/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/*global window, global*/
var util = __webpack_require__(3)
var assert = __webpack_require__(59)
function now() { return new Date().getTime() }

var slice = Array.prototype.slice
var console
var times = {}

if (typeof __webpack_require__.g !== "undefined" && __webpack_require__.g.console) {
    console = __webpack_require__.g.console
} else if (typeof window !== "undefined" && window.console) {
    console = window.console
} else {
    console = {}
}

var functions = [
    [log, "log"],
    [info, "info"],
    [warn, "warn"],
    [error, "error"],
    [time, "time"],
    [timeEnd, "timeEnd"],
    [trace, "trace"],
    [dir, "dir"],
    [consoleAssert, "assert"]
]

for (var i = 0; i < functions.length; i++) {
    var tuple = functions[i]
    var f = tuple[0]
    var name = tuple[1]

    if (!console[name]) {
        console[name] = f
    }
}

module.exports = console

function log() {}

function info() {
    console.log.apply(console, arguments)
}

function warn() {
    console.log.apply(console, arguments)
}

function error() {
    console.warn.apply(console, arguments)
}

function time(label) {
    times[label] = now()
}

function timeEnd(label) {
    var time = times[label]
    if (!time) {
        throw new Error("No such label: " + label)
    }

    delete times[label]
    var duration = now() - time
    console.log(label + ": " + duration + "ms")
}

function trace() {
    var err = new Error()
    err.name = "Trace"
    err.message = util.format.apply(null, arguments)
    console.error(err.stack)
}

function dir(object) {
    console.log(util.inspect(object) + "\n")
}

function consoleAssert(expression) {
    if (!expression) {
        var arr = slice.call(arguments, 1)
        assert.ok(false, util.format.apply(null, arr))
    }
}


/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(4);
/* provided dependency */ var console = __webpack_require__(2);
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors ||
  function getOwnPropertyDescriptors(obj) {
    var keys = Object.keys(obj);
    var descriptors = {};
    for (var i = 0; i < keys.length; i++) {
      descriptors[keys[i]] = Object.getOwnPropertyDescriptor(obj, keys[i]);
    }
    return descriptors;
  };

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  if (typeof process !== 'undefined' && process.noDeprecation === true) {
    return fn;
  }

  // Allow for deprecating things in the process of starting up.
  if (typeof process === 'undefined') {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnvRegex = /^$/;

if (process.env.NODE_DEBUG) {
  var debugEnv = process.env.NODE_DEBUG;
  debugEnv = debugEnv.replace(/[|\\{}()[\]^$+?.]/g, '\\$&')
    .replace(/\*/g, '.*')
    .replace(/,/g, '$|^')
    .toUpperCase();
  debugEnvRegex = new RegExp('^' + debugEnv + '$', 'i');
}
exports.debuglog = function(set) {
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (debugEnvRegex.test(set)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').slice(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.slice(1, -1);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
exports.types = __webpack_require__(5);

function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;
exports.types.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;
exports.types.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;
exports.types.isNativeError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = __webpack_require__(57);

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = __webpack_require__(58);

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

var kCustomPromisifiedSymbol = typeof Symbol !== 'undefined' ? Symbol('util.promisify.custom') : undefined;

exports.promisify = function promisify(original) {
  if (typeof original !== 'function')
    throw new TypeError('The "original" argument must be of type Function');

  if (kCustomPromisifiedSymbol && original[kCustomPromisifiedSymbol]) {
    var fn = original[kCustomPromisifiedSymbol];
    if (typeof fn !== 'function') {
      throw new TypeError('The "util.promisify.custom" argument must be of type Function');
    }
    Object.defineProperty(fn, kCustomPromisifiedSymbol, {
      value: fn, enumerable: false, writable: false, configurable: true
    });
    return fn;
  }

  function fn() {
    var promiseResolve, promiseReject;
    var promise = new Promise(function (resolve, reject) {
      promiseResolve = resolve;
      promiseReject = reject;
    });

    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }
    args.push(function (err, value) {
      if (err) {
        promiseReject(err);
      } else {
        promiseResolve(value);
      }
    });

    try {
      original.apply(this, args);
    } catch (err) {
      promiseReject(err);
    }

    return promise;
  }

  Object.setPrototypeOf(fn, Object.getPrototypeOf(original));

  if (kCustomPromisifiedSymbol) Object.defineProperty(fn, kCustomPromisifiedSymbol, {
    value: fn, enumerable: false, writable: false, configurable: true
  });
  return Object.defineProperties(
    fn,
    getOwnPropertyDescriptors(original)
  );
}

exports.promisify.custom = kCustomPromisifiedSymbol

function callbackifyOnRejected(reason, cb) {
  // `!reason` guard inspired by bluebird (Ref: https://goo.gl/t5IS6M).
  // Because `null` is a special error value in callbacks which means "no error
  // occurred", we error-wrap so the callback consumer can distinguish between
  // "the promise rejected with null" or "the promise fulfilled with undefined".
  if (!reason) {
    var newReason = new Error('Promise was rejected with a falsy value');
    newReason.reason = reason;
    reason = newReason;
  }
  return cb(reason);
}

function callbackify(original) {
  if (typeof original !== 'function') {
    throw new TypeError('The "original" argument must be of type Function');
  }

  // We DO NOT return the promise as it gives the user a false sense that
  // the promise is actually somehow related to the callback's execution
  // and that the callback throwing will reject the promise.
  function callbackified() {
    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }

    var maybeCb = args.pop();
    if (typeof maybeCb !== 'function') {
      throw new TypeError('The last argument must be of type Function');
    }
    var self = this;
    var cb = function() {
      return maybeCb.apply(self, arguments);
    };
    // In true node style we process the callback on `nextTick` with all the
    // implications (stack, `uncaughtException`, `async_hooks`)
    original.apply(this, args)
      .then(function(ret) { process.nextTick(cb.bind(null, null, ret)) },
            function(rej) { process.nextTick(callbackifyOnRejected.bind(null, rej, cb)) });
  }

  Object.setPrototypeOf(callbackified, Object.getPrototypeOf(original));
  Object.defineProperties(callbackified,
                          getOwnPropertyDescriptors(original));
  return callbackified;
}
exports.callbackify = callbackify;


/***/ }),
/* 4 */
/***/ ((module) => {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/util/types.js
// https://github.com/nodejs/node/commit/112cc7c27551254aa2b17098fb774867f05ed0d9



var isArgumentsObject = __webpack_require__(6);
var isGeneratorFunction = __webpack_require__(43);
var whichTypedArray = __webpack_require__(46);
var isTypedArray = __webpack_require__(56);

function uncurryThis(f) {
  return f.call.bind(f);
}

var BigIntSupported = typeof BigInt !== 'undefined';
var SymbolSupported = typeof Symbol !== 'undefined';

var ObjectToString = uncurryThis(Object.prototype.toString);

var numberValue = uncurryThis(Number.prototype.valueOf);
var stringValue = uncurryThis(String.prototype.valueOf);
var booleanValue = uncurryThis(Boolean.prototype.valueOf);

if (BigIntSupported) {
  var bigIntValue = uncurryThis(BigInt.prototype.valueOf);
}

if (SymbolSupported) {
  var symbolValue = uncurryThis(Symbol.prototype.valueOf);
}

function checkBoxedPrimitive(value, prototypeValueOf) {
  if (typeof value !== 'object') {
    return false;
  }
  try {
    prototypeValueOf(value);
    return true;
  } catch(e) {
    return false;
  }
}

exports.isArgumentsObject = isArgumentsObject;
exports.isGeneratorFunction = isGeneratorFunction;
exports.isTypedArray = isTypedArray;

// Taken from here and modified for better browser support
// https://github.com/sindresorhus/p-is-promise/blob/cda35a513bda03f977ad5cde3a079d237e82d7ef/index.js
function isPromise(input) {
	return (
		(
			typeof Promise !== 'undefined' &&
			input instanceof Promise
		) ||
		(
			input !== null &&
			typeof input === 'object' &&
			typeof input.then === 'function' &&
			typeof input.catch === 'function'
		)
	);
}
exports.isPromise = isPromise;

function isArrayBufferView(value) {
  if (typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView) {
    return ArrayBuffer.isView(value);
  }

  return (
    isTypedArray(value) ||
    isDataView(value)
  );
}
exports.isArrayBufferView = isArrayBufferView;


function isUint8Array(value) {
  return whichTypedArray(value) === 'Uint8Array';
}
exports.isUint8Array = isUint8Array;

function isUint8ClampedArray(value) {
  return whichTypedArray(value) === 'Uint8ClampedArray';
}
exports.isUint8ClampedArray = isUint8ClampedArray;

function isUint16Array(value) {
  return whichTypedArray(value) === 'Uint16Array';
}
exports.isUint16Array = isUint16Array;

function isUint32Array(value) {
  return whichTypedArray(value) === 'Uint32Array';
}
exports.isUint32Array = isUint32Array;

function isInt8Array(value) {
  return whichTypedArray(value) === 'Int8Array';
}
exports.isInt8Array = isInt8Array;

function isInt16Array(value) {
  return whichTypedArray(value) === 'Int16Array';
}
exports.isInt16Array = isInt16Array;

function isInt32Array(value) {
  return whichTypedArray(value) === 'Int32Array';
}
exports.isInt32Array = isInt32Array;

function isFloat32Array(value) {
  return whichTypedArray(value) === 'Float32Array';
}
exports.isFloat32Array = isFloat32Array;

function isFloat64Array(value) {
  return whichTypedArray(value) === 'Float64Array';
}
exports.isFloat64Array = isFloat64Array;

function isBigInt64Array(value) {
  return whichTypedArray(value) === 'BigInt64Array';
}
exports.isBigInt64Array = isBigInt64Array;

function isBigUint64Array(value) {
  return whichTypedArray(value) === 'BigUint64Array';
}
exports.isBigUint64Array = isBigUint64Array;

function isMapToString(value) {
  return ObjectToString(value) === '[object Map]';
}
isMapToString.working = (
  typeof Map !== 'undefined' &&
  isMapToString(new Map())
);

function isMap(value) {
  if (typeof Map === 'undefined') {
    return false;
  }

  return isMapToString.working
    ? isMapToString(value)
    : value instanceof Map;
}
exports.isMap = isMap;

function isSetToString(value) {
  return ObjectToString(value) === '[object Set]';
}
isSetToString.working = (
  typeof Set !== 'undefined' &&
  isSetToString(new Set())
);
function isSet(value) {
  if (typeof Set === 'undefined') {
    return false;
  }

  return isSetToString.working
    ? isSetToString(value)
    : value instanceof Set;
}
exports.isSet = isSet;

function isWeakMapToString(value) {
  return ObjectToString(value) === '[object WeakMap]';
}
isWeakMapToString.working = (
  typeof WeakMap !== 'undefined' &&
  isWeakMapToString(new WeakMap())
);
function isWeakMap(value) {
  if (typeof WeakMap === 'undefined') {
    return false;
  }

  return isWeakMapToString.working
    ? isWeakMapToString(value)
    : value instanceof WeakMap;
}
exports.isWeakMap = isWeakMap;

function isWeakSetToString(value) {
  return ObjectToString(value) === '[object WeakSet]';
}
isWeakSetToString.working = (
  typeof WeakSet !== 'undefined' &&
  isWeakSetToString(new WeakSet())
);
function isWeakSet(value) {
  return isWeakSetToString(value);
}
exports.isWeakSet = isWeakSet;

function isArrayBufferToString(value) {
  return ObjectToString(value) === '[object ArrayBuffer]';
}
isArrayBufferToString.working = (
  typeof ArrayBuffer !== 'undefined' &&
  isArrayBufferToString(new ArrayBuffer())
);
function isArrayBuffer(value) {
  if (typeof ArrayBuffer === 'undefined') {
    return false;
  }

  return isArrayBufferToString.working
    ? isArrayBufferToString(value)
    : value instanceof ArrayBuffer;
}
exports.isArrayBuffer = isArrayBuffer;

function isDataViewToString(value) {
  return ObjectToString(value) === '[object DataView]';
}
isDataViewToString.working = (
  typeof ArrayBuffer !== 'undefined' &&
  typeof DataView !== 'undefined' &&
  isDataViewToString(new DataView(new ArrayBuffer(1), 0, 1))
);
function isDataView(value) {
  if (typeof DataView === 'undefined') {
    return false;
  }

  return isDataViewToString.working
    ? isDataViewToString(value)
    : value instanceof DataView;
}
exports.isDataView = isDataView;

// Store a copy of SharedArrayBuffer in case it's deleted elsewhere
var SharedArrayBufferCopy = typeof SharedArrayBuffer !== 'undefined' ? SharedArrayBuffer : undefined;
function isSharedArrayBufferToString(value) {
  return ObjectToString(value) === '[object SharedArrayBuffer]';
}
function isSharedArrayBuffer(value) {
  if (typeof SharedArrayBufferCopy === 'undefined') {
    return false;
  }

  if (typeof isSharedArrayBufferToString.working === 'undefined') {
    isSharedArrayBufferToString.working = isSharedArrayBufferToString(new SharedArrayBufferCopy());
  }

  return isSharedArrayBufferToString.working
    ? isSharedArrayBufferToString(value)
    : value instanceof SharedArrayBufferCopy;
}
exports.isSharedArrayBuffer = isSharedArrayBuffer;

function isAsyncFunction(value) {
  return ObjectToString(value) === '[object AsyncFunction]';
}
exports.isAsyncFunction = isAsyncFunction;

function isMapIterator(value) {
  return ObjectToString(value) === '[object Map Iterator]';
}
exports.isMapIterator = isMapIterator;

function isSetIterator(value) {
  return ObjectToString(value) === '[object Set Iterator]';
}
exports.isSetIterator = isSetIterator;

function isGeneratorObject(value) {
  return ObjectToString(value) === '[object Generator]';
}
exports.isGeneratorObject = isGeneratorObject;

function isWebAssemblyCompiledModule(value) {
  return ObjectToString(value) === '[object WebAssembly.Module]';
}
exports.isWebAssemblyCompiledModule = isWebAssemblyCompiledModule;

function isNumberObject(value) {
  return checkBoxedPrimitive(value, numberValue);
}
exports.isNumberObject = isNumberObject;

function isStringObject(value) {
  return checkBoxedPrimitive(value, stringValue);
}
exports.isStringObject = isStringObject;

function isBooleanObject(value) {
  return checkBoxedPrimitive(value, booleanValue);
}
exports.isBooleanObject = isBooleanObject;

function isBigIntObject(value) {
  return BigIntSupported && checkBoxedPrimitive(value, bigIntValue);
}
exports.isBigIntObject = isBigIntObject;

function isSymbolObject(value) {
  return SymbolSupported && checkBoxedPrimitive(value, symbolValue);
}
exports.isSymbolObject = isSymbolObject;

function isBoxedPrimitive(value) {
  return (
    isNumberObject(value) ||
    isStringObject(value) ||
    isBooleanObject(value) ||
    isBigIntObject(value) ||
    isSymbolObject(value)
  );
}
exports.isBoxedPrimitive = isBoxedPrimitive;

function isAnyArrayBuffer(value) {
  return typeof Uint8Array !== 'undefined' && (
    isArrayBuffer(value) ||
    isSharedArrayBuffer(value)
  );
}
exports.isAnyArrayBuffer = isAnyArrayBuffer;

['isProxy', 'isExternal', 'isModuleNamespaceObject'].forEach(function(method) {
  Object.defineProperty(exports, method, {
    enumerable: false,
    value: function() {
      throw new Error(method + ' is not supported in userland');
    }
  });
});


/***/ }),
/* 6 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var hasToStringTag = __webpack_require__(7)();
var callBound = __webpack_require__(9);

var $toString = callBound('Object.prototype.toString');

/** @type {import('.')} */
var isStandardArguments = function isArguments(value) {
	if (
		hasToStringTag
		&& value
		&& typeof value === 'object'
		&& Symbol.toStringTag in value
	) {
		return false;
	}
	return $toString(value) === '[object Arguments]';
};

/** @type {import('.')} */
var isLegacyArguments = function isArguments(value) {
	if (isStandardArguments(value)) {
		return true;
	}
	return value !== null
		&& typeof value === 'object'
		&& 'length' in value
		&& typeof value.length === 'number'
		&& value.length >= 0
		&& $toString(value) !== '[object Array]'
		&& 'callee' in value
		&& $toString(value.callee) === '[object Function]';
};

var supportsStandardArguments = (function () {
	return isStandardArguments(arguments);
}());

// @ts-expect-error TODO make this not error
isStandardArguments.isLegacyArguments = isLegacyArguments; // for tests

/** @type {import('.')} */
module.exports = supportsStandardArguments ? isStandardArguments : isLegacyArguments;


/***/ }),
/* 7 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var hasSymbols = __webpack_require__(8);

/** @type {import('.')} */
module.exports = function hasToStringTagShams() {
	return hasSymbols() && !!Symbol.toStringTag;
};


/***/ }),
/* 8 */
/***/ ((module) => {

"use strict";


/** @type {import('./shams')} */
/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	/** @type {{ [k in symbol]?: unknown }} */
	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (var _ in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		// eslint-disable-next-line no-extra-parens
		var descriptor = /** @type {PropertyDescriptor} */ (Object.getOwnPropertyDescriptor(obj, sym));
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),
/* 9 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);

var callBindBasic = __webpack_require__(35);

/** @type {(thisArg: string, searchString: string, position?: number) => number} */
var $indexOf = callBindBasic([GetIntrinsic('%String.prototype.indexOf%')]);

/** @type {import('.')} */
module.exports = function callBoundIntrinsic(name, allowMissing) {
	// eslint-disable-next-line no-extra-parens
	var intrinsic = /** @type {Parameters<typeof callBindBasic>[0][0]} */ (GetIntrinsic(name, !!allowMissing));
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBindBasic([intrinsic]);
	}
	return intrinsic;
};


/***/ }),
/* 10 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var undefined;

var $Object = __webpack_require__(11);

var $Error = __webpack_require__(12);
var $EvalError = __webpack_require__(13);
var $RangeError = __webpack_require__(14);
var $ReferenceError = __webpack_require__(15);
var $SyntaxError = __webpack_require__(16);
var $TypeError = __webpack_require__(17);
var $URIError = __webpack_require__(18);

var abs = __webpack_require__(19);
var floor = __webpack_require__(20);
var max = __webpack_require__(21);
var min = __webpack_require__(22);
var pow = __webpack_require__(23);
var round = __webpack_require__(24);
var sign = __webpack_require__(25);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = __webpack_require__(27);
var $defineProperty = __webpack_require__(29);

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(30)();

var getProto = __webpack_require__(31);
var $ObjectGPO = __webpack_require__(33);
var $ReflectGPO = __webpack_require__(32);

var $apply = __webpack_require__(40);
var $call = __webpack_require__(38);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': $Object,
	'%Object.getOwnPropertyDescriptor%': $gOPD,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet,

	'%Function.prototype.call%': $call,
	'%Function.prototype.apply%': $apply,
	'%Object.defineProperty%': $defineProperty,
	'%Object.getPrototypeOf%': $ObjectGPO,
	'%Math.abs%': abs,
	'%Math.floor%': floor,
	'%Math.max%': max,
	'%Math.min%': min,
	'%Math.pow%': pow,
	'%Math.round%': round,
	'%Math.sign%': sign,
	'%Reflect.getPrototypeOf%': $ReflectGPO
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(36);
var hasOwn = __webpack_require__(42);
var $concat = bind.call($call, Array.prototype.concat);
var $spliceApply = bind.call($apply, Array.prototype.splice);
var $replace = bind.call($call, String.prototype.replace);
var $strSlice = bind.call($call, String.prototype.slice);
var $exec = bind.call($call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),
/* 11 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = Object;


/***/ }),
/* 12 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = Error;


/***/ }),
/* 13 */
/***/ ((module) => {

"use strict";


/** @type {import('./eval')} */
module.exports = EvalError;


/***/ }),
/* 14 */
/***/ ((module) => {

"use strict";


/** @type {import('./range')} */
module.exports = RangeError;


/***/ }),
/* 15 */
/***/ ((module) => {

"use strict";


/** @type {import('./ref')} */
module.exports = ReferenceError;


/***/ }),
/* 16 */
/***/ ((module) => {

"use strict";


/** @type {import('./syntax')} */
module.exports = SyntaxError;


/***/ }),
/* 17 */
/***/ ((module) => {

"use strict";


/** @type {import('./type')} */
module.exports = TypeError;


/***/ }),
/* 18 */
/***/ ((module) => {

"use strict";


/** @type {import('./uri')} */
module.exports = URIError;


/***/ }),
/* 19 */
/***/ ((module) => {

"use strict";


/** @type {import('./abs')} */
module.exports = Math.abs;


/***/ }),
/* 20 */
/***/ ((module) => {

"use strict";


/** @type {import('./floor')} */
module.exports = Math.floor;


/***/ }),
/* 21 */
/***/ ((module) => {

"use strict";


/** @type {import('./max')} */
module.exports = Math.max;


/***/ }),
/* 22 */
/***/ ((module) => {

"use strict";


/** @type {import('./min')} */
module.exports = Math.min;


/***/ }),
/* 23 */
/***/ ((module) => {

"use strict";


/** @type {import('./pow')} */
module.exports = Math.pow;


/***/ }),
/* 24 */
/***/ ((module) => {

"use strict";


/** @type {import('./round')} */
module.exports = Math.round;


/***/ }),
/* 25 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $isNaN = __webpack_require__(26);

/** @type {import('./sign')} */
module.exports = function sign(number) {
	if ($isNaN(number) || number === 0) {
		return number;
	}
	return number < 0 ? -1 : +1;
};


/***/ }),
/* 26 */
/***/ ((module) => {

"use strict";


/** @type {import('./isNaN')} */
module.exports = Number.isNaN || function isNaN(a) {
	return a !== a;
};


/***/ }),
/* 27 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


/** @type {import('.')} */
var $gOPD = __webpack_require__(28);

if ($gOPD) {
	try {
		$gOPD([], 'length');
	} catch (e) {
		// IE 8 has a broken gOPD
		$gOPD = null;
	}
}

module.exports = $gOPD;


/***/ }),
/* 28 */
/***/ ((module) => {

"use strict";


/** @type {import('./gOPD')} */
module.exports = Object.getOwnPropertyDescriptor;


/***/ }),
/* 29 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
var $defineProperty = Object.defineProperty || false;
if ($defineProperty) {
	try {
		$defineProperty({}, 'a', { value: 1 });
	} catch (e) {
		// IE 8 has a broken defineProperty
		$defineProperty = false;
	}
}

module.exports = $defineProperty;


/***/ }),
/* 30 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(8);

/** @type {import('.')} */
module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),
/* 31 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var reflectGetProto = __webpack_require__(32);
var originalGetProto = __webpack_require__(33);

var getDunderProto = __webpack_require__(34);

/** @type {import('.')} */
module.exports = reflectGetProto
	? function getProto(O) {
		// @ts-expect-error TS can't narrow inside a closure, for some reason
		return reflectGetProto(O);
	}
	: originalGetProto
		? function getProto(O) {
			if (!O || (typeof O !== 'object' && typeof O !== 'function')) {
				throw new TypeError('getProto: not an object');
			}
			// @ts-expect-error TS can't narrow inside a closure, for some reason
			return originalGetProto(O);
		}
		: getDunderProto
			? function getProto(O) {
				// @ts-expect-error TS can't narrow inside a closure, for some reason
				return getDunderProto(O);
			}
			: null;


/***/ }),
/* 32 */
/***/ ((module) => {

"use strict";


/** @type {import('./Reflect.getPrototypeOf')} */
module.exports = (typeof Reflect !== 'undefined' && Reflect.getPrototypeOf) || null;


/***/ }),
/* 33 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $Object = __webpack_require__(11);

/** @type {import('./Object.getPrototypeOf')} */
module.exports = $Object.getPrototypeOf || null;


/***/ }),
/* 34 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBind = __webpack_require__(35);
var gOPD = __webpack_require__(27);

var hasProtoAccessor;
try {
	// eslint-disable-next-line no-extra-parens, no-proto
	hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */ ([]).__proto__ === Array.prototype;
} catch (e) {
	if (!e || typeof e !== 'object' || !('code' in e) || e.code !== 'ERR_PROTO_ACCESS') {
		throw e;
	}
}

// eslint-disable-next-line no-extra-parens
var desc = !!hasProtoAccessor && gOPD && gOPD(Object.prototype, /** @type {keyof typeof Object.prototype} */ ('__proto__'));

var $Object = Object;
var $getPrototypeOf = $Object.getPrototypeOf;

/** @type {import('./get')} */
module.exports = desc && typeof desc.get === 'function'
	? callBind([desc.get])
	: typeof $getPrototypeOf === 'function'
		? /** @type {import('./get')} */ function getDunder(value) {
			// eslint-disable-next-line eqeqeq
			return $getPrototypeOf(value == null ? value : $Object(value));
		}
		: false;


/***/ }),
/* 35 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);
var $TypeError = __webpack_require__(17);

var $call = __webpack_require__(38);
var $actualApply = __webpack_require__(39);

/** @type {(args: [Function, thisArg?: unknown, ...args: unknown[]]) => Function} TODO FIXME, find a way to use import('.') */
module.exports = function callBindBasic(args) {
	if (args.length < 1 || typeof args[0] !== 'function') {
		throw new $TypeError('a function is required');
	}
	return $actualApply(bind, $call, args);
};


/***/ }),
/* 36 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(37);

module.exports = Function.prototype.bind || implementation;


/***/ }),
/* 37 */
/***/ ((module) => {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),
/* 38 */
/***/ ((module) => {

"use strict";


/** @type {import('./functionCall')} */
module.exports = Function.prototype.call;


/***/ }),
/* 39 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);

var $apply = __webpack_require__(40);
var $call = __webpack_require__(38);
var $reflectApply = __webpack_require__(41);

/** @type {import('./actualApply')} */
module.exports = $reflectApply || bind.call($call, $apply);


/***/ }),
/* 40 */
/***/ ((module) => {

"use strict";


/** @type {import('./functionApply')} */
module.exports = Function.prototype.apply;


/***/ }),
/* 41 */
/***/ ((module) => {

"use strict";


/** @type {import('./reflectApply')} */
module.exports = typeof Reflect !== 'undefined' && Reflect && Reflect.apply;


/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var call = Function.prototype.call;
var $hasOwn = Object.prototype.hasOwnProperty;
var bind = __webpack_require__(36);

/** @type {import('.')} */
module.exports = bind.call(call, $hasOwn);


/***/ }),
/* 43 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var safeRegexTest = __webpack_require__(44);
var isFnRegex = safeRegexTest(/^\s*(?:function)?\*/);
var hasToStringTag = __webpack_require__(7)();
var getProto = __webpack_require__(31);

var toStr = callBound('Object.prototype.toString');
var fnToStr = callBound('Function.prototype.toString');

var getGeneratorFunc = function () { // eslint-disable-line consistent-return
	if (!hasToStringTag) {
		return false;
	}
	try {
		return Function('return function*() {}')();
	} catch (e) {
	}
};
/** @type {undefined | false | null | GeneratorFunctionConstructor} */
var GeneratorFunction;

/** @type {import('.')} */
module.exports = function isGeneratorFunction(fn) {
	if (typeof fn !== 'function') {
		return false;
	}
	if (isFnRegex(fnToStr(fn))) {
		return true;
	}
	if (!hasToStringTag) {
		var str = toStr(fn);
		return str === '[object GeneratorFunction]';
	}
	if (!getProto) {
		return false;
	}
	if (typeof GeneratorFunction === 'undefined') {
		var generatorFunc = getGeneratorFunc();
		GeneratorFunction = generatorFunc
			// eslint-disable-next-line no-extra-parens
			? /** @type {GeneratorFunctionConstructor} */ (getProto(generatorFunc))
			: false;
	}
	return getProto(fn) === GeneratorFunction;
};


/***/ }),
/* 44 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var isRegex = __webpack_require__(45);

var $exec = callBound('RegExp.prototype.exec');
var $TypeError = __webpack_require__(17);

/** @type {import('.')} */
module.exports = function regexTester(regex) {
	if (!isRegex(regex)) {
		throw new $TypeError('`regex` must be a RegExp');
	}
	return function test(s) {
		return $exec(regex, s) !== null;
	};
};


/***/ }),
/* 45 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var hasToStringTag = __webpack_require__(7)();
var hasOwn = __webpack_require__(42);
var gOPD = __webpack_require__(27);

/** @type {import('.')} */
var fn;

if (hasToStringTag) {
	/** @type {(receiver: ThisParameterType<typeof RegExp.prototype.exec>, ...args: Parameters<typeof RegExp.prototype.exec>) => ReturnType<typeof RegExp.prototype.exec>} */
	var $exec = callBound('RegExp.prototype.exec');
	/** @type {object} */
	var isRegexMarker = {};

	var throwRegexMarker = function () {
		throw isRegexMarker;
	};
	/** @type {{ toString(): never, valueOf(): never, [Symbol.toPrimitive]?(): never }} */
	var badStringifier = {
		toString: throwRegexMarker,
		valueOf: throwRegexMarker
	};

	if (typeof Symbol.toPrimitive === 'symbol') {
		badStringifier[Symbol.toPrimitive] = throwRegexMarker;
	}

	/** @type {import('.')} */
	// @ts-expect-error TS can't figure out that the $exec call always throws
	// eslint-disable-next-line consistent-return
	fn = function isRegex(value) {
		if (!value || typeof value !== 'object') {
			return false;
		}

		// eslint-disable-next-line no-extra-parens
		var descriptor = /** @type {NonNullable<typeof gOPD>} */ (gOPD)(/** @type {{ lastIndex?: unknown }} */ (value), 'lastIndex');
		var hasLastIndexDataProperty = descriptor && hasOwn(descriptor, 'value');
		if (!hasLastIndexDataProperty) {
			return false;
		}

		try {
			// eslint-disable-next-line no-extra-parens
			$exec(value, /** @type {string} */ (/** @type {unknown} */ (badStringifier)));
		} catch (e) {
			return e === isRegexMarker;
		}
	};
} else {
	/** @type {(receiver: ThisParameterType<typeof Object.prototype.toString>, ...args: Parameters<typeof Object.prototype.toString>) => ReturnType<typeof Object.prototype.toString>} */
	var $toString = callBound('Object.prototype.toString');
	/** @const @type {'[object RegExp]'} */
	var regexClass = '[object RegExp]';

	/** @type {import('.')} */
	fn = function isRegex(value) {
		// In older browsers, typeof regex incorrectly returns 'function'
		if (!value || (typeof value !== 'object' && typeof value !== 'function')) {
			return false;
		}

		return $toString(value) === regexClass;
	};
}

module.exports = fn;


/***/ }),
/* 46 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var forEach = __webpack_require__(47);
var availableTypedArrays = __webpack_require__(49);
var callBind = __webpack_require__(51);
var callBound = __webpack_require__(9);
var gOPD = __webpack_require__(27);

/** @type {(O: object) => string} */
var $toString = callBound('Object.prototype.toString');
var hasToStringTag = __webpack_require__(7)();

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;
var typedArrays = availableTypedArrays();

var $slice = callBound('String.prototype.slice');
var getPrototypeOf = Object.getPrototypeOf; // require('getprototypeof');

/** @type {<T = unknown>(array: readonly T[], value: unknown) => number} */
var $indexOf = callBound('Array.prototype.indexOf', true) || function indexOf(array, value) {
	for (var i = 0; i < array.length; i += 1) {
		if (array[i] === value) {
			return i;
		}
	}
	return -1;
};

/** @typedef {(receiver: import('.').TypedArray) => string | typeof Uint8Array.prototype.slice.call | typeof Uint8Array.prototype.set.call} Getter */
/** @type {{ [k in `\$${import('.').TypedArrayName}`]?: Getter } & { __proto__: null }} */
var cache = { __proto__: null };
if (hasToStringTag && gOPD && getPrototypeOf) {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		if (Symbol.toStringTag in arr) {
			var proto = getPrototypeOf(arr);
			// @ts-expect-error TS won't narrow inside a closure
			var descriptor = gOPD(proto, Symbol.toStringTag);
			if (!descriptor) {
				var superProto = getPrototypeOf(proto);
				// @ts-expect-error TS won't narrow inside a closure
				descriptor = gOPD(superProto, Symbol.toStringTag);
			}
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(descriptor.get);
		}
	});
} else {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		var fn = arr.slice || arr.set;
		if (fn) {
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(fn);
		}
	});
}

/** @type {(value: object) => false | import('.').TypedArrayName} */
var tryTypedArrays = function tryAllTypedArrays(value) {
	/** @type {ReturnType<typeof tryAllTypedArrays>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
		function (getter, typedArray) {
			if (!found) {
				try {
				// @ts-expect-error TODO: fix
					if ('$' + getter(value) === typedArray) {
						found = $slice(typedArray, 1);
					}
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {(value: object) => false | import('.').TypedArrayName} */
var trySlices = function tryAllSlices(value) {
	/** @type {ReturnType<typeof tryAllSlices>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: typeof cache, name: `\$${import('.').TypedArrayName}`) => void} */ function (getter, name) {
			if (!found) {
				try {
					// @ts-expect-error TODO: fix
					getter(value);
					found = $slice(name, 1);
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {import('.')} */
module.exports = function whichTypedArray(value) {
	if (!value || typeof value !== 'object') { return false; }
	if (!hasToStringTag) {
		/** @type {string} */
		var tag = $slice($toString(value), 8, -1);
		if ($indexOf(typedArrays, tag) > -1) {
			return tag;
		}
		if (tag !== 'Object') {
			return false;
		}
		// node < 0.6 hits here on real Typed Arrays
		return trySlices(value);
	}
	if (!gOPD) { return null; } // unknown engine
	return tryTypedArrays(value);
};


/***/ }),
/* 47 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isCallable = __webpack_require__(48);

var toStr = Object.prototype.toString;
var hasOwnProperty = Object.prototype.hasOwnProperty;

/** @type {<This, A extends readonly unknown[]>(arr: A, iterator: (this: This | void, value: A[number], index: number, arr: A) => void, receiver: This | undefined) => void} */
var forEachArray = function forEachArray(array, iterator, receiver) {
    for (var i = 0, len = array.length; i < len; i++) {
        if (hasOwnProperty.call(array, i)) {
            if (receiver == null) {
                iterator(array[i], i, array);
            } else {
                iterator.call(receiver, array[i], i, array);
            }
        }
    }
};

/** @type {<This, S extends string>(string: S, iterator: (this: This | void, value: S[number], index: number, string: S) => void, receiver: This | undefined) => void} */
var forEachString = function forEachString(string, iterator, receiver) {
    for (var i = 0, len = string.length; i < len; i++) {
        // no such thing as a sparse string.
        if (receiver == null) {
            iterator(string.charAt(i), i, string);
        } else {
            iterator.call(receiver, string.charAt(i), i, string);
        }
    }
};

/** @type {<This, O>(obj: O, iterator: (this: This | void, value: O[keyof O], index: keyof O, obj: O) => void, receiver: This | undefined) => void} */
var forEachObject = function forEachObject(object, iterator, receiver) {
    for (var k in object) {
        if (hasOwnProperty.call(object, k)) {
            if (receiver == null) {
                iterator(object[k], k, object);
            } else {
                iterator.call(receiver, object[k], k, object);
            }
        }
    }
};

/** @type {(x: unknown) => x is readonly unknown[]} */
function isArray(x) {
    return toStr.call(x) === '[object Array]';
}

/** @type {import('.')._internal} */
module.exports = function forEach(list, iterator, thisArg) {
    if (!isCallable(iterator)) {
        throw new TypeError('iterator must be a function');
    }

    var receiver;
    if (arguments.length >= 3) {
        receiver = thisArg;
    }

    if (isArray(list)) {
        forEachArray(list, iterator, receiver);
    } else if (typeof list === 'string') {
        forEachString(list, iterator, receiver);
    } else {
        forEachObject(list, iterator, receiver);
    }
};


/***/ }),
/* 48 */
/***/ ((module) => {

"use strict";


var fnToStr = Function.prototype.toString;
var reflectApply = typeof Reflect === 'object' && Reflect !== null && Reflect.apply;
var badArrayLike;
var isCallableMarker;
if (typeof reflectApply === 'function' && typeof Object.defineProperty === 'function') {
	try {
		badArrayLike = Object.defineProperty({}, 'length', {
			get: function () {
				throw isCallableMarker;
			}
		});
		isCallableMarker = {};
		// eslint-disable-next-line no-throw-literal
		reflectApply(function () { throw 42; }, null, badArrayLike);
	} catch (_) {
		if (_ !== isCallableMarker) {
			reflectApply = null;
		}
	}
} else {
	reflectApply = null;
}

var constructorRegex = /^\s*class\b/;
var isES6ClassFn = function isES6ClassFunction(value) {
	try {
		var fnStr = fnToStr.call(value);
		return constructorRegex.test(fnStr);
	} catch (e) {
		return false; // not a function
	}
};

var tryFunctionObject = function tryFunctionToStr(value) {
	try {
		if (isES6ClassFn(value)) { return false; }
		fnToStr.call(value);
		return true;
	} catch (e) {
		return false;
	}
};
var toStr = Object.prototype.toString;
var objectClass = '[object Object]';
var fnClass = '[object Function]';
var genClass = '[object GeneratorFunction]';
var ddaClass = '[object HTMLAllCollection]'; // IE 11
var ddaClass2 = '[object HTML document.all class]';
var ddaClass3 = '[object HTMLCollection]'; // IE 9-10
var hasToStringTag = typeof Symbol === 'function' && !!Symbol.toStringTag; // better: use `has-tostringtag`

var isIE68 = !(0 in [,]); // eslint-disable-line no-sparse-arrays, comma-spacing

var isDDA = function isDocumentDotAll() { return false; };
if (typeof document === 'object') {
	// Firefox 3 canonicalizes DDA to undefined when it's not accessed directly
	var all = document.all;
	if (toStr.call(all) === toStr.call(document.all)) {
		isDDA = function isDocumentDotAll(value) {
			/* globals document: false */
			// in IE 6-8, typeof document.all is "object" and it's truthy
			if ((isIE68 || !value) && (typeof value === 'undefined' || typeof value === 'object')) {
				try {
					var str = toStr.call(value);
					return (
						str === ddaClass
						|| str === ddaClass2
						|| str === ddaClass3 // opera 12.16
						|| str === objectClass // IE 6-8
					) && value('') == null; // eslint-disable-line eqeqeq
				} catch (e) { /**/ }
			}
			return false;
		};
	}
}

module.exports = reflectApply
	? function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		try {
			reflectApply(value, null, badArrayLike);
		} catch (e) {
			if (e !== isCallableMarker) { return false; }
		}
		return !isES6ClassFn(value) && tryFunctionObject(value);
	}
	: function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (hasToStringTag) { return tryFunctionObject(value); }
		if (isES6ClassFn(value)) { return false; }
		var strClass = toStr.call(value);
		if (strClass !== fnClass && strClass !== genClass && !(/^\[object HTML/).test(strClass)) { return false; }
		return tryFunctionObject(value);
	};


/***/ }),
/* 49 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var possibleNames = __webpack_require__(50);

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;

/** @type {import('.')} */
module.exports = function availableTypedArrays() {
	var /** @type {ReturnType<typeof availableTypedArrays>} */ out = [];
	for (var i = 0; i < possibleNames.length; i++) {
		if (typeof g[possibleNames[i]] === 'function') {
			// @ts-expect-error
			out[out.length] = possibleNames[i];
		}
	}
	return out;
};


/***/ }),
/* 50 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = [
	'Float16Array',
	'Float32Array',
	'Float64Array',
	'Int8Array',
	'Int16Array',
	'Int32Array',
	'Uint8Array',
	'Uint8ClampedArray',
	'Uint16Array',
	'Uint32Array',
	'BigInt64Array',
	'BigUint64Array'
];


/***/ }),
/* 51 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var setFunctionLength = __webpack_require__(52);

var $defineProperty = __webpack_require__(29);

var callBindBasic = __webpack_require__(35);
var applyBind = __webpack_require__(55);

module.exports = function callBind(originalFunction) {
	var func = callBindBasic(arguments);
	var adjustedLength = originalFunction.length - (arguments.length - 1);
	return setFunctionLength(
		func,
		1 + (adjustedLength > 0 ? adjustedLength : 0),
		true
	);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),
/* 52 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);
var define = __webpack_require__(53);
var hasDescriptors = __webpack_require__(54)();
var gOPD = __webpack_require__(27);

var $TypeError = __webpack_require__(17);
var $floor = GetIntrinsic('%Math.floor%');

/** @type {import('.')} */
module.exports = function setFunctionLength(fn, length) {
	if (typeof fn !== 'function') {
		throw new $TypeError('`fn` is not a function');
	}
	if (typeof length !== 'number' || length < 0 || length > 0xFFFFFFFF || $floor(length) !== length) {
		throw new $TypeError('`length` must be a positive 32-bit integer');
	}

	var loose = arguments.length > 2 && !!arguments[2];

	var functionLengthIsConfigurable = true;
	var functionLengthIsWritable = true;
	if ('length' in fn && gOPD) {
		var desc = gOPD(fn, 'length');
		if (desc && !desc.configurable) {
			functionLengthIsConfigurable = false;
		}
		if (desc && !desc.writable) {
			functionLengthIsWritable = false;
		}
	}

	if (functionLengthIsConfigurable || functionLengthIsWritable || !loose) {
		if (hasDescriptors) {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length, true, true);
		} else {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length);
		}
	}
	return fn;
};


/***/ }),
/* 53 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $defineProperty = __webpack_require__(29);

var $SyntaxError = __webpack_require__(16);
var $TypeError = __webpack_require__(17);

var gopd = __webpack_require__(27);

/** @type {import('.')} */
module.exports = function defineDataProperty(
	obj,
	property,
	value
) {
	if (!obj || (typeof obj !== 'object' && typeof obj !== 'function')) {
		throw new $TypeError('`obj` must be an object or a function`');
	}
	if (typeof property !== 'string' && typeof property !== 'symbol') {
		throw new $TypeError('`property` must be a string or a symbol`');
	}
	if (arguments.length > 3 && typeof arguments[3] !== 'boolean' && arguments[3] !== null) {
		throw new $TypeError('`nonEnumerable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 4 && typeof arguments[4] !== 'boolean' && arguments[4] !== null) {
		throw new $TypeError('`nonWritable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 5 && typeof arguments[5] !== 'boolean' && arguments[5] !== null) {
		throw new $TypeError('`nonConfigurable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 6 && typeof arguments[6] !== 'boolean') {
		throw new $TypeError('`loose`, if provided, must be a boolean');
	}

	var nonEnumerable = arguments.length > 3 ? arguments[3] : null;
	var nonWritable = arguments.length > 4 ? arguments[4] : null;
	var nonConfigurable = arguments.length > 5 ? arguments[5] : null;
	var loose = arguments.length > 6 ? arguments[6] : false;

	/* @type {false | TypedPropertyDescriptor<unknown>} */
	var desc = !!gopd && gopd(obj, property);

	if ($defineProperty) {
		$defineProperty(obj, property, {
			configurable: nonConfigurable === null && desc ? desc.configurable : !nonConfigurable,
			enumerable: nonEnumerable === null && desc ? desc.enumerable : !nonEnumerable,
			value: value,
			writable: nonWritable === null && desc ? desc.writable : !nonWritable
		});
	} else if (loose || (!nonEnumerable && !nonWritable && !nonConfigurable)) {
		// must fall back to [[Set]], and was not explicitly asked to make non-enumerable, non-writable, or non-configurable
		obj[property] = value; // eslint-disable-line no-param-reassign
	} else {
		throw new $SyntaxError('This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.');
	}
};


/***/ }),
/* 54 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $defineProperty = __webpack_require__(29);

var hasPropertyDescriptors = function hasPropertyDescriptors() {
	return !!$defineProperty;
};

hasPropertyDescriptors.hasArrayLengthDefineBug = function hasArrayLengthDefineBug() {
	// node v0.6 has a bug where array lengths can be Set but not Defined
	if (!$defineProperty) {
		return null;
	}
	try {
		return $defineProperty([], 'length', { value: 1 }).length !== 1;
	} catch (e) {
		// In Firefox 4-22, defining length on an array throws an exception.
		return true;
	}
};

module.exports = hasPropertyDescriptors;


/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);
var $apply = __webpack_require__(40);
var actualApply = __webpack_require__(39);

/** @type {import('./applyBind')} */
module.exports = function applyBind() {
	return actualApply(bind, $apply, arguments);
};


/***/ }),
/* 56 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var whichTypedArray = __webpack_require__(46);

/** @type {import('.')} */
module.exports = function isTypedArray(value) {
	return !!whichTypedArray(value);
};


/***/ }),
/* 57 */
/***/ ((module) => {

module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}

/***/ }),
/* 58 */
/***/ ((module) => {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),
/* 59 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(4);
/* provided dependency */ var console = __webpack_require__(2);
// Currently in sync with Node.js lib/assert.js
// https://github.com/nodejs/node/commit/2a51ae424a513ec9a6aa3466baa0cc1d55dd4f3b

// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.



function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
var _require = __webpack_require__(60),
  _require$codes = _require.codes,
  ERR_AMBIGUOUS_ARGUMENT = _require$codes.ERR_AMBIGUOUS_ARGUMENT,
  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
  ERR_INVALID_ARG_VALUE = _require$codes.ERR_INVALID_ARG_VALUE,
  ERR_INVALID_RETURN_VALUE = _require$codes.ERR_INVALID_RETURN_VALUE,
  ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS;
var AssertionError = __webpack_require__(61);
var _require2 = __webpack_require__(3),
  inspect = _require2.inspect;
var _require$types = (__webpack_require__(3).types),
  isPromise = _require$types.isPromise,
  isRegExp = _require$types.isRegExp;
var objectAssign = __webpack_require__(62)();
var objectIs = __webpack_require__(67)();
var RegExpPrototypeTest = __webpack_require__(69)('RegExp.prototype.test');
var errorCache = new Map();
var isDeepEqual;
var isDeepStrictEqual;
var parseExpressionAt;
var findNodeAround;
var decoder;
function lazyLoadComparison() {
  var comparison = __webpack_require__(70);
  isDeepEqual = comparison.isDeepEqual;
  isDeepStrictEqual = comparison.isDeepStrictEqual;
}

// Escape control characters but not \n and \t to keep the line breaks and
// indentation intact.
// eslint-disable-next-line no-control-regex
var escapeSequencesRegExp = /[\x00-\x08\x0b\x0c\x0e-\x1f]/g;
var meta = ["\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", '\\b', '', '', "\\u000b", '\\f', '', "\\u000e", "\\u000f", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001a", "\\u001b", "\\u001c", "\\u001d", "\\u001e", "\\u001f"];
var escapeFn = function escapeFn(str) {
  return meta[str.charCodeAt(0)];
};
var warned = false;

// The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;
var NO_EXCEPTION_SENTINEL = {};

// All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided. All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function innerFail(obj) {
  if (obj.message instanceof Error) throw obj.message;
  throw new AssertionError(obj);
}
function fail(actual, expected, message, operator, stackStartFn) {
  var argsLen = arguments.length;
  var internalMessage;
  if (argsLen === 0) {
    internalMessage = 'Failed';
  } else if (argsLen === 1) {
    message = actual;
    actual = undefined;
  } else {
    if (warned === false) {
      warned = true;
      var warn = process.emitWarning ? process.emitWarning : console.warn.bind(console);
      warn('assert.fail() with more than one argument is deprecated. ' + 'Please use assert.strictEqual() instead or only pass a message.', 'DeprecationWarning', 'DEP0094');
    }
    if (argsLen === 2) operator = '!=';
  }
  if (message instanceof Error) throw message;
  var errArgs = {
    actual: actual,
    expected: expected,
    operator: operator === undefined ? 'fail' : operator,
    stackStartFn: stackStartFn || fail
  };
  if (message !== undefined) {
    errArgs.message = message;
  }
  var err = new AssertionError(errArgs);
  if (internalMessage) {
    err.message = internalMessage;
    err.generatedMessage = true;
  }
  throw err;
}
assert.fail = fail;

// The AssertionError is defined in internal/error.
assert.AssertionError = AssertionError;
function innerOk(fn, argLen, value, message) {
  if (!value) {
    var generatedMessage = false;
    if (argLen === 0) {
      generatedMessage = true;
      message = 'No value argument passed to `assert.ok()`';
    } else if (message instanceof Error) {
      throw message;
    }
    var err = new AssertionError({
      actual: value,
      expected: true,
      message: message,
      operator: '==',
      stackStartFn: fn
    });
    err.generatedMessage = generatedMessage;
    throw err;
  }
}

// Pure assertion tests whether a value is truthy, as determined
// by !!value.
function ok() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  innerOk.apply(void 0, [ok, args.length].concat(args));
}
assert.ok = ok;

// The equality assertion tests shallow, coercive equality with ==.
/* eslint-disable no-restricted-properties */
assert.equal = function equal(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  // eslint-disable-next-line eqeqeq
  if (actual != expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '==',
      stackStartFn: equal
    });
  }
};

// The non-equality assertion tests for whether two objects are not
// equal with !=.
assert.notEqual = function notEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  // eslint-disable-next-line eqeqeq
  if (actual == expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '!=',
      stackStartFn: notEqual
    });
  }
};

// The equivalence assertion tests a deep equality relation.
assert.deepEqual = function deepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (!isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepEqual',
      stackStartFn: deepEqual
    });
  }
};

// The non-equivalence assertion tests for any deep inequality.
assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepEqual',
      stackStartFn: notDeepEqual
    });
  }
};
/* eslint-enable */

assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (!isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepStrictEqual',
      stackStartFn: deepStrictEqual
    });
  }
};
assert.notDeepStrictEqual = notDeepStrictEqual;
function notDeepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepStrictEqual',
      stackStartFn: notDeepStrictEqual
    });
  }
}
assert.strictEqual = function strictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (!objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'strictEqual',
      stackStartFn: strictEqual
    });
  }
};
assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notStrictEqual',
      stackStartFn: notStrictEqual
    });
  }
};
var Comparison = /*#__PURE__*/_createClass(function Comparison(obj, keys, actual) {
  var _this = this;
  _classCallCheck(this, Comparison);
  keys.forEach(function (key) {
    if (key in obj) {
      if (actual !== undefined && typeof actual[key] === 'string' && isRegExp(obj[key]) && RegExpPrototypeTest(obj[key], actual[key])) {
        _this[key] = actual[key];
      } else {
        _this[key] = obj[key];
      }
    }
  });
});
function compareExceptionKey(actual, expected, key, message, keys, fn) {
  if (!(key in actual) || !isDeepStrictEqual(actual[key], expected[key])) {
    if (!message) {
      // Create placeholder objects to create a nice output.
      var a = new Comparison(actual, keys);
      var b = new Comparison(expected, keys, actual);
      var err = new AssertionError({
        actual: a,
        expected: b,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.actual = actual;
      err.expected = expected;
      err.operator = fn.name;
      throw err;
    }
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: fn.name,
      stackStartFn: fn
    });
  }
}
function expectedException(actual, expected, msg, fn) {
  if (typeof expected !== 'function') {
    if (isRegExp(expected)) return RegExpPrototypeTest(expected, actual);
    // assert.doesNotThrow does not accept objects.
    if (arguments.length === 2) {
      throw new ERR_INVALID_ARG_TYPE('expected', ['Function', 'RegExp'], expected);
    }

    // Handle primitives properly.
    if (_typeof(actual) !== 'object' || actual === null) {
      var err = new AssertionError({
        actual: actual,
        expected: expected,
        message: msg,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.operator = fn.name;
      throw err;
    }
    var keys = Object.keys(expected);
    // Special handle errors to make sure the name and the message are compared
    // as well.
    if (expected instanceof Error) {
      keys.push('name', 'message');
    } else if (keys.length === 0) {
      throw new ERR_INVALID_ARG_VALUE('error', expected, 'may not be an empty object');
    }
    if (isDeepEqual === undefined) lazyLoadComparison();
    keys.forEach(function (key) {
      if (typeof actual[key] === 'string' && isRegExp(expected[key]) && RegExpPrototypeTest(expected[key], actual[key])) {
        return;
      }
      compareExceptionKey(actual, expected, key, msg, keys, fn);
    });
    return true;
  }
  // Guard instanceof against arrow functions as they don't have a prototype.
  if (expected.prototype !== undefined && actual instanceof expected) {
    return true;
  }
  if (Error.isPrototypeOf(expected)) {
    return false;
  }
  return expected.call({}, actual) === true;
}
function getActual(fn) {
  if (typeof fn !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('fn', 'Function', fn);
  }
  try {
    fn();
  } catch (e) {
    return e;
  }
  return NO_EXCEPTION_SENTINEL;
}
function checkIsPromise(obj) {
  // Accept native ES6 promises and promises that are implemented in a similar
  // way. Do not accept thenables that use a function as `obj` and that have no
  // `catch` handler.

  // TODO: thenables are checked up until they have the correct methods,
  // but according to documentation, the `then` method should receive
  // the `fulfill` and `reject` arguments as well or it may be never resolved.

  return isPromise(obj) || obj !== null && _typeof(obj) === 'object' && typeof obj.then === 'function' && typeof obj.catch === 'function';
}
function waitForActual(promiseFn) {
  return Promise.resolve().then(function () {
    var resultPromise;
    if (typeof promiseFn === 'function') {
      // Return a rejected promise if `promiseFn` throws synchronously.
      resultPromise = promiseFn();
      // Fail in case no promise is returned.
      if (!checkIsPromise(resultPromise)) {
        throw new ERR_INVALID_RETURN_VALUE('instance of Promise', 'promiseFn', resultPromise);
      }
    } else if (checkIsPromise(promiseFn)) {
      resultPromise = promiseFn;
    } else {
      throw new ERR_INVALID_ARG_TYPE('promiseFn', ['Function', 'Promise'], promiseFn);
    }
    return Promise.resolve().then(function () {
      return resultPromise;
    }).then(function () {
      return NO_EXCEPTION_SENTINEL;
    }).catch(function (e) {
      return e;
    });
  });
}
function expectsError(stackStartFn, actual, error, message) {
  if (typeof error === 'string') {
    if (arguments.length === 4) {
      throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
    }
    if (_typeof(actual) === 'object' && actual !== null) {
      if (actual.message === error) {
        throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error message \"".concat(actual.message, "\" is identical to the message."));
      }
    } else if (actual === error) {
      throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error \"".concat(actual, "\" is identical to the message."));
    }
    message = error;
    error = undefined;
  } else if (error != null && _typeof(error) !== 'object' && typeof error !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
  }
  if (actual === NO_EXCEPTION_SENTINEL) {
    var details = '';
    if (error && error.name) {
      details += " (".concat(error.name, ")");
    }
    details += message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'rejects' ? 'rejection' : 'exception';
    innerFail({
      actual: undefined,
      expected: error,
      operator: stackStartFn.name,
      message: "Missing expected ".concat(fnType).concat(details),
      stackStartFn: stackStartFn
    });
  }
  if (error && !expectedException(actual, error, message, stackStartFn)) {
    throw actual;
  }
}
function expectsNoError(stackStartFn, actual, error, message) {
  if (actual === NO_EXCEPTION_SENTINEL) return;
  if (typeof error === 'string') {
    message = error;
    error = undefined;
  }
  if (!error || expectedException(actual, error)) {
    var details = message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'doesNotReject' ? 'rejection' : 'exception';
    innerFail({
      actual: actual,
      expected: error,
      operator: stackStartFn.name,
      message: "Got unwanted ".concat(fnType).concat(details, "\n") + "Actual message: \"".concat(actual && actual.message, "\""),
      stackStartFn: stackStartFn
    });
  }
  throw actual;
}
assert.throws = function throws(promiseFn) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }
  expectsError.apply(void 0, [throws, getActual(promiseFn)].concat(args));
};
assert.rejects = function rejects(promiseFn) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }
  return waitForActual(promiseFn).then(function (result) {
    return expectsError.apply(void 0, [rejects, result].concat(args));
  });
};
assert.doesNotThrow = function doesNotThrow(fn) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }
  expectsNoError.apply(void 0, [doesNotThrow, getActual(fn)].concat(args));
};
assert.doesNotReject = function doesNotReject(fn) {
  for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
    args[_key5 - 1] = arguments[_key5];
  }
  return waitForActual(fn).then(function (result) {
    return expectsNoError.apply(void 0, [doesNotReject, result].concat(args));
  });
};
assert.ifError = function ifError(err) {
  if (err !== null && err !== undefined) {
    var message = 'ifError got unwanted exception: ';
    if (_typeof(err) === 'object' && typeof err.message === 'string') {
      if (err.message.length === 0 && err.constructor) {
        message += err.constructor.name;
      } else {
        message += err.message;
      }
    } else {
      message += inspect(err);
    }
    var newErr = new AssertionError({
      actual: err,
      expected: null,
      operator: 'ifError',
      message: message,
      stackStartFn: ifError
    });

    // Make sure we actually have a stack trace!
    var origStack = err.stack;
    if (typeof origStack === 'string') {
      // This will remove any duplicated frames from the error frames taken
      // from within `ifError` and add the original error frames to the newly
      // created ones.
      var tmp2 = origStack.split('\n');
      tmp2.shift();
      // Filter all frames existing in err.stack.
      var tmp1 = newErr.stack.split('\n');
      for (var i = 0; i < tmp2.length; i++) {
        // Find the first occurrence of the frame.
        var pos = tmp1.indexOf(tmp2[i]);
        if (pos !== -1) {
          // Only keep new frames.
          tmp1 = tmp1.slice(0, pos);
          break;
        }
      }
      newErr.stack = "".concat(tmp1.join('\n'), "\n").concat(tmp2.join('\n'));
    }
    throw newErr;
  }
};

// Currently in sync with Node.js lib/assert.js
// https://github.com/nodejs/node/commit/2a871df3dfb8ea663ef5e1f8f62701ec51384ecb
function internalMatch(string, regexp, message, fn, fnName) {
  if (!isRegExp(regexp)) {
    throw new ERR_INVALID_ARG_TYPE('regexp', 'RegExp', regexp);
  }
  var match = fnName === 'match';
  if (typeof string !== 'string' || RegExpPrototypeTest(regexp, string) !== match) {
    if (message instanceof Error) {
      throw message;
    }
    var generatedMessage = !message;

    // 'The input was expected to not match the regular expression ' +
    message = message || (typeof string !== 'string' ? 'The "string" argument must be of type string. Received type ' + "".concat(_typeof(string), " (").concat(inspect(string), ")") : (match ? 'The input did not match the regular expression ' : 'The input was expected to not match the regular expression ') + "".concat(inspect(regexp), ". Input:\n\n").concat(inspect(string), "\n"));
    var err = new AssertionError({
      actual: string,
      expected: regexp,
      message: message,
      operator: fnName,
      stackStartFn: fn
    });
    err.generatedMessage = generatedMessage;
    throw err;
  }
}
assert.match = function match(string, regexp, message) {
  internalMatch(string, regexp, message, match, 'match');
};
assert.doesNotMatch = function doesNotMatch(string, regexp, message) {
  internalMatch(string, regexp, message, doesNotMatch, 'doesNotMatch');
};

// Expose a strict only variant of assert
function strict() {
  for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
    args[_key6] = arguments[_key6];
  }
  innerOk.apply(void 0, [strict, args.length].concat(args));
}
assert.strict = objectAssign(strict, assert, {
  equal: assert.strictEqual,
  deepEqual: assert.deepStrictEqual,
  notEqual: assert.notStrictEqual,
  notDeepEqual: assert.notDeepStrictEqual
});
assert.strict.strict = assert.strict;

/***/ }),
/* 60 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/errors.js
// https://github.com/nodejs/node/commit/3b044962c48fe313905877a96b5d0894a5404f6f

/* eslint node-core/documented-errors: "error" */
/* eslint node-core/alphabetize-errors: "error" */
/* eslint node-core/prefer-util-format-errors: "error" */



// The whole point behind this internal module is to allow Node.js to no
// longer be forced to treat every error message change as a semver-major
// change. The NodeError classes here all expose a `code` property whose
// value statically and permanently identifies the error. While the error
// message may change, the code should not.
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var codes = {};

// Lazy loaded
var assert;
var util;
function createErrorType(code, message, Base) {
  if (!Base) {
    Base = Error;
  }
  function getMessage(arg1, arg2, arg3) {
    if (typeof message === 'string') {
      return message;
    } else {
      return message(arg1, arg2, arg3);
    }
  }
  var NodeError = /*#__PURE__*/function (_Base) {
    _inherits(NodeError, _Base);
    var _super = _createSuper(NodeError);
    function NodeError(arg1, arg2, arg3) {
      var _this;
      _classCallCheck(this, NodeError);
      _this = _super.call(this, getMessage(arg1, arg2, arg3));
      _this.code = code;
      return _this;
    }
    return _createClass(NodeError);
  }(Base);
  codes[code] = NodeError;
}

// https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js
function oneOf(expected, thing) {
  if (Array.isArray(expected)) {
    var len = expected.length;
    expected = expected.map(function (i) {
      return String(i);
    });
    if (len > 2) {
      return "one of ".concat(thing, " ").concat(expected.slice(0, len - 1).join(', '), ", or ") + expected[len - 1];
    } else if (len === 2) {
      return "one of ".concat(thing, " ").concat(expected[0], " or ").concat(expected[1]);
    } else {
      return "of ".concat(thing, " ").concat(expected[0]);
    }
  } else {
    return "of ".concat(thing, " ").concat(String(expected));
  }
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith
function startsWith(str, search, pos) {
  return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith
function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }
  return str.substring(this_len - search.length, this_len) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes
function includes(str, search, start) {
  if (typeof start !== 'number') {
    start = 0;
  }
  if (start + search.length > str.length) {
    return false;
  } else {
    return str.indexOf(search, start) !== -1;
  }
}
createErrorType('ERR_AMBIGUOUS_ARGUMENT', 'The "%s" argument is ambiguous. %s', TypeError);
createErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {
  if (assert === undefined) assert = __webpack_require__(59);
  assert(typeof name === 'string', "'name' must be a string");

  // determiner: 'must be' or 'must not be'
  var determiner;
  if (typeof expected === 'string' && startsWith(expected, 'not ')) {
    determiner = 'must not be';
    expected = expected.replace(/^not /, '');
  } else {
    determiner = 'must be';
  }
  var msg;
  if (endsWith(name, ' argument')) {
    // For cases like 'first argument'
    msg = "The ".concat(name, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  } else {
    var type = includes(name, '.') ? 'property' : 'argument';
    msg = "The \"".concat(name, "\" ").concat(type, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  }

  // TODO(BridgeAR): Improve the output by showing `null` and similar.
  msg += ". Received type ".concat(_typeof(actual));
  return msg;
}, TypeError);
createErrorType('ERR_INVALID_ARG_VALUE', function (name, value) {
  var reason = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'is invalid';
  if (util === undefined) util = __webpack_require__(3);
  var inspected = util.inspect(value);
  if (inspected.length > 128) {
    inspected = "".concat(inspected.slice(0, 128), "...");
  }
  return "The argument '".concat(name, "' ").concat(reason, ". Received ").concat(inspected);
}, TypeError, RangeError);
createErrorType('ERR_INVALID_RETURN_VALUE', function (input, name, value) {
  var type;
  if (value && value.constructor && value.constructor.name) {
    type = "instance of ".concat(value.constructor.name);
  } else {
    type = "type ".concat(_typeof(value));
  }
  return "Expected ".concat(input, " to be returned from the \"").concat(name, "\"") + " function but got ".concat(type, ".");
}, TypeError);
createErrorType('ERR_MISSING_ARGS', function () {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  if (assert === undefined) assert = __webpack_require__(59);
  assert(args.length > 0, 'At least one arg needs to be specified');
  var msg = 'The ';
  var len = args.length;
  args = args.map(function (a) {
    return "\"".concat(a, "\"");
  });
  switch (len) {
    case 1:
      msg += "".concat(args[0], " argument");
      break;
    case 2:
      msg += "".concat(args[0], " and ").concat(args[1], " arguments");
      break;
    default:
      msg += args.slice(0, len - 1).join(', ');
      msg += ", and ".concat(args[len - 1], " arguments");
      break;
  }
  return "".concat(msg, " must be specified");
}, TypeError);
module.exports.codes = codes;

/***/ }),
/* 61 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(4);
// Currently in sync with Node.js lib/internal/assert/assertion_error.js
// https://github.com/nodejs/node/commit/0817840f775032169ddd70c85ac059f18ffcc81c



function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }
function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _require = __webpack_require__(3),
  inspect = _require.inspect;
var _require2 = __webpack_require__(60),
  ERR_INVALID_ARG_TYPE = _require2.codes.ERR_INVALID_ARG_TYPE;

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith
function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }
  return str.substring(this_len - search.length, this_len) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat
function repeat(str, count) {
  count = Math.floor(count);
  if (str.length == 0 || count == 0) return '';
  var maxCount = str.length * count;
  count = Math.floor(Math.log(count) / Math.log(2));
  while (count) {
    str += str;
    count--;
  }
  str += str.substring(0, maxCount - str.length);
  return str;
}
var blue = '';
var green = '';
var red = '';
var white = '';
var kReadableOperator = {
  deepStrictEqual: 'Expected values to be strictly deep-equal:',
  strictEqual: 'Expected values to be strictly equal:',
  strictEqualObject: 'Expected "actual" to be reference-equal to "expected":',
  deepEqual: 'Expected values to be loosely deep-equal:',
  equal: 'Expected values to be loosely equal:',
  notDeepStrictEqual: 'Expected "actual" not to be strictly deep-equal to:',
  notStrictEqual: 'Expected "actual" to be strictly unequal to:',
  notStrictEqualObject: 'Expected "actual" not to be reference-equal to "expected":',
  notDeepEqual: 'Expected "actual" not to be loosely deep-equal to:',
  notEqual: 'Expected "actual" to be loosely unequal to:',
  notIdentical: 'Values identical but not reference-equal:'
};

// Comparing short primitives should just show === / !== instead of using the
// diff.
var kMaxShortLength = 10;
function copyError(source) {
  var keys = Object.keys(source);
  var target = Object.create(Object.getPrototypeOf(source));
  keys.forEach(function (key) {
    target[key] = source[key];
  });
  Object.defineProperty(target, 'message', {
    value: source.message
  });
  return target;
}
function inspectValue(val) {
  // The util.inspect default values could be changed. This makes sure the
  // error messages contain the necessary information nevertheless.
  return inspect(val, {
    compact: false,
    customInspect: false,
    depth: 1000,
    maxArrayLength: Infinity,
    // Assert compares only enumerable properties (with a few exceptions).
    showHidden: false,
    // Having a long line as error is better than wrapping the line for
    // comparison for now.
    // TODO(BridgeAR): `breakLength` should be limited as soon as soon as we
    // have meta information about the inspected properties (i.e., know where
    // in what line the property starts and ends).
    breakLength: Infinity,
    // Assert does not detect proxies currently.
    showProxy: false,
    sorted: true,
    // Inspect getters as we also check them when comparing entries.
    getters: true
  });
}
function createErrDiff(actual, expected, operator) {
  var other = '';
  var res = '';
  var lastPos = 0;
  var end = '';
  var skipped = false;
  var actualInspected = inspectValue(actual);
  var actualLines = actualInspected.split('\n');
  var expectedLines = inspectValue(expected).split('\n');
  var i = 0;
  var indicator = '';

  // In case both values are objects explicitly mark them as not reference equal
  // for the `strictEqual` operator.
  if (operator === 'strictEqual' && _typeof(actual) === 'object' && _typeof(expected) === 'object' && actual !== null && expected !== null) {
    operator = 'strictEqualObject';
  }

  // If "actual" and "expected" fit on a single line and they are not strictly
  // equal, check further special handling.
  if (actualLines.length === 1 && expectedLines.length === 1 && actualLines[0] !== expectedLines[0]) {
    var inputLength = actualLines[0].length + expectedLines[0].length;
    // If the character length of "actual" and "expected" together is less than
    // kMaxShortLength and if neither is an object and at least one of them is
    // not `zero`, use the strict equal comparison to visualize the output.
    if (inputLength <= kMaxShortLength) {
      if ((_typeof(actual) !== 'object' || actual === null) && (_typeof(expected) !== 'object' || expected === null) && (actual !== 0 || expected !== 0)) {
        // -0 === +0
        return "".concat(kReadableOperator[operator], "\n\n") + "".concat(actualLines[0], " !== ").concat(expectedLines[0], "\n");
      }
    } else if (operator !== 'strictEqualObject') {
      // If the stderr is a tty and the input length is lower than the current
      // columns per line, add a mismatch indicator below the output. If it is
      // not a tty, use a default value of 80 characters.
      var maxLength = process.stderr && process.stderr.isTTY ? process.stderr.columns : 80;
      if (inputLength < maxLength) {
        while (actualLines[0][i] === expectedLines[0][i]) {
          i++;
        }
        // Ignore the first characters.
        if (i > 2) {
          // Add position indicator for the first mismatch in case it is a
          // single line and the input length is less than the column length.
          indicator = "\n  ".concat(repeat(' ', i), "^");
          i = 0;
        }
      }
    }
  }

  // Remove all ending lines that match (this optimizes the output for
  // readability by reducing the number of total changed lines).
  var a = actualLines[actualLines.length - 1];
  var b = expectedLines[expectedLines.length - 1];
  while (a === b) {
    if (i++ < 2) {
      end = "\n  ".concat(a).concat(end);
    } else {
      other = a;
    }
    actualLines.pop();
    expectedLines.pop();
    if (actualLines.length === 0 || expectedLines.length === 0) break;
    a = actualLines[actualLines.length - 1];
    b = expectedLines[expectedLines.length - 1];
  }
  var maxLines = Math.max(actualLines.length, expectedLines.length);
  // Strict equal with identical objects that are not identical by reference.
  // E.g., assert.deepStrictEqual({ a: Symbol() }, { a: Symbol() })
  if (maxLines === 0) {
    // We have to get the result again. The lines were all removed before.
    var _actualLines = actualInspected.split('\n');

    // Only remove lines in case it makes sense to collapse those.
    // TODO: Accept env to always show the full error.
    if (_actualLines.length > 30) {
      _actualLines[26] = "".concat(blue, "...").concat(white);
      while (_actualLines.length > 27) {
        _actualLines.pop();
      }
    }
    return "".concat(kReadableOperator.notIdentical, "\n\n").concat(_actualLines.join('\n'), "\n");
  }
  if (i > 3) {
    end = "\n".concat(blue, "...").concat(white).concat(end);
    skipped = true;
  }
  if (other !== '') {
    end = "\n  ".concat(other).concat(end);
    other = '';
  }
  var printedLines = 0;
  var msg = kReadableOperator[operator] + "\n".concat(green, "+ actual").concat(white, " ").concat(red, "- expected").concat(white);
  var skippedMsg = " ".concat(blue, "...").concat(white, " Lines skipped");
  for (i = 0; i < maxLines; i++) {
    // Only extra expected lines exist
    var cur = i - lastPos;
    if (actualLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(expectedLines[i - 2]);
          printedLines++;
        }
        res += "\n  ".concat(expectedLines[i - 1]);
        printedLines++;
      }
      // Mark the current line as the last diverging one.
      lastPos = i;
      // Add the expected line to the cache.
      other += "\n".concat(red, "-").concat(white, " ").concat(expectedLines[i]);
      printedLines++;
      // Only extra actual lines exist
    } else if (expectedLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(actualLines[i - 2]);
          printedLines++;
        }
        res += "\n  ".concat(actualLines[i - 1]);
        printedLines++;
      }
      // Mark the current line as the last diverging one.
      lastPos = i;
      // Add the actual line to the result.
      res += "\n".concat(green, "+").concat(white, " ").concat(actualLines[i]);
      printedLines++;
      // Lines diverge
    } else {
      var expectedLine = expectedLines[i];
      var actualLine = actualLines[i];
      // If the lines diverge, specifically check for lines that only diverge by
      // a trailing comma. In that case it is actually identical and we should
      // mark it as such.
      var divergingLines = actualLine !== expectedLine && (!endsWith(actualLine, ',') || actualLine.slice(0, -1) !== expectedLine);
      // If the expected line has a trailing comma but is otherwise identical,
      // add a comma at the end of the actual line. Otherwise the output could
      // look weird as in:
      //
      //   [
      //     1         // No comma at the end!
      // +   2
      //   ]
      //
      if (divergingLines && endsWith(expectedLine, ',') && expectedLine.slice(0, -1) === actualLine) {
        divergingLines = false;
        actualLine += ',';
      }
      if (divergingLines) {
        // If the last diverging line is more than one line above and the
        // current line is at least line three, add some of the former lines and
        // also add dots to indicate skipped entries.
        if (cur > 1 && i > 2) {
          if (cur > 4) {
            res += "\n".concat(blue, "...").concat(white);
            skipped = true;
          } else if (cur > 3) {
            res += "\n  ".concat(actualLines[i - 2]);
            printedLines++;
          }
          res += "\n  ".concat(actualLines[i - 1]);
          printedLines++;
        }
        // Mark the current line as the last diverging one.
        lastPos = i;
        // Add the actual line to the result and cache the expected diverging
        // line so consecutive diverging lines show up as +++--- and not +-+-+-.
        res += "\n".concat(green, "+").concat(white, " ").concat(actualLine);
        other += "\n".concat(red, "-").concat(white, " ").concat(expectedLine);
        printedLines += 2;
        // Lines are identical
      } else {
        // Add all cached information to the result before adding other things
        // and reset the cache.
        res += other;
        other = '';
        // If the last diverging line is exactly one line above or if it is the
        // very first line, add the line to the result.
        if (cur === 1 || i === 0) {
          res += "\n  ".concat(actualLine);
          printedLines++;
        }
      }
    }
    // Inspected object to big (Show ~20 rows max)
    if (printedLines > 20 && i < maxLines - 2) {
      return "".concat(msg).concat(skippedMsg, "\n").concat(res, "\n").concat(blue, "...").concat(white).concat(other, "\n") + "".concat(blue, "...").concat(white);
    }
  }
  return "".concat(msg).concat(skipped ? skippedMsg : '', "\n").concat(res).concat(other).concat(end).concat(indicator);
}
var AssertionError = /*#__PURE__*/function (_Error, _inspect$custom) {
  _inherits(AssertionError, _Error);
  var _super = _createSuper(AssertionError);
  function AssertionError(options) {
    var _this;
    _classCallCheck(this, AssertionError);
    if (_typeof(options) !== 'object' || options === null) {
      throw new ERR_INVALID_ARG_TYPE('options', 'Object', options);
    }
    var message = options.message,
      operator = options.operator,
      stackStartFn = options.stackStartFn;
    var actual = options.actual,
      expected = options.expected;
    var limit = Error.stackTraceLimit;
    Error.stackTraceLimit = 0;
    if (message != null) {
      _this = _super.call(this, String(message));
    } else {
      if (process.stderr && process.stderr.isTTY) {
        // Reset on each call to make sure we handle dynamically set environment
        // variables correct.
        if (process.stderr && process.stderr.getColorDepth && process.stderr.getColorDepth() !== 1) {
          blue = "\x1B[34m";
          green = "\x1B[32m";
          white = "\x1B[39m";
          red = "\x1B[31m";
        } else {
          blue = '';
          green = '';
          white = '';
          red = '';
        }
      }
      // Prevent the error stack from being visible by duplicating the error
      // in a very close way to the original in case both sides are actually
      // instances of Error.
      if (_typeof(actual) === 'object' && actual !== null && _typeof(expected) === 'object' && expected !== null && 'stack' in actual && actual instanceof Error && 'stack' in expected && expected instanceof Error) {
        actual = copyError(actual);
        expected = copyError(expected);
      }
      if (operator === 'deepStrictEqual' || operator === 'strictEqual') {
        _this = _super.call(this, createErrDiff(actual, expected, operator));
      } else if (operator === 'notDeepStrictEqual' || operator === 'notStrictEqual') {
        // In case the objects are equal but the operator requires unequal, show
        // the first object and say A equals B
        var base = kReadableOperator[operator];
        var res = inspectValue(actual).split('\n');

        // In case "actual" is an object, it should not be reference equal.
        if (operator === 'notStrictEqual' && _typeof(actual) === 'object' && actual !== null) {
          base = kReadableOperator.notStrictEqualObject;
        }

        // Only remove lines in case it makes sense to collapse those.
        // TODO: Accept env to always show the full error.
        if (res.length > 30) {
          res[26] = "".concat(blue, "...").concat(white);
          while (res.length > 27) {
            res.pop();
          }
        }

        // Only print a single input.
        if (res.length === 1) {
          _this = _super.call(this, "".concat(base, " ").concat(res[0]));
        } else {
          _this = _super.call(this, "".concat(base, "\n\n").concat(res.join('\n'), "\n"));
        }
      } else {
        var _res = inspectValue(actual);
        var other = '';
        var knownOperators = kReadableOperator[operator];
        if (operator === 'notDeepEqual' || operator === 'notEqual') {
          _res = "".concat(kReadableOperator[operator], "\n\n").concat(_res);
          if (_res.length > 1024) {
            _res = "".concat(_res.slice(0, 1021), "...");
          }
        } else {
          other = "".concat(inspectValue(expected));
          if (_res.length > 512) {
            _res = "".concat(_res.slice(0, 509), "...");
          }
          if (other.length > 512) {
            other = "".concat(other.slice(0, 509), "...");
          }
          if (operator === 'deepEqual' || operator === 'equal') {
            _res = "".concat(knownOperators, "\n\n").concat(_res, "\n\nshould equal\n\n");
          } else {
            other = " ".concat(operator, " ").concat(other);
          }
        }
        _this = _super.call(this, "".concat(_res).concat(other));
      }
    }
    Error.stackTraceLimit = limit;
    _this.generatedMessage = !message;
    Object.defineProperty(_assertThisInitialized(_this), 'name', {
      value: 'AssertionError [ERR_ASSERTION]',
      enumerable: false,
      writable: true,
      configurable: true
    });
    _this.code = 'ERR_ASSERTION';
    _this.actual = actual;
    _this.expected = expected;
    _this.operator = operator;
    if (Error.captureStackTrace) {
      // eslint-disable-next-line no-restricted-syntax
      Error.captureStackTrace(_assertThisInitialized(_this), stackStartFn);
    }
    // Create error message including the error code in the name.
    _this.stack;
    // Reset the name.
    _this.name = 'AssertionError';
    return _possibleConstructorReturn(_this);
  }
  _createClass(AssertionError, [{
    key: "toString",
    value: function toString() {
      return "".concat(this.name, " [").concat(this.code, "]: ").concat(this.message);
    }
  }, {
    key: _inspect$custom,
    value: function value(recurseTimes, ctx) {
      // This limits the `actual` and `expected` property default inspection to
      // the minimum depth. Otherwise those values would be too verbose compared
      // to the actual error message which contains a combined view of these two
      // input values.
      return inspect(this, _objectSpread(_objectSpread({}, ctx), {}, {
        customInspect: false,
        depth: 0
      }));
    }
  }]);
  return AssertionError;
}( /*#__PURE__*/_wrapNativeSuper(Error), inspect.custom);
module.exports = AssertionError;

/***/ }),
/* 62 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(63);

var lacksProperEnumerationOrder = function () {
	if (!Object.assign) {
		return false;
	}
	/*
	 * v8, specifically in node 4.x, has a bug with incorrect property enumeration order
	 * note: this does not detect the bug unless there's 20 characters
	 */
	var str = 'abcdefghijklmnopqrst';
	var letters = str.split('');
	var map = {};
	for (var i = 0; i < letters.length; ++i) {
		map[letters[i]] = letters[i];
	}
	var obj = Object.assign({}, map);
	var actual = '';
	for (var k in obj) {
		actual += k;
	}
	return str !== actual;
};

var assignHasPendingExceptions = function () {
	if (!Object.assign || !Object.preventExtensions) {
		return false;
	}
	/*
	 * Firefox 37 still has "pending exception" logic in its Object.assign implementation,
	 * which is 72% slower than our shim, and Firefox 40's native implementation.
	 */
	var thrower = Object.preventExtensions({ 1: 2 });
	try {
		Object.assign(thrower, 'xy');
	} catch (e) {
		return thrower[1] === 'y';
	}
	return false;
};

module.exports = function getPolyfill() {
	if (!Object.assign) {
		return implementation;
	}
	if (lacksProperEnumerationOrder()) {
		return implementation;
	}
	if (assignHasPendingExceptions()) {
		return implementation;
	}
	return Object.assign;
};


/***/ }),
/* 63 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// modified from https://github.com/es-shims/es6-shim
var objectKeys = __webpack_require__(64);
var hasSymbols = __webpack_require__(8)();
var callBound = __webpack_require__(9);
var $Object = __webpack_require__(11);
var $push = callBound('Array.prototype.push');
var $propIsEnumerable = callBound('Object.prototype.propertyIsEnumerable');
var originalGetSymbols = hasSymbols ? $Object.getOwnPropertySymbols : null;

// eslint-disable-next-line no-unused-vars
module.exports = function assign(target, source1) {
	if (target == null) { throw new TypeError('target must be an object'); }
	var to = $Object(target); // step 1
	if (arguments.length === 1) {
		return to; // step 2
	}
	for (var s = 1; s < arguments.length; ++s) {
		var from = $Object(arguments[s]); // step 3.a.i

		// step 3.a.ii:
		var keys = objectKeys(from);
		var getSymbols = hasSymbols && ($Object.getOwnPropertySymbols || originalGetSymbols);
		if (getSymbols) {
			var syms = getSymbols(from);
			for (var j = 0; j < syms.length; ++j) {
				var key = syms[j];
				if ($propIsEnumerable(from, key)) {
					$push(keys, key);
				}
			}
		}

		// step 3.a.iii:
		for (var i = 0; i < keys.length; ++i) {
			var nextKey = keys[i];
			if ($propIsEnumerable(from, nextKey)) { // step 3.a.iii.2
				var propValue = from[nextKey]; // step 3.a.iii.2.a
				to[nextKey] = propValue; // step 3.a.iii.2.b
			}
		}
	}

	return to; // step 4
};


/***/ }),
/* 64 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var slice = Array.prototype.slice;
var isArgs = __webpack_require__(65);

var origKeys = Object.keys;
var keysShim = origKeys ? function keys(o) { return origKeys(o); } : __webpack_require__(66);

var originalKeys = Object.keys;

keysShim.shim = function shimObjectKeys() {
	if (Object.keys) {
		var keysWorksWithArguments = (function () {
			// Safari 5.0 bug
			var args = Object.keys(arguments);
			return args && args.length === arguments.length;
		}(1, 2));
		if (!keysWorksWithArguments) {
			Object.keys = function keys(object) { // eslint-disable-line func-name-matching
				if (isArgs(object)) {
					return originalKeys(slice.call(object));
				}
				return originalKeys(object);
			};
		}
	} else {
		Object.keys = keysShim;
	}
	return Object.keys || keysShim;
};

module.exports = keysShim;


/***/ }),
/* 65 */
/***/ ((module) => {

"use strict";


var toStr = Object.prototype.toString;

module.exports = function isArguments(value) {
	var str = toStr.call(value);
	var isArgs = str === '[object Arguments]';
	if (!isArgs) {
		isArgs = str !== '[object Array]' &&
			value !== null &&
			typeof value === 'object' &&
			typeof value.length === 'number' &&
			value.length >= 0 &&
			toStr.call(value.callee) === '[object Function]';
	}
	return isArgs;
};


/***/ }),
/* 66 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var keysShim;
if (!Object.keys) {
	// modified from https://github.com/es-shims/es5-shim
	var has = Object.prototype.hasOwnProperty;
	var toStr = Object.prototype.toString;
	var isArgs = __webpack_require__(65); // eslint-disable-line global-require
	var isEnumerable = Object.prototype.propertyIsEnumerable;
	var hasDontEnumBug = !isEnumerable.call({ toString: null }, 'toString');
	var hasProtoEnumBug = isEnumerable.call(function () {}, 'prototype');
	var dontEnums = [
		'toString',
		'toLocaleString',
		'valueOf',
		'hasOwnProperty',
		'isPrototypeOf',
		'propertyIsEnumerable',
		'constructor'
	];
	var equalsConstructorPrototype = function (o) {
		var ctor = o.constructor;
		return ctor && ctor.prototype === o;
	};
	var excludedKeys = {
		$applicationCache: true,
		$console: true,
		$external: true,
		$frame: true,
		$frameElement: true,
		$frames: true,
		$innerHeight: true,
		$innerWidth: true,
		$onmozfullscreenchange: true,
		$onmozfullscreenerror: true,
		$outerHeight: true,
		$outerWidth: true,
		$pageXOffset: true,
		$pageYOffset: true,
		$parent: true,
		$scrollLeft: true,
		$scrollTop: true,
		$scrollX: true,
		$scrollY: true,
		$self: true,
		$webkitIndexedDB: true,
		$webkitStorageInfo: true,
		$window: true
	};
	var hasAutomationEqualityBug = (function () {
		/* global window */
		if (typeof window === 'undefined') { return false; }
		for (var k in window) {
			try {
				if (!excludedKeys['$' + k] && has.call(window, k) && window[k] !== null && typeof window[k] === 'object') {
					try {
						equalsConstructorPrototype(window[k]);
					} catch (e) {
						return true;
					}
				}
			} catch (e) {
				return true;
			}
		}
		return false;
	}());
	var equalsConstructorPrototypeIfNotBuggy = function (o) {
		/* global window */
		if (typeof window === 'undefined' || !hasAutomationEqualityBug) {
			return equalsConstructorPrototype(o);
		}
		try {
			return equalsConstructorPrototype(o);
		} catch (e) {
			return false;
		}
	};

	keysShim = function keys(object) {
		var isObject = object !== null && typeof object === 'object';
		var isFunction = toStr.call(object) === '[object Function]';
		var isArguments = isArgs(object);
		var isString = isObject && toStr.call(object) === '[object String]';
		var theKeys = [];

		if (!isObject && !isFunction && !isArguments) {
			throw new TypeError('Object.keys called on a non-object');
		}

		var skipProto = hasProtoEnumBug && isFunction;
		if (isString && object.length > 0 && !has.call(object, 0)) {
			for (var i = 0; i < object.length; ++i) {
				theKeys.push(String(i));
			}
		}

		if (isArguments && object.length > 0) {
			for (var j = 0; j < object.length; ++j) {
				theKeys.push(String(j));
			}
		} else {
			for (var name in object) {
				if (!(skipProto && name === 'prototype') && has.call(object, name)) {
					theKeys.push(String(name));
				}
			}
		}

		if (hasDontEnumBug) {
			var skipConstructor = equalsConstructorPrototypeIfNotBuggy(object);

			for (var k = 0; k < dontEnums.length; ++k) {
				if (!(skipConstructor && dontEnums[k] === 'constructor') && has.call(object, dontEnums[k])) {
					theKeys.push(dontEnums[k]);
				}
			}
		}
		return theKeys;
	};
}
module.exports = keysShim;


/***/ }),
/* 67 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(68);

module.exports = function getPolyfill() {
	return typeof Object.is === 'function' ? Object.is : implementation;
};


/***/ }),
/* 68 */
/***/ ((module) => {

"use strict";


var numberIsNaN = function (value) {
	return value !== value;
};

module.exports = function is(a, b) {
	if (a === 0 && b === 0) {
		return 1 / a === 1 / b;
	}
	if (a === b) {
		return true;
	}
	if (numberIsNaN(a) && numberIsNaN(b)) {
		return true;
	}
	return false;
};



/***/ }),
/* 69 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);

var callBind = __webpack_require__(51);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),
/* 70 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/util/comparisons.js
// https://github.com/nodejs/node/commit/112cc7c27551254aa2b17098fb774867f05ed0d9



function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var regexFlagsSupported = /a/g.flags !== undefined;
var arrayFromSet = function arrayFromSet(set) {
  var array = [];
  set.forEach(function (value) {
    return array.push(value);
  });
  return array;
};
var arrayFromMap = function arrayFromMap(map) {
  var array = [];
  map.forEach(function (value, key) {
    return array.push([key, value]);
  });
  return array;
};
var objectIs = Object.is ? Object.is : __webpack_require__(71);
var objectGetOwnPropertySymbols = Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols : function () {
  return [];
};
var numberIsNaN = Number.isNaN ? Number.isNaN : __webpack_require__(74);
function uncurryThis(f) {
  return f.call.bind(f);
}
var hasOwnProperty = uncurryThis(Object.prototype.hasOwnProperty);
var propertyIsEnumerable = uncurryThis(Object.prototype.propertyIsEnumerable);
var objectToString = uncurryThis(Object.prototype.toString);
var _require$types = (__webpack_require__(3).types),
  isAnyArrayBuffer = _require$types.isAnyArrayBuffer,
  isArrayBufferView = _require$types.isArrayBufferView,
  isDate = _require$types.isDate,
  isMap = _require$types.isMap,
  isRegExp = _require$types.isRegExp,
  isSet = _require$types.isSet,
  isNativeError = _require$types.isNativeError,
  isBoxedPrimitive = _require$types.isBoxedPrimitive,
  isNumberObject = _require$types.isNumberObject,
  isStringObject = _require$types.isStringObject,
  isBooleanObject = _require$types.isBooleanObject,
  isBigIntObject = _require$types.isBigIntObject,
  isSymbolObject = _require$types.isSymbolObject,
  isFloat32Array = _require$types.isFloat32Array,
  isFloat64Array = _require$types.isFloat64Array;
function isNonIndex(key) {
  if (key.length === 0 || key.length > 10) return true;
  for (var i = 0; i < key.length; i++) {
    var code = key.charCodeAt(i);
    if (code < 48 || code > 57) return true;
  }
  // The maximum size for an array is 2 ** 32 -1.
  return key.length === 10 && key >= Math.pow(2, 32);
}
function getOwnNonIndexProperties(value) {
  return Object.keys(value).filter(isNonIndex).concat(objectGetOwnPropertySymbols(value).filter(Object.prototype.propertyIsEnumerable.bind(value)));
}

// Taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
function compare(a, b) {
  if (a === b) {
    return 0;
  }
  var x = a.length;
  var y = b.length;
  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }
  if (x < y) {
    return -1;
  }
  if (y < x) {
    return 1;
  }
  return 0;
}
var ONLY_ENUMERABLE = undefined;
var kStrict = true;
var kLoose = false;
var kNoIterator = 0;
var kIsArray = 1;
var kIsSet = 2;
var kIsMap = 3;

// Check if they have the same source and flags
function areSimilarRegExps(a, b) {
  return regexFlagsSupported ? a.source === b.source && a.flags === b.flags : RegExp.prototype.toString.call(a) === RegExp.prototype.toString.call(b);
}
function areSimilarFloatArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }
  for (var offset = 0; offset < a.byteLength; offset++) {
    if (a[offset] !== b[offset]) {
      return false;
    }
  }
  return true;
}
function areSimilarTypedArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }
  return compare(new Uint8Array(a.buffer, a.byteOffset, a.byteLength), new Uint8Array(b.buffer, b.byteOffset, b.byteLength)) === 0;
}
function areEqualArrayBuffers(buf1, buf2) {
  return buf1.byteLength === buf2.byteLength && compare(new Uint8Array(buf1), new Uint8Array(buf2)) === 0;
}
function isEqualBoxedPrimitive(val1, val2) {
  if (isNumberObject(val1)) {
    return isNumberObject(val2) && objectIs(Number.prototype.valueOf.call(val1), Number.prototype.valueOf.call(val2));
  }
  if (isStringObject(val1)) {
    return isStringObject(val2) && String.prototype.valueOf.call(val1) === String.prototype.valueOf.call(val2);
  }
  if (isBooleanObject(val1)) {
    return isBooleanObject(val2) && Boolean.prototype.valueOf.call(val1) === Boolean.prototype.valueOf.call(val2);
  }
  if (isBigIntObject(val1)) {
    return isBigIntObject(val2) && BigInt.prototype.valueOf.call(val1) === BigInt.prototype.valueOf.call(val2);
  }
  return isSymbolObject(val2) && Symbol.prototype.valueOf.call(val1) === Symbol.prototype.valueOf.call(val2);
}

// Notes: Type tags are historical [[Class]] properties that can be set by
// FunctionTemplate::SetClassName() in C++ or Symbol.toStringTag in JS
// and retrieved using Object.prototype.toString.call(obj) in JS
// See https://tc39.github.io/ecma262/#sec-object.prototype.tostring
// for a list of tags pre-defined in the spec.
// There are some unspecified tags in the wild too (e.g. typed array tags).
// Since tags can be altered, they only serve fast failures
//
// Typed arrays and buffers are checked by comparing the content in their
// underlying ArrayBuffer. This optimization requires that it's
// reasonable to interpret their underlying memory in the same way,
// which is checked by comparing their type tags.
// (e.g. a Uint8Array and a Uint16Array with the same memory content
// could still be different because they will be interpreted differently).
//
// For strict comparison, objects should have
// a) The same built-in type tags
// b) The same prototypes.

function innerDeepEqual(val1, val2, strict, memos) {
  // All identical values are equivalent, as determined by ===.
  if (val1 === val2) {
    if (val1 !== 0) return true;
    return strict ? objectIs(val1, val2) : true;
  }

  // Check more closely if val1 and val2 are equal.
  if (strict) {
    if (_typeof(val1) !== 'object') {
      return typeof val1 === 'number' && numberIsNaN(val1) && numberIsNaN(val2);
    }
    if (_typeof(val2) !== 'object' || val1 === null || val2 === null) {
      return false;
    }
    if (Object.getPrototypeOf(val1) !== Object.getPrototypeOf(val2)) {
      return false;
    }
  } else {
    if (val1 === null || _typeof(val1) !== 'object') {
      if (val2 === null || _typeof(val2) !== 'object') {
        // eslint-disable-next-line eqeqeq
        return val1 == val2;
      }
      return false;
    }
    if (val2 === null || _typeof(val2) !== 'object') {
      return false;
    }
  }
  var val1Tag = objectToString(val1);
  var val2Tag = objectToString(val2);
  if (val1Tag !== val2Tag) {
    return false;
  }
  if (Array.isArray(val1)) {
    // Check for sparse arrays and general fast path
    if (val1.length !== val2.length) {
      return false;
    }
    var keys1 = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);
    var keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);
    if (keys1.length !== keys2.length) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsArray, keys1);
  }
  // [browserify] This triggers on certain types in IE (Map/Set) so we don't
  // wan't to early return out of the rest of the checks. However we can check
  // if the second value is one of these values and the first isn't.
  if (val1Tag === '[object Object]') {
    // return keyCheck(val1, val2, strict, memos, kNoIterator);
    if (!isMap(val1) && isMap(val2) || !isSet(val1) && isSet(val2)) {
      return false;
    }
  }
  if (isDate(val1)) {
    if (!isDate(val2) || Date.prototype.getTime.call(val1) !== Date.prototype.getTime.call(val2)) {
      return false;
    }
  } else if (isRegExp(val1)) {
    if (!isRegExp(val2) || !areSimilarRegExps(val1, val2)) {
      return false;
    }
  } else if (isNativeError(val1) || val1 instanceof Error) {
    // Do not compare the stack as it might differ even though the error itself
    // is otherwise identical.
    if (val1.message !== val2.message || val1.name !== val2.name) {
      return false;
    }
  } else if (isArrayBufferView(val1)) {
    if (!strict && (isFloat32Array(val1) || isFloat64Array(val1))) {
      if (!areSimilarFloatArrays(val1, val2)) {
        return false;
      }
    } else if (!areSimilarTypedArrays(val1, val2)) {
      return false;
    }
    // Buffer.compare returns true, so val1.length === val2.length. If they both
    // only contain numeric keys, we don't need to exam further than checking
    // the symbols.
    var _keys = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);
    var _keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);
    if (_keys.length !== _keys2.length) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kNoIterator, _keys);
  } else if (isSet(val1)) {
    if (!isSet(val2) || val1.size !== val2.size) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsSet);
  } else if (isMap(val1)) {
    if (!isMap(val2) || val1.size !== val2.size) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsMap);
  } else if (isAnyArrayBuffer(val1)) {
    if (!areEqualArrayBuffers(val1, val2)) {
      return false;
    }
  } else if (isBoxedPrimitive(val1) && !isEqualBoxedPrimitive(val1, val2)) {
    return false;
  }
  return keyCheck(val1, val2, strict, memos, kNoIterator);
}
function getEnumerables(val, keys) {
  return keys.filter(function (k) {
    return propertyIsEnumerable(val, k);
  });
}
function keyCheck(val1, val2, strict, memos, iterationType, aKeys) {
  // For all remaining Object pairs, including Array, objects and Maps,
  // equivalence is determined by having:
  // a) The same number of owned enumerable properties
  // b) The same set of keys/indexes (although not necessarily the same order)
  // c) Equivalent values for every corresponding key/index
  // d) For Sets and Maps, equal contents
  // Note: this accounts for both named and indexed properties on Arrays.
  if (arguments.length === 5) {
    aKeys = Object.keys(val1);
    var bKeys = Object.keys(val2);

    // The pair must have the same number of owned properties.
    if (aKeys.length !== bKeys.length) {
      return false;
    }
  }

  // Cheap key test
  var i = 0;
  for (; i < aKeys.length; i++) {
    if (!hasOwnProperty(val2, aKeys[i])) {
      return false;
    }
  }
  if (strict && arguments.length === 5) {
    var symbolKeysA = objectGetOwnPropertySymbols(val1);
    if (symbolKeysA.length !== 0) {
      var count = 0;
      for (i = 0; i < symbolKeysA.length; i++) {
        var key = symbolKeysA[i];
        if (propertyIsEnumerable(val1, key)) {
          if (!propertyIsEnumerable(val2, key)) {
            return false;
          }
          aKeys.push(key);
          count++;
        } else if (propertyIsEnumerable(val2, key)) {
          return false;
        }
      }
      var symbolKeysB = objectGetOwnPropertySymbols(val2);
      if (symbolKeysA.length !== symbolKeysB.length && getEnumerables(val2, symbolKeysB).length !== count) {
        return false;
      }
    } else {
      var _symbolKeysB = objectGetOwnPropertySymbols(val2);
      if (_symbolKeysB.length !== 0 && getEnumerables(val2, _symbolKeysB).length !== 0) {
        return false;
      }
    }
  }
  if (aKeys.length === 0 && (iterationType === kNoIterator || iterationType === kIsArray && val1.length === 0 || val1.size === 0)) {
    return true;
  }

  // Use memos to handle cycles.
  if (memos === undefined) {
    memos = {
      val1: new Map(),
      val2: new Map(),
      position: 0
    };
  } else {
    // We prevent up to two map.has(x) calls by directly retrieving the value
    // and checking for undefined. The map can only contain numbers, so it is
    // safe to check for undefined only.
    var val2MemoA = memos.val1.get(val1);
    if (val2MemoA !== undefined) {
      var val2MemoB = memos.val2.get(val2);
      if (val2MemoB !== undefined) {
        return val2MemoA === val2MemoB;
      }
    }
    memos.position++;
  }
  memos.val1.set(val1, memos.position);
  memos.val2.set(val2, memos.position);
  var areEq = objEquiv(val1, val2, strict, aKeys, memos, iterationType);
  memos.val1.delete(val1);
  memos.val2.delete(val2);
  return areEq;
}
function setHasEqualElement(set, val1, strict, memo) {
  // Go looking.
  var setValues = arrayFromSet(set);
  for (var i = 0; i < setValues.length; i++) {
    var val2 = setValues[i];
    if (innerDeepEqual(val1, val2, strict, memo)) {
      // Remove the matching element to make sure we do not check that again.
      set.delete(val2);
      return true;
    }
  }
  return false;
}

// See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness#Loose_equality_using
// Sadly it is not possible to detect corresponding values properly in case the
// type is a string, number, bigint or boolean. The reason is that those values
// can match lots of different string values (e.g., 1n == '+00001').
function findLooseMatchingPrimitives(prim) {
  switch (_typeof(prim)) {
    case 'undefined':
      return null;
    case 'object':
      // Only pass in null as object!
      return undefined;
    case 'symbol':
      return false;
    case 'string':
      prim = +prim;
    // Loose equal entries exist only if the string is possible to convert to
    // a regular number and not NaN.
    // Fall through
    case 'number':
      if (numberIsNaN(prim)) {
        return false;
      }
  }
  return true;
}
function setMightHaveLoosePrim(a, b, prim) {
  var altValue = findLooseMatchingPrimitives(prim);
  if (altValue != null) return altValue;
  return b.has(altValue) && !a.has(altValue);
}
function mapMightHaveLoosePrim(a, b, prim, item, memo) {
  var altValue = findLooseMatchingPrimitives(prim);
  if (altValue != null) {
    return altValue;
  }
  var curB = b.get(altValue);
  if (curB === undefined && !b.has(altValue) || !innerDeepEqual(item, curB, false, memo)) {
    return false;
  }
  return !a.has(altValue) && innerDeepEqual(item, curB, false, memo);
}
function setEquiv(a, b, strict, memo) {
  // This is a lazily initiated Set of entries which have to be compared
  // pairwise.
  var set = null;
  var aValues = arrayFromSet(a);
  for (var i = 0; i < aValues.length; i++) {
    var val = aValues[i];
    // Note: Checking for the objects first improves the performance for object
    // heavy sets but it is a minor slow down for primitives. As they are fast
    // to check this improves the worst case scenario instead.
    if (_typeof(val) === 'object' && val !== null) {
      if (set === null) {
        set = new Set();
      }
      // If the specified value doesn't exist in the second set its an not null
      // object (or non strict only: a not matching primitive) we'll need to go
      // hunting for something thats deep-(strict-)equal to it. To make this
      // O(n log n) complexity we have to copy these values in a new set first.
      set.add(val);
    } else if (!b.has(val)) {
      if (strict) return false;

      // Fast path to detect missing string, symbol, undefined and null values.
      if (!setMightHaveLoosePrim(a, b, val)) {
        return false;
      }
      if (set === null) {
        set = new Set();
      }
      set.add(val);
    }
  }
  if (set !== null) {
    var bValues = arrayFromSet(b);
    for (var _i = 0; _i < bValues.length; _i++) {
      var _val = bValues[_i];
      // We have to check if a primitive value is already
      // matching and only if it's not, go hunting for it.
      if (_typeof(_val) === 'object' && _val !== null) {
        if (!setHasEqualElement(set, _val, strict, memo)) return false;
      } else if (!strict && !a.has(_val) && !setHasEqualElement(set, _val, strict, memo)) {
        return false;
      }
    }
    return set.size === 0;
  }
  return true;
}
function mapHasEqualEntry(set, map, key1, item1, strict, memo) {
  // To be able to handle cases like:
  //   Map([[{}, 'a'], [{}, 'b']]) vs Map([[{}, 'b'], [{}, 'a']])
  // ... we need to consider *all* matching keys, not just the first we find.
  var setValues = arrayFromSet(set);
  for (var i = 0; i < setValues.length; i++) {
    var key2 = setValues[i];
    if (innerDeepEqual(key1, key2, strict, memo) && innerDeepEqual(item1, map.get(key2), strict, memo)) {
      set.delete(key2);
      return true;
    }
  }
  return false;
}
function mapEquiv(a, b, strict, memo) {
  var set = null;
  var aEntries = arrayFromMap(a);
  for (var i = 0; i < aEntries.length; i++) {
    var _aEntries$i = _slicedToArray(aEntries[i], 2),
      key = _aEntries$i[0],
      item1 = _aEntries$i[1];
    if (_typeof(key) === 'object' && key !== null) {
      if (set === null) {
        set = new Set();
      }
      set.add(key);
    } else {
      // By directly retrieving the value we prevent another b.has(key) check in
      // almost all possible cases.
      var item2 = b.get(key);
      if (item2 === undefined && !b.has(key) || !innerDeepEqual(item1, item2, strict, memo)) {
        if (strict) return false;
        // Fast path to detect missing string, symbol, undefined and null
        // keys.
        if (!mapMightHaveLoosePrim(a, b, key, item1, memo)) return false;
        if (set === null) {
          set = new Set();
        }
        set.add(key);
      }
    }
  }
  if (set !== null) {
    var bEntries = arrayFromMap(b);
    for (var _i2 = 0; _i2 < bEntries.length; _i2++) {
      var _bEntries$_i = _slicedToArray(bEntries[_i2], 2),
        _key = _bEntries$_i[0],
        item = _bEntries$_i[1];
      if (_typeof(_key) === 'object' && _key !== null) {
        if (!mapHasEqualEntry(set, a, _key, item, strict, memo)) return false;
      } else if (!strict && (!a.has(_key) || !innerDeepEqual(a.get(_key), item, false, memo)) && !mapHasEqualEntry(set, a, _key, item, false, memo)) {
        return false;
      }
    }
    return set.size === 0;
  }
  return true;
}
function objEquiv(a, b, strict, keys, memos, iterationType) {
  // Sets and maps don't have their entries accessible via normal object
  // properties.
  var i = 0;
  if (iterationType === kIsSet) {
    if (!setEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsMap) {
    if (!mapEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsArray) {
    for (; i < a.length; i++) {
      if (hasOwnProperty(a, i)) {
        if (!hasOwnProperty(b, i) || !innerDeepEqual(a[i], b[i], strict, memos)) {
          return false;
        }
      } else if (hasOwnProperty(b, i)) {
        return false;
      } else {
        // Array is sparse.
        var keysA = Object.keys(a);
        for (; i < keysA.length; i++) {
          var key = keysA[i];
          if (!hasOwnProperty(b, key) || !innerDeepEqual(a[key], b[key], strict, memos)) {
            return false;
          }
        }
        if (keysA.length !== Object.keys(b).length) {
          return false;
        }
        return true;
      }
    }
  }

  // The pair must have equivalent values for every corresponding key.
  // Possibly expensive deep test:
  for (i = 0; i < keys.length; i++) {
    var _key2 = keys[i];
    if (!innerDeepEqual(a[_key2], b[_key2], strict, memos)) {
      return false;
    }
  }
  return true;
}
function isDeepEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kLoose);
}
function isDeepStrictEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kStrict);
}
module.exports = {
  isDeepEqual: isDeepEqual,
  isDeepStrictEqual: isDeepStrictEqual
};

/***/ }),
/* 71 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var define = __webpack_require__(72);
var callBind = __webpack_require__(51);

var implementation = __webpack_require__(68);
var getPolyfill = __webpack_require__(67);
var shim = __webpack_require__(73);

var polyfill = callBind(getPolyfill(), Object);

define(polyfill, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = polyfill;


/***/ }),
/* 72 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var keys = __webpack_require__(64);
var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

var toStr = Object.prototype.toString;
var concat = Array.prototype.concat;
var defineDataProperty = __webpack_require__(53);

var isFunction = function (fn) {
	return typeof fn === 'function' && toStr.call(fn) === '[object Function]';
};

var supportsDescriptors = __webpack_require__(54)();

var defineProperty = function (object, name, value, predicate) {
	if (name in object) {
		if (predicate === true) {
			if (object[name] === value) {
				return;
			}
		} else if (!isFunction(predicate) || !predicate()) {
			return;
		}
	}

	if (supportsDescriptors) {
		defineDataProperty(object, name, value, true);
	} else {
		defineDataProperty(object, name, value);
	}
};

var defineProperties = function (object, map) {
	var predicates = arguments.length > 2 ? arguments[2] : {};
	var props = keys(map);
	if (hasSymbols) {
		props = concat.call(props, Object.getOwnPropertySymbols(map));
	}
	for (var i = 0; i < props.length; i += 1) {
		defineProperty(object, props[i], map[props[i]], predicates[props[i]]);
	}
};

defineProperties.supportsDescriptors = !!supportsDescriptors;

module.exports = defineProperties;


/***/ }),
/* 73 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getPolyfill = __webpack_require__(67);
var define = __webpack_require__(72);

module.exports = function shimObjectIs() {
	var polyfill = getPolyfill();
	define(Object, { is: polyfill }, {
		is: function testObjectIs() {
			return Object.is !== polyfill;
		}
	});
	return polyfill;
};


/***/ }),
/* 74 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBind = __webpack_require__(51);
var define = __webpack_require__(72);

var implementation = __webpack_require__(75);
var getPolyfill = __webpack_require__(76);
var shim = __webpack_require__(77);

var polyfill = callBind(getPolyfill(), Number);

/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

define(polyfill, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = polyfill;


/***/ }),
/* 75 */
/***/ ((module) => {

"use strict";


/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

module.exports = function isNaN(value) {
	return value !== value;
};


/***/ }),
/* 76 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(75);

module.exports = function getPolyfill() {
	if (Number.isNaN && Number.isNaN(NaN) && !Number.isNaN('a')) {
		return Number.isNaN;
	}
	return implementation;
};


/***/ }),
/* 77 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var define = __webpack_require__(72);
var getPolyfill = __webpack_require__(76);

/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

module.exports = function shimNumberIsNaN() {
	var polyfill = getPolyfill();
	define(Number, { isNaN: polyfill }, {
		isNaN: function testIsNaN() {
			return Number.isNaN !== polyfill;
		}
	});
	return polyfill;
};


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* provided dependency */ var console = __webpack_require__(2);
!function(t){var e={};function i(s){if(e[s])return e[s].exports;var n=e[s]={i:s,l:!1,exports:{}};return t[s].call(n.exports,n,n.exports,i),n.l=!0,n.exports}i.m=t,i.c=e,i.d=function(t,e,s){i.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:s})},i.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},i.t=function(t,e){if(1&e&&(t=i(t)),8&e)return t;if(4&e&&"object"==typeof t&&t&&t.__esModule)return t;var s=Object.create(null);if(i.r(s),Object.defineProperty(s,"default",{enumerable:!0,value:t}),2&e&&"string"!=typeof t)for(var n in t)i.d(s,n,function(e){return t[e]}.bind(null,n));return s},i.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return i.d(e,"a",e),e},i.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},i.p="",i(i.s="./sdk_oppo/Main.ts")}({"./fw/Assist/Http.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"default",function(){return r});var s=i("./sdk/Assist/Log.ts"),n=i("./sdk/SDK/Declare.ts");class r{static Request(t,e,i=1,n=!1){let o=new XMLHttpRequest,a=e.Value();(t.IsVivo||t.IsQGMiniGame||t.IsQQMiniGame||t.IsAlipay||t.IsToutiao||t.IsHuaWei)&&(a=e.EncodeURI()),t.IsOnMobile?o.open(e.Method(),a):o.open(e.Method(),a,e.IsAsync());let h=e.Header();for(const t in h)o.setRequestHeader(t,h[t]);o.onerror=function(o){i>1?(i--,r.Request(t,e,i,n)):(n&&s.Log.Error("Http OnError:"+o),e.InvokeError(o+""))},o.onabort=function(t){e.InvokeException(t)},o.onprogress=function(t){},o.onreadystatechange=function(){200===this.status||n&&s.Log.Debug("http request status:"+this.status)},o.onload=function(){try{e.Print();let t=JSON.parse(this.responseText);e.InvokeReceive(t)}catch(t){console.error("xhr.onload error:"+t)}};try{let i=JSON.stringify(e.Data());t.IsOnMobile,o.send(i);let r=e.CheckValue();-1==r.indexOf("statistics/duration")&&n&&s.Log.Log("Request="+r,i)}catch(t){e.InvokeException(t)}}static RequestNormal(t,e,i=1,o=!1){let a=new XMLHttpRequest,h=e.CustomUrl();t.IsOnMobile?a.open(e.Method(),h):a.open(e.Method(),h,e.IsAsync());let l=e.Header();for(const t in l)a.setRequestHeader(t,l[t]);a.onerror=function(n){i>1?(i--,r.RequestNormal(t,e,i,o)):(o&&s.Log.Error("Http OnError:"+n),e.InvokeError(n+""))},a.onabort=function(t){e.InvokeException(t)},a.onprogress=function(t){},a.onreadystatechange=function(){200===this.status||o&&s.Log.Debug("http request status:"+this.status)},a.onload=function(){try{e.Print(),n.SDK.W("YDHW Response-"+e+"-data:",this.responseText);let t=this.responseText;e.InvokeReceive(t)}catch(t){console.error("xhr.onload error:"+t)}};try{let i=JSON.stringify(e.Data());t.IsOnMobile,a.send(i)}catch(t){e.InvokeException(t)}}}},"./fw/Assist/StorageApt.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"StorageApt",function(){return s});class s{}s.SDK_CONFIG="YDHW_CONFIG",s.WriteString=null,s.WriteObject=null,s.ReadString=null,s.ReadObject=null,s.DeleteObject=null},"./fw/Core.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Method",function(){return r}),i.d(e,"Wrapper",function(){return o}),i.d(e,"Variable",function(){return a}),i.d(e,"VariableContainer",function(){return h}),i.d(e,"MethodContainer",function(){return l}),i.d(e,"Core",function(){return S}),i.d(e,"BaseManager",function(){return c});var s=i("./fw/Assist/StorageApt.ts"),n=i("./fw/Log/FrameworkLog.ts");class r{constructor(t,e,i){this.c=t,this.m=e,this._Owner=i}Log(){let t="";if(t+="/ncaller:"+this.c.name,t+="/nmethod:"+this.m.name,this.args)for(let e=0;e<this.args.length;e++)t+=`/r/n arg[${e}]=${this.args[e].name}`;this._Owner&&(t+="/n Owner:"+this._Owner),n.FWLog.D(t)}Destroy(){this.c=null,this.m=null}Bind(t,e,...i){return this.c=t,this.m=e,this.args=i,this}}class o extends Array{constructor(t=64){super(),this._Size=0,this.length=t}RemoveAt(t){const e=this[t];return this[t]=this[--this._Size],this[this._Size]=null,e}Remove(t){let e,i;const s=this._Size;for(e=0;e<s;e++)if(t==(i=this[e]))return this[e]=this[--this._Size],this[this._Size]=null,!0;return!1}RemoveLast(){if(this._Size>0){const t=this[--this._Size];return this[this._Size]=null,t}return null}Contains(t){let e,i;for(e=0,i=this._Size;i>e;e++)if(t===this[e])return!0;return!1}RemoveAll(t){let e,i,s,n,r,o=!1;for(e=0,s=t.Size;e<s;e++)for(n=t.Get(e),i=0;i<this._Size;i++)if(n===(r=this[i])){this.RemoveAt(i),i--,o=!0;break}return o}Get(t){if(t>=this.length)throw new Error("ArrayIndexOutOfBoundsException");return this[t]}SafeGet(t){return t>=this.length&&this.Grow(7*t/4+1),this[t]}get Size(){return this._Size}GetCapacity(){return this.length}IsIndexWithinBounds(t){return t<this.GetCapacity()}IsEmpty(){return 0==this._Size}Add(t){this._Size===this.length&&this.Grow(),this[this._Size++]=t}Set(t,e){t>=this.length&&this.Grow(2*t),this._Size=t+1,this[t]=e}Grow(t=1+~~(3*this.length/2)){this.length=~~t}EnsureCapacity(t){t>=this.length&&this.Grow(2*t)}Clear(){let t,e;for(t=0,e=this._Size;t<e;t++)this[t]=null;this._Size=0}AddAll(t){let e;for(e=0;t.Size>e;e++)this.Add(t.Get(e))}}class a{constructor(t,e,i){this._id=0,this._IsStore=!1,this._ListCaller={},this._LBEvent={},this._ListArgs={},this._Owner=e,this._Id=t,this._Value=i,this._Type=typeof i}Log(){let t="";this._Owner&&(t+="Owner: "+this._Owner),t+="\nType: "+this._Type,t+="\nVariableId: "+this._Id,t+="\nValue: "+this._Value,t+="\n",n.FWLog.D(t)}SetOwner(t){return this._Owner=t,this}Owner(){return this._Owner}Store(){return this._IsStore=!0,this}IsStore(){return this._IsStore}Data(){this.Owner}Revert(t){this._Value=t,this._Type=typeof t}Id(){return this._Id}SetValue(t){let e=this._Value;return this._Value=t,this._Type=typeof t,this._EmitValueChanged(e),this}Value(){return this._Value}Type(){return this._Type}Bind(t,e,...i){this._id++,this._ListCaller[this._id+""]=t,this._LBEvent[this._id+""]=e,this._ListArgs[this._id+""]=i}Assign(){this._EmitValueChanged(this._Value)}Unbind(t,e){for(let t in this._ListCaller)delete this._ListCaller[t];for(let t in this._LBEvent)delete this._LBEvent[t]}_EmitValueChanged(t){for(let t in this._LBEvent){let e=this._ListCaller[t],i=this._LBEvent[t],s=this._ListArgs[t],n=[];n.push(this._Value);for(let t in s)n.push(s[t]);i.apply(e,n)}}}class h{constructor(){this._DictVariable={},this._IsRestore=!1}CheckAllVariables(){n.FWLog.D("Check all variables");let t=this._DictVariable;for(let e in t){let i=t[e];n.FWLog.D("Variable:"+e),i.Log()}}_GV(t,e){let i=this._DictVariable[t];return null==i||null==i?null:i}GV(t,e){let i=this._DictVariable,s=i[t];if(null==s){let n=new a(t,e,null);null==(s=this.RevertVariable(n))||(i[t]=s)}return s}MV(t,e){null!=t?(t.SetValue(e),t.IsStore()&&this.SaveV(t.Id())):n.FWLog.E("修改的变量不存在")}DV(t,e,i){if(null==t||0==t.toString().length)return null;{let s=this._GV(t);return null!=s?s.SetValue(i):(s=new a(t,e,i),this._DictVariable[t]=s),s}}RemoveV(t){let e=this._DictVariable;null!=e[t]&&(delete e[t],s.StorageApt.DeleteObject(t+""))}_GVV(t){let e=this.GV(t);return null==e?null:e.Value()}GVT(t,e){let i=this._GVV(t);return null==i?(n.FWLog.W(`找不到对应的变量名:${t}`),void 0===e?null:e):i}SVT(t,e){let i=this._GV(t);null!=i?this.MV(i,e):console.error("修改的变量不存在："+t)}AVT(t,e){let i=this._GV(t);if(null!=i){if("number"==typeof e){let t=i.Value()+Number(e);return this.MV(i,t),i.Value()}if("string"==typeof e){let t=i.Value()+String(e);return this.MV(i,t),i.Value()}console.error('当前数据类型暂不支持"+"运算符操作')}else console.error(`"+" 变量不存在：${t}`);return null}SubVT(t,e){let i=this._GV(t);if(null!=i){if("number"==typeof e){let t=i.Value()+Number(e);return this.MV(i,t),i.Value()}if("string"==typeof e){let t=i.Value()+String(e);return this.MV(i,t),i.Value()}console.error('当前数据类型暂不支持"+"运算符操作')}else console.error(`"-" 变量不存在：${t}`);return null}Bind(t,e,i,...s){let n=this._GV(t);return null!=n&&(n.Bind(e,i,s),!0)}Unbind(t,e,i){let s=this._GV(t);return null!=s&&(s.Unbind(e,i),!0)}RevertVariable(t){let e=t.Id(),i=s.StorageApt.ReadObject("varId_"+e);if(!i)return n.FWLog.W("本地数据不存在字段:varId_"+e),null;let r="YDHW-Framework: ",o=" 数据类型不存在!";if("object"==typeof i){i.name;let e=i.type;if(void 0===e)return console.warn(r+"1"+o),null;let s=i.value;if(void 0===s)return console.warn(r+"2"+o),null;if(void 0===i.is_store)return console.warn(r+"3"+o),null;let n=i.owner;if(void 0===n)return console.warn(r+"4"+o),null;if("string"==e)t.Revert(String(s));else if("number"==e)t.Revert(Number(s));else if("boolean"==e)t.Revert(Boolean(s));else{if("object"!=e)return console.warn(r+""+o),null;t.Revert(Object(s))}t.Store(),t.SetOwner(n)}return t}RevertData(){if(this._IsRestore)return;let t=this._DictVariable;for(let e in t){let i=t[e];i.IsStore()&&this.RevertVariable(i)}this._IsRestore=!0}SaveData(t){let e=this._DictVariable;for(let i in e){let n=e[i];n.Owner()==t&&n.IsStore()&&s.StorageApt.WriteObject("varId_"+i,{name:i,value:n.Value(),type:n.Type(),is_store:n.IsStore(),owner:n.Owner()})}return[]}SaveAllData(){let t=this._DictVariable;for(let e in t)this.SaveV(parseInt(e))}SaveV(t){let e=this._DictVariable[t];e.IsStore()&&s.StorageApt.WriteObject("varId_"+t,{name:t,value:e.Value(),type:e.Type(),is_store:e.IsStore(),owner:e.Owner()})}}class l{constructor(){this._DNfy={},this._DMtd={}}CheckAllMtd(){console.log("Check all notify");for(let t in this._DNfy){let e=this._DNfy[t];console.log(`Notify: ${t}`);for(let t=0;t<e.length;t++)e[t].Log()}console.log("Check all m");for(let t in this._DMtd){let e=this._DMtd[t];console.log(`Mehtod: ${t}`),e.Log()}}DM(t,e,i,s){let n=this._DMtd,o=n[t];return null==o?n[t]=new r(e,s,i):(console.warn("owner="+i+" "+t+" 已经被注册过了, 二次注册=重载覆写上一个函数的内容"),n[t]=new r(e,s,i)),o}DNotify(t,e,i,s){let n=this._DNfy;null==n[t]?(n[t]=[],n[t].push(new r(e,s,i))):n[t].push(new r(e,s,i))}InvokeNfy(t,e){let i=this._DNfy[t];if(i&&i.length)for(let t=0,s=i.length;t<s;t++){let s=i[t];s.m.apply(s.c,e)}}Invoke(t,e){let i=this._DMtd[t];if(null!=i)return i.m.apply(i.c,e);console.error("事件没注册："+t)}ClearAllMethod(){let t=this._DMtd;for(let e in t)t[e].Destroy(),delete t[e];delete this._DMtd}}function d(t,e){return e in t?t:null}class S{constructor(){this._VC=new h,this._MC=new l,this._ListInit={},this._ListExecute={},this._ListAll={},this._CurFrameIndex=0,this._ListInit={},this._ListExecute={},this._ListAll={},this._Manager=new c,this._Manager.SetCore(this)}static Me(){return null==S._Me&&(S._Me=new S),S._Me}static SetCore(t,e){const i=d(t,"SetCore");null!=i&&i.SetCore(e)}static SetName(t,e){const i=d(t,"SetName");null!=i&&i.SetName(e)}VContainer(){return this._VC}MContainer(){return this._MC}Add(t,e){n.FWLog.L("Add Manager: "+t),"function"==typeof e&&(e=new e),S.SetCore(e,this),S.SetName(e,t);const i=d(e,"Init");null!=i&&(this._ListInit[t]=i);const s=d(e,"Execute");return null!=s&&(this._ListExecute[t]=s),this._ListAll[t]=e,this}AsManager(){return this._Manager}GetManager(t){return this._ListAll[t]}Initialize(){const t=this._ListInit;for(let e in t){let i=t[e];i&&i.Init()}}Execute(){this._CurFrameIndex++;const t=this._ListExecute;for(let e in t){let i=t[e];i&&i.Execute(this._CurFrameIndex)}}Restore(){const t=this._ListAll;for(let e in t)t[e].Restore()}Save(){const t=this._ListAll;for(let e in t)t[e].Save()}}S._Me=null;class c{constructor(){this.Name="Gauntlet",this._Core=null,this.VC=null,this.MC=null}SetName(t){this.Name=t}SetCore(t){this._Core=t,this.VC=this._Core.VContainer(),this.MC=this._Core.MContainer()}DM(t,e,i){return this.MC.DM(t,e,this.Name,i)}DNfy(t,e,i){this.MC.DNotify(t,e,this.Name,i)}Invoke(t,...e){return this.MC.Invoke(t,e)}InvokeNfy(t,...e){this.MC.InvokeNfy(t,e)}DV(t,e){return this.VC.DV(t,this.Name,e)}GV(t){return this.VC.GV(t,this.Name)}GVT(t,e){return this.VC.GVT(t,e)}SVT(t,e){this.VC.SVT(t,e)}AVT(t,e){return this.VC.AVT(t,e)}SubVT(t,e){return this.VC.SubVT(t,e)}BindV(t,e,i,...s){return this.VC.Bind(t,e,i)}UnbindV(t,e,i){return this.VC.Unbind(t,e,i)}RemoveV(t){this.VC.RemoveV(t)}Restore(){this.VC.RevertData()}Save(){this.Name&&this.Name.length>0?this.VC.SaveData(this.Name):this.VC.SaveAllData()}SaveVariable(t){this.Name&&this.Name.length>0&&this.VC.SaveV(t)}}},"./fw/Enums/PLAT.ts":function(t,e,i){"use strict";var s;i.r(e),i.d(e,"PLAT",function(){return s}),function(t){t[t.Common=-1]="Common",t[t.Wechat=0]="Wechat",t[t.QQ=1]="QQ",t[t.Oppo=2]="Oppo",t[t.Vivo=3]="Vivo",t[t.Toutiao=4]="Toutiao",t[t.Baidu=5]="Baidu",t[t.P_4399=6]="P_4399",t[t.Qutoutiao=7]="Qutoutiao",t[t.P_360=8]="P_360",t[t.Momo=9]="Momo",t[t.Web=10]="Web",t[t.Xiaomi=11]="Xiaomi",t[t.Meizu=12]="Meizu",t[t.UC=13]="UC",t[t.Alipay=14]="Alipay",t[t.kwg=15]="kwg",t[t.YY=16]="YY",t[t.HuaWei=17]="HuaWei",t[t.Hago=18]="Hago",t[t.Wuji=19]="Wuji"}(s||(s={}))},"./fw/Log/FrameworkLog.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"FWLog",function(){return n});var s=i("./fw/Utility/LogUtility.ts");class n{static L(t,...e){s.LogUtility.Me().L(this.a,t,null,e)}static D(t,...e){s.LogUtility.Me().D(this.a,t,null,e)}static I(t,...e){s.LogUtility.Me().I(this.a,t,null,e)}static W(t,...e){s.LogUtility.Me().W(this.a,t,null,e)}static E(t,...e){s.LogUtility.Me().E(this.a,t,null,e)}}n.a="Framework"},"./fw/Log/UrlLog.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"default",function(){return n});var s=i("./fw/Utility/LogUtility.ts");class n{static L(t,...e){s.LogUtility.Me().L(this.a,t,null,e)}static D(t,...e){s.LogUtility.Me().D(this.a,t,null,e)}static I(t,...e){s.LogUtility.Me().I(this.a,t,null,e)}static W(t,...e){s.LogUtility.Me().W(this.a,t,null,e)}static E(t,...e){s.LogUtility.Me().E(this.a,t,null,e)}}n.a="Url"},"./fw/Manager/ApiManager.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"ApiManager",function(){return r});var s=i("./fw/Manager/Manager.ts"),n=i("./fw/Core.ts");class r extends s.Manager{SetCore(t){this._Core=t,this.VC=new n.VariableContainer,this.MC=new n.MethodContainer}Init(){}}},"./fw/Manager/CommerceManager.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"CommerceManager",function(){return n});var s=i("./fw/Manager/Manager.ts");class n extends s.Manager{Init(){}}},"./fw/Manager/Manager.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Manager",function(){return r});var s=i("./fw/Utility/LogUtility.ts"),n=i("./fw/Core.ts");class r extends n.BaseManager{constructor(){super(...arguments),this.Name="Gauntlet"}Log(t,...e){s.LogUtility.Me().L(this.Name,t,r.LogStyle,e)}Debug(t,...e){s.LogUtility.Me().D(this.Name,t,r.DebugStyle,e)}Info(t,...e){s.LogUtility.Me().I(this.Name,t,r.InfoStyle,e)}Warn(t,...e){s.LogUtility.Me().W(this.Name,t,r.WarnStyle,e)}Error(t,...e){s.LogUtility.Me().E(this.Name,t,r.ErrorStyle,e)}Table(t,e){s.LogUtility.Me().T(this.Name,r.TableStyle,t,e)}}r.DEFAULT_FONT_SIZE=12,r.LogStyle=`color: green; font-size:${r.DEFAULT_FONT_SIZE}px`,r.DebugStyle=`color: DodgerBlue; font-size:${r.DEFAULT_FONT_SIZE}px`,r.InfoStyle=`color: Turquoise; font-size:${r.DEFAULT_FONT_SIZE}px`,r.WarnStyle=`color: Orange; font-size:bold,${r.DEFAULT_FONT_SIZE}px`,r.ErrorStyle=`color: Tomato; font-size:${r.DEFAULT_FONT_SIZE}px`,r.TableStyle=`color: Black; font-size:${r.DEFAULT_FONT_SIZE}px`},"./fw/Manager/NetManager.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"NetManager",function(){return r});var s=i("./fw/Manager/Manager.ts"),n=i("./fw/Core.ts");class r extends s.Manager{SetCore(t){this._Core=t,this.VC=new n.VariableContainer,this.MC=new n.MethodContainer}Init(){}}},"./fw/Utility/Assist.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Assist",function(){return s});class s{static ToB(t){return 1===t}static ToSB(t,e){let i=0!==t;return i||console.warn(e+" is off"),i}}},"./fw/Utility/LogUtility.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"LogUtility",function(){return s});class s{constructor(){this._Tag="",this.PARAM_COUNT=3,this._LogStyle=`color:green;font-size:${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`,this._DebugStyle=`color:dodgerblue;font-size:${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`,this._InfoStyle=`color:turquoise;font-size:${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`,this._WarnStyle=`color:orange;font-size:bold,${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`,this._ErrorStyle=`color:tomato;font-size:${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`,this._TableStyle=`color:magenta;font-size:${s.DEFAULT_FONT_SIZE}px;font-weight:bold;`}static Me(){return null==this._Me&&(this._Me=new s),this._Me}L(t,e,i,n){if(!s.IS_ENABLE_DEBUG)return;i=i&&void 0!==i?i:this._LogStyle;let r=[];for(let t=this.PARAM_COUNT;t<arguments.length;t++)r[t-this.PARAM_COUNT]=arguments[t];if(this.P&&(this.P.IsOppo||this.P.IsVivo||this.P.IsMeizu||!this.P.IsSimulator)){let i="";return n&&void 0!==n&&n.length>0&&(i=JSON.stringify(r[0])),void console.log("[Log]["+t+"] "+e+" "+i)}this.P&&(this.P.IsOppo||this.P.IsWechat)?n&&void 0!==n&&n.length>0?console.log.apply(console,["[Log]["+t+"] "+e].concat(r)):console.log.apply(console,["[Log]["+t+"] "+e]):(n&&void 0!==n&&n.length>0?console.groupCollapsed.apply(console,["%c[Log]["+t+"] "+e,i].concat(r)):console.groupCollapsed.apply(console,["%c[Log]["+t+"] "+e,i]),console.trace(),console.groupEnd())}D(t,e,i,n){if(!s.IS_ENABLE_DEBUG)return;i=i&&void 0!==i?i:this._DebugStyle;let r=[];for(let t=this.PARAM_COUNT;t<arguments.length;t++)r[t-this.PARAM_COUNT]=arguments[t];if(this.P&&(this.P.IsOppo||this.P.IsVivo||this.P.IsMeizu||!this.P.IsSimulator)){let i="";return n&&void 0!==n&&n.length>0&&(i=JSON.stringify(r[0])),void console.debug("[Debug]["+t+"] "+e+" "+i)}this.P&&(this.P.IsOppo||this.P.IsWechat)?n&&void 0!==n&&n.length>0?console.debug.apply(console,["[Debug]["+t+"] "+e].concat(r)):console.debug.apply(console,["[Debug]["+t+"] "+e]):(n&&void 0!==n&&n.length>0?console.groupCollapsed.apply(console,["%c[Debug]["+t+"] "+e,i].concat(r)):console.groupCollapsed.apply(console,["%c[Debug]["+t+"] "+e,i]),console.trace(),console.groupEnd())}I(t,e,i,n){if(!s.IS_ENABLE_DEBUG)return;i=i&&void 0!==i?i:this._InfoStyle;let r=[];for(let t=this.PARAM_COUNT;t<arguments.length;t++)r[t-this.PARAM_COUNT]=arguments[t];if(this.P&&(this.P.IsOppo||this.P.IsVivo||this.P.IsMeizu||!this.P.IsSimulator)){let i="";return n&&void 0!==n&&n.length>0&&(i=JSON.stringify(r[0])),void console.log("[Info]["+t+"] "+e+" "+i)}this.P&&(this.P.IsOppo||this.P.IsWechat)?n&&void 0!==n&&n.length>0?console.info.apply(console,["[Info]["+t+"] "+e].concat(r)):console.info.apply(console,["[Info]["+t+"] "+e]):(n&&void 0!==n&&n.length>0?console.groupCollapsed.apply(console,["%c[Info]["+t+"] "+e,i].concat(r)):console.groupCollapsed.apply(console,["%c[Info]["+t+"] "+e,i]),console.trace(),console.groupEnd())}W(t,e,i,n){if(!s.IS_ENABLE_DEBUG)return;i=i&&void 0!==i?i:this._WarnStyle;let r=[];for(let t=this.PARAM_COUNT;t<arguments.length;t++)r[t-this.PARAM_COUNT]=arguments[t];if(this.P&&(this.P.IsOppo||this.P.IsVivo||this.P.IsMeizu||!this.P.IsSimulator)){let i="";return n&&void 0!==n&&n.length>0&&(i=JSON.stringify(r[0])),void console.warn("[Warn]["+t+"] "+e+" "+i)}this.P&&(this.P.IsOppo||this.P.IsWechat)?n&&void 0!==n&&n.length>0?console.warn.apply(console,["[Warn]["+t+"] "+e].concat(r)):console.warn.apply(console,["[Warn]["+t+"] "+e]):(n&&void 0!==n&&n.length>0?console.groupCollapsed.apply(console,["%c[Warn]["+t+"] "+e,i].concat(r)):console.groupCollapsed.apply(console,["%c[Warn]["+t+"] "+e,i]),console.trace(),console.groupEnd())}E(t,e,i,n){if(!s.IS_ENABLE_DEBUG)return;i=i&&void 0!==i?i:this._ErrorStyle;let r=[];for(let t=this.PARAM_COUNT;t<arguments.length;t++)r[t-this.PARAM_COUNT]=arguments[t];if(this.P&&(this.P.IsOppo||this.P.IsVivo||this.P.IsMeizu||!this.P.IsSimulator)){let i="";return n&&void 0!==n&&n.length>0&&(i=JSON.stringify(r[0])),void console.error("[Error]["+t+"] "+e+" "+i)}this.P&&(this.P.IsOppo||this.P.IsWechat)?n&&void 0!==n&&n.length>0?console.error.apply(console,["[Error]["+t+"] "+e].concat(r)):console.error.apply(console,["[Error]["+t+"] "+e]):(n&&void 0!==n&&n.length>0?console.groupCollapsed.apply(console,["%c[Error]["+t+"] "+e,i].concat(r)):console.groupCollapsed.apply(console,["%c[Error]["+t+"] "+e,i]),console.trace(),console.groupEnd())}T(t,e,i,n){s.IS_ENABLE_DEBUG&&(n=n&&void 0!==n?n:this._TableStyle,this.P&&(this.P.IsOppo||this.P.IsWechat)||(console.groupCollapsed.apply(console,["%c[Table]["+t+"] ",n]),console.table(e),console.groupEnd()))}}s._Me=null,s.IS_ENABLE_DEBUG=!0,s.DEFAULT_FONT_SIZE=12,s.BACK_GROUND_COLOR="background:#FFFF99",new s},"./fw/Utility/RandomUtility.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"RandomUtility",function(){return s});class s{static Probability(t){return 100==t||0!=t&&Math.floor(100*Math.random())<=t}}},"./fw/Utility/TimerUtility.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Timer",function(){return s}),i.d(e,"DelayTimer",function(){return n}),i.d(e,"default",function(){return r});class s{constructor(){this.IntervalID=null}Init(t,e,i,s,n){this.Name=t,this._Caller=e,this._Method=i,this.Args=n,this._StartTimestamp=Date.now(),this.Interval=s}Execute(...t){this._Method.call(this._Caller,t)&&r.RemoveTimer(this.Name)}Invoke(...t){this._Method.call(this._Caller,t)}}class n extends s{Init(t,e,i,s,n){this.Name=t,this._Caller=e,this._InnerMethod=i,this.Args=n,this._StartTimestamp=Date.now(),this.Interval=s}Execute(...t){this._InnerMethod.apply(this._Caller,t)}Invoke(...t){this._InnerMethod.apply(this._Caller,t)}}class r{static DecimalFormat(t){return(t>9?"":"0")+t}static TimeFormat_1(t,e){return this.SecondsToDay(t)+e+this.SecondsToHour(t)+e+this.SecondsToMinute(t%60)}static MilliSecondsToSeconds(t){return Math.floor(t/1e3)}static SecondsToDay(t){return t/3600|0}static SecondsToHour(t){return(t/60|0)%60}static SecondsToMinute(t){return t/60}static MilliSecondsToMinute(t){return this.SecondsToMinute(this.MilliSecondsToSeconds(t))}static Delay(t,e,i,...s){let r=new n;r.Init("delay_event",e,i,t,s),r.IntervalID=setTimeout(function(){r.Execute(r.Args)},r.Interval);let o=r.IntervalID+"";return this._DelayTimer[o]=r,o}static RemoveDelayTimer(t){let e=this._DelayTimer[t];e&&e instanceof n&&clearTimeout(e.IntervalID)}static DelayBtnEnabled(t,e,...i){this.Delay(2500,t,e,...i)}static DeactivateTimer(t){let e=this._DictTimer[t];e&&e instanceof s?clearInterval(e.IntervalID):console.warn("休眠 "+this.noTimer+`${t}`)}static ActivateTimer(t){let e=this._DictTimer[t];e&&e instanceof s?(clearInterval(e.IntervalID),e.IntervalID=setInterval(function(){e.Execute(e.Args)},e.Interval)):console.warn("激活"+this.noTimer+`${t}`)}static AddTimer(t,e,i,n,r,o){let a=this._DictTimer[t];a&&a instanceof s?console.warn(`添加 定时器已存在：${t}`):(i&&n&&n.call(i),(a=new s).Init(t,i,r,e,o),a.IntervalID=setInterval(function(){a.Execute(a.Args)},e,o),this._DictTimer[t]=a)}static GetTimer(t){let e=this._DictTimer[t];return e&&e instanceof s?e:(console.warn("获取"+this.noTimer+`${t}`),null)}static RemoveTimer(t){let e=this._DictTimer[t];e&&e instanceof s?(e=this._DictTimer[t],clearInterval(e.IntervalID),this._DictTimer[t]=null):console.warn("移除"+this.noTimer+`${t}`)}}r._DictTimer={},r._DelayTimer={},r.noTimer="定时器不存在："},"./fw/Utility/Url.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"URL_SLICE_TYPE",function(){return h}),i.d(e,"Url",function(){return l});var s=i("./fw/Assist/Http.ts"),n=i("./fw/Log/UrlLog.ts"),r=i("./sdk/SDK/Declare.ts");const o="need set ",a="not set ";var h;!function(t){t.None="Null",t.Method="Method",t.Domain="Domain",t.Manager="Manager",t.Version="Version",t.Category="Category",t.Router="Router",t.Append="Append",t.Description="Description",t.End="End"}(h||(h={}));class l{constructor(){this._Slices=[],this._Header={},this._AccountPass="",this._MethodType="",this._Http="",this._DomainIndex=0,this._Domains=[],this._Version="",this._Category="",this._Manager="",this._Router="",this._AppendList=[],this._Params={},this._CAIndex=0,this._Description="",this._Url="",this._CSType=h.None,this._Async=!0,this._IsEnd=!1,this._Data="",this._IsDebug=!0,this._RecvCounter=0,this._DictRecvCaller={},this._DictRecvMethod={},this._ErrorCaller=null,this._ErrorMethod=null,this._ExceptionCaller=null,this.HTTPs={1:"Content-Type",2:"AccountPass",3:"EngineType",4:"EngineVer"},this.HEADs={1:"application/json;charset=UTF-8",2:"application/x-www-form-urlencoded",3:"application/json"},l.AllUrls.push(this)}Print(){let t=this._Category+"-"+this._Router;this._IsDebug&&console.log(""+t)}SetIsDebugMode(t){this._IsDebug=t}static SetAllDebugMode(t){for(let e=0;e<l.AllUrls.length;e++)l.AllUrls[e]._IsDebug=t}AccountPass(t){return this._AccountPass=t,this}static SetAccountPass(t){for(let e=0;e<l.AllUrls.length;e++)l.AllUrls[e]._AccountPass=t}Head(t,e){return this._Header[this.HTTPs[t]]="string"==typeof e?e:this.HEADs[e],this}Header(){return this._Header}AsPost(){return this._MethodType="post",this}AsGet(){return this._MethodType="get",this}Method(){return this._MethodType}Des(t){return this._Description=t,this._CSType=h.Description,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this}Switch(t){return this._DomainIndex=t,this}Domain(t){return this._CSType=h.Domain,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._Domains=t,this}Manager(t){return this._Slices.indexOf(h.Domain)<0?(n.default.E(o+"domain"),this):(this._CSType=h.Manager,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._Manager=t,this)}Version(t){return this._Slices.indexOf(h.Manager)<0?(n.default.E(o+"manager"),this):(this._CSType=h.Version,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._Version=t,this)}C(t){return this._Slices.indexOf(h.Version)<0?(n.default.E(o+"version"),this):(this._CSType=h.Category,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._Category=t,this)}R(t){return this._Slices.indexOf(h.Category)<0?(n.default.E(o+"category"),this):(this._CSType=h.Router,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._Router=t,this._Router.length>=0&&(this._AppendList=[]),this)}A(t){return this._Slices.indexOf(h.Router)<0?(n.default.E(o+"router"),this):(this._CSType=h.Append,this._Slices.indexOf(this._CSType)<0&&this._Slices.push(this._CSType),this._CAIndex=this._AppendList.push(t),this)}End(){if(this._Slices.indexOf(h.Domain)<0)return n.default.E(a+"domain"),this;if(this._Slices.indexOf(h.Manager)<0)return n.default.E(a+"manager"),this;if(this._Slices.indexOf(h.Version)<0)return n.default.E(a+"version"),this;if(this._Slices.indexOf(h.Category)<0)return n.default.E(a+"category"),this;if(this._Slices.indexOf(h.Router)<0)return n.default.E(a+"router"),this;if(this._CSType=h.End,this._IsEnd=!0,this._DomainIndex>this._Domains.length-1)return n.default.E("domain error"),null;if(this._DomainIndex<0)return n.default.E("domain switch error"),null;if(!this._Domains[this._DomainIndex])return n.default.E("domain null"),null;this._Url=this._Http+this._Domains[this._DomainIndex]+"/"+this._Manager+"/"+this._Version+"/"+this._Category+"/"+this._Router;try{for(const t in this._AppendList)this._Url+="/"+this._AppendList[t]}catch(t){for(const t of this._AppendList)this._Url+="/"+t}if(Object.keys(this._Params).length>0){let t=!0;for(const e in this._Params){let i=this._Params[e];t?(t=!1,this._Url+="?"):this._Url+="&",this._Url+=e+"="+i}}return this}Value(){if(!0!==this._IsEnd)return n.default.E(a+"end yet"),null;if(this._MethodType.length<=0)return n.default.E(a+"m type"),null;switch(this._CSType){case h.None:return"Error Url";case h.Method:return this._MethodType;case h.Domain:return this._Domains[this._DomainIndex];case h.Version:return this._Version;case h.Category:return this._Category;case h.Router:return this._Router;case h.Append:return this._AppendList.length>0?this._AppendList[this._CAIndex]:"Error Append Param";case h.End:return this._Url}return null}SetCustomUrl(t){return this._Url=t,this}CustomUrl(){return this._Url}CheckValue(){return this._Url}Data(){return this._Data}Post(t){return"post"!=this._MethodType?(n.default.E("current m is not post"),null):(this._Data=t||"",this)}IsAsync(){return this._Async}EncodeURI(){return!1===this._IsEnd?(n.default.E("not end"),""):encodeURI(this._Url)}Param(t,e){return this._Params[t]=e,this}static Post(t){let e=new l;return e._MethodType="post",e._Data=t,e}static Get(){let t=new l;return t._MethodType="get",t}Send(t){this._AccountPass&&this._AccountPass.length>0&&this.Head(2,this._AccountPass),s.default.Request(r.SDK.P(),this,3,this._IsDebug)}SendCustomUrl(){s.default.RequestNormal(r.SDK.P(),this,3,this._IsDebug)}Clone(){let t=new l;t._Slices=[];for(const e of this._Slices)t._Slices.push(e);t._Header={};for(const e in this._Header)t._Header[e]=this._Header[e];t._AccountPass=this._AccountPass,t._MethodType=this._MethodType,t._Http=this._Http,t._DomainIndex=this._DomainIndex,t._Domains=[];for(const e of this._Domains)t._Domains.push(e);t._Version=this._Version,t._Category=this._Category,t._Manager=this._Manager,t._Router=this._Router,t._AppendList=[];for(const e of this._AppendList)t._AppendList.push(e);return t._CAIndex=this._CAIndex,t._Url=this._Url,t._CSType=this._CSType,t._Async=this._Async,t._IsEnd=this._IsEnd,t._Data=JSON.parse(JSON.stringify(this._Data)),t._DictRecvCaller={},t._DictRecvMethod={},t._ErrorCaller=null,t._ErrorMethod=null,t._ExceptionCaller=null,t._ExceptionMethod=null,t}OnReceive(t,e){return this._RecvCounter++,!this._DictRecvCaller&&(this._DictRecvCaller={}),!this._DictRecvMethod&&(this._DictRecvMethod={}),this._DictRecvCaller[this._RecvCounter]=t,this._DictRecvMethod[this._RecvCounter]=e,this}InvokeReceive(t){if(this._DictRecvCaller&&this._DictRecvMethod){for(let e in this._DictRecvCaller){let i=this._DictRecvCaller[e];this._DictRecvMethod[e].call(i,t)}this._DictRecvCaller={},this._DictRecvMethod={}}else n.default.W("not bind receive callback")}OnError(t,e){return this._ErrorCaller=t,this._ErrorMethod=e,this}InvokeError(t){this._ErrorCaller&&this._ErrorMethod?this._ErrorMethod.call(this._ErrorCaller,t):n.default.W("not bind error callback")}OnException(t,e){return this._ExceptionCaller=t,this._ExceptionMethod=e,this}InvokeException(t){this._ExceptionCaller&&this._ExceptionMethod?this._ExceptionMethod.call(this._ExceptionCaller,t):n.default.W("not bind exception callback")}}l.AllUrls=[]},"./sdk/Assist/Log.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Log",function(){return n});var s=i("./fw/Utility/LogUtility.ts");class n{static Log(t,...e){s.LogUtility.Me().L("YDHW_SDK",t,null,e)}static Debug(t,...e){s.LogUtility.Me().D("YDHW_SDK",t,null,e)}static Info(t,...e){s.LogUtility.Me().I("YDHW_SDK",t,null,e)}static Warn(t,...e){s.LogUtility.Me().W("YDHW_SDK",t,null,e)}static Error(t,...e){s.LogUtility.Me().E("YDHW_SDK",t,null,e)}}},"./sdk/Base/SDKP.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"SDKErrorInfo",function(){return l}),i.d(e,"SDKP",function(){return d});var s=i("./fw/Assist/StorageApt.ts"),n=i("./sdk/SDK/Declare.ts"),r=i("./fw/Utility/LogUtility.ts"),o=i("./sdk/Extensions/ClientLogSystem.ts"),a=i("./fw/Enums/PLAT.ts");const h="YDHW-SDK:";class l{}class d{constructor(){this.Ctrl=null,this.Controller2=null,this.Config=null,this.Name="SDKPlatform",this.SysInfo=null,this.BnAdId="",this.BnAd=null,this.GameBanner=null,this.GamePortaAd=null,this.BnStyle=null,this.COnRsBnAd=null,this.IsMTBnAd=!1,this.IsSBnAd=!1,this.IsSGBnad=!1,this.VdAdId="",this.VdAd=null,this.IsShowVdAd=!1,this.IntttAdId="",this.IntttAd=null,this.GridAdId="",this.AppBoxAdId="",this.BlockAdId="",this.UIBtn=null,this.IsSimulator=!1,this.NickName="",this.AvatarUrl="",this.Code="",this.OpenID="",this.AccountPass="",this.NetType="Get NetworkType failed!",this.Brand="",this.Model="",this.Resolution="",this.AppName="",this.Env="",this.InviteAccount="",this.IsDebug=!1,this.IsWechat=!1,this.IsQQ=!1,this.IsOppo=!1,this.IsVivo=!1,this.IsToutiao=!1,this.IsBaidu=!1,this.Is4399=!1,this.IsQutoutiao=!1,this.Is360=!1,this.IsMomo=!1,this.IsXiaomi=!1,this.IsMeizu=!1,this.IsUC=!1,this.IsWeb=!1,this.IsAlipay=!1,this.IsHago=!1,this.IsWuji=!1,this.IsHuaWei=!1,this.Iskwaigame=!1,this.IsQGMiniGame=!1,this.IsQQMiniGame=!1,this.IsOnMobile=!1,this.IsOnIOS=!1,this.IsOnIPhone=!1,this.IsOnMac=!1,this.IsOnIPad=!1,this.IsOnAndroid=!1,this.IsOnWP=!1,this.IsOnQQBrowser=!1,this.IsOnMQQBrowser=!1,this.IsOnWeiXin=!1,this.IsOnSafari=!1,this.IsOnPC=!1,this.IsCocosEngine=!1,this.IsLayaEngine=!1,this.AccountToken=null,this.platfrom=null,this.reqNativeLimit=1,this.Name=this.constructor.name}initSDK(){this.Name=this.constructor.name,this.Config=window[s.StorageApt.SDK_CONFIG],n.SDK.Debug=Boolean(this.Config.debug),this.IsDebug=Boolean(this.Config.debug),this.reqNativeLimit=Number(this.Config.reqNativeLimit),this.Env=String(this.Config.env);let t=window.navigator.userAgent;this.IsOnMobile=!!window.isConchApp||t.indexOf("Mobile")>-1,this.IsOnIOS=!!t.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),this.IsOnIPhone=t.indexOf("iPhone")>-1,this.IsOnMac=t.indexOf("Mac OS X")>-1,this.IsOnIPad=t.indexOf("iPad")>-1,this.IsOnAndroid=t.indexOf("Android")>-1||t.indexOf("Adr")>-1,this.IsOnWP=t.indexOf("Windows Phone")>-1,this.IsOnQQBrowser=t.indexOf("QQBrowser")>-1,this.IsOnMQQBrowser=t.indexOf("MQQBrowser")>-1||t.indexOf("Mobile")>-1&&t.indexOf("QQ")>-1,this.IsOnWeiXin=t.indexOf("MicroMessenger")>-1,this.IsOnSafari=t.indexOf("Safari")>-1,this.IsOnPC=!this.IsOnMobile,"undefined"==typeof wx||"undefined"!=typeof ks&&"undefined"!=typeof kwaigame||"undefined"!=typeof tt?"undefined"!=typeof qg&&t.indexOf("OPPO")>-1?(this.L("平台:Oppo"),this.Ctrl=window.qg,this.PfType=a.PLAT.Oppo,this.IsOppo=!0,this.IsQGMiniGame=!0,this.initPlatform()):t.indexOf("HUAWEI")>-1&&("undefined"!=typeof hbs||"undefined"!=typeof qg)?(this.L("平台:华为"),this.Ctrl=window.qg?window.qg:window.hbs,this.PfType=a.PLAT.HuaWei,this.IsHuaWei=!0,this.initPlatform()):"undefined"!=typeof qg&&(t.indexOf("VVGame")>-1||t.indexOf("vivo")>-1)?(this.L("平台:Vivo"),this.Ctrl=window.qg,this.PfType=a.PLAT.Vivo,this.IsVivo=!0,this.IsQGMiniGame=!0,this.initPlatform(),console.log("平台:Vivo 成功")):"undefined"!=typeof swan&&t.indexOf("SwanGame")>-1?(this.L("平台:百度"),this.Ctrl=window.swan,this.PfType=a.PLAT.Baidu,this.IsBaidu=!0,this.initPlatform()):t.indexOf("4399")>-1?this.L("平台:4399"):"undefined"!=typeof qu_tou_tiao?this.L("平台:趣头条"):t.indexOf("360")>-1?this.L("平台:360"):"undefined"!=typeof momo?this.L("平台:陌陌"):t.indexOf("QuickGame")>-1?(this.L("平台:小米"),this.Ctrl=window.qg,this.PfType=a.PLAT.Xiaomi,this.IsXiaomi=!0,this.IsQGMiniGame=!0):"undefined"!=typeof mz&&t.indexOf("MZ-")>-1?(this.L("平台:魅族"),this.Controller2=window.mz,this.Ctrl=window.qg,this.PfType=a.PLAT.Meizu,this.IsMeizu=!0):"undefined"!=typeof uc?(this.L("平台:UC"),this.Ctrl=window.uc,this.PfType=a.PLAT.UC,this.IsUC=!0,this.initPlatform()):"undefined"!=typeof wuji?(this.L("平台:Wifi万能钥匙"),this.Ctrl=window.wuji,this.PfType=a.PLAT.Wuji,this.IsWuji=!0,this.initPlatform()):"undefined"!=typeof kwaigame||"undefined"!=typeof ks?(this.L("平台:快手平台"),this.Ctrl=window.ks?window.ks:window.kwaigame,this.PfType=a.PLAT.kwg,this.Iskwaigame=!0,this.initPlatform()):"undefined"!=typeof hg?(this.L("平台:Hago"),this.Ctrl=window.hg,this.PfType=a.PLAT.Hago,this.IsHago=!0,this.initPlatform()):"undefined"!=typeof my&&t.indexOf("AlipayMiniGame")>-1?(this.Ctrl=window.my,this.PfType=a.PLAT.Alipay,this.IsAlipay=!0):"undefined"!=typeof document&&t.indexOf("Mobile")<0?(this.L("平台:"),this.Ctrl=window,this.PfType=a.PLAT.Web,this.IsWeb=!0):"undefined"!=typeof document&&t.indexOf("Mobile")>0&&(this.Ctrl=window,this.PfType=a.PLAT.Web,this.IsWeb=!0):"undefined"!=typeof qq&&(t.indexOf("MiniGame")>-1||t.indexOf("qqdevtools")>-1)?(this.L("平台:QQ"),this.Ctrl=window.qq,this.PfType=a.PLAT.QQ,this.IsQQ=!0,this.IsQQMiniGame=!0,this.initPlatform()):t.indexOf("wechatdevtools")>-1?(this.L("平台:微信开发者工具"),this.Ctrl=window.wx,this.Ctrl&&this.Ctrl.getSystemInfoSync&&(this.IsSimulator="devtools"==this.Ctrl.getSystemInfoSync().platform),this.PfType=a.PLAT.Wechat,this.IsWechat=!0,this.initPlatform()):t.indexOf("MiniGame")>-1&&(this.L("平台:微信"),this.Ctrl=window.wx,this.Ctrl&&this.Ctrl.getSystemInfoSync&&(this.IsSimulator="devtools"==this.Ctrl.getSystemInfoSync().platform),this.PfType=a.PLAT.Wechat,this.IsWechat=!0,this.initPlatform()),"undefined"!=typeof tt&&(t.indexOf("MiniGame")>-1||t.indexOf("bytedanceide")>-1)&&(this.L("平台:今日头条"),this.Ctrl=window.tt,this.PfType=a.PLAT.Toutiao,this.IsToutiao=!0,this.initPlatform()),window[s.StorageApt.SDK_CONFIG]||console.error("缺少配置:"+s.StorageApt.SDK_CONFIG)}L(...t){this.Debug&&console.log(...t)}CreateVdAd2(t,e,i,s){}ShowVdAd2(t,e,i,s){}ShareAppMsg(t,e,i,s,n,r){}CreateNativeAd(t,e,i,s){}ShowNativeAd(t){}ClickNativeAd(t,e){}HasShortcut(t,e,i,s){}InstallShortcut(t,e,i,s,n){}ExitGame(){}InitEngine(){this.IsCocosEngine=window.cc&&"object"==typeof window.cc&&"object"==typeof window.cc.sys,this.IsLayaEngine=window.Laya&&"object"==typeof Laya&&"function"==typeof Laya.Browser,this.IsEgretEngine=window.egret&&"object"===window.egret&&"object"==typeof window.egret.sys}initPlatform(){var t=null;let e=null;try{t=this.Ctrl.getSystemInfoSync()}catch(e){t=this.Ctrl.getSystemInfo({response:e=>{t=e}})}try{(e=this.PfType==a.PLAT.Vivo?t.osType:t.platform)&&("ios"==e?this.IsOnIOS=!0:"android"==e?this.IsOnAndroid=!0:"devtools"==e&&(this.IsSimulator=!0)),this.platfrom=t}catch(t){n.SDK.L("获取系统信息失败")}}Init(){return this.initSDK(),this.GetSysIf(this,t=>{try{this.SysInfo=t,t.brand&&(this.Brand=t.brand),t.model&&(this.Model=t.model),t.appName&&(this.AppName=t.appName);let e="";t.screenWidth&&t.screenHeight&&(e=t.screenWidth+"x"+t.screenHeight),this.Resolution=t.resolution||e}catch(t){this.Resolution=""}}),!0}Login(t,e,i){throw new Error("Login Method not implemented.")}HasAPI(t){let e=this.Ctrl[t];return!(!e||void 0===e||"function"!=typeof e)||(this.Warn("platform not exists api:"+t),!1)}HasAPI2(t){let e=this.Controller2[t];return!(!e||void 0===e||"function"!=typeof e)||(this.Warn("platform not exists api:"+t),!1)}LaunchInfo(){if(!this.HasAPI("getLaunchOptionsSync"))return;let t=this.Ctrl.getLaunchOptionsSync();return n.SDK.L("SDK--\x3e> LaunchInfo:"+JSON.stringify(t)),t}GetSysIf(t,e){n.SDK.L("SDK--\x3e>  SDKPlatform GetSystemInfoSync()")}GetCapsulePoint(t,e){}OnFrontend(t,e){}OnBackend(t,e){}OnError(t,e){if(!this.HasAPI("onError"))return;let i=this;this.Ctrl.onError(s=>{n.SDK.C(t,e,s),i.Warn("onError:",s),o.ClientLogSystem.Me().setErrorStack(s,{})})}CFBBtn(t,e){}SFBBtn(t){}ExitMP(){}TriggerGC(){}OnShare(t){}NToMP(t,e,i,s,n,r){}CreateBnAd(t,e,i,s,n,r,o){}RefBnAd(){}DstyBnAd(){this.BnAd&&(this.BnAd.destroy(),this.BnAd=null)}BnAdV(t){}ChangeBnAdStyle(t){this.BnAd&&t&&(t.left&&(this.BnAd.style.left=t.left),t.top&&(this.BnAd.style.top=t.top),t.width&&(this.BnAd.style.width=t.width),t.height&&(this.BnAd.style.height=t.height),this.BnAd._style=t,this.BnStyle=t)}CreateVdAd(t,e,i,s,n){}ShowVdAd(t,e,i){}CreateIntttAd(t,e,i,s,n){}ShowIntttAd(t,e){}ClearIntttAd(){}GetUserInfo(t,e,i){this.HasAPI("getUserInfo")?this._Author("scope.userInfo",this,s=>{this.Ctrl.getUserInfo({withCredentials:!1,lang:"zh_CN",success:i=>{n.SDK.L("YDHW getUserInfo:"+JSON.stringify(i)),i.userInfo&&n.SDK.C(t,e,i.userInfo)},fail:e=>{n.SDK.C(t,i,e)}})},()=>{t&&i&&i.call(t)}):t&&i&&i.call(t)}CreateUIBtn(t,e,i,s){}ShowUIBtn(){this.UIBtn&&this.UIBtn.show()}HideUIBtn(){this.UIBtn&&this.UIBtn.hide()}DestroyUIBtn(){this.UIBtn&&(this.UIBtn.offTap(),this.HideUIBtn(),this.UIBtn.destroy(),this.UIBtn=null)}VibrateShort(){}VibrateLong(){}SetUserCloudStorage(t){}PostMessage(t){}CheckUpdate(){}GetNetworkType(t,e){}CreateVideo(t){return null}LoadSubpackage(t,e){return null}ShowLoading(){}HideLoading(){}ShowShare(t){}ShowModal(t){}_Author(t,e,i,s){if(!this.HasAPI("getSetting"))return void(e&&s&&s.call(e));if(!this.HasAPI("authorize"))return void(e&&s&&s.call(e));let r=this;this.Ctrl.getSetting({success(o){o.authSetting[t]?n.SDK.C(e,i,o):r.Ctrl.authorize({scope:t,success(t){n.SDK.C(e,i,t)},fail(){n.SDK.C(e,s,"No authority")}})}})}Hook(t,e,i){try{let s=this.Ctrl[t];Object.defineProperty(this.Ctrl,t,{writable:!0}),this.Ctrl[t]=function(){let n=arguments.length,r=Array(n);for(let t=0;t<n;t++)r[t]=arguments[t];let o=s.apply(this,r);if("Function"==Object.prototype.toString.call(t).slice(8,-1))return i.call(e,r,o)},Object.defineProperty(this.Ctrl,t,{writable:!1}),this.Log("Hook Success name:"+t)}catch(e){this.Log("Hook Exception:"+e+" name:"+t)}}readgo(){}Pay(t,e,i,s){}willClose(){}Log(t,...e){this.IsDebug&&r.LogUtility.Me().L(h+this.Name,t,null,e)}Debug(t,...e){this.IsDebug&&r.LogUtility.Me().D(h+this.Name,t,null,e)}Info(t,...e){this.IsDebug&&r.LogUtility.Me().I(h+this.Name,t,null,e)}Warn(t,...e){this.IsDebug&&r.LogUtility.Me().W(h+this.Name,t,null,e)}Error(t,...e){this.IsDebug&&r.LogUtility.Me().E(h+this.Name,t,null,e)}}},"./sdk/Commerce/OppoC.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"OppoErrInfo",function(){return d}),i.d(e,"OppoP",function(){return S}),i.d(e,"OppoC",function(){return c});var s=i("./sdk/Mgr/CommerceMgr.ts"),n=i("./sdk/SDK/Declare.ts"),r=i("./sdk/SDK/EventDef.ts"),o=i("./sdk/Config/SDKConfig.ts"),a=i("./fw/Utility/TimerUtility.ts"),h=i("./sdk/Base/SDKP.ts"),l=i("./fw/Assist/StorageApt.ts");class d{}class S extends h.SDKP{constructor(){super(),this._NativeAd=null,this._BannerAd=null,this._VideoAd=null,this._InterstitialAd=null,this._IsShowBannerAd=!1,this._BannerReflashTime=60,this._LastCreatBannerTime=0,this._LastCreatNativeTime=0,this._BannerCount=0,this._NativeCount=0,this._LastCreatBannerPushTime=0,this._LastCreatBoxPushTime=0,this._NativeAdList=[],this._NativeObjList=[],this._NativeDataList=[],this._NativeClick=[],this._NativeIdList=[],this._IsFastClickCreatNative=!0,this._isPermitCreatNative=!0,this._isLoadNative=[],this.Name=this.constructor.name}Init(){return!!super.Init()&&(l.StorageApt.WriteString=((t,e)=>{localStorage.setItem(t,e)}),l.StorageApt.WriteObject=((t,e)=>{localStorage.setItem(t,JSON.stringify(e))}),l.StorageApt.ReadString=localStorage.getItem,l.StorageApt.ReadObject=(t=>JSON.parse(localStorage.getItem(t))),l.StorageApt.DeleteObject=(t=>{localStorage.removeItem(t)}),this.Ctrl.setEnableDebug({enableDebug:n.SDK.Debug}),!0)}OnFrontend(t,e){this.HasAPI("onShow")&&this.Ctrl.onShow(i=>{n.SDK.C(t,e,i)})}OnBackend(t,e){this.HasAPI("onHide")&&this.Ctrl.onHide(i=>{n.SDK.C(t,e,i)})}GetSysIf(t,e){if(!this.HasAPI("getSystemInfoSync"))return;n.SDK.L("Oppo GetSystemInfoSync()");let i=this.Ctrl.getSystemInfoSync();if(i&&void 0===i)return e.call(t,i),i;this.Ctrl.getSystemInfo({success:function(i){e.call(t,i)},fail:function(t){n.SDK.W("error:"+t)},complete:function(t){}})}GetCapsulePoint(t,e){if(this.HasAPI("getMenuButtonBoundingClientRect")){var i=this.Ctrl&&this.Ctrl.getMenuButtonBoundingClientRect();n.SDK.L("oppoPlatform GetSystemInfoSync()",i),e.call(t,i)}}NToMP(t,e,i,s,r,o){this.HasAPI("navigateToMiniGame")&&this.Ctrl.navigateToMiniGame({pkgName:i,path:e,success:function(){s&&r&&r.call(s)},fail:function(t){n.SDK.W("navigateToMiniGame"+JSON.stringify(t)),s&&o&&o.call(s)}})}CreateBnAd(t,e,i,s,r,o){if(this.COnRsBnAd=r,!this.HasAPI("createBannerAd"))return;this.OnRsBnAd=o,this.BnAdId=e,this.IsMTBnAd=i;let a=null;s?(this.BnStyle=s,a={adUnitId:e,style:s}):a={adUnitId:e},this.DstyBnAd(),this.BnAd=this.Ctrl.createBannerAd(a),this._BannerCount+=1,n.SDK.L("sdk-----》》》Banner创建"+`第${this._BannerCount}次`);let h=this;this.BnAd.onResize(t=>{h.OnRsBnAd&&this.COnRsBnAd&&this.OnRsBnAd.call(this.COnRsBnAd,t),n.SDK.CME().SwitchLog&&this.Log("CreateBannerAd onResize:"+`left=${h.BnStyle.left} top=${h.BnStyle.top} width=${h.BnStyle.width} height=${h.BnStyle.height}`)})}RefBnAd(){this.BnAd?(n.SDK.L("sdk-----》》》Banner.show"),this.BnAd.show()):this.Warn("RefreshBannerAd banner ad is not exists")}DstyBnAd(){this.BnAd&&(this.BnAd.destroy(),this.BnAd=null)}BnAdV(t){this.BnAd?!0===t?(this.IsSBnAd=!0,this.BnAd&&this.BnAd.show()):(this.BnAd&&this.BnAd.hide(),this.IsSBnAd=!1):this.Warn("SetBannerVisible banner ad is not exists")}ChangeBnAdStyle(t){if(!this.BnAd||!t)return;let e=(new Date).getTime();e-this._LastCreatBannerTime>(this.reqNativeLimit?1e3*this.reqNativeLimit:45e3)&&(this._LastCreatBannerTime=e,t.left&&(this.BnAd.style.left=t.left),t.top&&(this.BnAd.style.top=t.top),t.width&&(this.BnAd.style.width=t.width),t.height&&(this.BnAd.style.height=t.height),this.BnAd._style=t,this.BnStyle=t,n.SDK.L("更改尺寸触发刷新"))}CreateVdAd2(t,e,i,s){if(!this.HasAPI("createRewardedVideoAd"))return;n.SDK.L("CreateRewardedVideoAd adUnitId="+t);let r=this;if(!t)return r.Warn("videoAd 激励视频 ID出错"),r.IsShowVdAd=!1,void n.SDK.C(e,s,!1);let o=function(t){r.Warn("videoAd onError:",t),r.IsShowVdAd=!1,r.removeVideoAd(),n.SDK.C(e,s,t)},a=function(t){r.IsShowVdAd=!1,r.removeVideoAd(),i.call(e,t)};this.VdAd&&(this.VdAd.offError(o),this.VdAd.offClose(a),this.VdAd.destroy(),this.VdAd=null),this.VdAd=this.Ctrl.createRewardedVideoAd({adUnitId:t}),this.VdAdId=t,this.VdAd&&(n.SDK.L("设置视频广告加载成功回调"),this.VdAd.onError(o),this.VdAd.onClose(a))}removeVideoAd(){this.VdAd.destroy(),this.VdAd=null}ShowVdAd2(t,e,i,s){if(!this.VdAd)return void this.Error("VideoAd is null");this.IsShowVdAd=!0;let n=this,r=function(){n.Log("VideoAd onLoad"),n.IsShowVdAd=!0,t&&e&&e.call(t,!0),t&&i&&i.call(t),n.VdAd.show().then(()=>{}).catch(e=>{n.IsShowVdAd=!1,t&&s&&s.call(t,e),n.removeVideoAd()})};this.VdAd&&(this.VdAd.offLoad(r),this.VdAd.onLoad(r)),this.VdAd.load()}VibrateShort(){this.HasAPI("vibrateShort")&&this.Ctrl.vibrateShort()}VibrateLong(){this.HasAPI("vibrateLong")&&this.Ctrl.vibrateLong()}GetNetworkType(t,e){this.HasAPI("getNetworkType")&&(e=e&&void 0!==e?e:null,this.Ctrl.getNetworkType({success:function(t){n.SDK.L("res.networkType="+t.networkType),e&&e(t.networkType)},fail:function(t){n.SDK.L("res.errMsg="+t.errMsg)},complete:function(t){}}))}CreateIntttAd(t,e,i){if(!this.HasAPI("createInterstitialAd"))return;this.IntttAd&&(this.IntttAd.Destroy(),this.IntttAd=null),this.IntttAd=this.Ctrl.createInterstitialAd({adUnitId:t}),this.IntttAdId=t;let s=this;this.IntttAd.onLoad(()=>{this.IntttAd.show(),s.Log("InterstitialAd onLoad")}),this.IntttAd.onError(t=>{s.Warn("InterstitialAd onError:",t),n.SDK.C(e,i,!1)}),this.IntttAd.onClose(()=>{n.SDK.C(e,i,!0)}),this.IntttAd.load()}CreateNativeAd(t,e,i,s){if(!this.HasAPI("createNativeAd"))return;var r=this;let o;r._NativeID=t,r.reqNativeLimit=window.reqNativeLimit;var a=r.reqNativeLimit?1e3*r.reqNativeLimit:25e3;if(r._IsFastClickCreatNative)if(r._IsFastClickCreatNative=!1,setTimeout(()=>{r._IsFastClickCreatNative=!0},3e3),-1==r._NativeIdList.indexOf(t)&&r._NativeIdList.push(t),r._isPermitCreatNative){setTimeout(()=>{r._isPermitCreatNative=!0,n.SDK.L("--_isPermitCreatNative---允许调用平台接口创建------"),n.SDK.L("--请勿滥用接口,为避免因频繁调用引起出现无广告的情况,SDK底层限制调用平台接口-修改时间间隔请知会运营团队----")},a),r._isPermitCreatNative=!1,this._NativeObjList[this._NativeID]&&(this._NativeObjList[this._NativeID].destroy(),this._NativeObjList[this._NativeID]=null,this._NativeDataList[this._NativeID]=null,this._NativeClick[this._NativeID]=!1),o=r.Ctrl.createNativeAd({adUnitId:t}),n.SDK.C(e,i);let h=0,l=i=>{if(i&&i.adList){h+=1;let a=i.adList;r._NativeObjList[t]=o,r._NativeDataList[t]=a,n.SDK.C(e,s,a),r._isLoadNative[t]=!0,r.Log("NativeAd onLoad"),n.SDK.L("---load成功--"),r._NativeID=t}else{n.SDK.L("---load失败 空广告--");let t=!1;for(const i of r._NativeIdList)if(r._NativeDataList[i]&&r._NativeDataList[i]&&!t)return r._NativeID=i,n.SDK.C(e,s,r._NativeDataList[i]),n.SDK.L("---load失败 空广告-查缓存返回-"),r._isPermitCreatNative=!1,void(t=!0);t||(n.SDK.C(e,s,null),n.SDK.W("----load失败 空广告 -返回空-")),n.SDK.W("返回空广告,请先去执行reportAdShow和reportAdClick使用上一条广告！")}},d=i=>{console.info("--onError -",JSON.stringify(i));let o=!1;for(const t of r._NativeIdList)r._NativeDataList[t]&&r._NativeDataList[t]&&!o&&(r._NativeID=t,n.SDK.C(e,s,r._NativeDataList[t]),r._isPermitCreatNative=!1,n.SDK.L("-onError ----返回缓存"),o=!0);o||(n.SDK.C(e,s,null),n.SDK.L("-onError ----返回空"),r.Warn("NativeAd onError:",i)),r._isLoadNative[t]=!1};o.offLoad(l),o.offError(d),o.onLoad(l),o.onError(d),o.load(),n.SDK.L("Native-load ----执行一次加载广告")}else{let t=!1;for(let i of r._NativeIdList)if(r._NativeDataList[i]&&r._NativeDataList[i]&&!t){const o=i;return r._NativeID=o,n.SDK.L("-间隔时间太短------查找本地缓存广告-返回ID对应缓存-"),n.SDK.C(e,s,r._NativeDataList[i]),void(t=!0)}if(!t)return n.SDK.L("-间隔时间太短---isReturn----无本地缓存广告-返回空"),void n.SDK.C(e,s,null)}}ShowNativeAd(t){let e=this._NativeDataList[this._NativeID],i=this._NativeObjList[this._NativeID];e&&i?i.reportAdShow({adId:e[0].adId}):n.SDK.L("Native-上报曝光 ----当前无广告,请勿烂用接口")}ClickNativeAd(t){let e=this._NativeDataList[this._NativeID],i=this._NativeObjList[this._NativeID];e&&i?i.reportAdClick({adId:e[0].adId}):n.SDK.L("Native-上报点击 ----当前无广告,请勿烂用接口")}HasShortcut(t,e,i,s){let r="hasShortcutInstalled";this.HasAPI(r)&&this.Ctrl.hasShortcutInstalled({success:function(i){n.SDK.L(r+" result:"+i),t&&e.call(t,i)},fail:function(e){n.SDK.W(r+" error:"+e),t&&i.call(t,e)},complete:function(){t&&s.call(t)}})}InstallShortcut(t,e,i,s){let r="installShortcut";this.HasAPI(r)&&this.Ctrl.installShortcut({success:function(){n.SDK.L(r+" success"),t&&e&&e.call(t)},fail:function(e){n.SDK.W(r+" error:"+e),n.SDK.C(t,i,e)},complete:function(){t&&s&&s.call(t)}})}CreateGameBanner(t,e,i){if(this.Ctrl.getSystemInfoSync().platformVersionCode>=1076){let s=(new Date).getTime()-this._LastCreatBannerPushTime;(!this.GameBanner||s>2e4)&&(this.DstyGameBnAdV(),this.GameBanner=qg.createGameBannerAd({adUnitId:t}),this.GameBanner.onError(t=>{this.Log(JSON.stringify(t))}),this.GameBanner.onLoad(()=>{n.SDK.C(e,i,!0),this._LastCreatBannerPushTime=(new Date).getTime()}))}else n.SDK.C(e,i,!1),n.SDK.L("快应用平台版本号低于1076，暂不支持互推盒子相关 API")}DstyGameBnAdV(){this.GameBanner&&(this.GameBanner.offError(),this.GameBanner.destroy(),this.GameBanner=null)}GameBnAdV(t,e){this.GameBanner||this.CreateGameBanner(e,this,function(){}),n.SDK.L(JSON.stringify(this.GameBanner)),!0===t?(this.IsSGBnad=!0,this.GameBanner&&this.GameBanner.show()):(this.GameBanner&&this.GameBanner.hide(),this.IsSGBnad=!1)}CreateGamePortalAd(t,e,i){if(this.Ctrl.getSystemInfoSync().platformVersionCode>=1076){let s=(new Date).getTime()-this._LastCreatBoxPushTime;!this.GamePortaAd||s>2e4?(this.GamePortaAd&&this.DstyGamePortalAd(),this.GamePortaAd=qg.createGamePortalAd({adUnitId:t}),this.GamePortaAd.load().then(()=>{this._LastCreatBoxPushTime=(new Date).getTime(),n.SDK.C(e,i,!0)}).catch(function(t){n.SDK.C(e,i,!1),n.SDK.L("load fail: +"+JSON.stringify(t))}),this.GamePortaAd.onError(t=>{n.SDK.C(e,i,!1)})):n.SDK.C(e,i,!0)}else n.SDK.C(e,i,!1),n.SDK.L("快应用平台版本号低于1076，暂不支持互推盒子相关 API")}ShowGamePortalAd(t,e,i){this.GamePortaAd?(this.GamePortaAd&&this.GamePortaAd.show().then(function(){e&&n.SDK.C(t,e,!0)}).catch(function(i){e&&n.SDK.C(t,e,!1)}),this.GamePortaAd&&this.GamePortaAd.onClose(()=>{i&&n.SDK.C(t,i,!0)}),this.IsSGBnad=!1):this.Warn("SetBannerVisible banner ad is not exists")}DstyGamePortalAd(){this.GamePortaAd.offError(),this.GamePortaAd.destroy().then(function(){this.GamePortaAd=null}).catch(function(t){n.SDK.L("destroy fail with:"+t.errCode+","+t.errMsg)})}ExitGame(){let t="exitApplication";this.HasAPI(t)&&this.Ctrl.exitApplication({success:()=>{n.SDK.L(t+" success")},fail:e=>{n.SDK.W(t+" error:"+e)},complete:()=>{n.SDK.L(t+" complete")}})}Pay(t,e,i){this.Ctrl.pay({appId:t.appId,token:t.token,timestamp:t.timestamp,orderNo:t.orderNo,paySign:t.paySign,success:function(t){n.SDK.L(JSON.stringify(t.data)),e&&e(!0)},fail:function(t){n.SDK.L(JSON.stringify(t.data)),i&&i(!1)},complete:function(){n.SDK.L("oppo pay complete")}})}}class c extends s.CommerceMgr{constructor(){super(),this.P=null,this._LastTimeRefreshBannerAd=0,this._BannerReflashTime=60,this._LastCreatBannerTime=0,this._LastCreatNativeTime=0,this._resCount=0,this.Name="YDHW-SDK:"+this.constructor.name}Init(){super.Init(),this.NativeAdUnitIdList=this.Config.native_ad_unit_id_list,this.NativeAdUnitIdList&&void 0!==this.NativeAdUnitIdList||n.SDK.W("YDHW_CONFIG.native_ad_unit_id_list not exists"),this.P.OnFrontend(this,t=>{this.Log("OnFrontend"),this._ShareAppInfo&&this.Strategy&&this.Strategy.GetSRlt(this._ShareAppInfo,this,t=>{this.Warn("本次分享"),this._CallerShareCardBack&&this._EvtOnShareCardBack&&this._EvtOnShareCardBack.call(this._CallerShareCardBack,t),this._EvtOnShareCardBack=null}),this.Invoke(10069,t)}),this.P.OnBackend(this,t=>{this.Log("OnBackend"),this.Invoke(10070,t)}),this.DM(10081,this,(t,e)=>{n.SDK.L("Oppo登陆");let i=this;this.P.Ctrl.login({success(s){i.Code=s.token,n.SDK.L("登陆信息:"+JSON.stringify(s)),i._InnerLogin(t,e)},fail(t){n.SDK.E("登录错误：code=",t.errCode)},complete(t){n.SDK.L("complete:",t)}}),n.SDK.API().Invoke(10081)}),this.DM(10034,this,(t,e,i,s)=>{this._CreateBannerAd(!1,t,e,null,i,s,null),n.SDK.API().Invoke(10034)}),this.DM(10035,this,(t,e,i,s)=>{this._CreateBannerAd(!0,t,e,null,i,s,null),n.SDK.API().Invoke(10035)}),this.DM(10036,this,(t,e,i,s,r,o)=>{this._CreateBannerAd(!1,t,e,i,s,r,o),n.SDK.API().Invoke(10036)}),this.DM(10037,this,t=>{this.P.ChangeBnAdStyle(t),n.SDK.API().Invoke(10037)}),this.DM(10038,this,()=>{this.Log("ShowBannerAd");let t=(new Date).getTime(),e=this._LastTimeRefreshBannerAd||t,i=!1,s=!1,h=0,l=!1;if(this.BnRefCfg&&(s=this.BnRefCfg.IsOn||!1,h=this.BnRefCfg.Interval||o.SDKCfg.DIFRefreshBannerAd),this.P.BnAd){s&&(i=this._IsSmallBannerAd||!1);let n=t-e>=1e3*o.SDKCfg.DIFRefreshBannerAd;this._LastTimeRefreshBannerAd=t,s&&n&&(this.Log("ShowBannerAd CreateBannerAd"),l=!0,this._CreateBannerAd(i,this.P.IsMTBnAd,!0,this.P.BnStyle,this.P.OnRsBnAd,null,null)),l||(this.P.BnAdV(!0),this.Invoke(10002,r.TP_AD.SHOW,this.P.BnAdId),this._needShowBannerAd=!1)}!l&&s&&(this.Log(`将在${h}秒后重新创建banner`),a.default.RemoveDelayTimer(this._BannerAdDelayTimerId),this._BannerAdDelayTimerId=a.default.Delay(1e3*h,this,()=>{this.P.IsSBnAd&&this._CreateBannerAd(i,this.P.IsMTBnAd,!0,this.P.BnStyle,this.P.OnRsBnAd,null,null)})),n.SDK.API().Invoke(10038)}),this.DM(10039,this,()=>{this.Log("HideBannerAd"),this.P.BnAdV(!1),this._needShowBannerAd=!1,a.default.RemoveDelayTimer(this._BannerAdDelayTimerId),this._BannerAdDelayTimerId="",n.SDK.API().Invoke(10039)}),this.DM(10016,this,t=>{if(this.P.BnAd){if(this.BnRefCfg&&this.BnRefCfg.IsForceRefresh){let e=(new Date).getTime();e-(this._LastTimeRefreshBannerAd||e)>=1e3*(this.BnRefCfg.MinimumInterval||o.SDKCfg.DIFRefreshBannerAd)&&(this.P.IsSBnAd&&this._IsSmallBannerAd?this.Invoke(10035,t,!0,this,()=>{}):this.P.IsSBnAd?this.Invoke(10034,t,!0,this,t=>{}):this._LastTimeRefreshBannerAd=e-(1e3*this.BnRefCfg.MinimumInterval+1e3))}}else this.Warn("BannerAd is null");n.SDK.API().Invoke(10016)}),this.DM(10041,this,t=>{if(this.VideoAdUnitIdList&&0!=this.VideoAdUnitIdList.length){if(!this.P.VdAd){let e=this,i=t||Math.floor(Math.random()*this.VideoAdUnitIdList.length),s=this.VideoAdUnitIdList[i];this.P.CreateVdAd2(s,this,t=>{t&&t.isEnded||void 0===t?(e.Log("视频播放完成"),e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,r.VIDEO_P_T.FINISH),e._AddUnlockVideoLevelNumber(e._UnlockCustomNumber),e.Invoke(10003,r.TP_AD.PLAY_FINISH,s),e._IsAddPower&&e._AddPowerByVideo()):(e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,r.VIDEO_P_T.CANCEL),e.Log("视频播放中途取消"),e.Invoke(10003,r.TP_AD.PLAY_CANCEL,s)),e._UnlockCustomNumber=null,e._EvtOnCloseRewardVideoAd=null,e._showVideoAd=!1},t=>{e.Log("RewardVideoAd onError:",t),e.Invoke(10003,r.TP_AD.LOAD_FAIL,s),e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,r.VIDEO_P_T.FAIL),e._EvtOnCloseRewardVideoAd=null,e._UnlockCustomNumber=null,e._showVideoAd=!1}),this.Invoke(10003,r.TP_AD.CREATE,s)}}else this.Error("VideoAdUnitIdList is empty.");n.SDK.API().Invoke(10041)}),this.DM(10042,this,(t,e,i,s,o)=>{let a=this;this._IsRewardVideoAdFinish=!1,this._UnlockCustomNumber=t,this._CallerRewardVideoAd=i,this._EvtOnCloseRewardVideoAd=s,this._IsAddPower=e||!1,(this.P.VdAd||(this.Invoke(10041,o||null),this.P.VdAd))&&(this.P.ShowVdAd2(this,()=>{a._IsRewardVideoAdFinish=!0,a.Invoke(10003,r.TP_AD.LOAD_SUCCESS,a.P.VdAdId)},()=>{a.Log("视频播放成功"),a._showVideoAd=!0,a._IsRewardVideoAdFinish=!0,a.Invoke(10003,r.TP_AD.SHOW,a.P.VdAdId),a._CallerRewardVideoAd&&a._EvtOnCloseRewardVideoAd&&a._EvtOnCloseRewardVideoAd.call(a._CallerRewardVideoAd,r.VIDEO_P_T.SHOW)},()=>{a.Error("视频播放失败"),a._CallerRewardVideoAd&&a._EvtOnCloseRewardVideoAd&&a._EvtOnCloseRewardVideoAd.call(a._CallerRewardVideoAd,r.VIDEO_P_T.FAIL),a._EvtOnCloseRewardVideoAd=null,a._showVideoAd=!1}),n.SDK.API().Invoke(10042))}),this.DM(60001,this,(t,e)=>{let i=Math.floor(Math.random()*this.GameBoxBannerList.length),s=this.GameBoxBannerList[i];s?n.SDK.L("当前执行创建BannerPushId为：",s):n.SDK.W("广告ID不存在，请检查配置！"),this.P.CreateGameBanner(s,t,e),n.SDK.API().Invoke(10034)}),this.DM(60002,this,()=>{let t=Math.floor(Math.random()*this.GameBoxBannerList.length),e=this.GameBoxBannerList[t];e?n.SDK.L("当前执行创建BannerPushId为：",e):n.SDK.W("广告ID不存在，请检查配置！"),this.P.GameBnAdV(!1,e),n.SDK.API().Invoke(60002)}),this.DM(60003,this,()=>{let t=Math.floor(Math.random()*this.GameBoxBannerList.length),e=this.GameBoxBannerList[t];e?n.SDK.L("当前执行创建BannerPushId为：",e):n.SDK.W("广告ID不存在，请检查配置！"),this.P.GameBnAdV(!0,e),n.SDK.API().Invoke(60003)}),this.DM(60004,this,(t,e)=>{let i=Math.floor(Math.random()*this.GameBoxPortalList.length),s=this.GameBoxPortalList[i];this.P.CreateGamePortalAd(s,t,e),n.SDK.API().Invoke(10034)}),this.DM(60005,this,(t,e,i)=>{this.P.ShowGamePortalAd(t,e,i),n.SDK.API().Invoke(60003)}),this.DM(60006,this,(t,e,i)=>{let s={};s.appId=`${this.AppId}`,s.openId=`${this.Code}`,s.timestamp=`${e.timestamp}`,s.productName=`${e.productName}`,s.productDesc=`${e.productDesc}`,s.count=`${e.count}`,s.price=`${e.price}`,s.currency=`${e.currency}`,s.cpOrderId=`${e.cpOrderId}`,s.appVersion=`${this.Version}`,s.engineVersion=`${this.platfromsys.platformVersion}`,n.SDK.Me.Invoke(r.NET_API.OPPaySign,t,s,e=>{e?n.SDK.C(t,i,e):n.SDK.C(t,i,null),n.SDK.API().Invoke(170005)})}),this.DM(60011,this,(t,e,i)=>{let s={};s.appKey=`${e.appKey}`,s.timestamp=`${e.timestamp}`,s.orderNo=`${e.orderNo}`,n.SDK.Me.Invoke(r.NET_API.OPPaySign,t,s,e=>{e?n.SDK.C(t,i,e):n.SDK.C(t,i,null),n.SDK.API().Invoke(170005)})}),this.DM(60007,this,(t,e,i)=>{n.SDK.Me.Invoke(r.NET_API.OPPayResult,t,e,e=>{e?n.SDK.C(t,i,e):n.SDK.C(t,i,null),n.SDK.API().Invoke(170005)})}),this.DM(60008,this,(t,e)=>{n.SDK.Me.Invoke(r.NET_API.OPCreatOrder,t,i=>{i?n.SDK.C(t,e,i):n.SDK.C(t,e,null),n.SDK.API().Invoke(170005)})}),this.DM(60009,this,(t,e,i)=>{let s={};s.appId=e.appId||this.AppId,s.openId=e.openId||this.Code,s.timestamp=e.timestamp,s.sign=e.sign,s.productName=e.productName,s.productDesc=e.productDesc,s.count=e.count,s.price=e.price,s.currency=e.currency,s.cpOrderId=e.cpOrderId,s.appVersion=e.appVersion||this.Version,s.engineVersion=e.engineVersion||this.platfromsys.platformVersion,n.SDK.Me.Invoke(r.NET_API.OpPlaceAnOrder,t,s,e=>{e?n.SDK.C(t,i,e):n.SDK.C(t,i,null),n.SDK.API().Invoke(170005)})}),this.DM(60010,this,(t,e,i)=>{let s,r,o,a,h;r=(new Date).getTime(),s=null,o=null,a=null,h=null;let l={code:0,msg:"",data:!1};this.Invoke(60008,this,a=>{if(0===a.code){s=a.result;let d={timestamp:r,productName:e.productName,productDesc:e.productDesc,count:e.count,price:e.price,currency:"CNY",cpOrderId:s};this.Invoke(60006,this,d,a=>{if(0===a.code){o=a.result;let d={timestamp:r,productName:e.productName,productDesc:e.productDesc,count:e.count,price:e.price,currency:"CNY",cpOrderId:s,sign:o};this.Invoke(60009,this,d,s=>{let o=JSON.parse(s);if("200"===o.code&&o.data.orderNo){h=o.data.orderNo;let s={appKey:e.AppKey,timestamp:r,orderNo:h};this.Invoke(60011,this,s,e=>{if(0===e.code){let s={};s.timestamp=r,s.orderNo=h,s.paySign=e.result,s.token=this.Code,s.appId=this.AppId,this.P.Pay(s,()=>{l.code=0,l.msg="支付成功",l.data=!0,n.SDK.C(t,i,l)},()=>{l.code=1,l.msg="支付失败",l.data=!1,n.SDK.C(t,i,l)})}else l.code=2,l.msg="支付签名获取失败",l.data=!1,n.SDK.C(t,i,l),n.SDK.L("/支付签名获取失败")})}else l.code=3,l.msg="统一下单获取订单失败",l.data=!1,n.SDK.C(t,i,l)})}else l.code=4,l.msg="统一下单签名获取失败",l.data=!1,n.SDK.L("统一下单签名获取失败"),n.SDK.C(t,i,l)})}else l.code=5,l.msg="CP服务器创建订单失败",l.data=!1,n.SDK.L("CP服务器创建订单失败 "),n.SDK.C(t,i,l)})})}_CreateBannerAd(t,e,i,s,o,h,l){if(this.BannerAdUnitIdList&&0!=this.BannerAdUnitIdList.length){let d=(new Date).getTime();if(d-this._LastCreatBannerTime>1e3*this._BannerReflashTime){this._LastCreatBannerTime=d,this.P.BnAd&&(this.P.DstyBnAd(),this.P.IsSBnAd=!1);let S=this;this._needShowBannerAd=!0;let c=Math.floor(Math.random()*this.BannerAdUnitIdList.length),u=this.BannerAdUnitIdList[c];t||this.P.SysInfo.windowWidth;this.P.SysInfo.windowWidth,this.P.CreateBnAd(t,u,e,s,this,l),this.Invoke(10002,r.TP_AD.CREATE,u);let D=this.BnRefCfg&&this.BnRefCfg.IsOn;D&&(this._IsSmallBannerAd=t),this.P.BnAd.onLoad(function(){S.Log("BannerAd onLoad"),S.Invoke(10002,r.TP_AD.LOAD_SUCCESS,u),n.SDK.C(o,h,!0)}),this.P.BnAd.onError(d=>{if(S.Invoke(10002,r.TP_AD.LOAD_FAIL,u),S.Warn("BannerAd onError:",d),this._needShowBannerAd=!1,this.P.IsSBnAd=!1,D){let r=S.BnRefCfg.Interval;S.Log(`将在${r}秒后重新创建banner(调用ylBannerAdHide会取消重试`),a.default.RemoveDelayTimer(S._BannerAdDelayTimerId),S._BannerAdDelayTimerId=a.default.Delay(1e3*r,S,()=>{this.P.IsSBnAd&&S._CreateBannerAd(t,e,i,s,l,o,h)}),n.SDK.C(o,h,!1)}}),this._needShowBannerAd&&i&&S.Invoke(10038)}}else this.Error("BannerAdUnitIdList is empty.")}}},"./sdk/Config/SDKConfig.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"SDKCfg",function(){return s});class s{}s.SceneWhiteList=[],s.DIFRefreshBannerAd=10},"./sdk/Extensions/ClientLogSystem.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"ClientLogSystem",function(){return a});var s=i("./sdk/SDK/Declare.ts"),n=i("./fw/Utility/TimerUtility.ts"),r=i("./src/Utils/TimeUtils.ts");class o{constructor(t,e,i){this.errStack=t,this.logStr=e,this.strDate=i}}class a{constructor(){this._SendErrorStackTimerId="SendErrorStackTimerId",this.stackList=new Array,this.stackTab=new Array}static Me(){return a._Me}setErrorStack(t,e){if(this.hasErrorStack(JSON.stringify(t)))return;let i=r.default.formatDate(new Date,"YYYY-MM-dd hh:mm:ss");this.stackList.push(new o(t,e,i)),this.stackTab.push(JSON.stringify(t)),this.sendErrorStack()}getErrorStack(){return this.stackList.pop()}hasErrorStack(t){return this.stackTab.indexOf(t)>=0}sendErrorStack(){this.stackList&&this.stackList.length>0&&(n.default.RemoveTimer(this._SendErrorStackTimerId),n.default.AddTimer(this._SendErrorStackTimerId,1e3,this,null,()=>{let t=this.getErrorStack();return s.SDK.CME().Invoke(10009,t.errStack,t.logStr,t.strDate),0==this.stackList.length}))}}a._Me=new a},"./sdk/Extensions/CloudAPI.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"EM_CLOUD_API_TYPE",function(){return s}),i.d(e,"CloudAPI",function(){return a});var s,n=i("./sdk/SDK/Declare.ts"),r=i("./sdk/SDK/EventDef.ts"),o=i("./sdk/Model/Data.ts");!function(t){t[t.String=0]="String",t[t.StringArray=1]="StringArray",t[t.StringSet=2]="StringSet",t[t.StringMap=3]="StringMap",t[t.StringRandom=4]="StringRandom"}(s||(s={}));class a{All(){}GetObject(t,e,i){let s=new o.StoreValueReq;s.name=t,s.cmd="get",s.args="",n.SDK.Data.Invoke(r.NET_API.StoreValue,s,this,t=>{n.SDK.C(e,i,JSON.parse(t.value))})}GetString(t,e,i){let s=new o.StoreValueReq;s.name=t,s.cmd="get",s.args="",n.SDK.Data.Invoke(r.NET_API.StoreValue,s,this,t=>{n.SDK.C(e,i,t.value)})}SetObject(t,e,i,s){let a=new o.StoreValueReq;a.name=t,a.cmd="set",a.args=JSON.stringify(e),n.SDK.Data.Invoke(r.NET_API.StoreValue,a,this,t=>{n.SDK.C(i,s,!0===t.value)})}SetString(t,e,i,s){let a=new o.StoreValueReq;a.name=t,a.cmd="set",a.args=e,n.SDK.Data.Invoke(r.NET_API.StoreValue,a,this,t=>{n.SDK.C(i,s,!0===t.value)})}Size(t,e){let i=new o.StoreValueReq;i.cmd="size",n.SDK.Data.Invoke(r.NET_API.StoreValue,i,this,i=>{n.SDK.C(t,e,!0===i.value)})}DeleteObject(t,e,i){let s=new o.StoreValueReq;s.name=t,s.cmd="del",n.SDK.Data.Invoke(r.NET_API.StoreValue,s,this,t=>{n.SDK.C(e,i,!0===t.value)})}StoreValue(t,e,i){n.SDK.Data.Invoke(r.NET_API.StoreValue,t,this,t=>{n.SDK.C(e,i,t)})}}},"./sdk/Extensions/HeartBeatSystem.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"HeartBeatSystem",function(){return r});var s=i("./fw/Utility/TimerUtility.ts"),n=i("./sdk/SDK/Declare.ts");class r{constructor(){this._UploadTimeTimerId="_UploadTimeTimerId",this._timeSpace=3e3,this._timeChange=!1}Init(){}static Me(){return r._Me}StartUploadTime(){this.StopUploadTimer(),s.default.AddTimer(this._UploadTimeTimerId,this._timeSpace,this,null,()=>(n.SDK.CME().Invoke(10012),this._timeChange&&(this._timeChange=!1,this.StartUploadTime()),!1))}SetTimeSpace(t){t&&t>=1&&(this._timeSpace=1e3*t,this._timeChange=!0,n.SDK.L("SetTimeSpace-times:",t))}StopUploadTimer(){s.default.RemoveTimer(this._UploadTimeTimerId)}}r._Me=new r},"./sdk/Extensions/PowerSystem.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"PowerInfo",function(){return o}),i.d(e,"PowerSystem",function(){return a});var s=i("./sdk/SDK/EventDef.ts"),n=i("./sdk/SDK/Declare.ts"),r=i("./fw/Utility/TimerUtility.ts");class o{}class a{constructor(){this._AutoRecoveryTimerId="PowerAutoRecoveryTimerId",this._CPC=null,this._LOPC=null,this._OCD=!1,this._CDT=0,this._CPN=0}Init(){if(!n.SDK.CME().PSysCfg||!1===n.SDK.CME().PSysCfg.IsOn)return void n.SDK.L("Power System is off");let t=(new Date).getTime();this._CPN=n.SDK.Me.GVT(s.SV.TPCounter,-1);let e=n.SDK.Me.GVT(s.SV.LPAddTstamp,t);this._CDT=n.SDK.CME().GVT(s.SV.CDPro,0),this._OCD=n.SDK.CME().GVT(s.SV.OnCD,!1),n.SDK.L("total power:"+this._CPN);let i=n.SDK.CME().PSysCfg.UpperLimit,r=n.SDK.CME().PSysCfg.AutoRecoveryTime,o=this._CPN<0?n.SDK.CME().PSysCfg.DefaultPowerValue:this._CPN;if(o<i&&t!==e){let a=Math.floor((t-e)/1e3);a=a<0?0:a;let h=Math.floor(a/r);o=(o+=h)>i?i:o,n.SDK.L(`timeSpace=${a}, getPowerNum=${h},totalPower=${o}`),n.SDK.Me.SVT(s.SV.LPAddTstamp,(new Date).getTime())}this.SetPower(o,s.P_R_T.None)}SetPower(t,e){if(!1===n.SDK.CME().PSysCfg.IsOn)return void n.SDK.L("PowerSystem is off");let i=n.SDK.Me.GVT(s.SV.TPCounter,0),a=n.SDK.CME().PSysCfg.UpperLimit,h=n.SDK.CME().PSysCfg.AutoRecoveryTime;this._CPN=t>a?a:t<0?0:t,n.SDK.CME().SVT(s.SV.TPCounter,this._CPN),n.SDK.CME().SVT(s.SV.LPAddTstamp,(new Date).getTime()),n.SDK.L("setPower-powerUpper:"+a+",recoveryTime:"+h+",_CurrentPowerNum:"+this._CPN),this._CPN<a?(this._CDT=0==this._CDT?h:this._CDT,r.default.AddTimer(this._AutoRecoveryTimerId,1e3,this,null,()=>this._AddPowerAuto()),this._OCD=!0):(r.default.RemoveTimer(this._AutoRecoveryTimerId),this._OCD=!1,this._CDT=0,n.SDK.CME().SVT(s.SV.CDPro,this._CDT)),n.SDK.CME().SVT(s.SV.OnCD,this._OCD);let l=i!=this._CPN;if(this._CPC&&this._LOPC&&l){let t=new o;t.Type=e,t.PowerNum=this._CPN,t.CountDownPro=this._CDT,t.OnCountDown=this._OCD,this._CPC&&this._LOPC&&this._LOPC.call(this._CPC,t)}}_AddPowerAuto(){this._CDT-=1;let t=this._CPN;if(this._CDT<=0){t+=1;let e=n.SDK.CME().PSysCfg.UpperLimit;return t=t>e?e:t<0?0:t,this.SetPower(t,s.P_R_T.AutoRecovery),t===e}{n.SDK.CME().SVT(s.SV.CDPro,this._CDT);let e=new o;e.Type=s.P_R_T.CountDown,e.PowerNum=t,e.CountDownPro=this._CDT,e.OnCountDown=this._OCD,this._CPC&&this._LOPC&&this._LOPC.call(this._CPC,e)}}GetPower(){return n.SDK.CME().GVT(s.SV.TPCounter,0)}LOnPC(t,e){this._CPC=t,this._LOPC=e}}},"./sdk/Extensions/StatisticSystem.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"StatSystem",function(){return a});var s=i("./sdk/SDK/Declare.ts"),n=i("./sdk/SDK/EventDef.ts"),r=i("./sdk/Model/Default.ts"),o=i("./fw/Utility/TimerUtility.ts");class a{constructor(){this._StatTimerId="_StatTimerId",this.lStatIf=[],this._tSta=!1}Initialize(){}static Me(){return a._Me}RQAd(t,e,i,n,r,o){this.checkStatAdInfo(r,t,e)&&s.SDK.STAC().Invoke(n,t,e,o||null,this,n=>{n||(s.SDK.L(r+" fail type:"+t),this.lStatIf.unshift({type:t,adId:e,sType:i}))})}StatBanner(t,e){this.checkStatAdInfo("StatBanner",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Banner}),this.startT())}StatVideo(t,e,i){this.checkStatAdInfo("StatVideo",t,e)&&(i?this.lStatIf.push({type:t,adId:e,time:i,sType:n.ST_S_TYPE.Video}):this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Video}),this.startT())}StatInterstitial(t,e){this.checkStatAdInfo("StatInterstitial",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Interstitial}),this.startT())}StatGrid(t,e){this.checkStatAdInfo("StatGrid",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Grid}),this.startT())}StatAppBox(t,e){this.checkStatAdInfo("StatAppBox",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.AppBox}),this.startT())}StatBlock(t,e){this.checkStatAdInfo("StatBlock",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Block}),this.startT())}StatNativeAd(t,e){this.checkStatAdInfo("StatNativeAd",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.Native}),this.startT())}StatCustomAd(t,e){this.checkStatAdInfo("StatCustomAd",t,e)&&(this.lStatIf.push({type:t,adId:e,sType:n.ST_S_TYPE.CustomAd}),this.startT())}StatResult(t){null!=t?(this.lStatIf.push({details:t,sType:n.ST_S_TYPE.Result}),this.startT(),s.SDK.API().Invoke(10010)):s.SDK.CME().Warn("StatResult details is null")}RQResult(t){null!=t?s.SDK.STAC().Invoke(n.NET_API.Result,t,this,e=>{e||(s.SDK.L("StatResult fail"),this.lStatIf.unshift({details:t,sType:n.ST_S_TYPE.Result}))}):s.SDK.CME().Warn("StatResult details is null")}StatEvent(t,e,i){if(null==t)return void s.SDK.CME().Warn("StatEvent event is null");let r=(new Date).getTime();i?this.lStatIf.push({event:t,scene:e,time:r,sType:n.ST_S_TYPE.Event,detail:i}):this.lStatIf.push({event:t,scene:e,time:r,sType:n.ST_S_TYPE.Event}),!1!==s.SDK.CME().SwitchEvent||"LayerOn"===e?(this.startT(),s.SDK.API().Invoke(10011)):s.SDK.L("StatEvent is stop by SwitchEvent")}RQEvent(t,e,i,o){if(null==t||null==e||null==i)return;let a=new r.StatisticEventReq;a.event=t,a.scene=e,a.time=i,o&&(a.detail=o),s.SDK.STAC().Invoke(n.NET_API.Event,[a],this,r=>{r||(s.SDK.L("StatEvent fail"),o?this.lStatIf.unshift({event:t,scene:e,detail:o,time:i,sType:n.ST_S_TYPE.Event}):this.lStatIf.unshift({event:t,scene:e,time:i,sType:n.ST_S_TYPE.Event}))})}StatClickOut(t){let e="StatClickOut request";t?t.iconId?t.action?(this.lStatIf.push({request:t,sType:n.ST_S_TYPE.ClickOut}),this.startT(),s.SDK.API().Invoke(10013)):s.SDK.L(e+".action is null"):s.SDK.L(e+".iconId is null"):s.SDK.L(e+" is null")}RQClickOut(t){null!=t&&s.SDK.STAC().Invoke(n.NET_API.ClickOut,t,this,e=>{e||(s.SDK.L("StatClickOut fail"),this.lStatIf.unshift({request:t,sType:n.ST_S_TYPE.ClickOut}))})}checkStatAdInfo(t,e,i){return null==e?(s.SDK.CME().Warn(t+" type is null"),!1):!(!i||""==i)||(s.SDK.CME().Warn(t+" adId is null"),!1)}startT(){if(!this._tSta&&!this.noData()){o.default.RemoveTimer(this._StatTimerId);let t=this;o.default.AddTimer(this._StatTimerId,500,this,null,()=>{if(s.SDK.CME().OnLine&&t.lStatIf&&t.lStatIf.length>0){let e=t.lStatIf.shift();e&&e.sType&&t.RQStat(e)}return this.noData()}),this._tSta=!0}}RQStat(t){switch(t.sType){case n.ST_S_TYPE.Banner:this.RQAd(t.type,t.adId,t.sType,n.NET_API.Banner,"StatBanner");break;case n.ST_S_TYPE.Video:t.time?this.RQAd(t.type,t.adId,t.sType,n.NET_API.Video,"StatVideo",t.time):this.RQAd(t.type,t.adId,t.sType,n.NET_API.Video,"StatVideo");break;case n.ST_S_TYPE.Interstitial:this.RQAd(t.type,t.adId,t.sType,n.NET_API.InterstitialAd,"StatInterstitial");break;case n.ST_S_TYPE.Grid:this.RQAd(t.type,t.adId,t.sType,n.NET_API.GridAd,"StatGrid");break;case n.ST_S_TYPE.Block:this.RQAd(t.type,t.adId,t.sType,n.NET_API.BlockAd,"StatBlock");break;case n.ST_S_TYPE.AppBox:this.RQAd(t.type,t.adId,t.sType,n.NET_API.AppBoxAd,"StatAppBox");break;case n.ST_S_TYPE.Native:this.RQAd(t.type,t.adId,t.sType,n.NET_API.NativeAd,"StatNativeAd");break;case n.ST_S_TYPE.CustomAd:this.RQAd(t.type,t.adId,t.sType,n.NET_API.CustomAd,"StatCustomAd");break;case n.ST_S_TYPE.Event:t.detail?this.RQEvent(t.event,t.scene,t.time,t.detail):this.RQEvent(t.event,t.scene,t.time);break;case n.ST_S_TYPE.Result:this.RQResult(t.details);break;case n.ST_S_TYPE.ClickOut:this.RQClickOut(t.request)}}noData(){return!(this.lStatIf&&0!=this.lStatIf.length||(this._tSta=!1,0))}}a._Me=new a},"./sdk/Extensions/Strategy.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"Strategy",function(){return h});var s=i("./fw/Utility/RandomUtility.ts"),n=i("./sdk/SDK/Declare.ts"),r=i("./sdk/SDK/EventDef.ts"),o=i("./sdk/Model/Default.ts"),a=i("./sdk/Model/User.ts");class h{constructor(t,e){this._ShareSceneConfig={},this._ShareSceneNames=[],this.ModuleFalseList=[],this.ModuleList=[],this.CurrentShareVideoTypes=[],t.length>0&&(this.ModuleList=[],t.forEach(t=>{let e=new a.ShareVideoModule;e._id=t._id,e.channel=t.channel,e.version=t.version,e.module=t.module,e.type=t.type,e.videoNum=t.videoNum,e.shareNum=t.shareNum,e.remarks=t.remarks,e.strategy=t.strategy,e.loopIndex=0,e.logic=t.logicJson&&t.logicJson.length>0?JSON.parse(t.logicJson):null,this.ModuleList.push(e)})),e.length>0&&(this.ModuleFalseList=[],e.forEach(t=>{let e=new a.ShareVideoModuleFalse;e._id=t._id,e.strategyId=0,e.timeId=0,e.count=0,e.strategies=t.strategyjson.length>0?JSON.parse(t.strategyjson):null,e.tips=t.trickJson.length>0?JSON.parse(t.trickJson):null,this.ModuleFalseList.push(e)})),n.SDK.Me.DV(r.SV.SConfig,this._ShareSceneConfig)}SSVd(t,e,i,s){let o=this.GUUS(t,e,!1);if(o)return void n.SDK.C(i,s,o.type);if(this.ModuleList&&0==this.ModuleList.length)return void n.SDK.C(i,s,0);let h=!1;this.ModuleList.every(o=>{if(o.channel===t&&o.module===e&&o.logic){let t=new a.UnUseShareVideoModule;if(t.channel=o.channel,t.module=o.module,h=!0,o.logic.pe&&o.logic.pe.length>0){let e=o.logic.pe.shift();return t.type=e,this.CurrentShareVideoTypes.push(t),n.SDK.C(i,s,e),!1}if(o.logic.loop&&o.logic.loop.length>0&&o.logic.time&&o.logic.time>0){let e=o.logic.loop[o.loopIndex];return o.loopIndex+=1,o.loopIndex>=o.logic.loop.length&&(o.loopIndex=0,o.logic.time-=1),t.type=e,this.CurrentShareVideoTypes.push(t),n.SDK.C(i,s,e),!1}return n.SDK.C(i,s,r.SHARE_T.None),!1}return!0}),!1===h&&n.SDK.C(i,s,r.SHARE_T.None)}GUUS(t,e,i){if(this.CurrentShareVideoTypes.length>0)for(let s=0;s<this.CurrentShareVideoTypes.length;s++){let n=this.CurrentShareVideoTypes[s];if(n.channel==t&&n.module==e){let t=n;return i&&(t=this.CurrentShareVideoTypes.splice(s,1)[0]),n}}return null}USVSty(t,e,i,s){let o=this.GUUS(t,e,!0);o?n.SDK.C(i,s,o.type):n.SDK.C(i,s,r.SHARE_T.None)}ISConf(t,e){let i=this;""===t?e.forEach(t=>{if(i._ShareSceneConfig[t.scene]){let e=i._ShareSceneConfig[t.scene],s=!1;for(let i=0,n=e.length;i<n;i++)if(e[i].id==t.id){s=!0;break}s||e.push(t),i._ShareSceneConfig[t.scene]=e}else{let e=[];e.push(t),i._ShareSceneConfig[t.scene]=e}-1==i._ShareSceneNames.indexOf(t.scene)&&i._ShareSceneNames.push(t.scene)}):this._ShareSceneConfig[t]=e}HasSScene(t){return!!this._ShareSceneConfig[t]}GetSSConf(t){return this._ShareSceneConfig[t]}GetRSConf(){if(this._ShareSceneNames&&this._ShareSceneNames.length>0){var t=Math.floor(Math.random()*this._ShareSceneNames.length);let e=this._ShareSceneNames[t];if(this._ShareSceneConfig[e]){let t=this._ShareSceneConfig[e];if(t&&t.length>0)return t[Math.floor(Math.random()*t.length)]}}return null}GetShareStrategy(t,e){let i=null;return this.ModuleFalseList&&this.ModuleFalseList.length>0&&t&&e&&this.ModuleList&&this.ModuleList.length>0&&(n.SDK.L("getSharingStrategy-channel,module:",t,e),this.ModuleList.every(s=>(s.type&&s.channel&&s.module&&s.channel==t&&s.module==e&&this.ModuleFalseList.forEach(t=>{if(t._id==Number(s.type))return i=t,!1}),!0))),i}GetSRlt(t,e,i){let r=!1,a=new o.ShareBackInfo,h=(new Date).getTime()-t.showTime,l=this.GetShareStrategy(t.channel,t.module);if(l){let t=l.strategyId,e=l.strategies[t],i=l.timeId;if(n.SDK.L("当前策略:",JSON.stringify(e)),e.time&&i<e.time.length){let t=e.time[i],o=e.prob[i];if(n.SDK.L("time:"+JSON.stringify(t)+" , prob:"+JSON.stringify(o)+",time_space:",h),t)if(t.length>1){for(let e=1;e<t.length;e++)if(e==t.length-1&&h>t[e]){let t=o[e];r=s.RandomUtility.Probability(t)}else if(h>=t[e-1]&&h<=t[e]){let t=o[e-1];r=s.RandomUtility.Probability(t)}}else if(1==t.length&&o.length>=1&&h>t[0]){let t=o[0];r=s.RandomUtility.Probability(t)}}i+=1,r?(l.timeId=0,l.count+=1,a.IsSuccess=!0):(i>=e.time.length?(l.timeId=0,l.count+=1):l.timeId=i,a.IsSuccess=!1,a.IsHasStrategy=!0,a.Tips=l.tips),l.count>=e.num&&(l.count=0,l.strategyId=this._GetNextStrategy(l,t)),this._SetSharingStategy(l)}else n.SDK.L("真分享(time_space > 3000)?:"+h),h>3e3?(r=!0,a.IsSuccess=!0):(a.IsSuccess=!1,a.IsHasStrategy=!1);n.SDK.C(e,i,a)}_GetNextStrategy(t,e){let i=e+1;n.SDK.L("nextStrategyId:"+i),i>=t.strategies.length&&(i=0);let s=t.strategies[i];return 0==s.num&&(n.SDK.L("num:"+s.num),i=this._GetNextStrategy(t,i)),i}_SetSharingStategy(t){for(let e=0;e<this.ModuleFalseList.length;e++)if(this.ModuleFalseList[e]._id&&t._id){this.ModuleFalseList[e]=t;break}}GetDMT(t){if(!1===n.SDK.CME().SwitchTouch)return!1;if(n.SDK.CME().DevAcntCfg.IsOn&&n.SDK.CME().DevAcntCfg.Accounts.length>0){let t=n.SDK.CME().DevAcntCfg.Accounts;for(let e=0;e<t.length;e++)if(t[e]==n.SDK.CME().AccountId+"")return n.SDK.L(`In whiteList:${t[e]}`),!0}return!!this._IsHasMistouchTimer()&&this._IsDepthShield(t)}_IsHasMistouchTimer(){if(n.SDK.CME().MisTSwCfg){if(!n.SDK.CME().MisTSwCfg.IsOn)return!0;let t,e,i,s,r,o=n.SDK.CME().MisTSwCfg,a=o.StartTimeHour||0,h=o.StartTimeMinute||0,l=o.EndTimeHour||23,d=o.EndTimeMinute||0,S=new Date,c=S.getHours(),u=S.getMinutes();if(window.ConfigTestMgr){let t=window.ConfigTestMgr.LoginTime;t.length>3&&(c=Number(t.substring(0,2)),u=Number(t.substring(t.length-2,t.length)))}return n.SDK.L(`checkMistouchTimer- ${a}:${h} > ${c}:${u} < ${l}:${d}`),!!((t=c<a)||(e=c==a)&&(i=u<=h)||(s=c>l)||(r=c==l&&u>=d))}return!1}_IsDepthShield(t){if(n.SDK.CME().DeepSRCfg){let e="_IsDepthShield-",i=n.SDK.CME().DeepSRCfg,s=i.CustomNumberCounter||0;if(n.SDK.L(e+"depthShield.Type:"+i.Type),0==i.Type)return!this._IsGoodUser(i);if(1==i.Type){let t=n.SDK.Me.GVT(r.SV.TCNCounter,0),e=n.SDK.Me.GVT(r.SV.TdCNCounter,0);return window.ConfigTestMgr.ins.GameCfg&&(t=window.ConfigTestMgr.ins.GameCfg.GameTime,e=window.ConfigTestMgr.ins.GameCfg.TodayGameTime),n.SDK.L(`TotalCustomNumberCounter > totalCustoms: ${t} > ${i.CustomNumberCounter}`),(!i.CustomNumberCounter||t>i.CustomNumberCounter)&&(n.SDK.L(`toalByTodayNum > dayCustoms: ${e} > ${i.DayCustomNumber[0]}`),(!i.CustomNumberCounter||e>i.DayCustomNumber[0])&&!this._IsGoodUser(i))}if(2==i.Type){if((t||0===t)&&(n.SDK.L(`customNum >= totalCustoms: ${t} >= ${s}`),t>=s)){if(!i.DayCustomNumber||0==i.DayCustomNumber.length)return n.SDK.L("depthShield.dayCustoms is null or empty"),!1;if(n.SDK.L(`${t} == ${s} || ((${t} > ${s}) && ((${t} - ${s}) % (${i.DayCustomNumber[0]} + 1)) == 0)`),t==s||t>s&&(t-s)%(i.DayCustomNumber[0]+1)==0)return!this._IsGoodUser(i)}return n.SDK.L("customNum is "+t),!1}}}_IsGoodUser(t){n.SDK.L("_IsGoodUser:"+t.ExecellentUserSwitch);let e=!0;if(t.ExecellentUserSwitch&&(t.WatchVideoCounter||0===t.WatchVideoCounter)){let i=window.ConfigTestMgr.ins.GameCfg.WatchViedoTime?window.ConfigTestMgr.ins.GameCfg.WatchViedoTime:n.SDK.Me.GVT(r.SV.TdWVCounter);window.ConfigTestMgr&&(i=window.ConfigTestMgr.ins.GameCfg.WatchViedoTime?window.ConfigTestMgr.ins.GameCfg.WatchViedoTime:n.SDK.Me.GVT(r.SV.TdWVCounter)),n.SDK.L(`isGoodUser--${i} > ${t.WatchVideoCounter}`),e=i>t.WatchVideoCounter}return e}IsUVd(t){let e=!1;if(n.SDK.CME().VdULCfg){let i=n.SDK.CME().VdULCfg.CustomNumber||0,s=n.SDK.CME().VdULCfg.IntervalCount||0;if(n.SDK.CME().VdULCfg.IsOn)if(t==i||t>i&&(t-i)%(s+1)==0){let i=n.SDK.Me.GVT(r.SV.LUlVLNumber,[]);i&&i.length>0&&i.forEach(i=>{t==i&&(e=!0)})}else e=!0;else e=!0,n.SDK.L("视频解锁关卡开关-关闭,开启所有关卡");n.SDK.L(`IsUnlockVideo-index:${t} customNumber:${i} intervalCount=${s} unlock=${e}`)}return e}}},"./sdk/Extensions/YDHWCache.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"YDHWCache",function(){return o});var s=i("./sdk/SDK/Declare.ts"),n=i("./sdk/SDK/EventDef.ts"),r=i("./sdk/Model/Default.ts");class o{constructor(){this.JumpOutInfo=null,s.SDK.Me.DV(n.SV.JOInfo,new r.JumpOutInfo)}RemoveItemFrom(t){let e=s.SDK.Me.GVT(n.SV.JOInfo,null);if(s.SDK.CME().ListBoxConfig&&s.SDK.CME().ListBoxConfig.length>0&&s.SDK.CME().SideBoxCount<s.SDK.CME().ListBoxConfig.length){for(let i=0;i<s.SDK.CME().ListBoxConfig.length;i++){let n=s.SDK.CME().ListBoxConfig[i];if(n.toAppid===t&&0==n.innerStatus){s.SDK.L("隐藏对应appid的所有icon--id:"+n._id),s.SDK.CME().ListBoxConfig.splice(i,1);let o=!1;for(let i=0;i<e.List.length;i++)e.List[i].appid==t&&(o=!0);o||e.List.push(new r.AppInfo(t)),e.Date=(new Date).getTime()}}s.SDK.Me.SVT(n.SV.JOInfo,e)}}}},"./sdk/Mgr/CommerceMgr.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"EditRequest",function(){return w}),i.d(e,"ApiMgr",function(){return M}),i.d(e,"StatMgr",function(){return O}),i.d(e,"AgentMgr",function(){return V}),i.d(e,"DataMgr",function(){return N}),i.d(e,"CommerceMgr",function(){return B});var s=i("./fw/Manager/CommerceManager.ts"),n=i("./fw/Assist/StorageApt.ts"),r=i("./sdk/SDK/Declare.ts"),o=i("./sdk/Model/User.ts"),a=i("./fw/Utility/Assist.ts"),h=i("./fw/Utility/Url.ts"),l=i("./sdk/SDK/EventDef.ts"),d=i("./sdk/Model/Data.ts"),S=i("./sdk/Config/SDKConfig.ts"),c=i("./sdk/Model/Default.ts"),u=i("./fw/Utility/TimerUtility.ts"),D=i("./sdk/Extensions/Strategy.ts"),C=i("./sdk/Model/Statistic.ts"),_=i("./sdk/Extensions/YDHWCache.ts"),I=i("./sdk/Extensions/PowerSystem.ts"),A=i("./sdk/Extensions/CloudAPI.ts"),f=i("./sdk/Extensions/HeartBeatSystem.ts"),g=i("./sdk/Extensions/StatisticSystem.ts"),m=i("./sdk/Assist/Log.ts"),p=i("./fw/Manager/ApiManager.ts"),y=i("./fw/Manager/NetManager.ts"),E=i("./fw/Enums/PLAT.ts");const P="Error=",L="Exception=",T="server say:",K="code:",v="Response=";class w{}class M extends p.ApiManager{constructor(){super(...arguments),this._ApiStatisticUploadTimeId="_ApiStatisticUploadTimeId",this.pendingMsgList=[],this._CurrentCallIndex=1,this._CounterList={},this.categoryStatistics="statistics"}Init(){super.Init(),this.DV(l.SV.PACList,{}).Store(),this.DV(l.SV.BatchID,0).Store(),this._UrApiFinal=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStatistics).R("sdk").A("final").End(),this._UrlApi=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStatistics).R("sdk").End(),this.DNfy(l.SE.OnFrontend,this,()=>{this.getLocalApiCountList()}),this.DNfy(l.SE.OnBackend,this,()=>{0!=this.pendingMsgList.length&&(this.SVT(l.SV.PACList,this.pendingMsgList),this.pendingMsgList=[])}),u.default.AddTimer(this._ApiStatisticUploadTimeId,5e3,this,null,()=>this.UploadStatisticSdk());for(let t=10001;t<=10094;t++)this.DeclareMethod(t);for(let t=20001;t<=20035;t++)this.DeclareMethod(t);for(let t=30001;t<=30013;t++)this.DeclareMethod(t);for(let t=40001;t<=40013;t++)this.DeclareMethod(t);for(let t=50001;t<=50007;t++)this.DeclareMethod(t);for(let t=60001;t<=60011;t++)this.DeclareMethod(t);for(let t=140001;t<=140002;t++)this.DeclareMethod(t);for(let t=150001;t<=150007;t++)this.DeclareMethod(t);for(let t=170001;t<=170007;t++)this.DeclareMethod(t)}DeclareMethod(t){this.DM(t,this,e=>{if(!r.SDK.CME().SwitchSdk)return;let i=this.GVT(l.SV.BatchID),s=(new Date).getTime();this._CounterList[t]?this._CounterList[t]++:this._CounterList[t]=1;let n=new C.SdkInfo;n.index=this._CurrentCallIndex,this._CurrentCallIndex++,n.count=this._CounterList[t],n.name=String(t),n.platform=this.getPlatformName(e),n.time=s,n.wholesaleId=i,this.pendingMsgList.push(n)})}UploadStatisticSdk(){return!!r.SDK.CME().OnLine&&0!=this.pendingMsgList.length&&(this._UrApiFinal.AsPost().Post({appid:r.SDK.CME().AppId,accountId:r.SDK.CME().AccountId,infos:this.pendingMsgList}).OnReceive(this,t=>{r.SDK.L("Sdk "+v,t),0===t.code?this.pendingMsgList=[]:r.SDK.Debug&&(m.Log.Error(T+t.info),m.Log.Error(K+t.code))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send(),!1)}getPlatformName(t){let e="";for(var i in E.PLAT)t==E.PLAT[i]&&(e=""+i);return e}Restore(){super.Restore(),this.getLocalApiCountList(),this.AVT(l.SV.BatchID,1),this._CurrentCallIndex=1}getLocalApiCountList(){let t=this.GVT(l.SV.PACList,[]);t.length>0&&(this.pendingMsgList=t)}}class O extends y.NetManager{constructor(){super(...arguments),this.categoryStat="statistics"}Init(){this._UrlBanner=r.SDK.Domain().Clone().Head(1,2).C(this.categoryStat).R("banner").End(),r.SDK.STAC().DM(l.NET_API.Banner,this,(t,e,i,s)=>{this._UrlBanner.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("Banner "+v,t),0===t.code?i&&s&&r.SDK.C(i,s,!0):(r.SDK.E1(t),i&&s&&r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlClickCount=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("clickcount").End(),r.SDK.STAC().DM(l.NET_API.ClickOut,this,(t,e,i)=>{this._UrlClickCount.AsPost().Post(t).OnReceive(this,t=>{r.SDK.E("ClickOut",t),0===t.code?r.SDK.C(e,i,!0):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlClientLog=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("clientlog").End(),r.SDK.STAC().DM(l.NET_API.ClientLog,this,(t,e,i)=>{try{this._UrlClientLog.AsPost().Post(t).OnReceive(this,t=>{r.SDK.L("ClientLog "+v,t),0===t.code?r.SDK.C(e,i,!0):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}catch(t){r.SDK.W(t)}}),this._UrlDuration=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("duration").End(),r.SDK.STAC().DM(l.NET_API.Duration,this,(t,e,i,s)=>{this._UrlDuration.AsGet().Param("type",t).Param("duration",e).End().OnReceive(this,t=>{0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlEvent=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("event").End(),r.SDK.STAC().DM(l.NET_API.Event,this,(t,e,i)=>{this._UrlEvent.AsPost().Post({events:t}).OnReceive(this,t=>{r.SDK.L("Event "+v,t),0===t.code?r.SDK.C(e,i,!0):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlInterstitialAd=r.SDK.Domain().Clone().Head(1,2).C(this.categoryStat).R("interstitial").End(),r.SDK.STAC().DM(l.NET_API.InterstitialAd,this,(t,e,i,s)=>{this._UrlInterstitialAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("Event "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlGridAd=r.SDK.Domain().Clone().Head(1,2).C(this.categoryStat).R("grid").End(),r.SDK.STAC().DM(l.NET_API.GridAd,this,(t,e,i,s)=>{this._UrlGridAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("Event "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlLayer=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("layer").End(),r.SDK.STAC().DM(l.NET_API.Stat_Layer,this,(t,e,i)=>{this._UrlLayer.AsPost().Post({layer:t}).OnReceive(this,t=>{r.SDK.L("Event "+v,t),0===t.code?r.SDK.C(e,i,!0):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlResult=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("result").End(),r.SDK.STAC().DM(l.NET_API.Result,this,(t,e,i)=>{this._UrlResult.AsPost().Post({detail:t}).OnReceive(this,t=>{r.SDK.L("Result "+v,t),0===t.code?r.SDK.C(e,i,t.result):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlShareCard=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("sharecard").End(),r.SDK.STAC().DM(l.NET_API.Stat_ShareCard,this,(t,e,i)=>{this._UrlShareCard.AsPost().Post(t).OnReceive(this,t=>{r.SDK.L("ShareCard "+v,t),0===t.code?r.SDK.C(e,i,!0):(r.SDK.E1(t),r.SDK.C(e,i,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlVideo=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("video").End(),r.SDK.STAC().DM(l.NET_API.Video,this,(t,e,i,s,n)=>{let o=i?{type:t,adId:e,time:i}:{type:t,adId:e};this._UrlVideo.AsPost().Post(o).OnReceive(this,t=>{r.SDK.L("Video "+v,t),0===t.code?r.SDK.C(s,n,!0):(r.SDK.E1(t),r.SDK.C(s,n,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlAppBoxAd=r.SDK.Domain().Clone().Head(1,2).C(this.categoryStat).R("box").End(),r.SDK.STAC().DM(l.NET_API.AppBoxAd,this,(t,e,i,s)=>{this._UrlAppBoxAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("AppBox "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlBlockAd=r.SDK.Domain().Clone().Head(1,2).C(this.categoryStat).R("block").End(),r.SDK.STAC().DM(l.NET_API.BlockAd,this,(t,e,i,s)=>{this._UrlBlockAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("Block "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlNativeAd=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("native").End(),r.SDK.STAC().DM(l.NET_API.NativeAd,this,(t,e,i,s)=>{this._UrlNativeAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("Native "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlNativeAd=r.SDK.Domain().Clone().Head(1,1).C(this.categoryStat).R("custom").End(),r.SDK.STAC().DM(l.NET_API.CustomAd,this,(t,e,i,s)=>{this._UrlNativeAd.AsGet().Param("type",t).Param("adId",e).End().OnReceive(this,t=>{r.SDK.L("CustomAd "+v,t),0===t.code?r.SDK.C(i,s,!0):(r.SDK.E1(t),r.SDK.C(i,s,!1))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()})}}class V extends y.NetManager{Init(){super.Init(),this._UrlEdit=r.SDK.Domain().Clone().Head(1,1).C("user").R("info").A("edit").End(),r.SDK.Data.DM(l.NET_API.Edit,this,(t,e,i)=>{r.SDK.L("NET_API.Edit info =",JSON.stringify(t)),this._UrlEdit.AsPost().Post(t).OnReceive(this,t=>{0===t.code?r.SDK.C(e,i,t.result):r.SDK.E1(t)}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlMyInfo=r.SDK.Domain().Clone().Head(1,2).C("user").R("my").A("info").End(),r.SDK.Data.DM(l.NET_API.MyInfo,this,(t,e)=>{this._UrlMyInfo.AsGet().OnReceive(this,i=>{r.SDK.L("MyInfo "+v,i),0===i.code?r.SDK.C(t,e,i.result):r.SDK.Debug&&(m.Log.Error(T+i.info),m.Log.Error(K+i.code))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlLogin=r.SDK.Domain().Clone().Head(1,1).C("user").R("login").End(),r.SDK.Me.DM(l.NET_API.Login,this,(t,e,i,s,n,o)=>{this._UrlLogin.Head(3,t).Head(4,e),this._UrlLogin.AsPost().Post(i).OnReceive(this,t=>{r.SDK.L("Login "+v,t),0===t.code?r.SDK.C(s,n,t.result):(r.SDK.Debug&&(m.Log.Error(T+t.info),m.Log.Error(K+t.code)),s&&o&&o.call(s))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetPayInfo=r.SDK.Domain().Clone().Head(1,1).C("pay").R("huawei").A("player").A("order").A("create").End(),r.SDK.Me.DM(l.NET_API.HuaweiPay,this,(t,e,i)=>{this.UrlGetPayInfo.AsPost().Post(e).OnReceive(this,e=>{r.SDK.L("HuaweiPay1 "+v,JSON.stringify(e)),0===e.code?r.SDK.C(t,i,e.result):(r.SDK.E1(e),r.SDK.C(t,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetPayReq=r.SDK.Domain().Clone().Head(1,2).C("pay").R("huawei").A("player").A("order").A("result").End(),r.SDK.Me.DM(l.NET_API.HuaweiPayReques,this,(t,e,i)=>{this.UrlGetPayReq.AsGet().Param("requestId",e).End().OnReceive(this,e=>{r.SDK.L("HuaweiPayREQ "+v,JSON.stringify(e)),0===e.code?r.SDK.C(t,i,e.result):(r.SDK.E1(e),r.SDK.C(t,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlCancelpay=r.SDK.Domain().Clone().C("pay").R("weixin").A("player").R("cancelpay").End(),r.SDK.Me.DM(l.NET_API.CancelPay,this,(t,e,i)=>{this._UrlCancelpay.AsGet().Param("amount",e).End().OnReceive(this,e=>{r.SDK.L("Cancelpay---SDKS----\x3e>>>>>",JSON.stringify(e)),0===e.code?r.SDK.C(t,i,e.result):(r.SDK.E1(e),r.SDK.C(t,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._Urlpresent=r.SDK.Domain().Clone().C("pay").R("weixin").A("player").R("present").End(),r.SDK.Me.DM(l.NET_API.GivinglGameCurrency,this,(t,e,i)=>{this._Urlpresent.AsGet().Param("amount",e).End().OnReceive(this,e=>{r.SDK.L("GivinglGameCurrency---SDKS----\x3e>>>>>",JSON.stringify(e)),0===e.code?r.SDK.C(t,i,e.result):(r.SDK.E1(e),r.SDK.C(t,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._Urlpay=r.SDK.Domain().Clone().C("pay").R("weixin").A("player").R("pay").End(),r.SDK.Me.DM(l.NET_API.GameCurrencyPay,this,(t,e,i)=>{this._Urlpay.AsGet().Param("amount",e).End().OnReceive(this,e=>{r.SDK.L("GameCurrencyPay---SDKS----\x3e>>>>>",JSON.stringify(e)),0===e.code?r.SDK.C(t,i,e.result):(r.SDK.E1(e),r.SDK.C(t,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this._UrlAccount=r.SDK.Domain().Clone().C("pay").R("weixin").A("player").R("account").End(),r.SDK.Me.DM(l.NET_API.GetServerUserInfo,this,(t,e)=>{this._UrlAccount.AsGet().End().OnReceive(this,i=>{r.SDK.L("GameCurrencyPay---SDKS----\x3e>>>>>",JSON.stringify(i)),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlOpGetPaySign=r.SDK.Domain().Clone().Head(1,3).C("pay").R("oppo").A("pay").A("sign").End(),r.SDK.Me.DM(l.NET_API.OPPaySign,this,(t,e,i)=>{this.UrlOpGetPaySign.AsPost().Post(e).OnReceive(this,e=>{r.SDK.L("HuaweiPay1 "+v,JSON.stringify(e)),r.SDK.C(t,i,e)}).OnError(this,e=>{r.SDK.E(P,e),r.SDK.C(t,i,e)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlOpPayResult=r.SDK.Domain().Clone().Head(1,2).C("pay").R("oppo").A("player").A("order").A("result").End(),r.SDK.Me.DM(l.NET_API.OPPayResult,this,(t,e,i)=>{this.UrlOpPayResult.AsGet().Param("cpOrderId",e).End().OnReceive(this,e=>{r.SDK.L("oppo pay result",JSON.stringify(e)),r.SDK.C(t,i,e)}).OnError(this,e=>{r.SDK.E(P,e),r.SDK.C(t,i,e)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlOpCreatOrder=r.SDK.Domain().Clone().Head(1,2).C("pay").R("oppo").A("player").A("order").A("create").End(),r.SDK.Me.DM(l.NET_API.OPCreatOrder,this,(t,e)=>{this.UrlOpCreatOrder.AsGet().End().OnReceive(this,i=>{r.SDK.L("oppo pay creatOrder",JSON.stringify(i)),r.SDK.C(t,e,i)}).OnError(this,i=>{r.SDK.E(P,i),r.SDK.C(t,e,i)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlOpPlaceAnOrder=new h.Url,r.SDK.Me.DM(l.NET_API.OpPlaceAnOrder,this,(t,e,i)=>{this.UrlOpPlaceAnOrder.AsPost().Post(e).Head(1,3).SetCustomUrl("https://jits.open.oppomobile.com/jitsopen/api/pay/v1.0/preOrder").OnReceive(this,e=>{r.SDK.L("oppo pay sign"+v,JSON.stringify(e)),r.SDK.C(t,i,e)}).OnError(this,e=>{r.SDK.E(P,e),r.SDK.C(t,i,e)}).OnException(this,t=>{r.SDK.E(L,t)}).SendCustomUrl(),console.warn("UrlOpPlaceAnOrder Url="+this.UrlOpPlaceAnOrder.CheckValue())}),this.Debug("Edit Url="+this._UrlEdit.CheckValue()),this.Debug("MyInfo Url="+this._UrlMyInfo.CheckValue()),this.Debug("Login Url="+this._UrlLogin.CheckValue()),this.Debug("Login Url="+this._UrlLogin.CheckValue()),this.Debug("UrlOpPayResult Url="+this.UrlOpPayResult.CheckValue()),this.Debug("UrlOpCreatOrder Url="+this.UrlOpCreatOrder.CheckValue()),this.Debug("UrlOpGetPaySign Url="+this.UrlOpGetPaySign.CheckValue())}}class N extends y.NetManager{Init(){this.UrlConfig=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("config").End(),this.UrlConfigFinal=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("config").A("final").End(),r.SDK.Data.DM(l.NET_API.Config,this,(t,e)=>{this.UrlConfig.AsGet().End().OnReceive(this,i=>{r.SDK.L("Config "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),this.UrlConfigFinal.AsGet().Param("appid",r.SDK.CME().AppId).End().OnReceive(this,i=>{r.SDK.L("ConfigForce "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send())}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetAccounToken=r.SDK.Domain().Clone().Head(1,2).C("user").R("platform").A("token").End(),r.SDK.Data.DM(l.NET_API.AccountToken,this,(t,e)=>{this.UrlGetAccounToken.AsGet().End().OnReceive(this,i=>{r.SDK.L("AccountToken "+v,i),0===i.code&&r.SDK.C(t,e,i)}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlCustomConfig=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("customconfig").End(),this.UrlCustomConfigFinal=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("customconfig").A("final").End(),r.SDK.Data.DM(l.NET_API.CustomConfig,this,(t,e)=>{this.UrlCustomConfig.AsGet().End().OnReceive(this,i=>{r.SDK.L("CustomConfig "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),this.UrlCustomConfigFinal.AsGet().Param("appid",r.SDK.CME().AppId).Param("version",r.SDK.CME().Version).End().OnReceive(this,i=>{r.SDK.L("CustomConfigForce "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send())}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetAdvertisingBoard=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("scene").A("group").A("adid").End(),r.SDK.Data.DM(l.NET_API.AdvertisingBoard,this,(t,e)=>{this.UrlGetAdvertisingBoard.AsGet().End().OnReceive(this,i=>{r.SDK.L("CustomConfig AdvertisingBoard "+v,i),0===i.code?r.SDK.C(t,e,i.result):1038===i.code||(r.SDK.E1(i),this.UrlGetAdvertisingBoard.AsGet().End().OnReceive(this,i=>{r.SDK.L("AdvertisingBoard "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.L(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.L(P,t)}).OnException(this,t=>{r.SDK.L(L,t)}).Send())}).OnError(this,t=>{r.SDK.L(P,t)}).OnException(this,t=>{r.SDK.L(L,t)}).Send()}),this.UrlDataDecode=r.SDK.Domain().Clone().Head(1,1).C("gamebase").R("data").A("decode").End(),r.SDK.Data.DM(l.NET_API.DataDecode,this,(t,e,i)=>{this.UrlDataDecode.AsPost().Post(t).OnReceive(this,t=>{r.SDK.L("DataDecode "+v,t),0===t.code?r.SDK.C(e,i,t.result):(r.SDK.E1(t),r.SDK.C(e,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetBoardAward=r.SDK.Domain().Clone().Head(1,1).C("gamebase").R("getboardaward").End(),r.SDK.Data.DM(l.NET_API.GetBoardAward,this,(t,e,i,s)=>{this.UrlGetBoardAward.AsPost().Post({module:t,awardId:e}).OnReceive(this,t=>{r.SDK.L("GetBoardAward "+v,t),0===t.code?r.SDK.C(i,s,t.result):(r.SDK.E1(t),r.SDK.C(i,s,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlLayer=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("layer").End(),r.SDK.Data.DM(l.NET_API.Data_Layer,this,(t,e)=>{this.UrlLayer.AsGet().End().OnReceive(this,i=>{r.SDK.L("Layer "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlScoreBoard=r.SDK.Domain().Clone().Head(1,1).AsPost().C("gamebase").R("scoreboard").End(),this.UrlScoreBoardFinal=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("scoreboard").A("final").End(),r.SDK.Data.DM(l.NET_API.ScoreBoard,this,(t,e,i)=>{this.UrlScoreBoard.AsPost().Post({module:t}).OnReceive(this,s=>{r.SDK.L("ScoreBoard "+v,s),0===s.code?r.SDK.C(e,i,s.result):(r.SDK.E1(s),this.UrlScoreBoardFinal.AsGet().Param("appid",r.SDK.CME().AppId).Param("version",r.SDK.CME().Version).Param("module",t).End().OnReceive(this,t=>{r.SDK.L("ScoreBoard "+v,t),0===t.code?r.SDK.C(e,i,t.result):(r.SDK.E1(t),r.SDK.C(e,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send())}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlSideBox=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("sidebox").End(),this.UrlSideBoxFinal=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("sidebox").A("final").End(),r.SDK.Data.DM(l.NET_API.SideBox,this,(t,e)=>{this.UrlSideBox.AsGet().End().OnReceive(this,i=>{r.SDK.L("SideBox "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),this.UrlSideBoxFinal.AsGet().Param("appi",r.SDK.CME().AppId).Param("version",r.SDK.CME().Version).End().OnReceive(this,i=>{r.SDK.L("SideBoxForce "+v,i),0===i.code?r.SDK.C(t,e,i.result):(r.SDK.E1(i),r.SDK.C(t,e,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send())}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlShareCard=r.SDK.Domain().Clone().Head(1,1).C("gamebase").R("sharecard").End(),this.UrlShareCardFinal=r.SDK.Domain().Clone().Head(1,2).C("gamebase").R("sharecard").A("final").End(),r.SDK.Data.DM(l.NET_API.Data_ShareCard,this,(t,e,i)=>{this.UrlShareCard.AsPost().Post({scene:t}).OnReceive(this,s=>{r.SDK.L("ShareCard "+v,s),0===s.code?r.SDK.C(e,i,s.result):(r.SDK.E1(s),this.UrlShareCardFinal.AsGet().Param("appid",r.SDK.CME().AppId).Param("scene",t).End().OnReceive(this,t=>{r.SDK.L("ShareCardFinal "+v,t),0===t.code?r.SDK.C(e,i,t.result):(r.SDK.E1(t),r.SDK.C(e,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send())}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlStoreValue=r.SDK.Domain().Clone().Head(1,1).C("gamebase").R("store").A("value").End(),r.SDK.Data.DM(l.NET_API.StoreValue,this,(t,e,i)=>{this.UrlStoreValue.AsPost().Post(t).OnReceive(this,t=>{r.SDK.L("StoreValue "+v,t),0===t.code?r.SDK.C(e,i,t.result):(r.SDK.E1(t),r.SDK.C(e,i,null))}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).Send()}),this.UrlGetMyIp=new h.Url,r.SDK.Me.DM(l.NET_API.GetMyIp,this,(t,e)=>{this.UrlGetMyIp.AsGet().SetCustomUrl("http://pv.sohu.com/cityjson").Head(1,1).OnReceive(this,i=>{r.SDK.L("UrlGetMyIp "+v,i),r.SDK.C(t,e,i)}).OnError(this,t=>{r.SDK.E(P,t)}).OnException(this,t=>{r.SDK.E(L,t)}).SendCustomUrl()})}}class B extends s.CommerceManager{constructor(){super(...arguments),this.Config=null,this._P=null,this.Strategy=null,this.Cache=null,this.PowerSystem=null,this.SDK_VERSION="3.2.5",this.AppId="",this.AppKey="",this.PkgName="",this.Version="",this.SceneId=0,this.payEnv="1",this.payKey="",this.signature="",this.playId="",this.SwitchTouch=!1,this.SwitchPush=!1,this.SwitchLog=!1,this.SwitchLogin=!0,this.SwitchJump=!0,this.SwitchShare=!0,this.SwitchVideo=!0,this.SwitchEvent=!0,this.SwitchLayer=!0,this.SwitchResult=!1,this.IsLowVersion=!1,this.IsRealVersion=!1,this.SwitchClient=!0,this.SwitchDuration=!0,this.SwitchBanner=!0,this.SwitchBlock=!0,this.SwitchBox=!0,this.SwitchCustom=!0,this.SwitchGrid=!0,this.SwitchInterstitial=!0,this.SwitchNative=!0,this.SwitchSdk=!0,this.OnLine=!1,this.VideoFalseLimit=0,this.ShareFalseLimit=0,this.LastLoginTime=0,this.ListCustomConfig=null,this.ListBoxConfig=null,this.ListLayer=null,this.AccountToken=null,this.BannerAdUnitIdList=null,this.InterstitialAdUnitIdList=null,this.SpreadAdUnitIdList=null,this.NativeAdUnitIdList=null,this.VideoAdUnitIdList=null,this.GameBoxBannerList=null,this.GameBoxPortalList=null,this.NativeIndex=0,this.BnRefCfg=null,this.PSysCfg=null,this.VdULCfg=null,this.DeepSRCfg=null,this.MisTSwCfg=null,this.DevAcntCfg=null,this._LastTimeRefreshBannerAd=0,this._BannerAdDelayTimerId="",this._IsSmallBannerAd=!1,this._UnlockCustomNumber=0,this._CallerRewardVideoAd=null,this._EvtOnCloseRewardVideoAd=null,this._IsAddPower=!1,this._IsRewardVideoAdFinish=!1,this._VideoStartPlayTime=null,this.IntttAdFirstShowWT=0,this.IntttAdShowTimeI=0,this._LCIntttAd=0,this._CurrentShareScene="",this._CallerShareCardBack=null,this._EvtOnShareCardBack=null,this._ShareAppInfo=null,this._ScoreBoardinfo=null,this.SideBoxCount=20,this._LastPlayTime=(new Date).getTime(),this._showShare=!1,this._showVideoAd=!1,this._showInterstitialAd=!1,this._intttAdWaitShow=!1,this._needShowBannerAd=!1,this._isShowBannerAd=!1,this._showMoreGameView=!1,this._localLayerList=null,this._ResolutionWidth=0,this._resolutionHeight=0,this._ScaleType=0,this._hasHide=!1,this._onShow=null,this._onHide=null,this._onError=null}_InnerLogin(t,e){if(this._P.InitEngine(),r.SDK.L("CommerceMgr InnerLogin()"),!this.SwitchLogin)return console.error("当前游戏已经被禁止登录，请联系SDK官方 !"),void r.SDK.C(t,e,!1);this._LCIntttAd=(new Date).getTime(),this._P.GetNetworkType(this,t=>{this._P.NetType=t,r.SDK.L("GetNetworkType = ",t)});let i=new o.LoginRequest,s=this.Invoke(10001),S=new o.ClientInfo;i.platform=this._P.PfType+"",i.appid=this.AppId,i.version=this.Version;try{i.code=hbs?this.playId:this.Code}catch(t){i.code=this.Code}i.pkgName=this.PkgName,i.uuid=n.StorageApt.ReadString("uuid")||"",i.shareInfo=s,S.uuid="",S.platform=this._P.PfType+"",S.brand=this._P.Brand,S.version=this.SDK_VERSION,S.model=this._P.Model,S.appName=this._P.AppName,S.resolution=this._P.Resolution,this.platfromsys=this._P.SysInfo;let c="",u="";try{this._P.IsLayaEngine?(c="laya",u=Laya.version):this._P.IsCocosEngine?(c="cocos",window.cc&&window.cc.ENGINE_VERSION&&(u=window.cc.ENGINE_VERSION)):this._P.IsEgretEngine&&(c="egret",u="")}catch(t){r.SDK.W("get platform info error:"+t)}i.clientInfo=S,window.ConfigTestMgr&&(c="laya",u="2.5.0",i.platform=window.ConfigTestMgr.PfType,i.appid=window.ConfigTestMgr.Appid,i.version=window.ConfigTestMgr.Virsion,i.pkgName="anonymousCode",i.uuid=n.StorageApt.ReadString("uuid")||"",S.uuid="",S.platform=window.ConfigTestMgr.PfType,S.brand="PC",S.version=this.SDK_VERSION,S.model="web",S.appName="this._P.AppName",S.resolution="",i.clientInfo=S),r.SDK.L("请求登录参数",JSON.stringify(i)),r.SDK.Me.Invoke(l.NET_API.Login,c,u,i,this,i=>{r.SDK.L("login result:"+JSON.stringify(i)),this.OnLine=!0,this.AccountId=i.accountId,this.NickName=i.nickName||"",this.AvatarUrl=i.avatarUrl||"",this.IsNewPlayer=a.Assist.ToB(i.newPlayer),this.OpenID=i.openid||"",this.AccountPass=i.accountPass||"",this.GroupCode=i.groupCode||"",this.payEnv=i.payEny||"",this.payKey=i.payKey||"",this.SVT(l.SV.APYDHW,{account_pass:this.AccountPass,save_time:(new Date).getTime()}),h.Url.SetAccountPass(this.AccountPass),this.SwitchTouch=a.Assist.ToB(i.switchTouch)||!1,this.SwitchPush=a.Assist.ToB(i.switchPush)||!1,this.SwitchLog=a.Assist.ToB(i.switchLog)||!1,this.SwitchLogin=a.Assist.ToSB(i.switchLogin,"switchLogin")||!1,this.SwitchJump=a.Assist.ToSB(i.switchJump,"switchJump")||!1,this.SwitchShare=a.Assist.ToSB(i.switchShare,"switchShare")||!1,this.SwitchVideo=a.Assist.ToSB(i.switchVideo,"switchVideo")||!1,this.SwitchEvent=a.Assist.ToSB(i.switchEvent,"switchEvent")||!1,this.SwitchLayer=a.Assist.ToSB(i.switchLayer,"switchLayer")||!1,this.SwitchResult=a.Assist.ToSB(i.switchResult,"switchResult")||!1,this.IsLowVersion=a.Assist.ToB(i.isLowVersion)||!1,this.IsRealVersion=a.Assist.ToB(i.isRealVersion)||!1,this.SwitchClient=a.Assist.ToSB(i.switchClient,"switchClient")||!1,this.SwitchDuration=a.Assist.ToSB(i.switchDuration,"switchDuration")||!1,this.SwitchBanner=a.Assist.ToSB(i.switchBanner,"switchBanner")||!1,this.SwitchBlock=a.Assist.ToSB(i.switchBlock,"switchBlock")||!1,this.SwitchBox=a.Assist.ToSB(i.switchBox,"switchBox")||!1,this.SwitchCustom=a.Assist.ToSB(i.switchCustom,"switchCustom")||!1,this.SwitchGrid=a.Assist.ToSB(i.switchGrid,"switchGrid")||!1,this.SwitchInterstitial=a.Assist.ToSB(i.switchInterstitial,"switchInterstitial")||!1,this.SwitchNative=a.Assist.ToSB(i.switchNative,"switchNative")||!1,this.SwitchSdk=a.Assist.ToSB(i.switchSdk,"switchSdk")||!1,this.CloudApi=new A.CloudAPI,this.VideoFalseLimit=i.videoFalseLimit||0,this.ShareFalseLimit=i.shareFalseLimit||0;let s=i.moduleFalseList||[],n=i.moduleList||[];this.Strategy=new D.Strategy(n,s),r.SDK.L("SDK version:"+this.SDK_VERSION+",Game version:"+this.Version),this.IsLowVersion&&r.SDK.W("SDK is low please update !"),this.IsRealVersion||r.SDK.W("not found Game version by Server !"),this.SwitchLogin||console.error("当前游戏已经被禁止登录，请联系SDK官方 !"),r.SDK.Debug=this.SwitchLog,this._P.IsDebug=this.SwitchLog,r.SDK.Data.Invoke(l.NET_API.Config,this,i=>{i.forEach(t=>{let e=JSON.parse(t.value);if("b_t_s"==t.code)this.BnRefCfg=new d.BannerRefreshCfg,this.BnRefCfg.IsOn=a.Assist.ToB(e[0]),this.BnRefCfg.Interval=e[1]||10,this.BnRefCfg.IsForceRefresh=a.Assist.ToB(e[2]),this.BnRefCfg.MinimumInterval=e[3]||3,window.reqNativeLimit=e[3]||20;else if("power"==t.code)this.PSysCfg=new d.PowerSystemCfg,this.PSysCfg.DefaultPowerValue=e[0]||5,this.PSysCfg.UpperLimit=e[1]||5,this.PSysCfg.AutoRecoveryTime=e[2]||300,this.PSysCfg.VideoPowerWeight=e[3]||1,this.PSysCfg.IsOn=a.Assist.ToB(e[4]);else if("v_u_c"==t.code)this.VdULCfg=new d.VideoUnlockLevelCfg,this.VdULCfg.IsOn=a.Assist.ToB(e[0]),this.VdULCfg.CustomNumber=e[1]||2,this.VdULCfg.IntervalCount=e[2]||0;else if("dp_s"==t.code)this.DeepSRCfg=new d.DeepSheildRuleCfg,this.DeepSRCfg.Type=e[0]||0,this.DeepSRCfg.CustomNumberCounter=e[1]||5,this.DeepSRCfg.ExecellentUserSwitch=a.Assist.ToB(e[2]),this.DeepSRCfg.WatchVideoCounter=e[3]||2,this.DeepSRCfg.DayCustomNumber=e[4]||0,window.ConfigTestMgr&&(window.ConfigTestMgr.ins.ServerSRC=this.DeepSRCfg);else if("m_t"==t.code)this.MisTSwCfg=new d.MisTouchSwitchCfg,this.MisTSwCfg.IsOn=a.Assist.ToB(e[0]),this.MisTSwCfg.StartTimeHour=e[1]||0,this.MisTSwCfg.StartTimeMinute=e[2]||0,this.MisTSwCfg.EndTimeHour=e[3]||23,this.MisTSwCfg.EndTimeMinute=e[4]||0,window.ConfigTestMgr&&(window.ConfigTestMgr.ins.MisTSwCfg=this.MisTSwCfg);else if("d_a"==t.code){this.DevAcntCfg=new d.DeveloperAccountCfg,this.DevAcntCfg.IsOn=a.Assist.ToB(e[0]);for(let t=1,i=e.length;t<i;t++)this.DevAcntCfg.Accounts.push(e[t])}}),this.PowerSystem.Init(),r.SDK.C(t,e,!0)}),this.Invoke(10018,this,t=>{}),this.Invoke(10089,this,t=>{}),this.Invoke(10012),f.HeartBeatSystem.Me().StartUploadTime()},()=>{r.SDK.C(t,e,!1)}),r.SDK.L("SDKPlatform InnerLogin() end")}Init(){super.Init(),this.RefreshLastPlayTime(),this.Name="YDHW-SDK:"+this.Name,this.Cache=new _.YDHWCache,this.PowerSystem=new I.PowerSystem,this.Config=window[n.StorageApt.SDK_CONFIG],!this.CloudApi&&(this.CloudApi=new A.CloudAPI),this.AppId=String(this.Config.appid),this.AppKey=String(this.Config.appkey),this.PkgName=String(this.Config.pkg_name),this.Version=String(this.Config.version),this.SwitchLog=this._P.IsDebug,this.BannerAdUnitIdList=this.Config.banner_ad_unit_id_list,this.IntttAdFirstShowWT=Number(this.Config.interstitialAd_first_show_wait_time)||0,this.IntttAdShowTimeI=Number(this.Config.interstitialAd_show_time_interval)||0,this.SideBoxCount=Number(this.Config.side_box_count)||0,this.BannerAdUnitIdList&&void 0!==this.BannerAdUnitIdList||this._P.IsDebug&&console.error("YDHW_CONFIG.banner_ad_unit_id_list not exists"),this.InterstitialAdUnitIdList=this.Config.interstitial_ad_unit_id_list,this.InterstitialAdUnitIdList&&void 0!==this.InterstitialAdUnitIdList||this._P.IsDebug&&console.error("YDHW_CONFIG.interstitial_ad_unit_id_list not exists"),this.SpreadAdUnitIdList=this.Config.spread_ad_unit_id_list,this.SpreadAdUnitIdList&&void 0!==this.SpreadAdUnitIdList||this._P.IsDebug&&console.error("YDHW_CONFIG.spread_ad_unit_id_list not exists"),this.NativeAdUnitIdList=this.Config.native_ad_unit_id_list,this.NativeAdUnitIdList&&void 0!==this.NativeAdUnitIdList||this._P.IsDebug&&console.error("YDHW_CONFIG.native_ad_unit_id_list not exists"),this.VideoAdUnitIdList=this.Config.video_ad_unit_id_list,this.VideoAdUnitIdList&&void 0!==this.VideoAdUnitIdList||this._P.IsDebug&&console.error("YDHW_CONFIG.video_ad_unit_id_list not exists"),this.GameBoxBannerList=this.Config.sidebox_bn_unit_id_list,this.GameBoxBannerList&&void 0!==this.GameBoxBannerList||this._P.IsDebug&&console.error("YDHW_CONFIG.sidebox_bn_unit_id_list not exists"),this.GameBoxPortalList=this.Config.sidebox_Pt_unit_id_list,this.GameBoxBannerList&&void 0!==this.GameBoxPortalList||this._P.IsDebug&&console.error("YDHW_CONFIG.sidebox_Pt_unit_id_list not exists"),this._ResolutionWidth=Number(this.Config.resolution_width)||0,this._resolutionHeight=Number(this.Config.resolution_height)||0,this._ScaleType=Number(this.Config.scale_type)||0,this.DV(l.SV.APYDHW,null).Store(),this.DV(l.SV.TPCounter,-1).Store(),this.DV(l.SV.LPAddTstamp,(new Date).getTime()).Store(),this.DV(l.SV.TdWVCounter,0).Store(),this.DV(l.SV.LWhVTstamp,(new Date).getTime()).Store(),this.DV(l.SV.LUlVLNumber,[]).Store(),this.DV(l.SV.MCNumber,0).Store(),this.DV(l.SV.LCNumber,0).Store(),this.DV(l.SV.TdCNCounter,0).Store(),this.DV(l.SV.TCNCounter,0).Store(),this.DV(l.SV.LPTstamp,(new Date).getTime()),this.DV(l.SV.LUlVLNumber,[]).Store(),this.DV(l.SV.VFLimit,0).Store(),this.DV(l.SV.SFLimit,0).Store(),this.DV(l.SV.PfUInfo,null),this.DV(l.SV.LStttLayer,null).Store(),this.DV(l.SV.CDPro,0).Store(),this.DV(l.SV.OnCD,!1).Store(),this.DM(10069,this,t=>{this._hasHide&&(this.RefreshLastPlayTime(),this._hasHide=!1),f.HeartBeatSystem.Me().StartUploadTime(),this._ShareAppInfo=null,this.InvokeNfy(l.SE.OnFrontend),this._onShow&&this._onShow.c&&this._onShow.m&&this._onShow.m.call(this._onShow.c,t)}),this.DM(10070,this,t=>{!this._P.IsSBnAd||this._showInterstitialAd||this._showVideoAd||this._showShare||(r.SDK.L("YDHW has click Banner AdId:"+this._P.BnAdId),this.Invoke(10002,l.TP_AD.CLICK,this._P.BnAdId)),f.HeartBeatSystem.Me().StopUploadTimer(),this._hasHide=!0,this.Invoke(10012),this.InvokeNfy(l.SE.OnBackend),this._onHide&&this._onHide.c&&this._onHide.m&&this._onHide.m.call(this._onHide.c,t)}),this.DM(10071,this,(t,e)=>{this._onShow={c:t,m:e},r.SDK.API().Invoke(10071)}),this.DM(10072,this,(t,e)=>{this._onHide={c:t,m:e},r.SDK.API().Invoke(10072)}),this.DM(10073,this,(t,e)=>{this._onError={c:t,m:e},r.SDK.API().Invoke(10073)}),this.DM(10002,this,(t,e)=>{r.SDK.CME().SwitchBanner&&g.StatSystem.Me().StatBanner(t,e)}),this.DM(10003,this,(t,e,i)=>{r.SDK.CME().SwitchVideo&&g.StatSystem.Me().StatVideo(t,e,i)}),this.DM(10004,this,(t,e)=>{r.SDK.CME().SwitchInterstitial&&g.StatSystem.Me().StatInterstitial(t,e)}),this.DM(10005,this,(t,e)=>{r.SDK.CME().SwitchGrid&&g.StatSystem.Me().StatGrid(t,e)}),this.DM(10006,this,(t,e)=>{r.SDK.CME().SwitchBox&&g.StatSystem.Me().StatAppBox(t,e)}),this.DM(10007,this,(t,e)=>{r.SDK.CME().SwitchBlock&&g.StatSystem.Me().StatBlock(t,e)}),this.DM(10008,this,(t,e)=>{r.SDK.CME().SwitchNative&&g.StatSystem.Me().StatNativeAd(t,e)}),this.DM(10009,this,(t,e,i)=>{if(r.SDK.CME().SwitchClient)try{let s=this._P.SysInfo,n=new C.ClientLogReq;n.ErrStack=t,n.LogStr=e,s&&(n.appid=this.AppId,n.version=this.Version,n.language=s.language,n.system=s.system,n.model=s.model,n.brand=s.brand,n.platform=s.platform,n.SDKVersion=this.SDK_VERSION,n.resolution=s.screenWidth+"x"+s.screenHeight,n.window=s.windowWidth+"x"+s.windowHeight),n.addDate=i,r.SDK.STAC().Invoke(l.NET_API.ClientLog,n,this,t=>{!0===t&&this.Log("StatErrorStack isOk:"+t)})}catch(t){this.Warn("StatErrorStack-err:",t)}}),this.DM(10010,this,t=>{r.SDK.CME().SwitchResult&&g.StatSystem.Me().StatResult(t)}),this.DM(10011,this,(t,e,i)=>{r.SDK.CME().SwitchEvent&&(i?g.StatSystem.Me().StatEvent(t,e,i):g.StatSystem.Me().StatEvent(t,e))}),this.DM(10012,this,()=>{if(!this.OnLine)return void this.Warn("is not onLine");if(!r.SDK.CME().SwitchDuration)return;let t=(new Date).getTime(),e=t-this._LastPlayTime,i=this;r.SDK.STAC().Invoke(l.NET_API.Duration,0,e,this,e=>{!0===e&&(i._LastPlayTime=t)})}),this.DM(10013,this,t=>{r.SDK.CME().SwitchJump&&g.StatSystem.Me().StatClickOut(t)}),this.DM(10014,this,(t,e,i,s)=>{t?e?(this.Strategy&&this.Strategy.SSVd(t,e,i,s),r.SDK.API().Invoke(10014)):this.Error("module is null"):this.Error("channel is null")}),this.DM(10015,this,(t,e,i,s)=>{t?e?(this.Strategy&&this.Strategy.USVSty(t,e,i,s),r.SDK.API().Invoke(10015)):this.Error("module is null"):this.Error("channel is null")}),this.DM(10016,this,t=>{if(!this._P.BnAd&&this.SwitchLog)this.Warn("BannerAd is null");else if(this.BnRefCfg&&this.BnRefCfg.IsForceRefresh){let t=(new Date).getTime();t-(this._LastTimeRefreshBannerAd||t)>=1e3*(this.BnRefCfg.MinimumInterval||S.SDKCfg.DIFRefreshBannerAd)&&(this._P.IsSBnAd?this._CreateBannerAd(this._IsSmallBannerAd,this._P.IsMTBnAd,!0,this._P.BnStyle,this._P.OnRsBnAd,null,null):this._LastTimeRefreshBannerAd=t-(1e3*this.BnRefCfg.MinimumInterval+1e3))}r.SDK.API().Invoke(10016)}),this.DM(10017,this,t=>{let e=this.Strategy&&this.Strategy.GetDMT(t),i=new c.DeepTouchInfo;return i.deepTouch=!!e,this.ListCustomConfig&&this.ListCustomConfig.length>0&&this.ListCustomConfig.forEach(t=>{let s=r.SDK.copy(t);e||(1==parseInt(t.type)?s.value="":2==parseInt(t.type)&&(s.value="0")),i.ListCustomInfo.push(s)}),r.SDK.API().Invoke(10017),i}),this.DM(10018,this,(t,e)=>{this.ListCustomConfig?r.SDK.C(t,e,this.ListCustomConfig):r.SDK.Data.Invoke(l.NET_API.CustomConfig,this,i=>{if(this.ListCustomConfig=i,i){for(const t in this.ListCustomConfig)if(Object.prototype.hasOwnProperty.call(i,t)){const e=this.ListCustomConfig[t];if(r.SDK.CME().SwitchTouch||1==parseInt(e.switchTouchUse)&&(1==parseInt(e.type)?e.value="":2==parseInt(e.type)&&(e.value="0")),"ydhw_duration"==e.name&&"1"==e.type&&e.value){let t=0;try{t=Number(e.value)}catch(t){this.Warn("GetCustomConfig-parse ydhw_duration-error",t)}f.HeartBeatSystem.Me().SetTimeSpace(t)}this.ListCustomConfig[t]=e}r.SDK.C(t,e,this.ListCustomConfig)}else this.Warn("GetCustomConfig-parse ydhw_duration-error")}),r.SDK.API().Invoke(10018)}),this.DM(10019,this,t=>{this.SVT(l.SV.LCNumber,t),t>this.GVT(l.SV.MCNumber,0)&&this.SVT(l.SV.MCNumber,t),this.AVT(l.SV.TdCNCounter,1),this.AVT(l.SV.TCNCounter,1),this.SVT(l.SV.LPTstamp,(new Date).getTime()),r.SDK.API().Invoke(10019)}),this.DM(10020,this,t=>(r.SDK.API().Invoke(10020),this.Strategy&&this.Strategy.IsUVd(t))),this.DM(10021,this,()=>this.PSysCfg?(r.SDK.API().Invoke(10021),this.PSysCfg):(this.Error("GetPowerInfo error: PowerInfo is null"),null)),this.DM(10022,this,(t,e)=>{this.PowerSystem.LOnPC(t,e),r.SDK.API().Invoke(10022)}),this.DM(10023,this,(t,e)=>{this.PSysCfg&&!1!==this.PSysCfg.IsOn?(this.PowerSystem&&this.PowerSystem.SetPower(t,e),r.SDK.API().Invoke(10023)):this.Warn("Power System is Off")}),this.DM(10024,this,()=>(r.SDK.API().Invoke(10024),this.PowerSystem&&this.PowerSystem.GetPower())),this.DM(10025,this,(t,e)=>{this.ListBoxConfig&&r.SDK.C(t,e,this.ListBoxConfig),r.SDK.Data.Invoke(l.NET_API.SideBox,this,i=>{this.ListBoxConfig=i,r.SDK.C(t,e,this.ListBoxConfig)}),r.SDK.API().Invoke(10025)}),this.DM(10026,this,(t,e)=>{r.SDK.Data.Invoke(l.NET_API.ScoreBoard,"scoreboard",t,e),r.SDK.API().Invoke(10026)}),this.DM(10027,this,(t,e,i)=>{r.SDK.Data.Invoke(l.NET_API.GetBoardAward,"scoreboard",t,e,i),r.SDK.API().Invoke(10027)}),this.DM(10028,this,(t,e,i)=>{this._CurrentShareScene=""!==t?t:"default",r.SDK.Data.Invoke(l.NET_API.Data_ShareCard,t,this,s=>{this.Strategy.ISConf(t,s),r.SDK.C(e,i,s)}),r.SDK.API().Invoke(10028)}),this.DM(10029,this,()=>{let t=this.GVT(l.SV.TdCNCounter,0);return r.SDK.API().Invoke(10029),t}),this.DM(10030,this,()=>{let t=this.GVT(l.SV.TCNCounter,0);return r.SDK.API().Invoke(10030),t}),this.DM(10031,this,()=>{let t=this.GVT(l.SV.LCNumber,0);return r.SDK.API().Invoke(10031),t}),this.DM(10032,this,()=>{let t=this.GVT(l.SV.MCNumber,0);return r.SDK.API().Invoke(10032),t}),this.DM(10033,this,()=>{let t=this.GVT(l.SV.TdWVCounter,0);return r.SDK.API().Invoke(10033),t}),this.DM(10034,this,(t,e,i,s,n)=>{this._P.BnStyle=null,this._CreateBannerAd(!1,t,e,null,i,s,n),r.SDK.API().Invoke(10034)}),this.DM(10035,this,(t,e,i,s,n)=>{this._P.BnStyle=null,this._CreateBannerAd(!0,t,e,null,i,s,n),r.SDK.API().Invoke(10035)}),this.DM(10036,this,(t,e,i,s,n,o)=>{this._P.BnStyle=i,this._CreateBannerAd(!1,t,e,i,s,n,o),r.SDK.API().Invoke(10036)}),this.DM(10037,this,t=>{this._P.ChangeBnAdStyle(t),r.SDK.API().Invoke(10037)}),this.DM(10038,this,()=>{this.Log("ShowBannerAd");let t=(new Date).getTime(),e=this._LastTimeRefreshBannerAd||t,i=!1,s=!1,n=0,o=!1;this.BnRefCfg&&(s=this.BnRefCfg.IsOn||!1,n=this.BnRefCfg.Interval||S.SDKCfg.DIFRefreshBannerAd),this._P.BnAd&&(s&&(i=this._IsSmallBannerAd||!1),s&&t-e>=1e3*n&&(this.Log("ShowBannerAd CreateBannerAd"),o=!0,this._CreateBannerAd(this._IsSmallBannerAd,this._P.IsMTBnAd,!0,this._P.BnStyle,this._P.OnRsBnAd,null,null)),o||(this._P.BnAdV(!0),this.Invoke(10002,l.TP_AD.SHOW,this._P.BnAdId),this._needShowBannerAd=!1),this._LastTimeRefreshBannerAd=t),!o&&s&&(this.Log(`将在${n}秒后重新创建banner`),u.default.RemoveDelayTimer(this._BannerAdDelayTimerId),this._BannerAdDelayTimerId=u.default.Delay(1e3*n,this,()=>{this._P.IsSBnAd&&this._CreateBannerAd(this._IsSmallBannerAd,this._P.IsMTBnAd,!0,this._P.BnStyle,this._P.OnRsBnAd,null,null)})),r.SDK.API().Invoke(10038)}),this.DM(10039,this,()=>{this.Log("HideBannerAd"),this._P.BnAdV(!1),this._needShowBannerAd=!1,u.default.RemoveDelayTimer(this._BannerAdDelayTimerId),this._BannerAdDelayTimerId="",r.SDK.API().Invoke(10039)}),this.DM(10040,this,t=>{this._P.ChangeBnAdStyle(t),r.SDK.API().Invoke(10040)}),this.DM(10041,this,t=>{if(this.VideoAdUnitIdList&&0!=this.VideoAdUnitIdList.length){if(!this._P.VdAd){let e=this,i=!1,s=t?Number(t):Math.floor(Math.random()*this.VideoAdUnitIdList.length);s=s<this.VideoAdUnitIdList.length-1?s:this.VideoAdUnitIdList.length-1;let n=this.VideoAdUnitIdList[s];this._P.CreateVdAd(n,this,()=>{e._IsRewardVideoAdFinish=!0},t=>{e._LCIntttAd=(new Date).getTime();let s=e._LCIntttAd-e._VideoStartPlayTime;e.Invoke(10003,l.TP_AD.CLOSE,n,s),t&&t.isEnded||void 0===t?(e.Log("视频播放完成"),e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,l.VIDEO_P_T.FINISH),e._AddUnlockVideoLevelNumber(e._UnlockCustomNumber),e.Invoke(10003,l.TP_AD.PLAY_FINISH,n),e._IsAddPower&&e._AddPowerByVideo(),i=!0):(e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,l.VIDEO_P_T.CANCEL),e.Log("视频播放中途取消"),this.Invoke(10003,l.TP_AD.PLAY_CANCEL,n)),e._UnlockCustomNumber=null,e._EvtOnCloseRewardVideoAd=null,e._showVideoAd=!1,r.SDK.TKMgr.Invoke(l.TK_DOT_API.EvtAdEnd,n,i)},t=>{e.Log("RewardVideoAd onError:",t),this.Invoke(10003,l.TP_AD.LOAD_FAIL,n),e._CallerRewardVideoAd&&e._EvtOnCloseRewardVideoAd&&e._EvtOnCloseRewardVideoAd.call(e._CallerRewardVideoAd,l.VIDEO_P_T.FAIL),e._EvtOnCloseRewardVideoAd=null,e._UnlockCustomNumber=null,e._showVideoAd=!1,e._LCIntttAd=(new Date).getTime()}),this.Invoke(10003,l.TP_AD.CREATE,n)}}else this.Error("VideoAdUnitIdList is empty.");r.SDK.API().Invoke(10041)}),this.DM(10042,this,(t,e,i,s,n,o)=>{let a=this;this._IsRewardVideoAdFinish=!1,this._UnlockCustomNumber=t,this._CallerRewardVideoAd=i,this._EvtOnCloseRewardVideoAd=s,this._IsAddPower=e||!1,(this._P.VdAd||(this.Invoke(10041,o),this._P.VdAd))&&(this._P.ShowVdAd(this,()=>{a.Log("视频播放成功"),a._showVideoAd=!0,a._IsRewardVideoAdFinish=!0,a._VideoStartPlayTime=(new Date).getTime(),a.Invoke(10003,l.TP_AD.SHOW,this._P.VdAdId),a._CallerRewardVideoAd&&a._EvtOnCloseRewardVideoAd&&a._EvtOnCloseRewardVideoAd.call(a._CallerRewardVideoAd,l.VIDEO_P_T.SHOW);let t=this._P.VdAdId;r.SDK.TKMgr.Invoke(l.TK_DOT_API.EVtAdStart,t)},()=>{a.Error("视频播放失败"),a._CallerRewardVideoAd&&a._EvtOnCloseRewardVideoAd&&a._EvtOnCloseRewardVideoAd.call(a._CallerRewardVideoAd,l.VIDEO_P_T.FAIL),a._EvtOnCloseRewardVideoAd=null,a._showVideoAd=!1,a._LCIntttAd=(new Date).getTime()},null),n&&n(this._P.VdAdId),r.SDK.API().Invoke(10042))}),this.DM(10043,this,t=>{this.Invoke(10044,t),r.SDK.API().Invoke(10043)}),this.DM(10044,this,t=>{r.SDK.CME().SwitchShare&&r.SDK.STAC().Invoke(l.NET_API.Stat_ShareCard,t,this,t=>{})}),this.DM(10045,this,t=>{r.SDK.Data.Invoke(l.NET_API.Data_Layer,this,e=>{this.ListLayer=e.sort();let i=this.GVT(l.SV.LStttLayer,null);i&&(this._localLayerList=i),t&&t(e.sort())}),r.SDK.API().Invoke(10045)}),this.DM(10046,this,(t,e,i,s,n,o)=>{let a=s||"default",h=new C.ClickOutReq;h.iconId=t,h.target=e,h.souce=a,this._P.NToMP(this.AppId,e,i,this,()=>{this.Log("小游戏跳转-跳转成功！"),h.action="enable",r.SDK.STAC().Invoke(l.NET_API.ClickOut,h,null),this.Cache.RemoveItemFrom(e),r.SDK.C(n,o,!0)},()=>{this.Log("小游戏跳转-跳转失败！"),h.action="cancel",r.SDK.STAC().Invoke(l.NET_API.ClickOut,h,null),r.SDK.C(n,o,!1)}),r.SDK.API().Invoke(10046)}),this.DM(10047,this,(t,e,i)=>{this._P.GetUserInfo(this,i=>{r.SDK.C(t,e,i);let s=new w;i.nickName&&(s.nickName=i.nickName),i.avatarUrl&&(s.headimgurl=i.avatarUrl),i.gender&&(s.gender=i.gender),i.province&&(s.province=i.province),i.city&&(s.city=i.city),i.country&&(s.country=i.country),i.signature&&(s.signature=i.signature),i.iv&&(s.iv=i.iv),i.encryptedData&&(s.encryptedData=i.encryptedData),r.SDK.Data.Invoke(l.NET_API.Edit,s,t,()=>{}),i.nickName&&(this.NickName=i.nickName),i.avatarUrl&&(this.AvatarUrl=i.avatarUrl)},e=>{r.SDK.C(t,i,e)}),r.SDK.API().Invoke(10047)}),this.DM(10087,this,(t,e)=>{this._P.GetCapsulePoint(this,i=>{r.SDK.C(t,e,i)}),r.SDK.API().Invoke(10087)}),this.DM(10088,this,(t,e)=>{this._P.GetSysIf(this,i=>{r.SDK.C(t,e,i)}),r.SDK.API().Invoke(10088)}),this.DM(10089,this,(t,e)=>{r.SDK.Data.Invoke(l.NET_API.AdvertisingBoard,this,t=>{t.bannerAdCode&&(this.BannerAdUnitIdList=[t.bannerAdCode]),t.screenAdCode&&(this.InterstitialAdUnitIdList=[t.screenAdCode]),this.SpreadAdUnitIdList,t.nativeAdCode&&(this.NativeAdUnitIdList=[t.nativeAdCode]),t.videoAdCode&&(this.VideoAdUnitIdList=[t.videoAdCode])}),r.SDK.API().Invoke(10089)}),this.DM(10090,this,(t,e)=>{r.SDK.TKMgr.Invoke(l.TK_DOT_API.EventDot,t,e)}),this.DM(10091,this,t=>{r.SDK.TKMgr.Invoke(l.TK_DOT_API.UserSet,t)}),this.DM(10092,this,t=>{r.SDK.TKMgr.Invoke(l.TK_DOT_API.UserSetOnce,t)}),this.DM(10093,this,t=>{r.SDK.TKMgr.Invoke(l.TK_DOT_API.TKLogin,t)}),this.DM(10094,this,t=>{r.SDK.TKMgr.Invoke(l.TK_DOT_API.TimeEvent,t)}),this.DM(10048,this,(t,e,i,s)=>{let n="ShowUserInfoButton";this.Log(n),this._P.CreateUIBtn(t,this,t=>{this.Log(n),this.SVT(l.SV.PfUInfo,t),r.SDK.C(e,i,t);let s=new w;t.nickName&&(s.nickName=t.nickName),t.avatarUrl&&(s.headimgurl=t.avatarUrl),t.gender&&(s.gender=t.gender),t.province&&(s.province=t.province),t.city&&(s.city=t.city),t.country&&(s.country=t.country),t.signature&&(s.signature=t.signature),t.iv&&(s.iv=t.iv),t.encryptedData&&(s.encryptedData=t.encryptedData),r.SDK.Data.Invoke(l.NET_API.Edit,s,e,()=>{}),t.nickName&&(this.NickName=t.nickName),t.avatarUrl&&(this.AvatarUrl=t.avatarUrl)},t=>{this.Warn(n+" error: "+t),r.SDK.C(e,s,null)}),r.SDK.API().Invoke(10048)}),this.DM(10049,this,()=>{this._P.ShowUIBtn(),r.SDK.API().Invoke(10049)}),this.DM(10050,this,()=>{this._P.HideUIBtn(),r.SDK.API().Invoke(10050)}),this.DM(10051,this,()=>{this._P.DestroyUIBtn(),r.SDK.API().Invoke(10051)}),this.DM(10052,this,(t,e,i,s,n)=>{if((new Date).getTime(),this._P.IntttAd&&this._intttAdWaitShow)return void this.Invoke(10053);if(!this.InterstitialAdUnitIdList||0==this.InterstitialAdUnitIdList.length)return void this.Log("InterstitialAdUnitIdList is empty");if(!this._CanCreateIntttAd())return void(e&&n&&n.call(e));let o=this,a=Math.floor(Math.random()*this.InterstitialAdUnitIdList.length),h=this.InterstitialAdUnitIdList[a];this._P.IntttAd&&this._P.ClearIntttAd(),this.Invoke(10004,l.TP_AD.CREATE,h),this._P.CreateIntttAd(h,this,()=>{o.Invoke(10004,l.TP_AD.LOAD_SUCCESS,h),t?o.Invoke(10053):e&&i&&i.call(e),o.Log("InterstitialAd OnLoad")},t=>{o.Invoke(10004,l.TP_AD.CLOSE,h),r.SDK.C(e,s,t),o._showInterstitialAd=!1,o._LCIntttAd=(new Date).getTime()},t=>{o.Invoke(10004,l.TP_AD.LOAD_FAIL,h),o.Warn("InterstistAd Error:"+t+" adId:"+h),r.SDK.C(e,n,t),o._showInterstitialAd=!1,o._LCIntttAd=(new Date).getTime()}),r.SDK.API().Invoke(10052)}),this.DM(10053,this,()=>{this._P.IntttAd?(this._intttAdWaitShow=!0,this._P.ShowIntttAd(this,()=>{this._showInterstitialAd=!0,this._intttAdWaitShow=!1,this.Invoke(10004,l.TP_AD.SHOW,this._P.IntttAdId)}),r.SDK.API().Invoke(10053)):this._intttAdWaitShow=!1}),this.DM(10054,this,(t,e,i)=>{t&&this.Strategy&&this.Strategy.GetSRlt(t,this,t=>{this.Warn("Sharing Results"),e&&i.call(e,t)}),r.SDK.API().Invoke(10054)}),this.DM(10055,this,t=>{if(!r.SDK.CME().SwitchLayer)return;if(!t||""==t)return void this.Warn("layerPath is null or empty");let e=(new Date).getTime();if(this._localLayerList){let t=this._localLayerList.get_time;t&&this.isToday(t)||(this._localLayerList=null)}let i=this._localLayerList,s=!1;if(i&&i.s_layers&&(s=i.s_layers.indexOf(t)>0),!(this.ListLayer&&this.ListLayer.length>0))return void this.Warn("流失列表为空,请确认是否调用获取流失列表接口,或后台配置了流失列表");let n=this.ListLayer,o=!1,a=-1;for(let e=0;e<n.length;e++)if(n[e].layerPath==t){o=!0,a=e;break}if(o&&-1!=a){if(!s){this._localLayerList||(this._localLayerList=new d.LocalLayerInfo,this._localLayerList.s_layers=[]);for(let t=0;t<=a;t++){let e=n[t].layerPath;this._localLayerList.s_layers.indexOf(e)<0&&(r.SDK.STAC().Invoke(l.NET_API.Stat_Layer,e,this,t=>{}),this._localLayerList.s_layers.push(e))}this._localLayerList.get_time=e,this.SVT(l.SV.LStttLayer,this._localLayerList)}this.Invoke(10011,t,"LayerOn")}else this.Warn("statLayer-layerPath not found","warn");r.SDK.API().Invoke(10055)}),this.DM(10056,this,()=>(r.SDK.API().Invoke(10056),this.ShareFalseLimit)),this.DM(10057,this,()=>(r.SDK.API().Invoke(10057),this.VideoFalseLimit)),this.DM(10058,this,(t,e)=>{r.SDK.Data.Invoke(l.NET_API.MyInfo,t,e),r.SDK.API().Invoke(10058)}),this.DM(10059,this,()=>{this._P.ExitGame(),r.SDK.API().Invoke(10059)}),this.DM(10060,this,()=>{this._P.VibrateShort(),r.SDK.API().Invoke(10060)}),this.DM(10061,this,()=>{this._P.VibrateLong(),r.SDK.API().Invoke(10061)}),this.DM(10062,this,(t,e,i,s,n)=>{this._P.InstallShortcut(this,()=>{t&&e&&e.call(t)},e=>{r.SDK.C(t,i,e)},()=>{t&&s&&s.call(t)},n),r.SDK.API().Invoke(10062)}),this.DM(10066,this,(t,e,i,s)=>{this._P.HasShortcut(this,i=>{r.SDK.C(t,e,i)},e=>{r.SDK.C(t,i,e)},()=>{t&&s&&s.call(t)}),r.SDK.API().Invoke(10066)}),this.DM(10063,this,(t,e,i=-1)=>{-1!==i&&(this.NativeIndex=i),this.NativeIndex>this.NativeAdUnitIdList.length&&r.SDK.E("原生广告Index异常",i),this.NativeIndex==this.NativeAdUnitIdList.length&&(this.NativeIndex=0),this.nativeAdId=this.NativeAdUnitIdList[this.NativeIndex],this.NativeIndex+=1,this._P.CreateNativeAd(this.nativeAdId,this,()=>{r.SDK.CME().Invoke(10008,l.TP_AD.CREATE,this.nativeAdId)},i=>{r.SDK.C(t,e,i)}),r.SDK.API().Invoke(10063)}),this.DM(10064,this,t=>{this._P.ShowNativeAd(t),r.SDK.CME().Invoke(10008,l.TP_AD.EXPOSURE,this.nativeAdId),r.SDK.API().Invoke(10064)}),this.DM(10065,this,t=>{this._P.ClickNativeAd(t),r.SDK.CME().Invoke(10008,l.TP_AD.CLICK,this.nativeAdId),r.SDK.API().Invoke(10065)}),this.DM(10068,this,(t,e,i,...s)=>{this._P.Hook(t,e,i)}),this.DM(10074,this,(t,e,i)=>{this.CloudApi.GetObject(t,e,i),r.SDK.API().Invoke(10074)}),this.DM(10075,this,(t,e,i)=>{this.CloudApi.GetString(t,e,i),r.SDK.API().Invoke(10075)}),this.DM(10076,this,(t,e,i,s)=>{this.CloudApi.SetObject(t,e,i,s),r.SDK.API().Invoke(10076)}),this.DM(10077,this,(t,e,i,s)=>{this.CloudApi.SetString(t,e,i,s),r.SDK.API().Invoke(10077)}),this.DM(10078,this,(t,e)=>{this.CloudApi.Size(t,e),r.SDK.API().Invoke(10078)}),this.DM(10079,this,(t,e,i)=>{this.CloudApi.DeleteObject(t,e,i),r.SDK.API().Invoke(10079)}),this.DM(10080,this,(t,e,i)=>{this.CloudApi.StoreValue(t,e,i),r.SDK.API().Invoke(10080)}),this.DM(10084,this,t=>{let e=!1,i=this.VideoFalseLimit,s=this.ShareFalseLimit;return t==l.SHARE_T.Video?i&&i>0&&(e=!0,i=(i-=1)<0?0:i,this.VideoFalseLimit=i):t==l.SHARE_T.Share&&s&&s>0&&(e=!0,s=(s-=1)<0?0:s,this.ShareFalseLimit=s),e&&(this.SVT(l.SV.VFLimit,this.VideoFalseLimit),this.SVT(l.SV.SFLimit,this.ShareFalseLimit)),r.SDK.API().Invoke(10084),e}),this.DM(10085,this,(t,e)=>{r.SDK.CME().SwitchCustom&&g.StatSystem.Me().StatCustomAd(t,e)})}_AddUnlockVideoLevelNumber(t){if(!t)return;this.AVT(l.SV.TdWVCounter,1),this.SVT(l.SV.LWhVTstamp,(new Date).getTime());let e=this.GVT(l.SV.LUlVLNumber,[]);-1==e.indexOf(t)&&(this.Log("AddUnlockLevelNumber index="+t),e.push(t),this.SVT(l.SV.LUlVLNumber,e))}RefreshLastPlayTime(){this._LastPlayTime=(new Date).getTime()}_CanCreateIntttAd(){let t=((new Date).getTime()-this._LCIntttAd)/1e3,e=!1;return this.Log("CreateIntertitialAd interval:",t),(e=this._P.IntttAd?t>=(this.IntttAdFirstShowWT||0):t>=(this.IntttAdShowTimeI||0))||this.Warn("创建插屏广告太频繁，请稍后再试"),e}isToday(t){let e=new Date,i=e.getFullYear(),s=e.getMonth()+1,n=e.getDate(),r=new Date(t),o=r.getFullYear(),a=r.getMonth()+1,h=r.getDate();return i==o&&s==a&&n==h}_AddPowerByVideo(){if(!this.PSysCfg||!1===this.PSysCfg.IsOn)return void this.Log("Power System is off");let t=this.PSysCfg.VideoPowerWeight,e=this.PowerSystem.GetPower();this.PowerSystem.SetPower(e+t,l.P_R_T.WatchVideo)}IsCanRewardByVideoOrShare(t){let e=!1,i=this.VideoFalseLimit,s=this.ShareFalseLimit;return t==l.SHARE_T.Video?i&&i>0&&(e=!0,i=(i-=1)<0?0:i,this.VideoFalseLimit=i):t==l.SHARE_T.Share&&s&&s>0&&(e=!0,s=(s-=1)<0?0:s,this.ShareFalseLimit=s),e&&(this.SVT(l.SV.VFLimit,this.VideoFalseLimit),this.SVT(l.SV.SFLimit,this.ShareFalseLimit)),r.SDK.API().Invoke(10084),e}_CreateBannerAd(t,e,i,s,n,o,a){if(this.BannerAdUnitIdList&&0!=this.BannerAdUnitIdList.length){this._P.BnAd&&(this._P.DstyBnAd(),this._P.IsSBnAd=!1);let h=this;this._needShowBannerAd=!0;let d=Math.floor(Math.random()*this.BannerAdUnitIdList.length),S=this.BannerAdUnitIdList[d];this._P.CreateBnAd(t,S,e,s,this,a),this.Invoke(10002,l.TP_AD.CREATE,S);let c=this.BnRefCfg&&this.BnRefCfg.IsOn;c&&(this._IsSmallBannerAd=t),this._P.BnAd.onLoad(function(){h.Log("BannerAd onLoad"),h.Invoke(10002,l.TP_AD.LOAD_SUCCESS,S),i&&h._needShowBannerAd&&h.Invoke(10038),n&&o&&r.SDK.C(n,o,!0)}),this._P.BnAd.onError(t=>{if(h.Invoke(10002,l.TP_AD.LOAD_FAIL,S),h.Warn("BannerAd onError:",t),this._P.DstyBnAd(),this._needShowBannerAd=!1,this._P.IsSBnAd=!1,c){let t=h.BnRefCfg.Interval;h.Log(`将在${t}秒后重新创建banner(调用ylBannerAdHide会取消重试`),u.default.RemoveDelayTimer(h._BannerAdDelayTimerId),h._BannerAdDelayTimerId=u.default.Delay(1e3*t,h,()=>{h._CreateBannerAd(this._IsSmallBannerAd,e,i,s,a,n,o)}),n&&o&&r.SDK.C(n,o,!1)}})}else this.Error("BannerAdUnitIdList is empty.")}LoginByAccountPass(){window.ConfigTestMgr&&(this.AccountPass=window.ConfigTestMgr.AccountPass,this.SVT(l.SV.APYDHW,{account_pass:this.AccountPass,save_time:(new Date).getTime()}),h.Url.SetAccountPass(this.AccountPass));let t=this.GVT(l.SV.APYDHW,null);if(t){r.SDK.L("YDHW AccountPass:"+JSON.stringify(t));let e=!0;if(t.save_time&&(e=(new Date).getTime()-t.save_time>=432e5),!e)return this.AccountPass=t.account_pass,h.Url.SetAccountPass(this.AccountPass),!0}return!1}Log(t,...e){this.SwitchLog&&super.Log(t,...e)}Debug(t,...e){this.SwitchLog&&super.Debug(t,...e)}Info(t,...e){this.SwitchLog&&super.Info(t,...e)}Warn(t,...e){this.SwitchLog&&super.Warn(t,...e)}Error(t,...e){this.SwitchLog&&super.Error(t,...e)}}},"./sdk/Model/Data.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"StoreValueReq",function(){return s}),i.d(e,"BannerRefreshCfg",function(){return n}),i.d(e,"PowerSystemCfg",function(){return r}),i.d(e,"VideoUnlockLevelCfg",function(){return o}),i.d(e,"DeepSheildRuleCfg",function(){return a}),i.d(e,"MisTouchSwitchCfg",function(){return h}),i.d(e,"DeveloperAccountCfg",function(){return l}),i.d(e,"LocalLayerInfo",function(){return d});class s{constructor(){this.name="",this.cmd="",this.args=""}}class n{}class r{constructor(){this.DefaultPowerValue=0,this.UpperLimit=0,this.AutoRecoveryTime=0,this.VideoPowerWeight=0,this.IsOn=!1}}class o{constructor(){this.IsOn=!1,this.CustomNumber=0,this.IntervalCount=0}}class a{constructor(){this.Type=0,this.CustomNumberCounter=0,this.ExecellentUserSwitch=!1,this.WatchVideoCounter=0,this.DayCustomNumber=[]}}class h{constructor(){this.IsOn=!1,this.StartTimeHour=0,this.StartTimeMinute=0,this.EndTimeHour=0,this.EndTimeMinute=0}}class l{constructor(){this.IsOn=!1,this.Accounts=[]}}class d{constructor(){this.s_layers=null,this.get_time=null}}},"./sdk/Model/Default.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"BannerAdStyle",function(){return s}),i.d(e,"ShareAppInfo",function(){return n}),i.d(e,"ShareBackInfo",function(){return r}),i.d(e,"CustomInfo",function(){return o}),i.d(e,"DeepTouchInfo",function(){return a}),i.d(e,"AppInfo",function(){return h}),i.d(e,"JumpOutInfo",function(){return l}),i.d(e,"StatisticEventReq",function(){return d});class s{}class n{constructor(){this.channel="",this.module="",this.showTime=0,this.shareId=0}}class r{constructor(){this.IsSuccess=!1,this.IsHasStrategy=!1,this.Tips=null}}class o{constructor(){this._id=0,this.name="",this.version="",this.type="",this.value="",this.switchRegionUse="",this.switchTouchUse="",this.desc=""}}class a{constructor(){this.deepTouch=!1,this.ListCustomInfo=[]}}class h{constructor(t){this.appid="",this.appid=t}}class l{constructor(){this.Date=0,this.List=[]}}class d{}},"./sdk/Model/Statistic.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"ClientLogReq",function(){return s}),i.d(e,"ClickOutReq",function(){return n}),i.d(e,"SdkInfo",function(){return r}),i.d(e,"StatistiicShareInfo",function(){return o});class s{}class n{}class r{}class o{constructor(t,e,i,s,n){this.sharecardId=e||-1,this.shareTime=t,null!=i&&(this.sType=i||0),s&&(this.target=s),this.real=n||0}}},"./sdk/Model/User.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"ShareInfo",function(){return s}),i.d(e,"ClientInfo",function(){return n}),i.d(e,"LoginRequest",function(){return r}),i.d(e,"LoginRsp",function(){return o}),i.d(e,"StrategyData",function(){return a}),i.d(e,"Tips",function(){return h}),i.d(e,"ShareVideoModuleFalse",function(){return l}),i.d(e,"LoopCtrl",function(){return d}),i.d(e,"ShareVideoModule",function(){return S}),i.d(e,"UnUseShareVideoModule",function(){return c});class s{}class n{}class r{}class o{}class a{}class h{}class l{constructor(){this.strategyId=0,this.timeId=0,this.count=0}}class d{}class S{}class c{}},"./sdk/SDK/Declare.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"SDK",function(){return h});var s=i("./fw/Core.ts"),n=i("./sdk/SDK/Enum.ts"),r=i("./fw/Utility/Url.ts"),o=i("./sdk/Base/SDKP.ts"),a=i("./sdk/Assist/Log.ts");class h{static Domain(){return this._Url}static P(){return null==this._Me&&(this._Me=new o.SDKP),this._Me}static Core(){return s.Core.Me()}static get Me(){return s.Core.Me().AsManager()}static get Agent(){return s.Core.Me().GetManager(n.MGR.Agent)}static CME(){return s.Core.Me().GetManager(n.MGR.Commerce)}static STAC(){return s.Core.Me().GetManager(n.MGR.Statistic)}static API(){return s.Core.Me().GetManager(n.MGR.Api)}static get Data(){return s.Core.Me().GetManager(n.MGR.Data)}static get TKMgr(){return s.Core.Me().GetManager(n.MGR.TKMgr)}static copy(t){var e;if("object"==typeof t){e=t instanceof Array?[]:Object.create(null);for(let i in t)e[i]=h.copy(t[i])}else e=t;return e}static E(t,e){h.Debug&&a.Log.Log(t+" Response=",e)}static L(...t){h.Debug&&console.log(...t)}static W(...t){h.Debug&&console.warn(...t)}static E1(t){h.Debug&&a.Log.Error("server say:"+t.info+" code:"+t.code)}static C(t,e,...i){!t&&h.Debug&&a.Log.Warn("caller is null"),!e&&h.Debug&&a.Log.Warn("method is null"),t&&e&&e.call(t,...i)}}h.Debug=!1,h._Url=new r.Url,h._Me=null},"./sdk/SDK/Enum.ts":function(t,e,i){"use strict";var s;i.r(e),i.d(e,"MGR",function(){return s}),function(t){t.Agent="AgentMgr",t.Event="EventMgr",t.Commerce="CommerceMgr",t.Resource="ResourceMgr",t.State="StateMgr",t.Panel="PanelMgr",t.Statistic="StatisticMgr",t.Data="DataMgr",t.Sound="SoundMgr",t.Platform="PlatformMgr",t.Logic="Logic",t.Log="LogMgr",t.Power="Power",t.Api="ApiMgr",t.TKMgr="ThinkingMgr"}(s||(s={}))},"./sdk/SDK/EventDef.ts":function(t,e,i){"use strict";var s,n,r,o,a,h,l,d,S,c,u,D,C,_;i.r(e),i.d(e,"NET_API",function(){return s}),i.d(e,"ST_S_TYPE",function(){return n}),i.d(e,"TK_DOT_API",function(){return r}),i.d(e,"SV",function(){return o}),i.d(e,"SE",function(){return a}),i.d(e,"VIDEO_P_T",function(){return h}),i.d(e,"TP_AD",function(){return l}),i.d(e,"SHARE_T",function(){return d}),i.d(e,"P_R_T",function(){return S}),i.d(e,"POWER_EVT",function(){return c}),i.d(e,"TIMER_NAME",function(){return u}),i.d(e,"EM_APP_BOX_TYPE",function(){return D}),i.d(e,"BLOCK_T",function(){return C}),i.d(e,"SHARE_A_T",function(){return _}),function(t){t[t.Edit=201]="Edit",t[t.Login=202]="Login",t[t.MyInfo=203]="MyInfo",t[t.Banner=204]="Banner",t[t.Video=205]="Video",t[t.InterstitialAd=206]="InterstitialAd",t[t.GridAd=207]="GridAd",t[t.AppBoxAd=208]="AppBoxAd",t[t.BlockAd=209]="BlockAd",t[t.NativeAd=210]="NativeAd",t[t.CustomAd=211]="CustomAd",t[t.ClickOut=212]="ClickOut",t[t.ClientLog=213]="ClientLog",t[t.Duration=214]="Duration",t[t.Event=215]="Event",t[t.Stat_Api=216]="Stat_Api",t[t.Stat_Layer=217]="Stat_Layer",t[t.Result=218]="Result",t[t.Stat_ShareCard=219]="Stat_ShareCard",t[t.Config=220]="Config",t[t.CustomConfig=221]="CustomConfig",t[t.DataDecode=222]="DataDecode",t[t.GetBoardAward=223]="GetBoardAward",t[t.Data_Layer=224]="Data_Layer",t[t.ScoreBoard=225]="ScoreBoard",t[t.SideBox=226]="SideBox",t[t.Data_ShareCard=227]="Data_ShareCard",t[t.StoreValue=228]="StoreValue",t[t.GetMyIp=229]="GetMyIp",t[t.AdvertisingBoard=230]="AdvertisingBoard",t[t.AccountToken=231]="AccountToken",t[t.CancelPay=232]="CancelPay",t[t.GivinglGameCurrency=233]="GivinglGameCurrency",t[t.GameCurrencyPay=234]="GameCurrencyPay",t[t.GetServerUserInfo=235]="GetServerUserInfo",t[t.HuaweiPay=236]="HuaweiPay",t[t.HuaweiPayReques=237]="HuaweiPayReques",t[t.OPPaySign=238]="OPPaySign",t[t.OPPayResult=239]="OPPayResult",t[t.OPCreatOrder=240]="OPCreatOrder",t[t.OpPlaceAnOrder=241]="OpPlaceAnOrder"}(s||(s={})),function(t){t[t.Banner=1]="Banner",t[t.Video=2]="Video",t[t.Interstitial=3]="Interstitial",t[t.Grid=4]="Grid",t[t.AppBox=5]="AppBox",t[t.Block=6]="Block",t[t.CustomAd=7]="CustomAd",t[t.Native=8]="Native",t[t.Result=9]="Result",t[t.ClickOut=10]="ClickOut",t[t.Event=11]="Event"}(n||(n={})),function(t){t[t.TKLogin=1]="TKLogin",t[t.EventDot=2]="EventDot",t[t.EvtAdEnd=3]="EvtAdEnd",t[t.EVtAdStart=4]="EVtAdStart",t[t.share=5]="share",t[t.UserSet=6]="UserSet",t[t.UserSetOnce=7]="UserSetOnce",t[t.TimeEvent=8]="TimeEvent"}(r||(r={})),function(t){t[t.APYDHW=30001]="APYDHW",t[t.TPCounter=30002]="TPCounter",t[t.LPAddTstamp=30003]="LPAddTstamp",t[t.CDPro=30004]="CDPro",t[t.OnCD=30005]="OnCD",t[t.TdWVCounter=30006]="TdWVCounter",t[t.LWhVTstamp=30007]="LWhVTstamp",t[t.LUlVLNumber=30008]="LUlVLNumber",t[t.LStttLayer=30009]="LStttLayer",t[t.SConfig=30010]="SConfig",t[t.MCNumber=30011]="MCNumber",t[t.LCNumber=30012]="LCNumber",t[t.TdCNCounter=30013]="TdCNCounter",t[t.TCNCounter=30014]="TCNCounter",t[t.LPTstamp=30015]="LPTstamp",t[t.JOInfo=30016]="JOInfo",t[t.VFLimit=30017]="VFLimit",t[t.SFLimit=30018]="SFLimit",t[t.PfUInfo=30019]="PfUInfo",t[t.BatchID=30020]="BatchID",t[t.PACList=30021]="PACList"}(o||(o={})),function(t){t[t.OnFrontend=20012]="OnFrontend",t[t.OnBackend=20013]="OnBackend"}(a||(a={})),function(t){t[t.FAIL=0]="FAIL",t[t.FINISH=1]="FINISH",t[t.CANCEL=2]="CANCEL",t[t.SHOW=3]="SHOW"}(h||(h={})),function(t){t[t.CREATE=0]="CREATE",t[t.LOAD_SUCCESS=1]="LOAD_SUCCESS",t[t.LOAD_FAIL=2]="LOAD_FAIL",t[t.CLICK=3]="CLICK",t[t.SHOW=4]="SHOW",t[t.CLOSE=5]="CLOSE",t[t.EXPOSURE=6]="EXPOSURE",t[t.PLAY_CANCEL=7]="PLAY_CANCEL",t[t.PLAY_FINISH=8]="PLAY_FINISH"}(l||(l={})),function(t){t[t.None=0]="None",t[t.Share=1]="Share",t[t.Video=2]="Video"}(d||(d={})),function(t){t[t.None=0]="None",t[t.WatchVideo=1]="WatchVideo",t[t.AutoRecovery=2]="AutoRecovery",t[t.CountDown=3]="CountDown"}(S||(S={})),function(t){t[t.AddPower=0]="AddPower"}(c||(c={})),function(t){t.RotateTurnplate="RotateTurnplate",t.SaveLastTimestamp="SaveLastTimestamp"}(u||(u={})),function(t){t[t.C_SUC=0]="C_SUC",t[t.C_FAIL=1]="C_FAIL",t[t.CLOSE=2]="CLOSE"}(D||(D={})),function(t){t[t.C_SUC=0]="C_SUC",t[t.C_FAIL=1]="C_FAIL",t[t.ONRESIZE=2]="ONRESIZE"}(C||(C={})),function(t){t.QQ="qq",t.QQ_FAST_SHARE="qqFastShare",t.QQ_FAST_SHARE_LIST="qqFastShareList",t.QZONE="qzone",t.WECHARTFRIENDS="wechatFriends",t.WECHATMOMENT="wechatMoment"}(_||(_={}))},"./sdk_oppo/Main.ts":function(t,e,i){"use strict";i.r(e);var s=i("./sdk/SDK/Declare.ts"),n=i("./sdk/Commerce/OppoC.ts"),r=i("./sdk/SDK/Enum.ts"),o=i("./fw/Utility/LogUtility.ts"),a=i("./sdk/Mgr/CommerceMgr.ts");new class{constructor(){if(this.SDK_NAME="ydhw_oppo",this.ALL_SDK_NAME="ydhw",o.LogUtility.IS_ENABLE_DEBUG=!0,o.LogUtility.Me().P=s.SDK.P(),!s.SDK.P().Init())return void console.error("Init SDK failed!");let t=new n.OppoP;t.Init();let e=new n.OppoC;e._P=t,e.P=t,null!=window[this.SDK_NAME]?s.SDK.Debug&&console.error("已存在: "+this.SDK_NAME):null!=e?(s.SDK.L("Main constructor platform.Init():",s.SDK.P().PfType),window[this.SDK_NAME]=e,window[this.ALL_SDK_NAME]=e):s.SDK.Debug&&console.error("不存在平台对应的SDK"),s.SDK.Domain().Domain(["http://test-api.ylxyx.cn","https://api.ylxyx.cn","https://jits.open.oppomobile.com"]).Manager("api/collect").Version("v1").Switch(1),s.SDK.Core().Add(r.MGR.Commerce,e).Add(r.MGR.Agent,new a.AgentMgr).Add(r.MGR.Statistic,new a.StatMgr).Add(r.MGR.Data,new a.DataMgr).Add(r.MGR.Api,new a.ApiMgr).Initialize(),s.SDK.Core().Restore()}}},"./src/Utils/TimeUtils.ts":function(t,e,i){"use strict";i.r(e),i.d(e,"default",function(){return h});var s=0,n=0,r={},o={},a=function(t,e){var i=t[e];i&&(delete t[e],Laya.timer.clear(null,i))};class h{constructor(){}static formatTen(t){return(t>9?"":"0")+t}static formatHour(t,e=":"){var i=h.formatTen,s=(t/60|0)%60,n=t%60;return i(t/3600|0)+e+i(s)+e+i(n)}static getDay(t){return(t/36e5+8)/24|0}static isSameDay(t,e){var i=h.getDay;return i(t)==i(e)}static setTimeout(t,e,i,...n){var o=++s,a=r[o]=function(){t.apply(e,n),delete r[o]};return Laya.timer.once(i,null,a),o}static clearTimeout(t){a(r,t)}static setInterval(t,e,i,...s){var r=++n,a=o[r]=function(){t.apply(e,s)};return Laya.timer.loop(i,null,a),r}static clearInterval(t){a(o,t)}static log(...t){let e=h.formatDate(new Date,"[hh:mm:ss.SSS]");t.forEach(t=>{e+=" "+JSON.stringify(t)}),console.log(e)}static formatDate(t,e){let i={"Y+":t.getFullYear(),"M+":t.getMonth()+1,"d+":t.getDate(),"h+":t.getHours(),"m+":t.getMinutes(),"s+":t.getSeconds(),"S+":t.getMilliseconds()};/(y+)/.test(e)&&(e=e.replace(RegExp.$1,(t.getFullYear()+"").substr(4-RegExp.$1.length)));for(let t in i)new RegExp("("+t+")").test(e)&&(e=e.replace(RegExp.$1,1==RegExp.$1.length?i[t]:("00"+i[t]).substr((""+i[t]).length)));return e}static formatFullDate(t,e){let i={"Y+":t.getFullYear(),"M+":t.getMonth()+1,"d+":t.getDate(),"h+":t.getHours(),"m+":t.getMinutes(),"s+":t.getSeconds(),"S+":t.getMilliseconds()};/(y+)/.test(e)&&(e=e.replace(RegExp.$1,(t.getFullYear()+"").substr(4-RegExp.$1.length)));for(let t in i)new RegExp("("+t+")").test(e)&&(e=e.replace(RegExp.$1,1==RegExp.$1.length?i[t]:("00"+i[t]).substr((""+i[t]).length)));return t.getFullYear()+e.substr(2,e.length)}}}});
})();

/******/ })()
;