/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/*global window, global*/
var util = __webpack_require__(3)
var assert = __webpack_require__(59)
function now() { return new Date().getTime() }

var slice = Array.prototype.slice
var console
var times = {}

if (typeof __webpack_require__.g !== "undefined" && __webpack_require__.g.console) {
    console = __webpack_require__.g.console
} else if (typeof window !== "undefined" && window.console) {
    console = window.console
} else {
    console = {}
}

var functions = [
    [log, "log"],
    [info, "info"],
    [warn, "warn"],
    [error, "error"],
    [time, "time"],
    [timeEnd, "timeEnd"],
    [trace, "trace"],
    [dir, "dir"],
    [consoleAssert, "assert"]
]

for (var i = 0; i < functions.length; i++) {
    var tuple = functions[i]
    var f = tuple[0]
    var name = tuple[1]

    if (!console[name]) {
        console[name] = f
    }
}

module.exports = console

function log() {}

function info() {
    console.log.apply(console, arguments)
}

function warn() {
    console.log.apply(console, arguments)
}

function error() {
    console.warn.apply(console, arguments)
}

function time(label) {
    times[label] = now()
}

function timeEnd(label) {
    var time = times[label]
    if (!time) {
        throw new Error("No such label: " + label)
    }

    delete times[label]
    var duration = now() - time
    console.log(label + ": " + duration + "ms")
}

function trace() {
    var err = new Error()
    err.name = "Trace"
    err.message = util.format.apply(null, arguments)
    console.error(err.stack)
}

function dir(object) {
    console.log(util.inspect(object) + "\n")
}

function consoleAssert(expression) {
    if (!expression) {
        var arr = slice.call(arguments, 1)
        assert.ok(false, util.format.apply(null, arr))
    }
}


/***/ }),
/* 3 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(4);
/* provided dependency */ var console = __webpack_require__(2);
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors ||
  function getOwnPropertyDescriptors(obj) {
    var keys = Object.keys(obj);
    var descriptors = {};
    for (var i = 0; i < keys.length; i++) {
      descriptors[keys[i]] = Object.getOwnPropertyDescriptor(obj, keys[i]);
    }
    return descriptors;
  };

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  if (typeof process !== 'undefined' && process.noDeprecation === true) {
    return fn;
  }

  // Allow for deprecating things in the process of starting up.
  if (typeof process === 'undefined') {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnvRegex = /^$/;

if (process.env.NODE_DEBUG) {
  var debugEnv = process.env.NODE_DEBUG;
  debugEnv = debugEnv.replace(/[|\\{}()[\]^$+?.]/g, '\\$&')
    .replace(/\*/g, '.*')
    .replace(/,/g, '$|^')
    .toUpperCase();
  debugEnvRegex = new RegExp('^' + debugEnv + '$', 'i');
}
exports.debuglog = function(set) {
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (debugEnvRegex.test(set)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').slice(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.slice(1, -1);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
exports.types = __webpack_require__(5);

function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;
exports.types.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;
exports.types.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;
exports.types.isNativeError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = __webpack_require__(57);

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = __webpack_require__(58);

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

var kCustomPromisifiedSymbol = typeof Symbol !== 'undefined' ? Symbol('util.promisify.custom') : undefined;

exports.promisify = function promisify(original) {
  if (typeof original !== 'function')
    throw new TypeError('The "original" argument must be of type Function');

  if (kCustomPromisifiedSymbol && original[kCustomPromisifiedSymbol]) {
    var fn = original[kCustomPromisifiedSymbol];
    if (typeof fn !== 'function') {
      throw new TypeError('The "util.promisify.custom" argument must be of type Function');
    }
    Object.defineProperty(fn, kCustomPromisifiedSymbol, {
      value: fn, enumerable: false, writable: false, configurable: true
    });
    return fn;
  }

  function fn() {
    var promiseResolve, promiseReject;
    var promise = new Promise(function (resolve, reject) {
      promiseResolve = resolve;
      promiseReject = reject;
    });

    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }
    args.push(function (err, value) {
      if (err) {
        promiseReject(err);
      } else {
        promiseResolve(value);
      }
    });

    try {
      original.apply(this, args);
    } catch (err) {
      promiseReject(err);
    }

    return promise;
  }

  Object.setPrototypeOf(fn, Object.getPrototypeOf(original));

  if (kCustomPromisifiedSymbol) Object.defineProperty(fn, kCustomPromisifiedSymbol, {
    value: fn, enumerable: false, writable: false, configurable: true
  });
  return Object.defineProperties(
    fn,
    getOwnPropertyDescriptors(original)
  );
}

exports.promisify.custom = kCustomPromisifiedSymbol

function callbackifyOnRejected(reason, cb) {
  // `!reason` guard inspired by bluebird (Ref: https://goo.gl/t5IS6M).
  // Because `null` is a special error value in callbacks which means "no error
  // occurred", we error-wrap so the callback consumer can distinguish between
  // "the promise rejected with null" or "the promise fulfilled with undefined".
  if (!reason) {
    var newReason = new Error('Promise was rejected with a falsy value');
    newReason.reason = reason;
    reason = newReason;
  }
  return cb(reason);
}

function callbackify(original) {
  if (typeof original !== 'function') {
    throw new TypeError('The "original" argument must be of type Function');
  }

  // We DO NOT return the promise as it gives the user a false sense that
  // the promise is actually somehow related to the callback's execution
  // and that the callback throwing will reject the promise.
  function callbackified() {
    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }

    var maybeCb = args.pop();
    if (typeof maybeCb !== 'function') {
      throw new TypeError('The last argument must be of type Function');
    }
    var self = this;
    var cb = function() {
      return maybeCb.apply(self, arguments);
    };
    // In true node style we process the callback on `nextTick` with all the
    // implications (stack, `uncaughtException`, `async_hooks`)
    original.apply(this, args)
      .then(function(ret) { process.nextTick(cb.bind(null, null, ret)) },
            function(rej) { process.nextTick(callbackifyOnRejected.bind(null, rej, cb)) });
  }

  Object.setPrototypeOf(callbackified, Object.getPrototypeOf(original));
  Object.defineProperties(callbackified,
                          getOwnPropertyDescriptors(original));
  return callbackified;
}
exports.callbackify = callbackify;


/***/ }),
/* 4 */
/***/ ((module) => {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/util/types.js
// https://github.com/nodejs/node/commit/112cc7c27551254aa2b17098fb774867f05ed0d9



var isArgumentsObject = __webpack_require__(6);
var isGeneratorFunction = __webpack_require__(43);
var whichTypedArray = __webpack_require__(46);
var isTypedArray = __webpack_require__(56);

function uncurryThis(f) {
  return f.call.bind(f);
}

var BigIntSupported = typeof BigInt !== 'undefined';
var SymbolSupported = typeof Symbol !== 'undefined';

var ObjectToString = uncurryThis(Object.prototype.toString);

var numberValue = uncurryThis(Number.prototype.valueOf);
var stringValue = uncurryThis(String.prototype.valueOf);
var booleanValue = uncurryThis(Boolean.prototype.valueOf);

if (BigIntSupported) {
  var bigIntValue = uncurryThis(BigInt.prototype.valueOf);
}

if (SymbolSupported) {
  var symbolValue = uncurryThis(Symbol.prototype.valueOf);
}

function checkBoxedPrimitive(value, prototypeValueOf) {
  if (typeof value !== 'object') {
    return false;
  }
  try {
    prototypeValueOf(value);
    return true;
  } catch(e) {
    return false;
  }
}

exports.isArgumentsObject = isArgumentsObject;
exports.isGeneratorFunction = isGeneratorFunction;
exports.isTypedArray = isTypedArray;

// Taken from here and modified for better browser support
// https://github.com/sindresorhus/p-is-promise/blob/cda35a513bda03f977ad5cde3a079d237e82d7ef/index.js
function isPromise(input) {
	return (
		(
			typeof Promise !== 'undefined' &&
			input instanceof Promise
		) ||
		(
			input !== null &&
			typeof input === 'object' &&
			typeof input.then === 'function' &&
			typeof input.catch === 'function'
		)
	);
}
exports.isPromise = isPromise;

function isArrayBufferView(value) {
  if (typeof ArrayBuffer !== 'undefined' && ArrayBuffer.isView) {
    return ArrayBuffer.isView(value);
  }

  return (
    isTypedArray(value) ||
    isDataView(value)
  );
}
exports.isArrayBufferView = isArrayBufferView;


function isUint8Array(value) {
  return whichTypedArray(value) === 'Uint8Array';
}
exports.isUint8Array = isUint8Array;

function isUint8ClampedArray(value) {
  return whichTypedArray(value) === 'Uint8ClampedArray';
}
exports.isUint8ClampedArray = isUint8ClampedArray;

function isUint16Array(value) {
  return whichTypedArray(value) === 'Uint16Array';
}
exports.isUint16Array = isUint16Array;

function isUint32Array(value) {
  return whichTypedArray(value) === 'Uint32Array';
}
exports.isUint32Array = isUint32Array;

function isInt8Array(value) {
  return whichTypedArray(value) === 'Int8Array';
}
exports.isInt8Array = isInt8Array;

function isInt16Array(value) {
  return whichTypedArray(value) === 'Int16Array';
}
exports.isInt16Array = isInt16Array;

function isInt32Array(value) {
  return whichTypedArray(value) === 'Int32Array';
}
exports.isInt32Array = isInt32Array;

function isFloat32Array(value) {
  return whichTypedArray(value) === 'Float32Array';
}
exports.isFloat32Array = isFloat32Array;

function isFloat64Array(value) {
  return whichTypedArray(value) === 'Float64Array';
}
exports.isFloat64Array = isFloat64Array;

function isBigInt64Array(value) {
  return whichTypedArray(value) === 'BigInt64Array';
}
exports.isBigInt64Array = isBigInt64Array;

function isBigUint64Array(value) {
  return whichTypedArray(value) === 'BigUint64Array';
}
exports.isBigUint64Array = isBigUint64Array;

function isMapToString(value) {
  return ObjectToString(value) === '[object Map]';
}
isMapToString.working = (
  typeof Map !== 'undefined' &&
  isMapToString(new Map())
);

function isMap(value) {
  if (typeof Map === 'undefined') {
    return false;
  }

  return isMapToString.working
    ? isMapToString(value)
    : value instanceof Map;
}
exports.isMap = isMap;

function isSetToString(value) {
  return ObjectToString(value) === '[object Set]';
}
isSetToString.working = (
  typeof Set !== 'undefined' &&
  isSetToString(new Set())
);
function isSet(value) {
  if (typeof Set === 'undefined') {
    return false;
  }

  return isSetToString.working
    ? isSetToString(value)
    : value instanceof Set;
}
exports.isSet = isSet;

function isWeakMapToString(value) {
  return ObjectToString(value) === '[object WeakMap]';
}
isWeakMapToString.working = (
  typeof WeakMap !== 'undefined' &&
  isWeakMapToString(new WeakMap())
);
function isWeakMap(value) {
  if (typeof WeakMap === 'undefined') {
    return false;
  }

  return isWeakMapToString.working
    ? isWeakMapToString(value)
    : value instanceof WeakMap;
}
exports.isWeakMap = isWeakMap;

function isWeakSetToString(value) {
  return ObjectToString(value) === '[object WeakSet]';
}
isWeakSetToString.working = (
  typeof WeakSet !== 'undefined' &&
  isWeakSetToString(new WeakSet())
);
function isWeakSet(value) {
  return isWeakSetToString(value);
}
exports.isWeakSet = isWeakSet;

function isArrayBufferToString(value) {
  return ObjectToString(value) === '[object ArrayBuffer]';
}
isArrayBufferToString.working = (
  typeof ArrayBuffer !== 'undefined' &&
  isArrayBufferToString(new ArrayBuffer())
);
function isArrayBuffer(value) {
  if (typeof ArrayBuffer === 'undefined') {
    return false;
  }

  return isArrayBufferToString.working
    ? isArrayBufferToString(value)
    : value instanceof ArrayBuffer;
}
exports.isArrayBuffer = isArrayBuffer;

function isDataViewToString(value) {
  return ObjectToString(value) === '[object DataView]';
}
isDataViewToString.working = (
  typeof ArrayBuffer !== 'undefined' &&
  typeof DataView !== 'undefined' &&
  isDataViewToString(new DataView(new ArrayBuffer(1), 0, 1))
);
function isDataView(value) {
  if (typeof DataView === 'undefined') {
    return false;
  }

  return isDataViewToString.working
    ? isDataViewToString(value)
    : value instanceof DataView;
}
exports.isDataView = isDataView;

// Store a copy of SharedArrayBuffer in case it's deleted elsewhere
var SharedArrayBufferCopy = typeof SharedArrayBuffer !== 'undefined' ? SharedArrayBuffer : undefined;
function isSharedArrayBufferToString(value) {
  return ObjectToString(value) === '[object SharedArrayBuffer]';
}
function isSharedArrayBuffer(value) {
  if (typeof SharedArrayBufferCopy === 'undefined') {
    return false;
  }

  if (typeof isSharedArrayBufferToString.working === 'undefined') {
    isSharedArrayBufferToString.working = isSharedArrayBufferToString(new SharedArrayBufferCopy());
  }

  return isSharedArrayBufferToString.working
    ? isSharedArrayBufferToString(value)
    : value instanceof SharedArrayBufferCopy;
}
exports.isSharedArrayBuffer = isSharedArrayBuffer;

function isAsyncFunction(value) {
  return ObjectToString(value) === '[object AsyncFunction]';
}
exports.isAsyncFunction = isAsyncFunction;

function isMapIterator(value) {
  return ObjectToString(value) === '[object Map Iterator]';
}
exports.isMapIterator = isMapIterator;

function isSetIterator(value) {
  return ObjectToString(value) === '[object Set Iterator]';
}
exports.isSetIterator = isSetIterator;

function isGeneratorObject(value) {
  return ObjectToString(value) === '[object Generator]';
}
exports.isGeneratorObject = isGeneratorObject;

function isWebAssemblyCompiledModule(value) {
  return ObjectToString(value) === '[object WebAssembly.Module]';
}
exports.isWebAssemblyCompiledModule = isWebAssemblyCompiledModule;

function isNumberObject(value) {
  return checkBoxedPrimitive(value, numberValue);
}
exports.isNumberObject = isNumberObject;

function isStringObject(value) {
  return checkBoxedPrimitive(value, stringValue);
}
exports.isStringObject = isStringObject;

function isBooleanObject(value) {
  return checkBoxedPrimitive(value, booleanValue);
}
exports.isBooleanObject = isBooleanObject;

function isBigIntObject(value) {
  return BigIntSupported && checkBoxedPrimitive(value, bigIntValue);
}
exports.isBigIntObject = isBigIntObject;

function isSymbolObject(value) {
  return SymbolSupported && checkBoxedPrimitive(value, symbolValue);
}
exports.isSymbolObject = isSymbolObject;

function isBoxedPrimitive(value) {
  return (
    isNumberObject(value) ||
    isStringObject(value) ||
    isBooleanObject(value) ||
    isBigIntObject(value) ||
    isSymbolObject(value)
  );
}
exports.isBoxedPrimitive = isBoxedPrimitive;

function isAnyArrayBuffer(value) {
  return typeof Uint8Array !== 'undefined' && (
    isArrayBuffer(value) ||
    isSharedArrayBuffer(value)
  );
}
exports.isAnyArrayBuffer = isAnyArrayBuffer;

['isProxy', 'isExternal', 'isModuleNamespaceObject'].forEach(function(method) {
  Object.defineProperty(exports, method, {
    enumerable: false,
    value: function() {
      throw new Error(method + ' is not supported in userland');
    }
  });
});


/***/ }),
/* 6 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var hasToStringTag = __webpack_require__(7)();
var callBound = __webpack_require__(9);

var $toString = callBound('Object.prototype.toString');

/** @type {import('.')} */
var isStandardArguments = function isArguments(value) {
	if (
		hasToStringTag
		&& value
		&& typeof value === 'object'
		&& Symbol.toStringTag in value
	) {
		return false;
	}
	return $toString(value) === '[object Arguments]';
};

/** @type {import('.')} */
var isLegacyArguments = function isArguments(value) {
	if (isStandardArguments(value)) {
		return true;
	}
	return value !== null
		&& typeof value === 'object'
		&& 'length' in value
		&& typeof value.length === 'number'
		&& value.length >= 0
		&& $toString(value) !== '[object Array]'
		&& 'callee' in value
		&& $toString(value.callee) === '[object Function]';
};

var supportsStandardArguments = (function () {
	return isStandardArguments(arguments);
}());

// @ts-expect-error TODO make this not error
isStandardArguments.isLegacyArguments = isLegacyArguments; // for tests

/** @type {import('.')} */
module.exports = supportsStandardArguments ? isStandardArguments : isLegacyArguments;


/***/ }),
/* 7 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var hasSymbols = __webpack_require__(8);

/** @type {import('.')} */
module.exports = function hasToStringTagShams() {
	return hasSymbols() && !!Symbol.toStringTag;
};


/***/ }),
/* 8 */
/***/ ((module) => {

"use strict";


/** @type {import('./shams')} */
/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	/** @type {{ [k in symbol]?: unknown }} */
	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (var _ in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		// eslint-disable-next-line no-extra-parens
		var descriptor = /** @type {PropertyDescriptor} */ (Object.getOwnPropertyDescriptor(obj, sym));
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),
/* 9 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);

var callBindBasic = __webpack_require__(35);

/** @type {(thisArg: string, searchString: string, position?: number) => number} */
var $indexOf = callBindBasic([GetIntrinsic('%String.prototype.indexOf%')]);

/** @type {import('.')} */
module.exports = function callBoundIntrinsic(name, allowMissing) {
	// eslint-disable-next-line no-extra-parens
	var intrinsic = /** @type {Parameters<typeof callBindBasic>[0][0]} */ (GetIntrinsic(name, !!allowMissing));
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBindBasic([intrinsic]);
	}
	return intrinsic;
};


/***/ }),
/* 10 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var undefined;

var $Object = __webpack_require__(11);

var $Error = __webpack_require__(12);
var $EvalError = __webpack_require__(13);
var $RangeError = __webpack_require__(14);
var $ReferenceError = __webpack_require__(15);
var $SyntaxError = __webpack_require__(16);
var $TypeError = __webpack_require__(17);
var $URIError = __webpack_require__(18);

var abs = __webpack_require__(19);
var floor = __webpack_require__(20);
var max = __webpack_require__(21);
var min = __webpack_require__(22);
var pow = __webpack_require__(23);
var round = __webpack_require__(24);
var sign = __webpack_require__(25);

var $Function = Function;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = __webpack_require__(27);
var $defineProperty = __webpack_require__(29);

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(30)();

var getProto = __webpack_require__(31);
var $ObjectGPO = __webpack_require__(33);
var $ReflectGPO = __webpack_require__(32);

var $apply = __webpack_require__(40);
var $call = __webpack_require__(38);

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' || !getProto ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	__proto__: null,
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols && getProto ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': $Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': $EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols && getProto ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': $Object,
	'%Object.getOwnPropertyDescriptor%': $gOPD,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': $RangeError,
	'%ReferenceError%': $ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols || !getProto ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols && getProto ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': $URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet,

	'%Function.prototype.call%': $call,
	'%Function.prototype.apply%': $apply,
	'%Object.defineProperty%': $defineProperty,
	'%Object.getPrototypeOf%': $ObjectGPO,
	'%Math.abs%': abs,
	'%Math.floor%': floor,
	'%Math.max%': max,
	'%Math.min%': min,
	'%Math.pow%': pow,
	'%Math.round%': round,
	'%Math.sign%': sign,
	'%Reflect.getPrototypeOf%': $ReflectGPO
};

if (getProto) {
	try {
		null.error; // eslint-disable-line no-unused-expressions
	} catch (e) {
		// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
		var errorProto = getProto(getProto(e));
		INTRINSICS['%Error.prototype%'] = errorProto;
	}
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen && getProto) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	__proto__: null,
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(36);
var hasOwn = __webpack_require__(42);
var $concat = bind.call($call, Array.prototype.concat);
var $spliceApply = bind.call($apply, Array.prototype.splice);
var $replace = bind.call($call, String.prototype.replace);
var $strSlice = bind.call($call, String.prototype.slice);
var $exec = bind.call($call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),
/* 11 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = Object;


/***/ }),
/* 12 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = Error;


/***/ }),
/* 13 */
/***/ ((module) => {

"use strict";


/** @type {import('./eval')} */
module.exports = EvalError;


/***/ }),
/* 14 */
/***/ ((module) => {

"use strict";


/** @type {import('./range')} */
module.exports = RangeError;


/***/ }),
/* 15 */
/***/ ((module) => {

"use strict";


/** @type {import('./ref')} */
module.exports = ReferenceError;


/***/ }),
/* 16 */
/***/ ((module) => {

"use strict";


/** @type {import('./syntax')} */
module.exports = SyntaxError;


/***/ }),
/* 17 */
/***/ ((module) => {

"use strict";


/** @type {import('./type')} */
module.exports = TypeError;


/***/ }),
/* 18 */
/***/ ((module) => {

"use strict";


/** @type {import('./uri')} */
module.exports = URIError;


/***/ }),
/* 19 */
/***/ ((module) => {

"use strict";


/** @type {import('./abs')} */
module.exports = Math.abs;


/***/ }),
/* 20 */
/***/ ((module) => {

"use strict";


/** @type {import('./floor')} */
module.exports = Math.floor;


/***/ }),
/* 21 */
/***/ ((module) => {

"use strict";


/** @type {import('./max')} */
module.exports = Math.max;


/***/ }),
/* 22 */
/***/ ((module) => {

"use strict";


/** @type {import('./min')} */
module.exports = Math.min;


/***/ }),
/* 23 */
/***/ ((module) => {

"use strict";


/** @type {import('./pow')} */
module.exports = Math.pow;


/***/ }),
/* 24 */
/***/ ((module) => {

"use strict";


/** @type {import('./round')} */
module.exports = Math.round;


/***/ }),
/* 25 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $isNaN = __webpack_require__(26);

/** @type {import('./sign')} */
module.exports = function sign(number) {
	if ($isNaN(number) || number === 0) {
		return number;
	}
	return number < 0 ? -1 : +1;
};


/***/ }),
/* 26 */
/***/ ((module) => {

"use strict";


/** @type {import('./isNaN')} */
module.exports = Number.isNaN || function isNaN(a) {
	return a !== a;
};


/***/ }),
/* 27 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


/** @type {import('.')} */
var $gOPD = __webpack_require__(28);

if ($gOPD) {
	try {
		$gOPD([], 'length');
	} catch (e) {
		// IE 8 has a broken gOPD
		$gOPD = null;
	}
}

module.exports = $gOPD;


/***/ }),
/* 28 */
/***/ ((module) => {

"use strict";


/** @type {import('./gOPD')} */
module.exports = Object.getOwnPropertyDescriptor;


/***/ }),
/* 29 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
var $defineProperty = Object.defineProperty || false;
if ($defineProperty) {
	try {
		$defineProperty({}, 'a', { value: 1 });
	} catch (e) {
		// IE 8 has a broken defineProperty
		$defineProperty = false;
	}
}

module.exports = $defineProperty;


/***/ }),
/* 30 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(8);

/** @type {import('.')} */
module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),
/* 31 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var reflectGetProto = __webpack_require__(32);
var originalGetProto = __webpack_require__(33);

var getDunderProto = __webpack_require__(34);

/** @type {import('.')} */
module.exports = reflectGetProto
	? function getProto(O) {
		// @ts-expect-error TS can't narrow inside a closure, for some reason
		return reflectGetProto(O);
	}
	: originalGetProto
		? function getProto(O) {
			if (!O || (typeof O !== 'object' && typeof O !== 'function')) {
				throw new TypeError('getProto: not an object');
			}
			// @ts-expect-error TS can't narrow inside a closure, for some reason
			return originalGetProto(O);
		}
		: getDunderProto
			? function getProto(O) {
				// @ts-expect-error TS can't narrow inside a closure, for some reason
				return getDunderProto(O);
			}
			: null;


/***/ }),
/* 32 */
/***/ ((module) => {

"use strict";


/** @type {import('./Reflect.getPrototypeOf')} */
module.exports = (typeof Reflect !== 'undefined' && Reflect.getPrototypeOf) || null;


/***/ }),
/* 33 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $Object = __webpack_require__(11);

/** @type {import('./Object.getPrototypeOf')} */
module.exports = $Object.getPrototypeOf || null;


/***/ }),
/* 34 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBind = __webpack_require__(35);
var gOPD = __webpack_require__(27);

var hasProtoAccessor;
try {
	// eslint-disable-next-line no-extra-parens, no-proto
	hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */ ([]).__proto__ === Array.prototype;
} catch (e) {
	if (!e || typeof e !== 'object' || !('code' in e) || e.code !== 'ERR_PROTO_ACCESS') {
		throw e;
	}
}

// eslint-disable-next-line no-extra-parens
var desc = !!hasProtoAccessor && gOPD && gOPD(Object.prototype, /** @type {keyof typeof Object.prototype} */ ('__proto__'));

var $Object = Object;
var $getPrototypeOf = $Object.getPrototypeOf;

/** @type {import('./get')} */
module.exports = desc && typeof desc.get === 'function'
	? callBind([desc.get])
	: typeof $getPrototypeOf === 'function'
		? /** @type {import('./get')} */ function getDunder(value) {
			// eslint-disable-next-line eqeqeq
			return $getPrototypeOf(value == null ? value : $Object(value));
		}
		: false;


/***/ }),
/* 35 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);
var $TypeError = __webpack_require__(17);

var $call = __webpack_require__(38);
var $actualApply = __webpack_require__(39);

/** @type {(args: [Function, thisArg?: unknown, ...args: unknown[]]) => Function} TODO FIXME, find a way to use import('.') */
module.exports = function callBindBasic(args) {
	if (args.length < 1 || typeof args[0] !== 'function') {
		throw new $TypeError('a function is required');
	}
	return $actualApply(bind, $call, args);
};


/***/ }),
/* 36 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(37);

module.exports = Function.prototype.bind || implementation;


/***/ }),
/* 37 */
/***/ ((module) => {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var toStr = Object.prototype.toString;
var max = Math.max;
var funcType = '[object Function]';

var concatty = function concatty(a, b) {
    var arr = [];

    for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
    }
    for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
    }

    return arr;
};

var slicy = function slicy(arrLike, offset) {
    var arr = [];
    for (var i = offset || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
    }
    return arr;
};

var joiny = function (arr, joiner) {
    var str = '';
    for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
            str += joiner;
        }
    }
    return str;
};

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                concatty(args, arguments)
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        }
        return target.apply(
            that,
            concatty(args, arguments)
        );

    };

    var boundLength = max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = '$' + i;
    }

    bound = Function('binder', 'return function (' + joiny(boundArgs, ',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),
/* 38 */
/***/ ((module) => {

"use strict";


/** @type {import('./functionCall')} */
module.exports = Function.prototype.call;


/***/ }),
/* 39 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);

var $apply = __webpack_require__(40);
var $call = __webpack_require__(38);
var $reflectApply = __webpack_require__(41);

/** @type {import('./actualApply')} */
module.exports = $reflectApply || bind.call($call, $apply);


/***/ }),
/* 40 */
/***/ ((module) => {

"use strict";


/** @type {import('./functionApply')} */
module.exports = Function.prototype.apply;


/***/ }),
/* 41 */
/***/ ((module) => {

"use strict";


/** @type {import('./reflectApply')} */
module.exports = typeof Reflect !== 'undefined' && Reflect && Reflect.apply;


/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var call = Function.prototype.call;
var $hasOwn = Object.prototype.hasOwnProperty;
var bind = __webpack_require__(36);

/** @type {import('.')} */
module.exports = bind.call(call, $hasOwn);


/***/ }),
/* 43 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var safeRegexTest = __webpack_require__(44);
var isFnRegex = safeRegexTest(/^\s*(?:function)?\*/);
var hasToStringTag = __webpack_require__(7)();
var getProto = __webpack_require__(31);

var toStr = callBound('Object.prototype.toString');
var fnToStr = callBound('Function.prototype.toString');

var getGeneratorFunc = function () { // eslint-disable-line consistent-return
	if (!hasToStringTag) {
		return false;
	}
	try {
		return Function('return function*() {}')();
	} catch (e) {
	}
};
/** @type {undefined | false | null | GeneratorFunctionConstructor} */
var GeneratorFunction;

/** @type {import('.')} */
module.exports = function isGeneratorFunction(fn) {
	if (typeof fn !== 'function') {
		return false;
	}
	if (isFnRegex(fnToStr(fn))) {
		return true;
	}
	if (!hasToStringTag) {
		var str = toStr(fn);
		return str === '[object GeneratorFunction]';
	}
	if (!getProto) {
		return false;
	}
	if (typeof GeneratorFunction === 'undefined') {
		var generatorFunc = getGeneratorFunc();
		GeneratorFunction = generatorFunc
			// eslint-disable-next-line no-extra-parens
			? /** @type {GeneratorFunctionConstructor} */ (getProto(generatorFunc))
			: false;
	}
	return getProto(fn) === GeneratorFunction;
};


/***/ }),
/* 44 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var isRegex = __webpack_require__(45);

var $exec = callBound('RegExp.prototype.exec');
var $TypeError = __webpack_require__(17);

/** @type {import('.')} */
module.exports = function regexTester(regex) {
	if (!isRegex(regex)) {
		throw new $TypeError('`regex` must be a RegExp');
	}
	return function test(s) {
		return $exec(regex, s) !== null;
	};
};


/***/ }),
/* 45 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBound = __webpack_require__(9);
var hasToStringTag = __webpack_require__(7)();
var hasOwn = __webpack_require__(42);
var gOPD = __webpack_require__(27);

/** @type {import('.')} */
var fn;

if (hasToStringTag) {
	/** @type {(receiver: ThisParameterType<typeof RegExp.prototype.exec>, ...args: Parameters<typeof RegExp.prototype.exec>) => ReturnType<typeof RegExp.prototype.exec>} */
	var $exec = callBound('RegExp.prototype.exec');
	/** @type {object} */
	var isRegexMarker = {};

	var throwRegexMarker = function () {
		throw isRegexMarker;
	};
	/** @type {{ toString(): never, valueOf(): never, [Symbol.toPrimitive]?(): never }} */
	var badStringifier = {
		toString: throwRegexMarker,
		valueOf: throwRegexMarker
	};

	if (typeof Symbol.toPrimitive === 'symbol') {
		badStringifier[Symbol.toPrimitive] = throwRegexMarker;
	}

	/** @type {import('.')} */
	// @ts-expect-error TS can't figure out that the $exec call always throws
	// eslint-disable-next-line consistent-return
	fn = function isRegex(value) {
		if (!value || typeof value !== 'object') {
			return false;
		}

		// eslint-disable-next-line no-extra-parens
		var descriptor = /** @type {NonNullable<typeof gOPD>} */ (gOPD)(/** @type {{ lastIndex?: unknown }} */ (value), 'lastIndex');
		var hasLastIndexDataProperty = descriptor && hasOwn(descriptor, 'value');
		if (!hasLastIndexDataProperty) {
			return false;
		}

		try {
			// eslint-disable-next-line no-extra-parens
			$exec(value, /** @type {string} */ (/** @type {unknown} */ (badStringifier)));
		} catch (e) {
			return e === isRegexMarker;
		}
	};
} else {
	/** @type {(receiver: ThisParameterType<typeof Object.prototype.toString>, ...args: Parameters<typeof Object.prototype.toString>) => ReturnType<typeof Object.prototype.toString>} */
	var $toString = callBound('Object.prototype.toString');
	/** @const @type {'[object RegExp]'} */
	var regexClass = '[object RegExp]';

	/** @type {import('.')} */
	fn = function isRegex(value) {
		// In older browsers, typeof regex incorrectly returns 'function'
		if (!value || (typeof value !== 'object' && typeof value !== 'function')) {
			return false;
		}

		return $toString(value) === regexClass;
	};
}

module.exports = fn;


/***/ }),
/* 46 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var forEach = __webpack_require__(47);
var availableTypedArrays = __webpack_require__(49);
var callBind = __webpack_require__(51);
var callBound = __webpack_require__(9);
var gOPD = __webpack_require__(27);

/** @type {(O: object) => string} */
var $toString = callBound('Object.prototype.toString');
var hasToStringTag = __webpack_require__(7)();

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;
var typedArrays = availableTypedArrays();

var $slice = callBound('String.prototype.slice');
var getPrototypeOf = Object.getPrototypeOf; // require('getprototypeof');

/** @type {<T = unknown>(array: readonly T[], value: unknown) => number} */
var $indexOf = callBound('Array.prototype.indexOf', true) || function indexOf(array, value) {
	for (var i = 0; i < array.length; i += 1) {
		if (array[i] === value) {
			return i;
		}
	}
	return -1;
};

/** @typedef {(receiver: import('.').TypedArray) => string | typeof Uint8Array.prototype.slice.call | typeof Uint8Array.prototype.set.call} Getter */
/** @type {{ [k in `\$${import('.').TypedArrayName}`]?: Getter } & { __proto__: null }} */
var cache = { __proto__: null };
if (hasToStringTag && gOPD && getPrototypeOf) {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		if (Symbol.toStringTag in arr) {
			var proto = getPrototypeOf(arr);
			// @ts-expect-error TS won't narrow inside a closure
			var descriptor = gOPD(proto, Symbol.toStringTag);
			if (!descriptor) {
				var superProto = getPrototypeOf(proto);
				// @ts-expect-error TS won't narrow inside a closure
				descriptor = gOPD(superProto, Symbol.toStringTag);
			}
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(descriptor.get);
		}
	});
} else {
	forEach(typedArrays, function (typedArray) {
		var arr = new g[typedArray]();
		var fn = arr.slice || arr.set;
		if (fn) {
			// @ts-expect-error TODO: fix
			cache['$' + typedArray] = callBind(fn);
		}
	});
}

/** @type {(value: object) => false | import('.').TypedArrayName} */
var tryTypedArrays = function tryAllTypedArrays(value) {
	/** @type {ReturnType<typeof tryAllTypedArrays>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
		function (getter, typedArray) {
			if (!found) {
				try {
				// @ts-expect-error TODO: fix
					if ('$' + getter(value) === typedArray) {
						found = $slice(typedArray, 1);
					}
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {(value: object) => false | import('.').TypedArrayName} */
var trySlices = function tryAllSlices(value) {
	/** @type {ReturnType<typeof tryAllSlices>} */ var found = false;
	forEach(
		// eslint-disable-next-line no-extra-parens
		/** @type {Record<`\$${TypedArrayName}`, Getter>} */ /** @type {any} */ (cache),
		/** @type {(getter: typeof cache, name: `\$${import('.').TypedArrayName}`) => void} */ function (getter, name) {
			if (!found) {
				try {
					// @ts-expect-error TODO: fix
					getter(value);
					found = $slice(name, 1);
				} catch (e) { /**/ }
			}
		}
	);
	return found;
};

/** @type {import('.')} */
module.exports = function whichTypedArray(value) {
	if (!value || typeof value !== 'object') { return false; }
	if (!hasToStringTag) {
		/** @type {string} */
		var tag = $slice($toString(value), 8, -1);
		if ($indexOf(typedArrays, tag) > -1) {
			return tag;
		}
		if (tag !== 'Object') {
			return false;
		}
		// node < 0.6 hits here on real Typed Arrays
		return trySlices(value);
	}
	if (!gOPD) { return null; } // unknown engine
	return tryTypedArrays(value);
};


/***/ }),
/* 47 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isCallable = __webpack_require__(48);

var toStr = Object.prototype.toString;
var hasOwnProperty = Object.prototype.hasOwnProperty;

/** @type {<This, A extends readonly unknown[]>(arr: A, iterator: (this: This | void, value: A[number], index: number, arr: A) => void, receiver: This | undefined) => void} */
var forEachArray = function forEachArray(array, iterator, receiver) {
    for (var i = 0, len = array.length; i < len; i++) {
        if (hasOwnProperty.call(array, i)) {
            if (receiver == null) {
                iterator(array[i], i, array);
            } else {
                iterator.call(receiver, array[i], i, array);
            }
        }
    }
};

/** @type {<This, S extends string>(string: S, iterator: (this: This | void, value: S[number], index: number, string: S) => void, receiver: This | undefined) => void} */
var forEachString = function forEachString(string, iterator, receiver) {
    for (var i = 0, len = string.length; i < len; i++) {
        // no such thing as a sparse string.
        if (receiver == null) {
            iterator(string.charAt(i), i, string);
        } else {
            iterator.call(receiver, string.charAt(i), i, string);
        }
    }
};

/** @type {<This, O>(obj: O, iterator: (this: This | void, value: O[keyof O], index: keyof O, obj: O) => void, receiver: This | undefined) => void} */
var forEachObject = function forEachObject(object, iterator, receiver) {
    for (var k in object) {
        if (hasOwnProperty.call(object, k)) {
            if (receiver == null) {
                iterator(object[k], k, object);
            } else {
                iterator.call(receiver, object[k], k, object);
            }
        }
    }
};

/** @type {(x: unknown) => x is readonly unknown[]} */
function isArray(x) {
    return toStr.call(x) === '[object Array]';
}

/** @type {import('.')._internal} */
module.exports = function forEach(list, iterator, thisArg) {
    if (!isCallable(iterator)) {
        throw new TypeError('iterator must be a function');
    }

    var receiver;
    if (arguments.length >= 3) {
        receiver = thisArg;
    }

    if (isArray(list)) {
        forEachArray(list, iterator, receiver);
    } else if (typeof list === 'string') {
        forEachString(list, iterator, receiver);
    } else {
        forEachObject(list, iterator, receiver);
    }
};


/***/ }),
/* 48 */
/***/ ((module) => {

"use strict";


var fnToStr = Function.prototype.toString;
var reflectApply = typeof Reflect === 'object' && Reflect !== null && Reflect.apply;
var badArrayLike;
var isCallableMarker;
if (typeof reflectApply === 'function' && typeof Object.defineProperty === 'function') {
	try {
		badArrayLike = Object.defineProperty({}, 'length', {
			get: function () {
				throw isCallableMarker;
			}
		});
		isCallableMarker = {};
		// eslint-disable-next-line no-throw-literal
		reflectApply(function () { throw 42; }, null, badArrayLike);
	} catch (_) {
		if (_ !== isCallableMarker) {
			reflectApply = null;
		}
	}
} else {
	reflectApply = null;
}

var constructorRegex = /^\s*class\b/;
var isES6ClassFn = function isES6ClassFunction(value) {
	try {
		var fnStr = fnToStr.call(value);
		return constructorRegex.test(fnStr);
	} catch (e) {
		return false; // not a function
	}
};

var tryFunctionObject = function tryFunctionToStr(value) {
	try {
		if (isES6ClassFn(value)) { return false; }
		fnToStr.call(value);
		return true;
	} catch (e) {
		return false;
	}
};
var toStr = Object.prototype.toString;
var objectClass = '[object Object]';
var fnClass = '[object Function]';
var genClass = '[object GeneratorFunction]';
var ddaClass = '[object HTMLAllCollection]'; // IE 11
var ddaClass2 = '[object HTML document.all class]';
var ddaClass3 = '[object HTMLCollection]'; // IE 9-10
var hasToStringTag = typeof Symbol === 'function' && !!Symbol.toStringTag; // better: use `has-tostringtag`

var isIE68 = !(0 in [,]); // eslint-disable-line no-sparse-arrays, comma-spacing

var isDDA = function isDocumentDotAll() { return false; };
if (typeof document === 'object') {
	// Firefox 3 canonicalizes DDA to undefined when it's not accessed directly
	var all = document.all;
	if (toStr.call(all) === toStr.call(document.all)) {
		isDDA = function isDocumentDotAll(value) {
			/* globals document: false */
			// in IE 6-8, typeof document.all is "object" and it's truthy
			if ((isIE68 || !value) && (typeof value === 'undefined' || typeof value === 'object')) {
				try {
					var str = toStr.call(value);
					return (
						str === ddaClass
						|| str === ddaClass2
						|| str === ddaClass3 // opera 12.16
						|| str === objectClass // IE 6-8
					) && value('') == null; // eslint-disable-line eqeqeq
				} catch (e) { /**/ }
			}
			return false;
		};
	}
}

module.exports = reflectApply
	? function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		try {
			reflectApply(value, null, badArrayLike);
		} catch (e) {
			if (e !== isCallableMarker) { return false; }
		}
		return !isES6ClassFn(value) && tryFunctionObject(value);
	}
	: function isCallable(value) {
		if (isDDA(value)) { return true; }
		if (!value) { return false; }
		if (typeof value !== 'function' && typeof value !== 'object') { return false; }
		if (hasToStringTag) { return tryFunctionObject(value); }
		if (isES6ClassFn(value)) { return false; }
		var strClass = toStr.call(value);
		if (strClass !== fnClass && strClass !== genClass && !(/^\[object HTML/).test(strClass)) { return false; }
		return tryFunctionObject(value);
	};


/***/ }),
/* 49 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var possibleNames = __webpack_require__(50);

var g = typeof globalThis === 'undefined' ? __webpack_require__.g : globalThis;

/** @type {import('.')} */
module.exports = function availableTypedArrays() {
	var /** @type {ReturnType<typeof availableTypedArrays>} */ out = [];
	for (var i = 0; i < possibleNames.length; i++) {
		if (typeof g[possibleNames[i]] === 'function') {
			// @ts-expect-error
			out[out.length] = possibleNames[i];
		}
	}
	return out;
};


/***/ }),
/* 50 */
/***/ ((module) => {

"use strict";


/** @type {import('.')} */
module.exports = [
	'Float16Array',
	'Float32Array',
	'Float64Array',
	'Int8Array',
	'Int16Array',
	'Int32Array',
	'Uint8Array',
	'Uint8ClampedArray',
	'Uint16Array',
	'Uint32Array',
	'BigInt64Array',
	'BigUint64Array'
];


/***/ }),
/* 51 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var setFunctionLength = __webpack_require__(52);

var $defineProperty = __webpack_require__(29);

var callBindBasic = __webpack_require__(35);
var applyBind = __webpack_require__(55);

module.exports = function callBind(originalFunction) {
	var func = callBindBasic(arguments);
	var adjustedLength = originalFunction.length - (arguments.length - 1);
	return setFunctionLength(
		func,
		1 + (adjustedLength > 0 ? adjustedLength : 0),
		true
	);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),
/* 52 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);
var define = __webpack_require__(53);
var hasDescriptors = __webpack_require__(54)();
var gOPD = __webpack_require__(27);

var $TypeError = __webpack_require__(17);
var $floor = GetIntrinsic('%Math.floor%');

/** @type {import('.')} */
module.exports = function setFunctionLength(fn, length) {
	if (typeof fn !== 'function') {
		throw new $TypeError('`fn` is not a function');
	}
	if (typeof length !== 'number' || length < 0 || length > 0xFFFFFFFF || $floor(length) !== length) {
		throw new $TypeError('`length` must be a positive 32-bit integer');
	}

	var loose = arguments.length > 2 && !!arguments[2];

	var functionLengthIsConfigurable = true;
	var functionLengthIsWritable = true;
	if ('length' in fn && gOPD) {
		var desc = gOPD(fn, 'length');
		if (desc && !desc.configurable) {
			functionLengthIsConfigurable = false;
		}
		if (desc && !desc.writable) {
			functionLengthIsWritable = false;
		}
	}

	if (functionLengthIsConfigurable || functionLengthIsWritable || !loose) {
		if (hasDescriptors) {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length, true, true);
		} else {
			define(/** @type {Parameters<define>[0]} */ (fn), 'length', length);
		}
	}
	return fn;
};


/***/ }),
/* 53 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $defineProperty = __webpack_require__(29);

var $SyntaxError = __webpack_require__(16);
var $TypeError = __webpack_require__(17);

var gopd = __webpack_require__(27);

/** @type {import('.')} */
module.exports = function defineDataProperty(
	obj,
	property,
	value
) {
	if (!obj || (typeof obj !== 'object' && typeof obj !== 'function')) {
		throw new $TypeError('`obj` must be an object or a function`');
	}
	if (typeof property !== 'string' && typeof property !== 'symbol') {
		throw new $TypeError('`property` must be a string or a symbol`');
	}
	if (arguments.length > 3 && typeof arguments[3] !== 'boolean' && arguments[3] !== null) {
		throw new $TypeError('`nonEnumerable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 4 && typeof arguments[4] !== 'boolean' && arguments[4] !== null) {
		throw new $TypeError('`nonWritable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 5 && typeof arguments[5] !== 'boolean' && arguments[5] !== null) {
		throw new $TypeError('`nonConfigurable`, if provided, must be a boolean or null');
	}
	if (arguments.length > 6 && typeof arguments[6] !== 'boolean') {
		throw new $TypeError('`loose`, if provided, must be a boolean');
	}

	var nonEnumerable = arguments.length > 3 ? arguments[3] : null;
	var nonWritable = arguments.length > 4 ? arguments[4] : null;
	var nonConfigurable = arguments.length > 5 ? arguments[5] : null;
	var loose = arguments.length > 6 ? arguments[6] : false;

	/* @type {false | TypedPropertyDescriptor<unknown>} */
	var desc = !!gopd && gopd(obj, property);

	if ($defineProperty) {
		$defineProperty(obj, property, {
			configurable: nonConfigurable === null && desc ? desc.configurable : !nonConfigurable,
			enumerable: nonEnumerable === null && desc ? desc.enumerable : !nonEnumerable,
			value: value,
			writable: nonWritable === null && desc ? desc.writable : !nonWritable
		});
	} else if (loose || (!nonEnumerable && !nonWritable && !nonConfigurable)) {
		// must fall back to [[Set]], and was not explicitly asked to make non-enumerable, non-writable, or non-configurable
		obj[property] = value; // eslint-disable-line no-param-reassign
	} else {
		throw new $SyntaxError('This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.');
	}
};


/***/ }),
/* 54 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $defineProperty = __webpack_require__(29);

var hasPropertyDescriptors = function hasPropertyDescriptors() {
	return !!$defineProperty;
};

hasPropertyDescriptors.hasArrayLengthDefineBug = function hasArrayLengthDefineBug() {
	// node v0.6 has a bug where array lengths can be Set but not Defined
	if (!$defineProperty) {
		return null;
	}
	try {
		return $defineProperty([], 'length', { value: 1 }).length !== 1;
	} catch (e) {
		// In Firefox 4-22, defining length on an array throws an exception.
		return true;
	}
};

module.exports = hasPropertyDescriptors;


/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(36);
var $apply = __webpack_require__(40);
var actualApply = __webpack_require__(39);

/** @type {import('./applyBind')} */
module.exports = function applyBind() {
	return actualApply(bind, $apply, arguments);
};


/***/ }),
/* 56 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var whichTypedArray = __webpack_require__(46);

/** @type {import('.')} */
module.exports = function isTypedArray(value) {
	return !!whichTypedArray(value);
};


/***/ }),
/* 57 */
/***/ ((module) => {

module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}

/***/ }),
/* 58 */
/***/ ((module) => {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),
/* 59 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(4);
/* provided dependency */ var console = __webpack_require__(2);
// Currently in sync with Node.js lib/assert.js
// https://github.com/nodejs/node/commit/2a51ae424a513ec9a6aa3466baa0cc1d55dd4f3b

// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.



function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
var _require = __webpack_require__(60),
  _require$codes = _require.codes,
  ERR_AMBIGUOUS_ARGUMENT = _require$codes.ERR_AMBIGUOUS_ARGUMENT,
  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
  ERR_INVALID_ARG_VALUE = _require$codes.ERR_INVALID_ARG_VALUE,
  ERR_INVALID_RETURN_VALUE = _require$codes.ERR_INVALID_RETURN_VALUE,
  ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS;
var AssertionError = __webpack_require__(61);
var _require2 = __webpack_require__(3),
  inspect = _require2.inspect;
var _require$types = (__webpack_require__(3).types),
  isPromise = _require$types.isPromise,
  isRegExp = _require$types.isRegExp;
var objectAssign = __webpack_require__(62)();
var objectIs = __webpack_require__(67)();
var RegExpPrototypeTest = __webpack_require__(69)('RegExp.prototype.test');
var errorCache = new Map();
var isDeepEqual;
var isDeepStrictEqual;
var parseExpressionAt;
var findNodeAround;
var decoder;
function lazyLoadComparison() {
  var comparison = __webpack_require__(70);
  isDeepEqual = comparison.isDeepEqual;
  isDeepStrictEqual = comparison.isDeepStrictEqual;
}

// Escape control characters but not \n and \t to keep the line breaks and
// indentation intact.
// eslint-disable-next-line no-control-regex
var escapeSequencesRegExp = /[\x00-\x08\x0b\x0c\x0e-\x1f]/g;
var meta = ["\\u0000", "\\u0001", "\\u0002", "\\u0003", "\\u0004", "\\u0005", "\\u0006", "\\u0007", '\\b', '', '', "\\u000b", '\\f', '', "\\u000e", "\\u000f", "\\u0010", "\\u0011", "\\u0012", "\\u0013", "\\u0014", "\\u0015", "\\u0016", "\\u0017", "\\u0018", "\\u0019", "\\u001a", "\\u001b", "\\u001c", "\\u001d", "\\u001e", "\\u001f"];
var escapeFn = function escapeFn(str) {
  return meta[str.charCodeAt(0)];
};
var warned = false;

// The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;
var NO_EXCEPTION_SENTINEL = {};

// All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided. All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function innerFail(obj) {
  if (obj.message instanceof Error) throw obj.message;
  throw new AssertionError(obj);
}
function fail(actual, expected, message, operator, stackStartFn) {
  var argsLen = arguments.length;
  var internalMessage;
  if (argsLen === 0) {
    internalMessage = 'Failed';
  } else if (argsLen === 1) {
    message = actual;
    actual = undefined;
  } else {
    if (warned === false) {
      warned = true;
      var warn = process.emitWarning ? process.emitWarning : console.warn.bind(console);
      warn('assert.fail() with more than one argument is deprecated. ' + 'Please use assert.strictEqual() instead or only pass a message.', 'DeprecationWarning', 'DEP0094');
    }
    if (argsLen === 2) operator = '!=';
  }
  if (message instanceof Error) throw message;
  var errArgs = {
    actual: actual,
    expected: expected,
    operator: operator === undefined ? 'fail' : operator,
    stackStartFn: stackStartFn || fail
  };
  if (message !== undefined) {
    errArgs.message = message;
  }
  var err = new AssertionError(errArgs);
  if (internalMessage) {
    err.message = internalMessage;
    err.generatedMessage = true;
  }
  throw err;
}
assert.fail = fail;

// The AssertionError is defined in internal/error.
assert.AssertionError = AssertionError;
function innerOk(fn, argLen, value, message) {
  if (!value) {
    var generatedMessage = false;
    if (argLen === 0) {
      generatedMessage = true;
      message = 'No value argument passed to `assert.ok()`';
    } else if (message instanceof Error) {
      throw message;
    }
    var err = new AssertionError({
      actual: value,
      expected: true,
      message: message,
      operator: '==',
      stackStartFn: fn
    });
    err.generatedMessage = generatedMessage;
    throw err;
  }
}

// Pure assertion tests whether a value is truthy, as determined
// by !!value.
function ok() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  innerOk.apply(void 0, [ok, args.length].concat(args));
}
assert.ok = ok;

// The equality assertion tests shallow, coercive equality with ==.
/* eslint-disable no-restricted-properties */
assert.equal = function equal(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  // eslint-disable-next-line eqeqeq
  if (actual != expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '==',
      stackStartFn: equal
    });
  }
};

// The non-equality assertion tests for whether two objects are not
// equal with !=.
assert.notEqual = function notEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  // eslint-disable-next-line eqeqeq
  if (actual == expected) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: '!=',
      stackStartFn: notEqual
    });
  }
};

// The equivalence assertion tests a deep equality relation.
assert.deepEqual = function deepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (!isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepEqual',
      stackStartFn: deepEqual
    });
  }
};

// The non-equivalence assertion tests for any deep inequality.
assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (isDeepEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepEqual',
      stackStartFn: notDeepEqual
    });
  }
};
/* eslint-enable */

assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (!isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'deepStrictEqual',
      stackStartFn: deepStrictEqual
    });
  }
};
assert.notDeepStrictEqual = notDeepStrictEqual;
function notDeepStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (isDeepEqual === undefined) lazyLoadComparison();
  if (isDeepStrictEqual(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notDeepStrictEqual',
      stackStartFn: notDeepStrictEqual
    });
  }
}
assert.strictEqual = function strictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (!objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'strictEqual',
      stackStartFn: strictEqual
    });
  }
};
assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (arguments.length < 2) {
    throw new ERR_MISSING_ARGS('actual', 'expected');
  }
  if (objectIs(actual, expected)) {
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: 'notStrictEqual',
      stackStartFn: notStrictEqual
    });
  }
};
var Comparison = /*#__PURE__*/_createClass(function Comparison(obj, keys, actual) {
  var _this = this;
  _classCallCheck(this, Comparison);
  keys.forEach(function (key) {
    if (key in obj) {
      if (actual !== undefined && typeof actual[key] === 'string' && isRegExp(obj[key]) && RegExpPrototypeTest(obj[key], actual[key])) {
        _this[key] = actual[key];
      } else {
        _this[key] = obj[key];
      }
    }
  });
});
function compareExceptionKey(actual, expected, key, message, keys, fn) {
  if (!(key in actual) || !isDeepStrictEqual(actual[key], expected[key])) {
    if (!message) {
      // Create placeholder objects to create a nice output.
      var a = new Comparison(actual, keys);
      var b = new Comparison(expected, keys, actual);
      var err = new AssertionError({
        actual: a,
        expected: b,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.actual = actual;
      err.expected = expected;
      err.operator = fn.name;
      throw err;
    }
    innerFail({
      actual: actual,
      expected: expected,
      message: message,
      operator: fn.name,
      stackStartFn: fn
    });
  }
}
function expectedException(actual, expected, msg, fn) {
  if (typeof expected !== 'function') {
    if (isRegExp(expected)) return RegExpPrototypeTest(expected, actual);
    // assert.doesNotThrow does not accept objects.
    if (arguments.length === 2) {
      throw new ERR_INVALID_ARG_TYPE('expected', ['Function', 'RegExp'], expected);
    }

    // Handle primitives properly.
    if (_typeof(actual) !== 'object' || actual === null) {
      var err = new AssertionError({
        actual: actual,
        expected: expected,
        message: msg,
        operator: 'deepStrictEqual',
        stackStartFn: fn
      });
      err.operator = fn.name;
      throw err;
    }
    var keys = Object.keys(expected);
    // Special handle errors to make sure the name and the message are compared
    // as well.
    if (expected instanceof Error) {
      keys.push('name', 'message');
    } else if (keys.length === 0) {
      throw new ERR_INVALID_ARG_VALUE('error', expected, 'may not be an empty object');
    }
    if (isDeepEqual === undefined) lazyLoadComparison();
    keys.forEach(function (key) {
      if (typeof actual[key] === 'string' && isRegExp(expected[key]) && RegExpPrototypeTest(expected[key], actual[key])) {
        return;
      }
      compareExceptionKey(actual, expected, key, msg, keys, fn);
    });
    return true;
  }
  // Guard instanceof against arrow functions as they don't have a prototype.
  if (expected.prototype !== undefined && actual instanceof expected) {
    return true;
  }
  if (Error.isPrototypeOf(expected)) {
    return false;
  }
  return expected.call({}, actual) === true;
}
function getActual(fn) {
  if (typeof fn !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('fn', 'Function', fn);
  }
  try {
    fn();
  } catch (e) {
    return e;
  }
  return NO_EXCEPTION_SENTINEL;
}
function checkIsPromise(obj) {
  // Accept native ES6 promises and promises that are implemented in a similar
  // way. Do not accept thenables that use a function as `obj` and that have no
  // `catch` handler.

  // TODO: thenables are checked up until they have the correct methods,
  // but according to documentation, the `then` method should receive
  // the `fulfill` and `reject` arguments as well or it may be never resolved.

  return isPromise(obj) || obj !== null && _typeof(obj) === 'object' && typeof obj.then === 'function' && typeof obj.catch === 'function';
}
function waitForActual(promiseFn) {
  return Promise.resolve().then(function () {
    var resultPromise;
    if (typeof promiseFn === 'function') {
      // Return a rejected promise if `promiseFn` throws synchronously.
      resultPromise = promiseFn();
      // Fail in case no promise is returned.
      if (!checkIsPromise(resultPromise)) {
        throw new ERR_INVALID_RETURN_VALUE('instance of Promise', 'promiseFn', resultPromise);
      }
    } else if (checkIsPromise(promiseFn)) {
      resultPromise = promiseFn;
    } else {
      throw new ERR_INVALID_ARG_TYPE('promiseFn', ['Function', 'Promise'], promiseFn);
    }
    return Promise.resolve().then(function () {
      return resultPromise;
    }).then(function () {
      return NO_EXCEPTION_SENTINEL;
    }).catch(function (e) {
      return e;
    });
  });
}
function expectsError(stackStartFn, actual, error, message) {
  if (typeof error === 'string') {
    if (arguments.length === 4) {
      throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
    }
    if (_typeof(actual) === 'object' && actual !== null) {
      if (actual.message === error) {
        throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error message \"".concat(actual.message, "\" is identical to the message."));
      }
    } else if (actual === error) {
      throw new ERR_AMBIGUOUS_ARGUMENT('error/message', "The error \"".concat(actual, "\" is identical to the message."));
    }
    message = error;
    error = undefined;
  } else if (error != null && _typeof(error) !== 'object' && typeof error !== 'function') {
    throw new ERR_INVALID_ARG_TYPE('error', ['Object', 'Error', 'Function', 'RegExp'], error);
  }
  if (actual === NO_EXCEPTION_SENTINEL) {
    var details = '';
    if (error && error.name) {
      details += " (".concat(error.name, ")");
    }
    details += message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'rejects' ? 'rejection' : 'exception';
    innerFail({
      actual: undefined,
      expected: error,
      operator: stackStartFn.name,
      message: "Missing expected ".concat(fnType).concat(details),
      stackStartFn: stackStartFn
    });
  }
  if (error && !expectedException(actual, error, message, stackStartFn)) {
    throw actual;
  }
}
function expectsNoError(stackStartFn, actual, error, message) {
  if (actual === NO_EXCEPTION_SENTINEL) return;
  if (typeof error === 'string') {
    message = error;
    error = undefined;
  }
  if (!error || expectedException(actual, error)) {
    var details = message ? ": ".concat(message) : '.';
    var fnType = stackStartFn.name === 'doesNotReject' ? 'rejection' : 'exception';
    innerFail({
      actual: actual,
      expected: error,
      operator: stackStartFn.name,
      message: "Got unwanted ".concat(fnType).concat(details, "\n") + "Actual message: \"".concat(actual && actual.message, "\""),
      stackStartFn: stackStartFn
    });
  }
  throw actual;
}
assert.throws = function throws(promiseFn) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    args[_key2 - 1] = arguments[_key2];
  }
  expectsError.apply(void 0, [throws, getActual(promiseFn)].concat(args));
};
assert.rejects = function rejects(promiseFn) {
  for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
    args[_key3 - 1] = arguments[_key3];
  }
  return waitForActual(promiseFn).then(function (result) {
    return expectsError.apply(void 0, [rejects, result].concat(args));
  });
};
assert.doesNotThrow = function doesNotThrow(fn) {
  for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }
  expectsNoError.apply(void 0, [doesNotThrow, getActual(fn)].concat(args));
};
assert.doesNotReject = function doesNotReject(fn) {
  for (var _len5 = arguments.length, args = new Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
    args[_key5 - 1] = arguments[_key5];
  }
  return waitForActual(fn).then(function (result) {
    return expectsNoError.apply(void 0, [doesNotReject, result].concat(args));
  });
};
assert.ifError = function ifError(err) {
  if (err !== null && err !== undefined) {
    var message = 'ifError got unwanted exception: ';
    if (_typeof(err) === 'object' && typeof err.message === 'string') {
      if (err.message.length === 0 && err.constructor) {
        message += err.constructor.name;
      } else {
        message += err.message;
      }
    } else {
      message += inspect(err);
    }
    var newErr = new AssertionError({
      actual: err,
      expected: null,
      operator: 'ifError',
      message: message,
      stackStartFn: ifError
    });

    // Make sure we actually have a stack trace!
    var origStack = err.stack;
    if (typeof origStack === 'string') {
      // This will remove any duplicated frames from the error frames taken
      // from within `ifError` and add the original error frames to the newly
      // created ones.
      var tmp2 = origStack.split('\n');
      tmp2.shift();
      // Filter all frames existing in err.stack.
      var tmp1 = newErr.stack.split('\n');
      for (var i = 0; i < tmp2.length; i++) {
        // Find the first occurrence of the frame.
        var pos = tmp1.indexOf(tmp2[i]);
        if (pos !== -1) {
          // Only keep new frames.
          tmp1 = tmp1.slice(0, pos);
          break;
        }
      }
      newErr.stack = "".concat(tmp1.join('\n'), "\n").concat(tmp2.join('\n'));
    }
    throw newErr;
  }
};

// Currently in sync with Node.js lib/assert.js
// https://github.com/nodejs/node/commit/2a871df3dfb8ea663ef5e1f8f62701ec51384ecb
function internalMatch(string, regexp, message, fn, fnName) {
  if (!isRegExp(regexp)) {
    throw new ERR_INVALID_ARG_TYPE('regexp', 'RegExp', regexp);
  }
  var match = fnName === 'match';
  if (typeof string !== 'string' || RegExpPrototypeTest(regexp, string) !== match) {
    if (message instanceof Error) {
      throw message;
    }
    var generatedMessage = !message;

    // 'The input was expected to not match the regular expression ' +
    message = message || (typeof string !== 'string' ? 'The "string" argument must be of type string. Received type ' + "".concat(_typeof(string), " (").concat(inspect(string), ")") : (match ? 'The input did not match the regular expression ' : 'The input was expected to not match the regular expression ') + "".concat(inspect(regexp), ". Input:\n\n").concat(inspect(string), "\n"));
    var err = new AssertionError({
      actual: string,
      expected: regexp,
      message: message,
      operator: fnName,
      stackStartFn: fn
    });
    err.generatedMessage = generatedMessage;
    throw err;
  }
}
assert.match = function match(string, regexp, message) {
  internalMatch(string, regexp, message, match, 'match');
};
assert.doesNotMatch = function doesNotMatch(string, regexp, message) {
  internalMatch(string, regexp, message, doesNotMatch, 'doesNotMatch');
};

// Expose a strict only variant of assert
function strict() {
  for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
    args[_key6] = arguments[_key6];
  }
  innerOk.apply(void 0, [strict, args.length].concat(args));
}
assert.strict = objectAssign(strict, assert, {
  equal: assert.strictEqual,
  deepEqual: assert.deepStrictEqual,
  notEqual: assert.notStrictEqual,
  notDeepEqual: assert.notDeepStrictEqual
});
assert.strict.strict = assert.strict;

/***/ }),
/* 60 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/errors.js
// https://github.com/nodejs/node/commit/3b044962c48fe313905877a96b5d0894a5404f6f

/* eslint node-core/documented-errors: "error" */
/* eslint node-core/alphabetize-errors: "error" */
/* eslint node-core/prefer-util-format-errors: "error" */



// The whole point behind this internal module is to allow Node.js to no
// longer be forced to treat every error message change as a semver-major
// change. The NodeError classes here all expose a `code` property whose
// value statically and permanently identifies the error. While the error
// message may change, the code should not.
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
var codes = {};

// Lazy loaded
var assert;
var util;
function createErrorType(code, message, Base) {
  if (!Base) {
    Base = Error;
  }
  function getMessage(arg1, arg2, arg3) {
    if (typeof message === 'string') {
      return message;
    } else {
      return message(arg1, arg2, arg3);
    }
  }
  var NodeError = /*#__PURE__*/function (_Base) {
    _inherits(NodeError, _Base);
    var _super = _createSuper(NodeError);
    function NodeError(arg1, arg2, arg3) {
      var _this;
      _classCallCheck(this, NodeError);
      _this = _super.call(this, getMessage(arg1, arg2, arg3));
      _this.code = code;
      return _this;
    }
    return _createClass(NodeError);
  }(Base);
  codes[code] = NodeError;
}

// https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js
function oneOf(expected, thing) {
  if (Array.isArray(expected)) {
    var len = expected.length;
    expected = expected.map(function (i) {
      return String(i);
    });
    if (len > 2) {
      return "one of ".concat(thing, " ").concat(expected.slice(0, len - 1).join(', '), ", or ") + expected[len - 1];
    } else if (len === 2) {
      return "one of ".concat(thing, " ").concat(expected[0], " or ").concat(expected[1]);
    } else {
      return "of ".concat(thing, " ").concat(expected[0]);
    }
  } else {
    return "of ".concat(thing, " ").concat(String(expected));
  }
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith
function startsWith(str, search, pos) {
  return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith
function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }
  return str.substring(this_len - search.length, this_len) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes
function includes(str, search, start) {
  if (typeof start !== 'number') {
    start = 0;
  }
  if (start + search.length > str.length) {
    return false;
  } else {
    return str.indexOf(search, start) !== -1;
  }
}
createErrorType('ERR_AMBIGUOUS_ARGUMENT', 'The "%s" argument is ambiguous. %s', TypeError);
createErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {
  if (assert === undefined) assert = __webpack_require__(59);
  assert(typeof name === 'string', "'name' must be a string");

  // determiner: 'must be' or 'must not be'
  var determiner;
  if (typeof expected === 'string' && startsWith(expected, 'not ')) {
    determiner = 'must not be';
    expected = expected.replace(/^not /, '');
  } else {
    determiner = 'must be';
  }
  var msg;
  if (endsWith(name, ' argument')) {
    // For cases like 'first argument'
    msg = "The ".concat(name, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  } else {
    var type = includes(name, '.') ? 'property' : 'argument';
    msg = "The \"".concat(name, "\" ").concat(type, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  }

  // TODO(BridgeAR): Improve the output by showing `null` and similar.
  msg += ". Received type ".concat(_typeof(actual));
  return msg;
}, TypeError);
createErrorType('ERR_INVALID_ARG_VALUE', function (name, value) {
  var reason = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'is invalid';
  if (util === undefined) util = __webpack_require__(3);
  var inspected = util.inspect(value);
  if (inspected.length > 128) {
    inspected = "".concat(inspected.slice(0, 128), "...");
  }
  return "The argument '".concat(name, "' ").concat(reason, ". Received ").concat(inspected);
}, TypeError, RangeError);
createErrorType('ERR_INVALID_RETURN_VALUE', function (input, name, value) {
  var type;
  if (value && value.constructor && value.constructor.name) {
    type = "instance of ".concat(value.constructor.name);
  } else {
    type = "type ".concat(_typeof(value));
  }
  return "Expected ".concat(input, " to be returned from the \"").concat(name, "\"") + " function but got ".concat(type, ".");
}, TypeError);
createErrorType('ERR_MISSING_ARGS', function () {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  if (assert === undefined) assert = __webpack_require__(59);
  assert(args.length > 0, 'At least one arg needs to be specified');
  var msg = 'The ';
  var len = args.length;
  args = args.map(function (a) {
    return "\"".concat(a, "\"");
  });
  switch (len) {
    case 1:
      msg += "".concat(args[0], " argument");
      break;
    case 2:
      msg += "".concat(args[0], " and ").concat(args[1], " arguments");
      break;
    default:
      msg += args.slice(0, len - 1).join(', ');
      msg += ", and ".concat(args[len - 1], " arguments");
      break;
  }
  return "".concat(msg, " must be specified");
}, TypeError);
module.exports.codes = codes;

/***/ }),
/* 61 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(4);
// Currently in sync with Node.js lib/internal/assert/assertion_error.js
// https://github.com/nodejs/node/commit/0817840f775032169ddd70c85ac059f18ffcc81c



function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }
function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _require = __webpack_require__(3),
  inspect = _require.inspect;
var _require2 = __webpack_require__(60),
  ERR_INVALID_ARG_TYPE = _require2.codes.ERR_INVALID_ARG_TYPE;

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith
function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }
  return str.substring(this_len - search.length, this_len) === search;
}

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat
function repeat(str, count) {
  count = Math.floor(count);
  if (str.length == 0 || count == 0) return '';
  var maxCount = str.length * count;
  count = Math.floor(Math.log(count) / Math.log(2));
  while (count) {
    str += str;
    count--;
  }
  str += str.substring(0, maxCount - str.length);
  return str;
}
var blue = '';
var green = '';
var red = '';
var white = '';
var kReadableOperator = {
  deepStrictEqual: 'Expected values to be strictly deep-equal:',
  strictEqual: 'Expected values to be strictly equal:',
  strictEqualObject: 'Expected "actual" to be reference-equal to "expected":',
  deepEqual: 'Expected values to be loosely deep-equal:',
  equal: 'Expected values to be loosely equal:',
  notDeepStrictEqual: 'Expected "actual" not to be strictly deep-equal to:',
  notStrictEqual: 'Expected "actual" to be strictly unequal to:',
  notStrictEqualObject: 'Expected "actual" not to be reference-equal to "expected":',
  notDeepEqual: 'Expected "actual" not to be loosely deep-equal to:',
  notEqual: 'Expected "actual" to be loosely unequal to:',
  notIdentical: 'Values identical but not reference-equal:'
};

// Comparing short primitives should just show === / !== instead of using the
// diff.
var kMaxShortLength = 10;
function copyError(source) {
  var keys = Object.keys(source);
  var target = Object.create(Object.getPrototypeOf(source));
  keys.forEach(function (key) {
    target[key] = source[key];
  });
  Object.defineProperty(target, 'message', {
    value: source.message
  });
  return target;
}
function inspectValue(val) {
  // The util.inspect default values could be changed. This makes sure the
  // error messages contain the necessary information nevertheless.
  return inspect(val, {
    compact: false,
    customInspect: false,
    depth: 1000,
    maxArrayLength: Infinity,
    // Assert compares only enumerable properties (with a few exceptions).
    showHidden: false,
    // Having a long line as error is better than wrapping the line for
    // comparison for now.
    // TODO(BridgeAR): `breakLength` should be limited as soon as soon as we
    // have meta information about the inspected properties (i.e., know where
    // in what line the property starts and ends).
    breakLength: Infinity,
    // Assert does not detect proxies currently.
    showProxy: false,
    sorted: true,
    // Inspect getters as we also check them when comparing entries.
    getters: true
  });
}
function createErrDiff(actual, expected, operator) {
  var other = '';
  var res = '';
  var lastPos = 0;
  var end = '';
  var skipped = false;
  var actualInspected = inspectValue(actual);
  var actualLines = actualInspected.split('\n');
  var expectedLines = inspectValue(expected).split('\n');
  var i = 0;
  var indicator = '';

  // In case both values are objects explicitly mark them as not reference equal
  // for the `strictEqual` operator.
  if (operator === 'strictEqual' && _typeof(actual) === 'object' && _typeof(expected) === 'object' && actual !== null && expected !== null) {
    operator = 'strictEqualObject';
  }

  // If "actual" and "expected" fit on a single line and they are not strictly
  // equal, check further special handling.
  if (actualLines.length === 1 && expectedLines.length === 1 && actualLines[0] !== expectedLines[0]) {
    var inputLength = actualLines[0].length + expectedLines[0].length;
    // If the character length of "actual" and "expected" together is less than
    // kMaxShortLength and if neither is an object and at least one of them is
    // not `zero`, use the strict equal comparison to visualize the output.
    if (inputLength <= kMaxShortLength) {
      if ((_typeof(actual) !== 'object' || actual === null) && (_typeof(expected) !== 'object' || expected === null) && (actual !== 0 || expected !== 0)) {
        // -0 === +0
        return "".concat(kReadableOperator[operator], "\n\n") + "".concat(actualLines[0], " !== ").concat(expectedLines[0], "\n");
      }
    } else if (operator !== 'strictEqualObject') {
      // If the stderr is a tty and the input length is lower than the current
      // columns per line, add a mismatch indicator below the output. If it is
      // not a tty, use a default value of 80 characters.
      var maxLength = process.stderr && process.stderr.isTTY ? process.stderr.columns : 80;
      if (inputLength < maxLength) {
        while (actualLines[0][i] === expectedLines[0][i]) {
          i++;
        }
        // Ignore the first characters.
        if (i > 2) {
          // Add position indicator for the first mismatch in case it is a
          // single line and the input length is less than the column length.
          indicator = "\n  ".concat(repeat(' ', i), "^");
          i = 0;
        }
      }
    }
  }

  // Remove all ending lines that match (this optimizes the output for
  // readability by reducing the number of total changed lines).
  var a = actualLines[actualLines.length - 1];
  var b = expectedLines[expectedLines.length - 1];
  while (a === b) {
    if (i++ < 2) {
      end = "\n  ".concat(a).concat(end);
    } else {
      other = a;
    }
    actualLines.pop();
    expectedLines.pop();
    if (actualLines.length === 0 || expectedLines.length === 0) break;
    a = actualLines[actualLines.length - 1];
    b = expectedLines[expectedLines.length - 1];
  }
  var maxLines = Math.max(actualLines.length, expectedLines.length);
  // Strict equal with identical objects that are not identical by reference.
  // E.g., assert.deepStrictEqual({ a: Symbol() }, { a: Symbol() })
  if (maxLines === 0) {
    // We have to get the result again. The lines were all removed before.
    var _actualLines = actualInspected.split('\n');

    // Only remove lines in case it makes sense to collapse those.
    // TODO: Accept env to always show the full error.
    if (_actualLines.length > 30) {
      _actualLines[26] = "".concat(blue, "...").concat(white);
      while (_actualLines.length > 27) {
        _actualLines.pop();
      }
    }
    return "".concat(kReadableOperator.notIdentical, "\n\n").concat(_actualLines.join('\n'), "\n");
  }
  if (i > 3) {
    end = "\n".concat(blue, "...").concat(white).concat(end);
    skipped = true;
  }
  if (other !== '') {
    end = "\n  ".concat(other).concat(end);
    other = '';
  }
  var printedLines = 0;
  var msg = kReadableOperator[operator] + "\n".concat(green, "+ actual").concat(white, " ").concat(red, "- expected").concat(white);
  var skippedMsg = " ".concat(blue, "...").concat(white, " Lines skipped");
  for (i = 0; i < maxLines; i++) {
    // Only extra expected lines exist
    var cur = i - lastPos;
    if (actualLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(expectedLines[i - 2]);
          printedLines++;
        }
        res += "\n  ".concat(expectedLines[i - 1]);
        printedLines++;
      }
      // Mark the current line as the last diverging one.
      lastPos = i;
      // Add the expected line to the cache.
      other += "\n".concat(red, "-").concat(white, " ").concat(expectedLines[i]);
      printedLines++;
      // Only extra actual lines exist
    } else if (expectedLines.length < i + 1) {
      // If the last diverging line is more than one line above and the
      // current line is at least line three, add some of the former lines and
      // also add dots to indicate skipped entries.
      if (cur > 1 && i > 2) {
        if (cur > 4) {
          res += "\n".concat(blue, "...").concat(white);
          skipped = true;
        } else if (cur > 3) {
          res += "\n  ".concat(actualLines[i - 2]);
          printedLines++;
        }
        res += "\n  ".concat(actualLines[i - 1]);
        printedLines++;
      }
      // Mark the current line as the last diverging one.
      lastPos = i;
      // Add the actual line to the result.
      res += "\n".concat(green, "+").concat(white, " ").concat(actualLines[i]);
      printedLines++;
      // Lines diverge
    } else {
      var expectedLine = expectedLines[i];
      var actualLine = actualLines[i];
      // If the lines diverge, specifically check for lines that only diverge by
      // a trailing comma. In that case it is actually identical and we should
      // mark it as such.
      var divergingLines = actualLine !== expectedLine && (!endsWith(actualLine, ',') || actualLine.slice(0, -1) !== expectedLine);
      // If the expected line has a trailing comma but is otherwise identical,
      // add a comma at the end of the actual line. Otherwise the output could
      // look weird as in:
      //
      //   [
      //     1         // No comma at the end!
      // +   2
      //   ]
      //
      if (divergingLines && endsWith(expectedLine, ',') && expectedLine.slice(0, -1) === actualLine) {
        divergingLines = false;
        actualLine += ',';
      }
      if (divergingLines) {
        // If the last diverging line is more than one line above and the
        // current line is at least line three, add some of the former lines and
        // also add dots to indicate skipped entries.
        if (cur > 1 && i > 2) {
          if (cur > 4) {
            res += "\n".concat(blue, "...").concat(white);
            skipped = true;
          } else if (cur > 3) {
            res += "\n  ".concat(actualLines[i - 2]);
            printedLines++;
          }
          res += "\n  ".concat(actualLines[i - 1]);
          printedLines++;
        }
        // Mark the current line as the last diverging one.
        lastPos = i;
        // Add the actual line to the result and cache the expected diverging
        // line so consecutive diverging lines show up as +++--- and not +-+-+-.
        res += "\n".concat(green, "+").concat(white, " ").concat(actualLine);
        other += "\n".concat(red, "-").concat(white, " ").concat(expectedLine);
        printedLines += 2;
        // Lines are identical
      } else {
        // Add all cached information to the result before adding other things
        // and reset the cache.
        res += other;
        other = '';
        // If the last diverging line is exactly one line above or if it is the
        // very first line, add the line to the result.
        if (cur === 1 || i === 0) {
          res += "\n  ".concat(actualLine);
          printedLines++;
        }
      }
    }
    // Inspected object to big (Show ~20 rows max)
    if (printedLines > 20 && i < maxLines - 2) {
      return "".concat(msg).concat(skippedMsg, "\n").concat(res, "\n").concat(blue, "...").concat(white).concat(other, "\n") + "".concat(blue, "...").concat(white);
    }
  }
  return "".concat(msg).concat(skipped ? skippedMsg : '', "\n").concat(res).concat(other).concat(end).concat(indicator);
}
var AssertionError = /*#__PURE__*/function (_Error, _inspect$custom) {
  _inherits(AssertionError, _Error);
  var _super = _createSuper(AssertionError);
  function AssertionError(options) {
    var _this;
    _classCallCheck(this, AssertionError);
    if (_typeof(options) !== 'object' || options === null) {
      throw new ERR_INVALID_ARG_TYPE('options', 'Object', options);
    }
    var message = options.message,
      operator = options.operator,
      stackStartFn = options.stackStartFn;
    var actual = options.actual,
      expected = options.expected;
    var limit = Error.stackTraceLimit;
    Error.stackTraceLimit = 0;
    if (message != null) {
      _this = _super.call(this, String(message));
    } else {
      if (process.stderr && process.stderr.isTTY) {
        // Reset on each call to make sure we handle dynamically set environment
        // variables correct.
        if (process.stderr && process.stderr.getColorDepth && process.stderr.getColorDepth() !== 1) {
          blue = "\x1B[34m";
          green = "\x1B[32m";
          white = "\x1B[39m";
          red = "\x1B[31m";
        } else {
          blue = '';
          green = '';
          white = '';
          red = '';
        }
      }
      // Prevent the error stack from being visible by duplicating the error
      // in a very close way to the original in case both sides are actually
      // instances of Error.
      if (_typeof(actual) === 'object' && actual !== null && _typeof(expected) === 'object' && expected !== null && 'stack' in actual && actual instanceof Error && 'stack' in expected && expected instanceof Error) {
        actual = copyError(actual);
        expected = copyError(expected);
      }
      if (operator === 'deepStrictEqual' || operator === 'strictEqual') {
        _this = _super.call(this, createErrDiff(actual, expected, operator));
      } else if (operator === 'notDeepStrictEqual' || operator === 'notStrictEqual') {
        // In case the objects are equal but the operator requires unequal, show
        // the first object and say A equals B
        var base = kReadableOperator[operator];
        var res = inspectValue(actual).split('\n');

        // In case "actual" is an object, it should not be reference equal.
        if (operator === 'notStrictEqual' && _typeof(actual) === 'object' && actual !== null) {
          base = kReadableOperator.notStrictEqualObject;
        }

        // Only remove lines in case it makes sense to collapse those.
        // TODO: Accept env to always show the full error.
        if (res.length > 30) {
          res[26] = "".concat(blue, "...").concat(white);
          while (res.length > 27) {
            res.pop();
          }
        }

        // Only print a single input.
        if (res.length === 1) {
          _this = _super.call(this, "".concat(base, " ").concat(res[0]));
        } else {
          _this = _super.call(this, "".concat(base, "\n\n").concat(res.join('\n'), "\n"));
        }
      } else {
        var _res = inspectValue(actual);
        var other = '';
        var knownOperators = kReadableOperator[operator];
        if (operator === 'notDeepEqual' || operator === 'notEqual') {
          _res = "".concat(kReadableOperator[operator], "\n\n").concat(_res);
          if (_res.length > 1024) {
            _res = "".concat(_res.slice(0, 1021), "...");
          }
        } else {
          other = "".concat(inspectValue(expected));
          if (_res.length > 512) {
            _res = "".concat(_res.slice(0, 509), "...");
          }
          if (other.length > 512) {
            other = "".concat(other.slice(0, 509), "...");
          }
          if (operator === 'deepEqual' || operator === 'equal') {
            _res = "".concat(knownOperators, "\n\n").concat(_res, "\n\nshould equal\n\n");
          } else {
            other = " ".concat(operator, " ").concat(other);
          }
        }
        _this = _super.call(this, "".concat(_res).concat(other));
      }
    }
    Error.stackTraceLimit = limit;
    _this.generatedMessage = !message;
    Object.defineProperty(_assertThisInitialized(_this), 'name', {
      value: 'AssertionError [ERR_ASSERTION]',
      enumerable: false,
      writable: true,
      configurable: true
    });
    _this.code = 'ERR_ASSERTION';
    _this.actual = actual;
    _this.expected = expected;
    _this.operator = operator;
    if (Error.captureStackTrace) {
      // eslint-disable-next-line no-restricted-syntax
      Error.captureStackTrace(_assertThisInitialized(_this), stackStartFn);
    }
    // Create error message including the error code in the name.
    _this.stack;
    // Reset the name.
    _this.name = 'AssertionError';
    return _possibleConstructorReturn(_this);
  }
  _createClass(AssertionError, [{
    key: "toString",
    value: function toString() {
      return "".concat(this.name, " [").concat(this.code, "]: ").concat(this.message);
    }
  }, {
    key: _inspect$custom,
    value: function value(recurseTimes, ctx) {
      // This limits the `actual` and `expected` property default inspection to
      // the minimum depth. Otherwise those values would be too verbose compared
      // to the actual error message which contains a combined view of these two
      // input values.
      return inspect(this, _objectSpread(_objectSpread({}, ctx), {}, {
        customInspect: false,
        depth: 0
      }));
    }
  }]);
  return AssertionError;
}( /*#__PURE__*/_wrapNativeSuper(Error), inspect.custom);
module.exports = AssertionError;

/***/ }),
/* 62 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(63);

var lacksProperEnumerationOrder = function () {
	if (!Object.assign) {
		return false;
	}
	/*
	 * v8, specifically in node 4.x, has a bug with incorrect property enumeration order
	 * note: this does not detect the bug unless there's 20 characters
	 */
	var str = 'abcdefghijklmnopqrst';
	var letters = str.split('');
	var map = {};
	for (var i = 0; i < letters.length; ++i) {
		map[letters[i]] = letters[i];
	}
	var obj = Object.assign({}, map);
	var actual = '';
	for (var k in obj) {
		actual += k;
	}
	return str !== actual;
};

var assignHasPendingExceptions = function () {
	if (!Object.assign || !Object.preventExtensions) {
		return false;
	}
	/*
	 * Firefox 37 still has "pending exception" logic in its Object.assign implementation,
	 * which is 72% slower than our shim, and Firefox 40's native implementation.
	 */
	var thrower = Object.preventExtensions({ 1: 2 });
	try {
		Object.assign(thrower, 'xy');
	} catch (e) {
		return thrower[1] === 'y';
	}
	return false;
};

module.exports = function getPolyfill() {
	if (!Object.assign) {
		return implementation;
	}
	if (lacksProperEnumerationOrder()) {
		return implementation;
	}
	if (assignHasPendingExceptions()) {
		return implementation;
	}
	return Object.assign;
};


/***/ }),
/* 63 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// modified from https://github.com/es-shims/es6-shim
var objectKeys = __webpack_require__(64);
var hasSymbols = __webpack_require__(8)();
var callBound = __webpack_require__(9);
var $Object = __webpack_require__(11);
var $push = callBound('Array.prototype.push');
var $propIsEnumerable = callBound('Object.prototype.propertyIsEnumerable');
var originalGetSymbols = hasSymbols ? $Object.getOwnPropertySymbols : null;

// eslint-disable-next-line no-unused-vars
module.exports = function assign(target, source1) {
	if (target == null) { throw new TypeError('target must be an object'); }
	var to = $Object(target); // step 1
	if (arguments.length === 1) {
		return to; // step 2
	}
	for (var s = 1; s < arguments.length; ++s) {
		var from = $Object(arguments[s]); // step 3.a.i

		// step 3.a.ii:
		var keys = objectKeys(from);
		var getSymbols = hasSymbols && ($Object.getOwnPropertySymbols || originalGetSymbols);
		if (getSymbols) {
			var syms = getSymbols(from);
			for (var j = 0; j < syms.length; ++j) {
				var key = syms[j];
				if ($propIsEnumerable(from, key)) {
					$push(keys, key);
				}
			}
		}

		// step 3.a.iii:
		for (var i = 0; i < keys.length; ++i) {
			var nextKey = keys[i];
			if ($propIsEnumerable(from, nextKey)) { // step 3.a.iii.2
				var propValue = from[nextKey]; // step 3.a.iii.2.a
				to[nextKey] = propValue; // step 3.a.iii.2.b
			}
		}
	}

	return to; // step 4
};


/***/ }),
/* 64 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var slice = Array.prototype.slice;
var isArgs = __webpack_require__(65);

var origKeys = Object.keys;
var keysShim = origKeys ? function keys(o) { return origKeys(o); } : __webpack_require__(66);

var originalKeys = Object.keys;

keysShim.shim = function shimObjectKeys() {
	if (Object.keys) {
		var keysWorksWithArguments = (function () {
			// Safari 5.0 bug
			var args = Object.keys(arguments);
			return args && args.length === arguments.length;
		}(1, 2));
		if (!keysWorksWithArguments) {
			Object.keys = function keys(object) { // eslint-disable-line func-name-matching
				if (isArgs(object)) {
					return originalKeys(slice.call(object));
				}
				return originalKeys(object);
			};
		}
	} else {
		Object.keys = keysShim;
	}
	return Object.keys || keysShim;
};

module.exports = keysShim;


/***/ }),
/* 65 */
/***/ ((module) => {

"use strict";


var toStr = Object.prototype.toString;

module.exports = function isArguments(value) {
	var str = toStr.call(value);
	var isArgs = str === '[object Arguments]';
	if (!isArgs) {
		isArgs = str !== '[object Array]' &&
			value !== null &&
			typeof value === 'object' &&
			typeof value.length === 'number' &&
			value.length >= 0 &&
			toStr.call(value.callee) === '[object Function]';
	}
	return isArgs;
};


/***/ }),
/* 66 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var keysShim;
if (!Object.keys) {
	// modified from https://github.com/es-shims/es5-shim
	var has = Object.prototype.hasOwnProperty;
	var toStr = Object.prototype.toString;
	var isArgs = __webpack_require__(65); // eslint-disable-line global-require
	var isEnumerable = Object.prototype.propertyIsEnumerable;
	var hasDontEnumBug = !isEnumerable.call({ toString: null }, 'toString');
	var hasProtoEnumBug = isEnumerable.call(function () {}, 'prototype');
	var dontEnums = [
		'toString',
		'toLocaleString',
		'valueOf',
		'hasOwnProperty',
		'isPrototypeOf',
		'propertyIsEnumerable',
		'constructor'
	];
	var equalsConstructorPrototype = function (o) {
		var ctor = o.constructor;
		return ctor && ctor.prototype === o;
	};
	var excludedKeys = {
		$applicationCache: true,
		$console: true,
		$external: true,
		$frame: true,
		$frameElement: true,
		$frames: true,
		$innerHeight: true,
		$innerWidth: true,
		$onmozfullscreenchange: true,
		$onmozfullscreenerror: true,
		$outerHeight: true,
		$outerWidth: true,
		$pageXOffset: true,
		$pageYOffset: true,
		$parent: true,
		$scrollLeft: true,
		$scrollTop: true,
		$scrollX: true,
		$scrollY: true,
		$self: true,
		$webkitIndexedDB: true,
		$webkitStorageInfo: true,
		$window: true
	};
	var hasAutomationEqualityBug = (function () {
		/* global window */
		if (typeof window === 'undefined') { return false; }
		for (var k in window) {
			try {
				if (!excludedKeys['$' + k] && has.call(window, k) && window[k] !== null && typeof window[k] === 'object') {
					try {
						equalsConstructorPrototype(window[k]);
					} catch (e) {
						return true;
					}
				}
			} catch (e) {
				return true;
			}
		}
		return false;
	}());
	var equalsConstructorPrototypeIfNotBuggy = function (o) {
		/* global window */
		if (typeof window === 'undefined' || !hasAutomationEqualityBug) {
			return equalsConstructorPrototype(o);
		}
		try {
			return equalsConstructorPrototype(o);
		} catch (e) {
			return false;
		}
	};

	keysShim = function keys(object) {
		var isObject = object !== null && typeof object === 'object';
		var isFunction = toStr.call(object) === '[object Function]';
		var isArguments = isArgs(object);
		var isString = isObject && toStr.call(object) === '[object String]';
		var theKeys = [];

		if (!isObject && !isFunction && !isArguments) {
			throw new TypeError('Object.keys called on a non-object');
		}

		var skipProto = hasProtoEnumBug && isFunction;
		if (isString && object.length > 0 && !has.call(object, 0)) {
			for (var i = 0; i < object.length; ++i) {
				theKeys.push(String(i));
			}
		}

		if (isArguments && object.length > 0) {
			for (var j = 0; j < object.length; ++j) {
				theKeys.push(String(j));
			}
		} else {
			for (var name in object) {
				if (!(skipProto && name === 'prototype') && has.call(object, name)) {
					theKeys.push(String(name));
				}
			}
		}

		if (hasDontEnumBug) {
			var skipConstructor = equalsConstructorPrototypeIfNotBuggy(object);

			for (var k = 0; k < dontEnums.length; ++k) {
				if (!(skipConstructor && dontEnums[k] === 'constructor') && has.call(object, dontEnums[k])) {
					theKeys.push(dontEnums[k]);
				}
			}
		}
		return theKeys;
	};
}
module.exports = keysShim;


/***/ }),
/* 67 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(68);

module.exports = function getPolyfill() {
	return typeof Object.is === 'function' ? Object.is : implementation;
};


/***/ }),
/* 68 */
/***/ ((module) => {

"use strict";


var numberIsNaN = function (value) {
	return value !== value;
};

module.exports = function is(a, b) {
	if (a === 0 && b === 0) {
		return 1 / a === 1 / b;
	}
	if (a === b) {
		return true;
	}
	if (numberIsNaN(a) && numberIsNaN(b)) {
		return true;
	}
	return false;
};



/***/ }),
/* 69 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(10);

var callBind = __webpack_require__(51);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),
/* 70 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
// Currently in sync with Node.js lib/internal/util/comparisons.js
// https://github.com/nodejs/node/commit/112cc7c27551254aa2b17098fb774867f05ed0d9



function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var regexFlagsSupported = /a/g.flags !== undefined;
var arrayFromSet = function arrayFromSet(set) {
  var array = [];
  set.forEach(function (value) {
    return array.push(value);
  });
  return array;
};
var arrayFromMap = function arrayFromMap(map) {
  var array = [];
  map.forEach(function (value, key) {
    return array.push([key, value]);
  });
  return array;
};
var objectIs = Object.is ? Object.is : __webpack_require__(71);
var objectGetOwnPropertySymbols = Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols : function () {
  return [];
};
var numberIsNaN = Number.isNaN ? Number.isNaN : __webpack_require__(74);
function uncurryThis(f) {
  return f.call.bind(f);
}
var hasOwnProperty = uncurryThis(Object.prototype.hasOwnProperty);
var propertyIsEnumerable = uncurryThis(Object.prototype.propertyIsEnumerable);
var objectToString = uncurryThis(Object.prototype.toString);
var _require$types = (__webpack_require__(3).types),
  isAnyArrayBuffer = _require$types.isAnyArrayBuffer,
  isArrayBufferView = _require$types.isArrayBufferView,
  isDate = _require$types.isDate,
  isMap = _require$types.isMap,
  isRegExp = _require$types.isRegExp,
  isSet = _require$types.isSet,
  isNativeError = _require$types.isNativeError,
  isBoxedPrimitive = _require$types.isBoxedPrimitive,
  isNumberObject = _require$types.isNumberObject,
  isStringObject = _require$types.isStringObject,
  isBooleanObject = _require$types.isBooleanObject,
  isBigIntObject = _require$types.isBigIntObject,
  isSymbolObject = _require$types.isSymbolObject,
  isFloat32Array = _require$types.isFloat32Array,
  isFloat64Array = _require$types.isFloat64Array;
function isNonIndex(key) {
  if (key.length === 0 || key.length > 10) return true;
  for (var i = 0; i < key.length; i++) {
    var code = key.charCodeAt(i);
    if (code < 48 || code > 57) return true;
  }
  // The maximum size for an array is 2 ** 32 -1.
  return key.length === 10 && key >= Math.pow(2, 32);
}
function getOwnNonIndexProperties(value) {
  return Object.keys(value).filter(isNonIndex).concat(objectGetOwnPropertySymbols(value).filter(Object.prototype.propertyIsEnumerable.bind(value)));
}

// Taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
function compare(a, b) {
  if (a === b) {
    return 0;
  }
  var x = a.length;
  var y = b.length;
  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }
  if (x < y) {
    return -1;
  }
  if (y < x) {
    return 1;
  }
  return 0;
}
var ONLY_ENUMERABLE = undefined;
var kStrict = true;
var kLoose = false;
var kNoIterator = 0;
var kIsArray = 1;
var kIsSet = 2;
var kIsMap = 3;

// Check if they have the same source and flags
function areSimilarRegExps(a, b) {
  return regexFlagsSupported ? a.source === b.source && a.flags === b.flags : RegExp.prototype.toString.call(a) === RegExp.prototype.toString.call(b);
}
function areSimilarFloatArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }
  for (var offset = 0; offset < a.byteLength; offset++) {
    if (a[offset] !== b[offset]) {
      return false;
    }
  }
  return true;
}
function areSimilarTypedArrays(a, b) {
  if (a.byteLength !== b.byteLength) {
    return false;
  }
  return compare(new Uint8Array(a.buffer, a.byteOffset, a.byteLength), new Uint8Array(b.buffer, b.byteOffset, b.byteLength)) === 0;
}
function areEqualArrayBuffers(buf1, buf2) {
  return buf1.byteLength === buf2.byteLength && compare(new Uint8Array(buf1), new Uint8Array(buf2)) === 0;
}
function isEqualBoxedPrimitive(val1, val2) {
  if (isNumberObject(val1)) {
    return isNumberObject(val2) && objectIs(Number.prototype.valueOf.call(val1), Number.prototype.valueOf.call(val2));
  }
  if (isStringObject(val1)) {
    return isStringObject(val2) && String.prototype.valueOf.call(val1) === String.prototype.valueOf.call(val2);
  }
  if (isBooleanObject(val1)) {
    return isBooleanObject(val2) && Boolean.prototype.valueOf.call(val1) === Boolean.prototype.valueOf.call(val2);
  }
  if (isBigIntObject(val1)) {
    return isBigIntObject(val2) && BigInt.prototype.valueOf.call(val1) === BigInt.prototype.valueOf.call(val2);
  }
  return isSymbolObject(val2) && Symbol.prototype.valueOf.call(val1) === Symbol.prototype.valueOf.call(val2);
}

// Notes: Type tags are historical [[Class]] properties that can be set by
// FunctionTemplate::SetClassName() in C++ or Symbol.toStringTag in JS
// and retrieved using Object.prototype.toString.call(obj) in JS
// See https://tc39.github.io/ecma262/#sec-object.prototype.tostring
// for a list of tags pre-defined in the spec.
// There are some unspecified tags in the wild too (e.g. typed array tags).
// Since tags can be altered, they only serve fast failures
//
// Typed arrays and buffers are checked by comparing the content in their
// underlying ArrayBuffer. This optimization requires that it's
// reasonable to interpret their underlying memory in the same way,
// which is checked by comparing their type tags.
// (e.g. a Uint8Array and a Uint16Array with the same memory content
// could still be different because they will be interpreted differently).
//
// For strict comparison, objects should have
// a) The same built-in type tags
// b) The same prototypes.

function innerDeepEqual(val1, val2, strict, memos) {
  // All identical values are equivalent, as determined by ===.
  if (val1 === val2) {
    if (val1 !== 0) return true;
    return strict ? objectIs(val1, val2) : true;
  }

  // Check more closely if val1 and val2 are equal.
  if (strict) {
    if (_typeof(val1) !== 'object') {
      return typeof val1 === 'number' && numberIsNaN(val1) && numberIsNaN(val2);
    }
    if (_typeof(val2) !== 'object' || val1 === null || val2 === null) {
      return false;
    }
    if (Object.getPrototypeOf(val1) !== Object.getPrototypeOf(val2)) {
      return false;
    }
  } else {
    if (val1 === null || _typeof(val1) !== 'object') {
      if (val2 === null || _typeof(val2) !== 'object') {
        // eslint-disable-next-line eqeqeq
        return val1 == val2;
      }
      return false;
    }
    if (val2 === null || _typeof(val2) !== 'object') {
      return false;
    }
  }
  var val1Tag = objectToString(val1);
  var val2Tag = objectToString(val2);
  if (val1Tag !== val2Tag) {
    return false;
  }
  if (Array.isArray(val1)) {
    // Check for sparse arrays and general fast path
    if (val1.length !== val2.length) {
      return false;
    }
    var keys1 = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);
    var keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);
    if (keys1.length !== keys2.length) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsArray, keys1);
  }
  // [browserify] This triggers on certain types in IE (Map/Set) so we don't
  // wan't to early return out of the rest of the checks. However we can check
  // if the second value is one of these values and the first isn't.
  if (val1Tag === '[object Object]') {
    // return keyCheck(val1, val2, strict, memos, kNoIterator);
    if (!isMap(val1) && isMap(val2) || !isSet(val1) && isSet(val2)) {
      return false;
    }
  }
  if (isDate(val1)) {
    if (!isDate(val2) || Date.prototype.getTime.call(val1) !== Date.prototype.getTime.call(val2)) {
      return false;
    }
  } else if (isRegExp(val1)) {
    if (!isRegExp(val2) || !areSimilarRegExps(val1, val2)) {
      return false;
    }
  } else if (isNativeError(val1) || val1 instanceof Error) {
    // Do not compare the stack as it might differ even though the error itself
    // is otherwise identical.
    if (val1.message !== val2.message || val1.name !== val2.name) {
      return false;
    }
  } else if (isArrayBufferView(val1)) {
    if (!strict && (isFloat32Array(val1) || isFloat64Array(val1))) {
      if (!areSimilarFloatArrays(val1, val2)) {
        return false;
      }
    } else if (!areSimilarTypedArrays(val1, val2)) {
      return false;
    }
    // Buffer.compare returns true, so val1.length === val2.length. If they both
    // only contain numeric keys, we don't need to exam further than checking
    // the symbols.
    var _keys = getOwnNonIndexProperties(val1, ONLY_ENUMERABLE);
    var _keys2 = getOwnNonIndexProperties(val2, ONLY_ENUMERABLE);
    if (_keys.length !== _keys2.length) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kNoIterator, _keys);
  } else if (isSet(val1)) {
    if (!isSet(val2) || val1.size !== val2.size) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsSet);
  } else if (isMap(val1)) {
    if (!isMap(val2) || val1.size !== val2.size) {
      return false;
    }
    return keyCheck(val1, val2, strict, memos, kIsMap);
  } else if (isAnyArrayBuffer(val1)) {
    if (!areEqualArrayBuffers(val1, val2)) {
      return false;
    }
  } else if (isBoxedPrimitive(val1) && !isEqualBoxedPrimitive(val1, val2)) {
    return false;
  }
  return keyCheck(val1, val2, strict, memos, kNoIterator);
}
function getEnumerables(val, keys) {
  return keys.filter(function (k) {
    return propertyIsEnumerable(val, k);
  });
}
function keyCheck(val1, val2, strict, memos, iterationType, aKeys) {
  // For all remaining Object pairs, including Array, objects and Maps,
  // equivalence is determined by having:
  // a) The same number of owned enumerable properties
  // b) The same set of keys/indexes (although not necessarily the same order)
  // c) Equivalent values for every corresponding key/index
  // d) For Sets and Maps, equal contents
  // Note: this accounts for both named and indexed properties on Arrays.
  if (arguments.length === 5) {
    aKeys = Object.keys(val1);
    var bKeys = Object.keys(val2);

    // The pair must have the same number of owned properties.
    if (aKeys.length !== bKeys.length) {
      return false;
    }
  }

  // Cheap key test
  var i = 0;
  for (; i < aKeys.length; i++) {
    if (!hasOwnProperty(val2, aKeys[i])) {
      return false;
    }
  }
  if (strict && arguments.length === 5) {
    var symbolKeysA = objectGetOwnPropertySymbols(val1);
    if (symbolKeysA.length !== 0) {
      var count = 0;
      for (i = 0; i < symbolKeysA.length; i++) {
        var key = symbolKeysA[i];
        if (propertyIsEnumerable(val1, key)) {
          if (!propertyIsEnumerable(val2, key)) {
            return false;
          }
          aKeys.push(key);
          count++;
        } else if (propertyIsEnumerable(val2, key)) {
          return false;
        }
      }
      var symbolKeysB = objectGetOwnPropertySymbols(val2);
      if (symbolKeysA.length !== symbolKeysB.length && getEnumerables(val2, symbolKeysB).length !== count) {
        return false;
      }
    } else {
      var _symbolKeysB = objectGetOwnPropertySymbols(val2);
      if (_symbolKeysB.length !== 0 && getEnumerables(val2, _symbolKeysB).length !== 0) {
        return false;
      }
    }
  }
  if (aKeys.length === 0 && (iterationType === kNoIterator || iterationType === kIsArray && val1.length === 0 || val1.size === 0)) {
    return true;
  }

  // Use memos to handle cycles.
  if (memos === undefined) {
    memos = {
      val1: new Map(),
      val2: new Map(),
      position: 0
    };
  } else {
    // We prevent up to two map.has(x) calls by directly retrieving the value
    // and checking for undefined. The map can only contain numbers, so it is
    // safe to check for undefined only.
    var val2MemoA = memos.val1.get(val1);
    if (val2MemoA !== undefined) {
      var val2MemoB = memos.val2.get(val2);
      if (val2MemoB !== undefined) {
        return val2MemoA === val2MemoB;
      }
    }
    memos.position++;
  }
  memos.val1.set(val1, memos.position);
  memos.val2.set(val2, memos.position);
  var areEq = objEquiv(val1, val2, strict, aKeys, memos, iterationType);
  memos.val1.delete(val1);
  memos.val2.delete(val2);
  return areEq;
}
function setHasEqualElement(set, val1, strict, memo) {
  // Go looking.
  var setValues = arrayFromSet(set);
  for (var i = 0; i < setValues.length; i++) {
    var val2 = setValues[i];
    if (innerDeepEqual(val1, val2, strict, memo)) {
      // Remove the matching element to make sure we do not check that again.
      set.delete(val2);
      return true;
    }
  }
  return false;
}

// See https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness#Loose_equality_using
// Sadly it is not possible to detect corresponding values properly in case the
// type is a string, number, bigint or boolean. The reason is that those values
// can match lots of different string values (e.g., 1n == '+00001').
function findLooseMatchingPrimitives(prim) {
  switch (_typeof(prim)) {
    case 'undefined':
      return null;
    case 'object':
      // Only pass in null as object!
      return undefined;
    case 'symbol':
      return false;
    case 'string':
      prim = +prim;
    // Loose equal entries exist only if the string is possible to convert to
    // a regular number and not NaN.
    // Fall through
    case 'number':
      if (numberIsNaN(prim)) {
        return false;
      }
  }
  return true;
}
function setMightHaveLoosePrim(a, b, prim) {
  var altValue = findLooseMatchingPrimitives(prim);
  if (altValue != null) return altValue;
  return b.has(altValue) && !a.has(altValue);
}
function mapMightHaveLoosePrim(a, b, prim, item, memo) {
  var altValue = findLooseMatchingPrimitives(prim);
  if (altValue != null) {
    return altValue;
  }
  var curB = b.get(altValue);
  if (curB === undefined && !b.has(altValue) || !innerDeepEqual(item, curB, false, memo)) {
    return false;
  }
  return !a.has(altValue) && innerDeepEqual(item, curB, false, memo);
}
function setEquiv(a, b, strict, memo) {
  // This is a lazily initiated Set of entries which have to be compared
  // pairwise.
  var set = null;
  var aValues = arrayFromSet(a);
  for (var i = 0; i < aValues.length; i++) {
    var val = aValues[i];
    // Note: Checking for the objects first improves the performance for object
    // heavy sets but it is a minor slow down for primitives. As they are fast
    // to check this improves the worst case scenario instead.
    if (_typeof(val) === 'object' && val !== null) {
      if (set === null) {
        set = new Set();
      }
      // If the specified value doesn't exist in the second set its an not null
      // object (or non strict only: a not matching primitive) we'll need to go
      // hunting for something thats deep-(strict-)equal to it. To make this
      // O(n log n) complexity we have to copy these values in a new set first.
      set.add(val);
    } else if (!b.has(val)) {
      if (strict) return false;

      // Fast path to detect missing string, symbol, undefined and null values.
      if (!setMightHaveLoosePrim(a, b, val)) {
        return false;
      }
      if (set === null) {
        set = new Set();
      }
      set.add(val);
    }
  }
  if (set !== null) {
    var bValues = arrayFromSet(b);
    for (var _i = 0; _i < bValues.length; _i++) {
      var _val = bValues[_i];
      // We have to check if a primitive value is already
      // matching and only if it's not, go hunting for it.
      if (_typeof(_val) === 'object' && _val !== null) {
        if (!setHasEqualElement(set, _val, strict, memo)) return false;
      } else if (!strict && !a.has(_val) && !setHasEqualElement(set, _val, strict, memo)) {
        return false;
      }
    }
    return set.size === 0;
  }
  return true;
}
function mapHasEqualEntry(set, map, key1, item1, strict, memo) {
  // To be able to handle cases like:
  //   Map([[{}, 'a'], [{}, 'b']]) vs Map([[{}, 'b'], [{}, 'a']])
  // ... we need to consider *all* matching keys, not just the first we find.
  var setValues = arrayFromSet(set);
  for (var i = 0; i < setValues.length; i++) {
    var key2 = setValues[i];
    if (innerDeepEqual(key1, key2, strict, memo) && innerDeepEqual(item1, map.get(key2), strict, memo)) {
      set.delete(key2);
      return true;
    }
  }
  return false;
}
function mapEquiv(a, b, strict, memo) {
  var set = null;
  var aEntries = arrayFromMap(a);
  for (var i = 0; i < aEntries.length; i++) {
    var _aEntries$i = _slicedToArray(aEntries[i], 2),
      key = _aEntries$i[0],
      item1 = _aEntries$i[1];
    if (_typeof(key) === 'object' && key !== null) {
      if (set === null) {
        set = new Set();
      }
      set.add(key);
    } else {
      // By directly retrieving the value we prevent another b.has(key) check in
      // almost all possible cases.
      var item2 = b.get(key);
      if (item2 === undefined && !b.has(key) || !innerDeepEqual(item1, item2, strict, memo)) {
        if (strict) return false;
        // Fast path to detect missing string, symbol, undefined and null
        // keys.
        if (!mapMightHaveLoosePrim(a, b, key, item1, memo)) return false;
        if (set === null) {
          set = new Set();
        }
        set.add(key);
      }
    }
  }
  if (set !== null) {
    var bEntries = arrayFromMap(b);
    for (var _i2 = 0; _i2 < bEntries.length; _i2++) {
      var _bEntries$_i = _slicedToArray(bEntries[_i2], 2),
        _key = _bEntries$_i[0],
        item = _bEntries$_i[1];
      if (_typeof(_key) === 'object' && _key !== null) {
        if (!mapHasEqualEntry(set, a, _key, item, strict, memo)) return false;
      } else if (!strict && (!a.has(_key) || !innerDeepEqual(a.get(_key), item, false, memo)) && !mapHasEqualEntry(set, a, _key, item, false, memo)) {
        return false;
      }
    }
    return set.size === 0;
  }
  return true;
}
function objEquiv(a, b, strict, keys, memos, iterationType) {
  // Sets and maps don't have their entries accessible via normal object
  // properties.
  var i = 0;
  if (iterationType === kIsSet) {
    if (!setEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsMap) {
    if (!mapEquiv(a, b, strict, memos)) {
      return false;
    }
  } else if (iterationType === kIsArray) {
    for (; i < a.length; i++) {
      if (hasOwnProperty(a, i)) {
        if (!hasOwnProperty(b, i) || !innerDeepEqual(a[i], b[i], strict, memos)) {
          return false;
        }
      } else if (hasOwnProperty(b, i)) {
        return false;
      } else {
        // Array is sparse.
        var keysA = Object.keys(a);
        for (; i < keysA.length; i++) {
          var key = keysA[i];
          if (!hasOwnProperty(b, key) || !innerDeepEqual(a[key], b[key], strict, memos)) {
            return false;
          }
        }
        if (keysA.length !== Object.keys(b).length) {
          return false;
        }
        return true;
      }
    }
  }

  // The pair must have equivalent values for every corresponding key.
  // Possibly expensive deep test:
  for (i = 0; i < keys.length; i++) {
    var _key2 = keys[i];
    if (!innerDeepEqual(a[_key2], b[_key2], strict, memos)) {
      return false;
    }
  }
  return true;
}
function isDeepEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kLoose);
}
function isDeepStrictEqual(val1, val2) {
  return innerDeepEqual(val1, val2, kStrict);
}
module.exports = {
  isDeepEqual: isDeepEqual,
  isDeepStrictEqual: isDeepStrictEqual
};

/***/ }),
/* 71 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var define = __webpack_require__(72);
var callBind = __webpack_require__(51);

var implementation = __webpack_require__(68);
var getPolyfill = __webpack_require__(67);
var shim = __webpack_require__(73);

var polyfill = callBind(getPolyfill(), Object);

define(polyfill, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = polyfill;


/***/ }),
/* 72 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var keys = __webpack_require__(64);
var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

var toStr = Object.prototype.toString;
var concat = Array.prototype.concat;
var defineDataProperty = __webpack_require__(53);

var isFunction = function (fn) {
	return typeof fn === 'function' && toStr.call(fn) === '[object Function]';
};

var supportsDescriptors = __webpack_require__(54)();

var defineProperty = function (object, name, value, predicate) {
	if (name in object) {
		if (predicate === true) {
			if (object[name] === value) {
				return;
			}
		} else if (!isFunction(predicate) || !predicate()) {
			return;
		}
	}

	if (supportsDescriptors) {
		defineDataProperty(object, name, value, true);
	} else {
		defineDataProperty(object, name, value);
	}
};

var defineProperties = function (object, map) {
	var predicates = arguments.length > 2 ? arguments[2] : {};
	var props = keys(map);
	if (hasSymbols) {
		props = concat.call(props, Object.getOwnPropertySymbols(map));
	}
	for (var i = 0; i < props.length; i += 1) {
		defineProperty(object, props[i], map[props[i]], predicates[props[i]]);
	}
};

defineProperties.supportsDescriptors = !!supportsDescriptors;

module.exports = defineProperties;


/***/ }),
/* 73 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getPolyfill = __webpack_require__(67);
var define = __webpack_require__(72);

module.exports = function shimObjectIs() {
	var polyfill = getPolyfill();
	define(Object, { is: polyfill }, {
		is: function testObjectIs() {
			return Object.is !== polyfill;
		}
	});
	return polyfill;
};


/***/ }),
/* 74 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var callBind = __webpack_require__(51);
var define = __webpack_require__(72);

var implementation = __webpack_require__(75);
var getPolyfill = __webpack_require__(76);
var shim = __webpack_require__(77);

var polyfill = callBind(getPolyfill(), Number);

/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

define(polyfill, {
	getPolyfill: getPolyfill,
	implementation: implementation,
	shim: shim
});

module.exports = polyfill;


/***/ }),
/* 75 */
/***/ ((module) => {

"use strict";


/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

module.exports = function isNaN(value) {
	return value !== value;
};


/***/ }),
/* 76 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(75);

module.exports = function getPolyfill() {
	if (Number.isNaN && Number.isNaN(NaN) && !Number.isNaN('a')) {
		return Number.isNaN;
	}
	return implementation;
};


/***/ }),
/* 77 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var define = __webpack_require__(72);
var getPolyfill = __webpack_require__(76);

/* http://www.ecma-international.org/ecma-262/6.0/#sec-number.isnan */

module.exports = function shimNumberIsNaN() {
	var polyfill = getPolyfill();
	define(Number, { isNaN: polyfill }, {
		isNaN: function testIsNaN() {
			return Number.isNaN !== polyfill;
		}
	});
	return polyfill;
};


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/* provided dependency */ var console = __webpack_require__(2);
var Laya=window.Laya=function(t,e){var i={__internals:[],__packages:{},__classmap:{Object:Object,Function:Function,Array:Array,String:String},__sysClass:{object:"Object",array:"Array",string:"String",dictionary:"Dictionary"},__propun:{writable:!0,enumerable:!1,configurable:!0},__presubstr:String.prototype.substr,__substr:function(t,e){return 1==arguments.length?i.__presubstr.call(this,t):i.__presubstr.call(this,t,e>0?e:this.length+e)},__init:function(t){t.forEach(function(t){t.__init$&&t.__init$()})},__isClass:function(t){return t&&(t.__isclass||t==Object||t==String||t==Array)},__newvec:function(t,e){var i=[];i.length=t;for(var s=0;s<t;s++)i[s]=e;return i},__extend:function(t,e){for(var s in e)if(e.hasOwnProperty(s)){var n=Object.getOwnPropertyDescriptor(e,s),r=n.get,a=n.set;r||a?r&&a?Object.defineProperty(t,s,n):(r&&Object.defineProperty(t,s,r),a&&Object.defineProperty(t,s,a)):t[s]=e[s]}function __(){i.un(this,"constructor",t)}__.prototype=e.prototype,t.prototype=new __,i.un(t.prototype,"__imps",i.__copy({},e.prototype.__imps))},__copy:function(t,e){if(!e)return null;for(var i in t=t||{},e)t[i]=e[i];return t},__package:function(e,s){if(!i.__packages[e]){i.__packages[e]=!0;var n=t,r=e.split(".");if(r.length>1)for(var a=0,o=r.length-1;a<o;a++){var h=n[r[a]];n=h||(n[r[a]]={})}n[r[r.length-1]]||(n[r[r.length-1]]=s||{})}},__hasOwnProperty:function(t,e){return e=e||this,Object.hasOwnProperty.call(e,t)||function classHas(t,e){if(Object.hasOwnProperty.call(e.prototype,t))return!0;var i=e.prototype.__super;return null==i?null:classHas(t,i)}(t,e.__class)},__typeof:function(t,e){if(!t||!e)return!1;if(e===String)return"string"==typeof t;if(e===Number)return"number"==typeof t;if(e.__interface__)e=e.__interface__;else if("string"!=typeof e)return t instanceof e;return t.__imps&&t.__imps[e]||t.__class==e},__as:function(t,e){return this.__typeof(t,e)?t:null},__int:function(t){return t?parseInt(t):0},interface:function(e,s){i.__package(e,{});var n=i.__internals,r=n[e]=n[e]||{self:e};if(s){var a=s.split(",");r.extend=[];for(var o=0;o<a.length;o++){var h=a[o];n[h]=n[h]||{self:h},r.extend.push(n[h])}}var l=t,c=e.split(".");for(o=0;o<c.length-1;o++)l=l[c[o]];l[c[c.length-1]]={__interface__:e}},class:function(e,s,n,r){if(n&&i.__extend(e,n),s)if(i.__package(s,e),i.__classmap[s]=e,s.indexOf(".")>0){if(0==s.indexOf("laya.")){var a=s.split(".");r=r||a[a.length-1],i[r]&&console.log("Warning!,this class["+r+"] already exist:",i[r]),i[r]=e}}else"Main"==s?t.Main=e:(i[s]&&console.log("Error!,this class["+s+"] already exist:",i[s]),i[s]=e);var o=i.un,h=e.prototype;o(h,"hasOwnProperty",i.__hasOwnProperty),o(h,"__class",e),o(h,"__super",n),o(h,"__className",s),o(e,"__super",n),o(e,"__className",s),o(e,"__isclass",!0),o(e,"super",function(t){this.__super.call(t)})},imps:function(t,e){if(!e)return null;var s=t.__imps||i.un(t,"__imps",{});function __(t){var e,n;if((e=i.__internals[t])&&(s[t]=!0,n=e.extend))for(var r=0;r<n.length;r++)__(n[r].self)}for(var n in e)__(n)},superSet:function(t,e,i,s){var n=t.prototype["_$set_"+i];n&&n.call(e,s)},superGet:function(t,e,i){var s=t.prototype["_$get_"+i];return s?s.call(e):null},getset:function(t,e,s,n,r){t?(n&&(e["_$GET_"+s]=n),r&&(e["_$SET_"+s]=r)):(n&&i.un(e,"_$get_"+s,n),r&&i.un(e,"_$set_"+s,r)),n&&r?Object.defineProperty(e,s,{get:n,set:r,enumerable:!1,configurable:!0}):(n&&Object.defineProperty(e,s,{get:n,enumerable:!1,configurable:!0}),r&&Object.defineProperty(e,s,{set:r,enumerable:!1,configurable:!0}))},static:function(t,e){for(var i=0,s=e.length;i<s;i+=2)if("length"==e[i])t.length=e[i+1].call(t);else{function tmp(){var s=e[i],n=e[i+1];Object.defineProperty(t,s,{get:function(){return delete this[s],this[s]=n.call(this)},set:function(t){delete this[s],this[s]=t},enumerable:!0,configurable:!0})}tmp()}},un:function(t,e,s){return s||(s=t[e]),i.__propun.value=s,Object.defineProperty(t,e,i.__propun),s},uns:function(t,e){e.forEach(function(e){i.un(t,e)})}};return t.console=t.console||{log:function(){}},t.trace=t.console.log,Error.prototype.throwError=function(){throw arguments},Object.defineProperty(Array.prototype,"fixed",{enumerable:!1}),i}(window,document);!function(t,e,i){i.un,i.uns,i.static,i.class,i.getset,i.__newvec}(window,document,Laya),function(t,e,i){i.un,i.uns;var s=i.static,n=i.class,r=i.getset;i.__newvec;i.interface("laya.ui.IBox"),i.interface("laya.ui.IItem"),i.interface("laya.ui.ISelect"),i.interface("laya.ui.IRender"),i.interface("laya.filters.IFilter"),i.interface("laya.resource.IDispose"),i.interface("laya.resource.IDestroy"),i.interface("laya.resource.ICreateResource"),i.interface("laya.resource.ISingletonElement");r(1,i,"alertGlobalError",null,function(t){var e=0;P.window.onerror=t?function(t,i,s,n,r){e++<5&&r&&alert("出错啦，请把此信息截图给研发商\n"+t+"\n"+r.stack)}:null}),i.init=function(e,s,n){for(var r=[],a=2,o=arguments.length;a<o;a++)r.push(arguments[a]);if(!i._isinit){i._isinit=!0,ArrayBuffer.prototype.slice||(ArrayBuffer.prototype.slice=i._arrayBufferSlice),P.__init__(),xt.isConchApp||it.__init__(),i.systemTimer=new B(!1),i.startTimer=new B(!1),i.physicsTimer=new B(!1),i.updateTimer=new B(!1),i.lateTimer=new B(!1),i.timer=new B(!1),i.loader=new Bt,ct.__init__();for(var h=!1,l=(a=0,r.length);a<l;a++)r[a]&&r[a].enable&&(r[a].enable(),"WebGL"==typeof r[a]&&(h=!0));return xt.isConchApp&&(h||laya.webgl.WebGL.enable(),I.enableNative()),vt.beginCheck(),i._currentStage=i.stage=new jt,i._getUrlPath(),i.render=new xt(0,0),i.stage.size(e,s),t.stage=i.stage,Ct.__init__(),w.instance.__init__(i.stage,xt.canvas),xt.canvas}},i._getUrlPath=function(){var t=P.window.location,e=t.pathname;e=":"==e.charAt(2)?e.substring(1):e,v.rootPath=v.basePath=v.getPath("file:"==t.protocol?e:t.protocol+"//"+t.host+t.pathname)},i._arrayBufferSlice=function(t,e){var i=new Uint8Array(this,t,e-t),s=new Uint8Array(i.length);return s.set(i),s.buffer},i._runScript=function(t){return P.window[i._evcode](t)},i.enableDebugPanel=function(t){if(void 0===t&&(t="libs/laya.debugtool.js"),i.DebugPanel)i.DebugPanel.enable();else{var e=P.createElement("script");e.onload=function(){i.DebugPanel.enable()},e.src=t,P.document.body.appendChild(e)}},i.stage=null,i.systemTimer=null,i.startTimer=null,i.physicsTimer=null,i.updateTimer=null,i.lateTimer=null,i.timer=null,i.loader=null,i.version="2.0.0",i.render=null,i._currentStage=null,i._isinit=!1,i.isWXOpenDataContext=!1,i.isWXPosMsg=!1,s(i,["_evcode",function(){return this._evcode="eval"}]);var a=function(){function LayaGLQuickRunner(){}return n(LayaGLQuickRunner,"laya.renders.LayaGLQuickRunner"),LayaGLQuickRunner.__init__=function(){LayaGLQuickRunner.map[515]=LayaGLQuickRunner.alpha_transform_drawLayaGL,LayaGLQuickRunner.map[513]=LayaGLQuickRunner.alpha_drawLayaGL,LayaGLQuickRunner.map[514]=LayaGLQuickRunner.transform_drawLayaGL,LayaGLQuickRunner.map[8194]=LayaGLQuickRunner.transform_drawNodes,LayaGLQuickRunner.map[259]=LayaGLQuickRunner.alpha_transform_drawTexture,LayaGLQuickRunner.map[257]=LayaGLQuickRunner.alpha_drawTexture,LayaGLQuickRunner.map[258]=LayaGLQuickRunner.transform_drawTexture,LayaGLQuickRunner.map[8704]=LayaGLQuickRunner.drawLayaGL_drawNodes},LayaGLQuickRunner.transform_drawTexture=function(t,e,i,s){t._style;var n=t.texture;e.saveTransform(LayaGLQuickRunner.curMat),e.transformByMatrix(t.transform,i,s),e.drawTexture(n,-t.pivotX,-t.pivotY,t._width||n.width,t._height||n.height),e.restoreTransform(LayaGLQuickRunner.curMat)},LayaGLQuickRunner.alpha_drawTexture=function(t,e,i,s){var n,r=t._style,a=t.texture;if((n=r.alpha)>.01||t._needRepaint()){var o=e.globalAlpha;e.globalAlpha*=n,e.drawTexture(a,i-r.pivotX+a.offsetX,s-r.pivotY+a.offsetY,t._width||a.width,t._height||a.height),e.globalAlpha=o}},LayaGLQuickRunner.alpha_transform_drawTexture=function(t,e,i,s){var n,r=t._style,a=t.texture;if((n=r.alpha)>.01||t._needRepaint()){var o=e.globalAlpha;e.globalAlpha*=n,e.saveTransform(LayaGLQuickRunner.curMat),e.transformByMatrix(t.transform,i,s),e.drawTexture(a,-r.pivotX+a.offsetX,-r.pivotY+a.offsetY,t._width||a.width,t._height||a.height),e.restoreTransform(LayaGLQuickRunner.curMat),e.globalAlpha=o}},LayaGLQuickRunner.alpha_transform_drawLayaGL=function(t,e,i,s){var n,r=t._style;if((n=r.alpha)>.01||t._needRepaint()){var a=e.globalAlpha;e.globalAlpha*=n,e.saveTransform(LayaGLQuickRunner.curMat),e.transformByMatrix(t.transform,i,s),t._graphics&&t._graphics._render(t,e,-r.pivotX,-r.pivotY),e.restoreTransform(LayaGLQuickRunner.curMat),e.globalAlpha=a}},LayaGLQuickRunner.alpha_drawLayaGL=function(t,e,i,s){var n,r=t._style;if((n=r.alpha)>.01||t._needRepaint()){var a=e.globalAlpha;e.globalAlpha*=n,t._graphics&&t._graphics._render(t,e,i-r.pivotX,s-r.pivotY),e.globalAlpha=a}},LayaGLQuickRunner.transform_drawLayaGL=function(t,e,i,s){var n=t._style;e.saveTransform(LayaGLQuickRunner.curMat),e.transformByMatrix(t.transform,i,s),t._graphics&&t._graphics._render(t,e,-n.pivotX,-n.pivotY),e.restoreTransform(LayaGLQuickRunner.curMat)},LayaGLQuickRunner.transform_drawNodes=function(t,e,i,s){var n=t._getBit(256)&&e.drawCallOptimize(!0),r=t._style;e.saveTransform(LayaGLQuickRunner.curMat),e.transformByMatrix(t.transform,i,s),i=-r.pivotX,s=-r.pivotY;var a,o=t._children,h=o.length;if(r.viewport){var l=r.viewport,c=l.x,u=l.y,_=l.right,d=l.bottom,f=NaN,p=NaN;for(g=0;g<h;++g)(a=o[g])._visible&&(f=a._x)<_&&f+a.width>c&&(p=a._y)<d&&p+a.height>u&&a.render(e,i,s)}else for(var g=0;g<h;++g)(a=o[g])._visible&&a.render(e,i,s);e.restoreTransform(LayaGLQuickRunner.curMat),n&&e.drawCallOptimize(!1)},LayaGLQuickRunner.drawLayaGL_drawNodes=function(t,e,i,s){var n=t._getBit(256)&&e.drawCallOptimize(!0),r=t._style;i-=r.pivotX,s-=r.pivotY,t._graphics&&t._graphics._render(t,e,i,s);var a,o=t._children,h=o.length;if(r.viewport){var l=r.viewport,c=l.x,u=l.y,_=l.right,d=l.bottom,f=NaN,p=NaN;for(g=0;g<h;++g)(a=o[g])._visible&&(f=a._x)<_&&f+a.width>c&&(p=a._y)<d&&p+a.height>u&&a.render(e,i,s)}else for(var g=0;g<h;++g)(a=o[g])._visible&&a.render(e,i,s);n&&e.drawCallOptimize(!1)},LayaGLQuickRunner.map={},s(LayaGLQuickRunner,["curMat",function(){return this.curMat=new Z}]),LayaGLQuickRunner}(),o=function(){function ColorUtils(t){if(this.arrColor=[],null==t)return this.strColor="#00000000",this.numColor=0,void(this.arrColor=[0,0,0,0]);var e=0,i=0,s=0;if("string"==typeof t)if(t.indexOf("rgba(")>=0||t.indexOf("rgb(")>=0){var n,r,a=t;for(n=a.indexOf("("),r=a.indexOf(")"),a=a.substring(n+1,r),this.arrColor=a.split(","),i=this.arrColor.length,e=0;e<i;e++)this.arrColor[e]=parseFloat(this.arrColor[e]),e<3&&(this.arrColor[e]=Math.round(this.arrColor[e]));s=4==this.arrColor.length?256*(256*(256*this.arrColor[0]+this.arrColor[1])+this.arrColor[2])+Math.round(255*this.arrColor[3]):256*(256*this.arrColor[0]+this.arrColor[1])+this.arrColor[2],this.strColor=t}else{if(this.strColor=t,"#"===t.charAt(0)&&(t=t.substr(1)),3===(i=t.length)||4===i){var o="";for(e=0;e<i;e++)o+=t[e]+t[e];t=o}s=parseInt(t,16)}else s=t,this.strColor=_t.toHexColor(s);this.strColor.indexOf("rgba")>=0||9===this.strColor.length?(this.arrColor=[((4278190080&s)>>>24)/255,((16711680&s)>>16)/255,((65280&s)>>8)/255,(255&s)/255],this.numColor=(4278190080&s)>>>24|(16711680&s)>>8|(65280&s)<<8|(255&s)<<24):(this.arrColor=[((16711680&s)>>16)/255,((65280&s)>>8)/255,(255&s)/255,1],this.numColor=4278190080|(16711680&s)>>16|65280&s|(255&s)<<16),this.arrColor.__id=++ColorUtils._COLODID}return n(ColorUtils,"laya.utils.ColorUtils"),ColorUtils._initDefault=function(){for(var t in ColorUtils._DEFAULT={},ColorUtils._COLOR_MAP)ColorUtils._SAVE[t]=ColorUtils._DEFAULT[t]=new ColorUtils(ColorUtils._COLOR_MAP[t]);return ColorUtils._DEFAULT},ColorUtils._initSaveMap=function(){for(var t in ColorUtils._SAVE_SIZE=0,ColorUtils._SAVE={},ColorUtils._DEFAULT)ColorUtils._SAVE[t]=ColorUtils._DEFAULT[t]},ColorUtils.create=function(t){var e=t+"",i=ColorUtils._SAVE[e];return null!=i?i:(ColorUtils._SAVE_SIZE<1e3&&ColorUtils._initSaveMap(),ColorUtils._SAVE[e]=new ColorUtils(t))},ColorUtils._SAVE={},ColorUtils._SAVE_SIZE=0,ColorUtils._COLOR_MAP={purple:"#800080",orange:"#ffa500",white:"#FFFFFF",red:"#FF0000",green:"#00FF00",blue:"#0000FF",black:"#000000",yellow:"#FFFF00",gray:"#808080"},ColorUtils._DEFAULT=ColorUtils._initDefault(),ColorUtils._COLODID=1,ColorUtils}(),h=(function(){function Config(){}n(Config,"Config"),Config.animationInterval=50,Config.isAntialias=!1,Config.isAlpha=!1,Config.premultipliedAlpha=!0,Config.isStencil=!0,Config.preserveDrawingBuffer=!1,Config.webGL2D_MeshAllocMaxMem=!0,Config.is2DPixelArtGame=!1,Config.useWebGL2=!1}(),function(){var t;function EventDispatcher(){this._events=null}n(EventDispatcher,"laya.events.EventDispatcher");var e=EventDispatcher.prototype;return e.hasListener=function(t){return!!(this._events&&this._events[t])},e.event=function(t,e){if(!this._events||!this._events[t])return!1;var i=this._events[t];if(i.run)i.once&&delete this._events[t],null!=e?i.runWith(e):i.run();else{for(var s=0,n=i.length;s<n;s++){var r=i[s];r&&(null!=e?r.runWith(e):r.run()),r&&!r.once||(i.splice(s,1),s--,n--)}0===i.length&&this._events&&delete this._events[t]}return!0},e.on=function(t,e,i,s){return this._createListener(t,e,i,s,!1)},e.once=function(t,e,i,s){return this._createListener(t,e,i,s,!0)},e._createListener=function(e,i,s,n,r,a){void 0===a&&(a=!0),a&&this.off(e,i,s,r);var o=t.create(i||this,s,n,r);this._events||(this._events={});var h=this._events;return h[e]?h[e].run?h[e]=[h[e],o]:h[e].push(o):h[e]=o,this},e.off=function(t,e,i,s){if(void 0===s&&(s=!1),!this._events||!this._events[t])return this;var n=this._events[t];if(null!=n)if(n.run)e&&n.caller!==e||null!=i&&n.method!==i||s&&!n.once||(delete this._events[t],n.recover());else{for(var r=0,a=0,o=n.length;a<o;a++){var h=n[a];h?!h||e&&h.caller!==e||null!=i&&h.method!==i||s&&!h.once||(r++,n[a]=null,h.recover()):r++}r===o&&delete this._events[t]}return this},e.offAll=function(t){var e=this._events;if(!e)return this;if(t)this._recoverHandlers(e[t]),delete e[t];else{for(var i in e)this._recoverHandlers(e[i]);this._events=null}return this},e.offAllCaller=function(t){if(t&&this._events)for(var e in this._events)this.off(e,t,null);return this},e._recoverHandlers=function(t){if(t)if(t.run)t.recover();else for(var e=t.length-1;e>-1;e--)t[e]&&(t[e].recover(),t[e]=null)},e.isMouseEvent=function(t){return EventDispatcher.MOUSE_EVENTS[t]||!1},EventDispatcher.MOUSE_EVENTS={rightmousedown:!0,rightmouseup:!0,rightclick:!0,mousedown:!0,mouseup:!0,mousemove:!0,mouseover:!0,mouseout:!0,click:!0,doubleclick:!0},EventDispatcher.__init$=function(){Object.defineProperty(laya.events.EventDispatcher.prototype,"_events",{enumerable:!1,writable:!0}),t=function(t){function EventHandler(t,e,i,s){EventHandler.__super.call(this,t,e,i,s)}return n(EventHandler,"",l),EventHandler.prototype.recover=function(){this._id>0&&(this._id=0,EventHandler._pool.push(this.clear()))},EventHandler.create=function(t,e,i,s){return void 0===s&&(s=!0),EventHandler._pool.length?EventHandler._pool.pop().setTo(t,e,i,s):new EventHandler(t,e,i,s)},EventHandler._pool=[],EventHandler}()},EventDispatcher}()),l=function(){function Handler(t,e,i,s){this.once=!1,this._id=0,void 0===s&&(s=!1),this.setTo(t,e,i,s)}n(Handler,"laya.utils.Handler");var t=Handler.prototype;return t.setTo=function(t,e,i,s){return this._id=Handler._gid++,this.caller=t,this.method=e,this.args=i,this.once=s,this},t.run=function(){if(null==this.method)return null;var t=this._id,e=this.method.apply(this.caller,this.args);return this._id===t&&this.once&&this.recover(),e},t.runWith=function(t){if(null==this.method)return null;var e=this._id;if(null==t)var i=this.method.apply(this.caller,this.args);else i=this.args||t.unshift?this.args?this.method.apply(this.caller,this.args.concat(t)):this.method.apply(this.caller,t):this.method.call(this.caller,t);return this._id===e&&this.once&&this.recover(),i},t.clear=function(){return this.caller=null,this.method=null,this.args=null,this},t.recover=function(){this._id>0&&(this._id=0,Handler._pool.push(this.clear()))},Handler.create=function(t,e,i,s){return void 0===s&&(s=!0),Handler._pool.length?Handler._pool.pop().setTo(t,e,i,s):new Handler(t,e,i,s)},Handler._pool=[],Handler._gid=1,Handler}(),c=function(){function Filter(){this._action=null,this._glRender=null}n(Filter,"laya.filters.Filter");var t=Filter.prototype;return i.imps(t,{"laya.filters.IFilter":!0}),r(0,t,"type",function(){return-1}),Filter.BLUR=16,Filter.COLOR=32,Filter.GLOW=8,Filter._filter=null,Filter._recycleScope=null,Filter}(),u=function(){function TouchManager(){this.preOvers=[],this.preDowns=[],this.preRightDowns=[],this.enable=!0,this._lastClickTime=0,this._event=new L}n(TouchManager,"laya.events.TouchManager");var t=TouchManager.prototype;return t._clearTempArrs=function(){TouchManager._oldArr.length=0,TouchManager._newArr.length=0,TouchManager._tEleArr.length=0},t.getTouchFromArr=function(t,e){var i,s,n=0;for(i=e.length,n=0;n<i;n++)if((s=e[n]).id==t)return s;return null},t.removeTouchFromArr=function(t,e){var i=0;for(i=e.length-1;i>=0;i--)e[i].id==t&&e.splice(i,1)},t.createTouchO=function(t,e){var i;return(i=y.getItem("TouchData")||{}).id=e,i.tar=t,i},t.onMouseDown=function(t,e,i){var s,n,r,a;(void 0===i&&(i=!1),this.enable)&&(s=this.getTouchFromArr(e,this.preOvers),r=this.getEles(t,null,TouchManager._tEleArr),s?s.tar=t:(n=this.createTouchO(t,e),this.preOvers.push(n)),P.onMobile&&this.sendEvents(r,"mouseover"),a=i?this.preDowns:this.preRightDowns,(s=this.getTouchFromArr(e,a))?s.tar=t:(n=this.createTouchO(t,e),a.push(n)),this.sendEvents(r,i?"mousedown":"rightmousedown"),this._clearTempArrs())},t.sendEvents=function(t,e){var i,s,n,r=0;for(i=t.length,this._event._stoped=!1,s=t[0],r=0;r<i;r++){if((n=t[r]).destroyed)return;if(n.event(e,this._event.setTo(e,n,s)),this._event._stoped)break}},t.getEles=function(t,e,i){for(i?i.length=0:i=[];t&&t!=e;)i.push(t),t=t.parent;return i},t.checkMouseOutAndOverOfMove=function(t,e,i){if(void 0===i&&(i=0),e!=t){var s,n,r=0,a=0;if(e.contains(t))n=this.getEles(t,e,TouchManager._tEleArr),this.sendEvents(n,"mouseover");else if(t.contains(e))n=this.getEles(e,t,TouchManager._tEleArr),this.sendEvents(n,"mouseout");else{var o,h;(n=TouchManager._tEleArr).length=0,o=this.getEles(e,null,TouchManager._oldArr),h=this.getEles(t,null,TouchManager._newArr),a=o.length;var l=0;for(r=0;r<a;r++){if(s=o[r],(l=h.indexOf(s))>=0){h.splice(l,h.length-l);break}n.push(s)}n.length>0&&this.sendEvents(n,"mouseout"),h.length>0&&this.sendEvents(h,"mouseover")}}},t.onMouseMove=function(t,e){var i,s;this.enable&&((i=this.getTouchFromArr(e,this.preOvers))?(this.checkMouseOutAndOverOfMove(t,i.tar),i.tar=t,s=this.getEles(t,null,TouchManager._tEleArr)):(s=this.getEles(t,null,TouchManager._tEleArr),this.sendEvents(s,"mouseover"),this.preOvers.push(this.createTouchO(t,e))),this.sendEvents(s,"mousemove"),this._clearTempArrs())},t.getLastOvers=function(){return TouchManager._tEleArr.length=0,this.preOvers.length>0&&this.preOvers[0].tar?this.getEles(this.preOvers[0].tar,null,TouchManager._tEleArr):(TouchManager._tEleArr.push(i.stage),TouchManager._tEleArr)},t.stageMouseOut=function(){var t;t=this.getLastOvers(),this.preOvers.length=0,this.sendEvents(t,"mouseout")},t.onMouseUp=function(t,e,i){if(void 0===i&&(i=!1),this.enable){var s,n,r,a,o,h,l=0,c=0,u=P.onMobile;if(n=this.getEles(t,null,TouchManager._tEleArr),this.sendEvents(n,i?"mouseup":"rightmouseup"),h=i?this.preDowns:this.preRightDowns,s=this.getTouchFromArr(e,h)){var _,d=P.now();if(_=d-this._lastClickTime<300,this._lastClickTime=d,t==s.tar)o=n;else for(r=this.getEles(s.tar,null,TouchManager._oldArr),(o=TouchManager._newArr).length=0,c=r.length,l=0;l<c;l++)a=r[l],n.indexOf(a)>=0&&o.push(a);o.length>0&&this.sendEvents(o,i?"click":"rightclick"),i&&_&&this.sendEvents(o,"doubleclick"),this.removeTouchFromArr(e,h),s.tar=null,y.recover("TouchData",s)}else;(s=this.getTouchFromArr(e,this.preOvers))&&u&&((o=this.getEles(s.tar,null,o))&&o.length>0&&this.sendEvents(o,"mouseout"),this.removeTouchFromArr(e,this.preOvers),s.tar=null,y.recover("TouchData",s)),this._clearTempArrs()}},TouchManager._oldArr=[],TouchManager._newArr=[],TouchManager._tEleArr=[],s(TouchManager,["I",function(){return this.I=new TouchManager}]),TouchManager}(),_=function(){function Component(){this._id=_t.getGID(),this._resetComp()}n(Component,"laya.components.Component");var t=Component.prototype;return i.imps(t,{"laya.resource.ISingletonElement":!0,"laya.resource.IDestroy":!0}),t._isScript=function(){return!1},t._resetComp=function(){this._indexInList=-1,this._enabled=!0,this._awaked=!1,this.owner=null},t._getIndexInList=function(){return this._indexInList},t._setIndexInList=function(t){this._indexInList=t},t._onAdded=function(){},t._onAwake=function(){},t._onEnable=function(){},t._onDisable=function(){},t._onEnableInScene=function(){},t._onDisableInScene=function(){},t._onDestroy=function(){},t.onReset=function(){},t._parse=function(t){},t._cloneTo=function(t){},t._setActive=function(t){t?(this._awaked||(this._awaked=!0,this._onAwake()),this._enabled&&this._onEnable()):this._enabled&&this._onDisable()},t._setActiveInScene=function(t){t?this._onEnableInScene():this._onDisableInScene()},t.destroy=function(){this.owner&&this.owner._destroyComponent(this)},t._destroy=function(){this.owner.activeInHierarchy&&this._enabled&&(this._setActive(!1),this._isScript()&&this.onDisable()),this.owner._scene&&this._setActiveInScene(!1),this._onDestroy(),this._destroyed=!0,this.onReset!==laya.components.Component.prototype.onReset?(this.onReset(),this._resetComp(),y.recoverByClass(this)):this._resetComp()},r(0,t,"id",function(){return this._id}),r(0,t,"enabled",function(){return this._enabled},function(t){this._enabled=t,this.owner&&(t?this.owner.activeInHierarchy&&this._onEnable():this.owner.activeInHierarchy&&this._onDisable())}),r(0,t,"isSingleton",function(){return!0}),r(0,t,"destroyed",function(){return this._destroyed}),Component}(),d=function(){var t;function CallLater(){this._pool=[],this._map=[],this._laters=[]}n(CallLater,"laya.utils.CallLater");var e=CallLater.prototype;return e._update=function(){var t=this._laters,e=t.length;if(e>0){for(var i=0,s=e-1;i<=s;i++){var n=t[i];this._map[n.key]=null,null!==n.method&&(n.run(),n.clear()),this._pool.push(n),i===s&&(s=t.length-1)}t.length=0}},e._getHandler=function(t,e){var i=t?t.$_GID||(t.$_GID=_t.getGID()):0,s=e.$_TID||(e.$_TID=1e5*B._mid++);return this._map[i+s]},e.callLater=function(e,i,s){if(null==this._getHandler(e,i)){if(this._pool.length)var n=this._pool.pop();else n=new t;n.caller=e,n.method=i,n.args=s;var r=e?e.$_GID:0,a=i.$_TID;n.key=r+a,this._map[n.key]=n,this._laters.push(n)}},e.runCallLater=function(t,e){var i=this._getHandler(t,e);i&&null!=i.method&&(this._map[i.key]=null,i.run(),i.clear())},CallLater.I=new CallLater,CallLater.__init$=function(){t=function(){function LaterHandler(){this.key=0,this.caller=null,this.method=null,this.args=null}n(LaterHandler,"");var t=LaterHandler.prototype;return t.clear=function(){this.caller=null,this.method=null,this.args=null},t.run=function(){var t=this.caller;if(t&&t.destroyed)return this.clear();var e=this.method,i=this.args;null!=e&&(i?e.apply(t,i):e.call(t))},LaterHandler}()},CallLater}(),f=function(){function MiniLocalStorage(){}return n(MiniLocalStorage,"laya.wx.mini.MiniLocalStorage"),MiniLocalStorage.__init__=function(){MiniLocalStorage.items=MiniLocalStorage},MiniLocalStorage.setItem=function(t,e){try{wx.setStorageSync(t,e)}catch(i){wx.setStorage({key:t,data:e})}},MiniLocalStorage.getItem=function(t){return wx.getStorageSync(t)},MiniLocalStorage.setJSON=function(t,e){MiniLocalStorage.setItem(t,e)},MiniLocalStorage.getJSON=function(t){return MiniLocalStorage.getItem(t)},MiniLocalStorage.removeItem=function(t){wx.removeStorageSync(t)},MiniLocalStorage.clear=function(){wx.clearStorageSync()},MiniLocalStorage.getStorageInfoSync=function(){try{var t=wx.getStorageInfoSync();return console.log(t.keys),console.log(t.currentSize),console.log(t.limitSize),t}catch(t){}return null},MiniLocalStorage.support=!0,MiniLocalStorage.items=null,MiniLocalStorage}(),p=(function(){function HTMLChar(){this.reset()}n(HTMLChar,"laya.utils.HTMLChar");var t=HTMLChar.prototype;t.setData=function(t,e,i,s){return this.char=t,this.charNum=t.charCodeAt(0),this.x=this.y=0,this.width=e,this.height=i,this.style=s,this.isWord=!HTMLChar._isWordRegExp.test(t),this},t.reset=function(){return this.x=this.y=this.width=this.height=0,this.isWord=!1,this.char=null,this.charNum=0,this.style=null,this},t.recover=function(){y.recover("HTMLChar",this.reset())},t._isChar=function(){return!0},t._getCSSStyle=function(){return this.style},HTMLChar.create=function(){return y.getItemByClass("HTMLChar",HTMLChar)},HTMLChar._isWordRegExp=new RegExp("[\\w.]","")}(),function(){function DrawRectCmd(){}n(DrawRectCmd,"laya.display.cmd.DrawRectCmd");var t=DrawRectCmd.prototype;return t.recover=function(){this.fillColor=null,this.lineColor=null,y.recover("DrawRectCmd",this)},t.run=function(t,e,i){t.drawRect(this.x+e,this.y+i,this.width,this.height,this.fillColor,this.lineColor,this.lineWidth)},r(0,t,"cmdID",function(){return"DrawRect"}),DrawRectCmd.create=function(t,e,i,s,n,r,a){var o=y.getItemByClass("DrawRectCmd",DrawRectCmd);return o.x=t,o.y=e,o.width=i,o.height=s,o.fillColor=n,o.lineColor=r,o.lineWidth=a,o},DrawRectCmd.ID="DrawRect",DrawRectCmd}()),g=function(){function DrawCircleCmd(){}n(DrawCircleCmd,"laya.display.cmd.DrawCircleCmd");var t=DrawCircleCmd.prototype;return t.recover=function(){this.fillColor=null,this.lineColor=null,y.recover("DrawCircleCmd",this)},t.run=function(t,e,i){t._drawCircle(this.x+e,this.y+i,this.radius,this.fillColor,this.lineColor,this.lineWidth,this.vid)},r(0,t,"cmdID",function(){return"DrawCircle"}),DrawCircleCmd.create=function(t,e,i,s,n,r,a){var o=y.getItemByClass("DrawCircleCmd",DrawCircleCmd);return o.x=t,o.y=e,o.radius=i,o.fillColor=s,o.lineColor=n,o.lineWidth=r,o.vid=a,o},DrawCircleCmd.ID="DrawCircle",DrawCircleCmd}(),m=function(){function Styles(){}return n(Styles,"laya.ui.Styles"),Styles.labelColor="#000000",Styles.buttonStateNum=3,Styles.scrollBarMinNum=15,Styles.scrollBarDelayTime=500,s(Styles,["defaultSizeGrid",function(){return this.defaultSizeGrid=[4,4,4,4,0]},"labelPadding",function(){return this.labelPadding=[2,2,2,2]},"inputLabelPadding",function(){return this.inputLabelPadding=[1,1,1,3]},"buttonLabelColors",function(){return this.buttonLabelColors=["#32556b","#32cc6b","#ff0000","#C0C0C0"]},"comboBoxItemColors",function(){return this.comboBoxItemColors=["#5e95b6","#ffffff","#000000","#8fa4b1","#ffffff"]}]),Styles}(),v=function(){function URL(t){this._url=null,this._path=null,this._url=URL.formatURL(t),this._path=URL.getPath(t)}n(URL,"laya.net.URL");var t=URL.prototype;return r(0,t,"path",function(){return this._path}),r(0,t,"url",function(){return this._url}),URL.formatURL=function(t){if(!t)return"null path";if(t.indexOf(":")>0)return t;if(null!=URL.customFormat&&(t=URL.customFormat(t)),t.indexOf(":")>0)return t;var e=t.charAt(0);if("."===e)return URL._formatRelativePath(URL.basePath+t);if("~"===e)return URL.rootPath+t.substring(1);if("d"===e){if(0===t.indexOf("data:image"))return t}else if("/"===e)return t;return URL.basePath+t},URL._formatRelativePath=function(t){for(var e=t.split("/"),i=0,s=e.length;i<s;i++)".."==e[i]&&(e.splice(i-1,2),i-=2);return e.join("/")},URL.getPath=function(t){var e=t.lastIndexOf("/");return e>0?t.substr(0,e+1):""},URL.getFileName=function(t){var e=t.lastIndexOf("/");return e>0?t.substr(e+1):t},URL.getAdptedFilePath=function(t){if(!URL.exportSceneToJson||!t)return t;var e,i,s=0;for(e=URL._adpteTypeList.length,s=0;s<e;s++)i=URL._adpteTypeList[s],t=t.replace(i[0],i[1]);return t},URL.version={},URL.exportSceneToJson=!1,URL.basePath="",URL.rootPath="",URL.customFormat=function(t){var e=URL.version[t];return!xt.isConchApp&&e&&(t+="?v="+e),t},s(URL,["_adpteTypeList",function(){return this._adpteTypeList=[[".scene3d",".json"],[".scene",".json"],[".taa",".json"],[".prefab",".json"]]}]),URL}(),y=function(){function Pool(){}return n(Pool,"laya.utils.Pool"),Pool.getPoolBySign=function(t){return Pool._poolDic[t]||(Pool._poolDic[t]=[])},Pool.clearBySign=function(t){Pool._poolDic[t]&&(Pool._poolDic[t].length=0)},Pool.recover=function(t,e){e.__InPool||(e.__InPool=!0,Pool.getPoolBySign(t).push(e))},Pool.recoverByClass=function(t){if(t){var e=t.__className||t.constructor._$gid;e&&Pool.recover(e,t)}},Pool._getClassSign=function(t){var e=t.__className||t._$gid;return e||(t._$gid=e=_t.getGID()+""),e},Pool.createByClass=function(t){return Pool.getItemByClass(Pool._getClassSign(t),t)},Pool.getItemByClass=function(t,e){if(!Pool._poolDic[t])return new e;var i=Pool.getPoolBySign(t);if(i.length){var s=i.pop();s.__InPool=!1}else s=new e;return s},Pool.getItemByCreateFun=function(t,e,i){var s=Pool.getPoolBySign(t),n=s.length?s.pop():e.call(i);return n.__InPool=!1,n},Pool.getItem=function(t){var e=Pool.getPoolBySign(t),i=e.length?e.pop():null;return i&&(i.__InPool=!1),i},Pool.POOLSIGN="__InPool",Pool._poolDic={},Pool}(),C=(function(){function PoolCache(){this.sign=null,this.maxCount=1e3}n(PoolCache,"laya.utils.PoolCache");var t=PoolCache.prototype;t.getCacheList=function(){return y.getPoolBySign(this.sign)},t.tryDispose=function(t){var e;(e=y.getPoolBySign(this.sign)).length>this.maxCount&&e.splice(this.maxCount,e.length-this.maxCount)},PoolCache.addPoolCacheManager=function(t,e){var i;void 0===e&&(e=100),(i=new PoolCache).sign=t,i.maxCount=e,vt.regCacheByFunction(_t.bind(i.tryDispose,i),_t.bind(i.getCacheList,i))}}(),function(){function SpriteStyle(){this.reset()}n(SpriteStyle,"laya.display.css.SpriteStyle");var t=SpriteStyle.prototype;return t.reset=function(){return this.scaleX=this.scaleY=1,this.skewX=this.skewY=0,this.pivotX=this.pivotY=this.rotation=0,this.alpha=1,this.scrollRect&&this.scrollRect.recover(),this.scrollRect=null,this.viewport&&this.viewport.recover(),this.viewport=null,this.hitArea=null,this.dragging=null,this.blendMode=null,this},t.recover=function(){this!==SpriteStyle.EMPTY&&y.recover("SpriteStyle",this.reset())},SpriteStyle.create=function(){return y.getItemByClass("SpriteStyle",SpriteStyle)},SpriteStyle.EMPTY=new SpriteStyle,SpriteStyle}()),w=function(){function MouseManager(){this.mouseX=0,this.mouseY=0,this.disableMouseEvent=!1,this.mouseDownTime=0,this.mouseMoveAccuracy=2,this._stage=null,this._captureSp=null,this._captureExlusiveMode=!1,this._hitCaputreSp=!1,this._target=null,this._lastMoveTimer=0,this._isLeftMouse=!1,this._touchIDs={},this._id=1,this._tTouchID=0,this._event=new L,this._captureChain=[],this._matrix=new Z,this._point=new et,this._rect=new gt,this._prePoint=new et,this._curTouchID=NaN}n(MouseManager,"laya.events.MouseManager");var t=MouseManager.prototype;return t.__init__=function(t,e){var i=this;this._stage=t;var s=this;e.oncontextmenu=function(t){if(MouseManager.enabled)return!1},e.addEventListener("mousedown",function(t){MouseManager.enabled&&(P.onIE||t.preventDefault(),s.mouseDownTime=P.now(),i.runEvent(t))}),e.addEventListener("mouseup",function(t){MouseManager.enabled&&(t.preventDefault(),s.mouseDownTime=-P.now(),i.runEvent(t))},!0),e.addEventListener("mousemove",function(t){if(MouseManager.enabled){t.preventDefault();var e=P.now();if(e-s._lastMoveTimer<10)return;s._lastMoveTimer=e,i.runEvent(t)}},!0),e.addEventListener("mouseout",function(t){MouseManager.enabled&&i.runEvent(t)}),e.addEventListener("mouseover",function(t){MouseManager.enabled&&i.runEvent(t)}),e.addEventListener("touchstart",function(t){MouseManager.enabled&&(MouseManager._isFirstTouch||t.preventDefault(),s.mouseDownTime=P.now(),i.runEvent(t))}),e.addEventListener("touchend",function(t){MouseManager.enabled?(MouseManager._isFirstTouch||t.preventDefault(),MouseManager._isFirstTouch=!1,s.mouseDownTime=-P.now(),i.runEvent(t)):i._curTouchID=NaN},!0),e.addEventListener("touchmove",function(t){MouseManager.enabled&&(t.preventDefault(),i.runEvent(t))},!0),e.addEventListener("touchcancel",function(t){MouseManager.enabled?(t.preventDefault(),i.runEvent(t)):i._curTouchID=NaN},!0),e.addEventListener("mousewheel",function(t){MouseManager.enabled&&i.runEvent(t)}),e.addEventListener("DOMMouseScroll",function(t){MouseManager.enabled&&i.runEvent(t)})},t.initEvent=function(t,e){var i;this._event._stoped=!1,this._event.nativeEvent=e||t,this._target=null,this._point.setTo(t.pageX||t.clientX,t.pageY||t.clientY),this._stage._canvasTransform&&(this._stage._canvasTransform.invertTransformPoint(this._point),this.mouseX=this._point.x,this.mouseY=this._point.y),this._event.touchId=t.identifier||0,this._tTouchID=this._event.touchId,(i=u.I._event)._stoped=!1,i.nativeEvent=this._event.nativeEvent,i.touchId=this._event.touchId},t.checkMouseWheel=function(t){this._event.delta=t.wheelDelta?.025*t.wheelDelta:-t.detail;for(var e=u.I.getLastOvers(),i=0,s=e.length;i<s;i++){var n=e[i];n.event("mousewheel",this._event.setTo("mousewheel",n,this._target))}},t.onMouseMove=function(t){u.I.onMouseMove(t,this._tTouchID)},t.onMouseDown=function(t){i.stage.focus&&i.stage.focus.focus&&!i.stage.focus.contains(this._target)&&((i.stage.focus._tf||i.stage.focus).focus=!1);u.I.onMouseDown(t,this._tTouchID,this._isLeftMouse)},t.onMouseUp=function(t){u.I.onMouseUp(t,this._tTouchID,this._isLeftMouse)},t.check=function(t,e,i,s){this._point.setTo(e,i),t.fromParentPoint(this._point),e=this._point.x,i=this._point.y;var n=t._style.scrollRect;if(n&&(this._rect.setTo(n.x,n.y,n.width,n.height),!this._rect.contains(e,i)))return!1;if(!this.disableMouseEvent){if(t.hitTestPrior&&!t.mouseThrough&&!this.hitTest(t,e,i))return!1;for(var r=t._children.length-1;r>-1;r--){var a=t._children[r];if(!a.destroyed&&a._mouseState>1&&a._visible&&this.check(a,e,i,s))return!0}for(r=t._extUIChild.length-1;r>=0;r--){var o=t._extUIChild[r];if(!o.destroyed&&o._mouseState>1&&o._visible&&this.check(o,e,i,s))return!0}}var h=!(!t.hitTestPrior||t.mouseThrough||this.disableMouseEvent)||this.hitTest(t,e,i);return h?(this._target=t,s.call(this,t),this._target==this._hitCaputreSp&&(this._hitCaputreSp=!0)):s===this.onMouseUp&&t===this._stage&&(this._target=this._stage,s.call(this,this._target)),h},t.hitTest=function(t,e,i){var s=!1;t.scrollRect&&(e-=t._style.scrollRect.x,i-=t._style.scrollRect.y);var n=t._style.hitArea;return n&&n._hit?n.contains(e,i):((t.width>0&&t.height>0||t.mouseThrough||n)&&(s=t.mouseThrough?t.getGraphicBounds().contains(e,i):(n||this._rect.setTo(0,0,t.width,t.height)).contains(e,i)),s)},t._checkAllBaseUI=function(t,e,i){var s=this.handleExclusiveCapture(this.mouseX,this.mouseY,i);return!!s||(s=this.check(this._stage,this.mouseX,this.mouseY,i),this.handleCapture(this.mouseX,this.mouseY,i)||s)},t.check3DUI=function(t,e,i){for(var s=this._stage._3dUI,n=0,r=!1;n<s.length;n++){var a=s[n];this._stage._curUIBase=a,!a.destroyed&&a._mouseState>1&&a._visible&&(r=r||this.check(a,this.mouseX,this.mouseY,i))}return this._stage._curUIBase=this._stage,r},t.handleExclusiveCapture=function(t,e,i){if(this._captureExlusiveMode&&this._captureSp&&this._captureChain.length>0){var s;this._point.setTo(t,e);for(var n=0;n<this._captureChain.length;n++)(s=this._captureChain[n]).fromParentPoint(this._point);return this._target=s,i.call(this,s),!0}return!1},t.handleCapture=function(t,e,i){if(!this._hitCaputreSp&&this._captureSp&&this._captureChain.length>0){var s;this._point.setTo(t,e);for(var n=0;n<this._captureChain.length;n++)(s=this._captureChain[n]).fromParentPoint(this._point);return this._target=s,i.call(this,s),!0}return!1},t.runEvent=function(t){var e,i=0,s=0;switch("mousemove"!==t.type&&(this._prePoint.x=this._prePoint.y=-1e6),t.type){case"mousedown":this._touchIDs[0]=this._id++,MouseManager._isTouchRespond?MouseManager._isTouchRespond=!1:(this._isLeftMouse=0===t.button,this.initEvent(t),this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseDown));break;case"mouseup":this._isLeftMouse=0===t.button,this.initEvent(t),this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseUp);break;case"mousemove":Math.abs(this._prePoint.x-t.clientX)+Math.abs(this._prePoint.y-t.clientY)>=this.mouseMoveAccuracy&&(this._prePoint.x=t.clientX,this._prePoint.y=t.clientY,this.initEvent(t),this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseMove));break;case"touchstart":MouseManager._isTouchRespond=!0,this._isLeftMouse=!0;var n=t.changedTouches;for(i=0,s=n.length;i<s;i++)e=n[i],(MouseManager.multiTouchEnabled||isNaN(this._curTouchID))&&(this._curTouchID=e.identifier,this._id%200==0&&(this._touchIDs={}),this._touchIDs[e.identifier]=this._id++,this.initEvent(e,t),this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseDown));break;case"touchend":case"touchcancel":MouseManager._isTouchRespond=!0,this._isLeftMouse=!0;var r=t.changedTouches;for(i=0,s=r.length;i<s;i++)if(e=r[i],MouseManager.multiTouchEnabled||e.identifier==this._curTouchID){this._curTouchID=NaN,this.initEvent(e,t);this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseUp)||this.onMouseUp(null)}break;case"touchmove":var a=t.changedTouches;for(i=0,s=a.length;i<s;i++)e=a[i],(MouseManager.multiTouchEnabled||e.identifier==this._curTouchID)&&(this.initEvent(e,t),this._checkAllBaseUI(this.mouseX,this.mouseY,this.onMouseMove));break;case"wheel":case"mousewheel":case"DOMMouseScroll":this.checkMouseWheel(t);break;case"mouseout":u.I.stageMouseOut();break;case"mouseover":this._stage.event("mouseover",this._event.setTo("mouseover",this._stage,this._stage))}},t.setCapture=function(t,e){void 0===e&&(e=!1),this._captureSp=t,this._captureExlusiveMode=e,this._captureChain.length=0,this._captureChain.push(t);for(var s=t;s!=i.stage&&s!=i.stage._curUIBase&&(s=s.parent);)this._captureChain.splice(0,0,s)},t.releaseCapture=function(){console.log("release capture"),this._captureSp=null},MouseManager.enabled=!0,MouseManager.multiTouchEnabled=!0,MouseManager._isTouchRespond=!1,MouseManager._isFirstTouch=!0,s(MouseManager,["instance",function(){return this.instance=new MouseManager}]),MouseManager}(),S=function(){function TranslateCmd(){}n(TranslateCmd,"laya.display.cmd.TranslateCmd");var t=TranslateCmd.prototype;return t.recover=function(){y.recover("TranslateCmd",this)},t.run=function(t,e,i){t.translate(this.tx,this.ty)},r(0,t,"cmdID",function(){return"Translate"}),TranslateCmd.create=function(t,e){var i=y.getItemByClass("TranslateCmd",TranslateCmd);return i.tx=t,i.ty=e,i},TranslateCmd.ID="Translate",TranslateCmd}(),x=function(){function DrawLineCmd(){}n(DrawLineCmd,"laya.display.cmd.DrawLineCmd");var t=DrawLineCmd.prototype;return t.recover=function(){y.recover("DrawLineCmd",this)},t.run=function(t,e,i){t._drawLine(e,i,this.fromX,this.fromY,this.toX,this.toY,this.lineColor,this.lineWidth,this.vid)},r(0,t,"cmdID",function(){return"DrawLine"}),DrawLineCmd.create=function(t,e,i,s,n,r,a){var o=y.getItemByClass("DrawLineCmd",DrawLineCmd);return o.fromX=t,o.fromY=e,o.toX=i,o.toY=s,o.lineColor=n,o.lineWidth=r,o.vid=a,o},DrawLineCmd.ID="DrawLine",DrawLineCmd}(),T=function(){function DrawTexturesCmd(){}n(DrawTexturesCmd,"laya.display.cmd.DrawTexturesCmd");var t=DrawTexturesCmd.prototype;return t.recover=function(){this.texture._removeReference(),this.texture=null,this.pos=null,y.recover("DrawTexturesCmd",this)},t.run=function(t,e,i){t.drawTextures(this.texture,this.pos,e,i)},r(0,t,"cmdID",function(){return"DrawTextures"}),DrawTexturesCmd.create=function(t,e){var i=y.getItemByClass("DrawTexturesCmd",DrawTexturesCmd);return i.texture=t,t._addReference(),i.pos=e,i},DrawTexturesCmd.ID="DrawTextures",DrawTexturesCmd}(),M=function(){function ColorFilterAction(){this.data=null}n(ColorFilterAction,"laya.filters.ColorFilterAction");var t=ColorFilterAction.prototype;return t.apply=function(t){var e=t.canvas,i=e.context;if(0==e.width||0==e.height)return e;for(var s,n=i.getImageData(0,0,e.width,e.height),r=n.data,a=0,o=r.length;a<o;a+=4)s=this.getColor(r[a],r[a+1],r[a+2],r[a+3]),0!=r[a+3]&&(r[a]=s[0],r[a+1]=s[1],r[a+2]=s[2],r[a+3]=s[3]);return i.putImageData(n,0,0),t},t.getColor=function(t,e,i,s){var n=[];if(this.data._mat&&this.data._alpha){var r=this.data._mat,a=this.data._alpha;n[0]=r[0]*t+r[1]*e+r[2]*i+r[3]*s+a[0],n[1]=r[4]*t+r[5]*e+r[6]*i+r[7]*s+a[1],n[2]=r[8]*t+r[9]*e+r[10]*i+r[11]*s+a[2],n[3]=r[12]*t+r[13]*e+r[14]*i+r[15]*s+a[3]}return n},ColorFilterAction}(),b=(function(){function System(){}n(System,"laya.system.System"),System.changeDefinition=function(t,e){i[t]=e;var s=t+"=classObj";i._runScript(s)},System.__init__=function(){}}(),function(){function MiniAdpter(){}return n(MiniAdpter,"laya.wx.mini.MiniAdpter"),MiniAdpter.getJson=function(t){return JSON.parse(t)},MiniAdpter.enable=function(){MiniAdpter.init(i.isWXPosMsg,i.isWXOpenDataContext)},MiniAdpter.init=function(e,s){void 0===e&&(e=!1),void 0===s&&(s=!1),MiniAdpter._inited||(MiniAdpter._inited=!0,MiniAdpter.window=t,MiniAdpter.window.navigator.userAgent.indexOf("MiniGame")<0||(MiniAdpter.isZiYu=s,MiniAdpter.isPosMsgYu=e,MiniAdpter.EnvConfig={},MiniAdpter.isZiYu||(U.setNativeFileDir("/layaairGame"),U.existDir(U.fileNativeDir,l.create(MiniAdpter,MiniAdpter.onMkdirCallBack))),MiniAdpter.systemInfo=wx.getSystemInfoSync(),MiniAdpter.window.focus=function(){},i._getUrlPath=function(){},MiniAdpter.window.logtime=function(t){},MiniAdpter.window.alertTimeLog=function(t){},MiniAdpter.window.resetShareInfo=function(){},MiniAdpter.window.CanvasRenderingContext2D=function(){},MiniAdpter.window.CanvasRenderingContext2D.prototype=MiniAdpter.window.wx.createCanvas().getContext("2d").__proto__,MiniAdpter.window.document.body.appendChild=function(){},MiniAdpter.EnvConfig.pixelRatioInt=0,P._pixelRatio=MiniAdpter.pixelRatio(),MiniAdpter._preCreateElement=P.createElement,P.createElement=MiniAdpter.createElement,I.createShaderCondition=MiniAdpter.createShaderCondition,_t.parseXMLFromString=MiniAdpter.parseXMLFromString,MiniAdpter.EnvConfig.load=Ft.prototype.load,Ft.prototype.load=kt.prototype.load,Ft.prototype._loadImage=yt.prototype._loadImage,f.__init__(),MiniAdpter.window.wx.onMessage(MiniAdpter._onMessage)))},MiniAdpter._onMessage=function(t){switch(t.type){case"changeMatrix":i.stage.transform.identity(),i.stage._width=t.w,i.stage._height=t.h,i.stage._canvasTransform=new Z(t.a,t.b,t.c,t.d,t.tx,t.ty);break;case"display":i.stage.frameRate=t.rate||"fast";break;case"undisplay":i.stage.frameRate="sleep"}"opendatacontext"==t.isLoad?t.url&&(U.ziyuFileData[t.url]=t.atlasdata,U.ziyuFileTextureData[t.imgReadyUrl]=t.imgNativeUrl):"openJsondatacontext"==t.isLoad?t.url&&(U.ziyuFileData[t.url]=t.atlasdata):"openJsondatacontextPic"==t.isLoad&&(U.ziyuFileTextureData[t.imgReadyUrl]=t.imgNativeUrl)},MiniAdpter.getUrlEncode=function(t,e){return"arraybuffer"==e?"":"utf8"},MiniAdpter.downLoadFile=function(t,e,i,s){void 0===e&&(e=""),void 0===s&&(s="utf8"),U.getFileInfo(t)?null!=i&&i.runWith([0]):U.downLoadFile(t,e,i,s)},MiniAdpter.remove=function(t,e){U.deleteFile("",t,e,"",0)},MiniAdpter.removeAll=function(){U.deleteAll()},MiniAdpter.hasNativeFile=function(t){return U.isLocalNativeFile(t)},MiniAdpter.getFileInfo=function(t){return U.getFileInfo(t)},MiniAdpter.getFileList=function(){return U.filesListObj},MiniAdpter.exitMiniProgram=function(){MiniAdpter.window.wx.exitMiniProgram()},MiniAdpter.onMkdirCallBack=function(t,e){t||(U.filesListObj=JSON.parse(e.data))},MiniAdpter.pixelRatio=function(){if(!MiniAdpter.EnvConfig.pixelRatioInt)try{return MiniAdpter.EnvConfig.pixelRatioInt=MiniAdpter.systemInfo.pixelRatio,MiniAdpter.systemInfo.pixelRatio}catch(t){}return MiniAdpter.EnvConfig.pixelRatioInt},MiniAdpter.createElement=function(e){var i;if("canvas"==e)return 1==MiniAdpter.idx?MiniAdpter.isZiYu?(i=sharedCanvas).style={}:i=t.canvas:i=t.wx.createCanvas(),MiniAdpter.idx++,i;if("textarea"==e||"input"==e)return MiniAdpter.onCreateInput(e);if("div"==e){var s=MiniAdpter._preCreateElement(e);return s.contains=function(t){return null},s.removeChild=function(t){},s}return MiniAdpter._preCreateElement(e)},MiniAdpter.onCreateInput=function(t){var e=MiniAdpter._preCreateElement(t);return e.style={},e.value=0,e.parentElement={},e.placeholder={},e.type={},e.setColor=function(t){},e.setType=function(t){},e.setFontFace=function(t){},e.addEventListener=function(t){},e.contains=function(t){return null},e.removeChild=function(t){},e},MiniAdpter.createShaderCondition=function(t){var e=this;return function(){return e[t.replace("this.","")]}},MiniAdpter.sendAtlasToOpenDataContext=function(t){if(!laya.wx.mini.MiniAdpter.isZiYu){var e=Ft.getRes(v.formatURL(t));if(!e)throw"传递的url没有获取到对应的图集数据信息，请确保图集已经过！";e.meta.image.split(",");if(e.meta&&e.meta.image)for(var i=e.meta.image.split(","),s=t.indexOf("/")>=0?"/":"\\",n=t.lastIndexOf(s),r=n>=0?t.substr(0,n+1):"",a=0,o=i.length;a<o;a++)i[a]=r+i[a];else i=[t.replace(".json",".png")];for(a=0;a<i.length;a++){var h=i[a];MiniAdpter.postInfoToContext(t,h,e)}}},MiniAdpter.postInfoToContext=function(t,e,i){var s={frames:i.frames,meta:i.meta},n=e,r=U.getFileInfo(v.formatURL(e));if(r)var a=r.md5,o=U.getFileNativePath(a);else o=n;if(!o)throw"获取图集的磁盘url路径不存在！";wx.postMessage({url:t,atlasdata:s,imgNativeUrl:o,imgReadyUrl:n,isLoad:"opendatacontext"})},MiniAdpter.sendSinglePicToOpenDataContext=function(t){var e=v.formatURL(t),i=U.getFileInfo(e);if(i){var s=i.md5,n=U.getFileNativePath(s);t=e}else n=t;if(!n)throw"获取图集的磁盘url路径不存在！";wx.postMessage({url:t,imgNativeUrl:n,imgReadyUrl:t,isLoad:"openJsondatacontextPic"})},MiniAdpter.sendJsonDataToDataContext=function(t){if(!laya.wx.mini.MiniAdpter.isZiYu){var e=Ft.getRes(t);if(!e)throw"传递的url没有获取到对应的图集数据信息，请确保图集已经过！";wx.postMessage({url:t,atlasdata:e,isLoad:"openJsondatacontext"})}},MiniAdpter.EnvConfig=null,MiniAdpter.window=null,MiniAdpter._preCreateElement=null,MiniAdpter._inited=!1,MiniAdpter.systemInfo=null,MiniAdpter.isZiYu=!1,MiniAdpter.isPosMsgYu=!1,MiniAdpter.autoCacheFile=!0,MiniAdpter.minClearSize=5242880,MiniAdpter.subNativeFiles=null,MiniAdpter.subNativeheads=[],MiniAdpter.subMaps=[],MiniAdpter.AutoCacheDownFile=!1,MiniAdpter.parseXMLFromString=function(e){var i;e=e.replace(/>\s+</g,"><");try{i=(new t.Parser.DOMParser).parseFromString(e,"text/xml")}catch(t){throw"需要引入xml解析库文件"}return i},MiniAdpter.idx=1,s(MiniAdpter,["nativefiles",function(){return this.nativefiles=["layaNativeDir","wxlocal"]}]),MiniAdpter}()),L=function(){function Event(){}n(Event,"laya.events.Event");var t=Event.prototype;return t.setTo=function(t,e,i){return this.type=t,this.currentTarget=e,this.target=i,this},t.stopPropagation=function(){this._stoped=!0},r(0,t,"stageY",function(){return i.stage.mouseY}),r(0,t,"charCode",function(){return this.nativeEvent.charCode}),r(0,t,"touches",function(){if(!this.nativeEvent)return null;var t=this.nativeEvent.touches;if(t)for(var e=i.stage,s=0,n=t.length;s<n;s++){var r=t[s],a=et.TEMP;a.setTo(r.clientX,r.clientY),e._canvasTransform.invertTransformPoint(a),e.transform.invertTransformPoint(a),r.stageX=a.x,r.stageY=a.y}return t}),r(0,t,"keyLocation",function(){return this.nativeEvent.location||this.nativeEvent.keyLocation}),r(0,t,"ctrlKey",function(){return this.nativeEvent.ctrlKey}),r(0,t,"altKey",function(){return this.nativeEvent.altKey}),r(0,t,"shiftKey",function(){return this.nativeEvent.shiftKey}),r(0,t,"stageX",function(){return i.stage.mouseX}),Event.EMPTY=new Event,Event.MOUSE_DOWN="mousedown",Event.MOUSE_UP="mouseup",Event.CLICK="click",Event.RIGHT_MOUSE_DOWN="rightmousedown",Event.RIGHT_MOUSE_UP="rightmouseup",Event.RIGHT_CLICK="rightclick",Event.MOUSE_MOVE="mousemove",Event.MOUSE_OVER="mouseover",Event.MOUSE_OUT="mouseout",Event.MOUSE_WHEEL="mousewheel",Event.ROLL_OVER="mouseover",Event.ROLL_OUT="mouseout",Event.DOUBLE_CLICK="doubleclick",Event.CHANGE="change",Event.CHANGED="changed",Event.RESIZE="resize",Event.ADDED="added",Event.REMOVED="removed",Event.DISPLAY="display",Event.UNDISPLAY="undisplay",Event.ERROR="error",Event.COMPLETE="complete",Event.LOADED="loaded",Event.READY="ready",Event.PROGRESS="progress",Event.INPUT="input",Event.RENDER="render",Event.OPEN="open",Event.MESSAGE="message",Event.CLOSE="close",Event.KEY_DOWN="keydown",Event.KEY_PRESS="keypress",Event.KEY_UP="keyup",Event.FRAME="enterframe",Event.DRAG_START="dragstart",Event.DRAG_MOVE="dragmove",Event.DRAG_END="dragend",Event.ENTER="enter",Event.SELECT="select",Event.BLUR="blur",Event.FOCUS="focus",Event.VISIBILITY_CHANGE="visibilitychange",Event.FOCUS_CHANGE="focuschange",Event.PLAYED="played",Event.PAUSED="paused",Event.STOPPED="stopped",Event.START="start",Event.END="end",Event.COMPONENT_ADDED="componentadded",Event.COMPONENT_REMOVED="componentremoved",Event.RELEASED="released",Event.LINK="link",Event.LABEL="label",Event.FULL_SCREEN_CHANGE="fullscreenchange",Event.DEVICE_LOST="devicelost",Event.TRANSFORM_CHANGED="transformchanged",Event.ANIMATION_CHANGED="animationchanged",Event.TRAIL_FILTER_CHANGE="trailfilterchange",Event.TRIGGER_ENTER="triggerenter",Event.TRIGGER_STAY="triggerstay",Event.TRIGGER_EXIT="triggerexit",Event}(),I=function(){function RunDriver(){}return n(RunDriver,"laya.utils.RunDriver"),RunDriver.getIncludeStr=function(t){return null},RunDriver.createShaderCondition=function(t){var e="(function() {return "+t+";})";return i._runScript(e)},RunDriver.fontMap=[],RunDriver.measureText=function(t,e){var i=RunDriver.hanzi.test(t);if(i&&RunDriver.fontMap[e])return RunDriver.fontMap[e];var s=P.context;s.font=e;var n=s.measureText(t);return i&&(RunDriver.fontMap[e]=n),n},RunDriver.drawToCanvas=function(t,e,i,s,n,r){i|=0,s|=0,n|=0,r|=0;var a=new $t,o=a.getContext("2d");return a.size(i,s),Ct.renders[e]._fun(t,o,n,r),a},RunDriver.initRender=function(t,e,i){return xt._context=t.getContext("2d"),t.size(e,i),!0},RunDriver.createParticleTemplate2D=null,RunDriver.changeWebGLSize=function(t,e){},RunDriver.createRenderSprite=function(t,e){return new Ct(t,e)},RunDriver.clear=function(t){xt.isConchApp||xt._context.clear()},RunDriver.getTexturePixels=function(t,e,i,s,n){return null},RunDriver.skinAniSprite=function(){return null},RunDriver.cancelLoadByUrl=function(t){},RunDriver.enableNative=null,s(RunDriver,["hanzi",function(){return this.hanzi=new RegExp("^[一-龥]$")}]),RunDriver}(),R=function(){function Tween(){this.gid=0,this.repeat=1,this._count=0}n(Tween,"laya.utils.Tween");var t=Tween.prototype;return t.to=function(t,e,i,s,n,r,a){return void 0===r&&(r=0),void 0===a&&(a=!1),this._create(t,e,i,s,n,r,a,!0,!1,!0)},t.from=function(t,e,i,s,n,r,a){return void 0===r&&(r=0),void 0===a&&(a=!1),this._create(t,e,i,s,n,r,a,!1,!1,!0)},t._create=function(t,e,s,n,r,a,o,h,l,c){if(!t)throw new Error("Tween:target is null");this._target=t,this._duration=s,this._ease=n||e.ease||Tween.easeNone,this._complete=r||e.complete,this._delay=a,this._props=[],this._usedTimer=0,this._startTimer=P.now(),this._usedPool=l,this._delayParam=null,this.update=e.update;var u=t.$_GID||(t.$_GID=_t.getGID());return Tween.tweenMap[u]?(o&&Tween.clearTween(t),Tween.tweenMap[u].push(this)):Tween.tweenMap[u]=[this],c?a<=0?this.firstStart(t,e,h):(this._delayParam=[t,e,h],i.timer.once(a,this,this.firstStart,this._delayParam)):this._initProps(t,e,h),this},t.firstStart=function(t,e,i){this._delayParam=null,t.destroyed?this.clear():(this._initProps(t,e,i),this._beginLoop())},t._initProps=function(t,e,i){for(var s in e)if("number"==typeof t[s]){var n=i?t[s]:e[s],r=i?e[s]:t[s];this._props.push([s,n,r-n]),i||(t[s]=n)}},t._beginLoop=function(){i.timer.frameLoop(1,this,this._doEase)},t._doEase=function(){this._updateEase(P.now())},t._updateEase=function(t){var e=this._target;if(e){if(e.destroyed)return Tween.clearTween(e);var i=this._usedTimer=t-this._startTimer-this._delay;if(!(i<0)){if(i>=this._duration)return this.complete();for(var s=i>0?this._ease(i,0,1,this._duration):0,n=this._props,r=0,a=n.length;r<a;r++){var o=n[r];e[o[0]]=o[1]+s*o[2]}this.update&&this.update.run()}}},t.complete=function(){if(this._target){i.timer.runTimer(this,this.firstStart);for(var t=this._target,e=this._props,s=this._complete,n=0,r=e.length;n<r;n++){var a=e[n];t[a[0]]=a[1]+a[2]}this.update&&this.update.run(),this._count++,0!=this.repeat&&this._count>=this.repeat?(this.clear(),s&&s.run()):this.restart()}},t.pause=function(){i.timer.clear(this,this._beginLoop),i.timer.clear(this,this._doEase),i.timer.clear(this,this.firstStart);var t;(t=P.now()-this._startTimer-this._delay)<0&&(this._usedTimer=t)},t.setStartTime=function(t){this._startTimer=t},t.clear=function(){this._target&&(this._remove(),this._clear())},t._clear=function(){this.pause(),i.timer.clear(this,this.firstStart),this._complete=null,this._target=null,this._ease=null,this._props=null,this._delayParam=null,this._usedPool&&(this.update=null,y.recover("tween",this))},t.recover=function(){this._usedPool=!0,this._clear()},t._remove=function(){var t=Tween.tweenMap[this._target.$_GID];if(t)for(var e=0,i=t.length;e<i;e++)if(t[e]===this){t.splice(e,1);break}},t.restart=function(){if(this.pause(),this._usedTimer=0,this._startTimer=P.now(),this._delayParam)i.timer.once(this._delay,this,this.firstStart,this._delayParam);else{for(var t=this._props,e=0,s=t.length;e<s;e++){var n=t[e];this._target[n[0]]=n[1]}i.timer.once(this._delay,this,this._beginLoop)}},t.resume=function(){this._usedTimer>=this._duration||(this._startTimer=P.now()-this._usedTimer-this._delay,this._delayParam?this._usedTimer<0?i.timer.once(-this._usedTimer,this,this.firstStart,this._delayParam):this.firstStart.apply(this,this._delayParam):this._beginLoop())},r(0,t,"progress",null,function(t){var e=t*this._duration;this._startTimer=P.now()-this._delay-e}),Tween.to=function(t,e,i,s,n,r,a,o){return void 0===r&&(r=0),void 0===a&&(a=!1),void 0===o&&(o=!0),y.getItemByClass("tween",Tween)._create(t,e,i,s,n,r,a,!0,o,!0)},Tween.from=function(t,e,i,s,n,r,a,o){return void 0===r&&(r=0),void 0===a&&(a=!1),void 0===o&&(o=!0),y.getItemByClass("tween",Tween)._create(t,e,i,s,n,r,a,!1,o,!0)},Tween.clearAll=function(t){if(t&&t.$_GID){var e=Tween.tweenMap[t.$_GID];if(e){for(var i=0,s=e.length;i<s;i++)e[i]._clear();e.length=0}}},Tween.clear=function(t){t.clear()},Tween.clearTween=function(t){Tween.clearAll(t)},Tween.easeNone=function(t,e,i,s){return i*t/s+e},Tween.tweenMap=[],Tween}(),P=function(){function Browser(){}return n(Browser,"laya.utils.Browser"),r(1,Browser,"pixelRatio",function(){if(Browser._pixelRatio<0)if(Browser.__init__(),Browser.userAgent.indexOf("Mozilla/6.0(Linux; Android 6.0; HUAWEI NXT-AL10 Build/HUAWEINXT-AL10)")>-1)Browser._pixelRatio=2;else{var t=Browser.context,e=t.backingStorePixelRatio||t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1;Browser._pixelRatio=(Browser._window.devicePixelRatio||1)/e,Browser._pixelRatio<1&&(Browser._pixelRatio=1)}return Browser._pixelRatio}),r(1,Browser,"height",function(){return Browser.__init__(),(i.stage&&i.stage.canvasRotation?Browser.clientWidth:Browser.clientHeight)*Browser.pixelRatio}),r(1,Browser,"clientWidth",function(){return Browser.__init__(),Browser._window.innerWidth||Browser._document.body.clientWidth}),r(1,Browser,"window",function(){return Browser._window||Browser.__init__()}),r(1,Browser,"clientHeight",function(){return Browser.__init__(),Browser._window.innerHeight||Browser._document.body.clientHeight||Browser._document.documentElement.clientHeight}),r(1,Browser,"width",function(){return Browser.__init__(),(i.stage&&i.stage.canvasRotation?Browser.clientHeight:Browser.clientWidth)*Browser.pixelRatio}),r(1,Browser,"container",function(){return Browser._container||(Browser.__init__(),Browser._container=Browser.createElement("div"),Browser._container.id="layaContainer",Browser._document.body.appendChild(Browser._container)),Browser._container},function(t){Browser._container=t}),r(1,Browser,"document",function(){return Browser.__init__(),Browser._document}),Browser.__init__=function(){if(Browser._window)return Browser._window;var e=Browser._window=t,s=Browser._document=e.document,n=Browser.userAgent=e.navigator.userAgent,r=e._layalibs;if(r){r.sort(function(t,e){return t.i>e.i});for(var a=0;a<r.length;a++)r[a].f(e,s,i)}n.indexOf("MiniGame")>-1&&(i.MiniAdpter?i.MiniAdpter.enable():console.error("请先添加小游戏适配库,详细教程：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0")),n.indexOf("SwanGame")>-1&&(i.BMiniAdapter?i.BMiniAdapter.enable():console.error("请先添加百度小游戏适配库,详细教程：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0")),e.trace=console.log,e.requestAnimationFrame=e.requestAnimationFrame||e.webkitRequestAnimationFrame||e.mozRequestAnimationFrame||e.oRequestAnimationFrame||e.msRequestAnimationFrame||function(t){return e.setTimeout(t,1e3/60)};var o=s.body.style;o.margin=0,o.overflow="hidden",o["-webkit-user-select"]="none",o["-webkit-tap-highlight-color"]="rgba(200,200,200,0)";for(var h=s.getElementsByTagName("meta"),l=0,c=!1,u="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no";l<h.length;){var _=h[l];if("viewport"==_.name){_.content=u,c=!0;break}l++}c||((_=s.createElement("meta")).name="viewport",_.content=u,s.getElementsByTagName("head")[0].appendChild(_)),Browser.onMobile=n.indexOf("Mobile")>-1,Browser.onIOS=!!n.match(/\(i[^;]+;(U;)? CPU.+Mac OS X/),Browser.onIPhone=n.indexOf("iPhone")>-1,Browser.onMac=n.indexOf("Mac OS X")>-1,Browser.onIPad=n.indexOf("iPad")>-1,Browser.onAndroid=n.indexOf("Android")>-1||n.indexOf("Adr")>-1,Browser.onWP=n.indexOf("Windows Phone")>-1,Browser.onQQBrowser=n.indexOf("QQBrowser")>-1,Browser.onMQQBrowser=n.indexOf("MQQBrowser")>-1||n.indexOf("Mobile")>-1&&n.indexOf("QQ")>-1,Browser.onIE=!!e.ActiveXObject||"ActiveXObject"in e,Browser.onWeiXin=n.indexOf("MicroMessenger")>-1,Browser.onSafari=n.indexOf("Safari")>-1,Browser.onPC=!Browser.onMobile,Browser.onMiniGame=n.indexOf("MiniGame")>-1,Browser.onBDMiniGame=n.indexOf("SwanGame")>-1,Browser.onLimixiu=n.indexOf("limixiu")>-1,xt._mainCanvas=new $t(!0);var d=xt._mainCanvas.source.style;return d.position="absolute",d.top=d.left="0px",d.background="#000000",Browser.canvas=new $t(!0),Browser.context=Browser.canvas.getContext("2d"),e},Browser.createElement=function(t){return Browser.__init__(),Browser._document.createElement(t)},Browser.getElementById=function(t){return Browser.__init__(),Browser._document.getElementById(t)},Browser.removeElement=function(t){t&&t.parentNode&&t.parentNode.removeChild(t)},Browser.now=function(){return Date.now()},Browser.userAgent=null,Browser.onMobile=!1,Browser.onIOS=!1,Browser.onMac=!1,Browser.onIPhone=!1,Browser.onIPad=!1,Browser.onAndroid=!1,Browser.onWP=!1,Browser.onQQBrowser=!1,Browser.onMQQBrowser=!1,Browser.onSafari=!1,Browser.onIE=!1,Browser.onWeiXin=!1,Browser.onPC=!1,Browser.onMiniGame=!1,Browser.onBDMiniGame=!1,Browser.onLimixiu=!1,Browser.onFirefox=!1,Browser.onEdge=!1,Browser.supportWebAudio=!1,Browser.supportLocalStorage=!1,Browser.canvas=null,Browser.context=null,Browser._window=null,Browser._document=null,Browser._container=null,Browser._pixelRatio=-1,Browser._supportWebGL=!1,Browser}(),D=function(){function DrawPathCmd(){}n(DrawPathCmd,"laya.display.cmd.DrawPathCmd");var t=DrawPathCmd.prototype;return t.recover=function(){this.paths=null,this.brush=null,this.pen=null,y.recover("DrawPathCmd",this)},t.run=function(t,e,i){t._drawPath(this.x+e,this.y+i,this.paths,this.brush,this.pen)},r(0,t,"cmdID",function(){return"DrawPath"}),DrawPathCmd.create=function(t,e,i,s,n){var r=y.getItemByClass("DrawPathCmd",DrawPathCmd);return r.x=t,r.y=e,r.paths=i,r.brush=s,r.pen=n,r},DrawPathCmd.ID="DrawPath",DrawPathCmd}(),B=function(){var t;function Timer(t){this.scale=1,this.currFrame=0,this._delta=0,this._map=[],this._handlers=[],this._temp=[],this._count=0,this.currTimer=P.now(),this._lastTimer=P.now(),void 0===t&&(t=!0),t&&i.systemTimer&&i.systemTimer.frameLoop(1,this,this._update)}n(Timer,"laya.utils.Timer");var e=Timer.prototype;return e._update=function(){if(this.scale<=0)this._lastTimer=P.now();else{var t=this.currFrame=this.currFrame+this.scale,e=P.now();this._delta=(e-this._lastTimer)*this.scale;var i=this.currTimer=this.currTimer+this._delta;this._lastTimer=e;var s=this._handlers;this._count=0;for(var n=0,r=s.length;n<r;n++){var a=s[n];if(null!==a.method){var o=a.userFrame?t:i;if(o>=a.exeTime)if(a.repeat)if(a.jumpFrame)for(;o>=a.exeTime;)a.exeTime+=a.delay,a.run(!1);else a.exeTime+=a.delay,a.run(!1),o>a.exeTime&&(a.exeTime+=Math.ceil((o-a.exeTime)/a.delay)*a.delay);else a.run(!0)}else this._count++}(this._count>30||t%200==0)&&this._clearHandlers()}},e._clearHandlers=function(){for(var t=this._handlers,e=0,i=t.length;e<i;e++){var s=t[e];null!==s.method?this._temp.push(s):this._recoverHandler(s)}this._handlers=this._temp,t.length=0,this._temp=t},e._recoverHandler=function(t){this._map[t.key]==t&&(this._map[t.key]=null),t.clear(),Timer._pool.push(t)},e._create=function(e,i,s,n,r,a,o){if(!s)return r.apply(n,a),null;if(o){var h=this._getHandler(n,r);if(h)return h.repeat=i,h.userFrame=e,h.delay=s,h.caller=n,h.method=r,h.args=a,h.exeTime=s+(e?this.currFrame:this.currTimer+P.now()-this._lastTimer),h}return(h=Timer._pool.length>0?Timer._pool.pop():new t).repeat=i,h.userFrame=e,h.delay=s,h.caller=n,h.method=r,h.args=a,h.exeTime=s+(e?this.currFrame:this.currTimer+P.now()-this._lastTimer),this._indexHandler(h),this._handlers.push(h),h},e._indexHandler=function(t){var e=t.caller,i=t.method,s=e?e.$_GID||(e.$_GID=_t.getGID()):0,n=i.$_TID||(i.$_TID=1e5*Timer._mid++);t.key=s+n,this._map[t.key]=t},e.once=function(t,e,i,s,n){void 0===n&&(n=!0),this._create(!1,!1,t,e,i,s,n)},e.loop=function(t,e,i,s,n,r){void 0===n&&(n=!0),void 0===r&&(r=!1);var a=this._create(!1,!0,t,e,i,s,n);a&&(a.jumpFrame=r)},e.frameOnce=function(t,e,i,s,n){void 0===n&&(n=!0),this._create(!0,!1,t,e,i,s,n)},e.frameLoop=function(t,e,i,s,n){void 0===n&&(n=!0),this._create(!0,!0,t,e,i,s,n)},e.toString=function(){return" handlers:"+this._handlers.length+" pool:"+Timer._pool.length},e.clear=function(t,e){var i=this._getHandler(t,e);i&&(this._map[i.key]=null,i.key=0,i.clear())},e.clearAll=function(t){if(t)for(var e=0,i=this._handlers.length;e<i;e++){var s=this._handlers[e];s.caller===t&&(this._map[s.key]=null,s.key=0,s.clear())}},e._getHandler=function(t,e){var i=t?t.$_GID||(t.$_GID=_t.getGID()):0,s=e.$_TID||(e.$_TID=1e5*Timer._mid++);return this._map[i+s]},e.callLater=function(t,e,i){d.I.callLater(t,e,i)},e.runCallLater=function(t,e){d.I.runCallLater(t,e)},e.runTimer=function(t,e){var i=this._getHandler(t,e);i&&null!=i.method&&(this._map[i.key]=null,i.run(!0))},e.pause=function(){this.scale=0},e.resume=function(){this.scale=1},r(0,e,"delta",function(){return this._delta}),Timer._pool=[],Timer._mid=1,Timer.__init$=function(){t=function(){function TimerHandler(){this.key=0,this.repeat=!1,this.delay=0,this.userFrame=!1,this.exeTime=0,this.caller=null,this.method=null,this.args=null,this.jumpFrame=!1}n(TimerHandler,"");var t=TimerHandler.prototype;return t.clear=function(){this.caller=null,this.method=null,this.args=null},t.run=function(t){var e=this.caller;if(e&&e.destroyed)return this.clear();var i=this.method,s=this.args;t&&this.clear(),null!=i&&(s?i.apply(e,s):i.call(e))},TimerHandler}()},Timer}(),A=function(){function FillBorderTextCmd(){}n(FillBorderTextCmd,"laya.display.cmd.FillBorderTextCmd");var t=FillBorderTextCmd.prototype;return t.recover=function(){y.recover("FillBorderTextCmd",this)},t.run=function(t,e,i){t.fillBorderText(this.text,this.x+e,this.y+i,this.font,this.fillColor,this.borderColor,this.lineWidth,this.textAlign)},r(0,t,"cmdID",function(){return"FillBorderText"}),FillBorderTextCmd.create=function(t,e,i,s,n,r,a,o){var h=y.getItemByClass("FillBorderTextCmd",FillBorderTextCmd);return h.text=t,h.x=e,h.y=i,h.font=s,h.fillColor=n,h.borderColor=r,h.lineWidth=a,h.textAlign=o,h},FillBorderTextCmd.ID="FillBorderText",FillBorderTextCmd}(),E=(function(){function DrawParticleCmd(){}n(DrawParticleCmd,"laya.display.cmd.DrawParticleCmd");var t=DrawParticleCmd.prototype;t.recover=function(){this._templ=null,y.recover("DrawParticleCmd",this)},t.run=function(t,e,i){t.drawParticle(e,i,this._templ)},r(0,t,"cmdID",function(){return"DrawParticleCmd"}),DrawParticleCmd.create=function(t){var e=y.getItemByClass("DrawParticleCmd",DrawParticleCmd);return e._templ=t,e},DrawParticleCmd.ID="DrawParticleCmd"}(),function(){function FontInfo(t){this._font="14px Arial",this._family="Arial",this._size=14,this._italic=!1,this._bold=!1,this._id=FontInfo._gfontID++,this.setFont(t||this._font)}return n(FontInfo,"laya.utils.FontInfo"),FontInfo.prototype.setFont=function(t){this._font=t;var e=t.split(" "),i=e.length;if(i<2)1==i&&e[0].indexOf("px")>0&&(this._size=parseInt(e[0]));else{for(var s=-1,n=0;n<i;n++)if(e[n].indexOf("px")>0||e[n].indexOf("pt")>0){s=n,this._size=parseInt(e[n]),this._size<=0&&(console.error("font parse error:"+t),this._size=14);break}var r=s+1,a=e[r];for(r++;r<i;r++)a+=" "+e[r];this._family=a.split(",")[0],this._italic=e.indexOf("italic")>=0,this._bold=e.indexOf("bold")>=0}},FontInfo.Parse=function(t){if(t===FontInfo._lastFont)return FontInfo._lastFontInfo;var e=FontInfo._cache[t];return e||(e=FontInfo._cache[t]=new FontInfo(t)),FontInfo._lastFont=t,FontInfo._lastFontInfo=e,e},FontInfo.EMPTY=new FontInfo(null),FontInfo._cache={},FontInfo._gfontID=0,FontInfo._lastFont="",FontInfo._lastFontInfo=null,FontInfo}()),F=(function(){function SpriteConst(){}n(SpriteConst,"laya.display.SpriteConst"),SpriteConst.POSRENDERTYPE=0,SpriteConst.POSBUFFERBEGIN=1,SpriteConst.POSBUFFEREND=2,SpriteConst.POSFRAMECOUNT=3,SpriteConst.POSREPAINT=4,SpriteConst.POSVISIBLE_NATIVE=5,SpriteConst.POSX=6,SpriteConst.POSY=7,SpriteConst.POSPIVOTX=8,SpriteConst.POSPIVOTY=9,SpriteConst.POSSCALEX=10,SpriteConst.POSSCALEY=11,SpriteConst.POSSKEWX=12,SpriteConst.POSSKEWY=13,SpriteConst.POSROTATION=14,SpriteConst.POSTRANSFORM_FLAG=15,SpriteConst.POSMATRIX=16,SpriteConst.POSCOLOR=22,SpriteConst.POSGRAPICS=23,SpriteConst.POSSIM_TEXTURE_ID=24,SpriteConst.POSSIM_TEXTURE_DATA=25,SpriteConst.POSLAYAGL3D=26,SpriteConst.POSCUSTOM=27,SpriteConst.POSCLIP=28,SpriteConst.POSCLIP_NEG_POS=32,SpriteConst.POSCOLORFILTER_COLOR=34,SpriteConst.POSCOLORFILTER_ALPHA=50,SpriteConst.POSCALLBACK_OBJ_ID=54,SpriteConst.POSCUSTOM_CALLBACK_FUN_ID=55,SpriteConst.POSCANVAS_CALLBACK_FUN_ID=56,SpriteConst.POSCANVAS_CALLBACK_END_FUN_ID=57,SpriteConst.POSCANVAS_BEGIN_CMD_ID=58,SpriteConst.POSCANVAS_END_CMD_ID=59,SpriteConst.POSCANVAS_DRAW_TARGET_CMD_ID=60,SpriteConst.POSCANVAS_DRAW_TARGET_PARAM_ID=61,SpriteConst.POSLAYA3D_FUN_ID=62,SpriteConst.POSCACHE_CANVAS_SKIP_PAINT_FLAG=63,SpriteConst.POSFILTER_BEGIN_CMD_ID=64,SpriteConst.POSFILTER_CALLBACK_FUN_ID=65,SpriteConst.POSFILTER_END_CMD_ID=66,SpriteConst.POSFILTER_END_CALLBACK_FUN_ID=67,SpriteConst.POSGRAPHICS_CALLBACK_FUN_ID=68,SpriteConst.POSMASK_CALLBACK_FUN_ID=69,SpriteConst.POSMASK_CMD_ID=70,SpriteConst.POSBLEND_SRC=71,SpriteConst.POSBLEND_DEST=72,SpriteConst.POSSIM_RECT_FILL_CMD=73,SpriteConst.POSSIM_RECT_FILL_DATA=74,SpriteConst.POSSIM_RECT_STROKE_CMD=75,SpriteConst.POSSIM_RECT_STROKE_DATA=76,SpriteConst.POSSIZE=77,SpriteConst.ALPHA=1,SpriteConst.TRANSFORM=2,SpriteConst.BLEND=4,SpriteConst.CANVAS=8,SpriteConst.FILTERS=16,SpriteConst.MASK=32,SpriteConst.CLIP=64,SpriteConst.STYLE=128,SpriteConst.TEXTURE=256,SpriteConst.GRAPHICS=512,SpriteConst.LAYAGL3D=1024,SpriteConst.CUSTOM=2048,SpriteConst.ONECHILD=4096,SpriteConst.CHILDS=8192,SpriteConst.REPAINT_NONE=0,SpriteConst.REPAINT_NODE=1,SpriteConst.REPAINT_CACHE=2,SpriteConst.REPAINT_ALL=3}(),function(){function DrawLinesCmd(){}n(DrawLinesCmd,"laya.display.cmd.DrawLinesCmd");var t=DrawLinesCmd.prototype;return t.recover=function(){this.points=null,this.lineColor=null,y.recover("DrawLinesCmd",this)},t.run=function(t,e,i){t._drawLines(this.x+e,this.y+i,this.points,this.lineColor,this.lineWidth,this.vid)},r(0,t,"cmdID",function(){return"DrawLines"}),DrawLinesCmd.create=function(t,e,i,s,n,r){var a=y.getItemByClass("DrawLinesCmd",DrawLinesCmd);return a.x=t,a.y=e,a.points=i,a.lineColor=s,a.lineWidth=n,a.vid=r,a},DrawLinesCmd.ID="DrawLines",DrawLinesCmd}()),k=function(){function BoundsStyle(){}n(BoundsStyle,"laya.display.css.BoundsStyle");var t=BoundsStyle.prototype;return t.reset=function(){return this.bounds&&this.bounds.recover(),this.userBounds&&this.userBounds.recover(),this.bounds=null,this.userBounds=null,this.temBM=null,this},t.recover=function(){y.recover("BoundsStyle",this.reset())},BoundsStyle.create=function(){return y.getItemByClass("BoundsStyle",BoundsStyle)},BoundsStyle}(),O=function(){function DrawPieCmd(){}n(DrawPieCmd,"laya.display.cmd.DrawPieCmd");var t=DrawPieCmd.prototype;return t.recover=function(){this.fillColor=null,this.lineColor=null,y.recover("DrawPieCmd",this)},t.run=function(t,e,i){t._drawPie(this.x+e,this.y+i,this.radius,this._startAngle,this._endAngle,this.fillColor,this.lineColor,this.lineWidth,this.vid)},r(0,t,"startAngle",function(){return 180*this._startAngle/Math.PI},function(t){this._startAngle=t*Math.PI/180}),r(0,t,"cmdID",function(){return"DrawPie"}),r(0,t,"endAngle",function(){return 180*this._endAngle/Math.PI},function(t){this._endAngle=t*Math.PI/180}),DrawPieCmd.create=function(t,e,i,s,n,r,a,o,h){var l=y.getItemByClass("DrawPieCmd",DrawPieCmd);return l.x=t,l.y=e,l.radius=i,l._startAngle=s,l._endAngle=n,l.fillColor=r,l.lineColor=a,l.lineWidth=o,l.vid=h,l},DrawPieCmd.ID="DrawPie",DrawPieCmd}(),U=function(){function MiniFileMgr(){}return n(MiniFileMgr,"laya.wx.mini.MiniFileMgr"),MiniFileMgr.isLocalNativeFile=function(t){for(var e=0,i=b.nativefiles.length;e<i;e++)if(-1!=t.indexOf(b.nativefiles[e]))return!0;return!1},MiniFileMgr.getFileInfo=function(t){var e=t,i=MiniFileMgr.filesListObj[e];return null==i?null:i},MiniFileMgr.read=function(t,e,i,s,n,r){var a;void 0===e&&(e="ascill"),void 0===s&&(s=""),void 0===n&&(n=!1),void 0===r&&(r=""),a=""==s||-1==s.indexOf("http://")&&-1==s.indexOf("https://")?t:MiniFileMgr.getFileNativePath(t),a=v.getAdptedFilePath(a),MiniFileMgr.fs.readFile({filePath:a,encoding:e,success:function(t){null!=i&&i.runWith([0,t])},fail:function(t){t&&""!=s?MiniFileMgr.downFiles(s,e,i,s,n,r):null!=i&&i.runWith([1])}})},MiniFileMgr.downFiles=function(t,e,i,s,n,r,a){void 0===e&&(e="ascii"),void 0===s&&(s=""),void 0===n&&(n=!1),void 0===r&&(r=""),void 0===a&&(a=!0),MiniFileMgr.wxdown({url:t,success:function(o){200===o.statusCode?MiniFileMgr.readFile(o.tempFilePath,e,i,s,n,r,a):403===o.statusCode?null!=i&&i.runWith([0,t]):null!=i&&i.runWith([1,o])},fail:function(t){null!=i&&i.runWith([1,t])}}).onProgressUpdate(function(t){null!=i&&i.runWith([2,t.progress])})},MiniFileMgr.readFile=function(t,e,i,s,n,r,a){void 0===e&&(e="ascill"),void 0===s&&(s=""),void 0===n&&(n=!1),void 0===r&&(r=""),void 0===a&&(a=!0),t=v.getAdptedFilePath(t),MiniFileMgr.fs.readFile({filePath:t,encoding:e,success:function(r){-1!=t.indexOf("http://")||-1!=t.indexOf("https://")?(b.autoCacheFile||n)&&MiniFileMgr.copyFile(t,s,i,e,a):null!=i&&i.runWith([0,r])},fail:function(t){t&&null!=i&&i.runWith([1,t])}})},MiniFileMgr.downOtherFiles=function(t,e,i,s,n){void 0===i&&(i=""),void 0===s&&(s=!1),void 0===n&&(n=!0),MiniFileMgr.wxdown({url:t,success:function(t){200===t.statusCode?(b.autoCacheFile||s)&&-1==i.indexOf("qlogo.cn")&&-1==i.indexOf(".php")?MiniFileMgr.copyFile(t.tempFilePath,i,e,"",n):null!=e&&e.runWith([0,t.tempFilePath]):null!=e&&e.runWith([1,t])},fail:function(t){null!=e&&e.runWith([1,t])}})},MiniFileMgr.downLoadFile=function(e,s,n,r){void 0===s&&(s=""),void 0===r&&(r="ascii"),t.navigator.userAgent.indexOf("MiniGame")<0?i.loader.load(e,n):"image"==s||"sound"==s?MiniFileMgr.downOtherFiles(e,n,e,!0,!1):MiniFileMgr.downFiles(e,r,n,e,!0,s,!1)},MiniFileMgr.copyFile=function(t,e,i,s,n){void 0===s&&(s=""),void 0===n&&(n=!0);var r=t.split("/"),a=r[r.length-1],o=MiniFileMgr.getFileInfo(e),h=MiniFileMgr.getFileNativePath(a),l=MiniFileMgr.getCacheUseSize();o?o.readyUrl!=e?MiniFileMgr.fs.getFileInfo({filePath:t,success:function(t){n&&l+4194304+t.size>=52428800&&(t.size>b.minClearSize&&(b.minClearSize=t.size),MiniFileMgr.onClearCacheRes()),MiniFileMgr.deleteFile(a,e,i,s,t.size)},fail:function(t){null!=i&&i.runWith([1,t])}}):null!=i&&i.runWith([0]):MiniFileMgr.fs.getFileInfo({filePath:t,success:function(r){n&&l+4194304+r.size>=52428800&&(r.size>b.minClearSize&&(b.minClearSize=r.size),MiniFileMgr.onClearCacheRes()),MiniFileMgr.fs.copyFile({srcPath:t,destPath:h,success:function(t){MiniFileMgr.onSaveFile(e,a,!0,s,i,r.size)},fail:function(t){null!=i&&i.runWith([1,t])}})},fail:function(t){null!=i&&i.runWith([1,t])}})},MiniFileMgr.onClearCacheRes=function(){var t=b.minClearSize,e=[];for(var i in MiniFileMgr.filesListObj)e.push(MiniFileMgr.filesListObj[i]);MiniFileMgr.sortOn(e,"times",16);for(var s=0,n=1,r=e.length;n<r;n++){var a=e[n];if(s>=t)break;s+=a.size,MiniFileMgr.deleteFile("",a.readyUrl)}},MiniFileMgr.sortOn=function(t,e,i){return void 0===i&&(i=0),16==i?t.sort(function(t,i){return t[e]-i[e]}):18==i?t.sort(function(t,i){return i[e]-t[e]}):t.sort(function(t,i){return t[e]-i[e]})},MiniFileMgr.getFileNativePath=function(t){return laya.wx.mini.MiniFileMgr.fileNativeDir+"/"+t},MiniFileMgr.deleteFile=function(t,e,i,s,n){void 0===e&&(e=""),void 0===s&&(s=""),void 0===n&&(n=0);var r=MiniFileMgr.getFileInfo(e),a=MiniFileMgr.getFileNativePath(r.md5);MiniFileMgr.fs.unlink({filePath:a,success:function(r){var a=""!=t;if(""!=t){var o=MiniFileMgr.getFileNativePath(t);MiniFileMgr.fs.copyFile({srcPath:t,destPath:o,success:function(n){MiniFileMgr.onSaveFile(e,t,a,s,i,n.size)},fail:function(t){null!=i&&i.runWith([1,t])}})}else MiniFileMgr.onSaveFile(e,t,a,s,i,n)},fail:function(t){}})},MiniFileMgr.deleteAll=function(){var t=[];for(var e in MiniFileMgr.filesListObj)t.push(MiniFileMgr.filesListObj[e]);for(var i=1,s=t.length;i<s;i++){var n=t[i];MiniFileMgr.deleteFile("",n.readyUrl)}laya.wx.mini.MiniFileMgr.filesListObj&&laya.wx.mini.MiniFileMgr.filesListObj.fileUsedSize&&(laya.wx.mini.MiniFileMgr.filesListObj.fileUsedSize=0),laya.wx.mini.MiniFileMgr.writeFilesList("",JSON.stringify({}),!1)},MiniFileMgr.onSaveFile=function(t,e,i,s,n,r){void 0===i&&(i=!0),void 0===s&&(s=""),void 0===r&&(r=0);var a=t;if(null==MiniFileMgr.filesListObj.fileUsedSize&&(MiniFileMgr.filesListObj.fileUsedSize=0),i){MiniFileMgr.getFileNativePath(e);MiniFileMgr.filesListObj[a]={md5:e,readyUrl:t,size:r,times:P.now(),encoding:s},MiniFileMgr.filesListObj.fileUsedSize=parseInt(MiniFileMgr.filesListObj.fileUsedSize)+r,MiniFileMgr.writeFilesList(a,JSON.stringify(MiniFileMgr.filesListObj),!0),null!=n&&n.runWith([0])}else if(MiniFileMgr.filesListObj[a]){var o=parseInt(MiniFileMgr.filesListObj[a].size);MiniFileMgr.filesListObj.fileUsedSize=parseInt(MiniFileMgr.filesListObj.fileUsedSize)-o,delete MiniFileMgr.filesListObj[a],MiniFileMgr.writeFilesList(a,JSON.stringify(MiniFileMgr.filesListObj),!1),null!=n&&n.runWith([0])}},MiniFileMgr.writeFilesList=function(t,e,i){var s=MiniFileMgr.fileNativeDir+"/"+MiniFileMgr.fileListName;MiniFileMgr.fs.writeFile({filePath:s,encoding:"utf8",data:e,success:function(t){},fail:function(t){}}),!b.isZiYu&&b.isPosMsgYu&&wx.postMessage({url:t,data:MiniFileMgr.filesListObj[t],isLoad:"filenative",isAdd:i})},MiniFileMgr.getCacheUseSize=function(){return MiniFileMgr.filesListObj&&MiniFileMgr.filesListObj.fileUsedSize?MiniFileMgr.filesListObj.fileUsedSize:0},MiniFileMgr.existDir=function(t,e){MiniFileMgr.fs.mkdir({dirPath:t,success:function(t){null!=e&&e.runWith([0,{data:JSON.stringify({})}])},fail:function(t){-1!=t.errMsg.indexOf("file already exists")?MiniFileMgr.readSync(MiniFileMgr.fileListName,"utf8",e):null!=e&&e.runWith([1,t])}})},MiniFileMgr.readSync=function(t,e,i,s){void 0===e&&(e="ascill"),void 0===s&&(s="");var n,r=MiniFileMgr.getFileNativePath(t);try{n=MiniFileMgr.fs.readFileSync(r,e),null!=i&&i.runWith([0,{data:n}])}catch(t){null!=i&&i.runWith([1])}},MiniFileMgr.setNativeFileDir=function(t){MiniFileMgr.fileNativeDir=wx.env.USER_DATA_PATH+t},MiniFileMgr.filesListObj={},MiniFileMgr.fileNativeDir=null,MiniFileMgr.fileListName="layaairfiles.txt",MiniFileMgr.ziyuFileData={},MiniFileMgr.ziyuFileTextureData={},MiniFileMgr.loadPath="",MiniFileMgr.DESCENDING=2,MiniFileMgr.NUMERIC=16,s(MiniFileMgr,["fs",function(){return this.fs=wx.getFileSystemManager()},"wxdown",function(){return this.wxdown=wx.downloadFile}]),MiniFileMgr}(),N=function(){function FillTextureCmd(){}n(FillTextureCmd,"laya.display.cmd.FillTextureCmd");var t=FillTextureCmd.prototype;return t.recover=function(){this.texture=null,this.offset=null,this.other=null,y.recover("FillTextureCmd",this)},t.run=function(t,e,i){t.fillTexture(this.texture,this.x+e,this.y+i,this.width,this.height,this.type,this.offset,this.other)},r(0,t,"cmdID",function(){return"FillTexture"}),FillTextureCmd.create=function(t,e,i,s,n,r,a,o){var h=y.getItemByClass("FillTextureCmd",FillTextureCmd);return h.texture=t,h.x=e,h.y=i,h.width=s,h.height=n,h.type=r,h.offset=a,h.other=o,h},FillTextureCmd.ID="FillTexture",FillTextureCmd}(),W=function(){function StrokeTextCmd(){}n(StrokeTextCmd,"laya.display.cmd.StrokeTextCmd");var t=StrokeTextCmd.prototype;return t.recover=function(){y.recover("StrokeTextCmd",this)},t.run=function(t,e,i){t.strokeWord(this.text,this.x+e,this.y+i,this.font,this.color,this.lineWidth,this.textAlign)},r(0,t,"cmdID",function(){return"StrokeText"}),StrokeTextCmd.create=function(t,e,i,s,n,r,a){var o=y.getItemByClass("StrokeTextCmd",StrokeTextCmd);return o.text=t,o.x=e,o.y=i,o.font=s,o.color=n,o.lineWidth=r,o.textAlign=a,o},StrokeTextCmd.ID="StrokeText",StrokeTextCmd}(),G=function(){function Graphics(){this._one=null,this._cmds=null,this.autoDestroy=!1,this._render=this._renderEmpty,this._createData()}n(Graphics,"laya.display.Graphics");var t=Graphics.prototype;return t._createData=function(){},t._clearData=function(){},t._destroyData=function(){},t.destroy=function(){this.clear(!0),this._graphicBounds&&this._graphicBounds.destroy(),this._graphicBounds=null,this._vectorgraphArray=null,this._sp&&(this._sp._renderType=0,this._sp._setRenderType(0),this._sp=null),this._destroyData()},t.clear=function(t){if(void 0===t&&(t=!0),t){var e=this._one;if(this._cmds){var i=0,s=this._cmds.length;for(i=0;i<s;i++)(e=this._cmds[i]).recover();this._cmds.length=0}else e&&e.recover()}else this._cmds=null;if(this._one=null,this._render=this._renderEmpty,this._clearData(),this._sp&&(this._sp._renderType&=-513,this._sp._setRenderType(this._sp._renderType)),this._repaint(),this._vectorgraphArray){for(i=0,s=this._vectorgraphArray.length;i<s;i++)st.getInstance().deleteShape(this._vectorgraphArray[i]);this._vectorgraphArray.length=0}},t._clearBoundsCache=function(){this._graphicBounds&&this._graphicBounds.reset()},t._initGraphicBounds=function(){this._graphicBounds||(this._graphicBounds=mt.create(),this._graphicBounds._graphics=this)},t._repaint=function(){this._clearBoundsCache(),this._sp&&this._sp.repaint()},t._isOnlyOne=function(){return!this._cmds||0===this._cmds.length},t.getBounds=function(t){return void 0===t&&(t=!1),this._initGraphicBounds(),this._graphicBounds.getBounds(t)},t.getBoundPoints=function(t){return void 0===t&&(t=!1),this._initGraphicBounds(),this._graphicBounds.getBoundPoints(t)},t.drawImage=function(t,e,i,s,n){if(void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===n&&(n=0),!t)return null;if(s||(s=t.sourceWidth),n||(n=t.sourceHeight),t.getIsReady()){var r=s/t.sourceWidth,a=n/t.sourceHeight;if(s=t.width*r,n=t.height*a,s<=0||n<=0)return null;e+=t.offsetX*r,i+=t.offsetY*a}this._sp&&(this._sp._renderType|=512,this._sp._setRenderType(this._sp._renderType));var o=Q.create.call(this,t,e,i,s,n);return null==this._one?(this._one=o,this._render=this._renderOneImg):this._saveToCmd(null,o),this._repaint(),o},t.drawTexture=function(t,e,i,s,n,r,a,h,l){if(void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===n&&(n=0),void 0===a&&(a=1),!t||a<.01)return null;if(!t.getIsReady())return null;if(s||(s=t.sourceWidth),n||(n=t.sourceHeight),t.getIsReady()){var c=!xt.isWebGL&&(P.onFirefox||P.onEdge||P.onIE||P.onSafari)?.5:0,u=s/t.sourceWidth,_=n/t.sourceHeight;if(s=t.width*u,n=t.height*_,s<=0||n<=0)return null;e+=t.offsetX*u,i+=t.offsetY*_,e-=c,i-=c,s+=2*c,n+=2*c}if(this._sp&&(this._sp._renderType|=512,this._sp._setRenderType(this._sp._renderType)),!xt.isConchApp&&!xt.isWebGL&&(l||h)){var d=new $t;if(d.size(s,n),d.getContext("2d").drawTexture(t,0,0,s,n),t=new Ot(d),h){var f=new M,p=o.create(h).arrColor;f.data=(new Rt).color(255*p[0],255*p[1],255*p[2]),f.apply({canvas:d})}}var g=lt.create.call(this,t,e,i,s,n,r,a,h,l);return this._repaint(),this._saveToCmd(null,g)},t.drawTextures=function(t,e){return t?this._saveToCmd(xt._context._drawTextures,T.create.call(this,t,e)):null},t.drawTriangles=function(t,e,i,s,n,r,a,o,h,l){return void 0===o&&(o=1),this._saveToCmd(xt._context.drawTriangles,It.create.call(this,t,e,i,s,n,r,a,o,h,l))},t.fillTexture=function(t,e,i,s,n,r,a){return void 0===s&&(s=0),void 0===n&&(n=0),void 0===r&&(r="repeat"),t&&t.getIsReady()?this._saveToCmd(xt._context._fillTexture,N.create.call(this,t,e,i,s,n,r,a||et.EMPTY,{})):null},t._saveToCmd=function(t,e){return this._sp&&(this._sp._renderType|=512,this._sp._setRenderType(this._sp._renderType)),null==this._one?(this._one=e,this._render=this._renderOne):(this._render=this._renderAll,0===(this._cmds||(this._cmds=[])).length&&this._cmds.push(this._one),this._cmds.push(e)),this._repaint(),e},t.clipRect=function(t,e,i,s){return this._saveToCmd(xt._context._clipRect,Mt.create.call(this,t,e,i,s))},t.fillText=function(t,e,i,s,n,r){return this._saveToCmd(xt._context._fillText,rt.create.call(this,t,e,i,s||zt.defaultFontStr(),n,r))},t.fillBorderText=function(t,e,i,s,n,r,a,o){return this._saveToCmd(xt._context._fillBorderText,A.create.call(this,t,e,i,s||zt.defaultFontStr(),n,r,a,o))},t.fillWords=function(t,e,i,s,n){return this._saveToCmd(xt._context._fillWords,wt.create.call(this,t,e,i,s||zt.defaultFontStr(),n))},t.fillBorderWords=function(t,e,i,s,n,r,a){return this._saveToCmd(xt._context._fillBorderWords,H.create.call(this,t,e,i,s||zt.defaultFontStr(),n,r,a))},t.strokeText=function(t,e,i,s,n,r,a){return this._saveToCmd(xt._context._strokeText,W.create.call(this,t,e,i,s||zt.defaultFontStr(),n,r,a))},t.alpha=function(t){return this._saveToCmd(xt._context._alpha,z.create.call(this,t))},t.transform=function(t,e,i){return void 0===e&&(e=0),void 0===i&&(i=0),this._saveToCmd(xt._context._transform,St.create.call(this,t,e,i))},t.rotate=function(t,e,i){return void 0===e&&(e=0),void 0===i&&(i=0),this._saveToCmd(xt._context._rotate,pt.create.call(this,t,e,i))},t.scale=function(t,e,i,s){return void 0===i&&(i=0),void 0===s&&(s=0),this._saveToCmd(xt._context._scale,X.create.call(this,t,e,i,s))},t.translate=function(t,e){return this._saveToCmd(xt._context._translate,S.create.call(this,t,e))},t.save=function(){return this._saveToCmd(xt._context._save,K.create.call(this))},t.restore=function(){return this._saveToCmd(xt._context._restore,Y.create.call(this))},t.replaceText=function(t){this._repaint();var e=this._cmds;if(e){for(var i=e.length-1;i>-1;i--)if(this._isTextCmd(e[i]))return e[i].text=t,!0}else if(this._one&&this._isTextCmd(this._one))return this._one.text=t,!0;return!1},t._isTextCmd=function(t){var e=t.cmdID;return"FillText"==e||"StrokeText"==e||"FillBorderText"==e},t.replaceTextColor=function(t){this._repaint();var e=this._cmds;if(e)for(var i=e.length-1;i>-1;i--)this._isTextCmd(e[i])&&this._setTextCmdColor(e[i],t);else this._one&&this._isTextCmd(this._one)&&this._setTextCmdColor(this._one,t)},t._setTextCmdColor=function(t,e){switch(t.cmdID){case"FillText":case"StrokeText":t.color=e;break;case"FillBorderText":case"FillBorderWords":case"FillBorderText":t.fillColor=e}},t.loadImage=function(t,e,i,s,n,r){void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===n&&(n=0);var a=Ft.getRes(t);a?a.getIsReady()?this.drawImage(a,e,i,s,n):a.once("ready",this,this.drawImage,[a,e,i,s,n]):((a=new Ot).load(t),Ft.cacheRes(t,a),a.once("ready",this,this.drawImage,[a,e,i,s,n])),null!=r&&(a.getIsReady()?r.call(this._sp):a.on("ready",this._sp,r))},t._renderEmpty=function(t,e,i,s){},t._renderAll=function(t,e,i,s){for(var n=this._cmds,r=0,a=n.length;r<a;r++)n[r].run(e,i,s)},t._renderOne=function(t,e,i,s){this._one.run(e,i,s)},t._renderOneImg=function(t,e,i,s){this._one.run(e,i,s)},t.drawLine=function(t,e,i,s,n,r){void 0===r&&(r=1);var a=0;xt.isWebGL&&(a=st.getInstance().getId(),null==this._vectorgraphArray&&(this._vectorgraphArray=[]),this._vectorgraphArray.push(a));var o=r<1||r%2==0?0:.5;return this._saveToCmd(xt._context._drawLine,x.create.call(this,t+o,e+o,i+o,s+o,n,r,a))},t.drawLines=function(t,e,i,s,n){void 0===n&&(n=1);var r=0;if(!i||i.length<4)return null;xt.isWebGL&&(r=st.getInstance().getId(),null==this._vectorgraphArray&&(this._vectorgraphArray=[]),this._vectorgraphArray.push(r));var a=n<1||n%2==0?0:.5;return this._saveToCmd(xt._context._drawLines,F.create.call(this,t+a,e+a,i,s,n,r))},t.drawCurves=function(t,e,i,s,n){return void 0===n&&(n=1),this._saveToCmd(xt._context._drawCurves,q.create.call(this,t,e,i,s,n))},t.drawRect=function(t,e,i,s,n,r,a){void 0===a&&(a=1);var o=a>=1&&r?a/2:0,h=r?a:0;return this._saveToCmd(xt._context.drawRect,p.create.call(this,t+o,e+o,i-h,s-h,n,r,a))},t.drawCircle=function(t,e,i,s,n,r){void 0===r&&(r=1);var a=r>=1&&n?r/2:0,o=0;return xt.isWebGL&&(o=st.getInstance().getId(),null==this._vectorgraphArray&&(this._vectorgraphArray=[]),this._vectorgraphArray.push(o)),this._saveToCmd(xt._context._drawCircle,g.create.call(this,t,e,i-a,s,n,r,o))},t.drawPie=function(t,e,i,s,n,r,a,o){void 0===o&&(o=1);var h=o>=1&&a?o/2:0,l=a?o:0,c=0;return xt.isWebGL&&(c=st.getInstance().getId(),null==this._vectorgraphArray&&(this._vectorgraphArray=[]),this._vectorgraphArray.push(c)),this._saveToCmd(xt._context._drawPie,O.create.call(this,t+h,e+h,i-l,_t.toRadian(s),_t.toRadian(n),r,a,o,c))},t.drawPoly=function(t,e,i,s,n,r){void 0===r&&(r=1);var a=0;if(xt.isWebGL){a=st.getInstance().getId(),null==this._vectorgraphArray&&(this._vectorgraphArray=[]),this._vectorgraphArray.push(a);var o=!1;o=!(i.length>6)}var h=r>=1&&n?r%2==0?0:.5:0;return this._saveToCmd(xt._context._drawPoly,bt.create.call(this,t+h,e+h,i,s,n,r,o,a))},t.drawPath=function(t,e,i,s,n){return this._saveToCmd(xt._context._drawPath,D.create.call(this,t,e,i,s,n))},r(0,t,"cmds",function(){return this._cmds},function(t){this._sp&&(this._sp._renderType|=512,this._sp._setRenderType(this._sp._renderType)),this._cmds=t,this._render=this._renderAll,this._repaint()}),Graphics}(),Y=function(){function RestoreCmd(){}n(RestoreCmd,"laya.display.cmd.RestoreCmd");var t=RestoreCmd.prototype;return t.recover=function(){y.recover("RestoreCmd",this)},t.run=function(t,e,i){t.restore()},r(0,t,"cmdID",function(){return"Restore"}),RestoreCmd.create=function(){return y.getItemByClass("RestoreCmd",RestoreCmd)},RestoreCmd.ID="Restore",RestoreCmd}(),H=(function(){function ResourceVersion(){}n(ResourceVersion,"laya.net.ResourceVersion"),ResourceVersion.enable=function(t,e,s){void 0===s&&(s=2),laya.net.ResourceVersion.type=s,i.loader.load(t,l.create(null,ResourceVersion.onManifestLoaded,[e]),null,"json")},ResourceVersion.onManifestLoaded=function(t,e){ResourceVersion.manifest=e,v.customFormat=ResourceVersion.addVersionPrefix,t.run(),e||console.warn("资源版本清单文件不存在，不使用资源版本管理。忽略ERR_FILE_NOT_FOUND错误。")},ResourceVersion.addVersionPrefix=function(t){return t=v.getAdptedFilePath(t),ResourceVersion.manifest&&ResourceVersion.manifest[t]?2==ResourceVersion.type?ResourceVersion.manifest[t]:ResourceVersion.manifest[t]+"/"+t:t},ResourceVersion.FOLDER_VERSION=1,ResourceVersion.FILENAME_VERSION=2,ResourceVersion.manifest=null,ResourceVersion.type=1}(),function(){function FillBorderWordsCmd(){}n(FillBorderWordsCmd,"laya.display.cmd.FillBorderWordsCmd");var t=FillBorderWordsCmd.prototype;return t.recover=function(){this.words=null,y.recover("FillBorderWordsCmd",this)},t.run=function(t,e,i){t.fillBorderWords(this.words,this.x+e,this.y+i,this.font,this.fillColor,this.borderColor,this.lineWidth)},r(0,t,"cmdID",function(){return"FillBorderWords"}),FillBorderWordsCmd.create=function(t,e,i,s,n,r,a){var o=y.getItemByClass("FillBorderWordsCmd",FillBorderWordsCmd);return o.words=t,o.x=e,o.y=i,o.font=s,o.fillColor=n,o.borderColor=r,o.lineWidth=a,o},FillBorderWordsCmd.ID="FillBorderWords",FillBorderWordsCmd}()),X=function(){function ScaleCmd(){}n(ScaleCmd,"laya.display.cmd.ScaleCmd");var t=ScaleCmd.prototype;return t.recover=function(){y.recover("ScaleCmd",this)},t.run=function(t,e,i){t._scale(this.scaleX,this.scaleY,this.pivotX+e,this.pivotY+i)},r(0,t,"cmdID",function(){return"Scale"}),ScaleCmd.create=function(t,e,i,s){var n=y.getItemByClass("ScaleCmd",ScaleCmd);return n.scaleX=t,n.scaleY=e,n.pivotX=i,n.pivotY=s,n},ScaleCmd.ID="Scale",ScaleCmd}(),z=function(){function AlphaCmd(){}n(AlphaCmd,"laya.display.cmd.AlphaCmd");var t=AlphaCmd.prototype;return t.recover=function(){y.recover("AlphaCmd",this)},t.run=function(t,e,i){t.alpha(this.alpha)},r(0,t,"cmdID",function(){return"Alpha"}),AlphaCmd.create=function(t){var e=y.getItemByClass("AlphaCmd",AlphaCmd);return e.alpha=t,e},AlphaCmd.ID="Alpha",AlphaCmd}(),V=function(){function Prefab(){this.json=null}return n(Prefab,"laya.components.Prefab"),Prefab.prototype.create=function(){return this.json?nt.createByData(null,this.json):null},Prefab}(),j=function(){function WordText(){this.id=NaN,this.save=[],this.toUpperCase=null,this.changed=!1,this._text=null,this.width=-1,this.pageChars=[],this.startID=0,this.startIDStroke=0,this.lastGCCnt=0}n(WordText,"laya.utils.WordText");var t=WordText.prototype;return t.setText=function(t){this.changed=!0,this._text=t,this.width=-1,this.pageChars=[]},t.toString=function(){return this._text},t.charCodeAt=function(t){return this._text?this._text.charCodeAt(t):NaN},t.charAt=function(t){return this._text?this._text.charAt(t):null},t.cleanCache=function(){this.pageChars=[],this.startID=0},r(0,t,"length",function(){return this._text?this._text.length:0}),WordText}(),$=function(){function GrahamScan(){}return n(GrahamScan,"laya.maths.GrahamScan"),GrahamScan.multiply=function(t,e,i){return(t.x-i.x)*(e.y-i.y)-(e.x-i.x)*(t.y-i.y)},GrahamScan.dis=function(t,e){return(t.x-e.x)*(t.x-e.x)+(t.y-e.y)*(t.y-e.y)},GrahamScan._getPoints=function(t,e,i){for(void 0===e&&(e=!1),GrahamScan._mPointList||(GrahamScan._mPointList=[]);GrahamScan._mPointList.length<t;)GrahamScan._mPointList.push(new et);return i||(i=[]),i.length=0,e?GrahamScan.getFrom(i,GrahamScan._mPointList,t):GrahamScan.getFromR(i,GrahamScan._mPointList,t),i},GrahamScan.getFrom=function(t,e,i){var s=0;for(s=0;s<i;s++)t.push(e[s]);return t},GrahamScan.getFromR=function(t,e,i){var s=0;for(s=0;s<i;s++)t.push(e.pop());return t},GrahamScan.pListToPointList=function(t,e){void 0===e&&(e=!1);var i=0,s=t.length/2,n=GrahamScan._getPoints(s,e,GrahamScan._tempPointList);for(i=0;i<s;i++)n[i].setTo(t[i+i],t[i+i+1]);return n},GrahamScan.pointListToPlist=function(t){var e,i=0,s=t.length,n=GrahamScan._temPList;for(n.length=0,i=0;i<s;i++)e=t[i],n.push(e.x,e.y);return n},GrahamScan.scanPList=function(t){return _t.copyArray(t,GrahamScan.pointListToPlist(GrahamScan.scan(GrahamScan.pListToPointList(t,!0))))},GrahamScan.scan=function(t){var e,i,s,n=0,r=0,a=0,o=t.length,h={};for((i=GrahamScan._temArr).length=0,n=(o=t.length)-1;n>=0;n--)s=(e=t[n]).x+"_"+e.y,h.hasOwnProperty(s)||(h[s]=!0,i.push(e));for(o=i.length,_t.copyArray(t,i),n=1;n<o;n++)(t[n].y<t[a].y||t[n].y==t[a].y&&t[n].x<t[a].x)&&(a=n);for(e=t[0],t[0]=t[a],t[a]=e,n=1;n<o-1;n++){for(a=n,r=n+1;r<o;r++)(GrahamScan.multiply(t[r],t[a],t[0])>0||0==GrahamScan.multiply(t[r],t[a],t[0])&&GrahamScan.dis(t[0],t[r])<GrahamScan.dis(t[0],t[a]))&&(a=r);e=t[n],t[n]=t[a],t[a]=e}if((i=GrahamScan._temArr).length=0,t.length<3)return _t.copyArray(i,t);for(i.push(t[0],t[1],t[2]),n=3;n<o;n++){for(;i.length>=2&&GrahamScan.multiply(t[n],i[i.length-1],i[i.length-2])>=0;)i.pop();t[n]&&i.push(t[n])}return i},GrahamScan._mPointList=null,GrahamScan._tempPointList=[],GrahamScan._temPList=[],GrahamScan._temArr=[],GrahamScan}(),q=(function(){function Const(){}n(Const,"laya.Const"),Const.NOT_ACTIVE=1,Const.ACTIVE_INHIERARCHY=2,Const.AWAKED=4,Const.NOT_READY=8,Const.DISPLAY=16,Const.HAS_ZORDER=32,Const.HAS_MOUSE=64,Const.DISPLAYED_INSTAGE=128,Const.DRAWCALL_OPTIMIZE=256}(),function(){function MathUtil(){}n(MathUtil,"laya.maths.MathUtil"),MathUtil.subtractVector3=function(t,e,i){i[0]=t[0]-e[0],i[1]=t[1]-e[1],i[2]=t[2]-e[2]},MathUtil.lerp=function(t,e,i){return t*(1-i)+e*i},MathUtil.scaleVector3=function(t,e,i){i[0]=t[0]*e,i[1]=t[1]*e,i[2]=t[2]*e},MathUtil.lerpVector3=function(t,e,i,s){var n=t[0],r=t[1],a=t[2];s[0]=n+i*(e[0]-n),s[1]=r+i*(e[1]-r),s[2]=a+i*(e[2]-a)},MathUtil.lerpVector4=function(t,e,i,s){var n=t[0],r=t[1],a=t[2],o=t[3];s[0]=n+i*(e[0]-n),s[1]=r+i*(e[1]-r),s[2]=a+i*(e[2]-a),s[3]=o+i*(e[3]-o)},MathUtil.slerpQuaternionArray=function(t,e,i,s,n,r,a){var o,h,l,c,u,_=t[e+0],d=t[e+1],f=t[e+2],p=t[e+3],g=i[s+0],m=i[s+1],v=i[s+2],y=i[s+3];return(h=_*g+d*m+f*v+p*y)<0&&(h=-h,g=-g,m=-m,v=-v,y=-y),1-h>1e-6?(o=Math.acos(h),l=Math.sin(o),c=Math.sin((1-n)*o)/l,u=Math.sin(n*o)/l):(c=1-n,u=n),r[a+0]=c*_+u*g,r[a+1]=c*d+u*m,r[a+2]=c*f+u*v,r[a+3]=c*p+u*y,r},MathUtil.getRotation=function(t,e,i,s){return Math.atan2(s-e,i-t)/Math.PI*180},MathUtil.sortBigFirst=function(t,e){return t==e?0:e>t?1:-1},MathUtil.sortSmallFirst=function(t,e){return t==e?0:e>t?-1:1},MathUtil.sortNumBigFirst=function(t,e){return parseFloat(e)-parseFloat(t)},MathUtil.sortNumSmallFirst=function(t,e){return parseFloat(t)-parseFloat(e)},MathUtil.sortByKey=function(t,e,i){var s;return void 0===e&&(e=!1),void 0===i&&(i=!0),s=e?i?MathUtil.sortNumBigFirst:MathUtil.sortBigFirst:i?MathUtil.sortNumSmallFirst:MathUtil.sortSmallFirst,function(e,i){return s(e[t],i[t])}}}(),function(){function DrawCurvesCmd(){}n(DrawCurvesCmd,"laya.display.cmd.DrawCurvesCmd");var t=DrawCurvesCmd.prototype;return t.recover=function(){this.points=null,this.lineColor=null,y.recover("DrawCurvesCmd",this)},t.run=function(t,e,i){t.drawCurves(this.x+e,this.y+i,this.points,this.lineColor,this.lineWidth)},r(0,t,"cmdID",function(){return"DrawCurves"}),DrawCurvesCmd.create=function(t,e,i,s,n){var r=y.getItemByClass("DrawCurvesCmd",DrawCurvesCmd);return r.x=t,r.y=e,r.points=i,r.lineColor=s,r.lineWidth=n,r},DrawCurvesCmd.ID="DrawCurves",DrawCurvesCmd}()),K=function(){function SaveCmd(){}n(SaveCmd,"laya.display.cmd.SaveCmd");var t=SaveCmd.prototype;return t.recover=function(){y.recover("SaveCmd",this)},t.run=function(t,e,i){t.save()},r(0,t,"cmdID",function(){return"Save"}),SaveCmd.create=function(){return y.getItemByClass("SaveCmd",SaveCmd)},SaveCmd.ID="Save",SaveCmd}(),Q=function(){function DrawImageCmd(){}n(DrawImageCmd,"laya.display.cmd.DrawImageCmd");var t=DrawImageCmd.prototype;return t.recover=function(){this.texture._removeReference(),this.texture=null,y.recover("DrawImageCmd",this)},t.run=function(t,e,i){t.drawTexture(this.texture,this.x+e,this.y+i,this.width,this.height)},r(0,t,"cmdID",function(){return"DrawImage"}),DrawImageCmd.create=function(t,e,i,s,n){var r=y.getItemByClass("DrawImageCmd",DrawImageCmd);return r.texture=t,t._addReference(),r.x=e,r.y=i,r.width=s,r.height=n,r},DrawImageCmd.ID="DrawImage",DrawImageCmd}(),Z=function(){function Matrix(t,e,i,s,n,r,a){if(this._bTransform=!1,void 0===t&&(t=1),void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=1),void 0===n&&(n=0),void 0===r&&(r=0),void 0===a&&(a=0),null!=Matrix._createFun)return Matrix._createFun(t,e,i,s,n,r,a);this.a=t,this.b=e,this.c=i,this.d=s,this.tx=n,this.ty=r,this._checkTransform()}n(Matrix,"laya.maths.Matrix");var t=Matrix.prototype;return t.identity=function(){return this.a=this.d=1,this.b=this.tx=this.ty=this.c=0,this._bTransform=!1,this},t._checkTransform=function(){return this._bTransform=1!==this.a||0!==this.b||0!==this.c||1!==this.d},t.setTranslate=function(t,e){return this.tx=t,this.ty=e,this},t.translate=function(t,e){return this.tx+=t,this.ty+=e,this},t.scale=function(t,e){return this.a*=t,this.d*=e,this.c*=t,this.b*=e,this.tx*=t,this.ty*=e,this._bTransform=!0,this},t.rotate=function(t){var e=Math.cos(t),i=Math.sin(t),s=this.a,n=this.c,r=this.tx;return this.a=s*e-this.b*i,this.b=s*i+this.b*e,this.c=n*e-this.d*i,this.d=n*i+this.d*e,this.tx=r*e-this.ty*i,this.ty=r*i+this.ty*e,this._bTransform=!0,this},t.skew=function(t,e){var i=Math.tan(t),s=Math.tan(e),n=this.a,r=this.b;return this.a+=s*this.c,this.b+=s*this.d,this.c+=i*n,this.d+=i*r,this},t.invertTransformPoint=function(t){var e=this.a,i=this.b,s=this.c,n=this.d,r=this.tx,a=e*n-i*s,o=n/a,h=-i/a,l=-s/a,c=e/a,u=(s*this.ty-n*r)/a,_=-(e*this.ty-i*r)/a;return t.setTo(o*t.x+l*t.y+u,h*t.x+c*t.y+_)},t.transformPoint=function(t){return t.setTo(this.a*t.x+this.c*t.y+this.tx,this.b*t.x+this.d*t.y+this.ty)},t.transformPointN=function(t){return t.setTo(this.a*t.x+this.c*t.y,this.b*t.x+this.d*t.y)},t.getScaleX=function(){return 0===this.b?this.a:Math.sqrt(this.a*this.a+this.b*this.b)},t.getScaleY=function(){return 0===this.c?this.d:Math.sqrt(this.c*this.c+this.d*this.d)},t.invert=function(){var t=this.a,e=this.b,i=this.c,s=this.d,n=this.tx,r=t*s-e*i;return this.a=s/r,this.b=-e/r,this.c=-i/r,this.d=t/r,this.tx=(i*this.ty-s*n)/r,this.ty=-(t*this.ty-e*n)/r,this},t.setTo=function(t,e,i,s,n,r){return this.a=t,this.b=e,this.c=i,this.d=s,this.tx=n,this.ty=r,this},t.concat=function(t){var e=this.a,i=this.c,s=this.tx;return this.a=e*t.a+this.b*t.c,this.b=e*t.b+this.b*t.d,this.c=i*t.a+this.d*t.c,this.d=i*t.b+this.d*t.d,this.tx=s*t.a+this.ty*t.c+t.tx,this.ty=s*t.b+this.ty*t.d+t.ty,this},t.scaleEx=function(t,e){var i=this.a,s=this.b,n=this.c,r=this.d;0!==s||0!==n?(this.a=t*i,this.b=t*s,this.c=e*n,this.d=e*r):(this.a=t*i,this.b=0*r,this.c=0*i,this.d=e*r),this._bTransform=!0},t.rotateEx=function(t){var e=Math.cos(t),i=Math.sin(t),s=this.a,n=this.b,r=this.c,a=this.d;0!==n||0!==r?(this.a=e*s+i*r,this.b=e*n+i*a,this.c=-i*s+e*r,this.d=-i*n+e*a):(this.a=e*s,this.b=i*a,this.c=-i*s,this.d=e*a),this._bTransform=!0},t.clone=function(){var t=Matrix.create();return t.a=this.a,t.b=this.b,t.c=this.c,t.d=this.d,t.tx=this.tx,t.ty=this.ty,t._bTransform=this._bTransform,t},t.copyTo=function(t){return t.a=this.a,t.b=this.b,t.c=this.c,t.d=this.d,t.tx=this.tx,t.ty=this.ty,t._bTransform=this._bTransform,t},t.toString=function(){return this.a+","+this.b+","+this.c+","+this.d+","+this.tx+","+this.ty},t.destroy=function(){this.recover()},t.recover=function(){y.recover("Matrix",this.identity())},Matrix.mul=function(t,e,i){var s=t.a,n=t.b,r=t.c,a=t.d,o=t.tx,h=t.ty,l=e.a,c=e.b,u=e.c,_=e.d,d=e.tx,f=e.ty;return 0!==c||0!==u?(i.a=s*l+n*u,i.b=s*c+n*_,i.c=r*l+a*u,i.d=r*c+a*_,i.tx=l*o+u*h+d,i.ty=c*o+_*h+f):(i.a=s*l,i.b=n*_,i.c=r*l,i.d=a*_,i.tx=l*o+d,i.ty=_*h+f),i},Matrix.mul16=function(t,e,i){var s=t.a,n=t.b,r=t.c,a=t.d,o=t.tx,h=t.ty,l=e.a,c=e.b,u=e.c,_=e.d,d=e.tx,f=e.ty;return 0!==c||0!==u?(i[0]=s*l+n*u,i[1]=s*c+n*_,i[4]=r*l+a*u,i[5]=r*c+a*_,i[12]=l*o+u*h+d,i[13]=c*o+_*h+f):(i[0]=s*l,i[1]=n*_,i[4]=r*l,i[5]=a*_,i[12]=l*o+d,i[13]=_*h+f),i},Matrix.create=function(){return y.getItemByClass("Matrix",Matrix)},Matrix.EMPTY=new Matrix,Matrix.TEMP=new Matrix,Matrix._createFun=null,Matrix}(),J=(function(){function Byte(t){this._xd_=!0,this._allocated_=8,this._pos_=0,this._length=0,t?(this._u8d_=new Uint8Array(t),this._d_=new DataView(this._u8d_.buffer),this._length=this._d_.byteLength):this._resizeBuffer(this._allocated_)}n(Byte,"laya.utils.Byte");var t=Byte.prototype;t._resizeBuffer=function(t){try{var e=new Uint8Array(t);null!=this._u8d_&&(this._u8d_.length<=t?e.set(this._u8d_):e.set(this._u8d_.subarray(0,t))),this._u8d_=e,this._d_=new DataView(e.buffer)}catch(e){throw"Invalid typed array length:"+t}},t.getString=function(){return this.readString()},t.readString=function(){return this._rUTF(this.getUint16())},t.getFloat32Array=function(t,e){return this.readFloat32Array(t,e)},t.readFloat32Array=function(t,e){var i=t+e;i=i>this._length?this._length:i;var s=new Float32Array(this._d_.buffer.slice(t,i));return this._pos_=i,s},t.getUint8Array=function(t,e){return this.readUint8Array(t,e)},t.readUint8Array=function(t,e){var i=t+e;i=i>this._length?this._length:i;var s=new Uint8Array(this._d_.buffer.slice(t,i));return this._pos_=i,s},t.getInt16Array=function(t,e){return this.readInt16Array(t,e)},t.readInt16Array=function(t,e){var i=t+e;i=i>this._length?this._length:i;var s=new Int16Array(this._d_.buffer.slice(t,i));return this._pos_=i,s},t.getFloat32=function(){return this.readFloat32()},t.readFloat32=function(){if(this._pos_+4>this._length)throw"getFloat32 error - Out of bounds";var t=this._d_.getFloat32(this._pos_,this._xd_);return this._pos_+=4,t},t.getFloat64=function(){return this.readFloat64()},t.readFloat64=function(){if(this._pos_+8>this._length)throw"getFloat64 error - Out of bounds";var t=this._d_.getFloat64(this._pos_,this._xd_);return this._pos_+=8,t},t.writeFloat32=function(t){this._ensureWrite(this._pos_+4),this._d_.setFloat32(this._pos_,t,this._xd_),this._pos_+=4},t.writeFloat64=function(t){this._ensureWrite(this._pos_+8),this._d_.setFloat64(this._pos_,t,this._xd_),this._pos_+=8},t.getInt32=function(){return this.readInt32()},t.readInt32=function(){if(this._pos_+4>this._length)throw"getInt32 error - Out of bounds";var t=this._d_.getInt32(this._pos_,this._xd_);return this._pos_+=4,t},t.getUint32=function(){return this.readUint32()},t.readUint32=function(){if(this._pos_+4>this._length)throw"getUint32 error - Out of bounds";var t=this._d_.getUint32(this._pos_,this._xd_);return this._pos_+=4,t},t.writeInt32=function(t){this._ensureWrite(this._pos_+4),this._d_.setInt32(this._pos_,t,this._xd_),this._pos_+=4},t.writeUint32=function(t){this._ensureWrite(this._pos_+4),this._d_.setUint32(this._pos_,t,this._xd_),this._pos_+=4},t.getInt16=function(){return this.readInt16()},t.readInt16=function(){if(this._pos_+2>this._length)throw"getInt16 error - Out of bounds";var t=this._d_.getInt16(this._pos_,this._xd_);return this._pos_+=2,t},t.getUint16=function(){return this.readUint16()},t.readUint16=function(){if(this._pos_+2>this._length)throw"getUint16 error - Out of bounds";var t=this._d_.getUint16(this._pos_,this._xd_);return this._pos_+=2,t},t.writeUint16=function(t){this._ensureWrite(this._pos_+2),this._d_.setUint16(this._pos_,t,this._xd_),this._pos_+=2},t.writeInt16=function(t){this._ensureWrite(this._pos_+2),this._d_.setInt16(this._pos_,t,this._xd_),this._pos_+=2},t.getUint8=function(){return this.readUint8()},t.readUint8=function(){if(this._pos_+1>this._length)throw"getUint8 error - Out of bounds";return this._u8d_[this._pos_++]},t.writeUint8=function(t){this._ensureWrite(this._pos_+1),this._d_.setUint8(this._pos_,t),this._pos_++},t._getUInt8=function(t){return this._readUInt8(t)},t._readUInt8=function(t){return this._d_.getUint8(t)},t._getUint16=function(t){return this._readUint16(t)},t._readUint16=function(t){return this._d_.getUint16(t,this._xd_)},t._getMatrix=function(){return this._readMatrix()},t._readMatrix=function(){return new Z(this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32(),this.getFloat32())},t._rUTF=function(t){for(var e="",i=this._pos_+t,s=0,n=String.fromCharCode,r=this._u8d_;this._pos_<i;)(s=r[this._pos_++])<128?0!=s&&(e+=n(s)):e+=n(s<224?(63&s)<<6|127&r[this._pos_++]:s<240?(31&s)<<12|(127&r[this._pos_++])<<6|127&r[this._pos_++]:(15&s)<<18|(127&r[this._pos_++])<<12|r[this._pos_++]<<6&127|127&r[this._pos_++]),0;return e},t.getCustomString=function(t){return this.readCustomString(t)},t.readCustomString=function(t){for(var e="",i=0,s=0,n=String.fromCharCode,r=this._u8d_;t>0;)if((s=r[this._pos_])<128)e+=n(s),this._pos_++,t--;else for(i=s-128,this._pos_++,t-=i;i>0;)s=r[this._pos_++],e+=n(r[this._pos_++]<<8|s),i--;return e},t.clear=function(){this._pos_=0,this.length=0},t.__getBuffer=function(){return this._d_.buffer},t.writeUTFBytes=function(t){for(var e=0,i=(t+="").length;e<i;e++){var s=t.charCodeAt(e);s<=127?this.writeByte(s):s<=2047?(this._ensureWrite(this._pos_+2),this._u8d_.set([192|s>>6,128|63&s],this._pos_),this._pos_+=2):s<=65535?(this._ensureWrite(this._pos_+3),this._u8d_.set([224|s>>12,128|s>>6&63,128|63&s],this._pos_),this._pos_+=3):(this._ensureWrite(this._pos_+4),this._u8d_.set([240|s>>18,128|s>>12&63,128|s>>6&63,128|63&s],this._pos_),this._pos_+=4)}},t.writeUTFString=function(t){var e=this.pos;this.writeUint16(1),this.writeUTFBytes(t);var i=this.pos-e-2;this._d_.setUint16(e,i,this._xd_)},t.readUTFString=function(){return this.readUTFBytes(this.getUint16())},t.getUTFString=function(){return this.readUTFString()},t.readUTFBytes=function(t){if(void 0===t&&(t=-1),0===t)return"";var e=this.bytesAvailable;if(t>e)throw"readUTFBytes error - Out of bounds";return t=t>0?t:e,this._rUTF(t)},t.getUTFBytes=function(t){return void 0===t&&(t=-1),this.readUTFBytes(t)},t.writeByte=function(t){this._ensureWrite(this._pos_+1),this._d_.setInt8(this._pos_,t),this._pos_+=1},t.readByte=function(){if(this._pos_+1>this._length)throw"readByte error - Out of bounds";return this._d_.getInt8(this._pos_++)},t.getByte=function(){return this.readByte()},t._ensureWrite=function(t){this._length<t&&(this._length=t),this._allocated_<t&&(this.length=t)},t.writeArrayBuffer=function(t,e,i){if(void 0===e&&(e=0),void 0===i&&(i=0),e<0||i<0)throw"writeArrayBuffer error - Out of bounds";0==i&&(i=t.byteLength-e),this._ensureWrite(this._pos_+i);var s=new Uint8Array(t);this._u8d_.set(s.subarray(e,e+i),this._pos_),this._pos_+=i},t.readArrayBuffer=function(t){var e;return e=this._u8d_.buffer.slice(this._pos_,this._pos_+t),this._pos_=this._pos_+t,e},r(0,t,"buffer",function(){var t=this._d_.buffer;return t.byteLength===this._length?t:t.slice(0,this._length)}),r(0,t,"endian",function(){return this._xd_?"littleEndian":"bigEndian"},function(t){this._xd_="littleEndian"===t}),r(0,t,"length",function(){return this._length},function(t){this._allocated_<t?this._resizeBuffer(this._allocated_=Math.floor(Math.max(t,2*this._allocated_))):this._allocated_>t&&this._resizeBuffer(this._allocated_=t),this._length=t}),r(0,t,"pos",function(){return this._pos_},function(t){this._pos_=t}),r(0,t,"bytesAvailable",function(){return this._length-this._pos_}),Byte.getSystemEndian=function(){if(!Byte._sysEndian){var t=new ArrayBuffer(2);new DataView(t).setInt16(0,256,!0),Byte._sysEndian=256===new Int16Array(t)[0]?"littleEndian":"bigEndian"}return Byte._sysEndian},Byte.BIG_ENDIAN="bigEndian",Byte.LITTLE_ENDIAN="littleEndian",Byte._sysEndian=null}(),function(){function UIUtils(){}return n(UIUtils,"laya.ui.UIUtils"),UIUtils.fillArray=function(t,e,i){var s=t.concat();if(e)for(var n=e.split(","),r=0,a=Math.min(s.length,n.length);r<a;r++){var o=n[r];s[r]="true"==o||"false"!=o&&o,null!=i&&(s[r]=i(o))}return s},UIUtils.toColor=function(t){return _t.toHexColor(t)},UIUtils.gray=function(t,e){void 0===e&&(e=!0),e?UIUtils.addFilter(t,UIUtils.grayFilter):UIUtils.clearFilter(t,Rt)},UIUtils.addFilter=function(t,e){var i=t.filters||[];i.push(e),t.filters=i},UIUtils.clearFilter=function(t,e){var s=t.filters;if(null!=s&&s.length>0){for(var n=s.length-1;n>-1;n--){var r=s[n];i.__typeof(r,e)&&s.splice(n,1)}t.filters=s}},UIUtils._getReplaceStr=function(t){return UIUtils.escapeSequence[t]},UIUtils.adptString=function(t){return t.replace(/\\(\w)/g,UIUtils._getReplaceStr)},UIUtils.getBindFun=function(t){var e=UIUtils._funMap.get(t);if(null==e){var s='"'+t+'"',n="(function(data){if(data==null)return;with(data){try{\nreturn "+(s=s.replace(/^"\${|}"$/g,"").replace(/\${/g,'"+').replace(/}/g,'+"'))+"\n}catch(e){}}})";e=i._runScript(n),UIUtils._funMap.set(t,e)}return e},s(UIUtils,["grayFilter",function(){return this.grayFilter=new Rt([.3086,.6094,.082,0,0,.3086,.6094,.082,0,0,.3086,.6094,.082,0,0,0,0,0,1,0])},"escapeSequence",function(){return this.escapeSequence={"\\n":"\n","\\t":"\t"}},"_funMap",function(){return this._funMap=new ct}]),UIUtils}()),tt=function(){function CacheStyle(){this.reset()}n(CacheStyle,"laya.display.css.CacheStyle");var t=CacheStyle.prototype;return t.needBitmapCache=function(){return this.cacheForFilters||!!this.mask},t.needEnableCanvasRender=function(){return"none"!=this.userSetCache||this.cacheForFilters||!!this.mask},t.releaseContext=function(){this.canvas&&this.canvas.size&&(y.recover("CacheCanvas",this.canvas),this.canvas.size(0,0)),this.canvas=null},t.createContext=function(){if(!this.canvas){this.canvas=y.getItem("CacheCanvas")||new $t(!xt.isWebGL);var t=this.canvas.context;t||(t=this.canvas.getContext("2d"))}},t.releaseFilterCache=function(){var t=this.filterCache;t&&(t.destroy(),t.recycle(),this.filterCache=null)},t.recover=function(){this!==CacheStyle.EMPTY&&y.recover("SpriteCache",this.reset())},t.reset=function(){return this.releaseContext(),this.releaseFilterCache(),this.cacheAs="none",this.enableCanvasRender=!1,this.userSetCache="none",this.cacheForFilters=!1,this.staticCache=!1,this.reCache=!0,this.mask=null,this.maskParent=null,this.filterCache=null,this.filters=null,this.hasGlowFilter=!1,this.cacheRect&&this.cacheRect.recover(),this.cacheRect=null,this},t._calculateCacheRect=function(t,e,s,n){var r=!1;(xt.isWebGL||xt.isConchApp)&&(r=!0);var a,o=t._cacheStyle;o.cacheRect||(o.cacheRect=gt.create()),r&&"bitmap"!==e?o.cacheRect.setTo(-t._style.pivotX,-t._style.pivotY,1,1):(a=t.getSelfBounds(),xt.isConchApp?(a.width=a.x+a.width+32,a.height=a.x+a.height+32):(a.width=a.width+32,a.height=a.height+32),a.x=a.x-t.pivotX,a.y=a.y-t.pivotY,a.x=a.x-16,a.y=a.y-16,a.x=Math.floor(a.x+s)-s,a.y=Math.floor(a.y+n)-n,a.width=Math.floor(a.width),a.height=Math.floor(a.height),o.cacheRect.copyFrom(a)),a=o.cacheRect;var h=r?1:P.pixelRatio*i.stage.clientScaleX,l=r?1:P.pixelRatio*i.stage.clientScaleY;if(!r){var c,u=1,_=1;for(c=t;c&&c!=i.stage;)u*=c.scaleX,_*=c.scaleY,c=c.parent;u>1&&(h*=u),_>1&&(l*=_)}if(t._style.scrollRect){var d=t._style.scrollRect;a.x-=d.x,a.y-=d.y}return CacheStyle._scaleInfo.setTo(h,l),CacheStyle._scaleInfo},CacheStyle.create=function(){return y.getItemByClass("SpriteCache",CacheStyle)},CacheStyle.EMPTY=new CacheStyle,CacheStyle.CANVAS_EXTEND_EDGE=16,s(CacheStyle,["_scaleInfo",function(){return this._scaleInfo=new et}]),CacheStyle}(),et=function(){function Point(t,e){void 0===t&&(t=0),void 0===e&&(e=0),this.x=t,this.y=e}n(Point,"laya.maths.Point");var t=Point.prototype;return t.setTo=function(t,e){return this.x=t,this.y=e,this},t.reset=function(){return this.x=this.y=0,this},t.recover=function(){y.recover("Point",this.reset())},t.distance=function(t,e){return Math.sqrt((this.x-t)*(this.x-t)+(this.y-e)*(this.y-e))},t.toString=function(){return this.x+","+this.y},t.normalize=function(){var t=Math.sqrt(this.x*this.x+this.y*this.y);if(t>0){var e=1/t;this.x*=e,this.y*=e}},t.copy=function(t){return this.setTo(t.x,t.y)},Point.create=function(){return y.getItemByClass("Point",Point)},Point.TEMP=new Point,Point.EMPTY=new Point,Point}(),it=function(){function Context(){}n(Context,"laya.resource.Context");var t=Context.prototype;return t.drawCanvas=function(t,e,i,s,n){Tt.renderBatch++,this.drawImage(t._source,e,i,s,n)},t._drawRect=function(t,e,i,s,n){Tt.renderBatch++,n&&(this.fillStyle=n),this.fillRect(t,e,i,s)},t.drawText=function(t,e,i,s,n,r){Tt.renderBatch++,arguments.length>3&&null!=s&&(this.font=s,this.fillStyle=n,this.textAlign=r,this.textBaseline="top"),this.fillText(t,e,i)},t.fillBorderText=function(t,e,i,s,n,r,a,o){Tt.renderBatch++,this.font=s,this.fillStyle=n,this.textBaseline="top",this.strokeStyle=r,this.lineWidth=a,this.textAlign=o,this.strokeText(t,e,i),this.fillText(t,e,i)},t.fillWords=function(t,e,i,s,n){s&&(this.font=s),n&&(this.fillStyle=n),this.textBaseline="top",this.textAlign="left";for(var r=0,a=t.length;r<a;r++){var o=t[r];this.fillText(o.char,o.x+e,o.y+i)}},t.fillBorderWords=function(t,e,i,s,n,r,a){s&&(this.font=s),n&&(this.fillStyle=n),this.textBaseline="top",this.lineWidth=a,this.textAlign="left",this.strokeStyle=r;for(var o=0,h=t.length;o<h;o++){var l=t[o];this.strokeText(l.char,l.x+e,l.y+i),this.fillText(l.char,l.x+e,l.y+i)}},t.strokeWord=function(t,e,i,s,n,r,a){Tt.renderBatch++,arguments.length>3&&null!=s&&(this.font=s,this.strokeStyle=n,this.lineWidth=r,this.textAlign=a,this.textBaseline="top"),this.strokeText(t,e,i)},t.setTransformByMatrix=function(t){this.setTransform(t.a,t.b,t.c,t.d,t.tx,t.ty)},t.clipRect=function(t,e,i,s){Tt.renderBatch++,this.beginPath(),this.rect(t,e,i,s),this.clip()},t.drawTextureWithTransform=function(t,e,i,s,n,r,a,o,h,l,c){if(t._getSource()){Tt.renderBatch++;var u=1!==h;if(u){var _=this.globalAlpha;this.globalAlpha*=h}l&&(this.globalCompositeOperation=l);var d=t.uv,f=t.bitmap._width,p=t.bitmap._height;r?(this.save(),this.transform(r.a,r.b,r.c,r.d,r.tx+a,r.ty+o),this.drawImage(t.bitmap._source,d[0]*f,d[1]*p,(d[2]-d[0])*f,(d[5]-d[3])*p,e,i,s,n),this.restore()):this.drawImage(t.bitmap._source,d[0]*f,d[1]*p,(d[2]-d[0])*f,(d[5]-d[3])*p,a+e,o+i,s,n),u&&(this.globalAlpha=_),l&&(this.globalCompositeOperation="source-over")}},t.drawTexture2=function(t,e,i,s,n,r){var a=r[0];Tt.renderBatch++;var o=a.uv,h=a.bitmap._width,l=a.bitmap._height;n?(this.save(),this.transform(n.a,n.b,n.c,n.d,n.tx+t,n.ty+e),this.drawImage(a.bitmap._source,o[0]*h,o[1]*l,(o[2]-o[0])*h,(o[5]-o[3])*l,r[1]-i,r[2]-s,r[3],r[4]),this.restore()):this.drawImage(a.bitmap._source,o[0]*h,o[1]*l,(o[2]-o[0])*h,(o[5]-o[3])*l,r[1]-i+t,r[2]-s+e,r[3],r[4])},t.fillTexture=function(t,e,i,s,n,r,a,o){if(!o.pat){if(t.uv!=Ot.DEF_UV){var h=new $t;h.getContext("2d"),h.size(t.width,t.height),h.context.drawTexture(t,0,0,t.width,t.height),t=new Ot(h)}o.pat=this.createPattern(t.bitmap._source,r)}var l=e,c=i,u=0,_=0;a&&(l+=a.x%t.width,c+=a.y%t.height,u-=a.x%t.width,_-=a.y%t.height),this.translate(l,c),this._drawRect(u,_,s,n,o.pat),this.translate(-l,-c)},t.flush=function(){return 0},t.destroy=function(){this.canvas.width=this.canvas.height=0},t.clear=function(){xt.isConchApp||this.clearRect(0,0,xt._mainCanvas.width,xt._mainCanvas.height)},t.drawTriangle=function(t,e,i,s,n,r,a,o){var h=t.bitmap,l=h._getSource(),c=t.width,u=t.height,_=h.width,d=h.height,f=i[s]*_,p=i[n]*_,g=i[r]*_,m=i[s+1]*d,v=i[n+1]*d,y=i[r+1]*d,C=e[s],w=e[n],S=e[r],x=e[s+1],T=e[n+1],M=e[r+1];if(o){var b=(C+w+S)/3,L=(x+T+M)/3,I=C-b,R=x-L,P=Math.sqrt(I*I+R*R);C=b+I/P*(P+1),x=L+R/P*(P+1),R=T-L,w=b+(I=w-b)/(P=Math.sqrt(I*I+R*R))*(P+1),T=L+R/P*(P+1),R=M-L,S=b+(I=S-b)/(P=Math.sqrt(I*I+R*R))*(P+1),M=L+R/P*(P+1)}this.save(),a&&this.transform(a.a,a.b,a.c,a.d,a.tx,a.ty),this.beginPath(),this.moveTo(C,x),this.lineTo(w,T),this.lineTo(S,M),this.closePath(),this.clip();var D=1/(f*v+m*g+p*y-v*g-m*p-f*y),B=C*v+m*S+w*y-v*S-m*w-C*y,A=f*w+C*g+p*S-w*g-C*p-f*S,E=f*v*S+m*w*g+C*p*y-C*v*g-m*p*S-f*w*y,F=x*v+m*M+T*y-v*M-m*T-x*y,k=f*T+x*g+p*M-T*g-x*p-f*M,O=f*v*M+m*T*g+x*p*y-x*v*g-m*p*M-f*T*y;this.transform(B*D,F*D,A*D,k*D,E*D,O*D),this.drawImage(l,t.uv[0]*_,t.uv[1]*d,c,u,t.uv[0]*_,t.uv[1]*d,c,u),this.restore()},t.transformByMatrix=function(t,e,i){this.transform(t.a,t.b,t.c,t.d,t.tx+e,t.ty+i)},t.saveTransform=function(t){this.save()},t.restoreTransform=function(t){this.restore()},t.drawRect=function(t,e,i,s,n,r,a){null!=n&&(this.fillStyle=n,this.fillRect(t,e,i,s)),null!=r&&(this.strokeStyle=r,this.lineWidth=a,this.strokeRect(t,e,i,s))},t.drawTexture=function(t,e,i,s,n){var r=t._getSource();if(r){Tt.renderBatch++;var a=t.uv,o=t.bitmap.width,h=t.bitmap.height;this.drawImage(r,a[0]*o,a[1]*h,(a[2]-a[0])*o,(a[5]-a[3])*h,e,i,s,n)}},t.drawTextures=function(t,e,i,s){Tt.renderBatch+=e.length/2;for(var n=t.width,r=t.height,a=0,o=e.length;a<o;a+=2)this.drawTexture(t,e[a]+i,e[a+1]+s,n,r)},t.drawTriangles=function(t,e,i,s,n,r,a,o,h,l){var c=0,u=r.length;for(this.translate(e,i),c=0;c<u;c+=3){var _=2*r[c],d=2*r[c+1],f=2*r[c+2];this.drawTriangle(t,s,n,_,d,f,a,!0)}this.translate(-e,-i)},t.alpha=function(t){this.globalAlpha*=t},t._transform=function(t,e,i){this.translate(e,i),this.transform(t.a,t.b,t.c,t.d,t.tx,t.ty),this.translate(-e,-i)},t._rotate=function(t,e,i){this.translate(e,i),this.rotate(t),this.translate(-e,-i)},t._scale=function(t,e,i,s){this.translate(i,s),this.scale(t,e),this.translate(-i,-s)},t._drawLine=function(t,e,i,s,n,r,a,o,h){this.beginPath(),this.strokeStyle=a,this.lineWidth=o,this.moveTo(t+i,e+s),this.lineTo(t+n,e+r),this.stroke()},t._drawLines=function(t,e,i,s,n,r){xt.isWebGL&&this.setPathId(r),this.beginPath(),this.strokeStyle=s,this.lineWidth=n;var a=2,o=i.length;if(xt.isWebGL)this.addPath(i.slice(),!1,!1,t,e);else for(this.moveTo(t+i[0],e+i[1]);a<o;)this.lineTo(t+i[a++],e+i[a++]);this.stroke()},t.drawCurves=function(t,e,i,s,n){this.beginPath(),this.strokeStyle=s,this.lineWidth=n,this.moveTo(t+i[0],e+i[1]);for(var r=2,a=i.length;r<a;)this.quadraticCurveTo(t+i[r++],e+i[r++],t+i[r++],e+i[r++]);this.stroke()},t._fillAndStroke=function(t,e,i,s){void 0===s&&(s=!1),null!=t&&(this.fillStyle=t,this.fill()),null!=e&&i>0&&(this.strokeStyle=e,this.lineWidth=i,this.stroke())},t._drawCircle=function(t,e,i,s,n,r,a){Tt.renderBatch++,xt.isWebGL?this.beginPath(!0):this.beginPath(),this.arc(t,e,i,0,Context.PI2),this.closePath(),this._fillAndStroke(s,n,r)},t._drawPie=function(t,e,i,s,n,r,a,o,h){this.beginPath(),this.moveTo(t,e),this.arc(t,e,i,s,n),this.closePath(),this._fillAndStroke(r,a,o)},t._drawPoly=function(t,e,i,s,n,r,a,o){var h=2,l=i.length;if(this.beginPath(),xt.isWebGL)this.setPathId(o),this.addPath(i.slice(),!0,a,t,e);else for(this.moveTo(t+i[0],e+i[1]);h<l;)this.lineTo(t+i[h++],e+i[h++]);this.closePath(),this._fillAndStroke(s,n,r,a)},t._drawPath=function(t,e,i,s,n){this.beginPath();for(var r=0,a=i.length;r<a;r++){var o=i[r];switch(o[0]){case"moveTo":this.moveTo(t+o[1],e+o[2]);break;case"lineTo":this.lineTo(t+o[1],e+o[2]);break;case"arcTo":this.arcTo(t+o[1],e+o[2],t+o[3],e+o[4],o[5]);break;case"closePath":this.closePath()}}null!=s&&(this.fillStyle=s.fillStyle,this.fill()),null!=n&&(this.strokeStyle=n.strokeStyle,this.lineWidth=n.lineWidth||1,this.lineJoin=n.lineJoin,this.lineCap=n.lineCap,this.miterLimit=n.miterLimit,this.stroke())},t.drawParticle=function(t,e,i){},Context.__init__=function(t){var e=laya.resource.Context.prototype;if(!(t=t||CanvasRenderingContext2D.prototype).init2d){t.init2d=!0;["saveTransform","restoreTransform","transformByMatrix","drawTriangles","drawTriangle","drawTextures","fillWords","fillBorderWords","drawRect","strokeWord","drawText","fillTexture","setTransformByMatrix","clipRect","drawTexture","drawTexture2","drawTextureWithTransform","flush","clear","destroy","drawCanvas","fillBorderText","drawCurves","_drawRect","alpha","_transform","_rotate","_scale","_drawLine","_drawLines","_drawCircle","_fillAndStroke","_drawPie","_drawPoly","_drawPath","drawTextureWithTransform"].forEach(function(i){t[i]=e[i]})}},Context.ENUM_TEXTALIGN_DEFAULT=0,Context.ENUM_TEXTALIGN_CENTER=1,Context.ENUM_TEXTALIGN_RIGHT=2,Context.PI2=2*Math.PI,Context}(),st=function(){function VectorGraphManager(){this.useDic={},this.shapeDic={},this.shapeLineDic={},this._id=0,this._checkKey=!1,this._freeIdArray=[],xt.isWebGL&&vt.regCacheByFunction(_t.bind(this.startDispose,this),_t.bind(this.getCacheList,this))}n(VectorGraphManager,"laya.utils.VectorGraphManager");var t=VectorGraphManager.prototype;return t.getId=function(){return this._id++},t.addShape=function(t,e){this.shapeDic[t]=e,this.useDic[t]||(this.useDic[t]=!0)},t.addLine=function(t,e){this.shapeLineDic[t]=e,this.shapeLineDic[t]||(this.shapeLineDic[t]=!0)},t.getShape=function(t){this._checkKey&&null!=this.useDic[t]&&(this.useDic[t]=!0)},t.deleteShape=function(t){this.shapeDic[t]&&(this.shapeDic[t]=null,delete this.shapeDic[t]),this.shapeLineDic[t]&&(this.shapeLineDic[t]=null,delete this.shapeLineDic[t]),null!=this.useDic[t]&&delete this.useDic[t]},t.getCacheList=function(){var t,e=[];for(t in this.shapeDic)e.push(this.shapeDic[t]);for(t in this.shapeLineDic)e.push(this.shapeLineDic[t]);return e},t.startDispose=function(t){var e;for(e in this.useDic)this.useDic[e]=!1;this._checkKey=!0},t.endDispose=function(){if(this._checkKey){var t;for(t in this.useDic)this.useDic[t]||this.deleteShape(t);this._checkKey=!1}},VectorGraphManager.getInstance=function(){return VectorGraphManager.instance=VectorGraphManager.instance||new VectorGraphManager},VectorGraphManager.instance=null,VectorGraphManager}(),nt=function(){var t,e;function SceneUtils(){}return n(SceneUtils,"laya.utils.SceneUtils"),SceneUtils.getBindFun=function(t){var e=SceneUtils._funMap.get(t);if(null==e){var s='"'+t+'"',n="(function(data){if(data==null)return;with(data){try{\nreturn "+(s=s.replace(/^"\${|}"$/g,"").replace(/\${/g,'"+').replace(/}/g,'+"'))+"\n}catch(e){}}})";e=i._runScript(n),SceneUtils._funMap.set(t,e)}return e},SceneUtils.createByData=function(t,i){var s=e.create();if((t=SceneUtils.createComp(i,t,t,null,s))._setBit(8,!0),t.hasOwnProperty("_idMap")&&(t._idMap=s._idMap),i.animations)i.animations.length;return"Scene"===t._$componentType&&t._width>0&&null==i.props.hitTestPrior&&!t.mouseThrough&&(t.hitTestPrior=!0),s.beginLoad(t),t},SceneUtils.createInitTool=function(){return e.create()},SceneUtils.createComp=function(t,e,s,n,r){if("Scene3D"==t.type||"Sprite3D"==t.type){var a=[],o=i.Utils3D._createSceneByJsonForMaker(t,a,r);return"Sprite3D"==t.type?i.StaticBatchManager.combine(o,a):i.StaticBatchManager.combine(null,a),o}if(!(e=e||SceneUtils.getCompInstance(t)))return t.props&&t.props.runtime?console.warn("runtime not found:"+t.props.runtime):console.warn("can not create:"+t.type),null;var h=t.child;if(h)for(var l="List"==e._$componentType,c=0,u=h.length;c<u;c++){var _=h[c];if(!e.hasOwnProperty("itemRender")||"render"!=_.props.name&&"render"!==_.props.renderType)if("Graphic"==_.type)dt._addGraphicsToSprite(_,e);else if(dt._isDrawType(_.type))dt._addGraphicToSprite(_,e,!0);else{if(l){var d=[],f=SceneUtils.createComp(_,null,s,d,r);d.length&&(f._$bindData=d)}else f=SceneUtils.createComp(_,null,s,n,r);"Script"==_.type?f instanceof laya.components.Component?e._addComponentInstance(f):"owner"in f?f.owner=e:"target"in f&&(f.target=e):"mask"==_.props.renderType||"mask"==_.props.name?e.mask=f:f instanceof laya.display.Node&&e.addChild(f)}else e.itemRender=_}var p=t.props;for(var g in p){var m=p[g];"string"==typeof m&&(m.indexOf("@node:")>=0||m.indexOf("@Prefab:")>=0)?r&&r.addNodeRef(e,g,m):SceneUtils.setCompValue(e,g,m,s,n)}return e._afterInited&&e._afterInited(),t.compId&&r&&r._idMap&&(r._idMap[t.compId]=e),e},SceneUtils.setCompValue=function(e,i,s,n,r){if("string"==typeof s&&s.indexOf("${")>-1){if(SceneUtils._sheet||(SceneUtils._sheet=dt.getClass("laya.data.Table")),!SceneUtils._sheet)return void console.warn("Can not find class Sheet");if(r)r.push(e,i,s);else if(n){-1==s.indexOf("].")&&(s=s.replace(".","[0]."));var a,o,h=new t(e,i,s);h.exe(n);for(var l=s.replace(/\[.*?\]\./g,".");null!=(a=SceneUtils._parseWatchData.exec(l));){for(var c=a[1];null!=(o=SceneUtils._parseKeyWord.exec(c));){var u=o[0],_=n._watchMap[u]||(n._watchMap[u]=[]);_.push(h),SceneUtils._sheet.I.notifer.on(u,n,n.changeData,[u])}(_=n._watchMap[c]||(n._watchMap[c]=[])).push(h),SceneUtils._sheet.I.notifer.on(c,n,n.changeData,[c])}}}else"var"===i&&n?n[s]=e:e[i]="true"===s||"false"!==s&&s},SceneUtils.getCompInstance=function(t){if("UIView"==t.type&&t.props&&t.props.pageData)return SceneUtils.createByData(null,t.props.pageData);var e=t.props&&t.props.runtime||t.type,i=dt.getClass(e);if(!i)throw"Can not find class "+e;if("Script"===t.type&&i.prototype._doAwake){var s=y.createByClass(i);return s._destroyed=!1,s}return t.props&&t.props.hasOwnProperty("renderType")&&"instance"==t.props.renderType?(i.instance||(i.instance=new i),i.instance):new i},SceneUtils._sheet=null,s(SceneUtils,["_funMap",function(){return this._funMap=new ct},"_parseWatchData",function(){return this._parseWatchData=/\${(.*?)}/g},"_parseKeyWord",function(){return this._parseKeyWord=/[a-zA-Z_][a-zA-Z0-9_]*(?:(?:\.[a-zA-Z_][a-zA-Z0-9_]*)+)/g}]),SceneUtils.__init$=function(){t=function(){function DataWatcher(t,e,i){this.comp=null,this.prop=null,this.value=null,this.comp=t,this.prop=e,this.value=i}return n(DataWatcher,""),DataWatcher.prototype.exe=function(t){var e=SceneUtils.getBindFun(this.value);this.comp[this.prop]=e.call(this,t)},DataWatcher}(),e=function(){function InitTool(){this._nodeRefList=null,this._initList=null,this._loadList=null,this._idMap=null,this._scene=null}n(InitTool,"");var t=InitTool.prototype;return t.reset=function(){this._nodeRefList=null,this._initList=null,this._idMap=null,this._loadList=null,this._scene=null},t.recover=function(){this.reset(),y.recover("InitTool",this)},t.addLoadRes=function(t,e){this._loadList||(this._loadList=[]),e?this._loadList.push({url:t,type:e}):this._loadList.push(t)},t.addNodeRef=function(t,e,i){this._nodeRefList||(this._nodeRefList=[]),this._nodeRefList.push([t,e,i]),i.indexOf("@Prefab:")>=0&&this.addLoadRes(i.replace("@Prefab:",""),"prefab")},t.setNodeRef=function(){if(this._nodeRefList)if(this._idMap){var t,e,i=0;for(t=this._nodeRefList.length,i=0;i<t;i++)(e=this._nodeRefList[i])[0][e[1]]=this.getReferData(e[2]);this._nodeRefList=null}else this._nodeRefList=null},t.getReferData=function(t){if(t.indexOf("@Prefab:")>=0)return Ft.getRes(t.replace("@Prefab:",""));if(t.indexOf("@arr:")>=0){var e,i,s,n=0;for(i=(e=(t=t.replace("@arr:","")).split(",")).length,n=0;n<i;n++)s=e[n],e[n]=s?this._idMap[s.replace("@node:","")]:null;return e}return this._idMap[t.replace("@node:","")]},t.addInitItem=function(t){this._initList||(this._initList=[]),this._initList.push(t)},t.doInits=function(){this._initList&&(this._initList=null)},t.finish=function(){this.setNodeRef(),this.doInits(),this._scene._setBit(8,!1),this._scene.parent&&this._scene.parent.activeInHierarchy&&this._scene.active&&this._scene._processActive(),this._scene.event("onViewCreated"),this.recover()},t.beginLoad=function(t){this._scene=t,!this._loadList||this._loadList.length<1?this.finish():i.loader.load(this._loadList,l.create(this,this.finish))},InitTool.create=function(){var t=y.getItemByClass("InitTool",InitTool);return t._idMap=[],t},InitTool}()},SceneUtils}(),rt=function(){function FillTextCmd(){this._textIsWorldText=!1,this._fontColor=4294967295,this._strokeColor=0,this._nTexAlign=0,this._fontObj=FillTextCmd._defFontObj}n(FillTextCmd,"laya.display.cmd.FillTextCmd");var t=FillTextCmd.prototype;return t.recover=function(){y.recover("FillTextCmd",this)},t.run=function(t,e,s){i.stage.isGlobalRepaint()&&this._textIsWorldText&&this._text.cleanCache(),this._textIsWorldText&&t._fast_filltext?t._fast_filltext(this._text,this.x+e,this.y+s,this._fontObj,this._color,null,0,this._nTexAlign,0):t.drawText(this._text,this.x+e,this.y+s,this._font,this._color,this._textAlign)},r(0,t,"text",function(){return this._text},function(t){this._text=t,this._textIsWorldText=t instanceof laya.utils.WordText,this._textIsWorldText&&this._text.cleanCache()}),r(0,t,"cmdID",function(){return"FillText"}),r(0,t,"color",function(){return this._color},function(t){this._color=t,this._fontColor=o.create(t).numColor,this._textIsWorldText&&this._text.cleanCache()}),r(0,t,"font",function(){return this._font},function(t){this._font=t,(xt.isWebGL||xt.isConchApp)&&(this._fontObj=E.Parse(t)),this._textIsWorldText&&this._text.cleanCache()}),r(0,t,"textAlign",function(){return this._textAlign},function(t){switch(this._textAlign=t,t){case"center":this._nTexAlign=it.ENUM_TEXTALIGN_CENTER;break;case"right":this._nTexAlign=it.ENUM_TEXTALIGN_RIGHT;break;default:this._nTexAlign=it.ENUM_TEXTALIGN_DEFAULT}this._textIsWorldText&&this._text.cleanCache()}),FillTextCmd.create=function(t,e,i,s,n,r){var a=y.getItemByClass("FillTextCmd",FillTextCmd);return a.text=t,a._textIsWorldText=t instanceof laya.utils.WordText,a.x=e,a.y=i,a.font=s,a.color=n,a.textAlign=r,a},FillTextCmd.ID="FillText",s(FillTextCmd,["_defFontObj",function(){return this._defFontObj=new E(null)}]),FillTextCmd}(),at=function(){function Ease(){}return n(Ease,"laya.utils.Ease"),Ease.linearNone=function(t,e,i,s){return i*t/s+e},Ease.linearIn=function(t,e,i,s){return i*t/s+e},Ease.linearInOut=function(t,e,i,s){return i*t/s+e},Ease.linearOut=function(t,e,i,s){return i*t/s+e},Ease.bounceIn=function(t,e,i,s){return i-Ease.bounceOut(s-t,0,i,s)+e},Ease.bounceInOut=function(t,e,i,s){return t<.5*s?.5*Ease.bounceIn(2*t,0,i,s)+e:.5*Ease.bounceOut(2*t-s,0,i,s)+.5*i+e},Ease.bounceOut=function(t,e,i,s){return(t/=s)<1/2.75?i*(7.5625*t*t)+e:t<2/2.75?i*(7.5625*(t-=1.5/2.75)*t+.75)+e:t<2.5/2.75?i*(7.5625*(t-=2.25/2.75)*t+.9375)+e:i*(7.5625*(t-=2.625/2.75)*t+.984375)+e},Ease.backIn=function(t,e,i,s,n){return void 0===n&&(n=1.70158),i*(t/=s)*t*((n+1)*t-n)+e},Ease.backInOut=function(t,e,i,s,n){return void 0===n&&(n=1.70158),(t/=.5*s)<1?.5*i*(t*t*((1+(n*=1.525))*t-n))+e:i/2*((t-=2)*t*((1+(n*=1.525))*t+n)+2)+e},Ease.backOut=function(t,e,i,s,n){return void 0===n&&(n=1.70158),i*((t=t/s-1)*t*((n+1)*t+n)+1)+e},Ease.elasticIn=function(t,e,i,s,n,r){var a;return void 0===n&&(n=0),void 0===r&&(r=0),0==t?e:1==(t/=s)?e+i:(r||(r=.3*s),!n||i>0&&n<i||i<0&&n<-i?(n=i,a=r/4):a=r/Ease.PI2*Math.asin(i/n),-n*Math.pow(2,10*(t-=1))*Math.sin((t*s-a)*Ease.PI2/r)+e)},Ease.elasticInOut=function(t,e,i,s,n,r){var a;return void 0===n&&(n=0),void 0===r&&(r=0),0==t?e:2==(t/=.5*s)?e+i:(r||(r=s*(.3*1.5)),!n||i>0&&n<i||i<0&&n<-i?(n=i,a=r/4):a=r/Ease.PI2*Math.asin(i/n),t<1?n*Math.pow(2,10*(t-=1))*Math.sin((t*s-a)*Ease.PI2/r)*-.5+e:n*Math.pow(2,-10*(t-=1))*Math.sin((t*s-a)*Ease.PI2/r)*.5+i+e)},Ease.elasticOut=function(t,e,i,s,n,r){var a;return void 0===n&&(n=0),void 0===r&&(r=0),0==t?e:1==(t/=s)?e+i:(r||(r=.3*s),!n||i>0&&n<i||i<0&&n<-i?(n=i,a=r/4):a=r/Ease.PI2*Math.asin(i/n),n*Math.pow(2,-10*t)*Math.sin((t*s-a)*Ease.PI2/r)+i+e)},Ease.strongIn=function(t,e,i,s){return i*(t/=s)*t*t*t*t+e},Ease.strongInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*i*t*t*t*t*t+e:.5*i*((t-=2)*t*t*t*t+2)+e},Ease.strongOut=function(t,e,i,s){return i*((t=t/s-1)*t*t*t*t+1)+e},Ease.sineInOut=function(t,e,i,s){return.5*-i*(Math.cos(Math.PI*t/s)-1)+e},Ease.sineIn=function(t,e,i,s){return-i*Math.cos(t/s*Ease.HALF_PI)+i+e},Ease.sineOut=function(t,e,i,s){return i*Math.sin(t/s*Ease.HALF_PI)+e},Ease.quintIn=function(t,e,i,s){return i*(t/=s)*t*t*t*t+e},Ease.quintInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*i*t*t*t*t*t+e:.5*i*((t-=2)*t*t*t*t+2)+e},Ease.quintOut=function(t,e,i,s){return i*((t=t/s-1)*t*t*t*t+1)+e},Ease.quartIn=function(t,e,i,s){return i*(t/=s)*t*t*t+e},Ease.quartInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*i*t*t*t*t+e:.5*-i*((t-=2)*t*t*t-2)+e},Ease.quartOut=function(t,e,i,s){return-i*((t=t/s-1)*t*t*t-1)+e},Ease.cubicIn=function(t,e,i,s){return i*(t/=s)*t*t+e},Ease.cubicInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*i*t*t*t+e:.5*i*((t-=2)*t*t+2)+e},Ease.cubicOut=function(t,e,i,s){return i*((t=t/s-1)*t*t+1)+e},Ease.quadIn=function(t,e,i,s){return i*(t/=s)*t+e},Ease.quadInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*i*t*t+e:.5*-i*(--t*(t-2)-1)+e},Ease.quadOut=function(t,e,i,s){return-i*(t/=s)*(t-2)+e},Ease.expoIn=function(t,e,i,s){return 0==t?e:i*Math.pow(2,10*(t/s-1))+e-.001*i},Ease.expoInOut=function(t,e,i,s){return 0==t?e:t==s?e+i:(t/=.5*s)<1?.5*i*Math.pow(2,10*(t-1))+e:.5*i*(2-Math.pow(2,-10*--t))+e},Ease.expoOut=function(t,e,i,s){return t==s?e+i:i*(1-Math.pow(2,-10*t/s))+e},Ease.circIn=function(t,e,i,s){return-i*(Math.sqrt(1-(t/=s)*t)-1)+e},Ease.circInOut=function(t,e,i,s){return(t/=.5*s)<1?.5*-i*(Math.sqrt(1-t*t)-1)+e:.5*i*(Math.sqrt(1-(t-=2)*t)+1)+e},Ease.circOut=function(t,e,i,s){return i*Math.sqrt(1-(t=t/s-1)*t)+e},Ease.HALF_PI=.5*Math.PI,Ease.PI2=2*Math.PI,Ease}(),ot=function(){function HitArea(){this._hit=null,this._unHit=null}n(HitArea,"laya.utils.HitArea");var t=HitArea.prototype;return t.contains=function(t,e){return!!HitArea._isHitGraphic(t,e,this.hit)&&!HitArea._isHitGraphic(t,e,this.unHit)},r(0,t,"hit",function(){return this._hit||(this._hit=new G),this._hit},function(t){this._hit=t}),r(0,t,"unHit",function(){return this._unHit||(this._unHit=new G),this._unHit},function(t){this._unHit=t}),HitArea._isHitGraphic=function(t,e,i){if(!i)return!1;var s=i.cmds;if(!s&&i._one&&((s=HitArea._cmds).length=1,s[0]=i._one),!s)return!1;var n,r,a=0;for(n=s.length,a=0;a<n;a++)if(r=s[a]){switch(r.cmdID){case"Translate":t-=r.tx,e-=r.ty}if(HitArea._isHitCmd(t,e,r))return!0}return!1},HitArea._isHitCmd=function(t,e,i){if(!i)return!1;var s=!1;switch(i.cmdID){case"DrawRect":HitArea._rect.setTo(i.x,i.y,i.width,i.height),s=HitArea._rect.contains(t,e);break;case"DrawCircle":s=(t-=i.x)*t+(e-=i.y)*e<i.radius*i.radius;break;case"DrawPoly":t-=i.x,e-=i.y,s=HitArea._ptInPolygon(t,e,i.points)}return s},HitArea._ptInPolygon=function(t,e,i){var s=HitArea._ptPoint;s.setTo(t,e);var n,r=0,a=NaN,o=NaN,h=NaN,l=NaN;n=i.length;for(var c=0;c<n;c+=2){if(a=i[c],o=i[c+1],h=i[(c+2)%n],o!=(l=i[(c+3)%n]))if(!(s.y<Math.min(o,l)))if(!(s.y>=Math.max(o,l)))(s.y-o)*(h-a)/(l-o)+a>s.x&&r++}return r%2==1},HitArea._cmds=[],s(HitArea,["_rect",function(){return this._rect=new gt},"_ptPoint",function(){return this._ptPoint=new et}]),HitArea}(),ht=function(){function AtlasInfoManager(){}return n(AtlasInfoManager,"laya.net.AtlasInfoManager"),AtlasInfoManager.enable=function(t,e){i.loader.load(t,l.create(null,AtlasInfoManager._onInfoLoaded,[e]),null,"json")},AtlasInfoManager._onInfoLoaded=function(t,e){var i,s,n,r=0,a=0;for(i in e)for(s=(n=e[i])[0],a=(n=n[1]).length,r=0;r<a;r++)AtlasInfoManager._fileLoadDic[s+n[r]]=i;t&&t.run()},AtlasInfoManager.getFileLoadPath=function(t){return AtlasInfoManager._fileLoadDic[t]||t},AtlasInfoManager._fileLoadDic={},AtlasInfoManager}(),lt=function(){function DrawTextureCmd(){}n(DrawTextureCmd,"laya.display.cmd.DrawTextureCmd");var t=DrawTextureCmd.prototype;return t.recover=function(){this.texture._removeReference(),this.texture=null,this.matrix=null,y.recover("DrawTextureCmd",this)},t.run=function(t,e,i){t.drawTextureWithTransform(this.texture,this.x,this.y,this.width,this.height,this.matrix,e,i,this.alpha,this.blendMode,this.colorFlt)},r(0,t,"cmdID",function(){return"DrawTexture"}),DrawTextureCmd.create=function(t,e,i,s,n,r,a,o,h){var l=y.getItemByClass("DrawTextureCmd",DrawTextureCmd);return l.texture=t,t._addReference(),l.x=e,l.y=i,l.width=s,l.height=n,l.matrix=r,l.alpha=a,l.color=o,l.blendMode=h,o&&(l.colorFlt=new Rt,l.colorFlt.setColor(o)),l},DrawTextureCmd.ID="DrawTexture",DrawTextureCmd}(),ct=function(){function WeakObject(){this._obj=null,this._obj=WeakObject.supportWeakMap?new P.window.WeakMap:{},WeakObject.supportWeakMap||WeakObject._maps.push(this)}n(WeakObject,"laya.utils.WeakObject");var t=WeakObject.prototype;return t.set=function(t,e){if(null!=t)if(WeakObject.supportWeakMap){var i=t;"string"!=typeof t&&"number"!=typeof t||(i=WeakObject._keys[t])||(i=WeakObject._keys[t]={k:t}),this._obj.set(i,e)}else"string"==typeof t||"number"==typeof t?this._obj[t]=e:(t.$_GID||(t.$_GID=_t.getGID()),this._obj[t.$_GID]=e)},t.get=function(t){if(null==t)return null;if(WeakObject.supportWeakMap){var e="string"==typeof t||"number"==typeof t?WeakObject._keys[t]:t;return e?this._obj.get(e):null}return"string"==typeof t||"number"==typeof t?this._obj[t]:this._obj[t.$_GID]},t.del=function(t){if(null!=t)if(WeakObject.supportWeakMap){var e="string"==typeof t||"number"==typeof t?WeakObject._keys[t]:t;if(!e)return;this._obj.delete(e)}else"string"==typeof t||"number"==typeof t?delete this._obj[t]:delete this._obj[this._obj.$_GID]},t.has=function(t){if(null==t)return!1;if(WeakObject.supportWeakMap){var e="string"==typeof t||"number"==typeof t?WeakObject._keys[t]:t;return this._obj.has(e)}return"string"==typeof t||"number"==typeof t?null!=this._obj[t]:null!=this._obj[this._obj.$_GID]},WeakObject.__init__=function(){WeakObject.supportWeakMap=null!=P.window.WeakMap,WeakObject.supportWeakMap||i.systemTimer.loop(WeakObject.delInterval,null,WeakObject.clearCache)},WeakObject.clearCache=function(){for(var t=0,e=WeakObject._maps.length;t<e;t++){WeakObject._maps[t]._obj={}}},WeakObject.supportWeakMap=!1,WeakObject.delInterval=6e5,WeakObject._keys={},WeakObject._maps=[],s(WeakObject,["I",function(){return this.I=new WeakObject}]),WeakObject}(),ut=function(){function UIConfig(){}return n(UIConfig,"UIConfig"),UIConfig.touchScrollEnable=!0,UIConfig.mouseWheelEnable=!0,UIConfig.showButtons=!0,UIConfig.popupBgColor="#000000",UIConfig.popupBgAlpha=.5,UIConfig.closeDialogOnSide=!0,UIConfig}(),_t=(function(){function Mouse(){}n(Mouse,"laya.utils.Mouse"),r(1,Mouse,"cursor",function(){return Mouse._style.cursor},function(t){Mouse._style.cursor=t}),Mouse.hide=function(){"none"!=Mouse.cursor&&(Mouse._preCursor=Mouse.cursor,Mouse.cursor="none")},Mouse.show=function(){"none"==Mouse.cursor&&(Mouse._preCursor?Mouse.cursor=Mouse._preCursor:Mouse.cursor="auto")},Mouse._preCursor=null,s(Mouse,["_style",function(){return this._style=P.document.body.style}])}(),function(){function Utils(){}return n(Utils,"laya.utils.Utils"),Utils.toRadian=function(t){return t*Utils._pi2},Utils.toAngle=function(t){return t*Utils._pi},Utils.toHexColor=function(t){if(t<0||isNaN(t))return null;for(var e=t.toString(16);e.length<6;)e="0"+e;return"#"+e},Utils.getGID=function(){return Utils._gid++},Utils.concatArray=function(t,e){if(!e)return t;if(!t)return e;var i=0,s=e.length;for(i=0;i<s;i++)t.push(e[i]);return t},Utils.clearArray=function(t){return t?(t.length=0,t):t},Utils.copyArray=function(t,e){if(t||(t=[]),!e)return t;t.length=e.length;var i=0,s=e.length;for(i=0;i<s;i++)t[i]=e[i];return t},Utils.getGlobalRecByPoints=function(t,e,i,s,n){var r,a;r=et.create().setTo(e,i),r=t.localToGlobal(r),a=et.create().setTo(s,n),a=t.localToGlobal(a);var o=gt._getWrapRec([r.x,r.y,a.x,a.y]);return r.recover(),a.recover(),o},Utils.getGlobalPosAndScale=function(t){return Utils.getGlobalRecByPoints(t,0,0,1,1)},Utils.bind=function(t,e){return t.bind(e)},Utils.measureText=function(t,e){return I.measureText(t,e)},Utils.updateOrder=function(t){if(!t||t.length<2)return!1;for(var e,i=1,s=0,n=t.length,r=NaN;i<n;){for(e=t[s=i],r=t[s]._zOrder;--s>-1&&t[s]._zOrder>r;)t[s+1]=t[s];t[s+1]=e,i++}return!0},Utils.transPointList=function(t,e,i){var s=0,n=t.length;for(s=0;s<n;s+=2)t[s]+=e,t[s+1]+=i},Utils.parseInt=function(t,e){void 0===e&&(e=0);var i=P.window.parseInt(t,e);return isNaN(i)?0:i},Utils.getFileExtension=function(t){Utils._extReg.lastIndex=t.lastIndexOf(".");var e=Utils._extReg.exec(t);return e&&e.length>1?e[1].toLowerCase():null},Utils.getTransformRelativeToWindow=function(t,e,s){var n=i.stage,r=laya.utils.Utils.getGlobalPosAndScale(t),a=n._canvasTransform.clone(),o=a.tx,h=a.ty;a.rotate(-Math.PI/180*i.stage.canvasDegree),a.scale(i.stage.clientScaleX,i.stage.clientScaleY);var l=i.stage.canvasDegree%180!=0,c=NaN,u=NaN;l?(c=s+r.y,u=e+r.x,c*=a.d,u*=a.a,90==i.stage.canvasDegree?(c=o-c,u+=h):(c+=o,u=h-u)):(c=e+r.x,u=s+r.y,c*=a.a,u*=a.d,c+=o,u+=h),u+=i.stage._safariOffsetY;var _=NaN,d=NaN;return l?(_=a.d*r.height,d=a.a*r.width):(_=a.a*r.width,d=a.d*r.height),{x:c,y:u,scaleX:_,scaleY:d}},Utils.fitDOMElementInArea=function(t,e,s,n,r,a){t._fitLayaAirInitialized||(t._fitLayaAirInitialized=!0,t.style.transformOrigin=t.style.webKittransformOrigin="left top",t.style.position="absolute");var o=Utils.getTransformRelativeToWindow(e,s,n);t.style.transform=t.style.webkitTransform="scale("+o.scaleX+","+o.scaleY+") rotate("+i.stage.canvasDegree+"deg)",t.style.width=r+"px",t.style.height=a+"px",t.style.left=o.x+"px",t.style.top=o.y+"px"},Utils.isOkTextureList=function(t){if(!t)return!1;var e,i=0,s=t.length;for(i=0;i<s;i++)if(!(e=t[i])||!e._getSource())return!1;return!0},Utils.isOKCmdList=function(t){if(!t)return!1;var e=0,i=t.length;for(e=0;e<i;e++)t[e];return!0},Utils.getQueryString=function(e){if(P.onMiniGame)return null;var i=new RegExp("(^|&)"+e+"=([^&]*)(&|$)"),s=t.location.search.substr(1).match(i);return null!=s?unescape(s[2]):null},Utils._gid=1,Utils._pi=180/Math.PI,Utils._pi2=Math.PI/180,Utils._extReg=/\.(\w+)\??/g,Utils.parseXMLFromString=function(t){var e;if(t=t.replace(/>\s+</g,"><"),(e=(new DOMParser).parseFromString(t,"text/xml")).firstChild.textContent.indexOf("This page contains the following errors")>-1)throw new Error(e.firstChild.firstChild.textContent);return e},Utils}()),dt=function(){function ClassUtils(){}return n(ClassUtils,"laya.utils.ClassUtils"),ClassUtils.regClass=function(t,e){ClassUtils._classMap[t]=e},ClassUtils.regShortClassName=function(t){for(var e=0;e<t.length;e++){var i=t[e],s=i.name;ClassUtils._classMap[s]=i}},ClassUtils.getRegClass=function(t){return ClassUtils._classMap[t]},ClassUtils.getClass=function(t){var e=ClassUtils._classMap[t]||t;return"string"==typeof e?i.__classmap[e]||i[t]:e},ClassUtils.getInstance=function(t){var e=ClassUtils.getClass(t);return e?new e:(console.warn("[error] Undefined class:",t),null)},ClassUtils.createByJson=function(t,e,i,s,n){"string"==typeof t&&(t=JSON.parse(t));var r=t.props;if(!e&&!(e=n?n.runWith(t):ClassUtils.getInstance(r.runtime||t.type)))return null;var a=t.child;if(a)for(var o=0,h=a.length;o<h;o++){var l=a[o];if("render"!==l.props.name&&"render"!==l.props.renderType||!e._$set_itemRender)if("Graphic"==l.type)ClassUtils._addGraphicsToSprite(l,e);else if(ClassUtils._isDrawType(l.type))ClassUtils._addGraphicToSprite(l,e,!0);else{var c=ClassUtils.createByJson(l,null,i,s,n);"Script"===l.type?c.hasOwnProperty("owner")?c.owner=e:c.hasOwnProperty("target")&&(c.target=e):"mask"==l.props.renderType?e.mask=c:e.addChild(c)}else e.itemRender=l}if(r)for(var u in r){var _=r[u];"var"===u&&i?i[_]=e:_ instanceof Array&&"function"==typeof e[u]?e[u].apply(e,_):e[u]=_}return s&&t.customProps&&s.runWith([e,t]),e.created&&e.created(),e},ClassUtils._addGraphicsToSprite=function(t,e){var i=t.child;if(i&&!(i.length<1)){var s=ClassUtils._getGraphicsFromSprite(t,e),n=0,r=0;t.props&&(n=ClassUtils._getObjVar(t.props,"x",0),r=ClassUtils._getObjVar(t.props,"y",0)),0!=n&&0!=r&&s.translate(n,r);var a,o=0;for(a=i.length,o=0;o<a;o++)ClassUtils._addGraphicToGraphics(i[o],s);0!=n&&0!=r&&s.translate(-n,-r)}},ClassUtils._addGraphicToSprite=function(t,e,i){void 0===i&&(i=!1);var s=i?ClassUtils._getGraphicsFromSprite(t,e):e.graphics;ClassUtils._addGraphicToGraphics(t,s)},ClassUtils._getGraphicsFromSprite=function(t,e){if(!t||!t.props)return e.graphics;var i=t.props.renderType;if("hit"===i||"unHit"===i){var s=e._style.hitArea||(e.hitArea=new ot);s[i]||(s[i]=new G);var n=s[i]}return n||(n=e.graphics),n},ClassUtils._getTransformData=function(t){var e;(t.hasOwnProperty("pivotX")||t.hasOwnProperty("pivotY"))&&(e=e||new Z).translate(-ClassUtils._getObjVar(t,"pivotX",0),-ClassUtils._getObjVar(t,"pivotY",0));var i=ClassUtils._getObjVar(t,"scaleX",1),s=ClassUtils._getObjVar(t,"scaleY",1),n=ClassUtils._getObjVar(t,"rotation",0);ClassUtils._getObjVar(t,"skewX",0),ClassUtils._getObjVar(t,"skewY",0);return 1==i&&1==s&&0==n||((e=e||new Z).scale(i,s),e.rotate(.0174532922222222*n)),e},ClassUtils._addGraphicToGraphics=function(t,e){var i,s;if((i=t.props)&&(s=ClassUtils.DrawTypeDic[t.type])){var n=e,r=ClassUtils._getParams(i,s[1],s[2],s[3]),a=ClassUtils._tM;(a||1!=ClassUtils._alpha)&&(n.save(),a&&n.transform(a),1!=ClassUtils._alpha&&n.alpha(ClassUtils._alpha)),n[s[0]].apply(n,r),(a||1!=ClassUtils._alpha)&&n.restore()}},ClassUtils._adptLineData=function(t){return t[2]=parseFloat(t[0])+parseFloat(t[2]),t[3]=parseFloat(t[1])+parseFloat(t[3]),t},ClassUtils._adptTextureData=function(t){return t[0]=Ft.getRes(t[0]),t},ClassUtils._adptLinesData=function(t){return t[2]=ClassUtils._getPointListByStr(t[2]),t},ClassUtils._isDrawType=function(t){return"Image"!==t&&ClassUtils.DrawTypeDic.hasOwnProperty(t)},ClassUtils._getParams=function(t,e,i,s){void 0===i&&(i=0);var n=ClassUtils._temParam;n.length=e.length;var r,a,o=0;for(r=e.length,o=0;o<r;o++)n[o]=ClassUtils._getObjVar(t,e[o][0],e[o][1]);return ClassUtils._alpha=ClassUtils._getObjVar(t,"alpha",1),(a=ClassUtils._getTransformData(t))?(i||(i=0),a.translate(n[i],n[i+1]),n[i]=n[i+1]=0,ClassUtils._tM=a):ClassUtils._tM=null,s&&ClassUtils[s]&&(n=ClassUtils[s](n)),n},ClassUtils._getPointListByStr=function(t){var e,i=t.split(","),s=0;for(e=i.length,s=0;s<e;s++)i[s]=parseFloat(i[s]);return i},ClassUtils._getObjVar=function(t,e,i){return t.hasOwnProperty(e)?t[e]:i},ClassUtils._temParam=[],ClassUtils._classMap={Sprite:Yt,Scene:Xt,Text:zt,Animation:"laya.display.Animation",Skeleton:"laya.ani.bone.Skeleton",Particle2D:"laya.particle.Particle2D",div:"laya.html.dom.HTMLDivParser",p:"laya.html.dom.HTMLElement",img:"laya.html.dom.HTMLImageElement",span:"laya.html.dom.HTMLElement",br:"laya.html.dom.HTMLBrElement",style:"laya.html.dom.HTMLStyleElement",font:"laya.html.dom.HTMLElement",a:"laya.html.dom.HTMLElement","#text":"laya.html.dom.HTMLElement",link:"laya.html.dom.HTMLLinkElement"},ClassUtils._tM=null,ClassUtils._alpha=NaN,s(ClassUtils,["DrawTypeDic",function(){return this.DrawTypeDic={Rect:["drawRect",[["x",0],["y",0],["width",0],["height",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],Circle:["drawCircle",[["x",0],["y",0],["radius",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],Pie:["drawPie",[["x",0],["y",0],["radius",0],["startAngle",0],["endAngle",0],["fillColor",null],["lineColor",null],["lineWidth",1]]],Image:["drawTexture",[["x",0],["y",0],["width",0],["height",0]]],Texture:["drawTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0]],1,"_adptTextureData"],FillTexture:["fillTexture",[["skin",null],["x",0],["y",0],["width",0],["height",0],["repeat",null]],1,"_adptTextureData"],FillText:["fillText",[["text",""],["x",0],["y",0],["font",null],["color",null],["textAlign",null]],1],Line:["drawLine",[["x",0],["y",0],["toX",0],["toY",0],["lineColor",null],["lineWidth",0]],0,"_adptLineData"],Lines:["drawLines",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],Curves:["drawCurves",[["x",0],["y",0],["points",""],["lineColor",null],["lineWidth",0]],0,"_adptLinesData"],Poly:["drawPoly",[["x",0],["y",0],["points",""],["fillColor",null],["lineColor",null],["lineWidth",1]],0,"_adptLinesData"]}}]),ClassUtils}(),ft=function(){function Bezier(){this._controlPoints=[new et,new et,new et],this._calFun=this.getPoint2}n(Bezier,"laya.maths.Bezier");var t=Bezier.prototype;return t._switchPoint=function(t,e){var i=this._controlPoints.shift();i.setTo(t,e),this._controlPoints.push(i)},t.getPoint2=function(t,e){var i=this._controlPoints[0],s=this._controlPoints[1],n=this._controlPoints[2],r=Math.pow(1-t,2)*i.x+2*t*(1-t)*s.x+Math.pow(t,2)*n.x,a=Math.pow(1-t,2)*i.y+2*t*(1-t)*s.y+Math.pow(t,2)*n.y;e.push(r,a)},t.getPoint3=function(t,e){var i=this._controlPoints[0],s=this._controlPoints[1],n=this._controlPoints[2],r=this._controlPoints[3],a=Math.pow(1-t,3)*i.x+3*s.x*t*(1-t)*(1-t)+3*n.x*t*t*(1-t)+r.x*Math.pow(t,3),o=Math.pow(1-t,3)*i.y+3*s.y*t*(1-t)*(1-t)+3*n.y*t*t*(1-t)+r.y*Math.pow(t,3);e.push(a,o)},t.insertPoints=function(t,e){var i,s=NaN;for(i=1/(t=t>0?t:5),s=0;s<=1;s+=i)this._calFun(s,e)},t.getBezierPoints=function(t,e,i){void 0===e&&(e=5),void 0===i&&(i=2);var s,n=0;if((s=t.length)<2*(i+1))return[];var r=[];switch(i){case 2:this._calFun=this.getPoint2;break;case 3:this._calFun=this.getPoint3;break;default:return[]}for(;this._controlPoints.length<=i;)this._controlPoints.push(et.create());for(n=0;n<2*i;n+=2)this._switchPoint(t[n],t[n+1]);for(n=2*i;n<s;n+=2)this._switchPoint(t[n],t[n+1]),n/2%i==0&&this.insertPoints(e,r);return r},s(Bezier,["I",function(){return this.I=new Bezier}]),Bezier}(),pt=(function(){function Config3D(){this._defaultPhysicsMemory=16,this._editerEnvironment=!1,this.isAntialias=!0,this.isAlpha=!1,this.premultipliedAlpha=!0,this.isStencil=!0}n(Config3D,"Config3D");var t=Config3D.prototype;r(0,t,"defaultPhysicsMemory",function(){return this._defaultPhysicsMemory},function(t){if(t<16)throw"defaultPhysicsMemory must large than 16M";this._defaultPhysicsMemory=t}),s(Config3D,["_defaultConfig",function(){return this._defaultConfig=new Config3D}])}(),function(){function RotateCmd(){}n(RotateCmd,"laya.display.cmd.RotateCmd");var t=RotateCmd.prototype;return t.recover=function(){y.recover("RotateCmd",this)},t.run=function(t,e,i){t._rotate(this.angle,this.pivotX+e,this.pivotY+i)},r(0,t,"cmdID",function(){return"Rotate"}),RotateCmd.create=function(t,e,i){var s=y.getItemByClass("RotateCmd",RotateCmd);return s.angle=t,s.pivotX=e,s.pivotY=i,s},RotateCmd.ID="Rotate",RotateCmd}()),gt=function(){function Rectangle(t,e,i,s){void 0===t&&(t=0),void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=0),this.x=t,this.y=e,this.width=i,this.height=s}n(Rectangle,"laya.maths.Rectangle");var t=Rectangle.prototype;return t.setTo=function(t,e,i,s){return this.x=t,this.y=e,this.width=i,this.height=s,this},t.reset=function(){return this.x=this.y=this.width=this.height=0,this},t.recover=function(){y.recover("Rectangle",this.reset())},t.copyFrom=function(t){return this.x=t.x,this.y=t.y,this.width=t.width,this.height=t.height,this},t.contains=function(t,e){return!(this.width<=0||this.height<=0)&&(t>=this.x&&t<this.right&&e>=this.y&&e<this.bottom)},t.intersects=function(t){return!(t.x>this.x+this.width||t.x+t.width<this.x||t.y>this.y+this.height||t.y+t.height<this.y)},t.intersection=function(t,e){return this.intersects(t)?(e||(e=new Rectangle),e.x=Math.max(this.x,t.x),e.y=Math.max(this.y,t.y),e.width=Math.min(this.right,t.right)-e.x,e.height=Math.min(this.bottom,t.bottom)-e.y,e):null},t.union=function(t,e){return e||(e=new Rectangle),this.clone(e),t.width<=0||t.height<=0?e:(e.addPoint(t.x,t.y),e.addPoint(t.right,t.bottom),this)},t.clone=function(t){return t||(t=new Rectangle),t.x=this.x,t.y=this.y,t.width=this.width,t.height=this.height,t},t.toString=function(){return this.x+","+this.y+","+this.width+","+this.height},t.equals=function(t){return!(!t||t.x!==this.x||t.y!==this.y||t.width!==this.width||t.height!==this.height)},t.addPoint=function(t,e){return this.x>t&&(this.width+=this.x-t,this.x=t),this.y>e&&(this.height+=this.y-e,this.y=e),this.width<t-this.x&&(this.width=t-this.x),this.height<e-this.y&&(this.height=e-this.y),this},t._getBoundPoints=function(){var t=Rectangle._temB;return t.length=0,0==this.width||0==this.height?t:(t.push(this.x,this.y,this.x+this.width,this.y,this.x,this.y+this.height,this.x+this.width,this.y+this.height),t)},t.isEmpty=function(){return this.width<=0||this.height<=0},r(0,t,"right",function(){return this.x+this.width}),r(0,t,"bottom",function(){return this.y+this.height}),Rectangle.create=function(){return y.getItemByClass("Rectangle",Rectangle)},Rectangle._getBoundPointS=function(t,e,i,s){var n=Rectangle._temA;return n.length=0,0==i||0==s?n:(n.push(t,e,t+i,e,t,e+s,t+i,e+s),n)},Rectangle._getWrapRec=function(t,e){if(!t||t.length<1)return e?e.setTo(0,0,0,0):Rectangle.TEMP.setTo(0,0,0,0);e=e||laya.maths.Rectangle.create();var i,s,n,r,a,o=t.length,h=et.TEMP;for(n=a=-(s=r=99999),i=0;i<o;i+=2)h.x=t[i],h.y=t[i+1],s=s<h.x?s:h.x,r=r<h.y?r:h.y,n=n>h.x?n:h.x,a=a>h.y?a:h.y;return e.setTo(s,r,n-s,a-r)},Rectangle.EMPTY=new Rectangle,Rectangle.TEMP=new Rectangle,Rectangle._temB=[],Rectangle._temA=[],Rectangle}(),mt=function(){function GraphicsBounds(){this._cacheBoundsType=!1}n(GraphicsBounds,"laya.display.GraphicsBounds");var t=GraphicsBounds.prototype;return t.destroy=function(){this._graphics=null,this._cacheBoundsType=!1,this._temp&&(this._temp.length=0),this._rstBoundPoints&&(this._rstBoundPoints.length=0),this._bounds&&this._bounds.recover(),this._bounds=null,y.recover("GraphicsBounds",this)},t.reset=function(){this._temp&&(this._temp.length=0)},t.getBounds=function(t){return void 0===t&&(t=!1),(!this._bounds||!this._temp||this._temp.length<1||t!=this._cacheBoundsType)&&(this._bounds=gt._getWrapRec(this.getBoundPoints(t),this._bounds)),this._cacheBoundsType=t,this._bounds},t.getBoundPoints=function(t){return void 0===t&&(t=!1),(!this._temp||this._temp.length<1||t!=this._cacheBoundsType)&&(this._temp=this._getCmdPoints(t)),this._cacheBoundsType=t,this._rstBoundPoints=_t.copyArray(this._rstBoundPoints,this._temp)},t._getCmdPoints=function(t){void 0===t&&(t=!1);xt._context;var e,i=this._graphics.cmds;if((e=this._temp||(this._temp=[])).length=0,i||null==this._graphics._one||(GraphicsBounds._tempCmds.length=0,GraphicsBounds._tempCmds.push(this._graphics._one),i=GraphicsBounds._tempCmds),!i)return e;var s=GraphicsBounds._tempMatrixArrays;s.length=0;var n=GraphicsBounds._initMatrix;n.identity();for(var r,a,o=GraphicsBounds._tempMatrix,h=0,l=i.length;h<l;h++)switch((r=i[h]).cmdID){case"Alpha":s.push(n),n=n.clone();break;case"Restore":n=s.pop();break;case"Scale":o.identity(),o.translate(-r.pivotX,-r.pivotY),o.scale(r.scaleX,r.scaleY),o.translate(r.pivotX,r.pivotY),this._switchMatrix(n,o);break;case"Rotate":o.identity(),o.translate(-r.pivotX,-r.pivotY),o.rotate(r.angle),o.translate(r.pivotX,r.pivotY),this._switchMatrix(n,o);break;case"Translate":o.identity(),o.translate(r.tx,r.ty),this._switchMatrix(n,o);break;case"Transform":o.identity(),o.translate(-r.pivotX,-r.pivotY),o.concat(r.matrix),o.translate(r.pivotX,r.pivotY),this._switchMatrix(n,o);break;case"DrawImage":case"FillTexture":GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),n);break;case"DrawTexture":n.copyTo(o),r.matrix&&o.concat(r.matrix),GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),o);break;case"DrawImage":if(a=r.texture,t)r.width&&r.height?GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),n):GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,a.width,a.height),n);else{var c=(r.width||a.sourceWidth)/a.width,u=(r.height||a.sourceHeight)/a.height,_=c*a.sourceWidth,d=u*a.sourceHeight,f=a.offsetX>0?a.offsetX:0,p=a.offsetY>0?a.offsetY:0;f*=c,p*=u,GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x-f,r.y-p,_,d),n)}break;case"FillTexture":r.width&&r.height?GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),n):(a=r.texture,GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,a.width,a.height),n));break;case"DrawTexture":var g;r.matrix?(n.copyTo(o),o.concat(r.matrix),g=o):g=n,t?r.width&&r.height?GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),g):(a=r.texture,GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,a.width,a.height),g)):(a=r.texture,c=(r.width||a.sourceWidth)/a.width,u=(r.height||a.sourceHeight)/a.height,_=c*a.sourceWidth,d=u*a.sourceHeight,f=a.offsetX>0?a.offsetX:0,p=a.offsetY>0?a.offsetY:0,f*=c,p*=u,GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x-f,r.y-p,_,d),g));break;case"DrawRect":GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x,r.y,r.width,r.height),n);break;case"DrawCircle":GraphicsBounds._addPointArrToRst(e,gt._getBoundPointS(r.x-r.radius,r.y-r.radius,r.radius+r.radius,r.radius+r.radius),n);break;case"DrawLine":GraphicsBounds._tempPoints.length=0;var m;m=.5*r.lineWidth,r.fromX==r.toX?GraphicsBounds._tempPoints.push(r.fromX+m,r.fromY,r.toX+m,r.toY,r.fromX-m,r.fromY,r.toX-m,r.toY):r.fromY==r.toY?GraphicsBounds._tempPoints.push(r.fromX,r.fromY+m,r.toX,r.toY+m,r.fromX,r.fromY-m,r.toX,r.toY-m):GraphicsBounds._tempPoints.push(r.fromX,r.fromY,r.toX,r.toY),GraphicsBounds._addPointArrToRst(e,GraphicsBounds._tempPoints,n);break;case"DrawCurves":GraphicsBounds._addPointArrToRst(e,ft.I.getBezierPoints(r.points),n,r.x,r.y);break;case"DrawLines":case"DrawPoly":GraphicsBounds._addPointArrToRst(e,r.points,n,r.x,r.y);break;case"DrawPath":GraphicsBounds._addPointArrToRst(e,this._getPathPoints(r.paths),n,r.x,r.y);break;case"DrawPie":GraphicsBounds._addPointArrToRst(e,this._getPiePoints(r.x,r.y,r.radius,r.startAngle,r.endAngle),n)}return e.length>200?e=_t.copyArray(e,gt._getWrapRec(e)._getBoundPoints()):e.length>8&&(e=$.scanPList(e)),e},t._switchMatrix=function(t,e){e.concat(t),e.copyTo(t)},t._getPiePoints=function(t,e,i,s,n){var r=GraphicsBounds._tempPoints;GraphicsBounds._tempPoints.length=0,r.push(t,e);var a=Math.PI/10,o=NaN;for(o=s;o<n;o+=a)r.push(t+i*Math.cos(o),e+i*Math.sin(o));return n!=o&&r.push(t+i*Math.cos(n),e+i*Math.sin(n)),r},t._getPathPoints=function(t){var e,i,s=0,n=GraphicsBounds._tempPoints;for(n.length=0,e=t.length,s=0;s<e;s++)(i=t[s]).length>1&&(n.push(i[1],i[2]),i.length>3&&n.push(i[3],i[4]));return n},GraphicsBounds.create=function(){return y.getItemByClass("GraphicsBounds",GraphicsBounds)},GraphicsBounds._addPointArrToRst=function(t,e,i,s,n){void 0===s&&(s=0),void 0===n&&(n=0);var r,a=0;for(r=e.length,a=0;a<r;a+=2)GraphicsBounds._addPointToRst(t,e[a]+s,e[a+1]+n,i)},GraphicsBounds._addPointToRst=function(t,e,i,s){var n=et.TEMP;n.setTo(e||0,i||0),s.transformPoint(n),t.push(n.x,n.y)},GraphicsBounds._tempPoints=[],GraphicsBounds._tempMatrixArrays=[],GraphicsBounds._tempCmds=[],s(GraphicsBounds,["_tempMatrix",function(){return this._tempMatrix=new Z},"_initMatrix",function(){return this._initMatrix=new Z}]),GraphicsBounds}(),vt=function(){function CacheManger(){}return n(CacheManger,"laya.utils.CacheManger"),CacheManger.regCacheByFunction=function(t,e){var i;CacheManger.unRegCacheByFunction(t,e),i={tryDispose:t,getCacheList:e},CacheManger._cacheList.push(i)},CacheManger.unRegCacheByFunction=function(t,e){var i,s=0;for(i=CacheManger._cacheList.length,s=0;s<i;s++)if(CacheManger._cacheList[s].tryDispose==t&&CacheManger._cacheList[s].getCacheList==e)return void CacheManger._cacheList.splice(s,1)},CacheManger.forceDispose=function(){var t=0,e=CacheManger._cacheList.length;for(t=0;t<e;t++)CacheManger._cacheList[t].tryDispose(!0)},CacheManger.beginCheck=function(t){void 0===t&&(t=15e3),i.systemTimer.loop(t,null,CacheManger._checkLoop)},CacheManger.stopCheck=function(){i.systemTimer.clear(null,CacheManger._checkLoop)},CacheManger._checkLoop=function(){var t=CacheManger._cacheList;if(!(t.length<1)){var e,i=P.now(),s=0;for(e=s=t.length;s>0&&(CacheManger._index++,CacheManger._index=CacheManger._index%e,t[CacheManger._index].tryDispose(!1),!(P.now()-i>CacheManger.loopTimeLimit));)s--}},CacheManger.loopTimeLimit=2,CacheManger._cacheList=[],CacheManger._index=0,CacheManger}(),yt=function(){function MiniImage(){}return n(MiniImage,"laya.wx.mini.MiniImage"),MiniImage.prototype._loadImage=function(t){if(b.isZiYu)MiniImage.onCreateImage(v.formatURL(t),this,!0);else{var e=!1;if(U.isLocalNativeFile(t)){if(-1!=t.indexOf("http://")||-1!=t.indexOf("https://"))if(""!=U.loadPath)t=t.split(U.loadPath)[1];else{var i=""!=v.rootPath?v.rootPath:v.basePath,s=t;""!=i&&(t=t.split(i)[1]),t||(t=s)}if(b.subNativeFiles&&0==b.subNativeheads.length)for(var n in b.subNativeFiles){var r=b.subNativeFiles[n];b.subNativeheads=b.subNativeheads.concat(r);for(var a=0;a<r.length;a++)b.subMaps[r[a]]=n+"/"+r[a]}if(b.subNativeFiles&&-1!=t.indexOf("/")){var o=t.split("/")[0]+"/";if(o&&-1!=b.subNativeheads.indexOf(o)){var h=b.subMaps[o];t=t.replace(o,h)}}}else e=!0,t=v.formatURL(t);U.getFileInfo(t)?MiniImage.onCreateImage(t,this,!e):-1!=t.indexOf("http://")||-1!=t.indexOf("https://")?b.isZiYu?MiniImage.onCreateImage(t,this,!0):U.downOtherFiles(t,new l(MiniImage,MiniImage.onDownImgCallBack,[t,this]),t):MiniImage.onCreateImage(t,this,!0)}},MiniImage.onDownImgCallBack=function(t,e,i,s){void 0===s&&(s=""),i?e.onError(null):MiniImage.onCreateImage(t,e,!1,s)},MiniImage.onCreateImage=function(t,e,i,s){var n,r;if(void 0===i&&(i=!1),void 0===s&&(s=""),b.autoCacheFile)if(i)if(b.isZiYu){var a=v.formatURL(t);n=U.ziyuFileTextureData[a]?U.ziyuFileTextureData[a]:t}else n=t;else if(""!=s)n=s;else{var o=U.getFileInfo(t).md5;n=U.getFileNativePath(o)}else n=i?t:s;function clear(){var t=e._imgCache[n];t&&(t.onload=null,t.onerror=null,delete e._imgCache[n])}null==e._imgCache&&(e._imgCache={});var h=function(){clear(),e.event("error","Load image failed")};if("nativeimage"==e._type){var l=function(){clear(),e._url=v.formatURL(e._url),e.onLoaded(r)};(r=new P.window.Image).crossOrigin="",r.onload=l,r.onerror=h,r.src=n,e._imgCache[n]=r}else{var c=new P.window.Image;l=function(){e._url=v.formatURL(e._url),(r=qt.create(c.width,c.height)).loadImageSource(c,!0),r._setCreateURL(n),clear(),e.onLoaded(r)},c.crossOrigin="",c.onload=l,c.onerror=h,c.src=n,e._imgCache[n]=c}},MiniImage}(),Ct=function(){function RenderSprite(t,e){if(a.map[t])return this._fun=a.map[t],void(this._next=RenderSprite.NORENDER);switch(this._next=e||RenderSprite.NORENDER,t){case 0:return void(this._fun=this._no);case 1:return void(this._fun=this._alpha);case 2:return void(this._fun=this._transform);case 4:return void(this._fun=this._blend);case 8:return void(this._fun=this._canvas);case 32:return void(this._fun=this._mask);case 64:return void(this._fun=this._clip);case 128:return void(this._fun=this._style);case 512:return void(this._fun=this._graphics);case 8192:return void(this._fun=this._children);case 2048:return void(this._fun=this._custom);case 256:return void(this._fun=this._texture);case 16:return void(this._fun=c._filter);case 69905:return void(this._fun=RenderSprite._initRenderFun)}this.onCreate(t)}n(RenderSprite,"laya.renders.RenderSprite");var t=RenderSprite.prototype;return t.onCreate=function(t){},t._style=function(t,e,i,s){var n=t._style;null!=n.render&&n.render(t,e,i,s);var r=this._next;r._fun.call(r,t,e,i,s)},t._no=function(t,e,i,s){},t._custom=function(t,e,i,s){t.customRender(e,i,s),this._next._fun.call(this._next,t,e,i-t.pivotX,s-t.pivotY)},t._clip=function(t,e,i,s){var n=this._next;if(n!=RenderSprite.NORENDER){var r=t._style.scrollRect;e.save(),e.clipRect(i,s,r.width,r.height),n._fun.call(n,t,e,i-r.x,s-r.y),e.restore()}},t._blend=function(t,e,i,s){var n=t._style;n.blendMode&&(e.globalCompositeOperation=n.blendMode);var r=this._next;r._fun.call(r,t,e,i,s),e.globalCompositeOperation="source-over"},t._mask=function(t,e,i,s){var n=this._next;n._fun.call(n,t,e,i,s);var r=t.mask;r&&(e.globalCompositeOperation="destination-in",(r.numChildren>0||!r.graphics._isOnlyOne())&&(r.cacheAs="bitmap"),r.render(e,i-t._style.pivotX,s-t._style.pivotY)),e.globalCompositeOperation="source-over"},t._texture=function(t,e,i,s){var n=t.texture;n._getSource()&&e.drawTexture(n,i-t.pivotX+n.offsetX,s-t.pivotY+n.offsetY,t._width||n.width,t._height||n.height);var r=this._next;r._fun.call(r,t,e,i,s)},t._graphics=function(t,e,i,s){t._graphics&&t._graphics._render(t,e,i-t.pivotX,s-t.pivotY);var n=this._next;n._fun.call(n,t,e,i,s)},t._image=function(t,e,i,s){var n=t._style;e.drawTexture2(i,s,n.pivotX,n.pivotY,t.transform,t._graphics._one)},t._image2=function(t,e,i,s){var n=t._style;e.drawTexture2(i,s,n.pivotX,n.pivotY,t.transform,t._graphics._one)},t._alpha=function(t,e,i,s){var n;if((n=t._style.alpha)>.01||t._needRepaint()){var r=e.globalAlpha;e.globalAlpha*=n;var a=this._next;a._fun.call(a,t,e,i,s),e.globalAlpha=r}},t._transform=function(t,e,i,s){var n=t.transform,r=this._next;t._style;n&&r!=RenderSprite.NORENDER?(e.save(),e.transform(n.a,n.b,n.c,n.d,n.tx+i,n.ty+s),r._fun.call(r,t,e,0,0),e.restore()):r._fun.call(r,t,e,i,s)},t._children=function(t,e,i,s){var n,r=t._style,a=t._children,o=a.length;i-=t.pivotX,s-=t.pivotY;var h=t._getBit(256)&&e.drawCallOptimize(!0);if(r.viewport){var l=r.viewport,c=l.x,u=l.y,_=l.right,d=l.bottom,f=NaN,p=NaN;for(g=0;g<o;++g)(n=a[g])._visible&&(f=n._x)<_&&f+n.width>c&&(p=n._y)<d&&p+n.height>u&&n.render(e,i,s)}else for(var g=0;g<o;++g)(n=a[g])._visible&&n.render(e,i,s);h&&e.drawCallOptimize(!1)},t._canvas=function(t,e,s,n){var r=t._cacheStyle,a=this._next;if(r.enableCanvasRender){"bitmap"===r.cacheAs?Tt.canvasBitmap++:Tt.canvasNormal++;var o=!1,h=!1;if(xt.isWebGL&&r.canvas){var l=r.canvas,c=(l.context,l.touches);if(c)for(var u=0;u<c.length;u++)if(c[u].deleted){h=!0;break}o=l.isCacheValid&&!l.isCacheValid()}if(t._needRepaint()||!r.canvas||h||o||i.stage.isGlobalRepaint())if(xt.isWebGL&&"normal"===r.cacheAs){if(e._targets)return void a._fun.call(a,t,e,s,n);this._canvas_webgl_normal_repaint(t,e)}else this._canvas_repaint(t,e,s,n);var _=r.cacheRect;e.drawCanvas(r.canvas,s+_.x,n+_.y,_.width,_.height)}else a._fun.call(a,t,e,s,n)},t._canvas_repaint=function(t,e,i,s){var n,r,a,o,h,l,c,u,_,d=t._cacheStyle,f=this._next,p=d.canvas,g=d.cacheAs;if(c=(_=d._calculateCacheRect(t,g,i,s)).x,u=_.y,h=(o=d.cacheRect).width*c,l=o.height*u,r=o.x,a=o.y,xt.isWebGL&&"bitmap"===g&&(h>2048||l>2048))return console.warn("cache bitmap size larger than 2048,cache ignored"),d.releaseContext(),void f._fun.call(f,t,e,i,s);if(p||(d.createContext(),p=d.canvas),(n=p.context).sprite=t,(p.width!=h||p.height!=l)&&p.size(h,l),"bitmap"===g?n.asBitmap=!0:"normal"===g&&(n.asBitmap=!1),n.clear(),1!=c||1!=u){var m=n;m.save(),m.scale(c,u),f._fun.call(f,t,n,-r,-a),m.restore(),t._applyFilters()}else m=n,f._fun.call(f,t,n,-r,-a),t._applyFilters();d.staticCache&&(d.reCache=!1),Tt.canvasReCache++},t._canvas_webgl_normal_repaint=function(t,e){var s=t._cacheStyle,n=this._next,r=s.canvas,a=s.cacheAs;s._calculateCacheRect(t,a,0,0);r||(r=s.canvas=new i.WebGLCacheAsNormalCanvas(e,t));var o=r.context;r.startRec(),n._fun.call(n,t,o,t.pivotX,t.pivotY),t._applyFilters(),Tt.canvasReCache++,r.endRec()},RenderSprite.__init__=function(){a.__init__();var t,e,i=0;for(e=I.createRenderSprite(69905,null),t=RenderSprite.renders.length=16384,i=0;i<t;i++)RenderSprite.renders[i]=e;RenderSprite.renders[0]=I.createRenderSprite(0,null)},RenderSprite._initRenderFun=function(t,e,i,s){var n=t._renderType;(RenderSprite.renders[n]=RenderSprite._getTypeRender(n))._fun(t,e,i,s)},RenderSprite._getTypeRender=function(t){if(a.map[t])return I.createRenderSprite(t,null);for(var e=null,i=8192;i>0;)i&t&&(e=I.createRenderSprite(i,e)),i>>=1;return e},RenderSprite.INIT=69905,RenderSprite.renders=[],RenderSprite.NORENDER=new RenderSprite(0,null),RenderSprite}(),wt=function(){function FillWordsCmd(){}n(FillWordsCmd,"laya.display.cmd.FillWordsCmd");var t=FillWordsCmd.prototype;return t.recover=function(){this.words=null,y.recover("FillWordsCmd",this)},t.run=function(t,e,i){t.fillWords(this.words,this.x+e,this.y+i,this.font,this.color)},r(0,t,"cmdID",function(){return"FillWords"}),FillWordsCmd.create=function(t,e,i,s,n){var r=y.getItemByClass("FillWordsCmd",FillWordsCmd);return r.words=t,r.x=e,r.y=i,r.font=s,r.color=n,r},FillWordsCmd.ID="FillWords",FillWordsCmd}(),St=function(){function TransformCmd(){}n(TransformCmd,"laya.display.cmd.TransformCmd");var t=TransformCmd.prototype;return t.recover=function(){this.matrix=null,y.recover("TransformCmd",this)},t.run=function(t,e,i){t._transform(this.matrix,this.pivotX+e,this.pivotY+i)},r(0,t,"cmdID",function(){return"Transform"}),TransformCmd.create=function(t,e,i){var s=y.getItemByClass("TransformCmd",TransformCmd);return s.matrix=t,s.pivotX=e,s.pivotY=i,s},TransformCmd.ID="Transform",TransformCmd}(),xt=(function(){function DrawCanvasCmd(){this._graphicsCmdEncoder=null,this._index=0,this._paramData=null,this.texture=null,this.x=NaN,this.y=NaN,this.width=NaN,this.height=NaN}n(DrawCanvasCmd,"laya.display.cmd.DrawCanvasCmd");var t=DrawCanvasCmd.prototype;t.recover=function(){this._graphicsCmdEncoder=null,y.recover("DrawCanvasCmd",this)},r(0,t,"cmdID",function(){return"DrawCanvasCmd"}),DrawCanvasCmd.create=function(t,e,i,s,n){return null},DrawCanvasCmd.ID="DrawCanvasCmd",DrawCanvasCmd._DRAW_IMAGE_CMD_ENCODER_=null,DrawCanvasCmd._PARAM_TEXTURE_POS_=2,DrawCanvasCmd._PARAM_VB_POS_=5}(),function(){function Render(t,e){this._timeId=0,Render._mainCanvas.source.id="layaCanvas",laya.renders.Render.isConchApp?P.document.body.appendChild(Render._mainCanvas.source):P.container.appendChild(Render._mainCanvas.source),I.initRender(Render._mainCanvas,t,e),P.window.requestAnimationFrame(function loop(t){i.stage._loop();P.window.requestAnimationFrame(loop)}),i.stage.on("visibilitychange",this,this._onVisibilitychange)}n(Render,"laya.renders.Render");var e=Render.prototype;return e._onVisibilitychange=function(){i.stage.isVisibility?0!=this._timeId&&P.window.clearInterval(this._timeId):this._timeId=P.window.setInterval(this._enterFrame,1e3)},e._enterFrame=function(t){i.stage._loop()},r(1,Render,"context",function(){return Render._context}),r(1,Render,"canvas",function(){return Render._mainCanvas.source}),Render._context=null,Render._mainCanvas=null,Render.isWebGL=!1,Render.is3DMode=!1,s(Render,["isConchApp",function(){return this.isConchApp=null!=t.conch}]),Render}()),Tt=function(){function Stat(){}return n(Stat,"laya.utils.Stat"),r(1,Stat,"onclick",null,function(t){Stat._sp&&Stat._sp.on("click",Stat._sp,t),Stat._canvas&&(Stat._canvas.source.onclick=t,Stat._canvas.source.style.pointerEvents="")}),Stat.show=function(t,e){void 0===t&&(t=0),void 0===e&&(e=0),P.onMiniGame||P.onLimixiu||(Stat._useCanvas=!0),Stat._show=!0,Stat._fpsData.length=60,xt.isConchApp?Stat._view[0]={title:"FPS",value:"_fpsStr",color:"yellow",units:"int"}:Stat._view[0]={title:"FPS(Canvas)",value:"_fpsStr",color:"yellow",units:"int"},Stat._view[1]={title:"Sprite",value:"_spriteStr",color:"white",units:"int"},Stat._view[2]={title:"RenderBatch",value:"renderBatch",color:"white",units:"int"},Stat._view[3]={title:"CPUMemory",value:"cpuMemory",color:"yellow",units:"M"},Stat._view[4]={title:"GPUMemory",value:"gpuMemory",color:"yellow",units:"M"},xt.isWebGL&&(Stat._view[5]={title:"Shader",value:"shaderCall",color:"white",units:"int"},xt.is3DMode?(Stat._view[0].title="FPS(3D)",Stat._view[6]={title:"TriFaces",value:"trianglesFaces",color:"white",units:"int"}):(Stat._view[0].title="FPS(WebGL)",Stat._view[6]={title:"Canvas",value:"_canvasStr",color:"white",units:"int"})),Stat._useCanvas?Stat.createUIPre(t,e):Stat.createUI(t,e),Stat.enable()},Stat.createUIPre=function(t,e){var s=P.pixelRatio;Stat._width=130*s,Stat._vx=75*s,Stat._height=s*(12*Stat._view.length+3*s)+4,Stat._fontSize=12*s;for(var n=0;n<Stat._view.length;n++)Stat._view[n].x=4,Stat._view[n].y=n*Stat._fontSize+2*s;xt.isConchApp?(Stat._sp=new Yt,Stat._titleSp=new Yt,Stat._bgSp=new Yt,Stat._bgSp.graphics.drawRect(t,e,Stat._width,Stat._height,"#969696"),Stat._bgSp.alpha=.8,Stat._sp.zOrder=1e5,Stat._titleSp.zOrder=1e5,Stat._bgSp.zOrder=1e5,Stat._bgSp.addChild(Stat._sp),Stat._bgSp.addChild(Stat._titleSp),i.stage.addChild(Stat._bgSp)):(Stat._canvas||(Stat._canvas=new $t(!0),Stat._canvas.size(Stat._width,Stat._height),Stat._ctx=Stat._canvas.getContext("2d"),Stat._ctx.textBaseline="top",Stat._ctx.font=Stat._fontSize+"px Arial",Stat._canvas.source.style.cssText="pointer-events:none;background:rgba(150,150,150,0.8);z-index:100000;position: absolute;direction:ltr;left:"+t+"px;top:"+e+"px;width:"+Stat._width/s+"px;height:"+Stat._height/s+"px;"),P.container.appendChild(Stat._canvas.source)),Stat._first=!0,Stat.loop(),Stat._first=!1},Stat.createUI=function(t,e){var i=Stat._sp,s=P.pixelRatio;i||(i=new Yt,Stat._leftText=new zt,Stat._leftText.pos(5,5),Stat._leftText.color="#ffffff",i.addChild(Stat._leftText),Stat._txt=new zt,Stat._txt.pos(80*s,5),Stat._txt.color="#ffffff",i.addChild(Stat._txt),Stat._sp=i),i.pos(t,e);for(var n="",r=0;r<Stat._view.length;r++){n+=Stat._view[r].title+"\n"}Stat._leftText.text=n;var a=138*s,o=s*(12*Stat._view.length+3*s)+4;Stat._txt.fontSize=Stat._fontSize*s,Stat._leftText.fontSize=Stat._fontSize*s,i.size(a,o),i.graphics.clear(),i.graphics.alpha(.5),i.graphics.drawRect(0,0,a,o,"#999999"),i.graphics.alpha(2),Stat.loop()},Stat.enable=function(){i.systemTimer.frameLoop(1,Stat,Stat.loop)},Stat.hide=function(){Stat._show=!1,i.systemTimer.clear(Stat,Stat.loop),Stat._canvas&&P.removeElement(Stat._canvas.source)},Stat.clear=function(){Stat.trianglesFaces=Stat.renderBatch=Stat.shaderCall=Stat.spriteCount=Stat.spriteRenderUseCacheCount=Stat.treeNodeCollision=Stat.treeSpriteCollision=Stat.canvasNormal=Stat.canvasBitmap=Stat.canvasReCache=0},Stat.loop=function(){Stat._count++;var t=P.now();if(!(t-Stat._timer<1e3)){var e=Stat._count;if(Stat.FPS=Math.round(1e3*e/(t-Stat._timer)),Stat._show){Stat.trianglesFaces=Math.round(Stat.trianglesFaces/e),Stat._useCanvas?(Stat.renderBatch=Math.round(Stat.renderBatch/e),Stat.shaderCall=Math.round(Stat.shaderCall/e),Stat.spriteCount=Math.round(Stat.spriteCount/e)-1):(Stat.renderBatch=Math.round(Stat.renderBatch/e)-1,Stat.shaderCall=Math.round(Stat.shaderCall/e),Stat.spriteCount=Math.round(Stat.spriteCount/e)-4),Stat.spriteRenderUseCacheCount=Math.round(Stat.spriteRenderUseCacheCount/e),Stat.canvasNormal=Math.round(Stat.canvasNormal/e),Stat.canvasBitmap=Math.round(Stat.canvasBitmap/e),Stat.canvasReCache=Math.ceil(Stat.canvasReCache/e),Stat.treeNodeCollision=Math.round(Stat.treeNodeCollision/e),Stat.treeSpriteCollision=Math.round(Stat.treeSpriteCollision/e);var i=Stat.FPS>0?Math.floor(1e3/Stat.FPS).toString():" ";Stat._fpsStr=Stat.FPS+(Stat.renderSlow?" slow":"")+" "+i,Stat._spriteStr=Stat.spriteCount+(Stat.spriteRenderUseCacheCount?"/"+Stat.spriteRenderUseCacheCount:""),Stat._canvasStr=Stat.canvasReCache+"/"+Stat.canvasNormal+"/"+Stat.canvasBitmap,Stat.cpuMemory=At.cpuMemory,Stat.gpuMemory=At.gpuMemory,Stat._useCanvas?Stat.renderInfoPre():Stat.renderInfo(),Stat.clear()}Stat._count=0,Stat._timer=t}},Stat.renderInfoPre=function(){var t,e,i=0;if(xt.isConchApp)for(Stat._sp.graphics.clear(),i=0;i<Stat._view.length;i++)t=Stat._view[i],Stat._first&&Stat._titleSp.graphics.fillText(t.title,t.x,t.y,Stat._fontSize+"px Arial","#ffffff","left"),e=Stat[t.value],"M"==t.units&&(e=Math.floor(e/1048576*100)/100+" M"),Stat._sp.graphics.fillText(e+"",t.x+Stat._vx,t.y,Stat._fontSize+"px Arial",t.color,"left");else if(Stat._canvas){var s=Stat._ctx;for(s.clearRect(Stat._first?0:Stat._vx,0,Stat._width,Stat._height),i=0;i<Stat._view.length;i++)t=Stat._view[i],Stat._first&&(s.fillStyle="white",s.fillText(t.title,t.x,t.y)),s.fillStyle=t.color,e=Stat[t.value],"M"==t.units&&(e=Math.floor(e/1048576*100)/100+" M"),s.fillText(e+"",t.x+Stat._vx,t.y)}},Stat.renderInfo=function(){for(var t="",e=0;e<Stat._view.length;e++){var i=Stat._view[e],s=Stat[i.value];"M"==i.units&&(s=Math.floor(s/1048576*100)/100+" M"),"K"==i.units&&(s=Math.floor(s/1024*100)/100+" K"),t+=s+"\n"}Stat._txt.text=t},Stat.FPS=0,Stat.loopCount=0,Stat.shaderCall=0,Stat.renderBatch=0,Stat.trianglesFaces=0,Stat.spriteCount=0,Stat.spriteRenderUseCacheCount=0,Stat.treeNodeCollision=0,Stat.treeSpriteCollision=0,Stat.canvasNormal=0,Stat.canvasBitmap=0,Stat.canvasReCache=0,Stat.renderSlow=!1,Stat.gpuMemory=0,Stat.cpuMemory=0,Stat._fpsStr=null,Stat._canvasStr=null,Stat._spriteStr=null,Stat._fpsData=[],Stat._timer=0,Stat._count=0,Stat._view=[],Stat._fontSize=12,Stat._txt=null,Stat._leftText=null,Stat._sp=null,Stat._titleSp=null,Stat._bgSp=null,Stat._show=!1,Stat._useCanvas=!1,Stat._canvas=null,Stat._ctx=null,Stat._first=!1,Stat._vx=NaN,Stat._width=0,Stat._height=100,Stat}(),Mt=function(){function ClipRectCmd(){}n(ClipRectCmd,"laya.display.cmd.ClipRectCmd");var t=ClipRectCmd.prototype;return t.recover=function(){y.recover("ClipRectCmd",this)},t.run=function(t,e,i){t.clipRect(this.x+e,this.y+i,this.width,this.height)},r(0,t,"cmdID",function(){return"ClipRect"}),ClipRectCmd.create=function(t,e,i,s){var n=y.getItemByClass("ClipRectCmd",ClipRectCmd);return n.x=t,n.y=e,n.width=i,n.height=s,n},ClipRectCmd.ID="ClipRect",ClipRectCmd}(),bt=function(){function DrawPolyCmd(){}n(DrawPolyCmd,"laya.display.cmd.DrawPolyCmd");var t=DrawPolyCmd.prototype;return t.recover=function(){this.points=null,this.fillColor=null,this.lineColor=null,y.recover("DrawPolyCmd",this)},t.run=function(t,e,i){t._drawPoly(this.x+e,this.y+i,this.points,this.fillColor,this.lineColor,this.lineWidth,this.isConvexPolygon,this.vid)},r(0,t,"cmdID",function(){return"DrawPoly"}),DrawPolyCmd.create=function(t,e,i,s,n,r,a,o){var h=y.getItemByClass("DrawPolyCmd",DrawPolyCmd);return h.x=t,h.y=e,h.points=i,h.fillColor=s,h.lineColor=n,h.lineWidth=r,h.isConvexPolygon=a,h.vid=o,h},DrawPolyCmd.ID="DrawPoly",DrawPolyCmd}(),Lt=function(){function Dragging(){this.ratio=.92,this.maxOffset=60,this._dragging=!1,this._clickOnly=!0}n(Dragging,"laya.utils.Dragging");var t=Dragging.prototype;return t.start=function(t,e,s,n,r,a,o,h){void 0===h&&(h=.92),this.clearTimer(),this.target=t,this.area=e,this.hasInertia=s,this.elasticDistance=e?n:0,this.elasticBackTime=r,this.data=a,this._disableMouseEvent=o,this.ratio=h,this._parent=t.parent,this._clickOnly=!0,this._dragging=!0,this._elasticRateX=this._elasticRateY=1,this._lastX=this._parent.mouseX,this._lastY=this._parent.mouseY,i.stage.on("mouseup",this,this.onStageMouseUp),i.stage.on("mouseout",this,this.onStageMouseUp),i.systemTimer.frameLoop(1,this,this.loop)},t.clearTimer=function(){i.systemTimer.clear(this,this.loop),i.systemTimer.clear(this,this.tweenMove),this._tween&&(this._tween.recover(),this._tween=null)},t.stop=function(){this._dragging&&(w.instance.disableMouseEvent=!1,i.stage.off("mouseup",this,this.onStageMouseUp),i.stage.off("mouseout",this,this.onStageMouseUp),this._dragging=!1,this.target&&this.area&&this.backToArea(),this.clear())},t.loop=function(){var t=this._parent.getMousePoint(),e=t.x,s=t.y,n=e-this._lastX,r=s-this._lastY;if(this._clickOnly){if(!(Math.abs(n*i.stage._canvasTransform.getScaleX())>1||Math.abs(r*i.stage._canvasTransform.getScaleY())>1))return;this._clickOnly=!1,this._offsets||(this._offsets=[]),this._offsets.length=0,this.target.event("dragstart",this.data),w.instance.disableMouseEvent=this._disableMouseEvent}else this._offsets.push(n,r);0===n&&0===r||(this._lastX=e,this._lastY=s,this.target.x+=n*this._elasticRateX,this.target.y+=r*this._elasticRateY,this.area&&this.checkArea(),this.target.event("dragmove",this.data))},t.checkArea=function(){if(this.elasticDistance<=0)this.backToArea();else{if(this.target._x<this.area.x)var t=this.area.x-this.target._x;else t=this.target._x>this.area.x+this.area.width?this.target._x-this.area.x-this.area.width:0;if(this._elasticRateX=Math.max(0,1-t/this.elasticDistance),this.target._y<this.area.y)var e=this.area.y-this.target.y;else e=this.target._y>this.area.y+this.area.height?this.target._y-this.area.y-this.area.height:0;this._elasticRateY=Math.max(0,1-e/this.elasticDistance)}},t.backToArea=function(){this.target.x=Math.min(Math.max(this.target._x,this.area.x),this.area.x+this.area.width),this.target.y=Math.min(Math.max(this.target._y,this.area.y),this.area.y+this.area.height)},t.onStageMouseUp=function(t){if(w.instance.disableMouseEvent=!1,i.stage.off("mouseup",this,this.onStageMouseUp),i.stage.off("mouseout",this,this.onStageMouseUp),i.systemTimer.clear(this,this.loop),!this._clickOnly&&this.target)if(this.hasInertia){this._offsets.length<1&&this._offsets.push(this._parent.mouseX-this._lastX,this._parent.mouseY-this._lastY),this._offsetX=this._offsetY=0;for(var e=this._offsets.length,s=Math.min(e,6),n=this._offsets.length-s,r=e-1;r>n;r--)this._offsetY+=this._offsets[r--],this._offsetX+=this._offsets[r];this._offsetX=this._offsetX/s*2,this._offsetY=this._offsetY/s*2,Math.abs(this._offsetX)>this.maxOffset&&(this._offsetX=this._offsetX>0?this.maxOffset:-this.maxOffset),Math.abs(this._offsetY)>this.maxOffset&&(this._offsetY=this._offsetY>0?this.maxOffset:-this.maxOffset),i.systemTimer.frameLoop(1,this,this.tweenMove)}else this.elasticDistance>0?this.checkElastic():this.clear()},t.checkElastic=function(){var t=NaN,e=NaN;if(this.target.x<this.area.x?t=this.area.x:this.target._x>this.area.x+this.area.width&&(t=this.area.x+this.area.width),this.target.y<this.area.y?e=this.area.y:this.target._y>this.area.y+this.area.height&&(e=this.area.y+this.area.height),isNaN(t)&&isNaN(e))this.clear();else{var i={};isNaN(t)||(i.x=t),isNaN(e)||(i.y=e),this._tween=R.to(this.target,i,this.elasticBackTime,at.sineOut,l.create(this,this.clear),0,!1,!1)}},t.tweenMove=function(){this._offsetX*=this.ratio*this._elasticRateX,this._offsetY*=this.ratio*this._elasticRateY,this.target.x+=this._offsetX,this.target.y+=this._offsetY,this.area&&this.checkArea(),this.target.event("dragmove",this.data),(Math.abs(this._offsetX)<1&&Math.abs(this._offsetY)<1||this._elasticRateX<.5||this._elasticRateY<.5)&&(i.systemTimer.clear(this,this.tweenMove),this.elasticDistance>0?this.checkElastic():this.clear())},t.clear=function(){if(this.target){this.clearTimer();var t=this.target;this.target=null,this._parent=null,t.event("dragend",this.data)}},Dragging}(),It=function(){function DrawTrianglesCmd(){}n(DrawTrianglesCmd,"laya.display.cmd.DrawTrianglesCmd");var t=DrawTrianglesCmd.prototype;return t.recover=function(){this.texture=null,this.vertices=null,this.uvs=null,this.indices=null,this.matrix=null,y.recover("DrawTrianglesCmd",this)},t.run=function(t,e,i){t.drawTriangles(this.texture,this.x+e,this.y+i,this.vertices,this.uvs,this.indices,this.matrix,this.alpha,this.color,this.blendMode)},r(0,t,"cmdID",function(){return"DrawTriangles"}),DrawTrianglesCmd.create=function(t,e,i,s,n,r,a,h,l,c){var u=y.getItemByClass("DrawTrianglesCmd",DrawTrianglesCmd);if(u.texture=t,u.x=e,u.y=i,u.vertices=s,u.uvs=n,u.indices=r,u.matrix=a,u.alpha=h,l){u.color=new Rt;var _=o.create(l).arrColor;u.color.color(255*_[0],255*_[1],255*_[2],255*_[3])}return u.blendMode=c,u},DrawTrianglesCmd.ID="DrawTriangles",DrawTrianglesCmd}(),Rt=function(t){function ColorFilter(t){ColorFilter.__super.call(this),t||(t=this._copyMatrix(ColorFilter.IDENTITY_MATRIX)),this._mat=new Float32Array(16),this._alpha=new Float32Array(4),this.setByMatrix(t),this._action=new M,this._action.data=this}n(ColorFilter,"laya.filters.ColorFilter",c);var e=ColorFilter.prototype;return i.imps(e,{"laya.filters.IFilter":!0}),e.gray=function(){return this.setByMatrix(ColorFilter.GRAY_MATRIX)},e.color=function(t,e,i,s){return void 0===t&&(t=0),void 0===e&&(e=0),void 0===i&&(i=0),void 0===s&&(s=1),this.setByMatrix([1,0,0,0,t,0,1,0,0,e,0,0,1,0,i,0,0,0,1,s])},e.setColor=function(t){var e=o.create(t).arrColor,i=[0,0,0,0,256*e[0],0,0,0,0,256*e[1],0,0,0,0,256*e[2],0,0,0,1,0];return this.setByMatrix(i)},e.setByMatrix=function(t){this._matrix!=t&&this._copyMatrix(t);for(var e=0,i=0,s=0;s<20;s++)s%5!=4?this._mat[e++]=t[s]:this._alpha[i++]=t[s];return this},e.adjustColor=function(t,e,i,s){return this.adjustHue(s),this.adjustContrast(e),this.adjustBrightness(t),this.adjustSaturation(i),this},e.adjustBrightness=function(t){return 0==(t=this._clampValue(t,100))||isNaN(t)?this:this._multiplyMatrix([1,0,0,0,t,0,1,0,0,t,0,0,1,0,t,0,0,0,1,0,0,0,0,0,1])},e.adjustContrast=function(t){if(0==(t=this._clampValue(t,100))||isNaN(t))return this;var e=NaN,i=(e=t<0?127+t/100*127:127*(e=0==(e=t%1)?ColorFilter.DELTA_INDEX[t]:ColorFilter.DELTA_INDEX[t<<0]*(1-e)+ColorFilter.DELTA_INDEX[1+(t<<0)]*e)+127)/127,s=.5*(127-e);return this._multiplyMatrix([i,0,0,0,s,0,i,0,0,s,0,0,i,0,s,0,0,0,1,0,0,0,0,0,1])},e.adjustSaturation=function(t){if(0==(t=this._clampValue(t,100))||isNaN(t))return this;var e=1+(t>0?3*t/100:t/100),i=1-e,s=.3086*i,n=.6094*i,r=.082*i;return this._multiplyMatrix([s+e,n,r,0,0,s,n+e,r,0,0,s,n,r+e,0,0,0,0,0,1,0,0,0,0,0,1])},e.adjustHue=function(t){if(0==(t=this._clampValue(t,180)/180*Math.PI)||isNaN(t))return this;var e=Math.cos(t),i=Math.sin(t),s=.213,n=.715,r=.072;return this._multiplyMatrix([s+e*(1-s)+i*-s,n+e*-n+i*-n,r+e*-r+i*(1-r),0,0,s+e*-s+.143*i,n+e*(1-n)+.14*i,r+e*-r+-.283*i,0,0,s+e*-s+-.787*i,n+e*-n+i*n,r+e*(1-r)+i*r,0,0,0,0,0,1,0,0,0,0,0,1])},e.reset=function(){return this.setByMatrix(this._copyMatrix(ColorFilter.IDENTITY_MATRIX))},e._multiplyMatrix=function(t){var e=[];this._matrix=this._fixMatrix(this._matrix);for(var i=0;i<5;i++){for(var s=0;s<5;s++)e[s]=this._matrix[s+5*i];for(s=0;s<5;s++){for(var n=0,r=0;r<5;r++)n+=t[s+5*r]*e[r];this._matrix[s+5*i]=n}}return this.setByMatrix(this._matrix)},e._clampValue=function(t,e){return Math.min(e,Math.max(-e,t))},e._fixMatrix=function(t){return null==t?ColorFilter.IDENTITY_MATRIX:(t.length<25?t=t.slice(0,t.length).concat(ColorFilter.IDENTITY_MATRIX.slice(t.length,25)):t.length>25&&(t=t.slice(0,25)),t)},e._copyMatrix=function(t){this._matrix||(this._matrix=[]);for(var e=0;e<25;e++)this._matrix[e]=t[e];return this._matrix},r(0,e,"type",function(){return 32}),ColorFilter.LENGTH=25,s(ColorFilter,["DELTA_INDEX",function(){return this.DELTA_INDEX=[0,.01,.02,.04,.05,.06,.07,.08,.1,.11,.12,.14,.15,.16,.17,.18,.2,.21,.22,.24,.25,.27,.28,.3,.32,.34,.36,.38,.4,.42,.44,.46,.48,.5,.53,.56,.59,.62,.65,.68,.71,.74,.77,.8,.83,.86,.89,.92,.95,.98,1,1.06,1.12,1.18,1.24,1.3,1.36,1.42,1.48,1.54,1.6,1.66,1.72,1.78,1.84,1.9,1.96,2,2.12,2.25,2.37,2.5,2.62,2.75,2.87,3,3.2,3.4,3.6,3.8,4,4.3,4.7,4.9,5,5.5,6,6.5,6.8,7,7.3,7.5,7.8,8,8.4,8.7,9,9.4,9.6,9.8,10]},"GRAY_MATRIX",function(){return this.GRAY_MATRIX=[.3086,.6094,.082,0,0,.3086,.6094,.082,0,0,.3086,.6094,.082,0,0,0,0,0,1,0]},"IDENTITY_MATRIX",function(){return this.IDENTITY_MATRIX=[1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1]}]),ColorFilter}(),Pt=function(t){function Widget(){Widget.__super.call(this),this._top=NaN,this._bottom=NaN,this._left=NaN,this._right=NaN,this._centerX=NaN,this._centerY=NaN}n(Widget,"laya.ui.Widget",_);var e=Widget.prototype;return e.onReset=function(){this._top=this._bottom=this._left=this._right=this._centerX=this._centerY=NaN},e._onEnable=function(){this.owner.parent?this._onAdded():this.owner.once("added",this,this._onAdded)},e._onDisable=function(){this.owner.off("added",this,this._onAdded),this.owner.parent&&this.owner.parent.off("resize",this,this._onParentResize)},e._onAdded=function(){this.owner.parent&&this.owner.parent.on("resize",this,this._onParentResize),this.resetLayoutX(),this.resetLayoutY()},e._onParentResize=function(){(this.resetLayoutX()||this.resetLayoutY())&&this.owner.event("resize")},e.resetLayoutX=function(){var t=this.owner;if(!t)return!1;var e=t.parent;if(e)if(isNaN(this.centerX)){if(isNaN(this.left))isNaN(this.right)||(t.x=Math.round(e.width-t.displayWidth-this.right+t.pivotX*t.scaleX));else if(t.x=Math.round(this.left+t.pivotX*t.scaleX),!isNaN(this.right)){var i=(e._width-this.left-this.right)/(t.scaleX||.01);if(i!=t.width)return t.width=i,!0}}else t.x=Math.round(.5*(e.width-t.displayWidth)+this.centerX+t.pivotX*t.scaleX);return!1},e.resetLayoutY=function(){var t=this.owner;if(!t)return!1;var e=t.parent;if(e)if(isNaN(this.centerY)){if(isNaN(this.top))isNaN(this.bottom)||(t.y=Math.round(e.height-t.displayHeight-this.bottom+t.pivotY*t.scaleY));else if(t.y=Math.round(this.top+t.pivotY*t.scaleY),!isNaN(this.bottom)){var i=(e._height-this.top-this.bottom)/(t.scaleY||.01);if(i!=t.height)return t.height=i,!0}}else t.y=Math.round(.5*(e.height-t.displayHeight)+this.centerY+t.pivotY*t.scaleY);return!1},e.resetLayout=function(){this.owner&&(this.resetLayoutX(),this.resetLayoutY())},r(0,e,"centerX",function(){return this._centerX},function(t){this._centerX!=t&&(this._centerX=t,this.resetLayoutX())}),r(0,e,"top",function(){return this._top},function(t){this._top!=t&&(this._top=t,this.resetLayoutY())}),r(0,e,"bottom",function(){return this._bottom},function(t){this._bottom!=t&&(this._bottom=t,this.resetLayoutY())}),r(0,e,"left",function(){return this._left},function(t){this._left!=t&&(this._left=t,this.resetLayoutX())}),r(0,e,"right",function(){return this._right},function(t){this._right!=t&&(this._right=t,this.resetLayoutX())}),r(0,e,"centerY",function(){return this._centerY},function(t){this._centerY!=t&&(this._centerY=t,this.resetLayoutY())}),s(Widget,["EMPTY",function(){return this.EMPTY=new Widget}]),Widget}(),Dt=function(t){function Node(){this._bits=0,this._parent=null,this.name="",this.destroyed=!1,this._conchData=null,this._components=null,this._activeChangeScripts=null,this._scene=null,Node.__super.call(this),this._children=Node.ARRAY_EMPTY,this._extUIChild=Node.ARRAY_EMPTY,this.createGLBuffer()}n(Node,"laya.display.Node",h);var e=Node.prototype;return e.createGLBuffer=function(){},e._setBit=function(t,e){16===t&&(this._getBit(t)!=e&&this._updateDisplayedInstage());e?this._bits|=t:this._bits&=~t},e._getBit=function(t){return 0!=(this._bits&t)},e._setUpNoticeChain=function(){this._getBit(16)&&this._setBitUp(16)},e._setBitUp=function(t){var e=this;for(e._setBit(t,!0),e=e._parent;e;){if(e._getBit(t))return;e._setBit(t,!0),e=e._parent}},e.on=function(t,e,i,s){return"display"!==t&&"undisplay"!==t||this._getBit(16)||this._setBitUp(16),this._createListener(t,e,i,s,!1)},e.once=function(t,e,i,s){return"display"!==t&&"undisplay"!==t||this._getBit(16)||this._setBitUp(16),this._createListener(t,e,i,s,!0)},e.destroy=function(t){void 0===t&&(t=!0),this.destroyed=!0,this._destroyAllComponent(),this._parent&&this._parent.removeChild(this),this._children&&(t?this.destroyChildren():this.removeChildren()),this.onDestroy(),this._children=null,this.offAll()},e.onDestroy=function(){},e.destroyChildren=function(){if(this._children)for(var t=0,e=this._children.length;t<e;t++)this._children[0].destroy(!0)},e.addChild=function(t){if(!t||this.destroyed||t===this)return t;if(t._zOrder&&this._setBit(32,!0),t._parent===this){var e=this.getChildIndex(t);e!==this._children.length-1&&(this._children.splice(e,1),this._children.push(t),this._childChanged())}else t._parent&&t._parent.removeChild(t),this._children===Node.ARRAY_EMPTY&&(this._children=[]),this._children.push(t),t._setParent(this),this._childChanged();return t},e.addInputChild=function(t){if(this._extUIChild==Node.ARRAY_EMPTY)this._extUIChild=[t];else{if(this._extUIChild.indexOf(t)>=0)return null;this._extUIChild.push(t)}return null},e.removeInputChild=function(t){var e=this._extUIChild.indexOf(t);e>=0&&this._extUIChild.splice(e,1)},e.addChildren=function(t){for(var e=arguments,i=0,s=e.length;i<s;)this.addChild(e[i++])},e.addChildAt=function(t,e){if(!t||this.destroyed||t===this)return t;if(t._zOrder&&this._setBit(32,!0),e>=0&&e<=this._children.length){if(t._parent===this){var i=this.getChildIndex(t);this._children.splice(i,1),this._children.splice(e,0,t),this._childChanged()}else t._parent&&t._parent.removeChild(t),this._children===Node.ARRAY_EMPTY&&(this._children=[]),this._children.splice(e,0,t),t._setParent(this);return t}throw new Error("appendChildAt:The index is out of bounds")},e.getChildIndex=function(t){return this._children.indexOf(t)},e.getChildByName=function(t){var e=this._children;if(e)for(var i=0,s=e.length;i<s;i++){var n=e[i];if(n.name===t)return n}return null},e.getChildAt=function(t){return this._children[t]||null},e.setChildIndex=function(t,e){var i=this._children;if(e<0||e>=i.length)throw new Error("setChildIndex:The index is out of bounds.");var s=this.getChildIndex(t);if(s<0)throw new Error("setChildIndex:node is must child of this object.");return i.splice(s,1),i.splice(e,0,t),this._childChanged(),t},e._childChanged=function(t){},e.removeChild=function(t){if(!this._children)return t;var e=this._children.indexOf(t);return this.removeChildAt(e)},e.removeSelf=function(){return this._parent&&this._parent.removeChild(this),this},e.removeChildByName=function(t){var e=this.getChildByName(t);return e&&this.removeChild(e),e},e.removeChildAt=function(t){var e=this.getChildAt(t);return e&&(this._children.splice(t,1),e._setParent(null)),e},e.removeChildren=function(t,e){if(void 0===t&&(t=0),void 0===e&&(e=2147483647),this._children&&this._children.length>0){var i=this._children;if(0===t&&e>=i.length-1){var s=i;this._children=Node.ARRAY_EMPTY}else s=i.splice(t,e-t);for(var n=0,r=s.length;n<r;n++)s[n]._setParent(null)}return this},e.replaceChild=function(t,e){var i=this._children.indexOf(e);return i>-1?(this._children.splice(i,1,t),e._setParent(null),t._setParent(this),t):null},e._setParent=function(t){this._parent!==t&&(t?(this._parent=t,this._onAdded(),this.event("added"),this._getBit(16)&&(this._setUpNoticeChain(),t.displayedInStage&&this._displayChild(this,!0)),t._childChanged(this)):(this._onRemoved(),this.event("removed"),this._parent._childChanged(),this._getBit(16)&&this._displayChild(this,!1),this._parent=t))},e._updateDisplayedInstage=function(){var t;t=this;for(var e=i.stage,s=!1;t;){if(t._getBit(16)){s=t._getBit(128);break}if(t===e||t._getBit(128)){s=!0;break}t=t._parent}this._setBit(128,s)},e._setDisplay=function(t){this._getBit(128)!==t&&(this._setBit(128,t),t?this.event("display"):this.event("undisplay"))},e._displayChild=function(t,e){var i=t._children;if(i)for(var s=0,n=i.length;s<n;s++){var r=i[s];r._getBit(16)&&(r._children.length>0?this._displayChild(r,e):r._setDisplay(e))}t._setDisplay(e)},e.contains=function(t){if(t===this)return!0;for(;t;){if(t._parent===this)return!0;t=t._parent}return!1},e.timerLoop=function(t,e,s,n,r,a){void 0===r&&(r=!0),void 0===a&&(a=!1),(this.scene?this.scene.timer:i.timer).loop(t,e,s,n,r,a)},e.timerOnce=function(t,e,s,n,r){void 0===r&&(r=!0),(this.scene?this.scene.timer:i.timer)._create(!1,!1,t,e,s,n,r)},e.frameLoop=function(t,e,s,n,r){void 0===r&&(r=!0),(this.scene?this.scene.timer:i.timer)._create(!0,!0,t,e,s,n,r)},e.frameOnce=function(t,e,s,n,r){void 0===r&&(r=!0),(this.scene?this.scene.timer:i.timer)._create(!0,!1,t,e,s,n,r)},e.clearTimer=function(t,e){(this.scene?this.scene.timer:i.timer).clear(t,e)},e.callLater=function(t,e){(this.scene?this.scene.timer:i.timer).callLater(this,t,e)},e.runCallLater=function(t){(this.scene?this.scene.timer:i.timer).runCallLater(this,t)},e._onActive=function(){},e._onInActive=function(){},e._onActiveInScene=function(){},e._onInActiveInScene=function(){},e._parse=function(t){},e._setBelongScene=function(t){if(!this._scene){if(this._scene=t,this._components)for(var e=0,i=this._components.length;e<i;e++)this._components[e]._setActiveInScene(!0);for(this._onActiveInScene(),e=0,i=this._children.length;e<i;e++)this._children[e]._setBelongScene(t)}},e._setUnBelongScene=function(){if(this._scene!==this){if(this._onInActiveInScene(),this._components)for(var t=0,e=this._components.length;t<e;t++)this._components[t]._setActiveInScene(!1);for(this._scene=null,t=0,e=this._children.length;t<e;t++)this._children[t]._setUnBelongScene()}},e.onAwake=function(){},e.onEnable=function(){},e._processActive=function(){this._activeChangeScripts||(this._activeChangeScripts=[]),this._activeHierarchy(this._activeChangeScripts),this._activeScripts()},e._activeHierarchy=function(t){if(this._setBit(2,!0),this._components)for(var e=0,i=this._components.length;e<i;e++){var s=this._components[e];s._setActive(!0),s._isScript()&&t.push(s)}for(this._onActive(),e=0,i=this._children.length;e<i;e++){var n=this._children[e];!n._getBit(1)&&n._activeHierarchy(t)}this._getBit(4)||(this._setBit(4,!0),this.onAwake()),this.onEnable()},e._activeScripts=function(){for(var t=0,e=this._activeChangeScripts.length;t<e;t++)this._activeChangeScripts[t].onEnable();this._activeChangeScripts.length=0},e._processInActive=function(){this._activeChangeScripts||(this._activeChangeScripts=[]),this._inActiveHierarchy(this._activeChangeScripts),this._inActiveScripts()},e._inActiveHierarchy=function(t){if(this._onInActive(),this._components)for(var e=0,i=this._components.length;e<i;e++){var s=this._components[e];s._setActive(!1),s._isScript()&&t.push(s)}for(this._setBit(2,!1),e=0,i=this._children.length;e<i;e++){var n=this._children[e];n&&!n._getBit(1)&&n._inActiveHierarchy(t)}this.onDisable()},e._inActiveScripts=function(){for(var t=0,e=this._activeChangeScripts.length;t<e;t++)this._activeChangeScripts[t].onDisable();this._activeChangeScripts.length=0},e.onDisable=function(){},e._onAdded=function(){if(this._activeChangeScripts&&0!==this._activeChangeScripts.length)throw"Node: can't set the main inActive node active in hierarchy,if the operate is in main inActive node or it's children script's onDisable Event.";var t=this._parent.scene;t&&this._setBelongScene(t),this._parent.activeInHierarchy&&this.active&&this._processActive()},e._onRemoved=function(){if(this._activeChangeScripts&&0!==this._activeChangeScripts.length)throw"Node: can't set the main active node inActive in hierarchy,if the operate is in main active node or it's children script's onEnable Event.";this._parent.activeInHierarchy&&this.active&&this._processInActive(),this._parent.scene&&this._setUnBelongScene()},e._addComponentInstance=function(t){this._components=this._components||[],this._components.push(t),t.owner=this,t._onAdded(),this.activeInHierarchy&&(t._setActive(!0),t._isScript()&&t.onEnable()),this._scene&&t._setActiveInScene(!0)},e._destroyComponent=function(t){if(this._components)for(var e=0,i=this._components.length;e<i;e++){var s=this._components[e];if(s===t){s._destroy(),this._components.splice(e,1);break}}},e._destroyAllComponent=function(){if(this._components){for(var t=0,e=this._components.length;t<e;t++){this._components[t]._destroy()}this._components.length=0}},e._cloneTo=function(t){var e=t;if(this._components)for(var i=0,s=this._components.length;i<s;i++){var n=e.addComponent(this._components[i].constructor);this._components[i]._cloneTo(n)}},e.addComponentIntance=function(t){if(t.owner)throw"Node:the component has belong to other node.";if(t.isSingleton&&this.getComponent(t.constructor))throw"Node:the component is singleton,can't add the second one.";return this._addComponentInstance(t),t},e.addComponent=function(t){var e=y.createByClass(t);if(e._destroyed=!1,e.isSingleton&&this.getComponent(t))throw"无法实例"+t+"组件，"+t+"组件已存在！";return this._addComponentInstance(e),e},e.getComponent=function(t){if(this._components)for(var e=0,s=this._components.length;e<s;e++){var n=this._components[e];if(i.__typeof(n,t))return n}return null},e.getComponents=function(t){var e;if(this._components)for(var s=0,n=this._components.length;s<n;s++){var r=this._components[s];i.__typeof(r,t)&&(e=e||[]).push(r)}return e},r(0,e,"numChildren",function(){return this._children.length}),r(0,e,"parent",function(){return this._parent}),r(0,e,"activeInHierarchy",function(){return this._getBit(2)}),r(0,e,"active",function(){return!this._getBit(8)&&!this._getBit(1)},function(t){if(t=!!t,!this._getBit(1)!==t){if(this._activeChangeScripts&&0!==this._activeChangeScripts.length)throw t?"Node: can't set the main inActive node active in hierarchy,if the operate is in main inActive node or it's children script's onDisable Event.":"Node: can't set the main active node inActive in hierarchy,if the operate is in main active node or it's children script's onEnable Event.";this._setBit(1,!t),this._parent&&this._parent.activeInHierarchy&&(t?this._processActive():this._processInActive())}}),r(0,e,"displayedInStage",function(){return this._getBit(16)?this._getBit(128):(this._setBitUp(16),this._getBit(128))}),r(0,e,"scene",function(){return this._scene}),r(0,e,"timer",function(){return this.scene?this.scene.timer:i.timer}),Node.ARRAY_EMPTY=[],Node}(),Bt=function(t){var e;function LoaderManager(){this.retryNum=1,this.retryDelay=0,this.maxLoader=5,this._loaders=[],this._loaderCount=0,this._resInfos=[],this._infoPool=[],this._maxPriority=5,this._failRes={},this._statInfo={count:1,loaded:1},LoaderManager.__super.call(this);for(var t=0;t<this._maxPriority;t++)this._resInfos[t]=[]}n(LoaderManager,"laya.net.LoaderManager",h);var r=LoaderManager.prototype;return r.getProgress=function(){return this._statInfo.loaded/this._statInfo.count},r.resetProgress=function(){this._statInfo.count=this._statInfo.loaded=1},r.create=function(t,e,i,s,n,r,a,o){void 0===a&&(a=1),void 0===o&&(o=!0),this._create(t,!0,e,i,s,n,r,a,o)},r._create=function(t,e,i,s,n,r,a,o,h){if(void 0===o&&(o=1),void 0===h&&(h=!0),t instanceof Array){var c=t,u=c.length,_=0;if(s)var d=l.create(s.caller,s.method,s.args,!1);for(var f=0;f<u;f++){var p=c[f];"string"==typeof p&&(p=c[f]={url:p}),p.progress=0}for(f=0;f<u;f++){p=c[f];var g=s?l.create(null,onProgress,[p],!1):null,m=s||i?l.create(null,onComplete,[p]):null;this._createOne(p.url,e,m,g,p.type||n,p.constructParams||r,p.propertyParams||a,p.priority||o,h)}function onComplete(t,e){_++,t.progress=1,_===u&&i&&i.run()}function onProgress(t,e){t.progress=e;for(var i=0,s=0;s<u;s++){i+=c[s].progress}var n=i/u;d.runWith(n)}}else this._createOne(t,e,i,s,n,r,a,o,h)},r._createOne=function(t,e,s,n,r,a,o,h,c){void 0===h&&(h=1),void 0===c&&(c=!0);var u=this.getRes(t);if(u)!e&&u instanceof laya.resource.Resource&&u._addReference(),n&&n.runWith(1),s&&s.runWith(u);else{var _=_t.getFileExtension(t);if(r||(r=LoaderManager.createMap[_]?LoaderManager.createMap[_][0]:null),!r)return void this.load(t,s,n,r,h,c);if(!Ft.parserMap[r])return void this.load(t,s,n,r,h,c);this._createLoad(t,l.create(null,function(n){n&&(!e&&n instanceof laya.resource.Resource&&n._addReference(),n._setCreateURL(t));s&&s.runWith(n),i.loader.event(t)}),n,r,a,o,h,c,!0)}},r.load=function(t,s,n,r,a,o,h,l,c){var u=this;if(void 0===a&&(a=1),void 0===o&&(o=!0),void 0===l&&(l=!1),void 0===c&&(c=!1),t instanceof Array)return this._loadAssets(t,s,n,r,a,o,h);var _=Ft.getRes(t);if(l||null==_){var d;d=t,(t=ht.getFileLoadPath(t))!=d&&"nativeimage"!==r?r="atlas":d=null;var f=LoaderManager._resMap[t];f?(s&&(d?s&&f._createListener("complete",this,this._resInfoLoaded,[d,s],!1,!1):s&&f._createListener("complete",s.caller,s.method,s.args,!1,!1)),n&&f._createListener("progress",n.caller,n.method,n.args,!1,!1)):((f=this._infoPool.length?this._infoPool.pop():new e).url=t,f.type=r,f.cache=o,f.group=h,f.ignoreCache=l,f.useWorkerLoader=c,f.originalUrl=d,s&&f.on("complete",s.caller,s.method,s.args),n&&f.on("progress",n.caller,n.method,n.args),LoaderManager._resMap[t]=f,a=a<this._maxPriority?a:this._maxPriority-1,this._resInfos[a].push(f),this._statInfo.count++,this.event("progress",this.getProgress()),this._next())}else i.systemTimer.frameOnce(1,null,function(){n&&n.runWith(1),s&&s.runWith(_),u._loaderCount||u.event("complete")});return this},r._resInfoLoaded=function(t,e){e.runWith(Ft.getRes(t))},r._createLoad=function(t,s,n,r,a,o,h,l,c){var u=this;if(void 0===h&&(h=1),void 0===l&&(l=!0),void 0===c&&(c=!1),t instanceof Array)return this._loadAssets(t,s,n,r,h,l);var _=Ft.getRes(t);if(null!=_)i.systemTimer.frameOnce(1,null,function(){n&&n.runWith(1),s&&s.runWith(_),u._loaderCount||u.event("complete")});else{var d=LoaderManager._resMap[t];d?(s&&d._createListener("complete",s.caller,s.method,s.args,!1,!1),n&&d._createListener("progress",n.caller,n.method,n.args,!1,!1)):((d=this._infoPool.length?this._infoPool.pop():new e).url=t,d.type=r,d.cache=!1,d.ignoreCache=c,d.originalUrl=null,d.createCache=l,d.createConstructParams=a,d.createPropertyParams=o,s&&d.on("complete",s.caller,s.method,s.args),n&&d.on("progress",n.caller,n.method,n.args),LoaderManager._resMap[t]=d,h=h<this._maxPriority?h:this._maxPriority-1,this._resInfos[h].push(d),this._statInfo.count++,this.event("progress",this.getProgress()),this._next())}return this},r._next=function(){if(!(this._loaderCount>=this.maxLoader)){for(var t=0;t<this._maxPriority;t++)for(var e=this._resInfos[t];e.length>0;){var i=e.shift();if(i)return this._doLoad(i)}this._loaderCount||this.event("complete")}},r._doLoad=function(t){this._loaderCount++;var e=this._loaders.length?this._loaders.pop():new Ft;e.on("complete",null,onLoaded),e.on("progress",null,function(e){t.event("progress",e)}),e.on("error",null,function(t){onLoaded(null)});var i=this;function onLoaded(s){e.offAll(),e._data=null,e._customParse=!1,i._loaders.push(e),i._endLoad(t,s instanceof Array?[s]:s),i._loaderCount--,i._next()}e._constructParams=t.createConstructParams,e._propertyParams=t.createPropertyParams,e._createCache=t.createCache,e.load(t.url,t.type,t.cache,t.group,t.ignoreCache,t.useWorkerLoader)},r._endLoad=function(t,e){var s=t.url;if(null==e){var n=this._failRes[s]||0;if(n<this.retryNum)return console.warn("[warn]Retry to load:",s),this._failRes[s]=n+1,void i.systemTimer.once(this.retryDelay,this,this._addReTry,[t],!1);Ft.clearRes(s),console.warn("[error]Failed to load:",s),this.event("error",s)}this._failRes[s]&&(this._failRes[s]=0),delete LoaderManager._resMap[s],t.originalUrl&&(e=Ft.getRes(t.originalUrl)),t.event("complete",e),t.offAll(),this._infoPool.push(t),this._statInfo.loaded++,this.event("progress",this.getProgress())},r._addReTry=function(t){this._resInfos[this._maxPriority-1].push(t),this._next()},r.clearRes=function(t){Ft.clearRes(t)},r.clearTextureRes=function(t){Ft.clearTextureRes(t)},r.getRes=function(t){return Ft.getRes(t)},r.cacheRes=function(t,e){Ft.cacheRes(t,e)},r.setGroup=function(t,e){Ft.setGroup(t,e)},r.clearResByGroup=function(t){Ft.clearResByGroup(t)},r.clearUnLoaded=function(){for(var t=0;t<this._maxPriority;t++){for(var e=this._resInfos[t],i=e.length-1;i>-1;i--){var s=e[i];s&&(s.offAll(),this._infoPool.push(s))}e.length=0}this._loaderCount=0,LoaderManager._resMap={}},r.cancelLoadByUrls=function(t){if(t)for(var e=0,i=t.length;e<i;e++)this.cancelLoadByUrl(t[e])},r.cancelLoadByUrl=function(t){for(var e=0;e<this._maxPriority;e++)for(var i=this._resInfos[e],s=i.length-1;s>-1;s--){var n=i[s];n&&n.url===t&&(i[s]=null,n.offAll(),this._infoPool.push(n))}LoaderManager._resMap[t]&&delete LoaderManager._resMap[t]},r._loadAssets=function(t,e,i,s,n,r,a){void 0===n&&(n=1),void 0===r&&(r=!0);for(var o=t.length,h=0,c=0,u=[],_=!0,d=0;d<o;d++){var f=t[d];"string"==typeof f&&(f={url:f,type:s,size:1,priority:n}),f.size||(f.size=1),f.progress=0,c+=f.size,u.push(f);var p=i?l.create(null,loadProgress,[f],!1):null,g=e||i?l.create(null,loadComplete,[f]):null;this.load(f.url,g,p,f.type,f.priority||1,r,f.group||a,!1,f.useWorkerLoader)}function loadComplete(t,i){h++,t.progress=1,i||(_=!1),h===o&&e&&e.runWith(_)}function loadProgress(t,e){if(null!=i){t.progress=e;for(var s=0,n=0;n<u.length;n++){var r=u[n];s+=r.size*r.progress}var a=s/c;i.runWith(a)}}return this},r.decodeBitmaps=function(t){var e,i=0,s=t.length;for(e=xt._context,i=0;i<s;i++){var n,r;if(n=Ft.getAtlas(t[i]))this._decodeTexture(n[0],e);else(r=this.getRes(t[i]))&&r instanceof laya.resource.Texture&&this._decodeTexture(r,e)}},r._decodeTexture=function(t,e){var s=t.bitmap;if(t&&s){var n=s.source||s.image;if(n&&i.__typeof(n,P.window.HTMLImageElement)){e.drawImage(n,0,0,1,1);e.getImageData(0,0,1,1)}}},LoaderManager.cacheRes=function(t,e){Ft.cacheRes(t,e)},LoaderManager._resMap={},s(LoaderManager,["createMap",function(){return this.createMap={atlas:[null,"atlas"]}}]),LoaderManager.__init$=function(){e=function(t){function ResInfo(){this.url=null,this.type=null,this.cache=!1,this.group=null,this.ignoreCache=!1,this.useWorkerLoader=!1,this.originalUrl=null,this.createCache=!1,this.createConstructParams=null,this.createPropertyParams=null,ResInfo.__super.call(this)}return n(ResInfo,"",h),ResInfo}()},LoaderManager}(),At=function(t){function Resource(){this._cpuMemory=0,this._gpuMemory=0,Resource.__super.call(this),this._id=++Resource._uniqueIDCounter,this._destroyed=!1,this._referenceCount=0,Resource._idResourcesMap[this.id]=this,this.lock=!1}n(Resource,"laya.resource.Resource",h);var e=Resource.prototype;return i.imps(e,{"laya.resource.ICreateResource":!0,"laya.resource.IDestroy":!0}),e._setCPUMemory=function(t){var e=t-this._cpuMemory;this._cpuMemory=t,Resource._addCPUMemory(e)},e._setGPUMemory=function(t){var e=t-this._gpuMemory;this._gpuMemory=t,Resource._addGPUMemory(e)},e._setCreateURL=function(t){var e;this._url!==t&&(this._url&&((e=Resource._urlResourcesMap[this._url]).splice(e.indexOf(this),1),0===e.length&&delete Resource._urlResourcesMap[this._url]),t&&((e=Resource._urlResourcesMap[t])||(Resource._urlResourcesMap[t]=e=[]),e.push(this)),this._url=t)},e._addReference=function(t){void 0===t&&(t=1),this._referenceCount+=t},e._removeReference=function(t){void 0===t&&(t=1),this._referenceCount-=t},e._clearReference=function(){this._referenceCount=0},e._recoverResource=function(){},e._disposeResource=function(){},e._activeResource=function(){},e.destroy=function(){var t;this._destroyed||(this._destroyed=!0,this.lock=!1,this._disposeResource(),delete Resource._idResourcesMap[this.id],this._url&&((t=Resource._urlResourcesMap[this._url])&&(t.splice(t.indexOf(this),1),0===t.length&&delete Resource._urlResourcesMap[this._url]),Ft.getRes(this._url)==this&&delete Ft.loadedMap[this._url]))},r(0,e,"id",function(){return this._id}),r(0,e,"gpuMemory",function(){return this._gpuMemory}),r(0,e,"url",function(){return this._url}),r(0,e,"cpuMemory",function(){return this._cpuMemory}),r(0,e,"destroyed",function(){return this._destroyed}),r(0,e,"referenceCount",function(){return this._referenceCount}),r(1,Resource,"cpuMemory",function(){return this._cpuMemory},laya.events.EventDispatcher._$SET_cpuMemory),r(1,Resource,"gpuMemory",function(){return this._gpuMemory},laya.events.EventDispatcher._$SET_gpuMemory),Resource._addCPUMemory=function(t){this._cpuMemory+=t},Resource._addGPUMemory=function(t){this._gpuMemory+=t},Resource._addMemory=function(t,e){this._cpuMemory+=t,this._gpuMemory+=e},Resource.getResourceByID=function(t){return Resource._idResourcesMap[t]},Resource.getResourceByURL=function(t,e){return void 0===e&&(e=0),Resource._urlResourcesMap[t][e]},Resource.destroyUnusedResources=function(){for(var t in Resource._idResourcesMap){var e=Resource._idResourcesMap[t];e.lock||0!==e._referenceCount||e.destroy()}},Resource._uniqueIDCounter=0,Resource._idResourcesMap={},Resource._urlResourcesMap={},Resource._cpuMemory=0,Resource._gpuMemory=0,Resource}(),Et=function(t){function SceneLoader(){this.totalCount=0,this._completeHandler=null,this._toLoadList=null,this._isLoading=!1,this._curUrl=null,SceneLoader.__super.call(this),this._completeHandler=new l(this,this.onOneLoadComplete),this.reset()}n(SceneLoader,"laya.net.SceneLoader",h);var e=SceneLoader.prototype;return e.reset=function(){this._toLoadList=[],this._isLoading=!1,this.totalCount=0},e.load=function(t,e,i){if(void 0===e&&(e=!1),void 0===i&&(i=!0),t instanceof Array){var s,n=0;for(s=t.length,n=0;n<s;n++)this._addToLoadList(t[n],e)}else this._addToLoadList(t,e);i&&this._checkNext()},e._addToLoadList=function(t,e){void 0===e&&(e=!1),this._toLoadList.indexOf(t)>=0||Ft.getRes(t)||(e?this._toLoadList.push({url:t}):this._toLoadList.push(t),this.totalCount++)},e._checkNext=function(){if(!this._isLoading){if(0==this._toLoadList.length)return void this.event("complete");var t;"string"==typeof(t=this._toLoadList.pop())?this.loadOne(t):this.loadOne(t.url,!0)}},e.loadOne=function(t,e){void 0===e&&(e=!1),this._curUrl=t;var s=_t.getFileExtension(this._curUrl);e?i.loader.create(t,this._completeHandler):SceneLoader.LoadableExtensions[s]?i.loader.load(t,this._completeHandler,null,SceneLoader.LoadableExtensions[s]):t!=ht.getFileLoadPath(t)||SceneLoader.No3dLoadTypes[s]||!Bt.createMap[s]?i.loader.load(t,this._completeHandler):i.loader.create(t,this._completeHandler)},e.onOneLoadComplete=function(){this._isLoading=!1,Ft.getRes(this._curUrl)||console.log("Fail to load:",this._curUrl);var t,e=_t.getFileExtension(this._curUrl);SceneLoader.LoadableExtensions[e]&&((t=Ft.getRes(this._curUrl))&&t instanceof laya.components.Prefab&&(t=t.json),t&&(t.loadList&&this.load(t.loadList,!1,!1),t.loadList3D&&this.load(t.loadList3D,!0,!1)));"sk"==e&&this.load(this._curUrl.replace(".sk",".png"),!1,!1),this.event("progress",this.getProgress()),this._checkNext()},e.getProgress=function(){return this.loadedCount/this.totalCount},r(0,e,"loadedCount",function(){return this.totalCount-this.leftCount}),r(0,e,"leftCount",function(){return this._isLoading?this._toLoadList.length+1:this._toLoadList.length}),s(SceneLoader,["LoadableExtensions",function(){return this.LoadableExtensions={scene:"json",scene3d:"json",ani:"json",ui:"json",prefab:"prefab"}},"No3dLoadTypes",function(){return this.No3dLoadTypes={png:!0,jpg:!0,txt:!0}}]),SceneLoader}(),Ft=function(t){function Loader(){this._data=null,this._url=null,this._type=null,this._cache=!1,this._http=null,this._useWorkerLoader=!1,this._customParse=!1,this._constructParams=null,this._propertyParams=null,this._createCache=!1,Loader.__super.call(this)}n(Loader,"laya.net.Loader",h);var e=Loader.prototype;return e.load=function(t,e,i,s,n,r){if(void 0===i&&(i=!0),void 0===n&&(n=!1),void 0===r&&(r=!1),t){if(Loader.setGroup(t,"666"),this._url=t,0===t.indexOf("data:image")?e="image":t=v.formatURL(t),this._type=e||(e=Loader.getTypeFromUrl(this._url)),this._cache=i,this._useWorkerLoader=r,this._data=null,!n&&Loader.loadedMap[t])return this._data=Loader.loadedMap[t],this.event("progress",1),void this.event("complete",this._data);if(s&&Loader.setGroup(t,s),null!=Loader.parserMap[e])return this._customParse=!0,void(Loader.parserMap[e]instanceof laya.utils.Handler?Loader.parserMap[e].runWith(this):Loader.parserMap[e].call(null,this));if("image"===e||"htmlimage"===e||"nativeimage"===e)return this._loadImage(t);var a;switch(e){case"atlas":case"prefab":case"plf":a="json";break;case"font":a="xml";break;default:a=e}Loader.preLoadedMap[t]?this.onLoaded(Loader.preLoadedMap[t]):(this._http||(this._http=new Wt,this._http.on("progress",this,this.onProgress),this._http.on("error",this,this.onError),this._http.on("complete",this,this.onLoaded)),this._http.send(t,null,"get",a))}else this.onLoaded(null)},e._loadImage=function(t){t=v.formatURL(t);var e,i=this;function clear(){var i=e;i&&(i.onload=null,i.onerror=null,delete Loader._imgCache[t])}var s=function(){clear(),i.event("error","Load image failed")};if("nativeimage"===this._type){var n=function(){clear(),i.onLoaded(e)};(e=new P.window.Image).crossOrigin="",e.onload=n,e.onerror=s,e.src=t,Loader._imgCache[t]=e}else{var r=new P.window.Image;n=function(){(e=qt.create(r.width,r.height)).loadImageSource(r,!0),e._setCreateURL(t),clear(),i.onLoaded(e)},r.crossOrigin="",r.onload=n,r.onerror=s,r.src=t,e=r,Loader._imgCache[t]=r}},e.onProgress=function(t){"atlas"===this._type?this.event("progress",.3*t):this.event("progress",t)},e.onError=function(t){this.event("error",t)},e.onLoaded=function(t){var e=this._type;if("plf"==e)this.parsePLFData(t),this.complete(t);else if("image"===e){var i=new Ot(t);i.url=this._url,this.complete(i)}else if("sound"===e||"htmlimage"===e||"nativeimage"===e)this.complete(t);else if("atlas"===e){if(!t.url&&!t._setContext){if(!this._data){if(this._data=t,t.meta&&t.meta.image)for(var s=t.meta.image.split(","),n=this._url.indexOf("/")>=0?"/":"\\",r=this._url.lastIndexOf(n),a=r>=0?this._url.substr(0,r+1):"",o=0,h=s.length;o<h;o++)s[o]=a+s[o];else s=[this._url.replace(".json",".png")];s.reverse(),t.toLoads=s,t.pics=[]}return this.event("progress",.3+1/s.length*.6),this._loadImage(s.pop())}if(this._data.pics.push(t),this._data.toLoads.length>0)return this.event("progress",.3+1/this._data.toLoads.length*.6),this._loadImage(this._data.toLoads.pop());var l=this._data.frames,c=this._url.split("?")[0],u=this._data.meta&&this._data.meta.prefix?this._data.meta.prefix:c.substring(0,c.lastIndexOf("."))+"/",_=this._data.pics,d=v.formatURL(this._url),f=Loader.atlasMap[d]||(Loader.atlasMap[d]=[]);f.dir=u;var p=1;if(this._data.meta&&this._data.meta.scale&&1!=this._data.meta.scale)for(var g in p=parseFloat(this._data.meta.scale),l){var m,y=l[g],C=_[y.frame.idx?y.frame.idx:0],w=v.formatURL(u+g);C.scaleRate=p,m=Ot._create(C,y.frame.x,y.frame.y,y.frame.w,y.frame.h,y.spriteSourceSize.x,y.spriteSourceSize.y,y.sourceSize.w,y.sourceSize.h,laya.net.Loader.getRes(w)),Loader.cacheRes(w,m),m.url=w,f.push(w)}else for(g in l)C=_[(y=l[g]).frame.idx?y.frame.idx:0],w=v.formatURL(u+g),m=Ot._create(C,y.frame.x,y.frame.y,y.frame.w,y.frame.h,y.spriteSourceSize.x,y.spriteSourceSize.y,y.sourceSize.w,y.sourceSize.h,laya.net.Loader.getRes(w)),Loader.cacheRes(w,m),m.url=w,f.push(w);delete this._data.pics,this.complete(this._data)}else if("font"===e){if(!t._source)return this._data=t,this.event("progress",.5),this._loadImage(this._url.replace(".fnt",".png"))}else if("prefab"===e){var S=new V;S.json=t,this.complete(S)}else this.complete(t)},e.parsePLFData=function(t){var e,i,s;for(e in t)switch(s=t[e],e){case"json":case"text":for(i in s)Loader.preLoadedMap[v.formatURL(i)]=s[i];break;default:for(i in s)Loader.preLoadedMap[v.formatURL(i)]=s[i]}},e.complete=function(t){this._data=t,this._customParse?this.event("loaded",t instanceof Array?[t]:t):(Loader._loaders.push(this),Loader._isWorking||Loader.checkNext())},e.endLoad=function(t){t&&(this._data=t),this._cache&&Loader.cacheRes(this._url,this._data),this.event("progress",1),this.event("complete",this.data instanceof Array?[this.data]:this.data)},r(0,e,"url",function(){return this._url}),r(0,e,"data",function(){return this._data}),r(0,e,"cache",function(){return this._cache}),r(0,e,"type",function(){return this._type}),Loader.getTypeFromUrl=function(t){var e=_t.getFileExtension(t);return e?Loader.typeMap[e]:(console.warn("Not recognize the resources suffix",t),"text")},Loader.checkNext=function(){Loader._isWorking=!0;for(var t=P.now();Loader._startIndex<Loader._loaders.length;)if(P.now(),Loader._loaders[Loader._startIndex].endLoad(),Loader._startIndex++,P.now()-t>Loader.maxTimeOut)return console.warn("loader callback cost a long time:"+(P.now()-t)+" url="+Loader._loaders[Loader._startIndex-1].url),void i.systemTimer.frameOnce(1,null,Loader.checkNext);Loader._loaders.length=0,Loader._startIndex=0,Loader._isWorking=!1},Loader.clearRes=function(t){t=v.formatURL(t);var e=Loader.getAtlas(t);if(e){for(var i=0,s=e.length;i<s;i++){var n=e[i],r=Loader.getRes(n);delete Loader.loadedMap[n],r&&r.destroy()}e.length=0,delete Loader.atlasMap[t],delete Loader.loadedMap[t]}else{var a=Loader.loadedMap[t];a&&(delete Loader.loadedMap[t],a instanceof laya.resource.Texture&&a.bitmap&&a.destroy())}},Loader.clearTextureRes=function(t){t=v.formatURL(t);var e=laya.net.Loader.getAtlas(t),i=e&&e.length>0?laya.net.Loader.getRes(e[0]):laya.net.Loader.getRes(t);i instanceof laya.resource.Texture&&i.disposeBitmap()},Loader.getRes=function(t){return Loader.loadedMap[v.formatURL(t)]},Loader.getAtlas=function(t){return Loader.atlasMap[v.formatURL(t)]},Loader.cacheRes=function(t,e){t=v.formatURL(t),null!=Loader.loadedMap[t]?console.warn("Resources already exist,is repeated loading:",t):Loader.loadedMap[t]=e},Loader.setGroup=function(t,e){Loader.groupMap[e]||(Loader.groupMap[e]=[]),Loader.groupMap[e].push(t)},Loader.clearResByGroup=function(t){if(Loader.groupMap[t]){var e=Loader.groupMap[t],i=0,s=e.length;for(i=0;i<s;i++)Loader.clearRes(e[i]);e.length=0}},Loader.TEXT="text",Loader.JSON="json",Loader.PREFAB="prefab",Loader.XML="xml",Loader.BUFFER="arraybuffer",Loader.IMAGE="image",Loader.SOUND="sound",Loader.ATLAS="atlas",Loader.FONT="font",Loader.TTF="ttf",Loader.PLF="plf",Loader.HIERARCHY="HIERARCHY",Loader.MESH="MESH",Loader.MATERIAL="MATERIAL",Loader.TEXTURE2D="TEXTURE2D",Loader.TEXTURECUBE="TEXTURECUBE",Loader.ANIMATIONCLIP="ANIMATIONCLIP",Loader.AVATAR="AVATAR",Loader.TERRAINHEIGHTDATA="TERRAINHEIGHTDATA",Loader.TERRAINRES="TERRAIN",Loader.typeMap={ttf:"ttf",png:"image",jpg:"image",jpeg:"image",txt:"text",json:"json",prefab:"prefab",xml:"xml",als:"atlas",atlas:"atlas",mp3:"sound",ogg:"sound",wav:"sound",part:"json",fnt:"font",pkm:"pkm",plf:"plf",scene:"json",ani:"json",sk:"arraybuffer"},Loader.parserMap={},Loader.maxTimeOut=100,Loader.groupMap={},Loader.loadedMap={},Loader.atlasMap={},Loader.preLoadedMap={},Loader._imgCache={},Loader._loaders=[],Loader._isWorking=!1,Loader._startIndex=0,Loader}(),kt=function(t){function MiniLoader(){MiniLoader.__super.call(this)}return n(MiniLoader,"laya.wx.mini.MiniLoader",h),MiniLoader.prototype.load=function(t,e,i,s,n){void 0===i&&(i=!0),void 0===n&&(n=!1);if(this._url=t,0===(t=v.customFormat(t)).indexOf("data:image")?this._type=e="image":this._type=e||(e=Ft.getTypeFromUrl(this._url)),this._cache=i,this._data=null,!n&&Ft.loadedMap[v.formatURL(t)])return this._data=Ft.loadedMap[v.formatURL(t)],this.event("progress",1),void this.event("complete",this._data);if(null!=Ft.parserMap[e])return this._customParse=!0,void(Ft.parserMap[e]instanceof laya.utils.Handler?Ft.parserMap[e].runWith(this):Ft.parserMap[e].call(null,this));var r=b.getUrlEncode(t,e),a=_t.getFileExtension(t);if(-1!=MiniLoader._fileTypeArr.indexOf(a))b.EnvConfig.load.call(this,t,e,i,s,n);else{if(b.isZiYu&&!U.ziyuFileData[t]&&(t=v.formatURL(t)),b.isZiYu&&U.ziyuFileData[t]){var o=U.ziyuFileData[t];return void this.onLoaded(o)}if(U.getFileInfo(t)){var h=U.getFileInfo(t);h.encoding=null==h.encoding?"utf8":h.encoding,U.readFile(t,h.encoding,new l(MiniLoader,MiniLoader.onReadNativeCallBack,[r,t,e,i,s,n,this]),t)}else{if(U.isLocalNativeFile(t)){if(b.subNativeFiles&&0==b.subNativeheads.length)for(var c in b.subNativeFiles){var u=b.subNativeFiles[c];b.subNativeheads=b.subNativeheads.concat(u);for(var _=0;_<u.length;_++)b.subMaps[u[_]]=c+"/"+u[_]}if(b.subNativeFiles&&-1!=t.indexOf("/")){var d=t.split("/")[0]+"/";if(d&&-1!=b.subNativeheads.indexOf(d)){var f=b.subMaps[d];t=t.replace(d,f)}}var p=""!=v.rootPath?v.rootPath:v.basePath,g=t;return""!=p&&(t=t.split(p)[1]),t||(t=g),void U.read(t,r,new l(MiniLoader,MiniLoader.onReadNativeCallBack,[r,t,e,i,s,n,this]))}-1!=(t=v.formatURL(t)).indexOf("http://")||-1!=t.indexOf("https://")&&!b.AutoCacheDownFile?b.EnvConfig.load.call(this,t,e,i,s,n):U.readFile(t,r,new l(MiniLoader,MiniLoader.onReadNativeCallBack,[r,t,e,i,s,n,this]),t)}}},MiniLoader.onReadNativeCallBack=function(t,e,i,s,n,r,a,o,h){var l;(void 0===s&&(s=!0),void 0===r&&(r=!1),void 0===o&&(o=0),o)?1==o&&b.EnvConfig.load.call(a,e,i,s,n,r):(l="json"==i||"atlas"==i||"prefab"==i?b.getJson(h.data):"xml"==i?_t.parseXMLFromString(h.data):h.data,!b.isZiYu&&b.isPosMsgYu&&"arraybuffer"!=i&&wx.postMessage({url:e,data:l,isLoad:"filedata"}),a.onLoaded(l))},s(MiniLoader,["_fileTypeArr",function(){return this._fileTypeArr=["png","jpg","bmp","jpeg","gif"]}]),MiniLoader}(),Ot=(function(t){function UIEvent(){UIEvent.__super.call(this)}n(UIEvent,"laya.ui.UIEvent",L),UIEvent.SHOW_TIP="showtip",UIEvent.HIDE_TIP="hidetip"}(),function(t){function Texture(t,e,i,s){this.uvrect=[0,0,1,1],this._w=0,this._h=0,this._destroyed=!1,this._referenceCount=0,this.offsetX=0,this.offsetY=0,this.sourceWidth=0,this.sourceHeight=0,this.scaleRate=1,Texture.__super.call(this),void 0===i&&(i=0),void 0===s&&(s=0),this.setTo(t,e,i,s)}n(Texture,"laya.resource.Texture",h);var e=Texture.prototype;return e._addReference=function(){this._bitmap&&this._bitmap._addReference(),this._referenceCount++},e._removeReference=function(){this._bitmap&&this._bitmap._removeReference(),this._referenceCount--},e._getSource=function(){return this._destroyed||!this._bitmap?null:(this.recoverBitmap(),this._bitmap.destroyed?null:this.bitmap._getSource())},e._onLoaded=function(t,e){if(e)if(e==this);else if(e instanceof laya.resource.Texture){var i=e;Texture._create(e,0,0,i.width,i.height,0,0,i.sourceWidth,i.sourceHeight,this)}else this.bitmap=e,this.sourceWidth=this._w=e.width,this.sourceHeight=this._h=e.height;else;t&&t.run(),this.event("ready",this)},e.getIsReady=function(){return!this._destroyed&&!!this._bitmap},e.setTo=function(t,e,i,s){if(void 0===i&&(i=0),void 0===s&&(s=0),this.bitmap=t,this.sourceWidth=i,this.sourceHeight=s,t){this._w=t.width,this._h=t.height,this.sourceWidth=this.sourceWidth||this._w,this.sourceHeight=this.sourceHeight||this._h}this.uv=e||Texture.DEF_UV},e.load=function(t,e){this._destroyed||i.loader.load(t,l.create(this,this._onLoaded,[e]),null,"htmlimage",1,!1,null,!0)},e.getPixels=function(t,e,i,s){if(xt.isWebGL)return I.getTexturePixels(this,t,e,i,s);if(xt.isConchApp)return this._nativeObj.getImageData(t,e,i,s);var n=this.width,r=this.height;return t+i>n&&(i-=t+i-n),e+s>r&&(s-=e+s-r),i<=0||s<=0?null:(P.canvas.size(i,s),P.canvas.clear(),P.context.drawImage(this.bitmap._source,t,e,i,s,0,0,i,s),P.context.getImageData(0,0,i,s).data)},e.recoverBitmap=function(){var t=this._bitmap.url;this._destroyed||this._bitmap&&!this._bitmap.destroyed||!t||this.load(t)},e.disposeBitmap=function(){!this._destroyed&&this._bitmap&&this._bitmap.destroy()},e.destroy=function(){this._destroyed||(this._destroyed=!0,this.bitmap&&(this.bitmap._removeReference(this._referenceCount),this.bitmap=null),this.url&&this===i.loader.getRes(this.url)&&i.loader.clearRes(this.url))},r(0,e,"height",function(){return this._h?this._h:this.bitmap?this.uv&&this.uv!==Texture.DEF_UV?(this.uv[5]-this.uv[1])*this.bitmap.height:this.bitmap.height:0},function(t){this._h=t,this.sourceHeight||(this.sourceHeight=t)}),r(0,e,"uv",function(){return this._uv},function(t){this.uvrect[0]=Math.min(t[0],t[2],t[4],t[6]),this.uvrect[1]=Math.min(t[1],t[3],t[5],t[7]),this.uvrect[2]=Math.max(t[0],t[2],t[4],t[6])-this.uvrect[0],this.uvrect[3]=Math.max(t[1],t[3],t[5],t[7])-this.uvrect[1],this._uv=t}),r(0,e,"width",function(){return this._w?this._w:this.bitmap?this.uv&&this.uv!==Texture.DEF_UV?(this.uv[2]-this.uv[0])*this.bitmap.width:this.bitmap.width:0},function(t){this._w=t,this.sourceWidth||(this.sourceWidth=t)}),r(0,e,"bitmap",function(){return this._bitmap},function(t){this._bitmap&&this._bitmap._removeReference(this._referenceCount),this._bitmap=t,t&&t._addReference(this._referenceCount)}),r(0,e,"destroyed",function(){return this._destroyed}),Texture.moveUV=function(t,e,i){for(var s=0;s<8;s+=2)i[s]+=t,i[s+1]+=e;return i},Texture.create=function(t,e,i,s,n,r,a,o,h){return void 0===r&&(r=0),void 0===a&&(a=0),void 0===o&&(o=0),void 0===h&&(h=0),Texture._create(t,e,i,s,n,r,a,o,h)},Texture._create=function(t,e,i,s,n,r,a,o,h,l){void 0===r&&(r=0),void 0===a&&(a=0),void 0===o&&(o=0),void 0===h&&(h=0);var c,u=t instanceof laya.resource.Texture,_=u?t.uv:Texture.DEF_UV,d=u?t.bitmap:t;d.width&&e+s>d.width&&(s=d.width-e),d.height&&i+n>d.height&&(n=d.height-i),l?(c=l).setTo(d,null,o||s,h||n):c=new Texture(d,null,o||s,h||n),c.width=s,c.height=n,c.offsetX=r,c.offsetY=a;var f=1/d.width,p=1/d.height;e*=f,i*=p,s*=f,n*=p;var g=c.uv[0],m=c.uv[1],v=c.uv[4],y=c.uv[5],C=v-g,w=y-m,S=Texture.moveUV(_[0],_[1],[e,i,e+s,i,e+s,i+n,e,i+n]);c.uv=[g+S[0]*C,m+S[1]*w,v-(1-S[2])*C,m+S[3]*w,v-(1-S[4])*C,y-(1-S[5])*w,g+S[6]*C,y-(1-S[7])*w];var x=d.scaleRate;return x&&1!=x?(c.sourceWidth/=x,c.sourceHeight/=x,c.width/=x,c.height/=x,c.scaleRate=x):c.scaleRate=1,c},Texture.createFromTexture=function(t,e,i,s,n){var r=t.scaleRate;1!=r&&(e*=r,i*=r,s*=r,n*=r);var a=gt.TEMP.setTo(e-t.offsetX,i-t.offsetY,s,n),o=a.intersection(Texture._rect1.setTo(0,0,t.width,t.height),Texture._rect2);return o?Texture.create(t,o.x,o.y,o.width,o.height,o.x-a.x,o.y-a.y,s,n):null},Texture.DEF_UV=[0,0,1,0,1,1,0,1],Texture.NO_UV=[0,0,0,0,0,0,0,0],Texture.INV_UV=[0,1,1,1,1,0,0,0],Texture._rect1=new gt,Texture._rect2=new gt,Texture}()),Ut=function(t){function TextStyle(){this.italic=!1,TextStyle.__super.call(this)}n(TextStyle,"laya.display.css.TextStyle",t);var e=TextStyle.prototype;return e.reset=function(){return t.prototype.reset.call(this),this.italic=!1,this.align="left",this.wordWrap=!1,this.leading=0,this.padding=[0,0,0,0],this.bgColor=null,this.borderColor=null,this.asPassword=!1,this.stroke=0,this.strokeColor="#000000",this.bold=!1,this.underline=!1,this.underlineColor=null,this},e.recover=function(){this!==TextStyle.EMPTY&&y.recover("TextStyle",this.reset())},e.render=function(t,e,i,s){(this.bgColor||this.borderColor)&&e.drawRect(i,s,t.width,t.height,this.bgColor,this.borderColor,1)},TextStyle.create=function(){return y.getItemByClass("TextStyle",TextStyle)},TextStyle.EMPTY=new TextStyle,TextStyle}(C),Nt=(function(t){function Script(){Script.__super.call(this)}n(Script,"laya.components.Script",_);var e=Script.prototype;e._onAwake=function(){this.onAwake(),this.onStart!==laya.components.Script.prototype.onStart&&i.startTimer.callLater(this,this.onStart)},e._onEnable=function(){var t=laya.components.Script.prototype;this.onTriggerEnter!==t.onTriggerEnter&&this.owner.on("triggerenter",this,this.onTriggerEnter),this.onTriggerStay!==t.onTriggerStay&&this.owner.on("triggerstay",this,this.onTriggerStay),this.onTriggerExit!==t.onTriggerExit&&this.owner.on("triggerexit",this,this.onTriggerExit),this.onMouseDown!==t.onMouseDown&&this.owner.on("mousedown",this,this.onMouseDown),this.onMouseUp!==t.onMouseUp&&this.owner.on("mouseup",this,this.onMouseUp),this.onClick!==t.onClick&&this.owner.on("click",this,this.onClick),this.onStageMouseDown!==t.onStageMouseDown&&i.stage.on("mousedown",this,this.onStageMouseDown),this.onStageMouseUp!==t.onStageMouseUp&&i.stage.on("mouseup",this,this.onStageMouseUp),this.onStageClick!==t.onStageClick&&i.stage.on("click",this,this.onStageClick),this.onStageMouseMove!==t.onStageMouseMove&&i.stage.on("mousemove",this,this.onStageMouseMove),this.onDoubleClick!==t.onDoubleClick&&this.owner.on("doubleclick",this,this.onDoubleClick),this.onRightClick!==t.onRightClick&&this.owner.on("rightclick",this,this.onRightClick),this.onMouseMove!==t.onMouseMove&&this.owner.on("mousemove",this,this.onMouseMove),this.onMouseOver!==t.onMouseOver&&this.owner.on("mouseover",this,this.onMouseOver),this.onMouseOut!==t.onMouseOut&&this.owner.on("mouseout",this,this.onMouseOut),this.onKeyDown!==t.onKeyDown&&i.stage.on("keydown",this,this.onKeyDown),this.onKeyPress!==t.onKeyPress&&i.stage.on("keypress",this,this.onKeyPress),this.onKeyUp!==t.onKeyUp&&i.stage.on("keyup",this,this.onKeyUp),this.onUpdate!==t.onUpdate&&i.updateTimer.frameLoop(1,this,this.onUpdate),this.onLateUpdate!==t.onLateUpdate&&i.lateTimer.frameLoop(1,this,this.onLateUpdate),this.onPreRender!==t.onPreRender&&i.lateTimer.frameLoop(1,this,this.onPreRender)},e._onDisable=function(){this.owner.offAllCaller(this),i.stage.offAllCaller(this),i.startTimer.clearAll(this),i.updateTimer.clearAll(this),i.lateTimer.clearAll(this)},e._isScript=function(){return!0},e._onDestroy=function(){this.onDestroy()},e.onAwake=function(){},e.onEnable=function(){},e.onStart=function(){},e.onTriggerEnter=function(t,e,i){},e.onTriggerStay=function(t,e,i){},e.onTriggerExit=function(t,e,i){},e.onMouseDown=function(t){},e.onMouseUp=function(t){},e.onClick=function(t){},e.onStageMouseDown=function(t){},e.onStageMouseUp=function(t){},e.onStageClick=function(t){},e.onStageMouseMove=function(t){},e.onDoubleClick=function(t){},e.onRightClick=function(t){},e.onMouseMove=function(t){},e.onMouseOver=function(t){},e.onMouseOut=function(t){},e.onKeyDown=function(t){},e.onKeyPress=function(t){},e.onKeyUp=function(t){},e.onUpdate=function(){},e.onLateUpdate=function(){},e.onPreRender=function(){},e.onPostRender=function(){},e.onDisable=function(){},e.onDestroy=function(){},r(0,e,"isSingleton",function(){return!1})}(),function(t){var e;function TimeLine(){this._labelDic=null,this._tweenDic={},this._tweenDataList=[],this._endTweenDataList=null,this._currTime=0,this._lastTime=0,this._startTime=0,this._index=0,this._gidIndex=0,this._firstTweenDic={},this._startTimeSort=!1,this._endTimeSort=!1,this._loopKey=!1,this.scale=1,this._frameRate=60,this._frameIndex=0,this._total=0,TimeLine.__super.call(this)}n(TimeLine,"laya.utils.TimeLine",h);var s=TimeLine.prototype;return s.to=function(t,e,i,s,n){return void 0===n&&(n=0),this._create(t,e,i,s,n,!0)},s.from=function(t,e,i,s,n){return void 0===n&&(n=0),this._create(t,e,i,s,n,!1)},s._create=function(t,i,s,n,r,a){var o=y.getItemByClass("tweenData",e);return o.isTo=a,o.type=0,o.target=t,o.duration=s,o.data=i,o.startTime=this._startTime+r,o.endTime=o.startTime+o.duration,o.ease=n,this._startTime=Math.max(o.endTime,this._startTime),this._tweenDataList.push(o),this._startTimeSort=!0,this._endTimeSort=!0,this},s.addLabel=function(t,i){var s=y.getItemByClass("tweenData",e);return s.type=1,s.data=t,s.endTime=s.startTime=this._startTime+i,this._labelDic||(this._labelDic={}),this._labelDic[t]=s,this._tweenDataList.push(s),this},s.removeLabel=function(t){if(this._labelDic&&this._labelDic[t]){var e=this._labelDic[t];if(e){var i=this._tweenDataList.indexOf(e);i>-1&&this._tweenDataList.splice(i,1)}delete this._labelDic[t]}},s.gotoTime=function(t){if(null!=this._tweenDataList&&0!=this._tweenDataList.length){var e,i,s,n;for(var r in this._firstTweenDic)if(i=this._firstTweenDic[r])for(var a in i)i.diyTarget.hasOwnProperty(a)&&(i.diyTarget[a]=i[a]);for(r in this._tweenDic)(e=this._tweenDic[r]).clear(),delete this._tweenDic[r];if(this._index=0,this._gidIndex=0,this._currTime=t,this._lastTime=P.now(),null==this._endTweenDataList||this._endTimeSort){this._endTimeSort=!1,this._endTweenDataList=s=this._tweenDataList.concat(),s.sort(function(t,e){return t.endTime>e.endTime?1:t.endTime<e.endTime?-1:0})}else s=this._endTweenDataList;for(var o=0,h=s.length;o<h;o++)if(0==(n=s[o]).type){if(!(t>=n.endTime))break;this._index=Math.max(this._index,o+1);var c=n.data;if(n.isTo)for(var u in c)n.target[u]=c[u]}for(o=0,h=this._tweenDataList.length;o<h;o++)0==(n=this._tweenDataList[o]).type&&t>=n.startTime&&t<n.endTime&&(this._index=Math.max(this._index,o+1),this._gidIndex++,(e=y.getItemByClass("tween",R))._create(n.target,n.data,n.duration,n.ease,l.create(this,this._animComplete,[this._gidIndex]),0,!1,n.isTo,!0,!1),e.setStartTime(this._currTime-(t-n.startTime)),e._updateEase(this._currTime),e.gid=this._gidIndex,this._tweenDic[this._gidIndex]=e)}},s.gotoLabel=function(t){if(null!=this._labelDic){var e=this._labelDic[t];e&&this.gotoTime(e.startTime)}},s.pause=function(){i.timer.clear(this,this._update)},s.resume=function(){this.play(this._currTime,this._loopKey)},s.play=function(t,e){if(void 0===t&&(t=0),void 0===e&&(e=!1),this._tweenDataList){if(this._startTimeSort){this._startTimeSort=!1,this._tweenDataList.sort(function(t,e){return t.startTime>e.startTime?1:t.startTime<e.startTime?-1:0});for(var s=0,n=this._tweenDataList.length;s<n;s++){var r=this._tweenDataList[s];if(null!=r&&0==r.type){var a=r.target,o=a.$_GID||(a.$_GID=_t.getGID()),h=null;for(var l in null==this._firstTweenDic[o]?((h={}).diyTarget=a,this._firstTweenDic[o]=h):h=this._firstTweenDic[o],r.data)null==h[l]&&(h[l]=a[l])}}}"string"==typeof t?this.gotoLabel(t):this.gotoTime(t),this._loopKey=e,this._lastTime=P.now(),i.timer.frameLoop(1,this,this._update)}},s._update=function(){if(this._currTime>=this._startTime){if(!this._loopKey){for(var t in this._tweenDic)(e=this._tweenDic[t]).complete();return this._complete(),void this.pause()}if(this._complete(),!this._tweenDataList)return;this.gotoTime(0)}var e,i=P.now(),s=i-this._lastTime,n=this._currTime+=s*this.scale;for(t in this._lastTime=i,this._tweenDic)(e=this._tweenDic[t])._updateEase(n);if(0!=this._tweenDataList.length&&this._index<this._tweenDataList.length){var r=this._tweenDataList[this._index];n>=r.startTime&&(this._index++,0==r.type?(this._gidIndex++,(e=y.getItemByClass("tween",R))._create(r.target,r.data,r.duration,r.ease,l.create(this,this._animComplete,[this._gidIndex]),0,!1,r.isTo,!0,!1),e.setStartTime(n),e.gid=this._gidIndex,this._tweenDic[this._gidIndex]=e,e._updateEase(n)):this.event("label",r.data))}},s._animComplete=function(t){this._tweenDic[t]&&delete this._tweenDic[t]},s._complete=function(){this.event("complete")},s.reset=function(){var t;if(this._labelDic)for(t in this._labelDic)delete this._labelDic[t];for(t in this._tweenDic)this._tweenDic[t].clear(),delete this._tweenDic[t];for(t in this._firstTweenDic)delete this._firstTweenDic[t];if(this._endTweenDataList=null,this._tweenDataList&&this._tweenDataList.length){var e,s=0;for(e=this._tweenDataList.length,s=0;s<e;s++)this._tweenDataList[s]&&this._tweenDataList[s].destroy()}this._tweenDataList.length=0,this._currTime=0,this._lastTime=0,this._startTime=0,this._index=0,this._gidIndex=0,this.scale=1,i.timer.clear(this,this._update)},s.destroy=function(){this.reset(),this._labelDic=null,this._tweenDic=null,this._tweenDataList=null,this._firstTweenDic=null},r(0,s,"index",function(){return this._frameIndex},function(t){this._frameIndex=t,this.gotoTime(this._frameIndex/this._frameRate*1e3)}),r(0,s,"total",function(){return this._total=Math.floor(this._startTime/1e3*this._frameRate),this._total}),TimeLine.to=function(t,e,i,s,n){return void 0===n&&(n=0),(new TimeLine).to(t,e,i,s,n)},TimeLine.from=function(t,e,i,s,n){return void 0===n&&(n=0),(new TimeLine).from(t,e,i,s,n)},TimeLine.__init$=function(){e=function(){function tweenData(){this.type=0,this.isTo=!0,this.startTime=NaN,this.endTime=NaN,this.target=null,this.duration=NaN,this.ease=null,this.data=null}return n(tweenData,""),tweenData.prototype.destroy=function(){this.target=null,this.ease=null,this.data=null,this.isTo=!0,this.type=0,y.recover("tweenData",this)},tweenData}()},TimeLine}()),Wt=function(t){function HttpRequest(){this._responseType=null,this._data=null,this._url=null,HttpRequest.__super.call(this),this._http=new P.window.XMLHttpRequest}n(HttpRequest,"laya.net.HttpRequest",h);var e=HttpRequest.prototype;return e.send=function(t,e,i,s,n){void 0===i&&(i="get"),void 0===s&&(s="text"),this._responseType=s,this._data=null,this._url=t;var r=this,a=this._http;if(t=v.getAdptedFilePath(t),a.open(i,t,!0),n)for(var o=0;o<n.length;o++)a.setRequestHeader(n[o++],n[o]);else xt.isConchApp||(e&&"string"!=typeof e?a.setRequestHeader("Content-Type","application/json"):a.setRequestHeader("Content-Type","application/x-www-form-urlencoded"));a.responseType="arraybuffer"!==s?"text":"arraybuffer",a.onerror=function(t){r._onError(t)},a.onabort=function(t){r._onAbort(t)},a.onprogress=function(t){r._onProgress(t)},a.onload=function(t){r._onLoad(t)},a.send(e)},e._onProgress=function(t){t&&t.lengthComputable&&this.event("progress",t.loaded/t.total)},e._onAbort=function(t){this.error("Request was aborted by user")},e._onError=function(t){this.error("Request failed Status:"+this._http.status+" text:"+this._http.statusText)},e._onLoad=function(t){var e=this._http,i=void 0!==e.status?e.status:200;200===i||204===i||0===i?this.complete():this.error("["+e.status+"]"+e.statusText+":"+e.responseURL)},e.error=function(t){this.clear(),console.warn(this.url,t),this.event("error",t)},e.complete=function(){this.clear();var t=!0;try{"json"===this._responseType?this._data=JSON.parse(this._http.responseText):"xml"===this._responseType?this._data=_t.parseXMLFromString(this._http.responseText):this._data=this._http.response||this._http.responseText}catch(e){t=!1,this.error(e.message)}t&&this.event("complete",this._data instanceof Array?[this._data]:this._data)},e.clear=function(){var t=this._http;t.onerror=t.onabort=t.onprogress=t.onload=null},r(0,e,"url",function(){return this._url}),r(0,e,"http",function(){return this._http}),r(0,e,"data",function(){return this._data}),HttpRequest}(),Gt=function(t){function AutoBitmap(){this.autoCacheCmd=!0,this._width=0,this._height=0,this._source=null,this._sizeGrid=null,this._isChanged=!1,this._offset=null,AutoBitmap.__super.call(this)}n(AutoBitmap,"laya.ui.AutoBitmap",t);var e=AutoBitmap.prototype;return e.destroy=function(){t.prototype.destroy.call(this),this._source=null,this._sizeGrid=null,this._offset=null},e._setChanged=function(){this._isChanged||(this._isChanged=!0,i.timer.callLater(this,this.changeSource))},e.changeSource=function(){this._isChanged=!1;var t=this._source;if(t&&t.bitmap){var e=this.width,i=this.height,s=this._sizeGrid,n=t.sourceWidth,r=t.sourceHeight;if(!s||n===e&&r===i)this.clear(),this.drawTexture(t,this._offset?this._offset[0]:0,this._offset?this._offset[1]:0,e,i);else{this.clear();var a=s[0],o=s[1],h=s[2],l=s[3],c=s[4],u=!1;if(e==n&&(l=o=0),i==r&&(a=h=0),l+o>e){var _=e;u=!0,e=l+o,this.save(),this.clipRect(0,0,_,i)}l&&a&&this.drawImage(AutoBitmap.getTexture(t,0,0,l,a),0,0,l,a),o&&a&&this.drawImage(AutoBitmap.getTexture(t,n-o,0,o,a),e-o,0,o,a),l&&h&&this.drawImage(AutoBitmap.getTexture(t,0,r-h,l,h),0,i-h,l,h),o&&h&&this.drawImage(AutoBitmap.getTexture(t,n-o,r-h,o,h),e-o,i-h,o,h),a&&this.drawBitmap(c,AutoBitmap.getTexture(t,l,0,n-l-o,a),l,0,e-l-o,a),h&&this.drawBitmap(c,AutoBitmap.getTexture(t,l,r-h,n-l-o,h),l,i-h,e-l-o,h),l&&this.drawBitmap(c,AutoBitmap.getTexture(t,0,a,l,r-a-h),0,a,l,i-a-h),o&&this.drawBitmap(c,AutoBitmap.getTexture(t,n-o,a,o,r-a-h),e-o,a,o,i-a-h),this.drawBitmap(c,AutoBitmap.getTexture(t,l,a,n-l-o,r-a-h),l,a,e-l-o,i-a-h),u&&this.restore()}this._repaint()}},e.drawBitmap=function(t,e,i,s,n,r){void 0===n&&(n=0),void 0===r&&(r=0),n<.1||r<.1||(!t||e.width==n&&e.height==r?this.drawImage(e,i,s,n,r):this.fillTexture(e,i,s,n,r))},r(0,e,"sizeGrid",function(){return this._sizeGrid},function(t){this._sizeGrid=t,this._setChanged()}),r(0,e,"width",function(){return this._width?this._width:this._source?this._source.sourceWidth:0},function(t){this._width!=t&&(this._width=t,this._setChanged())}),r(0,e,"height",function(){return this._height?this._height:this._source?this._source.sourceHeight:0},function(t){this._height!=t&&(this._height=t,this._setChanged())}),r(0,e,"source",function(){return this._source},function(t){t?(this._source=t,this._setChanged()):(this._source=null,this.clear())}),AutoBitmap.getTexture=function(t,e,i,s,n){var r;return s<=0&&(s=1),n<=0&&(n=1),t.$_GID||(t.$_GID=_t.getGID()),r&&r._getSource()||(r=Ot.createFromTexture(t,e,i,s,n)),r},AutoBitmap}(G),Yt=function(t){function Sprite(){this._x=0,this._y=0,this._width=0,this._height=0,this._visible=!0,this._mouseState=0,this._zOrder=0,this._renderType=0,this._transform=null,this._tfChanged=!1,this._texture=null,this._boundStyle=null,this._graphics=null,this.mouseThrough=!1,this.autoSize=!1,this.hitTestPrior=!1,Sprite.__super.call(this),this._repaint=0,this._style=C.EMPTY,this._cacheStyle=tt.EMPTY}n(Sprite,"laya.display.Sprite",t);var e=Sprite.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,e),this._style&&this._style.recover(),this._cacheStyle&&this._cacheStyle.recover(),this._boundStyle&&this._boundStyle.recover(),this._style=null,this._cacheStyle=null,this._boundStyle=null,this._transform=null,this._graphics&&this._graphics.autoDestroy&&this._graphics.destroy(),this._graphics=null,this.texture=null},e.updateZOrder=function(){_t.updateOrder(this._children)&&this.repaint()},e._getBoundsStyle=function(){return this._boundStyle||(this._boundStyle=k.create()),this._boundStyle},e._setCustomRender=function(){},e._setCacheAs=function(t){},e._checkCanvasEnable=function(){var t=this._cacheStyle.needEnableCanvasRender();this._getCacheStyle().enableCanvasRender=t,t?(this._cacheStyle.needBitmapCache()?this._cacheStyle.cacheAs="bitmap":this._cacheStyle.cacheAs=this._cacheStyle.userSetCache,this._cacheStyle.reCache=!0,this._renderType|=8):(this._cacheStyle.cacheAs="none",this._cacheStyle.releaseContext(),this._renderType&=-9),this._setCacheAs(this._cacheStyle.cacheAs),this._setRenderType(this._renderType)},e.reCache=function(){this._cacheStyle.reCache=!0,this._repaint|=2},e.getRepaint=function(){return this._repaint},e._setX=function(t){this._x=t},e._setY=function(t){this._y=t},e._setWidth=function(t,e){},e._setHeight=function(t,e){},e.setSelfBounds=function(t){this._getBoundsStyle().userBounds=t},e.getBounds=function(){return this._getBoundsStyle().bounds=gt._getWrapRec(this._boundPointsToParent())},e.getSelfBounds=function(){return this._boundStyle&&this._boundStyle.userBounds?this._boundStyle.userBounds:this._graphics||0!==this._children.length||this._texture?this._getBoundsStyle().bounds=gt._getWrapRec(this._getBoundPointsM(!1)):gt.TEMP.setTo(0,0,0,0)},e._boundPointsToParent=function(t){void 0===t&&(t=!1);var e=0,i=0;this._style&&(e=this.pivotX,i=this.pivotY,t=t||0!==this._style.rotation,this._style.scrollRect&&(e+=this._style.scrollRect.x,i+=this._style.scrollRect.y));var s=this._getBoundPointsM(t);if(!s||s.length<1)return s;if(8!=s.length&&(s=t?$.scanPList(s):gt._getWrapRec(s,gt.TEMP)._getBoundPoints()),!this.transform)return _t.transPointList(s,this._x-e,this._y-i),s;var n=et.TEMP,r=0,a=s.length;for(r=0;r<a;r+=2)n.x=s[r],n.y=s[r+1],this.toParentPoint(n),s[r]=n.x,s[r+1]=n.y;return s},e.getGraphicBounds=function(t){return void 0===t&&(t=!1),this._graphics?this._graphics.getBounds(t):gt.TEMP.setTo(0,0,0,0)},e._getBoundPointsM=function(t){if(void 0===t&&(t=!1),this._boundStyle&&this._boundStyle.userBounds)return this._boundStyle.userBounds._getBoundPoints();if(this._boundStyle||this._getBoundsStyle(),this._boundStyle.temBM||(this._boundStyle.temBM=[]),this._style.scrollRect){var e=_t.clearArray(this._boundStyle.temBM),i=gt.TEMP;return i.copyFrom(this._style.scrollRect),_t.concatArray(e,i._getBoundPoints()),e}var s,n,r,a;this._graphics?s=this._graphics.getBoundPoints():(s=_t.clearArray(this._boundStyle.temBM),this._texture&&((i=gt.TEMP).setTo(0,0,this._texture.width,this._texture.height),_t.concatArray(s,i._getBoundPoints())));for(var o=0,h=(a=this._children).length;o<h;o++)(n=a[o])instanceof laya.display.Sprite&&!0===n._visible&&(r=n._boundPointsToParent(t))&&(s=s?_t.concatArray(s,r):r);return s},e._getCacheStyle=function(){return this._cacheStyle===tt.EMPTY&&(this._cacheStyle=tt.create()),this._cacheStyle},e.getStyle=function(){return this._style===C.EMPTY&&(this._style=C.create()),this._style},e.setStyle=function(t){this._style=t},e._setScaleX=function(t){this._style.scaleX=t},e._setScaleY=function(t){this._style.scaleY=t},e._setRotation=function(t){this._style.rotation=t},e._setSkewX=function(t){this._style.skewX=t},e._setSkewY=function(t){this._style.skewY=t},e._createTransform=function(){return Z.create()},e._adjustTransform=function(){this._tfChanged=!1;var t=this._style,e=t.scaleX,i=t.scaleY,s=this._transform||(this._transform=this._createTransform());if(t.rotation||1!==e||1!==i||0!==t.skewX||0!==t.skewY){s._bTransform=!0;var n=.0174532922222222*(t.rotation-t.skewX),r=.0174532922222222*(t.rotation+t.skewY),a=Math.cos(r),o=Math.sin(r),h=Math.sin(n),l=Math.cos(n);s.a=e*a,s.b=e*o,s.c=-i*h,s.d=i*l,s.tx=s.ty=0}else s.identity(),this._renderType&=-3,this._setRenderType(this._renderType);return s},e._setTransform=function(t){},e._setPivotX=function(t){this.getStyle().pivotX=t},e._getPivotX=function(){return this._style.pivotX},e._setPivotY=function(t){this.getStyle().pivotY=t},e._getPivotY=function(){return this._style.pivotY},e._setAlpha=function(t){this._style.alpha!==t&&(this.getStyle().alpha=t,1!==t?this._renderType|=1:this._renderType&=-2,this._setRenderType(this._renderType),this.parentRepaint())},e._getAlpha=function(){return this._style.alpha},e._setBlendMode=function(t){},e._setGraphics=function(t){},e._setGraphicsCallBack=function(){},e._setScrollRect=function(t){},e.pos=function(t,e,i){if(void 0===i&&(i=!1),this._x!==t||this._y!==e){if(this.destroyed)return this;if(i){this._setX(t),this._setY(e),this.parentRepaint(2);var s=this._cacheStyle.maskParent;s&&s.repaint(2)}else this.x=t,this.y=e}return this},e.pivot=function(t,e){return this.pivotX=t,this.pivotY=e,this},e.size=function(t,e){return this.width=t,this.height=e,this},e.scale=function(t,e,i){void 0===i&&(i=!1);var s=this.getStyle();if(s.scaleX!=t||s.scaleY!=e){if(this.destroyed)return this;i?(this._setScaleX(t),this._setScaleY(e),this._setTranformChange()):(this.scaleX=t,this.scaleY=e)}return this},e.skew=function(t,e){return this.skewX=t,this.skewY=e,this},e.render=function(t,e,i){Tt.spriteCount++,Ct.renders[this._renderType]._fun(this,t,e+this._x,i+this._y),this._repaint=0},e.drawToCanvas=function(t,e,i,s){return I.drawToCanvas(this,this._renderType,t,e,i,s)},e.customRender=function(t,e,i){this._repaint=3},e._applyFilters=function(){var t;if(!xt.isWebGL&&((t=this._cacheStyle.filters)&&!(t.length<1)))for(var e=0,i=t.length;e<i;e++)t[e]._action&&t[e]._action.apply(this._cacheStyle)},e._setColorFilter=function(t){},e._isHaveGlowFilter=function(){var t,e=0;if(this.filters)for(e=0;e<this.filters.length;e++)if(8==this.filters[e].type)return!0;for(e=0,t=this._children.length;e<t;e++)if(this._children[e]._isHaveGlowFilter())return!0;return!1},e.localToGlobal=function(t,e,s){void 0===e&&(e=!1),!0===e&&(t=new et(t.x,t.y));var n=this;for(s=s||i.stage;n&&!n.destroyed&&n!=s;)t=n.toParentPoint(t),n=n.parent;return t},e.globalToLocal=function(t,e,s){void 0===e&&(e=!1),e&&(t=new et(t.x,t.y));var n=this,r=[];for(s=s||i.stage;n&&!n.destroyed&&n!=s;)r.push(n),n=n.parent;for(var a=r.length-1;a>=0;)t=(n=r[a]).fromParentPoint(t),a--;return t},e.toParentPoint=function(t){if(!t)return t;t.x-=this.pivotX,t.y-=this.pivotY,this.transform&&this._transform.transformPoint(t),t.x+=this._x,t.y+=this._y;var e=this._style.scrollRect;return e&&(t.x-=e.x,t.y-=e.y),t},e.fromParentPoint=function(t){if(!t)return t;t.x-=this._x,t.y-=this._y;var e=this._style.scrollRect;return e&&(t.x+=e.x,t.y+=e.y),this.transform&&this._transform.invertTransformPoint(t),t.x+=this.pivotX,t.y+=this.pivotY,t},e.fromStagePoint=function(t){return t},e.on=function(e,i,s,n){return 1!==this._mouseState&&this.isMouseEvent(e)?(this.mouseEnabled=!0,this._setBit(64,!0),this._parent&&this._$2__onDisplay(),this._createListener(e,i,s,n,!1)):t.prototype.on.call(this,e,i,s,n)},e.once=function(e,i,s,n){return 1!==this._mouseState&&this.isMouseEvent(e)?(this.mouseEnabled=!0,this._setBit(64,!0),this._parent&&this._$2__onDisplay(),this._createListener(e,i,s,n,!0)):t.prototype.once.call(this,e,i,s,n)},e._$2__onDisplay=function(){if(1!==this._mouseState){var t=this;for(t=t.parent;t&&1!==t._mouseState&&!t._getBit(64);)t.mouseEnabled=!0,t._setBit(64,!0),t=t.parent}},e._setParent=function(e){t.prototype._setParent.call(this,e),e&&this._getBit(64)&&this._$2__onDisplay()},e.loadImage=function(t,e){var i=this;if(null==t)this.texture=null,loaded();else{var s=Ft.getRes(t);s||((s=new Ot).load(t),Ft.cacheRes(t,s)),this.texture=s,s.getIsReady()?loaded():s.once("ready",null,loaded)}function loaded(){i.repaint(3),e&&e.run()}return this},e.repaint=function(t){void 0===t&&(t=2),this._repaint&t||(this._repaint|=t,this.parentRepaint(t)),this._cacheStyle&&this._cacheStyle.maskParent&&this._cacheStyle.maskParent.repaint(t)},e._needRepaint=function(){return 2&this._repaint&&this._cacheStyle.enableCanvasRender&&this._cacheStyle.reCache},e._childChanged=function(t){this._children.length?this._renderType|=8192:this._renderType&=-8193,this._setRenderType(this._renderType),t&&this._getBit(32)&&i.systemTimer.callLater(this,this.updateZOrder),this.repaint(3)},e.parentRepaint=function(t){void 0===t&&(t=2);var e=this._parent;!e||e._repaint&t||(e._repaint|=t,e.parentRepaint(t))},e._setMask=function(t){},e.startDrag=function(t,e,i,s,n,r,a){void 0===e&&(e=!1),void 0===i&&(i=0),void 0===s&&(s=300),void 0===r&&(r=!1),void 0===a&&(a=.92),this._style.dragging||(this.getStyle().dragging=new Lt),this._style.dragging.start(this,t,e,i,s,n,r,a)},e.stopDrag=function(){this._style.dragging&&this._style.dragging.stop()},e._setDisplay=function(e){e||this._cacheStyle&&(this._cacheStyle.releaseContext(),this._cacheStyle.releaseFilterCache(),this._cacheStyle.hasGlowFilter&&(this._cacheStyle.hasGlowFilter=!1)),t.prototype._setDisplay.call(this,e)},e.hitTestPoint=function(t,e){var i=this.globalToLocal(et.TEMP.setTo(t,e));return t=i.x,e=i.y,(this._style.hitArea?this._style.hitArea:this._width>0&&this._height>0?gt.TEMP.setTo(0,0,this._width,this._height):this.getSelfBounds()).contains(t,e)},e.getMousePoint=function(){return this.globalToLocal(et.TEMP.setTo(i.stage.mouseX,i.stage.mouseY))},e._setTexture=function(t){},e._setRenderType=function(t){},e._setTranformChange=function(){this._tfChanged=!0,this._renderType|=2,this.parentRepaint(2)},e._setBgStyleColor=function(t,e,i,s,n){},e._setBorderStyleColor=function(t,e,i,s,n,r){},e.captureMouseEvent=function(t){w.instance.setCapture(this,t)},e.releaseMouseEvent=function(){w.instance.releaseCapture()},r(0,e,"customRenderEnable",null,function(t){t&&(this._renderType|=2048,this._setRenderType(this._renderType),this._setCustomRender())}),r(0,e,"cacheAs",function(){return this._cacheStyle.cacheAs},function(t){t!==this._cacheStyle.userSetCache&&(xt.isConchApp&&"bitmap"!=t||this.mask&&"normal"===t||(this._setCacheAs(t),this._getCacheStyle().userSetCache=t,this._checkCanvasEnable(),this.repaint()))}),r(0,e,"globalScaleY",function(){for(var t=1,e=this;e&&e!==i.stage;)t*=e.scaleY,e=e.parent;return t}),r(0,e,"hitArea",function(){return this._style.hitArea},function(t){this.getStyle().hitArea=t}),r(0,e,"staticCache",function(){return this._cacheStyle.staticCache},function(t){this._getCacheStyle().staticCache=t,t||this.reCache()}),r(0,e,"displayWidth",function(){return this.width*this.scaleX}),r(0,e,"zOrder",function(){return this._zOrder},function(t){this._zOrder!=t&&(this._zOrder=t,this._parent&&(t&&this._parent._setBit(32,!0),i.systemTimer.callLater(this._parent,this.updateZOrder)))}),r(0,e,"rotation",function(){return this._style.rotation},function(t){this.getStyle().rotation!==t&&(this._setRotation(t),this._setTranformChange())}),r(0,e,"width",function(){return this.autoSize?this.texture?this.texture.width:this._graphics||0!==this._children.length?this.getSelfBounds().width:0:this._width||(this.texture?this.texture.width:0)},function(t){this._width!==t&&(this._width=t,this._setWidth(this.texture,t),this._setTranformChange())}),r(0,e,"x",function(){return this._x},function(t){if(!this.destroyed&&this._x!==t){this._setX(t),this.parentRepaint(2);var e=this._cacheStyle.maskParent;e&&e.repaint(2)}}),r(0,e,"drawCallOptimize",function(){return this._getBit(256)},function(t){this._setBit(256,t)}),r(0,e,"texture",function(){return this._texture},function(t){"string"==typeof t?this.loadImage(t):this._texture!=t&&(this._texture&&this._texture._removeReference(),this._texture=t,t&&t._addReference(),this._setTexture(t),this._setWidth(this._texture,this.width),this._setHeight(this._texture,this.height),t?this._renderType|=256:this._renderType&=-257,this._setRenderType(this._renderType),this.repaint())}),r(0,e,"globalRotation",function(){for(var t=0,e=this;e&&e!==i.stage;)t+=e.rotation,e=e.parent;return t}),r(0,e,"y",function(){return this._y},function(t){if(!this.destroyed&&this._y!==t){this._setY(t),this.parentRepaint(2);var e=this._cacheStyle.maskParent;e&&e.repaint(2)}}),r(0,e,"displayHeight",function(){return this.height*this.scaleY}),r(0,e,"height",function(){return this.autoSize?this.texture?this.texture.height:this._graphics||0!==this._children.length?this.getSelfBounds().height:0:this._height||(this.texture?this.texture.height:0)},function(t){this._height!==t&&(this._height=t,this._setHeight(this.texture,t),this._setTranformChange())}),r(0,e,"blendMode",function(){return this._style.blendMode},function(t){this._setBlendMode(t),this.getStyle().blendMode=t,t&&"source-over"!=t?this._renderType|=4:this._renderType&=-5,this._setRenderType(this._renderType),this.parentRepaint()}),r(0,e,"scaleX",function(){return this._style.scaleX},function(t){this.getStyle().scaleX!==t&&(this._setScaleX(t),this._setTranformChange())}),r(0,e,"scaleY",function(){return this._style.scaleY},function(t){this.getStyle().scaleY!==t&&(this._setScaleY(t),this._setTranformChange())}),r(0,e,"stage",function(){return i.stage}),r(0,e,"skewX",function(){return this._style.skewX},function(t){this.getStyle().skewX!==t&&(this._setSkewX(t),this._setTranformChange())}),r(0,e,"scrollRect",function(){return this._style.scrollRect},function(t){this.getStyle().scrollRect=t,this._setScrollRect(t),this.repaint(),t?this._renderType|=64:this._renderType&=-65,this._setRenderType(this._renderType)}),r(0,e,"skewY",function(){return this._style.skewY},function(t){this.getStyle().skewY!==t&&(this._setSkewY(t),this._setTranformChange())}),r(0,e,"transform",function(){return this._tfChanged?this._adjustTransform():this._transform},function(t){this._tfChanged=!1;var e=this._transform||(this._transform=this._createTransform());t.copyTo(e),this._setTransform(e),t&&(this._x=t.tx,this._y=t.ty,t.tx=t.ty=0),t?this._renderType|=2:this._renderType&=-3,this._setRenderType(this._renderType),this.parentRepaint()}),r(0,e,"pivotX",function(){return this._getPivotX()},function(t){this._setPivotX(t),this.repaint()}),r(0,e,"pivotY",function(){return this._getPivotY()},function(t){this._setPivotY(t),this.repaint()}),r(0,e,"alpha",function(){return this._getAlpha()},function(t){t=t<0?0:t>1?1:t,this._setAlpha(t)}),r(0,e,"visible",function(){return this._visible},function(t){this._visible!==t&&(this._visible=t,this.parentRepaint(3))}),r(0,e,"graphics",function(){return this._graphics||(this.graphics=new G,this._graphics.autoDestroy=!0),this._graphics},function(t){this._graphics&&(this._graphics._sp=null),this._graphics=t,t?(this._setGraphics(t),this._renderType|=512,t._sp=this):this._renderType&=-513,this._setRenderType(this._renderType),this.repaint()}),r(0,e,"filters",function(){return this._cacheStyle.filters},function(t){t&&0===t.length&&(t=null),this._cacheStyle.filters!=t&&(this._getCacheStyle().filters=t?t.slice():null,(xt.isWebGL||xt.isConchApp)&&(t&&t.length?(this._setColorFilter(t[0]),this._renderType|=16):(this._setColorFilter(null),this._renderType&=-17),this._setRenderType(this._renderType)),t&&t.length>0?(this._getBit(16)||this._setBitUp(16),(xt.isWebGL||xt.isConchApp)&&1==t.length&&t[0]instanceof laya.filters.ColorFilter||(this._getCacheStyle().cacheForFilters=!0,this._checkCanvasEnable())):this._cacheStyle.cacheForFilters&&(this._cacheStyle.cacheForFilters=!1,this._checkCanvasEnable()),this._getCacheStyle().hasGlowFilter=this._isHaveGlowFilter(),this.repaint())}),r(0,e,"mask",function(){return this._cacheStyle.mask},function(t){t&&this.mask&&this.mask._cacheStyle.maskParent||(this._getCacheStyle().mask=t,this._setMask(t),this._checkCanvasEnable(),t?t._getCacheStyle().maskParent=this:this.mask&&(this.mask._getCacheStyle().maskParent=null),this._renderType|=32,this._setRenderType(this._renderType),this.parentRepaint(3))}),r(0,e,"mouseEnabled",function(){return this._mouseState>1},function(t){this._mouseState=t?2:1}),r(0,e,"globalScaleX",function(){for(var t=1,e=this;e&&e!==i.stage;)t*=e.scaleX,e=e.parent;return t}),r(0,e,"mouseX",function(){return this.getMousePoint().x}),r(0,e,"mouseY",function(){return this.getMousePoint().y}),r(0,e,"viewport",function(){return this._style.viewport},function(t){var e;"string"==typeof t&&((e=t.split(",")).length>3&&(t=new gt(parseFloat(e[0]),parseFloat(e[1]),parseFloat(e[2]),parseFloat(e[3]))));this.getStyle().viewport=t}),Sprite.fromImage=function(t){return(new Sprite).loadImage(t)},Sprite}(Dt),Ht=function(t){function Bitmap(){Bitmap.__super.call(this),this._width=-1,this._height=-1}n(Bitmap,"laya.resource.Bitmap",At);var e=Bitmap.prototype;return e._getSource=function(){throw"Bitmap: must override it."},r(0,e,"width",function(){return this._width}),r(0,e,"height",function(){return this._height}),Bitmap}(),Xt=function(t){function Scene(){this.autoDestroyAtClosed=!1,this.url=null,this._timer=null,this._viewCreated=!1,this._idMap=null,this._$componentType="Scene",Scene.__super.call(this),this._setBit(8,!0),Scene.unDestroyedScenes.push(this),this._scene=this,this.createChildren()}n(Scene,"laya.display.Scene",t);var e=Scene.prototype;return e.createChildren=function(){},e.loadScene=function(t){var e=t.indexOf(".")>-1?t:t+".scene",s=i.loader.getRes(e);if(s)this.createView(s);else{i.loader.resetProgress();var n=new Et;n.on("complete",this,this._onSceneLoaded,[e]),n.load(e)}},e._onSceneLoaded=function(t){this.createView(Ft.getRes(t))},e.createView=function(t){t&&!this._viewCreated&&(this._viewCreated=!0,nt.createByData(this,t))},e.getNodeByID=function(t){return this._idMap?this._idMap[t]:null},e.open=function(t,e){void 0===t&&(t=!0),t&&Scene.closeAll(),Scene.root.addChild(this.scene),this.onOpened(e)},e.onOpened=function(t){},e.close=function(t){this.autoDestroyAtClosed?this.destroy():this.removeSelf(),this.onClosed(t)},e.onClosed=function(t){},e.destroy=function(e){void 0===e&&(e=!0),this._idMap=null,t.prototype.destroy.call(this,e);for(var i=laya.display.Scene.unDestroyedScenes,s=i.length-1;s>-1;s--)if(i[s]===this)return void i.splice(s,1)},e._sizeChanged=function(){this.event("resize")},r(0,e,"scaleX",t.prototype._$get_scaleX,function(t){i.superGet(Yt,this,"scaleX")!=t&&(i.superSet(Yt,this,"scaleX",t),this.event("resize"))}),r(0,e,"scaleY",t.prototype._$get_scaleY,function(t){i.superGet(Yt,this,"scaleY")!=t&&(i.superSet(Yt,this,"scaleY",t),this.event("resize"))}),r(0,e,"width",function(){if(this._width)return this._width;for(var t=0,e=this.numChildren-1;e>-1;e--){var i=this.getChildAt(e);i._visible&&(t=Math.max(i._x+i.width*i.scaleX,t))}return t},function(t){i.superGet(Yt,this,"width")!=t&&(i.superSet(Yt,this,"width",t),this.callLater(this._sizeChanged))}),r(0,e,"timer",function(){return this._timer||i.timer},function(t){this._timer=t}),r(0,e,"height",function(){if(this._height)return this._height;for(var t=0,e=this.numChildren-1;e>-1;e--){var i=this.getChildAt(e);i._visible&&(t=Math.max(i._y+i.height*i.scaleY,t))}return t},function(t){i.superGet(Yt,this,"height")!=t&&(i.superSet(Yt,this,"height",t),this.callLater(this._sizeChanged))}),r(1,Scene,"root",function(){if(!Scene._root){function resize(){Scene._root.size(i.stage.width,i.stage.height),Scene._root.event("resize")}Scene._root=i.stage.addChild(new Yt),Scene._root.name="root",i.stage.on("resize",null,resize),resize()}return Scene._root},laya.display.Sprite._$SET_root),Scene.load=function(t,e,s){i.loader.resetProgress();var n=new Et;function onProgress(t){Scene._loadPage&&Scene._loadPage.event("progress",t),s&&s.runWith(t)}n.on("progress",null,onProgress),n.once("complete",null,function(){n.off("progress",null,onProgress);var i=Ft.getRes(t);if(!i)throw"Can not find scene:"+t;if(!i.props)throw"Scene data is error:"+t;var s=i.props.runtime?i.props.runtime:i.type,r=dt.getClass(s);if("instance"==i.props.renderType)var a=r.instance||(r.instance=new r);else a=new r;if(!(a&&a instanceof laya.display.Node))throw"Can not find scene:"+s;a.url=t,a._getBit(8)?(a.on("onViewCreated",null,function(){e&&e.runWith(a)}),a.createView(i)):e&&e.runWith(a),Scene.hideLoadingPage()}),n.load(t)},Scene.open=function(t,e,i,s,n){if(void 0===e&&(e=!0),i instanceof laya.utils.Handler){var r=s;s=i,i=r}Scene.showLoadingPage(),Scene.load(t,l.create(null,this._onSceneLoaded,[e,s,i]),n)},Scene._onSceneLoaded=function(t,e,i,s){s.open(t,i),e&&e.runWith(s)},Scene.close=function(t,e){void 0===e&&(e="");for(var i=!1,s=laya.display.Scene.unDestroyedScenes,n=0,r=s.length;n<r;n++){var a=s[n];a&&a.parent&&a.url===t&&a.name==e&&(a.close(),i=!0)}return i},Scene.closeAll=function(){for(var t=laya.display.Scene.root,e=0,i=t.numChildren;e<i;e++){var s=t.getChildAt(0);s instanceof laya.display.Scene?s.close():s.removeSelf()}},Scene.destroy=function(t,e){void 0===e&&(e="");for(var i=!1,s=laya.display.Scene.unDestroyedScenes,n=0,r=s.length;n<r;n++){var a=s[n];a.url===t&&a.name==e&&(a.destroy(),i=!0)}return i},Scene.gc=function(){At.destroyUnusedResources()},Scene.setLoadingPage=function(t){Scene._loadPage!=t&&(Scene._loadPage=t)},Scene.showLoadingPage=function(t,e){void 0===e&&(e=500),Scene._loadPage&&(i.systemTimer.clear(null,Scene._showLoading),i.systemTimer.clear(null,Scene._hideLoading),i.systemTimer.once(e,null,Scene._showLoading,[t],!1))},Scene._showLoading=function(t){i.stage.addChild(Scene._loadPage),Scene._loadPage.onOpened(t)},Scene._hideLoading=function(){Scene._loadPage.close()},Scene.hideLoadingPage=function(t){void 0===t&&(t=500),Scene._loadPage&&(i.systemTimer.clear(null,Scene._showLoading),i.systemTimer.clear(null,Scene._hideLoading),i.systemTimer.once(t,null,Scene._hideLoading))},Scene.unDestroyedScenes=[],Scene._root=null,Scene._loadPage=null,Scene}(Yt),zt=function(e){function Text(){this._clipPoint=null,this._text=null,this._isChanged=!1,this._textWidth=0,this._textHeight=0,this._lines=[],this._lineWidths=[],this._startX=0,this._startY=0,this._words=null,this._charSize={},this._valign="top",this._color="#000000",Text.__super.call(this),this._fontSize=Text.defaultFontSize,this._font=Text.defaultFont,this.overflow="visible",this._style=Ut.EMPTY}n(Text,"laya.display.Text",e);var a=Text.prototype;return a.getStyle=function(){return this._style===Ut.EMPTY&&(this._style=Ut.create()),this._style},a._getTextStyle=function(){return this._style===Ut.EMPTY&&(this._style=Ut.create()),this._style},a.destroy=function(t){void 0===t&&(t=!0),e.prototype.destroy.call(this,t),this._clipPoint=null,this._lines=null,this._lineWidths=null,this._words=null,this._charSize=null},a._getBoundPointsM=function(t){void 0===t&&(t=!1);var e=gt.TEMP;return e.setTo(0,0,this.width,this.height),e._getBoundPoints()},a.getGraphicBounds=function(t){void 0===t&&(t=!1);var e=gt.TEMP;return e.setTo(0,0,this.width,this.height),e},a._getCSSStyle=function(){return this._style},a.lang=function(t,e,i,s,n,r,a,o,h,l,c){if(t=Text.langPacks&&Text.langPacks[t]?Text.langPacks[t]:t,arguments.length<2)this._text=t;else{for(var u=0,_=arguments.length;u<_;u++)t=t.replace("{"+u+"}",arguments[u+1]);this._text=t}},a._getContextFont=function(){return(this.italic?"italic ":"")+(this.bold?"bold ":"")+this.fontSize+"px "+(P.onIPhone&&laya.display.Text.fontFamilyMap[this.font]||this.font)},a._isPassWordMode=function(){var t=this._style.asPassword;return"prompt"in this&&this.prompt==this._text&&(t=!1),t},a._getPassWordTxt=function(t){var e;e="";for(var i=t.length;i>0;i--)e+="●";return e},a._renderText=function(){var t=this.padding,e=this._lines.length;"visible"!=this.overflow&&(e=Math.min(e,Math.floor((this.height-t[0]-t[2])/(this.leading+this._charSize.height))+1));var i=this.scrollY/(this._charSize.height+this.leading)|0,s=this.graphics;s.clear(!0);var n=this._getContextFont();P.context.font=n;var r=t[3],a="left",o=this._lines,h=this.leading+this._charSize.height,l=t[0];if(this._width>0&&this._textWidth<=this._width&&("right"==this.align?(a="right",r=this._width-t[1]):"center"==this.align&&(a="center",r=.5*this._width+t[3]-t[1])),this._height>0){var c=this._textHeight>this._height?"top":this.valign;"middle"===c?l=.5*(this._height-e*h)+t[0]-t[2]:"bottom"===c&&(l=this._height-e*h-t[2])}var u=this._style;this._clipPoint&&(s.save(),s.clipRect(t[3],t[0],this._width?this._width-t[3]-t[1]:this._textWidth,this._height?this._height-t[0]-t[2]:this._textHeight),this.repaint());var _=u.asPassword;"prompt"in this&&this.prompt==this._text&&(_=!1);for(var d=0,f=0,p=Math.min(this._lines.length,e+i)||1,g=i;g<p;g++){var m,v=o[g];if(_){var y=v.length;v="";for(var C=y;C>0;C--)v+="●"}null==v&&(v=""),d=r-(this._clipPoint?this._clipPoint.x:0),f=l+h*g-(this._clipPoint?this._clipPoint.y:0),this.underline&&this._drawUnderline(a,d,f,g),xt.isWebGL?(this._words||(this._words=[]),(m=this._words.length>g-i?this._words[g-i]:new j).setText(v)):m=v,u.stroke?s.fillBorderText(m,d,f,n,this.color,u.strokeColor,u.stroke,a):s.fillText(m,d,f,n,this.color,a)}this._clipPoint&&s.restore(),this._startX=r,this._startY=l},a._drawUnderline=function(t,e,i,s){var n=this._lineWidths[s];switch(t){case"center":e-=n/2;break;case"right":e-=n}i+=this._charSize.height,this._graphics.drawLine(e,i,e+n,i,this.underlineColor||this.color,1)},a.typeset=function(){if(this._isChanged=!1,!this._text)return this._clipPoint=null,this._textWidth=this._textHeight=0,void this.graphics.clear(!0);xt.isConchApp?t.conchTextCanvas.font=this._getContextFont():P.context.font=this._getContextFont(),this._lines.length=0,this._lineWidths.length=0,this._isPassWordMode()?this._parseLines(this._getPassWordTxt(this._text)):this._parseLines(this._text),this._evalTextSize(),this._checkEnabledViewportOrNot()?this._clipPoint||(this._clipPoint=new et(0,0)):this._clipPoint=null,this._renderText()},a._evalTextSize=function(){var t,e;t=Math.max.apply(this,this._lineWidths),e=this._lines.length*(this._charSize.height+this.leading)+this.padding[0]+this.padding[2],t==this._textWidth&&e==this._textHeight||(this._textWidth=t,this._textHeight=e)},a._checkEnabledViewportOrNot=function(){return"scroll"==this.overflow&&(this._width>0&&this._textWidth>this._width||this._height>0&&this._textHeight>this._height)},a.changeText=function(t){this._text!==t&&(this.lang(t+""),this._graphics&&this._graphics.replaceText(this._text)||this.typeset())},a._parseLines=function(e){var i=this.wordWrap||"hidden"==this.overflow;if(i)var s=this._getWordWrapWidth();var n=null;n=xt.isConchApp?t.conchTextCanvas.measureText(this._testWord):P.context.measureText(Text._testWord),this._charSize.width=n.width,this._charSize.height=n.height||this.fontSize;for(var r=e.replace(/\r\n/g,"\n").split("\n"),a=0,o=r.length;a<o;a++){var h=r[a];i?this._parseLine(h,s):(this._lineWidths.push(this._getTextWidth(h)),this._lines.push(h))}},a._parseLine=function(t,e){P.context;var i,s=this._lines,n=0,r=NaN,a=NaN,o=0;if((r=this._getTextWidth(t))<=e)return s.push(t),void this._lineWidths.push(r);r=this._charSize.width,0==(n=Math.floor(e/r))&&(n=1),a=r=this._getTextWidth(t.substring(0,n));for(var h=n,l=t.length;h<l;h++)if((a+=r=this._getTextWidth(t.charAt(h)))>e)if(this.wordWrap){var c=t.substring(o,h);if(c.charCodeAt(c.length-1)<255&&(i=/(?:\w|-)+$/.exec(c))&&(h=i.index+o,0==i.index?h+=c.length:c=t.substring(o,h)),s.push(c),this._lineWidths.push(a-r),o=h,!(h+n<l)){s.push(t.substring(o,l)),this._lineWidths.push(this._getTextWidth(s[s.length-1])),o=-1;break}h+=n,a=r=this._getTextWidth(t.substring(o,h)),h--}else if("hidden"==this.overflow)return s.push(t.substring(0,h)),void this._lineWidths.push(this._getTextWidth(s[s.length-1]));this.wordWrap&&-1!=o&&(s.push(t.substring(o,l)),this._lineWidths.push(this._getTextWidth(s[s.length-1])))},a._getTextWidth=function(e){return xt.isConchApp?t.conchTextCanvas.measureText(e).width:P.context.measureText(e).width},a._getWordWrapWidth=function(){var t=this.padding,e=NaN;return(e=this._width)<=0&&(e=this.wordWrap?100:P.width),e<=0&&(e=100),e-t[3]-t[1]},a.getCharPoint=function(t,e){this._isChanged&&i.systemTimer.runCallLater(this,this.typeset);for(var s=0,n=this._lines,r=0,a=0,o=n.length;a<o;a++){if(t<(s+=n[a].length)){var h=a;break}r=s}var l=(this.italic?"italic ":"")+(this.bold?"bold ":"")+this.fontSize+"px "+this.font;P.context.font=l;var c=this._getTextWidth(this._text.substring(r,t));return(e||new et).setTo(this._startX+c-(this._clipPoint?this._clipPoint.x:0),this._startY+h*(this._charSize.height+this.leading)-(this._clipPoint?this._clipPoint.y:0))},r(0,a,"width",function(){return this._width?this._width:this.textWidth+this.padding[1]+this.padding[3]},function(t){t!=this._width&&(i.superSet(Yt,this,"width",t),this.isChanged=!0,this.borderColor&&this._setBorderStyleColor(0,0,this.width,this.height,this.borderColor,1))}),r(0,a,"textWidth",function(){return this._isChanged&&i.systemTimer.runCallLater(this,this.typeset),this._textWidth}),r(0,a,"height",function(){return this._height?this._height:this.textHeight},function(t){t!=this._height&&(i.superSet(Yt,this,"height",t),this.isChanged=!0,this.borderColor&&this._setBorderStyleColor(0,0,this.width,this.height,this.borderColor,1))}),r(0,a,"textHeight",function(){return this._isChanged&&i.systemTimer.runCallLater(this,this.typeset),this._textHeight}),r(0,a,"padding",function(){return this._style.padding},function(t){if("string"==typeof t){var e,i,s=0;for(i=(e=t.split(",")).length;e.length<4;)e.push(0);for(s=0;s<i;s++)e[s]=parseFloat(e[s])||0;t=e}this._getTextStyle().padding=t,this.isChanged=!0}),r(0,a,"bold",function(){return this._style.bold},function(t){this._getTextStyle().bold=t,this.isChanged=!0}),r(0,a,"text",function(){return this._text||""},function(t){this._text!==t&&(this.lang(t+""),this.isChanged=!0,this.event("change"),this.borderColor&&this._setBorderStyleColor(0,0,this.width,this.height,this.borderColor,1))}),r(0,a,"color",function(){return this._color},function(t){this._color!=t&&(this._color=t,!this._isChanged&&this._graphics?this._graphics.replaceTextColor(this.color):this.isChanged=!0)}),r(0,a,"font",function(){return this._font},function(t){this._font=t,this.isChanged=!0}),r(0,a,"fontSize",function(){return this._fontSize},function(t){this._fontSize!=t&&(this._fontSize=t,this.isChanged=!0)}),r(0,a,"italic",function(){return this._style.italic},function(t){this._getTextStyle().italic=t,this.isChanged=!0}),r(0,a,"align",function(){return this._style.align},function(t){this._getTextStyle().align=t,this.isChanged=!0}),r(0,a,"valign",function(){return this._valign},function(t){this._valign=t,this.isChanged=!0}),r(0,a,"wordWrap",function(){return this._style.wordWrap},function(t){this._getTextStyle().wordWrap=t,this.isChanged=!0}),r(0,a,"leading",function(){return this._style.leading},function(t){this._getTextStyle().leading=t,this.isChanged=!0}),r(0,a,"bgColor",function(){return this._style.bgColor},function(t){this._getTextStyle().bgColor=t,this._renderType|=128,this._setBgStyleColor(0,0,this.width,this.height,t),this._setRenderType(this._renderType),this.isChanged=!0}),r(0,a,"borderColor",function(){return this._style.borderColor},function(t){this._getTextStyle().borderColor=t,this._renderType|=128,this._setBorderStyleColor(0,0,this.width,this.height,t,1),this._setRenderType(this._renderType),this.isChanged=!0}),r(0,a,"stroke",function(){return this._style.stroke},function(t){this._getTextStyle().stroke=t,this.isChanged=!0}),r(0,a,"strokeColor",function(){return this._style.strokeColor},function(t){this._getTextStyle().strokeColor=t,this.isChanged=!0}),r(0,a,"isChanged",null,function(t){this._isChanged!==t&&(this._isChanged=t,t&&i.systemTimer.callLater(this,this.typeset))}),r(0,a,"scrollX",function(){return this._clipPoint?this._clipPoint.x:0},function(t){if(!("scroll"!=this.overflow||this.textWidth<this._width)&&this._clipPoint){t=t<this.padding[3]?this.padding[3]:t;var e=this._textWidth-this._width;t=t>e?e:t,this._clipPoint.x=t,this._renderText()}}),r(0,a,"scrollY",function(){return this._clipPoint?this._clipPoint.y:0},function(t){if(!("scroll"!=this.overflow||this.textHeight<this._height)&&this._clipPoint){t=t<this.padding[0]?this.padding[0]:t;var e=this._textHeight-this._height;t=t>e?e:t,this._clipPoint.y=t,this._renderText()}}),r(0,a,"maxScrollX",function(){return this.textWidth<this._width?0:this._textWidth-this._width}),r(0,a,"maxScrollY",function(){return this.textHeight<this._height?0:this._textHeight-this._height}),r(0,a,"lines",function(){return this._isChanged&&this.typeset(),this._lines}),r(0,a,"underlineColor",function(){return this._style.underlineColor},function(t){this._getTextStyle().underlineColor=t,this._isChanged||this._renderText()}),r(0,a,"underline",function(){return this._style.underline},function(t){this._getTextStyle().underline=t}),Text.defaultFontStr=function(){return Text.defaultFontSize+"px "+Text.defaultFont},Text.unregisterBitmapFont=function(t,e){void 0===e&&(e=!0),Text._bitmapFonts&&Text._bitmapFonts[t]&&delete Text._bitmapFonts[t]},Text.VISIBLE="visible",Text.SCROLL="scroll",Text.HIDDEN="hidden",Text.defaultFontSize=12,Text.defaultFont="Arial",Text.langPacks=null,Text.isComplexText=!1,Text._testWord="游",Text._bitmapFonts=null,Text.CharacterCache=!0,Text.RightToLeft=!1,s(Text,["fontFamilyMap",function(){return this.fontFamilyMap={"报隶":"报隶-简","黑体":"黑体-简","楷体":"楷体-简","兰亭黑":"兰亭黑-简","隶变":"隶变-简","凌慧体":"凌慧体-简","翩翩体":"翩翩体-简","苹方":"苹方-简","手札体":"手札体-简","宋体":"宋体-简","娃娃体":"娃娃体-简","魏碑":"魏碑-简","行楷":"行楷-简","雅痞":"雅痞-简","圆体":"圆体-简"}}]),Text}(Yt),Vt=function(t){function UIComponent(){this._dataSource=null,this._toolTip=null,this._tag=null,this._disabled=!1,this._gray=!1,UIComponent.__super.call(this),this._anchorX=NaN,this._anchorY=NaN,this._widget=Pt.EMPTY,this.preinitialize(),this.createChildren(),this.initialize()}n(UIComponent,"laya.ui.UIComponent",t);var e=UIComponent.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,e),this._dataSource=null,this._tag=null,this._toolTip=null},e.preinitialize=function(){},e.createChildren=function(){},e.initialize=function(){},e.measureWidth=function(){var t=0;this.commitMeasure();for(var e=this.numChildren-1;e>-1;e--){var i=this.getChildAt(e);i._visible&&(t=Math.max(i._x+i.width*i.scaleX,t))}return t},e.commitMeasure=function(){},e.measureHeight=function(){var t=0;this.commitMeasure();for(var e=this.numChildren-1;e>-1;e--){var i=this.getChildAt(e);i._visible&&(t=Math.max(i._y+i.height*i.scaleY,t))}return t},e._sizeChanged=function(){isNaN(this._anchorX)||(this.pivotX=this.anchorX*this.width),isNaN(this._anchorY)||(this.pivotY=this.anchorY*this.height),this.event("resize"),this._widget!==Pt.EMPTY&&this._widget.resetLayout()},e.onMouseOver=function(t){i.stage.event("showtip",this._toolTip)},e.onMouseOut=function(t){i.stage.event("hidetip",this._toolTip)},e._getWidget=function(){return this._widget===Pt.EMPTY&&(this._widget=this.addComponent(Pt)),this._widget},e.onCompResize=function(){this._sizeChanged()},e._childChanged=function(e){this.callLater(this._sizeChanged),t.prototype._childChanged.call(this,e)},r(0,e,"centerY",function(){return this._widget.centerY},function(t){t!=this._widget.centerY&&(this._getWidget().centerY=t)}),r(0,e,"width",function(){return this._width?this._width:this.measureWidth()},function(t){i.superGet(Yt,this,"width")!=t&&(i.superSet(Yt,this,"width",t),this.callLater(this._sizeChanged))}),r(0,e,"bottom",function(){return this._widget.bottom},function(t){t!=this._widget.bottom&&(this._getWidget().bottom=t)}),r(0,e,"height",function(){return this._height?this._height:this.measureHeight()},function(t){i.superGet(Yt,this,"height")!=t&&(i.superSet(Yt,this,"height",t),this.callLater(this._sizeChanged))}),r(0,e,"left",function(){return this._widget.left},function(t){t!=this._widget.left&&(this._getWidget().left=t)}),r(0,e,"dataSource",function(){return this._dataSource},function(t){for(var e in this._dataSource=t,this._dataSource)this.hasOwnProperty(e)&&"function"!=typeof this[e]&&(this[e]=this._dataSource[e])}),r(0,e,"centerX",function(){return this._widget.centerX},function(t){t!=this._widget.centerX&&(this._getWidget().centerX=t)}),r(0,e,"top",function(){return this._widget.top},function(t){t!=this._widget.top&&(this._getWidget().top=t)}),r(0,e,"right",function(){return this._widget.right},function(t){t!=this._widget.right&&(this._getWidget().right=t)}),r(0,e,"tag",function(){return this._tag},function(t){this._tag=t}),r(0,e,"toolTip",function(){return this._toolTip},function(t){this._toolTip!=t&&(this._toolTip=t,null!=t?(this.on("mouseover",this,this.onMouseOver),this.on("mouseout",this,this.onMouseOut)):(this.off("mouseover",this,this.onMouseOver),this.off("mouseout",this,this.onMouseOut)))}),r(0,e,"gray",function(){return this._gray},function(t){t!==this._gray&&(this._gray=t,J.gray(this,t))}),r(0,e,"disabled",function(){return this._disabled},function(t){t!==this._disabled&&(this.gray=this._disabled=t,this.mouseEnabled=!t)}),r(0,e,"scaleX",t.prototype._$get_scaleX,function(t){i.superGet(Yt,this,"scaleX")!=t&&(i.superSet(Yt,this,"scaleX",t),this.event("resize"))}),r(0,e,"scaleY",t.prototype._$get_scaleY,function(t){i.superGet(Yt,this,"scaleY")!=t&&(i.superSet(Yt,this,"scaleY",t),this.event("resize"))}),r(0,e,"anchorX",function(){return this._anchorX},function(t){this._anchorX!=t&&(this._anchorX=t,this.callLater(this._sizeChanged))}),r(0,e,"anchorY",function(){return this._anchorY},function(t){this._anchorY!=t&&(this._anchorY=t,this.callLater(this._sizeChanged))}),UIComponent}(Yt),jt=function(e){function Stage(){this.focus=null,this._frameRate="fast",this.designWidth=0,this.designHeight=0,this.canvasRotation=!1,this.canvasDegree=0,this.renderingEnabled=!0,this.screenAdaptationEnabled=!0,this._screenMode="none",this._scaleMode="noscale",this._alignV="top",this._alignH="left",this._bgColor="black",this._mouseMoveTime=0,this._renderCount=0,this._safariOffsetY=0,this._frameStartTime=0,this._isFocused=!1,this._isVisibility=!1,this._wgColor=[0,0,0,1],this._scene3Ds=[],this._globalRepaintSet=!1,this._globalRepaintGet=!1,this._curUIBase=null,Stage.__super.call(this),this.offset=new et,this._canvasTransform=new Z,this._previousOrientation=P.window.orientation,this._3dUI=[];var t=this;this.transform=Z.create(),this.mouseEnabled=!0,this.hitTestPrior=!0,this.autoSize=!1,this._setBit(128,!0),this._setBit(2,!0),this._isFocused=!0,this._isVisibility=!0;var e=P.window,i=this;e.addEventListener("focus",function(){t._isFocused=!0,i.event("focus"),i.event("focuschange")}),e.addEventListener("blur",function(){t._isFocused=!1,i.event("blur"),i.event("focuschange")});var s="visibilityState",n="visibilitychange",r=e.document;void 0!==r.hidden?(n="visibilitychange",s="visibilityState"):void 0!==r.mozHidden?(n="mozvisibilitychange",s="mozVisibilityState"):void 0!==r.msHidden?(n="msvisibilitychange",s="msVisibilityState"):void 0!==r.webkitHidden&&(n="webkitvisibilitychange",s="webkitVisibilityState"),e.document.addEventListener(n,function(){"hidden"==P.document[s]?t._isVisibility=!1:t._isVisibility=!0;t.renderingEnabled=t._isVisibility,i.event("visibilitychange")}),e.addEventListener("resize",function(){var e=P.window.orientation;t._previousOrientation=e,i._isInputting()||(P.onSafari&&(i._safariOffsetY=(P.window.__innerHeight||P.document.body.clientHeight||P.document.documentElement.clientHeight)-P.window.innerHeight),i._resetCanvas())}),e.addEventListener("orientationchange",function(t){i._resetCanvas()}),this.on("mousemove",this,this._onmouseMove),P.onMobile&&this.on("mousedown",this,this._onmouseMove)}n(Stage,"laya.display.Stage",e);var a=Stage.prototype;return a._isInputting=function(){return P.onMobile},a._changeCanvasSize=function(){this.setScreenSize(P.clientWidth*P.pixelRatio,P.clientHeight*P.pixelRatio)},a._resetCanvas=function(){this.screenAdaptationEnabled&&this._changeCanvasSize()},a.setScreenSize=function(t,e){var i=!1;if("none"!==this._screenMode&&(i=(t/e<1?"vertical":"horizontal")!==this._screenMode)){var s=e;e=t,t=s}this.canvasRotation=i;var n=xt._mainCanvas,r=n.source.style,a=this._canvasTransform.identity(),o=this._scaleMode,h=t/this.designWidth,l=e/this.designHeight,c=this.designWidth,u=this.designHeight,_=t,d=e,f=P.pixelRatio;switch(this._width=this.designWidth,this._height=this.designHeight,o){case"noscale":h=l=1,_=this.designWidth,d=this.designHeight;break;case"showall":h=l=Math.min(h,l),c=_=Math.round(this.designWidth*h),u=d=Math.round(this.designHeight*l);break;case"noborder":h=l=Math.max(h,l),_=Math.round(this.designWidth*h),d=Math.round(this.designHeight*l);break;case"full":h=l=1,this._width=c=t,this._height=u=e;break;case"fixedwidth":l=h,this._height=u=Math.round(e/h);break;case"fixedheight":h=l,this._width=c=Math.round(t/l);break;case"fixedauto":t/e<this.designWidth/this.designHeight?(l=h,this._height=u=Math.round(e/h)):(h=l,this._width=c=Math.round(t/l))}h*=this.scaleX,l*=this.scaleY,1===h&&1===l?this.transform.identity():(this.transform.a=this._formatData(h/(_/c)),this.transform.d=this._formatData(l/(d/u))),xt.isConchApp&&(this._conchData._float32Data[10]=this._formatData(h/(_/c)),this._conchData._float32Data[11]=this._formatData(l/(d/u)),this._conchData._float32Data[15]=1),n.size(c,u),I.changeWebGLSize(c,u),a.scale(_/c/f,d/u/f),"left"===this._alignH?this.offset.x=0:"right"===this._alignH?this.offset.x=t-_:this.offset.x=.5*(t-_)/f,"top"===this._alignV?this.offset.y=0:"bottom"===this._alignV?this.offset.y=e-d:this.offset.y=.5*(e-d)/f,this.offset.x=Math.round(this.offset.x),this.offset.y=Math.round(this.offset.y),a.translate(this.offset.x,this.offset.y),this._safariOffsetY&&a.translate(0,this._safariOffsetY),this.canvasDegree=0,i&&("horizontal"===this._screenMode?(a.rotate(Math.PI/2),a.translate(e/f,0),this.canvasDegree=90):(a.rotate(-Math.PI/2),a.translate(0,t/f),this.canvasDegree=-90)),a.a=this._formatData(a.a),a.d=this._formatData(a.d),a.tx=this._formatData(a.tx),a.ty=this._formatData(a.ty),this.transform=this.transform,r.transformOrigin=r.webkitTransformOrigin=r.msTransformOrigin=r.mozTransformOrigin=r.oTransformOrigin="0px 0px 0px",r.transform=r.webkitTransform=r.msTransform=r.mozTransform=r.oTransform="matrix("+a.toString()+")",this._safariOffsetY&&a.translate(0,-this._safariOffsetY),a.translate(parseInt(r.left)||0,parseInt(r.top)||0),this.visible=!0,this._repaint|=2,this.event("resize")},a._formatData=function(t){return Math.abs(t)<1e-6?0:Math.abs(1-t)<.001?t>0?1:-1:t},a.getMousePoint=function(){return et.TEMP.setTo(this.mouseX,this.mouseY)},a.repaint=function(t){void 0===t&&(t=2),this._repaint|=t},a.repaintForNative=function(t){void 0===t&&(t=2),this._conchData._int32Data[4]|=t},a.parentRepaint=function(t){void 0===t&&(t=2)},a._loop=function(){return this._globalRepaintGet=this._globalRepaintSet,this._globalRepaintSet=!1,this.render(xt._context,0,0),!0},a.getFrameTm=function(){return this._frameStartTime},a._onmouseMove=function(t){this._mouseMoveTime=P.now()},a.getTimeFromFrameStart=function(){return P.now()-this._frameStartTime},a.render=function(t,i,s){if(Stage._dbgSprite.graphics.clear(),"sleep"===this._frameRate){var n=P.now();if(!(n-this._frameStartTime>=1e3))return;this._frameStartTime=n}else{if(!this._visible)return this._renderCount++,void(this._renderCount%5==0&&(d.I._update(),Tt.loopCount++,this._updateTimers()));this._frameStartTime=P.now()}this._renderCount++;var r="slow"!==("mouse"===this._frameRate?this._frameStartTime-this._mouseMoveTime<2e3?"fast":"slow":this._frameRate),a=this._renderCount%2==0;if(Tt.renderSlow=!r,(r||a)&&(d.I._update(),Tt.loopCount++,!xt.isConchApp&&xt.isWebGL&&this.renderingEnabled)){for(var o=0,h=this._scene3Ds.length;o<h;o++)this._scene3Ds[o]._update();t.clear(),e.prototype.render.call(this,t,i,s),Tt._show&&Tt._sp&&Tt._sp.render(t,i,s)}Stage._dbgSprite.render(t,0,0),!r&&a||(this.renderingEnabled&&(xt.isWebGL?(I.clear(this._bgColor),t.flush(),st.instance&&st.getInstance().endDispose()):(I.clear(this._bgColor),e.prototype.render.call(this,t,i,s),Tt._show&&Tt._sp&&Tt._sp.render(t,i,s),xt.isConchApp&&t.gl.commit())),this._updateTimers())},a._updateTimers=function(){i.systemTimer._update(),i.startTimer._update(),i.physicsTimer._update(),i.updateTimer._update(),i.lateTimer._update(),i.timer._update()},a.renderToNative=function(t,i,s){this._renderCount++,Tt.loopCount++,this._visible?(d.I._update(),this._updateTimers(),d.I._update(),this.renderingEnabled&&(I.clear(this._bgColor),e.prototype.render.call(this,t,i,s),Tt._show&&Tt._sp&&Tt._sp.render(t,i,s),t.gl.commit())):this._renderCount%5==0&&(d.I._update(),Tt.loopCount++,this._updateTimers(),d.I._update())},a._requestFullscreen=function(){var t=P.document.documentElement;t.requestFullscreen?t.requestFullscreen():t.mozRequestFullScreen?t.mozRequestFullScreen():t.webkitRequestFullscreen?t.webkitRequestFullscreen():t.msRequestFullscreen&&t.msRequestFullscreen()},a._fullScreenChanged=function(){i.stage.event("fullscreenchange")},a.exitFullscreen=function(){var t=P.document;t.exitFullscreen?t.exitFullscreen():t.mozCancelFullScreen?t.mozCancelFullScreen():t.webkitExitFullscreen&&t.webkitExitFullscreen()},a.isGlobalRepaint=function(){return this._globalRepaintGet},a.setGlobalRepaint=function(){this._globalRepaintSet=!0},a.add3DUI=function(t){var e=t.rootView;this._3dUI.indexOf(e)>=0||this._3dUI.push(e)},a.remove3DUI=function(t){var e=t.rootView,i=this._3dUI.indexOf(e);return i>=0&&(this._3dUI.splice(i,1),!0)},r(0,a,"clientScaleY",function(){return this._transform?this._transform.getScaleY():1}),r(0,a,"width",e.prototype._$get_width,function(t){this.designWidth=t,i.superSet(Yt,this,"width",t),i.systemTimer.callLater(this,this._changeCanvasSize)}),r(0,a,"isFocused",function(){return this._isFocused}),r(0,a,"alignH",function(){return this._alignH},function(t){this._alignH=t,i.systemTimer.callLater(this,this._changeCanvasSize)}),r(0,a,"height",e.prototype._$get_height,function(t){this.designHeight=t,i.superSet(Yt,this,"height",t),i.systemTimer.callLater(this,this._changeCanvasSize)}),r(0,a,"transform",function(){return this._tfChanged&&this._adjustTransform(),this._transform=this._transform||this._createTransform()},e.prototype._$set_transform),r(0,a,"isVisibility",function(){return this._isVisibility}),r(0,a,"scaleMode",function(){return this._scaleMode},function(t){this._scaleMode=t,i.systemTimer.callLater(this,this._changeCanvasSize)}),r(0,a,"alignV",function(){return this._alignV},function(t){this._alignV=t,i.systemTimer.callLater(this,this._changeCanvasSize)}),r(0,a,"bgColor",function(){return this._bgColor},function(t){this._bgColor=t,xt.isWebGL&&(this._wgColor=t?o.create(t).arrColor:null),P.onLimixiu?this._wgColor=o.create(t).arrColor:xt.canvas.style.background=t||"none",xt.isConchApp&&(this._renderType|=128,this._setBgStyleColor(0,0,this.width,this.height,t),this._setRenderType(this._renderType))}),r(0,a,"mouseX",function(){return Math.round(w.instance.mouseX/this.clientScaleX)}),r(0,a,"mouseY",function(){return Math.round(w.instance.mouseY/this.clientScaleY)}),r(0,a,"clientScaleX",function(){return this._transform?this._transform.getScaleX():1}),r(0,a,"screenMode",function(){return this._screenMode},function(t){this._screenMode=t}),r(0,a,"visible",e.prototype._$get_visible,function(t){this.visible!==t&&(i.superSet(Yt,this,"visible",t),xt._mainCanvas.source.style.visibility=t?"visible":"hidden")}),r(0,a,"fullScreenEnabled",null,function(t){var e=P.document,i=xt.canvas;t?(i.addEventListener("mousedown",this._requestFullscreen),i.addEventListener("touchstart",this._requestFullscreen),e.addEventListener("fullscreenchange",this._fullScreenChanged),e.addEventListener("mozfullscreenchange",this._fullScreenChanged),e.addEventListener("webkitfullscreenchange",this._fullScreenChanged),e.addEventListener("msfullscreenchange",this._fullScreenChanged)):(i.removeEventListener("mousedown",this._requestFullscreen),i.removeEventListener("touchstart",this._requestFullscreen),e.removeEventListener("fullscreenchange",this._fullScreenChanged),e.removeEventListener("mozfullscreenchange",this._fullScreenChanged),e.removeEventListener("webkitfullscreenchange",this._fullScreenChanged),e.removeEventListener("msfullscreenchange",this._fullScreenChanged))}),r(0,a,"frameRate",function(){return xt.isConchApp?this._frameRateNative:this._frameRate},function(e){if(xt.isConchApp){switch(e){case"fast":t.conch.config.setLimitFPS(60);break;case"mouse":t.conch.config.setMouseFrame(2e3);break;case"slow":t.conch.config.setSlowFrame(!0);break;case"sleep":t.conch.config.setLimitFPS(1)}this._frameRateNative=e}else this._frameRate=e}),Stage.SCALE_NOSCALE="noscale",Stage.SCALE_EXACTFIT="exactfit",Stage.SCALE_SHOWALL="showall",Stage.SCALE_NOBORDER="noborder",Stage.SCALE_FULL="full",Stage.SCALE_FIXED_WIDTH="fixedwidth",Stage.SCALE_FIXED_HEIGHT="fixedheight",Stage.SCALE_FIXED_AUTO="fixedauto",Stage.ALIGN_LEFT="left",Stage.ALIGN_RIGHT="right",Stage.ALIGN_CENTER="center",Stage.ALIGN_TOP="top",Stage.ALIGN_MIDDLE="middle",Stage.ALIGN_BOTTOM="bottom",Stage.SCREEN_NONE="none",Stage.SCREEN_HORIZONTAL="horizontal",Stage.SCREEN_VERTICAL="vertical",Stage.FRAME_FAST="fast",Stage.FRAME_SLOW="slow",Stage.FRAME_MOUSE="mouse",Stage.FRAME_SLEEP="sleep",s(Stage,["_dbgSprite",function(){return this._dbgSprite=new Yt}]),Stage}(Yt),$t=function(t){function HTMLCanvas(t){HTMLCanvas.__super.call(this),void 0===t&&(t=!1),t||!xt.isWebGL?this._source=P.createElement("canvas"):this._source=this,this.lock=!0}n(HTMLCanvas,"laya.resource.HTMLCanvas",Ht);var e=HTMLCanvas.prototype;return e._getSource=function(){return this._source},e.clear=function(){this._ctx&&this._ctx.clear(),this._texture&&(this._texture.destroy(),this._texture=null)},e.destroy=function(){this._ctx&&this._ctx.destroy(),this._ctx=null},e.release=function(){},e._setContext=function(t){this._ctx=t},e.getContext=function(t,e){return this.context},e.getMemSize=function(){return 0},e.size=function(t,e){(this._width!=t||this._height!=e||this._source&&(this._source.width!=t||this._source.height!=e))&&(this._width=t,this._height=e,this._setGPUMemory(t*e*4),this._ctx&&this._ctx.size&&this._ctx.size(t,e),this._texture&&(this._texture.destroy(),this._texture=null))},e.getTexture=function(){return this._texture||(this._texture=new Ot(this,Ot.DEF_UV)),this._texture},e.toBase64=function(t,e,i){this._source&&(xt.isConchApp&&this._source.toBase64?this._source.toBase64(t,e,i):i(this._source.toDataURL(t,e)))},r(0,e,"source",function(){return this._source}),r(0,e,"context",function(){return this._ctx?this._ctx:(xt.isWebGL&&this._source==this?this._ctx=new laya.webgl.canvas.WebGLContext2D:this._ctx=this._source.getContext(xt.isConchApp?"layagl":"2d"),this._ctx._canvas=this,this._ctx)}),HTMLCanvas}(),qt=function(t){function HTMLImage(){HTMLImage.__super.call(this)}n(HTMLImage,"laya.resource.HTMLImage",Ht);var e=HTMLImage.prototype;return e.loadImageSource=function(t){var e=t.width,i=t.height;if(e<=0||i<=0)throw new Error("HTMLImage:width or height must large than 0.");this._width=e,this._height=i,this._source=t,this._setGPUMemory(e*i*4),this._activeResource()},e._disposeResource=function(){this._source&&(this._source=null,this._setGPUMemory(0))},e._getSource=function(){return this._source},HTMLImage.create=function(t,e){return new HTMLImage},HTMLImage}(),Kt=function(t){function View(){this._watchMap={},this._widget=null,this._dataSource=null,this._anchorX=NaN,this._anchorY=NaN,this._widget=Pt.EMPTY,View.__super.call(this)}n(View,"laya.ui.View",t);var e=View.prototype;return e.destroy=function(e){void 0===e&&(e=!0),this._watchMap=null,t.prototype.destroy.call(this,e)},e.changeData=function(t){var e=this._watchMap[t];if(e)for(var i=0,s=e.length;i<s;i++){e[i].exe(this)}},e._sizeChanged=function(){isNaN(this._anchorX)||(this.pivotX=this.anchorX*this.width),isNaN(this._anchorY)||(this.pivotY=this.anchorY*this.height),this.event("resize")},e._getWidget=function(){return this._widget===Pt.EMPTY&&(this._widget=this.addComponent(Pt)),this._widget},e.loadUI=function(t){var e=View.uiMap[t];View.uiMap&&this.createView(e)},r(0,e,"anchorX",function(){return this._anchorX},function(t){this._anchorX!=t&&(this._anchorX=t,this.callLater(this._sizeChanged))}),r(0,e,"centerX",function(){return this._widget.centerX},function(t){t!=this._widget.centerX&&(this._getWidget().centerX=t)}),r(0,e,"top",function(){return this._widget.top},function(t){t!=this._widget.top&&(this._getWidget().top=t)}),r(0,e,"bottom",function(){return this._widget.bottom},function(t){t!=this._widget.bottom&&(this._getWidget().bottom=t)}),r(0,e,"dataSource",function(){return this._dataSource},function(t){for(var e in this._dataSource=t,t){var i=this.getChildByName(e);i instanceof laya.ui.UIComponent?i.dataSource=t[e]:this.hasOwnProperty(e)&&"function"!=typeof this[e]&&(this[e]=t[e])}}),r(0,e,"left",function(){return this._widget.left},function(t){t!=this._widget.left&&(this._getWidget().left=t)}),r(0,e,"right",function(){return this._widget.right},function(t){t!=this._widget.right&&(this._getWidget().right=t)}),r(0,e,"anchorY",function(){return this._anchorY},function(t){this._anchorY!=t&&(this._anchorY=t,this.callLater(this._sizeChanged))}),r(0,e,"centerY",function(){return this._widget.centerY},function(t){t!=this._widget.centerY&&(this._getWidget().centerY=t)}),View.regComponent=function(t,e){dt.regClass(t,e)},View.regViewRuntime=function(t,e){dt.regClass(t,e)},View.regUI=function(t,e){i.loader.cacheRes(t,e)},View.uiMap={},View.__init$=function(){dt.regShortClassName([Jt,Zt,Jt,te,Vt,le,ce,Qt,ee,ne,re,ie,se,View,oe,he,Yt,zt,ae])},View}(Xt),Qt=function(t){function Image(t){this._bitmap=null,this._skin=null,this._group=null,Image.__super.call(this),this.skin=t}n(Image,"laya.ui.Image",t);var e=Image.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,!0),this._bitmap&&this._bitmap.destroy(),this._bitmap=null},e.dispose=function(){this.destroy(!0),i.loader.clearRes(this._skin)},e.createChildren=function(){this.graphics=this._bitmap=new Gt,this._bitmap.autoCacheCmd=!1},e.setSource=function(t,e){t===this._skin&&e&&(this.source=e,this.onCompResize())},e.measureWidth=function(){return this._bitmap.width},e.measureHeight=function(){return this._bitmap.height},r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"string"==typeof t?this.skin=t:i.superSet(Vt,this,"dataSource",t)}),r(0,e,"source",function(){return this._bitmap.source},function(t){this._bitmap&&(this._bitmap.source=t,this.event("loaded"),this.repaint())}),r(0,e,"skin",function(){return this._skin},function(t){if(this._skin!=t)if(this._skin=t,t){var e=Ft.getRes(t);e?(this.source=e,this.onCompResize()):i.loader.load(this._skin,l.create(this,this.setSource,[this._skin]),null,"image",1,!0,this._group)}else this.source=null}),r(0,e,"sizeGrid",function(){return this._bitmap.sizeGrid?this._bitmap.sizeGrid.join(","):null},function(t){this._bitmap.sizeGrid=J.fillArray(m.defaultSizeGrid,t,Number)}),r(0,e,"group",function(){return this._group},function(t){t&&this._skin&&Ft.setGroup(this._skin,t),this._group=t}),r(0,e,"width",t.prototype._$get_width,function(t){i.superSet(Vt,this,"width",t),this._bitmap.width=0==t?1e-7:t}),r(0,e,"height",t.prototype._$get_height,function(t){i.superSet(Vt,this,"height",t),this._bitmap.height=0==t?1e-7:t}),Image}(Vt),Zt=function(t){function Box(){Box.__super.call(this)}n(Box,"laya.ui.Box",t);var e=Box.prototype;return i.imps(e,{"laya.ui.IBox":!0}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){for(var e in this._dataSource=t,t){var i=this.getChildByName(e);i?i.dataSource=t[e]:this.hasOwnProperty(e)&&"function"!=typeof this[e]&&(this[e]=t[e])}}),Box}(Vt),Jt=function(t){function Button(t,e){this.toggle=!1,this._bitmap=null,this._text=null,this._strokeColors=null,this._state=0,this._selected=!1,this._skin=null,this._autoSize=!0,this._sources=null,this._clickHandler=null,this._stateChanged=!1,Button.__super.call(this),this._labelColors=m.buttonLabelColors,this._stateNum=m.buttonStateNum,void 0===e&&(e=""),this.skin=t,this.label=e}n(Button,"laya.ui.Button",t);var e=Button.prototype;return i.imps(e,{"laya.ui.ISelect":!0}),e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,e),this._bitmap&&this._bitmap.destroy(),this._text&&this._text.destroy(e),this._bitmap=null,this._text=null,this._clickHandler=null,this._labelColors=this._sources=this._strokeColors=null},e.createChildren=function(){this.graphics=this._bitmap=new Gt},e.createText=function(){this._text||(this._text=new zt,this._text.overflow="hidden",this._text.align="center",this._text.valign="middle",this._text.width=this._width,this._text.height=this._height)},e.initialize=function(){1!==this._mouseState&&(this.mouseEnabled=!0,this._setBit(64,!0)),this._createListener("mouseover",this,this.onMouse,null,!1,!1),this._createListener("mouseout",this,this.onMouse,null,!1,!1),this._createListener("mousedown",this,this.onMouse,null,!1,!1),this._createListener("mouseup",this,this.onMouse,null,!1,!1),this._createListener("click",this,this.onMouse,null,!1,!1)},e.onMouse=function(t){if(!1!==this.toggle||!this._selected)return"click"===t.type?(this.toggle&&(this.selected=!this._selected),void(this._clickHandler&&this._clickHandler.run())):void(!this._selected&&(this.state=Button.stateMap[t.type]))},e._skinLoaded=function(){this.callLater(this.changeClips),this._setStateChanged(),this._sizeChanged(),this.event("loaded")},e.changeClips=function(){var t=Ft.getRes(this._skin);if(t){var e=t.sourceWidth,i=t.sourceHeight/this._stateNum;t.$_GID||(t.$_GID=_t.getGID());var s=t.$_GID+"-"+this._stateNum,n=ct.I.get(s);if(_t.isOkTextureList(n)||(n=null),n)this._sources=n;else{if(this._sources=[],1===this._stateNum)this._sources.push(t);else for(var r=0;r<this._stateNum;r++)this._sources.push(Ot.createFromTexture(t,0,i*r,e,i));ct.I.set(s,this._sources)}this._autoSize?(this._bitmap.width=this._width||e,this._bitmap.height=this._height||i,this._text&&(this._text.width=this._bitmap.width,this._text.height=this._bitmap.height)):this._text&&(this._text.x=e)}else console.log("lose skin",this._skin)},e.measureWidth=function(){return this.runCallLater(this.changeClips),this._autoSize?this._bitmap.width:(this.runCallLater(this.changeState),this._bitmap.width+(this._text?this._text.width:0))},e.measureHeight=function(){return this.runCallLater(this.changeClips),this._text?Math.max(this._bitmap.height,this._text.height):this._bitmap.height},e.changeState=function(){this._stateChanged=!1,this.runCallLater(this.changeClips);var t=this._state<this._stateNum?this._state:this._stateNum-1;this._sources&&(this._bitmap.source=this._sources[t]),this.label&&(this._text.color=this._labelColors[t],this._strokeColors&&(this._text.strokeColor=this._strokeColors[t]))},e._setStateChanged=function(){this._stateChanged||(this._stateChanged=!0,this.callLater(this.changeState))},r(0,e,"skin",function(){return this._skin},function(t){this._skin!=t&&(this._skin=t,t?Ft.getRes(t)?this._skinLoaded():i.loader.load(this._skin,l.create(this,this._skinLoaded),null,"image",1):this._skinLoaded())}),r(0,e,"labelPadding",function(){return this.createText(),this._text.padding.join(",")},function(t){this.createText(),this._text.padding=J.fillArray(m.labelPadding,t,Number)}),r(0,e,"state",function(){return this._state},function(t){this._state!=t&&(this._state=t,this._setStateChanged())}),r(0,e,"text",function(){return this.createText(),this._text}),r(0,e,"stateNum",function(){return this._stateNum},function(t){"string"==typeof t&&(t=parseInt(t)),this._stateNum!=t&&(this._stateNum=t<1?1:t>3?3:t,this.callLater(this.changeClips))}),r(0,e,"label",function(){return this._text?this._text.text:null},function(t){(this._text||t)&&(this.createText(),this._text.text!=t&&(t&&!this._text.parent&&this.addChild(this._text),this._text.text=(t+"").replace(/\\n/g,"\n"),this._setStateChanged()))}),r(0,e,"labelSize",function(){return this.createText(),this._text.fontSize},function(t){this.createText(),this._text.fontSize=t}),r(0,e,"selected",function(){return this._selected},function(t){this._selected!=t&&(this._selected=t,this.state=this._selected?2:0,this.event("change"))}),r(0,e,"strokeColors",function(){return this._strokeColors?this._strokeColors.join(","):""},function(t){this._strokeColors=J.fillArray(m.buttonLabelColors,t,String),this._setStateChanged()}),r(0,e,"labelColors",function(){return this._labelColors.join(",")},function(t){this._labelColors=J.fillArray(m.buttonLabelColors,t,String),this._setStateChanged()}),r(0,e,"labelStroke",function(){return this.createText(),this._text.stroke},function(t){this.createText(),this._text.stroke=t}),r(0,e,"labelStrokeColor",function(){return this.createText(),this._text.strokeColor},function(t){this.createText(),this._text.strokeColor=t}),r(0,e,"labelBold",function(){return this.createText(),this._text.bold},function(t){this.createText(),this._text.bold=t}),r(0,e,"labelFont",function(){return this.createText(),this._text.font},function(t){this.createText(),this._text.font=t}),r(0,e,"labelAlign",function(){return this.createText(),this._text.align},function(t){this.createText(),this._text.align=t}),r(0,e,"clickHandler",function(){return this._clickHandler},function(t){this._clickHandler=t}),r(0,e,"sizeGrid",function(){return this._bitmap.sizeGrid?this._bitmap.sizeGrid.join(","):null},function(t){this._bitmap.sizeGrid=J.fillArray(m.defaultSizeGrid,t,Number)}),r(0,e,"width",t.prototype._$get_width,function(t){i.superSet(Vt,this,"width",t),this._autoSize&&(this._bitmap.width=t,this._text&&(this._text.width=t))}),r(0,e,"height",t.prototype._$get_height,function(t){i.superSet(Vt,this,"height",t),this._autoSize&&(this._bitmap.height=t,this._text&&(this._text.height=t))}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t||"string"==typeof t?this.label=t+"":i.superSet(Vt,this,"dataSource",t)}),r(0,e,"iconOffset",function(){return this._bitmap._offset?this._bitmap._offset.join(","):null},function(t){this._bitmap._offset=t?J.fillArray([1,1],t,Number):[]}),s(Button,["stateMap",function(){return this.stateMap={mouseup:0,mouseover:1,mousedown:2,mouseout:0}}]),Button}(Vt),te=function(t){function Clip(t,e,i){this._sources=null,this._bitmap=null,this._skin=null,this._clipX=1,this._clipY=1,this._clipWidth=0,this._clipHeight=0,this._autoPlay=!1,this._interval=50,this._complete=null,this._isPlaying=!1,this._index=0,this._clipChanged=!1,this._group=null,this._toIndex=-1,Clip.__super.call(this),void 0===e&&(e=1),void 0===i&&(i=1),this._clipX=e,this._clipY=i,this.skin=t}n(Clip,"laya.ui.Clip",t);var e=Clip.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,!0),this._bitmap&&this._bitmap.destroy(),this._bitmap=null,this._sources=null},e.dispose=function(){this.destroy(!0),i.loader.clearRes(this._skin)},e.createChildren=function(){this.graphics=this._bitmap=new Gt},e._onDisplay=function(t){this._isPlaying?this._getBit(128)?this.play():this.stop():this._autoPlay&&this.play()},e._skinLoaded=function(){this._setClipChanged(),this._sizeChanged(),this.event("loaded")},e.changeClip=function(){if(this._clipChanged=!1,this._skin){var t=Ft.getRes(this._skin);t?this.loadComplete(this._skin,t):i.loader.load(this._skin,l.create(this,this.loadComplete,[this._skin]))}},e.loadComplete=function(t,e){if(t===this._skin&&e){var i=this._clipWidth||Math.ceil(e.sourceWidth/this._clipX),s=this._clipHeight||Math.ceil(e.sourceHeight/this._clipY),n=this._skin+i+s,r=ct.I.get(n);if(_t.isOkTextureList(r)||(r=null),r)this._sources=r;else{this._sources=[];for(var a=0;a<this._clipY;a++)for(var o=0;o<this._clipX;o++)this._sources.push(Ot.createFromTexture(e,i*o,s*a,i,s));ct.I.set(n,this._sources)}this.index=this._index,this.event("loaded"),this.onCompResize()}},e.measureWidth=function(){return this.runCallLater(this.changeClip),this._bitmap.width},e.measureHeight=function(){return this.runCallLater(this.changeClip),this._bitmap.height},e.play=function(t,e){void 0===t&&(t=0),void 0===e&&(e=-1),this._isPlaying=!0,this.index=t,this._toIndex=e,this._index++,i.timer.loop(this.interval,this,this._loop),this.on("display",this,this._onDisplay),this.on("undisplay",this,this._onDisplay)},e._loop=function(){this._visible&&this._sources&&(this._index++,this._toIndex>-1&&this._index>=this._toIndex?this.stop():this._index>=this._sources.length&&(this._index=0),this.index=this._index)},e.stop=function(){this._isPlaying=!1,i.timer.clear(this,this._loop),this.event("complete")},e._setClipChanged=function(){this._clipChanged||(this._clipChanged=!0,this.callLater(this.changeClip))},r(0,e,"interval",function(){return this._interval},function(t){this._interval!=t&&(this._interval=t,this._isPlaying&&this.play())}),r(0,e,"skin",function(){return this._skin},function(t){this._skin!=t&&(this._skin=t,t?Ft.getRes(t)?this._skinLoaded():i.loader.load(this._skin,l.create(this,this._skinLoaded),null,"image",1):this._bitmap.source=null)}),r(0,e,"sources",function(){return this._sources},function(t){this._sources=t,this.index=this._index,this.event("loaded")}),r(0,e,"clipX",function(){return this._clipX},function(t){this._clipX=t||1,this._setClipChanged()}),r(0,e,"clipY",function(){return this._clipY},function(t){this._clipY=t||1,this._setClipChanged()}),r(0,e,"total",function(){return this.runCallLater(this.changeClip),this._sources?this._sources.length:0}),r(0,e,"clipWidth",function(){return this._clipWidth},function(t){this._clipWidth=t,this._setClipChanged()}),r(0,e,"sizeGrid",function(){return this._bitmap.sizeGrid?this._bitmap.sizeGrid.join(","):null},function(t){this._bitmap.sizeGrid=J.fillArray(m.defaultSizeGrid,t,Number)}),r(0,e,"group",function(){return this._group},function(t){t&&this._skin&&Ft.setGroup(this._skin,t),this._group=t}),r(0,e,"clipHeight",function(){return this._clipHeight},function(t){this._clipHeight=t,this._setClipChanged()}),r(0,e,"width",t.prototype._$get_width,function(t){i.superSet(Vt,this,"width",t),this._bitmap.width=t}),r(0,e,"height",t.prototype._$get_height,function(t){i.superSet(Vt,this,"height",t),this._bitmap.height=t}),r(0,e,"index",function(){return this._index},function(t){this._index=t,this._bitmap&&this._sources&&(this._bitmap.source=this._sources[t]),this.event("change")}),r(0,e,"autoPlay",function(){return this._autoPlay},function(t){this._autoPlay!=t&&(this._autoPlay=t,t?this.play():this.stop())}),r(0,e,"isPlaying",function(){return this._isPlaying},function(t){this._isPlaying=t}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t&&Math.floor(t)==t||"string"==typeof t?this.index=parseInt(t):i.superSet(Vt,this,"dataSource",t)}),r(0,e,"bitmap",function(){return this._bitmap}),Clip}(Vt),ee=function(t){function Label(t){this._tf=null,Label.__super.call(this),void 0===t&&(t=""),this.text=t}n(Label,"laya.ui.Label",t);var e=Label.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,e),this._tf=null},e.createChildren=function(){this.addChild(this._tf=new zt)},e.changeText=function(t){this._tf.changeText(t)},e.measureWidth=function(){return this._tf.width},e.measureHeight=function(){return this._tf.height},r(0,e,"padding",function(){return this._tf.padding.join(",")},function(t){this._tf.padding=J.fillArray(m.labelPadding,t,Number)}),r(0,e,"bold",function(){return this._tf.bold},function(t){this._tf.bold=t}),r(0,e,"align",function(){return this._tf.align},function(t){this._tf.align=t}),r(0,e,"text",function(){return this._tf.text},function(t){this._tf.text!=t&&(t&&(t=J.adptString(t+"")),this._tf.text=t,this.event("change"),this._width&&this._height||this.onCompResize())}),r(0,e,"italic",function(){return this._tf.italic},function(t){this._tf.italic=t}),r(0,e,"wordWrap",function(){return this._tf.wordWrap},function(t){this._tf.wordWrap=t}),r(0,e,"font",function(){return this._tf.font},function(t){this._tf.font=t}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t||"string"==typeof t?this.text=t+"":i.superSet(Vt,this,"dataSource",t)}),r(0,e,"color",function(){return this._tf.color},function(t){this._tf.color=t}),r(0,e,"valign",function(){return this._tf.valign},function(t){this._tf.valign=t}),r(0,e,"leading",function(){return this._tf.leading},function(t){this._tf.leading=t}),r(0,e,"fontSize",function(){return this._tf.fontSize},function(t){this._tf.fontSize=t}),r(0,e,"bgColor",function(){return this._tf.bgColor},function(t){this._tf.bgColor=t}),r(0,e,"borderColor",function(){return this._tf.borderColor},function(t){this._tf.borderColor=t}),r(0,e,"stroke",function(){return this._tf.stroke},function(t){this._tf.stroke=t}),r(0,e,"strokeColor",function(){return this._tf.strokeColor},function(t){this._tf.strokeColor=t}),r(0,e,"textField",function(){return this._tf}),r(0,e,"width",function(){return this._width||this._tf.text?i.superGet(Vt,this,"width"):0},function(t){i.superSet(Vt,this,"width",t),this._tf.width=t}),r(0,e,"height",function(){return this._height||this._tf.text?i.superGet(Vt,this,"height"):0},function(t){i.superSet(Vt,this,"height",t),this._tf.height=t}),r(0,e,"overflow",function(){return this._tf.overflow},function(t){this._tf.overflow=t}),r(0,e,"underline",function(){return this._tf.underline},function(t){this._tf.underline=t}),r(0,e,"underlineColor",function(){return this._tf.underlineColor},function(t){this._tf.underlineColor=t}),Label}(Vt),ie=function(t){function ScrollBar(t){this.rollRatio=.97,this.changeHandler=null,this.scaleBar=!0,this.autoHide=!1,this.elasticDistance=0,this.elasticBackTime=500,this.upButton=null,this.downButton=null,this.slider=null,this._scrollSize=1,this._skin=null,this._thumbPercent=1,this._target=null,this._lastPoint=null,this._lastOffset=0,this._checkElastic=!1,this._isElastic=!1,this._value=NaN,this._hide=!1,this._clickOnly=!0,this._offsets=null,this.isLockedFun=null,this.triggerDownDragLimit=null,this.triggerUpDragLimit=null,ScrollBar.__super.call(this),this._showButtons=ut.showButtons,this._touchScrollEnable=ut.touchScrollEnable,this._mouseWheelEnable=ut.mouseWheelEnable,this.skin=t,this.max=1}n(ScrollBar,"laya.ui.ScrollBar",t);var e=ScrollBar.prototype;return e.destroy=function(e){void 0===e&&(e=!0),this.stopScroll(),this.target=null,t.prototype.destroy.call(this,e),this.upButton&&this.upButton.destroy(e),this.downButton&&this.downButton.destroy(e),this.slider&&this.slider.destroy(e),this.upButton=this.downButton=null,this.slider=null,this.changeHandler=null,this._offsets=null},e.createChildren=function(){this.addChild(this.slider=new se),this.addChild(this.upButton=new Jt),this.addChild(this.downButton=new Jt)},e.initialize=function(){this.slider.showLabel=!1,this.slider.tick=0,this.slider.on("change",this,this.onSliderChange),this.slider.setSlider(0,0,0),this.upButton.on("mousedown",this,this.onButtonMouseDown),this.downButton.on("mousedown",this,this.onButtonMouseDown)},e.onSliderChange=function(){this._value!=this.slider.value&&(this.value=this.slider.value)},e.onButtonMouseDown=function(t){var e=t.currentTarget===this.upButton;this.slide(e),i.timer.once(m.scrollBarDelayTime,this,this.startLoop,[e]),i.stage.once("mouseup",this,this.onStageMouseUp)},e.startLoop=function(t){i.timer.frameLoop(1,this,this.slide,[t])},e.slide=function(t){t?this.value-=this._scrollSize:this.value+=this._scrollSize},e.onStageMouseUp=function(t){i.timer.clear(this,this.startLoop),i.timer.clear(this,this.slide)},e._skinLoaded=function(){this.slider.skin=this._skin,this.callLater(this.changeScrollBar),this._sizeChanged(),this.event("loaded")},e.changeScrollBar=function(){this.upButton.visible=this._showButtons,this.downButton.visible=this._showButtons,this._showButtons&&(this.upButton.skin=this._skin.replace(".png","$up.png"),this.downButton.skin=this._skin.replace(".png","$down.png")),this.slider.isVertical?this.slider.y=this._showButtons?this.upButton.height:0:this.slider.x=this._showButtons?this.upButton.width:0,this.resetPositions(),this.repaint()},e._sizeChanged=function(){t.prototype._sizeChanged.call(this),this.repaint(),this.resetPositions(),this.event("change"),this.changeHandler&&this.changeHandler.runWith(this.value)},e.resetPositions=function(){this.slider.isVertical?this.slider.height=this.height-(this._showButtons?this.upButton.height+this.downButton.height:0):this.slider.width=this.width-(this._showButtons?this.upButton.width+this.downButton.width:0),this.resetButtonPosition()},e.resetButtonPosition=function(){this.slider.isVertical?this.downButton.y=this.slider._y+this.slider.height:this.downButton.x=this.slider._x+this.slider.width},e.measureWidth=function(){return this.slider.isVertical?this.slider.width:100},e.measureHeight=function(){return this.slider.isVertical?100:this.slider.height},e.setScroll=function(t,e,i){this.runCallLater(this._sizeChanged),this.slider.setSlider(t,e,i),this.slider.bar.visible=e>0,!this._hide&&this.autoHide&&(this.visible=!1)},e.onTargetMouseWheel=function(t){this.value-=t.delta*this._scrollSize,this.target=this._target},e.onTargetMouseDown=function(t){this.isLockedFun&&!this.isLockedFun(t)||(this.event("end"),this._clickOnly=!0,this._lastOffset=0,this._checkElastic=!1,this._lastPoint||(this._lastPoint=new et),this._lastPoint.setTo(i.stage.mouseX,i.stage.mouseY),i.timer.clear(this,this.tweenMove),R.clearTween(this),i.stage.once("mouseup",this,this.onStageMouseUp2),i.stage.once("mouseout",this,this.onStageMouseUp2),i.timer.frameLoop(1,this,this.loop))},e.startDragForce=function(){this._clickOnly=!0,this._lastOffset=0,this._checkElastic=!1,this._lastPoint||(this._lastPoint=new et),this._lastPoint.setTo(i.stage.mouseX,i.stage.mouseY),i.timer.clear(this,this.tweenMove),R.clearTween(this),i.stage.once("mouseup",this,this.onStageMouseUp2),i.stage.once("mouseout",this,this.onStageMouseUp2),i.timer.frameLoop(1,this,this.loop)},e.cancelDragOp=function(){i.stage.off("mouseup",this,this.onStageMouseUp2),i.stage.off("mouseout",this,this.onStageMouseUp2),i.timer.clear(this,this.tweenMove),i.timer.clear(this,this.loop),this._target.mouseEnabled=!0},e.checkTriggers=function(t){return void 0===t&&(t=!1),this.value>=0&&this.value-this._lastOffset<=0&&this.triggerDownDragLimit&&this.triggerDownDragLimit(t)?(this.cancelDragOp(),this.value=0,!0):!!(this.value<=this.max&&this.value-this._lastOffset>=this.max&&this.triggerUpDragLimit&&this.triggerUpDragLimit(t))&&(this.cancelDragOp(),this.value=this.max,!0)},e.startTweenMoveForce=function(t){this._lastOffset=t,i.timer.frameLoop(1,this,this.tweenMove,[200])},e.loop=function(){var t=i.stage.mouseY,e=i.stage.mouseX;if(this._lastOffset=this.isVertical?t-this._lastPoint.y:e-this._lastPoint.x,this._clickOnly){if(!(Math.abs(this._lastOffset*(this.isVertical?i.stage._canvasTransform.getScaleY():i.stage._canvasTransform.getScaleX()))>1))return;if(this._clickOnly=!1,this.checkTriggers())return;this._offsets||(this._offsets=[]),this._offsets.length=0,this._target.mouseEnabled=!1,!this.hide&&this.autoHide&&(this.alpha=1,this.visible=!0),this.event("start")}else if(this.checkTriggers())return;this._offsets.push(this._lastOffset),this._lastPoint.x=e,this._lastPoint.y=t,0!==this._lastOffset&&(this._checkElastic||(this.elasticDistance>0?this._checkElastic||0==this._lastOffset||(this._lastOffset>0&&this._value<=this.min||this._lastOffset<0&&this._value>=this.max?(this._isElastic=!0,this._checkElastic=!0):this._isElastic=!1):this._checkElastic=!0),this._isElastic?this._value<=this.min?this._lastOffset>0?this.value-=this._lastOffset*Math.max(0,1-(this.min-this._value)/this.elasticDistance):(this.value-=.5*this._lastOffset,this._value>=this.min&&(this._checkElastic=!1)):this._value>=this.max&&(this._lastOffset<0?this.value-=this._lastOffset*Math.max(0,1-(this._value-this.max)/this.elasticDistance):(this.value-=.5*this._lastOffset,this._value<=this.max&&(this._checkElastic=!1))):this.value-=this._lastOffset)},e.onStageMouseUp2=function(t){if(i.stage.off("mouseup",this,this.onStageMouseUp2),i.stage.off("mouseout",this,this.onStageMouseUp2),i.timer.clear(this,this.loop),!(this._clickOnly&&this._value>=this.min&&this._value<=this.max))if(this._target.mouseEnabled=!0,this._isElastic)this._value<this.min?R.to(this,{value:this.min},this.elasticBackTime,at.sineOut,l.create(this,this.elasticOver)):this._value>this.max&&R.to(this,{value:this.max},this.elasticBackTime,at.sineOut,l.create(this,this.elasticOver));else{if(!this._offsets)return;this._offsets.length<1&&(this._offsets[0]=this.isVertical?i.stage.mouseY-this._lastPoint.y:i.stage.mouseX-this._lastPoint.x);for(var e=0,s=Math.min(this._offsets.length,3),n=0;n<s;n++)e+=this._offsets[this._offsets.length-1-n];if(this._lastOffset=e/s,(e=Math.abs(this._lastOffset))<2)return void this.event("end");e>250&&(this._lastOffset=this._lastOffset>0?250:-250);var r=Math.round(Math.abs(this.elasticDistance*(this._lastOffset/150)));i.timer.frameLoop(1,this,this.tweenMove,[r])}},e.elasticOver=function(){this._isElastic=!1,!this.hide&&this.autoHide&&R.to(this,{alpha:0},500),this.event("end")},e.tweenMove=function(t){if(this._lastOffset*=this.rollRatio,!this.checkTriggers(!0)){var e=NaN;if(t>0&&(this._lastOffset>0&&this.value<=this.min?(this._isElastic=!0,e=.5*-(this.min-t-this.value),this._lastOffset>e&&(this._lastOffset=e)):this._lastOffset<0&&this.value>=this.max&&(this._isElastic=!0,e=.5*-(this.max+t-this.value),this._lastOffset<e&&(this._lastOffset=e))),this.value-=this._lastOffset,Math.abs(this._lastOffset)<.1){if(i.timer.clear(this,this.tweenMove),this._isElastic)return void(this._value<this.min?R.to(this,{value:this.min},this.elasticBackTime,at.sineOut,l.create(this,this.elasticOver)):this._value>this.max?R.to(this,{value:this.max},this.elasticBackTime,at.sineOut,l.create(this,this.elasticOver)):this.elasticOver());this.event("end"),!this.hide&&this.autoHide&&R.to(this,{alpha:0},500)}}},e.stopScroll=function(){this.onStageMouseUp2(null),i.timer.clear(this,this.tweenMove),R.clearTween(this)},r(0,e,"thumbPercent",function(){return this._thumbPercent},function(t){this.runCallLater(this.changeScrollBar),this.runCallLater(this._sizeChanged),t=t>=1?.99:t,this._thumbPercent=t,this.scaleBar&&(this.slider.isVertical?this.slider.bar.height=Math.max(this.slider.height*t,m.scrollBarMinNum):this.slider.bar.width=Math.max(this.slider.width*t,m.scrollBarMinNum))}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t||"string"==typeof t?this.value=Number(t):i.superSet(Vt,this,"dataSource",t)}),r(0,e,"skin",function(){return this._skin},function(t){" "!=t&&this._skin!=t&&(this._skin=t,this._skin&&!Ft.getRes(this._skin)?i.loader.load([this._skin,this._skin.replace(".png","$up.png"),this._skin.replace(".png","$down.png"),this._skin.replace(".png","$bar.png")],l.create(this,this._skinLoaded)):this._skinLoaded())}),r(0,e,"max",function(){return this.slider.max},function(t){this.slider.max=t}),r(0,e,"min",function(){return this.slider.min},function(t){this.slider.min=t}),r(0,e,"value",function(){return this._value},function(t){t!==this._value&&(this._value=t,this._isElastic||(this.slider._value!=t&&(this.slider._value=t,this.slider.changeValue()),this._value=this.slider._value),this.event("change"),this.changeHandler&&this.changeHandler.runWith(this._value))}),r(0,e,"isVertical",function(){return this.slider.isVertical},function(t){this.slider.isVertical=t}),r(0,e,"sizeGrid",function(){return this.slider.sizeGrid},function(t){this.slider.sizeGrid=t}),r(0,e,"scrollSize",function(){return this._scrollSize},function(t){this._scrollSize=t}),r(0,e,"target",function(){return this._target},function(t){this._target&&(this._target.off("mousewheel",this,this.onTargetMouseWheel),this._target.off("mousedown",this,this.onTargetMouseDown)),this._target=t,t&&(this._mouseWheelEnable&&this._target.on("mousewheel",this,this.onTargetMouseWheel),this._touchScrollEnable&&this._target.on("mousedown",this,this.onTargetMouseDown))}),r(0,e,"hide",function(){return this._hide},function(t){this._hide=t,this.visible=!t}),r(0,e,"showButtons",function(){return this._showButtons},function(t){this._showButtons=t,this.callLater(this.changeScrollBar)}),r(0,e,"touchScrollEnable",function(){return this._touchScrollEnable},function(t){this._touchScrollEnable=t,this.target=this._target}),r(0,e,"mouseWheelEnable",function(){return this._mouseWheelEnable},function(t){this._mouseWheelEnable=t,this.target=this._target}),r(0,e,"lastOffset",function(){return this._lastOffset}),r(0,e,"tick",function(){return this.slider.tick},function(t){this.slider.tick=t}),ScrollBar}(Vt),se=function(t){function Slider(t){this.changeHandler=null,this.isVertical=!0,this.showLabel=!0,this._allowClickBack=!1,this._max=100,this._min=0,this._tick=1,this._value=0,this._skin=null,this._bg=null,this._progress=null,this._bar=null,this._tx=NaN,this._ty=NaN,this._maxMove=NaN,this._globalSacle=null,Slider.__super.call(this),this.skin=t}n(Slider,"laya.ui.Slider",t);var e=Slider.prototype;return e.destroy=function(e){void 0===e&&(e=!0),t.prototype.destroy.call(this,e),this._bg&&this._bg.destroy(e),this._bar&&this._bar.destroy(e),this._progress&&this._progress.destroy(e),this._bg=null,this._bar=null,this._progress=null,this.changeHandler=null},e.createChildren=function(){this.addChild(this._bg=new Qt),this.addChild(this._bar=new Jt)},e.initialize=function(){this._bar.on("mousedown",this,this.onBarMouseDown),this._bg.sizeGrid=this._bar.sizeGrid="4,4,4,4,0",this._progress&&(this._progress.sizeGrid=this._bar.sizeGrid),this.allowClickBack=!0},e.onBarMouseDown=function(t){this._globalSacle||(this._globalSacle=new et),this._globalSacle.setTo(this.globalScaleX||.01,this.globalScaleY||.01),this._maxMove=this.isVertical?this.height-this._bar.height:this.width-this._bar.width,this._tx=i.stage.mouseX,this._ty=i.stage.mouseY,i.stage.on("mousemove",this,this.mouseMove),i.stage.once("mouseup",this,this.mouseUp),i.stage.once("mouseout",this,this.mouseUp),this.showValueText()},e.showValueText=function(){if(this.showLabel){var t=laya.ui.Slider.label;this.addChild(t),t.textField.changeText(this._value+""),this.isVertical?(t.x=this._bar._x+20,t.y=.5*(this._bar.height-t.height)+this._bar._y):(t.y=this._bar._y-20,t.x=.5*(this._bar.width-t.width)+this._bar._x)}},e.hideValueText=function(){laya.ui.Slider.label&&laya.ui.Slider.label.removeSelf()},e.mouseUp=function(t){i.stage.off("mousemove",this,this.mouseMove),i.stage.off("mouseup",this,this.mouseUp),i.stage.off("mouseout",this,this.mouseUp),this.sendChangeEvent("changed"),this.hideValueText()},e.mouseMove=function(t){var e=this._value;if(this.isVertical?(this._bar.y+=(i.stage.mouseY-this._ty)/this._globalSacle.y,this._bar._y>this._maxMove?this._bar.y=this._maxMove:this._bar._y<0&&(this._bar.y=0),this._value=this._bar._y/this._maxMove*(this._max-this._min)+this._min,this._progress&&(this._progress.height=this._bar._y+.5*this._bar.height)):(this._bar.x+=(i.stage.mouseX-this._tx)/this._globalSacle.x,this._bar._x>this._maxMove?this._bar.x=this._maxMove:this._bar._x<0&&(this._bar.x=0),this._value=this._bar._x/this._maxMove*(this._max-this._min)+this._min,this._progress&&(this._progress.width=this._bar._x+.5*this._bar.width)),this._tx=i.stage.mouseX,this._ty=i.stage.mouseY,0!=this._tick){var s=Math.pow(10,(this._tick+"").length-1);this._value=Math.round(Math.round(this._value/this._tick)*this._tick*s)/s}this._value!=e&&this.sendChangeEvent(),this.showValueText()},e.sendChangeEvent=function(t){void 0===t&&(t="change"),this.event(t),this.changeHandler&&this.changeHandler.runWith(this._value)},e._skinLoaded=function(){this._bg.skin=this._skin,this._bar.skin=this._skin.replace(".png","$bar.png");var t=this._skin.replace(".png","$progress.png");Ft.getRes(t)&&(this._progress||(this.addChild(this._progress=new Qt),this._progress.sizeGrid=this._bar.sizeGrid,this.setChildIndex(this._progress,1)),this._progress.skin=t),this.setBarPoint(),this.callLater(this.changeValue),this._sizeChanged(),this.event("loaded")},e.setBarPoint=function(){this.isVertical?this._bar.x=Math.round(.5*(this._bg.width-this._bar.width)):this._bar.y=Math.round(.5*(this._bg.height-this._bar.height))},e.measureWidth=function(){return Math.max(this._bg.width,this._bar.width)},e.measureHeight=function(){return Math.max(this._bg.height,this._bar.height)},e._sizeChanged=function(){t.prototype._sizeChanged.call(this),this.isVertical?this._bg.height=this.height:this._bg.width=this.width,this.setBarPoint(),this.changeValue()},e.setSlider=function(t,e,i){this._value=-1,this._min=t,this._max=e>t?e:t,this.value=i<t?t:i>e?e:i},e.changeValue=function(){if(0!=this.tick){var t=Math.pow(10,(this._tick+"").length-1);this._value=Math.round(Math.round(this._value/this._tick)*this._tick*t)/t}this._value=this._value>this._max?this._max:this._value<this._min?this._min:this._value;var e=this._max-this._min;0===e&&(e=1),this.isVertical?(this._bar.y=(this._value-this._min)/e*(this.height-this._bar.height),this._progress&&(this._progress.height=this._bar._y+.5*this._bar.height)):(this._bar.x=(this._value-this._min)/e*(this.width-this._bar.width),this._progress&&(this._progress.width=this._bar._x+.5*this._bar.width))},e.onBgMouseDown=function(t){var e=this._bg.getMousePoint();this.isVertical?this.value=e.y/(this.height-this._bar.height)*(this._max-this._min)+this._min:this.value=e.x/(this.width-this._bar.width)*(this._max-this._min)+this._min},r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t||"string"==typeof t?this.value=Number(t):i.superSet(Vt,this,"dataSource",t)}),r(0,e,"skin",function(){return this._skin},function(t){this._skin!=t&&(this._skin=t,this._skin&&!Ft.getRes(this._skin)?i.loader.load([this._skin,this._skin.replace(".png","$bar.png")],l.create(this,this._skinLoaded)):this._skinLoaded())}),r(0,e,"tick",function(){return this._tick},function(t){this._tick!=t&&(this._tick=t,this.callLater(this.changeValue))}),r(0,e,"sizeGrid",function(){return this._bg.sizeGrid},function(t){this._bg.sizeGrid=t,this._bar.sizeGrid=t,this._progress&&(this._progress.sizeGrid=this._bar.sizeGrid)}),r(0,e,"allowClickBack",function(){return this._allowClickBack},function(t){this._allowClickBack!=t&&(this._allowClickBack=t,t?this._bg.on("mousedown",this,this.onBgMouseDown):this._bg.off("mousedown",this,this.onBgMouseDown))}),r(0,e,"max",function(){return this._max},function(t){this._max!=t&&(this._max=t,this.callLater(this.changeValue))}),r(0,e,"min",function(){return this._min},function(t){this._min!=t&&(this._min=t,this.callLater(this.changeValue))}),r(0,e,"bar",function(){return this._bar}),r(0,e,"value",function(){return this._value},function(t){if(this._value!=t){var e=this._value;this._value=t,this.changeValue(),this._value!=e&&this.sendChangeEvent()}}),s(Slider,["label",function(){return this.label=new ee}]),Slider}(Vt),ne=function(t){function List(){this.selectHandler=null,this.renderHandler=null,this.mouseHandler=null,this.selectEnable=!1,this.totalPage=0,this._$componentType="List",this._content=null,this._scrollBar=null,this._itemRender=null,this._repeatX=0,this._repeatY=0,this._repeatX2=0,this._repeatY2=0,this._spaceX=0,this._spaceY=0,this._array=null,this._startIndex=0,this._selectedIndex=-1,this._page=0,this._isVertical=!0,this._cellSize=20,this._cellOffset=0,this._isMoved=!1,this.cacheContent=!1,this._createdLine=0,this._cellChanged=!1,this._usedCache=null,this._elasticEnabled=!1,this._preLen=0,List.__super.call(this),this._cells=[],this._offset=new et}n(List,"laya.ui.List",t);var e=List.prototype;return i.imps(e,{"laya.ui.IRender":!0,"laya.ui.IItem":!0}),e.destroy=function(t){void 0===t&&(t=!0),this._content&&this._content.destroy(t),this._scrollBar&&this._scrollBar.destroy(t),laya.ui.UIComponent.prototype.destroy.call(this,t),this._content=null,this._scrollBar=null,this._itemRender=null,this._cells=null,this._array=null,this.selectHandler=this.renderHandler=this.mouseHandler=null},e.createChildren=function(){this.addChild(this._content=new Zt)},e.onScrollStart=function(){this._usedCache||(this._usedCache=i.superGet(Zt,this,"cacheAs")),i.superSet(Zt,this,"cacheAs","none"),this._scrollBar.once("end",this,this.onScrollEnd)},e.onScrollEnd=function(){i.superSet(Zt,this,"cacheAs",this._usedCache)},e._removePreScrollBar=function(){var t=this.removeChildByName("scrollBar");t&&t.destroy(!0)},e.changeCells=function(){if(this._cellChanged=!1,this._itemRender){this.scrollBar=this.getChildByName("scrollBar");var t=this._getOneCell(),e=t.width+this._spaceX||1,i=t.height+this._spaceY||1;this._width>0&&(this._repeatX2=this._isVertical?Math.round(this._width/e):Math.ceil(this._width/e)),this._height>0&&(this._repeatY2=this._isVertical?Math.ceil(this._height/i):Math.round(this._height/i));var s=this._width?this._width:e*this.repeatX-this._spaceX,n=this._height?this._height:i*this.repeatY-this._spaceY;this._cellSize=this._isVertical?i:e,this._cellOffset=this._isVertical?i*Math.max(this._repeatY2,this._repeatY)-n-this._spaceY:e*Math.max(this._repeatX2,this._repeatX)-s-this._spaceX,this._isVertical&&this.vScrollBarSkin?this._scrollBar.height=n:!this._isVertical&&this.hScrollBarSkin&&(this._scrollBar.width=s),this.setContentSize(s,n);var r=this._isVertical?this.repeatX:this.repeatY,a=(this._isVertical?this.repeatY:this.repeatX)+(this._scrollBar?1:0);this._createItems(0,r,a),this._createdLine=a,this._array&&(this.array=this._array,this.runCallLater(this.renderItems))}},e._getOneCell=function(){if(0===this._cells.length){var t=this.createItem();if(this._offset.setTo(t._x,t._y),this.cacheContent)return t;this._cells.push(t)}return this._cells[0]},e._createItems=function(t,e,i){var s=this._content,n=this._getOneCell(),r=n.width+this._spaceX,a=n.height+this._spaceY;if(this.cacheContent){var o=new Zt;o.cacheAs="normal",o.pos((this._isVertical?0:t)*r,(this._isVertical?t:0)*a),this._content.addChild(o),s=o}else{for(var h=[],l=this._cells.length-1;l>-1;l--){var c=this._cells[l];c.removeSelf(),h.push(c)}this._cells.length=0}for(var u=t;u<i;u++)for(var _=0;_<e;_++)(n=h&&h.length?h.pop():this.createItem()).x=(this._isVertical?_:u)*r-s._x,n.y=(this._isVertical?u:_)*a-s._y,n.name="item"+(u*e+_),s.addChild(n),this.addCell(n)},e.createItem=function(){var t=[];if("function"==typeof this._itemRender)var e=new this._itemRender;else e=nt.createComp(this._itemRender,null,null,t);if(0==t.length&&e._watchMap){var i=e._watchMap;for(var s in i)for(var n=i[s],r=0;r<n.length;r++){var a=n[r];t.push(a.comp,a.prop,a.value)}}return t.length&&(e._$bindData=t),e},e.addCell=function(t){t.on("click",this,this.onCellMouse),t.on("rightclick",this,this.onCellMouse),t.on("mouseover",this,this.onCellMouse),t.on("mouseout",this,this.onCellMouse),t.on("mousedown",this,this.onCellMouse),t.on("mouseup",this,this.onCellMouse),this._cells.push(t)},e._afterInited=function(){this.initItems()},e.initItems=function(){if(!this._itemRender&&null!=this.getChildByName("item0")){this.repeatX=1;var t=0;t=0;for(var e=0;e<1e4;e++){var i=this.getChildByName("item"+e);if(!i)break;this.addCell(i),t++}this.repeatY=t}},e.setContentSize=function(t,e){this._content.width=t,this._content.height=e,(this._scrollBar||0!=this._offset.x||0!=this._offset.y)&&(this._content._style.scrollRect||(this._content.scrollRect=gt.create()),this._content._style.scrollRect.setTo(-this._offset.x,-this._offset.y,t,e),this._content.scrollRect=this._content.scrollRect),this.event("resize")},e.onCellMouse=function(t){"mousedown"===t.type&&(this._isMoved=!1);var e=t.currentTarget,i=this._startIndex+this._cells.indexOf(e);i<0||("click"===t.type||"rightclick"===t.type?this.selectEnable&&!this._isMoved?this.selectedIndex=i:this.changeCellState(e,!0,0):"mouseover"!==t.type&&"mouseout"!==t.type||this._selectedIndex===i||this.changeCellState(e,"mouseover"===t.type,0),this.mouseHandler&&this.mouseHandler.runWith([t,i]))},e.changeCellState=function(t,e,i){var s=t.getChildByName("selectBox");s&&(this.selectEnable=!0,s.visible=e,s.index=i)},e._sizeChanged=function(){laya.ui.UIComponent.prototype._sizeChanged.call(this),this.setContentSize(this.width,this.height),this._scrollBar&&this.callLater(this.onScrollBarChange)},e.onScrollBarChange=function(t){this.runCallLater(this.changeCells);var e=this._scrollBar.value,i=this._isVertical?this.repeatX:this.repeatY,s=this._isVertical?this.repeatY:this.repeatX,n=Math.floor(e/this._cellSize);if(this.cacheContent)a=s+1,this._createdLine-n<a&&(this._createItems(this._createdLine,i,this._createdLine+a),this.renderItems(this._createdLine*i,0),this._createdLine+=a);else{var r=n*i,a=0;if(r>this._startIndex){a=r-this._startIndex;var o=!0,h=this._startIndex+i*(s+1);this._isMoved=!0}else r<this._startIndex&&(a=this._startIndex-r,o=!1,h=this._startIndex-1,this._isMoved=!0);for(var l=0;l<a;l++){if(o){var c=this._cells.shift();this._cells[this._cells.length]=c;var u=h+l}else c=this._cells.pop(),this._cells.unshift(c),u=h-l;var _=Math.floor(u/i)*this._cellSize;this._isVertical?c.y=_:c.x=_,this.renderItem(c,u)}this._startIndex=r,this.changeSelectStatus()}var d=this._content._style.scrollRect;this._isVertical?(d.y=e-this._offset.y,d.x=-this._offset.x):(d.y=-this._offset.y,d.x=e-this._offset.x),this._content.scrollRect=d},e.posCell=function(t,e){if(this._scrollBar){var i=this._isVertical?this.repeatX:this.repeatY,s=(this._isVertical?this.repeatY:this.repeatX,Math.floor(e/i)*this._cellSize);this._isVertical?t._y=s:t.x=s}},e.changeSelectStatus=function(){for(var t=0,e=this._cells.length;t<e;t++)this.changeCellState(this._cells[t],this._selectedIndex===this._startIndex+t,1)},e.renderItems=function(t,e){void 0===t&&(t=0),void 0===e&&(e=0);for(var i=t,s=e||this._cells.length;i<s;i++)this.renderItem(this._cells[i],this._startIndex+i);this.changeSelectStatus()},e.renderItem=function(t,e){this._array&&e>=0&&e<this._array.length?(t.visible=!0,t._$bindData?(t._dataSource=this._array[e],this._bindData(t,this._array[e])):t.dataSource=this._array[e],this.cacheContent||this.posCell(t,e),this.hasListener("render")&&this.event("render",[t,e]),this.renderHandler&&this.renderHandler.runWith([t,e])):(t.visible=!1,t.dataSource=null)},e._bindData=function(t,e){for(var i=t._$bindData,s=0,n=i.length;s<n;s++){var r=i[s++],a=i[s++],o=i[s],h=J.getBindFun(o);r[a]=h.call(this,e)}},e.updateArray=function(t){this._array=t;var e=0;if(this._array&&((e=this._preLen-this._startIndex)>=0&&this.renderItems(e),this._preLen=this._array.length),this._scrollBar){var i=t.length,s=this._isVertical?this.repeatX:this.repeatY,n=this._isVertical?this.repeatY:this.repeatX,r=Math.ceil(i/s);r>=n&&(this._scrollBar.thumbPercent=n/r,this._scrollBar.slider._max=(r-n)*this._cellSize+this._cellOffset)}},e.refresh=function(){this.array=this._array},e.getItem=function(t){return t>-1&&t<this._array.length?this._array[t]:null},e.changeItem=function(t,e){t>-1&&t<this._array.length&&(this._array[t]=e,t>=this._startIndex&&t<this._startIndex+this._cells.length&&this.renderItem(this.getCell(t),t))},e.setItem=function(t,e){this.changeItem(t,e)},e.addItem=function(t){this._array.push(t),this.array=this._array},e.addItemAt=function(t,e){this._array.splice(e,0,t),this.array=this._array},e.deleteItem=function(t){this._array.splice(t,1),this.array=this._array},e.getCell=function(t){return this.runCallLater(this.changeCells),t>-1&&this._cells?this._cells[(t-this._startIndex)%this._cells.length]:null},e.scrollTo=function(t){if(this._scrollBar){var e=this._isVertical?this.repeatX:this.repeatY;this._scrollBar.value=Math.floor(t/e)*this._cellSize}else this.startIndex=t},e.tweenTo=function(t,e,i){if(void 0===e&&(e=200),this._scrollBar){this._scrollBar.stopScroll();var s=this._isVertical?this.repeatX:this.repeatY;R.to(this._scrollBar,{value:Math.floor(t/s)*this._cellSize},e,null,i,0,!0)}else this.startIndex=t,i&&i.run()},e._setCellChanged=function(){this._cellChanged||(this._cellChanged=!0,this.callLater(this.changeCells))},e.commitMeasure=function(){this.runCallLater(this.changeCells)},r(0,e,"cacheAs",t.prototype._$get_cacheAs,function(t){i.superSet(Zt,this,"cacheAs",t),this._scrollBar&&(this._usedCache=null,"none"!==t?this._scrollBar.on("start",this,this.onScrollStart):this._scrollBar.off("start",this,this.onScrollStart))}),r(0,e,"content",function(){return this._content}),r(0,e,"height",t.prototype._$get_height,function(t){t!=this._height&&(i.superSet(Zt,this,"height",t),this._setCellChanged())}),r(0,e,"itemRender",function(){return this._itemRender},function(t){if(this._itemRender!=t){this._itemRender=t;for(var e=this._cells.length-1;e>-1;e--)this._cells[e].destroy();this._cells.length=0,this._setCellChanged()}}),r(0,e,"vScrollBarSkin",function(){return this._scrollBar?this._scrollBar.skin:null},function(t){this._removePreScrollBar();var e=new oe;e.name="scrollBar",e.right=0,e.skin=t,e.elasticDistance=this._elasticEnabled?200:0,this.scrollBar=e,this.addChild(e),this._setCellChanged()}),r(0,e,"page",function(){return this._page},function(t){this._page=t,this._array&&(this._page=t>0?t:0,this._page=this._page<this.totalPage?this._page:this.totalPage-1,this.startIndex=this._page*this.repeatX*this.repeatY)}),r(0,e,"hScrollBarSkin",function(){return this._scrollBar?this._scrollBar.skin:null},function(t){this._removePreScrollBar();var e=new le;e.name="scrollBar",e.bottom=0,e.skin=t,e.elasticDistance=this._elasticEnabled?200:0,this.scrollBar=e,this.addChild(e),this._setCellChanged()}),r(0,e,"repeatX",function(){return this._repeatX>0?this._repeatX:this._repeatX2>0?this._repeatX2:1},function(t){this._repeatX=t,this._setCellChanged()}),r(0,e,"scrollBar",function(){return this._scrollBar},function(t){this._scrollBar!=t&&(this._scrollBar=t,t&&(this._isVertical=this._scrollBar.isVertical,this.addChild(this._scrollBar),this._scrollBar.on("change",this,this.onScrollBarChange)))}),r(0,e,"width",t.prototype._$get_width,function(t){t!=this._width&&(i.superSet(Zt,this,"width",t),this._setCellChanged())}),r(0,e,"repeatY",function(){return this._repeatY>0?this._repeatY:this._repeatY2>0?this._repeatY2:1},function(t){this._repeatY=t,this._setCellChanged()}),r(0,e,"spaceX",function(){return this._spaceX},function(t){this._spaceX=t,this._setCellChanged()}),r(0,e,"spaceY",function(){return this._spaceY},function(t){this._spaceY=t,this._setCellChanged()}),r(0,e,"selectedIndex",function(){return this._selectedIndex},function(t){this._selectedIndex!=t&&(this._selectedIndex=t,this.changeSelectStatus(),this.event("change"),this.selectHandler&&this.selectHandler.runWith(t),this.startIndex=this._startIndex)}),r(0,e,"selectedItem",function(){return-1!=this._selectedIndex?this._array[this._selectedIndex]:null},function(t){this.selectedIndex=this._array.indexOf(t)}),r(0,e,"length",function(){return this._array?this._array.length:0}),r(0,e,"selection",function(){return this.getCell(this._selectedIndex)},function(t){this.selectedIndex=this._startIndex+this._cells.indexOf(t)}),r(0,e,"startIndex",function(){return this._startIndex},function(t){this._startIndex=t>0?t:0,this.callLater(this.renderItems)}),r(0,e,"array",function(){return this._array},function(t){this.runCallLater(this.changeCells),this._array=t||[],this._preLen=this._array.length;var e=this._array.length;if(this.totalPage=Math.ceil(e/(this.repeatX*this.repeatY)),this._selectedIndex=this._selectedIndex<e?this._selectedIndex:e-1,this.startIndex=this._startIndex,this._scrollBar){this._scrollBar.stopScroll();var i=this._isVertical?this.repeatX:this.repeatY,s=this._isVertical?this.repeatY:this.repeatX,n=Math.ceil(e/i);(this._cellOffset>0?this.totalPage+1:this.totalPage)>1&&n>=s?(this._scrollBar.scrollSize=this._cellSize,this._scrollBar.thumbPercent=s/n,this._scrollBar.setScroll(0,(n-s)*this._cellSize+this._cellOffset,this._scrollBar.value),this._scrollBar.target=this._content):(this._scrollBar.setScroll(0,0,0),this._scrollBar.target=this._content)}}),r(0,e,"dataSource",t.prototype._$get_dataSource,function(t){this._dataSource=t,"number"==typeof t&&Math.floor(t)==t||"string"==typeof t?this.selectedIndex=parseInt(t):t instanceof Array?this.array=t:i.superSet(Zt,this,"dataSource",t)}),r(0,e,"cells",function(){return this.runCallLater(this.changeCells),this._cells}),r(0,e,"elasticEnabled",function(){return this._elasticEnabled},function(t){this._elasticEnabled=t,this._scrollBar&&(this._scrollBar.elasticDistance=t?200:0)}),List}(Zt),re=function(t){function Panel(){this._content=null,this._vScrollBar=null,this._hScrollBar=null,this._scrollChanged=!1,this._usedCache=null,this._elasticEnabled=!1,Panel.__super.call(this),this.width=this.height=100}n(Panel,"laya.ui.Panel",t);var e=Panel.prototype;return e.destroy=function(t){void 0===t&&(t=!0),laya.ui.UIComponent.prototype.destroy.call(this,t),this._content&&this._content.destroy(t),this._vScrollBar&&this._vScrollBar.destroy(t),this._hScrollBar&&this._hScrollBar.destroy(t),this._vScrollBar=null,this._hScrollBar=null,this._content=null},e.destroyChildren=function(){this._content.destroyChildren()},e.createChildren=function(){laya.display.Node.prototype.addChild.call(this,this._content=new Zt)},e.addChild=function(t){return t.on("resize",this,this.onResize),this._setScrollChanged(),this._content.addChild(t)},e.onResize=function(){this._setScrollChanged()},e.addChildAt=function(t,e){return t.on("resize",this,this.onResize),this._setScrollChanged(),this._content.addChildAt(t,e)},e.removeChild=function(t){return t.off("resize",this,this.onResize),this._setScrollChanged(),this._content.removeChild(t)},e.removeChildAt=function(t){return this.getChildAt(t).off("resize",this,this.onResize),this._setScrollChanged(),this._content.removeChildAt(t)},e.removeChildren=function(t,e){return void 0===t&&(t=0),void 0===e&&(e=2147483647),this._content.removeChildren(t,e),this._setScrollChanged(),this},e.getChildAt=function(t){return this._content.getChildAt(t)},e.getChildByName=function(t){return this._content.getChildByName(t)},e.getChildIndex=function(t){return this._content.getChildIndex(t)},e.changeScroll=function(){this._scrollChanged=!1;var t=this.contentWidth||1,e=this.contentHeight||1,i=this._vScrollBar,s=this._hScrollBar,n=i&&e>this._height,r=s&&t>this._width,a=n?this._width-i.width:this._width,o=r?this._height-s.height:this._height;i&&(i.x=this._width-i.width,i.y=0,i.height=this._height-(r?s.height:0),i.scrollSize=Math.max(.033*this._height,1),i.thumbPercent=o/e,i.setScroll(0,e-o,i.value)),s&&(s.x=0,s.y=this._height-s.height,s.width=this._width-(n?i.width:0),s.scrollSize=Math.max(.033*this._width,1),s.thumbPercent=a/t,s.setScroll(0,t-a,s.value))},e._sizeChanged=function(){laya.ui.UIComponent.prototype._sizeChanged.call(this),this.setContentSize(this._width,this._height)},e.setContentSize=function(t,e){var i=this._content;i.width=t,i.height=e,i._style.scrollRect||(i.scrollRect=gt.create()),i._style.scrollRect.setTo(0,0,t,e),i.scrollRect=i.scrollRect},e.onScrollBarChange=function(t){var e=this._content._style.scrollRect;if(e){var i=Math.round(t.value);t.isVertical?e.y=i:e.x=i,this._content.scrollRect=e}},e.scrollTo=function(t,e){void 0===t&&(t=0),void 0===e&&(e=0),this.vScrollBar&&(this.vScrollBar.value=e),this.hScrollBar&&(this.hScrollBar.value=t)},e.refresh=function(){this.changeScroll()},e.onScrollStart=function(){this._usedCache||(this._usedCache=i.superGet(Zt,this,"cacheAs")),i.superSet(Zt,this,"cacheAs","none"),this._hScrollBar&&this._hScrollBar.once("end",this,this.onScrollEnd),this._vScrollBar&&this._vScrollBar.once("end",this,this.onScrollEnd)},e.onScrollEnd=function(){i.superSet(Zt,this,"cacheAs",this._usedCache)},e._setScrollChanged=function(){this._scrollChanged||(this._scrollChanged=!0,this.callLater(this.changeScroll))},r(0,e,"numChildren",function(){return this._content.numChildren}),r(0,e,"hScrollBarSkin",function(){return this._hScrollBar?this._hScrollBar.skin:null},function(t){null==this._hScrollBar&&(laya.display.Node.prototype.addChild.call(this,this._hScrollBar=new le),this._hScrollBar.on("change",this,this.onScrollBarChange,[this._hScrollBar]),this._hScrollBar.target=this._content,this._hScrollBar.elasticDistance=this._elasticEnabled?200:0,this._setScrollChanged()),this._hScrollBar.skin=t}),r(0,e,"contentWidth",function(){for(var t=0,e=this._content.numChildren-1;e>-1;e--){var i=this._content.getChildAt(e);t=Math.max(i._x+i.width*i.scaleX-i.pivotX,t)}return t}),r(0,e,"contentHeight",function(){for(var t=0,e=this._content.numChildren-1;e>-1;e--){var i=this._content.getChildAt(e);t=Math.max(i._y+i.height*i.scaleY-i.pivotY,t)}return t}),r(0,e,"width",t.prototype._$get_width,function(t){i.superSet(Zt,this,"width",t),this._setScrollChanged()}),r(0,e,"hScrollBar",function(){return this._hScrollBar}),r(0,e,"content",function(){return this._content}),r(0,e,"height",t.prototype._$get_height,function(t){i.superSet(Zt,this,"height",t),this._setScrollChanged()}),r(0,e,"vScrollBarSkin",function(){return this._vScrollBar?this._vScrollBar.skin:null},function(t){null==this._vScrollBar&&(laya.display.Node.prototype.addChild.call(this,this._vScrollBar=new oe),this._vScrollBar.on("change",this,this.onScrollBarChange,[this._vScrollBar]),this._vScrollBar.target=this._content,this._vScrollBar.elasticDistance=this._elasticEnabled?200:0,this._setScrollChanged()),this._vScrollBar.skin=t}),r(0,e,"vScrollBar",function(){return this._vScrollBar}),r(0,e,"cacheAs",t.prototype._$get_cacheAs,function(t){i.superSet(Zt,this,"cacheAs",t),this._usedCache=null,"none"!==t?(this._hScrollBar&&this._hScrollBar.on("start",this,this.onScrollStart),this._vScrollBar&&this._vScrollBar.on("start",this,this.onScrollStart)):(this._hScrollBar&&this._hScrollBar.off("start",this,this.onScrollStart),this._vScrollBar&&this._vScrollBar.off("start",this,this.onScrollStart))}),r(0,e,"elasticEnabled",function(){return this._elasticEnabled},function(t){this._elasticEnabled=t,this._vScrollBar&&(this._vScrollBar.elasticDistance=t?200:0),this._hScrollBar&&(this._hScrollBar.elasticDistance=t?200:0)}),Panel}(Zt),ae=function(t){function FontClip(t,e){this._valueArr=null,this._indexMap=null,this._sheet=null,this._direction="horizontal",this._spaceX=0,this._spaceY=0,this._align="left",this._wordsW=0,this._wordsH=0,FontClip.__super.call(this),t&&(this.skin=t),e&&(this.sheet=e)}n(FontClip,"laya.ui.FontClip",t);var e=FontClip.prototype;return e.createChildren=function(){this._bitmap=new Gt,this.on("loaded",this,this._onClipLoaded)},e._onClipLoaded=function(){this.callLater(this.changeValue)},e.changeValue=function(){var t;if(this._sources&&(this._valueArr&&(this.graphics.clear(!0),t=this._sources[0]))){var e="horizontal"===this._direction;e?(this._wordsW=this._valueArr.length*(t.sourceWidth+this.spaceX),this._wordsH=t.sourceHeight):(this._wordsW=t.sourceWidth,this._wordsH=(t.sourceHeight+this.spaceY)*this._valueArr.length);var i=0;if(this._width)switch(this._align){case"center":i=.5*(this._width-this._wordsW);break;case"right":i=this._width-this._wordsW;break;default:i=0}for(var s=0,n=this._valueArr.length;s<n;s++){var r=this._indexMap[this._valueArr.charAt(s)];this.sources[r]&&(t=this.sources[r],e?this.graphics.drawImage(t,i+s*(t.sourceWidth+this.spaceX),0,t.sourceWidth,t.sourceHeight):this.graphics.drawImage(t,0+i,s*(t.sourceHeight+this.spaceY),t.sourceWidth,t.sourceHeight))}this._width||(this._widget.resetLayoutX(),this.callLater(this._sizeChanged)),this._height||(this._widget.resetLayoutY(),this.callLater(this._sizeChanged))}},e.measureWidth=function(){return this._wordsW},e.measureHeight=function(){return this._wordsH},e.destroy=function(e){void 0===e&&(e=!0),this._valueArr=null,this._indexMap=null,this.graphics.clear(!0),this.removeSelf(),this.off("loaded",this,this._onClipLoaded),t.prototype.destroy.call(this,e)},r(0,e,"sheet",function(){return this._sheet},function(t){t+="",this._sheet=t;var e=t.split(" ");this._clipX=String(e[0]).length,this.clipY=e.length,this._indexMap={};for(var i=0;i<this._clipY;i++)for(var s=e[i].split(""),n=0,r=s.length;n<r;n++)this._indexMap[s[n]]=i*this._clipX+n}),r(0,e,"height",t.prototype._$get_height,function(t){i.superSet(te,this,"height",t),this.callLater(this.changeValue)}),r(0,e,"direction",function(){return this._direction},function(t){this._direction=t,this.callLater(this.changeValue)}),r(0,e,"value",function(){return this._valueArr?this._valueArr:""},function(t){t+="",this._valueArr=t,this.callLater(this.changeValue)}),r(0,e,"width",t.prototype._$get_width,function(t){i.superSet(te,this,"width",t),this.callLater(this.changeValue)}),r(0,e,"spaceX",function(){return this._spaceX},function(t){this._spaceX=t,"horizontal"===this._direction&&this.callLater(this.changeValue)}),r(0,e,"spaceY",function(){return this._spaceY},function(t){this._spaceY=t,"horizontal"!==this._direction&&this.callLater(this.changeValue)}),r(0,e,"align",function(){return this._align},function(t){this._align=t,this.callLater(this.changeValue)}),FontClip}(te),oe=function(t){function VScrollBar(){VScrollBar.__super.call(this)}return n(VScrollBar,"laya.ui.VScrollBar",ie),VScrollBar}(),he=function(t){function VSlider(){VSlider.__super.call(this)}return n(VSlider,"laya.ui.VSlider",se),VSlider}(),le=function(t){function HScrollBar(){HScrollBar.__super.call(this)}return n(HScrollBar,"laya.ui.HScrollBar",t),HScrollBar.prototype.initialize=function(){t.prototype.initialize.call(this),this.slider.isVertical=!1},HScrollBar}(ie),ce=function(t){function HSlider(t){HSlider.__super.call(this,t),this.isVertical=!1}return n(HSlider,"laya.ui.HSlider",se),HSlider}();i.__init([nt,h,B,d,Bt,Kt,Nt])}(window,document,Laya),function(t,e,i){i.un,i.uns,i.static;var s=i.class;i.getset,i.__newvec;new(function(){function LayaMain(){}return s(LayaMain,"LayaMain"),LayaMain}())}(window,document,Laya);
})();

/******/ })()
;