(function () {
    'use strict';

    let ui_fit_width = 100;
    let ui_fit_height = 100;
    let canvas_width = 100;
    let canvas_height = 100;
    const B_FILL_DEVICE = true;
    class UIRoot extends Laya.Script {
        constructor() {
            super(...arguments);
            this.standardShort = 576;
            this.standardLong = 1024;
            this.uiMinRate = 0.4;
            this.maxRate = 0.75;
            this.canvasMinRate = 0.44;
            this.layerNode = [];
        }
        static get canvasWidth() {
            return canvas_width;
        }
        static get canvasHeight() {
            return canvas_height;
        }
        static get uiFitWidth() {
            return ui_fit_width;
        }
        static get uiFitHeight() {
            return ui_fit_height;
        }
        static get uiFitTop() {
            return ui_fit_height < canvas_height ? (canvas_height - ui_fit_height) / 2 : 0;
        }
        static get uiFitLeft() {
            return ui_fit_width < canvas_width ? (canvas_width - ui_fit_width) / 2 : 0;
        }
        static get canvasCenterX() {
            return canvas_width / 2;
        }
        static get canvasCenterY() {
            return canvas_height / 2;
        }
        onAwake() {
            this.fixScreenResolution();
            UIRoot.instance = this;
        }
        onDestroy() {
            UIRoot.instance = null;
            if (super.onDestroy) {
                super.onDestroy();
            }
        }
        fixScreenResolution() {
            let frameSize = new Laya.Vector2(Laya.Browser.width, Laya.Browser.height);
            console.log("frame size:", frameSize.x, frameSize.y);
            let bPortrait = false;
            if (true) {
                bPortrait = true;
            }
            let standardRate = this.standardShort / this.standardLong;
            let frameRate;
            if (bPortrait) {
                frameRate = frameSize.x / frameSize.y;
            }
            else {
                frameRate = frameSize.y / frameSize.x;
            }
            let policy;
            let short, long;
            let shortFull, longFull;
            if (frameRate < standardRate) {
                if (frameRate < this.uiMinRate) {
                    long = this.standardLong * (standardRate / this.uiMinRate);
                    longFull = Math.floor(this.standardLong * (standardRate / frameRate));
                    let maxLong = Math.floor(this.standardLong * (standardRate / this.canvasMinRate));
                    longFull = Math.min(longFull, maxLong);
                    policy = Laya.Stage.SCALE_SHOWALL;
                    console.log(`长边超出：重置长边 ${long}`);
                }
                else {
                    long = this.standardLong * (standardRate / frameRate);
                    longFull = long;
                    if (bPortrait) {
                        policy = Laya.Stage.SCALE_FIXED_WIDTH;
                    }
                    else {
                        policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                    }
                    console.log(`短边适配:${long}`);
                }
                long = Math.floor(long);
                short = this.standardShort;
                shortFull = short;
            }
            else if (frameRate > standardRate) {
                if (frameRate > this.maxRate) {
                    short = this.standardShort * (this.maxRate / standardRate);
                    shortFull = Math.floor(this.standardShort * (frameRate / standardRate));
                    shortFull = short;
                    policy = Laya.Stage.SCALE_SHOWALL;
                    console.log(`短边超出：重置短边 ${short}`);
                }
                else {
                    short = this.standardShort * (frameRate / standardRate);
                    shortFull = short;
                    if (bPortrait) {
                        policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                    }
                    else {
                        policy = Laya.Stage.SCALE_FIXED_WIDTH;
                    }
                    console.log(`长边适配:${short}`);
                }
                short = Math.floor(short);
                long = this.standardLong;
                longFull = long;
            }
            else {
                console.log("默认适配");
                short = this.standardShort;
                long = this.standardLong;
                shortFull = short;
                longFull = long;
                if (bPortrait) {
                    policy = Laya.Stage.SCALE_FIXED_WIDTH;
                }
                else {
                    policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                }
            }
            if (bPortrait) {
                ui_fit_width = short;
                ui_fit_height = long;
                canvas_width = B_FILL_DEVICE ? shortFull : ui_fit_width;
                canvas_height = B_FILL_DEVICE ? longFull : ui_fit_height;
                UIRoot._designWidth = this.standardShort;
                UIRoot._designHeight = this.standardLong;
            }
            else {
                ui_fit_width = long;
                ui_fit_height = short;
                canvas_width = B_FILL_DEVICE ? longFull : ui_fit_width;
                canvas_height = B_FILL_DEVICE ? shortFull : ui_fit_height;
                UIRoot._designWidth = this.standardLong;
                UIRoot._designHeight = this.standardShort;
            }
            console.log("cur fit size:", ui_fit_width, ui_fit_height);
            console.log("cur full size:", canvas_width, canvas_height);
            Laya.stage.width = canvas_width;
            Laya.stage.height = canvas_height;
            Laya.stage.scaleMode = Laya.Stage.SCALE_SHOWALL;
            Laya.stage.screenMode = Laya.Stage.SCREEN_NONE;
            Laya.stage.alignH = Laya.Stage.ALIGN_CENTER;
            Laya.stage.alignV = Laya.Stage.ALIGN_MIDDLE;
            this.owner.size(canvas_width, canvas_height);
        }
        static get designWidth() {
            return this._designWidth;
        }
        static get designHeight() {
            return this._designHeight;
        }
    }

    let cur_log_level = 3;
    let EMPTY_FUN = function () { };
    class Logger {
        static catchError(userMessage, error) {
            let errorStr = this.getErrorStr(error);
            this.error(`[${userMessage} error]:\n${errorStr}`);
        }
        static getErrorStr(error) {
            if (error instanceof Error) {
                return `message:${error.message} stack:${error.stack}`;
            }
            else {
                if (error) {
                    return JSON.stringify(error);
                }
                else {
                    return error.toString();
                }
            }
        }
        static setLogLevel(level) {
            cur_log_level = level;
            level >= 3 ? Logger.debug = console.log : EMPTY_FUN;
            level >= 2 ? Logger.log = console.log : EMPTY_FUN;
            level >= 1 ? Logger.warn = console.warn : EMPTY_FUN;
            level >= 0 ? Logger.error = console.error : EMPTY_FUN;
        }
        static get isDebugLevel() {
            return cur_log_level == 3;
        }
    }
    Logger.log = console.log;
    Logger.debug = console.log;
    Logger.warn = console.warn;
    Logger.error = console.error;

    function safeAdd(x, y) {
        var lsw = (x & 0xffff) + (y & 0xffff);
        var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xffff);
    }
    function bitRotateLeft(num, cnt) {
        return (num << cnt) | (num >>> (32 - cnt));
    }
    function md5cmn(q, a, b, x, s, t) {
        return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
    }
    function md5ff(a, b, c, d, x, s, t) {
        return md5cmn((b & c) | (~b & d), a, b, x, s, t);
    }
    function md5gg(a, b, c, d, x, s, t) {
        return md5cmn((b & d) | (c & ~d), a, b, x, s, t);
    }
    function md5hh(a, b, c, d, x, s, t) {
        return md5cmn(b ^ c ^ d, a, b, x, s, t);
    }
    function md5ii(a, b, c, d, x, s, t) {
        return md5cmn(c ^ (b | ~d), a, b, x, s, t);
    }
    function binlMD5(x, len) {
        x[len >> 5] |= 0x80 << (len % 32);
        x[((len + 64) >>> 9 << 4) + 14] = len;
        var i;
        var olda;
        var oldb;
        var oldc;
        var oldd;
        var a = 1732584193;
        var b = -271733879;
        var c = -1732584194;
        var d = 271733878;
        for (i = 0; i < x.length; i += 16) {
            olda = a;
            oldb = b;
            oldc = c;
            oldd = d;
            a = md5ff(a, b, c, d, x[i], 7, -680876936);
            d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
            c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
            b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
            a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
            d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
            c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
            b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
            a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
            d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
            c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
            b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
            a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
            d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
            c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
            b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
            a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
            d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
            c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
            b = md5gg(b, c, d, a, x[i], 20, -373897302);
            a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
            d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
            c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
            b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
            a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
            d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
            c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
            b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
            a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
            d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
            c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
            b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
            a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
            d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
            c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
            b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
            a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
            d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
            c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
            b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
            a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
            d = md5hh(d, a, b, c, x[i], 11, -358537222);
            c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
            b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
            a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
            d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
            c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
            b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
            a = md5ii(a, b, c, d, x[i], 6, -198630844);
            d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
            c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
            b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
            a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
            d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
            c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
            b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
            a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
            d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
            c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
            b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
            a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
            d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
            c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
            b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
            a = safeAdd(a, olda);
            b = safeAdd(b, oldb);
            c = safeAdd(c, oldc);
            d = safeAdd(d, oldd);
        }
        return [a, b, c, d];
    }
    function binl2rstr(input) {
        var i;
        var output = '';
        var length32 = input.length * 32;
        for (i = 0; i < length32; i += 8) {
            output += String.fromCharCode((input[i >> 5] >>> (i % 32)) & 0xff);
        }
        return output;
    }
    function rstr2binl(input) {
        var i;
        var output = [];
        output[(input.length >> 2) - 1] = undefined;
        for (i = 0; i < output.length; i += 1) {
            output[i] = 0;
        }
        var length8 = input.length * 8;
        for (i = 0; i < length8; i += 8) {
            output[i >> 5] |= (input.charCodeAt(i / 8) & 0xff) << (i % 32);
        }
        return output;
    }
    function rstrMD5(s) {
        return binl2rstr(binlMD5(rstr2binl(s), s.length * 8));
    }
    function rstrHMACMD5(key, data) {
        var i;
        var bkey = rstr2binl(key);
        var ipad = [];
        var opad = [];
        var hash;
        ipad[15] = opad[15] = undefined;
        if (bkey.length > 16) {
            bkey = binlMD5(bkey, key.length * 8);
        }
        for (i = 0; i < 16; i += 1) {
            ipad[i] = bkey[i] ^ 0x36363636;
            opad[i] = bkey[i] ^ 0x5c5c5c5c;
        }
        hash = binlMD5(ipad.concat(rstr2binl(data)), 512 + data.length * 8);
        return binl2rstr(binlMD5(opad.concat(hash), 512 + 128));
    }
    function rstr2hex(input) {
        var hexTab = '0123456789abcdef';
        var output = '';
        var x;
        var i;
        for (i = 0; i < input.length; i += 1) {
            x = input.charCodeAt(i);
            output += hexTab.charAt((x >>> 4) & 0x0f) + hexTab.charAt(x & 0x0f);
        }
        return output;
    }
    function str2rstrUTF8(input) {
        return unescape(encodeURIComponent(input));
    }
    function rawMD5(s) {
        return rstrMD5(str2rstrUTF8(s));
    }
    function hexMD5(s) {
        return rstr2hex(rawMD5(s));
    }
    function rawHMACMD5(k, d) {
        return rstrHMACMD5(str2rstrUTF8(k), str2rstrUTF8(d));
    }
    function hexHMACMD5(k, d) {
        return rstr2hex(rawHMACMD5(k, d));
    }
    function md5(string, key, raw) {
        if (!key) {
            if (!raw) {
                return hexMD5(string);
            }
            return rawMD5(string);
        }
        if (!raw) {
            return hexHMACMD5(key, string);
        }
        return rawHMACMD5(key, string);
    }

    const Base64 = (function () {
        const version = '3.5.2';
        const VERSION = version;
        const _hasatob = typeof atob === 'function';
        const _hasbtoa = typeof btoa === 'function';
        const _hasBuffer = typeof Buffer === 'function';
        const _TD = typeof TextDecoder === 'function' ? new TextDecoder() : undefined;
        const _TE = typeof TextEncoder === 'function' ? new TextEncoder() : undefined;
        const b64ch = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
        const b64chs = [...b64ch];
        const b64tab = ((a) => {
            let tab = {};
            a.forEach((c, i) => tab[c] = i);
            return tab;
        })(b64chs);
        const b64re = /^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/;
        const _fromCC = String.fromCharCode.bind(String);
        const _U8Afrom = typeof Uint8Array.from === 'function'
            ? Uint8Array.from.bind(Uint8Array)
            : (it, fn = (x) => x) => new Uint8Array(Array.prototype.slice.call(it, 0).map(fn));
        const _mkUriSafe = (src) => src
            .replace(/[+\/]/g, (m0) => m0 == '+' ? '-' : '_')
            .replace(/=+$/m, '');
        const _tidyB64 = (s) => s.replace(/[^A-Za-z0-9\+\/]/g, '');
        const btoaPolyfill = (bin) => {
            let u32, c0, c1, c2, asc = '';
            const pad = bin.length % 3;
            for (let i = 0; i < bin.length;) {
                if ((c0 = bin.charCodeAt(i++)) > 255 ||
                    (c1 = bin.charCodeAt(i++)) > 255 ||
                    (c2 = bin.charCodeAt(i++)) > 255)
                    throw new TypeError('invalid character found');
                u32 = (c0 << 16) | (c1 << 8) | c2;
                asc += b64chs[u32 >> 18 & 63]
                    + b64chs[u32 >> 12 & 63]
                    + b64chs[u32 >> 6 & 63]
                    + b64chs[u32 & 63];
            }
            return pad ? asc.slice(0, pad - 3) + "===".substring(pad) : asc;
        };
        const _btoa = _hasbtoa ? (bin) => btoa(bin)
            : _hasBuffer ? (bin) => Buffer.from(bin, 'binary').toString('base64')
                : btoaPolyfill;
        const _fromUint8Array = _hasBuffer
            ? (u8a) => Buffer.from(u8a).toString('base64')
            : (u8a) => {
                const maxargs = 0x1000;
                let strs = [];
                for (let i = 0, l = u8a.length; i < l; i += maxargs) {
                    strs.push(_fromCC.apply(null, u8a.subarray(i, i + maxargs)));
                }
                return _btoa(strs.join(''));
            };
        const fromUint8Array = (u8a, urlsafe = false) => urlsafe ? _mkUriSafe(_fromUint8Array(u8a)) : _fromUint8Array(u8a);
        const cb_utob = (c) => {
            if (c.length < 2) {
                var cc = c.charCodeAt(0);
                return cc < 0x80 ? c
                    : cc < 0x800 ? (_fromCC(0xc0 | (cc >>> 6))
                        + _fromCC(0x80 | (cc & 0x3f)))
                        : (_fromCC(0xe0 | ((cc >>> 12) & 0x0f))
                            + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                            + _fromCC(0x80 | (cc & 0x3f)));
            }
            else {
                var cc = 0x10000
                    + (c.charCodeAt(0) - 0xD800) * 0x400
                    + (c.charCodeAt(1) - 0xDC00);
                return (_fromCC(0xf0 | ((cc >>> 18) & 0x07))
                    + _fromCC(0x80 | ((cc >>> 12) & 0x3f))
                    + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                    + _fromCC(0x80 | (cc & 0x3f)));
            }
        };
        const re_utob = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g;
        const utob = (u) => u.replace(re_utob, cb_utob);
        const _encode = _hasBuffer
            ? (s) => Buffer.from(s, 'utf8').toString('base64')
            : _TE
                ? (s) => _fromUint8Array(_TE.encode(s))
                : (s) => _btoa(utob(s));
        const encode = (src, urlsafe = false) => urlsafe
            ? _mkUriSafe(_encode(src))
            : _encode(src);
        const encodeURI = (src) => encode(src, true);
        const re_btou = /[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3}/g;
        const cb_btou = (cccc) => {
            switch (cccc.length) {
                case 4:
                    var cp = ((0x07 & cccc.charCodeAt(0)) << 18)
                        | ((0x3f & cccc.charCodeAt(1)) << 12)
                        | ((0x3f & cccc.charCodeAt(2)) << 6)
                        | (0x3f & cccc.charCodeAt(3)), offset = cp - 0x10000;
                    return (_fromCC((offset >>> 10) + 0xD800)
                        + _fromCC((offset & 0x3FF) + 0xDC00));
                case 3:
                    return _fromCC(((0x0f & cccc.charCodeAt(0)) << 12)
                        | ((0x3f & cccc.charCodeAt(1)) << 6)
                        | (0x3f & cccc.charCodeAt(2)));
                default:
                    return _fromCC(((0x1f & cccc.charCodeAt(0)) << 6)
                        | (0x3f & cccc.charCodeAt(1)));
            }
        };
        const btou = (b) => b.replace(re_btou, cb_btou);
        const atobPolyfill = (asc) => {
            asc = asc.replace(/\s+/g, '');
            if (!b64re.test(asc))
                throw new TypeError('malformed base64.');
            asc += '=='.slice(2 - (asc.length & 3));
            let u24, bin = '', r1, r2;
            for (let i = 0; i < asc.length;) {
                u24 = b64tab[asc.charAt(i++)] << 18
                    | b64tab[asc.charAt(i++)] << 12
                    | (r1 = b64tab[asc.charAt(i++)]) << 6
                    | (r2 = b64tab[asc.charAt(i++)]);
                bin += r1 === 64 ? _fromCC(u24 >> 16 & 255)
                    : r2 === 64 ? _fromCC(u24 >> 16 & 255, u24 >> 8 & 255)
                        : _fromCC(u24 >> 16 & 255, u24 >> 8 & 255, u24 & 255);
            }
            return bin;
        };
        const _atob = _hasatob ? (asc) => atob(_tidyB64(asc))
            : _hasBuffer ? (asc) => Buffer.from(asc, 'base64').toString('binary')
                : atobPolyfill;
        const _toUint8Array = _hasBuffer
            ? (a) => _U8Afrom(Buffer.from(a, 'base64'))
            : (a) => _U8Afrom(_atob(a), c => c.charCodeAt(0));
        const toUint8Array = (a) => _toUint8Array(_unURI(a));
        const _decode = _hasBuffer
            ? (a) => Buffer.from(a, 'base64').toString('utf8')
            : _TD
                ? (a) => _TD.decode(_toUint8Array(a))
                : (a) => btou(_atob(a));
        const _unURI = (a) => _tidyB64(a.replace(/[-_]/g, (m0) => m0 == '-' ? '+' : '/'));
        const decode = (src) => _decode(_unURI(src));
        const _noEnum = (v) => {
            return {
                value: v, enumerable: false, writable: true, configurable: true
            };
        };
        const extendString = function () {
            const _add = (name, body) => Object.defineProperty(String.prototype, name, _noEnum(body));
            _add('fromBase64', function () { return decode(this); });
            _add('toBase64', function (urlsafe) { return encode(this, urlsafe); });
            _add('toBase64URI', function () { return encode(this, true); });
            _add('toBase64URL', function () { return encode(this, true); });
            _add('toUint8Array', function () { return toUint8Array(this); });
        };
        const extendUint8Array = function () {
            const _add = (name, body) => Object.defineProperty(Uint8Array.prototype, name, _noEnum(body));
            _add('toBase64', function (urlsafe) { return fromUint8Array(this, urlsafe); });
            _add('toBase64URI', function () { return fromUint8Array(this, true); });
            _add('toBase64URL', function () { return fromUint8Array(this, true); });
        };
        const extendBuiltins = () => {
            extendString();
            extendUint8Array();
        };
        return {
            version: version,
            VERSION: VERSION,
            atob: _atob,
            atobPolyfill: atobPolyfill,
            btoa: _btoa,
            btoaPolyfill: btoaPolyfill,
            encode: encode,
            encodeURI: encodeURI,
            utob: utob,
            btou: btou,
            decode: decode,
            fromUint8Array: fromUint8Array,
            toUint8Array: toUint8Array,
            extendString: extendString,
            extendUint8Array: extendUint8Array,
            extendBuiltins: extendBuiltins,
        };
    })();

    let _convert = function (match, nosign) {
        if (nosign) {
            match.sign = '';
        }
        else {
            match.sign = match.negative ? '-' : match.sign;
        }
        var l = match.min - match.argument.length + 1 - match.sign.length;
        var pad = new Array(l < 0 ? 0 : l).join(match.pad);
        if (!match.left) {
            if (match.pad == "0" || nosign) {
                return match.sign + pad + match.argument;
            }
            else {
                return pad + match.sign + match.argument;
            }
        }
        else {
            if (match.pad == "0" || nosign) {
                return match.sign + match.argument + pad.replace(/0/g, ' ');
            }
            else {
                return match.sign + match.argument + pad;
            }
        }
    };
    function sprintf(...args) {
        if (typeof args == "undefined") {
            return null;
        }
        if (args.length < 1) {
            return null;
        }
        if (typeof args[0] != "string") {
            return null;
        }
        if (typeof RegExp == "undefined") {
            return null;
        }
        var string = args[0];
        var exp = new RegExp(/(%([%]|(\-)?(\+|\x20)?(0)?(\d+)?(\.(\d)?)?([bcdfosxX])))/g);
        var matches = new Array();
        var strings = new Array();
        var convCount = 0;
        var stringPosStart = 0;
        var stringPosEnd = 0;
        var matchPosEnd = 0;
        var newString = '';
        var match = null;
        while (match = exp.exec(string)) {
            if (match[9]) {
                convCount += 1;
            }
            stringPosStart = matchPosEnd;
            stringPosEnd = exp.lastIndex - match[0].length;
            strings[strings.length] = string.substring(stringPosStart, stringPosEnd);
            matchPosEnd = exp.lastIndex;
            matches[matches.length] = {
                match: match[0],
                left: match[3] ? true : false,
                sign: match[4] || '',
                pad: match[5] || ' ',
                min: match[6] || 0,
                precision: match[8],
                code: match[9] || '%',
                negative: parseInt(args[convCount]) < 0 ? true : false,
                argument: String(args[convCount])
            };
        }
        strings[strings.length] = string.substring(matchPosEnd);
        if (matches.length == 0) {
            return string;
        }
        if ((args.length - 1) < convCount) {
            return null;
        }
        var code = null;
        var match = null;
        var substitution = null;
        var i = null;
        for (i = 0; i < matches.length; i++) {
            if (matches[i].code == '%') {
                substitution = '%';
            }
            else if (matches[i].code == 'b') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(2));
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'c') {
                matches[i].argument = String(String.fromCharCode(Math.abs(parseInt(matches[i].argument))));
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'd') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'f') {
                matches[i].argument = String(Math.abs(parseFloat(matches[i].argument)).toFixed(matches[i].precision ? matches[i].precision : 6));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'o') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(8));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 's') {
                matches[i].argument = matches[i].argument.substring(0, matches[i].precision ? matches[i].precision : matches[i].argument.length);
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'x') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'X') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                substitution = _convert(matches[i]).toUpperCase();
            }
            else {
                substitution = matches[i].match;
            }
            newString += strings[i];
            newString += substitution;
        }
        newString += strings[i];
        return newString;
    }

    const _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    const lookup = new Uint8Array(256);
    for (let i = 0; i < _keyStr.length; i++) {
        lookup[_keyStr.charCodeAt(i)] = i;
    }
    class Base64Plus {
        static get nativeBase64() {
            return false;
        }
        static decode(base64) {
            base64 = base64.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            if (this.nativeBase64) {
                return window.atob(base64);
            }
            else {
                var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
                while (i < base64.length) {
                    enc1 = _keyStr.indexOf(base64.charAt(i++));
                    enc2 = _keyStr.indexOf(base64.charAt(i++));
                    enc3 = _keyStr.indexOf(base64.charAt(i++));
                    enc4 = _keyStr.indexOf(base64.charAt(i++));
                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;
                    output.push(String.fromCharCode(chr1));
                    if (enc3 !== 64) {
                        output.push(String.fromCharCode(chr2));
                    }
                    if (enc4 !== 64) {
                        output.push(String.fromCharCode(chr3));
                    }
                }
                output = output.join("");
                return this._utf8_decode(output);
            }
        }
        static encode(input) {
            input = this._utf8_encode(input);
            if (this.nativeBase64) {
                window.btoa(input);
            }
            else {
                var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
                while (i < input.length) {
                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);
                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;
                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    }
                    else if (isNaN(chr3)) {
                        enc4 = 64;
                    }
                    output.push(_keyStr.charAt(enc1));
                    output.push(_keyStr.charAt(enc2));
                    output.push(_keyStr.charAt(enc3));
                    output.push(_keyStr.charAt(enc4));
                }
                output = output.join("");
                return output;
            }
        }
        static encodeArrayBuffer(arraybuffer) {
            var bytes = new Uint8Array(arraybuffer), i, len = bytes["length"], base64 = "";
            for (i = 0; i < len; i += 3) {
                base64 += _keyStr[bytes[i] >> 2];
                base64 += _keyStr[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
                base64 += _keyStr[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
                base64 += _keyStr[bytes[i + 2] & 63];
            }
            if ((len % 3) === 2) {
                base64 = base64.substring(0, base64.length - 1) + "=";
            }
            else if (len % 3 === 1) {
                base64 = base64.substring(0, base64.length - 2) + "==";
            }
            return base64;
        }
        static decodeArrayBuffer(base64) {
            var bufferLength = base64.length * 0.75, len = base64.length, i, p = 0, encoded1, encoded2, encoded3, encoded4;
            if (base64[base64.length - 1] === "=") {
                bufferLength--;
                if (base64[base64.length - 2] === "=") {
                    bufferLength--;
                }
            }
            var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
            for (i = 0; i < len; i += 4) {
                encoded1 = lookup[base64.charCodeAt(i)];
                encoded2 = lookup[base64.charCodeAt(i + 1)];
                encoded3 = lookup[base64.charCodeAt(i + 2)];
                encoded4 = lookup[base64.charCodeAt(i + 3)];
                bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
                bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
                bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
            }
            return arraybuffer;
        }
        static decodeToUnit32Array(base64, bytes) {
            bytes = bytes || 1;
            var dec = Base64Plus.decode(base64), i, j, len;
            var ar = new Uint32Array(dec.length / bytes);
            for (i = 0, len = dec.length / bytes; i < len; i++) {
                ar[i] = 0;
                for (j = bytes - 1; j >= 0; --j) {
                    ar[i] += dec.charCodeAt((i * bytes) + j) << (j << 3);
                }
            }
            return ar;
        }
        static removePaddingChars(base64) {
            var lkey = _keyStr.indexOf(base64.charAt(base64.length - 1));
            if (lkey == 64) {
                return base64.substring(0, base64.length - 1);
            }
            return base64;
        }
        static decodeToUnit8Array(base64, arrayBuffer) {
            base64 = this.removePaddingChars(base64);
            base64 = this.removePaddingChars(base64);
            var bytes = Math.floor(base64.length / 4 * 3);
            let uarray;
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            var j = 0;
            if (arrayBuffer)
                uarray = new Uint8Array(arrayBuffer);
            else
                uarray = new Uint8Array(bytes);
            base64 = base64.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            for (i = 0; i < bytes; i += 3) {
                enc1 = _keyStr.indexOf(base64.charAt(j++));
                enc2 = _keyStr.indexOf(base64.charAt(j++));
                enc3 = _keyStr.indexOf(base64.charAt(j++));
                enc4 = _keyStr.indexOf(base64.charAt(j++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                uarray[i] = chr1;
                if (enc3 != 64)
                    uarray[i + 1] = chr2;
                if (enc4 != 64)
                    uarray[i + 2] = chr3;
            }
            return uarray;
        }
        static decodeToArrayBuffer(base64) {
            var bytes = Math.floor((base64.length / 4) * 3);
            var ab = new ArrayBuffer(bytes);
            this.decodeToUnit8Array(base64, ab);
            return ab;
        }
        static _utf8_encode(input) {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            return utftext;
        }
        static _utf8_decode(utftext) {
            var string = "";
            var i = 0;
            var c = 0;
            var c1 = 0;
            var c2 = 0;
            var c3 = 0;
            while (i < utftext.length) {
                c = utftext.charCodeAt(i);
                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                }
                else if ((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i + 1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                }
                else {
                    c2 = utftext.charCodeAt(i + 1);
                    c3 = utftext.charCodeAt(i + 2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }
            }
            return string;
        }
    }

    const LOG10 = Math.log(10);
    class Mathf {
        static log(value, newBase) {
            if (newBase == null) {
                return Math.log(value) / LOG10;
            }
            else {
                return Math.log(value) / Math.log(newBase);
            }
        }
        static getDigits(num) {
            return Math.floor(this.log(num));
        }
        static random(min, max) {
            if (min == null) {
                return Math.random();
            }
            else if (max == null) {
                return (Math.random() * min + 1) | 0;
            }
            else {
                return (Math.random() * (max - min + 1) + min) | 0;
            }
        }
        static randomPlusOrMinus() {
            return (this.random(2) - 1) * 2 - 1;
        }
        static trueOrFalse() {
            return Math.random() > 0.5;
        }
        static randomEnable(rate) {
            return this.random(100) <= rate;
        }
        static clamp01(value) {
            if (value > 1)
                return 1;
            else if (value < 0)
                return 0;
            else
                return value;
        }
        static clamp(value, min, max) {
            if (value < min)
                return min;
            else if (value > max)
                return max;
            else
                return value;
        }
        static sign(value) {
            if (value >= 0)
                return 1;
            else
                return -1;
        }
        static fuzzyEquals(value1, value2) {
            return Math.abs(value1 - value2) < this.EPSILON;
        }
        static lerp(min, max, t) {
            return min + (max - min) * this.clamp01(t);
        }
        static inverseLerp(min, max, cur) {
            if (min != max) {
                return this.clamp01((cur - min) / (max - min));
            }
            else {
                return 0;
            }
        }
        static lerpFromInverseLerp(valueMin, valueMax, fromMin, fromMax, fromValue) {
            return this.lerp(valueMin, valueMax, this.inverseLerp(fromMin, fromMax, fromValue));
        }
        static getFitScale(x, y, maxX, maxY) {
            let scaleX = maxX / x;
            let scaleY = maxY / y;
            return Math.min(scaleX, scaleY);
        }
        static round(value, digits) {
            digits = digits || 0;
            let num = this.roundPower10Double[digits];
            value *= num;
            return Math.round(value) / num;
        }
        static loop(value, min, max) {
            if (max == null) {
                max = min;
                min = 0;
            }
            if (value < min) {
                return min;
            }
            else {
                let v = (value - min) % (max - min);
                return min + v;
            }
        }
        static pingPong(value, min, max) {
            if (max == null) {
                max = min;
                min = 0;
            }
            if (value < min) {
                return min;
            }
            else {
                let d = max - min;
                let v1 = value - min;
                let s = Math.floor(v1 / d);
                let v2 = v1 % d;
                if (s % 2 == 0) {
                    return v2 + min;
                }
                else {
                    return max - v2;
                }
            }
        }
        static nextGaussian(mean, std_dev) {
            return mean + (this.uniform2NormalDistribution() * std_dev);
        }
        static uniform2NormalDistribution() {
            var sum = 0.0;
            for (var i = 0; i < 12; i++) {
                sum = sum + Math.random();
            }
            return sum - 6.0;
        }
        static circleRandom(...weights) {
            return this.arrCircleRandom(weights);
        }
        static arrCircleRandom(weights) {
            let sum = 0;
            for (let i = 0; i < weights.length; i++) {
                sum += weights[i];
            }
            if (sum <= 0)
                return -1;
            let random = Mathf.random(sum);
            for (let i = 0; i < weights.length; i++) {
                if (random <= weights[i]) {
                    return i;
                }
                random -= weights[i];
            }
            return -1;
        }
        static makeArray(len, shuffle = true) {
            let arr = new Array(len);
            for (let i = 0; i < len; i++) {
                arr[i] = i;
            }
            shuffle && this.shuffle(arr);
            return arr;
        }
        static randomFromArray(arr, removeIt) {
            if (arr && arr.length) {
                let idx = this.random(arr.length) - 1;
                if (removeIt) {
                    return arr.splice(idx, 1)[0];
                }
                else {
                    return arr[idx];
                }
            }
            else {
                return null;
            }
        }
        static randomArrFromArray(arr, count, removeIt) {
            let result = [];
            if (arr) {
                if (!removeIt) {
                    arr = arr.slice();
                }
                for (let i = Math.min(arr.length, count); i > 0; i--) {
                    result.push(this.randomFromArray(arr, true));
                }
            }
            return result;
        }
        static shuffle(data) {
            let temp;
            let rnd;
            for (let i = data.length - 1; i > 0; i--) {
                rnd = this.random(0, i);
                temp = data[i];
                data[i] = data[rnd];
                data[rnd] = temp;
            }
        }
        static swap(data, i, j) {
            let temp = data[i];
            data[i] = data[j];
            data[j] = temp;
        }
        static minIndex(values) {
            let minValue = Number.MAX_SAFE_INTEGER;
            let index = -1;
            for (let i = values.length - 1; i >= 0; i--) {
                if (values[i] <= minValue) {
                    minValue = values[i];
                    index = i;
                }
            }
            return index;
        }
        static distance(p1, p2) {
            let dx = p1.x - p2.x;
            let dy = p1.y - p2.y;
            return Math.sqrt(dx * dx + dy * dy);
        }
        static distance2(dx, dy) {
            return Math.sqrt(dx * dx + dy * dy);
        }
        static distanceSqr(p1, p2) {
            let dx = p1.x - p2.x;
            let dy = p1.y - p2.y;
            return dx * dx + dy * dy;
        }
        static distanceSqr2(dx, dy) {
            return dx * dx + dy * dy;
        }
        static point2line(a, b, s) {
            let sqrt = Math.sqrt;
            let pow = Math.pow;
            let ab = sqrt(pow((a.x - b.x), 2) + pow((a.y - b.y), 2) + pow((a.z - b.z), 2));
            let as = sqrt(pow((a.x - s.x), 2) + pow((a.y - s.y), 2) + pow((a.z - s.z), 2));
            let bs = sqrt(pow((s.x - b.x), 2) + pow((s.y - b.y), 2) + pow((s.z - b.z), 2));
            let cos_A = (pow(as, 2) + pow(ab, 2) - pow(bs, 2)) / (2 * ab * as);
            let sin_A = sqrt(1 - pow(cos_A, 2));
            return as * sin_A;
        }
        static easeInLogic(val) {
            return 1 - Math.sin(0.5 * Math.PI * (1 - val));
        }
        static easeOutLogic(val) {
            return Math.sin(0.5 * Math.PI * val);
        }
        static easeInOutLogic(val) {
            let pi2 = Math.PI * 2;
            return val - Math.sin(val * pi2) / pi2;
        }
        static bounceLogic(val) {
            if (val < 0.363636) {
                val = 7.5685 * val * val;
            }
            else if (val < 0.727272) {
                val = 7.5625 * (val -= 0.545454) * val + 0.75;
            }
            else if (val < 0.909090) {
                val = 7.5625 * (val -= 0.818181) * val + 0.9375;
            }
            else {
                val = 7.5625 * (val -= 0.9545454) * val + 0.984375;
            }
            return val;
        }
        static calcAngleA2B(A, B) {
            if (!A)
                return 0;
            if (!B)
                return 0;
            let magA = Laya.Vector3.scalarLength(A);
            let magB = Laya.Vector3.scalarLength(B);
            if (!magA)
                return 0;
            if (!magB)
                return 0;
            let cos_angle = Laya.Vector3.dot(A, B) / (magA * magB);
            let angle = Math.acos(cos_angle);
            return angle;
        }
    }
    Mathf.roundPower10Double = [
        1.0,
        10.0,
        100.0,
        1000.0,
        10000.0,
        100000.0,
        1000000.0,
        10000000.0,
        100000000.0,
        1000000000.0,
        10000000000.0,
        100000000000.0,
        1000000000000.0,
        10000000000000.0,
        100000000000000.0,
        1E+15
    ];
    Mathf.PI = 3.14159274;
    Mathf.Deg2Rad = 0.0174532924;
    Mathf.Rad2Deg = 57.295779;
    Mathf.TEMP_POINT = new Laya.Point();
    Mathf.TEMP_POINTS = [
        new Laya.Point(),
        new Laya.Point(),
        new Laya.Point(),
        new Laya.Point(),
    ];
    Mathf.TempRect = Laya.Rectangle.create();
    Mathf.VEC3_UP = new Laya.Vector3(0, 1, 0);
    Mathf.TEMP_VEC3 = new Laya.Vector3();
    Mathf.TEMP_VEC3S = [
        new Laya.Vector3(),
        new Laya.Vector3(),
        new Laya.Vector3(),
        new Laya.Vector3(),
    ];
    Mathf.EPSILON = 1e-6;

    let pako$1 = window["pako"];
    function _dump(arr, level) {
        let dumped_text = "";
        if (!level)
            level = 0;
        let level_padding = "";
        for (let j = 0; j < level + 1; j++)
            level_padding += "    ";
        if (arr instanceof Array) {
            for (let i = 0; i < arr.length; i++) {
                let value = arr[i];
                if (typeof (value) == 'object') {
                    dumped_text += level_padding + i + " ...\n";
                    dumped_text += _dump(value, level + 1);
                }
                else {
                    if (typeof value == "number") {
                        dumped_text += level_padding + i + " => " + value + "\n";
                    }
                    else {
                        dumped_text += level_padding + i + " => \"" + value + "\"\n";
                    }
                }
            }
        }
        else if (typeof arr == "object") {
            for (let item in arr) {
                let value = arr[item];
                if (typeof (value) == 'object') {
                    dumped_text += level_padding + "'" + item + "' ...\n";
                    dumped_text += _dump(value, level + 1);
                }
                else {
                    if (typeof value == "number") {
                        dumped_text += level_padding + "'" + item + "' => " + value + "\n";
                    }
                    else {
                        dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
                    }
                }
            }
        }
        else {
            dumped_text = "===>" + arr + "<===(" + typeof (arr) + ")";
        }
        return dumped_text;
    }
    class Tools {
        static gameExecuteTime() {
            return this.gameRuingTime;
        }
        static autoIncrementRuingTime() {
            if (!this.gameRuingTime) {
                this.gameRuingTime = 0;
            }
            this.gameRuingTime += Math.min(this.delta(), 1);
        }
        static delta() {
            return Laya.timer.delta / 1000 * this.timeScale;
        }
        static forward(transform, pos) {
            let delta = new Laya.Vector3();
            Laya.Vector3.subtract(pos, transform.position, delta);
            let targetPos = new Laya.Vector3();
            Laya.Vector3.subtract(transform.position, delta, targetPos);
            transform.lookAt(targetPos, new Laya.Vector3(0, 1, 0), false);
        }
        static forwardDirection(transform, dir) {
            let targetPos = new Laya.Vector3();
            Laya.Vector3.subtract(transform.position, dir, targetPos);
            transform.lookAt(targetPos, new Laya.Vector3(0, 1, 0), false);
        }
        static isOneDay(seconds1, seconds2) {
            let d1 = new Date(seconds1 * 1000);
            let d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate();
        }
        static random(min, max) {
            if (min == null && max == null) {
                return Math.random();
            }
            else if (max == null) {
                return Math.floor(Math.random() * min + 1);
            }
            else {
                return Math.floor(Math.random() * (max - min + 1) + min);
            }
        }
        static getMidnightTime(second) {
            let dNow;
            if (second == null) {
                dNow = new Date(Date.now());
            }
            else {
                dNow = new Date(second * 1000);
            }
            dNow.setHours(0, 0, 0, 0);
            return dNow.getTime() / 1000;
        }
        static getObjSize(obj) {
            if (!obj) {
                return 0;
            }
            if (Array.isArray(obj)) {
                return obj.length;
            }
            let count = 0;
            Tools.forEachMap(obj, (k, v) => {
                count++;
            });
            return count;
        }
        static forEachMap(map, callback) {
            if (!map)
                return;
            var keys = Object.keys(map);
            var key, value;
            for (var i = 0, count = keys.length; i < count; i++) {
                key = keys[i];
                value = map[key];
                if (value != null) {
                    if (callback(key, value))
                        break;
                }
            }
        }
        static clearNullValue(map) {
            var keys = Object.keys(map);
            var key, value;
            for (var i = 0, count = keys.length; i < count; i++) {
                key = keys[i];
                value = map[key];
                if (value == null) {
                    delete map[key];
                }
            }
        }
        static splitToInt(input, separator) {
            if (!input || !separator) {
                return [];
            }
            let arr = input.split(separator);
            let narr = [];
            for (let i = 0; i < arr.length; i++) {
                narr[i] = this.safeParseInt(arr[i], null);
            }
            return narr;
        }
        static splitToNumber(input, separator) {
            if (!input || !separator) {
                return [];
            }
            let arr = input.split(separator);
            let narr = [];
            for (let i = 0; i < arr.length; i++) {
                narr[i] = this.safeParseFloat(arr[i], null);
            }
            return narr;
        }
        static formatNumber(num, fillStr, limitCount) {
            num = Math.floor(num);
            let calcNum = num;
            let numLen = 1;
            while (true) {
                calcNum /= 10;
                if (calcNum >= 1) {
                    numLen++;
                }
                else {
                    break;
                }
            }
            if (numLen >= limitCount) {
                return num.toString();
            }
            else {
                let fillCount = limitCount - numLen;
                let result = "";
                for (let i = 0; i < fillCount; i++) {
                    result += fillStr;
                }
                return result + num;
            }
        }
        static _formatTime(time, format) {
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.floor(time) % 60;
            if (format.match("%h")) {
                format = format.replace("%h", hour.toString());
            }
            if (format.match("%H")) {
                format = format.replace("%h", Tools.formatNumber(hour, "0", 2));
            }
            if (format.match("%m")) {
                format = format.replace("%m", minute.toString());
            }
            if (format.match("%M")) {
                format = format.replace("%M", Tools.formatNumber(minute, "0", 2));
            }
            if (format.match("%s")) {
                format = format.replace("%s", second.toString());
            }
            if (format.match("%S")) {
                format = format.replace("%S", Tools.formatNumber(second, "0", 2));
            }
            return format;
        }
        static formatTime(time) {
            time = Math.ceil(time);
            if (time <= 0)
                return "00:00";
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.ceil(time) % 60;
            let result = "";
            if (hour > 0) {
                result = hour + ":";
            }
            if (minute > 9) {
                result = `${result}${minute}:`;
            }
            else {
                result = `${result}0${minute}:`;
            }
            if (second > 9) {
                result = `${result}${second}`;
            }
            else {
                result = `${result}0${second}`;
            }
            return result;
        }
        static formatFullTime(timeStamp = Date.now()) {
            var time = new Date(timeStamp);
            var y = time.getFullYear();
            var m = time.getMonth() + 1;
            var d = time.getDate();
            var h = time.getHours();
            var tm = time.getMinutes();
            var s = time.getSeconds();
            return `${y}-${m < 10 ? "0" + m : m}-${d < 10 ? "0" + d : d} ${h < 10 ? "0" + h : h}:${tm < 10 ? "0" + tm : tm}:${s < 10 ? "0" + s : s}`;
        }
        static formatDate(timeStamp) {
            var time = new Date(timeStamp);
            var y = time.getFullYear();
            var m = time.getMonth() + 1;
            var d = time.getDate();
            return `${y}-${m}-${d}`;
        }
        static format() {
            this.format = sprintf;
            return sprintf(...arguments);
        }
        static generateUUID() {
            let d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }
        ;
        static deepCopy(src, dest) {
            if (!src)
                return src;
            if (src instanceof Array) {
                let newObj = dest || [];
                let len = src.length;
                for (let i = 0; i < len; i++) {
                    const element = src[i];
                    newObj.push(this.deepCopy(element));
                }
                return newObj;
            }
            else if (src instanceof Object) {
                let newObj = dest || {};
                let keys = Object.keys(src);
                for (let i = 0; i < keys.length; i++) {
                    let key = keys[i];
                    let value = src[key];
                    newObj[key] = this.deepCopy(value);
                }
                return newObj;
            }
            else {
                return src;
            }
        }
        static testDeepCopy() {
            let str = "haha";
            console.log(this.deepCopy(str));
            let num = 3;
            console.log(this.deepCopy(num));
            let arr = ["1", "3"];
            console.log(this.deepCopy(arr));
            let obj = { a: "h", b: "m" };
            console.log(this.deepCopy(obj));
        }
        static mergeArray(srcArr, destArr) {
            for (let i = 0; i < srcArr.length; i++) {
                destArr.push(srcArr[i]);
            }
        }
        static swap(arr, idx1, idx2) {
            let temp = arr[idx1];
            arr[idx1] = arr[idx2];
            arr[idx2] = temp;
        }
        static getMd5(context) {
            if (context == null) {
                return md5("null");
            }
            else {
                return md5(context);
            }
        }
        static getMax(arr) {
            let max = -Number.MAX_VALUE;
            for (let i = 0; i < arr.length; i++) {
                if (max < arr[i]) {
                    max = arr[i];
                }
            }
            return max;
        }
        static getMaxIndex(arr) {
            let max = -Number.MAX_VALUE;
            let idx = -1;
            for (let i = 0; i < arr.length; i++) {
                if (max < arr[i]) {
                    max = arr[i];
                    idx = i;
                }
            }
            return idx;
        }
        static isValueType(value) {
            let type = typeof value;
            if (type == "number" || type == "boolean" || type == "string") {
                return true;
            }
            return false;
        }
        static serializeObject(obj) {
            let newObj = this.deepCopy(obj);
            return JSON.stringify(newObj);
        }
        static copyTo(res, dest) {
            if (res instanceof Array) {
                for (let i = 0; i < res.length; i++) {
                    dest[i] = res[i];
                }
            }
            if (res instanceof Object) {
                let keys = Object.keys(res);
                for (let i = 0; i < keys.length; i++) {
                    let key = keys[i];
                    dest[key] = res[key];
                }
            }
        }
        static deserializeObject(objData, obj) {
            let newObj = JSON.parse(objData);
            this.copyTo(newObj, obj);
        }
        static safeParseInt(value, defaultValue, radix) {
            let v = parseInt(value, radix);
            if (isNaN(v)) {
                return defaultValue;
            }
            else {
                return v;
            }
        }
        static safeParseFloat(value, defaultValue) {
            let v = parseFloat(value);
            if (isNaN(v)) {
                return defaultValue;
            }
            else {
                return v;
            }
        }
        static safeParseBool(value) {
            if (!value)
                return false;
            value = value.toString();
            if (value == "0")
                return false;
            value = value.toLowerCase();
            return value != "false";
        }
        static arrayCopy(src, srcPos, dest, destPos, lenght) {
            if (src.length < srcPos + lenght)
                throw "arrayCopy: src out of bound";
            if (dest.length < destPos + lenght)
                throw "arrayCopy: dest out of bound";
            for (let i = 0; i < lenght; i++) {
                dest[destPos + i] = src[srcPos + i];
            }
        }
        static arrayFill(arr, value) {
            for (let i = arr.length - 1; i >= 0; i--) {
                arr[i] = value;
            }
        }
        static sort_db_by_order(d1, d2) {
            return d1.order - d2.order;
        }
        static dump(data, tag, level) {
            let text = _dump(data);
            console.log("dump-begin", tag);
            console.log(text);
            console.log("dump-end");
        }
        static utf8Len(str) {
            var len = 0;
            if (str) {
                for (var i = 0; i < str.length; i++) {
                    let code = str.charCodeAt(i);
                    if (code > 127 || code == 94) {
                        len += 2;
                    }
                    else {
                        len++;
                    }
                }
            }
            return len;
        }
        static bitSub(a, b) {
            if ((a & b) > 0) {
                return a - b;
            }
            else {
                return a;
            }
        }
        static compress(str) {
            return pako$1.gzip(str, { to: "string" });
        }
        static decompress(str) {
            try {
                return pako$1.ungzip(str, { to: "string" });
            }
            catch (error) {
                Logger.catchError("Tools.decompress", error);
                return null;
            }
        }
        static compressToBase64(str) {
            let compressStr = this.compress(str);
            return Base64.encode(compressStr);
        }
        static decompressFromBase64(str) {
            let compressStr = Base64.decode(str);
            return this.decompress(compressStr);
        }
        static compressArr(arr) {
            return pako$1.deflate(arr);
        }
        static decompressArr(arr) {
            try {
                return pako$1.inflate(arr);
            }
            catch (error) {
                Logger.catchError("Tools.decompressArr", error);
            }
        }
        static decompressArrToStr(arr) {
            return pako$1.ungzip(arr, { to: "string" });
        }
        static printTrace() {
            if (Logger.isDebugLevel && console.trace)
                Logger.log(console.trace());
        }
        static getPath(file) {
            let idx = file.lastIndexOf("/");
            if (idx > 0) {
                return file.slice(0, idx + 1);
            }
            else {
                return ";;";
            }
        }
        static _toHexColor(value) {
            let rst;
            rst = Math.floor(value * 255).toString(16);
            rst = rst.length > 1 ? rst : "0" + rst;
            return rst;
        }
        static toHexColor(color) {
            return "#" + this._toHexColor(color.r) + this._toHexColor(color.g) + this._toHexColor(color.b) + this._toHexColor(color.a);
        }
        static toLayaColor(value) {
            value.charAt(0) === '#' && (value = value.substr(1));
            var len = value.length;
            var color = parseInt(value, 16);
            if (len === 6) {
                return new Laya.Color(((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255, 1);
            }
            else if (len == 8) {
                color = parseInt(value.substr(0, 6), 16);
                let alpha = parseInt(value.substr(6), 16);
                return new Laya.Color(((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255, alpha / 255);
            }
            return null;
        }
        static requestHttp(url, caller, onSuc, onError) {
            var xhr = new Laya.HttpRequest();
            xhr.http.timeout = 10000;
            xhr.once(Laya.Event.COMPLETE, caller, onSuc);
            xhr.once(Laya.Event.ERROR, caller, onError);
            xhr.send("res/data.data", "", "get", "text");
        }
        static reverseBitmap(bitmap, width, height) {
            var newmap = new Uint8Array(width * height * 4);
            let wstride = width * 4;
            let st = 0;
            let dst = (height - 1) * wstride;
            for (var i = height - 1; i >= 0; i--) {
                newmap.set(bitmap.slice(dst, dst + wstride), st);
                st += wstride;
                dst -= wstride;
            }
            return newmap;
        }
        static getTex2dFromTex2d(tex2d, x, y, width, height) {
            x = (x | 0);
            y = (y | 0);
            width = (width | 0);
            height = (height | 0);
            var ret = this.getTexturePixels(tex2d, x, y, width, height);
            let newTex2d = new Laya.Texture2D(width, height, tex2d.format, false, true);
            newTex2d.setPixels(ret);
            return newTex2d;
        }
        static getTexturePixels(tex2d, x, y, width, height) {
            x = (x | 0);
            y = (y | 0);
            width = (width | 0);
            height = (height | 0);
            let tex2dw = tex2d.width, tex2dh = tex2d.height;
            let pix = tex2d.getPixels();
            if (x == 0 && y == 0 && width == tex2dw && height == tex2dh)
                return pix;
            let uv = Laya.Texture.DEF_UV;
            let atlasPosX = Math.round(uv[0] * tex2dw);
            let atlasPosY = Math.round(uv[1] * tex2dh);
            var ret = new Uint8Array(width * height * 4);
            let wstride = tex2dw * 4;
            let dst = (atlasPosY + y) * wstride;
            let st = atlasPosX * 4 + x * 4 + dst;
            for (var i = 0; i < height; i++) {
                ret.set(pix.slice(st, st + width * 4), width * 4 * (i + 0) + 0 * 4);
                st += wstride;
            }
            return ret;
        }
        static isNodeVaild(node) {
            if (!node)
                return false;
            if (node.destroyed)
                return false;
            if (node.owner && node.owner.destroyed)
                return false;
            if (node.parent && node.parent.destroyed)
                return false;
            return true;
        }
        static findAllSkinnedMeshRenderers(node, out, recursive = false) {
            out = out || [];
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                if (child) {
                    let render = child["skinnedMeshRenderer"];
                    if (render) {
                        out.push(render);
                    }
                    if (recursive) {
                        this.findAllSkinnedMeshRenderers(child, out, recursive);
                    }
                }
            }
            return out;
        }
        static findAllRenderers(node) {
            let out = [];
            this.__findAllRenderers(node, out, node);
            return out;
        }
        static __findAllRenderers(node, out, root) {
            let render = node["_render"];
            if (render) {
                out.push({
                    router: this.traceToFindRouter(root, node),
                    renderer: render,
                    node: node,
                });
            }
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                this.__findAllRenderers(child, out, root);
            }
        }
        static traceToFindRouter(root, cursorNode) {
            let router = "/";
            while (cursorNode !== root) {
                router = "/" + cursorNode.name + router;
                cursorNode = cursorNode.parent;
            }
            return router;
        }
        static findAllShurikenParticleSystem(node, out) {
            out = out || [];
            for (var i = node.numChildren - 1; i >= 0; i--) {
                var child = node.getChildAt(i);
                if (child.particleSystem) {
                    out.push(child.particleSystem);
                }
                this.findAllShurikenParticleSystem(child, out);
            }
            return out;
        }
        static setSprite3dLayer(node, layer) {
            node.layer = layer;
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                this.setSprite3dLayer(child, layer);
            }
        }
        static objLength(obj) {
            let type = this.getType(obj);
            if (type === "array") {
                let length = 0;
                for (const key in obj) {
                    const element = obj[key];
                    if (element) {
                        length++;
                    }
                }
                return length;
            }
            else if (type === "object") {
                let length = 0;
                for (const key in obj) {
                    const element = obj[key];
                    if (element) {
                        length++;
                    }
                }
                return length;
            }
            else {
                return 0;
            }
        }
        static getType(obj) {
            let toString = Object.prototype.toString;
            let map = {
                '[object Boolean]': 'boolean',
                '[object Number]': 'number',
                '[object String]': 'string',
                '[object Function]': 'function',
                '[object Array]': 'array',
                '[object Date]': 'date',
                '[object RegExp]': 'regExp',
                '[object Undefined]': 'undefined',
                '[object Null]': 'null',
                '[object Object]': 'object'
            };
            return map[toString.call(obj)];
        }
        static link2Node(nodeName, root, Sprite3D) {
            if (root.name == nodeName) {
                root.addChild(Sprite3D);
                Sprite3D.transform.localPosition = new Laya.Vector3();
                return true;
            }
            let index = 0;
            let child = null;
            while (true) {
                child = root.getChildAt(index);
                if (!child)
                    break;
                if (child.name == nodeName) {
                    child.addChild(Sprite3D);
                    Sprite3D.transform.localPosition = new Laya.Vector3();
                    return true;
                }
                else {
                    if (this.link2Node(nodeName, child, Sprite3D)) {
                        return true;
                    }
                }
                index++;
            }
            return false;
        }
        static unLink2Node(Sprite3D) {
            Sprite3D.removeSelf();
        }
        static findNode(nodeName, root) {
            if (root.name == nodeName) {
                return root;
            }
            for (let i = 0; i < root.numChildren; i++) {
                let child = root.getChildAt(i);
                if (child.name == nodeName)
                    return child;
                else {
                    let node = this.findNode(nodeName, child);
                    if (node)
                        return node;
                }
            }
            return null;
        }
        static RoundTableProbability(list, field) {
            let randomField = 0;
            Tools.forEachMap(list, (k, v) => {
                randomField += v[field];
            });
            let cursorField = 0;
            let point = Math.random() * randomField;
            let value = null;
            Tools.forEachMap(list, (k, v) => {
                if (point > cursorField && point <= cursorField + v[field]) {
                    value = list[k];
                    return true;
                }
                else {
                    cursorField += v[field];
                }
            });
            return value;
        }
        static encodePixelsData(pixels) {
            let data = this.compressArr(pixels);
            return Base64Plus.encodeArrayBuffer(data);
        }
        static encodeTexture(texture) {
            let pixels = texture.getPixels();
            let data = this.compressArr(pixels);
            return Base64Plus.encodeArrayBuffer(data);
        }
        static decodeTexture(value, width = 576, height = 1024) {
            let data = Base64Plus.decodeArrayBuffer(value);
            let pixels = this.decompressArr(new Uint8Array(data));
            let texture2d = new Laya.Texture2D(width, height, undefined, false);
            texture2d.setPixels(pixels);
            return texture2d;
        }
        static getMeshRender(node) {
            if (!node) {
                return null;
            }
            return node[`skinnedMeshRenderer`] || node[`meshRenderer`];
        }
        static randomGotArrayDatas(arr, expectNum) {
            if (!arr || arr.length <= 0 || !expectNum || expectNum <= 0) {
                return [];
            }
            let newArr = [];
            expectNum = Math.min(expectNum, arr.length);
            let indexArr = [];
            for (let i = 0; i < arr.length; i++) {
                indexArr.push(i);
            }
            let gotNum = 0;
            while (gotNum < expectNum) {
                let index = Mathf.random(0, indexArr.length - 1);
                let indexValue = indexArr[index];
                let data = arr[indexValue];
                newArr.push(data);
                indexArr.splice(index, 1);
                gotNum += 1;
            }
            return newArr;
        }
        static time() {
            return new Date().getTime() / 1000;
        }
    }
    Tools.timeScale = 1;

    let globalEventDis;
    class MsgHandler {
        constructor(eventTarget) {
            if (!globalEventDis)
                globalEventDis = new Laya.EventDispatcher();
            this._eventTarget = eventTarget || globalEventDis;
            this._registeredListeners = Object.create(null);
            this._startedListeners = Object.create(null);
            this._bStarted = false;
        }
        registerListeners(listeners) {
            for (let msgName in listeners) {
                if (this._registeredListeners[msgName] != null) {
                    console.log(`[警告] MsgHandler.registerListeners msg重复注册！ msgName=${msgName}`);
                }
                let listener = listeners[msgName];
                this._registeredListeners[msgName] = listener;
            }
            if (this._bStarted) {
                this.startProcMsg();
            }
        }
        startProcMsg() {
            this._bStarted = true;
            for (const msgName in this._registeredListeners) {
                if (!this._startedListeners[msgName]) {
                    const listener = this._registeredListeners[msgName];
                    this._eventTarget.on(msgName, this, listener);
                    this._startedListeners[msgName] = listener;
                }
            }
        }
        stopProcMsg() {
            for (const msgName in this._startedListeners) {
                let listener = this._startedListeners[msgName];
                this._eventTarget.off(msgName, this, listener);
            }
            this._bStarted = false;
            this._startedListeners = Object.create(null);
        }
        sendMsg(msgName, data) {
            try {
                this._eventTarget.event(msgName, data);
            }
            catch (error) {
                Logger.catchError(`MsgHandler.sendMsg:${msgName}`, error);
            }
        }
        sendMsgWithArray(msgName, arrData) {
            try {
                this._eventTarget.event(msgName, [arrData]);
            }
            catch (error) {
                Logger.catchError(`MsgHandler.sendMsgWithArray:${msgName}`, error);
            }
        }
        static registerListeners(caller, listeners) {
            Tools.forEachMap(listeners, (k, listener) => {
                listeners[k] = listener.bind(caller);
            });
            let handler;
            for (let i = 0; i < this.globalHandlers.length; i++) {
                const element = this.globalHandlers[i];
                if (element.caller == caller) {
                    handler = element.handler;
                    break;
                }
            }
            if (!handler) {
                handler = new MsgHandler;
                handler.startProcMsg();
                this.globalHandlers.push({
                    handler: handler,
                    caller: caller,
                });
            }
            handler.registerListeners(listeners);
        }
        static sendMsg(msgName, data) {
            for (let i = this.globalHandlers.length - 1; i >= 0; i--) {
                const element = this.globalHandlers[i];
                if (element.caller.destroyed || (element.caller.owner && element.caller.owner.destroyed)) {
                    element.handler.stopProcMsg();
                    this.globalHandlers.splice(i, 1);
                }
            }
            if (this.globalHandlers.length > 0) {
                this.globalHandlers[0].handler.sendMsg(msgName, data);
            }
        }
    }
    MsgHandler.globalHandlers = [];

    class Queue {
        constructor(max = 128, autoGrow = true) {
            this.autoGrow = true;
            this.autoGrow = autoGrow;
            this.maxLen = max;
            this.tail = 0;
            this.head = 0;
            this.count = 0;
            this.queue = new Array(max);
        }
        get size() {
            return this.count;
        }
        get max() {
            return this.maxLen;
        }
        enqueue(obj) {
            if (this.autoGrow) {
                if (this.count >= this.maxLen - 1) {
                    this.grow();
                }
            }
            else {
                if (this.count >= this.maxLen) {
                    return false;
                }
            }
            this.queue[this.tail] = obj;
            this.tail = ++this.tail % this.maxLen;
            this.count++;
            return true;
        }
        dequeue() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.queue[this.head];
            this.queue[this.head] = null;
            this.head = ++this.head % this.maxLen;
            this.count--;
            return t;
        }
        peek() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.queue[this.head];
            return t;
        }
        grow() {
            let newLen = this.maxLen + (this.maxLen >> 1);
            this.maxLen = this.hugeLen(newLen);
            let newQueue = new Array(this.maxLen);
            if (this.count > 0) {
                if (this.head < this.tail) {
                    Tools.arrayCopy(this.queue, this.head, newQueue, 0, this.count);
                }
                else {
                    Tools.arrayCopy(this.queue, this.head, newQueue, 0, this.queue.length - this.head);
                    Tools.arrayCopy(this.queue, 0, newQueue, this.queue.length - this.head, this.tail);
                }
            }
            this.queue = newQueue;
            this.head = 0;
            this.tail = ((this.count == this.maxLen) ? 0 : this.count);
        }
        hugeLen(len) {
            if (len < 0)
                throw "Queue.hugeLen: OutOfMemoryError";
            return len > Queue.MAX_ARRAY_SIZE ? Queue.MAX_ARRAY_SIZE : len;
        }
        clear() {
            this.tail = 0;
            this.head = 0;
            this.count = 0;
            this.queue = new Array(this.queue.length);
        }
        reset() {
            this.tail = 0;
            this.head = 0;
            this.count = 0;
        }
        indexOf(idx) {
            if (idx < 0 || idx >= this.count)
                return null;
            let t = this.queue[(this.head + idx) % this.maxLen];
            return t;
        }
        contains(obj) {
            for (let i = 0; i < this.count; i++) {
                if (obj == this.indexOf(i))
                    return true;
            }
            return false;
        }
    }
    Queue.MAX_ARRAY_SIZE = Number.MAX_VALUE - 8;

    const KEY_POOL_ID = "__pool_id";
    const KEY_POOL_KEY = "__pool_key";
    const KEY_FLAG_IN_POOL = "__pool_flag_inpool";
    class PoolStack {
        constructor() {
            this.m_queue = new Queue(16, true);
            this.m_referenceCount = 0;
        }
        get length() {
            return this.m_queue.size;
        }
        push(t) {
            this.m_queue.enqueue(t);
        }
        pop() {
            return this.m_queue.dequeue();
        }
        retain() {
            this.m_referenceCount++;
        }
        release() {
            this.m_referenceCount--;
        }
        get referenceCount() {
            return this.m_referenceCount;
        }
        get totalCount() {
            return this.m_referenceCount + this.m_queue.size;
        }
    }
    class PoolManager {
        constructor() {
            this.pools = [];
            this.poolConfigs = [];
        }
        _getPool(poolId, poolKey) {
            let group = this.pools[poolId];
            if (!group) {
                group = {};
                this.pools[poolId] = group;
            }
            let pool = group[poolKey];
            if (!pool) {
                pool = new PoolStack();
                group[poolKey] = pool;
            }
            return pool;
        }
        register(reuseClass, maxCount = 1000, overload = true) {
            if (reuseClass[KEY_POOL_ID]) {
                let cnf = this.poolConfigs[reuseClass[KEY_POOL_ID]];
                if (cnf.reuseClass === reuseClass) {
                    Logger.error("PoolManager.register class is registed.", reuseClass);
                    return;
                }
            }
            let cnf = {
                reuseClass: reuseClass,
                maxCount: maxCount,
                bOverload: overload,
            };
            reuseClass[KEY_POOL_ID] = this.poolConfigs.length;
            this.poolConfigs.push(cnf);
        }
        get(reuseClass, poolKey) {
            let poolId = reuseClass[KEY_POOL_ID];
            if (poolId == undefined) {
                Logger.debug("PoolManager.get class is not register.", reuseClass.name);
                this.register(reuseClass);
                return this.get(reuseClass, poolKey);
            }
            let config = this.poolConfigs[poolId];
            if (!config) {
                Logger.warn(`"PoolManager.get config not found! poolId = ${poolId}"`);
                return;
            }
            if (poolKey == null)
                poolKey = "__default_pool_key__";
            let pool = this._getPool(poolId, poolKey);
            let node = pool.pop();
            if (!node) {
                if (!config.bOverload) {
                    if (pool.totalCount >= config.maxCount) {
                        return null;
                    }
                }
                node = new reuseClass(poolKey);
                node[KEY_POOL_ID] = poolId;
                node[KEY_POOL_KEY] = poolKey;
            }
            pool.retain();
            node.reuse();
            node[KEY_FLAG_IN_POOL] = false;
            return node;
        }
        put(reuseNode) {
            if (!reuseNode) {
                Logger.warn("PoolManager.put node is nil!");
                return false;
            }
            let poolId = reuseNode[KEY_POOL_ID];
            let poolKey = reuseNode[KEY_POOL_KEY];
            if (poolId == undefined) {
                Logger.warn("PoolManager.put obj[KEY_POOL_ID] not found!");
                return false;
            }
            if (!poolKey) {
                Logger.warn("PoolManager.put obj[KEY_POOL_KEY] not found!");
                return false;
            }
            let config = this.poolConfigs[poolId];
            if (!config) {
                Logger.warn(`PoolManager.put config not found! poolId:[${poolId}] key:[${poolKey}]`);
                return false;
            }
            if (reuseNode[KEY_FLAG_IN_POOL]) {
                Logger.warn(`PoolManager.put obj is already in pool! [${poolId}] key:[${poolKey}]`);
                return false;
            }
            reuseNode.unuse();
            let pool = this._getPool(poolId, poolKey);
            if (pool.length < config.maxCount) {
                reuseNode[KEY_FLAG_IN_POOL] = true;
                pool.push(reuseNode);
            }
            else {
                Logger.warn(`PoolManager.put pool:[${poolId}] key:[${poolKey}] is full!`);
                reuseNode.dispose();
            }
            pool.release();
            return true;
        }
        clean(reuseClass, poolKey) {
            let poolId = reuseClass[KEY_POOL_ID];
            for (const pid in this.pools) {
                if (poolId != null || poolId == pid) {
                    const pools = this.pools[pid];
                    for (const key in pools) {
                        if (!poolKey || poolKey == key) {
                            const pool = pools[key];
                            let len = pool.length;
                            for (let i = 0; i < len; i++) {
                                const node = pool.pop();
                                node.dispose();
                            }
                        }
                    }
                }
            }
        }
        debugInfo() {
            console.log("\n------ debug PoolManager ------");
            for (const pid in this.pools) {
                const pools = this.pools[pid];
                for (const key in pools) {
                    const pool = pools[key];
                    const config = this.poolConfigs[pid];
                    console.log(`pool:${pid}    class:${config.reuseClass.name}    key:${key}    cached:${pool.length}    used:${pool.referenceCount}`);
                }
            }
            console.log("\n------ debug pool class info ------");
        }
        debugClassId() {
            for (let i = 0; i < this.poolConfigs.length; i++) {
                let cnf = this.poolConfigs[i];
                let classStr = cnf.reuseClass.toString();
                let p0 = classStr.indexOf("{");
                if (p0 && p0 > 9) {
                    classStr = classStr.substring(9, p0);
                }
                console.log(`class:${classStr}    name:${cnf.reuseClass.name}    poolId:${cnf.reuseClass[KEY_POOL_ID]}`);
            }
        }
    }

    class Stack {
        constructor(max = 128, autoGrow = true) {
            this.autoGrow = true;
            this.autoGrow = autoGrow;
            this.count = 0;
            this.stack = new Array(max);
        }
        get size() {
            return this.count;
        }
        push(obj) {
            if (!this.autoGrow) {
                if (this.count >= this.stack.length) {
                    return false;
                }
            }
            this.stack[this.count++] = obj;
            return true;
        }
        pop() {
            if (this.count <= 0) {
                return null;
            }
            let t = this.stack[--this.count];
            this.stack[this.count] = null;
            return t;
        }
        peek() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.stack[this.count - 1];
            return t;
        }
        clear() {
            this.count = 0;
            this.stack = new Array(this.stack.length);
        }
        reset() {
            this.count = 0;
        }
        indexOf(idx) {
            if (idx < 0 || idx >= this.count)
                return null;
            return this.stack[idx];
        }
        contains(obj) {
            for (let i = 0; i < this.count; i++) {
                if (obj == this.stack[i])
                    return true;
            }
            return false;
        }
    }

    const KEY_POOL_ID$1 = "__pool_id2";
    const KEY_FLAG_IN_POOL$1 = "__pool_flag_inpool";
    class Pool {
        constructor() {
            this._pools = [];
            this._classNames = [];
            this._key2id = Object.create(null);
        }
        get(poolClass) {
            let idx = poolClass[KEY_POOL_ID$1];
            if (idx == null) {
                idx = this._pools.length;
                poolClass[KEY_POOL_ID$1] = idx;
                this._classNames.push(poolClass.name || "unkown");
                this._pools.push(new Stack(32, true));
            }
            let stack = this._pools[idx];
            let obj = stack.pop();
            if (!obj) {
                obj = new poolClass();
                obj[KEY_POOL_ID$1] = idx;
                return obj;
            }
            else {
                obj[KEY_FLAG_IN_POOL$1] = false;
                return obj;
            }
        }
        put(obj) {
            let idx = obj[KEY_POOL_ID$1];
            if (idx == null) {
                Logger.warn("Pool.put obj[KEY_POOL_ID] not found!");
                return;
            }
            if (obj[KEY_FLAG_IN_POOL$1]) {
                Logger.warn(`Pool.put obj is already in pool! [${idx}].`);
                return;
            }
            obj[KEY_FLAG_IN_POOL$1] = true;
            let stack = this._pools[idx];
            stack.push(obj);
        }
        getObject(key) {
            let idx = this._key2id[key];
            if (idx == null) {
                idx = this._pools.length;
                this._key2id[key] = idx;
                this._classNames.push(key);
                this._pools.push(new Stack(32, true));
            }
            let stack = this._pools[idx];
            let obj = stack.pop();
            if (!obj) {
                obj = Object.create(null);
                obj[KEY_POOL_ID$1] = idx;
                return obj;
            }
            else {
                obj[KEY_FLAG_IN_POOL$1] = false;
                return obj;
            }
        }
        debugInfo() {
            console.log("\n------ debug pools ------");
            for (let i = 0; i < this._pools.length; i++) {
                const pool = this._pools[i];
                console.log(`pool:${i}    name:${this._classNames[i]}    cached:${pool.size}`);
            }
            console.log("");
        }
    }

    var SDK_VERSIONS_VALUE;
    (function (SDK_VERSIONS_VALUE) {
        SDK_VERSIONS_VALUE["NONE"] = "None";
        SDK_VERSIONS_VALUE["V5"] = "V5";
        SDK_VERSIONS_VALUE["V6"] = "V6";
    })(SDK_VERSIONS_VALUE || (SDK_VERSIONS_VALUE = {}));
    class Global {
        static sendMsg(msgName, data) {
            MsgHandler.sendMsg(msgName, data);
        }
        static registerListeners(caller, listeners) {
            MsgHandler.registerListeners(caller, listeners);
        }
        static get canvasWidth() {
            return UIRoot.canvasWidth;
        }
        static get canvasHeight() {
            return UIRoot.canvasHeight;
        }
        static get canvasFitWidth() {
            return UIRoot.uiFitWidth;
        }
        static get canvasFitHeight() {
            return UIRoot.uiFitHeight;
        }
        static get top() {
            return UIRoot.uiFitTop;
        }
        static get bottom() {
            return this.canvasHeight - this.top;
        }
        static get left() {
            return UIRoot.uiFitLeft;
        }
        static get right() {
            return this.canvasWidth - this.left;
        }
        static get centerX() {
            return this.canvasWidth / 2;
        }
        static get centerY() {
            return this.canvasHeight / 2;
        }
    }
    Global.H5_TEST = false;
    Global.DEBUG = false;
    Global.GAME_ID = "115";
    Global.SDK_VERSION = SDK_VERSIONS_VALUE.NONE;
    Global.RECORD_VERSION = 2;
    Global.GAME_VERSION = "v1009.1200";
    Global.PATCH_VERSION = "0";
    Global.gameFrameRate = 50;
    Global.isGuiding = false;
    Global.poolManager = new PoolManager();
    Global.pool = new Pool();
    Global.FPS = 0;
    Global.EMPTY_FUN = function () { };
    Global.SDK_VERSION = SDK_VERSIONS_VALUE.V6;

    class GameGlobal {
    }
    GameGlobal.isDebug = false;
    GameGlobal.isRayTest = false;
    GameGlobal.DEBUG_CODE = "lrlrllrr";
    GameGlobal.MAIN_TASK_ID = "1";
    GameGlobal.hitPointLocal = new Laya.Vector3();
    GameGlobal.debugAI = false;

    class db {
        static setAllDbs(allDb) {
            this._allDbs = allDb;
        }
        static getDb(dbName) {
            let db = this._allDbs[dbName];
            if (!db) {
                console.error(`[警告] db.getDb db not found! dbName=[${dbName}]`);
            }
            return db;
        }
        static get_activity_config_db_map() {
            return this.getDb("activity_config_db");
        }
        static get_activity_config_db(id) {
            let data = this.get_activity_config_db_map()[id];
            if (data == null) {
                console.error(`can't find data in activity_config_db by id [${id}]`);
            }
            return data;
        }
        static get_adv_banner_int_db_map() {
            return this.getDb("adv_banner_int_db");
        }
        static get_adv_banner_int_db(advName) {
            let data = this.get_adv_banner_int_db_map()[advName];
            if (data == null) {
                console.error(`can't find data in adv_banner_int_db by advName [${advName}]`);
            }
            return data;
        }
        static get_adv_db_map() {
            return this.getDb("adv_db");
        }
        static get_adv_db(advName) {
            let data = this.get_adv_db_map()[advName];
            if (data == null) {
                console.error(`can't find data in adv_db by advName [${advName}]`);
            }
            return data;
        }
        static get_ad_banner_int_ui_db_map() {
            return this.getDb("ad_banner_int_ui_db");
        }
        static get_ad_banner_int_ui_db(viewName) {
            let data = this.get_ad_banner_int_ui_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ad_banner_int_ui_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_alert_dialog_db_map() {
            return this.getDb("alert_dialog_db");
        }
        static get_alert_dialog_db(key) {
            let data = this.get_alert_dialog_db_map()[key];
            if (data == null) {
                console.error(`can't find data in alert_dialog_db by key [${key}]`);
            }
            return data;
        }
        static get_auto_increase_db_map() {
            return this.getDb("auto_increase_db");
        }
        static get_auto_increase_db(itemId) {
            let data = this.get_auto_increase_db_map()[itemId];
            if (data == null) {
                console.error(`can't find data in auto_increase_db by itemId [${itemId}]`);
            }
            return data;
        }
        static get_block_db_map() {
            return this.getDb("block_db");
        }
        static get_block_db(id) {
            let data = this.get_block_db_map()[id];
            if (data == null) {
                console.error(`can't find data in block_db by id [${id}]`);
            }
            return data;
        }
        static get_block_group_map() {
            return this.getDb("block_group");
        }
        static get_block_group(id) {
            let data = this.get_block_group_map()[id];
            if (data == null) {
                console.error(`can't find data in block_group by id [${id}]`);
            }
            return data;
        }
        static get_dino_piece_db_map() {
            return this.getDb("dino_piece_db");
        }
        static get_dino_piece_db(id) {
            let data = this.get_dino_piece_db_map()[id];
            if (data == null) {
                console.error(`can't find data in dino_piece_db by id [${id}]`);
            }
            return data;
        }
        static get_dino_revive_db_map() {
            return this.getDb("dino_revive_db");
        }
        static get_dino_revive_db(id) {
            let data = this.get_dino_revive_db_map()[id];
            if (data == null) {
                console.error(`can't find data in dino_revive_db by id [${id}]`);
            }
            return data;
        }
        static get_effect_db_map() {
            return this.getDb("effect_db");
        }
        static get_effect_db(id) {
            let data = this.get_effect_db_map()[id];
            if (data == null) {
                console.error(`can't find data in effect_db by id [${id}]`);
            }
            return data;
        }
        static get_evo_food_map() {
            return this.getDb("evo_food");
        }
        static get_evo_food(id) {
            let data = this.get_evo_food_map()[id];
            if (data == null) {
                console.error(`can't find data in evo_food by id [${id}]`);
            }
            return data;
        }
        static get_fate_result_db_map() {
            return this.getDb("fate_result_db");
        }
        static get_fate_result_db(word1) {
            let data = this.get_fate_result_db_map()[word1];
            if (data == null) {
                console.error(`can't find data in fate_result_db by word1 [${word1}]`);
            }
            return data;
        }
        static get_guide_db_map() {
            return this.getDb("guide_db");
        }
        static get_guide_db(group, id) {
            let data = this.get_guide_db_map()[group][id];
            if (data == null) {
                console.error(`can't find data in guide_db by id [${id}]`);
            }
            return data;
        }
        static get_inner_cdk_db_map() {
            return this.getDb("inner_cdk_db");
        }
        static get_inner_cdk_db(key) {
            let data = this.get_inner_cdk_db_map()[key];
            if (data == null) {
                console.error(`can't find data in inner_cdk_db by key [${key}]`);
            }
            return data;
        }
        static get_item_add_sub_statis_db_map() {
            return this.getDb("item_add_sub_statis_db");
        }
        static get_item_add_sub_statis_db(index) {
            let data = this.get_item_add_sub_statis_db_map()[index];
            if (data == null) {
                console.error(`can't find data in item_add_sub_statis_db by index [${index}]`);
            }
            return data;
        }
        static get_item_db_map() {
            return this.getDb("item_db");
        }
        static get_item_db(id) {
            let data = this.get_item_db_map()[id];
            if (data == null) {
                console.error(`can't find data in item_db by id [${id}]`);
            }
            return data;
        }
        static get_jump_point_event_db_map() {
            return this.getDb("jump_point_event_db");
        }
        static get_jump_point_event_db(viewName) {
            let data = this.get_jump_point_event_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in jump_point_event_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_level_db_map() {
            return this.getDb("level_db");
        }
        static get_level_db(id) {
            let data = this.get_level_db_map()[id];
            if (data == null) {
                console.error(`can't find data in level_db by id [${id}]`);
            }
            return data;
        }
        static get_merge_ability_db_map() {
            return this.getDb("merge_ability_db");
        }
        static get_merge_ability_db(id) {
            let data = this.get_merge_ability_db_map()[id];
            if (data == null) {
                console.error(`can't find data in merge_ability_db by id [${id}]`);
            }
            return data;
        }
        static get_merge_item_db_map() {
            return this.getDb("merge_item_db");
        }
        static get_merge_item_db(id) {
            let data = this.get_merge_item_db_map()[id];
            if (data == null) {
                console.error(`can't find data in merge_item_db by id [${id}]`);
            }
            return data;
        }
        static get_merge_recipe_db_map() {
            return this.getDb("merge_recipe_db");
        }
        static get_merge_recipe_db(id) {
            let data = this.get_merge_recipe_db_map()[id];
            if (data == null) {
                console.error(`can't find data in merge_recipe_db by id [${id}]`);
            }
            return data;
        }
        static get_merge_skin_db_map() {
            return this.getDb("merge_skin_db");
        }
        static get_merge_skin_db(id) {
            let data = this.get_merge_skin_db_map()[id];
            if (data == null) {
                console.error(`can't find data in merge_skin_db by id [${id}]`);
            }
            return data;
        }
        static get_model_db_map() {
            return this.getDb("model_db");
        }
        static get_model_db(id) {
            let data = this.get_model_db_map()[id];
            if (data == null) {
                console.error(`can't find data in model_db by id [${id}]`);
            }
            return data;
        }
        static get_name_db_map() {
            return this.getDb("name_db");
        }
        static get_name_db(id) {
            let data = this.get_name_db_map()[id];
            if (data == null) {
                console.error(`can't find data in name_db by id [${id}]`);
            }
            return data;
        }
        static get_park_db_map() {
            return this.getDb("park_db");
        }
        static get_park_db(name) {
            let data = this.get_park_db_map()[name];
            if (data == null) {
                console.error(`can't find data in park_db by name [${name}]`);
            }
            return data;
        }
        static get_park_event_db_map() {
            return this.getDb("park_event_db");
        }
        static get_park_event_db(id) {
            let data = this.get_park_event_db_map()[id];
            if (data == null) {
                console.error(`can't find data in park_event_db by id [${id}]`);
            }
            return data;
        }
        static get_park_event_rule_db_map() {
            return this.getDb("park_event_rule_db");
        }
        static get_park_event_rule_db(id) {
            let data = this.get_park_event_rule_db_map()[id];
            if (data == null) {
                console.error(`can't find data in park_event_rule_db by id [${id}]`);
            }
            return data;
        }
        static get_pay_db_map() {
            return this.getDb("pay_db");
        }
        static get_pay_db(id) {
            let data = this.get_pay_db_map()[id];
            if (data == null) {
                console.error(`can't find data in pay_db by id [${id}]`);
            }
            return data;
        }
        static get_random_name_db_arr() {
            return this.getDb("random_name_db");
        }
        static get_random_name_db(word1) {
            let data = this.get_random_name_db_arr()[word1];
            if (data == null) {
                console.error(`can't find data in random_name_db by word1 [${word1}]`);
            }
            return data;
        }
        static get_random_name_girl_part0_db_map() {
            return this.getDb("random_name_girl_part0_db");
        }
        static get_random_name_girl_part0_db(word) {
            let data = this.get_random_name_girl_part0_db_map()[word];
            if (data == null) {
                console.error(`can't find data in random_name_girl_part0_db by word [${word}]`);
            }
            return data;
        }
        static get_random_name_girl_part1_db_map() {
            return this.getDb("random_name_girl_part1_db");
        }
        static get_random_name_girl_part1_db(word) {
            let data = this.get_random_name_girl_part1_db_map()[word];
            if (data == null) {
                console.error(`can't find data in random_name_girl_part1_db by word [${word}]`);
            }
            return data;
        }
        static get_random_name_girl_part2_db_map() {
            return this.getDb("random_name_girl_part2_db");
        }
        static get_random_name_girl_part2_db(word) {
            let data = this.get_random_name_girl_part2_db_map()[word];
            if (data == null) {
                console.error(`can't find data in random_name_girl_part2_db by word [${word}]`);
            }
            return data;
        }
        static get_random_tip_db_map() {
            return this.getDb("random_tip_db");
        }
        static get_random_tip_db(word1) {
            let data = this.get_random_tip_db_map()[word1];
            if (data == null) {
                console.error(`can't find data in random_tip_db by word1 [${word1}]`);
            }
            return data;
        }
        static get_reward_db_map() {
            return this.getDb("reward_db");
        }
        static get_reward_db(id, idx) {
            let data = this.get_reward_db_map()[id][idx];
            if (data == null) {
                console.error(`can't find data in reward_db by idx [${idx}]`);
            }
            return data;
        }
        static get_shop_buy_db_map() {
            return this.getDb("shop_buy_db");
        }
        static get_shop_buy_db(id) {
            let data = this.get_shop_buy_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_buy_db by id [${id}]`);
            }
            return data;
        }
        static get_shop_db_map() {
            return this.getDb("shop_db");
        }
        static get_shop_db(id) {
            let data = this.get_shop_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_db by id [${id}]`);
            }
            return data;
        }
        static get_sign_db_arr() {
            return this.getDb("sign_db");
        }
        static get_sign_db(idx) {
            let data = this.get_sign_db_arr()[idx];
            if (data == null) {
                console.error(`can't find data in sign_db by idx [${idx}]`);
            }
            return data;
        }
        static get_skin_anim_map() {
            return this.getDb("skin_anim");
        }
        static get_skin_anim(id) {
            let data = this.get_skin_anim_map()[id];
            if (data == null) {
                console.error(`can't find data in skin_anim by id [${id}]`);
            }
            return data;
        }
        static get_skin_db_map() {
            return this.getDb("skin_db");
        }
        static get_skin_db(id) {
            let data = this.get_skin_db_map()[id];
            if (data == null) {
                console.error(`can't find data in skin_db by id [${id}]`);
            }
            return data;
        }
        static get_skin_default_map() {
            return this.getDb("skin_default");
        }
        static get_skin_default(type) {
            let data = this.get_skin_default_map()[type];
            if (data == null) {
                console.error(`can't find data in skin_default by type [${type}]`);
            }
            return data;
        }
        static get_skin_speed_map() {
            return this.getDb("skin_speed");
        }
        static get_skin_speed(id) {
            let data = this.get_skin_speed_map()[id];
            if (data == null) {
                console.error(`can't find data in skin_speed by id [${id}]`);
            }
            return data;
        }
        static get_sound_db_map() {
            return this.getDb("sound_db");
        }
        static get_sound_db(id) {
            let data = this.get_sound_db_map()[id];
            if (data == null) {
                console.error(`can't find data in sound_db by id [${id}]`);
            }
            return data;
        }
        static get_spine_db_map() {
            return this.getDb("spine_db");
        }
        static get_spine_db(id) {
            let data = this.get_spine_db_map()[id];
            if (data == null) {
                console.error(`can't find data in spine_db by id [${id}]`);
            }
            return data;
        }
        static get_statis_db_map() {
            return this.getDb("statis_db");
        }
        static get_statis_db(name) {
            let data = this.get_statis_db_map()[name];
            if (data == null) {
                console.error(`can't find data in statis_db by name [${name}]`);
            }
            return data;
        }
        static get_statue_level_db_map() {
            return this.getDb("statue_level_db");
        }
        static get_statue_level_db(id) {
            let data = this.get_statue_level_db_map()[id];
            if (data == null) {
                console.error(`can't find data in statue_level_db by id [${id}]`);
            }
            return data;
        }
        static get_sub_cop_map() {
            return this.getDb("sub_cop");
        }
        static get_sub_cop(subCopKey) {
            let data = this.get_sub_cop_map()[subCopKey];
            if (data == null) {
                console.error(`can't find data in sub_cop by subCopKey [${subCopKey}]`);
            }
            return data;
        }
        static get_switch_db_map() {
            return this.getDb("switch_db");
        }
        static get_switch_db(id) {
            let data = this.get_switch_db_map()[id];
            if (data == null) {
                console.error(`can't find data in switch_db by id [${id}]`);
            }
            return data;
        }
        static get_tourist_db_map() {
            return this.getDb("tourist_db");
        }
        static get_tourist_db(id) {
            let data = this.get_tourist_db_map()[id];
            if (data == null) {
                console.error(`can't find data in tourist_db by id [${id}]`);
            }
            return data;
        }
        static get_tourist_num_db_map() {
            return this.getDb("tourist_num_db");
        }
        static get_tourist_num_db(id) {
            let data = this.get_tourist_num_db_map()[id];
            if (data == null) {
                console.error(`can't find data in tourist_num_db by id [${id}]`);
            }
            return data;
        }
        static get_ui_statis_button_db_map() {
            return this.getDb("ui_statis_button_db");
        }
        static get_ui_statis_button_db(viewName) {
            let data = this.get_ui_statis_button_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ui_statis_button_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_ui_statis_duration_db_map() {
            return this.getDb("ui_statis_duration_db");
        }
        static get_ui_statis_duration_db(viewName) {
            let data = this.get_ui_statis_duration_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ui_statis_duration_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_view_method_call_point_event_db_map() {
            return this.getDb("view_method_call_point_event_db");
        }
        static get_view_method_call_point_event_db(panelName, index) {
            let data = this.get_view_method_call_point_event_db_map()[panelName][index];
            if (data == null) {
                console.error(`can't find data in view_method_call_point_event_db by index [${index}]`);
            }
            return data;
        }
        static get_wheel_db_map() {
            return this.getDb("wheel_db");
        }
        static get_wheel_db(id) {
            let data = this.get_wheel_db_map()[id];
            if (data == null) {
                console.error(`can't find data in wheel_db by id [${id}]`);
            }
            return data;
        }
    }
    db.ACTIVITY_CONFIG_DB_ID = {
        1: "1",
        2: "2",
        3: "3",
        4: "4",
        5: "5",
    };
    db.ADV_DB_ADVNAME = {
        free_gold: "free_gold",
        game_revive: "game_revive",
        ad_skin_shop: "ad_skin_shop",
        ad_skin_try: "ad_skin_try",
        wheel: "wheel",
        more_coin: "more_coin",
        three_reward: "three_reward",
        get_skin: "get_skin",
        free_vit: "free_vit",
        skip_level: "skip_level",
        merge_skin: "merge_skin",
        merge_skin_unlock: "merge_skin_unlock",
        get_merge_item: "get_merge_item",
        evolution_food: "evolution_food",
        luck_coin: "luck_coin",
        one_key_in: "one_key_in",
        rabbit_skin_try: "rabbit_skin_try",
        limit_skin_unlock: "limit_skin_unlock",
        interact_feeding: "interact_feeding",
        interact_wash: "interact_wash",
        interact_fight: "interact_fight",
        ad_unlock_park: "ad_unlock_park",
        upgrade_park: "upgrade_park",
        auto_get_tourist_reward: "auto_get_tourist_reward",
        free_hatch_egg: "free_hatch_egg",
        double_tourist_num: "double_tourist_num",
        open_game_ad: "open_game_ad",
    };
    db.ALERT_DIALOG_DB_KEY = {
        wheel: "wheel",
    };
    db.cop_db = {
        ad_interstitial_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_banner_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_embedded_ratios: [],
        ad_video_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100],
        ad_video_cds: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_video_counts: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_inst_cd: 0.5,
        ad_banner_refresh_cd: 10,
        ad_btn_mode: 0,
        b_inst_or_banner: 0,
        native_insert_mode: 1,
        b_banner_in_guide: 0,
        b_inst_in_guide: 0,
        some_function: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        b_open_statics_item: 0,
        url_notice: "",
        b_open_follow: 0,
        gold_rain_ratios: [0, 0],
        gold_rain_count: 10,
        gold_rain_cd: 10,
        isShowMergeBtn: 1,
        banner_confiom_ratio: [0, 0, 0, 0, 0, 0],
        banner_confiom_close_time: [0, 0, 0, 0, 0, 0],
        banner_confiom_banner_time: [0, 0, 0, 0, 0, 0],
        progress_end_count: 0,
        gray_mode_switch: [0, 0],
        gray_first_not_gou_time: [1, 1],
        gray_gou_time: [2, 2],
        gray_not_gou_time: [2, 2],
        gray_mode_btn_style_switch: [0, 0],
        ban_alert_revive: 0,
        b_alert_hutui_switch: 0,
        not_alert_hutui_time: 0,
        alert_hutui_cd: 0,
        grid_ad_switch: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        grid_hot_game: [0, 0, 0, 0, 0, 0],
        show_to_park_level: 10,
        op_see_ad_btn_switch: [0, 0, 0, 0],
        share_mode: [0, 0, 0, 0, 0, 0, 0, 0, 0],
        share_close_delta_time: 0,
        isItemGetShareFirst: 0,
        video_share_mode: 0,
        video_share_delay_time: 0,
        video_ad_close_button: 0,
        video_ad_close_delay: 2,
        check_mode: 0,
        video_tag_switchs: [100, 100, 100, 100, 100, 100, 100, 100, 100],
        video_touch_range_modes: [0, 0, 0, 0, 0, 0, 0, 0],
        video_close_alerp_switchs: [0, 0, 0, 0, 0, 0],
        video_failed_retry_mode: 0,
        jump_single_switchs: [],
        jump_banner_switchs: [],
        jump_banner_vertical_switchs: [],
        jump_left_switchs: [],
        b_open_friend_game: 0,
        douyin_follow_switch: 0,
        ad_flag_style: 0,
        s_kefu_text: "",
        ad_h5: [0],
        check_mode_cd: 0,
        b_show_skin_phl: 1,
        show_invite_ratio: 0,
        b_open_advancedSetting: 0,
        b_show_probability_publicit: 0,
        isThirdExit: false,
        isAbout: false,
        isShareEnabled: false,
        isPayEnabled: false,
        isULMoreGame: false,
        isUseSdkRank: false,
        isWebView: false,
        isShowUrlAdIcon: false,
        isSupportRecordShare: false,
        isSupportInstallShortcut: false,
        isSupportFindMinigames: false,
        isSupportRecommendationBtn: false,
        is4399Watermark: false,
        isJumpLeisureEnabled: false,
        isSupportFollowOfficialAccount: false,
        isSupportFavoriteGuide: false,
        alert_dialog_ratios: [100],
        alert_dialog_cds: [0],
        b_video_share_finger: false,
        switch_button: 0,
        cost_vit: 1,
        merge_guide_ad: 0,
        preload_res: 0,
        mid_share: 0,
        jump_other_game_main: [0, 0],
        try_dialog_alert_mode: 1,
        dino_revive_ad: 0,
        coin_crit_ratio: 100,
        coin_crit_cd: 10,
        luck_coin_cd: 10,
        skin_try_switch: 0,
        mid_autumn_festival_version_switch: 0,
        b_open_skin_activity: true,
        b_show_age_tip: 0,
        ageLevelInfo: "适龄提示内容",
        more_game_box_switch: [0, 0, 0, 0, 0, 0, 0],
        more_game_box_ratio: 0,
        more_game_box_cd: 0,
        b_open_privacy: 0,
        delay_banner_names: ["PanelTry"],
        delay_banner_switchs: [0],
        delay_banner_first_cds: [0],
        delay_banner_cds: [0],
        delay_banner_ratios: [0],
        delay_banner_category_cds: [0],
        open_main_one_panelAd: 0,
        open_main_panelAd: 0,
        b_douyin_switch: false,
    };
    db.game_cnf = {
        scene_game: "res/_unity/Conventional/scene_game.ls",
        scene_front: "res/_unity/Conventional/scene_front.ls",
        scene_park: "res/_unity/Conventional/scene_park.ls",
        revive_time: 3,
        skin_unlock_step: 3,
        ad_add_coin: 500,
        ad_add_vit: 6,
        mini_ready_time: 3,
        mini_game_time: 2,
        speed_run: 8,
        speed_clash: 14,
        speed_fly: 8,
        speed_moor: 8,
        speed_swim: 8,
        speed_climb: 8,
        speed_fight: 14,
        speed_gorilla: 8,
        speed_trunk: 10,
        speed_spider: 8,
        speed_back: -20,
        speed_jump: 10,
        speed_skill: 10,
        speed_fall: 4,
        speed_charge_add: 1,
        speed_charge_init: 8,
        speed_charge: 17,
        speed_charge_ready: 0.5,
        speed_charge_sub_time: 0.1,
        speed_charge_sub: 0.2,
        energy_cost_charge: 2,
        time_add_charge_perfect: 4.3,
        ai_clever_min: 8,
        ai_clever_max: 20,
        ad_wheel_reward_count: 3,
        speed_correct_add: 0.1,
        speed_correct_max: 1.5,
        rank_num: 10,
        rank_interval: 3600,
        rank_reset_time: 17,
        dino_income_interval: 10,
        interact_feeding_count: 3,
        interact_wash_count: 3,
        interact_fight_count: 3,
        clean_buff_duration: 99,
        feed_buff_duration: 99,
        clean_duration: 7200,
        feed_duration: 7200,
        business_time: 5,
    };
    db.PARK_EVENT_DB_ID = {
        1: "1",
        2: "2",
        3: "3",
        4: "4",
    };
    db.PARK_EVENT_RULE_DB_ID = {
        1: "1",
    };
    db.STATIS_DB_NAME = {
        share_level: "share_level",
        share_luck: "share_luck",
        coin_change_vit: "coin_change_vit",
        ui_load: "ui_load",
        ui_main: "ui_main",
        ui_luck: "ui_luck",
        ui_collect: "ui_collect",
        ui_common: "ui_common",
        ui_load_game: "ui_load_game",
        ui_game: "ui_game",
        ui_game_template: "ui_game_template",
        ui_game_bucket: "ui_game_bucket",
        ui_game_material: "ui_game_material",
        ui_game_shape: "ui_game_shape",
        ui_game_skin: "ui_game_skin",
        ui_game_prepare: "ui_game_prepare",
        ui_game_fire: "ui_game_fire",
        ui_game_play: "ui_game_play",
        ui_share: "ui_share",
        ui_over: "ui_over",
        ui_luck_ad: "ui_luck_ad",
        ui_luck_result: "ui_luck_result",
        ui_item_get: "ui_item_get",
        ui_collect_game: "ui_collect_game",
        ui_egg_begin: "ui_egg_begin",
        ui_egg: "ui_egg",
        ui_item_get_egg: "ui_item_get_egg",
        ui_draw: "ui_draw",
        ui_map: "ui_map",
        ui_meet: "ui_meet",
        ui_theme: "ui_theme",
        guide_total: "guide_total",
        guide_1: "guide_1",
        guide_2: "guide_2",
        guide_3: "guide_3",
        guide_4: "guide_4",
        guide_5: "guide_5",
        guide_6: "guide_6",
        guide_7: "guide_7",
        guide_8: "guide_8",
        guide_9: "guide_9",
        guide_10: "guide_10",
        guide_11: "guide_11",
        guide_12: "guide_12",
        guide_13: "guide_13",
        guide_14: "guide_14",
        guide_15: "guide_15",
        guide_16: "guide_16",
        guide_17: "guide_17",
        guide_18: "guide_18",
        guide_19: "guide_19",
        level_min: "level_min",
        level_freestyle: "level_freestyle",
        level_play: "level_play",
        level_luck: "level_luck",
        level_draw: "level_draw",
        level_meet: "level_meet",
        level_theme: "level_theme",
        main_click_vit: "main_click_vit",
        main_click_set: "main_click_set",
        main_click_collect: "main_click_collect",
        main_click_luck: "main_click_luck",
        main_click_level_freestyle: "main_click_level_freestyle",
        main_click_level: "main_click_level",
        main_click_music: "main_click_music",
        main_click_sound: "main_click_sound",
        main_click_draw: "main_click_draw",
        main_click_meet: "main_click_meet",
        main_click_theme: "main_click_theme",
        collect_close: "collect_close",
        collect_make: "collect_make",
        collect_play: "collect_play",
        collect_collect: "collect_collect",
        collect_replace: "collect_replace",
        luck_click_close: "luck_click_close",
        luck_click_begin: "luck_click_begin",
        luck_click_money_item: "luck_click_money_item",
        luck_click_money_next: "luck_click_money_next",
        luck_click_anim_item: "luck_click_anim_item",
        luck_click_anin_next: "luck_click_anin_next",
        luck_click_firework: "luck_click_firework",
        luck_click_play: "luck_click_play",
        common_close: "common_close",
        game_back: "game_back",
        game_back_exit: "game_back_exit",
        game_back_stay: "game_back_stay",
        game_click_template: "game_click_template",
        game_click_template_next: "game_click_template_next",
        game_click_bucket: "game_click_bucket",
        game_click_bucket_next: "game_click_bucket_next",
        game_click_material: "game_click_material",
        game_click_material_next: "game_click_material_next",
        game_click_shape: "game_click_shape",
        game_click_shape_next: "game_click_shape_next",
        game_click_skin: "game_click_skin",
        game_click_skin_next: "game_click_skin_next",
        game_click_play: "game_click_play",
        share_close: "share_close",
        share_replay: "share_replay",
        share_share: "share_share",
        game_collect_close: "game_collect_close",
        game_collect_collect: "game_collect_collect",
        over_back: "over_back",
        over_next: "over_next",
        luck_ad_close: "luck_ad_close",
        luck_ad_check: "luck_ad_check",
        luck_result_close: "luck_result_close",
        luck_result_share: "luck_result_share",
        egg_begin_close: "egg_begin_close",
        egg_begin_ensure: "egg_begin_ensure",
        egg_show: "egg_show",
        egg_result: "egg_result",
        egg_close: "egg_close",
        egg_click: "egg_click",
        fu_dai_click: "fu_dai_click",
        fu_dai_code1: "fu_dai_code1",
        fu_dai_code2: "fu_dai_code2",
        fu_dai_code3: "fu_dai_code3",
        fu_dai_code4: "fu_dai_code4",
        fu_dai_code5: "fu_dai_code5",
        fu_dai_code6: "fu_dai_code6",
        fu_dai_code7: "fu_dai_code7",
        fu_dai_code8: "fu_dai_code8",
        fu_dai_code9: "fu_dai_code9",
        fu_dai_code10: "fu_dai_code10",
        draw_click_back: "draw_click_back",
        draw_click_next: "draw_click_next",
        draw_click_fire: "draw_click_fire",
        draw_click_reset: "draw_click_reset",
        meet_map_back: "meet_map_back",
        meet_map_enter: "meet_map_enter",
        meet_map_reward: "meet_map_reward",
        meet_place_back: "meet_place_back",
        meet_place_next: "meet_place_next",
        meet_palce_fire: "meet_palce_fire",
        theme_click_back: "theme_click_back",
        theme_click_play: "theme_click_play",
    };
    db.SUB_COP_SUBCOPKEY = {
        b_share: "b_share",
        b_jump_other_game: "b_jump_other_game",
        b_record_video: "b_record_video",
        b_cdk: "b_cdk",
        b_kefu_email: "b_kefu_email",
        b_more_game: "b_more_game",
        b_jump_other_game_banner: "b_jump_other_game_banner",
        for_ad_h5: "for_ad_h5",
        b_jump_other_game_left: "b_jump_other_game_left",
        b_reward_more_game: "b_reward_more_game",
        jump_icon_hub: "jump_icon_hub",
    };

    let _gameStartTime = 0;
    let _lastUpdateTime = 0;
    let _curTime = 0;
    let _time = 0;
    let _deltaTime = 0;
    let _timeFromGameStart = 0;
    let _timeOffset = 0;
    class Timer {
        constructor(span, repeatCount, callback, caller) {
            this._repeatCount = -1;
            this._span = 1;
            this._callback = null;
            this._count = 0;
            this._bRunning = false;
            this._span = span;
            this._repeatCount = repeatCount;
            this._callback = callback;
            this._caller = caller;
        }
        static get now() {
            return Date.now() / 1000;
        }
        static get time() {
            return _time + _timeOffset;
        }
        static get deltaTime() {
            return _deltaTime;
        }
        static get timeFromGameStart() {
            return _timeFromGameStart;
        }
        static waitTime(value) {
            return new Promise(function (resolve, reject) {
                Timer.callLater(value, function () {
                    resolve();
                });
            });
        }
        static setTimeOffset(offset) {
            _timeOffset = offset;
        }
        static initTime() {
            _gameStartTime = this.now;
            this.updateTime();
        }
        static updateTime() {
            _curTime = this.now;
            _time = _curTime;
            _timeFromGameStart = _curTime - _gameStartTime;
            _deltaTime = _curTime - _lastUpdateTime;
            _lastUpdateTime = _curTime;
        }
        static callLater(span, callback, caller) {
            let timer = new Timer(span, 1, callback, caller);
            timer.start();
            return timer;
        }
        static callLaterFrame(span, callback, caller) {
            let timer = new Timer(span, 1, callback, caller);
            timer.startFrame();
            return timer;
        }
        static callLoop(span, callback, caller) {
            let timer = new Timer(span, -1, callback, caller);
            timer.start(!caller);
            return timer;
        }
        static callLoopFrame(span, callback, caller) {
            let timer = new Timer(span, -1, callback, caller);
            timer.startFrame(!caller);
            return timer;
        }
        _onSpan() {
            this._count++;
            if (this._caller && !Tools.isNodeVaild(this._caller)) {
                this.stop();
                return;
            }
            if (this._callback) {
                try {
                    this._callback(this);
                }
                catch (error) {
                    Logger.error("[警告] Timer._onSpan callback has error", error);
                }
            }
            if (this._repeatCount >= 0 && this._count >= this._repeatCount) {
                this.stop();
            }
        }
        isRunning() {
            return this._bRunning;
        }
        get isDone() {
            return this._repeatCount >= 0 && this._count >= this._repeatCount;
        }
        get count() {
            return this._count;
        }
        get span() {
            return this._span;
        }
        start(bIgnoreForeverWarn = false) {
            this.stop();
            if (!this._callback) {
                Logger.warn("警告] Timer.start callback未设置！");
                return this;
            }
            if (!bIgnoreForeverWarn && this._repeatCount < 0) {
                Logger.warn("警告] Timer.start, this timer will never stop!");
                Logger.warn("警告]     please use startAndBindToNode");
                Logger.warn("警告]     or your can stop timer in callback. use e:stop()");
            }
            this._count = 0;
            Laya.timer.loop(this.span * 1000, this, this._onSpan);
            this._bRunning = true;
            return this;
        }
        startFrame(bIgnoreForeverWarn = false) {
            this.stop();
            if (!this._callback) {
                Logger.warn("警告] Timer.start callback未设置！");
                return this;
            }
            if (!bIgnoreForeverWarn && this._repeatCount < 0) {
                Logger.warn("警告] Timer.start, this timer will never stop!");
                Logger.warn("警告]     please use startAndBindToNode");
                Logger.warn("警告]     or your can stop timer in callback. use e:stop()");
            }
            this._count = 0;
            Laya.timer.frameLoop(this.span, this, this._onSpan);
            this._bRunning = true;
            return this;
        }
        resetCount() {
            this._count = 0;
        }
        stop() {
            if (this._bRunning) {
                Laya.timer.clear(this, this._onSpan);
                this._bRunning = false;
            }
            return this;
        }
    }

    const BASE_MSG = {
        VIEW_RESIZE: "VIEW_RESIZE",
        SYS_SHOW: "SYS_SHOW",
        SYS_HIDE: "SYS_HIDE",
        SYS_KEY_DOWN: "SYS_KEY_DOWN",
        SYS_KEY_UP: "SYS_KEY_UP",
        RES_LOAD_START: "RES_LOAD_START",
        RES_LOAD_PROGRESS: "RES_LOAD_PROGRESS",
        RES_LOAD_END: "RES_LOAD_END",
        CFG_LOAD_FINISH: "CFG_LOAD_FINISH",
        UI_SHOW_TIP: "UI_SHOW_TIP",
        SDK_EXIT_GAME: "SDK_EXIT_GAME",
        SDK_VIDEO_VISIBLE: "SDK_VIDEO_VISIBLE",
        SDK_SHARE_SUC: "SDK_SHARE_SUC",
        SDK_SHARE_FAIL: "SDK_SHARE_FAIL",
        SDK_LOGIN_STATE: "SDK_LOGIN_STATE",
        SDK_LOGIN_RESULT: "SDK_LOGIN_RESULT",
        SDK_INSTALL_SHORTCUT_SUC: "SDK_INSTALL_SHORTCUT_SUC",
        SDK_GET_SHORTCUT_STATE_SUC: "SDK_GET_SHORTCUT_STATE_SUC",
        SDK_COP_CHANGED: "SDK_COP_CHANGED",
        SDK_VIDEO_SHARE_SUC: "SDK_VIDEO_SHARE_SUC",
        SDK_VIDEO_SHARE_FAIL: "SDK_VIDEO_SHARE_FAIL",
        SDK_OPEN_JUMP_RESULT: "SDK_OPEN_JUMP_RESULT",
        SDK_JUMP_GAME_SUC: "SDK_JUMP_GAME_SUC",
        SDK_JUMP_GAME_REWARD: "SDK_JUMP_GAME_REWARD",
        SDK_FOLLOW_OFFICIAL_ACCOUNT_SUC: "SDK_FOLLOW_OFFICIAL_ACCOUNT_SUC",
        SDK_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_SUC: "SDK_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_SUC",
        SDK_CONTENT_CHECK_RESULT: "SDK_CONTENT_CHECK_RESULT",
        SDK_PRE_PAY: "SDK_PRE_PAY",
        SDK_ADD_ITEM: "SDK_ADD_ITEM",
        RECORD_GAME_VIDEO_RESULT: "RECORD_GAME_VIDEO_RESULT",
        SHARE_VIDEO_RESULT: "SHARE_VIDEO_RESULT",
        VIDEO_RECORDER_STATUS_CHANGED: "VIDEO_RECORDER_STATUS_CHANGED",
        ADV_SHOW_SUC: "ADV_SHOW_SUC",
        ADV_SHOW_FAIL: "ADV_SHOW_FAIL",
        ADV_CLICK_SUC: "ADV_CLICK_SUC",
        NATIVE_ADV_LOADED: "NATIVE_ADV_LOADED",
        ADV_CLOSE_NATIVE_BANNER: "ADV_CLOSE_NATIVE_BANNER",
        BASE_MGR_LOADED: "BASE_MGR_LOADED",
        PANEL_OPEN_COMPLETE: "PANEL_OPEN_COMPLETE",
        PANEL_CLOSE: "PANEL_CLOSE",
        PANEL_SHOW: "PANEL_SHOW",
        PANEL_HIDE: "PANEL_HIDE",
        UI_PANEL_CLOSED: "UI_PANEL_CLOSED",
        ITEM_CHANGE: "ITEM_CHANGE",
        ITEM_USE: "ITEM_USE",
        GOAL_STATE_CHANGE: "GOAL_STATE_CHANGE",
        DAILY_SWITCH_ACTIVE: "DAILY_SWITCH_ACTIVE",
        QUEST_STATE_CHANGE: "QUEST_STATE_CHANGE",
        UP_STATE_CHANGE: "UP_STATE_CHANGE",
        PAY_SUC: "PAY_SUC",
        SKIP_GUIDE: "SKIP_GUIDE",
    };
    const RES_TYPE = {
        BUFFER: Laya.Loader.BUFFER,
        PREFAB2D: Laya.Loader.PREFAB,
        IMAGE: Laya.Loader.IMAGE,
        TEXT: Laya.Loader.TEXT,
        JSON: Laya.Loader.JSON,
        SOUND: Laya.Loader.SOUND,
        ATLAS: Laya.Loader.ATLAS,
        PREFAB3D: Laya.Loader.HIERARCHY,
        MATERIAL: Laya.Loader.MATERIAL,
        TEXTURE2D: Laya.Loader.TEXTURE2D,
        MESH: Laya.Loader.MESH,
        ANIMATIONCLIP: Laya.Loader.ANIMATIONCLIP,
        TEXTURECUBE: Laya.Loader.TEXTURECUBE,
    };
    var GOAL_TYPE;
    (function (GOAL_TYPE) {
        GOAL_TYPE["QUEST"] = "QUEST";
        GOAL_TYPE["SWITCH"] = "SWITCH";
    })(GOAL_TYPE || (GOAL_TYPE = {}));
    const BASE_ACTION_ID = {
        ITEM_GET: "ITEM_GET",
        ITEM_USE: "ITEM_USE",
        PAY_SUC: "PAY_SUC",
        SHARE: "SHARE",
        LEVEL_UP: "LEVEL_UP",
        LEVEL_UP_KEY: "LEVEL_UP_KEY",
        LEVEL_UP_KEY_MAX: "LEVEL_UP_KEY_MAX",
        QUEST_FINISH: "QUEST_FINISH",
        QUEST_FINISH_COUNT: "QUEST_FINISH_COUNT",
        VIDEO_SHOW_SUC: "VIDEO_SHOW_SUC",
    };
    const BASE_SWITCH_ID = {
        DAILY: "1",
        WEEKLY: "2",
    };
    const UpAttrName = {
        Base: "baseUp",
    };

    class ResLoader {
        static tryLoadRes(url) {
            return Laya.loader.getRes(url);
        }
        static loadRes(url, type, completeCallback) {
            completeCallback = completeCallback || this.EMPTY_FUN;
            let resource = Laya.loader.getRes(url);
            if (resource != null) {
                completeCallback(resource);
                return;
            }
            if (this.loadingCallback[url]) {
                this.loadingCallback[url].calls.push(completeCallback);
                return;
            }
            else {
                this.loadingCallback[url] = { calls: [completeCallback], loadCount: 1 };
            }
            let loadCallback;
            loadCallback = (res) => {
                let callbacks = this.loadingCallback[url];
                if (callbacks) {
                    if (res) {
                        let calls = callbacks.calls;
                        delete this.loadingCallback[url];
                        for (let i = 0; i < calls.length; i++) {
                            calls[i](res);
                        }
                    }
                    else {
                        Logger.error(`mgrRes.loadRes load [${url}] err.`);
                        if (callbacks.loadCount <= this.retryCount) {
                            callbacks.loadCount++;
                            this._loadRes(url, type, loadCallback);
                        }
                        else {
                            let calls = callbacks.calls;
                            delete this.loadingCallback[url];
                            for (let i = 0; i < calls.length; i++) {
                                calls[i](null);
                            }
                        }
                    }
                }
                else {
                    Logger.warn("mgrRes loadCallback: No Loaded Callback Exists! ", url);
                }
            };
            this._loadRes(url, type, loadCallback);
        }
        static _loadRes(url, type, completeCallback) {
            let handler = Laya.Handler.create(this, function (res) {
                try {
                    completeCallback(res);
                }
                catch (error) {
                    Logger.catchError("mgrRes._loadRes complete", error);
                }
            });
            switch (type) {
                case RES_TYPE.PREFAB2D:
                case RES_TYPE.IMAGE:
                case RES_TYPE.TEXT:
                case RES_TYPE.JSON:
                case RES_TYPE.SOUND:
                case RES_TYPE.ATLAS:
                    Laya.loader.load(url, handler, null, type);
                    return;
                case RES_TYPE.PREFAB3D:
                case RES_TYPE.MATERIAL:
                case RES_TYPE.TEXTURE2D:
                case RES_TYPE.MESH:
                case RES_TYPE.ANIMATIONCLIP:
                case RES_TYPE.TEXTURECUBE:
                    Laya.loader.create(url, handler, null, type);
                    return;
                default:
                    Logger.error("未知资源类型:", type);
                    break;
            }
        }
        static loadImageFromWeb(url, onComplete) {
            if (!url) {
                onComplete(null);
                return;
            }
            if (this.webResCache[url]) {
                onComplete(this.webResCache[url]);
                return;
            }
            Logger.error("本方法暂未实现.");
        }
        static loadImage(url, callback) {
            this.loadRes(url, RES_TYPE.IMAGE, callback);
        }
        static loadText(url, callback) {
            this.loadRes(url, RES_TYPE.TEXT, callback);
        }
        static loadJson(url, callback) {
            this.loadRes(url, RES_TYPE.JSON, callback);
        }
        static loadTexture2D(url, callback) {
            this.loadRes(url, RES_TYPE.TEXTURE2D, callback);
        }
        static loadAnimationClip(url, callback) {
            this.loadRes(url, RES_TYPE.ANIMATIONCLIP, callback);
        }
        static loadTextureCube(url, callback) {
            this.loadRes(url, RES_TYPE.TEXTURECUBE, callback);
        }
        static loadSprite3D(url, callback) {
            this.loadRes(url, RES_TYPE.PREFAB3D, function (res) {
                if (callback) {
                    if (res) {
                        res = Laya.Sprite3D.instantiate(res);
                    }
                    callback(res);
                }
            });
        }
    }
    ResLoader.EMPTY_FUN = function () { };
    ResLoader.retryCount = 0;
    ResLoader.loadingCallback = {};
    ResLoader.webResCache = {};

    class TaskManager {
        constructor(taskName = "", bLog = Logger.isDebugLevel) {
            this.destroyed = false;
            this.isLoaded = false;
            this.isLoading = false;
            this.taskName = "";
            this.urls = [];
            this.urlData = { prefab: [], d3: [], d2: [] };
            this.calls = [];
            this.resStartTime = 0;
            this.callStartTime = 0;
            this.progressCallback = null;
            this.completeCallback = null;
            if (taskName) {
                this.taskName = `(${taskName})`;
            }
            this.bLog = bLog;
        }
        get resCount() {
            return this.urls.length;
        }
        get totalCallWeight() {
            let value = 0;
            for (var i = this.calls.length - 1; i >= 0; i--) {
                value += this.calls[i].weight;
            }
            return value;
        }
        dispose() {
            this.destroyed = true;
            this.urlData = null;
            this.urls = null;
            this.calls = null;
            this.completeCallback = null;
            this.progressCallback = null;
        }
        setLoadingCallback(completeCallback, progressCallback) {
            this.completeCallback = completeCallback;
            this.progressCallback = progressCallback || Global.EMPTY_FUN;
        }
        addRes(url, type = Laya.Loader.PREFAB) {
            if (!url)
                return;
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            if (this.bLog)
                Logger.log(`TaskManager${this.taskName} add:${url} ${type}`);
            let urlData = this.urls;
            if (url instanceof Array) {
                for (let i = 0; i < url.length; i++) {
                    let item = url[i];
                    if (typeof item == "string") {
                        urlData.push({ url: item, type: type });
                    }
                    else {
                        urlData.push(item);
                    }
                }
            }
            else {
                if (typeof url == "string") {
                    urlData.push({ url: url, type: type });
                }
                else {
                    urlData.push(url);
                }
            }
        }
        addFguiPackage(resKey) {
            this.addCall(function (resolve) {
                fgui.UIPackage.loadPackage(resKey, Laya.Handler.create(this, resolve));
            });
        }
        addCall(call, weight = 1) {
            this.calls.push({ fuc: call, weight: weight });
        }
        clearDuplicateRes() {
            let urls = this.urls;
            let resMap = Object.create(null);
            for (let i = urls.length - 1; i >= 0; i--) {
                let item = urls[i];
                if (Laya.loader.getRes(item.url)) {
                    urls.splice(i, 1);
                    continue;
                }
                if (resMap[item.url]) {
                    urls.splice(i, 1);
                }
                else {
                    resMap[item.url] = true;
                }
            }
        }
        classifyRes() {
            this.clearDuplicateRes();
            if (this.urlData.prefab.length > 0 || this.urlData.d2.length > 0 || this.urlData.d3.length > 0)
                return;
            let urls = this.urls;
            for (let i = urls.length - 1; i >= 0; i--) {
                let item = urls[i];
                switch (item.type) {
                    case RES_TYPE.PREFAB2D:
                        this.urlData.prefab.push(item);
                        break;
                    case RES_TYPE.IMAGE:
                    case RES_TYPE.TEXT:
                    case RES_TYPE.JSON:
                    case RES_TYPE.SOUND:
                    case RES_TYPE.ATLAS:
                    case RES_TYPE.BUFFER:
                        this.urlData.d2.push(item);
                        break;
                    case RES_TYPE.PREFAB3D:
                    case RES_TYPE.MATERIAL:
                    case RES_TYPE.TEXTURE2D:
                    case RES_TYPE.MESH:
                    case RES_TYPE.ANIMATIONCLIP:
                    case RES_TYPE.TEXTURECUBE:
                        this.urlData.d3.push(item);
                        break;
                    default:
                        urls.splice(i, 1);
                        Logger.error(`TaskManager${this.taskName}.classifyRes 未知资源类型:${item.type}`);
                        break;
                }
            }
        }
        get isEmpty() {
            return this.resCount == 0;
        }
        loadAll() {
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            this.isLoading = true;
            this.resStartTime = Timer.time;
            this.classifyRes();
            if (this.resCount == 0) {
                this.onResLoadComplete(true);
                return;
            }
            let countPrefab = this.urlData.prefab.length;
            let count2D = this.urlData.d2.length;
            let count3D = this.urlData.d3.length;
            let countTotal = countPrefab + count2D + count3D + this.totalCallWeight;
            let progressPrefab = 0;
            let progress2D = 0;
            let progress3D = 0;
            let completeState = 0;
            let bError = false;
            let calcProgress = () => {
                var progress = progressPrefab * countPrefab + progress2D * count2D + progress3D * count3D;
                this.onProgress(progress / countTotal);
            };
            let checkComplete = (suc) => {
                completeState++;
                if (!suc)
                    bError = true;
                if (completeState == 3) {
                    if (bError) {
                        this.onResLoadComplete(false);
                        Logger.error(`TaskManager${this.taskName} 资源加载错误.`);
                    }
                    else {
                        this.onResLoadComplete(true);
                    }
                }
            };
            this._loadPrefab(checkComplete, function (p) {
                progressPrefab = p;
                calcProgress();
            });
            this._load2d(checkComplete, function (p) {
                progress2D = p;
                calcProgress();
            });
            this._load3d(checkComplete, function (p) {
                progress3D = p;
                calcProgress();
            });
        }
        _loadPrefab(complete, progress, loadIndex = 0) {
            if (loadIndex < this.urlData.prefab.length) {
                let item = this.urlData.prefab[loadIndex++];
                let onAllLoaded = (res) => {
                    if (res) {
                        progress(loadIndex / this.urlData.prefab.length);
                        this._loadPrefab(complete, progress, loadIndex);
                    }
                    else {
                        this.onComplete(false);
                    }
                };
                let onPrefabLoaded = (prefab) => {
                    if (prefab) {
                        if (prefab.json && prefab.json.loadList && prefab.json.loadList.length > 0) {
                            Laya.loader.load(prefab.json.loadList, Laya.Handler.create(this, onAllLoaded));
                            return;
                        }
                        onAllLoaded(true);
                    }
                    else {
                        onAllLoaded(false);
                    }
                };
                Laya.loader.load(item.url, Laya.Handler.create(this, onPrefabLoaded), null, item.type);
            }
            else {
                complete(true);
            }
        }
        _load2d(complete, progress) {
            if (this.urlData.d2.length > 0) {
                Laya.loader.load(this.urlData.d2, Laya.Handler.create(this, complete), Laya.Handler.create(this, progress));
            }
            else {
                complete(true);
            }
        }
        _load3d(complete, progress) {
            if (this.urlData.d3.length > 0) {
                Laya.loader.create(this.urlData.d3, Laya.Handler.create(this, complete), Laya.Handler.create(this, progress));
            }
            else {
                complete(true);
            }
        }
        loadOneByOne(deltaTime = 1) {
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            this.isLoading = true;
            this.resStartTime = Timer.time;
            this.clearDuplicateRes();
            this._loadOneByOne(deltaTime * 1000);
        }
        _loadOneByOne(deltaTime) {
            if (this.destroyed)
                return;
            let urlData = this.urls.shift();
            if (urlData) {
                ResLoader.loadRes(urlData.url, urlData.type, (res) => {
                    if (res) {
                        Laya.timer.once(deltaTime, this, this._loadOneByOne, [deltaTime]);
                    }
                    else {
                        Logger.error(`TaskManager${this.taskName}.loadOneByOne error, url:${urlData.url}`);
                        this.onResLoadComplete(false);
                    }
                });
            }
            else {
                this.onResLoadComplete(true);
            }
        }
        onResLoadComplete(suc) {
            this.bLog && Logger.log(`TaskManager 资源加载结束:${suc}，耗时：${Mathf.round(Timer.time - this.resStartTime, 2)}`);
            if (suc) {
                this.bLog && Logger.log(`TaskManager${this.taskName} 开始执行call!`);
                this.callStartTime = Timer.time;
                this._processCalls();
            }
            else {
                this.onComplete(false);
            }
        }
        _processCalls(curCallIndex = 0) {
            this.curCallIndex = curCallIndex;
            if (curCallIndex >= this.calls.length) {
                this.onProgress(1);
                this.onComplete(true);
                return;
            }
            this.bLog && Logger.log(`TaskManager${this.taskName} 执行索引：`, curCallIndex);
            let curCompleteWeight = 0;
            for (var i = 0; i < curCallIndex; i++) {
                curCompleteWeight += this.calls[i].weight;
            }
            this.onProgress((curCompleteWeight + this.resCount) / (this.totalCallWeight + this.resCount));
            let callItem = this.calls[curCallIndex];
            try {
                let nextStep = () => {
                    Laya.timer.frameOnce(1, this, this._processCalls, [curCallIndex + 1]);
                };
                callItem.fuc(nextStep);
            }
            catch (error) {
                Logger.catchError(`TaskManager${this.taskName}._processCalls index:${curCallIndex}`, error);
                this.onComplete(false);
            }
        }
        setParent(loader) {
            if (this.parent) {
                Logger.warn(`TaskManager${this.taskName}.setParent: parent already exists.`);
            }
            this.parent = loader;
        }
        setCallProgress(percent) {
            if (this.curCallIndex < this.calls.length) {
                let curCompleteWeight = 0;
                for (var i = 0; i < this.curCallIndex; i++) {
                    curCompleteWeight += this.calls[i].weight;
                }
                curCompleteWeight += this.calls[this.curCallIndex].weight * percent;
                this.onProgress((curCompleteWeight + this.resCount) / (this.totalCallWeight + this.resCount));
            }
        }
        onProgress(percent) {
            if (this.progressCallback) {
                this.progressCallback(percent);
            }
            if (this.parent) {
                this.parent.setCallProgress(percent);
            }
            this.bLog && Logger.log(`TaskManager${this.taskName} 加载进度: [${Mathf.round(percent, 2)}]`);
        }
        onComplete(finish) {
            Logger.log(`TaskManager${this.taskName} 执行完成，耗时：${Mathf.round(Timer.time - this.callStartTime, 2)}`);
            Logger.log(`TaskManager${this.taskName} 总耗时：${Mathf.round(Timer.time - this.resStartTime, 2)}`);
            this.isLoaded = true;
            if (this.completeCallback) {
                try {
                    this.completeCallback(finish);
                }
                catch (error) {
                    Logger.catchError(`TaskManager${this.taskName}.onComplete[${finish}]`, error);
                }
            }
            this.dispose();
        }
    }

    class Manager {
        static loadAllManagers(finishCallback) {
            try {
                let tManager = new TaskManager("Manager");
                for (let i = 0; i < this._managerInstances.length; i++) {
                    let manager = this._managerInstances[i];
                    tManager.addCall((resolve) => {
                        manager.loadedCallback = () => {
                            resolve();
                        };
                        manager.onLoad();
                    });
                }
                tManager.setLoadingCallback(() => {
                    finishCallback();
                    this.startAllManagers();
                });
                tManager.loadAll();
            }
            catch (error) {
                console.warn("Manager.loadAllManager has error", error);
            }
        }
        static startAllManagers() {
            for (let i = 0; i < this._managerInstances.length; i++) {
                this._managerInstances[i].onStart();
            }
        }
        static checkRecord(data, dataDefault) {
            let needSave = false;
            for (let key in dataDefault) {
                let value = data[key];
                if (value == null) {
                    data[key] = dataDefault[key];
                    needSave = true;
                }
            }
            if (needSave) {
                this.saveRecord();
            }
        }
        static __init() {
            Manager._managerInstances.push(this);
        }
        static onLoad() {
            Global.registerListeners(this, {
                "MSG_RECORD_RESET": this.loadRecord,
            });
            if (!this._bNetworkResponseRegistered) {
                this._bNetworkResponseRegistered = true;
                this.onRegisterNetworkResponseListeners();
            }
            this.loadedCallback();
            this.loadRecord();
        }
        static onStart() {
        }
        static loadRecord() {
        }
        static saveRecord() {
        }
        static onRegisterNetworkResponseListeners() {
        }
    }
    Manager._managerInstances = [];
    Manager.loadedCallback = null;
    Manager._bNetworkResponseRegistered = false;

    const RECORD_DATA_KEY = "record_game" + Global.GAME_ID;
    const RECORD_AGE_KEY = "__age__";
    const RECORD_VERSION_KEY = "__version__";
    const RECORD_FILES_KEY = "__files__";
    class FileRecord {
        static init() {
            this._readRecord();
            Timer.callLoop(1, this._onTimerSpan.bind(this), true);
        }
        static _onTimerSpan(timer) {
            if (this.writeEnable && this.bNeedFlush) {
                this.bNeedFlush = false;
                this._writeRecord();
            }
        }
        static _readRecord(recordText) {
            if (!recordText) {
                recordText = Laya.LocalStorage.getItem(RECORD_DATA_KEY);
            }
            if (!recordText) {
                console.log("提示] FileRecord._readRecord 存档未找到！重置存档！");
                this.resetRecord();
                return;
            }
            let record = this._decodeData(recordText);
            if (!record) {
                console.warn("警告] FileRecord._readRecord 存档数据损坏！重置存档！");
                this.resetRecord();
                return;
            }
            if (record[RECORD_VERSION_KEY] != Global.RECORD_VERSION) {
                console.warn("警告] FileRecord._readRecord 存档版本改变！重置存档！");
                this.resetRecord();
                return;
            }
            this.record = record;
        }
        static _writeRecord() {
            let encodeText = this._encodeData(this.record);
            Laya.LocalStorage.setItem(RECORD_DATA_KEY, encodeText);
        }
        static markFlush() {
            this.bNeedFlush = true;
        }
        static flush() {
            this._writeRecord();
            this.bNeedFlush = false;
        }
        static _encodeData(data) {
            let jsonStr = JSON.stringify(data);
            if (this.compressEnable) {
                let compressStr = Tools.compress(jsonStr);
                let encodeStr = Base64.encode(compressStr);
                return encodeStr;
            }
            else {
                return jsonStr;
            }
        }
        static _decodeData(encodeStr) {
            try {
                if (this.compressEnable) {
                    let compressStr = Base64.decode(encodeStr);
                    let jsonStr = Tools.decompress(compressStr);
                    if (jsonStr) {
                        let data = JSON.parse(jsonStr);
                        return data;
                    }
                    else {
                        return null;
                    }
                }
                else {
                    return JSON.parse(encodeStr);
                }
            }
            catch (error) {
                Logger.catchError("FileRecord._decodeData", error);
            }
            return null;
        }
        static getData(key) {
            return this.record[key];
        }
        static setData(key, value) {
            this.record[key] = value;
            this.record[RECORD_AGE_KEY] = (this.record[RECORD_AGE_KEY] || 0) + 1;
            this.markFlush();
        }
        static resetRecord() {
            this.deletFileData();
            this.record = {};
            this.record[RECORD_AGE_KEY] = 0;
            this.record[RECORD_VERSION_KEY] = Global.RECORD_VERSION;
            this.record[RECORD_FILES_KEY] = {};
            this.markFlush();
            this.isNewRecord = true;
        }
        static deletAllData(clear = true) {
            this.deletFileData();
            if (clear) {
                this.record = {};
                this.record[RECORD_AGE_KEY] = 0;
            }
            this.record[RECORD_VERSION_KEY] = Global.RECORD_VERSION + 123698745;
            this.record[RECORD_FILES_KEY] = {};
            Laya.LocalStorage.removeItem(RECORD_DATA_KEY);
        }
        static deletFileData() {
            let record = this.record;
            if (record) {
                let files = record[RECORD_FILES_KEY];
                if (files) {
                    for (const file in files) {
                        Laya.LocalStorage.removeItem(file);
                    }
                }
            }
        }
        static setDataToFile(file, value, bEncode = true) {
            let files = this.getData(RECORD_FILES_KEY);
            files[file] = 1;
            this.setData(RECORD_FILES_KEY, files);
            Laya.LocalStorage.setItem(file, bEncode ? this._encodeData(value) : value);
        }
        static getDataFromFile(file, bDecode = true) {
            let dataStr = Laya.LocalStorage.getItem(file);
            if (dataStr) {
                return bDecode ? this._decodeData(dataStr) : dataStr;
            }
            else {
                return null;
            }
        }
    }
    FileRecord.record = {};
    FileRecord.bNeedFlush = false;
    FileRecord.writeEnable = true;
    FileRecord.isNewRecord = false;
    FileRecord.compressEnable = false;

    class Utils {
        static Clamp(t, e, i) {
            return Math.max(Math.min(t, Math.max(e, i)), Math.min(e, i));
        }
        static getV3_ZERO() {
            var t = Laya.Vector3['ZERO'];
            if (t == null) {
                t = Laya.Vector3['_ZERO'];
            }
            return t;
        }
        static getV3_UP() {
            var t = Laya.Vector3['Up'];
            if (t == null) {
                t = Laya.Vector3['_Up'];
            }
            return t;
        }
        static getTransformForward(t) {
            var e = t['forward'];
            if (e == null) {
                e = new Laya.Vector3();
                t['getForward'](e);
            }
            return e;
        }
        static getTransformRight(t) {
            var e = t['right'];
            if (e == null) {
                e = new Laya.Vector3();
                t['getRight'](e);
            }
            return e;
        }
        static getTransformUp(t) {
            var e = t['up'];
            if (e == null) {
                e = new Laya.Vector3();
                t['getUp'](e);
            }
            return e;
        }
        static findNodeByPath(node, path, debug) {
            var list = path.split("/");
            for (var i = 0; i < list.length; i++) {
                node = node.getChildByName(list[i]);
                if (node == null) {
                    console.log("findNodeByPath: Not found", list[i]);
                    return null;
                }
                if (debug) {
                    console.log("-->", list[i]);
                }
            }
            return node;
        }
        static findNodeByPathNoRoot(node, path, tag) {
            var list = path.split("/");
            for (var i = 1; i < list.length; i++) {
                node = node.getChildByName(list[i]);
                if (node == null) {
                    console.error("findNodeByPathNoRoot: Not found", path, list[i], tag);
                    return null;
                }
            }
            return node;
        }
        static findNodeByPathIndexNoRoot(node, path, tag) {
            var list = path.split("/");
            for (var i = 1; i < list.length; i++) {
                node = node.getChildAt(Number(list[i]));
                if (node == null) {
                    console.error("findNodeByPathIndexNoRoot: Not found", path, tag);
                    return null;
                }
            }
            return node;
        }
        static applyShader(sprite, shaderMaterial) {
            if (sprite instanceof Laya.MeshSprite3D) {
                let oldMat = sprite.meshRenderer.sharedMaterial;
                let newMat = new shaderMaterial();
                newMat.albedoTexture = oldMat.albedoTexture;
                newMat.albedoColorA = oldMat.albedoColorA;
                newMat.albedoColorR = oldMat.albedoColorR;
                newMat.albedoColorG = oldMat.albedoColorG;
                newMat.albedoColorB = oldMat.albedoColorB;
                sprite.meshRenderer.sharedMaterial = newMat;
            }
            let childNum = sprite.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.applyShader(sprite.getChildAt(i), shaderMaterial);
            }
        }
        static hex2rgb(hex) {
            var clr = new Laya.Vector3;
            return hex = hex.replace("#", ""), clr.x = parseInt(hex.substr(0, 2), 16) / 255, clr.y = parseInt(hex.substr(2, 2), 16) / 255, clr.z = parseInt(hex.substr(4, 2), 16) / 255, clr;
        }
        static hex2rgba(hex) {
            var clr = new Laya.Vector4;
            return hex = hex.replace("#", ""), clr.x = parseInt(hex.substr(0, 2), 16) / 255, clr.y = parseInt(hex.substr(2, 2), 16) / 255, clr.z = parseInt(hex.substr(4, 2), 16) / 255, hex.length > 6 ? clr.w = parseInt(hex.substr(6, 2), 16) / 255 : clr.w = 1, clr;
        }
        static fogOpen(scene3d, fogStart, fogRange) {
            scene3d.enableFog = true;
            scene3d.fogStart = fogStart;
            scene3d.fogRange = fogRange;
        }
        static fogColor(scene3d, camera, color) {
            if (color) {
                scene3d.fogColor = Utils.hex2rgb(color);
            }
            let fogColor = scene3d.fogColor;
            camera.clearColor.x = fogColor.x;
            camera.clearColor.y = fogColor.y;
            camera.clearColor.z = fogColor.z;
        }
        static setComponentValue(node, clas, key, value) {
            let comp = node.getComponent(clas);
            if (comp instanceof clas) {
                comp[key] = value;
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.setComponentValue(node.getChildAt(i), clas, key, value);
            }
        }
        static lightShadow(directionLight) {
            directionLight.shadowMode = Laya.ShadowMode.SoftHigh;
            directionLight.shadowDistance = 40;
            directionLight.shadowResolution = 1024;
            directionLight.shadowCascadesMode = Laya.ShadowCascadesMode.NoCascades;
            directionLight.shadowStrength = 0.7;
        }
        static openCastShadow(node) {
            if (node instanceof Laya.SkinnedMeshSprite3D) {
                node.skinnedMeshRenderer.castShadow = true;
            }
            else if (node instanceof Laya.MeshSprite3D) {
                node.meshRenderer.castShadow = true;
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.openCastShadow(node.getChildAt(i));
            }
        }
        static openReceiveShadow(node, filterName) {
            if (node instanceof Laya.MeshSprite3D) {
                if (filterName) {
                    if (node.name.indexOf(filterName) >= 0) {
                        node.meshRenderer.receiveShadow = true;
                    }
                }
                else {
                    node.meshRenderer.receiveShadow = true;
                }
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.openReceiveShadow(node.getChildAt(i), filterName);
            }
        }
        static buildStickJumpPath(StickJumpPath) {
            let positionRoot = StickJumpPath.transform.position;
            let pathArray = [];
            let point1;
            for (let i = 0; i < StickJumpPath.numChildren; i++) {
                let pointRoot = StickJumpPath.getChildAt(i);
                let point = pointRoot.getChildByName("Point");
                if (point) {
                    let p = point.transform.position;
                    if (i > 0) {
                        p.x = 0;
                        p.y -= point1.y;
                        p.z -= point1.z;
                    }
                    else {
                        point1 = point.transform.position;
                        p = new Laya.Vector3(0, 0, 0);
                    }
                    pathArray.push(p);
                }
            }
            return pathArray;
        }
        static checkProb(prob, max = 99) {
            let r = this.random(0, max);
            if (r < prob) {
                return true;
            }
            else {
                return false;
            }
        }
        static _randomsort(a, b) {
            return Math.random() > .5 ? -1 : 1;
        }
        static printTransform(tag, node) {
            node.transform.position.clone(), node.transform.rotationEuler.clone();
            console.log(tag, "position", node.transform.position.clone());
            console.log(tag, "rotation", node.transform.rotation.clone());
            console.log(tag, "rotationEuler", node.transform.rotationEuler.clone());
        }
        static getParentPath(node) {
            let path = "";
            while (node) {
                path += (node.name + "/");
                node = node.parent;
            }
            return path;
        }
        static setSpriteColor(sprite, colorStr) {
            let color = Utils.hex2rgb(colorStr);
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            if (mat instanceof Laya.BlinnPhongMaterial) {
                mat.albedoColorR = color.x;
                mat.albedoColorG = color.y;
                mat.albedoColorB = color.z;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                mat.albedoColorR = color.x;
                mat.albedoColorG = color.y;
                mat.albedoColorB = color.z;
            }
        }
        static setSpriteColorV4(sprite, color) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            if (mat)
                mat.albedoColor = color;
        }
        static getSpriteMaterials(sprite) {
            let mat = [];
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterials;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterials;
            }
            return mat;
        }
        static getSpriteMat(sprite) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            return mat;
        }
        static setSpriteMat(sprite, mat) {
            if (sprite instanceof Laya.MeshSprite3D) {
                sprite.meshRenderer.sharedMaterial = mat;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                sprite.skinnedMeshRenderer.sharedMaterial = mat;
            }
        }
        static getSpriteTextrue(sprite) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            if (mat instanceof Laya.BlinnPhongMaterial) {
                return mat.albedoTexture;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                return mat.albedoTexture;
            }
            else {
                console.error("getSpriteTextrue: Not found material!", sprite);
            }
            return null;
        }
        static getSpriteNormalTextrue(sprite) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            if (mat instanceof Laya.BlinnPhongMaterial) {
                return mat.normalTexture;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                return null;
            }
            else {
                console.error("getSpriteTextrue: Not found material!", sprite);
            }
            return null;
        }
        static getSpriteColor(sprite) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
            }
            if (mat)
                return mat.albedoColor;
        }
        static setSpriteTextrue(sprite, texture, defaultMaterial = Laya.BlinnPhongMaterial) {
            let mat;
            if (sprite instanceof Laya.MeshSprite3D) {
                mat = sprite.meshRenderer.sharedMaterial;
                if (mat == null && defaultMaterial) {
                    mat = new defaultMaterial();
                    sprite.meshRenderer.sharedMaterial = mat;
                }
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                mat = sprite.skinnedMeshRenderer.sharedMaterial;
                if (mat == null && defaultMaterial) {
                    mat = new defaultMaterial();
                    sprite.skinnedMeshRenderer.sharedMaterial = mat;
                }
            }
            if (mat instanceof Laya.BlinnPhongMaterial) {
                mat.albedoTexture = texture;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                mat.albedoTexture = texture;
            }
            else {
                console.error("setSpriteTexture: Not found material!", sprite);
            }
            return mat;
        }
        static setMaterialColor(mat, colorStr) {
            let color = Utils.hex2rgb(colorStr);
            if (mat instanceof Laya.BlinnPhongMaterial) {
                mat.albedoColorR = color.x;
                mat.albedoColorG = color.y;
                mat.albedoColorB = color.z;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                mat.albedoColorR = color.x;
                mat.albedoColorG = color.y;
                mat.albedoColorB = color.z;
            }
        }
        static cloneSpriteMaterial(sprite) {
            if (sprite instanceof Laya.MeshSprite3D) {
                let mat = sprite.meshRenderer.sharedMaterial.clone();
                sprite.meshRenderer.sharedMaterial = mat;
                return mat;
            }
            else if (sprite instanceof Laya.SkinnedMeshSprite3D) {
                let mat = sprite.skinnedMeshRenderer.sharedMaterial.clone();
                sprite.skinnedMeshRenderer.sharedMaterial = mat;
                return mat;
            }
        }
        static setSpriteColorAll(node, colorStr, filterName) {
            if (node instanceof Laya.MeshSprite3D) {
                if (filterName) {
                    if (node.name.indexOf(filterName) >= 0) {
                        Utils.setSpriteColor(node, colorStr);
                    }
                }
                else {
                    Utils.setSpriteColor(node, colorStr);
                }
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.setSpriteColorAll(node.getChildAt(i), colorStr, filterName);
            }
        }
        static setSpriteTilingOffset(node, x, y, z, w) {
            let mat = node.meshRenderer.sharedMaterial;
            if (mat instanceof Laya.BlinnPhongMaterial) {
                mat.tilingOffsetX = x;
                mat.tilingOffsetY = y;
                mat.tilingOffsetZ = z;
                mat.tilingOffsetW = w;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                mat.tilingOffsetX = x;
                mat.tilingOffsetY = y;
                mat.tilingOffsetZ = z;
                mat.tilingOffsetW = w;
            }
        }
        static isMeshSprite(node) {
            if (node instanceof Laya.MeshSprite3D || node instanceof Laya.SkinnedMeshSprite3D) {
                return true;
            }
            else {
                return false;
            }
        }
        static getSpriteTilingOffset(node) {
            let mat = node.meshRenderer.sharedMaterial;
            if (mat instanceof Laya.BlinnPhongMaterial) {
                return mat.tilingOffset;
            }
            else if (mat instanceof Laya.UnlitMaterial) {
                return mat.tilingOffset;
            }
            return null;
        }
        static getScreenPos(camera, inPos, outPos) {
            if (outPos == null) {
                outPos = new Laya.Vector4();
            }
            camera.viewport.project(inPos, camera.projectionViewMatrix, outPos);
            outPos.x = outPos.x / Laya.stage.clientScaleX;
            outPos.y = outPos.y / Laya.stage.clientScaleY;
            return outPos;
        }
        static numberFormat(num, digits) {
            const si = [
                { value: 1, symbol: "" },
                { value: 1E3, symbol: "K" },
                { value: 1E6, symbol: "M" },
                { value: 1E9, symbol: "G" },
                { value: 1E12, symbol: "T" },
                { value: 1E15, symbol: "P" },
                { value: 1E18, symbol: "E" }
            ];
            const rx = /\.0+$|(\.[0-9]*[1-9])0+$/;
            let i;
            for (i = si.length - 1; i > 0; i--) {
                if (num >= si[i].value) {
                    break;
                }
            }
            return (num / si[i].value).toFixed(digits).replace(rx, "$1") + si[i].symbol;
        }
        static getTime() {
            return Date.now();
        }
        static getNodePathName(node) {
            if (node.parent) {
                return this.getNodePathName(node.parent) + "." + node.name;
            }
            else {
                return node.name;
            }
        }
        static vectorToDegree(dx, dy) {
            let degree = 0;
            if (dx != 0) {
                let yx = dy / dx;
                degree = Math.atan(yx) * 180 / Math.PI;
                if (dx < 0) {
                    degree += 180;
                }
                else if (dy < 0) {
                    degree = 360 + degree;
                }
            }
            else {
                if (dy == 0) {
                    degree = 0;
                }
                else if (dy > 0) {
                    degree = 90;
                }
                else {
                    degree = 270;
                }
            }
            return degree;
        }
        static zLookAt(transform, target, up) {
            let rotation = transform.rotation;
            Laya.Quaternion.lookAt(target, transform.position, up, rotation);
            rotation.invert(rotation);
            transform.rotation = rotation;
        }
        static zLookAtRotation(transform, target, up) {
            let rotation = transform.rotation;
            Laya.Quaternion.lookAt(target, transform.position, up, rotation);
            rotation.invert(rotation);
            return rotation;
        }
        static zLookAtDrection(transform, direction, up) {
            let rotation = transform.rotation;
            let Vector3 = Laya.Vector3;
            Laya.Quaternion.lookAt(direction, Vector3._ZERO, up, rotation);
            rotation.invert(rotation);
            transform.rotation = rotation;
        }
        static lookAtDrection(transform, direction, up) {
            let rotation = transform.rotation;
            let Vector3 = Laya.Vector3;
            Laya.Quaternion.lookAt(Vector3._ZERO, direction, up, rotation);
            rotation.invert(rotation);
            transform.rotation = rotation;
        }
        static getBackUp(transform) {
            let backup = new Laya.Vector3();
            transform.getForward(backup);
            backup.x = -backup.x;
            backup.y = -backup.y;
            backup.z = -backup.z;
            return backup;
        }
        static calcDistance(node1, node2) {
            return Laya.Vector3.distance(node1.transform.position, node2.transform.position);
        }
        static tweenProgress(progress, value, speed) {
            if (value <= 0 || value >= 100) {
                progress.value = value;
            }
            else if (speed > 0) {
                let deltaValue = Math.abs(progress.value - value);
                let time = deltaValue / speed;
                if (time > 0) {
                    progress.tweenValue(value, time);
                }
                else {
                    progress.value = value;
                }
            }
            else {
                progress.value = value;
            }
        }
        static createBoxTrans(p1, p2, p3, p4, p5, p6, p7, p8) {
            var vertexDeclaration = Laya.VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
            var faces = [];
            faces.push([p1, p2, p3, p4]);
            faces.push([p5, p6, p7, p8]);
            faces.push([p1, p4, p8, p5]);
            faces.push([p2, p3, p7, p6]);
            faces.push([p4, p3, p7, p8]);
            faces.push([p1, p2, p6, p5]);
            var normalAndUV = [
                0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1,
                0, -1, 0, 0, 1, 0, -1, 0, 1, 1, 0, -1, 0, 1, 0, 0, -1, 0, 0, 0,
                -1, 0, 0, 0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 1, 1, -1, 0, 0, 0, 1,
                1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1,
                0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1,
                0, 0, -1, 1, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, 1, 0, 0, -1, 1, 1
            ];
            let verticesData = [];
            let indexNormalAndUV = 0;
            for (let list of faces) {
                for (let point of list) {
                    verticesData.push(point.x);
                    verticesData.push(point.y);
                    verticesData.push(point.z);
                    for (let i = 0; i < 5; i++)
                        verticesData.push(normalAndUV[indexNormalAndUV++]);
                }
            }
            var vertices = new Float32Array(verticesData);
            var indices = new Uint16Array([
                0, 1, 2, 2, 3, 0,
                4, 7, 6, 6, 5, 4,
                8, 9, 10, 10, 11, 8,
                12, 15, 14, 14, 13, 12,
            ]);
            let PrimitiveMesh = Laya.PrimitiveMesh;
            let mesh = PrimitiveMesh._createMesh(vertexDeclaration, vertices, indices);
            return new Laya.MeshSprite3D(mesh);
        }
        static createTriangleByPoint(p1, p2, p3, unit = 1) {
            var vertexDeclaration = Laya.VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
            let HalfUnit = unit / 2;
            var vertices = new Float32Array([
                p1.x * unit - HalfUnit, (1 - p1.y) * unit - HalfUnit, 0, 0, 0, 1, p1.x, p1.y,
                p2.x * unit - HalfUnit, (1 - p2.y) * unit - HalfUnit, 0, 0, 0, 1, p2.x, p2.y,
                p3.x * unit - HalfUnit, (1 - p3.y) * unit - HalfUnit, 0, 0, 0, 1, p3.x, p3.y,
            ]);
            var indices = new Uint16Array([0, 1, 2]);
            var PrimitiveMesh = Laya.PrimitiveMesh;
            return PrimitiveMesh._createMesh(vertexDeclaration, vertices, indices);
        }
        static createTriangle(width = 1, height = 1) {
            var vertexDeclaration = Laya.VertexMesh.getVertexDeclaration("POSITION,NORMAL,UV");
            var halfWidth = width / 2;
            var halfHeight = height / 2;
            var vertices = new Float32Array([
                -halfWidth, halfHeight, 0, 0, 0, 1, 0, 0,
                halfWidth, halfHeight, 0, 0, 0, 1, 1, 0,
                -halfWidth, -halfHeight, 0, 0, 0, 1, 0, 1,
            ]);
            var indices = new Uint16Array([0, 1, 2]);
            var PrimitiveMesh = Laya.PrimitiveMesh;
            return PrimitiveMesh._createMesh(vertexDeclaration, vertices, indices);
        }
        static world2local(transform, value) {
            var localPosition = new Laya.Vector3();
            var Transform3D = Laya.Transform3D;
            var parentInvMat = Transform3D._tempMatrix0;
            transform.worldMatrix.invert(parentInvMat);
            Laya.Vector3.transformCoordinate(value, parentInvMat, localPosition);
            return localPosition;
        }
        static buttonDisable(button) {
            if (button.filters && button.filters.length > 0) {
                let colorFilter = button.filters[0];
                colorFilter.gray();
            }
            button.enabled = false;
        }
        static buttonEnable(button) {
            if (button.filters && button.filters.length > 0) {
                let colorFilter = button.filters[0];
                colorFilter.reset();
            }
            button.enabled = true;
        }
        static testRayCast(scene, camera) {
            var ray = new Laya.Ray(new Laya.Vector3(), new Laya.Vector3());
            var rayCastHit = new Laya.HitResult();
            camera.viewportPointToRay(new Laya.Vector2(Laya.stage.mouseX, Laya.stage.mouseY), ray);
            scene.physicsSimulation.rayCast(ray, rayCastHit, 300);
            console.log("testRayCast", ray, rayCastHit);
        }
        static processName(name) {
            return name.replace(/_/g, " ").trim();
        }
        static playEffect(node) {
            if (node == null)
                return;
            node.active = true;
            if (node instanceof Laya.ShuriKenParticle3D) {
                node.particleSystem.play();
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.playEffect(node.getChildAt(i));
            }
        }
        static stopEffect(node) {
            if (node == null)
                return;
            node.active = false;
            if (node instanceof Laya.ShuriKenParticle3D) {
                node.particleSystem.stop();
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.stopEffect(node.getChildAt(i));
            }
        }
        static changeEffectSpace(node, value) {
            if (node == null)
                return;
            node.active = true;
            if (node instanceof Laya.ShuriKenParticle3D) {
                node.particleSystem.simulationSpace = value;
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                this.changeEffectSpace(node.getChildAt(i), value);
            }
        }
        static changeEffectColor(node, color) {
            if (node == null)
                return;
            node.active = true;
            if (node instanceof Laya.ShuriKenParticle3D) {
                node.particleSystem.startColorConstant.x = color.x;
                node.particleSystem.startColorConstant.y = color.y;
                node.particleSystem.startColorConstant.z = color.z;
            }
            let childNum = node.numChildren;
            for (let i = 0; i < childNum; i++) {
                Utils.changeEffectColor(node.getChildAt(i), color);
            }
        }
        static changeEffectColorDeep(node, colorStr) {
            if (!colorStr)
                return;
            this.changeEffectColor(node, this.hex2rgb(colorStr));
        }
        static changeEffectColorByPath(parent, path, colorStr) {
            if (parent == null || !colorStr)
                return;
            let node = this.findNodeByPath(parent, path);
            if (node instanceof Laya.ShuriKenParticle3D) {
                let color = this.hex2rgb(colorStr);
                node.particleSystem.startColorConstant.x = color.x;
                node.particleSystem.startColorConstant.y = color.y;
                node.particleSystem.startColorConstant.z = color.z;
            }
        }
        static dateFormat(times, formats) {
            formats = formats || 'Y-m-d';
            var zero = function (value) {
                if (value < 10) {
                    return '0' + value;
                }
                return value;
            };
            var h = Math.floor(times / 3600);
            var m = Math.floor((times - h * 3600) / 60);
            var s = Math.floor((times - h * 3600 - m * 60));
            var hour = zero(h);
            var minite = zero(m);
            var second = zero(s);
            return formats.replace(/Y|m|d|H|i|s/ig, function (matches) {
                return ({
                    H: hour,
                    i: minite,
                    s: second
                })[matches];
            });
        }
        static getTimeByDate(h = 0, m = 0, s = 0) {
            var data = new Date();
            data.setHours(h);
            data.setMinutes(m, s);
            return data.getTime();
        }
        static WorldToScreen2(camera, point) {
            var pointA = this.InverseTransformPoint(camera.transform, point);
            var distance = pointA.z;
            var out = new Laya.Vector3();
            camera.viewport.project(point, camera.projectionViewMatrix, out);
            var value = new Laya.Vector3(out.x / Laya.stage.clientScaleX, out.y / Laya.stage.clientScaleY, distance);
            return value;
        }
        static InverseTransformPoint(origin, point) {
            var xx = new Laya.Vector3();
            origin.getRight(xx);
            var yy = new Laya.Vector3();
            origin.getUp(yy);
            var zz = new Laya.Vector3();
            origin.getForward(zz);
            var zz1 = new Laya.Vector3(-zz.x, -zz.y, -zz.z);
            var x = this.ProjectDistance(point, origin.position, xx);
            var y = this.ProjectDistance(point, origin.position, yy);
            var z = this.ProjectDistance(point, origin.position, zz1);
            var value = new Laya.Vector3(x, y, z);
            return value;
        }
        static ProjectDistance(A, C, B) {
            var CA = new Laya.Vector3();
            Laya.Vector3.subtract(A, C, CA);
            var angle = this.Angle2(CA, B) * Math.PI / 180;
            var distance = Laya.Vector3.distance(A, C);
            distance *= Math.cos(angle);
            return distance;
        }
        static Angle2(ma, mb) {
            var v1 = (ma.x * mb.x) + (ma.y * mb.y) + (ma.z * mb.z);
            var ma_val = Math.sqrt(ma.x * ma.x + ma.y * ma.y + ma.z * ma.z);
            var mb_val = Math.sqrt(mb.x * mb.x + mb.y * mb.y + mb.z * mb.z);
            var cosM = v1 / (ma_val * mb_val);
            if (cosM < -1)
                cosM = -1;
            if (cosM > 1)
                cosM = 1;
            var angleAMB = Math.acos(cosM) * 180 / Math.PI;
            return angleAMB;
        }
        static transformLocal2WorldPosition(transform, local, world) {
            Laya.Vector3.transformV3ToV3(local, transform.worldMatrix, world);
        }
        static transformLocal2WorldNormal(transform, local, world) {
            let Transform3D = Laya.Transform3D;
            var matrix = Transform3D._tempMatrix0;
            transform.localMatrix.invert(matrix);
            Laya.Vector3.TransformNormal(local, matrix, world);
        }
        static transformWorld2LocaldNormal(transform, world, local) {
            let Transform3D = Laya.Transform3D;
            var matrix = Transform3D._tempMatrix0;
            transform.worldMatrix.invert(matrix);
            Laya.Vector3.TransformNormal(world, matrix, local);
        }
        static transformWorld2LocalPosition(transform, world, local) {
            let Transform3D = Laya.Transform3D;
            var matrix = Transform3D._tempMatrix0;
            transform.worldMatrix.invert(matrix);
            Laya.Vector3.transformCoordinate(world, matrix, local);
        }
        static eulerToQuaternion(rotationEulerE) {
            let Transform3D = Laya.Transform3D;
            let rotation = new Laya.Quaternion;
            Laya.Quaternion.createFromYawPitchRoll(rotationEulerE.y / Transform3D._angleToRandin, rotationEulerE.x / Transform3D._angleToRandin, rotationEulerE.z / Transform3D._angleToRandin, rotation);
            return rotation;
        }
        static quaternionToEuler(rotation) {
            let Transform3D = Laya.Transform3D;
            let rotationEulerE = new Laya.Vector3;
            let eulerE = Transform3D._tempVector30;
            rotation.getYawPitchRoll(eulerE);
            rotationEulerE.x = eulerE.y * Transform3D._angleToRandin;
            rotationEulerE.y = eulerE.x * Transform3D._angleToRandin;
            rotationEulerE.z = eulerE.z * Transform3D._angleToRandin;
            return rotationEulerE;
        }
        static vector3ToQuaternion(vec3) {
            let rotation = new Laya.Quaternion;
            Laya.Quaternion.createFromYawPitchRoll(vec3.x, vec3.y, vec3.z, rotation);
            return rotation;
        }
        static quaternionToVector3(rotation) {
            let vec3 = new Laya.Vector3;
            rotation.getYawPitchRoll(vec3);
            return vec3;
        }
        static vector3ToEuler(vec3) {
            let Transform3D = Laya.Transform3D;
            let euler = new Laya.Vector3;
            euler.x = vec3.y * Transform3D._angleToRandin;
            euler.y = vec3.x * Transform3D._angleToRandin;
            euler.z = vec3.z * Transform3D._angleToRandin;
            return euler;
        }
        static eulerToVector3(euler) {
            let Transform3D = Laya.Transform3D;
            let vec3 = new Laya.Vector3;
            vec3.x = euler.y / Transform3D._angleToRandin;
            vec3.y = euler.x / Transform3D._angleToRandin;
            vec3.z = euler.z / Transform3D._angleToRandin;
            return vec3;
        }
        static getMesh(node) {
            let sharedMesh;
            if (node instanceof Laya.MeshSprite3D) {
                sharedMesh = node.meshFilter.sharedMesh;
            }
            else if (node instanceof Laya.SkinnedMeshSprite3D) {
                sharedMesh = node.meshFilter.sharedMesh;
            }
            else {
                console.warn("Utils.getMesh: not found Mesh data");
                return;
            }
            return sharedMesh;
        }
        static calculateBounds(vertices) {
            var min = new Laya.Vector3;
            var max = new Laya.Vector3;
            min.x = min.y = min.z = Number.MAX_VALUE;
            max.x = max.y = max.z = -Number.MAX_VALUE;
            for (var i = 0; i < vertices.length; i++) {
                var p = vertices[i];
                min.x = Math.min(min.x, p.x);
                min.y = Math.min(min.y, p.y);
                min.z = Math.min(min.z, p.z);
                max.x = Math.max(max.x, p.x);
                max.y = Math.max(max.y, p.y);
                max.z = Math.max(max.z, p.z);
            }
            return new Laya.BoundBox(min, max);
        }
        static addDebugLine(parent, direction, length, color = Laya.Color.RED) {
            let debugLine = new Laya.PixelLineSprite3D();
            debugLine.maxLineCount = 1;
            let to = direction.clone();
            to.x *= length;
            to.y *= length;
            to.z *= length;
            debugLine.addLine(new Laya.Vector3, direction, color, color);
            parent.addChild(debugLine);
        }
        static scaleNode(node, scale) {
            let localScale = node.transform.localScale;
            this.scaleVector3(localScale, scale);
            node.transform.localScale = localScale;
        }
        static scaleNodeSet(node, scale) {
            node.transform.localScaleX = scale;
            node.transform.localScaleY = scale;
            node.transform.localScaleZ = scale;
        }
        static scaleVector3(vec3, scale) {
            Laya.Vector3.scale(vec3, scale, vec3);
        }
        static callFuncWithName(caller, funcName) {
            let func = caller[funcName];
            if (func)
                func.bind(caller)();
        }
        static addSpriteFilter(sprite, filter) {
            if (sprite.filters) {
                sprite.filters.push(filter);
            }
            else {
                sprite.filters = [filter];
            }
        }
        static clearFilter(sprite) {
            sprite.filters = [];
        }
        static parseJsonSafe(jsonStr) {
            let jsonData = null;
            if (jsonStr) {
                try {
                    jsonData = JSON.parse(jsonStr);
                }
                catch (e) {
                    jsonData = null;
                }
            }
            return jsonData;
        }
        static lerp(start, end, percent) {
            return (start + percent * (end - start));
        }
        static isApp() {
            return window["conch"] != null;
        }
    }
    Utils.format = function () {
        var t = [];
        for (var e = 0; e < arguments.length; e++) {
            t[e] = arguments[e];
        }
        var i = undefined;
        if (t.length > 0) {
            i = t[0];
            for (var a = 1; a < t.length; a++) {
                if (t[a] != undefined) {
                    var s = new RegExp('({)' + a + '(})', 'g');
                    i = i.replace(s, t[a]);
                }
            }
        }
        return i;
    };
    Utils.random = function (min, max) {
        return Math.round(Math.random() * (max - min) + min);
    };
    Utils.randomRange = function (min, max) {
        return Math.random() * (max - min) + min;
    };
    Utils.keyOfMap = function (data, value) {
        for (var key in data) {
            if (data[key] == value)
                return key;
        }
        return null;
    };
    Utils.indexOfArray = function (array, value) {
        for (var i = 0; i < array.length; i++) {
            if (array[i] == value)
                return i;
        }
        return -1;
    };
    Utils.removeArrayItem = function (array, value) {
        var index = this.indexOfArray(array, value);
        if (index > -1) {
            array.splice(index, 1);
        }
    };
    Utils.randomItem = function (array) {
        if (array && array.length > 0) {
            return array[Utils.random(0, array.length - 1)];
        }
        else {
            return null;
        }
    };
    Utils.randomSort = function (array) {
        array.sort(this._randomsort);
    };

    var MSG;
    (function (MSG) {
        MSG["LOAD_PROGRESS"] = "LOAD_PROGRESS";
        MSG["LOAD_PLAY_END"] = "LOAD_PLAY_END";
        MSG["LOAD_COMPLETE"] = "LOAD_COMPLETE";
        MSG["SDK_INIT"] = "SDK_INIT";
        MSG["PANEL_ITEM_GET_OPEN"] = "PANEL_ITEM_GET_OPEN";
        MSG["PANEL_ITEM_GET_CLOSE"] = "PANEL_ITEM_GET_CLOSE";
        MSG["MSG_ENTER_PANEL_MAIN"] = "MSG_ENTER_PANEL_MAIN";
        MSG["GUIDE_CLOSE_PANEL"] = "GUIDE_CLOSE_PANEL";
        MSG["GUIDE_UPDATE"] = "GUIDE_UPDATE";
        MSG["GUIDE_COMPLETE"] = "GUIDE_COMPLETE";
        MSG["GUIDE_END"] = "GUIDE_END";
        MSG["GUIDE_SHOW_WEB_FINGER"] = "GUIDE_SHOW_WEB_FINGER";
        MSG["MAIN_SHOW_MENU"] = "MAIN_SHOW_MENU";
        MSG["MAIN_REFRESH_BUTTONS"] = "MAIN_REFRESH_BUTTONS";
        MSG["REFRESH_GAME_LIST"] = "REFRESH_GAME_LIST";
        MSG["PANEL_WAIT_CLOSE"] = "PANEL_WAIT_CLOSE";
        MSG["GAME_START"] = "GAME_START";
        MSG["GAME_PAUSE"] = "GAME_PAUSE";
        MSG["GAME_RESUME"] = "GAME_RESUME";
        MSG["GAME_RESTART"] = "GAME_RESTART";
        MSG["GAME_OPEN_GAME"] = "GAME_OPEN_GAME";
        MSG["GAME_REFRESH_WITH_GUIDE"] = "GAME_REFRESH_WITH_GUIDE";
        MSG["GAME_LOAD_LEVEL"] = "GAME_LOAD_LEVEL";
        MSG["GAME_LOAD_BLOCK"] = "GAME_LOAD_BLOCK";
        MSG["GAME_LOAD_BLOCK_ALL"] = "GAME_LOAD_BLOCK_ALL";
        MSG["GAME_REVIVE"] = "GAME_REVIVE";
        MSG["PLAYER_REVIVE"] = "PLAYER_REVIVE";
        MSG["GAME_UPDATE_SCORE"] = "GAME_UPDATE_SCORE";
        MSG["GAME_WIN"] = "GAME_WIN";
        MSG["PLAYER_MAIN_CHANGE_SKIN"] = "PLAYER_MAIN_CHANGE_SKIN";
        MSG["MSG_SDK_BASE_CHANNEL_INFO_CHANGED"] = "MSG_SDK_BASE_CHANNEL_INFO_CHANGED";
        MSG["CAMERA_CHANGE"] = "CAMERA_CHANGE";
        MSG["GAME_MINI_OPEN"] = "GAME_MINI_OPEN";
        MSG["CAMERA_SHAKE"] = "CAMERA_SHAKE";
        MSG["CAMERA_SHAKE_ONCE"] = "CAMERA_SHAKE_ONCE";
        MSG["GAME_MINI_LOAD"] = "GAME_MINI_LOAD";
        MSG["GAME_MINI_READY"] = "GAME_MINI_READY";
        MSG["GAME_MINI_START"] = "GAME_MINI_START";
        MSG["GAME_MINI_END"] = "GAME_MINI_END";
        MSG["GAME_MINI_CLICK"] = "GAME_MINI_CLICK";
        MSG["GAME_MINI_CLOSE_UI"] = "GAME_MINI_CLOSE_UI";
        MSG["GAME_SHOW_SCORE_ADD"] = "GAME_SHOW_SCORE_ADD";
        MSG["GAME_CHANGE_SKIN_USE"] = "GAME_CHANGE_SKIN_USE";
        MSG["GAME_ENERGY_ARRIVE"] = "GAME_ENERGY_ARRIVE";
        MSG["GAME_SHOW_YUEBING_ADD"] = "GAME_SHOW_YUEBING_ADD";
        MSG["CAMERA_CHANGE_END"] = "CAMERA_CHANGE_END";
        MSG["MODEL_SPRITE_LOAD"] = "MODEL_SPRITE_LOAD";
        MSG["FRONT_SKIN_LOAD"] = "FRONT_SKIN_LOAD";
        MSG["MODEL_SPRITE_SHOW"] = "MODEL_SPRITE_SHOW";
        MSG["MODEL_SPRITE_HIDE"] = "MODEL_SPRITE_HIDE";
        MSG["MODEL_SPRITE_PLAY"] = "MODEL_SPRITE_PLAY";
        MSG["MODEL_SPRITE_UPDATE"] = "MODEL_SPRITE_UPDATE";
        MSG["MODEL_SPRITE_BLINK_BEGIN"] = "MODEL_SPRITE_BLINK_BEGIN";
        MSG["MODEL_SPRITE_BLINK_END"] = "MODEL_SPRITE_BLINK_END";
        MSG["RANK_RESET_ACTIVE"] = "RANK_RESET_ACTIVE";
        MSG["PLAYER_WALK_ON_BLOCK"] = "PLAYER_WALK_ON_BLOCK";
        MSG["GAME_UPDATE_FACE"] = "GAME_UPDATE_FACE";
        MSG["CUSTOM_MODEL_DISPPOSE"] = "CUSTOM_MODEL_DISPPOSE";
        MSG["DINO_REVIVE_GET_PIECE"] = "DINO_REVIVE_GET_PIECE";
        MSG["DINO_REVIVE_PIECE_ARRIVE"] = "DINO_REVIVE_PIECE_ARRIVE";
        MSG["HOUSE_BOX_CLOSE"] = "HOUSE_BOX_CLOSE";
        MSG["GAME_SYNC_MONEY_BAR"] = "GAME_SYNC_MONEY_BAR";
        MSG["PARK_FOCUS_DINO"] = "PARK_FOCUS_DINO";
        MSG["PARK_FOCUS_NONE"] = "PARK_FOCUS_NONE";
        MSG["PARK_UPDATE_INFO"] = "PARK_UPDATE_INFO";
        MSG["PARK_TOURIST_SHOW_FACE"] = "PARK_TOURIST_SHOW_FACE";
        MSG["PARK_EXIT_FOCUS"] = "PARK_EXIT_FOCUS";
        MSG["PARK_BACK_MAIN"] = "PARK_BACK_MAIN";
    })(MSG || (MSG = {}));
    var GameModel;
    (function (GameModel) {
        GameModel["ITEM_FLAG"] = "e_xx";
        GameModel["ITEM_FLAG_SCAN"] = "mupai";
    })(GameModel || (GameModel = {}));
    var ITEM_GET_WAY;
    (function (ITEM_GET_WAY) {
        ITEM_GET_WAY[ITEM_GET_WAY["AD_VIDEO"] = 0] = "AD_VIDEO";
        ITEM_GET_WAY[ITEM_GET_WAY["BUY"] = 1] = "BUY";
        ITEM_GET_WAY[ITEM_GET_WAY["SHARE"] = 2] = "SHARE";
    })(ITEM_GET_WAY || (ITEM_GET_WAY = {}));
    var FIREWORK_TYPE;
    (function (FIREWORK_TYPE) {
        FIREWORK_TYPE[FIREWORK_TYPE["NORMAL"] = 0] = "NORMAL";
        FIREWORK_TYPE[FIREWORK_TYPE["DRAW"] = 1] = "DRAW";
    })(FIREWORK_TYPE || (FIREWORK_TYPE = {}));
    var PLAYER_STATE;
    (function (PLAYER_STATE) {
        PLAYER_STATE[PLAYER_STATE["NONE"] = 0] = "NONE";
        PLAYER_STATE[PLAYER_STATE["IDLE"] = 1] = "IDLE";
        PLAYER_STATE[PLAYER_STATE["RUN"] = 2] = "RUN";
        PLAYER_STATE[PLAYER_STATE["SWIM"] = 3] = "SWIM";
        PLAYER_STATE[PLAYER_STATE["CLASH"] = 4] = "CLASH";
        PLAYER_STATE[PLAYER_STATE["FLY"] = 5] = "FLY";
        PLAYER_STATE[PLAYER_STATE["CLIMB"] = 6] = "CLIMB";
        PLAYER_STATE[PLAYER_STATE["FIGHT"] = 7] = "FIGHT";
        PLAYER_STATE[PLAYER_STATE["MOOR"] = 8] = "MOOR";
        PLAYER_STATE[PLAYER_STATE["GORILLA"] = 9] = "GORILLA";
        PLAYER_STATE[PLAYER_STATE["TRUNK"] = 10] = "TRUNK";
        PLAYER_STATE[PLAYER_STATE["SPIDER"] = 11] = "SPIDER";
        PLAYER_STATE[PLAYER_STATE["RUN_SKILL"] = 12] = "RUN_SKILL";
        PLAYER_STATE[PLAYER_STATE["SWIM_SKILL"] = 13] = "SWIM_SKILL";
        PLAYER_STATE[PLAYER_STATE["CLASH_SKILL"] = 14] = "CLASH_SKILL";
        PLAYER_STATE[PLAYER_STATE["FLY_SKILL"] = 15] = "FLY_SKILL";
        PLAYER_STATE[PLAYER_STATE["CLIMB_SKILL"] = 16] = "CLIMB_SKILL";
        PLAYER_STATE[PLAYER_STATE["FIGHT_SKILL"] = 17] = "FIGHT_SKILL";
        PLAYER_STATE[PLAYER_STATE["MOOR_SKILL"] = 18] = "MOOR_SKILL";
        PLAYER_STATE[PLAYER_STATE["GORILLA_SKILL"] = 19] = "GORILLA_SKILL";
        PLAYER_STATE[PLAYER_STATE["TRUNK_SKILL"] = 20] = "TRUNK_SKILL";
        PLAYER_STATE[PLAYER_STATE["SPIDER_SKILL"] = 21] = "SPIDER_SKILL";
        PLAYER_STATE[PLAYER_STATE["BACK"] = 22] = "BACK";
        PLAYER_STATE[PLAYER_STATE["FALL"] = 23] = "FALL";
        PLAYER_STATE[PLAYER_STATE["WALL"] = 24] = "WALL";
        PLAYER_STATE[PLAYER_STATE["DEAD"] = 25] = "DEAD";
        PLAYER_STATE[PLAYER_STATE["WIN"] = 26] = "WIN";
        PLAYER_STATE[PLAYER_STATE["MINI_READY"] = 27] = "MINI_READY";
        PLAYER_STATE[PLAYER_STATE["MINI_RUN"] = 28] = "MINI_RUN";
        PLAYER_STATE[PLAYER_STATE["MINI_END"] = 29] = "MINI_END";
        PLAYER_STATE[PLAYER_STATE["MINI_RUN_SWIM"] = 30] = "MINI_RUN_SWIM";
        PLAYER_STATE[PLAYER_STATE["TRUNKING"] = 31] = "TRUNKING";
        PLAYER_STATE[PLAYER_STATE["SPIDERING"] = 32] = "SPIDERING";
        PLAYER_STATE[PLAYER_STATE["WAIT_CLASH"] = 33] = "WAIT_CLASH";
        PLAYER_STATE[PLAYER_STATE["FALL_DEAD"] = 34] = "FALL_DEAD";
        PLAYER_STATE[PLAYER_STATE["RUN_PATH"] = 35] = "RUN_PATH";
        PLAYER_STATE[PLAYER_STATE["MINI_HOUSE"] = 36] = "MINI_HOUSE";
        PLAYER_STATE[PLAYER_STATE["MINI_HOUSE_END"] = 37] = "MINI_HOUSE_END";
    })(PLAYER_STATE || (PLAYER_STATE = {}));
    const PLAYER_STATE_2_TTYPE = {
        [PLAYER_STATE.RUN]: "run",
        [PLAYER_STATE.RUN_PATH]: "run",
        [PLAYER_STATE.SWIM]: "swim",
        [PLAYER_STATE.CLASH]: "clash",
        [PLAYER_STATE.FLY]: "fly",
        [PLAYER_STATE.CLIMB]: "climb",
        [PLAYER_STATE.FIGHT]: "fight",
        [PLAYER_STATE.MOOR]: "moor",
        [PLAYER_STATE.GORILLA]: "gorilla",
        [PLAYER_STATE.TRUNK]: "trunk",
        [PLAYER_STATE.SPIDER]: "spider",
    };
    const PLAYER_STATE_2_SKILL = {
        [PLAYER_STATE.RUN]: PLAYER_STATE.RUN_SKILL,
        [PLAYER_STATE.SWIM]: PLAYER_STATE.SWIM_SKILL,
        [PLAYER_STATE.CLASH]: PLAYER_STATE.CLASH_SKILL,
        [PLAYER_STATE.FLY]: PLAYER_STATE.FLY_SKILL,
        [PLAYER_STATE.CLIMB]: PLAYER_STATE.CLIMB_SKILL,
        [PLAYER_STATE.FIGHT]: PLAYER_STATE.FIGHT_SKILL,
        [PLAYER_STATE.MOOR]: PLAYER_STATE.MOOR_SKILL,
        [PLAYER_STATE.GORILLA]: PLAYER_STATE.GORILLA_SKILL,
        [PLAYER_STATE.TRUNK]: PLAYER_STATE.TRUNK_SKILL,
        [PLAYER_STATE.SPIDER]: PLAYER_STATE.SPIDER_SKILL,
    };
    const PLAYER_STATE_ARRAY = [
        PLAYER_STATE.NONE,
        PLAYER_STATE.IDLE,
        PLAYER_STATE.RUN,
        PLAYER_STATE.SWIM,
        PLAYER_STATE.CLASH,
        PLAYER_STATE.FLY,
        PLAYER_STATE.CLIMB,
        PLAYER_STATE.FIGHT,
        PLAYER_STATE.MOOR,
        PLAYER_STATE.BACK,
        PLAYER_STATE.FALL,
        PLAYER_STATE.WALL,
        PLAYER_STATE.DEAD,
        PLAYER_STATE.WIN,
        PLAYER_STATE.MINI_READY,
        PLAYER_STATE.MINI_RUN,
        PLAYER_STATE.MINI_END,
        PLAYER_STATE.MINI_RUN_SWIM,
        PLAYER_STATE.GORILLA,
        PLAYER_STATE.TRUNK,
        PLAYER_STATE.SPIDER,
        PLAYER_STATE.RUN_PATH,
        PLAYER_STATE.MINI_HOUSE,
    ];
    class GameConst {
        static updateFrameDeltaTime() {
            var t = Laya.timer.delta * 0.001;
            if (t > this.MAX_FRAME_DELTA_TIME) {
                t = this.MAX_FRAME_DELTA_TIME;
            }
            this._frameDeltaTime = t;
            return this.FrameDeltaTime;
        }
        static get FrameDeltaTime() {
            return this._frameDeltaTime;
        }
    }
    GameConst.MAX_FRAME_DELTA_TIME = 1 / 24;
    GameConst.GLOBAL_UP = new Laya.Vector3(0, 1, 0);
    GameConst.bHighShadowQuality = true;
    GameConst._frameDeltaTime = 1 / 60;
    const SWITCH_ID = {
        RANK_RESET: "3",
    };
    var EditorType;
    (function (EditorType) {
        EditorType[EditorType["color"] = 1] = "color";
        EditorType[EditorType["slider"] = 2] = "slider";
        EditorType[EditorType["num"] = 3] = "num";
        EditorType[EditorType["vec4"] = 4] = "vec4";
    })(EditorType || (EditorType = {}));
    var CustomMaterialRenderMode;
    (function (CustomMaterialRenderMode) {
        CustomMaterialRenderMode[CustomMaterialRenderMode["unknown"] = 0] = "unknown";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_OPAQUE"] = 1] = "RENDERMODE_OPAQUE";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_CUTOUT"] = 2] = "RENDERMODE_CUTOUT";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_CUTOUT_CULL_NONE"] = 3] = "RENDERMODE_CUTOUT_CULL_NONE";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_TRANSPARENT"] = 4] = "RENDERMODE_TRANSPARENT";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_TRANSPARENT_CULL_NONE"] = 5] = "RENDERMODE_TRANSPARENT_CULL_NONE";
        CustomMaterialRenderMode[CustomMaterialRenderMode["RENDERMODE_OPAQUE_CULL_NONE"] = 6] = "RENDERMODE_OPAQUE_CULL_NONE";
    })(CustomMaterialRenderMode || (CustomMaterialRenderMode = {}));
    var CustomMaterialType;
    (function (CustomMaterialType) {
        CustomMaterialType[CustomMaterialType["unknown"] = 0] = "unknown";
        CustomMaterialType[CustomMaterialType["unlitCartoon"] = 1] = "unlitCartoon";
        CustomMaterialType[CustomMaterialType["pbrHair"] = 2] = "pbrHair";
        CustomMaterialType[CustomMaterialType["pbrSkin"] = 3] = "pbrSkin";
        CustomMaterialType[CustomMaterialType["pbrMask"] = 4] = "pbrMask";
        CustomMaterialType[CustomMaterialType["bagMaterial"] = 5] = "bagMaterial";
    })(CustomMaterialType || (CustomMaterialType = {}));
    var CHN_DATA = {
        appName: "toutiao",
        isShareEnabled: true,
        isPayEnabled: false,
        isSupportRecordShare: true,
        isSupportFindMinigames: true,
        isSupportInstallShortcut: true,
        findMinigamesImageUrl: "https://gamesres.ultralisk.cn/h5_games_res/common/find_me/default.png",
        jumpInfo: [
            {
                index: "1", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/61.png",
            },
            {
                index: "2", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/64.png",
            },
            {
                index: "3", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/49.png",
            },
            {
                index: "4", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/60.png",
            },
            {
                index: "5", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/61.png",
            },
            {
                index: "6", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/64.png",
            },
            {
                index: "7", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/49.png",
            },
            {
                index: "8", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/60.png",
            },
            {
                index: "9", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/61.png",
            },
            {
                index: "10", bReceived: false, rewards: [[1002, 10]],
                url: "https://gamesres.ultralisk.cn/h5_games_res/common/jump_games/64.png",
            }
        ],
        copInfo: `{
        "share_rate":"10",

        "isSupportRecommendationBtn": 1,
        
        "ad_mode":0,
        "ad_h5":"0",
        "ad_interstitial_ratios":"100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100",
        "ad_banner_ratios":"100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100",
        "ad_embedded_ratios":"100;100;100",
        "ad_video_ratios_":"",
        "ad_video_ratios":"100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100;100",
        "ad_video_cds":"",
        "ad_inst_cd":"10",
        "native_insert_mode":2,
        "some_function":"1;1;1;1;1;1;1;1;1;1;1",
        "b_open_statics_item":1,
        "url_notice":"TEST",

        "share_mode":"2;2;2;2;2;2;2;2;2",
        "share_delay_close":3,
        "level_delay_close":3,

        "cat_ratio":100,
        "cat_delta_time":30,

        "cd_dialog_game_unlock": 5,
        "cd_dialog_game_egg": 5,

        "egg_show_rate":100,
        "b_video_rewatch":1,
        "b_game_mistake_ad":0,
        "egg_show_game_rate":50,

        "alert_dialog_swtich": "1;1;1",
        "alert_dialog_queue": "1;2;3",
        "alert_dialog_cd": 28800,

        "video_mode":"0;0",
        "b_sign_delay_mode":0,
        "b_video_share_full_screen":1,
        "b_video_share_finger":1,
        "b_adv_reward_confirm":1,
        "b_adv_delay":1,
        "b_adv_full_screen":1
    }`
    };

    class _mBase {
        onStart() {
        }
    }

    const SECONDS_IN_DAY = 3600 * 24;
    const LONG_DELTA_TIME = SECONDS_IN_DAY * 365 * 1000;
    class mSwitch extends _mBase {
        constructor() {
            super(...arguments);
            this.m_data = null;
            this.dailyActive = false;
            this.weeklyActive = false;
        }
        onLoad() {
            this.loadRecord();
            let allDbs = db.get_switch_db_map();
            for (const id in allDbs) {
                var switchDb = allDbs[id];
                this.initSwitch(switchDb);
            }
            Global.registerListeners(this, {
                [BASE_MSG.GOAL_STATE_CHANGE]: this.onMsgGoalStateChange.bind(this),
            });
        }
        onStart() {
            if (this.active(BASE_SWITCH_ID.DAILY)) {
                this.dailyActive = true;
                Global.sendMsg(BASE_MSG.DAILY_SWITCH_ACTIVE);
                console.log("---> daily switch active true.");
            }
            if (this.active(BASE_SWITCH_ID.WEEKLY)) {
                this.weeklyActive = true;
                console.log("---> weekly switch active true.");
            }
            if (this.active(SWITCH_ID.RANK_RESET)) {
                Global.sendMsg(MSG.RANK_RESET_ACTIVE);
                console.log("---> rank switch active true.");
            }
        }
        loadRecord() {
            this.m_data = FileRecord.getData("switch_data") || {};
        }
        saveRecord() {
            FileRecord.setData("switch_data", this.m_data);
        }
        onMsgGoalStateChange(e) {
            if (e.userData.type != GOAL_TYPE.SWITCH)
                return;
            if (!e.isDone)
                return;
            let switchId = e.userData.data;
            let switchItem = this.m_data[switchId];
            if (switchItem) {
                let switchDb = db.get_switch_db(switchId);
                if (switchDb) {
                    this.updateUnlockSwitch(switchItem, switchDb);
                    this.saveRecord();
                }
            }
            return false;
        }
        initSwitch(switchDb) {
            let switchs = this.m_data;
            if (switchs[switchDb.id])
                return;
            let data = {
                count: switchDb.count,
                startTime: 0,
                endTime: 0,
            };
            switch (switchDb.type) {
                case 0:
                    this.updateCycleSwitch(data, switchDb);
                    break;
                case 1:
                    this.updateCdSwitch(data, switchDb);
                    return;
                case 2:
                    this.updateUnlockSwitch(data, switchDb);
                    break;
                case 3:
                case 4:
                    let sDb = switchDb;
                    sDb.count = 1;
                    break;
            }
            switchs[switchDb.id] = data;
            this.saveRecord();
        }
        query(switchId) {
            let data = this.m_data[switchId];
            if (!data) {
                console.error("mSwitch: can't find switch by switchId " + switchId);
                return null;
            }
            return data;
        }
        check(switchId) {
            if (!switchId)
                return true;
            let data = this.query(switchId);
            if (!data) {
                return false;
            }
            if (Timer.time >= data.startTime) {
                if (Timer.time <= data.endTime) {
                    return data.count != 0;
                }
                else {
                    this.updateCheck(switchId);
                    return this.check(switchId);
                }
            }
            else {
                return false;
            }
        }
        active(switchId) {
            if (!switchId)
                return true;
            if (!this.check(switchId))
                return false;
            let data = this.m_data[switchId];
            data.count--;
            if (data.count == 0) {
                let switchDb = db.get_switch_db(switchId);
                if (switchDb.type == 1) {
                    this.updateCdSwitch(data, switchDb);
                }
            }
            this.pushChangeToSession(switchId, null, null, data.count);
            this.saveRecord();
            return true;
        }
        getCount(switchId) {
            let data = this.query(switchId);
            if (!data) {
                return 0;
            }
            return data.count;
        }
        getCycleStartTime(switchId) {
            let data = this.query(switchId);
            if (!data) {
                return 0;
            }
            return data.startTime;
        }
        getCycleEndTime(switchId) {
            let data = this.query(switchId);
            if (!data) {
                return 0;
            }
            return data.endTime;
        }
        updateCheck(id) {
            let switchItem = this.m_data[id];
            let switchDb = db.get_switch_db(id);
            switch (switchDb.type) {
                case 0:
                    this.updateCycleSwitch(switchItem, switchDb);
                    break;
                case 1:
                    this.updateCdSwitch(switchItem, switchDb);
                    break;
                case 2:
                    switchItem.endTime = LONG_DELTA_TIME;
                    console.error(`解锁类型开关无法重复check id: ${id}`);
                    break;
                default:
                    console.error(`暂不支持类型更新 ${switchDb.type}`);
                    break;
            }
        }
        updateCycleSwitch(recordData, switchDb) {
            let timeData = Tools.splitToNumber(switchDb.params, ":");
            let date;
            if (timeData.length == 5) {
                date = new Date(timeData[2], timeData[3] - 1, timeData[4], timeData[0], timeData[1], 0, 0);
            }
            else if (timeData.length == 2) {
                if (recordData.startTime == 0) {
                    date = new Date(Date.now());
                }
                else {
                    date = new Date(recordData.startTime * 1000);
                }
                date.setHours(timeData[0], timeData[1], 0, 0);
            }
            else {
                console.error(`开关[${switchDb.id}]起始时间[${switchDb.params}]错误.`);
            }
            let startTime = date.getTime() / 1000;
            let endTime = 0;
            if (switchDb.duration <= 0) {
                endTime = LONG_DELTA_TIME;
            }
            else {
                endTime = startTime + switchDb.duration * 3600;
            }
            let deltaTime = switchDb.delta * 3600;
            deltaTime = Math.ceil((Timer.time - endTime) / deltaTime) * deltaTime;
            if (deltaTime > 0) {
                startTime += deltaTime;
                endTime += deltaTime;
            }
            recordData.startTime = startTime;
            recordData.endTime = endTime;
            recordData.count = switchDb.count;
        }
        updateCdSwitch(recordData, switchDb) {
            if (recordData.endTime == 0) {
                recordData.startTime = Timer.time;
                recordData.endTime = LONG_DELTA_TIME;
            }
            else {
                recordData.startTime = Timer.time + switchDb.delta;
            }
            recordData.count = switchDb.count;
        }
        updateUnlockSwitch(recordData, switchDb) {
            if (recordData.endTime == 0) {
                recordData.startTime = LONG_DELTA_TIME;
                recordData.endTime = recordData.startTime;
            }
            else {
                recordData.startTime = Timer.time;
                if (switchDb.duration <= 0) {
                    recordData.endTime = LONG_DELTA_TIME;
                }
                else {
                    recordData.endTime = Timer.time + switchDb.duration * 3600;
                }
                recordData.count = switchDb.count;
            }
        }
        pushChangeToSession(switchId, startTime, endTime, count) {
            if (true)
                return;
        }
    }

    let systemConsole = console;
    var ULLog$1;
    (function (ULLog) {
        class console {
            static info(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.info(...data);
                }
            }
            static log(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.log(...data);
                }
            }
            static warn(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.warn(...data);
                }
            }
            static error(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.error(...data);
                }
            }
        }
        console.allowConsole = true;
        ULLog.console = console;
    })(ULLog$1 || (ULLog$1 = {}));
    window["ULLog"] = ULLog$1;

    class ULEventListener {
        constructor(type, priority, callback, bDispatchOnce) {
            this.type = type;
            this.priority = priority;
            this.callback = callback;
            this.bDispatchOnce = bDispatchOnce;
            this.bNeedRemove = false;
        }
        isDispatchOnce() {
            return !!this.bDispatchOnce;
        }
        isNeedRemove() {
            return !!this.bNeedRemove;
        }
        markNeedRemove() {
            this.bNeedRemove = true;
        }
        triggerCallback(event) {
            if (this.callback instanceof Function) {
                try {
                    this.callback(event);
                }
                catch (error) {
                    ULLog.console.error("ULEventListener.triggerCallback has exception!", error.stack);
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class ULEvent {
        constructor(type, data) {
            this.bPropagationStoped = false;
            this.type = type;
            this.data = data;
            this.bPropagationStoped = false;
            this.returnValue = null;
        }
        stopImmediatePropagation() {
            this.bPropagationStoped = true;
        }
        setReturnValue(value, bDonotStop) {
            if (value != null) {
                this.returnValue = value;
                if (!bDonotStop)
                    this.stopImmediatePropagation();
            }
        }
        getReturnValue() {
            return this.returnValue;
        }
        isPropagationStoped() {
            return !!this.bPropagationStoped;
        }
    }

    class ULConst {
    }
    ULConst.CMD_GET_BASE_CHANNEL_INFO = "/c/getBaseChannelInfo";
    ULConst.CMD_SET_VERSION = "/c/setVersion";
    ULConst.CMD_END_USER_GUIDE = "/c/endUserGuide";
    ULConst.CMD_OPEN_MORE_GAME = "/c/openMoreGame";
    ULConst.CMD_OPEN_UL_MORE_GAME = "/c/openUlMoreGame";
    ULConst.CMD_OPEN_PAY = "/c/openPay";
    ULConst.CMD_OPEN_JF = "/c/openJf";
    ULConst.CMD_OPEN_SHARE = "/c/openShare";
    ULConst.CMD_QUERY_SHARE = "/c/queryShare";
    ULConst.CMD_CALL_PHONE = "/c/callPhone";
    ULConst.CMD_UL_WEB_VIEW = "/c/ulWebView";
    ULConst.CMD_EXIT_GAME = "/c/exitGame";
    ULConst.CMD_MEGADATA_SERVER = "/c/megadataServer";
    ULConst.CMD_POST_MEGADATA = "/c/postMegadata";
    ULConst.CMD_USE_CDKEY = "/c/useCdkey";
    ULConst.CMD_CHECK_TIME_CHANGE = "/c/checkTimeChange";
    ULConst.CMD_OPEN_ADV = "/c/openAdv";
    ULConst.CMD_CLICK_NATIVE_ADV = "/c/clickNativeAdv";
    ULConst.CMD_CLOSE_ADV = "/c/closeAdv";
    ULConst.CMD_CLOSE_NATIVE_ADV = "/c/closeNativeAdv";
    ULConst.CMD_USER_LOGIN = "/c/userLogin";
    ULConst.CMD_USER_LOGIN_REPORT = "/c/userLoginReport";
    ULConst.CMD_USER_IS_LOGIN = "/c/userIsLogin";
    ULConst.CMD_LOGIN_OUT = "/c/loginOut";
    ULConst.CMD_SAVE_RANK_DATA = "/c/saveRankData";
    ULConst.CMD_GET_RANK_DATA = "/c/getRankData";
    ULConst.CMD_GET_HEADLINE_IMRANK_DATA = "/c/getHeadlineIMRankData";
    ULConst.CMD_SET_HEADLINE_IMRANK_DATA = "/c/setHeadlineIMRankData";
    ULConst.CMD_RECORDER_GAME_VIDEO = "/c/recorderGameVideo";
    ULConst.CMD_SHARE_GAME_VIDEO = "/c/shareGameVideo";
    ULConst.CMD_OPEN_JUMP = "/c/openJump";
    ULConst.CMD_JUMP_OTHER_GAME = "/c/jumpOtherGame";
    ULConst.CMD_OPEN_RECOMMENDATION = "/c/openRecommendation";
    ULConst.CMD_CLOSE_RECOMMENDATION = "/c/closeRecommendation";
    ULConst.CMD_SAVE_USER_DATA = "/c/saveUserData";
    ULConst.CMD_GET_USER_DATA = "/c/getUserData";
    ULConst.CMD_ADD_GAME_TO_MY_FAVORITE = "/c/addGameToMyFavorite";
    ULConst.CMD_GET_USER_INFO_MSG = "/c/getUserInfoMsg";
    ULConst.CMD_OPEN_USERINFO_ACCREDIT_BUTTON = "/c/openUserInfoAccreditButton";
    ULConst.CMD_CLOSE_USERINFO_ACCREDIT_BUTTON = "/c/closeUserInfoAccreditButton";
    ULConst.CMD_INSTALL_SHORTCUT = "/c/installShortcut";
    ULConst.CMD_SET_CLIPBOARD_DATA = "/c/setClipboardData";
    ULConst.CMD_GET_CLIPBOARD_DATA = "/c/getClipboardData";
    ULConst.CMD_SET_ULSDKDEMO_DEBUG_MODE = "/c/setUlsdkdemoDebugMode";
    ULConst.CMD_MPSDK_AD_HANDLER = '/c/mpsdkAdHandler';
    ULConst.CMD_CREATE_GAME_ICON = '/c/createGameIcon';
    ULConst.CMD_GAME_ICON_HANDLER = '/c/gameIconHandler';
    ULConst.CMD_OPEN_CHANNEL_MORE_GAME_BOX = '/c/openChannelMoreGameBox';
    ULConst.CMD_OPEN_BLOCK_AD = '/c/openBlockAd';
    ULConst.CMD_CLOSE_BLOCK_AD = '/c/closeBlockAd';
    ULConst.CMD_GET_SHORTCUT_STATE = '/c/getShortcutState';
    ULConst.CMD_GET_SUBSCRIBE_STATE = "/c/getSubscribeState";
    ULConst.CMD_ADD_SUBSCRIBE = "/c/addSubscribe";
    ULConst.CMD_ADD_COLOR_SIGN = '/c/addColorSign';
    ULConst.CMD_OPEN_GRID_AD = '/c/openGridAd';
    ULConst.CMD_CLOSE_GRID_AD = '/c/closeGridAd';
    ULConst.CMD_JUMP_TO_VIDEO_VIEW = '/c/jumpToVideoView';
    ULConst.CMD_FOLLOW_OFFICIAL_ACCOUNT = '/c/followOfficialAccount';
    ULConst.CMD_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE = '/c/getFollowOfficialAccountState';
    ULConst.CMD_CONTENT_SECURITY_CHECK = '/c/contentSecurityCheck';
    ULConst.CMD_JUMP_LEISURE_SUBJECT = '/c/jumpLeisureSubject';
    ULConst.CMD_PHONE_VIBRATE = '/c/phoneVibrate';
    ULConst.CMD_OPEN_URL = '/c/openUrl';
    ULConst.CMD_SHOW_CHANNEL_MASK = '/c/showChannelMask';
    ULConst.CMD_CLOSE_CHANNEL_MASK = '/c/closeChannelMask';
    ULConst.CMD_SHOW_PRIVACY = '/c/showPrivacy';
    ULConst.CMD_OPEN_ADVANCED_SETTING = '/c/openAdvancedSetting';
    ULConst.CMD_GET_OPENDATA_CANVAS = '/c/getOpenDataCanvas';
    ULConst.CMD_CLOSE_OPENDATA_CANVAS = '/c/closeOpenDataCanvas';
    ULConst.CMD_SET_USER_CLOUD_STORAGE = '/c/setUserCloudStorage';
    ULConst.CMD_GET_USER_CLOUD_STORAGE = '/c/getUserCloudStorage';
    ULConst.CMD_GET_JOIN_GROUP_NUM = "/c/getJoinGroupNum";
    ULConst.CMD_JOIN_GROUP = "/c/joinGroup";
    ULConst.CMD_RANKLIST_GET_USER_NUM = "/c/getUserNumInRank";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_ID = "/c/getUserInfoByIdInRank";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_IDLIST = "/c/getUserInfoByIdListInRank";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_LIST = "/c/getUserInfoListByRankId";
    ULConst.CMD_RANKLIST_REPORT_USER_INFO = "/c/reportUserInfoInRank";
    ULConst.CMD_RANKLIST_MODIFY_SCORE_BY_ARRAY = "/c/modifyScoreByArray";
    ULConst.CMD_RANKLIST_GET_RANK_INFO = "/c/getRankInfo";
    ULConst.CMD_RANKLIST_UPDATE_RANK_USER_DATA = "/c/updateRankUserData";
    ULConst.CMD_GET_CHANNEL_USERID = "/c/getChannelUserId";
    ULConst.CMD_SHOW_LAUNCH_REWARD_ICON = "/c/showLaunchRewardIcon";
    ULConst.CMD_HIDE_LAUNCH_REWARD_ICON = "/c/hideLaunchRewardIcon";
    ULConst.CMD_SHOW_CHANNEL_MORE_GAME = "/c/showChannelMoreGame";
    ULConst.CMD_HIDE_CHANNEL_MORE_GAME = "/c/hideChannelMoreGame";
    ULConst.CMD_GET_CHANNEL_TASK_LIST_DATA = "/c/getChannelTaskListData";
    ULConst.CMD_CLICK_CHANNEL_TASK = "/c/clickChannelTask";
    ULConst.CMD_SEND_EMAIL_TO_USER = "/c/sendEmailToUser";
    ULConst.CMD_GET_USER_EMAIL = "/c/getUserEmail";
    ULConst.CMD_SHOW_FEEDBACK_AND_COMPLAINTS = "/c/showFeedbackAndComplaints";
    ULConst.CMD_OPEN_COMMUNITY = "/c/openCommunity";
    ULConst.CMD_CHANNEL_INFO_RESULT = "/c/channelInfoResult";
    ULConst.CMD_GET_BASE_CHANNEL_INFO_RESULT = "/c/getBaseChannelInfoResult";
    ULConst.CMD_PAY_RESULT = "/c/payResult";
    ULConst.CMD_PRE_PAY_RESULT = "/c/prePayResult";
    ULConst.CMD_SHARE_RESULT = "/c/shareResult";
    ULConst.CMD_LIFE_CYCLE_RESULT = "/c/lifeCycle";
    ULConst.CMD_PAUSE_SOUND_RESULT = "/c/pauseSound";
    ULConst.CMD_RESUME_SOUND_RESULT = "/c/resumeSound";
    ULConst.CMD_COP_INFO_RESULT = "/c/copInfoResult";
    ULConst.CMD_MEGADATA_SERVER_RESULT = "/c/megadataServer";
    ULConst.CMD_POST_MEGADATA_RESULT = "/c/postMegadataResult";
    ULConst.CMD_USE_CDKEY_RESULT = "/c/useCdkey";
    ULConst.CMD_CHECK_TIME_CHANGE_RESULT = "/c/checkTimeChangeResult";
    ULConst.CMD_OPEN_ADV_RESULT = "/c/openAdvResult";
    ULConst.CMD_OPEN_NATIVE_ADV_RESULT = "/c/openNativeAdvResult";
    ULConst.CMD_CLICK_NATIVE_ADV_RESULT = "/c/clickNativeAdvResult";
    ULConst.CMD_CLICK_ADV_RESULT = "/c/clickAdvResult";
    ULConst.CMD_CLOSE_ADV_RESULT = "/c/closeAdvResult";
    ULConst.CMD_CLOSE_NATIVE_ADV_RESULT = "/c/closeNativeAdvResult";
    ULConst.CMD_USER_LOGIN_RESULT = "/c/userLoginResult";
    ULConst.CMD_USER_IS_LOGIN_RESULT = "/c/userIsLoginResult";
    ULConst.CMD_USER_LOGIN_REPORT_RESULT = "/c/userLoginReportResult";
    ULConst.CMD_LOGIN_OUT_RESULT = "/c/loginOutResult";
    ULConst.CMD_SHOW_PRIVACY_RESULT = '/c/showPrivacyResult';
    ULConst.CMD_ADV_VALID_COUNT_RESULT = "/c/advValidCountResult";
    ULConst.CMD_SAVE_RANK_DATA_RESULT = "/c/saveRankDataResult";
    ULConst.CMD_GET_RANK_DATA_RESULT = "/c/getRankDataResult";
    ULConst.CMD_GET_HEADLINE_IMRANK_DATA_RESULT = "/c/getHeadlineIMRankDataResult";
    ULConst.CMD_SET_HEADLINE_IMRANK_DATA_RESULT = "/c/setHeadlineIMRankDataResult";
    ULConst.CMD_RECORDER_GAME_VIDEO_RESULT = "/c/recorderGameVideoResult";
    ULConst.CMD_SHARE_GAME_VIDEO_RESULT = "/c/shareGameVideoResult";
    ULConst.CMD_OPEN_JUMP_RESULT = "/c/openJumpResult";
    ULConst.CMD_JUMP_OTHER_GAME_RESULT = "/c/jumpOtherGameResult";
    ULConst.CMD_JUMP_OTHER_GAME_REWARD_RESULT = "/c/jumpOtherGameRewardResult";
    ULConst.CMD_EXTRA_BONUS_RESULT = "/c/extraBonus";
    ULConst.CMD_OPEN_RECOMMENDATION_RESULT = "/c/openRecommendationResult";
    ULConst.CMD_CLOSE_RECOMMENDATION_RESULT = "/c/closeRecommendationResult";
    ULConst.CMD_SAVE_USER_DATA_RESULT = "/c/saveUserDataResult";
    ULConst.CMD_GET_USER_DATA_RESULT = "/c/getUserDataResult";
    ULConst.CMD_ADD_GAME_TO_MY_FAVORITE_RESULT = "/c/addGameToMyFavoriteResult";
    ULConst.CMD_GET_USER_INFO_MSG_RESULT = "/c/getUserInfoMsgResult";
    ULConst.CMD_OPEN_USERINFO_ACCREDIT_BUTTON_RESULT = "/c/openUserInfoAccreditButtonResult";
    ULConst.CMD_CLOSE_USERINFO_ACCREDIT_BUTTON_RESULT = "/c/closeUserInfoAccreditButtonResult";
    ULConst.CMD_APP_SHARE_RESULT = "/c/appShareResult";
    ULConst.CMD_INSTALL_SHORTCUT_RESULT = "/c/installShortcutResult";
    ULConst.CMD_SET_CLIPBOARD_DATA_RESULT = "/c/setClipboardDataResult";
    ULConst.CMD_GET_CLIPBOARD_DATA_RESULT = "/c/getClipboardDataResult";
    ULConst.CMD_MPSDK_AD_HANDLER_RESULT = '/c/mpsdkAdHandlerResult';
    ULConst.CMD_CREATE_GAME_ICON_RESULT = '/c/createGameIconResult';
    ULConst.CMD_GAME_ICON_HANDLER_RESULT = '/c/gameIconHandlerResult';
    ULConst.CMD_OPEN_CHANNEL_MORE_GAME_BOX_RESULT = '/c/openChannelMoreGameBoxResult';
    ULConst.CMD_OPEN_BLOCK_AD_RESULT = '/c/openBlockAdResult';
    ULConst.CMD_CLOSE_BLOCK_AD_RESULT = '/c/closeBlockAdResult';
    ULConst.CMD_GET_SHORTCUT_STATE_RESULT = '/c/getShortcutStateResult';
    ULConst.CMD_GET_SUBSCRIBE_STATE_RESULT = "/c/getSubscribeStateResult";
    ULConst.CMD_ADD_SUBSCRIBE_RESULT = "/c/addSubscribeResult";
    ULConst.CMD_ADD_COLOR_SIGN_RESULT = '/c/addColorSignResult';
    ULConst.CMD_OPEN_GRID_AD_RESULT = '/c/openGridAdResult';
    ULConst.CMD_CLOSE_GRID_AD_RESULT = '/c/closeGridAdResult';
    ULConst.CMD_JUMP_TO_VIDEO_VIEW_RESULT = '/c/jumpToVideoViewResult';
    ULConst.CMD_FOLLOW_OFFICIAL_ACCOUNT_RESULT = '/c/followOfficialAccountResult';
    ULConst.CMD_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_RESULT = '/c/getFollowOfficialAccountStateResult';
    ULConst.CMD_CONTENT_SECURITY_CHECK_RESULT = '/c/contentSecurityCheckResult';
    ULConst.CMD_JUMP_LEISURE_SUBJECT_RESULT = '/c/jumpLeisureSubjectResult';
    ULConst.CMD_PHONE_VIBRATE_RESULT = '/c/phoneVibrateResult';
    ULConst.CMD_JUMP_NEW_USER_GUIDE = '/c/jumpNewGuide';
    ULConst.CMD_CHECKDEBUG_WHITEUSER_RESULT = '/c/checkDebugWhiteUserResult';
    ULConst.CMD_OPEN_URL_RESULT = '/c/openUrlResult';
    ULConst.CMD_CLEAN_UP_GAME_ARCHIVE = '/c/cleanUpGameArchive';
    ULConst.CMD_SHOW_POINT_DEBUG_INFO = '/c/showPointDebugInfo';
    ULConst.CMD_QUERY_SHARE_RESULT = "/c/queryShareResult";
    ULConst.CMD_CHECK_LAUNCH_REWARD = "/sdk/checkLaunchReward";
    ULConst.CMD_NAVIGATE_LAUNCH_REWARD_SCENE = "/c/navigateLaunchRewardScene";
    ULConst.CMD_WX_GET_GAMECLUB_DATA = "/c/wxGetGameClubData";
    ULConst.CMD_WX_SHOW_GAMECLUB_BUTTON = "/c/wxShowGameClubButton";
    ULConst.CMD_WX_HIDE_GAMECLUB_BUTTON = "/c/wxHideGameClubButton";
    ULConst.CMD_WX_GET_GAMECLUB_DATA_RESULT = "/c/wxGetGameClubDataResult";
    ULConst.CMD_WX_SHOW_GAMECLUB_BUTTON_RESULT = "/c/wxShowGameClubButtonResult";
    ULConst.CMD_WX_HIDE_GAMECLUB_BUTTON_RESULT = "/c/wxHideGameClubButtonResult";
    ULConst.CMD_WX_GAMECLUB_BUTTON_ONTAP_RESULT = "/c/wxGameClubButtonOnTapResult";
    ULConst.CMD_WX_GAMECLUB_BUTTON_OFFTAP_RESULT = "/c/wxGameClubButtonOffTapResult";
    ULConst.CMD_SET_USER_CLOUD_STORAGE_RESULT = '/c/setUserCloudStorageResult';
    ULConst.CMD_GET_USER_CLOUD_STORAGE_RESULT = '/c/getUserCloudStorageResult';
    ULConst.CMD_GET_JOIN_GROUP_NUM_RESULT = "/c/getJoinGroupNumResult";
    ULConst.CMD_JOIN_GROUP_RESULT = "/c/joinGroupResult";
    ULConst.CMD_LAUNCH_REWARD_RESULT = "/c/launchRewardResult";
    ULConst.REMSG_CMD_SHOW_LAUNCH_REWARD_ICON_RESULT = "/c/showLaunchRewardIconResult";
    ULConst.REMSG_CMD_HIDE_LAUNCH_REWARD_ICON_RESULT = "/c/hideLaunchRewardIconResult";
    ULConst.REMSG_CMD_SHOW_CHANNEL_MORE_GAME_RESULT = "/c/showChannelMoreGameResult";
    ULConst.REMSG_CMD_HIDE_CHANNEL_MORE_GAME_RESULT = "/c/hideChannelMoreGameResult";
    ULConst.REMSG_CMD_GET_CHANNEL_TASK_LIST_DATA_RESULT = "/c/getChannelTaskListDataResult";
    ULConst.REMSG_CMD_CLICK_CHANNEL_TASK_RESULT = "/c/clickChannelTaskResult";
    ULConst.REMSG_CMD_CHANNEL_TASK_FINISHED_RESULT = "/c/channelTaskFinishedResult";
    ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT = "/c/sendEmailToUserResult";
    ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT = "/c/getUserEmailResult";
    ULConst.REMSG_CMD_SHOW_FEEDBACK_AND_COMPLAINTS = "/c/showFeedbackAndComplaintsResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_QUERY = "/c/qqNetEarnedQuery";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_RECHARGE = "/c/qqNetEarnedRecharge";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_CASH = "/c/qqNetEarnedCash";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_QUERY_RESULT = "/c/qqNetEarnedQueryResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_RECHARGE_RESULT = "/c/qqNetEarnedRechargeResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_CASH_RESULT = "/c/qqNetEarnedCashResult";
    ULConst.CMD_RANKLIST_GET_USER_NUM_RESULT = "/c/getUserNumInRankResult";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_ID_RESULT = "/c/getUserInfoByIdInRankResult";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_IDLIST_RESULT = "/c/getUserInfoByIdListInRankResult";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_LIST_RESULT = "/c/getUserInfoListByRankIdResult";
    ULConst.CMD_RANKLIST_REPORT_USER_INFO_RESULT = "/c/reportUserInfoInRankResult";
    ULConst.CMD_RANKLIST_MODIFY_SCORE_BY_ARRAY_RESULT = "/c/modifyScoreByArrayResult";
    ULConst.CMD_RANKLIST_GET_RANK_INFO_RESULT = "/c/getRankInfoResult";
    ULConst.CMD_RANKLIST_UPDATE_RANK_USER_DATA_RESULT = "/c/updateRankUserDataResult";
    ULConst.CMD_GET_OPENDATA_CANVAS_RESULT = '/c/getOpenDataCanvasResult';
    ULConst.RECMD_GET_CHANNEL_USERID_RESULT = "/c/getChannelUserIdResult";
    ULConst.RECMD_OPEN_COMMUNITY_RESULT = "/c/openCommunityResult";
    ULConst.CMD_SDK_ON_COP_CHANGED = "/sdk/onCopChanged";
    ULConst.CMD_SDK_PREPARE_SHOW_VIDEO_ADV = "/sdk/prepareShowVideoAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_INTER_ADV = "/sdk/prepareShowInterAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_BANNER_ADV = "/sdk/prepareShowBannerAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_EMBEDDED_ADV = "/sdk/prepareShowEmbeddedAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_URL_ADV = "/sdk/prepareShowUrlAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_PASTER_ADV = "/sdk/prepareShowPasterAdv";
    ULConst.CMD_SDK_SHOW_VIDEO_ADV = "/sdk/showVideoAdv";
    ULConst.CMD_SDK_SHOW_INTER_ADV = "/sdk/showInterAdv";
    ULConst.CMD_SDK_SHOW_BANNER_ADV = "/sdk/showBannerAdv";
    ULConst.CMD_SDK_SHOW_EMBEDDED_ADV = "/sdk/showEmbeddedAdv";
    ULConst.CMD_SDK_SHOW_URL_ADV = "/sdk/showUrlAdv";
    ULConst.CMD_SDK_SHOW_PASTER_ADV = "/sdk/showPasterAdv";
    ULConst.CMD_SDK_CLOSE_VIDEO_ADV = "/sdk/closeVideoAdv";
    ULConst.CMD_SDK_CLOSE_INTER_ADV = "/sdk/closeInterAdv";
    ULConst.CMD_SDK_CLOSE_BANNER_ADV = "/sdk/closeBannerAdv";
    ULConst.CMD_SDK_CLOSE_EMBEDDED_ADV = "/sdk/closeEmbeddedAdv";
    ULConst.CMD_SDK_CLOSE_URL_ADV = "/sdk/closeUrlAdv";
    ULConst.CMD_SDK_CLOSE_Paster_ADV = "/sdk/closePasterAdv";
    ULConst.CMD_SDK_CLOSE_NATIVE_ADV = "/sdk/closeNativeAdv";
    ULConst.CMD_SDK_CLICK_NATIVE_ADV = "/sdk/clickNativeAdv";
    ULConst.CMD_SDK_GET_STORAGE = "/sdk/getStorge";
    ULConst.CMD_SDK_SET_STORAGE = "/sdk/setStorge";
    ULConst.CMD_SDK_GET_CLIPBOARD_DATA = "/sdk/getClipboardData";
    ULConst.CMD_SDK_SET_CLIPBOARD_DATA = "/sdk/setClipboardData";
    ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD = "/sdk/isSupportClipboard";
    ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG = "/sdk/collectionModuleCheckerConfig";
    ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_MORE_GAME_AB_TEST_CONFIG = "/sdk/collectionModuleCheckerMoreGameAbTestConfig";
    ULConst.CMD_SDK_ON_GAME_START = "/sdk/onGameStart";
    ULConst.CMD_SDK_ON_GAME_PAUSE = "/sdk/onGamePause";
    ULConst.CMD_SDK_ON_GAME_RESUME = "/sdk/onGameResume";
    ULConst.CMD_SDK_ON_SHARE_SHOW = "/sdk/onShareShow";
    ULConst.CMD_SDK_ON_SAHRE_APP_MESSAGE = "/sdk/onShareAppMessage";
    ULConst.CMD_SDK_ON_REPORT_ULSDK_EVENT = "/sdk/ulsdkMegadataUpload";
    ULConst.CMD_SDK_OPEN_SHARE_DURING_ADV = "/sdk/openShareDuringAdv";
    ULConst.CMD_SDK_CHANNEL_MEGADATA_POST = "/sdk/channelMegadataPost";
    ULConst.CMD_SDK_SET_UP_WEBVIEW_JAVASCRIPT_BRIDGE = "/sdk/setUpWebViewJavascriptBridge";
    ULConst.CMD_SDK_EXPRESS_NATIVE_ADV_STATUS_CHANGE = "/sdk/expressNativeAdvStatusChange";
    ULConst.CMD_MOYANG_QQ_REWARD_VIDEO_PLAY = "/sdk/moyangQQRewardVideoPlay";
    ULConst.CMD_MOYANG_QQ_REWARD_VIDEO_CLOSE = "/sdk/moyangQQRewardVideoClose";
    ULConst.CMD_FACEBOOK_INIT_COMPLETE = "/sdk/facebookInitComplete";
    ULConst.CMD_WXOCEANENGINE_PAY_SUCCESS = "/sdk/wxOceanEnginePaySuccess";
    ULConst.CMD_HUAWEI_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/HuaweiBuyQuantityPlayVideoAd";
    ULConst.CMD_HUAWEI_BUYQUANTITY_PAY_SUCCESS = "/sdk/HuaweiBuyQuantityPaySuccess";
    ULConst.CMD_WEIXIN_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/weixinBuyQuantityPlayVideoAd";
    ULConst.CMD_WEIXIN_BUYQUANTITY_PAY_SUCCESS = "/sdk/weixinBuyQuantityPaySuccess";
    ULConst.CMD_HEADLINE_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/headlineBuyQuantityPlayVideoAd";
    ULConst.CMD_HEADLINE_BUYQUANTITY_STARTPLAY_VIDEOAD = "/sdk/headlineBuyQuantityStartPlayVideoAd";
    ULConst.CMD_HEADLINE_BUYQUANTITY_PAY_SUCCESS = "/sdk/headlineBuyQuantityPaySuccess";
    ULConst.CMD_HEADLINE_SUBSCRIBE_SUCCESS = "/sdk/headlineSubscribeSuccess";
    ULConst.CMD_KUAISHOU_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/kuaishouBuyQuantityPlayVideoAd";
    ULConst.CMD_KUAISHOU_BUYQUANTITY_PAY_SUCCESS = "/sdk/kuaishouBuyQuantityPaySuccess";
    ULConst.CMD_SDK_COMMONEVENT_ID_POST = "/sdk/commonEventIdPost";
    ULConst.CMD_SDK_LEVELCOMPLETEEVENT_ID_POST = "/sdk/levelCompleteEventIdPost";
    ULConst.CMD_SDK_INIT_USER_LOGIN = "/sdk/initUserLogin";
    ULConst.CMD_SDK_QM_LOGIN_REPORT = "/qmsdk/loginReport";
    ULConst.CMD_SDK_QM_REPORT_EVENT = "/qmsdk/reportEvent";
    ULConst.CMD_SDK_QM_REPORT_GOLD = "/qmsdk/reportGold";
    ULConst.CMD_SDK_QM_SET_ACCOUNT_INFO = "/qmsdk/setAccountInfo";
    ULConst.CMD_SDK_QM_GET_OPEN_LEVEL = "/qmsdk/getOpenLevel";
    ULConst.CMD_SDK_QM_GET_RECOMMEND_INFO = "/qmsdk/getRecommendInfo";
    ULConst.CMD_SDK_QM_GET_SUGGEST_LIST = "/qmsdk/getSuggestList";
    ULConst.CMD_SDK_QM_GET_EXCITATION_LIST = "/qmsdk/getExcitationList";
    ULConst.CMD_SDK_QM_MPSDK_AD_CLICK = "/qmsdk/mpsdkAdClick";
    ULConst.CMD_SDK_QM_MPSDK_CLICK_SYNC = "/qmsdk/mpsdkClickSync";
    ULConst.CMD_SDK_QM_GET_USER_DATA_VERSION = "/qmsdk/getUserDataVersion";
    ULConst.CMD_SDK_QM_IS_STRONG_FISSION = "/qmsdk/isStrongFission";
    ULConst.CMD_SDK_QM_REPORT_VIDEO_TIME_EVENT = "/qmsdk/reportVideoTimeEvent";
    ULConst.CMD_SDK_OPPOQG_MARK_MANUAL_CLOSE_BANNER_COUNT = "/sdk/oppoqg/markManualCloseBannerCount";
    ULConst.CMD_SDK_OPPOQG_GET_MANUAL_CLOSE_BANNER_COUNT = "/sdk/oppoqg/getManualCloseBannerCount";
    ULConst.CMD_SDK_OPPOQG_HAS_BANNER_SHOWING = "/sdk/oppoqg/hasBannerShowing";
    ULConst.PRIORITY_DISABLE = -2;
    ULConst.PRIORITY_NONE = -1;
    ULConst.CONSOLE_OUTPUT_LEVEL_WARN = 1;
    ULConst.CONSOLE_OUTPUT_LEVEL_ERROR = 1;
    ULConst.CONSOLE_OUTPUT_LEVEL_LOG = 2;
    ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG = 3;
    ULConst.B_INNER_DEBUG = false;
    ULConst.COP_RETRY_TIME_SEC = 30;
    ULConst.STATIS_TYPE_BASE_INFO = "1";
    ULConst.STATIS_TYPE_PAY_INFO = "2";
    ULConst.STATIS_TYPE_ADV_INFO = "3";
    ULConst.STATIS_TYPE_COP_REQUEST = "4";
    ULConst.STATIS_TYPE_USER_EVENT = "5";
    ULConst.STATIS_TYPE_ONLINE_TIME = "6";
    ULConst.STATIS_TYPE_POINT_EVENT = "7";
    ULConst.STATIS_TYPE_COIN_CHANGE_EVENT = "5";
    ULConst.STATIS_TYPE_COMMON_EVENT = "7";
    ULConst.STATIS_TYPE_LEVEL_START_EVENT = "8";
    ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT = "9";
    ULConst.STATIS_TYPE_ITEM_BUY = "10";
    ULConst.STATIS_TYPE_BUY_ACTION = "11";
    ULConst.STATIS_TYPE_VIDEO_POINT_EVENT = "12";
    ULConst.STATIS_TYPE_USER_MESSAGE = "14";
    ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT = 200;
    ULConst.STATIS_USER_EVENT_GAME_LEVEL_START = "gameLevelStart";
    ULConst.STATIS_USER_EVENT_GAME_LEVEL_COMPLETE = "gameLevelComplete";
    ULConst.STATIS_USER_EVENT_GAME_COIN_ADD = "gameCoinAdd";
    ULConst.STATIS_USER_EVENT_GAME_COIN_LOST = "gameCoinLost";
    ULConst.STATIS_USER_EVENT_BUY_ACTION = "buyAction";
    ULConst.STATIS_USER_EVENT_ITEM_BUY = "itemBuy";
    ULConst.STATIS_USER_EVENT_COMMON_EVENT = "commonEvent";
    ULConst.STATIS_USER_EVENT_COMMON_EVENT_MULTI_FIELD = "commonEventMultiField";
    ULConst.STATIS_USER_EVENT_POINT_EVENT = "pointEvent";
    ULConst.STATIS_USER_ACTION_EVENT_LEVEL_START = "levelStart";
    ULConst.STATIS_USER_ACTION_EVENT_LEVEL_COMPLETE = "levelComplete";
    ULConst.STATIS_USER_ACTION_EVENT_COIN_CHANGE = "coinChange";
    ULConst.STATIS_USER_ACTION_EVENT_ITEM_BUY = "itemBuy";
    ULConst.STATIS_USER_ACTION_EVENT_BUY_ACTION = "buyAction";
    ULConst.STATIS_USER_ACTION_EVENT_COMMON_EVENT = "commonEvent";
    ULConst.STATIS_USER_ACTION_EVENT_VIDEO_POINT_EVENT = "videoPointEvent";
    ULConst.STATIS_UPLOAD_SPAN = 60;
    ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT = 100;
    ULConst.ADV_FAIL_TIP_NOAD = "暂无广告，请稍后再试";
    ULConst.ADV_FAIL_TIP_BUSY = "广告准备中，请稍后再试";
    ULConst.ENGLISH_ADV_FAIL_TIP_NOAD = "Ad display failed, please retry later.";
    ULConst.ENGLISH_ADV_FAIL_TIP_BUSY = "Ad in preparation, please retry later.";
    ULConst.ADV_ERR_CODE_CONSECUTIVE_FAIL = -100;
    ULConst.ADV_ERR_CODE_CDING = -101;
    ULConst.ADV_ERR_CODE_NATIVE_ID_ERROR = -102;
    ULConst.ADV_ERR_CODE_NATIVE_DATA_ERROR = -102;
    ULConst.ADV_ERR_CODE_CAN_NOT_PLAY = -103;
    ULConst.ADV_ERR_CODE_NOT_INITED = -104;
    ULConst.ADV_ERR_CODE_UNKNOWN = -105;
    ULConst.ADV_ERR_CODE_SHARE_NO_CALLBACK = -106;
    ULConst.ADV_ERR_CODE_SHARE_FAIL = -107;
    ULConst.ADV_ERR_CODE_ADOBJ_NULL = -108;
    ULConst.ADV_ERR_CODE_ADV_TYPE_CD = -109;
    ULConst.ADV_ERR_CODE_ADV_TYPE_DAILY_LIMIT = -110;
    ULConst.ADV_PRELOAD_STATE_READY = 1;
    ULConst.ADV_PRELOAD_STATE_LOADING = 2;
    ULConst.ADV_PRELOAD_STATE_NOAD = 3;
    ULConst.ADV_RESULT_CODE_SUCCESS = 1;
    ULConst.ADV_RESULT_CODE_FAILED = 0;
    ULConst.ADV_RESULT_CODE_OBSOLETE = 2;
    ULConst.ADV_MUST_DEFAULT_WEIGHT = 100;
    ULConst.ADV_RANDOM_DEFAULT_WEIGHT = 1;
    ULConst.ADV_DISABLE_DEFAULT_WEIGHT = 0;
    ULConst.ADV_RESULT_MSG_FAILED = "哎呀,广告走丢啦";
    ULConst.ADV_RESULT_MSG_SUCCESS = "show adv success";
    ULConst.ADV_NATIVE_RESULT_MSG_SUCCESS = "load native data success";
    ULConst.ADV_NATIVE_RESULT_MSG_FAIL = "load native data fail";
    ULConst.ADV_VIDEO_PLAY_FAIL_MSG = "广告提前关闭,无法获得奖励";
    ULConst.ADV_RESULT_MSG_CLICK = "click adv";
    ULConst.ADV_RESULT_MSG_CLOSE = "close adv";
    ULConst.ADV_NATIVE_OBSOLETE_MSG = "广告数据作废";
    ULConst.EXP_ADV_TYPE_CONST = "atype";
    ULConst.EXP_ADV_TEMPLATE_CONST = "tid";
    ULConst.EXP_ADV_POINT_CONST = ".";
    ULConst.UL_EVENT_ONREQUEST = "onRequest";
    ULConst.UL_EVENT_SHOW_PRIVACY_POLICY = "showPrivacyPolicy";
    ULConst.UL_EVENT_SHOW_PRIVACY_POLICY_WAIT = "showPrivacyPolicyWait";
    ULConst.CMD_GET_ADV_STATE_RESULT = "/c/getAdvStateResult";
    ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE_RESULT = "/c/closeAllAdvByTypeResult";
    ULConst.CMD_JUMP_NEW_GUIDE = "/c/jumpNewGuide";
    ULConst.CMD_GET_ADV_STATE = "/c/getAdvState";
    ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE = "/c/closeAllAdvByType";
    ULConst.CMD_REWARD_ADV_RESULT = "/c/rewardAdvResult";
    ULConst.UL_ADV_DEFAULT_TIMEOUT_TIME = 30000;
    ULConst.DEFAULT_TITLE = "广告";
    ULConst.DEFAULT_DESC = "哇!这个实在太棒啦!";
    ULConst.DEFAULT_TARGET_TITLE = "查看广告";
    ULConst.MIN_NATIVE_RESPONSE_CACHE_TIMEOUT = 0;
    ULConst.MAX_NATIVE_RESPONSE_CACHE_TIMEOUT = 30 * 1000;
    ULConst.DEFAULT_NATIVE_RESPONSE_CACHE_TIMEOUT = 15 * 1000;
    ULConst.ADV_LOAD_TYPE_PRELOAD = 1;
    ULConst.ADV_LOAD_TYPE_UNPRELOAD = 0;

    class ULEventDispatcher {
        constructor() {
            this.allListeners = {};
        }
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULEventDispatcher();
            }
            return this._instance;
        }
        addListener(type, priority, callback) {
            return this._addListener(type, priority, callback, false);
        }
        once(type, priority, callback) {
            return this._addListener(type, priority, callback, true);
        }
        _addListener(type, priority, callback, bDispatchOnce) {
            if (priority < ULConst.PRIORITY_NONE) {
                this.removeListenerByCallback(type, callback);
                return;
            }
            ;
            let listeners = this.allListeners[type];
            if (!listeners) {
                listeners = [];
                this.allListeners[type] = listeners;
            }
            let insertIndex = -1;
            for (let i = 0; i < listeners.length; i++) {
                let listener = listeners[i];
                if (listener.callback == callback) {
                    ULLog.console.warn("ULEventDispatcher._addListener callback already exists:", type);
                    return false;
                }
                if (insertIndex == -1 && listener.priority < priority) {
                    insertIndex = i;
                }
            }
            let listener = new ULEventListener(type, priority, callback, bDispatchOnce);
            if (insertIndex != -1) {
                listeners.splice(insertIndex, 0, listener);
            }
            else {
                listeners.push(listener);
            }
            return true;
        }
        removeListenerByCallback(type, callback) {
            let listeners = this.allListeners[type];
            if (!listeners)
                return;
            for (let i = listeners.length - 1; i >= 0; i--) {
                let listener = listeners[i];
                if (listener.callback == callback) {
                    listeners.splice(i, 1);
                }
            }
        }
        removeListenersByType(type) {
            delete this.allListeners[type];
        }
        dispatch(type, data) {
            let event = null;
            if (type instanceof ULEvent) {
                event = type;
            }
            else {
                event = new ULEvent(type, data);
            }
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULEventDispatcher.dispatch", event.type, event.data);
            let ret = this._inner_dispatch(event);
            return ret.bCalled;
        }
        dispatchWithReturn(type, data) {
            let event = null;
            if (type instanceof ULEvent) {
                event = type;
            }
            else {
                event = new ULEvent(type, data);
            }
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULEventDispatcher.dispatchWithReturn", event.type, event.data);
            let ret = this._inner_dispatch(event);
            return ret.returnValue;
        }
        _inner_dispatch(event) {
            let bCalled = false;
            let listeners = this.allListeners[event.type];
            if (!listeners) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("  listeners not found");
                return { bCalled: false, returnValue: null };
            }
            for (let i = 0; i < listeners.length; i++) {
                const listener = listeners[i];
                if (listener.isNeedRemove())
                    continue;
                if (listener.isDispatchOnce()) {
                    listener.markNeedRemove();
                }
                if (listener.triggerCallback(event)) {
                    bCalled = true;
                }
                if (event.isPropagationStoped()) {
                    break;
                }
            }
            for (let i = listeners.length - 1; i >= 0; i--) {
                let listener = listeners[i];
                if (listener.isNeedRemove()) {
                    listeners.splice(i, 1);
                }
            }
            return { bCalled: bCalled, returnValue: event.getReturnValue() };
        }
    }
    ULEventDispatcher._instance = null;

    var cConfig = {
        "a_prj_upload_res_dirs": [],
        "a_sdk_shield_unsubscribe_channels": [
            "146"
        ],
        "b_sdk_vivo_debug": false,
        "creatorVersion": "",
        "i_channel_info_timeout": 3000,
        "i_game_start_ready_timeout": 10000,
        "i_net_timeout": 5000,
        "i_prj_b2b_mode": 0,
        "i_sdk_adv_banner_cd": 0,
        "i_sdk_adv_banner_timeout": 30000,
        "i_sdk_adv_banner_valid_show_count": 2,
        "i_sdk_adv_custom_valid_show_count": 2,
        "i_sdk_adv_embedded_timeout": 30000,
        "i_sdk_adv_inter_cd": 0,
        "i_sdk_adv_inter_timeout": 30000,
        "i_sdk_adv_native_clicked_report_mode": 0,
        "i_sdk_adv_native_exposure_cd": 0,
        "i_sdk_adv_native_life_time": 15000,
        "i_sdk_adv_native_request_cd": 10000,
        "i_sdk_adv_paster_timeout": 30000,
        "i_sdk_adv_type_banner_cd": 0,
        "i_sdk_adv_type_banner_daily_limit": 0,
        "i_sdk_adv_type_embedded_cd": 0,
        "i_sdk_adv_type_embedded_daily_limit": 0,
        "i_sdk_adv_type_interstitial_cd": 0,
        "i_sdk_adv_type_interstitial_daily_limit": 0,
        "i_sdk_adv_type_paster_cd": 0,
        "i_sdk_adv_type_paster_daily_limit": 0,
        "i_sdk_adv_type_url_cd": 0,
        "i_sdk_adv_type_url_daily_limit": 0,
        "i_sdk_adv_type_video_cd": 0,
        "i_sdk_adv_type_video_daily_limit": 0,
        "i_sdk_adv_url_timeout": 30000,
        "i_sdk_adv_video_timeout": 30000,
        "i_sdk_age_level_info_mode": 1,
        "i_sdk_banner_autoRefresh_mode": 0,
        "i_sdk_banner_refresh_intervals": 30,
        "i_sdk_channel_user_id_mode": 0,
        "i_sdk_common_checktime_deferenceLimit": 300000,
        "i_sdk_compress_res_mode": 1,
        "i_sdk_content_security_check_support": 1,
        "i_sdk_custom_autoRefresh_mode": 0,
        "i_sdk_custom_refresh_intervals": 30,
        "i_sdk_debug_mode": 0,
        "i_sdk_debug_task_mode": 0,
        "i_sdk_find_mini_game_mode": 1,
        "i_sdk_installShortcut_mode": 1,
        "i_sdk_joinGroup_mode": 1,
        "i_sdk_jump_game_resource_mode": 0,
        "i_sdk_jump_single_random_length": 5,
        "i_sdk_jumplist_mode": 1,
        "i_sdk_megadata_encrypt": 1,
        "i_sdk_megadata_mode": 1,
        "i_sdk_megadata_upload_span": 5000,
        "i_sdk_moreWonderful_mode": 0,
        "i_sdk_moregame_mode": 1,
        "i_sdk_native_autoRefresh_intervals": 30,
        "i_sdk_native_autoRefresh_mode": 0,
        "i_sdk_native_valid_show_count": 2,
        "i_sdk_pay_mode": 0,
        "i_sdk_phone_vibrate": 1,
        "i_sdk_sdk_rank_mode": 0,
        "i_sdk_share_mode": 0,
        "i_sdk_subscribe_mode": 1,
        "i_sdk_support_open_url": 0,
        "i_sdk_support_record_share": 1,
        "i_sdk_trim_adv_err_switch": 1,
        "i_sdk_vivo_banner_intervals": 30,
        "i_sdk_vivo_custom_translucent_swicth": 1,
        "layaVersion": "2.8",
        "n_sdk_add_favorite_switch": 0,
        "n_sdk_adv_switch": 1,
        "n_sdk_adv_video_complete_mode": 1,
        "n_sdk_avoid_code_tort_switch": 0,
        "n_sdk_cdk_swtich": 1,
        "n_sdk_channel_more_game_switch": 0,
        "n_sdk_channel_task_switch": 0,
        "n_sdk_common_online_time_report_looper_interval": 60,
        "n_sdk_cop_switch": 1,
        "n_sdk_game_avoid_homogenization_switch": 0,
        "n_sdk_game_update_switch": 0,
        "n_sdk_open_community_switch": 0,
        "n_sdk_privacy_policy_switch": 1,
        "n_sdk_sidebar_reward_switch": 0,
        "n_sdk_ul_email_switch": 0,
        "n_sdk_vivo_buyQuantity_debug_switch": 0,
        "n_sdk_vivo_buyQuantity_switch": 0,
        "nodejsExePath": "nodejs16.15.1/node.exe",
        "nodejsGitAddr": "ude2/prj.ulnodejs",
        "nodejsGitBranch": "v1",
        "o_sdk_common_pay_info": {},
        "o_sdk_normal_share_success_rule": {
            "advShowNumber": "",
            "commonEventId": "valid_player_flag1",
            "onlineTime": 0,
            "payNumber": ""
        },
        "o_sdk_vivo_pay_info": {},
        "resProcessScriptPath": "",
        "s_game_name": "怪物冒险之旅⁡",
        "s_game_orientation": "portrait",
        "s_prj_company_name": "",
        "s_prj_engine": "Laya",
        "s_prj_engine_version": "2.8",
        "s_prj_id": "1565",
        "s_prj_name": "prj.game288",
        "s_prj_number": "game288",
        "s_sdk_adv_info": {
            "1": {
                "group": [
                    "1"
                ],
                "type": "interstitial"
            },
            "2": {
                "group": [
                    "2"
                ],
                "type": "banner"
            },
            "3": {
                "group": [
                    "3"
                ],
                "type": "embedded"
            },
            "4": {
                "group": [
                    "4"
                ],
                "type": "video"
            },
            "5": {
                "group": [
                    "5"
                ],
                "type": "url"
            }
        },
        "s_sdk_age_level_info": "1、本游戏是一款玩法简单的休闲游戏，适用于年满8周岁及以上的用户，建议未成年人在家长监护下使用游戏产品。\n2、游戏内无社交系统。\n3、游戏中有实名认证系统，认证为未成年人的用户将接受以下管理：未满8周岁的用户不能充值；8周岁以上未满16周岁的未成年人用户，单次充值金额不得超过50元人民币，每月充值金额累计不得超过200元人民币；16周岁以上的未成年人用户，单次充值金额不得超过100元人民币，每月充值金额累计不得超过400元人民币。\n未成年人用户可以在周五、周六、周日和法定节假日每日晚20时至21时期间登录游戏，其他时间内无法登录游戏。",
        "s_sdk_age_level_target": "12",
        "s_sdk_cdk_app_id": "",
        "s_sdk_cdk_url": "https://common.ultralisk.cn",
        "s_sdk_cocos2x_rootNode_check": "",
        "s_sdk_common_affiche_title": "最新公告",
        "s_sdk_common_affiche_url": "",
        "s_sdk_common_checktime_url": "https://copv7.ultralisk.cn/getservertime",
        "s_sdk_common_copyright_str": "QEBAXiAgICBdXV1dXV1dXV1dXSAgICAgLkBAQF4gICAgXV1dXV1dXV1dXSAgID1AQEAuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQF4gICAgQEBAQEBAQEBAQEAgPUBAQEBAQEBAQEBAXkBAQEBAQEBAQEAgLi9AQEBAQEBAQEBAXkBAQEBAQEBAQF4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgID1AQEBAQEBAQEBAXkBAQF4gICA9QEBAICAgICAuQEBAXiAgICBAQEBeICA9QEBAICAsQGAgPUBAQCAgICBAQEBeICA9QEBeICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAsQEBAQEBAQEBAQGBAQEBcXV1dL0BAQCAgQEBAQEBAQEBAQEAgQEBAXF1dL0BAQCA9QEBAQEBAQEBAQEBAQEBAXiAgPUBAXiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQF4gICAgQEBAQEBAQEBAQEAgIEBAQF4gICA9QEBAIEBAQEBAQEBAQEAgICAgLEBAQEBAQEBgIEBAQEBAQEBAQF4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAQEBAQEBeIEBAQF4gICA9QEBAICBAQEBAQEBAQEBAQCBAQEBeICA9QEBAID1AQEBAQGAgLlxALy4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQEBAQEBAXi5AQEBcXV1dL0BAQCAgQEBAXF1dXS9AQEAgQEBAXF1dL0BAQCAgLltAQEBAQEBAQEBAQEBAQEBAQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQCogID1AQF49QEBAQEBAQEBAQEAgIEBAQEBAQEBAQEBALkBAQEBAQEBAQEAgICAuQEBAXiAgICAgICAgICA9QEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEAqICA9QEBePUBAQCAgICA9QEBAICxdXV1dQEBAXF1dXT1AQEAqICA9QEBAICAgLkBAQEBAQEBAQEBAQEBAQEBAQCogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQEBAQEBAXEBAQF4gICAuQEBALyA9QEBAQEBAQEBAQEBAQEAvICAgL0BAQCAgIC5AQEBeICAgICAgICAgID1AQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQCogICAgPUBAQC8gXEBAQEBAQF4gICAgIC5AQEBeICxAQEBAIFxAQEBAQC8gICAuQEBAQEBAQEBAQEBAQEBAQEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAuXF4gICxbW1tbYCAgICAgICAuXEBAYCAgICxbICAuW1tbYCAgICAgLkBAQGAgICAgICAgICAgLEBAQCogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgLl1dXWAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLF1dXS4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAsXV1dLiAgICAgICAgICAgICwgICAgICAgICAgICAgIA0KICAgICAgID1AQEBeICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQCogICAgICAgICAgL0BAQEAgICAgICAgICAgICANCiAgICAgICA9QEBAXiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQEAqICAgICAgICAgIC5cQC9gICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICxdXSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICxdXV0qICAgQEBAQCogLl1dYCAgICAgICAgLl1dXWAgICAgICAgICAgIF1dXV0gICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAKiAuXV1gICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgID1AQEBcQEBAQEBAQGAgIC5AQEBAICAgID1AQEBeICAgICAgICAgICxAQEBAQEBAQF4gIEBAQEAvQEBAQEBAXCAgIC5AQEBAQEBAQEBeICAgICxAQEBAQEBAQEBAYCAgICAgICAgIC5AQEBAQEBAQEBAQCAgQEBAQC9AQEBAQEBcICAgPUBAQF4gICAgICAgICAgICANCiAgICAgICA9QEBAQGAgID1AQEBALiAuQEBAQCAgICA9QEBAXiAgICAgICAgID1AQEBAYCAgICxgICBAQEBALy4gLkBAQEBeICAuWy4gICAgXEBAQF4gIC9AQEAvYCAgLEBAQEBeICAgICAgICAgICAgICAvQEBALyAgIEBAQEAvLiAuQEBAQF4gID1AQEBeICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICAgQEBAQCogLkBAQEAgICAgPUBAQF4gICAgICAgIC5AQEBALiAgICAgICAgQEBAQCogICA9QEBAXiAgICxdQEBAQEBAQEBeIC5AQEBALiAgICAsQEBAQCAgICAgICAgICAgICxAQEBAYCAgICBAQEBAKiAgID1AQEBeICA9QEBAXiAgICAgICAgICAgIA0KICAgICAgID1AQEBeICAgIEBAQEAqIC5AQEBAICAgID1AQEBeICAgICAgICAuQEBAQC4gICAgICAgIEBAQEAqICAgPUBAQF4gLkBAQEBbYCA9QEBAXiAuQEBAQC4gICAgPUBAQEAgICAgICAgICAgIC9AQEAvICAgICAgQEBAQCogICA9QEBAXiAgPUBAQF4gICAgICAgICAgICANCiAgICAgICA9QEBAXiAgICBAQEBAKiAuQEBAQF4gICxAQEBAXiAgICAgICAgIFxAQEBAYCAgICxgICBAQEBAKiAgID1AQEBeID1AQEBeICAuQEBAQF4gIFxAQEBcLiAgLEBAQEBeICAgICAgICAgLEBAQEBgICAgICAgIEBAQEAqICAgXEBAQF4gID1AQEBeICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICAgQEBAQCogICxAQEBAQEBAXEBAQF4gICAgICAgICAgLEBAQEBAQEBAXiAgQEBAQCogICA9QEBAXiAgQEBAQEBAQEBAQEBeICAgLEBAQEBAQEBAQEBgICAgICAgICAgL0BAQEBAQEBAQEBAICBAQEBAKiAgID1AQEBeICA9QEBAXiAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgIC5bW1sgICAgICAgICAgICAgICAgICAgIC5bW1tbICAgICAgICAgICAgICAgICAgICAgLFtbKiAgICAgICAgICAgIC5bW1tbDQo",
        "s_sdk_common_login_url": "https://common.ultralisk.cn",
        "s_sdk_common_online_pay_url": "https://common.ultralisk.cn",
        "s_sdk_cop_addr": "https://copv7.ultralisk.cn",
        "s_sdk_cop_game_id": "",
        "s_sdk_jump_game_statis_game_indexes": "",
        "s_sdk_lan_debug_address": "",
        "s_sdk_megadata_close_table_type_ids": "",
        "s_sdk_megadata_game_id": "",
        "s_sdk_megadata_server_jump_game_type_id": "jumpabtest",
        "s_sdk_megadata_server_type_id": "974",
        "s_sdk_megadata_test_url": "https://megadatav7.ultralisk.cn/batchtestmodedataupload",
        "s_sdk_megadata_url": "https://megadatav7.ultralisk.cn",
        "s_sdk_normal_share_success_common_eventid": "valid_player_flag1",
        "s_sdk_version": "b6e130029",
        "s_sdk_vivo_app_id": "",
        "s_sdk_vivo_app_secret": "",
        "s_sdk_vivo_buyQuantity_addiction_game_eventId": "valid_player_flag1",
        "s_sdk_vivo_buyQuantity_addiction_rule": "",
        "s_sdk_vivo_buyQuantity_base_url": "",
        "s_sdk_vivo_minPlatform_version": "1102",
        "s_sdk_vivo_package_name": "com.ultralisk.game288.h5.vivominigame",
        "s_sdk_vivo_qg_url": "https://pay.vivo.com.cn/vivopay/order/request",
        "s_sdk_vivo_tiny_package_server": "https://gamesres.ultralisk.cn/h5_games_res/game288/vivo/v1",
        "s_sdk_vivo_version_code": "102",
        "s_sdk_vivo_version_name": "1.0.2",
        "s_sdk_white_user_check_url": "https://common.ultralisk.cn/sdkserver/checkwhiteuser",
        "srcRootPath": "src/script/",
        "t_customer_service_info": [
            "kefu@ultralisk.cn"
        ],
        "t_sdk_adv_banner_tags_style_setting": {},
        "t_sdk_adv_custom_args_style_setting": {},
        "t_sdk_common_event_ids": {
            "add_subscrible": "102",
            "click_more_game_channel_system_button": "108",
            "click_more_game_icon_list": "106",
            "click_more_game_icon_reward": "105",
            "click_more_game_icon_single": "104",
            "click_share": "101",
            "click_subscrible": "103",
            "open_cdk": "107",
            "open_share": "100"
        },
        "t_sdk_common_modify_tag_afterBuild": [],
        "t_sdk_common_modify_tag_beforeBuild": [],
        "t_sdk_compress_json_includes": [],
        "t_sdk_compress_json_includes_rem": "",
        "t_sdk_compress_res_config": [
            {
                "cmds": "jpeg-recompress --strip -t 0.4 --min 80 | guetzil --quality 85",
                "rep": ".*\\.jpg"
            },
            {
                "cmds": "autopng --quality 40-80 | optipng -strip all -o7 | zopflipng -y --lossy_8bit --lossy_transparent",
                "rep": ".*\\.png"
            }
        ],
        "t_sdk_cop_default_cop": {
            "b_open_privacy": "1",
            "i_preload_res": "1"
        },
        "t_sdk_cop_simulate_city_data": {
            "0": "未知城市",
            "1001": "海南藏族自治州",
            "1002": "西宁",
            "1003": "海东",
            "1004": "黄南藏族自治州",
            "1005": "海西蒙古族藏族自治州",
            "1006": "海北藏族自治州",
            "1007": "果洛藏族自治州",
            "1008": "玉树藏族自治州",
            "101": "北京",
            "1101": "临夏回族自治州",
            "1102": "甘南藏族自治州",
            "1103": "白银",
            "1104": "陇南",
            "1105": "定西",
            "1106": "平凉",
            "1107": "金昌",
            "1108": "酒泉",
            "1109": "张掖",
            "1110": "庆阳",
            "1111": "兰州",
            "1112": "武威",
            "1113": "嘉峪关",
            "1114": "天水",
            "1201": "银川",
            "1202": "固原",
            "1203": "吴忠",
            "1204": "中卫",
            "1205": "石嘴山",
            "1301": "商洛",
            "1302": "安康",
            "1303": "榆林",
            "1304": "铜川",
            "1305": "咸阳",
            "1306": "西安",
            "1307": "渭南",
            "1308": "汉中",
            "1309": "宝鸡",
            "1310": "延安",
            "1401": "长春",
            "1402": "白城",
            "1403": "松原",
            "1404": "白山",
            "1405": "吉林",
            "1406": "延边朝鲜族自治州",
            "1407": "四平",
            "1408": "辽源",
            "1409": "通化",
            "1501": "铜陵",
            "1502": "亳州",
            "1503": "黄山",
            "1504": "池州",
            "1505": "合肥",
            "1506": "淮北",
            "1507": "滁州",
            "1508": "宿州",
            "1509": "淮南",
            "1510": "蚌埠",
            "1511": "六安",
            "1512": "阜阳",
            "1513": "芜湖",
            "1514": "宣城",
            "1515": "安庆",
            "1516": "马鞍山",
            "1601": "恩施土家族苗族自治州",
            "1602": "仙桃",
            "1603": "武汉",
            "1604": "孝感",
            "1605": "咸宁",
            "1606": "十堰",
            "1607": "天门",
            "1608": "黄冈",
            "1609": "宜昌",
            "1610": "襄阳",
            "1611": "黄石",
            "1612": "荆门",
            "1613": "随州",
            "1614": "荆州",
            "1615": "鄂州",
            "1616": "神农架林区",
            "1617": "潜江",
            "1701": "株洲",
            "1702": "邵阳",
            "1703": "岳阳",
            "1704": "张家界",
            "1705": "怀化",
            "1706": "衡阳",
            "1707": "长沙",
            "1708": "常德",
            "1709": "郴州",
            "1710": "永州",
            "1711": "湘西土家族苗族自治州",
            "1712": "湘潭",
            "1713": "益阳",
            "1714": "娄底",
            "1801": "安顺",
            "1802": "黔南布依族苗族自治州",
            "1803": "铜仁",
            "1804": "六盘水",
            "1805": "贵阳",
            "1806": "黔东南苗族侗族自治州",
            "1807": "毕节",
            "1808": "遵义",
            "1809": "黔西南布依族苗族自治州",
            "1901": "太原",
            "1902": "长治",
            "1903": "运城",
            "1904": "晋中",
            "1905": "忻州",
            "1906": "朔州",
            "1907": "晋城",
            "1908": "阳泉",
            "1909": "大同",
            "1910": "临汾",
            "1911": "吕梁",
            "2001": "来宾",
            "2002": "柳州",
            "2003": "崇左",
            "2004": "百色",
            "2005": "河池",
            "2006": "防城港",
            "2007": "贺州",
            "2008": "贵港",
            "2009": "北海",
            "201": "上海",
            "2010": "南宁",
            "2011": "桂林",
            "2012": "玉林",
            "2013": "钦州",
            "2014": "梧州",
            "2101": "凉山彝族自治州",
            "2102": "攀枝花",
            "2103": "乐山",
            "2104": "遂宁",
            "2105": "资阳",
            "2106": "绵阳",
            "2107": "自贡",
            "2108": "德阳",
            "2109": "雅安",
            "2110": "达州",
            "2111": "广元",
            "2112": "广安",
            "2113": "阿坝藏族羌族自治州",
            "2114": "甘孜藏族自治州",
            "2115": "成都",
            "2116": "南充",
            "2117": "泸州",
            "2118": "内江",
            "2119": "宜宾",
            "2120": "巴中",
            "2121": "眉山",
            "2201": "郑州",
            "2202": "三门峡",
            "2203": "洛阳",
            "2204": "开封",
            "2205": "信阳",
            "2206": "焦作",
            "2207": "许昌",
            "2208": "濮阳",
            "2209": "济源",
            "2210": "鹤壁",
            "2211": "安阳",
            "2212": "驻马店",
            "2213": "新乡",
            "2214": "南阳",
            "2215": "漯河",
            "2216": "平顶山",
            "2217": "商丘",
            "2218": "周口",
            "2301": "石家庄",
            "2302": "保定",
            "2303": "沧州",
            "2304": "衡水",
            "2305": "唐山",
            "2306": "邯郸",
            "2307": "廊坊",
            "2308": "秦皇岛",
            "2309": "邢台",
            "2310": "张家口",
            "2311": "承德",
            "2401": "福州",
            "2402": "厦门",
            "2403": "宁德",
            "2404": "莆田",
            "2405": "龙岩",
            "2406": "三明",
            "2407": "南平",
            "2408": "泉州",
            "2409": "漳州",
            "2501": "南昌",
            "2502": "上饶",
            "2503": "赣州",
            "2504": "新余",
            "2505": "鹰潭",
            "2506": "抚州",
            "2507": "萍乡",
            "2508": "宜春",
            "2509": "景德镇",
            "2510": "吉安",
            "2511": "九江",
            "2601": "珠海",
            "2602": "东莞",
            "2603": "江门",
            "2604": "阳江",
            "2605": "惠州",
            "2606": "汕尾",
            "2607": "梅州",
            "2608": "清远",
            "2609": "湛江",
            "2610": "揭阳",
            "2611": "广州",
            "2612": "云浮",
            "2613": "潮州",
            "2614": "汕头",
            "2615": "韶关",
            "2616": "深圳",
            "2617": "佛山",
            "2618": "中山",
            "2619": "肇庆",
            "2620": "茂名",
            "2621": "河源",
            "2701": "呼和浩特",
            "2702": "锡林郭勒盟",
            "2703": "乌兰察布",
            "2704": "通辽",
            "2705": "包头",
            "2706": "阿拉善盟",
            "2707": "巴彦淖尔",
            "2708": "兴安盟",
            "2709": "鄂尔多斯",
            "2710": "乌海",
            "2711": "呼伦贝尔",
            "2712": "赤峰",
            "2801": "鹤岗",
            "2802": "鸡西",
            "2803": "哈尔滨",
            "2804": "黑河",
            "2805": "七台河",
            "2806": "伊春",
            "2807": "大兴安岭地区",
            "2808": "牡丹江",
            "2809": "绥化",
            "2810": "齐齐哈尔",
            "2811": "双鸭山",
            "2812": "大庆",
            "2813": "佳木斯",
            "2901": "葫芦岛",
            "2902": "营口",
            "2903": "丹东",
            "2904": "沈阳",
            "2905": "抚顺",
            "2906": "辽阳",
            "2907": "大连",
            "2908": "鞍山",
            "2909": "盘锦",
            "2910": "阜新",
            "2911": "本溪",
            "2912": "锦州",
            "2913": "铁岭",
            "2914": "朝阳",
            "3001": "淄博",
            "3002": "临沂",
            "3003": "威海",
            "3004": "莱芜",
            "3005": "日照",
            "3006": "济南",
            "3007": "泰安",
            "3008": "烟台",
            "3009": "聊城",
            "301": "天津",
            "3010": "东营",
            "3011": "菏泽",
            "3012": "滨州",
            "3013": "潍坊",
            "3014": "德州",
            "3015": "青岛",
            "3016": "济宁",
            "3017": "枣庄",
            "3101": "南京",
            "3102": "常州",
            "3103": "苏州",
            "3104": "无锡",
            "3105": "盐城",
            "3106": "镇江",
            "3107": "连云港",
            "3108": "宿迁",
            "3109": "南通",
            "3110": "徐州",
            "3111": "淮安",
            "3112": "扬州",
            "3113": "泰州",
            "401": "重庆",
            "501": "宁波",
            "502": "金华",
            "503": "嘉兴",
            "504": "绍兴",
            "505": "湖州",
            "506": "衢州",
            "507": "舟山",
            "508": "杭州",
            "509": "温州",
            "510": "丽水",
            "511": "台州",
            "601": "儋州",
            "602": "定安县",
            "603": "东方",
            "604": "五指山",
            "605": "屯昌县",
            "606": "琼海",
            "607": "澄迈县",
            "608": "琼中黎族苗族自治县",
            "609": "三亚",
            "610": "白沙黎族自治县",
            "611": "文昌",
            "612": "陵水黎族自治县",
            "613": "昌江黎族自治县",
            "614": "保亭黎族苗族自治县",
            "615": "临高县",
            "616": "海口",
            "617": "万宁",
            "618": "乐东黎族自治县",
            "701": "迪庆藏族自治州",
            "702": "西双版纳傣族自治州",
            "703": "临沧",
            "704": "保山",
            "705": "玉溪",
            "706": "德宏傣族景颇族自治州",
            "707": "红河哈尼族彝族自治州",
            "708": "大理白族自治州",
            "709": "丽江",
            "710": "怒江傈僳族自治州",
            "711": "普洱",
            "712": "楚雄彝族自治州",
            "713": "文山壮族苗族自治州",
            "714": "昆明",
            "715": "曲靖",
            "716": "昭通",
            "801": "拉萨",
            "802": "昌都",
            "803": "山南",
            "804": "阿里地区",
            "805": "林芝",
            "806": "日喀则",
            "807": "那曲地区",
            "901": "喀什地区",
            "902": "阿克苏地区",
            "903": "和田地区",
            "904": "哈密",
            "905": "石河子",
            "906": "吐鲁番",
            "907": "博尔塔拉蒙古自治州",
            "908": "巴音郭楞蒙古自治州",
            "909": "昌吉回族自治州",
            "910": "塔城地区",
            "911": "克孜勒苏柯尔克孜自治州",
            "912": "阿勒泰地区",
            "913": "乌鲁木齐",
            "914": "克拉玛依",
            "915": "伊犁哈萨克自治州"
        },
        "t_sdk_cop_strategy_setting": {},
        "t_sdk_exempt_advType_limit_arrays": [],
        "t_sdk_mutuallyExclusive_advType_setting": {},
        "t_sdk_privacyPolicy_dataArray": [
            {
                "name": "隐私政策",
                "privacyText": {
                    "policyText": "发布日期:2021年11月12日\n更新日期:2021年11月12日\n生效日期:2021年11月12日\n我们《》为了向您提供和持续优化定制化的服务或广告，游戏将收集和处理以下的信息，并仅在上述目的范围内与广告合作伙伴共享:设备信息，包括设备标识符、MAC、机型、品牌、App包名、App版本号、设备分辨率及像素密度;网络信息,包括网络连接状态、接入网络的方式和类型、IP地址;使用信息，包括广告内容的展现、点击、下载;除上述信息外,游戏还会收集账号ID，用来提供云存档服务，账号ID数据不会共享给广告合作伙伴。上述数据将会传输并保存至【中华人民共和国境内】的服务器，保存期限为60天，超出这一保留时间后将删除，但法律法规另有要求除外。\n\n如果您不同意我们采集上述信息， 或不同意调用相关手机权限或功能， 本软件将无法正常运行。 您可通过卸载或退出本软件来终止数据收集及上传。 点击“ 同意”， 即表示您同意本条款及服务协议。 如果您对本隐私政策有任何疑问,请通过kefu@ultralisk.cn与我们联系。地址：中国（四川）自由贸易试验区成都高新区府城大道西段399号8栋13层5号"
                },
                "url": "https://gamesres.ultralisk.cn/notice/policy/oppoyiguopolicy.json"
            }
        ],
        "t_sdk_record_duration_limit_object": {
            "*": {
                "max": 300,
                "min": 3
            },
            "2": {
                "max": 300,
                "min": 15
            }
        },
        "t_sdk_show_native_banner_autoRefresh_tags": [],
        "t_sdk_show_native_banner_autoRefresh_tags_style_setting": {},
        "t_sdk_trim_adv_err_object": {
            "*": "广告播放失败了，重新试试看吧！",
            "baidu": {
                "code": {
                    "3010003": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                    "3010005||3010006": "正在为您播放广告，请稍等一会儿，不要重复点击。"
                }
            },
            "headline||weixin||qq": {
                "code": {
                    "1004": "暂时没有适合您观看的广告，请稍等一会儿再试吧！"
                }
            },
            "oppo": {
                "(this.code==1001 || this.code == 1004)&&msg": {
                    "/10001/||/10100/||/10101/||/10403/": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                    "/10405/": "您的操作系统版本太低，不能播放广告。",
                    "/10406/": "需要连接到 Wifi 网络",
                    "/11002/": "这个广告只能在OPPO手机上播放，请确认您的机型。",
                    "/11003/": "暂时无法播放广告，请稍等一会儿再试吧1！"
                }
            },
            "vivo": {
                "code": {
                    "-100||101||500": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                    "-3||108||30005": "暂时无法播放广告，请稍等一会儿再试吧！",
                    "30007": "暂时无法播放广告，请稍等一会儿再试吧！",
                    "30010": "广告播放失败了，可能是是由于您经常关闭广告造成的，稍等一会儿再试吧。"
                }
            },
            "zhifubao": "暂无广告，请稍后再试"
        },
        "t_sdk_vivo_custom_adv_setting": {},
        "t_sdk_vivo_share_list": [],
        "t_sdk_vivo_show_banner_box_adv_tags": [],
        "t_sdk_vivo_show_portal_box_adv_setting": {
            "*": {
                "top": 0.5
            }
        },
        "targetCreatorBranch": "",
        "targetCreatorExePath": "",
        "targetCreatorGitAddr": "",
        "targetCreatorToolGitAddr": "ude2/prj.ulcocoscreator_tools3.x",
        "targetCreatorToolGitBranch": "v2",
        "targetProjectBranch": "v1_h5_release",
        "targetProjectGitAddr": "ude2/prj.game288",
        "targetProjectPath": "_publish/h5_release/proj.h5",
        "tempCreatorProjectPaths": [
            [
                ".laya/",
                ".laya/"
            ],
            [
                "bin/",
                "bin/",
                [
                    "**/vconsole.*"
                ]
            ],
            [
                "declare/",
                "declare/"
            ],
            [
                "laya/",
                "laya/"
            ],
            [
                "libs/",
                "libs/"
            ],
            [
                "src/",
                "src/"
            ],
            [
                "prj.game120.laya",
                ""
            ],
            [
                "tsconfig.json",
                ""
            ]
        ],
        "tempProjectName": "laya_proj",
        "autoUploadPack": true,
        "systemConfig": {
            "_comment": "系统层面的相关配置",
            "git_addr": "git@git.ultralisk.cn:/",
            "task_git_library_path": "prj.games.html5.channels.tasks",
            "gameres_git_library_path": "h5_games_res",
            "h5gamesres_git_addr": "git@h005.ultralisk.cn:/"
        },
        "B_SHOW_LICENCE_INFO_ON_LOADING": false,
        "a_sdk_obfuscator_excludes": [],
        "a_sdk_obfuscator_includes": [
            "**/bundle*.js",
            "**/project*.js",
            "**/index*.js",
            "**/ulsdk*.js",
            "**/settings*.js",
            "**/game*.js"
        ],
        "b_sdk_obfuscator_mode": false,
        "build_laya_vivogame_module_config": {
            "bAutoUploadEnabled": true,
            "bNakedPackage": true,
            "compressJs": false,
            "nakedPackageSearchKeys": [
                "res/cfg/",
                "res/scene/vLoadingScene.json"
            ],
            "title": "怪物冒险之旅⁡",
            "url_path": "https://gamesres.ultralisk.cn/h5_games_res/game288/vivo/v1",
            "useMinJsLibs": false,
            "vivoInfo": {
                "logLevel": "log",
                "minPlatformVersion": "1102",
                "name": "怪物冒险之旅⁡",
                "package": "com.ultralisk.game288.h5.vivominigame",
                "versionCode": "102",
                "versionName": "1.0.2"
            }
        },
        "i_sdk_licence_info_mode": 1,
        "i_sdk_start_game_by_touch": 1,
        "o_sdk_obfuscator_config": {},
        "s_sdk_channel_name": "vivo",
        "s_sdk_cop_channel_id": "136",
        "s_sdk_cop_version": "109034",
        "s_sdk_licence_info": "",
        "t_sdk_increment_fields": [
            "s_sdk_vivo_version_code",
            "s_sdk_vivo_version_name"
        ],
        "_target_project_branch": "v1_h5_release",
        "_target_project_log": "2025-05-13 16:00:40 +0800-yinruilin-80088f998",
        "_target_last_commit_time": 1747123240,
        "prjVersion": "80088f998",
        "rootPath": "D:/ulwork/ulsdk/",
        "rootSdkPath": "D:/ulwork/ulsdk/prj.sdk.html5/",
        "gitRepoPath": "D:/ulwork/ulsdk/h5_games_res/",
        "taskDate": "2025_05_13",
        "taskTick": "2025_05_13_17_01_41",
        "taskTickShort": "0513_170141",
        "taskName": "vivo",
        "configName": "task_h5_game288_shjpk",
        "targetPath": "D:/ulwork/ulsdk/h5_out/88_vivo_0513_170141/",
        "resCachePath": "D:/ulwork/ulsdk/h5_res_cache/prj.game288/",
        "packagePath": "D:/ulwork/ulsdk/prj.games.html5.channels.packages/prj.game288/prj.game288_v1_h5_release_vivo_0513_170141/",
        "buildDisabled": false,
        "creatorExePath": "",
        "nodejsExeAbsPath": "D:/ulwork/ude2/prj.ulnodejs/nodejs16.15.1/node.exe",
        "taskJsonPath": "D:/ulwork/ulsdk/prj.games.html5.channels.tasks/task_h5_game288_shjpk/task.json",
        "buildTempPath": "D:\\ulwork\\ulsdk\\prj.sdk.html5\\build_system\\build_gradle/../../../h5_out/build_temp/",
        "envCheckResult": [],
        "tempProjPath": "D:/ulwork/ulsdk/h5_out/88_vivo_0513_170141/laya_proj/",
        "moduleList": "common,build_laya_vivogame,privacyPolicy,vivo"
    };

    class ULTimer {
        constructor(span, repeatCount, callback) {
            this._repeatCount = -1;
            this._span = 1;
            this._callback = null;
            this._intervalId = null;
            this._count = 0;
            this._beginTime = -1;
            this._usedTime = 0;
            this._span = span;
            this._repeatCount = repeatCount;
            this._callback = callback;
        }
        static callLater(span, callback) {
            let timer = new ULTimer(span, 1, callback);
            timer.start();
        }
        static callLoop(span, callback) {
            let timer = new ULTimer(span, -1, callback);
            timer.start();
        }
        _onSpan() {
            this._count++;
            this._usedTime = ULTools.time() - this._beginTime;
            if (this._callback) {
                try {
                    this._callback(this);
                }
                catch (error) {
                    ULLog.console.warn("警告] ULTimer._onSpan callback has error", error);
                }
            }
            if (this._repeatCount >= 0 && this._count >= this._repeatCount) {
                this.stop();
            }
        }
        isRunning() {
            return this._intervalId != null;
        }
        get count() {
            return this._count;
        }
        get span() {
            return this._span;
        }
        get usedTime() {
            return this._usedTime;
        }
        start() {
            this.stop();
            if (!this._callback) {
                ULLog.console.warn("警告] ULTimer.start callback未设置！");
                return this;
            }
            this._beginTime = ULTools.time();
            this._count = 0;
            this._intervalId = setInterval(this._onSpan.bind(this), this.span * 1000);
            return this;
        }
        stop() {
            if (this._intervalId != null) {
                clearInterval(this._intervalId);
                this._intervalId = null;
            }
            return this;
        }
    }

    class ULStorageManager {
        constructor() {
            this.cacheStorage = {};
        }
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULStorageManager();
            }
            return this._instance;
        }
        getStorage(key) {
            let returnValue = ULEventDispatcher.getInstance().dispatchWithReturn(ULConst.CMD_SDK_GET_STORAGE, { key: key });
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log(ULTools.format("ULStorageManager.getStorage(%s) => [%s]", key, returnValue));
            if (returnValue == null) {
                returnValue = this.cacheStorage[key];
            }
            else {
                this.cacheStorage[key] = returnValue;
            }
            return returnValue;
        }
        setStorage(key, data) {
            this.cacheStorage[key] = data;
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_SET_STORAGE, { key: key, data: data });
            if (!bCalled) {
                ULLog.console.warn("ULStorageManager.setStorage 未找到实现！");
            }
        }
    }
    ULStorageManager._instance = null;

    class ULWebSocket {
        constructor(url) {
            this.socketingWS = null;
            this.isOpening = false;
            this.socketMsgCache = [];
            this._isAutoClearCache = false;
            if ("WebSocket" in window) {
                var address = url;
                var ws = new WebSocket(address);
                this.socketingWS = ws;
                let self = this;
                ws.onopen = function (ev) {
                    self.isOpening = true;
                    self.onopen(ev);
                };
                ws.onmessage = function (evt) {
                    self.onmessage(evt);
                };
                ws.onclose = function (evt) {
                    self.isOpening = false;
                    self.socketingWS = null;
                    self.socketMsgCache = [];
                    self.onclose(evt);
                };
                ws.onerror = function (err) {
                    self.isOpening = false;
                    self.socketingWS = null;
                    self.socketMsgCache = [];
                    self.onerror(err);
                };
            }
        }
        set isAutoClearCache(value) {
            if (value == this._isAutoClearCache) {
                return;
            }
            this._isAutoClearCache = value;
            if (this._isAutoClearCache) {
                this.intervalId = setInterval(() => {
                    this.clearCache();
                }, 30);
            }
            else {
                clearInterval(this.intervalId);
            }
        }
        close(code, reason) {
            if (this.isOpening && this.socketingWS) {
                this.socketingWS.close();
                this.isOpening = false;
                this.socketingWS = null;
            }
        }
        send(msg) {
            if (!this.socketingWS) {
                return;
            }
            let ietm = null;
            try {
                ietm = JSON.stringify(msg);
            }
            catch (error) {
                ietm = JSON.stringify({
                    type: 3,
                    data: error
                });
            }
            finally {
                if (!this.isOpening || this._isAutoClearCache) {
                    this.socketMsgCache.push(ietm);
                    this.isAutoClearCache = true;
                }
                else {
                    this.socketingWS.send(ietm);
                }
            }
        }
        clearCache() {
            if (!this.socketingWS || !this.socketMsgCache.length) {
                this.isAutoClearCache = false;
                return;
            }
            if (this.isOpening) {
                let item = this.socketMsgCache.shift();
                this.socketingWS.send(item);
            }
        }
    }

    class ULTools {
        static time() {
            let time = new Date().getTime() / 1000;
            return time;
        }
        static timeInDay() {
            let time = this.time();
            let todayBeginDate = new Date(time * 1000);
            todayBeginDate.setHours(0);
            todayBeginDate.setMinutes(0);
            todayBeginDate.setSeconds(0);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            return time - todayBeginTime;
        }
        static timeDay(time = this.time()) {
            let todayBeginDate = new Date(time * 1000);
            todayBeginDate.setHours(0);
            todayBeginDate.setMinutes(0);
            todayBeginDate.setSeconds(0);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            return todayBeginTime;
        }
        static timeDayHour(hours = 0, minutes = 0, seconds = 0) {
            let todayBeginDate = new Date();
            todayBeginDate.setHours(hours);
            todayBeginDate.setMinutes(minutes);
            todayBeginDate.setSeconds(seconds);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            if (this.time() > todayBeginTime) {
                todayBeginTime += 60 * 60 * 24;
            }
            return todayBeginTime;
        }
        static isOneDay(seconds1, seconds2) {
            var d1 = new Date(seconds1 * 1000);
            var d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate();
        }
        static isOneMonth(seconds1, seconds2) {
            var d1 = new Date(seconds1 * 1000);
            var d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth();
        }
        static getObjSize(obj) {
            if (!obj) {
                return 0;
            }
            if (Array.isArray(obj)) {
                return obj.length;
            }
            let count = 0;
            this.forEachMap(obj, (k, v) => {
                count++;
            });
            return count;
        }
        static parseUrl(url) {
            var r = {
                protocol: /([^\/]+:)\/\/(.*)/i,
                host: /(^[^\:\/]+)((?:\/|:|$)?.*)/,
                port: /\:?([^\/]*)(\/?.*)/,
                pathname: /([^\?#]+)(\??[^#]*)(#?.*)/
            };
            var tmp = {};
            var res = {
                href: url,
                protocol: "",
                host: "",
                port: "",
                pathname: "",
                search: "",
                hash: ""
            };
            for (let p in r) {
                tmp = r[p].exec(url);
                res[p] = tmp[1];
                url = tmp[2];
                if (url === "") {
                    url = "/";
                }
                if (p === "pathname") {
                    res.pathname = tmp[1];
                    res.search = tmp[2];
                    res.hash = tmp[3];
                }
            }
            return res;
        }
        static random(min, max) {
            if (min == null && max == null) {
                return Math.random();
            }
            else if (max == null) {
                return Math.floor(Math.random() * min + 1);
            }
            else {
                return Math.floor(Math.random() * (max - min + 1) + min);
            }
        }
        static scaleInRange(n, ia, ib, oa, ob) {
            if (ia < ib) {
                if (n < ia)
                    n = ia;
                if (n > ib)
                    n = ib;
            }
            else {
                if (n < ib)
                    n = ib;
                if (n > ia)
                    n = ia;
            }
            let iDistance = ib - ia;
            let oDistance = ob - oa;
            return (n - ia) / iDistance * oDistance + oa;
        }
        static clampf(n, min, max) {
            if (n < min)
                return min;
            if (n > max)
                return max;
            return n;
        }
        static calcWheelTarget(arr, weightKey) {
            let totalWeight = 0;
            for (let i = 0; i < arr.length; i++) {
                const v = arr[i];
                let w = parseInt(v[weightKey]);
                if (isNaN(w)) {
                    ULLog.console.warn(this.format("Tools.calcWheelTarget weight field not found! key=[%s]", weightKey));
                    return null;
                }
                totalWeight += w;
            }
            let rw = this.random(totalWeight);
            for (let i = 0; i < arr.length; i++) {
                const v = arr[i];
                let w = parseInt(v[weightKey]);
                if (rw <= w) {
                    return v;
                }
                else {
                    rw -= w;
                }
            }
            return null;
        }
        static sortArrayByField(array, fields) {
            if (typeof (fields) == "string") {
                fields = [fields];
            }
            else {
                fields = fields;
            }
            let fieldConfig = [];
            for (let k in fields) {
                let v = fields[k];
                if (v && v != "") {
                    if (v.substring(0, 1) === "-") {
                        let tmpField = v.substring(1, v.length);
                        if (tmpField && tmpField != "") {
                            fieldConfig.push([tmpField, true]);
                        }
                    }
                    else {
                        fieldConfig.push([v, false]);
                    }
                }
            }
            let sorter = (a, b) => {
                let ret = 0;
                for (let k in fieldConfig) {
                    let v = fieldConfig[k];
                    let field = v[0];
                    let desc = v[1];
                    let v1 = a[field];
                    let v2 = b[field];
                    if (v1 != null) {
                        if (desc) {
                            ret = v2 - v1;
                        }
                        else {
                            ret = v1 - v2;
                        }
                        if (ret != 0) {
                            return ret;
                        }
                    }
                }
                return ret;
            };
            let sorted = [];
            for (let i = 0; i < array.length; i++) {
                const v = array[i];
                sorted.push(v);
            }
            sorted.sort(sorter);
            return sorted;
        }
        static bubbleSort(arr, sorter) {
            var len = arr.length;
            for (var i = 0; i < len; i++) {
                for (var j = 0; j < len - 1 - i; j++) {
                    let ret = sorter(arr[j], arr[j + 1]);
                    if (ret > 0) {
                        var temp = arr[j + 1];
                        arr[j + 1] = arr[j];
                        arr[j] = temp;
                    }
                }
            }
            return arr;
        }
        static forEachMap(map, callback) {
            if (!map)
                return;
            let keys = Object.keys(map);
            for (let i = 0; i < keys.length; i++) {
                let key = keys[i];
                let value = map[key];
                if (value != null) {
                    if (callback(key, value))
                        break;
                }
            }
        }
        static formatTime(time, format) {
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.ceil(time) % 60;
            if (format.match("%h")) {
                format = format.replace("%h", hour.toString());
            }
            if (format.match("%H")) {
                format = format.replace("%H", this.format("%02d", hour));
            }
            if (format.match("%m")) {
                format = format.replace("%m", minute.toString());
            }
            if (format.match("%M")) {
                format = format.replace("%M", this.format("%02d", minute));
            }
            if (format.match("%s")) {
                format = format.replace("%s", second.toString());
            }
            if (format.match("%S")) {
                format = format.replace("%S", this.format("%02d", second));
            }
            return format;
        }
        static formatDate(date, format) {
            let o = {
                "M+": date.getMonth() + 1,
                "d+": date.getDate(),
                "H+": date.getHours(),
                "m+": date.getMinutes(),
                "s+": date.getSeconds(),
                "q+": Math.floor((date.getMonth() + 3) / 3),
                "S+": date.getMilliseconds()
            };
            let fmt = format;
            if (/(y+)/.test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
            }
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(fmt)) {
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                }
            }
            return fmt;
        }
        static generateUUID() {
            let d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }
        ;
        static compressUuid(uuid) {
            let hexChars = "0123456789abcdef".split("");
            let hexMap = {};
            for (let i = 0; i < hexChars.length; i++) {
                hexMap[hexChars[i]] = i;
            }
            let base64KeyToChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".split("");
            let base64CharToKey = {};
            for (let i = 0; i < base64KeyToChars.length; i++) {
                base64CharToKey[base64KeyToChars[i]] = i;
            }
            uuid = uuid.replace(/-/g, "");
            let arr = uuid.split("");
            let outArr = [];
            outArr.push(arr[0]);
            outArr.push(arr[1]);
            for (let i = 2; i < arr.length; i += 3) {
                let hex1 = hexMap[arr[i]];
                let hex2 = hexMap[arr[i + 1]];
                let hex3 = hexMap[arr[i + 2]];
                outArr.push(base64KeyToChars[(hex1 << 2) | (hex2 >> 2)]);
                outArr.push(base64KeyToChars[((hex2 & 3) << 4) | hex3]);
            }
            return outArr.join("");
        }
        static decompressUuid(uuid) {
            let arr = uuid.split("");
            if (arr.length < 22)
                return uuid;
            let hexChars = "0123456789abcdef".split("");
            let hexMap = {};
            for (let i = 0; i < hexChars.length; i++) {
                hexMap[hexChars[i]] = i;
            }
            let base64KeyToChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".split("");
            let base64CharToKey = {};
            for (let i = 0; i < base64KeyToChars.length; i++) {
                base64CharToKey[base64KeyToChars[i]] = i;
            }
            let outArr = [];
            outArr.push(arr[0]);
            outArr.push(arr[1]);
            for (let i = 2; i < arr.length; i += 2) {
                let lhs = base64CharToKey[arr[i]];
                let rhs = base64CharToKey[arr[i + 1]];
                outArr.push(hexChars[lhs >> 2]);
                outArr.push(hexChars[((lhs & 3) << 2) | rhs >> 4]);
                outArr.push(hexChars[rhs & 0xF]);
            }
            outArr.splice(8, 0, "-");
            outArr.splice(13, 0, "-");
            outArr.splice(18, 0, "-");
            outArr.splice(23, 0, "-");
            return outArr.join("");
        }
        static getType(obj) {
            let toString = Object.prototype.toString;
            let map = {
                '[object Boolean]': 'boolean',
                '[object Number]': 'number',
                '[object String]': 'string',
                '[object Function]': 'function',
                '[object Array]': 'array',
                '[object Date]': 'date',
                '[object RegExp]': 'regExp',
                '[object Undefined]': 'undefined',
                '[object Null]': 'null',
                '[object Object]': 'object'
            };
            return map[toString.call(obj)];
        }
        static clone(data) {
            let type = this.getType(data);
            let obj;
            if (window["cc"] && window["cc"].Node && data instanceof window["cc"].Node) {
                return data;
            }
            else if (type === 'object') {
                obj = {};
            }
            else if (type === 'array') {
                obj = [];
            }
            else {
                return data;
            }
            if (type === 'array') {
                for (let i = 0, len = data["length"]; i < len; i++) {
                    obj.push(this.clone(data[i]));
                }
            }
            else if (type === 'object') {
                for (let key in data) {
                    obj[key] = this.clone(data[key]);
                }
            }
            return obj;
        }
        static toArray(arr) {
            if (Array.isArray(arr))
                return arr;
            return [];
        }
        static sumNumberArray(arr) {
            if (!Array.isArray(arr))
                return 0;
            let sum = 0;
            for (let i = 0; i < arr.length; i++) {
                const n = arr[i];
                if (isNaN(n))
                    continue;
                sum += n;
            }
            return sum;
        }
        static getRandomValueInArray(arr) {
            if (!Array.isArray(arr))
                return null;
            return arr[this.random(arr.length) - 1];
        }
        static _convert(match, nosign) {
            if (nosign) {
                match.sign = '';
            }
            else {
                match.sign = match.negative ? '-' : match.sign;
            }
            var l = match.min - match.argument.length + 1 - match.sign.length;
            var pad = new Array(l < 0 ? 0 : l).join(match.pad);
            if (!match.left) {
                if (match.pad == "0" || nosign) {
                    return match.sign + pad + match.argument;
                }
                else {
                    return pad + match.sign + match.argument;
                }
            }
            else {
                if (match.pad == "0" || nosign) {
                    return match.sign + match.argument + pad.replace(/0/g, ' ');
                }
                else {
                    return match.sign + match.argument + pad;
                }
            }
        }
        static format(...args) {
            if (typeof arguments == "undefined") {
                return null;
            }
            if (arguments.length < 1) {
                return null;
            }
            if (typeof arguments[0] != "string") {
                return null;
            }
            if (typeof RegExp == "undefined") {
                return null;
            }
            var string = arguments[0];
            var exp = new RegExp(/(%([%]|(\-)?(\+|\x20)?(0)?(\d+)?(\.(\d)?)?([bcdfosxX])))/g);
            var matches = new Array();
            var strings = new Array();
            var convCount = 0;
            var stringPosStart = 0;
            var stringPosEnd = 0;
            var matchPosEnd = 0;
            var newString = '';
            var match = null;
            while (match = exp.exec(string)) {
                if (match[9]) {
                    convCount += 1;
                }
                stringPosStart = matchPosEnd;
                stringPosEnd = exp.lastIndex - match[0].length;
                strings[strings.length] = string.substring(stringPosStart, stringPosEnd);
                matchPosEnd = exp.lastIndex;
                matches[matches.length] = {
                    match: match[0],
                    left: match[3] ? true : false,
                    sign: match[4] || '',
                    pad: match[5] || ' ',
                    min: match[6] || 0,
                    precision: match[8],
                    code: match[9] || '%',
                    negative: parseInt(arguments[convCount]) < 0 ? true : false,
                    argument: String(arguments[convCount])
                };
            }
            strings[strings.length] = string.substring(matchPosEnd);
            if (matches.length == 0) {
                return string;
            }
            if ((arguments.length - 1) < convCount) {
                return null;
            }
            var code = null;
            var match = null;
            var substitution = null;
            var i = null;
            for (i = 0; i < matches.length; i++) {
                if (matches[i].code == '%') {
                    substitution = '%';
                }
                else if (matches[i].code == 'b') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(2));
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'c') {
                    matches[i].argument = String(String.fromCharCode(Math.abs(parseInt(matches[i].argument))));
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'd') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'f') {
                    matches[i].argument = String(Math.abs(parseFloat(matches[i].argument)).toFixed(matches[i].precision ? matches[i].precision : 6));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'o') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(8));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 's') {
                    matches[i].argument = matches[i].argument.substring(0, matches[i].precision ? matches[i].precision : matches[i].argument.length);
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'x') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'X') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                    substitution = this._convert(matches[i]).toUpperCase();
                }
                else {
                    substitution = matches[i].match;
                }
                newString += strings[i];
                newString += substitution;
            }
            newString += strings[i];
            return newString;
        }
        static httpGet(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (typeof (responseData) == "object")
                            responseData = JSON.stringify(responseData);
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        if (xhr) {
                            ULLog.console.warn("ULTools.httpGet on error:", xhr.readyState, xhr.status);
                            if (obj.fail instanceof Function)
                                obj.fail(xhr.status.toString());
                            let temp = xhr;
                            xhr = null;
                            temp.abort();
                        }
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('get', obj.url);
            xhr.send();
        }
        static httpGetJson(obj) {
            let arr = [];
            this.forEachMap(obj.params, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let paramString = arr.join('&');
            let trimUrl = `${obj.url}?${paramString}`;
            ULLog.console.log("ULTools.httpGetJson trimUrl:", trimUrl);
            this.httpGet({
                url: trimUrl,
                timeoutMillisecond: obj.timeoutMillisecond,
                success: obj.success,
                fail: obj.fail
            });
        }
        static httpPost(obj) {
            obj.contentType = obj.contentType || "application/x-www-form-urlencoded;charset=utf-8";
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (typeof (responseData) == "object")
                            responseData = JSON.stringify(responseData);
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        ULLog.console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader('Content-Type', obj.contentType);
            let requestHeader = obj.requestHeader;
            if (requestHeader) {
                Object.keys(requestHeader).forEach(element => {
                    xhr.setRequestHeader(element, requestHeader[element]);
                });
            }
            xhr.send(obj.postData);
        }
        static httpPostJson(obj) {
            let arr = [];
            this.forEachMap(obj.params, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let paramString = arr.join('&');
            ULLog.console.log("ULTools.httpPostJson paramString:", paramString);
            this.httpPost({
                url: obj.url,
                postData: paramString,
                timeoutMillisecond: obj.timeoutMillisecond,
                success: obj.success,
                fail: obj.fail
            });
        }
        static httpPostFormData(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (typeof (responseData) == "object")
                            responseData = JSON.stringify(responseData);
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        ULLog.console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.send(obj.formData);
        }
        static httpPostEncryption(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (typeof (responseData) == "object")
                            responseData = JSON.stringify(responseData);
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            let byteArray = this.stringToByte(obj.postString);
            let key = byteArray.length % 127 || 127;
            var myArray = new ArrayBuffer(byteArray.length);
            var longInt8View = new Uint8Array(myArray);
            for (let i = 0; i < byteArray.length; i++) {
                byteArray[i] = byteArray[i] ^ key;
                longInt8View[i] = byteArray[i];
            }
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader('isEncrypt', "1");
            xhr.setRequestHeader('Content-Type', "application/octet-stream");
            let requestHeader = obj.requestHeader;
            if (requestHeader) {
                Object.keys(requestHeader).forEach(element => {
                    xhr.setRequestHeader(element, requestHeader[element]);
                });
            }
            xhr.send(myArray);
        }
        static httpJsonp(obj) {
            if (!obj || !obj.url) {
                throw new Error("参数不合法");
            }
            let callbackName = ULTools.format("jsonp_%d", ULTools.random(1000000));
            obj.data.callback = callbackName;
            let oHead = document.getElementsByTagName('head')[0];
            let arr = [];
            this.forEachMap(obj.data, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let params = arr.join('&');
            let oS = document.createElement('script');
            oHead.appendChild(oS);
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (!window[callbackName])
                    return;
                window[callbackName] = null;
                oHead.removeChild(oS);
                obj.fail && obj.fail("timeout");
            });
            window[callbackName] = function (json) {
                if (!window[callbackName])
                    return;
                oHead.removeChild(oS);
                timeoutTimer.stop();
                window[callbackName] = null;
                obj.success && obj.success(json);
            };
            oS.src = obj.url + '?' + params;
        }
        static method() {
            return new Promise((resolve, reject) => {
                reject("eee");
            });
        }
        static _start_console_print_LAN() {
            if (ULTools.socketingWS) {
                return Promise.resolve();
            }
            let lan_debug_address_default = ULConfig.getConfig().s_sdk_lan_debug_address.length > 10 ? ULConfig.getConfig().s_sdk_lan_debug_address : "";
            let lan_id = localStorage.getItem("console_lan_id") || ULStorageManager.getInstance().getStorage("console_lan_id") || lan_debug_address_default;
            ULLog.console.log('console_lan_id:', lan_id);
            if (lan_id && lan_id.length && "WebSocket" in window) {
                ULLog.console.log("支持WebSocket局域网调试");
                var address = `ws://${lan_id}:3002/websocket/test`;
                var ws = null;
                let promise = Promise.resolve();
                try {
                    ws = new ULWebSocket(address);
                    ws.onopen = function () {
                        ULLog.console.log("Connection open ...");
                        ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("console_lan_id", "已开启局域网调试");
                    };
                    ws.onmessage = function (evt) {
                        ULLog.console.log("Received Message:" + evt.data);
                    };
                    ws.onclose = function () {
                        ULLog.console.log("Connection closed");
                        ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("console_lan_id");
                        ULTools.socketingWS = null;
                        ULTools._hack_console_print_method();
                    };
                    ws.onerror = function (err) {
                        ULLog.console.error("Connection onerror:", err);
                        ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("console_lan_id");
                        ULTools.socketingWS = null;
                        ULTools._hack_console_print_method();
                    };
                }
                catch (error) {
                    ws = null;
                    ULLog.console.log("局域网调试错误:", JSON.stringify(error));
                    promise = Promise.reject(`局域网调试错误(包含域名白名单渠道无法使用):${JSON.stringify(error)}`);
                }
                finally {
                    if (ws == null) {
                        return;
                    }
                    ULTools.socketingWS = ws;
                    ULTools._hack_console_print_method();
                }
                return promise;
            }
            else {
                ULLog.console.log("不支持WebSocket局域网调试");
                return Promise.reject("不支持WebSocket局域网调试");
            }
        }
        static _close_console_print_LAN() {
            if (ULTools.socketingWS) {
                ULTools.socketingWS.close();
                ULTools.socketingWS = null;
                ULTools._hack_console_print_method();
            }
        }
        static loadJs(url, fOnSuccess, bCrossOriginAnonymous) {
            let script = document.createElement('script');
            script.type = "text/javascript";
            script.addEventListener('load', (e) => {
                if (fOnSuccess instanceof Function)
                    fOnSuccess();
            });
            script.src = url;
            script.defer = "defer";
            if (bCrossOriginAnonymous) {
                script.crossOrigin = "anonymous";
            }
            let head = document.getElementsByTagName('head')[0];
            head.appendChild(script);
        }
        static stringToByte(str) {
            var bytes = new Array();
            var len, c;
            len = str.length;
            for (var i = 0; i < len; i++) {
                c = str.charCodeAt(i);
                if (c >= 0x010000 && c <= 0x10FFFF) {
                    bytes.push(((c >> 18) & 0x07) | 0xF0);
                    bytes.push(((c >> 12) & 0x3F) | 0x80);
                    bytes.push(((c >> 6) & 0x3F) | 0x80);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else if (c >= 0x000800 && c <= 0x00FFFF) {
                    bytes.push(((c >> 12) & 0x0F) | 0xE0);
                    bytes.push(((c >> 6) & 0x3F) | 0x80);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else if (c >= 0x000080 && c <= 0x0007FF) {
                    bytes.push(((c >> 6) & 0x1F) | 0xC0);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else {
                    bytes.push(c & 0xFF);
                }
            }
            return bytes;
        }
        static byteToString(arr) {
            if (typeof arr === 'string') {
                return arr;
            }
            var str = '', _arr = arr;
            for (var i = 0; i < _arr.length; i++) {
                var one = _arr[i].toString(2), v = one.match(/^1+?(?=0)/);
                if (v && one.length == 8) {
                    var bytesLength = v[0].length;
                    var store = _arr[i].toString(2).slice(7 - bytesLength);
                    for (var st = 1; st < bytesLength; st++) {
                        store += _arr[st + i].toString(2).slice(2);
                    }
                    str += String.fromCharCode(parseInt(store, 2));
                    i += bytesLength - 1;
                }
                else {
                    str += String.fromCharCode(_arr[i]);
                }
            }
            return str;
        }
        static getQueryString(name) {
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
            var r = window.location.search.substr(1).match(reg);
            if (r != null) {
                return decodeURI(r[2]);
            }
            return null;
        }
        static createRandomString(len) {
            len = len || 32;
            let $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz123456789';
            let maxPos = $chars.length;
            let pwd = '';
            for (let i = 0; i < len; i++) {
                pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
            }
            return pwd;
        }
        static createRandomUserId() {
            let longUuid = this.generateUUID();
            let shortUuid = this.compressUuid(longUuid);
            return shortUuid;
        }
        static createRandomOrderId() {
            let t = new Date().getTime();
            return t + this.createRandomString(7);
        }
        static compareVersion(v1, v2) {
            let arr1 = v1.split('.');
            let arr2 = v2.split('.');
            const len = Math.max(arr1.length, arr2.length);
            while (arr1.length < len) {
                arr1.push('0');
            }
            while (arr2.length < len) {
                arr2.push('0');
            }
            for (let i = 0; i < len; i++) {
                const num1 = parseInt(arr1[i]);
                const num2 = parseInt(arr2[i]);
                if (num1 > num2) {
                    return 1;
                }
                else if (num1 < num2) {
                    return -1;
                }
            }
            return 0;
        }
        static _hack_console_print_method() {
            if (!this._origin_console_log)
                this._origin_console_log = console.log;
            if (!this._origin_console_warn)
                this._origin_console_warn = console.warn;
            if (!this._origin_console_error)
                this._origin_console_error = console.error;
            if (window["cc"] && window["cc"].Node) {
                if (!this._origin_cc_log)
                    this._origin_cc_log = window["cc"]["log"];
                if (!this._origin_cc_warn)
                    this._origin_cc_warn = window["cc"]["warn"];
                if (!this._origin_cc_error)
                    this._origin_cc_error = window["cc"]["error"];
            }
            let trim_console_func = function (type, callback) {
                let trimFunc = function (...data) {
                    callback(...data);
                    if (ULTools.socketingWS) {
                        ULTools.socketingWS.send({
                            type: type,
                            data: data
                        });
                    }
                };
                return trimFunc;
            };
            let config = ULConfig.getConfig();
            console.log = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_LOG ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_console_log) : this._origin_console_log));
            console.warn = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_WARN ? () => { } : (ULTools.socketingWS ? trim_console_func(2, this._origin_console_warn) : this._origin_console_warn));
            console.error = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_ERROR ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_console_error) : this._origin_console_error));
            if (window["cc"] && window["cc"].Node) {
                window["cc"]["log"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_LOG ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_cc_log) : this._origin_cc_log));
                window["cc"]["warn"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_WARN ? () => { } : (ULTools.socketingWS ? trim_console_func(2, this._origin_cc_warn) : this._origin_cc_warn));
                window["cc"]["error"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_ERROR ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_cc_error) : this._origin_cc_error));
            }
        }
        static jsonValToStr(oldJson) {
            if (!oldJson) {
                return oldJson;
            }
            let targetJson = {};
            let keys = Object.keys(oldJson);
            for (let i = 0; i < keys.length; i++) {
                let key = keys[i];
                let value = oldJson[key];
                if (typeof (value) == "object") {
                    value = JSON.stringify(value);
                }
                else {
                    value = String(value);
                }
                targetJson[key] = value;
            }
            return targetJson;
        }
        static calcWheelTargetByArray(array, maxWeight) {
            let totalWeight = 0;
            for (let i = 0; i < array.length; i++) {
                totalWeight += array[i];
            }
            if (maxWeight != 0) {
                totalWeight = Math.min(totalWeight, maxWeight);
            }
            let random = (Math.random() * totalWeight);
            let sum = 0;
            for (let i = 0; i < array.length; i++) {
                sum += array[i];
                if (sum > random) {
                    return i;
                }
            }
            return null;
        }
        static recordVideoTimeLimit(type, recordDuration) {
            let duration_limit_object = ULConfig.getConfig().t_sdk_record_duration_limit_object || {};
            let tirm_type = (typeof (type) == "string") ? type : (typeof (type) == "number") ? type.toString() : "";
            let type_Object = duration_limit_object[tirm_type] || duration_limit_object["*"] || {};
            let limit_min = type_Object.min || 0;
            let limit_max = type_Object.max || 10000;
            if (limit_min > recordDuration) {
                return { isConform: false, msg: `录屏时间少于${limit_min}秒` };
            }
            else if (limit_max < recordDuration) {
                return { isConform: false, msg: `录屏时间大于${limit_max}秒` };
            }
            return { isConform: true, msg: "" };
        }
        static substrFromByte(str, byteNum) {
            let trimNum = byteNum;
            let trimStrAry = str.split("");
            let cutStr = "";
            while (trimStrAry.length && trimNum > 0) {
                let firstItem = trimStrAry.shift();
                let bytes = ULTools.stringToByte(firstItem);
                trimNum = trimNum - bytes.length;
                if (trimNum >= 0) {
                    cutStr += firstItem;
                }
                else {
                    trimStrAry.unshift(firstItem);
                }
            }
            return { remainStr: trimStrAry.join(""), cutStr: cutStr };
        }
        static isLayaEngine() {
            if (window["Laya"])
                return true;
            return false;
        }
        static startsWith(str, startStr) {
            var sliceStr = str.slice(0, Math.min(str.length, startStr.length));
            return sliceStr == startStr;
        }
        ;
        static isCreator2xEngine() {
            if (window["cc"] && window["cc"].ENGINE_VERSION && this.startsWith(window["cc"].ENGINE_VERSION, "2.")) {
                return true;
            }
            return false;
        }
        static isCreator3xEngine() {
            if (window["cc"] && window["cc"].ENGINE_VERSION && this.startsWith(window["cc"].ENGINE_VERSION, "3.")) {
                return true;
            }
            return false;
        }
        static isString(obj) {
            let type = ULTools.getType(obj);
            return type == "string";
        }
        static isNumber(obj) {
            let type = ULTools.getType(obj);
            return type == "number";
        }
        static isStringOrNumber(obj) {
            let type = ULTools.getType(obj);
            return type == "number" || type == "string";
        }
        static isObject(obj) {
            let type = ULTools.getType(obj);
            return type == "object";
        }
        static isArray(obj) {
            let type = ULTools.getType(obj);
            return type == "array";
        }
        static isFunc(obj) {
            let type = ULTools.getType(obj);
            return type == "function";
        }
        static getStringValue(obj, key, defaultValue = "") {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isStringOrNumber(value))
                    return value.toString();
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isStringOrNumber(value))
                        return value.toString();
                }
            }
            return defaultValue;
        }
        static getNumberValue(obj, key, defaultValue = 0) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isStringOrNumber(value))
                    return !isNaN(Number(value)) ? Number(value) : defaultValue;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = obj[key];
                    if (ULTools.isStringOrNumber(value))
                        return !isNaN(Number(value)) ? Number(value) : defaultValue;
                }
            }
            return defaultValue;
        }
        static getArrayValue(obj, key, defaultValue = []) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isArray(value))
                    return value;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isArray(value))
                        return value;
                }
            }
            return defaultValue;
        }
        static getObjectValue(obj, key, defaultValue = {}) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isObject(value))
                    return value;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isObject(value))
                        return value;
                }
            }
            return defaultValue;
        }
        static randomChinese(length = 10) {
            const randomLength = Math.floor(Math.random() * length) + 1;
            let result = '';
            for (let i = 0; i < randomLength; i++) {
                const random = Math.floor(Math.random() * (0x9fa5 - 0x4e00 + 1)) + 0x4e00;
                result += String.fromCharCode(random);
            }
            return result;
        }
        static getCommonHost() {
            let result = "u";
            result += "l";
            result += "t";
            result += "r";
            result += "a";
            result += "l";
            result += "i";
            result += "s";
            result += "k";
            return result;
        }
        static judgeSubscribeHours(oldValue, hours) {
            let currentTime = new Date();
            let currentHour = currentTime.getHours();
            let nextHour = currentHour + 1;
            let nextHourDate = new Date();
            nextHourDate.setHours(nextHour);
            nextHourDate.setMinutes(0);
            nextHourDate.setSeconds(0);
            nextHourDate.setMilliseconds(0);
            let nextHourTimeNumber = nextHourDate.getTime();
            let oldTime = Number(oldValue || "0");
            if (!isNaN(oldTime)) {
                var span = nextHourTimeNumber - oldTime;
                if (span >= 0 && span <= (hours * 60 * 60 * 1000)) {
                    return oldValue;
                }
            }
            return nextHourTimeNumber.toString();
        }
        static areObjectsEqual(obj1, obj2) {
            if (obj1 === obj2)
                return true;
            if (!ULTools.isObject(obj1) || !ULTools.isObject(obj2)) {
                return false;
            }
            const keys1 = Object.keys(obj1);
            const keys2 = Object.keys(obj2);
            if (keys1.length !== keys2.length) {
                return false;
            }
            for (let key of keys1) {
                if (!obj2.hasOwnProperty(key) || !ULTools.areObjectsEqual(obj1[key], obj2[key])) {
                    return false;
                }
            }
            return true;
        }
        static sha1(message) {
            const K = [0x5A827999, 0x6ED9EBA1, 0x8F1BBCDC, 0xCA62C1D6];
            let h0 = 0x67452301;
            let h1 = 0xEFCDAB89;
            let h2 = 0x98BADCFE;
            let h3 = 0x10325476;
            let h4 = 0xC3D2E1F0;
            const messageBytes = ULTools.toBytes(message);
            const originalLength = messageBytes.length * 8;
            messageBytes.push(0x80);
            while ((messageBytes.length * 8) % 512 !== 448) {
                messageBytes.push(0);
            }
            for (let i = 7; i >= 0; i--) {
                messageBytes.push((originalLength >>> (i * 8)) & 0xFF);
            }
            for (let i = 0; i < messageBytes.length; i += 64) {
                const chunk = messageBytes.slice(i, i + 64);
                const words = new Array(80);
                for (let j = 0; j < 16; j++) {
                    words[j] =
                        (chunk[j * 4] << 24) |
                            (chunk[j * 4 + 1] << 16) |
                            (chunk[j * 4 + 2] << 8) |
                            chunk[j * 4 + 3];
                }
                for (let j = 16; j < 80; j++) {
                    words[j] = ULTools.leftRotate(words[j - 3] ^ words[j - 8] ^ words[j - 14] ^ words[j - 16], 1);
                }
                let a = h0;
                let b = h1;
                let c = h2;
                let d = h3;
                let e = h4;
                for (let j = 0; j < 80; j++) {
                    const f = j < 20 ? (b & c) | (~b & d)
                        : j < 40 ? b ^ c ^ d
                            : j < 60 ? (b & c) | (b & d) | (c & d)
                                : b ^ c ^ d;
                    const temp = (ULTools.leftRotate(a, 5) + f + e + K[Math.floor(j / 20)] + words[j]) >>> 0;
                    e = d;
                    d = c;
                    c = ULTools.leftRotate(b, 30);
                    b = a;
                    a = temp;
                }
                h0 = (h0 + a) >>> 0;
                h1 = (h1 + b) >>> 0;
                h2 = (h2 + c) >>> 0;
                h3 = (h3 + d) >>> 0;
                h4 = (h4 + e) >>> 0;
            }
            return [h0, h1, h2, h3, h4].map(n => ('00000000' + n.toString(16)).slice(-8)).join('');
        }
        static sha256(message) {
            const K = [
                0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
                0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
                0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
                0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
                0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
                0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
                0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
                0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2
            ];
            let h0 = 0x6a09e667;
            let h1 = 0xbb67ae85;
            let h2 = 0x3c6ef372;
            let h3 = 0xa54ff53a;
            let h4 = 0x510e527f;
            let h5 = 0x9b05688c;
            let h6 = 0x1f83d9ab;
            let h7 = 0x5be0cd19;
            const messageBytes = ULTools.toBytes(message);
            const originalLength = messageBytes.length * 8;
            messageBytes.push(0x80);
            while ((messageBytes.length * 8) % 512 !== 448) {
                messageBytes.push(0);
            }
            for (let i = 7; i >= 0; i--) {
                messageBytes.push((originalLength >>> (i * 8)) & 0xFF);
            }
            for (let i = 0; i < messageBytes.length; i += 64) {
                const chunk = messageBytes.slice(i, i + 64);
                const words = new Array(64);
                for (let j = 0; j < 16; j++) {
                    words[j] =
                        (chunk[j * 4] << 24) |
                            (chunk[j * 4 + 1] << 16) |
                            (chunk[j * 4 + 2] << 8) |
                            chunk[j * 4 + 3];
                }
                for (let j = 16; j < 64; j++) {
                    const s0 = ULTools.rightRotate(words[j - 15], 7) ^ ULTools.rightRotate(words[j - 15], 18) ^ (words[j - 15] >>> 3);
                    const s1 = ULTools.rightRotate(words[j - 2], 17) ^ ULTools.rightRotate(words[j - 2], 19) ^ (words[j - 2] >>> 10);
                    words[j] = (words[j - 16] + s0 + words[j - 7] + s1) >>> 0;
                }
                let a = h0;
                let b = h1;
                let c = h2;
                let d = h3;
                let e = h4;
                let f = h5;
                let g = h6;
                let h = h7;
                for (let j = 0; j < 64; j++) {
                    const S1 = ULTools.rightRotate(e, 6) ^ ULTools.rightRotate(e, 11) ^ ULTools.rightRotate(e, 25);
                    const ch = (e & f) ^ (~e & g);
                    const temp1 = (h + S1 + ch + K[j] + words[j]) >>> 0;
                    const S0 = ULTools.rightRotate(a, 2) ^ ULTools.rightRotate(a, 13) ^ ULTools.rightRotate(a, 22);
                    const maj = (a & b) ^ (a & c) ^ (b & c);
                    const temp2 = (S0 + maj) >>> 0;
                    h = g;
                    g = f;
                    f = e;
                    e = (d + temp1) >>> 0;
                    d = c;
                    c = b;
                    b = a;
                    a = (temp1 + temp2) >>> 0;
                }
                h0 = (h0 + a) >>> 0;
                h1 = (h1 + b) >>> 0;
                h2 = (h2 + c) >>> 0;
                h3 = (h3 + d) >>> 0;
                h4 = (h4 + e) >>> 0;
                h5 = (h5 + f) >>> 0;
                h6 = (h6 + g) >>> 0;
                h7 = (h7 + h) >>> 0;
            }
            return [h0, h1, h2, h3, h4, h5, h6, h7].map(n => ('00000000' + n.toString(16)).slice(-8)).join('');
        }
        static rightRotate(value, shift) {
            return (value >>> shift) | (value << (32 - shift));
        }
        static toBytes(message) {
            const bytes = [];
            for (let i = 0; i < message.length; i++) {
                bytes.push(message.charCodeAt(i));
            }
            return bytes;
        }
        static leftRotate(value, shift) {
            return (value << shift) | (value >>> (32 - shift));
        }
        static hmacSha1(message, secret) {
            const blockSize = 64;
            const opad = 0x5C;
            const ipad = 0x36;
            let key = ULTools.toBytes(secret);
            if (key.length > blockSize) {
                key = ULTools.toBytes(ULTools.sha1(secret));
            }
            while (key.length < blockSize) {
                key.push(0);
            }
            const oKeyPad = key.map(b => b ^ opad);
            const iKeyPad = key.map(b => b ^ ipad);
            const innerHash = ULTools.sha1(ULTools.byteArrayToString(iKeyPad) + message);
            return ULTools.sha1(ULTools.byteArrayToString(oKeyPad) + innerHash);
        }
        static hmacSha256(message, secret) {
            const blockSize = 64;
            const opad = 0x5C;
            const ipad = 0x36;
            let key = ULTools.toBytes(secret);
            if (key.length > blockSize) {
                key = ULTools.toBytes(ULTools.sha256(secret));
            }
            while (key.length < blockSize) {
                key.push(0);
            }
            const oKeyPad = key.map(b => b ^ opad);
            const iKeyPad = key.map(b => b ^ ipad);
            const innerHash = ULTools.sha256(ULTools.byteArrayToString(iKeyPad) + message);
            return ULTools.sha256(ULTools.byteArrayToString(oKeyPad) + innerHash);
        }
        static byteArrayToString(bytes) {
            return bytes.map(byte => String.fromCharCode(byte)).join('');
        }
        static removeElement(array, element) {
            return array.filter(item => item !== element);
        }
    }
    ULTools.socketingWS = null;

    class ULConfig {
        static init() {
            this.bInit = true;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        static getConfig() {
            if (!this.bInit) {
                this.init();
            }
            if (!this.currConfig) {
                this.currConfig = ULTools.clone(cConfig);
            }
            return this.currConfig;
        }
        static get(key) {
            let config = this.getConfig();
            let value = config[key];
            return value;
        }
        static updateConfig(cop) {
            let newConfig = ULConfig.getConfig();
            ULTools.forEachMap(cop, (k, v) => {
                if (v == "nil")
                    v = "";
                newConfig[k] = v;
            });
            this.currConfig = newConfig;
            ULConst.B_INNER_DEBUG = this.getConfig().i_sdk_debug_mode >= ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG;
        }
        static onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cConfig:" });
            config.push({
                type: "button",
                text: "显示cConfig",
                onClick: () => {
                    let data = this.currConfig;
                    let keys = Object.keys(data);
                    keys.sort();
                    let conf = [];
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = JSON.stringify(data[key]);
                        let text = ULTools.format("[%s] = [%s]\n", key, value);
                        if (text.length >= 64) {
                            text = text.substr(0, 64 - 2) + "..";
                        }
                        conf.push({ text: text, value: { k: key, v: value } });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("cConfig", conf, (value) => {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt(value.k, value.v, "关闭", null);
                    }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: ULTools.format("i_sdk_debug_mode=[%s]", this.getConfig().i_sdk_debug_mode),
                name: "labelDebugMode",
            });
            config.push({
                type: "button",
                text: "切换调试模式",
                onClick: () => {
                    let conf = [
                        { text: "0: 全关", value: 0 },
                        { text: "1: warn + error", value: 1 },
                        { text: "2: log + warn + error", value: 2 },
                        { text: "3: 开启各模块的DEBUG + log + warn + error", value: 3 },
                    ];
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择调试模式", conf, (value) => {
                        cConfig.i_sdk_debug_mode = value;
                        this.currConfig.i_sdk_debug_mode = value;
                        ULTools._hack_console_print_method();
                        ULConst.B_INNER_DEBUG = this.getConfig().i_sdk_debug_mode >= ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG;
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelDebugMode", ULTools.format("i_sdk_debug_mode=[%s]", this.getConfig().i_sdk_debug_mode));
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: "局域网调试：",
                name: "labelSocketDebugMode",
            });
            config.push({
                type: "inputBox",
                text: ULStorageManager.getInstance().getStorage("console_lan_id"),
                name: "console_lan_id"
            });
            config.push({
                type: "button",
                text: "切换局域网调试模式",
                onClick: () => {
                    let console_lan_id = ULSdkManager.getInstance().moduleCheckerManager.getItemText("console_lan_id");
                    let conf = [
                        { text: "关闭调试", value: 0 },
                        { text: "开启调试: " + console_lan_id, value: 1 },
                    ];
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择调试模式", conf, (value) => {
                        if (value == 0) {
                            ULStorageManager.getInstance().setStorage("console_lan_id", null);
                            ULTools._close_console_print_LAN();
                        }
                        else {
                            ULStorageManager.getInstance().setStorage("console_lan_id", console_lan_id);
                            ULTools._start_console_print_LAN()
                                .catch(err => {
                                ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", err, "确认", null);
                            });
                        }
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: `SDK log 开关：(${this.sdkLogSwitch ? "已开启" : "已关闭"})`,
                name: "SDK_LOG_MODE",
            });
            config.push({
                type: "button",
                text: `切换状态`,
                onClick: () => {
                    if (this.sdkLogSwitch) {
                        this.sdkLogSwitch = false;
                        ULLog.console.allowConsole = false;
                    }
                    else {
                        this.sdkLogSwitch = true;
                        ULLog.console.allowConsole = true;
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("SDK_LOG_MODE", `SDK log 开关：(${this.sdkLogSwitch ? "已开启" : "已关闭"})`);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "显示sdk通信记录:" });
            config.push({
                type: "button",
                text: "查看...",
                onClick: () => {
                    let log = ULSdkManager.getInstance().getSdkCommunicationLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const v = log[i];
                        try {
                            let data = JSON.parse(v);
                            ULLog.console.log(i, v, data);
                            conf.push({
                                text: ULTools.format("%d: %s", i, data.cmd),
                                value: v,
                            });
                        }
                        catch (error) {
                        }
                    }
                    ULLog.console.log("conf", conf);
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("sdk通信记录（最近100条）", conf, (v) => {
                        ULSdkManager.getInstance().moduleCheckerManager.showBigTextWithPickerDialog("详情", v, 40);
                    }, true);
                },
            });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }
    ULConfig.bInit = false;
    ULConfig.sdkLogSwitch = true;

    class ULModuleBase {
        constructor() {
            ULLog.console.log("ULModuleBase-constructor");
        }
        init() {
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, this.getCollectionModuleCheckerPriority(), this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        onDisposeModule() {
            ULLog.console.log("ULModuleBase-onDisposeModule");
        }
        loadSubModules() {
            return [];
        }
        getSubAdModuleClassName() {
            return [];
        }
        getAdMainClassName() {
            return "";
        }
        createSubAdObj(className, param) {
            return null;
        }
        createMainAdObj() {
            return null;
        }
        loadModuleCheckerConfig() {
            return [];
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let ret = this.loadModuleCheckerConfig();
            for (let i = 0; i < ret.length; i++) {
                const v = ret[i];
                config.push(v);
            }
            e.setReturnValue(config, true);
        }
        getCollectionModuleCheckerPriority() {
            return ULConst.PRIORITY_NONE;
        }
    }

    class ULModuleCdk extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleCdk";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USE_CDKEY, 1, this.onCmdUseCdkey.bind(this));
        }
        requestUseCdk(userId, cdkStr, channelId, gameVersion) {
            return ULModuleCdk.requestCDK(userId, cdkStr, channelId, gameVersion);
        }
        onCmdUseCdkey(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userId = data.userId;
            let cdkStr = data.cdkStr;
            let channelId = config.s_sdk_cop_channel_id;
            this.requestUseCdk(userId, cdkStr, channelId, data.gameVersion || "")
                .then(cdkData => {
                ULSdkManager.getInstance().response(ULConst.CMD_USE_CDKEY_RESULT, {
                    code: 1,
                    data: cdkData,
                    message: "兑换成功",
                });
            }).catch(err => {
                ULSdkManager.getInstance().response(ULConst.CMD_USE_CDKEY_RESULT, {
                    code: 0,
                    message: err,
                });
            });
        }
        static requestCDK(userId, cdkStr, channelId, gameVersion) {
            return new Promise((resolve, reject) => {
                let config = ULConfig.getConfig();
                let appId = config.s_prj_id;
                let timeout = config.i_net_timeout;
                let url = ULTools.format("%s?userId=%s&cdkStr=%s&gameId=%s&channelId=%s&platform=1&gameVersion=%s", config.s_sdk_cdk_url + "/cdk/usecdkv8", userId, cdkStr, appId, channelId, gameVersion || "");
                ULLog.console.log("ULModuleCdk.requestUseCdk", url);
                ULTools.httpGet({
                    url: url,
                    timeoutMillisecond: timeout,
                    success: (responseText) => {
                        let result = JSON.parse(responseText);
                        ULSdkManager.getInstance().statisManager.reportOpenCdk(result.code);
                        if (result.code == "1") {
                            resolve(result.data);
                        }
                        else {
                            let msg = "兑换失败";
                            if (result.code == "2") {
                                msg = "该cdkey不属于该应用";
                            }
                            else if (result.code == "3") {
                                msg = "cdk不在有效使用时间内";
                            }
                            else if (result.code == "4") {
                                msg = "cdk渠道不对";
                            }
                            else if (result.code == "5") {
                                msg = "此cdkey此用户已使用过";
                            }
                            else if (result.code == "6") {
                                msg = "无效cdk";
                            }
                            else if (result.code == "7") {
                                msg = "版本号过低";
                            }
                            else if (result.code == "8") {
                                msg = "非该cdk绑定用户兑换";
                            }
                            reject(msg);
                        }
                    },
                    fail: () => {
                        ULSdkManager.getInstance().statisManager.reportOpenCdk(0);
                        reject("请求超时");
                    },
                });
            });
        }
    }

    class ULModuleMegadata extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleMegadata";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_MEGADATA_SERVER, 1, this.onCmdMegadataServer.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_POST_MEGADATA, 1, this.onCmdPostMegadata.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            this.gameLevelStartMsgList = {};
        }
        onCmdMegadataServer(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            if (Array.isArray(data) && data.length > 0) {
                ULSdkManager.getInstance().response(ULConst.CMD_MEGADATA_SERVER_RESULT, {
                    code: 1,
                    message: "上报成功",
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_MEGADATA_SERVER_RESULT, {
                    code: 0,
                    message: "数据异常",
                });
            }
            let statisticsAddr = config.s_sdk_megadata_url;
            if (!!ULSdkManager.getInstance().statisManager.getPostMegadataMode()) {
                statisticsAddr = config.s_sdk_megadata_test_url;
            }
            if (statisticsAddr.search(/megadatav7/gi) != -1) {
                ULLog.console.warn("应用确定使用v7版本统计，/c/megadataServer接口数据不再进行上报");
                return;
            }
            let rawDatas = ULTools.clone(data);
            let actionType = rawDatas[0];
            if (actionType == ULConst.STATIS_USER_EVENT_POINT_EVENT) {
                ULSdkManager.getInstance().statisManager.reportPointEvent(rawDatas[1], rawDatas[2]);
                return;
            }
            if (actionType == ULConst.STATIS_USER_EVENT_GAME_LEVEL_START) {
                let gameLevelStartTime = ULTools.time();
                let levelName = rawDatas[1] + "";
                this.gameLevelStartMsgList[levelName] = gameLevelStartTime;
            }
            if (actionType == ULConst.STATIS_USER_EVENT_GAME_LEVEL_COMPLETE) {
                let levelName = rawDatas[1] + "";
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[levelName];
                this.gameLevelStartMsgList[levelName] = undefined;
                delete this.gameLevelStartMsgList[levelName];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                rawDatas.push(Math.floor(usedTime).toString());
            }
            ULSdkManager.getInstance().statisManager.reportUserEvent(rawDatas);
        }
        onCmdPostMegadata(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            if (Array.isArray(data) && data.length > 0) {
                ULSdkManager.getInstance().response(ULConst.CMD_POST_MEGADATA_RESULT, {
                    code: 1,
                    message: "上报成功",
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_POST_MEGADATA_RESULT, {
                    code: 0,
                    message: "数据异常",
                });
            }
            let rawDatas = ULTools.clone(data);
            let actionType = rawDatas[0];
            let typeId = "";
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_LEVEL_START) {
                let gameLevelStartTime = ULTools.time();
                let levelName = rawDatas[1] + "";
                this.gameLevelStartMsgList[levelName] = gameLevelStartTime;
                typeId = ULConst.STATIS_TYPE_LEVEL_START_EVENT;
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_LEVEL_COMPLETE) {
                let levelName = rawDatas[1] + "";
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[levelName];
                this.gameLevelStartMsgList[levelName] = undefined;
                delete this.gameLevelStartMsgList[levelName];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                rawDatas.push(Math.floor(usedTime).toString());
                typeId = ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT;
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, ["levelComplete", levelName]);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_COIN_CHANGE) {
                typeId = ULConst.STATIS_TYPE_COIN_CHANGE_EVENT;
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_ITEM_BUY) {
                typeId = ULConst.STATIS_TYPE_ITEM_BUY;
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_BUY_ACTION) {
                typeId = ULConst.STATIS_TYPE_BUY_ACTION;
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_COMMON_EVENT) {
                typeId = ULConst.STATIS_TYPE_COMMON_EVENT;
                let postData = ULTools.clone(rawDatas);
                postData.shift();
                ULLog.console.log("ULModuleMegadta.onCmdPostMegadatapostData postData:", postData);
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, postData);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_VIDEO_POINT_EVENT) {
                typeId = ULConst.STATIS_TYPE_VIDEO_POINT_EVENT;
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, ["videoPointShow", rawDatas[1]]);
            }
            if (typeId != "") {
                rawDatas.shift();
                ULLog.console.log("ULModuleMegadta.onCmdPostMegadatapostData typeId:", typeId, " rawDatas:", rawDatas);
                ULSdkManager.getInstance().statisManager.reportUserActionEvent(rawDatas, typeId);
            }
        }
        onCmdSdkOnGameResume(e) {
            let config = ULConfig.getConfig();
            for (let key in this.gameLevelStartMsgList) {
                this.gameLevelStartMsgList[key] = ULTools.time();
            }
            ULLog.console.log("ULModuleMegadta.onCmdSdkOnGameResume gameLevelStartTime:", this.gameLevelStartMsgList);
        }
        onCmdSdkOnGamePause(e) {
            let config = ULConfig.getConfig();
            for (let key in this.gameLevelStartMsgList) {
                ULLog.console.log("ULModuleMegadta.onCmdSdkOnGamePause currentGameLevelName:", key);
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[key];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                let rawDatas = new Array();
                rawDatas.push(key);
                rawDatas.push("2");
                rawDatas.push("pause");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push(Math.floor(usedTime).toString());
                let typeId = ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT;
                ULSdkManager.getInstance().statisManager.reportUserActionEvent(rawDatas, typeId);
            }
        }
    }

    class ULModuleUserData extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleUserData";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SAVE_USER_DATA, ULConst.PRIORITY_DISABLE, this.onCmdSaveUserData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_USER_DATA, ULConst.PRIORITY_DISABLE, this.onCmdGetUserData.bind(this));
        }
        requestUploadUserData(userId, userData) {
            let config = ULConfig.getConfig();
            let url = "https://h5gameserver.ultralisk.cn/savealluserdata";
            let postData = {
                userId: userId,
                data: userData,
            };
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    let responseData = JSON.parse(responseText);
                    if (responseData && responseData.code == 0) {
                        ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                            code: 1,
                            msg: "存档成功",
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                            code: 0,
                            msg: "存档失败",
                        });
                    }
                },
                fail: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                        code: 0,
                        msg: "存档超时",
                    });
                },
            });
        }
        requestDownloadUserData(userId) {
            let config = ULConfig.getConfig();
            let url = ULTools.format("%s?userId=%s", "https://h5gameserver.ultralisk.cn/getuserdata", userId);
            ULLog.console.log("ULModuleUserData.requestDownloadUserData", userId);
            ULLog.console.log("  url", url);
            ULTools.httpGet({
                url: url,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    let responseData = JSON.parse(responseText);
                    ULLog.console.log("  ULModuleUserData.requestDownloadUserData success", responseText);
                    if (responseData && responseData.code == 0) {
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                            code: 1,
                            userData: responseData.data,
                            msg: "模拟成功",
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                            code: 0,
                            userData: {},
                            msg: "读取存档失败",
                        });
                    }
                },
                fail: (err) => {
                    ULLog.console.log("  ULModuleUserData.requestDownloadUserData fail", err);
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                        code: 0,
                        userData: {},
                        msg: "读取存档超时",
                    });
                },
            });
        }
        onCmdSaveUserData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let data = e.data;
            let userId = channelInfo.uuid;
            let userData = data.userData;
            if (!userId) {
                ULLog.console.log("ULModuleUserData.onCmdSaveUserData userId not found!");
                return;
            }
            this.requestUploadUserData(userId, userData);
        }
        onCmdGetUserData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let data = e.data;
            let userId = channelInfo.uuid;
            this.requestDownloadUserData(userId);
        }
    }

    class ULClipboardManager {
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULClipboardManager();
            }
            return this._instance;
        }
        getClipboardData(finishCallback) {
            if (!(finishCallback instanceof Function)) {
                ULLog.console.warn("ULClipboardManager.getClipboardData finishCallback not a function");
                return;
            }
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_GET_CLIPBOARD_DATA, {
                finishCallback: finishCallback,
            });
            if (!bCalled) {
                finishCallback(null);
            }
        }
        setClipboardData(data, finishCallback) {
            if (!(finishCallback instanceof Function)) {
                ULLog.console.warn("ULClipboardManager.setClipboardData finishCallback not a function");
                return;
            }
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_SET_CLIPBOARD_DATA, {
                data: data,
                finishCallback: finishCallback,
            });
            if (!bCalled) {
                finishCallback(false);
            }
        }
        isSupport() {
            let bSupport = !!ULEventDispatcher.getInstance().dispatchWithReturn(ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD, {});
            return bSupport;
        }
    }
    ULClipboardManager._instance = null;

    class ULModuleClipboard extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleClipboard";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_CLIPBOARD_DATA, 1, this.onCmdSetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_CLIPBOARD_DATA, 1, this.onCmdGetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
        }
        onCmdSetClipboardData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let clipboardData = data.clipboardData;
            let userData = data.userData;
            ULClipboardManager.getInstance().setClipboardData(clipboardData, (bSuccess) => {
                if (bSuccess) {
                    ULSdkManager.getInstance().response(ULConst.CMD_SET_CLIPBOARD_DATA_RESULT, {
                        code: 1,
                        msg: "保存成功",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_SET_CLIPBOARD_DATA_RESULT, {
                        code: 0,
                        msg: "保存失败",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
            });
        }
        onCmdGetClipboardData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userData = data.userData;
            ULClipboardManager.getInstance().getClipboardData((clipboardData) => {
                if (clipboardData) {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_CLIPBOARD_DATA_RESULT, {
                        code: 1,
                        msg: "获取成功",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_CLIPBOARD_DATA_RESULT, {
                        code: 0,
                        msg: "获取失败",
                        clipboardData: null,
                        userData: userData,
                    });
                }
            });
        }
        onCmdSetVersion(e) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isSupportClipboardData = ULClipboardManager.getInstance().isSupport();
            ULLog.console.log(ULTools.format("ULModuleClipboard.onCmdSetVersion mark isSupportClipboardData = %s", channelInfo.isSupportClipboardData));
        }
    }

    class ULModuleDefault extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleDefault";
            this.hadShowAffiche = false;
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CHECK_TIME_CHANGE, 1, (e) => {
                this.checkTimeChange((bChange, serverTime, timeDeferenceLimit) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_CHECK_TIME_CHANGE_RESULT, {
                        bChange: bChange,
                        serverTime: serverTime,
                        timeDeferenceLimit: timeDeferenceLimit
                    }, true);
                });
            });
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_CHANNEL_USERID, 1, this.onCmdGetChannelUserId.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SHOW_FEEDBACK_AND_COMPLAINTS, 1, this.onCmdShowFeedbackAndComplaints.bind(this));
        }
        checkTimeChange(callback) {
            let config = ULConfig.getConfig();
            let url = config.s_sdk_common_checktime_url;
            let timeout = config.i_net_timeout;
            let deferenceLimit = config.i_sdk_common_checktime_deferenceLimit;
            deferenceLimit = !isNaN(Number(deferenceLimit)) ? Number(deferenceLimit) : 300000;
            if (url) {
                ULTools.httpGet({
                    url: url,
                    timeoutMillisecond: timeout,
                    success: (responseText) => {
                        let serviceTime = !isNaN(Number(responseText)) ? Number(responseText) : 0;
                        let difference = Math.abs(serviceTime - new Date().getTime());
                        console.log("now:", new Date().getTime());
                        console.log("serviceTime:", serviceTime);
                        console.log("difference:", difference);
                        callback(difference > deferenceLimit, serviceTime, deferenceLimit);
                    },
                    fail: () => {
                        callback(true, 0, deferenceLimit);
                    },
                });
            }
            else {
                Promise.resolve().then(() => {
                    callback(false, new Date().getTime(), deferenceLimit);
                });
            }
        }
        onCmdSetVersion(e) {
            if (!this.hadShowAffiche) {
                this.hadShowAffiche = true;
                let config = ULConfig.getConfig();
                let affiche_url = config.s_sdk_common_affiche_url;
                if (affiche_url.length > 5) {
                    let title = config.s_sdk_common_affiche_title || "最新公告";
                    ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(title, affiche_url);
                }
            }
        }
        onCmdGetChannelUserId(e) {
            e.stopImmediatePropagation();
            let callback = (userId) => {
                ULSdkManager.getInstance().response(ULConst.RECMD_GET_CHANNEL_USERID_RESULT, {
                    code: userId ? 1 : 0,
                    msg: userId ? "success" : "failed",
                    userId: userId
                });
            };
            let fun = ULSdkManager.getInstance().channelInfo.getChannelOpenIdFunc;
            fun ? fun((openId, err) => {
                callback(openId);
            }) : callback("");
            let config = ULConfig.getConfig();
            let key = `${this.className}_record_${config['s_prj_id']}`;
            let recordStr = ULStorageManager.getInstance().getStorage(key);
            let record = {};
            if (recordStr) {
                try {
                    record = JSON.parse(recordStr);
                }
                catch (error) {
                    record = {};
                }
            }
            if (Object.keys(record).length == 0) {
                record['bCanCheckWhite'] = 1;
                ULStorageManager.getInstance().setStorage(key, JSON.stringify(record));
            }
        }
        onCmdShowFeedbackAndComplaints(e) {
            e.stopImmediatePropagation();
            ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SHOW_FEEDBACK_AND_COMPLAINTS, {
                code: 0,
                msg: "Unsupported",
                userData: e && e.data && e.data.userData || ""
            });
        }
    }

    class ULModuleEmail extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleEmail";
        }
        init() {
            super.init();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isSupportULEmail = true;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SEND_EMAIL_TO_USER, 1, this.onCmdSendEmailToUser.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_USER_EMAIL, 1, this.onCmdGetUserEmail.bind(this));
        }
        _serverUrl() {
            return ULConfig.getConfig()['s_sdk_email_server_url'] || "https://common.ultralisk.cn/email2";
        }
        onCmdSendEmailToUser(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let userData = data ? data.userData : "";
            let userIds = data.userIds || [];
            let gameId = data.gameId || "";
            let expiration = data.expiration || 0;
            let title = data.title || "";
            let content = data.content || "";
            let attachment = data.attachment || [];
            if (!ULSdkManager.getInstance().channelInfo.isSupportULEmail) {
                ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT, {
                    code: 0,
                    msg: "unsupported",
                    userData: userData,
                    gameId: gameId,
                    userIds: userIds,
                    expiration: expiration,
                    title: title,
                    content: content,
                    attachment: attachment
                });
                return;
            }
            let postParam = {
                url: `${this._serverUrl()}/sendEmailToUser`,
                postData: JSON.stringify({
                    "gameId": Number(gameId || ULConfig.getConfig().s_prj_id),
                    "bAll": 0,
                    "expiration": expiration,
                    "title": title,
                    "content": content,
                    "attachment": attachment,
                    "userIds": userIds
                }),
                contentType: "application/json;charset=UTF-8",
                timeoutMillisecond: ULConfig.getConfig().i_net_timeout,
                success: (responseText) => {
                    ULLog.console.log("ULModuleEmail-onCmdSendEmailToUser-success:", responseText);
                    try {
                        let result = JSON.parse(responseText);
                        let code = result.code;
                        let msg = result.msg;
                        if (code === 0) {
                            ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT, {
                                code: 1,
                                msg: 'success',
                                userData: userData,
                                gameId: gameId,
                                userIds: userIds,
                                expiration: expiration,
                                title: title,
                                content: content,
                                attachment: attachment
                            });
                        }
                        else {
                            ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT, {
                                code: 0,
                                msg: msg,
                                userData: userData,
                                gameId: gameId,
                                userIds: userIds,
                                expiration: expiration,
                                title: title,
                                content: content,
                                attachment: attachment
                            });
                        }
                    }
                    catch (error) {
                        ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT, {
                            code: 0,
                            msg: '解析异常',
                            userData: userData,
                            gameId: gameId,
                            userIds: userIds,
                            expiration: expiration,
                            title: title,
                            content: content,
                            attachment: attachment
                        });
                    }
                },
                fail: (err) => {
                    ULLog.console.log("ULModuleEmail-onCmdSendEmailToUser-fail:", err);
                    ULSdkManager.getInstance().response(ULConst.REMSG_CMD_SEND_EMAIL_TO_USER_RESULT, {
                        code: 0,
                        msg: '请求失败',
                        userData: userData,
                        gameId: gameId,
                        userIds: userIds,
                        expiration: expiration,
                        title: title,
                        content: content,
                        attachment: attachment
                    });
                }
            };
            if (ULSdkManager.getInstance().channelInfo.channelName === "zhifubao") {
                this._httpPost(postParam);
            }
            else {
                ULTools.httpPost(postParam);
            }
        }
        _httpPost(obj) {
            obj.contentType = obj.contentType || "application/x-www-form-urlencoded;charset=utf-8";
            let xhr = new XMLHttpRequest();
            let timeoutTimer = setTimeout(() => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            }, obj.timeoutMillisecond);
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    clearTimeout(timeoutTimer);
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (typeof (responseData) == "object")
                            responseData = JSON.stringify(responseData);
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        ULLog.console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader('content-type', obj.contentType);
            let requestHeader = obj.requestHeader;
            if (requestHeader) {
                Object.keys(requestHeader).forEach(element => {
                    xhr.setRequestHeader(element, requestHeader[element]);
                });
            }
            xhr.send(obj.postData);
        }
        onCmdGetUserEmail(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userId = data.userId;
            let gameId = data.gameId;
            let userData = data.userData;
            if (!ULSdkManager.getInstance().channelInfo.isSupportULEmail) {
                ULSdkManager.getInstance().response(ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT, {
                    code: 0,
                    msg: "unsupported",
                    gameId: gameId,
                    userId: userId,
                    userData: userData
                });
                return;
            }
            let url = this._serverUrl() + "/getUserEmail?" + `gameId=${gameId || config.s_prj_id}&userId=${encodeURIComponent(userId)}`;
            ULTools.httpGet({
                url: url,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    ULLog.console.log("ULModuleEmail-onCmdGetUserEmail-success:", responseText);
                    try {
                        let result = JSON.parse(responseText);
                        let code = result.code;
                        let msg = result.msg;
                        let mData = result.data;
                        if (code === 0) {
                            ULSdkManager.getInstance().response(ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT, {
                                code: 1,
                                msg: "success",
                                gameId: gameId,
                                userId: userId,
                                emailData: mData,
                                userData: userData
                            });
                        }
                        else {
                            ULSdkManager.getInstance().response(ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT, {
                                code: 0,
                                msg: msg,
                                gameId: gameId,
                                userId: userId,
                                userData: userData
                            });
                        }
                    }
                    catch (error) {
                        ULSdkManager.getInstance().response(ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT, {
                            code: 0,
                            msg: '解析异常',
                            gameId: gameId,
                            userId: userId,
                            userData: userData
                        });
                    }
                },
                fail: (err) => {
                    ULLog.console.log("ULModuleEmail-onCmdGetUserEmail-fail:", err);
                    ULSdkManager.getInstance().response(ULConst.REMSG_CMD_GET_USER_EMAIL_RESULT, {
                        code: 0,
                        msg: '请求失败',
                        gameId: gameId,
                        userId: userId,
                        userData: userData
                    });
                }
            });
        }
    }

    let hbs = window["hbs"];
    let qg = window["qg"];
    let tt = window["tt"];
    let wx = window["wx"];
    let qq = window["qq"];
    let gamebox = window['gamebox'];
    class ULModulePrivacyPolicy extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModulePrivacyPolicy";
        }
        get isAgreePrivacyPolicy() {
            let value = ULStorageManager.getInstance().getStorage("hadSurePrivacy") || "0";
            return value == "1";
        }
        agreePrivacyPolicy() {
            ULStorageManager.getInstance().setStorage("hadSurePrivacy", "1");
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isAgreePrivacyPolicy = true;
        }
        init() {
            super.init();
            this.initSdk();
        }
        initSdk() {
            ULLog.console.info("ULModulePrivacyPolicy-initSdk");
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isAgreePrivacyPolicy = this.isAgreePrivacyPolicy;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SHOW_PRIVACY, 1000, this.onCmdShowPrivacy.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_ADVANCED_SETTING, 1000, this.onCmdOpenAdvancedSetting.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
        }
        onCmdOpenAdvancedSetting(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let items = [];
            let shield_unsubscribe_channels = config.a_sdk_shield_unsubscribe_channels;
            let channelId = config.s_sdk_cop_channel_id;
            if (shield_unsubscribe_channels.indexOf(channelId) == -1) {
                items.push({
                    name: `注销账户`,
                    handle: () => {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt2("温馨提示", "注销账户会导致该账户不可用", "知道了", "再想想", () => {
                            localStorage.clear();
                            this.exitGame();
                            localStorage.clear();
                        }, () => {
                        });
                    }
                });
            }
            items.push({
                name: `隐私政策界面`,
                handle: () => {
                    ULSdkManager.getInstance().moduleCheckerManager.alertPrivacy("温馨提示", config.t_sdk_privacyPolicy_dataArray, ["返回"], [() => {
                        }]);
                }
            });
            for (let item of config.t_sdk_privacyPolicy_dataArray) {
                items.push({
                    name: `《${item.name}》`,
                    handle: () => {
                        ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(item.name, item.url, item["replaceParam"] || {}, item['privacyText']);
                    }
                });
            }
            ULSdkManager.getInstance().moduleCheckerManager.showSettingView("高级设置", items, {
                sdkUserId: ULSdkManager.getInstance().channelInfo.uuid,
                channelUserId: ULSdkManager.getInstance().channelInfo.channelUserId
            });
        }
        onCmdSetVersion(e) {
            this.showPrivacyPolicy();
        }
        onCmdShowPrivacy(e) {
            e.stopImmediatePropagation();
            let data = e.data || {};
            let type = data.type || "0";
            let userData = data.userData || "";
            let callback = (code, msg) => {
                ULSdkManager.getInstance().response(ULConst.CMD_SHOW_PRIVACY_RESULT, {
                    code: code,
                    msg: msg,
                    type: type,
                    userData: userData,
                });
            };
            if (!type) {
                callback(0, "type 值错误");
                return;
            }
            let config = ULConfig.getConfig();
            let dataArray = config.t_sdk_privacyPolicy_dataArray || [];
            let index = Math.max(0, Number(type));
            if (index < dataArray.length) {
                let content = dataArray[index];
                ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(content.name, content.url, content["replaceParam"] || {}, content['privacyText']);
                callback(1, "执行成功");
            }
            else {
                callback(0, "未找到对应配置");
            }
        }
        showPrivacyPolicy() {
            if (!this.isAgreePrivacyPolicy) {
                let config = ULConfig.getConfig();
                ULSdkManager.getInstance().moduleCheckerManager.alertPrivacy("温馨提示", config.t_sdk_privacyPolicy_dataArray, ["拒绝", "同意"], [() => {
                        this.exitGame();
                        return true;
                    }, () => {
                        this.agreePrivacyPolicy();
                        ULSdkManager.getInstance().waits.removeCondition("privacy_agree");
                    }]);
            }
            else {
                ULSdkManager.getInstance().waits.removeCondition("privacy_agree");
            }
        }
        exitGame() {
            let modeArray = [hbs, qg, tt, wx, qq, gamebox];
            while (modeArray.length) {
                let mode = modeArray.pop();
                if (mode && mode != 'undefined' && mode.exitApplication) {
                    mode.exitApplication({
                        success: function () {
                            ULLog.console.log("exitApplication success");
                        },
                        fail: function () {
                            ULLog.console.log("exitApplication fail");
                        },
                        complete: function () {
                            ULLog.console.log("exitApplication complete");
                        }
                    });
                }
                else if (mode && mode != 'undefined' && mode.exitMiniProgram) {
                    mode.exitMiniProgram({
                        success: function () {
                            ULLog.console.log("exitMiniProgram success");
                        },
                        fail: function () {
                            ULLog.console.log("exitMiniProgram fail");
                        },
                        complete: function () {
                            ULLog.console.log("exitMiniProgram complete");
                        }
                    });
                }
            }
            ULLog.console.log("未配置 退出游戏 渠道");
        }
    }

    function rotateLeft(lValue, iShiftBits) {
    	return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
    }
    function addUnsigned(lX, lY) {
    	var lX4, lY4, lX8, lY8, lResult;
    	lX8 = (lX & 0x80000000);
    	lY8 = (lY & 0x80000000);
    	lX4 = (lX & 0x40000000);
    	lY4 = (lY & 0x40000000);
    	lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
    	if (lX4 & lY4) return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
    	if (lX4 | lY4) {
    		if (lResult & 0x40000000) return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
    		else return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
    	} else {
    		return (lResult ^ lX8 ^ lY8);
    	}
    }
    function F (x, y, z) {
    	return (x & y) | ((~ x) & z);
    }
    function G (x, y, z) {
    	return (x & z) | (y & (~ z));
    }
    function H (x, y, z) {
    	return (x ^ y ^ z);
    }
    function I (x, y, z) {
    	return (y ^ (x | (~ z)));
    }
    function FF (a, b, c, d, x, s, ac) {
    	a = addUnsigned(a, addUnsigned(addUnsigned(F(b, c, d), x), ac));
    	return addUnsigned(rotateLeft(a, s), b);
    };
    function GG (a, b, c, d, x, s, ac) {
    	a = addUnsigned(a, addUnsigned(addUnsigned(G(b, c, d), x), ac));
    	return addUnsigned(rotateLeft(a, s), b);
    };
    function HH (a, b, c, d, x, s, ac) {
    	a = addUnsigned(a, addUnsigned(addUnsigned(H(b, c, d), x), ac));
    	return addUnsigned(rotateLeft(a, s), b);
    };
    function II (a, b, c, d, x, s, ac) {
    	a = addUnsigned(a, addUnsigned(addUnsigned(I(b, c, d), x), ac));
    	return addUnsigned(rotateLeft(a, s), b);
    }

    function convertToWordArray(string) {
    	var lWordCount;
    	var lMessageLength = string.length;
    	var lNumberOfWordsTempOne = lMessageLength + 8;
    	var lNumberOfWordsTempTwo = (lNumberOfWordsTempOne - (lNumberOfWordsTempOne % 64)) / 64;
    	var lNumberOfWords = (lNumberOfWordsTempTwo + 1) * 16;
    	var lWordArray = Array(lNumberOfWords - 1);
    	var lBytePosition = 0;
    	var lByteCount = 0;
    	while (lByteCount < lMessageLength) {
    		lWordCount = (lByteCount - (lByteCount % 4)) / 4;
    		lBytePosition = (lByteCount % 4) * 8;
    		lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) << lBytePosition));
    		lByteCount++;
    	}
    	lWordCount = (lByteCount - (lByteCount % 4)) / 4;
    	lBytePosition = (lByteCount % 4) * 8;
    	lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
    	lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
    	lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
    	return lWordArray;
    };
    function wordToHex(lValue) {
    	var WordToHexValue = "", WordToHexValueTemp = "", lByte, lCount;
    	for (lCount = 0; lCount <= 3; lCount++) {
    		lByte = (lValue >>> (lCount * 8)) & 255;
    		WordToHexValueTemp = "0" + lByte.toString(16);
    		WordToHexValue = WordToHexValue + WordToHexValueTemp.substr(WordToHexValueTemp.length - 2, 2);
    	}
    	return WordToHexValue;
    };
    function uTF8Encode (string) {
    	string = string.replace(/\x0d\x0a/g, "\x0a");
    	var output = "";
    	for (var n = 0; n < string.length; n++) {
    		var c = string.charCodeAt(n);
    		if (c < 128) {
    			output += String.fromCharCode(c);
    		} else if ((c > 127) && (c < 2048)) {
    			output += String.fromCharCode((c >> 6) | 192);
    			output += String.fromCharCode((c & 63) | 128);
    		} else {
    			output += String.fromCharCode((c >> 12) | 224);
    			output += String.fromCharCode(((c >> 6) & 63) | 128);
    			output += String.fromCharCode((c & 63) | 128);
    		}
    	}
    	return output;
    };
    	
    function md5Sign(string) {
    	var x = Array();
    	var k, AA, BB, CC, DD, a, b, c, d;
    	var S11=7, S12=12, S13=17, S14=22;
    	var S21=5, S22=9 , S23=14, S24=20;
    	var S31=4, S32=11, S33=16, S34=23;
    	var S41=6, S42=10, S43=15, S44=21;
    	string = uTF8Encode(string);
    	x = convertToWordArray(string);
    	a = 0x67452301; b = 0xEFCDAB89; c = 0x98BADCFE; d = 0x10325476;
    	for (k = 0; k < x.length; k += 16) {
    		AA = a; BB = b; CC = c; DD = d;
    		a = FF(a, b, c, d, x[k+0],  S11, 0xD76AA478);
    		d = FF(d, a, b, c, x[k+1],  S12, 0xE8C7B756);
    		c = FF(c, d, a, b, x[k+2],  S13, 0x242070DB);
    		b = FF(b, c, d, a, x[k+3],  S14, 0xC1BDCEEE);
    		a = FF(a, b, c, d, x[k+4],  S11, 0xF57C0FAF);
    		d = FF(d, a, b, c, x[k+5],  S12, 0x4787C62A);
    		c = FF(c, d, a, b, x[k+6],  S13, 0xA8304613);
    		b = FF(b, c, d, a, x[k+7],  S14, 0xFD469501);
    		a = FF(a, b, c, d, x[k+8],  S11, 0x698098D8);
    		d = FF(d, a, b, c, x[k+9],  S12, 0x8B44F7AF);
    		c = FF(c, d, a, b, x[k+10], S13, 0xFFFF5BB1);
    		b = FF(b, c, d, a, x[k+11], S14, 0x895CD7BE);
    		a = FF(a, b, c, d, x[k+12], S11, 0x6B901122);
    		d = FF(d, a, b, c, x[k+13], S12, 0xFD987193);
    		c = FF(c, d, a, b, x[k+14], S13, 0xA679438E);
    		b = FF(b, c, d, a, x[k+15], S14, 0x49B40821);
    		a = GG(a, b, c, d, x[k+1],  S21, 0xF61E2562);
    		d = GG(d, a, b, c, x[k+6],  S22, 0xC040B340);
    		c = GG(c, d, a, b, x[k+11], S23, 0x265E5A51);
    		b = GG(b, c, d, a, x[k+0],  S24, 0xE9B6C7AA);
    		a = GG(a, b, c, d, x[k+5],  S21, 0xD62F105D);
    		d = GG(d, a, b, c, x[k+10], S22, 0x2441453);
    		c = GG(c, d, a, b, x[k+15], S23, 0xD8A1E681);
    		b = GG(b, c, d, a, x[k+4],  S24, 0xE7D3FBC8);
    		a = GG(a, b, c, d, x[k+9],  S21, 0x21E1CDE6);
    		d = GG(d, a, b, c, x[k+14], S22, 0xC33707D6);
    		c = GG(c, d, a, b, x[k+3],  S23, 0xF4D50D87);
    		b = GG(b, c, d, a, x[k+8],  S24, 0x455A14ED);
    		a = GG(a, b, c, d, x[k+13], S21, 0xA9E3E905);
    		d = GG(d, a, b, c, x[k+2],  S22, 0xFCEFA3F8);
    		c = GG(c, d, a, b, x[k+7],  S23, 0x676F02D9);
    		b = GG(b, c, d, a, x[k+12], S24, 0x8D2A4C8A);
    		a = HH(a, b, c, d, x[k+5],  S31, 0xFFFA3942);
    		d = HH(d, a, b, c, x[k+8],  S32, 0x8771F681);
    		c = HH(c, d, a, b, x[k+11], S33, 0x6D9D6122);
    		b = HH(b, c, d, a, x[k+14], S34, 0xFDE5380C);
    		a = HH(a, b, c, d, x[k+1],  S31, 0xA4BEEA44);
    		d = HH(d, a, b, c, x[k+4],  S32, 0x4BDECFA9);
    		c = HH(c, d, a, b, x[k+7],  S33, 0xF6BB4B60);
    		b = HH(b, c, d, a, x[k+10], S34, 0xBEBFBC70);
    		a = HH(a, b, c, d, x[k+13], S31, 0x289B7EC6);
    		d = HH(d, a, b, c, x[k+0],  S32, 0xEAA127FA);
    		c = HH(c, d, a, b, x[k+3],  S33, 0xD4EF3085);
    		b = HH(b, c, d, a, x[k+6],  S34, 0x4881D05);
    		a = HH(a, b, c, d, x[k+9],  S31, 0xD9D4D039);
    		d = HH(d, a, b, c, x[k+12], S32, 0xE6DB99E5);
    		c = HH(c, d, a, b, x[k+15], S33, 0x1FA27CF8);
    		b = HH(b, c, d, a, x[k+2],  S34, 0xC4AC5665);
    		a = II(a, b, c, d, x[k+0],  S41, 0xF4292244);
    		d = II(d, a, b, c, x[k+7],  S42, 0x432AFF97);
    		c = II(c, d, a, b, x[k+14], S43, 0xAB9423A7);
    		b = II(b, c, d, a, x[k+5],  S44, 0xFC93A039);
    		a = II(a, b, c, d, x[k+12], S41, 0x655B59C3);
    		d = II(d, a, b, c, x[k+3],  S42, 0x8F0CCC92);
    		c = II(c, d, a, b, x[k+10], S43, 0xFFEFF47D);
    		b = II(b, c, d, a, x[k+1],  S44, 0x85845DD1);
    		a = II(a, b, c, d, x[k+8],  S41, 0x6FA87E4F);
    		d = II(d, a, b, c, x[k+15], S42, 0xFE2CE6E0);
    		c = II(c, d, a, b, x[k+6],  S43, 0xA3014314);
    		b = II(b, c, d, a, x[k+13], S44, 0x4E0811A1);
    		a = II(a, b, c, d, x[k+4],  S41, 0xF7537E82);
    		d = II(d, a, b, c, x[k+11], S42, 0xBD3AF235);
    		c = II(c, d, a, b, x[k+2],  S43, 0x2AD7D2BB);
    		b = II(b, c, d, a, x[k+9],  S44, 0xEB86D391);
    		a = addUnsigned(a, AA);
    		b = addUnsigned(b, BB);
    		c = addUnsigned(c, CC);
    		d = addUnsigned(d, DD);
    	}
    	var tempValue = wordToHex(a) + wordToHex(b) + wordToHex(c) + wordToHex(d);
    	return tempValue.toLowerCase();
    }

    class ULChannelModuleBase extends ULModuleBase {
        constructor() {
            super();
            ULLog.console.log("ULChannelModuleBase-constructor");
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_GET_STORAGE, ULConst.PRIORITY_NONE, this.onCmdSdkGetStorage.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_SET_STORAGE, ULConst.PRIORITY_NONE, this.onCmdSdkSetStorage.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_GET_CLIPBOARD_DATA, ULConst.PRIORITY_NONE, this.onCmdSdkGetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_SET_CLIPBOARD_DATA, ULConst.PRIORITY_NONE, this.onCmdSdkSetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD, ULConst.PRIORITY_NONE, this.onCmdSdkIsSupportClipboard.bind(this));
            this.genSdkUserId();
            ULSdkManager.getInstance().channelInfo._sdkUserId = this.sdkUserId;
            ULSdkManager.getInstance().channelInfo.isNewUser = this.isNewUser;
            ULLog.console.log("ULChannelModuleBase.init isNewUser:", this.isNewUser);
        }
        genSdkUserId() {
            let config = ULConfig.getConfig();
            let oldKey = ULTools.format("mUserId_%s", config.s_sdk_megadata_game_id);
            let newKey = ULTools.format("ulsdk_userid_%s", config.s_prj_id);
            let oldRecord = ULStorageManager.getInstance().getStorage(oldKey);
            if (oldRecord) {
                ULStorageManager.getInstance().setStorage(oldKey, "");
                ULStorageManager.getInstance().setStorage(newKey, oldRecord);
            }
            this.sdkUserId = ULStorageManager.getInstance().getStorage(newKey);
            if (!this.sdkUserId) {
                this.sdkUserId = ULTools.format("%s_%s", ULTools.createRandomUserId(), config.s_sdk_cop_channel_id);
                ULStorageManager.getInstance().setStorage(newKey, this.sdkUserId);
                this.isNewUser = true;
            }
        }
        onCmdSdkGetStorage(e) {
            let data = e.data;
            let key = data.key;
            e.setReturnValue(this._hook_getStorage(key));
        }
        onCmdSdkSetStorage(e) {
            let key = e.data.key;
            let data = e.data.data;
            this._hook_setStorage(key, data);
            e.stopImmediatePropagation();
        }
        onCmdSdkGetClipboardData(e) {
            let data = e.data;
            let finishCallback = data.finishCallback;
            this._hook_getClipboardData(finishCallback);
            e.stopImmediatePropagation();
        }
        onCmdSdkSetClipboardData(e) {
            let clipboardData = e.data.data;
            let finishCallback = e.data.finishCallback;
            this._hook_setClipboardData(clipboardData, finishCallback);
            e.stopImmediatePropagation();
        }
        onCmdSdkIsSupportClipboard(e) {
            let data = e.data;
            e.setReturnValue(this._hook_isSupportClipboard());
            e.stopImmediatePropagation();
        }
        bNewUser() {
            return this.isNewUser;
        }
    }

    class ULAdvObjectBase extends ULModuleBase {
        constructor(arg, advType, advKey) {
            super();
            this._preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
            this.onLoadFailErr = { code: "", msg: "" };
            this._statisticsAdvertiser = "";
            this._statisticsType = "";
            this.advKey_2_lastRequestTime = {};
            this._supportLoadType = [];
            this._loadType = undefined;
            this.isReportLoading = false;
            this.isDispose = false;
            this._arg = arg;
            this._advType = advType;
            this._advKey = advKey;
        }
        onDisposeModule() {
            super.onDisposeModule();
            this.isDispose = true;
            ULLog.console.log("ULAdvObjectBase-onDisposeModule arg:", this.arg);
        }
        get arg() {
            return this._arg;
        }
        get advKey() {
            return this._advKey;
        }
        get preLoadState() {
            return this._preLoadState;
        }
        set preLoadState(preLoadState) {
            if (this._preLoadState == preLoadState)
                return;
            this._preLoadState = preLoadState;
            ULSdkManager.getInstance().advManager.onAdvObjectPreloadStateChanged(this.advKey);
        }
        get advType() {
            return this._advType;
        }
        get isOpened() {
            return this._isOpened;
        }
        set isOpened(opened) {
            this._isOpened = opened;
        }
        get showData() {
            return this._mShowData;
        }
        set showData(mShowData) {
            this._mShowData = mShowData;
        }
        getMainClassNameString() {
            return this.getMainClassName();
        }
        receiveMainClassInitState(initState) {
            this.receiveInitState(initState);
        }
        preLoadAdv() {
            this.onLoadFailErr.code = "";
            this.onLoadFailErr.msg = "";
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            let rcd = ULSdkManager.getInstance().advManager.getRcdByAdvKey(this.advKey);
            if (rcd) {
                let lastRequestTime = this.advKey_2_lastRequestTime[this.advKey];
                let now = (new Date()).valueOf();
                if (lastRequestTime) {
                    if ((now - lastRequestTime) < rcd) {
                        console.warn(`${this.className}-preLoadAdv:模块[ + ${this.advKey} + ]in cd`);
                        this.preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
                        this.reLoadAdv();
                        return;
                    }
                    else {
                        this.advKey_2_lastRequestTime[this.advKey] = now;
                    }
                }
                else {
                    this.advKey_2_lastRequestTime[this.advKey] = now;
                }
            }
            this.loadAdv();
        }
        reLoadAdv() {
            ULTimer.callLater(ULSdkManager.getInstance().advManager.getAdvReloadTime() / 1000, () => {
                if (!this.isDispose) {
                    this.preLoadAdv();
                }
            });
        }
        advSkip(data, info) {
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleSkip(this.advKey, info, data);
        }
        get statisticsAdvertiser() {
            return this._statisticsAdvertiser;
        }
        set statisticsAdvertiser(statisticsAdvertiser) {
            this._statisticsAdvertiser = statisticsAdvertiser;
        }
        get statisticsType() {
            return this._statisticsType;
        }
        set statisticsType(statisticsType) {
            this._statisticsType = statisticsType;
        }
        set setSupportLoadType(types) {
            this._supportLoadType = types;
        }
        get getSupportLoadType() {
            return this._supportLoadType;
        }
        set setLoadType(type) {
            if (type == undefined) {
                return;
            }
            this._loadType = type;
        }
        get getLoadType() {
            return this._loadType;
        }
    }

    class ULAdvNativeObjectBase extends ULAdvObjectBase {
        constructor(arg, advType, templateItemName) {
            super(arg, advType, templateItemName);
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_CLICK_NATIVE_ADV, ULConst.PRIORITY_NONE, this.clickNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_CLOSE_NATIVE_ADV, ULConst.PRIORITY_NONE, this.closeNativeAdv.bind(this));
        }
        get nativeShowState() {
            return this._nativeShowState;
        }
        set nativeShowState(nativeShowState) {
            this._nativeShowState = nativeShowState;
        }
        get nativeData() {
            return this._nativeData;
        }
        set nativeData(nativeData) {
            this._nativeData = nativeData;
        }
    }

    const EvalSYMBOL = {
        ",": { order: -2, argCount: 1, handler: (args) => { return args[0]; } },
        "*": { order: 3, argCount: 2, handler: (args) => { return args[0] * args[1]; } },
        "/": { order: 3, argCount: 2, handler: (args) => { return args[0] / args[1]; } },
        "%": { order: 3, argCount: 2, handler: (args) => { return args[0] % args[1]; } },
        "+": { order: 2, argCount: 2, handler: (args) => { return args[0] + args[1]; } },
        "-": {
            order: 2, argCount: 2, handler: (args) => {
                if (args.length == 1)
                    return 0 - args[0];
                return args[0] - args[1];
            }
        },
        ">=": { order: 1, argCount: 2, handler: (args) => { return args[0] >= args[1]; } },
        ">": { order: 1, argCount: 2, handler: (args) => { return args[0] > args[1]; } },
        "<=": { order: 1, argCount: 2, handler: (args) => { return args[0] <= args[1]; } },
        "<": { order: 1, argCount: 2, handler: (args) => { return args[0] < args[1]; } },
        "==": { order: 0, argCount: 2, handler: (args) => { return args[0] == args[1]; } },
        "!=": { order: 0, argCount: 2, handler: (args) => { return args[0] != args[1]; } },
        "&&": { order: -1, argCount: 2, handler: (args) => { return args[0] && args[1]; } },
        "||": { order: -1, argCount: 2, handler: (args) => { return args[0] || args[1]; } },
        "[": { order: 4, argChar: "]", handler: (args) => { let a = args[0]; let b = args[1]; return a[b]; } },
        "(": {
            order: 4, argChar: ')', handler: (args) => {
                let a = args[0];
                if (Object.prototype.toString.call(a) === "[object Function]") {
                    args.shift();
                    return a(...args);
                }
                else {
                    return a;
                }
            }
        },
        ".": {
            order: 5, argCount: 2, handler: (args) => {
                if (typeof (args[1]) == "number") {
                    return Number(`${args[0]}.${args[1]}`);
                }
                else {
                    let item = args[0][args[1]];
                    if (Object.prototype.toString.call(item) === "[object Function]") {
                        return item.bind(args[0]);
                    }
                    else {
                        return item;
                    }
                }
            }
        },
        "\"\"": { order: 6, argCount: 1, handler: (args) => { return args[0].toString(); } },
        "\'\'": { order: 6, argCount: 1, handler: (args) => { return args[0].toString(); } },
        "undefined": { order: 5, argCount: 0, handler: (args) => { return undefined; } },
        "window": { order: 5, argCount: 0, handler: (args) => { return window; } },
        "ULConfig": { order: 5, argCount: 0, handler: (args) => { return ULConfig; } },
        "ULTools": { order: 5, argCount: 0, handler: (args) => { return ULTools; } },
        "true": { order: 5, argCount: 0, handler: (args) => { return true; } },
        "false": { order: 5, argCount: 0, handler: (args) => { return false; } },
    };
    let EvalSYMBOL_keys = Object.keys(EvalSYMBOL);
    let EvalSYMBOLKeysDic = {};
    EvalSYMBOL_keys.forEach((value) => {
        EvalSYMBOLKeysDic[value.length] = true;
    });
    let EvalSYMBOLKeys = Object.keys(EvalSYMBOLKeysDic).map(a => {
        return Number(a);
    }).sort((a, b) => {
        return b - a;
    });
    class ULEvalExp {
        static trimCalcExp(exp) {
            exp = exp.replace(/\s/g, "");
            let expArray = exp.split("");
            var expSignCache = [];
            var expSignSetting = {
                ")": {
                    cut: [")", "\'", "\""],
                    end: "(",
                    symbol: "(",
                    handle: (str) => {
                        let expCache = this.trimCalcExp(str);
                        expCache.push("\")\"");
                        return expCache;
                    }
                },
                "]": {
                    cut: [")", "\'", "\""],
                    end: "[",
                    symbol: "[",
                    handle: (str) => {
                        let expCache = this.trimCalcExp(str);
                        expCache.push("\"]\"");
                        return expCache;
                    }
                },
                "\"": {
                    cut: [],
                    end: "\"",
                    handle: (str) => {
                        return [`"${str}"`];
                    }
                },
                "\'": {
                    cut: [],
                    end: "\'",
                    handle: (str) => {
                        return [`'${str}'`];
                    }
                }
            };
            let value = "";
            let expCache = [];
            let symbolCache = [];
            let expCacheString = "";
            while (expArray.length) {
                let char = expArray.pop();
                let lastExpChar = expSignCache.length ? expSignCache[expSignCache.length - 1] : null;
                if (lastExpChar) {
                    let cut = expSignSetting[lastExpChar].cut;
                    let end = expSignSetting[lastExpChar].end;
                    let symbol = expSignSetting[lastExpChar].symbol;
                    let handle = expSignSetting[lastExpChar].handle;
                    if (char == end) {
                        expSignCache.pop();
                        if (expSignCache.length == 0) {
                            expCache = expCache.concat(handle(expCacheString).reverse());
                            symbol && symbolCache.push(symbol);
                            expCacheString = "";
                            continue;
                        }
                    }
                    else if (cut.indexOf(char) >= 0) {
                        expSignCache.push(char);
                    }
                    expCacheString = char + expCacheString;
                }
                else {
                    if (expSignSetting[char]) {
                        if (value.length) {
                            expCache.push(value);
                            value = "";
                        }
                        expSignCache.push(char);
                        continue;
                    }
                    let symbol = null;
                    for (let i = 0; i < EvalSYMBOLKeys.length; i++) {
                        let length = EvalSYMBOLKeys[i] - 1;
                        if (expArray.length > length) {
                            let key = expArray.slice(expArray.length - length, expArray.length) + char;
                            if (EvalSYMBOL[key]) {
                                char = key;
                                symbol = EvalSYMBOL[key];
                                expArray = expArray.slice(0, expArray.length - length);
                                break;
                            }
                        }
                    }
                    if (symbol) {
                        if (value.length) {
                            expCache.push(value);
                            value = "";
                        }
                        if (symbolCache.length) {
                            for (let i = symbolCache.length - 1; i >= 0; i--) {
                                let lastKey = symbolCache.pop();
                                let lastSymbol = EvalSYMBOL[lastKey];
                                if (lastSymbol && lastSymbol.order > symbol.order) {
                                    expCache.push(lastKey);
                                }
                                else {
                                    symbolCache.push(lastKey);
                                    break;
                                }
                            }
                        }
                        symbolCache.push(char);
                        continue;
                    }
                    value = char + value;
                }
            }
            if (value.length) {
                expCache.push(value);
                value = "";
            }
            expCache = expCache.filter((element, index, array) => {
                return (element != "");
            });
            expCache = expCache.concat(symbolCache.reverse()).reverse();
            return expCache;
        }
        static getCalcExpArray(exp, getObjCallback = null) {
            exp = exp.split(".").join(".^");
            let expCache = this.trimCalcExp(exp);
            let trimExpCache = expCache.map((item, index, arr) => {
                if (EvalSYMBOL[item])
                    return item;
                let char = item.charAt(0);
                if (char == '"' || char == "'") {
                    let trimItem = item.substring(1, item.length - 1);
                    return trimItem.split(".^").join(".");
                }
                else if (char == '^') {
                    let trimItem = item.substring(1, item.length);
                    char = trimItem.charAt(0);
                    if (char <= '9' && char >= '0') {
                        return Number(trimItem);
                    }
                    return trimItem;
                }
                else if (!isNaN(Number(item))) {
                    return Number(item);
                }
                else {
                    let value = getObjCallback ? getObjCallback(item) : undefined;
                    return value;
                }
            });
            return trimExpCache;
        }
        static evalExpResults(exp, getObjCallback = null) {
            var result = true;
            try {
                let expArray = this.getCalcExpArray(exp, getObjCallback);
                result = this.evalExpArrayResults(expArray);
            }
            catch (error) {
                ULLog.console.log("ULEvalExp exp规则错误:", error.stack);
                result = false;
            }
            return result;
        }
        static evalExpArrayResults(expArray) {
            if (expArray.length == 0)
                return true;
            let argCountDefalutHandler = (resultArray, argChar, argCount) => {
                let args = [];
                while (resultArray.length > 0) {
                    if (argChar) {
                        let arg = resultArray.pop();
                        if (arg == argChar)
                            break;
                        args.push(arg);
                    }
                    else {
                        if (argCount-- <= 0)
                            break;
                        args.push(resultArray.pop());
                    }
                }
                return args;
            };
            let resultArray = [];
            while (expArray.length) {
                let key = expArray.pop();
                if (EvalSYMBOL_keys.indexOf(key) > -1) {
                    let value = EvalSYMBOL[key];
                    let argChar = value.argChar;
                    let argCount = value.argCount;
                    let args = argCountDefalutHandler(resultArray, argChar, argCount);
                    let result = value.handler(args);
                    resultArray.push(result);
                }
                else {
                    resultArray.push(key);
                }
            }
            return resultArray[0];
        }
    }

    class ULAdvExpManager {
        constructor() {
            this._timeString = "";
            this.availableExpKeyArray = [];
            this.updateValue = 10;
            this._timeString = ULTools.formatDate(new Date(), "yyyyMMddss");
        }
        static getInstance() {
            if (this.instance == null) {
                this.instance = new ULAdvExpManager();
                this.instance.addListern();
            }
            return this.instance;
        }
        get expValueCache() {
            if (!this._expValueCache) {
                let recordExpKey = this._getRecordKey();
                let oldRecord = ULStorageManager.getInstance().getStorage(recordExpKey);
                let newKey = ULTools.format("ULAdvExpManager_record_%s", ULConfig.getConfig().s_prj_id);
                if (oldRecord) {
                    ULStorageManager.getInstance().setStorage(recordExpKey, "");
                    ULStorageManager.getInstance().setStorage(newKey, oldRecord);
                }
                let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
                let record;
                try {
                    record = JSON.parse(recordStr);
                }
                catch (error) {
                    record = {};
                }
                for (const key in record) {
                    let timeString = this.getKeyTimeString(key);
                    let expValueItem = record[key];
                    if (timeString != expValueItem.exp_time) {
                        delete record[key];
                    }
                }
                this._expValueCache = record;
            }
            return this._expValueCache;
        }
        addListern() {
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
        }
        onCmdSdkOnGamePause(e) {
            this.saveStoreValue();
        }
        static updateExpKeys(expKeyArray) {
            ULAdvExpManager.getInstance().availableExpKeyArray = expKeyArray.slice(0);
        }
        static calcExp(exp) {
            return ULAdvExpManager.getInstance().calcExpResults(exp);
        }
        static updateExpValue(expKey) {
            ULAdvExpManager.getInstance().setStoreValue(expKey);
        }
        calcExpResults(exp) {
            if (!exp)
                return true;
            ULLog.console.log("ULAdvExpManager calcExp:", exp);
            let trimExp = exp.replace(/\s/g, "");
            trimExp = trimExp.split(".").join("^");
            return ULEvalExp.evalExpResults(trimExp, (key) => {
                let trimKey = key.split("^").join(".");
                return this.getCalcExpValue(trimKey);
            });
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULAdvExpManager_record_%d", config.s_sdk_megadata_game_id);
        }
        getCalcExpValue(anyObject) {
            if (typeof (anyObject) == "string" && this.availableExpKeyArray.indexOf(anyObject) != -1) {
                return this.getStoreValue(anyObject);
            }
            return anyObject;
        }
        getStoreValue(key) {
            let expValueItem = this.expValueCache[key];
            if (!expValueItem) {
                return 0;
            }
            let timeString = this.getKeyTimeString(key);
            if (timeString != expValueItem.exp_time) {
                expValueItem.exp_time = timeString;
                expValueItem.exp_value = 0;
            }
            return expValueItem.exp_value;
        }
        setStoreValue(key) {
            if (typeof (key) != "string" || this.availableExpKeyArray.indexOf(key) == -1) {
                return;
            }
            let timeString = this.getKeyTimeString(key);
            let expValueItem = this.expValueCache[key];
            if (!expValueItem) {
                expValueItem = {
                    exp_name: key,
                    exp_time: timeString,
                    exp_value: 1
                };
                this.expValueCache[key] = expValueItem;
            }
            else {
                if (timeString != expValueItem.exp_time) {
                    expValueItem.exp_time = timeString;
                    expValueItem.exp_value = 1;
                }
                else {
                    expValueItem.exp_value += 1;
                }
            }
            this.updateValue--;
            if (this.updateValue <= 0) {
                this.updateValue = 10;
                this.saveStoreValue();
            }
        }
        saveStoreValue() {
            let newKey = ULTools.format("ULAdvExpManager_record_%s", ULConfig.getConfig().s_prj_id);
            ULStorageManager.getInstance().setStorage(newKey, JSON.stringify(this.expValueCache));
        }
        getKeyTimeString(key) {
            let timeString = this._timeString;
            let keyFirstChar = key.substr(0, 1);
            switch (keyFirstChar) {
                case "d":
                    timeString = ULTools.formatDate(new Date(), "yyyyMMdd");
                    break;
                case "w":
                    let today = new Date();
                    let day = today.getDay() || 7;
                    let date = new Date(today.getFullYear(), today.getMonth(), today.getDate() + 1 - day);
                    timeString = ULTools.formatDate(date, "yyyyMMdd");
                    break;
                case "m":
                    timeString = ULTools.formatDate(new Date(), "yyyyMM");
                    break;
                case "y":
                    timeString = ULTools.formatDate(new Date(), "yyyy");
                    break;
            }
            return timeString;
        }
    }
    ULAdvExpManager.instance = null;

    class ULAdvSlot {
        constructor(advId, schemes, subAids, rcd) {
            this._advId = advId;
            this.schemes = schemes;
            this._subAids = subAids;
            this._rcd = rcd;
        }
        get advId() {
            return this._advId;
        }
        refreshValidAdvKeys() {
            let validSchemes = this.getValidSchemes();
            if (!validSchemes || validSchemes.length == 0) {
                return;
            }
            this.validAdvKeys = [];
            for (let i = 0, len = validSchemes.length; i < len; i++) {
                let scheme = validSchemes[i];
                let validTemplates = this.getValidTemplates(scheme);
                if (!validTemplates || validTemplates.length == 0) {
                    continue;
                }
                for (const template of validTemplates) {
                    let tid = template.templateId;
                    let keys = ULSdkManager.getInstance().advManager.getAdvKeysByTemplateId(tid);
                    if (!keys || keys.length == 0) {
                        continue;
                    }
                    for (const key of keys) {
                        if (this.validAdvKeys.indexOf(key) == -1) {
                            this.validAdvKeys.push(key);
                        }
                    }
                }
            }
        }
        set openingInfo(v) {
            this._openingInfo = v;
        }
        get openingInfo() {
            return this._openingInfo;
        }
        get preLoadState() {
            return this._preLoadState;
        }
        set preLoadState(v) {
            this._preLoadState = v;
            ULSdkManager.getInstance().advManager.onAdvSlotPreloadStateChanged(this.advId);
        }
        get rcd() {
            return this._rcd;
        }
        get subAids() {
            return this._subAids;
        }
        set showTid(t) {
            this._showTid = t;
        }
        get showTid() {
            return this._showTid;
        }
        openAdv(advRequestSerialNum, data) {
            let ulAdvInfo = {
                data: data,
                requestSerialNum: advRequestSerialNum
            };
            this.openingInfo = ulAdvInfo;
            let scheme = this.getShowScheme();
            if (!scheme) {
                console.warn("ULAdvSlot-openAdv:广告位[" + this.advId + "]未获取到有效策略");
                this.openingInfo = null;
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${this.advId}]未获取到有效策略` });
                return;
            }
            let validTemplates = this.getValidTemplates(scheme);
            if (!validTemplates || validTemplates.length == 0) {
                console.warn("ULAdvSlot-openAdv:广告位[" + this.advId + "]未获取到可用模板");
                this.openingInfo = null;
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${this.advId}]未获取到可用模板` });
                return;
            }
            ULLog.console.log("ULAdvSlot-openAdv:广告位[" + this.advId + "]当前展示策略：" + JSON.stringify(scheme));
            this.openingInfo.scheme = scheme;
            let validTemplateIdArray = [];
            let validTemplateWeightArray = [];
            for (let i = 0; i < validTemplates.length; i++) {
                let tid = validTemplates[i].templateId;
                let tidWeight = 0;
                let tidsArray = scheme.tids;
                let tidsWeightsArray = scheme.tidWeights;
                for (let j = 0; j < tidsArray.length; j++) {
                    if (tid == tidsArray[j].toString()) {
                        tidWeight = Number(tidsWeightsArray[j] || 0);
                        validTemplateIdArray.push(tid);
                        validTemplateWeightArray.push(tidWeight);
                        break;
                    }
                }
            }
            this.openingInfo.validTemplateIdArray = validTemplateIdArray;
            this.openingInfo.validTemplateWeightArray = validTemplateWeightArray;
            this.showNextAdv(data);
        }
        showNextAdv(data, info) {
            let validTemplateIdArray = this.openingInfo.validTemplateIdArray;
            let validTemplateWeightArray = this.openingInfo.validTemplateWeightArray;
            let index = ULTools.calcWheelTargetByArray(validTemplateWeightArray, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index == null) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]无有效模板展示");
                this.openingInfo = null;
                let mInfo = {
                    code: "",
                    msg: `广告位[${this.advId}]无有效模板展示`
                };
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info ? info : mInfo);
                return;
            }
            let templateId = validTemplateIdArray[index];
            this.openingInfo.tid = templateId;
            this.showTid = templateId;
            validTemplateIdArray.splice(index, 1);
            this.openingInfo.validTemplateIdArray = validTemplateIdArray;
            validTemplateWeightArray.splice(index, 1);
            this.openingInfo.validTemplateWeightArray = validTemplateWeightArray;
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(templateId);
            let type_ad_ecd = ULSdkManager.getInstance().advManager.getLaunchCdByType(advType);
            if (ULTools.time() - ULSdkManager.getInstance().advManager.sdkInitTime < type_ad_ecd / 1000) {
                ULLog.console.log(`ULAdvSlot-showNextAdv:广告${advType}处于启动请求cd中`);
                this.showNextAdv(data, {
                    code: "",
                    msg: `广告位[${this.advId}]对应广告类型${advType}处于启动请求cd中`
                });
                return;
            }
            let advTypeCd = ULSdkManager.getInstance().advManager.getAdvTypeCd(advType);
            if (advTypeCd > 0) {
                let lastTriggerTime = (ULSdkManager.getInstance().advManager.getAdvTypeLastTriggerTimeLog())[advType] || 0;
                let triggerGap = ULTools.time() - lastTriggerTime;
                ULLog.console.log(ULTools.format("ULAdvSlot-showNextAdv:检查广告类型cd。上次播放间隔%d秒，cd%d秒", triggerGap, advTypeCd / 1000));
                if (triggerGap <= advTypeCd / 1000) {
                    ULLog.console.log(ULTools.format("ULAdvSlot-showNextAdv:广告类型[%s]cd中，请%d后再试", advType, (advTypeCd / 1000) - triggerGap));
                    this.showNextAdv(data, {
                        code: "",
                        msg: `广告位[${this.advId}]对应广告类型${advType}处于播放间隔cd中`
                    });
                    return;
                }
            }
            let advTypeDailyLimit = ULSdkManager.getInstance().advManager.getAdvTypeDailyLimit(advType);
            if (advTypeDailyLimit > 0) {
                let dailyCount = (ULSdkManager.getInstance().advManager.getAdvTypeDailyCountLog())[advType] || 0;
                ULLog.console.log(ULTools.format("检查广告日限。今日已播放%d次，日限制%d次", dailyCount, advTypeDailyLimit));
                if (dailyCount >= advTypeDailyLimit) {
                    ULLog.console.log(ULTools.format("广告类型[%s]今日已播放%d次，限制%d次。无法播放。", advType, dailyCount, advTypeDailyLimit));
                    this.showNextAdv(data, {
                        code: "",
                        msg: `广告位[${this.advId}]对应${ULTools.format("广告类型[%s]今日已播放%d次，限制%d次。无法播放。", advType, dailyCount, advTypeDailyLimit)}`
                    });
                    return;
                }
            }
            if (ULSdkManager.getInstance().advManager.isAdvTypeOpened(advType)) {
                console.warn("ULAdvSlot-showNextAdv:一个广告类型，同一时间只允许启动一个广告");
                this.showNextAdv(data, {
                    code: "",
                    msg: `广告位[${this.advId}]对应广告类型${advType}已处于展示中，一个广告类型，同一时间只允许启动一个广告`
                });
                return;
            }
            let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(templateId);
            let rcd = ulAdvTemplate.rcd || 0;
            let lastRequestTime = ULAdvSlot.tid_lastRequestTime[templateId] || 0;
            let nowTime = (new Date()).valueOf();
            if ((nowTime - lastRequestTime) < rcd) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板【" + templateId + "】in rcd");
                this.showNextAdv(data, {
                    code: "",
                    msg: `广告位[${this.advId}]当前展示模板【 + ${templateId} + 】in rcd`
                });
                return;
            }
            else {
                ULAdvSlot.tid_lastRequestTime[templateId] = nowTime;
            }
            let scd = ulAdvTemplate.scd || 0;
            let lastShowTime = ULAdvSlot.tid_lastShowTime[templateId] || 0;
            nowTime = (new Date()).valueOf();
            if ((nowTime - lastShowTime) < scd) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板【" + templateId + "】in scd");
                this.showNextAdv(data, {
                    code: "",
                    msg: `广告位[${this.advId}]当前展示模板【 + ${templateId} + 】in scd`
                });
                return;
            }
            else {
            }
            let advObject = this.calcValidObjectByTemplateId(templateId);
            if (advObject == null) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板【" + templateId + "】未获取到可用广告对象");
                this.showNextAdv(data, {
                    code: "",
                    msg: `广告位[${this.advId}]当前展示模板【 + ${templateId} + 】未获取到可用广告对象`
                });
                return;
            }
            if (advType == typeExp.video) {
                let tag = data.tag || "";
                if (ULSdkManager.getInstance().advManager.isFirstPlayVideo) {
                    ULSdkManager.getInstance().advManager.isFirstPlayVideo = false;
                    let firstOpenVideoTimeSec = ULTools.time() - ULSdkManager.getInstance().advManager.sdkInitTime;
                    firstOpenVideoTimeSec = Math.floor(firstOpenVideoTimeSec);
                    if (isNaN(firstOpenVideoTimeSec))
                        firstOpenVideoTimeSec = 0;
                    if (firstOpenVideoTimeSec < ULConfig.getConfig()['t_sdk_miniplay_game_adv_point_first_click_event_report_time_limit']) {
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_game_adv_point_first_click_event_id'], tag, firstOpenVideoTimeSec.toString()]);
                    }
                }
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_game_click_video_event_id'], tag]);
            }
            if (advType == typeExp.inter) {
                let betweenCD = ULSdkManager.getInstance().advManager.getInterAndVideoBetweenCd();
                if (betweenCD) {
                    if (ULSdkManager.getInstance().advManager.videoCloseTime) {
                        if (ULTools.time() - ULSdkManager.getInstance().advManager.videoCloseTime < betweenCD / 1000) {
                            ULLog.console.log(`ULAdvSlot-showNextAdv:广告${advType}处于视频类型播放间隔cd中`);
                            this.showNextAdv(data, {
                                code: "",
                                msg: `广告位[${this.advId}]当前展示广告类型${advType}处于视频类型播放间隔cd中`
                            });
                            return;
                        }
                    }
                }
            }
            ULSdkManager.getInstance().advManager.updateAdvIds(advType, this.advId);
            let advKey = advObject.advKey;
            this.openingInfo.advTemplateItemName = advKey;
            ULLog.console.log("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板：" + JSON.stringify(this.openingInfo));
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShowRequest(advKey, data);
            data["playType"] = advType;
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(templateId);
            data["rewardType"] = rType;
            advObject.showAdv(data);
        }
        closeAdv(data) {
            let advKey = this.openingInfo.advTemplateItemName;
            let objectBase = ULSdkManager.getInstance().advManager.getAdvObjectByAdvKey(advKey);
            if (!objectBase) {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advobject未找到");
                return;
            }
            if (objectBase.isOpened) {
                objectBase.closeAdv(data);
            }
            else {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "广告未展示");
            }
        }
        getShowScheme() {
            let schemeList = this.getValidSchemes();
            if (!schemeList || schemeList.length == 0) {
                return null;
            }
            let validSchemes = [];
            for (const scheme of schemeList) {
                let validTemplates = this.getValidTemplates(scheme);
                if (validTemplates && validTemplates.length > 0) {
                    validSchemes.push(scheme);
                }
            }
            if (validSchemes.length == 0) {
                return null;
            }
            let weightArray = new Array(validSchemes.length);
            for (let i = 0; i < validSchemes.length; i++) {
                weightArray[i] = validSchemes[i].weight;
            }
            let index = ULTools.calcWheelTargetByArray(weightArray, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index != null) {
                return validSchemes[index];
            }
            return null;
        }
        getValidSchemes() {
            let validSchemes = [];
            for (let scheme of this.schemes) {
                if (!ULAdvExpManager.calcExp(scheme.exp)) {
                    continue;
                }
                let weight = scheme.weight;
                if (weight <= 0) {
                    continue;
                }
                if (weight == 100) {
                    validSchemes.unshift(scheme);
                }
                else {
                    validSchemes.push(scheme);
                }
            }
            if (validSchemes.length == 0) {
                return null;
            }
            return validSchemes;
        }
        getValidTemplates(scheme) {
            let validTemplates = [];
            let tids = scheme.tids;
            if (!tids || tids.length == 0) {
                return null;
            }
            for (let i = 0; i < tids.length; i++) {
                let tidS = tids[i];
                let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(tidS);
                if (!ulAdvTemplate) {
                    console.warn("ULAdvSlot-getValidTemplates:广告位【" + this.advId + "】对应的模板【" + tidS + "】不存在模板对象，需检查模板列表中是否配置该模板id");
                    continue;
                }
                if (!ULAdvExpManager.calcExp(ulAdvTemplate.exp)) {
                    continue;
                }
                let tidWeight = scheme.tidWeights[i];
                if (tidWeight <= 0) {
                    continue;
                }
                validTemplates.push(ulAdvTemplate);
            }
            return validTemplates;
        }
        calcValidObjectByTemplateId(tid) {
            let objectBases = ULSdkManager.getInstance().advManager.getAdvObjsByTid(tid);
            if (!objectBases || objectBases.length == 0)
                return null;
            let readyObjects = [];
            for (const base of objectBases) {
                if (base.preLoadState == ULConst.ADV_PRELOAD_STATE_READY) {
                    readyObjects.push(base);
                }
            }
            let targetObjects;
            if (readyObjects.length == 0) {
                targetObjects = objectBases;
            }
            else {
                targetObjects = readyObjects;
            }
            let argWeights = new Array(targetObjects.length);
            let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(tid);
            if (!ulAdvTemplate) {
                return null;
            }
            for (let j = 0, len = targetObjects.length; j < len; j++) {
                let objectBase = targetObjects[j];
                for (let i = 0, len = ulAdvTemplate.args.length; i < len; i++) {
                    let arg = ulAdvTemplate.args[i];
                    let key = ulAdvTemplate.moduleName + "_" + arg;
                    let argWeight = ulAdvTemplate.argWeights[i];
                    if (key == objectBase.advKey) {
                        argWeights[j] = argWeight;
                    }
                }
            }
            let index = ULTools.calcWheelTargetByArray(argWeights, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index != null) {
                return targetObjects[index];
            }
            return null;
        }
        onAdvObjectPreloadStateChanged(advKey) {
            if (!this.validAdvKeys || this.validAdvKeys.indexOf(advKey) == -1)
                return;
            this.refreshPreloadState();
        }
        refreshPreloadState() {
            let bHasLoading = false;
            let bHasReady = false;
            for (const advKey of this.validAdvKeys) {
                let state = ULSdkManager.getInstance().advManager.getAdvObjPreloadStateByAdvKey(advKey);
                if (state == ULConst.ADV_PRELOAD_STATE_LOADING) {
                    bHasLoading = true;
                }
                else if (state == ULConst.ADV_PRELOAD_STATE_READY) {
                    bHasReady = true;
                }
            }
            if (bHasReady) {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            }
            else if (bHasLoading) {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
            }
            else {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
            }
        }
        onAdvObjectLifeCycleSkip(data, info) {
            if (this.openingInfo == null) {
                return;
            }
            if (this.openingInfo != null) {
                this.openingInfo.advTemplateItemName = null;
            }
            this.showNextAdv(data, info);
        }
        onAdvObjectLifeCycleShow(msg, data) {
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(this.showTid);
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(this.showTid);
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, { code: "", msg: msg });
            if (rewardType.show == rType) {
                ULSdkManager.getInstance().advManager.responseRewardAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            }
        }
        onAdvObjectLifeCycleClick(msg, data) {
            ULSdkManager.getInstance().advManager.responseClickAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(this.showTid);
            if (rewardType.click == rType) {
                ULSdkManager.getInstance().advManager.responseRewardAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            }
        }
        onAdvObjectLifeCycleClose() {
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(this.showTid);
            ULSdkManager.getInstance().advManager.deleteAdvIdOpening(advType, this.advId);
            this.openingInfo = null;
            if (advType == typeExp.video) {
                !window['my'] && ULSdkManager.getInstance().advManager.resumeSound();
                ULAdvSlot.tid_lastShowTime[this.showTid] = (new Date()).valueOf();
            }
        }
        onAdvObjectLifeCycleFail(info, data) {
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info);
            this.openingInfo = null;
        }
    }
    ULAdvSlot.tid_lastRequestTime = {};
    ULAdvSlot.tid_lastShowTime = {};

    class ULAdvItem {
        constructor(advId, userData, tag) {
            this.advId = advId;
            this.advType = ULSdkManager.getInstance().advManager.searchAdvTypeByAdvId(advId);
            this.advGroupId = ULSdkManager.getInstance().advManager.searchAdvGroupIdByAdvId(advId);
            this.userData = userData;
            this.tag = tag;
            this.serialId = ULAdvItem.SERIAL_ID++;
            this.bOpenAdvResultResponsed = false;
            this.bClickAdvResultResponsed = false;
            this.lifeCycleLog = {};
            this.bRequesting = true;
            this.statisChannelName = "";
            this.statisSdkAdvId = "";
            this.statisNativeAdTitle = "";
        }
        startimeoutTimer(timeoutSec) {
            if (this.timeoutTimer)
                return;
            this.timeoutTimer = new ULTimer(timeoutSec, 1, () => {
                ULSdkManager.getInstance().advManager.onAdvTimeout(this);
            });
            this.timeoutTimer.start();
        }
        stopTimeoutTimer() {
            if (this.timeoutTimer) {
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
        setLifeCycleLogAllCycle() {
            this.lifeCycleLog = {
                0: true, 1: true, 2: true, 3: true, 4: true, 5: true
            };
        }
        set advData(data) {
            this._advData = data;
        }
        get advData() {
            return this._advData;
        }
    }
    ULAdvItem.SERIAL_ID = 0;

    var typeExp;
    (function (typeExp) {
        typeExp["all"] = "all";
        typeExp["splash"] = "splash";
        typeExp["inter"] = "inter";
        typeExp["video"] = "video";
        typeExp["custom"] = "custom";
        typeExp["interVideo"] = "interVideo";
        typeExp["banner"] = "banner";
        typeExp["embed"] = "embed";
        typeExp["url"] = "url";
        typeExp["paster"] = "paster";
        typeExp["share"] = "share";
        typeExp["icon"] = "icon";
    })(typeExp || (typeExp = {}));
    var rewardType;
    (function (rewardType) {
        rewardType["show"] = "show";
        rewardType["click"] = "click";
    })(rewardType || (rewardType = {}));
    var countExp;
    (function (countExp) {
        countExp["rc"] = "rc";
        countExp["sc"] = "sc";
        countExp["cc"] = "cc";
        countExp["fc"] = "fc";
        countExp["mcc"] = "mcc";
    })(countExp || (countExp = {}));
    var cdExp;
    (function (cdExp) {
        cdExp["rcd"] = "rcd";
        cdExp["scd"] = "scd";
        cdExp["ecd"] = "ecd";
    })(cdExp || (cdExp = {}));
    var dataExp;
    (function (dataExp) {
        dataExp["t"] = "t";
        dataExp["d"] = "d";
        dataExp["w"] = "w";
        dataExp["m"] = "m";
        dataExp["y"] = "y";
    })(dataExp || (dataExp = {}));
    var openResult;
    (function (openResult) {
        openResult["totalAdvRequest"] = "totalAdvRequest";
        openResult["branchAdvRequest"] = "branchAdvRequest";
        openResult["success"] = "success";
        openResult["failed"] = "failed";
        openResult["clicked"] = "clicked";
        openResult["playStart"] = "playStart";
        openResult["playCompletion"] = "playCompletion";
        openResult["loadAdvRequest"] = "loadAdvRequest";
        openResult["close"] = "close";
        openResult["hide"] = "hide";
    })(openResult || (openResult = {}));
    var oldTypeExp;
    (function (oldTypeExp) {
        oldTypeExp["interstitial"] = "interstitial";
        oldTypeExp["embedded"] = "embedded";
        oldTypeExp["fullscreen"] = "fullscreen";
    })(oldTypeExp || (oldTypeExp = {}));
    class ULAdvManager {
        constructor() {
            this.systemAdvExpKeyArray = [];
            this.advExpKeyArray = [];
            this.advRequestSerialNum = 0;
            this.advId_2_advSlot = {};
            this.templateId_2_advTemplate = {};
            this.templateId_2_advTemplateItemArray = {};
            this.advKey_2_templateIdArray = {};
            this.moduleName_2_argsArray = {};
            this.moduleName_2_advIdsArray = {};
            this.templateId_2_moduleName = {};
            this.moduleName_2_advTemplate = {};
            this.mainName_2_advObjectArray = {};
            this.templateId_2_advObjectArray = {};
            this.advType_2_advObjectArray = {};
            this.moduleName_2_templateIdsArray = {};
            this.logKey_2_countNum = {};
            this.advKey_2_advIdArray = {};
            this.tid_2_advKeyArray = {};
            this.advId_2_tidArray = {};
            this.nativeType_2_advObjectArray = {};
            this.advKey_2_advObject = {};
            this.ADV_RELOAD_DEFAULT_TIME = 15000;
            this.ADV_RELOAD_TIME = 15000;
            this.bannerStartShowTime = 0;
            this.advKey_2_rcd = {};
            this.advKey_2_scd = {};
            this.advId_2_lastRequestTime = {};
            this.adMainName_2_obj = {};
            this.type_2_advIds = {};
            this.exp_2_result = {};
            this.advTypeLastTriggerTimeLog = {};
            this._videoCloseTime = 0;
        }
        static getInstance() {
            if (this.instance == null) {
                this.instance = new ULAdvManager();
            }
            return this.instance;
        }
        get videoCloseTime() {
            return this._videoCloseTime;
        }
        get isFirstPlayVideo() {
            return this._isFirstPlayVideo;
        }
        set isFirstPlayVideo(v) {
            this._isFirstPlayVideo = v;
        }
        get isReturnSuccess() {
            return this._isReturnSuccess;
        }
        set isReturnSuccess(v) {
            this._isReturnSuccess = v;
        }
        init() {
            ULLog.console.log("ULAdvManager-init");
            let config = ULConfig.getConfig();
            let key = `ULModuleDefault_record_${config['s_prj_id']}`;
            let recordStr = ULStorageManager.getInstance().getStorage(key);
            let record = {};
            if (recordStr) {
                try {
                    record = JSON.parse(recordStr);
                }
                catch (error) {
                    record = {};
                }
            }
            if (record['bCanCheckWhite']) {
                let channelInfo = ULSdkManager.getInstance().channelInfo;
                if (channelInfo && !!channelInfo.getChannelOpenIdFunc) {
                    let self = this;
                    let networkCallback = (openId) => {
                        let gameId = config.s_prj_id;
                        let channelId = config.s_sdk_cop_channel_id;
                        let userId = channelInfo._sdkUserId;
                        let netTimeout = config.i_net_timeout;
                        let url = `${config['s_sdk_white_user_check_url']}?gameId=${gameId}&userId=${userId}&openId=${openId}&channelId=${channelId}&platform=H5&userName=&adFree=1`;
                        ULTools.httpGet({
                            url: url,
                            timeoutMillisecond: netTimeout,
                            success: (responseText) => {
                                let jsonData = null;
                                try {
                                    jsonData = JSON.parse(responseText);
                                }
                                catch (error) {
                                    jsonData = {
                                        code: 0,
                                        msg: "responseText"
                                    };
                                }
                                let code = jsonData.code || 0;
                                let msg = jsonData.msg || "未知错误";
                                code == 1 ? (self.isReturnSuccess = true) : ULLog.console.error("白名单校验失败：", msg);
                                ;
                            },
                            fail: (err) => {
                                ULLog.console.error("白名单校验失败：", err);
                            }
                        });
                    };
                    channelInfo.getChannelOpenIdFunc((openId, err) => {
                        openId ? networkCallback(openId) : ULLog.console.error("openId获取失败");
                    });
                }
                else {
                    ULLog.console.warn("该渠道暂不支持获取openId");
                }
            }
            this.loadRecord();
            this.initAdvExpKey();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_ADV, ULConst.PRIORITY_NONE, this.onCmdOpenAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLOSE_ADV, ULConst.PRIORITY_NONE, this.onCmdCloseAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLOSE_NATIVE_ADV, ULConst.PRIORITY_NONE, this.onCmdCloseNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLICK_NATIVE_ADV, ULConst.PRIORITY_NONE, this.onCmdClickNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_ADV_STATE, ULConst.PRIORITY_NONE, this.onCmdGetAdvState.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_COP_CHANGED, 1, this.onCopChanged.bind(this));
            this._sdkInitTime = ULTools.time();
            this.isFirstPlayVideo = true;
        }
        loadRecord() {
            let oldRecord = ULStorageManager.getInstance().getStorage(this._getRecordKey());
            let newKey = ULTools.format("ULAdvManager_record_%s", ULConfig.getConfig().s_prj_id);
            if (oldRecord) {
                ULStorageManager.getInstance().setStorage(this._getRecordKey(), "");
                ULStorageManager.getInstance().setStorage(newKey, oldRecord);
            }
            let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.advTypeDailyCountLog = record.advTypeDailyCountLog || {};
            this.advTypeDailyRefreshTime = record.advTypeDailyRefreshTime || 0;
            this.tryDailyRefresh();
        }
        saveRecord() {
            let oldRecord = ULStorageManager.getInstance().getStorage(this._getRecordKey());
            let newKey = ULTools.format("ULAdvManager_record_%s", ULConfig.getConfig().s_prj_id);
            if (oldRecord) {
                ULStorageManager.getInstance().setStorage(this._getRecordKey(), "");
                ULStorageManager.getInstance().setStorage(newKey, oldRecord);
            }
            let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            record.advTypeDailyCountLog = this.advTypeDailyCountLog || {};
            record.advTypeDailyRefreshTime = this.advTypeDailyRefreshTime || 0,
                ULStorageManager.getInstance().setStorage(newKey, JSON.stringify(record));
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULAdvManager_record_%d", config.s_sdk_megadata_game_id);
        }
        tryDailyRefresh() {
            if (!ULTools.isOneDay(this.advTypeDailyRefreshTime, ULTools.time())) {
                ULLog.console.log("ULAdvManager-tryDailyRefresh 进行日常刷新");
                this.advTypeDailyCountLog = {};
                this.advTypeDailyRefreshTime = ULTools.time();
                this.saveRecord();
            }
        }
        searchAdvGroupIdByAdvId(advId) {
            let config = ULConfig.getConfig();
            let advInfo = config.s_sdk_adv_info;
            let advGroupId = "";
            ULTools.forEachMap(advInfo, (k, v) => {
                if (v.group.indexOf(advId) >= 0) {
                    advGroupId = k;
                    return true;
                }
            });
            return advGroupId;
        }
        searchAdvTypeByAdvId(advId) {
            let config = ULConfig.getConfig();
            let advInfo = config.s_sdk_adv_info;
            let advType = "";
            ULTools.forEachMap(advInfo, (k, v) => {
                if (v.group.indexOf(advId) >= 0) {
                    advType = v.type;
                    return true;
                }
            });
            return advType;
        }
        onCopChanged(e) {
            try {
                this.initAdv();
            }
            catch (error) {
                ULLog.console.error("ULAdvManager.onCopChanged err:", error.stack);
            }
        }
        onCmdSdkOnGameResume(e) {
            ULLog.console.log("ULAdvManager-onCmdSdkOnGameResume");
            let objectBase = this.getAdvObjectOpeningByAdvType(typeExp.banner);
            if (!objectBase)
                return;
            this.bannerStartShowTime = ULTools.time();
        }
        onCmdSdkOnGamePause(e) {
            let objectBase = this.getAdvObjectOpeningByAdvType(typeExp.banner);
            if (!objectBase)
                return;
            let nativeData;
            if (objectBase instanceof ULAdvNativeObjectBase) {
                nativeData = objectBase.nativeData;
            }
            this.reportBannerShowTime(objectBase.advKey, objectBase.showData, nativeData);
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let advTypes = ["interstitial", "banner", "embedded", "video", "url", "paster"];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "广告cd限制:" });
            config.push({ type: "newLine" });
            for (let i = 0; i < advTypes.length; i++) {
                const advType = advTypes[i];
                let cdTag = "未配置CD";
                let lastTriggerTag = "未触发";
                let cd = this.getAdvTypeCd(advType);
                if (cd > 0) {
                    cdTag = ULTools.format("CD%d秒", cd / 1000);
                }
                let lastTriggerTime = this.advTypeLastTriggerTimeLog[advType] || 0;
                if (lastTriggerTime > 0) {
                    lastTriggerTag = ULTools.formatDate(new Date(lastTriggerTime * 1000), "触发时间：HH:mm:ss");
                }
                config.push({ type: "label", text: ULTools.format("%s: %s %s", advType, cdTag, lastTriggerTag) });
                config.push({ type: "newLine" });
            }
            config.push({ type: "label", text: "广告次数限制:" });
            config.push({ type: "newLine" });
            for (let i = 0; i < advTypes.length; i++) {
                const advType = advTypes[i];
                let limitTag = "未配置次数限制";
                let countTag = "未触发";
                let dailyLimit = this.getAdvTypeDailyLimit(advType);
                if (dailyLimit > 0) {
                    limitTag = ULTools.format("日限制%d次", dailyLimit);
                }
                let dailyCount = this.advTypeDailyCountLog[advType] || 0;
                if (dailyCount > 0) {
                    countTag = ULTools.format("今日已触发%d次", dailyCount);
                }
                config.push({ type: "label", text: ULTools.format("%s: %s %s", advType, limitTag, countTag) });
                config.push({ type: "newLine" });
            }
            e.setReturnValue(config, true);
        }
        initAdv() {
            let old_advKey_2_advObject = this.advKey_2_advObject;
            this.advKey_2_advObject = {};
            this.advId_2_advSlot = {};
            this.templateId_2_advTemplate = {};
            this.templateId_2_advTemplateItemArray = {};
            this.advKey_2_templateIdArray = {};
            this.templateId_2_moduleName = {};
            this.mainName_2_advObjectArray = {};
            this.templateId_2_advObjectArray = {};
            this.advType_2_advObjectArray = {};
            this.moduleName_2_templateIdsArray = {};
            this.logKey_2_countNum = {};
            this.advKey_2_advIdArray = {};
            this.tid_2_advKeyArray = {};
            this.advId_2_tidArray = {};
            this.nativeType_2_advObjectArray = {};
            this.advKey_2_rcd = {};
            this.advKey_2_scd = {};
            let config = ULConfig.getConfig();
            this.ADV_RELOAD_TIME = config["i_sdk_adv_reload_time"] || this.ADV_RELOAD_DEFAULT_TIME;
            let showListS = config["o_sdk_adv_show_list"];
            if (!showListS || typeof (showListS) !== "string") {
                console.warn("ULAdvManager-initAdv:adv show list error");
                return;
            }
            let showListObject = JSON.parse(showListS);
            let templatesObj = showListObject["templates"] || {};
            let advSlotsObj = showListObject["advSlots"] || {};
            Object.keys(showListObject).forEach(key => {
                if (Object.keys(typeExp).map(type => typeExp[type].toString()).indexOf(key) != -1) {
                    let typeListS = showListObject[key];
                    let typeList = typeListS.split(";");
                    let tids = [];
                    for (let i = 0; i < typeList.length; i++) {
                        const item = typeList[i];
                        let itemList = item.split("|");
                        let moduleName = itemList[0];
                        let arg = "";
                        try {
                            arg = itemList[1];
                            if (!arg) {
                                console.warn(`ULAdvManager-initAdv:类型【${key}】对应【 ${moduleName} 】缺少必配参数`);
                                continue;
                            }
                        }
                        catch (error) {
                            console.warn(`ULAdvManager-initAdv:类型【${key}】对应【 ${moduleName} 】缺少必配参数`);
                            continue;
                        }
                        let reward = undefined;
                        try {
                            reward = itemList[2];
                        }
                        catch (error) {
                        }
                        if (!reward)
                            reward = rewardType.show.toString();
                        let templateId = `${key}_${i}`;
                        if (templatesObj.hasOwnProperty(templateId)) {
                            templateId = `${key}_${i}_${arg}`;
                        }
                        tids.push(templateId);
                        templatesObj[templateId] = {
                            moduleName: moduleName,
                            rewardType: reward,
                            args: [arg]
                        };
                    }
                    advSlotsObj[key] = {
                        schemes: [{
                                tids: tids
                            }]
                    };
                }
            });
            this.updateAdvExpKey(templatesObj);
            let templateArray = new Array();
            for (const key in templatesObj) {
                if (!key) {
                    console.warn(`ULAdvManager-initAdv:模板命令非法`);
                    continue;
                }
                let templateId = key;
                let templateItem = templatesObj[templateId];
                if (typeof (templateItem) !== "object") {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】格式配置非法`);
                    continue;
                }
                let moduleName = templateItem['moduleName'];
                if (!moduleName || (typeof moduleName) !== "string") {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】缺少必配字段moduleName`);
                    continue;
                }
                let args = templateItem['args'];
                if (!args || !(args instanceof Array)) {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】缺少必配字段args，或格式非法`);
                    continue;
                }
                if (args.length == 0) {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】必配字段args长度不能为0`);
                    continue;
                }
                let reward = templateItem['rewardType'] || rewardType.show.toString();
                let exp = templateItem['exp'] || "";
                let argWeights = templateItem["argWeights"] || [];
                let loadTypes = templateItem["loadTypes"] || [];
                let rcd = templateItem["rcd"];
                if ((typeof rcd) !== "number") {
                    rcd = 0;
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】字段rcd未配置或格式错误，写入默认值0`);
                }
                let scd = templateItem["scd"];
                if ((typeof scd) !== "number") {
                    scd = 0;
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】字段scd未配置或格式错误，写入默认值0`);
                }
                let templateIdsArray = this.moduleName_2_templateIdsArray[moduleName];
                if (!templateIdsArray) {
                    templateIdsArray = [];
                    templateIdsArray.push(templateId);
                    this.moduleName_2_templateIdsArray[moduleName] = templateIdsArray;
                }
                else {
                    if (templateIdsArray.indexOf(templateId) == -1) {
                        templateIdsArray.push(templateId);
                    }
                }
                if (!this.templateId_2_moduleName[templateId]) {
                    this.templateId_2_moduleName[templateId] = moduleName;
                }
                if (templateArray.indexOf(templateId) == -1) {
                    templateArray.push(templateId);
                }
                let newArgWeights = [];
                let newLoadTypes = [];
                for (let i = 0, len = args.length; i < len; i++) {
                    let arg = args[i];
                    if (typeof (arg) !== "string") {
                        console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】字段args中的参数${arg}，为非字符串类型`);
                        arg = arg.toString();
                    }
                    let argWeight = 0;
                    if (argWeights.length == 0) {
                        argWeight = ULConst.ADV_RANDOM_DEFAULT_WEIGHT;
                    }
                    else {
                        argWeight = argWeights[i];
                    }
                    newArgWeights.push(argWeight);
                    let loadType = undefined;
                    try {
                        loadType = loadTypes[i];
                        if (loadType && typeof (loadType) !== "number") {
                            loadType = Number(loadType);
                        }
                    }
                    catch (error) {
                    }
                    newLoadTypes.push(loadType);
                    let ulAdvTemplateItem = {
                        templateId: templateId,
                        moduleName: moduleName,
                        rewardType: reward,
                        arg: arg,
                        argWeight: argWeight,
                        exp: exp,
                        loadType: loadType
                    };
                    let templateItemArray = this.templateId_2_advTemplateItemArray[templateId];
                    if (!templateItemArray) {
                        templateItemArray = [];
                        templateItemArray.push(ulAdvTemplateItem);
                        this.templateId_2_advTemplateItemArray[templateId] = templateItemArray;
                    }
                    else {
                        let bContains = false;
                        for (const item of templateItemArray) {
                            let key = item.templateId + "_" + item.arg;
                            let targetKey = templateId + "_" + arg;
                            if (key == targetKey) {
                                bContains = true;
                            }
                        }
                        if (!bContains) {
                            templateItemArray.push(ulAdvTemplateItem);
                        }
                    }
                    let advKey = ULTools.format("%s%s%s", moduleName, "_", arg);
                    let tidArray = this.advKey_2_templateIdArray[advKey];
                    if (!tidArray) {
                        tidArray = [];
                        tidArray.push(templateId);
                        this.advKey_2_templateIdArray[advKey] = tidArray;
                    }
                    else {
                        if (tidArray.indexOf(templateId) == -1) {
                            tidArray.push(templateId);
                        }
                    }
                    let advkeyArray = this.tid_2_advKeyArray[templateId];
                    if (!advkeyArray) {
                        advkeyArray = [];
                        advkeyArray.push(advKey);
                        this.tid_2_advKeyArray[templateId] = advkeyArray;
                    }
                    else {
                        if (advkeyArray.indexOf(advKey) == -1) {
                            advkeyArray.push(advKey);
                        }
                    }
                    let num = this.advKey_2_rcd[advKey];
                    let mRcd;
                    if (num != undefined) {
                        mRcd = Math.min(rcd, num);
                    }
                    else {
                        mRcd = rcd;
                    }
                    this.advKey_2_rcd[advKey] = mRcd;
                    num = this.advKey_2_scd[advKey];
                    let mScd;
                    if (num != undefined) {
                        mScd = Math.min(scd, num);
                    }
                    else {
                        mScd = scd;
                    }
                    this.advKey_2_scd[advKey] = mScd;
                }
                let advTemplate = {
                    templateId: templateId,
                    moduleName: moduleName,
                    rewardType: reward,
                    exp: exp,
                    args: args,
                    argWeights: newArgWeights,
                    rcd: rcd,
                    scd: scd,
                    loadTypes: newLoadTypes
                };
                if (!this.templateId_2_advTemplate[templateId]) {
                    this.templateId_2_advTemplate[templateId] = advTemplate;
                }
            }
            let tidsInAdvSlotsArray = [];
            for (const key in advSlotsObj) {
                if (!key) {
                    console.warn(`ULAdvManager-initAdv:广告位配置非法`);
                    continue;
                }
                let advId = key;
                let advSlotItem = advSlotsObj[advId];
                if (typeof (advSlotItem) !== "object") {
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】格式配置非法`);
                    continue;
                }
                let schemesArray = advSlotItem["schemes"];
                if (!schemesArray) {
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】缺少必配字段schemes,或该字段格式非法`);
                    continue;
                }
                let subAidsArray = advSlotItem["subAids"] || [];
                let rcd = advSlotItem["rcd"];
                if ((typeof rcd) !== "number") {
                    rcd = 0;
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】字段rcd未配置或格式错误，写入默认值0`);
                }
                let schemeArray = [];
                for (let i = 0, len = schemesArray.length; i < len; i++) {
                    const schemeItemObj = schemesArray[i];
                    let tids = schemeItemObj["tids"];
                    if (!tids) {
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略缺少必配字段tids,或该字段格式非法`);
                        continue;
                    }
                    if (tids.length == 0) {
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略必配字段tids长度不能为0`);
                        continue;
                    }
                    let tidWeights = schemeItemObj["tidWeights"] || [];
                    let newTidWeights = [];
                    for (let j = 0, len = tids.length; j < len; j++) {
                        let tid = tids[j];
                        let tidWeight = 0;
                        if (tidWeights.length == 0) {
                            console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略第【 ${j + 1} 】个模板权重未配置，写入默认值${ULConst.ADV_MUST_DEFAULT_WEIGHT}`);
                            tidWeight = ULConst.ADV_MUST_DEFAULT_WEIGHT;
                        }
                        else {
                            let tidW = tidWeights[j];
                            if ((typeof tidW) !== "number") {
                                console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略第【 ${j + 1} 】个模板权重格式异常，写入默认值${ULConst.ADV_MUST_DEFAULT_WEIGHT}`);
                                tidWeight = ULConst.ADV_MUST_DEFAULT_WEIGHT;
                            }
                            else {
                                tidWeight = tidW;
                            }
                        }
                        newTidWeights.push(tidWeight);
                        if (tidsInAdvSlotsArray.indexOf(tid) == -1) {
                            tidsInAdvSlotsArray.push(tid);
                        }
                        let tidArray = this.advId_2_tidArray[advId];
                        if (!tidArray) {
                            tidArray = [];
                            tidArray.push(tid);
                            this.advId_2_tidArray[advId] = tidArray;
                        }
                        else {
                            if (tidArray.indexOf(tid) == -1) {
                                tidArray.push(tid);
                            }
                        }
                        if (subAidsArray.length > 0) {
                            for (const advId of subAidsArray) {
                                if (!advId) {
                                    continue;
                                }
                                let tidArray = this.advId_2_tidArray[advId];
                                if (!tidArray) {
                                    tidArray = [];
                                    tidArray.push(tid);
                                    this.advId_2_tidArray[advId] = tidArray;
                                }
                                else {
                                    if (tidArray.indexOf(tid) == -1) {
                                        tidArray.push(tid);
                                    }
                                }
                            }
                        }
                    }
                    let exp = schemeItemObj["exp"] || "";
                    let weight = schemeItemObj["weight"];
                    if ((typeof weight) !== "number") {
                        weight = ULConst.ADV_RANDOM_DEFAULT_WEIGHT;
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略字段weight格式异常，写入默认值${ULConst.ADV_RANDOM_DEFAULT_WEIGHT}`);
                    }
                    let ulAdvScheme = {
                        tids: tids,
                        tidWeights: newTidWeights,
                        exp: exp,
                        weight: weight
                    };
                    schemeArray.push(ulAdvScheme);
                }
                let advSlot = new ULAdvSlot(advId, schemeArray, subAidsArray, rcd);
                if (!this.advId_2_advSlot[advId]) {
                    this.advId_2_advSlot[advId] = advSlot;
                }
                if (subAidsArray.length > 0) {
                    for (const mAdvId of subAidsArray) {
                        let newSubAidsArray = ULTools.clone(subAidsArray);
                        let index = newSubAidsArray.indexOf(mAdvId);
                        if (index > -1) {
                            newSubAidsArray.splice(index, 1);
                        }
                        newSubAidsArray.push(advId);
                        let subIdAdvSlot = new ULAdvSlot(mAdvId, schemeArray, newSubAidsArray, rcd);
                        if (!this.advId_2_advSlot[mAdvId]) {
                            this.advId_2_advSlot[mAdvId] = subIdAdvSlot;
                        }
                    }
                }
            }
            ULTools.forEachMap(this.advId_2_tidArray, (advId, tidArray) => {
                for (const tid of tidArray) {
                    let advKeyArray = this.tid_2_advKeyArray[tid];
                    if (!advKeyArray)
                        continue;
                    for (const key of advKeyArray) {
                        let advIdArray = this.advKey_2_advIdArray[key];
                        if (!advIdArray) {
                            advIdArray = [];
                            advIdArray.push(advId);
                            this.advKey_2_advIdArray[key] = advIdArray;
                        }
                        else {
                            if (advIdArray.indexOf(advId) == -1) {
                                advIdArray.push(advId);
                            }
                        }
                    }
                }
            });
            let newAdvBaseObjectArray = [];
            for (const tid in this.templateId_2_advTemplateItemArray) {
                let tidItemArray = this.templateId_2_advTemplateItemArray[tid];
                if (tidsInAdvSlotsArray.indexOf(tid) == -1) {
                    console.warn("ULAdvManager-initAdv:tid [" + tid + "] no advId use");
                    continue;
                }
                let moduleName = this.templateId_2_moduleName[tid];
                let moduleMainClass;
                ULTools.forEachMap(ULSdkModuleLoader.getSubAdModuleClassName(), (k, v) => {
                    let moduleNameArray = v;
                    if (moduleNameArray.indexOf(moduleName) >= 0) {
                        moduleMainClass = k;
                        return true;
                    }
                });
                if (!moduleMainClass) {
                    console.warn("ULAdvManager-initAdv: class " + moduleName + " not found ,continue");
                    continue;
                }
                for (let i = 0, len = tidItemArray.length; i < len; i++) {
                    let templateItem = tidItemArray[i];
                    let advKey = templateItem.moduleName + "_" + templateItem.arg;
                    let targetObj = null;
                    if (old_advKey_2_advObject[advKey]) {
                        let obj = old_advKey_2_advObject[advKey];
                        this.advKey_2_advObject[advKey] = obj;
                        delete old_advKey_2_advObject[advKey];
                    }
                    if (this.advKey_2_advObject[advKey]) {
                        console.warn("ULAdvManger-initAdv: class " + moduleName + " already init,continue");
                        targetObj = this.advKey_2_advObject[advKey];
                    }
                    else {
                        let mainObj = ULSdkModuleLoader.getObjectByModuleName(moduleMainClass);
                        targetObj = mainObj.createSubAdObj(moduleName, templateItem.arg);
                    }
                    targetObj.setLoadType = templateItem.loadType;
                    let advMainClassNameString = targetObj.getMainClassNameString();
                    if (newAdvBaseObjectArray.indexOf(targetObj) == -1) {
                        newAdvBaseObjectArray.push(targetObj);
                    }
                    let templateItemObjectArray = this.mainName_2_advObjectArray[advMainClassNameString];
                    if (!templateItemObjectArray) {
                        templateItemObjectArray = [];
                        templateItemObjectArray.push(targetObj);
                        this.mainName_2_advObjectArray[advMainClassNameString] = templateItemObjectArray;
                    }
                    else {
                        if (templateItemObjectArray.indexOf(targetObj) == -1) {
                            templateItemObjectArray.push(targetObj);
                        }
                    }
                    let templateItemObjectsArray = this.templateId_2_advObjectArray[tid];
                    if (!templateItemObjectsArray) {
                        templateItemObjectsArray = [];
                        templateItemObjectsArray.push(targetObj);
                        this.templateId_2_advObjectArray[tid] = templateItemObjectsArray;
                    }
                    else {
                        if (templateItemObjectsArray.indexOf(targetObj) == -1) {
                            templateItemObjectsArray.push(targetObj);
                        }
                    }
                    if (targetObj instanceof ULAdvNativeObjectBase) {
                        let type = targetObj.advType;
                        let ulAdvNativeObjectBases = this.nativeType_2_advObjectArray[type];
                        if (ulAdvNativeObjectBases == null) {
                            ulAdvNativeObjectBases = [];
                            ulAdvNativeObjectBases.push(targetObj);
                            this.nativeType_2_advObjectArray[type] = ulAdvNativeObjectBases;
                        }
                        else {
                            if (ulAdvNativeObjectBases.indexOf(targetObj) == -1) {
                                ulAdvNativeObjectBases.push(targetObj);
                            }
                        }
                    }
                }
            }
            ;
            ULTools.forEachMap(this.advKey_2_advObject, (k, v) => {
                let objectBase = v;
                let bases = this.advType_2_advObjectArray[objectBase.advType];
                if (!bases) {
                    bases = [];
                    bases.push(objectBase);
                    this.advType_2_advObjectArray[objectBase.advType] = bases;
                }
                else {
                    if (bases.indexOf(objectBase) == -1) {
                        bases.push(objectBase);
                    }
                }
            });
            for (const key in old_advKey_2_advObject) {
                let object = old_advKey_2_advObject[key];
                object.onDisposeModule();
            }
            ULTools.forEachMap(this.advId_2_advSlot, (advId, advSlot) => {
                let slot = advSlot;
                slot.refreshValidAdvKeys();
            });
            let newAdvBaseCache = {};
            for (let i = 0, len = newAdvBaseObjectArray.length; i < len; i++) {
                let advObjectBaseCacheItem = newAdvBaseObjectArray[i];
                let advMainClassNameString = advObjectBaseCacheItem.getMainClassNameString();
                ULTools.forEachMap(ULSdkModuleLoader.getSubAdMainClassName(), (k, v) => {
                    let adMainClassName = v;
                    if (advMainClassNameString == adMainClassName) {
                        if (this.adMainName_2_obj[adMainClassName]) {
                            let targetObj = this.adMainName_2_obj[adMainClassName];
                            advObjectBaseCacheItem.receiveMainClassInitState(targetObj.initState);
                        }
                        else if (!newAdvBaseCache[adMainClassName]) {
                            let obj = ULSdkModuleLoader.getObjectByModuleName(k);
                            let targetObj = obj.createMainAdObj();
                            newAdvBaseCache[adMainClassName] = targetObj;
                        }
                    }
                });
            }
            for (const key in newAdvBaseCache) {
                this.adMainName_2_obj[key] = newAdvBaseCache[key];
            }
            ULLog.console.log("ULAdvManager-initAdv-advExpKeyArray:", this.advExpKeyArray);
            ULLog.console.log("ULAdvManager-initAdv-templateArray:", templateArray);
            ULLog.console.log("ULAdvManager-initAdv-advId_2_advSlot:", this.advId_2_advSlot);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advTemplate:", this.templateId_2_advTemplate);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advTemplateItemArray:", this.templateId_2_advTemplateItemArray);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_templateIdArray:", this.advKey_2_templateIdArray);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_moduleName:", this.templateId_2_moduleName);
            ULLog.console.log("ULAdvManager-initAdv-mainName_2_advObjectArray:", this.mainName_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advObjectArray:", this.templateId_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-advType_2_advObjectArray:", this.advType_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-moduleName_2_templateIdsArray:", this.moduleName_2_templateIdsArray);
            ULLog.console.log("ULAdvManager-initAdv-logKey_2_countNum:", this.logKey_2_countNum);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_advIdArray:", this.advKey_2_advIdArray);
            ULLog.console.log("ULAdvManager-initAdv-tid_2_advKeyArray:", this.tid_2_advKeyArray);
            ULLog.console.log("ULAdvManager-initAdv-advId_2_tidArray:", this.advId_2_tidArray);
            ULLog.console.log("ULAdvManager-initAdv-nativeType_2_advObjectArray:", this.nativeType_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_advObject:", this.advKey_2_advObject);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_rcd:", this.advKey_2_rcd);
        }
        getAdvReloadTime() {
            return this.ADV_RELOAD_TIME;
        }
        getAdvExpKeyArray() {
            return this.advExpKeyArray;
        }
        getLogKeyCountNum() {
            return this.logKey_2_countNum;
        }
        initAdvExpKey() {
            let keyArray = new Array();
            for (const type in typeExp) {
                for (const count in countExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TYPE_CONST, type, ULConst.EXP_ADV_POINT_CONST, count);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
                for (const cd in cdExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TYPE_CONST, type, ULConst.EXP_ADV_POINT_CONST, cd);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
            }
            for (let i = 0; i < keyArray.length; i++) {
                let key = keyArray[i];
                for (const data in dataExp) {
                    let newKey;
                    if (data == dataExp.t) {
                        newKey = key;
                    }
                    else {
                        newKey = data + key;
                    }
                    if (this.systemAdvExpKeyArray.indexOf(newKey) == -1) {
                        this.systemAdvExpKeyArray.push(newKey);
                    }
                }
            }
        }
        updateAdvExpKey(templatesObj) {
            this.advExpKeyArray = this.systemAdvExpKeyArray.slice(0);
            let keyArray = new Array();
            for (const template in templatesObj) {
                for (const count in countExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TEMPLATE_CONST, template, ULConst.EXP_ADV_POINT_CONST, count);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
                for (const cd in cdExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TEMPLATE_CONST, template, ULConst.EXP_ADV_POINT_CONST, cd);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
            }
            for (let i = 0; i < keyArray.length; i++) {
                let key = keyArray[i];
                for (const data in dataExp) {
                    let newKey;
                    if (data == dataExp.t) {
                        newKey = key;
                    }
                    else {
                        newKey = data + key;
                    }
                    if (this.advExpKeyArray.indexOf(newKey) == -1) {
                        this.advExpKeyArray.push(newKey);
                    }
                }
            }
            ULAdvExpManager.updateExpKeys(this.advExpKeyArray);
        }
        updateAdvKeyObjMap(advKey, advObject) {
            this.advKey_2_advObject[advKey] = advObject;
        }
        updateAdvIds(type, advId) {
            let advIds = this.type_2_advIds[type];
            if (!advIds) {
                advIds = [];
                advIds.push(advId);
                this.type_2_advIds[type] = advIds;
            }
            else {
                if (advIds.indexOf(advId) == -1) {
                    advIds.push(advId);
                }
            }
        }
        deleteAdvIdOpening(type, advId) {
            let advIds = this.type_2_advIds[type];
            if (advIds) {
                advIds = advIds.filter(item => item !== advId);
                this.type_2_advIds[type] = advIds;
            }
        }
        getAdvObjectsByName(mainName) {
            return this.mainName_2_advObjectArray[mainName];
        }
        onAdvObjectPreloadStateChanged(advKey) {
            ULTools.forEachMap(this.advId_2_advSlot, (k, v) => {
                let advSlot = v;
                advSlot.onAdvObjectPreloadStateChanged(advKey);
            });
        }
        onAdvSlotPreloadStateChanged(advId) {
            let ulAdvSlot = this.advId_2_advSlot[advId];
            if (!ulAdvSlot) {
                return;
            }
            let states = {};
            states[advId] = ulAdvSlot.preLoadState;
        }
        getTemplateObjByTid(tid) {
            return this.templateId_2_advTemplate[tid];
        }
        getAdvObjsByTid(tid) {
            return this.templateId_2_advObjectArray[tid];
        }
        getAdvTypeByTemplateId(tid) {
            let advType = null;
            let advObjects = this.templateId_2_advObjectArray[tid];
            if (advObjects && advObjects.length > 0) {
                advType = advObjects[0].advType;
            }
            return advType;
        }
        isAdvTypeOpened(advType) {
            let config = ULConfig.getConfig();
            let exemptArray = config.t_sdk_exempt_advType_limit_arrays;
            if (exemptArray.indexOf(advType) != -1) {
                return false;
            }
            let mutuallyExclusive = config.t_sdk_mutuallyExclusive_advType_setting || {};
            let trimMutuallyExclusiv = {};
            for (let advType of Object.keys(mutuallyExclusive)) {
                let itemList = mutuallyExclusive[advType];
                for (let subAdvType of itemList) {
                    let list = trimMutuallyExclusiv[advType] || [advType];
                    let otherList = trimMutuallyExclusiv[subAdvType] || [subAdvType];
                    list.push(subAdvType);
                    otherList.push(advType);
                    trimMutuallyExclusiv[advType] = list;
                    trimMutuallyExclusiv[subAdvType] = otherList;
                }
            }
            let itemList = trimMutuallyExclusiv[advType] || [advType];
            for (let subAdvType of itemList) {
                let objectBases = this.advType_2_advObjectArray[subAdvType];
                if (objectBases && objectBases.length > 0) {
                    for (let i = 0; i < objectBases.length; i++) {
                        let objectBase = objectBases[i];
                        if (objectBase.isOpened)
                            return true;
                    }
                }
            }
            return false;
        }
        getAdvObjectByAdvKey(advKey) {
            return this.advKey_2_advObject[advKey];
        }
        getRcdByAdvKey(advkey) {
            return this.advKey_2_rcd[advkey];
        }
        getAdvKeysByTemplateId(tid) {
            return this.tid_2_advKeyArray[tid];
        }
        getAdvSlotByAdvId(advId) {
            return this.advId_2_advSlot[advId];
        }
        getAdvObjPreloadStateByAdvKey(advKey) {
            let objectBase = this.advKey_2_advObject[advKey];
            if (objectBase) {
                return objectBase.preLoadState;
            }
            return ULConst.ADV_PRELOAD_STATE_NOAD;
        }
        getRewardTypeByTemplateId(tid) {
            let ulAdvTemplate = this.templateId_2_advTemplate[tid];
            if (!ulAdvTemplate) {
                return rewardType.show;
            }
            return ulAdvTemplate.rewardType;
        }
        getAdvTypeDailyLimit(advType) {
            let config = ULConfig.getConfig();
            let dailyLimit = 0;
            switch (advType) {
                case "interstitial":
                    dailyLimit = config.i_sdk_adv_type_interstitial_daily_limit;
                    break;
                case "banner":
                    dailyLimit = config.i_sdk_adv_type_banner_daily_limit;
                    break;
                case "embedded":
                    dailyLimit = config.i_sdk_adv_type_embedded_daily_limit;
                    break;
                case "video":
                    dailyLimit = config.i_sdk_adv_type_video_daily_limit;
                    break;
                case "url":
                    dailyLimit = config.i_sdk_adv_type_url_daily_limit;
                    break;
                case "paster":
                    dailyLimit = config.i_sdk_adv_type_paster_daily_limit;
                    break;
            }
            if (dailyLimit == null)
                return 0;
            if (isNaN(dailyLimit))
                return 0;
            return dailyLimit;
        }
        getAdvTypeCd(advType) {
            let config = ULConfig.getConfig();
            let cd = 0;
            switch (advType) {
                case typeExp.inter:
                    cd = config.i_sdk_adv_type_interstitial_cd;
                    break;
                case typeExp.banner:
                    cd = config.i_sdk_adv_type_banner_cd;
                    break;
                case typeExp.embed:
                    cd = config.i_sdk_adv_type_embedded_cd;
                    break;
                case typeExp.video:
                    cd = config.i_sdk_adv_type_video_cd;
                    break;
                case typeExp.url:
                    cd = config.i_sdk_adv_type_url_cd;
                    break;
                case typeExp.paster:
                    cd = config.i_sdk_adv_type_paster_cd;
                    break;
            }
            if (cd == null)
                return 0;
            if (isNaN(cd))
                return 0;
            return cd;
        }
        getInterAndVideoBetweenCd() {
            let config = ULConfig.getConfig();
            let cd = config['n_sdk_adv_inter_video_cd'];
            if (cd == null)
                return 0;
            if (isNaN(cd))
                return 0;
            return cd;
        }
        getLaunchCdByType(advType) {
            let config = ULConfig.getConfig();
            let cd = 0;
            switch (advType) {
                case typeExp.inter:
                    cd = config['i_sdk_adv_inter_launch_cd'];
                    break;
                case typeExp.banner:
                    cd = config['i_sdk_adv_banner_launch_cd'];
                    break;
                case typeExp.embed:
                    cd = config['i_sdk_adv_embed_launch_cd'];
                    break;
                case typeExp.video:
                    cd = config['i_sdk_adv_video_launch_cd'];
                    break;
                case typeExp.url:
                    cd = config['i_sdk_adv_url_launch_cd'];
                    break;
                case typeExp.paster:
                    cd = config['i_sdk_adv_paster_launch_cd'];
                    break;
                case typeExp.custom:
                    cd = config['i_sdk_adv_custom_launch_cd'];
                    break;
            }
            if (cd == null)
                return 0;
            if (isNaN(cd))
                return 0;
            return cd;
        }
        get sdkInitTime() {
            return this._sdkInitTime;
        }
        getAdvTypeLastTriggerTimeLog() {
            return this.advTypeLastTriggerTimeLog;
        }
        getAdvTypeDailyCountLog() {
            return this.advTypeDailyCountLog;
        }
        getAdvObjectOpeningByAdvType(type) {
            for (let key in this.advType_2_advObjectArray) {
                if (type !== key) {
                    continue;
                }
                let objectBases = this.advType_2_advObjectArray[key];
                for (let objectBase of objectBases) {
                    if (objectBase.isOpened) {
                        return objectBase;
                    }
                }
            }
            return null;
        }
        getNewAdvTypeByOld(oldType) {
            let type = "";
            if (!oldType) {
                return type;
            }
            type = oldType;
            if (oldTypeExp.embedded == oldType) {
                type = typeExp.embed;
            }
            else if (oldTypeExp.interstitial == oldType) {
                type = typeExp.inter;
            }
            else if (oldTypeExp.fullscreen == oldType) {
                type = typeExp.interVideo;
            }
            return type;
        }
        geOldAdvTypeByNew(newType) {
            let type = "";
            if (!newType) {
                return type;
            }
            type = newType;
            if (typeExp.embed == newType) {
                type = oldTypeExp.embedded;
            }
            else if (typeExp.inter == newType) {
                type = oldTypeExp.interstitial;
            }
            else if (typeExp.interVideo == newType) {
                type = oldTypeExp.fullscreen;
            }
            return type;
        }
        onCmdGetAdvState(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let userData = data['userData'] || "";
            let advIds = data['advIds'] || [];
            let advIdPreLoadState = {};
            for (const advId of advIds) {
                let ulAdvSlot = this.advId_2_advSlot[advId];
                if (!ulAdvSlot) {
                    advIdPreLoadState[advId] = ULConst.ADV_PRELOAD_STATE_NOAD;
                    continue;
                }
                advIdPreLoadState[advId] = ulAdvSlot.preLoadState;
            }
            this.getAdvStateResult(advIdPreLoadState, userData);
        }
        onCmdOpenAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let config = ULConfig.getConfig();
            if (!cConfig.n_sdk_adv_switch) {
                ULLog.console.log("ULAdvManager-onCmdOpenAdv:广告功能禁用");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: "unavailable" });
                return;
            }
            if (this.isReturnSuccess) {
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, { code: "", msg: "success" });
                this.responseRewardAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "success");
                return;
            }
            this.advRequestSerialNum++;
            let type = data["type"] || "";
            let advId = data["advId"] || "";
            let userData = data.userData || "";
            let tag = data.tag || "";
            let advType = type ? this.geOldAdvTypeByNew(type) : this.searchAdvTypeByAdvId(advId);
            let advGroupId = this.searchAdvGroupIdByAdvId(advId);
            let advItem = new ULAdvItem(advId || type, userData, tag);
            advItem.advType = advType;
            advItem.advGroupId = advGroupId;
            ULSdkManager.getInstance().statisManager.reportAdvTotalRequest(advItem);
            let all_ad_ecd = config['i_sdk_adv_all_launch_cd'];
            if (ULTools.time() - this.sdkInitTime < all_ad_ecd / 1000) {
                ULLog.console.log("ULAdvManager-onCmdOpenAdv:广告处于启动请求cd中");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: "in all adv launch cd" });
                return;
            }
            let advSolt = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSolt) {
                let msg = "";
                if (type) {
                    msg = `广告位[${type}]对应的advSlot不存在`;
                }
                else {
                    msg = `广告位[${advId}]对应的advSlot不存在`;
                }
                console.warn("ULAdvManager-onCmdOpenAdv:" + msg);
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: msg });
                return;
            }
            let openingInfo = advSolt.openingInfo;
            if (openingInfo) {
                console.warn("ULAdvManager-onCmdOpenAdv:广告位[" + advSolt.advId + "]已有广告请求中或正在展示");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位${advSolt.advId}已有广告请求中或正在展示` });
                return;
            }
            let rcd = advSolt.rcd;
            ULLog.console.log("ULAdvManager-onCmdOpenAdv-rcd:", rcd);
            let lastRequestTime = this.advId_2_lastRequestTime[advSolt.advId];
            let nowTime = (new Date()).valueOf();
            if (lastRequestTime) {
                if ((nowTime - lastRequestTime) < rcd) {
                    console.warn("ULAdvManager-onCmdOpenAdv:广告位[" + advSolt.advId + "]in cd");
                    this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${advSolt.advId}]in cd` });
                    return;
                }
                else {
                    this.advId_2_lastRequestTime[advSolt.advId] = nowTime;
                }
            }
            else {
                this.advId_2_lastRequestTime[advSolt.advId] = nowTime;
            }
            advSolt.openAdv(this.advRequestSerialNum, data);
        }
        onCmdCloseAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            let type = data.type;
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advSlot未找到!");
                return;
            }
            if (!advSlot.openingInfo) {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advSlot没有广告执行!");
                return;
            }
            let objectBase = this.getAdvObjectByAdvKey(advSlot.openingInfo.advTemplateItemName);
            if (objectBase) {
                if (objectBase instanceof ULAdvNativeObjectBase) {
                    advSlot.closeAdv(data);
                    this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "close adv success");
                }
                else {
                    advSlot.closeAdv(data);
                }
            }
            else {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad open!");
            }
        }
        onCmdCloseAllAdvByType(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let type = data.type || "";
            let advIds = this.type_2_advIds[type];
            if (advIds == null || advIds.length == 0) {
                this.responseCloseAllAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad show");
                return;
            }
            for (let advId of advIds) {
                let advSlot = this.advId_2_advSlot[advId];
                if (advSlot == null || advSlot.openingInfo == null) {
                    continue;
                }
                let objectBase = this.getAdvObjectByAdvKey(advSlot.openingInfo.advTemplateItemName);
                if (objectBase != null) {
                    data["advId"] = advId;
                    if (objectBase instanceof ULAdvNativeObjectBase) {
                        objectBase.closeNativeAdv(data);
                    }
                    else {
                        advSlot.closeAdv(data);
                    }
                }
            }
            this.responseCloseAllAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "关闭成功");
        }
        onCmdCloseNativeAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no advSlot");
                return;
            }
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CLOSE_NATIVE_ADV, data);
            this.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "关闭成功");
        }
        onCmdClickNativeAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", "109", advId || '', ""]);
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseClickNativeAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no advSlot");
                return;
            }
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CLICK_NATIVE_ADV, data);
            ULSdkManager.getInstance().advManager.responseClickNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "点击成功");
        }
        responseOpenAdvResult(data, code, info) {
            let returnData = {};
            returnData["code"] = code;
            returnData["msg"] = code == 1 ? "广告展示成功" : "暂无广告，请稍后再试";
            returnData["advId"] = data.advId || "";
            returnData["userData"] = data.userData || "";
            returnData["tag"] = data.tag || "";
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            if (code == 1) {
                if (!returnData.hasOwnProperty('type'))
                    returnData["type"] = data.playType || "";
                returnData["rewardType"] = data.rewardType || "";
                this.advTypeLastTriggerTimeLog[data.type] = ULTools.time();
                this.advTypeDailyCountLog[data.type] = (this.advTypeDailyCountLog[data.type] || 0) + 1;
                this.saveRecord();
                let actualShowCount = data["actualShowCount"];
                returnData["actualShowCount"] = isNaN(actualShowCount) ? 1 : actualShowCount;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_OPEN_ADV_RESULT, returnData);
        }
        responseRewardAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            if (code == 1) {
                let actualShowCount = data["actualShowCount"];
                returnData["actualShowCount"] = isNaN(actualShowCount) ? 1 : actualShowCount;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_REWARD_ADV_RESULT, returnData);
        }
        responseClickAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_CLICK_ADV_RESULT, returnData);
        }
        responseOpenNativeAdvResult(showData, nativeType, code, msg, nativeData) {
            let returnData = {};
            returnData["code"] = code;
            returnData["msg"] = msg;
            returnData["advId"] = showData.advId || "";
            returnData["userData"] = showData.userData || "";
            returnData["tag"] = showData.tag || "";
            if (showData.hasOwnProperty('type')) {
                returnData["type"] = showData.type;
            }
            returnData["nativeType"] = nativeType || "";
            returnData["nativeData"] = nativeData || {};
            if (code == 1) {
                if (!returnData.hasOwnProperty('type'))
                    returnData["type"] = showData.playType || "";
                returnData["rewardType"] = showData.rewardType || "";
            }
            ULSdkManager.getInstance().response(ULConst.CMD_OPEN_NATIVE_ADV_RESULT, returnData);
        }
        responseClickNativeAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                nativeType: data.nativeType || "",
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_CLICK_NATIVE_ADV_RESULT, data);
        }
        responseCloseNativeAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                nativeType: data.nativeType || "",
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_NATIVE_ADV_RESULT, returnData);
        }
        responseCloseAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (data.hasOwnProperty('type')) {
                returnData["type"] = data.type;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_ADV_RESULT, returnData);
        }
        responseCloseAllAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE_RESULT, {
                code: code,
                msg: msg,
                type: data.type || "",
                userData: data.userData || ""
            });
        }
        pauseSound() {
            ULSdkManager.getInstance().response(ULConst.CMD_PAUSE_SOUND_RESULT, {});
        }
        resumeSound() {
            ULSdkManager.getInstance().response(ULConst.CMD_RESUME_SOUND_RESULT, {});
        }
        getAdvStateResult(data, userData) {
            ULSdkManager.getInstance().response(ULConst.CMD_GET_ADV_STATE_RESULT, {
                states: data,
                userData: userData,
            });
        }
        onAdvObjectLifeCycleShowRequest(advKey, data) {
            this.addAdvCountLog(advKey, countExp.rc);
            let advId = data.advId || "";
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                ULSdkManager.getInstance().statisManager.reportAdvBranchRequest(advItem, advertiser, arg);
            }
        }
        onAdvObjectLifeCycleSkip(advKey, info, data) {
            let advId = data["advId"] || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleSkip(data, info);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleShow(advKey, msg, data, nativeData) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleShow(msg, data);
            this.addAdvCountLog(advKey, countExp.sc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.banner == advType) {
                    this.bannerStartShowTime = ULTools.time();
                }
                let title = nativeData ? nativeData.title : "";
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = title;
                advItem.statisSdkAdvId = arg;
                let actualShowCount = data["actualShowCount"];
                ULSdkManager.getInstance().statisManager.reportAdvSuccess(advItem, title, isNaN(actualShowCount) ? 1 : actualShowCount);
            }
        }
        onAdvObjectLifeCycleClick(advKey, msg, data, nativeData) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleClick(msg, data);
            this.addAdvCountLog(advKey, countExp.cc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let title = nativeData ? nativeData.title : "";
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = title;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvClicked(advItem);
            }
        }
        onAdvObjectLifeCycleClose(advKey, data, nativeData) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            this.reportBannerShowTime(advKey, data, nativeData);
            this.reportVideoPlayCompletion(advKey, data, nativeData);
            advSlot.onAdvObjectLifeCycleClose();
            this.responseCloseAdvResult(data, 1, "success");
        }
        onAdvTimeout(advItem, msg) {
        }
        reportBannerShowTime(advKey, data, nativeData) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.banner == advType) {
                    let bannerShowDuration = Math.floor(ULTools.time() - this.bannerStartShowTime);
                    if (bannerShowDuration <= 0) {
                        return;
                    }
                    let bannerShowTime = String(bannerShowDuration);
                    let advId = data.advId || "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = nativeData ? nativeData.title : "";
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvClose(advItem, bannerShowTime);
                }
            }
        }
        reportVideoPlayStart(advKey, data, nativeData) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            !window['my'] && ULSdkManager.getInstance().advManager.pauseSound();
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.video == advType) {
                    let title = nativeData ? nativeData.title : "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = title;
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvPlayStart(advItem);
                }
            }
        }
        reportVideoPlayCompletion(advKey, data, nativeData) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.video == advType) {
                    this._videoCloseTime = ULTools.time();
                    let title = nativeData ? nativeData.title : "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = title;
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvPlayCompletion(advItem);
                }
            }
        }
        onAdvObjectLifeCycleRequest(advKey) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && !objectBase.isReportLoading) {
                objectBase.isReportLoading = true;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = "";
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvRequest(advItem);
            }
        }
        onAdvObjectLifeCycleRequestSuccess(advKey) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && objectBase.isReportLoading) {
                objectBase.isReportLoading = false;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = "";
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvSuccess(advItem);
            }
        }
        onAdvObjectLifeCycleRequestFailed(advKey, info) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && objectBase.isReportLoading) {
                objectBase.isReportLoading = false;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvFailed(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleFail(advKey, info, data) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleFail(info, data);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleReuse(advKey, info, data) {
            let advId = data.advId || "";
            let type = data["type"] || "";
            let advSlot = this.advId_2_advSlot[type] || this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        addAdvFailCount(advKey) {
            this.addAdvCountLog(advKey, countExp.fc);
        }
        addAdvCountLog(advKey, countExp) {
            let tidArray = this.advKey_2_templateIdArray[advKey];
            if (tidArray && tidArray.length > 0) {
                for (const tid of tidArray) {
                    let key = ULConst.EXP_ADV_TEMPLATE_CONST + tid + ULConst.EXP_ADV_POINT_CONST + countExp;
                    this.updateAdvCountStoreNum(key);
                    this.advSlotRefreshValidAdvKeys(advKey);
                }
            }
            let objectBase = this.advKey_2_advObject[advKey];
            if (objectBase) {
                let advType = objectBase.advType;
                let key = ULConst.EXP_ADV_TYPE_CONST + advType + ULConst.EXP_ADV_POINT_CONST + countExp;
                this.updateAdvCountStoreNum(key);
                this.advSlotRefreshValidAdvKeys(advKey);
            }
        }
        updateAdvCountStoreNum(key) {
            ULAdvExpManager.updateExpValue(key);
            ULAdvExpManager.updateExpValue(dataExp.d + key);
            ULAdvExpManager.updateExpValue(dataExp.w + key);
            ULAdvExpManager.updateExpValue(dataExp.m + key);
            ULAdvExpManager.updateExpValue(dataExp.y + key);
        }
        advSlotRefreshValidAdvKeys(advKey) {
            let advIdArray = this.advKey_2_advIdArray[advKey];
            if (advIdArray) {
                for (const advId of advIdArray) {
                    let ulAdvSlot = this.advId_2_advSlot[advId];
                    if (ulAdvSlot) {
                        ulAdvSlot.refreshValidAdvKeys();
                    }
                }
            }
        }
    }
    ULAdvManager.instance = null;

    class ULAdvBase extends ULModuleBase {
        constructor() {
            super();
            this._initState = false;
            this.onInitModule();
        }
        get initState() {
            return this._initState;
        }
        set initState(v) {
            this._initState = v;
        }
    }

    let qg$1 = window["qg"];
    class ULAdvVivo extends ULAdvBase {
        constructor() {
            super();
            this.className = "ULAdvVivo";
        }
        onInitModule() {
            ULLog.console.log("ULAdvVivo-onInitModule");
            this.initState = true;
            this.notifyInitState(this.initState);
        }
        notifyInitState(initState) {
            let templateItemObjectArray = ULSdkManager.getInstance().advManager.getAdvObjectsByName("ULAdvVivo");
            if (!templateItemObjectArray) {
                return;
            }
            for (const baseObj of templateItemObjectArray) {
                baseObj.receiveMainClassInitState(initState);
            }
        }
        initAdv() {
        }
    }
    ULAdvVivo.NORMAL_ADVERTISER = "ULAdvVivo";
    ULAdvVivo.NATIVE_ADVERTISER = "ULAdvVivoNative";

    let qg$2 = window["qg"];
    class ULAdvVivoInter extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, ULTools.format("%s%s%s", "ULAdvVivoInter", "_", arg));
            this.className = "ULAdvVivoInter";
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
            this.statisticsType = oldTypeExp.interstitial;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoCustom-onDisposeModule arg:", this.arg);
            if (this.interstitialAd) {
                this.interstitialAd.offError();
                this.interstitialAd.offLoad();
                this.interstitialAd.offClose();
                this.interstitialAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoInter-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
        }
        showAdv(data) {
            let platformVersionCode = qg$2.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1031) {
                console.warn("ULAdvVivoInter-showAdv:原生api最低支持1031");
                this.advSkip(data, { code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                console.warn("ULAdvVivoInter-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            if (this.interstitialAd) {
                this.interstitialAd = null;
            }
            this.showData = data;
            this.isOpened = true;
            this.interstitialAd = qg$2.createInterstitialAd({
                posId: this.arg
            });
            if (!this.interstitialAd) {
                ULLog.console.log("ULAdvVivoInter-showAdv:广告对象创建异常，请检查参数是否正确：", this.arg);
                this.advSkip(data, { code: "", msg: "param error" });
                return;
            }
            this.interstitialAd.offLoad();
            this.interstitialAd.offClose();
            this.interstitialAd.offError();
            this.interstitialAd.onLoad(() => {
                ULLog.console.log("ULAdvVivoInter-showAdv-onLoad");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
            });
            this.interstitialAd.onError((err) => {
                ULLog.console.log("ULAdvVivoInter-showAdv-onError:", err);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                }
            });
            this.interstitialAd.onClose(() => {
                ULLog.console.log("ULAdvVivoInter-showAdv-onClose");
                if (this.isOpened) {
                    this.isOpened = false;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                }
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.interstitialAd.show().then(() => {
                ULLog.console.log("ULAdvVivoInter-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
            }).catch((err) => {
                ULLog.console.log("ULAdvVivoInter-showAdv show catch:", JSON.stringify(err));
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(data, { code: err.errCode, msg: err.errMsg });
                }
            });
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoInter-receiveInitState:初始化失败");
            }
        }
    }

    let qg$3 = window["qg"];
    class ULAdvVivoVideo extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.video, ULTools.format("%s%s%s", "ULAdvVivoVideo", "_", arg));
            this.className = "ULAdvVivoVideo";
            this.videoAd = null;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
            this.setSupportLoadType = [ULConst.ADV_LOAD_TYPE_PRELOAD, ULConst.ADV_LOAD_TYPE_UNPRELOAD];
            this.setLoadType = ULConst.ADV_LOAD_TYPE_PRELOAD;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoVideo-onDisposeModule arg:", this.arg);
            if (this.videoAd) {
                this.videoAd.offError();
                this.videoAd.offLoad();
                this.videoAd.offClose();
                this.videoAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoVideo-initAdv");
            let platformVersionCode = qg$3.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1041) {
                ULLog.console.log("ULAdvVivoVideo-initAdv-最低平台版本支持1051，直接跳过");
                return;
            }
            let loadType = this.getLoadType;
            if (loadType == undefined || this.getSupportLoadType.indexOf(loadType) == -1) {
                ULLog.console.log(`ULAdvVivoVideo-initAdv-当前加载类型${loadType}模块不支持`);
                loadType = ULConst.ADV_LOAD_TYPE_PRELOAD;
            }
            this.mLoadType = loadType;
            if (!this.videoAd) {
                this.videoAd = qg$3.createRewardedVideoAd({
                    posId: this.arg
                });
            }
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.videoAd.onLoad(() => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onLoad");
                    this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                });
                this.videoAd.onClose((res) => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onClose.res:", res);
                    this.isOpened = false;
                    if (res.isEnded) {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_video_success_show_event_id']]);
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleFail(this.advKey, { code: "", msg: ULConst.ADV_VIDEO_PLAY_FAIL_MSG }, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_close_video_event_id']]);
                    }
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                    this.preLoadAdv();
                });
                this.videoAd.onError((err) => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onError", err);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                    this.onLoadFailErr = { code: String(err.errCode), msg: err.errMsg };
                    if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_READY) {
                        this.isOpened = false;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    }
                    else {
                        ULSdkManager.getInstance().advManager.addAdvFailCount(this.advKey);
                    }
                    this.preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
                    this.reLoadAdv();
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_open_video_event_id'], "2"]);
                });
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            }
            else {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            }
        }
        loadAdv() {
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.videoAd.load();
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            }
            else {
            }
        }
        showAdv(data) {
            let platformVersionCode = qg$3.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1041) {
                console.warn("ULAdvVivoVideo-showAdv:原生api最低支持1041");
                this.advSkip(data, { code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            if (!this.videoAd) {
                console.warn("ULAdvVivoVideo-showAdv:广告未初始化,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv not init" });
                return;
            }
            if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_LOADING) {
                console.warn("ULAdvVivoVideo-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv is loading" });
                return;
            }
            if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_NOAD) {
                console.warn("ULAdvVivoVideo-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, this.onLoadFailErr);
                return;
            }
            this.showData = data;
            this.isOpened = true;
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.videoAd.show().then(() => {
                    ULSdkManager.getInstance().advManager.reportVideoPlayStart(this.advKey, data);
                });
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_open_video_event_id'], "1"]);
            }
            else {
                this.videoAd.offLoad();
                this.videoAd.offClose();
                this.videoAd.offError();
                this.videoAd.onLoad(() => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onLoad");
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                    this.videoAd.show().then(() => {
                        ULSdkManager.getInstance().advManager.reportVideoPlayStart(this.advKey, data);
                    });
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_open_video_event_id'], "1"]);
                });
                this.videoAd.onClose((res) => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onClose.res:", res);
                    this.isOpened = false;
                    if (res.isEnded) {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_video_success_show_event_id']]);
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleFail(this.advKey, { code: "", msg: ULConst.ADV_VIDEO_PLAY_FAIL_MSG }, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_close_video_event_id']]);
                    }
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                });
                this.videoAd.onError((err) => {
                    ULLog.console.log("ULAdvVivoVideo videoAd.onError", err);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                    if (this.isOpened) {
                        this.isOpened = false;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig()['s_sdk_miniplay_user_open_video_event_id'], "2"]);
                    }
                });
                this.videoAd.load();
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            }
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoVideo-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvNativeAdLoadCycle {
        constructor() {
            this.onLoad = () => {
                ULLog.console.log("ULAdvNativeAdLoadCycle default onLoad");
            };
            this.onLoadFail = (errInfo) => {
                ULLog.console.log("ULAdvNativeAdLoadCycle default onLoadFail");
            };
        }
    }
    class ULAdvNativeAdShowCycle {
        constructor() {
            this.onShow = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onShow");
            };
            this.onShowFail = (errInfo) => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onShowFail");
            };
            this.onRefresh = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onRefresh");
            };
            this.onClose = (isUserClick = true) => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onClose isUserClick:", isUserClick);
            };
            this.onClick = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onClick");
            };
        }
    }
    class ULAdvNativeData {
    }

    class ULAdvSDKNativeAd {
        constructor(parma) {
            this.showData = {};
            this.loadCycle = new ULAdvNativeAdLoadCycle();
            this.showCycle = new ULAdvNativeAdShowCycle();
            this.selfShowCycle = {
                onShow: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.closeCall && this.closeCall(this);
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                    this.nativeData = null;
                },
                onClick: () => {
                    if (!this.isShowing)
                        return;
                    this.clickCall && this.clickCall(this);
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            };
            this.loadCall = null;
            this.clickCall = null;
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.type = parma.type;
            this.loadCall = parma.load;
            this.clickCall = parma.click;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        click() {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClick && this.selfShowCycle.onClick();
            if (this.type == ULAdvNativeAdType.inter) {
                this.close(false);
            }
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.loadCall || !this.showCall)
                return;
            this.isShowing = true;
            this.loadCall(this, {
                onLoad: (nativeData) => {
                    this.nativeData = nativeData;
                    this.loadCycle.onLoad && this.loadCycle.onLoad(nativeData);
                    this.showSDKView(data);
                },
                onLoadFail: (errInfo) => {
                    this.loadCycle.onLoadFail && this.loadCycle.onLoadFail(errInfo);
                    this.selfShowCycle.onShowFail(errInfo);
                }
            });
        }
        close(isUserClick) {
            if (!this.isShowing)
                return;
            this.closeSDKAd();
            this.selfShowCycle.onClose(isUserClick);
        }
        destroy() {
            this.isShowing = false;
            this.nativeData = null;
            this.destroyCall && this.destroyCall(this);
            this.loadCall = null;
            this.showCall = null;
            this.clickCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
        refreshData(nativeData) {
            ULLog.console.log("ULAdvSDKNativeAd refreshData nativeData:", nativeData);
            if (this.isShowing) {
                this.nativeData = nativeData;
                this.showSDKView(this.showData, true);
            }
        }
        showSDKView(data, isRefreshing = false) {
            ULLog.console.log("ULAdvSDKNativeAd showSDKView nativeData:", this.nativeData);
            this.closeSDKAd();
            if (this.nativeData == null)
                return;
            this.showData = data;
            let obj = {
                nationData: this.nativeData,
                onShow: isRefreshing ? this.selfShowCycle.onRefresh : this.selfShowCycle.onShow,
                onError: (errMsg) => {
                    if (!isRefreshing) {
                        this.selfShowCycle.onShowFail({ code: "0", msg: errMsg });
                    }
                },
                onClick: this.selfShowCycle.onClick,
                onClose: (isUserClick) => {
                    if (isUserClick) {
                        this.selfShowCycle.onClose(isUserClick);
                    }
                }
            };
            switch (this.type) {
                case ULAdvNativeAdType.banner: {
                    let style = ULAdvNativeManager.getBannerStyle(data);
                    if (style == null) {
                        obj.onError('sdk自动刷新不包含此tag');
                        return;
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showNationBanner(obj, style);
                    break;
                }
                case ULAdvNativeAdType.embedded: {
                    let style = ULAdvNativeManager.getEmbeddStyle(data);
                    ULSdkManager.getInstance().moduleCheckerManager.showNationEmbedded(obj, style);
                    break;
                }
                case ULAdvNativeAdType.inter: {
                    ULSdkManager.getInstance().moduleCheckerManager.showNationInter(obj);
                    break;
                }
            }
        }
        closeSDKAd() {
            switch (this.type) {
                case ULAdvNativeAdType.banner: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationBanner();
                    break;
                }
                case ULAdvNativeAdType.embedded: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationEmbedded();
                    break;
                }
                case ULAdvNativeAdType.inter: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationInter();
                    break;
                }
            }
        }
    }

    class ULAdvGameNativeAd {
        constructor(parma) {
            this.loadCycle = new ULAdvNativeAdLoadCycle();
            this.showCycle = new ULAdvNativeAdShowCycle();
            this.selfShowCycle = {
                onShow: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.closeCall && this.closeCall(this);
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                    this.nativeData = null;
                },
                onClick: () => {
                    if (!this.isShowing)
                        return;
                    this.clickCall && this.clickCall(this);
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            };
            this.loadCall = null;
            this.clickCall = null;
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.type = parma.type;
            this.loadCall = parma.load;
            this.clickCall = parma.click;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        click() {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClick && this.selfShowCycle.onClick();
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.loadCall || !this.showCall)
                return;
            this.isShowing = true;
            this.loadCall(this, {
                onLoad: (nativeData) => {
                    this.nativeData = nativeData;
                    this.loadCycle.onLoad && this.loadCycle.onLoad(nativeData);
                    this.showGameView(data);
                },
                onLoadFail: (errInfo) => {
                    this.loadCycle.onLoadFail && this.loadCycle.onLoadFail(errInfo);
                    this.selfShowCycle.onShowFail(errInfo);
                }
            });
        }
        close(isUserClick) {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClose(isUserClick);
        }
        destroy() {
            this.isShowing = false;
            this.destroyCall && this.destroyCall(this);
            this.nativeData = null;
            this.loadCall = null;
            this.showCall = null;
            this.clickCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
        showGameView(data) {
            if (!this.isShowing)
                return;
            let advType = this.type.toString();
            ULSdkManager.getInstance().advManager.responseOpenNativeAdvResult(data, advType, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_NATIVE_RESULT_MSG_SUCCESS, this.nativeData);
            this.selfShowCycle.onShow();
        }
    }

    var ULAdvNativeAdType;
    (function (ULAdvNativeAdType) {
        ULAdvNativeAdType["banner"] = "banner";
        ULAdvNativeAdType["inter"] = "inter";
        ULAdvNativeAdType["embedded"] = "embed";
    })(ULAdvNativeAdType || (ULAdvNativeAdType = {}));
    var ULAdvNativeAdShowType;
    (function (ULAdvNativeAdShowType) {
        ULAdvNativeAdShowType[ULAdvNativeAdShowType["game"] = 0] = "game";
        ULAdvNativeAdShowType[ULAdvNativeAdShowType["sdk"] = 1] = "sdk";
    })(ULAdvNativeAdShowType || (ULAdvNativeAdShowType = {}));
    class ULNativeItem {
        constructor(param) {
            this.showGameAdArray = [];
            this.showSdkAdArray = [];
            this.loadCycleList = [];
            this.lastExposureTime = 0;
            this.channelLoadCycle = new ULAdvNativeAdLoadCycle();
            this.arg = param.arg;
            this.channelAd = param.channelAd;
            this.hadClick = false;
            this.hadshown = false;
            this.isLoading = false;
            this.inUseNativeData = null;
            this.errInfo = null;
            this.remainRequestTime = 0;
            this.remainShowTime = this.adIntervals;
            this.remainShowNumber = this.allowShowNum;
            this.channelAd.init(this.arg);
        }
        get isShowing() {
            return this.showGameAdArray.length + this.showSdkAdArray.length > 0;
        }
        get adIntervals() {
            let config = ULConfig.getConfig();
            let refresh_intervals = config.i_sdk_native_autoRefresh_intervals || 30;
            let nation_autoRefresh_intervals = Number(refresh_intervals) || 30;
            return nation_autoRefresh_intervals;
        }
        get allowShowNum() {
            let config = ULConfig.getConfig();
            let allowShowNum = config.i_sdk_native_valid_show_count || 0;
            let trimAllowShowNum = Number(allowShowNum) || 2;
            return trimAllowShowNum;
        }
        get requestCD() {
            let config = ULConfig.getConfig();
            let nativeCD = config.i_sdk_adv_native_life_time || 0;
            let trimNativeCD = Number(nativeCD) / 1000 || 0;
            return Math.max(trimNativeCD, 15);
        }
        get exposureCd() {
            let config = ULConfig.getConfig();
            let exposureCd = config.i_sdk_adv_native_exposure_cd || 0;
            let trimExposureCd = Number(exposureCd) / 1000 || 0;
            return trimExposureCd;
        }
        get allowLoad() {
            if (this.showGameAdArray.length > 0)
                return false;
            if (this.remainRequestTime == 0) {
                if (this.hadClick)
                    return true;
                if (this.inUseNativeData == null)
                    return true;
                if (this.hadshown && this.remainShowTime == 0)
                    return true;
                if (this.hadshown && this.remainShowNumber == 0) {
                    let isAutoRefresh = ULAdvNativeManager.isAutoRefresh;
                    if (!this.isShowing && isAutoRefresh)
                        return true;
                    if (this.isShowing && !isAutoRefresh)
                        return true;
                }
            }
            return false;
        }
        performSecond() {
            this.remainRequestTime = Math.max(--this.remainRequestTime, 0);
            if (this.isShowing)
                this.remainShowTime = Math.max(--this.remainShowTime, 0);
            ULLog.console.log(`ULNativeItem allowLoad:${this.allowLoad},isShowing:${this.isShowing},rmRequestTime:${this.remainRequestTime},rmShowTime:${this.remainShowTime},rmShowNumber:${this.remainShowNumber}`);
        }
        refreshLoad() {
            this.loadChannelData({
                onLoad: (nativeData) => {
                    ULLog.console.log(`ULNativeItem refreshLoad onLoad:${nativeData}`);
                    this.showSdkAdArray.forEach(nativeAd => {
                        if (nativeAd instanceof ULAdvSDKNativeAd) {
                            nativeAd.refreshData(nativeData);
                        }
                    });
                },
                onLoadFail: (errInfo) => {
                    ULLog.console.log(`ULNativeItem refreshLoad onLoadFail:${errInfo}`);
                    this.showSdkAdArray.forEach(nativeAd => {
                        if (nativeAd instanceof ULAdvSDKNativeAd) {
                            nativeAd.refreshData(null);
                        }
                    });
                },
            });
        }
        load(cycle) {
            if (this.allowLoad || this.isLoading) {
                this.loadChannelData(cycle);
            }
            else if (this.inUseNativeData != null) {
                cycle.onLoad && cycle.onLoad(this.inUseNativeData);
            }
            else {
                cycle.onLoadFail && cycle.onLoadFail(this.errInfo || { code: "0", msg: this.isLoading ? "正在加载中" : "未知错误" });
            }
        }
        loadChannelData(cycle) {
            this.loadCycleList.push(cycle);
            if (this.isLoading)
                return;
            this.isLoading = true;
            this.remainRequestTime = this.requestCD;
            let timerId = setTimeout(() => {
                this.channelLoadCycle.onLoadFail({ code: "0", msg: "加载超时" });
            }, 20000);
            let baseLoadCycle = new ULAdvNativeAdLoadCycle();
            this.channelLoadCycle.onLoad = (nativeData) => {
                ULLog.console.log(`ULNativeItem onLoad nativeData:${nativeData}`);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = null;
                this.inUseNativeData = nativeData;
                this.hadshown = false;
                this.hadClick = false;
                this.remainRequestTime = this.requestCD;
                this.remainShowTime = this.adIntervals;
                this.remainShowNumber = this.allowShowNum;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoad && cycleItem.onLoad(nativeData);
                }
            };
            this.channelLoadCycle.onLoadFail = (errInfo) => {
                ULLog.console.log("ULNativeItem channelLoadCycle onLoadFail:" + errInfo);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = errInfo;
                this.inUseNativeData = null;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoadFail && cycleItem.onLoadFail(errInfo);
                }
            };
            this.channelAd.load(this.channelLoadCycle);
        }
        show(nativeAd, showType) {
            ULLog.console.log("ULNativeItem show");
            if (showType == ULAdvNativeAdShowType.game) {
                let index = this.showGameAdArray.indexOf(nativeAd);
                if (index == -1) {
                    this.showGameAdArray.push(nativeAd);
                }
            }
            else if (showType == ULAdvNativeAdShowType.sdk) {
                let index = this.showSdkAdArray.indexOf(nativeAd);
                if (index == -1) {
                    this.showSdkAdArray.push(nativeAd);
                }
            }
            this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
            if (!this.hadshown || ULTools.time() - this.lastExposureTime > this.exposureCd) {
                this.channelAd.show();
                this.lastExposureTime = ULTools.time();
            }
            this.hadshown = true;
        }
        click() {
            this.channelAd.click();
            this.hadClick = true;
            this.remainRequestTime = 0;
        }
        close(nativeAd, showType) {
            ULLog.console.log(`ULNativeItem close `);
            if (showType == ULAdvNativeAdShowType.game) {
                let index = this.showGameAdArray.indexOf(nativeAd);
                if (index > -1) {
                    this.showGameAdArray.splice(index, 1);
                }
            }
            else if (showType == ULAdvNativeAdShowType.sdk) {
                let index = this.showSdkAdArray.indexOf(nativeAd);
                if (index > -1) {
                    this.showSdkAdArray.splice(index, 1);
                }
            }
        }
        destroy() {
        }
    }
    class ULAdvNativeManager {
        constructor() {
            this.timerId = null;
            this.nativeItemCache = {};
            this.showBannerAutoRefreshTags = null;
            let self = this;
            this.timerId = setInterval(function () {
                for (let key in self.nativeItemCache) {
                    let nativeItem = self.nativeItemCache[key];
                    self.showOneSecond(nativeItem);
                }
            }, 1000);
        }
        static getInstance() {
            if (!this.instance) {
                this.instance = new ULAdvNativeManager();
            }
            return this.instance;
        }
        get isAutoRefresh() {
            let config = ULConfig.getConfig();
            return config.i_sdk_native_autoRefresh_mode == 1;
        }
        static get isAutoRefresh() {
            return ULAdvNativeManager.getInstance().isAutoRefresh;
        }
        get channelBannerStyle() {
            if (this.showBannerAutoRefreshTags == null) {
                let config = ULConfig.getConfig();
                this.showBannerAutoRefreshTags = {};
                let banner_autoRefresh_tags = config.t_sdk_show_native_banner_autoRefresh_tags || [];
                let banner_autoRefresh_tags_style_setting = config.t_sdk_show_native_banner_autoRefresh_tags_style_setting || {};
                for (let index = 0; index < banner_autoRefresh_tags.length; index++) {
                    let tag = banner_autoRefresh_tags[index];
                    let style = banner_autoRefresh_tags_style_setting[tag] || banner_autoRefresh_tags_style_setting["*"] || {};
                    this.showBannerAutoRefreshTags[tag] = style;
                }
            }
            return this.showBannerAutoRefreshTags;
        }
        showOneSecond(nativeItem) {
            nativeItem.performSecond();
            if (!this.isAutoRefresh)
                return;
            if (nativeItem.allowLoad)
                nativeItem.refreshLoad();
        }
        static createNativeAd(channelAd, parma) {
            return ULAdvNativeManager.getInstance().createNativeAd(channelAd, parma);
        }
        static isShowing(arg) {
            if (this.instance.nativeItemCache[arg]) {
                return this.instance.nativeItemCache[arg].isShowing;
            }
            return false;
        }
        createNativeAd(channelAd, parma) {
            let nativeAd = null;
            if (!this.nativeItemCache[parma.arg]) {
                this.nativeItemCache[parma.arg] = new ULNativeItem({
                    arg: parma.arg,
                    channelAd: new channelAd()
                });
            }
            let item = this.nativeItemCache[parma.arg];
            let trimParma = {
                arg: parma.arg,
                type: parma.type,
                load: (nativeAd, loadCycle) => {
                    item.load(loadCycle);
                },
                click: (nativeAd) => {
                    item.click();
                },
                show: (nativeAd) => {
                    item.show(nativeAd, parma.showType);
                },
                close: (nativeAd) => {
                    item.close(nativeAd, parma.showType);
                },
                destroy: (nativeAd) => {
                    item.destroy();
                    delete this.nativeItemCache[item.arg];
                }
            };
            if (parma.showType == ULAdvNativeAdShowType.game) {
                ULLog.console.log("ULAdvNativeManager-createNativeAd-ULAdvGameNativeAd");
                nativeAd = new ULAdvGameNativeAd(trimParma);
            }
            else {
                ULLog.console.log("ULAdvNativeManager-createNativeAd-ULAdvSDKNativeAd");
                nativeAd = new ULAdvSDKNativeAd(trimParma);
            }
            return nativeAd;
        }
        static getBannerStyle(data) {
            let advId = data["advId"];
            let tag = data["tag"] || advId || "";
            let channelBannerStyle = ULAdvNativeManager.instance.channelBannerStyle;
            ULLog.console.log("ULAdvNativeManager data.layout:", data.layout);
            ULLog.console.log(`ULAdvNativeManager this.channelBannerStyle[${tag}]:`, channelBannerStyle[tag]);
            let style = data.layout || channelBannerStyle[tag] || null;
            if (style == null || style == undefined) {
                return null;
            }
            let trimStyle = {
                x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                y: !isNaN(Number(style.y)) ? Number(style.y) : 0,
                width: !isNaN(Number(style.width)) ? Number(style.width) : 1,
                height: !isNaN(Number(style.height)) ? Number(style.height) : 1,
            };
            return trimStyle;
        }
        static getEmbeddStyle(data) {
            let style = data.layout || {};
            let trimStyle = {
                x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                y: !isNaN(Number(style.y)) ? Number(style.y) : 0.5,
                width: !isNaN(Number(style.width)) ? Number(style.width) : 0.4,
                height: !isNaN(Number(style.height)) ? Number(style.height) : 0.2,
            };
            ULLog.console.log("ULAdvNativeManager data.layout:", data.layout);
            ULLog.console.log("ULAdvNativeManager data.trimStyle:", trimStyle);
            return trimStyle;
        }
    }
    ULAdvNativeManager.isPreLoad = true;

    let qg$4 = window["qg"];
    class ULAdvVivoNativeItem {
        init(arg) {
            this.arg = arg;
            let platformVersionCode = qg$4.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1053) {
                ULLog.console.warn("ULAdvVivoNativeItem.init :原生api最低支持1053");
                return;
            }
            this.nativeAd = qg$4.createNativeAd({
                posId: arg,
            });
        }
        load(cycle) {
            if (!!!this.nativeAd) {
                cycle.onLoadFail && cycle.onLoadFail({ code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            this.nativeAd.offLoad();
            this.nativeAd.onLoad((res) => {
                ULLog.console.log('ULAdvVivoNativeItem-onLoad:', res);
                if (res && res.adList) {
                    let adData = res.adList.pop();
                    this.inUseData = adData;
                    let respone = {
                        title: adData.title || "",
                        desc: adData.desc || "",
                        icon: adData.icon || "",
                        url: adData.imgUrlList[0],
                        targetTitle: adData.clickBtnTxt || "点击查看",
                        adSource: adData.adSource || "",
                    };
                    cycle.onLoad && cycle.onLoad(respone);
                }
                else {
                    cycle.onLoadFail && cycle.onLoadFail({ code: "", msg: "no ad" });
                }
            });
            this.nativeAd.onError((err) => {
                ULLog.console.log('ULAdvVivoNativeItem-onError err:', err);
                if (this.inUseData) {
                    let respone = {
                        title: this.inUseData.title || "",
                        desc: this.inUseData.desc || "",
                        icon: this.inUseData.icon || "",
                        url: this.inUseData.imgUrlList[0],
                        targetTitle: this.inUseData.clickBtnTxt || "点击查看",
                        adSource: this.inUseData.adSource || "",
                    };
                    cycle.onLoad && cycle.onLoad(respone);
                    return;
                }
                let errInfo = {
                    code: String(err.errCode),
                    msg: err.errMsg
                };
                cycle.onLoadFail && cycle.onLoadFail(errInfo);
            });
            this.nativeAd.load();
        }
        click() {
            this.nativeAd.reportAdClick({
                adId: this.inUseData.adId
            });
        }
        show() {
            this.nativeAd.reportAdShow({
                adId: this.inUseData.adId
            });
        }
    }

    let qg$5 = window["qg"];
    class ULAdvVivoNativeBase extends ULAdvNativeObjectBase {
        constructor(arg, advType, templateItemName) {
            super(arg, advType, templateItemName);
            this.className = "ULAdvVivoNativeBase";
            this.statisticsAdvertiser = ULAdvVivo.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoNativeBase-onDisposeModule arg:", this.arg);
        }
        closeNativeAdv(e) {
            let data = e.data;
            let advId = data.advId;
            if (!this.showData || !this.showData.advId || this.showData.advId != advId) {
                return;
            }
            ULLog.console.log("ULAdvVivoNativeBase-closeNativeAdv");
            this.nativeAd.close(data.closeType == 1);
            ULSdkManager.getInstance().advManager.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        clickNativeAdv(e) {
            let data = e.data;
            let advId = data.advId;
            if (!this.showData || !this.showData.advId || this.showData.advId != advId) {
                return;
            }
            ULLog.console.log("ULAdvVivoNativeBase-clickNativeAdv");
            this.nativeAd.click();
            this.nativeAd.close(false);
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoNativeBase-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            let type = this.advType == "banner" ? ULAdvNativeAdType.banner : ULAdvNativeAdType.inter;
            ULLog.console.log("ULAdvVivoNativeBase-initAdv:", type);
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvVivoNativeItem, {
                arg: this.arg,
                type: type,
                showType: ULAdvNativeAdShowType.game
            });
        }
        loadAdv() {
        }
        showAdv(showData) {
            ULLog.console.log("ULAdvVivoNativeBase-showAdv:");
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                console.warn("ULAdvVivoNativeBase-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(showData, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = showData;
            let advId = showData["advId"];
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoNativeBase-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoNativeBase-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, showData, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoNativeBase-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", showData, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoNativeBase-showAdv-onClose");
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, showData, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.isOpened = true;
            this.nativeAd.show(showData);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoNativeBase-closeAdv");
            this.nativeAd.close(data.closeType == 1);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoNativeBase-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvVivoNativeBanner extends ULAdvVivoNativeBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvVivoNativeBanner_" + arg);
        }
    }

    class ULAdvVivoNativeInter extends ULAdvVivoNativeBase {
        constructor(arg) {
            super(arg, typeExp.inter, "ULAdvVivoNativeInter_" + arg);
            this.statisticsType = oldTypeExp.interstitial;
        }
    }

    let qg$6 = window["qg"];
    class ULAdvVivoShare extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, "share", ULTools.format("%s%s%s", "ULAdvVivoShare", "_", arg));
            this.className = "ULAdvVivoShare";
            this.statisticsAdvertiser = "ULAdvVivoShare";
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoShare-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
        }
        showAdv(data) {
            let platformVersionCode = qg$6.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1056) {
                console.warn("ULAdvVivoShare-showAdv:原生api最低支持1056");
                this.advSkip(data, { code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            this.showData = data;
            this.isOpened = true;
            this.showData.showAdvType = "share";
            let self = this;
            qg$6.share({
                success: () => {
                    ULLog.console.log("ULAdvVivoShare openShare......分享成功!");
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(self.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, self.showData);
                },
                fail: (err) => {
                    ULLog.console.log(`ULAdvVivoShare openShare.......分享失败!`, err.code, err.message);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleFail(self.advKey, { code: String(err.code), msg: err.message }, self.showData);
                },
                complete(e) {
                    ULLog.console.log(`ULAdvVivoShare openShare.......complete!`);
                    self.isOpened = false;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(self.advKey, self.showData);
                }
            });
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoShare-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvCustomAdStyle {
        constructor() {
            this.x = 0.5;
            this.y = 0;
            this.width = 1;
            this.height = 1;
        }
    }
    class ULAdvCustomAdLoadCycle {
        constructor() {
            this.onLoad = () => {
                ULLog.console.log("ULAdvCustomAdLoadCycle default onLoad");
            };
            this.onLoadFail = (errInfo) => {
                ULLog.console.log("ULAdvCustomAdLoadCycle default onLoadFail");
            };
        }
    }
    class ULAdvCustomAdShowCycle {
        constructor() {
            this.onShow = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onShow");
            };
            this.onShowFail = (errInfo) => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onShowFail");
            };
            this.onRefresh = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onRefresh");
            };
            this.onClose = (isUserClick = true) => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onClose isUserClick:", isUserClick);
            };
            this.onClick = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onClick");
            };
        }
    }

    class ULAdvCustomNormalAd {
        constructor(parma) {
            this.showCycle = new ULAdvCustomAdShowCycle();
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.showCall)
                return;
            this.isShowing = true;
            this.showCall(data, {
                onShow: () => {
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    this.isShowing = false;
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                },
                onClick: () => {
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            });
        }
        close() {
            if (!this.isShowing)
                return;
            this.closeCall && this.closeCall();
        }
        destroy() {
            this.destroyCall && this.destroyCall();
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
    }

    class ULAdvCustomManager {
        constructor() {
            this.timerId = null;
            this.customItemCache = {};
            let self = this;
            this.timerId = setInterval(function () {
                for (let key in self.customItemCache) {
                    let customItem = self.customItemCache[key];
                    self.showOneSecond(customItem);
                }
            }, 1000);
        }
        get isAutoRefresh() {
            let config = ULConfig.getConfig();
            return !!config.i_sdk_custom_autoRefresh_mode;
        }
        get channelCustomStyle() {
            let config = ULConfig.getConfig();
            let setting = config.t_sdk_adv_custom_args_style_setting;
            let settingObj = {};
            if (setting) {
                if ((typeof setting) == "string") {
                    try {
                        settingObj = JSON.parse(setting);
                    }
                    catch (error) {
                    }
                }
                else if ((typeof setting) == "object") {
                    settingObj = setting;
                }
            }
            return settingObj;
        }
        static get isAutoRefresh() {
            return ULAdvCustomManager.getInstance().isAutoRefresh;
        }
        static getInstance() {
            if (!this.instance) {
                this.instance = new ULAdvCustomManager();
            }
            return this.instance;
        }
        showOneSecond(customItem) {
            customItem.performSecond();
            if (!this.isAutoRefresh)
                return;
            if (customItem.allowLoad) {
                customItem.refresh();
            }
        }
        static createCustomAd(channelAd, parma, allowRefreshShowing = true) {
            return ULAdvCustomManager.getInstance().createCustomAd(channelAd, parma, allowRefreshShowing);
        }
        createCustomAd(channelAd, parma, allowRefreshShowing = true) {
            let customAd = null;
            let item = this.customItemCache[parma.arg];
            if (!!!item) {
                item = new ULCustomItem({
                    arg: parma.arg,
                    channelAd: new channelAd()
                });
                this.customItemCache[parma.arg] = item;
            }
            customAd = new ULAdvCustomNormalAd({
                arg: item.arg,
                show: (data, cycle) => {
                    let advId = data["advId"];
                    let tag = data["tag"] || advId || "";
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[tag]:", this.channelCustomStyle[tag]);
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[arg]:", this.channelCustomStyle[item.arg]);
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[*]:", this.channelCustomStyle["*"]);
                    let style = this.channelCustomStyle[tag] || this.channelCustomStyle[item.arg] || this.channelCustomStyle["*"] || {};
                    let trimStyle = {
                        x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                        y: !isNaN(Number(style.y)) ? Number(style.y) : 0,
                        width: !isNaN(Number(style.width)) ? Number(style.width) : 1,
                        height: !isNaN(Number(style.height)) ? Number(style.height) : 0.5,
                    };
                    item.allowRefreshShowing = allowRefreshShowing;
                    item.show(trimStyle, cycle);
                },
                close: () => {
                    item.close();
                },
                destroy: () => {
                    item.destroy();
                    delete this.customItemCache[item.arg];
                }
            });
            return customAd;
        }
    }
    class ULCustomItem {
        constructor(param) {
            this.allowRefreshShowing = true;
            this.showStyle = { x: 0.5, y: 0, width: 1, height: 1 };
            this.showCycleList = [];
            this.loadCycleList = [];
            this.hadShowRulst = false;
            this.channelShowCycle = {
                onShow: () => {
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onShow");
                    if (!this.isShowing) {
                        this.close();
                        return;
                    }
                    this.hadShowRulst = true;
                    this.hadshown = true;
                    this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onShow && cycleItem.onShow();
                    }
                },
                onShowFail: (errInfo) => {
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onShowFail");
                    if (!this.isShowing) {
                        return;
                    }
                    this.hadShowRulst = true;
                    this.isShowing = false;
                    this.loadSuccess = false;
                    this.errInfo = errInfo;
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList.shift();
                        cycleItem.onShowFail && cycleItem.onShowFail(errInfo);
                    }
                },
                onRefresh: (errInfo = null) => {
                    if (!this.isShowing) {
                        return;
                    }
                    this.hadShowRulst = true;
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle refresh onRefresh err:", errInfo);
                    if (errInfo) {
                        return;
                    }
                    this.hadshown = true;
                    this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onRefresh && cycleItem.onRefresh();
                    }
                },
                onClose: (isUserClick = false) => {
                    if (!this.isShowing) {
                        return;
                    }
                    if (this.isLoading && isUserClick) {
                        return;
                    }
                    if (!this.hadshown && isUserClick) {
                        return;
                    }
                    if (!this.hadShowRulst)
                        return;
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onClose");
                    this.isShowing = false;
                    while (this.showCycleList.length) {
                        let cycleItem = this.showCycleList.shift();
                        cycleItem.onClose && cycleItem.onClose(isUserClick);
                    }
                },
                onClick: () => {
                    if (!this.isShowing) {
                        return;
                    }
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onClick");
                    this.hadClick = true;
                    this.remainRequestTime = 0;
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onClick && cycleItem.onClick();
                    }
                }
            };
            this.channelLoadCycle = new ULAdvCustomAdLoadCycle();
            this.arg = param.arg;
            this.channelAd = param.channelAd;
            this.isShowing = false;
            this.hadClick = false;
            this.hadshown = false;
            this.isLoading = false;
            this.loadSuccess = false;
            this.remainRequestTime = 0;
            this.remainShowTime = this.adIntervals;
            this.remainShowNumber = this.allowShowNum;
            this.channelAd.init(this.arg);
        }
        get adIntervals() {
            let config = ULConfig.getConfig();
            let adIntervals = config.i_sdk_custom_refresh_intervals || 30;
            return Number(adIntervals) || 30;
        }
        get allowShowNum() {
            let config = ULConfig.getConfig();
            let allowShowNum = config.i_sdk_adv_custom_valid_show_count || 0;
            let trimAllowShowNum = Number(allowShowNum) || 2;
            return trimAllowShowNum;
        }
        get requestCD() {
            let config = ULConfig.getConfig();
            let customCD = config['i_sdk_adv_custom_cd'] || 0;
            let trimCustomCD = Number(customCD) / 1000 || 0;
            return Math.max(trimCustomCD, 15);
        }
        get allowLoad() {
            if (this.remainRequestTime == 0) {
                if (this.hadClick)
                    return true;
                if (!this.loadSuccess)
                    return true;
                if (this.hadshown && this.remainShowTime == 0)
                    return true;
                if (this.hadshown && this.remainShowNumber == 0) {
                    let isAutoRefresh = ULAdvCustomManager.isAutoRefresh;
                    if (!this.isShowing && isAutoRefresh && this.allowRefreshShowing)
                        return true;
                    if (this.isShowing && !isAutoRefresh)
                        return true;
                }
            }
            return false;
        }
        performSecond() {
            this.remainRequestTime = Math.max(--this.remainRequestTime, 0);
            if (this.isShowing) {
                this.remainShowTime = Math.max(--this.remainShowTime, 0);
            }
        }
        loadData(cycle) {
            this.loadCycleList.push(cycle);
            if (this.isLoading)
                return;
            this.isLoading = true;
            this.remainRequestTime = this.requestCD;
            let timerId = setTimeout(() => {
                this.channelLoadCycle.onLoadFail({ code: "0", msg: "加载超时" });
            }, 20000);
            let baseLoadCycle = new ULAdvCustomAdLoadCycle();
            this.channelLoadCycle.onLoad = () => {
                ULLog.console.log("ULCustomItem channelLoadCycle onLoad");
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = null;
                this.loadSuccess = true;
                this.hadshown = false;
                this.hadClick = false;
                this.remainRequestTime = this.requestCD;
                this.remainShowTime = this.adIntervals;
                this.remainShowNumber = this.allowShowNum;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoad && cycleItem.onLoad();
                }
            };
            this.channelLoadCycle.onLoadFail = (errInfo) => {
                ULLog.console.log("ULCustomItem channelLoadCycle onLoadFail:" + errInfo);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = errInfo;
                this.loadSuccess = false;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoadFail && cycleItem.onLoadFail(errInfo);
                }
            };
            this.channelAd.load(this.channelLoadCycle);
        }
        channelShow(isRefresh = false) {
            if (!this.isShowing)
                return;
            this.hadShowRulst = false;
            this.channelAd.show(this.showStyle, {
                onShow: isRefresh ? this.channelShowCycle.onRefresh : this.channelShowCycle.onShow,
                onShowFail: isRefresh ? this.channelShowCycle.onRefresh : this.channelShowCycle.onShowFail,
                onRefresh: this.channelShowCycle.onRefresh,
                onClose: this.channelShowCycle.onClose,
                onClick: this.channelShowCycle.onClick
            });
        }
        show(style, cycle) {
            ULLog.console.log("ULAdvCustomManager.show isShowing:", this.isShowing);
            if (this.isShowing) {
                cycle.onShowFail({ code: "0", msg: "正在播放中" });
                return;
            }
            this.isShowing = true;
            this.showStyle = style;
            this.showCycleList.push(cycle);
            if (this.allowLoad || this.isLoading) {
                ULLog.console.log("ULAdvCustomManager.show loadData");
                this.loadData({
                    onLoad: () => {
                        ULLog.console.log("ULAdvCustomManager.show loadData onLoad");
                        this.channelShow();
                    },
                    onLoadFail: (errInfo) => {
                        ULLog.console.log("ULAdvCustomManager.show loadData onLoadFail");
                        this.channelShowCycle.onShowFail(errInfo);
                    }
                });
            }
            else if (this.loadSuccess) {
                ULLog.console.log("ULAdvCustomManager.show loadSuccess");
                this.remainRequestTime = Math.max(this.remainRequestTime, 3);
                this.channelShow();
            }
            else {
                ULLog.console.log("ULAdvCustomManager.show errInfo");
                this.channelShowCycle.onShowFail(this.errInfo || (this.isLoading ? { code: "0", msg: "正在加载中" } : { code: "0", msg: "未知错误" }));
            }
        }
        refresh() {
            ULLog.console.log("ULAdvCustomManager.refresh");
            var isShowing = this.isShowing;
            this.loadData({
                onLoad: () => {
                    ULLog.console.log("ULAdvCustomManager.refresh onLoad isShowing:", this.isShowing);
                    if (isShowing && this.isShowing)
                        this.channelShow(true);
                },
                onLoadFail: (errInfo) => {
                    ULLog.console.log("ULAdvCustomManager.refresh onLoadFail");
                },
            });
        }
        close() {
            ULLog.console.log("ULAdvCustomManager.close");
            this.hadShowRulst = true;
            this.loadCycleList = [];
            this.channelAd.close();
            this.channelShowCycle.onClose && this.channelShowCycle.onClose(false);
        }
        destroy() {
            ULLog.console.log("ULAdvCustomManager.destroy");
            this.close();
            this.channelAd.destroy();
            this.channelAd = null;
        }
    }

    let qg$7 = window["qg"];
    class ULAdvVivoCustomItem {
        constructor() {
            this.arg = null;
            this.customAd = null;
            this.hadShow = false;
            this.showStyleString = "";
            this.channelStyle = null;
            this._showCycle = null;
        }
        init(arg) {
            this.arg = arg;
            let config = ULConfig.getConfig();
            let setting = config.t_sdk_vivo_custom_adv_setting;
            let settingObj = {};
            if (setting) {
                if ((typeof setting) == "string") {
                    try {
                        settingObj = JSON.parse(setting);
                    }
                    catch (error) {
                    }
                }
                else if ((typeof setting) == "object") {
                    settingObj = setting;
                }
            }
            this.channelStyle = settingObj[this.arg] || settingObj["*"] || {};
            ULLog.console.log("ULAdvVivoCustomItem.initAdv channelStyle:", this.channelStyle);
        }
        load(cycle) {
            ULLog.console.log("ULAdvVivoCustomItem.load ");
            if (!qg$7.createCustomAd) {
                cycle.onLoadFail({ code: "0", msg: "qg.createCustomAd == undefined" });
                return;
            }
            if (this.customAd) {
                this.close();
                this.destroy();
                this.customAd = null;
            }
            cycle.onLoad();
        }
        creatNewCustom(showStyle) {
            ULLog.console.log("ULAdvVivoCustomItem.creatNewCustom :", JSON.stringify(showStyle));
            if (this.customAd) {
                this.close();
                this.destroy();
                this.customAd = null;
            }
            let customAdParam = {
                posId: this.arg,
            };
            if (!ULTools.areObjectsEqual(showStyle, {
                x: 0.5,
                y: 0,
                width: 1,
                height: 0.5,
            })) {
                let style = {};
                try {
                    let sys = qg$7.getSystemInfoSync();
                    let screenWidth = sys.screenWidth;
                    let screenHeight = sys.screenHeight;
                    let adWidth = showStyle.width ? showStyle.width * screenWidth : 720;
                    if (adWidth < 720) {
                        adWidth = 720;
                    }
                    else if (adWidth > 1080) {
                        adWidth = 1080;
                    }
                    let left = showStyle.x ? showStyle.x * screenWidth : 0;
                    let top = showStyle.y ? showStyle.y * screenHeight : 0;
                    style = {
                        left: left,
                        top: top,
                    };
                }
                catch (error) {
                    ULLog.console.log("ULAdvVivoCustomItem.load catch:", error);
                }
                ULLog.console.log("ULAdvVivoCustomItem.load createCustomAd style:", JSON.stringify(style));
                customAdParam['style'] = style;
            }
            this.customAd = qg$7.createCustomAd(customAdParam);
            this.customAd.onError(this.onError.bind(this));
            this.customAd.onClose(this.onClose.bind(this));
        }
        onClose() {
            ULLog.console.log("ULAdvVivoCustomItem.show onClose:");
            this._showCycle && this._showCycle.onClose(true);
            this.destroy();
        }
        onError(err) {
            ULLog.console.log("ULAdvVivoCustomItem.show onError:");
            this._showCycle && this._showCycle.onShowFail({ code: "" + err.errCode, msg: err.errMsg });
        }
        show(style, cycle) {
            let showStyleString = JSON.stringify(style);
            let isEqual = showStyleString == this.showStyleString;
            this.showStyleString = showStyleString;
            console.log(`ULAdvVivoCustomItem.show style :${showStyleString} :`, isEqual);
            if (!this.customAd || !isEqual) {
                this.creatNewCustom(style);
            }
            this._showCycle = cycle;
            if (this.hadShow) {
                ULLog.console.log("ULAdvVivoCustomItem.show hadShow true");
                this.customAd.show();
                cycle.onShow();
            }
            else {
                this.customAd.show().then(() => {
                    ULLog.console.log("ULAdvVivoCustomItem.show then");
                    this.hadShow = true;
                    cycle.onShow();
                }).catch((e) => {
                    ULLog.console.log("ULAdvVivoCustomItem.show catch:", e);
                    cycle.onShowFail({ code: "" + e.errCode, msg: e.errMsg });
                });
            }
        }
        close() {
            ULLog.console.log("ULAdvVivoCustomItem.close ");
            this._showCycle = null;
            this.customAd && this.customAd.hide();
        }
        destroy() {
            ULLog.console.log("ULAdvVivoCustomItem.destroy ");
            this._showCycle = null;
            this.customAd.offError(this.onError.bind(this));
            this.customAd.offClose(this.onClose.bind(this));
            this.customAd && this.customAd.destroy();
            this.customAd = null;
            this.hadShow = false;
        }
    }

    class ULAdvVivoCustom extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.custom, ULTools.format("%s%s%s", "ULAdvVivoCustom", "_", arg));
            this.className = "ULAdvVivoCustom";
            this.customAd = null;
            this.showTranslucentSwitch = true;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
            let config = ULConfig.getConfig();
            this.showTranslucentSwitch = config.i_sdk_vivo_custom_translucent_swicth == 1;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoCustom-onDisposeModule arg:", this.arg);
            if (this.customAd) {
                this.customAd.destroy();
                this.customAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoCustom-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.customAd = ULAdvCustomManager.createCustomAd(ULAdvVivoCustomItem, { arg: this.arg }, false);
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvVivoCustom.showAdv");
            this.customAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoCustom.showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(data, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.customAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoCustom.showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
                if (this.showTranslucentSwitch) {
                    ULSdkManager.getInstance().moduleCheckerManager.showTranslucentView();
                }
            });
            this.customAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoCustom.showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, null);
            });
            this.customAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoCustom.showAdv-onClose");
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data, null);
                ULSdkManager.getInstance().moduleCheckerManager.closeTranslucentView();
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.isOpened = true;
            this.customAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoCustom.closeAdv");
            this.customAd.close();
            ULSdkManager.getInstance().moduleCheckerManager.closeTranslucentView();
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoCustom-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvVivoCustomBanner extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.custom, ULTools.format("%s%s%s", "ULAdvVivoCustomBanner", "_", arg));
            this.className = "ULAdvVivoCustomBanner";
            this.customAd = null;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoCustomBanner-onDisposeModule arg:", this.arg);
            if (this.customAd) {
                this.customAd.destroy();
                this.customAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoCustomBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.customAd = ULAdvCustomManager.createCustomAd(ULAdvVivoCustomItem, { arg: this.arg });
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvVivoCustomBanner.showAdv");
            this.customAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoCustomBanner.showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(data, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.customAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoCustomBanner.showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
            });
            this.customAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoCustomBanner.showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, null);
            });
            this.customAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoCustomBanner.showAdv-onClose");
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data, null);
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.isOpened = true;
            this.customAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoCustomBanner.closeAdv");
            this.customAd.close();
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoCustomBanner-receiveInitState:初始化失败");
            }
        }
    }

    let qg$8 = window["qg"];
    class ULAdvVivoBannerBox extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvVivoBannerBox" + "_" + arg);
            this.className = "ULAdvVivoBannerBox";
            this.showBannerGameBoxTags = {};
            this.statisticsAdvertiser = "ULAdvVivoBannerBox";
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoBannerBox-onDisposeModule arg:", this.arg);
            if (this.boxBannerAd) {
                this.boxBannerAd.destroy();
                this.boxBannerAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoBannerBox-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            let config = ULConfig.getConfig();
            let bannerTags = config.t_sdk_vivo_show_banner_box_adv_tags || [];
            for (let index = 0; index < bannerTags.length; index++) {
                let tag = bannerTags[index];
                this.showBannerGameBoxTags[tag] = true;
            }
            ULLog.console.log("ULAdvVivoBannerBox.init showBannerGameBoxTags:", this.showBannerGameBoxTags);
        }
        loadAdv() {
        }
        showAdv(data) {
            this.showData = data;
            let tag = data["tag"] || "";
            ULLog.console.log("ULAdvVivoBannerBox.showAdv tag:", tag, "  showBannerGameBoxTags :", this.showBannerGameBoxTags);
            if (!this.showBannerGameBoxTags[tag]) {
                ULLog.console.log("ULAdvVivoBannerBox.showAdv 当前广告位不允许展示横幅的盒子");
                this.advSkip(data, { code: "", msg: "ULAdvVivoBannerBox 不包含此tag:" + tag });
                return;
            }
            let config = ULConfig.getConfig();
            let timeGap = ULTools.time() - this.lastShowBannerTime;
            if (timeGap <= config.i_sdk_adv_banner_cd / 1000) {
                ULLog.console.log('ULAdvVivoBannerBox.openGameBannerBoxAdv cd 中');
                this.advSkip(data, { code: "", msg: "in cd" });
                return;
            }
            if (qg$8.createBoxBannerAd) {
                if (this.boxBannerAd) {
                    this.boxBannerAd.destroy();
                    this.boxBannerAd = null;
                }
                this.boxBannerAd = qg$8.createBoxBannerAd({
                    posId: this.arg
                });
                this.boxBannerAd.onError(function (err) {
                    ULLog.console.log('ULAdvVivoBannerBox.showAdv show fail with err:', JSON.stringify(err));
                    if (this.isOpened) {
                        this.isOpened = false;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    }
                });
                this.boxBannerAd.onClose(function () {
                    if (this.isOpened) {
                        this.isOpened = false;
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
                    }
                });
                this.boxBannerAd.show().then(function () {
                    ULLog.console.log('ULAdvVivoBannerBox.showAdv show success');
                    this.lastShowBannerTime = ULTools.time();
                    this.advSkip(data, { code: "", msg: "adv not ready" });
                });
                this.isOpened = true;
            }
            else {
                ULLog.console.log('ULAdvVivoBannerBox.showAdv 暂不支持互推盒子相关 API');
                this.advSkip(data, { code: "", msg: "暂不支持互推盒子相关 API" });
            }
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoBannerBox-closeAdv");
            this.isOpened = false;
            if (this.boxBannerAd != null) {
                this.boxBannerAd.destroy();
                this.boxBannerAd = null;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
            }
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvDemoInter-receiveInitState:初始化失败");
            }
        }
    }

    let qg$9 = window["qg"];
    class ULAdvVivoAutoNativeBanner extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvVivoAutoNativeBanner" + "_" + arg);
            this.className = "ULAdvVivoAutoNativeBanner";
            this.statisticsAdvertiser = ULAdvVivo.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoAutoNativeBanner-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoAutoNativeBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvVivoNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.banner,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvVivoAutoNativeBanner-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoAutoNativeBanner-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeBanner-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeBanner-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoAutoNativeBanner-showAdv-onClose isUserClick:", isUserClick);
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoAutoNativeBanner-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeBanner-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeBanner-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoAutoNativeBanner-receiveInitState:初始化失败");
            }
        }
    }

    let qg$a = window["qg"];
    class ULAdvVivoAutoNativeInter extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, "ULAdvVivoAutoNativeInter" + "_" + arg);
            this.className = "ULAdvVivoAutoNativeInter";
            this.nation_autoRefresh_intervals = 0;
            this.statisticsAdvertiser = ULAdvVivo.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoAutoNativeInter-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoAutoNativeInter-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvVivoNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.inter,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvVivoAutoNativeInter-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoAutoNativeInter-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeInter-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeInter-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoAutoNativeInter-showAdv-onClose isUserClick:", isUserClick);
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoAutoNativeInter-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeInter-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeInter-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoAutoNativeInter-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvVivoNativeEmbed extends ULAdvVivoNativeBase {
        constructor(arg) {
            super(arg, typeExp.embed, "ULAdvVivoNativeEmbed_" + arg);
            this.statisticsType = oldTypeExp.embedded;
        }
    }

    let qg$b = window["qg"];
    class ULAdvVivoBanner extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvVivoBanner" + "_" + arg);
            this.className = "ULAdvVivoBanner";
            this.banner_autoRefresh_mode = false;
            this.bannerTimerId = null;
            this.bannerRefreshIntervals = 0;
            this.banner_autoRefresh_object = {
                showTime: 0,
                isLoading: false,
                hadFirstShowed: false,
                bannerAdrealWidth: 0,
                bannerAdrealHeight: 0
            };
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoBanner-onDisposeModule arg:", this.arg);
            if (this.bannerTimerId) {
                clearInterval(this.bannerTimerId);
                this.bannerTimerId = null;
            }
            if (this.bannerAd) {
                this.bannerAd.offError();
                this.bannerAd.offLoad();
                this.bannerAd.offClose();
                this.bannerAd.offSize();
                this.bannerAd.destroy();
                this.bannerAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            let config = ULConfig.getConfig();
            this.banner_autoRefresh_mode = !!config.i_sdk_banner_autoRefresh_mode;
            let adIntervals = config.i_sdk_banner_refresh_intervals || 30;
            this.bannerRefreshIntervals = Number(adIntervals) || 30;
            this.banner_autoRefresh_object.showTime = this.bannerRefreshIntervals;
            this.banner_autoRefresh_object.isLoading = true;
            if (this.banner_autoRefresh_mode) {
                let self = this;
                this.bannerTimerId = setInterval(function () {
                    if (self.isOpened || self.banner_autoRefresh_object.isLoading) {
                        self.banner_autoRefresh_object.showTime++;
                        ULLog.console.log(`ULAdvVivoBanner banner_autoRefresh showTime:${self.banner_autoRefresh_object.showTime} `);
                        if (self.banner_autoRefresh_object.showTime > self.bannerRefreshIntervals) {
                            self.creatBannerAd();
                        }
                    }
                }, 1000);
            }
        }
        creatBannerAd() {
            ULLog.console.log("ULAdvVivoBanner.creatBannerAd ");
            this.banner_autoRefresh_object.showTime = 0;
            this.banner_autoRefresh_object.isLoading = true;
            this.banner_autoRefresh_object.bannerAdrealWidth = 0;
            this.banner_autoRefresh_object.bannerAdrealHeight = 0;
            let bannerAd = qg$b.createBannerAd({
                posId: this.arg,
                style: {}
            });
            ULLog.console.log(`ULAdvVivoBanner.creatBannerAd bannerId :${this.arg}`);
            bannerAd.onError((e) => {
                ULLog.console.log("ULAdvVivoBanner.creatBannerAd bannerAd.onError", e);
                if (bannerAd != this.bannerAd) {
                    bannerAd.destroy();
                }
            });
            bannerAd.onLoad(() => {
                ULLog.console.log("ULAdvVivoBanner.creatBannerAd bannerAd.onLoad");
                if (this.bannerAd == bannerAd) {
                    return;
                }
                if (this.bannerAd) {
                    this.bannerAd.hide();
                    this.bannerAd.destroy();
                    this.bannerAd = null;
                }
                this.bannerAd = bannerAd;
                this.banner_autoRefresh_object.showTime = 0;
                this.banner_autoRefresh_object.isLoading = false;
                this.banner_autoRefresh_object.hadFirstShowed = false;
                if (this.isOpened) {
                    ULLog.console.log("ULAdvVivoBanner.creatBannerAd bannerAd.onLoad autoRefresh");
                    this.bannerAd.show().then(() => {
                        this.banner_autoRefresh_object.hadFirstShowed = true;
                        ULLog.console.log("ULAdvVivoBanner.creatBannerAd bannerAd.onLoad autoRefresh show then");
                    }).catch((err) => {
                        ULLog.console.log("ULAdvVivoBanner.creatBannerAd bannerAd.onLoad autoRefresh show catch:", err);
                    });
                }
            });
        }
        setBannerStyle(style) {
            if (this.bannerAd == null || this.bannerAd == undefined) {
                return;
            }
            let systemInfo = qg$b.getSystemInfoSync();
            let bannerWidth = Math.min(systemInfo.screenWidth, systemInfo.screenHeight);
            if (style) {
                console.log(`ULAdvVivoBanner.setBannerStyle style :${JSON.stringify(style)}`);
                let widthScale = style.width;
                if (widthScale != undefined && widthScale >= 0) {
                    bannerWidth = bannerWidth * widthScale;
                }
            }
            bannerWidth = Math.max(bannerWidth, 300);
            let callBack = (e) => {
                ULLog.console.log("ULAdvVivoBanner.setBannerStyle bannerAd.onResize", e);
                let left = (systemInfo.screenWidth - e.width) * 0.5;
                let top = systemInfo.screenHeight - e.height + 0.1;
                if (style) {
                    let x = style.x;
                    let y = style.y;
                    if (x != undefined && x >= 0 && x <= 1) {
                        left = (systemInfo.screenWidth - e.width) * x;
                        console.log("ULAdvVivoBanner.setBannerStyle bannerAd.onResize.newLeft", left);
                    }
                    if (y != undefined && y >= 0 && y <= 1) {
                        top = (1 - y) * (systemInfo.screenHeight - e.height);
                        console.log("ULAdvVivoBanner.setBannerStyle bannerAd.onResize.newTop", top);
                    }
                }
                this.bannerAd.style.left = left;
                this.bannerAd.style.top = top;
                this.banner_autoRefresh_object.bannerAdrealWidth = e.width;
                this.banner_autoRefresh_object.bannerAdrealHeight = e.height;
            };
            ULLog.console.log("ULAdvVivoBanner.setBannerStyle bannerWidth:", bannerWidth);
            ULLog.console.log("ULAdvVivoBanner.setBannerStyle bannerAdrealWidth:", this.banner_autoRefresh_object.bannerAdrealWidth);
            ULLog.console.log("ULAdvVivoBanner.setBannerStyle bannerAdrealHeight:", this.banner_autoRefresh_object.bannerAdrealHeight);
            if (this.banner_autoRefresh_object.bannerAdrealWidth > 0) {
                callBack({
                    width: this.banner_autoRefresh_object.bannerAdrealWidth,
                    height: this.banner_autoRefresh_object.bannerAdrealHeight
                });
            }
            this.bannerAd.offSize();
            this.bannerAd.onSize(callBack);
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvVivoBanner-showAdv");
            let platformVersionCode = qg$b.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1031) {
                console.warn("ULAdvVivoBanner-showAdv:原生api最低支持1031");
                this.advSkip(data, { code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvVivoBanner-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = data;
            let advId = data["advId"];
            ULLog.console.log("ULAdvVivoBanner-showAdv banner_autoRefresh_mode:", this.banner_autoRefresh_mode);
            this.showData = data;
            this.isOpened = true;
            this.bAutoCloseBannerFlag = false;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            if (this.banner_autoRefresh_mode) {
                if (this.bannerAd && this.bannerAd != undefined) {
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                    if (this.banner_autoRefresh_object.hadFirstShowed) {
                        this.bannerAd.show();
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
                    }
                    else {
                        this.bannerAd.show().then(() => {
                            ULLog.console.log("ULAdvVivoBanner.showBannerAdv bannerAd.show.then");
                            this.banner_autoRefresh_object.hadFirstShowed = true;
                            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
                        }).catch((err) => {
                            ULLog.console.log("ULAdvVivoBanner.showBannerAdv bannerAd.show.catch", err);
                            this.isOpened = false;
                            this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                        });
                    }
                }
                else {
                    ULLog.console.log("ULAdvHeadLineBanner.showBannerAdv bannerAd not ready");
                    this.isOpened = false;
                    this.advSkip(data, { code: "", msg: "bannerAd not ready" });
                }
                return;
            }
            else {
                if (this.bannerAd) {
                    this.bannerAd.destroy();
                    this.bannerAd = null;
                }
                this.bannerAd = qg$b.createBannerAd({
                    posId: this.arg,
                    style: {}
                });
                ULLog.console.log("ULAdvVivoBanner.setBannerStyle ------------4");
                this.bannerAd.onLoad(() => {
                    ULLog.console.log("ULAdvVivoBanner-showAdv-onLoad");
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                    this.bannerAd.show().then(() => {
                        ULLog.console.log("ULAdvVivoBanner.showAdv bannerAd.show then");
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                    }).catch((err) => {
                        ULLog.console.log("ULAdvVivoBanner.showAdv bannerAd.show catch", err);
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    });
                });
                this.bannerAd.onClose(() => {
                    ULLog.console.log("ULAdvVivoBanner-showAdv-onClose");
                    if (!this.bAutoCloseBannerFlag) {
                        ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                    }
                    this.isOpened = false;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                });
                this.bannerAd.onError((err) => {
                    ULLog.console.log("ULAdvVivoBanner-showAdv-onError:", err);
                    if (this.isOpened) {
                        this.isOpened = false;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                    }
                });
            }
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoBanner.closeAdv ");
            this.isOpened = false;
            this.bAutoCloseBannerFlag = true;
            if (this.banner_autoRefresh_mode) {
                if (!!this.bannerAd) {
                    this.bannerAd.hide();
                }
            }
            else {
                if (!!this.bannerAd) {
                    this.bannerAd.hide();
                    this.bannerAd.destroy();
                    this.bannerAd = null;
                }
            }
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvDemoInter-receiveInitState:初始化失败");
            }
        }
    }

    let qg$c = window["qg"];
    class ULAdvVivoAutoNativeEmbed extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.embed, "ULAdvVivoAutoNativeEmbed" + "_" + arg);
            this.className = "ULAdvVivoAutoNativeEmbed";
            this.statisticsAdvertiser = ULAdvVivo.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoAutoNativeEmbed-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoAutoNativeEmbed-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvVivoNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.embedded,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvVivoAutoNativeEmbed-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvVivoAutoNativeEmbed-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeEmbed-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvVivoAutoNativeEmbed-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvVivoAutoNativeEmbed-showAdv-onClose isUserClick:", isUserClick);
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoAutoNativeEmbed-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeEmbed-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvVivoAutoNativeEmbed-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoAutoNativeEmbed-receiveInitState:初始化失败");
            }
        }
    }

    let qg$d = window["qg"];
    class ULAdvVivoPortalBox extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.embed, "ULAdvVivoPortalBox" + "_" + arg);
            this.className = "ULAdvVivoPortalBox";
            this.marginTop = 0;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoPortalBox-onDisposeModule arg:", this.arg);
            if (this.boxPortalAd) {
                this.boxPortalAd.destroy();
                this.boxPortalAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoPortalBox-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
            this.boxPortalAd.show().then(function () {
                console.log('show success');
            }).catch(function (error) {
                console.log('show fail with:' + error.errCode + ',' + error.errMsg);
            });
        }
        showAdv(data) {
            ULLog.console.log("ULAdvVivoPortalBox-showAdv");
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvVivoPortalBox-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let advId = data["advId"];
            let tag = data["tag"] || advId || "";
            let config = ULConfig.getConfig();
            let vivo_portalBox_setting = config.t_sdk_vivo_show_portal_box_adv_setting;
            let setting = vivo_portalBox_setting[tag] || vivo_portalBox_setting[this.arg] || vivo_portalBox_setting["*"] || { top: 0.5 };
            let top = !isNaN(Number(setting.top)) ? Number(setting.top) : 0.5;
            let sys = qg$d.getSystemInfoSync();
            let screenHeight = sys.screenHeight;
            let marginTop = screenHeight * top;
            if (this.boxPortalAd && this.marginTop != marginTop) {
                this.boxPortalAd.destroy();
                this.boxPortalAd = null;
            }
            if (!this.boxPortalAd) {
                this.marginTop = marginTop;
                this.boxPortalAd = qg$d.createBoxPortalAd({
                    posId: this.arg,
                    marginTop: marginTop
                });
                this.boxPortalAd.onClose(() => {
                    ULLog.console.log("ULAdvVivoPortalBox-onClose");
                    if (this.isOpened) {
                        this.isOpened = false;
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                    }
                });
            }
            this.showData = data;
            this.isOpened = true;
            this.boxPortalAd.show().then(function () {
                ULLog.console.log("ULAdvVivoPortalBox-showAdv-then");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
            }).catch(function (err) {
                ULLog.console.log("ULAdvVivoPortalBox-showAdv-catch:", err);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                }
            });
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvVivoPortalBox-closeAdv");
            this.boxPortalAd && this.boxPortalAd.hide().then(function () {
                ULLog.console.log("ULAdvVivoPortalBox-closeAdv-hide-then");
            }).catch(function (error) {
                ULLog.console.log("ULAdvVivoPortalBox-closeAdv-hide-catch:", error.errCode + '_' + error.errMsg);
            });
            if (this.isOpened) {
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
            }
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvDemoInter-receiveInitState:初始化失败");
            }
        }
    }

    class ULCustomAd {
        create() {
            throw new Error("Method not implemented.");
        }
    }
    class ULChannelCustomAd extends ULCustomAd {
        constructor(arg) {
            super();
        }
    }
    class ULCustomAdItem extends ULCustomAd {
        constructor(param) {
            super();
            this._bShow = false;
            this._bAutoRefresh = false;
            this._refreshInterval = 30000;
            this._adItem = null;
            this._intervalId = null;
            this._arg = null;
            this._cls = null;
            this._showCD = null;
            this._bInstance = false;
            this._onShow = null;
            this._adType = null;
            this._arg = param.arg;
            this._adType = param.type;
            this._cls = param.cls;
            this._bAutoRefresh = param.bAutoRefresh;
            this._bInstance = param.bInstance;
            this._onShow = param.onShow;
            this.create();
        }
        create() {
            this._adItem = new this._cls(this._arg, this._adType);
        }
        onClose() {
            this.clear();
        }
        clear(data) {
            this._intervalId && clearInterval(this._intervalId);
            this._bShow = false;
            if (!this._bInstance) {
                this._adItem.destroy(data);
                this._adItem = null;
            }
            else {
                this._adItem.hide(data);
            }
        }
        load() {
            return this._adItem.load();
        }
        show(data) {
            let self = this;
            if (!self._adItem) {
                self.create();
            }
            return new Promise((resolve, reject) => {
                let mData = Object.assign(Object.assign({}, data), { onClose: () => {
                        self.onClose();
                        resolve();
                    } });
                let showData = data ? data.showData || {} : {};
                let onShowResult = self._onShow(showData['advId'] || showData['tag']);
                self._refreshInterval = onShowResult['interval'];
                mData['style'] = onShowResult['style'];
                let delayTime = onShowResult['delayTime'];
                let run = () => {
                    self._adItem.show(mData).then(() => {
                        self._bShow = true;
                        if (self._bAutoRefresh) {
                            self._intervalId = setInterval(() => {
                                if (!self._bInstance) {
                                    self._adItem && (self._adItem.destroy(), self._adItem = null);
                                    self.create();
                                }
                                mData['bRefresh'] = true;
                                self._adItem.show(mData);
                            }, self._refreshInterval * 1000);
                        }
                        else {
                        }
                    }).catch(err => {
                        self._bShow = false;
                        reject(err);
                    });
                };
                if (delayTime) {
                    setTimeout(run, delayTime);
                }
                else {
                    run();
                }
            });
        }
        hide(data) {
            this.clear(data);
        }
        destroy(data) {
            this.clear(data);
        }
    }
    class ULAdvCustomManager$1 {
        static autoRefreshMode() {
            return ULConfig.getConfig()['n_sdk_adv_atuo_refresh_switch'] == 1 || ULConfig.getConfig().i_sdk_custom_autoRefresh_mode == 1;
        }
        static delayToShow(advId, arg) {
            let delayConfig = ULConfig.getConfig()['o_sdk_adv_delay_show'] || {};
            let delay = delayConfig[advId] || delayConfig[arg] || delayConfig["*"] || 0;
            return delay;
        }
        static autoRefreshInterval(advId, arg) {
            let intervalObj = ULConfig.getConfig()['o_sdk_adv_atuo_refresh_interval'] || {};
            let interval = ULConfig.getConfig().i_sdk_custom_refresh_intervals || intervalObj[advId] || intervalObj[arg] || intervalObj["*"] || 30;
            return interval;
        }
        static advShowStyle(advId, arg) {
            let styleConfig = ULConfig.getConfig()['o_sdk_adv_atuo_refresh_style'] || ULConfig.getConfig().t_sdk_adv_custom_args_style_setting || {};
            let style = styleConfig[advId] || styleConfig[arg] || styleConfig["*"];
            return style;
        }
        static createCustomAd(arg, type, cls) {
            let cacheCustom = ULAdvCustomManager$1.cacheCustoms[arg];
            if (!cacheCustom) {
                cacheCustom = new ULCustomAdItem({
                    arg: arg,
                    type: type,
                    cls: cls,
                    bAutoRefresh: ULAdvCustomManager$1.autoRefreshMode(),
                    onShow: (advId) => {
                        return {
                            interval: ULAdvCustomManager$1.autoRefreshInterval(advId, arg),
                            style: ULAdvCustomManager$1.advShowStyle(advId, arg),
                            delayTime: ULAdvCustomManager$1.delayToShow(advId, arg)
                        };
                    }
                });
                ULAdvCustomManager$1.cacheCustoms[arg] = cacheCustom;
            }
            return cacheCustom;
        }
    }
    ULAdvCustomManager$1.cacheCustoms = {};
    let qg$e = window["qg"];
    var AD_TYPE;
    (function (AD_TYPE) {
        AD_TYPE["inter"] = "inter";
        AD_TYPE["icon"] = "icon";
        AD_TYPE["banner"] = "banner";
    })(AD_TYPE || (AD_TYPE = {}));
    const AD_TYPE_FORM = {
        inter: [2, 3, 4, 5, 6, 10],
        icon: [0],
        banner: [1, 7, 8, 9]
    };
    class ULAdvVivoNewNativeBase {
        static bSupport() {
            return !!qg$e && qg$e.createNewNativeAd;
        }
    }
    class ULVivoNewNativeCustomAd extends ULChannelCustomAd {
        constructor(arg, type) {
            super(arg);
        }
    }
    class ULAdvVivoNewNativeItem extends ULVivoNewNativeCustomAd {
        constructor(arg, type) {
            super(arg, type);
            this._nativeAd = null;
            this._adType = AD_TYPE.icon;
            this._arg = null;
            this._adType = type;
            this._arg = arg;
        }
        load() {
            ULLog.console.log("Unsupported.");
        }
        show(data) {
            let self = this;
            return new Promise((resolve, reject) => {
                let advKey = data ? data.advKey || "" : "";
                let showData = data ? data.showData || {} : {};
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(advKey);
                self._nativeAd = qg$e.createNewNativeAd({
                    posId: self._arg
                });
                self._nativeAd.offLoad();
                self._nativeAd.offError();
                self._nativeAd.offClose();
                self._nativeAd.offClick && self._nativeAd.offClick();
                self._nativeAd.onLoad(function (res) {
                    ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onLoad', res && JSON.stringify(res));
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(advKey);
                    if (res && res.adList) {
                        let formArray = AD_TYPE_FORM[self._adType];
                        let adList = res.adList;
                        let result = adList[0];
                        let formTypeArray = result['formType'];
                        let formType = undefined;
                        for (const iterator of formTypeArray) {
                            if (formArray.indexOf(iterator) != -1) {
                                formType = iterator;
                                break;
                            }
                        }
                        if (formType == undefined) {
                            formType = formArray[0];
                        }
                        var b = {
                            adId: result['adId'],
                            formType: formType
                        };
                        let sys = qg$e.getSystemInfoSync();
                        let screenWidth = sys.screenWidth;
                        let screenHeight = sys.screenHeight;
                        let mStyle = {};
                        let showStyle = showData.style || data.style || {};
                        let left = showStyle.hasOwnProperty("x") ? showStyle.x * screenWidth : undefined;
                        let top = showStyle.hasOwnProperty("y") ? showStyle.y * screenHeight : undefined;
                        (left != undefined) && (mStyle['left'] = left);
                        (top != undefined) && (mStyle['top'] = top);
                        if (Object.keys(showStyle).length > 0) {
                            b['style'] = mStyle;
                        }
                        self._nativeAd.show(b).then(() => {
                            ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onLoad-show-then');
                            if (!data['bRefresh']) {
                                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(advKey, ULConst.ADV_RESULT_MSG_SUCCESS, showData);
                            }
                            resolve();
                        }).catch((err) => {
                            ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onLoad-show-catch:', err && JSON.stringify(err));
                        });
                    }
                    else {
                        reject({
                            errCode: 0,
                            errMsg: "adList is null"
                        });
                    }
                });
                self._nativeAd.onClose(() => {
                    ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onClose');
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(advKey, showData);
                    data && data.onClose();
                });
                self._nativeAd.onError(err => {
                    ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onError: ', err && JSON.stringify(err));
                    if (!data['bRefresh']) {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(advKey, { code: String(err.errCode), msg: err.errMsg });
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(advKey, showData);
                        data && data.onClose();
                    }
                    reject(err);
                });
                self._nativeAd.onClick && self._nativeAd.onClick(() => {
                    ULLog.console.log('ULAdvVivoNewNativeItem-showAdv-onClick');
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(advKey, ULConst.ADV_RESULT_MSG_SUCCESS, showData);
                });
            });
        }
        hide(data) {
            let advKey = data ? data.advKey || "" : "";
            let closeData = data ? data.closeData || {} : {};
            this._nativeAd.hide();
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(advKey, closeData);
        }
        destroy(data) {
            this._nativeAd.destroy();
            if (data) {
                let advKey = data ? data.advKey || "" : "";
                let closeData = data ? data.closeData || {} : {};
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(advKey, closeData);
            }
        }
    }

    class ULAdvVivoNewNativeInter extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, ULTools.format("%s%s%s", "ULAdvVivoNewNativeInter", "_", arg));
            this.className = "ULAdvVivoNewNativeInter";
            this.nativeAd = null;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
            this.statisticsType = oldTypeExp.interstitial;
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoNewNativeInter-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            ULAdvVivoNewNativeBase.bSupport() && (this.nativeAd = ULAdvCustomManager$1.createCustomAd(this.arg, this.advType, ULAdvVivoNewNativeItem));
        }
        loadAdv() {
        }
        showAdv(data) {
            if (!this.nativeAd) {
                ULLog.console.warn("ULAdvVivoNewNativeInter-showAdv:尚未初始化或不支持");
                this.advSkip(data, { code: "", msg: "not initialized" });
                return;
            }
            let self = this;
            this.isOpened = true;
            this.nativeAd.show({
                advKey: this.advKey,
                showData: data
            }).then(() => {
                self.isOpened = false;
            }).catch(err => {
                self.isOpened = false;
                this.advSkip(data, { code: err.errCode, msg: err.errMsg });
            });
        }
        closeAdv(data) {
            this.isOpened = false;
            this.nativeAd && this.nativeAd.hide({
                advKey: this.advKey,
                closeData: data
            });
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoNewNativeInter-receiveInitState:初始化失败");
            }
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoNewNativeInter-onDisposeModule arg:", this.arg);
            if (this.nativeAd) {
                this.nativeAd.destroy();
                this.nativeAd = null;
            }
        }
    }

    class ULAdvVivoNewNativeBanner extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, ULTools.format("%s%s%s", "ULAdvVivoNewNativeBanner", "_", arg));
            this.className = "ULAdvVivoNewNativeBanner";
            this.nativeAd = null;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoNewNativeBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            ULAdvVivoNewNativeBase.bSupport() && (this.nativeAd = ULAdvCustomManager$1.createCustomAd(this.arg, this.advType, ULAdvVivoNewNativeItem));
        }
        loadAdv() {
        }
        showAdv(data) {
            if (!this.nativeAd) {
                ULLog.console.warn("ULAdvVivoNewNativeBanner-showAdv:尚未初始化或不支持");
                this.advSkip(data, { code: "", msg: "not initialized" });
                return;
            }
            let self = this;
            this.isOpened = true;
            this.nativeAd.show({
                advKey: this.advKey,
                showData: data
            }).then(() => {
                self.isOpened = false;
            }).catch(err => {
                self.isOpened = false;
                this.advSkip(data, { code: err.errCode, msg: err.errMsg });
            });
        }
        closeAdv(data) {
            this.isOpened = false;
            this.nativeAd && this.nativeAd.hide({
                advKey: this.advKey,
                closeData: data
            });
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoNewNativeBanner-receiveInitState:初始化失败");
            }
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoNewNativeBanner-onDisposeModule arg:", this.arg);
            if (this.nativeAd) {
                this.nativeAd.destroy();
                this.nativeAd = null;
            }
        }
    }

    class ULAdvVivoNewNativeIcon extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.icon, ULTools.format("%s%s%s", "ULAdvVivoNewNativeIcon", "_", arg));
            this.className = "ULAdvVivoNewNativeIcon";
            this.nativeAd = null;
            this.statisticsAdvertiser = ULAdvVivo.NORMAL_ADVERTISER;
        }
        initAdv() {
            ULLog.console.log("ULAdvVivoNewNativeIcon-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            ULAdvVivoNewNativeBase.bSupport() && (this.nativeAd = ULAdvCustomManager$1.createCustomAd(this.arg, this.advType, ULAdvVivoNewNativeItem));
        }
        loadAdv() {
        }
        showAdv(data) {
            if (!this.nativeAd) {
                ULLog.console.warn("ULAdvVivoNewNativeIcon-showAdv:尚未初始化或不支持");
                this.advSkip(data, { code: "", msg: "not initialized" });
                return;
            }
            let self = this;
            this.isOpened = true;
            this.nativeAd.show({
                advKey: this.advKey,
                showData: data
            }).then(() => {
                self.isOpened = false;
            }).catch(err => {
                self.isOpened = false;
                this.advSkip(data, { code: err.errCode, msg: err.errMsg });
            });
        }
        closeAdv(data) {
            this.isOpened = false;
            this.nativeAd && this.nativeAd.hide({
                advKey: this.advKey,
                closeData: data
            });
        }
        getMainClassName() {
            return "ULAdvVivo";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvVivoNewNativeIcon-receiveInitState:初始化失败");
            }
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvVivoNewNativeIcon-onDisposeModule arg:", this.arg);
            if (this.nativeAd) {
                this.nativeAd.destroy();
                this.nativeAd = null;
            }
        }
    }

    let qg$f = window["qg"];
    class ULVivoBuyQuantityCache {
        constructor(delegate) {
            this.className = "ULVivoBuyQuantityCache";
            this.delegate = null;
            this._isActive = false;
            this._isRegister = false;
            this._isNextDayOpen = false;
            this._isPaymentBehavior = false;
            this._onlineTime = 0;
            this._videoTimes = 0;
            this._payCount = 0;
            this._ecpmCount = 0;
            this._gameEventJudge = false;
            this._isReportAddiction = false;
            this.activeTime = ULTools.time();
            this.adPlanId = null;
            this.adGroupId = null;
            this.adCreativeId = null;
            this._onlineTimeRepotCache = 0;
            this.timerId = null;
            this._startWork = false;
            this.delegate = delegate;
            this.loadRecord();
            qg$f.onHide(() => {
                ULLog.console.log("ULVivoBuyQuantityCache qg.onHide");
                if (this._onlineTimeRepotCache > 0) {
                    this.delegate.addOnlineTime(this._onlineTimeRepotCache);
                    this._onlineTimeRepotCache = 0;
                }
            });
        }
        get addictionRule() {
            let config = ULConfig.getConfig();
            return config['s_sdk_vivo_buyQuantity_addiction_rule'] || "";
        }
        get addictionGameEventId() {
            let config = ULConfig.getConfig();
            return config['s_sdk_vivo_buyQuantity_addiction_game_eventId'] || "";
        }
        set onlineTime(v) {
            this._onlineTime = v;
            this.isReportAddiction = this.isReportAddiction;
        }
        get onlineTime() {
            return this._onlineTime;
        }
        set videoTimes(v) {
            this._videoTimes = v;
            this.isReportAddiction = this.isReportAddiction;
        }
        get videoTimes() {
            return this._videoTimes;
        }
        set payCount(v) {
            this._payCount = v;
            this.isPaymentBehavior = this._payCount > 0;
            this.isReportAddiction = this.isReportAddiction;
        }
        get payCount() {
            return this._payCount;
        }
        set ecpmCount(v) {
            this._ecpmCount = v;
            this.isReportAddiction = this.isReportAddiction;
        }
        get ecpmCount() {
            return this._ecpmCount;
        }
        set isReportAddiction(v) {
            if (this._isReportAddiction || !v)
                return;
            this._isReportAddiction = true;
            this.saveRecord();
            this.delegate.reportAddiction();
        }
        get isReportAddiction() {
            if (this._isReportAddiction)
                return true;
            let ruleExp = this.addictionRule;
            if (!ruleExp)
                return false;
            return ULEvalExp.evalExpResults(ruleExp, (key) => {
                if (key == "onlineTime") {
                    return this._onlineTime;
                }
                else if (key == "videoTimes") {
                    return this._videoTimes;
                }
                else if (key == "payCount") {
                    return this._payCount;
                }
                else if (key == "ecpmCount") {
                    return this._ecpmCount;
                }
                else if (key == "gameEventJudge") {
                    return this._gameEventJudge;
                }
            });
        }
        set isActive(v) {
            this._isActive = v;
            if (this._isActive) {
                this.delegate.reportActive();
            }
        }
        get isActive() {
            return this._isActive;
        }
        set isRegister(v) {
            if (this._isRegister)
                return;
            this._isRegister = v;
            if (this._isRegister) {
                this.saveRecord();
                this.delegate.reportRegister();
            }
        }
        get isRegister() {
            return this._isRegister;
        }
        set isPaymentBehavior(v) {
            if (this._isPaymentBehavior)
                return;
            this._isPaymentBehavior = v;
            if (this._isPaymentBehavior) {
                this.saveRecord();
                this.delegate.reportPaymentBehavior();
            }
        }
        get isPaymentBehavior() {
            return this._isPaymentBehavior;
        }
        set isNextDayOpen(v) {
            if (this._isNextDayOpen)
                return;
            this._isNextDayOpen = v;
            if (this._isNextDayOpen) {
                this.saveRecord();
                this.delegate.reportNextDayOpen();
            }
        }
        get isNextDayOpen() {
            if (this._isNextDayOpen)
                return true;
            let time = ULTools.time() - ULTools.timeDay(this.activeTime);
            return time > 60 * 60 * 24;
        }
        get gameEventJudge() {
            return this._gameEventJudge;
        }
        set gameEventJudge(v) {
            if (this._gameEventJudge || !v)
                return;
            this._gameEventJudge = true;
            this.isReportAddiction = this.isReportAddiction;
            this.delegate.gameEventDidJudge();
        }
        set startWork(v) {
            if (this._startWork == v)
                return;
            this._startWork = v;
            if (this._startWork) {
                let self = this;
                this.timerId = setInterval(() => {
                    self.onlineTime += 10;
                    self._onlineTimeRepotCache += 10;
                    if (self._onlineTimeRepotCache >= 60) {
                        self.delegate.addOnlineTime(self._onlineTimeRepotCache);
                        self._onlineTimeRepotCache = 0;
                    }
                    self.saveRecord();
                }, 10000);
                this.isActive = true;
                this.isRegister = true;
                this.isNextDayOpen = this.isNextDayOpen;
            }
            else {
                clearInterval(this.timerId);
            }
        }
        get startWork() {
            return this._startWork;
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage("ULVivoBuyQuantityCache_record") || "{}";
            ULLog.console.log("ULVivoBuyQuantityCache.loadRecord recordStr:", recordStr);
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this._isRegister = record.isRegister || false;
            this._isNextDayOpen = record.isNextDayOpen || false;
            this._isPaymentBehavior = record.isPaymentBehavior || false;
            this._onlineTime = record.onlineTime || 0;
            this._videoTimes = record.videoTimes || 0;
            this._payCount = record.payCount || 0;
            this._ecpmCount = record.ecpmCount || 0;
            this._gameEventJudge = record.gameEventJudge || false;
            this._isReportAddiction = record.isReportAddiction || false;
            this.activeTime = record.activeTime || ULTools.time();
            this.adPlanId = record.adPlanId || "";
            this.adGroupId = record.adGroupId || "";
            this.adCreativeId = record.adCreativeId || "";
        }
        saveRecord() {
            let recordStr = JSON.stringify({
                isRegister: this._isRegister,
                isNextDayOpen: this._isNextDayOpen,
                isPaymentBehavior: this._isPaymentBehavior,
                onlineTime: this._onlineTime,
                videoTimes: this._videoTimes,
                payCount: this._payCount,
                ecpmCount: this._ecpmCount,
                gameEventJudge: this._gameEventJudge,
                isReportAddiction: this._isReportAddiction,
                activeTime: this.activeTime,
                adPlanId: this.adPlanId,
                adGroupId: this.adGroupId,
                adCreativeId: this.adCreativeId,
            });
            ULStorageManager.getInstance().setStorage("ULVivoBuyQuantityCache_record", recordStr);
        }
        playVideoAdComplete() {
            this.videoTimes += 1;
            this.saveRecord();
        }
        paySuccess(count) {
            this.payCount += count;
            this.saveRecord();
        }
        onAcceptEcpm(ecpm) {
            this.ecpmCount += ecpm;
            this.saveRecord();
        }
        onAcceptEvent(eventId) {
            if (eventId && eventId == this.addictionGameEventId) {
                this.gameEventJudge = true;
                this.saveRecord();
            }
        }
        getCacheMessage() {
            return {
                isActive: this.isActive,
                isRegister: this._isRegister,
                isNextDayOpen: this.isNextDayOpen,
                isPaymentBehavior: this.isPaymentBehavior,
                onlineTime: this.onlineTime,
                videoTimes: this.videoTimes,
                payCount: this.payCount,
                ecpmCount: this.ecpmCount,
                gameEventJudge: this.gameEventJudge,
                isReportAddiction: this.isReportAddiction,
                activeTime: this.activeTime,
                adPlanId: this.adPlanId,
                adGroupId: this.adGroupId,
                adCreativeId: this.adCreativeId,
            };
        }
    }

    var ULVivoBuyQuantityType;
    (function (ULVivoBuyQuantityType) {
        ULVivoBuyQuantityType[ULVivoBuyQuantityType["active"] = 1] = "active";
        ULVivoBuyQuantityType[ULVivoBuyQuantityType["active_register"] = 2] = "active_register";
        ULVivoBuyQuantityType[ULVivoBuyQuantityType["active_gameEvent"] = 20] = "active_gameEvent";
    })(ULVivoBuyQuantityType || (ULVivoBuyQuantityType = {}));
    let qg$g = window["qg"];
    class ULVivoBuyQuantityApi {
        constructor(delegate) {
            this.delegate = null;
            this.className = "ULVivoBuyQuantityApi";
            this.cacheItem = new ULVivoBuyQuantityCache(this);
            this.osType = 0;
            this.delegate = delegate;
            if (this.startMode) {
                this.addListener();
            }
        }
        get startMode() {
            let config = ULConfig.getConfig();
            return config['n_sdk_vivo_buyQuantity_switch'] == 1;
        }
        get debugMode() {
            let config = ULConfig.getConfig();
            return config['n_sdk_vivo_buyQuantity_debug_switch'] == 1;
        }
        get serviceUrl() {
            let config = ULConfig.getConfig();
            let url = ULTools.parseUrl(config['s_sdk_vivo_buyQuantity_base_url'] || "");
            if (url.port) {
                return `${url.protocol}//${url.host}:${url.port}`;
            }
            return `${url.protocol}//${url.host}`;
        }
        initSdk() {
            ULLog.console.log("ULVivoBuyQuantityApi.initSdk");
            try {
                let systemInfo = qg$g.getSystemInfoSync();
                let platform = systemInfo.platform || "";
                if (platform.toLowerCase() == "ios") {
                    this.osType = 1;
                }
            }
            catch (e) {
                ULLog.console.log("ULVivoBuyQuantityApi.initSdk.getSystemInfoSync-----err:", e);
            }
            if (this.cacheItem.isActive) {
                this.cacheItem.startWork = true;
                this.showDebugMode("温馨提示", `已是买量用户\n ${this.cacheItem.adPlanId}`, () => {
                });
            }
            else {
                if (qg$g.getEnterOptionsSync) {
                    let enterOptions = qg$g.getEnterOptionsSync() || {};
                    let query = enterOptions.query || {};
                    let adPlanId = query['adPlanId'] || "";
                    if (adPlanId) {
                        this.showDebugMode("温馨提示", `买量用户\n ${adPlanId}`, () => {
                        });
                        this.cacheItem.adPlanId = adPlanId;
                        this.cacheItem.adGroupId = query.adGroupId || "";
                        this.cacheItem.adCreativeId = query.adCreativeId || "";
                        this.cacheItem.startWork = true;
                    }
                }
            }
            ULLog.console.log("ULVivoBuyQuantityApi.initSdk isActive:", this.cacheItem.isActive);
        }
        addListener() {
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_MORE_GAME_AB_TEST_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerMoreGameTestConfig.bind(this));
        }
        reportType(type) {
            let success = (response) => {
                this.showDebugMode("VIVO买量", `上传数据成功：\n${response}`, () => {
                });
            };
            let fail = (errMsg) => {
                this.showDebugMode("VIVO买量", `上传数据失败：\n${errMsg}`, () => {
                });
            };
            if (!this.cacheItem.adPlanId) {
                fail(`该用户不是 买量 用户`);
                return;
            }
            this.showDebugMode("VIVO买量", `上传数据\ntype：${type}`, () => {
                let config = ULConfig.getConfig();
                this.reportToNetWork({
                    data: {
                        imei: "",
                        ouId: "",
                        timestamp: Date.now().toString(),
                        pkg: config['s_sdk_vivo_package_name'] || "",
                        dataType: Number(type),
                        channel: 1,
                        type: 0,
                        ascribeType: 1,
                        adId: this.cacheItem.adPlanId
                    },
                    success: success,
                    fail: fail
                });
            });
        }
        reportToNetWork(param) {
            if (!this.delegate) {
                param.fail && param.fail(`未注册delegate`);
                return;
            }
            this.delegate.getOpenId({
                success: (openId) => {
                    ULLog.console.log("ULVivoBuyQuantityApi.getOpenId success openId:", openId);
                    let params = Object.assign(Object.assign({}, param.data), {
                        openId: openId
                    });
                    let config = ULConfig.getConfig();
                    ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork body:", params);
                    ULTools.httpPostEncryption({
                        url: `${this.serviceUrl}`,
                        postString: JSON.stringify(params),
                        timeoutMillisecond: config.i_net_timeout,
                        success: (responseText) => {
                            ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork success:", responseText);
                            param.success && param.success(responseText);
                        },
                        fail: (err) => {
                            ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork err:", err);
                            param.fail && param.fail(`上报失败：${JSON.stringify(err)}`);
                        }
                    });
                },
                fail: (err) => {
                    ULLog.console.log("ULVivoBuyQuantityApi.getOpenId fail:", err);
                    param.fail && param.fail(`获取openId失败：${JSON.stringify(err)}`);
                }
            });
        }
        reportNetworkAddictionData(typeName, value) {
            let success = (response) => {
                this.showDebugMode("VIVO买量", `上传行为成功：\n${response}`, () => {
                });
            };
            let fail = (errMsg) => {
                this.showDebugMode("VIVO买量", `上传行为失败：\n${errMsg}`, () => {
                });
            };
            if (!this.cacheItem.adPlanId) {
                fail(`该用户不是 买量 用户`);
                return;
            }
            this.showDebugMode("VIVO买量", `上传行为\n typeName: ${typeName}\n value: ${value}`, () => {
                let config = ULConfig.getConfig();
                this.reportNetworkAddictionDataToNetWork({
                    data: {
                        gameId: Number(config.s_prj_id),
                        copChannelId: config.s_sdk_cop_channel_id,
                        typeName: typeName,
                        value: value,
                        sdkUserId: ULSdkManager.getInstance().channelInfo._sdkUserId,
                        callback: this.cacheItem.adPlanId,
                        platform: this.osType == 1 ? "ios" : "android",
                        copVersion: config.s_sdk_cop_version,
                        creativeId: this.cacheItem.adCreativeId || ""
                    },
                    success: success,
                    fail: fail
                });
            });
        }
        reportNetworkAddictionDataToNetWork(param) {
            if (!this.delegate) {
                param.fail && param.fail(`未注册delegate`);
                return;
            }
            this.delegate.getOpenId({
                success: (openId) => {
                    ULLog.console.log("ULVivoBuyQuantityApi.getOpenId success openId:", openId);
                    let config = ULConfig.getConfig();
                    let params = Object.assign(Object.assign({}, param.data), {
                        openId: openId
                    });
                    ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork body:", params);
                    ULTools.httpPostEncryption({
                        url: `${this.serviceUrl}/iaaback/h5/ksuploadaddictionevent`,
                        postString: JSON.stringify(params),
                        timeoutMillisecond: config.i_net_timeout,
                        success: (responseText) => {
                            ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork success:", responseText);
                            param.success && param.success(responseText);
                        },
                        fail: (err) => {
                            ULLog.console.log("ULVivoBuyQuantityApi.reportToNetWork err:", err);
                            param.fail && param.fail(`获取openId失败：${JSON.stringify(err)}`);
                        }
                    });
                },
                fail: (err) => {
                    ULLog.console.log("ULVivoBuyQuantityApi.getOpenId fail:", err);
                    param.fail && param.fail(`获取openId失败：${JSON.stringify(err)}`);
                }
            });
        }
        onCmdPlayVideoAd(e) {
            if (!this.cacheItem.isActive)
                return;
            ULLog.console.log("ULVivoBuyQuantityApi.onCmdPlayVideoAd");
            this.cacheItem.playVideoAdComplete();
            this.reportNetworkAddictionData("advShowCount", 1);
        }
        onCmdPaySuccess(e) {
            if (!this.cacheItem.isActive)
                return;
            let data = e.data;
            let count = data.count || 0;
            ULLog.console.log("ULVivoBuyQuantityApi.onCmdPaySuccess count:", count);
            this.cacheItem.paySuccess(count);
            this.reportNetworkAddictionData("payMoney", count);
        }
        onCmdPostEventId(e) {
            if (!this.cacheItem.isActive)
                return;
            let data = e.data;
            let commonEventId = data.commonEventId || "";
            ULLog.console.log("ULVivoBuyQuantityApi.onCmdPostEventId commonEventId:", commonEventId);
            if (commonEventId) {
                this.cacheItem.onAcceptEvent(commonEventId);
            }
        }
        showDebugMode(title, content, callBack) {
            if (this.debugMode) {
                ULSdkManager.getInstance().moduleCheckerManager.alertPrompt(title, content, "知道了", () => {
                    callBack();
                });
            }
            else {
                callBack();
            }
        }
        reportActive() {
            this.reportType(ULVivoBuyQuantityType.active);
        }
        reportRegister() {
            this.reportType(ULVivoBuyQuantityType.active_register);
        }
        reportNextDayOpen() {
        }
        reportPaymentBehavior() {
        }
        reportAddiction() {
        }
        addOnlineTime(time) {
            this.reportNetworkAddictionData("playTime", time);
        }
        gameEventDidJudge() {
            this.reportNetworkAddictionData("gameTag", 1);
        }
        showPickerDialogObj(obj) {
            let conf = [];
            for (let key of Object.keys(obj)) {
                let value = `${key} : ${obj[key]}`;
                conf.push({
                    text: value,
                    value: value
                });
            }
            ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("买量信息", conf, (v) => {
                ULSdkManager.getInstance().moduleCheckerManager.showBigTextWithPickerDialog("详情", v, 40);
            }, true);
        }
        onCmdSdkCollectionModuleCheckerMoreGameTestConfig(e) {
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "VIVO买量:" });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "    是否模拟VIVO买量用户启动:   " });
            config.push({ type: "newLine" });
            config.push({
                type: "button",
                text: "是",
                onClick: () => {
                    let config = ULConfig.getConfig();
                    let newKey = ULTools.format("ULModuleVivo_record_%s", config.s_prj_id);
                    let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
                    let record = JSON.parse(recordStr);
                    if (record['bTestBuyQuantity'] == "1") {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "已设置为买量用户启动", "确认");
                    }
                    else {
                        record['bTestBuyQuantity'] = "1";
                        ULStorageManager.getInstance().setStorage(newKey, JSON.stringify(record));
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "设置成功，将在下次启动游戏时生效", "确认");
                    }
                },
            }, {
                type: "button",
                text: "否",
                onClick: () => {
                    let config = ULConfig.getConfig();
                    let newKey = ULTools.format("ULModuleVivo_record_%s", config.s_prj_id);
                    let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
                    let record = JSON.parse(recordStr);
                    if (!record.hasOwnProperty('bTestBuyQuantity') || !record['bTestBuyQuantity']) {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "未设置为买量用户", "确认");
                    }
                    else {
                        delete record['bTestBuyQuantity'];
                        ULStorageManager.getInstance().setStorage(newKey, JSON.stringify(record));
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "设置成功，将在下次启动游戏时生效", "确认");
                    }
                },
            });
            e.setReturnValue(config, true);
        }
    }

    let qg$h = window["qg"];
    class ULModuleVivo extends ULChannelModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleVivo";
            this.openId = null;
        }
        getSubAdModuleClassName() {
            return ["ULAdvVivoInter", "ULAdvVivoBanner", "ULAdvVivoVideo", "ULAdvVivoCustom", "ULAdvVivoCustomBanner", "ULAdvVivoShare", "ULAdvVivoNativeBanner", "ULAdvVivoNativeInter", "ULAdvVivoAutoNativeInter", "ULAdvVivoAutoNativeBanner", "ULAdvVivoBannerBox", "ULAdvVivoNativeEmbed", "ULAdvVivoAutoNativeEmbed", "ULAdvVivoPortalBox", "ULAdvVivoNewNativeInter", "ULAdvVivoNewNativeBanner", "ULAdvVivoNewNativeIcon"];
        }
        getAdMainClassName() {
            return "ULAdvVivo";
        }
        createSubAdObj(className, param) {
            let targetObj;
            let advKey;
            ULLog.console.log("ULModuleVivo-createSubAdObj：", className);
            switch (className) {
                case "ULAdvVivoInter":
                    targetObj = new ULAdvVivoInter(param);
                    break;
                case "ULAdvVivoBanner":
                    targetObj = new ULAdvVivoBanner(param);
                    break;
                case "ULAdvVivoVideo":
                    targetObj = new ULAdvVivoVideo(param);
                    break;
                case "ULAdvVivoCustom":
                    targetObj = new ULAdvVivoCustom(param);
                    break;
                case "ULAdvVivoCustomBanner":
                    targetObj = new ULAdvVivoCustomBanner(param);
                    break;
                case "ULAdvVivoNativeBanner":
                    targetObj = new ULAdvVivoNativeBanner(param);
                    break;
                case "ULAdvVivoNativeInter":
                    targetObj = new ULAdvVivoNativeInter(param);
                    break;
                case "ULAdvVivoNativeEmbed":
                    targetObj = new ULAdvVivoNativeEmbed(param);
                    break;
                case "ULAdvVivoAutoNativeBanner":
                    targetObj = new ULAdvVivoAutoNativeBanner(param);
                    break;
                case "ULAdvVivoAutoNativeInter":
                    targetObj = new ULAdvVivoAutoNativeInter(param);
                    break;
                case "ULAdvVivoShare":
                    targetObj = new ULAdvVivoShare(param);
                    break;
                case "ULAdvVivoBannerBox":
                    targetObj = new ULAdvVivoBannerBox(param);
                    break;
                case "ULAdvVivoAutoNativeEmbed":
                    targetObj = new ULAdvVivoAutoNativeEmbed(param);
                    break;
                case "ULAdvVivoPortalBox":
                    targetObj = new ULAdvVivoPortalBox(param);
                    break;
                case "ULAdvVivoNewNativeInter":
                    targetObj = new ULAdvVivoNewNativeInter(param);
                    break;
                case "ULAdvVivoNewNativeBanner":
                    targetObj = new ULAdvVivoNewNativeBanner(param);
                    break;
                case "ULAdvVivoNewNativeIcon":
                    targetObj = new ULAdvVivoNewNativeIcon(param);
                    break;
                default:
                    break;
            }
            if (targetObj) {
                advKey = ULTools.format("%s%s%s", className, "_", param);
                ULSdkManager.getInstance().advManager.updateAdvKeyObjMap(advKey, targetObj);
            }
            return targetObj;
        }
        createMainAdObj() {
            return new ULAdvVivo();
        }
        init() {
            super.init();
            if (ULConfig.getConfig()['n_sdk_vivo_buyQuantity_switch'] == 1) {
                let config = ULConfig.getConfig();
                let newKey = ULTools.format("ULModuleVivo_record_%s", config.s_prj_id);
                let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
                let record = JSON.parse(recordStr);
                let adPlanId = "";
                if (qg$h.getEnterOptionsSync) {
                    let enterOptions = qg$h.getEnterOptionsSync() || {};
                    let query = enterOptions.query || {};
                    adPlanId = query['adPlanId'] || "";
                }
                if (adPlanId || record['bTestBuyQuantity'] == "1") {
                    ULConfig.updateConfig({
                        s_sdk_cop_version: "mailiang"
                    });
                }
            }
            new ULVivoBuyQuantityApi(this);
            this.initSdk();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_PAY, ULConst.PRIORITY_NONE, this.onCmdOpenPay.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_SHARE, 1, this.onCmdOpenShare.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_INSTALL_SHORTCUT, ULConst.PRIORITY_NONE, this.onCmdInstallShortcut.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_SHORTCUT_STATE, ULConst.PRIORITY_NONE, this.onCmdGetShortcutState.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_PHONE_VIBRATE, 1, this.onCmdPhoneVibrate.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_RECOMMENDATION, 1, this.onCmdOpenRecommendation.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLOSE_RECOMMENDATION, 1, this.onCmdCloseRecommendation.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USER_LOGIN, 1, this.onCmdUserLogin.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USER_IS_LOGIN, 1, this.onCmdUserIsLogin.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_USER_INFO_MSG, 1, this.onCmdGetUserInfo.bind(this));
        }
        initSdk() {
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.channelName = "vivo";
            channelInfo.uuid = this.sdkUserId;
            channelInfo.isSupportRecordShare = false;
            channelInfo.isShareEnabled = !!config.i_sdk_share_mode;
            channelInfo.copChannelId = config.s_sdk_cop_channel_id;
            channelInfo.isPayEnabled = !!qg$h.pay;
            channelInfo.isUseSdkRank = !!config.i_sdk_sdk_rank_mode;
            channelInfo.isSupportVibrate = true;
            channelInfo.isSupportUserInfo = true;
            if (qg$h.createBoxPortalAd) {
                channelInfo.isSupportRecommendationBtn = true;
            }
            let platformVersionCode = qg$h.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode >= 1041) {
                channelInfo.isSupportInstallShortcut = true;
            }
            channelInfo.getChannelOpenIdFunc = this.getChannelOpenIdFunc.bind(this);
            channelInfo.appName = "vivo";
            channelInfo.referenceBannerHeight = 110;
            let vivo_pay_info = config.o_sdk_vivo_pay_info || {};
            Object.keys(vivo_pay_info).length > 0 && (channelInfo.payInfo = vivo_pay_info);
        }
        formatDate(now) {
            let year = now.getFullYear();
            let month = (now.getMonth() + 1);
            month = month < 10 ? ('0' + month) : month;
            let date = now.getDate();
            date = date < 10 ? ('0' + date) : date;
            let hour = now.getHours();
            hour = hour < 10 ? ('0' + hour) : hour;
            let minute = now.getMinutes();
            minute = minute < 10 ? ('0' + minute) : minute;
            let second = now.getSeconds();
            second = second < 10 ? ('0' + second) : second;
            return year + month + date + hour + minute + second;
        }
        _hook_getStorage(key) {
            if (qg$h)
                return qg$h.getStorageSync({ key: key });
            return null;
        }
        _hook_setStorage(key, data) {
            if (qg$h)
                return qg$h.setStorageSync({ key: key, value: data });
        }
        _hook_isSupportClipboard() {
            return true;
        }
        _hook_getClipboardData(finishCallback) {
            qg$h.getClipboardData({
                success: function (res) {
                    finishCallback(res.data);
                },
                fail: function (res) {
                    finishCallback(null);
                }
            });
        }
        _hook_setClipboardData(clipboardData, finishCallback) {
            qg$h.setClipboardData({
                text: clipboardData,
                success(res) {
                    finishCallback(true);
                },
                fail(res) {
                    finishCallback(false);
                }
            });
        }
        login(obj) {
            if (qg$h.getSystemInfoSync().platformVersionCode >= 1063) {
                qg$h.login().then((res) => {
                    ULLog.console.log("ULModuleVivo.login success:", res);
                    obj.success(res.data.token || "");
                }, (err) => {
                    ULLog.console.log("ULModuleVivo.login fail:", JSON.stringify(err));
                    obj.fail(JSON.stringify(err));
                });
            }
            else {
                ULLog.console.log("ULModuleVivo.login fail platformVersionCode < 1063");
                obj.fail("platformVersionCode < 1063");
            }
        }
        getOpenId(obj) {
            if (this.openId) {
                obj.success && obj.success(this.openId);
                return;
            }
            let config = ULConfig.getConfig();
            this.login({
                success: (token) => {
                    ULLog.console.log("ULModuleVivo.getOpenId login success");
                    var userLoginUrl = config.s_sdk_common_login_url + "/sdkserver/userlogin";
                    var postData = {
                        token: token,
                        channel: "h5vivo",
                        gameId: Number(config.s_prj_id)
                    };
                    ULTools.httpPost({
                        url: userLoginUrl,
                        contentType: "application/json",
                        postData: JSON.stringify(postData),
                        timeoutMillisecond: config.i_net_timeout,
                        success: (responseText) => {
                            ULLog.console.log("ULModuleVivo.getOpenId success", responseText);
                            let resultObj = JSON.parse(responseText);
                            if (resultObj.code == 1) {
                                let openId = resultObj.openId;
                                this.openId = openId;
                                ULSdkManager.getInstance().channelInfo.channelUserId = openId;
                                obj.success && obj.success(this.openId);
                            }
                            else {
                                ULLog.console.log("ULModuleVivo.getOpenId resultObj:", resultObj);
                                obj.fail && obj.fail(JSON.stringify(resultObj));
                            }
                        },
                        fail: (res) => {
                            ULLog.console.log("ULModuleVivo.getOpenId fail:", res);
                            obj.fail && obj.fail(JSON.stringify(res));
                        }
                    });
                },
                fail: (res) => {
                    ULLog.console.log("ULModuleVivo.getOpenId login fail:", res);
                    obj.fail && obj.fail(JSON.stringify(res));
                }
            });
        }
        onCmdOpenPay(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            ULLog.console.log("ULModulVivo.onCmdOpenPay openPay:", JSON.stringify(data));
            let payId = data.payId;
            let userData = data.userData || "";
            let payDataObj = ULSdkManager.getInstance().channelInfo.payInfo;
            try {
                var moneyStr = payDataObj[payId]["price"];
            }
            catch (e) {
                ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                    code: "0",
                    msg: "payId 不存在",
                    payId: payId,
                    userData: userData,
                });
                return;
            }
            let moneyCent = parseInt(moneyStr);
            let netTimeout = config.i_net_timeout;
            let platformVersionCode = qg$h.getSystemInfoSync().platformVersionCode;
            ULLog.console.log("ULModulVivo.onCmdOpenPay platformVersionCode:", platformVersionCode);
            let qgUrl = config.s_sdk_vivo_qg_url;
            let version = config.s_sdk_vivo_version_name;
            let appSecret = config.s_sdk_vivo_app_secret;
            let packageName = config.s_sdk_vivo_package_name;
            let cpOrderNumber = ULTools.createRandomOrderId();
            let notifyUrl = "http://113.98.231.125:8051/vcoin/notifyStubAction";
            let orderTime = this.formatDate(new Date());
            let money = moneyCent / 100;
            let orderAmount = ULTools.format("%.2f", money);
            let orderTitle = payDataObj[payId]["proName"];
            let orderDesc = config.s_game_name;
            let signMethod = "MD5";
            let md5Secret = md5Sign(appSecret);
            md5Secret = md5Secret.toLowerCase();
            ULSdkManager.getInstance().statisManager.reportPayRequest();
            if (platformVersionCode >= 1056) {
                let appId = config.s_sdk_vivo_app_id;
                let md5SignStr = "appId=" + appId + "&cpOrderNumber=" + cpOrderNumber + "&orderAmount=" + moneyCent + "&productDesc=" + orderDesc + "&productName=" + orderTitle + "&" + md5Secret;
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost--new-md5Sign---", md5SignStr);
                let signature = md5Sign(md5SignStr);
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost--new-signature---", signature);
                signature = signature.toLowerCase();
                let orderInfo = JSON.stringify({
                    appId: appId,
                    cpOrderNumber: cpOrderNumber,
                    productName: orderTitle,
                    productDesc: orderDesc,
                    orderAmount: moneyCent,
                    vivoSignature: signature
                });
                this.qgPay(orderInfo, payId, userData, moneyCent);
            }
            else {
                let md5SignStr = "cpOrderNumber=" + cpOrderNumber + "&notifyUrl=" + notifyUrl + "&orderAmount=" + orderAmount + "&orderDesc=" + orderDesc + "&orderTime=" + orderTime + "&orderTitle=" + orderTitle + "&packageName=" + packageName + "&version=" + version + "&" + md5Secret;
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost---md5Sign---", md5SignStr);
                let signature = md5Sign(md5SignStr);
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost---signature---", signature);
                signature = signature.toLowerCase();
                let postData = "cpOrderNumber=" + cpOrderNumber + "&notifyUrl=" + notifyUrl + "&orderAmount=" + orderAmount + "&orderDesc=" + orderDesc + "&orderTime=" + orderTime + "&orderTitle=" + orderTitle + "&packageName=" + packageName + "&version=" + version + "&signMethod=" + signMethod + "&signature=" + signature;
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost---qgUrl---", qgUrl);
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost---postData---", postData);
                ULLog.console.log("ULModulVivo.onCmdOpenPay httpPost---netTimeout---", netTimeout);
                qgUrl = qgUrl + "?" + postData;
                ULTools.httpPost({
                    url: qgUrl,
                    postData: "",
                    timeoutMillisecond: netTimeout,
                    success: (res) => {
                        ULLog.console.log("ULModulVivo.onCmdOpenPay openPay---- success", res);
                        this.qgPay(res, payId, userData, moneyCent);
                    },
                    fail: () => {
                        ULLog.console.log("ULModulVivo.onCmdOpenPay openPay---- timeout");
                        ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                            code: "0",
                            msg: "订单预支付失败",
                            payId: payId,
                            userData: userData,
                        });
                        ULSdkManager.getInstance().statisManager.reportPayFail("", moneyCent);
                    },
                });
            }
        }
        qgPay(orderInfo, payId, userData, moneyCent) {
            qg$h.pay({
                orderInfo: orderInfo,
                success: (ret) => {
                    ULLog.console.log("ULModulVivo.onCmdOpenPay openPay---- success----qg.pay----", ret);
                    ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                        code: "1",
                        msg: "支付成功",
                        payId: payId,
                        userData: userData,
                    });
                    ULSdkManager.getInstance().statisManager.reportPaySuccess("", moneyCent);
                },
                fail: (msg, code) => {
                    ULLog.console.log("ULModulVivo.onCmdOpenPay openPay---- fail----qg.pay----", msg, code);
                    ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                        code: "0",
                        msg: "支付失败 code:" + code + " msg :" + msg,
                        payId: payId,
                        userData: userData,
                    });
                    ULSdkManager.getInstance().statisManager.reportPayFail("", moneyCent);
                },
                cancel: () => {
                    ULLog.console.log("ULModulVivo.onCmdOpenPay openPay---- cancel----qg.pay----");
                    ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                        code: "0",
                        msg: "取消支付",
                        payId: payId,
                        userData: userData,
                    });
                    ULSdkManager.getInstance().statisManager.reportPayCancel("", moneyCent);
                }
            });
        }
        onCmdOpenShare(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userData = data.userData || "";
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [config['s_sdk_miniplay_user_open_share_event_id']]);
            qg$h.share({
                success: () => {
                    ULLog.console.log("ULModuleVivo onCmdOpenShare......分享成功!");
                    ULSdkManager.getInstance().response(ULConst.CMD_SHARE_RESULT, {
                        code: 1,
                        msg: "分享成功",
                        userData: userData,
                    });
                    ULSdkManager.getInstance().statisManager.reportShareSuccess(0);
                },
                fail: (e) => {
                    ULLog.console.log(`ULModuleVivo onCmdOpenShare.......分享失败!`, e.code, e.message);
                    ULSdkManager.getInstance().response(ULConst.CMD_SHARE_RESULT, {
                        code: 0,
                        msg: "分享失败",
                        userData: userData,
                    });
                    ULSdkManager.getInstance().statisManager.reportShareFail(0);
                },
                complete(e) {
                    ULLog.console.log(`ULModuleVivo onCmdOpenShare.......complete!`);
                }
            });
        }
        onCmdInstallShortcut(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userData = data.userData;
            qg$h.hasShortcutInstalled({
                success: (res) => {
                    if (res == false) {
                        ULSdkManager.getInstance().statisManager.reportAddShortcut("0");
                        qg$h.installShortcut({
                            success: () => {
                                ULSdkManager.getInstance().statisManager.reportAddShortcut("1");
                                ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                    code: 1,
                                    msg: "添加桌面快捷方式成功",
                                    userData: userData,
                                });
                                this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                            },
                            fail: (err) => {
                                ULSdkManager.getInstance().statisManager.reportAddShortcut("2");
                                ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                    code: 0,
                                    msg: "添加桌面快捷方式失败",
                                    userData: userData,
                                });
                                this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                            }
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                            code: 2,
                            msg: "添加桌面快捷方式成功",
                            userData: userData,
                        });
                        this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                    }
                },
                fail: (err) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                        code: 0,
                        msg: "添加桌面快捷方式失败",
                        userData: userData,
                    });
                    this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                }
            });
        }
        onCmdGetShortcutState(e) {
            e.stopImmediatePropagation();
            ULLog.console.log("ULModulVivo.onCmdGetShortcutState:");
            if (qg$h.hasShortcutInstalled) {
                qg$h.hasShortcutInstalled({
                    success: (res) => {
                        ULLog.console.log("ULModulVivo.onCmdGetShortcutState.hasShortcutInstalled success :", res);
                        if (res == false) {
                            ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                                state: 1,
                                bHasPrompt: true
                            });
                        }
                        else {
                            ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                                state: 3,
                                bHasPrompt: true
                            });
                        }
                    },
                    fail: (err) => {
                        ULLog.console.log("ULModuleVivo.onCmdGetShortcutState.hasShortcutInstalled fail:", err);
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                            state: 1,
                            bHasPrompt: true
                        });
                    }
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                    state: 1,
                    bHasPrompt: true
                });
            }
        }
        onCmdPhoneVibrate(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let type = data.type || "short";
            switch (type) {
                case "long":
                    if (qg$h.vibrateLong) {
                        qg$h.vibrateLong();
                        this.responsePhoneVibrate(1, "success", data);
                    }
                    else {
                        ULLog.console.log("ULModuleVivo.onCmdPhoneVibrate 当前版本低");
                    }
                    break;
                default:
                    if (qg$h.vibrateShort) {
                        qg$h.vibrateShort();
                        this.responsePhoneVibrate(1, "success", data);
                    }
                    else {
                        ULLog.console.log("ULModuleVivo.onCmdPhoneVibrate 当前版本低");
                    }
                    break;
            }
        }
        responsePhoneVibrate(code, msg, data) {
            ULSdkManager.getInstance().response(ULConst.CMD_PHONE_VIBRATE_RESULT, {
                code: code,
                msg: msg,
                userData: data.userData,
                type: data.type,
                intensity: data.intensity
            });
        }
        onCmdOpenRecommendation(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let config = ULConfig.getConfig();
            let adUnitId = config['s_sdk_vivo_inter_box_id'];
            let style = data.style;
            if (qg$h.createBoxPortalAd) {
                if (!this.gamePortalGridAd) {
                    this.gamePortalGridAd = qg$h.createBoxPortalAd({
                        posId: adUnitId,
                        marginTop: style.top
                    });
                }
                let self = this;
                this.gamePortalGridAd.onError(function (err) {
                    ULLog.console.log("ULModuleVivo.onCmdOpenRecommendation err:", err);
                    ULSdkManager.getInstance().response(ULConst.CMD_OPEN_RECOMMENDATION_RESULT, {
                        code: 1,
                        msg: "交叉推荐成功",
                    });
                });
                this.gamePortalGridAd.onClose(function () {
                    ULLog.console.log("ULModuleVivo.onCmdOpenRecommendation onClose");
                    if (self.gamePortalGridAd.isDestroyed) {
                        return;
                    }
                    self.gamePortalGridAd.show();
                });
                this.gamePortalGridAd.show().then(function () {
                    ULLog.console.log("ULModuleVivo.onCmdOpenRecommendation show success");
                    ULSdkManager.getInstance().response(ULConst.CMD_OPEN_RECOMMENDATION_RESULT, {
                        code: 1,
                        msg: "交叉推荐成功",
                    });
                });
            }
            else {
                ULLog.console.log("ULModuleVivo.onCmdOpenRecommendation 暂不支持互推盒子相关 API");
                ULSdkManager.getInstance().response(ULConst.CMD_OPEN_RECOMMENDATION_RESULT, {
                    code: 0,
                    msg: "交叉推荐不支持",
                });
            }
        }
        onCmdCloseRecommendation(e) {
            e.stopImmediatePropagation();
            ULLog.console.log("ULModuleVivo.onCmdCloseRecommendation");
            let data = e.data;
            if (this.gamePortalGridAd != null) {
                this.gamePortalGridAd.isDestroyed = true;
                this.gamePortalGridAd.destroy();
                this.gamePortalGridAd = null;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_RECOMMENDATION_RESULT, {
                code: 1,
                msg: "关闭成功"
            });
        }
        getChannelOpenIdFunc(callback) {
            ULLog.console.log("ULModuleVivo.getChannelOpenIdFunc");
            this.getOpenId({
                success: (openId) => {
                    callback && callback(openId, null);
                },
                fail: (err) => {
                    callback && callback(null, JSON.stringify(err));
                }
            });
        }
        onCmdUserIsLogin(e) {
            e.stopImmediatePropagation();
            ULLog.console.log(`ULModuleOppoQg.onCmdUserIsLogin `);
            let data = e.data;
            let userData = data.userData || "";
            ULSdkManager.getInstance().response(ULConst.CMD_USER_IS_LOGIN_RESULT, {
                code: 1,
                userData: userData
            });
        }
        onCmdUserLogin(e) {
            e.stopImmediatePropagation();
            ULLog.console.log(`ULModuleOppoQg.onCmdUserLogin 登陆`);
            let userData = e.data.userData || "";
            let config = ULConfig.getConfig();
            this.login({
                success: (token) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_USER_LOGIN_RESULT, {
                        code: 1,
                        userData: userData,
                        loginData: {
                            mgid: Number(config.s_sdk_megadata_game_id),
                            gameId: Number(config.s_prj_id),
                            channel: "h5vivo",
                            openId: "",
                            token: token
                        }
                    });
                }, fail: (res) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_USER_LOGIN_RESULT, {
                        code: 0,
                        userData: userData
                    });
                }
            });
        }
        onCmdGetUserInfo(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let userData = data.userData || "";
            qg$h.getUserInfo().then((res) => {
                ULLog.console.log("ULModuleVivo.onCmdGetUserInfo then:", res);
                if (res.data) {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_INFO_MSG_RESULT, {
                        code: 1,
                        msg: "获取用户信息成功",
                        userData: userData,
                        userInfo: {
                            avatarUrl: res.data.smallAvatar,
                            nickName: res.data.nickName,
                            gender: res.data.gender.toString()
                        }
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_INFO_MSG_RESULT, {
                        code: 0,
                        msg: JSON.stringify(res),
                        userData: userData
                    });
                }
            }, (err) => {
                ULLog.console.log("ULModuleVivo.onCmdGetUserInfo catch:", err);
                ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_INFO_MSG_RESULT, {
                    code: 0,
                    msg: JSON.stringify(err),
                    userData: userData
                });
            });
        }
    }

    class ULSdkModuleLoader {
        static getObjectByModuleName(moduleName) {
            return ULSdkModuleLoader.moduleName_2_object[moduleName];
        }
        static getSubAdModuleClassName() {
            return ULSdkModuleLoader.moduleName_2_subAdvModuleClassName;
        }
        static getSubAdMainClassName() {
            return ULSdkModuleLoader.moduleName_2_subAdvMainClassName;
        }
        static initAllModules() {
            let modules = [];
            modules.push(new ULModuleCdk());
            modules.push(new ULModuleMegadata());
            modules.push(new ULModuleUserData());
            modules.push(new ULModuleClipboard());
            modules.push(new ULModuleDefault());
            modules.push(new ULModuleEmail());
            modules.push(new ULModuleVivo());
            //#region 主页的隐私按钮功能
            // modules.push(new ULModulePrivacyPolicy());
            for (let i = 0, len = modules.length; i < len; i++) {
                const module = modules[i];
                let moduleClassName = module.className;
                ULSdkModuleLoader.moduleName_2_subAdvModuleClassName[moduleClassName] = module.getSubAdModuleClassName();
                ULSdkModuleLoader.moduleName_2_subAdvMainClassName[moduleClassName] = module.getAdMainClassName();
            }
            ULLog.console.log("ULSdkModuleLoader-moduleName_2_subAdvModuleClassName:", ULSdkModuleLoader.moduleName_2_subAdvModuleClassName);
            ULLog.console.log("ULSdkModuleLoader-moduleName_2_subAdvMainClassName:", ULSdkModuleLoader.moduleName_2_subAdvMainClassName);
            for (let i = 0; i < modules.length; i++) {
                const module = modules[i];
                let subModules = module.loadSubModules();
                for (let j = 0; j < subModules.length; j++) {
                    const subModule = subModules[j];
                    modules.splice(i + 1, 0, subModule);
                    i++;
                }
            }
            ULLog.console.log("ULSdkModuleLoader--modules:", modules);
            for (let i = 0; i < modules.length; i++) {
                const module = modules[i];
                ULSdkModuleLoader.moduleName_2_object[module.className] = module;
                try {
                    ULLog.console.log("ULSdkModuleLoader--module.init:", module);
                    module.init();
                }
                catch (error) {
                    ULLog.console.error(error);
                }
            }
            return modules;
        }
    }
    ULSdkModuleLoader.moduleName_2_object = {};
    ULSdkModuleLoader.moduleName_2_subAdvModuleClassName = {};
    ULSdkModuleLoader.moduleName_2_subAdvMainClassName = {};

    class ULWaitTool {
        constructor() {
            this.conditionMap = {};
        }
        ok() {
            if (ULTools.getObjSize(this.conditionMap) <= 0)
                return true;
            return false;
        }
        getConditionMap() {
            let flags = [];
            ULTools.forEachMap(this.conditionMap, (k, v) => {
                flags.push(k);
            });
            return flags;
        }
        addCondition(key) {
            this.conditionMap[key] = true;
        }
        removeCondition(key) {
            delete this.conditionMap[key];
        }
    }

    class ULChannelInfo {
        constructor() {
            this.waits = null;
            this._agreePrivacyPolicyCallBackList = [];
            this._isAgreePrivacyPolicy = false;
            this.copInfo = "{}";
            this.payInfo = {};
            this.jumpInfo = [];
            this.isSupportRecordShare = false;
            this.channelName = "default";
            this.isPayEnabled = false;
            this.isShareEnabled = false;
            this.isUseSdkRank = false;
            this.isShowUrlAdIcon = false;
            this.appName = "";
            this.equipmentModel = "";
            this.platformVersionMessage = "";
            this.osVersionMessage = "";
            this.cardType = 0;
            this.isThirdExit = false;
            this.isAbout = false;
            this.isMoreGame = false;
            this.isULMoreGame = false;
            this.isSupportClipboardData = false;
            this.isSupportInstallShortcut = false;
            this.isSupportFindMinigames = false;
            this.findMinigamesImageUrl = "";
            this.isSupportRecommendationBtn = false;
            this.isSupportJumpList = false;
            this.is4399Watermark = false;
            this.uuid = "";
            this.sdcardPath = "";
            this.packageVersion = "";
            this.copChannelId = "";
            this.ulsdkVersion = "";
            this.cdkChannelId = "";
            this._channelUserId = "";
            this.referenceBannerHeight = ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT;
            this.isNewUser = true;
            this.loginDays = 0;
            this._sdkUserId = "";
            this.isSupportPasterAdv = false;
            this.gameLanguage = "";
            this.isSupportChannelMoreGameBox = false;
            this.isSupportChannelBlockAd = false;
            this.isSupportSubscribe = false;
            this.isSupportColorSign = false;
            this.isSupportGridAd = false;
            this.isSupportVideoRank = false;
            this.isSupportFavoriteGuide = false;
            this.isSupportFollowOfficialAccount = false;
            this.appIdOrPkgName = "";
            this.isSupportContentSecurityCheck = false;
            this.isJumpLeisureEnabled = false;
            this.isSupportVibrate = true;
            this.isSupportOpenUrl = false;
            this.isSupportJumpInfoVideoType = false;
            this.isSupportUserCloudStorage = false;
            this.isSupportJoinGroup = false;
            this.isSupportOpenData = false;
            this.isSupportMegadataEncrypt = true;
            this.isSupportUserInfo = false;
            this.weixinIOSPayEnabled = false;
            this.isSupportHeadlineImRank = false;
            this.isSupportLaunchReward = false;
            this.isSupportWXGameClub = false;
            this.isSupportChannelMoreGame = false;
            this.isSupportChannelTask = false;
            this.isSupportULEmail = false;
            this.isSupportOpenCommunity = false;
            this.getChannelOpenIdFunc = null;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
            this.waits = new ULWaitTool();
        }
        onAgreePrivacyPolicy(callback) {
            if (this._isAgreePrivacyPolicy) {
                callback();
                return;
            }
            this._agreePrivacyPolicyCallBackList.push(callback);
        }
        get isAgreePrivacyPolicy() {
            return this._isAgreePrivacyPolicy;
        }
        set isAgreePrivacyPolicy(v) {
            if (this._isAgreePrivacyPolicy)
                return;
            this._isAgreePrivacyPolicy = v;
            if (this._isAgreePrivacyPolicy) {
                while (this._agreePrivacyPolicyCallBackList.length > 0) {
                    let callback = this._agreePrivacyPolicyCallBackList.shift();
                    callback();
                }
            }
        }
        set channelUserId(v) {
            if (this._channelUserId == v)
                return;
            this._channelUserId = v;
            if (!!this._channelUserId) {
                setTimeout(() => {
                    ULSdkManager.getInstance().statisManager.reportUserChannelId(this._channelUserId);
                }, 1000);
            }
        }
        get channelUserId() {
            return this._channelUserId;
        }
        toBaseChannelInfoData() {
            let config = ULConfig.getConfig();
            ULLog.console.log("config", config);
            let licenceInfo = config.s_sdk_licence_info == undefined ? "" : config.s_sdk_licence_info;
            licenceInfo = licenceInfo.replace(/\/n/g, "\n");
            let isShowAgeLevelInfo = !!config.i_sdk_age_level_info_mode;
            let ageLevelInfo = config.s_sdk_age_level_info || "";
            let result = {
                gameName: config.s_game_name,
                gameId: config.s_sdk_cop_game_id || config.s_prj_id,
                gameLanguage: this.gameLanguage,
                channelName: this.channelName,
                appName: this.appName,
                isShowLicenceInfo: config.i_sdk_licence_info_mode == 1,
                licenceInfo: licenceInfo,
                isShowAgeLevelInfo: isShowAgeLevelInfo,
                isStartGameByTouch: config.i_sdk_start_game_by_touch == 1,
                isSupportUserCloudStorage: this.isSupportUserCloudStorage,
            };
            if (ageLevelInfo) {
                result['ageLevelInfo'] = ageLevelInfo;
                result['ageLevelMin'] = config.s_sdk_age_level_target || "12";
            }
            return result;
        }
        toResponseData() {
            let jumpInfo = [];
            for (let i = 0; i < this.jumpInfo.length; i++) {
                const v = this.jumpInfo[i];
                if (!v.index || !v.url) {
                    ULLog.console.warn("ULChannelInfo.toResponseData jump data error!", v);
                    continue;
                }
                jumpInfo.push({
                    index: v.index,
                    url: v.url,
                    rewards: v.rewards || [],
                    bReceived: v.bReceived || false,
                    appName: v.appName || ""
                });
            }
            let config = ULConfig.getConfig();
            if (config['i_sdk_adv_reference_banner_height'] != null) {
                this.referenceBannerHeight = config['i_sdk_adv_reference_banner_height'];
            }
            this.isJumpLeisureEnabled = this.isJumpLeisureEnabled && !!config.i_sdk_moreWonderful_mode;
            this.isSupportInstallShortcut = this.isSupportInstallShortcut && !!config.i_sdk_installShortcut_mode;
            this.isSupportRecommendationBtn = this.isSupportRecommendationBtn && !!config.i_sdk_moregame_mode;
            this.isSupportJumpList = this.isSupportJumpList && !!config.i_sdk_jumplist_mode;
            this.isSupportVibrate = this.isSupportVibrate && !!config.i_sdk_phone_vibrate;
            this.isSupportOpenUrl = this.isSupportOpenUrl && !!config.i_sdk_support_open_url;
            this.isSupportRecordShare = this.isSupportRecordShare && !!config.i_sdk_support_record_share;
            this.isSupportSubscribe = this.isSupportSubscribe && !!config.i_sdk_subscribe_mode;
            this.isSupportJoinGroup = this.isSupportJoinGroup && !!config.i_sdk_joinGroup_mode;
            this.isPayEnabled = this.isPayEnabled && !!config.i_sdk_pay_mode;
            this.isShareEnabled = this.isShareEnabled && !!config.i_sdk_share_mode;
            if (this.weixinIOSPayEnabled) {
                this.isPayEnabled = this.weixinIOSPayEnabled && !!config.i_sdk_pay_mode && !!config['i_sdk_weixin_iosPay_mode'];
            }
            this.isSupportLaunchReward = this.isSupportLaunchReward && !!config.n_sdk_sidebar_reward_switch;
            this.isSupportChannelMoreGame = this.isSupportChannelMoreGame && !!config.n_sdk_channel_more_game_switch;
            this.isSupportChannelTask = this.isSupportChannelTask && !!config.n_sdk_channel_task_switch;
            this.isSupportULEmail = this.isSupportULEmail && !!config.n_sdk_ul_email_switch;
            this.isSupportFavoriteGuide = this.isSupportFavoriteGuide && !!config.n_sdk_add_favorite_switch;
            this.payInfo = this.payInfo || config.o_sdk_common_pay_info;
            this.isSupportOpenCommunity = this.isSupportOpenCommunity && !!config['n_sdk_open_community_switch'];
            return {
                copInfo: this.copInfo,
                cardType: this.cardType,
                isThirdExit: this.isThirdExit,
                isAbout: this.isAbout,
                payInfo: this.payInfo,
                isMoreGame: this.isMoreGame,
                isULMoreGame: this.isULMoreGame,
                uuid: this.uuid,
                sdcardPath: this.sdcardPath,
                packageVersion: this.packageVersion,
                copChannelId: this.copChannelId,
                ulsdkVersion: this.ulsdkVersion,
                isShowUrlAdIcon: this.isShowUrlAdIcon,
                cdkChannelId: this.cdkChannelId,
                isPayEnabled: this.isPayEnabled,
                isShareEnabled: this.isShareEnabled,
                isUseSdkRank: this.isUseSdkRank,
                isSupportRecordShare: this.isSupportRecordShare,
                isSupportInstallShortcut: this.isSupportInstallShortcut,
                isSupportClipboardData: this.isSupportClipboardData,
                isSupportFindMinigames: this.isSupportFindMinigames,
                findMinigamesImageUrl: this.findMinigamesImageUrl,
                isSupportRecommendationBtn: this.isSupportRecommendationBtn,
                isSupportJumpList: this.isSupportJumpList,
                is4399Watermark: this.is4399Watermark,
                appName: this.appName.toLocaleLowerCase(),
                jumpInfo: jumpInfo,
                channelUserId: this.channelUserId,
                referenceBannerHeight: this.referenceBannerHeight,
                isNewUser: this.isNewUser,
                loginDays: this.loginDays,
                isSupportPasterAdv: this.isSupportPasterAdv,
                gameLanguage: this.gameLanguage,
                isSupportChannelMoreGameBox: this.isSupportChannelMoreGameBox,
                isSupportChannelBlockAd: this.isSupportChannelBlockAd,
                isSupportSubscribe: this.isSupportSubscribe,
                isSupportGridAd: this.isSupportGridAd,
                isSupportVideoRank: this.isSupportVideoRank,
                isSupportFavoriteGuide: this.isSupportFavoriteGuide,
                isSupportFollowOfficialAccount: this.isSupportFollowOfficialAccount,
                customerServiceInfo: config.t_customer_service_info,
                appIdOrPkgName: this.appIdOrPkgName,
                isSupportContentSecurityCheck: this.isSupportContentSecurityCheck,
                isJumpLeisureEnabled: this.isJumpLeisureEnabled,
                isSupportVibrate: this.isSupportVibrate,
                isSupportOpenUrl: this.isSupportOpenUrl,
                isSupportJumpInfoVideoType: this.isSupportJumpInfoVideoType,
                isSupportUserCloudStorage: this.isSupportUserCloudStorage,
                isSupportJoinGroup: this.isSupportJoinGroup,
                isSupportHeadlineImRank: this.isSupportHeadlineImRank,
                isSupportOpenData: this.isSupportOpenData,
                isSupportLaunchReward: this.isSupportLaunchReward,
                isSupportWXGameClub: this.isSupportWXGameClub,
                isSupportUserInfo: this.isSupportUserInfo,
                isSupportChannelMoreGame: this.isSupportChannelMoreGame,
                isSupportChannelTask: this.isSupportChannelTask,
                isSupportULEmail: this.isSupportULEmail,
                isSupportFeedback: !!config['n_sdk_feedback_switch'],
                isSupportOpenCommunity: this.isSupportOpenCommunity
            };
        }
        isReady() {
            return this.waits.ok();
        }
        getPreparationFlags() {
            return this.waits.getConditionMap();
        }
        addPreparationFlag(key) {
            this.waits.addCondition(key);
        }
        removePreparationFlag(key) {
            this.waits.removeCondition(key);
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "渠道信息:" });
            config.push({ type: "newLine" });
            let text = "";
            let data = this.toResponseData();
            let keys = Object.keys(data);
            keys.sort();
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                let value = data[key];
                text += ULTools.format("[%s] = [%s]\n", key, JSON.stringify(value));
            }
            config.push({ type: "labelArea", text: text });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }

    class MCConsts {
    }
    MCConsts.COP_CITY_ID_2_NAME = {
        "": "关闭城市模拟",
    };

    class ULCopManager {
        constructor() {
            this.localCop = {};
            this.serverCop = {};
            this.cop = {};
            this.copStrategySetting = {};
            this.simulateCityId = "";
            this.simulateTemplateId = "";
            this.useCopStrategyName = "";
            this.coverCop = "";
        }
        init() {
            this.loadRecord();
            let config = ULConfig.getConfig();
            this.localCop = config.t_sdk_cop_default_cop;
            this.localCop = ULTools.jsonValToStr(this.localCop);
            ULLog.console.log(`ULCopManager-init-localCop:${JSON.stringify(this.localCop)}`);
            this.processCop();
            this.requestServerCop(false);
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, 10, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.useCopStrategyName = record.useCopStrategyName || "";
            this.setCoverCop(record.coverCop || "");
            this.setSimulateCityId(record.simulateCityId || "");
            this.setSimulateTemplateId(record.simulateTemplateId || "");
        }
        saveRecord() {
            let record = {
                simulateCityId: this.simulateCityId || "",
                simulateTemplateId: this.simulateTemplateId || "",
                useCopStrategyName: this.useCopStrategyName || "",
                coverCop: this.coverCop || "",
            };
            let recordStr = JSON.stringify(record);
            ULStorageManager.getInstance().setStorage(this._getRecordKey(), recordStr);
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULCopManager_record_%s", config.s_prj_id);
        }
        requestServerCop(bRetry) {
            let config = ULConfig.getConfig();
            if (!config.n_sdk_cop_switch) {
                ULLog.console.log("禁用cop");
                return;
            }
            if (!bRetry) {
                ULSdkManager.getInstance().channelInfo.addPreparationFlag("cop");
            }
            let cop_addr = config.s_sdk_cop_addr;
            if (!cop_addr) {
                ULLog.console.log("cop地址为空");
                return;
            }
            cop_addr += "/getdatav8";
            let platform = "1";
            let cop_game_id = config.s_prj_id;
            let cop_channel_id = config.s_sdk_cop_channel_id;
            let cop_version = config.s_sdk_cop_version;
            let uid = ULSdkManager.getInstance().channelInfo._sdkUserId;
            var reg = RegExp(/^[0-9a-zA-Z_]{1,}$/);
            if (!reg.test(uid)) {
                uid = "";
            }
            let netTimeout = config.i_net_timeout;
            let copUrl = ULTools.format("%s?platform=%s&gameid=%s&qudao=%s&version=%s&uid=%s&signmd5=&os=&devices=&uid=&imsi=&iccid=", cop_addr, platform, cop_game_id, cop_channel_id, cop_version, uid);
            if (this.simulateCityId || this.simulateTemplateId) {
                ULLog.console.warn("使用debug模式cop地址");
                copUrl = copUrl.replace("/getdatav8", "/getdatadebugv8");
                if (this.simulateCityId) {
                    copUrl += "&carrierid=0&zoneid=" + this.simulateCityId;
                }
                if (this.simulateTemplateId) {
                    copUrl += "&templateId=" + this.simulateTemplateId;
                }
            }
            ULLog.console.log("ULCopManager.requestServerCop:", copUrl);
            ULTools.httpGet({
                url: copUrl,
                timeoutMillisecond: netTimeout,
                success: (responseText) => {
                    let copJsonData = null;
                    try {
                        copJsonData = JSON.parse(responseText);
                        ULSdkManager.getInstance().statisManager.reportCopSuccess(responseText);
                    }
                    catch (error) {
                        ULLog.console.error(error);
                        ULSdkManager.getInstance().statisManager.reportCopFail(error.message);
                    }
                    ULLog.console.log("copJsonData", copJsonData);
                    if (copJsonData) {
                        this.serverCop = copJsonData;
                    }
                    else {
                        this.serverCop = {};
                    }
                    this.processCop();
                    this.triggerCopInfoResult();
                    if (!bRetry) {
                        ULSdkManager.getInstance().channelInfo.removePreparationFlag("cop");
                    }
                },
                fail: (err) => {
                    ULLog.console.warn("ULCopManager.requestServerCop http fail!", err);
                    if (!bRetry) {
                        ULSdkManager.getInstance().channelInfo.removePreparationFlag("cop");
                    }
                    ULSdkManager.getInstance().statisManager.reportCopFail("timeout");
                    ULTimer.callLater(ULConst.COP_RETRY_TIME_SEC, () => {
                        ULLog.console.log(ULTools.format("ULCopManager.requestServerCop 失败后，等待%d秒重新请求cop", ULConst.COP_RETRY_TIME_SEC));
                        this.requestServerCop(true);
                    });
                },
            });
        }
        processCop() {
            let config = ULConfig.getConfig();
            let cop = {};
            ULTools.forEachMap(this.localCop, (k, v) => {
                cop[k] = v;
            });
            ULTools.forEachMap(this.serverCop, (k, v) => {
                if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                    v = parseFloat(v);
                }
                if (k.substr(0, 2) == "t_") {
                    try {
                        v = JSON.parse(v);
                    }
                    catch (error) {
                        ULLog.console.log("processCop error --key:", k, " val:", v);
                        v = "";
                    }
                }
                cop[k] = v;
            });
            if (!config.n_sdk_cop_switch || !config.s_sdk_cop_addr) {
                if (this.coverCop) {
                    try {
                        ULTools.forEachMap(JSON.parse(this.coverCop), (k, v) => {
                            if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                                v = parseFloat(v);
                            }
                            if (k.substr(0, 2) == "t_") {
                                try {
                                    v = JSON.parse(v);
                                }
                                catch (error) {
                                    ULLog.console.log("processCop error --key:", k, " val:", v);
                                    v = "";
                                }
                            }
                            cop[k] = v;
                        });
                    }
                    catch (error) {
                        ULLog.console.error(`ULCopManager-init-coverCop:${JSON.stringify(error)}`);
                    }
                }
            }
            else {
                if (Object.keys(this.serverCop).length > 0 && this.coverCop) {
                    try {
                        ULTools.forEachMap(JSON.parse(this.coverCop), (k, v) => {
                            if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                                v = parseFloat(v);
                            }
                            if (k.substr(0, 2) == "t_") {
                                try {
                                    v = JSON.parse(v);
                                }
                                catch (error) {
                                    ULLog.console.log("processCop error --key:", k, " val:", v);
                                    v = "";
                                }
                            }
                            cop[k] = v;
                        });
                    }
                    catch (error) {
                        ULLog.console.error(`ULCopManager-init-coverCop:${JSON.stringify(error)}`);
                    }
                }
            }
            this.copStrategySetting = cop["t_sdk_cop_strategy_setting"] || config.t_sdk_cop_strategy_setting || {};
            if (this.useCopStrategyName && this.copStrategySetting[this.useCopStrategyName]) {
                let copStrategy = this.copStrategySetting[this.useCopStrategyName] || {};
                ULTools.forEachMap(copStrategy, (k, v) => {
                    if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                        v = parseFloat(v);
                    }
                    if (k.substr(0, 2) == "t_" && typeof (v) !== "object") {
                        try {
                            v = JSON.parse(v);
                        }
                        catch (error) {
                            ULLog.console.log("processCop error --key:", k, " val:", v);
                            v = "";
                        }
                    }
                    cop[k] = v;
                });
                this.setUseStrategyName(this.useCopStrategyName);
            }
            ULLog.console.log("processCop.copresult cop:", cop);
            this.cop = cop;
            let channelInfoCop = ULTools.clone(this.cop);
            channelInfoCop["cop_game_id"] = config.s_sdk_cop_game_id || config.s_prj_id || "unknown";
            channelInfoCop["cop_channel_id"] = config.s_sdk_cop_channel_id || "unknown";
            channelInfoCop["cop_version"] = config.s_sdk_cop_version || "unknown";
            ULSdkManager.getInstance().channelInfo.copInfo = JSON.stringify(channelInfoCop);
            ULConfig.updateConfig(this.cop);
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_ON_COP_CHANGED, {});
        }
        get(key, defaultValue) {
            let value = this.cop[key];
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
        getNumberValue(key, defaultValue) {
            let value = this.get(key, defaultValue);
            let numberValue = parseFloat(value);
            if (isNaN(numberValue))
                return 0;
            return numberValue;
        }
        getNumberValueInRange(key, defaultValue, minValue, maxValue) {
            let value = this.getNumberValue(key, defaultValue);
            value = ULTools.clampf(value, minValue, maxValue);
            return value;
        }
        getBooleanValue(key, defaultValue) {
            let value = this.get(key, defaultValue);
            return value == true;
        }
        setSimulateCityId(cityId) {
            this.simulateCityId = cityId;
            this.saveRecord();
            if (cityId != "") {
                let debugInfo = ULTools.format("已开启COP调试模式，模拟城市：%s_%s", cityId, ULConfig.getConfig().t_sdk_cop_simulate_city_data[cityId]);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop");
            }
        }
        setSimulateTemplateId(templateId) {
            this.simulateTemplateId = templateId;
            this.saveRecord();
            if (templateId != "") {
                let debugInfo = ULTools.format("已开启COP调试模式，模板id：%s", templateId);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop_templateId", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop_templateId");
            }
        }
        setCoverCop(coverCop) {
            this.coverCop = coverCop;
            this.saveRecord();
            if (coverCop != "") {
                let debugInfo = ULTools.format("已开启覆盖COP调试模式");
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cover_cop", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cover_cop");
            }
        }
        setUseStrategyName(useCopStrategyName) {
            this.useCopStrategyName = useCopStrategyName;
            this.saveRecord();
            if (useCopStrategyName != "") {
                let debugInfo = ULTools.format("已选择COP策略，策略名：%s", useCopStrategyName);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop_useCopStrategyName", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop_useCopStrategyName");
            }
        }
        triggerCopInfoResult() {
            let referenceBannerHeight = ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT;
            let config = ULConfig.getConfig();
            if (config['i_sdk_adv_reference_banner_height'] != null) {
                referenceBannerHeight = config['i_sdk_adv_reference_banner_height'];
            }
            ULSdkManager.getInstance().response(ULConst.CMD_COP_INFO_RESULT, {
                copInfo: ULSdkManager.getInstance().channelInfo.copInfo,
                referenceBannerHeight: referenceBannerHeight,
            });
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let cityId_2_name = ULTools.clone(MCConsts.COP_CITY_ID_2_NAME);
            let cConfig = ULConfig.getConfig();
            if (cConfig.t_sdk_cop_simulate_city_data) {
                ULLog.console.log("t_sdk_cop_simulate_city_data", cConfig.t_sdk_cop_simulate_city_data);
                ULTools.forEachMap(cConfig.t_sdk_cop_simulate_city_data, (k, v) => {
                    cityId_2_name[k] = v;
                });
            }
            ULLog.console.log("cityId_2_name", cityId_2_name);
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "Cop模块信息:" });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "Cop策略选择:" });
            config.push({ type: "label", name: "labelUseCopStrategyName", text: "(" + (this.useCopStrategyName || "已关闭") + ")" });
            config.push({
                type: "button",
                text: "策略选择",
                onClick: () => {
                    let conf = [{ text: "关闭", value: "" }];
                    for (let key in this.copStrategySetting) {
                        conf.push({ text: key, value: key });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择策略", conf, (value) => {
                        this.useCopStrategyName = value;
                        this.saveRecord();
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelUseCopStrategyName", this.useCopStrategyName || "已关闭");
                        if (value) {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已打开cop 策略，将在下次启动游戏时生效");
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已关闭cop 策略，将在下次启动游戏时生效");
                        }
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cop调试模式 模板id：" });
            config.push({
                type: "label",
                text: this.simulateTemplateId ? ULTools.format("%s(已开启) ", this.simulateTemplateId) : "已关闭 ",
                name: "labelCopTemplate",
            });
            config.push({
                type: "inputBox",
                name: "inputCopTemplate"
            });
            config.push({
                type: "button",
                text: "切换开关",
                onClick: () => {
                    let templateId = "";
                    if (this.simulateTemplateId) {
                        templateId = "";
                    }
                    else {
                        templateId = ULSdkManager.getInstance().moduleCheckerManager.getItemText("inputCopTemplate");
                        if (!templateId) {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("请先设置 模板id");
                            return;
                        }
                    }
                    this.setSimulateTemplateId(templateId);
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCopTemplate", templateId ? ULTools.format("%s(已开启) ", templateId) : "已关闭 ");
                    ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已开启cop调试模式，策略将在下次启动游戏时生效");
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cop调试模式 城市id：" });
            config.push({
                type: "label",
                text: ULTools.format("%s_%s", this.simulateCityId, cityId_2_name[this.simulateCityId]),
                name: "labelCopCity",
            });
            config.push({
                type: "button",
                text: "选择城市..",
                onClick: () => {
                    let keys = Object.keys(cityId_2_name);
                    let ids = [];
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let id = parseInt(key);
                        if (!isNaN(id)) {
                            ids.push(id);
                        }
                    }
                    ids.sort((a, b) => {
                        return a - b;
                    });
                    ids.unshift("");
                    let conf1 = [];
                    for (let i = 0; i < Math.min(15, ids.length); i++) {
                        const cityId = ids[i];
                        conf1.push({ text: ULTools.format("%s_%s", cityId, cityId_2_name[cityId]), value: cityId });
                    }
                    conf1.push({ text: "加载其他城市...", "value": "more" });
                    let conf2 = [];
                    for (let i = 0; i < ids.length; i++) {
                        const cityId = ids[i];
                        conf2.push({ text: ULTools.format("%s_%s", cityId, cityId_2_name[cityId]), value: cityId });
                    }
                    let fOnSelectCity = (cityId) => {
                        if (cityId == "more") {
                            ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择需要模拟的城市：", conf2, fOnSelectCity);
                            return;
                        }
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCopCity", ULTools.format("%s_%s", cityId, cityId_2_name[cityId]));
                        this.setSimulateCityId(cityId);
                        if (cityId != "") {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已开启cop调试模式，策略将在下次启动游戏时生效");
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("cop调试模式已关闭");
                        }
                    };
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择需要模拟的城市：", conf1, fOnSelectCity);
                },
            });
            config.push({
                type: "button",
                text: "重新请求cop",
                onClick: () => {
                    ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "重新请求cop不能保证所有功能生效，仅供查看cop使用。切换cop城市模拟后，请重新启动游戏测试功能", "知道了", () => {
                        ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已重新请求cop，不能保证所有功能生效");
                        this.requestServerCop(false);
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "覆盖COP:" });
            config.push({ type: "newLine" });
            config.push({
                type: "button",
                text: "覆盖",
                onClick: () => {
                    if (!ULSdkManager.getInstance().statisManager.whiteUserCheck) {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "请先验证并通过白名单校验", "确认");
                        return;
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("开始请求服务器覆盖COP，请稍后");
                    let gameId = ULConfig.getConfig().s_prj_id;
                    let netTimeout = ULConfig.getConfig().i_net_timeout;
                    let url = `https://common.ultralisk.cn/sdkserver/getCoverCop?gameId=${gameId}`;
                    ULTools.httpGet({
                        url: url,
                        timeoutMillisecond: netTimeout,
                        success: (responseText) => {
                            let jsonData = {};
                            try {
                                jsonData = JSON.parse(responseText);
                            }
                            catch (error) {
                            }
                            if (jsonData['code'] == 0) {
                                let inputCoverCop = jsonData['data'] || "";
                                if (!inputCoverCop) {
                                    ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("覆盖内容为空，功能不启用");
                                }
                                else {
                                    try {
                                        let coverCopObj = inputCoverCop;
                                        if (coverCopObj && (typeof coverCopObj === 'object')) {
                                            this.setCoverCop(JSON.stringify(inputCoverCop));
                                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "覆盖COP设置成功，将在下次启动游戏时生效", "确认");
                                        }
                                        else {
                                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("覆盖内容设置异常：仅支持JSON格式内容");
                                        }
                                    }
                                    catch (error) {
                                        ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("覆盖内容设置异常：仅支持JSON格式内容");
                                    }
                                }
                            }
                            else {
                                ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", `服务器覆盖COP请求失败:${responseText}`, "确认");
                            }
                        },
                        fail: (err) => {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", `服务器覆盖COP请求失败:${JSON.stringify(err)}`, "确认");
                        }
                    });
                },
            }, {
                type: "button",
                text: "取消",
                onClick: () => {
                    if (!ULSdkManager.getInstance().statisManager.whiteUserCheck) {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "请先验证并通过白名单校验", "确认");
                        return;
                    }
                    if (!this.coverCop) {
                        ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("覆盖内容为空，功能不启用");
                    }
                    else {
                        this.setCoverCop("");
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "覆盖COP已关闭，将在下次启动游戏时生效", "确认");
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "查看cop：" });
            config.push({
                type: "button",
                text: "默认cop",
                onClick: () => {
                    let cop = this.localCop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "默认cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({
                type: "button",
                text: "远程cop",
                onClick: () => {
                    let cop = this.serverCop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "远程cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({
                type: "button",
                text: "生效cop",
                onClick: () => {
                    let cop = this.cop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "生效cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({
                type: "button",
                text: "覆盖cop",
                onClick: () => {
                    if (this.coverCop) {
                        let cop = JSON.parse(this.coverCop);
                        let keys = Object.keys(cop);
                        keys.sort();
                        let copInfo = "覆盖cop：\n";
                        for (let i = 0; i < keys.length; i++) {
                            const key = keys[i];
                            let value = cop[key];
                            copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                        }
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "labelArea",
                text: "<<这里显示cop信息>>",
                name: "labelCop",
            });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }

    class ULStatisEventId {
    }
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_SINGLE_SHOW = "S_500";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_LIST_SHOW = "S_501";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_SINGLE_CLICK = "S_502";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_LIST_CLICK = "S_503";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_SINGLE_LAUNCH = "S_504";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_LIST_LAUNCH = "S_505";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_REWARD_SHOW = "S_506";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_REWARD_CLICK = "S_507";
    ULStatisEventId.SDK_CUSTOM_EVENT_JUMP_REWARD_LAUNCH = "S_508";
    ULStatisEventId.OPEN_SHARE = "S_509";
    ULStatisEventId.CLICK_SHARE = "S_510";
    ULStatisEventId.ADD_SUBSCRIPTION = "S_511";
    ULStatisEventId.CLICK_SUBSCRIPTION = "S_512";
    ULStatisEventId.CLICK_MORE_GAME_ICON_SINGLE = "S_513";
    ULStatisEventId.CLICK_MORE_GAME_ICON_REWARD = "S_514";
    ULStatisEventId.CLICK_MORE_GAME_ICON_LIST = "S_515";
    ULStatisEventId.CDK = "S_516";
    ULStatisEventId.CLICK_MORE_GAME_CHANNEL_SYSTEM_BUTTON = "S_517";
    ULStatisEventId.NATIVE_ADV_CLICK_EVENT = "S_518";
    ULStatisEventId.WEIXIN_TOUFANG = "S_519";
    ULStatisEventId.IOS_USERID_EVENT = "S_520";
    ULStatisEventId.REAL_NAME_AUTHENTICATION = "S_521";
    ULStatisEventId.LOGIN_EVENT = "S_522";
    ULStatisEventId.GAME_PACK_EVENT = "S_523";
    ULStatisEventId.INSTALLATION_SOURCE = "S_524";
    ULStatisEventId.OPPO_CUSTOM_EVENT = "S_525";
    ULStatisEventId.LAUNCH_SCENE = "S_526";
    ULStatisEventId.ADD_SHORTCUT = "S_527";
    ULStatisEventId.ADD_FAVORITES = "S_528";
    ULStatisEventId.NATIVE_ADV_DATA_UPLOAD_EVENT = "S_529";
    ULStatisEventId.CLICK_GAME_CLUB = "S_530";
    ULStatisEventId.FEEDBACK_AND_REPORT = "S_531";
    ULStatisEventId.CLOUD_STORAGE_REPORT = "S_532";
    ULStatisEventId.CLOUD_STORAGE_RESULT = "S_533";

    class ULStatisManager {
        constructor() {
            this.bUploading = false;
            this.lastTimerLoopTime = null;
            this.isGamePause = false;
            this.pointEventLog = {};
            this.pointEventCategoryId_2_enabled = null;
            this.gameStartDataPreparationFlags = {};
            this.commonEventLog = {};
            this.levelStartLog = {};
            this.levelCompletetLog = {};
            this.videoPointLog = {};
            this.buyActionLog = {};
            this.coinChangeLog = {};
            this._reportTimer = null;
            this._whiteUserCheck = false;
        }
        init() {
            this.channelInfoUuid = ULSdkManager.getInstance().channelInfo.uuid;
            this.megadataId = ULConfig.getConfig().s_sdk_megadata_server_type_id;
            this.loadRecord();
            ULTimer.callLoop(ULConfig.getConfig().i_sdk_megadata_upload_span / 1000, this.onTimerLoop.bind(this));
            this.startTimeReportTimer();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_START, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameStart.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_COP_CHANGED, ULConst.PRIORITY_NONE, this.onCmdSdkOnCopChanged.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, 9, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        loadRecord() {
            let oldRecord = ULStorageManager.getInstance().getStorage(this._getRecordKey());
            let newKey = ULTools.format("ULStatisManager_record_%s", ULConfig.getConfig().s_prj_id);
            if (oldRecord) {
                ULStorageManager.getInstance().setStorage(this._getRecordKey(), "");
                ULStorageManager.getInstance().setStorage(newKey, oldRecord);
            }
            let recordStr = ULStorageManager.getInstance().getStorage(newKey) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.cacheItems = record.cacheItems || [];
            let mode = record.postMegadataTestMode || 0;
            this.postMegadataTestUserId = record.postMegadataTestUserId;
            this.setPostMegadataMode(mode);
        }
        saveRecord() {
            let record = {
                cacheItems: this.cacheItems || [],
                postMegadataTestUserId: this.postMegadataTestUserId,
                postMegadataTestMode: this.postMegadataTestMode
            };
            let recordStr = JSON.stringify(record);
            let newKey = ULTools.format("ULStatisManager_record_%s", ULConfig.getConfig().s_prj_id);
            ULStorageManager.getInstance().setStorage(newKey, recordStr);
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULStatisManager_record_%d", config.s_sdk_megadata_game_id);
        }
        onTimerLoop(timer) {
            if (this.cacheItems.length <= 0) {
                return;
            }
            this.tryUploadToServer();
        }
        setPostMegadataMode(mode) {
            this.postMegadataTestMode = mode;
            this.saveRecord();
            if (!!this.postMegadataTestMode) {
                this.channelInfoUuid = this.postMegadataTestUserId;
                let debugInfo = "数据上传已开启测试模式\n测试用户id:" + this.postMegadataTestUserId;
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("postMegadataTestModeInfo", debugInfo);
            }
            else {
                this.channelInfoUuid = ULSdkManager.getInstance().channelInfo.uuid;
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("postMegadataTestModeInfo");
            }
        }
        getPostMegadataMode() {
            return this.postMegadataTestMode;
        }
        _report(typeid, updata) {
            let config = ULConfig.getConfig();
            let closeIds = config.s_sdk_megadata_close_table_type_ids || "";
            let closeIdsList = closeIds.split(";");
            for (let index = 0; index < closeIdsList.length; index++) {
                let closeId = ULTools.format("%s-%s", this.megadataId, closeIdsList[index]);
                if (closeId == typeid) {
                    ULLog.console.log("ULStatisManager._report 大数据分表控制表数据上传closeId:", closeId);
                    return;
                }
            }
            ULLog.console.log("ULStatisManager._report i_sdk_megadata_mode 1 ", config.i_sdk_megadata_mode);
            try {
                let otherItem = { typeid: typeid, updata: updata };
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_ON_REPORT_ULSDK_EVENT, {
                    parameter: otherItem
                });
            }
            catch (error) {
                ULLog.console.log("ULStatisManager.CMD_SDK_ON_REPORT_ULSDK_EVENT error:", error);
            }
            if (!config.i_sdk_megadata_mode) {
                ULLog.console.log("ULStatisManager._report !i_sdk_megadata_mode 关闭统计功能");
                return;
            }
            if (!!this.postMegadataTestMode) {
            }
            if (updata.length == 0) {
                ULLog.console.log("ULStatisManager._report !updata 无有效数据，无法上报:", updata);
                return;
            }
            for (let i = 0; i < updata.length; i++) {
                let v = updata[i];
                if (typeof (v) != "string") {
                    if (v == null) {
                        v = "";
                    }
                    else {
                        v = "" + v;
                    }
                }
                updata[i] = v;
            }
            let item = { typeid: typeid, updata: updata };
            this.cacheItems.push(item);
            if (this.cacheItems.length >= ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT) {
                this.tryUploadToServer();
            }
        }
        tryUploadToServer() {
            if (this.bUploading) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer 数据上传中");
                return;
            }
            let uploadCount = Math.min(this.cacheItems.length, ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT);
            if (uploadCount <= 0) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer 没有数据需要上传");
                return;
            }
            this.bUploading = true;
            let uploadItems = this.cacheItems.slice(0, uploadCount);
            this.cacheItems.splice(0, uploadCount);
            this.saveRecord();
            let config = ULConfig.getConfig();
            let url = config.s_sdk_megadata_url;
            if (!url) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer url为空");
                return;
            }
            url += "/batchdatauploadv8";
            let requestHeader = {
                gameId: config.s_prj_id,
                platform: "1"
            };
            if (!!this.postMegadataTestMode) {
                url = url.replace("/batchdatauploadv8", "/batchtestdatauploadv8");
                requestHeader.gameId = "1";
            }
            if (ULSdkManager.getInstance().channelInfo.isSupportMegadataEncrypt && !!config.i_sdk_megadata_encrypt) {
                ULTools.httpPostEncryption({
                    url: url,
                    postString: JSON.stringify(uploadItems),
                    timeoutMillisecond: config.i_net_timeout,
                    success: (responseText) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  加密统计上报成功!");
                        this.bUploading = false;
                    },
                    fail: (err) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  加密统计上报错误!", err);
                        this.cacheItems = uploadItems.concat(this.cacheItems);
                        this.saveRecord();
                        this.bUploading = false;
                    },
                    requestHeader: requestHeader
                });
                return;
            }
            let postData = "updata=" + JSON.stringify(uploadItems);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatisManager.tryUploadToServer");
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  url:", url);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  postData:", postData);
            postData = postData.replace(";", ",");
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报成功!");
                    this.bUploading = false;
                },
                fail: (err) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报错误!", err);
                    this.cacheItems = uploadItems.concat(this.cacheItems);
                    this.saveRecord();
                    this.bUploading = false;
                },
                requestHeader: requestHeader
            });
        }
        uploadToServerRightNow(typeid, updata) {
            let config = ULConfig.getConfig();
            let url = config.s_sdk_megadata_url;
            if (!config.i_sdk_megadata_mode) {
                ULLog.console.log("ULStatisManager.uploadToServerRightNow !i_sdk_megadata_mode 关闭统计功能");
                return;
            }
            url += "/batchdatauploadv8";
            let item = { typeid: typeid, updata: updata };
            let uploadItems = [];
            uploadItems.push(item);
            let requestHeader = {
                gameId: config.s_prj_id,
                platform: "1"
            };
            if (!!this.postMegadataTestMode) {
                url = url.replace("/batchdatauploadv8", "/batchtestdatauploadv8");
                requestHeader.gameId = "1";
            }
            if (ULSdkManager.getInstance().channelInfo.isSupportMegadataEncrypt && !!config.i_sdk_megadata_encrypt) {
                ULTools.httpPostEncryption({
                    url: url,
                    postString: JSON.stringify(uploadItems),
                    timeoutMillisecond: config.i_net_timeout,
                    success: (responseText) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  统计上报成功!");
                    },
                    fail: (err) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  统计上报错误!", err);
                    },
                    requestHeader: requestHeader
                });
                return;
            }
            let postData = "updata=" + JSON.stringify(uploadItems);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatisManager.uploadToServerRightNow");
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  url:", url);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  postData:", postData);
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报成功!");
                },
                fail: (err) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报错误!", err);
                },
                requestHeader: requestHeader
            });
        }
        genPointEventLog() {
            let rawLog = this.pointEventLog;
            let arr = [];
            let arr1 = [];
            ULTools.forEachMap(rawLog, (k, v) => {
                let eventId = parseInt(k);
                arr1.push({ eventId: eventId, v: v });
            });
            arr1 = ULTools.sortArrayByField(arr1, "eventId");
            for (let i = 0; i < arr1.length; i++) {
                const v = arr1[i];
                let arr2 = [];
                ULTools.forEachMap(v.v, (k, count) => {
                    let paramId = parseInt(k);
                    arr2.push({ paramId: paramId, count: count });
                });
                arr2 = ULTools.sortArrayByField(arr2, "paramId");
                for (let j = 0; j < arr2.length; j++) {
                    const vv = arr2[j];
                    arr.push(ULTools.format("%d-%d: %d", v.eventId, vv.paramId, vv.count));
                }
            }
            return arr;
        }
        getCommonEventLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.commonEventLog;
            ULLog.console.log("ULStatisManager.getCommonEventLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getLevelStartLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.levelStartLog;
            ULLog.console.log("ULStatisManager.getLevelStartLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getLevelCompletetLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.levelCompletetLog;
            ULLog.console.log("ULStatisManager.getLevelCompletetLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d   时长：%d", key, rawLog[key].count, rawLog[key].playTime));
            }
            return arr;
        }
        getVideoPointLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.videoPointLog;
            ULLog.console.log("ULStatisManager.getVideoPointLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getBuyActionLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.buyActionLog;
            ULLog.console.log("ULStatisManager.getBuyActionLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getCoinChangeLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.coinChangeLog;
            ULLog.console.log("ULStatisManager.coinChangeLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s  次数：%d   货币数量：%d", key, rawLog[key].count, rawLog[key].changeCount));
            }
            return arr;
        }
        isReady() {
            if (ULTools.getObjSize(this.gameStartDataPreparationFlags) <= 0)
                return true;
            return false;
        }
        getPreparationFlags() {
            let flags = [];
            ULTools.forEachMap(this.gameStartDataPreparationFlags, (k, v) => {
                flags.push(k);
            });
            return flags;
        }
        addPreparationFlag(key) {
            this.gameStartDataPreparationFlags[key] = true;
        }
        removePreparationFlag(key) {
            delete this.gameStartDataPreparationFlags[key];
        }
        setGameStartSourceMsg(param) {
            this.gameStartSourceMsg = param;
        }
        reportGameStart() {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_BASE_INFO;
            let updata = [];
            updata.push(this.gameStartTimeFormattedStr);
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push("");
            updata.push("");
            updata.push(config.s_game_name);
            updata.push(config.s_sdk_cop_game_id || config.s_prj_id);
            updata.push(channelInfo.appName);
            updata.push(config.s_sdk_cop_channel_id);
            updata.push(config.s_sdk_cop_version);
            updata.push(channelInfo.osVersionMessage || "");
            updata.push("gameStart");
            updata.push("");
            updata.push(config.s_sdk_version);
            updata.push(channelInfo.equipmentModel || "");
            updata.push(this.gameStartSourceMsg);
            updata.push(channelInfo.platformVersionMessage || "");
            updata.push("");
            updata.push("");
            updata.push("");
            this._report(typeid, updata);
        }
        reportPayRequest(payId, channelOrderId, sdkOrderId) {
            this.reportPayResult("", "", "requestPay", payId, channelOrderId, sdkOrderId);
        }
        reportPaySuccess(payType, priceCent, payId, channelOrderId, sdkOrderId) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "success", payId, channelOrderId, sdkOrderId);
        }
        reportPayCancel(payType, priceCent, payId, channelOrderId, sdkOrderId) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "cancel", payId, channelOrderId, sdkOrderId);
        }
        reportPayFail(payType, priceCent, payId, channelOrderId, sdkOrderId) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "failed", payId, channelOrderId, sdkOrderId);
        }
        reportPayResult(payType, price, result, payId, channelOrderId, sdkOrderId) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_PAY_INFO;
            let updata = [];
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push(channelInfo.channelName);
            updata.push(payType || "");
            updata.push(price || "");
            updata.push(result || "");
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            updata.push(payId || "");
            updata.push(channelOrderId || "");
            updata.push(sdkOrderId || "");
            this._report(typeid, updata);
        }
        reportAdvBranchRequest(advItem, channel, sdkAdvId) {
            advItem.statisChannelName = channel;
            advItem.statisSdkAdvId = sdkAdvId;
            this.reportAdvInfo(channel, advItem.showAdvType, "branchAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, "", sdkAdvId, "");
        }
        reportAdvTotalRequest(advItem) {
            this.reportAdvInfo("", advItem.advType, "totalAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, "", "", "");
        }
        reportAdvSuccess(advItem, nativeAdvTitle, actualShowCount = 1) {
            advItem.statisNativeAdTitle = nativeAdvTitle;
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "success", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "", actualShowCount.toString());
        }
        reportAdvClicked(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "clicked", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvPlayStart(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "playStart", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvPlayCompletion(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "playCompletion", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvRequest(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvSuccess(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvSuccess", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvFailed(advItem, failMsg) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvFailed", failMsg, advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvFail(advItem, failMsg) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "failed", failMsg, advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvClose(advItem, advShowTimeSec) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "hide", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, advShowTimeSec);
        }
        reportAdvInfo(channel, advType, result, failMsg, advGroupId, advId, advEventInfo, nativeAdvInfo, sdkAdvId, advShowTimeSec, actualShowCount = "") {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_ADV_INFO;
            let updata = [];
            if (nativeAdvInfo && nativeAdvInfo.length > 6) {
                nativeAdvInfo = nativeAdvInfo.substr(0, 6);
            }
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push(channel || "");
            updata.push(advType || "");
            updata.push(result || "");
            updata.push(failMsg || "");
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            updata.push(advGroupId || "");
            updata.push(advId || "");
            updata.push(advEventInfo || "");
            updata.push(nativeAdvInfo || "");
            updata.push(sdkAdvId || "");
            updata.push(advShowTimeSec || "");
            updata.push("");
            updata.push(actualShowCount);
            ULLog.console.log("reportAdvInfo result:", result);
            if (result == 'hide') {
                this.uploadToServerRightNow(typeid, updata);
            }
            else {
                this._report(typeid, updata);
            }
        }
        reportCopSuccess(responseJson) {
            this.reportCopResult("success", "", responseJson);
        }
        reportCopFail(failMsg) {
            this.reportCopResult("filed", failMsg, "");
        }
        reportCopResult(result, failMsg, responseJson) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_COP_REQUEST;
            let updata = [];
            responseJson = "";
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push("coprequest");
            updata.push(result || "");
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            updata.push(failMsg || "");
            updata.push(responseJson || "");
            this._report(typeid, updata);
        }
        reportUserEvent(rawData) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_USER_EVENT;
            let updata = [];
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            for (let i = 0; i < rawData.length; i++) {
                const v = rawData[i];
                updata.push(v);
            }
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            updata.push(channelInfo.channelName);
            this._report(typeid, updata);
        }
        reportUserChannelId(channelId) {
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_COMMON_EVENT;
            let updata = [];
            updata.push(ULStatisEventId.LOGIN_EVENT);
            updata.push("1");
            updata.push(channelId);
            updata.push("0");
            this.reportUserActionEvent(updata, typeid);
        }
        reportUserActionEvent(rawData, typeid) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let sdkIndexObj = {
                levelStart: [0, 1, 2, 5, 6, 7],
                levelComplete: [0, 1, 2, 11, 12, 13, 14],
                coinChange: [0, 1, 2, 7, 8, 9],
                itemBuy: [0, 1, 2, 6, 7, 8],
                buyAction: [0, 1, 2, 6, 7, 8],
                commonEvent: [0, 1, 2, 6, 7, 8],
                videoPointEvent: [0, 1, 2, 5, 6, 7,],
            };
            let sdkValue = [
                ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"),
                this.channelInfoUuid,
                "",
                config.s_sdk_cop_version,
                config.s_sdk_version,
                channelInfo.copChannelId
            ];
            let updata = [];
            if (typeid == ULConst.STATIS_TYPE_COMMON_EVENT) {
                try {
                    rawData.length > 0 && ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_COMMONEVENT_ID_POST, { commonEventId: rawData[0] });
                }
                catch (error) { }
                updata = this.rebuildData(sdkIndexObj.commonEvent, sdkValue, rawData);
                let key = rawData[0] + "-" + rawData[1];
                this.commonEventLog[key] = !!this.commonEventLog[key] ? (this.commonEventLog[key] + 1) : 1;
            }
            else if (typeid == ULConst.STATIS_TYPE_LEVEL_START_EVENT) {
                updata = this.rebuildData(sdkIndexObj.levelStart, sdkValue, rawData);
                let key = rawData[0];
                this.levelStartLog[key] = !!this.levelStartLog[key] ? (this.levelStartLog[key] + 1) : 1;
            }
            else if (typeid == ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT) {
                try {
                    if (rawData.length >= 2) {
                        let state = rawData[1] || "0";
                        if (state == "1") {
                            let levelName = rawData[0] || "";
                            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_LEVELCOMPLETEEVENT_ID_POST, { levelCompleteEventId: levelName });
                        }
                    }
                }
                catch (error) { }
                let key = rawData[0] + "-" + rawData[1];
                if (!this.levelCompletetLog[key]) {
                    this.levelCompletetLog[key] = { count: 0, playTime: 0 };
                }
                this.levelCompletetLog[key].count = !!this.levelCompletetLog[key].count ? (this.levelCompletetLog[key].count + 1) : 1;
                this.levelCompletetLog[key].playTime = !!this.levelCompletetLog[key].playTime ? (this.levelCompletetLog[key].playTime + parseInt(rawData[rawData.length - 1])) : parseInt(rawData[rawData.length - 1]);
                let time = rawData.pop();
                sdkValue.splice(3, 0, time);
                updata = this.rebuildData(sdkIndexObj.levelComplete, sdkValue, rawData);
            }
            else if (typeid == ULConst.STATIS_TYPE_VIDEO_POINT_EVENT) {
                updata = this.rebuildData(sdkIndexObj.videoPointEvent, sdkValue, rawData);
                let key = rawData[0] + "-" + rawData[1];
                this.videoPointLog[key] = !!this.videoPointLog[key] ? (this.videoPointLog[key] + 1) : 1;
            }
            else if (typeid == ULConst.STATIS_TYPE_BUY_ACTION) {
                updata = this.rebuildData(sdkIndexObj.buyAction, sdkValue, rawData);
                let key = rawData[0] + "-" + rawData[1] + "-" + rawData[2];
                this.buyActionLog[key] = !!this.buyActionLog[key] ? (this.buyActionLog[key] + 1) : 1;
            }
            else if (typeid == ULConst.STATIS_TYPE_COIN_CHANGE_EVENT) {
                updata = this.rebuildData(sdkIndexObj.coinChange, sdkValue, rawData);
                let key = rawData[0] + "-" + rawData[1] + "-" + rawData[3];
                if (!this.coinChangeLog[key]) {
                    this.coinChangeLog[key] = { count: 0, changeCount: 0 };
                }
                this.coinChangeLog[key].count = !!this.coinChangeLog[key].count ? (this.coinChangeLog[key].count + 1) : 1;
                this.coinChangeLog[key].changeCount = !!this.coinChangeLog[key].changeCount ? (this.coinChangeLog[key].changeCount + parseInt(rawData[2])) : parseInt(rawData[2]);
            }
            else if (typeid == ULConst.STATIS_TYPE_ITEM_BUY) {
                updata = this.rebuildData(sdkIndexObj.itemBuy, sdkValue, rawData);
            }
            this._report(typeid, updata);
        }
        rebuildData(sdkIndex, sdkValue, rawData) {
            let mSdkIndex = ULTools.clone(sdkIndex);
            let mSdkValue = ULTools.clone(sdkValue);
            let mRawData = ULTools.clone(rawData);
            let updata = [];
            while (mSdkValue.length || mRawData.length) {
                let index = mSdkIndex[0];
                if (index == updata.length) {
                    updata.push(mSdkValue.shift());
                    mSdkIndex.shift();
                }
                else if (mRawData.length) {
                    updata.push(mRawData.shift());
                }
                else {
                    updata.push("");
                }
            }
            return updata;
        }
        reportOnlineTime(onlineTimeSec) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_ONLINE_TIME;
            let updata = [];
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push(this.gameStartTimeFormattedStr || "");
            updata.push(onlineTimeSec.toString() || "0");
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            this.uploadToServerRightNow(typeid, updata);
        }
        reportShareSuccess(index) {
            let singleField = ["openShare", "success", index || 0].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.OPEN_SHARE, 1, index || 0]);
            }
        }
        reportShareFail(index) {
            let singleField = ["openShare", "fail", index || 0].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.OPEN_SHARE, 0, index || 0]);
            }
        }
        reportAppShare(index) {
            let singleField = ["openShare", "appShare", index || 0].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.OPEN_SHARE, 2, index || 0]);
            }
        }
        reportShareClick(queryMsg) {
            let singleField = ["clickShare", queryMsg || ""].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.CLICK_SHARE, queryMsg || "", ""]);
            }
        }
        reportAddSubcrible(code) {
            let singleField = ["addSubscrible", code || ""].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.ADD_SUBSCRIPTION, code || "", ""]);
            }
        }
        reportSubcribleClick(queryMsg) {
            let singleField = ["clickSubscrible", queryMsg || ""].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.CLICK_SUBSCRIPTION, queryMsg || "", ""]);
            }
        }
        reportClickMoreGameIcon(iconType, gameIndex) {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let eventId = ULStatisEventId.CLICK_MORE_GAME_ICON_LIST;
            if (iconType == "single") {
                eventId = ULStatisEventId.CLICK_MORE_GAME_ICON_SINGLE;
            }
            else if (iconType == "reward") {
                eventId = ULStatisEventId.CLICK_MORE_GAME_ICON_REWARD;
            }
            let megdataUrl = config.s_sdk_megadata_url || "";
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", eventId, gameIndex || "", ""]);
        }
        reportClickMoreGameButtonToChannelSystem() {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let eventId = ULStatisEventId.CLICK_MORE_GAME_CHANNEL_SYSTEM_BUTTON;
            let megdataUrl = config.s_sdk_megadata_url || "";
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", eventId, "", ""]);
        }
        reportOpenCdk(code) {
            let singleField = ["openCdk", code].join("_");
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            let megdataUrl = config.s_sdk_megadata_url || "";
            ULLog.console.log("ULStatisManager.reportOpenCdk code:", code);
            if (megdataUrl.indexOf(`megadata.${ULTools.getCommonHost()}.cn`) >= 0) {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_MEGADATA_SERVER, ["commonEvent", singleField]);
            }
            else {
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.CDK, code || 0, ""]);
            }
        }
        reportJumpGame(eventId, channel, sourceGameId, type, targetIconId) {
            let config = ULConfig.getConfig();
            let openIds = config.s_sdk_jump_game_statis_game_indexes || "";
            let openIdsList = openIds.split(";");
            let openStatus = {};
            for (let index = 0; index < openIdsList.length; index++) {
                openStatus[openIdsList[index]] = true;
            }
            let gameIndex = targetIconId.split("_")[0];
            if (!openStatus[gameIndex]) {
                ULLog.console.log("ULStatisManager.reportJumpGame 当前跳转的游戏数据上报没开,targetIconId:", targetIconId);
                return;
            }
            let typeid = config.s_sdk_megadata_server_jump_game_type_id;
            let updata = [];
            updata.push(eventId);
            updata.push(channel);
            updata.push(sourceGameId);
            updata.push(type);
            updata.push(targetIconId);
            this._report(typeid, updata);
        }
        reportToufang(aid, traceId) {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.WEIXIN_TOUFANG, aid, traceId]);
        }
        reportLaunchScene(scene) {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.LAUNCH_SCENE, scene, ""]);
        }
        reportCustomData(code, state = "", msg = "") {
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", code || "400", state || "", msg || ""]);
        }
        reportAddShortcut(code) {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", ULStatisEventId.ADD_SHORTCUT, code, ""]);
        }
        reportAddFavorites(code) {
            let config = ULConfig.getConfig();
            let sdkEventIds = config.t_sdk_common_event_ids || {};
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", sdkEventIds["add_favorites"] || "302", code, ""]);
        }
        _checkPointEventSwitch(eventId) {
            if (!this.pointEventCategoryId_2_enabled) {
                let config = ULConfig.getConfig();
                let arr = config['s_sdk_megadata_point_event_open_category_ids'].split(";");
                let pointEventCategoryId_2_enabled = {};
                for (let i = 0; i < arr.length; i++) {
                    const categoryId = arr[i];
                    pointEventCategoryId_2_enabled[categoryId] = true;
                }
                this.pointEventCategoryId_2_enabled = pointEventCategoryId_2_enabled;
            }
            let categoryId = Math.floor(eventId / 1000);
            return !!this.pointEventCategoryId_2_enabled[categoryId];
        }
        reportPointEvent(eventId, param1) {
            eventId = parseInt(eventId) || 0;
            if (isNaN(eventId))
                eventId = 0;
            eventId = ULTools.clampf(eventId, 0, 0xffff);
            param1 = parseInt(param1) || 0;
            if (isNaN(param1))
                param1 = 0;
            param1 = ULTools.clampf(param1, 0, 0xffff);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatisManager.reportPointEvent", eventId, param1);
            if (!this._checkPointEventSwitch(eventId)) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("  打点统计上报未开启：", ULConfig.getConfig()['s_sdk_megadata_point_event_open_category_ids']);
                return;
            }
            let shortUserId = "";
            let sdkUserId = ULSdkManager.getInstance().channelInfo._sdkUserId;
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log(ULTools.format("  sdkUserId = [%s]", sdkUserId));
            let reg = /(\d+)_(.*)_(\d+)/;
            if (reg.test(sdkUserId)) {
                shortUserId = RegExp.$2;
                if (!shortUserId || shortUserId.length != 22) {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  核心长度不匹配，直接使用sdkUserId");
                    shortUserId = sdkUserId;
                }
                else {
                    shortUserId = shortUserId.substr(2, shortUserId.length - 2);
                }
            }
            else {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("  userId规则不匹配，直接使用sdkUserId");
                shortUserId = sdkUserId;
            }
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log(ULTools.format("  shortUserId = [%s]", shortUserId));
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULConst.STATIS_TYPE_POINT_EVENT;
            let updata = [];
            updata.push(shortUserId);
            updata.push(config.s_sdk_cop_channel_id);
            updata.push(eventId.toString());
            updata.push(param1.toString());
            this._report(typeid, updata);
            let log = this.pointEventLog;
            let v = log[eventId];
            if (!v) {
                v = {};
                log[eventId] = v;
            }
            v[param1] = (v[param1] || 0) + 1;
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  log", log);
        }
        startTimeReportTimer() {
            let config0 = ULConfig.getConfig();
            let reportInterval = config0.n_sdk_common_online_time_report_looper_interval;
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatiManager.startTimeReportTimer", reportInterval);
            if (this._reportTimer) {
                clearInterval(this._reportTimer);
                this._reportTimer = undefined;
            }
            let self = this;
            this._reportTimer = setInterval(() => {
                if (!self.isGamePause) {
                    let onlineTime = ULTools.time() - self.gameLastResumeTime;
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.info("ULStatiManager.startTimeReportTimer,timer前台上报一次在线时长", onlineTime);
                    if (onlineTime <= 5 || onlineTime > 3600 * 24)
                        return;
                    self.gameLastResumeTime = ULTools.time();
                    self.reportOnlineTime(Math.floor(onlineTime));
                    let config = ULConfig.getConfig();
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [config['s_sdk_miniplay_user_play_game_time_event_id'] || "", Math.floor(onlineTime)]);
                    self.saveRecord();
                }
            }, 1000 * reportInterval);
        }
        onCmdSdkOnGameStart(e) {
            this.isGamePause = false;
            this.gameStartTimeFormattedStr = ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss");
            this.gameLastResumeTime = ULTools.time();
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatiManager.onCmdSdkOnGameStart", this.gameStartTimeFormattedStr, this.gameLastResumeTime);
            if (this.isReady()) {
                this.reportGameStart();
                this.tryUploadToServer();
                return;
            }
            let flags = this.getPreparationFlags();
            ULLog.console.log("ULStatiManager.onCmdSdkOnGameStart 上报数据没有准备好,flags:", flags.join(","));
            let timeout = ULConfig.getConfig().i_game_start_ready_timeout / 1000;
            ULTimer.callLoop(1 / 60, (timer) => {
                if (timer.usedTime >= timeout) {
                    timer.stop();
                    let flags = this.getPreparationFlags();
                    ULLog.console.log("ULStatiManager.onCmdSdkOnGameStart 等待超时！直接触发reportGameStart flags:", flags.join(","));
                    this.reportGameStart();
                    this.tryUploadToServer();
                    return;
                }
                if (this.isReady()) {
                    timer.stop();
                    ULLog.console.log("ULStatiManager.onCmdSdkOnGameStart 准备完毕！触发reportGameStart");
                    this.reportGameStart();
                    this.tryUploadToServer();
                    return;
                }
            });
        }
        onCmdSdkOnGamePause(e) {
            this.isGamePause = true;
            if (!this.gameLastResumeTime) {
                ULLog.console.warn("ULStatiManager.onCmdSdkOnGamePause gameLastResumeTime not found! 无法上报在线时间");
                return;
            }
            let onlineTime = ULTools.time() - this.gameLastResumeTime;
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatiManager.onCmdSdkOnGamePause", onlineTime);
            if (onlineTime <= 5 || onlineTime > 3600 * 24)
                return;
            this.gameLastResumeTime = ULTools.time();
            this.reportOnlineTime(Math.floor(onlineTime));
            let config = ULConfig.getConfig();
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [config['s_sdk_miniplay_user_play_game_time_event_id'] || "", Math.floor(onlineTime)]);
            this.saveRecord();
        }
        onCmdSdkOnGameResume(e) {
            this.isGamePause = false;
            this.gameLastResumeTime = ULTools.time();
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatiManager.onCmdSdkOnGameResume", this.gameLastResumeTime);
        }
        onCmdSdkOnCopChanged(e) {
            this.pointEventCategoryId_2_enabled = null;
            this.startTimeReportTimer();
        }
        get whiteUserCheck() {
            return this._whiteUserCheck;
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let self = this;
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            let postDataModeLabelDescList = ["正式模式", "测试模式"];
            let postDataModeLabelDesc = "当前数据上传模式:" + postDataModeLabelDescList[this.postMegadataTestMode];
            config.push({ type: "label", text: postDataModeLabelDesc, name: "labelPostDataMode" });
            config.push({
                type: "button",
                text: "切换数据上传模式..",
                onClick: () => {
                    let userId = ULSdkManager.getInstance().moduleCheckerManager.getItemText("labelPostTestModeUserId");
                    let conf1 = [];
                    conf1.push({ text: "测试模式 ( 用户id:" + userId + ")", value: 1 });
                    conf1.push({ text: "正式模式", value: 0 });
                    let fOnSelectCity = (isTestmode) => {
                        let postDataModeLabelDesc = "当前数据上传模式:" + postDataModeLabelDescList[this.postMegadataTestMode];
                        if (!!isTestmode) {
                            if (userId.length < 1) {
                                ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("提示", "请设置测试用户id", "好的");
                                return;
                            }
                            this.postMegadataTestUserId = userId;
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已开启测试模式");
                        }
                        else {
                            this.postMegadataTestUserId = null;
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("测试模式已关闭");
                        }
                        this.setPostMegadataMode(isTestmode);
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelPostDataMode", postDataModeLabelDesc);
                    };
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("切换数据上传模式:", conf1, fOnSelectCity);
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: "测试用户id",
            });
            config.push({
                type: "inputBox",
                text: this.postMegadataTestUserId,
                name: "labelPostTestModeUserId"
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: `UUID: ${ULSdkManager.getInstance().channelInfo._sdkUserId}  ` });
            config.push({
                type: "button",
                text: "复制",
                onClick: () => {
                    let userId = ULSdkManager.getInstance().channelInfo._sdkUserId;
                    ULClipboardManager.getInstance().setClipboardData(userId, (bSuccess) => {
                        if (bSuccess) {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "复制成功", "知道了", () => {
                            });
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "复制失败", "知道了", () => {
                            });
                        }
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: `渠道openId:      ` });
            config.push({
                type: "button",
                text: "请求",
                onClick: () => {
                    let callback = (openId, msg) => {
                        if (!!openId) {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "获取成功\n" + openId, "复制", () => {
                                ULClipboardManager.getInstance().setClipboardData(openId, (bSuccess) => {
                                    if (bSuccess) {
                                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "复制成功", "知道了", () => {
                                        });
                                    }
                                    else {
                                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "复制失败", "知道了", () => {
                                        });
                                    }
                                });
                            });
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "获取失败\n" + msg, "知道了", () => {
                            });
                        }
                    };
                    let getChannelOpenIdFunc = ULSdkManager.getInstance().channelInfo.getChannelOpenIdFunc;
                    if (!!getChannelOpenIdFunc) {
                        ULLog.console.log("ULStatisManager.getOpenId getChannelOpenIdFunc");
                        getChannelOpenIdFunc((openId, err) => {
                            ULLog.console.log("ULStatisManager.getOpenId getChannelOpenIdFunc callback");
                            callback(openId, err);
                        });
                    }
                    else {
                        ULLog.console.log("ULStatisManager.getOpenId 该渠道暂不支持获取openId");
                        callback(null, "该渠道暂不支持获取openId");
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "游戏金手指:      " });
            config.push({
                type: "button",
                text: "验证",
                onClick: () => {
                    let callback = (isCheck, msg) => {
                        self._whiteUserCheck = isCheck;
                        if (isCheck) {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "验证通过", "知道了", () => {
                                ULSdkManager.getInstance().response(ULConst.CMD_CHECKDEBUG_WHITEUSER_RESULT, {
                                    code: 1,
                                    isWhiteUser: true,
                                    msg: "当前用户是白名单用户"
                                });
                            });
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "验证失败\n" + msg, "知道了", () => {
                            });
                        }
                    };
                    if (ULSdkModuleLoader.getObjectByModuleName("ULModuleUlsdkDemo")) {
                        ULLog.console.log("ULModuleUlsdkDemo is Exit");
                        callback(true, "ULModuleUlsdkDemo is Exit");
                        return;
                    }
                    let networkCallback = (openId) => {
                        let config = ULConfig.getConfig();
                        let gameId = config.s_prj_id;
                        let channelId = config.s_sdk_cop_channel_id;
                        let userId = ULSdkManager.getInstance().channelInfo._sdkUserId;
                        let netTimeout = config.i_net_timeout;
                        let url = `${config['s_sdk_white_user_check_url']}?gameId=${gameId}&userId=${userId}&openId=${openId}&channelId=${channelId}&platform=H5&userName=`;
                        ULTools.httpGet({
                            url: url,
                            timeoutMillisecond: netTimeout,
                            success: (responseText) => {
                                let jsonData = null;
                                try {
                                    jsonData = JSON.parse(responseText);
                                }
                                catch (error) {
                                    jsonData = {
                                        code: 0,
                                        msg: "responseText"
                                    };
                                }
                                let code = jsonData.code || 0;
                                let msg = jsonData.msg || "位置错误";
                                callback(code == 1, msg);
                            },
                            fail: (err) => {
                                callback(false, JSON.stringify(err));
                            }
                        });
                    };
                    let getChannelOpenIdFunc = ULSdkManager.getInstance().channelInfo.getChannelOpenIdFunc;
                    if (!!getChannelOpenIdFunc) {
                        ULLog.console.log("ULStatisManager.getOpenId getChannelOpenIdFunc");
                        getChannelOpenIdFunc((openId, err) => {
                            ULLog.console.log("ULStatisManager.getOpenId getChannelOpenIdFunc callback err:", err);
                            networkCallback(openId);
                        });
                    }
                    else {
                        ULLog.console.log("ULStatisManager.getOpenId 该渠道暂不支持获取openId");
                        networkCallback("");
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "广告直接发奖:      " });
            config.push({ type: "newLine" });
            config.push({
                type: "button",
                text: "开启",
                onClick: () => {
                    if (!self._whiteUserCheck) {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "请先验证并通过白名单校验", "知道了", () => {
                        });
                    }
                    else {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "广告直接发奖已开启", "知道了", () => {
                            ULSdkManager.getInstance().advManager.isReturnSuccess = true;
                        });
                    }
                },
            });
            config.push({
                type: "button",
                text: "关闭",
                onClick: () => {
                    if (!self._whiteUserCheck) {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "请先验证并通过白名单校验", "知道了", () => { });
                    }
                    else {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "广告直接发奖已关闭", "知道了", () => {
                            ULSdkManager.getInstance().advManager.isReturnSuccess = false;
                        });
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "清理游戏存档:      " });
            config.push({
                type: "button",
                text: "清理游戏存档",
                onClick: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_CLEAN_UP_GAME_ARCHIVE, {});
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "跳过新手引导:      " });
            config.push({
                type: "button",
                text: "跳过新手引导",
                onClick: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_NEW_USER_GUIDE, {});
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "验证渠道域名白名单:      " });
            config.push({
                type: "button",
                text: "验证",
                onClick: () => {
                    let config = ULConfig.getConfig();
                    let requests = [];
                    Object.keys(config).forEach(key => {
                        let value = config[key];
                        if (typeof (value) == "string") {
                            value = value.trim();
                            if (ULTools.startsWith(value, "http")) {
                                let url = ULTools.parseUrl(value);
                                let hostUrl = url.protocol + "//" + url.host;
                                if (requests.indexOf(hostUrl) == -1) {
                                    requests.push(hostUrl);
                                }
                            }
                        }
                    });
                    if (requests.length > 0) {
                        let requestFun = (url) => {
                            return new Promise(resolve => {
                                let xhr = new XMLHttpRequest();
                                xhr.onreadystatechange = function (e) {
                                    if (!xhr)
                                        return;
                                    if (xhr.readyState == 4) {
                                        resolve({
                                            url: url,
                                            result: ""
                                        });
                                    }
                                };
                                xhr.onerror = function (e) {
                                    resolve({
                                        url: url,
                                        result: JSON.stringify(e)
                                    });
                                };
                                xhr.open('get', url);
                                xhr.send();
                            });
                        };
                        let promises = [];
                        requests.forEach(element => {
                            let requestPromise = requestFun(element);
                            promises.push(requestPromise);
                        });
                        ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("校验中，请稍后......");
                        Promise.all(promises)
                            .then(results => {
                            if (results) {
                                ULLog.console.log("ULStatisManager-校验域名白名单：", results);
                                let resultArray = results.filter(item => {
                                    return !!item.result;
                                });
                                if (resultArray && resultArray.length > 0) {
                                    let conf = [];
                                    resultArray.forEach(item => {
                                        conf.push({ text: item.url, value: { v: item.result } });
                                    });
                                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("域名访问错误项：", conf, (value) => {
                                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("错误信息", value.v, "关闭", null);
                                    }, true);
                                }
                                else {
                                    ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "校验通过", "确认", () => {
                                    });
                                }
                            }
                        });
                    }
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "是否显示客户端打点信息界面开关:      " });
            config.push({ type: "newLine" });
            config.push({
                type: "button",
                text: "打开",
                onClick: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_SHOW_POINT_DEBUG_INFO, { state: 1 });
                },
            });
            config.push({
                type: "button",
                text: "关闭",
                onClick: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_SHOW_POINT_DEBUG_INFO, { state: 0 });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "打点统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.genPointEventLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("打点统计记录(事件id-状态：次数)：", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "自定义统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getCommonEventLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("自定义统计记录(事件id-状态：次数)：", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "关卡开始统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getLevelStartLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("关卡开始统计记录(关卡名：次数):", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "关卡结束统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getLevelCompletetLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("关卡结束统计记录(关卡名-结果-次数):", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "视频埋点转化统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getVideoPointLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("视频埋点转化统计记录(视频点-状态：次数)", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "内购行为统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getBuyActionLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("内购行为统计记录(弹出理由-商品名-结果)", conf, () => { }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "货币统计记录:      " });
            config.push({
                type: "button",
                text: "点击查看..",
                onClick: () => {
                    let log = this.getCoinChangeLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const line = log[i];
                        conf.push({ text: line, value: line });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("货币统计记录(货币名称-变化类型-变化原因)", conf, () => { }, true);
                },
            });
            e.setReturnValue(config, true);
        }
        reportOpenJumpGame(eventId, game) {
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", eventId, game, ""]);
        }
    }

    class MCItem {
        initByData(data) {
            this.type = data.type;
            this.type = data.type || "newLine";
            this.name = data.name || "";
            this.text = data.text || "";
            this.width = data.width || 0;
            this.height = data.height || 0;
            this.fOnClick = data.onClick;
            this.fOnTextChanged = data.onTextChanged;
        }
        setText(text) {
            this.text = text;
            if (this.fOnTextChanged instanceof Function) {
                this.fOnTextChanged(text);
            }
        }
        triggerOnClick() {
            if (this.fOnClick instanceof Function) {
                this.fOnClick();
            }
        }
    }

    const BUTTON_WIDTH = 150;
    const BUTTON_HEIGHT = 40;
    const NEW_LINE_HEIGHT = 20;
    const FONT_SIZE = 20;
    const PENDING = 10;
    const GAP = 4;
    let _cc = window["cc"];
    class MCPanelCreator {
        constructor() {
            this.nodeReferenceRects = {};
            this.debugInfoRenderNode = null;
        }
        getNodeCanvas() {
            if (!_cc) {
                ULLog.console.warn("MCPanelCreator.getNodeCanvas 未检测到creator环境！");
                return null;
            }
            let scene = _cc.director.getScene();
            if (!scene) {
                ULLog.console.warn("MCPanelCreator.getNodeCanvas scene not found!");
                return null;
            }
            let check = ULConfig.getConfig().s_sdk_cocos2x_rootNode_check;
            if (check) {
                let nodeCanvas = ULEvalExp.evalExpResults(check, (key) => {
                    if (key == "scene") {
                        return scene;
                    }
                    return null;
                });
                ULLog.console.log("MCPanelCreator.getNodeCanvas nodeCanvas ==" + nodeCanvas);
                return nodeCanvas;
            }
            else {
                let nodeCanvas = scene.getChildByName("Canvas");
                ULLog.console.log("MCPanelCreator.getNodeCanvas nodeCanvas ==" + nodeCanvas);
                return nodeCanvas;
            }
        }
        addFillerSprite(node, color) {
            let size = node.getContentSize();
            let sprite = node.addComponent(_cc.Sprite);
            sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
            sprite.type = _cc.Sprite.Type.SIMPLE;
            _cc.loader.loadRes("_ulsdk_ui/white_dot", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.addFillerSprite err!", err);
                    return;
                }
                sprite.spriteFrame = spriteFrame;
                node.setContentSize(size);
            });
            node.color = color;
            node.opacity = color.getA();
        }
        registerTouchHandler(_node, handler, bEnableMultiTouch = false, bStopPropagation = true, bUseCapture = false) {
            let node = _node;
            if (!node)
                return;
            if (!handler)
                return;
            let fOnTouchBegan = (e) => {
                let touchId = e.getID() || 0;
                if (!bEnableMultiTouch && node.__touch_id != null)
                    return false;
                e.name = "began";
                if (bStopPropagation)
                    e.stopPropagation();
                node.__touch_id = touchId;
                handler(e);
                return true;
            };
            let fOnTouchMoved = (e) => {
                let touchId = e.getID() || 0;
                if (!bEnableMultiTouch && touchId != node.__touch_id)
                    return;
                e.name = "moved";
                handler(e);
            };
            let fOnTouchEnded = (e) => {
                let touchId = e.getID() || 0;
                if (!bEnableMultiTouch && touchId != node.__touch_id)
                    return;
                e.name = "ended";
                node.__touch_id = null;
                handler(e);
            };
            let fOnTouchCancelled = (e) => {
                let touchId = e.getID() || 0;
                if (!bEnableMultiTouch && touchId != node.__touch_id)
                    return;
                e.name = "cancelled";
                node.__touch_id = null;
                handler(e);
            };
            node.on(_cc.Node.EventType.TOUCH_START, fOnTouchBegan, null, bUseCapture);
            node.on(_cc.Node.EventType.TOUCH_MOVE, fOnTouchMoved, null, bUseCapture);
            node.on(_cc.Node.EventType.TOUCH_END, fOnTouchEnded, null, bUseCapture);
            node.on(_cc.Node.EventType.TOUCH_CANCEL, fOnTouchCancelled, null, bUseCapture);
        }
        isTouchEventClick(e) {
            if (!(e.name == "ended" || e.name == "cancelled"))
                return false;
            let p0 = e.getStartLocation();
            let p1 = e.getLocation();
            let dx = p0.x - p1.x;
            let dy = p0.y - p1.y;
            let distanceSq = dx * dx + dy * dy;
            return distanceSq <= 20 * 20;
        }
        createItemByData(data) {
            let item = new MCItem();
            item.initByData(data);
            let nodeContainer = this.nodeContainer;
            switch (data.type) {
                case "label": {
                    let node = new _cc.Node();
                    node.parent = nodeContainer;
                    node.setAnchorPoint(0.5, 0.5);
                    node.on(_cc.Node.EventType.SIZE_CHANGED, () => {
                        item.width = node.width;
                        item.height = node.height;
                        this.onItemNodeResize();
                    });
                    node.addComponent(_cc.Label).string = item.text;
                    node.getComponent(_cc.Label).fontSize = FONT_SIZE;
                    node.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                    node.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                    item.renderNode = node;
                    break;
                }
                case "labelArea": {
                    let node = new _cc.Node();
                    node.parent = nodeContainer;
                    node.setAnchorPoint(0.5, 0.5);
                    node.on(_cc.Node.EventType.SIZE_CHANGED, () => {
                        item.width = node.width;
                        item.height = node.height;
                        this.onItemNodeResize();
                    });
                    node.addComponent(_cc.Label).string = item.text;
                    node.getComponent(_cc.Label).fontSize = FONT_SIZE;
                    node.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                    node.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                    node.getComponent(_cc.Label).overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
                    node.width = nodeContainer.width - PENDING * 2;
                    node.height = FONT_SIZE;
                    item.renderNode = node;
                    break;
                }
                case "button": {
                    let node = new _cc.Node();
                    node.parent = nodeContainer;
                    node.on(_cc.Node.EventType.SIZE_CHANGED, () => {
                        item.width = node.width;
                        item.height = node.height;
                        this.onItemNodeResize();
                    });
                    node.width = item.width || BUTTON_WIDTH;
                    node.height = item.height || BUTTON_HEIGHT;
                    let nodeBg = new _cc.Node();
                    nodeBg.parent = node;
                    nodeBg.setContentSize(nodeBg.parent.getContentSize());
                    this.addFillerSprite(nodeBg, _cc.color(200, 200, 200, 255));
                    let nodeLabel = new _cc.Node();
                    nodeLabel.parent = node;
                    nodeLabel.setAnchorPoint(0.5, 0.5);
                    nodeLabel.addComponent(_cc.Label).string = item.text;
                    nodeLabel.getComponent(_cc.Label).fontSize = FONT_SIZE;
                    nodeLabel.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                    nodeLabel.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                    nodeLabel.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                    nodeLabel.width = node.width;
                    nodeLabel.height = node.height;
                    nodeLabel.color = _cc.Color.BLACK;
                    this.registerTouchHandler(node, (e) => {
                        switch (e.name) {
                            case "began":
                                nodeLabel.color = _cc.Color.GREEN;
                                break;
                            case "moved": break;
                            default:
                                nodeLabel.color = _cc.Color.BLACK;
                                break;
                        }
                        if (!this.isTouchEventClick(e))
                            return;
                        item.triggerOnClick();
                    });
                    item.renderNode = node;
                    break;
                }
                case "inputBox": {
                    let node = new _cc.Node();
                    node.parent = nodeContainer;
                    node.on(_cc.Node.EventType.SIZE_CHANGED, () => {
                        item.width = node.width;
                        item.height = node.height;
                        this.onItemNodeResize();
                    });
                    node.width = item.width || BUTTON_WIDTH;
                    node.height = item.height || BUTTON_HEIGHT;
                    let nodeBg = new _cc.Node();
                    nodeBg.parent = node;
                    nodeBg.setContentSize(nodeBg.parent.getContentSize());
                    this.addFillerSprite(nodeBg, _cc.color(200, 200, 200, 255));
                    let editBox = node.addComponent(_cc.EditBox);
                    editBox.fontSize = FONT_SIZE;
                    editBox.fontColor = _cc.Color.BLACK;
                    editBox.lineHeight = node.height;
                    editBox.inputMode = _cc.EditBox.InputMode.SINGLE_LINE;
                    editBox.maxLength = 1024;
                    editBox.placeholder = "<<输入框>>";
                    editBox.placeholderFontSize = FONT_SIZE;
                    editBox.placeholderFontColor = _cc.Color.GRAY;
                    let labels = node.getComponentsInChildren(_cc.Label);
                    for (let i = 0; i < labels.length; i++) {
                        const label = labels[i];
                        label.verticalAlign = _cc.Label.VerticalAlign.CENTER;
                    }
                    editBox.node.on("text-changed", () => {
                        let text = editBox.string;
                        item.setText(text);
                    });
                    item.renderNode = node;
                    break;
                }
                case "newLine": {
                    item.width = nodeContainer.width - PENDING * 2;
                    item.height = NEW_LINE_HEIGHT;
                    break;
                }
            }
            return item;
        }
        doLayout() {
            if (!this.items)
                return;
            let width = this.nodePanel.width - 20;
            let rowItems = [];
            let rowRight = PENDING;
            let rowTop = -PENDING;
            let rowHeight = 0;
            for (let i = 0; i < this.items.length; i++) {
                let item = this.items[i];
                let renderNode = item.renderNode || { x: 0, y: 0 };
                if (rowRight + item.width > width) {
                    rowRight = 0;
                    for (let i = 0; i < rowItems.length; i++) {
                        const rowItem = rowItems[i];
                        let renderNode = rowItem.renderNode || { x: 0, y: 0 };
                        renderNode.y = rowTop - rowHeight / 2;
                    }
                    rowRight = PENDING;
                    rowTop -= rowHeight + GAP;
                    rowItems = [];
                    rowHeight = 0;
                }
                rowHeight = Math.max(rowHeight, item.height);
                rowItems.push(item);
                renderNode.x = rowRight + item.width / 2;
                rowRight += item.width + GAP;
            }
            for (let i = 0; i < rowItems.length; i++) {
                const rowItem = rowItems[i];
                let renderNode = rowItem.renderNode || { x: 0, y: 0 };
                renderNode.y = rowTop - rowHeight / 2;
            }
            rowTop -= rowHeight - PENDING;
            this.nodeContainer.height = Math.max(this.nodePanel.height, -rowTop);
        }
        onItemNodeResize() {
            this.doLayout();
        }
        getItemByName(name) {
            for (let i = 0; i < this.items.length; i++) {
                const item = this.items[i];
                if (item.name == name)
                    return item;
            }
            return null;
        }
        show(config) {
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas)
                return;
            let nodePanel = new _cc.Node();
            nodePanel.parent = nodeCanvas;
            nodePanel.setContentSize(nodeCanvas.getContentSize());
            nodePanel.zIndex = _cc.macro.MAX_ZINDEX;
            this.nodePanel = nodePanel;
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodePanel;
            nodeBg.setContentSize(nodeBg.parent.getContentSize());
            this.addFillerSprite(nodeBg, _cc.color(0, 0, 0, 191));
            this.registerTouchHandler(this.nodePanel, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
            });
            let nodeContainer = new _cc.Node();
            nodeContainer.setAnchorPoint(0, 1);
            nodeContainer.parent = this.nodePanel;
            nodeContainer.setContentSize(nodeCanvas.getContentSize());
            this.nodeContainer = nodeContainer;
            let scrollView = this.nodePanel.addComponent(_cc.ScrollView);
            scrollView.horizontal = false;
            scrollView.vertical = true;
            scrollView.content = nodeContainer;
            scrollView.cancelInnerEvents = false;
            scrollView.elastic = true;
            let items = [];
            for (let i = 0; i < config.length; i++) {
                const data = config[i];
                let item = this.createItemByData(data);
                items.push(item);
            }
            this.items = items;
            this.doLayout();
        }
        close() {
            if (_cc.isValid(this.nodePanel)) {
                this.nodePanel.destroy();
            }
            this.nodePanel = null;
            this.items = [];
        }
        getItemText(name) {
            let item = this.getItemByName(name);
            if (!item)
                return "";
            return item.text;
        }
        setItemText(name, text) {
            let item = this.getItemByName(name);
            if (!item)
                return;
            item.setText(text);
            let node = item.renderNode;
            if (node instanceof _cc.Node) {
                let label = node.getComponent(_cc.Label) || node.getComponentInChildren(_cc.Label);
                if (label) {
                    label.string = text;
                }
                let editBox = node.getComponent(_cc.EditBox) || node.getComponentInChildren(_cc.EditBox);
                if (editBox) {
                    editBox.string = text;
                }
            }
        }
        showMsgTip(text) {
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas)
                return;
            let nodeLabel = new _cc.Node();
            nodeLabel.parent = nodeCanvas;
            nodeLabel.width = nodeCanvas.width;
            nodeLabel.height = 20;
            nodeLabel.zIndex = _cc.macro.MAX_ZINDEX;
            let label = nodeLabel.addComponent(_cc.Label);
            label.string = text;
            label.fontSize = 20;
            label.enableWrapText = true;
            nodeLabel.x = 0;
            nodeLabel.y = nodeCanvas.height * 0.25;
            nodeLabel.runAction(_cc.sequence(_cc.moveBy(1.5, 0, 50), _cc.callFunc(() => {
                nodeLabel.destroy();
            })));
        }
        showPickerDialog(title, conf, callback, bKeepDialogOpen) {
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas)
                return;
            let minCount = 8.5;
            let maxCount = 17.5;
            let dialogHeight = ULTools.scaleInRange(conf.length, minCount, maxCount, minCount * 40 + (minCount - 1) * 4 + 60, maxCount * 40 + (maxCount - 1) * 4 + 60);
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeCanvas;
            nodeShadow.setContentSize(nodeCanvas.getContentSize());
            nodeShadow.zIndex = _cc.macro.MAX_ZINDEX;
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                nodeShadow.destroy();
            });
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeShadow;
            nodeBg.setContentSize(nodeBg.parent.getContentSize());
            this.addFillerSprite(nodeBg, _cc.color(0, 0, 0, 127));
            let nodeDialog = new _cc.Node();
            nodeDialog.parent = nodeShadow;
            nodeDialog.width = nodeCanvas.width - 100;
            nodeDialog.height = dialogHeight;
            this.registerTouchHandler(nodeDialog, (e) => { });
            nodeBg = new _cc.Node();
            nodeBg.parent = nodeDialog;
            nodeBg.setContentSize(nodeBg.parent.getContentSize());
            this.addFillerSprite(nodeBg, _cc.color(167, 167, 167, 255));
            let nodeTitle = new _cc.Node();
            nodeTitle.parent = nodeDialog;
            nodeTitle.y = nodeDialog.height / 2 - 25;
            nodeTitle.x = 0;
            nodeTitle.addComponent(_cc.Label).string = title;
            nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).fontSize = 40;
            nodeTitle.width = nodeDialog.width - 10;
            nodeTitle.height = 40;
            let nodeListBg = new _cc.Node();
            nodeListBg.parent = nodeDialog;
            nodeListBg.width = nodeDialog.width - 10;
            nodeListBg.height = nodeDialog.height - 50;
            nodeListBg.x = 0;
            nodeListBg.y = -nodeDialog.height / 2 + nodeListBg.height / 2 + 5;
            this.addFillerSprite(nodeListBg, _cc.color(97, 97, 97, 255));
            let nodeList = new _cc.Node();
            nodeList.parent = nodeDialog;
            nodeList.width = nodeDialog.width - 10;
            nodeList.height = nodeDialog.height - 50;
            nodeList.x = 0;
            nodeList.y = -nodeDialog.height / 2 + nodeList.height / 2 + 5;
            nodeList.addComponent(_cc.Mask);
            let nodeContainer = new _cc.Node();
            nodeContainer.setAnchorPoint(0, 1);
            nodeContainer.parent = nodeList;
            nodeContainer.setContentSize(nodeList.getContentSize());
            let scrollView = nodeList.addComponent(_cc.ScrollView);
            scrollView.horizontal = false;
            scrollView.vertical = true;
            scrollView.content = nodeContainer;
            scrollView.cancelInnerEvents = false;
            scrollView.elastic = true;
            let y = 0;
            for (let i = 0; i < conf.length; i++) {
                const v = conf[i];
                let nodeItem = new _cc.Node();
                nodeItem.parent = nodeContainer;
                nodeItem.width = nodeList.width;
                nodeItem.height = 40;
                nodeItem.x = nodeContainer.width / 2;
                nodeItem.y = y - nodeItem.height / 2;
                let nodeBg = new _cc.Node();
                nodeBg.parent = nodeItem;
                nodeBg.setContentSize(nodeBg.parent.getContentSize());
                this.addFillerSprite(nodeBg, _cc.color(0, 0, 0, 63));
                let nodeLabel = new _cc.Node();
                nodeLabel.parent = nodeItem;
                nodeLabel.setAnchorPoint(0, 0.5);
                nodeLabel.x = -nodeItem.width / 2 + 5;
                nodeLabel.y = 0;
                let label = nodeLabel.addComponent(_cc.Label);
                label.fontSize = FONT_SIZE;
                label.lineHeight = FONT_SIZE;
                label.verticalAlign = _cc.Label.VerticalAlign.CENTER;
                label.horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                label.string = v.text;
                this.registerTouchHandler(nodeItem, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    callback(v.value);
                    if (!bKeepDialogOpen) {
                        nodeShadow.destroy();
                    }
                });
                y -= nodeItem.height + 4;
            }
            nodeContainer.height = Math.max(nodeList.height, -y);
        }
        showPromptDialog(title, content, btnTexts, callbacks, other) {
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showPromptDialog nodeCanvas not found!");
                ULTimer.callLater(0.1, () => {
                    this.showPromptDialog(title, content, btnTexts, callbacks, other);
                });
                return;
            }
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeCanvas;
            nodeShadow.setContentSize(nodeCanvas.getContentSize());
            nodeShadow.zIndex = _cc.macro.MAX_ZINDEX;
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("click bg");
            });
            let nodeSpriteBg = new _cc.Node();
            nodeSpriteBg.parent = nodeShadow;
            nodeSpriteBg.setContentSize(nodeSpriteBg.parent.getContentSize());
            this.addFillerSprite(nodeSpriteBg, _cc.color(0, 0, 0, 127));
            let bManualDestroy = false;
            let triggerNode = new _cc.Node();
            triggerNode.parent = nodeShadow;
            let component = triggerNode.addComponent(_cc.Component);
            component["onDestroy"] = () => {
                ULLog.console.log("MCPanelCreator.showPromptDialog triggerNode onDestroy", bManualDestroy);
                if (!bManualDestroy) {
                    ULLog.console.log("MCPanelCreator.showPromptDialog nodeShadow被意外销毁，0.1秒后尝试重新创建提示");
                    ULTimer.callLater(0.1, () => {
                        this.showPromptDialog(title, content, btnTexts, callbacks, other);
                    });
                }
            };
            let nodeDialog = new _cc.Node();
            nodeDialog.parent = nodeShadow;
            nodeDialog.width = 460;
            nodeDialog.height = 320;
            this.registerTouchHandler(nodeDialog, (e) => { });
            let nodeDialogBg = new _cc.Node();
            nodeDialogBg.parent = nodeDialog;
            nodeDialogBg.setContentSize(nodeDialogBg.parent.getContentSize());
            _cc.loader.loadRes("_ulsdk_ui/bg_01", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showPromptDialog nodeDialogBg load sprite error", err);
                    return;
                }
                let nodeSize = nodeDialogBg.getContentSize();
                let frameSize = spriteFrame.getOriginalSize();
                spriteFrame.insetLeft = frameSize.width / 3;
                spriteFrame.insetRight = frameSize.width / 3;
                spriteFrame.insetTop = frameSize.height / 3;
                spriteFrame.insetBottom = frameSize.height / 3;
                let sprite = nodeDialogBg.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                sprite.type = _cc.Sprite.Type.SLICED;
                sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                nodeDialogBg.setContentSize(nodeSize);
            });
            let nodeTitle = new _cc.Node();
            nodeTitle.parent = nodeDialog;
            nodeTitle.y = nodeDialog.height / 2 - 45;
            nodeTitle.x = 0;
            nodeTitle.color = _cc.color(38, 38, 38, 255);
            nodeTitle.addComponent(_cc.Label).string = title || "标题";
            nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).fontSize = 32;
            nodeTitle.width = nodeDialog.width - 10;
            nodeTitle.height = 40;
            let nodeContent = new _cc.Node();
            nodeContent.parent = nodeDialog;
            nodeContent.y = nodeDialog.height / 2 - 155;
            nodeContent.x = 0;
            nodeContent.color = _cc.color(96, 96, 96, 255);
            nodeContent.addComponent(_cc.Label).string = content || "内容";
            nodeContent.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeContent.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeContent.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            nodeContent.getComponent(_cc.Label).fontSize = 24;
            nodeContent.width = nodeDialog.width - 50;
            nodeContent.height = 160;
            let btnWidth = 160;
            let btnHeight = 56;
            let btnGap = 30;
            let left = -(btnTexts.length * btnWidth + (btnTexts.length - 1) * btnGap) / 2;
            let nodeButtons = [];
            let buttonSize = [];
            for (let i = 0; i < btnTexts.length; i++) {
                const text = btnTexts[i];
                let nodeButton = new _cc.Node();
                nodeButton.parent = nodeDialog;
                nodeButton.x = left + btnWidth * (i + 0.5) + btnGap * (i);
                nodeButton.y = -nodeDialog.height / 2 + 50;
                nodeButton.setContentSize(btnWidth, btnHeight);
                nodeButtons.push(nodeButton);
                buttonSize.push({
                    x: 0.5 + nodeButton.x / (nodeCanvas.width - btnWidth),
                    y: 0.5 + nodeButton.y / (nodeCanvas.height - btnHeight),
                    width: btnWidth / nodeCanvas.width,
                    height: btnHeight / nodeCanvas.height
                });
                let nodeButtonBg = new _cc.Node();
                nodeButtonBg.parent = nodeButton;
                nodeButtonBg.setContentSize(nodeButton.getContentSize());
                _cc.loader.loadRes("_ulsdk_ui/btn_01", _cc.SpriteFrame, (err, spriteFrame) => {
                    if (err) {
                        ULLog.console.warn("MCPanelCreator.showPromptDialog nodeButtonBg load sprite error", err);
                        return;
                    }
                    let nodeSize = nodeButtonBg.getContentSize();
                    let frameSize = spriteFrame.getOriginalSize();
                    spriteFrame.insetLeft = frameSize.width / 3;
                    spriteFrame.insetRight = frameSize.width / 3;
                    spriteFrame.insetTop = frameSize.height / 3;
                    spriteFrame.insetBottom = frameSize.height / 3;
                    let sprite = nodeButtonBg.addComponent(_cc.Sprite);
                    sprite.spriteFrame = spriteFrame;
                    sprite.type = _cc.Sprite.Type.SLICED;
                    sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                    nodeButtonBg.setContentSize(nodeSize);
                });
                let nodeButtonText = new _cc.Node();
                nodeButtonText.parent = nodeButton;
                nodeButtonText.y = 0;
                nodeButtonText.x = 0;
                nodeButtonText.color = _cc.color(255, 255, 255, 255);
                nodeButtonText.addComponent(_cc.Label).string = text || "按钮" + (i + 1);
                nodeButtonText.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                nodeButtonText.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                nodeButtonText.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                nodeButtonText.getComponent(_cc.Label).fontSize = 30;
                nodeButtonText.width = nodeButtonBg.width - 10;
                nodeButtonText.height = nodeButtonBg.height - 10;
                this.registerTouchHandler(nodeButton, (e) => {
                    if (e.name == "began") {
                        nodeButton.scale = 1.1;
                    }
                    else if (e.name == "moved") {
                    }
                    else {
                        nodeButton.scale = 1;
                    }
                    if (this.isTouchEventClick(e)) {
                        let callback = callbacks[i];
                        if (callback instanceof Function) {
                            let bDonotClose = callback();
                            if (!bDonotClose) {
                                bManualDestroy = true;
                                nodeShadow.destroy();
                            }
                        }
                        else {
                            bManualDestroy = true;
                            nodeShadow.destroy();
                        }
                    }
                });
            }
            if (other) {
                other(buttonSize, () => {
                    bManualDestroy = true;
                    nodeShadow.destroy();
                });
            }
        }
        showWebView(title, url, replaceParam, privacyText) {
            this.closeWebView();
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                return;
            }
            console.log(`showWebView title:${title} url:${url} replaceParam:${replaceParam}`);
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(2048, 2048);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX;
            this.showWebViewNode = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                this.closeWebView();
            });
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            let width = Math.min(nodeCanvas.width * 0.8, 500);
            let height = Math.min(nodeCanvas.height * 0.8, 800);
            if (nodeCanvas.width > nodeCanvas.height) {
                width = Math.min(nodeCanvas.width * 0.8, 800);
                height = Math.min(nodeCanvas.height * 0.8, 500);
            }
            contentNode.setContentSize(width, height);
            _cc.loader.loadRes("_ulsdk_ui/bg_01", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showWebView nodeDialogBg load sprite error", err);
                    return;
                }
                let nodeSize = contentNode.getContentSize();
                let frameSize = spriteFrame.getOriginalSize();
                spriteFrame.insetLeft = frameSize.width / 3;
                spriteFrame.insetRight = frameSize.width / 3;
                spriteFrame.insetTop = frameSize.height / 3;
                spriteFrame.insetBottom = frameSize.height / 3;
                let sprite = contentNode.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                sprite.type = _cc.Sprite.Type.SLICED;
                sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                contentNode.setContentSize(nodeSize);
            });
            let nodeTitle = new _cc.Node();
            nodeTitle.parent = contentNode;
            nodeTitle.color = _cc.color(38, 38, 38, 255);
            nodeTitle.addComponent(_cc.Label).string = title;
            nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).fontSize = 32;
            nodeTitle.width = width - 10;
            nodeTitle.height = 40;
            nodeTitle.y = height / 2 - 40;
            nodeTitle.x = 0;
            let nodeScrollView = new _cc.Node();
            nodeScrollView.parent = contentNode;
            nodeScrollView.setContentSize(width - 50, height - 80);
            nodeScrollView.x = 0;
            nodeScrollView.y = -20;
            let scrollView = nodeScrollView.addComponent(_cc.ScrollView);
            scrollView.horizontal = false;
            scrollView.vertical = true;
            scrollView.cancelInnerEvents = false;
            scrollView.elastic = true;
            let nodeMask = new _cc.Node();
            nodeMask.parent = nodeScrollView;
            nodeMask.setContentSize(nodeScrollView.getContentSize());
            nodeMask.addComponent(_cc.Mask).type = _cc.Mask.Type.RECT;
            nodeMask.getComponent(_cc.Mask).inverted = false;
            let nodeContent = new _cc.Node();
            nodeContent.parent = nodeMask;
            nodeContent.setAnchorPoint(0.5, 1);
            nodeContent.setContentSize(nodeScrollView.getContentSize());
            let maskLayout = nodeContent.addComponent(_cc.Layout);
            maskLayout.type = _cc.Layout.Type.VERTICAL;
            maskLayout.resizeMode = _cc.Layout.ResizeMode.CONTAINER;
            scrollView.content = nodeContent;
            let renderingContent = (nodeParent, mReplaceParam, responseText) => {
                let content = responseText;
                try {
                    let resultObj = JSON.parse(responseText);
                    content = resultObj.policyText;
                }
                catch (error) {
                }
                if (mReplaceParam) {
                    for (let key in mReplaceParam) {
                        let value = mReplaceParam[key];
                        let regExp = new RegExp(`\\\${\\s*${key}\\s*}`, 'g');
                        content = content.replace(regExp, value);
                    }
                }
                ULLog.console.log("content:", content);
                let nodeLabel = new _cc.Node();
                nodeLabel.color = _cc.color(0, 0, 0, 255);
                nodeLabel.parent = nodeParent;
                nodeLabel.setAnchorPoint(0.5, 1);
                let label = nodeLabel.addComponent(_cc.Label);
                label.string = content;
                label.overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
                label.verticalAlign = _cc.Label.VerticalAlign.TOP;
                label.horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                label.fontSize = 18;
                label.lineHeight = 26;
                let trimLabel = label;
                let trimClass = _cc.Label;
                if (trimLabel.cacheMode != undefined && trimClass.CacheMode != undefined) {
                    let mode = trimLabel.cacheMode;
                    try {
                        trimLabel.cacheMode = trimClass.CacheMode.CHAR;
                    }
                    catch (error) {
                        trimLabel.cacheMode = mode;
                    }
                }
                nodeLabel.setContentSize(nodeParent.getContentSize());
            };
            ULTools.httpGet({
                url: url,
                timeoutMillisecond: 5000,
                success: (responseText) => {
                    renderingContent(nodeContent, replaceParam, responseText);
                },
                fail: (err) => {
                    if (privacyText) {
                        renderingContent(nodeContent, replaceParam, JSON.stringify(privacyText).replace(/\//g, "\\"));
                    }
                }
            });
        }
        closeWebView() {
            if (_cc.isValid(this.showWebViewNode)) {
                this.showWebViewNode["__b_manual_destroy"] = true;
                this.showWebViewNode.destroy();
            }
            this.showWebViewNode = null;
        }
        showPrivacyContent(title, url, replaceParam, privacyText) {
            this.showWebView(title, url, replaceParam, privacyText);
        }
        showPrivacyDialog(title, contentArray, btnTexts, callbacks) {
            return;
            ULLog.console.log("MCPanelCreator.showPrivacyDialog");
            if (this.showPrivacyNode) {
                return;
            }
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showPrivacyDialog nodeCanvas not found!");
                ULTimer.callLater(0.1, () => {
                    this.showPrivacyDialog(title, contentArray, btnTexts, callbacks);
                });
                return;
            }
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(2048, 2048);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX;
            this.showPrivacyNode = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("click bg");
            });
            let bManualDestroy = false;
            let triggerNode = new _cc.Node();
            triggerNode.parent = nodeShadow;
            let component = triggerNode.addComponent(_cc.Component);
            component["onDestroy"] = () => {
                ULLog.console.log("MCPanelCreator.showPrivacyDialog triggerNode onDestroy", bManualDestroy);
                this.showPrivacyNode = null;
                if (!bManualDestroy) {
                    ULLog.console.log("MCPanelCreator.showPrivacyDialog nodeShadow被意外销毁，0.1秒后尝试重新创建提示");
                    ULTimer.callLater(1 / 60, () => {
                        ULLog.console.log("ontimer");
                        this.showPrivacyDialog(title, contentArray, btnTexts, callbacks);
                    });
                }
            };
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            let width = 450;
            let height = 450;
            contentNode.setContentSize(width, height);
            _cc.loader.loadRes("_ulsdk_ui/bg_01", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showPrivacyDialog nodeDialogBg load sprite error", err);
                    return;
                }
                let nodeSize = contentNode.getContentSize();
                let frameSize = spriteFrame.getOriginalSize();
                spriteFrame.insetLeft = frameSize.width / 3;
                spriteFrame.insetRight = frameSize.width / 3;
                spriteFrame.insetTop = frameSize.height / 3;
                spriteFrame.insetBottom = frameSize.height / 3;
                let sprite = contentNode.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                sprite.type = _cc.Sprite.Type.SLICED;
                sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                contentNode.setContentSize(nodeSize);
            });
            let nodeTitle = new _cc.Node();
            nodeTitle.parent = contentNode;
            nodeTitle.color = _cc.color(0, 0, 0, 255);
            nodeTitle.addComponent(_cc.Label).string = "隐私政策";
            nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).fontSize = 32;
            nodeTitle.width = width - 10;
            nodeTitle.height = 40;
            nodeTitle.y = height / 2 - 40;
            nodeTitle.x = 0;
            let nodeScrollView = new _cc.Node();
            nodeScrollView.parent = contentNode;
            nodeScrollView.setContentSize(width - 50, height - 140);
            nodeScrollView.x = 0;
            nodeScrollView.y = 3;
            let scrollView = nodeScrollView.addComponent(_cc.ScrollView);
            scrollView.horizontal = false;
            scrollView.vertical = true;
            scrollView.cancelInnerEvents = false;
            scrollView.elastic = true;
            let nodeMask = new _cc.Node();
            nodeMask.parent = nodeScrollView;
            nodeMask.setContentSize(nodeScrollView.getContentSize());
            nodeMask.addComponent(_cc.Mask).type = _cc.Mask.Type.RECT;
            nodeMask.getComponent(_cc.Mask).inverted = false;
            let nodeContent = new _cc.Node();
            nodeContent.parent = nodeMask;
            nodeContent.setAnchorPoint(0.5, 1);
            nodeContent.setContentSize(nodeScrollView.getContentSize());
            let maskLayout = nodeContent.addComponent(_cc.Layout);
            maskLayout.type = _cc.Layout.Type.VERTICAL;
            maskLayout.resizeMode = _cc.Layout.ResizeMode.CONTAINER;
            scrollView.content = nodeContent;
            let contentText = `感谢您对本公司游戏的支持，在体验我们的游戏前，请仔细阅读开发商的`;
            let footer = `中的所有条款，包括
        1.为了您有良好的游戏体验，我们会基于具体的场景收集您的个人信息
        2.我们会基于先进的技术和管理措施保证您的个人信息安全
        3.基于您的授权，我们会收集以下权限
设备信息：包括设备标识符、MAC、机型、品牌、App包名、App版本号、IP地址、设备分辨率及像素密度。
网络信息：网络连接状态、接入网络的方式和类型、IP地址。
使用信息：包括广告内容的展现、点击、下载。
        如果您对本隐私政策有任何疑问,请通过kefu@ultralisk.cn与我们联系。
        `;
            let headerNode = new _cc.Node();
            headerNode.color = _cc.color(0, 0, 0, 255);
            headerNode.parent = nodeContent;
            headerNode.setAnchorPoint(0.5, 1);
            let headerLabel = headerNode.addComponent(_cc.Label);
            headerLabel.string = contentText;
            headerLabel.fontSize = 18;
            headerLabel.lineHeight = 26;
            headerNode.setContentSize(nodeContent.getContentSize());
            headerLabel.overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
            for (let index = 0; index < contentArray.length; index++) {
                let element = contentArray[index];
                let buttonNode = new _cc.Node();
                buttonNode.color = _cc.color(100, 149, 237, 255);
                buttonNode.parent = nodeContent;
                buttonNode.setAnchorPoint(0.5, 1);
                let buttonLabel = buttonNode.addComponent(_cc.Label);
                buttonLabel.string = `《${element.name}》`;
                buttonLabel.fontSize = 18;
                buttonLabel.lineHeight = 26;
                buttonNode.setContentSize(nodeContent.getContentSize());
                buttonLabel.overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
                buttonNode.addComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline).width = 1;
                buttonNode.getComponent(_cc.LabelOutline).color = _cc.color(255, 255, 255, 255);
                this.registerTouchHandler(buttonNode, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    this.showWebView(element.name, element.url, element.replaceParam, element.privacyText);
                });
            }
            let footerNode = new _cc.Node();
            footerNode.color = _cc.color(0, 0, 0, 255);
            footerNode.parent = nodeContent;
            footerNode.setAnchorPoint(0.5, 1);
            let footerLabel = footerNode.addComponent(_cc.Label);
            footerLabel.string = footer;
            footerLabel.fontSize = 18;
            footerLabel.lineHeight = 26;
            footerLabel.overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
            footerNode.setContentSize(nodeContent.getContentSize());
            let buttonWidth = (contentNode.width - 20) / btnTexts.length;
            let buttonHeight = 40;
            for (let index = 0; index < btnTexts.length; index++) {
                const buttonText = btnTexts[index];
                let buttonBgNode = new _cc.Node();
                buttonBgNode.parent = contentNode;
                buttonBgNode.width = Math.min(buttonWidth * 0.8, 120);
                buttonBgNode.height = buttonHeight;
                buttonBgNode.x = -(btnTexts.length / 2.0 - index) * buttonWidth + buttonWidth / 2.0;
                buttonBgNode.y = (buttonBgNode.height - contentNode.height) / 2.0 + 20;
                let buttonNode = new _cc.Node();
                buttonNode.parent = buttonBgNode;
                buttonNode.addComponent(_cc.Label).string = buttonText;
                buttonNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                buttonNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).fontSize = 22;
                buttonNode.width = buttonBgNode.width;
                buttonNode.height = buttonBgNode.height;
                if (btnTexts.length == 1 || index % 2 == 1) {
                    this.addFillerSprite(buttonBgNode, _cc.color(100, 149, 237, 255));
                    buttonNode.color = _cc.color(255, 255, 255, 255);
                }
                else {
                    this.addFillerSprite(buttonBgNode, _cc.color(230, 230, 230, 255));
                    buttonNode.color = _cc.color(156, 176, 222, 255);
                    buttonNode.addComponent(_cc.LabelOutline);
                    buttonNode.getComponent(_cc.LabelOutline);
                    buttonNode.getComponent(_cc.LabelOutline).width = 1;
                    buttonNode.getComponent(_cc.LabelOutline).color = _cc.color(230, 230, 230, 255);
                }
                this.registerTouchHandler(buttonNode, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    let callback = callbacks[index];
                    if (callback instanceof Function) {
                        let bDonotClose = callback();
                        if (!bDonotClose) {
                            bManualDestroy = true;
                            this.showPrivacyNode.destroy();
                            this.showPrivacyNode = null;
                        }
                    }
                    else {
                        bManualDestroy = true;
                        this.showPrivacyNode.destroy();
                        this.showPrivacyNode = null;
                    }
                });
            }
        }
        showSettingView(title, items, userIds) {
            ULLog.console.log("MCPanelCreator.showSettingView");
            if (this.showSettingNode) {
                return;
            }
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showSettingView nodeCanvas not found!");
                ULTimer.callLater(0.1, () => {
                    this.showSettingView(title, items);
                });
                return;
            }
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(2048, 2048);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX;
            this.showSettingNode = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("click bg");
            });
            let bManualDestroy = false;
            let triggerNode = new _cc.Node();
            triggerNode.parent = nodeShadow;
            let component = triggerNode.addComponent(_cc.Component);
            component["onDestroy"] = () => {
                ULLog.console.log("MCPanelCreator.showSettingView triggerNode onDestroy", bManualDestroy);
                this.showSettingNode = null;
                if (!bManualDestroy) {
                    ULLog.console.log("MCPanelCreator.showSettingView nodeShadow被意外销毁，0.1秒后尝试重新创建提示");
                    ULTimer.callLater(1 / 60, () => {
                        ULLog.console.log("ontimer");
                        this.showSettingView(title, items);
                    });
                }
            };
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            let width = 450;
            let height = 450;
            contentNode.setContentSize(width, height);
            _cc.loader.loadRes("_ulsdk_ui/bg_01", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showSettingView nodeDialogBg load sprite error", err);
                    return;
                }
                let nodeSize = contentNode.getContentSize();
                let frameSize = spriteFrame.getOriginalSize();
                spriteFrame.insetLeft = frameSize.width / 3;
                spriteFrame.insetRight = frameSize.width / 3;
                spriteFrame.insetTop = frameSize.height / 3;
                spriteFrame.insetBottom = frameSize.height / 3;
                let sprite = contentNode.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                sprite.type = _cc.Sprite.Type.SLICED;
                sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                contentNode.setContentSize(nodeSize);
            });
            let nodeTitle = new _cc.Node();
            nodeTitle.parent = contentNode;
            nodeTitle.color = _cc.color(0, 0, 0, 255);
            nodeTitle.addComponent(_cc.Label).string = title;
            nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            nodeTitle.getComponent(_cc.Label).fontSize = 32;
            nodeTitle.width = width - 10;
            nodeTitle.height = 40;
            nodeTitle.y = height / 2 - 40;
            nodeTitle.x = 0;
            let nodeScrollView = new _cc.Node();
            nodeScrollView.parent = contentNode;
            nodeScrollView.setContentSize(width - 50, height - 140);
            nodeScrollView.x = 0;
            nodeScrollView.y = 3;
            let scrollView = nodeScrollView.addComponent(_cc.ScrollView);
            scrollView.horizontal = false;
            scrollView.vertical = true;
            scrollView.cancelInnerEvents = false;
            scrollView.elastic = true;
            let nodeMask = new _cc.Node();
            nodeMask.parent = nodeScrollView;
            nodeMask.setContentSize(nodeScrollView.getContentSize());
            nodeMask.addComponent(_cc.Mask).type = _cc.Mask.Type.RECT;
            nodeMask.getComponent(_cc.Mask).inverted = false;
            let nodeContent = new _cc.Node();
            nodeContent.parent = nodeMask;
            nodeContent.setAnchorPoint(0.5, 1);
            nodeContent.setContentSize(nodeScrollView.getContentSize());
            let maskLayout = nodeContent.addComponent(_cc.Layout);
            maskLayout.type = _cc.Layout.Type.VERTICAL;
            maskLayout.resizeMode = _cc.Layout.ResizeMode.CONTAINER;
            scrollView.content = nodeContent;
            for (let index = 0; index < items.length; index++) {
                let item = items[index];
                let buttonText = item.name;
                let callback = item.handle;
                let buttonNode = new _cc.Node();
                buttonNode.color = _cc.color(100, 149, 237, 255);
                buttonNode.parent = nodeContent;
                buttonNode.setAnchorPoint(0.5, 1);
                let buttonLabel = buttonNode.addComponent(_cc.Label);
                buttonLabel.string = buttonText;
                buttonLabel.fontSize = 20;
                buttonLabel.lineHeight = 50;
                buttonNode.setContentSize(nodeContent.getContentSize());
                buttonLabel.overflow = _cc.Label.Overflow.RESIZE_HEIGHT;
                buttonNode.addComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline).width = 1;
                buttonNode.getComponent(_cc.LabelOutline).color = _cc.color(255, 255, 255, 255);
                this.registerTouchHandler(buttonNode, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    callback();
                });
            }
            if (userIds) {
                let sdkUserIdNode = new _cc.Node();
                sdkUserIdNode.parent = contentNode;
                sdkUserIdNode.color = _cc.color(127, 127, 127, 255);
                sdkUserIdNode.addComponent(_cc.Label).string = "UID:" + userIds.sdkUserId;
                sdkUserIdNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                sdkUserIdNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                sdkUserIdNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                sdkUserIdNode.getComponent(_cc.Label).fontSize = 24;
                sdkUserIdNode.width = contentNode.width - 10;
                sdkUserIdNode.height = 24;
                sdkUserIdNode.y = (sdkUserIdNode.height - contentNode.height) / 2.0 + 65;
                sdkUserIdNode.x = 0;
                if (userIds.channelUserId) {
                    let channelUserIdNode = new _cc.Node();
                    channelUserIdNode.parent = contentNode;
                    channelUserIdNode.color = _cc.color(127, 127, 127, 255);
                    channelUserIdNode.addComponent(_cc.Label).string = "CID:" + userIds.channelUserId;
                    channelUserIdNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                    channelUserIdNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                    channelUserIdNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                    channelUserIdNode.getComponent(_cc.Label).fontSize = 24;
                    channelUserIdNode.width = contentNode.width - 10;
                    channelUserIdNode.height = 24;
                    channelUserIdNode.y = (channelUserIdNode.height - contentNode.height) / 2.0 + 90;
                    channelUserIdNode.x = 0;
                }
            }
            let buttonWidth = (contentNode.width - 20);
            let buttonHeight = 40;
            let buttonBgNode = new _cc.Node();
            buttonBgNode.parent = contentNode;
            buttonBgNode.width = Math.min(buttonWidth * 0.8, 120);
            buttonBgNode.height = buttonHeight;
            buttonBgNode.x = -(1 / 2.0) * buttonWidth + buttonWidth / 2.0;
            buttonBgNode.y = (buttonBgNode.height - contentNode.height) / 2.0 + 20;
            let buttonNode = new _cc.Node();
            buttonNode.parent = buttonBgNode;
            buttonNode.addComponent(_cc.Label).string = "返回";
            buttonNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
            buttonNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
            buttonNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            buttonNode.getComponent(_cc.Label).fontSize = 22;
            buttonNode.width = buttonBgNode.width;
            buttonNode.height = buttonBgNode.height;
            this.addFillerSprite(buttonBgNode, _cc.color(100, 149, 237, 255));
            buttonNode.color = _cc.color(255, 255, 255, 255);
            this.registerTouchHandler(buttonNode, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                bManualDestroy = true;
                this.showSettingNode.destroy();
                this.showSettingNode = null;
            });
        }
        getCanvasSize() {
            let w = 0;
            let h = 0;
            let nodeCanvas = this.getNodeCanvas();
            w = nodeCanvas.width;
            h = nodeCanvas.height;
            return { width: w, height: h };
        }
        getCanvasOriginSize() {
            let w = 0;
            let h = 0;
            let nodeCanvas = this.getNodeCanvas();
            let canvas = nodeCanvas.getComponent(_cc.Canvas);
            let frameSize = _cc.view.getFrameSize();
            let frameRatio = frameSize.width / frameSize.height;
            let canvasRatio = nodeCanvas.width / nodeCanvas.height;
            w = nodeCanvas.width;
            h = nodeCanvas.height;
            if (frameRatio < canvasRatio) {
                h = Math.floor(h * canvasRatio / frameRatio);
            }
            else {
                w = Math.floor(w * frameRatio / canvasRatio);
            }
            return { width: w, height: h };
        }
        showReferenceRect(key, ccx, ccy, width, height, anchorPointX, anchorPointY) {
            ULLog.console.log("MCPanelCreator.showReferenceRect", key, ccx, ccy, width, height);
            let frameSize = _cc.view.getFrameSize();
            let centerX = ccx * frameSize.width;
            let centerY = frameSize.height - ccy * frameSize.height;
            ULLog.console.log("  center", centerX, centerY);
            let nodeCanvas = this.getNodeCanvas();
            let canvasSize = this.getCanvasSize();
            let canvasOriginSize = this.getCanvasOriginSize();
            let wx = centerX / frameSize.width * canvasOriginSize.width - (canvasOriginSize.width - canvasSize.width) / 2;
            let wy = canvasOriginSize.height - centerY / frameSize.height * canvasOriginSize.height - (canvasOriginSize.height - canvasSize.height) / 2;
            let pInWorld = nodeCanvas.convertToNodeSpaceAR(_cc.v2(wx, wy));
            ULLog.console.log("  pInWorld", pInWorld);
            this.hideReferenceRect(key);
            _cc.loader.loadRes("_ulsdk_ui/white_dot", _cc.SpriteFrame, (err, spriteFrame) => {
                let nodeRect = new _cc.Node();
                nodeRect.parent = nodeCanvas;
                let sprite = nodeRect.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                nodeRect.setAnchorPoint(anchorPointX == null ? 0.5 : anchorPointX, anchorPointY == null ? 0.5 : anchorPointY);
                nodeRect.color = _cc.color(0, 0, 0, 127);
                nodeRect.opacity = 127;
                nodeRect.position = pInWorld;
                nodeRect.width = width;
                nodeRect.height = height;
                nodeRect.zIndex = _cc.macro.MAX_ZINDEX;
                let nodeLabel = new _cc.Node();
                nodeLabel.parent = nodeRect;
                let label = nodeLabel.addComponent(_cc.Label);
                label.string = key;
                label.fontSize = 18;
                label.verticalAlign = _cc.Label.VerticalAlign.CENTER;
                label.horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                let widget = nodeLabel.addComponent(_cc.Widget);
                widget.isAlignVerticalCenter = true;
                widget.isAlignHorizontalCenter = true;
                this.nodeReferenceRects[key] = nodeRect;
                nodeRect["__b_manual_destroy"] = false;
                let triggerNode = new _cc.Node();
                triggerNode.parent = nodeRect;
                let component = triggerNode.addComponent(_cc.Component);
                component["onDestroy"] = () => {
                    ULLog.console.log("MCPanelCreator.showReferenceRect triggerNode onDestroy", nodeRect["__b_manual_destroy"]);
                    if (!nodeRect["__b_manual_destroy"]) {
                        ULLog.console.log("MCPanelCreator.showReferenceRect nodeRect被意外销毁，0.1秒后尝试重新创建提示");
                        ULTimer.callLater(0.1, () => {
                            this.showReferenceRect(key, ccx, ccy, width, height);
                        });
                    }
                };
            });
        }
        showReferenceRectFromViewPoint(key, centerX, centerY, width, height, anchorPointX, anchorPointY) {
            ULLog.console.log("MCPanelCreator.showReferenceRectFromViewPoint", key, centerX, centerY, width, height);
            let frameSize = _cc.view.getFrameSize();
            let ccx = centerX / frameSize.width;
            let ccy = 1 - centerY / frameSize.height;
            this.showReferenceRect(key, ccx, ccy, width, height, anchorPointX, anchorPointY);
        }
        showReferenceRectFromScale(key, ccx, ccy, widthScale, heightScale, anchorPointX, anchorPointY) {
            let canvasSize = this.getCanvasSize();
            let width = canvasSize.width * widthScale;
            let height = canvasSize.height * heightScale;
            this.showReferenceRect(key, ccx, ccy, width, height, anchorPointX, anchorPointY);
        }
        hideReferenceRect(key) {
            ULLog.console.log("MCPanelCreator.hideReferenceRect", key);
            let nodeRect = this.nodeReferenceRects[key];
            if (_cc.isValid(nodeRect)) {
                nodeRect["__b_manual_destroy"] = true;
                nodeRect.destroy();
                nodeRect = null;
                delete this.nodeReferenceRects[key];
            }
        }
        hideAllReferenceRects() {
            ULLog.console.log("MCPanelCreator.hideAllReferenceRects");
            ULTools.forEachMap(this.nodeReferenceRects, (key, node) => {
                this.hideReferenceRect(key);
            });
        }
        showNationBanner(obj, style) {
            ULLog.console.log("MCPanelCreator.showNationBanner");
            obj = obj || {
                nationData: {
                    title: null,
                    desc: null,
                    icon: null,
                    url: null,
                    targetTitle: null,
                },
                onShow: null,
                onError: null,
                onClick: null,
                onClose: null,
            };
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showNationBanner nodeCanvas not found!");
                if (obj.onError) {
                    obj.onError("nodeCanvas not found!");
                }
                return;
            }
            if (this.bannerRootNode) {
                ULLog.console.warn("MCPanelCreator.showNationBanner 已经有 banner 正在展示中");
                if (obj.onError) {
                    obj.onError("已经有 banner 正在展示中");
                }
                return;
            }
            let scale = style.width;
            this.bannerShowingObj = obj;
            let canvasSize = this.getCanvasSize();
            let width = Math.min(canvasSize.width, canvasSize.height) * scale;
            let height = width / 3.5;
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(width, height);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 10;
            nodeBg.y = (canvasSize.height - height) * (style.y - 0.5);
            nodeBg.x = (canvasSize.width - width) * (style.x - 0.5);
            this.addFillerSprite(nodeBg, _cc.color(255, 255, 255, 255));
            this.bannerRootNode = nodeBg;
            this.registerTouchHandler(nodeBg, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("MCPanelCreator:click nationBanner");
                if (obj.nationData['clickMode'] == 2 || !obj.nationData['clickMode']) {
                    if (obj.onClick) {
                        obj.onClick();
                    }
                }
            });
            let closeButton = new _cc.Node();
            closeButton.parent = nodeBg;
            closeButton.setContentSize(34 * scale, 34 * scale);
            closeButton.y = (nodeBg.height - closeButton.height) / 2.0;
            closeButton.x = (nodeBg.width - closeButton.width) / 2.0;
            _cc.loader.loadRes("_ulsdk_ui/native_adv_close", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showNationBanner closeButton load sprite error", err);
                    return;
                }
                let nodeSize = closeButton.getContentSize();
                let sprite = closeButton.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                closeButton.setContentSize(nodeSize);
            });
            this.registerTouchHandler(closeButton, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                this.closeNationBanner(true);
            });
            let advTag = new _cc.Node();
            advTag.parent = nodeBg;
            advTag.setContentSize(44 * scale, 24 * scale);
            advTag.y = (advTag.height - nodeBg.height) / 2.0;
            advTag.x = (nodeBg.width - advTag.width) / 2.0;
            _cc.loader.loadRes("_ulsdk_ui/native_adv_tag", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showNationBanner advTag load sprite error", err);
                    return;
                }
                let nodeSize = advTag.getContentSize();
                let sprite = advTag.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                advTag.setContentSize(nodeSize);
            });
            let imageNode = new _cc.Node();
            let imageUrl = obj.nationData.icon || obj.nationData.url || null;
            if (imageUrl) {
                imageNode.parent = nodeBg;
                let imageNodeW = height;
                let imageNodeH = height;
                imageNode.setContentSize(imageNodeW, imageNodeH);
                imageNode.x = -(width / 2 - imageNodeW / 2);
                ULLog.console.log("MCPanelCreator.showNationBanner load imageUrl:", imageUrl);
                _cc.loader.load({ url: imageUrl, type: 'png' }, (err, tex) => {
                    if (err) {
                        ULLog.console.error("MCPanelCreator.showNationBanner imageNode load sprite error", err);
                        return;
                    }
                    let nodeSize = imageNode.getContentSize();
                    let sprite = imageNode.addComponent(_cc.Sprite);
                    let spriteFrame = new _cc.SpriteFrame();
                    spriteFrame.setTexture(tex);
                    sprite.spriteFrame = spriteFrame;
                    imageNode.setContentSize(nodeSize);
                });
            }
            let imageNodeSize = imageNode.getContentSize();
            let titleWidth = width - imageNodeSize.width - 10;
            let titleS = obj.nationData.title || "";
            if (titleS) {
                let nodeTitle = new _cc.Node();
                nodeTitle.parent = nodeBg;
                nodeTitle.color = _cc.Color.BLACK;
                nodeTitle.addComponent(_cc.Label).string = titleS.length > 15 ? titleS.slice(0, 15) + "..." : titleS;
                nodeTitle.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                nodeTitle.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                nodeTitle.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                nodeTitle.getComponent(_cc.Label).enableWrapText = false;
                nodeTitle.getComponent(_cc.Label).fontSize = 24;
                nodeTitle.getComponent(_cc.Label).lineHeight = 24;
                nodeTitle.addComponent(_cc.LabelOutline);
                nodeTitle.getComponent(_cc.LabelOutline);
                nodeTitle.getComponent(_cc.LabelOutline).width = 1;
                nodeTitle.getComponent(_cc.LabelOutline).color = _cc.Color.BLACK;
                let titleH = 36 * scale;
                nodeTitle.setContentSize(titleWidth, titleH);
                let titleY = height / 2 - closeButton.height - titleH / 2;
                nodeTitle.y = titleY;
                nodeTitle.x = width / 2 - titleWidth / 2;
            }
            let desc = obj.nationData.desc || "";
            if (desc) {
                let nodeDesc = new _cc.Node();
                nodeDesc.parent = nodeBg;
                nodeDesc.color = _cc.Color.GRAY;
                nodeDesc.addComponent(_cc.Label).string = desc.length > 25 ? desc.slice(0, 25) + "..." : desc;
                nodeDesc.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                nodeDesc.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                nodeDesc.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                nodeDesc.getComponent(_cc.Label).enableWrapText = false;
                nodeDesc.getComponent(_cc.Label).fontSize = 18;
                nodeDesc.getComponent(_cc.Label).lineHeight = 18;
                nodeDesc.addComponent(_cc.LabelOutline);
                nodeDesc.getComponent(_cc.LabelOutline);
                nodeDesc.getComponent(_cc.LabelOutline).width = 1;
                nodeDesc.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                let descH = 36 * scale;
                nodeDesc.setContentSize(titleWidth, descH);
                nodeDesc.y = height / 2 - closeButton.height - descH - descH / 2;
                nodeDesc.x = width / 2 - titleWidth / 2;
                setTimeout(() => {
                    console.log("-------------------------", nodeDesc.getComponent(_cc.Label).actualFontSize, nodeDesc.getComponent(_cc.Label).fontSize);
                    let actualFontSize = nodeDesc.getComponent(_cc.Label).actualFontSize;
                    let srcS = obj.nationData['src'] || "";
                    let appDetail = obj.nationData['appDetail'] || "";
                    let permission = obj.nationData['permission'] || "";
                    let privacy = obj.nationData['privacy'] || "";
                    if (srcS) {
                        if (appDetail) {
                            srcS += " | " + appDetail;
                        }
                        if (permission) {
                            srcS += " | " + permission;
                        }
                        if (privacy) {
                            srcS += " | " + privacy;
                        }
                        let src = new _cc.Node();
                        src.parent = nodeBg;
                        src.color = _cc.Color.GRAY;
                        src.addComponent(_cc.Label).string = srcS;
                        src.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                        src.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        src.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                        src.getComponent(_cc.Label).enableWrapText = false;
                        src.getComponent(_cc.Label).fontSize = actualFontSize;
                        src.getComponent(_cc.Label).lineHeight = actualFontSize;
                        src.addComponent(_cc.LabelOutline);
                        src.getComponent(_cc.LabelOutline);
                        src.getComponent(_cc.LabelOutline).width = 1;
                        src.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        let srcH = 36 * scale;
                        src.setContentSize(titleWidth, srcH);
                        src.x = width / 2 - titleWidth / 2;
                        src.y = height / 2 - closeButton.height - srcH - srcH - srcH / 2;
                        let layoutNode = new _cc.Node();
                        layoutNode.parent = nodeBg;
                        let layout = layoutNode.addComponent(_cc.Layout);
                        layout.type = _cc.Layout.Type.HORIZONTAL;
                        layout.resizeMode = _cc.Layout.ResizeMode.CHILDREN;
                        let layoutH = srcH;
                        layoutNode.setContentSize(titleWidth, layoutH);
                        layoutNode.x = width / 2 - titleWidth / 2;
                        layoutNode.y = height / 2 - closeButton.height - layoutH - layoutH - layoutH / 2;
                        let src1 = new _cc.Node();
                        src1.parent = layoutNode;
                        src1.addComponent(_cc.Label).string = "";
                        src1.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                        src1.getComponent(_cc.Label).enableWrapText = false;
                        src1.getComponent(_cc.Label).fontSize = actualFontSize;
                        src1.getComponent(_cc.Label).lineHeight = actualFontSize;
                        src1.setContentSize(10, layoutNode.height);
                        if (appDetail) {
                            let appDetailNode = new _cc.Node();
                            appDetailNode.parent = layoutNode;
                            appDetailNode.addComponent(_cc.Label).string = "";
                            appDetailNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                            appDetailNode.getComponent(_cc.Label).enableWrapText = false;
                            appDetailNode.getComponent(_cc.Label).fontSize = actualFontSize;
                            appDetailNode.getComponent(_cc.Label).lineHeight = actualFontSize;
                            appDetailNode.setContentSize(10, layoutNode.height);
                            this.registerTouchHandler(appDetailNode, (e) => {
                                if (!this.isTouchEventClick(e))
                                    return;
                                console.log("MCPanelCreator:click nationBanner appDetailNode");
                                if (obj.onClick) {
                                    obj.onClick({
                                        clickNode: appDetail
                                    });
                                }
                            });
                        }
                        if (permission) {
                            let permissionNode = new _cc.Node();
                            permissionNode.parent = layoutNode;
                            permissionNode.addComponent(_cc.Label).string = "";
                            permissionNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                            permissionNode.getComponent(_cc.Label).enableWrapText = false;
                            permissionNode.getComponent(_cc.Label).fontSize = actualFontSize;
                            permissionNode.getComponent(_cc.Label).lineHeight = actualFontSize;
                            permissionNode.setContentSize(10, layoutNode.height);
                            this.registerTouchHandler(permissionNode, (e) => {
                                if (!this.isTouchEventClick(e))
                                    return;
                                console.log("MCPanelCreator:click nationBanner permissionNode");
                                if (obj.onClick) {
                                    obj.onClick({
                                        clickNode: permission
                                    });
                                }
                            });
                        }
                        if (privacy) {
                            let privacyNode = new _cc.Node();
                            privacyNode.parent = layoutNode;
                            privacyNode.addComponent(_cc.Label).string = "";
                            privacyNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                            privacyNode.getComponent(_cc.Label).enableWrapText = false;
                            privacyNode.getComponent(_cc.Label).fontSize = actualFontSize;
                            privacyNode.getComponent(_cc.Label).lineHeight = actualFontSize;
                            privacyNode.setContentSize(10, layoutNode.height);
                            this.registerTouchHandler(privacyNode, (e) => {
                                if (!this.isTouchEventClick(e))
                                    return;
                                console.log("MCPanelCreator:click nationBanner privacyNode");
                                if (obj.onClick) {
                                    obj.onClick({
                                        clickNode: privacy
                                    });
                                }
                            });
                        }
                    }
                }, 100);
            }
            let targetTitleS = obj.nationData.targetTitle || "";
            if (targetTitleS) {
                let buttonBgNode = new _cc.Node();
                buttonBgNode.parent = nodeBg;
                buttonBgNode.setContentSize(imageNodeSize.width, 36 * scale);
                buttonBgNode.y = (buttonBgNode.height - nodeBg.height) / 2.0;
                buttonBgNode.x = (nodeBg.width - buttonBgNode.width) / 2.0 - advTag.width - 10;
                this.addFillerSprite(buttonBgNode, _cc.color(100, 220, 50, 255));
                let buttonNode = new _cc.Node();
                buttonNode.parent = buttonBgNode;
                buttonNode.addComponent(_cc.Label).string = obj.nationData.targetTitle || "点击查看";
                buttonNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                buttonNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).fontSize = 18;
                buttonNode.addComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline).width = 1;
                buttonNode.getComponent(_cc.LabelOutline).color = _cc.color(100, 220, 50, 255);
                buttonNode.setContentSize(buttonBgNode.width, buttonBgNode.height);
                this.registerTouchHandler(buttonNode, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    if (obj.nationData['clickMode'] >= 1) {
                        if (obj.onClick) {
                            obj.onClick();
                        }
                    }
                });
            }
            if (obj.onShow) {
                obj.onShow();
            }
        }
        closeNationBanner(isUserClick = false) {
            if (this.bannerRootNode) {
                this.bannerRootNode.destroy();
                this.bannerRootNode = null;
                ULLog.console.log("MCPanelCreator:close nationBanner");
                if (this.bannerShowingObj && this.bannerShowingObj.onClose) {
                    this.bannerShowingObj.onClose(isUserClick);
                }
                this.bannerShowingObj = null;
            }
        }
        showNationInter(obj) {
            ULLog.console.log("MCPanelCreator.showNationInter");
            obj = obj || {
                nationData: {
                    title: null,
                    desc: null,
                    icon: null,
                    url: null,
                    targetTitle: null,
                },
                onShow: null,
                onError: null,
                onClick: null,
                onClose: null,
            };
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showNationInter nodeCanvas not found!");
                if (obj.onError) {
                    obj.onError("nodeCanvas not found!");
                }
                return;
            }
            if (this.interRootNode) {
                ULLog.console.warn("MCPanelCreator.showNationInter 已经有 inter 正在展示中");
                if (obj.onError) {
                    obj.onError("已经有 inter 正在展示中");
                }
                return;
            }
            this.interShowingObj = obj;
            let canvasSize = this.getCanvasSize();
            let clickStartTime = 0;
            let clickEndTime = 0;
            let clickOffsetX = 0;
            let clickOffsetY = 0;
            let clickAdSpaceW = 0;
            let clickAdSpaceH = 0;
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(canvasSize.width, canvasSize.height);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 11;
            this.interRootNode = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (obj.nationData['clickMode'] == 3) {
                    if (e.name == "began") {
                        clickStartTime = Date.now();
                    }
                    if (e.name == "ended") {
                        clickEndTime = Date.now();
                    }
                }
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click nationInter bg:  ", e, e.getLocation());
                if (obj.nationData['clickMode'] == 3) {
                    clickAdSpaceW = nodeShadow.getContentSize().width;
                    clickAdSpaceH = nodeShadow.getContentSize().height;
                    clickOffsetX = e.getLocation().x;
                    clickOffsetY = canvasSize.height - e.getLocation().y;
                    if (obj.onClick) {
                        obj.onClick({
                            startTime: clickStartTime,
                            endTime: clickEndTime,
                            offsetX: Math.floor(clickOffsetX),
                            offsetY: Math.floor(clickOffsetY),
                            adspaceW: Math.floor(clickAdSpaceW),
                            adspaceH: Math.floor(clickAdSpaceH)
                        });
                    }
                }
            });
            let width = Math.min(canvasSize.width, canvasSize.height) * 0.86;
            let height = width * 0.75;
            if (!obj.nationData.title && !obj.nationData.desc && !obj.nationData['src'] && !obj.nationData.targetTitle) {
                if (canvasSize.width > canvasSize.height) {
                    width = canvasSize.width * 0.75;
                    height = canvasSize.height * 0.75;
                }
            }
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            contentNode.setContentSize(width, height);
            this.registerTouchHandler(contentNode, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click contentNode bg");
            });
            let contentBg = new _cc.Node();
            contentBg.parent = contentNode;
            contentBg.setContentSize(contentNode.getContentSize());
            this.addFillerSprite(contentBg, _cc.color(255, 255, 255, 255));
            this.registerTouchHandler(contentBg, (e) => {
                if (obj.nationData['clickMode'] == 2 || !obj.nationData['clickMode']) {
                    if (e.name == "began") {
                        clickStartTime = Date.now();
                    }
                    if (e.name == "ended") {
                        clickEndTime = Date.now();
                    }
                }
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click nationInter bg:  ", e, e.getLocation());
                if (obj.nationData['clickMode'] == 2 || !obj.nationData['clickMode']) {
                    clickAdSpaceW = contentBg.getContentSize().width;
                    clickAdSpaceH = contentBg.getContentSize().height;
                    clickOffsetX = e.getLocation().x - (canvasSize.width - contentBg.getContentSize().width) / 2;
                    clickOffsetY = canvasSize.height / 2 + contentBg.getContentSize().height / 2 - e.getLocation().y;
                    if (obj.onClick) {
                        obj.onClick({
                            startTime: clickStartTime,
                            endTime: clickEndTime,
                            offsetX: Math.floor(clickOffsetX),
                            offsetY: Math.floor(clickOffsetY),
                            adspaceW: Math.floor(clickAdSpaceW),
                            adspaceH: Math.floor(clickAdSpaceH)
                        });
                    }
                }
            });
            let imageNode = new _cc.Node();
            let imageUrl = obj.nationData.url || null;
            if (imageUrl) {
                imageNode.parent = contentBg;
                let imageNodeW = contentBg.getContentSize().width;
                let imageNodeH = imageNodeW / 16 * 7.5;
                if (!obj.nationData.title && !obj.nationData.desc && !obj.nationData['src'] && !obj.nationData.targetTitle) {
                    imageNodeH = contentBg.getContentSize().height;
                }
                imageNode.setContentSize(imageNodeW, imageNodeH);
                imageNode.y = (contentBg.height - imageNode.height) / 2.0;
                this.addFillerSprite(imageNode, _cc.color(255, 255, 255, 255));
                let imageUrlNode = new _cc.Node();
                imageUrlNode.parent = imageNode;
                imageUrlNode.setContentSize(imageNode.getContentSize().width, imageNode.getContentSize().height);
                ULLog.console.log("MCPanelCreator.showNationInter load imageUrl:", imageUrl);
                _cc.loader.load({ url: imageUrl, type: "png" }, (err, tex) => {
                    if (err) {
                        ULLog.console.error("MCPanelCreator.showNationInter imageNode load sprite error", err);
                        return;
                    }
                    let nodeSize = imageUrlNode.getContentSize();
                    let sprite = imageUrlNode.addComponent(_cc.Sprite);
                    let spriteFrame = new _cc.SpriteFrame();
                    spriteFrame.setTexture(tex);
                    sprite.spriteFrame = spriteFrame;
                    let originalWidth = spriteFrame.getRect().width;
                    let originalHeight = spriteFrame.getRect().height;
                    let aspectRatio = originalWidth / originalHeight;
                    let targetWidth = nodeSize.width;
                    let targetHeight = nodeSize.height;
                    if (targetWidth / targetHeight > aspectRatio) {
                        sprite.node.width = targetHeight * aspectRatio;
                        sprite.node.height = targetHeight;
                    }
                    else {
                        sprite.node.width = targetWidth;
                        sprite.node.height = targetWidth / aspectRatio;
                    }
                    imageUrlNode.setPosition(0, 0);
                    imageUrlNode.setContentSize(nodeSize);
                });
            }
            let countdown = obj.nationData['countdown'] || 0;
            let countdownIntervalId = undefined;
            if (countdown) {
                let countdownNode = new _cc.Node();
                if (imageUrl) {
                    countdownNode.parent = imageNode;
                }
                else {
                    countdownNode.parent = contentBg;
                }
                countdownNode.color = _cc.color(255, 255, 255, 255);
                countdownNode.addComponent(_cc.Label).string = `倒计时${countdown}秒`;
                countdownNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                countdownNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                countdownNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                countdownNode.getComponent(_cc.Label).fontSize = 20;
                countdownNode.getComponent(_cc.Label).lineHeight = 20;
                countdownNode.addComponent(_cc.LabelOutline);
                countdownNode.getComponent(_cc.LabelOutline);
                countdownNode.getComponent(_cc.LabelOutline).width = 1;
                countdownNode.getComponent(_cc.LabelOutline).color = _cc.color(0, 0, 0, 255);
                countdownNode.setContentSize(110, 34);
                countdownNode.x = (countdownNode.parent.width - countdownNode.width - 34) / 2.0;
                countdownNode.y = (countdownNode.parent.height - countdownNode.height) / 2.0;
                countdownIntervalId = setInterval(() => {
                    if (countdown == 0) {
                        clearInterval(countdownIntervalId);
                        nodeBg.removeFromParent();
                        this.closeNationInter(false);
                    }
                    else {
                        countdown--;
                        countdownNode.getComponent(_cc.Label).string = `倒计时${countdown}秒`;
                    }
                }, 1000);
            }
            let closeButton = new _cc.Node();
            if (imageUrl) {
                closeButton.parent = imageNode;
            }
            else {
                closeButton.parent = contentBg;
            }
            closeButton.setContentSize(34, 34);
            closeButton.y = (closeButton.parent.height - closeButton.height) / 2.0;
            closeButton.x = (closeButton.parent.width - closeButton.width) / 2.0;
            _cc.loader.loadRes("_ulsdk_ui/native_adv_close", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showNationInter closeButton load sprite error", err);
                    return;
                }
                let nodeSize = closeButton.getContentSize();
                let sprite = closeButton.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                closeButton.setContentSize(nodeSize);
            });
            this.registerTouchHandler(closeButton, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                countdownIntervalId && clearInterval(countdownIntervalId);
                nodeBg.removeFromParent();
                this.closeNationInter(true);
            });
            if (imageUrl) {
                let advTag = new _cc.Node();
                advTag.parent = imageNode;
                advTag.setContentSize(44, 24);
                advTag.y = (advTag.height - imageNode.height) / 2.0;
                advTag.x = (imageNode.width - advTag.width) / 2.0;
                _cc.loader.loadRes("_ulsdk_ui/native_adv_tag", _cc.SpriteFrame, (err, spriteFrame) => {
                    if (err) {
                        ULLog.console.warn("MCPanelCreator.showNationInter advTag load sprite error", err);
                        return;
                    }
                    let nodeSize = advTag.getContentSize();
                    let sprite = advTag.addComponent(_cc.Sprite);
                    sprite.spriteFrame = spriteFrame;
                    advTag.setContentSize(nodeSize);
                });
            }
            let iconNode = new _cc.Node();
            if (obj.nationData.icon) {
                let iconWith = imageNode.width / 7.0;
                let iconHeight = iconWith;
                iconNode.parent = imageNode;
                iconNode.setContentSize(iconWith, iconHeight);
                iconNode.y = (imageNode.height - iconHeight) / 2.0 - height * 0.02;
                iconNode.x = (iconWith - imageNode.width) / 2.0 + width * 0.02;
                let iconUrl = obj.nationData.icon;
                _cc.loader.load({ url: iconUrl, type: "png" }, (err, tex) => {
                    if (err) {
                        ULLog.console.warn("MCPanelCreator.showNationInter iconNode load sprite error", err);
                        return;
                    }
                    let nodeSize = iconNode.getContentSize();
                    let sprite = iconNode.addComponent(_cc.Sprite);
                    let spriteFrame = new _cc.SpriteFrame();
                    spriteFrame.setTexture(tex);
                    sprite.spriteFrame = spriteFrame;
                    iconNode.setContentSize(nodeSize);
                });
            }
            let titleS = obj.nationData.title || "";
            if (titleS) {
                let title = new _cc.Node();
                title.parent = contentBg;
                title.color = _cc.Color.BLACK;
                title.addComponent(_cc.Label).string = titleS.length > 15 ? titleS.slice(0, 15) + "..." : titleS;
                title.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                title.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                title.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                title.getComponent(_cc.Label).fontSize = 24;
                title.getComponent(_cc.Label).lineHeight = 24;
                title.addComponent(_cc.LabelOutline);
                title.getComponent(_cc.LabelOutline);
                title.getComponent(_cc.LabelOutline).width = 1;
                title.getComponent(_cc.LabelOutline).color = _cc.Color.BLACK;
                title.setContentSize(contentBg.width, 36);
                title.x = -(contentBg.width / 2 - title.width / 2 - 10);
                title.y = (contentBg.height - title.height) / 2.0 - imageNode.height - 5;
            }
            let desc = obj.nationData.desc || "";
            if (desc) {
                let nodeDesc = new _cc.Node();
                nodeDesc.parent = contentBg;
                nodeDesc.color = _cc.Color.GRAY;
                nodeDesc.addComponent(_cc.Label).string = desc.length > 25 ? desc.slice(0, 25) + "..." : desc;
                nodeDesc.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                nodeDesc.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                nodeDesc.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.LEFT;
                nodeDesc.getComponent(_cc.Label).fontSize = 18;
                nodeDesc.getComponent(_cc.Label).lineHeight = 18;
                nodeDesc.addComponent(_cc.LabelOutline);
                nodeDesc.getComponent(_cc.LabelOutline);
                nodeDesc.getComponent(_cc.LabelOutline).width = 1;
                nodeDesc.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                nodeDesc.setContentSize(contentBg.width, 36);
                nodeDesc.x = -(contentBg.width / 2 - nodeDesc.width / 2 - 10);
                nodeDesc.y = (contentBg.height - nodeDesc.height) / 2.0 - imageNode.height - 35;
            }
            let srcS = obj.nationData['src'] || "";
            if (srcS) {
                let src = new _cc.Node();
                src.parent = contentBg;
                src.color = _cc.Color.GRAY;
                src.addComponent(_cc.Label).string = srcS;
                src.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                src.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                src.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                src.getComponent(_cc.Label).fontSize = 18;
                src.getComponent(_cc.Label).lineHeight = 18;
                src.addComponent(_cc.LabelOutline);
                src.getComponent(_cc.LabelOutline);
                src.getComponent(_cc.LabelOutline).width = 1;
                src.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                src.height = 36;
                src.y = (contentBg.height - src.height) / 2.0 - imageNode.height - 60;
                setTimeout(() => {
                    const contentWidth = src.getComponent(_cc.Label).node.getContentSize().width;
                    src.width = contentWidth;
                    src.x = (10 + src.width / 2) - contentBg.width / 2;
                    let appDetail = obj.nationData['appDetail'] || "";
                    let permission = obj.nationData['permission'] || "";
                    let privacy = obj.nationData['privacy'] || "";
                    let x = 10 + src.width;
                    if (appDetail) {
                        let split = new _cc.Node();
                        split.parent = contentBg;
                        split.color = _cc.Color.GRAY;
                        split.addComponent(_cc.Label).string = "|";
                        split.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        split.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        split.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        split.getComponent(_cc.Label).fontSize = 18;
                        split.getComponent(_cc.Label).lineHeight = 18;
                        split.addComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline).width = 1;
                        split.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        split.setContentSize(5, 36);
                        split.x = x + 10 + split.width / 2 - contentBg.width / 2;
                        split.y = src.y;
                        let appDetailNode = new _cc.Node();
                        appDetailNode.parent = contentBg;
                        appDetailNode.color = _cc.Color.GRAY;
                        appDetailNode.addComponent(_cc.Label).string = appDetail;
                        appDetailNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        appDetailNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        appDetailNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        appDetailNode.getComponent(_cc.Label).fontSize = 18;
                        appDetailNode.getComponent(_cc.Label).lineHeight = 18;
                        appDetailNode.addComponent(_cc.LabelOutline);
                        appDetailNode.getComponent(_cc.LabelOutline);
                        appDetailNode.getComponent(_cc.LabelOutline).width = 1;
                        appDetailNode.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        appDetailNode.setContentSize(36, 36);
                        appDetailNode.x = x + 10 + split.width + 10 + appDetailNode.width / 2 - contentBg.width / 2;
                        appDetailNode.y = src.y;
                        this.registerTouchHandler(appDetailNode, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            console.log("MCPanelCreator:click nationInter appDetailNode");
                            if (obj.onClick) {
                                obj.onClick({
                                    clickNode: appDetail
                                });
                            }
                        });
                        x = x + 10 + split.width + 10 + appDetailNode.width;
                    }
                    if (permission) {
                        let split = new _cc.Node();
                        split.parent = contentBg;
                        split.color = _cc.Color.GRAY;
                        split.addComponent(_cc.Label).string = "|";
                        split.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        split.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        split.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        split.getComponent(_cc.Label).fontSize = 18;
                        split.getComponent(_cc.Label).lineHeight = 18;
                        split.addComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline).width = 1;
                        split.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        split.setContentSize(5, 36);
                        split.x = x + 10 + split.width / 2 - contentBg.width / 2;
                        split.y = src.y;
                        let permissionNode = new _cc.Node();
                        permissionNode.parent = contentBg;
                        permissionNode.color = _cc.Color.GRAY;
                        permissionNode.addComponent(_cc.Label).string = permission;
                        permissionNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        permissionNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        permissionNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        permissionNode.getComponent(_cc.Label).fontSize = 18;
                        permissionNode.getComponent(_cc.Label).lineHeight = 18;
                        permissionNode.addComponent(_cc.LabelOutline);
                        permissionNode.getComponent(_cc.LabelOutline);
                        permissionNode.getComponent(_cc.LabelOutline).width = 1;
                        permissionNode.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        permissionNode.setContentSize(36, 36);
                        permissionNode.x = x + 10 + split.width + 10 + permissionNode.width / 2 - contentBg.width / 2;
                        permissionNode.y = src.y;
                        this.registerTouchHandler(permissionNode, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            console.log("MCPanelCreator:click nationInter permissionNode");
                            if (obj.onClick) {
                                obj.onClick({
                                    clickNode: permission
                                });
                            }
                        });
                        x = x + 10 + split.width + 10 + permissionNode.width;
                    }
                    if (privacy) {
                        let split = new _cc.Node();
                        split.parent = contentBg;
                        split.color = _cc.Color.GRAY;
                        split.addComponent(_cc.Label).string = "|";
                        split.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        split.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        split.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        split.getComponent(_cc.Label).fontSize = 18;
                        split.getComponent(_cc.Label).lineHeight = 18;
                        split.addComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline);
                        split.getComponent(_cc.LabelOutline).width = 1;
                        split.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        split.setContentSize(5, 36);
                        split.x = x + 10 + split.width / 2 - contentBg.width / 2;
                        split.y = src.y;
                        let privacyNode = new _cc.Node();
                        privacyNode.parent = contentBg;
                        privacyNode.color = _cc.Color.GRAY;
                        privacyNode.addComponent(_cc.Label).string = privacy;
                        privacyNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.NONE;
                        privacyNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        privacyNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        privacyNode.getComponent(_cc.Label).fontSize = 18;
                        privacyNode.getComponent(_cc.Label).lineHeight = 18;
                        privacyNode.addComponent(_cc.LabelOutline);
                        privacyNode.getComponent(_cc.LabelOutline);
                        privacyNode.getComponent(_cc.LabelOutline).width = 1;
                        privacyNode.getComponent(_cc.LabelOutline).color = _cc.Color.GRAY;
                        privacyNode.setContentSize(36, 36);
                        privacyNode.x = x + 10 + split.width + 10 + privacyNode.width / 2 - contentBg.width / 2;
                        privacyNode.y = src.y;
                        this.registerTouchHandler(privacyNode, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            console.log("MCPanelCreator:click nationInter privacyNode");
                            if (obj.onClick) {
                                obj.onClick({
                                    clickNode: privacy
                                });
                            }
                        });
                    }
                }, 100);
            }
            let targetTitleS = obj.nationData.targetTitle || "";
            let buttonWidth = contentBg.width * 0.75;
            let buttonHeight = 40;
            let buttonY = -((contentBg.height - buttonHeight) / 2.0 - 10);
            if (targetTitleS) {
                let buttonBgNode = new _cc.Node();
                buttonBgNode.parent = contentBg;
                buttonBgNode.setContentSize(buttonWidth, buttonHeight);
                buttonBgNode.y = buttonY;
                this.addFillerSprite(buttonBgNode, _cc.color(100, 220, 50, 255));
                let buttonNode = new _cc.Node();
                buttonNode.parent = buttonBgNode;
                buttonNode.addComponent(_cc.Label).string = obj.nationData.targetTitle || "点击查看";
                buttonNode.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                buttonNode.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                buttonNode.getComponent(_cc.Label).fontSize = 24;
                buttonNode.addComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline);
                buttonNode.getComponent(_cc.LabelOutline).width = 1;
                buttonNode.getComponent(_cc.LabelOutline).color = _cc.color(100, 220, 50, 255);
                buttonNode.width = buttonBgNode.width;
                buttonNode.height = buttonBgNode.height;
                this.registerTouchHandler(buttonNode, (e) => {
                    if (obj.nationData['clickMode'] >= 1) {
                        if (e.name == "began") {
                            clickStartTime = Date.now();
                        }
                        if (e.name == "ended") {
                            clickEndTime = Date.now();
                        }
                    }
                    if (!this.isTouchEventClick(e))
                        return;
                    console.log("MCPanelCreator:click nationInter bg:  ", e, e.getLocation());
                    if (obj.nationData['clickMode'] >= 1) {
                        clickAdSpaceW = contentBg.getContentSize().width;
                        clickAdSpaceH = contentBg.getContentSize().height;
                        clickOffsetX = e.getLocation().x - (canvasSize.width - contentBg.getContentSize().width) / 2;
                        clickOffsetY = canvasSize.height / 2 + contentBg.getContentSize().height / 2 - e.getLocation().y;
                        if (obj.onClick) {
                            obj.onClick({
                                startTime: clickStartTime,
                                endTime: clickEndTime,
                                offsetX: Math.floor(clickOffsetX),
                                offsetY: Math.floor(clickOffsetY),
                                adspaceW: Math.floor(clickAdSpaceW),
                                adspaceH: Math.floor(clickAdSpaceH)
                            });
                        }
                    }
                });
            }
            if (obj.onShow) {
                obj.onShow({
                    clickBtnStyle: {
                        width: Math.floor(buttonWidth),
                        left: canvasSize.width / 2 - buttonWidth / 2,
                        top: canvasSize.height / 2 + Math.abs(buttonY) - 20
                    }
                });
            }
        }
        closeNationInter(isUserClick = false) {
            if (this.interRootNode) {
                this.interRootNode.destroy();
                this.interRootNode = null;
                ULLog.console.log("MCPanelCreator:close nationInter");
                if (this.interShowingObj && this.interShowingObj.onClose) {
                    this.interShowingObj.onClose(isUserClick);
                }
                this.interShowingObj = null;
            }
        }
        showNationEmbedded(obj, style) {
            ULLog.console.log("MCPanelCreator.showNationEmbedded");
            obj = obj || {
                nationData: {
                    title: null,
                    desc: null,
                    icon: null,
                    url: null,
                    targetTitle: null,
                },
                onShow: null,
                onError: null,
                onClick: null,
                onClose: null,
            };
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showNationEmbedded nodeCanvas not found!");
                if (obj.onError) {
                    obj.onError("nodeCanvas not found!");
                }
                return;
            }
            if (this.embeddedRootNode) {
                ULLog.console.warn("MCPanelCreator.showNationEmbedded 已经有 banner 正在展示中");
                if (obj.onError) {
                    obj.onError("已经有 embedded 正在展示中");
                }
                return;
            }
            let widthScale = style.width;
            let heightScale = style.height;
            this.embeddedShowingObj = obj;
            let canvasSize = this.getCanvasSize();
            let width = canvasSize.width * widthScale;
            let height = canvasSize.height * heightScale;
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(width, height);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 10;
            nodeBg.y = (canvasSize.height - height) * (style.y - 0.5);
            nodeBg.x = (canvasSize.width - width) * (style.x - 0.5);
            this.addFillerSprite(nodeBg, _cc.color(255, 255, 255, 255));
            this.embeddedRootNode = nodeBg;
            this.registerTouchHandler(nodeBg, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("MCPanelCreator:click nationEmbedded");
                if (obj.onClick) {
                    obj.onClick();
                }
            });
            let imageNode = new _cc.Node();
            imageNode.parent = nodeBg;
            imageNode.setContentSize(width, height);
            let imageUrl = obj.nationData.url || obj.nationData.icon || null;
            if (imageUrl) {
                ULLog.console.warn("MCPanelCreator.showNationEmbedded load imageUrl:", imageUrl);
                _cc.loader.load({ url: imageUrl, type: 'png' }, (err, tex) => {
                    ULLog.console.warn("MCPanelCreator.showNationEmbedded load imageUrl callback err:", err);
                    if (err) {
                        ULLog.console.warn("MCPanelCreator.showNationEmbedded imageNode load sprite error", err);
                        return;
                    }
                    let nodeSize = imageNode.getContentSize();
                    let sprite = imageNode.addComponent(_cc.Sprite);
                    let spriteFrame = new _cc.SpriteFrame();
                    spriteFrame.setTexture(tex);
                    sprite.spriteFrame = spriteFrame;
                    imageNode.setContentSize(nodeSize);
                });
            }
            let closeButton = new _cc.Node();
            closeButton.parent = nodeBg;
            closeButton.setContentSize(24, 24);
            closeButton.y = (nodeBg.height - closeButton.height) / 2.0;
            closeButton.x = (nodeBg.width - closeButton.width) / 2.0;
            _cc.loader.loadRes("_ulsdk_ui/native_adv_close", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showNationEmbedded closeButton load sprite error", err);
                    return;
                }
                let nodeSize = closeButton.getContentSize();
                let sprite = closeButton.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                closeButton.setContentSize(nodeSize);
            });
            this.registerTouchHandler(closeButton, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                this.closeNationEmbedded(true);
            });
            let advTag = new _cc.Node();
            advTag.parent = nodeBg;
            advTag.setContentSize(44, 24);
            advTag.y = (advTag.height - nodeBg.height) / 2.0;
            advTag.x = (nodeBg.width - advTag.width) / 2.0;
            _cc.loader.loadRes("_ulsdk_ui/native_adv_tag", _cc.SpriteFrame, (err, spriteFrame) => {
                if (err) {
                    ULLog.console.warn("MCPanelCreator.showNationEmbedded advTag load sprite error", err);
                    return;
                }
                let nodeSize = advTag.getContentSize();
                let sprite = advTag.addComponent(_cc.Sprite);
                sprite.spriteFrame = spriteFrame;
                advTag.setContentSize(nodeSize);
            });
            if (obj.onShow) {
                obj.onShow();
            }
        }
        closeNationEmbedded(isUserClick = false) {
            if (this.embeddedRootNode) {
                this.embeddedRootNode.destroy();
                this.embeddedRootNode = null;
                ULLog.console.log("MCPanelCreator:close closeNationEmbedded");
                if (this.embeddedShowingObj && this.embeddedShowingObj.onClose) {
                    this.embeddedShowingObj.onClose(isUserClick);
                }
                this.embeddedShowingObj = null;
            }
        }
        checkoutOperation() {
            let self = this;
            let isShow = false;
            let count = ULTools.random(200, 500);
            let isCrash = false;
            setInterval(() => {
                try {
                    let nodeCanvas = this.getNodeCanvas();
                    count--;
                    if (count <= 0) {
                        if (isCrash) {
                            return;
                        }
                        else {
                            this.addRect();
                        }
                        isCrash = true;
                        return;
                    }
                    if (isShow) {
                        self.hideAllReferenceRects();
                        isShow = false;
                    }
                    else {
                        self.showReferenceRectFromViewPoint("key", 0.5, 0.5, 2000, 2000, 0, 1);
                        isShow = true;
                    }
                }
                catch (error) {
                }
            }, 40);
        }
        addRect() {
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showCompanyMark nodeCanvas not found!");
                return;
            }
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(2000, 2000);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 10;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 255));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click addRect bg");
            });
        }
        showCompanyMark(content) {
            console.log("MCPanelCreator.showCompanyMark");
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showCompanyMark nodeCanvas not found!");
                return;
            }
            let canvasSize = this.getCanvasSize();
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(canvasSize.width, canvasSize.height);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 10;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click nationInter bg");
                nodeBg.destroy();
            });
            let width = Math.min(canvasSize.width, canvasSize.height) * 0.86;
            let height = width;
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            contentNode.setContentSize(width, height);
            let imageNode = new _cc.Node();
            imageNode.parent = contentNode;
            imageNode.setContentSize(width, width / 16 * 9);
            imageNode.y = (contentNode.height - imageNode.height) / 2.0;
            imageNode.x = (imageNode.width - contentNode.width) / 2.0;
            this.addFillerSprite(imageNode, _cc.color(255, 255, 255, 255));
            this.registerTouchHandler(imageNode, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click imageNode bg");
            });
            let lines = content.split("\n");
            for (let i = 0; i < lines.length; i++) {
                const line = lines[i];
                for (let j = 0; j < line.length; j++) {
                    let char = line[j];
                    let color = null;
                    if (char == " ") {
                        color = null;
                    }
                    else if (char == "@") {
                        color = _cc.color(0, 0, 0, 255);
                    }
                    else if (char == "0") {
                        color = _cc.color(64, 64, 64, 255);
                    }
                    else if (char == "\n" || char == "\r") {
                        continue;
                    }
                    else {
                        color = _cc.color(128, 128, 128, 255);
                    }
                    if (color) {
                        let nodeDot = new _cc.Node();
                        nodeDot.parent = imageNode;
                        nodeDot.setContentSize(2, 3);
                        nodeDot.x = (j - line.length / 2.0) * 2.0;
                        nodeDot.y = (lines.length / 2.0 - i) * 3.0;
                        this.addFillerSprite(nodeDot, color);
                    }
                }
            }
        }
        showTranslucentView() {
            if (this.translucentView) {
                return;
            }
            let nodeCanvas = this.getNodeCanvas();
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(2048, 2048);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX;
            this.translucentView = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeBg, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                console.log("MCPanelCreator:click showTranslucentView bg");
            });
        }
        closeTranslucentView() {
            if (this.translucentView) {
                this.translucentView.destroy();
                this.translucentView = null;
            }
        }
        showMarrsConfigView(title, config, actions, cancelCallback) {
            ULLog.console.log("MCPanelCreator.showMarrsLoginView");
            if (this.marrsView) {
                return;
            }
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.showMarrsLoginView nodeCanvas not found!");
                return;
            }
            config = JSON.parse(JSON.stringify(config));
            let canvasSize = this.getCanvasSize();
            let nodeBg = new _cc.Node();
            nodeBg.parent = nodeCanvas;
            nodeBg.setContentSize(canvasSize.width, canvasSize.height);
            nodeBg.zIndex = _cc.macro.MAX_ZINDEX - 10;
            this.marrsView = nodeBg;
            let nodeShadow = new _cc.Node();
            nodeShadow.parent = nodeBg;
            nodeShadow.setContentSize(nodeBg.getContentSize());
            this.addFillerSprite(nodeShadow, _cc.color(0, 0, 0, 127));
            this.registerTouchHandler(nodeShadow, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("MCPanelCreator:showMarrsLoginView click cancel");
                this.closeMarrsConfigView();
                cancelCallback && cancelCallback();
            });
            let width = Math.min(canvasSize.width, canvasSize.height) * 0.86;
            let height = width / 16 * 12;
            let contentNode = new _cc.Node();
            contentNode.parent = nodeBg;
            contentNode.setContentSize(width, height);
            let nodeContent = new _cc.Node();
            nodeContent.parent = contentNode;
            nodeContent.setContentSize(contentNode.getContentSize());
            this.addFillerSprite(nodeContent, _cc.color(255, 255, 255, 255));
            this.registerTouchHandler(nodeContent, (e) => {
                if (!this.isTouchEventClick(e))
                    return;
                ULLog.console.log("MCPanelCreator:showMarrsLoginView click bg");
            });
            let maskLayout = nodeContent.addComponent(_cc.Layout);
            maskLayout.type = _cc.Layout.Type.VERTICAL;
            maskLayout.resizeMode = _cc.Layout.ResizeMode.CONTAINER;
            let titleNode = new _cc.Node();
            titleNode.color = _cc.color(0, 0, 0, 255);
            titleNode.parent = nodeContent;
            let titleLabel = titleNode.addComponent(_cc.Label);
            titleLabel.string = title;
            titleLabel.fontSize = 32;
            titleLabel.overflow = _cc.Label.Overflow.SHRINK;
            titleLabel.verticalAlign = _cc.Label.VerticalAlign.CENTER;
            titleLabel.horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
            titleNode.setContentSize(width, 70);
            for (let i = 0; i < config.length; i++) {
                const item = config[i];
                let itemNode = new _cc.Node();
                itemNode.parent = nodeContent;
                itemNode.setContentSize(width * 0.9, titleNode.height);
                let labelNode = new _cc.Node();
                labelNode.color = _cc.color(0, 0, 0, 255);
                labelNode.parent = itemNode;
                let label = labelNode.addComponent(_cc.Label);
                label.string = item.name + ":";
                label.fontSize = 24;
                label.lineHeight = 24;
                label.overflow = _cc.Label.Overflow.SHRINK;
                label.verticalAlign = _cc.Label.VerticalAlign.CENTER;
                label.horizontalAlign = _cc.Label.HorizontalAlign.RIGHT;
                labelNode.setContentSize(120, itemNode.height * 0.8);
                labelNode.x = -(itemNode.width - labelNode.width) / 2.0 - 15;
                let editNode = new _cc.Node();
                editNode.parent = itemNode;
                editNode.setContentSize(itemNode.width - labelNode.width, 24);
                editNode.x = -(itemNode.width - editNode.width) / 2.0 + labelNode.width;
                let bgNode = new _cc.Node();
                bgNode.parent = itemNode;
                bgNode.setContentSize(editNode.width + 20, 40);
                bgNode.x = editNode.x;
                this.addFillerSprite(bgNode, _cc.color(0, 100, 0, 127));
                let editBox = editNode.addComponent(_cc.EditBox);
                editBox.fontSize = 24;
                editBox.lineHeight = 24;
                editBox.fontColor = _cc.Color.BLACK;
                editBox.inputMode = _cc.EditBox.InputMode.SINGLE_LINE;
                editBox.maxLength = 100;
                editBox.string = item.value || "";
                editBox.placeholder = "<<输入框>>";
                editBox.placeholderFontSize = 24;
                editBox.placeholderFontColor = _cc.Color.GRAY;
                editBox.node.on("text-changed", () => {
                    item.value = editBox.string;
                    ;
                });
            }
            let buttonNode = new _cc.Node();
            buttonNode.parent = nodeContent;
            titleNode.setAnchorPoint(0.5, 1);
            buttonNode.setContentSize(width, 70);
            let btnWidth = 160;
            let btnHeight = 56;
            let btnGap = 30;
            let left = -(actions.length * btnWidth + (actions.length - 1) * btnGap) / 2;
            for (let i = 0; i < actions.length; i++) {
                let item = actions[i];
                let nodeButton = new _cc.Node();
                nodeButton.parent = buttonNode;
                nodeButton.x = left + btnWidth * (i + 0.5) + btnGap * (i);
                nodeButton.setContentSize(btnWidth, btnHeight);
                let nodeButtonBg = new _cc.Node();
                nodeButtonBg.parent = nodeButton;
                nodeButtonBg.setContentSize(nodeButton.getContentSize());
                _cc.loader.loadRes("_ulsdk_ui/btn_01", _cc.SpriteFrame, (err, spriteFrame) => {
                    if (err) {
                        ULLog.console.warn("MCPanelCreator.showPromptDialog nodeButtonBg load sprite error", err);
                        return;
                    }
                    let nodeSize = nodeButtonBg.getContentSize();
                    let frameSize = spriteFrame.getOriginalSize();
                    spriteFrame.insetLeft = frameSize.width / 3;
                    spriteFrame.insetRight = frameSize.width / 3;
                    spriteFrame.insetTop = frameSize.height / 3;
                    spriteFrame.insetBottom = frameSize.height / 3;
                    let sprite = nodeButtonBg.addComponent(_cc.Sprite);
                    sprite.spriteFrame = spriteFrame;
                    sprite.type = _cc.Sprite.Type.SLICED;
                    sprite.sizeMode = _cc.Sprite.SizeMode.CUSTOM;
                    nodeButtonBg.setContentSize(nodeSize);
                });
                let nodeButtonText = new _cc.Node();
                nodeButtonText.parent = nodeButton;
                nodeButtonText.y = 0;
                nodeButtonText.x = 0;
                nodeButtonText.color = _cc.color(255, 255, 255, 255);
                nodeButtonText.addComponent(_cc.Label).string = item.name;
                nodeButtonText.getComponent(_cc.Label).overflow = _cc.Label.Overflow.SHRINK;
                nodeButtonText.getComponent(_cc.Label).verticalAlign = _cc.Label.VerticalAlign.CENTER;
                nodeButtonText.getComponent(_cc.Label).horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                nodeButtonText.getComponent(_cc.Label).fontSize = 30;
                nodeButtonText.width = nodeButtonBg.width - 10;
                nodeButtonText.height = nodeButtonBg.height - 10;
                this.registerTouchHandler(nodeButton, (e) => {
                    if (!this.isTouchEventClick(e))
                        return;
                    item.action && item.action(config);
                });
            }
        }
        closeMarrsConfigView() {
            if (this.marrsView) {
                this.marrsView.destroy();
                this.marrsView = null;
            }
        }
        refreshDebugInfo(text) {
            ULLog.console.warn("MCPanelCreator.refreshDebugInfo");
            this.debugInfoRenderNode && this.debugInfoRenderNode.destroy();
            if (!text)
                return;
            let nodeCanvas = this.getNodeCanvas();
            if (!nodeCanvas) {
                ULLog.console.warn("MCPanelCreator.refreshDebugInfo nodeCanvas not found!");
                return;
            }
            let nodeDebugInfo = new window["cc"].Node();
            nodeDebugInfo.parent = nodeCanvas;
            nodeDebugInfo.zIndex = window["cc"].macro.MAX_ZINDEX;
            nodeDebugInfo.y = 0;
            nodeDebugInfo.x = 0;
            nodeDebugInfo.width = nodeCanvas.width - 10;
            nodeDebugInfo.setAnchorPoint(0.5, 1);
            nodeDebugInfo.color = window["cc"].Color.RED;
            nodeDebugInfo.addComponent(window["cc"].Label).fontSize = 24;
            nodeDebugInfo.getComponent(window["cc"].Label).enableWrapText = true;
            nodeDebugInfo.getComponent(window["cc"].Label).horizontalAlign = window["cc"].Label.HorizontalAlign.CENTER;
            nodeDebugInfo.getComponent(window["cc"].Label).verticalAlign = window["cc"].Label.VerticalAlign.CENTER;
            nodeDebugInfo.runAction(window["cc"].repeatForever(window["cc"].sequence(window["cc"].fadeTo(1, 63), window["cc"].fadeTo(1, 255))));
            nodeDebugInfo.getComponent(window["cc"].Label).string = text;
            this.debugInfoRenderNode = nodeDebugInfo;
        }
        showSideBarView(style, bReward, gameName, skip) {
            return new Promise((resolve, reject) => {
                let nodeCanvas = this.getNodeCanvas();
                if (!nodeCanvas) {
                    ULLog.console.error("MCPanelCreator2x.showSideBarView nodeCanvas not found!");
                    reject("MCPanelCreator2x.showSideBarView nodeCanvas not found!");
                    return;
                }
                let mStyle = {
                    left: style ? (style['left'] ? style['left'] : 0) : 0,
                    top: style ? (style['top'] ? style['top'] : 0) : 0,
                    width: style ? (style['width'] ? style['width'] : 0) : 0,
                    height: style ? (style['height'] ? style['height'] : 0) : 0,
                };
                const visibleSize = _cc.view.getVisibleSize();
                const screenWidth = visibleSize.width;
                const screenHeight = visibleSize.height;
                let iconNodeWidth = 80;
                let iconNodeHeight = 80;
                if (mStyle['width']) {
                    iconNodeWidth = screenWidth * mStyle['width'];
                    iconNodeHeight = mStyle['height'] ? screenHeight * mStyle['height'] : iconNodeWidth;
                }
                else if (mStyle['height']) {
                    iconNodeHeight = screenHeight * mStyle['height'];
                    iconNodeWidth = iconNodeHeight;
                }
                let iconNode = nodeCanvas.getChildByName("ul_side_bar_btn");
                if (iconNode && !iconNode.active) {
                    iconNode.active = true;
                }
                else {
                    iconNode = new _cc.Node();
                    iconNode.parent = nodeCanvas;
                    iconNode.name = "ul_side_bar_btn";
                    iconNode.addComponent(_cc.Button);
                    iconNode.getComponent(_cc.Button).interactable = true;
                    this.registerTouchHandler(iconNode, (e) => {
                        if (!this.isTouchEventClick(e))
                            return;
                        let nodeParent = new _cc.Node();
                        nodeParent.parent = nodeCanvas;
                        nodeParent.setPosition(0, 0);
                        nodeParent.setContentSize(screenWidth, screenHeight);
                        let nodeBg = new _cc.Node();
                        nodeBg.parent = nodeParent;
                        nodeBg.setPosition(0, 0);
                        nodeBg.setContentSize(nodeParent.getContentSize());
                        nodeBg.opacity = 0;
                        this.registerTouchHandler(nodeBg, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            ULLog.console.log("MCPanelCreator:showSideBarView click bg");
                        });
                        let dialogParent = new _cc.Node();
                        dialogParent.parent = nodeParent;
                        dialogParent.setPosition(0, 0);
                        let dialogParentW = screenWidth < screenHeight ? (3 / 4) * screenWidth : (1 / 2) * screenHeight;
                        let dialogParentH = dialogParentW / 0.7;
                        dialogParent.setContentSize(dialogParentW, dialogParentH);
                        let dialogBg = new _cc.Node();
                        dialogBg.parent = dialogParent;
                        dialogBg.setPosition(0, 0);
                        dialogBg.setContentSize(dialogParent.getContentSize());
                        dialogBg.addComponent(_cc.Sprite);
                        _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_dialog_bg", _cc.SpriteFrame, (err, spriteFrame) => {
                            if (err) {
                                ULLog.console.warn("MCPanelCreator.showSideBarView dialogBg load sprite error", err);
                                reject(`dialogBg load sprite error: ${err}`);
                                return;
                            }
                            let sprite = dialogBg.getComponent(_cc.Sprite);
                            sprite.spriteFrame = spriteFrame;
                            let originalWidth = spriteFrame.getRect().width;
                            let originalHeight = spriteFrame.getRect().height;
                            let aspectRatio = originalWidth / originalHeight;
                            let targetWidth = dialogParent.width;
                            let targetHeight = dialogParent.height;
                            if (targetWidth / targetHeight > aspectRatio) {
                                sprite.node.width = targetHeight * aspectRatio;
                                sprite.node.height = targetHeight;
                            }
                            else {
                                sprite.node.width = targetWidth;
                                sprite.node.height = targetWidth / aspectRatio;
                            }
                            dialogBg.setPosition(0, 0);
                            dialogBg.setContentSize(dialogParent.getContentSize());
                        });
                        let close = new _cc.Node();
                        close.parent = dialogParent;
                        let closeW = dialogParent.getContentSize().width / 9;
                        let closeH = closeW;
                        close.setPosition(dialogParent.getContentSize().width / 2 - closeW / 2 - 5, dialogParent.getContentSize().height / 2 - closeH / 2 - 10);
                        close.setContentSize(closeW, closeH);
                        close.addComponent(_cc.Sprite);
                        _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_close", _cc.SpriteFrame, (err, spriteFrame) => {
                            if (err) {
                                ULLog.console.warn("MCPanelCreator.showSideBarView close load sprite error", err);
                                reject(`close load sprite error: ${err}`);
                                return;
                            }
                            let sprite = close.getComponent(_cc.Sprite);
                            sprite.spriteFrame = spriteFrame;
                            close.setPosition(dialogParent.getContentSize().width / 2 - closeW / 2 - 5, dialogParent.getContentSize().height / 2 - closeH / 2 - 10);
                            close.setContentSize(closeW, closeH);
                        });
                        this.registerTouchHandler(close, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            ULLog.console.log("MCPanelCreator.showSideBarView 点击关闭");
                            nodeCanvas.removeChild(nodeParent);
                        });
                        let gameIcon = new _cc.Node();
                        gameIcon.parent = dialogParent;
                        let gameIconW = dialogParent.getContentSize().width * 0.11;
                        let gameIconH = gameIconW;
                        gameIcon.setPosition(-(dialogParent.getContentSize().width / 2 * 0.42), -(dialogParent.getContentSize().height / 2 * 0.2));
                        gameIcon.setContentSize(gameIconW, gameIconH);
                        gameIcon.addComponent(_cc.Sprite);
                        _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_game_icon", _cc.SpriteFrame, (err, spriteFrame) => {
                            if (err) {
                                ULLog.console.warn("MCPanelCreator.showSideBarView gameIcon load sprite error", err);
                                reject(`gameIcon load sprite error: ${err}`);
                                return;
                            }
                            let sprite = gameIcon.getComponent(_cc.Sprite);
                            sprite.spriteFrame = spriteFrame;
                            gameIcon.setPosition(-(dialogParent.getContentSize().width / 2 * 0.42), -(dialogParent.getContentSize().height / 2 * 0.2));
                            gameIcon.setContentSize(gameIconW, gameIconH);
                        });
                        let appName = new _cc.Node();
                        appName.parent = dialogParent;
                        let appNameW = dialogParent.getContentSize().width * 0.15;
                        let appNameH = appNameW * 0.17;
                        appName.setPosition(-(dialogParent.getContentSize().width / 2 * 0.42), -(dialogParent.getContentSize().height / 2 * 0.325));
                        appName.setContentSize(appNameW, appNameH);
                        appName.addComponent(_cc.Label);
                        appName.color = _cc.Color.BLACK;
                        let appNameLabel = appName.getComponent(_cc.Label);
                        appNameLabel.string = gameName.length > 5 ? gameName.slice(0, 5) + "..." : gameName;
                        appNameLabel.verticalAlign = _cc.Label.VerticalAlign.CENTER;
                        appNameLabel.horizontalAlign = _cc.Label.HorizontalAlign.CENTER;
                        appNameLabel.lineHeight = appNameH;
                        appNameLabel.fontSize = appNameH;
                        if (bReward) {
                            let step3Node = new _cc.Node();
                            step3Node.parent = dialogParent;
                            let step3NodeW = dialogParent.getContentSize().width * 0.32;
                            let step3NodeH = dialogParent.getContentSize().width * 0.08;
                            step3Node.setPosition(-(dialogParent.getContentSize().width / 2 * 0.46), -(dialogParent.getContentSize().height / 2 * 0.48));
                            step3Node.setContentSize(step3NodeW, step3NodeH);
                            step3Node.addComponent(_cc.Sprite);
                            _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_step3", _cc.SpriteFrame, (err, spriteFrame) => {
                                if (err) {
                                    ULLog.console.warn("MCPanelCreator.showSideBarView step3Node load sprite error", err);
                                    reject(`step3Node load sprite error: ${err}`);
                                    return;
                                }
                                let sprite = step3Node.getComponent(_cc.Sprite);
                                sprite.spriteFrame = spriteFrame;
                                step3Node.setPosition(-(dialogParent.getContentSize().width / 2 * 0.46), -(dialogParent.getContentSize().height / 2 * 0.48));
                                step3Node.setContentSize(step3NodeW, step3NodeH);
                            });
                            let step3RewardNode = new _cc.Node();
                            step3RewardNode.parent = dialogParent;
                            let step3RewardNodeW = dialogParent.getContentSize().width * 0.25;
                            let step3RewardNodeH = step3RewardNodeW;
                            step3RewardNode.setPosition(0, -(dialogParent.getContentSize().height / 2 * 0.75));
                            step3RewardNode.setContentSize(step3RewardNodeW, step3RewardNodeH);
                            step3RewardNode.addComponent(_cc.Sprite);
                            _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_reward_icon", _cc.SpriteFrame, (err, spriteFrame) => {
                                if (err) {
                                    ULLog.console.warn("MCPanelCreator.showSideBarView step3RewardNode load sprite error", err);
                                    reject(`step3RewardNode load sprite error: ${err}`);
                                    return;
                                }
                                let sprite = step3RewardNode.getComponent(_cc.Sprite);
                                sprite.spriteFrame = spriteFrame;
                                step3RewardNode.setPosition(0, -(dialogParent.getContentSize().height / 2 * 0.75));
                                step3RewardNode.setContentSize(step3RewardNodeW, step3RewardNodeH);
                            });
                        }
                        let enterButton = new _cc.Node();
                        enterButton.parent = dialogParent;
                        let enterButtonW = dialogParent.getContentSize().width * 0.4;
                        let enterButtonH = enterButtonW / 2.5;
                        enterButton.setPosition(0, -(dialogParent.getContentSize().height / 2 + enterButtonH / 2 + 20));
                        enterButton.setContentSize(enterButtonW, enterButtonH);
                        enterButton.addComponent(_cc.Sprite);
                        _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_enterButton", _cc.SpriteFrame, (err, spriteFrame) => {
                            if (err) {
                                ULLog.console.warn("MCPanelCreator.showSideBarView enterButton load sprite error", err);
                                reject(`enterButton load sprite error: ${err}`);
                                return;
                            }
                            let sprite = enterButton.getComponent(_cc.Sprite);
                            sprite.spriteFrame = spriteFrame;
                            enterButton.setPosition(0, -(dialogParent.getContentSize().height / 2 + enterButtonH / 2 + 20));
                            enterButton.setContentSize(enterButtonW, enterButtonH);
                        });
                        this.registerTouchHandler(enterButton, (e) => {
                            if (!this.isTouchEventClick(e))
                                return;
                            ULLog.console.log("MCPanelCreator.showSideBarView 点击跳转");
                            skip && skip();
                        });
                    });
                    _cc.loader.loadRes("_ulsdk_ui/sidebar/ul_sidebar_icon", _cc.SpriteFrame, (err, spriteFrame) => {
                        if (err) {
                            ULLog.console.warn("MCPanelCreator.showSideBarView iconNode load sprite error", err);
                            iconNode.active = false;
                            reject(`iconNode load sprite error: ${err}`);
                            return;
                        }
                        let sprite = iconNode.addComponent(_cc.Sprite);
                        sprite.spriteFrame = spriteFrame;
                        iconNode.setContentSize(iconNodeWidth, iconNodeHeight);
                        iconNode.setPosition(screenWidth * mStyle['left'] + iconNodeWidth / 2, screenHeight * mStyle['top'] + iconNodeHeight / 2);
                    });
                }
                iconNode.setContentSize(iconNodeWidth, iconNodeHeight);
                iconNode.setPosition(screenWidth * mStyle['left'] + iconNodeWidth / 2, screenHeight * mStyle['top'] + iconNodeHeight / 2);
                resolve();
            });
        }
        hideSideBarView() {
            return new Promise((resolve, reject) => {
                let nodeCanvas = this.getNodeCanvas();
                let iconNode = nodeCanvas.getChildByName("ul_side_bar_btn");
                iconNode && (iconNode.active = false);
                resolve();
            });
        }
    }

    const BUTTON_WIDTH$1 = 150;
    const BUTTON_HEIGHT$1 = 40;
    const NEW_LINE_HEIGHT$1 = 20;
    const FONT_SIZE$1 = 20;
    const PENDING$1 = 10;
    const GAP$1 = 4;
    class MCPanelLaya {
        constructor() {
            this.nodeReferenceRects = {};
          