(function () {
    'use strict';

    let ui_fit_width = 100;
    let ui_fit_height = 100;
    let canvas_width = 100;
    let canvas_height = 100;
    const B_FILL_DEVICE = true;
    class UIRoot extends Laya.Script {
        constructor() {
            super(...arguments);
            this.standardShort = 576;
            this.standardLong = 1024;
            this.uiMinRate = 0.4;
            this.maxRate = 0.75;
            this.canvasMinRate = 0.44;
            this.layerNode = [];
        }
        static get canvasWidth() {
            return canvas_width;
        }
        static get canvasHeight() {
            return canvas_height;
        }
        static get uiFitWidth() {
            return ui_fit_width;
        }
        static get uiFitHeight() {
            return ui_fit_height;
        }
        static get uiFitTop() {
            return ui_fit_height < canvas_height ? (canvas_height - ui_fit_height) / 2 : 0;
        }
        static get uiFitLeft() {
            return ui_fit_width < canvas_width ? (canvas_width - ui_fit_width) / 2 : 0;
        }
        static get canvasCenterX() {
            return canvas_width / 2;
        }
        static get canvasCenterY() {
            return canvas_height / 2;
        }
        onAwake() {
            this.fixScreenResolution();
            UIRoot.instance = this;
        }
        onDestroy() {
            UIRoot.instance = null;
            if (super.onDestroy) {
                super.onDestroy();
            }
        }
        fixScreenResolution() {
            let frameSize = new Laya.Vector2(Laya.Browser.width, Laya.Browser.height);
            console.log("frame size:", frameSize.x, frameSize.y);
            let bPortrait = false;
            if (true) {
                bPortrait = true;
            }
            let standardRate = this.standardShort / this.standardLong;
            let frameRate;
            if (bPortrait) {
                frameRate = frameSize.x / frameSize.y;
            }
            else {
                frameRate = frameSize.y / frameSize.x;
            }
            let policy;
            let short, long;
            let shortFull, longFull;
            if (frameRate < standardRate) {
                if (frameRate < this.uiMinRate) {
                    long = this.standardLong * (standardRate / this.uiMinRate);
                    longFull = Math.floor(this.standardLong * (standardRate / frameRate));
                    let maxLong = Math.floor(this.standardLong * (standardRate / this.canvasMinRate));
                    longFull = Math.min(longFull, maxLong);
                    policy = Laya.Stage.SCALE_SHOWALL;
                    console.log(`长边超出：重置长边 ${long}`);
                }
                else {
                    long = this.standardLong * (standardRate / frameRate);
                    longFull = long;
                    if (bPortrait) {
                        policy = Laya.Stage.SCALE_FIXED_WIDTH;
                    }
                    else {
                        policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                    }
                    console.log(`短边适配:${long}`);
                }
                long = Math.floor(long);
                short = this.standardShort;
                shortFull = short;
            }
            else if (frameRate > standardRate) {
                if (frameRate > this.maxRate) {
                    short = this.standardShort * (this.maxRate / standardRate);
                    shortFull = Math.floor(this.standardShort * (frameRate / standardRate));
                    shortFull = short;
                    policy = Laya.Stage.SCALE_SHOWALL;
                    console.log(`短边超出：重置短边 ${short}`);
                }
                else {
                    short = this.standardShort * (frameRate / standardRate);
                    shortFull = short;
                    if (bPortrait) {
                        policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                    }
                    else {
                        policy = Laya.Stage.SCALE_FIXED_WIDTH;
                    }
                    console.log(`长边适配:${short}`);
                }
                short = Math.floor(short);
                long = this.standardLong;
                longFull = long;
            }
            else {
                console.log("默认适配");
                short = this.standardShort;
                long = this.standardLong;
                shortFull = short;
                longFull = long;
                if (bPortrait) {
                    policy = Laya.Stage.SCALE_FIXED_WIDTH;
                }
                else {
                    policy = Laya.Stage.SCALE_FIXED_HEIGHT;
                }
            }
            if (bPortrait) {
                ui_fit_width = short;
                ui_fit_height = long;
                canvas_width = B_FILL_DEVICE ? shortFull : ui_fit_width;
                canvas_height = B_FILL_DEVICE ? longFull : ui_fit_height;
                UIRoot._designWidth = this.standardShort;
                UIRoot._designHeight = this.standardLong;
            }
            else {
                ui_fit_width = long;
                ui_fit_height = short;
                canvas_width = B_FILL_DEVICE ? longFull : ui_fit_width;
                canvas_height = B_FILL_DEVICE ? shortFull : ui_fit_height;
                UIRoot._designWidth = this.standardLong;
                UIRoot._designHeight = this.standardShort;
            }
            console.log("cur fit size:", ui_fit_width, ui_fit_height);
            console.log("cur full size:", canvas_width, canvas_height);
            Laya.stage.width = canvas_width;
            Laya.stage.height = canvas_height;
            Laya.stage.scaleMode = Laya.Stage.SCALE_SHOWALL;
            Laya.stage.screenMode = Laya.Stage.SCREEN_NONE;
            Laya.stage.alignH = Laya.Stage.ALIGN_CENTER;
            Laya.stage.alignV = Laya.Stage.ALIGN_MIDDLE;
            this.owner.size(canvas_width, canvas_height);
        }
        static get designWidth() {
            return this._designWidth;
        }
        static get designHeight() {
            return this._designHeight;
        }
    }

    let cur_log_level = 3;
    let EMPTY_FUN = function () { };
    class Logger {
        static catchError(userMessage, error) {
            let errorStr = this.getErrorStr(error);
            this.error(`[${userMessage} error]:\n${errorStr}`);
        }
        static getErrorStr(error) {
            if (error instanceof Error) {
                return `message:${error.message} stack:${error.stack}`;
            }
            else {
                if (error) {
                    return JSON.stringify(error);
                }
                else {
                    return error.toString();
                }
            }
        }
        static setLogLevel(level) {
            cur_log_level = level;
            level >= 3 ? Logger.debug = console.log : EMPTY_FUN;
            level >= 2 ? Logger.log = console.log : EMPTY_FUN;
            level >= 1 ? Logger.warn = console.warn : EMPTY_FUN;
            level >= 0 ? Logger.error = console.error : EMPTY_FUN;
        }
        static get isDebugLevel() {
            return cur_log_level == 3;
        }
    }
    Logger.log = console.log;
    Logger.debug = console.log;
    Logger.warn = console.warn;
    Logger.error = console.error;

    function safeAdd(x, y) {
        var lsw = (x & 0xffff) + (y & 0xffff);
        var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xffff);
    }
    function bitRotateLeft(num, cnt) {
        return (num << cnt) | (num >>> (32 - cnt));
    }
    function md5cmn(q, a, b, x, s, t) {
        return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
    }
    function md5ff(a, b, c, d, x, s, t) {
        return md5cmn((b & c) | (~b & d), a, b, x, s, t);
    }
    function md5gg(a, b, c, d, x, s, t) {
        return md5cmn((b & d) | (c & ~d), a, b, x, s, t);
    }
    function md5hh(a, b, c, d, x, s, t) {
        return md5cmn(b ^ c ^ d, a, b, x, s, t);
    }
    function md5ii(a, b, c, d, x, s, t) {
        return md5cmn(c ^ (b | ~d), a, b, x, s, t);
    }
    function binlMD5(x, len) {
        x[len >> 5] |= 0x80 << (len % 32);
        x[((len + 64) >>> 9 << 4) + 14] = len;
        var i;
        var olda;
        var oldb;
        var oldc;
        var oldd;
        var a = 1732584193;
        var b = -271733879;
        var c = -1732584194;
        var d = 271733878;
        for (i = 0; i < x.length; i += 16) {
            olda = a;
            oldb = b;
            oldc = c;
            oldd = d;
            a = md5ff(a, b, c, d, x[i], 7, -680876936);
            d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);
            c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);
            b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);
            a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);
            d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);
            c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);
            b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);
            a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);
            d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);
            c = md5ff(c, d, a, b, x[i + 10], 17, -42063);
            b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);
            a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);
            d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);
            c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);
            b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);
            a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);
            d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);
            c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);
            b = md5gg(b, c, d, a, x[i], 20, -373897302);
            a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);
            d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);
            c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);
            b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);
            a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);
            d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);
            c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);
            b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);
            a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);
            d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);
            c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);
            b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);
            a = md5hh(a, b, c, d, x[i + 5], 4, -378558);
            d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);
            c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);
            b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);
            a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);
            d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);
            c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);
            b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);
            a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);
            d = md5hh(d, a, b, c, x[i], 11, -358537222);
            c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);
            b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);
            a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);
            d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);
            c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);
            b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);
            a = md5ii(a, b, c, d, x[i], 6, -198630844);
            d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);
            c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);
            b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);
            a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);
            d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);
            c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);
            b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);
            a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);
            d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);
            c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);
            b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);
            a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);
            d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);
            c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);
            b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);
            a = safeAdd(a, olda);
            b = safeAdd(b, oldb);
            c = safeAdd(c, oldc);
            d = safeAdd(d, oldd);
        }
        return [a, b, c, d];
    }
    function binl2rstr(input) {
        var i;
        var output = '';
        var length32 = input.length * 32;
        for (i = 0; i < length32; i += 8) {
            output += String.fromCharCode((input[i >> 5] >>> (i % 32)) & 0xff);
        }
        return output;
    }
    function rstr2binl(input) {
        var i;
        var output = [];
        output[(input.length >> 2) - 1] = undefined;
        for (i = 0; i < output.length; i += 1) {
            output[i] = 0;
        }
        var length8 = input.length * 8;
        for (i = 0; i < length8; i += 8) {
            output[i >> 5] |= (input.charCodeAt(i / 8) & 0xff) << (i % 32);
        }
        return output;
    }
    function rstrMD5(s) {
        return binl2rstr(binlMD5(rstr2binl(s), s.length * 8));
    }
    function rstrHMACMD5(key, data) {
        var i;
        var bkey = rstr2binl(key);
        var ipad = [];
        var opad = [];
        var hash;
        ipad[15] = opad[15] = undefined;
        if (bkey.length > 16) {
            bkey = binlMD5(bkey, key.length * 8);
        }
        for (i = 0; i < 16; i += 1) {
            ipad[i] = bkey[i] ^ 0x36363636;
            opad[i] = bkey[i] ^ 0x5c5c5c5c;
        }
        hash = binlMD5(ipad.concat(rstr2binl(data)), 512 + data.length * 8);
        return binl2rstr(binlMD5(opad.concat(hash), 512 + 128));
    }
    function rstr2hex(input) {
        var hexTab = '0123456789abcdef';
        var output = '';
        var x;
        var i;
        for (i = 0; i < input.length; i += 1) {
            x = input.charCodeAt(i);
            output += hexTab.charAt((x >>> 4) & 0x0f) + hexTab.charAt(x & 0x0f);
        }
        return output;
    }
    function str2rstrUTF8(input) {
        return unescape(encodeURIComponent(input));
    }
    function rawMD5(s) {
        return rstrMD5(str2rstrUTF8(s));
    }
    function hexMD5(s) {
        return rstr2hex(rawMD5(s));
    }
    function rawHMACMD5(k, d) {
        return rstrHMACMD5(str2rstrUTF8(k), str2rstrUTF8(d));
    }
    function hexHMACMD5(k, d) {
        return rstr2hex(rawHMACMD5(k, d));
    }
    function md5(string, key, raw) {
        if (!key) {
            if (!raw) {
                return hexMD5(string);
            }
            return rawMD5(string);
        }
        if (!raw) {
            return hexHMACMD5(key, string);
        }
        return rawHMACMD5(key, string);
    }

    const Base64 = (function () {
        const version = '3.5.2';
        const VERSION = version;
        const _hasatob = typeof atob === 'function';
        const _hasbtoa = typeof btoa === 'function';
        const _hasBuffer = typeof Buffer === 'function';
        const _TD = typeof TextDecoder === 'function' ? new TextDecoder() : undefined;
        const _TE = typeof TextEncoder === 'function' ? new TextEncoder() : undefined;
        const b64ch = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
        const b64chs = [...b64ch];
        const b64tab = ((a) => {
            let tab = {};
            a.forEach((c, i) => tab[c] = i);
            return tab;
        })(b64chs);
        const b64re = /^(?:[A-Za-z\d+\/]{4})*?(?:[A-Za-z\d+\/]{2}(?:==)?|[A-Za-z\d+\/]{3}=?)?$/;
        const _fromCC = String.fromCharCode.bind(String);
        const _U8Afrom = typeof Uint8Array.from === 'function'
            ? Uint8Array.from.bind(Uint8Array)
            : (it, fn = (x) => x) => new Uint8Array(Array.prototype.slice.call(it, 0).map(fn));
        const _mkUriSafe = (src) => src
            .replace(/[+\/]/g, (m0) => m0 == '+' ? '-' : '_')
            .replace(/=+$/m, '');
        const _tidyB64 = (s) => s.replace(/[^A-Za-z0-9\+\/]/g, '');
        const btoaPolyfill = (bin) => {
            let u32, c0, c1, c2, asc = '';
            const pad = bin.length % 3;
            for (let i = 0; i < bin.length;) {
                if ((c0 = bin.charCodeAt(i++)) > 255 ||
                    (c1 = bin.charCodeAt(i++)) > 255 ||
                    (c2 = bin.charCodeAt(i++)) > 255)
                    throw new TypeError('invalid character found');
                u32 = (c0 << 16) | (c1 << 8) | c2;
                asc += b64chs[u32 >> 18 & 63]
                    + b64chs[u32 >> 12 & 63]
                    + b64chs[u32 >> 6 & 63]
                    + b64chs[u32 & 63];
            }
            return pad ? asc.slice(0, pad - 3) + "===".substring(pad) : asc;
        };
        const _btoa = _hasbtoa ? (bin) => btoa(bin)
            : _hasBuffer ? (bin) => Buffer.from(bin, 'binary').toString('base64')
                : btoaPolyfill;
        const _fromUint8Array = _hasBuffer
            ? (u8a) => Buffer.from(u8a).toString('base64')
            : (u8a) => {
                const maxargs = 0x1000;
                let strs = [];
                for (let i = 0, l = u8a.length; i < l; i += maxargs) {
                    strs.push(_fromCC.apply(null, u8a.subarray(i, i + maxargs)));
                }
                return _btoa(strs.join(''));
            };
        const fromUint8Array = (u8a, urlsafe = false) => urlsafe ? _mkUriSafe(_fromUint8Array(u8a)) : _fromUint8Array(u8a);
        const cb_utob = (c) => {
            if (c.length < 2) {
                var cc = c.charCodeAt(0);
                return cc < 0x80 ? c
                    : cc < 0x800 ? (_fromCC(0xc0 | (cc >>> 6))
                        + _fromCC(0x80 | (cc & 0x3f)))
                        : (_fromCC(0xe0 | ((cc >>> 12) & 0x0f))
                            + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                            + _fromCC(0x80 | (cc & 0x3f)));
            }
            else {
                var cc = 0x10000
                    + (c.charCodeAt(0) - 0xD800) * 0x400
                    + (c.charCodeAt(1) - 0xDC00);
                return (_fromCC(0xf0 | ((cc >>> 18) & 0x07))
                    + _fromCC(0x80 | ((cc >>> 12) & 0x3f))
                    + _fromCC(0x80 | ((cc >>> 6) & 0x3f))
                    + _fromCC(0x80 | (cc & 0x3f)));
            }
        };
        const re_utob = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g;
        const utob = (u) => u.replace(re_utob, cb_utob);
        const _encode = _hasBuffer
            ? (s) => Buffer.from(s, 'utf8').toString('base64')
            : _TE
                ? (s) => _fromUint8Array(_TE.encode(s))
                : (s) => _btoa(utob(s));
        const encode = (src, urlsafe = false) => urlsafe
            ? _mkUriSafe(_encode(src))
            : _encode(src);
        const encodeURI = (src) => encode(src, true);
        const re_btou = /[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3}/g;
        const cb_btou = (cccc) => {
            switch (cccc.length) {
                case 4:
                    var cp = ((0x07 & cccc.charCodeAt(0)) << 18)
                        | ((0x3f & cccc.charCodeAt(1)) << 12)
                        | ((0x3f & cccc.charCodeAt(2)) << 6)
                        | (0x3f & cccc.charCodeAt(3)), offset = cp - 0x10000;
                    return (_fromCC((offset >>> 10) + 0xD800)
                        + _fromCC((offset & 0x3FF) + 0xDC00));
                case 3:
                    return _fromCC(((0x0f & cccc.charCodeAt(0)) << 12)
                        | ((0x3f & cccc.charCodeAt(1)) << 6)
                        | (0x3f & cccc.charCodeAt(2)));
                default:
                    return _fromCC(((0x1f & cccc.charCodeAt(0)) << 6)
                        | (0x3f & cccc.charCodeAt(1)));
            }
        };
        const btou = (b) => b.replace(re_btou, cb_btou);
        const atobPolyfill = (asc) => {
            asc = asc.replace(/\s+/g, '');
            if (!b64re.test(asc))
                throw new TypeError('malformed base64.');
            asc += '=='.slice(2 - (asc.length & 3));
            let u24, bin = '', r1, r2;
            for (let i = 0; i < asc.length;) {
                u24 = b64tab[asc.charAt(i++)] << 18
                    | b64tab[asc.charAt(i++)] << 12
                    | (r1 = b64tab[asc.charAt(i++)]) << 6
                    | (r2 = b64tab[asc.charAt(i++)]);
                bin += r1 === 64 ? _fromCC(u24 >> 16 & 255)
                    : r2 === 64 ? _fromCC(u24 >> 16 & 255, u24 >> 8 & 255)
                        : _fromCC(u24 >> 16 & 255, u24 >> 8 & 255, u24 & 255);
            }
            return bin;
        };
        const _atob = _hasatob ? (asc) => atob(_tidyB64(asc))
            : _hasBuffer ? (asc) => Buffer.from(asc, 'base64').toString('binary')
                : atobPolyfill;
        const _toUint8Array = _hasBuffer
            ? (a) => _U8Afrom(Buffer.from(a, 'base64'))
            : (a) => _U8Afrom(_atob(a), c => c.charCodeAt(0));
        const toUint8Array = (a) => _toUint8Array(_unURI(a));
        const _decode = _hasBuffer
            ? (a) => Buffer.from(a, 'base64').toString('utf8')
            : _TD
                ? (a) => _TD.decode(_toUint8Array(a))
                : (a) => btou(_atob(a));
        const _unURI = (a) => _tidyB64(a.replace(/[-_]/g, (m0) => m0 == '-' ? '+' : '/'));
        const decode = (src) => _decode(_unURI(src));
        const _noEnum = (v) => {
            return {
                value: v, enumerable: false, writable: true, configurable: true
            };
        };
        const extendString = function () {
            const _add = (name, body) => Object.defineProperty(String.prototype, name, _noEnum(body));
            _add('fromBase64', function () { return decode(this); });
            _add('toBase64', function (urlsafe) { return encode(this, urlsafe); });
            _add('toBase64URI', function () { return encode(this, true); });
            _add('toBase64URL', function () { return encode(this, true); });
            _add('toUint8Array', function () { return toUint8Array(this); });
        };
        const extendUint8Array = function () {
            const _add = (name, body) => Object.defineProperty(Uint8Array.prototype, name, _noEnum(body));
            _add('toBase64', function (urlsafe) { return fromUint8Array(this, urlsafe); });
            _add('toBase64URI', function () { return fromUint8Array(this, true); });
            _add('toBase64URL', function () { return fromUint8Array(this, true); });
        };
        const extendBuiltins = () => {
            extendString();
            extendUint8Array();
        };
        return {
            version: version,
            VERSION: VERSION,
            atob: _atob,
            atobPolyfill: atobPolyfill,
            btoa: _btoa,
            btoaPolyfill: btoaPolyfill,
            encode: encode,
            encodeURI: encodeURI,
            utob: utob,
            btou: btou,
            decode: decode,
            fromUint8Array: fromUint8Array,
            toUint8Array: toUint8Array,
            extendString: extendString,
            extendUint8Array: extendUint8Array,
            extendBuiltins: extendBuiltins,
        };
    })();

    let _convert = function (match, nosign) {
        if (nosign) {
            match.sign = '';
        }
        else {
            match.sign = match.negative ? '-' : match.sign;
        }
        var l = match.min - match.argument.length + 1 - match.sign.length;
        var pad = new Array(l < 0 ? 0 : l).join(match.pad);
        if (!match.left) {
            if (match.pad == "0" || nosign) {
                return match.sign + pad + match.argument;
            }
            else {
                return pad + match.sign + match.argument;
            }
        }
        else {
            if (match.pad == "0" || nosign) {
                return match.sign + match.argument + pad.replace(/0/g, ' ');
            }
            else {
                return match.sign + match.argument + pad;
            }
        }
    };
    function sprintf(...args) {
        if (typeof args == "undefined") {
            return null;
        }
        if (args.length < 1) {
            return null;
        }
        if (typeof args[0] != "string") {
            return null;
        }
        if (typeof RegExp == "undefined") {
            return null;
        }
        var string = args[0];
        var exp = new RegExp(/(%([%]|(\-)?(\+|\x20)?(0)?(\d+)?(\.(\d)?)?([bcdfosxX])))/g);
        var matches = new Array();
        var strings = new Array();
        var convCount = 0;
        var stringPosStart = 0;
        var stringPosEnd = 0;
        var matchPosEnd = 0;
        var newString = '';
        var match = null;
        while (match = exp.exec(string)) {
            if (match[9]) {
                convCount += 1;
            }
            stringPosStart = matchPosEnd;
            stringPosEnd = exp.lastIndex - match[0].length;
            strings[strings.length] = string.substring(stringPosStart, stringPosEnd);
            matchPosEnd = exp.lastIndex;
            matches[matches.length] = {
                match: match[0],
                left: match[3] ? true : false,
                sign: match[4] || '',
                pad: match[5] || ' ',
                min: match[6] || 0,
                precision: match[8],
                code: match[9] || '%',
                negative: parseInt(args[convCount]) < 0 ? true : false,
                argument: String(args[convCount])
            };
        }
        strings[strings.length] = string.substring(matchPosEnd);
        if (matches.length == 0) {
            return string;
        }
        if ((args.length - 1) < convCount) {
            return null;
        }
        var code = null;
        var match = null;
        var substitution = null;
        var i = null;
        for (i = 0; i < matches.length; i++) {
            if (matches[i].code == '%') {
                substitution = '%';
            }
            else if (matches[i].code == 'b') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(2));
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'c') {
                matches[i].argument = String(String.fromCharCode(Math.abs(parseInt(matches[i].argument))));
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'd') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'f') {
                matches[i].argument = String(Math.abs(parseFloat(matches[i].argument)).toFixed(matches[i].precision ? matches[i].precision : 6));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'o') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(8));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 's') {
                matches[i].argument = matches[i].argument.substring(0, matches[i].precision ? matches[i].precision : matches[i].argument.length);
                substitution = _convert(matches[i], true);
            }
            else if (matches[i].code == 'x') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                substitution = _convert(matches[i]);
            }
            else if (matches[i].code == 'X') {
                matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                substitution = _convert(matches[i]).toUpperCase();
            }
            else {
                substitution = matches[i].match;
            }
            newString += strings[i];
            newString += substitution;
        }
        newString += strings[i];
        return newString;
    }

    const _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    const lookup = new Uint8Array(256);
    for (let i = 0; i < _keyStr.length; i++) {
        lookup[_keyStr.charCodeAt(i)] = i;
    }
    class Base64Plus {
        static get nativeBase64() {
            return false;
        }
        static decode(base64) {
            base64 = base64.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            if (this.nativeBase64) {
                return window.atob(base64);
            }
            else {
                var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
                while (i < base64.length) {
                    enc1 = _keyStr.indexOf(base64.charAt(i++));
                    enc2 = _keyStr.indexOf(base64.charAt(i++));
                    enc3 = _keyStr.indexOf(base64.charAt(i++));
                    enc4 = _keyStr.indexOf(base64.charAt(i++));
                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;
                    output.push(String.fromCharCode(chr1));
                    if (enc3 !== 64) {
                        output.push(String.fromCharCode(chr2));
                    }
                    if (enc4 !== 64) {
                        output.push(String.fromCharCode(chr3));
                    }
                }
                output = output.join("");
                return this._utf8_decode(output);
            }
        }
        static encode(input) {
            input = this._utf8_encode(input);
            if (this.nativeBase64) {
                window.btoa(input);
            }
            else {
                var output = [], chr1, chr2, chr3, enc1, enc2, enc3, enc4, i = 0;
                while (i < input.length) {
                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);
                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;
                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    }
                    else if (isNaN(chr3)) {
                        enc4 = 64;
                    }
                    output.push(_keyStr.charAt(enc1));
                    output.push(_keyStr.charAt(enc2));
                    output.push(_keyStr.charAt(enc3));
                    output.push(_keyStr.charAt(enc4));
                }
                output = output.join("");
                return output;
            }
        }
        static encodeArrayBuffer(arraybuffer) {
            var bytes = new Uint8Array(arraybuffer), i, len = bytes["length"], base64 = "";
            for (i = 0; i < len; i += 3) {
                base64 += _keyStr[bytes[i] >> 2];
                base64 += _keyStr[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
                base64 += _keyStr[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
                base64 += _keyStr[bytes[i + 2] & 63];
            }
            if ((len % 3) === 2) {
                base64 = base64.substring(0, base64.length - 1) + "=";
            }
            else if (len % 3 === 1) {
                base64 = base64.substring(0, base64.length - 2) + "==";
            }
            return base64;
        }
        static decodeArrayBuffer(base64) {
            var bufferLength = base64.length * 0.75, len = base64.length, i, p = 0, encoded1, encoded2, encoded3, encoded4;
            if (base64[base64.length - 1] === "=") {
                bufferLength--;
                if (base64[base64.length - 2] === "=") {
                    bufferLength--;
                }
            }
            var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
            for (i = 0; i < len; i += 4) {
                encoded1 = lookup[base64.charCodeAt(i)];
                encoded2 = lookup[base64.charCodeAt(i + 1)];
                encoded3 = lookup[base64.charCodeAt(i + 2)];
                encoded4 = lookup[base64.charCodeAt(i + 3)];
                bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
                bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
                bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
            }
            return arraybuffer;
        }
        static decodeToUnit32Array(base64, bytes) {
            bytes = bytes || 1;
            var dec = Base64Plus.decode(base64), i, j, len;
            var ar = new Uint32Array(dec.length / bytes);
            for (i = 0, len = dec.length / bytes; i < len; i++) {
                ar[i] = 0;
                for (j = bytes - 1; j >= 0; --j) {
                    ar[i] += dec.charCodeAt((i * bytes) + j) << (j << 3);
                }
            }
            return ar;
        }
        static removePaddingChars(base64) {
            var lkey = _keyStr.indexOf(base64.charAt(base64.length - 1));
            if (lkey == 64) {
                return base64.substring(0, base64.length - 1);
            }
            return base64;
        }
        static decodeToUnit8Array(base64, arrayBuffer) {
            base64 = this.removePaddingChars(base64);
            base64 = this.removePaddingChars(base64);
            var bytes = Math.floor(base64.length / 4 * 3);
            let uarray;
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            var j = 0;
            if (arrayBuffer)
                uarray = new Uint8Array(arrayBuffer);
            else
                uarray = new Uint8Array(bytes);
            base64 = base64.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            for (i = 0; i < bytes; i += 3) {
                enc1 = _keyStr.indexOf(base64.charAt(j++));
                enc2 = _keyStr.indexOf(base64.charAt(j++));
                enc3 = _keyStr.indexOf(base64.charAt(j++));
                enc4 = _keyStr.indexOf(base64.charAt(j++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                uarray[i] = chr1;
                if (enc3 != 64)
                    uarray[i + 1] = chr2;
                if (enc4 != 64)
                    uarray[i + 2] = chr3;
            }
            return uarray;
        }
        static decodeToArrayBuffer(base64) {
            var bytes = Math.floor((base64.length / 4) * 3);
            var ab = new ArrayBuffer(bytes);
            this.decodeToUnit8Array(base64, ab);
            return ab;
        }
        static _utf8_encode(input) {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            return utftext;
        }
        static _utf8_decode(utftext) {
            var string = "";
            var i = 0;
            var c = 0;
            var c1 = 0;
            var c2 = 0;
            var c3 = 0;
            while (i < utftext.length) {
                c = utftext.charCodeAt(i);
                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                }
                else if ((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i + 1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                }
                else {
                    c2 = utftext.charCodeAt(i + 1);
                    c3 = utftext.charCodeAt(i + 2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }
            }
            return string;
        }
    }

    let pako$1 = window["pako"];
    function _dump(arr, level) {
        let dumped_text = "";
        if (!level)
            level = 0;
        let level_padding = "";
        for (let j = 0; j < level + 1; j++)
            level_padding += "    ";
        if (arr instanceof Array) {
            for (let i = 0; i < arr.length; i++) {
                let value = arr[i];
                if (typeof (value) == 'object') {
                    dumped_text += level_padding + i + " ...\n";
                    dumped_text += _dump(value, level + 1);
                }
                else {
                    if (typeof value == "number") {
                        dumped_text += level_padding + i + " => " + value + "\n";
                    }
                    else {
                        dumped_text += level_padding + i + " => \"" + value + "\"\n";
                    }
                }
            }
        }
        else if (typeof arr == "object") {
            for (let item in arr) {
                let value = arr[item];
                if (typeof (value) == 'object') {
                    dumped_text += level_padding + "'" + item + "' ...\n";
                    dumped_text += _dump(value, level + 1);
                }
                else {
                    if (typeof value == "number") {
                        dumped_text += level_padding + "'" + item + "' => " + value + "\n";
                    }
                    else {
                        dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
                    }
                }
            }
        }
        else {
            dumped_text = "===>" + arr + "<===(" + typeof (arr) + ")";
        }
        return dumped_text;
    }
    class Tools {
        static gameExecuteTime() {
            return this.gameRuingTime;
        }
        static autoIncrementRuingTime() {
            if (!this.gameRuingTime) {
                this.gameRuingTime = 0;
            }
            this.gameRuingTime += Math.min(this.delta(), 1);
        }
        static delta() {
            return Laya.timer.delta / 1000 * this.timeScale;
        }
        static forward(transform, pos) {
            let delta = new Laya.Vector3();
            Laya.Vector3.subtract(pos, transform.position, delta);
            let targetPos = new Laya.Vector3();
            Laya.Vector3.subtract(transform.position, delta, targetPos);
            transform.lookAt(targetPos, new Laya.Vector3(0, 1, 0), false);
        }
        static forwardDirection(transform, dir) {
            let targetPos = new Laya.Vector3();
            Laya.Vector3.subtract(transform.position, dir, targetPos);
            transform.lookAt(targetPos, new Laya.Vector3(0, 1, 0), false);
        }
        static isOneDay(seconds1, seconds2) {
            let d1 = new Date(seconds1 * 1000);
            let d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate();
        }
        static random(min, max) {
            if (min == null && max == null) {
                return Math.random();
            }
            else if (max == null) {
                return Math.floor(Math.random() * min + 1);
            }
            else {
                return Math.floor(Math.random() * (max - min + 1) + min);
            }
        }
        static getMidnightTime(second) {
            let dNow;
            if (second == null) {
                dNow = new Date(Date.now());
            }
            else {
                dNow = new Date(second * 1000);
            }
            dNow.setHours(0, 0, 0, 0);
            return dNow.getTime() / 1000;
        }
        static getObjSize(obj) {
            if (!obj) {
                return 0;
            }
            if (Array.isArray(obj)) {
                return obj.length;
            }
            let count = 0;
            Tools.forEachMap(obj, (k, v) => {
                count++;
            });
            return count;
        }
        static forEachMap(map, callback) {
            if (!map)
                return;
            var keys = Object.keys(map);
            var key, value;
            for (var i = 0, count = keys.length; i < count; i++) {
                key = keys[i];
                value = map[key];
                if (value != null) {
                    if (callback(key, value))
                        break;
                }
            }
        }
        static clearNullValue(map) {
            var keys = Object.keys(map);
            var key, value;
            for (var i = 0, count = keys.length; i < count; i++) {
                key = keys[i];
                value = map[key];
                if (value == null) {
                    delete map[key];
                }
            }
        }
        static splitToInt(input, separator) {
            if (!input || !separator) {
                return [];
            }
            let arr = input.split(separator);
            let narr = [];
            for (let i = 0; i < arr.length; i++) {
                narr[i] = this.safeParseInt(arr[i], null);
            }
            return narr;
        }
        static splitToNumber(input, separator) {
            if (!input || !separator) {
                return [];
            }
            let arr = input.split(separator);
            let narr = [];
            for (let i = 0; i < arr.length; i++) {
                narr[i] = this.safeParseFloat(arr[i], null);
            }
            return narr;
        }
        static formatNumber(num, fillStr, limitCount) {
            num = Math.floor(num);
            let calcNum = num;
            let numLen = 1;
            while (true) {
                calcNum /= 10;
                if (calcNum >= 1) {
                    numLen++;
                }
                else {
                    break;
                }
            }
            if (numLen >= limitCount) {
                return num.toString();
            }
            else {
                let fillCount = limitCount - numLen;
                let result = "";
                for (let i = 0; i < fillCount; i++) {
                    result += fillStr;
                }
                return result + num;
            }
        }
        static _formatTime(time, format) {
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.floor(time) % 60;
            if (format.match("%h")) {
                format = format.replace("%h", hour.toString());
            }
            if (format.match("%H")) {
                format = format.replace("%h", Tools.formatNumber(hour, "0", 2));
            }
            if (format.match("%m")) {
                format = format.replace("%m", minute.toString());
            }
            if (format.match("%M")) {
                format = format.replace("%M", Tools.formatNumber(minute, "0", 2));
            }
            if (format.match("%s")) {
                format = format.replace("%s", second.toString());
            }
            if (format.match("%S")) {
                format = format.replace("%S", Tools.formatNumber(second, "0", 2));
            }
            return format;
        }
        static formatTime(time) {
            time = Math.ceil(time);
            if (time <= 0)
                return "00:00";
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.ceil(time) % 60;
            let result = "";
            if (hour > 0) {
                result = hour + ":";
            }
            if (minute > 9) {
                result = `${result}${minute}:`;
            }
            else {
                result = `${result}0${minute}:`;
            }
            if (second > 9) {
                result = `${result}${second}`;
            }
            else {
                result = `${result}0${second}`;
            }
            return result;
        }
        static formatFullTime(timeStamp = Date.now()) {
            var time = new Date(timeStamp);
            var y = time.getFullYear();
            var m = time.getMonth() + 1;
            var d = time.getDate();
            var h = time.getHours();
            var tm = time.getMinutes();
            var s = time.getSeconds();
            return `${y}-${m < 10 ? "0" + m : m}-${d < 10 ? "0" + d : d} ${h < 10 ? "0" + h : h}:${tm < 10 ? "0" + tm : tm}:${s < 10 ? "0" + s : s}`;
        }
        static formatDate(timeStamp) {
            var time = new Date(timeStamp);
            var y = time.getFullYear();
            var m = time.getMonth() + 1;
            var d = time.getDate();
            return `${y}-${m}-${d}`;
        }
        static format() {
            this.format = sprintf;
            return sprintf(...arguments);
        }
        static generateUUID() {
            let d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }
        ;
        static deepCopy(src, dest) {
            if (!src)
                return src;
            if (src instanceof Array) {
                let newObj = dest || [];
                let len = src.length;
                for (let i = 0; i < len; i++) {
                    const element = src[i];
                    newObj.push(this.deepCopy(element));
                }
                return newObj;
            }
            else if (src instanceof Object) {
                let newObj = dest || {};
                let keys = Object.keys(src);
                for (let i = 0; i < keys.length; i++) {
                    let key = keys[i];
                    let value = src[key];
                    newObj[key] = this.deepCopy(value);
                }
                return newObj;
            }
            else {
                return src;
            }
        }
        static testDeepCopy() {
            let str = "haha";
            console.log(this.deepCopy(str));
            let num = 3;
            console.log(this.deepCopy(num));
            let arr = ["1", "3"];
            console.log(this.deepCopy(arr));
            let obj = { a: "h", b: "m" };
            console.log(this.deepCopy(obj));
        }
        static mergeArray(srcArr, destArr) {
            for (let i = 0; i < srcArr.length; i++) {
                destArr.push(srcArr[i]);
            }
        }
        static swap(arr, idx1, idx2) {
            let temp = arr[idx1];
            arr[idx1] = arr[idx2];
            arr[idx2] = temp;
        }
        static getMd5(context) {
            if (context == null) {
                return md5("null");
            }
            else {
                return md5(context);
            }
        }
        static getMax(arr) {
            let max = -Number.MAX_VALUE;
            for (let i = 0; i < arr.length; i++) {
                if (max < arr[i]) {
                    max = arr[i];
                }
            }
            return max;
        }
        static getMaxIndex(arr) {
            let max = -Number.MAX_VALUE;
            let idx = -1;
            for (let i = 0; i < arr.length; i++) {
                if (max < arr[i]) {
                    max = arr[i];
                    idx = i;
                }
            }
            return idx;
        }
        static isValueType(value) {
            let type = typeof value;
            if (type == "number" || type == "boolean" || type == "string") {
                return true;
            }
            return false;
        }
        static serializeObject(obj) {
            let newObj = this.deepCopy(obj);
            return JSON.stringify(newObj);
        }
        static copyTo(res, dest) {
            if (res instanceof Array) {
                for (let i = 0; i < res.length; i++) {
                    dest[i] = res[i];
                }
            }
            if (res instanceof Object) {
                let keys = Object.keys(res);
                for (let i = 0; i < keys.length; i++) {
                    let key = keys[i];
                    dest[key] = res[key];
                }
            }
        }
        static deserializeObject(objData, obj) {
            let newObj = JSON.parse(objData);
            this.copyTo(newObj, obj);
        }
        static safeParseInt(value, defaultValue, radix) {
            let v = parseInt(value, radix);
            if (isNaN(v)) {
                return defaultValue;
            }
            else {
                return v;
            }
        }
        static safeParseFloat(value, defaultValue) {
            let v = parseFloat(value);
            if (isNaN(v)) {
                return defaultValue;
            }
            else {
                return v;
            }
        }
        static safeParseBool(value) {
            if (!value)
                return false;
            value = value.toString();
            if (value == "0")
                return false;
            value = value.toLowerCase();
            return value != "false";
        }
        static arrayCopy(src, srcPos, dest, destPos, lenght) {
            if (src.length < srcPos + lenght)
                throw "arrayCopy: src out of bound";
            if (dest.length < destPos + lenght)
                throw "arrayCopy: dest out of bound";
            for (let i = 0; i < lenght; i++) {
                dest[destPos + i] = src[srcPos + i];
            }
        }
        static arrayFill(arr, value) {
            for (let i = arr.length - 1; i >= 0; i--) {
                arr[i] = value;
            }
        }
        static sort_db_by_order(d1, d2) {
            return d1.order - d2.order;
        }
        static dump(data, tag, level) {
            let text = _dump(data);
            console.log("dump-begin", tag);
            console.log(text);
            console.log("dump-end");
        }
        static utf8Len(str) {
            var len = 0;
            if (str) {
                for (var i = 0; i < str.length; i++) {
                    let code = str.charCodeAt(i);
                    if (code > 127 || code == 94) {
                        len += 2;
                    }
                    else {
                        len++;
                    }
                }
            }
            return len;
        }
        static bitSub(a, b) {
            if ((a & b) > 0) {
                return a - b;
            }
            else {
                return a;
            }
        }
        static compress(str) {
            return pako$1.gzip(str, { to: "string" });
        }
        static decompress(str) {
            try {
                return pako$1.ungzip(str, { to: "string" });
            }
            catch (error) {
                Logger.catchError("Tools.decompress", error);
                return null;
            }
        }
        static compressToBase64(str) {
            let compressStr = this.compress(str);
            return Base64.encode(compressStr);
        }
        static decompressFromBase64(str) {
            let compressStr = Base64.decode(str);
            return this.decompress(compressStr);
        }
        static compressArr(arr) {
            return pako$1.deflate(arr);
        }
        static decompressArr(arr) {
            try {
                return pako$1.inflate(arr);
            }
            catch (error) {
                Logger.catchError("Tools.decompressArr", error);
            }
        }
        static decompressArrToStr(arr) {
            return pako$1.ungzip(arr, { to: "string" });
        }
        static printTrace() {
            if (Logger.isDebugLevel && console.trace)
                Logger.log(console.trace());
        }
        static getPath(file) {
            let idx = file.lastIndexOf("/");
            if (idx > 0) {
                return file.slice(0, idx + 1);
            }
            else {
                return ";;";
            }
        }
        static _toHexColor(value) {
            let rst;
            rst = Math.floor(value * 255).toString(16);
            rst = rst.length > 1 ? rst : "0" + rst;
            return rst;
        }
        static toHexColor(color) {
            return "#" + this._toHexColor(color.r) + this._toHexColor(color.g) + this._toHexColor(color.b) + this._toHexColor(color.a);
        }
        static toLayaColor(value) {
            value.charAt(0) === '#' && (value = value.substr(1));
            var len = value.length;
            var color = parseInt(value, 16);
            if (len === 6) {
                return new Laya.Color(((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255, 1);
            }
            else if (len == 8) {
                color = parseInt(value.substr(0, 6), 16);
                let alpha = parseInt(value.substr(6), 16);
                return new Laya.Color(((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255, alpha / 255);
            }
            return null;
        }
        static requestHttp(url, caller, onSuc, onError) {
            var xhr = new Laya.HttpRequest();
            xhr.http.timeout = 10000;
            xhr.once(Laya.Event.COMPLETE, caller, onSuc);
            xhr.once(Laya.Event.ERROR, caller, onError);
            xhr.send("res/data.data", "", "get", "text");
        }
        static reverseBitmap(bitmap, width, height) {
            var newmap = new Uint8Array(width * height * 4);
            let wstride = width * 4;
            let st = 0;
            let dst = (height - 1) * wstride;
            for (var i = height - 1; i >= 0; i--) {
                newmap.set(bitmap.slice(dst, dst + wstride), st);
                st += wstride;
                dst -= wstride;
            }
            return newmap;
        }
        static getTex2dFromTex2d(tex2d, x, y, width, height) {
            x = (x | 0);
            y = (y | 0);
            width = (width | 0);
            height = (height | 0);
            var ret = this.getTexturePixels(tex2d, x, y, width, height);
            let newTex2d = new Laya.Texture2D(width, height, tex2d.format, false, true);
            newTex2d.setPixels(ret);
            return newTex2d;
        }
        static getTexturePixels(tex2d, x, y, width, height) {
            x = (x | 0);
            y = (y | 0);
            width = (width | 0);
            height = (height | 0);
            let tex2dw = tex2d.width, tex2dh = tex2d.height;
            let pix = tex2d.getPixels();
            if (x == 0 && y == 0 && width == tex2dw && height == tex2dh)
                return pix;
            let uv = Laya.Texture.DEF_UV;
            let atlasPosX = Math.round(uv[0] * tex2dw);
            let atlasPosY = Math.round(uv[1] * tex2dh);
            var ret = new Uint8Array(width * height * 4);
            let wstride = tex2dw * 4;
            let dst = (atlasPosY + y) * wstride;
            let st = atlasPosX * 4 + x * 4 + dst;
            for (var i = 0; i < height; i++) {
                ret.set(pix.slice(st, st + width * 4), width * 4 * (i + 0) + 0 * 4);
                st += wstride;
            }
            return ret;
        }
        static isNodeVaild(node) {
            if (!node)
                return false;
            if (node.destroyed)
                return false;
            if (node.owner && node.owner.destroyed)
                return false;
            if (node.parent && node.parent.destroyed)
                return false;
            return true;
        }
        static findAllSkinnedMeshRenderers(node, out, recursive = false) {
            out = out || [];
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                if (child) {
                    let render = child["skinnedMeshRenderer"];
                    if (render) {
                        out.push(render);
                    }
                    if (recursive) {
                        this.findAllSkinnedMeshRenderers(child, out, recursive);
                    }
                }
            }
            return out;
        }
        static findAllRenderers(node) {
            let out = [];
            this.__findAllRenderers(node, out, node);
            return out;
        }
        static __findAllRenderers(node, out, root) {
            let render = node["_render"];
            if (render) {
                out.push({
                    router: this.traceToFindRouter(root, node),
                    renderer: render,
                    node: node,
                });
            }
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                this.__findAllRenderers(child, out, root);
            }
        }
        static traceToFindRouter(root, cursorNode) {
            let router = "/";
            while (cursorNode !== root) {
                router = "/" + cursorNode.name + router;
                cursorNode = cursorNode.parent;
            }
            return router;
        }
        static findAllShurikenParticleSystem(node, out) {
            out = out || [];
            for (var i = node.numChildren - 1; i >= 0; i--) {
                var child = node.getChildAt(i);
                if (child.particleSystem) {
                    out.push(child.particleSystem);
                }
                this.findAllShurikenParticleSystem(child, out);
            }
            return out;
        }
        static setSprite3dLayer(node, layer) {
            node.layer = layer;
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                this.setSprite3dLayer(child, layer);
            }
        }
        static objLength(obj) {
            let type = this.getType(obj);
            if (type === "array") {
                let length = 0;
                for (const key in obj) {
                    const element = obj[key];
                    if (element) {
                        length++;
                    }
                }
                return length;
            }
            else if (type === "object") {
                let length = 0;
                for (const key in obj) {
                    const element = obj[key];
                    if (element) {
                        length++;
                    }
                }
                return length;
            }
            else {
                return 0;
            }
        }
        static getType(obj) {
            let toString = Object.prototype.toString;
            let map = {
                '[object Boolean]': 'boolean',
                '[object Number]': 'number',
                '[object String]': 'string',
                '[object Function]': 'function',
                '[object Array]': 'array',
                '[object Date]': 'date',
                '[object RegExp]': 'regExp',
                '[object Undefined]': 'undefined',
                '[object Null]': 'null',
                '[object Object]': 'object'
            };
            return map[toString.call(obj)];
        }
        static link2Node(nodeName, root, Sprite3D) {
            if (root.name == nodeName) {
                root.addChild(Sprite3D);
                Sprite3D.transform.localPosition = new Laya.Vector3();
                return true;
            }
            let index = 0;
            let child = null;
            while (true) {
                child = root.getChildAt(index);
                if (!child)
                    break;
                if (child.name == nodeName) {
                    child.addChild(Sprite3D);
                    Sprite3D.transform.localPosition = new Laya.Vector3();
                    return true;
                }
                else {
                    if (this.link2Node(nodeName, child, Sprite3D)) {
                        return true;
                    }
                }
                index++;
            }
            return false;
        }
        static unLink2Node(Sprite3D) {
            Sprite3D.removeSelf();
        }
        static findNode(nodeName, root) {
            if (root.name == nodeName) {
                return root;
            }
            for (let i = 0; i < root.numChildren; i++) {
                let child = root.getChildAt(i);
                if (child.name == nodeName)
                    return child;
                else {
                    let node = this.findNode(nodeName, child);
                    if (node)
                        return node;
                }
            }
            return null;
        }
        static RoundTableProbability(list, field) {
            let randomField = 0;
            Tools.forEachMap(list, (k, v) => {
                randomField += v[field];
            });
            let cursorField = 0;
            let point = Math.random() * randomField;
            let value = null;
            Tools.forEachMap(list, (k, v) => {
                if (point > cursorField && point <= cursorField + v[field]) {
                    value = list[k];
                    return true;
                }
                else {
                    cursorField += v[field];
                }
            });
            return value;
        }
        static encodePixelsData(pixels) {
            let data = this.compressArr(pixels);
            return Base64Plus.encodeArrayBuffer(data);
        }
        static encodeTexture(texture) {
            let pixels = texture.getPixels();
            let data = this.compressArr(pixels);
            return Base64Plus.encodeArrayBuffer(data);
        }
        static decodeTexture(value, width = 576, height = 1024) {
            let data = Base64Plus.decodeArrayBuffer(value);
            let pixels = this.decompressArr(new Uint8Array(data));
            let texture2d = new Laya.Texture2D(width, height, undefined, false);
            texture2d.setPixels(pixels);
            return texture2d;
        }
        static getMeshRender(node) {
            if (!node) {
                return null;
            }
            return node[`skinnedMeshRenderer`] || node[`meshRenderer`];
        }
        static scaleInRange(n, ia, ib, oa, ob) {
            if (ia < ib) {
                if (n < ia)
                    n = ia;
                if (n > ib)
                    n = ib;
            }
            else {
                if (n < ib)
                    n = ib;
                if (n > ia)
                    n = ia;
            }
            let iDistance = ib - ia;
            let oDistance = ob - oa;
            return (n - ia) / iDistance * oDistance + oa;
        }
        static sortArrayByField(array, fields) {
            if (typeof (fields) == "string") {
                fields = [fields];
            }
            else {
                fields = fields;
            }
            let fieldConfig = [];
            for (let k in fields) {
                let v = fields[k];
                if (v && v != "") {
                    if (v.substring(0, 1) === "-") {
                        let tmpField = v.substring(1, v.length);
                        if (tmpField && tmpField != "") {
                            fieldConfig.push([tmpField, true]);
                        }
                    }
                    else {
                        fieldConfig.push([v, false]);
                    }
                }
            }
            let sorter = (a, b) => {
                let ret = 0;
                for (let k in fieldConfig) {
                    let v = fieldConfig[k];
                    let field = v[0];
                    let desc = v[1];
                    let v1 = a[field];
                    let v2 = b[field];
                    if (v1 != null) {
                        if (desc) {
                            ret = v2 - v1;
                        }
                        else {
                            ret = v1 - v2;
                        }
                        if (ret != 0) {
                            return ret;
                        }
                    }
                }
                return ret;
            };
            let sorted = [];
            for (let i = 0; i < array.length; i++) {
                const v = array[i];
                sorted.push(v);
            }
            sorted.sort(sorter);
            return sorted;
        }
    }
    Tools.timeScale = 1;

    let globalEventDis;
    class MsgHandler {
        constructor(eventTarget) {
            if (!globalEventDis)
                globalEventDis = new Laya.EventDispatcher();
            this._eventTarget = eventTarget || globalEventDis;
            this._registeredListeners = Object.create(null);
            this._startedListeners = Object.create(null);
            this._bStarted = false;
        }
        registerListeners(listeners) {
            for (let msgName in listeners) {
                if (this._registeredListeners[msgName] != null) {
                    console.log(`[警告] MsgHandler.registerListeners msg重复注册！ msgName=${msgName}`);
                }
                let listener = listeners[msgName];
                this._registeredListeners[msgName] = listener;
            }
            if (this._bStarted) {
                this.startProcMsg();
            }
        }
        startProcMsg() {
            this._bStarted = true;
            for (const msgName in this._registeredListeners) {
                if (!this._startedListeners[msgName]) {
                    const listener = this._registeredListeners[msgName];
                    this._eventTarget.on(msgName, this, listener);
                    this._startedListeners[msgName] = listener;
                }
            }
        }
        stopProcMsg() {
            for (const msgName in this._startedListeners) {
                let listener = this._startedListeners[msgName];
                this._eventTarget.off(msgName, this, listener);
            }
            this._bStarted = false;
            this._startedListeners = Object.create(null);
        }
        sendMsg(msgName, data) {
            try {
                this._eventTarget.event(msgName, data);
            }
            catch (error) {
                Logger.catchError(`MsgHandler.sendMsg:${msgName}`, error);
            }
        }
        sendMsgWithArray(msgName, arrData) {
            try {
                this._eventTarget.event(msgName, [arrData]);
            }
            catch (error) {
                Logger.catchError(`MsgHandler.sendMsgWithArray:${msgName}`, error);
            }
        }
        static registerListeners(caller, listeners) {
            Tools.forEachMap(listeners, (k, listener) => {
                listeners[k] = listener.bind(caller);
            });
            let handler;
            for (let i = 0; i < this.globalHandlers.length; i++) {
                const element = this.globalHandlers[i];
                if (element.caller == caller) {
                    handler = element.handler;
                    break;
                }
            }
            if (!handler) {
                handler = new MsgHandler;
                handler.startProcMsg();
                this.globalHandlers.push({
                    handler: handler,
                    caller: caller,
                });
            }
            handler.registerListeners(listeners);
        }
        static sendMsg(msgName, data) {
            for (let i = this.globalHandlers.length - 1; i >= 0; i--) {
                const element = this.globalHandlers[i];
                if (element.caller.destroyed || (element.caller.owner && element.caller.owner.destroyed)) {
                    element.handler.stopProcMsg();
                    this.globalHandlers.splice(i, 1);
                }
            }
            if (this.globalHandlers.length > 0) {
                this.globalHandlers[0].handler.sendMsg(msgName, data);
            }
        }
    }
    MsgHandler.globalHandlers = [];

    class Queue {
        constructor(max = 128, autoGrow = true) {
            this.autoGrow = true;
            this.autoGrow = autoGrow;
            this.maxLen = max;
            this.tail = 0;
            this.head = 0;
            this.count = 0;
            this.queue = new Array(max);
        }
        get size() {
            return this.count;
        }
        get max() {
            return this.maxLen;
        }
        enqueue(obj) {
            if (this.autoGrow) {
                if (this.count >= this.maxLen - 1) {
                    this.grow();
                }
            }
            else {
                if (this.count >= this.maxLen) {
                    return false;
                }
            }
            this.queue[this.tail] = obj;
            this.tail = ++this.tail % this.maxLen;
            this.count++;
            return true;
        }
        dequeue() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.queue[this.head];
            this.queue[this.head] = null;
            this.head = ++this.head % this.maxLen;
            this.count--;
            return t;
        }
        peek() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.queue[this.head];
            return t;
        }
        grow() {
            let newLen = this.maxLen + (this.maxLen >> 1);
            this.maxLen = this.hugeLen(newLen);
            let newQueue = new Array(this.maxLen);
            if (this.count > 0) {
                if (this.head < this.tail) {
                    Tools.arrayCopy(this.queue, this.head, newQueue, 0, this.count);
                }
                else {
                    Tools.arrayCopy(this.queue, this.head, newQueue, 0, this.queue.length - this.head);
                    Tools.arrayCopy(this.queue, 0, newQueue, this.queue.length - this.head, this.tail);
                }
            }
            this.queue = newQueue;
            this.head = 0;
            this.tail = ((this.count == this.maxLen) ? 0 : this.count);
        }
        hugeLen(len) {
            if (len < 0)
                throw "Queue.hugeLen: OutOfMemoryError";
            return len > Queue.MAX_ARRAY_SIZE ? Queue.MAX_ARRAY_SIZE : len;
        }
        clear() {
            this.tail = 0;
            this.head = 0;
            this.count = 0;
            this.queue = new Array(this.queue.length);
        }
        reset() {
            this.tail = 0;
            this.head = 0;
            this.count = 0;
        }
        indexOf(idx) {
            if (idx < 0 || idx >= this.count)
                return null;
            let t = this.queue[(this.head + idx) % this.maxLen];
            return t;
        }
        contains(obj) {
            for (let i = 0; i < this.count; i++) {
                if (obj == this.indexOf(i))
                    return true;
            }
            return false;
        }
    }
    Queue.MAX_ARRAY_SIZE = Number.MAX_VALUE - 8;

    const KEY_POOL_ID = "__pool_id";
    const KEY_POOL_KEY = "__pool_key";
    const KEY_FLAG_IN_POOL = "__pool_flag_inpool";
    class PoolStack {
        constructor() {
            this.m_queue = new Queue(16, true);
            this.m_referenceCount = 0;
        }
        get length() {
            return this.m_queue.size;
        }
        push(t) {
            this.m_queue.enqueue(t);
        }
        pop() {
            return this.m_queue.dequeue();
        }
        retain() {
            this.m_referenceCount++;
        }
        release() {
            this.m_referenceCount--;
        }
        get referenceCount() {
            return this.m_referenceCount;
        }
        get totalCount() {
            return this.m_referenceCount + this.m_queue.size;
        }
    }
    class PoolManager {
        constructor() {
            this.pools = [];
            this.poolConfigs = [];
        }
        _getPool(poolId, poolKey) {
            let group = this.pools[poolId];
            if (!group) {
                group = {};
                this.pools[poolId] = group;
            }
            let pool = group[poolKey];
            if (!pool) {
                pool = new PoolStack();
                group[poolKey] = pool;
            }
            return pool;
        }
        register(reuseClass, maxCount = 1000, overload = true) {
            if (reuseClass[KEY_POOL_ID]) {
                let cnf = this.poolConfigs[reuseClass[KEY_POOL_ID]];
                if (cnf.reuseClass === reuseClass) {
                    Logger.error("PoolManager.register class is registed.", reuseClass);
                    return;
                }
            }
            let cnf = {
                reuseClass: reuseClass,
                maxCount: maxCount,
                bOverload: overload,
            };
            reuseClass[KEY_POOL_ID] = this.poolConfigs.length;
            this.poolConfigs.push(cnf);
        }
        get(reuseClass, poolKey) {
            let poolId = reuseClass[KEY_POOL_ID];
            if (poolId == undefined) {
                Logger.debug("PoolManager.get class is not register.", reuseClass.name);
                this.register(reuseClass);
                return this.get(reuseClass, poolKey);
            }
            let config = this.poolConfigs[poolId];
            if (!config) {
                Logger.warn(`"PoolManager.get config not found! poolId = ${poolId}"`);
                return;
            }
            if (poolKey == null)
                poolKey = "__default_pool_key__";
            let pool = this._getPool(poolId, poolKey);
            let node = pool.pop();
            if (!node) {
                if (!config.bOverload) {
                    if (pool.totalCount >= config.maxCount) {
                        return null;
                    }
                }
                node = new reuseClass(poolKey);
                node[KEY_POOL_ID] = poolId;
                node[KEY_POOL_KEY] = poolKey;
            }
            pool.retain();
            node.reuse();
            node[KEY_FLAG_IN_POOL] = false;
            return node;
        }
        put(reuseNode) {
            if (!reuseNode) {
                Logger.warn("PoolManager.put node is nil!");
                return false;
            }
            let poolId = reuseNode[KEY_POOL_ID];
            let poolKey = reuseNode[KEY_POOL_KEY];
            if (poolId == undefined) {
                Logger.warn("PoolManager.put obj[KEY_POOL_ID] not found!");
                return false;
            }
            if (!poolKey) {
                Logger.warn("PoolManager.put obj[KEY_POOL_KEY] not found!");
                return false;
            }
            let config = this.poolConfigs[poolId];
            if (!config) {
                Logger.warn(`PoolManager.put config not found! poolId:[${poolId}] key:[${poolKey}]`);
                return false;
            }
            if (reuseNode[KEY_FLAG_IN_POOL]) {
                Logger.warn(`PoolManager.put obj is already in pool! [${poolId}] key:[${poolKey}]`);
                return false;
            }
            reuseNode.unuse();
            let pool = this._getPool(poolId, poolKey);
            if (pool.length < config.maxCount) {
                reuseNode[KEY_FLAG_IN_POOL] = true;
                pool.push(reuseNode);
            }
            else {
                Logger.warn(`PoolManager.put pool:[${poolId}] key:[${poolKey}] is full!`);
                reuseNode.dispose();
            }
            pool.release();
            return true;
        }
        clean(reuseClass, poolKey) {
            let poolId = reuseClass[KEY_POOL_ID];
            for (const pid in this.pools) {
                if (poolId != null || poolId == pid) {
                    const pools = this.pools[pid];
                    for (const key in pools) {
                        if (!poolKey || poolKey == key) {
                            const pool = pools[key];
                            let len = pool.length;
                            for (let i = 0; i < len; i++) {
                                const node = pool.pop();
                                node.dispose();
                            }
                        }
                    }
                }
            }
        }
        debugInfo() {
            console.log("\n------ debug PoolManager ------");
            for (const pid in this.pools) {
                const pools = this.pools[pid];
                for (const key in pools) {
                    const pool = pools[key];
                    const config = this.poolConfigs[pid];
                    console.log(`pool:${pid}    class:${config.reuseClass.name}    key:${key}    cached:${pool.length}    used:${pool.referenceCount}`);
                }
            }
            console.log("\n------ debug pool class info ------");
        }
        debugClassId() {
            for (let i = 0; i < this.poolConfigs.length; i++) {
                let cnf = this.poolConfigs[i];
                let classStr = cnf.reuseClass.toString();
                let p0 = classStr.indexOf("{");
                if (p0 && p0 > 9) {
                    classStr = classStr.substring(9, p0);
                }
                console.log(`class:${classStr}    name:${cnf.reuseClass.name}    poolId:${cnf.reuseClass[KEY_POOL_ID]}`);
            }
        }
    }

    class Stack {
        constructor(max = 128, autoGrow = true) {
            this.autoGrow = true;
            this.autoGrow = autoGrow;
            this.count = 0;
            this.stack = new Array(max);
        }
        get size() {
            return this.count;
        }
        push(obj) {
            if (!this.autoGrow) {
                if (this.count >= this.stack.length) {
                    return false;
                }
            }
            this.stack[this.count++] = obj;
            return true;
        }
        pop() {
            if (this.count <= 0) {
                return null;
            }
            let t = this.stack[--this.count];
            this.stack[this.count] = null;
            return t;
        }
        peek() {
            while (this.count <= 0) {
                return null;
            }
            let t = this.stack[this.count - 1];
            return t;
        }
        clear() {
            this.count = 0;
            this.stack = new Array(this.stack.length);
        }
        reset() {
            this.count = 0;
        }
        indexOf(idx) {
            if (idx < 0 || idx >= this.count)
                return null;
            return this.stack[idx];
        }
        contains(obj) {
            for (let i = 0; i < this.count; i++) {
                if (obj == this.stack[i])
                    return true;
            }
            return false;
        }
    }

    const KEY_POOL_ID$1 = "__pool_id2";
    const KEY_FLAG_IN_POOL$1 = "__pool_flag_inpool";
    class Pool {
        constructor() {
            this._pools = [];
            this._classNames = [];
            this._key2id = Object.create(null);
        }
        get(poolClass) {
            let idx = poolClass[KEY_POOL_ID$1];
            if (idx == null) {
                idx = this._pools.length;
                poolClass[KEY_POOL_ID$1] = idx;
                this._classNames.push(poolClass.name || "unkown");
                this._pools.push(new Stack(32, true));
            }
            let stack = this._pools[idx];
            let obj = stack.pop();
            if (!obj) {
                obj = new poolClass();
                obj[KEY_POOL_ID$1] = idx;
                return obj;
            }
            else {
                obj[KEY_FLAG_IN_POOL$1] = false;
                return obj;
            }
        }
        put(obj) {
            let idx = obj[KEY_POOL_ID$1];
            if (idx == null) {
                Logger.warn("Pool.put obj[KEY_POOL_ID] not found!");
                return;
            }
            if (obj[KEY_FLAG_IN_POOL$1]) {
                Logger.warn(`Pool.put obj is already in pool! [${idx}].`);
                return;
            }
            obj[KEY_FLAG_IN_POOL$1] = true;
            let stack = this._pools[idx];
            stack.push(obj);
        }
        getObject(key) {
            let idx = this._key2id[key];
            if (idx == null) {
                idx = this._pools.length;
                this._key2id[key] = idx;
                this._classNames.push(key);
                this._pools.push(new Stack(32, true));
            }
            let stack = this._pools[idx];
            let obj = stack.pop();
            if (!obj) {
                obj = Object.create(null);
                obj[KEY_POOL_ID$1] = idx;
                return obj;
            }
            else {
                obj[KEY_FLAG_IN_POOL$1] = false;
                return obj;
            }
        }
        debugInfo() {
            console.log("\n------ debug pools ------");
            for (let i = 0; i < this._pools.length; i++) {
                const pool = this._pools[i];
                console.log(`pool:${i}    name:${this._classNames[i]}    cached:${pool.size}`);
            }
            console.log("");
        }
    }

    var SDK_VERSIONS_VALUE;
    (function (SDK_VERSIONS_VALUE) {
        SDK_VERSIONS_VALUE["NONE"] = "None";
        SDK_VERSIONS_VALUE["V5"] = "V5";
        SDK_VERSIONS_VALUE["V6"] = "V6";
    })(SDK_VERSIONS_VALUE || (SDK_VERSIONS_VALUE = {}));
    class Global {
        static sendMsg(msgName, data) {
            MsgHandler.sendMsg(msgName, data);
        }
        static registerListeners(caller, listeners) {
            MsgHandler.registerListeners(caller, listeners);
        }
        static get canvasWidth() {
            return UIRoot.canvasWidth;
        }
        static get canvasHeight() {
            return UIRoot.canvasHeight;
        }
        static get canvasFitWidth() {
            return UIRoot.uiFitWidth;
        }
        static get canvasFitHeight() {
            return UIRoot.uiFitHeight;
        }
        static get top() {
            return UIRoot.uiFitTop;
        }
        static get bottom() {
            return this.canvasHeight - this.top;
        }
        static get left() {
            return UIRoot.uiFitLeft;
        }
        static get right() {
            return this.canvasWidth - this.left;
        }
        static get centerX() {
            return this.canvasWidth / 2;
        }
        static get centerY() {
            return this.canvasHeight / 2;
        }
    }
    Global.H5_TEST = false;
    Global.DEBUG = false;
    Global.GAME_ID = "166";
    Global.SDK_VERSION = SDK_VERSIONS_VALUE.NONE;
    Global.RECORD_VERSION = 2;
    Global.GAME_VERSION = "v1009.1200";
    Global.PATCH_VERSION = "0";
    Global.gameFrameRate = 50;
    Global.isGuiding = false;
    Global.poolManager = new PoolManager();
    Global.pool = new Pool();
    Global.FPS = 0;
    Global.EMPTY_FUN = function () { };
    Global.SDK_VERSION = SDK_VERSIONS_VALUE.V6;

    class FguiHelper {
        static getItem(url) {
            let item = Laya.Pool.getItem(url);
            if (!item) {
                item = fgui.UIPackage.createObjectFromURL(url);
            }
            return item;
        }
        static putItem(url, item) {
            if (!item || item.destroyed)
                return;
            Laya.Pool.recover(url, item);
        }
        static clearItem(url) {
            Laya.Pool.clearBySign(url);
        }
        static playTransition(object, name, delay = 0) {
            if (object && name) {
                let transition = object.getTransition(name);
                if (transition) {
                    transition.play(null, 1, delay);
                }
            }
        }
        static playIdleAndIn(object, index, start, interval, limit = 0, nameIdle = "idle", nameIn = "in") {
            if (limit && index >= limit)
                return;
            this.playTransition(object, nameIdle);
            this.playTransition(object, nameIn, start + index * interval);
        }
        static makeFullScreenFitTop(node) {
            let offset = 0;
            let dsRatio = UIRoot.instance.standardLong / UIRoot.instance.standardShort;
            let uiRatio = fgui.GRoot.inst.height / fgui.GRoot.inst.width;
            if (uiRatio > dsRatio) {
                offset = 50;
            }
            node.setSize(fgui.GRoot.inst.width, fgui.GRoot.inst.height - offset);
        }
    }

    class db {
        static setAllDbs(allDb) {
            this._allDbs = allDb;
        }
        static getDb(dbName) {
            let db = this._allDbs[dbName];
            if (!db) {
                console.error(`[警告] db.getDb db not found! dbName=[${dbName}]`);
                db = this._empty;
            }
            return db;
        }
        static get_adv_banner_int_db_map() {
            return this.getDb("adv_banner_int_db");
        }
        static get_adv_banner_int_db(advName) {
            let data = this.get_adv_banner_int_db_map()[advName];
            if (data == null) {
                console.error(`can't find data in adv_banner_int_db by advName [${advName}]`);
            }
            return data;
        }
        static get_adv_db_map() {
            return this.getDb("adv_db");
        }
        static get_adv_db(advName) {
            let data = this.get_adv_db_map()[advName];
            if (data == null) {
                console.error(`can't find data in adv_db by advName [${advName}]`);
            }
            return data;
        }
        static get_ad_banner_int_ui_db_map() {
            return this.getDb("ad_banner_int_ui_db");
        }
        static get_ad_banner_int_ui_db(viewName) {
            let data = this.get_ad_banner_int_ui_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ad_banner_int_ui_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_alert_dialog_db_map() {
            return this.getDb("alert_dialog_db");
        }
        static get_alert_dialog_db(panel) {
            let data = this.get_alert_dialog_db_map()[panel];
            if (data == null) {
                console.error(`can't find data in alert_dialog_db by panel [${panel}]`);
            }
            return data;
        }
        static get_all_equip_attr_map() {
            return this.getDb("all_equip_attr");
        }
        static get_all_equip_attr(id) {
            let data = this.get_all_equip_attr_map()[id];
            if (data == null) {
                console.error(`can't find data in all_equip_attr by id [${id}]`);
            }
            return data;
        }
        static get_all_equip_level_map() {
            return this.getDb("all_equip_level");
        }
        static get_all_equip_level(id) {
            let data = this.get_all_equip_level_map()[id];
            if (data == null) {
                console.error(`can't find data in all_equip_level by id [${id}]`);
            }
            return data;
        }
        static get_all_equip_wash_map() {
            return this.getDb("all_equip_wash");
        }
        static get_all_equip_wash(id) {
            let data = this.get_all_equip_wash_map()[id];
            if (data == null) {
                console.error(`can't find data in all_equip_wash by id [${id}]`);
            }
            return data;
        }
        static get_all_equip_word_map() {
            return this.getDb("all_equip_word");
        }
        static get_all_equip_word(id) {
            let data = this.get_all_equip_word_map()[id];
            if (data == null) {
                console.error(`can't find data in all_equip_word by id [${id}]`);
            }
            return data;
        }
        static get_all_tower_equip_map() {
            return this.getDb("all_tower_equip");
        }
        static get_all_tower_equip(id) {
            let data = this.get_all_tower_equip_map()[id];
            if (data == null) {
                console.error(`can't find data in all_tower_equip by id [${id}]`);
            }
            return data;
        }
        static get_attr_base_map() {
            return this.getDb("attr_base");
        }
        static get_attr_base(id) {
            let data = this.get_attr_base_map()[id];
            if (data == null) {
                console.error(`can't find data in attr_base by id [${id}]`);
            }
            return data;
        }
        static get_auto_increase_db_map() {
            return this.getDb("auto_increase_db");
        }
        static get_auto_increase_db(itemId) {
            let data = this.get_auto_increase_db_map()[itemId];
            if (data == null) {
                console.error(`can't find data in auto_increase_db by itemId [${itemId}]`);
            }
            return data;
        }
        static get_boss_wave_db_map() {
            return this.getDb("boss_wave_db");
        }
        static get_boss_wave_db(id, wave) {
            let data = this.get_boss_wave_db_map()[id][wave];
            if (data == null) {
                console.error(`can't find data in boss_wave_db by wave [${wave}]`);
            }
            return data;
        }
        static get_buff_db_map() {
            return this.getDb("buff_db");
        }
        static get_buff_db(id) {
            let data = this.get_buff_db_map()[id];
            if (data == null) {
                console.error(`can't find data in buff_db by id [${id}]`);
            }
            return data;
        }
        static get_bullet_db_map() {
            return this.getDb("bullet_db");
        }
        static get_bullet_db(id) {
            let data = this.get_bullet_db_map()[id];
            if (data == null) {
                console.error(`can't find data in bullet_db by id [${id}]`);
            }
            return data;
        }
        static get_challenge_level_map() {
            return this.getDb("challenge_level");
        }
        static get_challenge_level(id) {
            let data = this.get_challenge_level_map()[id];
            if (data == null) {
                console.error(`can't find data in challenge_level by id [${id}]`);
            }
            return data;
        }
        static get_collect_db_map() {
            return this.getDb("collect_db");
        }
        static get_collect_db(id, index) {
            let data = this.get_collect_db_map()[id][index];
            if (data == null) {
                console.error(`can't find data in collect_db by index [${index}]`);
            }
            return data;
        }
        static get_daily_damage_ad_map() {
            return this.getDb("daily_damage_ad");
        }
        static get_daily_damage_ad(id) {
            let data = this.get_daily_damage_ad_map()[id];
            if (data == null) {
                console.error(`can't find data in daily_damage_ad by id [${id}]`);
            }
            return data;
        }
        static get_daily_damage_db_map() {
            return this.getDb("daily_damage_db");
        }
        static get_daily_damage_db(id) {
            let data = this.get_daily_damage_db_map()[id];
            if (data == null) {
                console.error(`can't find data in daily_damage_db by id [${id}]`);
            }
            return data;
        }
        static get_daily_damage_reward_map() {
            return this.getDb("daily_damage_reward");
        }
        static get_daily_damage_reward(id, index) {
            let data = this.get_daily_damage_reward_map()[id][index];
            if (data == null) {
                console.error(`can't find data in daily_damage_reward by index [${index}]`);
            }
            return data;
        }
        static get_drop_custom_db_map() {
            return this.getDb("drop_custom_db");
        }
        static get_drop_custom_db(id) {
            let data = this.get_drop_custom_db_map()[id];
            if (data == null) {
                console.error(`can't find data in drop_custom_db by id [${id}]`);
            }
            return data;
        }
        static get_drop_db_map() {
            return this.getDb("drop_db");
        }
        static get_drop_db(id) {
            let data = this.get_drop_db_map()[id];
            if (data == null) {
                console.error(`can't find data in drop_db by id [${id}]`);
            }
            return data;
        }
        static get_effect_db_map() {
            return this.getDb("effect_db");
        }
        static get_effect_db(id) {
            let data = this.get_effect_db_map()[id];
            if (data == null) {
                console.error(`can't find data in effect_db by id [${id}]`);
            }
            return data;
        }
        static get_enemy_drop_db_map() {
            return this.getDb("enemy_drop_db");
        }
        static get_enemy_drop_db(id) {
            let data = this.get_enemy_drop_db_map()[id];
            if (data == null) {
                console.error(`can't find data in enemy_drop_db by id [${id}]`);
            }
            return data;
        }
        static get_explore_buff_map() {
            return this.getDb("explore_buff");
        }
        static get_explore_buff(id) {
            let data = this.get_explore_buff_map()[id];
            if (data == null) {
                console.error(`can't find data in explore_buff by id [${id}]`);
            }
            return data;
        }
        static get_explore_holy_db_map() {
            return this.getDb("explore_holy_db");
        }
        static get_explore_holy_db(id) {
            let data = this.get_explore_holy_db_map()[id];
            if (data == null) {
                console.error(`can't find data in explore_holy_db by id [${id}]`);
            }
            return data;
        }
        static get_explore_map_map() {
            return this.getDb("explore_map");
        }
        static get_explore_map(id) {
            let data = this.get_explore_map_map()[id];
            if (data == null) {
                console.error(`can't find data in explore_map by id [${id}]`);
            }
            return data;
        }
        static get_explore_shop_db_map() {
            return this.getDb("explore_shop_db");
        }
        static get_explore_shop_db(id) {
            let data = this.get_explore_shop_db_map()[id];
            if (data == null) {
                console.error(`can't find data in explore_shop_db by id [${id}]`);
            }
            return data;
        }
        static get_explore_time_map() {
            return this.getDb("explore_time");
        }
        static get_explore_time(id) {
            let data = this.get_explore_time_map()[id];
            if (data == null) {
                console.error(`can't find data in explore_time by id [${id}]`);
            }
            return data;
        }
        static get_fb_coin_db_map() {
            return this.getDb("fb_coin_db");
        }
        static get_fb_coin_db(id) {
            let data = this.get_fb_coin_db_map()[id];
            if (data == null) {
                console.error(`can't find data in fb_coin_db by id [${id}]`);
            }
            return data;
        }
        static get_fb_custom_db_map() {
            return this.getDb("fb_custom_db");
        }
        static get_fb_custom_db(id) {
            let data = this.get_fb_custom_db_map()[id];
            if (data == null) {
                console.error(`can't find data in fb_custom_db by id [${id}]`);
            }
            return data;
        }
        static get_fb_holyitem_db_map() {
            return this.getDb("fb_holyitem_db");
        }
        static get_fb_holyitem_db(id) {
            let data = this.get_fb_holyitem_db_map()[id];
            if (data == null) {
                console.error(`can't find data in fb_holyitem_db by id [${id}]`);
            }
            return data;
        }
        static get_fb_holyitem_show_map() {
            return this.getDb("fb_holyitem_show");
        }
        static get_fb_holyitem_show(id) {
            let data = this.get_fb_holyitem_show_map()[id];
            if (data == null) {
                console.error(`can't find data in fb_holyitem_show by id [${id}]`);
            }
            return data;
        }
        static get_finalwar_db_map() {
            return this.getDb("finalwar_db");
        }
        static get_finalwar_db(id) {
            let data = this.get_finalwar_db_map()[id];
            if (data == null) {
                console.error(`can't find data in finalwar_db by id [${id}]`);
            }
            return data;
        }
        static get_goal_db_map() {
            return this.getDb("goal_db");
        }
        static get_goal_db(id) {
            let data = this.get_goal_db_map()[id];
            if (data == null) {
                console.error(`can't find data in goal_db by id [${id}]`);
            }
            return data;
        }
        static get_grow_item_getway_map() {
            return this.getDb("grow_item_getway");
        }
        static get_grow_item_getway(id) {
            let data = this.get_grow_item_getway_map()[id];
            if (data == null) {
                console.error(`can't find data in grow_item_getway by id [${id}]`);
            }
            return data;
        }
        static get_grow_page1_map() {
            return this.getDb("grow_page1");
        }
        static get_grow_page1(id) {
            let data = this.get_grow_page1_map()[id];
            if (data == null) {
                console.error(`can't find data in grow_page1 by id [${id}]`);
            }
            return data;
        }
        static get_grow_page2_map() {
            return this.getDb("grow_page2");
        }
        static get_grow_page2(id) {
            let data = this.get_grow_page2_map()[id];
            if (data == null) {
                console.error(`can't find data in grow_page2 by id [${id}]`);
            }
            return data;
        }
        static get_grow_page3_map() {
            return this.getDb("grow_page3");
        }
        static get_grow_page3(id) {
            let data = this.get_grow_page3_map()[id];
            if (data == null) {
                console.error(`can't find data in grow_page3 by id [${id}]`);
            }
            return data;
        }
        static get_grow_page4_map() {
            return this.getDb("grow_page4");
        }
        static get_grow_page4(id) {
            let data = this.get_grow_page4_map()[id];
            if (data == null) {
                console.error(`can't find data in grow_page4 by id [${id}]`);
            }
            return data;
        }
        static get_guide_db_map() {
            return this.getDb("guide_db");
        }
        static get_guide_db(group, id) {
            let data = this.get_guide_db_map()[group][id];
            if (data == null) {
                console.error(`can't find data in guide_db by id [${id}]`);
            }
            return data;
        }
        static get_guide_rush_db_map() {
            return this.getDb("guide_rush_db");
        }
        static get_guide_rush_db(wave) {
            let data = this.get_guide_rush_db_map()[wave];
            if (data == null) {
                console.error(`can't find data in guide_rush_db by wave [${wave}]`);
            }
            return data;
        }
        static get_holy_exp_db_map() {
            return this.getDb("holy_exp_db");
        }
        static get_holy_exp_db(id) {
            let data = this.get_holy_exp_db_map()[id];
            if (data == null) {
                console.error(`can't find data in holy_exp_db by id [${id}]`);
            }
            return data;
        }
        static get_holy_item_attr_base_map() {
            return this.getDb("holy_item_attr_base");
        }
        static get_holy_item_attr_base(id) {
            let data = this.get_holy_item_attr_base_map()[id];
            if (data == null) {
                console.error(`can't find data in holy_item_attr_base by id [${id}]`);
            }
            return data;
        }
        static get_holy_item_db_map() {
            return this.getDb("holy_item_db");
        }
        static get_holy_item_db(id) {
            let data = this.get_holy_item_db_map()[id];
            if (data == null) {
                console.error(`can't find data in holy_item_db by id [${id}]`);
            }
            return data;
        }
        static get_holy_item_quality_map() {
            return this.getDb("holy_item_quality");
        }
        static get_holy_item_quality(id) {
            let data = this.get_holy_item_quality_map()[id];
            if (data == null) {
                console.error(`can't find data in holy_item_quality by id [${id}]`);
            }
            return data;
        }
        static get_holy_item_word_map() {
            return this.getDb("holy_item_word");
        }
        static get_holy_item_word(id) {
            let data = this.get_holy_item_word_map()[id];
            if (data == null) {
                console.error(`can't find data in holy_item_word by id [${id}]`);
            }
            return data;
        }
        static get_inner_cdk_db_map() {
            return this.getDb("inner_cdk_db");
        }
        static get_inner_cdk_db(key) {
            let data = this.get_inner_cdk_db_map()[key];
            if (data == null) {
                console.error(`can't find data in inner_cdk_db by key [${key}]`);
            }
            return data;
        }
        static get_item_add_sub_statis_db_map() {
            return this.getDb("item_add_sub_statis_db");
        }
        static get_item_add_sub_statis_db(index) {
            let data = this.get_item_add_sub_statis_db_map()[index];
            if (data == null) {
                console.error(`can't find data in item_add_sub_statis_db by index [${index}]`);
            }
            return data;
        }
        static get_item_db_map() {
            return this.getDb("item_db");
        }
        static get_item_db(id) {
            let data = this.get_item_db_map()[id];
            if (data == null) {
                console.error(`can't find data in item_db by id [${id}]`);
            }
            return data;
        }
        static get_item_get_max_map() {
            return this.getDb("item_get_max");
        }
        static get_item_get_max(id) {
            let data = this.get_item_get_max_map()[id];
            if (data == null) {
                console.error(`can't find data in item_get_max by id [${id}]`);
            }
            return data;
        }
        static get_jump_point_event_db_map() {
            return this.getDb("jump_point_event_db");
        }
        static get_jump_point_event_db(viewName) {
            let data = this.get_jump_point_event_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in jump_point_event_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_level_db_map() {
            return this.getDb("level_db");
        }
        static get_level_db(id, index) {
            let data = this.get_level_db_map()[id][index];
            if (data == null) {
                console.error(`can't find data in level_db by index [${index}]`);
            }
            return data;
        }
        static get_magic_db_map() {
            return this.getDb("magic_db");
        }
        static get_magic_db(id) {
            let data = this.get_magic_db_map()[id];
            if (data == null) {
                console.error(`can't find data in magic_db by id [${id}]`);
            }
            return data;
        }
        static get_main_hero_map() {
            return this.getDb("main_hero");
        }
        static get_main_hero(id) {
            let data = this.get_main_hero_map()[id];
            if (data == null) {
                console.error(`can't find data in main_hero by id [${id}]`);
            }
            return data;
        }
        static get_main_story_level_map() {
            return this.getDb("main_story_level");
        }
        static get_main_story_level(id, lv) {
            let data = this.get_main_story_level_map()[id][lv];
            if (data == null) {
                console.error(`can't find data in main_story_level by lv [${lv}]`);
            }
            return data;
        }
        static get_main_story_map_map() {
            return this.getDb("main_story_map");
        }
        static get_main_story_map(id) {
            let data = this.get_main_story_map_map()[id];
            if (data == null) {
                console.error(`can't find data in main_story_map by id [${id}]`);
            }
            return data;
        }
        static get_map_config_map() {
            return this.getDb("map_config");
        }
        static get_map_config(id) {
            let data = this.get_map_config_map()[id];
            if (data == null) {
                console.error(`can't find data in map_config by id [${id}]`);
            }
            return data;
        }
        static get_map_db_map() {
            return this.getDb("map_db");
        }
        static get_map_db(id) {
            let data = this.get_map_db_map()[id];
            if (data == null) {
                console.error(`can't find data in map_db by id [${id}]`);
            }
            return data;
        }
        static get_model_db_map() {
            return this.getDb("model_db");
        }
        static get_model_db(id) {
            let data = this.get_model_db_map()[id];
            if (data == null) {
                console.error(`can't find data in model_db by id [${id}]`);
            }
            return data;
        }
        static get_name_db_map() {
            return this.getDb("name_db");
        }
        static get_name_db(id) {
            let data = this.get_name_db_map()[id];
            if (data == null) {
                console.error(`can't find data in name_db by id [${id}]`);
            }
            return data;
        }
        static get_newbee_box_reward_map() {
            return this.getDb("newbee_box_reward");
        }
        static get_newbee_box_reward(id) {
            let data = this.get_newbee_box_reward_map()[id];
            if (data == null) {
                console.error(`can't find data in newbee_box_reward by id [${id}]`);
            }
            return data;
        }
        static get_newyear_fb_reward_map() {
            return this.getDb("newyear_fb_reward");
        }
        static get_newyear_fb_reward(id) {
            let data = this.get_newyear_fb_reward_map()[id];
            if (data == null) {
                console.error(`can't find data in newyear_fb_reward by id [${id}]`);
            }
            return data;
        }
        static get_newyear_sign_db_map() {
            return this.getDb("newyear_sign_db");
        }
        static get_newyear_sign_db(day) {
            let data = this.get_newyear_sign_db_map()[day];
            if (data == null) {
                console.error(`can't find data in newyear_sign_db by day [${day}]`);
            }
            return data;
        }
        static get_next_day_reward_map() {
            return this.getDb("next_day_reward");
        }
        static get_next_day_reward(id) {
            let data = this.get_next_day_reward_map()[id];
            if (data == null) {
                console.error(`can't find data in next_day_reward by id [${id}]`);
            }
            return data;
        }
        static get_pay_db_map() {
            return this.getDb("pay_db");
        }
        static get_pay_db(id) {
            let data = this.get_pay_db_map()[id];
            if (data == null) {
                console.error(`can't find data in pay_db by id [${id}]`);
            }
            return data;
        }
        static get_pray_box_db_map() {
            return this.getDb("pray_box_db");
        }
        static get_pray_box_db(id) {
            let data = this.get_pray_box_db_map()[id];
            if (data == null) {
                console.error(`can't find data in pray_box_db by id [${id}]`);
            }
            return data;
        }
        static get_reward_db_map() {
            return this.getDb("reward_db");
        }
        static get_reward_db(id, idx) {
            let data = this.get_reward_db_map()[id][idx];
            if (data == null) {
                console.error(`can't find data in reward_db by idx [${idx}]`);
            }
            return data;
        }
        static get_role_db_map() {
            return this.getDb("role_db");
        }
        static get_role_db(id) {
            let data = this.get_role_db_map()[id];
            if (data == null) {
                console.error(`can't find data in role_db by id [${id}]`);
            }
            return data;
        }
        static get_role_model_db_map() {
            return this.getDb("role_model_db");
        }
        static get_role_model_db(id) {
            let data = this.get_role_model_db_map()[id];
            if (data == null) {
                console.error(`can't find data in role_model_db by id [${id}]`);
            }
            return data;
        }
        static get_role_model_effect_map() {
            return this.getDb("role_model_effect");
        }
        static get_role_model_effect(id, anim) {
            let data = this.get_role_model_effect_map()[id][anim];
            if (data == null) {
                console.error(`can't find data in role_model_effect by anim [${anim}]`);
            }
            return data;
        }
        static get_rush_wave_db_map() {
            return this.getDb("rush_wave_db");
        }
        static get_rush_wave_db(id, wave) {
            let data = this.get_rush_wave_db_map()[id][wave];
            if (data == null) {
                console.error(`can't find data in rush_wave_db by wave [${wave}]`);
            }
            return data;
        }
        static get_secret_daily_reward_map() {
            return this.getDb("secret_daily_reward");
        }
        static get_secret_daily_reward(id) {
            let data = this.get_secret_daily_reward_map()[id];
            if (data == null) {
                console.error(`can't find data in secret_daily_reward by id [${id}]`);
            }
            return data;
        }
        static get_secret_level_map() {
            return this.getDb("secret_level");
        }
        static get_secret_level(id) {
            let data = this.get_secret_level_map()[id];
            if (data == null) {
                console.error(`can't find data in secret_level by id [${id}]`);
            }
            return data;
        }
        static get_secret_word_db_map() {
            return this.getDb("secret_word_db");
        }
        static get_secret_word_db(id) {
            let data = this.get_secret_word_db_map()[id];
            if (data == null) {
                console.error(`can't find data in secret_word_db by id [${id}]`);
            }
            return data;
        }
        static get_secret_word_week_map() {
            return this.getDb("secret_word_week");
        }
        static get_secret_word_week(id) {
            let data = this.get_secret_word_week_map()[id];
            if (data == null) {
                console.error(`can't find data in secret_word_week by id [${id}]`);
            }
            return data;
        }
        static get_seven_score_db_map() {
            return this.getDb("seven_score_db");
        }
        static get_seven_score_db(id) {
            let data = this.get_seven_score_db_map()[id];
            if (data == null) {
                console.error(`can't find data in seven_score_db by id [${id}]`);
            }
            return data;
        }
        static get_seven_task_db_map() {
            return this.getDb("seven_task_db");
        }
        static get_seven_task_db(day) {
            let data = this.get_seven_task_db_map()[day];
            if (data == null) {
                console.error(`can't find data in seven_task_db by day [${day}]`);
            }
            return data;
        }
        static get_shop_buy_db_map() {
            return this.getDb("shop_buy_db");
        }
        static get_shop_buy_db(id) {
            let data = this.get_shop_buy_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_buy_db by id [${id}]`);
            }
            return data;
        }
        static get_shop_db_map() {
            return this.getDb("shop_db");
        }
        static get_shop_db(id) {
            let data = this.get_shop_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_db by id [${id}]`);
            }
            return data;
        }
        static get_shop_exchange_db_map() {
            return this.getDb("shop_exchange_db");
        }
        static get_shop_exchange_db(id) {
            let data = this.get_shop_exchange_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_exchange_db by id [${id}]`);
            }
            return data;
        }
        static get_shop_extra_db_map() {
            return this.getDb("shop_extra_db");
        }
        static get_shop_extra_db(id) {
            let data = this.get_shop_extra_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_extra_db by id [${id}]`);
            }
            return data;
        }
        static get_shop_slot_db_map() {
            return this.getDb("shop_slot_db");
        }
        static get_shop_slot_db(type, index) {
            let data = this.get_shop_slot_db_map()[type][index];
            if (data == null) {
                console.error(`can't find data in shop_slot_db by index [${index}]`);
            }
            return data;
        }
        static get_shop_time_db_map() {
            return this.getDb("shop_time_db");
        }
        static get_shop_time_db(id) {
            let data = this.get_shop_time_db_map()[id];
            if (data == null) {
                console.error(`can't find data in shop_time_db by id [${id}]`);
            }
            return data;
        }
        static get_sign_db_map() {
            return this.getDb("sign_db");
        }
        static get_sign_db(week, idx) {
            let data = this.get_sign_db_map()[week][idx];
            if (data == null) {
                console.error(`can't find data in sign_db by idx [${idx}]`);
            }
            return data;
        }
        static get_skill_db_map() {
            return this.getDb("skill_db");
        }
        static get_skill_db(id) {
            let data = this.get_skill_db_map()[id];
            if (data == null) {
                console.error(`can't find data in skill_db by id [${id}]`);
            }
            return data;
        }
        static get_sound_db_map() {
            return this.getDb("sound_db");
        }
        static get_sound_db(id) {
            let data = this.get_sound_db_map()[id];
            if (data == null) {
                console.error(`can't find data in sound_db by id [${id}]`);
            }
            return data;
        }
        static get_spine_db_map() {
            return this.getDb("spine_db");
        }
        static get_spine_db(id) {
            let data = this.get_spine_db_map()[id];
            if (data == null) {
                console.error(`can't find data in spine_db by id [${id}]`);
            }
            return data;
        }
        static get_story_dialog_db_map() {
            return this.getDb("story_dialog_db");
        }
        static get_story_dialog_db(id) {
            let data = this.get_story_dialog_db_map()[id];
            if (data == null) {
                console.error(`can't find data in story_dialog_db by id [${id}]`);
            }
            return data;
        }
        static get_subscription_db_map() {
            return this.getDb("subscription_db");
        }
        static get_subscription_db(name) {
            let data = this.get_subscription_db_map()[name];
            if (data == null) {
                console.error(`can't find data in subscription_db by name [${name}]`);
            }
            return data;
        }
        static get_sub_cop_map() {
            return this.getDb("sub_cop");
        }
        static get_sub_cop(subCopKey) {
            let data = this.get_sub_cop_map()[subCopKey];
            if (data == null) {
                console.error(`can't find data in sub_cop by subCopKey [${subCopKey}]`);
            }
            return data;
        }
        static get_summon_card_db_map() {
            return this.getDb("summon_card_db");
        }
        static get_summon_card_db(id) {
            let data = this.get_summon_card_db_map()[id];
            if (data == null) {
                console.error(`can't find data in summon_card_db by id [${id}]`);
            }
            return data;
        }
        static get_switch_db_map() {
            return this.getDb("switch_db");
        }
        static get_switch_db(id) {
            let data = this.get_switch_db_map()[id];
            if (data == null) {
                console.error(`can't find data in switch_db by id [${id}]`);
            }
            return data;
        }
        static get_talent_db_map() {
            return this.getDb("talent_db");
        }
        static get_talent_db(id) {
            let data = this.get_talent_db_map()[id];
            if (data == null) {
                console.error(`can't find data in talent_db by id [${id}]`);
            }
            return data;
        }
        static get_task_db_map() {
            return this.getDb("task_db");
        }
        static get_task_db(id) {
            let data = this.get_task_db_map()[id];
            if (data == null) {
                console.error(`can't find data in task_db by id [${id}]`);
            }
            return data;
        }
        static get_task_event_map() {
            return this.getDb("task_event");
        }
        static get_task_event(id) {
            let data = this.get_task_event_map()[id];
            if (data == null) {
                console.error(`can't find data in task_event by id [${id}]`);
            }
            return data;
        }
        static get_task_reward_db_map() {
            return this.getDb("task_reward_db");
        }
        static get_task_reward_db(id, index) {
            let data = this.get_task_reward_db_map()[id][index];
            if (data == null) {
                console.error(`can't find data in task_reward_db by index [${index}]`);
            }
            return data;
        }
        static get_tower_db_map() {
            return this.getDb("tower_db");
        }
        static get_tower_db(id) {
            let data = this.get_tower_db_map()[id];
            if (data == null) {
                console.error(`can't find data in tower_db by id [${id}]`);
            }
            return data;
        }
        static get_tower_dialog_db_map() {
            return this.getDb("tower_dialog_db");
        }
        static get_tower_dialog_db(id, index) {
            let data = this.get_tower_dialog_db_map()[id][index];
            if (data == null) {
                console.error(`can't find data in tower_dialog_db by index [${index}]`);
            }
            return data;
        }
        static get_tower_pos_map() {
            return this.getDb("tower_pos");
        }
        static get_tower_pos(gid, id) {
            let data = this.get_tower_pos_map()[gid][id];
            if (data == null) {
                console.error(`can't find data in tower_pos by id [${id}]`);
            }
            return data;
        }
        static get_tower_quality_map() {
            return this.getDb("tower_quality");
        }
        static get_tower_quality(id) {
            let data = this.get_tower_quality_map()[id];
            if (data == null) {
                console.error(`can't find data in tower_quality by id [${id}]`);
            }
            return data;
        }
        static get_tower_rush_reward_map() {
            return this.getDb("tower_rush_reward");
        }
        static get_tower_rush_reward(id) {
            let data = this.get_tower_rush_reward_map()[id];
            if (data == null) {
                console.error(`can't find data in tower_rush_reward by id [${id}]`);
            }
            return data;
        }
        static get_tower_star_map() {
            return this.getDb("tower_star");
        }
        static get_tower_star(id) {
            let data = this.get_tower_star_map()[id];
            if (data == null) {
                console.error(`can't find data in tower_star by id [${id}]`);
            }
            return data;
        }
        static get_ui_statis_button_db_map() {
            return this.getDb("ui_statis_button_db");
        }
        static get_ui_statis_button_db(viewName) {
            let data = this.get_ui_statis_button_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ui_statis_button_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_ui_statis_duration_db_map() {
            return this.getDb("ui_statis_duration_db");
        }
        static get_ui_statis_duration_db(viewName) {
            let data = this.get_ui_statis_duration_db_map()[viewName];
            if (data == null) {
                console.error(`can't find data in ui_statis_duration_db by viewName [${viewName}]`);
            }
            return data;
        }
        static get_view_method_call_point_event_db_map() {
            return this.getDb("view_method_call_point_event_db");
        }
        static get_view_method_call_point_event_db(panelName, index) {
            let data = this.get_view_method_call_point_event_db_map()[panelName][index];
            if (data == null) {
                console.error(`can't find data in view_method_call_point_event_db by index [${index}]`);
            }
            return data;
        }
        static get_wheel_db_map() {
            return this.getDb("wheel_db");
        }
        static get_wheel_db(id) {
            let data = this.get_wheel_db_map()[id];
            if (data == null) {
                console.error(`can't find data in wheel_db by id [${id}]`);
            }
            return data;
        }
    }
    db._empty = {};
    db.ADV_DB_ADVNAME = {
        unlock_tower_slot: "unlock_tower_slot",
        unlock_item_slot: "unlock_item_slot",
        unlock_main_hero: "unlock_main_hero",
        mine_deep: "mine_deep",
        box_open_now: "box_open_now",
        boss_ex: "boss_ex",
        task_reward_now: "task_reward_now",
        bag_expand: "bag_expand",
        gain_buff: "gain_buff",
        offline_ad: "offline_ad",
        sign_ad: "sign_ad",
        goal_ad: "goal_ad",
        talent_ad: "talent_ad",
        sign_fix_ad: "sign_fix_ad",
        shop_ad: "shop_ad",
        boss_sweep: "boss_sweep",
        icebreak: "icebreak",
        secret_add: "secret_add",
        daily_damage_ad: "daily_damage_ad",
        sweep_fb_coin: "sweep_fb_coin",
        sweep_fb_item: "sweep_fb_item",
        more_reward: "more_reward",
        endness_reward: "endness_reward",
        pick_reward: "pick_reward",
        finalwar_sweep: "finalwar_sweep",
        seven_again: "seven_again",
        explore_sub_time: "explore_sub_time",
        explore_add: "explore_add",
        explore_refresh_shop: "explore_refresh_shop",
        smelt_auto_put: "smelt_auto_put",
        newyear_sign_fix_ad: "newyear_sign_fix_ad",
        newyear_game_more: "newyear_game_more",
        map_unlock_tower_slot: "map_unlock_tower_slot",
        unlock_newbie_reward_box: "unlock_newbie_reward_box",
    };
    db.ALERT_DIALOG_DB_PANEL = {
        PanelIntroPeace: "PanelIntroPeace",
        PanelIntroSummon: "PanelIntroSummon",
        PanelIntroPray: "PanelIntroPray",
        PanelIntroStory: "PanelIntroStory",
        PanelIntroBoss: "PanelIntroBoss",
        PanelIntroChallenge: "PanelIntroChallenge",
        PanelIntroBag: "PanelIntroBag",
        PanelNextDayReward: "PanelNextDayReward",
        PanelBoxReward: "PanelBoxReward",
    };
    db.cop_db = {
        ad_interstitial_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_banner_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_embedded_ratios: [],
        ad_video_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_video_cds: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_video_counts: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ad_inst_cd: 0.5,
        ad_banner_refresh_cd: 10,
        ad_btn_mode: 0,
        b_inst_or_banner: 0,
        native_insert_mode: 2,
        b_banner_in_guide: 0,
        b_inst_in_guide: 0,
        some_function: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        b_open_statics_item: 0,
        url_notice: "",
        b_open_follow: 0,
        gold_rain_ratios: [0, 0],
        gold_rain_count: 10,
        gold_rain_cd: 10,
        isShowMergeBtn: 1,
        banner_confiom_ratio: [0, 0, 0],
        banner_confiom_close_time: [0, 0, 0],
        banner_confiom_banner_time: [0, 0, 0],
        progress_end_count: 0,
        share_mode: [0, 0, 0, 0, 0, 0, 0, 0, 0],
        share_close_delta_time: 0,
        isItemGetShareFirst: 0,
        video_share_mode: 0,
        video_share_delay_time: 0,
        video_ad_close_button: 0,
        video_ad_close_delay: 2,
        check_mode: 0,
        video_tag_switchs: [100, 100, 100, 100, 100, 100, 100, 100, 100],
        video_touch_range_modes: [0, 0, 0, 0, 0, 0, 0, 0],
        video_close_alerp_switchs: [0, 0, 0, 0, 0, 0],
        video_failed_retry_mode: 0,
        jump_single_switchs: [0],
        jump_banner_switchs: [0, 0, 0],
        jump_banner_vertical_switchs: [0, 0, 0],
        jump_left_switchs: [0],
        douyin_follow_switch: 0,
        ad_flag_style: 0,
        s_kefu_text: "",
        ad_h5: [0],
        check_mode_cd: 0,
        b_show_skin_phl: 1,
        show_invite_ratio: 0,
        b_open_advancedSetting: 0,
        b_show_banner_btn_switch: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        b_show_add_to_desk_dialog: 0,
        isThirdExit: false,
        isAbout: false,
        isShareEnabled: false,
        isPayEnabled: false,
        isULMoreGame: false,
        isUseSdkRank: false,
        isWebView: false,
        isShowUrlAdIcon: false,
        isSupportRecordShare: false,
        isSupportInstallShortcut: false,
        isSupportFindMinigames: false,
        isSupportRecommendationBtn: false,
        is4399Watermark: false,
        isJumpLeisureEnabled: false,
        isSupportFollowOfficialAccount: false,
        isSupportFavoriteGuide: false,
        isSupportUserCloudStorage: false,
        isSupportSubscription: false,
        b_video_share_finger: false,
        isByteDance: false,
        alert_dialog_ratios: [0, 0, 0, 0, 0, 0, 0, 0, 0],
        alert_dialog_cds: [0],
        alert_dialog_pre_cds: [0],
        egg_click_time: 2,
        egg_click_count: 14,
        egg_button_close: 1,
        is_sdk_start_game_by_touch: 0,
        b_advanced_setting: 0,
        b_advanced_game: 0,
        mine_configs: [50, 5, 20, 120, 15],
        notice_content: "[color=#000000][b]《魔力火线联盟‎》[/b][/color]上线啦！",
        notice_version: 1,
        b_cdk: 0,
        s_sdk_qq_group: "706743493",
        num_ad_video_free: 0,
        shortcut_interval_idle: 0,
        ui_itemget_button_banner_ratio: 0,
        ui_itemget_button_banner_wait: 0,
        ui_itemget_button_banner_delay: 0,
        ui_itemget_button_banner_cd: 0,
        auto_open_ad_cd: 0,
        auto_open_ad_interval: 60,
        auto_open_ad_start: 60,
        open_police: 0,
        police_speed_check: 0,
        advanced_game_style: 0,
        network_check_point: 0,
        newyear_time_total: [20230106, 20230122],
        newyear_time_task_and_fb: [20230106, 20230119],
        bag_data_compress: 0,
        tower_slot_show_ad: 0,
    };
    db.FB_CUSTOM_DB_ID = {
        NEWYEAR: "NEWYEAR",
    };
    db.game_cnf = {
        version: "v1.0",
        scene_game: "res/prefab/StageGame.prefab",
        slot_unlock_lv: [5, 10, 15, 20, 25, 30],
        slot_unlock_cost: [20, 80, 160, 320, 640, 1280],
        point_add_per_lv: 5,
        main_item_slot_unlock_lv: [20, 50, 95, 155, 230, 350, 500],
        tower_item_slot_unlock_cost: [100, 200, 400, 800, 1600, 3200],
        tower_item_slot_unlock_star: [1, 3, 5],
        pray_coin_desc: "普通祈愿可以直接获得钻石奖励。\n献上贡品可以获得%d倍于普通祈愿的奖励，同时今日内普通祈愿的数量增加%d。",
        pray_box_desc: "每过一段时间你可以领取一次奖励。\n你可以通过下方的光球看到未来的奖励品种和种类,品级越高获得的奖励越好。\n每2个小时生成一个新的光球，最多累积6个。",
        pray_box_interval: 7200,
        challenge_desc: "再次回顾挑战主线剧情中来袭的精锐部队，成功挑战则会获得奖励及一定的巅峰点数。（每日24时刷新）",
        summon_price_1: 200,
        summon_price_5: 980,
        summon_first_id: "2",
        talent_learn_cost: 5,
        damge_text_jump: [0.5, 20, 50, -50, -20, 5, 20],
        crossbow_skill_id_ad: "4000",
        crossbow_skill_id_ap: "4002",
        crossbow_bomb_id: "4001",
        crossbow_degree: 10,
        crossbow_delay: 0,
        crossbow_speed: 800,
        crossbow_aspeed: -50,
        crossbow_click_cd: 50,
        crossbow_time: 0.8,
        crossbow_energy_cost: 22,
        crossbow_energy_recover: 25,
        holyitem_moon_stone: 0.4,
        drop_prob_enemy: 0.3,
        drop_prob_boss: 8,
        drop_item_time: [600, 600],
        drop_item_cd: [5, 115],
        task_mini_cd: 15,
        task_mini_ids: ["12", "1", "5", "12", "13", "6", "12", "1", "5", "3", "1", "6", "13", "11", "12", "5", "6", "1", "16", "12", "13", "1"],
        task_daily_ids: ["1001", "1002", "1004", "1005", "1006", "1007"],
        time_offline_min: 5,
        time_offline_max: 480,
        offline_limit_coin: 5000000,
        offline_limit_diamond: 100000,
        damage_float_range: [0.9, 1.1],
        enemy_speed_min: 0.4,
        enemy_atk_speed_min: 0.4,
        buff_damage_hp_limit_ap: 0.8,
        buff_damage_hp_limit_ad: 0.8,
        holyitem_bag_size: 48,
        bag_ex_cost: 50,
        bag_ex_add: 6,
        holyitem_bag_size_max: 2000,
        summon_card_prob: ["橙色英雄_1%", "紫色英雄_5%", "蓝色英雄_10%", "绿色英雄_15%", "橙色圣物_1%", "紫色圣物_10%", "蓝色圣物_29%", "绿色圣物_29%"],
        pray_box_init_ids: ["7", "10", "4", "5", "3", "6"],
        guide_tip_time_init: 15,
        guide_tip_time_hide: 25,
        guide_tip_time_cd_auto: 25,
        guide_tip_time_cd_hand: 45,
        guide_tip_time_level: 60,
        tip_piece_desc: "召唤到重复的英雄会转化为英雄碎片（英雄满阶时将会把英雄碎片转化为万能碎片），万能碎片能代替英雄碎片对英雄进行升阶。",
        tip_star_up_desc: "当英雄碎片满了之后可以对英雄进行升阶，升阶会为英雄提供不同的效果，碎片不足时也可以使用万能碎片来作为替代",
        tip_talent_desc: "玩家可以通过每日进行挑战模式来获得大量的巅峰灵石，也可以通过循环任务小概率获得巅峰灵石，消耗巅峰灵石可以随机学习巅峰天赋获得大幅度强化，巅峰天赋的属性仅对主塔生效。",
        tip_goal_desc: "玩家可以通过完成每日任务，成就任务，循环任务来获得大量战令经验，战令每次升级都可以获得相应的道具或者货币的奖励，也可以通过看广告来获得额外的奖励。",
        cdk_main_lv_limit: 20,
        talent_action_interval: 600,
        shop_extra_cd: 3600,
        shop_businessman_cd: 10800,
        shop_businessman_refresh_cost: 100,
        level_game_scale_3: 250,
        icebreak_tower_id_free: "18",
        icebreak_tower_id_ad: "3",
        icebreak_tower_lv: 5,
        secret_reset_week: 4,
        secret_yearweek_offset: 33,
        secret_daily_count: 4,
        secret_count_buy_ad: 6,
        tower_lv_break_items: [1007, 25, 1006, 35, 1000, 2000],
        tower_lv_break_add: 50,
        hp_recover_enemy_dead_range: 4,
        holyitem_config_35: 35,
        holyitem_config_38: 30,
        holyitem_config_38_cd: 5,
        holyitem_config_40: 0.06,
        holyitem_config_41: 0.25,
        holyitem_config_43: 60,
        holyitem_config_45: "3045",
        holyitem_config_46: 0.05,
        daily_damage_time: 60,
        fb_sweep_ticket: 7,
        all_equip_crit_2_crit_dmg: 2.5,
        explore_daily_count: 2,
        explore_count_buy_ad: 2,
        next_dmg_crit_factor: 1.5,
        next_dmg_crit_damage_factor: 1.75,
        cd_record_upload_hand: 8,
        subscription_reward_notice: [1000, 400, 1006, 10, 1007, 10, 1011, 3],
        subscription_reward_offline: [1000, 100, 1006, 3, 1007, 3, 1011, 1],
        grow_newbie_level: 100,
        grow_alert_cd: 6,
        grow_alert_day: 3,
        summon_best_count: 100,
        summon_best_limit: 1,
        summon_best_id: "1",
        bag_init_item_id: ["1", "2", "3", "4"],
        bag_init_item_quality: [1, 0, 0, 0],
        newyear_firecracker_cost_fu: 2,
        newyear_firecracker_get_num: [80, 120],
        secret_shop_exchange_ids: ["35", "36", "37"],
        auto_drop_item_custom_time: 3,
    };
    db.MAGIC_DB_ID = {
        buff1: "buff1",
    };
    db.SUBSCRIPTION_DB_NAME = {
        NOTICE: "NOTICE",
        OFFLINE: "OFFLINE",
        NEXTDAY: "NEXTDAY",
    };
    db.SUB_COP_SUBCOPKEY = {
        b_share: "b_share",
        b_jump_other_game: "b_jump_other_game",
        b_record_video: "b_record_video",
        b_cdk: "b_cdk",
        b_kefu_email: "b_kefu_email",
        b_more_game: "b_more_game",
        b_jump_other_game_banner: "b_jump_other_game_banner",
        for_ad_h5: "for_ad_h5",
        b_jump_other_game_left: "b_jump_other_game_left",
        b_reward_more_game: "b_reward_more_game",
    };
    db.TASK_EVENT_ID = {
        LOGIN: "LOGIN",
        CROSSBOW: "CROSSBOW",
        SKILL_HAND: "SKILL_HAND",
        DEAD_ENEMY: "DEAD_ENEMY",
        DEAD_BOSS: "DEAD_BOSS",
        LVUP_TOWER_MAIN: "LVUP_TOWER_MAIN",
        LVUP_TOWER: "LVUP_TOWER",
        COLLECT_HOLYITEM_QUALITY_0: "COLLECT_HOLYITEM_QUALITY_0",
        COLLECT_HOLYITEM_QUALITY_1: "COLLECT_HOLYITEM_QUALITY_1",
        COLLECT_HOLYITEM_QUALITY_2: "COLLECT_HOLYITEM_QUALITY_2",
        COLLECT_HOLYITEM_QUALITY_3: "COLLECT_HOLYITEM_QUALITY_3",
        LVUP_HOLYITEM: "LVUP_HOLYITEM",
        COLLECT_HOLYITEM: "COLLECT_HOLYITEM",
        COMPLETE_MAIN_STORY: "COMPLETE_MAIN_STORY",
        COMPLETE_TOWER_RUSH: "COMPLETE_TOWER_RUSH",
        PICKUP_COIN: "PICKUP_COIN",
        PICKUP_BOX: "PICKUP_BOX",
        OPEN_PRAY_BOX: "OPEN_PRAY_BOX",
        AD_VIDEO: "AD_VIDEO",
        SUMMON_TOWER_QUALITY_0: "SUMMON_TOWER_QUALITY_0",
        SUMMON_TOWER_QUALITY_1: "SUMMON_TOWER_QUALITY_1",
        SUMMON_TOWER_QUALITY_2: "SUMMON_TOWER_QUALITY_2",
        SUMMON_TOWER_QUALITY_3: "SUMMON_TOWER_QUALITY_3",
        SUMMON_TOWER: "SUMMON_TOWER",
        PASS_MAIN_STORY: "PASS_MAIN_STORY",
        OPEN_PRAY_COIN: "OPEN_PRAY_COIN",
        PASS_TOWER_RUSH: "PASS_TOWER_RUSH",
        GET_SHOP_ITEM: "GET_SHOP_ITEM",
        TALENT_LEARN: "TALENT_LEARN",
        COMPLETE_BOSS: "COMPLETE_BOSS",
        COMPLETE_TASK_MINI: "COMPLETE_TASK_MINI",
        COMPLETE_FB_COIN: "COMPLETE_FB_COIN",
        COMPLETE_FB_ITEM: "COMPLETE_FB_ITEM",
        NEWYEAR_SIGN: "NEWYEAR_SIGN",
        NEWYEAR_BEAT_NIAN: "NEWYEAR_BEAT_NIAN",
        NEWYEAR_SHOP_EXCHANGE: "NEWYEAR_SHOP_EXCHANGE",
    };

    const BASE_MSG = {
        VIEW_RESIZE: "VIEW_RESIZE",
        SYS_SHOW: "SYS_SHOW",
        SYS_HIDE: "SYS_HIDE",
        SYS_KEY_DOWN: "SYS_KEY_DOWN",
        SYS_KEY_UP: "SYS_KEY_UP",
        RES_LOAD_START: "RES_LOAD_START",
        RES_LOAD_PROGRESS: "RES_LOAD_PROGRESS",
        RES_LOAD_END: "RES_LOAD_END",
        CFG_LOAD_FINISH: "CFG_LOAD_FINISH",
        UI_SHOW_TIP: "UI_SHOW_TIP",
        SDK_EXIT_GAME: "SDK_EXIT_GAME",
        SDK_VIDEO_VISIBLE: "SDK_VIDEO_VISIBLE",
        SDK_SHARE_SUC: "SDK_SHARE_SUC",
        SDK_SHARE_FAIL: "SDK_SHARE_FAIL",
        SDK_LOGIN_STATE: "SDK_LOGIN_STATE",
        SDK_LOGIN_RESULT: "SDK_LOGIN_RESULT",
        SDK_INSTALL_SHORTCUT_SUC: "SDK_INSTALL_SHORTCUT_SUC",
        SDK_GET_SHORTCUT_STATE_SUC: "SDK_GET_SHORTCUT_STATE_SUC",
        SDK_COP_CHANGED: "SDK_COP_CHANGED",
        SDK_VIDEO_SHARE_SUC: "SDK_VIDEO_SHARE_SUC",
        SDK_VIDEO_SHARE_FAIL: "SDK_VIDEO_SHARE_FAIL",
        SDK_OPEN_JUMP_RESULT: "SDK_OPEN_JUMP_RESULT",
        SDK_JUMP_GAME_SUC: "SDK_JUMP_GAME_SUC",
        SDK_JUMP_GAME_REWARD: "SDK_JUMP_GAME_REWARD",
        SDK_FOLLOW_OFFICIAL_ACCOUNT_SUC: "SDK_FOLLOW_OFFICIAL_ACCOUNT_SUC",
        SDK_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_SUC: "SDK_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_SUC",
        SDK_CONTENT_CHECK_RESULT: "SDK_CONTENT_CHECK_RESULT",
        SDK_BASE_CHANNEL_INFO_CHANGED: "SDK_BASE_CHANNEL_INFO_CHANGED",
        SDK_SERVER_TIME_CHANGE: "SDK_SERVER_TIME_CHANGE",
        SDK_PRE_PAY: "SDK_PRE_PAY",
        SDK_ADD_ITEM: "SDK_ADD_ITEM",
        RECORD_GAME_VIDEO_RESULT: "RECORD_GAME_VIDEO_RESULT",
        SHARE_VIDEO_RESULT: "SHARE_VIDEO_RESULT",
        VIDEO_RECORDER_STATUS_CHANGED: "VIDEO_RECORDER_STATUS_CHANGED",
        ADV_SHOW_SUC: "ADV_SHOW_SUC",
        ADV_SHOW_FAIL: "ADV_SHOW_FAIL",
        ADV_CLICK_SUC: "ADV_CLICK_SUC",
        NATIVE_ADV_LOADED: "NATIVE_ADV_LOADED",
        ADV_CLOSE_NATIVE_BANNER: "ADV_CLOSE_NATIVE_BANNER",
        BASE_MGR_LOADED: "BASE_MGR_LOADED",
        PANEL_OPEN_COMPLETE: "PANEL_OPEN_COMPLETE",
        PANEL_CLOSE: "PANEL_CLOSE",
        PANEL_SHOW: "PANEL_SHOW",
        PANEL_HIDE: "PANEL_HIDE",
        UI_PANEL_CLOSED: "UI_PANEL_CLOSED",
        ITEM_CHANGE: "ITEM_CHANGE",
        ITEM_USE: "ITEM_USE",
        GOAL_STATE_CHANGE: "GOAL_STATE_CHANGE",
        DAILY_SWITCH_ACTIVE: "DAILY_SWITCH_ACTIVE",
        QUEST_STATE_CHANGE: "QUEST_STATE_CHANGE",
        UP_STATE_CHANGE: "UP_STATE_CHANGE",
        PAY_SUC: "PAY_SUC",
        SDK_GUIDE_SKIP: "SDK_GUIDE_SKIP",
        SDK_CHECK_DEBUG_WHITE_USER_RESULT: "SDK_CHECK_DEBUG_WHITE_USER_RESULT",
        SDK_GET_SUBSCRIBE_STATE_RESULT: "SDK_GET_SUBSCRIBE_STATE_RESULT",
        SDK_ADD_SUBSCRIBE_RESULT: "SDK_ADD_SUBSCRIBE_RESULT",
        SDK_CHECK_NETWORK_RESULT: "SDK_CHECK_NETWORK_RESULT",
    };
    const RES_TYPE = {
        BUFFER: Laya.Loader.BUFFER,
        PREFAB2D: Laya.Loader.PREFAB,
        IMAGE: Laya.Loader.IMAGE,
        TEXT: Laya.Loader.TEXT,
        JSON: Laya.Loader.JSON,
        SOUND: Laya.Loader.SOUND,
        ATLAS: Laya.Loader.ATLAS,
        PREFAB3D: Laya.Loader.HIERARCHY,
        MATERIAL: Laya.Loader.MATERIAL,
        TEXTURE2D: Laya.Loader.TEXTURE2D,
        MESH: Laya.Loader.MESH,
        ANIMATIONCLIP: Laya.Loader.ANIMATIONCLIP,
        TEXTURECUBE: Laya.Loader.TEXTURECUBE,
    };
    var GOAL_TYPE;
    (function (GOAL_TYPE) {
        GOAL_TYPE["QUEST"] = "QUEST";
        GOAL_TYPE["SWITCH"] = "SWITCH";
    })(GOAL_TYPE || (GOAL_TYPE = {}));
    const BASE_ACTION_ID = {
        ITEM_GET: "ITEM_GET",
        ITEM_USE: "ITEM_USE",
        PAY_SUC: "PAY_SUC",
        SHARE: "SHARE",
        LEVEL_UP: "LEVEL_UP",
        LEVEL_UP_KEY: "LEVEL_UP_KEY",
        LEVEL_UP_KEY_MAX: "LEVEL_UP_KEY_MAX",
        QUEST_FINISH: "QUEST_FINISH",
        QUEST_FINISH_COUNT: "QUEST_FINISH_COUNT",
        VIDEO_SHOW_SUC: "VIDEO_SHOW_SUC",
    };
    const BASE_SWITCH_ID = {
        DAILY: "1",
        WEEKLY: "2",
    };
    const UpAttrName = {
        Base: "baseUp",
    };

    class FguiEffect extends Laya.Script {
        onAwake() {
        }
        onStart() {
            this.loadEffect();
        }
        onDestroy() {
            this.unloadEffect();
        }
        show() {
            if (this.effect)
                this.effect.show();
        }
        hide() {
            if (this.effect)
                this.effect.hide();
        }
        loadEffect() {
            if (FguiEffect.funcCreater && !this.effect) {
                this.effect = FguiEffect.funcCreater(this, this.root);
            }
        }
        unloadEffect() {
            if (FguiEffect.funcDestroy && this.effect) {
                FguiEffect.funcDestroy(this, this.effect);
            }
        }
        get guiNode() {
            return this._guiNode;
        }
        setGuiNode(node) {
            this._guiNode = node;
            return this;
        }
        get root() {
            return this._root;
        }
        setRoot(view) {
            this._root = view;
            return this;
        }
        static setEffectCreater(funcCreater) {
            this.funcCreater = funcCreater;
        }
        static setEffectDestroy(funcDestroy) {
            this.funcDestroy = funcDestroy;
        }
    }

    class ScaleButton extends Laya.Script {
        constructor() {
            super(...arguments);
            this.bTween = true;
            this.bTouchBegin = false;
        }
        get guiNode() {
            return this._guiNode;
        }
        setGuiNode(node) {
            this._guiNode = node;
            return this;
        }
        stopEvent(e) {
            e && e.stopPropagation && e.stopPropagation();
        }
        onMouseDown(e) {
            this.bTouchBegin = true;
            if (!this.bTween || !this._guiNode)
                return;
            fgui.GRoot.inst.playOneShotSound(fgui.UIConfig.buttonSound);
            Laya.Tween.to(this._guiNode, { scaleX: 1.1, scaleY: 1.1 }, 50);
        }
        onMouseUp(e) {
            this.bTouchBegin = false;
            if (!this.bTween || !this._guiNode)
                return;
            Laya.Tween.to(this._guiNode, { scaleX: 1, scaleY: 1 }, 50, Laya.Ease.backOut);
        }
        onMouseOut(e) {
            if (!this.bTouchBegin)
                return;
            this.bTouchBegin = false;
            if (!this.bTween || !this._guiNode)
                return;
            Laya.Tween.to(this._guiNode, { scaleX: 1, scaleY: 1 }, 50, Laya.Ease.backOut);
        }
        size(width, height) {
            if (!this.guiNode)
                return;
            this.guiNode.setSize(width, height);
        }
        scale(scaleX, scaleY) {
            if (!this.guiNode)
                return;
            this.guiNode.scaleX = scaleX;
            this.guiNode.scaleY = scaleY;
        }
        set visible(visible) {
            if (!this.guiNode)
                return;
            this.guiNode.visible = visible;
        }
        get visible() {
            if (!this.guiNode)
                return;
            return this.guiNode.visible;
        }
        set x(x) {
            if (!this.guiNode)
                return;
            this.guiNode.x = x;
        }
        get x() {
            if (!this.guiNode)
                return;
            return this.guiNode.x;
        }
        set y(y) {
            if (!this.guiNode)
                return;
            this.guiNode.y = y;
        }
        get y() {
            if (!this.guiNode)
                return;
            return this.guiNode.y;
        }
        set scaleX(scaleX) {
            if (!this.guiNode)
                return;
            this.guiNode.scaleX = scaleX;
        }
        get scaleX() {
            if (!this.guiNode)
                return;
            return this.guiNode.scaleX;
        }
        set scaleY(scaleY) {
            if (!this.guiNode)
                return;
            this.guiNode.scaleY = scaleY;
        }
        get scaleY() {
            if (!this.guiNode)
                return;
            return this.guiNode.scaleY;
        }
        set alpha(alpha) {
            if (!this.guiNode)
                return;
            this.guiNode.alpha = alpha;
        }
        get alpha() {
            if (!this.guiNode)
                return;
            return this.guiNode.alpha;
        }
    }

    let emtpy_fun = function () { };
    class UpdateCom extends Laya.Script {
        constructor() {
            super(...arguments);
            this.update = emtpy_fun;
            this.lateUpdate = emtpy_fun;
        }
        onUpdate() {
            this.update();
        }
        onLateUpdate() {
            this.lateUpdate();
        }
    }

    let _gameStartTime = 0;
    let _lastUpdateTime = 0;
    let _curTime = 0;
    let _time = 0;
    let _deltaTime = 0;
    let _timeFromGameStart = 0;
    let _timeOffset = 0;
    class Timer {
        constructor(span, repeatCount, callback, caller) {
            this._repeatCount = -1;
            this._span = 1;
            this._callback = null;
            this._count = 0;
            this._bRunning = false;
            this._span = span;
            this._repeatCount = repeatCount;
            this._callback = callback;
            this._caller = caller;
        }
        static get now() {
            return Date.now() / 1000;
        }
        static get time() {
            return _time + _timeOffset;
        }
        static get deltaTime() {
            return _deltaTime;
        }
        static get timeFromGameStart() {
            return _timeFromGameStart;
        }
        static waitTime(value) {
            return new Promise(function (resolve, reject) {
                Timer.callLater(value, function () {
                    resolve();
                });
            });
        }
        static setTimeOffset(offset) {
            _timeOffset = offset;
        }
        static initTime() {
            _gameStartTime = this.now;
            this.updateTime();
        }
        static updateTime() {
            _curTime = this.now;
            _time = _curTime;
            _timeFromGameStart = _curTime - _gameStartTime;
            _deltaTime = _curTime - _lastUpdateTime;
            _lastUpdateTime = _curTime;
        }
        static callLater(span, callback, caller) {
            let timer = new Timer(span, 1, callback, caller);
            timer.start();
            return timer;
        }
        static callLaterFrame(span, callback, caller) {
            let timer = new Timer(span, 1, callback, caller);
            timer.startFrame();
            return timer;
        }
        static callLoop(span, callback, caller) {
            let timer = new Timer(span, -1, callback, caller);
            timer.start(!caller);
            return timer;
        }
        static callLoopFrame(span, callback, caller) {
            let timer = new Timer(span, -1, callback, caller);
            timer.startFrame(!caller);
            return timer;
        }
        _onSpan() {
            this._count++;
            if (this._caller && !Tools.isNodeVaild(this._caller)) {
                this.stop();
                return;
            }
            if (this._callback) {
                try {
                    this._callback(this);
                }
                catch (error) {
                    Logger.error("[警告] Timer._onSpan callback has error", error);
                }
            }
            if (this._repeatCount >= 0 && this._count >= this._repeatCount) {
                this.stop();
            }
        }
        isRunning() {
            return this._bRunning;
        }
        get isDone() {
            return this._repeatCount >= 0 && this._count >= this._repeatCount;
        }
        get count() {
            return this._count;
        }
        get span() {
            return this._span;
        }
        start(bIgnoreForeverWarn = false) {
            this.stop();
            if (!this._callback) {
                Logger.warn("警告] Timer.start callback未设置！");
                return this;
            }
            if (!bIgnoreForeverWarn && this._repeatCount < 0) {
                Logger.warn("警告] Timer.start, this timer will never stop!");
                Logger.warn("警告]     please use startAndBindToNode");
                Logger.warn("警告]     or your can stop timer in callback. use e:stop()");
            }
            this._count = 0;
            Laya.timer.loop(this.span * 1000, this, this._onSpan);
            this._bRunning = true;
            return this;
        }
        startFrame(bIgnoreForeverWarn = false) {
            this.stop();
            if (!this._callback) {
                Logger.warn("警告] Timer.start callback未设置！");
                return this;
            }
            if (!bIgnoreForeverWarn && this._repeatCount < 0) {
                Logger.warn("警告] Timer.start, this timer will never stop!");
                Logger.warn("警告]     please use startAndBindToNode");
                Logger.warn("警告]     or your can stop timer in callback. use e:stop()");
            }
            this._count = 0;
            Laya.timer.frameLoop(this.span, this, this._onSpan);
            this._bRunning = true;
            return this;
        }
        resetCount() {
            this._count = 0;
        }
        stop() {
            if (this._bRunning) {
                Laya.timer.clear(this, this._onSpan);
                this._bRunning = false;
            }
            return this;
        }
    }

    const LOG10 = Math.log(10);
    class Mathf {
        static log(value, newBase) {
            if (newBase == null) {
                return Math.log(value) / LOG10;
            }
            else {
                return Math.log(value) / Math.log(newBase);
            }
        }
        static getDigits(num) {
            return Math.floor(this.log(num));
        }
        static random(min, max) {
            if (min == null) {
                return Math.random();
            }
            else if (max == null) {
                return (Math.random() * min + 1) | 0;
            }
            else {
                return (Math.random() * (max - min + 1) + min) | 0;
            }
        }
        static randomPlusOrMinus() {
            return (this.random(2) - 1) * 2 - 1;
        }
        static trueOrFalse() {
            return Math.random() > 0.5;
        }
        static randomEnable(rate) {
            return this.random(100) <= rate;
        }
        static clamp01(value) {
            if (value > 1)
                return 1;
            else if (value < 0)
                return 0;
            else
                return value;
        }
        static clamp(value, min, max) {
            if (value < min)
                return min;
            else if (value > max)
                return max;
            else
                return value;
        }
        static sign(value) {
            if (value >= 0)
                return 1;
            else
                return -1;
        }
        static fuzzyEquals(value1, value2) {
            return Math.abs(value1 - value2) < this.EPSILON;
        }
        static lerp(min, max, t) {
            return min + (max - min) * this.clamp01(t);
        }
        static inverseLerp(min, max, cur) {
            if (min != max) {
                return this.clamp01((cur - min) / (max - min));
            }
            else {
                return 0;
            }
        }
        static lerpFromInverseLerp(valueMin, valueMax, fromMin, fromMax, fromValue) {
            return this.lerp(valueMin, valueMax, this.inverseLerp(fromMin, fromMax, fromValue));
        }
        static getFitScale(x, y, maxX, maxY) {
            let scaleX = maxX / x;
            let scaleY = maxY / y;
            return Math.min(scaleX, scaleY);
        }
        static round(value, digits) {
            digits = digits || 0;
            let num = this.roundPower10Double[digits];
            value *= num;
            return Math.round(value) / num;
        }
        static loop(value, min, max) {
            if (max == null) {
                max = min;
                min = 0;
            }
            if (value < min) {
                return min;
            }
            else {
                let v = (value - min) % (max - min);
                return min + v;
            }
        }
        static pingPong(value, min, max) {
            if (max == null) {
                max = min;
                min = 0;
            }
            if (value < min) {
                return min;
            }
            else {
                let d = max - min;
                let v1 = value - min;
                let s = Math.floor(v1 / d);
                let v2 = v1 % d;
                if (s % 2 == 0) {
                    return v2 + min;
                }
                else {
                    return max - v2;
                }
            }
        }
        static nextGaussian(mean, std_dev) {
            return mean + (this.uniform2NormalDistribution() * std_dev);
        }
        static uniform2NormalDistribution() {
            var sum = 0.0;
            for (var i = 0; i < 12; i++) {
                sum = sum + Math.random();
            }
            return sum - 6.0;
        }
        static circleRandom(...weights) {
            return this.arrCircleRandom(weights);
        }
        static arrCircleRandom(weights) {
            let sum = 0;
            for (let i = 0; i < weights.length; i++) {
                sum += weights[i];
            }
            if (sum <= 0)
                return -1;
            let random = Mathf.random(sum);
            for (let i = 0; i < weights.length; i++) {
                if (random <= weights[i]) {
                    return i;
                }
                random -= weights[i];
            }
            return -1;
        }
        static makeArray(len, shuffle = true) {
            let arr = new Array(len);
            for (let i = 0; i < len; i++) {
                arr[i] = i;
            }
            shuffle && this.shuffle(arr);
            return arr;
        }
        static randomFromArray(arr, removeIt) {
            if (arr && arr.length) {
                let idx = this.random(arr.length) - 1;
                if (removeIt) {
                    return arr.splice(idx, 1)[0];
                }
                else {
                    return arr[idx];
                }
            }
            else {
                return null;
            }
        }
        static randomArrFromArray(arr, count, removeIt) {
            let result = [];
            if (arr) {
                if (!removeIt) {
                    arr = arr.slice();
                }
                for (let i = Math.min(arr.length, count); i > 0; i--) {
                    result.push(this.randomFromArray(arr, true));
                }
            }
            return result;
        }
        static shuffle(data) {
            let temp;
            let rnd;
            for (let i = data.length - 1; i > 0; i--) {
                rnd = this.random(0, i);
                temp = data[i];
                data[i] = data[rnd];
                data[rnd] = temp;
            }
        }
        static swap(data, i, j) {
            let temp = data[i];
            data[i] = data[j];
            data[j] = temp;
        }
        static minIndex(values) {
            let minValue = Number.MAX_SAFE_INTEGER;
            let index = -1;
            for (let i = values.length - 1; i >= 0; i--) {
                if (values[i] <= minValue) {
                    minValue = values[i];
                    index = i;
                }
            }
            return index;
        }
        static distance(p1, p2) {
            let dx = p1.x - p2.x;
            let dy = p1.y - p2.y;
            return Math.sqrt(dx * dx + dy * dy);
        }
        static distance2(dx, dy) {
            return Math.sqrt(dx * dx + dy * dy);
        }
        static distanceSqr(p1, p2) {
            let dx = p1.x - p2.x;
            let dy = p1.y - p2.y;
            return dx * dx + dy * dy;
        }
        static distanceSqr2(dx, dy) {
            return dx * dx + dy * dy;
        }
        static point2line(a, b, s) {
            let sqrt = Math.sqrt;
            let pow = Math.pow;
            let ab = sqrt(pow((a.x - b.x), 2) + pow((a.y - b.y), 2) + pow((a.z - b.z), 2));
            let as = sqrt(pow((a.x - s.x), 2) + pow((a.y - s.y), 2) + pow((a.z - s.z), 2));
            let bs = sqrt(pow((s.x - b.x), 2) + pow((s.y - b.y), 2) + pow((s.z - b.z), 2));
            let cos_A = (pow(as, 2) + pow(ab, 2) - pow(bs, 2)) / (2 * ab * as);
            let sin_A = sqrt(1 - pow(cos_A, 2));
            return as * sin_A;
        }
        static easeInLogic(val) {
            return 1 - Math.sin(0.5 * Math.PI * (1 - val));
        }
        static easeOutLogic(val) {
            return Math.sin(0.5 * Math.PI * val);
        }
        static easeInOutLogic(val) {
            let pi2 = Math.PI * 2;
            return val - Math.sin(val * pi2) / pi2;
        }
        static bounceLogic(val) {
            if (val < 0.363636) {
                val = 7.5685 * val * val;
            }
            else if (val < 0.727272) {
                val = 7.5625 * (val -= 0.545454) * val + 0.75;
            }
            else if (val < 0.909090) {
                val = 7.5625 * (val -= 0.818181) * val + 0.9375;
            }
            else {
                val = 7.5625 * (val -= 0.9545454) * val + 0.984375;
            }
            return val;
        }
        static calcAngleA2B(A, B) {
            if (!A)
                return 0;
            if (!B)
                return 0;
            let magA = Laya.Vector3.scalarLength(A);
            let magB = Laya.Vector3.scalarLength(B);
            if (!magA)
                return 0;
            if (!magB)
                return 0;
            let cos_angle = Laya.Vector3.dot(A, B) / (magA * magB);
            let angle = Math.acos(cos_angle);
            return angle;
        }
    }
    Mathf.roundPower10Double = [
        1.0,
        10.0,
        100.0,
        1000.0,
        10000.0,
        100000.0,
        1000000.0,
        10000000.0,
        100000000.0,
        1000000000.0,
        10000000000.0,
        100000000000.0,
        1000000000000.0,
        10000000000000.0,
        100000000000000.0,
        1E+15
    ];
    Mathf.PI = 3.14159274;
    Mathf.Deg2Rad = 0.0174532924;
    Mathf.Rad2Deg = 57.295779;
    Mathf.TEMP_POINT = new Laya.Point();
    Mathf.TEMP_POINTS = [
        new Laya.Point(),
        new Laya.Point(),
        new Laya.Point(),
        new Laya.Point(),
    ];
    Mathf.TempRect = Laya.Rectangle.create();
    Mathf.VEC3_UP = new Laya.Vector3(0, 1, 0);
    Mathf.TEMP_VEC3 = new Laya.Vector3();
    Mathf.TEMP_VEC3S = [
        new Laya.Vector3(),
        new Laya.Vector3(),
        new Laya.Vector3(),
        new Laya.Vector3(),
    ];
    Mathf.EPSILON = 1e-6;

    class ResLoader {
        static tryLoadRes(url) {
            return Laya.loader.getRes(url);
        }
        static loadRes(url, type, completeCallback) {
            completeCallback = completeCallback || this.EMPTY_FUN;
            let resource = Laya.loader.getRes(url);
            if (resource != null) {
                completeCallback(resource);
                return;
            }
            if (this.loadingCallback[url]) {
                this.loadingCallback[url].calls.push(completeCallback);
                return;
            }
            else {
                this.loadingCallback[url] = { calls: [completeCallback], loadCount: 1 };
            }
            let loadCallback;
            loadCallback = (res) => {
                let callbacks = this.loadingCallback[url];
                if (callbacks) {
                    if (res) {
                        let calls = callbacks.calls;
                        delete this.loadingCallback[url];
                        for (let i = 0; i < calls.length; i++) {
                            calls[i](res);
                        }
                    }
                    else {
                        Logger.error(`mgrRes.loadRes load [${url}] err.`);
                        if (callbacks.loadCount <= this.retryCount) {
                            callbacks.loadCount++;
                            this._loadRes(url, type, loadCallback);
                        }
                        else {
                            let calls = callbacks.calls;
                            delete this.loadingCallback[url];
                            for (let i = 0; i < calls.length; i++) {
                                calls[i](null);
                            }
                        }
                    }
                }
                else {
                    Logger.warn("mgrRes loadCallback: No Loaded Callback Exists! ", url);
                }
            };
            this._loadRes(url, type, loadCallback);
        }
        static _loadRes(url, type, completeCallback) {
            let handler = Laya.Handler.create(this, function (res) {
                try {
                    completeCallback(res);
                }
                catch (error) {
                    Logger.catchError("mgrRes._loadRes complete", error);
                }
            });
            switch (type) {
                case RES_TYPE.PREFAB2D:
                case RES_TYPE.IMAGE:
                case RES_TYPE.TEXT:
                case RES_TYPE.JSON:
                case RES_TYPE.SOUND:
                case RES_TYPE.ATLAS:
                    Laya.loader.load(url, handler, null, type);
                    return;
                case RES_TYPE.PREFAB3D:
                case RES_TYPE.MATERIAL:
                case RES_TYPE.TEXTURE2D:
                case RES_TYPE.MESH:
                case RES_TYPE.ANIMATIONCLIP:
                case RES_TYPE.TEXTURECUBE:
                    Laya.loader.create(url, handler, null, type);
                    return;
                default:
                    Logger.error("未知资源类型:", type);
                    break;
            }
        }
        static loadImageFromWeb(url, onComplete) {
            if (!url) {
                onComplete(null);
                return;
            }
            if (this.webResCache[url]) {
                onComplete(this.webResCache[url]);
                return;
            }
            Logger.error("本方法暂未实现.");
        }
        static loadImage(url, callback) {
            this.loadRes(url, RES_TYPE.IMAGE, callback);
        }
        static loadText(url, callback) {
            this.loadRes(url, RES_TYPE.TEXT, callback);
        }
        static loadJson(url, callback) {
            this.loadRes(url, RES_TYPE.JSON, callback);
        }
        static loadTexture2D(url, callback) {
            this.loadRes(url, RES_TYPE.TEXTURE2D, callback);
        }
        static loadAnimationClip(url, callback) {
            this.loadRes(url, RES_TYPE.ANIMATIONCLIP, callback);
        }
        static loadTextureCube(url, callback) {
            this.loadRes(url, RES_TYPE.TEXTURECUBE, callback);
        }
        static loadSprite3D(url, callback) {
            this.loadRes(url, RES_TYPE.PREFAB3D, function (res) {
                if (callback) {
                    if (res) {
                        res = Laya.Sprite3D.instantiate(res);
                    }
                    callback(res);
                }
            });
        }
    }
    ResLoader.EMPTY_FUN = function () { };
    ResLoader.retryCount = 0;
    ResLoader.loadingCallback = {};
    ResLoader.webResCache = {};

    class TaskManager {
        constructor(taskName = "", bLog = Logger.isDebugLevel) {
            this.destroyed = false;
            this.isLoaded = false;
            this.isLoading = false;
            this.taskName = "";
            this.urls = [];
            this.urlData = { prefab: [], d3: [], d2: [] };
            this.calls = [];
            this.resStartTime = 0;
            this.callStartTime = 0;
            this.progressCallback = null;
            this.completeCallback = null;
            if (taskName) {
                this.taskName = `(${taskName})`;
            }
            this.bLog = false;
        }
        get resCount() {
            return this.urls.length;
        }
        get totalCallWeight() {
            let value = 0;
            for (var i = this.calls.length - 1; i >= 0; i--) {
                value += this.calls[i].weight;
            }
            return value;
        }
        dispose() {
            this.destroyed = true;
            this.urlData = null;
            this.urls = null;
            this.calls = null;
            this.completeCallback = null;
            this.progressCallback = null;
        }
        setLoadingCallback(completeCallback, progressCallback) {
            this.completeCallback = completeCallback;
            this.progressCallback = progressCallback || Global.EMPTY_FUN;
        }
        addRes(url, type = Laya.Loader.PREFAB) {
            if (!url)
                return;
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            if (this.bLog)
                Logger.log(`TaskManager${this.taskName} add:${url} ${type}`);
            let urlData = this.urls;
            if (url instanceof Array) {
                for (let i = 0; i < url.length; i++) {
                    let item = url[i];
                    if (typeof item == "string") {
                        urlData.push({ url: item, type: type });
                    }
                    else {
                        urlData.push(item);
                    }
                }
            }
            else {
                if (typeof url == "string") {
                    urlData.push({ url: url, type: type });
                }
                else {
                    urlData.push(url);
                }
            }
        }
        addFguiPackage(resKey) {
            this.addCall(function (resolve) {
                fgui.UIPackage.loadPackage(resKey, Laya.Handler.create(this, resolve));
            });
        }
        addCall(call, weight = 1) {
            this.calls.push({ fuc: call, weight: weight });
        }
        clearDuplicateRes() {
            let urls = this.urls;
            let resMap = Object.create(null);
            for (let i = urls.length - 1; i >= 0; i--) {
                let item = urls[i];
                if (Laya.loader.getRes(item.url)) {
                    urls.splice(i, 1);
                    continue;
                }
                if (resMap[item.url]) {
                    urls.splice(i, 1);
                }
                else {
                    resMap[item.url] = true;
                }
            }
        }
        classifyRes() {
            this.clearDuplicateRes();
            if (this.urlData.prefab.length > 0 || this.urlData.d2.length > 0 || this.urlData.d3.length > 0)
                return;
            let urls = this.urls;
            for (let i = urls.length - 1; i >= 0; i--) {
                let item = urls[i];
                switch (item.type) {
                    case RES_TYPE.PREFAB2D:
                        this.urlData.prefab.push(item);
                        break;
                    case RES_TYPE.IMAGE:
                    case RES_TYPE.TEXT:
                    case RES_TYPE.JSON:
                    case RES_TYPE.SOUND:
                    case RES_TYPE.ATLAS:
                    case RES_TYPE.BUFFER:
                        this.urlData.d2.push(item);
                        break;
                    case RES_TYPE.PREFAB3D:
                    case RES_TYPE.MATERIAL:
                    case RES_TYPE.TEXTURE2D:
                    case RES_TYPE.MESH:
                    case RES_TYPE.ANIMATIONCLIP:
                    case RES_TYPE.TEXTURECUBE:
                        this.urlData.d3.push(item);
                        break;
                    default:
                        urls.splice(i, 1);
                        Logger.error(`TaskManager${this.taskName}.classifyRes 未知资源类型:${item.type}`);
                        break;
                }
            }
        }
        get isEmpty() {
            return this.resCount == 0;
        }
        loadAll() {
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            this.isLoading = true;
            this.resStartTime = Timer.time;
            this.classifyRes();
            if (this.resCount == 0) {
                this.onResLoadComplete(true);
                return;
            }
            let countPrefab = this.urlData.prefab.length;
            let count2D = this.urlData.d2.length;
            let count3D = this.urlData.d3.length;
            let countTotal = countPrefab + count2D + count3D + this.totalCallWeight;
            let progressPrefab = 0;
            let progress2D = 0;
            let progress3D = 0;
            let completeState = 0;
            let bError = false;
            let calcProgress = () => {
                var progress = progressPrefab * countPrefab + progress2D * count2D + progress3D * count3D;
                this.onProgress(progress / countTotal);
            };
            let checkComplete = (suc) => {
                completeState++;
                if (!suc)
                    bError = true;
                if (completeState == 3) {
                    if (bError) {
                        this.onResLoadComplete(false);
                        Logger.error(`TaskManager${this.taskName} 资源加载错误.`);
                    }
                    else {
                        this.onResLoadComplete(true);
                    }
                }
            };
            this._loadPrefab(checkComplete, function (p) {
                progressPrefab = p;
                calcProgress();
            });
            this._load2d(checkComplete, function (p) {
                progress2D = p;
                calcProgress();
            });
            this._load3d(checkComplete, function (p) {
                progress3D = p;
                calcProgress();
            });
        }
        _loadPrefab(complete, progress, loadIndex = 0) {
            if (loadIndex < this.urlData.prefab.length) {
                let item = this.urlData.prefab[loadIndex++];
                let onAllLoaded = (res) => {
                    if (res) {
                        progress(loadIndex / this.urlData.prefab.length);
                        this._loadPrefab(complete, progress, loadIndex);
                    }
                    else {
                        this.onComplete(false);
                    }
                };
                let onPrefabLoaded = (prefab) => {
                    if (prefab) {
                        if (prefab.json && prefab.json.loadList && prefab.json.loadList.length > 0) {
                            Laya.loader.load(prefab.json.loadList, Laya.Handler.create(this, onAllLoaded));
                            return;
                        }
                        onAllLoaded(true);
                    }
                    else {
                        onAllLoaded(false);
                    }
                };
                Laya.loader.load(item.url, Laya.Handler.create(this, onPrefabLoaded), null, item.type);
            }
            else {
                complete(true);
            }
        }
        _load2d(complete, progress) {
            if (this.urlData.d2.length > 0) {
                Laya.loader.load(this.urlData.d2, Laya.Handler.create(this, complete), Laya.Handler.create(this, progress));
            }
            else {
                complete(true);
            }
        }
        _load3d(complete, progress) {
            if (this.urlData.d3.length > 0) {
                Laya.loader.create(this.urlData.d3, Laya.Handler.create(this, complete), Laya.Handler.create(this, progress));
            }
            else {
                complete(true);
            }
        }
        loadOneByOne(deltaTime = 1) {
            if (this.isLoading) {
                Logger.error(`TaskManager${this.taskName} is loading!`);
                return;
            }
            this.isLoading = true;
            this.resStartTime = Timer.time;
            this.clearDuplicateRes();
            this._loadOneByOne(deltaTime * 1000);
        }
        _loadOneByOne(deltaTime) {
            if (this.destroyed)
                return;
            let urlData = this.urls.shift();
            if (urlData) {
                ResLoader.loadRes(urlData.url, urlData.type, (res) => {
                    if (res) {
                        Laya.timer.once(deltaTime, this, this._loadOneByOne, [deltaTime]);
                    }
                    else {
                        Logger.error(`TaskManager${this.taskName}.loadOneByOne error, url:${urlData.url}`);
                        this.onResLoadComplete(false);
                    }
                });
            }
            else {
                this.onResLoadComplete(true);
            }
        }
        onResLoadComplete(suc) {
            this.bLog && Logger.log(`TaskManager 资源加载结束:${suc}，耗时：${Mathf.round(Timer.time - this.resStartTime, 2)}`);
            if (suc) {
                this.bLog && Logger.log(`TaskManager${this.taskName} 开始执行call!`);
                this.callStartTime = Timer.time;
                this._processCalls();
            }
            else {
                this.onComplete(false);
            }
        }
        _processCalls(curCallIndex = 0) {
            this.curCallIndex = curCallIndex;
            if (curCallIndex >= this.calls.length) {
                this.onProgress(1);
                this.onComplete(true);
                return;
            }
            this.bLog && Logger.log(`TaskManager${this.taskName} 执行索引：`, curCallIndex);
            let curCompleteWeight = 0;
            for (var i = 0; i < curCallIndex; i++) {
                curCompleteWeight += this.calls[i].weight;
            }
            this.onProgress((curCompleteWeight + this.resCount) / (this.totalCallWeight + this.resCount));
            let callItem = this.calls[curCallIndex];
            try {
                let nextStep = () => {
                    Laya.timer.frameOnce(1, this, this._processCalls, [curCallIndex + 1]);
                };
                callItem.fuc(nextStep);
            }
            catch (error) {
                Logger.catchError(`TaskManager${this.taskName}._processCalls index:${curCallIndex}`, error);
                this.onComplete(false);
            }
        }
        setParent(loader) {
            if (this.parent) {
                Logger.warn(`TaskManager${this.taskName}.setParent: parent already exists.`);
            }
            this.parent = loader;
        }
        setCallProgress(percent) {
            if (this.curCallIndex < this.calls.length) {
                let curCompleteWeight = 0;
                for (var i = 0; i < this.curCallIndex; i++) {
                    curCompleteWeight += this.calls[i].weight;
                }
                curCompleteWeight += this.calls[this.curCallIndex].weight * percent;
                this.onProgress((curCompleteWeight + this.resCount) / (this.totalCallWeight + this.resCount));
            }
        }
        onProgress(percent) {
            if (this.progressCallback) {
                this.progressCallback(percent);
            }
            if (this.parent) {
                this.parent.setCallProgress(percent);
            }
            this.bLog && Logger.log(`TaskManager${this.taskName} 加载进度: [${Mathf.round(percent, 2)}]`);
        }
        onComplete(finish) {
            this.bLog && Logger.log(`TaskManager${this.taskName} 执行完成，耗时：${Mathf.round(Timer.time - this.callStartTime, 2)}`);
            this.bLog && Logger.log(`TaskManager${this.taskName} 总耗时：${Mathf.round(Timer.time - this.resStartTime, 2)}`);
            this.isLoaded = true;
            if (this.completeCallback) {
                try {
                    this.completeCallback(finish);
                }
                catch (error) {
                    Logger.catchError(`TaskManager${this.taskName}.onComplete[${finish}]`, error);
                }
            }
            this.dispose();
        }
    }

    class Manager {
        static loadAllManagers(finishCallback) {
            try {
                let tManager = new TaskManager("Manager");
                for (let i = 0; i < this._managerInstances.length; i++) {
                    let manager = this._managerInstances[i];
                    tManager.addCall((resolve) => {
                        manager.loadedCallback = () => {
                            resolve();
                        };
                        manager.onLoad();
                    });
                }
                tManager.setLoadingCallback(() => {
                    finishCallback();
                    this.startAllManagers();
                });
                tManager.loadAll();
            }
            catch (error) {
                console.warn("Manager.loadAllManager has error", error);
            }
        }
        static startAllManagers() {
            for (let i = 0; i < this._managerInstances.length; i++) {
                this._managerInstances[i].onStart();
            }
        }
        static checkRecord(data, dataDefault) {
            let needSave = false;
            for (let key in dataDefault) {
                let value = data[key];
                if (value == null) {
                    data[key] = dataDefault[key];
                    needSave = true;
                }
            }
            if (needSave) {
                this.saveRecord();
            }
        }
        static __init() {
            Manager._managerInstances.push(this);
        }
        static onLoad() {
            Global.registerListeners(this, {
                "MSG_RECORD_RESET": this.loadRecord,
            });
            if (!this._bNetworkResponseRegistered) {
                this._bNetworkResponseRegistered = true;
                this.onRegisterNetworkResponseListeners();
            }
            this.loadedCallback();
            this.loadRecord();
        }
        static onStart() {
        }
        static loadRecord() {
        }
        static saveRecord() {
        }
        static onRegisterNetworkResponseListeners() {
        }
    }
    Manager._managerInstances = [];
    Manager.loadedCallback = null;
    Manager._bNetworkResponseRegistered = false;

    const CLASS_KEY = "__mgr_class__";
    const FLAG_OPENING = "__mgr_flag_open__";
    const FLAG_LOADED = "__mgr_flag_loaded__";
    class Director {
        static get isSceneOpening() {
            return this._isSceneOpening;
        }
        static init() {
            this.initScene();
            console.log("Director.onLoad");
        }
        static runScene(sceneClass, loadingClass, params) {
            console.log("mgrScene startRun.", sceneClass);
            if (this._isSceneOpening) {
                console.error("mgr scene is busy");
                return;
            }
            this._isSceneOpening = true;
            if (loadingClass) {
                this.initScene();
                Director.openPanelWithSingleton(loadingClass, null, () => {
                    this.startLoading(sceneClass, params);
                });
            }
            else {
                this.startLoading(sceneClass, params);
            }
        }
        static startLoading(sceneClass, params) {
            Global.sendMsg(BASE_MSG.RES_LOAD_START, "收集能量");
            if (this.runningScene) {
                this.runningScene.onExit();
                this.runningScene = null;
            }
            let curScene;
            try {
                curScene = new sceneClass();
            }
            catch (error) {
                console.error("mgrScene.runScene:", error);
                return;
            }
            this.runingSceneClass = sceneClass;
            this.nextScene = curScene;
            this.nextSceneparams = params;
            let taskManager = curScene.getTaskManager();
            if (taskManager == null) {
                this.onTaskComplete(true);
            }
            else {
                taskManager.setLoadingCallback(this.onTaskComplete.bind(this), this.onTaskProgress.bind(this));
                taskManager.loadAll();
                console.log("mgrScene 开始加载.");
            }
        }
        static onTaskProgress(progress) {
            Global.sendMsg(BASE_MSG.RES_LOAD_PROGRESS, progress);
        }
        static onTaskComplete(suc) {
            console.log("mgrScene 加载完成.", suc);
            if (suc) {
                this.runningScene = this.nextScene;
                this.nextScene = null;
                let params = this.nextSceneparams;
                this.nextSceneparams = null;
                this._isSceneOpening = false;
                Global.sendMsg(BASE_MSG.RES_LOAD_END);
                this.runningScene.onEnter(params);
            }
            else {
                console.error("mgrSceen.onResComplete error.");
            }
        }
        static initScene() {
            this.init2DLayer();
        }
        static init2DLayer() {
            if (!this.layers2D) {
                this.layers2D = [];
                Laya.stage.addChild(fgui.GRoot.inst.displayObject);
                for (let i = 0; i <= 8; i++) {
                    let layer = new fgui.GComponent();
                    layer.name = "Layer" + i;
                    layer.displayObject.name = layer.name;
                    layer.makeFullScreen();
                    fgui.GRoot.inst.addChild(layer);
                    this.layers2D.push(layer);
                    this.view_stack.push([]);
                }
            }
        }
        static getTopViewName() {
            let node = fgui.GRoot.inst.getChild("Layer1");
            if (node.numChildren > 0)
                return node.getChildAt(node.numChildren - 1).name;
            else
                return "";
        }
        static getLayer(layer = 2) {
            return this.layers2D[layer];
        }
        static getDialogLayer() {
            return this.getLayer;
        }
        static getTipRoot() {
            return this.getLayer(6);
        }
        static createScene3DLayer(layer) {
            if (this.layerScene3d[layer]) {
                return this.layerScene3d[layer];
            }
            let scene3d = new Laya.Scene3D();
            this.getLayer(layer).displayObject.addChild(scene3d);
            var camera = scene3d.addChild(new Laya.Camera(0, 0.1, 20));
            camera.orthographic = true;
            camera.orthographicVerticalSize *= UIRoot.canvasHeight / 1024;
            camera.transform.position = new Laya.Vector3(0, 0, 10);
            camera.clearFlag = Laya.CameraClearFlags.DepthOnly;
            let data = { scene3d: scene3d, camera: camera };
            this.layerScene3d[layer] = data;
            return data;
        }
        static getScene3DLayer(layer) {
            return this.layerScene3d[layer];
        }
        static destroyScene3DLayer(layer) {
            let data = this.getScene3DLayer(layer);
            if (data) {
                data.scene3d.destroy();
            }
            this.layerScene3d[layer] = null;
        }
        static pushStack(panel, layer) {
            let stack = this.view_stack[layer];
            if (stack) {
                stack.push(panel);
            }
            else {
                console.error(`push panel invalid layer: ${layer}`);
            }
        }
        static peekStack(layer, fromIdx) {
            let stack = this.view_stack[layer];
            if (stack) {
                if (fromIdx == null)
                    return stack[stack.length - 1];
                else {
                    for (var i = fromIdx; i >= 0; i--) {
                        if (stack[i])
                            return stack[i];
                    }
                    return null;
                }
            }
            else {
                console.error(`pop panel invalid layer:${layer}}`);
            }
        }
        static removeAndDispose(panel) {
            if (panel) {
                let stack = this.view_stack[panel.panelLayer];
                let index = -1;
                for (let i = 0; i < stack.length; i++) {
                    if (stack[i] === panel) {
                        panel[CLASS_KEY][FLAG_OPENING] = false;
                        stack.splice(i, 1);
                        index = i;
                        break;
                    }
                }
                if (index < 0)
                    console.error(`can't remove panel:${panel.sourceName} in layer:${panel.panelLayer}`);
                panel.dispose();
                return index;
            }
            return -1;
        }
        static closePanel(panel) {
            if (!panel || !panel.isLoaded)
                return;
            if (panel.isFocus)
                panel.onFocus(false);
            let layer = panel.panelLayer;
            let style = panel.panelStyle;
            let idx = this.removeAndDispose(panel);
            if (idx > 0) {
                let curPanel = this.peekStack(layer, idx - 1);
                if (!curPanel)
                    return;
                if (curPanel.panelStyle == 0) {
                }
                else if (curPanel.panelStyle == style) {
                    curPanel.show();
                }
                else if (style == 1) {
                    curPanel.show();
                }
                if (this.peekStack(layer) === curPanel)
                    curPanel.onFocus(true);
            }
        }
        static hasLoaded(panelClass) {
            return !!panelClass[FLAG_LOADED];
        }
        static getPanelClass(panel) {
            if (typeof panel == "string") {
                return Global.require(panel);
            }
            else {
                return panel;
            }
        }
        static openPanel(panel, context, callback) {
            let panelClass = this.getPanelClass(panel);
            if (!panelClass) {
                callback && callback();
                return;
            }
            var panelInstance = new panelClass(context);
            panelInstance.name = panel;
            return this.openPanelInstance(panelInstance, panelClass, callback);
        }
        static openPanelByClass(panelClass, panelName, context, callback) {
            var panelInstance = new panelClass(context);
            panelInstance.name = panelName;
            return this.openPanelInstance(panelInstance, panelClass, callback);
        }
        static openPanelInstance(panel, panelClass, callback) {
            panel[CLASS_KEY] = panelClass;
            panel.create(function (suc) {
                if (suc)
                    panelClass[FLAG_LOADED] = true;
                callback && callback(suc);
                console.log("打开:" + panel.sourceName, suc);
            });
            return panel;
        }
        static openPanelWithSingleton(panel, context, callback) {
            let panelClass = this.getPanelClass(panel);
            if (!panelClass) {
                callback && callback(false);
                return;
            }
            let view = this.findPanel(panelClass);
            if (view) {
                callback && callback(true);
                view.setContext(context);
                view.setTop();
                view.show();
            }
            else {
                if (panelClass[FLAG_OPENING]) {
                    console.info(`${panelClass} is opening`);
                    return;
                }
                panelClass[FLAG_OPENING] = true;
                this.openPanel(panel, context, function (suc) {
                    panelClass[FLAG_OPENING] = false;
                    callback && callback(suc);
                });
            }
        }
        static openPanelWithSingletonByClass(panelClass, panelName, context, callback) {
            let view = this.findPanel(panelClass);
            if (view) {
                callback && callback(true);
                view.setContext(context);
                view.setTop();
                view.show();
            }
            else {
                if (panelClass[FLAG_OPENING]) {
                    console.info(`${panelClass} is opening`);
                    return;
                }
                panelClass[FLAG_OPENING] = true;
                this.openPanelByClass(panelClass, panelName, context, function (suc) {
                    panelClass[FLAG_OPENING] = false;
                    callback && callback(suc);
                });
            }
        }
        static openPanelByWait(panel, context, callback) {
            this.showWait("open_panel");
            this.openPanel(panel, context, (suc) => {
                this.hideWait("open_panel");
                callback && callback(suc);
            });
        }
        static showWait(router = "default") {
            if (~this.waitRouters.indexOf(router))
                return;
            this.waitRouters.push(router);
            if (!this.waitPanel) {
                this.waitPanel = this.openPanel("PanelWait");
            }
        }
        static hideWait(router = "default") {
            let idx = this.waitRouters.indexOf(router);
            if (idx != -1) {
                this.waitRouters.splice(idx, 1);
            }
            if (this.waitRouters.length == 0) {
                if (this.waitPanel) {
                    this.waitPanel.close();
                    this.waitPanel = null;
                }
            }
        }
        static findPanel(panelClass, layer) {
            for (let layerIdx = 0; layerIdx < this.view_stack.length; layerIdx++) {
                if (layer == null || layer == layerIdx) {
                    const stack = this.view_stack[layerIdx];
                    for (let j = 0; j < stack.length; j++) {
                        const panel = stack[j];
                        if (panel[CLASS_KEY] == panelClass)
                            return panel;
                    }
                }
            }
            return null;
        }
        static findPanelLocalBanner() {
            return this.findPanelByName("PanelLocalBanner");
        }
        static findPanelByName(panelName) {
            for (let layer = 0; layer < this.view_stack.length; layer++) {
                const stack = this.view_stack[layer];
                for (let j = 0; j < stack.length; j++) {
                    const panel = stack[j];
                    let arr = panel.sourceName.split("/");
                    if (arr && arr.length > 0) {
                        if (arr[arr.length - 1] == panelName) {
                            return panel;
                        }
                    }
                }
            }
            return null;
        }
        static addPanel(panel) {
            let layer = panel.panelLayer;
            let style = panel.panelStyle;
            let topPanel = this.peekStack(layer);
            this.pushStack(panel, layer);
            this.getLayer(layer).addChild(panel);
            if (topPanel) {
                if (topPanel.panelStyle == 0) {
                }
                else if (topPanel.panelStyle == style) {
                    topPanel.hide();
                }
                else if (style == 1) {
                    topPanel.hide();
                }
                topPanel.onFocus(false);
            }
            panel.onFocus(true);
        }
        static disposeAllPanel(layerExcept) {
            for (let i = 0; i < this.view_stack.length; i++) {
                if (layerExcept == null || i != layerExcept) {
                    const stack = this.view_stack[i];
                    for (let j = 0; j < stack.length; j++) {
                        const panel = stack[j];
                        panel[CLASS_KEY][FLAG_OPENING] = false;
                        panel.onFocus(false);
                        panel.dispose();
                    }
                    this.view_stack[i] = [];
                }
            }
        }
        static closeTop(layer) {
            if (layer == null) {
                for (let i = this.view_stack.length - 1; i >= 0; i--) {
                    const stack = this.view_stack[i];
                    for (let j = stack.length - 1; j >= 0; j--) {
                        const panel = stack[j];
                        if (panel.visible) {
                            panel.close();
                            console.info("close top:", panel.sourceName);
                            return;
                        }
                    }
                }
            }
            else {
                const stack = this.view_stack[layer];
                for (let j = stack.length - 1; j >= 0; j--) {
                    const panel = stack[j];
                    if (panel.visible) {
                        panel.close();
                        console.info("close top:", panel.sourceName);
                        return;
                    }
                }
            }
        }
        static closeLayer(layer) {
            for (let i = this.view_stack.length - 1; i >= 0; i--) {
                if (layer == null || i == layer) {
                    const stack = this.view_stack[i];
                    for (let j = stack.length - 1; j >= 0; j--) {
                        const panel = stack[j];
                        if (panel.visible) {
                            panel.close();
                        }
                    }
                }
            }
        }
        static debugPanels() {
            console.log("------ debug panels start ------");
            for (let i = 0; i < this.view_stack.length; i++) {
                const stack = this.view_stack[i];
                for (let j = 0; j < stack.length; j++) {
                    const panel = stack[j];
                    console.log(`layer:[${i}]  name:[${panel.sourceName}] visible:[${panel.visible}]`);
                }
            }
            console.log("------ debug panels end ------");
        }
        static isDeviceOverHeight() {
            return Laya.stage.height / Laya.stage.width >= 2;
        }
        static get maxRatio() {
            return 2;
        }
        static get standardRatio() {
            return 1024 / 576;
        }
        static get ratioLerpValue() {
            let cur = Laya.stage.height / Laya.stage.width;
            cur = Mathf.clamp(cur, this.standardRatio, this.maxRatio);
            return (cur - this.standardRatio) / (this.maxRatio - this.standardRatio);
        }
        static get width() {
            return Laya.stage.width;
        }
        static get height() {
            return Laya.stage.height;
        }
        static isSceneRuning(sceneClass) {
            return this.runingSceneClass == sceneClass;
        }
    }
    Director._isSceneOpening = false;
    Director.runingSceneClass = null;
    Director.runningScene = null;
    Director.nextScene = null;
    Director.nextSceneparams = null;
    Director.view_stack = [];
    Director.waitRouters = [];
    Director.layerScene3d = [];

    function logID(id) {
        console.log(id);
    }
    function errorID(id) {
        console.error(id);
    }
    function warnID(id, opt) {
        console.warn(id, opt);
    }

    let ID_COUNTER = 0;
    class HashElement {
        constructor() {
            this.actions = [];
            this.target = null;
            this.actionIndex = 0;
            this.currentAction = null;
            this.paused = false;
            this.lock = false;
        }
    }
    class ActionManager {
        constructor() {
            this._hashTargets = Object.create(null);
            this._arrayTargets = [];
            this._elementPool = [];
        }
        _searchElementByTarget(arr, target) {
            for (var k = 0; k < arr.length; k++) {
                if (target === arr[k].target)
                    return arr[k];
            }
            return null;
        }
        _getElement(target, paused) {
            var element = this._elementPool.pop();
            if (!element) {
                element = new HashElement();
            }
            element.target = target;
            element.paused = !!paused;
            return element;
        }
        _putElement(element) {
            element.actions.length = 0;
            element.actionIndex = 0;
            element.currentAction = null;
            element.paused = false;
            element.target = null;
            element.lock = false;
            this._elementPool.push(element);
        }
        addAction(action, target, paused) {
            if (!action || !target) {
                errorID(1000);
                return;
            }
            var gid = (target["$_GID"] || (target["$_GID"] = Laya.Utils.getGID()));
            var element = this._hashTargets[gid];
            if (!element) {
                element = this._getElement(target, paused);
                this._hashTargets[gid] = element;
                this._arrayTargets.push(element);
            }
            else if (!element.actions) {
                element.actions = [];
            }
            element.actions.push(action);
            action.startWithTarget(target);
        }
        removeAllActions() {
            var locTargets = this._arrayTargets;
            for (var i = 0; i < locTargets.length; i++) {
                var element = locTargets[i];
                if (element)
                    this._putElement(element);
            }
            this._arrayTargets.length = 0;
            this._hashTargets = Object.create(null);
        }
        removeAllActionsFromTarget(target, forceDelete) {
            if (target == null)
                return;
            var element = this._hashTargets[target["$_GID"]];
            if (element) {
                element.actions.length = 0;
                this._deleteHashElement(element);
            }
            if (target instanceof Laya.EventDispatcher) {
                target.offAll("NODE_DESTROYED");
            }
        }
        removeAction(action) {
            if (action == null)
                return;
            var target = action.getOriginalTarget();
            var element = this._hashTargets[target["$_GID"]];
            if (element) {
                for (var i = 0; i < element.actions.length; i++) {
                    if (element.actions[i] === action) {
                        element.actions.splice(i, 1);
                        if (element.actionIndex >= i)
                            element.actionIndex--;
                        break;
                    }
                }
            }
        }
        getNumberOfRunningActionsInTarget(target) {
            var element = this._hashTargets[target["$_GID"]];
            if (element)
                return (element.actions) ? element.actions.length : 0;
            return 0;
        }
        pauseTarget(target) {
            var element = this._hashTargets[target["$_GID"]];
            if (element)
                element.paused = true;
        }
        resumeTarget(target) {
            var element = this._hashTargets[target["$_GID"]];
            if (element)
                element.paused = false;
        }
        pauseAllRunningActions() {
            var idsWithActions = [];
            var locTargets = this._arrayTargets;
            for (var i = 0; i < locTargets.length; i++) {
                var element = locTargets[i];
                if (element && !element.paused) {
                    element.paused = true;
                    idsWithActions.push(element.target);
                }
            }
            return idsWithActions;
        }
        resumeTargets(targetsToResume) {
            if (!targetsToResume)
                return;
            for (var i = 0; i < targetsToResume.length; i++) {
                if (targetsToResume[i])
                    this.resumeTarget(targetsToResume[i]);
            }
        }
        pauseTargets(targetsToPause) {
            if (!targetsToPause)
                return;
            for (var i = 0; i < targetsToPause.length; i++) {
                if (targetsToPause[i])
                    this.pauseTarget(targetsToPause[i]);
            }
        }
        purgeSharedManager() {
            Laya.stage.timer.clearAll(this);
        }
        _removeActionAtIndex(index, element) {
            var action = element.actions[index];
            element.actions.splice(index, 1);
            if (element.actionIndex >= index)
                element.actionIndex--;
            if (element.actions.length === 0) {
                this._deleteHashElement(element);
            }
        }
        _deleteHashElement(element) {
            var ret = false;
            if (element && !element.lock) {
                if (this._hashTargets[element.target["$_GID"]]) {
                    delete this._hashTargets[element.target["$_GID"]];
                    var targets = this._arrayTargets;
                    for (var i = 0, l = targets.length; i < l; i++) {
                        if (targets[i] === element) {
                            targets.splice(i, 1);
                            break;
                        }
                    }
                    this._putElement(element);
                    ret = true;
                }
            }
            return ret;
        }
        update(dt) {
            var locTargets = this._arrayTargets;
            var locCurrTarget;
            for (var elt = 0; elt < locTargets.length; elt++) {
                this._currentTarget = locTargets[elt];
                locCurrTarget = this._currentTarget;
                if (!locCurrTarget.paused && locCurrTarget.actions) {
                    locCurrTarget.lock = true;
                    for (locCurrTarget.actionIndex = 0; locCurrTarget.actionIndex < locCurrTarget.actions.length; locCurrTarget.actionIndex++) {
                        locCurrTarget.currentAction = locCurrTarget.actions[locCurrTarget.actionIndex];
                        if (!locCurrTarget.currentAction)
                            continue;
                        locCurrTarget.currentAction.step(dt * (locCurrTarget.currentAction._speedMethod ? locCurrTarget.currentAction._speed : 1));
                        if (locCurrTarget.currentAction && locCurrTarget.currentAction.isDone()) {
                            locCurrTarget.currentAction.stop();
                            var action = locCurrTarget.currentAction;
                            locCurrTarget.currentAction = null;
                            this.removeAction(action);
                        }
                        locCurrTarget.currentAction = null;
                    }
                    locCurrTarget.lock = false;
                }
                if (locCurrTarget.actions.length === 0) {
                    this._deleteHashElement(locCurrTarget) && elt--;
                }
            }
        }
    }
    ;

    class TweenSystem {
        constructor() {
            this.actionMgr = new ActionManager();
        }
        static create() {
            if (!this.instance) {
                let sys = new TweenSystem();
                this.instance = sys;
                let timer = Laya.timer;
                timer.frameLoop(1, this, function TweenSystemLoop() {
                    sys.postUpdate(timer.delta / 1000);
                });
            }
        }
        get ActionManager() {
            return this.actionMgr;
        }
        postUpdate(dt) {
            this.actionMgr.update(dt);
        }
    }
    TweenSystem.ID = 'tween';

    class Action {
        constructor() {
            this.originalTarget = null;
            this.target = null;
            this.tag = Action.TAG_INVALID;
        }
        clone() {
            var action = new Action();
            action.originalTarget = null;
            action.target = null;
            action.tag = this.tag;
            return action;
        }
        isDone() {
            return true;
        }
        startWithTarget(target) {
            this.originalTarget = target;
            this.target = target;
        }
        stop() {
            this.target = null;
        }
        step(dt) {
            logID(1006);
        }
        update(dt) {
            logID(1007);
        }
        getTarget() {
            return this.target;
        }
        setTarget(target) {
            this.target = target;
        }
        getOriginalTarget() {
            return this.originalTarget;
        }
        setOriginalTarget(originalTarget) {
            this.originalTarget = originalTarget;
        }
        getTag() {
            return this.tag;
        }
        setTag(tag) {
            this.tag = tag;
        }
        reverse() {
            logID(1008);
            return null;
        }
        retain() { }
        release() { }
    }
    Action.TAG_INVALID = -1;
    class FiniteTimeAction extends Action {
        constructor() {
            super(...arguments);
            this._duration = 0;
            this._timesForRepeat = 1;
        }
        getDuration() {
            return this._duration * (this._timesForRepeat || 1);
        }
        setDuration(duration) {
            this._duration = duration;
        }
        clone() {
            return new FiniteTimeAction();
        }
    }
    class Speed extends Action {
        constructor(action, speed = 1) {
            super();
            this._speed = 0;
            this._innerAction = null;
            action && this.initWithAction(action, speed);
        }
        getSpeed() {
            return this._speed;
        }
        setSpeed(speed) {
            this._speed = speed;
        }
        initWithAction(action, speed) {
            if (!action) {
                errorID(1021);
                return false;
            }
            this._innerAction = action;
            this._speed = speed;
            return true;
        }
        clone() {
            var action = new Speed();
            action.initWithAction(this._innerAction.clone(), this._speed);
            return action;
        }
        startWithTarget(target) {
            Action.prototype.startWithTarget.call(this, target);
            this._innerAction.startWithTarget(target);
        }
        stop() {
            this._innerAction.stop();
            Action.prototype.stop.call(this);
        }
        step(dt) {
            this._innerAction.step(dt * this._speed);
        }
        isDone() {
            return this._innerAction.isDone();
        }
        reverse() {
            return new Speed(this._innerAction.reverse(), this._speed);
        }
        setInnerAction(action) {
            if (this._innerAction !== action) {
                this._innerAction = action;
            }
        }
        getInnerAction() {
            return this._innerAction;
        }
    }

    class ActionInstant extends FiniteTimeAction {
        isDone() {
            return true;
        }
        step(dt) {
            this.update(1);
        }
        update(dt) {
        }
        reverse() {
            return this.clone();
        }
        clone() {
            return new ActionInstant();
        }
    }
    class Show extends ActionInstant {
        update(dt) {
            this.target.visible = true;
        }
        reverse() {
            return new Hide();
        }
        clone() {
            return new Show();
        }
    }
    function show() {
        return new Show();
    }
    ;
    class Hide extends ActionInstant {
        update(dt) {
            this.target.visible = false;
        }
        reverse() {
            return new Show();
        }
        clone() {
            return new Hide();
        }
    }
    function hide() {
        return new Hide();
    }
    ;
    class RemoveSelf extends ActionInstant {
        constructor(isNeedCleanUp) {
            super();
            this._isNeedCleanUp = true;
            isNeedCleanUp !== undefined && this.init(isNeedCleanUp);
        }
        update(dt) {
            this.target.removeSelf();
            if (this._isNeedCleanUp) {
                this.target.destroy();
            }
        }
        init(isNeedCleanUp) {
            this._isNeedCleanUp = isNeedCleanUp;
            return true;
        }
        reverse() {
            return new RemoveSelf(this._isNeedCleanUp);
        }
        clone() {
            return new RemoveSelf(this._isNeedCleanUp);
        }
    }
    function removeSelf(isNeedCleanUp) {
        return new RemoveSelf(isNeedCleanUp);
    }
    ;
    class CallFunc extends ActionInstant {
        constructor(selector, selectorTarget, data) {
            super();
            this._selectorTarget = null;
            this._function = null;
            this._data = null;
            this.initWithFunction(selector, selectorTarget, data);
        }
        initWithFunction(selector, selectorTarget, data) {
            if (selector) {
                this._function = selector;
            }
            if (selectorTarget) {
                this._selectorTarget = selectorTarget;
            }
            if (data !== undefined) {
                this._data = data;
            }
            return true;
        }
        execute() {
            if (this._function) {
                this._function.call(this._selectorTarget, this.target, this._data);
            }
        }
        update(dt) {
            this.execute();
        }
        getTargetCallback() {
            return this._selectorTarget;
        }
        setTargetCallback(sel) {
            if (sel !== this._selectorTarget) {
                if (this._selectorTarget)
                    this._selectorTarget = null;
                this._selectorTarget = sel;
            }
        }
        clone() {
            var action = new CallFunc();
            action.initWithFunction(this._function, this._selectorTarget, this._data);
            return action;
        }
    }
    function callFunc(selector, selectorTarget, data) {
        return new CallFunc(selector, selectorTarget, data);
    }
    ;

    class ActionInterval extends FiniteTimeAction {
        constructor(d) {
            super();
            this.MAX_VALUE = 2;
            this._elapsed = 0;
            this._firstTick = false;
            this._easeList = [];
            this._speed = 1;
            this._repeatForever = false;
            this._repeatMethod = false;
            this._speedMethod = false;
            if (d !== undefined && !isNaN(d)) {
                this.initWithDuration(d);
            }
        }
        getElapsed() {
            return this._elapsed;
        }
        initWithDuration(d) {
            this._duration = (d === 0) ? 0.0000001192092896 : d;
            this._elapsed = 0;
            this._firstTick = true;
            return true;
        }
        isDone() {
            return (this._elapsed >= this._duration);
        }
        _cloneDecoration(action) {
            action._repeatForever = this._repeatForever;
            action._speed = this._speed;
            action._timesForRepeat = this._timesForRepeat;
            action._easeList = this._easeList;
            action._speedMethod = this._speedMethod;
            action._repeatMethod = this._repeatMethod;
        }
        _reverseEaseList(action) {
            if (this._easeList) {
                action._easeList = [];
                for (var i = 0; i < this._easeList.length; i++) {
                    action._easeList.push(this._easeList[i]);
                }
            }
        }
        clone() {
            var action = new ActionInterval(this._duration);
            this._cloneDecoration(action);
            return action;
        }
        easing(...easeObj) {
            if (this._easeList)
                this._easeList.length = 0;
            else
                this._easeList = [];
            for (var i = 0; i < easeObj.length; i++)
                this._easeList.push(easeObj[i]);
            return this;
        }
        _computeEaseTime(dt) {
            var locList = this._easeList;
            if ((!locList) || (locList.length === 0))
                return dt;
            for (var i = 0, n = locList.length; i < n; i++)
                dt = locList[i](dt);
            return dt;
        }
        step(dt) {
            if (this._firstTick) {
                this._firstTick = false;
                this._elapsed = 0;
            }
            else
                this._elapsed += dt;
            var t = this._elapsed / (this._duration > 0.0000001192092896 ? this._duration : 0.0000001192092896);
            t = (1 > t ? t : 1);
            this.update(t > 0 ? t : 0);
            if (this._repeatMethod && this._timesForRepeat > 1 && this.isDone()) {
                if (!this._repeatForever) {
                    this._timesForRepeat--;
                }
                this.startWithTarget(this.target);
                this.step(this._elapsed - this._duration);
            }
        }
        startWithTarget(target) {
            Action.prototype.startWithTarget.call(this, target);
            this._elapsed = 0;
            this._firstTick = true;
        }
        reverse() {
            logID(1010);
            return this;
        }
        setAmplitudeRate(amp) {
            logID(1011);
        }
        getAmplitudeRate() {
            logID(1012);
            return 0;
        }
        speed(speed) {
            if (speed <= 0) {
                logID(1013);
                return this;
            }
            this._speedMethod = true;
            this._speed *= speed;
            return this;
        }
        getSpeed() {
            return this._speed;
        }
        setSpeed(speed) {
            this._speed = speed;
            return this;
        }
        repeat(times) {
            times = Math.round(times);
            if (isNaN(times) || times < 1) {
                logID(1014);
                return this;
            }
            this._repeatMethod = true;
            this._timesForRepeat *= times;
            return this;
        }
        repeatForever() {
            this._repeatMethod = true;
            this._timesForRepeat = this.MAX_VALUE;
            this._repeatForever = true;
            return this;
        }
    }
    function actionInterval(d) {
        return new ActionInterval(d);
    }
    class Sequence extends ActionInterval {
        constructor(tempArray) {
            super();
            this._actions = [];
            this._split = 0;
            this._last = 0;
            this._reversed = false;
            var paramArray = (tempArray instanceof Array) ? tempArray : arguments;
            if (paramArray.length === 1) {
                errorID(1019);
                return;
            }
            var last = paramArray.length - 1;
            if ((last >= 0) && (paramArray[last] == null))
                logID(1015);
            if (last >= 0) {
                var prev = paramArray[0], action1;
                for (var i = 1; i < last; i++) {
                    if (paramArray[i]) {
                        action1 = prev;
                        prev = Sequence._actionOneTwo(action1, paramArray[i]);
                    }
                }
                this.initWithTwoActions(prev, paramArray[last]);
            }
        }
        initWithTwoActions(actionOne, actionTwo) {
            if (!actionOne || !actionTwo) {
                errorID(1025);
                return false;
            }
            var durationOne = actionOne._duration, durationTwo = actionTwo._duration;
            durationOne *= actionOne._repeatMethod ? actionOne._timesForRepeat : 1;
            durationTwo *= actionTwo._repeatMethod ? actionTwo._timesForRepeat : 1;
            var d = durationOne + durationTwo;
            this.initWithDuration(d);
            this._actions[0] = actionOne;
            this._actions[1] = actionTwo;
            return true;
        }
        clone() {
            var action = new Sequence();
            this._cloneDecoration(action);
            action.initWithTwoActions(this._actions[0].clone(), this._actions[1].clone());
            return action;
        }
        startWithTarget(target) {
            ActionInterval.prototype.startWithTarget.call(this, target);
            this._split = this._actions[0]._duration / this._duration;
            this._split *= this._actions[0]._repeatMethod ? this._actions[0]._timesForRepeat : 1;
            this._last = -1;
        }
        stop() {
            if (this._last !== -1)
                this._actions[this._last].stop();
            Action.prototype.stop.call(this);
        }
        update(dt) {
            if (!this.target || this.target.destroyed) {
                this.stop();
                return;
            }
            var new_t, found = 0;
            var locSplit = this._split;
            var locActions = this._actions;
            var locLast = this._last;
            var actionFound;
            dt = this._computeEaseTime(dt);
            if (dt < locSplit) {
                new_t = (locSplit !== 0) ? dt / locSplit : 1;
                if (found === 0 && locLast === 1 && this._reversed) {
                    locActions[1].update(0);
                    locActions[1].stop();
                }
            }
            else {
                found = 1;
                new_t = (locSplit === 1) ? 1 : (dt - locSplit) / (1 - locSplit);
                if (locLast === -1) {
                    locActions[0].startWithTarget(this.target);
                    locActions[0].update(1);
                    locActions[0].stop();
                }
                if (locLast === 0) {
                    locActions[0].update(1);
                    locActions[0].stop();
                }
            }
            actionFound = locActions[found];
            if (locLast === found && actionFound.isDone())
                return;
            if (locLast !== found)
                actionFound.startWithTarget(this.target);
            new_t = new_t * actionFound._timesForRepeat;
            actionFound.update(new_t > 1 ? new_t % 1 : new_t);
            this._last = found;
        }
        reverse() {
            var action = Sequence._actionOneTwo(this._actions[1].reverse(), this._actions[0].reverse());
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            action._reversed = true;
            return action;
        }
    }
    Sequence._actionOneTwo = function (actionOne, actionTwo) {
        var sequence = new Sequence();
        sequence.initWithTwoActions(actionOne, actionTwo);
        return sequence;
    };
    function sequence(tempArray) {
        var paramArray = (tempArray instanceof Array) ? tempArray : arguments;
        if (paramArray.length === 1) {
            errorID(1019);
            return null;
        }
        var last = paramArray.length - 1;
        if ((last >= 0) && (paramArray[last] == null))
            logID(1015);
        var result = null;
        if (last >= 0) {
            result = paramArray[0];
            for (var i = 1; i <= last; i++) {
                if (paramArray[i]) {
                    result = Sequence._actionOneTwo(result, paramArray[i]);
                }
            }
        }
        return result;
    }
    ;
    class Repeat extends ActionInterval {
        constructor(action, times) {
            super();
            this._times = 0;
            this._total = 0;
            this._nextDt = 0;
            this._actionInstant = false;
            this._innerAction = null;
            times !== undefined && this.initWithAction(action, times);
        }
        initWithAction(action, times) {
            var duration = action._duration * times;
            if (this.initWithDuration(duration)) {
                this._times = times;
                this._innerAction = action;
                if (action instanceof ActionInstant) {
                    this._actionInstant = true;
                    this._times -= 1;
                }
                this._total = 0;
                return true;
            }
            return false;
        }
        clone() {
            var action = new Repeat();
            this._cloneDecoration(action);
            action.initWithAction(this._innerAction.clone(), this._times);
            return action;
        }
        startWithTarget(target) {
            this._total = 0;
            this._nextDt = this._innerAction._duration / this._duration;
            ActionInterval.prototype.startWithTarget.call(this, target);
            this._innerAction.startWithTarget(target);
        }
        stop() {
            this._innerAction.stop();
            Action.prototype.stop.call(this);
        }
        update(dt) {
            dt = this._computeEaseTime(dt);
            var locInnerAction = this._innerAction;
            var locDuration = this._duration;
            var locTimes = this._times;
            var locNextDt = this._nextDt;
            if (dt >= locNextDt) {
                while (dt > locNextDt && this._total < locTimes) {
                    locInnerAction.update(1);
                    this._total++;
                    locInnerAction.stop();
                    locInnerAction.startWithTarget(this.target);
                    locNextDt += locInnerAction._duration / locDuration;
                    this._nextDt = locNextDt > 1 ? 1 : locNextDt;
                }
                if (dt >= 1.0 && this._total < locTimes) {
                    locInnerAction.update(1);
                    this._total++;
                }
                if (!this._actionInstant) {
                    if (this._total === locTimes) {
                        locInnerAction.stop();
                    }
                    else {
                        locInnerAction.update(dt - (locNextDt - locInnerAction._duration / locDuration));
                    }
                }
            }
            else {
                locInnerAction.update((dt * locTimes) % 1.0);
            }
        }
        isDone() {
            return this._total === this._times;
        }
        reverse() {
            var action = new Repeat(this._innerAction.reverse(), this._times);
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
        setInnerAction(action) {
            if (this._innerAction !== action) {
                this._innerAction = action;
            }
        }
        getInnerAction() {
            return this._innerAction;
        }
    }
    function repeat(action, times) {
        return new Repeat(action, times);
    }
    class RepeatForever extends ActionInterval {
        constructor(action) {
            super();
            this._innerAction = null;
            action && this.initWithAction(action);
        }
        stop() {
            this.bStop = true;
            super.stop();
        }
        initWithAction(action) {
            if (!action) {
                errorID(1026);
                return false;
            }
            this._innerAction = action;
            return true;
        }
        clone() {
            var action = new RepeatForever();
            this._cloneDecoration(action);
            action.initWithAction(this._innerAction.clone());
            return action;
        }
        startWithTarget(target) {
            this.bStop = false;
            ActionInterval.prototype.startWithTarget.call(this, target);
            this._innerAction.startWithTarget(target);
        }
        step(dt) {
            const target = this.target;
            if (!target || target.destroyed) {
                this.stop();
                return;
            }
            var locInnerAction = this._innerAction;
            locInnerAction.step(dt);
            if (locInnerAction.isDone()) {
                locInnerAction.startWithTarget(this.target);
                locInnerAction.step(locInnerAction.getElapsed() - locInnerAction._duration);
            }
        }
        isDone() {
            return this.bStop;
        }
        reverse() {
            var action = new RepeatForever(this._innerAction.reverse());
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
        setInnerAction(action) {
            if (this._innerAction !== action) {
                this._innerAction = action;
            }
        }
        getInnerAction() {
            return this._innerAction;
        }
    }
    function repeatForever(action) {
        return new RepeatForever(action);
    }
    class Spawn extends ActionInterval {
        constructor(tempArray) {
            super();
            this._one = null;
            this._two = null;
            var paramArray = (tempArray instanceof Array) ? tempArray : arguments;
            if (paramArray.length === 1) {
                errorID(1020);
                return;
            }
            var last = paramArray.length - 1;
            if ((last >= 0) && (paramArray[last] == null))
                logID(1015);
            if (last >= 0) {
                var prev = paramArray[0], action1;
                for (var i = 1; i < last; i++) {
                    if (paramArray[i]) {
                        action1 = prev;
                        prev = Spawn._actionOneTwo(action1, paramArray[i]);
                    }
                }
                this.initWithTwoActions(prev, paramArray[last]);
            }
        }
        initWithTwoActions(action1, action2) {
            if (!action1 || !action2) {
                errorID(1027);
                return false;
            }
            var ret = false;
            var d1 = action1._duration;
            var d2 = action2._duration;
            if (this.initWithDuration(Math.max(d1, d2))) {
                this._one = action1;
                this._two = action2;
                if (d1 > d2) {
                    this._two = Sequence._actionOneTwo(action2, delayTime(d1 - d2));
                }
                else if (d1 < d2) {
                    this._one = Sequence._actionOneTwo(action1, delayTime(d2 - d1));
                }
                ret = true;
            }
            return ret;
        }
        clone() {
            var action = new Spawn();
            this._cloneDecoration(action);
            action.initWithTwoActions(this._one.clone(), this._two.clone());
            return action;
        }
        startWithTarget(target) {
            ActionInterval.prototype.startWithTarget.call(this, target);
            this._one.startWithTarget(target);
            this._two.startWithTarget(target);
        }
        stop() {
            this._one.stop();
            this._two.stop();
            Action.prototype.stop.call(this);
        }
        update(dt) {
            dt = this._computeEaseTime(dt);
            if (this._one)
                this._one.update(dt);
            if (this._two)
                this._two.update(dt);
        }
        reverse() {
            var action = Spawn._actionOneTwo(this._one.reverse(), this._two.reverse());
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
    }
    Spawn._actionOneTwo = function (action1, action2) {
        var pSpawn = new Spawn();
        pSpawn.initWithTwoActions(action1, action2);
        return pSpawn;
    };
    function spawn(tempArray) {
        var paramArray = (tempArray instanceof Array) ? tempArray : arguments;
        if (paramArray.length === 1) {
            errorID(1020);
            return null;
        }
        if ((paramArray.length > 0) && (paramArray[paramArray.length - 1] == null))
            logID(1015);
        var prev = paramArray[0];
        for (var i = 1; i < paramArray.length; i++) {
            if (paramArray[i] != null)
                prev = Spawn._actionOneTwo(prev, paramArray[i]);
        }
        return prev;
    }
    class DelayTime extends ActionInterval {
        update(dt) { }
        reverse() {
            var action = new DelayTime(this._duration);
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
        clone() {
            var action = new DelayTime();
            this._cloneDecoration(action);
            action.initWithDuration(this._duration);
            return action;
        }
    }
    function delayTime(d) {
        return new DelayTime(d);
    }
    ;
    class ReverseTime extends ActionInterval {
        constructor(action) {
            super();
            this._other = null;
            action && this.initWithAction(action);
        }
        initWithAction(action) {
            if (!action) {
                errorID(1028);
                return false;
            }
            if (action === this._other) {
                errorID(1029);
                return false;
            }
            if (ActionInterval.prototype.initWithDuration.call(this, action._duration)) {
                this._other = action;
                return true;
            }
            return false;
        }
        clone() {
            var action = new ReverseTime();
            this._cloneDecoration(action);
            action.initWithAction(this._other.clone());
            return action;
        }
        startWithTarget(target) {
            ActionInterval.prototype.startWithTarget.call(this, target);
            this._other.startWithTarget(target);
        }
        update(dt) {
            dt = this._computeEaseTime(dt);
            if (this._other)
                this._other.update(1 - dt);
        }
        reverse() {
            return this._other.clone();
        }
        stop() {
            this._other.stop();
            Action.prototype.stop.call(this);
        }
    }
    function reverseTime(action) {
        return new ReverseTime(action);
    }

    var Easing;
    (function (Easing) {
        function constant() {
            return 0;
        }
        Easing.constant = constant;
        function linear(k) {
            return k;
        }
        Easing.linear = linear;
        function quadIn(k) {
            return k * k;
        }
        Easing.quadIn = quadIn;
        function quadOut(k) {
            return k * (2 - k);
        }
        Easing.quadOut = quadOut;
        function quadInOut(k) {
            k *= 2;
            if (k < 1) {
                return 0.5 * k * k;
            }
            return -0.5 * (--k * (k - 2) - 1);
        }
        Easing.quadInOut = quadInOut;
        function cubicIn(k) {
            return k * k * k;
        }
        Easing.cubicIn = cubicIn;
        function cubicOut(k) {
            return --k * k * k + 1;
        }
        Easing.cubicOut = cubicOut;
        function cubicInOut(k) {
            k *= 2;
            if (k < 1) {
                return 0.5 * k * k * k;
            }
            return 0.5 * ((k -= 2) * k * k + 2);
        }
        Easing.cubicInOut = cubicInOut;
        function quartIn(k) {
            return k * k * k * k;
        }
        Easing.quartIn = quartIn;
        function quartOut(k) {
            return 1 - (--k * k * k * k);
        }
        Easing.quartOut = quartOut;
        function quartInOut(k) {
            k *= 2;
            if (k < 1) {
                return 0.5 * k * k * k * k;
            }
            return -0.5 * ((k -= 2) * k * k * k - 2);
        }
        Easing.quartInOut = quartInOut;
        function quintIn(k) {
            return k * k * k * k * k;
        }
        Easing.quintIn = quintIn;
        function quintOut(k) {
            return --k * k * k * k * k + 1;
        }
        Easing.quintOut = quintOut;
        function quintInOut(k) {
            k *= 2;
            if (k < 1) {
                return 0.5 * k * k * k * k * k;
            }
            return 0.5 * ((k -= 2) * k * k * k * k + 2);
        }
        Easing.quintInOut = quintInOut;
        function sineIn(k) {
            return 1 - Math.cos(k * Math.PI / 2);
        }
        Easing.sineIn = sineIn;
        function sineOut(k) {
            return Math.sin(k * Math.PI / 2);
        }
        Easing.sineOut = sineOut;
        function sineInOut(k) {
            return 0.5 * (1 - Math.cos(Math.PI * k));
        }
        Easing.sineInOut = sineInOut;
        function expoIn(k) {
            return k === 0 ? 0 : Math.pow(1024, k - 1);
        }
        Easing.expoIn = expoIn;
        function expoOut(k) {
            return k === 1 ? 1 : 1 - Math.pow(2, -10 * k);
        }
        Easing.expoOut = expoOut;
        function expoInOut(k) {
            if (k === 0) {
                return 0;
            }
            if (k === 1) {
                return 1;
            }
            k *= 2;
            if (k < 1) {
                return 0.5 * Math.pow(1024, k - 1);
            }
            return 0.5 * (-Math.pow(2, -10 * (k - 1)) + 2);
        }
        Easing.expoInOut = expoInOut;
        function circIn(k) {
            return 1 - Math.sqrt(1 - k * k);
        }
        Easing.circIn = circIn;
        function circOut(k) {
            return Math.sqrt(1 - (--k * k));
        }
        Easing.circOut = circOut;
        function circInOut(k) {
            k *= 2;
            if (k < 1) {
                return -0.5 * (Math.sqrt(1 - k * k) - 1);
            }
            return 0.5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
        }
        Easing.circInOut = circInOut;
        function elasticIn(k) {
            let s;
            let a = 0.1;
            const p = 0.4;
            if (k === 0) {
                return 0;
            }
            if (k === 1) {
                return 1;
            }
            if (!a || a < 1) {
                a = 1;
                s = p / 4;
            }
            else {
                s = p * Math.asin(1 / a) / (2 * Math.PI);
            }
            return -(a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
        }
        Easing.elasticIn = elasticIn;
        function elasticOut(k) {
            let s;
            let a = 0.1;
            const p = 0.4;
            if (k === 0) {
                return 0;
            }
            if (k === 1) {
                return 1;
            }
            if (!a || a < 1) {
                a = 1;
                s = p / 4;
            }
            else {
                s = p * Math.asin(1 / a) / (2 * Math.PI);
            }
            return (a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1);
        }
        Easing.elasticOut = elasticOut;
        function elasticInOut(k) {
            let s;
            let a = 0.1;
            const p = 0.4;
            if (k === 0) {
                return 0;
            }
            if (k === 1) {
                return 1;
            }
            if (!a || a < 1) {
                a = 1;
                s = p / 4;
            }
            else {
                s = p * Math.asin(1 / a) / (2 * Math.PI);
            }
            k *= 2;
            if (k < 1) {
                return -0.5 *
                    (a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
            }
            return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * 0.5 + 1;
        }
        Easing.elasticInOut = elasticInOut;
        function backIn(k) {
            const s = 1.70158;
            return k * k * ((s + 1) * k - s);
        }
        Easing.backIn = backIn;
        function backOut(k) {
            const s = 1.70158;
            return --k * k * ((s + 1) * k + s) + 1;
        }
        Easing.backOut = backOut;
        function backInOut(k) {
            const s = 1.70158 * 1.525;
            k *= 2;
            if (k < 1) {
                return 0.5 * (k * k * ((s + 1) * k - s));
            }
            return 0.5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
        }
        Easing.backInOut = backInOut;
        function bounceIn(k) {
            return 1 - bounceOut(1 - k);
        }
        Easing.bounceIn = bounceIn;
        function bounceOut(k) {
            if (k < (1 / 2.75)) {
                return 7.5625 * k * k;
            }
            else if (k < (2 / 2.75)) {
                return 7.5625 * (k -= (1.5 / 2.75)) * k + 0.75;
            }
            else if (k < (2.5 / 2.75)) {
                return 7.5625 * (k -= (2.25 / 2.75)) * k + 0.9375;
            }
            else {
                return 7.5625 * (k -= (2.625 / 2.75)) * k + 0.984375;
            }
        }
        Easing.bounceOut = bounceOut;
        function bounceInOut(k) {
            if (k < 0.5) {
                return bounceIn(k * 2) * 0.5;
            }
            return bounceOut(k * 2 - 1) * 0.5 + 0.5;
        }
        Easing.bounceInOut = bounceInOut;
        function smooth(k) {
            if (k <= 0) {
                return 0;
            }
            if (k >= 1) {
                return 1;
            }
            return k * k * (3 - 2 * k);
        }
        Easing.smooth = smooth;
        function fade(k) {
            if (k <= 0) {
                return 0;
            }
            if (k >= 1) {
                return 1;
            }
            return k * k * k * (k * (k * 6 - 15) + 10);
        }
        Easing.fade = fade;
        Easing.quadOutIn = _makeOutIn(quadIn, quadOut);
        Easing.cubicOutIn = _makeOutIn(cubicIn, cubicOut);
        Easing.quartOutIn = _makeOutIn(quartIn, quartOut);
        Easing.quintOutIn = _makeOutIn(quintIn, quintOut);
        Easing.sineOutIn = _makeOutIn(sineIn, sineOut);
        Easing.expoOutIn = _makeOutIn(expoIn, expoOut);
        Easing.circOutIn = _makeOutIn(circIn, circOut);
        Easing.elasticOutIn = _makeOutIn(elasticIn, elasticOut);
        Easing.backOutIn = _makeOutIn(backIn, backOut);
        Easing.bounceOutIn = _makeOutIn(bounceIn, bounceOut);
        function _makeOutIn(fnIn, fnOut) {
            return (k) => {
                if (k < 0.5) {
                    return fnOut(k * 2) / 2;
                }
                return fnIn(2 * k - 1) / 2 + 0.5;
            };
        }
    })(Easing || (Easing = {}));

    function TweenEasinAdapter(easingName) {
        let initialChar = easingName.charAt(0);
        if (/[A-Z]/.test(initialChar)) {
            easingName = easingName.replace(initialChar, initialChar.toLowerCase());
            const arr = easingName.split('-');
            if (arr.length == 2) {
                const str0 = arr[0];
                if (str0 == 'linear') {
                    easingName = 'linear';
                }
                else {
                    const str1 = arr[1];
                    switch (str0) {
                        case 'quadratic':
                            easingName = 'quad' + str1;
                            break;
                        case 'quartic':
                            easingName = 'quart' + str1;
                            break;
                        case 'quintic':
                            easingName = 'quint' + str1;
                            break;
                        case 'sinusoidal':
                            easingName = 'sine' + str1;
                            break;
                        case 'exponential':
                            easingName = 'expo' + str1;
                            break;
                        case 'circular':
                            easingName = 'circ' + str1;
                            break;
                        default:
                            easingName = str0 + str1;
                            break;
                    }
                }
            }
        }
        return easingName;
    }
    function TweenOptionChecker(opts) {
        if (true)
            return;
        const header = ' [Tween:] ';
        const message = ' option is not support in v' + -1;
        if (opts['delay']) {
            console.warn(header + 'delay' + message);
        }
        if (opts['repeat']) {
            console.warn(header + 'repeat' + message);
        }
        if (opts['repeatDelay']) {
            console.warn(header + 'repeatDelay' + message);
        }
        if (opts['interpolation']) {
            console.warn(header + 'interpolation' + message);
        }
        if (opts['onStop']) {
            console.warn(header + 'onStop' + message);
        }
    }
    class TweenAction extends ActionInterval {
        constructor(duration, props, opts) {
            super();
            if (opts == null) {
                opts = TweenAction.EMPTY_OPTION;
            }
            else {
                TweenOptionChecker(opts);
                if (opts.easing && typeof opts.easing === 'string') {
                    opts.easing = TweenEasinAdapter(opts.easing);
                }
                if (!opts.progress) {
                    opts.progress = this.progress;
                }
                if (opts.easing && typeof opts.easing === 'string') {
                    let easingName = opts.easing;
                    opts.easing = Easing[easingName];
                    if (!opts.easing) {
                        warnID(1031, easingName);
                    }
                }
            }
            this._opts = opts;
            this._props = Object.create(null);
            for (let name in props) {
                let value = props[name];
                let easing, progress;
                if (value.value !== undefined && (value.easing || value.progress)) {
                    if (typeof value.easing === 'string') {
                        easing = easing[value.easing];
                        !easing && warnID(1031, value.easing);
                    }
                    else {
                        easing = value.easing;
                    }
                    progress = value.progress;
                    value = value.value;
                }
                let prop = Object.create(null);
                prop.value = value;
                prop.easing = easing;
                prop.progress = progress;
                this._props[name] = prop;
            }
            this._originProps = props;
            this.initWithDuration(duration);
        }
        clone() {
            var action = new TweenAction(this._duration, this._originProps, this._opts);
            this._cloneDecoration(action);
            return action;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            const relative = !!this._opts.relative;
            const props = this._props;
            for (var property in props) {
                const _t = target[property];
                if (_t === undefined) {
                    continue;
                }
                const prop = props[property];
                const value = prop.value;
                if (typeof _t === "number") {
                    prop.start = _t;
                    prop.current = _t;
                    prop.end = relative ? _t + value : value;
                }
                else if (typeof _t === "object") {
                    if (prop.start == null) {
                        prop.start = {};
                        prop.current = {};
                        prop.end = {};
                    }
                    for (var k in value) {
                        prop.start[k] = _t[k];
                        prop.current[k] = _t[k];
                        prop.end[k] = relative ? _t[k] + value[k] : value[k];
                    }
                }
            }
            if (this._opts.onStart) {
                this._opts.onStart(this.target);
            }
        }
        update(t) {
            const target = this.target;
            if (!target || target.destroyed) {
                this.stop();
                return;
            }
            const props = this._props;
            const opts = this._opts;
            let easingTime = t;
            if (opts.easing)
                easingTime = opts.easing(t);
            let progress = opts.progress;
            for (const name in props) {
                let prop = props[name];
                let time = prop.easing ? prop.easing(t) : easingTime;
                let interpolation = prop.progress ? prop.progress : progress;
                const start = prop.start;
                const end = prop.end;
                if (typeof start === 'number') {
                    prop.current = interpolation(start, end, prop.current, time);
                }
                else if (typeof start === 'object') {
                    for (const k in start) {
                        prop.current[k] = interpolation(start[k], end[k], prop.current[k], time);
                    }
                }
                target[name] = prop.current;
            }
            if (opts.onUpdate) {
                opts.onUpdate(this.target, t);
            }
            if (t == 1 && opts.onComplete) {
                opts.onComplete(this.target);
            }
        }
        progress(start, end, current, t) {
            return current = start + (end - start) * t;
        }
    }
    TweenAction.EMPTY_OPTION = Object.create(null);

    class SetAction extends ActionInstant {
        constructor(props) {
            super();
            this._props = {};
            props !== undefined && this.init(props);
        }
        init(props) {
            for (let name in props) {
                this._props[name] = props[name];
            }
            return true;
        }
        update() {
            let props = this._props;
            let target = this.target;
            for (let name in props) {
                target[name] = props[name];
            }
        }
        clone() {
            var action = new SetAction();
            action.init(this._props);
            return action;
        }
    }

    let _default_progress = function (start, end, current, t) {
        return current = start + (end - start) * t;
    };
    let DEFAULT_OPT1 = { easing: Easing.linear, progress: _default_progress };
    let DEFAULT_OPT2 = { easing: Easing.linear, progress: _default_progress };
    class Tween {
        constructor(target) {
            this._actions = [];
            this._finalAction = null;
            this._target = null;
            this._target = target === undefined ? null : target;
            if (this._target && this._target instanceof Laya.EventDispatcher) {
                this._target.on("NODE_DESTROYED", this, this._destroy);
            }
        }
        then(other) {
            if (other instanceof Action) {
                this._actions.push(other);
            }
            else {
                this._actions.push(other._union());
            }
            return this;
        }
        target(target) {
            if (this._target && this._target instanceof Laya.EventDispatcher) {
                this._target.off("NODE_DESTROYED", this, this._destroy);
            }
            this._target = target;
            if (this._target && this._target instanceof Laya.EventDispatcher) {
                this._target.on("NODE_DESTROYED", this, this._destroy);
            }
            return this;
        }
        start() {
            if (!this._target) {
                console.warn('Please set target to tween first');
                return this;
            }
            if (this._finalAction) {
                TweenSystem.instance.ActionManager.removeAction(this._finalAction);
            }
            this._finalAction = this._union();
            TweenSystem.instance.ActionManager.addAction(this._finalAction, this._target, false);
            return this;
        }
        stop() {
            if (this._finalAction) {
                TweenSystem.instance.ActionManager.removeAction(this._finalAction);
            }
            return this;
        }
        clone(target) {
            let action = this._union();
            return new Tween(target).then(action.clone());
        }
        union() {
            let action = this._union();
            this._actions.length = 0;
            this._actions.push(action);
            return this;
        }
        to(duration, props, opts) {
            opts = opts || DEFAULT_OPT1;
            opts.relative = false;
            const action = new TweenAction(duration, props, opts);
            this._actions.push(action);
            return this;
        }
        by(duration, props, opts) {
            opts = opts || DEFAULT_OPT2;
            opts.relative = true;
            const action = new TweenAction(duration, props, opts);
            this._actions.push(action);
            return this;
        }
        set(props) {
            const action = new SetAction(props);
            this._actions.push(action);
            return this;
        }
        delay(duration) {
            const action = delayTime(duration);
            this._actions.push(action);
            return this;
        }
        call(callback) {
            const action = callFunc(callback);
            this._actions.push(action);
            return this;
        }
        sequence(...args) {
            const action = Tween._wrappedSequence(...args);
            this._actions.push(action);
            return this;
        }
        parallel(...args) {
            const action = Tween._wrappedParallel(...args);
            this._actions.push(action);
            return this;
        }
        repeat(repeatTimes, embedTween) {
            if (repeatTimes == Infinity) {
                return this.repeatForever(embedTween);
            }
            const actions = this._actions;
            let action;
            if (embedTween) {
                action = embedTween._union();
            }
            else {
                action = actions.pop();
            }
            actions.push(repeat(action, repeatTimes));
            return this;
        }
        repeatForever(embedTween) {
            const actions = this._actions;
            let action;
            if (embedTween) {
                action = embedTween._union();
            }
            else {
                action = actions.pop();
            }
            actions.push(repeatForever(action));
            return this;
        }
        reverseTime(embedTween) {
            const actions = this._actions;
            let action;
            if (embedTween instanceof Tween) {
                action = embedTween._union();
            }
            else {
                action = actions.pop();
            }
            actions.push(reverseTime(action));
            return this;
        }
        hide() {
            let action = hide();
            this._actions.push(action);
            return this;
        }
        show() {
            let action = show();
            this._actions.push(action);
            return this;
        }
        removeSelf(destroy = false) {
            let action = removeSelf(destroy);
            this._actions.push(action);
            return this;
        }
        _union() {
            let actions = this._actions;
            let action;
            if (actions.length === 1) {
                action = actions[0];
            }
            else {
                action = sequence(actions);
            }
            return action;
        }
        _destroy() {
            this.stop();
        }
        static _wrappedSequence(...args) {
            const tmp_args = Tween._tmp_args;
            tmp_args.length = 0;
            for (let l = args.length, i = 0; i < l; i++) {
                let arg = tmp_args[i] = args[i];
                if (arg instanceof Tween) {
                    tmp_args[i] = arg._union();
                }
            }
            return sequence.apply(sequence, tmp_args);
        }
        static _wrappedParallel(...args) {
            const tmp_args = Tween._tmp_args;
            tmp_args.length = 0;
            for (let l = args.length, i = 0; i < l; i++) {
                let arg = tmp_args[i] = args[i];
                if (arg instanceof Tween) {
                    tmp_args[i] = arg._union();
                }
            }
            return spawn.apply(spawn, tmp_args);
        }
    }
    Tween._tmp_args = [];

    class Vec2 {
        constructor(x = 0, y = 0) {
            this.x = 0;
            this.y = 0;
            this.x = x;
            this.y = y;
        }
        static get zero() {
            return new Vec2(0, 0);
        }
        static get one() {
            return new Vec2(1, 1);
        }
        clone() {
            return new Vec2(this.x, this.y);
        }
        setTo(x, y) {
            this.setValue(x, y);
            return this;
        }
        setValue(x, y) {
            this.x = x;
            this.y = y;
        }
        set(newValue) {
            this.x = newValue.x;
            this.y = newValue.y;
            return this;
        }
        equals(other) {
            return other && this.x === other.x && this.y === other.y;
        }
        fuzzyEquals(other, variance) {
            if (this.x - variance <= other.x && other.x <= this.x + variance) {
                if (this.y - variance <= other.y && other.y <= this.y + variance)
                    return true;
            }
            return false;
        }
        lerp(to, ratio, out) {
            out = out || new Vec2();
            let x = this.x;
            let y = this.y;
            out.x = x + (to.x - x) * ratio;
            out.y = y + (to.y - y) * ratio;
            return out;
        }
        clampf(min_inclusive, max_inclusive) {
            this.x = Mathf.clamp(this.x, min_inclusive.x, max_inclusive.x);
            this.y = Mathf.clamp(this.y, min_inclusive.y, max_inclusive.y);
            return this;
        }
        addSelf(vector) {
            this.x += vector.x;
            this.y += vector.y;
            return this;
        }
        add(vector, out) {
            out = out || new Vec2();
            out.x = this.x + vector.x;
            out.y = this.y + vector.y;
            return out;
        }
        subSelf(vector) {
            this.x -= vector.x;
            this.y -= vector.y;
            return this;
        }
        sub(vector, out) {
            out = out || new Vec2();
            out.x = this.x - vector.x;
            out.y = this.y - vector.y;
            return out;
        }
        mulSelf(num) {
            this.x *= num;
            this.y *= num;
            return this;
        }
        mul(num, out) {
            out = out || new Vec2();
            out.x = this.x * num;
            out.y = this.y * num;
            return out;
        }
        scaleSelf(vector) {
            this.x *= vector.x;
            this.y *= vector.y;
            return this;
        }
        scale(vector, out) {
            out = out || new Vec2();
            out.x = this.x * vector.x;
            out.y = this.y * vector.y;
            return out;
        }
        divSelf(divisor) {
            this.x /= divisor;
            this.y /= divisor;
            return this;
        }
        div(divisor, out) {
            out = out || new Vec2();
            out.x = this.x / divisor;
            out.y = this.y / divisor;
            return out;
        }
        negSelf() {
            this.x = -this.x;
            this.y = -this.y;
            return this;
        }
        neg(out) {
            out = out || new Vec2();
            out.x = -this.x;
            out.y = -this.y;
            return out;
        }
        dot(vector) {
            return this.x * vector.x + this.y * vector.y;
        }
        cross(vector) {
            return this.x * vector.y - this.y * vector.x;
        }
        mag() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
        magSqr() {
            return this.x * this.x + this.y * this.y;
        }
        normalizeSelf() {
            var magSqr = this.x * this.x + this.y * this.y;
            if (magSqr === 1.0)
                return this;
            if (magSqr === 0.0) {
                return this;
            }
            var invsqrt = 1.0 / Math.sqrt(magSqr);
            this.x *= invsqrt;
            this.y *= invsqrt;
            return this;
        }
        normalize(out) {
            out = out || new Vec2();
            out.x = this.x;
            out.y = this.y;
            out.normalizeSelf();
            return out;
        }
        angle(vector) {
            var magSqr1 = this.magSqr();
            var magSqr2 = vector.magSqr();
            if (magSqr1 === 0 || magSqr2 === 0) {
                console.warn("Can't get angle between zero vector");
                return 0.0;
            }
            var dot = this.dot(vector);
            var theta = dot / (Math.sqrt(magSqr1 * magSqr2));
            theta = Mathf.clamp(theta, -1.0, 1.0);
            return Math.acos(theta);
        }
        signAngle(vector) {
            let angle = this.angle(vector);
            return this.cross(vector) < 0 ? -angle : angle;
        }
        rotate(radians, out) {
            out = out || new Vec2();
            out.x = this.x;
            out.y = this.y;
            return out.rotateSelf(radians);
        }
        rotateSelf(radians) {
            var sin = Math.sin(radians);
            var cos = Math.cos(radians);
            var x = this.x;
            this.x = cos * x - sin * this.y;
            this.y = sin * x + cos * this.y;
            return this;
        }
        project(vector) {
            return vector.mul(this.dot(vector) / vector.dot(vector));
        }
    }
    Vec2.ZERO = new Vec2(0, 0);
    Vec2.TEMP = new Vec2(0, 0);
    Vec2.TEMPS = [
        new Vec2(0, 0),
        new Vec2(0, 0),
        new Vec2(0, 0),
        new Vec2(0, 0)
    ];

    class JumpBy extends ActionInterval {
        constructor(duration, x, y, height, jumps) {
            super();
            this._previousPosition = new Vec2(0, 0);
            this._startPosition = new Vec2(0, 0);
            this._delta = new Vec2(0, 0);
            this._height = 0;
            this._jumps = 0;
            height !== undefined && this.initWithDuration(duration, x, y, height, jumps);
        }
        initWithDuration(duration, x, y, height, jumps) {
            if (super.initWithDuration(duration)) {
                this._delta.x = x;
                this._delta.y = y;
                this._height = height;
                this._jumps = jumps;
                return true;
            }
            return false;
        }
        clone() {
            var action = new JumpBy();
            this._cloneDecoration(action);
            action.initWithDuration(this._duration, this._delta.x, this._delta.y, this._height, this._jumps);
            return action;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            var locPosX = target.x;
            var locPosY = target.y;
            this._previousPosition.x = locPosX;
            this._previousPosition.y = locPosY;
            this._startPosition.x = locPosX;
            this._startPosition.y = locPosY;
        }
        update(dt) {
            dt = this._computeEaseTime(dt);
            let target = this.target;
            if (target) {
                var frac = dt * this._jumps % 1.0;
                var y = this._height * 4 * frac * (1 - frac);
                y += this._delta.y * dt;
                var x = this._delta.x * dt;
                var locStartPosition = this._startPosition;
                if (false) {
                    var targetX = target.x;
                    var targetY = target.y;
                    var locPreviousPosition = this._previousPosition;
                    locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
                    locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
                    x = x + locStartPosition.x;
                    y = y + locStartPosition.y;
                    locPreviousPosition.x = x;
                    locPreviousPosition.y = y;
                    target.setXY(x, y);
                }
                else {
                    target.x = locStartPosition.x + x;
                    target.y = locStartPosition.y + y;
                }
            }
        }
        reverse() {
            var action = new JumpBy(this._duration, -this._delta.x, -this._delta.y, this._height, this._jumps);
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
    }
    class JumpTo extends JumpBy {
        constructor(duration, x, y, height, jumps) {
            super();
            this._endPosition = new Vec2(0, 0);
            height !== undefined && this.initWithDuration(duration, x, y, height, jumps);
        }
        initWithDuration(duration, x, y, height, jumps) {
            if (super.initWithDuration(duration, x, y, height, jumps)) {
                this._endPosition.x = x;
                this._endPosition.y = y;
                return true;
            }
            return false;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            this._delta.x = this._endPosition.x - this._startPosition.x;
            this._delta.y = this._endPosition.y - this._startPosition.y;
        }
        clone() {
            var action = new JumpTo();
            this._cloneDecoration(action);
            action.initWithDuration(this._duration, this._endPosition.x, this._endPosition.y, this._height, this._jumps);
            return action;
        }
    }
    class JumpBy3D extends ActionInterval {
        constructor(duration, delta, height, jumps, bWorld) {
            super();
            this._previousPosition = new Laya.Vector3(0, 0);
            this._startPosition = new Laya.Vector3(0, 0);
            this._delta = new Laya.Vector3(0, 0);
            this._height = new Laya.Vector3(0, 0);
            this._jumps = 0;
            height !== undefined && this.initWithDuration(duration, delta, height, jumps, bWorld);
        }
        initWithDuration(duration, delta, height, jumps, bWorld) {
            if (super.initWithDuration(duration)) {
                delta.cloneTo(this._delta);
                height.cloneTo(this._height);
                this._jumps = jumps;
                this._bWorld = bWorld;
                return true;
            }
            return false;
        }
        clone() {
            var action = new JumpBy3D();
            this._cloneDecoration(action);
            action.initWithDuration(this._duration, this._delta, this._height, this._jumps, this._bWorld);
            return action;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            if (this._bWorld) {
                target.transform.position.cloneTo(this._previousPosition);
            }
            else {
                target.transform.localPosition.cloneTo(this._previousPosition);
            }
            this._previousPosition.cloneTo(this._startPosition);
        }
        update(dt) {
            dt = this._computeEaseTime(dt);
            let target = this.target;
            if (target && !target.destroyed) {
                var frac = dt * this._jumps % 1.0;
                let dh = Mathf.TEMP_VEC3S[0];
                let delta = Mathf.TEMP_VEC3S[1];
                Laya.Vector3.scale(this._height, 4 * frac * (1 - frac), dh);
                Laya.Vector3.scale(this._delta, dt, delta);
                Laya.Vector3.add(delta, dh, delta);
                Laya.Vector3.add(this._startPosition, delta, delta);
                if (this._bWorld) {
                    target.transform.position = delta;
                }
                else {
                    target.transform.localPosition = delta;
                }
            }
        }
        reverse() {
            let delta = this._delta.clone();
            Laya.Vector3.scale(delta, -1, delta);
            var action = new JumpBy3D(this._duration, delta, this._height, this._jumps, this._bWorld);
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
    }
    class JumpTo3D extends JumpBy3D {
        constructor(duration, to, height, jumps, bWorld) {
            super();
            this._endPosition = new Laya.Vector3;
            height !== undefined && this.initWithDuration(duration, to, height, jumps, bWorld);
        }
        initWithDuration(duration, to, height, jumps, bWorld) {
            if (super.initWithDuration(duration, to, height, jumps, bWorld)) {
                to.cloneTo(this._endPosition);
                return true;
            }
            return false;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            Laya.Vector3.subtract(this._endPosition, this._startPosition, this._delta);
        }
        clone() {
            var action = new JumpTo3D();
            this._cloneDecoration(action);
            action.initWithDuration(this._duration, this._endPosition, this._height, this._jumps, this._bWorld);
            return action;
        }
    }
    let default_number_formater = function (value) {
        return (value | 0).toString();
    };
    class NumberTo extends ActionInterval {
        constructor(duration, from, to, formater) {
            super();
            this._from = from;
            this._to = to;
            this._formater = formater || default_number_formater;
            this.initWithDuration(duration);
        }
        clone() {
            var action = new NumberTo(this._duration, this._from, this._to, this._formater);
            this._cloneDecoration(action);
            return action;
        }
        initWithDuration(duration) {
            if (super.initWithDuration(duration)) {
                return true;
            }
            return false;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            this.m_label = target;
        }
        update(t) {
            if (this.m_label) {
                t = this._computeEaseTime(t);
                let cur = this._from + (this._to - this._from) * t;
                this.m_label.text = this._formater(cur);
            }
        }
    }
    class StringOneByOne extends ActionInterval {
        constructor(duration, text) {
            super();
            this._text = text;
            this.initWithDuration(duration);
        }
        clone() {
            var action = new StringOneByOne(this._duration, this._text);
            this._cloneDecoration(action);
            return action;
        }
        update(t) {
            let target = this.target;
            if (target) {
                t = this._computeEaseTime(t);
                let idx = Math.floor(Mathf.lerp(0, this._text.length, t));
                target.text = this._text.substring(0, idx);
            }
        }
    }
    class Follow3DTo2D extends ActionInterval {
        constructor(duration, target, orthographicCamera, offsetX = 0, offsetY = 0) {
            super();
            this._followTarget = target;
            this._orthographicCamera = orthographicCamera;
            this._offsetX = offsetX;
            this._offsetY = offsetY;
            if (duration <= 0)
                duration = 1e8;
            this.initWithDuration(duration);
        }
        clone() {
            var action = new Follow3DTo2D(this._duration, this._followTarget, this._orthographicCamera);
            this._cloneDecoration(action);
            return action;
        }
        update(t) {
            let target = this.target;
            if (target) {
                let followTarge = this._followTarget;
                if (followTarge && !followTarge.destroyed) {
                    let v2 = Laya.Point.TEMP;
                    v2.setTo(this._offsetX + followTarge.pivotX, this._offsetY + followTarge.pivotY);
                    followTarge.localToGlobal(v2, false);
                    let v3 = Mathf.TEMP_VEC3;
                    v3.setValue(v2.x, v2.y, 0);
                    this._orthographicCamera.convertScreenCoordToOrthographicCoord(v3, v3);
                    target.transform.position = v3;
                }
            }
        }
    }
    function bezierAt(a, b, c, d, t) {
        return (Math.pow(1 - t, 3) * a +
            3 * t * (Math.pow(1 - t, 2)) * b +
            3 * Math.pow(t, 2) * (1 - t) * c +
            Math.pow(t, 3) * d);
    }
    class BezierBy extends ActionInterval {
        constructor(duration, points) {
            super();
            this._config = [];
            this._startPosition = new Vec2();
            this._previousPosition = new Vec2();
            points && this.initWithDuration(duration, points);
        }
        initWithDuration(duration, points) {
            if (super.initWithDuration(duration)) {
                this._config = points;
                return true;
            }
            return false;
        }
        clone() {
            var action = new BezierBy();
            this._cloneDecoration(action);
            var newConfigs = [];
            for (var i = 0; i < this._config.length; i++) {
                var selConf = this._config[i];
                newConfigs.push(new Vec2(selConf.x, selConf.y));
            }
            action.initWithDuration(this._duration, newConfigs);
            return action;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            var locPosX = target.x;
            var locPosY = target.y;
            this._previousPosition.x = locPosX;
            this._previousPosition.y = locPosY;
            this._startPosition.x = locPosX;
            this._startPosition.y = locPosY;
        }
        update(t) {
            t = this._computeEaseTime(t);
            if (this.target) {
                var target = this.target;
                var locConfig = this._config;
                var xa = 0;
                var xb = locConfig[0].x;
                var xc = locConfig[1].x;
                var xd = locConfig[2].x;
                var ya = 0;
                var yb = locConfig[0].y;
                var yc = locConfig[1].y;
                var yd = locConfig[2].y;
                var x = bezierAt(xa, xb, xc, xd, t);
                var y = bezierAt(ya, yb, yc, yd, t);
                var locStartPosition = this._startPosition;
                if (false) {
                    var targetX = target.x;
                    var targetY = target.y;
                    var locPreviousPosition = this._previousPosition;
                    locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
                    locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
                    x = x + locStartPosition.x;
                    y = y + locStartPosition.y;
                    locPreviousPosition.x = x;
                    locPreviousPosition.y = y;
                    target.setXY(x, y, true);
                }
                else {
                    target.x = locStartPosition.x + x;
                    target.y = locStartPosition.y + y;
                }
            }
        }
        reverse() {
            var locConfig = this._config;
            var x0 = locConfig[0].x, y0 = locConfig[0].y;
            var x1 = locConfig[1].x, y1 = locConfig[1].y;
            var x2 = locConfig[2].x, y2 = locConfig[2].y;
            var r = [
                new Vec2(x1 - x2, y1 - y2),
                new Vec2(x0 - x2, y0 - y2),
                new Vec2(-x2, -y2)
            ];
            var action = new BezierBy(this._duration, r);
            this._cloneDecoration(action);
            this._reverseEaseList(action);
            return action;
        }
    }
    class BezierTo extends ActionInterval {
        constructor(duration, points, pathCount = 5, count = 2) {
            super();
            this.initWithDuration(duration, points, pathCount, count);
        }
        initWithDuration(duration, points, pathCount, count) {
            if (super.initWithDuration(duration)) {
                let path = new Laya.Bezier().getBezierPoints(points, pathCount, count);
                this._path = path;
                let len = 0;
                for (var i = 0; i < path.length - 2; i += 2) {
                    len += Mathf.distance2(path[i] - path[i + 2], path[i + 1] - path[i + 3]);
                }
                return true;
            }
            return false;
        }
        clone() {
            console.error("暂无clone实现，偷懒而已");
            return null;
        }
        startWithTarget(target) {
            super.startWithTarget(target);
        }
        setUpdateCallBack(callback) {
            this.handlerUpdate = callback;
        }
        update(t) {
            t = this._computeEaseTime(t);
            if (this.target) {
                var pos = Vec2.TEMP;
                let ox = this.target.x;
                let oy = this.target.y;
                BezierTo.lerpPath(this._path, t, pos);
                var target = this.target;
                let dx = pos.x - ox;
                let dy = pos.y - oy;
                target.x = pos.x;
                target.y = pos.y;
                if (this.handlerUpdate)
                    this.handlerUpdate.runWith([dx, dy]);
            }
        }
        reverse() {
            console.error("暂无reverse实现，偷懒而已");
            return null;
        }
        static lerpPath(path, t, out) {
            if (path.length == 0) {
                return;
            }
            t = Mathf.clamp01(t);
            if (out == null) {
                out = new Vec2(0, 0);
            }
            if (t == 0) {
                out.setValue(path[0], path[1]);
            }
            else if (t == 1) {
                out.setValue(path[path.length - 2], path[path.length - 1]);
            }
            else {
                let value = (path.length / 2 - 1) * t;
                let min = value | 0;
                let max = Math.ceil(value);
                if (min != max) {
                    out.x = Mathf.lerp(path[min * 2], path[max * 2], value - min);
                    out.y = Mathf.lerp(path[min * 2 + 1], path[max * 2 + 1], value - min);
                }
                else {
                    out.setValue(path[max * 2], path[max * 2 + 1]);
                }
            }
            return out;
        }
    }
    class LookAt extends ActionInterval {
        constructor(duration, target) {
            super();
            this.looAtTarget = target;
            this.lookAtPos = new Laya.Vector3();
            if (duration <= 0)
                duration = 1e8;
            this.initWithDuration(duration);
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            let forward = Mathf.TEMP_VEC3;
            target.transform.getForward(forward);
            Laya.Vector3.normalize(forward, forward);
            let dis = Laya.Vector3.distance(target.transform.position, this.looAtTarget.transform.position);
            Laya.Vector3.scale(forward, dis, forward);
            Laya.Vector3.add(target.transform.position, forward, this.lookAtPos);
        }
        clone() {
            var action = new LookAt(this._duration, this.looAtTarget);
            this._cloneDecoration(action);
            return action;
        }
        update(t) {
            let target = this.target;
            if (target) {
                let lookAtTarge = this.looAtTarget;
                if (lookAtTarge && !lookAtTarge.destroyed) {
                    Laya.Vector3.lerp(this.lookAtPos, lookAtTarge.transform.position, 0.1, this.lookAtPos);
                    target.transform.lookAt(this.lookAtPos, LookAt.UP, false);
                }
            }
        }
    }
    LookAt.UP = new Laya.Vector3(0, 1, 0);
    class Follow3D extends ActionInterval {
        constructor(duration, target, distance = 0) {
            super();
            this.followTarget = target;
            this.distance = distance;
            this.originPos = new Laya.Vector3();
            if (duration <= 0)
                duration = 1e8;
            this.initWithDuration(duration);
        }
        startWithTarget(target) {
            super.startWithTarget(target);
            if (this.distance <= 0) {
                this.distance = Laya.Vector3.distance(target.transform.position, this.followTarget.transform.position);
            }
            target.transform.position.cloneTo(this.originPos);
        }
        clone() {
            var action = new Follow3D(this._duration, this.followTarget, this.distance);
            this._cloneDecoration(action);
            return action;
        }
        update(t) {
            let target = this.target;
            if (target) {
                let followTarge = this.followTarget;
                if (followTarge && !followTarge.destroyed) {
                    Laya.Vector3.lerp(this.originPos, followTarge.transform.position, 0.1, this.originPos);
                    target.transform.position = this.originPos;
                }
            }
        }
    }
    Follow3D.UP = new Laya.Vector3(0, 1, 0);
    class Follow2D extends ActionInterval {
        constructor(duration, target, offset) {
            super();
            this.followTarget = target;
            this.offset = offset || new Laya.Point();
            if (duration <= 0)
                duration = 1e8;
            this.initWithDuration(duration);
        }
        startWithTarget(target) {
            super.startWithTarget(target);
        }
        clone() {
            var action = new Follow2D(this._duration, this.followTarget, this.offset);
            this._cloneDecoration(action);
            return action;
        }
        update(t) {
            let target = this.target;
            if (target) {
                let followTarget = this.followTarget;
                if (followTarget && !followTarget.isDisposed) {
                    let p = Follow2D.temp_point;
                    p.setTo(this.offset.x, this.offset.y);
                    followTarget.localToGlobal(p.x, p.y, p);
                    if (target.parent) {
                        target.parent.globalToLocal(p.x, p.y, p);
                        target.x = Mathf.lerp(target.x, p.x, 0.1);
                        target.y = Mathf.lerp(target.y, p.y, 0.1);
                    }
                }
            }
        }
    }
    Follow2D.temp_point = new Laya.Point();

    var cc;
    (function (cc) {
        function tween(target, clearBefore = false) {
            if (clearBefore)
                clearTween(target);
            return new Tween(target);
        }
        cc.tween = tween;
        function clearTween(target) {
            TweenSystem.instance.ActionManager.removeAllActionsFromTarget(target);
        }
        cc.clearTween = clearTween;
        cc.Ease = Easing;
        function jumpBy(duration, x, y, height, jumps) {
            return new JumpBy(duration, x, y, -height, jumps);
        }
        cc.jumpBy = jumpBy;
        function jumpTo(duration, x, y, height, jumps) {
            return new JumpTo(duration, x, y, -height, jumps);
        }
        cc.jumpTo = jumpTo;
        function jumpBy3D(duration, delta, height, jumps, bWorld = false) {
            return new JumpBy3D(duration, delta, height, jumps, bWorld);
        }
        cc.jumpBy3D = jumpBy3D;
        function jumpTo3D(duration, to, height, jumps, bWorld = false) {
            return new JumpTo3D(duration, to, height, jumps, bWorld);
        }
        cc.jumpTo3D = jumpTo3D;
        function numberTo(duration, from, to, formater) {
            return new NumberTo(duration, from, to, formater);
        }
        cc.numberTo = numberTo;
        function stringOneByOne(duration, text) {
            return new StringOneByOne(duration, text);
        }
        cc.stringOneByOne = stringOneByOne;
        function lookAt(duration, target) {
            return new LookAt(duration, target);
        }
        cc.lookAt = lookAt;
        function bezierTo(duration, points, pathCount) {
            return new BezierTo(duration, points, pathCount, points.length / 2 - 1);
        }
        cc.bezierTo = bezierTo;
        function bezierFromTo(duration, from, to, radiusRate = 0.5, pathCount = 10) {
            let r = Mathf.distance(from, to) * radiusRate;
            let rot = Mathf.random(Math.PI * 200) / 100;
            let x = Math.cos(rot) * r;
            let y = Math.sin(rot) * r;
            let points = [from.x, from.y, from.x + x, from.y + y, to.x, to.y];
            return bezierTo(duration, points, pathCount);
        }
        cc.bezierFromTo = bezierFromTo;
        function follow2d(target, duration = 0, offset) {
            return new Follow2D(duration, target, offset);
        }
        cc.follow2d = follow2d;
        function follow3d(target, duration = 0, distance) {
            return new Follow3D(duration, target, distance);
        }
        cc.follow3d = follow3d;
        cc.PROP = {
            EMPTY: {},
            SCALE0: { scaleX: 0, scaleY: 0 },
            SCALE1: { scaleX: 1, scaleY: 1 },
            SCALE1_2: { scaleX: 1.2, scaleY: 1.2 },
            ALPHA0: { alpha: 0 },
            ALPHA1: { alpha: 1 },
            SCALE_ALPHA0: { scaleX: 0, scaleY: 0, alpha: 0 },
            SCALE_ALPHA1: { scaleX: 1, scaleY: 1, alpha: 1 },
        };
        cc.OPTION = {
            BACK_OUT: { easing: Easing.backOut },
            BACK_IN: { easing: Easing.backIn },
            SINE_IN: { easing: Easing.sineIn },
            SINE_OUT: { easing: Easing.sineOut },
            SINE_IN_OUT: { easing: Easing.sineInOut },
            SINE_OUT_IN: { easing: Easing.sineOutIn },
            CIRC_IN: { easing: Easing.circIn },
            CIRC_OUT: { easing: Easing.circOut },
            EXPO_IN: { easing: Easing.expoIn },
            EXPO_OUT: { easing: Easing.expoOut },
            CUBIC_IN: { easing: Easing.cubicIn },
            CUBIC_OUT: { easing: Easing.cubicOut },
        };
    })(cc || (cc = {}));

    class UITools {
        static get MASK_TEXTURE2D() {
            if (!this.maskTexture2d) {
                var pixels = new Uint8Array(4);
                pixels[0] = 0;
                pixels[1] = 0;
                pixels[2] = 0;
                pixels[3] = (255 * 0.7) | 0;
                let tex2d = new Laya.Texture2D(1, 1, Laya.TextureFormat.R8G8B8A8, false, false);
                tex2d.setPixels(pixels);
                tex2d.lock = true;
                this.maskTexture2d = tex2d;
            }
            return this.maskTexture2d;
        }
        static get MASK_TEXTURE() {
            if (!this.maskTexture) {
                this.maskTexture = Laya.Texture.create(this.MASK_TEXTURE2D, 0, 0, 1, 1);
            }
            return this.maskTexture;
        }
        static get WHITE_TEXTURE2D() {
            return Laya.Texture2D.whiteTexture;
        }
        static get WHITE_TEXTURE() {
            if (!this.whiteTexture) {
                this.whiteTexture = Laya.Texture.create(this.WHITE_TEXTURE2D, 0, 0, 1, 1);
            }
            return this.whiteTexture;
        }
        static getChild(node, childPath) {
            if (!childPath)
                return null;
            if (childPath == "/")
                return node;
            if (~childPath.indexOf("/")) {
                let names = childPath.split("/");
                for (let i = 0; i < names.length; i++) {
                    node = node.getChildByName(names[i]);
                    if (!node)
                        return null;
                }
                return node;
            }
            else {
                return node.getChildByName(childPath);
            }
        }
        static findChild(root, childName) {
            if (!childName)
                return null;
            if (root.name == childName)
                return root;
            for (let i = root.numChildren - 1; i >= 0; i--) {
                let child = this.findChild(root.getChildAt(i), childName);
                if (child) {
                    return child;
                }
            }
        }
        static findAllMeshRenderers(node, out, recursive = false) {
            out = out || [];
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                if (child) {
                    let render = child["meshRenderer"];
                    if (render) {
                        out.push(render);
                    }
                    if (recursive) {
                        this.findAllMeshRenderers(child, out, recursive);
                    }
                }
            }
            return out;
        }
        static findAllSkinnedMeshRenderers(node, out, recursive = false) {
            out = out || [];
            for (let i = 0; i < node.numChildren; i++) {
                let child = node.getChildAt(i);
                if (child) {
                    let render = child["skinnedMeshRenderer"];
                    if (render) {
                        out.push(render);
                    }
                    if (recursive) {
                        this.findAllSkinnedMeshRenderers(child, out, recursive);
                    }
                }
            }
            return out;
        }
        static findMeshRender(model) {
            for (let i = 0; i < model.numChildren; i++) {
                let child = model.getChildAt(i);
                let renderer = child[`skinnedMeshRenderer`] || child[`meshRenderer`];
                if (renderer) {
                    return renderer;
                }
            }
            return null;
        }
        static findAllShurikenParticleSystem(node, out) {
            out = out || [];
            for (var i = node.numChildren - 1; i >= 0; i--) {
                var child = node.getChildAt(i);
                if (child.particleSystem) {
                    out.push(child.particleSystem);
                }
                this.findAllShurikenParticleSystem(child, out);
            }
            return out;
        }
        static setLayer(node, layer) {
            node.layer = layer;
            for (var i = 0; i < node.numChildren; i++) {
                this.setLayer(node.getChildAt(i), layer);
            }
        }
        static cloneSprite(sprite) {
            let newSprite = this._cloneSingleSprite(sprite);
            for (var i = 0; i < sprite.numChildren; i++) {
                var newChild = this.cloneSprite(sprite.getChildAt(i));
                if (newChild) {
                    newSprite.addChild(newChild);
                }
            }
            return newSprite;
        }
        static _cloneSingleSprite(sprite) {
            if (!sprite.name)
                return null;
            let newSprite;
            if (sprite instanceof Laya.Image) {
                let newImage = new Laya.Image(sprite.skin);
                if (sprite.anchorX)
                    newImage.anchorX = sprite.anchorX;
                if (sprite.anchorY)
                    newImage.anchorY = sprite.anchorY;
                newImage.sizeGrid = sprite.sizeGrid;
                newImage.pivot(sprite.pivotX, sprite.pivotY);
                newSprite = newImage;
            }
            else if (sprite instanceof Laya.Label) {
                let newLabel = new Laya.Label();
                newLabel.fontSize = sprite.fontSize;
                newLabel.color = sprite.color;
                newLabel.strokeColor = sprite.strokeColor;
                newLabel.stroke = sprite.stroke;
                if (sprite.anchorX)
                    newLabel.anchorX = sprite.anchorX;
                if (sprite.anchorY)
                    newLabel.anchorY = sprite.anchorY;
                newLabel.align = sprite.align;
                newLabel.wordWrap = sprite.wordWrap;
                newLabel.text = sprite.text;
                newSprite = newLabel;
            }
            else if (sprite instanceof Laya.Text) {
                let newText = new Laya.Label();
                newText.fontSize = sprite.fontSize;
                newText.color = sprite.color;
                newText.strokeColor = sprite.strokeColor;
                newText.stroke = sprite.stroke;
                newText.align = sprite.align;
                newText.wordWrap = sprite.wordWrap;
                newText.text = sprite.text;
                newSprite = newText;
            }
            else if (sprite instanceof Laya.Sprite) {
                newSprite = new Laya.Sprite();
                newSprite.texture = sprite.texture;
                newSprite.pivot(sprite.pivotX, sprite.pivotY);
            }
            if (sprite["_width"])
                newSprite.width = sprite.width;
            if (sprite["_height"])
                newSprite.height = sprite.height;
            newSprite.pos(sprite.x, sprite.y, true)
                .scale(sprite.scaleX, sprite.scaleY).rotation = sprite.rotation;
            newSprite.name = sprite.name;
            return newSprite;
        }
        static local2local(from, toNode, outPos) {
            from.localToGlobal(outPos, false);
            toNode.globalToLocal(outPos, false);
            return outPos;
        }
        static getSelfGlobalPos(obj, outPos) {
            outPos = outPos || new Laya.Point();
            if (obj.parent) {
                outPos.setTo(obj.x, obj.y);
                obj.parent.localToGlobal(obj.x, obj.y, outPos);
            }
            return outPos;
        }
        static node2camera(obj, camera, out) {
            let p = this.getSelfGlobalPos(obj, new Laya.Point());
            return this.global2camera(p, camera, out);
        }
        static global2camera(worldPos, camera, out) {
            out = out || new Laya.Vector3();
            out.x = worldPos.x;
            out.y = worldPos.y;
            out.z = 0;
            camera.convertScreenCoordToOrthographicCoord(out, out);
            return out;
        }
        static worldToScreen(pos, camera, out) {
            out = out || new Laya.Point();
            let point = this.vec4_temp;
            camera.viewport.project(pos, camera.projectionViewMatrix, point);
            out.x = point.x / Laya.stage.clientScaleX;
            out.y = point.y / Laya.stage.clientScaleY;
            return out;
        }
        static screenToWorld(screenPos, camera, distance, out) {
            out = out || new Laya.Vector3();
            this.screenToRay(screenPos, camera, this.ray_temp);
            Laya.Vector3.scale(this.ray_temp.direction, distance, out);
            Laya.Vector3.add(this.ray_temp.origin, out, out);
            return out;
        }
        static screenToRay(screenPos, camera, ray) {
            ray = ray || new Laya.Ray(new Laya.Vector3, new Laya.Vector3);
            this.convertScreenToCanvas(screenPos, this.vec2_temp);
            camera.viewportPointToRay(this.vec2_temp, ray);
            return ray;
        }
        static convertScreenToCanvas(screenPos, out) {
            out = out || new Laya.Vector2();
            out.x = screenPos.x * Laya.stage.clientScaleX;
            out.y = screenPos.y * Laya.stage.clientScaleY;
            return out;
        }
        static clampSpriteSize(sprite, maxSize) {
            let max = Math.max(sprite.width, sprite.height);
            if (max > 0) {
                if (max > maxSize) {
                    let scale = maxSize / max;
                    sprite.scale(scale, scale, true);
                }
            }
            else {
                let texture = sprite.texture;
                if (texture) {
                    let fixSize = function () {
                        if (sprite.destroyed)
                            return;
                        let max = Math.max(texture.width, texture.height);
                        if (max > maxSize) {
                            let scale = maxSize / max;
                            sprite.scale(scale, scale, true);
                        }
                    };
                    if (texture.getIsReady()) {
                        fixSize();
                    }
                    else {
                        texture.once(Laya.Event.READY, sprite, fixSize);
                    }
                }
            }
        }
        static setSpritePosition(sprite3d, x, y, z) {
            let transform = sprite3d.transform;
            transform.position.setValue(x, y, z);
            transform.position = transform.position;
        }
        static setSpriteLocalPosition(sprite3d, x, y, z) {
            let transform = sprite3d.transform;
            transform.localPosition.setValue(x, y, z);
            transform.localPosition = transform.localPosition;
        }
        static setSpriteLocalScale(sprite3d, x, y, z) {
            let transform = sprite3d.transform;
            transform.localScale.setValue(x, y, z);
            transform.localScale = transform.localScale;
        }
        static setTransformVec3Prop(transform, key, x, y, z) {
            let prop = transform[key];
            prop.setValue(x, y, z);
            transform[key] = prop;
        }
        static tweenTransformVec3Prop(transform, key, duration, x, y, z) {
            let prop = transform[key];
            let fromX = prop.x;
            let fromY = prop.y;
            let fromZ = prop.z;
            cc.tween(transform).to(duration, cc.PROP.EMPTY, {
                onUpdate: function (target, t) {
                    prop.setValue(Mathf.lerp(fromX, x, t), Mathf.lerp(fromY, y, t), Mathf.lerp(fromZ, z, t));
                    transform[key] = prop;
                }
            }).start();
        }
        static linearModel(sprite3D, lineSprite3D, color, keepWorldPos = false) {
            if (sprite3D instanceof Laya.MeshSprite3D) {
                var meshSprite3D = sprite3D;
                var mesh = meshSprite3D.meshFilter.sharedMesh;
                var positions = [];
                mesh.getPositions(positions);
                var indices = mesh.getSubMesh(0).getIndices();
                for (var i = 0; i < indices.length; i += 3) {
                    var vertex0 = positions[indices[i]];
                    var vertex1 = positions[indices[i + 1]];
                    var vertex2 = positions[indices[i + 2]];
                    if (keepWorldPos) {
                        Laya.Vector3.transformCoordinate(vertex0, meshSprite3D.transform.worldMatrix, this.transVertex0);
                        Laya.Vector3.transformCoordinate(vertex1, meshSprite3D.transform.worldMatrix, this.transVertex1);
                        Laya.Vector3.transformCoordinate(vertex2, meshSprite3D.transform.worldMatrix, this.transVertex2);
                        lineSprite3D.addLine(this.transVertex0, this.transVertex1, color, color);
                        lineSprite3D.addLine(this.transVertex1, this.transVertex2, color, color);
                        lineSprite3D.addLine(this.transVertex2, this.transVertex0, color, color);
                    }
                    else {
                        lineSprite3D.addLine(vertex0, vertex1, color, color);
                        lineSprite3D.addLine(vertex1, vertex2, color, color);
                        lineSprite3D.addLine(vertex2, vertex0, color, color);
                    }
                }
            }
            for (var i = 0, n = sprite3D.numChildren; i < n; i++)
                this.linearModel(sprite3D.getChildAt(i), lineSprite3D, color);
        }
        static widgetLeftMC(node) {
            this.widgetLeftTopMC(node, false, true);
        }
        static widgetRightMC(node) {
            this.widgetRightTopMC(node, false, true);
        }
        static widgetTopMC(node) {
            this.widgetLeftTopMC(node, true, false);
        }
        static widgetBottomMC(node) {
            this.widgetLeftBottomMC(node, true, false);
        }
        static widgetLeftTopMC(node, bDisableH = false, bDisableV = false) {
            if (!node[`_originPos_`]) {
                node[`_originPos_`] = new Laya.Point(node.x, node.y);
            }
            let offsetX = (UIRoot.uiFitWidth - UIRoot.designWidth) / 2;
            let offsetY = (UIRoot.uiFitHeight - UIRoot.designHeight) / 2;
            !bDisableH && (node.x = node[`_originPos_`].x - offsetX);
            !bDisableV && (node.y = node[`_originPos_`].y - offsetY);
        }
        static widgetRightTopMC(node, bDisableH = false, bDisableV = false) {
            if (!node[`_originPos_`]) {
                node[`_originPos_`] = new Laya.Point(node.x, node.y);
            }
            let offsetX = (UIRoot.uiFitWidth - UIRoot.designWidth) / 2;
            let offsetY = (UIRoot.uiFitHeight - UIRoot.designHeight) / 2;
            !bDisableH && (node.x = node[`_originPos_`].x + offsetX);
            !bDisableV && (node.y = node[`_originPos_`].y - offsetY);
        }
        static widgetLeftBottomMC(node, bDisableH = false, bDisableV = false) {
            if (!node[`_originPos_`]) {
                node[`_originPos_`] = new Laya.Point(node.x, node.y);
            }
            let offsetX = (UIRoot.uiFitWidth - UIRoot.designWidth) / 2;
            let offsetY = (UIRoot.uiFitHeight - UIRoot.designHeight) / 2;
            !bDisableH && (node.x = node[`_originPos_`].x - offsetX);
            !bDisableV && (node.y = node[`_originPos_`].y + offsetY);
        }
        static widgetRightBottomMC(node, bDisableH = false, bDisableV = false) {
            if (!node[`_originPos_`]) {
                node[`_originPos_`] = new Laya.Point(node.x, node.y);
            }
            let offsetX = (UIRoot.uiFitWidth - UIRoot.designWidth) / 2;
            let offsetY = (UIRoot.uiFitHeight - UIRoot.designHeight) / 2;
            !bDisableH && (node.x = node[`_originPos_`].x + offsetX);
            !bDisableV && (node.y = node[`_originPos_`].y + offsetY);
        }
    }
    UITools.vec2_temp = new Laya.Vector2();
    UITools.vec3_temp = new Laya.Vector3();
    UITools.vec4_temp = new Laya.Vector4();
    UITools.ray_temp = new Laya.Ray(new Laya.Vector3, new Laya.Vector3);
    UITools.transVertex0 = new Laya.Vector3();
    UITools.transVertex1 = new Laya.Vector3();
    UITools.transVertex2 = new Laya.Vector3();

    var AnimLoadState;
    (function (AnimLoadState) {
        AnimLoadState[AnimLoadState["Empty"] = 0] = "Empty";
        AnimLoadState[AnimLoadState["Loading"] = 1] = "Loading";
        AnimLoadState[AnimLoadState["Loaded"] = 2] = "Loaded";
    })(AnimLoadState || (AnimLoadState = {}));
    const DEFAULT_TRANSITION_DURATION = 0.1;
    class AnimStateScript extends Laya.AnimatorStateScript {
        constructor() {
            super(...arguments);
            this._callbackList = [];
        }
        addCallback(callback) {
            this._callbackList.push(callback);
        }
        setEventData(node, animId) {
            this._node = node;
            this._animId = animId;
        }
        onStateEnter() {
            if (this._node.destroyed)
                return;
            this._node.event("Enter", this._animId);
            this._startTime = Timer.time;
        }
        onStateUpdate() {
            let deltaTime = Timer.time - this._startTime;
            for (let i = this._callbackList.length - 1; i >= 0; i--) {
                const callInfo = this._callbackList[i];
                if (callInfo.time <= deltaTime) {
                    callInfo.callback();
                    this._callbackList.splice(i, 1);
                }
            }
        }
        onStateExit() {
            if (this._node.destroyed)
                return;
            this._node.event("Exit", this._animId);
        }
    }
    class Model extends Laya.Sprite3D {
        constructor(modelId) {
            super();
            this.resourceType = RES_TYPE.PREFAB3D;
            this._lastAnimId = "";
            this._curAnimId = "";
            this._animStates = Object.create(null);
            this.delayCalls = [];
            this.aniDelayCalls = {};
            this.modelId = modelId;
            this.modelDb = db.get_model_db(modelId);
            this.sourceName = this.modelDb.resPath;
            this.name = modelId;
            this.create();
        }
        get isLoaded() {
            return this._isLoaded;
        }
        get isLoading() {
            return this._isLoading;
        }
        get lastAnimationId() {
            return this._lastAnimId;
        }
        get curAnimationId() {
            return this._curAnimId;
        }
        create() {
            if (this._isLoaded) {
                return;
            }
            if (this._isLoading) {
                return;
            }
            let pName = this.sourceName;
            if (!pName) {
                console.error("Model.create: can't find resourceName.");
                return;
            }
            this._isLoading = true;
            ResLoader.loadRes(this.sourceName, this.resourceType, (res) => {
                this.onResLoaded(res);
            });
        }
        onResLoaded(res) {
            this._isLoading = false;
            if (res) {
                if (!this.destroyed) {
                    this._isLoaded = true;
                    this.onResourceLoaded(res);
                    if (!this.destroyed && this.scene)
                        this.processDelayCalls();
                }
            }
            else {
                this.onResourceLoadedFail();
            }
        }
        onResourceLoadedFail() {
            console.warn("资源加载失败:", this.sourceName);
        }
        onResourceLoaded(res) {
            this.resNode = Laya.Sprite3D.instantiate(res);
            this._animtor = this.resNode.getComponent(Laya.Animator);
            this.addChild(this.resNode);
            if (this._animtor)
                this.on("Exit", this, this._onAnimComplete);
        }
        tryCreate() {
            if (this.destroyed || this._isLoaded || this._isLoading)
                return;
            this.create();
        }
        reuse() {
            this.tryCreate();
            this.setSpeed(1);
            this.active = true;
        }
        unuse() {
            this._curAnimId = "";
            this._clearAnimList();
            this.setSpeed(0);
            this.removeSelf();
            this.transform.position = new Laya.Vector3(0, 0, 0);
            this.transform.rotationEuler = new Laya.Vector3(0, 0, 0);
            this.transform.localScale = new Laya.Vector3(1, 1, 1);
            this.active = false;
        }
        dispose() {
            this.destroy();
        }
        onDestroy() {
            this._isLoaded = false;
            this.clearDelayCalls();
        }
        initAnimator(createControllerLayer = true, alwaysAnimate = true) {
            if (this._isLoaded) {
                if (!this._animtor) {
                    this._animtor = this.resNode.addComponent(Laya.Animator);
                    this._animtor.cullingMode = alwaysAnimate ? Laya.Animator.CULLINGMODE_ALWAYSANIMATE : Laya.Animator.CULLINGMODE_CULLCOMPLETELY;
                    createControllerLayer && this._animtor.addControllerLayer(new Laya.AnimatorControllerLayer(""));
                    this.on("Exit", this, this._onAnimComplete);
                }
            }
            else {
                this.safeCall(this.initAnimator, createControllerLayer, alwaysAnimate);
            }
        }
        getAnimator() {
            if (this.callable) {
                return this._animtor;
            }
            else {
                this.logNotFinishError();
            }
        }
        logNotFinishError() {
            Logger.error("对象未加载完成");
        }
        getAnimationDuration(animId) {
            let animState = this._animtor.getControllerLayer(0).getAnimatorState(animId);
            if (animState) {
                return animState.clip.duration();
            }
            else {
                return 0;
            }
        }
        playAnim(animId, transitionDuration = DEFAULT_TRANSITION_DURATION, loop) {
            if (!this.callable) {
                this.safeCall(this.playAnim, animId, transitionDuration, loop);
                return;
            }
            this._clearAnimList();
            this._checkAnimAndPlay(animId, transitionDuration, 0, loop);
        }
        _checkAnimAndPlay(animId, transitionDuration, normalizedTime, loop) {
            if (!this._animtor)
                return;
            this._curAnimId = animId;
            this._lastAnimId = animId;
            switch (this._animStates[animId] || AnimLoadState.Empty) {
                case AnimLoadState.Loaded:
                    this._playAnimOnloaded(animId, transitionDuration, normalizedTime, loop);
                    break;
                case AnimLoadState.Empty:
                    if (animId) {
                    }
                    else {
                        this._playAnimOnloaded(null, transitionDuration, normalizedTime, loop);
                    }
                    break;
                case AnimLoadState.Loading:
                    break;
            }
        }
        addAnimatorStateById(animId) {
            if (this._animtor.getControllerLayer(0).getAnimatorState(animId)) {
                return;
            }
        }
        addAnimatorState(animId, clip) {
            if (!this._animtor)
                return;
            if (!clip) {
                console.error(`Model.addAnimatorState: 未知动画:${animId}`);
                return;
            }
            if (this._animtor.getControllerLayer(0).getAnimatorState(animId)) {
                console.log(`Model.addAnimatorState: 重复添加动画:`, animId);
                return;
            }
            let state = new Laya.AnimatorState();
            state.clip = clip;
            state.clipStart = 0;
            state.clipEnd = 1;
            state.name = animId;
            state.addScript(AnimStateScript).setEventData(this, animId);
            if (this.aniDelayCalls[animId]) {
                for (let i = 0; i < this.aniDelayCalls[animId].length; i++) {
                    const element = this.aniDelayCalls[animId][i];
                    state.getScript(AnimStateScript).addCallback(element);
                }
                this.aniDelayCalls[animId] = [];
            }
            this._animtor.getControllerLayer(0).addState(state);
            this._animStates[animId] = AnimLoadState.Loaded;
        }
        addAniCallback(animId, time, callback, aniLayer = 0) {
            if (this.destroyed)
                return;
            if (!this.callable) {
                this.safeCall(this.addAniCallback, animId, time, callback, aniLayer);
                return;
            }
            if (!this._animtor)
                return;
            let layer = this._animtor.getControllerLayer(aniLayer);
            if (!layer) {
                Logger.error(`model: addAniCallback: find layer${aniLayer} failed`);
                return;
            }
            ;
            let state = layer.getAnimatorState(animId);
            if (!state) {
                if (!this.aniDelayCalls[animId])
                    this.aniDelayCalls[animId] = [];
                this.aniDelayCalls[animId].push({
                    time: time,
                    callback: callback,
                });
                return;
            }
            let script = state.getScript(AnimStateScript);
            if (!script)
                return;
            script.addCallback({
                time: time,
                callback: callback,
            });
        }
        _playAnimOnloaded(animId, transitionDuration, normalizedTime, loop) {
            if (this._curAnimId != animId)
                return;
            if (this.destroyed)
                return;
            if (loop != null) {
                this._animtor.getControllerLayer(0).getAnimatorState(animId).clip.islooping = loop;
            }
            if (!transitionDuration) {
                this._animtor.play(animId, 0, normalizedTime);
            }
            else {
                this._animtor.crossFade(animId, transitionDuration, 0, normalizedTime);
            }
        }
        playAnims(transitionDuration = DEFAULT_TRANSITION_DURATION, animIds, loop) {
            if (!this.callable) {
                this.safeCall(this.playAnims, transitionDuration, animIds, loop);
                return;
            }
            this._loop = loop;
            switch (animIds.length) {
                case 0:
                    return;
                case 1:
                    this._checkAnimAndPlay(animIds[0], transitionDuration, 0, loop);
                    break;
                default:
                    this._animPlayList = animIds.slice(1);
                    this._checkAnimAndPlay(animIds[0], transitionDuration, 0, false);
                    break;
            }
        }
        _onAnimComplete(animId) {
            this._curAnimId = "";
            if (this._animPlayList && this._animPlayList.length > 0) {
                let animId = this._animPlayList.shift();
                this._checkAnimAndPlay(animId, 0.1, 0, this._loop);
                if (this._animPlayList.length == 0)
                    this._animPlayList = null;
            }
        }
        _clearAnimList() {
            this._animPlayList = null;
            this._loop = null;
        }
        simulate(animId, normalizedTime) {
            if (!this.callable) {
                this.safeCall(this.simulate, animId, normalizedTime);
                return;
            }
            this._clearAnimList();
            this._checkAnimAndPlay(animId, 0, normalizedTime, false);
        }
        getSpeed() {
            return this._animtor && this._animtor.speed;
        }
        setSpeed(value) {
            if (this.callable) {
                this._animtor && (this._animtor.speed = value);
            }
            else {
                this.safeCall(this.setSpeed, value);
            }
        }
        safeCall(method, ...ps) {
            if (this.destroyed)
                return;
            if (this._isLoaded) {
                method.apply(this, ps);
            }
            else {
                this.pushDelayCall(method, ps);
            }
        }
        processDelayCalls() {
            let calls = this.delayCalls;
            let len = calls.length;
            if (len > 0) {
                this.delayCalls = [];
                for (let i = 0; i < len; i++) {
                    const item = calls[i];
                    item.method.apply(this, item.params);
                }
            }
        }
        clearDelayCalls() {
            if (this.delayCalls.length > 0)
                this.delayCalls.length = 0;
        }
        pushDelayCall(method, params) {
            this.delayCalls.push({ method: method, params: params });
        }
        callIfLoaded(func) {
            if (this.destroyed)
                return;
            if (this.isLoaded) {
                this.callDelayFunc(func);
            }
            else {
                this.pushDelayCall(this.callDelayFunc, [func]);
            }
        }
        callDelayFunc(func) {
            if (func) {
                func();
            }
        }
        get callable() {
            return this._isLoaded && !this.destroyed;
        }
    }

    class Particle extends Model {
        constructor() {
            super(...arguments);
            this.sourceName = null;
            this.resourceType = RES_TYPE.PREFAB3D;
            this._pss = [];
        }
        onResourceLoaded(res) {
            super.onResourceLoaded(res);
            Particle._findPs(this.resNode, this._pss);
        }
        static _findPs(node, out) {
            for (var i = node.numChildren - 1; i >= 0; i--) {
                var child = node.getChildAt(i);
                if (child.particleSystem) {
                    out.push(child.particleSystem);
                }
                this._findPs(child, out);
            }
        }
        reuse() {
            super.reuse();
        }
        unuse() {
            this.stop();
            this.stopFollow();
            super.unuse();
        }
        dispose() {
            this._pss = null;
            super.dispose();
        }
        play(pos, time, stopDelay, layer) {
            if (this.callable) {
                layer && layer.addChild(this.resNode);
                pos && (this.transform.position = pos);
                for (var i = this._pss.length - 1; i >= 0; i--) {
                    this._pss[i].play();
                }
                if (time) {
                    Laya.timer.once(time * 1000, this, this.stopAndPutback, [stopDelay]);
                }
            }
            else {
                this.safeCall(this.play, pos, time, stopDelay, layer);
            }
        }
        stopAndPutback(delay) {
            if (this.callable) {
                this.stop();
                if (delay) {
                    Laya.timer.once(delay * 1000, this, this.putBack);
                }
                else {
                    this.putBack();
                }
            }
            else {
                this.safeCall(this.stopAndPutback, delay);
            }
        }
        stop() {
            if (this.callable) {
                for (var i = this._pss.length - 1; i >= 0; i--) {
                    this._pss[i].stop();
                }
            }
            else {
                this.safeCall(this.stop);
            }
        }
        putBack() {
            if (this.callable) {
                Global.poolManager.put(this);
            }
            else {
                this.safeCall(this.putBack);
            }
        }
        resetTrail(mode) {
            mode = mode || this.resNode;
            if (mode instanceof Laya.TrailSprite3D) {
                let oldTime = mode.trailFilter.time;
                mode.trailFilter.time = 0;
                Laya.timer.frameOnce(1, mode, function () {
                    mode.trailFilter.time = oldTime;
                });
            }
            for (let i = 0; i < mode.numChildren; i++) {
                let child = mode.getChildAt(i);
                this.resetTrail(child);
            }
        }
        setPlayOnAwake(value) {
            if (!this.callable) {
                return this.safeCall(this.setPlayOnAwake, value);
            }
            for (var i = this._pss.length - 1; i >= 0; i--) {
                this._pss[i].playOnAwake = value;
            }
        }
        simulateParticle(time, restart) {
            if (this.callable) {
                for (var i = this._pss.length - 1; i >= 0; i--) {
                    this._pss[i].simulate(time, restart);
                }
            }
            else {
                this.safeCall(this.simulate, time, restart);
            }
        }
        setCurrentTime(time) {
            if (this.callable) {
                for (var i = this._pss.length - 1; i >= 0; i--) {
                    var emitTime = time - this._pss[i]["_currentTime"];
                    this._pss[i]["_updateParticles"](emitTime);
                }
            }
            else {
                this.safeCall(this.setCurrentTime, time);
            }
        }
        followTarget(target, camera, offsetX = 0, offsetY = 0) {
            if (!this.callable) {
                return this.safeCall(this.followTarget, target, camera, offsetX, offsetY);
            }
            if (target instanceof Laya.Sprite3D) {
                this._target3D = target;
            }
            else {
                this._target = target;
                this._camera = camera;
                this._offsetX = offsetX;
                this._offsetY = offsetY;
            }
            Laya.timer.frameLoop(1, this, this.updateFollow, null, true);
            this.updateFollow();
        }
        followScale(value) {
            if (this.callable) {
                this._bScale = value;
            }
            else {
                this.safeCall(this.followScale, value);
            }
        }
        stopFollow() {
            if (!this.callable) {
                return this.safeCall(this.stopFollow);
            }
            this._target = null;
            this._target3D = null;
            this._camera = null;
            this._bScale = false;
            Laya.timer.clearAll(this);
        }
        updateFollow() {
            if (this._target) {
                if (this._target.isDisposed || this._camera.destroyed) {
                    this.stopAndPutback();
                }
                else {
                    this.align(this._target, this._camera);
                }
            }
            else {
                if (this._target3D.destroyed) {
                    this.stopAndPutback();
                }
                else {
                    this.align3D(this._target3D);
                }
            }
        }
        align(target, camera) {
            let p0 = Particle._TEMP_P;
            let p1 = Particle._TEMP_VEC3;
            UITools.getSelfGlobalPos(target, p0);
            p1.setValue(p0.x, p0.y, 0);
            camera.convertScreenCoordToOrthographicCoord(p1, p1);
            this.transform.position = p1;
        }
        align3D(target) {
            let p1 = Particle._TEMP_VEC3;
            target.transform.position.cloneTo(p1);
            this.transform.position = p1;
            if (this._bScale) {
                this.transform.localScale = target.transform.localScale;
            }
        }
    }
    Particle._TEMP_P = new Laya.Point();
    Particle._TEMP_VEC3 = new Laya.Vector3();

    class mgrTip extends Manager {
        static onLoad() {
            Global.require("ViewTipItem").init();
            super.onLoad();
        }
        static playEffect(effectId, pos, time, stopDelay) {
            let effect = Global.poolManager.get(Particle, effectId);
            return effect;
        }
        static showMsgTip(text) {
            Global.sendMsg(BASE_MSG.UI_SHOW_TIP, text);
        }
        static alertPrompt(desc, title, onConfirm, onCancel, confirmText, cancelText) {
            let context;
            if (typeof desc === "string") {
                context = {
                    desc: desc,
                    title: title,
                    confirm: onConfirm,
                    cancel: onCancel,
                    confirmText: confirmText,
                    cancelText: cancelText,
                };
            }
            else {
                context = desc;
            }
            Director.openPanel("PanelDialog", context);
        }
        static alertTip(desc, title, confirmText) {
            Director.openPanelWithSingleton("PanelDialogTip", { title: title || "提示", desc: desc, confirmText: confirmText || "确定" });
        }
        static alertNotEnough(itemId, bShowMsg = true) {
            if (bShowMsg) {
                let itemDb = db.get_item_db(itemId);
                this.showMsgTip(`${itemDb.name}不足~`);
            }
        }
        static alertItemsByText(items, callback) {
            let str = "";
            if (items instanceof Array) {
                for (let i = 0; i < items.length; i++) {
                    const item = items[i];
                    let itemDb = db.get_item_db(item.itemId);
                    if (i == 0) {
                        str = `获得${itemDb.name}x${item.count}`;
                    }
                    else {
                        str = `${str}, 获得${itemDb.name}x${item.count}`;
                    }
                }
            }
            else {
                let itemDb = db.get_item_db(items.itemId);
                str = `获得${itemDb.name}x${items.count}`;
            }
            this.showMsgTip(str);
            callback && callback();
        }
        static alertSingleItem(item, bAdv = true, onClose) {
            Director.openPanelByWait("PanelItemGet", { items: [{ data: item }], bAdv: bAdv, onClose: onClose });
        }
        static alertItems(items, bAdv = true, onClose) {
            if (!items)
                return;
            let item;
            if (items instanceof Array) {
                if (items.length == 0) {
                    onClose && onClose();
                    return;
                }
                if (items.length == 1) {
                    item = items[0];
                }
                else {
                    let idx = 0;
                    var alertItem = () => {
                        this.alertSingleItem(items[idx++], bAdv, function () {
                            Laya.timer.frameOnce(1, this, function () {
                                if (idx < items.length) {
                                    alertItem();
                                }
                                else {
                                    onClose && onClose();
                                }
                            });
                        });
                    };
                    alertItem();
                    return;
                }
            }
            else {
                item = items;
            }
            let itemDb = db.get_item_db(item.itemId);
            switch (itemDb.type) {
                case 2:
                    this.alertSingleItem(item, bAdv, onClose);
                    break;
                case 1:
                    this.alertSingleItem(item, bAdv, onClose);
                    break;
                default:
                    this.alertSingleItem(item, bAdv, onClose);
                    break;
            }
        }
        static alertItemFromNode(items, node) {
            let item;
            if (items instanceof Array) {
                if (items.length == 0)
                    return;
                if (items.length == 1) {
                    item = items[0];
                }
                else {
                    return;
                }
            }
            else {
                item = items;
            }
            let p = UITools.getSelfGlobalPos(node, Laya.Point.TEMP);
            return this.playItemToCurrency(item.itemId, p, 10);
        }
        static initCurrencyIconPosition(coinPos, diamondPos, vitPos) {
            this.uiCoinPos = coinPos;
            this.uiVitPos = vitPos;
            this.uiDiamondPos = diamondPos;
        }
        static playItemToCurrency(itemId, worldPos, count) {
            let itemDb = db.get_item_db(itemId);
            switch (itemId) {
                case 1001:
                    return this.playIconTo(worldPos, count, itemDb.icon, this.uiCoinPos, 0.42, true);
                case 1000:
                    return this.playIconTo(worldPos, count, itemDb.icon, this.uiDiamondPos, 0.42, true);
                case 1002:
                    return this.playIconTo(worldPos, count, itemDb.icon, this.uiVitPos, 0.42, true);
                default:
                    break;
            }
        }
        static playIconTo(worldPos, count = 2, view, toPos, scale = 0.5, rndFly = false) {
        }
    }

    let systemConsole = console;
    var ULLog$1;
    (function (ULLog) {
        class console {
            static info(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.info(...data);
                }
            }
            static log(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.log(...data);
                }
            }
            static warn(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.warn(...data);
                }
            }
            static error(...data) {
                if (ULLog.console.allowConsole) {
                    systemConsole.error(...data);
                }
            }
        }
        console.allowConsole = true;
        ULLog.console = console;
    })(ULLog$1 || (ULLog$1 = {}));
    window["ULLog"] = ULLog$1;

    class ULEventListener {
        constructor(type, priority, callback, bDispatchOnce) {
            this.type = type;
            this.priority = priority;
            this.callback = callback;
            this.bDispatchOnce = bDispatchOnce;
            this.bNeedRemove = false;
        }
        isDispatchOnce() {
            return !!this.bDispatchOnce;
        }
        isNeedRemove() {
            return !!this.bNeedRemove;
        }
        markNeedRemove() {
            this.bNeedRemove = true;
        }
        triggerCallback(event) {
            if (this.callback instanceof Function) {
                try {
                    this.callback(event);
                }
                catch (error) {
                    ULLog.console.error("ULEventListener.triggerCallback has exception!", error.stack);
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class ULEvent {
        constructor(type, data) {
            this.bPropagationStoped = false;
            this.type = type;
            this.data = data;
            this.bPropagationStoped = false;
            this.returnValue = null;
        }
        stopImmediatePropagation() {
            this.bPropagationStoped = true;
        }
        setReturnValue(value, bDonotStop) {
            if (value != null) {
                this.returnValue = value;
                if (!bDonotStop)
                    this.stopImmediatePropagation();
            }
        }
        getReturnValue() {
            return this.returnValue;
        }
        isPropagationStoped() {
            return !!this.bPropagationStoped;
        }
    }

    class ULConst {
    }
    ULConst.CMD_GET_BASE_CHANNEL_INFO = "/c/getBaseChannelInfo";
    ULConst.CMD_SET_VERSION = "/c/setVersion";
    ULConst.CMD_END_USER_GUIDE = "/c/endUserGuide";
    ULConst.CMD_OPEN_MORE_GAME = "/c/openMoreGame";
    ULConst.CMD_OPEN_UL_MORE_GAME = "/c/openUlMoreGame";
    ULConst.CMD_OPEN_PAY = "/c/openPay";
    ULConst.CMD_OPEN_JF = "/c/openJf";
    ULConst.CMD_OPEN_SHARE = "/c/openShare";
    ULConst.CMD_CALL_PHONE = "/c/callPhone";
    ULConst.CMD_UL_WEB_VIEW = "/c/ulWebView";
    ULConst.CMD_EXIT_GAME = "/c/exitGame";
    ULConst.CMD_MEGADATA_SERVER = "/c/megadataServer";
    ULConst.CMD_POST_MEGADATA = "/c/postMegadata";
    ULConst.CMD_USE_CDKEY = "/c/useCdkey";
    ULConst.CMD_CHECK_TIME_CHANGE = "/c/checkTimeChange";
    ULConst.CMD_OPEN_ADV = "/c/openAdv";
    ULConst.CMD_CLICK_NATIVE_ADV = "/c/clickNativeAdv";
    ULConst.CMD_CLOSE_ADV = "/c/closeAdv";
    ULConst.CMD_CLOSE_NATIVE_ADV = "/c/closeNativeAdv";
    ULConst.CMD_USER_LOGIN = "/c/userLogin";
    ULConst.CMD_USER_LOGIN_REPORT = "/c/userLoginReport";
    ULConst.CMD_USER_IS_LOGIN = "/c/userIsLogin";
    ULConst.CMD_LOGIN_OUT = "/c/loginOut";
    ULConst.CMD_SAVE_RANK_DATA = "/c/saveRankData";
    ULConst.CMD_GET_RANK_DATA = "/c/getRankData";
    ULConst.CMD_GET_HEADLINE_IMRANK_DATA = "/c/getHeadlineIMRankData";
    ULConst.CMD_SET_HEADLINE_IMRANK_DATA = "/c/setHeadlineIMRankData";
    ULConst.CMD_RECORDER_GAME_VIDEO = "/c/recorderGameVideo";
    ULConst.CMD_SHARE_GAME_VIDEO = "/c/shareGameVideo";
    ULConst.CMD_OPEN_JUMP = "/c/openJump";
    ULConst.CMD_JUMP_OTHER_GAME = "/c/jumpOtherGame";
    ULConst.CMD_OPEN_RECOMMENDATION = "/c/openRecommendation";
    ULConst.CMD_CLOSE_RECOMMENDATION = "/c/closeRecommendation";
    ULConst.CMD_SAVE_USER_DATA = "/c/saveUserData";
    ULConst.CMD_GET_USER_DATA = "/c/getUserData";
    ULConst.CMD_ADD_GAME_TO_MY_FAVORITE = "/c/addGameToMyFavorite";
    ULConst.CMD_GET_USER_INFO_MSG = "/c/getUserInfoMsg";
    ULConst.CMD_OPEN_USERINFO_ACCREDIT_BUTTON = "/c/openUserInfoAccreditButton";
    ULConst.CMD_CLOSE_USERINFO_ACCREDIT_BUTTON = "/c/closeUserInfoAccreditButton";
    ULConst.CMD_INSTALL_SHORTCUT = "/c/installShortcut";
    ULConst.CMD_SET_CLIPBOARD_DATA = "/c/setClipboardData";
    ULConst.CMD_GET_CLIPBOARD_DATA = "/c/getClipboardData";
    ULConst.CMD_SET_ULSDKDEMO_DEBUG_MODE = "/c/setUlsdkdemoDebugMode";
    ULConst.CMD_MPSDK_AD_HANDLER = '/c/mpsdkAdHandler';
    ULConst.CMD_CREATE_GAME_ICON = '/c/createGameIcon';
    ULConst.CMD_GAME_ICON_HANDLER = '/c/gameIconHandler';
    ULConst.CMD_OPEN_CHANNEL_MORE_GAME_BOX = '/c/openChannelMoreGameBox';
    ULConst.CMD_OPEN_BLOCK_AD = '/c/openBlockAd';
    ULConst.CMD_CLOSE_BLOCK_AD = '/c/closeBlockAd';
    ULConst.CMD_GET_SHORTCUT_STATE = '/c/getShortcutState';
    ULConst.CMD_GET_SUBSCRIBE_STATE = "/c/getSubscribeState";
    ULConst.CMD_ADD_SUBSCRIBE = "/c/addSubscribe";
    ULConst.CMD_ADD_COLOR_SIGN = '/c/addColorSign';
    ULConst.CMD_OPEN_GRID_AD = '/c/openGridAd';
    ULConst.CMD_CLOSE_GRID_AD = '/c/closeGridAd';
    ULConst.CMD_JUMP_TO_VIDEO_VIEW = '/c/jumpToVideoView';
    ULConst.CMD_FOLLOW_OFFICIAL_ACCOUNT = '/c/followOfficialAccount';
    ULConst.CMD_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE = '/c/getFollowOfficialAccountState';
    ULConst.CMD_CONTENT_SECURITY_CHECK = '/c/contentSecurityCheck';
    ULConst.CMD_JUMP_LEISURE_SUBJECT = '/c/jumpLeisureSubject';
    ULConst.CMD_PHONE_VIBRATE = '/c/phoneVibrate';
    ULConst.CMD_OPEN_URL = '/c/openUrl';
    ULConst.CMD_SHOW_CHANNEL_MASK = '/c/showChannelMask';
    ULConst.CMD_CLOSE_CHANNEL_MASK = '/c/closeChannelMask';
    ULConst.CMD_SHOW_PRIVACY = '/c/showPrivacy';
    ULConst.CMD_OPEN_ADVANCED_SETTING = '/c/openAdvancedSetting';
    ULConst.CMD_GET_OPENDATA_CANVAS = '/c/getOpenDataCanvas';
    ULConst.CMD_SET_USER_CLOUD_STORAGE = '/c/setUserCloudStorage';
    ULConst.CMD_GET_USER_CLOUD_STORAGE = '/c/getUserCloudStorage';
    ULConst.CMD_GET_JOIN_GROUP_NUM = "/c/getJoinGroupNum";
    ULConst.CMD_JOIN_GROUP = "/c/joinGroup";
    ULConst.CMD_RANKLIST_GET_USER_NUM = "/c/getUserNumInRank";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_ID = "/c/getUserInfoByIdInRank";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_LIST = "/c/getUserInfoListByRankId";
    ULConst.CMD_RANKLIST_REPORT_USER_INFO = "/c/reportUserInfoInRank";
    ULConst.CMD_RANKLIST_MODIFY_SCORE_BY_ARRAY = "/c/modifyScoreByArray";
    ULConst.CMD_CHANNEL_INFO_RESULT = "/c/channelInfoResult";
    ULConst.CMD_GET_BASE_CHANNEL_INFO_RESULT = "/c/getBaseChannelInfoResult";
    ULConst.CMD_PAY_RESULT = "/c/payResult";
    ULConst.CMD_PRE_PAY_RESULT = "/c/prePayResult";
    ULConst.CMD_SHARE_RESULT = "/c/shareResult";
    ULConst.CMD_LIFE_CYCLE_RESULT = "/c/lifeCycle";
    ULConst.CMD_PAUSE_SOUND_RESULT = "/c/pauseSound";
    ULConst.CMD_RESUME_SOUND_RESULT = "/c/resumeSound";
    ULConst.CMD_COP_INFO_RESULT = "/c/copInfoResult";
    ULConst.CMD_MEGADATA_SERVER_RESULT = "/c/megadataServer";
    ULConst.CMD_POST_MEGADATA_RESULT = "/c/postMegadataResult";
    ULConst.CMD_USE_CDKEY_RESULT = "/c/useCdkey";
    ULConst.CMD_CHECK_TIME_CHANGE_RESULT = "/c/checkTimeChangeResult";
    ULConst.CMD_OPEN_ADV_RESULT = "/c/openAdvResult";
    ULConst.CMD_OPEN_NATIVE_ADV_RESULT = "/c/openNativeAdvResult";
    ULConst.CMD_CLICK_NATIVE_ADV_RESULT = "/c/clickNativeAdvResult";
    ULConst.CMD_CLICK_ADV_RESULT = "/c/clickAdvResult";
    ULConst.CMD_CLOSE_ADV_RESULT = "/c/closeAdvResult";
    ULConst.CMD_CLOSE_NATIVE_ADV_RESULT = "/c/closeNativeAdvResult";
    ULConst.CMD_USER_LOGIN_RESULT = "/c/userLoginResult";
    ULConst.CMD_USER_IS_LOGIN_RESULT = "/c/userIsLoginResult";
    ULConst.CMD_USER_LOGIN_REPORT_RESULT = "/c/userLoginReportResult";
    ULConst.CMD_LOGIN_OUT_RESULT = "/c/loginOutResult";
    ULConst.CMD_SHOW_PRIVACY_RESULT = '/c/showPrivacyResult';
    ULConst.CMD_ADV_VALID_COUNT_RESULT = "/c/advValidCountResult";
    ULConst.CMD_SAVE_RANK_DATA_RESULT = "/c/saveRankDataResult";
    ULConst.CMD_GET_RANK_DATA_RESULT = "/c/getRankDataResult";
    ULConst.CMD_GET_HEADLINE_IMRANK_DATA_RESULT = "/c/getHeadlineIMRankDataResult";
    ULConst.CMD_SET_HEADLINE_IMRANK_DATA_RESULT = "/c/setHeadlineIMRankDataResult";
    ULConst.CMD_RECORDER_GAME_VIDEO_RESULT = "/c/recorderGameVideoResult";
    ULConst.CMD_SHARE_GAME_VIDEO_RESULT = "/c/shareGameVideoResult";
    ULConst.CMD_OPEN_JUMP_RESULT = "/c/openJumpResult";
    ULConst.CMD_JUMP_OTHER_GAME_RESULT = "/c/jumpOtherGameResult";
    ULConst.CMD_JUMP_OTHER_GAME_REWARD_RESULT = "/c/jumpOtherGameRewardResult";
    ULConst.CMD_EXTRA_BONUS_RESULT = "/c/extraBonus";
    ULConst.CMD_OPEN_RECOMMENDATION_RESULT = "/c/openRecommendationResult";
    ULConst.CMD_CLOSE_RECOMMENDATION_RESULT = "/c/closeRecommendationResult";
    ULConst.CMD_SAVE_USER_DATA_RESULT = "/c/saveUserDataResult";
    ULConst.CMD_GET_USER_DATA_RESULT = "/c/getUserDataResult";
    ULConst.CMD_ADD_GAME_TO_MY_FAVORITE_RESULT = "/c/addGameToMyFavoriteResult";
    ULConst.CMD_GET_USER_INFO_MSG_RESULT = "/c/getUserInfoMsgResult";
    ULConst.CMD_OPEN_USERINFO_ACCREDIT_BUTTON_RESULT = "/c/openUserInfoAccreditButtonResult";
    ULConst.CMD_CLOSE_USERINFO_ACCREDIT_BUTTON_RESULT = "/c/closeUserInfoAccreditButtonResult";
    ULConst.CMD_APP_SHARE_RESULT = "/c/appShareResult";
    ULConst.CMD_INSTALL_SHORTCUT_RESULT = "/c/installShortcutResult";
    ULConst.CMD_SET_CLIPBOARD_DATA_RESULT = "/c/setClipboardDataResult";
    ULConst.CMD_GET_CLIPBOARD_DATA_RESULT = "/c/getClipboardDataResult";
    ULConst.CMD_MPSDK_AD_HANDLER_RESULT = '/c/mpsdkAdHandlerResult';
    ULConst.CMD_CREATE_GAME_ICON_RESULT = '/c/createGameIconResult';
    ULConst.CMD_GAME_ICON_HANDLER_RESULT = '/c/gameIconHandlerResult';
    ULConst.CMD_OPEN_CHANNEL_MORE_GAME_BOX_RESULT = '/c/openChannelMoreGameBoxResult';
    ULConst.CMD_OPEN_BLOCK_AD_RESULT = '/c/openBlockAdResult';
    ULConst.CMD_CLOSE_BLOCK_AD_RESULT = '/c/closeBlockAdResult';
    ULConst.CMD_GET_SHORTCUT_STATE_RESULT = '/c/getShortcutStateResult';
    ULConst.CMD_GET_SUBSCRIBE_STATE_RESULT = "/c/getSubscribeStateResult";
    ULConst.CMD_ADD_SUBSCRIBE_RESULT = "/c/addSubscribeResult";
    ULConst.CMD_ADD_COLOR_SIGN_RESULT = '/c/addColorSignResult';
    ULConst.CMD_OPEN_GRID_AD_RESULT = '/c/openGridAdResult';
    ULConst.CMD_CLOSE_GRID_AD_RESULT = '/c/closeGridAdResult';
    ULConst.CMD_JUMP_TO_VIDEO_VIEW_RESULT = '/c/jumpToVideoViewResult';
    ULConst.CMD_FOLLOW_OFFICIAL_ACCOUNT_RESULT = '/c/followOfficialAccountResult';
    ULConst.CMD_GET_FOLLOW_OFFICIAL_ACCOUNT_STATE_RESULT = '/c/getFollowOfficialAccountStateResult';
    ULConst.CMD_CONTENT_SECURITY_CHECK_RESULT = '/c/contentSecurityCheckResult';
    ULConst.CMD_JUMP_LEISURE_SUBJECT_RESULT = '/c/jumpLeisureSubjectResult';
    ULConst.CMD_PHONE_VIBRATE_RESULT = '/c/phoneVibrateResult';
    ULConst.CMD_JUMP_NEW_USER_GUIDE = '/c/jumpNewGuide';
    ULConst.CMD_CHECKDEBUG_WHITEUSER_RESULT = '/c/checkDebugWhiteUserResult';
    ULConst.CMD_OPEN_URL_RESULT = '/c/openUrlResult';
    ULConst.CMD_CLEAN_UP_GAME_ARCHIVE = '/c/cleanUpGameArchive';
    ULConst.CMD_SHOW_POINT_DEBUG_INFO = '/c/showPointDebugInfo';
    ULConst.CMD_CHECK_LAUNCH_REWARD = "/sdk/checkLaunchReward";
    ULConst.CMD_SET_USER_CLOUD_STORAGE_RESULT = '/c/setUserCloudStorageResult';
    ULConst.CMD_GET_USER_CLOUD_STORAGE_RESULT = '/c/getUserCloudStorageResult';
    ULConst.CMD_GET_JOIN_GROUP_NUM_RESULT = "/c/getJoinGroupNumResult";
    ULConst.CMD_JOIN_GROUP_RESULT = "/c/joinGroupResult";
    ULConst.CMD_LAUNCH_REWARD_RESULT = "/c/launchRewardResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_QUERY = "/c/qqNetEarnedQuery";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_RECHARGE = "/c/qqNetEarnedRecharge";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_CASH = "/c/qqNetEarnedCash";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_QUERY_RESULT = "/c/qqNetEarnedQueryResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_RECHARGE_RESULT = "/c/qqNetEarnedRechargeResult";
    ULConst.CMD_MOYANG_QQ_NET_EARNED_CASH_RESULT = "/c/qqNetEarnedCashResult";
    ULConst.CMD_RANKLIST_GET_USER_NUM_RESULT = "/c/getUserNumInRankResult";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_ID_RESULT = "/c/getUserInfoByIdInRankResult";
    ULConst.CMD_RANKLIST_GET_USER_INFO_BY_LIST_RESULT = "/c/getUserInfoListByRankIdResult";
    ULConst.CMD_RANKLIST_REPORT_USER_INFO_RESULT = "/c/reportUserInfoInRankResult";
    ULConst.CMD_RANKLIST_MODIFY_SCORE_BY_ARRAY_RESULT = "/c/modifyScoreByArrayResult";
    ULConst.CMD_GET_OPENDATA_CANVAS_RESULT = '/c/getOpenDataCanvasResult';
    ULConst.CMD_SDK_ON_COP_CHANGED = "/sdk/onCopChanged";
    ULConst.CMD_SDK_PREPARE_SHOW_VIDEO_ADV = "/sdk/prepareShowVideoAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_INTER_ADV = "/sdk/prepareShowInterAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_BANNER_ADV = "/sdk/prepareShowBannerAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_EMBEDDED_ADV = "/sdk/prepareShowEmbeddedAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_URL_ADV = "/sdk/prepareShowUrlAdv";
    ULConst.CMD_SDK_PREPARE_SHOW_PASTER_ADV = "/sdk/prepareShowPasterAdv";
    ULConst.CMD_SDK_SHOW_VIDEO_ADV = "/sdk/showVideoAdv";
    ULConst.CMD_SDK_SHOW_INTER_ADV = "/sdk/showInterAdv";
    ULConst.CMD_SDK_SHOW_BANNER_ADV = "/sdk/showBannerAdv";
    ULConst.CMD_SDK_SHOW_EMBEDDED_ADV = "/sdk/showEmbeddedAdv";
    ULConst.CMD_SDK_SHOW_URL_ADV = "/sdk/showUrlAdv";
    ULConst.CMD_SDK_SHOW_PASTER_ADV = "/sdk/showPasterAdv";
    ULConst.CMD_SDK_CLOSE_VIDEO_ADV = "/sdk/closeVideoAdv";
    ULConst.CMD_SDK_CLOSE_INTER_ADV = "/sdk/closeInterAdv";
    ULConst.CMD_SDK_CLOSE_BANNER_ADV = "/sdk/closeBannerAdv";
    ULConst.CMD_SDK_CLOSE_EMBEDDED_ADV = "/sdk/closeEmbeddedAdv";
    ULConst.CMD_SDK_CLOSE_URL_ADV = "/sdk/closeUrlAdv";
    ULConst.CMD_SDK_CLOSE_Paster_ADV = "/sdk/closePasterAdv";
    ULConst.CMD_SDK_CLOSE_NATIVE_ADV = "/sdk/closeNativeAdv";
    ULConst.CMD_SDK_CLICK_NATIVE_ADV = "/sdk/clickNativeAdv";
    ULConst.CMD_SDK_GET_STORAGE = "/sdk/getStorge";
    ULConst.CMD_SDK_SET_STORAGE = "/sdk/setStorge";
    ULConst.CMD_SDK_GET_CLIPBOARD_DATA = "/sdk/getClipboardData";
    ULConst.CMD_SDK_SET_CLIPBOARD_DATA = "/sdk/setClipboardData";
    ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD = "/sdk/isSupportClipboard";
    ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG = "/sdk/collectionModuleCheckerConfig";
    ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_MORE_GAME_AB_TEST_CONFIG = "/sdk/collectionModuleCheckerMoreGameAbTestConfig";
    ULConst.CMD_SDK_ON_GAME_START = "/sdk/onGameStart";
    ULConst.CMD_SDK_ON_GAME_PAUSE = "/sdk/onGamePause";
    ULConst.CMD_SDK_ON_GAME_RESUME = "/sdk/onGameResume";
    ULConst.CMD_SDK_ON_SHARE_SHOW = "/sdk/onShareShow";
    ULConst.CMD_SDK_ON_SAHRE_APP_MESSAGE = "/sdk/onShareAppMessage";
    ULConst.CMD_SDK_ON_REPORT_ULSDK_EVENT = "/sdk/ulsdkMegadataUpload";
    ULConst.CMD_SDK_OPEN_SHARE_DURING_ADV = "/sdk/openShareDuringAdv";
    ULConst.CMD_SDK_CHANNEL_MEGADATA_POST = "/sdk/channelMegadataPost";
    ULConst.CMD_SDK_SET_UP_WEBVIEW_JAVASCRIPT_BRIDGE = "/sdk/setUpWebViewJavascriptBridge";
    ULConst.CMD_SDK_EXPRESS_NATIVE_ADV_STATUS_CHANGE = "/sdk/expressNativeAdvStatusChange";
    ULConst.CMD_MOYANG_QQ_REWARD_VIDEO_PLAY = "/sdk/moyangQQRewardVideoPlay";
    ULConst.CMD_MOYANG_QQ_REWARD_VIDEO_CLOSE = "/sdk/moyangQQRewardVideoClose";
    ULConst.CMD_FACEBOOK_INIT_COMPLETE = "/sdk/facebookInitComplete";
    ULConst.CMD_WXOCEANENGINE_PAY_SUCCESS = "/sdk/wxOceanEnginePaySuccess";
    ULConst.CMD_HUAWEI_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/HuaweiBuyQuantityPlayVideoAd";
    ULConst.CMD_HUAWEI_BUYQUANTITY_PAY_SUCCESS = "/sdk/HuaweiBuyQuantityPaySuccess";
    ULConst.CMD_WEIXIN_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/weixinBuyQuantityPlayVideoAd";
    ULConst.CMD_WEIXIN_BUYQUANTITY_PAY_SUCCESS = "/sdk/weixinBuyQuantityPaySuccess";
    ULConst.CMD_HEADLINE_BUYQUANTITY_PLAY_VIDEOAD = "/sdk/headlineBuyQuantityPlayVideoAd";
    ULConst.CMD_HEADLINE_BUYQUANTITY_STARTPLAY_VIDEOAD = "/sdk/headlineBuyQuantityStartPlayVideoAd";
    ULConst.CMD_HEADLINE_BUYQUANTITY_PAY_SUCCESS = "/sdk/headlineBuyQuantityPaySuccess";
    ULConst.CMD_SDK_COMMONEVENT_ID_POST = "/sdk/commonEventIdPost";
    ULConst.CMD_SDK_LEVELCOMPLETEEVENT_ID_POST = "/sdk/levelCompleteEventIdPost";
    ULConst.CMD_SDK_INIT_USER_LOGIN = "/sdk/initUserLogin";
    ULConst.CMD_SDK_QM_LOGIN_REPORT = "/qmsdk/loginReport";
    ULConst.CMD_SDK_QM_REPORT_EVENT = "/qmsdk/reportEvent";
    ULConst.CMD_SDK_QM_REPORT_GOLD = "/qmsdk/reportGold";
    ULConst.CMD_SDK_QM_SET_ACCOUNT_INFO = "/qmsdk/setAccountInfo";
    ULConst.CMD_SDK_QM_GET_OPEN_LEVEL = "/qmsdk/getOpenLevel";
    ULConst.CMD_SDK_QM_GET_RECOMMEND_INFO = "/qmsdk/getRecommendInfo";
    ULConst.CMD_SDK_QM_GET_SUGGEST_LIST = "/qmsdk/getSuggestList";
    ULConst.CMD_SDK_QM_GET_EXCITATION_LIST = "/qmsdk/getExcitationList";
    ULConst.CMD_SDK_QM_MPSDK_AD_CLICK = "/qmsdk/mpsdkAdClick";
    ULConst.CMD_SDK_QM_MPSDK_CLICK_SYNC = "/qmsdk/mpsdkClickSync";
    ULConst.CMD_SDK_QM_GET_USER_DATA_VERSION = "/qmsdk/getUserDataVersion";
    ULConst.CMD_SDK_QM_IS_STRONG_FISSION = "/qmsdk/isStrongFission";
    ULConst.CMD_SDK_QM_REPORT_VIDEO_TIME_EVENT = "/qmsdk/reportVideoTimeEvent";
    ULConst.CMD_SDK_OPPOQG_MARK_MANUAL_CLOSE_BANNER_COUNT = "/sdk/oppoqg/markManualCloseBannerCount";
    ULConst.CMD_SDK_OPPOQG_GET_MANUAL_CLOSE_BANNER_COUNT = "/sdk/oppoqg/getManualCloseBannerCount";
    ULConst.CMD_SDK_OPPOQG_HAS_BANNER_SHOWING = "/sdk/oppoqg/hasBannerShowing";
    ULConst.PRIORITY_DISABLE = -2;
    ULConst.PRIORITY_NONE = -1;
    ULConst.CONSOLE_OUTPUT_LEVEL_WARN = 1;
    ULConst.CONSOLE_OUTPUT_LEVEL_ERROR = 1;
    ULConst.CONSOLE_OUTPUT_LEVEL_LOG = 2;
    ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG = 3;
    ULConst.B_INNER_DEBUG = false;
    ULConst.COP_RETRY_TIME_SEC = 30;
    ULConst.STATIS_TYPE_BASE_INFO = "1";
    ULConst.STATIS_TYPE_PAY_INFO = "2";
    ULConst.STATIS_TYPE_ADV_INFO = "3";
    ULConst.STATIS_TYPE_COP_REQUEST = "4";
    ULConst.STATIS_TYPE_USER_EVENT = "5";
    ULConst.STATIS_TYPE_ONLINE_TIME = "6";
    ULConst.STATIS_TYPE_POINT_EVENT = "7";
    ULConst.STATIS_TYPE_COIN_CHANGE_EVENT = "5";
    ULConst.STATIS_TYPE_COMMON_EVENT = "7";
    ULConst.STATIS_TYPE_LEVEL_START_EVENT = "8";
    ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT = "9";
    ULConst.STATIS_TYPE_ITEM_BUY = "10";
    ULConst.STATIS_TYPE_BUY_ACTION = "11";
    ULConst.STATIS_TYPE_VIDEO_POINT_EVENT = "12";
    ULConst.STATIS_TYPE_USER_MESSAGE = "14";
    ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT = 200;
    ULConst.STATIS_USER_EVENT_GAME_LEVEL_START = "gameLevelStart";
    ULConst.STATIS_USER_EVENT_GAME_LEVEL_COMPLETE = "gameLevelComplete";
    ULConst.STATIS_USER_EVENT_GAME_COIN_ADD = "gameCoinAdd";
    ULConst.STATIS_USER_EVENT_GAME_COIN_LOST = "gameCoinLost";
    ULConst.STATIS_USER_EVENT_BUY_ACTION = "buyAction";
    ULConst.STATIS_USER_EVENT_ITEM_BUY = "itemBuy";
    ULConst.STATIS_USER_EVENT_COMMON_EVENT = "commonEvent";
    ULConst.STATIS_USER_EVENT_COMMON_EVENT_MULTI_FIELD = "commonEventMultiField";
    ULConst.STATIS_USER_EVENT_POINT_EVENT = "pointEvent";
    ULConst.STATIS_USER_ACTION_EVENT_LEVEL_START = "levelStart";
    ULConst.STATIS_USER_ACTION_EVENT_LEVEL_COMPLETE = "levelComplete";
    ULConst.STATIS_USER_ACTION_EVENT_COIN_CHANGE = "coinChange";
    ULConst.STATIS_USER_ACTION_EVENT_ITEM_BUY = "itemBuy";
    ULConst.STATIS_USER_ACTION_EVENT_BUY_ACTION = "buyAction";
    ULConst.STATIS_USER_ACTION_EVENT_COMMON_EVENT = "commonEvent";
    ULConst.STATIS_USER_ACTION_EVENT_VIDEO_POINT_EVENT = "videoPointEvent";
    ULConst.STATIS_UPLOAD_SPAN = 60;
    ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT = 100;
    ULConst.ADV_FAIL_TIP_NOAD = "暂时无法播放广告，请稍后再试";
    ULConst.ADV_FAIL_TIP_BUSY = "广告准备中，请稍后再试";
    ULConst.ENGLISH_ADV_FAIL_TIP_NOAD = "Ad display failed, please retry later.";
    ULConst.ENGLISH_ADV_FAIL_TIP_BUSY = "Ad in preparation, please retry later.";
    ULConst.ADV_ERR_CODE_CONSECUTIVE_FAIL = -100;
    ULConst.ADV_ERR_CODE_CDING = -101;
    ULConst.ADV_ERR_CODE_NATIVE_ID_ERROR = -102;
    ULConst.ADV_ERR_CODE_NATIVE_DATA_ERROR = -102;
    ULConst.ADV_ERR_CODE_CAN_NOT_PLAY = -103;
    ULConst.ADV_ERR_CODE_NOT_INITED = -104;
    ULConst.ADV_ERR_CODE_UNKNOWN = -105;
    ULConst.ADV_ERR_CODE_SHARE_NO_CALLBACK = -106;
    ULConst.ADV_ERR_CODE_SHARE_FAIL = -107;
    ULConst.ADV_ERR_CODE_ADOBJ_NULL = -108;
    ULConst.ADV_ERR_CODE_ADV_TYPE_CD = -109;
    ULConst.ADV_ERR_CODE_ADV_TYPE_DAILY_LIMIT = -110;
    ULConst.ADV_PRELOAD_STATE_READY = 1;
    ULConst.ADV_PRELOAD_STATE_LOADING = 2;
    ULConst.ADV_PRELOAD_STATE_NOAD = 3;
    ULConst.ADV_RESULT_CODE_SUCCESS = 1;
    ULConst.ADV_RESULT_CODE_FAILED = 0;
    ULConst.ADV_RESULT_CODE_OBSOLETE = 2;
    ULConst.ADV_MUST_DEFAULT_WEIGHT = 100;
    ULConst.ADV_RANDOM_DEFAULT_WEIGHT = 1;
    ULConst.ADV_DISABLE_DEFAULT_WEIGHT = 0;
    ULConst.ADV_RESULT_MSG_FAILED = "哎呀,广告走丢啦";
    ULConst.ADV_RESULT_MSG_SUCCESS = "show adv success";
    ULConst.ADV_NATIVE_RESULT_MSG_SUCCESS = "load native data success";
    ULConst.ADV_NATIVE_RESULT_MSG_FAIL = "load native data fail";
    ULConst.ADV_VIDEO_PLAY_FAIL_MSG = "广告提前关闭,无法获得奖励";
    ULConst.ADV_RESULT_MSG_CLICK = "click adv";
    ULConst.ADV_RESULT_MSG_CLOSE = "close adv";
    ULConst.ADV_NATIVE_OBSOLETE_MSG = "广告数据作废";
    ULConst.EXP_ADV_TYPE_CONST = "atype";
    ULConst.EXP_ADV_TEMPLATE_CONST = "tid";
    ULConst.EXP_ADV_POINT_CONST = ".";
    ULConst.UL_EVENT_ONREQUEST = "onRequest";
    ULConst.UL_EVENT_SHOW_PRIVACY_POLICY = "showPrivacyPolicy";
    ULConst.UL_EVENT_SHOW_PRIVACY_POLICY_WAIT = "showPrivacyPolicyWait";
    ULConst.CMD_GET_ADV_STATE_RESULT = "/c/getAdvStateResult";
    ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE_RESULT = "/c/closeAllAdvByTypeResult";
    ULConst.CMD_JUMP_NEW_GUIDE = "/c/jumpNewGuide";
    ULConst.CMD_GET_ADV_STATE = "/c/getAdvState";
    ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE = "/c/closeAllAdvByType";
    ULConst.CMD_REWARD_ADV_RESULT = "/c/rewardAdvResult";
    ULConst.UL_ADV_DEFAULT_TIMEOUT_TIME = 30000;
    ULConst.DEFAULT_TITLE = "广告";
    ULConst.DEFAULT_DESC = "哇!这个实在太棒啦!";
    ULConst.DEFAULT_TARGET_TITLE = "查看广告";
    ULConst.MIN_NATIVE_RESPONSE_CACHE_TIMEOUT = 0;
    ULConst.MAX_NATIVE_RESPONSE_CACHE_TIMEOUT = 30 * 1000;
    ULConst.DEFAULT_NATIVE_RESPONSE_CACHE_TIMEOUT = 15 * 1000;
    ULConst.ADV_LOAD_TYPE_PRELOAD = 1;
    ULConst.ADV_LOAD_TYPE_UNPRELOAD = 0;

    class ULEventDispatcher {
        constructor() {
            this.allListeners = {};
        }
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULEventDispatcher();
            }
            return this._instance;
        }
        addListener(type, priority, callback) {
            return this._addListener(type, priority, callback, false);
        }
        once(type, priority, callback) {
            return this._addListener(type, priority, callback, true);
        }
        _addListener(type, priority, callback, bDispatchOnce) {
            if (priority < ULConst.PRIORITY_NONE) {
                this.removeListenerByCallback(type, callback);
                return;
            }
            ;
            let listeners = this.allListeners[type];
            if (!listeners) {
                listeners = [];
                this.allListeners[type] = listeners;
            }
            let insertIndex = -1;
            for (let i = 0; i < listeners.length; i++) {
                let listener = listeners[i];
                if (listener.callback == callback) {
                    ULLog.console.warn("ULEventDispatcher._addListener callback already exists:", type);
                    return false;
                }
                if (insertIndex == -1 && listener.priority < priority) {
                    insertIndex = i;
                }
            }
            let listener = new ULEventListener(type, priority, callback, bDispatchOnce);
            if (insertIndex != -1) {
                listeners.splice(insertIndex, 0, listener);
            }
            else {
                listeners.push(listener);
            }
            return true;
        }
        removeListenerByCallback(type, callback) {
            let listeners = this.allListeners[type];
            if (!listeners)
                return;
            for (let i = listeners.length - 1; i >= 0; i--) {
                let listener = listeners[i];
                if (listener.callback == callback) {
                    listeners.splice(i, 1);
                }
            }
        }
        removeListenersByType(type) {
            delete this.allListeners[type];
        }
        dispatch(type, data) {
            let event = null;
            if (type instanceof ULEvent) {
                event = type;
            }
            else {
                event = new ULEvent(type, data);
            }
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULEventDispatcher.dispatch", event.type, event.data);
            let ret = this._inner_dispatch(event);
            return ret.bCalled;
        }
        dispatchWithReturn(type, data) {
            let event = null;
            if (type instanceof ULEvent) {
                event = type;
            }
            else {
                event = new ULEvent(type, data);
            }
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULEventDispatcher.dispatchWithReturn", event.type, event.data);
            let ret = this._inner_dispatch(event);
            return ret.returnValue;
        }
        _inner_dispatch(event) {
            let bCalled = false;
            let listeners = this.allListeners[event.type];
            if (!listeners) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("  listeners not found");
                return { bCalled: false, returnValue: null };
            }
            for (let i = 0; i < listeners.length; i++) {
                const listener = listeners[i];
                if (listener.isNeedRemove())
                    continue;
                if (listener.isDispatchOnce()) {
                    listener.markNeedRemove();
                }
                if (listener.triggerCallback(event)) {
                    bCalled = true;
                }
                if (event.isPropagationStoped()) {
                    break;
                }
            }
            for (let i = listeners.length - 1; i >= 0; i--) {
                let listener = listeners[i];
                if (listener.isNeedRemove()) {
                    listeners.splice(i, 1);
                }
            }
            return { bCalled: bCalled, returnValue: event.getReturnValue() };
        }
    }
    ULEventDispatcher._instance = null;

    var cConfig = JSON.parse(`{
    "a_prj_upload_res_dirs": [
        
    ],
    "b_sdk_oppoqg_debug": false,
    "creatorVersion": "",
    "i_channel_info_timeout": 3000,
    "i_game_start_ready_timeout": 10000,
    "i_net_timeout": 5000,
    "i_prj_b2b_mode": 0,
    "i_sdk_adv_banner_cd": 0,
    "i_sdk_adv_banner_timeout": 30000,
    "i_sdk_adv_banner_valid_show_count": 2,
    "i_sdk_adv_custom_valid_show_count": 2,
    "i_sdk_adv_embedded_timeout": 30000,
    "i_sdk_adv_inter_cd": 0,
    "i_sdk_adv_inter_timeout": 30000,
    "i_sdk_adv_native_clicked_report_mode": 0,
    "i_sdk_adv_native_exposure_cd": 0,
    "i_sdk_adv_native_life_time": 15000,
    "i_sdk_adv_native_request_cd": 10000,
    "i_sdk_adv_paster_timeout": 30000,
    "i_sdk_adv_type_banner_cd": 0,
    "i_sdk_adv_type_banner_daily_limit": 0,
    "i_sdk_adv_type_embedded_cd": 0,
    "i_sdk_adv_type_embedded_daily_limit": 0,
    "i_sdk_adv_type_interstitial_cd": 0,
    "i_sdk_adv_type_interstitial_daily_limit": 0,
    "i_sdk_adv_type_paster_cd": 0,
    "i_sdk_adv_type_paster_daily_limit": 0,
    "i_sdk_adv_type_url_cd": 0,
    "i_sdk_adv_type_url_daily_limit": 0,
    "i_sdk_adv_type_video_cd": 0,
    "i_sdk_adv_type_video_daily_limit": 0,
    "i_sdk_adv_url_timeout": 30000,
    "i_sdk_adv_video_timeout": 30000,
    "i_sdk_age_level_info_mode": 1,
    "i_sdk_banner_autoRefresh_mode": 0,
    "i_sdk_banner_refresh_intervals": 30,
    "i_sdk_channel_user_id_mode": 0,
    "i_sdk_common_checktime_deferenceLimit": 300000,
    "i_sdk_compress_res_mode": 1,
    "i_sdk_content_security_check_support": 1,
    "i_sdk_custom_autoRefresh_mode": 0,
    "i_sdk_custom_refresh_intervals": 30,
    "i_sdk_debug_mode": 0,
    "i_sdk_debug_task_mode": 0,
    "i_sdk_find_mini_game_mode": 1,
    "i_sdk_installShortcut_mode": 1,
    "i_sdk_joinGroup_mode": 1,
    "i_sdk_jump_game_resource_mode": 0,
    "i_sdk_jump_single_random_length": 5,
    "i_sdk_jumplist_mode": 1,
    "i_sdk_megadata_encrypt": 1,
    "i_sdk_megadata_mode": 1,
    "i_sdk_megadata_upload_span": 5000,
    "i_sdk_moreWonderful_mode": 0,
    "i_sdk_moregame_mode": 1,
    "i_sdk_native_autoRefresh_intervals": 30,
    "i_sdk_native_autoRefresh_mode": 0,
    "i_sdk_native_valid_show_count": 2,
    "i_sdk_oppoqg_ad_ecd": 0,
    "i_sdk_oppoqg_banner_mode": 0,
    "i_sdk_oppoqg_jump_game_reward_time": 20000,
    "i_sdk_oppoqg_not_show_banner_after_user_close_count_limit": 5,
    "i_sdk_pay_mode": 0,
    "i_sdk_phone_vibrate": 0,
    "i_sdk_sdk_rank_mode": 0,
    "i_sdk_share_mode": 0,
    "i_sdk_subscribe_mode": 1,
    "i_sdk_support_open_url": 0,
    "i_sdk_support_record_share": 1,
    "i_sdk_trim_adv_err_switch": 1,
    "layaVersion": "2.8",
    "n_sdk_adv_video_complete_mode": 1,
    "n_sdk_common_online_time_report_looper_interval": 60,
    "nodejsExePath": "nodejs16.15.1/node.exe",
    "nodejsGitAddr": "ude2/prj.ulnodejs",
    "nodejsGitBranch": "v1",
    "resProcessScriptPath": "",
    "s_game_name": "魔力火线联盟‎",
    "s_game_orientation": "portrait",
    "s_prj_name": "prj.game166",
    "s_sdk_adv_info": {
        "1": {
            "group": [
                "1"
            ],
            "type": "interstitial"
        },
        "2": {
            "group": [
                "2"
            ],
            "type": "banner"
        },
        "3": {
            "group": [
                "3"
            ],
            "type": "embedded"
        },
        "4": {
            "group": [
                "4"
            ],
            "type": "video"
        },
        "5": {
            "group": [
                "5"
            ],
            "type": "url"
        }
    },
    "s_sdk_age_level_info": "游戏中有实名认证系统，认证为未成年人的用户将接受以下管理：未满8周岁的用户不能充值；8周岁以上未满16周岁的未成年人用户，单次充值金额不得超过50元人民币，每月充值金额累计不得超过200元人民币；16周岁以上的未成年人用户，单次充值金额不得超过100元人民币，每月充值金额累计不得超过400元人民币。未成年人用户可以在周五、周六、周日和法定节假日每日晚20时至21时期间登录游戏，其他时间内无法登录游戏。",
    "s_sdk_cdk_app_id": "99",
    "s_sdk_cdk_url": "https://cdkey.ultralisk.cn/commoncdk/usecdk",
    "s_sdk_common_affiche_title": "最新公告",
    "s_sdk_common_affiche_url": "",
    "s_sdk_common_checktime_url": "https://copv7.ultralisk.cn/getservertime",
    "s_sdk_common_copyright_str": "QEBAXiAgICBdXV1dXV1dXV1dXSAgICAgLkBAQF4gICAgXV1dXV1dXV1dXSAgID1AQEAuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQF4gICAgQEBAQEBAQEBAQEAgPUBAQEBAQEBAQEBAXkBAQEBAQEBAQEAgLi9AQEBAQEBAQEBAXkBAQEBAQEBAQF4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgID1AQEBAQEBAQEBAXkBAQF4gICA9QEBAICAgICAuQEBAXiAgICBAQEBeICA9QEBAICAsQGAgPUBAQCAgICBAQEBeICA9QEBeICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAsQEBAQEBAQEBAQGBAQEBcXV1dL0BAQCAgQEBAQEBAQEBAQEAgQEBAXF1dL0BAQCA9QEBAQEBAQEBAQEBAQEBAXiAgPUBAXiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQF4gICAgQEBAQEBAQEBAQEAgIEBAQF4gICA9QEBAIEBAQEBAQEBAQEAgICAgLEBAQEBAQEBgIEBAQEBAQEBAQF4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAQEBAQEBeIEBAQF4gICA9QEBAICBAQEBAQEBAQEBAQCBAQEBeICA9QEBAID1AQEBAQGAgLlxALy4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQEBAQEBAXi5AQEBcXV1dL0BAQCAgQEBAXF1dXS9AQEAgQEBAXF1dL0BAQCAgLltAQEBAQEBAQEBAQEBAQEBAQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQCogID1AQF49QEBAQEBAQEBAQEAgIEBAQEBAQEBAQEBALkBAQEBAQEBAQEAgICAuQEBAXiAgICAgICAgICA9QEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEAqICA9QEBePUBAQCAgICA9QEBAICxdXV1dQEBAXF1dXT1AQEAqICA9QEBAICAgLkBAQEBAQEBAQEBAQEBAQEBAQCogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQEBAQEBAXEBAQF4gICAuQEBALyA9QEBAQEBAQEBAQEBAQEAvICAgL0BAQCAgIC5AQEBeICAgICAgICAgID1AQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQCogICAgPUBAQC8gXEBAQEBAQF4gICAgIC5AQEBeICxAQEBAIFxAQEBAQC8gICAuQEBAQEBAQEBAQEBAQEBAQEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAuXF4gICxbW1tbYCAgICAgICAuXEBAYCAgICxbICAuW1tbYCAgICAgLkBAQGAgICAgICAgICAgLEBAQCogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICANCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgDQogICAgICAgLl1dXWAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLF1dXS4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAsXV1dLiAgICAgICAgICAgICwgICAgICAgICAgICAgIA0KICAgICAgID1AQEBeICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQEAqICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQEBAQCogICAgICAgICAgL0BAQEAgICAgICAgICAgICANCiAgICAgICA9QEBAXiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBAQEAqICAgICAgICAgIC5cQC9gICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICxdXSAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICxdXV0qICAgQEBAQCogLl1dYCAgICAgICAgLl1dXWAgICAgICAgICAgIF1dXV0gICAgICAgICAgICAgICAgICAgICAgICAgICBAQEBAKiAuXV1gICAgICAgICAgICAgICAgICAgICAgIA0KICAgICAgID1AQEBcQEBAQEBAQGAgIC5AQEBAICAgID1AQEBeICAgICAgICAgICxAQEBAQEBAQF4gIEBAQEAvQEBAQEBAXCAgIC5AQEBAQEBAQEBeICAgICxAQEBAQEBAQEBAYCAgICAgICAgIC5AQEBAQEBAQEBAQCAgQEBAQC9AQEBAQEBcICAgPUBAQF4gICAgICAgICAgICANCiAgICAgICA9QEBAQGAgID1AQEBALiAuQEBAQCAgICA9QEBAXiAgICAgICAgID1AQEBAYCAgICxgICBAQEBALy4gLkBAQEBeICAuWy4gICAgXEBAQF4gIC9AQEAvYCAgLEBAQEBeICAgICAgICAgICAgICAvQEBALyAgIEBAQEAvLiAuQEBAQF4gID1AQEBeICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICAgQEBAQCogLkBAQEAgICAgPUBAQF4gICAgICAgIC5AQEBALiAgICAgICAgQEBAQCogICA9QEBAXiAgICxdQEBAQEBAQEBeIC5AQEBALiAgICAsQEBAQCAgICAgICAgICAgICxAQEBAYCAgICBAQEBAKiAgID1AQEBeICA9QEBAXiAgICAgICAgICAgIA0KICAgICAgID1AQEBeICAgIEBAQEAqIC5AQEBAICAgID1AQEBeICAgICAgICAuQEBAQC4gICAgICAgIEBAQEAqICAgPUBAQF4gLkBAQEBbYCA9QEBAXiAuQEBAQC4gICAgPUBAQEAgICAgICAgICAgIC9AQEAvICAgICAgQEBAQCogICA9QEBAXiAgPUBAQF4gICAgICAgICAgICANCiAgICAgICA9QEBAXiAgICBAQEBAKiAuQEBAQF4gICxAQEBAXiAgICAgICAgIFxAQEBAYCAgICxgICBAQEBAKiAgID1AQEBeID1AQEBeICAuQEBAQF4gIFxAQEBcLiAgLEBAQEBeICAgICAgICAgLEBAQEBgICAgICAgIEBAQEAqICAgXEBAQF4gID1AQEBeICAgICAgICAgICAgDQogICAgICAgPUBAQF4gICAgQEBAQCogICxAQEBAQEBAXEBAQF4gICAgICAgICAgLEBAQEBAQEBAXiAgQEBAQCogICA9QEBAXiAgQEBAQEBAQEBAQEBeICAgLEBAQEBAQEBAQEBgICAgICAgICAgL0BAQEBAQEBAQEBAICBAQEBAKiAgID1AQEBeICA9QEBAXiAgICAgICAgICAgIA0KICAgICAgICAgICAgICAgICAgICAgICAgIC5bW1sgICAgICAgICAgICAgICAgICAgIC5bW1tbICAgICAgICAgICAgICAgICAgICAgLFtbKiAgICAgICAgICAgIC5bW1tbDQo=",
    "s_sdk_common_login_url": "https://sdkserver.ultralisk.cn/userlogin",
    "s_sdk_common_online_pay_url": "https://sdkpay.ultralisk.cn",
    "s_sdk_cop_addr": "https://copv7.ultralisk.cn/h5/getdata/",
    "s_sdk_cop_game_id": "119",
    "s_sdk_jump_game_statis_game_indexes": "",
    "s_sdk_lan_debug_address": "",
    "s_sdk_megadata_close_table_type_ids": "",
    "s_sdk_megadata_game_id": "368",
    "s_sdk_megadata_server_jump_game_type_id": "jumpabtest",
    "s_sdk_megadata_server_type_id": "368",
    "s_sdk_megadata_test_url": "https://megadatav7.ultralisk.cn/batchtestmodedataupload",
    "s_sdk_megadata_url": "https://megadatav7.ultralisk.cn/batchdataupload",
    "s_sdk_oppoqg_app_key": "C96a5e0EnDkC4Wc440k888Wss",
    "s_sdk_oppoqg_appid": "30831905",
    "s_sdk_oppoqg_appsecret": "4B57A7b74aB8054C72C06a1D2873A6Ac",
    "s_sdk_oppoqg_minPlatform_version": "1056",
    "s_sdk_oppoqg_package_name": "com.ultralisk.game166.nearme.gamecenter",
    "s_sdk_oppoqg_preOrder_online_url": "http://sdkpay.ultralisk.cn/preorder",
    "s_sdk_oppoqg_pre_order_url": "https://jits.open.oppomobile.com/jitsopen/api/pay/v1.0/preOrder",
    "s_sdk_oppoqg_private_key": "-----BEGIN RSA PRIVATE KEY-----MIICXgIBAAKBgQC46Giy1S4Zuys/c3QO6VZVWAOo1tussbIpqI0M7edU9OC732leFej2DmG3O9XRh9NlYjoAq4hyt7DxiZ6MyN8IdStZn4b0/e/CZKQA5WaCI5h71hUTwCJTzHZHvO+woDWaE2mOSsBfjAdwTsHUr32eCPzju/1zatys02W7ai4v+wIDAQABAoGAGjbAmRHF3ln9kJpCitajqae3pRkIvZvXgTZnAL09fXrV3WyX2IHMrA1v5vUxo+nYm1foly26Q2EtUaDL/HOBwshbwEtR5TR0g+kZBpA+S4wt/ujZPlALmZiGuQjjqwWFo9OfeskXer7vA5UWYemDMvy7XQ2TWoLNOzI+LaVvEPECQQDpEgY7XmrKeq8qkUFPsDjcEa7SZ2eEEOps0NKmewGvAaiavm7+8yCdS/ZPS7ZD6590TanFWy3gJtugw/vPa2tpAkEAyxlj8u+EYKchPBYehuRjm4W5SlJNAGrABqrJjM50jQ4aRVr1LbS6R0S77kTaZLTV/w8eYk1LS9cTCaY+JB+HwwJBAIXrlmscmG4ZynbCGe4JCtLg0jwRsHhBJAI8hx2jxlbhtBieXbbeypm3YSM1FNi4FdpFGczN1HFcwowAsLsBNSkCQQC9YgywQKYI1m+ILvwCPr+fCt/PrNS+mcw7q0/Lq8xEp6zZlUpgd1DoGfC/6pZXJ8UQVFG5ymd27bOD4O+7EWevAkEAzYHfclV/kP3V1aCR0KoXBHA4WIHKa+JaVuFMIDZqd/SsfsoKDn+Stsajl/e8LAwt9XXctYWNvGsVfCSfZ5Y3tw==-----END RSA PRIVATE KEY-----",
    "s_sdk_oppoqg_tiny_package_server": "https://gamesres.ultralisk.cn/h5_games_res/game166/oppoqg/v1",
    "s_sdk_oppoqg_version_code": "127",
    "s_sdk_oppoqg_version_name": "1.0.27",
    "s_sdk_user_data_get_url": "https://h5gameserver.ultralisk.cn/getuserdata",
    "s_sdk_user_data_save_url": "https://h5gameserver.ultralisk.cn/savealluserdata",
    "s_sdk_version": "f6e824b5e",
    "srcRootPath": "src/script/",
    "t_customer_service_info": [
        "kefu@ultralisk.cn"
    ],
    "t_sdk_adv_banner_tags_style_setting": {
        
    },
    "t_sdk_adv_custom_args_style_setting": {
        
    },
    "t_sdk_common_event_ids": {
        "add_subscrible": "102",
        "click_more_game_channel_system_button": "108",
        "click_more_game_icon_list": "106",
        "click_more_game_icon_reward": "105",
        "click_more_game_icon_single": "104",
        "click_share": "101",
        "click_subscrible": "103",
        "open_cdk": "107",
        "open_share": "100"
    },
    "t_sdk_common_modify_tag_afterBuild": [
        
    ],
    "t_sdk_common_modify_tag_beforeBuild": [
        
    ],
    "t_sdk_compress_json_includes": [
        
    ],
    "t_sdk_compress_json_includes_rem": "",
    "t_sdk_compress_res_config": [
        {
            "cmds": "",
            "rep": ".*fgui///.*"
        },
        {
            "cmds": "jpeg-recompress --strip -t 0.4 --min 80 | guetzil --quality 85",
            "rep": ".*//.jpg"
        },
        {
            "cmds": "autopng --quality 40-80 | optipng -strip all -o7 | zopflipng -y --lossy_8bit --lossy_transparent",
            "rep": ".*//.png"
        }
    ],
    "t_sdk_cop_default_cop": {
        "is_sdk_start_game_by_touch": "1"
    },
    "t_sdk_cop_simulate_city_data": {
        "0": "未知城市",
        "1001": "海南藏族自治州",
        "1002": "西宁",
        "1003": "海东",
        "1004": "黄南藏族自治州",
        "1005": "海西蒙古族藏族自治州",
        "1006": "海北藏族自治州",
        "1007": "果洛藏族自治州",
        "1008": "玉树藏族自治州",
        "101": "北京",
        "1101": "临夏回族自治州",
        "1102": "甘南藏族自治州",
        "1103": "白银",
        "1104": "陇南",
        "1105": "定西",
        "1106": "平凉",
        "1107": "金昌",
        "1108": "酒泉",
        "1109": "张掖",
        "1110": "庆阳",
        "1111": "兰州",
        "1112": "武威",
        "1113": "嘉峪关",
        "1114": "天水",
        "1201": "银川",
        "1202": "固原",
        "1203": "吴忠",
        "1204": "中卫",
        "1205": "石嘴山",
        "1301": "商洛",
        "1302": "安康",
        "1303": "榆林",
        "1304": "铜川",
        "1305": "咸阳",
        "1306": "西安",
        "1307": "渭南",
        "1308": "汉中",
        "1309": "宝鸡",
        "1310": "延安",
        "1401": "长春",
        "1402": "白城",
        "1403": "松原",
        "1404": "白山",
        "1405": "吉林",
        "1406": "延边朝鲜族自治州",
        "1407": "四平",
        "1408": "辽源",
        "1409": "通化",
        "1501": "铜陵",
        "1502": "亳州",
        "1503": "黄山",
        "1504": "池州",
        "1505": "合肥",
        "1506": "淮北",
        "1507": "滁州",
        "1508": "宿州",
        "1509": "淮南",
        "1510": "蚌埠",
        "1511": "六安",
        "1512": "阜阳",
        "1513": "芜湖",
        "1514": "宣城",
        "1515": "安庆",
        "1516": "马鞍山",
        "1601": "恩施土家族苗族自治州",
        "1602": "仙桃",
        "1603": "武汉",
        "1604": "孝感",
        "1605": "咸宁",
        "1606": "十堰",
        "1607": "天门",
        "1608": "黄冈",
        "1609": "宜昌",
        "1610": "襄阳",
        "1611": "黄石",
        "1612": "荆门",
        "1613": "随州",
        "1614": "荆州",
        "1615": "鄂州",
        "1616": "神农架林区",
        "1617": "潜江",
        "1701": "株洲",
        "1702": "邵阳",
        "1703": "岳阳",
        "1704": "张家界",
        "1705": "怀化",
        "1706": "衡阳",
        "1707": "长沙",
        "1708": "常德",
        "1709": "郴州",
        "1710": "永州",
        "1711": "湘西土家族苗族自治州",
        "1712": "湘潭",
        "1713": "益阳",
        "1714": "娄底",
        "1801": "安顺",
        "1802": "黔南布依族苗族自治州",
        "1803": "铜仁",
        "1804": "六盘水",
        "1805": "贵阳",
        "1806": "黔东南苗族侗族自治州",
        "1807": "毕节",
        "1808": "遵义",
        "1809": "黔西南布依族苗族自治州",
        "1901": "太原",
        "1902": "长治",
        "1903": "运城",
        "1904": "晋中",
        "1905": "忻州",
        "1906": "朔州",
        "1907": "晋城",
        "1908": "阳泉",
        "1909": "大同",
        "1910": "临汾",
        "1911": "吕梁",
        "2001": "来宾",
        "2002": "柳州",
        "2003": "崇左",
        "2004": "百色",
        "2005": "河池",
        "2006": "防城港",
        "2007": "贺州",
        "2008": "贵港",
        "2009": "北海",
        "201": "上海",
        "2010": "南宁",
        "2011": "桂林",
        "2012": "玉林",
        "2013": "钦州",
        "2014": "梧州",
        "2101": "凉山彝族自治州",
        "2102": "攀枝花",
        "2103": "乐山",
        "2104": "遂宁",
        "2105": "资阳",
        "2106": "绵阳",
        "2107": "自贡",
        "2108": "德阳",
        "2109": "雅安",
        "2110": "达州",
        "2111": "广元",
        "2112": "广安",
        "2113": "阿坝藏族羌族自治州",
        "2114": "甘孜藏族自治州",
        "2115": "成都",
        "2116": "南充",
        "2117": "泸州",
        "2118": "内江",
        "2119": "宜宾",
        "2120": "巴中",
        "2121": "眉山",
        "2201": "郑州",
        "2202": "三门峡",
        "2203": "洛阳",
        "2204": "开封",
        "2205": "信阳",
        "2206": "焦作",
        "2207": "许昌",
        "2208": "濮阳",
        "2209": "济源",
        "2210": "鹤壁",
        "2211": "安阳",
        "2212": "驻马店",
        "2213": "新乡",
        "2214": "南阳",
        "2215": "漯河",
        "2216": "平顶山",
        "2217": "商丘",
        "2218": "周口",
        "2301": "石家庄",
        "2302": "保定",
        "2303": "沧州",
        "2304": "衡水",
        "2305": "唐山",
        "2306": "邯郸",
        "2307": "廊坊",
        "2308": "秦皇岛",
        "2309": "邢台",
        "2310": "张家口",
        "2311": "承德",
        "2401": "福州",
        "2402": "厦门",
        "2403": "宁德",
        "2404": "莆田",
        "2405": "龙岩",
        "2406": "三明",
        "2407": "南平",
        "2408": "泉州",
        "2409": "漳州",
        "2501": "南昌",
        "2502": "上饶",
        "2503": "赣州",
        "2504": "新余",
        "2505": "鹰潭",
        "2506": "抚州",
        "2507": "萍乡",
        "2508": "宜春",
        "2509": "景德镇",
        "2510": "吉安",
        "2511": "九江",
        "2601": "珠海",
        "2602": "东莞",
        "2603": "江门",
        "2604": "阳江",
        "2605": "惠州",
        "2606": "汕尾",
        "2607": "梅州",
        "2608": "清远",
        "2609": "湛江",
        "2610": "揭阳",
        "2611": "广州",
        "2612": "云浮",
        "2613": "潮州",
        "2614": "汕头",
        "2615": "韶关",
        "2616": "深圳",
        "2617": "佛山",
        "2618": "中山",
        "2619": "肇庆",
        "2620": "茂名",
        "2621": "河源",
        "2701": "呼和浩特",
        "2702": "锡林郭勒盟",
        "2703": "乌兰察布",
        "2704": "通辽",
        "2705": "包头",
        "2706": "阿拉善盟",
        "2707": "巴彦淖尔",
        "2708": "兴安盟",
        "2709": "鄂尔多斯",
        "2710": "乌海",
        "2711": "呼伦贝尔",
        "2712": "赤峰",
        "2801": "鹤岗",
        "2802": "鸡西",
        "2803": "哈尔滨",
        "2804": "黑河",
        "2805": "七台河",
        "2806": "伊春",
        "2807": "大兴安岭地区",
        "2808": "牡丹江",
        "2809": "绥化",
        "2810": "齐齐哈尔",
        "2811": "双鸭山",
        "2812": "大庆",
        "2813": "佳木斯",
        "2901": "葫芦岛",
        "2902": "营口",
        "2903": "丹东",
        "2904": "沈阳",
        "2905": "抚顺",
        "2906": "辽阳",
        "2907": "大连",
        "2908": "鞍山",
        "2909": "盘锦",
        "2910": "阜新",
        "2911": "本溪",
        "2912": "锦州",
        "2913": "铁岭",
        "2914": "朝阳",
        "3001": "淄博",
        "3002": "临沂",
        "3003": "威海",
        "3004": "莱芜",
        "3005": "日照",
        "3006": "济南",
        "3007": "泰安",
        "3008": "烟台",
        "3009": "聊城",
        "301": "天津",
        "3010": "东营",
        "3011": "菏泽",
        "3012": "滨州",
        "3013": "潍坊",
        "3014": "德州",
        "3015": "青岛",
        "3016": "济宁",
        "3017": "枣庄",
        "3101": "南京",
        "3102": "常州",
        "3103": "苏州",
        "3104": "无锡",
        "3105": "盐城",
        "3106": "镇江",
        "3107": "连云港",
        "3108": "宿迁",
        "3109": "南通",
        "3110": "徐州",
        "3111": "淮安",
        "3112": "扬州",
        "3113": "泰州",
        "401": "重庆",
        "501": "宁波",
        "502": "金华",
        "503": "嘉兴",
        "504": "绍兴",
        "505": "湖州",
        "506": "衢州",
        "507": "舟山",
        "508": "杭州",
        "509": "温州",
        "510": "丽水",
        "511": "台州",
        "601": "儋州",
        "602": "定安县",
        "603": "东方",
        "604": "五指山",
        "605": "屯昌县",
        "606": "琼海",
        "607": "澄迈县",
        "608": "琼中黎族苗族自治县",
        "609": "三亚",
        "610": "白沙黎族自治县",
        "611": "文昌",
        "612": "陵水黎族自治县",
        "613": "昌江黎族自治县",
        "614": "保亭黎族苗族自治县",
        "615": "临高县",
        "616": "海口",
        "617": "万宁",
        "618": "乐东黎族自治县",
        "701": "迪庆藏族自治州",
        "702": "西双版纳傣族自治州",
        "703": "临沧",
        "704": "保山",
        "705": "玉溪",
        "706": "德宏傣族景颇族自治州",
        "707": "红河哈尼族彝族自治州",
        "708": "大理白族自治州",
        "709": "丽江",
        "710": "怒江傈僳族自治州",
        "711": "普洱",
        "712": "楚雄彝族自治州",
        "713": "文山壮族苗族自治州",
        "714": "昆明",
        "715": "曲靖",
        "716": "昭通",
        "801": "拉萨",
        "802": "昌都",
        "803": "山南",
        "804": "阿里地区",
        "805": "林芝",
        "806": "日喀则",
        "807": "那曲地区",
        "901": "喀什地区",
        "902": "阿克苏地区",
        "903": "和田地区",
        "904": "哈密",
        "905": "石河子",
        "906": "吐鲁番",
        "907": "博尔塔拉蒙古自治州",
        "908": "巴音郭楞蒙古自治州",
        "909": "昌吉回族自治州",
        "910": "塔城地区",
        "911": "克孜勒苏柯尔克孜自治州",
        "912": "阿勒泰地区",
        "913": "乌鲁木齐",
        "914": "克拉玛依",
        "915": "伊犁哈萨克自治州"
    },
    "t_sdk_cop_strategy_setting": {
        
    },
    "t_sdk_exempt_advType_limit_arrays": [
        
    ],
    "t_sdk_mutuallyExclusive_advType_setting": {
        
    },
    "t_sdk_oppoqg_adv_tag_2_native_index": {
        
    },
    "t_sdk_oppoqg_custom_adv_setting": {
        
    },
    "t_sdk_oppoqg_jump_games": [
        
    ],
    "t_sdk_oppoqg_native_index_2_native_id": {
        
    },
    "t_sdk_oppoqg_pay_code": {
        
    },
    "t_sdk_oppoqg_show_banner_box_adv_tags": [
        
    ],
    "t_sdk_oppoqg_show_drawer_box_adv_tags": {
        
    },
    "t_sdk_oppoqg_show_inter_box_adv_tags": [
        
    ],
    "t_sdk_privacyPolicy_dataArray": [
        {
            "name": "隐私政策",
            "url": "https://gamesres.ultralisk.cn/notice/policy/oppoyiguopolicy.json"
        }
    ],
    "t_sdk_record_duration_limit_object": {
        "*": {
            "max": 300,
            "min": 3
        },
        "2": {
            "max": 300,
            "min": 15
        }
    },
    "t_sdk_show_native_banner_autoRefresh_tags": [
        
    ],
    "t_sdk_show_native_banner_autoRefresh_tags_style_setting": {
        
    },
    "t_sdk_trim_adv_err_object": {
        "*": "广告播放失败了，重新试试看吧！",
        "baidu": {
            "code": {
                "3010003": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                "3010005||3010006": "正在为您播放广告，请稍等一会儿，不要重复点击。"
            }
        },
        "headline||weixin||qq": {
            "code": {
                "1004": "暂时没有适合您观看的广告，请稍等一会儿再试吧！"
            }
        },
        "oppoqg": {
            "(this.code==1001 || this.code == 1004)&&msg": {
                "/10001/||/10100/||/10101/||/10403/": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                "/10405/": "您的操作系统版本太低，不能播放广告。",
                "/10406/": "需要连接到 Wifi 网络",
                "/11002/": "这个广告只能在OPPO手机上播放，请确认您的机型。",
                "/11003/": "暂时无法播放广告，请稍等一会儿再试吧1！"
            }
        },
        "vivo": {
            "code": {
                "-100||101||500": "您的网络好像不够流畅，请更换到良好的网络环境再播放广告。",
                "-3||108||30005": "暂时无法播放广告，请稍等一会儿再试吧！",
                "30007": "暂时无法播放广告，请稍等一会儿再试吧！",
                "30010": "广告播放失败了，可能是是由于您经常关闭广告造成的，稍等一会儿再试吧。"
            }
        }
    },
    "targetCreatorBranch": "",
    "targetCreatorExePath": "",
    "targetCreatorGitAddr": "",
    "targetCreatorToolGitAddr": "ude2/prj.ulcocoscreator_tools3.x",
    "targetCreatorToolGitBranch": "v2",
    "targetProjectBranch": "v1_h5_release",
    "targetProjectGitAddr": "ude2/prj.game166",
    "targetProjectPath": "",
    "tempCreatorProjectPaths": [
        [
            ".laya/",
            ".laya/"
        ],
        [
            "bin/",
            "bin/",
            [
                "**/vconsole.*"
            ]
        ],
        [
            "declare/",
            "declare/"
        ],
        [
            "laya/",
            "laya/"
        ],
        [
            "libs/",
            "libs/"
        ],
        [
            "src/",
            "src/"
        ],
        [
            "prj.game166.laya",
            ""
        ],
        [
            "tsconfig.json",
            ""
        ]
    ],
    "tempProjectName": "laya_proj",
    "autoUploadPack": true,
    "B_SHOW_LICENCE_INFO_ON_LOADING": false,
    "build_laya_oppogame_module_config": {
        "bAutoUploadEnabled": true,
        "bNakedPackage": true,
        "compressJs": false,
        "nakedPackageSearchKeys": [
            "res/cfg/",
            "res/scene/vLoadingScene.json"
        ],
        "oppoInfo": {
            "logLevel": "off",
            "name": "魔力火线联盟‎",
            "package": "com.ultralisk.game166.nearme.gamecenter",
            "versionCode": "127",
            "versionName": "1.0.27"
        },
        "title": "魔力火线联盟‎",
        "url_path": "https://gamesres.ultralisk.cn/h5_games_res/game166/oppoqg/v1",
        "useMinJsLibs": false
    },
    "i_sdk_licence_info_mode": 1,
    "i_sdk_start_game_by_touch": 1,
    "s_sdk_cop_channel_id": "146",
    "s_sdk_cop_version": "25098",
    "s_sdk_licence_info": "著作权人：成都尚泽科技有限公司     登记号：2022SRE013215",
    "t_sdk_increment_fields": [
        "s_sdk_oppoqg_version_code",
        "s_sdk_oppoqg_version_name"
    ],
    "_target_project_branch": "v1_h5_release",
    "_target_project_log": "2023-07-31 11:59:52 +0800-wujun-5dad95c59",
    "_target_last_commit_time": 1690775992,
    "prjVersion": "5dad95c59",
    "rootPath": "D:/ulwork/ulsdk/",
    "rootSdkPath": "D:/ulwork/ulsdk/prj.sdk.html5/",
    "gitRepoPath": "D:/ulwork/ulsdk/h5_games_res/",
    "taskDate": "2023_07_31",
    "taskTick": "2023_07_31_18_41_34",
    "taskTickShort": "0731_184134",
    "taskName": "oppo",
    "configName": "task_game166_ttswz_v1",
    "targetPath": "D:/ulwork/ulsdk/h5_out/66_oppo_0731_184134/",
    "resCachePath": "D:/ulwork/ulsdk/h5_res_cache/prj.game166/",
    "packagePath": "D:/ulwork/ulsdk/prj.games.html5.channels.packages/prj.game166/prj.game166_v1_h5_release_oppo_0731_184134/",
    "buildDisabled": false,
    "creatorExePath": "",
    "nodejsExeAbsPath": "D:/ulwork/ude2/prj.ulnodejs/nodejs16.15.1/node.exe",
    "taskJsonPath": "D:/ulwork/ulsdk/prj.games.html5.channels.tasks/task_game166_ttswz_v1/task.json",
    "buildTempPath": "D://ulwork//ulsdk//prj.sdk.html5//build_system//build_gradle/../../../h5_out/build_temp/",
    "s_sdk_obfuscator_ts_key": "IHY",
    "envCheckResult": [
        {
            "msg": "[警告] taskConfig[t_sdk_oppoqg_show_banner_box_adv_tags]类型错误！当前为[class java.util.ArrayList]，期望[object]",
            "level": 1
        }
    ],
    "b_sdk_obfuscator_mode": false,
    "a_sdk_obfuscator_includes": [
        
    ],
    "o_sdk_obfuscator_config": {
        
    },
    "s_sdk_cocos2x_rootNode_check": "",
    "i_sdk_launchReward_mode": 0,
    "tempProjPath": "D:/ulwork/ulsdk/h5_out/66_oppo_0731_184134/laya_proj/",
    "moduleList": "common,build_laya_oppogame,oppoqg,privacyPolicy"
}`);

    class ULTimer {
        constructor(span, repeatCount, callback) {
            this._repeatCount = -1;
            this._span = 1;
            this._callback = null;
            this._intervalId = null;
            this._count = 0;
            this._beginTime = -1;
            this._usedTime = 0;
            this._span = span;
            this._repeatCount = repeatCount;
            this._callback = callback;
        }
        static callLater(span, callback) {
            let timer = new ULTimer(span, 1, callback);
            timer.start();
        }
        static callLoop(span, callback) {
            let timer = new ULTimer(span, -1, callback);
            timer.start();
        }
        _onSpan() {
            this._count++;
            this._usedTime = ULTools.time() - this._beginTime;
            if (this._callback) {
                try {
                    this._callback(this);
                }
                catch (error) {
                    ULLog.console.warn("警告] ULTimer._onSpan callback has error", error);
                }
            }
            if (this._repeatCount >= 0 && this._count >= this._repeatCount) {
                this.stop();
            }
        }
        isRunning() {
            return this._intervalId != null;
        }
        get count() {
            return this._count;
        }
        get span() {
            return this._span;
        }
        get usedTime() {
            return this._usedTime;
        }
        start() {
            this.stop();
            if (!this._callback) {
                ULLog.console.warn("警告] ULTimer.start callback未设置！");
                return this;
            }
            this._beginTime = ULTools.time();
            this._count = 0;
            this._intervalId = setInterval(this._onSpan.bind(this), this.span * 1000);
            return this;
        }
        stop() {
            if (this._intervalId != null) {
                clearInterval(this._intervalId);
                this._intervalId = null;
            }
            return this;
        }
    }

    class ULStorageManager {
        constructor() {
            this.cacheStorage = {};
        }
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULStorageManager();
            }
            return this._instance;
        }
        getStorage(key) {
            let returnValue = ULEventDispatcher.getInstance().dispatchWithReturn(ULConst.CMD_SDK_GET_STORAGE, { key: key });
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log(ULTools.format("ULStorageManager.getStorage(%s) => [%s]", key, returnValue));
            if (returnValue == null) {
                returnValue = this.cacheStorage[key];
            }
            else {
                this.cacheStorage[key] = returnValue;
            }
            return returnValue;
        }
        setStorage(key, data) {
            this.cacheStorage[key] = data;
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_SET_STORAGE, { key: key, data: data });
            if (!bCalled) {
                ULLog.console.warn("ULStorageManager.setStorage 未找到实现！");
            }
        }
    }
    ULStorageManager._instance = null;

    class ULWebSocket {
        constructor(url) {
            this.socketingWS = null;
            this.isOpening = false;
            this.socketMsgCache = [];
            this._isAutoClearCache = false;
            if ("WebSocket" in window) {
                var address = url;
                var ws = new WebSocket(address);
                this.socketingWS = ws;
                let self = this;
                ws.onopen = function (ev) {
                    self.isOpening = true;
                    self.onopen(ev);
                };
                ws.onmessage = function (evt) {
                    self.onmessage(evt);
                };
                ws.onclose = function (evt) {
                    self.isOpening = false;
                    self.socketingWS = null;
                    self.socketMsgCache = [];
                    self.onclose(evt);
                };
                ws.onerror = function (err) {
                    self.isOpening = false;
                    self.socketingWS = null;
                    self.socketMsgCache = [];
                    self.onerror(err);
                };
            }
        }
        set isAutoClearCache(value) {
            if (value == this._isAutoClearCache) {
                return;
            }
            this._isAutoClearCache = value;
            if (this._isAutoClearCache) {
                this.intervalId = setInterval(() => {
                    this.clearCache();
                }, 30);
            }
            else {
                clearInterval(this.intervalId);
            }
        }
        close(code, reason) {
            if (this.isOpening && this.socketingWS) {
                this.socketingWS.close();
                this.isOpening = false;
                this.socketingWS = null;
            }
        }
        send(msg) {
            if (!this.socketingWS) {
                return;
            }
            let ietm = null;
            try {
                ietm = JSON.stringify(msg);
            }
            catch (error) {
                ietm = JSON.stringify({
                    type: 3,
                    data: error
                });
            }
            finally {
                if (!this.isOpening || this._isAutoClearCache) {
                    this.socketMsgCache.push(ietm);
                    this.isAutoClearCache = true;
                }
                else {
                    this.socketingWS.send(ietm);
                }
            }
        }
        clearCache() {
            if (!this.socketingWS || !this.socketMsgCache.length) {
                this.isAutoClearCache = false;
                return;
            }
            if (this.isOpening) {
                let item = this.socketMsgCache.shift();
                this.socketingWS.send(item);
            }
        }
    }

    class ULTools {
        static time() {
            let time = new Date().getTime() / 1000;
            return time;
        }
        static timeInDay() {
            let time = this.time();
            let todayBeginDate = new Date(time * 1000);
            todayBeginDate.setHours(0);
            todayBeginDate.setMinutes(0);
            todayBeginDate.setSeconds(0);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            return time - todayBeginTime;
        }
        static timeDay(time = this.time()) {
            let todayBeginDate = new Date(time * 1000);
            todayBeginDate.setHours(0);
            todayBeginDate.setMinutes(0);
            todayBeginDate.setSeconds(0);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            return todayBeginTime;
        }
        static timeDayHour(hours = 0, minutes = 0, seconds = 0) {
            let todayBeginDate = new Date();
            todayBeginDate.setHours(hours);
            todayBeginDate.setMinutes(minutes);
            todayBeginDate.setSeconds(seconds);
            todayBeginDate.setMilliseconds(0);
            let todayBeginTime = todayBeginDate.getTime() / 1000;
            if (this.time() > todayBeginTime) {
                todayBeginTime += 60 * 60 * 24;
            }
            return todayBeginTime;
        }
        static isOneDay(seconds1, seconds2) {
            var d1 = new Date(seconds1 * 1000);
            var d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate();
        }
        static isOneMonth(seconds1, seconds2) {
            var d1 = new Date(seconds1 * 1000);
            var d2 = new Date(seconds2 * 1000);
            return d1.getFullYear() == d2.getFullYear() && d1.getMonth() == d2.getMonth();
        }
        static getObjSize(obj) {
            if (!obj) {
                return 0;
            }
            if (Array.isArray(obj)) {
                return obj.length;
            }
            let count = 0;
            this.forEachMap(obj, (k, v) => {
                count++;
            });
            return count;
        }
        static parseUrl(url) {
            var r = {
                protocol: /([^\/]+:)\/\/(.*)/i,
                host: /(^[^\:\/]+)((?:\/|:|$)?.*)/,
                port: /\:?([^\/]*)(\/?.*)/,
                pathname: /([^\?#]+)(\??[^#]*)(#?.*)/
            };
            var tmp = {};
            var res = {
                href: url,
                protocol: "",
                host: "",
                port: "",
                pathname: "",
                search: "",
                hash: ""
            };
            for (let p in r) {
                tmp = r[p].exec(url);
                res[p] = tmp[1];
                url = tmp[2];
                if (url === "") {
                    url = "/";
                }
                if (p === "pathname") {
                    res.pathname = tmp[1];
                    res.search = tmp[2];
                    res.hash = tmp[3];
                }
            }
            return res;
        }
        static random(min, max) {
            if (min == null && max == null) {
                return Math.random();
            }
            else if (max == null) {
                return Math.floor(Math.random() * min + 1);
            }
            else {
                return Math.floor(Math.random() * (max - min + 1) + min);
            }
        }
        static scaleInRange(n, ia, ib, oa, ob) {
            if (ia < ib) {
                if (n < ia)
                    n = ia;
                if (n > ib)
                    n = ib;
            }
            else {
                if (n < ib)
                    n = ib;
                if (n > ia)
                    n = ia;
            }
            let iDistance = ib - ia;
            let oDistance = ob - oa;
            return (n - ia) / iDistance * oDistance + oa;
        }
        static clampf(n, min, max) {
            if (n < min)
                return min;
            if (n > max)
                return max;
            return n;
        }
        static calcWheelTarget(arr, weightKey) {
            let totalWeight = 0;
            for (let i = 0; i < arr.length; i++) {
                const v = arr[i];
                let w = parseInt(v[weightKey]);
                if (isNaN(w)) {
                    ULLog.console.warn(this.format("Tools.calcWheelTarget weight field not found! key=[%s]", weightKey));
                    return null;
                }
                totalWeight += w;
            }
            let rw = this.random(totalWeight);
            for (let i = 0; i < arr.length; i++) {
                const v = arr[i];
                let w = parseInt(v[weightKey]);
                if (rw <= w) {
                    return v;
                }
                else {
                    rw -= w;
                }
            }
            return null;
        }
        static sortArrayByField(array, fields) {
            if (typeof (fields) == "string") {
                fields = [fields];
            }
            else {
                fields = fields;
            }
            let fieldConfig = [];
            for (let k in fields) {
                let v = fields[k];
                if (v && v != "") {
                    if (v.substring(0, 1) === "-") {
                        let tmpField = v.substring(1, v.length);
                        if (tmpField && tmpField != "") {
                            fieldConfig.push([tmpField, true]);
                        }
                    }
                    else {
                        fieldConfig.push([v, false]);
                    }
                }
            }
            let sorter = (a, b) => {
                let ret = 0;
                for (let k in fieldConfig) {
                    let v = fieldConfig[k];
                    let field = v[0];
                    let desc = v[1];
                    let v1 = a[field];
                    let v2 = b[field];
                    if (v1 != null) {
                        if (desc) {
                            ret = v2 - v1;
                        }
                        else {
                            ret = v1 - v2;
                        }
                        if (ret != 0) {
                            return ret;
                        }
                    }
                }
                return ret;
            };
            let sorted = [];
            for (let i = 0; i < array.length; i++) {
                const v = array[i];
                sorted.push(v);
            }
            sorted.sort(sorter);
            return sorted;
        }
        static bubbleSort(arr, sorter) {
            var len = arr.length;
            for (var i = 0; i < len; i++) {
                for (var j = 0; j < len - 1 - i; j++) {
                    let ret = sorter(arr[j], arr[j + 1]);
                    if (ret > 0) {
                        var temp = arr[j + 1];
                        arr[j + 1] = arr[j];
                        arr[j] = temp;
                    }
                }
            }
            return arr;
        }
        static forEachMap(map, callback) {
            if (!map)
                return;
            let keys = Object.keys(map);
            for (let i = 0; i < keys.length; i++) {
                let key = keys[i];
                let value = map[key];
                if (value != null) {
                    if (callback(key, value))
                        break;
                }
            }
        }
        static formatTime(time, format) {
            let hour = Math.floor(time / 3600);
            let minute = Math.floor(time / 60) % 60;
            let second = Math.ceil(time) % 60;
            if (format.match("%h")) {
                format = format.replace("%h", hour.toString());
            }
            if (format.match("%H")) {
                format = format.replace("%H", this.format("%02d", hour));
            }
            if (format.match("%m")) {
                format = format.replace("%m", minute.toString());
            }
            if (format.match("%M")) {
                format = format.replace("%M", this.format("%02d", minute));
            }
            if (format.match("%s")) {
                format = format.replace("%s", second.toString());
            }
            if (format.match("%S")) {
                format = format.replace("%S", this.format("%02d", second));
            }
            return format;
        }
        static formatDate(date, format) {
            let o = {
                "M+": date.getMonth() + 1,
                "d+": date.getDate(),
                "H+": date.getHours(),
                "m+": date.getMinutes(),
                "s+": date.getSeconds(),
                "q+": Math.floor((date.getMonth() + 3) / 3),
                "S+": date.getMilliseconds()
            };
            let fmt = format;
            if (/(y+)/.test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
            }
            for (var k in o) {
                if (new RegExp("(" + k + ")").test(fmt)) {
                    fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
                }
            }
            return fmt;
        }
        static generateUUID() {
            let d = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }
        ;
        static compressUuid(uuid) {
            let hexChars = "0123456789abcdef".split("");
            let hexMap = {};
            for (let i = 0; i < hexChars.length; i++) {
                hexMap[hexChars[i]] = i;
            }
            let base64KeyToChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".split("");
            let base64CharToKey = {};
            for (let i = 0; i < base64KeyToChars.length; i++) {
                base64CharToKey[base64KeyToChars[i]] = i;
            }
            uuid = uuid.replace(/-/g, "");
            let arr = uuid.split("");
            let outArr = [];
            outArr.push(arr[0]);
            outArr.push(arr[1]);
            for (let i = 2; i < arr.length; i += 3) {
                let hex1 = hexMap[arr[i]];
                let hex2 = hexMap[arr[i + 1]];
                let hex3 = hexMap[arr[i + 2]];
                outArr.push(base64KeyToChars[(hex1 << 2) | (hex2 >> 2)]);
                outArr.push(base64KeyToChars[((hex2 & 3) << 4) | hex3]);
            }
            return outArr.join("");
        }
        static decompressUuid(uuid) {
            let arr = uuid.split("");
            if (arr.length < 22)
                return uuid;
            let hexChars = "0123456789abcdef".split("");
            let hexMap = {};
            for (let i = 0; i < hexChars.length; i++) {
                hexMap[hexChars[i]] = i;
            }
            let base64KeyToChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".split("");
            let base64CharToKey = {};
            for (let i = 0; i < base64KeyToChars.length; i++) {
                base64CharToKey[base64KeyToChars[i]] = i;
            }
            let outArr = [];
            outArr.push(arr[0]);
            outArr.push(arr[1]);
            for (let i = 2; i < arr.length; i += 2) {
                let lhs = base64CharToKey[arr[i]];
                let rhs = base64CharToKey[arr[i + 1]];
                outArr.push(hexChars[lhs >> 2]);
                outArr.push(hexChars[((lhs & 3) << 2) | rhs >> 4]);
                outArr.push(hexChars[rhs & 0xF]);
            }
            outArr.splice(8, 0, "-");
            outArr.splice(13, 0, "-");
            outArr.splice(18, 0, "-");
            outArr.splice(23, 0, "-");
            return outArr.join("");
        }
        static getType(obj) {
            let toString = Object.prototype.toString;
            let map = {
                '[object Boolean]': 'boolean',
                '[object Number]': 'number',
                '[object String]': 'string',
                '[object Function]': 'function',
                '[object Array]': 'array',
                '[object Date]': 'date',
                '[object RegExp]': 'regExp',
                '[object Undefined]': 'undefined',
                '[object Null]': 'null',
                '[object Object]': 'object'
            };
            return map[toString.call(obj)];
        }
        static clone(data) {
            let type = this.getType(data);
            let obj;
            if (window["cc"] && window["cc"].Node && data instanceof window["cc"].Node) {
                return data;
            }
            else if (type === 'object') {
                obj = {};
            }
            else if (type === 'array') {
                obj = [];
            }
            else {
                return data;
            }
            if (type === 'array') {
                for (let i = 0, len = data["length"]; i < len; i++) {
                    obj.push(this.clone(data[i]));
                }
            }
            else if (type === 'object') {
                for (let key in data) {
                    obj[key] = this.clone(data[key]);
                }
            }
            return obj;
        }
        static toArray(arr) {
            if (Array.isArray(arr))
                return arr;
            return [];
        }
        static sumNumberArray(arr) {
            if (!Array.isArray(arr))
                return 0;
            let sum = 0;
            for (let i = 0; i < arr.length; i++) {
                const n = arr[i];
                if (isNaN(n))
                    continue;
                sum += n;
            }
            return sum;
        }
        static getRandomValueInArray(arr) {
            if (!Array.isArray(arr))
                return null;
            return arr[this.random(arr.length) - 1];
        }
        static _convert(match, nosign) {
            if (nosign) {
                match.sign = '';
            }
            else {
                match.sign = match.negative ? '-' : match.sign;
            }
            var l = match.min - match.argument.length + 1 - match.sign.length;
            var pad = new Array(l < 0 ? 0 : l).join(match.pad);
            if (!match.left) {
                if (match.pad == "0" || nosign) {
                    return match.sign + pad + match.argument;
                }
                else {
                    return pad + match.sign + match.argument;
                }
            }
            else {
                if (match.pad == "0" || nosign) {
                    return match.sign + match.argument + pad.replace(/0/g, ' ');
                }
                else {
                    return match.sign + match.argument + pad;
                }
            }
        }
        static format(...args) {
            if (typeof arguments == "undefined") {
                return null;
            }
            if (arguments.length < 1) {
                return null;
            }
            if (typeof arguments[0] != "string") {
                return null;
            }
            if (typeof RegExp == "undefined") {
                return null;
            }
            var string = arguments[0];
            var exp = new RegExp(/(%([%]|(\-)?(\+|\x20)?(0)?(\d+)?(\.(\d)?)?([bcdfosxX])))/g);
            var matches = new Array();
            var strings = new Array();
            var convCount = 0;
            var stringPosStart = 0;
            var stringPosEnd = 0;
            var matchPosEnd = 0;
            var newString = '';
            var match = null;
            while (match = exp.exec(string)) {
                if (match[9]) {
                    convCount += 1;
                }
                stringPosStart = matchPosEnd;
                stringPosEnd = exp.lastIndex - match[0].length;
                strings[strings.length] = string.substring(stringPosStart, stringPosEnd);
                matchPosEnd = exp.lastIndex;
                matches[matches.length] = {
                    match: match[0],
                    left: match[3] ? true : false,
                    sign: match[4] || '',
                    pad: match[5] || ' ',
                    min: match[6] || 0,
                    precision: match[8],
                    code: match[9] || '%',
                    negative: parseInt(arguments[convCount]) < 0 ? true : false,
                    argument: String(arguments[convCount])
                };
            }
            strings[strings.length] = string.substring(matchPosEnd);
            if (matches.length == 0) {
                return string;
            }
            if ((arguments.length - 1) < convCount) {
                return null;
            }
            var code = null;
            var match = null;
            var substitution = null;
            var i = null;
            for (i = 0; i < matches.length; i++) {
                if (matches[i].code == '%') {
                    substitution = '%';
                }
                else if (matches[i].code == 'b') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(2));
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'c') {
                    matches[i].argument = String(String.fromCharCode(Math.abs(parseInt(matches[i].argument))));
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'd') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'f') {
                    matches[i].argument = String(Math.abs(parseFloat(matches[i].argument)).toFixed(matches[i].precision ? matches[i].precision : 6));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'o') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(8));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 's') {
                    matches[i].argument = matches[i].argument.substring(0, matches[i].precision ? matches[i].precision : matches[i].argument.length);
                    substitution = this._convert(matches[i], true);
                }
                else if (matches[i].code == 'x') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                    substitution = this._convert(matches[i]);
                }
                else if (matches[i].code == 'X') {
                    matches[i].argument = String(Math.abs(parseInt(matches[i].argument)).toString(16));
                    substitution = this._convert(matches[i]).toUpperCase();
                }
                else {
                    substitution = matches[i].match;
                }
                newString += strings[i];
                newString += substitution;
            }
            newString += strings[i];
            return newString;
        }
        static httpGet(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        if (xhr) {
                            ULLog.console.warn("ULTools.httpGet on error:", xhr.readyState, xhr.status);
                            if (obj.fail instanceof Function)
                                obj.fail(xhr.status.toString());
                            let temp = xhr;
                            xhr = null;
                            temp.abort();
                        }
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('get', obj.url);
            xhr.send();
        }
        static httpGetJson(obj) {
            let arr = [];
            this.forEachMap(obj.params, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let paramString = arr.join('&');
            let trimUrl = `${obj.url}?${paramString}`;
            ULLog.console.log("ULTools.httpGetJson trimUrl:", trimUrl);
            this.httpGet({
                url: trimUrl,
                timeoutMillisecond: obj.timeoutMillisecond,
                success: obj.success,
                fail: obj.fail
            });
        }
        static httpPost(obj) {
            obj.contentType = obj.contentType || "application/x-www-form-urlencoded;charset=utf-8";
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        ULLog.console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader('Content-Type', obj.contentType);
            xhr.send(obj.postData);
        }
        static httpPostJson(obj) {
            let arr = [];
            this.forEachMap(obj.params, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let paramString = arr.join('&');
            ULLog.console.log("ULTools.httpPostJson paramString:", paramString);
            this.httpPost({
                url: obj.url,
                postData: paramString,
                timeoutMillisecond: obj.timeoutMillisecond,
                success: obj.success,
                fail: obj.fail
            });
        }
        static httpPostFormData(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        ULLog.console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.send(obj.formData);
        }
        static httpPostEncryption(obj) {
            let xhr = new XMLHttpRequest();
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            });
            xhr.onreadystatechange = function (e) {
                if (!xhr)
                    return;
                if (xhr.readyState == 4) {
                    timeoutTimer.stop();
                    if (xhr.status == 200) {
                        let responseData = xhr.responseText;
                        if (obj.success instanceof Function)
                            obj.success(responseData);
                    }
                    else {
                        console.warn("ULTools.httpPost on error:", xhr.readyState, xhr.status);
                        if (obj.fail instanceof Function)
                            obj.fail(xhr.status.toString());
                    }
                }
            };
            xhr.ontimeout = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("timeout");
                }
            };
            xhr.onerror = function (e) {
                if (xhr) {
                    let temp = xhr;
                    xhr = null;
                    temp.abort();
                    if (obj.fail instanceof Function)
                        obj.fail("on error :" + e);
                }
            };
            let byteArray = this.stringToByte(obj.postString);
            let key = byteArray.length % 127 || 127;
            var myArray = new ArrayBuffer(byteArray.length);
            var longInt8View = new Uint8Array(myArray);
            for (let i = 0; i < byteArray.length; i++) {
                byteArray[i] = byteArray[i] ^ key;
                longInt8View[i] = byteArray[i];
            }
            timeoutTimer.start();
            xhr.open('post', obj.url, true);
            xhr.setRequestHeader('isEncrypt', "1");
            xhr.setRequestHeader('Content-Type', "application/octet-stream");
            xhr.send(myArray);
        }
        static httpJsonp(obj) {
            if (!obj || !obj.url) {
                throw new Error("参数不合法");
            }
            let callbackName = ULTools.format("jsonp_%d", ULTools.random(1000000));
            obj.data.callback = callbackName;
            let oHead = document.getElementsByTagName('head')[0];
            let arr = [];
            this.forEachMap(obj.data, (k, v) => {
                arr.push(ULTools.format("%s=%s", encodeURIComponent(k), encodeURIComponent(v)));
            });
            let params = arr.join('&');
            let oS = document.createElement('script');
            oHead.appendChild(oS);
            let timeoutTimer = new ULTimer(obj.timeoutMillisecond / 1000, 1, (timer) => {
                if (!window[callbackName])
                    return;
                window[callbackName] = null;
                oHead.removeChild(oS);
                obj.fail && obj.fail("timeout");
            });
            window[callbackName] = function (json) {
                if (!window[callbackName])
                    return;
                oHead.removeChild(oS);
                timeoutTimer.stop();
                window[callbackName] = null;
                obj.success && obj.success(json);
            };
            oS.src = obj.url + '?' + params;
        }
        static _start_console_print_LAN() {
            if (ULTools.socketingWS) {
                return;
            }
            let lan_debug_address_default = ULConfig.getConfig().s_sdk_lan_debug_address.length > 10 ? ULConfig.getConfig().s_sdk_lan_debug_address : "";
            let lan_id = localStorage.getItem("console_lan_id") || ULStorageManager.getInstance().getStorage("console_lan_id") || lan_debug_address_default;
            ULLog.console.log('console_lan_id:', lan_id);
            if (lan_id && lan_id.length && "WebSocket" in window) {
                ULLog.console.log("支持WebSocket局域网调试");
                var address = `ws://${lan_id}:3002/websocket/test`;
                var ws = null;
                try {
                    ws = new ULWebSocket(address);
                    ws.onopen = function () {
                        ULLog.console.log("Connection open ...");
                        ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("console_lan_id", "已开启局域网调试");
                    };
                    ws.onmessage = function (evt) {
                        ULLog.console.log("Received Message:" + evt.data);
                    };
                    ws.onclose = function () {
                        ULLog.console.log("Connection closed");
                        ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("console_lan_id");
                        ULTools.socketingWS = null;
                        ULTools._hack_console_print_method();
                    };
                    ws.onerror = function (err) {
                        ULLog.console.error("Connection onerror:", err);
                        ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("console_lan_id");
                        ULTools.socketingWS = null;
                        ULTools._hack_console_print_method();
                    };
                }
                catch (error) {
                    ws = null;
                    ULLog.console.log("局域网调试错误:", JSON.stringify(error));
                }
                finally {
                    if (ws == null) {
                        return;
                    }
                    ULTools.socketingWS = ws;
                    ULTools._hack_console_print_method();
                }
            }
            else {
                ULLog.console.log("不支持WebSocket局域网调试");
            }
        }
        static _close_console_print_LAN() {
            if (ULTools.socketingWS) {
                ULTools.socketingWS.close();
                ULTools.socketingWS = null;
                ULTools._hack_console_print_method();
            }
        }
        static loadJs(url, fOnSuccess, bCrossOriginAnonymous) {
            let script = document.createElement('script');
            script.type = "text/javascript";
            script.addEventListener('load', (e) => {
                if (fOnSuccess instanceof Function)
                    fOnSuccess();
            });
            script.src = url;
            script.defer = "defer";
            if (bCrossOriginAnonymous) {
                script.crossOrigin = "anonymous";
            }
            let head = document.getElementsByTagName('head')[0];
            head.appendChild(script);
        }
        static stringToByte(str) {
            var bytes = new Array();
            var len, c;
            len = str.length;
            for (var i = 0; i < len; i++) {
                c = str.charCodeAt(i);
                if (c >= 0x010000 && c <= 0x10FFFF) {
                    bytes.push(((c >> 18) & 0x07) | 0xF0);
                    bytes.push(((c >> 12) & 0x3F) | 0x80);
                    bytes.push(((c >> 6) & 0x3F) | 0x80);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else if (c >= 0x000800 && c <= 0x00FFFF) {
                    bytes.push(((c >> 12) & 0x0F) | 0xE0);
                    bytes.push(((c >> 6) & 0x3F) | 0x80);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else if (c >= 0x000080 && c <= 0x0007FF) {
                    bytes.push(((c >> 6) & 0x1F) | 0xC0);
                    bytes.push((c & 0x3F) | 0x80);
                }
                else {
                    bytes.push(c & 0xFF);
                }
            }
            return bytes;
        }
        static byteToString(arr) {
            if (typeof arr === 'string') {
                return arr;
            }
            var str = '', _arr = arr;
            for (var i = 0; i < _arr.length; i++) {
                var one = _arr[i].toString(2), v = one.match(/^1+?(?=0)/);
                if (v && one.length == 8) {
                    var bytesLength = v[0].length;
                    var store = _arr[i].toString(2).slice(7 - bytesLength);
                    for (var st = 1; st < bytesLength; st++) {
                        store += _arr[st + i].toString(2).slice(2);
                    }
                    str += String.fromCharCode(parseInt(store, 2));
                    i += bytesLength - 1;
                }
                else {
                    str += String.fromCharCode(_arr[i]);
                }
            }
            return str;
        }
        static getQueryString(name) {
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
            var r = window.location.search.substr(1).match(reg);
            if (r != null) {
                return decodeURI(r[2]);
            }
            return null;
        }
        static createRandomString(len) {
            len = len || 32;
            let $chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz123456789';
            let maxPos = $chars.length;
            let pwd = '';
            for (let i = 0; i < len; i++) {
                pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
            }
            return pwd;
        }
        static createRandomUserId() {
            let longUuid = this.generateUUID();
            let shortUuid = this.compressUuid(longUuid);
            return shortUuid;
        }
        static createRandomOrderId() {
            let t = new Date().getTime();
            return t + this.createRandomString(7);
        }
        static compareVersion(v1, v2) {
            let arr1 = v1.split('.');
            let arr2 = v2.split('.');
            const len = Math.max(arr1.length, arr2.length);
            while (arr1.length < len) {
                arr1.push('0');
            }
            while (arr2.length < len) {
                arr2.push('0');
            }
            for (let i = 0; i < len; i++) {
                const num1 = parseInt(arr1[i]);
                const num2 = parseInt(arr2[i]);
                if (num1 > num2) {
                    return 1;
                }
                else if (num1 < num2) {
                    return -1;
                }
            }
            return 0;
        }
        static _hack_console_print_method() {
            if (!this._origin_console_log)
                this._origin_console_log = console.log;
            if (!this._origin_console_warn)
                this._origin_console_warn = console.warn;
            if (!this._origin_console_error)
                this._origin_console_error = console.error;
            if (window["cc"] && window["cc"].Node) {
                if (!this._origin_cc_log)
                    this._origin_cc_log = window["cc"]["log"];
                if (!this._origin_cc_warn)
                    this._origin_cc_warn = window["cc"]["warn"];
                if (!this._origin_cc_error)
                    this._origin_cc_error = window["cc"]["error"];
            }
            let trim_console_func = function (type, callback) {
                let trimFunc = function (...data) {
                    callback(...data);
                    if (ULTools.socketingWS) {
                        ULTools.socketingWS.send({
                            type: type,
                            data: data
                        });
                    }
                };
                return trimFunc;
            };
            let config = ULConfig.getConfig();
            console.log = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_LOG ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_console_log) : this._origin_console_log));
            console.warn = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_WARN ? () => { } : (ULTools.socketingWS ? trim_console_func(2, this._origin_console_warn) : this._origin_console_warn));
            console.error = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_ERROR ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_console_error) : this._origin_console_error));
            if (window["cc"] && window["cc"].Node) {
                window["cc"]["log"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_LOG ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_cc_log) : this._origin_cc_log));
                window["cc"]["warn"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_WARN ? () => { } : (ULTools.socketingWS ? trim_console_func(2, this._origin_cc_warn) : this._origin_cc_warn));
                window["cc"]["error"] = (config.i_sdk_debug_mode < ULConst.CONSOLE_OUTPUT_LEVEL_ERROR ? () => { } : (ULTools.socketingWS ? trim_console_func(1, this._origin_cc_error) : this._origin_cc_error));
            }
        }
        static jsonValToStr(oldJson) {
            if (!oldJson) {
                return oldJson;
            }
            let targetJson = {};
            let keys = Object.keys(oldJson);
            for (let i = 0; i < keys.length; i++) {
                let key = keys[i];
                let value = oldJson[key];
                if (typeof (value) == "object") {
                    value = JSON.stringify(value);
                }
                else {
                    value = String(value);
                }
                targetJson[key] = value;
            }
            return targetJson;
        }
        static calcWheelTargetByArray(array, maxWeight) {
            let totalWeight = 0;
            for (let i = 0; i < array.length; i++) {
                totalWeight += array[i];
            }
            if (maxWeight != 0) {
                totalWeight = Math.min(totalWeight, maxWeight);
            }
            let random = (Math.random() * totalWeight);
            let sum = 0;
            for (let i = 0; i < array.length; i++) {
                sum += array[i];
                if (sum > random) {
                    return i;
                }
            }
            return null;
        }
        static recordVideoTimeLimit(type, recordDuration) {
            let duration_limit_object = ULConfig.getConfig().t_sdk_record_duration_limit_object || {};
            let tirm_type = (typeof (type) == "string") ? type : (typeof (type) == "number") ? type.toString() : "";
            let type_Object = duration_limit_object[tirm_type] || duration_limit_object["*"] || {};
            let limit_min = type_Object.min || 0;
            let limit_max = type_Object.max || 10000;
            if (limit_min > recordDuration) {
                return { isConform: false, msg: `录屏时间少于${limit_min}秒` };
            }
            else if (limit_max < recordDuration) {
                return { isConform: false, msg: `录屏时间大于${limit_max}秒` };
            }
            return { isConform: true, msg: "" };
        }
        static substrFromByte(str, byteNum) {
            let trimNum = byteNum;
            let trimStrAry = str.split("");
            let cutStr = "";
            while (trimStrAry.length && trimNum > 0) {
                let firstItem = trimStrAry.shift();
                let bytes = ULTools.stringToByte(firstItem);
                trimNum = trimNum - bytes.length;
                if (trimNum >= 0) {
                    cutStr += firstItem;
                }
                else {
                    trimStrAry.unshift(firstItem);
                }
            }
            return { remainStr: trimStrAry.join(""), cutStr: cutStr };
        }
        static isLayaEngine() {
            if (window["Laya"])
                return true;
            return false;
        }
        static startsWith(str, startStr) {
            var sliceStr = str.slice(0, Math.min(str.length, startStr.length));
            return sliceStr == startStr;
        }
        ;
        static isCreator2xEngine() {
            if (window["cc"] && window["cc"].ENGINE_VERSION && this.startsWith(window["cc"].ENGINE_VERSION, "2.")) {
                return true;
            }
            return false;
        }
        static isCreator3xEngine() {
            if (window["cc"] && window["cc"].ENGINE_VERSION && this.startsWith(window["cc"].ENGINE_VERSION, "3.")) {
                return true;
            }
            return false;
        }
        static isString(obj) {
            let type = ULTools.getType(obj);
            return type == "string";
        }
        static isNumber(obj) {
            let type = ULTools.getType(obj);
            return type == "number";
        }
        static isStringOrNumber(obj) {
            let type = ULTools.getType(obj);
            return type == "number" || type == "string";
        }
        static isObject(obj) {
            let type = ULTools.getType(obj);
            return type == "object";
        }
        static isArray(obj) {
            let type = ULTools.getType(obj);
            return type == "array";
        }
        static isFunc(obj) {
            let type = ULTools.getType(obj);
            return type == "function";
        }
        static getStringValue(obj, key, defaultValue = "") {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isStringOrNumber(value))
                    return value.toString();
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isStringOrNumber(value))
                        return value.toString();
                }
            }
            return defaultValue;
        }
        static getNumberValue(obj, key, defaultValue = 0) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isStringOrNumber(value))
                    return !isNaN(Number(value)) ? Number(value) : defaultValue;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = obj[key];
                    if (ULTools.isStringOrNumber(value))
                        return !isNaN(Number(value)) ? Number(value) : defaultValue;
                }
            }
            return defaultValue;
        }
        static getArrayValue(obj, key, defaultValue = []) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isArray(value))
                    return value;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isArray(value))
                        return value;
                }
            }
            return defaultValue;
        }
        static getObjectValue(obj, key, defaultValue = {}) {
            if (ULTools.isObject(obj) && ULTools.isString(key)) {
                let value = obj[key];
                if (ULTools.isObject(value))
                    return value;
            }
            else if (ULTools.isArray(obj) && ULTools.isNumber(key)) {
                let trimObj = obj;
                if (trimObj.length > Number(key)) {
                    let value = trimObj[key];
                    if (ULTools.isObject(value))
                        return value;
                }
            }
            return defaultValue;
        }
        static randomChinese(length = 10) {
            const randomLength = Math.floor(Math.random() * length) + 1;
            let result = '';
            for (let i = 0; i < randomLength; i++) {
                const random = Math.floor(Math.random() * (0x9fa5 - 0x4e00 + 1)) + 0x4e00;
                result += String.fromCharCode(random);
            }
            return result;
        }
        static getCommonHost() {
            let result = "u";
            result += "l";
            result += "t";
            result += "r";
            result += "a";
            result += "l";
            result += "i";
            result += "s";
            result += "k";
            return result;
        }
    }
    ULTools.socketingWS = null;

    class ULConfig {
        static init() {
            this.bInit = true;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        static getConfig() {
            if (!this.bInit) {
                this.init();
            }
            if (!this.currConfig) {
                this.currConfig = ULTools.clone(cConfig);
            }
            return this.currConfig;
        }
        static get(key) {
            let config = this.getConfig();
            let value = config[key];
            return value;
        }
        static updateValueByCop(cop) {
            let newConfig = ULTools.clone(cConfig);
            ULTools.forEachMap(cop, (k, v) => {
                if (v == "nil")
                    v = "";
                newConfig[k] = v;
            });
            this.currConfig = newConfig;
            ULConst.B_INNER_DEBUG = this.getConfig().i_sdk_debug_mode >= ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG;
        }
        static onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cConfig:" });
            config.push({
                type: "button",
                text: "显示cConfig",
                onClick: () => {
                    let data = this.currConfig;
                    let keys = Object.keys(data);
                    keys.sort();
                    let conf = [];
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = JSON.stringify(data[key]);
                        let text = ULTools.format("[%s] = [%s]\n", key, value);
                        if (text.length >= 64) {
                            text = text.substr(0, 64 - 2) + "..";
                        }
                        conf.push({ text: text, value: { k: key, v: value } });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("cConfig", conf, (value) => {
                        ULSdkManager.getInstance().moduleCheckerManager.alertPrompt(value.k, value.v, "关闭", null);
                    }, true);
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: ULTools.format("i_sdk_debug_mode=[%s]", this.getConfig().i_sdk_debug_mode),
                name: "labelDebugMode",
            });
            config.push({
                type: "button",
                text: "切换调试模式",
                onClick: () => {
                    let conf = [
                        { text: "0: 全关", value: 0 },
                        { text: "1: warn + error", value: 1 },
                        { text: "2: log + warn + error", value: 2 },
                        { text: "3: 开启各模块的DEBUG + log + warn + error", value: 3 },
                    ];
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择调试模式", conf, (value) => {
                        cConfig.i_sdk_debug_mode = value;
                        this.currConfig.i_sdk_debug_mode = value;
                        ULTools._hack_console_print_method();
                        ULConst.B_INNER_DEBUG = this.getConfig().i_sdk_debug_mode >= ULConst.CONSOLE_OUTPUT_LEVEL_INNER_DEBUG;
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelDebugMode", ULTools.format("i_sdk_debug_mode=[%s]", this.getConfig().i_sdk_debug_mode));
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: "局域网调试：",
                name: "labelSocketDebugMode",
            });
            config.push({
                type: "inputBox",
                text: ULStorageManager.getInstance().getStorage("console_lan_id"),
                name: "console_lan_id"
            });
            config.push({
                type: "button",
                text: "切换局域网调试模式",
                onClick: () => {
                    let console_lan_id = ULSdkManager.getInstance().moduleCheckerManager.getItemText("console_lan_id");
                    let conf = [
                        { text: "关闭调试", value: 0 },
                        { text: "开启调试: " + console_lan_id, value: 1 },
                    ];
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择调试模式", conf, (value) => {
                        if (value == 0) {
                            ULStorageManager.getInstance().setStorage("console_lan_id", null);
                            ULTools._close_console_print_LAN();
                        }
                        else {
                            ULStorageManager.getInstance().setStorage("console_lan_id", console_lan_id);
                            ULTools._start_console_print_LAN();
                        }
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "label",
                text: `SDK log 开关：(${this.sdkLogSwitch ? "已开启" : "已关闭"})`,
                name: "SDK_LOG_MODE",
            });
            config.push({
                type: "button",
                text: `切换状态`,
                onClick: () => {
                    if (this.sdkLogSwitch) {
                        this.sdkLogSwitch = false;
                        ULLog.console.allowConsole = false;
                    }
                    else {
                        this.sdkLogSwitch = true;
                        ULLog.console.allowConsole = true;
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("SDK_LOG_MODE", `SDK log 开关：(${this.sdkLogSwitch ? "已开启" : "已关闭"})`);
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "显示sdk通信记录:" });
            config.push({
                type: "button",
                text: "查看...",
                onClick: () => {
                    let log = ULSdkManager.getInstance().getSdkCommunicationLog();
                    let conf = [];
                    for (let i = 0; i < log.length; i++) {
                        const v = log[i];
                        try {
                            let data = JSON.parse(v);
                            ULLog.console.log(i, v, data);
                            conf.push({
                                text: ULTools.format("%d: %s", i, data.cmd),
                                value: v,
                            });
                        }
                        catch (error) {
                        }
                    }
                    ULLog.console.log("conf", conf);
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("sdk通信记录（最近100条）", conf, (v) => {
                        ULSdkManager.getInstance().moduleCheckerManager.showBigTextWithPickerDialog("详情", v, 40);
                    }, true);
                },
            });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }
    ULConfig.bInit = false;
    ULConfig.sdkLogSwitch = true;

    class ULModuleBase {
        constructor() {
            ULLog.console.log("ULModuleBase-constructor");
        }
        init() {
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, this.getCollectionModuleCheckerPriority(), this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        onDisposeModule() {
            ULLog.console.log("ULModuleBase-onDisposeModule");
        }
        loadSubModules() {
            return [];
        }
        getSubAdModuleClassName() {
            return [];
        }
        getAdMainClassName() {
            return "";
        }
        createSubAdObj(className, param) {
            return null;
        }
        createMainAdObj() {
            return null;
        }
        loadModuleCheckerConfig() {
            return [];
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let ret = this.loadModuleCheckerConfig();
            for (let i = 0; i < ret.length; i++) {
                const v = ret[i];
                config.push(v);
            }
            e.setReturnValue(config, true);
        }
        getCollectionModuleCheckerPriority() {
            return ULConst.PRIORITY_NONE;
        }
    }

    class ULModuleCdk extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleCdk";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USE_CDKEY, 1, this.onCmdUseCdkey.bind(this));
        }
        requestUseCdk(userId, cdkStr, channelId) {
            let config = ULConfig.getConfig();
            let appId = config.s_sdk_cdk_app_id;
            let timeout = config.i_net_timeout;
            let url = ULTools.format("%s?userId=%s&cdkStr=%s&appId=%s&channelId=%s", config.s_sdk_cdk_url, userId, cdkStr, appId, channelId);
            ULLog.console.log("ULModuleCdk.requestUseCdk", url);
            ULTools.httpGet({
                url: url,
                timeoutMillisecond: timeout,
                success: (responseText) => {
                    responseText = responseText.replace("\"[", "[");
                    responseText = responseText.replace("]\"", "]");
                    responseText = responseText.replace("\"0\"", "\"1\"");
                    responseText = responseText.replace("message", "data");
                    let data = JSON.parse(responseText);
                    ULSdkManager.getInstance().statisManager.reportOpenCdk(data.code);
                    if (data.code == 1) {
                        ULSdkManager.getInstance().response(ULConst.CMD_USE_CDKEY_RESULT, {
                            code: 1,
                            data: data.data,
                            message: "兑换成功",
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_USE_CDKEY_RESULT, {
                            code: 0,
                            data: [],
                            message: data.data,
                        });
                    }
                },
                fail: () => {
                    ULSdkManager.getInstance().statisManager.reportOpenCdk(0);
                    ULSdkManager.getInstance().response(ULConst.CMD_USE_CDKEY_RESULT, {
                        code: 0,
                        message: "请求超时",
                    });
                },
            });
        }
        onCmdUseCdkey(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userId = data.userId;
            let cdkStr = data.cdkStr;
            let channelId = config.s_sdk_cop_channel_id;
            this.requestUseCdk(userId, cdkStr, channelId);
        }
    }

    class ULModuleMegadata extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleMegadata";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_MEGADATA_SERVER, 1, this.onCmdMegadataServer.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_POST_MEGADATA, 1, this.onCmdPostMegadata.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            this.gameLevelStartMsgList = {};
        }
        onCmdMegadataServer(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            if (Array.isArray(data) && data.length > 0) {
                ULSdkManager.getInstance().response(ULConst.CMD_MEGADATA_SERVER_RESULT, {
                    code: 1,
                    message: "上报成功",
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_MEGADATA_SERVER_RESULT, {
                    code: 0,
                    message: "数据异常",
                });
            }
            let statisticsAddr = config.s_sdk_megadata_url;
            if (!!ULSdkManager.getInstance().statisManager.getPostMegadataMode()) {
                statisticsAddr = config.s_sdk_megadata_test_url;
            }
            if (statisticsAddr.search(/megadatav7/gi) != -1) {
                ULLog.console.warn("应用确定使用v7版本统计，/c/megadataServer接口数据不再进行上报");
                return;
            }
            let rawDatas = ULTools.clone(data);
            let actionType = rawDatas[0];
            if (actionType == ULConst.STATIS_USER_EVENT_POINT_EVENT) {
                ULSdkManager.getInstance().statisManager.reportPointEvent(rawDatas[1], rawDatas[2]);
                return;
            }
            if (actionType == ULConst.STATIS_USER_EVENT_GAME_LEVEL_START) {
                let gameLevelStartTime = ULTools.time();
                let levelName = rawDatas[1] + "";
                this.gameLevelStartMsgList[levelName] = gameLevelStartTime;
            }
            if (actionType == ULConst.STATIS_USER_EVENT_GAME_LEVEL_COMPLETE) {
                let levelName = rawDatas[1] + "";
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[levelName];
                this.gameLevelStartMsgList[levelName] = undefined;
                delete this.gameLevelStartMsgList[levelName];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                rawDatas.push(Math.floor(usedTime).toString());
            }
            ULSdkManager.getInstance().statisManager.reportUserEvent(rawDatas);
        }
        onCmdPostMegadata(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            if (Array.isArray(data) && data.length > 0) {
                ULSdkManager.getInstance().response(ULConst.CMD_POST_MEGADATA_RESULT, {
                    code: 1,
                    message: "上报成功",
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_POST_MEGADATA_RESULT, {
                    code: 0,
                    message: "数据异常",
                });
            }
            let rawDatas = ULTools.clone(data);
            let actionType = rawDatas[0];
            let typeId = "";
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_LEVEL_START) {
                let gameLevelStartTime = ULTools.time();
                let levelName = rawDatas[1] + "";
                this.gameLevelStartMsgList[levelName] = gameLevelStartTime;
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_LEVEL_START_EVENT);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_LEVEL_COMPLETE) {
                let levelName = rawDatas[1] + "";
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[levelName];
                this.gameLevelStartMsgList[levelName] = undefined;
                delete this.gameLevelStartMsgList[levelName];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                rawDatas.push(Math.floor(usedTime).toString());
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT);
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, ["levelComplete", levelName]);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_COIN_CHANGE) {
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_COIN_CHANGE_EVENT);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_ITEM_BUY) {
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_ITEM_BUY);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_BUY_ACTION) {
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_BUY_ACTION);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_COMMON_EVENT) {
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_COMMON_EVENT);
                let postData = ULTools.clone(rawDatas);
                postData.shift();
                ULLog.console.log("ULModuleMegadta.onCmdPostMegadatapostData postData:", postData);
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, postData);
            }
            if (actionType == ULConst.STATIS_USER_ACTION_EVENT_VIDEO_POINT_EVENT) {
                typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_VIDEO_POINT_EVENT);
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, ["videoPointShow", rawDatas[1]]);
            }
            if (typeId != "") {
                rawDatas.shift();
                ULLog.console.log("ULModuleMegadta.onCmdPostMegadatapostData typeId:", typeId, " rawDatas:", rawDatas);
                ULSdkManager.getInstance().statisManager.reportUserActionEvent(rawDatas, typeId);
            }
        }
        onCmdSdkOnGameResume(e) {
            let config = ULConfig.getConfig();
            for (let key in this.gameLevelStartMsgList) {
                this.gameLevelStartMsgList[key] = ULTools.time();
            }
            ULLog.console.log("ULModuleMegadta.onCmdSdkOnGameResume gameLevelStartTime:", this.gameLevelStartMsgList);
        }
        onCmdSdkOnGamePause(e) {
            let config = ULConfig.getConfig();
            for (let key in this.gameLevelStartMsgList) {
                ULLog.console.log("ULModuleMegadta.onCmdSdkOnGamePause currentGameLevelName:", key);
                let usedTime = ULTools.time() - this.gameLevelStartMsgList[key];
                if (isNaN(usedTime))
                    usedTime = 0;
                if (usedTime < 0 || usedTime > 10000) {
                    usedTime = 0;
                }
                let rawDatas = new Array();
                rawDatas.push(key);
                rawDatas.push("2");
                rawDatas.push("pause");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push("0");
                rawDatas.push(Math.floor(usedTime).toString());
                let typeId = ULTools.format("%s-%s", config.s_sdk_megadata_server_type_id, ULConst.STATIS_TYPE_LEVEL_COMPLETE_EVENT);
                ULSdkManager.getInstance().statisManager.reportUserActionEvent(rawDatas, typeId);
            }
        }
    }

    class ULModuleUserData extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleUserData";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SAVE_USER_DATA, ULConst.PRIORITY_DISABLE, this.onCmdSaveUserData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_USER_DATA, ULConst.PRIORITY_DISABLE, this.onCmdGetUserData.bind(this));
        }
        requestUploadUserData(userId, userData) {
            let config = ULConfig.getConfig();
            let url = config.s_sdk_user_data_save_url;
            let postData = {
                userId: userId,
                data: userData,
            };
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    let responseData = JSON.parse(responseText);
                    if (responseData && responseData.code == 0) {
                        ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                            code: 1,
                            msg: "存档成功",
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                            code: 0,
                            msg: "存档失败",
                        });
                    }
                },
                fail: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_SAVE_USER_DATA_RESULT, {
                        code: 0,
                        msg: "存档超时",
                    });
                },
            });
        }
        requestDownloadUserData(userId) {
            let config = ULConfig.getConfig();
            let url = ULTools.format("%s?userId=%s", config.s_sdk_user_data_get_url, userId);
            ULLog.console.log("ULModuleUserData.requestDownloadUserData", userId);
            ULLog.console.log("  url", url);
            ULTools.httpGet({
                url: url,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    let responseData = JSON.parse(responseText);
                    ULLog.console.log("  ULModuleUserData.requestDownloadUserData success", responseText);
                    if (responseData && responseData.code == 0) {
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                            code: 1,
                            userData: responseData.data,
                            msg: "模拟成功",
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                            code: 0,
                            userData: {},
                            msg: "读取存档失败",
                        });
                    }
                },
                fail: (err) => {
                    ULLog.console.log("  ULModuleUserData.requestDownloadUserData fail", err);
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_DATA_RESULT, {
                        code: 0,
                        userData: {},
                        msg: "读取存档超时",
                    });
                },
            });
        }
        onCmdSaveUserData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let data = e.data;
            let userId = channelInfo.uuid;
            let userData = data.userData;
            if (!userId) {
                ULLog.console.log("ULModuleUserData.onCmdSaveUserData userId not found!");
                return;
            }
            this.requestUploadUserData(userId, userData);
        }
        onCmdGetUserData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let data = e.data;
            let userId = channelInfo.uuid;
            this.requestDownloadUserData(userId);
        }
    }

    class ULClipboardManager {
        static getInstance() {
            if (!this._instance) {
                this._instance = new ULClipboardManager();
            }
            return this._instance;
        }
        getClipboardData(finishCallback) {
            if (!(finishCallback instanceof Function)) {
                ULLog.console.warn("ULClipboardManager.getClipboardData finishCallback not a function");
                return;
            }
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_GET_CLIPBOARD_DATA, {
                finishCallback: finishCallback,
            });
            if (!bCalled) {
                finishCallback(null);
            }
        }
        setClipboardData(data, finishCallback) {
            if (!(finishCallback instanceof Function)) {
                ULLog.console.warn("ULClipboardManager.setClipboardData finishCallback not a function");
                return;
            }
            let bCalled = ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_SET_CLIPBOARD_DATA, {
                data: data,
                finishCallback: finishCallback,
            });
            if (!bCalled) {
                finishCallback(false);
            }
        }
        isSupport() {
            let bSupport = !!ULEventDispatcher.getInstance().dispatchWithReturn(ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD, {});
            return bSupport;
        }
    }
    ULClipboardManager._instance = null;

    class ULModuleClipboard extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleClipboard";
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_CLIPBOARD_DATA, 1, this.onCmdSetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_CLIPBOARD_DATA, 1, this.onCmdGetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
        }
        onCmdSetClipboardData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let clipboardData = data.clipboardData;
            let userData = data.userData;
            ULClipboardManager.getInstance().setClipboardData(clipboardData, (bSuccess) => {
                if (bSuccess) {
                    ULSdkManager.getInstance().response(ULConst.CMD_SET_CLIPBOARD_DATA_RESULT, {
                        code: 1,
                        msg: "保存成功",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_SET_CLIPBOARD_DATA_RESULT, {
                        code: 0,
                        msg: "保存失败",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
            });
        }
        onCmdGetClipboardData(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userData = data.userData;
            ULClipboardManager.getInstance().getClipboardData((clipboardData) => {
                if (clipboardData) {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_CLIPBOARD_DATA_RESULT, {
                        code: 1,
                        msg: "获取成功",
                        clipboardData: clipboardData,
                        userData: userData,
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_CLIPBOARD_DATA_RESULT, {
                        code: 0,
                        msg: "获取失败",
                        clipboardData: null,
                        userData: userData,
                    });
                }
            });
        }
        onCmdSetVersion(e) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isSupportClipboardData = ULClipboardManager.getInstance().isSupport();
            ULLog.console.log(ULTools.format("ULModuleClipboard.onCmdSetVersion mark isSupportClipboardData = %s", channelInfo.isSupportClipboardData));
        }
    }

    class ULModuleDefault extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleDefault";
            this.hadShowAffiche = false;
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CHECK_TIME_CHANGE, 1, (e) => {
                this.checkTimeChange((bChange, serverTime, timeDeferenceLimit) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_CHECK_TIME_CHANGE_RESULT, {
                        bChange: bChange,
                        serverTime: serverTime,
                        timeDeferenceLimit: timeDeferenceLimit
                    }, true);
                });
            });
        }
        checkTimeChange(callback) {
            let config = ULConfig.getConfig();
            let url = config.s_sdk_common_checktime_url;
            let timeout = config.i_net_timeout;
            let deferenceLimit = config.i_sdk_common_checktime_deferenceLimit;
            deferenceLimit = !isNaN(Number(deferenceLimit)) ? Number(deferenceLimit) : 300000;
            if (url) {
                ULTools.httpGet({
                    url: url,
                    timeoutMillisecond: timeout,
                    success: (responseText) => {
                        let serviceTime = !isNaN(Number(responseText)) ? Number(responseText) : 0;
                        let difference = Math.abs(serviceTime - new Date().getTime());
                        console.log("now:", new Date().getTime());
                        console.log("serviceTime:", serviceTime);
                        console.log("difference:", difference);
                        callback(difference > deferenceLimit, serviceTime, deferenceLimit);
                    },
                    fail: () => {
                        callback(true, 0, deferenceLimit);
                    },
                });
            }
            else {
                Promise.resolve().then(() => {
                    callback(false, new Date().getTime(), deferenceLimit);
                });
            }
        }
        onCmdSetVersion(e) {
            if (!this.hadShowAffiche) {
                this.hadShowAffiche = true;
                let config = ULConfig.getConfig();
                let affiche_url = config.s_sdk_common_affiche_url;
                if (affiche_url.length > 5) {
                    let title = config.s_sdk_common_affiche_title || "最新公告";
                    ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(title, affiche_url);
                }
            }
        }
    }

    let hbs = window["hbs"];
    let qg = window["qg"];
    let tt = window["tt"];
    let wx = window["wx"];
    let qq = window["qq"];
    class ULModulePrivacyPolicy extends ULModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModulePrivacyPolicy";
        }
        get isAgreePrivacyPolicy() {
            let value = ULStorageManager.getInstance().getStorage("hadSurePrivacy") || "0";
            return value == "1";
        }
        agreePrivacyPolicy() {
            ULStorageManager.getInstance().setStorage("hadSurePrivacy", "1");
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isAgreePrivacyPolicy = true;
        }
        init() {
            super.init();
            this.initSdk();
        }
        initSdk() {
            ULLog.console.info("ULModulePrivacyPolicy-initSdk");
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.isAgreePrivacyPolicy = this.isAgreePrivacyPolicy;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SHOW_PRIVACY, 1000, this.onCmdShowPrivacy.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_ADVANCED_SETTING, 1000, this.onCmdOpenAdvancedSetting.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
        }
        onCmdOpenAdvancedSetting(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let items = [];
            items.push({
                name: `注销账户`,
                handle: () => {
                    ULSdkManager.getInstance().moduleCheckerManager.alertPrompt2("温馨提示", "注销账户会导致该账户不可用", "知道了", "再想想", () => {
                        localStorage.clear();
                        this.exitGame();
                        localStorage.clear();
                    }, () => {
                    });
                }
            });
            items.push({
                name: `隐私政策界面`,
                handle: () => {
                    ULSdkManager.getInstance().moduleCheckerManager.alertPrivacy("温馨提示", config.t_sdk_privacyPolicy_dataArray, ["返回"], [() => {
                        }]);
                }
            });
            for (let item of config.t_sdk_privacyPolicy_dataArray) {
                items.push({
                    name: `《${item.name}》`,
                    handle: () => {
                        ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(item.name, item.url, item["replaceParam"] || {});
                    }
                });
            }
            ULSdkManager.getInstance().moduleCheckerManager.showSettingView("高级设置", items);
        }
        onCmdSetVersion(e) {
            this.showPrivacyPolicy();
        }
        onCmdShowPrivacy(e) {
            e.stopImmediatePropagation();
            let data = e.data || {};
            let type = data.type || "0";
            let userData = data.userData || "";
            let callback = (code, msg) => {
                ULSdkManager.getInstance().response(ULConst.CMD_SHOW_PRIVACY_RESULT, {
                    code: code,
                    msg: msg,
                    type: type,
                    userData: userData,
                });
            };
            if (!type) {
                callback(0, "type 值错误");
                return;
            }
            let config = ULConfig.getConfig();
            let dataArray = config.t_sdk_privacyPolicy_dataArray || [];
            let index = Math.max(0, Number(type));
            if (index < dataArray.length) {
                let content = dataArray[index];
                ULSdkManager.getInstance().moduleCheckerManager.showPrivacyContent(content.name, content.url, content["replaceParam"] || {});
                callback(1, "执行成功");
            }
            else {
                callback(0, "未找到对应配置");
            }
        }
        showPrivacyPolicy() {
            if (!this.isAgreePrivacyPolicy) {
                let config = ULConfig.getConfig();
                ULSdkManager.getInstance().moduleCheckerManager.alertPrivacy("温馨提示", config.t_sdk_privacyPolicy_dataArray, ["拒绝", "同意"], [() => {
                        this.exitGame();
                        return true;
                    }, () => {
                        this.agreePrivacyPolicy();
                        ULSdkManager.getInstance().waits.removeCondition("privacy_agree");
                    }]);
            }
            else {
                ULSdkManager.getInstance().waits.removeCondition("privacy_agree");
            }
        }
        exitGame() {
            let modeArray = [hbs, qg, tt, wx, qq];
            while (modeArray.length) {
                let mode = modeArray.pop();
                if (mode && mode != 'undefined' && mode.exitApplication) {
                    mode.exitApplication({
                        success: function () {
                            ULLog.console.log("exitApplication success");
                        },
                        fail: function () {
                            ULLog.console.log("exitApplication fail");
                        },
                        complete: function () {
                            ULLog.console.log("exitApplication complete");
                        }
                    });
                }
                else if (mode && mode != 'undefined' && mode.exitMiniProgram) {
                    mode.exitMiniProgram({
                        success: function () {
                            ULLog.console.log("exitMiniProgram success");
                        },
                        fail: function () {
                            ULLog.console.log("exitMiniProgram fail");
                        },
                        complete: function () {
                            ULLog.console.log("exitMiniProgram complete");
                        }
                    });
                }
            }
            ULLog.console.log("未配置 退出游戏 渠道");
        }
    }

    function pkcs1unpad2(d,n) {
      var b = d.toByteArray();
      var i = 0;
      while(i < b.length && b[i] == 0) ++i;
      if(b.length-i != n-1 || b[i] != 2)
        return null;
      ++i;
      while(b[i] != 0)
        if(++i >= b.length) return null;
      var ret = "";
      while(++i < b.length) {
        var c = b[i] & 255;
        if(c < 128) { // utf-8 decode
          ret += String.fromCharCode(c);
        }
        else if((c > 191) && (c < 224)) {
          ret += String.fromCharCode(((c & 31) << 6) | (b[i+1] & 63));
          ++i;
        }
        else {
          ret += String.fromCharCode(((c & 15) << 12) | ((b[i+1] & 63) << 6) | (b[i+2] & 63));
          i += 2;
        }
      }
      return ret;
    }

    // PKCS#1 (OAEP) mask generation function
    function oaep_mgf1_str(seed, len, hash)
    {
        var mask = '', i = 0;

        while (mask.length < len)
        {
            mask += hash(seed + String.fromCharCode.apply(String, [
                    (i & 0xff000000) >> 24,
                    (i & 0x00ff0000) >> 16,
                    (i & 0x0000ff00) >> 8,
                    i & 0x000000ff]));
            i += 1;
        }

        return mask;
    }

    function oaep_unpad(d, n, hash, hashLen) {
        var MD = KJUR.crypto.MessageDigest;
        var Util = KJUR.crypto.Util;
        var algName = null;

        if (!hash) hash = "sha1";

        if (typeof hash === "string") {
            algName = MD.getCanonicalAlgName(hash);
            hashLen = MD.getHashLength(algName);
            hash = function(s) {
                return hextorstr(Util.hashHex(rstrtohex(s), algName));
            };
        }

        d = d.toByteArray();

        var i;

        for (i = 0; i < d.length; i += 1) {
            d[i] &= 0xff;
        }

        while (d.length < n) {
            d.unshift(0);
        }

        d = String.fromCharCode.apply(String, d);

        if (d.length < 2 * hashLen + 2) {
            throw "Cipher too short";
        }

        var maskedSeed = d.substr(1, hashLen);
        var maskedDB = d.substr(hashLen + 1);

        var seedMask = oaep_mgf1_str(maskedDB, hashLen, hash);
        var seed = [], i;

        for (i = 0; i < maskedSeed.length; i += 1) {
            seed[i] = maskedSeed.charCodeAt(i) ^ seedMask.charCodeAt(i);
        }

        var dbMask = oaep_mgf1_str(String.fromCharCode.apply(String, seed),
                                   d.length - hashLen, hash);

        var DB = [];

        for (i = 0; i < maskedDB.length; i += 1) {
            DB[i] = maskedDB.charCodeAt(i) ^ dbMask.charCodeAt(i);
        }

        DB = String.fromCharCode.apply(String, DB);

        if (DB.substr(0, hashLen) !== hash('')) {
            throw "Hash mismatch";
        }

        DB = DB.substr(hashLen);

        var first_one = DB.indexOf('\x01');
        var last_zero = (first_one != -1) ? DB.substr(0, first_one).lastIndexOf('\x00') : -1;

        if (last_zero + 1 != first_one) {
            throw "Malformed data";
        }

        return DB.substr(first_one + 1);
    }

    // Set the private key fields N, e, and d from hex strings
    function RSASetPrivate(N,E,D) {
      this.isPrivate = true;
      if (typeof N !== "string")
      {
        this.n = N;
        this.e = E;
        this.d = D;
      }
      else if(N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N,16);
        this.e = parseInt(E,16);
        this.d = parseBigInt(D,16);
      }
      else
        throw "Invalid RSA private key";
    }

    // Set the private key fields N, e, d and CRT params from hex strings
    function RSASetPrivateEx(N,E,D,P,Q,DP,DQ,C) {
      this.isPrivate = true;
      this.isPublic = false;
      if (N == null) throw "RSASetPrivateEx N == null";
      if (E == null) throw "RSASetPrivateEx E == null";
      if (N.length == 0) throw "RSASetPrivateEx N.length == 0";
      if (E.length == 0) throw "RSASetPrivateEx E.length == 0";

      if (N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N,16);
        this.e = parseInt(E,16);
        this.d = parseBigInt(D,16);
        this.p = parseBigInt(P,16);
        this.q = parseBigInt(Q,16);
        this.dmp1 = parseBigInt(DP,16);
        this.dmq1 = parseBigInt(DQ,16);
        this.coeff = parseBigInt(C,16);
      } else {
        throw "Invalid RSA private key in RSASetPrivateEx";
      }
    }

    // Generate a new random private key B bits long, using public expt E
    function RSAGenerate(B,E) {
      var rng = new SecureRandom();
      var qs = B>>1;
      this.e = parseInt(E,16);
      var ee = new BigInteger(E,16);
      for(;;) {
        for(;;) {
          this.p = new BigInteger(B-qs,1,rng);
          if(this.p.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) == 0 && this.p.isProbablePrime(10)) break;
        }
        for(;;) {
          this.q = new BigInteger(qs,1,rng);
          if(this.q.subtract(BigInteger.ONE).gcd(ee).compareTo(BigInteger.ONE) == 0 && this.q.isProbablePrime(10)) break;
        }
        if(this.p.compareTo(this.q) <= 0) {
          var t = this.p;
          this.p = this.q;
          this.q = t;
        }
        var p1 = this.p.subtract(BigInteger.ONE); // p1 = p - 1
        var q1 = this.q.subtract(BigInteger.ONE); // q1 = q - 1
        var phi = p1.multiply(q1);
        if(phi.gcd(ee).compareTo(BigInteger.ONE) == 0) {
          this.n = this.p.multiply(this.q); // this.n = p * q
          this.d = ee.modInverse(phi);  // this.d = 
          this.dmp1 = this.d.mod(p1); // this.dmp1 = d mod (p - 1)
          this.dmq1 = this.d.mod(q1); // this.dmq1 = d mod (q - 1)
          this.coeff = this.q.modInverse(this.p); // this.coeff = (q ^ -1) mod p
          break;
        }
      }
      this.isPrivate = true;
    }

    // Perform raw private operation on "x": return x^d (mod n)
    function RSADoPrivate(x) {
      if(this.p == null || this.q == null)
        return x.modPow(this.d, this.n);

      // TODO: re-calculate any missing CRT params
      var xp = x.mod(this.p).modPow(this.dmp1, this.p); // xp=cp?
      var xq = x.mod(this.q).modPow(this.dmq1, this.q); // xq=cq?

      while(xp.compareTo(xq) < 0)
        xp = xp.add(this.p);
      return xp.subtract(xq).multiply(this.coeff).mod(this.p).multiply(this.q).add(xq);
    }

    function RSADecrypt(ctext) {
      var c = parseBigInt(ctext, 16);
      var m = this.doPrivate(c);
      if(m == null) return null;
      return pkcs1unpad2(m, (this.n.bitLength()+7)>>3);
    }

    function RSADecryptOAEP(ctext, hash, hashLen) {
      var c = parseBigInt(ctext, 16);
      var m = this.doPrivate(c);
      if(m == null) return null;
      return oaep_unpad(m, (this.n.bitLength()+7)>>3, hash, hashLen);
    }

    // protected
    RSAKey.prototype.doPrivate = RSADoPrivate;

    // public
    RSAKey.prototype.setPrivate = RSASetPrivate;
    RSAKey.prototype.setPrivateEx = RSASetPrivateEx;
    RSAKey.prototype.generate = RSAGenerate;
    RSAKey.prototype.decrypt = RSADecrypt;
    RSAKey.prototype.decryptOAEP = RSADecryptOAEP;
    //RSAKey.prototype.b64_decrypt = RSAB64Decrypt;

    // (public)
    function bnClone() { var r = nbi(); this.copyTo(r); return r; }

    // (public) return value as integer
    function bnIntValue() {
      if(this.s < 0) {
        if(this.t == 1) return this[0]-this.DV;
        else if(this.t == 0) return -1;
      }
      else if(this.t == 1) return this[0];
      else if(this.t == 0) return 0;
      // assumes 16 < DB < 32
      return ((this[1]&((1<<(32-this.DB))-1))<<this.DB)|this[0];
    }

    // (public) return value as byte
    function bnByteValue() { return (this.t==0)?this.s:(this[0]<<24)>>24; }

    // (public) return value as short (assumes DB>=16)
    function bnShortValue() { return (this.t==0)?this.s:(this[0]<<16)>>16; }

    // (protected) return x s.t. r^x < DV
    function bnpChunkSize(r) { return Math.floor(Math.LN2*this.DB/Math.log(r)); }

    // (public) 0 if this == 0, 1 if this > 0
    function bnSigNum() {
      if(this.s < 0) return -1;
      else if(this.t <= 0 || (this.t == 1 && this[0] <= 0)) return 0;
      else return 1;
    }

    // (protected) convert to radix string
    function bnpToRadix(b) {
      if(b == null) b = 10;
      if(this.signum() == 0 || b < 2 || b > 36) return "0";
      var cs = this.chunkSize(b);
      var a = Math.pow(b,cs);
      var d = nbv(a), y = nbi(), z = nbi(), r = "";
      this.divRemTo(d,y,z);
      while(y.signum() > 0) {
        r = (a+z.intValue()).toString(b).substr(1) + r;
        y.divRemTo(d,y,z);
      }
      return z.intValue().toString(b) + r;
    }

    // (protected) convert from radix string
    function bnpFromRadix(s,b) {
      this.fromInt(0);
      if(b == null) b = 10;
      var cs = this.chunkSize(b);
      var d = Math.pow(b,cs), mi = false, j = 0, w = 0;
      for(var i = 0; i < s.length; ++i) {
        var x = intAt(s,i);
        if(x < 0) {
          if(s.charAt(i) == "-" && this.signum() == 0) mi = true;
          continue;
        }
        w = b*w+x;
        if(++j >= cs) {
          this.dMultiply(d);
          this.dAddOffset(w,0);
          j = 0;
          w = 0;
        }
      }
      if(j > 0) {
        this.dMultiply(Math.pow(b,j));
        this.dAddOffset(w,0);
      }
      if(mi) BigInteger.ZERO.subTo(this,this);
    }

    // (protected) alternate constructor
    function bnpFromNumber(a,b,c) {
      if("number" == typeof b) {
        // new BigInteger(int,int,RNG)
        if(a < 2) this.fromInt(1);
        else {
          this.fromNumber(a,c);
          if(!this.testBit(a-1))  // force MSB set
            this.bitwiseTo(BigInteger.ONE.shiftLeft(a-1),op_or,this);
          if(this.isEven()) this.dAddOffset(1,0); // force odd
          while(!this.isProbablePrime(b)) {
            this.dAddOffset(2,0);
            if(this.bitLength() > a) this.subTo(BigInteger.ONE.shiftLeft(a-1),this);
          }
        }
      }
      else {
        // new BigInteger(int,RNG)
        var x = new Array(), t = a&7;
        x.length = (a>>3)+1;
        b.nextBytes(x);
        if(t > 0) x[0] &= ((1<<t)-1); else x[0] = 0;
        this.fromString(x,256);
      }
    }

    // (public) convert to bigendian byte array
    function bnToByteArray() {
      var i = this.t, r = new Array();
      r[0] = this.s;
      var p = this.DB-(i*this.DB)%8, d, k = 0;
      if(i-- > 0) {
        if(p < this.DB && (d = this[i]>>p) != (this.s&this.DM)>>p)
          r[k++] = d|(this.s<<(this.DB-p));
        while(i >= 0) {
          if(p < 8) {
            d = (this[i]&((1<<p)-1))<<(8-p);
            d |= this[--i]>>(p+=this.DB-8);
          }
          else {
            d = (this[i]>>(p-=8))&0xff;
            if(p <= 0) { p += this.DB; --i; }
          }
          if((d&0x80) != 0) d |= -256;
          if(k == 0 && (this.s&0x80) != (d&0x80)) ++k;
          if(k > 0 || d != this.s) r[k++] = d;
        }
      }
      return r;
    }

    function bnEquals(a) { return(this.compareTo(a)==0); }
    function bnMin(a) { return (this.compareTo(a)<0)?this:a; }
    function bnMax(a) { return (this.compareTo(a)>0)?this:a; }

    // (protected) r = this op a (bitwise)
    function bnpBitwiseTo(a,op,r) {
      var i, f, m = Math.min(a.t,this.t);
      for(i = 0; i < m; ++i) r[i] = op(this[i],a[i]);
      if(a.t < this.t) {
        f = a.s&this.DM;
        for(i = m; i < this.t; ++i) r[i] = op(this[i],f);
        r.t = this.t;
      }
      else {
        f = this.s&this.DM;
        for(i = m; i < a.t; ++i) r[i] = op(f,a[i]);
        r.t = a.t;
      }
      r.s = op(this.s,a.s);
      r.clamp();
    }

    // (public) this & a
    function op_and(x,y) { return x&y; }
    function bnAnd(a) { var r = nbi(); this.bitwiseTo(a,op_and,r); return r; }

    // (public) this | a
    function op_or(x,y) { return x|y; }
    function bnOr(a) { var r = nbi(); this.bitwiseTo(a,op_or,r); return r; }

    // (public) this ^ a
    function op_xor(x,y) { return x^y; }
    function bnXor(a) { var r = nbi(); this.bitwiseTo(a,op_xor,r); return r; }

    // (public) this & ~a
    function op_andnot(x,y) { return x&~y; }
    function bnAndNot(a) { var r = nbi(); this.bitwiseTo(a,op_andnot,r); return r; }

    // (public) ~this
    function bnNot() {
      var r = nbi();
      for(var i = 0; i < this.t; ++i) r[i] = this.DM&~this[i];
      r.t = this.t;
      r.s = ~this.s;
      return r;
    }

    // (public) this << n
    function bnShiftLeft(n) {
      var r = nbi();
      if(n < 0) this.rShiftTo(-n,r); else this.lShiftTo(n,r);
      return r;
    }

    // (public) this >> n
    function bnShiftRight(n) {
      var r = nbi();
      if(n < 0) this.lShiftTo(-n,r); else this.rShiftTo(n,r);
      return r;
    }

    // return index of lowest 1-bit in x, x < 2^31
    function lbit(x) {
      if(x == 0) return -1;
      var r = 0;
      if((x&0xffff) == 0) { x >>= 16; r += 16; }
      if((x&0xff) == 0) { x >>= 8; r += 8; }
      if((x&0xf) == 0) { x >>= 4; r += 4; }
      if((x&3) == 0) { x >>= 2; r += 2; }
      if((x&1) == 0) ++r;
      return r;
    }

    // (public) returns index of lowest 1-bit (or -1 if none)
    function bnGetLowestSetBit() {
      for(var i = 0; i < this.t; ++i)
        if(this[i] != 0) return i*this.DB+lbit(this[i]);
      if(this.s < 0) return this.t*this.DB;
      return -1;
    }

    // return number of 1 bits in x
    function cbit(x) {
      var r = 0;
      while(x != 0) { x &= x-1; ++r; }
      return r;
    }

    // (public) return number of set bits
    function bnBitCount() {
      var r = 0, x = this.s&this.DM;
      for(var i = 0; i < this.t; ++i) r += cbit(this[i]^x);
      return r;
    }

    // (public) true iff nth bit is set
    function bnTestBit(n) {
      var j = Math.floor(n/this.DB);
      if(j >= this.t) return(this.s!=0);
      return((this[j]&(1<<(n%this.DB)))!=0);
    }

    // (protected) this op (1<<n)
    function bnpChangeBit(n,op) {
      var r = BigInteger.ONE.shiftLeft(n);
      this.bitwiseTo(r,op,r);
      return r;
    }

    // (public) this | (1<<n)
    function bnSetBit(n) { return this.changeBit(n,op_or); }

    // (public) this & ~(1<<n)
    function bnClearBit(n) { return this.changeBit(n,op_andnot); }

    // (public) this ^ (1<<n)
    function bnFlipBit(n) { return this.changeBit(n,op_xor); }

    // (protected) r = this + a
    function bnpAddTo(a,r) {
      var i = 0, c = 0, m = Math.min(a.t,this.t);
      while(i < m) {
        c += this[i]+a[i];
        r[i++] = c&this.DM;
        c >>= this.DB;
      }
      if(a.t < this.t) {
        c += a.s;
        while(i < this.t) {
          c += this[i];
          r[i++] = c&this.DM;
          c >>= this.DB;
        }
        c += this.s;
      }
      else {
        c += this.s;
        while(i < a.t) {
          c += a[i];
          r[i++] = c&this.DM;
          c >>= this.DB;
        }
        c += a.s;
      }
      r.s = (c<0)?-1:0;
      if(c > 0) r[i++] = c;
      else if(c < -1) r[i++] = this.DV+c;
      r.t = i;
      r.clamp();
    }

    // (public) this + a
    function bnAdd(a) { var r = nbi(); this.addTo(a,r); return r; }

    // (public) this - a
    function bnSubtract(a) { var r = nbi(); this.subTo(a,r); return r; }

    // (public) this * a
    function bnMultiply(a) { var r = nbi(); this.multiplyTo(a,r); return r; }

    // (public) this^2
    function bnSquare() { var r = nbi(); this.squareTo(r); return r; }

    // (public) this / a
    function bnDivide(a) { var r = nbi(); this.divRemTo(a,r,null); return r; }

    // (public) this % a
    function bnRemainder(a) { var r = nbi(); this.divRemTo(a,null,r); return r; }

    // (public) [this/a,this%a]
    function bnDivideAndRemainder(a) {
      var q = nbi(), r = nbi();
      this.divRemTo(a,q,r);
      return new Array(q,r);
    }

    // (protected) this *= n, this >= 0, 1 < n < DV
    function bnpDMultiply(n) {
      this[this.t] = this.am(0,n-1,this,0,0,this.t);
      ++this.t;
      this.clamp();
    }

    // (protected) this += n << w words, this >= 0
    function bnpDAddOffset(n,w) {
      if(n == 0) return;
      while(this.t <= w) this[this.t++] = 0;
      this[w] += n;
      while(this[w] >= this.DV) {
        this[w] -= this.DV;
        if(++w >= this.t) this[this.t++] = 0;
        ++this[w];
      }
    }

    // A "null" reducer
    function NullExp() {}
    function nNop(x) { return x; }
    function nMulTo(x,y,r) { x.multiplyTo(y,r); }
    function nSqrTo(x,r) { x.squareTo(r); }

    NullExp.prototype.convert = nNop;
    NullExp.prototype.revert = nNop;
    NullExp.prototype.mulTo = nMulTo;
    NullExp.prototype.sqrTo = nSqrTo;

    // (public) this^e
    function bnPow(e) { return this.exp(e,new NullExp()); }

    // (protected) r = lower n words of "this * a", a.t <= n
    // "this" should be the larger one if appropriate.
    function bnpMultiplyLowerTo(a,n,r) {
      var i = Math.min(this.t+a.t,n);
      r.s = 0; // assumes a,this >= 0
      r.t = i;
      while(i > 0) r[--i] = 0;
      var j;
      for(j = r.t-this.t; i < j; ++i) r[i+this.t] = this.am(0,a[i],r,i,0,this.t);
      for(j = Math.min(a.t,n); i < j; ++i) this.am(0,a[i],r,i,0,n-i);
      r.clamp();
    }

    // (protected) r = "this * a" without lower n words, n > 0
    // "this" should be the larger one if appropriate.
    function bnpMultiplyUpperTo(a,n,r) {
      --n;
      var i = r.t = this.t+a.t-n;
      r.s = 0; // assumes a,this >= 0
      while(--i >= 0) r[i] = 0;
      for(i = Math.max(n-this.t,0); i < a.t; ++i)
        r[this.t+i-n] = this.am(n-i,a[i],r,0,0,this.t+i-n);
      r.clamp();
      r.drShiftTo(1,r);
    }

    // Barrett modular reduction
    function Barrett(m) {
      // setup Barrett
      this.r2 = nbi();
      this.q3 = nbi();
      BigInteger.ONE.dlShiftTo(2*m.t,this.r2);
      this.mu = this.r2.divide(m);
      this.m = m;
    }

    function barrettConvert(x) {
      if(x.s < 0 || x.t > 2*this.m.t) return x.mod(this.m);
      else if(x.compareTo(this.m) < 0) return x;
      else { var r = nbi(); x.copyTo(r); this.reduce(r); return r; }
    }

    function barrettRevert(x) { return x; }

    // x = x mod m (HAC 14.42)
    function barrettReduce(x) {
      x.drShiftTo(this.m.t-1,this.r2);
      if(x.t > this.m.t+1) { x.t = this.m.t+1; x.clamp(); }
      this.mu.multiplyUpperTo(this.r2,this.m.t+1,this.q3);
      this.m.multiplyLowerTo(this.q3,this.m.t+1,this.r2);
      while(x.compareTo(this.r2) < 0) x.dAddOffset(1,this.m.t+1);
      x.subTo(this.r2,x);
      while(x.compareTo(this.m) >= 0) x.subTo(this.m,x);
    }

    // r = x^2 mod m; x != r
    function barrettSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

    // r = x*y mod m; x,y != r
    function barrettMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }

    Barrett.prototype.convert = barrettConvert;
    Barrett.prototype.revert = barrettRevert;
    Barrett.prototype.reduce = barrettReduce;
    Barrett.prototype.mulTo = barrettMulTo;
    Barrett.prototype.sqrTo = barrettSqrTo;

    // (public) this^e % m (HAC 14.85)
    function bnModPow(e,m) {
      var i = e.bitLength(), k, r = nbv(1), z;
      if(i <= 0) return r;
      else if(i < 18) k = 1;
      else if(i < 48) k = 3;
      else if(i < 144) k = 4;
      else if(i < 768) k = 5;
      else k = 6;
      if(i < 8)
        z = new Classic(m);
      else if(m.isEven())
        z = new Barrett(m);
      else
        z = new Montgomery(m);

      // precomputation
      var g = new Array(), n = 3, k1 = k-1, km = (1<<k)-1;
      g[1] = z.convert(this);
      if(k > 1) {
        var g2 = nbi();
        z.sqrTo(g[1],g2);
        while(n <= km) {
          g[n] = nbi();
          z.mulTo(g2,g[n-2],g[n]);
          n += 2;
        }
      }

      var j = e.t-1, w, is1 = true, r2 = nbi(), t;
      i = nbits(e[j])-1;
      while(j >= 0) {
        if(i >= k1) w = (e[j]>>(i-k1))&km;
        else {
          w = (e[j]&((1<<(i+1))-1))<<(k1-i);
          if(j > 0) w |= e[j-1]>>(this.DB+i-k1);
        }

        n = k;
        while((w&1) == 0) { w >>= 1; --n; }
        if((i -= n) < 0) { i += this.DB; --j; }
        if(is1) { // ret == 1, don't bother squaring or multiplying it
          g[w].copyTo(r);
          is1 = false;
        }
        else {
          while(n > 1) { z.sqrTo(r,r2); z.sqrTo(r2,r); n -= 2; }
          if(n > 0) z.sqrTo(r,r2); else { t = r; r = r2; r2 = t; }
          z.mulTo(r2,g[w],r);
        }

        while(j >= 0 && (e[j]&(1<<i)) == 0) {
          z.sqrTo(r,r2); t = r; r = r2; r2 = t;
          if(--i < 0) { i = this.DB-1; --j; }
        }
      }
      return z.revert(r);
    }

    // (public) gcd(this,a) (HAC 14.54)
    function bnGCD(a) {
      var x = (this.s<0)?this.negate():this.clone();
      var y = (a.s<0)?a.negate():a.clone();
      if(x.compareTo(y) < 0) { var t = x; x = y; y = t; }
      var i = x.getLowestSetBit(), g = y.getLowestSetBit();
      if(g < 0) return x;
      if(i < g) g = i;
      if(g > 0) {
        x.rShiftTo(g,x);
        y.rShiftTo(g,y);
      }
      while(x.signum() > 0) {
        if((i = x.getLowestSetBit()) > 0) x.rShiftTo(i,x);
        if((i = y.getLowestSetBit()) > 0) y.rShiftTo(i,y);
        if(x.compareTo(y) >= 0) {
          x.subTo(y,x);
          x.rShiftTo(1,x);
        }
        else {
          y.subTo(x,y);
          y.rShiftTo(1,y);
        }
      }
      if(g > 0) y.lShiftTo(g,y);
      return y;
    }

    // (protected) this % n, n < 2^26
    function bnpModInt(n) {
      if(n <= 0) return 0;
      var d = this.DV%n, r = (this.s<0)?n-1:0;
      if(this.t > 0)
        if(d == 0) r = this[0]%n;
        else for(var i = this.t-1; i >= 0; --i) r = (d*r+this[i])%n;
      return r;
    }

    // (public) 1/this % m (HAC 14.61)
    function bnModInverse(m) {
      var ac = m.isEven();
      if((this.isEven() && ac) || m.signum() == 0) return BigInteger.ZERO;
      var u = m.clone(), v = this.clone();
      var a = nbv(1), b = nbv(0), c = nbv(0), d = nbv(1);
      while(u.signum() != 0) {
        while(u.isEven()) {
          u.rShiftTo(1,u);
          if(ac) {
            if(!a.isEven() || !b.isEven()) { a.addTo(this,a); b.subTo(m,b); }
            a.rShiftTo(1,a);
          }
          else if(!b.isEven()) b.subTo(m,b);
          b.rShiftTo(1,b);
        }
        while(v.isEven()) {
          v.rShiftTo(1,v);
          if(ac) {
            if(!c.isEven() || !d.isEven()) { c.addTo(this,c); d.subTo(m,d); }
            c.rShiftTo(1,c);
          }
          else if(!d.isEven()) d.subTo(m,d);
          d.rShiftTo(1,d);
        }
        if(u.compareTo(v) >= 0) {
          u.subTo(v,u);
          if(ac) a.subTo(c,a);
          b.subTo(d,b);
        }
        else {
          v.subTo(u,v);
          if(ac) c.subTo(a,c);
          d.subTo(b,d);
        }
      }
      if(v.compareTo(BigInteger.ONE) != 0) return BigInteger.ZERO;
      if(d.compareTo(m) >= 0) return d.subtract(m);
      if(d.signum() < 0) d.addTo(m,d); else return d;
      if(d.signum() < 0) return d.add(m); else return d;
    }

    var lowprimes = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997];
    var lplim = (1<<26)/lowprimes[lowprimes.length-1];

    // (public) test primality with certainty >= 1-.5^t
    function bnIsProbablePrime(t) {
      var i, x = this.abs();
      if(x.t == 1 && x[0] <= lowprimes[lowprimes.length-1]) {
        for(i = 0; i < lowprimes.length; ++i)
          if(x[0] == lowprimes[i]) return true;
        return false;
      }
      if(x.isEven()) return false;
      i = 1;
      while(i < lowprimes.length) {
        var m = lowprimes[i], j = i+1;
        while(j < lowprimes.length && m < lplim) m *= lowprimes[j++];
        m = x.modInt(m);
        while(i < j) if(m%lowprimes[i++] == 0) return false;
      }
      return x.millerRabin(t);
    }

    // (protected) true if probably prime (HAC 4.24, Miller-Rabin)
    function bnpMillerRabin(t) {
      var n1 = this.subtract(BigInteger.ONE);
      var k = n1.getLowestSetBit();
      if(k <= 0) return false;
      var r = n1.shiftRight(k);
      t = (t+1)>>1;
      if(t > lowprimes.length) t = lowprimes.length;
      var a = nbi();
      for(var i = 0; i < t; ++i) {
        //Pick bases at random, instead of starting at 2
        a.fromInt(lowprimes[Math.floor(Math.random()*lowprimes.length)]);
        var y = a.modPow(r,this);
        if(y.compareTo(BigInteger.ONE) != 0 && y.compareTo(n1) != 0) {
          var j = 1;
          while(j++ < k && y.compareTo(n1) != 0) {
            y = y.modPowInt(2,this);
            if(y.compareTo(BigInteger.ONE) == 0) return false;
          }
          if(y.compareTo(n1) != 0) return false;
        }
      }
      return true;
    }

    // protected
    BigInteger.prototype.chunkSize = bnpChunkSize;
    BigInteger.prototype.toRadix = bnpToRadix;
    BigInteger.prototype.fromRadix = bnpFromRadix;
    BigInteger.prototype.fromNumber = bnpFromNumber;
    BigInteger.prototype.bitwiseTo = bnpBitwiseTo;
    BigInteger.prototype.changeBit = bnpChangeBit;
    BigInteger.prototype.addTo = bnpAddTo;
    BigInteger.prototype.dMultiply = bnpDMultiply;
    BigInteger.prototype.dAddOffset = bnpDAddOffset;
    BigInteger.prototype.multiplyLowerTo = bnpMultiplyLowerTo;
    BigInteger.prototype.multiplyUpperTo = bnpMultiplyUpperTo;
    BigInteger.prototype.modInt = bnpModInt;
    BigInteger.prototype.millerRabin = bnpMillerRabin;

    // public
    BigInteger.prototype.clone = bnClone;
    BigInteger.prototype.intValue = bnIntValue;
    BigInteger.prototype.byteValue = bnByteValue;
    BigInteger.prototype.shortValue = bnShortValue;
    BigInteger.prototype.signum = bnSigNum;
    BigInteger.prototype.toByteArray = bnToByteArray;
    BigInteger.prototype.equals = bnEquals;
    BigInteger.prototype.min = bnMin;
    BigInteger.prototype.max = bnMax;
    BigInteger.prototype.and = bnAnd;
    BigInteger.prototype.or = bnOr;
    BigInteger.prototype.xor = bnXor;
    BigInteger.prototype.andNot = bnAndNot;
    BigInteger.prototype.not = bnNot;
    BigInteger.prototype.shiftLeft = bnShiftLeft;
    BigInteger.prototype.shiftRight = bnShiftRight;
    BigInteger.prototype.getLowestSetBit = bnGetLowestSetBit;
    BigInteger.prototype.bitCount = bnBitCount;
    BigInteger.prototype.testBit = bnTestBit;
    BigInteger.prototype.setBit = bnSetBit;
    BigInteger.prototype.clearBit = bnClearBit;
    BigInteger.prototype.flipBit = bnFlipBit;
    BigInteger.prototype.add = bnAdd;
    BigInteger.prototype.subtract = bnSubtract;
    BigInteger.prototype.multiply = bnMultiply;
    BigInteger.prototype.divide = bnDivide;
    BigInteger.prototype.remainder = bnRemainder;
    BigInteger.prototype.divideAndRemainder = bnDivideAndRemainder;
    BigInteger.prototype.modPow = bnModPow;
    BigInteger.prototype.modInverse = bnModInverse;
    BigInteger.prototype.pow = bnPow;
    BigInteger.prototype.gcd = bnGCD;
    BigInteger.prototype.isProbablePrime = bnIsProbablePrime;

    // JSBN-specific extension
    BigInteger.prototype.square = bnSquare;



    if (YAHOO === undefined) {var YAHOO = {};}
    YAHOO.lang = {
        /**
         * Utility to set up the prototype, constructor and superclass properties to
         * support an inheritance strategy that can chain constructors and methods.
         * Static members will not be inherited.
         *
         * @method extend
         * @static
         * @param {Function} subc   the object to modify
         * @param {Function} superc the object to inherit
         * @param {Object} overrides  additional properties/methods to add to the
         *                              subclass prototype.  These will override the
         *                              matching items obtained from the superclass
         *                              if present.
         */
        extend: function(subc, superc, overrides) {
      if (! superc || ! subc) {
                throw new Error("YAHOO.lang.extend failed, please check that " +
                                "all dependencies are included.");
      }
      
      var F = function() {};
      F.prototype = superc.prototype;
      subc.prototype = new F();
      subc.prototype.constructor = subc;
      subc.superclass = superc.prototype;
         
      if (superc.prototype.constructor == Object.prototype.constructor) {
                superc.prototype.constructor = superc;
      }
     
      if (overrides) {
          var i;
                for (i in overrides) {
        subc.prototype[i] = overrides[i];
                }

          var _IEEnumFix = function() {},
        ADD = ["toString", "valueOf"];
          try {
        if (/MSIE/.test(navigator.userAgent)) {
            _IEEnumFix = function(r, s) {
          for (i = 0; i < ADD.length; i = i + 1) {
              var fname = ADD[i], f = s[fname];
              if (typeof f === 'function' && f != Object.prototype[fname]) {
            r[fname] = f;
              }
          }
            };
        }
          } catch (ex) {};
                _IEEnumFix(subc.prototype, overrides);
      }
        }
    };

    if (typeof KJUR == "undefined" || !KJUR) KJUR = {};

    if (typeof KJUR.asn1 == "undefined" || !KJUR.asn1) KJUR.asn1 = {};

    /**
     * ASN1 utilities class
     * @name KJUR.asn1.ASN1Util
     * @class ASN1 utilities class
     * @since asn1 1.0.2
     */
    KJUR.asn1.ASN1Util = new function() {
        this.integerToByteHex = function(i) {
            var h = i.toString(16);
            if ((h.length % 2) == 1) h = '0' + h;
            return h;
        };
        this.bigIntToMinTwosComplementsHex = function(bigIntegerValue) {
            var h = bigIntegerValue.toString(16);
            if (h.substr(0, 1) != '-') {
                if (h.length % 2 == 1) {
                    h = '0' + h;
                } else {
                    if (! h.match(/^[0-7]/)) {
                        h = '00' + h;
                    }
                }
            } else {
                var hPos = h.substr(1);
                var xorLen = hPos.length;
                if (xorLen % 2 == 1) {
                    xorLen += 1;
                } else {
                    if (! h.match(/^[0-7]/)) {
                        xorLen += 2;
                    }
                }
                var hMask = '';
                for (var i = 0; i < xorLen; i++) {
                    hMask += 'f';
                }
                var biMask = new BigInteger(hMask, 16);
                var biNeg = biMask.xor(bigIntegerValue).add(BigInteger.ONE);
                h = biNeg.toString(16).replace(/^-/, '');
            }
            return h;
        };
       
        this.getPEMStringFromHex = function(dataHex, pemHeader) {
      return hextopem(dataHex, pemHeader);
        };

        this.newObject = function(param) {
      var _KJUR = KJUR,
          _KJUR_asn1 = _KJUR.asn1,
          _DERBoolean = _KJUR_asn1.DERBoolean,
          _DERInteger = _KJUR_asn1.DERInteger,
          _DERBitString = _KJUR_asn1.DERBitString,
          _DEROctetString = _KJUR_asn1.DEROctetString,
          _DERNull = _KJUR_asn1.DERNull,
          _DERObjectIdentifier = _KJUR_asn1.DERObjectIdentifier,
          _DEREnumerated = _KJUR_asn1.DEREnumerated,
          _DERUTF8String = _KJUR_asn1.DERUTF8String,
          _DERNumericString = _KJUR_asn1.DERNumericString,
          _DERPrintableString = _KJUR_asn1.DERPrintableString,
          _DERTeletexString = _KJUR_asn1.DERTeletexString,
          _DERIA5String = _KJUR_asn1.DERIA5String,
          _DERUTCTime = _KJUR_asn1.DERUTCTime,
          _DERGeneralizedTime = _KJUR_asn1.DERGeneralizedTime,
          _DERSequence = _KJUR_asn1.DERSequence,
          _DERSet = _KJUR_asn1.DERSet,
          _DERTaggedObject = _KJUR_asn1.DERTaggedObject,
          _newObject = _KJUR_asn1.ASN1Util.newObject;

            var keys = Object.keys(param);
            if (keys.length != 1)
                throw "key of param shall be only one.";
            var key = keys[0];

            if (":bool:int:bitstr:octstr:null:oid:enum:utf8str:numstr:prnstr:telstr:ia5str:utctime:gentime:seq:set:tag:".indexOf(":" + key + ":") == -1)
                throw "undefined key: " + key;

            if (key == "bool")    return new _DERBoolean(param[key]);
            if (key == "int")     return new _DERInteger(param[key]);
            if (key == "bitstr")  return new _DERBitString(param[key]);
            if (key == "octstr")  return new _DEROctetString(param[key]);
            if (key == "null")    return new _DERNull(param[key]);
            if (key == "oid")     return new _DERObjectIdentifier(param[key]);
            if (key == "enum")    return new _DEREnumerated(param[key]);
            if (key == "utf8str") return new _DERUTF8String(param[key]);
            if (key == "numstr")  return new _DERNumericString(param[key]);
            if (key == "prnstr")  return new _DERPrintableString(param[key]);
            if (key == "telstr")  return new _DERTeletexString(param[key]);
            if (key == "ia5str")  return new _DERIA5String(param[key]);
            if (key == "utctime") return new _DERUTCTime(param[key]);
            if (key == "gentime") return new _DERGeneralizedTime(param[key]);

            if (key == "seq") {
                var paramList = param[key];
                var a = [];
                for (var i = 0; i < paramList.length; i++) {
                    var asn1Obj = _newObject(paramList[i]);
                    a.push(asn1Obj);
                }
                return new _DERSequence({'array': a});
            }

            if (key == "set") {
                var paramList = param[key];
                var a = [];
                for (var i = 0; i < paramList.length; i++) {
                    var asn1Obj = _newObject(paramList[i]);
                    a.push(asn1Obj);
                }
                return new _DERSet({'array': a});
            }

            if (key == "tag") {
                var tagParam = param[key];
                if (Object.prototype.toString.call(tagParam) === '[object Array]' &&
                    tagParam.length == 3) {
                    var obj = _newObject(tagParam[2]);
                    return new _DERTaggedObject({tag: tagParam[0],
                   explicit: tagParam[1],
                   obj: obj});
                } else {
                    var newParam = {};
                    if (tagParam.explicit !== undefined)
                        newParam.explicit = tagParam.explicit;
                    if (tagParam.tag !== undefined)
                        newParam.tag = tagParam.tag;
                    if (tagParam.obj === undefined)
                        throw "obj shall be specified for 'tag'.";
                    newParam.obj = _newObject(tagParam.obj);
                    return new _DERTaggedObject(newParam);
                }
            }
        };

        this.jsonToASN1HEX = function(param) {
            var asn1Obj = this.newObject(param);
            return asn1Obj.getEncodedHex();
        };
    };

    KJUR.asn1.ASN1Util.oidHexToInt = function(hex) {
        var s = "";
        var i01 = parseInt(hex.substr(0, 2), 16);
        var i0 = Math.floor(i01 / 40);
        var i1 = i01 % 40;
        var s = i0 + "." + i1;

        var binbuf = "";
        for (var i = 2; i < hex.length; i += 2) {
      var value = parseInt(hex.substr(i, 2), 16);
            var bin = ("00000000" + value.toString(2)).slice(- 8);
      binbuf = binbuf + bin.substr(1, 7);
      if (bin.substr(0, 1) == "0") {
          var bi = new BigInteger(binbuf, 2);
          s = s + "." + bi.toString(10);
          binbuf = "";
      }
        };

        return s;
    };


    KJUR.asn1.ASN1Util.oidIntToHex = function(oidString) {
        var itox = function(i) {
            var h = i.toString(16);
            if (h.length == 1) h = '0' + h;
            return h;
        };

        var roidtox = function(roid) {
            var h = '';
            var bi = new BigInteger(roid, 10);
            var b = bi.toString(2);
            var padLen = 7 - b.length % 7;
            if (padLen == 7) padLen = 0;
            var bPad = '';
            for (var i = 0; i < padLen; i++) bPad += '0';
            b = bPad + b;
            for (var i = 0; i < b.length - 1; i += 7) {
                var b8 = b.substr(i, 7);
                if (i != b.length - 7) b8 = '1' + b8;
                h += itox(parseInt(b8, 2));
            }
            return h;
        };
        
        if (! oidString.match(/^[0-9.]+$/)) {
            throw "malformed oid string: " + oidString;
        }
        var h = '';
        var a = oidString.split('.');
        var i0 = parseInt(a[0]) * 40 + parseInt(a[1]);
        h += itox(i0);
        a.splice(0, 2);
        for (var i = 0; i < a.length; i++) {
            h += roidtox(a[i]);
        }
        return h;
    };


    KJUR.asn1.ASN1Object = function() {
        var isModified = true;
        var hTLV = null;
        var hT = '00';
        var hL = '00';
        var hV = '';

        this.getLengthHexFromValue = function() {
            if (typeof this.hV == "undefined" || this.hV == null) {
                throw "this.hV is null or undefined.";
            }
            if (this.hV.length % 2 == 1) {
                throw "value hex must be even length: n=" + hV.length + ",v=" + this.hV;
            }
            var n = this.hV.length / 2;
            var hN = n.toString(16);
            if (hN.length % 2 == 1) {
                hN = "0" + hN;
            }
            if (n < 128) {
                return hN;
            } else {
                var hNlen = hN.length / 2;
                if (hNlen > 15) {
                    throw "ASN.1 length too long to represent by 8x: n = " + n.toString(16);
                }
                var head = 128 + hNlen;
                return head.toString(16) + hN;
            }
        };

        
        this.getEncodedHex = function() {
            if (this.hTLV == null || this.isModified) {
                this.hV = this.getFreshValueHex();
                this.hL = this.getLengthHexFromValue();
                this.hTLV = this.hT + this.hL + this.hV;
                this.isModified = false;
                //alert("first time: " + this.hTLV);
            }
            return this.hTLV;
        };

        this.getValueHex = function() {
            this.getEncodedHex();
            return this.hV;
        };

        this.getFreshValueHex = function() {
            return '';
        };
    };

    KJUR.asn1.DERAbstractString = function(params) {
        KJUR.asn1.DERAbstractString.superclass.constructor.call(this);
        var s = null;
        var hV = null;

        
        this.getString = function() {
            return this.s;
        };

        
        this.setString = function(newS) {
            this.hTLV = null;
            this.isModified = true;
            this.s = newS;
            this.hV = utf8tohex(this.s).toLowerCase();
        };

        this.setStringHex = function(newHexString) {
            this.hTLV = null;
            this.isModified = true;
            this.s = null;
            this.hV = newHexString;
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params == "string") {
                this.setString(params);
            } else if (typeof params['str'] != "undefined") {
                this.setString(params['str']);
            } else if (typeof params['hex'] != "undefined") {
                this.setStringHex(params['hex']);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERAbstractString, KJUR.asn1.ASN1Object);

    KJUR.asn1.DERAbstractTime = function(params) {
        KJUR.asn1.DERAbstractTime.superclass.constructor.call(this);
        var s = null;
        var date = null;

        // --- PRIVATE METHODS --------------------
        this.localDateToUTC = function(d) {
            utc = d.getTime() + (d.getTimezoneOffset() * 60000);
            var utcDate = new Date(utc);
            return utcDate;
        };

        
        this.formatDate = function(dateObject, type, withMillis) {
            var pad = this.zeroPadding;
            var d = this.localDateToUTC(dateObject);
            var year = String(d.getFullYear());
            if (type == 'utc') year = year.substr(2, 2);
            var month = pad(String(d.getMonth() + 1), 2);
            var day = pad(String(d.getDate()), 2);
            var hour = pad(String(d.getHours()), 2);
            var min = pad(String(d.getMinutes()), 2);
            var sec = pad(String(d.getSeconds()), 2);
            var s = year + month + day + hour + min + sec;
            if (withMillis === true) {
                var millis = d.getMilliseconds();
                if (millis != 0) {
                    var sMillis = pad(String(millis), 3);
                    sMillis = sMillis.replace(/[0]+$/, "");
                    s = s + "." + sMillis;
                }
            }
            return s + "Z";
        };

        this.zeroPadding = function(s, len) {
            if (s.length >= len) return s;
            return new Array(len - s.length + 1).join('0') + s;
        };

        this.getString = function() {
            return this.s;
        };

        
        this.setString = function(newS) {
            this.hTLV = null;
            this.isModified = true;
            this.s = newS;
            this.hV = stohex(newS);
        };

        
        this.setByDateValue = function(year, month, day, hour, min, sec) {
            var dateObject = new Date(Date.UTC(year, month - 1, day, hour, min, sec, 0));
            this.setByDate(dateObject);
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };
    };
    YAHOO.lang.extend(KJUR.asn1.DERAbstractTime, KJUR.asn1.ASN1Object);

    KJUR.asn1.DERAbstractStructured = function(params) {
        KJUR.asn1.DERAbstractString.superclass.constructor.call(this);
        var asn1Array = null;

        
        this.setByASN1ObjectArray = function(asn1ObjectArray) {
            this.hTLV = null;
            this.isModified = true;
            this.asn1Array = asn1ObjectArray;
        };

        this.appendASN1Object = function(asn1Object) {
            this.hTLV = null;
            this.isModified = true;
            this.asn1Array.push(asn1Object);
        };

        this.asn1Array = new Array();
        if (typeof params != "undefined") {
            if (typeof params['array'] != "undefined") {
                this.asn1Array = params['array'];
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERAbstractStructured, KJUR.asn1.ASN1Object);


    KJUR.asn1.DERBoolean = function() {
        KJUR.asn1.DERBoolean.superclass.constructor.call(this);
        this.hT = "01";
        this.hTLV = "0101ff";
    };
    YAHOO.lang.extend(KJUR.asn1.DERBoolean, KJUR.asn1.ASN1Object);


    KJUR.asn1.DERInteger = function(params) {
        KJUR.asn1.DERInteger.superclass.constructor.call(this);
        this.hT = "02";

       
        this.setByBigInteger = function(bigIntegerValue) {
            this.hTLV = null;
            this.isModified = true;
            this.hV = KJUR.asn1.ASN1Util.bigIntToMinTwosComplementsHex(bigIntegerValue);
        };

        
        this.setByInteger = function(intValue) {
            var bi = new BigInteger(String(intValue), 10);
            this.setByBigInteger(bi);
        };

        this.setValueHex = function(newHexString) {
            this.hV = newHexString;
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params['bigint'] != "undefined") {
                this.setByBigInteger(params['bigint']);
            } else if (typeof params['int'] != "undefined") {
                this.setByInteger(params['int']);
            } else if (typeof params == "number") {
                this.setByInteger(params);
            } else if (typeof params['hex'] != "undefined") {
                this.setValueHex(params['hex']);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERInteger, KJUR.asn1.ASN1Object);


    KJUR.asn1.DERBitString = function(params) {
        if (params !== undefined && typeof params.obj !== "undefined") {
      var o = KJUR.asn1.ASN1Util.newObject(params.obj);
      params.hex = "00" + o.getEncodedHex();
        }
        KJUR.asn1.DERBitString.superclass.constructor.call(this);
        this.hT = "03";

        
        this.setHexValueIncludingUnusedBits = function(newHexStringIncludingUnusedBits) {
            this.hTLV = null;
            this.isModified = true;
            this.hV = newHexStringIncludingUnusedBits;
        };

       
        this.setUnusedBitsAndHexValue = function(unusedBits, hValue) {
            if (unusedBits < 0 || 7 < unusedBits) {
                throw "unused bits shall be from 0 to 7: u = " + unusedBits;
            }
            var hUnusedBits = "0" + unusedBits;
            this.hTLV = null;
            this.isModified = true;
            this.hV = hUnusedBits + hValue;
        };

        
        this.setByBinaryString = function(binaryString) {
            binaryString = binaryString.replace(/0+$/, '');
            var unusedBits = 8 - binaryString.length % 8;
            if (unusedBits == 8) unusedBits = 0;
            for (var i = 0; i <= unusedBits; i++) {
                binaryString += '0';
            }
            var h = '';
            for (var i = 0; i < binaryString.length - 1; i += 8) {
                var b = binaryString.substr(i, 8);
                var x = parseInt(b, 2).toString(16);
                if (x.length == 1) x = '0' + x;
                h += x;  
            }
            this.hTLV = null;
            this.isModified = true;
            this.hV = '0' + unusedBits + h;
        };

        
        this.setByBooleanArray = function(booleanArray) {
            var s = '';
            for (var i = 0; i < booleanArray.length; i++) {
                if (booleanArray[i] == true) {
                    s += '1';
                } else {
                    s += '0';
                }
            }
            this.setByBinaryString(s);
        };

        
        this.newFalseArray = function(nLength) {
            var a = new Array(nLength);
            for (var i = 0; i < nLength; i++) {
                a[i] = false;
            }
            return a;
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params == "string" && params.toLowerCase().match(/^[0-9a-f]+$/)) {
                this.setHexValueIncludingUnusedBits(params);
            } else if (typeof params['hex'] != "undefined") {
                this.setHexValueIncludingUnusedBits(params['hex']);
            } else if (typeof params['bin'] != "undefined") {
                this.setByBinaryString(params['bin']);
            } else if (typeof params['array'] != "undefined") {
                this.setByBooleanArray(params['array']);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERBitString, KJUR.asn1.ASN1Object);


    KJUR.asn1.DEROctetString = function(params) {
        if (params !== undefined && typeof params.obj !== "undefined") {
      var o = KJUR.asn1.ASN1Util.newObject(params.obj);
      params.hex = o.getEncodedHex();
        }
        KJUR.asn1.DEROctetString.superclass.constructor.call(this, params);
        this.hT = "04";
    };
    YAHOO.lang.extend(KJUR.asn1.DEROctetString, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERNull = function() {
        KJUR.asn1.DERNull.superclass.constructor.call(this);
        this.hT = "05";
        this.hTLV = "0500";
    };
    YAHOO.lang.extend(KJUR.asn1.DERNull, KJUR.asn1.ASN1Object);


    KJUR.asn1.DERObjectIdentifier = function(params) {
        var itox = function(i) {
            var h = i.toString(16);
            if (h.length == 1) h = '0' + h;
            return h;
        };
        var roidtox = function(roid) {
            var h = '';
            var bi = new BigInteger(roid, 10);
            var b = bi.toString(2);
            var padLen = 7 - b.length % 7;
            if (padLen == 7) padLen = 0;
            var bPad = '';
            for (var i = 0; i < padLen; i++) bPad += '0';
            b = bPad + b;
            for (var i = 0; i < b.length - 1; i += 7) {
                var b8 = b.substr(i, 7);
                if (i != b.length - 7) b8 = '1' + b8;
                h += itox(parseInt(b8, 2));
            }
            return h;
        };

        KJUR.asn1.DERObjectIdentifier.superclass.constructor.call(this);
        this.hT = "06";

        
        this.setValueHex = function(newHexString) {
            this.hTLV = null;
            this.isModified = true;
            this.s = null;
            this.hV = newHexString;
        };

        
        this.setValueOidString = function(oidString) {
            if (! oidString.match(/^[0-9.]+$/)) {
                throw "malformed oid string: " + oidString;
            }
            var h = '';
            var a = oidString.split('.');
            var i0 = parseInt(a[0]) * 40 + parseInt(a[1]);
            h += itox(i0);
            a.splice(0, 2);
            for (var i = 0; i < a.length; i++) {
                h += roidtox(a[i]);
            }
            this.hTLV = null;
            this.isModified = true;
            this.s = null;
            this.hV = h;
        };

        this.setValueName = function(oidName) {
      var oid = KJUR.asn1.x509.OID.name2oid(oidName);
      if (oid !== '') {
                this.setValueOidString(oid);
            } else {
                throw "DERObjectIdentifier oidName undefined: " + oidName;
            }
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (params !== undefined) {
            if (typeof params === "string") {
          if (params.match(/^[0-2].[0-9.]+$/)) {
        this.setValueOidString(params);
          } else {
        this.setValueName(params);
          }
            } else if (params.oid !== undefined) {
                this.setValueOidString(params.oid);
            } else if (params.hex !== undefined) {
                this.setValueHex(params.hex);
            } else if (params.name !== undefined) {
                this.setValueName(params.name);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERObjectIdentifier, KJUR.asn1.ASN1Object);


    KJUR.asn1.DEREnumerated = function(params) {
        KJUR.asn1.DEREnumerated.superclass.constructor.call(this);
        this.hT = "0a";

        
        this.setByBigInteger = function(bigIntegerValue) {
            this.hTLV = null;
            this.isModified = true;
            this.hV = KJUR.asn1.ASN1Util.bigIntToMinTwosComplementsHex(bigIntegerValue);
        };

        
        this.setByInteger = function(intValue) {
            var bi = new BigInteger(String(intValue), 10);
            this.setByBigInteger(bi);
        };

        
        this.setValueHex = function(newHexString) {
            this.hV = newHexString;
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params['int'] != "undefined") {
                this.setByInteger(params['int']);
            } else if (typeof params == "number") {
                this.setByInteger(params);
            } else if (typeof params['hex'] != "undefined") {
                this.setValueHex(params['hex']);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DEREnumerated, KJUR.asn1.ASN1Object);


    KJUR.asn1.DERUTF8String = function(params) {
        KJUR.asn1.DERUTF8String.superclass.constructor.call(this, params);
        this.hT = "0c";
    };
    YAHOO.lang.extend(KJUR.asn1.DERUTF8String, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERNumericString = function(params) {
        KJUR.asn1.DERNumericString.superclass.constructor.call(this, params);
        this.hT = "12";
    };
    YAHOO.lang.extend(KJUR.asn1.DERNumericString, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERPrintableString = function(params) {
        KJUR.asn1.DERPrintableString.superclass.constructor.call(this, params);
        this.hT = "13";
    };
    YAHOO.lang.extend(KJUR.asn1.DERPrintableString, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERTeletexString = function(params) {
        KJUR.asn1.DERTeletexString.superclass.constructor.call(this, params);
        this.hT = "14";
    };
    YAHOO.lang.extend(KJUR.asn1.DERTeletexString, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERIA5String = function(params) {
        KJUR.asn1.DERIA5String.superclass.constructor.call(this, params);
        this.hT = "16";
    };
    YAHOO.lang.extend(KJUR.asn1.DERIA5String, KJUR.asn1.DERAbstractString);


    KJUR.asn1.DERUTCTime = function(params) {
        KJUR.asn1.DERUTCTime.superclass.constructor.call(this, params);
        this.hT = "17";

       
        this.setByDate = function(dateObject) {
            this.hTLV = null;
            this.isModified = true;
            this.date = dateObject;
            this.s = this.formatDate(this.date, 'utc');
            this.hV = stohex(this.s);
        };

        this.getFreshValueHex = function() {
            if (typeof this.date == "undefined" && typeof this.s == "undefined") {
                this.date = new Date();
                this.s = this.formatDate(this.date, 'utc');
                this.hV = stohex(this.s);
            }
            return this.hV;
        };

        if (params !== undefined) {
            if (params.str !== undefined) {
                this.setString(params.str);
            } else if (typeof params == "string" && params.match(/^[0-9]{12}Z$/)) {
                this.setString(params);
            } else if (params.hex !== undefined) {
                this.setStringHex(params.hex);
            } else if (params.date !== undefined) {
                this.setByDate(params.date);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERUTCTime, KJUR.asn1.DERAbstractTime);


    KJUR.asn1.DERGeneralizedTime = function(params) {
        KJUR.asn1.DERGeneralizedTime.superclass.constructor.call(this, params);
        this.hT = "18";
        this.withMillis = false;

        
        this.setByDate = function(dateObject) {
            this.hTLV = null;
            this.isModified = true;
            this.date = dateObject;
            this.s = this.formatDate(this.date, 'gen', this.withMillis);
            this.hV = stohex(this.s);
        };

        this.getFreshValueHex = function() {
            if (this.date === undefined && this.s === undefined) {
                this.date = new Date();
                this.s = this.formatDate(this.date, 'gen', this.withMillis);
                this.hV = stohex(this.s);
            }
            return this.hV;
        };

        if (params !== undefined) {
            if (params.str !== undefined) {
                this.setString(params.str);
            } else if (typeof params == "string" && params.match(/^[0-9]{14}Z$/)) {
                this.setString(params);
            } else if (params.hex !== undefined) {
                this.setStringHex(params.hex);
            } else if (params.date !== undefined) {
                this.setByDate(params.date);
            }
            if (params.millis === true) {
                this.withMillis = true;
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERGeneralizedTime, KJUR.asn1.DERAbstractTime);


    KJUR.asn1.DERSequence = function(params) {
        KJUR.asn1.DERSequence.superclass.constructor.call(this, params);
        this.hT = "30";
        this.getFreshValueHex = function() {
            var h = '';
            for (var i = 0; i < this.asn1Array.length; i++) {
                var asn1Obj = this.asn1Array[i];
                h += asn1Obj.getEncodedHex();
            }
            this.hV = h;
            return this.hV;
        };
    };
    YAHOO.lang.extend(KJUR.asn1.DERSequence, KJUR.asn1.DERAbstractStructured);


    KJUR.asn1.DERSet = function(params) {
        KJUR.asn1.DERSet.superclass.constructor.call(this, params);
        this.hT = "31";
        this.sortFlag = true; // item shall be sorted only in ASN.1 DER
        this.getFreshValueHex = function() {
            var a = new Array();
            for (var i = 0; i < this.asn1Array.length; i++) {
                var asn1Obj = this.asn1Array[i];
                a.push(asn1Obj.getEncodedHex());
            }
            if (this.sortFlag == true) a.sort();
            this.hV = a.join('');
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params.sortflag != "undefined" &&
                params.sortflag == false)
                this.sortFlag = false;
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERSet, KJUR.asn1.DERAbstractStructured);


    KJUR.asn1.DERTaggedObject = function(params) {
        KJUR.asn1.DERTaggedObject.superclass.constructor.call(this);
        this.hT = "a0";
        this.hV = '';
        this.isExplicit = true;
        this.asn1Object = null;

        
        this.setASN1Object = function(isExplicitFlag, tagNoHex, asn1Object) {
            this.hT = tagNoHex;
            this.isExplicit = isExplicitFlag;
            this.asn1Object = asn1Object;
            if (this.isExplicit) {
                this.hV = this.asn1Object.getEncodedHex();
                this.hTLV = null;
                this.isModified = true;
            } else {
                this.hV = null;
                this.hTLV = asn1Object.getEncodedHex();
                this.hTLV = this.hTLV.replace(/^../, tagNoHex);
                this.isModified = false;
            }
        };

        this.getFreshValueHex = function() {
            return this.hV;
        };

        if (typeof params != "undefined") {
            if (typeof params['tag'] != "undefined") {
                this.hT = params['tag'];
            }
            if (typeof params['explicit'] != "undefined") {
                this.isExplicit = params['explicit'];
            }
            if (typeof params['obj'] != "undefined") {
                this.asn1Object = params['obj'];
                this.setASN1Object(this.isExplicit, this.hT, this.asn1Object);
            }
        }
    };
    YAHOO.lang.extend(KJUR.asn1.DERTaggedObject, KJUR.asn1.ASN1Object);


    var dbits;

    // JavaScript engine analysis
    var canary = 0xdeadbeefcafe;
    var j_lm = ((canary&0xffffff)==0xefcafe);

    // (public) Constructor
    function BigInteger(a,b,c) {
      if(a != null)
        if("number" == typeof a) this.fromNumber(a,b,c);
        else if(b == null && "string" != typeof a) this.fromString(a,256);
        else this.fromString(a,b);
    }

    // return new, unset BigInteger
    function nbi() { return new BigInteger(null); }


    function am1(i,x,w,j,c,n) {
      while(--n >= 0) {
        var v = x*this[i++]+w[j]+c;
        c = Math.floor(v/0x4000000);
        w[j++] = v&0x3ffffff;
      }
      return c;
    }

    function am2(i,x,w,j,c,n) {
      var xl = x&0x7fff, xh = x>>15;
      while(--n >= 0) {
        var l = this[i]&0x7fff;
        var h = this[i++]>>15;
        var m = xh*l+h*xl;
        l = xl*l+((m&0x7fff)<<15)+w[j]+(c&0x3fffffff);
        c = (l>>>30)+(m>>>15)+xh*h+(c>>>30);
        w[j++] = l&0x3fffffff;
      }
      return c;
    }
    // Alternately, set max digit bits to 28 since some
    // browsers slow down when dealing with 32-bit numbers.
    function am3(i,x,w,j,c,n) {
      var xl = x&0x3fff, xh = x>>14;
      while(--n >= 0) {
        var l = this[i]&0x3fff;
        var h = this[i++]>>14;
        var m = xh*l+h*xl;
        l = xl*l+((m&0x3fff)<<14)+w[j]+c;
        c = (l>>28)+(m>>14)+xh*h;
        w[j++] = l&0xfffffff;
      }
      return c;
    }
    if(j_lm && (navigator.appName == "Microsoft Internet Explorer")) {
      BigInteger.prototype.am = am2;
      dbits = 30;
    }
    else if(j_lm && (navigator.appName != "Netscape")) {
      BigInteger.prototype.am = am1;
      dbits = 26;
    }
    else { // Mozilla/Netscape seems to prefer am3
      BigInteger.prototype.am = am3;
      dbits = 28;
    }

    BigInteger.prototype.DB = dbits;
    BigInteger.prototype.DM = ((1<<dbits)-1);
    BigInteger.prototype.DV = (1<<dbits);

    var BI_FP = 52;
    BigInteger.prototype.FV = Math.pow(2,BI_FP);
    BigInteger.prototype.F1 = BI_FP-dbits;
    BigInteger.prototype.F2 = 2*dbits-BI_FP;

    // Digit conversions
    var BI_RM = "0123456789abcdefghijklmnopqrstuvwxyz";
    var BI_RC = new Array();
    var rr,vv;
    rr = "0".charCodeAt(0);
    for(vv = 0; vv <= 9; ++vv) BI_RC[rr++] = vv;
    rr = "a".charCodeAt(0);
    for(vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;
    rr = "A".charCodeAt(0);
    for(vv = 10; vv < 36; ++vv) BI_RC[rr++] = vv;

    function int2char(n) { return BI_RM.charAt(n); }
    function intAt(s,i) {
      var c = BI_RC[s.charCodeAt(i)];
      return (c==null)?-1:c;
    }

    // (protected) copy this to r
    function bnpCopyTo(r) {
      for(var i = this.t-1; i >= 0; --i) r[i] = this[i];
      r.t = this.t;
      r.s = this.s;
    }

    // (protected) set from integer value x, -DV <= x < DV
    function bnpFromInt(x) {
      this.t = 1;
      this.s = (x<0)?-1:0;
      if(x > 0) this[0] = x;
      else if(x < -1) this[0] = x+this.DV;
      else this.t = 0;
    }

    // return bigint initialized to value
    function nbv(i) { var r = nbi(); r.fromInt(i); return r; }

    // (protected) set from string and radix
    function bnpFromString(s,b) {
      var k;
      if(b == 16) k = 4;
      else if(b == 8) k = 3;
      else if(b == 256) k = 8; // byte array
      else if(b == 2) k = 1;
      else if(b == 32) k = 5;
      else if(b == 4) k = 2;
      else { this.fromRadix(s,b); return; }
      this.t = 0;
      this.s = 0;
      var i = s.length, mi = false, sh = 0;
      while(--i >= 0) {
        var x = (k==8)?s[i]&0xff:intAt(s,i);
        if(x < 0) {
          if(s.charAt(i) == "-") mi = true;
          continue;
        }
        mi = false;
        if(sh == 0)
          this[this.t++] = x;
        else if(sh+k > this.DB) {
          this[this.t-1] |= (x&((1<<(this.DB-sh))-1))<<sh;
          this[this.t++] = (x>>(this.DB-sh));
        }
        else
          this[this.t-1] |= x<<sh;
        sh += k;
        if(sh >= this.DB) sh -= this.DB;
      }
      if(k == 8 && (s[0]&0x80) != 0) {
        this.s = -1;
        if(sh > 0) this[this.t-1] |= ((1<<(this.DB-sh))-1)<<sh;
      }
      this.clamp();
      if(mi) BigInteger.ZERO.subTo(this,this);
    }

    // (protected) clamp off excess high words
    function bnpClamp() {
      var c = this.s&this.DM;
      while(this.t > 0 && this[this.t-1] == c) --this.t;
    }

    // (public) return string representation in given radix
    function bnToString(b) {
      if(this.s < 0) return "-"+this.negate().toString(b);
      var k;
      if(b == 16) k = 4;
      else if(b == 8) k = 3;
      else if(b == 2) k = 1;
      else if(b == 32) k = 5;
      else if(b == 4) k = 2;
      else return this.toRadix(b);
      var km = (1<<k)-1, d, m = false, r = "", i = this.t;
      var p = this.DB-(i*this.DB)%k;
      if(i-- > 0) {
        if(p < this.DB && (d = this[i]>>p) > 0) { m = true; r = int2char(d); }
        while(i >= 0) {
          if(p < k) {
            d = (this[i]&((1<<p)-1))<<(k-p);
            d |= this[--i]>>(p+=this.DB-k);
          }
          else {
            d = (this[i]>>(p-=k))&km;
            if(p <= 0) { p += this.DB; --i; }
          }
          if(d > 0) m = true;
          if(m) r += int2char(d);
        }
      }
      return m?r:"0";
    }

    // (public) -this
    function bnNegate() { var r = nbi(); BigInteger.ZERO.subTo(this,r); return r; }

    // (public) |this|
    function bnAbs() { return (this.s<0)?this.negate():this; }

    // (public) return + if this > a, - if this < a, 0 if equal
    function bnCompareTo(a) {
      var r = this.s-a.s;
      if(r != 0) return r;
      var i = this.t;
      r = i-a.t;
      if(r != 0) return (this.s<0)?-r:r;
      while(--i >= 0) if((r=this[i]-a[i]) != 0) return r;
      return 0;
    }

    // returns bit length of the integer x
    function nbits(x) {
      var r = 1, t;
      if((t=x>>>16) != 0) { x = t; r += 16; }
      if((t=x>>8) != 0) { x = t; r += 8; }
      if((t=x>>4) != 0) { x = t; r += 4; }
      if((t=x>>2) != 0) { x = t; r += 2; }
      if((t=x>>1) != 0) { x = t; r += 1; }
      return r;
    }

    // (public) return the number of bits in "this"
    function bnBitLength() {
      if(this.t <= 0) return 0;
      return this.DB*(this.t-1)+nbits(this[this.t-1]^(this.s&this.DM));
    }

    // (protected) r = this << n*DB
    function bnpDLShiftTo(n,r) {
      var i;
      for(i = this.t-1; i >= 0; --i) r[i+n] = this[i];
      for(i = n-1; i >= 0; --i) r[i] = 0;
      r.t = this.t+n;
      r.s = this.s;
    }

    // (protected) r = this >> n*DB
    function bnpDRShiftTo(n,r) {
      for(var i = n; i < this.t; ++i) r[i-n] = this[i];
      r.t = Math.max(this.t-n,0);
      r.s = this.s;
    }

    // (protected) r = this << n
    function bnpLShiftTo(n,r) {
      var bs = n%this.DB;
      var cbs = this.DB-bs;
      var bm = (1<<cbs)-1;
      var ds = Math.floor(n/this.DB), c = (this.s<<bs)&this.DM, i;
      for(i = this.t-1; i >= 0; --i) {
        r[i+ds+1] = (this[i]>>cbs)|c;
        c = (this[i]&bm)<<bs;
      }
      for(i = ds-1; i >= 0; --i) r[i] = 0;
      r[ds] = c;
      r.t = this.t+ds+1;
      r.s = this.s;
      r.clamp();
    }

    // (protected) r = this >> n
    function bnpRShiftTo(n,r) {
      r.s = this.s;
      var ds = Math.floor(n/this.DB);
      if(ds >= this.t) { r.t = 0; return; }
      var bs = n%this.DB;
      var cbs = this.DB-bs;
      var bm = (1<<bs)-1;
      r[0] = this[ds]>>bs;
      for(var i = ds+1; i < this.t; ++i) {
        r[i-ds-1] |= (this[i]&bm)<<cbs;
        r[i-ds] = this[i]>>bs;
      }
      if(bs > 0) r[this.t-ds-1] |= (this.s&bm)<<cbs;
      r.t = this.t-ds;
      r.clamp();
    }

    // (protected) r = this - a
    function bnpSubTo(a,r) {
      var i = 0, c = 0, m = Math.min(a.t,this.t);
      while(i < m) {
        c += this[i]-a[i];
        r[i++] = c&this.DM;
        c >>= this.DB;
      }
      if(a.t < this.t) {
        c -= a.s;
        while(i < this.t) {
          c += this[i];
          r[i++] = c&this.DM;
          c >>= this.DB;
        }
        c += this.s;
      }
      else {
        c += this.s;
        while(i < a.t) {
          c -= a[i];
          r[i++] = c&this.DM;
          c >>= this.DB;
        }
        c -= a.s;
      }
      r.s = (c<0)?-1:0;
      if(c < -1) r[i++] = this.DV+c;
      else if(c > 0) r[i++] = c;
      r.t = i;
      r.clamp();
    }

    // (protected) r = this * a, r != this,a (HAC 14.12)
    // "this" should be the larger one if appropriate.
    function bnpMultiplyTo(a,r) {
      var x = this.abs(), y = a.abs();
      var i = x.t;
      r.t = i+y.t;
      while(--i >= 0) r[i] = 0;
      for(i = 0; i < y.t; ++i) r[i+x.t] = x.am(0,y[i],r,i,0,x.t);
      r.s = 0;
      r.clamp();
      if(this.s != a.s) BigInteger.ZERO.subTo(r,r);
    }

    // (protected) r = this^2, r != this (HAC 14.16)
    function bnpSquareTo(r) {
      var x = this.abs();
      var i = r.t = 2*x.t;
      while(--i >= 0) r[i] = 0;
      for(i = 0; i < x.t-1; ++i) {
        var c = x.am(i,x[i],r,2*i,0,1);
        if((r[i+x.t]+=x.am(i+1,2*x[i],r,2*i+1,c,x.t-i-1)) >= x.DV) {
          r[i+x.t] -= x.DV;
          r[i+x.t+1] = 1;
        }
      }
      if(r.t > 0) r[r.t-1] += x.am(i,x[i],r,2*i,0,1);
      r.s = 0;
      r.clamp();
    }

    // (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)
    // r != q, this != m.  q or r may be null.
    function bnpDivRemTo(m,q,r) {
      var pm = m.abs();
      if(pm.t <= 0) return;
      var pt = this.abs();
      if(pt.t < pm.t) {
        if(q != null) q.fromInt(0);
        if(r != null) this.copyTo(r);
        return;
      }
      if(r == null) r = nbi();
      var y = nbi(), ts = this.s, ms = m.s;
      var nsh = this.DB-nbits(pm[pm.t-1]);  // normalize modulus
      if(nsh > 0) { pm.lShiftTo(nsh,y); pt.lShiftTo(nsh,r); }
      else { pm.copyTo(y); pt.copyTo(r); }
      var ys = y.t;
      var y0 = y[ys-1];
      if(y0 == 0) return;
      var yt = y0*(1<<this.F1)+((ys>1)?y[ys-2]>>this.F2:0);
      var d1 = this.FV/yt, d2 = (1<<this.F1)/yt, e = 1<<this.F2;
      var i = r.t, j = i-ys, t = (q==null)?nbi():q;
      y.dlShiftTo(j,t);
      if(r.compareTo(t) >= 0) {
        r[r.t++] = 1;
        r.subTo(t,r);
      }
      BigInteger.ONE.dlShiftTo(ys,t);
      t.subTo(y,y); // "negative" y so we can replace sub with am later
      while(y.t < ys) y[y.t++] = 0;
      while(--j >= 0) {
        // Estimate quotient digit
        var qd = (r[--i]==y0)?this.DM:Math.floor(r[i]*d1+(r[i-1]+e)*d2);
        if((r[i]+=y.am(0,qd,r,j,0,ys)) < qd) {  // Try it out
          y.dlShiftTo(j,t);
          r.subTo(t,r);
          while(r[i] < --qd) r.subTo(t,r);
        }
      }
      if(q != null) {
        r.drShiftTo(ys,q);
        if(ts != ms) BigInteger.ZERO.subTo(q,q);
      }
      r.t = ys;
      r.clamp();
      if(nsh > 0) r.rShiftTo(nsh,r);  // Denormalize remainder
      if(ts < 0) BigInteger.ZERO.subTo(r,r);
    }

    // (public) this mod a
    function bnMod(a) {
      var r = nbi();
      this.abs().divRemTo(a,null,r);
      if(this.s < 0 && r.compareTo(BigInteger.ZERO) > 0) a.subTo(r,r);
      return r;
    }

    // Modular reduction using "classic" algorithm
    function Classic(m) { this.m = m; }
    function cConvert(x) {
      if(x.s < 0 || x.compareTo(this.m) >= 0) return x.mod(this.m);
      else return x;
    }
    function cRevert(x) { return x; }
    function cReduce(x) { x.divRemTo(this.m,null,x); }
    function cMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }
    function cSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

    Classic.prototype.convert = cConvert;
    Classic.prototype.revert = cRevert;
    Classic.prototype.reduce = cReduce;
    Classic.prototype.mulTo = cMulTo;
    Classic.prototype.sqrTo = cSqrTo;


    function bnpInvDigit() {
      if(this.t < 1) return 0;
      var x = this[0];
      if((x&1) == 0) return 0;
      var y = x&3;    // y == 1/x mod 2^2
      y = (y*(2-(x&0xf)*y))&0xf;  // y == 1/x mod 2^4
      y = (y*(2-(x&0xff)*y))&0xff;  // y == 1/x mod 2^8
      y = (y*(2-(((x&0xffff)*y)&0xffff)))&0xffff; // y == 1/x mod 2^16
      // last step - calculate inverse mod DV directly;
      // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints
      y = (y*(2-x*y%this.DV))%this.DV;    // y == 1/x mod 2^dbits
      // we really want the negative inverse, and -DV < y < DV
      return (y>0)?this.DV-y:-y;
    }

    // Montgomery reduction
    function Montgomery(m) {
      this.m = m;
      this.mp = m.invDigit();
      this.mpl = this.mp&0x7fff;
      this.mph = this.mp>>15;
      this.um = (1<<(m.DB-15))-1;
      this.mt2 = 2*m.t;
    }

    // xR mod m
    function montConvert(x) {
      var r = nbi();
      x.abs().dlShiftTo(this.m.t,r);
      r.divRemTo(this.m,null,r);
      if(x.s < 0 && r.compareTo(BigInteger.ZERO) > 0) this.m.subTo(r,r);
      return r;
    }

    // x/R mod m
    function montRevert(x) {
      var r = nbi();
      x.copyTo(r);
      this.reduce(r);
      return r;
    }

    // x = x/R mod m (HAC 14.32)
    function montReduce(x) {
      while(x.t <= this.mt2)  // pad x so am has enough room later
        x[x.t++] = 0;
      for(var i = 0; i < this.m.t; ++i) {
        // faster way of calculating u0 = x[i]*mp mod DV
        var j = x[i]&0x7fff;
        var u0 = (j*this.mpl+(((j*this.mph+(x[i]>>15)*this.mpl)&this.um)<<15))&x.DM;
        // use am to combine the multiply-shift-add into one call
        j = i+this.m.t;
        x[j] += this.m.am(0,u0,x,i,0,this.m.t);
        // propagate carry
        while(x[j] >= x.DV) { x[j] -= x.DV; x[++j]++; }
      }
      x.clamp();
      x.drShiftTo(this.m.t,x);
      if(x.compareTo(this.m) >= 0) x.subTo(this.m,x);
    }

    // r = "x^2/R mod m"; x != r
    function montSqrTo(x,r) { x.squareTo(r); this.reduce(r); }

    // r = "xy/R mod m"; x,y != r
    function montMulTo(x,y,r) { x.multiplyTo(y,r); this.reduce(r); }

    Montgomery.prototype.convert = montConvert;
    Montgomery.prototype.revert = montRevert;
    Montgomery.prototype.reduce = montReduce;
    Montgomery.prototype.mulTo = montMulTo;
    Montgomery.prototype.sqrTo = montSqrTo;

    // (protected) true iff this is even
    function bnpIsEven() { return ((this.t>0)?(this[0]&1):this.s) == 0; }

    // (protected) this^e, e < 2^32, doing sqr and mul with "r" (HAC 14.79)
    function bnpExp(e,z) {
      if(e > 0xffffffff || e < 1) return BigInteger.ONE;
      var r = nbi(), r2 = nbi(), g = z.convert(this), i = nbits(e)-1;
      g.copyTo(r);
      while(--i >= 0) {
        z.sqrTo(r,r2);
        if((e&(1<<i)) > 0) z.mulTo(r2,g,r);
        else { var t = r; r = r2; r2 = t; }
      }
      return z.revert(r);
    }

    // (public) this^e % m, 0 <= e < 2^32
    function bnModPowInt(e,m) {
      var z;
      if(e < 256 || m.isEven()) z = new Classic(m); else z = new Montgomery(m);
      return this.exp(e,z);
    }

    // protected
    BigInteger.prototype.copyTo = bnpCopyTo;
    BigInteger.prototype.fromInt = bnpFromInt;
    BigInteger.prototype.fromString = bnpFromString;
    BigInteger.prototype.clamp = bnpClamp;
    BigInteger.prototype.dlShiftTo = bnpDLShiftTo;
    BigInteger.prototype.drShiftTo = bnpDRShiftTo;
    BigInteger.prototype.lShiftTo = bnpLShiftTo;
    BigInteger.prototype.rShiftTo = bnpRShiftTo;
    BigInteger.prototype.subTo = bnpSubTo;
    BigInteger.prototype.multiplyTo = bnpMultiplyTo;
    BigInteger.prototype.squareTo = bnpSquareTo;
    BigInteger.prototype.divRemTo = bnpDivRemTo;
    BigInteger.prototype.invDigit = bnpInvDigit;
    BigInteger.prototype.isEven = bnpIsEven;
    BigInteger.prototype.exp = bnpExp;

    // public
    BigInteger.prototype.toString = bnToString;
    BigInteger.prototype.negate = bnNegate;
    BigInteger.prototype.abs = bnAbs;
    BigInteger.prototype.compareTo = bnCompareTo;
    BigInteger.prototype.bitLength = bnBitLength;
    BigInteger.prototype.mod = bnMod;
    BigInteger.prototype.modPowInt = bnModPowInt;

    // "constants"
    BigInteger.ZERO = nbv(0);
    BigInteger.ONE = nbv(1);



    /*! (c) Tom Wu | http://www-cs-students.stanford.edu/~tjw/jsbn/
     */
    var b64map="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    var b64pad="=";

    function hex2b64(h) {
      var i;
      var c;
      var ret = "";
      for(i = 0; i+3 <= h.length; i+=3) {
        c = parseInt(h.substring(i,i+3),16);
        ret += b64map.charAt(c >> 6) + b64map.charAt(c & 63);
      }
      if(i+1 == h.length) {
        c = parseInt(h.substring(i,i+1),16);
        ret += b64map.charAt(c << 2);
      }
      else if(i+2 == h.length) {
        c = parseInt(h.substring(i,i+2),16);
        ret += b64map.charAt(c >> 2) + b64map.charAt((c & 3) << 4);
      }
      if (b64pad) while((ret.length & 3) > 0) ret += b64pad;
      return ret;
    }

    // convert a base64 string to hex
    function b64tohex(s) {
      var ret = "";
      var i;
      var k = 0; // b64 state, 0-3
      var slop;
      var v;
      for(i = 0; i < s.length; ++i) {
        if(s.charAt(i) == b64pad) break;
        v = b64map.indexOf(s.charAt(i));
        if(v < 0) continue;
        if(k == 0) {
          ret += int2char(v >> 2);
          slop = v & 3;
          k = 1;
        }
        else if(k == 1) {
          ret += int2char((slop << 2) | (v >> 4));
          slop = v & 0xf;
          k = 2;
        }
        else if(k == 2) {
          ret += int2char(slop);
          ret += int2char(v >> 2);
          slop = v & 3;
          k = 3;
        }
        else {
          ret += int2char((slop << 2) | (v >> 4));
          ret += int2char(v & 0xf);
          k = 0;
        }
      }
      if(k == 1)
        ret += int2char(slop << 2);
      return ret;
    }

    // convert a base64 string to a byte/number array
    function b64toBA(s) {
      //piggyback on b64tohex for now, optimize later
      var h = b64tohex(s);
      var i;
      var a = new Array();
      for(i = 0; 2*i < h.length; ++i) {
        a[i] = parseInt(h.substring(2*i,2*i+2),16);
      }
      return a;
    }


    /*
    -------------------------------------------------------------------------------------------------
     */
    function Arcfour() {
      this.i = 0;
      this.j = 0;
      this.S = new Array();
    }

    // Initialize arcfour context from key, an array of ints, each from [0..255]
    function ARC4init(key) {
      var i, j, t;
      for(i = 0; i < 256; ++i)
        this.S[i] = i;
      j = 0;
      for(i = 0; i < 256; ++i) {
        j = (j + this.S[i] + key[i % key.length]) & 255;
        t = this.S[i];
        this.S[i] = this.S[j];
        this.S[j] = t;
      }
      this.i = 0;
      this.j = 0;
    }

    function ARC4next() {
      var t;
      this.i = (this.i + 1) & 255;
      this.j = (this.j + this.S[this.i]) & 255;
      t = this.S[this.i];
      this.S[this.i] = this.S[this.j];
      this.S[this.j] = t;
      return this.S[(t + this.S[this.i]) & 255];
    }

    Arcfour.prototype.init = ARC4init;
    Arcfour.prototype.next = ARC4next;

    // Plug in your RNG constructor here
    function prng_newstate() {
      return new Arcfour();
    }

    // Pool size must be a multiple of 4 and greater than 32.
    // An array of bytes the size of the pool will be passed to init()
    var rng_psize = 256;

    /*
    ---------------------------------------SecureRandom----------------------------------------------------------
     */
    var rng_state;
    var rng_pool;
    var rng_pptr;

    // Mix in a 32-bit integer into the pool
    function rng_seed_int(x) {
      rng_pool[rng_pptr++] ^= x & 255;
      rng_pool[rng_pptr++] ^= (x >> 8) & 255;
      rng_pool[rng_pptr++] ^= (x >> 16) & 255;
      rng_pool[rng_pptr++] ^= (x >> 24) & 255;
      if(rng_pptr >= rng_psize) rng_pptr -= rng_psize;
    }

    // Mix in the current time (w/milliseconds) into the pool
    function rng_seed_time() {
      rng_seed_int(new Date().getTime());
    }

    // Initialize the pool with junk if needed.
    if (rng_pool == null) {
      rng_pool = new Array();
      rng_pptr = 0;
      var t;
      if (window !== undefined &&
          (window.crypto !== undefined ||
           window.msCrypto !== undefined)) {
        var crypto = window.crypto || window.msCrypto;
        if (crypto.getRandomValues) {
          // Use webcrypto if available
          var ua = new Uint8Array(32);
          crypto.getRandomValues(ua);
          for(t = 0; t < 32; ++t)
            rng_pool[rng_pptr++] = ua[t];
        } else if (navigator.appName == "Netscape" && navigator.appVersion < "5") {
          // Extract entropy (256 bits) from NS4 RNG if available
          var z = window.crypto.random(32);
          for(t = 0; t < z.length; ++t)
            rng_pool[rng_pptr++] = z.charCodeAt(t) & 255;
        }
      }  
      while (rng_pptr < rng_psize) {  // extract some randomness from Math.random()
        t = Math.floor(65536 * Math.random());
        rng_pool[rng_pptr++] = t >>> 8;
        rng_pool[rng_pptr++] = t & 255;
      }
      rng_pptr = 0;
      rng_seed_time();
      //rng_seed_int(window.screenX);
      //rng_seed_int(window.screenY);
    }

    function rng_get_byte() {
      if (rng_state == null) {
        rng_seed_time();
        rng_state = prng_newstate();
        rng_state.init(rng_pool);
        for(rng_pptr = 0; rng_pptr < rng_pool.length; ++rng_pptr)
          rng_pool[rng_pptr] = 0;
        rng_pptr = 0;
        //rng_pool = null;
      }
      // TODO: allow reseeding after first request
      return rng_state.next();
    }

    function rng_get_bytes(ba) {
      var i;
      for (i = 0; i < ba.length; ++i) ba[i] = rng_get_byte();
    }

    function SecureRandom() {}

    SecureRandom.prototype.nextBytes = rng_get_bytes;


    /*
    ---------------------------------------CryptoJS----------------------------------------------------------
     */

    var CryptoJS = CryptoJS || (function (Math, undefined$1) {
        /**
         * CryptoJS namespace.
         */
        var C = {};

        /**
         * Library namespace.
         */
        var C_lib = C.lib = {};

        /**
         * Base object for prototypal inheritance.
         */
        var Base = C_lib.Base = (function () {
            function F() {}

            return {
                
                extend: function (overrides) {
                    // Spawn
                    F.prototype = this;
                    var subtype = new F();

                    // Augment
                    if (overrides) {
                        subtype.mixIn(overrides);
                    }

                    // Create default initializer
                    if (!subtype.hasOwnProperty('init')) {
                        subtype.init = function () {
                            subtype.$super.init.apply(this, arguments);
                        };
                    }

                    // Initializer's prototype is the subtype object
                    subtype.init.prototype = subtype;

                    // Reference supertype
                    subtype.$super = this;

                    return subtype;
                },

                
                create: function () {
                    var instance = this.extend();
                    instance.init.apply(instance, arguments);

                    return instance;
                },

               
                init: function () {
                },

                
                mixIn: function (properties) {
                    for (var propertyName in properties) {
                        if (properties.hasOwnProperty(propertyName)) {
                            this[propertyName] = properties[propertyName];
                        }
                    }

                    // IE won't copy toString using the loop above
                    if (properties.hasOwnProperty('toString')) {
                        this.toString = properties.toString;
                    }
                },

                
                clone: function () {
                    return this.init.prototype.extend(this);
                }
            };
        }());

        
        var WordArray = C_lib.WordArray = Base.extend({
            
            init: function (words, sigBytes) {
                words = this.words = words || [];

                if (sigBytes != undefined$1) {
                    this.sigBytes = sigBytes;
                } else {
                    this.sigBytes = words.length * 4;
                }
            },

           
            toString: function (encoder) {
                return (encoder || Hex).stringify(this);
            },

            
            concat: function (wordArray) {
                // Shortcuts
                var thisWords = this.words;
                var thatWords = wordArray.words;
                var thisSigBytes = this.sigBytes;
                var thatSigBytes = wordArray.sigBytes;

                // Clamp excess bits
                this.clamp();

                // Concat
                if (thisSigBytes % 4) {
                    // Copy one byte at a time
                    for (var i = 0; i < thatSigBytes; i++) {
                        var thatByte = (thatWords[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                        thisWords[(thisSigBytes + i) >>> 2] |= thatByte << (24 - ((thisSigBytes + i) % 4) * 8);
                    }
                } else {
                    // Copy one word at a time
                    for (var i = 0; i < thatSigBytes; i += 4) {
                        thisWords[(thisSigBytes + i) >>> 2] = thatWords[i >>> 2];
                    }
                }
                this.sigBytes += thatSigBytes;

                // Chainable
                return this;
            },

            
            clamp: function () {
                // Shortcuts
                var words = this.words;
                var sigBytes = this.sigBytes;

                // Clamp
                words[sigBytes >>> 2] &= 0xffffffff << (32 - (sigBytes % 4) * 8);
                words.length = Math.ceil(sigBytes / 4);
            },

           
            clone: function () {
                var clone = Base.clone.call(this);
                clone.words = this.words.slice(0);

                return clone;
            },

            
            random: function (nBytes) {
                var words = [];
                for (var i = 0; i < nBytes; i += 4) {
                    words.push((Math.random() * 0x100000000) | 0);
                }

                return new WordArray.init(words, nBytes);
            }
        });


        var C_enc = C.enc = {};

        
        var Hex = C_enc.Hex = {
            
            stringify: function (wordArray) {
                // Shortcuts
                var words = wordArray.words;
                var sigBytes = wordArray.sigBytes;

                // Convert
                var hexChars = [];
                for (var i = 0; i < sigBytes; i++) {
                    var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                    hexChars.push((bite >>> 4).toString(16));
                    hexChars.push((bite & 0x0f).toString(16));
                }

                return hexChars.join('');
            },

           
            parse: function (hexStr) {
                // Shortcut
                var hexStrLength = hexStr.length;

                // Convert
                var words = [];
                for (var i = 0; i < hexStrLength; i += 2) {
                    words[i >>> 3] |= parseInt(hexStr.substr(i, 2), 16) << (24 - (i % 8) * 4);
                }

                return new WordArray.init(words, hexStrLength / 2);
            }
        };

        /**
         * Latin1 encoding strategy.
         */
        var Latin1 = C_enc.Latin1 = {
           
            stringify: function (wordArray) {
                // Shortcuts
                var words = wordArray.words;
                var sigBytes = wordArray.sigBytes;

                // Convert
                var latin1Chars = [];
                for (var i = 0; i < sigBytes; i++) {
                    var bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
                    latin1Chars.push(String.fromCharCode(bite));
                }

                return latin1Chars.join('');
            },

            
            parse: function (latin1Str) {
                // Shortcut
                var latin1StrLength = latin1Str.length;

                // Convert
                var words = [];
                for (var i = 0; i < latin1StrLength; i++) {
                    words[i >>> 2] |= (latin1Str.charCodeAt(i) & 0xff) << (24 - (i % 4) * 8);
                }

                return new WordArray.init(words, latin1StrLength);
            }
        };

       
        var Utf8 = C_enc.Utf8 = {
            
            stringify: function (wordArray) {
                try {
                    return decodeURIComponent(escape(Latin1.stringify(wordArray)));
                } catch (e) {
                    throw new Error('Malformed UTF-8 data');
                }
            },

            
            parse: function (utf8Str) {
                return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
            }
        };

        
        var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm = Base.extend({
            
            reset: function () {
                // Initial values
                this._data = new WordArray.init();
                this._nDataBytes = 0;
            },

            
            _append: function (data) {
                // Convert string to WordArray, else assume WordArray already
                if (typeof data == 'string') {
                    data = Utf8.parse(data);
                }

                // Append
                this._data.concat(data);
                this._nDataBytes += data.sigBytes;
            },

            _process: function (doFlush) {
                // Shortcuts
                var data = this._data;
                var dataWords = data.words;
                var dataSigBytes = data.sigBytes;
                var blockSize = this.blockSize;
                var blockSizeBytes = blockSize * 4;

                // Count blocks ready
                var nBlocksReady = dataSigBytes / blockSizeBytes;
                if (doFlush) {
                    // Round up to include partial blocks
                    nBlocksReady = Math.ceil(nBlocksReady);
                } else {
                    // Round down to include only full blocks,
                    // less the number of blocks that must remain in the buffer
                    nBlocksReady = Math.max((nBlocksReady | 0) - this._minBufferSize, 0);
                }

                // Count words ready
                var nWordsReady = nBlocksReady * blockSize;

                // Count bytes ready
                var nBytesReady = Math.min(nWordsReady * 4, dataSigBytes);

                // Process blocks
                if (nWordsReady) {
                    for (var offset = 0; offset < nWordsReady; offset += blockSize) {
                        // Perform concrete-algorithm logic
                        this._doProcessBlock(dataWords, offset);
                    }

                    // Remove processed words
                    var processedWords = dataWords.splice(0, nWordsReady);
                    data.sigBytes -= nBytesReady;
                }

                // Return processed words
                return new WordArray.init(processedWords, nBytesReady);
            },

           
            clone: function () {
                var clone = Base.clone.call(this);
                clone._data = this._data.clone();

                return clone;
            },

            _minBufferSize: 0
        });

       
        var Hasher = C_lib.Hasher = BufferedBlockAlgorithm.extend({
            /**
             * Configuration options.
             */
            cfg: Base.extend(),

            
            init: function (cfg) {
                // Apply config defaults
                this.cfg = this.cfg.extend(cfg);

                // Set initial values
                this.reset();
            },

            
            reset: function () {
                // Reset data buffer
                BufferedBlockAlgorithm.reset.call(this);

                // Perform concrete-hasher logic
                this._doReset();
            },

            
            update: function (messageUpdate) {
                // Append
                this._append(messageUpdate);

                // Update the hash
                this._process();

                // Chainable
                return this;
            },

            
            finalize: function (messageUpdate) {
                // Final message update
                if (messageUpdate) {
                    this._append(messageUpdate);
                }

                // Perform concrete-hasher logic
                var hash = this._doFinalize();

                return hash;
            },

            blockSize: 512/32,

            
            _createHelper: function (hasher) {
                return function (message, cfg) {
                    return new hasher.init(cfg).finalize(message);
                };
            },

            
            _createHmacHelper: function (hasher) {
                return function (message, key) {
                    return new C_algo.HMAC.init(hasher, key).finalize(message);
                };
            }
        });

       
        var C_algo = C.algo = {};

        return C;
    }(Math));






    (function () {
        // Shortcuts
        var C = CryptoJS;
        var C_lib = C.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C.algo;

        // Reusable object
        var W = [];

        /**
         * SHA-1 hash algorithm.
         */
        var SHA1 = C_algo.SHA1 = Hasher.extend({
            _doReset: function () {
                this._hash = new WordArray.init([
                    0x67452301, 0xefcdab89,
                    0x98badcfe, 0x10325476,
                    0xc3d2e1f0
                ]);
            },

            _doProcessBlock: function (M, offset) {
                // Shortcut
                var H = this._hash.words;

                // Working variables
                var a = H[0];
                var b = H[1];
                var c = H[2];
                var d = H[3];
                var e = H[4];

                // Computation
                for (var i = 0; i < 80; i++) {
                    if (i < 16) {
                        W[i] = M[offset + i] | 0;
                    } else {
                        var n = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
                        W[i] = (n << 1) | (n >>> 31);
                    }

                    var t = ((a << 5) | (a >>> 27)) + e + W[i];
                    if (i < 20) {
                        t += ((b & c) | (~b & d)) + 0x5a827999;
                    } else if (i < 40) {
                        t += (b ^ c ^ d) + 0x6ed9eba1;
                    } else if (i < 60) {
                        t += ((b & c) | (b & d) | (c & d)) - 0x70e44324;
                    } else /* if (i < 80) */ {
                        t += (b ^ c ^ d) - 0x359d3e2a;
                    }

                    e = d;
                    d = c;
                    c = (b << 30) | (b >>> 2);
                    b = a;
                    a = t;
                }

                // Intermediate hash value
                H[0] = (H[0] + a) | 0;
                H[1] = (H[1] + b) | 0;
                H[2] = (H[2] + c) | 0;
                H[3] = (H[3] + d) | 0;
                H[4] = (H[4] + e) | 0;
            },

            _doFinalize: function () {
                // Shortcuts
                var data = this._data;
                var dataWords = data.words;

                var nBitsTotal = this._nDataBytes * 8;
                var nBitsLeft = data.sigBytes * 8;

                // Add padding
                dataWords[nBitsLeft >>> 5] |= 0x80 << (24 - nBitsLeft % 32);
                dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 14] = Math.floor(nBitsTotal / 0x100000000);
                dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 15] = nBitsTotal;
                data.sigBytes = dataWords.length * 4;

                // Hash final blocks
                this._process();

                // Return final computed hash
                return this._hash;
            },

            clone: function () {
                var clone = Hasher.clone.call(this);
                clone._hash = this._hash.clone();

                return clone;
            }
        });

        C.SHA1 = Hasher._createHelper(SHA1);
        C.HmacSHA1 = Hasher._createHmacHelper(SHA1);
    }());




    (function (Math) {
        // Shortcuts
        var C = CryptoJS;
        var C_lib = C.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C.algo;

        // Initialization and round constants tables
        var H = [];
        var K = [];

        // Compute constants
        (function () {
            function isPrime(n) {
                var sqrtN = Math.sqrt(n);
                for (var factor = 2; factor <= sqrtN; factor++) {
                    if (!(n % factor)) {
                        return false;
                    }
                }

                return true;
            }

            function getFractionalBits(n) {
                return ((n - (n | 0)) * 0x100000000) | 0;
            }

            var n = 2;
            var nPrime = 0;
            while (nPrime < 64) {
                if (isPrime(n)) {
                    if (nPrime < 8) {
                        H[nPrime] = getFractionalBits(Math.pow(n, 1 / 2));
                    }
                    K[nPrime] = getFractionalBits(Math.pow(n, 1 / 3));

                    nPrime++;
                }

                n++;
            }
        }());

        // Reusable object
        var W = [];

        /**
         * SHA-256 hash algorithm.
         */
        var SHA256 = C_algo.SHA256 = Hasher.extend({
            _doReset: function () {
                this._hash = new WordArray.init(H.slice(0));
            },

            _doProcessBlock: function (M, offset) {
                // Shortcut
                var H = this._hash.words;

                // Working variables
                var a = H[0];
                var b = H[1];
                var c = H[2];
                var d = H[3];
                var e = H[4];
                var f = H[5];
                var g = H[6];
                var h = H[7];

                // Computation
                for (var i = 0; i < 64; i++) {
                    if (i < 16) {
                        W[i] = M[offset + i] | 0;
                    } else {
                        var gamma0x = W[i - 15];
                        var gamma0  = ((gamma0x << 25) | (gamma0x >>> 7))  ^
                                      ((gamma0x << 14) | (gamma0x >>> 18)) ^
                                       (gamma0x >>> 3);

                        var gamma1x = W[i - 2];
                        var gamma1  = ((gamma1x << 15) | (gamma1x >>> 17)) ^
                                      ((gamma1x << 13) | (gamma1x >>> 19)) ^
                                       (gamma1x >>> 10);

                        W[i] = gamma0 + W[i - 7] + gamma1 + W[i - 16];
                    }

                    var ch  = (e & f) ^ (~e & g);
                    var maj = (a & b) ^ (a & c) ^ (b & c);

                    var sigma0 = ((a << 30) | (a >>> 2)) ^ ((a << 19) | (a >>> 13)) ^ ((a << 10) | (a >>> 22));
                    var sigma1 = ((e << 26) | (e >>> 6)) ^ ((e << 21) | (e >>> 11)) ^ ((e << 7)  | (e >>> 25));

                    var t1 = h + sigma1 + ch + K[i] + W[i];
                    var t2 = sigma0 + maj;

                    h = g;
                    g = f;
                    f = e;
                    e = (d + t1) | 0;
                    d = c;
                    c = b;
                    b = a;
                    a = (t1 + t2) | 0;
                }

                // Intermediate hash value
                H[0] = (H[0] + a) | 0;
                H[1] = (H[1] + b) | 0;
                H[2] = (H[2] + c) | 0;
                H[3] = (H[3] + d) | 0;
                H[4] = (H[4] + e) | 0;
                H[5] = (H[5] + f) | 0;
                H[6] = (H[6] + g) | 0;
                H[7] = (H[7] + h) | 0;
            },

            _doFinalize: function () {
                // Shortcuts
                var data = this._data;
                var dataWords = data.words;

                var nBitsTotal = this._nDataBytes * 8;
                var nBitsLeft = data.sigBytes * 8;

                // Add padding
                dataWords[nBitsLeft >>> 5] |= 0x80 << (24 - nBitsLeft % 32);
                dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 14] = Math.floor(nBitsTotal / 0x100000000);
                dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 15] = nBitsTotal;
                data.sigBytes = dataWords.length * 4;

                // Hash final blocks
                this._process();

                // Return final computed hash
                return this._hash;
            },

            clone: function () {
                var clone = Hasher.clone.call(this);
                clone._hash = this._hash.clone();

                return clone;
            }
        });

        C.SHA256 = Hasher._createHelper(SHA256);


        C.HmacSHA256 = Hasher._createHmacHelper(SHA256);
    }(Math));


    /*

    --------------------------------------------------asn1hex-1.1-------------------------------------------------------
    */
    var ASN1HEX = new function() {
    };

    ASN1HEX.getLblen = function(s, idx) {
        if (s.substr(idx + 2, 1) != '8') return 1;
        var i = parseInt(s.substr(idx + 3, 1));
        if (i == 0) return -1;             // length octet '80' indefinite length
        if (0 < i && i < 10) return i + 1; // including '8?' octet;
        return -2;                         // malformed format
    };

    ASN1HEX.getL = function(s, idx) {
        var len = ASN1HEX.getLblen(s, idx);
        if (len < 1) return '';
        return s.substr(idx + 2, len * 2);
    };

    ASN1HEX.getVblen = function(s, idx) {
        var hLen, bi;
        hLen = ASN1HEX.getL(s, idx);
        if (hLen == '') return -1;
        if (hLen.substr(0, 1) === '8') {
            bi = new BigInteger(hLen.substr(2), 16);
        } else {
            bi = new BigInteger(hLen, 16);
        }
    //  console.log("bi---",bi, BigInteger)
        return bi.intValue();
    };


    ASN1HEX.getVidx = function(s, idx) {
        var l_len = ASN1HEX.getLblen(s, idx);
        if (l_len < 0) return l_len;
        return idx + (l_len + 1) * 2;
    };


    ASN1HEX.getV = function(s, idx) {
        var idx1 = ASN1HEX.getVidx(s, idx);
        var blen = ASN1HEX.getVblen(s, idx);
        return s.substr(idx1, blen * 2);
    };

    ASN1HEX.getTLV = function(s, idx) {
        return s.substr(idx, 2) + ASN1HEX.getL(s, idx) + ASN1HEX.getV(s, idx);
    };

    // ========== sibling methods ================================

    ASN1HEX.getNextSiblingIdx = function(s, idx) {
        var idx1 = ASN1HEX.getVidx(s, idx);
        var blen = ASN1HEX.getVblen(s, idx);
        return idx1 + blen * 2;
    };

    // ========== children methods ===============================

    ASN1HEX.getChildIdx = function(h, pos) {
        var _ASN1HEX = ASN1HEX;
        var a = new Array();
        var p0 = _ASN1HEX.getVidx(h, pos);
        if (h.substr(pos, 2) == "03") {
        a.push(p0 + 2); // BITSTRING value without unusedbits
        } else {
        a.push(p0);
        }

        var blen = _ASN1HEX.getVblen(h, pos);
        var p = p0;
        var k = 0;
        while (1) {
            var pNext = _ASN1HEX.getNextSiblingIdx(h, p);
            if (pNext == null || (pNext - p0  >= (blen * 2))) break;
            if (k >= 200) break;
                
            a.push(pNext);
            p = pNext;
                
            k++;
        }
        
        return a;
    };


    ASN1HEX.getNthChildIdx = function(h, idx, nth) {
        var a = ASN1HEX.getChildIdx(h, idx);
        return a[nth];
    };

    // ========== decendant methods ==============================

    ASN1HEX.getIdxbyList = function(h, currentIndex, nthList, checkingTag) {
        var _ASN1HEX = ASN1HEX;
        var firstNth, a;
        if (nthList.length == 0) {
        if (checkingTag !== undefined) {
                if (h.substr(currentIndex, 2) !== checkingTag) {
            throw "checking tag doesn't match: " + 
                        h.substr(currentIndex, 2) + "!=" + checkingTag;
                }
        }
            return currentIndex;
        }
        firstNth = nthList.shift();
        a = _ASN1HEX.getChildIdx(h, currentIndex);
        return _ASN1HEX.getIdxbyList(h, a[firstNth], nthList, checkingTag);
    };


    ASN1HEX.getTLVbyList = function(h, currentIndex, nthList, checkingTag) {
        var _ASN1HEX = ASN1HEX;
        var idx = _ASN1HEX.getIdxbyList(h, currentIndex, nthList);
        if (idx === undefined) {
            throw "can't find nthList object";
        }
        if (checkingTag !== undefined) {
            if (h.substr(idx, 2) != checkingTag) {
                throw "checking tag doesn't match: " + 
                    h.substr(idx,2) + "!=" + checkingTag;
            }
        }
        return _ASN1HEX.getTLV(h, idx);
    };


    ASN1HEX.getVbyList = function(h, currentIndex, nthList, checkingTag, removeUnusedbits) {
        var _ASN1HEX = ASN1HEX;
        var idx, v;
        idx = _ASN1HEX.getIdxbyList(h, currentIndex, nthList, checkingTag);
        
        if (idx === undefined) {
            throw "can't find nthList object";
        }

        v = _ASN1HEX.getV(h, idx);
        if (removeUnusedbits === true) v = v.substr(2);
        return v;
    };


    ASN1HEX.hextooidstr = function(hex) {
        var zeroPadding = function(s, len) {
            if (s.length >= len) return s;
            return new Array(len - s.length + 1).join('0') + s;
        };

        var a = [];

        // a[0], a[1]
        var hex0 = hex.substr(0, 2);
        var i0 = parseInt(hex0, 16);
        a[0] = new String(Math.floor(i0 / 40));
        a[1] = new String(i0 % 40);

        // a[2]..a[n]
       var hex1 = hex.substr(2);
        var b = [];
        for (var i = 0; i < hex1.length / 2; i++) {
        b.push(parseInt(hex1.substr(i * 2, 2), 16));
        }
        var c = [];
        var cbin = "";
        for (var i = 0; i < b.length; i++) {
            if (b[i] & 0x80) {
                cbin = cbin + zeroPadding((b[i] & 0x7f).toString(2), 7);
            } else {
                cbin = cbin + zeroPadding((b[i] & 0x7f).toString(2), 7);
                c.push(new String(parseInt(cbin, 2)));
                cbin = "";
            }
        }

        var s = a.join(".");
        if (c.length > 0) s = s + "." + c.join(".");
        return s;
    };

    ASN1HEX.dump = function(hexOrObj, flags, idx, indent) {
        var _ASN1HEX = ASN1HEX;
        var _getV = _ASN1HEX.getV;
        var _dump = _ASN1HEX.dump;
        var _getChildIdx = _ASN1HEX.getChildIdx;

        var hex = hexOrObj;
        if (hexOrObj instanceof KJUR.asn1.ASN1Object)
        hex = hexOrObj.getEncodedHex();

        var _skipLongHex = function(hex, limitNumOctet) {
        if (hex.length <= limitNumOctet * 2) {
            return hex;
        } else {
            var s = hex.substr(0, limitNumOctet) + 
                "..(total " + hex.length / 2 + "bytes).." +
                hex.substr(hex.length - limitNumOctet, limitNumOctet);
            return s;
        };
        };

        if (flags === undefined) flags = { "ommit_long_octet": 32 };
        if (idx === undefined) idx = 0;
        if (indent === undefined) indent = "";
        var skipLongHex = flags.ommit_long_octet;

        if (hex.substr(idx, 2) == "01") {
        var v = _getV(hex, idx);
        if (v == "00") {
            return indent + "BOOLEAN FALSE\n";
        } else {
            return indent + "BOOLEAN TRUE\n";
        }
        }
        if (hex.substr(idx, 2) == "02") {
        var v = _getV(hex, idx);
        return indent + "INTEGER " + _skipLongHex(v, skipLongHex) + "\n";
        }
        if (hex.substr(idx, 2) == "03") {
        var v = _getV(hex, idx);
        return indent + "BITSTRING " + _skipLongHex(v, skipLongHex) + "\n";
        }
        if (hex.substr(idx, 2) == "04") {
        var v = _getV(hex, idx);
        if (_ASN1HEX.isASN1HEX(v)) {
            var s = indent + "OCTETSTRING, encapsulates\n";
            s = s + _dump(v, flags, 0, indent + "  ");
            return s;
        } else {
            return indent + "OCTETSTRING " + _skipLongHex(v, skipLongHex) + "\n";
        }
        }
        if (hex.substr(idx, 2) == "05") {
        return indent + "NULL\n";
        }
        if (hex.substr(idx, 2) == "06") {
        var hV = _getV(hex, idx);
            var oidDot = KJUR.asn1.ASN1Util.oidHexToInt(hV);
            var oidName = KJUR.asn1.x509.OID.oid2name(oidDot);
        var oidSpc = oidDot.replace(/\./g, ' ');
            if (oidName != '') {
            return indent + "ObjectIdentifier " + oidName + " (" + oidSpc + ")\n";
        } else {
            return indent + "ObjectIdentifier (" + oidSpc + ")\n";
        }
        }
        if (hex.substr(idx, 2) == "0c") {
        return indent + "UTF8String '" + hextoutf8(_getV(hex, idx)) + "'\n";
        }
        if (hex.substr(idx, 2) == "13") {
        return indent + "PrintableString '" + hextoutf8(_getV(hex, idx)) + "'\n";
        }
        if (hex.substr(idx, 2) == "14") {
        return indent + "TeletexString '" + hextoutf8(_getV(hex, idx)) + "'\n";
        }
        if (hex.substr(idx, 2) == "16") {
        return indent + "IA5String '" + hextoutf8(_getV(hex, idx)) + "'\n";
        }
        if (hex.substr(idx, 2) == "17") {
        return indent + "UTCTime " + hextoutf8(_getV(hex, idx)) + "\n";
        }
        if (hex.substr(idx, 2) == "18") {
        return indent + "GeneralizedTime " + hextoutf8(_getV(hex, idx)) + "\n";
        }
        if (hex.substr(idx, 2) == "30") {
        if (hex.substr(idx, 4) == "3000") {
            return indent + "SEQUENCE {}\n";
        }

        var s = indent + "SEQUENCE\n";
        var aIdx = _getChildIdx(hex, idx);

        var flagsTemp = flags;
        
        if ((aIdx.length == 2 || aIdx.length == 3) &&
            hex.substr(aIdx[0], 2) == "06" &&
            hex.substr(aIdx[aIdx.length - 1], 2) == "04") { // supposed X.509v3 extension
            var oidName = _ASN1HEX.oidname(_getV(hex, aIdx[0]));
            var flagsClone = JSON.parse(JSON.stringify(flags));
            flagsClone.x509ExtName = oidName;
            flagsTemp = flagsClone;
        }
        
        for (var i = 0; i < aIdx.length; i++) {
            s = s + _dump(hex, flagsTemp, aIdx[i], indent + "  ");
        }
        return s;
        }
        if (hex.substr(idx, 2) == "31") {
        var s = indent + "SET\n";
        var aIdx = _getChildIdx(hex, idx);
        for (var i = 0; i < aIdx.length; i++) {
            s = s + _dump(hex, flags, aIdx[i], indent + "  ");
        }
        return s;
        }
        var tag = parseInt(hex.substr(idx, 2), 16);
        if ((tag & 128) != 0) { // context specific 
        var tagNumber = tag & 31;
        if ((tag & 32) != 0) { // structured tag
            var s = indent + "[" + tagNumber + "]\n";
            var aIdx = _getChildIdx(hex, idx);
            for (var i = 0; i < aIdx.length; i++) {
            s = s + _dump(hex, flags, aIdx[i], indent + "  ");
            }
            return s;
        } else { // primitive tag
            var v = _getV(hex, idx);
            if (v.substr(0, 8) == "68747470") { // http
            v = hextoutf8(v);
            }
            if (flags.x509ExtName === "subjectAltName" &&
            tagNumber == 2) {
            v = hextoutf8(v);
            }
            
            var s = indent + "[" + tagNumber + "] " + v + "\n";
            return s;
        }
        }
        return indent + "UNKNOWN(" + hex.substr(idx, 2) + ") " + 
           _getV(hex, idx) + "\n";
    };


    ASN1HEX.isASN1HEX = function(hex) {
        var _ASN1HEX = ASN1HEX;
        if (hex.length % 2 == 1) return false;

        var intL = _ASN1HEX.getVblen(hex, 0);
        var tV = hex.substr(0, 2);
        var lV = _ASN1HEX.getL(hex, 0);
        var hVLength = hex.length - tV.length - lV.length;
        if (hVLength == intL * 2) return true;

        return false;
    };

    ASN1HEX.oidname = function(oidDotOrHex) {
        var _KJUR_asn1 = KJUR.asn1;
        if (KJUR.lang.String.isHex(oidDotOrHex))
        oidDotOrHex = _KJUR_asn1.ASN1Util.oidHexToInt(oidDotOrHex);
        var name = _KJUR_asn1.x509.OID.oid2name(oidDotOrHex);
        if (name === "") name = oidDotOrHex;
        return name;
    };


    /*

    --------------------------------------------------base64x-1.1-------------------------------------------------------
    */
    var KJUR;
    if (typeof KJUR == "undefined" || !KJUR) KJUR = {};
    if (typeof KJUR.lang == "undefined" || !KJUR.lang) KJUR.lang = {};


    KJUR.lang.String = function() {};


    function Base64x() {
    }


    function stoBA(s) {
        var a = new Array();
        for (var i = 0; i < s.length; i++) {
        a[i] = s.charCodeAt(i);
        }
        return a;
    }


    function BAtos(a) {
        var s = "";
        for (var i = 0; i < a.length; i++) {
        s = s + String.fromCharCode(a[i]);
        }
        return s;
    }


    function BAtohex(a) {
        var s = "";
        for (var i = 0; i < a.length; i++) {
        var hex1 = a[i].toString(16);
        if (hex1.length == 1) hex1 = "0" + hex1;
        s = s + hex1;
        }
        return s;
    }


    function stohex(s) {
        return BAtohex(stoBA(s));
    }

    function stob64(s) {
        return hex2b64(stohex(s));
    }

    function stob64u(s) {
        return b64tob64u(hex2b64(stohex(s)));
    }

    function b64utos(s) {
        return BAtos(b64toBA(b64utob64(s)));
    }

    function b64tob64u(s) {
        s = s.replace(/\=/g, "");
        s = s.replace(/\+/g, "-");
        s = s.replace(/\//g, "_");
        return s;
    }

    function b64utob64(s) {
        if (s.length % 4 == 2) s = s + "==";
        else if (s.length % 4 == 3) s = s + "=";
        s = s.replace(/-/g, "+");
        s = s.replace(/_/g, "/");
        return s;
    }

    function hextob64u(s) {
        if (s.length % 2 == 1) s = "0" + s;
        return b64tob64u(hex2b64(s));
    }

    function b64utohex(s) {
        return b64tohex(b64utob64(s));
    }

    var utf8tob64u, b64utoutf8;

    if (typeof Buffer === 'function') {
      utf8tob64u = function (s) {
        return b64tob64u(new Buffer(s, 'utf8').toString('base64'));
      };

      b64utoutf8 = function (s) {
        return new Buffer(b64utob64(s), 'base64').toString('utf8');
      };
    } else {
      utf8tob64u = function (s) {
        return hextob64u(uricmptohex(encodeURIComponentAll(s)));
      };

      b64utoutf8 = function (s) {
        return decodeURIComponent(hextouricmp(b64utohex(s)));
      };
    }

    function utf8tob64(s) {
      return hex2b64(uricmptohex(encodeURIComponentAll(s)));
    }

    function b64toutf8(s) {
      return decodeURIComponent(hextouricmp(b64tohex(s)));
    }

    function utf8tohex(s) {
      return uricmptohex(encodeURIComponentAll(s));
    }

    function hextoutf8(s) {
      return decodeURIComponent(hextouricmp(s));
    }

    function hextorstr(sHex) {
        var s = "";
        for (var i = 0; i < sHex.length - 1; i += 2) {
            s += String.fromCharCode(parseInt(sHex.substr(i, 2), 16));
        }
        return s;
    }

    function rstrtohex(s) {
        var result = "";
        for (var i = 0; i < s.length; i++) {
            result += ("0" + s.charCodeAt(i).toString(16)).slice(-2);
        }
        return result;
    }

    function hextob64(s) {
        return hex2b64(s);
    }

    function hextob64nl(s) {
        var b64 = hextob64(s);
        var b64nl = b64.replace(/(.{64})/g, "$1\r\n");
        b64nl = b64nl.replace(/\r\n$/, '');
        return b64nl;
    }


    function b64nltohex(s) {
        var b64 = s.replace(/[^0-9A-Za-z\/+=]*/g, '');
        var hex = b64tohex(b64);
        return hex;
    } 

    function hextopem(dataHex, pemHeader) {
        var pemBody = hextob64nl(dataHex);
        return "-----BEGIN " + pemHeader + "-----\r\n" + 
            pemBody + 
            "\r\n-----END " + pemHeader + "-----\r\n";
    }

    function pemtohex(s, sHead) {
        if (s.indexOf("-----BEGIN ") == -1)
            throw "can't find PEM header: " + sHead;

        if (sHead !== undefined) {
            s = s.replace("-----BEGIN " + sHead + "-----", "");
            s = s.replace("-----END " + sHead + "-----", "");
        } else {
            s = s.replace(/-----BEGIN [^-]+-----/, '');
            s = s.replace(/-----END [^-]+-----/, '');
        }
        return b64nltohex(s);
    }

    function hextoArrayBuffer(hex) {
        if (hex.length % 2 != 0) throw "input is not even length";
        if (hex.match(/^[0-9A-Fa-f]+$/) == null) throw "input is not hexadecimal";

        var buffer = new ArrayBuffer(hex.length / 2);
        var view = new DataView(buffer);

        for (var i = 0; i < hex.length / 2; i++) {
        view.setUint8(i, parseInt(hex.substr(i * 2, 2), 16));
        }

        return buffer;
    }

    function ArrayBuffertohex(buffer) {
        var hex = "";
        var view = new DataView(buffer);

        for (var i = 0; i < buffer.byteLength; i++) {
        hex += ("00" + view.getUint8(i).toString(16)).slice(-2);
        }

        return hex;
    }

    function zulutomsec(s) {
        var year, month, day, hour, min, sec, msec, d;
        var sYear, sFrac, sMsec, matchResult;

        matchResult = s.match(/^(\d{2}|\d{4})(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(|\.\d+)Z$/);

        if (matchResult) {
            sYear = matchResult[1];
        year = parseInt(sYear);
            if (sYear.length === 2) {
            if (50 <= year && year < 100) {
            year = 1900 + year;
            } else if (0 <= year && year < 50) {
            year = 2000 + year;
            }
        }
        month = parseInt(matchResult[2]) - 1;
        day = parseInt(matchResult[3]);
        hour = parseInt(matchResult[4]);
        min = parseInt(matchResult[5]);
        sec = parseInt(matchResult[6]);
        msec = 0;

        sFrac = matchResult[7];
        if (sFrac !== "") {
            sMsec = (sFrac.substr(1) + "00").substr(0, 3); // .12 -> 012
            msec = parseInt(sMsec);
        }
        return Date.UTC(year, month, day, hour, min, sec, msec);
        }
        throw "unsupported zulu format: " + s;
    }

    function zulutosec(s) {
        var msec = zulutomsec(s);
        return ~~(msec / 1000);
    }

    function zulutodate(s) {
        return new Date(zulutomsec(s));
    }

    function datetozulu(d, flagUTCTime, flagMilli) {
        var s;
        var year = d.getUTCFullYear();
        if (flagUTCTime) {
        if (year < 1950 || 2049 < year) 
            throw "not proper year for UTCTime: " + year;
        s = ("" + year).slice(-2);
        } else {
        s = ("000" + year).slice(-4);
        }
        s += ("0" + (d.getUTCMonth() + 1)).slice(-2);
        s += ("0" + d.getUTCDate()).slice(-2);
        s += ("0" + d.getUTCHours()).slice(-2);
        s += ("0" + d.getUTCMinutes()).slice(-2);
        s += ("0" + d.getUTCSeconds()).slice(-2);
        if (flagMilli) {
        var milli = d.getUTCMilliseconds();
        if (milli !== 0) {
            milli = ("00" + milli).slice(-3);
            milli = milli.replace(/0+$/g, "");
            s += "." + milli;
        }
        }
        s += "Z";
        return s;
    }

    function uricmptohex(s) {
      return s.replace(/%/g, "");
    }

    function hextouricmp(s) {
      return s.replace(/(..)/g, "%$1");
    }

    function ipv6tohex(s) {
      var msgMalformedAddress = "malformed IPv6 address";
      if (! s.match(/^[0-9A-Fa-f:]+$/))
        throw msgMalformedAddress;

      // 1. downcase
      s = s.toLowerCase();

      // 2. expand ::
      var num_colon = s.split(':').length - 1;
      if (num_colon < 2) throw msgMalformedAddress;
      var colon_replacer = ':'.repeat(7 - num_colon + 2);
      s = s.replace('::', colon_replacer);

      // 3. fill zero
      var a = s.split(':');
      if (a.length != 8) throw msgMalformedAddress;
      for (var i = 0; i < 8; i++) {
        a[i] = ("0000" + a[i]).slice(-4);
      }
      return a.join('');
    }

    function hextoipv6(s) {
      if (! s.match(/^[0-9A-Fa-f]{32}$/))
        throw "malformed IPv6 address octet";

      // 1. downcase
      s = s.toLowerCase();

      // 2. split 4
      var a = s.match(/.{1,4}/g);

      // 3. trim leading 0
      for (var i = 0; i < 8; i++) {
        a[i] = a[i].replace(/^0+/, "");
        if (a[i] == '') a[i] = '0';
      }
      s = ":" + a.join(":") + ":";

      // 4. find shrinkables :0:0:...
      var aZero = s.match(/:(0:){2,}/g);

      // 5. no shrinkable
      if (aZero === null) return s.slice(1, -1);

      // 6. find max length :0:0:...
      var item = '';
      for (var i = 0; i < aZero.length; i++) {
        if (aZero[i].length > item.length) item = aZero[i];
      }

      // 7. shrink
      s = s.replace(item, '::');
      return s.slice(1, -1);
    }

    function hextoip(s) {
      var malformedMsg = "malformed hex value";
      if (! s.match(/^([0-9A-Fa-f][0-9A-Fa-f]){1,}$/))
        throw malformedMsg;
      if (s.length == 8) { // ipv4
        var ip;
        try {
          ip = parseInt(s.substr(0, 2), 16) + "." +
               parseInt(s.substr(2, 2), 16) + "." +
               parseInt(s.substr(4, 2), 16) + "." +
               parseInt(s.substr(6, 2), 16);
          return ip;
        } catch (ex) {
          throw malformedMsg;
        }
      } else if (s.length == 32) {
        return hextoipv6(s);
      } else {
        return s;
      }
    }

    function iptohex(s) {
      var malformedMsg = "malformed IP address";
      s = s.toLowerCase(s);

      if (s.match(/^[0-9.]+$/)) {
        var a = s.split(".");
        if (a.length !== 4) throw malformedMsg;
        var hex = "";
        try {
          for (var i = 0; i < 4; i++) {
            var d = parseInt(a[i]);
            hex += ("0" + d.toString(16)).slice(-2);
          }
          return hex;
        } catch(ex) {
          throw malformedMsg;
        }
      } else if (s.match(/^[0-9a-f:]+$/) && s.indexOf(":") !== -1) {
        return ipv6tohex(s);
      } else {
        throw malformedMsg;
      }
    }

    function encodeURIComponentAll(u8) {
      var s = encodeURIComponent(u8);
      var s2 = "";
      for (var i = 0; i < s.length; i++) {
        if (s[i] == "%") {
          s2 = s2 + s.substr(i, 3);
          i = i + 2;
        } else {
          s2 = s2 + "%" + stohex(s[i]);
        }
      }
      return s2;
    }

    // ==== new lines ================================
    function newline_toUnix(s) {
        s = s.replace(/\r\n/mg, "\n");
        return s;
    }

    function newline_toDos(s) {
        s = s.replace(/\r\n/mg, "\n");
        s = s.replace(/\n/mg, "\r\n");
        return s;
    }


    KJUR.lang.String.isInteger = function(s) {
        if (s.match(/^[0-9]+$/)) {
        return true;
        } else if (s.match(/^-[0-9]+$/)) {
        return true;
        } else {
        return false;
        }
    };

    KJUR.lang.String.isHex = function(s) {
        if (s.length % 2 == 0 &&
        (s.match(/^[0-9a-f]+$/) || s.match(/^[0-9A-F]+$/))) {
        return true;
        } else {
        return false;
        }
    };

    KJUR.lang.String.isBase64 = function(s) {
        s = s.replace(/\s+/g, "");
        if (s.match(/^[0-9A-Za-z+\/]+={0,3}$/) && s.length % 4 == 0) {
        return true;
        } else {
        return false;
        }
    };

    KJUR.lang.String.isBase64URL = function(s) {
        if (s.match(/[+/=]/)) return false;
        s = b64utob64(s);
        return KJUR.lang.String.isBase64(s);
    };

    KJUR.lang.String.isIntegerArray = function(s) {
        s = s.replace(/\s+/g, "");
        if (s.match(/^\[[0-9,]+\]$/)) {
        return true;
        } else {
        return false;
        }
    };


    function hextoposhex(s) {
        if (s.length % 2 == 1) return "0" + s;
        if (s.substr(0, 1) > "7") return "00" + s;
        return s;
    }

    function intarystrtohex(s) {
      s = s.replace(/^\s*\[\s*/, '');
      s = s.replace(/\s*\]\s*$/, '');
      s = s.replace(/\s*/g, '');
      try {
        var hex = s.split(/,/).map(function(element, index, array) {
          var i = parseInt(element);
          if (i < 0 || 255 < i) throw "integer not in range 0-255";
          var hI = ("00" + i.toString(16)).slice(-2);
          return hI;
        }).join('');
        return hex;
      } catch(ex) {
        throw "malformed integer array string: " + ex;
      }
    }

    var strdiffidx = function(s1, s2) {
        var n = s1.length;
        if (s1.length > s2.length) n = s2.length;
        for (var i = 0; i < n; i++) {
        if (s1.charCodeAt(i) != s2.charCodeAt(i)) return i;
        }
        if (s1.length != s2.length) return n;
        return -1; // same
    };




    /*

    --------------------------------------------------crypto-1.1-------------------------------------------------------
    */

    if (typeof KJUR == "undefined" || !KJUR) KJUR = {};

    if (typeof KJUR.crypto == "undefined" || !KJUR.crypto) KJUR.crypto = {};


    KJUR.crypto.Util = new function() {
        this.DIGESTINFOHEAD = {
        'sha1':      "3021300906052b0e03021a05000414",
        'sha224':    "302d300d06096086480165030402040500041c",
        'sha256':    "3031300d060960864801650304020105000420",
        'sha384':    "3041300d060960864801650304020205000430",
        'sha512':    "3051300d060960864801650304020305000440",
        'md2':       "3020300c06082a864886f70d020205000410",
        'md5':       "3020300c06082a864886f70d020505000410",
        'ripemd160': "3021300906052b2403020105000414",
        };

        /*
         * @since crypto 1.1.1
         */
        this.DEFAULTPROVIDER = {
        'md5':          'cryptojs',
        'sha1':         'cryptojs',
        'sha224':       'cryptojs',
        'sha256':       'cryptojs',
        'sha384':       'cryptojs',
        'sha512':       'cryptojs',
        'ripemd160':        'cryptojs',
        'hmacmd5':      'cryptojs',
        'hmacsha1':     'cryptojs',
        'hmacsha224':       'cryptojs',
        'hmacsha256':       'cryptojs',
        'hmacsha384':       'cryptojs',
        'hmacsha512':       'cryptojs',
        'hmacripemd160':    'cryptojs',

        'MD5withRSA':       'cryptojs/jsrsa',
        'SHA1withRSA':      'cryptojs/jsrsa',
        'SHA224withRSA':    'cryptojs/jsrsa',
        'SHA256withRSA':    'cryptojs/jsrsa',
        'SHA384withRSA':    'cryptojs/jsrsa',
        'SHA512withRSA':    'cryptojs/jsrsa',
        'RIPEMD160withRSA': 'cryptojs/jsrsa',

        'MD5withECDSA':     'cryptojs/jsrsa',
        'SHA1withECDSA':    'cryptojs/jsrsa',
        'SHA224withECDSA':  'cryptojs/jsrsa',
        'SHA256withECDSA':  'cryptojs/jsrsa',
        'SHA384withECDSA':  'cryptojs/jsrsa',
        'SHA512withECDSA':  'cryptojs/jsrsa',
        'RIPEMD160withECDSA':   'cryptojs/jsrsa',

        'SHA1withDSA':      'cryptojs/jsrsa',
        'SHA224withDSA':    'cryptojs/jsrsa',
        'SHA256withDSA':    'cryptojs/jsrsa',

        'MD5withRSAandMGF1':        'cryptojs/jsrsa',
        'SHA1withRSAandMGF1':       'cryptojs/jsrsa',
        'SHA224withRSAandMGF1':     'cryptojs/jsrsa',
        'SHA256withRSAandMGF1':     'cryptojs/jsrsa',
        'SHA384withRSAandMGF1':     'cryptojs/jsrsa',
        'SHA512withRSAandMGF1':     'cryptojs/jsrsa',
        'RIPEMD160withRSAandMGF1':  'cryptojs/jsrsa',
        };

        this.CRYPTOJSMESSAGEDIGESTNAME = {
        'md5':      CryptoJS.algo.MD5,
        'sha1':     CryptoJS.algo.SHA1,
        'sha224':   CryptoJS.algo.SHA224,
        'sha256':   CryptoJS.algo.SHA256,
        'sha384':   CryptoJS.algo.SHA384,
        'sha512':   CryptoJS.algo.SHA512,
        'ripemd160':    CryptoJS.algo.RIPEMD160
        };

        this.getDigestInfoHex = function(hHash, alg) {
        if (typeof this.DIGESTINFOHEAD[alg] == "undefined")
            throw "alg not supported in Util.DIGESTINFOHEAD: " + alg;
        return this.DIGESTINFOHEAD[alg] + hHash;
        };

        this.getPaddedDigestInfoHex = function(hHash, alg, keySize) {
        var hDigestInfo = this.getDigestInfoHex(hHash, alg);
        var pmStrLen = keySize / 4; // minimum PM length

        if (hDigestInfo.length + 22 > pmStrLen) // len(0001+ff(*8)+00+hDigestInfo)=22
            throw "key is too short for SigAlg: keylen=" + keySize + "," + alg;

        var hHead = "0001";
        var hTail = "00" + hDigestInfo;
        var hMid = "";
        var fLen = pmStrLen - hHead.length - hTail.length;
        for (var i = 0; i < fLen; i += 2) {
            hMid += "ff";
        }
        var hPaddedMessage = hHead + hMid + hTail;
        return hPaddedMessage;
        };

        this.hashString = function(s, alg) {
            var md = new KJUR.crypto.MessageDigest({'alg': alg});
            return md.digestString(s);
        };

        this.hashHex = function(sHex, alg) {
            var md = new KJUR.crypto.MessageDigest({'alg': alg});
            return md.digestHex(sHex);
        };

        this.sha1 = function(s) {
            var md = new KJUR.crypto.MessageDigest({'alg':'sha1', 'prov':'cryptojs'});
            return md.digestString(s);
        };

        this.sha256 = function(s) {
            var md = new KJUR.crypto.MessageDigest({'alg':'sha256', 'prov':'cryptojs'});
            return md.digestString(s);
        };

        this.sha256Hex = function(s) {
            var md = new KJUR.crypto.MessageDigest({'alg':'sha256', 'prov':'cryptojs'});
            return md.digestHex(s);
        };

        this.sha512 = function(s) {
            var md = new KJUR.crypto.MessageDigest({'alg':'sha512', 'prov':'cryptojs'});
            return md.digestString(s);
        };

        this.sha512Hex = function(s) {
            var md = new KJUR.crypto.MessageDigest({'alg':'sha512', 'prov':'cryptojs'});
            return md.digestHex(s);
        };

    };

    KJUR.crypto.Util.md5 = function(s) {
        var md = new KJUR.crypto.MessageDigest({'alg':'md5', 'prov':'cryptojs'});
        return md.digestString(s);
    };

    KJUR.crypto.Util.ripemd160 = function(s) {
        var md = new KJUR.crypto.MessageDigest({'alg':'ripemd160', 'prov':'cryptojs'});
        return md.digestString(s);
    };

    KJUR.crypto.Util.SECURERANDOMGEN = new SecureRandom();

    KJUR.crypto.Util.getRandomHexOfNbytes = function(n) {
        var ba = new Array(n);
        KJUR.crypto.Util.SECURERANDOMGEN.nextBytes(ba);
        return BAtohex(ba);
    };

    KJUR.crypto.Util.getRandomBigIntegerOfNbytes = function(n) {
        return new BigInteger(KJUR.crypto.Util.getRandomHexOfNbytes(n), 16);
    };


    KJUR.crypto.Util.getRandomHexOfNbits = function(n) {
        var n_remainder = n % 8;
        var n_quotient = (n - n_remainder) / 8;
        var ba = new Array(n_quotient + 1);
        KJUR.crypto.Util.SECURERANDOMGEN.nextBytes(ba);
        ba[0] = (((255 << n_remainder) & 255) ^ 255) & ba[0];
        return BAtohex(ba);
    };

    KJUR.crypto.Util.getRandomBigIntegerOfNbits = function(n) {
        return new BigInteger(KJUR.crypto.Util.getRandomHexOfNbits(n), 16);
    };

    KJUR.crypto.Util.getRandomBigIntegerZeroToMax = function(biMax) {
        var bitLenMax = biMax.bitLength();
        while (1) {
        var biRand = KJUR.crypto.Util.getRandomBigIntegerOfNbits(bitLenMax);
        if (biMax.compareTo(biRand) != -1) return biRand;
        }
    };

    KJUR.crypto.Util.getRandomBigIntegerMinToMax = function(biMin, biMax) {
        var flagCompare = biMin.compareTo(biMax);
        if (flagCompare == 1) throw "biMin is greater than biMax";
        if (flagCompare == 0) return biMin;

        var biDiff = biMax.subtract(biMin);
        var biRand = KJUR.crypto.Util.getRandomBigIntegerZeroToMax(biDiff);
        return biRand.add(biMin);
    };

    KJUR.crypto.MessageDigest = function(params) {
        var md = null;
        var algName = null;
        var provName = null;

        this.setAlgAndProvider = function(alg, prov) {
        alg = KJUR.crypto.MessageDigest.getCanonicalAlgName(alg);

        if (alg !== null && prov === undefined) prov = KJUR.crypto.Util.DEFAULTPROVIDER[alg];

        // for cryptojs
        if (':md5:sha1:sha224:sha256:sha384:sha512:ripemd160:'.indexOf(alg) != -1 &&
            prov == 'cryptojs') {
            try {
              console.log('KJUR.crypto.Util.CRYPTOJSMESSAGEDIGESTNAME[alg]--',KJUR.crypto.Util.CRYPTOJSMESSAGEDIGESTNAME, alg, "-----:",CryptoJS);
            this.md = KJUR.crypto.Util.CRYPTOJSMESSAGEDIGESTNAME[alg].create();
            } catch (ex) {
            throw "setAlgAndProvider hash alg set fail alg=" + alg + "/" + ex;
            }
            this.updateString = function(str) {
            this.md.update(str);
            };
            this.updateHex = function(hex) {
            var wHex = CryptoJS.enc.Hex.parse(hex);
            this.md.update(wHex);
            };
            this.digest = function() {
            var hash = this.md.finalize();
            return hash.toString(CryptoJS.enc.Hex);
            };
            this.digestString = function(str) {
            this.updateString(str);
            return this.digest();
            };
            this.digestHex = function(hex) {
            this.updateHex(hex);
            return this.digest();
            };
        }
        if (':sha256:'.indexOf(alg) != -1 &&
            prov == 'sjcl') {
            try {
            this.md = new sjcl.hash.sha256();
            } catch (ex) {
            throw "setAlgAndProvider hash alg set fail alg=" + alg + "/" + ex;
            }
            this.updateString = function(str) {
            this.md.update(str);
            };
            this.updateHex = function(hex) {
            var baHex = sjcl.codec.hex.toBits(hex);
            this.md.update(baHex);
            };
            this.digest = function() {
            var hash = this.md.finalize();
            return sjcl.codec.hex.fromBits(hash);
            };
            this.digestString = function(str) {
            this.updateString(str);
            return this.digest();
            };
            this.digestHex = function(hex) {
            this.updateHex(hex);
            return this.digest();
            };
        }
        };

        this.updateString = function(str) {
        throw "updateString(str) not supported for this alg/prov: " + this.algName + "/" + this.provName;
        };

        this.updateHex = function(hex) {
        throw "updateHex(hex) not supported for this alg/prov: " + this.algName + "/" + this.provName;
        };

        this.digest = function() {
        throw "digest() not supported for this alg/prov: " + this.algName + "/" + this.provName;
        };

        this.digestString = function(str) {
        throw "digestString(str) not supported for this alg/prov: " + this.algName + "/" + this.provName;
        };

        this.digestHex = function(hex) {
        throw "digestHex(hex) not supported for this alg/prov: " + this.algName + "/" + this.provName;
        };

        if (params !== undefined) {
        if (params['alg'] !== undefined) {
            this.algName = params['alg'];
            if (params['prov'] === undefined)
            this.provName = KJUR.crypto.Util.DEFAULTPROVIDER[this.algName];
            this.setAlgAndProvider(this.algName, this.provName);
        }
        }
    };

    KJUR.crypto.MessageDigest.getCanonicalAlgName = function(alg) {
        if (typeof alg === "string") {
        alg = alg.toLowerCase();
        alg = alg.replace(/-/, '');
        }
        return alg;
    };

    KJUR.crypto.MessageDigest.getHashLength = function(alg) {
        var MD = KJUR.crypto.MessageDigest;
        var alg2 = MD.getCanonicalAlgName(alg);
        if (MD.HASHLENGTH[alg2] === undefined)
        throw "not supported algorithm: " + alg;
        return MD.HASHLENGTH[alg2];
    };

    // described in KJUR.crypto.MessageDigest class (since jsrsasign 6.2.0 crypto 1.1.10)
    KJUR.crypto.MessageDigest.HASHLENGTH = {
        'md5':      16,
        'sha1':     20,
        'sha224':       28,
        'sha256':       32,
        'sha384':       48,
        'sha512':       64,
        'ripemd160':    20
    };

    KJUR.crypto.Mac = function(params) {
        var mac = null;
        var pass = null;
        var algName = null;
        var provName = null;
        var algProv = null;

        this.setAlgAndProvider = function(alg, prov) {
        alg = alg.toLowerCase();

        if (alg == null) alg = "hmacsha1";

        alg = alg.toLowerCase();
            if (alg.substr(0, 4) != "hmac") {
            throw "setAlgAndProvider unsupported HMAC alg: " + alg;
        }

        if (prov === undefined) prov = KJUR.crypto.Util.DEFAULTPROVIDER[alg];
        this.algProv = alg + "/" + prov;

        var hashAlg = alg.substr(4);

        // for cryptojs
        if (':md5:sha1:sha224:sha256:sha384:sha512:ripemd160:'.indexOf(hashAlg) != -1 &&
            prov == 'cryptojs') {
            try {
            var mdObj = KJUR.crypto.Util.CRYPTOJSMESSAGEDIGESTNAME[hashAlg];
            this.mac = CryptoJS.algo.HMAC.create(mdObj, this.pass);
            } catch (ex) {
            throw "setAlgAndProvider hash alg set fail hashAlg=" + hashAlg + "/" + ex;
            }
            this.updateString = function(str) {
            this.mac.update(str);
            };
            this.updateHex = function(hex) {
            var wHex = CryptoJS.enc.Hex.parse(hex);
            this.mac.update(wHex);
            };
            this.doFinal = function() {
            var hash = this.mac.finalize();
            return hash.toString(CryptoJS.enc.Hex);
            };
            this.doFinalString = function(str) {
            this.updateString(str);
            return this.doFinal();
            };
            this.doFinalHex = function(hex) {
            this.updateHex(hex);
            return this.doFinal();
            };
        }
        };

        this.updateString = function(str) {
        throw "updateString(str) not supported for this alg/prov: " + this.algProv;
        };

        this.updateHex = function(hex) {
        throw "updateHex(hex) not supported for this alg/prov: " + this.algProv;
        };

        this.doFinal = function() {
        throw "digest() not supported for this alg/prov: " + this.algProv;
        };

        this.doFinalString = function(str) {
        throw "digestString(str) not supported for this alg/prov: " + this.algProv;
        };

        this.doFinalHex = function(hex) {
        throw "digestHex(hex) not supported for this alg/prov: " + this.algProv;
        };

        this.setPassword = function(pass) {

        if (typeof pass == 'string') {
            var hPass = pass;
            if (pass.length % 2 == 1 || ! pass.match(/^[0-9A-Fa-f]+$/)) { // raw str
            hPass = rstrtohex(pass);
            }
            this.pass = CryptoJS.enc.Hex.parse(hPass);
            return;
        }

        if (typeof pass != 'object')
            throw "KJUR.crypto.Mac unsupported password type: " + pass;
        
        var hPass = null;
        if (pass.hex  !== undefined) {
            if (pass.hex.length % 2 != 0 || ! pass.hex.match(/^[0-9A-Fa-f]+$/))
            throw "Mac: wrong hex password: " + pass.hex;
            hPass = pass.hex;
        }
        if (pass.utf8 !== undefined) hPass = utf8tohex(pass.utf8);
        if (pass.rstr !== undefined) hPass = rstrtohex(pass.rstr);
        if (pass.b64  !== undefined) hPass = b64tohex(pass.b64);
        if (pass.b64u !== undefined) hPass = b64utohex(pass.b64u);

        if (hPass == null)
            throw "KJUR.crypto.Mac unsupported password type: " + pass;

        this.pass = CryptoJS.enc.Hex.parse(hPass);
        };

        if (params !== undefined) {
        if (params.pass !== undefined) {
            this.setPassword(params.pass);
        }
        if (params.alg !== undefined) {
            this.algName = params.alg;
            if (params['prov'] === undefined)
            this.provName = KJUR.crypto.Util.DEFAULTPROVIDER[this.algName];
            this.setAlgAndProvider(this.algName, this.provName);
        }
        }
    };

    KJUR.crypto.Signature = function(params) {
        var prvKey = null; // RSAKey/KJUR.crypto.{ECDSA,DSA} object for signing
        var pubKey = null; // RSAKey/KJUR.crypto.{ECDSA,DSA} object for verifying

        var md = null; // KJUR.crypto.MessageDigest object
        var sig = null;
        var algName = null;
        var provName = null;
        var algProvName = null;
        var mdAlgName = null;
        var pubkeyAlgName = null;   // rsa,ecdsa,rsaandmgf1(=rsapss)
        var state = null;
        var pssSaltLen = -1;
        var initParams = null;

        var sHashHex = null; // hex hash value for hex
        var hDigestInfo = null;
        var hPaddedDigestInfo = null;
        var hSign = null;

        this._setAlgNames = function() {
        var matchResult = this.algName.match(/^(.+)with(.+)$/);
        if (matchResult) {
            this.mdAlgName = matchResult[1].toLowerCase();
            this.pubkeyAlgName = matchResult[2].toLowerCase();
        }
        };

        this._zeroPaddingOfSignature = function(hex, bitLength) {
        var s = "";
        var nZero = bitLength / 4 - hex.length;
        for (var i = 0; i < nZero; i++) {
            s = s + "0";
        }
        return s + hex;
        };

        this.setAlgAndProvider = function(alg, prov) {
        this._setAlgNames();
        if (prov != 'cryptojs/jsrsa')
            throw "provider not supported: " + prov;

        if (':md5:sha1:sha224:sha256:sha384:sha512:ripemd160:'.indexOf(this.mdAlgName) != -1) {
            try {
            this.md = new KJUR.crypto.MessageDigest({'alg':this.mdAlgName});
            } catch (ex) {
            throw "setAlgAndProvider hash alg set fail alg=" +
                        this.mdAlgName + "/" + ex;
            }
            
            this.init = function(keyparam, pass) {
            var keyObj = null;
            try {
                if (pass === undefined) {
                keyObj = KEYUTIL.getKey(keyparam);
                } else {
                keyObj = KEYUTIL.getKey(keyparam, pass);
                }
            } catch (ex) {
                throw "init failed:" + ex;
            }

            if (keyObj.isPrivate === true) {
                this.prvKey = keyObj;
                this.state = "SIGN";
            } else if (keyObj.isPublic === true) {
                this.pubKey = keyObj;
                this.state = "VERIFY";
            } else {
                throw "init failed.:" + keyObj;
            }
            };

            this.updateString = function(str) {
            this.md.updateString(str);
            };

            this.updateHex = function(hex) {
            this.md.updateHex(hex);
            };

            this.sign = function() {
            this.sHashHex = this.md.digest();
            if (typeof this.ecprvhex != "undefined" &&
                typeof this.eccurvename != "undefined") {
                var ec = new KJUR.crypto.ECDSA({'curve': this.eccurvename});
                this.hSign = ec.signHex(this.sHashHex, this.ecprvhex);
            } else if (this.prvKey instanceof RSAKey &&
                       this.pubkeyAlgName === "rsaandmgf1") {
                this.hSign = this.prvKey.signWithMessageHashPSS(this.sHashHex,
                                        this.mdAlgName,
                                        this.pssSaltLen);
            } else if (this.prvKey instanceof RSAKey &&
                   this.pubkeyAlgName === "rsa") {
                this.hSign = this.prvKey.signWithMessageHash(this.sHashHex,
                                     this.mdAlgName);
            } else if (this.prvKey instanceof KJUR.crypto.ECDSA) {
                this.hSign = this.prvKey.signWithMessageHash(this.sHashHex);
            } else if (this.prvKey instanceof KJUR.crypto.DSA) {
                this.hSign = this.prvKey.signWithMessageHash(this.sHashHex);
            } else {
                throw "Signature: unsupported private key alg: " + this.pubkeyAlgName;
            }
            return this.hSign;
            };
            this.signString = function(str) {
            this.updateString(str);
            return this.sign();
            };
            this.signHex = function(hex) {
            this.updateHex(hex);
            return this.sign();
            };
            this.verify = function(hSigVal) {
                this.sHashHex = this.md.digest();
            if (typeof this.ecpubhex != "undefined" &&
                typeof this.eccurvename != "undefined") {
                var ec = new KJUR.crypto.ECDSA({curve: this.eccurvename});
                return ec.verifyHex(this.sHashHex, hSigVal, this.ecpubhex);
            } else if (this.pubKey instanceof RSAKey &&
                   this.pubkeyAlgName === "rsaandmgf1") {
                return this.pubKey.verifyWithMessageHashPSS(this.sHashHex, hSigVal, 
                                    this.mdAlgName,
                                    this.pssSaltLen);
            } else if (this.pubKey instanceof RSAKey &&
                   this.pubkeyAlgName === "rsa") {
                return this.pubKey.verifyWithMessageHash(this.sHashHex, hSigVal);
            } else if (KJUR.crypto.ECDSA !== undefined &&
                   this.pubKey instanceof KJUR.crypto.ECDSA) {
                return this.pubKey.verifyWithMessageHash(this.sHashHex, hSigVal);
            } else if (KJUR.crypto.DSA !== undefined &&
                   this.pubKey instanceof KJUR.crypto.DSA) {
                return this.pubKey.verifyWithMessageHash(this.sHashHex, hSigVal);
            } else {
                throw "Signature: unsupported public key alg: " + this.pubkeyAlgName;
            }
            };
        }
        };

        this.init = function(key, pass) {
        throw "init(key, pass) not supported for this alg:prov=" +
              this.algProvName;
        };

        this.updateString = function(str) {
        throw "updateString(str) not supported for this alg:prov=" + this.algProvName;
        };

        this.updateHex = function(hex) {
        throw "updateHex(hex) not supported for this alg:prov=" + this.algProvName;
        };

        this.sign = function() {
        throw "sign() not supported for this alg:prov=" + this.algProvName;
        };

        this.signString = function(str) {
        throw "digestString(str) not supported for this alg:prov=" + this.algProvName;
        };

        this.signHex = function(hex) {
        throw "digestHex(hex) not supported for this alg:prov=" + this.algProvName;
        };

        this.verify = function(hSigVal) {
        throw "verify(hSigVal) not supported for this alg:prov=" + this.algProvName;
        };

        this.initParams = params;

        if (params !== undefined) {
        if (params.alg !== undefined) {
            this.algName = params.alg;
            if (params.prov === undefined) {
            this.provName = KJUR.crypto.Util.DEFAULTPROVIDER[this.algName];
            } else {
            this.provName = params.prov;
            }
            this.algProvName = this.algName + ":" + this.provName;
            this.setAlgAndProvider(this.algName, this.provName);
            this._setAlgNames();
        }

        if (params['psssaltlen'] !== undefined) this.pssSaltLen = params['psssaltlen'];

        if (params.prvkeypem !== undefined) {
            if (params.prvkeypas !== undefined) {
            throw "both prvkeypem and prvkeypas parameters not supported";
            } else {
            try {
                var prvKey = KEYUTIL.getKey(params.prvkeypem);
                this.init(prvKey);
            } catch (ex) {
                throw "fatal error to load pem private key: " + ex;
            }
            }
        }
        }
    };

    KJUR.crypto.Cipher = function(params) {
    };

    KJUR.crypto.Cipher.encrypt = function(s, keyObj, algName) {
        if (keyObj instanceof RSAKey && keyObj.isPublic) {
        var algName2 = KJUR.crypto.Cipher.getAlgByKeyAndName(keyObj, algName);
        if (algName2 === "RSA") return keyObj.encrypt(s);
        if (algName2 === "RSAOAEP") return keyObj.encryptOAEP(s, "sha1");

        var a = algName2.match(/^RSAOAEP(\d+)$/);
        if (a !== null) return keyObj.encryptOAEP(s, "sha" + a[1]);

        throw "Cipher.encrypt: unsupported algorithm for RSAKey: " + algName;
        } else {
        throw "Cipher.encrypt: unsupported key or algorithm";
        }
    };

    KJUR.crypto.Cipher.decrypt = function(hex, keyObj, algName) {
        if (keyObj instanceof RSAKey && keyObj.isPrivate) {
        var algName2 = KJUR.crypto.Cipher.getAlgByKeyAndName(keyObj, algName);
        if (algName2 === "RSA") return keyObj.decrypt(hex);
        if (algName2 === "RSAOAEP") return keyObj.decryptOAEP(hex, "sha1");

        var a = algName2.match(/^RSAOAEP(\d+)$/);
        if (a !== null) return keyObj.decryptOAEP(hex, "sha" + a[1]);

        throw "Cipher.decrypt: unsupported algorithm for RSAKey: " + algName;
        } else {
        throw "Cipher.decrypt: unsupported key or algorithm";
        }
    };

    KJUR.crypto.Cipher.getAlgByKeyAndName = function(keyObj, algName) {
        if (keyObj instanceof RSAKey) {
        if (":RSA:RSAOAEP:RSAOAEP224:RSAOAEP256:RSAOAEP384:RSAOAEP512:".indexOf(algName) != -1)
            return algName;
        if (algName === null || algName === undefined) return "RSA";
        throw "getAlgByKeyAndName: not supported algorithm name for RSAKey: " + algName;
        }
        throw "getAlgByKeyAndName: not supported algorithm name: " + algName;
    };

    KJUR.crypto.OID = new function() {
        this.oidhex2name = {
        '2a864886f70d010101': 'rsaEncryption',
        '2a8648ce3d0201': 'ecPublicKey',
        '2a8648ce380401': 'dsa',
        '2a8648ce3d030107': 'secp256r1',
        '2b8104001f': 'secp192k1',
        '2b81040021': 'secp224r1',
        '2b8104000a': 'secp256k1',
        '2b81040023': 'secp521r1',
        '2b81040022': 'secp384r1',
        '2a8648ce380403': 'SHA1withDSA', // 1.2.840.10040.4.3
        '608648016503040301': 'SHA224withDSA', // 2.16.840.1.101.3.4.3.1
        '608648016503040302': 'SHA256withDSA', // 2.16.840.1.101.3.4.3.2
        };
    };


    /*

    --------------------------------------------------rsa-------------------------------------------------------
    */

    function parseBigInt(str,r) {
      return new BigInteger(str,r);
    }

    function linebrk(s,n) {
      var ret = "";
      var i = 0;
      while(i + n < s.length) {
        ret += s.substring(i,i+n) + "\n";
        i += n;
      }
      return ret + s.substring(i,s.length);
    }

    function byte2Hex(b) {
      if(b < 0x10)
        return "0" + b.toString(16);
      else
        return b.toString(16);
    }

    // PKCS#1 (type 2, random) pad input string s to n bytes, and return a bigint
    function pkcs1pad2(s,n) {
      if(n < s.length + 11) { // TODO: fix for utf-8
        throw "Message too long for RSA";
        return null;
      }
      var ba = new Array();
      var i = s.length - 1;
      while(i >= 0 && n > 0) {
        var c = s.charCodeAt(i--);
        if(c < 128) { // encode using utf-8
          ba[--n] = c;
        }
        else if((c > 127) && (c < 2048)) {
          ba[--n] = (c & 63) | 128;
          ba[--n] = (c >> 6) | 192;
        }
        else {
          ba[--n] = (c & 63) | 128;
          ba[--n] = ((c >> 6) & 63) | 128;
          ba[--n] = (c >> 12) | 224;
        }
      }
      ba[--n] = 0;
      var rng = new SecureRandom();
      var x = new Array();
      while(n > 2) { // random non-zero pad
        x[0] = 0;
        while(x[0] == 0) rng.nextBytes(x);
        ba[--n] = x[0];
      }
      ba[--n] = 2;
      ba[--n] = 0;
      return new BigInteger(ba);
    }

    // PKCS#1 (OAEP) mask generation function
    function oaep_mgf1_arr(seed, len, hash)
    {
        var mask = '', i = 0;

        while (mask.length < len)
        {
            mask += hash(String.fromCharCode.apply(String, seed.concat([
                    (i & 0xff000000) >> 24,
                    (i & 0x00ff0000) >> 16,
                    (i & 0x0000ff00) >> 8,
                    i & 0x000000ff])));
            i += 1;
        }

        return mask;
    }

    function oaep_pad(s, n, hash, hashLen) {
        var MD = KJUR.crypto.MessageDigest;
        var Util = KJUR.crypto.Util;
        var algName = null;

        if (!hash) hash = "sha1";

        if (typeof hash === "string") {
            algName = MD.getCanonicalAlgName(hash);
            hashLen = MD.getHashLength(algName);
            hash = function(s) {
                return hextorstr(Util.hashHex(rstrtohex(s), algName));
            };
        }

        if (s.length + 2 * hashLen + 2 > n) {
            throw "Message too long for RSA";
        }

        var PS = '', i;

        for (i = 0; i < n - s.length - 2 * hashLen - 2; i += 1) {
            PS += '\x00';
        }

        var DB = hash('') + PS + '\x01' + s;
        var seed = new Array(hashLen);
        new SecureRandom().nextBytes(seed);
        
        var dbMask = oaep_mgf1_arr(seed, DB.length, hash);
        var maskedDB = [];

        for (i = 0; i < DB.length; i += 1) {
            maskedDB[i] = DB.charCodeAt(i) ^ dbMask.charCodeAt(i);
        }

        var seedMask = oaep_mgf1_arr(maskedDB, seed.length, hash);
        var maskedSeed = [0];

        for (i = 0; i < seed.length; i += 1) {
            maskedSeed[i + 1] = seed[i] ^ seedMask.charCodeAt(i);
        }

        return new BigInteger(maskedSeed.concat(maskedDB));
    }

    // "empty" RSA key constructor
    function RSAKey() {
      this.n = null;
      this.e = 0;
      this.d = null;
      this.p = null;
      this.q = null;
      this.dmp1 = null;
      this.dmq1 = null;
      this.coeff = null;
    }

    // Set the public key fields N and e from hex strings
    function RSASetPublic(N, E) {
        this.isPublic = true;
        this.isPrivate = false;
        if (typeof N !== "string") {
        this.n = N;
        this.e = E;
        } else if(N != null && E != null && N.length > 0 && E.length > 0) {
        this.n = parseBigInt(N,16);
        this.e = parseInt(E,16);
        } else {
        throw "Invalid RSA public key";
        }
    }

    // Perform raw public operation on "x": return x^e (mod n)
    function RSADoPublic(x) {
      return x.modPowInt(this.e, this.n);
    }

    // Return the PKCS#1 RSA encryption of "text" as an even-length hex string
    function RSAEncrypt(text) {
      var m = pkcs1pad2(text,(this.n.bitLength()+7)>>3);
      if(m == null) return null;
      var c = this.doPublic(m);
      if(c == null) return null;
      var h = c.toString(16);
      if((h.length & 1) == 0) return h; else return "0" + h;
    }

    // Return the PKCS#1 OAEP RSA encryption of "text" as an even-length hex string
    function RSAEncryptOAEP(text, hash, hashLen) {
      var m = oaep_pad(text, (this.n.bitLength() + 7) >> 3, hash, hashLen);
      if(m == null) return null;
      var c = this.doPublic(m);
      if(c == null) return null;
      var h = c.toString(16);
      if((h.length & 1) == 0) return h; else return "0" + h;
    }

    // protected
    RSAKey.prototype.doPublic = RSADoPublic;

    // public
    RSAKey.prototype.setPublic = RSASetPublic;
    RSAKey.prototype.encrypt = RSAEncrypt;
    RSAKey.prototype.encryptOAEP = RSAEncryptOAEP;
    //RSAKey.prototype.encrypt_b64 = RSAEncryptB64;

    RSAKey.prototype.type = "RSA";




    /*

    --------------------------------------------------rsapem-1.1-------------------------------------------------------
    */

    RSAKey.getPosArrayOfChildrenFromHex = function(hPrivateKey) {
        return ASN1HEX.getChildIdx(hPrivateKey, 0);
    };

    RSAKey.getHexValueArrayOfChildrenFromHex = function(hPrivateKey) {
        var _ASN1HEX = ASN1HEX;
        var _getV = _ASN1HEX.getV;
        var a = RSAKey.getPosArrayOfChildrenFromHex(hPrivateKey);
        var h_v =  _getV(hPrivateKey, a[0]);
        var h_n =  _getV(hPrivateKey, a[1]);
        var h_e =  _getV(hPrivateKey, a[2]);
        var h_d =  _getV(hPrivateKey, a[3]);
        var h_p =  _getV(hPrivateKey, a[4]);
        var h_q =  _getV(hPrivateKey, a[5]);
        var h_dp = _getV(hPrivateKey, a[6]);
        var h_dq = _getV(hPrivateKey, a[7]);
        var h_co = _getV(hPrivateKey, a[8]);
        var a = new Array();
        a.push(h_v, h_n, h_e, h_d, h_p, h_q, h_dp, h_dq, h_co);
        return a;
    };

    RSAKey.prototype.readPrivateKeyFromPEMString = function(keyPEM) {
        var keyHex = pemtohex(keyPEM);
        var a = RSAKey.getHexValueArrayOfChildrenFromHex(keyHex);
        this.setPrivateEx(a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8]);
    };

    RSAKey.prototype.readPKCS5PrvKeyHex = function(h) {
        var a = RSAKey.getHexValueArrayOfChildrenFromHex(h);
        this.setPrivateEx(a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8]);
    };

    RSAKey.prototype.readPKCS8PrvKeyHex = function(h) {
        var hN, hE, hD, hP, hQ, hDP, hDQ, hCO;
        var _ASN1HEX = ASN1HEX;
        var _getVbyList = _ASN1HEX.getVbyList;

        if (_ASN1HEX.isASN1HEX(h) === false)
        throw "not ASN.1 hex string";

        try {
        hN  = _getVbyList(h, 0, [2, 0, 1], "02");
        hE  = _getVbyList(h, 0, [2, 0, 2], "02");
        hD  = _getVbyList(h, 0, [2, 0, 3], "02");
        hP  = _getVbyList(h, 0, [2, 0, 4], "02");
        hQ  = _getVbyList(h, 0, [2, 0, 5], "02");
        hDP = _getVbyList(h, 0, [2, 0, 6], "02");
        hDQ = _getVbyList(h, 0, [2, 0, 7], "02");
        hCO = _getVbyList(h, 0, [2, 0, 8], "02");
        } catch(ex) {
        throw "malformed PKCS#8 plain RSA private key";
        }

        this.setPrivateEx(hN, hE, hD, hP, hQ, hDP, hDQ, hCO);
    };

    RSAKey.prototype.readPKCS5PubKeyHex = function(h) {
        var _ASN1HEX = ASN1HEX;
        var _getV = _ASN1HEX.getV;

        if (_ASN1HEX.isASN1HEX(h) === false)
        throw "keyHex is not ASN.1 hex string";
        var aIdx = _ASN1HEX.getChildIdx(h, 0);
        if (aIdx.length !== 2 ||
        h.substr(aIdx[0], 2) !== "02" ||
        h.substr(aIdx[1], 2) !== "02")
        throw "wrong hex for PKCS#5 public key";
        var hN = _getV(h, aIdx[0]);
        var hE = _getV(h, aIdx[1]);
        this.setPublic(hN, hE);
    };

    RSAKey.prototype.readPKCS8PubKeyHex = function(h) {
        var _ASN1HEX = ASN1HEX;
        if (_ASN1HEX.isASN1HEX(h) === false)
        throw "not ASN.1 hex string";

        // 06092a864886f70d010101: OBJECT IDENTIFIER rsaEncryption (1 2 840 113549 1 1 1)
        if (_ASN1HEX.getTLVbyList(h, 0, [0, 0]) !== "06092a864886f70d010101")
        throw "not PKCS8 RSA public key";

        var p5hex = _ASN1HEX.getTLVbyList(h, 0, [1, 0]);
        this.readPKCS5PubKeyHex(p5hex);
    };

    RSAKey.prototype.readCertPubKeyHex = function(h, nthPKI) {
        var x, hPub;
        x = new X509();
        x.readCertHex(h);
        hPub = x.getPublicKeyHex();
        this.readPKCS8PubKeyHex(hPub);
    };




    /*

    ---------------------------------------------rsasign-1.2------------------------------------------------------------
    */

    var _RE_HEXDECONLY = new RegExp("");
    _RE_HEXDECONLY.compile("[^0-9a-f]", "gi");

    function _rsasign_getHexPaddedDigestInfoForString(s, keySize, hashAlg) {
        var hashFunc = function(s) { return KJUR.crypto.Util.hashString(s, hashAlg); };
        var sHashHex = hashFunc(s);

        return KJUR.crypto.Util.getPaddedDigestInfoHex(sHashHex, hashAlg, keySize);
    }

    function _zeroPaddingOfSignature(hex, bitLength) {
        var s = "";
        var nZero = bitLength / 4 - hex.length;
        for (var i = 0; i < nZero; i++) {
      s = s + "0";
        }
        return s + hex;
    }

    RSAKey.prototype.sign = function(s, hashAlg) {
        var hashFunc = function(s) { return KJUR.crypto.Util.hashString(s, hashAlg); };
        var sHashHex = hashFunc(s);

        return this.signWithMessageHash(sHashHex, hashAlg);
    };

    RSAKey.prototype.signWithMessageHash = function(sHashHex, hashAlg) {
        var hPM = KJUR.crypto.Util.getPaddedDigestInfoHex(sHashHex, hashAlg, this.n.bitLength());
        var biPaddedMessage = parseBigInt(hPM, 16);
        var biSign = this.doPrivate(biPaddedMessage);
        var hexSign = biSign.toString(16);
        return _zeroPaddingOfSignature(hexSign, this.n.bitLength());
    };

    // PKCS#1 (PSS) mask generation function
    function pss_mgf1_str(seed, len, hash) {
        var mask = '', i = 0;

        while (mask.length < len) {
            mask += hextorstr(hash(rstrtohex(seed + String.fromCharCode.apply(String, [
                    (i & 0xff000000) >> 24,
                    (i & 0x00ff0000) >> 16,
                    (i & 0x0000ff00) >> 8,
                    i & 0x000000ff]))));
            i += 1;
        }

        return mask;
    }

    RSAKey.prototype.signPSS = function(s, hashAlg, sLen) {
        var hashFunc = function(sHex) { return KJUR.crypto.Util.hashHex(sHex, hashAlg); }; 
        var hHash = hashFunc(rstrtohex(s));

        if (sLen === undefined) sLen = -1;
        return this.signWithMessageHashPSS(hHash, hashAlg, sLen);
    };

    RSAKey.prototype.signWithMessageHashPSS = function(hHash, hashAlg, sLen) {
        var mHash = hextorstr(hHash);
        var hLen = mHash.length;
        var emBits = this.n.bitLength() - 1;
        var emLen = Math.ceil(emBits / 8);
        var i;
        var hashFunc = function(sHex) { return KJUR.crypto.Util.hashHex(sHex, hashAlg); }; 

        if (sLen === -1 || sLen === undefined) {
            sLen = hLen; // same as hash length
        } else if (sLen === -2) {
            sLen = emLen - hLen - 2; // maximum
        } else if (sLen < -2) {
            throw "invalid salt length";
        }

        if (emLen < (hLen + sLen + 2)) {
            throw "data too long";
        }

        var salt = '';

        if (sLen > 0) {
            salt = new Array(sLen);
            new SecureRandom().nextBytes(salt);
            salt = String.fromCharCode.apply(String, salt);
        }

        var H = hextorstr(hashFunc(rstrtohex('\x00\x00\x00\x00\x00\x00\x00\x00' + mHash + salt)));
        var PS = [];

        for (i = 0; i < emLen - sLen - hLen - 2; i += 1) {
            PS[i] = 0x00;
        }

        var DB = String.fromCharCode.apply(String, PS) + '\x01' + salt;
        var dbMask = pss_mgf1_str(H, DB.length, hashFunc);
        var maskedDB = [];

        for (i = 0; i < DB.length; i += 1) {
            maskedDB[i] = DB.charCodeAt(i) ^ dbMask.charCodeAt(i);
        }

        var mask = (0xff00 >> (8 * emLen - emBits)) & 0xff;
        maskedDB[0] &= ~mask;

        for (i = 0; i < hLen; i++) {
            maskedDB.push(H.charCodeAt(i));
        }

        maskedDB.push(0xbc);

        return _zeroPaddingOfSignature(this.doPrivate(new BigInteger(maskedDB)).toString(16),
               this.n.bitLength());
    };

    function _rsasign_getDecryptSignatureBI(biSig, hN, hE) {
        var rsa = new RSAKey();
        rsa.setPublic(hN, hE);
        var biDecryptedSig = rsa.doPublic(biSig);
        return biDecryptedSig;
    }

    function _rsasign_getHexDigestInfoFromSig(biSig, hN, hE) {
        var biDecryptedSig = _rsasign_getDecryptSignatureBI(biSig, hN, hE);
        var hDigestInfo = biDecryptedSig.toString(16).replace(/^1f+00/, '');
        return hDigestInfo;
    }

    function _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo) {
        for (var algName in KJUR.crypto.Util.DIGESTINFOHEAD) {
      var head = KJUR.crypto.Util.DIGESTINFOHEAD[algName];
      var len = head.length;
      if (hDigestInfo.substring(0, len) == head) {
          var a = [algName, hDigestInfo.substring(len)];
          return a;
      }
        }
        return [];
    }

    RSAKey.prototype.verify = function(sMsg, hSig) {
        hSig = hSig.replace(_RE_HEXDECONLY, '');
        hSig = hSig.replace(/[ \n]+/g, "");
        var biSig = parseBigInt(hSig, 16);
        if (biSig.bitLength() > this.n.bitLength()) return 0;
        var biDecryptedSig = this.doPublic(biSig);
        var hDigestInfo = biDecryptedSig.toString(16).replace(/^1f+00/, '');
        var digestInfoAry = _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo);
      
        if (digestInfoAry.length == 0) return false;
        var algName = digestInfoAry[0];
        var diHashValue = digestInfoAry[1];
        var ff = function(s) { return KJUR.crypto.Util.hashString(s, algName); };
        var msgHashValue = ff(sMsg);
        return (diHashValue == msgHashValue);
    };

    RSAKey.prototype.verifyWithMessageHash = function(sHashHex, hSig) {
        hSig = hSig.replace(_RE_HEXDECONLY, '');
        hSig = hSig.replace(/[ \n]+/g, "");
        var biSig = parseBigInt(hSig, 16);
        if (biSig.bitLength() > this.n.bitLength()) return 0;
        var biDecryptedSig = this.doPublic(biSig);
        var hDigestInfo = biDecryptedSig.toString(16).replace(/^1f+00/, '');
        var digestInfoAry = _rsasign_getAlgNameAndHashFromHexDisgestInfo(hDigestInfo);
      
        if (digestInfoAry.length == 0) return false;
        var algName = digestInfoAry[0];
        var diHashValue = digestInfoAry[1];
        return (diHashValue == sHashHex);
    };

    RSAKey.prototype.verifyPSS = function(sMsg, hSig, hashAlg, sLen) {
        var hashFunc = function(sHex) { return KJUR.crypto.Util.hashHex(sHex, hashAlg); };
        var hHash = hashFunc(rstrtohex(sMsg));

        if (sLen === undefined) sLen = -1;
        return this.verifyWithMessageHashPSS(hHash, hSig, hashAlg, sLen);
    };

    RSAKey.prototype.verifyWithMessageHashPSS = function(hHash, hSig, hashAlg, sLen) {
        var biSig = new BigInteger(hSig, 16);

        if (biSig.bitLength() > this.n.bitLength()) {
            return false;
        }

        var hashFunc = function(sHex) { return KJUR.crypto.Util.hashHex(sHex, hashAlg); };
        var mHash = hextorstr(hHash);
        var hLen = mHash.length;
        var emBits = this.n.bitLength() - 1;
        var emLen = Math.ceil(emBits / 8);
        var i;

        if (sLen === -1 || sLen === undefined) {
            sLen = hLen; // same as hash length
        } else if (sLen === -2) {
            sLen = emLen - hLen - 2; // recover
        } else if (sLen < -2) {
            throw "invalid salt length";
        }

        if (emLen < (hLen + sLen + 2)) {
            throw "data too long";
        }

        var em = this.doPublic(biSig).toByteArray();

        for (i = 0; i < em.length; i += 1) {
            em[i] &= 0xff;
        }

        while (em.length < emLen) {
            em.unshift(0);
        }

        if (em[emLen -1] !== 0xbc) {
            throw "encoded message does not end in 0xbc";
        }

        em = String.fromCharCode.apply(String, em);

        var maskedDB = em.substr(0, emLen - hLen - 1);
        var H = em.substr(maskedDB.length, hLen);

        var mask = (0xff00 >> (8 * emLen - emBits)) & 0xff;

        if ((maskedDB.charCodeAt(0) & mask) !== 0) {
            throw "bits beyond keysize not zero";
        }

        var dbMask = pss_mgf1_str(H, maskedDB.length, hashFunc);
        var DB = [];

        for (i = 0; i < maskedDB.length; i += 1) {
            DB[i] = maskedDB.charCodeAt(i) ^ dbMask.charCodeAt(i);
        }

        DB[0] &= ~mask;

        var checkLen = emLen - hLen - sLen - 2;

        for (i = 0; i < checkLen; i += 1) {
            if (DB[i] !== 0x00) {
                throw "leftmost octets not zero";
            }
        }

        if (DB[checkLen] !== 0x01) {
            throw "0x01 marker not found";
        }

        return H === hextorstr(hashFunc(rstrtohex('\x00\x00\x00\x00\x00\x00\x00\x00' + mHash +
                 String.fromCharCode.apply(String, DB.slice(-sLen)))));
    };

    RSAKey.SALT_LEN_HLEN = -1;
    RSAKey.SALT_LEN_MAX = -2;
    RSAKey.SALT_LEN_RECOVER = -2;

    class ULAdvBase extends ULModuleBase {
        constructor() {
            super();
            this._initState = false;
            this.onInitModule();
        }
        get initState() {
            return this._initState;
        }
        set initState(v) {
            this._initState = v;
        }
    }

    let qg$1 = window["qg"];
    class ULAdvOppoQg extends ULAdvBase {
        constructor() {
            super();
            this.className = "ULAdvOppoQg";
        }
        onInitModule() {
            qg$1.getSystemInfoSync().platformVersion;
            let platformVersionCode = qg$1.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode >= 1051) {
                this.initState = true;
                this.notifyInitState(this.initState);
            }
            else {
                this.initAdv();
            }
        }
        notifyInitState(initState) {
            let templateItemObjectArray = ULSdkManager.getInstance().advManager.getAdvObjectsByName("ULAdvOppoQg");
            if (!templateItemObjectArray) {
                return;
            }
            for (const baseObj of templateItemObjectArray) {
                baseObj.receiveMainClassInitState(initState);
            }
        }
        initAdv() {
            let config = ULConfig.getConfig();
            let appId = config.s_sdk_oppoqg_appid;
            qg$1.initAdService({
                appId: appId,
                isDebug: false,
                success: (res) => {
                    ULLog.console.log("ULAdvOppoQg.init success");
                    this.initState = true;
                    this.notifyInitState(this.initState);
                },
                fail: (res) => {
                    console.warn("ULAdvOppoQg.init fail", res.code, res.msg);
                    this.initState = false;
                    this.notifyInitState(this.initState);
                },
                complete: (res) => {
                    ULLog.console.log("ULAdvOppoQg.init complete");
                }
            });
        }
    }
    ULAdvOppoQg.NORMAL_ADVERTISER = "ULAdvOppoQg";
    ULAdvOppoQg.NATIVE_ADVERTISER = "ULAdvOppoQgNative";

    class ULChannelModuleBase extends ULModuleBase {
        constructor() {
            super();
            ULLog.console.log("ULChannelModuleBase-constructor");
        }
        init() {
            super.init();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_GET_STORAGE, ULConst.PRIORITY_NONE, this.onCmdSdkGetStorage.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_SET_STORAGE, ULConst.PRIORITY_NONE, this.onCmdSdkSetStorage.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_GET_CLIPBOARD_DATA, ULConst.PRIORITY_NONE, this.onCmdSdkGetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_SET_CLIPBOARD_DATA, ULConst.PRIORITY_NONE, this.onCmdSdkSetClipboardData.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_IS_SUPPORT_CLIPBOARD, ULConst.PRIORITY_NONE, this.onCmdSdkIsSupportClipboard.bind(this));
            this.genSdkUserId();
            ULSdkManager.getInstance().channelInfo._sdkUserId = this.sdkUserId;
            ULSdkManager.getInstance().channelInfo.isNewUser = this.isNewUser;
            ULLog.console.log("ULChannelModuleBase.init isNewUser:", this.isNewUser);
        }
        genSdkUserId() {
            let config = ULConfig.getConfig();
            let key = ULTools.format("mUserId_%s", config.s_sdk_megadata_game_id);
            this.isNewUser = false;
            this.sdkUserId = ULStorageManager.getInstance().getStorage(key);
            if (!this.sdkUserId) {
                this.sdkUserId = ULTools.format("%s_%s_%s", config.s_sdk_cop_game_id, ULTools.createRandomUserId(), config.s_sdk_cop_channel_id);
                ULStorageManager.getInstance().setStorage(key, this.sdkUserId);
                this.isNewUser = true;
            }
        }
        onCmdSdkGetStorage(e) {
            let data = e.data;
            let key = data.key;
            e.setReturnValue(this._hook_getStorage(key));
        }
        onCmdSdkSetStorage(e) {
            let key = e.data.key;
            let data = e.data.data;
            this._hook_setStorage(key, data);
            e.stopImmediatePropagation();
        }
        onCmdSdkGetClipboardData(e) {
            let data = e.data;
            let finishCallback = data.finishCallback;
            this._hook_getClipboardData(finishCallback);
            e.stopImmediatePropagation();
        }
        onCmdSdkSetClipboardData(e) {
            let clipboardData = e.data.data;
            let finishCallback = e.data.finishCallback;
            this._hook_setClipboardData(clipboardData, finishCallback);
            e.stopImmediatePropagation();
        }
        onCmdSdkIsSupportClipboard(e) {
            let data = e.data;
            e.setReturnValue(this._hook_isSupportClipboard());
            e.stopImmediatePropagation();
        }
    }

    class ULAdvObjectBase extends ULModuleBase {
        constructor(arg, advType, advKey) {
            super();
            this._preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
            this.onLoadFailErr = { code: "", msg: "" };
            this._statisticsAdvertiser = "";
            this._statisticsType = "";
            this.advKey_2_lastRequestTime = {};
            this._supportLoadType = [];
            this._loadType = undefined;
            this.isReportLoading = false;
            this.isDispose = false;
            this._arg = arg;
            this._advType = advType;
            this._advKey = advKey;
        }
        onDisposeModule() {
            super.onDisposeModule();
            this.isDispose = true;
            ULLog.console.log("ULAdvObjectBase-onDisposeModule arg:", this.arg);
        }
        get arg() {
            return this._arg;
        }
        get advKey() {
            return this._advKey;
        }
        get preLoadState() {
            return this._preLoadState;
        }
        set preLoadState(preLoadState) {
            if (this._preLoadState == preLoadState)
                return;
            this._preLoadState = preLoadState;
            ULSdkManager.getInstance().advManager.onAdvObjectPreloadStateChanged(this.advKey);
        }
        get advType() {
            return this._advType;
        }
        get isOpened() {
            return this._isOpened;
        }
        set isOpened(opened) {
            this._isOpened = opened;
        }
        get showData() {
            return this._mShowData;
        }
        set showData(mShowData) {
            this._mShowData = mShowData;
        }
        getMainClassNameString() {
            return this.getMainClassName();
        }
        receiveMainClassInitState(initState) {
            this.receiveInitState(initState);
        }
        preLoadAdv() {
            this.onLoadFailErr.code = "";
            this.onLoadFailErr.msg = "";
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            let rcd = ULSdkManager.getInstance().advManager.getRcdByAdvKey(this.advKey);
            if (rcd) {
                let lastRequestTime = this.advKey_2_lastRequestTime[this.advKey];
                let now = (new Date()).valueOf();
                if (lastRequestTime) {
                    if ((now - lastRequestTime) < rcd) {
                        console.warn(`${this.className}-preLoadAdv:模块[ + ${this.advKey} + ]in cd`);
                        this.preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
                        this.reLoadAdv();
                        return;
                    }
                    else {
                        this.advKey_2_lastRequestTime[this.advKey] = now;
                    }
                }
                else {
                    this.advKey_2_lastRequestTime[this.advKey] = now;
                }
            }
            this.loadAdv();
        }
        reLoadAdv() {
            ULTimer.callLater(ULSdkManager.getInstance().advManager.getAdvReloadTime() / 1000, () => {
                if (!this.isDispose) {
                    this.preLoadAdv();
                }
            });
        }
        advSkip(data, info) {
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleSkip(this.advKey, info, data);
        }
        get statisticsAdvertiser() {
            return this._statisticsAdvertiser;
        }
        set statisticsAdvertiser(statisticsAdvertiser) {
            this._statisticsAdvertiser = statisticsAdvertiser;
        }
        get statisticsType() {
            return this._statisticsType;
        }
        set statisticsType(statisticsType) {
            this._statisticsType = statisticsType;
        }
        set setSupportLoadType(types) {
            this._supportLoadType = types;
        }
        get getSupportLoadType() {
            return this._supportLoadType;
        }
        set setLoadType(type) {
            if (type == undefined) {
                return;
            }
            this._loadType = type;
        }
        get getLoadType() {
            return this._loadType;
        }
    }

    class ULAdvNativeObjectBase extends ULAdvObjectBase {
        constructor(arg, advType, templateItemName) {
            super(arg, advType, templateItemName);
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_CLICK_NATIVE_ADV, ULConst.PRIORITY_NONE, this.clickNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_CLOSE_NATIVE_ADV, ULConst.PRIORITY_NONE, this.closeNativeAdv.bind(this));
        }
        get nativeShowState() {
            return this._nativeShowState;
        }
        set nativeShowState(nativeShowState) {
            this._nativeShowState = nativeShowState;
        }
        get nativeData() {
            return this._nativeData;
        }
        set nativeData(nativeData) {
            this._nativeData = nativeData;
        }
    }

    const EvalSYMBOL = {
        ",": { order: -2, argCount: 1, handler: (args) => { return args[0]; } },
        "*": { order: 3, argCount: 2, handler: (args) => { return args[0] * args[1]; } },
        "/": { order: 3, argCount: 2, handler: (args) => { return args[0] / args[1]; } },
        "+": { order: 2, argCount: 2, handler: (args) => { return args[0] + args[1]; } },
        "-": {
            order: 2, argCount: 2, handler: (args) => {
                if (args.length == 1)
                    return 0 - args[0];
                return args[0] - args[1];
            }
        },
        ">=": { order: 1, argCount: 2, handler: (args) => { return args[0] >= args[1]; } },
        ">": { order: 1, argCount: 2, handler: (args) => { return args[0] > args[1]; } },
        "<=": { order: 1, argCount: 2, handler: (args) => { return args[0] <= args[1]; } },
        "<": { order: 1, argCount: 2, handler: (args) => { return args[0] < args[1]; } },
        "==": { order: 0, argCount: 2, handler: (args) => { return args[0] == args[1]; } },
        "!=": { order: 0, argCount: 2, handler: (args) => { return args[0] != args[1]; } },
        "&&": { order: -1, argCount: 2, handler: (args) => { return args[0] && args[1]; } },
        "||": { order: -1, argCount: 2, handler: (args) => { return args[0] || args[1]; } },
        "[": { order: 4, argChar: "]", handler: (args) => { let a = args[0]; let b = args[1]; return a[b]; } },
        "(": {
            order: 4, argChar: ')', handler: (args) => {
                let a = args[0];
                if (Object.prototype.toString.call(a) === "[object Function]") {
                    args.shift();
                    return a(...args);
                }
                else {
                    return a;
                }
            }
        },
        ".": {
            order: 5, argCount: 2, handler: (args) => {
                if (typeof (args[1]) == "number") {
                    return Number(`${args[0]}.${args[1]}`);
                }
                else {
                    let item = args[0][args[1]];
                    if (Object.prototype.toString.call(item) === "[object Function]") {
                        return item.bind(args[0]);
                    }
                    else {
                        return item;
                    }
                }
            }
        },
        "\"\"": { order: 6, argCount: 1, handler: (args) => { return args[0].toString(); } },
        "\'\'": { order: 6, argCount: 1, handler: (args) => { return args[0].toString(); } },
        "undefined": { order: 5, argCount: 0, handler: (args) => { return undefined; } },
        "window": { order: 5, argCount: 0, handler: (args) => { return window; } },
        "ULConfig": { order: 5, argCount: 0, handler: (args) => { return ULConfig; } },
        "ULTools": { order: 5, argCount: 0, handler: (args) => { return ULTools; } },
        "true": { order: 5, argCount: 0, handler: (args) => { return true; } },
        "false": { order: 5, argCount: 0, handler: (args) => { return false; } },
    };
    let EvalSYMBOL_keys = Object.keys(EvalSYMBOL);
    let EvalSYMBOLKeysDic = {};
    EvalSYMBOL_keys.forEach((value) => {
        EvalSYMBOLKeysDic[value.length] = true;
    });
    let EvalSYMBOLKeys = Object.keys(EvalSYMBOLKeysDic).map(a => {
        return Number(a);
    }).sort((a, b) => {
        return b - a;
    });
    class ULEvalExp {
        static trimCalcExp(exp) {
            exp = exp.replace(/\s/g, "");
            let expArray = exp.split("");
            var expSignCache = [];
            var expSignSetting = {
                ")": {
                    cut: [")", "\'", "\""],
                    end: "(",
                    symbol: "(",
                    handle: (str) => {
                        let expCache = this.trimCalcExp(str);
                        expCache.push("\")\"");
                        return expCache;
                    }
                },
                "]": {
                    cut: [")", "\'", "\""],
                    end: "[",
                    symbol: "[",
                    handle: (str) => {
                        let expCache = this.trimCalcExp(str);
                        expCache.push("\"]\"");
                        return expCache;
                    }
                },
                "\"": {
                    cut: [],
                    end: "\"",
                    handle: (str) => {
                        return [`"${str}"`];
                    }
                },
                "\'": {
                    cut: [],
                    end: "\'",
                    handle: (str) => {
                        return [`'${str}'`];
                    }
                }
            };
            let value = "";
            let expCache = [];
            let symbolCache = [];
            let expCacheString = "";
            while (expArray.length) {
                let char = expArray.pop();
                let lastExpChar = expSignCache.length ? expSignCache[expSignCache.length - 1] : null;
                if (lastExpChar) {
                    let cut = expSignSetting[lastExpChar].cut;
                    let end = expSignSetting[lastExpChar].end;
                    let symbol = expSignSetting[lastExpChar].symbol;
                    let handle = expSignSetting[lastExpChar].handle;
                    if (char == end) {
                        expSignCache.pop();
                        if (expSignCache.length == 0) {
                            expCache = expCache.concat(handle(expCacheString).reverse());
                            symbol && symbolCache.push(symbol);
                            expCacheString = "";
                            continue;
                        }
                    }
                    else if (cut.indexOf(char) >= 0) {
                        expSignCache.push(char);
                    }
                    expCacheString = char + expCacheString;
                }
                else {
                    if (expSignSetting[char]) {
                        if (value.length) {
                            expCache.push(value);
                            value = "";
                        }
                        expSignCache.push(char);
                        continue;
                    }
                    let symbol = null;
                    for (let i = 0; i < EvalSYMBOLKeys.length; i++) {
                        let length = EvalSYMBOLKeys[i] - 1;
                        if (expArray.length > length) {
                            let key = expArray.slice(expArray.length - length, expArray.length) + char;
                            if (EvalSYMBOL[key]) {
                                char = key;
                                symbol = EvalSYMBOL[key];
                                expArray = expArray.slice(0, expArray.length - length);
                                break;
                            }
                        }
                    }
                    if (symbol) {
                        if (value.length) {
                            expCache.push(value);
                            value = "";
                        }
                        if (symbolCache.length) {
                            for (let i = symbolCache.length - 1; i >= 0; i--) {
                                let lastKey = symbolCache.pop();
                                let lastSymbol = EvalSYMBOL[lastKey];
                                if (lastSymbol && lastSymbol.order > symbol.order) {
                                    expCache.push(lastKey);
                                }
                                else {
                                    symbolCache.push(lastKey);
                                    break;
                                }
                            }
                        }
                        symbolCache.push(char);
                        continue;
                    }
                    value = char + value;
                }
            }
            if (value.length) {
                expCache.push(value);
                value = "";
            }
            expCache = expCache.filter((element, index, array) => {
                return (element != "");
            });
            expCache = expCache.concat(symbolCache.reverse()).reverse();
            return expCache;
        }
        static getCalcExpArray(exp, getObjCallback = null) {
            exp = exp.split(".").join(".^");
            let expCache = this.trimCalcExp(exp);
            let trimExpCache = expCache.map((item, index, arr) => {
                if (EvalSYMBOL[item])
                    return item;
                let char = item.charAt(0);
                if (char == '"' || char == "'") {
                    let trimItem = item.substring(1, item.length - 1);
                    return trimItem.split(".^").join(".");
                }
                else if (char == '^') {
                    let trimItem = item.substring(1, item.length);
                    char = trimItem.charAt(0);
                    if (char <= '9' && char >= '0') {
                        return Number(trimItem);
                    }
                    return trimItem;
                }
                else if (!isNaN(Number(item))) {
                    return Number(item);
                }
                else {
                    let value = getObjCallback ? getObjCallback(item) : undefined;
                    if (!value)
                        ULLog.console.warn(`ULEvalExp item:${item} value:${value}`);
                    return value;
                }
            });
            return trimExpCache;
        }
        static evalExpResults(exp, getObjCallback = null) {
            var result = true;
            try {
                let expArray = this.getCalcExpArray(exp, getObjCallback);
                ULLog.console.log(expArray);
                result = this.evalExpArrayResults(expArray);
                ULLog.console.log("ULEvalExp result:", result);
            }
            catch (error) {
                ULLog.console.log("ULEvalExp exp规则错误:", error.stack);
                result = false;
            }
            return result;
        }
        static evalExpArrayResults(expArray) {
            if (expArray.length == 0)
                return true;
            let argCountDefalutHandler = (resultArray, argChar, argCount) => {
                let args = [];
                while (resultArray.length > 0) {
                    if (argChar) {
                        let arg = resultArray.pop();
                        if (arg == argChar)
                            break;
                        args.push(arg);
                    }
                    else {
                        if (argCount-- <= 0)
                            break;
                        args.push(resultArray.pop());
                    }
                }
                return args;
            };
            let resultArray = [];
            while (expArray.length) {
                let key = expArray.pop();
                if (EvalSYMBOL_keys.indexOf(key) > -1) {
                    let value = EvalSYMBOL[key];
                    let argChar = value.argChar;
                    let argCount = value.argCount;
                    let args = argCountDefalutHandler(resultArray, argChar, argCount);
                    let result = value.handler(args);
                    resultArray.push(result);
                }
                else {
                    resultArray.push(key);
                }
            }
            return resultArray[0];
        }
    }

    class ULAdvExpManager {
        constructor() {
            this.availableExpKeyArray = [];
            this.updateValue = 10;
        }
        static getInstance() {
            if (this.instance == null) {
                this.instance = new ULAdvExpManager();
                this.instance.addListern();
            }
            return this.instance;
        }
        get expValueCache() {
            if (!this._expValueCache) {
                let recordExpKey = this._getRecordKey();
                let recordStr = ULStorageManager.getInstance().getStorage(recordExpKey) || "{}";
                let record;
                try {
                    record = JSON.parse(recordStr);
                }
                catch (error) {
                    record = {};
                }
                for (const key in record) {
                    let timeString = this.getKeyTimeString(key);
                    let expValueItem = record[key];
                    if (timeString != expValueItem.exp_time) {
                        delete record[key];
                    }
                }
                this._expValueCache = record;
            }
            return this._expValueCache;
        }
        addListern() {
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
        }
        onCmdSdkOnGamePause(e) {
            this.saveStoreValue();
        }
        static updateExpKeys(expKeyArray) {
            ULAdvExpManager.getInstance().availableExpKeyArray = expKeyArray.slice(0);
        }
        static calcExp(exp) {
            return ULAdvExpManager.getInstance().calcExpResults(exp);
        }
        static updateExpValue(expKey) {
            ULAdvExpManager.getInstance().setStoreValue(expKey);
        }
        calcExpResults(exp) {
            if (!exp)
                return true;
            ULLog.console.log("ULAdvExpManager calcExp:", exp);
            let trimExp = exp.replace(/\s/g, "");
            trimExp = trimExp.split(".").join("^");
            return ULEvalExp.evalExpResults(trimExp, (key) => {
                let trimKey = key.split("^").join(".");
                return this.getCalcExpValue(trimKey);
            });
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULAdvExpManager_record_%d", config.s_sdk_megadata_game_id);
        }
        getCalcExpValue(anyObject) {
            if (typeof (anyObject) == "string" && this.availableExpKeyArray.indexOf(anyObject) != -1) {
                return this.getStoreValue(anyObject);
            }
            return anyObject;
        }
        getStoreValue(key) {
            let expValueItem = this.expValueCache[key];
            if (!expValueItem) {
                return 0;
            }
            let timeString = this.getKeyTimeString(key);
            if (timeString != expValueItem.exp_time) {
                expValueItem.exp_time = timeString;
                expValueItem.exp_value = 0;
            }
            return expValueItem.exp_value;
        }
        setStoreValue(key) {
            if (typeof (key) != "string" || this.availableExpKeyArray.indexOf(key) == -1) {
                return;
            }
            let timeString = this.getKeyTimeString(key);
            let expValueItem = this.expValueCache[key];
            if (!expValueItem) {
                expValueItem = {
                    exp_name: key,
                    exp_time: timeString,
                    exp_value: 1
                };
                this.expValueCache[key] = expValueItem;
            }
            else {
                if (timeString != expValueItem.exp_time) {
                    expValueItem.exp_time = timeString;
                    expValueItem.exp_value = 1;
                }
                else {
                    expValueItem.exp_value += 1;
                }
            }
            this.updateValue--;
            if (this.updateValue <= 0) {
                this.updateValue = 10;
                this.saveStoreValue();
            }
        }
        saveStoreValue() {
            let recordExpKey = this._getRecordKey();
            ULStorageManager.getInstance().setStorage(recordExpKey, JSON.stringify(this.expValueCache));
        }
        getKeyTimeString(key) {
            let timeString = ULTools.formatDate(new Date(), "yyyyMMdd");
            let keyFirstChar = key.substr(0, 1);
            switch (keyFirstChar) {
                case "d":
                    timeString = ULTools.formatDate(new Date(), "yyyyMMdd");
                    break;
                case "w":
                    let today = new Date();
                    let day = today.getDay() || 7;
                    let date = new Date(today.getFullYear(), today.getMonth(), today.getDate() + 1 - day);
                    timeString = ULTools.formatDate(date, "yyyyMMdd");
                    break;
                case "m":
                    timeString = ULTools.formatDate(new Date(), "yyyyMM");
                    break;
                case "y":
                    timeString = ULTools.formatDate(new Date(), "yyyy");
                    break;
            }
            return timeString;
        }
    }
    ULAdvExpManager.instance = null;

    class ULAdvSlot {
        constructor(advId, schemes, subAids, rcd) {
            this.advId = advId;
            this.schemes = schemes;
            this._subAids = subAids;
            this._rcd = rcd;
        }
        refreshValidAdvKeys() {
            let validSchemes = this.getValidSchemes();
            if (!validSchemes || validSchemes.length == 0) {
                return;
            }
            this.validAdvKeys = [];
            for (let i = 0, len = validSchemes.length; i < len; i++) {
                let scheme = validSchemes[i];
                let validTemplates = this.getValidTemplates(scheme);
                if (!validTemplates || validTemplates.length == 0) {
                    continue;
                }
                for (const template of validTemplates) {
                    let tid = template.templateId;
                    let keys = ULSdkManager.getInstance().advManager.getAdvKeysByTemplateId(tid);
                    if (!keys || keys.length == 0) {
                        continue;
                    }
                    for (const key of keys) {
                        if (this.validAdvKeys.indexOf(key) == -1) {
                            this.validAdvKeys.push(key);
                        }
                    }
                }
            }
        }
        set openingInfo(v) {
            this._openingInfo = v;
        }
        get openingInfo() {
            return this._openingInfo;
        }
        get preLoadState() {
            return this._preLoadState;
        }
        set preLoadState(v) {
            this._preLoadState = v;
            ULSdkManager.getInstance().advManager.onAdvSlotPreloadStateChanged(this.advId);
        }
        get rcd() {
            return this._rcd;
        }
        get subAids() {
            return this._subAids;
        }
        set showTid(t) {
            this._showTid = t;
        }
        get showTid() {
            return this._showTid;
        }
        openAdv(advRequestSerialNum, data) {
            let ulAdvInfo = {
                data: data,
                requestSerialNum: advRequestSerialNum
            };
            this.openingInfo = ulAdvInfo;
            let scheme = this.getShowScheme();
            if (!scheme) {
                console.warn("ULAdvSlot-openAdv:广告位[" + this.advId + "]未获取到有效策略");
                this.openingInfo = null;
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${this.advId}]未获取到有效策略` });
                return;
            }
            let validTemplates = this.getValidTemplates(scheme);
            if (!validTemplates || validTemplates.length == 0) {
                console.warn("ULAdvSlot-openAdv:广告位[" + this.advId + "]未获取到可用模板");
                this.openingInfo = null;
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${this.advId}]未获取到可用模板` });
                return;
            }
            ULLog.console.log("ULAdvSlot-openAdv:广告位[" + this.advId + "]当前展示策略：" + JSON.stringify(scheme));
            this.openingInfo.scheme = scheme;
            let validTemplateIdArray = [];
            let validTemplateWeightArray = [];
            for (let i = 0; i < validTemplates.length; i++) {
                let tid = validTemplates[i].templateId;
                let tidWeight = 0;
                let tidsArray = scheme.tids;
                let tidsWeightsArray = scheme.tidWeights;
                for (let j = 0; j < tidsArray.length; j++) {
                    if (tid == tidsArray[j].toString()) {
                        tidWeight = Number(tidsWeightsArray[j] || 0);
                        validTemplateIdArray.push(tid);
                        validTemplateWeightArray.push(tidWeight);
                        break;
                    }
                }
            }
            this.openingInfo.validTemplateIdArray = validTemplateIdArray;
            this.openingInfo.validTemplateWeightArray = validTemplateWeightArray;
            this.showNextAdv(data);
        }
        showNextAdv(data, info) {
            let validTemplateIdArray = this.openingInfo.validTemplateIdArray;
            let validTemplateWeightArray = this.openingInfo.validTemplateWeightArray;
            let index = ULTools.calcWheelTargetByArray(validTemplateWeightArray, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index == null) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]无有效模板展示");
                this.openingInfo = null;
                let mInfo = {
                    code: "",
                    msg: `广告位[${this.advId}]无有效模板展示`
                };
                ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info ? info : mInfo);
                return;
            }
            let templateId = validTemplateIdArray[index];
            this.openingInfo.tid = templateId;
            this.showTid = templateId;
            validTemplateIdArray.splice(index, 1);
            this.openingInfo.validTemplateIdArray = validTemplateIdArray;
            validTemplateWeightArray.splice(index, 1);
            this.openingInfo.validTemplateWeightArray = validTemplateWeightArray;
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(templateId);
            let type_ad_ecd = ULSdkManager.getInstance().advManager.getLaunchCdByType(advType);
            if (ULTools.time() - ULSdkManager.getInstance().advManager.sdkInitTime < type_ad_ecd / 1000) {
                ULLog.console.log(`ULAdvSlot-showNextAdv:广告${advType}处于启动请求cd中`);
                this.showNextAdv(data);
                return;
            }
            let advTypeCd = ULSdkManager.getInstance().advManager.getAdvTypeCd(advType);
            if (advTypeCd > 0) {
                let lastTriggerTime = (ULSdkManager.getInstance().advManager.getAdvTypeLastTriggerTimeLog())[advType] || 0;
                let triggerGap = ULTools.time() - lastTriggerTime;
                ULLog.console.log(ULTools.format("ULAdvSlot-showNextAdv:检查广告类型cd。上次播放间隔%d秒，cd%d秒", triggerGap, advTypeCd / 1000));
                if (triggerGap <= advTypeCd / 1000) {
                    ULLog.console.log(ULTools.format("ULAdvSlot-showNextAdv:广告类型[%s]cd中，请%d后再试", advType, (advTypeCd / 1000) - triggerGap));
                    this.showNextAdv(data);
                    return;
                }
            }
            let advTypeDailyLimit = ULSdkManager.getInstance().advManager.getAdvTypeDailyLimit(advType);
            if (advTypeDailyLimit > 0) {
                let dailyCount = (ULSdkManager.getInstance().advManager.getAdvTypeDailyCountLog())[advType] || 0;
                ULLog.console.log(ULTools.format("检查广告日限。今日已播放%d次，日限制%d次", dailyCount, advTypeDailyLimit));
                if (dailyCount >= advTypeDailyLimit) {
                    ULLog.console.log(ULTools.format("广告类型[%s]今日已播放%d次，限制%d次。无法播放。", advType, dailyCount, advTypeDailyLimit));
                    this.showNextAdv(data);
                    return;
                }
            }
            if (ULSdkManager.getInstance().advManager.isAdvTypeOpened(advType)) {
                console.warn("ULAdvSlot-showNextAdv:一个广告类型，同一时间只允许启动一个广告");
                this.showNextAdv(data);
                return;
            }
            let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(templateId);
            let rcd = ulAdvTemplate.rcd || 0;
            let lastRequestTime = ULAdvSlot.tid_lastRequestTime[templateId] || 0;
            let nowTime = (new Date()).valueOf();
            if ((nowTime - lastRequestTime) < rcd) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板【" + templateId + "】in rcd");
                this.showNextAdv(data);
                return;
            }
            else {
                ULAdvSlot.tid_lastRequestTime[templateId] = nowTime;
            }
            let advObject = this.calcValidObjectByTemplateId(templateId);
            if (advObject == null) {
                console.warn("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板【" + templateId + "】未获取到可用广告对象");
                this.showNextAdv(data);
                return;
            }
            if (advType == typeExp.video) {
                let tag = data.tag || "";
                if (ULSdkManager.getInstance().advManager.isFirstPlayVideo) {
                    ULSdkManager.getInstance().advManager.isFirstPlayVideo = false;
                    let firstOpenVideoTimeSec = ULTools.time() - ULSdkManager.getInstance().advManager.sdkInitTime;
                    firstOpenVideoTimeSec = Math.floor(firstOpenVideoTimeSec);
                    if (isNaN(firstOpenVideoTimeSec))
                        firstOpenVideoTimeSec = 0;
                    if (firstOpenVideoTimeSec < ULConfig.getConfig().t_sdk_miniplay_game_adv_point_first_click_event_report_time_limit) {
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_game_adv_point_first_click_event_id, tag, firstOpenVideoTimeSec.toString()]);
                    }
                }
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_game_click_video_event_id, tag]);
            }
            ULSdkManager.getInstance().advManager.updateAdvIds(advType, this.advId);
            let advKey = advObject.advKey;
            this.openingInfo.advTemplateItemName = advKey;
            ULLog.console.log("ULAdvSlot-showNextAdv:广告位[" + this.advId + "]当前展示模板：" + JSON.stringify(this.openingInfo));
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShowRequest(advKey, data);
            data["type"] = advType;
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(templateId);
            data["rewardType"] = rType;
            advObject.showAdv(data);
        }
        closeAdv(data) {
            let advKey = this.openingInfo.advTemplateItemName;
            let objectBase = ULSdkManager.getInstance().advManager.getAdvObjectByAdvKey(advKey);
            if (!objectBase) {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advobject未找到");
                return;
            }
            if (objectBase.isOpened) {
                objectBase.closeAdv(data);
            }
            else {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "广告未展示");
            }
        }
        getShowScheme() {
            let schemeList = this.getValidSchemes();
            if (!schemeList || schemeList.length == 0) {
                return null;
            }
            let validSchemes = [];
            for (const scheme of schemeList) {
                let validTemplates = this.getValidTemplates(scheme);
                if (validTemplates && validTemplates.length > 0) {
                    validSchemes.push(scheme);
                }
            }
            if (validSchemes.length == 0) {
                return null;
            }
            let weightArray = new Array(validSchemes.length);
            for (let i = 0; i < validSchemes.length; i++) {
                weightArray[i] = validSchemes[i].weight;
            }
            let index = ULTools.calcWheelTargetByArray(weightArray, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index != null) {
                return validSchemes[index];
            }
            return null;
        }
        getValidSchemes() {
            let validSchemes = [];
            for (let scheme of this.schemes) {
                if (!ULAdvExpManager.calcExp(scheme.exp)) {
                    continue;
                }
                let weight = scheme.weight;
                if (weight <= 0) {
                    continue;
                }
                if (weight == 100) {
                    validSchemes.unshift(scheme);
                }
                else {
                    validSchemes.push(scheme);
                }
            }
            if (validSchemes.length == 0) {
                return null;
            }
            return validSchemes;
        }
        getValidTemplates(scheme) {
            let validTemplates = [];
            let tids = scheme.tids;
            if (!tids || tids.length == 0) {
                return null;
            }
            for (let i = 0; i < tids.length; i++) {
                let tidS = tids[i];
                let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(tidS);
                if (!ulAdvTemplate) {
                    console.warn("ULAdvSlot-getValidTemplates:广告位【" + this.advId + "】对应的模板【" + tidS + "】不存在模板对象，需检查模板列表中是否配置该模板id");
                    continue;
                }
                if (!ULAdvExpManager.calcExp(ulAdvTemplate.exp)) {
                    continue;
                }
                let tidWeight = scheme.tidWeights[i];
                if (tidWeight <= 0) {
                    continue;
                }
                validTemplates.push(ulAdvTemplate);
            }
            return validTemplates;
        }
        calcValidObjectByTemplateId(tid) {
            let objectBases = ULSdkManager.getInstance().advManager.getAdvObjsByTid(tid);
            if (!objectBases || objectBases.length == 0)
                return null;
            let readyObjects = [];
            for (const base of objectBases) {
                if (base.preLoadState == ULConst.ADV_PRELOAD_STATE_READY) {
                    readyObjects.push(base);
                }
            }
            let targetObjects;
            if (readyObjects.length == 0) {
                targetObjects = objectBases;
            }
            else {
                targetObjects = readyObjects;
            }
            let argWeights = new Array(targetObjects.length);
            let ulAdvTemplate = ULSdkManager.getInstance().advManager.getTemplateObjByTid(tid);
            if (!ulAdvTemplate) {
                return null;
            }
            for (let j = 0, len = targetObjects.length; j < len; j++) {
                let objectBase = targetObjects[j];
                for (let i = 0, len = ulAdvTemplate.args.length; i < len; i++) {
                    let arg = ulAdvTemplate.args[i];
                    let key = ulAdvTemplate.moduleName + "_" + arg;
                    let argWeight = ulAdvTemplate.argWeights[i];
                    if (key == objectBase.advKey) {
                        argWeights[j] = argWeight;
                    }
                }
            }
            let index = ULTools.calcWheelTargetByArray(argWeights, ULConst.ADV_MUST_DEFAULT_WEIGHT);
            if (index != null) {
                return targetObjects[index];
            }
            return null;
        }
        onAdvObjectPreloadStateChanged(advKey) {
            if (!this.validAdvKeys || this.validAdvKeys.indexOf(advKey) == -1)
                return;
            this.refreshPreloadState();
        }
        refreshPreloadState() {
            let bHasLoading = false;
            let bHasReady = false;
            for (const advKey of this.validAdvKeys) {
                let state = ULSdkManager.getInstance().advManager.getAdvObjPreloadStateByAdvKey(advKey);
                if (state == ULConst.ADV_PRELOAD_STATE_LOADING) {
                    bHasLoading = true;
                }
                else if (state == ULConst.ADV_PRELOAD_STATE_READY) {
                    bHasReady = true;
                }
            }
            if (bHasReady) {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            }
            else if (bHasLoading) {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
            }
            else {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_NOAD;
            }
        }
        onAdvObjectLifeCycleSkip(data, info) {
            if (this.openingInfo == null) {
                return;
            }
            if (this.openingInfo != null) {
                this.openingInfo.advTemplateItemName = null;
            }
            this.showNextAdv(data, info);
        }
        onAdvObjectLifeCycleShow(msg, data) {
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(this.showTid);
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(this.showTid);
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, { code: "", msg: msg });
            if (rewardType.show == rType) {
                ULSdkManager.getInstance().advManager.responseRewardAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            }
        }
        onAdvObjectLifeCycleClick(msg, data) {
            ULSdkManager.getInstance().advManager.responseClickAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            let rType = ULSdkManager.getInstance().advManager.getRewardTypeByTemplateId(this.showTid);
            if (rewardType.click == rType) {
                ULSdkManager.getInstance().advManager.responseRewardAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, msg);
            }
        }
        onAdvObjectLifeCycleClose() {
            let advType = ULSdkManager.getInstance().advManager.getAdvTypeByTemplateId(this.showTid);
            ULSdkManager.getInstance().advManager.deleteAdvIdOpening(advType, this.advId);
            this.openingInfo = null;
        }
        onAdvObjectLifeCycleFail(info, data) {
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info);
            this.openingInfo = null;
        }
    }
    ULAdvSlot.tid_lastRequestTime = {};

    class ULAdvItem {
        constructor(advId, userData, tag) {
            this.advId = advId;
            this.advType = ULSdkManager.getInstance().advManager.searchAdvTypeByAdvId(advId);
            this.advGroupId = ULSdkManager.getInstance().advManager.searchAdvGroupIdByAdvId(advId);
            this.userData = userData;
            this.tag = tag;
            this.serialId = ULAdvItem.SERIAL_ID++;
            this.bOpenAdvResultResponsed = false;
            this.bClickAdvResultResponsed = false;
            this.lifeCycleLog = {};
            this.bRequesting = true;
            this.statisChannelName = "";
            this.statisSdkAdvId = "";
            this.statisNativeAdTitle = "";
        }
        startimeoutTimer(timeoutSec) {
            if (this.timeoutTimer)
                return;
            this.timeoutTimer = new ULTimer(timeoutSec, 1, () => {
                ULSdkManager.getInstance().advManager.onAdvTimeout(this);
            });
            this.timeoutTimer.start();
        }
        stopTimeoutTimer() {
            if (this.timeoutTimer) {
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
        setLifeCycleLogAllCycle() {
            this.lifeCycleLog = {
                0: true, 1: true, 2: true, 3: true, 4: true, 5: true
            };
        }
        set advData(data) {
            this._advData = data;
        }
        get advData() {
            return this._advData;
        }
    }
    ULAdvItem.SERIAL_ID = 0;

    var ULErrorRuleLogic;
    (function (ULErrorRuleLogic) {
        ULErrorRuleLogic[ULErrorRuleLogic["ordinary"] = 0] = "ordinary";
        ULErrorRuleLogic[ULErrorRuleLogic["or"] = 1] = "or";
        ULErrorRuleLogic[ULErrorRuleLogic["with"] = 2] = "with";
        ULErrorRuleLogic[ULErrorRuleLogic["error"] = 3] = "error";
    })(ULErrorRuleLogic || (ULErrorRuleLogic = {}));
    class ULErrorRuleItem {
        constructor(ruleString = null) {
            this.ruleString = null;
            this.logic = ULErrorRuleLogic.ordinary;
            this.rule = null;
            this.rules = [];
            this.ruleString = ruleString;
            if (!ruleString || ruleString.length == 0) {
                this.logic = ULErrorRuleLogic.error;
                return;
            }
            this.initWithRule(this.ruleString);
        }
        get isWildcard() {
            return this.rule == "*";
        }
        initWithErrRule() {
            this.logic = ULErrorRuleLogic.error;
            this.rule = null;
            this.rules = [];
        }
        initWithRule(rule) {
            rule = rule.replace(/\s/g, "");
            let leftBracketNum = 0;
            let startLeftBracketNum = 0;
            let trimString = "";
            while (rule.length) {
                let char = rule.charAt(0);
                let nextChar = rule.length > 0 ? rule.charAt(1) : "";
                rule = rule.slice(1);
                switch (char) {
                    case "(":
                        {
                            leftBracketNum++;
                            let string = trimString;
                            if (string.replace(/\(/g, '') == "") {
                                startLeftBracketNum++;
                            }
                        }
                        break;
                    case ")":
                        {
                            let string = rule;
                            if (string.replace(/\)/g, '') == "" && startLeftBracketNum != 0) {
                                trimString = trimString.substring(startLeftBracketNum);
                                return this.initWithRule(trimString);
                            }
                            leftBracketNum--;
                            startLeftBracketNum = leftBracketNum > startLeftBracketNum ? startLeftBracketNum : leftBracketNum;
                        }
                        break;
                    case "|":
                        {
                            if (leftBracketNum == 0) {
                                if (char + nextChar == "||") {
                                    if (this.logic != ULErrorRuleLogic.or && this.logic != ULErrorRuleLogic.ordinary) {
                                        return this.initWithErrRule();
                                    }
                                    this.logic = ULErrorRuleLogic.or;
                                    this.rules.push(new ULErrorRuleItem(trimString));
                                    trimString = "";
                                }
                                continue;
                            }
                        }
                        break;
                    case "&":
                        {
                            if (leftBracketNum == 0) {
                                if (char + nextChar == "&&") {
                                    if (this.logic != ULErrorRuleLogic.with && this.logic != ULErrorRuleLogic.ordinary) {
                                        return this.initWithErrRule();
                                    }
                                    this.logic = ULErrorRuleLogic.with;
                                    this.rules.push(new ULErrorRuleItem(trimString));
                                    trimString = "";
                                }
                                continue;
                            }
                        }
                        break;
                }
                trimString += char;
            }
            if (trimString.length > 0) {
                if (this.logic == ULErrorRuleLogic.ordinary) {
                    this.rule = trimString;
                }
                else {
                    this.rules.push(new ULErrorRuleItem(trimString));
                }
            }
        }
        complianceTheRules(key, customData = null) {
            switch (this.logic) {
                case ULErrorRuleLogic.ordinary:
                    {
                        return this.judgmentStandard(key, customData);
                    }
                    break;
                case ULErrorRuleLogic.or:
                    {
                        for (let subRuleItem of this.rules) {
                            if (subRuleItem.complianceTheRules(key, customData)) {
                                return true;
                            }
                        }
                        return false;
                    }
                    break;
                case ULErrorRuleLogic.with:
                    {
                        for (let subRuleItem of this.rules) {
                            if (!subRuleItem.complianceTheRules(key, customData)) {
                                return false;
                            }
                        }
                        return true;
                    }
                    break;
            }
            return false;
        }
        judgmentStandard(key, customData = null) {
            if (this.rule == null) {
                return false;
            }
            if (this.rule == "*") {
                return true;
            }
            if (this.rule == key) {
                return true;
            }
            if (this.rule.length > 2) {
                let rule = this.rule;
                let firstChar = rule.charAt(0);
                let lastChar = rule.charAt(this.rule.length - 1);
                if (firstChar + lastChar == '//') {
                    rule = rule.substring(1, rule.length - 1);
                    var reg = RegExp(rule);
                    if (reg.exec(key)) {
                        return true;
                    }
                }
            }
            var patrn = /(?==|!=|>=|>|<|<=)/;
            if (customData && patrn.exec(this.rule)) {
                let trimRule = this.rule.replace("this.", "customData.");
                return ULEvalExp.evalExpResults(trimRule, (key) => {
                    if (key == "customData") {
                        return customData;
                    }
                    return null;
                });
            }
            return false;
        }
    }
    class ULAdvTrimErrorManager {
        static trimErrMessage(msg, error) {
            let config = ULConfig.getConfig();
            if (!config.i_sdk_trim_adv_err_switch) {
                return (error && ULTools.format("%s %d", ULConst.ADV_FAIL_TIP_NOAD, error.code || error.errCode)) || msg || ULTools.format(ULConst.ADV_FAIL_TIP_NOAD, ULConst.ADV_ERR_CODE_UNKNOWN);
            }
            let errJson = config.t_sdk_trim_adv_err_object || {};
            if (!error) {
                return msg || ULTools.format(ULConst.ADV_FAIL_TIP_NOAD, ULConst.ADV_ERR_CODE_UNKNOWN);
            }
            let channelName = ULSdkManager.getInstance().channelInfo.channelName || "";
            let channelNameErrJson = {};
            channelNameErrJson[channelName] = error;
            let customMsg = null;
            try {
                customMsg = this.getCustomMsgFromRules(errJson, channelNameErrJson);
            }
            catch (error) {
                ULLog.console.error("ULAdvTrimErrorManager:错误整理报错-------------请检查配置");
                ULLog.console.error("ULAdvTrimErrorManager:errJson：", errJson);
                ULLog.console.error("ULAdvTrimErrorManager:channelNameErrJson：", channelNameErrJson);
            }
            if (customMsg) {
                customMsg = ULTools.format("%s %d", customMsg, error.code || error.errCode);
            }
            let trimMsg = customMsg || msg || ULTools.format(ULConst.ADV_FAIL_TIP_NOAD, ULConst.ADV_ERR_CODE_UNKNOWN);
            return trimMsg;
        }
        static getCustomMsgFromRules(type, errorData) {
            let typeKeys = [];
            let errorDataKeys = [];
            if (typeof type === 'object') {
                typeKeys = Object.keys(type);
            }
            else if (typeof type === 'string') {
                return type;
            }
            else {
                return "";
            }
            if (!errorData) {
                return "";
            }
            else if (typeof errorData === 'object') {
                errorDataKeys = Object.keys(errorData);
            }
            else {
                errorDataKeys.push(errorData);
            }
            let count = typeKeys.length;
            while (typeKeys.length) {
                let typeKey = typeKeys.shift();
                count--;
                let ruleItem = this.trimRules[typeKey];
                if (!ruleItem) {
                    ruleItem = new ULErrorRuleItem(typeKey);
                    this.trimRules[typeKey] = ruleItem;
                }
                if (ruleItem.isWildcard && count > 0) {
                    typeKeys.join(typeKey);
                    continue;
                }
                let typeValue = type[typeKey];
                for (let errorDataKey of errorDataKeys) {
                    if (ruleItem.complianceTheRules(errorDataKey, errorData)) {
                        let errorDataValue = errorData[errorDataKey] || null;
                        let returnString = this.getCustomMsgFromRules(typeValue, errorDataValue);
                        if (returnString) {
                            return returnString;
                        }
                    }
                }
            }
            return "";
        }
    }
    ULAdvTrimErrorManager.trimRules = {};

    var typeExp;
    (function (typeExp) {
        typeExp["all"] = "all";
        typeExp["splash"] = "splash";
        typeExp["inter"] = "inter";
        typeExp["video"] = "video";
        typeExp["custom"] = "custom";
        typeExp["interVideo"] = "interVideo";
        typeExp["banner"] = "banner";
        typeExp["embed"] = "embed";
        typeExp["url"] = "url";
        typeExp["paster"] = "paster";
    })(typeExp || (typeExp = {}));
    var rewardType;
    (function (rewardType) {
        rewardType["show"] = "show";
        rewardType["click"] = "click";
    })(rewardType || (rewardType = {}));
    var countExp;
    (function (countExp) {
        countExp["rc"] = "rc";
        countExp["sc"] = "sc";
        countExp["cc"] = "cc";
        countExp["fc"] = "fc";
        countExp["mcc"] = "mcc";
    })(countExp || (countExp = {}));
    var cdExp;
    (function (cdExp) {
        cdExp["rcd"] = "rcd";
        cdExp["scd"] = "scd";
        cdExp["ecd"] = "ecd";
    })(cdExp || (cdExp = {}));
    var dataExp;
    (function (dataExp) {
        dataExp["nil"] = "nil";
        dataExp["d"] = "d";
        dataExp["w"] = "w";
        dataExp["m"] = "m";
        dataExp["y"] = "y";
    })(dataExp || (dataExp = {}));
    var openResult;
    (function (openResult) {
        openResult["totalAdvRequest"] = "totalAdvRequest";
        openResult["branchAdvRequest"] = "branchAdvRequest";
        openResult["success"] = "success";
        openResult["failed"] = "failed";
        openResult["clicked"] = "clicked";
        openResult["playStart"] = "playStart";
        openResult["playCompletion"] = "playCompletion";
        openResult["loadAdvRequest"] = "loadAdvRequest";
        openResult["close"] = "close";
        openResult["hide"] = "hide";
    })(openResult || (openResult = {}));
    var oldTypeExp;
    (function (oldTypeExp) {
        oldTypeExp["interstitial"] = "interstitial";
        oldTypeExp["embedded"] = "embedded";
        oldTypeExp["fullscreen"] = "fullscreen";
    })(oldTypeExp || (oldTypeExp = {}));
    class ULAdvManager {
        constructor() {
            this.systemAdvExpKeyArray = [];
            this.advExpKeyArray = [];
            this.advRequestSerialNum = 0;
            this.advId_2_advSlot = {};
            this.templateId_2_advTemplate = {};
            this.templateId_2_advTemplateItemArray = {};
            this.advKey_2_templateIdArray = {};
            this.moduleName_2_argsArray = {};
            this.moduleName_2_advIdsArray = {};
            this.templateId_2_moduleName = {};
            this.moduleName_2_advTemplate = {};
            this.mainName_2_advObjectArray = {};
            this.templateId_2_advObjectArray = {};
            this.advType_2_advObjectArray = {};
            this.moduleName_2_templateIdsArray = {};
            this.logKey_2_countNum = {};
            this.advKey_2_advIdArray = {};
            this.tid_2_advKeyArray = {};
            this.advId_2_tidArray = {};
            this.nativeType_2_advObjectArray = {};
            this.advKey_2_advObject = {};
            this.ADV_RELOAD_DEFAULT_TIME = 15000;
            this.ADV_RELOAD_TIME = 15000;
            this.bannerStartShowTime = 0;
            this.advKey_2_rcd = {};
            this.advId_2_lastRequestTime = {};
            this.adMainName_2_obj = {};
            this.type_2_advIds = {};
            this.exp_2_result = {};
            this.advTypeLastTriggerTimeLog = {};
        }
        static getInstance() {
            if (this.instance == null) {
                this.instance = new ULAdvManager();
            }
            return this.instance;
        }
        get isFirstPlayVideo() {
            return this._isFirstPlayVideo;
        }
        set isFirstPlayVideo(v) {
            this._isFirstPlayVideo = v;
        }
        init() {
            this.loadRecord();
            this.initAdvExpKey();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_ADV, ULConst.PRIORITY_NONE, this.onCmdOpenAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLOSE_ADV, ULConst.PRIORITY_NONE, this.onCmdCloseAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLOSE_NATIVE_ADV, ULConst.PRIORITY_NONE, this.onCmdCloseNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_CLICK_NATIVE_ADV, ULConst.PRIORITY_NONE, this.onCmdClickNativeAdv.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_ADV_STATE, ULConst.PRIORITY_NONE, this.onCmdGetAdvState.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_COP_CHANGED, 1, this.onCopChanged.bind(this));
            this._sdkInitTime = ULTools.time();
            this.isFirstPlayVideo = true;
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.advTypeDailyCountLog = record.advTypeDailyCountLog || {};
            this.advTypeDailyRefreshTime = record.advTypeDailyRefreshTime || 0;
            this.tryDailyRefresh();
        }
        saveRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            record.advTypeDailyCountLog = this.advTypeDailyCountLog || {};
            record.advTypeDailyRefreshTime = this.advTypeDailyRefreshTime || 0,
                ULStorageManager.getInstance().setStorage(this._getRecordKey(), JSON.stringify(record));
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULAdvManager_record_%d", config.s_sdk_megadata_game_id);
        }
        tryDailyRefresh() {
            if (!ULTools.isOneDay(this.advTypeDailyRefreshTime, ULTools.time())) {
                ULLog.console.log("ULAdvManager-tryDailyRefresh 进行日常刷新");
                this.advTypeDailyCountLog = {};
                this.advTypeDailyRefreshTime = ULTools.time();
                this.saveRecord();
            }
        }
        searchAdvGroupIdByAdvId(advId) {
            let config = ULConfig.getConfig();
            let advInfo = config.s_sdk_adv_info;
            let advGroupId = "";
            ULTools.forEachMap(advInfo, (k, v) => {
                if (v.group.indexOf(advId) >= 0) {
                    advGroupId = k;
                    return true;
                }
            });
            return advGroupId;
        }
        searchAdvTypeByAdvId(advId) {
            let config = ULConfig.getConfig();
            let advInfo = config.s_sdk_adv_info;
            let advType = "";
            ULTools.forEachMap(advInfo, (k, v) => {
                if (v.group.indexOf(advId) >= 0) {
                    advType = v.type;
                    return true;
                }
            });
            return advType;
        }
        onCopChanged(e) {
            try {
                this.initAdv();
            }
            catch (error) {
                ULLog.console.error("ULAdvManager.onCopChanged err:", error.stack);
            }
        }
        onCmdSdkOnGameResume(e) {
            ULLog.console.log("ULAdvManager-onCmdSdkOnGameResume");
            let objectBase = this.getAdvObjectOpeningByAdvType(typeExp.banner);
            if (!objectBase)
                return;
            this.bannerStartShowTime = ULTools.time();
        }
        onCmdSdkOnGamePause(e) {
            let objectBase = this.getAdvObjectOpeningByAdvType(typeExp.banner);
            if (!objectBase)
                return;
            let nativeData;
            if (objectBase instanceof ULAdvNativeObjectBase) {
                nativeData = objectBase.nativeData;
            }
            this.reportBannerShowTime(objectBase.advKey, objectBase.showData, nativeData);
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let advTypes = ["interstitial", "banner", "embedded", "video", "url", "paster"];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "广告cd限制:" });
            config.push({ type: "newLine" });
            for (let i = 0; i < advTypes.length; i++) {
                const advType = advTypes[i];
                let cdTag = "未配置CD";
                let lastTriggerTag = "未触发";
                let cd = this.getAdvTypeCd(advType);
                if (cd > 0) {
                    cdTag = ULTools.format("CD%d秒", cd / 1000);
                }
                let lastTriggerTime = this.advTypeLastTriggerTimeLog[advType] || 0;
                if (lastTriggerTime > 0) {
                    lastTriggerTag = ULTools.formatDate(new Date(lastTriggerTime * 1000), "触发时间：HH:mm:ss");
                }
                config.push({ type: "label", text: ULTools.format("%s: %s %s", advType, cdTag, lastTriggerTag) });
                config.push({ type: "newLine" });
            }
            config.push({ type: "label", text: "广告次数限制:" });
            config.push({ type: "newLine" });
            for (let i = 0; i < advTypes.length; i++) {
                const advType = advTypes[i];
                let limitTag = "未配置次数限制";
                let countTag = "未触发";
                let dailyLimit = this.getAdvTypeDailyLimit(advType);
                if (dailyLimit > 0) {
                    limitTag = ULTools.format("日限制%d次", dailyLimit);
                }
                let dailyCount = this.advTypeDailyCountLog[advType] || 0;
                if (dailyCount > 0) {
                    countTag = ULTools.format("今日已触发%d次", dailyCount);
                }
                config.push({ type: "label", text: ULTools.format("%s: %s %s", advType, limitTag, countTag) });
                config.push({ type: "newLine" });
            }
            e.setReturnValue(config, true);
        }
        initAdv() {
            let config = ULConfig.getConfig();
            this.ADV_RELOAD_TIME = config["i_sdk_adv_reload_time"] || this.ADV_RELOAD_DEFAULT_TIME;
            let showListS = config["o_sdk_adv_show_list"];
            if (!showListS || typeof (showListS) !== "string") {
                console.warn("ULAdvManager-initAdv:adv show list error");
                return;
            }
            let showListObject = JSON.parse(showListS);
            let templatesObj = showListObject["templates"];
            if (!templatesObj || typeof (templatesObj) !== "object") {
                console.warn("ULAdvManager-initAdv:templates error");
                return;
            }
            let advSlotsObj = showListObject["advSlots"];
            if (!advSlotsObj || typeof (advSlotsObj) !== "object") {
                console.warn("ULAdvManager-initAdv:advSlots error");
                return;
            }
            let old_advKey_2_advObject = this.advKey_2_advObject;
            this.advKey_2_advObject = {};
            this.advId_2_advSlot = {};
            this.templateId_2_advTemplate = {};
            this.templateId_2_advTemplateItemArray = {};
            this.advKey_2_templateIdArray = {};
            this.templateId_2_moduleName = {};
            this.mainName_2_advObjectArray = {};
            this.templateId_2_advObjectArray = {};
            this.advType_2_advObjectArray = {};
            this.moduleName_2_templateIdsArray = {};
            this.logKey_2_countNum = {};
            this.advKey_2_advIdArray = {};
            this.tid_2_advKeyArray = {};
            this.advId_2_tidArray = {};
            this.nativeType_2_advObjectArray = {};
            this.advKey_2_rcd = {};
            this.updateAdvExpKey(templatesObj);
            let templateArray = new Array();
            for (const key in templatesObj) {
                let templateId = key;
                let templateItem = templatesObj[templateId];
                if (typeof (templateItem) !== "object") {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】格式配置非法`);
                    continue;
                }
                let moduleName = templateItem['moduleName'];
                if (!moduleName || (typeof moduleName) !== "string") {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】缺少必配字段moduleName`);
                    continue;
                }
                let rewardType = templateItem['rewardType'];
                if (!rewardType || (typeof moduleName) !== "string") {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】缺少必配字段rewardType`);
                    continue;
                }
                let args = templateItem['args'];
                if (!args || !(args instanceof Array)) {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】缺少必配字段args，或格式非法`);
                    continue;
                }
                if (args.length == 0) {
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】必配字段args长度不能为0`);
                    continue;
                }
                let exp = templateItem['exp'] || "";
                let argWeights = templateItem["argWeights"] || [];
                let loadTypes = templateItem["loadTypes"] || [];
                let rcd = templateItem["rcd"];
                if ((typeof rcd) !== "number") {
                    rcd = 0;
                    console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】字段rcd未配置或格式错误，写入默认值0`);
                }
                let templateIdsArray = this.moduleName_2_templateIdsArray[moduleName];
                if (!templateIdsArray) {
                    templateIdsArray = [];
                    templateIdsArray.push(templateId);
                    this.moduleName_2_templateIdsArray[moduleName] = templateIdsArray;
                }
                else {
                    if (templateIdsArray.indexOf(templateId) == -1) {
                        templateIdsArray.push(templateId);
                    }
                }
                if (!this.templateId_2_moduleName[templateId]) {
                    this.templateId_2_moduleName[templateId] = moduleName;
                }
                if (templateArray.indexOf(templateId) == -1) {
                    templateArray.push(templateId);
                }
                let newArgWeights = [];
                let newLoadTypes = [];
                for (let i = 0, len = args.length; i < len; i++) {
                    let arg = args[i];
                    if (typeof (arg) !== "string") {
                        console.warn(`ULAdvManager-initAdv:模板【 ${templateId} 】字段args中的参数${arg}，为非字符串类型`);
                        arg = arg.toString();
                    }
                    let argWeight = 0;
                    if (argWeights.length == 0) {
                        argWeight = ULConst.ADV_RANDOM_DEFAULT_WEIGHT;
                    }
                    else {
                        argWeight = argWeights[i];
                    }
                    newArgWeights.push(argWeight);
                    let loadType = undefined;
                    try {
                        loadType = loadTypes[i];
                        if (loadType && typeof (loadType) !== "number") {
                            loadType = Number(loadType);
                        }
                    }
                    catch (error) {
                    }
                    newLoadTypes.push(loadType);
                    let ulAdvTemplateItem = {
                        templateId: templateId,
                        moduleName: moduleName,
                        rewardType: rewardType,
                        arg: arg,
                        argWeight: argWeight,
                        exp: exp,
                        loadType: loadType
                    };
                    let templateItemArray = this.templateId_2_advTemplateItemArray[templateId];
                    if (!templateItemArray) {
                        templateItemArray = [];
                        templateItemArray.push(ulAdvTemplateItem);
                        this.templateId_2_advTemplateItemArray[templateId] = templateItemArray;
                    }
                    else {
                        let bContains = false;
                        for (const item of templateItemArray) {
                            let key = item.templateId + "_" + item.arg;
                            let targetKey = templateId + "_" + arg;
                            if (key == targetKey) {
                                bContains = true;
                            }
                        }
                        if (!bContains) {
                            templateItemArray.push(ulAdvTemplateItem);
                        }
                    }
                    let advKey = ULTools.format("%s%s%s", moduleName, "_", arg);
                    let tidArray = this.advKey_2_templateIdArray[advKey];
                    if (!tidArray) {
                        tidArray = [];
                        tidArray.push(templateId);
                        this.advKey_2_templateIdArray[advKey] = tidArray;
                    }
                    else {
                        if (tidArray.indexOf(templateId) == -1) {
                            tidArray.push(templateId);
                        }
                    }
                    let advkeyArray = this.tid_2_advKeyArray[templateId];
                    if (!advkeyArray) {
                        advkeyArray = [];
                        advkeyArray.push(advKey);
                        this.tid_2_advKeyArray[templateId] = advkeyArray;
                    }
                    else {
                        if (advkeyArray.indexOf(advKey) == -1) {
                            advkeyArray.push(advKey);
                        }
                    }
                    let num = this.advKey_2_rcd[advKey];
                    let cd;
                    if (num != undefined) {
                        cd = Math.min(rcd, num);
                    }
                    else {
                        cd = rcd;
                    }
                    this.advKey_2_rcd[advKey] = cd;
                }
                let advTemplate = {
                    templateId: templateId,
                    moduleName: moduleName,
                    rewardType: rewardType,
                    exp: exp,
                    args: args,
                    argWeights: newArgWeights,
                    rcd: rcd,
                    loadTypes: newLoadTypes
                };
                if (!this.templateId_2_advTemplate[templateId]) {
                    this.templateId_2_advTemplate[templateId] = advTemplate;
                }
            }
            let tidsInAdvSlotsArray = [];
            for (const key in advSlotsObj) {
                let advId = key;
                let advSlotItem = advSlotsObj[advId];
                if (typeof (advSlotItem) !== "object") {
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】格式配置非法`);
                    continue;
                }
                let schemesArray = advSlotItem["schemes"];
                if (!schemesArray) {
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】缺少必配字段schemes,或该字段格式非法`);
                    continue;
                }
                let subAidsArray = advSlotItem["subAids"] || [];
                let rcd = advSlotItem["rcd"];
                if ((typeof rcd) !== "number") {
                    rcd = 0;
                    console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】字段rcd未配置或格式错误，写入默认值0`);
                }
                let schemeArray = [];
                for (let i = 0, len = schemesArray.length; i < len; i++) {
                    const schemeItemObj = schemesArray[i];
                    let tids = schemeItemObj["tids"];
                    if (!tids) {
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略缺少必配字段tids,或该字段格式非法`);
                        continue;
                    }
                    if (tids.length == 0) {
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略必配字段tids长度不能为0`);
                        continue;
                    }
                    let tidWeights = schemeItemObj["tidWeights"] || [];
                    let newTidWeights = [];
                    for (let j = 0, len = tids.length; j < len; j++) {
                        let tid = tids[j];
                        let tidWeight = 0;
                        if (tidWeights.length == 0) {
                            console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略第【 ${j + 1} 】个模板权重未配置，写入默认值${ULConst.ADV_MUST_DEFAULT_WEIGHT}`);
                            tidWeight = ULConst.ADV_MUST_DEFAULT_WEIGHT;
                        }
                        else {
                            let tidW = tidWeights[j];
                            if ((typeof tidW) !== "number") {
                                console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略第【 ${j + 1} 】个模板权重格式异常，写入默认值${ULConst.ADV_MUST_DEFAULT_WEIGHT}`);
                                tidWeight = ULConst.ADV_MUST_DEFAULT_WEIGHT;
                            }
                            else {
                                tidWeight = tidW;
                            }
                        }
                        newTidWeights.push(tidWeight);
                        if (tidsInAdvSlotsArray.indexOf(tid) == -1) {
                            tidsInAdvSlotsArray.push(tid);
                        }
                        let tidArray = this.advId_2_tidArray[advId];
                        if (!tidArray) {
                            tidArray = [];
                            tidArray.push(tid);
                            this.advId_2_tidArray[advId] = tidArray;
                        }
                        else {
                            if (tidArray.indexOf(tid) == -1) {
                                tidArray.push(tid);
                            }
                        }
                        if (subAidsArray.length > 0) {
                            for (const advId of subAidsArray) {
                                let tidArray = this.advId_2_tidArray[advId];
                                if (!tidArray) {
                                    tidArray = [];
                                    tidArray.push(tid);
                                    this.advId_2_tidArray[advId] = tidArray;
                                }
                                else {
                                    if (tidArray.indexOf(tid) == -1) {
                                        tidArray.push(tid);
                                    }
                                }
                            }
                        }
                    }
                    let exp = schemeItemObj["exp"] || "";
                    let weight = schemeItemObj["weight"];
                    if ((typeof weight) !== "number") {
                        weight = ULConst.ADV_RANDOM_DEFAULT_WEIGHT;
                        console.warn(`ULAdvManager-initAdv:广告位【 ${advId} 】第【 ${i + 1} 】条策略字段weight格式异常，写入默认值${ULConst.ADV_RANDOM_DEFAULT_WEIGHT}`);
                    }
                    let ulAdvScheme = {
                        tids: tids,
                        tidWeights: newTidWeights,
                        exp: exp,
                        weight: weight
                    };
                    schemeArray.push(ulAdvScheme);
                }
                let advSlot = new ULAdvSlot(advId, schemeArray, subAidsArray, rcd);
                if (!this.advId_2_advSlot[advId]) {
                    this.advId_2_advSlot[advId] = advSlot;
                }
                if (subAidsArray.length > 0) {
                    for (const mAdvId of subAidsArray) {
                        let newSubAidsArray = ULTools.clone(subAidsArray);
                        let index = newSubAidsArray.indexOf(mAdvId);
                        if (index > -1) {
                            newSubAidsArray.splice(index, 1);
                        }
                        newSubAidsArray.push(advId);
                        let subIdAdvSlot = new ULAdvSlot(mAdvId, schemeArray, newSubAidsArray, rcd);
                        if (!this.advId_2_advSlot[mAdvId]) {
                            this.advId_2_advSlot[mAdvId] = subIdAdvSlot;
                        }
                    }
                }
            }
            ULTools.forEachMap(this.advId_2_tidArray, (advId, tidArray) => {
                for (const tid of tidArray) {
                    let advKeyArray = this.tid_2_advKeyArray[tid];
                    if (!advKeyArray)
                        continue;
                    for (const key of advKeyArray) {
                        let advIdArray = this.advKey_2_advIdArray[key];
                        if (!advIdArray) {
                            advIdArray = [];
                            advIdArray.push(advId);
                            this.advKey_2_advIdArray[key] = advIdArray;
                        }
                        else {
                            if (advIdArray.indexOf(advId) == -1) {
                                advIdArray.push(advId);
                            }
                        }
                    }
                }
            });
            let newAdvBaseObjectArray = [];
            for (const tid in this.templateId_2_advTemplateItemArray) {
                let tidItemArray = this.templateId_2_advTemplateItemArray[tid];
                if (tidsInAdvSlotsArray.indexOf(tid) == -1) {
                    console.warn("ULAdvManager-initAdv:tid [" + tid + "] no advId use");
                    continue;
                }
                let moduleName = this.templateId_2_moduleName[tid];
                let moduleMainClass;
                ULTools.forEachMap(ULSdkModuleLoader.getSubAdModuleClassName(), (k, v) => {
                    let moduleNameArray = v;
                    if (moduleNameArray.indexOf(moduleName) >= 0) {
                        moduleMainClass = k;
                        return true;
                    }
                });
                if (!moduleMainClass) {
                    console.warn("ULAdvManager-initAdv: class " + moduleName + " not found ,continue");
                    continue;
                }
                for (let i = 0, len = tidItemArray.length; i < len; i++) {
                    let templateItem = tidItemArray[i];
                    let advKey = templateItem.moduleName + "_" + templateItem.arg;
                    if (old_advKey_2_advObject[advKey]) {
                        let obj = old_advKey_2_advObject[advKey];
                        this.advKey_2_advObject[advKey] = obj;
                        delete old_advKey_2_advObject[advKey];
                    }
                    if (this.advKey_2_advObject[advKey]) {
                        console.warn("ULAdvManger-initAdv: class " + moduleName + " already init,continue");
                        let obj = this.advKey_2_advObject[advKey];
                        let templateItemObjectsArray = this.templateId_2_advObjectArray[tid];
                        if (!templateItemObjectsArray) {
                            templateItemObjectsArray = [];
                            templateItemObjectsArray.push(obj);
                            this.templateId_2_advObjectArray[tid] = templateItemObjectsArray;
                        }
                        else {
                            if (templateItemObjectsArray.indexOf(obj) == -1) {
                                templateItemObjectsArray.push(obj);
                            }
                        }
                        continue;
                    }
                    let mainObj = ULSdkModuleLoader.getObjectByModuleName(moduleMainClass);
                    let targetObj = mainObj.createSubAdObj(moduleName, templateItem.arg);
                    targetObj.setLoadType = templateItem.loadType;
                    let advMainClassNameString = targetObj.getMainClassNameString();
                    if (newAdvBaseObjectArray.indexOf(targetObj) == -1) {
                        newAdvBaseObjectArray.push(targetObj);
                    }
                    let templateItemObjectArray = this.mainName_2_advObjectArray[advMainClassNameString];
                    if (!templateItemObjectArray) {
                        templateItemObjectArray = [];
                        templateItemObjectArray.push(targetObj);
                        this.mainName_2_advObjectArray[advMainClassNameString] = templateItemObjectArray;
                    }
                    else {
                        if (templateItemObjectArray.indexOf(targetObj) == -1) {
                            templateItemObjectArray.push(targetObj);
                        }
                    }
                    let templateItemObjectsArray = this.templateId_2_advObjectArray[tid];
                    if (!templateItemObjectsArray) {
                        templateItemObjectsArray = [];
                        templateItemObjectsArray.push(targetObj);
                        this.templateId_2_advObjectArray[tid] = templateItemObjectsArray;
                    }
                    else {
                        if (templateItemObjectsArray.indexOf(targetObj) == -1) {
                            templateItemObjectsArray.push(targetObj);
                        }
                    }
                    if (targetObj instanceof ULAdvNativeObjectBase) {
                        let type = targetObj.advType;
                        let ulAdvNativeObjectBases = this.nativeType_2_advObjectArray[type];
                        if (ulAdvNativeObjectBases == null) {
                            ulAdvNativeObjectBases = [];
                            ulAdvNativeObjectBases.push(targetObj);
                            this.nativeType_2_advObjectArray[type] = ulAdvNativeObjectBases;
                        }
                        else {
                            if (ulAdvNativeObjectBases.indexOf(targetObj) == -1) {
                                ulAdvNativeObjectBases.push(targetObj);
                            }
                        }
                    }
                }
            }
            ;
            ULTools.forEachMap(this.advKey_2_advObject, (k, v) => {
                let objectBase = v;
                let bases = this.advType_2_advObjectArray[objectBase.advType];
                if (!bases) {
                    bases = [];
                    bases.push(objectBase);
                    this.advType_2_advObjectArray[objectBase.advType] = bases;
                }
                else {
                    if (bases.indexOf(objectBase) == -1) {
                        bases.push(objectBase);
                    }
                }
            });
            for (const key in old_advKey_2_advObject) {
                let object = old_advKey_2_advObject[key];
                object.onDisposeModule();
            }
            ULTools.forEachMap(this.advId_2_advSlot, (advId, advSlot) => {
                let slot = advSlot;
                slot.refreshValidAdvKeys();
            });
            let newAdvBaseCache = {};
            for (let i = 0, len = newAdvBaseObjectArray.length; i < len; i++) {
                let advObjectBaseCacheItem = newAdvBaseObjectArray[i];
                let advMainClassNameString = advObjectBaseCacheItem.getMainClassNameString();
                ULTools.forEachMap(ULSdkModuleLoader.getSubAdMainClassName(), (k, v) => {
                    let adMainClassName = v;
                    if (advMainClassNameString == adMainClassName) {
                        if (this.adMainName_2_obj[adMainClassName]) {
                            let targetObj = this.adMainName_2_obj[adMainClassName];
                            advObjectBaseCacheItem.receiveMainClassInitState(targetObj.initState);
                        }
                        else if (!newAdvBaseCache[adMainClassName]) {
                            let obj = ULSdkModuleLoader.getObjectByModuleName(k);
                            let targetObj = obj.createMainAdObj();
                            newAdvBaseCache[adMainClassName] = targetObj;
                        }
                    }
                });
            }
            for (const key in newAdvBaseCache) {
                this.adMainName_2_obj[key] = newAdvBaseCache[key];
            }
            ULLog.console.log("ULAdvManager-initAdv-advExpKeyArray:", this.advExpKeyArray);
            ULLog.console.log("ULAdvManager-initAdv-templateArray:", templateArray);
            ULLog.console.log("ULAdvManager-initAdv-advId_2_advSlot:", this.advId_2_advSlot);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advTemplate:", this.templateId_2_advTemplate);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advTemplateItemArray:", this.templateId_2_advTemplateItemArray);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_templateIdArray:", this.advKey_2_templateIdArray);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_moduleName:", this.templateId_2_moduleName);
            ULLog.console.log("ULAdvManager-initAdv-mainName_2_advObjectArray:", this.mainName_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-templateId_2_advObjectArray:", this.templateId_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-advType_2_advObjectArray:", this.advType_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-moduleName_2_templateIdsArray:", this.moduleName_2_templateIdsArray);
            ULLog.console.log("ULAdvManager-initAdv-logKey_2_countNum:", this.logKey_2_countNum);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_advIdArray:", this.advKey_2_advIdArray);
            ULLog.console.log("ULAdvManager-initAdv-tid_2_advKeyArray:", this.tid_2_advKeyArray);
            ULLog.console.log("ULAdvManager-initAdv-advId_2_tidArray:", this.advId_2_tidArray);
            ULLog.console.log("ULAdvManager-initAdv-nativeType_2_advObjectArray:", this.nativeType_2_advObjectArray);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_advObject:", this.advKey_2_advObject);
            ULLog.console.log("ULAdvManager-initAdv-advKey_2_rcd:", this.advKey_2_rcd);
        }
        getAdvReloadTime() {
            return this.ADV_RELOAD_TIME;
        }
        getAdvExpKeyArray() {
            return this.advExpKeyArray;
        }
        getLogKeyCountNum() {
            return this.logKey_2_countNum;
        }
        initAdvExpKey() {
            let keyArray = new Array();
            for (const type in typeExp) {
                for (const count in countExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TYPE_CONST, type, ULConst.EXP_ADV_POINT_CONST, count);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
                for (const cd in cdExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TYPE_CONST, type, ULConst.EXP_ADV_POINT_CONST, cd);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
            }
            for (let i = 0; i < keyArray.length; i++) {
                let key = keyArray[i];
                for (const data in dataExp) {
                    let newKey;
                    if (data == dataExp.nil) {
                        newKey = key;
                    }
                    else {
                        newKey = data + key;
                    }
                    if (this.systemAdvExpKeyArray.indexOf(newKey) == -1) {
                        this.systemAdvExpKeyArray.push(newKey);
                    }
                }
            }
        }
        updateAdvExpKey(templatesObj) {
            this.advExpKeyArray = this.systemAdvExpKeyArray.slice(0);
            let keyArray = new Array();
            for (const template in templatesObj) {
                for (const count in countExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TEMPLATE_CONST, template, ULConst.EXP_ADV_POINT_CONST, count);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
                for (const cd in cdExp) {
                    let key = ULTools.format("%s%s%s%s", ULConst.EXP_ADV_TEMPLATE_CONST, template, ULConst.EXP_ADV_POINT_CONST, cd);
                    if (keyArray.indexOf(key) == -1) {
                        keyArray.push(key);
                    }
                }
            }
            for (let i = 0; i < keyArray.length; i++) {
                let key = keyArray[i];
                for (const data in dataExp) {
                    let newKey;
                    if (data == dataExp.nil) {
                        newKey = key;
                    }
                    else {
                        newKey = data + key;
                    }
                    if (this.advExpKeyArray.indexOf(newKey) == -1) {
                        this.advExpKeyArray.push(newKey);
                    }
                }
            }
            ULAdvExpManager.updateExpKeys(this.advExpKeyArray);
        }
        updateAdvKeyObjMap(advKey, advObject) {
            this.advKey_2_advObject[advKey] = advObject;
        }
        updateAdvIds(type, advId) {
            let advIds = this.type_2_advIds[type];
            if (!advIds) {
                advIds = [];
                advIds.push(advId);
                this.type_2_advIds[type] = advIds;
            }
            else {
                if (advIds.indexOf(advId) == -1) {
                    advIds.push(advId);
                }
            }
        }
        deleteAdvIdOpening(type, advId) {
            let advIds = this.type_2_advIds[type];
            if (advIds) {
                advIds = advIds.filter(item => item !== advId);
                this.type_2_advIds[type] = advIds;
            }
        }
        getAdvObjectsByName(mainName) {
            return this.mainName_2_advObjectArray[mainName];
        }
        onAdvObjectPreloadStateChanged(advKey) {
            ULTools.forEachMap(this.advId_2_advSlot, (k, v) => {
                let advSlot = v;
                advSlot.onAdvObjectPreloadStateChanged(advKey);
            });
        }
        onAdvSlotPreloadStateChanged(advId) {
            let ulAdvSlot = this.advId_2_advSlot[advId];
            if (!ulAdvSlot) {
                return;
            }
            let states = {};
            states[advId] = ulAdvSlot.preLoadState;
        }
        getTemplateObjByTid(tid) {
            return this.templateId_2_advTemplate[tid];
        }
        getAdvObjsByTid(tid) {
            return this.templateId_2_advObjectArray[tid];
        }
        getAdvTypeByTemplateId(tid) {
            let advType = null;
            let advObjects = this.templateId_2_advObjectArray[tid];
            if (advObjects && advObjects.length > 0) {
                advType = advObjects[0].advType;
            }
            return advType;
        }
        isAdvTypeOpened(advType) {
            let config = ULConfig.getConfig();
            let exemptArray = config.t_sdk_exempt_advType_limit_arrays;
            if (exemptArray.indexOf(advType) != -1) {
                return false;
            }
            let mutuallyExclusive = config.t_sdk_mutuallyExclusive_advType_setting || {};
            let trimMutuallyExclusiv = {};
            for (let advType of Object.keys(mutuallyExclusive)) {
                let itemList = mutuallyExclusive[advType];
                for (let subAdvType of itemList) {
                    let list = trimMutuallyExclusiv[advType] || [advType];
                    let otherList = trimMutuallyExclusiv[subAdvType] || [subAdvType];
                    list.push(subAdvType);
                    otherList.push(advType);
                    trimMutuallyExclusiv[advType] = list;
                    trimMutuallyExclusiv[subAdvType] = otherList;
                }
            }
            let itemList = trimMutuallyExclusiv[advType] || [advType];
            for (let subAdvType of itemList) {
                let objectBases = this.advType_2_advObjectArray[subAdvType];
                if (objectBases && objectBases.length > 0) {
                    for (let i = 0; i < objectBases.length; i++) {
                        let objectBase = objectBases[i];
                        if (objectBase.isOpened)
                            return true;
                    }
                }
            }
            return false;
        }
        getAdvObjectByAdvKey(advKey) {
            return this.advKey_2_advObject[advKey];
        }
        getRcdByAdvKey(advkey) {
            return this.advKey_2_rcd[advkey];
        }
        getAdvKeysByTemplateId(tid) {
            return this.tid_2_advKeyArray[tid];
        }
        getAdvSlotByAdvId(advId) {
            return this.advId_2_advSlot[advId];
        }
        getAdvObjPreloadStateByAdvKey(advKey) {
            let objectBase = this.advKey_2_advObject[advKey];
            if (objectBase) {
                return objectBase.preLoadState;
            }
            return ULConst.ADV_PRELOAD_STATE_NOAD;
        }
        getRewardTypeByTemplateId(tid) {
            let ulAdvTemplate = this.templateId_2_advTemplate[tid];
            if (!ulAdvTemplate) {
                return rewardType.show;
            }
            return ulAdvTemplate.rewardType;
        }
        getAdvTypeDailyLimit(advType) {
            let config = ULConfig.getConfig();
            let dailyLimit = 0;
            switch (advType) {
                case "interstitial":
                    dailyLimit = config.i_sdk_adv_type_interstitial_daily_limit;
                    break;
                case "banner":
                    dailyLimit = config.i_sdk_adv_type_banner_daily_limit;
                    break;
                case "embedded":
                    dailyLimit = config.i_sdk_adv_type_embedded_daily_limit;
                    break;
                case "video":
                    dailyLimit = config.i_sdk_adv_type_video_daily_limit;
                    break;
                case "url":
                    dailyLimit = config.i_sdk_adv_type_url_daily_limit;
                    break;
                case "paster":
                    dailyLimit = config.i_sdk_adv_type_paster_daily_limit;
                    break;
            }
            if (dailyLimit == null)
                return 0;
            if (isNaN(dailyLimit))
                return 0;
            return dailyLimit;
        }
        getAdvTypeCd(advType) {
            let config = ULConfig.getConfig();
            let cd = 0;
            switch (advType) {
                case typeExp.inter:
                    cd = config.i_sdk_adv_type_interstitial_cd;
                    break;
                case typeExp.banner:
                    cd = config.i_sdk_adv_type_banner_cd;
                    break;
                case typeExp.embed:
                    cd = config.i_sdk_adv_type_embedded_cd;
                    break;
                case typeExp.video:
                    cd = config.i_sdk_adv_type_video_cd;
                    break;
                case typeExp.url:
                    cd = config.i_sdk_adv_type_url_cd;
                    break;
                case typeExp.paster:
                    cd = config.i_sdk_adv_type_paster_cd;
                    break;
            }
            if (cd == null)
                return 0;
            if (isNaN(cd))
                return 0;
            return cd;
        }
        getLaunchCdByType(advType) {
            let config = ULConfig.getConfig();
            let cd = 0;
            switch (advType) {
                case typeExp.inter:
                    cd = config.i_sdk_adv_inter_launch_cd;
                    break;
                case typeExp.banner:
                    cd = config.i_sdk_adv_banner_launch_cd;
                    break;
                case typeExp.embed:
                    cd = config.i_sdk_adv_embed_launch_cd;
                    break;
                case typeExp.video:
                    cd = config.i_sdk_adv_video_launch_cd;
                    break;
                case typeExp.url:
                    cd = config.i_sdk_adv_url_launch_cd;
                    break;
                case typeExp.paster:
                    cd = config.i_sdk_adv_paster_launch_cd;
                    break;
                case typeExp.custom:
                    cd = config.i_sdk_adv_custom_launch_cd;
                    break;
            }
            if (cd == null)
                return 0;
            if (isNaN(cd))
                return 0;
            return cd;
        }
        get sdkInitTime() {
            return this._sdkInitTime;
        }
        getAdvTypeLastTriggerTimeLog() {
            return this.advTypeLastTriggerTimeLog;
        }
        getAdvTypeDailyCountLog() {
            return this.advTypeDailyCountLog;
        }
        getAdvObjectOpeningByAdvType(type) {
            for (let key in this.advType_2_advObjectArray) {
                if (type !== key) {
                    continue;
                }
                let objectBases = this.advType_2_advObjectArray[key];
                for (let objectBase of objectBases) {
                    if (objectBase.isOpened) {
                        return objectBase;
                    }
                }
            }
            return null;
        }
        getNewAdvTypeByOld(oldType) {
            let type = "";
            if (!oldType) {
                return type;
            }
            type = oldType;
            if (oldTypeExp.embedded == oldType) {
                type = typeExp.embed;
            }
            else if (oldTypeExp.interstitial == oldType) {
                type = typeExp.inter;
            }
            else if (oldTypeExp.fullscreen == oldType) {
                type = typeExp.interVideo;
            }
            return type;
        }
        geOldAdvTypeByNew(newType) {
            let type = "";
            if (!newType) {
                return type;
            }
            type = newType;
            if (typeExp.embed == newType) {
                type = oldTypeExp.embedded;
            }
            else if (typeExp.inter == newType) {
                type = oldTypeExp.interstitial;
            }
            else if (typeExp.interVideo == newType) {
                type = oldTypeExp.fullscreen;
            }
            return type;
        }
        onCmdGetAdvState(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let userData = data['userData'] || "";
            let advIds = data['advIds'] || [];
            let advIdPreLoadState = {};
            for (const advId of advIds) {
                let ulAdvSlot = this.advId_2_advSlot[advId];
                if (!ulAdvSlot) {
                    advIdPreLoadState[advId] = ULConst.ADV_PRELOAD_STATE_NOAD;
                    continue;
                }
                advIdPreLoadState[advId] = ulAdvSlot.preLoadState;
            }
            this.getAdvStateResult(advIdPreLoadState, userData);
        }
        onCmdOpenAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let config = ULConfig.getConfig();
            this.advRequestSerialNum++;
            let advId = data["advId"] || "";
            let userData = data.userData || "";
            let tag = data.tag || "";
            let advType = this.searchAdvTypeByAdvId(advId);
            let advGroupId = this.searchAdvGroupIdByAdvId(advId);
            let advItem = new ULAdvItem(advId, userData, tag);
            advItem.advType = advType;
            advItem.advGroupId = advGroupId;
            ULSdkManager.getInstance().statisManager.reportAdvTotalRequest(advItem);
            let all_ad_ecd = config.i_sdk_adv_all_launch_cd;
            if (ULTools.time() - this.sdkInitTime < all_ad_ecd / 1000) {
                ULLog.console.log("ULAdvManager-onCmdOpenAdv:广告处于启动请求cd中");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: "in all adv launch cd" });
                return;
            }
            let advSolt = this.advId_2_advSlot[advId];
            if (!advSolt) {
                console.warn("ULAdvManager-onCmdOpenAdv:广告位[" + advId + "]对应的advSlot不存在");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位${advId}对应的advSlot不存在` });
                return;
            }
            let openingInfo = advSolt.openingInfo;
            if (openingInfo) {
                console.warn("ULAdvManager-onCmdOpenAdv:广告位[" + advId + "]已有广告请求中或正在展示");
                this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位${advId}已有广告请求中或正在展示` });
                return;
            }
            let rcd = advSolt.rcd;
            ULLog.console.log("ULAdvManager-onCmdOpenAdv-rcd:", rcd);
            let lastRequestTime = this.advId_2_lastRequestTime[advId];
            let nowTime = (new Date()).valueOf();
            if (lastRequestTime) {
                if ((nowTime - lastRequestTime) < rcd) {
                    console.warn("ULAdvManager-onCmdOpenAdv:广告位[" + advId + "]in cd");
                    this.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, { code: "", msg: `广告位[${advId}]in cd` });
                    return;
                }
                else {
                    this.advId_2_lastRequestTime[advId] = nowTime;
                }
            }
            else {
                this.advId_2_lastRequestTime[advId] = nowTime;
            }
            advSolt.openAdv(this.advRequestSerialNum, data);
        }
        onCmdCloseAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advSlot未找到!");
                return;
            }
            if (!advSlot.openingInfo) {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "advSlot没有广告执行!");
                return;
            }
            let objectBase = this.getAdvObjectByAdvKey(advSlot.openingInfo.advTemplateItemName);
            if (objectBase) {
                if (objectBase instanceof ULAdvNativeObjectBase) {
                    advSlot.closeAdv(data);
                    this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "close adv success");
                }
                else {
                    advSlot.closeAdv(data);
                }
            }
            else {
                this.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad open!");
            }
        }
        onCmdCloseAllAdvByType(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let type = data.type || "";
            let advIds = this.type_2_advIds[type];
            if (advIds == null || advIds.length == 0) {
                this.responseCloseAllAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad show");
                return;
            }
            for (let advId of advIds) {
                let advSlot = this.advId_2_advSlot[advId];
                if (advSlot == null || advSlot.openingInfo == null) {
                    continue;
                }
                let objectBase = this.getAdvObjectByAdvKey(advSlot.openingInfo.advTemplateItemName);
                if (objectBase != null) {
                    data["advId"] = advId;
                    if (objectBase instanceof ULAdvNativeObjectBase) {
                        objectBase.closeNativeAdv(data);
                    }
                    else {
                        advSlot.closeAdv(data);
                    }
                }
            }
            this.responseCloseAllAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "关闭成功");
        }
        onCmdCloseNativeAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no advSlot");
                return;
            }
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CLOSE_NATIVE_ADV, data);
            this.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "关闭成功");
        }
        onCmdClickNativeAdv(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let advId = data.advId;
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", "109", advId || '', ""]);
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot) {
                this.responseClickNativeAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no advSlot");
                return;
            }
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CLICK_NATIVE_ADV, data);
            ULSdkManager.getInstance().advManager.responseClickNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, "点击成功");
        }
        responseOpenAdvResult(data, code, info) {
            let returnData = {};
            returnData["code"] = code;
            returnData["msg"] = ULAdvTrimErrorManager.trimErrMessage(info.msg, info.code ? info : null);
            returnData["advId"] = data.advId || "";
            returnData["userData"] = data.userData || "";
            returnData["tag"] = data.tag || "";
            if (code == 1) {
                returnData["type"] = data.type || "";
                returnData["rewardType"] = data.rewardType || "";
                this.advTypeLastTriggerTimeLog[data.type] = ULTools.time();
                this.advTypeDailyCountLog[data.type] = (this.advTypeDailyCountLog[data.type] || 0) + 1;
                this.saveRecord();
                let actualShowCount = data["actualShowCount"];
                returnData["actualShowCount"] = isNaN(actualShowCount) ? 1 : actualShowCount;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_OPEN_ADV_RESULT, returnData);
        }
        responseRewardAdvResult(data, code, msg) {
            let returnData = {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            };
            if (code == 1) {
                let actualShowCount = data["actualShowCount"];
                returnData["actualShowCount"] = isNaN(actualShowCount) ? 1 : actualShowCount;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_REWARD_ADV_RESULT, returnData);
        }
        responseClickAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLICK_ADV_RESULT, {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            });
        }
        responseOpenNativeAdvResult(showData, nativeType, code, msg, nativeData) {
            let returnData = {};
            returnData["code"] = code;
            returnData["msg"] = msg;
            returnData["advId"] = showData.advId || "";
            returnData["userData"] = showData.userData || "";
            returnData["tag"] = showData.tag || "";
            returnData["nativeType"] = nativeType || "";
            returnData["nativeData"] = nativeData || {};
            if (code == 1) {
                returnData["type"] = showData.type || "";
                returnData["rewardType"] = showData.rewardType || "";
            }
            ULSdkManager.getInstance().response(ULConst.CMD_OPEN_NATIVE_ADV_RESULT, returnData);
        }
        responseClickNativeAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLICK_NATIVE_ADV_RESULT, {
                code: code,
                msg: msg,
                nativeType: data.nativeType || "",
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            });
        }
        responseCloseNativeAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_NATIVE_ADV_RESULT, {
                code: code,
                msg: msg,
                nativeType: data.nativeType || "",
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            });
        }
        responseCloseAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_ADV_RESULT, {
                code: code,
                msg: msg,
                advId: data.advId || "",
                userData: data.userData || "",
                tag: data.tag || ""
            });
        }
        responseCloseAllAdvResult(data, code, msg) {
            ULSdkManager.getInstance().response(ULConst.CMD_CLOSE_ALL_ADV_BY_TYPE_RESULT, {
                code: code,
                msg: msg,
                type: data.type || "",
                userData: data.userData || ""
            });
        }
        pauseSound() {
            ULSdkManager.getInstance().response(ULConst.CMD_PAUSE_SOUND_RESULT, {});
        }
        resumeSound() {
            ULSdkManager.getInstance().response(ULConst.CMD_RESUME_SOUND_RESULT, {});
        }
        getAdvStateResult(data, userData) {
            ULSdkManager.getInstance().response(ULConst.CMD_GET_ADV_STATE_RESULT, {
                states: data,
                userData: userData,
            });
        }
        onAdvObjectLifeCycleShowRequest(advKey, data) {
            this.addAdvCountLog(advKey, countExp.rc);
            let advId = data.advId || "";
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                ULSdkManager.getInstance().statisManager.reportAdvBranchRequest(advItem, advertiser, arg);
            }
        }
        onAdvObjectLifeCycleSkip(advKey, info, data) {
            let advId = data["advId"] || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleSkip(data, info);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleShow(advKey, msg, data, nativeData) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleShow(msg, data);
            this.addAdvCountLog(advKey, countExp.sc);
            this.reportVideoPlayCompletion(advKey, data, nativeData);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.banner == advType) {
                    this.bannerStartShowTime = ULTools.time();
                }
                let title = nativeData ? nativeData.title : "";
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = title;
                advItem.statisSdkAdvId = arg;
                let actualShowCount = data["actualShowCount"];
                ULSdkManager.getInstance().statisManager.reportAdvSuccess(advItem, title, isNaN(actualShowCount) ? 1 : actualShowCount);
            }
        }
        onAdvObjectLifeCycleClick(advKey, msg, data, nativeData) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleClick(msg, data);
            this.addAdvCountLog(advKey, countExp.cc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let title = nativeData ? nativeData.title : "";
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = title;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvClicked(advItem);
            }
        }
        onAdvObjectLifeCycleClose(advKey, data, nativeData) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            this.reportBannerShowTime(advKey, data, nativeData);
            this.reportVideoPlayStart(advKey, data, nativeData);
            advSlot.onAdvObjectLifeCycleClose();
            this.responseCloseAdvResult(data, 1, "success");
        }
        onAdvTimeout(advItem, msg) {
        }
        reportBannerShowTime(advKey, data, nativeData) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.banner == advType) {
                    let bannerShowDuration = Math.floor(ULTools.time() - this.bannerStartShowTime);
                    if (bannerShowDuration <= 0) {
                        return;
                    }
                    let bannerShowTime = String(bannerShowDuration);
                    let advId = data.advId || "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = nativeData ? nativeData.title : "";
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvClose(advItem, bannerShowTime);
                }
            }
        }
        reportVideoPlayStart(advKey, data, nativeData) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.video == advType) {
                    let title = nativeData ? nativeData.title : "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = title;
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvPlayStart(advItem);
                }
            }
        }
        reportVideoPlayCompletion(advKey, data, nativeData) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                if (typeExp.video == advType) {
                    let title = nativeData ? nativeData.title : "";
                    let userData = data.userData || "";
                    let tag = data.tag || "";
                    let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                    let advItem = new ULAdvItem(advId, userData, tag);
                    advItem.showAdvType = advType;
                    advItem.advGroupId = advGroupId;
                    advItem.statisChannelName = advertiser;
                    advItem.statisNativeAdTitle = title;
                    advItem.statisSdkAdvId = arg;
                    ULSdkManager.getInstance().statisManager.reportAdvPlayCompletion(advItem);
                }
            }
        }
        onAdvObjectLifeCycleRequest(advKey) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && !objectBase.isReportLoading) {
                objectBase.isReportLoading = true;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = "";
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvRequest(advItem);
            }
        }
        onAdvObjectLifeCycleRequestSuccess(advKey) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && objectBase.isReportLoading) {
                objectBase.isReportLoading = false;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisNativeAdTitle = "";
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvSuccess(advItem);
            }
        }
        onAdvObjectLifeCycleRequestFailed(advKey, info) {
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase != null && objectBase.isReportLoading) {
                objectBase.isReportLoading = false;
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType != null && statisticsType != "") {
                    advType = statisticsType;
                }
                let advId = "";
                let userData = "";
                let tag = "";
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = "";
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvLoadAdvFailed(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleFail(advKey, info, data) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            advSlot.onAdvObjectLifeCycleFail(info, data);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        onAdvObjectLifeCycleReuse(advKey, info, data) {
            let advId = data.advId || "";
            let advSlot = this.advId_2_advSlot[advId];
            if (!advSlot)
                return;
            ULSdkManager.getInstance().advManager.responseOpenAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, info);
            this.addAdvCountLog(advKey, countExp.fc);
            let objectBase = this.getAdvObjectByAdvKey(advKey);
            if (objectBase) {
                let advType = objectBase.advType;
                let arg = objectBase.arg;
                let advertiser = objectBase.statisticsAdvertiser;
                let statisticsType = objectBase.statisticsType;
                if (statisticsType && statisticsType != "") {
                    advType = statisticsType;
                }
                let userData = data.userData || "";
                let tag = data.tag || "";
                let advGroupId = this.searchAdvGroupIdByAdvId(advId);
                let advItem = new ULAdvItem(advId, userData, tag);
                advItem.showAdvType = advType;
                advItem.advGroupId = advGroupId;
                advItem.statisChannelName = advertiser;
                advItem.statisSdkAdvId = arg;
                ULSdkManager.getInstance().statisManager.reportAdvFail(advItem, "errCode=" + info.code + ";errMsg=" + info.msg);
            }
        }
        addAdvFailCount(advKey) {
            this.addAdvCountLog(advKey, countExp.fc);
        }
        addAdvCountLog(advKey, countExp) {
            let tidArray = this.advKey_2_templateIdArray[advKey];
            if (tidArray && tidArray.length > 0) {
                for (const tid of tidArray) {
                    let key = ULConst.EXP_ADV_TEMPLATE_CONST + tid + ULConst.EXP_ADV_POINT_CONST + countExp;
                    this.updateAdvCountStoreNum(key);
                    this.advSlotRefreshValidAdvKeys(advKey);
                }
            }
            let objectBase = this.advKey_2_advObject[advKey];
            if (objectBase) {
                let advType = objectBase.advType;
                let key = ULConst.EXP_ADV_TYPE_CONST + advType + ULConst.EXP_ADV_POINT_CONST + countExp;
                this.updateAdvCountStoreNum(key);
                this.advSlotRefreshValidAdvKeys(advKey);
            }
        }
        updateAdvCountStoreNum(key) {
            ULAdvExpManager.updateExpValue(dataExp.d + key);
            ULAdvExpManager.updateExpValue(dataExp.w + key);
            ULAdvExpManager.updateExpValue(dataExp.m + key);
            ULAdvExpManager.updateExpValue(dataExp.y + key);
        }
        advSlotRefreshValidAdvKeys(advKey) {
            let advIdArray = this.advKey_2_advIdArray[advKey];
            if (advIdArray) {
                for (const advId of advIdArray) {
                    let ulAdvSlot = this.advId_2_advSlot[advId];
                    if (ulAdvSlot) {
                        ulAdvSlot.refreshValidAdvKeys();
                    }
                }
            }
        }
    }
    ULAdvManager.instance = null;

    let qg$2 = window["qg"];
    class ULAdvOppoQgVideo extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.video, ULTools.format("%s%s%s", "ULAdvOppoQgVideo", "_", arg));
            this.className = "ULAdvOppoQgVideo";
            this.videoAd = null;
            this.statisticsAdvertiser = ULAdvOppoQg.NORMAL_ADVERTISER;
            this.setSupportLoadType = [ULConst.ADV_LOAD_TYPE_PRELOAD, ULConst.ADV_LOAD_TYPE_UNPRELOAD];
            this.setLoadType = ULConst.ADV_LOAD_TYPE_PRELOAD;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgVideo-onDisposeModule arg:", this.arg);
            if (this.videoAd) {
                this.videoAd.offClose();
                this.videoAd.offLoad();
                this.videoAd.offError();
                this.videoAd.destroy();
                this.videoAd = null;
            }
        }
        initAdv() {
            let platformVersionCode = qg$2.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1051) {
                ULLog.console.log("ULAdvOppoQgVideo-initAdv-最低平台版本支持1051，直接跳过");
                return;
            }
            let loadType = this.getLoadType;
            if (loadType == undefined || this.getSupportLoadType.indexOf(loadType) == -1) {
                ULLog.console.log(`ULAdvOppoQgVideo-initAdv-当前加载类型${loadType}模块不支持`);
                loadType = ULConst.ADV_LOAD_TYPE_PRELOAD;
            }
            this.mLoadType = loadType;
            if (!this.videoAd) {
                this.videoAd = qg$2.createRewardedVideoAd({
                    adUnitId: this.arg
                });
            }
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.videoAd.onLoad(() => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onLoad");
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                    this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
                });
                this.videoAd.onClose((res) => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onClose.res:", res);
                    this.isOpened = false;
                    if (res.isEnded) {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_video_success_show_event_id]);
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleFail(this.advKey, { code: "", msg: ULConst.ADV_VIDEO_PLAY_FAIL_MSG }, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_close_video_event_id]);
                    }
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                    this.preLoadAdv();
                });
                this.videoAd.onError((err) => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onError", err);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                    this.onLoadFailErr = { code: String(err.errCode), msg: err.errMsg };
                    if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_READY) {
                        this.isOpened = false;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    }
                    else {
                        ULSdkManager.getInstance().advManager.addAdvFailCount(this.advKey);
                    }
                    this.reLoadAdv();
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_open_video_event_id, "2"]);
                });
                this.preLoadAdv();
            }
            else {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            }
        }
        loadAdv() {
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.preLoadState = ULConst.ADV_PRELOAD_STATE_LOADING;
                this.videoAd.load();
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            }
            else {
            }
        }
        showAdv(data) {
            if (!this.videoAd) {
                console.warn("ULAdvOppoQgVideo-showAdv:广告未初始化,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv not init" });
                return;
            }
            if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_LOADING) {
                console.warn("ULAdvOppoQgVideo-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv is loading" });
                return;
            }
            if (this.preLoadState == ULConst.ADV_PRELOAD_STATE_NOAD) {
                console.warn("ULAdvOppoQgVideo-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, this.onLoadFailErr);
                return;
            }
            this.showData = data;
            this.isOpened = true;
            if (this.mLoadType == ULConst.ADV_LOAD_TYPE_PRELOAD) {
                this.videoAd.show();
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_open_video_event_id, "1"]);
            }
            else {
                this.videoAd.offLoad();
                this.videoAd.offClose();
                this.videoAd.offError();
                this.videoAd.onLoad(() => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onLoad");
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                    this.videoAd.show();
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_open_video_event_id, "1"]);
                });
                this.videoAd.onClose((res) => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onClose.res:", res);
                    this.isOpened = false;
                    if (res.isEnded) {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_video_success_show_event_id]);
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleFail(this.advKey, { code: "", msg: ULConst.ADV_VIDEO_PLAY_FAIL_MSG }, this.showData);
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_close_video_event_id]);
                    }
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                });
                this.videoAd.onError((err) => {
                    ULLog.console.log("ULAdvOppoQgVideo videoAd.onError", err);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                    this.isOpened = false;
                    this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_CHANNEL_MEGADATA_POST, [ULConfig.getConfig().s_sdk_miniplay_user_open_video_event_id, "2"]);
                });
                this.videoAd.load();
            }
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgVideo-receiveInitState:初始化失败");
            }
        }
    }

    let qg$3 = window["qg"];
    class ULAdvOppoQgBannerBox extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, ULTools.format("%s%s%s", "ULAdvOppoQgBannerBox", "_", arg));
            this.className = "ULAdvOppoQgBannerBox";
            this.statisticsAdvertiser = "ULAdvOppoQgBannerBox";
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgBannerBox-onDisposeModule arg:", this.arg);
            if (this.gameBannerAd) {
                this.gameBannerAd.destroy();
                this.gameBannerAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgBannerBox-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
        }
        showAdv(data) {
            if (qg$3.getSystemInfoSync().platformVersionCode < 1090) {
                ULLog.console.log('ULAdvOppoQgBannerBox-showAdv:快应用平台版本号低于1090，暂不支持互推盒子相关 API');
                this.advSkip(data, { code: "", msg: "api unsupport" });
                return;
            }
            let tag = data["tag"] || data["advId"] || "";
            let advSetting = ULConfig.getConfig().t_sdk_oppoqg_show_banner_box_adv_tags;
            let styleObj = advSetting[tag];
            if (!styleObj) {
                ULLog.console.log("ULAdvOppoQgBannerBox-showAdv:当前广告位不允许展示横幅的盒子");
                this.advSkip(data, { code: "", msg: `advId [${tag}] unsupport banner box` });
                return;
            }
            this.showData = data;
            this.isOpened = true;
            if (this.gameBannerAd) {
                this.gameBannerAd.destroy();
                this.gameBannerAd = null;
            }
            let sys = qg$3.getSystemInfoSync();
            let screenWidth = sys.screenWidth;
            let screenHeight = sys.screenHeight;
            let style = {};
            if (!isNaN(Number(styleObj.left))) {
                style["left"] = Number(styleObj.left) * screenWidth;
            }
            if (!isNaN(Number(styleObj.top))) {
                style["top"] = Number(styleObj.top) * screenHeight;
            }
            if (!isNaN(Number(styleObj.orientation))) {
                if (Number(styleObj.orientation) == 0) {
                    style["orientation"] = "horizontal";
                }
                else {
                    style["orientation"] = "vertical";
                }
            }
            this.gameBannerAd = qg$3.createGameBannerAd({
                adUnitId: this.arg,
                style: style
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.gameBannerAd.show().then(() => {
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
            }).catch((error) => {
                ULLog.console.log("ULAdvOppoQgBannerBox-showAdv-show-catch:", error);
                this.isOpened = false;
                this.advSkip(this.showData, { code: String(error.errCode), msg: error.errMsg });
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(error.errCode), msg: error.errMsg });
            });
        }
        closeAdv(data) {
            if (this.isOpened) {
                this.gameBannerAd.hide().then(() => {
                    this.isOpened = false;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
                    ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
                }).catch((error) => {
                    ULLog.console.log("ULAdvOppoQgBannerBox-closeAdv-hide-catch:", error);
                    ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, error.errCode + ',' + error.errMsg);
                });
            }
            else {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad show");
            }
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgBannerBox-receiveInitState:初始化失败");
            }
        }
    }

    let qg$4 = window["qg"];
    class ULAdvOppoQgPortalBox extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, ULTools.format("%s%s%s", "ULAdvOppoQgPortalBox", "_", arg));
            this.className = "ULAdvOppoQgPortalBox";
            this.showPortalGameBoxTags = {};
            this.isCall = false;
            this.statisticsAdvertiser = "ULAdvOppoQgPortalBox";
            this.statisticsType = oldTypeExp.interstitial;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgPortalBox-onDisposeModule arg:", this.arg);
            if (this.gamePortalAd) {
                this.gamePortalAd.offClose();
                this.gamePortalAd.offLoad();
                this.gamePortalAd.offError();
                this.gamePortalAd.destroy();
                this.gamePortalAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgPortalBox-initAdv");
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_JUMP_LEISURE_SUBJECT, 1, this.onCmdJumpLeisureSubject.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_COP_CHANGED, ULConst.PRIORITY_NONE, this.onCmdFromCopChange.bind(this));
            this.trimSetting();
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        onCmdFromCopChange(e) {
            this.trimSetting();
        }
        trimSetting() {
            let config = ULConfig.getConfig();
            let interTags = config.t_sdk_oppoqg_show_inter_box_adv_tags || [];
            for (let index = 0; index < interTags.length; index++) {
                let tag = interTags[index];
                this.showPortalGameBoxTags[tag] = true;
            }
            ULLog.console.log("ULAdvOppoQgPortalBox.init showPortalGameBoxTags:", this.showPortalGameBoxTags);
        }
        onCmdJumpLeisureSubject(e) {
            e.stopImmediatePropagation();
            ULLog.console.log("ULAdvOppoQgPortalBox.onCmdJumpLeisureSubject................");
            let data = e.data;
            let advId = "jumpLeisureSubjectAdvId";
            let userData = data.userData || "";
            let tag = "jumpLeisureSubjectTag";
            if (!this.showPortalGameBoxTags[tag]) {
                this.showPortalGameBoxTags[tag] = true;
            }
            this.isCall = true;
            this.showPortalAd((state) => {
                this.isCall = false;
                if (state) {
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_LEISURE_SUBJECT_RESULT, {
                        code: 1,
                        msg: "打开盒子广告成功",
                        userData: userData,
                    });
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_LEISURE_SUBJECT_RESULT, {
                        code: 0,
                        msg: "打开盒子广告失败",
                        userData: userData,
                    });
                }
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                console.warn("ULAdvOppoQgPortalBox-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let tag = data["tag"] || "";
            if (!this.showPortalGameBoxTags[tag]) {
                ULLog.console.log("ULAdvOppoQgPortalBox-showAdv:当前广告位不允许展示盒子");
                this.advSkip(data, { code: "", msg: `advId [${tag}] unsupport box` });
                return;
            }
            this.showData = data;
            this.isOpened = true;
            this.showPortalAd();
        }
        showPortalAd(callback) {
            if (qg$4.getSystemInfoSync().platformVersionCode < 1076) {
                ULLog.console.log('ULAdvOppoQgPortalBox-showAdv:快应用平台版本号低于1076，暂不支持互推盒子相关 API');
                if (callback) {
                    callback(false);
                }
                else {
                    this.advSkip(this.showData, { code: "", msg: "api unsupport" });
                }
                return;
            }
            if (!this.gamePortalAd) {
                this.gamePortalAd = qg$4.createGamePortalAd({
                    adUnitId: this.arg
                });
                if (!this.gamePortalAd) {
                    ULLog.console.log('ULAdvOppoQgPortalBox-showAdv:广告对象创建失败，请检查参数配置');
                    if (callback) {
                        callback(false);
                    }
                    else {
                        this.advSkip(this.showData, { code: "", msg: "obj create fail" });
                    }
                    return;
                }
                this.gamePortalAd.offLoad(() => {
                    ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-offLoad");
                });
                this.gamePortalAd.offError(() => {
                    ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-offError");
                });
                this.gamePortalAd.onLoad(() => {
                    ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-onLoad");
                });
                this.gamePortalAd.onClose(() => {
                    ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-onClose");
                    if (!this.isCall) {
                        this.isOpened = false;
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
                    }
                });
                this.gamePortalAd.onError((err) => {
                    ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-onError:", err);
                    if (!this.isCall) {
                        this.isOpened = false;
                        let errMsg = err.errCode + ',' + err.errMsg;
                        this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                    }
                });
            }
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.gamePortalAd.load().then(() => {
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                this.gamePortalAd.show().then(() => {
                    if (callback) {
                        callback(true);
                    }
                    else {
                        ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                    }
                }).catch((error) => {
                    if (callback) {
                        callback(false);
                    }
                    else {
                        this.isOpened = false;
                        let errMsg = error.errCode + ',' + error.errMsg;
                        this.advSkip(this.showData, { code: String(error.errCode), msg: error.errMsg });
                    }
                });
            }).catch((error) => {
                ULLog.console.log("ULAdvOppoQgPortalBox-showAdv-load-catch:", error);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(error.errCode), msg: error.errMsg });
                if (callback) {
                    callback(false);
                }
                else {
                    this.isOpened = false;
                    let errMsg = error.errCode + ',' + error.errMsg;
                    this.advSkip(this.showData, { code: String(error.errCode), msg: error.errMsg });
                }
            });
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgBannerBox-receiveInitState:初始化失败");
            }
        }
    }

    let qg$5 = window["qg"];
    class ULAdvOppoQgInter extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, ULTools.format("%s%s%s", "ULAdvOppoQgInter", "_", arg));
            this.className = "ULAdvOppoQgInter";
            this.statisticsAdvertiser = ULAdvOppoQg.NORMAL_ADVERTISER;
            this.statisticsType = oldTypeExp.interstitial;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgInter-onDisposeModule arg:", this.arg);
            if (this.interstitialAd) {
                this.interstitialAd.offLoad();
                this.interstitialAd.offClose();
                this.interstitialAd.offError();
                this.interstitialAd.destroy();
                this.interstitialAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgInter-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
        }
        showAdv(data) {
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                console.warn("ULAdvOppoQgInter-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = data;
            this.isOpened = true;
            if (!this.interstitialAd) {
                this.interstitialAd = qg$5.createInsertAd({
                    posId: this.arg
                });
            }
            if (!this.interstitialAd) {
                ULLog.console.log("ULAdvOppoQgInter-showAdv:广告对象创建异常，请检查参数是否正确：", this.arg);
                this.advSkip(data, { code: "", msg: "param error" });
                return;
            }
            this.interstitialAd.offLoad();
            this.interstitialAd.offClose();
            this.interstitialAd.offError();
            this.interstitialAd.onLoad(() => {
                ULLog.console.log("ULAdvOppoQgInter-showAdv-onLoad");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                this.interstitialAd.show();
            });
            this.interstitialAd.onShow(() => {
                ULLog.console.log("ULAdvOppoQgInter-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
            });
            this.interstitialAd.onClose(() => {
                ULLog.console.log("ULAdvOppoQgInter-showAdv-onClose");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
            });
            this.interstitialAd.onError((err) => {
                ULLog.console.log("ULAdvOppoQgInter-showAdv-onError:", err);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                this.isOpened = false;
                this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
            });
            this.interstitialAd.load();
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
        }
        closeAdv(data) {
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgInter-receiveInitState:初始化失败");
            }
        }
    }

    let qg$6 = window["qg"];
    class ULAdvOppoQgBanner extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvOppoQgBanner" + "_" + arg);
            this.className = "ULAdvOppoQgBanner";
            this.isCallHide = false;
            this.channelBannerStyle = {};
            this.statisticsAdvertiser = ULAdvOppoQg.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgBanner-onDisposeModule arg:", this.arg);
            if (this.bannerAd) {
                this.bannerAd.offHide();
                this.bannerAd.offLoad();
                this.bannerAd.offError();
                this.bannerAd.offResize();
                this.bannerAd.destroy();
                this.bannerAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.channelBannerStyle = ULConfig.getConfig().t_sdk_adv_banner_tags_style_setting || {};
        }
        loadAdv() {
        }
        showAdv(data) {
            let platformVersionCode = qg$6.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1051) {
                console.warn("ULAdvOppoQgBanner-showAdv:原生api最低支持1051");
                this.advSkip(data, { code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let ad_limitTime = ULConfig.getConfig().i_sdk_oppoqg_ad_ecd;
            let requestTime = ULTools.time();
            if (requestTime - ULSdkManager.getInstance().advManager.sdkInitTime < ad_limitTime / 1000) {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv:未达到启动cd限制，无法展示广告");
                this.advSkip(data, { code: "", msg: "in start cd" });
                return;
            }
            this.isOpened = true;
            this.showData = data;
            this.bAutoCloseBannerFlag = false;
            let tag = data["tag"] || "";
            let style = data.layout || this.channelBannerStyle[tag] || this.channelBannerStyle["*"] || {};
            let systemInfo = qg$6.getSystemInfoSync();
            let windowWidth = systemInfo.windowWidth;
            let windowHeight = systemInfo.windowHeight;
            if (!this.bannerAd) {
                this.bannerAd = qg$6.createBannerAd({
                    adUnitId: this.arg,
                });
                let bannerWidth = Math.min(systemInfo.screenWidth, systemInfo.screenHeight);
                if (style) {
                    ULLog.console.log('ULAdvOppoQgBanner-showAdv systemInfo:', JSON.stringify(systemInfo));
                    let widthScale = style.width;
                    if (widthScale != undefined && widthScale >= 0) {
                        bannerWidth = bannerWidth * widthScale;
                    }
                }
                this.bannerAd.style.width = bannerWidth;
            }
            if (!this.bannerAd) {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv:广告对象创建异常，请检查参数是否正确：", this.arg);
                this.advSkip(data, { code: "", msg: "param error" });
                return;
            }
            this.bannerAd.offLoad(() => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-offLoad");
            });
            this.bannerAd.offError(() => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-offError");
            });
            this.bannerAd.offHide();
            this.bannerAd.offResize(() => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-offResize");
            });
            let isPlay = false;
            this.bannerAd.onLoad(() => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-onLoad");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                if (!isPlay && this.isOpened) {
                    isPlay = true;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
                }
            });
            this.bannerAd.onHide(() => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-onHide");
                if (!this.bAutoCloseBannerFlag) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, this.showData);
            });
            this.bannerAd.onError((err) => {
                ULLog.console.log("ULAdvOppoQgBanner-showAdv-onError:", err);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(err.errCode), msg: err.errMsg });
                if (!this.isOpened && !this.isCallHide) {
                    this.advSkip(this.showData, { code: String(err.errCode), msg: err.errMsg });
                }
            });
            this.bannerAd.onResize(function (e) {
                ULLog.console.log('ULAdvOppoQgBanner-showAdv-onResize： ' + JSON.stringify(e));
                let left = (systemInfo.screenWidth - e.width) * 0.5;
                let top = systemInfo.screenHeight - e.height + 0.1;
                if (style) {
                    let x = style.x;
                    let y = style.y;
                    if (x != undefined && x >= 0 && x <= 1) {
                        left = (systemInfo.screenWidth - e.width) * x;
                        console.log("ULAdvOppoQgBanner.setBannerStyle bannerAd.onResize.newLeft", left);
                    }
                    if (y != undefined && y >= 0 && y <= 1) {
                        top = (1 - y) * (systemInfo.screenHeight - e.height);
                        console.log("ULAdvOppoQgBanner.setBannerStyle bannerAd.onResize.newTop", top);
                    }
                }
                this.bannerAd.style.left = left;
                this.bannerAd.style.top = top;
            });
            this.isCallHide = false;
            this.bannerAd.show();
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
        }
        closeAdv(data) {
            this.isOpened = false;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
            if (this.bannerAd) {
                if (ULConfig.getConfig().i_sdk_oppoqg_banner_mode == 1) {
                    ULLog.console.log("ULAdvOppoQgBanner.closeAdv banner.hide()");
                    this.bAutoCloseBannerFlag = true;
                    this.isCallHide = true;
                    this.bannerAd.hide();
                }
                else {
                    ULLog.console.log("ULAdvOppoQgBanner.closeAdv banner.destroy()");
                    this.bannerAd.destroy();
                    this.bannerAd = null;
                }
            }
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgBanner-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvNativeAdLoadCycle {
        constructor() {
            this.onLoad = () => {
                ULLog.console.log("ULAdvNativeAdLoadCycle default onLoad");
            };
            this.onLoadFail = (errInfo) => {
                ULLog.console.log("ULAdvNativeAdLoadCycle default onLoadFail");
            };
        }
    }
    class ULAdvNativeAdShowCycle {
        constructor() {
            this.onShow = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onShow");
            };
            this.onShowFail = (errInfo) => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onShowFail");
            };
            this.onRefresh = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onRefresh");
            };
            this.onClose = (isUserClick = true) => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onClose isUserClick:", isUserClick);
            };
            this.onClick = () => {
                ULLog.console.log("ULAdvNativeAdShowCycle default onClick");
            };
        }
    }
    class ULAdvNativeData {
    }

    class ULAdvSDKNativeAd {
        constructor(parma) {
            this.showData = {};
            this.loadCycle = new ULAdvNativeAdLoadCycle();
            this.showCycle = new ULAdvNativeAdShowCycle();
            this.selfShowCycle = {
                onShow: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.closeCall && this.closeCall(this);
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                    this.nativeData = null;
                },
                onClick: () => {
                    if (!this.isShowing)
                        return;
                    this.clickCall && this.clickCall(this);
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            };
            this.loadCall = null;
            this.clickCall = null;
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.type = parma.type;
            this.loadCall = parma.load;
            this.clickCall = parma.click;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        click() {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClick && this.selfShowCycle.onClick();
            if (this.type == ULAdvNativeAdType.inter) {
                this.close(false);
            }
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.loadCall || !this.showCall)
                return;
            this.isShowing = true;
            this.loadCall(this, {
                onLoad: (nativeData) => {
                    this.nativeData = nativeData;
                    this.loadCycle.onLoad && this.loadCycle.onLoad(nativeData);
                    this.showSDKView(data);
                },
                onLoadFail: (errInfo) => {
                    this.loadCycle.onLoadFail && this.loadCycle.onLoadFail(errInfo);
                    this.selfShowCycle.onShowFail(errInfo);
                }
            });
        }
        close(isUserClick) {
            if (!this.isShowing)
                return;
            this.closeSDKAd();
            this.selfShowCycle.onClose(isUserClick);
        }
        destroy() {
            this.isShowing = false;
            this.nativeData = null;
            this.destroyCall && this.destroyCall(this);
            this.loadCall = null;
            this.showCall = null;
            this.clickCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
        refreshData(nativeData) {
            ULLog.console.log("ULAdvSDKNativeAd refreshData nativeData:", nativeData);
            if (this.isShowing) {
                this.nativeData = nativeData;
                this.showSDKView(this.showData, true);
            }
        }
        showSDKView(data, isRefreshing = false) {
            ULLog.console.log("ULAdvSDKNativeAd showSDKView nativeData:", this.nativeData);
            this.closeSDKAd();
            if (this.nativeData == null)
                return;
            this.showData = data;
            let obj = {
                nationData: this.nativeData,
                onShow: isRefreshing ? this.selfShowCycle.onRefresh : this.selfShowCycle.onShow,
                onError: (errMsg) => {
                    if (!isRefreshing) {
                        this.selfShowCycle.onShowFail({ code: "0", msg: errMsg });
                    }
                },
                onClick: this.selfShowCycle.onClick,
                onClose: (isUserClick) => {
                    if (isUserClick) {
                        this.selfShowCycle.onClose(isUserClick);
                    }
                }
            };
            switch (this.type) {
                case ULAdvNativeAdType.banner: {
                    let style = ULAdvNativeManager.getBannerStyle(data);
                    if (style == null) {
                        obj.onError('sdk自动刷新不包含此tag');
                        return;
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showNationBanner(obj, style);
                    break;
                }
                case ULAdvNativeAdType.embedded: {
                    let style = ULAdvNativeManager.getEmbeddStyle(data);
                    ULSdkManager.getInstance().moduleCheckerManager.showNationEmbedded(obj, style);
                    break;
                }
                case ULAdvNativeAdType.inter: {
                    ULSdkManager.getInstance().moduleCheckerManager.showNationInter(obj);
                    break;
                }
            }
        }
        closeSDKAd() {
            switch (this.type) {
                case ULAdvNativeAdType.banner: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationBanner();
                    break;
                }
                case ULAdvNativeAdType.embedded: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationEmbedded();
                    break;
                }
                case ULAdvNativeAdType.inter: {
                    ULSdkManager.getInstance().moduleCheckerManager.closeNationInter();
                    break;
                }
            }
        }
    }

    class ULAdvGameNativeAd {
        constructor(parma) {
            this.loadCycle = new ULAdvNativeAdLoadCycle();
            this.showCycle = new ULAdvNativeAdShowCycle();
            this.selfShowCycle = {
                onShow: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    if (!this.isShowing)
                        return;
                    this.showCall && this.showCall(this);
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    if (!this.isShowing)
                        return;
                    this.isShowing = false;
                    this.closeCall && this.closeCall(this);
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                    this.nativeData = null;
                },
                onClick: () => {
                    if (!this.isShowing)
                        return;
                    this.clickCall && this.clickCall(this);
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            };
            this.loadCall = null;
            this.clickCall = null;
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.type = parma.type;
            this.loadCall = parma.load;
            this.clickCall = parma.click;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        click() {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClick && this.selfShowCycle.onClick();
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.loadCall || !this.showCall)
                return;
            this.isShowing = true;
            this.loadCall(this, {
                onLoad: (nativeData) => {
                    this.nativeData = nativeData;
                    this.loadCycle.onLoad && this.loadCycle.onLoad(nativeData);
                    this.showGameView(data);
                },
                onLoadFail: (errInfo) => {
                    this.loadCycle.onLoadFail && this.loadCycle.onLoadFail(errInfo);
                    this.selfShowCycle.onShowFail(errInfo);
                }
            });
        }
        close(isUserClick) {
            if (!this.isShowing)
                return;
            this.selfShowCycle.onClose(isUserClick);
        }
        destroy() {
            this.isShowing = false;
            this.destroyCall && this.destroyCall(this);
            this.nativeData = null;
            this.loadCall = null;
            this.showCall = null;
            this.clickCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
        showGameView(data) {
            if (!this.isShowing)
                return;
            let advType = this.type.toString();
            ULSdkManager.getInstance().advManager.responseOpenNativeAdvResult(data, advType, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_NATIVE_RESULT_MSG_SUCCESS, this.nativeData);
            this.selfShowCycle.onShow();
        }
    }

    var ULAdvNativeAdType;
    (function (ULAdvNativeAdType) {
        ULAdvNativeAdType["banner"] = "banner";
        ULAdvNativeAdType["inter"] = "inter";
        ULAdvNativeAdType["embedded"] = "embed";
    })(ULAdvNativeAdType || (ULAdvNativeAdType = {}));
    var ULAdvNativeAdShowType;
    (function (ULAdvNativeAdShowType) {
        ULAdvNativeAdShowType[ULAdvNativeAdShowType["game"] = 0] = "game";
        ULAdvNativeAdShowType[ULAdvNativeAdShowType["sdk"] = 1] = "sdk";
    })(ULAdvNativeAdShowType || (ULAdvNativeAdShowType = {}));
    class ULNativeItem {
        constructor(param) {
            this.showGameAdArray = [];
            this.showSdkAdArray = [];
            this.loadCycleList = [];
            this.lastExposureTime = 0;
            this.channelLoadCycle = new ULAdvNativeAdLoadCycle();
            this.arg = param.arg;
            this.channelAd = param.channelAd;
            this.hadClick = false;
            this.hadshown = false;
            this.isLoading = false;
            this.inUseNativeData = null;
            this.errInfo = null;
            this.remainRequestTime = 0;
            this.remainShowTime = this.adIntervals;
            this.remainShowNumber = this.allowShowNum;
            this.channelAd.init(this.arg);
        }
        get isShowing() {
            return this.showGameAdArray.length + this.showSdkAdArray.length > 0;
        }
        get adIntervals() {
            let config = ULConfig.getConfig();
            let refresh_intervals = config.i_sdk_native_autoRefresh_intervals || 30;
            let nation_autoRefresh_intervals = Number(refresh_intervals) || 30;
            return nation_autoRefresh_intervals;
        }
        get allowShowNum() {
            let config = ULConfig.getConfig();
            let allowShowNum = config.i_sdk_native_valid_show_count || 0;
            let trimAllowShowNum = Number(allowShowNum) || 2;
            return trimAllowShowNum;
        }
        get requestCD() {
            let config = ULConfig.getConfig();
            let nativeCD = config.i_sdk_adv_native_life_time || 0;
            let trimNativeCD = Number(nativeCD) / 1000 || 0;
            return Math.max(trimNativeCD, 15);
        }
        get exposureCd() {
            let config = ULConfig.getConfig();
            let exposureCd = config.i_sdk_adv_native_exposure_cd || 0;
            let trimExposureCd = Number(exposureCd) / 1000 || 0;
            return trimExposureCd;
        }
        get allowLoad() {
            if (this.showGameAdArray.length > 0)
                return false;
            if (this.remainRequestTime == 0) {
                if (this.hadClick)
                    return true;
                if (this.inUseNativeData == null)
                    return true;
                if (this.hadshown && this.remainShowTime == 0)
                    return true;
                if (this.hadshown && this.remainShowNumber == 0) {
                    let isAutoRefresh = ULAdvNativeManager.isAutoRefresh;
                    if (!this.isShowing && isAutoRefresh)
                        return true;
                    if (this.isShowing && !isAutoRefresh)
                        return true;
                }
            }
            return false;
        }
        performSecond() {
            this.remainRequestTime = Math.max(--this.remainRequestTime, 0);
            if (this.isShowing)
                this.remainShowTime = Math.max(--this.remainShowTime, 0);
            ULLog.console.log(`ULNativeItem allowLoad:${this.allowLoad},isShowing:${this.isShowing},rmRequestTime:${this.remainRequestTime},rmShowTime:${this.remainShowTime},rmShowNumber:${this.remainShowNumber}`);
        }
        refreshLoad() {
            this.loadChannelData({
                onLoad: (nativeData) => {
                    ULLog.console.log(`ULNativeItem refreshLoad onLoad:${nativeData}`);
                    this.showSdkAdArray.forEach(nativeAd => {
                        if (nativeAd instanceof ULAdvSDKNativeAd) {
                            nativeAd.refreshData(nativeData);
                        }
                    });
                },
                onLoadFail: (errInfo) => {
                    ULLog.console.log(`ULNativeItem refreshLoad onLoadFail:${errInfo}`);
                    this.showSdkAdArray.forEach(nativeAd => {
                        if (nativeAd instanceof ULAdvSDKNativeAd) {
                            nativeAd.refreshData(null);
                        }
                    });
                },
            });
        }
        load(cycle) {
            if (this.allowLoad || this.isLoading) {
                this.loadChannelData(cycle);
            }
            else if (this.inUseNativeData != null) {
                cycle.onLoad && cycle.onLoad(this.inUseNativeData);
            }
            else {
                cycle.onLoadFail && cycle.onLoadFail(this.errInfo || { code: "0", msg: this.isLoading ? "正在加载中" : "未知错误" });
            }
        }
        loadChannelData(cycle) {
            this.loadCycleList.push(cycle);
            if (this.isLoading)
                return;
            this.isLoading = true;
            this.remainRequestTime = this.requestCD;
            let timerId = setTimeout(() => {
                this.channelLoadCycle.onLoadFail({ code: "0", msg: "加载超时" });
            }, 20000);
            let baseLoadCycle = new ULAdvNativeAdLoadCycle();
            this.channelLoadCycle.onLoad = (nativeData) => {
                ULLog.console.log(`ULNativeItem onLoad nativeData:${nativeData}`);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = null;
                this.inUseNativeData = nativeData;
                this.hadshown = false;
                this.hadClick = false;
                this.remainRequestTime = this.requestCD;
                this.remainShowTime = this.adIntervals;
                this.remainShowNumber = this.allowShowNum;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoad && cycleItem.onLoad(nativeData);
                }
            };
            this.channelLoadCycle.onLoadFail = (errInfo) => {
                ULLog.console.log("ULNativeItem channelLoadCycle onLoadFail:" + errInfo);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = errInfo;
                this.inUseNativeData = null;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoadFail && cycleItem.onLoadFail(errInfo);
                }
            };
            this.channelAd.load(this.channelLoadCycle);
        }
        show(nativeAd, showType) {
            ULLog.console.log("ULNativeItem show");
            if (showType == ULAdvNativeAdShowType.game) {
                let index = this.showGameAdArray.indexOf(nativeAd);
                if (index == -1) {
                    this.showGameAdArray.push(nativeAd);
                }
            }
            else if (showType == ULAdvNativeAdShowType.sdk) {
                let index = this.showSdkAdArray.indexOf(nativeAd);
                if (index == -1) {
                    this.showSdkAdArray.push(nativeAd);
                }
            }
            this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
            if (!this.hadshown || ULTools.time() - this.lastExposureTime > this.exposureCd) {
                this.channelAd.show();
                this.lastExposureTime = ULTools.time();
            }
            this.hadshown = true;
        }
        click() {
            this.channelAd.click();
            this.hadClick = true;
            this.remainRequestTime = 0;
        }
        close(nativeAd, showType) {
            ULLog.console.log(`ULNativeItem close `);
            if (showType == ULAdvNativeAdShowType.game) {
                let index = this.showGameAdArray.indexOf(nativeAd);
                if (index > -1) {
                    this.showGameAdArray.splice(index, 1);
                }
            }
            else if (showType == ULAdvNativeAdShowType.sdk) {
                let index = this.showSdkAdArray.indexOf(nativeAd);
                if (index > -1) {
                    this.showSdkAdArray.splice(index, 1);
                }
            }
        }
        destroy() {
        }
    }
    class ULAdvNativeManager {
        constructor() {
            this.timerId = null;
            this.nativeItemCache = {};
            this.showBannerAutoRefreshTags = null;
            let self = this;
            this.timerId = setInterval(function () {
                for (let key in self.nativeItemCache) {
                    let nativeItem = self.nativeItemCache[key];
                    self.showOneSecond(nativeItem);
                }
            }, 1000);
        }
        static getInstance() {
            if (!this.instance) {
                this.instance = new ULAdvNativeManager();
            }
            return this.instance;
        }
        get isAutoRefresh() {
            let config = ULConfig.getConfig();
            return config.i_sdk_native_autoRefresh_mode == 1;
        }
        static get isAutoRefresh() {
            return ULAdvNativeManager.getInstance().isAutoRefresh;
        }
        get channelBannerStyle() {
            if (this.showBannerAutoRefreshTags == null) {
                let config = ULConfig.getConfig();
                this.showBannerAutoRefreshTags = {};
                let banner_autoRefresh_tags = config.t_sdk_show_native_banner_autoRefresh_tags || [];
                let banner_autoRefresh_tags_style_setting = config.t_sdk_show_native_banner_autoRefresh_tags_style_setting || {};
                for (let index = 0; index < banner_autoRefresh_tags.length; index++) {
                    let tag = banner_autoRefresh_tags[index];
                    let style = banner_autoRefresh_tags_style_setting[tag] || banner_autoRefresh_tags_style_setting["*"] || {};
                    this.showBannerAutoRefreshTags[tag] = style;
                }
            }
            return this.showBannerAutoRefreshTags;
        }
        showOneSecond(nativeItem) {
            nativeItem.performSecond();
            if (!this.isAutoRefresh)
                return;
            if (nativeItem.allowLoad)
                nativeItem.refreshLoad();
        }
        static createNativeAd(channelAd, parma) {
            return ULAdvNativeManager.getInstance().createNativeAd(channelAd, parma);
        }
        static isShowing(arg) {
            if (this.instance.nativeItemCache[arg]) {
                return this.instance.nativeItemCache[arg].isShowing;
            }
            return false;
        }
        createNativeAd(channelAd, parma) {
            let nativeAd = null;
            if (!this.nativeItemCache[parma.arg]) {
                this.nativeItemCache[parma.arg] = new ULNativeItem({
                    arg: parma.arg,
                    channelAd: new channelAd()
                });
            }
            let item = this.nativeItemCache[parma.arg];
            let trimParma = {
                arg: parma.arg,
                type: parma.type,
                load: (nativeAd, loadCycle) => {
                    item.load(loadCycle);
                },
                click: (nativeAd) => {
                    item.click();
                },
                show: (nativeAd) => {
                    item.show(nativeAd, parma.showType);
                },
                close: (nativeAd) => {
                    item.close(nativeAd, parma.showType);
                },
                destroy: (nativeAd) => {
                    item.destroy();
                    delete this.nativeItemCache[item.arg];
                }
            };
            if (parma.showType == ULAdvNativeAdShowType.game) {
                ULLog.console.log("ULAdvNativeManager-createNativeAd-ULAdvGameNativeAd");
                nativeAd = new ULAdvGameNativeAd(trimParma);
            }
            else {
                ULLog.console.log("ULAdvNativeManager-createNativeAd-ULAdvSDKNativeAd");
                nativeAd = new ULAdvSDKNativeAd(trimParma);
            }
            return nativeAd;
        }
        static getBannerStyle(data) {
            let advId = data["advId"];
            let tag = data["tag"] || advId || "";
            let channelBannerStyle = ULAdvNativeManager.instance.channelBannerStyle;
            ULLog.console.log("ULAdvNativeManager data.layout:", data.layout);
            ULLog.console.log(`ULAdvNativeManager this.channelBannerStyle[${tag}]:`, channelBannerStyle[tag]);
            let style = data.layout || channelBannerStyle[tag] || null;
            if (style == null || style == undefined) {
                return null;
            }
            let trimStyle = {
                x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                y: !isNaN(Number(style.y)) ? Number(style.y) : 0,
                width: !isNaN(Number(style.width)) ? Number(style.width) : 1,
                height: !isNaN(Number(style.height)) ? Number(style.height) : 1,
            };
            return trimStyle;
        }
        static getEmbeddStyle(data) {
            let style = data.layout || {};
            let trimStyle = {
                x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                y: !isNaN(Number(style.y)) ? Number(style.y) : 0.5,
                width: !isNaN(Number(style.width)) ? Number(style.width) : 0.4,
                height: !isNaN(Number(style.height)) ? Number(style.height) : 0.2,
            };
            ULLog.console.log("ULAdvNativeManager data.layout:", data.layout);
            ULLog.console.log("ULAdvNativeManager data.trimStyle:", trimStyle);
            return trimStyle;
        }
    }
    ULAdvNativeManager.isPreLoad = true;

    let qg$7 = window["qg"];
    class ULAdvOppoQgNativeItem {
        set inUseData(inUseData) {
            if (this._inUseData == inUseData) {
                return;
            }
            this._inUseData = inUseData;
        }
        get inUseData() {
            return this._inUseData;
        }
        init(arg) {
            this.arg = arg;
        }
        load(cycle) {
            let platformVersionCode = qg$7.getSystemInfoSync().platformVersionCode;
            if (platformVersionCode < 1051) {
                ULLog.console.warn("ULAdvOppoQgNativeItem.load:原生api最低支持1051");
                cycle.onLoadFail && cycle.onLoadFail({ code: "", msg: "minPlatformVersion unsupport" });
                return;
            }
            if (this.nativeAd) {
                this.nativeAd.destroy();
                this.nativeAd = null;
            }
            this.nativeAd = qg$7.createNativeAd({
                adUnitId: this.arg
            });
            this.nativeAd.onLoad((res) => {
                ULLog.console.log('ULAdvOppoQgNativeItem-onLoad:', res);
                if (res && res.adList) {
                    let adData = res.adList.pop();
                    this.inUseData = adData;
                    let respone = {
                        title: adData.title || "",
                        desc: adData.desc || "",
                        icon: adData.icon || "",
                        url: adData.imgUrlList[0] || adData.iconUrlList[0] || "",
                        targetTitle: adData.clickBtnTxt || "点击查看",
                        adSource: adData.adSource || "",
                    };
                    cycle.onLoad && cycle.onLoad(respone);
                }
                else {
                    cycle.onLoadFail && cycle.onLoadFail({ code: "", msg: "no ad" });
                }
            });
            this.nativeAd.onError((err) => {
                ULLog.console.log('ULAdvOppoQgNativeItem-onError err:', err);
                let errInfo = {
                    code: String(err.errCode),
                    msg: err.errMsg
                };
                cycle.onLoadFail && cycle.onLoadFail(errInfo);
            });
            this.nativeAd.load();
        }
        click() {
            ULLog.console.log('ULAdvOppoQgNativeItem-click');
            if (this.nativeAd) {
                this.nativeAd.reportAdClick({
                    adId: this.inUseData.adId
                });
            }
        }
        show() {
            ULLog.console.log('ULAdvOppoQgNativeItem-show');
            if (this.nativeAd) {
                this.nativeAd.reportAdShow({
                    adId: this.inUseData.adId
                });
            }
        }
    }

    let qg$8 = window["qg"];
    class ULAdvOppoQgNativeBase extends ULAdvNativeObjectBase {
        constructor(arg, advType, templateItemName) {
            super(arg, advType, templateItemName);
            this.className = "ULAdvOppoQgNativeBase";
            this.statisticsAdvertiser = ULAdvOppoQg.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgNativeBase-onDisposeModule arg:", this.arg);
        }
        closeNativeAdv(e) {
            let data = e.data;
            let advId = data.advId;
            if (!this.showData || !this.showData.advId || this.showData.advId != advId) {
                return;
            }
            ULLog.console.log("ULAdvOppoQgNativeBase-closeNativeAdv");
            this.nativeAd.close(data.closeType == 1);
            ULSdkManager.getInstance().advManager.responseCloseNativeAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        clickNativeAdv(e) {
            let data = e.data;
            let advId = data.advId;
            if (!this.showData || !this.showData.advId || this.showData.advId != advId) {
                return;
            }
            ULLog.console.log("ULAdvOppoQgNativeBase-clickNativeAdv");
            this.nativeAd.click();
            this.nativeAd.close(false);
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgNativeBase-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            let type = this.advType == "banner" ? ULAdvNativeAdType.banner : ULAdvNativeAdType.inter;
            ULLog.console.log("ULAdvOppoQgNativeBase-initAdv:", type);
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvOppoQgNativeItem, {
                arg: this.arg,
                type: type,
                showType: ULAdvNativeAdShowType.game
            });
        }
        loadAdv() {
        }
        showAdv(showData) {
            ULLog.console.log("ULAdvOppoQgNativeBase-showAdv:");
            let ad_limitTime = ULConfig.getConfig().i_sdk_oppoqg_ad_ecd;
            let requestTime = ULTools.time();
            if (requestTime - ULSdkManager.getInstance().advManager.sdkInitTime < ad_limitTime / 1000) {
                ULLog.console.log("ULAdvOppoQgNativeBase.onShowNativeAdv:未达到启动cd限制，无法展示广告");
                this.advSkip(showData, { code: "", msg: "in start cd" });
                return;
            }
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                console.warn("ULAdvOppoQgNativeBase-showAdv:广告未加载就绪,直接跳过当前广告展示");
                this.advSkip(showData, { code: "", msg: "adv not ready" });
                return;
            }
            this.showData = showData;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgNativeBase-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgNativeBase-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, showData, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgNativeBase-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", showData, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgNativeBase-showAdv-onClose");
                this.isOpened = false;
                this.nativeShowState = false;
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, showData, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(showData);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgNativeBase-closeAdv");
            this.nativeAd.close(data.closeType == 1);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgNativeBase-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvOppoQgNativeBanner extends ULAdvOppoQgNativeBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvOppoQgNativeBanner_" + arg);
        }
    }

    class ULAdvOppoQgNativeInter extends ULAdvOppoQgNativeBase {
        constructor(arg) {
            super(arg, typeExp.inter, "ULAdvOppoQgNativeInter_" + arg);
            this.statisticsType = oldTypeExp.interstitial;
        }
    }

    class ULAdvOppoQgNativeEmbed extends ULAdvOppoQgNativeBase {
        constructor(arg) {
            super(arg, typeExp.embed, "ULAdvOppoQgNativeEmbed_" + arg);
            this.statisticsType = oldTypeExp.embedded;
        }
    }

    let qg$9 = window["qg"];
    class ULAdvOppoQgAutoNativeBanner extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.banner, "ULAdvOppoQgAutoNativeBanner" + "_" + arg);
            this.className = "ULAdvOppoQgAutoNativeBanner";
            this.statisticsAdvertiser = ULAdvOppoQg.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvOppoQgNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.banner,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv");
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let ad_limitTime = ULConfig.getConfig().i_sdk_oppoqg_ad_ecd;
            let requestTime = ULTools.time();
            if (requestTime - ULSdkManager.getInstance().advManager.sdkInitTime < ad_limitTime / 1000) {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv:未达到启动cd限制，无法展示广告");
                this.advSkip(data, { code: "", msg: "in start cd" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeBanner-showAdv-onClose");
                this.isOpened = false;
                this.nativeShowState = false;
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeBanner-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgAutoNativeBanner-receiveInitState:初始化失败");
            }
        }
    }

    let qg$a = window["qg"];
    class ULAdvOppoQgAutoNativeInter extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.inter, "ULAdvOppoQgAutoNativeInter" + "_" + arg);
            this.className = "ULAdvOppoQgAutoNativeInter";
            this.statisticsAdvertiser = ULAdvOppoQg.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgAutoNativeInter-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgAutoNativeInter-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvOppoQgNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.inter,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            console.warn("ULAdvOppoQgAutoNativeInter-showAdv");
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let ad_limitTime = ULConfig.getConfig().i_sdk_oppoqg_ad_ecd;
            let requestTime = ULTools.time();
            if (requestTime - ULSdkManager.getInstance().advManager.sdkInitTime < ad_limitTime / 1000) {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv:未达到启动cd限制，无法展示广告");
                this.advSkip(data, { code: "", msg: "in start cd" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeInter-showAdv-onClose isUserClick：", isUserClick);
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgAutoNativeInter-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeInter-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeInter-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgAutoNativeInter-receiveInitState:初始化失败");
            }
        }
    }

    let qg$b = window["qg"];
    class ULAdvOppoQgAutoNativeEmbed extends ULAdvNativeObjectBase {
        constructor(arg) {
            super(arg, typeExp.embed, "ULAdvOppoQgAutoNativeEmbed" + "_" + arg);
            this.className = "ULAdvOppoQgAutoNativeEmbed";
            this.statisticsAdvertiser = ULAdvOppoQg.NATIVE_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-onDisposeModule arg:", this.arg);
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.nativeAd = ULAdvNativeManager.createNativeAd(ULAdvOppoQgNativeItem, {
                arg: this.arg,
                type: ULAdvNativeAdType.embedded,
                showType: ULAdvNativeAdShowType.sdk
            });
        }
        loadAdv() {
        }
        showAdv(data) {
            console.warn("ULAdvOppoQgAutoNativeEmbed-showAdv");
            if (this.preLoadState != ULConst.ADV_PRELOAD_STATE_READY) {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv:广告未加载就绪，直接跳过");
                this.advSkip(data, { code: "", msg: "adv not ready" });
                return;
            }
            let ad_limitTime = ULConfig.getConfig().i_sdk_oppoqg_ad_ecd;
            let requestTime = ULTools.time();
            if (requestTime - ULSdkManager.getInstance().advManager.sdkInitTime < ad_limitTime / 1000) {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv:未达到启动cd限制，无法展示广告");
                this.advSkip(data, { code: "", msg: "in start cd" });
                return;
            }
            this.showData = data;
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.nativeAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(this.showData, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.nativeAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, this.nativeAd.nativeData);
            });
            this.nativeAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, { title: this.nativeAd.nativeData ? this.nativeAd.nativeData.title : "" });
            });
            this.nativeAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-showAdv-onClose isUserClick：", isUserClick);
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                this.nativeShowState = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
            });
            this.isOpened = true;
            this.nativeShowState = true;
            this.nativeAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-closeAdv");
            this.nativeAd.close(false);
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        closeNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-closeNativeAdv");
        }
        clickNativeAdv(e) {
            ULLog.console.log("ULAdvOppoQgAutoNativeEmbed-clickNativeAdv");
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgAutoNativeEmbed-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvCustomAdStyle {
        constructor() {
            this.x = 0.5;
            this.y = 0;
            this.width = 1;
            this.height = 1;
        }
    }
    class ULAdvCustomAdLoadCycle {
        constructor() {
            this.onLoad = () => {
                ULLog.console.log("ULAdvCustomAdLoadCycle default onLoad");
            };
            this.onLoadFail = (errInfo) => {
                ULLog.console.log("ULAdvCustomAdLoadCycle default onLoadFail");
            };
        }
    }
    class ULAdvCustomAdShowCycle {
        constructor() {
            this.onShow = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onShow");
            };
            this.onShowFail = (errInfo) => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onShowFail");
            };
            this.onRefresh = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onRefresh");
            };
            this.onClose = (isUserClick = true) => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onClose isUserClick:", isUserClick);
            };
            this.onClick = () => {
                ULLog.console.log("ULAdvCustomAdShowCycle default onClick");
            };
        }
    }

    class ULAdvCustomNormalAd {
        constructor(parma) {
            this.showCycle = new ULAdvCustomAdShowCycle();
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
            this.arg = parma.arg;
            this.showCall = parma.show;
            this.closeCall = parma.close;
            this.destroyCall = parma.destroy;
        }
        show(data) {
            if (this.isShowing)
                return;
            if (!this.showCall)
                return;
            this.isShowing = true;
            this.showCall(data, {
                onShow: () => {
                    this.showCycle.onShow && this.showCycle.onShow();
                },
                onShowFail: (errInfo) => {
                    this.isShowing = false;
                    this.showCycle.onShowFail && this.showCycle.onShowFail(errInfo);
                },
                onRefresh: () => {
                    this.showCycle.onRefresh && this.showCycle.onRefresh();
                },
                onClose: (isUserClick) => {
                    this.isShowing = false;
                    this.showCycle.onClose && this.showCycle.onClose(isUserClick);
                },
                onClick: () => {
                    this.showCycle.onClick && this.showCycle.onClick();
                }
            });
        }
        close() {
            if (!this.isShowing)
                return;
            this.closeCall && this.closeCall();
        }
        destroy() {
            this.destroyCall && this.destroyCall();
            this.showCall = null;
            this.closeCall = null;
            this.destroyCall = null;
        }
    }

    class ULAdvCustomManager {
        constructor() {
            this.timerId = null;
            this.customItemCache = {};
            let self = this;
            this.timerId = setInterval(function () {
                for (let key in self.customItemCache) {
                    let customItem = self.customItemCache[key];
                    self.showOneSecond(customItem);
                }
            }, 1000);
        }
        get isAutoRefresh() {
            let config = ULConfig.getConfig();
            return !!config.i_sdk_custom_autoRefresh_mode;
        }
        get channelCustomStyle() {
            let config = ULConfig.getConfig();
            return config.t_sdk_adv_custom_args_style_setting || {};
        }
        static get isAutoRefresh() {
            return ULAdvCustomManager.getInstance().isAutoRefresh;
        }
        static getInstance() {
            if (!this.instance) {
                this.instance = new ULAdvCustomManager();
            }
            return this.instance;
        }
        showOneSecond(customItem) {
            customItem.performSecond();
            if (!this.isAutoRefresh)
                return;
            if (customItem.allowLoad) {
                customItem.refresh();
            }
        }
        static createCustomAd(channelAd, parma, allowRefreshShowing = true) {
            return ULAdvCustomManager.getInstance().createCustomAd(channelAd, parma, allowRefreshShowing);
        }
        createCustomAd(channelAd, parma, allowRefreshShowing = true) {
            let customAd = null;
            let item = this.customItemCache[parma.arg];
            if (!!!item) {
                item = new ULCustomItem({
                    arg: parma.arg,
                    channelAd: new channelAd()
                });
                this.customItemCache[parma.arg] = item;
            }
            customAd = new ULAdvCustomNormalAd({
                arg: item.arg,
                show: (data, cycle) => {
                    let advId = data["advId"];
                    let tag = data["tag"] || advId || "";
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[tag]:", this.channelCustomStyle[tag]);
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[arg]:", this.channelCustomStyle[item.arg]);
                    ULLog.console.log("ULAdvCustomManager this.channelCustomStyle[*]:", this.channelCustomStyle["*"]);
                    let style = this.channelCustomStyle[tag] || this.channelCustomStyle[item.arg] || this.channelCustomStyle["*"] || {};
                    let trimStyle = {
                        x: !isNaN(Number(style.x)) ? Number(style.x) : 0.5,
                        y: !isNaN(Number(style.y)) ? Number(style.y) : 0,
                        width: !isNaN(Number(style.width)) ? Number(style.width) : 1,
                        height: !isNaN(Number(style.height)) ? Number(style.height) : 0.5,
                    };
                    item.allowRefreshShowing = allowRefreshShowing;
                    item.show(trimStyle, cycle);
                },
                close: () => {
                    item.close();
                },
                destroy: () => {
                    item.destroy();
                    delete this.customItemCache[item.arg];
                }
            });
            return customAd;
        }
    }
    class ULCustomItem {
        constructor(param) {
            this.allowRefreshShowing = true;
            this.showStyle = { x: 0.5, y: 0, width: 1, height: 1 };
            this.showCycleList = [];
            this.loadCycleList = [];
            this.hadShowRulst = false;
            this.channelShowCycle = {
                onShow: () => {
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onShow");
                    if (!this.isShowing) {
                        this.close();
                        return;
                    }
                    this.hadShowRulst = true;
                    this.hadshown = true;
                    this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onShow && cycleItem.onShow();
                    }
                },
                onShowFail: (errInfo) => {
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onShowFail");
                    if (!this.isShowing) {
                        return;
                    }
                    this.hadShowRulst = true;
                    this.isShowing = false;
                    this.loadSuccess = false;
                    this.errInfo = errInfo;
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList.shift();
                        cycleItem.onShowFail && cycleItem.onShowFail(errInfo);
                    }
                },
                onRefresh: (errInfo = null) => {
                    if (!this.isShowing) {
                        return;
                    }
                    this.hadShowRulst = true;
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle refresh onRefresh err:", errInfo);
                    if (errInfo) {
                        return;
                    }
                    this.hadshown = true;
                    this.remainShowNumber = Math.max(--this.remainShowNumber, 0);
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onRefresh && cycleItem.onRefresh();
                    }
                },
                onClose: (isUserClick = false) => {
                    if (!this.isShowing) {
                        return;
                    }
                    if (this.isLoading && isUserClick) {
                        return;
                    }
                    if (!this.hadshown && isUserClick) {
                        return;
                    }
                    if (!this.hadShowRulst)
                        return;
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onClose");
                    this.isShowing = false;
                    while (this.showCycleList.length) {
                        let cycleItem = this.showCycleList.shift();
                        cycleItem.onClose && cycleItem.onClose(isUserClick);
                    }
                },
                onClick: () => {
                    if (!this.isShowing) {
                        return;
                    }
                    ULLog.console.log("ULCustomItem.channelShow channelShowCycle onClick");
                    this.hadClick = true;
                    this.remainRequestTime = 0;
                    for (let i = 0; i < this.showCycleList.length; i++) {
                        let cycleItem = this.showCycleList[i];
                        cycleItem.onClick && cycleItem.onClick();
                    }
                }
            };
            this.channelLoadCycle = new ULAdvCustomAdLoadCycle();
            this.arg = param.arg;
            this.channelAd = param.channelAd;
            this.isShowing = false;
            this.hadClick = false;
            this.hadshown = false;
            this.isLoading = false;
            this.loadSuccess = false;
            this.remainRequestTime = 0;
            this.remainShowTime = this.adIntervals;
            this.remainShowNumber = this.allowShowNum;
            this.channelAd.init(this.arg);
        }
        get adIntervals() {
            let config = ULConfig.getConfig();
            let adIntervals = config.i_sdk_custom_refresh_intervals || 30;
            return Number(adIntervals) || 30;
        }
        get allowShowNum() {
            let config = ULConfig.getConfig();
            let allowShowNum = config.i_sdk_adv_custom_valid_show_count || 0;
            let trimAllowShowNum = Number(allowShowNum) || 2;
            return trimAllowShowNum;
        }
        get requestCD() {
            let config = ULConfig.getConfig();
            let customCD = config.i_sdk_adv_custom_cd || 0;
            let trimCustomCD = Number(customCD) / 1000 || 0;
            return Math.max(trimCustomCD, 15);
        }
        get allowLoad() {
            if (this.remainRequestTime == 0) {
                if (this.hadClick)
                    return true;
                if (!this.loadSuccess)
                    return true;
                if (this.hadshown && this.remainShowTime == 0)
                    return true;
                if (this.hadshown && this.remainShowNumber == 0) {
                    let isAutoRefresh = ULAdvCustomManager.isAutoRefresh;
                    if (!this.isShowing && isAutoRefresh && this.allowRefreshShowing)
                        return true;
                    if (this.isShowing && !isAutoRefresh)
                        return true;
                }
            }
            return false;
        }
        performSecond() {
            this.remainRequestTime = Math.max(--this.remainRequestTime, 0);
            if (this.isShowing) {
                this.remainShowTime = Math.max(--this.remainShowTime, 0);
            }
            ULLog.console.log("ULCustomItem:", {
                allowLoad: this.allowLoad,
                isShowing: this.isShowing,
                remainRequestTime: this.remainRequestTime,
                remainShowTime: this.remainShowTime,
                remainShowNumber: this.remainShowNumber,
            });
        }
        loadData(cycle) {
            this.loadCycleList.push(cycle);
            if (this.isLoading)
                return;
            this.isLoading = true;
            this.remainRequestTime = this.requestCD;
            let timerId = setTimeout(() => {
                this.channelLoadCycle.onLoadFail({ code: "0", msg: "加载超时" });
            }, 20000);
            let baseLoadCycle = new ULAdvCustomAdLoadCycle();
            this.channelLoadCycle.onLoad = () => {
                ULLog.console.log("ULCustomItem channelLoadCycle onLoad");
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = null;
                this.loadSuccess = true;
                this.hadshown = false;
                this.hadClick = false;
                this.remainRequestTime = this.requestCD;
                this.remainShowTime = this.adIntervals;
                this.remainShowNumber = this.allowShowNum;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoad && cycleItem.onLoad();
                }
            };
            this.channelLoadCycle.onLoadFail = (errInfo) => {
                ULLog.console.log("ULCustomItem channelLoadCycle onLoadFail:" + errInfo);
                this.channelLoadCycle.onLoad = baseLoadCycle.onLoad;
                this.channelLoadCycle.onLoadFail = baseLoadCycle.onLoadFail;
                clearTimeout(timerId);
                this.isLoading = false;
                this.errInfo = errInfo;
                this.loadSuccess = false;
                while (this.loadCycleList.length) {
                    let cycleItem = this.loadCycleList.shift();
                    cycleItem.onLoadFail && cycleItem.onLoadFail(errInfo);
                }
            };
            this.channelAd.load(this.channelLoadCycle);
        }
        channelShow(isRefresh = false) {
            if (!this.isShowing)
                return;
            this.hadShowRulst = false;
            this.channelAd.show(this.showStyle, {
                onShow: isRefresh ? this.channelShowCycle.onRefresh : this.channelShowCycle.onShow,
                onShowFail: isRefresh ? this.channelShowCycle.onRefresh : this.channelShowCycle.onShowFail,
                onRefresh: this.channelShowCycle.onRefresh,
                onClose: this.channelShowCycle.onClose,
                onClick: this.channelShowCycle.onClick
            });
        }
        show(style, cycle) {
            ULLog.console.log("ULAdvCustomManager.show isShowing:", this.isShowing);
            if (this.isShowing) {
                cycle.onShowFail({ code: "0", msg: "正在播放中" });
                return;
            }
            this.isShowing = true;
            this.showStyle = style;
            this.showCycleList.push(cycle);
            if (this.allowLoad || this.isLoading) {
                ULLog.console.log("ULAdvCustomManager.show loadData");
                this.loadData({
                    onLoad: () => {
                        ULLog.console.log("ULAdvCustomManager.show loadData onLoad");
                        this.channelShow();
                    },
                    onLoadFail: (errInfo) => {
                        ULLog.console.log("ULAdvCustomManager.show loadData onLoadFail");
                        this.channelShowCycle.onShowFail(errInfo);
                    }
                });
            }
            else if (this.loadSuccess) {
                ULLog.console.log("ULAdvCustomManager.show loadSuccess");
                this.remainRequestTime = Math.max(this.remainRequestTime, 3);
                this.channelShow();
            }
            else {
                ULLog.console.log("ULAdvCustomManager.show errInfo");
                this.channelShowCycle.onShowFail(this.errInfo || (this.isLoading ? { code: "0", msg: "正在加载中" } : { code: "0", msg: "未知错误" }));
            }
        }
        refresh() {
            ULLog.console.log("ULAdvCustomManager.refresh");
            var isShowing = this.isShowing;
            this.loadData({
                onLoad: () => {
                    ULLog.console.log("ULAdvCustomManager.refresh onLoad isShowing:", this.isShowing);
                    if (isShowing && this.isShowing)
                        this.channelShow(true);
                },
                onLoadFail: (errInfo) => {
                    ULLog.console.log("ULAdvCustomManager.refresh onLoadFail");
                },
            });
        }
        close() {
            ULLog.console.log("ULAdvCustomManager.close");
            this.hadShowRulst = true;
            this.loadCycleList = [];
            this.channelAd.close();
            this.channelShowCycle.onClose && this.channelShowCycle.onClose(false);
        }
        destroy() {
            ULLog.console.log("ULAdvCustomManager.destroy");
            this.close();
            this.channelAd.destroy();
            this.channelAd = null;
        }
    }

    let qg$c = window["qg"];
    class ULAdvOppoQgCustomItem {
        constructor() {
            this.arg = null;
            this.customAd = null;
            this.channelStyle = null;
            this.showStyleString = "";
        }
        init(arg) {
            this.arg = arg;
            let config = ULConfig.getConfig();
            let t_sdk_oppoqg_custom_adv_setting = config.t_sdk_oppoqg_custom_adv_setting;
            this.channelStyle = t_sdk_oppoqg_custom_adv_setting[this.arg] || t_sdk_oppoqg_custom_adv_setting["*"] || {};
            ULLog.console.log("ULAdvOppoQgCustomItem.initAdv channelStyle:", this.channelStyle);
        }
        load(cycle) {
            ULLog.console.log("ULAdvOppoQgCustomItem.load ");
            if (this.customAd) {
                this.customAd.offHide();
                this.customAd.hide();
                this.customAd.destroy();
                this.customAd = null;
            }
            cycle.onLoad();
        }
        createNewCustomAd(style) {
            if (this.customAd) {
                this.customAd.offHide();
                this.customAd.hide();
                this.customAd.destroy();
                this.customAd = null;
            }
            let sys = qg$c.getSystemInfoSync();
            let screenWidth = sys.screenWidth;
            let screenHeight = sys.screenHeight;
            let width = Math.min(screenWidth, screenHeight);
            let height = 0;
            try {
                let size = this.channelStyle.size;
                size = size.replace(/\s*/g, "");
                let sizeArray = size.split("*");
                if (sizeArray.length == 2) {
                    let sizeWidth = parseInt(sizeArray[0]);
                    let sizeHeight = parseInt(sizeArray[1]);
                    width = width * Math.min(Math.max(0.6, style.width), 1);
                    height = width * sizeHeight / sizeWidth;
                }
            }
            catch (error) {
                ULLog.console.log("ULAdvOppoQgCustomItem.createNewCustomAd catch:", error.stack);
                width = width * Math.min(Math.max(0.6, style.width), 1);
                height = width;
            }
            let left = (screenWidth - width) * style.x;
            let top = (1 - style.y) * (screenHeight - height);
            ULLog.console.log("ULAdvOppoQgCustomItem.createNewCustomAd style:", {
                top: top,
                left: left,
                width: width,
            });
            this.customAd = qg$c.createCustomAd({
                adUnitId: this.arg,
                style: {
                    top: top,
                    left: left,
                    width: width,
                },
            });
        }
        show(style, cycle) {
            let showStyleString = JSON.stringify(style);
            let isEqual = showStyleString == this.showStyleString;
            this.showStyleString = showStyleString;
            console.log(`ULAdvOppoQgCustomItem.show style :${showStyleString} :`, isEqual);
            if (!this.customAd || !isEqual) {
                this.createNewCustomAd(style);
            }
            this.customAd.offHide();
            this.customAd.onHide(() => {
                ULLog.console.log("ULAdvOppoQgCustomItem.show onHide");
                cycle.onClose(true);
            });
            this.customAd
                .show()
                .then(() => {
                ULLog.console.log("ULAdvOppoQgCustomItem.show then");
                cycle.onShow();
            })
                .catch((e) => {
                ULLog.console.log("ULAdvOppoQgCustomItem.show catch e:", e);
                cycle.onShowFail({ code: "" + e.errCode, msg: e.errMsg });
            });
        }
        close() {
            ULLog.console.log("ULAdvOppoQgCustomItem.close ");
            this.customAd && this.customAd.hide();
        }
        destroy() {
            ULLog.console.log("ULAdvOppoQgCustomItem.destroy ");
            this.customAd && this.customAd.destroy();
            this.customAd = null;
        }
    }

    class ULAdvOppoQgCustom extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.custom, ULTools.format("%s%s%s", "ULAdvOppoQgCustom", "_", arg));
            this.className = "ULAdvOppoQgCustom";
            this.customAd = null;
            this.statisticsAdvertiser = ULAdvOppoQg.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgCustom-onDisposeModule arg:", this.arg);
            if (this.customAd) {
                this.customAd.destroy();
                this.customAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgCustom-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.customAd = ULAdvCustomManager.createCustomAd(ULAdvOppoQgCustomItem, { arg: this.arg }, false);
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvOppoQgCustom.showAdv");
            this.customAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgCustom.showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(data, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.customAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgCustom.showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
                let config = ULConfig.getConfig();
                let sw = config.s_sdk_oppo_custom_mode || "1";
                if (sw === "1") {
                    if (ULSdkManager.getInstance().channelInfo.getChannelOpenIdFunc) {
                        ULSdkManager.getInstance().channelInfo.getChannelOpenIdFunc((openId, err) => {
                            if (openId) {
                                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", "206", "0", `${new Date().getTime()}_${openId}_${this.arg}_0`]);
                            }
                            else {
                                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", "206", "0", `${new Date().getTime()}_${0}_${this.arg}_0`]);
                            }
                        });
                    }
                    else {
                        ULEventDispatcher.getInstance().dispatch(ULConst.CMD_POST_MEGADATA, ["commonEvent", "206", "0", `${new Date().getTime()}_${0}_${this.arg}_0`]);
                    }
                }
            });
            this.customAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgCustom.showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, null);
            });
            this.customAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgCustom.showAdv-onClose");
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data, null);
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.isOpened = true;
            this.customAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgCustom.closeAdv");
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgCustom-receiveInitState:初始化失败");
            }
        }
    }

    class ULAdvOppoQgCustomBanner extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.custom, ULTools.format("%s%s%s", "ULAdvOppoQgCustomBanner", "_", arg));
            this.className = "ULAdvOppoQgCustomBanner";
            this.customAd = null;
            this.statisticsAdvertiser = ULAdvOppoQg.NORMAL_ADVERTISER;
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgCustomBanner-onDisposeModule arg:", this.arg);
            if (this.customAd) {
                this.customAd.destroy();
                this.customAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgCustomBanner-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
            this.customAd = ULAdvCustomManager.createCustomAd(ULAdvOppoQgCustomItem, { arg: this.arg });
        }
        loadAdv() {
        }
        showAdv(data) {
            ULLog.console.log("ULAdvOppoQgCustomBanner.showAdv");
            this.customAd.showCycle.onShowFail = ((errInfo) => {
                ULLog.console.log("ULAdvOppoQgCustomBanner.showAdv-onError:", errInfo);
                if (this.isOpened) {
                    this.isOpened = false;
                    this.advSkip(data, errInfo);
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, errInfo);
                }
            });
            this.customAd.showCycle.onShow = (() => {
                ULLog.console.log("ULAdvOppoQgCustomBanner.showAdv-onShow");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, data, null);
            });
            this.customAd.showCycle.onClick = (() => {
                ULLog.console.log("ULAdvOppoQgCustomBanner.showAdv-onClick");
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClick(this.advKey, "点击", data, null);
            });
            this.customAd.showCycle.onClose = ((isUserClick) => {
                ULLog.console.log("ULAdvOppoQgCustomBanner.showAdv-onClose");
                if (isUserClick == true) {
                    ULSdkManager.getInstance().advManager.addAdvCountLog(this.advKey, countExp.mcc);
                }
                this.isOpened = false;
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data, null);
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.isOpened = true;
            this.customAd.show(data);
        }
        closeAdv(data) {
            ULLog.console.log("ULAdvOppoQgCustomBanner.closeAdv");
            this.customAd.close();
            ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgCustomBanner-receiveInitState:初始化失败");
            }
        }
    }

    let qg$d = window["qg"];
    class ULAdvOppoQgDrawerBox extends ULAdvObjectBase {
        constructor(arg) {
            super(arg, typeExp.embed, ULTools.format("%s%s%s", "ULAdvOppoQgDrawerBox", "_", arg));
            this.className = "ULAdvOppoQgDrawerBox";
            this.statisticsAdvertiser = "ULAdvOppoQgDrawerBox";
        }
        onDisposeModule() {
            super.onDisposeModule();
            ULLog.console.log("ULAdvOppoQgDrawerBox-onDisposeModule arg:", this.arg);
            if (this.gameDrawerAd) {
                this.gameDrawerAd.destroy();
                this.gameDrawerAd = null;
            }
        }
        initAdv() {
            ULLog.console.log("ULAdvOppoQgDrawerBox-initAdv");
            this.preLoadState = ULConst.ADV_PRELOAD_STATE_READY;
        }
        loadAdv() {
        }
        showAdv(data) {
            if (qg$d.getSystemInfoSync().platformVersionCode < 1090) {
                ULLog.console.log('ULAdvOppoQgDrawerBox-showAdv:快应用平台版本号低于1090，暂不支持互推盒子相关 API');
                this.advSkip(data, { code: "", msg: "api unsupport" });
                return;
            }
            let tag = data["tag"] || data["advId"] || "";
            let advSetting = ULConfig.getConfig().t_sdk_oppoqg_show_drawer_box_adv_tags;
            let styleObj = advSetting[tag];
            if (!styleObj) {
                ULLog.console.log("ULAdvOppoQgDrawerBox-showAdv:当前广告位不允许展示互推盒子抽屉广告");
                this.advSkip(data, { code: "", msg: `advId [${tag}] unsupport drawer box` });
                return;
            }
            this.showData = data;
            this.isOpened = true;
            if (this.gameDrawerAd) {
                this.gameDrawerAd.destroy();
                this.gameDrawerAd = null;
            }
            let sys = qg$d.getSystemInfoSync();
            let screenHeight = sys.screenHeight;
            let style = {};
            if (!isNaN(Number(styleObj.top))) {
                style["top"] = Number(styleObj.top) * screenHeight;
            }
            this.gameDrawerAd = qg$d.createGameDrawerAd({
                adUnitId: this.arg,
                style: style
            });
            ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequest(this.advKey);
            this.gameDrawerAd.show().then(() => {
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestSuccess(this.advKey);
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleShow(this.advKey, ULConst.ADV_RESULT_MSG_SUCCESS, this.showData);
            }).catch((error) => {
                ULLog.console.log("ULAdvOppoQgDrawerBox-showAdv-show-catch:", error);
                this.isOpened = false;
                this.advSkip(this.showData, { code: String(error.errCode), msg: error.errMsg });
                ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleRequestFailed(this.advKey, { code: String(error.errCode), msg: error.errMsg });
            });
        }
        closeAdv(data) {
            if (this.isOpened) {
                this.gameDrawerAd.hide().then(() => {
                    this.isOpened = false;
                    ULSdkManager.getInstance().advManager.onAdvObjectLifeCycleClose(this.advKey, data);
                    ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_SUCCESS, ULConst.ADV_RESULT_MSG_CLOSE);
                }).catch((error) => {
                    ULLog.console.log("ULAdvOppoQgDrawerBox-closeAdv-hide-catch:", error);
                    ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, error.errCode + ',' + error.errMsg);
                });
            }
            else {
                ULSdkManager.getInstance().advManager.responseCloseAdvResult(data, ULConst.ADV_RESULT_CODE_FAILED, "no ad show");
            }
        }
        getMainClassName() {
            return "ULAdvOppoQg";
        }
        receiveInitState(initState) {
            if (initState) {
                this.initState = initState;
                this.initAdv();
            }
            else {
                console.warn("ULAdvOppoQgDrawerBox-receiveInitState:初始化失败");
            }
        }
    }

    let qg$e = window["qg"];
    class ULModuleOppoQg extends ULChannelModuleBase {
        constructor() {
            super(...arguments);
            this.className = "ULModuleOppoQg";
            this.manualCloseBannerCount = 0;
            this.lastDailyResetTime = 0;
            this.userInfoData = null;
        }
        getSubAdModuleClassName() {
            return ["ULAdvOppoQgInter", "ULAdvOppoQgBanner", "ULAdvOppoQgVideo", "ULAdvOppoQgBannerBox", "ULAdvOppoQgPortalBox", "ULAdvOppoQgNativeBanner", "ULAdvOppoQgNativeInter", "ULAdvOppoQgNativeEmbed", "ULAdvOppoQgAutoNativeBanner", "ULAdvOppoQgAutoNativeInter", "ULAdvOppoQgAutoNativeEmbed", "ULAdvOppoQgCustom", "ULAdvOppoQgCustomBanner", "ULAdvOppoQgDrawerBox"];
        }
        getAdMainClassName() {
            return "ULAdvOppoQg";
        }
        createSubAdObj(className, param) {
            let targetObj;
            let advKey;
            switch (className) {
                case "ULAdvOppoQgInter":
                    targetObj = new ULAdvOppoQgInter(param);
                    break;
                case "ULAdvOppoQgBanner":
                    targetObj = new ULAdvOppoQgBanner(param);
                    break;
                case "ULAdvOppoQgVideo":
                    targetObj = new ULAdvOppoQgVideo(param);
                    break;
                case "ULAdvOppoQgBannerBox":
                    targetObj = new ULAdvOppoQgBannerBox(param);
                    break;
                case "ULAdvOppoQgPortalBox":
                    targetObj = new ULAdvOppoQgPortalBox(param);
                    break;
                case "ULAdvOppoQgNativeBanner":
                    targetObj = new ULAdvOppoQgNativeBanner(param);
                    break;
                case "ULAdvOppoQgNativeInter":
                    targetObj = new ULAdvOppoQgNativeInter(param);
                    break;
                case "ULAdvOppoQgNativeEmbed":
                    targetObj = new ULAdvOppoQgNativeEmbed(param);
                    break;
                case "ULAdvOppoQgAutoNativeBanner":
                    targetObj = new ULAdvOppoQgAutoNativeBanner(param);
                    break;
                case "ULAdvOppoQgAutoNativeInter":
                    targetObj = new ULAdvOppoQgAutoNativeInter(param);
                    break;
                case "ULAdvOppoQgAutoNativeEmbed":
                    targetObj = new ULAdvOppoQgAutoNativeEmbed(param);
                    break;
                case "ULAdvOppoQgCustom":
                    targetObj = new ULAdvOppoQgCustom(param);
                    break;
                case "ULAdvOppoQgCustomBanner":
                    targetObj = new ULAdvOppoQgCustomBanner(param);
                    break;
                case "ULAdvOppoQgDrawerBox":
                    targetObj = new ULAdvOppoQgDrawerBox(param);
                    break;
                default:
                    break;
            }
            if (targetObj) {
                advKey = ULTools.format("%s%s%s", className, "_", param);
                ULSdkManager.getInstance().advManager.updateAdvKeyObjMap(advKey, targetObj);
            }
            return targetObj;
        }
        createMainAdObj() {
            return new ULAdvOppoQg();
        }
        init() {
            super.init();
            ULSdkManager.getInstance().statisManager.addPreparationFlag("oppoMoreGameExtra");
            this.loadRecord();
            this.initUserJumpGameInfo();
            this.initSdk();
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SET_VERSION, 1, this.onCmdSetVersion.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USER_LOGIN, 1, this.onCmdUserLogin.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_USER_IS_LOGIN, 1, this.onCmdUserIsLogin.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_USER_INFO_MSG, 1, this.onCmdGetUserInfo.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_PAY, ULConst.PRIORITY_NONE, this.onCmdOpenPay.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_OPEN_JUMP, ULConst.PRIORITY_NONE, this.onCmdOpenJump.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_JUMP_OTHER_GAME, ULConst.PRIORITY_NONE, this.onCmdJumpOtherGame.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_INSTALL_SHORTCUT, ULConst.PRIORITY_NONE, this.onCmdInstallShortcut.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_MORE_GAME_AB_TEST_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerMoreGameTestConfig.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_GET_SHORTCUT_STATE, ULConst.PRIORITY_NONE, this.onCmdGetShortcutState.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_OPPOQG_MARK_MANUAL_CLOSE_BANNER_COUNT, ULConst.PRIORITY_NONE, this.onCmdSdkMarkManualCloseBannerCount.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_OPPOQG_GET_MANUAL_CLOSE_BANNER_COUNT, ULConst.PRIORITY_NONE, this.onCmdSdkGetManualCloseBannerCount.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_PHONE_VIBRATE, 1, this.onCmdPhoneVibrate.bind(this));
            this.onCmdSdkOnGameResume(new ULEvent(ULConst.CMD_SDK_ON_GAME_RESUME, {}));
        }
        loadSubModules() {
            return [];
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            ULLog.console.log("ULModuleOppoQg.loadRecord recordStr:", recordStr);
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this["jumpResourceIndex"] = record.jumpResourceIndex;
            this.lastJumpRecord = record.lastJumpRecord || null;
            this.jumpGameReceivedFlags = record.jumpGameReceivedFlags || {};
            this.lastDailyResetTime = record.lastDailyResetTime || ULTools.time();
            this.manualCloseBannerCount = record.manualCloseBannerCount || 0;
            this.tryDailyReset();
        }
        saveRecord() {
            let record = {
                jumpResourceIndex: this["jumpResourceIndex"],
                lastJumpRecord: this.lastJumpRecord,
                jumpGameReceivedFlags: this.jumpGameReceivedFlags,
                lastDailyResetTime: this.lastDailyResetTime,
                manualCloseBannerCount: this.manualCloseBannerCount,
            };
            let recordStr = JSON.stringify(record);
            ULStorageManager.getInstance().setStorage(this._getRecordKey(), recordStr);
        }
        tryDailyReset() {
            if (!ULTools.isOneDay(ULTools.time(), this.lastDailyResetTime)) {
                this.lastDailyResetTime = ULTools.time();
                this.manualCloseBannerCount = 0;
                this.saveRecord();
            }
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULModuleOppoQg_record_%d", config.s_sdk_megadata_game_id);
        }
        initSdk() {
            let config = ULConfig.getConfig();
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            channelInfo.channelName = "oppoqg";
            channelInfo.uuid = this.sdkUserId;
            channelInfo.isSupportRecordShare = false;
            channelInfo.isShareEnabled = !!config.i_sdk_share_mode;
            channelInfo.copChannelId = config.s_sdk_cop_channel_id;
            channelInfo.isPayEnabled = !!config.i_sdk_pay_mode;
            channelInfo.isUseSdkRank = !!config.i_sdk_sdk_rank_mode;
            channelInfo.isSupportInstallShortcut = true;
            channelInfo.appName = "oppoqg";
            channelInfo.isSupportJumpList = true;
            channelInfo.jumpInfo = this.getJumpInfo();
            channelInfo.referenceBannerHeight = 110;
            channelInfo.payInfo = config.t_sdk_oppoqg_pay_code || {};
            channelInfo.getChannelOpenIdFunc = this.getChannelOpenIdFunc.bind(this);
            let options = qg$e.getLaunchOptionsSync();
            let referrerInfo = options && (options.referrerInfo || {});
            if (JSON.stringify(referrerInfo) != "{}") {
                ULSdkManager.getInstance().statisManager.setGameStartSourceMsg(JSON.stringify(referrerInfo));
            }
            if (qg$e.getSystemInfoSync().platformVersionCode >= 1076) {
                channelInfo.isJumpLeisureEnabled = true;
            }
            else {
                channelInfo.isJumpLeisureEnabled = false;
            }
            ULLog.console.log("ULModuleOppoQg.initSdk getLaunchOptionsSync options:", options);
            ULSdkManager.getInstance().statisManager.removePreparationFlag("oppoMoreGameExtra");
            this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
        }
        initUserJumpGameInfo() {
            if (this["jumpResourceIndex"] == null || this["jumpResourceIndex"] == undefined) {
                this.setRandomJumpResourceIndex();
            }
            ULLog.console.log("ULModuleOppoQg.initUserJumpGameInfo this.jumpResourceIndex:", this["jumpResourceIndex"]);
        }
        getJumpResourceIndex() {
            let config = ULConfig.getConfig();
            if (config.i_sdk_jump_game_resource_mode == 1) {
                return this["jumpResourceIndex"];
            }
            else {
                return 0;
            }
        }
        setRandomJumpResourceIndex() {
            let config = ULConfig.getConfig();
            let jumpConfigs = config.t_sdk_oppoqg_jump_games || [];
            let jumpConfig = jumpConfigs[0];
            if (jumpConfig && jumpConfig.urls) {
                let urlsLength = jumpConfig.urls.length;
                let indexRange = urlsLength > 0 ? urlsLength - 1 : 0;
                this["jumpResourceIndex"] = ULTools.random(0, indexRange);
            }
            else {
                this["jumpResourceIndex"] = 0;
            }
            this.saveRecord();
        }
        getJumpInfo() {
            let config = ULConfig.getConfig();
            let jumpConfigs = config.t_sdk_oppoqg_jump_games;
            let jumpInfo = [];
            for (let i = 0; i < jumpConfigs.length; i++) {
                let jumpConfig = jumpConfigs[i];
                if (!jumpConfig.urls)
                    continue;
                let index = jumpConfig.index || "";
                let bReceived = this.jumpGameReceivedFlags[index] || false;
                jumpInfo.push({
                    index: jumpConfig.index,
                    url: jumpConfig.urls[this.getJumpResourceIndex()] || "",
                    rewards: jumpConfig.rewards || [],
                    bReceived: bReceived,
                });
            }
            return jumpInfo;
        }
        _hook_getStorage(key) {
            if (localStorage)
                return localStorage.getItem(key);
            return null;
        }
        _hook_setStorage(key, data) {
            if (localStorage)
                localStorage.setItem(key, data);
            return;
        }
        _hook_isSupportClipboard() {
            return true;
        }
        _hook_getClipboardData(finishCallback) {
            qg$e.getClipboardData({
                success: function (res) {
                    finishCallback(res.data);
                },
                fail: function (res) {
                    finishCallback(null);
                }
            });
        }
        _hook_setClipboardData(clipboardData, finishCallback) {
            qg$e.setClipboardData({
                data: clipboardData,
                success(res) {
                    finishCallback(true);
                },
                fail(res) {
                    finishCallback(false);
                }
            });
        }
        preOrderForSingleGame(payId, productDesc, productName, orderId, success, fail) {
            ULLog.console.log(`ULModuleOppoQg.preOrderForSingleGame token:`, payId);
            ULLog.console.log(`ULModuleOppoQg.preOrderForSingleGame orderId:`, orderId);
            let config = ULConfig.getConfig();
            let payData = config.t_sdk_oppoqg_pay_code[payId];
            if (!payData) {
                fail && fail("payId 不存在");
                return;
            }
            this.login({
                success: (token) => {
                    let timestamp = new Date().getTime();
                    let netTimeout = config.i_net_timeout;
                    let appkey = config.s_sdk_oppoqg_app_key;
                    let preOrderUrl = config.s_sdk_oppoqg_pre_order_url;
                    let privateKey = config.s_sdk_oppoqg_private_key;
                    let rsa = new RSAKey();
                    rsa.readPrivateKeyFromPEMString(privateKey);
                    let hashAlg = "sha256";
                    let params = {
                        appId: config.s_sdk_oppoqg_appid,
                        openId: token,
                        timestamp: timestamp,
                        productName: productName || payData.proName,
                        productDesc: productDesc || payData.proName,
                        count: 1,
                        price: parseInt(payData.price),
                        currency: "CNY",
                        cpOrderId: orderId,
                        appVersion: config.s_sdk_oppoqg_version_name,
                        engineVersion: qg$e.getSystemInfoSync().platformVersion
                    };
                    let signStr = `appId=${params.appId}&appVersion=${params.appVersion}&count=${params.count}&cpOrderId=${params.cpOrderId}&currency=${params.currency}&engineVersion=${params.engineVersion}&openId=${params.openId}&price=${params.price}&productDesc=${params.productDesc}&productName=${params.productName}&timestamp=${params.timestamp}`;
                    let hSig = rsa.sign(signStr, hashAlg);
                    params["sign"] = hex2b64(hSig);
                    ULTools.httpPost({
                        url: preOrderUrl,
                        postData: JSON.stringify(params),
                        timeoutMillisecond: netTimeout,
                        contentType: "application/json",
                        success: (res) => {
                            ULLog.console.log(`ULModuleOppoQg.preOrderForSingleGame timeoutMillisecond:`, res);
                            let resMsg = JSON.parse(res);
                            let code = resMsg.code;
                            if (code == "200") {
                                let orderNo = resMsg.data.orderNo;
                                let signStr = "appKey=" + appkey + "&orderNo=" + orderNo + "&timestamp=" + timestamp;
                                let hSig = rsa.sign(signStr, hashAlg);
                                let sign = hex2b64(hSig);
                                success && success(token, sign, orderNo, timestamp);
                            }
                            else {
                                fail && fail(resMsg);
                            }
                        },
                        fail: (res) => {
                            fail && fail(JSON.stringify(res));
                        }
                    });
                },
                fail: (res) => {
                    ULLog.console.log(`ULModuleOppoQg.preOrderForSingleGame login fail:`, res);
                    fail && fail(JSON.stringify(res));
                }
            });
        }
        preOrderForOnlineGame(payId, orderId, productDesc, productName, success, fail) {
            ULLog.console.log(`ULModuleOppoQg.preOrderForOnlineGame payId:`, payId);
            ULLog.console.log(`ULModuleOppoQg.preOrderForOnlineGame orderId:`, orderId);
            let config = ULConfig.getConfig();
            let payData = config.t_sdk_oppoqg_pay_code[payId];
            if (!payData) {
                fail && fail("payId 不存在");
                return;
            }
            this.login({
                success: (token) => {
                    let preOrderUrl = config.s_sdk_oppoqg_preOrder_online_url;
                    let params = {
                        mGameId: Number(config.s_sdk_megadata_game_id),
                        channel: "h5oppo",
                        orderInfo: JSON.stringify({
                            openId: token,
                            appVersion: config.s_sdk_oppoqg_version_name,
                            engineVersion: qg$e.getSystemInfoSync().platformVersion.toString(),
                            productDesc: productDesc || payData.proName,
                            productName: productName || payData.proName,
                            price: parseInt(payData.price),
                        })
                    };
                    ULTools.httpPostEncryption({
                        url: preOrderUrl,
                        postString: JSON.stringify(params),
                        timeoutMillisecond: config.i_net_timeout,
                        success: (res) => {
                            ULLog.console.log(`ULModuleOppoQg.preOrderForOnlineGame httpPost success:`, res);
                            let resMsg = JSON.parse(res);
                            let code = resMsg.code || 0;
                            if (code == 1) {
                                let preOrderData = resMsg.preOrderData || {};
                                let orderNo = preOrderData.orderNo;
                                let timestamp = preOrderData.timestamp;
                                let sign = preOrderData.sign;
                                success && success(token, sign, orderNo, timestamp);
                            }
                            else {
                                fail && fail(resMsg);
                            }
                        },
                        fail: (res) => {
                            ULLog.console.log(`ULModuleOppoQg.preOrderForOnlineGame httpPost fail:`, res);
                            fail && fail(JSON.stringify(res));
                        }
                    });
                }, fail: (res) => {
                    ULLog.console.log(`ULModuleOppoQg.preOrderForOnlineGame login fail:`, res);
                    fail && fail(JSON.stringify(res));
                }
            });
        }
        doOpenPay(isOnline, payId, productDesc, productName, orderId, success, fail) {
            ULLog.console.log(`ULModuleOppoQg.doOpenPay payId:`, payId);
            ULLog.console.log(`ULModuleOppoQg.doOpenPay orderId:`, orderId);
            let config = ULConfig.getConfig();
            let payData = config.t_sdk_oppoqg_pay_code[payId];
            if (!payData) {
                fail && fail("payId 不存在");
                return;
            }
            let preOrder = isOnline ? this.preOrderForOnlineGame.bind(this) : this.preOrderForSingleGame.bind(this);
            preOrder(payId, orderId, productDesc, productName, (token, sign, orderNo, timestamp) => {
                ULLog.console.log("ULModuleHuawei.doOpenPay preOrder success token:", token);
                ULLog.console.log("ULModuleHuawei.doOpenPay preOrder success sign:", sign);
                ULLog.console.log("ULModuleHuawei.doOpenPay preOrder success orderNo:", orderNo);
                ULLog.console.log("ULModuleHuawei.doOpenPay preOrder success timestamp:", timestamp);
                ULSdkManager.getInstance().statisManager.reportPayRequest();
                qg$e.pay({
                    appId: config.s_sdk_oppoqg_appid,
                    token: token,
                    timestamp: timestamp,
                    paySign: sign,
                    orderNo: orderNo,
                    success: function (res) {
                        ULLog.console.log(`ULModuleOppoQg.doOpenPay pay success:`, JSON.stringify(res));
                        success && success();
                    },
                    fail: function (res) {
                        let errMsg = JSON.stringify(res);
                        ULLog.console.log(`ULModuleOppoQg.doOpenPay pay fail:`, errMsg);
                        fail && fail(errMsg);
                    }
                });
            }, (errmsg) => {
                ULLog.console.log("ULModuleHuawei.doOpenPay preOrder fail errmsg:", errmsg);
                fail && fail(errmsg);
            });
        }
        onCmdUserIsLogin(e) {
            e.stopImmediatePropagation();
            ULLog.console.log(`ULModuleWeixin.onCmdUserIsLogin `);
            let data = e.data;
            let userData = data.userData || "";
            ULSdkManager.getInstance().response(ULConst.CMD_USER_IS_LOGIN_RESULT, {
                code: 1,
                userData: userData
            });
        }
        onCmdUserLogin(e) {
            e.stopImmediatePropagation();
            ULLog.console.log(`ULModuleOppoQg.onCmdUserLogin 登陆`);
            let userData = e.data.userData || "";
            let config = ULConfig.getConfig();
            this.login({
                success: (token) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_USER_LOGIN_RESULT, {
                        code: 1,
                        userData: userData,
                        loginData: {
                            mgid: Number(config.s_sdk_megadata_game_id),
                            channel: "h5oppo",
                            openId: "",
                            token: token
                        }
                    });
                }, fail: (res) => {
                    ULSdkManager.getInstance().response(ULConst.CMD_USER_LOGIN_RESULT, {
                        code: 0,
                        userData: userData
                    });
                }
            });
        }
        login(obj) {
            ULLog.console.log("ULModuleOppoQg.login start");
            qg$e.login({
                success: (res) => {
                    ULLog.console.log("ULModuleOppoQg.login success:", res);
                    obj.success(res.data.token || "");
                },
                fail: (res) => {
                    ULLog.console.log("ULModuleOppoQg.login fail：", res);
                    obj.fail(res);
                }
            });
        }
        getUserInfoData(obj) {
            if (this.userInfoData) {
                obj.success && obj.success(this.userInfoData);
                return;
            }
            let config = ULConfig.getConfig();
            this.login({
                success: (token) => {
                    ULLog.console.log("ULModuleOppoQg.getUserInfoData login success");
                    var userLoginUrl = config.s_sdk_common_login_url;
                    var postData = {
                        token: token,
                        channel: "h5oppo",
                        mgid: Number(config.s_sdk_megadata_game_id)
                    };
                    ULTools.httpPost({
                        url: userLoginUrl,
                        contentType: "application/json",
                        postData: JSON.stringify(postData),
                        timeoutMillisecond: config.i_net_timeout,
                        success: (responseText) => {
                            ULLog.console.log("ULModuleOppoQg.getUserInfoData success", responseText);
                            let resultObj = JSON.parse(responseText);
                            if (resultObj.code == 1) {
                                let openId = resultObj.openId;
                                this.userInfoData = {
                                    openId: openId,
                                    userInfo: {
                                        avatarUrl: resultObj.headImgUrl || "",
                                        nickName: resultObj.nickName || "",
                                    }
                                };
                                ULSdkManager.getInstance().channelInfo.channelUserId = openId;
                                obj.success && obj.success(this.userInfoData);
                            }
                            else {
                                ULLog.console.log("ULModuleOppoQg.getUserInfoData resultObj:", resultObj);
                                obj.fail && obj.fail(JSON.stringify(resultObj));
                            }
                        },
                        fail: (res) => {
                            ULLog.console.log("ULModuleOppoQg.getUserInfoData fail:", res);
                            obj.fail && obj.fail(JSON.stringify(res));
                        }
                    });
                },
                fail: (res) => {
                    ULLog.console.log("ULModuleOppoQg.getUserInfoData login fail:", res);
                    obj.fail && obj.fail(JSON.stringify(res));
                }
            });
        }
        onCmdOpenPay(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let payId = data.payId;
            let orderId = data.orderId;
            let userData = data.userData || "";
            let productDesc = data.productDesc;
            let productName = data.productName;
            let trimOrder = orderId || ULTools.createRandomOrderId();
            let callBack = (code, err) => {
                ULSdkManager.getInstance().response(ULConst.CMD_PAY_RESULT, {
                    code: code,
                    msg: err,
                    payId: payId,
                    userData: userData,
                });
            };
            this.doOpenPay(!!orderId, payId, productDesc, productName, trimOrder, () => {
                ULLog.console.log("ULModuleOppoQg.onCmdOpenPay doOpenPay success");
                callBack(1, "购买成功");
            }, (errmsg) => {
                ULLog.console.log("ULModuleOppoQg.onCmdOpenPay doOpenPay fail errmsg:", errmsg);
                callBack(0, errmsg);
            });
        }
        onCmdOpenJump(e) {
            this.bOpenJumpCalled = true;
            let config = ULConfig.getConfig();
            let data = e.data;
            let count = data.count || -1;
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            if (!channelInfo.isSupportJumpList) {
                ULLog.console.log("onCmdOpenJump----isSupportJumpList---不支持-");
                ULSdkManager.getInstance().response(ULConst.CMD_OPEN_JUMP_RESULT, {
                    code: 0,
                    msg: "isSupportJumpList false",
                });
                return;
            }
            ULSdkManager.getInstance().channelInfo.jumpInfo = this.getJumpInfo();
            let rawJumpInfo = ULTools.clone(ULSdkManager.getInstance().channelInfo.jumpInfo);
            let jumpInfo = [];
            let type = data.type;
            if (type == "single") {
                count = 1;
            }
            if (count == null || count <= 0) {
                count = rawJumpInfo.length;
            }
            for (let i = 0; i < rawJumpInfo.length; i++) {
                const v = rawJumpInfo[i];
                v["raw_order"] = i;
            }
            count = Math.min(count, rawJumpInfo.length);
            let single_random_length = config.i_sdk_jump_single_random_length || rawJumpInfo.length;
            for (let i = 0; i < count; i++) {
                let randLength = rawJumpInfo.length;
                if (type == "single") {
                    randLength = Math.min(Math.max(1, single_random_length), randLength);
                    single_random_length--;
                }
                let r = ULTools.random(randLength) - 1;
                let v = rawJumpInfo[r];
                rawJumpInfo.splice(r, 1);
                jumpInfo.push(v);
            }
            jumpInfo = ULTools.sortArrayByField(jumpInfo, "raw_order");
            for (let i = 0; i < jumpInfo.length; i++) {
                const v = jumpInfo[i];
                delete v["raw_order"];
            }
            ULSdkManager.getInstance().response(ULConst.CMD_OPEN_JUMP_RESULT, {
                code: 1,
                msg: "获取成功成功",
                jumpInfo: jumpInfo,
                type: type,
                userData: data.userData || "",
            });
            let sourceGameId = config.s_sdk_cop_game_id + "";
            for (let index = 0; index < jumpInfo.length; index++) {
                let jumpGameConfig = jumpInfo[index];
                let gameIndex = jumpGameConfig.index;
                let targetIconId = ULTools.format("%s_%d", gameIndex, this.getJumpResourceIndex());
                ULSdkManager.getInstance().statisManager.reportJumpGame("openJump", "oppoqg", sourceGameId, type, targetIconId);
            }
        }
        onCmdJumpOtherGame(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let gameIndex = data.gameIndex;
            let type = data.type;
            let userData = data.userData;
            let jumpGames = config.t_sdk_oppoqg_jump_games;
            let sourceGameId = config.s_sdk_cop_game_id + "";
            let targetIconId = ULTools.format("%s_%d", gameIndex, this.getJumpResourceIndex());
            if (this.bOpenJumpCalled) {
                ULSdkManager.getInstance().statisManager.reportJumpGame("jump", "oppoqg", sourceGameId, type, targetIconId);
            }
            let gameId = null;
            let rewards = null;
            for (let i = 0; i < jumpGames.length; i++) {
                const v = jumpGames[i];
                if (v.index == gameIndex) {
                    gameId = v.id;
                    rewards = v.rewards;
                    break;
                }
            }
            if (!gameId) {
                ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_RESULT, {
                    code: 0,
                    msg: "目标游戏未找到",
                    userData: userData,
                });
                if (this.bOpenJumpCalled) {
                    ULSdkManager.getInstance().statisManager.reportJumpGame("jumpFail", "oppoqg", sourceGameId, type, targetIconId);
                }
                return;
            }
            qg$e.navigateToMiniGame({
                pkgName: gameId,
                success: () => {
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_RESULT, {
                        code: 1,
                        msg: "跳转其他游戏成功",
                        userData: userData,
                    });
                    this.lastJumpRecord = {
                        gameIndex: gameIndex,
                        jumpTime: ULTools.time(),
                        type: type,
                        rewards: rewards,
                    };
                    this.saveRecord();
                },
                fail: (res) => {
                    ULLog.console.log("跳转其他游戏失败---err ", JSON.stringify(res));
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_RESULT, {
                        code: 0,
                        msg: "跳转其他游戏失败",
                        userData: userData,
                    });
                    if (this.bOpenJumpCalled) {
                        ULSdkManager.getInstance().statisManager.reportJumpGame("jumpFail", "oppoqg", sourceGameId, type, targetIconId);
                    }
                }
            });
        }
        onCmdSdkOnGameResume(e) {
            let config = ULConfig.getConfig();
            let lastJumpRecord = this.lastJumpRecord;
            if (!lastJumpRecord) {
                ULLog.console.log("ULModuleOppoQg.onCmdSdkOnGameResume 不存在上次跳转游戏");
                return;
            }
            let gameIndex = lastJumpRecord.gameIndex;
            let sourceGameId = config.s_sdk_cop_game_id + "";
            let targetIconId = ULTools.format("%s_%d", gameIndex, this.getJumpResourceIndex());
            let lastJumpTime = lastJumpRecord.jumpTime || 0;
            let now = ULTools.time();
            let bNeedUploadStatis = true;
            if (!this.bOpenJumpCalled) {
                bNeedUploadStatis = false;
            }
            let bJumpSuccess = (now - lastJumpTime) > config.i_sdk_oppoqg_jump_game_reward_time / 1000;
            if (bNeedUploadStatis) {
                if (bJumpSuccess) {
                    ULSdkManager.getInstance().statisManager.reportJumpGame("jumpSuccess", "oppoqg", sourceGameId, lastJumpRecord.type, targetIconId);
                }
                else {
                    ULSdkManager.getInstance().statisManager.reportJumpGame("jumpFail", "oppoqg", sourceGameId, lastJumpRecord.type, targetIconId);
                }
            }
            if (lastJumpRecord.type == "reward") {
                if (bJumpSuccess) {
                    if (this.jumpGameReceivedFlags[lastJumpRecord.gameIndex]) {
                        ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_REWARD_RESULT, {
                            code: 0,
                            msg: "该游戏已经发过奖",
                            rewards: lastJumpRecord.rewards || [],
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_REWARD_RESULT, {
                            code: 1,
                            msg: "跳转其他游戏成功，并达到发奖条件",
                            rewards: lastJumpRecord.rewards || [],
                        });
                        this.jumpGameReceivedFlags[gameIndex] = true;
                        this.saveRecord();
                        ULSdkManager.getInstance().channelInfo.jumpInfo = this.getJumpInfo();
                    }
                }
                else {
                    ULSdkManager.getInstance().response(ULConst.CMD_JUMP_OTHER_GAME_REWARD_RESULT, {
                        code: 0,
                        msg: "跳转其他游戏失败",
                        rewards: this.lastJumpRecord.rewards || [],
                    });
                }
            }
            this.lastJumpRecord = null;
            this.saveRecord();
        }
        onCmdSdkCollectionModuleCheckerMoreGameTestConfig(e) {
            let config = e.getReturnValue() || [];
            let text = ["A", "B", "C", "D", "E", "F"];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "更多游戏ab测试信息:" });
            config.push({
                type: "label",
                text: text[this.getJumpResourceIndex()] || this.getJumpResourceIndex().toString(),
                name: "labelMoreGameUserIndex"
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: ULTools.format("更多游戏资源状态：%s", ULConfig.getConfig().i_sdk_jump_game_resource_mode == 1 ? "随机" : "固定0") });
            config.push({ type: "newLine" });
            config.push({
                type: "button",
                text: "更改更多游戏用户AB属性",
                onClick: () => {
                    let config = ULConfig.getConfig();
                    let jumpConfigs = config.t_sdk_baidu_jump_games || [];
                    let jumpConfig = jumpConfigs[0];
                    let urlsLength = 2;
                    if (jumpConfig && jumpConfig.urls) {
                        urlsLength = jumpConfig.urls.length;
                    }
                    let conf = [];
                    for (let index = 0; index < urlsLength; index++) {
                        conf.push({
                            text: text[index] || index.toString(),
                            value: index.toString()
                        });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择AB测试用户属性：", conf, (index) => {
                        this["jumpResourceIndex"] = parseInt(index.toString());
                        let labelText = text[this.getJumpResourceIndex()] || this.getJumpResourceIndex().toString();
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelMoreGameUserIndex", labelText);
                        this.saveRecord();
                        ULSdkManager.getInstance().channelInfo.jumpInfo = this.getJumpInfo();
                    });
                }
            });
            e.setReturnValue(config, true);
        }
        onCmdGetShortcutState(e) {
            e.stopImmediatePropagation();
            if (qg$e.hasShortcutInstalled) {
                qg$e.hasShortcutInstalled({
                    success: (res) => {
                        if (res == false) {
                            ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                                state: 1,
                                bHasPrompt: true
                            });
                        }
                        else {
                            ULLog.console.log("ULModuleOppoQg.onCmdGetShortcutState.hasShortcutInstalled success true :", res);
                            ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                                state: 3,
                                bHasPrompt: true
                            });
                        }
                    },
                    fail: (err) => {
                        ULLog.console.log("ULModuleOppoQg.onCmdGetShortcutState.hasShortcutInstalled fail:", err);
                        ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                            state: 1,
                            bHasPrompt: true
                        });
                    }
                });
            }
            else {
                ULSdkManager.getInstance().response(ULConst.CMD_GET_SHORTCUT_STATE_RESULT, {
                    state: 1,
                    bHasPrompt: true
                });
            }
        }
        onCmdInstallShortcut(e) {
            e.stopImmediatePropagation();
            let config = ULConfig.getConfig();
            let data = e.data;
            let userData = data.userData;
            qg$e.hasShortcutInstalled({
                success: (res) => {
                    if (res == false) {
                        ULSdkManager.getInstance().statisManager.reportAddShortcut("0");
                        qg$e.installShortcut({
                            success: () => {
                                setTimeout(() => {
                                    qg$e.hasShortcutInstalled({
                                        success: (res) => {
                                            if (res == false) {
                                                ULLog.console.log("ULModuleOppoQg.onCmdInstallShortcut.hasShortcutInstalled 2 success false :", res);
                                                ULSdkManager.getInstance().statisManager.reportAddShortcut("2");
                                                ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                                    code: 0,
                                                    msg: "添加桌面快捷方式失败",
                                                    userData: userData,
                                                });
                                                this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                                            }
                                            else {
                                                ULSdkManager.getInstance().statisManager.reportAddShortcut("1");
                                                ULLog.console.log("ULModuleOppoQg.onCmdInstallShortcut.hasShortcutInstalled 2 success true :", res);
                                                ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                                    code: 1,
                                                    msg: "添加桌面快捷方式成功",
                                                    userData: userData,
                                                });
                                                this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                                            }
                                        },
                                        fail: (err) => {
                                            ULSdkManager.getInstance().statisManager.reportAddShortcut("2");
                                            ULLog.console.log("ULModuleOppoQg.onCmdInstallShortcut.hasShortcutInstalled 2 fail:", err);
                                            ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                                code: 0,
                                                msg: "添加桌面快捷方式失败",
                                                userData: userData,
                                            });
                                            this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                                        }
                                    });
                                }, 500);
                            },
                            fail: (err) => {
                                ULLog.console.log("ULModuleOppoQg.onCmdInstallShortcut.installShortcut fail:", err);
                                ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                                    code: 0,
                                    msg: "添加桌面快捷方式失败",
                                    userData: userData,
                                });
                                this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                            }
                        });
                    }
                    else {
                        ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                            code: 2,
                            msg: "添加桌面快捷方式成功",
                            userData: userData,
                        });
                        this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                    }
                },
                fail: (err) => {
                    ULLog.console.log("ULModuleOppoQg.onCmdInstallShortcut.hasShortcutInstalled 1 fail err:", err);
                    ULSdkManager.getInstance().response(ULConst.CMD_INSTALL_SHORTCUT_RESULT, {
                        code: 0,
                        msg: "添加桌面快捷方式失败",
                        userData: userData,
                    });
                    this.onCmdGetShortcutState(new ULEvent(ULConst.CMD_GET_SHORTCUT_STATE, {}));
                }
            });
        }
        onCmdSetVersion(e) {
            ULLog.console.log("ULModuleOppoQg.onCmdSetVersion................");
            let version = qg$e.getSystemInfoSync().platformVersion;
            ULLog.console.log("ULModuleOppoQg.onCmdSetVersion.....version: ", version);
            if (version >= 1060) {
                ULLog.console.log("ULModuleOppoQg.onCmdSetVersion........数据正在上报");
                qg$e.reportMonitor("game_scene", 0);
            }
            else {
                ULLog.console.log("ULModuleOppoQg.onCmdSetVersion........平台版本号低于1060，请升级平台");
            }
        }
        onCmdSdkMarkManualCloseBannerCount(e) {
            this.tryDailyReset();
            this.manualCloseBannerCount++;
            ULLog.console.log("ULModuleOppoQg.onCmdSdkMarkManualCloseBannerCount", this.manualCloseBannerCount);
            this.saveRecord();
        }
        onCmdSdkGetManualCloseBannerCount(e) {
            this.tryDailyReset();
            ULLog.console.log("ULModuleOppoQg.onCmdSdkGetManualCloseBannerCount", this.manualCloseBannerCount);
            e.setReturnValue(this.manualCloseBannerCount);
        }
        onCmdPhoneVibrate(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            if (!qg$e.vibrateShort || !qg$e.vibrateShort) {
            }
            let type = data.type || "short";
            switch (type) {
                case "long":
                    this.vibrateLong(data);
                    break;
                default:
                    this.vibrateShort(data);
                    break;
            }
        }
        vibrateShort(data) {
            qg$e.vibrateShort({
                success: () => {
                    this.responsePhoneVibrate(1, "success", data);
                },
                fail: () => {
                    this.responsePhoneVibrate(0, "fail", data);
                },
                complete: () => {
                }
            });
        }
        vibrateLong(data) {
            qg$e.vibrateLong({
                success: () => {
                    this.responsePhoneVibrate(1, "success", data);
                },
                fail: () => {
                    this.responsePhoneVibrate(0, "fail", data);
                },
                complete: () => {
                }
            });
        }
        responsePhoneVibrate(code, msg, data) {
            ULSdkManager.getInstance().response(ULConst.CMD_PHONE_VIBRATE_RESULT, {
                code: code,
                msg: msg,
                userData: data.userData,
                type: data.type,
                intensity: data.intensity
            });
        }
        getChannelOpenIdFunc(callback) {
            ULLog.console.log("ULModuleOppoQg.getChannelOpenIdFunc");
            this.getUserInfoData({
                success: (userInfoData) => {
                    callback && callback(userInfoData.openId, null);
                },
                fail: (err) => {
                    callback && callback(null, JSON.stringify(err));
                }
            });
        }
        onCmdGetUserInfo(e) {
            e.stopImmediatePropagation();
            let data = e.data;
            let userData = data.userData || "";
            this.getUserInfoData({
                success: (userInfoData) => {
                    ULLog.console.log("ULModuleOppoQg.onCmdGetUserInfo success:", userInfoData);
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_INFO_MSG_RESULT, {
                        code: 1,
                        msg: "获取用户信息成功",
                        userData: userData,
                        userInfo: userInfoData.userInfo
                    });
                },
                fail: (err) => {
                    ULLog.console.log("ULModuleOppoQg.onCmdGetUserInfo fail:", err);
                    ULSdkManager.getInstance().response(ULConst.CMD_GET_USER_INFO_MSG_RESULT, {
                        code: 0,
                        msg: JSON.stringify(err),
                        userData: userData
                    });
                }
            });
        }
    }

    class ULSdkModuleLoader {
        static getObjectByModuleName(moduleName) {
            return ULSdkModuleLoader.moduleName_2_object[moduleName];
        }
        static getSubAdModuleClassName() {
            return ULSdkModuleLoader.moduleName_2_subAdvModuleClassName;
        }
        static getSubAdMainClassName() {
            return ULSdkModuleLoader.moduleName_2_subAdvMainClassName;
        }
        static initAllModules() {
            let modules = [];
            modules.push(new ULModuleCdk());
            modules.push(new ULModuleMegadata());
            modules.push(new ULModuleUserData());
            modules.push(new ULModuleClipboard());
            modules.push(new ULModuleDefault());
            modules.push(new ULModuleOppoQg());
            modules.push(new ULModulePrivacyPolicy());
            for (let i = 0, len = modules.length; i < len; i++) {
                const module = modules[i];
                let moduleClassName = module.className;
                ULSdkModuleLoader.moduleName_2_subAdvModuleClassName[moduleClassName] = module.getSubAdModuleClassName();
                ULSdkModuleLoader.moduleName_2_subAdvMainClassName[moduleClassName] = module.getAdMainClassName();
            }
            ULLog.console.log("ULSdkModuleLoader-moduleName_2_subAdvModuleClassName:", ULSdkModuleLoader.moduleName_2_subAdvModuleClassName);
            ULLog.console.log("ULSdkModuleLoader-moduleName_2_subAdvMainClassName:", ULSdkModuleLoader.moduleName_2_subAdvMainClassName);
            for (let i = 0; i < modules.length; i++) {
                const module = modules[i];
                let subModules = module.loadSubModules();
                for (let j = 0; j < subModules.length; j++) {
                    const subModule = subModules[j];
                    modules.splice(i + 1, 0, subModule);
                    i++;
                }
            }
            ULLog.console.log("ULSdkModuleLoader--modules:", modules);
            for (let i = 0; i < modules.length; i++) {
                const module = modules[i];
                ULSdkModuleLoader.moduleName_2_object[module.className] = module;
                try {
                    ULLog.console.log("ULSdkModuleLoader--module.init:", module);
                    module.init();
                }
                catch (error) {
                    ULLog.console.error(error);
                }
            }
            return modules;
        }
    }
    ULSdkModuleLoader.moduleName_2_object = {};
    ULSdkModuleLoader.moduleName_2_subAdvModuleClassName = {};
    ULSdkModuleLoader.moduleName_2_subAdvMainClassName = {};

    class ULWaitTool {
        constructor() {
            this.conditionMap = {};
        }
        ok() {
            if (ULTools.getObjSize(this.conditionMap) <= 0)
                return true;
            return false;
        }
        getConditionMap() {
            let flags = [];
            ULTools.forEachMap(this.conditionMap, (k, v) => {
                flags.push(k);
            });
            return flags;
        }
        addCondition(key) {
            this.conditionMap[key] = true;
        }
        removeCondition(key) {
            delete this.conditionMap[key];
        }
    }

    class ULChannelInfo {
        constructor() {
            this.waits = null;
            this._agreePrivacyPolicyCallBackList = [];
            this._isAgreePrivacyPolicy = false;
            this.copInfo = "{}";
            this.payInfo = {};
            this.jumpInfo = [];
            this.isSupportRecordShare = false;
            this.channelName = "default";
            this.isPayEnabled = false;
            this.isShareEnabled = false;
            this.isUseSdkRank = false;
            this.isShowUrlAdIcon = false;
            this.appName = "";
            this.equipmentModel = "";
            this.platformVersionMessage = "";
            this.osVersionMessage = "";
            this.cardType = 0;
            this.isThirdExit = false;
            this.isAbout = false;
            this.isMoreGame = false;
            this.isULMoreGame = false;
            this.isSupportClipboardData = false;
            this.isSupportInstallShortcut = false;
            this.isSupportFindMinigames = false;
            this.findMinigamesImageUrl = "";
            this.isSupportRecommendationBtn = false;
            this.isSupportJumpList = false;
            this.is4399Watermark = false;
            this.uuid = "";
            this.sdcardPath = "";
            this.packageVersion = "";
            this.copChannelId = "";
            this.ulsdkVersion = "";
            this.cdkChannelId = "";
            this._channelUserId = "";
            this.referenceBannerHeight = ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT;
            this.isNewUser = true;
            this.loginDays = 0;
            this._sdkUserId = "";
            this.isSupportPasterAdv = false;
            this.gameLanguage = "";
            this.isSupportChannelMoreGameBox = false;
            this.isSupportChannelBlockAd = false;
            this.isSupportSubscribe = false;
            this.isSupportColorSign = false;
            this.isSupportGridAd = false;
            this.isSupportVideoRank = false;
            this.isSupportFavoriteGuide = false;
            this.isSupportFollowOfficialAccount = false;
            this.appIdOrPkgName = "";
            this.isSupportContentSecurityCheck = false;
            this.isJumpLeisureEnabled = false;
            this.isSupportVibrate = true;
            this.isSupportOpenUrl = false;
            this.isSupportJumpInfoVideoType = false;
            this.isSupportUserCloudStorage = false;
            this.isSupportJoinGroup = false;
            this.isSupportOpenData = false;
            this.weixinIOSPayEnabled = false;
            this.isSupportHeadlineImRank = false;
            this.isSupportLaunchReward = false;
            this.getChannelOpenIdFunc = null;
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, ULConst.PRIORITY_NONE, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
            this.waits = new ULWaitTool();
        }
        onAgreePrivacyPolicy(callback) {
            if (this._isAgreePrivacyPolicy) {
                callback();
                return;
            }
            this._agreePrivacyPolicyCallBackList.push(callback);
        }
        get isAgreePrivacyPolicy() {
            return this._isAgreePrivacyPolicy;
        }
        set isAgreePrivacyPolicy(v) {
            if (this._isAgreePrivacyPolicy)
                return;
            this._isAgreePrivacyPolicy = v;
            if (this._isAgreePrivacyPolicy) {
                while (this._agreePrivacyPolicyCallBackList.length > 0) {
                    let callback = this._agreePrivacyPolicyCallBackList.shift();
                    callback();
                }
            }
        }
        set channelUserId(v) {
            if (this._channelUserId == v)
                return;
            this._channelUserId = v;
            if (!!this._channelUserId) {
                setTimeout(() => {
                    ULSdkManager.getInstance().statisManager.reportUserChannelId(this._channelUserId);
                }, 1000);
            }
        }
        get channelUserId() {
            return this._channelUserId;
        }
        toBaseChannelInfoData() {
            let config = ULConfig.getConfig();
            ULLog.console.log("config", config);
            let licenceInfo = config.s_sdk_licence_info == undefined ? "" : config.s_sdk_licence_info;
            licenceInfo = licenceInfo.replace(/\/n/g, "\n");
            let isShowAgeLevelInfo = !!config.i_sdk_age_level_info_mode;
            let ageLevelInfo = config.s_sdk_age_level_info || "";
            let result = {
                gameName: config.s_game_name,
                gameId: config.s_sdk_cop_game_id,
                gameLanguage: this.gameLanguage,
                channelName: this.channelName,
                appName: this.appName,
                isShowLicenceInfo: config.i_sdk_licence_info_mode == 1,
                licenceInfo: licenceInfo,
                isShowAgeLevelInfo: isShowAgeLevelInfo,
                isStartGameByTouch: config.i_sdk_start_game_by_touch == 1,
                isSupportUserCloudStorage: this.isSupportUserCloudStorage,
            };
            if (ageLevelInfo) {
                result['ageLevelInfo'] = ageLevelInfo;
            }
            return result;
        }
        toResponseData() {
            let jumpInfo = [];
            for (let i = 0; i < this.jumpInfo.length; i++) {
                const v = this.jumpInfo[i];
                if (!v.index || !v.url) {
                    ULLog.console.warn("ULChannelInfo.toResponseData jump data error!", v);
                    continue;
                }
                jumpInfo.push({
                    index: v.index,
                    url: v.url,
                    rewards: v.rewards || [],
                    bReceived: v.bReceived || false,
                    appName: v.appName || ""
                });
            }
            let config = ULConfig.getConfig();
            if (config.i_sdk_adv_reference_banner_height != null) {
                this.referenceBannerHeight = config.i_sdk_adv_reference_banner_height;
            }
            this.isJumpLeisureEnabled = this.isJumpLeisureEnabled && !!config.i_sdk_moreWonderful_mode;
            this.isSupportInstallShortcut = this.isSupportInstallShortcut && !!config.i_sdk_installShortcut_mode;
            this.isSupportRecommendationBtn = this.isSupportRecommendationBtn && !!config.i_sdk_moregame_mode;
            this.isSupportJumpList = this.isSupportJumpList && !!config.i_sdk_jumplist_mode;
            this.isSupportVibrate = this.isSupportVibrate && !!config.i_sdk_phone_vibrate;
            this.isSupportOpenUrl = this.isSupportOpenUrl && !!config.i_sdk_support_open_url;
            this.isSupportRecordShare = this.isSupportRecordShare && !!config.i_sdk_support_record_share;
            this.isSupportSubscribe = this.isSupportSubscribe && !!config.i_sdk_subscribe_mode;
            this.isSupportJoinGroup = this.isSupportJoinGroup && !!config.i_sdk_joinGroup_mode;
            this.isPayEnabled = this.isPayEnabled && !!config.i_sdk_pay_mode;
            this.isShareEnabled = this.isShareEnabled && !!config.i_sdk_share_mode;
            this.isSupportLaunchReward = this.isSupportLaunchReward && !!config.i_sdk_launchReward_mode;
            if (this.weixinIOSPayEnabled) {
                this.isPayEnabled = this.weixinIOSPayEnabled && !!config.i_sdk_pay_mode && !!config.i_sdk_weixin_iosPay_mode;
            }
            return {
                copInfo: this.copInfo,
                cardType: this.cardType,
                isThirdExit: this.isThirdExit,
                isAbout: this.isAbout,
                payInfo: this.payInfo,
                isMoreGame: this.isMoreGame,
                isULMoreGame: this.isULMoreGame,
                uuid: this.uuid,
                sdcardPath: this.sdcardPath,
                packageVersion: this.packageVersion,
                copChannelId: this.copChannelId,
                ulsdkVersion: this.ulsdkVersion,
                isShowUrlAdIcon: this.isShowUrlAdIcon,
                cdkChannelId: this.cdkChannelId,
                isPayEnabled: this.isPayEnabled,
                isShareEnabled: this.isShareEnabled,
                isUseSdkRank: this.isUseSdkRank,
                isSupportRecordShare: this.isSupportRecordShare,
                isSupportInstallShortcut: this.isSupportInstallShortcut,
                isSupportClipboardData: this.isSupportClipboardData,
                isSupportFindMinigames: this.isSupportFindMinigames,
                findMinigamesImageUrl: this.findMinigamesImageUrl,
                isSupportRecommendationBtn: this.isSupportRecommendationBtn,
                isSupportJumpList: this.isSupportJumpList,
                is4399Watermark: this.is4399Watermark,
                appName: this.appName.toLocaleLowerCase(),
                jumpInfo: jumpInfo,
                channelUserId: this.channelUserId,
                referenceBannerHeight: this.referenceBannerHeight,
                isNewUser: this.isNewUser,
                loginDays: this.loginDays,
                isSupportPasterAdv: this.isSupportPasterAdv,
                gameLanguage: this.gameLanguage,
                isSupportChannelMoreGameBox: this.isSupportChannelMoreGameBox,
                isSupportChannelBlockAd: this.isSupportChannelBlockAd,
                isSupportSubscribe: this.isSupportSubscribe,
                isSupportGridAd: this.isSupportGridAd,
                isSupportVideoRank: this.isSupportVideoRank,
                isSupportFavoriteGuide: this.isSupportFavoriteGuide,
                isSupportFollowOfficialAccount: this.isSupportFollowOfficialAccount,
                customerServiceInfo: config.t_customer_service_info,
                appIdOrPkgName: this.appIdOrPkgName,
                isSupportContentSecurityCheck: this.isSupportContentSecurityCheck,
                isJumpLeisureEnabled: this.isJumpLeisureEnabled,
                isSupportVibrate: this.isSupportVibrate,
                isSupportOpenUrl: this.isSupportOpenUrl,
                isSupportJumpInfoVideoType: this.isSupportJumpInfoVideoType,
                isSupportUserCloudStorage: this.isSupportUserCloudStorage,
                isSupportJoinGroup: this.isSupportJoinGroup,
                isSupportHeadlineImRank: this.isSupportHeadlineImRank,
                isSupportOpenData: this.isSupportOpenData,
                isSupportLaunchReward: this.isSupportLaunchReward
            };
        }
        isReady() {
            return this.waits.ok();
        }
        getPreparationFlags() {
            return this.waits.getConditionMap();
        }
        addPreparationFlag(key) {
            this.waits.addCondition(key);
        }
        removePreparationFlag(key) {
            this.waits.removeCondition(key);
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "渠道信息:" });
            config.push({ type: "newLine" });
            let text = "";
            let data = this.toResponseData();
            let keys = Object.keys(data);
            keys.sort();
            for (let i = 0; i < keys.length; i++) {
                const key = keys[i];
                let value = data[key];
                text += ULTools.format("[%s] = [%s]\n", key, JSON.stringify(value));
            }
            config.push({ type: "labelArea", text: text });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }

    class MCConsts {
    }
    MCConsts.COP_CITY_ID_2_NAME = {
        "": "关闭城市模拟",
    };

    class ULCopManager {
        constructor() {
            this.localCop = {};
            this.serverCop = {};
            this.cop = {};
            this.copStrategySetting = {};
            this.simulateCityId = "";
            this.simulateTemplateId = "";
            this.useCopStrategyName = "";
        }
        init() {
            this.loadRecord();
            let config = ULConfig.getConfig();
            this.localCop = config.t_sdk_cop_default_cop;
            this.localCop = ULTools.jsonValToStr(this.localCop);
            ULLog.console.log(`ULCopManager-init-localCop:${JSON.stringify(this.localCop)}`);
            this.processCop();
            this.requestServerCop(false);
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, 10, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.useCopStrategyName = record.useCopStrategyName || "";
            this.setSimulateCityId(record.simulateCityId || "");
            this.setSimulateTemplateId(record.simulateTemplateId || "");
        }
        saveRecord() {
            let record = {
                simulateCityId: this.simulateCityId || "",
                simulateTemplateId: this.simulateTemplateId || "",
                useCopStrategyName: this.useCopStrategyName || ""
            };
            let recordStr = JSON.stringify(record);
            ULStorageManager.getInstance().setStorage(this._getRecordKey(), recordStr);
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULCopManager_record_%d", config.s_sdk_megadata_game_id);
        }
        requestServerCop(bRetry) {
            let config = ULConfig.getConfig();
            if (!config.s_sdk_cop_game_id || config.s_sdk_cop_game_id == '0') {
                ULLog.console.log("禁用cop");
                return;
            }
            if (!bRetry) {
                ULSdkManager.getInstance().channelInfo.addPreparationFlag("cop");
            }
            let cop_addr = config.s_sdk_cop_addr;
            if (!cop_addr) {
                ULLog.console.log("cop地址为空");
                return;
            }
            let cop_game_id = config.s_sdk_cop_game_id;
            let cop_channel_id = config.s_sdk_cop_channel_id;
            let cop_version = config.s_sdk_cop_version;
            let uid = ULSdkManager.getInstance().channelInfo._sdkUserId;
            var reg = RegExp(/^[0-9a-zA-Z_]{1,}$/);
            if (!reg.test(uid)) {
                uid = "";
            }
            let netTimeout = config.i_net_timeout;
            let copUrl = ULTools.format("%s?gameid=%d&qudao=%d&version=%d&uid=%s", cop_addr, cop_game_id, cop_channel_id, cop_version, uid);
            if (this.simulateCityId || this.simulateTemplateId) {
                ULLog.console.warn("使用debug模式cop地址");
                copUrl = copUrl.replace("getdata/", "getdatadebug");
                if (this.simulateCityId) {
                    copUrl += "&carrierid=0&zoneid=" + this.simulateCityId;
                }
                if (this.simulateTemplateId) {
                    copUrl += "&templateId=" + this.simulateTemplateId;
                }
            }
            ULLog.console.log("ULCopManager.requestServerCop:", copUrl);
            ULTools.httpGet({
                url: copUrl,
                timeoutMillisecond: netTimeout,
                success: (responseText) => {
                    let copJsonData = null;
                    try {
                        copJsonData = JSON.parse(responseText);
                        ULSdkManager.getInstance().statisManager.reportCopSuccess(responseText);
                    }
                    catch (error) {
                        ULLog.console.error(error);
                        ULSdkManager.getInstance().statisManager.reportCopFail(error.message);
                    }
                    ULLog.console.log("copJsonData", copJsonData);
                    if (copJsonData) {
                        this.serverCop = copJsonData;
                    }
                    else {
                        this.serverCop = {};
                    }
                    this.processCop();
                    this.triggerCopInfoResult();
                    if (!bRetry) {
                        ULSdkManager.getInstance().channelInfo.removePreparationFlag("cop");
                    }
                },
                fail: (err) => {
                    ULLog.console.warn("ULCopManager.requestServerCop http fail!", err);
                    if (!bRetry) {
                        ULSdkManager.getInstance().channelInfo.removePreparationFlag("cop");
                    }
                    ULSdkManager.getInstance().statisManager.reportCopFail("timeout");
                    ULTimer.callLater(ULConst.COP_RETRY_TIME_SEC, () => {
                        ULLog.console.log(ULTools.format("ULCopManager.requestServerCop 失败后，等待%d秒重新请求cop", ULConst.COP_RETRY_TIME_SEC));
                        this.requestServerCop(true);
                    });
                },
            });
        }
        processCop() {
            let cop = {};
            ULTools.forEachMap(this.localCop, (k, v) => {
                cop[k] = v;
            });
            ULTools.forEachMap(this.serverCop, (k, v) => {
                if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                    v = parseFloat(v);
                }
                if (k.substr(0, 2) == "t_") {
                    try {
                        v = JSON.parse(v);
                    }
                    catch (error) {
                        ULLog.console.log("processCop error --key:", k, " val:", v);
                        v = "";
                    }
                }
                cop[k] = v;
            });
            let config = ULConfig.getConfig();
            this.copStrategySetting = cop["t_sdk_cop_strategy_setting"] || config.t_sdk_cop_strategy_setting || {};
            if (this.useCopStrategyName && this.copStrategySetting[this.useCopStrategyName]) {
                let copStrategy = this.copStrategySetting[this.useCopStrategyName] || {};
                ULTools.forEachMap(copStrategy, (k, v) => {
                    if (k.substr(0, 2) == "i_" && !isNaN(parseFloat(v))) {
                        v = parseFloat(v);
                    }
                    if (k.substr(0, 2) == "t_" && typeof (v) !== "object") {
                        try {
                            v = JSON.parse(v);
                        }
                        catch (error) {
                            ULLog.console.log("processCop error --key:", k, " val:", v);
                            v = "";
                        }
                    }
                    cop[k] = v;
                });
                this.setUseStrategyName(this.useCopStrategyName);
            }
            ULLog.console.log("processCop.copresult cop:", cop);
            this.cop = cop;
            let channelInfoCop = ULTools.clone(this.cop);
            channelInfoCop["cop_game_id"] = config.s_sdk_cop_game_id || "unknown";
            channelInfoCop["cop_channel_id"] = config.s_sdk_cop_channel_id || "unknown";
            channelInfoCop["cop_version"] = config.s_sdk_cop_version || "unknown";
            ULSdkManager.getInstance().channelInfo.copInfo = JSON.stringify(channelInfoCop);
            ULConfig.updateValueByCop(this.cop);
            ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_ON_COP_CHANGED, {});
        }
        get(key, defaultValue) {
            let value = this.cop[key];
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
        getNumberValue(key, defaultValue) {
            let value = this.get(key, defaultValue);
            let numberValue = parseFloat(value);
            if (isNaN(numberValue))
                return 0;
            return numberValue;
        }
        getNumberValueInRange(key, defaultValue, minValue, maxValue) {
            let value = this.getNumberValue(key, defaultValue);
            value = ULTools.clampf(value, minValue, maxValue);
            return value;
        }
        getBooleanValue(key, defaultValue) {
            let value = this.get(key, defaultValue);
            return value == true;
        }
        setSimulateCityId(cityId) {
            this.simulateCityId = cityId;
            this.saveRecord();
            if (cityId != "") {
                let debugInfo = ULTools.format("已开启COP调试模式，模拟城市：%s_%s", cityId, ULConfig.getConfig().t_sdk_cop_simulate_city_data[cityId]);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop");
            }
        }
        setSimulateTemplateId(templateId) {
            this.simulateTemplateId = templateId;
            this.saveRecord();
            if (templateId != "") {
                let debugInfo = ULTools.format("已开启COP调试模式，模板id：%s", templateId);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop_templateId", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop_templateId");
            }
        }
        setUseStrategyName(useCopStrategyName) {
            this.useCopStrategyName = useCopStrategyName;
            this.saveRecord();
            if (useCopStrategyName != "") {
                let debugInfo = ULTools.format("已选择COP策略，策略名：%s", useCopStrategyName);
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("cop_useCopStrategyName", debugInfo);
            }
            else {
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("cop_useCopStrategyName");
            }
        }
        triggerCopInfoResult() {
            let referenceBannerHeight = ULConst.DEFAULT_REFERANCE_BANNER_HEIGHT;
            let config = ULConfig.getConfig();
            if (config.i_sdk_adv_reference_banner_height != null) {
                referenceBannerHeight = config.i_sdk_adv_reference_banner_height;
            }
            ULSdkManager.getInstance().response(ULConst.CMD_COP_INFO_RESULT, {
                copInfo: ULSdkManager.getInstance().channelInfo.copInfo,
                referenceBannerHeight: referenceBannerHeight,
            });
        }
        onCmdSdkCollectionModuleCheckerConfig(e) {
            let config = e.getReturnValue() || [];
            let cityId_2_name = ULTools.clone(MCConsts.COP_CITY_ID_2_NAME);
            let cConfig = ULConfig.getConfig();
            if (cConfig.t_sdk_cop_simulate_city_data) {
                ULLog.console.log("t_sdk_cop_simulate_city_data", cConfig.t_sdk_cop_simulate_city_data);
                ULTools.forEachMap(cConfig.t_sdk_cop_simulate_city_data, (k, v) => {
                    cityId_2_name[k] = v;
                });
            }
            ULLog.console.log("cityId_2_name", cityId_2_name);
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "Cop模块信息:" });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "Cop策略选择:" });
            config.push({ type: "label", name: "labelUseCopStrategyName", text: "(" + (this.useCopStrategyName || "已关闭") + ")" });
            config.push({
                type: "button",
                text: "策略选择",
                onClick: () => {
                    let conf = [{ text: "关闭", value: "" }];
                    for (let key in this.copStrategySetting) {
                        conf.push({ text: key, value: key });
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择策略", conf, (value) => {
                        this.useCopStrategyName = value;
                        this.saveRecord();
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelUseCopStrategyName", this.useCopStrategyName || "已关闭");
                        if (value) {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已打开cop 策略，将在下次启动游戏时生效");
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已关闭cop 策略，将在下次启动游戏时生效");
                        }
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cop调试模式 模板id：" });
            config.push({
                type: "label",
                text: this.simulateTemplateId ? ULTools.format("%s(已开启) ", this.simulateTemplateId) : "已关闭 ",
                name: "labelCopTemplate",
            });
            config.push({
                type: "inputBox",
                name: "inputCopTemplate"
            });
            config.push({
                type: "button",
                text: "切换开关",
                onClick: () => {
                    let templateId = "";
                    if (this.simulateTemplateId) {
                        templateId = "";
                    }
                    else {
                        templateId = ULSdkManager.getInstance().moduleCheckerManager.getItemText("inputCopTemplate");
                        if (!templateId) {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("请先设置 模板id");
                            return;
                        }
                    }
                    this.setSimulateTemplateId(templateId);
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCopTemplate", templateId ? ULTools.format("%s(已开启) ", templateId) : "已关闭 ");
                    ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已开启cop调试模式，策略将在下次启动游戏时生效");
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "cop调试模式 城市id：" });
            config.push({
                type: "label",
                text: ULTools.format("%s_%s", this.simulateCityId, cityId_2_name[this.simulateCityId]),
                name: "labelCopCity",
            });
            config.push({
                type: "button",
                text: "选择城市..",
                onClick: () => {
                    let keys = Object.keys(cityId_2_name);
                    let ids = [];
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let id = parseInt(key);
                        if (!isNaN(id)) {
                            ids.push(id);
                        }
                    }
                    ids.sort((a, b) => {
                        return a - b;
                    });
                    ids.unshift("");
                    let conf1 = [];
                    for (let i = 0; i < Math.min(15, ids.length); i++) {
                        const cityId = ids[i];
                        conf1.push({ text: ULTools.format("%s_%s", cityId, cityId_2_name[cityId]), value: cityId });
                    }
                    conf1.push({ text: "加载其他城市...", "value": "more" });
                    let conf2 = [];
                    for (let i = 0; i < ids.length; i++) {
                        const cityId = ids[i];
                        conf2.push({ text: ULTools.format("%s_%s", cityId, cityId_2_name[cityId]), value: cityId });
                    }
                    let fOnSelectCity = (cityId) => {
                        if (cityId == "more") {
                            ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择需要模拟的城市：", conf2, fOnSelectCity);
                            return;
                        }
                        ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCopCity", ULTools.format("%s_%s", cityId, cityId_2_name[cityId]));
                        this.setSimulateCityId(cityId);
                        if (cityId != "") {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已开启cop调试模式，策略将在下次启动游戏时生效");
                        }
                        else {
                            ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("cop调试模式已关闭");
                        }
                    };
                    ULSdkManager.getInstance().moduleCheckerManager.showPickerDialog("选择需要模拟的城市：", conf1, fOnSelectCity);
                },
            });
            config.push({
                type: "button",
                text: "重新请求cop",
                onClick: () => {
                    ULSdkManager.getInstance().moduleCheckerManager.alertPrompt("温馨提示", "重新请求cop不能保证所有功能生效，仅供查看cop使用。切换cop城市模拟后，请重新启动游戏测试功能", "知道了", () => {
                        ULSdkManager.getInstance().moduleCheckerManager.showMsgTip("已重新请求cop，不能保证所有功能生效");
                        this.requestServerCop(false);
                    });
                },
            });
            config.push({ type: "newLine" });
            config.push({ type: "label", text: "查看cop：" });
            config.push({
                type: "button",
                text: "默认cop",
                onClick: () => {
                    let cop = this.localCop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "默认cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({
                type: "button",
                text: "远程cop",
                onClick: () => {
                    let cop = this.serverCop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "远程cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({
                type: "button",
                text: "生效cop",
                onClick: () => {
                    let cop = this.cop;
                    let keys = Object.keys(cop);
                    keys.sort();
                    let copInfo = "生效cop：\n";
                    for (let i = 0; i < keys.length; i++) {
                        const key = keys[i];
                        let value = cop[key];
                        copInfo += ULTools.format("[%s] = [%s]\n", key, value);
                    }
                    ULSdkManager.getInstance().moduleCheckerManager.setItemText("labelCop", copInfo);
                },
            });
            config.push({ type: "newLine" });
            config.push({
                type: "labelArea",
                text: "<<这里显示cop信息>>",
                name: "labelCop",
            });
            config.push({ type: "newLine" });
            e.setReturnValue(config, true);
        }
    }

    class ULStatisEventId {
    }
    ULStatisEventId.OPEN_SHARE = "100";
    ULStatisEventId.CLICK_SHARE = "101";
    ULStatisEventId.ADD_SUBSCRIPTION = "102";
    ULStatisEventId.CLICK_SUBSCRIPTION = "103";
    ULStatisEventId.CLICK_MORE_GAME_ICON_SINGLE = "104";
    ULStatisEventId.CLICK_MORE_GAME_ICON_REWARD = "105";
    ULStatisEventId.CLICK_MORE_GAME_ICON_LIST = "106";
    ULStatisEventId.CDK = "107";
    ULStatisEventId.CLICK_MORE_GAME_CHANNEL_SYSTEM_BUTTON = "108";
    ULStatisEventId.NATIVE_ADV_CLICK_EVENT = "109";
    ULStatisEventId.WEIXIN_TOUFANG = "200";
    ULStatisEventId.IOS_USERID_EVENT = "201";
    ULStatisEventId.REAL_NAME_AUTHENTICATION = "202";
    ULStatisEventId.LOGIN_EVENT = "203";
    ULStatisEventId.GAME_PACK_EVENT = "204";
    ULStatisEventId.INSTALLATION_SOURCE = "205";
    ULStatisEventId.OPPO_CUSTOM_EVENT = "206";
    ULStatisEventId.LAUNCH_SCENE = "300";
    ULStatisEventId.ADD_SHORTCUT = "301";
    ULStatisEventId.ADD_FAVORITES = "302";
    ULStatisEventId.NATIVE_ADV_DATA_UPLOAD_EVENT = "888";

    class ULStatisManager {
        constructor() {
            this.bUploading = false;
            this.lastTimerLoopTime = null;
            this.isGamePause = false;
            this.pointEventLog = {};
            this.pointEventCategoryId_2_enabled = null;
            this.gameStartDataPreparationFlags = {};
            this.commonEventLog = {};
            this.levelStartLog = {};
            this.levelCompletetLog = {};
            this.videoPointLog = {};
            this.buyActionLog = {};
            this.coinChangeLog = {};
        }
        init() {
            this.channelInfoUuid = ULSdkManager.getInstance().channelInfo.uuid;
            this.megadataId = ULConfig.getConfig().s_sdk_megadata_server_type_id;
            this.loadRecord();
            ULTimer.callLoop(ULConfig.getConfig().i_sdk_megadata_upload_span / 1000, this.onTimerLoop.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_START, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameStart.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_PAUSE, ULConst.PRIORITY_NONE, this.onCmdSdkOnGamePause.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_GAME_RESUME, ULConst.PRIORITY_NONE, this.onCmdSdkOnGameResume.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_ON_COP_CHANGED, ULConst.PRIORITY_NONE, this.onCmdSdkOnCopChanged.bind(this));
            ULEventDispatcher.getInstance().addListener(ULConst.CMD_SDK_COLLECTION_MODULE_CHECKER_CONFIG, 9, this.onCmdSdkCollectionModuleCheckerConfig.bind(this));
        }
        loadRecord() {
            let recordStr = ULStorageManager.getInstance().getStorage(this._getRecordKey()) || "{}";
            let record;
            try {
                record = JSON.parse(recordStr);
            }
            catch (error) {
                record = {};
            }
            this.cacheItems = record.cacheItems || [];
            let mode = record.postMegadataTestMode || 0;
            this.postMegadataTestUserId = record.postMegadataTestUserId;
            this.setPostMegadataMode(mode);
        }
        saveRecord() {
            let record = {
                cacheItems: this.cacheItems || [],
                postMegadataTestUserId: this.postMegadataTestUserId,
                postMegadataTestMode: this.postMegadataTestMode
            };
            let recordStr = JSON.stringify(record);
            ULStorageManager.getInstance().setStorage(this._getRecordKey(), recordStr);
        }
        _getRecordKey() {
            let config = ULConfig.getConfig();
            return ULTools.format("ULStatisManager_record_%d", config.s_sdk_megadata_game_id);
        }
        onTimerLoop(timer) {
            if (this.cacheItems.length <= 0) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.onTimerLoop no cacheItems");
                return;
            }
            this.tryUploadToServer();
        }
        setPostMegadataMode(mode) {
            this.postMegadataTestMode = mode;
            this.saveRecord();
            if (!!this.postMegadataTestMode) {
                this.channelInfoUuid = this.postMegadataTestUserId;
                let debugInfo = "数据上传已开启测试模式\n测试用户id:" + this.postMegadataTestUserId;
                ULSdkManager.getInstance().moduleCheckerManager.addDebugInfo("postMegadataTestModeInfo", debugInfo);
            }
            else {
                this.channelInfoUuid = ULSdkManager.getInstance().channelInfo.uuid;
                ULSdkManager.getInstance().moduleCheckerManager.removeDebugInfo("postMegadataTestModeInfo");
            }
        }
        getPostMegadataMode() {
            return this.postMegadataTestMode;
        }
        _report(typeid, updata) {
            let config = ULConfig.getConfig();
            let closeIds = config.s_sdk_megadata_close_table_type_ids || "";
            let closeIdsList = closeIds.split(";");
            for (let index = 0; index < closeIdsList.length; index++) {
                let closeId = ULTools.format("%s-%s", this.megadataId, closeIdsList[index]);
                if (closeId == typeid) {
                    ULLog.console.log("ULStatisManager._report 大数据分表控制表数据上传closeId:", closeId);
                    return;
                }
            }
            ULLog.console.log("ULStatisManager._report i_sdk_megadata_mode 1 ", config.i_sdk_megadata_mode);
            try {
                let otherItem = { typeid: typeid, updata: updata };
                ULEventDispatcher.getInstance().dispatch(ULConst.CMD_SDK_ON_REPORT_ULSDK_EVENT, {
                    parameter: otherItem
                });
            }
            catch (error) {
                ULLog.console.log("ULStatisManager.CMD_SDK_ON_REPORT_ULSDK_EVENT error:", error);
            }
            if (!config.i_sdk_megadata_mode) {
                ULLog.console.log("ULStatisManager._report !i_sdk_megadata_mode 关闭统计功能");
                return;
            }
            if (!!this.postMegadataTestMode) {
                let replaceVal = this.megadataId + "-";
                typeid = typeid.replace(replaceVal, "1-");
                ULLog.console.log("ULStatisManager._report postMegadataTestMode 已打开 typeid:", typeid);
            }
            if (updata.length == 0) {
                ULLog.console.log("ULStatisManager._report !updata 无有效数据，无法上报:", updata);
                return;
            }
            for (let i = 0; i < updata.length; i++) {
                let v = updata[i];
                if (typeof (v) != "string") {
                    if (v == null) {
                        v = "";
                    }
                    else {
                        v = "" + v;
                    }
                }
                updata[i] = v;
            }
            let item = { typeid: typeid, updata: updata };
            this.cacheItems.push(item);
            if (this.cacheItems.length >= ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT) {
                this.tryUploadToServer();
            }
        }
        tryUploadToServer() {
            if (this.bUploading) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer 数据上传中");
                return;
            }
            let uploadCount = Math.min(this.cacheItems.length, ULConst.STATIS_UPLOAD_SINGLE_REQUEST_MAX_COUNT);
            if (uploadCount <= 0) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer 没有数据需要上传");
                return;
            }
            this.bUploading = true;
            let uploadItems = this.cacheItems.slice(0, uploadCount);
            this.cacheItems.splice(0, uploadCount);
            this.saveRecord();
            let config = ULConfig.getConfig();
            let url = config.s_sdk_megadata_url;
            if (!!this.postMegadataTestMode) {
                url = config.s_sdk_megadata_test_url;
            }
            if (!url) {
                if (ULConst.B_INNER_DEBUG)
                    ULLog.console.log("ULStatisManager.tryUploadToServer url为空");
                return;
            }
            if (!!config.i_sdk_megadata_encrypt) {
                ULTools.httpPostEncryption({
                    url: url,
                    postString: JSON.stringify(uploadItems),
                    timeoutMillisecond: config.i_net_timeout,
                    success: (responseText) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  加密统计上报成功!");
                        this.bUploading = false;
                    },
                    fail: (err) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  加密统计上报错误!", err);
                        this.cacheItems = uploadItems.concat(this.cacheItems);
                        this.saveRecord();
                        this.bUploading = false;
                    },
                });
                return;
            }
            let postData = "updata=" + JSON.stringify(uploadItems);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatisManager.tryUploadToServer");
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  url:", url);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  postData:", postData);
            postData = postData.replace(";", ",");
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报成功!");
                    this.bUploading = false;
                },
                fail: (err) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报错误!", err);
                    this.cacheItems = uploadItems.concat(this.cacheItems);
                    this.saveRecord();
                    this.bUploading = false;
                },
            });
        }
        uploadToServerRightNow(typeid, updata) {
            let config = ULConfig.getConfig();
            let url = config.s_sdk_megadata_url;
            if (!config.i_sdk_megadata_mode) {
                ULLog.console.log("ULStatisManager.uploadToServerRightNow !i_sdk_megadata_mode 关闭统计功能");
                return;
            }
            if (!!this.postMegadataTestMode) {
                url = config.s_sdk_megadata_test_url;
                let replaceVal = this.megadataId + "-";
                typeid = typeid.replace(replaceVal, "1-");
                ULLog.console.log("ULStatisManager.uploadToServerRightNow postMegadataTestMode 已打开 typeid:", typeid);
            }
            let item = { typeid: typeid, updata: updata };
            let uploadItems = [];
            uploadItems.push(item);
            if (!!config.i_sdk_megadata_encrypt) {
                ULTools.httpPostEncryption({
                    url: url,
                    postString: JSON.stringify(uploadItems),
                    timeoutMillisecond: config.i_net_timeout,
                    success: (responseText) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  统计上报成功!");
                    },
                    fail: (err) => {
                        if (ULConst.B_INNER_DEBUG)
                            ULLog.console.log("  统计上报错误!", err);
                    },
                });
                return;
            }
            let postData = "updata=" + JSON.stringify(uploadItems);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("ULStatisManager.uploadToServerRightNow");
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  url:", url);
            if (ULConst.B_INNER_DEBUG)
                ULLog.console.log("  postData:", postData);
            ULTools.httpPost({
                url: url,
                postData: postData,
                timeoutMillisecond: config.i_net_timeout,
                success: (responseText) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报成功!");
                },
                fail: (err) => {
                    if (ULConst.B_INNER_DEBUG)
                        ULLog.console.log("  统计上报错误!", err);
                },
            });
        }
        genPointEventLog() {
            let rawLog = this.pointEventLog;
            let arr = [];
            let arr1 = [];
            ULTools.forEachMap(rawLog, (k, v) => {
                let eventId = parseInt(k);
                arr1.push({ eventId: eventId, v: v });
            });
            arr1 = ULTools.sortArrayByField(arr1, "eventId");
            for (let i = 0; i < arr1.length; i++) {
                const v = arr1[i];
                let arr2 = [];
                ULTools.forEachMap(v.v, (k, count) => {
                    let paramId = parseInt(k);
                    arr2.push({ paramId: paramId, count: count });
                });
                arr2 = ULTools.sortArrayByField(arr2, "paramId");
                for (let j = 0; j < arr2.length; j++) {
                    const vv = arr2[j];
                    arr.push(ULTools.format("%d-%d: %d", v.eventId, vv.paramId, vv.count));
                }
            }
            return arr;
        }
        getCommonEventLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.commonEventLog;
            ULLog.console.log("ULStatisManager.getCommonEventLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getLevelStartLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.levelStartLog;
            ULLog.console.log("ULStatisManager.getLevelStartLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getLevelCompletetLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.levelCompletetLog;
            ULLog.console.log("ULStatisManager.getLevelCompletetLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d   时长：%d", key, rawLog[key].count, rawLog[key].playTime));
            }
            return arr;
        }
        getVideoPointLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.videoPointLog;
            ULLog.console.log("ULStatisManager.getVideoPointLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getBuyActionLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.buyActionLog;
            ULLog.console.log("ULStatisManager.getBuyActionLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s: %d", key, rawLog[key]));
            }
            return arr;
        }
        getCoinChangeLog() {
            let arr = [];
            let keyArr = [];
            let rawLog = this.coinChangeLog;
            ULLog.console.log("ULStatisManager.coinChangeLog rawLog:", rawLog);
            ULTools.forEachMap(rawLog, (k, v) => {
                keyArr.push(k);
            });
            keyArr.sort();
            for (let index = 0; index < keyArr.length; index++) {
                let key = keyArr[index];
                arr.push(ULTools.format("%s  次数：%d   货币数量：%d", key, rawLog[key].count, rawLog[key].changeCount));
            }
            return arr;
        }
        isReady() {
            if (ULTools.getObjSize(this.gameStartDataPreparationFlags) <= 0)
                return true;
            return false;
        }
        getPreparationFlags() {
            let flags = [];
            ULTools.forEachMap(this.gameStartDataPreparationFlags, (k, v) => {
                flags.push(k);
            });
            return flags;
        }
        addPreparationFlag(key) {
            this.gameStartDataPreparationFlags[key] = true;
        }
        removePreparationFlag(key) {
            delete this.gameStartDataPreparationFlags[key];
        }
        setGameStartSourceMsg(param) {
            this.gameStartSourceMsg = param;
        }
        reportGameStart() {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULTools.format("%s-%s", this.megadataId, ULConst.STATIS_TYPE_BASE_INFO);
            let updata = [];
            updata.push(this.gameStartTimeFormattedStr);
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push("");
            updata.push("");
            updata.push(config.s_game_name);
            updata.push(config.s_sdk_cop_game_id);
            updata.push(channelInfo.appName);
            updata.push(config.s_sdk_cop_channel_id);
            updata.push(config.s_sdk_cop_version);
            updata.push(channelInfo.osVersionMessage || "");
            updata.push("gameStart");
            updata.push("");
            updata.push(config.s_sdk_version);
            updata.push(channelInfo.equipmentModel || "");
            updata.push(this.gameStartSourceMsg);
            updata.push(channelInfo.platformVersionMessage || "");
            updata.push("");
            updata.push("");
            updata.push("");
            this._report(typeid, updata);
        }
        reportPayRequest() {
            this.reportPayResult("", "", "requestPay");
        }
        reportPaySuccess(payType, priceCent) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "success");
        }
        reportPayCancel(payType, priceCent) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "cancel");
        }
        reportPayFail(payType, priceCent) {
            let trimPriceCent = priceCent || 0;
            let strPrice = ULTools.format("%.2f", trimPriceCent / 100);
            this.reportPayResult(payType, strPrice, "failed");
        }
        reportPayResult(payType, price, result) {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULTools.format("%s-%s", this.megadataId, ULConst.STATIS_TYPE_PAY_INFO);
            let updata = [];
            updata.push(ULTools.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss"));
            updata.push(this.channelInfoUuid);
            updata.push("");
            updata.push(channelInfo.channelName);
            updata.push(payType || "");
            updata.push(price || "");
            updata.push(result || "");
            updata.push(config.s_sdk_cop_version);
            updata.push(config.s_sdk_version);
            this._report(typeid, updata);
        }
        reportAdvBranchRequest(advItem, channel, sdkAdvId) {
            advItem.statisChannelName = channel;
            advItem.statisSdkAdvId = sdkAdvId;
            this.reportAdvInfo(channel, advItem.showAdvType, "branchAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, "", sdkAdvId, "");
        }
        reportAdvTotalRequest(advItem) {
            this.reportAdvInfo("", advItem.advType, "totalAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, "", "", "");
        }
        reportAdvSuccess(advItem, nativeAdvTitle, actualShowCount = 1) {
            advItem.statisNativeAdTitle = nativeAdvTitle;
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "success", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "", actualShowCount.toString());
        }
        reportAdvClicked(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "clicked", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvPlayStart(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "playStart", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvPlayCompletion(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "playCompletion", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvRequest(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvRequest", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvSuccess(advItem) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvSuccess", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvLoadAdvFailed(advItem, failMsg) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "loadAdvFailed", failMsg, advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvFail(advItem, failMsg) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "failed", failMsg, advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, "");
        }
        reportAdvClose(advItem, advShowTimeSec) {
            this.reportAdvInfo(advItem.statisChannelName, advItem.showAdvType, "hide", "", advItem.advGroupId, advItem.advId, advItem.tag, advItem.statisNativeAdTitle, advItem.statisSdkAdvId, advShowTimeSec);
        }
        reportAdvInfo(channel, advType, result, failMsg, advGroupId, advId, advEventInfo, nativeAdvInfo, sdkAdvId, advShowTimeSec, actualShowCount = "") {
            let channelInfo = ULSdkManager.getInstance().channelInfo;
            let config = ULConfig.getConfig();
            let typeid = ULTools.format("%s-%s", this.megadataId, ULConst.STATIS_TYPE_ADV_INFO);
            let updata = [];
            if (nativeAdvInfo && nativeAdvInfo.length 