/**
 * @license bytebuffer.js (c) 2015 Daniel Wirtz <dcode@dcode.io>
 * Backing buffer: ArrayBuffer, Accessor: Uint8Array
 * Released under the Apache License, Version 2.0
 * see: https://github.com/dcodeIO/bytebuffer.js for details
 */
!function(t,e){"function"==typeof define&&define.amd?define(["long"],e):"function"==typeof require&&"object"==typeof module&&module&&module.exports?module.exports=function(){var t;try{t=require("long")}catch(t){}return e(t)}():(t.dcodeIO=t.dcodeIO||{}).ByteBuffer=e(t.dcodeIO.Long)}(this,(function(t){"use strict";var ByteBuffer=function(t,e,i){if(void 0===t&&(t=ByteBuffer.DEFAULT_CAPACITY),void 0===e&&(e=ByteBuffer.DEFAULT_ENDIAN),void 0===i&&(i=ByteBuffer.DEFAULT_NOASSERT),!i){if((t|=0)<0)throw RangeError("Illegal capacity");e=!!e,i=!!i}this.buffer=0===t?r:new ArrayBuffer(t),this.view=0===t?null:new Uint8Array(this.buffer),this.offset=0,this.markedOffset=-1,this.limit=t,this.littleEndian=e,this.noAssert=i};ByteBuffer.VERSION="5.0.1",ByteBuffer.LITTLE_ENDIAN=!0,ByteBuffer.BIG_ENDIAN=!1,ByteBuffer.DEFAULT_CAPACITY=16,ByteBuffer.DEFAULT_ENDIAN=ByteBuffer.BIG_ENDIAN,ByteBuffer.DEFAULT_NOASSERT=!1,ByteBuffer.Long=t||null;var e=ByteBuffer.prototype;e.__isByteBuffer__,Object.defineProperty(e,"__isByteBuffer__",{value:!0,enumerable:!1,configurable:!1});var r=new ArrayBuffer(0),i=String.fromCharCode;function stringSource(t){var e=0;return function(){return e<t.length?t.charCodeAt(e++):null}}function stringDestination(){var t=[],e=[];return function(){if(0===arguments.length)return e.join("")+i.apply(String,t);t.length+arguments.length>1024&&(e.push(i.apply(String,t)),t.length=0),Array.prototype.push.apply(t,arguments)}}function ieee754_read(t,e,r,i,n){var f,o,s=8*n-i-1,h=(1<<s)-1,a=h>>1,l=-7,u=r?n-1:0,g=r?-1:1,w=t[e+u];for(u+=g,f=w&(1<<-l)-1,w>>=-l,l+=s;l>0;f=256*f+t[e+u],u+=g,l-=8);for(o=f&(1<<-l)-1,f>>=-l,l+=i;l>0;o=256*o+t[e+u],u+=g,l-=8);if(0===f)f=1-a;else{if(f===h)return o?NaN:1/0*(w?-1:1);o+=Math.pow(2,i),f-=a}return(w?-1:1)*o*Math.pow(2,f-i)}function ieee754_write(t,e,r,i,n,f){var o,s,h,a=8*f-n-1,l=(1<<a)-1,u=l>>1,g=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,w=i?0:f-1,b=i?1:-1,v=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(s=isNaN(e)?1:0,o=l):(o=Math.floor(Math.log(e)/Math.LN2),e*(h=Math.pow(2,-o))<1&&(o--,h*=2),(e+=o+u>=1?g/h:g*Math.pow(2,1-u))*h>=2&&(o++,h/=2),o+u>=l?(s=0,o=l):o+u>=1?(s=(e*h-1)*Math.pow(2,n),o+=u):(s=e*Math.pow(2,u-1)*Math.pow(2,n),o=0));n>=8;t[r+w]=255&s,w+=b,s/=256,n-=8);for(o=o<<n|s,a+=n;a>0;t[r+w]=255&o,w+=b,o/=256,a-=8);t[r+w-b]|=128*v}ByteBuffer.accessor=function(){return Uint8Array},ByteBuffer.allocate=function(t,e,r){return new ByteBuffer(t,e,r)},ByteBuffer.concat=function(t,e,r,i){"boolean"!=typeof e&&"string"==typeof e||(i=r,r=e,e=void 0);for(var n,f=0,o=0,s=t.length;o<s;++o)ByteBuffer.isByteBuffer(t[o])||(t[o]=ByteBuffer.wrap(t[o],e)),(n=t[o].limit-t[o].offset)>0&&(f+=n);if(0===f)return new ByteBuffer(0,r,i);var h,a=new ByteBuffer(f,r,i);for(o=0;o<s;)(n=(h=t[o++]).limit-h.offset)<=0||(a.view.set(h.view.subarray(h.offset,h.limit),a.offset),a.offset+=n);return a.limit=a.offset,a.offset=0,a},ByteBuffer.isByteBuffer=function(t){return!0===(t&&t.__isByteBuffer__)},ByteBuffer.type=function(){return ArrayBuffer},ByteBuffer.wrap=function(t,r,i,n){if("string"!=typeof r&&(n=i,i=r,r=void 0),"string"==typeof t)switch(void 0===r&&(r="utf8"),r){case"base64":return ByteBuffer.fromBase64(t,i);case"hex":return ByteBuffer.fromHex(t,i);case"binary":return ByteBuffer.fromBinary(t,i);case"utf8":return ByteBuffer.fromUTF8(t,i);case"debug":return ByteBuffer.fromDebug(t,i);default:throw Error("Unsupported encoding: "+r)}if(null===t||"object"!=typeof t)throw TypeError("Illegal buffer");var f;if(ByteBuffer.isByteBuffer(t))return(f=e.clone.call(t)).markedOffset=-1,f;if(t instanceof Uint8Array)f=new ByteBuffer(0,i,n),t.length>0&&(f.buffer=t.buffer,f.offset=t.byteOffset,f.limit=t.byteOffset+t.byteLength,f.view=new Uint8Array(t.buffer));else if(t instanceof ArrayBuffer)f=new ByteBuffer(0,i,n),t.byteLength>0&&(f.buffer=t,f.offset=0,f.limit=t.byteLength,f.view=t.byteLength>0?new Uint8Array(t):null);else{if("[object Array]"!==Object.prototype.toString.call(t))throw TypeError("Illegal buffer");(f=new ByteBuffer(t.length,i,n)).limit=t.length;for(var o=0;o<t.length;++o)f.view[o]=t[o]}return f},e.writeBitSet=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if(!(t instanceof Array))throw TypeError("Illegal BitSet: Not an array");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}var i,n=e,f=t.length,o=f>>3,s=0;for(e+=this.writeVarint32(f,e);o--;)i=1&!!t[s++]|(1&!!t[s++])<<1|(1&!!t[s++])<<2|(1&!!t[s++])<<3|(1&!!t[s++])<<4|(1&!!t[s++])<<5|(1&!!t[s++])<<6|(1&!!t[s++])<<7,this.writeByte(i,e++);if(s<f){var h=0;for(i=0;s<f;)i|=(1&!!t[s++])<<h++;this.writeByte(i,e++)}return r?(this.offset=e,this):e-n},e.readBitSet=function(t){var e=void 0===t;e&&(t=this.offset);var r,i=this.readVarint32(t),n=i.value,f=n>>3,o=0,s=[];for(t+=i.length;f--;)r=this.readByte(t++),s[o++]=!!(1&r),s[o++]=!!(2&r),s[o++]=!!(4&r),s[o++]=!!(8&r),s[o++]=!!(16&r),s[o++]=!!(32&r),s[o++]=!!(64&r),s[o++]=!!(128&r);if(o<n){var h=0;for(r=this.readByte(t++);o<n;)s[o++]=!!(r>>h++&1)}return e&&(this.offset=t),s},e.readBytes=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+t>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+"+t+") <= "+this.buffer.byteLength)}var i=this.slice(e,e+t);return r&&(this.offset+=t),i},e.writeBytes=e.append,e.writeInt8=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t|=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=1;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=1,this.view[e]=t,r&&(this.offset+=1),this},e.writeByte=e.writeInt8,e.readInt8=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r=this.view[t];return 128==(128&r)&&(r=-(255-r+1)),e&&(this.offset+=1),r},e.readByte=e.readInt8,e.writeUint8=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=1;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=1,this.view[e]=t,r&&(this.offset+=1),this},e.writeUInt8=e.writeUint8,e.readUint8=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r=this.view[t];return e&&(this.offset+=1),r},e.readUInt8=e.readUint8,e.writeInt16=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t|=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=2;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=2,this.littleEndian?(this.view[e+1]=(65280&t)>>>8,this.view[e]=255&t):(this.view[e]=(65280&t)>>>8,this.view[e+1]=255&t),r&&(this.offset+=2),this},e.writeShort=e.writeInt16,e.readInt16=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+2>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+2) <= "+this.buffer.byteLength)}var r=0;return this.littleEndian?(r=this.view[t],r|=this.view[t+1]<<8):(r=this.view[t]<<8,r|=this.view[t+1]),32768==(32768&r)&&(r=-(65535-r+1)),e&&(this.offset+=2),r},e.readShort=e.readInt16,e.writeUint16=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=2;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=2,this.littleEndian?(this.view[e+1]=(65280&t)>>>8,this.view[e]=255&t):(this.view[e]=(65280&t)>>>8,this.view[e+1]=255&t),r&&(this.offset+=2),this},e.writeUInt16=e.writeUint16,e.readUint16=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+2>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+2) <= "+this.buffer.byteLength)}var r=0;return this.littleEndian?(r=this.view[t],r|=this.view[t+1]<<8):(r=this.view[t]<<8,r|=this.view[t+1]),e&&(this.offset+=2),r},e.readUInt16=e.readUint16,e.writeInt32=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t|=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=4;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=4,this.littleEndian?(this.view[e+3]=t>>>24&255,this.view[e+2]=t>>>16&255,this.view[e+1]=t>>>8&255,this.view[e]=255&t):(this.view[e]=t>>>24&255,this.view[e+1]=t>>>16&255,this.view[e+2]=t>>>8&255,this.view[e+3]=255&t),r&&(this.offset+=4),this},e.writeInt=e.writeInt32,e.readInt32=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+4) <= "+this.buffer.byteLength)}var r=0;return this.littleEndian?(r=this.view[t+2]<<16,r|=this.view[t+1]<<8,r|=this.view[t],r+=this.view[t+3]<<24>>>0):(r=this.view[t+1]<<16,r|=this.view[t+2]<<8,r|=this.view[t+3],r+=this.view[t]<<24>>>0),r|=0,e&&(this.offset+=4),r},e.readInt=e.readInt32,e.writeUint32=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=4;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=4,this.littleEndian?(this.view[e+3]=t>>>24&255,this.view[e+2]=t>>>16&255,this.view[e+1]=t>>>8&255,this.view[e]=255&t):(this.view[e]=t>>>24&255,this.view[e+1]=t>>>16&255,this.view[e+2]=t>>>8&255,this.view[e+3]=255&t),r&&(this.offset+=4),this},e.writeUInt32=e.writeUint32,e.readUint32=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+4) <= "+this.buffer.byteLength)}var r=0;return this.littleEndian?(r=this.view[t+2]<<16,r|=this.view[t+1]<<8,r|=this.view[t],r+=this.view[t+3]<<24>>>0):(r=this.view[t+1]<<16,r|=this.view[t+2]<<8,r|=this.view[t+3],r+=this.view[t]<<24>>>0),e&&(this.offset+=4),r},e.readUInt32=e.readUint32,t&&(e.writeInt64=function(e,r){var i=void 0===r;if(i&&(r=this.offset),!this.noAssert){if("number"==typeof e)e=t.fromNumber(e);else if("string"==typeof e)e=t.fromString(e);else if(!(e&&e instanceof t))throw TypeError("Illegal value: "+e+" (not an integer or Long)");if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}"number"==typeof e?e=t.fromNumber(e):"string"==typeof e&&(e=t.fromString(e)),r+=8;var n=this.buffer.byteLength;r>n&&this.resize((n*=2)>r?n:r),r-=8;var f=e.low,o=e.high;return this.littleEndian?(this.view[r+3]=f>>>24&255,this.view[r+2]=f>>>16&255,this.view[r+1]=f>>>8&255,this.view[r]=255&f,r+=4,this.view[r+3]=o>>>24&255,this.view[r+2]=o>>>16&255,this.view[r+1]=o>>>8&255,this.view[r]=255&o):(this.view[r]=o>>>24&255,this.view[r+1]=o>>>16&255,this.view[r+2]=o>>>8&255,this.view[r+3]=255&o,r+=4,this.view[r]=f>>>24&255,this.view[r+1]=f>>>16&255,this.view[r+2]=f>>>8&255,this.view[r+3]=255&f),i&&(this.offset+=8),this},e.writeLong=e.writeInt64,e.readInt64=function(e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+8) <= "+this.buffer.byteLength)}var i=0,n=0;this.littleEndian?(i=this.view[e+2]<<16,i|=this.view[e+1]<<8,i|=this.view[e],i+=this.view[e+3]<<24>>>0,e+=4,n=this.view[e+2]<<16,n|=this.view[e+1]<<8,n|=this.view[e],n+=this.view[e+3]<<24>>>0):(n=this.view[e+1]<<16,n|=this.view[e+2]<<8,n|=this.view[e+3],n+=this.view[e]<<24>>>0,e+=4,i=this.view[e+1]<<16,i|=this.view[e+2]<<8,i|=this.view[e+3],i+=this.view[e]<<24>>>0);var f=new t(i,n,!1);return r&&(this.offset+=8),f},e.readLong=e.readInt64,e.writeUint64=function(e,r){var i=void 0===r;if(i&&(r=this.offset),!this.noAssert){if("number"==typeof e)e=t.fromNumber(e);else if("string"==typeof e)e=t.fromString(e);else if(!(e&&e instanceof t))throw TypeError("Illegal value: "+e+" (not an integer or Long)");if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}"number"==typeof e?e=t.fromNumber(e):"string"==typeof e&&(e=t.fromString(e)),r+=8;var n=this.buffer.byteLength;r>n&&this.resize((n*=2)>r?n:r),r-=8;var f=e.low,o=e.high;return this.littleEndian?(this.view[r+3]=f>>>24&255,this.view[r+2]=f>>>16&255,this.view[r+1]=f>>>8&255,this.view[r]=255&f,r+=4,this.view[r+3]=o>>>24&255,this.view[r+2]=o>>>16&255,this.view[r+1]=o>>>8&255,this.view[r]=255&o):(this.view[r]=o>>>24&255,this.view[r+1]=o>>>16&255,this.view[r+2]=o>>>8&255,this.view[r+3]=255&o,r+=4,this.view[r]=f>>>24&255,this.view[r+1]=f>>>16&255,this.view[r+2]=f>>>8&255,this.view[r+3]=255&f),i&&(this.offset+=8),this},e.writeUInt64=e.writeUint64,e.readUint64=function(e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+8) <= "+this.buffer.byteLength)}var i=0,n=0;this.littleEndian?(i=this.view[e+2]<<16,i|=this.view[e+1]<<8,i|=this.view[e],i+=this.view[e+3]<<24>>>0,e+=4,n=this.view[e+2]<<16,n|=this.view[e+1]<<8,n|=this.view[e],n+=this.view[e+3]<<24>>>0):(n=this.view[e+1]<<16,n|=this.view[e+2]<<8,n|=this.view[e+3],n+=this.view[e]<<24>>>0,e+=4,i=this.view[e+1]<<16,i|=this.view[e+2]<<8,i|=this.view[e+3],i+=this.view[e]<<24>>>0);var f=new t(i,n,!0);return r&&(this.offset+=8),f},e.readUInt64=e.readUint64),e.writeFloat32=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t)throw TypeError("Illegal value: "+t+" (not a number)");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=4;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=4,ieee754_write(this.view,t,e,this.littleEndian,23,4),r&&(this.offset+=4),this},e.writeFloat=e.writeFloat32,e.readFloat32=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+4) <= "+this.buffer.byteLength)}var r=ieee754_read(this.view,t,this.littleEndian,23,4);return e&&(this.offset+=4),r},e.readFloat=e.readFloat32,e.writeFloat64=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t)throw TypeError("Illegal value: "+t+" (not a number)");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}e+=8;var i=this.buffer.byteLength;return e>i&&this.resize((i*=2)>e?i:e),e-=8,ieee754_write(this.view,t,e,this.littleEndian,52,8),r&&(this.offset+=8),this},e.writeDouble=e.writeFloat64,e.readFloat64=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+8>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+8) <= "+this.buffer.byteLength)}var r=ieee754_read(this.view,t,this.littleEndian,52,8);return e&&(this.offset+=8),r},e.readDouble=e.readFloat64,ByteBuffer.MAX_VARINT32_BYTES=5,ByteBuffer.calculateVarint32=function(t){return(t>>>=0)<128?1:t<16384?2:t<1<<21?3:t<1<<28?4:5},ByteBuffer.zigZagEncode32=function(t){return((t|=0)<<1^t>>31)>>>0},ByteBuffer.zigZagDecode32=function(t){return t>>>1^-(1&t)|0},e.writeVarint32=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t|=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}var i,n=ByteBuffer.calculateVarint32(t);e+=n;var f=this.buffer.byteLength;for(e>f&&this.resize((f*=2)>e?f:e),e-=n,t>>>=0;t>=128;)i=127&t|128,this.view[e++]=i,t>>>=7;return this.view[e++]=t,r?(this.offset=e,this):n},e.writeVarint32ZigZag=function(t,e){return this.writeVarint32(ByteBuffer.zigZagEncode32(t),e)},e.readVarint32=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r,i=0,n=0;do{if(!this.noAssert&&t>this.limit){var f=Error("Truncated");throw f.truncated=!0,f}r=this.view[t++],i<5&&(n|=(127&r)<<7*i),++i}while(0!=(128&r));return n|=0,e?(this.offset=t,n):{value:n,length:i}},e.readVarint32ZigZag=function(t){var e=this.readVarint32(t);return"object"==typeof e?e.value=ByteBuffer.zigZagDecode32(e.value):e=ByteBuffer.zigZagDecode32(e),e},t&&(ByteBuffer.MAX_VARINT64_BYTES=10,ByteBuffer.calculateVarint64=function(e){"number"==typeof e?e=t.fromNumber(e):"string"==typeof e&&(e=t.fromString(e));var r=e.toInt()>>>0,i=e.shiftRightUnsigned(28).toInt()>>>0,n=e.shiftRightUnsigned(56).toInt()>>>0;return 0==n?0==i?r<16384?r<128?1:2:r<1<<21?3:4:i<16384?i<128?5:6:i<1<<21?7:8:n<128?9:10},ByteBuffer.zigZagEncode64=function(e){return"number"==typeof e?e=t.fromNumber(e,!1):"string"==typeof e?e=t.fromString(e,!1):!1!==e.unsigned&&(e=e.toSigned()),e.shiftLeft(1).xor(e.shiftRight(63)).toUnsigned()},ByteBuffer.zigZagDecode64=function(e){return"number"==typeof e?e=t.fromNumber(e,!1):"string"==typeof e?e=t.fromString(e,!1):!1!==e.unsigned&&(e=e.toSigned()),e.shiftRightUnsigned(1).xor(e.and(t.ONE).toSigned().negate()).toSigned()},e.writeVarint64=function(e,r){var i=void 0===r;if(i&&(r=this.offset),!this.noAssert){if("number"==typeof e)e=t.fromNumber(e);else if("string"==typeof e)e=t.fromString(e);else if(!(e&&e instanceof t))throw TypeError("Illegal value: "+e+" (not an integer or Long)");if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}"number"==typeof e?e=t.fromNumber(e,!1):"string"==typeof e?e=t.fromString(e,!1):!1!==e.unsigned&&(e=e.toSigned());var n=ByteBuffer.calculateVarint64(e),f=e.toInt()>>>0,o=e.shiftRightUnsigned(28).toInt()>>>0,s=e.shiftRightUnsigned(56).toInt()>>>0;r+=n;var h=this.buffer.byteLength;switch(r>h&&this.resize((h*=2)>r?h:r),r-=n,n){case 10:this.view[r+9]=s>>>7&1;case 9:this.view[r+8]=9!==n?128|s:127&s;case 8:this.view[r+7]=8!==n?o>>>21|128:o>>>21&127;case 7:this.view[r+6]=7!==n?o>>>14|128:o>>>14&127;case 6:this.view[r+5]=6!==n?o>>>7|128:o>>>7&127;case 5:this.view[r+4]=5!==n?128|o:127&o;case 4:this.view[r+3]=4!==n?f>>>21|128:f>>>21&127;case 3:this.view[r+2]=3!==n?f>>>14|128:f>>>14&127;case 2:this.view[r+1]=2!==n?f>>>7|128:f>>>7&127;case 1:this.view[r]=1!==n?128|f:127&f}return i?(this.offset+=n,this):n},e.writeVarint64ZigZag=function(t,e){return this.writeVarint64(ByteBuffer.zigZagEncode64(t),e)},e.readVarint64=function(e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+1) <= "+this.buffer.byteLength)}var i=e,n=0,f=0,o=0,s=0;if(n=127&(s=this.view[e++]),128&s&&(n|=(127&(s=this.view[e++]))<<7,(128&s||this.noAssert&&void 0===s)&&(n|=(127&(s=this.view[e++]))<<14,(128&s||this.noAssert&&void 0===s)&&(n|=(127&(s=this.view[e++]))<<21,(128&s||this.noAssert&&void 0===s)&&(f=127&(s=this.view[e++]),(128&s||this.noAssert&&void 0===s)&&(f|=(127&(s=this.view[e++]))<<7,(128&s||this.noAssert&&void 0===s)&&(f|=(127&(s=this.view[e++]))<<14,(128&s||this.noAssert&&void 0===s)&&(f|=(127&(s=this.view[e++]))<<21,(128&s||this.noAssert&&void 0===s)&&(o=127&(s=this.view[e++]),(128&s||this.noAssert&&void 0===s)&&(o|=(127&(s=this.view[e++]))<<7,128&s||this.noAssert&&void 0===s))))))))))throw Error("Buffer overrun");var h=t.fromBits(n|f<<28,f>>>4|o<<24,!1);return r?(this.offset=e,h):{value:h,length:e-i}},e.readVarint64ZigZag=function(e){var r=this.readVarint64(e);return r&&r.value instanceof t?r.value=ByteBuffer.zigZagDecode64(r.value):r=ByteBuffer.zigZagDecode64(r),r}),e.writeCString=function(t,e){var r=void 0===e;r&&(e=this.offset);var i,n=t.length;if(!this.noAssert){if("string"!=typeof t)throw TypeError("Illegal str: Not a string");for(i=0;i<n;++i)if(0===t.charCodeAt(i))throw RangeError("Illegal str: Contains NULL-characters");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}n=f.calculateUTF16asUTF8(stringSource(t))[1],e+=n+1;var o=this.buffer.byteLength;return e>o&&this.resize((o*=2)>e?o:e),e-=n+1,f.encodeUTF16toUTF8(stringSource(t),function(t){this.view[e++]=t}.bind(this)),this.view[e++]=0,r?(this.offset=e,this):n},e.readCString=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r,i=t,n=-1;return f.decodeUTF8toUTF16(function(){if(0===n)return null;if(t>=this.limit)throw RangeError("Illegal range: Truncated data, "+t+" < "+this.limit);return 0===(n=this.view[t++])?null:n}.bind(this),r=stringDestination(),!0),e?(this.offset=t,r()):{string:r(),length:t-i}},e.writeIString=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("string"!=typeof t)throw TypeError("Illegal str: Not a string");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}var i,n=e;i=f.calculateUTF16asUTF8(stringSource(t),this.noAssert)[1],e+=4+i;var o=this.buffer.byteLength;if(e>o&&this.resize((o*=2)>e?o:e),e-=4+i,this.littleEndian?(this.view[e+3]=i>>>24&255,this.view[e+2]=i>>>16&255,this.view[e+1]=i>>>8&255,this.view[e]=255&i):(this.view[e]=i>>>24&255,this.view[e+1]=i>>>16&255,this.view[e+2]=i>>>8&255,this.view[e+3]=255&i),e+=4,f.encodeUTF16toUTF8(stringSource(t),function(t){this.view[e++]=t}.bind(this)),e!==n+4+i)throw RangeError("Illegal range: Truncated data, "+e+" == "+(e+4+i));return r?(this.offset=e,this):e-n},e.readIString=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+4>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+4) <= "+this.buffer.byteLength)}var r=t,i=this.readUint32(t),n=this.readUTF8String(i,ByteBuffer.METRICS_BYTES,t+=4);return t+=n.length,e?(this.offset=t,n.string):{string:n.string,length:t-r}},ByteBuffer.METRICS_CHARS="c",ByteBuffer.METRICS_BYTES="b",e.writeUTF8String=function(t,e){var r,i=void 0===e;if(i&&(e=this.offset),!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}var n=e;r=f.calculateUTF16asUTF8(stringSource(t))[1],e+=r;var o=this.buffer.byteLength;return e>o&&this.resize((o*=2)>e?o:e),e-=r,f.encodeUTF16toUTF8(stringSource(t),function(t){this.view[e++]=t}.bind(this)),i?(this.offset=e,this):e-n},e.writeString=e.writeUTF8String,ByteBuffer.calculateUTF8Chars=function(t){return f.calculateUTF16asUTF8(stringSource(t))[0]},ByteBuffer.calculateUTF8Bytes=function(t){return f.calculateUTF16asUTF8(stringSource(t))[1]},ByteBuffer.calculateString=ByteBuffer.calculateUTF8Bytes,e.readUTF8String=function(t,e,r){"number"==typeof e&&(r=e,e=void 0);var i=void 0===r;if(i&&(r=this.offset),void 0===e&&(e=ByteBuffer.METRICS_CHARS),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal length: "+t+" (not an integer)");if(t|=0,"number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}var n,o=0,s=r;if(e===ByteBuffer.METRICS_CHARS){if(n=stringDestination(),f.decodeUTF8(function(){return o<t&&r<this.limit?this.view[r++]:null}.bind(this),(function(t){++o,f.UTF8toUTF16(t,n)})),o!==t)throw RangeError("Illegal range: Truncated data, "+o+" == "+t);return i?(this.offset=r,n()):{string:n(),length:r-s}}if(e===ByteBuffer.METRICS_BYTES){if(!this.noAssert){if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+t>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+"+t+") <= "+this.buffer.byteLength)}var h=r+t;if(f.decodeUTF8toUTF16(function(){return r<h?this.view[r++]:null}.bind(this),n=stringDestination(),this.noAssert),r!==h)throw RangeError("Illegal range: Truncated data, "+r+" == "+h);return i?(this.offset=r,n()):{string:n(),length:r-s}}throw TypeError("Unsupported metrics: "+e)},e.readString=e.readUTF8String,e.writeVString=function(t,e){var r=void 0===e;if(r&&(e=this.offset),!this.noAssert){if("string"!=typeof t)throw TypeError("Illegal str: Not a string");if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: "+e+" (not an integer)");if((e>>>=0)<0||e+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+e+" (+0) <= "+this.buffer.byteLength)}var i,n,o=e;i=f.calculateUTF16asUTF8(stringSource(t),this.noAssert)[1],n=ByteBuffer.calculateVarint32(i),e+=n+i;var s=this.buffer.byteLength;if(e>s&&this.resize((s*=2)>e?s:e),e-=n+i,e+=this.writeVarint32(i,e),f.encodeUTF16toUTF8(stringSource(t),function(t){this.view[e++]=t}.bind(this)),e!==o+i+n)throw RangeError("Illegal range: Truncated data, "+e+" == "+(e+i+n));return r?(this.offset=e,this):e-o},e.readVString=function(t){var e=void 0===t;if(e&&(t=this.offset),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+1>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+1) <= "+this.buffer.byteLength)}var r=t,i=this.readVarint32(t),n=this.readUTF8String(i.value,ByteBuffer.METRICS_BYTES,t+=i.length);return t+=n.length,e?(this.offset=t,n.string):{string:n.string,length:t-r}},e.append=function(t,e,r){"number"!=typeof e&&"string"==typeof e||(r=e,e=void 0);var i=void 0===r;if(i&&(r=this.offset),!this.noAssert){if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}t instanceof ByteBuffer||(t=ByteBuffer.wrap(t,e));var n=t.limit-t.offset;if(n<=0)return this;r+=n;var f=this.buffer.byteLength;return r>f&&this.resize((f*=2)>r?f:r),r-=n,this.view.set(t.view.subarray(t.offset,t.limit),r),t.offset+=n,i&&(this.offset+=n),this},e.appendTo=function(t,e){return t.append(this,e),this},e.assert=function(t){return this.noAssert=!t,this},e.capacity=function(){return this.buffer.byteLength},e.clear=function(){return this.offset=0,this.limit=this.buffer.byteLength,this.markedOffset=-1,this},e.clone=function(t){var e=new ByteBuffer(0,this.littleEndian,this.noAssert);return t?(e.buffer=new ArrayBuffer(this.buffer.byteLength),e.view=new Uint8Array(e.buffer)):(e.buffer=this.buffer,e.view=this.view),e.offset=this.offset,e.markedOffset=this.markedOffset,e.limit=this.limit,e},e.compact=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}if(0===t&&e===this.buffer.byteLength)return this;var i=e-t;if(0===i)return this.buffer=r,this.view=null,this.markedOffset>=0&&(this.markedOffset-=t),this.offset=0,this.limit=0,this;var n=new ArrayBuffer(i),f=new Uint8Array(n);return f.set(this.view.subarray(t,e)),this.buffer=n,this.view=f,this.markedOffset>=0&&(this.markedOffset-=t),this.offset=0,this.limit=i,this},e.copy=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}if(t===e)return new ByteBuffer(0,this.littleEndian,this.noAssert);var r=e-t,i=new ByteBuffer(r,this.littleEndian,this.noAssert);return i.offset=0,i.limit=r,i.markedOffset>=0&&(i.markedOffset-=t),this.copyTo(i,0,t,e),i},e.copyTo=function(t,e,r,i){var n,f;if(!this.noAssert&&!ByteBuffer.isByteBuffer(t))throw TypeError("Illegal target: Not a ByteBuffer");if(e=(f=void 0===e)?t.offset:0|e,r=(n=void 0===r)?this.offset:0|r,i=void 0===i?this.limit:0|i,e<0||e>t.buffer.byteLength)throw RangeError("Illegal target range: 0 <= "+e+" <= "+t.buffer.byteLength);if(r<0||i>this.buffer.byteLength)throw RangeError("Illegal source range: 0 <= "+r+" <= "+this.buffer.byteLength);var o=i-r;return 0===o?t:(t.ensureCapacity(e+o),t.view.set(this.view.subarray(r,i),e),n&&(this.offset+=o),f&&(t.offset+=o),this)},e.ensureCapacity=function(t){var e=this.buffer.byteLength;return e<t?this.resize((e*=2)>t?e:t):this},e.fill=function(t,e,r){var i=void 0===e;if(i&&(e=this.offset),"string"==typeof t&&t.length>0&&(t=t.charCodeAt(0)),void 0===e&&(e=this.offset),void 0===r&&(r=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal value: "+t+" (not an integer)");if(t|=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal begin: Not an integer");if(e>>>=0,"number"!=typeof r||r%1!=0)throw TypeError("Illegal end: Not an integer");if(r>>>=0,e<0||e>r||r>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+r+" <= "+this.buffer.byteLength)}if(e>=r)return this;for(;e<r;)this.view[e++]=t;return i&&(this.offset=e),this},e.flip=function(){return this.limit=this.offset,this.offset=0,this},e.mark=function(t){if(t=void 0===t?this.offset:t,!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal offset: "+t+" (not an integer)");if((t>>>=0)<0||t+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+t+" (+0) <= "+this.buffer.byteLength)}return this.markedOffset=t,this},e.order=function(t){if(!this.noAssert&&"boolean"!=typeof t)throw TypeError("Illegal littleEndian: Not a boolean");return this.littleEndian=!!t,this},e.LE=function(t){return this.littleEndian=void 0===t||!!t,this},e.BE=function(t){return this.littleEndian=void 0!==t&&!t,this},e.prepend=function(t,e,r){"number"!=typeof e&&"string"==typeof e||(r=e,e=void 0);var i=void 0===r;if(i&&(r=this.offset),!this.noAssert){if("number"!=typeof r||r%1!=0)throw TypeError("Illegal offset: "+r+" (not an integer)");if((r>>>=0)<0||r+0>this.buffer.byteLength)throw RangeError("Illegal offset: 0 <= "+r+" (+0) <= "+this.buffer.byteLength)}t instanceof ByteBuffer||(t=ByteBuffer.wrap(t,e));var n=t.limit-t.offset;if(n<=0)return this;var f=n-r;if(f>0){var o=new ArrayBuffer(this.buffer.byteLength+f),s=new Uint8Array(o);s.set(this.view.subarray(r,this.buffer.byteLength),n),this.buffer=o,this.view=s,this.offset+=f,this.markedOffset>=0&&(this.markedOffset+=f),this.limit+=f,r+=f}else new Uint8Array(this.buffer);return this.view.set(t.view.subarray(t.offset,t.limit),r-n),t.offset=t.limit,i&&(this.offset-=n),this},e.prependTo=function(t,e){return t.prepend(this,e),this},e.printDebug=function(t){"function"!=typeof t&&(t=console.log.bind(console)),t(this.toString()+"\n-------------------------------------------------------------------\n"+this.toDebug(!0))},e.remaining=function(){return this.limit-this.offset},e.reset=function(){return this.markedOffset>=0?(this.offset=this.markedOffset,this.markedOffset=-1):this.offset=0,this},e.resize=function(t){if(!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal capacity: "+t+" (not an integer)");if((t|=0)<0)throw RangeError("Illegal capacity: 0 <= "+t)}if(this.buffer.byteLength<t){var e=new ArrayBuffer(t),r=new Uint8Array(e);r.set(this.view),this.buffer=e,this.view=r}return this},e.reverse=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}return t===e||Array.prototype.reverse.call(this.view.subarray(t,e)),this},e.skip=function(t){if(!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal length: "+t+" (not an integer)");t|=0}var e=this.offset+t;if(!this.noAssert&&(e<0||e>this.buffer.byteLength))throw RangeError("Illegal length: 0 <= "+this.offset+" + "+t+" <= "+this.buffer.byteLength);return this.offset=e,this},e.slice=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}var r=this.clone();return r.offset=t,r.limit=e,r},e.toBuffer=function(t){var e=this.offset,i=this.limit;if(!this.noAssert){if("number"!=typeof e||e%1!=0)throw TypeError("Illegal offset: Not an integer");if(e>>>=0,"number"!=typeof i||i%1!=0)throw TypeError("Illegal limit: Not an integer");if(i>>>=0,e<0||e>i||i>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+e+" <= "+i+" <= "+this.buffer.byteLength)}if(!t&&0===e&&i===this.buffer.byteLength)return this.buffer;if(e===i)return r;var n=new ArrayBuffer(i-e);return new Uint8Array(n).set(new Uint8Array(this.buffer).subarray(e,i),0),n},e.toArrayBuffer=e.toBuffer,e.toString=function(t,e,r){if(void 0===t)return"ByteBufferAB(offset="+this.offset+",markedOffset="+this.markedOffset+",limit="+this.limit+",capacity="+this.capacity()+")";switch("number"==typeof t&&(r=e=t="utf8"),t){case"utf8":return this.toUTF8(e,r);case"base64":return this.toBase64(e,r);case"hex":return this.toHex(e,r);case"binary":return this.toBinary(e,r);case"debug":return this.toDebug();case"columns":return this.toColumns();default:throw Error("Unsupported encoding: "+t)}};var n=function(){for(var t={},e=[65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,48,49,50,51,52,53,54,55,56,57,43,47],r=[],i=0,n=e.length;i<n;++i)r[e[i]]=i;return t.encode=function(t,r){for(var i,n;null!==(i=t());)r(e[i>>2&63]),n=(3&i)<<4,null!==(i=t())?(r(e[63&((n|=i>>4&15)|i>>4&15)]),n=(15&i)<<2,null!==(i=t())?(r(e[63&(n|i>>6&3)]),r(e[63&i])):(r(e[63&n]),r(61))):(r(e[63&n]),r(61),r(61))},t.decode=function(t,e){var i,n,f;function fail(t){throw Error("Illegal character code: "+t)}for(;null!==(i=t());)if(void 0===(n=r[i])&&fail(i),null!==(i=t())&&(void 0===(f=r[i])&&fail(i),e(n<<2>>>0|(48&f)>>4),null!==(i=t()))){if(void 0===(n=r[i])){if(61===i)break;fail(i)}if(e((15&f)<<4>>>0|(60&n)>>2),null!==(i=t())){if(void 0===(f=r[i])){if(61===i)break;fail(i)}e((3&n)<<6>>>0|f)}}},t.test=function(t){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(t)},t}();e.toBase64=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),e|=0,(t|=0)<0||e>this.capacity||t>e)throw RangeError("begin, end");var r;return n.encode(function(){return t<e?this.view[t++]:null}.bind(this),r=stringDestination()),r()},ByteBuffer.fromBase64=function(t,e){if("string"!=typeof t)throw TypeError("str");var r=new ByteBuffer(t.length/4*3,e),i=0;return n.decode(stringSource(t),(function(t){r.view[i++]=t})),r.limit=i,r},ByteBuffer.btoa=function(t){return ByteBuffer.fromBinary(t).toBase64()},ByteBuffer.atob=function(t){return ByteBuffer.fromBase64(t).toBinary()},e.toBinary=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),e|=0,(t|=0)<0||e>this.capacity()||t>e)throw RangeError("begin, end");if(t===e)return"";for(var r=[],i=[];t<e;)r.push(this.view[t++]),r.length>=1024&&(i.push(String.fromCharCode.apply(String,r)),r=[]);return i.join("")+String.fromCharCode.apply(String,r)},ByteBuffer.fromBinary=function(t,e){if("string"!=typeof t)throw TypeError("str");for(var r,i=0,n=t.length,f=new ByteBuffer(n,e);i<n;){if((r=t.charCodeAt(i))>255)throw RangeError("illegal char code: "+r);f.view[i++]=r}return f.limit=n,f},e.toDebug=function(t){for(var e,r=-1,i=this.buffer.byteLength,n="",f="",o="";r<i;){if(-1!==r&&(n+=(e=this.view[r])<16?"0"+e.toString(16).toUpperCase():e.toString(16).toUpperCase(),t&&(f+=e>32&&e<127?String.fromCharCode(e):".")),++r,t&&r>0&&r%16==0&&r!==i){for(;n.length<51;)n+=" ";o+=n+f+"\n",n=f=""}r===this.offset&&r===this.limit?n+=r===this.markedOffset?"!":"|":r===this.offset?n+=r===this.markedOffset?"[":"<":r===this.limit?n+=r===this.markedOffset?"]":">":n+=r===this.markedOffset?"'":t||0!==r&&r!==i?" ":""}if(t&&" "!==n){for(;n.length<51;)n+=" ";o+=n+f+"\n"}return t?o:n},ByteBuffer.fromDebug=function(t,e,r){for(var i,n,f=t.length,o=new ByteBuffer((f+1)/3|0,e,r),s=0,h=0,a=!1,l=!1,u=!1,g=!1,w=!1;s<f;){switch(i=t.charAt(s++)){case"!":if(!r){if(l||u||g){w=!0;break}l=u=g=!0}o.offset=o.markedOffset=o.limit=h,a=!1;break;case"|":if(!r){if(l||g){w=!0;break}l=g=!0}o.offset=o.limit=h,a=!1;break;case"[":if(!r){if(l||u){w=!0;break}l=u=!0}o.offset=o.markedOffset=h,a=!1;break;case"<":if(!r){if(l){w=!0;break}l=!0}o.offset=h,a=!1;break;case"]":if(!r){if(g||u){w=!0;break}g=u=!0}o.limit=o.markedOffset=h,a=!1;break;case">":if(!r){if(g){w=!0;break}g=!0}o.limit=h,a=!1;break;case"'":if(!r){if(u){w=!0;break}u=!0}o.markedOffset=h,a=!1;break;case" ":a=!1;break;default:if(!r&&a){w=!0;break}if(n=parseInt(i+t.charAt(s++),16),!r&&(isNaN(n)||n<0||n>255))throw TypeError("Illegal str: Not a debug encoded string");o.view[h++]=n,a=!0}if(w)throw TypeError("Illegal str: Invalid symbol at "+s)}if(!r){if(!l||!g)throw TypeError("Illegal str: Missing offset or limit");if(h<o.buffer.byteLength)throw TypeError("Illegal str: Not a debug encoded string (is it hex?) "+h+" < "+f)}return o},e.toHex=function(t,e){if(t=void 0===t?this.offset:t,e=void 0===e?this.limit:e,!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}for(var r,i=new Array(e-t);t<e;)(r=this.view[t++])<16?i.push("0",r.toString(16)):i.push(r.toString(16));return i.join("")},ByteBuffer.fromHex=function(t,e,r){if(!r){if("string"!=typeof t)throw TypeError("Illegal str: Not a string");if(t.length%2!=0)throw TypeError("Illegal str: Length not a multiple of 2")}for(var i,n=t.length,f=new ByteBuffer(n/2|0,e),o=0,s=0;o<n;o+=2){if(i=parseInt(t.substring(o,o+2),16),!r&&(!isFinite(i)||i<0||i>255))throw TypeError("Illegal str: Contains non-hex characters");f.view[s++]=i}return f.limit=s,f};var f=function(){var t={MAX_CODEPOINT:1114111,encodeUTF8:function(t,e){var r=null;for("number"==typeof t&&(r=t,t=function(){return null});null!==r||null!==(r=t());)r<128?e(127&r):r<2048?(e(r>>6&31|192),e(63&r|128)):r<65536?(e(r>>12&15|224),e(r>>6&63|128),e(63&r|128)):(e(r>>18&7|240),e(r>>12&63|128),e(r>>6&63|128),e(63&r|128)),r=null},decodeUTF8:function(t,e){for(var r,i,n,f,fail=function(t){t=t.slice(0,t.indexOf(null));var e=Error(t.toString());throw e.name="TruncatedError",e.bytes=t,e};null!==(r=t());)if(0==(128&r))e(r);else if(192==(224&r))null===(i=t())&&fail([r,i]),e((31&r)<<6|63&i);else if(224==(240&r))(null===(i=t())||null===(n=t()))&&fail([r,i,n]),e((15&r)<<12|(63&i)<<6|63&n);else{if(240!=(248&r))throw RangeError("Illegal starting byte: "+r);(null===(i=t())||null===(n=t())||null===(f=t()))&&fail([r,i,n,f]),e((7&r)<<18|(63&i)<<12|(63&n)<<6|63&f)}},UTF16toUTF8:function(t,e){for(var r,i=null;null!==(r=null!==i?i:t());)r>=55296&&r<=57343&&null!==(i=t())&&i>=56320&&i<=57343?(e(1024*(r-55296)+i-56320+65536),i=null):e(r);null!==i&&e(i)},UTF8toUTF16:function(t,e){var r=null;for("number"==typeof t&&(r=t,t=function(){return null});null!==r||null!==(r=t());)r<=65535?e(r):(e(55296+((r-=65536)>>10)),e(r%1024+56320)),r=null},encodeUTF16toUTF8:function(e,r){t.UTF16toUTF8(e,(function(e){t.encodeUTF8(e,r)}))},decodeUTF8toUTF16:function(e,r){t.decodeUTF8(e,(function(e){t.UTF8toUTF16(e,r)}))},calculateCodePoint:function(t){return t<128?1:t<2048?2:t<65536?3:4},calculateUTF8:function(t){for(var e,r=0;null!==(e=t());)r+=e<128?1:e<2048?2:e<65536?3:4;return r},calculateUTF16asUTF8:function(e){var r=0,i=0;return t.UTF16toUTF8(e,(function(t){++r,i+=t<128?1:t<2048?2:t<65536?3:4})),[r,i]}};return t}();return e.toUTF8=function(t,e){if(void 0===t&&(t=this.offset),void 0===e&&(e=this.limit),!this.noAssert){if("number"!=typeof t||t%1!=0)throw TypeError("Illegal begin: Not an integer");if(t>>>=0,"number"!=typeof e||e%1!=0)throw TypeError("Illegal end: Not an integer");if(e>>>=0,t<0||t>e||e>this.buffer.byteLength)throw RangeError("Illegal range: 0 <= "+t+" <= "+e+" <= "+this.buffer.byteLength)}var r;try{f.decodeUTF8toUTF16(function(){return t<e?this.view[t++]:null}.bind(this),r=stringDestination())}catch(r){if(t!==e)throw RangeError("Illegal range: Truncated data, "+t+" != "+e)}return r()},ByteBuffer.fromUTF8=function(t,e,r){if(!r&&"string"!=typeof t)throw TypeError("Illegal str: Not a string");var i=new ByteBuffer(f.calculateUTF16asUTF8(stringSource(t),!0)[1],e,r),n=0;return f.encodeUTF16toUTF8(stringSource(t),(function(t){i.view[n++]=t})),i.limit=n,i},ByteBuffer}));