function _createForOfIteratorHelper(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
    if (!it) {
        if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
            if (it) o = it;
            var i = 0;
            var F = function F() {};
            return {
                s: F,
                n: function n() {
                    if (i >= o.length) return {
                        done: true
                    };
                    return {
                        done: false,
                        value: o[i++]
                    };
                },
                e: function e(_e) {
                    throw _e;
                },
                f: F
            };
        }
        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    var normalCompletion = true,
    didErr = false,
    err;
    return {
        s: function s() {
            it = it.call(o);
        },
        n: function n() {
            var step = it.next();
            normalCompletion = step.done;
            return step;
        },
        e: function e(_e2) {
            didErr = true;
            err = _e2;
        },
        f: function f() {
            try {
                if (!normalCompletion && it["return"] != null) it["return"]();
            } finally {
                if (didErr) throw err;
            }
        }
    };
}
function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0,
    arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
    }
    return arr2;
}
function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ?
    function(obj) {
        return typeof obj;
    }: function(obj) {
        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol": typeof obj;
    },
    _typeof(obj);
}
function _get() {
    if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
    } else {
        _get = function _get(target, property, receiver) {
            var base = _superPropBase(target, property);
            if (!base) return;
            var desc = Object.getOwnPropertyDescriptor(base, property);
            if (desc.get) {
                return desc.get.call(arguments.length < 3 ? target: receiver);
            }
            return desc.value;
        };
    }
    return _get.apply(this, arguments);
}
function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);
        if (object === null) break;
    }
    return object;
}
function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
            value: subClass,
            writable: true,
            configurable: true
        }
    });
    Object.defineProperty(subClass, "prototype", {
        writable: false
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ||
    function _setPrototypeOf(o, p) {
        o.__proto__ = p;
        return o;
    };
    return _setPrototypeOf(o, p);
}
function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived),
        result;
        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;
            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    };
}
function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
    } else if (call !== void 0) {
        throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized(self);
}
function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}
function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [],
        function() {}));
        return true;
    } catch(e) {
        return false;
    }
}
function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf: function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
}
function _classCallCheck(instance, Constructor) {
    if (! (instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}
function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
        writable: false
    });
    return Constructor;
} (function(exports, Laya) {
    'use strict';
    var MathUtils3D =
    /*#__PURE__*/
    function() {
        function MathUtils3D() {
            _classCallCheck(this, MathUtils3D);
        }
        _createClass(MathUtils3D, null, [{
            key: "isZero",
            value: function isZero(v) {
                return Math.abs(v) < MathUtils3D.zeroTolerance;
            }
        },
        {
            key: "nearEqual",
            value: function nearEqual(n1, n2) {
                if (MathUtils3D.isZero(n1 - n2)) return true;
                return false;
            }
        },
        {
            key: "fastInvSqrt",
            value: function fastInvSqrt(value) {
                if (MathUtils3D.isZero(value)) return value;
                return 1.0 / Math.sqrt(value);
            }
        }]);
        return MathUtils3D;
    } ();
    MathUtils3D.zeroTolerance = 1e-6;
    MathUtils3D.MaxValue = 3.40282347e+38;
    MathUtils3D.MinValue = -3.40282347e+38;
    MathUtils3D.Deg2Rad = Math.PI / 180;
    var Vector2 =
    /*#__PURE__*/
    function() {
        function Vector2() {
            var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            _classCallCheck(this, Vector2);
            this.x = x;
            this.y = y;
        }
        _createClass(Vector2, [{
            key: "setValue",
            value: function setValue(x, y) {
                this.x = x;
                this.y = y;
            }
        },
        {
            key: "fromArray",
            value: function fromArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                this.x = array[offset + 0];
                this.y = array[offset + 1];
            }
        },
        {
            key: "toArray",
            value: function toArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                array[offset + 0] = this.x;
                array[offset + 1] = this.y;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destVector2 = destObject;
                destVector2.x = this.x;
                destVector2.y = this.y;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var destVector2 = new Vector2();
                this.cloneTo(destVector2);
                return destVector2;
            }
        },
        {
            key: "forNativeElement",
            value: function forNativeElement() {
                var nativeElements = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                if (nativeElements) {
                    this.elements = nativeElements;
                    this.elements[0] = this.x;
                    this.elements[1] = this.y;
                } else {
                    this.elements = new Float32Array([this.x, this.y]);
                }
                Vector2.rewriteNumProperty(this, "x", 0);
                Vector2.rewriteNumProperty(this, "y", 1);
            }
        }], [{
            key: "scale",
            value: function scale(a, b, out) {
                out.x = a.x * b;
                out.y = a.y * b;
            }
        },
        {
            key: "dot",
            value: function dot(a, b) {
                return a.x * b.x + a.y * b.y;
            }
        },
        {
            key: "normalize",
            value: function normalize(s, out) {
                var x = s.x,
                y = s.y;
                var len = x * x + y * y;
                if (len > 0) {
                    len = 1 / Math.sqrt(len);
                    out.x = x * len;
                    out.y = y * len;
                }
            }
        },
        {
            key: "scalarLength",
            value: function scalarLength(a) {
                var x = a.x,
                y = a.y;
                return Math.sqrt(x * x + y * y);
            }
        },
        {
            key: "rewriteNumProperty",
            value: function rewriteNumProperty(proto, name, index) {
                Object["defineProperty"](proto, name, {
                    "get": function get() {
                        return this.elements[index];
                    },
                    "set": function set(v) {
                        this.elements[index] = v;
                    }
                });
            }
        }]);
        return Vector2;
    } ();
    Vector2.ZERO = new Vector2(0.0, 0.0);
    Vector2.ONE = new Vector2(1.0, 1.0);
    var Vector4 =
    /*#__PURE__*/
    function() {
        function Vector4() {
            var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
            _classCallCheck(this, Vector4);
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        _createClass(Vector4, [{
            key: "setValue",
            value: function setValue(x, y, z, w) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.w = w;
            }
        },
        {
            key: "fromArray",
            value: function fromArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                this.x = array[offset + 0];
                this.y = array[offset + 1];
                this.z = array[offset + 2];
                this.w = array[offset + 3];
            }
        },
        {
            key: "toArray",
            value: function toArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                array[offset + 0] = this.x;
                array[offset + 1] = this.y;
                array[offset + 2] = this.z;
                array[offset + 3] = this.w;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destVector4 = destObject;
                destVector4.x = this.x;
                destVector4.y = this.y;
                destVector4.z = this.z;
                destVector4.w = this.w;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var destVector4 = new Vector4();
                this.cloneTo(destVector4);
                return destVector4;
            }
        },
        {
            key: "length",
            value: function length() {
                return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
            }
        },
        {
            key: "lengthSquared",
            value: function lengthSquared() {
                return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
            }
        },
        {
            key: "forNativeElement",
            value: function forNativeElement() {
                var nativeElements = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                if (nativeElements) {
                    this.elements = nativeElements;
                    this.elements[0] = this.x;
                    this.elements[1] = this.y;
                    this.elements[2] = this.z;
                    this.elements[3] = this.w;
                } else {
                    this.elements = new Float32Array([this.x, this.y, this.z, this.w]);
                }
                Vector2.rewriteNumProperty(this, "x", 0);
                Vector2.rewriteNumProperty(this, "y", 1);
                Vector2.rewriteNumProperty(this, "z", 2);
                Vector2.rewriteNumProperty(this, "w", 3);
            }
        }], [{
            key: "lerp",
            value: function lerp(a, b, t, out) {
                var ax = a.x,
                ay = a.y,
                az = a.z,
                aw = a.w;
                out.x = ax + t * (b.x - ax);
                out.y = ay + t * (b.y - ay);
                out.z = az + t * (b.z - az);
                out.w = aw + t * (b.w - aw);
            }
        },
        {
            key: "transformByM4x4",
            value: function transformByM4x4(vector4, m4x4, out) {
                var vx = vector4.x;
                var vy = vector4.y;
                var vz = vector4.z;
                var vw = vector4.w;
                var me = m4x4.elements;
                out.x = vx * me[0] + vy * me[4] + vz * me[8] + vw * me[12];
                out.y = vx * me[1] + vy * me[5] + vz * me[9] + vw * me[13];
                out.z = vx * me[2] + vy * me[6] + vz * me[10] + vw * me[14];
                out.w = vx * me[3] + vy * me[7] + vz * me[11] + vw * me[15];
            }
        },
        {
            key: "equals",
            value: function equals(a, b) {
                return MathUtils3D.nearEqual(Math.abs(a.x), Math.abs(b.x)) && MathUtils3D.nearEqual(Math.abs(a.y), Math.abs(b.y)) && MathUtils3D.nearEqual(Math.abs(a.z), Math.abs(b.z)) && MathUtils3D.nearEqual(Math.abs(a.w), Math.abs(b.w));
            }
        },
        {
            key: "normalize",
            value: function normalize(s, out) {
                var len = s.length();
                if (len > 0) {
                    var inverse = 1.0 / len;
                    out.x = s.x * inverse;
                    out.y = s.y * inverse;
                    out.z = s.z * inverse;
                    out.w = s.w * inverse;
                }
            }
        },
        {
            key: "add",
            value: function add(a, b, out) {
                out.x = a.x + b.x;
                out.y = a.y + b.y;
                out.z = a.z + b.z;
                out.w = a.w + b.w;
            }
        },
        {
            key: "subtract",
            value: function subtract(a, b, out) {
                out.x = a.x - b.x;
                out.y = a.y - b.y;
                out.z = a.z - b.z;
                out.w = a.w - b.w;
            }
        },
        {
            key: "multiply",
            value: function multiply(a, b, out) {
                out.x = a.x * b.x;
                out.y = a.y * b.y;
                out.z = a.z * b.z;
                out.w = a.w * b.w;
            }
        },
        {
            key: "scale",
            value: function scale(a, b, out) {
                out.x = a.x * b;
                out.y = a.y * b;
                out.z = a.z * b;
                out.w = a.w * b;
            }
        },
        {
            key: "Clamp",
            value: function Clamp(value, min, max, out) {
                var x = value.x;
                var y = value.y;
                var z = value.z;
                var w = value.w;
                var mineX = min.x;
                var mineY = min.y;
                var mineZ = min.z;
                var mineW = min.w;
                var maxeX = max.x;
                var maxeY = max.y;
                var maxeZ = max.z;
                var maxeW = max.w;
                x = x > maxeX ? maxeX: x;
                x = x < mineX ? mineX: x;
                y = y > maxeY ? maxeY: y;
                y = y < mineY ? mineY: y;
                z = z > maxeZ ? maxeZ: z;
                z = z < mineZ ? mineZ: z;
                w = w > maxeW ? maxeW: w;
                w = w < mineW ? mineW: w;
                out.x = x;
                out.y = y;
                out.z = z;
                out.w = w;
            }
        },
        {
            key: "distanceSquared",
            value: function distanceSquared(value1, value2) {
                var x = value1.x - value2.x;
                var y = value1.y - value2.y;
                var z = value1.z - value2.z;
                var w = value1.w - value2.w;
                return x * x + y * y + z * z + w * w;
            }
        },
        {
            key: "distance",
            value: function distance(value1, value2) {
                var x = value1.x - value2.x;
                var y = value1.y - value2.y;
                var z = value1.z - value2.z;
                var w = value1.w - value2.w;
                return Math.sqrt(x * x + y * y + z * z + w * w);
            }
        },
        {
            key: "dot",
            value: function dot(a, b) {
                return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
            }
        },
        {
            key: "min",
            value: function min(a, b, out) {
                out.x = Math.min(a.x, b.x);
                out.y = Math.min(a.y, b.y);
                out.z = Math.min(a.z, b.z);
                out.w = Math.min(a.w, b.w);
            }
        },
        {
            key: "max",
            value: function max(a, b, out) {
                out.x = Math.max(a.x, b.x);
                out.y = Math.max(a.y, b.y);
                out.z = Math.max(a.z, b.z);
                out.w = Math.max(a.w, b.w);
            }
        }]);
        return Vector4;
    } ();
    Vector4.ZERO = new Vector4();
    Vector4.ONE = new Vector4(1.0, 1.0, 1.0, 1.0);
    Vector4.UnitX = new Vector4(1.0, 0.0, 0.0, 0.0);
    Vector4.UnitY = new Vector4(0.0, 1.0, 0.0, 0.0);
    Vector4.UnitZ = new Vector4(0.0, 0.0, 1.0, 0.0);
    Vector4.UnitW = new Vector4(0.0, 0.0, 0.0, 1.0);
    var Vector3 =
    /*#__PURE__*/
    function() {
        function Vector3() {
            var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            _classCallCheck(this, Vector3);
            this.x = x;
            this.y = y;
            this.z = z;
        }
        _createClass(Vector3, [{
            key: "setValue",
            value: function setValue(x, y, z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }
        },
        {
            key: "fromArray",
            value: function fromArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                this.x = array[offset + 0];
                this.y = array[offset + 1];
                this.z = array[offset + 2];
            }
        },
        {
            key: "toArray",
            value: function toArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                array[offset + 0] = this.x;
                array[offset + 1] = this.y;
                array[offset + 2] = this.z;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destVector3 = destObject;
                destVector3.x = this.x;
                destVector3.y = this.y;
                destVector3.z = this.z;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var destVector3 = new Vector3();
                this.cloneTo(destVector3);
                return destVector3;
            }
        },
        {
            key: "toDefault",
            value: function toDefault() {
                this.x = 0;
                this.y = 0;
                this.z = 0;
            }
        },
        {
            key: "forNativeElement",
            value: function forNativeElement() {
                var nativeElements = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                if (nativeElements) {
                    this.elements = nativeElements;
                    this.elements[0] = this.x;
                    this.elements[1] = this.y;
                    this.elements[2] = this.z;
                } else {
                    this.elements = new Float32Array([this.x, this.y, this.z]);
                }
                Vector2.rewriteNumProperty(this, "x", 0);
                Vector2.rewriteNumProperty(this, "y", 1);
                Vector2.rewriteNumProperty(this, "z", 2);
            }
        }], [{
            key: "distanceSquared",
            value: function distanceSquared(value1, value2) {
                var x = value1.x - value2.x;
                var y = value1.y - value2.y;
                var z = value1.z - value2.z;
                return x * x + y * y + z * z;
            }
        },
        {
            key: "distance",
            value: function distance(value1, value2) {
                var x = value1.x - value2.x;
                var y = value1.y - value2.y;
                var z = value1.z - value2.z;
                return Math.sqrt(x * x + y * y + z * z);
            }
        },
        {
            key: "min",
            value: function min(a, b, out) {
                out.x = Math.min(a.x, b.x);
                out.y = Math.min(a.y, b.y);
                out.z = Math.min(a.z, b.z);
            }
        },
        {
            key: "max",
            value: function max(a, b, out) {
                out.x = Math.max(a.x, b.x);
                out.y = Math.max(a.y, b.y);
                out.z = Math.max(a.z, b.z);
            }
        },
        {
            key: "transformQuat",
            value: function transformQuat(source, rotation, out) {
                var x = source.x,
                y = source.y,
                z = source.z,
                qx = rotation.x,
                qy = rotation.y,
                qz = rotation.z,
                qw = rotation.w,
                ix = qw * x + qy * z - qz * y,
                iy = qw * y + qz * x - qx * z,
                iz = qw * z + qx * y - qy * x,
                iw = -qx * x - qy * y - qz * z;
                out.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
                out.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
                out.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
            }
        },
        {
            key: "scalarLength",
            value: function scalarLength(a) {
                var x = a.x,
                y = a.y,
                z = a.z;
                return Math.sqrt(x * x + y * y + z * z);
            }
        },
        {
            key: "scalarLengthSquared",
            value: function scalarLengthSquared(a) {
                var x = a.x,
                y = a.y,
                z = a.z;
                return x * x + y * y + z * z;
            }
        },
        {
            key: "normalize",
            value: function normalize(s, out) {
                var x = s.x,
                y = s.y,
                z = s.z;
                var len = x * x + y * y + z * z;
                if (len > 0) {
                    len = 1 / Math.sqrt(len);
                    out.x = x * len;
                    out.y = y * len;
                    out.z = z * len;
                }
            }
        },
        {
            key: "multiply",
            value: function multiply(a, b, out) {
                out.x = a.x * b.x;
                out.y = a.y * b.y;
                out.z = a.z * b.z;
            }
        },
        {
            key: "scale",
            value: function scale(a, b, out) {
                out.x = a.x * b;
                out.y = a.y * b;
                out.z = a.z * b;
            }
        },
        {
            key: "lerp",
            value: function lerp(a, b, t, out) {
                var ax = a.x,
                ay = a.y,
                az = a.z;
                out.x = ax + t * (b.x - ax);
                out.y = ay + t * (b.y - ay);
                out.z = az + t * (b.z - az);
            }
        },
        {
            key: "transformV3ToV3",
            value: function transformV3ToV3(vector, transform, result) {
                var intermediate = Vector3._tempVector4;
                Vector3.transformV3ToV4(vector, transform, intermediate);
                result.x = intermediate.x;
                result.y = intermediate.y;
                result.z = intermediate.z;
            }
        },
        {
            key: "transformV3ToV4",
            value: function transformV3ToV4(vector, transform, result) {
                var vectorX = vector.x;
                var vectorY = vector.y;
                var vectorZ = vector.z;
                var transformElem = transform.elements;
                result.x = vectorX * transformElem[0] + vectorY * transformElem[4] + vectorZ * transformElem[8] + transformElem[12];
                result.y = vectorX * transformElem[1] + vectorY * transformElem[5] + vectorZ * transformElem[9] + transformElem[13];
                result.z = vectorX * transformElem[2] + vectorY * transformElem[6] + vectorZ * transformElem[10] + transformElem[14];
                result.w = vectorX * transformElem[3] + vectorY * transformElem[7] + vectorZ * transformElem[11] + transformElem[15];
            }
        },
        {
            key: "TransformNormal",
            value: function TransformNormal(normal, transform, result) {
                var normalX = normal.x;
                var normalY = normal.y;
                var normalZ = normal.z;
                var transformElem = transform.elements;
                result.x = normalX * transformElem[0] + normalY * transformElem[4] + normalZ * transformElem[8];
                result.y = normalX * transformElem[1] + normalY * transformElem[5] + normalZ * transformElem[9];
                result.z = normalX * transformElem[2] + normalY * transformElem[6] + normalZ * transformElem[10];
            }
        },
        {
            key: "transformCoordinate",
            value: function transformCoordinate(coordinate, transform, result) {
                var coordinateX = coordinate.x;
                var coordinateY = coordinate.y;
                var coordinateZ = coordinate.z;
                var transformElem = transform.elements;
                var w = coordinateX * transformElem[3] + coordinateY * transformElem[7] + coordinateZ * transformElem[11] + transformElem[15];
                result.x = (coordinateX * transformElem[0] + coordinateY * transformElem[4] + coordinateZ * transformElem[8] + transformElem[12]) / w;
                result.y = (coordinateX * transformElem[1] + coordinateY * transformElem[5] + coordinateZ * transformElem[9] + transformElem[13]) / w;
                result.z = (coordinateX * transformElem[2] + coordinateY * transformElem[6] + coordinateZ * transformElem[10] + transformElem[14]) / w;
            }
        },
        {
            key: "Clamp",
            value: function Clamp(value, min, max, out) {
                var x = value.x;
                var y = value.y;
                var z = value.z;
                var mineX = min.x;
                var mineY = min.y;
                var mineZ = min.z;
                var maxeX = max.x;
                var maxeY = max.y;
                var maxeZ = max.z;
                x = x > maxeX ? maxeX: x;
                x = x < mineX ? mineX: x;
                y = y > maxeY ? maxeY: y;
                y = y < mineY ? mineY: y;
                z = z > maxeZ ? maxeZ: z;
                z = z < mineZ ? mineZ: z;
                out.x = x;
                out.y = y;
                out.z = z;
            }
        },
        {
            key: "add",
            value: function add(a, b, out) {
                out.x = a.x + b.x;
                out.y = a.y + b.y;
                out.z = a.z + b.z;
            }
        },
        {
            key: "subtract",
            value: function subtract(a, b, o) {
                o.x = a.x - b.x;
                o.y = a.y - b.y;
                o.z = a.z - b.z;
            }
        },
        {
            key: "cross",
            value: function cross(a, b, o) {
                var ax = a.x,
                ay = a.y,
                az = a.z,
                bx = b.x,
                by = b.y,
                bz = b.z;
                o.x = ay * bz - az * by;
                o.y = az * bx - ax * bz;
                o.z = ax * by - ay * bx;
            }
        },
        {
            key: "dot",
            value: function dot(a, b) {
                return a.x * b.x + a.y * b.y + a.z * b.z;
            }
        },
        {
            key: "equals",
            value: function equals(a, b) {
                return MathUtils3D.nearEqual(a.x, b.x) && MathUtils3D.nearEqual(a.y, b.y) && MathUtils3D.nearEqual(a.z, b.z);
            }
        }]);
        return Vector3;
    } ();
    Vector3._tempVector4 = new Vector4();
    Vector3._ZERO = new Vector3(0.0, 0.0, 0.0);
    Vector3._ONE = new Vector3(1.0, 1.0, 1.0);
    Vector3._NegativeUnitX = new Vector3( - 1, 0, 0);
    Vector3._UnitX = new Vector3(1, 0, 0);
    Vector3._UnitY = new Vector3(0, 1, 0);
    Vector3._UnitZ = new Vector3(0, 0, 1);
    Vector3._ForwardRH = new Vector3(0, 0, -1);
    Vector3._ForwardLH = new Vector3(0, 0, 1);
    Vector3._Up = new Vector3(0, 1, 0); (function(PBRRenderQuality) {
        PBRRenderQuality[PBRRenderQuality["High"] = 0] = "High";
        PBRRenderQuality[PBRRenderQuality["Low"] = 1] = "Low";
    })(exports.PBRRenderQuality || (exports.PBRRenderQuality = {}));
    var ILaya3D =
    /*#__PURE__*/
    _createClass(function ILaya3D() {
        _classCallCheck(this, ILaya3D);
    });
    ILaya3D.Shader3D = null;
    ILaya3D.Scene3D = null;
    ILaya3D.MeshRenderStaticBatchManager = null;
    ILaya3D.MeshRenderDynamicBatchManager = null;
    ILaya3D.SubMeshDynamicBatch = null;
    ILaya3D.Laya3D = null;
    ILaya3D.Matrix4x4 = null;
    ILaya3D.Physics3D = null;
    ILaya3D.ShadowLightType = null;
    ILaya3D.RenderElement = null;
    ILaya3D.CommandBuffer = null;
    ILaya3D.Camera = null;
    ILaya3D.SubMeshRenderElement = null;
    var Physics3D =
    /*#__PURE__*/
    function() {
        function Physics3D() {
            _classCallCheck(this, Physics3D);
        }
        _createClass(Physics3D, null, [{
            key: "__bulletinit__",
            value: function __bulletinit__() {
                this._bullet = window.Physics3D;
                if (this._bullet) {
                    Laya.StaticPlaneColliderShape.__init__();
                    Laya.ColliderShape.__init__();
                    Laya.CompoundColliderShape.__init__();
                    Laya.PhysicsComponent.__init__();
                    Laya.PhysicsSimulation.__init__();
                    Laya.BoxColliderShape.__init__();
                    Laya.CylinderColliderShape.__init__();
                    Laya.CharacterController.__init__();
                    Laya.Rigidbody3D.__init__();
                }
            }
        },
        {
            key: "__cannoninit__",
            value: function __cannoninit__() {
                this._cannon = window.CANNON;
                if (!this._cannon) return;
                Laya.CannonColliderShape.__init__();
                Laya.CannonPhysicsComponent.__init__();
                Laya.CannonPhysicsSimulation.__init__();
                Laya.CannonBoxColliderShape.__init__();
                Laya.CannonRigidbody3D.__init__();
            }
        }]);
        return Physics3D;
    } ();
    Physics3D._bullet = null;
    Physics3D._cannon = null;
    Physics3D._enablePhysics = false;
    var Config3D =
    /*#__PURE__*/
    function() {
        function Config3D() {
            _classCallCheck(this, Config3D);
            this._defaultPhysicsMemory = 16;
            this._maxLightCount = 32;
            this._lightClusterCount = new Vector3(12, 12, 12);
            this._resoluWidth = -1;
            this._resoluHeight = -1;
            this._resoluRatio = 1;
            this._customPixel = false;
            this._editerEnvironment = false;
            this.isAntialias = true;
            this.isAlpha = false;
            this.premultipliedAlpha = true;
            this.isStencil = true;
            this.enableMultiLight = true;
            this.octreeCulling = false;
            this.octreeInitialSize = 64.0;
            this.octreeInitialCenter = new Vector3(0, 0, 0);
            this.octreeMinNodeSize = 2.0;
            this.octreeLooseness = 1.25;
            this.distanceVolumCull = false;
            this.debugFrustumCulling = false;
            this.pbrRenderQuality = exports.PBRRenderQuality.High;
            this.isUseCannonPhysicsEngine = false;
            this._maxAreaLightCountPerClusterAverage = Math.min(Math.floor(2048 / this._lightClusterCount.z - 1) * 4, this._maxLightCount);
        }
        _createClass(Config3D, [{
            key: "defaultPhysicsMemory",
            get: function get() {
                return this._defaultPhysicsMemory;
            },
            set: function set(value) {
                if (value < 16) throw "defaultPhysicsMemory must large than 16M";
                this._defaultPhysicsMemory = value;
            }
        },
        {
            key: "setResSize",
            value: function setResSize(width, height) {
                this._customPixel = true;
                this._resoluWidth = width;
                this._resoluHeight = height;
            }
        },
        {
            key: "pixResolWidth",
            get: function get() {
                return this._resoluRatio * this._resoluWidth;
            }
        },
        {
            key: "pixResolHeight",
            get: function get() {
                return this._resoluRatio * this._resoluHeight;
            }
        },
        {
            key: "pixelResol",
            get: function get() {
                return this._resoluRatio;
            },
            set: function set(ratio) {
                this._resoluRatio = ratio;
            }
        },
        {
            key: "pixelRatio",
            get: function get() {
                return this._resoluRatio;
            },
            set: function set(ratio) {
                this._resoluRatio = ratio;
            }
        },
        {
            key: "customPixel",
            get: function get() {
                return this._customPixel;
            },
            set: function set(value) {
                this._customPixel = value;
            }
        },
        {
            key: "maxLightCount",
            get: function get() {
                return this._maxLightCount;
            },
            set: function set(value) {
                if (value > 2048) {
                    this._maxLightCount = 2048;
                    console.warn("Config3D: maxLightCount must less equal 2048.");
                } else {
                    this._maxLightCount = value;
                }
            }
        },
        {
            key: "lightClusterCount",
            get: function get() {
                return this._lightClusterCount;
            },
            set: function set(value) {
                if (value.x > 128 || value.y > 128 || value.z > 128) {
                    this._lightClusterCount.setValue(Math.min(value.x, 128), Math.min(value.y, 128), Math.min(value.z, 128));
                    console.warn("Config3D: lightClusterCount X and Y銆乑 must less equal 128.");
                } else {
                    value.cloneTo(this._lightClusterCount);
                }
                var maxAreaLightCountWithZ = Math.floor(2048 / this._lightClusterCount.z - 1) * 4;
                if (maxAreaLightCountWithZ < this._maxLightCount) console.warn("Config3D: if the area light(PointLight銆丼potLight) count is large than " + maxAreaLightCountWithZ + ",maybe the far away culster will ingonre some light.");
                this._maxAreaLightCountPerClusterAverage = Math.min(maxAreaLightCountWithZ, this._maxLightCount);
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(dest) {
                var destConfig3D = dest;
                destConfig3D._defaultPhysicsMemory = this._defaultPhysicsMemory;
                destConfig3D._editerEnvironment = this._editerEnvironment;
                destConfig3D.isAntialias = this.isAntialias;
                destConfig3D.isAlpha = this.isAlpha;
                destConfig3D.premultipliedAlpha = this.premultipliedAlpha;
                destConfig3D.isStencil = this.isStencil;
                destConfig3D.octreeCulling = this.octreeCulling;
                this.octreeInitialCenter.cloneTo(destConfig3D.octreeInitialCenter);
                destConfig3D.octreeInitialSize = this.octreeInitialSize;
                destConfig3D.octreeMinNodeSize = this.octreeMinNodeSize;
                destConfig3D.octreeLooseness = this.octreeLooseness;
                destConfig3D.debugFrustumCulling = this.debugFrustumCulling;
                destConfig3D.maxLightCount = this.maxLightCount;
                destConfig3D.enableMultiLight = this.enableMultiLight;
                var lightClusterCount = destConfig3D.lightClusterCount;
                this.lightClusterCount.cloneTo(lightClusterCount);
                destConfig3D.lightClusterCount = lightClusterCount;
                destConfig3D.pbrRenderQuality = this.pbrRenderQuality;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Config3D();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "useCannonPhysics",
            get: function get() {
                return Config3D._config.isUseCannonPhysicsEngine;
            },
            set: function set(value) {
                Config3D._config.isUseCannonPhysicsEngine = value;
                if (value) {
                    Physics3D.__cannoninit__();
                    if (!ILaya3D.Scene3D.cannonPhysicsSettings) ILaya3D.Scene3D.cannonPhysicsSettings = new Laya.CannonPhysicsSettings();
                }
            }
        },
        {
            key: "enableDynamicManager",
            get: function get() {
                return ILaya3D.SubMeshRenderElement.enableDynamicBatch;
            },
            set: function set(value) {
                ILaya3D.SubMeshRenderElement.enableDynamicBatch = value;
            }
        },
        {
            key: "enableStaticManager",
            get: function get() {
                return ILaya3D.SubMeshRenderElement.enableStaticBatch;
            },
            set: function set(value) {
                ILaya3D.SubMeshRenderElement.enableStaticBatch = value;
            }
        }]);
        return Config3D;
    } ();
    Config3D._config = new Config3D();
    window.Config3D = Config3D;
    var KeyframeNode =
    /*#__PURE__*/
    function() {
        function KeyframeNode() {
            _classCallCheck(this, KeyframeNode);
            this._ownerPath = [];
            this._propertys = [];
            this._keyFrames = [];
        }
        _createClass(KeyframeNode, [{
            key: "ownerPathCount",
            get: function get() {
                return this._ownerPath.length;
            }
        },
        {
            key: "propertyCount",
            get: function get() {
                return this._propertys.length;
            }
        },
        {
            key: "keyFramesCount",
            get: function get() {
                return this._keyFrames.length;
            }
        },
        {
            key: "_setOwnerPathCount",
            value: function _setOwnerPathCount(value) {
                this._ownerPath.length = value;
            }
        },
        {
            key: "_setOwnerPathByIndex",
            value: function _setOwnerPathByIndex(index, value) {
                this._ownerPath[index] = value;
            }
        },
        {
            key: "_joinOwnerPath",
            value: function _joinOwnerPath(sep) {
                return this._ownerPath.join(sep);
            }
        },
        {
            key: "_setPropertyCount",
            value: function _setPropertyCount(value) {
                this._propertys.length = value;
            }
        },
        {
            key: "_setPropertyByIndex",
            value: function _setPropertyByIndex(index, value) {
                this._propertys[index] = value;
            }
        },
        {
            key: "_joinProperty",
            value: function _joinProperty(sep) {
                return this._propertys.join(sep);
            }
        },
        {
            key: "_setKeyframeCount",
            value: function _setKeyframeCount(value) {
                this._keyFrames.length = value;
            }
        },
        {
            key: "_setKeyframeByIndex",
            value: function _setKeyframeByIndex(index, value) {
                this._keyFrames[index] = value;
            }
        },
        {
            key: "getOwnerPathByIndex",
            value: function getOwnerPathByIndex(index) {
                return this._ownerPath[index];
            }
        },
        {
            key: "getPropertyByIndex",
            value: function getPropertyByIndex(index) {
                return this._propertys[index];
            }
        },
        {
            key: "getKeyframeByIndex",
            value: function getKeyframeByIndex(index) {
                return this._keyFrames[index];
            }
        }]);
        return KeyframeNode;
    } ();
    var AnimationEvent =
    /*#__PURE__*/
    _createClass(function AnimationEvent() {
        _classCallCheck(this, AnimationEvent);
    }); (function(WeightedMode) {
        WeightedMode[WeightedMode["None"] = 0] = "None";
        WeightedMode[WeightedMode["In"] = 1] = "In";
        WeightedMode[WeightedMode["Out"] = 2] = "Out";
        WeightedMode[WeightedMode["Both"] = 3] = "Both";
    })(exports.WeightedMode || (exports.WeightedMode = {}));
    var Keyframe =
    /*#__PURE__*/
    function() {
        function Keyframe() {
            _classCallCheck(this, Keyframe);
        }
        _createClass(Keyframe, [{
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destKeyFrame = destObject;
                destKeyFrame.time = this.time;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Keyframe();
                this.cloneTo(dest);
                return dest;
            }
        }]);
        return Keyframe;
    } ();
    Keyframe.defaultWeight = 0.33333;
    var FloatKeyframe =
    /*#__PURE__*/
    function(_Keyframe) {
        _inherits(FloatKeyframe, _Keyframe);
        var _super = _createSuper(FloatKeyframe);
        function FloatKeyframe() {
            var _this;
            _classCallCheck(this, FloatKeyframe);
            _this = _super.call(this);
            _this.inWeight = Keyframe.defaultWeight;
            _this.outWeight = Keyframe.defaultWeight;
            _this.weightedMode = exports.WeightedMode.None;
            return _this;
        }
        _createClass(FloatKeyframe, [{
            key: "cloneTo",
            value: function cloneTo(destObject) {
                _get(_getPrototypeOf(FloatKeyframe.prototype), "cloneTo", this).call(this, destObject);
                var destKeyFrame = destObject;
                destKeyFrame.inTangent = this.inTangent;
                destKeyFrame.outTangent = this.outTangent;
                destKeyFrame.value = this.value;
            }
        }]);
        return FloatKeyframe;
    } (Keyframe);
    var Matrix3x3 =
    /*#__PURE__*/
    function() {
        function Matrix3x3() {
            _classCallCheck(this, Matrix3x3);
            var e = this.elements = new Float32Array(9);
            e[0] = 1;
            e[1] = 0;
            e[2] = 0;
            e[3] = 0;
            e[4] = 1;
            e[5] = 0;
            e[6] = 0;
            e[7] = 0;
            e[8] = 1;
        }
        _createClass(Matrix3x3, [{
            key: "determinant",
            value: function determinant() {
                var f = this.elements;
                var a00 = f[0],
                a01 = f[1],
                a02 = f[2];
                var a10 = f[3],
                a11 = f[4],
                a12 = f[5];
                var a20 = f[6],
                a21 = f[7],
                a22 = f[8];
                return a00 * (a22 * a11 - a12 * a21) + a01 * ( - a22 * a10 + a12 * a20) + a02 * (a21 * a10 - a11 * a20);
            }
        },
        {
            key: "translate",
            value: function translate(trans, out) {
                var e = out.elements;
                var f = this.elements;
                var a00 = f[0],
                a01 = f[1],
                a02 = f[2];
                var a10 = f[3],
                a11 = f[4],
                a12 = f[5];
                var a20 = f[6],
                a21 = f[7],
                a22 = f[8];
                var x = trans.x,
                y = trans.y;
                e[0] = a00;
                e[1] = a01;
                e[2] = a02;
                e[3] = a10;
                e[4] = a11;
                e[5] = a12;
                e[6] = x * a00 + y * a10 + a20;
                e[7] = x * a01 + y * a11 + a21;
                e[8] = x * a02 + y * a12 + a22;
            }
        },
        {
            key: "rotate",
            value: function rotate(rad, out) {
                var e = out.elements;
                var f = this.elements;
                var a00 = f[0],
                a01 = f[1],
                a02 = f[2];
                var a10 = f[3],
                a11 = f[4],
                a12 = f[5];
                var a20 = f[6],
                a21 = f[7],
                a22 = f[8];
                var s = Math.sin(rad);
                var c = Math.cos(rad);
                e[0] = c * a00 + s * a10;
                e[1] = c * a01 + s * a11;
                e[2] = c * a02 + s * a12;
                e[3] = c * a10 - s * a00;
                e[4] = c * a11 - s * a01;
                e[5] = c * a12 - s * a02;
                e[6] = a20;
                e[7] = a21;
                e[8] = a22;
            }
        },
        {
            key: "scale",
            value: function scale(_scale, out) {
                var e = out.elements;
                var f = this.elements;
                var x = _scale.x,
                y = _scale.y;
                e[0] = x * f[0];
                e[1] = x * f[1];
                e[2] = x * f[2];
                e[3] = y * f[3];
                e[4] = y * f[4];
                e[5] = y * f[5];
                e[6] = f[6];
                e[7] = f[7];
                e[8] = f[8];
            }
        },
        {
            key: "invert",
            value: function invert(out) {
                var e = out.elements;
                var f = this.elements;
                var a00 = f[0],
                a01 = f[1],
                a02 = f[2];
                var a10 = f[3],
                a11 = f[4],
                a12 = f[5];
                var a20 = f[6],
                a21 = f[7],
                a22 = f[8];
                var b01 = a22 * a11 - a12 * a21;
                var b11 = -a22 * a10 + a12 * a20;
                var b21 = a21 * a10 - a11 * a20;
                var det = a00 * b01 + a01 * b11 + a02 * b21;
                if (!det) {
                    return;
                }
                det = 1.0 / det;
                e[0] = b01 * det;
                e[1] = ( - a22 * a01 + a02 * a21) * det;
                e[2] = (a12 * a01 - a02 * a11) * det;
                e[3] = b11 * det;
                e[4] = (a22 * a00 - a02 * a20) * det;
                e[5] = ( - a12 * a00 + a02 * a10) * det;
                e[6] = b21 * det;
                e[7] = ( - a21 * a00 + a01 * a20) * det;
                e[8] = (a11 * a00 - a01 * a10) * det;
            }
        },
        {
            key: "transpose",
            value: function transpose(out) {
                var e = out.elements;
                var f = this.elements;
                if (out === this) {
                    var a01 = f[1],
                    a02 = f[2],
                    a12 = f[5];
                    e[1] = f[3];
                    e[2] = f[6];
                    e[3] = a01;
                    e[5] = f[7];
                    e[6] = a02;
                    e[7] = a12;
                } else {
                    e[0] = f[0];
                    e[1] = f[3];
                    e[2] = f[6];
                    e[3] = f[1];
                    e[4] = f[4];
                    e[5] = f[7];
                    e[6] = f[2];
                    e[7] = f[5];
                    e[8] = f[8];
                }
            }
        },
        {
            key: "identity",
            value: function identity() {
                var e = this.elements;
                e[0] = 1;
                e[1] = 0;
                e[2] = 0;
                e[3] = 0;
                e[4] = 1;
                e[5] = 0;
                e[6] = 0;
                e[7] = 0;
                e[8] = 1;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var i, s, d;
                s = this.elements;
                d = destObject.elements;
                if (s === d) {
                    return;
                }
                for (i = 0; i < 9; ++i) {
                    d[i] = s[i];
                }
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Matrix3x3();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "createRotationQuaternion",
            value: function createRotationQuaternion(rotation, out) {
                var rotX = rotation.x;
                var rotY = rotation.y;
                var rotZ = rotation.z;
                var rotW = rotation.w;
                var xx = rotX * rotX;
                var yy = rotY * rotY;
                var zz = rotZ * rotZ;
                var xy = rotX * rotY;
                var zw = rotZ * rotW;
                var zx = rotZ * rotX;
                var yw = rotY * rotW;
                var yz = rotY * rotZ;
                var xw = rotX * rotW;
                var resultE = out.elements;
                resultE[0] = 1.0 - 2.0 * (yy + zz);
                resultE[1] = 2.0 * (xy + zw);
                resultE[2] = 2.0 * (zx - yw);
                resultE[3] = 2.0 * (xy - zw);
                resultE[4] = 1.0 - 2.0 * (zz + xx);
                resultE[5] = 2.0 * (yz + xw);
                resultE[6] = 2.0 * (zx + yw);
                resultE[7] = 2.0 * (yz - xw);
                resultE[8] = 1.0 - 2.0 * (yy + xx);
            }
        },
        {
            key: "createFromTranslation",
            value: function createFromTranslation(trans, out) {
                var e = out.elements;
                e[0] = 1;
                e[1] = 0;
                e[2] = 0;
                e[3] = 0;
                e[4] = 1;
                e[5] = 0;
                e[6] = trans.x;
                e[7] = trans.y;
                e[8] = 1;
            }
        },
        {
            key: "createFromRotation",
            value: function createFromRotation(rad, out) {
                var e = out.elements;
                var s = Math.sin(rad),
                c = Math.cos(rad);
                e[0] = c;
                e[1] = s;
                e[2] = 0;
                e[3] = -s;
                e[4] = c;
                e[5] = 0;
                e[6] = 0;
                e[7] = 0;
                e[8] = 1;
            }
        },
        {
            key: "createFromScaling",
            value: function createFromScaling(scale, out) {
                var e = out.elements;
                e[0] = scale.x;
                e[1] = 0;
                e[2] = 0;
                e[3] = 0;
                e[4] = scale.y;
                e[5] = 0;
                e[6] = 0;
                e[7] = 0;
                e[8] = scale.z;
            }
        },
        {
            key: "createFromMatrix4x4",
            value: function createFromMatrix4x4(sou, out) {
                var souE = sou.elements;
                var outE = out.elements;
                outE[0] = souE[0];
                outE[1] = souE[1];
                outE[2] = souE[2];
                outE[3] = souE[4];
                outE[4] = souE[5];
                outE[5] = souE[6];
                outE[6] = souE[8];
                outE[7] = souE[9];
                outE[8] = souE[10];
            }
        },
        {
            key: "multiply",
            value: function multiply(left, right, out) {
                var l = left.elements;
                var r = right.elements;
                var e = out.elements;
                var l11 = l[0],
                l12 = l[1],
                l13 = l[2];
                var l21 = l[3],
                l22 = l[4],
                l23 = l[5];
                var l31 = l[6],
                l32 = l[7],
                l33 = l[8];
                var r11 = r[0],
                r12 = r[1],
                r13 = r[2];
                var r21 = r[3],
                r22 = r[4],
                r23 = r[5];
                var r31 = r[6],
                r32 = r[7],
                r33 = r[8];
                e[0] = r11 * l11 + r12 * l21 + r13 * l31;
                e[1] = r11 * l12 + r12 * l22 + r13 * r32;
                e[2] = r11 * l13 + r12 * l23 + r13 * l33;
                e[3] = r21 * l11 + r22 * l21 + r23 * l31;
                e[4] = r21 * l12 + r22 * l22 + r23 * l32;
                e[5] = r21 * l13 + r22 * l23 + r23 * l33;
                e[6] = r31 * l11 + r32 * l21 + r33 * l31;
                e[7] = r31 * l12 + r32 * l22 + r33 * l32;
                e[8] = r31 * l13 + r32 * l23 + r33 * l33;
            }
        },
        {
            key: "lookAt",
            value: function lookAt(eye, target, up, out) {
                Vector3.subtract(eye, target, Matrix3x3._tempV30);
                Vector3.normalize(Matrix3x3._tempV30, Matrix3x3._tempV30);
                Vector3.cross(up, Matrix3x3._tempV30, Matrix3x3._tempV31);
                Vector3.normalize(Matrix3x3._tempV31, Matrix3x3._tempV31);
                Vector3.cross(Matrix3x3._tempV30, Matrix3x3._tempV31, Matrix3x3._tempV32);
                var v0 = Matrix3x3._tempV30;
                var v1 = Matrix3x3._tempV31;
                var v2 = Matrix3x3._tempV32;
                var me = out.elements;
                me[0] = v1.x;
                me[3] = v1.y;
                me[6] = v1.z;
                me[1] = v2.x;
                me[4] = v2.y;
                me[7] = v2.z;
                me[2] = v0.x;
                me[5] = v0.y;
                me[8] = v0.z;
            }
        }]);
        return Matrix3x3;
    } ();
    Matrix3x3.DEFAULT = new Matrix3x3();
    Matrix3x3._tempV30 = new Vector3();
    Matrix3x3._tempV31 = new Vector3();
    Matrix3x3._tempV32 = new Vector3();
    var Quaternion =
    /*#__PURE__*/
    function() {
        function Quaternion() {
            var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var z = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var w = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
            _classCallCheck(this, Quaternion);
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
        _createClass(Quaternion, [{
            key: "setValue",
            value: function setValue(x, y, z, w) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.w = w;
            }
        },
        {
            key: "scaling",
            value: function scaling(_scaling, out) {
                out.x = this.x * _scaling;
                out.y = this.y * _scaling;
                out.z = this.z * _scaling;
                out.w = this.w * _scaling;
            }
        },
        {
            key: "normalize",
            value: function normalize(out) {
                var len = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
                if (len > 0) {
                    len = 1 / Math.sqrt(len);
                    out.x = this.x * len;
                    out.y = this.y * len;
                    out.z = this.z * len;
                    out.w = this.w * len;
                }
            }
        },
        {
            key: "length",
            value: function length() {
                return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
            }
        },
        {
            key: "rotateX",
            value: function rotateX(rad, out) {
                rad *= 0.5;
                var bx = Math.sin(rad),
                bw = Math.cos(rad);
                out.x = this.x * bw + this.w * bx;
                out.y = this.y * bw + this.z * bx;
                out.z = this.z * bw - this.y * bx;
                out.w = this.w * bw - this.x * bx;
            }
        },
        {
            key: "rotateY",
            value: function rotateY(rad, out) {
                rad *= 0.5;
                var by = Math.sin(rad),
                bw = Math.cos(rad);
                out.x = this.x * bw - this.z * by;
                out.y = this.y * bw + this.w * by;
                out.z = this.z * bw + this.x * by;
                out.w = this.w * bw - this.y * by;
            }
        },
        {
            key: "rotateZ",
            value: function rotateZ(rad, out) {
                rad *= 0.5;
                var bz = Math.sin(rad),
                bw = Math.cos(rad);
                out.x = this.x * bw + this.y * bz;
                out.y = this.y * bw - this.x * bz;
                out.z = this.z * bw + this.w * bz;
                out.w = this.w * bw - this.z * bz;
            }
        },
        {
            key: "getYawPitchRoll",
            value: function getYawPitchRoll(out) {
                Vector3.transformQuat(Vector3._ForwardRH, this, Quaternion.TEMPVector31);
                Vector3.transformQuat(Vector3._Up, this, Quaternion.TEMPVector32);
                var upe = Quaternion.TEMPVector32;
                Quaternion.angleTo(Vector3._ZERO, Quaternion.TEMPVector31, Quaternion.TEMPVector33);
                var angle = Quaternion.TEMPVector33;
                if (angle.x == Math.PI / 2) {
                    angle.y = Quaternion.arcTanAngle(upe.z, upe.x);
                    angle.z = 0;
                } else if (angle.x == -Math.PI / 2) {
                    angle.y = Quaternion.arcTanAngle( - upe.z, -upe.x);
                    angle.z = 0;
                } else {
                    ILaya3D.Matrix4x4.createRotationY( - angle.y, ILaya3D.Matrix4x4.TEMPMatrix0);
                    ILaya3D.Matrix4x4.createRotationX( - angle.x, ILaya3D.Matrix4x4.TEMPMatrix1);
                    Vector3.transformCoordinate(Quaternion.TEMPVector32, ILaya3D.Matrix4x4.TEMPMatrix0, Quaternion.TEMPVector32);
                    Vector3.transformCoordinate(Quaternion.TEMPVector32, ILaya3D.Matrix4x4.TEMPMatrix1, Quaternion.TEMPVector32);
                    angle.z = Quaternion.arcTanAngle(upe.y, -upe.x);
                }
                if (angle.y <= -Math.PI) angle.y = Math.PI;
                if (angle.z <= -Math.PI) angle.z = Math.PI;
                if (angle.y >= Math.PI && angle.z >= Math.PI) {
                    angle.y = 0;
                    angle.z = 0;
                    angle.x = Math.PI - angle.x;
                }
                var oe = out;
                oe.x = angle.y;
                oe.y = angle.x;
                oe.z = angle.z;
            }
        },
        {
            key: "invert",
            value: function invert(out) {
                var a0 = this.x,
                a1 = this.y,
                a2 = this.z,
                a3 = this.w;
                var dot = a0 * a0 + a1 * a1 + a2 * a2 + a3 * a3;
                var invDot = dot ? 1.0 / dot: 0;
                out.x = -a0 * invDot;
                out.y = -a1 * invDot;
                out.z = -a2 * invDot;
                out.w = a3 * invDot;
            }
        },
        {
            key: "identity",
            value: function identity() {
                this.x = 0;
                this.y = 0;
                this.z = 0;
                this.w = 1;
            }
        },
        {
            key: "fromArray",
            value: function fromArray(array) {
                var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                this.x = array[offset + 0];
                this.y = array[offset + 1];
                this.z = array[offset + 2];
                this.w = array[offset + 3];
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                if (this === destObject) {
                    return;
                }
                destObject.x = this.x;
                destObject.y = this.y;
                destObject.z = this.z;
                destObject.w = this.w;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Quaternion();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "equals",
            value: function equals(b) {
                return MathUtils3D.nearEqual(this.x, b.x) && MathUtils3D.nearEqual(this.y, b.y) && MathUtils3D.nearEqual(this.z, b.z) && MathUtils3D.nearEqual(this.w, b.w);
            }
        },
        {
            key: "lengthSquared",
            value: function lengthSquared() {
                return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
            }
        },
        {
            key: "forNativeElement",
            value: function forNativeElement() {
                var nativeElements = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                if (nativeElements) {
                    this.elements = nativeElements;
                    this.elements[0] = this.x;
                    this.elements[1] = this.y;
                    this.elements[2] = this.z;
                    this.elements[3] = this.w;
                } else {
                    this.elements = new Float32Array([this.x, this.y, this.z, this.w]);
                }
                Vector2.rewriteNumProperty(this, "x", 0);
                Vector2.rewriteNumProperty(this, "y", 1);
                Vector2.rewriteNumProperty(this, "z", 2);
                Vector2.rewriteNumProperty(this, "w", 3);
            }
        }], [{
            key: "createFromYawPitchRoll",
            value: function createFromYawPitchRoll(yaw, pitch, roll, out) {
                var halfRoll = roll * 0.5;
                var halfPitch = pitch * 0.5;
                var halfYaw = yaw * 0.5;
                var sinRoll = Math.sin(halfRoll);
                var cosRoll = Math.cos(halfRoll);
                var sinPitch = Math.sin(halfPitch);
                var cosPitch = Math.cos(halfPitch);
                var sinYaw = Math.sin(halfYaw);
                var cosYaw = Math.cos(halfYaw);
                out.x = cosYaw * sinPitch * cosRoll + sinYaw * cosPitch * sinRoll;
                out.y = sinYaw * cosPitch * cosRoll - cosYaw * sinPitch * sinRoll;
                out.z = cosYaw * cosPitch * sinRoll - sinYaw * sinPitch * cosRoll;
                out.w = cosYaw * cosPitch * cosRoll + sinYaw * sinPitch * sinRoll;
            }
        },
        {
            key: "multiply",
            value: function multiply(left, right, out) {
                var lx = left.x;
                var ly = left.y;
                var lz = left.z;
                var lw = left.w;
                var rx = right.x;
                var ry = right.y;
                var rz = right.z;
                var rw = right.w;
                var a = ly * rz - lz * ry;
                var b = lz * rx - lx * rz;
                var c = lx * ry - ly * rx;
                var d = lx * rx + ly * ry + lz * rz;
                out.x = lx * rw + rx * lw + a;
                out.y = ly * rw + ry * lw + b;
                out.z = lz * rw + rz * lw + c;
                out.w = lw * rw - d;
            }
        },
        {
            key: "arcTanAngle",
            value: function arcTanAngle(x, y) {
                if (x == 0) {
                    if (y == 1) return Math.PI / 2;
                    return - Math.PI / 2;
                }
                if (x > 0) return Math.atan(y / x);
                if (x < 0) {
                    if (y > 0) return Math.atan(y / x) + Math.PI;
                    return Math.atan(y / x) - Math.PI;
                }
                return 0;
            }
        },
        {
            key: "angleTo",
            value: function angleTo(from, location, angle) {
                Vector3.subtract(location, from, Quaternion.TEMPVector30);
                Vector3.normalize(Quaternion.TEMPVector30, Quaternion.TEMPVector30);
                angle.x = Math.asin(Quaternion.TEMPVector30.y);
                angle.y = Quaternion.arcTanAngle( - Quaternion.TEMPVector30.z, -Quaternion.TEMPVector30.x);
            }
        },
        {
            key: "createFromAxisAngle",
            value: function createFromAxisAngle(axis, rad, out) {
                rad = rad * 0.5;
                var s = Math.sin(rad);
                out.x = s * axis.x;
                out.y = s * axis.y;
                out.z = s * axis.z;
                out.w = Math.cos(rad);
            }
        },
        {
            key: "createFromMatrix4x4",
            value: function createFromMatrix4x4(mat, out) {
                var me = mat.elements;
                var sqrt;
                var half;
                var scale = me[0] + me[5] + me[10];
                if (scale > 0.0) {
                    sqrt = Math.sqrt(scale + 1.0);
                    out.w = sqrt * 0.5;
                    sqrt = 0.5 / sqrt;
                    out.x = (me[6] - me[9]) * sqrt;
                    out.y = (me[8] - me[2]) * sqrt;
                    out.z = (me[1] - me[4]) * sqrt;
                } else if (me[0] >= me[5] && me[0] >= me[10]) {
                    sqrt = Math.sqrt(1.0 + me[0] - me[5] - me[10]);
                    half = 0.5 / sqrt;
                    out.x = 0.5 * sqrt;
                    out.y = (me[1] + me[4]) * half;
                    out.z = (me[2] + me[8]) * half;
                    out.w = (me[6] - me[9]) * half;
                } else if (me[5] > me[10]) {
                    sqrt = Math.sqrt(1.0 + me[5] - me[0] - me[10]);
                    half = 0.5 / sqrt;
                    out.x = (me[4] + me[1]) * half;
                    out.y = 0.5 * sqrt;
                    out.z = (me[9] + me[6]) * half;
                    out.w = (me[8] - me[2]) * half;
                } else {
                    sqrt = Math.sqrt(1.0 + me[10] - me[0] - me[5]);
                    half = 0.5 / sqrt;
                    out.x = (me[8] + me[2]) * half;
                    out.y = (me[9] + me[6]) * half;
                    out.z = 0.5 * sqrt;
                    out.w = (me[1] - me[4]) * half;
                }
            }
        },
        {
            key: "slerp",
            value: function slerp(left, right, t, out) {
                var ax = left.x,
                ay = left.y,
                az = left.z,
                aw = left.w,
                bx = right.x,
                by = right.y,
                bz = right.z,
                bw = right.w;
                var omega, cosom, sinom, scale0, scale1;
                cosom = ax * bx + ay * by + az * bz + aw * bw;
                if (cosom < 0.0) {
                    cosom = -cosom;
                    bx = -bx;
                    by = -by;
                    bz = -bz;
                    bw = -bw;
                }
                if (1.0 - cosom > 0.000001) {
                    omega = Math.acos(cosom);
                    sinom = Math.sin(omega);
                    scale0 = Math.sin((1.0 - t) * omega) / sinom;
                    scale1 = Math.sin(t * omega) / sinom;
                } else {
                    scale0 = 1.0 - t;
                    scale1 = t;
                }
                out.x = scale0 * ax + scale1 * bx;
                out.y = scale0 * ay + scale1 * by;
                out.z = scale0 * az + scale1 * bz;
                out.w = scale0 * aw + scale1 * bw;
                return out;
            }
        },
        {
            key: "lerp",
            value: function lerp(left, right, amount, out) {
                var inverse = 1.0 - amount;
                if (Quaternion.dot(left, right) >= 0) {
                    out.x = inverse * left.x + amount * right.x;
                    out.y = inverse * left.y + amount * right.y;
                    out.z = inverse * left.z + amount * right.z;
                    out.w = inverse * left.w + amount * right.w;
                } else {
                    out.x = inverse * left.x - amount * right.x;
                    out.y = inverse * left.y - amount * right.y;
                    out.z = inverse * left.z - amount * right.z;
                    out.w = inverse * left.w - amount * right.w;
                }
                out.normalize(out);
            }
        },
        {
            key: "add",
            value: function add(left, right, out) {
                out.x = left.x + right.x;
                out.y = left.y + right.y;
                out.z = left.z + right.z;
                out.w = left.w + right.w;
            }
        },
        {
            key: "dot",
            value: function dot(left, right) {
                return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
            }
        },
        {
            key: "rotationLookAt",
            value: function rotationLookAt(forward, up, out) {
                Quaternion.lookAt(Vector3._ZERO, forward, up, out);
            }
        },
        {
            key: "lookAt",
            value: function lookAt(eye, target, up, out) {
                Matrix3x3.lookAt(eye, target, up, Quaternion._tempMatrix3x3);
                Quaternion.rotationMatrix(Quaternion._tempMatrix3x3, out);
            }
        },
        {
            key: "invert",
            value: function invert(value, out) {
                var lengthSq = value.lengthSquared();
                if (!MathUtils3D.isZero(lengthSq)) {
                    lengthSq = 1.0 / lengthSq;
                    out.x = -value.x * lengthSq;
                    out.y = -value.y * lengthSq;
                    out.z = -value.z * lengthSq;
                    out.w = value.w * lengthSq;
                }
            }
        },
        {
            key: "rotationMatrix",
            value: function rotationMatrix(matrix3x3, out) {
                var me = matrix3x3.elements;
                var m11 = me[0];
                var m12 = me[1];
                var m13 = me[2];
                var m21 = me[3];
                var m22 = me[4];
                var m23 = me[5];
                var m31 = me[6];
                var m32 = me[7];
                var m33 = me[8];
                var sqrt, half;
                var scale = m11 + m22 + m33;
                if (scale > 0) {
                    sqrt = Math.sqrt(scale + 1);
                    out.w = sqrt * 0.5;
                    sqrt = 0.5 / sqrt;
                    out.x = (m23 - m32) * sqrt;
                    out.y = (m31 - m13) * sqrt;
                    out.z = (m12 - m21) * sqrt;
                } else if (m11 >= m22 && m11 >= m33) {
                    sqrt = Math.sqrt(1 + m11 - m22 - m33);
                    half = 0.5 / sqrt;
                    out.x = 0.5 * sqrt;
                    out.y = (m12 + m21) * half;
                    out.z = (m13 + m31) * half;
                    out.w = (m23 - m32) * half;
                } else if (m22 > m33) {
                    sqrt = Math.sqrt(1 + m22 - m11 - m33);
                    half = 0.5 / sqrt;
                    out.x = (m21 + m12) * half;
                    out.y = 0.5 * sqrt;
                    out.z = (m32 + m23) * half;
                    out.w = (m31 - m13) * half;
                } else {
                    sqrt = Math.sqrt(1 + m33 - m11 - m22);
                    half = 0.5 / sqrt;
                    out.x = (m31 + m13) * half;
                    out.y = (m32 + m23) * half;
                    out.z = 0.5 * sqrt;
                    out.w = (m12 - m21) * half;
                }
            }
        }]);
        return Quaternion;
    } ();
    Quaternion.TEMPVector30 = new Vector3();
    Quaternion.TEMPVector31 = new Vector3();
    Quaternion.TEMPVector32 = new Vector3();
    Quaternion.TEMPVector33 = new Vector3();
    Quaternion._tempMatrix3x3 = new Matrix3x3();
    Quaternion.DEFAULT = new Quaternion();
    Quaternion.NAN = new Quaternion(NaN, NaN, NaN, NaN);
    var QuaternionKeyframe =
    /*#__PURE__*/
    function(_Keyframe2) {
        _inherits(QuaternionKeyframe, _Keyframe2);
        var _super2 = _createSuper(QuaternionKeyframe);
        function QuaternionKeyframe() {
            var _this2;
            _classCallCheck(this, QuaternionKeyframe);
            _this2 = _super2.call(this);
            _this2.inTangent = new Vector4();
            _this2.outTangent = new Vector4();
            _this2.value = new Quaternion();
            _this2.inWeight = new Vector4();
            _this2.outWeight = new Vector4();
            _this2.weightedMode = new Vector4();
            return _this2;
        }
        _createClass(QuaternionKeyframe, [{
            key: "cloneTo",
            value: function cloneTo(dest) {
                _get(_getPrototypeOf(QuaternionKeyframe.prototype), "cloneTo", this).call(this, dest);
                var destKeyFarme = dest;
                this.inTangent.cloneTo(destKeyFarme.inTangent);
                this.outTangent.cloneTo(destKeyFarme.outTangent);
                this.value.cloneTo(destKeyFarme.value);
            }
        }]);
        return QuaternionKeyframe;
    } (Keyframe);
    var Vector3Keyframe =
    /*#__PURE__*/
    function(_Keyframe3) {
        _inherits(Vector3Keyframe, _Keyframe3);
        var _super3 = _createSuper(Vector3Keyframe);
        function Vector3Keyframe() {
            var _this3;
            _classCallCheck(this, Vector3Keyframe);
            _this3 = _super3.call(this);
            _this3.inTangent = new Vector3();
            _this3.outTangent = new Vector3();
            _this3.value = new Vector3();
            _this3.inWeight = new Vector3(Keyframe.defaultWeight, Keyframe.defaultWeight, Keyframe.defaultWeight);
            _this3.outWeight = new Vector3(Keyframe.defaultWeight, Keyframe.defaultWeight, Keyframe.defaultWeight);
            _this3.weightedMode = new Vector3(exports.WeightedMode.None, exports.WeightedMode.None, exports.WeightedMode.None);
            return _this3;
        }
        _createClass(Vector3Keyframe, [{
            key: "cloneTo",
            value: function cloneTo(dest) {
                _get(_getPrototypeOf(Vector3Keyframe.prototype), "cloneTo", this).call(this, dest);
                var destKeyFarme = dest;
                this.inTangent.cloneTo(destKeyFarme.inTangent);
                this.outTangent.cloneTo(destKeyFarme.outTangent);
                this.value.cloneTo(destKeyFarme.value);
            }
        }]);
        return Vector3Keyframe;
    } (Keyframe);
    var AnimationClipParser03 =
    /*#__PURE__*/
    function() {
        function AnimationClipParser03() {
            _classCallCheck(this, AnimationClipParser03);
        }
        _createClass(AnimationClipParser03, null, [{
            key: "READ_DATA",
            value: function READ_DATA() {
                AnimationClipParser03._DATA.offset = AnimationClipParser03._reader.getUint32();
                AnimationClipParser03._DATA.size = AnimationClipParser03._reader.getUint32();
            }
        },
        {
            key: "READ_BLOCK",
            value: function READ_BLOCK() {
                var count = AnimationClipParser03._BLOCK.count = AnimationClipParser03._reader.getUint16();
                var blockStarts = AnimationClipParser03._BLOCK.blockStarts = [];
                var blockLengths = AnimationClipParser03._BLOCK.blockLengths = [];
                for (var i = 0; i < count; i++) {
                    blockStarts.push(AnimationClipParser03._reader.getUint32());
                    blockLengths.push(AnimationClipParser03._reader.getUint32());
                }
            }
        },
        {
            key: "READ_STRINGS",
            value: function READ_STRINGS() {
                var offset = AnimationClipParser03._reader.getUint32();
                var count = AnimationClipParser03._reader.getUint16();
                var prePos = AnimationClipParser03._reader.pos;
                AnimationClipParser03._reader.pos = offset + AnimationClipParser03._DATA.offset;
                for (var i = 0; i < count; i++) {
                    AnimationClipParser03._strings[i] = AnimationClipParser03._reader.readUTFString();
                }
                AnimationClipParser03._reader.pos = prePos;
            }
        },
        {
            key: "parse",
            value: function parse(clip, reader) {
                AnimationClipParser03._animationClip = clip;
                AnimationClipParser03._reader = reader;
                AnimationClipParser03.READ_DATA();
                AnimationClipParser03.READ_BLOCK();
                AnimationClipParser03.READ_STRINGS();
                for (var i = 0,
                n = AnimationClipParser03._BLOCK.count; i < n; i++) {
                    var index = reader.getUint16();
                    var blockName = AnimationClipParser03._strings[index];
                    var fn = AnimationClipParser03["READ_" + blockName];
                    if (fn == null) throw new Error("model file err,no this function:" + index + " " + blockName);
                    else fn.call(null);
                }
            }
        },
        {
            key: "READ_ANIMATIONS",
            value: function READ_ANIMATIONS() {
                var i, j;
                var node;
                var reader = AnimationClipParser03._reader;
                var startTimeTypes = [];
                var startTimeTypeCount = reader.getUint16();
                startTimeTypes.length = startTimeTypeCount;
                for (i = 0; i < startTimeTypeCount; i++) {
                    startTimeTypes[i] = reader.getFloat32();
                }
                var clip = AnimationClipParser03._animationClip;
                clip.name = AnimationClipParser03._strings[reader.getUint16()];
                var clipDur = clip._duration = reader.getFloat32();
                clip.islooping = !!reader.getByte();
                clip._frameRate = reader.getInt16();
                var nodeCount = reader.getInt16();
                var nodes = clip._nodes;
                nodes.count = nodeCount;
                var nodesMap = clip._nodesMap = {};
                var nodesDic = clip._nodesDic = {};
                for (i = 0; i < nodeCount; i++) {
                    node = new KeyframeNode();
                    nodes.setNodeByIndex(i, node);
                    node._indexInList = i;
                    var type = node.type = reader.getUint8();
                    var pathLength = reader.getUint16();
                    node._setOwnerPathCount(pathLength);
                    for (j = 0; j < pathLength; j++) {
                        node._setOwnerPathByIndex(j, AnimationClipParser03._strings[reader.getUint16()]);
                    }
                    var nodePath = node._joinOwnerPath("/");
                    var mapArray = nodesMap[nodePath];
                    mapArray || (nodesMap[nodePath] = mapArray = []);
                    mapArray.push(node);
                    node.propertyOwner = AnimationClipParser03._strings[reader.getUint16()];
                    var propertyLength = reader.getUint16();
                    node._setPropertyCount(propertyLength);
                    for (j = 0; j < propertyLength; j++) {
                        node._setPropertyByIndex(j, AnimationClipParser03._strings[reader.getUint16()]);
                    }
                    var fullPath = nodePath + "." + node.propertyOwner + "." + node._joinProperty(".");
                    nodesDic[fullPath] = node;
                    node.fullPath = fullPath;
                    var keyframeCount = reader.getUint16();
                    node._setKeyframeCount(keyframeCount);
                    for (j = 0; j < keyframeCount; j++) {
                        switch (type) {
                        case 0:
                            var floatKeyframe = new FloatKeyframe();
                            node._setKeyframeByIndex(j, floatKeyframe);
                            floatKeyframe.time = startTimeTypes[reader.getUint16()];
                            floatKeyframe.inTangent = reader.getFloat32();
                            floatKeyframe.outTangent = reader.getFloat32();
                            floatKeyframe.value = reader.getFloat32();
                            break;
                        case 1:
                        case 3:
                        case 4:
                            var floatArrayKeyframe = new Vector3Keyframe();
                            node._setKeyframeByIndex(j, floatArrayKeyframe);
                            floatArrayKeyframe.time = startTimeTypes[reader.getUint16()];
                            var inTangent = floatArrayKeyframe.inTangent;
                            var outTangent = floatArrayKeyframe.outTangent;
                            var value = floatArrayKeyframe.value;
                            inTangent.x = reader.getFloat32();
                            inTangent.y = reader.getFloat32();
                            inTangent.z = reader.getFloat32();
                            outTangent.x = reader.getFloat32();
                            outTangent.y = reader.getFloat32();
                            outTangent.z = reader.getFloat32();
                            value.x = reader.getFloat32();
                            value.y = reader.getFloat32();
                            value.z = reader.getFloat32();
                            break;
                        case 2:
                            var quaArrayKeyframe = new QuaternionKeyframe();
                            node._setKeyframeByIndex(j, quaArrayKeyframe);
                            quaArrayKeyframe.time = startTimeTypes[reader.getUint16()];
                            var inTangentQua = quaArrayKeyframe.inTangent;
                            var outTangentQua = quaArrayKeyframe.outTangent;
                            var valueQua = quaArrayKeyframe.value;
                            inTangentQua.x = reader.getFloat32();
                            inTangentQua.y = reader.getFloat32();
                            inTangentQua.z = reader.getFloat32();
                            inTangentQua.w = reader.getFloat32();
                            outTangentQua.x = reader.getFloat32();
                            outTangentQua.y = reader.getFloat32();
                            outTangentQua.z = reader.getFloat32();
                            outTangentQua.w = reader.getFloat32();
                            valueQua.x = reader.getFloat32();
                            valueQua.y = reader.getFloat32();
                            valueQua.z = reader.getFloat32();
                            valueQua.w = reader.getFloat32();
                            break;
                        default:
                            throw "AnimationClipParser03:unknown type.";
                        }
                    }
                }
                var eventCount = reader.getUint16();
                for (i = 0; i < eventCount; i++) {
                    var event = new AnimationEvent();
                    event.time = Math.min(clipDur, reader.getFloat32());
                    event.eventName = AnimationClipParser03._strings[reader.getUint16()];
                    var params = [];
                    var paramCount = reader.getUint16();
                    paramCount > 0 && (event.params = params = []);
                    for (j = 0; j < paramCount; j++) {
                        var eventType = reader.getByte();
                        switch (eventType) {
                        case 0:
                            params.push( !! reader.getByte());
                            break;
                        case 1:
                            params.push(reader.getInt32());
                            break;
                        case 2:
                            params.push(reader.getFloat32());
                            break;
                        case 3:
                            params.push(AnimationClipParser03._strings[reader.getUint16()]);
                            break;
                        default:
                            throw new Error("unknown type.");
                        }
                    }
                    clip.addEvent(event);
                }
            }
        }]);
        return AnimationClipParser03;
    } ();
    AnimationClipParser03._strings = [];
    AnimationClipParser03._BLOCK = {
        count: 0
    };
    AnimationClipParser03._DATA = {
        offset: 0,
        size: 0
    };
    var AnimationClipParser04 =
    /*#__PURE__*/
    function() {
        function AnimationClipParser04() {
            _classCallCheck(this, AnimationClipParser04);
        }
        _createClass(AnimationClipParser04, null, [{
            key: "READ_DATA",
            value: function READ_DATA() {
                AnimationClipParser04._DATA.offset = AnimationClipParser04._reader.getUint32();
                AnimationClipParser04._DATA.size = AnimationClipParser04._reader.getUint32();
            }
        },
        {
            key: "READ_BLOCK",
            value: function READ_BLOCK() {
                var count = AnimationClipParser04._BLOCK.count = AnimationClipParser04._reader.getUint16();
                var blockStarts = AnimationClipParser04._BLOCK.blockStarts = [];
                var blockLengths = AnimationClipParser04._BLOCK.blockLengths = [];
                for (var i = 0; i < count; i++) {
                    blockStarts.push(AnimationClipParser04._reader.getUint32());
                    blockLengths.push(AnimationClipParser04._reader.getUint32());
                }
            }
        },
        {
            key: "READ_STRINGS",
            value: function READ_STRINGS() {
                var offset = AnimationClipParser04._reader.getUint32();
                var count = AnimationClipParser04._reader.getUint16();
                var prePos = AnimationClipParser04._reader.pos;
                AnimationClipParser04._reader.pos = offset + AnimationClipParser04._DATA.offset;
                for (var i = 0; i < count; i++) {
                    AnimationClipParser04._strings[i] = AnimationClipParser04._reader.readUTFString();
                }
                AnimationClipParser04._reader.pos = prePos;
            }
        },
        {
            key: "parse",
            value: function parse(clip, reader, version) {
                AnimationClipParser04._animationClip = clip;
                AnimationClipParser04._reader = reader;
                AnimationClipParser04._version = version;
                AnimationClipParser04.READ_DATA();
                AnimationClipParser04.READ_BLOCK();
                AnimationClipParser04.READ_STRINGS();
                for (var i = 0,
                n = AnimationClipParser04._BLOCK.count; i < n; i++) {
                    var index = reader.getUint16();
                    var blockName = AnimationClipParser04._strings[index];
                    var fn = AnimationClipParser04["READ_" + blockName];
                    if (fn == null) throw new Error("model file err,no this function:" + index + " " + blockName);
                    else fn.call(null);
                }
                AnimationClipParser04._version = null;
                AnimationClipParser04._reader = null;
                AnimationClipParser04._animationClip = null;
            }
        },
        {
            key: "READ_ANIMATIONS",
            value: function READ_ANIMATIONS() {
                var i, j;
                var node;
                var reader = AnimationClipParser04._reader;
                var startTimeTypes = [];
                var startTimeTypeCount = reader.getUint16();
                startTimeTypes.length = startTimeTypeCount;
                for (i = 0; i < startTimeTypeCount; i++) {
                    startTimeTypes[i] = reader.getFloat32();
                }
                var clip = AnimationClipParser04._animationClip;
                clip.name = AnimationClipParser04._strings[reader.getUint16()];
                var clipDur = clip._duration = reader.getFloat32();
                clip.islooping = !!reader.getByte();
                clip._frameRate = reader.getInt16();
                var nodeCount = reader.getInt16();
                var nodes = clip._nodes;
                nodes.count = nodeCount;
                var nodesMap = clip._nodesMap = {};
                var nodesDic = clip._nodesDic = {};
                for (i = 0; i < nodeCount; i++) {
                    node = new KeyframeNode();
                    nodes.setNodeByIndex(i, node);
                    node._indexInList = i;
                    var type = node.type = reader.getUint8();
                    var pathLength = reader.getUint16();
                    node._setOwnerPathCount(pathLength);
                    for (j = 0; j < pathLength; j++) {
                        node._setOwnerPathByIndex(j, AnimationClipParser04._strings[reader.getUint16()]);
                    }
                    var nodePath = node._joinOwnerPath("/");
                    var mapArray = nodesMap[nodePath];
                    mapArray || (nodesMap[nodePath] = mapArray = []);
                    mapArray.push(node);
                    node.propertyOwner = AnimationClipParser04._strings[reader.getUint16()];
                    var propertyLength = reader.getUint16();
                    node._setPropertyCount(propertyLength);
                    for (j = 0; j < propertyLength; j++) {
                        node._setPropertyByIndex(j, AnimationClipParser04._strings[reader.getUint16()]);
                    }
                    var fullPath = nodePath + "." + node.propertyOwner + "." + node._joinProperty(".");
                    nodesDic[fullPath] = node;
                    node.fullPath = fullPath;
                    node.nodePath = nodePath;
                    var keyframeCount = reader.getUint16();
                    node._setKeyframeCount(keyframeCount);
                    switch (AnimationClipParser04._version) {
                    case "LAYAANIMATION:04":
                        for (j = 0; j < keyframeCount; j++) {
                            switch (type) {
                            case 0:
                                var floatKeyframe = new FloatKeyframe();
                                node._setKeyframeByIndex(j, floatKeyframe);
                                floatKeyframe.time = startTimeTypes[reader.getUint16()];
                                floatKeyframe.inTangent = reader.getFloat32();
                                floatKeyframe.outTangent = reader.getFloat32();
                                floatKeyframe.value = reader.getFloat32();
                                break;
                            case 1:
                            case 3:
                            case 4:
                                var floatArrayKeyframe = new Vector3Keyframe();
                                node._setKeyframeByIndex(j, floatArrayKeyframe);
                                floatArrayKeyframe.time = startTimeTypes[reader.getUint16()];
                                var inTangent = floatArrayKeyframe.inTangent;
                                var outTangent = floatArrayKeyframe.outTangent;
                                var value = floatArrayKeyframe.value;
                                inTangent.x = reader.getFloat32();
                                inTangent.y = reader.getFloat32();
                                inTangent.z = reader.getFloat32();
                                outTangent.x = reader.getFloat32();
                                outTangent.y = reader.getFloat32();
                                outTangent.z = reader.getFloat32();
                                value.x = reader.getFloat32();
                                value.y = reader.getFloat32();
                                value.z = reader.getFloat32();
                                break;
                            case 2:
                                var quaternionKeyframe = new QuaternionKeyframe();
                                node._setKeyframeByIndex(j, quaternionKeyframe);
                                quaternionKeyframe.time = startTimeTypes[reader.getUint16()];
                                var inTangentQua = quaternionKeyframe.inTangent;
                                var outTangentQua = quaternionKeyframe.outTangent;
                                var valueQua = quaternionKeyframe.value;
                                inTangentQua.x = reader.getFloat32();
                                inTangentQua.y = reader.getFloat32();
                                inTangentQua.z = reader.getFloat32();
                                inTangentQua.w = reader.getFloat32();
                                outTangentQua.x = reader.getFloat32();
                                outTangentQua.y = reader.getFloat32();
                                outTangentQua.z = reader.getFloat32();
                                outTangentQua.w = reader.getFloat32();
                                valueQua.x = reader.getFloat32();
                                valueQua.y = reader.getFloat32();
                                valueQua.z = reader.getFloat32();
                                valueQua.w = reader.getFloat32();
                                break;
                            default:
                                throw "AnimationClipParser04:unknown type.";
                            }
                        }
                        break;
                    case "LAYAANIMATION:WEIGHT_04":
                        for (j = 0; j < keyframeCount; j++) {
                            switch (type) {
                            case 0:
                                var floatKeyframe = new FloatKeyframe();
                                node._setKeyframeByIndex(j, floatKeyframe);
                                floatKeyframe.time = startTimeTypes[reader.getUint16()];
                                floatKeyframe.inTangent = reader.getFloat32();
                                floatKeyframe.outTangent = reader.getFloat32();
                                floatKeyframe.value = reader.getFloat32();
                                floatKeyframe.weightedMode = reader.getUint8();
                                floatKeyframe.inWeight = reader.getFloat32();
                                floatKeyframe.outWeight = reader.getFloat32();
                                break;
                            case 1:
                            case 3:
                            case 4:
                                var floatArrayKeyframe = new Vector3Keyframe();
                                node._setKeyframeByIndex(j, floatArrayKeyframe);
                                floatArrayKeyframe.time = startTimeTypes[reader.getUint16()];
                                var inTangent = floatArrayKeyframe.inTangent;
                                var outTangent = floatArrayKeyframe.outTangent;
                                var value = floatArrayKeyframe.value;
                                var weidhtMode = floatArrayKeyframe.weightedMode;
                                var inWeight = floatArrayKeyframe.inWeight;
                                var outWeight = floatArrayKeyframe.outWeight;
                                inTangent.x = reader.getFloat32();
                                inTangent.y = reader.getFloat32();
                                inTangent.z = reader.getFloat32();
                                outTangent.x = reader.getFloat32();
                                outTangent.y = reader.getFloat32();
                                outTangent.z = reader.getFloat32();
                                value.x = reader.getFloat32();
                                value.y = reader.getFloat32();
                                value.z = reader.getFloat32();
                                weidhtMode.x = reader.getUint8();
                                weidhtMode.y = reader.getUint8();
                                weidhtMode.z = reader.getUint8();
                                inWeight.x = reader.getFloat32();
                                inWeight.y = reader.getFloat32();
                                inWeight.z = reader.getFloat32();
                                outWeight.x = reader.getFloat32();
                                outWeight.y = reader.getFloat32();
                                outWeight.z = reader.getFloat32();
                                break;
                            case 2:
                                var quaternionKeyframe = new QuaternionKeyframe();
                                node._setKeyframeByIndex(j, quaternionKeyframe);
                                quaternionKeyframe.time = startTimeTypes[reader.getUint16()];
                                var inTangentQua = quaternionKeyframe.inTangent;
                                var outTangentQua = quaternionKeyframe.outTangent;
                                var valueQua = quaternionKeyframe.value;
                                var weightModeV4 = quaternionKeyframe.weightedMode;
                                var inWeightQua = quaternionKeyframe.inWeight;
                                var outWeightQua = quaternionKeyframe.outWeight;
                                inTangentQua.x = reader.getFloat32();
                                inTangentQua.y = reader.getFloat32();
                                inTangentQua.z = reader.getFloat32();
                                inTangentQua.w = reader.getFloat32();
                                outTangentQua.x = reader.getFloat32();
                                outTangentQua.y = reader.getFloat32();
                                outTangentQua.z = reader.getFloat32();
                                outTangentQua.w = reader.getFloat32();
                                valueQua.x = reader.getFloat32();
                                valueQua.y = reader.getFloat32();
                                valueQua.z = reader.getFloat32();
                                valueQua.w = reader.getFloat32();
                                weightModeV4.x = reader.getUint8();
                                weightModeV4.y = reader.getUint8();
                                weightModeV4.z = reader.getUint8();
                                weightModeV4.w = reader.getUint8();
                                inWeightQua.x = reader.getFloat32();
                                inWeightQua.y = reader.getFloat32();
                                inWeightQua.z = reader.getFloat32();
                                inWeightQua.w = reader.getFloat32();
                                outWeightQua.x = reader.getFloat32();
                                outWeightQua.y = reader.getFloat32();
                                outWeightQua.z = reader.getFloat32();
                                outWeightQua.w = reader.getFloat32();
                                break;
                            default:
                                throw "AnimationClipParser04:unknown type.";
                            }
                        }
                        break;
                    case "LAYAANIMATION:COMPRESSION_04":
                        for (j = 0; j < keyframeCount; j++) {
                            switch (type) {
                            case 0:
                                floatKeyframe = new FloatKeyframe();
                                node._setKeyframeByIndex(j, floatKeyframe);
                                floatKeyframe.time = startTimeTypes[reader.getUint16()];
                                floatKeyframe.inTangent = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                floatKeyframe.outTangent = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                floatKeyframe.value = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                break;
                            case 1:
                            case 3:
                            case 4:
                                floatArrayKeyframe = new Vector3Keyframe();
                                node._setKeyframeByIndex(j, floatArrayKeyframe);
                                floatArrayKeyframe.time = startTimeTypes[reader.getUint16()];
                                inTangent = floatArrayKeyframe.inTangent;
                                outTangent = floatArrayKeyframe.outTangent;
                                value = floatArrayKeyframe.value;
                                inTangent.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                inTangent.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                inTangent.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangent.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangent.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangent.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                value.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                value.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                value.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                break;
                            case 2:
                                quaternionKeyframe = new QuaternionKeyframe();
                                node._setKeyframeByIndex(j, quaternionKeyframe);
                                quaternionKeyframe.time = startTimeTypes[reader.getUint16()];
                                inTangentQua = quaternionKeyframe.inTangent;
                                outTangentQua = quaternionKeyframe.outTangent;
                                valueQua = quaternionKeyframe.value;
                                inTangentQua.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                inTangentQua.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                inTangentQua.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                inTangentQua.w = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangentQua.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangentQua.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangentQua.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                outTangentQua.w = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                valueQua.x = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                valueQua.y = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                valueQua.z = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                valueQua.w = Laya.HalfFloatUtils.convertToNumber(reader.getUint16());
                                break;
                            default:
                                throw "AnimationClipParser04:unknown type.";
                            }
                        }
                        break;
                    }
                }
                var eventCount = reader.getUint16();
                for (i = 0; i < eventCount; i++) {
                    var event = new AnimationEvent();
                    event.time = Math.min(clipDur, reader.getFloat32());
                    event.eventName = AnimationClipParser04._strings[reader.getUint16()];
                    var params = [];
                    var paramCount = reader.getUint16();
                    paramCount > 0 && (event.params = params = []);
                    for (j = 0; j < paramCount; j++) {
                        var eventType = reader.getByte();
                        switch (eventType) {
                        case 0:
                            params.push( !! reader.getByte());
                            break;
                        case 1:
                            params.push(reader.getInt32());
                            break;
                        case 2:
                            params.push(reader.getFloat32());
                            break;
                        case 3:
                            params.push(AnimationClipParser04._strings[reader.getUint16()]);
                            break;
                        default:
                            throw new Error("unknown type.");
                        }
                    }
                    clip.addEvent(event);
                }
            }
        }]);
        return AnimationClipParser04;
    } ();
    AnimationClipParser04._strings = [];
    AnimationClipParser04._BLOCK = {
        count: 0
    };
    AnimationClipParser04._DATA = {
        offset: 0,
        size: 0
    };
    var KeyframeNodeList =
    /*#__PURE__*/
    function() {
        function KeyframeNodeList() {
            _classCallCheck(this, KeyframeNodeList);
            this._nodes = [];
        }
        _createClass(KeyframeNodeList, [{
            key: "count",
            get: function get() {
                return this._nodes.length;
            },
            set: function set(value) {
                this._nodes.length = value;
            }
        },
        {
            key: "getNodeByIndex",
            value: function getNodeByIndex(index) {
                return this._nodes[index];
            }
        },
        {
            key: "setNodeByIndex",
            value: function setNodeByIndex(index, node) {
                this._nodes[index] = node;
            }
        }]);
        return KeyframeNodeList;
    } ();
    var TextureGenerator =
    /*#__PURE__*/
    function() {
        function TextureGenerator() {
            _classCallCheck(this, TextureGenerator);
        }
        _createClass(TextureGenerator, null, [{
            key: "lightAttenTexture",
            value: function lightAttenTexture(x, y, maxX, maxY, index, data) {
                var sqrRange = x / maxX;
                var atten = 1.0 / (1.0 + 25.0 * sqrRange);
                if (sqrRange >= 0.64) {
                    if (sqrRange > 1.0) {
                        atten = 0;
                    } else {
                        atten *= 1 - (sqrRange - 0.64) / (1 - 0.64);
                    }
                }
                data[index] = Math.floor(atten * 255.0 + 0.5);
            }
        },
        {
            key: "haloTexture",
            value: function haloTexture(x, y, maxX, maxY, index, data) {
                maxX >>= 1;
                maxY >>= 1;
                var xFac = (x - maxX) / maxX;
                var yFac = (y - maxY) / maxY;
                var sqrRange = xFac * xFac + yFac * yFac;
                if (sqrRange > 1.0) {
                    sqrRange = 1.0;
                }
                data[index] = Math.floor((1.0 - sqrRange) * 255.0 + 0.5);
            }
        },
        {
            key: "_generateTexture2D",
            value: function _generateTexture2D(texture, textureWidth, textureHeight, func) {
                var index = 0;
                var size = 0;
                switch (texture.format) {
                case Laya.TextureFormat.R8G8B8:
                    size = 3;
                    break;
                case Laya.TextureFormat.R8G8B8A8:
                    size = 4;
                    break;
                case Laya.TextureFormat.Alpha8:
                    size = 1;
                    break;
                default:
                    throw "GeneratedTexture._generateTexture: unkonw texture format.";
                }
                var data = new Uint8Array(textureWidth * textureHeight * size);
                for (var y = 0; y < textureHeight; y++) {
                    for (var x = 0; x < textureWidth; x++) {
                        func(x, y, textureWidth, textureHeight, index, data);
                        index += size;
                    }
                }
                texture.setPixels(data);
            }
        }]);
        return TextureGenerator;
    } ();
    var Utils3D =
    /*#__PURE__*/
    function() {
        function Utils3D() {
            _classCallCheck(this, Utils3D);
        }
        _createClass(Utils3D, null, [{
            key: "_createFloatTextureBuffer",
            value: function _createFloatTextureBuffer(width, height) {
                var floatTex = new Laya.Texture2D(width, height, Laya.TextureFormat.R32G32B32A32, false, false);
                floatTex.filterMode = Laya.FilterMode.Point;
                floatTex.wrapModeU = Laya.WarpMode.Clamp;
                floatTex.wrapModeV = Laya.WarpMode.Clamp;
                floatTex.anisoLevel = 0;
                return floatTex;
            }
        },
        {
            key: "_convertToLayaVec3",
            value: function _convertToLayaVec3(bVector, out, inverseX) {
                var bullet = ILaya3D.Physics3D._bullet;
                out.x = inverseX ? -bullet.btVector3_x(bVector) : bullet.btVector3_x(bVector);
                out.y = bullet.btVector3_y(bVector);
                out.z = bullet.btVector3_z(bVector);
            }
        },
        {
            key: "_convertToBulletVec3",
            value: function _convertToBulletVec3(lVector, out, inverseX) {
                ILaya3D.Physics3D._bullet.btVector3_setValue(out, inverseX ? -lVector.x: lVector.x, lVector.y, lVector.z);
            }
        },
        {
            key: "_rotationTransformScaleSkinAnimation",
            value: function _rotationTransformScaleSkinAnimation(tx, ty, tz, qx, qy, qz, qw, sx, sy, sz, outArray, outOffset) {
                var re = Utils3D._tempArray16_0;
                var se = Utils3D._tempArray16_1;
                var tse = Utils3D._tempArray16_2;
                var x2 = qx + qx;
                var y2 = qy + qy;
                var z2 = qz + qz;
                var xx = qx * x2;
                var yx = qy * x2;
                var yy = qy * y2;
                var zx = qz * x2;
                var zy = qz * y2;
                var zz = qz * z2;
                var wx = qw * x2;
                var wy = qw * y2;
                var wz = qw * z2;
                re[15] = 1;
                re[0] = 1 - yy - zz;
                re[1] = yx + wz;
                re[2] = zx - wy;
                re[4] = yx - wz;
                re[5] = 1 - xx - zz;
                re[6] = zy + wx;
                re[8] = zx + wy;
                re[9] = zy - wx;
                re[10] = 1 - xx - yy;
                se[15] = 1;
                se[0] = sx;
                se[5] = sy;
                se[10] = sz;
                var i, ai0, ai1, ai2, ai3;
                for (i = 0; i < 4; i++) {
                    ai0 = re[i];
                    ai1 = re[i + 4];
                    ai2 = re[i + 8];
                    ai3 = re[i + 12];
                    tse[i] = ai0;
                    tse[i + 4] = ai1;
                    tse[i + 8] = ai2;
                    tse[i + 12] = ai0 * tx + ai1 * ty + ai2 * tz + ai3;
                }
                for (i = 0; i < 4; i++) {
                    ai0 = tse[i];
                    ai1 = tse[i + 4];
                    ai2 = tse[i + 8];
                    ai3 = tse[i + 12];
                    outArray[i + outOffset] = ai0 * se[0] + ai1 * se[1] + ai2 * se[2] + ai3 * se[3];
                    outArray[i + outOffset + 4] = ai0 * se[4] + ai1 * se[5] + ai2 * se[6] + ai3 * se[7];
                    outArray[i + outOffset + 8] = ai0 * se[8] + ai1 * se[9] + ai2 * se[10] + ai3 * se[11];
                    outArray[i + outOffset + 12] = ai0 * se[12] + ai1 * se[13] + ai2 * se[14] + ai3 * se[15];
                }
            }
        },
        {
            key: "_computeBoneAndAnimationDatasByBindPoseMatrxix",
            value: function _computeBoneAndAnimationDatasByBindPoseMatrxix(bones, curData, inverGlobalBindPose, outBonesDatas, outAnimationDatas, boneIndexToMesh) {
                var offset = 0;
                var matOffset = 0;
                var i;
                var parentOffset;
                var boneLength = bones.length;
                for (i = 0; i < boneLength; offset += bones[i].keyframeWidth, matOffset += 16, i++) {
                    Utils3D._rotationTransformScaleSkinAnimation(curData[offset + 0], curData[offset + 1], curData[offset + 2], curData[offset + 3], curData[offset + 4], curData[offset + 5], curData[offset + 6], curData[offset + 7], curData[offset + 8], curData[offset + 9], outBonesDatas, matOffset);
                    if (i != 0) {
                        parentOffset = bones[i].parentIndex * 16;
                        Utils3D.mulMatrixByArray(outBonesDatas, parentOffset, outBonesDatas, matOffset, outBonesDatas, matOffset);
                    }
                }
                var n = inverGlobalBindPose.length;
                for (i = 0; i < n; i++) {
                    Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas, boneIndexToMesh[i] * 16, inverGlobalBindPose[i], outAnimationDatas, i * 16);
                }
            }
        },
        {
            key: "_computeAnimationDatasByArrayAndMatrixFast",
            value: function _computeAnimationDatasByArrayAndMatrixFast(inverGlobalBindPose, bonesDatas, outAnimationDatas, boneIndexToMesh) {
                for (var i = 0,
                n = inverGlobalBindPose.length; i < n; i++) {
                    Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas, boneIndexToMesh[i] * 16, inverGlobalBindPose[i], outAnimationDatas, i * 16);
                }
            }
        },
        {
            key: "_computeBoneAndAnimationDatasByBindPoseMatrxixOld",
            value: function _computeBoneAndAnimationDatasByBindPoseMatrxixOld(bones, curData, inverGlobalBindPose, outBonesDatas, outAnimationDatas) {
                var offset = 0;
                var matOffset = 0;
                var i;
                var parentOffset;
                var boneLength = bones.length;
                for (i = 0; i < boneLength; offset += bones[i].keyframeWidth, matOffset += 16, i++) {
                    Utils3D._rotationTransformScaleSkinAnimation(curData[offset + 7], curData[offset + 8], curData[offset + 9], curData[offset + 3], curData[offset + 4], curData[offset + 5], curData[offset + 6], curData[offset + 0], curData[offset + 1], curData[offset + 2], outBonesDatas, matOffset);
                    if (i != 0) {
                        parentOffset = bones[i].parentIndex * 16;
                        Utils3D.mulMatrixByArray(outBonesDatas, parentOffset, outBonesDatas, matOffset, outBonesDatas, matOffset);
                    }
                }
                var n = inverGlobalBindPose.length;
                for (i = 0; i < n; i++) {
                    var arrayOffset = i * 16;
                    Utils3D.mulMatrixByArrayAndMatrixFast(outBonesDatas, arrayOffset, inverGlobalBindPose[i], outAnimationDatas, arrayOffset);
                }
            }
        },
        {
            key: "_computeAnimationDatasByArrayAndMatrixFastOld",
            value: function _computeAnimationDatasByArrayAndMatrixFastOld(inverGlobalBindPose, bonesDatas, outAnimationDatas) {
                var n = inverGlobalBindPose.length;
                for (var i = 0; i < n; i++) {
                    var arrayOffset = i * 16;
                    Utils3D.mulMatrixByArrayAndMatrixFast(bonesDatas, arrayOffset, inverGlobalBindPose[i], outAnimationDatas, arrayOffset);
                }
            }
        },
        {
            key: "_computeRootAnimationData",
            value: function _computeRootAnimationData(bones, curData, animationDatas) {
                for (var i = 0,
                offset = 0,
                matOffset = 0,
                boneLength = bones.length; i < boneLength; offset += bones[i].keyframeWidth, matOffset += 16, i++) {
                    Utils3D.createAffineTransformationArray(curData[offset + 0], curData[offset + 1], curData[offset + 2], curData[offset + 3], curData[offset + 4], curData[offset + 5], curData[offset + 6], curData[offset + 7], curData[offset + 8], curData[offset + 9], animationDatas, matOffset);
                }
            }
        },
        {
            key: "transformVector3ArrayByQuat",
            value: function transformVector3ArrayByQuat(sourceArray, sourceOffset, rotation, outArray, outOffset) {
                var x = sourceArray[sourceOffset],
                y = sourceArray[sourceOffset + 1],
                z = sourceArray[sourceOffset + 2],
                qx = rotation.x,
                qy = rotation.y,
                qz = rotation.z,
                qw = rotation.w,
                ix = qw * x + qy * z - qz * y,
                iy = qw * y + qz * x - qx * z,
                iz = qw * z + qx * y - qy * x,
                iw = -qx * x - qy * y - qz * z;
                outArray[outOffset] = ix * qw + iw * -qx + iy * -qz - iz * -qy;
                outArray[outOffset + 1] = iy * qw + iw * -qy + iz * -qx - ix * -qz;
                outArray[outOffset + 2] = iz * qw + iw * -qz + ix * -qy - iy * -qx;
            }
        },
        {
            key: "mulMatrixByArray",
            value: function mulMatrixByArray(leftArray, leftOffset, rightArray, rightOffset, outArray, outOffset) {
                var i, ai0, ai1, ai2, ai3;
                if (outArray === rightArray) {
                    rightArray = Utils3D._tempArray16_3;
                    for (i = 0; i < 16; ++i) {
                        rightArray[i] = outArray[outOffset + i];
                    }
                    rightOffset = 0;
                }
                for (i = 0; i < 4; i++) {
                    ai0 = leftArray[leftOffset + i];
                    ai1 = leftArray[leftOffset + i + 4];
                    ai2 = leftArray[leftOffset + i + 8];
                    ai3 = leftArray[leftOffset + i + 12];
                    outArray[outOffset + i] = ai0 * rightArray[rightOffset + 0] + ai1 * rightArray[rightOffset + 1] + ai2 * rightArray[rightOffset + 2] + ai3 * rightArray[rightOffset + 3];
                    outArray[outOffset + i + 4] = ai0 * rightArray[rightOffset + 4] + ai1 * rightArray[rightOffset + 5] + ai2 * rightArray[rightOffset + 6] + ai3 * rightArray[rightOffset + 7];
                    outArray[outOffset + i + 8] = ai0 * rightArray[rightOffset + 8] + ai1 * rightArray[rightOffset + 9] + ai2 * rightArray[rightOffset + 10] + ai3 * rightArray[rightOffset + 11];
                    outArray[outOffset + i + 12] = ai0 * rightArray[rightOffset + 12] + ai1 * rightArray[rightOffset + 13] + ai2 * rightArray[rightOffset + 14] + ai3 * rightArray[rightOffset + 15];
                }
            }
        },
        {
            key: "mulMatrixByArrayFast",
            value: function mulMatrixByArrayFast(leftArray, leftOffset, rightArray, rightOffset, outArray, outOffset) {
                var i, ai0, ai1, ai2, ai3;
                for (i = 0; i < 4; i++) {
                    ai0 = leftArray[leftOffset + i];
                    ai1 = leftArray[leftOffset + i + 4];
                    ai2 = leftArray[leftOffset + i + 8];
                    ai3 = leftArray[leftOffset + i + 12];
                    outArray[outOffset + i] = ai0 * rightArray[rightOffset + 0] + ai1 * rightArray[rightOffset + 1] + ai2 * rightArray[rightOffset + 2] + ai3 * rightArray[rightOffset + 3];
                    outArray[outOffset + i + 4] = ai0 * rightArray[rightOffset + 4] + ai1 * rightArray[rightOffset + 5] + ai2 * rightArray[rightOffset + 6] + ai3 * rightArray[rightOffset + 7];
                    outArray[outOffset + i + 8] = ai0 * rightArray[rightOffset + 8] + ai1 * rightArray[rightOffset + 9] + ai2 * rightArray[rightOffset + 10] + ai3 * rightArray[rightOffset + 11];
                    outArray[outOffset + i + 12] = ai0 * rightArray[rightOffset + 12] + ai1 * rightArray[rightOffset + 13] + ai2 * rightArray[rightOffset + 14] + ai3 * rightArray[rightOffset + 15];
                }
            }
        },
        {
            key: "mulMatrixByArrayAndMatrixFast",
            value: function mulMatrixByArrayAndMatrixFast(leftArray, leftOffset, rightMatrix, outArray, outOffset) {
                var i, ai0, ai1, ai2, ai3;
                var rightMatrixE = rightMatrix.elements;
                var m11 = rightMatrixE[0],
                m12 = rightMatrixE[1],
                m13 = rightMatrixE[2],
                m14 = rightMatrixE[3];
                var m21 = rightMatrixE[4],
                m22 = rightMatrixE[5],
                m23 = rightMatrixE[6],
                m24 = rightMatrixE[7];
                var m31 = rightMatrixE[8],
                m32 = rightMatrixE[9],
                m33 = rightMatrixE[10],
                m34 = rightMatrixE[11];
                var m41 = rightMatrixE[12],
                m42 = rightMatrixE[13],
                m43 = rightMatrixE[14],
                m44 = rightMatrixE[15];
                var ai0LeftOffset = leftOffset;
                var ai1LeftOffset = leftOffset + 4;
                var ai2LeftOffset = leftOffset + 8;
                var ai3LeftOffset = leftOffset + 12;
                var ai0OutOffset = outOffset;
                var ai1OutOffset = outOffset + 4;
                var ai2OutOffset = outOffset + 8;
                var ai3OutOffset = outOffset + 12;
                for (i = 0; i < 4; i++) {
                    ai0 = leftArray[ai0LeftOffset + i];
                    ai1 = leftArray[ai1LeftOffset + i];
                    ai2 = leftArray[ai2LeftOffset + i];
                    ai3 = leftArray[ai3LeftOffset + i];
                    outArray[ai0OutOffset + i] = ai0 * m11 + ai1 * m12 + ai2 * m13 + ai3 * m14;
                    outArray[ai1OutOffset + i] = ai0 * m21 + ai1 * m22 + ai2 * m23 + ai3 * m24;
                    outArray[ai2OutOffset + i] = ai0 * m31 + ai1 * m32 + ai2 * m33 + ai3 * m34;
                    outArray[ai3OutOffset + i] = ai0 * m41 + ai1 * m42 + ai2 * m43 + ai3 * m44;
                }
            }
        },
        {
            key: "createAffineTransformationArray",
            value: function createAffineTransformationArray(tX, tY, tZ, rX, rY, rZ, rW, sX, sY, sZ, outArray, outOffset) {
                var x2 = rX + rX,
                y2 = rY + rY,
                z2 = rZ + rZ;
                var xx = rX * x2,
                xy = rX * y2,
                xz = rX * z2,
                yy = rY * y2,
                yz = rY * z2,
                zz = rZ * z2;
                var wx = rW * x2,
                wy = rW * y2,
                wz = rW * z2;
                outArray[outOffset + 0] = (1 - (yy + zz)) * sX;
                outArray[outOffset + 1] = (xy + wz) * sX;
                outArray[outOffset + 2] = (xz - wy) * sX;
                outArray[outOffset + 3] = 0;
                outArray[outOffset + 4] = (xy - wz) * sY;
                outArray[outOffset + 5] = (1 - (xx + zz)) * sY;
                outArray[outOffset + 6] = (yz + wx) * sY;
                outArray[outOffset + 7] = 0;
                outArray[outOffset + 8] = (xz + wy) * sZ;
                outArray[outOffset + 9] = (yz - wx) * sZ;
                outArray[outOffset + 10] = (1 - (xx + yy)) * sZ;
                outArray[outOffset + 11] = 0;
                outArray[outOffset + 12] = tX;
                outArray[outOffset + 13] = tY;
                outArray[outOffset + 14] = tZ;
                outArray[outOffset + 15] = 1;
            }
        },
        {
            key: "transformVector3ArrayToVector3ArrayCoordinate",
            value: function transformVector3ArrayToVector3ArrayCoordinate(source, sourceOffset, transform, result, resultOffset) {
                var coordinateX = source[sourceOffset + 0];
                var coordinateY = source[sourceOffset + 1];
                var coordinateZ = source[sourceOffset + 2];
                var transformElem = transform.elements;
                var w = coordinateX * transformElem[3] + coordinateY * transformElem[7] + coordinateZ * transformElem[11] + transformElem[15];
                result[resultOffset] = coordinateX * transformElem[0] + coordinateY * transformElem[4] + coordinateZ * transformElem[8] + transformElem[12] / w;
                result[resultOffset + 1] = coordinateX * transformElem[1] + coordinateY * transformElem[5] + coordinateZ * transformElem[9] + transformElem[13] / w;
                result[resultOffset + 2] = coordinateX * transformElem[2] + coordinateY * transformElem[6] + coordinateZ * transformElem[10] + transformElem[14] / w;
            }
        },
        {
            key: "transformVector3ArrayToVector3ArrayNormal",
            value: function transformVector3ArrayToVector3ArrayNormal(source, sourceOffset, transform, result, resultOffset) {
                var coordinateX = source[sourceOffset + 0];
                var coordinateY = source[sourceOffset + 1];
                var coordinateZ = source[sourceOffset + 2];
                var transformElem = transform.elements;
                result[resultOffset] = coordinateX * transformElem[0] + coordinateY * transformElem[4] + coordinateZ * transformElem[8];
                result[resultOffset + 1] = coordinateX * transformElem[1] + coordinateY * transformElem[5] + coordinateZ * transformElem[9];
                result[resultOffset + 2] = coordinateX * transformElem[2] + coordinateY * transformElem[6] + coordinateZ * transformElem[10];
            }
        },
        {
            key: "transformLightingMapTexcoordArray",
            value: function transformLightingMapTexcoordArray(source, sourceOffset, lightingMapScaleOffset, result, resultOffset) {
                result[resultOffset + 0] = source[sourceOffset + 0] * lightingMapScaleOffset.x + lightingMapScaleOffset.z;
                result[resultOffset + 1] = 1.0 - ((1.0 - source[sourceOffset + 1]) * lightingMapScaleOffset.y + lightingMapScaleOffset.w);
            }
        },
        {
            key: "getURLVerion",
            value: function getURLVerion(url) {
                var index = url.indexOf("?");
                return index >= 0 ? url.substr(index) : null;
            }
        },
        {
            key: "_createAffineTransformationArray",
            value: function _createAffineTransformationArray(trans, rot, scale, outE) {
                var x = rot.x,
                y = rot.y,
                z = rot.z,
                w = rot.w,
                x2 = x + x,
                y2 = y + y,
                z2 = z + z;
                var xx = x * x2,
                xy = x * y2,
                xz = x * z2,
                yy = y * y2,
                yz = y * z2,
                zz = z * z2;
                var wx = w * x2,
                wy = w * y2,
                wz = w * z2,
                sx = scale.x,
                sy = scale.y,
                sz = scale.z;
                outE[0] = (1 - (yy + zz)) * sx;
                outE[1] = (xy + wz) * sx;
                outE[2] = (xz - wy) * sx;
                outE[3] = 0;
                outE[4] = (xy - wz) * sy;
                outE[5] = (1 - (xx + zz)) * sy;
                outE[6] = (yz + wx) * sy;
                outE[7] = 0;
                outE[8] = (xz + wy) * sz;
                outE[9] = (yz - wx) * sz;
                outE[10] = (1 - (xx + yy)) * sz;
                outE[11] = 0;
                outE[12] = trans.x;
                outE[13] = trans.y;
                outE[14] = trans.z;
                outE[15] = 1;
            }
        },
        {
            key: "_mulMatrixArray",
            value: function _mulMatrixArray(left, right, rightOffset, outArray, outOffset) {
                var l = right;
                var r = left;
                var e = outArray;
                var l11 = l[rightOffset],
                l12 = l[rightOffset + 1],
                l13 = l[rightOffset + 2],
                l14 = l[rightOffset + 3];
                var l21 = l[rightOffset + 4],
                l22 = l[rightOffset + 5],
                l23 = l[rightOffset + 6],
                l24 = l[rightOffset + 7];
                var l31 = l[rightOffset + 8],
                l32 = l[rightOffset + 9],
                l33 = l[rightOffset + 10],
                l34 = l[rightOffset + 11];
                var l41 = l[rightOffset + 12],
                l42 = l[rightOffset + 13],
                l43 = l[rightOffset + 14],
                l44 = l[rightOffset + 15];
                var r11 = r[0],
                r12 = r[1],
                r13 = r[2],
                r14 = r[3];
                var r21 = r[4],
                r22 = r[5],
                r23 = r[6],
                r24 = r[7];
                var r31 = r[8],
                r32 = r[9],
                r33 = r[10],
                r34 = r[11];
                var r41 = r[12],
                r42 = r[13],
                r43 = r[14],
                r44 = r[15];
                e[outOffset] = l11 * r11 + l12 * r21 + l13 * r31 + l14 * r41;
                e[outOffset + 1] = l11 * r12 + l12 * r22 + l13 * r32 + l14 * r42;
                e[outOffset + 2] = l11 * r13 + l12 * r23 + l13 * r33 + l14 * r43;
                e[outOffset + 3] = l11 * r14 + l12 * r24 + l13 * r34 + l14 * r44;
                e[outOffset + 4] = l21 * r11 + l22 * r21 + l23 * r31 + l24 * r41;
                e[outOffset + 5] = l21 * r12 + l22 * r22 + l23 * r32 + l24 * r42;
                e[outOffset + 6] = l21 * r13 + l22 * r23 + l23 * r33 + l24 * r43;
                e[outOffset + 7] = l21 * r14 + l22 * r24 + l23 * r34 + l24 * r44;
                e[outOffset + 8] = l31 * r11 + l32 * r21 + l33 * r31 + l34 * r41;
                e[outOffset + 9] = l31 * r12 + l32 * r22 + l33 * r32 + l34 * r42;
                e[outOffset + 10] = l31 * r13 + l32 * r23 + l33 * r33 + l34 * r43;
                e[outOffset + 11] = l31 * r14 + l32 * r24 + l33 * r34 + l34 * r44;
                e[outOffset + 12] = l41 * r11 + l42 * r21 + l43 * r31 + l44 * r41;
                e[outOffset + 13] = l41 * r12 + l42 * r22 + l43 * r32 + l44 * r42;
                e[outOffset + 14] = l41 * r13 + l42 * r23 + l43 * r33 + l44 * r43;
                e[outOffset + 15] = l41 * r14 + l42 * r24 + l43 * r34 + l44 * r44;
            }
        },
        {
            key: "arcTanAngle",
            value: function arcTanAngle(x, y) {
                if (x == 0) {
                    if (y == 1) return Math.PI / 2;
                    return - Math.PI / 2;
                }
                if (x > 0) return Math.atan(y / x);
                if (x < 0) {
                    if (y > 0) return Math.atan(y / x) + Math.PI;
                    return Math.atan(y / x) - Math.PI;
                }
                return 0;
            }
        },
        {
            key: "angleTo",
            value: function angleTo(from, location, angle) {
                Vector3.subtract(location, from, Quaternion.TEMPVector30);
                Vector3.normalize(Quaternion.TEMPVector30, Quaternion.TEMPVector30);
                angle.x = Math.asin(Quaternion.TEMPVector30.y);
                angle.y = Utils3D.arcTanAngle( - Quaternion.TEMPVector30.z, -Quaternion.TEMPVector30.x);
            }
        },
        {
            key: "transformQuat",
            value: function transformQuat(source, rotation, out) {
                var re = rotation;
                var x = source.x,
                y = source.y,
                z = source.z,
                qx = re[0],
                qy = re[1],
                qz = re[2],
                qw = re[3],
                ix = qw * x + qy * z - qz * y,
                iy = qw * y + qz * x - qx * z,
                iz = qw * z + qx * y - qy * x,
                iw = -qx * x - qy * y - qz * z;
                out.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
                out.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
                out.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
            }
        },
        {
            key: "quaternionWeight",
            value: function quaternionWeight(f, weight, e) {
                e.x = f.x * weight;
                e.y = f.y * weight;
                e.z = f.z * weight;
                e.w = f.w;
            }
        },
        {
            key: "quaternionConjugate",
            value: function quaternionConjugate(value, result) {
                result.x = -value.x;
                result.y = -value.y;
                result.z = -value.z;
                result.w = value.w;
            }
        },
        {
            key: "scaleWeight",
            value: function scaleWeight(s, w, out) {
                var sX = s.x,
                sY = s.y,
                sZ = s.z;
                out.x = sX > 0 ? Math.pow(Math.abs(sX), w) : -Math.pow(Math.abs(sX), w);
                out.y = sY > 0 ? Math.pow(Math.abs(sY), w) : -Math.pow(Math.abs(sY), w);
                out.z = sZ > 0 ? Math.pow(Math.abs(sZ), w) : -Math.pow(Math.abs(sZ), w);
            }
        },
        {
            key: "scaleBlend",
            value: function scaleBlend(sa, sb, w, out) {
                var saw = Utils3D._tempVector3_0;
                var sbw = Utils3D._tempVector3_1;
                Utils3D.scaleWeight(sa, 1.0 - w, saw);
                Utils3D.scaleWeight(sb, w, sbw);
                var sng = w > 0.5 ? sb: sa;
                out.x = sng.x > 0 ? Math.abs(saw.x * sbw.x) : -Math.abs(saw.x * sbw.x);
                out.y = sng.y > 0 ? Math.abs(saw.y * sbw.y) : -Math.abs(saw.y * sbw.y);
                out.z = sng.z > 0 ? Math.abs(saw.z * sbw.z) : -Math.abs(saw.z * sbw.z);
            }
        },
        {
            key: "matrix4x4MultiplyFFF",
            value: function matrix4x4MultiplyFFF(a, b, e) {
                var i, ai0, ai1, ai2, ai3;
                if (e === b) {
                    b = new Float32Array(16);
                    for (i = 0; i < 16; ++i) {
                        b[i] = e[i];
                    }
                }
                var b0 = b[0],
                b1 = b[1],
                b2 = b[2],
                b3 = b[3];
                var b4 = b[4],
                b5 = b[5],
                b6 = b[6],
                b7 = b[7];
                var b8 = b[8],
                b9 = b[9],
                b10 = b[10],
                b11 = b[11];
                var b12 = b[12],
                b13 = b[13],
                b14 = b[14],
                b15 = b[15];
                for (i = 0; i < 4; i++) {
                    ai0 = a[i];
                    ai1 = a[i + 4];
                    ai2 = a[i + 8];
                    ai3 = a[i + 12];
                    e[i] = ai0 * b0 + ai1 * b1 + ai2 * b2 + ai3 * b3;
                    e[i + 4] = ai0 * b4 + ai1 * b5 + ai2 * b6 + ai3 * b7;
                    e[i + 8] = ai0 * b8 + ai1 * b9 + ai2 * b10 + ai3 * b11;
                    e[i + 12] = ai0 * b12 + ai1 * b13 + ai2 * b14 + ai3 * b15;
                }
            }
        },
        {
            key: "matrix4x4MultiplyFFFForNative",
            value: function matrix4x4MultiplyFFFForNative(a, b, e) {
                Laya.LayaGL.instance.matrix4x4Multiply(a, b, e);
            }
        },
        {
            key: "matrix4x4MultiplyMFM",
            value: function matrix4x4MultiplyMFM(left, right, out) {
                Utils3D.matrix4x4MultiplyFFF(left.elements, right, out.elements);
            }
        },
        {
            key: "_buildTexture2D",
            value: function _buildTexture2D(width, height, format, colorFunc) {
                var mipmaps = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
                var texture = new Laya.Texture2D(width, height, format, mipmaps, true);
                texture.anisoLevel = 1;
                texture.filterMode = Laya.FilterMode.Point;
                TextureGenerator._generateTexture2D(texture, width, height, colorFunc);
                return texture;
            }
        },
        {
            key: "_drawBound",
            value: function _drawBound(debugLine, boundBox, color) {
                if (debugLine.lineCount + 12 > debugLine.maxLineCount) debugLine.maxLineCount += 12;
                var start = Utils3D._tempVector3_0;
                var end = Utils3D._tempVector3_1;
                var min = boundBox.min;
                var max = boundBox.max;
                start.setValue(min.x, min.y, min.z);
                end.setValue(max.x, min.y, min.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, min.y, min.z);
                end.setValue(min.x, min.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(max.x, min.y, min.z);
                end.setValue(max.x, min.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, min.y, max.z);
                end.setValue(max.x, min.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, min.y, min.z);
                end.setValue(min.x, max.y, min.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, min.y, max.z);
                end.setValue(min.x, max.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(max.x, min.y, min.z);
                end.setValue(max.x, max.y, min.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(max.x, min.y, max.z);
                end.setValue(max.x, max.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, max.y, min.z);
                end.setValue(max.x, max.y, min.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, max.y, min.z);
                end.setValue(min.x, max.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(max.x, max.y, min.z);
                end.setValue(max.x, max.y, max.z);
                debugLine.addLine(start, end, color, color);
                start.setValue(min.x, max.y, max.z);
                end.setValue(max.x, max.y, max.z);
                debugLine.addLine(start, end, color, color);
            }
        },
        {
            key: "_getHierarchyPath",
            value: function _getHierarchyPath(rootSprite, checkSprite, path) {
                path.length = 0;
                var sprite = checkSprite;
                while (sprite !== rootSprite) {
                    var parent = sprite._parent;
                    if (parent) path.push(parent.getChildIndex(sprite));
                    else return null;
                    sprite = parent;
                }
                return path;
            }
        },
        {
            key: "_getNodeByHierarchyPath",
            value: function _getNodeByHierarchyPath(rootSprite, invPath) {
                var sprite = rootSprite;
                for (var i = invPath.length - 1; i >= 0; i--) {
                    sprite = sprite.getChildAt(invPath[i]);
                }
                return sprite;
            }
        },
        {
            key: "uint8ArrayToArrayBuffer",
            value: function uint8ArrayToArrayBuffer(rendertexture) {
                var pixelArray;
                var width = rendertexture.width;
                var height = rendertexture.height;
                switch (rendertexture.format) {
                case Laya.RenderTextureFormat.R8G8B8:
                    pixelArray = new Uint8Array(width * height * 4);
                    break;
                case Laya.RenderTextureFormat.R8G8B8A8:
                    pixelArray = new Uint8Array(width * height * 4);
                    break;
                case Laya.RenderTextureFormat.R16G16B16A16:
                    pixelArray = new Float32Array(width * height * 4);
                    break;
                default:
                    throw "this function is not surpprt " + rendertexture.format.toString() + "format Material";
                }
                rendertexture.getData(0, 0, rendertexture.width, rendertexture.height, pixelArray);
                switch (rendertexture.format) {
                case Laya.RenderTextureFormat.R16G16B16A16:
                    var ori = pixelArray;
                    var trans = new Uint8Array(width * height * 4);
                    for (var i = 0,
                    n = ori.length; i < n; i++) {
                        trans[i] = Math.min(Math.floor(ori[i] * 255), 255);
                    }
                    pixelArray = trans;
                    break;
                }
                var pixels = pixelArray;
                var bs;
                if (Laya.Render.isConchApp);
                else {
                    var canv = new Laya.HTMLCanvas(true);
                    canv.lock = true;
                    canv.size(width, height);
                    var ctx2d = canv.getContext('2d');
                    var imgdata = ctx2d.createImageData(width, height);
                    imgdata.data.set(new Uint8ClampedArray(pixels));
                    ctx2d.putImageData(imgdata, 0, 0);
                    bs = canv.source.toDataURL();
                    canv.destroy();
                }
                return bs;
            }
        }]);
        return Utils3D;
    } ();
    Utils3D._tempVector3_0 = new Vector3();
    Utils3D._tempVector3_1 = new Vector3();
    Utils3D._tempArray16_0 = new Float32Array(16);
    Utils3D._tempArray16_1 = new Float32Array(16);
    Utils3D._tempArray16_2 = new Float32Array(16);
    Utils3D._tempArray16_3 = new Float32Array(16);
    Utils3D._compIdToNode = new Object();
    var AnimationClip =
    /*#__PURE__*/
    function(_Laya$Resource) {
        _inherits(AnimationClip, _Laya$Resource);
        var _super4 = _createSuper(AnimationClip);
        function AnimationClip() {
            var _this4;
            _classCallCheck(this, AnimationClip);
            _this4 = _super4.call(this);
            _this4._duration = 0;
            _this4._frameRate = 0;
            _this4._nodes = new KeyframeNodeList();
            _this4.islooping = false;
            _this4._animationEvents = [];
            return _this4;
        }
        _createClass(AnimationClip, [{
            key: "duration",
            value: function duration() {
                return this._duration;
            }
        },
        {
            key: "_weightModeHermite",
            value: function _weightModeHermite(weightMode, nextweightMode) {
                return (weightMode & exports.WeightedMode.Out) == 0 && (nextweightMode & exports.WeightedMode.In) == 0;
            }
        },
        {
            key: "_hermiteInterpolate",
            value: function _hermiteInterpolate(frame, nextFrame, t, dur) {
                var t0 = frame.outTangent,
                t1 = nextFrame.inTangent;
                if (Number.isFinite(t0) && Number.isFinite(t1)) {
                    var t2 = t * t;
                    var t3 = t2 * t;
                    var a = 2.0 * t3 - 3.0 * t2 + 1.0;
                    var b = t3 - 2.0 * t2 + t;
                    var c = t3 - t2;
                    var d = -2.0 * t3 + 3.0 * t2;
                    return a * frame.value + b * t0 * dur + c * t1 * dur + d * nextFrame.value;
                } else return frame.value;
            }
        },
        {
            key: "_hermiteInterpolateVector3",
            value: function _hermiteInterpolateVector3(frame, nextFrame, t, dur, out) {
                var p0 = frame.value;
                var tan0 = frame.outTangent;
                var p1 = nextFrame.value;
                var tan1 = nextFrame.inTangent;
                var t2 = t * t;
                var t3 = t2 * t;
                var a = 2.0 * t3 - 3.0 * t2 + 1.0;
                var b = t3 - 2.0 * t2 + t;
                var c = t3 - t2;
                var d = -2.0 * t3 + 3.0 * t2;
                var t0 = tan0.x,
                t1 = tan1.x;
                if (this._weightModeHermite(frame.weightedMode.x, nextFrame.weightedMode.x)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.x = a * p0.x + b * t0 * dur + c * t1 * dur + d * p1.x;
                    else out.x = p0.x;
                } else {
                    out.x = this._hermiteCurveSplineWeight(frame.value.x, frame.time, frame.outWeight.x, frame.outTangent.x, nextFrame.value.x, nextFrame.time, nextFrame.inWeight.x, nextFrame.inTangent.x, t);
                }
                t0 = tan0.y,
                t1 = tan1.y;
                if (this._weightModeHermite(frame.weightedMode.y, nextFrame.weightedMode.y)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.y = a * p0.y + b * t0 * dur + c * t1 * dur + d * p1.y;
                    else out.y = p0.y;
                } else {
                    out.y = this._hermiteCurveSplineWeight(frame.value.y, frame.time, frame.outWeight.y, frame.outTangent.y, nextFrame.value.y, nextFrame.time, nextFrame.inWeight.y, nextFrame.inTangent.y, t);
                }
                t0 = tan0.z,
                t1 = tan1.z;
                if (this._weightModeHermite(frame.weightedMode.z, nextFrame.weightedMode.z)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.z = a * p0.z + b * t0 * dur + c * t1 * dur + d * p1.z;
                    else out.z = p0.z;
                } else {
                    out.z = this._hermiteCurveSplineWeight(frame.value.z, frame.time, frame.outWeight.z, frame.outTangent.z, nextFrame.value.z, nextFrame.time, nextFrame.inWeight.z, nextFrame.inTangent.z, t);
                }
            }
        },
        {
            key: "_hermiteInterpolateQuaternion",
            value: function _hermiteInterpolateQuaternion(frame, nextFrame, t, dur, out) {
                var p0 = frame.value;
                var tan0 = frame.outTangent;
                var p1 = nextFrame.value;
                var tan1 = nextFrame.inTangent;
                var t2 = t * t;
                var t3 = t2 * t;
                var a = 2.0 * t3 - 3.0 * t2 + 1.0;
                var b = t3 - 2.0 * t2 + t;
                var c = t3 - t2;
                var d = -2.0 * t3 + 3.0 * t2;
                var t0 = tan0.x,
                t1 = tan1.x;
                if (this._weightModeHermite(frame.weightedMode.x, nextFrame.weightedMode.x)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.x = a * p0.x + b * t0 * dur + c * t1 * dur + d * p1.x;
                    else out.x = p0.x;
                } else {
                    out.x = this._hermiteCurveSplineWeight(frame.value.x, frame.time, frame.outWeight.x, frame.outTangent.x, nextFrame.value.x, nextFrame.time, nextFrame.inWeight.x, nextFrame.inTangent.x, t);
                }
                t0 = tan0.y,
                t1 = tan1.y;
                if (this._weightModeHermite(frame.weightedMode.y, nextFrame.weightedMode.y)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.y = a * p0.y + b * t0 * dur + c * t1 * dur + d * p1.y;
                    else out.y = p0.y;
                } else {
                    out.y = this._hermiteCurveSplineWeight(frame.value.y, frame.time, frame.outWeight.y, frame.outTangent.y, nextFrame.value.y, nextFrame.time, nextFrame.inWeight.y, nextFrame.inTangent.y, t);
                }
                t0 = tan0.z,
                t1 = tan1.z;
                if (this._weightModeHermite(frame.weightedMode.z, nextFrame.weightedMode.z)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.z = a * p0.z + b * t0 * dur + c * t1 * dur + d * p1.z;
                    else out.z = p0.z;
                } else {
                    out.z = this._hermiteCurveSplineWeight(frame.value.z, frame.time, frame.outWeight.z, frame.outTangent.z, nextFrame.value.z, nextFrame.time, nextFrame.inWeight.z, nextFrame.inTangent.z, t);
                }
                t0 = tan0.w,
                t1 = tan1.w;
                if (this._weightModeHermite(frame.weightedMode.w, nextFrame.weightedMode.w)) {
                    if (Number.isFinite(t0) && Number.isFinite(t1)) out.w = a * p0.w + b * t0 * dur + c * t1 * dur + d * p1.w;
                    else out.w = p0.w;
                } else {
                    out.w = this._hermiteCurveSplineWeight(frame.value.w, frame.time, frame.outWeight.w, frame.outTangent.w, nextFrame.value.w, nextFrame.time, nextFrame.inWeight.w, nextFrame.inTangent.w, t);
                }
            }
        },
        {
            key: "_hermiteCurveSplineWeight",
            value: function _hermiteCurveSplineWeight(frameValue, frametime, frameOutWeight, frameOutTangent, nextframeValue, nextframetime, nextframeInweight, nextframeIntangent, time) {
                var Eps = 2.22e-16;
                var x = time;
                var x1 = frametime;
                var y1 = frameValue;
                var wt1 = frameOutWeight;
                var x2 = nextframetime;
                var y2 = nextframeValue;
                var wt2 = nextframeInweight;
                var dx = x2 - x1;
                var dy = y2 - y1;
                dy = Math.max(Math.abs(dy), Eps) * (dy < 0 ? -1 : 1);
                var yp1 = frameOutTangent;
                var yp2 = nextframeIntangent;
                if (!Number.isFinite(yp1) || !Number.isFinite(yp2)) {
                    return frameValue;
                }
                yp1 = yp1 * dx / dy;
                yp2 = yp2 * dx / dy;
                var wt2s = 1 - wt2;
                var t = 0.5;
                var t2 = 0;
                if (Math.abs(wt1 - 0.33333334) < 0.0001 && Math.abs(wt2 - 0.33333334) < 0.0001) {
                    t = x;
                    t2 = 1 - t;
                } else {
                    while (true) {
                        t2 = 1 - t;
                        var fg = 3 * t2 * t2 * t * wt1 + 3 * t2 * t * t * wt2s + t * t * t - x;
                        if (Math.abs(fg) <= 2.5 * Eps) break;
                        var fpg = 3 * t2 * t2 * wt1 + 6 * t2 * t * (wt2s - wt1) + 3 * t * t * (1 - wt2s);
                        var fppg = 6 * t2 * (wt2s - 2 * wt1) + 6 * t * (1 - 2 * wt2s + wt1);
                        var fpppg = 18 * wt1 - 18 * wt2s + 6;
                        t -= (6 * fg * fpg * fpg - 3 * fg * fg * fppg) / (6 * fpg * fpg * fpg - 6 * fg * fpg * fppg + fg * fg * fpppg);
                    }
                }
                var y = 3 * t2 * t2 * t * wt1 * yp1 + 3 * t2 * t * t * (1 - wt2 * yp2) + t * t * t;
                return y * dy + y1;
            }
        },
        {
            key: "_curveInterpolate",
            value: function _curveInterpolate(frame, nextFrame, t, dur) {
                if (this._weightModeHermite(frame.weightedMode, nextFrame.weightedMode)) {
                    return this._hermiteInterpolate(frame, nextFrame, t, dur);
                } else {
                    return this._hermiteCurveSplineWeight(frame.value, frame.time, frame.outWeight, frame.outTangent, nextFrame.value, nextFrame.time, nextFrame.inWeight, nextFrame.inTangent, t);
                }
            }
        },
        {
            key: "_evaluateClipDatasRealTime",
            value: function _evaluateClipDatasRealTime(nodes, playCurTime, realTimeCurrentFrameIndexes, addtive, frontPlay, outDatas, avatarMask) {
                for (var i = 0,
                n = nodes.count; i < n; i++) {
                    var node = nodes.getNodeByIndex(i);
                    var type = node.type;
                    var nextFrameIndex;
                    var keyFrames = node._keyFrames;
                    var keyFramesCount = keyFrames.length;
                    var frameIndex = realTimeCurrentFrameIndexes[i];
                    if (avatarMask && !avatarMask.getTransformActive(node.nodePath)) {
                        continue;
                    }
                    if (frontPlay) {
                        if (frameIndex !== -1 && playCurTime < keyFrames[frameIndex].time) {
                            frameIndex = -1;
                            realTimeCurrentFrameIndexes[i] = frameIndex;
                        }
                        nextFrameIndex = frameIndex + 1;
                        while (nextFrameIndex < keyFramesCount) {
                            if (keyFrames[nextFrameIndex].time > playCurTime) break;
                            frameIndex++;
                            nextFrameIndex++;
                            realTimeCurrentFrameIndexes[i] = frameIndex;
                        }
                    } else {
                        nextFrameIndex = frameIndex + 1;
                        if (nextFrameIndex !== keyFramesCount && playCurTime > keyFrames[nextFrameIndex].time) {
                            frameIndex = keyFramesCount - 1;
                            realTimeCurrentFrameIndexes[i] = frameIndex;
                        }
                        nextFrameIndex = frameIndex + 1;
                        while (frameIndex > -1) {
                            if (keyFrames[frameIndex].time < playCurTime) break;
                            frameIndex--;
                            nextFrameIndex--;
                            realTimeCurrentFrameIndexes[i] = frameIndex;
                        }
                    }
                    var isEnd = nextFrameIndex === keyFramesCount;
                    switch (type) {
                    case 0:
                        if (frameIndex !== -1) {
                            var frame = keyFrames[frameIndex];
                            if (isEnd) {
                                outDatas[i] = frame.value;
                            } else {
                                var nextFarme = keyFrames[nextFrameIndex];
                                var d = nextFarme.time - frame.time;
                                var t;
                                if (d !== 0) t = (playCurTime - frame.time) / d;
                                else t = 0;
                                outDatas[i] = this._curveInterpolate(frame, nextFarme, t, d);
                            }
                        } else {
                            outDatas[i] = keyFrames[0].value;
                        }
                        if (addtive) outDatas[i] = outDatas[i] - keyFrames[0].value;
                        break;
                    case 1:
                    case 4:
                        var clipData = outDatas[i];
                        this._evaluateFrameNodeVector3DatasRealTime(keyFrames, frameIndex, isEnd, playCurTime, clipData);
                        if (addtive) {
                            var firstFrameValue = keyFrames[0].value;
                            clipData.x -= firstFrameValue.x;
                            clipData.y -= firstFrameValue.y;
                            clipData.z -= firstFrameValue.z;
                        }
                        break;
                    case 2:
                        var clipQuat = outDatas[i];
                        this._evaluateFrameNodeQuaternionDatasRealTime(keyFrames, frameIndex, isEnd, playCurTime, clipQuat);
                        if (addtive) {
                            var tempQuat = AnimationClip._tempQuaternion0;
                            var firstFrameValueQua = keyFrames[0].value;
                            Utils3D.quaternionConjugate(firstFrameValueQua, tempQuat);
                            Quaternion.multiply(tempQuat, clipQuat, clipQuat);
                        }
                        break;
                    case 3:
                        clipData = outDatas[i];
                        this._evaluateFrameNodeVector3DatasRealTime(keyFrames, frameIndex, isEnd, playCurTime, clipData);
                        if (addtive) {
                            firstFrameValue = keyFrames[0].value;
                            clipData.x /= firstFrameValue.x;
                            clipData.y /= firstFrameValue.y;
                            clipData.z /= firstFrameValue.z;
                        }
                        break;
                    default:
                        throw "AnimationClip:unknown node type.";
                    }
                }
            }
        },
        {
            key: "_evaluateClipDatasRealTimeForNative",
            value: function _evaluateClipDatasRealTimeForNative(nodes, playCurTime, realTimeCurrentFrameIndexes, addtive) {
                Laya.LayaGL.instance.evaluateClipDatasRealTime(nodes._nativeObj, playCurTime, realTimeCurrentFrameIndexes, addtive);
            }
        },
        {
            key: "_evaluateFrameNodeVector3DatasRealTime",
            value: function _evaluateFrameNodeVector3DatasRealTime(keyFrames, frameIndex, isEnd, playCurTime, outDatas) {
                if (frameIndex !== -1) {
                    var frame = keyFrames[frameIndex];
                    if (isEnd) {
                        var frameData = frame.value;
                        outDatas.x = frameData.x;
                        outDatas.y = frameData.y;
                        outDatas.z = frameData.z;
                    } else {
                        var nextKeyFrame = keyFrames[frameIndex + 1];
                        var t;
                        var startTime = frame.time;
                        var d = nextKeyFrame.time - startTime;
                        if (d !== 0) t = (playCurTime - startTime) / d;
                        else t = 0;
                        this._hermiteInterpolateVector3(frame, nextKeyFrame, t, d, outDatas);
                    }
                } else {
                    var firstFrameDatas = keyFrames[0].value;
                    outDatas.x = firstFrameDatas.x;
                    outDatas.y = firstFrameDatas.y;
                    outDatas.z = firstFrameDatas.z;
                }
            }
        },
        {
            key: "_evaluateFrameNodeQuaternionDatasRealTime",
            value: function _evaluateFrameNodeQuaternionDatasRealTime(keyFrames, frameIndex, isEnd, playCurTime, outDatas) {
                if (frameIndex !== -1) {
                    var frame = keyFrames[frameIndex];
                    if (isEnd) {
                        var frameData = frame.value;
                        outDatas.x = frameData.x;
                        outDatas.y = frameData.y;
                        outDatas.z = frameData.z;
                        outDatas.w = frameData.w;
                    } else {
                        var nextKeyFrame = keyFrames[frameIndex + 1];
                        var t;
                        var startTime = frame.time;
                        var d = nextKeyFrame.time - startTime;
                        if (d !== 0) t = (playCurTime - startTime) / d;
                        else t = 0;
                        this._hermiteInterpolateQuaternion(frame, nextKeyFrame, t, d, outDatas);
                    }
                } else {
                    var firstFrameDatas = keyFrames[0].value;
                    outDatas.x = firstFrameDatas.x;
                    outDatas.y = firstFrameDatas.y;
                    outDatas.z = firstFrameDatas.z;
                    outDatas.w = firstFrameDatas.w;
                }
            }
        },
        {
            key: "_binarySearchEventIndex",
            value: function _binarySearchEventIndex(time) {
                var start = 0;
                var end = this._animationEvents.length - 1;
                var mid;
                while (start <= end) {
                    mid = Math.floor((start + end) / 2);
                    var midValue = this._animationEvents[mid].time;
                    if (midValue == time) return mid;
                    else if (midValue > time) end = mid - 1;
                    else start = mid + 1;
                }
                return start;
            }
        },
        {
            key: "addEvent",
            value: function addEvent(event) {
                var index = this._binarySearchEventIndex(event.time);
                this._animationEvents.splice(index, 0, event);
            }
        },
        {
            key: "_disposeResource",
            value: function _disposeResource() {
                this._nodes = null;
                this._nodesMap = null;
            }
        }], [{
            key: "_parse",
            value: function _parse(data) {
                var clip = new AnimationClip();
                var reader = new Laya.Byte(data);
                var version = reader.readUTFString();
                switch (version) {
                case "LAYAANIMATION:03":
                    AnimationClipParser03.parse(clip, reader);
                    break;
                case "LAYAANIMATION:04":
                case "LAYAANIMATION:COMPRESSION_04":
                case "LAYAANIMATION:WEIGHT_04":
                    AnimationClipParser04.parse(clip, reader, version);
                    break;
                default:
                    throw "unknown animationClip version.";
                }
                return clip;
            }
        },
        {
            key: "load",
            value: function load(url, complete) {
                Laya.ILaya.loader.create(url, complete, null, AnimationClip.ANIMATIONCLIP);
            }
        }]);
        return AnimationClip;
    } (Laya.Resource);
    AnimationClip.ANIMATIONCLIP = "ANIMATIONCLIP";
    AnimationClip._tempQuaternion0 = new Quaternion();
    var AnimatorPlayState =
    /*#__PURE__*/
    function() {
        function AnimatorPlayState() {
            _classCallCheck(this, AnimatorPlayState);
            this._currentState = null;
        }
        _createClass(AnimatorPlayState, [{
            key: "normalizedTime",
            get: function get() {
                return this._normalizedTime;
            }
        },
        {
            key: "duration",
            get: function get() {
                return this._duration;
            }
        },
        {
            key: "animatorState",
            get: function get() {
                return this._currentState;
            }
        },
        {
            key: "_resetPlayState",
            value: function _resetPlayState(startTime, clipDuration) {
                this._finish = false;
                this._startPlayTime = startTime;
                this._elapsedTime = startTime;
                this._playEventIndex = 0;
                this._lastIsFront = true;
                this._normalizedTime = this._elapsedTime / clipDuration;
                var playTime = this._normalizedTime % 1.0;
                this._normalizedPlayTime = playTime < 0 ? playTime + 1.0 : playTime;
            }
        },
        {
            key: "_cloneTo",
            value: function _cloneTo(dest) {
                dest._finish = this._finish;
                dest._startPlayTime = this._startPlayTime;
                dest._elapsedTime = this._elapsedTime;
                dest._normalizedTime = this._normalizedTime;
                dest._normalizedPlayTime = this._normalizedPlayTime;
                dest._playEventIndex = this._playEventIndex;
                dest._lastIsFront = this._lastIsFront;
            }
        }]);
        return AnimatorPlayState;
    } ();
    var AnimatorControllerLayer =
    /*#__PURE__*/
    function() {
        function AnimatorControllerLayer(name) {
            _classCallCheck(this, AnimatorControllerLayer);
            this._referenceCount = 0;
            this._playType = -1;
            this._crossDuration = -1;
            this._crossMark = 0;
            this._crossNodesOwnersCount = 0;
            this._crossNodesOwners = [];
            this._crossNodesOwnersIndicesMap = {};
            this._srcCrossClipNodeIndices = [];
            this._destCrossClipNodeIndices = [];
            this._statesMap = {};
            this._states = [];
            this._playStateInfo = new AnimatorPlayState();
            this._crossPlayStateInfo = new AnimatorPlayState();
            this.blendingMode = AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
            this.defaultWeight = 1.0;
            this.playOnWake = true;
            this.name = name;
        }
        _createClass(AnimatorControllerLayer, [{
            key: "defaultState",
            get: function get() {
                return this._defaultState;
            },
            set: function set(value) {
                this._defaultState = value;
                this._statesMap[value.name] = value;
            }
        },
        {
            key: "avatarMask",
            get: function get() {
                return this._avatarMask;
            },
            set: function set(value) {
                this._avatarMask = value;
            }
        },
        {
            key: "_removeClip",
            value: function _removeClip(clipStateInfos, statesMap, index, state) {
                var clip = state._clip;
                var clipStateInfo = clipStateInfos[index];
                clipStateInfos.splice(index, 1);
                delete statesMap[state.name];
                if (this._animator) {
                    var frameNodes = clip._nodes;
                    var nodeOwners = clipStateInfo._nodeOwners;
                    clip._removeReference();
                    for (var i = 0,
                    n = frameNodes.count; i < n; i++) {
                        this._animator._removeKeyframeNodeOwner(nodeOwners, frameNodes.getNodeByIndex(i));
                    }
                }
            }
        },
        {
            key: "_getReferenceCount",
            value: function _getReferenceCount() {
                return this._referenceCount;
            }
        },
        {
            key: "_addReference",
            value: function _addReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                for (var i = 0,
                n = this._states.length; i < n; i++) {
                    this._states[i]._addReference(count);
                }
                this._referenceCount += count;
            }
        },
        {
            key: "_removeReference",
            value: function _removeReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                for (var i = 0,
                n = this._states.length; i < n; i++) {
                    this._states[i]._removeReference(count);
                }
                this._referenceCount -= count;
            }
        },
        {
            key: "_clearReference",
            value: function _clearReference() {
                this._removeReference( - this._referenceCount);
            }
        },
        {
            key: "getCurrentPlayState",
            value: function getCurrentPlayState() {
                return this._playStateInfo;
            }
        },
        {
            key: "getAnimatorState",
            value: function getAnimatorState(name) {
                var state = this._statesMap[name];
                return state ? state: null;
            }
        },
        {
            key: "addState",
            value: function addState(state) {
                var stateName = state.name;
                if (this._statesMap[stateName]) {
                    throw "AnimatorControllerLayer:this stat's name has exist.";
                } else {
                    this._statesMap[stateName] = state;
                    this._states.push(state);
                    if (this._animator) {
                        state._clip && state._clip._addReference();
                        this._animator._getOwnersByClip(state);
                    }
                }
            }
        },
        {
            key: "removeState",
            value: function removeState(state) {
                var states = this._states;
                var index = -1;
                for (var i = 0,
                n = states.length; i < n; i++) {
                    if (states[i] === state) {
                        index = i;
                        break;
                    }
                }
                if (index !== -1) this._removeClip(states, this._statesMap, index, state);
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                this._clearReference();
                this._statesMap = null;
                this._states = [];
                this._playStateInfo = null;
                this._crossPlayStateInfo = null;
                this._defaultState = null;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                dest.name = this.name;
                dest.blendingMode = this.blendingMode;
                dest.defaultWeight = this.defaultWeight;
                dest.playOnWake = this.playOnWake;
                this.avatarMask && (dest.avatarMask = this._avatarMask.clone());
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new AnimatorControllerLayer(this.name);
                this.cloneTo(dest);
                return dest;
            }
        }]);
        return AnimatorControllerLayer;
    } ();
    AnimatorControllerLayer.BLENDINGMODE_OVERRIDE = 0;
    AnimatorControllerLayer.BLENDINGMODE_ADDTIVE = 1;
    var AnimatorState =
    /*#__PURE__*/
    function() {
        function AnimatorState() {
            _classCallCheck(this, AnimatorState);
            this._referenceCount = 0;
            this._clip = null;
            this._nodeOwners = [];
            this._currentFrameIndices = null;
            this._realtimeDatas = [];
            this._scripts = null;
            this.speed = 1.0;
            this.clipStart = 0.0;
            this.clipEnd = 1.0;
        }
        _createClass(AnimatorState, [{
            key: "clip",
            get: function get() {
                return this._clip;
            },
            set: function set(value) {
                if (this._clip !== value) {
                    if (this._clip) this._referenceCount > 0 && this._clip._removeReference(this._referenceCount);
                    if (value) {
                        var realtimeDatas = this._realtimeDatas;
                        var clipNodes = value._nodes;
                        var count = clipNodes.count;
                        this._currentFrameIndices = new Int16Array(count);
                        this._resetFrameIndices();
                        this._referenceCount > 0 && value._addReference(this._referenceCount);
                        this._realtimeDatas.length = count;
                        for (var i = 0; i < count; i++) {
                            switch (clipNodes.getNodeByIndex(i).type) {
                            case 0:
                                break;
                            case 1:
                            case 3:
                            case 4:
                                realtimeDatas[i] = new Vector3();
                                break;
                            case 2:
                                realtimeDatas[i] = new Quaternion();
                                break;
                            default:
                                throw "AnimationClipParser04:unknown type.";
                            }
                        }
                    }
                    this._clip = value;
                }
            }
        },
        {
            key: "_getReferenceCount",
            value: function _getReferenceCount() {
                return this._referenceCount;
            }
        },
        {
            key: "_addReference",
            value: function _addReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                this._clip && this._clip._addReference(count);
                this._referenceCount += count;
            }
        },
        {
            key: "_removeReference",
            value: function _removeReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                this._clip && this._clip._removeReference(count);
                this._referenceCount -= count;
            }
        },
        {
            key: "_clearReference",
            value: function _clearReference() {
                this._removeReference( - this._referenceCount);
            }
        },
        {
            key: "_resetFrameIndices",
            value: function _resetFrameIndices() {
                for (var i = 0,
                n = this._currentFrameIndices.length; i < n; i++) {
                    this._currentFrameIndices[i] = -1;
                }
            }
        },
        {
            key: "addScript",
            value: function addScript(type) {
                var script = new type();
                this._scripts = this._scripts || [];
                this._scripts.push(script);
                return script;
            }
        },
        {
            key: "getScript",
            value: function getScript(type) {
                if (this._scripts) {
                    for (var i = 0,
                    n = this._scripts.length; i < n; i++) {
                        var script = this._scripts[i];
                        if (script instanceof type) return script;
                    }
                }
                return null;
            }
        },
        {
            key: "getScripts",
            value: function getScripts(type) {
                var coms = null;
                if (this._scripts) {
                    for (var i = 0,
                    n = this._scripts.length; i < n; i++) {
                        var script = this._scripts[i];
                        if (script instanceof type) {
                            coms = coms || [];
                            coms.push(script);
                        }
                    }
                }
                return coms;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                dest.name = this.name;
                dest.speed = this.speed;
                dest.clipStart = this.clipStart;
                dest.clipEnd = this.clipEnd;
                dest.clip = this._clip;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new AnimatorState();
                this.cloneTo(dest);
                return dest;
            }
        }]);
        return AnimatorState;
    } ();
    var AvatarMask =
    /*#__PURE__*/
    function() {
        function AvatarMask() {
            _classCallCheck(this, AvatarMask);
            this._avatarPathMap = {};
        }
        _createClass(AvatarMask, [{
            key: "getTransformActive",
            value: function getTransformActive(path) {
                return this._avatarPathMap[path];
            }
        },
        {
            key: "setTransformActive",
            value: function setTransformActive(path, value) {
                this._avatarPathMap[path] = value;
            }
        },
        {
            key: "getAllTranfromPath",
            value: function getAllTranfromPath() {
                return this._avatarPathMap;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new AvatarMask();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                for (var key in this._avatarPathMap) {
                    dest.setTransformActive(key, this._avatarPathMap[key]);
                }
            }
        }]);
        return AvatarMask;
    } ();
    var KeyframeNodeOwner =
    /*#__PURE__*/
    function() {
        function KeyframeNodeOwner() {
            _classCallCheck(this, KeyframeNodeOwner);
            this.indexInList = -1;
            this.referenceCount = 0;
            this.updateMark = -1;
            this.type = -1;
            this.fullPath = null;
            this.nodePath = null;
            this.propertyOwner = null;
            this.property = null;
            this.defaultValue = null;
            this.value = null;
            this.crossFixedValue = null;
        }
        _createClass(KeyframeNodeOwner, [{
            key: "saveCrossFixedValue",
            value: function saveCrossFixedValue() {
                var pro = this.propertyOwner;
                if (pro) {
                    switch (this.type) {
                    case 0:
                        this.crossFixedValue = this.value;
                        break;
                    case 1:
                    case 3:
                    case 4:
                        this.value.cloneTo(this.crossFixedValue);
                        break;
                    case 2:
                        this.value.cloneTo(this.crossFixedValue);
                        break;
                    default:
                        throw "Animator:unknown type.";
                    }
                }
            }
        }]);
        return KeyframeNodeOwner;
    } (); (function(AnimatorUpdateMode) {
        AnimatorUpdateMode[AnimatorUpdateMode["Normal"] = 0] = "Normal";
        AnimatorUpdateMode[AnimatorUpdateMode["LowFrame"] = 1] = "LowFrame";
        AnimatorUpdateMode[AnimatorUpdateMode["UnScaleTime"] = 2] = "UnScaleTime";
    })(exports.AnimatorUpdateMode || (exports.AnimatorUpdateMode = {}));
    var Animator =
    /*#__PURE__*/
    function(_Laya$Component) {
        _inherits(Animator, _Laya$Component);
        var _super5 = _createSuper(Animator);
        function Animator() {
            var _this5;
            _classCallCheck(this, Animator);
            _this5 = _super5.call(this);
            _this5._keyframeNodeOwners = [];
            _this5._updateMode = exports.AnimatorUpdateMode.Normal;
            _this5._lowUpdateDelty = 20;
            _this5._linkAvatarSpritesData = {};
            _this5._linkAvatarSprites = [];
            _this5._renderableSprites = [];
            _this5.cullingMode = Animator.CULLINGMODE_CULLCOMPLETELY;
            _this5._controllerLayers = [];
            _this5._linkSprites = {};
            _this5._speed = 1.0;
            _this5._keyframeNodeOwnerMap = {};
            _this5._updateMark = 0;
            return _this5;
        }
        _createClass(Animator, [{
            key: "speed",
            get: function get() {
                return this._speed;
            },
            set: function set(value) {
                this._speed = value;
            }
        },
        {
            key: "updateMode",
            set: function set(value) {
                this._updateMode = value;
            }
        },
        {
            key: "lowUpdateDelty",
            set: function set(value) {
                this._lowUpdateDelty = value;
            }
        },
        {
            key: "controllerLayerCount",
            get: function get() {
                return this._controllerLayers.length;
            }
        },
        {
            key: "_linkToSprites",
            value: function _linkToSprites(linkSprites) {
                for (var k in linkSprites) {
                    var nodeOwner = this.owner;
                    var path = linkSprites[k];
                    for (var j = 0,
                    m = path.length; j < m; j++) {
                        var p = path[j];
                        if (p === "") {
                            break;
                        } else {
                            nodeOwner = nodeOwner.getChildByName(p);
                            if (!nodeOwner) break;
                        }
                    }
                    nodeOwner && this.linkSprite3DToAvatarNode(k, nodeOwner);
                }
            }
        },
        {
            key: "_addKeyframeNodeOwner",
            value: function _addKeyframeNodeOwner(clipOwners, node, propertyOwner) {
                var nodeIndex = node._indexInList;
                var fullPath = node.fullPath;
                var keyframeNodeOwner = this._keyframeNodeOwnerMap[fullPath];
                if (keyframeNodeOwner) {
                    keyframeNodeOwner.referenceCount++;
                    clipOwners[nodeIndex] = keyframeNodeOwner;
                } else {
                    var property = propertyOwner;
                    for (var i = 0,
                    n = node.propertyCount; i < n; i++) {
                        property = property[node.getPropertyByIndex(i)];
                        if (!property) break;
                    }
                    keyframeNodeOwner = this._keyframeNodeOwnerMap[fullPath] = new KeyframeNodeOwner();
                    keyframeNodeOwner.fullPath = fullPath;
                    keyframeNodeOwner.indexInList = this._keyframeNodeOwners.length;
                    keyframeNodeOwner.referenceCount = 1;
                    keyframeNodeOwner.propertyOwner = propertyOwner;
                    keyframeNodeOwner.nodePath = node.nodePath;
                    var propertyCount = node.propertyCount;
                    var propertys = [];
                    for (i = 0; i < propertyCount; i++) {
                        propertys[i] = node.getPropertyByIndex(i);
                    }
                    keyframeNodeOwner.property = propertys;
                    keyframeNodeOwner.type = node.type;
                    if (property) {
                        if (node.type === 0) {
                            keyframeNodeOwner.defaultValue = property;
                        } else {
                            var defaultValue = new property.constructor();
                            property.cloneTo(defaultValue);
                            keyframeNodeOwner.defaultValue = defaultValue;
                            keyframeNodeOwner.value = new property.constructor();
                            keyframeNodeOwner.crossFixedValue = new property.constructor();
                        }
                    }
                    this._keyframeNodeOwners.push(keyframeNodeOwner);
                    clipOwners[nodeIndex] = keyframeNodeOwner;
                }
            }
        },
        {
            key: "_removeKeyframeNodeOwner",
            value: function _removeKeyframeNodeOwner(nodeOwners, node) {
                var fullPath = node.fullPath;
                var keyframeNodeOwner = this._keyframeNodeOwnerMap[fullPath];
                if (keyframeNodeOwner) {
                    keyframeNodeOwner.referenceCount--;
                    if (keyframeNodeOwner.referenceCount === 0) {
                        delete this._keyframeNodeOwnerMap[fullPath];
                        this._keyframeNodeOwners.splice(this._keyframeNodeOwners.indexOf(keyframeNodeOwner), 1);
                    }
                    nodeOwners[node._indexInList] = null;
                }
            }
        },
        {
            key: "_getOwnersByClip",
            value: function _getOwnersByClip(clipStateInfo) {
                var frameNodes = clipStateInfo._clip._nodes;
                var frameNodesCount = frameNodes.count;
                var nodeOwners = clipStateInfo._nodeOwners;
                nodeOwners.length = frameNodesCount;
                for (var i = 0; i < frameNodesCount; i++) {
                    var node = frameNodes.getNodeByIndex(i);
                    var property = this._avatar ? this._avatarNodeMap[this._avatar._rootNode.name] : this.owner;
                    for (var j = 0,
                    m = node.ownerPathCount; j < m; j++) {
                        var ownPat = node.getOwnerPathByIndex(j);
                        if (ownPat === "") {
                            break;
                        } else {
                            property = property.getChildByName(ownPat);
                            if (!property) break;
                        }
                    }
                    if (property) {
                        var propertyOwner = node.propertyOwner;
                        propertyOwner && (property = property[propertyOwner]);
                        property && this._addKeyframeNodeOwner(nodeOwners, node, property);
                    }
                }
            }
        },
        {
            key: "_updatePlayer",
            value: function _updatePlayer(animatorState, playState, elapsedTime, islooping) {
                var clipDuration = animatorState._clip._duration * (animatorState.clipEnd - animatorState.clipStart);
                var lastElapsedTime = playState._elapsedTime;
                var elapsedPlaybackTime = lastElapsedTime + elapsedTime;
                playState._lastElapsedTime = lastElapsedTime;
                playState._elapsedTime = elapsedPlaybackTime;
                var normalizedTime = elapsedPlaybackTime / clipDuration;
                playState._normalizedTime = normalizedTime;
                var playTime = normalizedTime % 1.0;
                playState._normalizedPlayTime = playTime < 0 ? playTime + 1.0 : playTime;
                playState._duration = clipDuration;
                var scripts = animatorState._scripts;
                if (!islooping && elapsedPlaybackTime >= clipDuration) {
                    playState._finish = true;
                    playState._elapsedTime = clipDuration;
                    playState._normalizedPlayTime = 1.0;
                    return;
                }
                if (scripts) {
                    for (var i = 0,
                    n = scripts.length; i < n; i++) {
                        scripts[i].onStateUpdate();
                    }
                }
            }
        },
        {
            key: "_updateStateFinish",
            value: function _updateStateFinish(animatorState, playState) {
                if (playState._finish) {
                    var scripts = animatorState._scripts;
                    if (scripts) {
                        for (var i = 0,
                        n = scripts.length; i < n; i++) {
                            scripts[i].onStateExit();
                        }
                    }
                }
            }
        },
        {
            key: "_eventScript",
            value: function _eventScript(scripts, events, eventIndex, endTime, front) {
                if (front) {
                    for (var n = events.length; eventIndex < n; eventIndex++) {
                        var event = events[eventIndex];
                        if (event.time <= endTime) {
                            for (var j = 0,
                            m = scripts.length; j < m; j++) {
                                var script = scripts[j];
                                var fun = script[event.eventName];
                                fun && fun.apply(script, event.params);
                            }
                        } else {
                            break;
                        }
                    }
                } else {
                    for (; eventIndex >= 0; eventIndex--) {
                        event = events[eventIndex];
                        if (event.time >= endTime) {
                            for (j = 0, m = scripts.length; j < m; j++) {
                                script = scripts[j];
                                fun = script[event.eventName];
                                fun && fun.apply(script, event.params);
                            }
                        } else {
                            break;
                        }
                    }
                }
                return eventIndex;
            }
        },
        {
            key: "_updateEventScript",
            value: function _updateEventScript(stateInfo, playStateInfo) {
                var scripts = this.owner._scripts;
                if (scripts) {
                    var clip = stateInfo._clip;
                    var events = clip._animationEvents;
                    var clipDuration = clip._duration;
                    var elapsedTime = playStateInfo._elapsedTime;
                    var time = elapsedTime % clipDuration;
                    var loopCount = Math.abs(Math.floor(elapsedTime / clipDuration) - Math.floor(playStateInfo._lastElapsedTime / clipDuration));
                    var frontPlay = playStateInfo._elapsedTime >= playStateInfo._lastElapsedTime;
                    if (playStateInfo._lastIsFront !== frontPlay) {
                        if (frontPlay) playStateInfo._playEventIndex++;
                        else playStateInfo._playEventIndex--;
                        playStateInfo._lastIsFront = frontPlay;
                    }
                    var preEventIndex = playStateInfo._playEventIndex;
                    if (frontPlay) {
                        var newEventIndex = this._eventScript(scripts, events, playStateInfo._playEventIndex, loopCount > 0 ? clipDuration: time, true);
                        preEventIndex === playStateInfo._playEventIndex && (playStateInfo._playEventIndex = newEventIndex);
                        for (var i = 0,
                        n = loopCount - 1; i < n; i++) {
                            this._eventScript(scripts, events, 0, clipDuration, true);
                        }
                        loopCount > 0 && time > 0 && (playStateInfo._playEventIndex = this._eventScript(scripts, events, 0, time, true));
                    } else {
                        var newEventIndex = this._eventScript(scripts, events, playStateInfo._playEventIndex, loopCount > 0 ? 0 : time, false);
                        preEventIndex === playStateInfo._playEventIndex && (playStateInfo._playEventIndex = newEventIndex);
                        var eventIndex = events.length - 1;
                        for (i = 0, n = loopCount - 1; i < n; i++) {
                            this._eventScript(scripts, events, eventIndex, 0, false);
                        }
                        loopCount > 0 && time > 0 && (playStateInfo._playEventIndex = this._eventScript(scripts, events, eventIndex, time, false));
                    }
                }
            }
        },
        {
            key: "_updateClipDatas",
            value: function _updateClipDatas(animatorState, addtive, playStateInfo) {
                var animatorMask = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var clip = animatorState._clip;
                var clipDuration = clip._duration;
                var curPlayTime = animatorState.clipStart * clipDuration + playStateInfo._normalizedPlayTime * playStateInfo._duration;
                var currentFrameIndices = animatorState._currentFrameIndices;
                var frontPlay = playStateInfo._elapsedTime > playStateInfo._lastElapsedTime;
                clip._evaluateClipDatasRealTime(clip._nodes, curPlayTime, currentFrameIndices, addtive, frontPlay, animatorState._realtimeDatas, animatorMask);
            }
        },
        {
            key: "_applyFloat",
            value: function _applyFloat(pro, proName, nodeOwner, additive, weight, isFirstLayer, data) {
                if (nodeOwner.updateMark === this._updateMark) {
                    if (additive) {
                        pro[proName] += weight * data;
                    } else {
                        var oriValue = pro[proName];
                        pro[proName] = oriValue + weight * (data - oriValue);
                    }
                } else {
                    if (isFirstLayer) {
                        if (additive) pro[proName] = nodeOwner.defaultValue + data;
                        else pro[proName] = data;
                    } else {
                        if (additive) {
                            pro[proName] = nodeOwner.defaultValue + weight * data;
                        } else {
                            var defValue = nodeOwner.defaultValue;
                            pro[proName] = defValue + weight * (data - defValue);
                        }
                    }
                }
            }
        },
        {
            key: "_applyPositionAndRotationEuler",
            value: function _applyPositionAndRotationEuler(nodeOwner, additive, weight, isFirstLayer, data, out) {
                if (nodeOwner.updateMark === this._updateMark) {
                    if (additive) {
                        out.x += weight * data.x;
                        out.y += weight * data.y;
                        out.z += weight * data.z;
                    } else {
                        var oriX = out.x;
                        var oriY = out.y;
                        var oriZ = out.z;
                        out.x = oriX + weight * (data.x - oriX);
                        out.y = oriY + weight * (data.y - oriY);
                        out.z = oriZ + weight * (data.z - oriZ);
                    }
                } else {
                    if (isFirstLayer) {
                        if (additive) {
                            var defValue = nodeOwner.defaultValue;
                            out.x = defValue.x + data.x;
                            out.y = defValue.y + data.y;
                            out.z = defValue.z + data.z;
                        } else {
                            out.x = data.x;
                            out.y = data.y;
                            out.z = data.z;
                        }
                    } else {
                        defValue = nodeOwner.defaultValue;
                        if (additive) {
                            out.x = defValue.x + weight * data.x;
                            out.y = defValue.y + weight * data.y;
                            out.z = defValue.z + weight * data.z;
                        } else {
                            var defX = defValue.x;
                            var defY = defValue.y;
                            var defZ = defValue.z;
                            out.x = defX + weight * (data.x - defX);
                            out.y = defY + weight * (data.y - defY);
                            out.z = defZ + weight * (data.z - defZ);
                        }
                    }
                }
            }
        },
        {
            key: "_applyRotation",
            value: function _applyRotation(nodeOwner, additive, weight, isFirstLayer, clipRot, localRotation) {
                if (nodeOwner.updateMark === this._updateMark) {
                    if (additive) {
                        var tempQuat = Animator._tempQuaternion1;
                        Utils3D.quaternionWeight(clipRot, weight, tempQuat);
                        tempQuat.normalize(tempQuat);
                        Quaternion.multiply(localRotation, tempQuat, localRotation);
                    } else {
                        Quaternion.lerp(localRotation, clipRot, weight, localRotation);
                    }
                } else {
                    if (isFirstLayer) {
                        if (additive) {
                            var defaultRot = nodeOwner.defaultValue;
                            Quaternion.multiply(defaultRot, clipRot, localRotation);
                        } else {
                            localRotation.x = clipRot.x;
                            localRotation.y = clipRot.y;
                            localRotation.z = clipRot.z;
                            localRotation.w = clipRot.w;
                        }
                    } else {
                        defaultRot = nodeOwner.defaultValue;
                        if (additive) {
                            tempQuat = Animator._tempQuaternion1;
                            Utils3D.quaternionWeight(clipRot, weight, tempQuat);
                            tempQuat.normalize(tempQuat);
                            Quaternion.multiply(defaultRot, tempQuat, localRotation);
                        } else {
                            Quaternion.lerp(defaultRot, clipRot, weight, localRotation);
                        }
                    }
                }
            }
        },
        {
            key: "_applyScale",
            value: function _applyScale(nodeOwner, additive, weight, isFirstLayer, clipSca, localScale) {
                if (nodeOwner.updateMark === this._updateMark) {
                    if (additive) {
                        var scale = Animator._tempVector31;
                        Utils3D.scaleWeight(clipSca, weight, scale);
                        localScale.x = localScale.x * scale.x;
                        localScale.y = localScale.y * scale.y;
                        localScale.z = localScale.z * scale.z;
                    } else {
                        Utils3D.scaleBlend(localScale, clipSca, weight, localScale);
                    }
                } else {
                    if (isFirstLayer) {
                        if (additive) {
                            var defaultSca = nodeOwner.defaultValue;
                            localScale.x = defaultSca.x * clipSca.x;
                            localScale.y = defaultSca.y * clipSca.y;
                            localScale.z = defaultSca.z * clipSca.z;
                        } else {
                            localScale.x = clipSca.x;
                            localScale.y = clipSca.y;
                            localScale.z = clipSca.z;
                        }
                    } else {
                        defaultSca = nodeOwner.defaultValue;
                        if (additive) {
                            scale = Animator._tempVector31;
                            Utils3D.scaleWeight(clipSca, weight, scale);
                            localScale.x = defaultSca.x * scale.x;
                            localScale.y = defaultSca.y * scale.y;
                            localScale.z = defaultSca.z * scale.z;
                        } else {
                            Utils3D.scaleBlend(defaultSca, clipSca, weight, localScale);
                        }
                    }
                }
            }
        },
        {
            key: "_applyCrossData",
            value: function _applyCrossData(nodeOwner, additive, weight, isFirstLayer, srcValue, desValue, crossWeight) {
                var pro = nodeOwner.propertyOwner;
                if (pro) {
                    switch (nodeOwner.type) {
                    case 0:
                        var proPat = nodeOwner.property;
                        var m = proPat.length - 1;
                        for (var j = 0; j < m; j++) {
                            pro = pro[proPat[j]];
                            if (!pro) break;
                        }
                        var crossValue = srcValue + crossWeight * (desValue - srcValue);
                        nodeOwner.value = crossValue;
                        pro && this._applyFloat(pro, proPat[m], nodeOwner, additive, weight, isFirstLayer, crossValue);
                        break;
                    case 1:
                        var localPos = pro.localPosition;
                        var position = nodeOwner.value;
                        var srcX = srcValue.x,
                        srcY = srcValue.y,
                        srcZ = srcValue.z;
                        position.x = srcX + crossWeight * (desValue.x - srcX);
                        position.y = srcY + crossWeight * (desValue.y - srcY);
                        position.z = srcZ + crossWeight * (desValue.z - srcZ);
                        this._applyPositionAndRotationEuler(nodeOwner, additive, weight, isFirstLayer, position, localPos);
                        pro.localPosition = localPos;
                        break;
                    case 2:
                        var localRot = pro.localRotation;
                        var rotation = nodeOwner.value;
                        Quaternion.lerp(srcValue, desValue, crossWeight, rotation);
                        this._applyRotation(nodeOwner, additive, weight, isFirstLayer, rotation, localRot);
                        pro.localRotation = localRot;
                        break;
                    case 3:
                        var localSca = pro.localScale;
                        var scale = nodeOwner.value;
                        Utils3D.scaleBlend(srcValue, desValue, crossWeight, scale);
                        this._applyScale(nodeOwner, additive, weight, isFirstLayer, scale, localSca);
                        pro.localScale = localSca;
                        break;
                    case 4:
                        var localEuler = pro.localRotationEuler;
                        var rotationEuler = nodeOwner.value;
                        srcX = srcValue.x,
                        srcY = srcValue.y,
                        srcZ = srcValue.z;
                        rotationEuler.x = srcX + crossWeight * (desValue.x - srcX);
                        rotationEuler.y = srcY + crossWeight * (desValue.y - srcY);
                        rotationEuler.z = srcZ + crossWeight * (desValue.z - srcZ);
                        this._applyPositionAndRotationEuler(nodeOwner, additive, weight, isFirstLayer, rotationEuler, localEuler);
                        pro.localRotationEuler = localEuler;
                        break;
                    }
                    nodeOwner.updateMark = this._updateMark;
                }
            }
        },
        {
            key: "_setClipDatasToNode",
            value: function _setClipDatasToNode(stateInfo, additive, weight, isFirstLayer) {
                var controllerLayer = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                var realtimeDatas = stateInfo._realtimeDatas;
                var nodes = stateInfo._clip._nodes;
                var nodeOwners = stateInfo._nodeOwners;
                for (var i = 0,
                n = nodes.count; i < n; i++) {
                    var nodeOwner = nodeOwners[i];
                    if (nodeOwner) {
                        var node = nodes.getNodeByIndex(i);
                        if (controllerLayer.avatarMask && !controllerLayer.avatarMask.getTransformActive(node.nodePath)) {
                            continue;
                        }
                        var pro = nodeOwner.propertyOwner;
                        if (pro) {
                            switch (nodeOwner.type) {
                            case 0:
                                var proPat = nodeOwner.property;
                                var m = proPat.length - 1;
                                for (var j = 0; j < m; j++) {
                                    pro = pro[proPat[j]];
                                    if (!pro) break;
                                }
                                pro && this._applyFloat(pro, proPat[m], nodeOwner, additive, weight, isFirstLayer, realtimeDatas[i]);
                                break;
                            case 1:
                                var localPos = pro.localPosition;
                                this._applyPositionAndRotationEuler(nodeOwner, additive, weight, isFirstLayer, realtimeDatas[i], localPos);
                                pro.localPosition = localPos;
                                break;
                            case 2:
                                var localRot = pro.localRotation;
                                this._applyRotation(nodeOwner, additive, weight, isFirstLayer, realtimeDatas[i], localRot);
                                pro.localRotation = localRot;
                                break;
                            case 3:
                                var localSca = pro.localScale;
                                this._applyScale(nodeOwner, additive, weight, isFirstLayer, realtimeDatas[i], localSca);
                                pro.localScale = localSca;
                                break;
                            case 4:
                                var localEuler = pro.localRotationEuler;
                                this._applyPositionAndRotationEuler(nodeOwner, additive, weight, isFirstLayer, realtimeDatas[i], localEuler);
                                pro.localRotationEuler = localEuler;
                                break;
                            }
                            nodeOwner.updateMark = this._updateMark;
                        }
                    }
                }
            }
        },
        {
            key: "_setCrossClipDatasToNode",
            value: function _setCrossClipDatasToNode(controllerLayer, srcState, destState, crossWeight, isFirstLayer) {
                var nodeOwners = controllerLayer._crossNodesOwners;
                var ownerCount = controllerLayer._crossNodesOwnersCount;
                var additive = controllerLayer.blendingMode !== AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
                var weight = controllerLayer.defaultWeight;
                var destRealtimeDatas = destState._realtimeDatas;
                var destDataIndices = controllerLayer._destCrossClipNodeIndices;
                var destNodeOwners = destState._nodeOwners;
                var srcRealtimeDatas = srcState._realtimeDatas;
                var srcDataIndices = controllerLayer._srcCrossClipNodeIndices;
                var srcNodeOwners = srcState._nodeOwners;
                for (var i = 0; i < ownerCount; i++) {
                    var nodeOwner = nodeOwners[i];
                    if (nodeOwner) {
                        var srcIndex = srcDataIndices[i];
                        var destIndex = destDataIndices[i];
                        var srcValue = srcIndex !== -1 ? srcRealtimeDatas[srcIndex] : destNodeOwners[destIndex].defaultValue;
                        var desValue = destIndex !== -1 ? destRealtimeDatas[destIndex] : srcNodeOwners[srcIndex].defaultValue;
                        if (!controllerLayer.avatarMask || controllerLayer.avatarMask.getTransformActive(nodeOwner.nodePath)) {
                            this._applyCrossData(nodeOwner, additive, weight, isFirstLayer, srcValue, desValue, crossWeight);
                        }
                    }
                }
            }
        },
        {
            key: "_setFixedCrossClipDatasToNode",
            value: function _setFixedCrossClipDatasToNode(controllerLayer, destState, crossWeight, isFirstLayer) {
                var nodeOwners = controllerLayer._crossNodesOwners;
                var ownerCount = controllerLayer._crossNodesOwnersCount;
                var additive = controllerLayer.blendingMode !== AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
                var weight = controllerLayer.defaultWeight;
                var destRealtimeDatas = destState._realtimeDatas;
                var destDataIndices = controllerLayer._destCrossClipNodeIndices;
                for (var i = 0; i < ownerCount; i++) {
                    var nodeOwner = nodeOwners[i];
                    if (nodeOwner) {
                        var destIndex = destDataIndices[i];
                        var srcValue = nodeOwner.crossFixedValue;
                        var desValue = destIndex !== -1 ? destRealtimeDatas[destIndex] : nodeOwner.defaultValue;
                        this._applyCrossData(nodeOwner, additive, weight, isFirstLayer, srcValue, desValue, crossWeight);
                    }
                }
            }
        },
        {
            key: "_revertDefaultKeyframeNodes",
            value: function _revertDefaultKeyframeNodes(clipStateInfo) {
                var nodeOwners = clipStateInfo._nodeOwners;
                for (var i = 0,
                n = nodeOwners.length; i < n; i++) {
                    var nodeOwner = nodeOwners[i];
                    if (nodeOwner) {
                        var pro = nodeOwner.propertyOwner;
                        if (pro) {
                            switch (nodeOwner.type) {
                            case 0:
                                var proPat = nodeOwner.property;
                                var m = proPat.length - 1;
                                for (var j = 0; j < m; j++) {
                                    pro = pro[proPat[j]];
                                    if (!pro) break;
                                }
                                pro[proPat[m]] = nodeOwner.defaultValue;
                                break;
                            case 1:
                                var locPos = pro.localPosition;
                                var def = nodeOwner.defaultValue;
                                locPos.x = def.x;
                                locPos.y = def.y;
                                locPos.z = def.z;
                                pro.localPosition = locPos;
                                break;
                            case 2:
                                var locRot = pro.localRotation;
                                var defQua = nodeOwner.defaultValue;
                                locRot.x = defQua.x;
                                locRot.y = defQua.y;
                                locRot.z = defQua.z;
                                locRot.w = defQua.w;
                                pro.localRotation = locRot;
                                break;
                            case 3:
                                var locSca = pro.localScale;
                                def = nodeOwner.defaultValue;
                                locSca.x = def.x;
                                locSca.y = def.y;
                                locSca.z = def.z;
                                pro.localScale = locSca;
                                break;
                            case 4:
                                var locEul = pro.localRotationEuler;
                                def = nodeOwner.defaultValue;
                                locEul.x = def.x;
                                locEul.y = def.y;
                                locEul.z = def.z;
                                pro.localRotationEuler = locEul;
                                break;
                            default:
                                throw "Animator:unknown type.";
                            }
                        }
                    }
                }
            }
        },
        {
            key: "_onAdded",
            value: function _onAdded() {
                var parent = this.owner._parent;
                this.owner._setHierarchyAnimator(this, parent ? parent._hierarchyAnimator: null);
                this.owner._changeAnimatorToLinkSprite3DNoAvatar(this, true, []);
            }
        },
        {
            key: "_onDestroy",
            value: function _onDestroy() {
                for (var i = 0,
                n = this._controllerLayers.length; i < n; i++) {
                    this._controllerLayers[i]._removeReference();
                }
                var parent = this.owner._parent;
                this.owner._clearHierarchyAnimator(this, parent ? parent._hierarchyAnimator: null);
            }
        },
        {
            key: "_onEnable",
            value: function _onEnable() {
                this.owner._scene._animatorPool.add(this);
                for (var i = 0,
                n = this._controllerLayers.length; i < n; i++) {
                    if (this._controllerLayers[i].playOnWake) {
                        var defaultClip = this.getDefaultState(i);
                        defaultClip && this.play(null, i, 0);
                    }
                }
            }
        },
        {
            key: "_applyUpdateMode",
            value: function _applyUpdateMode(delta) {
                var ret;
                switch (this._updateMode) {
                case exports.AnimatorUpdateMode.Normal:
                    ret = delta;
                    break;
                case exports.AnimatorUpdateMode.LowFrame:
                    ret = Laya.Stat.loopCount % this._lowUpdateDelty == 0 ? delta * this._lowUpdateDelty: 0;
                    break;
                case exports.AnimatorUpdateMode.UnScaleTime:
                    ret = 0;
                    break;
                }
                return ret;
            }
        },
        {
            key: "_onDisable",
            value: function _onDisable() {
                this.owner._scene._animatorPool.remove(this);
            }
        },
        {
            key: "_handleSpriteOwnersBySprite",
            value: function _handleSpriteOwnersBySprite(isLink, path, sprite) {
                for (var i = 0,
                n = this._controllerLayers.length; i < n; i++) {
                    var clipStateInfos = this._controllerLayers[i]._states;
                    for (var j = 0,
                    m = clipStateInfos.length; j < m; j++) {
                        var clipStateInfo = clipStateInfos[j];
                        var clip = clipStateInfo._clip;
                        var nodePath = path.join("/");
                        var ownersNodes = clip._nodesMap[nodePath];
                        if (ownersNodes) {
                            var nodeOwners = clipStateInfo._nodeOwners;
                            for (var k = 0,
                            p = ownersNodes.length; k < p; k++) {
                                if (isLink) this._addKeyframeNodeOwner(nodeOwners, ownersNodes[k], sprite);
                                else this._removeKeyframeNodeOwner(nodeOwners, ownersNodes[k]);
                            }
                        }
                    }
                }
            }
        },
        {
            key: "_parse",
            value: function _parse(data) {
                var avatarData = data.avatar;
                if (avatarData) {
                    this.avatar = Laya.Loader.getRes(avatarData.path);
                    var linkSprites = avatarData.linkSprites;
                    this._linkSprites = linkSprites;
                    this._linkToSprites(linkSprites);
                }
                var play = data.playOnWake;
                var layersData = data.layers;
                for (var i = 0; i < layersData.length; i++) {
                    var layerData = layersData[i];
                    var animatorLayer = new AnimatorControllerLayer(layerData.name);
                    if (i === 0) animatorLayer.defaultWeight = 1.0;
                    else animatorLayer.defaultWeight = layerData.weight;
                    var blendingModeData = layerData.blendingMode;
                    blendingModeData && (animatorLayer.blendingMode = blendingModeData);
                    this.addControllerLayer(animatorLayer);
                    var states = layerData.states;
                    for (var j = 0,
                    m = states.length; j < m; j++) {
                        var state = states[j];
                        var clipPath = state.clipPath;
                        if (clipPath) {
                            var name = state.name;
                            var motion;
                            motion = Laya.Loader.getRes(clipPath);
                            if (motion) {
                                var animatorState = new AnimatorState();
                                animatorState.name = name;
                                animatorState.clip = motion;
                                state.speed && (animatorState.speed = state.speed);
                                animatorLayer.addState(animatorState);
                                j === 0 && (this.getControllerLayer(i).defaultState = animatorState);
                            }
                        }
                    }
                    play !== undefined && (animatorLayer.playOnWake = play);
                    var layerMaskData = layerData.avatarMask;
                    if (layerMaskData) {
                        var avaMask = new AvatarMask();
                        animatorLayer.avatarMask = avaMask;
                        for (var bips in layerMaskData) {
                            avaMask.setTransformActive(bips, layerMaskData[bips]);
                        }
                    }
                }
                var cullingModeData = data.cullingMode;
                cullingModeData !== undefined && (this.cullingMode = cullingModeData);
            }
        },
        {
            key: "_update",
            value: function _update() {
                var timer = this.owner._scene.timer;
                var delta = timer._delta / 1000.0;
                delta = this._applyUpdateMode(delta);
                if (this._speed === 0 || delta === 0) return;
                var needRender;
                if (this.cullingMode === Animator.CULLINGMODE_CULLCOMPLETELY) {
                    needRender = false;
                    for (var i = 0,
                    n = this._renderableSprites.length; i < n; i++) {
                        if (this._renderableSprites[i]._render.isRender) {
                            needRender = true;
                            break;
                        }
                    }
                } else {
                    needRender = true;
                }
                this._updateMark++;
                for (i = 0, n = this._controllerLayers.length; i < n; i++) {
                    var controllerLayer = this._controllerLayers[i];
                    var playStateInfo = controllerLayer._playStateInfo;
                    var crossPlayStateInfo = controllerLayer._crossPlayStateInfo;
                    addtive = controllerLayer.blendingMode !== AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
                    switch (controllerLayer._playType) {
                    case 0:
                        var animatorState = playStateInfo._currentState;
                        var clip = animatorState._clip;
                        var speed = this._speed * animatorState.speed;
                        var finish = playStateInfo._finish;
                        finish || this._updatePlayer(animatorState, playStateInfo, delta * speed, clip.islooping);
                        if (needRender) {
                            var addtive = controllerLayer.blendingMode !== AnimatorControllerLayer.BLENDINGMODE_OVERRIDE;
                            this._updateClipDatas(animatorState, addtive, playStateInfo, controllerLayer.avatarMask);
                            this._setClipDatasToNode(animatorState, addtive, controllerLayer.defaultWeight, i === 0, controllerLayer);
                            finish || this._updateEventScript(animatorState, playStateInfo);
                        }
                        finish || this._updateStateFinish(animatorState, playStateInfo);
                        break;
                    case 1:
                        animatorState = playStateInfo._currentState;
                        clip = animatorState._clip;
                        var crossState = controllerLayer._crossPlayState;
                        var crossClip = crossState._clip;
                        var crossDuratuion = controllerLayer._crossDuration;
                        var startPlayTime = crossPlayStateInfo._startPlayTime;
                        var crossClipDuration = crossClip._duration - startPlayTime;
                        var crossScale = crossDuratuion > crossClipDuration ? crossClipDuration / crossDuratuion: 1.0;
                        var crossSpeed = this._speed * crossState.speed;
                        this._updatePlayer(crossState, crossPlayStateInfo, delta * crossScale * crossSpeed, crossClip.islooping);
                        var crossWeight = (crossPlayStateInfo._elapsedTime - startPlayTime) / crossScale / crossDuratuion;
                        var needUpdateFinishcurrentState = false;
                        if (crossWeight >= 1.0) {
                            if (needRender) {
                                this._updateClipDatas(crossState, addtive, crossPlayStateInfo, controllerLayer.avatarMask);
                                this._setClipDatasToNode(crossState, addtive, controllerLayer.defaultWeight, i === 0, controllerLayer);
                                controllerLayer._playType = 0;
                                playStateInfo._currentState = crossState;
                                crossPlayStateInfo._cloneTo(playStateInfo);
                            }
                        } else {
                            if (!playStateInfo._finish) {
                                speed = this._speed * animatorState.speed;
                                needUpdateFinishcurrentState = true;
                                this._updatePlayer(animatorState, playStateInfo, delta * speed, clip.islooping);
                                if (needRender) this._updateClipDatas(animatorState, addtive, playStateInfo, controllerLayer.avatarMask);
                            }
                            if (needRender) {
                                this._updateClipDatas(crossState, addtive, crossPlayStateInfo, controllerLayer.avatarMask);
                                this._setCrossClipDatasToNode(controllerLayer, animatorState, crossState, crossWeight, i === 0);
                            }
                        }
                        if (needRender) {
                            this._updateEventScript(animatorState, playStateInfo);
                            this._updateEventScript(crossState, crossPlayStateInfo);
                        }
                        this._updateStateFinish(crossState, crossPlayStateInfo);
                        needUpdateFinishcurrentState && this._updateStateFinish(playStateInfo._currentState, playStateInfo);
                        break;
                    case 2:
                        crossState = controllerLayer._crossPlayState;
                        crossClip = crossState._clip;
                        crossDuratuion = controllerLayer._crossDuration;
                        startPlayTime = crossPlayStateInfo._startPlayTime;
                        crossClipDuration = crossClip._duration - startPlayTime;
                        crossScale = crossDuratuion > crossClipDuration ? crossClipDuration / crossDuratuion: 1.0;
                        crossSpeed = this._speed * crossState.speed;
                        this._updatePlayer(crossState, crossPlayStateInfo, delta * crossScale * crossSpeed, crossClip.islooping);
                        if (needRender) {
                            crossWeight = (crossPlayStateInfo._elapsedTime - startPlayTime) / crossScale / crossDuratuion;
                            if (crossWeight >= 1.0) {
                                this._updateClipDatas(crossState, addtive, crossPlayStateInfo, controllerLayer.avatarMask);
                                this._setClipDatasToNode(crossState, addtive, 1.0, i === 0, controllerLayer);
                                controllerLayer._playType = 0;
                                playStateInfo._currentState = crossState;
                                crossPlayStateInfo._cloneTo(playStateInfo);
                            } else {
                                this._updateClipDatas(crossState, addtive, crossPlayStateInfo, controllerLayer.avatarMask);
                                this._setFixedCrossClipDatasToNode(controllerLayer, crossState, crossWeight, i === 0);
                            }
                            this._updateEventScript(crossState, crossPlayStateInfo);
                        }
                        this._updateStateFinish(crossState, crossPlayStateInfo);
                        break;
                    }
                }
                if (needRender) {
                    if (this._avatar) {
                        this._updateAvatarNodesToSprite();
                    }
                }
            }
        },
        {
            key: "_cloneTo",
            value: function _cloneTo(dest) {
                var animator = dest;
                animator.avatar = this.avatar;
                animator.cullingMode = this.cullingMode;
                for (var i = 0,
                n = this._controllerLayers.length; i < n; i++) {
                    var controllLayer = this._controllerLayers[i];
                    animator.addControllerLayer(controllLayer.clone());
                    var animatorStates = controllLayer._states;
                    for (var j = 0,
                    m = animatorStates.length; j < m; j++) {
                        var state = animatorStates[j].clone();
                        var cloneLayer = animator.getControllerLayer(i);
                        cloneLayer.addState(state);
                        j == 0 && (cloneLayer.defaultState = state);
                    }
                }
                animator._linkSprites = this._linkSprites;
                animator._linkToSprites(this._linkSprites);
            }
        },
        {
            key: "getDefaultState",
            value: function getDefaultState() {
                var layerIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                var controllerLayer = this._controllerLayers[layerIndex];
                return controllerLayer.defaultState;
            }
        },
        {
            key: "addState",
            value: function addState(state) {
                var layerIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var controllerLayer = this._controllerLayers[layerIndex];
                controllerLayer.addState(state);
                console.warn("Animator:this function is discard,please use animatorControllerLayer.addState() instead.");
            }
        },
        {
            key: "removeState",
            value: function removeState(state) {
                var layerIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var controllerLayer = this._controllerLayers[layerIndex];
                controllerLayer.removeState(state);
                console.warn("Animator:this function is discard,please use animatorControllerLayer.removeState() instead.");
            }
        },
        {
            key: "addControllerLayer",
            value: function addControllerLayer(controllderLayer) {
                this._controllerLayers.push(controllderLayer);
                controllderLayer._animator = this;
                controllderLayer._addReference();
                var states = controllderLayer._states;
                for (var i = 0,
                n = states.length; i < n; i++) {
                    this._getOwnersByClip(states[i]);
                }
            }
        },
        {
            key: "getControllerLayer",
            value: function getControllerLayer() {
                var layerInex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                return this._controllerLayers[layerInex];
            }
        },
        {
            key: "play",
            value: function play() {
                var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                var layerIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var normalizedTime = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Number.NEGATIVE_INFINITY;
                var controllerLayer = this._controllerLayers[layerIndex];
                if (controllerLayer) {
                    var defaultState = controllerLayer.defaultState;
                    if (!name && !defaultState) throw new Error("Animator:must have default clip value,please set clip property.");
                    var playStateInfo = controllerLayer._playStateInfo;
                    var curPlayState = playStateInfo._currentState;
                    var animatorState = name ? controllerLayer._statesMap[name] : defaultState;
                    var clipDuration = animatorState._clip._duration;
                    var calclipduration = animatorState._clip._duration * (animatorState.clipEnd - animatorState.clipStart);
                    if (curPlayState !== animatorState) {
                        if (normalizedTime !== Number.NEGATIVE_INFINITY) playStateInfo._resetPlayState(clipDuration * normalizedTime, calclipduration);
                        else playStateInfo._resetPlayState(0.0, calclipduration);
                        curPlayState !== null && curPlayState !== animatorState && this._revertDefaultKeyframeNodes(curPlayState);
                        controllerLayer._playType = 0;
                        playStateInfo._currentState = animatorState;
                    } else {
                        if (normalizedTime !== Number.NEGATIVE_INFINITY) {
                            playStateInfo._resetPlayState(clipDuration * normalizedTime, calclipduration);
                            controllerLayer._playType = 0;
                        }
                    }
                    var scripts = animatorState._scripts;
                    if (scripts) {
                        for (var i = 0,
                        n = scripts.length; i < n; i++) {
                            scripts[i].onStateEnter();
                        }
                    }
                } else {
                    console.warn("Invalid layerIndex " + layerIndex + ".");
                }
                if (this.owner._scene) {
                    this._update();
                }
            }
        },
        {
            key: "crossFade",
            value: function crossFade(name, transitionDuration) {
                var layerIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var normalizedTime = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Number.NEGATIVE_INFINITY;
                var controllerLayer = this._controllerLayers[layerIndex];
                if (controllerLayer) {
                    var destAnimatorState = controllerLayer._statesMap[name];
                    if (destAnimatorState) {
                        var playType = controllerLayer._playType;
                        if (playType === -1) {
                            this.play(name, layerIndex, normalizedTime);
                            return;
                        }
                        var crossPlayStateInfo = controllerLayer._crossPlayStateInfo;
                        var crossNodeOwners = controllerLayer._crossNodesOwners;
                        var crossNodeOwnerIndicesMap = controllerLayer._crossNodesOwnersIndicesMap;
                        var srcAnimatorState = controllerLayer._playStateInfo._currentState;
                        var destNodeOwners = destAnimatorState._nodeOwners;
                        var destCrossClipNodeIndices = controllerLayer._destCrossClipNodeIndices;
                        var destClip = destAnimatorState._clip;
                        var destNodes = destClip._nodes;
                        var destNodesMap = destClip._nodesDic;
                        var crossCount = 0;
                        switch (playType) {
                        case 0:
                            var srcNodeOwners = srcAnimatorState._nodeOwners;
                            var scrCrossClipNodeIndices = controllerLayer._srcCrossClipNodeIndices;
                            var srcClip = srcAnimatorState._clip;
                            var srcNodes = srcClip._nodes;
                            var srcNodesMap = srcClip._nodesDic;
                            controllerLayer._playType = 1;
                            var crossMark = ++controllerLayer._crossMark;
                            crossCount = controllerLayer._crossNodesOwnersCount = 0;
                            for (var i = 0,
                            n = srcNodes.count; i < n; i++) {
                                var srcNode = srcNodes.getNodeByIndex(i);
                                var srcIndex = srcNode._indexInList;
                                var srcNodeOwner = srcNodeOwners[srcIndex];
                                if (srcNodeOwner) {
                                    var srcFullPath = srcNode.fullPath;
                                    scrCrossClipNodeIndices[crossCount] = srcIndex;
                                    var destNode = destNodesMap[srcFullPath];
                                    if (destNode) destCrossClipNodeIndices[crossCount] = destNode._indexInList;
                                    else destCrossClipNodeIndices[crossCount] = -1;
                                    crossNodeOwnerIndicesMap[srcFullPath] = crossMark;
                                    crossNodeOwners[crossCount] = srcNodeOwner;
                                    crossCount++;
                                }
                            }
                            for (i = 0, n = destNodes.count; i < n; i++) {
                                destNode = destNodes.getNodeByIndex(i);
                                var destIndex = destNode._indexInList;
                                var destNodeOwner = destNodeOwners[destIndex];
                                if (destNodeOwner) {
                                    var destFullPath = destNode.fullPath;
                                    if (!srcNodesMap[destFullPath]) {
                                        scrCrossClipNodeIndices[crossCount] = -1;
                                        destCrossClipNodeIndices[crossCount] = destIndex;
                                        crossNodeOwnerIndicesMap[destFullPath] = crossMark;
                                        crossNodeOwners[crossCount] = destNodeOwner;
                                        crossCount++;
                                    }
                                }
                            }
                            break;
                        case 1:
                        case 2:
                            controllerLayer._playType = 2;
                            for (i = 0, n = crossNodeOwners.length; i < n; i++) {
                                var nodeOwner = crossNodeOwners[i];
                                nodeOwner.saveCrossFixedValue();
                                destNode = destNodesMap[nodeOwner.fullPath];
                                if (destNode) destCrossClipNodeIndices[i] = destNode._indexInList;
                                else destCrossClipNodeIndices[i] = -1;
                            }
                            crossCount = controllerLayer._crossNodesOwnersCount;
                            crossMark = controllerLayer._crossMark;
                            for (i = 0, n = destNodes.count; i < n; i++) {
                                destNode = destNodes.getNodeByIndex(i);
                                destIndex = destNode._indexInList;
                                destNodeOwner = destNodeOwners[destIndex];
                                if (destNodeOwner) {
                                    destFullPath = destNode.fullPath;
                                    if (crossNodeOwnerIndicesMap[destFullPath] !== crossMark) {
                                        destCrossClipNodeIndices[crossCount] = destIndex;
                                        crossNodeOwnerIndicesMap[destFullPath] = crossMark;
                                        nodeOwner = destNodeOwners[destIndex];
                                        crossNodeOwners[crossCount] = nodeOwner;
                                        nodeOwner.saveCrossFixedValue();
                                        crossCount++;
                                    }
                                }
                            }
                            break;
                        }
                        controllerLayer._crossNodesOwnersCount = crossCount;
                        controllerLayer._crossPlayState = destAnimatorState;
                        controllerLayer._crossDuration = srcAnimatorState._clip._duration * transitionDuration;
                        if (normalizedTime !== Number.NEGATIVE_INFINITY) crossPlayStateInfo._resetPlayState(destClip._duration * normalizedTime, controllerLayer._crossDuration);
                        else crossPlayStateInfo._resetPlayState(0.0, controllerLayer._crossDuration);
                        var scripts = destAnimatorState._scripts;
                        if (scripts) {
                            for (i = 0, n = scripts.length; i < n; i++) {
                                scripts[i].onStateEnter();
                            }
                        }
                    } else {
                        console.warn("Invalid name " + layerIndex + ".");
                    }
                } else {
                    console.warn("Invalid layerIndex " + layerIndex + ".");
                }
            }
        },
        {
            key: "getCurrentAnimatorPlayState",
            value: function getCurrentAnimatorPlayState() {
                var layerInex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                return this._controllerLayers[layerInex]._playStateInfo;
            }
        },
        {
            key: "avatar",
            get: function get() {
                return this._avatar;
            },
            set: function set(value) {
                if (this._avatar !== value) {
                    this._avatar = value;
                    if (value) {
                        this._getAvatarOwnersAndInitDatasAsync();
                        this.owner._changeHierarchyAnimatorAvatar(this, value);
                    } else {
                        var parent = this.owner._parent;
                        this.owner._changeHierarchyAnimatorAvatar(this, parent ? parent._hierarchyAnimator._avatar: null);
                    }
                }
            }
        },
        {
            key: "_isLinkSpriteToAnimationNodeData",
            value: function _isLinkSpriteToAnimationNodeData(sprite, nodeName, isLink) {
                var linkSprites = this._linkAvatarSpritesData[nodeName];
                if (isLink) {
                    linkSprites || (this._linkAvatarSpritesData[nodeName] = linkSprites = []);
                    linkSprites.push(sprite);
                } else {
                    var index = linkSprites.indexOf(sprite);
                    linkSprites.splice(index, 1);
                }
            }
        },
        {
            key: "_getAvatarOwnersAndInitDatasAsync",
            value: function _getAvatarOwnersAndInitDatasAsync() {
                for (var i = 0,
                n = this._controllerLayers.length; i < n; i++) {
                    var clipStateInfos = this._controllerLayers[i]._states;
                    for (var j = 0,
                    m = clipStateInfos.length; j < m; j++) {
                        this._getOwnersByClip(clipStateInfos[j]);
                    }
                }
                this._avatar._cloneDatasToAnimator(this);
                for (var k in this._linkAvatarSpritesData) {
                    var sprites = this._linkAvatarSpritesData[k];
                    if (sprites) {
                        for (var c = 0,
                        p = sprites.length; c < p; c++) {
                            this._isLinkSpriteToAnimationNode(sprites[c], k, true);
                        }
                    }
                }
            }
        },
        {
            key: "_isLinkSpriteToAnimationNode",
            value: function _isLinkSpriteToAnimationNode(sprite, nodeName, isLink) {
                if (this._avatar) {
                    var node = this._avatarNodeMap[nodeName];
                    if (node) {
                        if (isLink) {
                            sprite._transform._dummy = node.transform;
                            this._linkAvatarSprites.push(sprite);
                            var nodeTransform = node.transform;
                            var spriteTransform = sprite.transform;
                            if (!spriteTransform.owner.isStatic && nodeTransform) {
                                var spriteWorldMatrix = spriteTransform.worldMatrix;
                                var ownParTra = this.owner._transform._parent;
                                if (ownParTra) {
                                    Utils3D.matrix4x4MultiplyMFM(ownParTra.worldMatrix, nodeTransform.getWorldMatrix(), spriteWorldMatrix);
                                } else {
                                    var sprWorE = spriteWorldMatrix.elements;
                                    var nodWorE = nodeTransform.getWorldMatrix();
                                    for (var i = 0; i < 16; i++) {
                                        sprWorE[i] = nodWorE[i];
                                    }
                                }
                                spriteTransform.worldMatrix = spriteWorldMatrix;
                            }
                        } else {
                            sprite._transform._dummy = null;
                            this._linkAvatarSprites.splice(this._linkAvatarSprites.indexOf(sprite), 1);
                        }
                    }
                }
            }
        },
        {
            key: "_updateAvatarNodesToSprite",
            value: function _updateAvatarNodesToSprite() {
                for (var i = 0,
                n = this._linkAvatarSprites.length; i < n; i++) {
                    var sprite = this._linkAvatarSprites[i];
                    var nodeTransform = sprite.transform._dummy;
                    var spriteTransform = sprite.transform;
                    if (!spriteTransform.owner.isStatic && nodeTransform) {
                        var spriteWorldMatrix = spriteTransform.worldMatrix;
                        var ownTra = this.owner._transform;
                        Utils3D.matrix4x4MultiplyMFM(ownTra.worldMatrix, nodeTransform.getWorldMatrix(), spriteWorldMatrix);
                        spriteTransform.worldMatrix = spriteWorldMatrix;
                    }
                }
            }
        },
        {
            key: "linkSprite3DToAvatarNode",
            value: function linkSprite3DToAvatarNode(nodeName, sprite3D) {
                this._isLinkSpriteToAnimationNodeData(sprite3D, nodeName, true);
                this._isLinkSpriteToAnimationNode(sprite3D, nodeName, true);
                return true;
            }
        },
        {
            key: "unLinkSprite3DToAvatarNode",
            value: function unLinkSprite3DToAvatarNode(sprite3D) {
                var dummy = sprite3D.transform._dummy;
                if (dummy) {
                    var nodeName = dummy._owner.name;
                    this._isLinkSpriteToAnimationNodeData(sprite3D, nodeName, false);
                    this._isLinkSpriteToAnimationNode(sprite3D, nodeName, false);
                    return true;
                } else {
                    return false;
                }
            }
        },
        {
            key: "_updateAnimationNodeWorldMatix",
            value: function _updateAnimationNodeWorldMatix(localPositions, localRotations, localScales, worldMatrixs, parentIndices) {
                Laya.LayaGL.instance.updateAnimationNodeWorldMatix(localPositions, localRotations, localScales, parentIndices, worldMatrixs);
            }
        }], [{
            key: "_update",
            value: function _update(scene) {
                var pool = scene._animatorPool;
                var elements = pool.elements;
                for (var i = 0,
                n = pool.length; i < n; i++) {
                    var animator = elements[i];
                    animator && animator.enabled && animator._update();
                }
            }
        }]);
        return Animator;
    } (Laya.Component);
    Animator._tempVector31 = new Vector3();
    Animator._tempQuaternion1 = new Quaternion();
    Animator.CULLINGMODE_ALWAYSANIMATE = 0;
    Animator.CULLINGMODE_CULLCOMPLETELY = 2;
    var RenderContext3D =
    /*#__PURE__*/
    _createClass(function RenderContext3D() {
        _classCallCheck(this, RenderContext3D);
        this.invertY = false;
        this.configPipeLineMode = "Forward";
    });
    RenderContext3D._instance = new RenderContext3D();
    var RenderTexture =
    /*#__PURE__*/
    function(_Laya$BaseTexture) {
        _inherits(RenderTexture, _Laya$BaseTexture);
        var _super6 = _createSuper(RenderTexture);
        function RenderTexture(width, height) {
            var _this6;
            var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Laya.RenderTextureFormat.R8G8B8;
            var depthStencilFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Laya.RenderTextureDepthFormat.DEPTH_16;
            var mipmap = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
            _classCallCheck(this, RenderTexture);
            _this6 = _super6.call(this, format, false);
            _this6._inPool = false;
            _this6._mulSampler = 1;
            _this6._mulSamplerRT = false;
            _this6._depthAttachMode = Laya.RTDEPTHATTACHMODE.RENDERBUFFER;
            _this6._isCameraTarget = false;
            _this6._glTextureType = Laya.LayaGL.instance.TEXTURE_2D;
            _this6._width = width;
            _this6._height = height;
            _this6._depthStencilFormat = depthStencilFormat;
            _this6._mipmapCount = 1;
            if (mipmap && _this6._isPot(width) && _this6._isPot(height)) {
                _this6._mipmap = mipmap;
                var mipmapCount = Math.max(Math.ceil(Math.log2(width)) + 1, Math.ceil(Math.log2(height)) + 1);
                _this6._mipmapCount = mipmapCount;
            }
            _this6._create(width, height);
            return _this6;
        }
        _createClass(RenderTexture, [{
            key: "depthStencilFormat",
            get: function get() {
                return this._depthStencilFormat;
            }
        },
        {
            key: "defaulteTexture",
            get: function get() {
                return Laya.Texture2D.grayTexture;
            }
        },
        {
            key: "mulSampler",
            get: function get() {
                return this._mulSampler;
            }
        },
        {
            key: "depthStencilTexture",
            get: function get() {
                return this._depthStencilTexture;
            }
        },
        {
            key: "depthAttachMode",
            get: function get() {
                return this._depthAttachMode;
            },
            set: function set(value) {
                if (this._depthAttachMode != value) {
                    this._depthAttachMode = value;
                    switch (value) {
                    case Laya.RTDEPTHATTACHMODE.RENDERBUFFER:
                        this._createGLDepthRenderbuffer(this.width, this.height);
                        if (this._depthStencilTexture) {
                            var gl = Laya.LayaGL.instance;
                            gl.deleteTexture(this._glTexture);
                            this._depthStencilTexture = null;
                        }
                        break;
                    case Laya.RTDEPTHATTACHMODE.TEXTURE:
                        this._createGLDepthTexture(this.width, this.height);
                        if (this._depthStencilBuffer) {
                            var gl = Laya.LayaGL.instance;
                            gl.deleteRenderbuffer(this._depthStencilBuffer);
                            this._depthStencilBuffer = null;
                        }
                        break;
                    }
                }
            }
        },
        {
            key: "_create",
            value: function _create(width, height) {
                var gl = Laya.LayaGL.instance;
                var layaGPU = Laya.LayaGL.layaGPUInstance;
                var isWebGL2 = layaGPU._isWebGL2;
                var format = this._format;
                this._frameBuffer = gl.createFramebuffer();
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                this._creatGlTexture(width, height);
                if (format !== Laya.RenderTextureFormat.Depth && format !== Laya.RenderTextureFormat.ShadowMap) {
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, this._glTexture, 0);
                    this._createGLDepthRenderbuffer(width, height);
                }
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                this._setFilterMode(this._filterMode);
                this._setAnisotropy(this._anisoLevel);
                this._readyed = true;
                this._activeResource();
                var gpuMemory = width * height * 4;
                if (this._mipmap) {
                    gpuMemory *= 4 / 3;
                }
                this._setGPUMemory(gpuMemory);
            }
        },
        {
            key: "_creatGlTexture",
            value: function _creatGlTexture(width, height) {
                var glTextureType = this._glTextureType;
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                var layaGPU = Laya.LayaGL.layaGPUInstance;
                var isWebGL2 = layaGPU._isWebGL2;
                var format = this._format;
                Laya.WebGLContext.bindTexture(gl, glTextureType, this._glTexture);
                if (format !== Laya.RenderTextureFormat.Depth && format !== Laya.RenderTextureFormat.ShadowMap) {
                    switch (format) {
                    case Laya.RenderTextureFormat.R8G8B8:
                        if (isWebGL2) gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.RGB8, width, height);
                        else gl.texImage2D(glTextureType, 0, gl.RGB, width, height, 0, gl.RGB, gl.UNSIGNED_BYTE, null);
                        break;
                    case Laya.RenderTextureFormat.R8G8B8A8:
                        if (isWebGL2) gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.RGBA8, width, height);
                        else gl.texImage2D(glTextureType, 0, gl.RGBA, width, height, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
                        break;
                    case Laya.RenderTextureFormat.Alpha8:
                        if (isWebGL2) gl2.texStorage2D(glTextureType, this.mipmapCount, gl2.R8, width, height);
                        else gl.texImage2D(glTextureType, 0, gl.ALPHA, width, height, 0, gl.ALPHA, gl.UNSIGNED_BYTE, null);
                        break;
                    case Laya.RenderTextureFormat.R16G16B16A16:
                        if (isWebGL2) gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.RGBA16F, width, height);
                        else gl.texImage2D(glTextureType, 0, gl.RGBA, width, height, 0, gl.RGBA, layaGPU._oesTextureHalfFloat.HALF_FLOAT_OES, null);
                        break;
                    }
                } else if (format == Laya.RenderTextureFormat.Depth || format == Laya.RenderTextureFormat.ShadowMap) {
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    this.filterMode = Laya.FilterMode.Point;
                    Laya.WebGLContext.bindTexture(gl, glTextureType, this._glTexture);
                    switch (this._depthStencilFormat) {
                    case Laya.RenderTextureDepthFormat.DEPTH_16:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT16, width, height);
                        } else gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_SHORT, null);
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._glTexture, 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTH_32:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT32F, width, height);
                        } else gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._glTexture, 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                        if (isWebGL2) gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH24_STENCIL8, width, height);
                        else gl.texImage2D(glTextureType, 0, gl.DEPTH_STENCIL, width, height, 0, gl.DEPTH_STENCIL, layaGPU._webgl_depth_texture.UNSIGNED_INT_24_8_WEBGL, null);
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_2D, this._glTexture, 0);
                        break;
                    default:
                        throw "RenderTexture: depth format RenderTexture must use depthFormat with DEPTH_16 and DEPTHSTENCIL_16_8.";
                    }
                    if (isWebGL2 && format == Laya.RenderTextureFormat.ShadowMap) {
                        gl2.texParameteri(glTextureType, gl2.TEXTURE_COMPARE_MODE, gl2.COMPARE_REF_TO_TEXTURE);
                        gl2.texParameteri(glTextureType, gl2.TEXTURE_COMPARE_FUNC, gl2.LESS);
                    }
                }
                Laya.WebGLContext.bindTexture(gl, glTextureType, null);
            }
        },
        {
            key: "_createGLDepthTexture",
            value: function _createGLDepthTexture(width, height) {
                var glTextureType = this._glTextureType;
                var layaGPU = Laya.LayaGL.layaGPUInstance;
                var isWebGL2 = layaGPU._isWebGL2;
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                if (this._depthStencilFormat !== Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE) {
                    this._depthStencilTexture = new Laya.BaseTexture(Laya.RenderTextureFormat.Depth, false);
                    this._depthStencilTexture.lock = true;
                    this._depthStencilTexture.width = width;
                    this._depthStencilTexture.height = height;
                    this._depthStencilTexture.mipmapCount = 1;
                    this._depthStencilTexture._glTextureType = Laya.LayaGL.instance.TEXTURE_2D;
                    this._depthStencilTexture._readyed = true;
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    this._depthStencilTexture.filterMode = Laya.FilterMode.Point;
                    this._depthStencilTexture.wrapModeU = Laya.WarpMode.Clamp;
                    this._depthStencilTexture.wrapModeV = Laya.WarpMode.Clamp;
                    Laya.WebGLContext.bindTexture(gl, this._depthStencilTexture._glTextureType, this._depthStencilTexture._getSource());
                    switch (this._depthStencilFormat) {
                    case Laya.RenderTextureDepthFormat.DEPTH_16:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT16, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_SHORT, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH24_STENCIL8, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_STENCIL, width, height, 0, gl.DEPTH_STENCIL, layaGPU._webgl_depth_texture.UNSIGNED_INT_24_8_WEBGL, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTH_32:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT32F, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    }
                }
            }
        },
        {
            key: "_createGLDepthRenderbuffer",
            value: function _createGLDepthRenderbuffer(width, height) {
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                if (this._depthStencilFormat !== Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE) {
                    this._depthStencilBuffer = gl.createRenderbuffer();
                    gl.bindRenderbuffer(gl.RENDERBUFFER, this._depthStencilBuffer);
                    switch (this._depthStencilFormat) {
                    case Laya.RenderTextureDepthFormat.DEPTH_16:
                        gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, width, height);
                        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl2.DEPTH_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    case Laya.RenderTextureDepthFormat.STENCIL_8:
                        gl.renderbufferStorage(gl.RENDERBUFFER, gl.STENCIL_INDEX8, width, height);
                        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                        gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, width, height);
                        gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    default:
                        throw "RenderTexture: unkonw depth format.";
                    }
                    gl.bindRenderbuffer(gl.RENDERBUFFER, null);
                }
            }
        },
        {
            key: "_start",
            value: function _start() {
                var gl = Laya.LayaGL.instance;
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                RenderTexture._currentActive = this;
                this._isCameraTarget && (RenderContext3D._instance.invertY = true);
                this._readyed = false;
            }
        },
        {
            key: "_end",
            value: function _end() {
                var gl = Laya.LayaGL.instance;
                if (this.mipmap) {
                    Laya.WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    gl.generateMipmap(this._glTextureType);
                    Laya.WebGLContext.bindTexture(gl, this._glTextureType, null);
                }
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                RenderTexture._currentActive = null;
                this._isCameraTarget && (RenderContext3D._instance.invertY = false);
                this._readyed = true;
            }
        },
        {
            key: "getData",
            value: function getData(x, y, width, height, out) {
                if (Laya.Render.isConchApp && window.conchConfig.threadMode == 2) {
                    throw "native 2 thread mode use getDataAsync";
                }
                var gl = Laya.LayaGL.instance;
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                var canRead = gl.checkFramebufferStatus(gl.FRAMEBUFFER) === gl.FRAMEBUFFER_COMPLETE;
                if (!canRead) {
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                    return null;
                }
                switch (this.format) {
                case Laya.RenderTextureFormat.R8G8B8:
                    gl.readPixels(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, out);
                    break;
                case Laya.RenderTextureFormat.R8G8B8A8:
                    gl.readPixels(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, out);
                    break;
                case Laya.RenderTextureFormat.R16G16B16A16:
                    gl.readPixels(x, y, width, height, gl.RGBA, gl.FLOAT, out);
                    break;
                }
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                return out;
            }
        },
        {
            key: "_disposeResource",
            value: function _disposeResource() {
                if (this._frameBuffer) {
                    var gl = Laya.LayaGL.instance;
                    this._glTexture && gl.deleteTexture(this._glTexture);
                    this._frameBuffer && gl.deleteFramebuffer(this._frameBuffer);
                    this._depthStencilBuffer && gl.deleteRenderbuffer(this._depthStencilBuffer);
                    this._depthStencilTexture && this._depthStencilTexture.destroy();
                    this._glTexture = null;
                    this._frameBuffer = null;
                    this._depthStencilBuffer = null;
                    this._depthStencilTexture = null;
                    this._setGPUMemory(0);
                }
            }
        },
        {
            key: "getDataAsync",
            value: function getDataAsync(x, y, width, height, callBack) {
                var gl = Laya.LayaGL.instance;
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                gl.readPixelsAsync(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE,
                function(data) {
                    callBack(new Uint8Array(data));
                });
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
            }
        }], [{
            key: "currentActive",
            get: function get() {
                return RenderTexture._currentActive;
            }
        },
        {
            key: "createFromPool",
            value: function createFromPool(width, height) {
                var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Laya.RenderTextureFormat.R8G8B8;
                var depthStencilFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Laya.RenderTextureDepthFormat.DEPTH_16;
                var mulSamples = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
                var mipmap = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                var tex;
                mipmap = mipmap && (width & width - 1) === 0 && (height & height - 1) === 0;
                for (var i = 0,
                n = RenderTexture._pool.length; i < n; i++) {
                    tex = RenderTexture._pool[i];
                    if (tex._width == width && tex._height == height && tex._format == format && tex._depthStencilFormat == depthStencilFormat && tex._mulSampler == mulSamples && tex._mipmap == mipmap) {
                        tex._inPool = false;
                        var end = RenderTexture._pool[n - 1];
                        RenderTexture._pool[i] = end;
                        RenderTexture._pool.length -= 1;
                        return tex;
                    }
                }
                tex = new RenderTexture(width, height, format, depthStencilFormat);
                tex.lock = true;
                return tex;
            }
        },
        {
            key: "recoverToPool",
            value: function recoverToPool(renderTexture) {
                if (renderTexture._inPool || renderTexture.destroyed) return;
                RenderTexture._pool.push(renderTexture);
                renderTexture._inPool = true;
            }
        },
        {
            key: "bindCanvasRender",
            get: function get() {
                return RenderTexture._bindCanvasRender;
            },
            set: function set(value) {
                if (value != this._bindCanvasRender) this._bindCanvasRender && RenderTexture.recoverToPool(this._bindCanvasRender);
                this._bindCanvasRender = value;
            }
        }]);
        return RenderTexture;
    } (Laya.BaseTexture);
    RenderTexture._pool = [];
    var DefineDatas =
    /*#__PURE__*/
    function() {
        function DefineDatas() {
            _classCallCheck(this, DefineDatas);
            this._mask = [];
            this._length = 0;
        }
        _createClass(DefineDatas, [{
            key: "_intersectionDefineDatas",
            value: function _intersectionDefineDatas(define) {
                var unionMask = define._mask;
                var mask = this._mask;
                for (var i = this._length - 1; i >= 0; i--) {
                    var value = mask[i] & unionMask[i];
                    if (value == 0 && i == this._length - 1) this._length--;
                    else mask[i] = value;
                }
            }
        },
        {
            key: "add",
            value: function add(define) {
                var index = define._index;
                var size = index + 1;
                var mask = this._mask;
                var maskStart = this._length;
                if (maskStart < size) {
                    mask.length < size && (mask.length = size);
                    for (; maskStart < index; maskStart++) {
                        mask[maskStart] = 0;
                    }
                    mask[index] = define._value;
                    this._length = size;
                } else {
                    mask[index] |= define._value;
                }
            }
        },
        {
            key: "remove",
            value: function remove(define) {
                var index = define._index;
                var mask = this._mask;
                var endIndex = this._length - 1;
                if (index > endIndex) return;
                var newValue = mask[index] & ~define._value;
                if (index == endIndex && newValue === 0) this._length--;
                else mask[index] = newValue;
            }
        },
        {
            key: "addDefineDatas",
            value: function addDefineDatas(define) {
                var addMask = define._mask;
                var size = define._length;
                var mask = this._mask;
                var maskStart = this._length;
                if (maskStart < size) {
                    mask.length = size;
                    for (var i = 0; i < maskStart; i++) {
                        mask[i] |= addMask[i];
                    }
                    for (; i < size; i++) {
                        mask[i] = addMask[i];
                    }
                    this._length = size;
                } else {
                    for (var i = 0; i < size; i++) {
                        mask[i] |= addMask[i];
                    }
                }
            }
        },
        {
            key: "removeDefineDatas",
            value: function removeDefineDatas(define) {
                var removeMask = define._mask;
                var mask = this._mask;
                var endIndex = this._length - 1;
                var i = Math.min(define._length, endIndex);
                for (; i >= 0; i--) {
                    var newValue = mask[i] & ~removeMask[i];
                    if (i == endIndex && newValue === 0) {
                        endIndex--;
                        this._length--;
                    } else {
                        mask[i] = newValue;
                    }
                }
            }
        },
        {
            key: "has",
            value: function has(define) {
                var index = define._index;
                if (index >= this._length) return false;
                return (this._mask[index] & define._value) !== 0;
            }
        },
        {
            key: "clear",
            value: function clear() {
                this._length = 0;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destDefineData = destObject;
                var destMask = destDefineData._mask;
                var mask = this._mask;
                var count = this._length;
                destMask.length = count;
                for (var i = 0; i < count; i++) {
                    destMask[i] = mask[i];
                }
                destDefineData._length = count;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new DefineDatas();
                this.cloneTo(dest);
                return dest;
            }
        }]);
        return DefineDatas;
    } ();
    var VertexBuffer3D =
    /*#__PURE__*/
    function(_Laya$Buffer) {
        _inherits(VertexBuffer3D, _Laya$Buffer);
        var _super7 = _createSuper(VertexBuffer3D);
        function VertexBuffer3D(byteLength, bufferUsage) {
            var _this7;
            var canRead = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
            _classCallCheck(this, VertexBuffer3D);
            _this7 = _super7.call(this);
            _this7._vertexDeclaration = null;
            _this7._float32Reader = null;
            var gl = Laya.LayaGL.instance;
            _this7._bufferUsage = bufferUsage;
            _this7._bufferType = gl.ARRAY_BUFFER;
            _this7._canRead = canRead;
            _this7._byteLength = byteLength;
            _this7.bind();
            gl.bufferData(_this7._bufferType, _this7._byteLength, _this7._bufferUsage);
            if (canRead) {
                _this7._buffer = new Uint8Array(byteLength);
                _this7._float32Reader = new Float32Array(_this7._buffer.buffer);
            }
            return _this7;
        }
        _createClass(VertexBuffer3D, [{
            key: "vertexDeclaration",
            get: function get() {
                return this._vertexDeclaration;
            },
            set: function set(value) {
                this._vertexDeclaration = value;
            }
        },
        {
            key: "canRead",
            get: function get() {
                return this._canRead;
            }
        },
        {
            key: "bind",
            value: function bind() {
                if (Laya.Buffer._bindedVertexBuffer !== this._glBuffer) {
                    var gl = Laya.LayaGL.instance;
                    gl.bindBuffer(gl.ARRAY_BUFFER, this._glBuffer);
                    Laya.Buffer._bindedVertexBuffer = this._glBuffer;
                    return true;
                } else {
                    return false;
                }
            }
        },
        {
            key: "orphanStorage",
            value: function orphanStorage() {
                this.bind();
                Laya.LayaGL.instance.bufferData(this._bufferType, this._byteLength, this._bufferUsage);
            }
        },
        {
            key: "setData",
            value: function setData(buffer) {
                var bufferOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var dataStartIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var dataCount = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Number.MAX_SAFE_INTEGER;
                this.bind();
                var needSubData = dataStartIndex !== 0 || dataCount !== Number.MAX_SAFE_INTEGER;
                if (needSubData) {
                    var subData = new Uint8Array(buffer, dataStartIndex, dataCount);
                    Laya.LayaGL.instance.bufferSubData(this._bufferType, bufferOffset, subData);
                    if (this._canRead) this._buffer.set(subData, bufferOffset);
                } else {
                    Laya.LayaGL.instance.bufferSubData(this._bufferType, bufferOffset, buffer);
                    if (this._canRead) this._buffer.set(new Uint8Array(buffer), bufferOffset);
                }
            }
        },
        {
            key: "getUint8Data",
            value: function getUint8Data() {
                if (this._canRead) return this._buffer;
                else throw new Error("Can't read data from VertexBuffer with only write flag!");
            }
        },
        {
            key: "getFloat32Data",
            value: function getFloat32Data() {
                if (this._canRead) return this._float32Reader;
                else throw new Error("Can't read data from VertexBuffer with only write flag!");
            }
        },
        {
            key: "markAsUnreadbale",
            value: function markAsUnreadbale() {
                this._canRead = false;
                this._buffer = null;
                this._float32Reader = null;
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                _get(_getPrototypeOf(VertexBuffer3D.prototype), "destroy", this).call(this);
                this._buffer = null;
                this._float32Reader = null;
                this._vertexDeclaration = null;
                this._byteLength = 0;
            }
        }]);
        return VertexBuffer3D;
    } (Laya.Buffer);
    VertexBuffer3D.DATATYPE_FLOAT32ARRAY = 0;
    VertexBuffer3D.DATATYPE_UINT8ARRAY = 1;
    var VertexElementFormat =
    /*#__PURE__*/
    function() {
        function VertexElementFormat() {
            _classCallCheck(this, VertexElementFormat);
        }
        _createClass(VertexElementFormat, null, [{
            key: "__init__",
            value: function __init__() {
                var gl = Laya.LayaGL.instance;
                VertexElementFormat._elementInfos = {
                    "single": [1, gl.FLOAT, 0],
                    "vector2": [2, gl.FLOAT, 0],
                    "vector3": [3, gl.FLOAT, 0],
                    "vector4": [4, gl.FLOAT, 0],
                    "color": [4, gl.FLOAT, 0],
                    "byte4": [4, gl.UNSIGNED_BYTE, 0],
                    "byte3": [3, gl.UNSIGNED_BYTE, 0],
                    "byte2": [2, gl.UNSIGNED_BYTE, 0],
                    "byte": [1, gl.UNSIGNED_BYTE, 0],
                    "short2": [2, gl.UNSIGNED_SHORT, 0],
                    "short4": [4, gl.UNSIGNED_SHORT, 0],
                    "normalizedshort2": [2, gl.UNSIGNED_SHORT, 1],
                    "normalizedshort4": [4, gl.UNSIGNED_SHORT, 1],
                    "halfvector2": [2, gl.FLOAT, 0],
                    "halfvector4": [4, gl.FLOAT, 0]
                };
            }
        },
        {
            key: "getElementInfos",
            value: function getElementInfos(element) {
                var info = VertexElementFormat._elementInfos[element];
                if (info) return info;
                else throw "VertexElementFormat: this vertexElementFormat is not implement.";
            }
        }]);
        return VertexElementFormat;
    } ();
    VertexElementFormat.Single = "single";
    VertexElementFormat.Vector2 = "vector2";
    VertexElementFormat.Vector3 = "vector3";
    VertexElementFormat.Vector4 = "vector4";
    VertexElementFormat.Color = "color";
    VertexElementFormat.Byte4 = "byte4";
    VertexElementFormat.Byte3 = "byte3";
    VertexElementFormat.Byte2 = "byte2";
    VertexElementFormat.ByteOne = "byte";
    VertexElementFormat.Short2 = "short2";
    VertexElementFormat.Short4 = "short4";
    VertexElementFormat.NormalizedShort2 = "normalizedshort2";
    VertexElementFormat.NormalizedShort4 = "normalizedshort4";
    VertexElementFormat.HalfVector2 = "halfvector2";
    VertexElementFormat.HalfVector4 = "halfvector4";
    var Matrix4x4 =
    /*#__PURE__*/
    function() {
        function Matrix4x4() {
            var m11 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
            var m12 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var m13 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var m14 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
            var m21 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
            var m22 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
            var m23 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
            var m24 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
            var m31 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
            var m32 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
            var m33 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 1;
            var m34 = arguments.length > 11 && arguments[11] !== undefined ? arguments[11] : 0;
            var m41 = arguments.length > 12 && arguments[12] !== undefined ? arguments[12] : 0;
            var m42 = arguments.length > 13 && arguments[13] !== undefined ? arguments[13] : 0;
            var m43 = arguments.length > 14 && arguments[14] !== undefined ? arguments[14] : 0;
            var m44 = arguments.length > 15 && arguments[15] !== undefined ? arguments[15] : 1;
            var elements = arguments.length > 16 && arguments[16] !== undefined ? arguments[16] : null;
            _classCallCheck(this, Matrix4x4);
            var e = elements ? this.elements = elements: this.elements = new Float32Array(16);
            e[0] = m11;
            e[1] = m12;
            e[2] = m13;
            e[3] = m14;
            e[4] = m21;
            e[5] = m22;
            e[6] = m23;
            e[7] = m24;
            e[8] = m31;
            e[9] = m32;
            e[10] = m33;
            e[11] = m34;
            e[12] = m41;
            e[13] = m42;
            e[14] = m43;
            e[15] = m44;
        }
        _createClass(Matrix4x4, [{
            key: "setRotation",
            value: function setRotation(rotation) {
                var rotationX = rotation.x;
                var rotationY = rotation.y;
                var rotationZ = rotation.z;
                var rotationW = rotation.w;
                var xx = rotationX * rotationX;
                var yy = rotationY * rotationY;
                var zz = rotationZ * rotationZ;
                var xy = rotationX * rotationY;
                var zw = rotationZ * rotationW;
                var zx = rotationZ * rotationX;
                var yw = rotationY * rotationW;
                var yz = rotationY * rotationZ;
                var xw = rotationX * rotationW;
                var e = this.elements;
                e[0] = 1.0 - 2.0 * (yy + zz);
                e[1] = 2.0 * (xy + zw);
                e[2] = 2.0 * (zx - yw);
                e[4] = 2.0 * (xy - zw);
                e[5] = 1.0 - 2.0 * (zz + xx);
                e[6] = 2.0 * (yz + xw);
                e[8] = 2.0 * (zx + yw);
                e[9] = 2.0 * (yz - xw);
                e[10] = 1.0 - 2.0 * (yy + xx);
            }
        },
        {
            key: "setPosition",
            value: function setPosition(position) {
                var e = this.elements;
                e[12] = position.x;
                e[13] = position.y;
                e[14] = position.z;
            }
        },
        {
            key: "getElementByRowColumn",
            value: function getElementByRowColumn(row, column) {
                if (row < 0 || row > 3) throw new Error("row Rows and columns for matrices run from 0 to 3, inclusive.");
                if (column < 0 || column > 3) throw new Error("column Rows and columns for matrices run from 0 to 3, inclusive.");
                return this.elements[row * 4 + column];
            }
        },
        {
            key: "setElementByRowColumn",
            value: function setElementByRowColumn(row, column, value) {
                if (row < 0 || row > 3) throw new Error("row Rows and columns for matrices run from 0 to 3, inclusive.");
                if (column < 0 || column > 3) throw new Error("column Rows and columns for matrices run from 0 to 3, inclusive.");
                this.elements[row * 4 + column] = value;
            }
        },
        {
            key: "equalsOtherMatrix",
            value: function equalsOtherMatrix(other) {
                var e = this.elements;
                var oe = other.elements;
                return MathUtils3D.nearEqual(e[0], oe[0]) && MathUtils3D.nearEqual(e[1], oe[1]) && MathUtils3D.nearEqual(e[2], oe[2]) && MathUtils3D.nearEqual(e[3], oe[3]) && MathUtils3D.nearEqual(e[4], oe[4]) && MathUtils3D.nearEqual(e[5], oe[5]) && MathUtils3D.nearEqual(e[6], oe[6]) && MathUtils3D.nearEqual(e[7], oe[7]) && MathUtils3D.nearEqual(e[8], oe[8]) && MathUtils3D.nearEqual(e[9], oe[9]) && MathUtils3D.nearEqual(e[10], oe[10]) && MathUtils3D.nearEqual(e[11], oe[11]) && MathUtils3D.nearEqual(e[12], oe[12]) && MathUtils3D.nearEqual(e[13], oe[13]) && MathUtils3D.nearEqual(e[14], oe[14]) && MathUtils3D.nearEqual(e[15], oe[15]);
            }
        },
        {
            key: "decomposeTransRotScale",
            value: function decomposeTransRotScale(translation, rotation, scale) {
                var rotationMatrix = Matrix4x4._tempMatrix4x4;
                if (this.decomposeTransRotMatScale(translation, rotationMatrix, scale)) {
                    Quaternion.createFromMatrix4x4(rotationMatrix, rotation);
                    return true;
                } else {
                    rotation.identity();
                    return false;
                }
            }
        },
        {
            key: "decomposeTransRotMatScale",
            value: function decomposeTransRotMatScale(translation, rotationMatrix, scale) {
                var e = this.elements;
                var te = translation;
                var re = rotationMatrix.elements;
                var se = scale;
                te.x = e[12];
                te.y = e[13];
                te.z = e[14];
                var m11 = e[0],
                m12 = e[1],
                m13 = e[2];
                var m21 = e[4],
                m22 = e[5],
                m23 = e[6];
                var m31 = e[8],
                m32 = e[9],
                m33 = e[10];
                var sX = se.x = Math.sqrt(m11 * m11 + m12 * m12 + m13 * m13);
                var sY = se.y = Math.sqrt(m21 * m21 + m22 * m22 + m23 * m23);
                var sZ = se.z = Math.sqrt(m31 * m31 + m32 * m32 + m33 * m33);
                if (MathUtils3D.isZero(sX) || MathUtils3D.isZero(sY) || MathUtils3D.isZero(sZ)) {
                    re[1] = re[2] = re[3] = re[4] = re[6] = re[7] = re[8] = re[9] = re[11] = re[12] = re[13] = re[14] = 0;
                    re[0] = re[5] = re[10] = re[15] = 1;
                    return false;
                }
                var at = Matrix4x4._tempVector0;
                at.x = m31 / sZ;
                at.y = m32 / sZ;
                at.z = m33 / sZ;
                var tempRight = Matrix4x4._tempVector1;
                tempRight.x = m11 / sX;
                tempRight.y = m12 / sX;
                tempRight.z = m13 / sX;
                var up = Matrix4x4._tempVector2;
                Vector3.cross(at, tempRight, up);
                var right = Matrix4x4._tempVector1;
                Vector3.cross(up, at, right);
                re[3] = re[7] = re[11] = re[12] = re[13] = re[14] = 0;
                re[15] = 1;
                re[0] = right.x;
                re[1] = right.y;
                re[2] = right.z;
                re[4] = up.x;
                re[5] = up.y;
                re[6] = up.z;
                re[8] = at.x;
                re[9] = at.y;
                re[10] = at.z;
                re[0] * m11 + re[1] * m12 + re[2] * m13 < 0.0 && (se.x = -sX);
                re[4] * m21 + re[5] * m22 + re[6] * m23 < 0.0 && (se.y = -sY);
                re[8] * m31 + re[9] * m32 + re[10] * m33 < 0.0 && (se.z = -sZ);
                return true;
            }
        },
        {
            key: "decomposeYawPitchRoll",
            value: function decomposeYawPitchRoll(yawPitchRoll) {
                var pitch = Math.asin( - this.elements[9]);
                yawPitchRoll.y = pitch;
                var test = Math.cos(pitch);
                if (test > MathUtils3D.zeroTolerance) {
                    yawPitchRoll.z = Math.atan2(this.elements[1], this.elements[5]);
                    yawPitchRoll.x = Math.atan2(this.elements[8], this.elements[10]);
                } else {
                    yawPitchRoll.z = Math.atan2( - this.elements[4], this.elements[0]);
                    yawPitchRoll.x = 0.0;
                }
            }
        },
        {
            key: "normalize",
            value: function normalize() {
                var v = this.elements;
                var c = v[0],
                d = v[1],
                e = v[2],
                g = Math.sqrt(c * c + d * d + e * e);
                if (g) {
                    if (g == 1) return;
                } else {
                    v[0] = 0;
                    v[1] = 0;
                    v[2] = 0;
                    return;
                }
                g = 1 / g;
                v[0] = c * g;
                v[1] = d * g;
                v[2] = e * g;
            }
        },
        {
            key: "transpose",
            value: function transpose() {
                var e, t;
                e = this.elements;
                t = e[1];
                e[1] = e[4];
                e[4] = t;
                t = e[2];
                e[2] = e[8];
                e[8] = t;
                t = e[3];
                e[3] = e[12];
                e[12] = t;
                t = e[6];
                e[6] = e[9];
                e[9] = t;
                t = e[7];
                e[7] = e[13];
                e[13] = t;
                t = e[11];
                e[11] = e[14];
                e[14] = t;
                return this;
            }
        },
        {
            key: "invert",
            value: function invert(out) {
                var ae = this.elements;
                var oe = out.elements;
                var a00 = ae[0],
                a01 = ae[1],
                a02 = ae[2],
                a03 = ae[3],
                a10 = ae[4],
                a11 = ae[5],
                a12 = ae[6],
                a13 = ae[7],
                a20 = ae[8],
                a21 = ae[9],
                a22 = ae[10],
                a23 = ae[11],
                a30 = ae[12],
                a31 = ae[13],
                a32 = ae[14],
                a33 = ae[15],
                b00 = a00 * a11 - a01 * a10,
                b01 = a00 * a12 - a02 * a10,
                b02 = a00 * a13 - a03 * a10,
                b03 = a01 * a12 - a02 * a11,
                b04 = a01 * a13 - a03 * a11,
                b05 = a02 * a13 - a03 * a12,
                b06 = a20 * a31 - a21 * a30,
                b07 = a20 * a32 - a22 * a30,
                b08 = a20 * a33 - a23 * a30,
                b09 = a21 * a32 - a22 * a31,
                b10 = a21 * a33 - a23 * a31,
                b11 = a22 * a33 - a23 * a32,
                det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
                if (Math.abs(det) === 0.0) {
                    return;
                }
                det = 1.0 / det;
                oe[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
                oe[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
                oe[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
                oe[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
                oe[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
                oe[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
                oe[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
                oe[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
                oe[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
                oe[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
                oe[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
                oe[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
                oe[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
                oe[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
                oe[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
                oe[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
            }
        },
        {
            key: "identity",
            value: function identity() {
                var e = this.elements;
                e[1] = e[2] = e[3] = e[4] = e[6] = e[7] = e[8] = e[9] = e[11] = e[12] = e[13] = e[14] = 0;
                e[0] = e[5] = e[10] = e[15] = 1;
            }
        },
        {
            key: "isIdentity",
            value: function isIdentity() {
                var delty = function delty(num0, num1) {
                    return Math.abs(num0 - num1) < 1e-7;
                };
                var e = this.elements;
                var defined = Matrix4x4.DEFAULT.elements;
                for (var i = 0,
                n = e.length; i < n; i++) {
                    if (!delty(e[i], defined[i])) return false;
                }
                return true;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var i, s, d;
                s = this.elements;
                d = destObject.elements;
                if (s === d) {
                    return;
                }
                for (i = 0; i < 16; ++i) {
                    d[i] = s[i];
                }
            }
        },
        {
            key: "cloneByArray",
            value: function cloneByArray(destObject) {
                var s = this.elements;
                var d = destObject;
                for (var i = 0; i < 16; ++i) {
                    s[i] = d[i];
                }
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Matrix4x4();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "getTranslationVector",
            value: function getTranslationVector(out) {
                var me = this.elements;
                out.x = me[12];
                out.y = me[13];
                out.z = me[14];
            }
        },
        {
            key: "setTranslationVector",
            value: function setTranslationVector(translate) {
                var me = this.elements;
                var ve = translate;
                me[12] = ve.x;
                me[13] = ve.y;
                me[14] = ve.z;
            }
        },
        {
            key: "getForward",
            value: function getForward(out) {
                var me = this.elements;
                out.x = -me[8];
                out.y = -me[9];
                out.z = -me[10];
            }
        },
        {
            key: "setForward",
            value: function setForward(forward) {
                var me = this.elements;
                me[8] = -forward.x;
                me[9] = -forward.y;
                me[10] = -forward.z;
            }
        },
        {
            key: "getInvertFront",
            value: function getInvertFront() {
                this.decomposeTransRotScale(Matrix4x4._tempVector0, Matrix4x4._tempQuaternion, Matrix4x4._tempVector1);
                var scale = Matrix4x4._tempVector1;
                var isInvert = scale.x < 0;
                scale.y < 0 && (isInvert = !isInvert);
                scale.z < 0 && (isInvert = !isInvert);
                return isInvert;
            }
        }], [{
            key: "createRotationX",
            value: function createRotationX(rad, out) {
                var oe = out.elements;
                var s = Math.sin(rad),
                c = Math.cos(rad);
                oe[1] = oe[2] = oe[3] = oe[4] = oe[7] = oe[8] = oe[11] = oe[12] = oe[13] = oe[14] = 0;
                oe[0] = oe[15] = 1;
                oe[5] = oe[10] = c;
                oe[6] = s;
                oe[9] = -s;
            }
        },
        {
            key: "createRotationY",
            value: function createRotationY(rad, out) {
                var oe = out.elements;
                var s = Math.sin(rad),
                c = Math.cos(rad);
                oe[1] = oe[3] = oe[4] = oe[6] = oe[7] = oe[9] = oe[11] = oe[12] = oe[13] = oe[14] = 0;
                oe[5] = oe[15] = 1;
                oe[0] = oe[10] = c;
                oe[2] = -s;
                oe[8] = s;
            }
        },
        {
            key: "createRotationZ",
            value: function createRotationZ(rad, out) {
                var oe = out.elements;
                var s = Math.sin(rad),
                c = Math.cos(rad);
                oe[2] = oe[3] = oe[6] = oe[7] = oe[8] = oe[9] = oe[11] = oe[12] = oe[13] = oe[14] = 0;
                oe[10] = oe[15] = 1;
                oe[0] = oe[5] = c;
                oe[1] = s;
                oe[4] = -s;
            }
        },
        {
            key: "createRotationYawPitchRoll",
            value: function createRotationYawPitchRoll(yaw, pitch, roll, result) {
                Quaternion.createFromYawPitchRoll(yaw, pitch, roll, Matrix4x4._tempQuaternion);
                Matrix4x4.createRotationQuaternion(Matrix4x4._tempQuaternion, result);
            }
        },
        {
            key: "createRotationAxis",
            value: function createRotationAxis(axis, angle, result) {
                var x = axis.x;
                var y = axis.y;
                var z = axis.z;
                var cos = Math.cos(angle);
                var sin = Math.sin(angle);
                var xx = x * x;
                var yy = y * y;
                var zz = z * z;
                var xy = x * y;
                var xz = x * z;
                var yz = y * z;
                var resultE = result.elements;
                resultE[3] = resultE[7] = resultE[11] = resultE[12] = resultE[13] = resultE[14] = 0;
                resultE[15] = 1.0;
                resultE[0] = xx + cos * (1.0 - xx);
                resultE[1] = xy - cos * xy + sin * z;
                resultE[2] = xz - cos * xz - sin * y;
                resultE[4] = xy - cos * xy - sin * z;
                resultE[5] = yy + cos * (1.0 - yy);
                resultE[6] = yz - cos * yz + sin * x;
                resultE[8] = xz - cos * xz + sin * y;
                resultE[9] = yz - cos * yz - sin * x;
                resultE[10] = zz + cos * (1.0 - zz);
            }
        },
        {
            key: "createRotationQuaternion",
            value: function createRotationQuaternion(rotation, result) {
                var resultE = result.elements;
                var rotationX = rotation.x;
                var rotationY = rotation.y;
                var rotationZ = rotation.z;
                var rotationW = rotation.w;
                var xx = rotationX * rotationX;
                var yy = rotationY * rotationY;
                var zz = rotationZ * rotationZ;
                var xy = rotationX * rotationY;
                var zw = rotationZ * rotationW;
                var zx = rotationZ * rotationX;
                var yw = rotationY * rotationW;
                var yz = rotationY * rotationZ;
                var xw = rotationX * rotationW;
                resultE[3] = resultE[7] = resultE[11] = resultE[12] = resultE[13] = resultE[14] = 0;
                resultE[15] = 1.0;
                resultE[0] = 1.0 - 2.0 * (yy + zz);
                resultE[1] = 2.0 * (xy + zw);
                resultE[2] = 2.0 * (zx - yw);
                resultE[4] = 2.0 * (xy - zw);
                resultE[5] = 1.0 - 2.0 * (zz + xx);
                resultE[6] = 2.0 * (yz + xw);
                resultE[8] = 2.0 * (zx + yw);
                resultE[9] = 2.0 * (yz - xw);
                resultE[10] = 1.0 - 2.0 * (yy + xx);
            }
        },
        {
            key: "createTranslate",
            value: function createTranslate(trans, out) {
                var oe = out.elements;
                oe[4] = oe[8] = oe[1] = oe[9] = oe[2] = oe[6] = oe[3] = oe[7] = oe[11] = 0;
                oe[0] = oe[5] = oe[10] = oe[15] = 1;
                oe[12] = trans.x;
                oe[13] = trans.y;
                oe[14] = trans.z;
            }
        },
        {
            key: "createScaling",
            value: function createScaling(scale, out) {
                var oe = out.elements;
                oe[0] = scale.x;
                oe[5] = scale.y;
                oe[10] = scale.z;
                oe[1] = oe[4] = oe[8] = oe[12] = oe[9] = oe[13] = oe[2] = oe[6] = oe[14] = oe[3] = oe[7] = oe[11] = 0;
                oe[15] = 1;
            }
        },
        {
            key: "multiply",
            value: function multiply(left, right, out) {
                var l = right.elements;
                var r = left.elements;
                var e = out.elements;
                var l11 = l[0],
                l12 = l[1],
                l13 = l[2],
                l14 = l[3];
                var l21 = l[4],
                l22 = l[5],
                l23 = l[6],
                l24 = l[7];
                var l31 = l[8],
                l32 = l[9],
                l33 = l[10],
                l34 = l[11];
                var l41 = l[12],
                l42 = l[13],
                l43 = l[14],
                l44 = l[15];
                var r11 = r[0],
                r12 = r[1],
                r13 = r[2],
                r14 = r[3];
                var r21 = r[4],
                r22 = r[5],
                r23 = r[6],
                r24 = r[7];
                var r31 = r[8],
                r32 = r[9],
                r33 = r[10],
                r34 = r[11];
                var r41 = r[12],
                r42 = r[13],
                r43 = r[14],
                r44 = r[15];
                e[0] = l11 * r11 + l12 * r21 + l13 * r31 + l14 * r41;
                e[1] = l11 * r12 + l12 * r22 + l13 * r32 + l14 * r42;
                e[2] = l11 * r13 + l12 * r23 + l13 * r33 + l14 * r43;
                e[3] = l11 * r14 + l12 * r24 + l13 * r34 + l14 * r44;
                e[4] = l21 * r11 + l22 * r21 + l23 * r31 + l24 * r41;
                e[5] = l21 * r12 + l22 * r22 + l23 * r32 + l24 * r42;
                e[6] = l21 * r13 + l22 * r23 + l23 * r33 + l24 * r43;
                e[7] = l21 * r14 + l22 * r24 + l23 * r34 + l24 * r44;
                e[8] = l31 * r11 + l32 * r21 + l33 * r31 + l34 * r41;
                e[9] = l31 * r12 + l32 * r22 + l33 * r32 + l34 * r42;
                e[10] = l31 * r13 + l32 * r23 + l33 * r33 + l34 * r43;
                e[11] = l31 * r14 + l32 * r24 + l33 * r34 + l34 * r44;
                e[12] = l41 * r11 + l42 * r21 + l43 * r31 + l44 * r41;
                e[13] = l41 * r12 + l42 * r22 + l43 * r32 + l44 * r42;
                e[14] = l41 * r13 + l42 * r23 + l43 * r33 + l44 * r43;
                e[15] = l41 * r14 + l42 * r24 + l43 * r34 + l44 * r44;
            }
        },
        {
            key: "multiplyForNative",
            value: function multiplyForNative(left, right, out) {
                Laya.LayaGL.instance.matrix4x4Multiply(left.elements, right.elements, out.elements);
            }
        },
        {
            key: "createFromQuaternion",
            value: function createFromQuaternion(rotation, out) {
                var e = out.elements;
                var x = rotation.x,
                y = rotation.y,
                z = rotation.z,
                w = rotation.w;
                var x2 = x + x;
                var y2 = y + y;
                var z2 = z + z;
                var xx = x * x2;
                var yx = y * x2;
                var yy = y * y2;
                var zx = z * x2;
                var zy = z * y2;
                var zz = z * z2;
                var wx = w * x2;
                var wy = w * y2;
                var wz = w * z2;
                e[0] = 1 - yy - zz;
                e[1] = yx + wz;
                e[2] = zx - wy;
                e[3] = 0;
                e[4] = yx - wz;
                e[5] = 1 - xx - zz;
                e[6] = zy + wx;
                e[7] = 0;
                e[8] = zx + wy;
                e[9] = zy - wx;
                e[10] = 1 - xx - yy;
                e[11] = 0;
                e[12] = 0;
                e[13] = 0;
                e[14] = 0;
                e[15] = 1;
            }
        },
        {
            key: "createAffineTransformation",
            value: function createAffineTransformation(trans, rot, scale, out) {
                var oe = out.elements;
                var x = rot.x,
                y = rot.y,
                z = rot.z,
                w = rot.w,
                x2 = x + x,
                y2 = y + y,
                z2 = z + z;
                var xx = x * x2,
                xy = x * y2,
                xz = x * z2,
                yy = y * y2,
                yz = y * z2,
                zz = z * z2;
                var wx = w * x2,
                wy = w * y2,
                wz = w * z2,
                sx = scale.x,
                sy = scale.y,
                sz = scale.z;
                oe[0] = (1 - (yy + zz)) * sx;
                oe[1] = (xy + wz) * sx;
                oe[2] = (xz - wy) * sx;
                oe[3] = 0;
                oe[4] = (xy - wz) * sy;
                oe[5] = (1 - (xx + zz)) * sy;
                oe[6] = (yz + wx) * sy;
                oe[7] = 0;
                oe[8] = (xz + wy) * sz;
                oe[9] = (yz - wx) * sz;
                oe[10] = (1 - (xx + yy)) * sz;
                oe[11] = 0;
                oe[12] = trans.x;
                oe[13] = trans.y;
                oe[14] = trans.z;
                oe[15] = 1;
            }
        },
        {
            key: "createLookAt",
            value: function createLookAt(eye, target, up, out) {
                var oE = out.elements;
                var xaxis = Matrix4x4._tempVector0;
                var yaxis = Matrix4x4._tempVector1;
                var zaxis = Matrix4x4._tempVector2;
                Vector3.subtract(eye, target, zaxis);
                Vector3.normalize(zaxis, zaxis);
                Vector3.cross(up, zaxis, xaxis);
                Vector3.normalize(xaxis, xaxis);
                Vector3.cross(zaxis, xaxis, yaxis);
                oE[3] = oE[7] = oE[11] = 0;
                oE[15] = 1;
                oE[0] = xaxis.x;
                oE[4] = xaxis.y;
                oE[8] = xaxis.z;
                oE[1] = yaxis.x;
                oE[5] = yaxis.y;
                oE[9] = yaxis.z;
                oE[2] = zaxis.x;
                oE[6] = zaxis.y;
                oE[10] = zaxis.z;
                oE[12] = -Vector3.dot(xaxis, eye);
                oE[13] = -Vector3.dot(yaxis, eye);
                oE[14] = -Vector3.dot(zaxis, eye);
            }
        },
        {
            key: "createPerspective",
            value: function createPerspective(fov, aspect, znear, zfar, out) {
                var yScale = 1.0 / Math.tan(fov * 0.5);
                var xScale = yScale / aspect;
                var halfWidth = znear / xScale;
                var halfHeight = znear / yScale;
                Matrix4x4.createPerspectiveOffCenter( - halfWidth, halfWidth, -halfHeight, halfHeight, znear, zfar, out);
            }
        },
        {
            key: "createPerspectiveOffCenter",
            value: function createPerspectiveOffCenter(left, right, bottom, top, znear, zfar, out) {
                var oe = out.elements;
                var zRange = zfar / (zfar - znear);
                oe[1] = oe[2] = oe[3] = oe[4] = oe[6] = oe[7] = oe[12] = oe[13] = oe[15] = 0;
                oe[0] = 2.0 * znear / (right - left);
                oe[5] = 2.0 * znear / (top - bottom);
                oe[8] = (left + right) / (right - left);
                oe[9] = (top + bottom) / (top - bottom);
                oe[10] = -zRange;
                oe[11] = -1.0;
                oe[14] = -znear * zRange;
            }
        },
        {
            key: "createOrthoOffCenter",
            value: function createOrthoOffCenter(left, right, bottom, top, znear, zfar, out) {
                var oe = out.elements;
                var zRange = 1.0 / (zfar - znear);
                oe[1] = oe[2] = oe[3] = oe[4] = oe[6] = oe[8] = oe[7] = oe[9] = oe[11] = 0;
                oe[15] = 1;
                oe[0] = 2.0 / (right - left);
                oe[5] = 2.0 / (top - bottom);
                oe[10] = -zRange;
                oe[12] = (left + right) / (left - right);
                oe[13] = (top + bottom) / (bottom - top);
                oe[14] = -znear * zRange;
            }
        },
        {
            key: "billboard",
            value: function billboard(objectPosition, cameraPosition, cameraUp, cameraForward, mat) {
                Vector3.subtract(objectPosition, cameraPosition, Matrix4x4._tempVector0);
                var lengthSq = Vector3.scalarLengthSquared(Matrix4x4._tempVector0);
                if (MathUtils3D.isZero(lengthSq)) {
                    Vector3.scale(cameraForward, -1, Matrix4x4._tempVector1);
                    Matrix4x4._tempVector1.cloneTo(Matrix4x4._tempVector0);
                } else {
                    Vector3.scale(Matrix4x4._tempVector0, 1 / Math.sqrt(lengthSq), Matrix4x4._tempVector0);
                }
                Vector3.cross(cameraUp, Matrix4x4._tempVector0, Matrix4x4._tempVector2);
                Vector3.normalize(Matrix4x4._tempVector2, Matrix4x4._tempVector2);
                Vector3.cross(Matrix4x4._tempVector0, Matrix4x4._tempVector2, Matrix4x4._tempVector3);
                var crosse = Matrix4x4._tempVector2;
                var finale = Matrix4x4._tempVector3;
                var diffee = Matrix4x4._tempVector0;
                var obpose = objectPosition;
                var mate = mat.elements;
                mate[0] = crosse.x;
                mate[1] = crosse.y;
                mate[2] = crosse.z;
                mate[3] = 0.0;
                mate[4] = finale.x;
                mate[5] = finale.y;
                mate[6] = finale.z;
                mate[7] = 0.0;
                mate[8] = diffee.x;
                mate[9] = diffee.y;
                mate[10] = diffee.z;
                mate[11] = 0.0;
                mate[12] = obpose.x;
                mate[13] = obpose.y;
                mate[14] = obpose.z;
                mate[15] = 1.0;
            }
        },
        {
            key: "translation",
            value: function translation(v3, out) {
                var oe = out.elements;
                oe[0] = oe[5] = oe[10] = oe[15] = 1;
                oe[12] = v3.x;
                oe[13] = v3.y;
                oe[14] = v3.z;
            }
        }]);
        return Matrix4x4;
    } ();
    Matrix4x4._tempMatrix4x4 = new Matrix4x4();
    Matrix4x4.TEMPMatrix0 = new Matrix4x4();
    Matrix4x4.TEMPMatrix1 = new Matrix4x4();
    Matrix4x4._tempVector0 = new Vector3();
    Matrix4x4._tempVector1 = new Vector3();
    Matrix4x4._tempVector2 = new Vector3();
    Matrix4x4._tempVector3 = new Vector3();
    Matrix4x4._tempQuaternion = new Quaternion();
    Matrix4x4.DEFAULT = new Matrix4x4();
    Matrix4x4.ZERO = new Matrix4x4(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    window.Matrix4x4 = Matrix4x4;
    var ShaderData =
    /*#__PURE__*/
    function() {
        function ShaderData() {
            var ownerResource = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
            _classCallCheck(this, ShaderData);
            this._ownerResource = null;
            this._data = null;
            this._defineDatas = new DefineDatas();
            this._runtimeCopyValues = [];
            this._ownerResource = ownerResource;
            this._initData();
        }
        _createClass(ShaderData, [{
            key: "_initData",
            value: function _initData() {
                this._data = {};
            }
        },
        {
            key: "getData",
            value: function getData() {
                return this._data;
            }
        },
        {
            key: "addDefine",
            value: function addDefine(define) {
                this._defineDatas.add(define);
            }
        },
        {
            key: "removeDefine",
            value: function removeDefine(define) {
                this._defineDatas.remove(define);
            }
        },
        {
            key: "hasDefine",
            value: function hasDefine(define) {
                return this._defineDatas.has(define);
            }
        },
        {
            key: "clearDefine",
            value: function clearDefine() {
                this._defineDatas.clear();
            }
        },
        {
            key: "getBool",
            value: function getBool(index) {
                return this._data[index];
            }
        },
        {
            key: "setBool",
            value: function setBool(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getInt",
            value: function getInt(index) {
                return this._data[index];
            }
        },
        {
            key: "setInt",
            value: function setInt(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getNumber",
            value: function getNumber(index) {
                return this._data[index];
            }
        },
        {
            key: "setNumber",
            value: function setNumber(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getVector2",
            value: function getVector2(index) {
                return this._data[index];
            }
        },
        {
            key: "setVector2",
            value: function setVector2(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getVector3",
            value: function getVector3(index) {
                return this._data[index];
            }
        },
        {
            key: "setVector3",
            value: function setVector3(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getVector",
            value: function getVector(index) {
                return this._data[index];
            }
        },
        {
            key: "setVector",
            value: function setVector(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getQuaternion",
            value: function getQuaternion(index) {
                return this._data[index];
            }
        },
        {
            key: "setQuaternion",
            value: function setQuaternion(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getMatrix4x4",
            value: function getMatrix4x4(index) {
                return this._data[index];
            }
        },
        {
            key: "setMatrix4x4",
            value: function setMatrix4x4(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getBuffer",
            value: function getBuffer(shaderIndex) {
                return this._data[shaderIndex];
            }
        },
        {
            key: "setBuffer",
            value: function setBuffer(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "setTexture",
            value: function setTexture(index, value) {
                var lastValue = this._data[index];
                this._data[index] = value ? value: Laya.Texture2D.erroTextur;
                if (this._ownerResource && this._ownerResource.referenceCount > 0) {
                    lastValue && lastValue._removeReference();
                    value && value._addReference();
                }
            }
        },
        {
            key: "getTexture",
            value: function getTexture(index) {
                return this._data[index];
            }
        },
        {
            key: "setValueData",
            value: function setValueData(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getValueData",
            value: function getValueData(index) {
                return this._data[index];
            }
        },
        {
            key: "setAttribute",
            value: function setAttribute(index, value) {
                this._data[index] = value;
            }
        },
        {
            key: "getAttribute",
            value: function getAttribute(index) {
                return this._data[index];
            }
        },
        {
            key: "getLength",
            value: function getLength() {
                return this._data.length;
            }
        },
        {
            key: "setLength",
            value: function setLength(value) {
                this._data.length = value;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                var destData = dest._data;
                for (var k in this._data) {
                    var value = this._data[k];
                    if (value != null) {
                        if (typeof value == 'number') {
                            destData[k] = value;
                        } else if (typeof value == 'number') {
                            destData[k] = value;
                        } else if (typeof value == "boolean") {
                            destData[k] = value;
                        } else if (value instanceof Vector2) {
                            var v2 = destData[k] || (destData[k] = new Vector2());
                            value.cloneTo(v2);
                            destData[k] = v2;
                        } else if (value instanceof Vector3) {
                            var v3 = destData[k] || (destData[k] = new Vector3());
                            value.cloneTo(v3);
                            destData[k] = v3;
                        } else if (value instanceof Vector4) {
                            var v4 = destData[k] || (destData[k] = new Vector4());
                            value.cloneTo(v4);
                            destData[k] = v4;
                        } else if (value instanceof Matrix4x4) {
                            var mat = destData[k] || (destData[k] = new Matrix4x4());
                            value.cloneTo(mat);
                            destData[k] = mat;
                        } else if (value instanceof Laya.BaseTexture) {
                            destData[k] = value;
                        }
                    }
                }
                this._defineDatas.cloneTo(dest._defineDatas);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new ShaderData();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "cloneToForNative",
            value: function cloneToForNative(destObject) {
                var dest = destObject;
                var diffSize = this._int32Data.length - dest._int32Data.length;
                if (diffSize > 0) {
                    dest.needRenewArrayBufferForNative(this._int32Data.length);
                }
                dest._int32Data.set(this._int32Data, 0);
                var destData = dest._nativeArray;
                var dataCount = this._nativeArray.length;
                destData.length = dataCount;
                for (var i = 0; i < dataCount; i++) {
                    var value = this._nativeArray[i];
                    if (value) {
                        if (typeof value == 'number') {
                            destData[i] = value;
                            dest.setNumber(i, value);
                        } else if (typeof value == 'number') {
                            destData[i] = value;
                            dest.setInt(i, value);
                        } else if (typeof value == "boolean") {
                            destData[i] = value;
                            dest.setBool(i, value);
                        } else if (value instanceof Vector2) {
                            var v2 = destData[i] || (destData[i] = new Vector2());
                            value.cloneTo(v2);
                            destData[i] = v2;
                            dest.setVector2(i, v2);
                        } else if (value instanceof Vector3) {
                            var v3 = destData[i] || (destData[i] = new Vector3());
                            value.cloneTo(v3);
                            destData[i] = v3;
                            dest.setVector3(i, v3);
                        } else if (value instanceof Vector4) {
                            var v4 = destData[i] || (destData[i] = new Vector4());
                            value.cloneTo(v4);
                            destData[i] = v4;
                            dest.setVector(i, v4);
                        } else if (value instanceof Matrix4x4) {
                            var mat = destData[i] || (destData[i] = new Matrix4x4());
                            value.cloneTo(mat);
                            destData[i] = mat;
                            dest.setMatrix4x4(i, mat);
                        } else if (value instanceof Laya.BaseTexture) {
                            destData[i] = value;
                            dest.setTexture(i, value);
                        }
                    }
                }
                this._defineDatas.cloneTo(dest._defineDatas);
            }
        },
        {
            key: "_initDataForNative",
            value: function _initDataForNative() {
                var length = 8;
                this._frameCount = -1;
                this._runtimeCopyValues.length = 0;
                this._nativeArray = [];
                this._data = new ArrayBuffer(length * 4);
                this._int32Data = new Int32Array(this._data);
                this._float32Data = new Float32Array(this._data);
                Laya.LayaGL.instance.createArrayBufferRef(this._data, Laya.LayaGL.ARRAY_BUFFER_TYPE_DATA, true);
            }
        },
        {
            key: "needRenewArrayBufferForNative",
            value: function needRenewArrayBufferForNative(index) {
                if (index >= this._int32Data.length) {
                    var nByteLen = (index + 1) * 4;
                    var pre = this._int32Data;
                    var preConchRef = this._data["conchRef"];
                    var prePtrID = this._data["_ptrID"];
                    this._data = new ArrayBuffer(nByteLen);
                    this._int32Data = new Int32Array(this._data);
                    this._float32Data = new Float32Array(this._data);
                    this._data["conchRef"] = preConchRef;
                    this._data["_ptrID"] = prePtrID;
                    pre && this._int32Data.set(pre, 0);
                    var layagl = Laya.LayaGL.instance;
                    if (layagl.updateArrayBufferRef) {
                        layagl.updateArrayBufferRef(this._data['_ptrID'], preConchRef.isSyncToRender(), this._data);
                    } else {
                        window.conch.updateArrayBufferRef(this._data['_ptrID'], preConchRef.isSyncToRender(), this._data);
                    }
                }
            }
        },
        {
            key: "getDataForNative",
            value: function getDataForNative() {
                return this._nativeArray;
            }
        },
        {
            key: "getIntForNative",
            value: function getIntForNative(index) {
                return this._int32Data[index];
            }
        },
        {
            key: "setIntForNative",
            value: function setIntForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._int32Data[index] = value;
                this._nativeArray[index] = value;
            }
        },
        {
            key: "getBoolForNative",
            value: function getBoolForNative(index) {
                return this._int32Data[index] == 1;
            }
        },
        {
            key: "setBoolForNative",
            value: function setBoolForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._int32Data[index] = value ? 1 : 0;
                this._nativeArray[index] = value;
            }
        },
        {
            key: "getNumberForNative",
            value: function getNumberForNative(index) {
                return this._float32Data[index];
            }
        },
        {
            key: "setNumberForNative",
            value: function setNumberForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._float32Data[index] = value;
                this._nativeArray[index] = value;
            }
        },
        {
            key: "getMatrix4x4ForNative",
            value: function getMatrix4x4ForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setMatrix4x4ForNative",
            value: function setMatrix4x4ForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                var nPtrID = this.setReferenceForNative(value.elements);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getVectorForNative",
            value: function getVectorForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setVectorForNative",
            value: function setVectorForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                if (!value.elements) {
                    value.forNativeElement();
                }
                var nPtrID = this.setReferenceForNative(value.elements);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getVector2ForNative",
            value: function getVector2ForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setVector2ForNative",
            value: function setVector2ForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                if (!value.elements) {
                    value.forNativeElement();
                }
                var nPtrID = this.setReferenceForNative(value.elements);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getVector3ForNative",
            value: function getVector3ForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setVector3ForNative",
            value: function setVector3ForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                if (!value.elements) {
                    value.forNativeElement();
                }
                var nPtrID = this.setReferenceForNative(value.elements);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getQuaternionForNative",
            value: function getQuaternionForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setQuaternionForNative",
            value: function setQuaternionForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                if (!value.elements) {
                    value.forNativeElement();
                }
                var nPtrID = this.setReferenceForNative(value.elements);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getBufferForNative",
            value: function getBufferForNative(shaderIndex) {
                return this._nativeArray[shaderIndex];
            }
        },
        {
            key: "setBufferForNative",
            value: function setBufferForNative(index, value) {
                this.needRenewArrayBufferForNative(index);
                this._nativeArray[index] = value;
                var nPtrID = this.setReferenceForNative(value);
                this._int32Data[index] = nPtrID;
            }
        },
        {
            key: "getAttributeForNative",
            value: function getAttributeForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setAttributeForNative",
            value: function setAttributeForNative(index, value) {
                this._nativeArray[index] = value;
                if (!value["_ptrID"]) {
                    Laya.LayaGL.instance.createArrayBufferRef(value, Laya.LayaGL.ARRAY_BUFFER_TYPE_DATA, true);
                }
                Laya.LayaGL.instance.syncBufferToRenderThread(value);
                this._int32Data[index] = value["_ptrID"];
            }
        },
        {
            key: "getTextureForNative",
            value: function getTextureForNative(index) {
                return this._nativeArray[index];
            }
        },
        {
            key: "setTextureForNative",
            value: function setTextureForNative(index, value) {
                if (!value) return;
                this.needRenewArrayBufferForNative(index);
                var lastValue = this._nativeArray[index];
                this._nativeArray[index] = value;
                var glTexture = value._getSource() || value.defaulteTexture._getSource();
                this._int32Data[index] = glTexture.id;
                if (this._ownerResource && this._ownerResource.referenceCount > 0) {
                    lastValue && lastValue._removeReference();
                    value && value._addReference();
                }
            }
        },
        {
            key: "setReferenceForNative",
            value: function setReferenceForNative(value) {
                this.clearRuntimeCopyArray();
                var nRefID = 0;
                var nPtrID = 0;
                if (ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_) {
                    Laya.LayaGL.instance.createArrayBufferRefs(value, Laya.LayaGL.ARRAY_BUFFER_TYPE_DATA, true, Laya.LayaGL.ARRAY_BUFFER_REF_REFERENCE);
                    nRefID = 0;
                    nPtrID = value.getPtrID(nRefID);
                } else {
                    Laya.LayaGL.instance.createArrayBufferRefs(value, Laya.LayaGL.ARRAY_BUFFER_TYPE_DATA, true, Laya.LayaGL.ARRAY_BUFFER_REF_COPY);
                    nRefID = value.getRefNum() - 1;
                    nPtrID = value.getPtrID(nRefID);
                    this._runtimeCopyValues.push({
                        "obj": value,
                        "refID": nRefID,
                        "ptrID": nPtrID
                    });
                }
                Laya.LayaGL.instance.syncBufferToRenderThread(value, nRefID);
                return nPtrID;
            }
        },
        {
            key: "clearRuntimeCopyArray",
            value: function clearRuntimeCopyArray() {
                var currentFrame = Laya.Stat.loopCount;
                if (this._frameCount != currentFrame) {
                    this._frameCount = currentFrame;
                    for (var i = 0,
                    n = this._runtimeCopyValues.length; i < n; i++) {
                        var obj = this._runtimeCopyValues[i];
                        obj.obj.clearRefNum();
                    }
                    this._runtimeCopyValues.length = 0;
                }
            }
        }], [{
            key: "setRuntimeValueMode",
            value: function setRuntimeValueMode(bReference) {
                ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_ = bReference;
            }
        }]);
        return ShaderData;
    } ();
    ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_ = true;
    var VertexDeclaration =
    /*#__PURE__*/
    function() {
        function VertexDeclaration(vertexStride, vertexElements) {
            _classCallCheck(this, VertexDeclaration);
            this._id = ++VertexDeclaration._uniqueIDCounter;
            this._vertexElementsDic = {};
            this._vertexStride = vertexStride;
            this._vertexElements = vertexElements;
            var count = vertexElements.length;
            this._shaderValues = new ShaderData(null);
            for (var j = 0; j < count; j++) {
                var vertexElement = vertexElements[j];
                var name = vertexElement._elementUsage;
                this._vertexElementsDic[name] = vertexElement;
                var value = new Int32Array(5);
                var elmentInfo = VertexElementFormat.getElementInfos(vertexElement._elementFormat);
                value[0] = elmentInfo[0];
                value[1] = elmentInfo[1];
                value[2] = elmentInfo[2];
                value[3] = this._vertexStride;
                value[4] = vertexElement._offset;
                this._shaderValues.setAttribute(name, value);
            }
        }
        _createClass(VertexDeclaration, [{
            key: "id",
            get: function get() {
                return this._id;
            }
        },
        {
            key: "vertexStride",
            get: function get() {
                return this._vertexStride;
            }
        },
        {
            key: "vertexElementCount",
            get: function get() {
                return this._vertexElements.length;
            }
        },
        {
            key: "getVertexElementByIndex",
            value: function getVertexElementByIndex(index) {
                return this._vertexElements[index];
            }
        },
        {
            key: "getVertexElementByUsage",
            value: function getVertexElementByUsage(usage) {
                return this._vertexElementsDic[usage];
            }
        }]);
        return VertexDeclaration;
    } ();
    VertexDeclaration._uniqueIDCounter = 1;
    var VertexElement =
    /*#__PURE__*/
    function() {
        function VertexElement(offset, elementFormat, elementUsage) {
            _classCallCheck(this, VertexElement);
            this._offset = offset;
            this._elementFormat = elementFormat;
            this._elementUsage = elementUsage;
        }
        _createClass(VertexElement, [{
            key: "offset",
            get: function get() {
                return this._offset;
            }
        },
        {
            key: "elementFormat",
            get: function get() {
                return this._elementFormat;
            }
        },
        {
            key: "elementUsage",
            get: function get() {
                return this._elementUsage;
            }
        }]);
        return VertexElement;
    } ();
    var BufferState =
    /*#__PURE__*/
    function(_Laya$BufferStateBase) {
        _inherits(BufferState, _Laya$BufferStateBase);
        var _super8 = _createSuper(BufferState);
        function BufferState() {
            _classCallCheck(this, BufferState);
            return _super8.call(this);
        }
        _createClass(BufferState, [{
            key: "applyVertexBuffer",
            value: function applyVertexBuffer(vertexBuffer) {
                if (Laya.BufferStateBase._curBindedBufferState === this) {
                    var gl = Laya.LayaGL.instance;
                    if (this.vertexDeclaration) {
                        var oriData = this.vertexDeclaration._shaderValues.getData();
                        for (var k in oriData) {
                            var _loc = parseInt(k);
                            gl.disableVertexAttribArray(_loc);
                        }
                    }
                    var verDec = vertexBuffer.vertexDeclaration;
                    var valueData = verDec._shaderValues.getData();
                    this.vertexDeclaration = verDec;
                    vertexBuffer.bind();
                    for (var k in valueData) {
                        var loc = parseInt(k);
                        var attribute = valueData[k];
                        gl.enableVertexAttribArray(loc);
                        gl.vertexAttribPointer(loc, attribute[0], attribute[1], !!attribute[2], attribute[3], attribute[4]);
                    }
                } else {
                    throw "BufferState: must call bind() function first.";
                }
            }
        },
        {
            key: "applyVertexBuffers",
            value: function applyVertexBuffers(vertexBuffers) {
                if (Laya.BufferStateBase._curBindedBufferState === this) {
                    var gl = Laya.LayaGL.instance;
                    for (var i = 0,
                    n = vertexBuffers.length; i < n; i++) {
                        var verBuf = vertexBuffers[i];
                        var verDec = verBuf.vertexDeclaration;
                        var valueData = verDec._shaderValues.getData();
                        verBuf.bind();
                        for (var k in valueData) {
                            var loc = parseInt(k);
                            var attribute = valueData[k];
                            gl.enableVertexAttribArray(loc);
                            gl.vertexAttribPointer(loc, attribute[0], attribute[1], !!attribute[2], attribute[3], attribute[4]);
                        }
                    }
                } else {
                    throw "BufferState: must call bind() function first.";
                }
            }
        },
        {
            key: "applyInstanceVertexBuffer",
            value: function applyInstanceVertexBuffer(vertexBuffer) {
                if (Laya.LayaGL.layaGPUInstance.supportInstance()) {
                    if (Laya.BufferStateBase._curBindedBufferState === this) {
                        var gl = Laya.LayaGL.instance;
                        var verDec = vertexBuffer.vertexDeclaration;
                        var valueData = verDec._shaderValues.getData();
                        vertexBuffer.bind();
                        for (var k in valueData) {
                            var loc = parseInt(k);
                            var attribute = valueData[k];
                            gl.enableVertexAttribArray(loc);
                            gl.vertexAttribPointer(loc, attribute[0], attribute[1], !!attribute[2], attribute[3], attribute[4]);
                            Laya.LayaGL.layaGPUInstance.vertexAttribDivisor(loc, 1);
                        }
                    } else {
                        throw "BufferState: must call bind() function first.";
                    }
                }
            }
        },
        {
            key: "applyIndexBuffer",
            value: function applyIndexBuffer(indexBuffer) {
                if (Laya.BufferStateBase._curBindedBufferState === this) {
                    if (this._bindedIndexBuffer !== indexBuffer) {
                        indexBuffer._bindForVAO();
                        this._bindedIndexBuffer = indexBuffer;
                    }
                } else {
                    throw "BufferState: must call bind() function first.";
                }
            }
        }]);
        return BufferState;
    } (Laya.BufferStateBase);
    var ScreenQuad =
    /*#__PURE__*/
    function(_Laya$Resource2) {
        _inherits(ScreenQuad, _Laya$Resource2);
        var _super9 = _createSuper(ScreenQuad);
        function ScreenQuad() {
            var _this8;
            _classCallCheck(this, ScreenQuad);
            _this8 = _super9.call(this);
            _this8._bufferState = new BufferState();
            _this8._bufferStateInvertUV = new BufferState();
            var gl = Laya.LayaGL.instance;
            _this8._vertexBuffer = new VertexBuffer3D(16 * 4, gl.STATIC_DRAW, false);
            _this8._vertexBuffer.vertexDeclaration = ScreenQuad._vertexDeclaration;
            _this8._vertexBuffer.setData(ScreenQuad._vertices.buffer);
            _this8._bufferState.bind();
            _this8._bufferState.applyVertexBuffer(_this8._vertexBuffer);
            _this8._bufferState.unBind();
            _this8._vertexBufferInvertUV = new VertexBuffer3D(16 * 4, gl.STATIC_DRAW, false);
            _this8._vertexBufferInvertUV.vertexDeclaration = ScreenQuad._vertexDeclaration;
            _this8._vertexBufferInvertUV.setData(ScreenQuad._verticesInvertUV.buffer);
            _this8._bufferStateInvertUV.bind();
            _this8._bufferStateInvertUV.applyVertexBuffer(_this8._vertexBufferInvertUV);
            _this8._bufferStateInvertUV.unBind();
            _this8._setGPUMemory(_this8._vertexBuffer._byteLength + _this8._vertexBufferInvertUV._byteLength);
            return _this8;
        }
        _createClass(ScreenQuad, [{
            key: "render",
            value: function render() {
                var gl = Laya.LayaGL.instance;
                this._bufferState.bind();
                gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);
                Laya.Stat.renderBatches++;
            }
        },
        {
            key: "renderInvertUV",
            value: function renderInvertUV() {
                var gl = Laya.LayaGL.instance;
                this._bufferStateInvertUV.bind();
                gl.drawArrays(gl.TRIANGLE_STRIP, 0, 4);
                Laya.Stat.renderBatches++;
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                _get(_getPrototypeOf(ScreenQuad.prototype), "destroy", this).call(this);
                this._bufferState.destroy();
                this._vertexBuffer.destroy();
                this._bufferStateInvertUV.destroy();
                this._vertexBufferInvertUV.destroy();
                this._setGPUMemory(0);
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                ScreenQuad._vertexDeclaration = new VertexDeclaration(16, [new VertexElement(0, VertexElementFormat.Vector4, ScreenQuad.SCREENQUAD_POSITION_UV)]);
                ScreenQuad.instance = new ScreenQuad();
                ScreenQuad.instance.lock = true;
            }
        }]);
        return ScreenQuad;
    } (Laya.Resource);
    ScreenQuad.SCREENQUAD_POSITION_UV = 0;
    ScreenQuad._vertices = new Float32Array([1, 1, 1, 1, 1, -1, 1, 0, -1, 1, 0, 1, -1, -1, 0, 0]);
    ScreenQuad._verticesInvertUV = new Float32Array([1, 1, 1, 0, 1, -1, 1, 1, -1, 1, 0, 0, -1, -1, 0, 1]);
    var ScreenTriangle =
    /*#__PURE__*/
    function(_Laya$Resource3) {
        _inherits(ScreenTriangle, _Laya$Resource3);
        var _super10 = _createSuper(ScreenTriangle);
        function ScreenTriangle() {
            var _this9;
            _classCallCheck(this, ScreenTriangle);
            _this9 = _super10.call(this);
            _this9._bufferState = new BufferState();
            _this9._bufferStateInvertUV = new BufferState();
            var gl = Laya.LayaGL.instance;
            _this9._vertexBuffer = new VertexBuffer3D(12 * 4, gl.STATIC_DRAW, false);
            _this9._vertexBuffer.vertexDeclaration = ScreenTriangle._vertexDeclaration;
            _this9._vertexBuffer.setData(ScreenTriangle._vertices.buffer);
            _this9._bufferState.bind();
            _this9._bufferState.applyVertexBuffer(_this9._vertexBuffer);
            _this9._bufferState.unBind();
            _this9._vertexBufferInvertUV = new VertexBuffer3D(12 * 4, gl.STATIC_DRAW, false);
            _this9._vertexBufferInvertUV.vertexDeclaration = ScreenTriangle._vertexDeclaration;
            _this9._vertexBufferInvertUV.setData(ScreenTriangle._verticesInvertUV.buffer);
            _this9._bufferStateInvertUV.bind();
            _this9._bufferStateInvertUV.applyVertexBuffer(_this9._vertexBufferInvertUV);
            _this9._bufferStateInvertUV.unBind();
            _this9._setGPUMemory(_this9._vertexBuffer._byteLength + _this9._vertexBufferInvertUV._byteLength);
            return _this9;
        }
        _createClass(ScreenTriangle, [{
            key: "render",
            value: function render() {
                var gl = Laya.LayaGL.instance;
                this._bufferState.bind();
                gl.drawArrays(gl.TRIANGLES, 0, 3);
                Laya.Stat.renderBatches++;
            }
        },
        {
            key: "renderInvertUV",
            value: function renderInvertUV() {
                var gl = Laya.LayaGL.instance;
                this._bufferStateInvertUV.bind();
                gl.drawArrays(gl.TRIANGLES, 0, 3);
                Laya.Stat.renderBatches++;
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                _get(_getPrototypeOf(ScreenTriangle.prototype), "destroy", this).call(this);
                this._bufferState.destroy();
                this._vertexBuffer.destroy();
                this._bufferStateInvertUV.destroy();
                this._vertexBufferInvertUV.destroy();
                this._setGPUMemory(0);
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                ScreenTriangle._vertexDeclaration = new VertexDeclaration(16, [new VertexElement(0, VertexElementFormat.Vector4, ScreenTriangle.SCREENTRIANGLE_POSITION_UV)]);
                ScreenTriangle.instance = new ScreenTriangle();
                ScreenTriangle.instance.lock = true;
            }
        }]);
        return ScreenTriangle;
    } (Laya.Resource);
    ScreenTriangle.SCREENTRIANGLE_POSITION_UV = 0;
    ScreenTriangle._vertices = new Float32Array([ - 1, -1, 0, 0, -1, 3, 0, 2, 3, -1, 2, 0]);
    ScreenTriangle._verticesInvertUV = new Float32Array([ - 1, -1, 0, 1, -1, 3, 0, -1, 3, -1, 2, 1]);
    var ShaderDefine =
    /*#__PURE__*/
    _createClass(function ShaderDefine(index, value) {
        _classCallCheck(this, ShaderDefine);
        this._index = index;
        this._value = value;
    });
    var ShaderVariant =
    /*#__PURE__*/
    function() {
        function ShaderVariant(shader, subShaderIndex, passIndex, defines) {
            _classCallCheck(this, ShaderVariant);
            this._subShaderIndex = 0;
            this._passIndex = 0;
            this.setValue(shader, subShaderIndex, passIndex, defines);
        }
        _createClass(ShaderVariant, [{
            key: "shader",
            get: function get() {
                return this._shader;
            }
        },
        {
            key: "subShaderIndex",
            get: function get() {
                return this._subShaderIndex;
            }
        },
        {
            key: "passIndex",
            get: function get() {
                return this._passIndex;
            }
        },
        {
            key: "defineNames",
            get: function get() {
                return this._defineNames;
            }
        },
        {
            key: "setValue",
            value: function setValue(shader, subShaderIndex, passIndex, defineNames) {
                if (shader) {
                    var subShader = shader.getSubShaderAt(subShaderIndex);
                    if (subShader) {
                        var pass = subShader._passes[passIndex];
                        if (pass) {
                            var validDefine = pass._validDefine;
                            for (var i = 0,
                            n = defineNames.length; i < n; i++) {
                                var defname = defineNames[i];
                                if (!validDefine.has(ILaya3D.Shader3D.getDefineByName(defname))) throw "ShaderVariantInfo:Invalid defineName ".concat(defname, " in ").concat(shader._name, " subShaderIndex of ").concat(subShaderIndex, " passIndex of ").concat(passIndex, ".");
                            }
                        } else {
                            throw "ShaderVariantInfo:Shader don't have passIndex of ".concat(passIndex, ".");
                        }
                    } else {
                        throw "ShaderVariantInfo:Shader don't have subShaderIndex of ".concat(subShaderIndex, ".");
                    }
                } else {
                    throw "ShaderVariantInfo:Shader can't be null.";
                }
                this._shader = shader;
                this._subShaderIndex = subShaderIndex;
                this._passIndex = passIndex;
                this._defineNames = defineNames;
            }
        },
        {
            key: "equal",
            value: function equal(other) {
                if (this._shader !== other._shader || this._subShaderIndex !== other._subShaderIndex || this._passIndex !== other._passIndex) return false;
                var defines = this._defineNames;
                var otherDefines = other._defineNames;
                if (defines.length !== otherDefines.length) return false;
                for (var i = 0,
                n = this._defineNames.length; i < n; i++) {
                    if (defines[i] !== otherDefines[i]) return false;
                }
                return true;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new ShaderVariant(this._shader, this._subShaderIndex, this._passIndex, this._defineNames.slice());
                return dest;
            }
        }]);
        return ShaderVariant;
    } ();
    var ShaderVariantCollection =
    /*#__PURE__*/
    function() {
        function ShaderVariantCollection() {
            _classCallCheck(this, ShaderVariantCollection);
            this._allCompiled = false;
            this._variants = [];
        }
        _createClass(ShaderVariantCollection, [{
            key: "allCompiled",
            get: function get() {
                return this._allCompiled;
            }
        },
        {
            key: "variantCount",
            get: function get() {
                return this._variants.length;
            }
        },
        {
            key: "add",
            value: function add(variant) {
                for (var i = 0,
                n = this._variants.length; i < n; i++) {
                    if (this._variants[i].equal(variant)) return false;
                }
                this._variants.push(variant.clone());
                this._allCompiled = false;
                return true;
            }
        },
        {
            key: "remove",
            value: function remove(variant) {
                for (var i = 0,
                n = this._variants.length; i < n; i++) {
                    if (this._variants[i].equal(variant)) {
                        this._variants.splice(i, 1);
                        return true;
                    }
                }
                return false;
            }
        },
        {
            key: "contatins",
            value: function contatins(variant) {
                for (var i = 0,
                n = this._variants.length; i < n; i++) {
                    if (this._variants[i].equal(variant)) return true;
                }
                return false;
            }
        },
        {
            key: "getByIndex",
            value: function getByIndex(index) {
                return this._variants[index];
            }
        },
        {
            key: "clear",
            value: function clear() {
                this._variants.length = 0;
            }
        },
        {
            key: "compile",
            value: function compile() {
                if (!this._allCompiled) {
                    var variants = this._variants;
                    for (var i = 0,
                    n = variants.length; i < n; i++) {
                        var variant = variants[i];
                        ILaya3D.Shader3D.compileShaderByDefineNames(variant._shader._name, variant._subShaderIndex, variant._passIndex, variant._defineNames);
                    }
                    this._allCompiled = true;
                }
            }
        }]);
        return ShaderVariantCollection;
    } ();
    var Shader3D =
    /*#__PURE__*/
    function() {
        function Shader3D(name, attributeMap, uniformMap, enableInstancing, supportReflectionProbe) {
            _classCallCheck(this, Shader3D);
            this._attributeMap = null;
            this._uniformMap = null;
            this._enableInstancing = false;
            this._supportReflectionProbe = false;
            this._subShaders = [];
            this._name = name;
            this._attributeMap = attributeMap;
            this._uniformMap = uniformMap;
            this._enableInstancing = enableInstancing;
            this._supportReflectionProbe = supportReflectionProbe;
        }
        _createClass(Shader3D, [{
            key: "name",
            get: function get() {
                return this._name;
            }
        },
        {
            key: "addSubShader",
            value: function addSubShader(subShader) {
                this._subShaders.push(subShader);
                subShader._owner = this;
            }
        },
        {
            key: "getSubShaderAt",
            value: function getSubShaderAt(index) {
                return this._subShaders[index];
            }
        }], [{
            key: "_getNamesByDefineData",
            value: function _getNamesByDefineData(defineData, out) {
                var maskMap = Shader3D._maskMap;
                var mask = defineData._mask;
                out.length = 0;
                for (var i = 0,
                n = defineData._length; i < n; i++) {
                    var subMaskMap = maskMap[i];
                    var subMask = mask[i];
                    for (var j = 0; j < 32; j++) {
                        var d = 1 << j;
                        if (subMask > 0 && d > subMask) break;
                        if (subMask & d) out.push(subMaskMap[d]);
                    }
                }
            }
        },
        {
            key: "getDefineByName",
            value: function getDefineByName(name) {
                var define = Shader3D._defineMap[name];
                if (!define) {
                    var maskMap = Shader3D._maskMap;
                    var counter = Shader3D._defineCounter;
                    var index = Math.floor(counter / 32);
                    var value = 1 << counter % 32;
                    define = new ShaderDefine(index, value);
                    Shader3D._defineMap[name] = define;
                    if (index == maskMap.length) {
                        maskMap.length++;
                        maskMap[index] = {};
                    }
                    maskMap[index][value] = name;
                    Shader3D._defineCounter++;
                }
                return define;
            }
        },
        {
            key: "propertyNameToID",
            value: function propertyNameToID(name) {
                if (Shader3D._propertyNameMap[name] != null) {
                    return Shader3D._propertyNameMap[name];
                } else {
                    var id = Shader3D._propertyNameCounter++;
                    Shader3D._propertyNameMap[name] = id;
                    Shader3D._propertyNameMap[id] = name;
                    return id;
                }
            }
        },
        {
            key: "addInclude",
            value: function addInclude(fileName, txt) {
                txt = txt.replace(Laya.ShaderCompile._clearCR, "");
                Laya.ShaderCompile.addInclude(fileName, txt);
            }
        },
        {
            key: "compileShaderByDefineNames",
            value: function compileShaderByDefineNames(shaderName, subShaderIndex, passIndex, defineNames) {
                var shader = Shader3D.find(shaderName);
                if (shader) {
                    var subShader = shader.getSubShaderAt(subShaderIndex);
                    if (subShader) {
                        var pass = subShader._passes[passIndex];
                        if (pass) {
                            var compileDefineDatas = Shader3D._compileDefineDatas;
                            compileDefineDatas.clear();
                            for (var i = 0,
                            n = defineNames.length; i < n; i++) {
                                compileDefineDatas.add(Shader3D.getDefineByName(defineNames[i]));
                            }
                            pass.withCompile(compileDefineDatas);
                        } else {
                            console.warn("Shader3D: unknown passIndex.");
                        }
                    } else {
                        console.warn("Shader3D: unknown subShaderIndex.");
                    }
                } else {
                    console.warn("Shader3D: unknown shader name.");
                }
            }
        },
        {
            key: "add",
            value: function add(name) {
                var attributeMap = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var uniformMap = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var enableInstancing = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                var supportReflectionProbe = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
                return Shader3D._preCompileShader[name] = new Shader3D(name, attributeMap, uniformMap, enableInstancing, supportReflectionProbe);
            }
        },
        {
            key: "find",
            value: function find(name) {
                return Shader3D._preCompileShader[name];
            }
        },
        {
            key: "compileShader",
            value: function compileShader(shaderName, subShaderIndex, passIndex) {
                var shader = Shader3D.find(shaderName);
                if (shader) {
                    var subShader = shader.getSubShaderAt(subShaderIndex);
                    if (subShader) {
                        var pass = subShader._passes[passIndex];
                        if (pass) {
                            var compileDefineDatas = Shader3D._compileDefineDatas;
                            var mask = compileDefineDatas._mask;
                            mask.length = 0;
                            for (var i = 0,
                            n = arguments.length <= 3 ? 0 : arguments.length - 3; i < n; i++) {
                                mask.push(i + 3 < 3 || arguments.length <= i + 3 ? undefined: arguments[i + 3]);
                            }
                            compileDefineDatas._length = arguments.length <= 3 ? 0 : arguments.length - 3;
                            pass.withCompile(compileDefineDatas);
                        } else {
                            console.warn("Shader3D: unknown passIndex.");
                        }
                    } else {
                        console.warn("Shader3D: unknown subShaderIndex.");
                    }
                } else {
                    console.warn("Shader3D: unknown shader name.");
                }
            }
        }]);
        return Shader3D;
    } ();
    Shader3D._compileDefineDatas = new DefineDatas();
    Shader3D.RENDER_STATE_CULL = 0;
    Shader3D.RENDER_STATE_BLEND = 1;
    Shader3D.RENDER_STATE_BLEND_SRC = 2;
    Shader3D.RENDER_STATE_BLEND_DST = 3;
    Shader3D.RENDER_STATE_BLEND_SRC_RGB = 4;
    Shader3D.RENDER_STATE_BLEND_DST_RGB = 5;
    Shader3D.RENDER_STATE_BLEND_SRC_ALPHA = 6;
    Shader3D.RENDER_STATE_BLEND_DST_ALPHA = 7;
    Shader3D.RENDER_STATE_BLEND_CONST_COLOR = 8;
    Shader3D.RENDER_STATE_BLEND_EQUATION = 9;
    Shader3D.RENDER_STATE_BLEND_EQUATION_RGB = 10;
    Shader3D.RENDER_STATE_BLEND_EQUATION_ALPHA = 11;
    Shader3D.RENDER_STATE_DEPTH_TEST = 12;
    Shader3D.RENDER_STATE_DEPTH_WRITE = 13;
    Shader3D.RENDER_STATE_STENCIL_TEST = 14;
    Shader3D.RENDER_STATE_STENCIL_WRITE = 15;
    Shader3D.RENDER_STATE_STENCIL_REF = 16;
    Shader3D.RENDER_STATE_STENCIL_OP = 17;
    Shader3D.PERIOD_CUSTOM = 0;
    Shader3D.PERIOD_MATERIAL = 1;
    Shader3D.PERIOD_SPRITE = 2;
    Shader3D.PERIOD_CAMERA = 3;
    Shader3D.PERIOD_SCENE = 4;
    Shader3D._propertyNameMap = {};
    Shader3D._propertyNameCounter = 0;
    Shader3D._defineCounter = 0;
    Shader3D._defineMap = {};
    Shader3D._preCompileShader = {};
    Shader3D._maskMap = [];
    Shader3D.debugMode = false;
    Shader3D.debugShaderVariantCollection = new ShaderVariantCollection();
    var Command =
    /*#__PURE__*/
    function() {
        function Command() {
            _classCallCheck(this, Command);
            this._commandBuffer = null;
        }
        _createClass(Command, [{
            key: "run",
            value: function run() {}
        },
        {
            key: "recover",
            value: function recover() {
                this._commandBuffer = null;
            }
        },
        {
            key: "setContext",
            value: function setContext(context) {
                this._context = context;
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                Command._screenShaderData = new ShaderData();
                Command._screenShader = Shader3D.find("BlitScreen");
            }
        }]);
        return Command;
    } ();
    Command.SCREENTEXTURE_NAME = "u_MainTex";
    Command.SCREENTEXTUREOFFSETSCALE_NAME = "u_OffsetScale";
    Command.MAINTEXTURE_TEXELSIZE_NAME = "u_MainTex_TexelSize";
    Command.SCREENTEXTURE_ID = Shader3D.propertyNameToID(Command.SCREENTEXTURE_NAME);
    Command.SCREENTEXTUREOFFSETSCALE_ID = Shader3D.propertyNameToID(Command.SCREENTEXTUREOFFSETSCALE_NAME);
    Command.MAINTEXTURE_TEXELSIZE_ID = Shader3D.propertyNameToID(Command.MAINTEXTURE_TEXELSIZE_NAME);
    var BlitScreenQuadCMD =
    /*#__PURE__*/
    function(_Command) {
        _inherits(BlitScreenQuadCMD, _Command);
        var _super11 = _createSuper(BlitScreenQuadCMD);
        function BlitScreenQuadCMD() {
            var _this10;
            _classCallCheck(this, BlitScreenQuadCMD);
            _this10 = _super11.apply(this, arguments);
            _this10._source = null;
            _this10._dest = null;
            _this10._offsetScale = null;
            _this10._shader = null;
            _this10._shaderData = null;
            _this10._subShader = 0;
            _this10._sourceTexelSize = new Vector4();
            _this10._screenType = 0;
            _this10._drawDefineCavans = false;
            return _this10;
        }
        _createClass(BlitScreenQuadCMD, [{
            key: "run",
            value: function run() {
                var source;
                if (!this._source) {
                    if (!this._commandBuffer._camera._internalRenderTexture) throw "camera internalRenderTexture is null,please set camera enableBuiltInRenderTexture";
                    source = this._commandBuffer._camera._internalRenderTexture;
                } else source = this._source;
                var shader = this._shader || Command._screenShader;
                var shaderData = this._shaderData || Command._screenShaderData;
                var dest = this._dest ? this._dest: this._drawDefineCavans ? this._dest: this._commandBuffer._camera._internalRenderTexture;
                if (dest) {
                    Laya.LayaGL.instance.viewport(0, 0, dest.width, dest.height);
                    Laya.LayaGL.instance.scissor(0, 0, dest.width, dest.height);
                } else {
                    var camera = this._commandBuffer._camera;
                    var viewport = camera.viewport;
                    var vpH = viewport.height;
                    var vpY = RenderContext3D.clientHeight - viewport.y - vpH;
                    Laya.LayaGL.instance.viewport(viewport.x, vpY, viewport.width, vpH);
                    Laya.LayaGL.instance.scissor(viewport.x, vpY, viewport.width, vpH);
                }
                shaderData.setTexture(Command.SCREENTEXTURE_ID, source);
                shaderData.setVector(Command.SCREENTEXTUREOFFSETSCALE_ID, this._offsetScale || BlitScreenQuadCMD._defaultOffsetScale);
                this._sourceTexelSize.setValue(1.0 / source.width, 1.0 / source.height, source.width, source.height);
                shaderData.setVector(Command.MAINTEXTURE_TEXELSIZE_ID, this._sourceTexelSize);
                RenderTexture.currentActive && RenderTexture.currentActive._end();
                dest && dest._start();
                this._commandBuffer && this.setContext(this._commandBuffer._context);
                var context = this._context;
                var currentPipelineMode = context.pipelineMode;
                var subShader = shader.getSubShaderAt(this._subShader);
                var passes = subShader._passes;
                for (var i = 0,
                n = passes.length; i < n; i++) {
                    var pass = passes[i];
                    if (pass._pipelineMode !== currentPipelineMode) continue;
                    var comDef = BlitScreenQuadCMD._compileDefine;
                    shaderData._defineDatas.cloneTo(comDef);
                    var shaderPass = passes[i].withCompile(comDef);
                    shaderPass.bind();
                    shaderPass.uploadUniforms(shaderPass._materialUniformParamsMap, shaderData, true);
                    shaderPass.uploadRenderStateBlendDepth(shaderData);
                    shaderPass.uploadRenderStateFrontFace(shaderData, false, null);
                    switch (this._screenType) {
                    case BlitScreenQuadCMD._SCREENTYPE_QUAD:
                        RenderContext3D._instance.invertY ? ScreenQuad.instance.renderInvertUV() : ScreenQuad.instance.render();
                        break;
                    case BlitScreenQuadCMD._SCREENTYPE_TRIANGLE:
                        RenderContext3D._instance.invertY ? ScreenTriangle.instance.renderInvertUV() : ScreenTriangle.instance.render();
                        break;
                    default:
                        throw "BlitScreenQuadCMD:unknown screen Type.";
                    }
                }
                dest && dest._end();
            }
        },
        {
            key: "recover",
            value: function recover() {
                BlitScreenQuadCMD._pool.push(this);
                this._source = null;
                this._dest = null;
                this._offsetScale = null;
                this._shader = null;
                this._shaderData = null;
                this._drawDefineCavans = false;
                _get(_getPrototypeOf(BlitScreenQuadCMD.prototype), "recover", this).call(this);
            }
        }], [{
            key: "create",
            value: function create(source, dest) {
                var offsetScale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var shader = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var shaderData = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                var subShader = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                var screenType = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : BlitScreenQuadCMD._SCREENTYPE_QUAD;
                var commandbuffer = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
                var definedCanvas = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : false;
                var cmd;
                cmd = BlitScreenQuadCMD._pool.length > 0 ? BlitScreenQuadCMD._pool.pop() : new BlitScreenQuadCMD();
                cmd._source = source;
                cmd._dest = dest;
                cmd._offsetScale = offsetScale;
                cmd._shader = shader;
                cmd._shaderData = shaderData;
                cmd._subShader = subShader;
                cmd._screenType = screenType;
                cmd._commandBuffer = commandbuffer;
                cmd._drawDefineCavans = definedCanvas;
                return cmd;
            }
        }]);
        return BlitScreenQuadCMD;
    } (Command);
    BlitScreenQuadCMD._SCREENTYPE_QUAD = 0;
    BlitScreenQuadCMD._SCREENTYPE_TRIANGLE = 1;
    BlitScreenQuadCMD._compileDefine = new DefineDatas();
    BlitScreenQuadCMD._pool = [];
    BlitScreenQuadCMD._defaultOffsetScale = new Vector4(0, 0, 1, 1);
    var SetRenderTargetCMD =
    /*#__PURE__*/
    function(_Command2) {
        _inherits(SetRenderTargetCMD, _Command2);
        var _super12 = _createSuper(SetRenderTargetCMD);
        function SetRenderTargetCMD() {
            var _this11;
            _classCallCheck(this, SetRenderTargetCMD);
            _this11 = _super12.apply(this, arguments);
            _this11._renderTexture = null;
            return _this11;
        }
        _createClass(SetRenderTargetCMD, [{
            key: "run",
            value: function run() {
                RenderTexture.currentActive && RenderTexture.currentActive._end();
                Laya.LayaGL.instance.viewport(0, 0, this._renderTexture.width, this._renderTexture.height);
                this._renderTexture._start();
            }
        },
        {
            key: "recover",
            value: function recover() {
                SetRenderTargetCMD._pool.push(this);
                this._renderTexture = null;
            }
        }], [{
            key: "create",
            value: function create(renderTexture) {
                var cmd;
                cmd = SetRenderTargetCMD._pool.length > 0 ? SetRenderTargetCMD._pool.pop() : new SetRenderTargetCMD();
                cmd._renderTexture = renderTexture;
                return cmd;
            }
        }]);
        return SetRenderTargetCMD;
    } (Command);
    SetRenderTargetCMD._pool = []; (function(ShaderDataType) {
        ShaderDataType[ShaderDataType["Int"] = 0] = "Int";
        ShaderDataType[ShaderDataType["Bool"] = 1] = "Bool";
        ShaderDataType[ShaderDataType["Number"] = 2] = "Number";
        ShaderDataType[ShaderDataType["Vector2"] = 3] = "Vector2";
        ShaderDataType[ShaderDataType["Vector3"] = 4] = "Vector3";
        ShaderDataType[ShaderDataType["Vector4"] = 5] = "Vector4";
        ShaderDataType[ShaderDataType["Quaternion"] = 6] = "Quaternion";
        ShaderDataType[ShaderDataType["Matrix4x4"] = 7] = "Matrix4x4";
        ShaderDataType[ShaderDataType["Buffer"] = 8] = "Buffer";
        ShaderDataType[ShaderDataType["Texture"] = 9] = "Texture";
        ShaderDataType[ShaderDataType["ShaderDefine"] = 10] = "ShaderDefine";
    })(exports.ShaderDataType || (exports.ShaderDataType = {}));
    var SetShaderDataCMD =
    /*#__PURE__*/
    function(_Command3) {
        _inherits(SetShaderDataCMD, _Command3);
        var _super13 = _createSuper(SetShaderDataCMD);
        function SetShaderDataCMD() {
            var _this12;
            _classCallCheck(this, SetShaderDataCMD);
            _this12 = _super13.apply(this, arguments);
            _this12._shaderData = null;
            _this12._nameID = 0;
            _this12._value = null;
            _this12._dataType = -1;
            return _this12;
        }
        _createClass(SetShaderDataCMD, [{
            key: "run",
            value: function run() {
                switch (this._dataType) {
                case exports.ShaderDataType.Int:
                    this._shaderData.setInt(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Number:
                    this._shaderData.setNumber(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Bool:
                    this._shaderData.setBool(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Matrix4x4:
                    this._shaderData.setMatrix4x4(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Quaternion:
                    this._shaderData.setQuaternion(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Texture:
                    this._shaderData.setTexture(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector4:
                    this._shaderData.setVector(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector2:
                    this._shaderData.setVector2(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector3:
                    this._shaderData.setVector3(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Buffer:
                    this._shaderData.setBuffer(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.ShaderDefine:
                    var defineData = Shader3D.getDefineByName(this._nameID);
                    if (this._value) this._shaderData.addDefine(defineData);
                    else this._shaderData.removeDefine(defineData);
                    break;
                default:
                    throw "no type shaderValue on this CommendBuffer";
                }
            }
        },
        {
            key: "recover",
            value: function recover() {
                SetShaderDataCMD._pool.push(this);
                this._shaderData = null;
                this._nameID = 0;
                this._value = null;
                this._dataType = -1;
            }
        }], [{
            key: "create",
            value: function create(shaderData, nameID, value, shaderDataType, commandBuffer) {
                var cmd;
                cmd = SetShaderDataCMD._pool.length > 0 ? SetShaderDataCMD._pool.pop() : new SetShaderDataCMD();
                cmd._shaderData = shaderData;
                cmd._nameID = nameID;
                cmd._value = value;
                cmd._dataType = shaderDataType;
                cmd._commandBuffer = commandBuffer;
                return cmd;
            }
        }]);
        return SetShaderDataCMD;
    } (Command);
    SetShaderDataCMD._pool = [];
    var Transform3D =
    /*#__PURE__*/
    function(_Laya$EventDispatcher) {
        _inherits(Transform3D, _Laya$EventDispatcher);
        var _super14 = _createSuper(Transform3D);
        function Transform3D(owner) {
            var _this13;
            _classCallCheck(this, Transform3D);
            _this13 = _super14.call(this);
            _this13._localPosition = new Vector3(0, 0, 0);
            _this13._localRotation = new Quaternion(0, 0, 0, 1);
            _this13._localScale = new Vector3(1, 1, 1);
            _this13._localRotationEuler = new Vector3(0, 0, 0);
            _this13._localMatrix = new Matrix4x4();
            _this13._position = new Vector3(0, 0, 0);
            _this13._rotation = new Quaternion(0, 0, 0, 1);
            _this13._scale = new Vector3(1, 1, 1);
            _this13._rotationEuler = new Vector3(0, 0, 0);
            _this13._worldMatrix = new Matrix4x4();
            _this13._children = null;
            _this13._isDefaultMatrix = false;
            _this13._parent = null;
            _this13._dummy = null;
            _this13._transformFlag = 0;
            _this13._owner = owner;
            _this13._children = [];
            _this13._setTransformFlag(Transform3D.TRANSFORM_LOCALQUATERNION | Transform3D.TRANSFORM_LOCALEULER | Transform3D.TRANSFORM_LOCALMATRIX, false);
            _this13._setTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION | Transform3D.TRANSFORM_WORLDQUATERNION | Transform3D.TRANSFORM_WORLDEULER | Transform3D.TRANSFORM_WORLDSCALE | Transform3D.TRANSFORM_WORLDMATRIX, true);
            return _this13;
        }
        _createClass(Transform3D, [{
            key: "isDefaultMatrix",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX)) {
                    var localMat = this.localMatrix;
                }
                return this._isDefaultMatrix;
            }
        },
        {
            key: "_isFrontFaceInvert",
            get: function get() {
                var scale = this.getWorldLossyScale();
                var isInvert = scale.x < 0;
                scale.y < 0 && (isInvert = !isInvert);
                scale.z < 0 && (isInvert = !isInvert);
                return isInvert;
            }
        },
        {
            key: "owner",
            get: function get() {
                return this._owner;
            }
        },
        {
            key: "worldNeedUpdate",
            get: function get() {
                return this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX);
            }
        },
        {
            key: "localPositionX",
            get: function get() {
                return this._localPosition.x;
            },
            set: function set(x) {
                this._localPosition.x = x;
                this.localPosition = this._localPosition;
            }
        },
        {
            key: "localPositionY",
            get: function get() {
                return this._localPosition.y;
            },
            set: function set(y) {
                this._localPosition.y = y;
                this.localPosition = this._localPosition;
            }
        },
        {
            key: "localPositionZ",
            get: function get() {
                return this._localPosition.z;
            },
            set: function set(z) {
                this._localPosition.z = z;
                this.localPosition = this._localPosition;
            }
        },
        {
            key: "localPosition",
            get: function get() {
                return this._localPosition;
            },
            set: function set(value) {
                if (this._localPosition !== value) value.cloneTo(this._localPosition);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX, true);
                this._onWorldPositionTransform();
            }
        },
        {
            key: "localRotationX",
            get: function get() {
                return this.localRotation.x;
            },
            set: function set(x) {
                var rot = this.localRotation;
                rot.x = x;
                this.localRotation = rot;
            }
        },
        {
            key: "localRotationY",
            get: function get() {
                return this.localRotation.y;
            },
            set: function set(y) {
                var rot = this.localRotation;
                rot.y = y;
                this.localRotation = rot;
            }
        },
        {
            key: "localRotationZ",
            get: function get() {
                return this.localRotation.z;
            },
            set: function set(z) {
                var rot = this.localRotation;
                rot.z = z;
                this.localRotation = rot;
            }
        },
        {
            key: "localRotationW",
            get: function get() {
                return this.localRotation.w;
            },
            set: function set(w) {
                var rot = this.localRotation;
                rot.w = w;
                this.localRotation = rot;
            }
        },
        {
            key: "localRotation",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_LOCALQUATERNION)) {
                    var eulerE = this._localRotationEuler;
                    Quaternion.createFromYawPitchRoll(eulerE.y / Transform3D._angleToRandin, eulerE.x / Transform3D._angleToRandin, eulerE.z / Transform3D._angleToRandin, this._localRotation);
                    this._setTransformFlag(Transform3D.TRANSFORM_LOCALQUATERNION, false);
                }
                return this._localRotation;
            },
            set: function set(value) {
                if (this._localRotation !== value) value.cloneTo(this._localRotation);
                this._localRotation.normalize(this._localRotation);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALEULER | Transform3D.TRANSFORM_LOCALMATRIX, true);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALQUATERNION, false);
                this._onWorldRotationTransform();
            }
        },
        {
            key: "localScaleX",
            get: function get() {
                return this._localScale.x;
            },
            set: function set(value) {
                this._localScale.x = value;
                this.localScale = this._localScale;
            }
        },
        {
            key: "localScaleY",
            get: function get() {
                return this._localScale.y;
            },
            set: function set(value) {
                this._localScale.y = value;
                this.localScale = this._localScale;
            }
        },
        {
            key: "localScaleZ",
            get: function get() {
                return this._localScale.z;
            },
            set: function set(value) {
                this._localScale.z = value;
                this.localScale = this._localScale;
            }
        },
        {
            key: "localScale",
            get: function get() {
                return this._localScale;
            },
            set: function set(value) {
                if (this._localScale !== value) value.cloneTo(this._localScale);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX, true);
                this._onWorldScaleTransform();
            }
        },
        {
            key: "localRotationEulerX",
            get: function get() {
                return this.localRotationEuler.x;
            },
            set: function set(value) {
                var rot = this.localRotationEuler;
                rot.x = value;
                this.localRotationEuler = rot;
            }
        },
        {
            key: "localRotationEulerY",
            get: function get() {
                return this.localRotationEuler.y;
            },
            set: function set(value) {
                var rot = this.localRotationEuler;
                rot.y = value;
                this.localRotationEuler = rot;
            }
        },
        {
            key: "localRotationEulerZ",
            get: function get() {
                return this.localRotationEuler.z;
            },
            set: function set(value) {
                var rot = this.localRotationEuler;
                rot.z = value;
                this.localRotationEuler = rot;
            }
        },
        {
            key: "localRotationEuler",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_LOCALEULER)) {
                    this._localRotation.getYawPitchRoll(Transform3D._tempVector30);
                    var euler = Transform3D._tempVector30;
                    var localRotationEuler = this._localRotationEuler;
                    localRotationEuler.x = euler.y * Transform3D._angleToRandin;
                    localRotationEuler.y = euler.x * Transform3D._angleToRandin;
                    localRotationEuler.z = euler.z * Transform3D._angleToRandin;
                    this._setTransformFlag(Transform3D.TRANSFORM_LOCALEULER, false);
                }
                return this._localRotationEuler;
            },
            set: function set(value) {
                if (this._localRotationEuler !== value) value.cloneTo(this._localRotationEuler);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALEULER, false);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALQUATERNION | Transform3D.TRANSFORM_LOCALMATRIX, true);
                this._onWorldRotationTransform();
            }
        },
        {
            key: "localMatrix",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX)) {
                    Matrix4x4.createAffineTransformation(this._localPosition, this.localRotation, this._localScale, this._localMatrix);
                    this._isDefaultMatrix = this._localMatrix.isIdentity();
                    this._setTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX, false);
                }
                return this._localMatrix;
            },
            set: function set(value) {
                if (this._localMatrix !== value) value.cloneTo(this._localMatrix);
                this._isDefaultMatrix = this._localMatrix.isIdentity();
                this._localMatrix.decomposeTransRotScale(this._localPosition, this._localRotation, this._localScale);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALEULER, true);
                this._setTransformFlag(Transform3D.TRANSFORM_LOCALMATRIX, false);
                this._onWorldTransform();
            }
        },
        {
            key: "position",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION)) {
                    if (this._parent != null) {
                        var worldMatE = this.worldMatrix.elements;
                        this._position.x = worldMatE[12];
                        this._position.y = worldMatE[13];
                        this._position.z = worldMatE[14];
                    } else {
                        this._localPosition.cloneTo(this._position);
                    }
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION, false);
                }
                return this._position;
            },
            set: function set(value) {
                if (this._parent != null) {
                    var parentInvMat = Transform3D._tempMatrix0;
                    this._parent.worldMatrix.invert(parentInvMat);
                    Vector3.transformCoordinate(value, parentInvMat, this._localPosition);
                } else {
                    value.cloneTo(this._localPosition);
                }
                this.localPosition = this._localPosition;
                if (this._position !== value) value.cloneTo(this._position);
                this._setTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION, false);
            }
        },
        {
            key: "rotation",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION)) {
                    if (this._parent != null) Quaternion.multiply(this._parent.rotation, this.localRotation, this._rotation);
                    else this.localRotation.cloneTo(this._rotation);
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION, false);
                }
                return this._rotation;
            },
            set: function set(value) {
                if (this._parent != null) {
                    this._parent.rotation.invert(Transform3D._tempQuaternion0);
                    Quaternion.multiply(Transform3D._tempQuaternion0, value, this._localRotation);
                } else {
                    value.cloneTo(this._localRotation);
                }
                this.localRotation = this._localRotation;
                if (value !== this._rotation) value.cloneTo(this._rotation);
                this._setTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION, false);
            }
        },
        {
            key: "rotationEuler",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_WORLDEULER)) {
                    this.rotation.getYawPitchRoll(Transform3D._tempVector30);
                    var eulerE = Transform3D._tempVector30;
                    var rotationEulerE = this._rotationEuler;
                    rotationEulerE.x = eulerE.y * Transform3D._angleToRandin;
                    rotationEulerE.y = eulerE.x * Transform3D._angleToRandin;
                    rotationEulerE.z = eulerE.z * Transform3D._angleToRandin;
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDEULER, false);
                }
                return this._rotationEuler;
            },
            set: function set(value) {
                Quaternion.createFromYawPitchRoll(value.y / Transform3D._angleToRandin, value.x / Transform3D._angleToRandin, value.z / Transform3D._angleToRandin, this._rotation);
                this.rotation = this._rotation;
                if (this._rotationEuler !== value) value.cloneTo(this._rotationEuler);
                this._setTransformFlag(Transform3D.TRANSFORM_WORLDEULER, false);
            }
        },
        {
            key: "worldMatrix",
            get: function get() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX)) {
                    if (this._parent != null) {
                        var effectiveTrans = this._parent;
                        while (effectiveTrans._parent && effectiveTrans.isDefaultMatrix) {
                            effectiveTrans = effectiveTrans._parent;
                        }
                        Matrix4x4.multiply(effectiveTrans.worldMatrix, this.localMatrix, this._worldMatrix);
                    } else this.localMatrix.cloneTo(this._worldMatrix);
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX, false);
                }
                return this._worldMatrix;
            },
            set: function set(value) {
                if (this._parent === null) {
                    value.cloneTo(this._localMatrix);
                } else {
                    this._parent.worldMatrix.invert(this._localMatrix);
                    Matrix4x4.multiply(this._localMatrix, value, this._localMatrix);
                }
                this.localMatrix = this._localMatrix;
                if (this._worldMatrix !== value) value.cloneTo(this._worldMatrix);
                this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX, false);
            }
        },
        {
            key: "_getScaleMatrix",
            value: function _getScaleMatrix() {
                var invRotation = Transform3D._tempQuaternion0;
                var invRotationMat = Transform3D._tempMatrix3x30;
                var worldRotScaMat = Transform3D._tempMatrix3x31;
                var scaMat = Transform3D._tempMatrix3x32;
                Matrix3x3.createFromMatrix4x4(this.worldMatrix, worldRotScaMat);
                this.rotation.invert(invRotation);
                Matrix3x3.createRotationQuaternion(invRotation, invRotationMat);
                Matrix3x3.multiply(invRotationMat, worldRotScaMat, scaMat);
                return scaMat;
            }
        },
        {
            key: "_setTransformFlag",
            value: function _setTransformFlag(type, value) {
                if (value) this._transformFlag |= type;
                else this._transformFlag &= ~type;
            }
        },
        {
            key: "_getTransformFlag",
            value: function _getTransformFlag(type) {
                return (this._transformFlag & type) != 0;
            }
        },
        {
            key: "_setParent",
            value: function _setParent(value) {
                if (this._parent !== value) {
                    if (this._parent) {
                        var parentChilds = this._parent._children;
                        var index = parentChilds.indexOf(this);
                        parentChilds.splice(index, 1);
                    }
                    if (value) {
                        value._children.push(this);
                        value && this._onWorldTransform();
                    }
                    this._parent = value;
                }
            }
        },
        {
            key: "_onWorldPositionRotationTransform",
            value: function _onWorldPositionRotationTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDEULER)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDPOSITION | Transform3D.TRANSFORM_WORLDQUATERNION | Transform3D.TRANSFORM_WORLDEULER, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldPositionRotationTransform();
                }
            }
        },
        {
            key: "_onWorldPositionScaleTransform",
            value: function _onWorldPositionScaleTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDSCALE)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDPOSITION | Transform3D.TRANSFORM_WORLDSCALE, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldPositionScaleTransform();
                }
            }
        },
        {
            key: "_onWorldPositionTransform",
            value: function _onWorldPositionTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDPOSITION, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldPositionTransform();
                }
            }
        },
        {
            key: "_onWorldRotationTransform",
            value: function _onWorldRotationTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDEULER)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDQUATERNION | Transform3D.TRANSFORM_WORLDEULER, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldPositionRotationTransform();
                }
            }
        },
        {
            key: "_onWorldScaleTransform",
            value: function _onWorldScaleTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDSCALE)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDSCALE, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldPositionScaleTransform();
                }
            }
        },
        {
            key: "_onWorldTransform",
            value: function _onWorldTransform() {
                if (!this._getTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDPOSITION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDQUATERNION) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDEULER) || !this._getTransformFlag(Transform3D.TRANSFORM_WORLDSCALE)) {
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDMATRIX | Transform3D.TRANSFORM_WORLDPOSITION | Transform3D.TRANSFORM_WORLDQUATERNION | Transform3D.TRANSFORM_WORLDEULER | Transform3D.TRANSFORM_WORLDSCALE, true);
                    this.event(Laya.Event.TRANSFORM_CHANGED, this._transformFlag);
                }
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    this._children[i]._onWorldTransform();
                }
            }
        },
        {
            key: "translate",
            value: function translate(translation) {
                var isLocal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
                if (isLocal) {
                    Matrix4x4.createFromQuaternion(this.localRotation, Transform3D._tempMatrix0);
                    Vector3.transformCoordinate(translation, Transform3D._tempMatrix0, Transform3D._tempVector30);
                    Vector3.add(this.localPosition, Transform3D._tempVector30, this._localPosition);
                    this.localPosition = this._localPosition;
                } else {
                    Vector3.add(this.position, translation, this._position);
                    this.position = this._position;
                }
            }
        },
        {
            key: "rotate",
            value: function rotate(rotation) {
                var isLocal = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
                var isRadian = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                var rot;
                if (isRadian) {
                    rot = rotation;
                } else {
                    Vector3.scale(rotation, Math.PI / 180.0, Transform3D._tempVector30);
                    rot = Transform3D._tempVector30;
                }
                Quaternion.createFromYawPitchRoll(rot.y, rot.x, rot.z, Transform3D._tempQuaternion0);
                if (isLocal) {
                    Quaternion.multiply(this._localRotation, Transform3D._tempQuaternion0, this._localRotation);
                    this.localRotation = this._localRotation;
                } else {
                    Quaternion.multiply(Transform3D._tempQuaternion0, this.rotation, this._rotation);
                    this.rotation = this._rotation;
                }
            }
        },
        {
            key: "getForward",
            value: function getForward(forward) {
                var worldMatElem = this.worldMatrix.elements;
                forward.x = -worldMatElem[8];
                forward.y = -worldMatElem[9];
                forward.z = -worldMatElem[10];
            }
        },
        {
            key: "getUp",
            value: function getUp(up) {
                var worldMatElem = this.worldMatrix.elements;
                up.x = worldMatElem[4];
                up.y = worldMatElem[5];
                up.z = worldMatElem[6];
            }
        },
        {
            key: "getRight",
            value: function getRight(right) {
                var worldMatElem = this.worldMatrix.elements;
                right.x = worldMatElem[0];
                right.y = worldMatElem[1];
                right.z = worldMatElem[2];
            }
        },
        {
            key: "lookAt",
            value: function lookAt(target, up) {
                var isLocal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                var isCamera = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                var eye;
                if (isLocal) {
                    eye = this._localPosition;
                    if (Math.abs(eye.x - target.x) < MathUtils3D.zeroTolerance && Math.abs(eye.y - target.y) < MathUtils3D.zeroTolerance && Math.abs(eye.z - target.z) < MathUtils3D.zeroTolerance) return;
                    if (isCamera) {
                        Quaternion.lookAt(this._localPosition, target, up, this._localRotation);
                        this._localRotation.invert(this._localRotation);
                    } else {
                        Vector3.subtract(this.localPosition, target, Transform3D._tempVector30);
                        Quaternion.rotationLookAt(Transform3D._tempVector30, up, this.localRotation);
                    }
                    this.localRotation = this._localRotation;
                } else {
                    var worldPosition = this.position;
                    eye = worldPosition;
                    if (Math.abs(eye.x - target.x) < MathUtils3D.zeroTolerance && Math.abs(eye.y - target.y) < MathUtils3D.zeroTolerance && Math.abs(eye.z - target.z) < MathUtils3D.zeroTolerance) return;
                    if (isCamera) {
                        Quaternion.lookAt(worldPosition, target, up, this._rotation);
                        this._rotation.invert(this._rotation);
                    } else {
                        Vector3.subtract(this.position, target, Transform3D._tempVector30);
                        Quaternion.rotationLookAt(Transform3D._tempVector30, up, this._rotation);
                    }
                    this.rotation = this._rotation;
                }
            }
        },
        {
            key: "objLookat",
            value: function objLookat(target, up) {
                var isLocal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
            }
        },
        {
            key: "getWorldLossyScale",
            value: function getWorldLossyScale() {
                if (this._getTransformFlag(Transform3D.TRANSFORM_WORLDSCALE)) {
                    if (this._parent !== null) {
                        var scaMatE = this._getScaleMatrix().elements;
                        this._scale.x = scaMatE[0];
                        this._scale.y = scaMatE[4];
                        this._scale.z = scaMatE[8];
                    } else {
                        this._localScale.cloneTo(this._scale);
                    }
                    this._setTransformFlag(Transform3D.TRANSFORM_WORLDSCALE, false);
                }
                return this._scale;
            }
        },
        {
            key: "setWorldLossyScale",
            value: function setWorldLossyScale(value) {
                if (this._parent !== null) {
                    var scaleMat = Transform3D._tempMatrix3x33;
                    var localScaleMat = Transform3D._tempMatrix3x33;
                    var localScaleMatE = localScaleMat.elements;
                    var parInvScaleMat = this._parent._getScaleMatrix();
                    parInvScaleMat.invert(parInvScaleMat);
                    Matrix3x3.createFromScaling(value, scaleMat);
                    Matrix3x3.multiply(parInvScaleMat, scaleMat, localScaleMat);
                    this._localScale.x = localScaleMatE[0];
                    this._localScale.y = localScaleMatE[4];
                    this._localScale.z = localScaleMatE[8];
                } else {
                    value.cloneTo(this._localScale);
                }
                this.localScale = this._localScale;
                if (this._scale !== value) value.cloneTo(this._scale);
                this._setTransformFlag(Transform3D.TRANSFORM_WORLDSCALE, false);
            }
        },
        {
            key: "scale",
            get: function get() {
                console.warn("Transfrm3D: discard function,please use getWorldLossyScale instead.");
                return this.getWorldLossyScale();
            },
            set: function set(value) {
                console.warn("Transfrm3D: discard function,please use setWorldLossyScale instead.");
                this.setWorldLossyScale(value);
            }
        },
        {
            key: "localToGlobal",
            value: function localToGlobal(value, out) {
                Vector3.transformV3ToV3(value, this.worldMatrix, out);
            }
        },
        {
            key: "globalToLocal",
            value: function globalToLocal(pos, out) {
                this.worldMatrix.invert(Transform3D._tempMatrix0);
                Vector3.transformV3ToV3(pos, Transform3D._tempMatrix0, out);
            }
        },
        {
            key: "toLocalNormal",
            value: function toLocalNormal(pos, out) {
                this.worldMatrix.invert(Transform3D._tempMatrix0);
                Vector3.TransformNormal(pos, Transform3D._tempMatrix0, out);
            }
        },
        {
            key: "toDir",
            value: function toDir(forward, dir) {
                var wmat = this.worldMatrix;
                this.rotationTo(this.rotation, forward, dir);
                this.rotation = this.rotation;
            }
        },
        {
            key: "rotationTo",
            value: function rotationTo(out, a, b) {
                var dot = Vector3.dot(a, b);
                if (dot < -0.999999) {
                    Vector3.cross(Vector3._UnitX, a, Transform3D.tmpVec3);
                    if (Vector3.scalarLength(Transform3D.tmpVec3) < 0.000001) Vector3.cross(Vector3._UnitY, a, Transform3D.tmpVec3);
                    Vector3.normalize(Transform3D.tmpVec3, Transform3D.tmpVec3);
                    Quaternion.createFromAxisAngle(Transform3D.tmpVec3, Math.PI, out);
                    return true;
                } else if (dot > 0.999999) {
                    out.x = 0;
                    out.y = 0;
                    out.z = 0;
                    out.w = 1;
                    return false;
                } else {
                    Vector3.cross(a, b, Transform3D.tmpVec3);
                    out.x = Transform3D.tmpVec3.x;
                    out.y = Transform3D.tmpVec3.y;
                    out.z = Transform3D.tmpVec3.z;
                    out.w = 1 + dot;
                    out.normalize(out);
                    return true;
                }
            }
        }]);
        return Transform3D;
    } (Laya.EventDispatcher);
    Transform3D._tempVector30 = new Vector3();
    Transform3D._tempQuaternion0 = new Quaternion();
    Transform3D._tempMatrix0 = new Matrix4x4();
    Transform3D._tempMatrix3x30 = new Matrix3x3();
    Transform3D._tempMatrix3x31 = new Matrix3x3();
    Transform3D._tempMatrix3x32 = new Matrix3x3();
    Transform3D._tempMatrix3x33 = new Matrix3x3();
    Transform3D.TRANSFORM_LOCALQUATERNION = 0x01;
    Transform3D.TRANSFORM_LOCALEULER = 0x02;
    Transform3D.TRANSFORM_LOCALMATRIX = 0x04;
    Transform3D.TRANSFORM_WORLDPOSITION = 0x08;
    Transform3D.TRANSFORM_WORLDQUATERNION = 0x10;
    Transform3D.TRANSFORM_WORLDSCALE = 0x20;
    Transform3D.TRANSFORM_WORLDMATRIX = 0x40;
    Transform3D.TRANSFORM_WORLDEULER = 0x80;
    Transform3D._angleToRandin = 180 / Math.PI;
    Transform3D.tmpVec3 = new Vector3();
    var Sprite3D =
    /*#__PURE__*/
    function(_Laya$Node) {
        _inherits(Sprite3D, _Laya$Node);
        var _super15 = _createSuper(Sprite3D);
        function Sprite3D() {
            var _this14;
            var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
            var isStatic = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
            _classCallCheck(this, Sprite3D);
            _this14 = _super15.call(this);
            _this14._needProcessCollisions = false;
            _this14._needProcessTriggers = false;
            _this14._id = ++Sprite3D._uniqueIDCounter;
            _this14._transform = new Transform3D(_assertThisInitialized(_this14));
            _this14._isStatic = isStatic;
            _this14.layer = 0;
            _this14.name = name ? name: "New Sprite3D";
            return _this14;
        }
        _createClass(Sprite3D, [{
            key: "id",
            get: function get() {
                return this._id;
            }
        },
        {
            key: "layer",
            get: function get() {
                return this._layer;
            },
            set: function set(value) {
                if (this._layer !== value) {
                    if (value >= 0 && value <= 30) {
                        this._layer = value;
                    } else {
                        throw new Error("Layer value must be 0-30.");
                    }
                }
            }
        },
        {
            key: "url",
            get: function get() {
                return this._url;
            }
        },
        {
            key: "isStatic",
            get: function get() {
                return this._isStatic;
            }
        },
        {
            key: "transform",
            get: function get() {
                return this._transform;
            }
        },
        {
            key: "_setCreateURL",
            value: function _setCreateURL(url) {
                this._url = Laya.URL.formatURL(url);
            }
        },
        {
            key: "_changeAnimatorsToLinkSprite3D",
            value: function _changeAnimatorsToLinkSprite3D(sprite3D, isLink, path) {
                var animator = this.getComponent(Animator);
                if (animator) {
                    if (!animator.avatar) sprite3D._changeAnimatorToLinkSprite3DNoAvatar(animator, isLink, path);
                }
                if (this._parent && this._parent instanceof Sprite3D) {
                    path.unshift(this._parent.name);
                    var p = this._parent;
                    p._hierarchyAnimator && p._changeAnimatorsToLinkSprite3D(sprite3D, isLink, path);
                }
            }
        },
        {
            key: "_setHierarchyAnimator",
            value: function _setHierarchyAnimator(animator, parentAnimator) {
                this._changeHierarchyAnimator(animator);
                this._changeAnimatorAvatar(animator.avatar);
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    child._hierarchyAnimator == parentAnimator && child._setHierarchyAnimator(animator, parentAnimator);
                }
            }
        },
        {
            key: "_clearHierarchyAnimator",
            value: function _clearHierarchyAnimator(animator, parentAnimator) {
                this._changeHierarchyAnimator(parentAnimator);
                this._changeAnimatorAvatar(parentAnimator ? parentAnimator.avatar: null);
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    child._hierarchyAnimator == animator && child._clearHierarchyAnimator(animator, parentAnimator);
                }
            }
        },
        {
            key: "_changeHierarchyAnimatorAvatar",
            value: function _changeHierarchyAnimatorAvatar(animator, avatar) {
                this._changeAnimatorAvatar(avatar);
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    child._hierarchyAnimator == animator && child._changeHierarchyAnimatorAvatar(animator, avatar);
                }
            }
        },
        {
            key: "_changeAnimatorToLinkSprite3DNoAvatar",
            value: function _changeAnimatorToLinkSprite3DNoAvatar(animator, isLink, path) {
                animator._handleSpriteOwnersBySprite(isLink, path, this);
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    var index = path.length;
                    path.push(child.name);
                    child._changeAnimatorToLinkSprite3DNoAvatar(animator, isLink, path);
                    path.splice(index, 1);
                }
            }
        },
        {
            key: "_changeHierarchyAnimator",
            value: function _changeHierarchyAnimator(animator) {
                this._hierarchyAnimator = animator;
            }
        },
        {
            key: "_changeAnimatorAvatar",
            value: function _changeAnimatorAvatar(avatar) {}
        },
        {
            key: "_onInActiveInScene",
            value: function _onInActiveInScene() {
                _get(_getPrototypeOf(Sprite3D.prototype), "_onInActiveInScene", this).call(this);
                if (!this._scripts) return;
                for (var i = 0,
                n = this._scripts.length; i < n; i++) {
                    this.scene._removeScript(this._scripts[i]);
                }
            }
        },
        {
            key: "_onAdded",
            value: function _onAdded() {
                if (this._parent instanceof Sprite3D) {
                    var parent3D = this._parent;
                    this.transform._setParent(parent3D.transform);
                    if (parent3D._hierarchyAnimator) { ! this._hierarchyAnimator && this._setHierarchyAnimator(parent3D._hierarchyAnimator, null);
                        parent3D._changeAnimatorsToLinkSprite3D(this, true, [this.name]);
                    }
                }
                _get(_getPrototypeOf(Sprite3D.prototype), "_onAdded", this).call(this);
            }
        },
        {
            key: "_onRemoved",
            value: function _onRemoved() {
                _get(_getPrototypeOf(Sprite3D.prototype), "_onRemoved", this).call(this);
                if (this._parent instanceof Sprite3D) {
                    var parent3D = this._parent;
                    this.transform._setParent(null);
                    if (parent3D._hierarchyAnimator) {
                        this._hierarchyAnimator == parent3D._hierarchyAnimator && this._clearHierarchyAnimator(parent3D._hierarchyAnimator, null);
                        parent3D._changeAnimatorsToLinkSprite3D(this, false, [this.name]);
                    }
                }
            }
        },
        {
            key: "_parse",
            value: function _parse(data, spriteMap) {
                data.isStatic !== undefined && (this._isStatic = data.isStatic);
                data.active !== undefined && (this.active = data.active);
                data.name != undefined && (this.name = data.name);
                if (data.position !== undefined) {
                    var loccalPosition = this.transform.localPosition;
                    loccalPosition.fromArray(data.position);
                    this.transform.localPosition = loccalPosition;
                }
                if (data.rotationEuler !== undefined) {
                    var localRotationEuler = this.transform.localRotationEuler;
                    localRotationEuler.fromArray(data.rotationEuler);
                    this.transform.localRotationEuler = localRotationEuler;
                }
                if (data.rotation !== undefined) {
                    var localRotation = this.transform.localRotation;
                    localRotation.fromArray(data.rotation);
                    this.transform.localRotation = localRotation;
                }
                if (data.scale !== undefined) {
                    var localScale = this.transform.localScale;
                    localScale.fromArray(data.scale);
                    this.transform.localScale = localScale;
                }
                data.layer != undefined && (this.layer = data.layer);
            }
        },
        {
            key: "_cloneTo",
            value: function _cloneTo(destObject, srcRoot, dstRoot) {
                if (this.destroyed) throw new Error("Sprite3D: Can't be cloned if the Sprite3D has destroyed.");
                var destSprite3D = destObject;
                var trans = this._transform;
                var destTrans = destSprite3D._transform;
                destSprite3D.name = this.name;
                destSprite3D.destroyed = this.destroyed;
                destSprite3D.active = this.active;
                destTrans.localPosition = trans.localPosition;
                destTrans.localRotation = trans.localRotation;
                destTrans.localScale = trans.localScale;
                destSprite3D._isStatic = this._isStatic;
                destSprite3D.layer = this.layer;
                _get(_getPrototypeOf(Sprite3D.prototype), "_cloneTo", this).call(this, destSprite3D, srcRoot, dstRoot);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dstSprite3D = Sprite3D._createSprite3DInstance(this);
                Sprite3D._parseSprite3DInstance(this, dstSprite3D, this, dstSprite3D);
                return dstSprite3D;
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                if (this.destroyed) return;
                _get(_getPrototypeOf(Sprite3D.prototype), "destroy", this).call(this, destroyChild);
                this._transform = null;
                this._scripts = null;
                this._url && Laya.Loader.clearRes(this._url);
            }
        },
        {
            key: "_create",
            value: function _create() {
                return new Sprite3D();
            }
        }], [{
            key: "__init__",
            value: function __init__() {}
        },
        {
            key: "instantiate",
            value: function instantiate(original) {
                var parent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var worldPositionStays = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                var position = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var rotation = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                var destSprite3D = original.clone();
                parent && parent.addChild(destSprite3D);
                var transform = destSprite3D.transform;
                if (worldPositionStays) {
                    var worldMatrix = transform.worldMatrix;
                    original.transform.worldMatrix.cloneTo(worldMatrix);
                    transform.worldMatrix = worldMatrix;
                } else {
                    position && (transform.position = position);
                    rotation && (transform.rotation = rotation);
                }
                return destSprite3D;
            }
        },
        {
            key: "load",
            value: function load(url, complete) {
                Laya.Laya.loader.create(url, complete, null, Sprite3D.HIERARCHY);
            }
        },
        {
            key: "_createSprite3DInstance",
            value: function _createSprite3DInstance(scrSprite) {
                var node = scrSprite._create();
                var children = scrSprite._children;
                for (var i = 0,
                n = children.length; i < n; i++) {
                    var child = Sprite3D._createSprite3DInstance(children[i]);
                    node.addChild(child);
                }
                return node;
            }
        },
        {
            key: "_parseSprite3DInstance",
            value: function _parseSprite3DInstance(srcRoot, dstRoot, scrSprite, dstSprite) {
                var srcChildren = scrSprite._children;
                var dstChildren = dstSprite._children;
                for (var i = 0,
                n = srcChildren.length; i < n; i++) {
                    Sprite3D._parseSprite3DInstance(srcRoot, dstRoot, srcChildren[i], dstChildren[i]);
                }
                scrSprite._cloneTo(dstSprite, srcRoot, dstRoot);
            }
        }]);
        return Sprite3D;
    } (Laya.Node);
    Sprite3D.HIERARCHY = "HIERARCHY";
    Sprite3D.WORLDMATRIX = Shader3D.propertyNameToID("u_WorldMat");
    Sprite3D.MVPMATRIX = Shader3D.propertyNameToID("u_MvpMatrix");
    Sprite3D._uniqueIDCounter = 0;
    var DrawMeshCMD =
    /*#__PURE__*/
    function(_Command4) {
        _inherits(DrawMeshCMD, _Command4);
        var _super16 = _createSuper(DrawMeshCMD);
        function DrawMeshCMD() {
            var _this15;
            _classCallCheck(this, DrawMeshCMD);
            _this15 = _super16.call(this);
            _this15._projectionViewWorldMatrix = new Matrix4x4();
            _this15._renderShaderValue = new ShaderData();
            _this15._renderShaderValue = new ShaderData(null);
            return _this15;
        }
        _createClass(DrawMeshCMD, [{
            key: "run",
            value: function run() {
                var renderSubShader = this._material._shader.getSubShaderAt(this._subShaderIndex);
                this.setContext(this._commandBuffer._context);
                var context = this._context;
                var forceInvertFace = context.invertY;
                var scene = context.scene;
                var cameraShaderValue = context.cameraShaderValue;
                var projectionView = context.projectionViewMatrix;
                Matrix4x4.multiply(projectionView, this._matrix, this._projectionViewWorldMatrix);
                this._renderShaderValue.setMatrix4x4(Sprite3D.WORLDMATRIX, this._matrix);
                this._renderShaderValue.setMatrix4x4(Sprite3D.MVPMATRIX, this._projectionViewWorldMatrix);
                var currentPipelineMode = context.pipelineMode;
                var passes = renderSubShader._passes;
                for (var j = 0,
                m = passes.length; j < m; j++) {
                    var pass = passes[j];
                    if (pass._pipelineMode !== currentPipelineMode) continue;
                    var comDef = DrawMeshCMD._compileDefine;
                    scene._shaderValues._defineDatas.cloneTo(comDef);
                    comDef.addDefineDatas(this._renderShaderValue._defineDatas);
                    comDef.addDefineDatas(this._material._shaderValues._defineDatas);
                    var shaderIns = context.shader = pass.withCompile(comDef);
                    shaderIns.bind();
                    shaderIns.uploadUniforms(shaderIns._sceneUniformParamsMap, scene._shaderValues, true);
                    shaderIns.uploadUniforms(shaderIns._spriteUniformParamsMap, this._renderShaderValue, true);
                    shaderIns.uploadUniforms(shaderIns._cameraUniformParamsMap, cameraShaderValue, true);
                    var matValues = this._material._shaderValues;
                    shaderIns.uploadUniforms(shaderIns._materialUniformParamsMap, matValues, true);
                    shaderIns.uploadRenderStateBlendDepth(matValues);
                    shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, this._matrix.getInvertFront());
                    var subGeometryElement = this._mesh._subMeshes;
                    var subMeshRender;
                    if (this._subMeshIndex == -1) {
                        for (var i = 0,
                        n = subGeometryElement.length; i < n; i++) {
                            subMeshRender = subGeometryElement[i];
                            if (subMeshRender._prepareRender(context)) {
                                subMeshRender._render(context);
                            }
                        }
                    } else {
                        var subGeometryElement = this._mesh._subMeshes;
                        subMeshRender = subGeometryElement[this._subMeshIndex];
                        if (subMeshRender._prepareRender(context)) {
                            subMeshRender._render(context);
                        }
                    }
                }
            }
        },
        {
            key: "recover",
            value: function recover() {
                DrawMeshCMD._pool.push(this);
                this._renderShaderValue.clearDefine();
                this._renderShaderValue._initData();
            }
        }], [{
            key: "create",
            value: function create(mesh, matrix, material, subMeshIndex, subShaderIndex, commandBuffer) {
                var cmd;
                cmd = DrawMeshCMD._pool.length > 0 ? DrawMeshCMD._pool.pop() : new DrawMeshCMD();
                cmd._mesh = mesh;
                cmd._matrix = matrix;
                cmd._material = material;
                cmd._subMeshIndex = subMeshIndex;
                cmd._subShaderIndex = subShaderIndex;
                cmd._commandBuffer = commandBuffer;
                return cmd;
            }
        }]);
        return DrawMeshCMD;
    } (Command);
    DrawMeshCMD._pool = [];
    DrawMeshCMD._compileDefine = new DefineDatas();
    var ClearRenderTextureCMD =
    /*#__PURE__*/
    function(_Command5) {
        _inherits(ClearRenderTextureCMD, _Command5);
        var _super17 = _createSuper(ClearRenderTextureCMD);
        function ClearRenderTextureCMD() {
            var _this16;
            _classCallCheck(this, ClearRenderTextureCMD);
            _this16 = _super17.apply(this, arguments);
            _this16._clearColor = false;
            _this16._clearDepth = false;
            _this16._backgroundColor = new Vector4();
            _this16._depth = 1;
            return _this16;
        }
        _createClass(ClearRenderTextureCMD, [{
            key: "run",
            value: function run() {
                var gl = Laya.LayaGL.instance;
                var flag;
                var backgroundColor = this._backgroundColor;
                if (this._clearColor) {
                    gl.clearColor(backgroundColor.x, backgroundColor.y, backgroundColor.z, backgroundColor.w);
                    flag |= gl.COLOR_BUFFER_BIT;
                }
                if (this._clearDepth) {
                    gl.clearDepth(this._depth);
                    flag |= gl.DEPTH_BUFFER_BIT;
                    Laya.WebGLContext.setDepthMask(gl, true);
                }
                if (this._clearColor || this._clearDepth) {
                    gl.clear(flag);
                }
            }
        },
        {
            key: "recover",
            value: function recover() {}
        }], [{
            key: "create",
            value: function create(clearColor, clearDepth, backgroundColor) {
                var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
                var commandBuffer = arguments.length > 4 ? arguments[4] : undefined;
                var cmd;
                cmd = ClearRenderTextureCMD._pool.length > 0 ? ClearRenderTextureCMD._pool.pop() : new ClearRenderTextureCMD();
                cmd._clearColor = clearColor;
                cmd._clearDepth = clearDepth;
                backgroundColor.cloneTo(cmd._backgroundColor);
                cmd._depth = depth;
                cmd._commandBuffer = commandBuffer;
                return cmd;
            }
        }]);
        return ClearRenderTextureCMD;
    } (Command);
    ClearRenderTextureCMD._pool = [];
    var DrawRenderCMD =
    /*#__PURE__*/
    function(_Command6) {
        _inherits(DrawRenderCMD, _Command6);
        var _super18 = _createSuper(DrawRenderCMD);
        function DrawRenderCMD() {
            _classCallCheck(this, DrawRenderCMD);
            return _super18.apply(this, arguments);
        }
        _createClass(DrawRenderCMD, [{
            key: "_elementRender",
            value: function _elementRender(renderElement, context) {
                var forceInvertFace = context.invertY;
                var lastStateMaterial, lastStateShaderInstance, lastStateRender;
                var updateMark = ILaya3D.Camera._updateMark;
                var scene = context.scene;
                this._render._scene = context.scene;
                var cameraShaderValue = context.cameraShaderValue;
                var transform = renderElement._transform;
                var geometry = renderElement._geometry;
                context.renderElement = renderElement;
                var updateRender = updateMark !== renderElement.render._updateMark || renderElement.renderType !== renderElement.render._updateRenderType;
                if (updateRender) {
                    renderElement.render._renderUpdate(context, transform);
                    renderElement.render._renderUpdateWithCamera(context, transform);
                    renderElement.render._updateMark = updateMark;
                    renderElement.render._updateRenderType = renderElement.renderType;
                } else {
                    if (renderElement.renderType == ILaya3D.RenderElement.RENDERTYPE_INSTANCEBATCH) {
                        renderElement.render._renderUpdate(context, transform);
                        renderElement.render._renderUpdateWithCamera(context, transform);
                    }
                }
                var currentPipelineMode = context.pipelineMode;
                if (geometry._prepareRender(context)) {
                    var passes = this._material._shader.getSubShaderAt(this._subShaderIndex)._passes;
                    for (var j = 0,
                    m = passes.length; j < m; j++) {
                        var pass = passes[j];
                        if (pass._pipelineMode !== currentPipelineMode) continue;
                        var comDef = DrawRenderCMD._compileDefine;
                        scene._shaderValues._defineDatas.cloneTo(comDef);
                        comDef.addDefineDatas(renderElement.render._shaderValues._defineDatas);
                        comDef.addDefineDatas(this._material._shaderValues._defineDatas);
                        var shaderIns = context.shader = pass.withCompile(comDef);
                        var switchShader = shaderIns.bind();
                        var switchUpdateMark = updateMark !== shaderIns._uploadMark;
                        var uploadScene = shaderIns._uploadScene !== scene || switchUpdateMark;
                        if (uploadScene || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._sceneUniformParamsMap, scene._shaderValues, uploadScene);
                            shaderIns._uploadScene = scene;
                        }
                        var uploadSprite3D = shaderIns._uploadRender !== renderElement.render || shaderIns._uploadRenderType !== renderElement.renderType || switchUpdateMark;
                        if (uploadSprite3D || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._spriteUniformParamsMap, renderElement.render._shaderValues, uploadSprite3D);
                            shaderIns._uploadRender = renderElement.render;
                            shaderIns._uploadRenderType = renderElement.renderType;
                        }
                        var uploadCamera = shaderIns._uploadCameraShaderValue !== cameraShaderValue || switchUpdateMark;
                        if (uploadCamera || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._cameraUniformParamsMap, cameraShaderValue, uploadCamera);
                            shaderIns._uploadCameraShaderValue = cameraShaderValue;
                        }
                        var uploadMaterial = shaderIns._uploadMaterial !== this._material || switchUpdateMark;
                        if (uploadMaterial || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._materialUniformParamsMap, this._material._shaderValues, uploadMaterial);
                            shaderIns._uploadMaterial = this._material;
                        }
                        var matValues = this._material._shaderValues;
                        if (lastStateMaterial !== this._material || lastStateShaderInstance !== shaderIns) {
                            shaderIns.uploadRenderStateBlendDepth(matValues);
                            shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, renderElement.getInvertFront());
                            lastStateMaterial = this._material;
                            lastStateShaderInstance = shaderIns;
                            lastStateRender = renderElement.render;
                        } else {
                            if (lastStateRender !== renderElement.render) {
                                shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, renderElement.getInvertFront());
                                lastStateRender = renderElement.render;
                            }
                        }
                        geometry._render(context);
                        shaderIns._uploadMark = updateMark;
                    }
                }
                if (renderElement.renderType !== ILaya3D.RenderElement.RENDERTYPE_NORMAL) renderElement.render._revertBatchRenderUpdate(context);
            }
        },
        {
            key: "run",
            value: function run() {
                if (!this._material) throw "This render command material cannot be empty";
                this.setContext(this._commandBuffer._context);
                var context = this._context;
                var scene = context.scene;
                var renderElements = this._render._renderElements;
                for (var i = 0,
                n = renderElements.length; i < n; i++) {
                    var renderelement = renderElements[i];
                    this._elementRender(renderelement, context);
                }
            }
        },
        {
            key: "recover",
            value: function recover() {
                DrawRenderCMD._pool.push(this);
            }
        }], [{
            key: "create",
            value: function create(render, material, subShaderIndex, commandBuffer) {
                var cmd;
                cmd = DrawRenderCMD._pool.length > 0 ? DrawRenderCMD._pool.pop() : new DrawRenderCMD();
                cmd._render = render;
                cmd._material = material;
                cmd._subShaderIndex = subShaderIndex;
                cmd._commandBuffer = commandBuffer;
                return cmd;
            }
        }]);
        return DrawRenderCMD;
    } (Command);
    DrawRenderCMD._pool = [];
    DrawRenderCMD._compileDefine = new DefineDatas();
    var SetGlobalShaderDataCMD =
    /*#__PURE__*/
    function(_Command7) {
        _inherits(SetGlobalShaderDataCMD, _Command7);
        var _super19 = _createSuper(SetGlobalShaderDataCMD);
        function SetGlobalShaderDataCMD() {
            var _this17;
            _classCallCheck(this, SetGlobalShaderDataCMD);
            _this17 = _super19.apply(this, arguments);
            _this17._nameID = 0;
            _this17._value = null;
            _this17._dataType = -1;
            return _this17;
        }
        _createClass(SetGlobalShaderDataCMD, [{
            key: "run",
            value: function run() {
                var shaderData = this._commandBuffer._camera.scene._shaderValues;
                switch (this._dataType) {
                case exports.ShaderDataType.Int:
                    shaderData.setInt(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Number:
                    shaderData.setNumber(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Bool:
                    shaderData.setBool(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Matrix4x4:
                    shaderData.setMatrix4x4(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Quaternion:
                    shaderData.setQuaternion(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Texture:
                    shaderData.setTexture(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector4:
                    shaderData.setVector(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector2:
                    shaderData.setVector2(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Vector3:
                    shaderData.setVector3(this._nameID, this._value);
                    break;
                case exports.ShaderDataType.Buffer:
                    shaderData.setBuffer(this._nameID, this._value);
                    break;
                default:
                    throw "no type shaderValue on this CommendBuffer";
                }
            }
        },
        {
            key: "recover",
            value: function recover() {
                SetGlobalShaderDataCMD._pool.push(this);
                this._nameID = 0;
                this._value = null;
                this._dataType = -1;
            }
        }], [{
            key: "create",
            value: function create(nameID, value, shaderDataType, commandBuffer) {
                var cmd;
                cmd = SetGlobalShaderDataCMD._pool.length > 0 ? SetGlobalShaderDataCMD._pool.pop() : new SetGlobalShaderDataCMD();
                cmd._nameID = nameID;
                cmd._value = value;
                cmd._dataType = shaderDataType;
                cmd._commandBuffer = commandBuffer;
                return cmd;
            }
        }]);
        return SetGlobalShaderDataCMD;
    } (Command);
    SetGlobalShaderDataCMD._pool = [];
    var MeshSprite3DShaderDeclaration =
    /*#__PURE__*/
    _createClass(function MeshSprite3DShaderDeclaration() {
        _classCallCheck(this, MeshSprite3DShaderDeclaration);
    });
    var VertexMesh =
    /*#__PURE__*/
    function() {
        function VertexMesh() {
            _classCallCheck(this, VertexMesh);
        }
        _createClass(VertexMesh, null, [{
            key: "__init__",
            value: function __init__() {
                VertexMesh.instanceWorldMatrixDeclaration = new VertexDeclaration(64, [new VertexElement(0, VertexElementFormat.Vector4, VertexMesh.MESH_WORLDMATRIX_ROW0), new VertexElement(16, VertexElementFormat.Vector4, VertexMesh.MESH_WORLDMATRIX_ROW1), new VertexElement(32, VertexElementFormat.Vector4, VertexMesh.MESH_WORLDMATRIX_ROW2), new VertexElement(48, VertexElementFormat.Vector4, VertexMesh.MESH_WORLDMATRIX_ROW3)]);
                VertexMesh.instanceSimpleAnimatorDeclaration = new VertexDeclaration(16, [new VertexElement(0, VertexElementFormat.Vector4, VertexMesh.MESH_SIMPLEANIMATOR)]);
            }
        },
        {
            key: "getVertexDeclaration",
            value: function getVertexDeclaration(vertexFlag) {
                var compatible = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
                var verDec = VertexMesh._vertexDeclarationMap[vertexFlag + (compatible ? "_0": "_1")];
                if (!verDec) {
                    var subFlags = vertexFlag.split(",");
                    var offset = 0;
                    var elements = [];
                    for (var i = 0,
                    n = subFlags.length; i < n; i++) {
                        var element;
                        switch (subFlags[i]) {
                        case "POSITION":
                            element = new VertexElement(offset, VertexElementFormat.Vector3, VertexMesh.MESH_POSITION0);
                            offset += 12;
                            break;
                        case "NORMAL":
                            element = new VertexElement(offset, VertexElementFormat.Vector3, VertexMesh.MESH_NORMAL0);
                            offset += 12;
                            break;
                        case "COLOR":
                            element = new VertexElement(offset, VertexElementFormat.Vector4, VertexMesh.MESH_COLOR0);
                            offset += 16;
                            break;
                        case "UV":
                            element = new VertexElement(offset, VertexElementFormat.Vector2, VertexMesh.MESH_TEXTURECOORDINATE0);
                            offset += 8;
                            break;
                        case "UV1":
                            element = new VertexElement(offset, VertexElementFormat.Vector2, VertexMesh.MESH_TEXTURECOORDINATE1);
                            offset += 8;
                            break;
                        case "BLENDWEIGHT":
                            element = new VertexElement(offset, VertexElementFormat.Vector4, VertexMesh.MESH_BLENDWEIGHT0);
                            offset += 16;
                            break;
                        case "BLENDINDICES":
                            if (compatible) {
                                element = new VertexElement(offset, VertexElementFormat.Vector4, VertexMesh.MESH_BLENDINDICES0);
                                offset += 16;
                            } else {
                                element = new VertexElement(offset, VertexElementFormat.Byte4, VertexMesh.MESH_BLENDINDICES0);
                                offset += 4;
                            }
                            break;
                        case "TANGENT":
                            element = new VertexElement(offset, VertexElementFormat.Vector4, VertexMesh.MESH_TANGENT0);
                            offset += 16;
                            break;
                        default:
                            throw "VertexMesh: unknown vertex flag.";
                        }
                        elements.push(element);
                    }
                    verDec = new VertexDeclaration(offset, elements);
                    VertexMesh._vertexDeclarationMap[vertexFlag + (compatible ? "_0": "_1")] = verDec;
                }
                return verDec;
            }
        }]);
        return VertexMesh;
    } ();
    VertexMesh.MESH_POSITION0 = 0;
    VertexMesh.MESH_COLOR0 = 1;
    VertexMesh.MESH_TEXTURECOORDINATE0 = 2;
    VertexMesh.MESH_NORMAL0 = 3;
    VertexMesh.MESH_TANGENT0 = 4;
    VertexMesh.MESH_BLENDINDICES0 = 5;
    VertexMesh.MESH_BLENDWEIGHT0 = 6;
    VertexMesh.MESH_TEXTURECOORDINATE1 = 7;
    VertexMesh.MESH_WORLDMATRIX_ROW0 = 8;
    VertexMesh.MESH_WORLDMATRIX_ROW1 = 9;
    VertexMesh.MESH_WORLDMATRIX_ROW2 = 10;
    VertexMesh.MESH_WORLDMATRIX_ROW3 = 11;
    VertexMesh.MESH_SIMPLEANIMATOR = 12;
    VertexMesh.MESH_CUSTOME0 = 12;
    VertexMesh.MESH_CUSTOME1 = 13;
    VertexMesh.MESH_CUSTOME2 = 14;
    VertexMesh.MESH_CUSTOME3 = 15;
    VertexMesh._vertexDeclarationMap = {};
    var DrawMeshInstancedCMD =
    /*#__PURE__*/
    function(_Command8) {
        _inherits(DrawMeshInstancedCMD, _Command8);
        var _super20 = _createSuper(DrawMeshInstancedCMD);
        function DrawMeshInstancedCMD() {
            var _this18;
            _classCallCheck(this, DrawMeshInstancedCMD);
            _this18 = _super20.call(this);
            _this18._renderShaderValue = new ShaderData(null);
            var gl = Laya.LayaGL.instance;
            _this18._instanceWorldMatrixData = new Float32Array(DrawMeshInstancedCMD.maxInstanceCount * 16);
            _this18._instanceWorldMatrixBuffer = new VertexBuffer3D(_this18._instanceWorldMatrixData.length * 4, gl.DYNAMIC_DRAW);
            _this18._instanceWorldMatrixBuffer.vertexDeclaration = VertexMesh.instanceWorldMatrixDeclaration;
            return _this18;
        }
        _createClass(DrawMeshInstancedCMD, [{
            key: "bufferState",
            get: function get() {
                return this._instanceWorldMatrixBuffer;
            }
        },
        {
            key: "_setInstanceBuffer",
            value: function _setInstanceBuffer() {
                var instanceBufferState = this._instanceBufferState = new BufferState();
                instanceBufferState.bind();
                instanceBufferState.applyVertexBuffer(this._mesh._vertexBuffer);
                instanceBufferState.applyInstanceVertexBuffer(this._instanceWorldMatrixBuffer);
                var propertyMap = this._instanceProperty._propertyMap;
                for (var i in propertyMap) {
                    instanceBufferState.applyInstanceVertexBuffer(propertyMap[i]._vertexBuffer);
                }
                instanceBufferState.applyIndexBuffer(this._mesh._indexBuffer);
                instanceBufferState.unBind();
            }
        },
        {
            key: "_updateWorldMatrixBuffer",
            value: function _updateWorldMatrixBuffer() {
                var worldMatrixData = this._instanceWorldMatrixData;
                var count = this._drawnums;
                for (var i = 0; i < count; i++) {
                    worldMatrixData.set(this._matrixs[i].elements, i * 16);
                }
                var worldBuffer = this._instanceWorldMatrixBuffer;
                worldBuffer.orphanStorage();
                worldBuffer.setData(worldMatrixData.buffer, 0, 0, count * 64);
            }
        },
        {
            key: "_render",
            value: function _render(subMesh) {
                var gl = Laya.LayaGL.instance;
                var count = this._drawnums;
                var indexCount = subMesh._indexCount;
                this._instanceBufferState.bind();
                Laya.LayaGL.layaGPUInstance.drawElementsInstanced(gl.TRIANGLES, indexCount, gl.UNSIGNED_SHORT, subMesh._indexStart * 2, count);
                Laya.Stat.renderBatches++;
                Laya.Stat.trianglesFaces += indexCount * count / 3;
            }
        },
        {
            key: "run",
            value: function run() {
                var renderSubShader = this._material._shader.getSubShaderAt(this._subShaderIndex);
                this.setContext(this._commandBuffer._context);
                var context = this._context;
                var forceInvertFace = context.invertY;
                var scene = context.scene;
                var cameraShaderValue = context.cameraShaderValue;
                var currentPipelineMode = context.pipelineMode;
                this._renderShaderValue.addDefine(MeshSprite3DShaderDeclaration.SHADERDEFINE_GPU_INSTANCE);
                var passes = renderSubShader._passes;
                for (var j = 0,
                m = passes.length; j < m; j++) {
                    var pass = passes[j];
                    if (pass._pipelineMode !== currentPipelineMode) continue;
                    var comDef = DrawMeshInstancedCMD._compileDefine;
                    scene._shaderValues._defineDatas.cloneTo(comDef);
                    comDef.addDefineDatas(this._renderShaderValue._defineDatas);
                    comDef.addDefineDatas(this._material._shaderValues._defineDatas);
                    var shaderIns = context.shader = pass.withCompile(comDef);
                    shaderIns.bind();
                    shaderIns.uploadUniforms(shaderIns._sceneUniformParamsMap, scene._shaderValues, true);
                    shaderIns.uploadUniforms(shaderIns._spriteUniformParamsMap, this._renderShaderValue, true);
                    shaderIns.uploadUniforms(shaderIns._cameraUniformParamsMap, cameraShaderValue, true);
                    var matValues = this._material._shaderValues;
                    shaderIns.uploadUniforms(shaderIns._materialUniformParamsMap, matValues, true);
                    shaderIns.uploadRenderStateBlendDepth(matValues);
                    shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, false);
                }
                var propertyMap = this._instanceProperty._propertyMap;
                for (var i in propertyMap) {
                    propertyMap[i].updateVertexBufferData(this._drawnums);
                }
                var subGeometryElement = this._mesh._subMeshes;
                var subMeshRender;
                if (this._subMeshIndex == -1) {
                    for (var _i = 0,
                    n = subGeometryElement.length; _i < n; _i++) {
                        subMeshRender = subGeometryElement[_i];
                        if (subMeshRender._prepareRender(context)) {
                            this._render(subMeshRender);
                        }
                    }
                } else {
                    var _subGeometryElement = this._mesh._subMeshes;
                    subMeshRender = _subGeometryElement[this._subMeshIndex];
                    if (subMeshRender._prepareRender(context)) {
                        this._render(subMeshRender);
                    }
                }
            }
        },
        {
            key: "setWorldMatrix",
            value: function setWorldMatrix(worldMatrixArray) {
                if (worldMatrixArray.length < this._drawnums) throw "worldMatrixArray length is less then drawnums";
                this._matrixs = worldMatrixArray;
                this._matrixs && this._updateWorldMatrixBuffer();
            }
        },
        {
            key: "setDrawNums",
            value: function setDrawNums(drawNums) {
                if (this._matrixs && this._matrixs.length < drawNums) throw "worldMatrixArray length is less then drawnums";
                this._drawnums = drawNums;
                this._matrixs && this._updateWorldMatrixBuffer();
            }
        },
        {
            key: "recover",
            value: function recover() {
                DrawMeshInstancedCMD._pool.push(this);
                this._renderShaderValue.clearDefine();
                this._renderShaderValue._initData();
                this._instanceBufferState.destroy();
                this._instanceBufferState = null;
            }
        }], [{
            key: "create",
            value: function create(mesh, subMeshIndex, matrixs, material, subShaderIndex, instanceProperty, drawnums, commandBuffer) {
                var cmd;
                if (matrixs && matrixs.length > DrawMeshInstancedCMD.maxInstanceCount || drawnums > DrawMeshInstancedCMD.maxInstanceCount) {
                    throw "the number of renderings exceeds the maximum number of merges";
                }
                cmd = DrawMeshInstancedCMD._pool.length > 0 ? DrawMeshInstancedCMD._pool.pop() : new DrawMeshInstancedCMD();
                cmd._mesh = mesh;
                cmd._matrixs = matrixs;
                cmd._material = material;
                cmd._subMeshIndex = subMeshIndex;
                cmd._subShaderIndex = subShaderIndex;
                cmd._commandBuffer = commandBuffer;
                cmd._instanceProperty = instanceProperty;
                cmd._drawnums = drawnums;
                matrixs && cmd._updateWorldMatrixBuffer();
                cmd._setInstanceBuffer();
                return cmd;
            }
        }]);
        return DrawMeshInstancedCMD;
    } (Command);
    DrawMeshInstancedCMD._pool = [];
    DrawMeshInstancedCMD._compileDefine = new DefineDatas();
    DrawMeshInstancedCMD.maxInstanceCount = 1024;
    var CommandBuffer =
    /*#__PURE__*/
    function() {
        function CommandBuffer() {
            var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
            _classCallCheck(this, CommandBuffer);
            this._camera = null;
            this._commands = [];
            this._name = name;
        }
        _createClass(CommandBuffer, [{
            key: "name",
            get: function get() {
                return this._name;
            }
        },
        {
            key: "_apply",
            value: function _apply() {
                for (var i = 0,
                n = this._commands.length; i < n; i++) {
                    this._commands[i].run();
                }
            }
        },
        {
            key: "_applyOne",
            value: function _applyOne() {
                if (this._commands.length) {
                    var cmd = this._commands.shift();
                    cmd.run();
                    cmd.recover();
                }
                return this._commands.length > 0;
            }
        },
        {
            key: "getCommandsSize",
            value: function getCommandsSize() {
                return this._commands.length;
            }
        },
        {
            key: "setShaderDataTexture",
            value: function setShaderDataTexture(shaderData, nameID, source) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, source, exports.ShaderDataType.Texture, this));
            }
        },
        {
            key: "setGlobalTexture",
            value: function setGlobalTexture(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Texture, this));
            }
        },
        {
            key: "setShaderDataVector",
            value: function setShaderDataVector(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Vector4, this));
            }
        },
        {
            key: "setGlobalVector",
            value: function setGlobalVector(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Vector4, this));
            }
        },
        {
            key: "setShaderDataVector3",
            value: function setShaderDataVector3(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Vector3, this));
            }
        },
        {
            key: "setGlobalVector3",
            value: function setGlobalVector3(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Vector3, this));
            }
        },
        {
            key: "setShaderDataVector2",
            value: function setShaderDataVector2(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Vector2, this));
            }
        },
        {
            key: "setGlobalVector2",
            value: function setGlobalVector2(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Vector2, this));
            }
        },
        {
            key: "setShaderDataNumber",
            value: function setShaderDataNumber(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Number, this));
            }
        },
        {
            key: "setGlobalNumber",
            value: function setGlobalNumber(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Number, this));
            }
        },
        {
            key: "setShaderDataInt",
            value: function setShaderDataInt(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Int, this));
            }
        },
        {
            key: "setGlobalInt",
            value: function setGlobalInt(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Int, this));
            }
        },
        {
            key: "setShaderDataMatrix",
            value: function setShaderDataMatrix(shaderData, nameID, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, nameID, value, exports.ShaderDataType.Matrix4x4, this));
            }
        },
        {
            key: "setShaderDefine",
            value: function setShaderDefine(shaderData, define, value) {
                this._commands.push(SetShaderDataCMD.create(shaderData, define, value, exports.ShaderDataType.ShaderDefine, this));
            }
        },
        {
            key: "setGlobalMatrix",
            value: function setGlobalMatrix(nameID, source) {
                this._commands.push(SetGlobalShaderDataCMD.create(nameID, source, exports.ShaderDataType.Matrix4x4, this));
            }
        },
        {
            key: "blitScreenQuad",
            value: function blitScreenQuad(source, dest) {
                var offsetScale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var shader = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var shaderData = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                var subShader = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                var definedCanvas = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;
                this._commands.push(BlitScreenQuadCMD.create(source, dest, offsetScale, shader, shaderData, subShader, BlitScreenQuadCMD._SCREENTYPE_QUAD, this, definedCanvas));
            }
        },
        {
            key: "blitScreenQuadByMaterial",
            value: function blitScreenQuadByMaterial(source, dest) {
                var offsetScale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var material = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var subShader = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                var shader;
                var shaderData;
                if (material) {
                    shader = material._shader;
                    shaderData = material.shaderData;
                }
                this._commands.push(BlitScreenQuadCMD.create(source, dest, offsetScale, shader, shaderData, subShader, BlitScreenQuadCMD._SCREENTYPE_QUAD, this));
            }
        },
        {
            key: "blitScreenTriangle",
            value: function blitScreenTriangle(source, dest) {
                var offsetScale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var shader = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var shaderData = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                var subShader = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                var defineCanvas = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : false;
                this._commands.push(BlitScreenQuadCMD.create(source, dest, offsetScale, shader, shaderData, subShader, BlitScreenQuadCMD._SCREENTYPE_TRIANGLE, this, defineCanvas));
            }
        },
        {
            key: "setRenderTarget",
            value: function setRenderTarget(renderTexture) {
                this._commands.push(SetRenderTargetCMD.create(renderTexture));
            }
        },
        {
            key: "clearRenderTarget",
            value: function clearRenderTarget(clearColor, clearDepth, backgroundColor) {
                var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
                this._commands.push(ClearRenderTextureCMD.create(clearColor, clearDepth, backgroundColor, depth, this));
            }
        },
        {
            key: "drawMesh",
            value: function drawMesh(mesh, matrix, material, submeshIndex, subShaderIndex) {
                this._commands.push(DrawMeshCMD.create(mesh, matrix, material, submeshIndex, subShaderIndex, this));
            }
        },
        {
            key: "drawRender",
            value: function drawRender(render, material, subShaderIndex) {
                this._commands.push(DrawRenderCMD.create(render, material, subShaderIndex, this));
            }
        },
        {
            key: "drawMeshInstance",
            value: function drawMeshInstance(mesh, subMeshIndex, matrixs, material, subShaderIndex, instanceProperty, drawnums) {
                if (!Laya.LayaGL.layaGPUInstance.supportInstance()) return null;
                var drawMeshInstancedCMD = DrawMeshInstancedCMD.create(mesh, subMeshIndex, matrixs, material, subShaderIndex, instanceProperty, drawnums, this);
                this._commands.push(drawMeshInstancedCMD);
                return drawMeshInstancedCMD;
            }
        },
        {
            key: "clear",
            value: function clear() {
                for (var i = 0,
                n = this._commands.length; i < n; i++) {
                    this._commands[i].recover();
                }
                this._commands.length = 0;
            }
        }]);
        return CommandBuffer;
    } ();
    var PostProcessRenderContext =
    /*#__PURE__*/
    _createClass(function PostProcessRenderContext() {
        _classCallCheck(this, PostProcessRenderContext);
        this.source = null;
        this.destination = null;
        this.camera = null;
        this.compositeShaderData = null;
        this.command = null;
        this.deferredReleaseTextures = [];
    });
    var PostProcess =
    /*#__PURE__*/
    function() {
        function PostProcess() {
            _classCallCheck(this, PostProcess);
            this._compositeShader = Shader3D.find("PostProcessComposite");
            this._compositeShaderData = new ShaderData();
            this._effects = [];
            this._enable = true;
            this._context = null;
            this._context = new PostProcessRenderContext();
            this._context.compositeShaderData = this._compositeShaderData;
            this._context.command = new CommandBuffer();
        }
        _createClass(PostProcess, [{
            key: "enable",
            get: function get() {
                return this._enable;
            },
            set: function set(value) {
                this._enable = value;
            }
        },
        {
            key: "commandContext",
            set: function set(oriContext) {
                this._context.command._context = oriContext;
            }
        },
        {
            key: "_init",
            value: function _init(camera) {
                this._context.camera = camera;
                this._context.command._camera = camera;
            }
        },
        {
            key: "_render",
            value: function _render() {
                var noteValue = ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_;
                Laya.ILaya.Render.supportWebGLPlusRendering && ShaderData.setRuntimeValueMode(false);
                var camera = this._context.camera;
                var viewport = camera.viewport;
                var cameraTarget = camera._internalRenderTexture;
                var screenTexture = RenderTexture.createFromPool(cameraTarget.width, cameraTarget.height, camera._getRenderTextureFormat(), Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE);
                this._context.command.clear();
                this._context.source = screenTexture;
                this._context.destination = cameraTarget;
                this._context.compositeShaderData.clearDefine();
                this._context.command.blitScreenTriangle(cameraTarget, screenTexture);
                this._context.compositeShaderData.setTexture(PostProcess.SHADERVALUE_AUTOEXPOSURETEX, Laya.Texture2D.whiteTexture);
                for (var i = 0,
                n = this._effects.length; i < n; i++) {
                    this._effects[i].render(this._context);
                }
                this._compositeShaderData.addDefine(PostProcess.SHADERDEFINE_FINALPASS);
                var offScreenTex = camera._offScreenRenderTexture;
                var dest = offScreenTex ? offScreenTex: null;
                this._context.destination = dest;
                var canvasWidth = camera._getCanvasWidth(),
                canvasHeight = camera._getCanvasHeight();
                camera._screenOffsetScale.setValue(viewport.x / canvasWidth, viewport.y / canvasHeight, viewport.width / canvasWidth, viewport.height / canvasHeight);
                if (dest) this._context.command.blitScreenTriangle(screenTexture, dest, camera._screenOffsetScale, this._compositeShader, this._compositeShaderData, 0, true);
                RenderTexture.recoverToPool(screenTexture);
                var tempRenderTextures = this._context.deferredReleaseTextures;
                for (i = 0, n = tempRenderTextures.length; i < n; i++) {
                    RenderTexture.recoverToPool(tempRenderTextures[i]);
                }
                tempRenderTextures.length = 0;
                Laya.ILaya.Render.supportWebGLPlusRendering && ShaderData.setRuntimeValueMode(noteValue);
            }
        },
        {
            key: "addEffect",
            value: function addEffect(effect) {
                this._effects.push(effect);
            }
        },
        {
            key: "removeEffect",
            value: function removeEffect(effect) {
                var index = this._effects.indexOf(effect);
                if (index !== -1) this._effects.splice(index, 1);
            }
        },
        {
            key: "_applyPostProcessCommandBuffers",
            value: function _applyPostProcessCommandBuffers() {
                this._context.command._apply();
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                PostProcess.SHADERDEFINE_BLOOM_LOW = Shader3D.getDefineByName("BLOOM_LOW");
                PostProcess.SHADERDEFINE_BLOOM = Shader3D.getDefineByName("BLOOM");
                PostProcess.SHADERDEFINE_FINALPASS = Shader3D.getDefineByName("FINALPASS");
            }
        }]);
        return PostProcess;
    } ();
    PostProcess.SHADERVALUE_MAINTEX = Shader3D.propertyNameToID("u_MainTex");
    PostProcess.SHADERVALUE_BLOOMTEX = Shader3D.propertyNameToID("u_BloomTex");
    PostProcess.SHADERVALUE_AUTOEXPOSURETEX = Shader3D.propertyNameToID("u_AutoExposureTex");
    PostProcess.SHADERVALUE_BLOOM_DIRTTEX = Shader3D.propertyNameToID("u_Bloom_DirtTex");
    PostProcess.SHADERVALUE_BLOOMTEX_TEXELSIZE = Shader3D.propertyNameToID("u_BloomTex_TexelSize");
    PostProcess.SHADERVALUE_BLOOM_DIRTTILEOFFSET = Shader3D.propertyNameToID("u_Bloom_DirtTileOffset");
    PostProcess.SHADERVALUE_BLOOM_SETTINGS = Shader3D.propertyNameToID("u_Bloom_Settings");
    PostProcess.SHADERVALUE_BLOOM_COLOR = Shader3D.propertyNameToID("u_Bloom_Color");
    var AnimationTransform3D =
    /*#__PURE__*/
    function(_Laya$EventDispatcher2) {
        _inherits(AnimationTransform3D, _Laya$EventDispatcher2);
        var _super21 = _createSuper(AnimationTransform3D);
        function AnimationTransform3D(owner) {
            var _this19;
            _classCallCheck(this, AnimationTransform3D);
            _this19 = _super21.call(this);
            _this19._owner = owner;
            _this19._children = [];
            _this19._localMatrix = new Float32Array(16);
            _this19._localPosition = new Vector3();
            _this19._localRotation = new Quaternion();
            _this19._localScale = new Vector3();
            _this19._worldMatrix = new Float32Array(16);
            _this19._localQuaternionUpdate = false;
            _this19._locaEulerlUpdate = false;
            _this19._localUpdate = false;
            _this19._worldUpdate = true;
            return _this19;
        }
        _createClass(AnimationTransform3D, [{
            key: "_getlocalMatrix",
            value: function _getlocalMatrix() {
                if (this._localUpdate) {
                    Utils3D._createAffineTransformationArray(this._localPosition, this._localRotation, this._localScale, this._localMatrix);
                    this._localUpdate = false;
                }
                return this._localMatrix;
            }
        },
        {
            key: "_onWorldTransform",
            value: function _onWorldTransform() {
                if (!this._worldUpdate) {
                    this._worldUpdate = true;
                    this.event(Laya.Event.TRANSFORM_CHANGED);
                    for (var i = 0,
                    n = this._children.length; i < n; i++) {
                        this._children[i]._onWorldTransform();
                    }
                }
            }
        },
        {
            key: "localPosition",
            get: function get() {
                return this._localPosition;
            },
            set: function set(value) {
                this._localPosition = value;
                this._localUpdate = true;
                this._onWorldTransform();
            }
        },
        {
            key: "localRotation",
            get: function get() {
                if (this._localQuaternionUpdate) {
                    var euler = this._localRotationEuler;
                    Quaternion.createFromYawPitchRoll(euler.y / AnimationTransform3D._angleToRandin, euler.x / AnimationTransform3D._angleToRandin, euler.z / AnimationTransform3D._angleToRandin, this._localRotation);
                    this._localQuaternionUpdate = false;
                }
                return this._localRotation;
            },
            set: function set(value) {
                this._localRotation = value;
                this._locaEulerlUpdate = true;
                this._localQuaternionUpdate = false;
                this._localUpdate = true;
                this._onWorldTransform();
            }
        },
        {
            key: "localScale",
            get: function get() {
                return this._localScale;
            },
            set: function set(value) {
                this._localScale = value;
                this._localUpdate = true;
                this._onWorldTransform();
            }
        },
        {
            key: "localRotationEuler",
            get: function get() {
                if (this._locaEulerlUpdate) {
                    this._localRotation.getYawPitchRoll(AnimationTransform3D._tempVector3);
                    var euler = AnimationTransform3D._tempVector3;
                    var localRotationEuler = this._localRotationEuler;
                    localRotationEuler.x = euler.y * AnimationTransform3D._angleToRandin;
                    localRotationEuler.y = euler.x * AnimationTransform3D._angleToRandin;
                    localRotationEuler.z = euler.z * AnimationTransform3D._angleToRandin;
                    this._locaEulerlUpdate = false;
                }
                return this._localRotationEuler;
            },
            set: function set(value) {
                this._localRotationEuler = value;
                this._locaEulerlUpdate = false;
                this._localQuaternionUpdate = true;
                this._localUpdate = true;
                this._onWorldTransform();
            }
        },
        {
            key: "getWorldMatrix",
            value: function getWorldMatrix() {
                if (this._worldUpdate) {
                    if (this._parent != null) {
                        Utils3D.matrix4x4MultiplyFFF(this._parent.getWorldMatrix(), this._getlocalMatrix(), this._worldMatrix);
                    } else {
                        var e = this._worldMatrix;
                        e[1] = e[2] = e[3] = e[4] = e[6] = e[7] = e[8] = e[9] = e[11] = e[12] = e[13] = e[14] = 0;
                        e[0] = e[5] = e[10] = e[15] = 1;
                    }
                    this._worldUpdate = false;
                }
                return this._worldMatrix;
            }
        },
        {
            key: "setParent",
            value: function setParent(value) {
                if (this._parent !== value) {
                    if (this._parent) {
                        var parentChilds = this._parent._children;
                        var index = parentChilds.indexOf(this);
                        parentChilds.splice(index, 1);
                    }
                    if (value) {
                        value._children.push(this);
                        value && this._onWorldTransform();
                    }
                    this._parent = value;
                }
            }
        }]);
        return AnimationTransform3D;
    } (Laya.EventDispatcher);
    AnimationTransform3D._tempVector3 = new Vector3();
    AnimationTransform3D._angleToRandin = 180 / Math.PI;
    var AnimationNode =
    /*#__PURE__*/
    function() {
        function AnimationNode() {
            _classCallCheck(this, AnimationNode);
            this._parent = null;
            this.name = null;
            this._worldMatrixIndex = 0;
            this._children = [];
            this.transform = new AnimationTransform3D(this);
        }
        _createClass(AnimationNode, [{
            key: "addChild",
            value: function addChild(child) {
                child._parent = this;
                child.transform.setParent(this.transform);
                this._children.push(child);
            }
        },
        {
            key: "removeChild",
            value: function removeChild(child) {
                var index = this._children.indexOf(child);
                index !== -1 && this._children.splice(index, 1);
            }
        },
        {
            key: "getChildByName",
            value: function getChildByName(name) {
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    if (child.name === name) return child;
                }
                return null;
            }
        },
        {
            key: "getChildByIndex",
            value: function getChildByIndex(index) {
                return this._children[index];
            }
        },
        {
            key: "getChildCount",
            value: function getChildCount() {
                return this._children.length;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destNode = destObject;
                destNode.name = this.name;
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    var destChild = child.clone();
                    destNode.addChild(destChild);
                    var transform = child.transform;
                    var destTransform = destChild.transform;
                    var destLocalPosition = destTransform.localPosition;
                    var destLocalRotation = destTransform.localRotation;
                    var destLocalScale = destTransform.localScale;
                    transform.localPosition.cloneTo(destLocalPosition);
                    transform.localRotation.cloneTo(destLocalRotation);
                    transform.localScale.cloneTo(destLocalScale);
                    destTransform.localPosition = destLocalPosition;
                    destTransform.localRotation = destLocalRotation;
                    destTransform.localScale = destLocalScale;
                }
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new AnimationNode();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "_cloneNative",
            value: function _cloneNative(localPositions, localRotations, localScales, animationNodeWorldMatrixs, animationNodeParentIndices, parentIndex, avatar) {
                var curID = avatar._nativeCurCloneCount;
                animationNodeParentIndices[curID] = parentIndex;
                var dest = new AnimationNode();
                dest._worldMatrixIndex = curID;
                this._cloneToNative(dest, localPositions, localRotations, localScales, animationNodeWorldMatrixs, animationNodeParentIndices, curID, avatar);
                return dest;
            }
        },
        {
            key: "_cloneToNative",
            value: function _cloneToNative(destObject, localPositions, localRotations, localScales, animationNodeWorldMatrixs, animationNodeParentIndices, parentIndex, avatar) {
                var destNode = destObject;
                destNode.name = this.name;
                for (var i = 0,
                n = this._children.length; i < n; i++) {
                    var child = this._children[i];
                    avatar._nativeCurCloneCount++;
                    var destChild = child._cloneNative(localPositions, localRotations, localScales, animationNodeWorldMatrixs, animationNodeParentIndices, parentIndex, avatar);
                    destNode.addChild(destChild);
                    var transform = child.transform;
                    var destTransform = destChild.transform;
                    var destLocalPosition = destTransform.localPosition;
                    var destLocalRotation = destTransform.localRotation;
                    var destLocalScale = destTransform.localScale;
                    transform.localPosition.cloneTo(destLocalPosition);
                    transform.localRotation.cloneTo(destLocalRotation);
                    transform.localScale.cloneTo(destLocalScale);
                    destTransform.localPosition = destLocalPosition;
                    destTransform.localRotation = destLocalRotation;
                    destTransform.localScale = destLocalScale;
                }
            }
        }]);
        return AnimationNode;
    } ();
    var Avatar =
    /*#__PURE__*/
    function(_Laya$Resource4) {
        _inherits(Avatar, _Laya$Resource4);
        var _super22 = _createSuper(Avatar);
        function Avatar() {
            var _this20;
            _classCallCheck(this, Avatar);
            _this20 = _super22.call(this);
            _this20._nativeNodeCount = 0;
            _this20._nativeCurCloneCount = 0;
            return _this20;
        }
        _createClass(Avatar, [{
            key: "_initCloneToAnimator",
            value: function _initCloneToAnimator(destNode, destAnimator) {
                destAnimator._avatarNodeMap[destNode.name] = destNode;
                for (var i = 0,
                n = destNode.getChildCount(); i < n; i++) {
                    this._initCloneToAnimator(destNode.getChildByIndex(i), destAnimator);
                }
            }
        },
        {
            key: "_parseNode",
            value: function _parseNode(nodaData, node) {
                var name = nodaData.props.name;
                node.name = name;
                var props = nodaData.props;
                var transform = node.transform;
                var pos = transform.localPosition;
                var rot = transform.localRotation;
                var sca = transform.localScale;
                pos.fromArray(props.translate);
                rot.fromArray(props.rotation);
                sca.fromArray(props.scale);
                transform.localPosition = pos;
                transform.localRotation = rot;
                transform.localScale = sca;
                var childrenData = nodaData.child;
                for (var j = 0,
                n = childrenData.length; j < n; j++) {
                    var childData = childrenData[j];
                    var childBone = new AnimationNode();
                    node.addChild(childBone);
                    this._parseNode(childData, childBone);
                }
            }
        },
        {
            key: "_cloneDatasToAnimator",
            value: function _cloneDatasToAnimator(destAnimator) {
                var destRoot;
                destRoot = this._rootNode.clone();
                var transform = this._rootNode.transform;
                var destTransform = destRoot.transform;
                var destPosition = destTransform.localPosition;
                var destRotation = destTransform.localRotation;
                var destScale = destTransform.localScale;
                transform.localPosition.cloneTo(destPosition);
                transform.localRotation.cloneTo(destRotation);
                transform.localScale.cloneTo(destScale);
                destTransform.localPosition = destPosition;
                destTransform.localRotation = destRotation;
                destTransform.localScale = destScale;
                destAnimator._avatarNodeMap = {};
                this._initCloneToAnimator(destRoot, destAnimator);
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destAvatar = destObject;
                var destRoot = this._rootNode.clone();
                destAvatar._rootNode = destRoot;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Avatar();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "_cloneDatasToAnimatorNative",
            value: function _cloneDatasToAnimatorNative(destAnimator) {
                var animationNodeLocalPositions = new Float32Array(this._nativeNodeCount * 3);
                var animationNodeLocalRotations = new Float32Array(this._nativeNodeCount * 4);
                var animationNodeLocalScales = new Float32Array(this._nativeNodeCount * 3);
                var animationNodeWorldMatrixs = new Float32Array(this._nativeNodeCount * 16);
                var animationNodeParentIndices = new Int16Array(this._nativeNodeCount);
                destAnimator._animationNodeLocalPositions = animationNodeLocalPositions;
                destAnimator._animationNodeLocalRotations = animationNodeLocalRotations;
                destAnimator._animationNodeLocalScales = animationNodeLocalScales;
                destAnimator._animationNodeWorldMatrixs = animationNodeWorldMatrixs;
                destAnimator._animationNodeParentIndices = animationNodeParentIndices;
                this._nativeCurCloneCount = 0;
                var destRoot = this._rootNode._cloneNative(animationNodeLocalPositions, animationNodeLocalRotations, animationNodeLocalScales, animationNodeWorldMatrixs, animationNodeParentIndices, -1, this);
                var transform = this._rootNode.transform;
                var destTransform = destRoot.transform;
                var destPosition = destTransform.localPosition;
                var destRotation = destTransform.localRotation;
                var destScale = destTransform.localScale;
                transform.localPosition.cloneTo(destPosition);
                transform.localRotation.cloneTo(destRotation);
                transform.localScale.cloneTo(destScale);
                destTransform.localPosition = destPosition;
                destTransform.localRotation = destRotation;
                destTransform.localScale = destScale;
                destAnimator._avatarNodeMap = {};
                this._initCloneToAnimator(destRoot, destAnimator);
            }
        }], [{
            key: "_parse",
            value: function _parse(data) {
                var propertyParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var constructParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var avatar = new Avatar();
                avatar._rootNode = new AnimationNode();
                if (data.version) {
                    var rootNode = data.rootNode;
                    rootNode && avatar._parseNode(rootNode, avatar._rootNode);
                }
                return avatar;
            }
        },
        {
            key: "load",
            value: function load(url, complete) {
                Laya.ILaya.loader.create(url, complete, null, Avatar.AVATAR);
            }
        }]);
        return Avatar;
    } (Laya.Resource);
    Avatar.AVATAR = "AVATAR";
    var Material =
    /*#__PURE__*/
    function(_Laya$Resource5) {
        _inherits(Material, _Laya$Resource5);
        var _super23 = _createSuper(Material);
        function Material() {
            var _this21;
            _classCallCheck(this, Material);
            _this21 = _super23.call(this);
            _this21._shaderValues = new ShaderData(_assertThisInitialized(_this21));
            _this21.renderQueue = Material.RENDERQUEUE_OPAQUE;
            _this21.alphaTest = false;
            return _this21;
        }
        _createClass(Material, [{
            key: "shaderData",
            get: function get() {
                return this._shaderValues;
            }
        },
        {
            key: "alphaTestValue",
            get: function get() {
                return this._shaderValues.getNumber(Material.ALPHATESTVALUE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(Material.ALPHATESTVALUE, value);
            }
        },
        {
            key: "alphaTest",
            get: function get() {
                return this.shaderData.hasDefine(Material.SHADERDEFINE_ALPHATEST);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(Material.SHADERDEFINE_ALPHATEST);
                else this._shaderValues.removeDefine(Material.SHADERDEFINE_ALPHATEST);
            }
        },
        {
            key: "depthWrite",
            get: function get() {
                return this._shaderValues.getBool(Material.DEPTH_WRITE);
            },
            set: function set(value) {
                this._shaderValues.setBool(Material.DEPTH_WRITE, value);
            }
        },
        {
            key: "cull",
            get: function get() {
                return this._shaderValues.getInt(Material.CULL);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.CULL, value);
            }
        },
        {
            key: "blend",
            get: function get() {
                return this._shaderValues.getInt(Material.BLEND);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.BLEND, value);
            }
        },
        {
            key: "blendSrc",
            get: function get() {
                return this._shaderValues.getInt(Material.BLEND_SRC);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.BLEND_SRC, value);
            }
        },
        {
            key: "blendDst",
            get: function get() {
                return this._shaderValues.getInt(Material.BLEND_DST);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.BLEND_DST, value);
            }
        },
        {
            key: "depthTest",
            get: function get() {
                return this._shaderValues.getInt(Material.DEPTH_TEST);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.DEPTH_TEST, value);
            }
        },
        {
            key: "stencilTest",
            get: function get() {
                return this._shaderValues.getInt(Material.STENCIL_TEST);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.STENCIL_TEST, value);
            }
        },
        {
            key: "stencilWrite",
            get: function get() {
                return this._shaderValues.getBool(Material.STENCIL_WRITE);
            },
            set: function set(value) {
                this._shaderValues.setBool(Material.STENCIL_WRITE, value);
            }
        },
        {
            key: "stencilRef",
            get: function get() {
                return this._shaderValues.getInt(Material.STENCIL_Ref);
            },
            set: function set(value) {
                this._shaderValues.setInt(Material.STENCIL_Ref, value);
            }
        },
        {
            key: "stencilOp",
            get: function get() {
                return this._shaderValues.getVector3(Material.STENCIL_Op);
            },
            set: function set(value) {
                this._shaderValues.setVector3(Material.STENCIL_Op, value);
            }
        },
        {
            key: "MaterialProperty",
            get: function get() {
                var propertyMap = {};
                var shaderValues = this._shaderValues.getData();
                for (var key in shaderValues) {
                    propertyMap[Shader3D._propertyNameMap[parseInt(key)]] = shaderValues[key];
                }
                return propertyMap;
            }
        },
        {
            key: "MaterialDefine",
            get: function get() {
                var shaderDefineArray = new Array();
                var defineData = this._shaderValues._defineDatas;
                Shader3D._getNamesByDefineData(defineData, shaderDefineArray);
                return shaderDefineArray;
            }
        },
        {
            key: "_removeTetxureReference",
            value: function _removeTetxureReference() {
                var data = this._shaderValues.getData();
                for (var k in data) {
                    var value = data[k];
                    if (value && value instanceof Laya.BaseTexture) value._removeReference();
                }
            }
        },
        {
            key: "_disposeResource",
            value: function _disposeResource() {
                if (this._referenceCount > 0) this._removeTetxureReference();
                this._shaderValues = null;
            }
        },
        {
            key: "_addReference",
            value: function _addReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                _get(_getPrototypeOf(Material.prototype), "_addReference", this).call(this, count);
                var data = this._shaderValues.getData();
                for (var k in data) {
                    var value = data[k];
                    if (value && value instanceof Laya.BaseTexture) value._addReference();
                }
            }
        },
        {
            key: "_removeReference",
            value: function _removeReference() {
                var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                _get(_getPrototypeOf(Material.prototype), "_removeReference", this).call(this, count);
                this._removeTetxureReference();
            }
        },
        {
            key: "setShaderName",
            value: function setShaderName(name) {
                this._shader = Shader3D.find(name);
                if (!this._shader) throw new Error("BaseMaterial: unknown shader name.");
            }
        },
        {
            key: "setShaderPropertyValue",
            value: function setShaderPropertyValue(name, value) {
                this.shaderData.setValueData(Shader3D.propertyNameToID(name), value);
            }
        },
        {
            key: "getShaderPropertyValue",
            value: function getShaderPropertyValue(name) {
                return this.shaderData.getValueData(Shader3D.propertyNameToID(name));
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destBaseMaterial = destObject;
                destBaseMaterial.name = this.name;
                destBaseMaterial.renderQueue = this.renderQueue;
                this._shaderValues.cloneTo(destBaseMaterial._shaderValues);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Material();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "_defineDatas",
            get: function get() {
                return this._shaderValues._defineDatas;
            }
        }], [{
            key: "load",
            value: function load(url, complete) {
                Laya.Laya.loader.create(url, complete, null, Material.MATERIAL);
            }
        },
        {
            key: "__initDefine__",
            value: function __initDefine__() {
                Material.SHADERDEFINE_ALPHATEST = Shader3D.getDefineByName("ALPHATEST");
            }
        },
        {
            key: "_parse",
            value: function _parse(data) {
                var propertyParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var constructParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var jsonData = data;
                var props = jsonData.props;
                var material;
                var classType = props.type;
                var clas = Laya.ClassUtils.getRegClass(classType);
                if (clas) material = new clas();
                else {
                    material = new Material();
                    material.setShaderName(classType);
                }
                switch (jsonData.version) {
                case "LAYAMATERIAL:01":
                case "LAYAMATERIAL:02":
                    var i, n;
                    for (var key in props) {
                        switch (key) {
                        case "type":
                            break;
                        case "vectors":
                            var vectors = props[key];
                            for (i = 0, n = vectors.length; i < n; i++) {
                                var vector = vectors[i];
                                var vectorValue = vector.value;
                                switch (vectorValue.length) {
                                case 2:
                                    material[vector.name] = new Vector2(vectorValue[0], vectorValue[1]);
                                    break;
                                case 3:
                                    material[vector.name] = new Vector3(vectorValue[0], vectorValue[1], vectorValue[2]);
                                    break;
                                case 4:
                                    material[vector.name] = new Vector4(vectorValue[0], vectorValue[1], vectorValue[2], vectorValue[3]);
                                    break;
                                default:
                                    throw new Error("BaseMaterial:unkonwn color length.");
                                }
                            }
                            break;
                        case "textures":
                            var textures = props[key];
                            for (i = 0, n = textures.length; i < n; i++) {
                                var texture = textures[i];
                                var path = texture.path;
                                path && (material[texture.name] = Laya.Loader.getRes(path));
                            }
                            break;
                        case "defines":
                            var defineNames = props[key];
                            for (i = 0, n = defineNames.length; i < n; i++) {
                                var define = Shader3D.getDefineByName(defineNames[i]);
                                material._shaderValues.addDefine(define);
                            }
                            break;
                        case "renderStates":
                            var renderStatesData = props[key];
                            var renderStateData = renderStatesData[0];
                            var mat = material;
                            mat.blend = renderStateData.blend;
                            mat.cull = renderStateData.cull;
                            mat.depthTest = renderStateData.depthTest;
                            mat.depthWrite = renderStateData.depthWrite;
                            mat.blendSrc = renderStateData.srcBlend;
                            mat.blendDst = renderStateData.dstBlend;
                            break;
                        case "cull":
                            material.cull = props[key];
                            break;
                        case "blend":
                            material.blend = props[key];
                            break;
                        case "depthWrite":
                            material.depthWrite = props[key];
                            break;
                        case "srcBlend":
                            material.blendSrc = props[key];
                            break;
                        case "dstBlend":
                            material.blendDst = props[key];
                            break;
                        default:
                            material[key] = props[key];
                        }
                    }
                    break;
                case "LAYAMATERIAL:03":
                    var i, n;
                    for (var key in props) {
                        switch (key) {
                        case "type":
                        case "name":
                            break;
                        case "defines":
                            var defineNames = props[key];
                            for (i = 0, n = defineNames.length; i < n; i++) {
                                var define = Shader3D.getDefineByName(defineNames[i]);
                                material._shaderValues.addDefine(define);
                            }
                            break;
                        case "textures":
                            var textures = props[key];
                            for (i = 0, n = textures.length; i < n; i++) {
                                var texture = textures[i];
                                var path = texture.path;
                                path && material._shaderValues.setTexture(Shader3D.propertyNameToID(texture.name), Laya.Loader.getRes(path));
                            }
                            break;
                        default:
                            var property = props[key];
                            var uniName = Shader3D.propertyNameToID(key);
                            if (!property.length) {
                                material._shaderValues.setNumber(uniName, props[key]);
                            } else {
                                var vectorValue = property;
                                switch (vectorValue.length) {
                                case 2:
                                    material._shaderValues.setVector2(uniName, new Vector2(vectorValue[0], vectorValue[1]));
                                    break;
                                case 3:
                                    material._shaderValues.setVector3(uniName, new Vector3(vectorValue[0], vectorValue[1], vectorValue[2]));
                                    break;
                                case 4:
                                    material._shaderValues.setVector(uniName, new Vector4(vectorValue[0], vectorValue[1], vectorValue[2], vectorValue[3]));
                                    break;
                                default:
                                    throw new Error("BaseMaterial:unkonwn color length.");
                                }
                            }
                        }
                    }
                    break;
                default:
                    throw new Error("BaseMaterial:unkonwn version.");
                }
                return material;
            }
        }]);
        return Material;
    } (Laya.Resource);
    Material.MATERIAL = "MATERIAL";
    Material.RENDERQUEUE_OPAQUE = 2000;
    Material.RENDERQUEUE_ALPHATEST = 2450;
    Material.RENDERQUEUE_TRANSPARENT = 3000;
    Material.ALPHATESTVALUE = Shader3D.propertyNameToID("u_AlphaTestValue");
    Material.CULL = Shader3D.propertyNameToID("s_Cull");
    Material.BLEND = Shader3D.propertyNameToID("s_Blend");
    Material.BLEND_SRC = Shader3D.propertyNameToID("s_BlendSrc");
    Material.BLEND_DST = Shader3D.propertyNameToID("s_BlendDst");
    Material.DEPTH_TEST = Shader3D.propertyNameToID("s_DepthTest");
    Material.DEPTH_WRITE = Shader3D.propertyNameToID("s_DepthWrite");
    Material.STENCIL_TEST = Shader3D.propertyNameToID("s_StencilTest");
    Material.STENCIL_WRITE = Shader3D.propertyNameToID("s_StencilWrite");
    Material.STENCIL_Ref = Shader3D.propertyNameToID("s_StencilRef");
    Material.STENCIL_Op = Shader3D.propertyNameToID("s_StencilOp");
    var BaseMaterial =
    /*#__PURE__*/
    function() {
        function BaseMaterial() {
            _classCallCheck(this, BaseMaterial);
        }
        _createClass(BaseMaterial, null, [{
            key: "load",
            value: function load(url, complete) {
                Laya.Laya.loader.create(url, complete, null, Material.MATERIAL);
            }
        },
        {
            key: "__initDefine__",
            value: function __initDefine__() {
                BaseMaterial.SHADERDEFINE_ALPHATEST = Material.SHADERDEFINE_ALPHATEST;
            }
        }]);
        return BaseMaterial;
    } ();
    BaseMaterial.MATERIAL = "MATERIAL";
    BaseMaterial.RENDERQUEUE_OPAQUE = 2000;
    BaseMaterial.RENDERQUEUE_ALPHATEST = 2450;
    BaseMaterial.RENDERQUEUE_TRANSPARENT = 3000;
    BaseMaterial.ALPHATESTVALUE = Shader3D.propertyNameToID("u_AlphaTestValue");
    var RenderState =
    /*#__PURE__*/
    function() {
        function RenderState() {
            _classCallCheck(this, RenderState);
            this.cull = RenderState.CULL_BACK;
            this.blend = RenderState.BLEND_DISABLE;
            this.srcBlend = RenderState.BLENDPARAM_ONE;
            this.dstBlend = RenderState.BLENDPARAM_ZERO;
            this.srcBlendRGB = RenderState.BLENDPARAM_ONE;
            this.dstBlendRGB = RenderState.BLENDPARAM_ZERO;
            this.srcBlendAlpha = RenderState.BLENDPARAM_ONE;
            this.dstBlendAlpha = RenderState.BLENDPARAM_ZERO;
            this.blendConstColor = new Vector4(1, 1, 1, 1);
            this.blendEquation = RenderState.BLENDEQUATION_ADD;
            this.blendEquationRGB = RenderState.BLENDEQUATION_ADD;
            this.blendEquationAlpha = RenderState.BLENDEQUATION_ADD;
            this.depthTest = RenderState.DEPTHTEST_LEQUAL;
            this.depthWrite = true;
            this.stencilRef = 1;
            this.stencilTest = RenderState.STENCILTEST_OFF;
            this.stencilWrite = false;
            this.stencilOp = new Vector3(RenderState.STENCILOP_KEEP, RenderState.STENCILOP_KEEP, RenderState.STENCILOP_REPLACE);
        }
        _createClass(RenderState, [{
            key: "cloneTo",
            value: function cloneTo(dest) {
                var destState = dest;
                destState.cull = this.cull;
                destState.blend = this.blend;
                destState.srcBlend = this.srcBlend;
                destState.dstBlend = this.dstBlend;
                destState.srcBlendRGB = this.srcBlendRGB;
                destState.dstBlendRGB = this.dstBlendRGB;
                destState.srcBlendAlpha = this.srcBlendAlpha;
                destState.dstBlendAlpha = this.dstBlendAlpha;
                this.blendConstColor.cloneTo(destState.blendConstColor);
                destState.blendEquation = this.blendEquation;
                destState.blendEquationRGB = this.blendEquationRGB;
                destState.blendEquationAlpha = this.blendEquationAlpha;
                destState.depthTest = this.depthTest;
                destState.depthWrite = this.depthWrite;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new RenderState();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "__init__",
            value: function __init__(gl) {
                RenderState.STENCILOP_KEEP = gl.KEEP;
                RenderState.STENCILOP_ZERO = gl.ZERO;
                RenderState.STENCILOP_REPLACE = gl.REPLACE;
                RenderState.STENCILOP_INCR = gl.INCR;
                RenderState.STENCILOP_INCR_WRAP = gl.INCR_WRAP;
                RenderState.STENCILOP_DECR = gl.DECR;
                RenderState.STENCILOP_DECR_WRAP = gl.DECR_WRAP;
                RenderState.STENCILOP_INVERT = gl.INVERT;
            }
        }]);
        return RenderState;
    } ();
    RenderState.CULL_NONE = 0;
    RenderState.CULL_FRONT = 1;
    RenderState.CULL_BACK = 2;
    RenderState.BLEND_DISABLE = 0;
    RenderState.BLEND_ENABLE_ALL = 1;
    RenderState.BLEND_ENABLE_SEPERATE = 2;
    RenderState.BLENDPARAM_ZERO = 0;
    RenderState.BLENDPARAM_ONE = 1;
    RenderState.BLENDPARAM_SRC_COLOR = 0x0300;
    RenderState.BLENDPARAM_ONE_MINUS_SRC_COLOR = 0x0301;
    RenderState.BLENDPARAM_DST_COLOR = 0x0306;
    RenderState.BLENDPARAM_ONE_MINUS_DST_COLOR = 0x0307;
    RenderState.BLENDPARAM_SRC_ALPHA = 0x0302;
    RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA = 0x0303;
    RenderState.BLENDPARAM_DST_ALPHA = 0x0304;
    RenderState.BLENDPARAM_ONE_MINUS_DST_ALPHA = 0x0305;
    RenderState.BLENDPARAM_SRC_ALPHA_SATURATE = 0x0308;
    RenderState.BLENDEQUATION_ADD = 0x8006;
    RenderState.BLENDEQUATION_SUBTRACT = 0x800A;
    RenderState.BLENDEQUATION_REVERSE_SUBTRACT = 0x800B;
    RenderState.DEPTHTEST_OFF = 0;
    RenderState.DEPTHTEST_NEVER = 0x0200;
    RenderState.DEPTHTEST_LESS = 0x0201;
    RenderState.DEPTHTEST_EQUAL = 0x0202;
    RenderState.DEPTHTEST_LEQUAL = 0x0203;
    RenderState.DEPTHTEST_GREATER = 0x0204;
    RenderState.DEPTHTEST_NOTEQUAL = 0x0205;
    RenderState.DEPTHTEST_GEQUAL = 0x0206;
    RenderState.DEPTHTEST_ALWAYS = 0x0207;
    RenderState.STENCILTEST_OFF = 0;
    RenderState.STENCILTEST_NEVER = 0x0200;
    RenderState.STENCILTEST_LESS = 0x0201;
    RenderState.STENCILTEST_EQUAL = 0x0202;
    RenderState.STENCILTEST_LEQUAL = 0x0203;
    RenderState.STENCILTEST_GREATER = 0x0204;
    RenderState.STENCILTEST_NOTEQUAL = 0x0205;
    RenderState.STENCILTEST_GEQUAL = 0x0206;
    RenderState.STENCILTEST_ALWAYS = 0x0207;
    var BlinnPhongMaterial =
    /*#__PURE__*/
    function(_Material) {
        _inherits(BlinnPhongMaterial, _Material);
        var _super24 = _createSuper(BlinnPhongMaterial);
        function BlinnPhongMaterial() {
            var _this22;
            _classCallCheck(this, BlinnPhongMaterial);
            _this22 = _super24.call(this);
            _this22.setShaderName("BLINNPHONG");
            _this22.albedoIntensity = 1.0;
            var sv = _this22._shaderValues;
            sv.setVector(BlinnPhongMaterial.ALBEDOCOLOR, new Vector4(1.0, 1.0, 1.0, 1.0));
            sv.setVector(BlinnPhongMaterial.MATERIALSPECULAR, new Vector4(1.0, 1.0, 1.0, 1.0));
            sv.setNumber(BlinnPhongMaterial.SHININESS, 0.078125);
            sv.setNumber(Material.ALPHATESTVALUE, 0.5);
            sv.setVector(BlinnPhongMaterial.TILINGOFFSET, new Vector4(1.0, 1.0, 0.0, 0.0));
            _this22.albedoIntensity = 1.0;
            _this22.renderMode = BlinnPhongMaterial.RENDERMODE_OPAQUE;
            return _this22;
        }
        _createClass(BlinnPhongMaterial, [{
            key: "_ColorR",
            get: function get() {
                return this.albedoColor.x;
            },
            set: function set(value) {
                var albedoColor = this.albedoColor;
                albedoColor.x = value;
                this.albedoColor = albedoColor;
            }
        },
        {
            key: "_ColorG",
            get: function get() {
                return this.albedoColor.y;
            },
            set: function set(value) {
                var albedoColor = this.albedoColor;
                albedoColor.y = value;
                this.albedoColor = albedoColor;
            }
        },
        {
            key: "_ColorB",
            get: function get() {
                return this.albedoColor.z;
            },
            set: function set(value) {
                var albedoColor = this.albedoColor;
                albedoColor.z = value;
                this.albedoColor = albedoColor;
            }
        },
        {
            key: "_ColorA",
            get: function get() {
                return this.albedoColor.w;
            },
            set: function set(value) {
                var albedoColor = this.albedoColor;
                albedoColor.w = value;
                this.albedoColor = albedoColor;
            }
        },
        {
            key: "_Color",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.ALBEDOCOLOR);
            },
            set: function set(value) {
                this.albedoColor = value;
            }
        },
        {
            key: "_SpecColorR",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).x;
            },
            set: function set(value) {
                this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).x = value;
            }
        },
        {
            key: "_SpecColorG",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).y;
            },
            set: function set(value) {
                this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).y = value;
            }
        },
        {
            key: "_SpecColorB",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).z;
            },
            set: function set(value) {
                this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).z = value;
            }
        },
        {
            key: "_SpecColorA",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).w;
            },
            set: function set(value) {
                this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR).w = value;
            }
        },
        {
            key: "_SpecColor",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR);
            },
            set: function set(value) {
                this.specularColor = value;
            }
        },
        {
            key: "_Shininess",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.SHININESS);
            },
            set: function set(value) {
                value = Math.max(0.0, Math.min(1.0, value));
                this._shaderValues.setNumber(BlinnPhongMaterial.SHININESS, value);
            }
        },
        {
            key: "_MainTex_STX",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET).x;
            },
            set: function set(x) {
                var tilOff = this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
                tilOff.x = x;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STY",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET).y;
            },
            set: function set(y) {
                var tilOff = this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
                tilOff.y = y;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STZ",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET).z;
            },
            set: function set(z) {
                var tilOff = this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
                tilOff.z = z;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STW",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET).w;
            },
            set: function set(w) {
                var tilOff = this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
                tilOff.w = w;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_ST",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
            },
            set: function set(value) {
                this.tilingOffset = value;
            }
        },
        {
            key: "_Cutoff",
            get: function get() {
                return this.alphaTestValue;
            },
            set: function set(value) {
                this.alphaTestValue = value;
            }
        },
        {
            key: "renderMode",
            set: function set(value) {
                switch (value) {
                case BlinnPhongMaterial.RENDERMODE_OPAQUE:
                    this.alphaTest = false;
                    this.renderQueue = Material.RENDERQUEUE_OPAQUE;
                    this.depthWrite = true;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_DISABLE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    break;
                case BlinnPhongMaterial.RENDERMODE_CUTOUT:
                    this.renderQueue = Material.RENDERQUEUE_ALPHATEST;
                    this.alphaTest = true;
                    this.depthWrite = true;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_DISABLE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    break;
                case BlinnPhongMaterial.RENDERMODE_TRANSPARENT:
                    this.renderQueue = Material.RENDERQUEUE_TRANSPARENT;
                    this.alphaTest = false;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_SRC_ALPHA;
                    this.blendDst = RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    break;
                default:
                    throw new Error("Material:renderMode value error.");
                }
            }
        },
        {
            key: "enableVertexColor",
            get: function get() {
                return this._shaderValues.hasDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLEVERTEXCOLOR);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLEVERTEXCOLOR);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLEVERTEXCOLOR);
            }
        },
        {
            key: "tilingOffsetX",
            get: function get() {
                return this._MainTex_STX;
            },
            set: function set(x) {
                this._MainTex_STX = x;
            }
        },
        {
            key: "tilingOffsetY",
            get: function get() {
                return this._MainTex_STY;
            },
            set: function set(y) {
                this._MainTex_STY = y;
            }
        },
        {
            key: "tilingOffsetZ",
            get: function get() {
                return this._MainTex_STZ;
            },
            set: function set(z) {
                this._MainTex_STZ = z;
            }
        },
        {
            key: "tilingOffsetW",
            get: function get() {
                return this._MainTex_STW;
            },
            set: function set(w) {
                this._MainTex_STW = w;
            }
        },
        {
            key: "tilingOffset",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET);
            },
            set: function set(value) {
                if (value) {
                    this._shaderValues.setVector(BlinnPhongMaterial.TILINGOFFSET, value);
                } else {
                    this._shaderValues.getVector(BlinnPhongMaterial.TILINGOFFSET).setValue(1.0, 1.0, 0.0, 0.0);
                }
            }
        },
        {
            key: "albedoColorR",
            get: function get() {
                return this._ColorR;
            },
            set: function set(value) {
                this._ColorR = value;
            }
        },
        {
            key: "albedoColorG",
            get: function get() {
                return this._ColorG;
            },
            set: function set(value) {
                this._ColorG = value;
            }
        },
        {
            key: "albedoColorB",
            get: function get() {
                return this._ColorB;
            },
            set: function set(value) {
                this._ColorB = value;
            }
        },
        {
            key: "albedoColorA",
            get: function get() {
                return this._ColorA;
            },
            set: function set(value) {
                this._ColorA = value;
            }
        },
        {
            key: "albedoColor",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.ALBEDOCOLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(BlinnPhongMaterial.ALBEDOCOLOR, value);
            }
        },
        {
            key: "albedoIntensity",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.AlbedoIntensity);
            },
            set: function set(value) {
                this._shaderValues.setNumber(BlinnPhongMaterial.AlbedoIntensity, value);
            }
        },
        {
            key: "specularColorR",
            get: function get() {
                return this._SpecColorR;
            },
            set: function set(value) {
                this._SpecColorR = value;
            }
        },
        {
            key: "specularColorG",
            get: function get() {
                return this._SpecColorG;
            },
            set: function set(value) {
                this._SpecColorG = value;
            }
        },
        {
            key: "specularColorB",
            get: function get() {
                return this._SpecColorB;
            },
            set: function set(value) {
                this._SpecColorB = value;
            }
        },
        {
            key: "specularColorA",
            get: function get() {
                return this._SpecColorA;
            },
            set: function set(value) {
                this._SpecColorA = value;
            }
        },
        {
            key: "specularColor",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.MATERIALSPECULAR);
            },
            set: function set(value) {
                this._shaderValues.setVector(BlinnPhongMaterial.MATERIALSPECULAR, value);
            }
        },
        {
            key: "shininess",
            get: function get() {
                return this._Shininess;
            },
            set: function set(value) {
                this._Shininess = value;
            }
        },
        {
            key: "albedoTexture",
            get: function get() {
                return this._shaderValues.getTexture(BlinnPhongMaterial.ALBEDOTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_DIFFUSEMAP);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_DIFFUSEMAP);
                this._shaderValues.setTexture(BlinnPhongMaterial.ALBEDOTEXTURE, value);
            }
        },
        {
            key: "normalTexture",
            get: function get() {
                return this._shaderValues.getTexture(BlinnPhongMaterial.NORMALTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_NORMALMAP);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_NORMALMAP);
                this._shaderValues.setTexture(BlinnPhongMaterial.NORMALTEXTURE, value);
            }
        },
        {
            key: "specularTexture",
            get: function get() {
                return this._shaderValues.getTexture(BlinnPhongMaterial.SPECULARTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_SPECULARMAP);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_SPECULARMAP);
                this._shaderValues.setTexture(BlinnPhongMaterial.SPECULARTEXTURE, value);
            }
        },
        {
            key: "enableTransmission",
            get: function get() {
                return this._shaderValues.hasDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLETRANSMISSION);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLETRANSMISSION);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_ENABLETRANSMISSION);
            }
        },
        {
            key: "transmissionRata",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.TRANSMISSIONRATE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(BlinnPhongMaterial.TRANSMISSIONRATE, value);
            }
        },
        {
            key: "backDiffuse",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.IBACKDIFFUSE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(BlinnPhongMaterial.IBACKDIFFUSE, Math.max(value, 1.0));
            }
        },
        {
            key: "backScale",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.IBACKSCALE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(BlinnPhongMaterial.IBACKSCALE, value);
            }
        },
        {
            key: "thinknessTexture",
            get: function get() {
                return this._shaderValues.getTexture(BlinnPhongMaterial.THINKNESSTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(BlinnPhongMaterial.SHADERDEFINE_THICKNESSMAP);
                else this._shaderValues.removeDefine(BlinnPhongMaterial.SHADERDEFINE_THICKNESSMAP);
                this._shaderValues.setTexture(BlinnPhongMaterial.THINKNESSTEXTURE, value);
            }
        },
        {
            key: "transmissionColor",
            get: function get() {
                return this._shaderValues.getVector(BlinnPhongMaterial.TRANSMISSIONCOLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(BlinnPhongMaterial.TRANSMISSIONCOLOR, value);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new BlinnPhongMaterial();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                _get(_getPrototypeOf(BlinnPhongMaterial.prototype), "cloneTo", this).call(this, destObject);
                var destMaterial = destObject;
                destMaterial.albedoIntensity = this.albedoIntensity;
                destMaterial.enableVertexColor = this.enableVertexColor;
                this.albedoColor.cloneTo(destMaterial.albedoColor);
            }
        },
        {
            key: "transmissionRate",
            get: function get() {
                return this._shaderValues.getNumber(BlinnPhongMaterial.TRANSMISSIONRATE);
            }
        }], [{
            key: "__initDefine__",
            value: function __initDefine__() {
                BlinnPhongMaterial.SHADERDEFINE_DIFFUSEMAP = Shader3D.getDefineByName("DIFFUSEMAP");
                BlinnPhongMaterial.SHADERDEFINE_NORMALMAP = Shader3D.getDefineByName("NORMALMAP");
                BlinnPhongMaterial.SHADERDEFINE_SPECULARMAP = Shader3D.getDefineByName("SPECULARMAP");
                BlinnPhongMaterial.SHADERDEFINE_ENABLEVERTEXCOLOR = Shader3D.getDefineByName("ENABLEVERTEXCOLOR");
                BlinnPhongMaterial.SHADERDEFINE_ENABLETRANSMISSION = Shader3D.getDefineByName("ENABLETRANSMISSION");
                BlinnPhongMaterial.SHADERDEFINE_THICKNESSMAP = Shader3D.getDefineByName("THICKNESSMAP");
            }
        }]);
        return BlinnPhongMaterial;
    } (Material);
    BlinnPhongMaterial.RENDERMODE_OPAQUE = 0;
    BlinnPhongMaterial.RENDERMODE_CUTOUT = 1;
    BlinnPhongMaterial.RENDERMODE_TRANSPARENT = 2;
    BlinnPhongMaterial.ALBEDOTEXTURE = Shader3D.propertyNameToID("u_DiffuseTexture");
    BlinnPhongMaterial.NORMALTEXTURE = Shader3D.propertyNameToID("u_NormalTexture");
    BlinnPhongMaterial.SPECULARTEXTURE = Shader3D.propertyNameToID("u_SpecularTexture");
    BlinnPhongMaterial.ALBEDOCOLOR = Shader3D.propertyNameToID("u_DiffuseColor");
    BlinnPhongMaterial.MATERIALSPECULAR = Shader3D.propertyNameToID("u_MaterialSpecular");
    BlinnPhongMaterial.SHININESS = Shader3D.propertyNameToID("u_Shininess");
    BlinnPhongMaterial.TILINGOFFSET = Shader3D.propertyNameToID("u_TilingOffset");
    BlinnPhongMaterial.TRANSMISSIONRATE = Shader3D.propertyNameToID("u_TransmissionRate");
    BlinnPhongMaterial.IBACKDIFFUSE = Shader3D.propertyNameToID("u_BackDiffuse");
    BlinnPhongMaterial.IBACKSCALE = Shader3D.propertyNameToID("u_BackScale");
    BlinnPhongMaterial.THINKNESSTEXTURE = Shader3D.propertyNameToID("u_ThinknessTexture");
    BlinnPhongMaterial.TRANSMISSIONCOLOR = Shader3D.propertyNameToID("u_TransmissionColor");
    BlinnPhongMaterial.AlbedoIntensity = Shader3D.propertyNameToID("u_AlbedoIntensity");
    var EffectMaterial =
    /*#__PURE__*/
    function(_Material2) {
        _inherits(EffectMaterial, _Material2);
        var _super25 = _createSuper(EffectMaterial);
        function EffectMaterial() {
            var _this23;
            _classCallCheck(this, EffectMaterial);
            _this23 = _super25.call(this);
            _this23.setShaderName("Effect");
            _this23._shaderValues.setVector(EffectMaterial.TILINGOFFSET, new Vector4(1.0, 1.0, 0.0, 0.0));
            _this23._shaderValues.setVector(EffectMaterial.TINTCOLOR, new Vector4(1.0, 1.0, 1.0, 1.0));
            _this23.renderMode = EffectMaterial.RENDERMODE_ADDTIVE;
            return _this23;
        }
        _createClass(EffectMaterial, [{
            key: "_TintColorR",
            get: function get() {
                return this.color.x;
            },
            set: function set(value) {
                var co = this.color;
                co.x = value;
                this.color = co;
            }
        },
        {
            key: "_TintColorG",
            get: function get() {
                return this.color.y;
            },
            set: function set(value) {
                var co = this.color;
                co.y = value;
                this.color = co;
            }
        },
        {
            key: "_TintColorB",
            get: function get() {
                return this.color.z;
            },
            set: function set(value) {
                var co = this.color;
                co.z = value;
                this.color = co;
            }
        },
        {
            key: "_TintColorA",
            get: function get() {
                return this.color.w;
            },
            set: function set(value) {
                var co = this.color;
                co.w = value;
                this.color = co;
            }
        },
        {
            key: "_TintColor",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TINTCOLOR);
            },
            set: function set(value) {
                this.color = value;
            }
        },
        {
            key: "_MainTex_STX",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET).x;
            },
            set: function set(x) {
                var tilOff = this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
                tilOff.x = x;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STY",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET).y;
            },
            set: function set(y) {
                var tilOff = this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
                tilOff.y = y;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STZ",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET).z;
            },
            set: function set(z) {
                var tilOff = this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
                tilOff.z = z;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_STW",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET).w;
            },
            set: function set(w) {
                var tilOff = this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
                tilOff.w = w;
                this.tilingOffset = tilOff;
            }
        },
        {
            key: "_MainTex_ST",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
            },
            set: function set(value) {
                this.tilingOffset = value;
            }
        },
        {
            key: "renderMode",
            set: function set(value) {
                switch (value) {
                case EffectMaterial.RENDERMODE_ADDTIVE:
                    this.renderQueue = Material.RENDERQUEUE_TRANSPARENT;
                    this.alphaTest = false;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_NONE;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_SRC_ALPHA;
                    this.blendDst = RenderState.BLENDPARAM_ONE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.addDefine(EffectMaterial.SHADERDEFINE_ADDTIVEFOG);
                    break;
                case EffectMaterial.RENDERMODE_ALPHABLENDED:
                    this.renderQueue = Material.RENDERQUEUE_TRANSPARENT;
                    this.alphaTest = false;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_NONE;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_SRC_ALPHA;
                    this.blendDst = RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.removeDefine(EffectMaterial.SHADERDEFINE_ADDTIVEFOG);
                    break;
                default:
                    throw new Error("MeshEffectMaterial : renderMode value error.");
                }
            }
        },
        {
            key: "colorR",
            get: function get() {
                return this._TintColorR;
            },
            set: function set(value) {
                this._TintColorR = value;
            }
        },
        {
            key: "colorG",
            get: function get() {
                return this._TintColorG;
            },
            set: function set(value) {
                this._TintColorG = value;
            }
        },
        {
            key: "colorB",
            get: function get() {
                return this._TintColorB;
            },
            set: function set(value) {
                this._TintColorB = value;
            }
        },
        {
            key: "colorA",
            get: function get() {
                return this._TintColorA;
            },
            set: function set(value) {
                this._TintColorA = value;
            }
        },
        {
            key: "color",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TINTCOLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(EffectMaterial.TINTCOLOR, value);
            }
        },
        {
            key: "texture",
            get: function get() {
                return this._shaderValues.getTexture(EffectMaterial.MAINTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(EffectMaterial.SHADERDEFINE_MAINTEXTURE);
                else this._shaderValues.removeDefine(EffectMaterial.SHADERDEFINE_MAINTEXTURE);
                this._shaderValues.setTexture(EffectMaterial.MAINTEXTURE, value);
            }
        },
        {
            key: "tilingOffsetX",
            get: function get() {
                return this._MainTex_STX;
            },
            set: function set(x) {
                this._MainTex_STX = x;
            }
        },
        {
            key: "tilingOffsetY",
            get: function get() {
                return this._MainTex_STY;
            },
            set: function set(y) {
                this._MainTex_STY = y;
            }
        },
        {
            key: "tilingOffsetZ",
            get: function get() {
                return this._MainTex_STZ;
            },
            set: function set(z) {
                this._MainTex_STZ = z;
            }
        },
        {
            key: "tilingOffsetW",
            get: function get() {
                return this._MainTex_STW;
            },
            set: function set(w) {
                this._MainTex_STW = w;
            }
        },
        {
            key: "tilingOffset",
            get: function get() {
                return this._shaderValues.getVector(EffectMaterial.TILINGOFFSET);
            },
            set: function set(value) {
                if (value) {
                    this._shaderValues.setVector(EffectMaterial.TILINGOFFSET, value);
                } else {
                    this._shaderValues.getVector(EffectMaterial.TILINGOFFSET).setValue(1.0, 1.0, 0.0, 0.0);
                }
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new EffectMaterial();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "__initDefine__",
            value: function __initDefine__() {
                EffectMaterial.SHADERDEFINE_MAINTEXTURE = Shader3D.getDefineByName("MAINTEXTURE");
                EffectMaterial.SHADERDEFINE_ADDTIVEFOG = Shader3D.getDefineByName("ADDTIVEFOG");
            }
        }]);
        return EffectMaterial;
    } (Material);
    EffectMaterial.RENDERMODE_ADDTIVE = 0;
    EffectMaterial.RENDERMODE_ALPHABLENDED = 1;
    EffectMaterial.MAINTEXTURE = Shader3D.propertyNameToID("u_AlbedoTexture");
    EffectMaterial.TINTCOLOR = Shader3D.propertyNameToID("u_AlbedoColor");
    EffectMaterial.TILINGOFFSET = Shader3D.propertyNameToID("u_TilingOffset");
    var ExtendTerrainMaterial =
    /*#__PURE__*/
    function(_Material3) {
        _inherits(ExtendTerrainMaterial, _Material3);
        var _super26 = _createSuper(ExtendTerrainMaterial);
        function ExtendTerrainMaterial() {
            var _this24;
            _classCallCheck(this, ExtendTerrainMaterial);
            _this24 = _super26.call(this);
            _this24.setShaderName("ExtendTerrain");
            _this24.renderMode = ExtendTerrainMaterial.RENDERMODE_OPAQUE;
            return _this24;
        }
        _createClass(ExtendTerrainMaterial, [{
            key: "splatAlphaTexture",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.SPLATALPHATEXTURE);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.SPLATALPHATEXTURE, value);
            }
        },
        {
            key: "diffuseTexture1",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.DIFFUSETEXTURE1);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.DIFFUSETEXTURE1, value);
                this._setDetailNum(1);
            }
        },
        {
            key: "diffuseTexture2",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.DIFFUSETEXTURE2);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.DIFFUSETEXTURE2, value);
                this._setDetailNum(2);
            }
        },
        {
            key: "diffuseTexture3",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.DIFFUSETEXTURE3);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.DIFFUSETEXTURE3, value);
                this._setDetailNum(3);
            }
        },
        {
            key: "diffuseTexture4",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.DIFFUSETEXTURE4);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.DIFFUSETEXTURE4, value);
                this._setDetailNum(4);
            }
        },
        {
            key: "diffuseTexture5",
            get: function get() {
                return this._shaderValues.getTexture(ExtendTerrainMaterial.DIFFUSETEXTURE5);
            },
            set: function set(value) {
                this._shaderValues.setTexture(ExtendTerrainMaterial.DIFFUSETEXTURE5, value);
                this._setDetailNum(5);
            }
        },
        {
            key: "diffuseScaleOffset1",
            set: function set(scaleOffset1) {
                this._shaderValues.setVector(ExtendTerrainMaterial.DIFFUSESCALEOFFSET1, scaleOffset1);
            }
        },
        {
            key: "diffuseScaleOffset2",
            set: function set(scaleOffset2) {
                this._shaderValues.setVector(ExtendTerrainMaterial.DIFFUSESCALEOFFSET2, scaleOffset2);
            }
        },
        {
            key: "diffuseScaleOffset3",
            set: function set(scaleOffset3) {
                this._shaderValues.setVector(ExtendTerrainMaterial.DIFFUSESCALEOFFSET3, scaleOffset3);
            }
        },
        {
            key: "diffuseScaleOffset4",
            set: function set(scaleOffset4) {
                this._shaderValues.setVector(ExtendTerrainMaterial.DIFFUSESCALEOFFSET4, scaleOffset4);
            }
        },
        {
            key: "diffuseScaleOffset5",
            set: function set(scaleOffset5) {
                this._shaderValues.setVector(ExtendTerrainMaterial.DIFFUSESCALEOFFSET5, scaleOffset5);
            }
        },
        {
            key: "renderMode",
            set: function set(value) {
                switch (value) {
                case ExtendTerrainMaterial.RENDERMODE_OPAQUE:
                    this.renderQueue = Material.RENDERQUEUE_OPAQUE;
                    this.depthWrite = true;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_DISABLE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    break;
                case ExtendTerrainMaterial.RENDERMODE_TRANSPARENT:
                    this.renderQueue = Material.RENDERQUEUE_OPAQUE;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_SRC_ALPHA;
                    this.blendDst = RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA;
                    this.depthTest = RenderState.DEPTHTEST_LEQUAL;
                    break;
                default:
                    throw new Error("ExtendTerrainMaterial:renderMode value error.");
                }
            }
        },
        {
            key: "_setDetailNum",
            value: function _setDetailNum(value) {
                switch (value) {
                case 1:
                    this._shaderValues.addDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5);
                    break;
                case 2:
                    this._shaderValues.addDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5);
                    break;
                case 3:
                    this._shaderValues.addDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5);
                    break;
                case 4:
                    this._shaderValues.addDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5);
                    break;
                case 5:
                    this._shaderValues.addDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3);
                    this._shaderValues.removeDefine(ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4);
                    break;
                }
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new ExtendTerrainMaterial();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "__initDefine__",
            value: function __initDefine__() {
                ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM1 = Shader3D.getDefineByName("ExtendTerrain_DETAIL_NUM1");
                ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM2 = Shader3D.getDefineByName("ExtendTerrain_DETAIL_NUM2");
                ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM3 = Shader3D.getDefineByName("ExtendTerrain_DETAIL_NUM3");
                ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM4 = Shader3D.getDefineByName("ExtendTerrain_DETAIL_NUM4");
                ExtendTerrainMaterial.SHADERDEFINE_DETAIL_NUM5 = Shader3D.getDefineByName("ExtendTerrain_DETAIL_NUM5");
            }
        }]);
        return ExtendTerrainMaterial;
    } (Material);
    ExtendTerrainMaterial.RENDERMODE_OPAQUE = 1;
    ExtendTerrainMaterial.RENDERMODE_TRANSPARENT = 2;
    ExtendTerrainMaterial.SPLATALPHATEXTURE = Shader3D.propertyNameToID("u_SplatAlphaTexture");
    ExtendTerrainMaterial.DIFFUSETEXTURE1 = Shader3D.propertyNameToID("u_DiffuseTexture1");
    ExtendTerrainMaterial.DIFFUSETEXTURE2 = Shader3D.propertyNameToID("u_DiffuseTexture2");
    ExtendTerrainMaterial.DIFFUSETEXTURE3 = Shader3D.propertyNameToID("u_DiffuseTexture3");
    ExtendTerrainMaterial.DIFFUSETEXTURE4 = Shader3D.propertyNameToID("u_DiffuseTexture4");
    ExtendTerrainMaterial.DIFFUSETEXTURE5 = Shader3D.propertyNameToID("u_DiffuseTexture5");
    ExtendTerrainMaterial.DIFFUSESCALEOFFSET1 = Shader3D.propertyNameToID("u_DiffuseScaleOffset1");
    ExtendTerrainMaterial.DIFFUSESCALEOFFSET2 = Shader3D.propertyNameToID("u_DiffuseScaleOffset2");
    ExtendTerrainMaterial.DIFFUSESCALEOFFSET3 = Shader3D.propertyNameToID("u_DiffuseScaleOffset3");
    ExtendTerrainMaterial.DIFFUSESCALEOFFSET4 = Shader3D.propertyNameToID("u_DiffuseScaleOffset4");
    ExtendTerrainMaterial.DIFFUSESCALEOFFSET5 = Shader3D.propertyNameToID("u_DiffuseScaleOffset5"); (function(PBRRenderMode) {
        PBRRenderMode[PBRRenderMode["Opaque"] = 0] = "Opaque";
        PBRRenderMode[PBRRenderMode["Cutout"] = 1] = "Cutout";
        PBRRenderMode[PBRRenderMode["Fade"] = 2] = "Fade";
        PBRRenderMode[PBRRenderMode["Transparent"] = 3] = "Transparent";
    })(exports.PBRRenderMode || (exports.PBRRenderMode = {}));
    var PBRMaterial =
    /*#__PURE__*/
    function(_Material4) {
        _inherits(PBRMaterial, _Material4);
        var _super27 = _createSuper(PBRMaterial);
        function PBRMaterial() {
            var _this25;
            _classCallCheck(this, PBRMaterial);
            _this25 = _super27.call(this);
            _this25._shaderValues.setVector(PBRMaterial.ALBEDOCOLOR, new Vector4(1.0, 1.0, 1.0, 1.0));
            _this25._shaderValues.setVector(PBRMaterial.EMISSIONCOLOR, new Vector4(1.0, 1.0, 1.0, 1.0));
            _this25._shaderValues.setVector(PBRMaterial.TILINGOFFSET, new Vector4(1.0, 1.0, 0.0, 0.0));
            _this25._shaderValues.setNumber(PBRMaterial.SMOOTHNESS, 0.5);
            _this25._shaderValues.setNumber(PBRMaterial.SMOOTHNESSSCALE, 1.0);
            _this25._shaderValues.setNumber(PBRMaterial.OCCLUSIONSTRENGTH, 1.0);
            _this25._shaderValues.setNumber(PBRMaterial.NORMALSCALE, 1.0);
            _this25._shaderValues.setNumber(PBRMaterial.PARALLAXSCALE, 0.001);
            _this25._shaderValues.setNumber(Material.ALPHATESTVALUE, 0.5);
            _this25.renderMode = exports.PBRRenderMode.Opaque;
            return _this25;
        }
        _createClass(PBRMaterial, [{
            key: "albedoColor",
            get: function get() {
                return this._shaderValues.getVector(PBRMaterial.ALBEDOCOLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(PBRMaterial.ALBEDOCOLOR, value);
            }
        },
        {
            key: "albedoTexture",
            get: function get() {
                return this._shaderValues.getTexture(PBRMaterial.ALBEDOTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_ALBEDOTEXTURE);
                else this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_ALBEDOTEXTURE);
                this._shaderValues.setTexture(PBRMaterial.ALBEDOTEXTURE, value);
            }
        },
        {
            key: "normalTexture",
            get: function get() {
                return this._shaderValues.getTexture(PBRMaterial.NORMALTEXTURE);
            },
            set: function set(value) {
                if (value) {
                    this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_NORMALTEXTURE);
                } else {
                    this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_NORMALTEXTURE);
                }
                this._shaderValues.setTexture(PBRMaterial.NORMALTEXTURE, value);
            }
        },
        {
            key: "normalTextureScale",
            get: function get() {
                return this._shaderValues.getNumber(PBRMaterial.NORMALSCALE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(PBRMaterial.NORMALSCALE, value);
            }
        },
        {
            key: "parallaxTexture",
            get: function get() {
                return this._shaderValues.getTexture(PBRMaterial.PARALLAXTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_PARALLAXTEXTURE);
                else this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_PARALLAXTEXTURE);
                this._shaderValues.setTexture(PBRMaterial.PARALLAXTEXTURE, value);
            }
        },
        {
            key: "parallaxTextureScale",
            get: function get() {
                return this._shaderValues.getNumber(PBRMaterial.PARALLAXSCALE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(PBRMaterial.PARALLAXSCALE, Math.max(0.005, Math.min(0.08, value)));
            }
        },
        {
            key: "occlusionTexture",
            get: function get() {
                return this._shaderValues.getTexture(PBRMaterial.OCCLUSIONTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_OCCLUSIONTEXTURE);
                else this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_OCCLUSIONTEXTURE);
                this._shaderValues.setTexture(PBRMaterial.OCCLUSIONTEXTURE, value);
            }
        },
        {
            key: "occlusionTextureStrength",
            get: function get() {
                return this._shaderValues.getNumber(PBRMaterial.OCCLUSIONSTRENGTH);
            },
            set: function set(value) {
                this._shaderValues.setNumber(PBRMaterial.OCCLUSIONSTRENGTH, Math.max(0.0, Math.min(1.0, value)));
            }
        },
        {
            key: "smoothness",
            get: function get() {
                return this._shaderValues.getNumber(PBRMaterial.SMOOTHNESS);
            },
            set: function set(value) {
                this._shaderValues.setNumber(PBRMaterial.SMOOTHNESS, Math.max(0.0, Math.min(1.0, value)));
            }
        },
        {
            key: "smoothnessTextureScale",
            get: function get() {
                return this._shaderValues.getNumber(PBRMaterial.SMOOTHNESSSCALE);
            },
            set: function set(value) {
                this._shaderValues.setNumber(PBRMaterial.SMOOTHNESSSCALE, Math.max(0.0, Math.min(1.0, value)));
            }
        },
        {
            key: "enableEmission",
            get: function get() {
                return this._shaderValues.hasDefine(PBRMaterial.SHADERDEFINE_EMISSION);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_EMISSION);
                else this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_EMISSION);
            }
        },
        {
            key: "emissionColor",
            get: function get() {
                return this._shaderValues.getVector(PBRMaterial.EMISSIONCOLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(PBRMaterial.EMISSIONCOLOR, value);
            }
        },
        {
            key: "emissionTexture",
            get: function get() {
                return this._shaderValues.getTexture(PBRMaterial.EMISSIONTEXTURE);
            },
            set: function set(value) {
                if (value) this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_EMISSIONTEXTURE);
                else this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_EMISSIONTEXTURE);
                this._shaderValues.setTexture(PBRMaterial.EMISSIONTEXTURE, value);
            }
        },
        {
            key: "tilingOffset",
            get: function get() {
                return this._shaderValues.getVector(PBRMaterial.TILINGOFFSET);
            },
            set: function set(value) {
                if (value) {
                    this._shaderValues.setVector(PBRMaterial.TILINGOFFSET, value);
                } else {
                    this._shaderValues.getVector(PBRMaterial.TILINGOFFSET).setValue(1.0, 1.0, 0.0, 0.0);
                }
            }
        },
        {
            key: "renderMode",
            set: function set(value) {
                switch (value) {
                case exports.PBRRenderMode.Opaque:
                    this.alphaTest = false;
                    this.renderQueue = Material.RENDERQUEUE_OPAQUE;
                    this.depthWrite = true;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_DISABLE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_TRANSPARENTBLEND);
                    break;
                case exports.PBRRenderMode.Cutout:
                    this.renderQueue = Material.RENDERQUEUE_ALPHATEST;
                    this.alphaTest = true;
                    this.depthWrite = true;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_DISABLE;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_TRANSPARENTBLEND);
                    break;
                case exports.PBRRenderMode.Fade:
                    this.renderQueue = Material.RENDERQUEUE_TRANSPARENT;
                    this.alphaTest = false;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_SRC_ALPHA;
                    this.blendDst = RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.removeDefine(PBRMaterial.SHADERDEFINE_TRANSPARENTBLEND);
                    break;
                case exports.PBRRenderMode.Transparent:
                    this.renderQueue = Material.RENDERQUEUE_TRANSPARENT;
                    this.alphaTest = false;
                    this.depthWrite = false;
                    this.cull = RenderState.CULL_BACK;
                    this.blend = RenderState.BLEND_ENABLE_ALL;
                    this.blendSrc = RenderState.BLENDPARAM_ONE;
                    this.blendDst = RenderState.BLENDPARAM_ONE_MINUS_SRC_ALPHA;
                    this.depthTest = RenderState.DEPTHTEST_LESS;
                    this._shaderValues.addDefine(PBRMaterial.SHADERDEFINE_TRANSPARENTBLEND);
                    break;
                default:
                    throw new Error("PBRMaterial:unknown renderMode value.");
                }
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                PBRMaterial.SHADERDEFINE_ALBEDOTEXTURE = Shader3D.getDefineByName("ALBEDOTEXTURE");
                PBRMaterial.SHADERDEFINE_NORMALTEXTURE = Shader3D.getDefineByName("NORMALTEXTURE");
                PBRMaterial.SHADERDEFINE_PARALLAXTEXTURE = Shader3D.getDefineByName("PARALLAXTEXTURE");
                PBRMaterial.SHADERDEFINE_OCCLUSIONTEXTURE = Shader3D.getDefineByName("OCCLUSIONTEXTURE");
                PBRMaterial.SHADERDEFINE_EMISSION = Shader3D.getDefineByName("EMISSION");
                PBRMaterial.SHADERDEFINE_EMISSIONTEXTURE = Shader3D.getDefineByName("EMISSIONTEXTURE");
                PBRMaterial.SHADERDEFINE_TRANSPARENTBLEND = Shader3D.getDefineByName("TRANSPARENTBLEND");
                PBRMaterial.SHADERDEFINE_LAYA_PBR_BRDF_HIGH = Shader3D.getDefineByName("LAYA_PBR_BRDF_HIGH");
                PBRMaterial.SHADERDEFINE_LAYA_PBR_BRDF_LOW = Shader3D.getDefineByName("LAYA_PBR_BRDF_LOW");
            }
        }]);
        return PBRMaterial;
    } (Material);
    PBRMaterial.ALBEDOTEXTURE = Shader3D.propertyNameToID("u_AlbedoTexture");
    PBRMaterial.ALBEDOCOLOR = Shader3D.propertyNameToID("u_AlbedoColor");
    PBRMaterial.TILINGOFFSET = Shader3D.propertyNameToID("u_TilingOffset");
    PBRMaterial.NORMALTEXTURE = Shader3D.propertyNameToID("u_NormalTexture");
    PBRMaterial.NORMALSCALE = Shader3D.propertyNameToID("u_NormalScale");
    PBRMaterial.SMOOTHNESS = Shader3D.propertyNameToID("u_Smoothness");
    PBRMaterial.SMOOTHNESSSCALE = Shader3D.propertyNameToID("u_SmoothnessScale");
    PBRMaterial.OCCLUSIONTEXTURE = Shader3D.propertyNameToID("u_OcclusionTexture");
    PBRMaterial.OCCLUSIONSTRENGTH = Shader3D.propertyNameToID("u_occlusionStrength");
    PBRMaterial.PARALLAXTEXTURE = Shader3D.propertyNameToID("u_ParallaxTexture");
    PBRMaterial.PARALLAXSCALE = Shader3D.propertyNameToID("u_ParallaxScale");
    PBRMaterial.EMISSIONTEXTURE = Shader3D.propertyNameToID("u_EmissionTexture");
    PBRMaterial.EMISSIONCOLOR = Shader3D.propertyNameToID("u_EmissionColor");
    PBRMaterial.renderQuality = exports.PBRRenderQuality.High;
    var PBRPS = "#if defined(GL_FRAGMENT_PRECISION_HIGH)//聽鍘熸潵鐨勫啓娉曚細琚垜浠嚜宸辩殑瑙ｆ瀽娴佺▼澶勭悊锛岃€屾垜浠殑瑙ｆ瀽鏄笉璁ゅ唴缃畯鐨勶紝瀵艰嚧琚垹鎺夛紝鎵€浠ユ敼鎴惵爄f聽defined聽浜哱r\n\tprecision highp float;\r\n\tprecision highp int;\r\n#else\r\n\tprecision mediump float;\r\n\tprecision mediump int;\r\n#endif\r\n\r\n#define SETUP_BRDF_INPUT specularSetup\r\n\r\n#include \"Lighting.glsl\";\r\n#include \"PBRFSInput.glsl\";\r\n#include \"LayaPBRBRDF.glsl\";\r\n#include \"GlobalIllumination.glsl\";\r\n#include \"Shadow.glsl\"\r\n#include \"PBRCore.glsl\";\r\n\r\nvoid main()\r\n{\r\n\tfragmentForward();\r\n}";
    var PBRVS = "#include \"PBRVSInput.glsl\";\r\n#include \"Lighting.glsl\";\r\n#include \"PBRVertex.glsl\";\r\n\r\nvoid main()\r\n{\r\n\tvertexForward();\r\n\tgl_Position=remapGLPositionZ(gl_Position);\r\n}";
    var PBRShadowCasterPS = "#if defined(GL_FRAGMENT_PRECISION_HIGH)//聽鍘熸潵鐨勫啓娉曚細琚垜浠嚜宸辩殑瑙ｆ瀽娴佺▼澶勭悊锛岃€屾垜浠殑瑙ｆ瀽鏄笉璁ゅ唴缃畯鐨勶紝瀵艰嚧琚垹鎺夛紝鎵€浠ユ敼鎴惵爄f聽defined聽浜哱r\n\tprecision highp float;\r\n\tprecision highp int;\r\n#else\r\n\tprecision mediump float;\r\n\tprecision mediump int;\r\n#endif\r\n\r\n#include \"ShadowCasterFS.glsl\"\r\n\r\nvoid main()\r\n{\r\n\tgl_FragColor=shadowCasterFragment();\r\n}";
    var PBRShadowCasterVS = "#include \"ShadowCasterVS.glsl\"\r\n\r\nvoid main()\r\n{\r\n\tvec4 positionCS =  shadowCasterVertex();\r\n\tgl_Position=remapGLPositionZ(positionCS);\r\n}";
    var DepthNormalsTextureVS = "#if defined(GL_FRAGMENT_PRECISION_HIGH)//聽鍘熸潵鐨勫啓娉曚細琚垜浠嚜宸辩殑瑙ｆ瀽娴佺▼澶勭悊锛岃€屾垜浠殑瑙ｆ瀽鏄笉璁ゅ唴缃畯鐨勶紝瀵艰嚧琚垹鎺夛紝鎵€浠ユ敼鎴惵爄f聽defined聽浜哱r\n\tprecision highp float;\r\n\tprecision highp int;\r\n#else\r\n\tprecision mediump float;\r\n\tprecision mediump int;\r\n#endif\r\n\r\n#include \"Lighting.glsl\";\r\n#include \"LayaUtile.glsl\"\r\n\r\nattribute vec4 a_Position;\r\nattribute vec3 a_Normal;\r\n\r\n#ifdef BONE\r\n\tconst int c_MaxBoneCount = 24;\r\n\tattribute vec4 a_BoneIndices;\r\n\tattribute vec4 a_BoneWeights;\r\n\tuniform mat4 u_Bones[c_MaxBoneCount];\r\n#endif\r\n\r\n#ifdef GPU_INSTANCE\r\n\tattribute mat4 a_WorldMat;\r\n#else\r\n\tuniform mat4 u_WorldMat;\r\n#endif\r\nuniform mat4 u_View;\r\nuniform mat4 u_ViewProjection;\r\nuniform vec4 u_ProjectionParams;\r\n\r\n//浼犲叆娉曠嚎\r\nvarying vec4 depthNormals;\r\n\r\n\r\nvec4 depthNormalsVertex()\r\n{\r\n\tmat4 worldMat;\r\n\t#ifdef GPU_INSTANCE\r\n\t\tworldMat = a_WorldMat;\r\n\t#else\r\n\t\tworldMat = u_WorldMat;\r\n\t#endif\r\n\t\r\n\t#ifdef BONE\r\n\t\tmat4 skinTransform;\r\n\t \t#ifdef SIMPLEBONE\r\n\t\t\tfloat currentPixelPos;\r\n\t\t\t#ifdef GPU_INSTANCE\r\n\t\t\t\tcurrentPixelPos = a_SimpleTextureParams.x+a_SimpleTextureParams.y;\r\n\t\t\t#else\r\n\t\t\t\tcurrentPixelPos = u_SimpleAnimatorParams.x+u_SimpleAnimatorParams.y;\r\n\t\t\t#endif\r\n\t\t\tfloat offset = 1.0/u_SimpleAnimatorTextureSize;\r\n\t\t\tskinTransform =  loadMatFromTexture(currentPixelPos,int(a_BoneIndices.x),offset) * a_BoneWeights.x;\r\n\t\t\tskinTransform += loadMatFromTexture(currentPixelPos,int(a_BoneIndices.y),offset) * a_BoneWeights.y;\r\n\t\t\tskinTransform += loadMatFromTexture(currentPixelPos,int(a_BoneIndices.z),offset) * a_BoneWeights.z;\r\n\t\t\tskinTransform += loadMatFromTexture(currentPixelPos,int(a_BoneIndices.w),offset) * a_BoneWeights.w;\r\n\t\t#else\r\n\t\t\tskinTransform =  u_Bones[int(a_BoneIndices.x)] * a_BoneWeights.x;\r\n\t\t\tskinTransform += u_Bones[int(a_BoneIndices.y)] * a_BoneWeights.y;\r\n\t\t\tskinTransform += u_Bones[int(a_BoneIndices.z)] * a_BoneWeights.z;\r\n\t\t\tskinTransform += u_Bones[int(a_BoneIndices.w)] * a_BoneWeights.w;\r\n\t\t#endif\r\n\t\tworldMat = worldMat * skinTransform;\r\n\t#endif\r\n\r\n\tvec4 positionWS = worldMat * a_Position;\r\n\r\n\tmat3 worldInvMat;\r\n\t#ifdef BONE\r\n\t\tworldInvMat=INVERSE_MAT(mat3(worldMat*skinTransform));\r\n\t#else\r\n\t\tworldInvMat=INVERSE_MAT(mat3(worldMat));\r\n\t#endif  \r\n\r\n\tvec3 normalWS = normalize(a_Normal*worldInvMat);//if no normalize will cause precision problem\r\n\t//depthNormals.xyz = normalWS;\r\n\t//瀛樺偍View绌洪棿娉曠嚎\r\n\tvec3 normalVS = mat3(u_View) * normalWS;\r\n\tdepthNormals.xyz = normalVS;\r\n\t\r\n\tvec4 positionCS = u_ViewProjection * positionWS;\r\n\tdepthNormals.w = (positionCS.z * 2.0 - positionCS.w)*u_ProjectionParams.w;\r\n\t\r\n    return positionCS;\r\n}\r\n\r\nvoid main()\r\n{\r\n\tvec4 positionCS =  depthNormalsVertex();\r\n\tgl_Position=remapGLPositionZ(positionCS);\r\n}";
    var DepthNormalsTextureFS = "#if defined(GL_FRAGMENT_PRECISION_HIGH)//聽鍘熸潵鐨勫啓娉曚細琚垜浠嚜宸辩殑瑙ｆ瀽娴佺▼澶勭悊锛岃€屾垜浠殑瑙ｆ瀽鏄笉璁ゅ唴缃畯鐨勶紝瀵艰嚧琚垹鎺夛紝鎵€浠ユ敼鎴惵爄f聽defined聽浜哱r\n\tprecision highp float;\r\n\tprecision highp int;\r\n#else\r\n\tprecision mediump float;\r\n\tprecision mediump int;\r\n#endif\r\n#include \"DepthNormalUtil.glsl\";\r\n\r\nvarying vec4 depthNormals;\r\n\r\nvoid main()\r\n{\r\n\tgl_FragColor=depthNormalsFragment(depthNormals);\r\n}";
    var ShaderVariable =
    /*#__PURE__*/
    _createClass(function ShaderVariable() {
        _classCallCheck(this, ShaderVariable);
        this.textureID = -1;
    });
    var ShaderInstance =
    /*#__PURE__*/
    function(_Laya$Resource6) {
        _inherits(ShaderInstance, _Laya$Resource6);
        var _super28 = _createSuper(ShaderInstance);
        function ShaderInstance(vs, ps, attributeMap, uniformMap, shaderPass) {
            var _this26;
            _classCallCheck(this, ShaderInstance);
            _this26 = _super28.call(this);
            _this26._stateParamsMap = [];
            _this26._uploadMark = -1;
            _this26._uploadRenderType = -1;
            _this26._vs = vs;
            _this26._ps = ps;
            _this26._attributeMap = attributeMap;
            _this26._uniformMap = uniformMap;
            _this26._shaderPass = shaderPass;
            _this26._globaluniformMap = {};
            _this26._create();
            _this26.lock = true;
            return _this26;
        }
        _createClass(ShaderInstance, [{
            key: "_create",
            value: function _create() {
                var gl = Laya.LayaGL.instance;
                this._program = gl.createProgram();
                this._vshader = this._createShader(gl, this._vs, gl.VERTEX_SHADER);
                this._pshader = this._createShader(gl, this._ps, gl.FRAGMENT_SHADER);
                gl.attachShader(this._program, this._vshader);
                gl.attachShader(this._program, this._pshader);
                for (var k in this._attributeMap) {
                    gl.bindAttribLocation(this._program, this._attributeMap[k], k);
                }
                gl.linkProgram(this._program);
                if (!Laya.Render.isConchApp && Shader3D.debugMode && !gl.getProgramParameter(this._program, gl.LINK_STATUS)) throw gl.getProgramInfoLog(this._program);
                var sceneParms = [];
                var cameraParms = [];
                var spriteParms = [];
                var materialParms = [];
                var customParms = [];
                this._customUniformParamsMap = [];
                var nUniformNum = gl.getProgramParameter(this._program, gl.ACTIVE_UNIFORMS);
                Laya.WebGLContext.useProgram(gl, this._program);
                this._curActTexIndex = 0;
                var one, i, n;
                for (i = 0; i < nUniformNum; i++) {
                    var uniformData = gl.getActiveUniform(this._program, i);
                    var uniName = uniformData.name;
                    one = new ShaderVariable();
                    one.location = gl.getUniformLocation(this._program, uniName);
                    if (uniName.indexOf('[0]') > 0) {
                        one.name = uniName = uniName.substr(0, uniName.length - 3);
                        one.isArray = true;
                    } else {
                        one.name = uniName;
                        one.isArray = false;
                    }
                    one.type = uniformData.type;
                    this._addShaderUnifiormFun(one);
                    var uniformPeriod = this._uniformMap[uniName];
                    if (uniformPeriod != null) {
                        one.dataOffset = Shader3D.propertyNameToID(uniName);
                        switch (uniformPeriod) {
                        case Shader3D.PERIOD_CUSTOM:
                            customParms.push(one);
                            break;
                        case Shader3D.PERIOD_MATERIAL:
                            materialParms.push(one);
                            break;
                        case Shader3D.PERIOD_SPRITE:
                            spriteParms.push(one);
                            break;
                        case Shader3D.PERIOD_CAMERA:
                            cameraParms.push(one);
                            break;
                        case Shader3D.PERIOD_SCENE:
                            sceneParms.push(one);
                            break;
                        default:
                            throw new Error("Shader3D: period is unkonw.");
                        }
                    } else {
                        one.dataOffset = Shader3D.propertyNameToID(uniName);
                        this._globaluniformMap[uniName] = Shader3D.PERIOD_SCENE;
                        sceneParms.push(one);
                    }
                }
                this._sceneUniformParamsMap = Laya.LayaGL.instance.createCommandEncoder(sceneParms.length * 4 * 5 + 4, 64, true);
                for (i = 0, n = sceneParms.length; i < n; i++) {
                    this._sceneUniformParamsMap.addShaderUniform(sceneParms[i]);
                }
                this._cameraUniformParamsMap = Laya.LayaGL.instance.createCommandEncoder(cameraParms.length * 4 * 5 + 4, 64, true);
                for (i = 0, n = cameraParms.length; i < n; i++) {
                    this._cameraUniformParamsMap.addShaderUniform(cameraParms[i]);
                }
                this._spriteUniformParamsMap = Laya.LayaGL.instance.createCommandEncoder(spriteParms.length * 4 * 5 + 4, 64, true);
                for (i = 0, n = spriteParms.length; i < n; i++) {
                    this._spriteUniformParamsMap.addShaderUniform(spriteParms[i]);
                }
                this._materialUniformParamsMap = Laya.LayaGL.instance.createCommandEncoder(materialParms.length * 4 * 5 + 4, 64, true);
                for (i = 0, n = materialParms.length; i < n; i++) {
                    this._materialUniformParamsMap.addShaderUniform(materialParms[i]);
                }
                this._customUniformParamsMap.length = customParms.length;
                for (i = 0, n = customParms.length; i < n; i++) {
                    var custom = customParms[i];
                    this._customUniformParamsMap[custom.dataOffset] = custom;
                }
                var stateMap = this._shaderPass._stateMap;
                for (var s in stateMap) {
                    this._stateParamsMap[stateMap[s]] = Shader3D.propertyNameToID(s);
                }
            }
        },
        {
            key: "_getRenderState",
            value: function _getRenderState(shaderDatas, stateIndex) {
                var stateID = this._stateParamsMap[stateIndex];
                if (stateID == null) return null;
                else return shaderDatas[stateID];
            }
        },
        {
            key: "_disposeResource",
            value: function _disposeResource() {
                Laya.LayaGL.instance.deleteShader(this._vshader);
                Laya.LayaGL.instance.deleteShader(this._pshader);
                Laya.LayaGL.instance.deleteProgram(this._program);
                this._vshader = this._pshader = this._program = null;
                this._setGPUMemory(0);
                this._curActTexIndex = 0;
            }
        },
        {
            key: "_addShaderUnifiormFun",
            value: function _addShaderUnifiormFun(one) {
                var gl = Laya.LayaGL.instance;
                one.caller = this;
                var isArray = one.isArray;
                switch (one.type) {
                case gl.BOOL:
                    one.fun = this._uniform1i;
                    one.uploadedValue = new Array(1);
                    break;
                case gl.INT:
                    one.fun = isArray ? this._uniform1iv: this._uniform1i;
                    one.uploadedValue = new Array(1);
                    break;
                case gl.FLOAT:
                    one.fun = isArray ? this._uniform1fv: this._uniform1f;
                    one.uploadedValue = new Array(1);
                    break;
                case gl.FLOAT_VEC2:
                    one.fun = isArray ? this._uniform_vec2v: this._uniform_vec2;
                    one.uploadedValue = new Array(2);
                    break;
                case gl.FLOAT_VEC3:
                    one.fun = isArray ? this._uniform_vec3v: this._uniform_vec3;
                    one.uploadedValue = new Array(3);
                    break;
                case gl.FLOAT_VEC4:
                    one.fun = isArray ? this._uniform_vec4v: this._uniform_vec4;
                    one.uploadedValue = new Array(4);
                    break;
                case gl.FLOAT_MAT2:
                    one.fun = this._uniformMatrix2fv;
                    break;
                case gl.FLOAT_MAT3:
                    one.fun = this._uniformMatrix3fv;
                    break;
                case gl.FLOAT_MAT4:
                    one.fun = isArray ? this._uniformMatrix4fv: this._uniformMatrix4f;
                    break;
                case gl.SAMPLER_2D:
                case gl.SAMPLER_2D_SHADOW:
                    gl.uniform1i(one.location, this._curActTexIndex);
                    one.textureID = Laya.WebGLContext._glTextureIDs[this._curActTexIndex++];
                    one.fun = this._uniform_sampler2D;
                    break;
                case 0x8b5f:
                    gl.uniform1i(one.location, this._curActTexIndex);
                    one.textureID = Laya.WebGLContext._glTextureIDs[this._curActTexIndex++];
                    one.fun = this._uniform_sampler3D;
                    break;
                case gl.SAMPLER_CUBE:
                    gl.uniform1i(one.location, this._curActTexIndex);
                    one.textureID = Laya.WebGLContext._glTextureIDs[this._curActTexIndex++];
                    one.fun = this._uniform_samplerCube;
                    break;
                default:
                    throw new Error("compile shader err!");
                }
            }
        },
        {
            key: "_createShader",
            value: function _createShader(gl, str, type) {
                var shader = gl.createShader(type);
                gl.shaderSource(shader, str);
                gl.compileShader(shader);
                if (Shader3D.debugMode && !gl.getShaderParameter(shader, gl.COMPILE_STATUS)) throw gl.getShaderInfoLog(shader);
                return shader;
            }
        },
        {
            key: "_uniform1f",
            value: function _uniform1f(one, value) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== value) {
                    Laya.LayaGL.instance.uniform1f(one.location, uploadedValue[0] = value);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform1fv",
            value: function _uniform1fv(one, value) {
                if (value.length < 4) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                        Laya.LayaGL.instance.uniform1fv(one.location, value);
                        uploadedValue[0] = value[0];
                        uploadedValue[1] = value[1];
                        uploadedValue[2] = value[2];
                        uploadedValue[3] = value[3];
                        return 1;
                    }
                    return 0;
                } else {
                    Laya.LayaGL.instance.uniform1fv(one.location, value);
                    return 1;
                }
            }
        },
        {
            key: "_uniform_vec2",
            value: function _uniform_vec2(one, v) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== v.x || uploadedValue[1] !== v.y) {
                    Laya.LayaGL.instance.uniform2f(one.location, uploadedValue[0] = v.x, uploadedValue[1] = v.y);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_vec2v",
            value: function _uniform_vec2v(one, value) {
                if (value.length < 2) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                        Laya.LayaGL.instance.uniform2fv(one.location, value);
                        uploadedValue[0] = value[0];
                        uploadedValue[1] = value[1];
                        uploadedValue[2] = value[2];
                        uploadedValue[3] = value[3];
                        return 1;
                    }
                    return 0;
                } else {
                    Laya.LayaGL.instance.uniform2fv(one.location, value);
                    return 1;
                }
            }
        },
        {
            key: "_uniform_vec3",
            value: function _uniform_vec3(one, v) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== v.x || uploadedValue[1] !== v.y || uploadedValue[2] !== v.z) {
                    Laya.LayaGL.instance.uniform3f(one.location, uploadedValue[0] = v.x, uploadedValue[1] = v.y, uploadedValue[2] = v.z);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_vec3v",
            value: function _uniform_vec3v(one, v) {
                Laya.LayaGL.instance.uniform3fv(one.location, v);
                return 1;
            }
        },
        {
            key: "_uniform_vec4",
            value: function _uniform_vec4(one, v) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== v.x || uploadedValue[1] !== v.y || uploadedValue[2] !== v.z || uploadedValue[3] !== v.w) {
                    Laya.LayaGL.instance.uniform4f(one.location, uploadedValue[0] = v.x, uploadedValue[1] = v.y, uploadedValue[2] = v.z, uploadedValue[3] = v.w);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_vec4v",
            value: function _uniform_vec4v(one, v) {
                Laya.LayaGL.instance.uniform4fv(one.location, v);
                return 1;
            }
        },
        {
            key: "_uniformMatrix2fv",
            value: function _uniformMatrix2fv(one, value) {
                Laya.LayaGL.instance.uniformMatrix2fv(one.location, false, value);
                return 1;
            }
        },
        {
            key: "_uniformMatrix3fv",
            value: function _uniformMatrix3fv(one, value) {
                Laya.LayaGL.instance.uniformMatrix3fv(one.location, false, value);
                return 1;
            }
        },
        {
            key: "_uniformMatrix4f",
            value: function _uniformMatrix4f(one, m) {
                var value = m.elements;
                Laya.LayaGL.instance.uniformMatrix4fv(one.location, false, value);
                return 1;
            }
        },
        {
            key: "_uniformMatrix4fv",
            value: function _uniformMatrix4fv(one, m) {
                Laya.LayaGL.instance.uniformMatrix4fv(one.location, false, m);
                return 1;
            }
        },
        {
            key: "_uniform1i",
            value: function _uniform1i(one, value) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== value) {
                    Laya.LayaGL.instance.uniform1i(one.location, uploadedValue[0] = value);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform1iv",
            value: function _uniform1iv(one, value) {
                Laya.LayaGL.instance.uniform1iv(one.location, value);
                return 1;
            }
        },
        {
            key: "_uniform_ivec2",
            value: function _uniform_ivec2(one, value) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1]) {
                    Laya.LayaGL.instance.uniform2i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1]);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_ivec2v",
            value: function _uniform_ivec2v(one, value) {
                Laya.LayaGL.instance.uniform2iv(one.location, value);
                return 1;
            }
        },
        {
            key: "_uniform_vec3i",
            value: function _uniform_vec3i(one, value) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2]) {
                    Laya.LayaGL.instance.uniform3i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2]);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_vec3vi",
            value: function _uniform_vec3vi(one, value) {
                Laya.LayaGL.instance.uniform3iv(one.location, value);
                return 1;
            }
        },
        {
            key: "_uniform_vec4i",
            value: function _uniform_vec4i(one, value) {
                var uploadedValue = one.uploadedValue;
                if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                    Laya.LayaGL.instance.uniform4i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2], uploadedValue[3] = value[3]);
                    return 1;
                }
                return 0;
            }
        },
        {
            key: "_uniform_vec4vi",
            value: function _uniform_vec4vi(one, value) {
                Laya.LayaGL.instance.uniform4iv(one.location, value);
                return 1;
            }
        },
        {
            key: "_uniform_sampler2D",
            value: function _uniform_sampler2D(one, texture) {
                var value = texture._getSource() || texture.defaulteTexture._getSource();
                var gl = Laya.LayaGL.instance;
                Laya.WebGLContext.activeTexture(gl, one.textureID);
                Laya.WebGLContext.bindTexture(gl, gl.TEXTURE_2D, value);
                return 0;
            }
        },
        {
            key: "_uniform_sampler3D",
            value: function _uniform_sampler3D(one, texture) {
                var value = texture._getSource() || texture.defaulteTexture._getSource();
                var gl = Laya.LayaGL.instance;
                Laya.WebGLContext.activeTexture(gl, one.textureID);
                Laya.WebGLContext.bindTexture(gl, WebGL2RenderingContext.TEXTURE_3D, value);
                return 0;
            }
        },
        {
            key: "_uniform_samplerCube",
            value: function _uniform_samplerCube(one, texture) {
                var value = texture._getSource() || texture.defaulteTexture._getSource();
                var gl = Laya.LayaGL.instance;
                Laya.WebGLContext.activeTexture(gl, one.textureID);
                Laya.WebGLContext.bindTexture(gl, gl.TEXTURE_CUBE_MAP, value);
                return 0;
            }
        },
        {
            key: "bind",
            value: function bind() {
                return Laya.WebGLContext.useProgram(Laya.LayaGL.instance, this._program);
            }
        },
        {
            key: "uploadUniforms",
            value: function uploadUniforms(shaderUniform, shaderDatas, uploadUnTexture) {
                Laya.Stat.shaderCall += Laya.LayaGLRunner.uploadShaderUniforms(Laya.LayaGL.instance, shaderUniform, shaderDatas, uploadUnTexture);
            }
        },
        {
            key: "uploadRenderStateBlendDepth",
            value: function uploadRenderStateBlendDepth(shaderDatas) {
                var gl = Laya.LayaGL.instance;
                var renderState = this._shaderPass.renderState;
                var datas = shaderDatas.getData();
                var depthWrite = this._getRenderState(datas, Shader3D.RENDER_STATE_DEPTH_WRITE);
                var depthTest = this._getRenderState(datas, Shader3D.RENDER_STATE_DEPTH_TEST);
                var blend = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND);
                var stencilRef = this._getRenderState(datas, Shader3D.RENDER_STATE_STENCIL_REF);
                var stencilTest = this._getRenderState(datas, Shader3D.RENDER_STATE_STENCIL_TEST);
                var stencilWrite = this._getRenderState(datas, Shader3D.RENDER_STATE_STENCIL_WRITE);
                var stencilOp = this._getRenderState(datas, Shader3D.RENDER_STATE_STENCIL_OP);
                depthWrite == null && (depthWrite = renderState.depthWrite);
                depthTest == null && (depthTest = renderState.depthTest);
                blend == null && (blend = renderState.blend);
                stencilRef == null && (stencilRef = renderState.stencilRef);
                stencilTest == null && (stencilTest = renderState.stencilTest);
                stencilWrite == null && (stencilTest = renderState.stencilWrite);
                stencilOp == null && (stencilOp = renderState.stencilOp);
                Laya.WebGLContext.setDepthMask(gl, depthWrite);
                if (depthTest === RenderState.DEPTHTEST_OFF) Laya.WebGLContext.setDepthTest(gl, false);
                else {
                    Laya.WebGLContext.setDepthTest(gl, true);
                    Laya.WebGLContext.setDepthFunc(gl, depthTest);
                }
                switch (blend) {
                case RenderState.BLEND_DISABLE:
                    Laya.WebGLContext.setBlend(gl, false);
                    break;
                case RenderState.BLEND_ENABLE_ALL:
                    var blendEquation = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_EQUATION);
                    var srcBlend = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_SRC);
                    var dstBlend = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_DST);
                    blendEquation == null && (blendEquation = renderState.blendEquation);
                    srcBlend == null && (srcBlend = renderState.srcBlend);
                    dstBlend == null && (dstBlend = renderState.dstBlend);
                    Laya.WebGLContext.setBlend(gl, true);
                    Laya.WebGLContext.setBlendEquation(gl, blendEquation);
                    Laya.WebGLContext.setBlendFunc(gl, srcBlend, dstBlend);
                    break;
                case RenderState.BLEND_ENABLE_SEPERATE:
                    var blendEquationRGB = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_EQUATION_RGB);
                    var blendEquationAlpha = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_EQUATION_ALPHA);
                    var srcRGB = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_SRC_RGB);
                    var dstRGB = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_DST_RGB);
                    var srcAlpha = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_SRC_ALPHA);
                    var dstAlpha = this._getRenderState(datas, Shader3D.RENDER_STATE_BLEND_DST_ALPHA);
                    blendEquationRGB == null && (blendEquationRGB = renderState.blendEquationRGB);
                    blendEquationAlpha == null && (blendEquationAlpha = renderState.blendEquationAlpha);
                    srcRGB == null && (srcRGB = renderState.srcBlendRGB);
                    dstRGB == null && (dstRGB = renderState.dstBlendRGB);
                    srcAlpha == null && (srcAlpha = renderState.srcBlendAlpha);
                    dstAlpha == null && (dstAlpha = renderState.dstBlendAlpha);
                    Laya.WebGLContext.setBlend(gl, true);
                    Laya.WebGLContext.setBlendEquationSeparate(gl, blendEquationRGB, blendEquationAlpha);
                    Laya.WebGLContext.setBlendFuncSeperate(gl, srcRGB, dstRGB, srcAlpha, dstAlpha);
                    break;
                }
                Laya.WebGLContext.setStencilMask(gl, stencilWrite);
                if (stencilTest == RenderState.STENCILTEST_OFF) {
                    Laya.WebGLContext.setStencilTest(gl, false);
                } else {
                    Laya.WebGLContext.setStencilTest(gl, true);
                    Laya.WebGLContext.setStencilFunc(gl, stencilTest, stencilRef);
                }
                Laya.WebGLContext.setstencilOp(gl, stencilOp.x, stencilOp.y, stencilOp.z);
            }
        },
        {
            key: "uploadRenderStateFrontFace",
            value: function uploadRenderStateFrontFace(shaderDatas, isTarget, invertFront) {
                var gl = Laya.LayaGL.instance;
                var renderState = this._shaderPass.renderState;
                var datas = shaderDatas.getData();
                var cull = this._getRenderState(datas, Shader3D.RENDER_STATE_CULL);
                cull == null && (cull = renderState.cull);
                var forntFace;
                switch (cull) {
                case RenderState.CULL_NONE:
                    Laya.WebGLContext.setCullFace(gl, false);
                    break;
                case RenderState.CULL_FRONT:
                    Laya.WebGLContext.setCullFace(gl, true);
                    if (isTarget) {
                        if (invertFront) forntFace = gl.CCW;
                        else forntFace = gl.CW;
                    } else {
                        if (invertFront) forntFace = gl.CW;
                        else forntFace = gl.CCW;
                    }
                    Laya.WebGLContext.setFrontFace(gl, forntFace);
                    break;
                case RenderState.CULL_BACK:
                    Laya.WebGLContext.setCullFace(gl, true);
                    if (isTarget) {
                        if (invertFront) forntFace = gl.CW;
                        else forntFace = gl.CCW;
                    } else {
                        if (invertFront) forntFace = gl.CCW;
                        else forntFace = gl.CW;
                    }
                    Laya.WebGLContext.setFrontFace(gl, forntFace);
                    break;
                }
            }
        },
        {
            key: "uploadCustomUniform",
            value: function uploadCustomUniform(index, data) {
                Laya.Stat.shaderCall += Laya.LayaGLRunner.uploadCustomUniform(Laya.LayaGL.instance, this._customUniformParamsMap, index, data);
            }
        },
        {
            key: "_uniformMatrix2fvForNative",
            value: function _uniformMatrix2fvForNative(one, value) {
                Laya.LayaGL.instance.uniformMatrix2fvEx(one.location, false, value);
                return 1;
            }
        },
        {
            key: "_uniformMatrix3fvForNative",
            value: function _uniformMatrix3fvForNative(one, value) {
                Laya.LayaGL.instance.uniformMatrix3fvEx(one.location, false, value);
                return 1;
            }
        },
        {
            key: "_uniformMatrix4fvForNative",
            value: function _uniformMatrix4fvForNative(one, m) {
                Laya.LayaGL.instance.uniformMatrix4fvEx(one.location, false, m);
                return 1;
            }
        }]);
        return ShaderInstance;
    } (Laya.Resource);
    var Script3D =
    /*#__PURE__*/
    function(_Laya$Component2) {
        _inherits(Script3D, _Laya$Component2);
        var _super29 = _createSuper(Script3D);
        function Script3D() {
            var _this27;
            _classCallCheck(this, Script3D);
            _this27 = _super29.apply(this, arguments);
            _this27._indexInPool = -1;
            _this27._enableState = false;
            return _this27;
        }
        _createClass(Script3D, [{
            key: "isSingleton",
            get: function get() {
                return false;
            }
        },
        {
            key: "_checkProcessTriggers",
            value: function _checkProcessTriggers() {
                var prototype = Script3D.prototype;
                if (this.onTriggerEnter !== prototype.onTriggerEnter) return true;
                if (this.onTriggerStay !== prototype.onTriggerStay) return true;
                if (this.onTriggerExit !== prototype.onTriggerExit) return true;
                return false;
            }
        },
        {
            key: "_checkProcessCollisions",
            value: function _checkProcessCollisions() {
                var prototype = Script3D.prototype;
                if (this.onCollisionEnter !== prototype.onCollisionEnter) return true;
                if (this.onCollisionStay !== prototype.onCollisionStay) return true;
                if (this.onCollisionExit !== prototype.onCollisionExit) return true;
                return false;
            }
        },
        {
            key: "_onAwake",
            value: function _onAwake() {
                this.onAwake();
                if (this.onStart !== Script3D.prototype.onStart) Laya.Laya.startTimer.callLater(this, this.onStart);
            }
        },
        {
            key: "_onEnable",
            value: function _onEnable() {
                if (this._enableState) return;
                this.owner._scene._addScript(this);
                this._enableState = true;
                this.onEnable();
            }
        },
        {
            key: "_onDisable",
            value: function _onDisable() {
                if (!this._enableState || this._indexInPool == -1) return;
                this.owner._scene._removeScript(this);
                this.owner.offAllCaller(this);
                this._enableState = false;
                this.onDisable();
            }
        },
        {
            key: "_onDestroy",
            value: function _onDestroy() {
                var scripts = this.owner._scripts;
                scripts.splice(scripts.indexOf(this), 1);
                var sprite = this.owner;
                sprite._needProcessTriggers = false;
                for (var i = 0,
                n = scripts.length; i < n; i++) {
                    if (scripts[i]._checkProcessTriggers()) {
                        sprite._needProcessTriggers = true;
                        break;
                    }
                }
                sprite._needProcessCollisions = false;
                for (i = 0, n = scripts.length; i < n; i++) {
                    if (scripts[i]._checkProcessCollisions()) {
                        sprite._needProcessCollisions = true;
                        break;
                    }
                }
                this.onDestroy();
            }
        },
        {
            key: "_isScript",
            value: function _isScript() {
                return true;
            }
        },
        {
            key: "_onAdded",
            value: function _onAdded() {
                var sprite = this.owner;
                var scripts = sprite._scripts;
                scripts || (sprite._scripts = scripts = []);
                scripts.push(this);
                if (!sprite._needProcessCollisions) sprite._needProcessCollisions = this._checkProcessCollisions();
                if (!sprite._needProcessTriggers) sprite._needProcessTriggers = this._checkProcessTriggers();
            }
        },
        {
            key: "onAwake",
            value: function onAwake() {}
        },
        {
            key: "onEnable",
            value: function onEnable() {}
        },
        {
            key: "onStart",
            value: function onStart() {}
        },
        {
            key: "onTriggerEnter",
            value: function onTriggerEnter(other) {}
        },
        {
            key: "onTriggerStay",
            value: function onTriggerStay(other) {}
        },
        {
            key: "onTriggerExit",
            value: function onTriggerExit(other) {}
        },
        {
            key: "onCollisionEnter",
            value: function onCollisionEnter(collision) {}
        },
        {
            key: "onCollisionStay",
            value: function onCollisionStay(collision) {}
        },
        {
            key: "onCollisionExit",
            value: function onCollisionExit(collision) {}
        },
        {
            key: "onJointBreak",
            value: function onJointBreak() {}
        },
        {
            key: "onMouseDown",
            value: function onMouseDown() {}
        },
        {
            key: "onMouseDrag",
            value: function onMouseDrag() {}
        },
        {
            key: "onMouseClick",
            value: function onMouseClick() {}
        },
        {
            key: "onMouseUp",
            value: function onMouseUp() {}
        },
        {
            key: "onMouseEnter",
            value: function onMouseEnter() {}
        },
        {
            key: "onMouseOver",
            value: function onMouseOver() {}
        },
        {
            key: "onMouseOut",
            value: function onMouseOut() {}
        },
        {
            key: "onUpdate",
            value: function onUpdate() {}
        },
        {
            key: "onLateUpdate",
            value: function onLateUpdate() {}
        },
        {
            key: "onPreRender",
            value: function onPreRender() {}
        },
        {
            key: "onPostRender",
            value: function onPostRender() {}
        },
        {
            key: "onDisable",
            value: function onDisable() {}
        },
        {
            key: "onDestroy",
            value: function onDestroy() {}
        }]);
        return Script3D;
    } (Laya.Component);
    var SingletonList =
    /*#__PURE__*/
    function() {
        function SingletonList() {
            _classCallCheck(this, SingletonList);
            this.elements = [];
            this.length = 0;
        }
        _createClass(SingletonList, [{
            key: "_add",
            value: function _add(element) {
                if (this.length === this.elements.length) this.elements.push(element);
                else this.elements[this.length] = element;
            }
        },
        {
            key: "add",
            value: function add(element) {
                if (this.length === this.elements.length) this.elements.push(element);
                else this.elements[this.length] = element;
                this.length++;
            }
        }]);
        return SingletonList;
    } ();
    var SimpleSingletonList =
    /*#__PURE__*/
    function(_SingletonList) {
        _inherits(SimpleSingletonList, _SingletonList);
        var _super30 = _createSuper(SimpleSingletonList);
        function SimpleSingletonList() {
            _classCallCheck(this, SimpleSingletonList);
            return _super30.call(this);
        }
        _createClass(SimpleSingletonList, [{
            key: "add",
            value: function add(element) {
                var index = element._getIndexInList();
                if (index !== -1) throw "SimpleSingletonList:" + element + " has  in  SingletonList.";
                this._add(element);
                element._setIndexInList(this.length++);
            }
        },
        {
            key: "remove",
            value: function remove(element) {
                var index = element._getIndexInList();
                if (index === -1) return;
                this.length--;
                if (index !== this.length) {
                    var end = this.elements[this.length];
                    this.elements[index] = end;
                    end._setIndexInList(index);
                }
                element._setIndexInList( - 1);
            }
        },
        {
            key: "clear",
            value: function clear() {
                var elements = this.elements;
                for (var i = 0,
                n = this.length; i < n; i++) {
                    elements[i]._setIndexInList( - 1);
                }
                this.length = 0;
            }
        },
        {
            key: "clearElement",
            value: function clearElement() {
                this.elements = null;
                this.length = 0;
            }
        }]);
        return SimpleSingletonList;
    } (SingletonList);
    var Color =
    /*#__PURE__*/
    function() {
        function Color() {
            var r = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
            var g = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
            var b = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
            var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
            _classCallCheck(this, Color);
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }
        _createClass(Color, [{
            key: "toLinear",
            value: function toLinear(out) {
                out.r = Color.gammaToLinearSpace(this.r);
                out.g = Color.gammaToLinearSpace(this.g);
                out.b = Color.gammaToLinearSpace(this.b);
            }
        },
        {
            key: "toGamma",
            value: function toGamma(out) {
                out.r = Color.linearToGammaSpace(this.r);
                out.g = Color.linearToGammaSpace(this.g);
                out.b = Color.linearToGammaSpace(this.b);
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destColor = destObject;
                destColor.r = this.r;
                destColor.g = this.g;
                destColor.b = this.b;
                destColor.a = this.a;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Color();
                this.cloneTo(dest);
                return dest;
            }
        },
        {
            key: "forNativeElement",
            value: function forNativeElement() {}
        }], [{
            key: "gammaToLinearSpace",
            value: function gammaToLinearSpace(value) {
                if (value <= 0.04045) return value / 12.92;
                else if (value < 1.0) return Math.pow((value + 0.055) / 1.055, 2.4);
                else return Math.pow(value, 2.4);
            }
        },
        {
            key: "linearToGammaSpace",
            value: function linearToGammaSpace(value) {
                if (value <= 0.0) return 0.0;
                else if (value <= 0.0031308) return 12.92 * value;
                else if (value <= 1.0) return 1.055 * Math.pow(value, 0.41666) - 0.055;
                else return Math.pow(value, 0.41666);
            }
        }]);
        return Color;
    } ();
    Color.RED = new Color(1, 0, 0, 1);
    Color.GREEN = new Color(0, 1, 0, 1);
    Color.BLUE = new Color(0, 0, 1, 1);
    Color.CYAN = new Color(0, 1, 1, 1);
    Color.YELLOW = new Color(1, 0.92, 0.016, 1);
    Color.MAGENTA = new Color(1, 0, 1, 1);
    Color.GRAY = new Color(0.5, 0.5, 0.5, 1);
    Color.WHITE = new Color(1, 1, 1, 1);
    Color.BLACK = new Color(0, 0, 0, 1);
    var CameraCullInfo =
    /*#__PURE__*/
    _createClass(function CameraCullInfo() {
        _classCallCheck(this, CameraCullInfo);
    });
    var ShadowCullInfo =
    /*#__PURE__*/
    _createClass(function ShadowCullInfo() {
        _classCallCheck(this, ShadowCullInfo);
    });
    var FrustumCulling =
    /*#__PURE__*/
    function() {
        function FrustumCulling() {
            _classCallCheck(this, FrustumCulling);
        }
        _createClass(FrustumCulling, null, [{
            key: "__init__",
            value: function __init__() {}
        },
        {
            key: "_drawTraversalCullingBound",
            value: function _drawTraversalCullingBound(renderList, debugTool) {
                var renders = renderList.elements;
                for (var i = 0,
                n = renderList.length; i < n; i++) {
                    var color = FrustumCulling._tempColor0;
                    color.r = 0;
                    color.g = 1;
                    color.b = 0;
                    color.a = 1;
                    Utils3D._drawBound(debugTool, renders[i].bounds._getBoundBox(), color);
                }
            }
        },
        {
            key: "_traversalCulling",
            value: function _traversalCulling(cameraCullInfo, scene, context, renderList, customShader, replacementTag, isShadowCasterCull) {
                var renders = renderList.elements;
                var boundFrustum = cameraCullInfo.boundFrustum;
                var camPos = cameraCullInfo.position;
                var cullMask = cameraCullInfo.cullingMask;
                var loopCount = Laya.Stat.loopCount;
                for (var i = 0,
                n = renderList.length; i < n; i++) {
                    var render = renders[i];
                    var canPass = true;
                    if (Config3D._config.distanceVolumCull) {
                        canPass = FrustumCulling.cullDistanceVolume(context, render);
                    }
                    if (isShadowCasterCull) canPass = render._castShadow && render._enable && canPass;
                    else canPass = (Math.pow(2, render._owner._layer) & cullMask) != 0 && render._enable && canPass;
                    if (canPass) {
                        Laya.Stat.frustumCulling++;
                        if (!cameraCullInfo.useOcclusionCulling || render._needRender(boundFrustum, context)) {
                            render._renderMark = loopCount;
                            render._distanceForSort = Vector3.distance(render.bounds.getCenter(), camPos);
                            var elements = render._renderElements;
                            for (var j = 0,
                            m = elements.length; j < m; j++) {
                                elements[j]._update(scene, context, customShader, replacementTag);
                            }
                        }
                    }
                }
            }
        },
        {
            key: "cullDistanceVolume",
            value: function cullDistanceVolume(context, render) {
                var camera = context.camera;
                if (!camera || !camera.transform) return false;
                var bound = render.bounds;
                var center = bound.getCenter();
                var exten = bound.getExtent();
                var dis = Vector3.distance(camera.transform.position, center);
                var volum = Math.max(exten.x, exten.y, exten.z);
                if (volum / dis < render._ratioIgnor) {
                    return false;
                }
                return true;
            }
        },
        {
            key: "renderObjectCulling",
            value: function renderObjectCulling(cameraCullInfo, scene, context, customShader, replacementTag, isShadowCasterCull) {
                var opaqueQueue = scene._opaqueQueue;
                var transparentQueue = scene._transparentQueue;
                var renderList = scene._renders;
                scene._clearRenderQueue();
                var octree = scene._octree;
                if (octree) {
                    octree.preFruUpdate();
                    octree.getCollidingWithFrustum(cameraCullInfo, context, customShader, replacementTag, isShadowCasterCull);
                }
                FrustumCulling._traversalCulling(cameraCullInfo, scene, context, renderList, customShader, replacementTag, isShadowCasterCull);
                if (FrustumCulling.debugFrustumCulling) {
                    var debugTool = scene._debugTool;
                    debugTool.clear();
                    if (octree) {
                        octree.drawAllBounds(debugTool);
                        octree.drawAllObjects(debugTool);
                    }
                    FrustumCulling._drawTraversalCullingBound(renderList, debugTool);
                }
                var count = opaqueQueue.elements.length;
                count > 0 && opaqueQueue._quickSort(0, count - 1);
                count = transparentQueue.elements.length;
                count > 0 && transparentQueue._quickSort(0, count - 1);
            }
        },
        {
            key: "cullingShadow",
            value: function cullingShadow(cullInfo, scene, context) {
                scene._clearRenderQueue();
                var opaqueQueue = scene._opaqueQueue;
                if (scene._octree) {
                    var octree = scene._octree;
                    octree.preFruUpdate();
                    octree.cullingShadow(cullInfo, context);
                }
                var renderList = scene._renders;
                var position = cullInfo.position;
                var renders = renderList.elements;
                var loopCount = Laya.Stat.loopCount;
                for (var i = 0,
                n = renderList.length; i < n; i++) {
                    var render = renders[i];
                    var opaqueRender = render.sharedMaterial && render.sharedMaterial.renderQueue < Material.RENDERQUEUE_TRANSPARENT;
                    var canPass = render._castShadow && render._enable && opaqueRender;
                    if (canPass) {
                        Laya.Stat.frustumCulling++;
                        var pass = FrustumCulling.cullingRenderBounds(render.bounds, cullInfo);
                        if (pass) {
                            render._renderMark = loopCount;
                            render._distanceForSort = Vector3.distance(render.bounds.getCenter(), position);
                            var elements = render._renderElements;
                            for (var j = 0,
                            m = elements.length; j < m; j++) {
                                elements[j]._update(scene, context, null, null);
                            }
                        }
                    }
                }
                return opaqueQueue.elements.length > 0 ? true: false;
            }
        },
        {
            key: "cullingRenderBounds",
            value: function cullingRenderBounds(bounds, cullInfo) {
                var cullPlaneCount = cullInfo.cullPlaneCount;
                var cullPlanes = cullInfo.cullPlanes;
                var min = bounds.getMin();
                var max = bounds.getMax();
                var minX = min.x;
                var minY = min.y;
                var minZ = min.z;
                var maxX = max.x;
                var maxY = max.y;
                var maxZ = max.z;
                var pass = true;
                for (var j = 0; j < cullPlaneCount; j++) {
                    var plane = cullPlanes[j];
                    var normal = plane.normal;
                    if (plane.distance + normal.x * (normal.x < 0.0 ? minX: maxX) + normal.y * (normal.y < 0.0 ? minY: maxY) + normal.z * (normal.z < 0.0 ? minZ: maxZ) < 0.0) {
                        pass = false;
                        break;
                    }
                }
                return pass;
            }
        },
        {
            key: "cullingSpotShadow",
            value: function cullingSpotShadow(cameraCullInfo, scene, context) {
                var opaqueQueue = scene._opaqueQueue;
                scene._clearRenderQueue();
                if (!scene._octree) {
                    var renderList = scene._renders;
                    var renders = renderList.elements;
                    var loopCount = Laya.Stat.loopCount;
                    for (var i = 0,
                    n = renderList.length; i < n; i++) {
                        var render = renders[i];
                        var canPass = render._castShadow && render._enable;
                        if (canPass) {
                            if (render._needRender(cameraCullInfo.boundFrustum, context)) {
                                var bounds = render.bounds;
                                render._renderMark = loopCount;
                                render._distanceForSort = Vector3.distance(bounds.getCenter(), cameraCullInfo.position);
                                var elements = render._renderElements;
                                for (var j = 0,
                                m = elements.length; j < m; j++) {
                                    elements[j]._update(scene, context, null, null);
                                }
                            }
                        }
                    }
                } else {
                    var octree = scene._octree;
                    octree.preFruUpdate();
                    octree.getCollidingWithFrustum(cameraCullInfo, context, null, null, true);
                }
                return opaqueQueue.elements.length > 0 ? true: false;
            }
        },
        {
            key: "renderObjectCullingNative",
            value: function renderObjectCullingNative(camera, scene, context, renderList, customShader, replacementTag) {
                var i, j, m;
                var opaqueQueue = scene._opaqueQueue;
                var transparentQueue = scene._transparentQueue;
                scene._clearRenderQueue();
                var validCount = renderList.length;
                var renders = renderList.elements;
                for (i = 0; i < validCount; i++) {
                    renders[i].bounds;
                    renders[i]._updateForNative && renders[i]._updateForNative(context);
                }
                FrustumCulling.cullingNative(camera._boundFrustumBuffer, FrustumCulling._cullingBuffer, scene._cullingBufferIndices, validCount, scene._cullingBufferResult);
                var loopCount = Laya.Stat.loopCount;
                var camPos = context.camera._transform.position;
                for (i = 0; i < validCount; i++) {
                    var render = renders[i];
                    if (!camera.useOcclusionCulling || camera._isLayerVisible(render._owner._layer) && render._enable && scene._cullingBufferResult[i]) {
                        render._renderMark = loopCount;
                        render._distanceForSort = Vector3.distance(render.bounds.getCenter(), camPos);
                        var elements = render._renderElements;
                        for (j = 0, m = elements.length; j < m; j++) {
                            var element = elements[j];
                            element._update(scene, context, customShader, replacementTag);
                        }
                    }
                }
                var count = opaqueQueue.elements.length;
                count > 0 && opaqueQueue._quickSort(0, count - 1);
                count = transparentQueue.elements.length;
                count > 0 && transparentQueue._quickSort(0, count - 1);
            }
        },
        {
            key: "cullingNative",
            value: function cullingNative(boundFrustumBuffer, cullingBuffer, cullingBufferIndices, cullingCount, cullingBufferResult) {
                return Laya.LayaGL.instance.culling(boundFrustumBuffer, cullingBuffer, cullingBufferIndices, cullingCount, cullingBufferResult);
            }
        }]);
        return FrustumCulling;
    } ();
    FrustumCulling._tempColor0 = new Color();
    FrustumCulling._cameraCullInfo = new CameraCullInfo();
    FrustumCulling._shadowCullInfo = new ShadowCullInfo();
    FrustumCulling.debugFrustumCulling = false;
    var LightBound =
    /*#__PURE__*/
    _createClass(function LightBound() {
        _classCallCheck(this, LightBound);
    });
    var ClusterData =
    /*#__PURE__*/
    _createClass(function ClusterData() {
        _classCallCheck(this, ClusterData);
        this.updateMark = -1;
        this.pointLightCount = 0;
        this.spotLightCount = 0;
        this.indices = [];
    });
    var Cluster =
    /*#__PURE__*/
    function() {
        function Cluster(xSlices, ySlices, zSlices, maxLightsPerClusterAverage) {
            _classCallCheck(this, Cluster);
            this._updateMark = 0;
            this._depthSliceParam = new Vector2();
            this._xSlices = xSlices;
            this._ySlices = ySlices;
            this._zSlices = zSlices;
            var clusterTexWidth = xSlices * ySlices;
            var clisterTexHeight = zSlices * (1 + Math.ceil(maxLightsPerClusterAverage / 4));
            this._clusterTexture = Utils3D._createFloatTextureBuffer(clusterTexWidth, clisterTexHeight);
            this._clusterTexture.lock = true;
            this._clusterPixels = new Float32Array(clusterTexWidth * clisterTexHeight * 4);
            var clusterDatas = new Array(this._zSlices);
            for (var z = 0; z < this._zSlices; z++) {
                clusterDatas[z] = new Array(this._ySlices);
                for (var y = 0; y < this._ySlices; y++) {
                    clusterDatas[z][y] = new Array(this._xSlices);
                    for (var x = 0; x < this._xSlices; x++) {
                        clusterDatas[z][y][x] = new ClusterData();
                    }
                }
            }
            this._clusterDatas = clusterDatas;
        }
        _createClass(Cluster, [{
            key: "_placePointLightToClusters",
            value: function _placePointLightToClusters(lightIndex, lightBound) {
                var clusterDatas = this._clusterDatas;
                var updateMark = this._updateMark;
                for (var z = lightBound.zMin,
                zEnd = lightBound.zMax; z < zEnd; z++) {
                    for (var y = lightBound.yMin,
                    yEnd = lightBound.yMax; y < yEnd; y++) {
                        for (var x = lightBound.xMin,
                        xEnd = lightBound.xMax; x < xEnd; x++) {
                            var data = clusterDatas[z][y][x];
                            if (data.updateMark != updateMark) {
                                data.pointLightCount = 0;
                                data.spotLightCount = 0;
                                data.updateMark = updateMark;
                            }
                            var indices = data.indices;
                            var lightCount = data.pointLightCount++;
                            if (lightCount < indices.length) indices[lightCount] = lightIndex;
                            else indices.push(lightIndex);
                        }
                    }
                }
            }
        },
        {
            key: "_placeSpotLightToClusters",
            value: function _placeSpotLightToClusters(lightIndex, lightBound) {
                var clusterDatas = this._clusterDatas;
                var updateMark = this._updateMark;
                for (var z = lightBound.zMin,
                zEnd = lightBound.zMax; z < zEnd; z++) {
                    for (var y = lightBound.yMin,
                    yEnd = lightBound.yMax; y < yEnd; y++) {
                        for (var x = lightBound.xMin,
                        xEnd = lightBound.xMax; x < xEnd; x++) {
                            var data = clusterDatas[z][y][x];
                            if (data.updateMark != updateMark) {
                                data.pointLightCount = 0;
                                data.spotLightCount = 0;
                                data.updateMark = updateMark;
                            }
                            var indices = data.indices;
                            var lightCount = data.pointLightCount + data.spotLightCount++;
                            if (lightCount < indices.length) indices[lightCount] = lightIndex;
                            else indices.push(lightIndex);
                        }
                    }
                }
            }
        },
        {
            key: "_insertConePlane",
            value: function _insertConePlane(origin, forward, radius, halfAngle, pNor) {
                var V1 = Cluster._tempVector36;
                var V2 = Cluster._tempVector37;
                Vector3.cross(pNor, forward, V1);
                Vector3.cross(V1, forward, V2);
                Vector3.normalize(V2, V2);
                var tanR = radius * Math.tan(halfAngle);
                var capRimX = origin.x + radius * forward.x + tanR * V2.x;
                var capRimY = origin.y + radius * forward.y + tanR * V2.y;
                var capRimZ = origin.z + radius * forward.z + tanR * V2.z;
                return capRimX * pNor.x + capRimY * pNor.y + capRimZ * pNor.z <= 0 || origin.x * pNor.x + origin.y * pNor.y + origin.z * pNor.z <= 0;
            }
        },
        {
            key: "_shrinkSphereLightZPerspective",
            value: function _shrinkSphereLightZPerspective(near, far, lightviewPos, radius, lightBound) {
                var lvZ = lightviewPos.z;
                var minZ = lvZ - radius;
                var maxZ = lvZ + radius;
                if (minZ > far || maxZ <= near) return false;
                var depthSliceParam = this._depthSliceParam;
                lightBound.zMin = Math.floor(Math.log2(Math.max(minZ, near)) * depthSliceParam.x - depthSliceParam.y);
                lightBound.zMax = Math.min(Math.ceil(Math.log2(maxZ) * depthSliceParam.x - depthSliceParam.y), this._zSlices);
                return true;
            }
        },
        {
            key: "_shrinkSpotLightZPerspective",
            value: function _shrinkSpotLightZPerspective(near, far, viewLightPos, viewConeCap, radius, halfAngle, lightBound) {
                var pbX = viewConeCap.x,
                pbY = viewConeCap.y,
                pbZ = viewConeCap.z;
                var rb = Math.tan(halfAngle) * radius;
                var paX = viewLightPos.x,
                paY = viewLightPos.y,
                paZ = viewLightPos.z;
                var aX = pbX - paX,
                aY = pbY - paY,
                aZ = pbZ - paZ;
                var dotA = aX * aX + aY * aY + aZ * aZ;
                var eZ = Math.sqrt(1.0 - aZ * aZ / dotA);
                var minZ = Math.max(Math.min(paZ, pbZ - eZ * rb), viewLightPos.z - radius);
                var maxZ = Math.min(Math.max(paZ, pbZ + eZ * rb), viewLightPos.z + radius);
                if (minZ > far || maxZ <= near) return false;
                var depthSliceParam = this._depthSliceParam;
                lightBound.zMin = Math.floor(Math.log2(Math.max(minZ, near)) * depthSliceParam.x - depthSliceParam.y);
                lightBound.zMax = Math.min(Math.ceil(Math.log2(maxZ) * depthSliceParam.x - depthSliceParam.y), this._zSlices);
                return true;
            }
        },
        {
            key: "_shrinkSphereLightByBoundOrth",
            value: function _shrinkSphereLightByBoundOrth(halfX, halfY, near, far, lightviewPos, radius, lightBound) {
                var lvZ = lightviewPos.z;
                var minZ = lvZ - radius,
                maxZ = lvZ + radius;
                if (minZ > far || maxZ <= near) return false;
                var lvX = lightviewPos.x;
                var minX = lvX - radius,
                maxX = lvX + radius;
                if (minX > halfX || maxX <= -halfX) return false;
                var lvY = lightviewPos.y;
                var minY = lvY - radius,
                maxY = lvY + radius;
                if (minY > halfY || maxY <= -halfY) return false;
                var xSlices = this._xSlices,
                ySlices = this._ySlices;
                var depthSliceParam = this._depthSliceParam;
                var xStride = halfX * 2 / xSlices,
                yStride = halfY * 2 / ySlices;
                lightBound.xMin = Math.max(Math.floor((minX + halfX) / xStride), 0);
                lightBound.xMax = Math.min(Math.ceil((maxX + halfX) / xStride), xSlices);
                lightBound.yMin = Math.max(Math.floor((halfY - maxY) / yStride), 0);
                lightBound.yMax = Math.min(Math.ceil((halfY - minY) / yStride), ySlices);
                lightBound.zMin = Math.floor(Math.log2(Math.max(minZ, near)) * depthSliceParam.x - depthSliceParam.y);
                lightBound.zMax = Math.min(Math.ceil(Math.log2(maxZ) * depthSliceParam.x - depthSliceParam.y), this._zSlices);
                return true;
            }
        },
        {
            key: "_shrinkSpotLightByBoundOrth",
            value: function _shrinkSpotLightByBoundOrth(halfX, halfY, near, far, viewLightPos, viewConeCap, radius, halfAngle, lightBound) {
                var pbX = viewConeCap.x,
                pbY = viewConeCap.y,
                pbZ = viewConeCap.z;
                var rb = Math.tan(halfAngle) * radius;
                var paX = viewLightPos.x,
                paY = viewLightPos.y,
                paZ = viewLightPos.z;
                var aX = pbX - paX,
                aY = pbY - paY,
                aZ = pbZ - paZ;
                var dotA = aX * aX + aY * aY + aZ * aZ;
                var eZ = Math.sqrt(1.0 - aZ * aZ / dotA);
                var minZ = Math.max(Math.min(paZ, pbZ - eZ * rb), viewLightPos.z - radius);
                var maxZ = Math.min(Math.max(paZ, pbZ + eZ * rb), viewLightPos.z + radius);
                if (minZ > far || maxZ <= near) return false;
                var eX = Math.sqrt(1.0 - aX * aX / dotA);
                var minX = Math.max(Math.min(paX, pbX - eX * rb), viewLightPos.x - radius);
                var maxX = Math.min(Math.max(paX, pbX + eX * rb), viewLightPos.x + radius);
                if (minX > halfX || maxX <= -halfX) return false;
                var eY = Math.sqrt(1.0 - aY * aY / dotA);
                var minY = Math.max(Math.min(paY, pbY - eY * rb), viewLightPos.y - radius);
                var maxY = Math.min(Math.max(paY, pbY + eY * rb), viewLightPos.y + radius);
                if (minY > halfY || maxY <= -halfY) return false;
                var xSlices = this._xSlices,
                ySlices = this._ySlices;
                var depthSliceParam = this._depthSliceParam;
                var xStride = halfX * 2 / xSlices,
                yStride = halfY * 2 / ySlices;
                lightBound.xMin = Math.max(Math.floor((minX + halfX) / xStride), 0);
                lightBound.xMax = Math.min(Math.ceil((maxX + halfX) / xStride), xSlices);
                lightBound.yMin = Math.max(Math.floor((halfY - maxY) / yStride), 0);
                lightBound.yMax = Math.min(Math.ceil((halfY - minY) / yStride), ySlices);
                lightBound.zMin = Math.floor(Math.log2(Math.max(minZ, near)) * depthSliceParam.x - depthSliceParam.y);
                lightBound.zMax = Math.min(Math.ceil(Math.log2(maxZ) * depthSliceParam.x - depthSliceParam.y), this._zSlices);
                return true;
            }
        },
        {
            key: "_shrinkXYByRadiusPerspective",
            value: function _shrinkXYByRadiusPerspective(lightviewPos, radius, lightBound, xPlanes, yPlanes) {
                var xMin, yMin;
                var xMax, yMax;
                var lvX = lightviewPos.x,
                lvY = lightviewPos.y,
                lvZ = lightviewPos.z;
                var i;
                var n = this._ySlices + 1;
                for (i = 0; i < n; i++) {
                    var plane = yPlanes[i];
                    if (lvY * plane.y + lvZ * plane.z < radius) {
                        yMin = Math.max(0, i - 1);
                        break;
                    }
                }
                if (i == n) return false;
                yMax = this._ySlices;
                for (i = yMin + 1; i < n; i++) {
                    var plane = yPlanes[i];
                    if (lvY * plane.y + lvZ * plane.z <= -radius) {
                        yMax = Math.max(0, i);
                        break;
                    }
                }
                n = this._xSlices + 1;
                for (i = 0; i < n; i++) {
                    var plane = xPlanes[i];
                    if (lvX * plane.x + lvZ * plane.z < radius) {
                        xMin = Math.max(0, i - 1);
                        break;
                    }
                }
                xMax = this._xSlices;
                for (i = xMin + 1; i < n; i++) {
                    var plane = xPlanes[i];
                    if (lvX * plane.x + lvZ * plane.z <= -radius) {
                        xMax = Math.max(0, i);
                        break;
                    }
                }
                lightBound.xMin = xMin;
                lightBound.xMax = xMax;
                lightBound.yMin = yMin;
                lightBound.yMax = yMax;
                return true;
            }
        },
        {
            key: "_shrinkSpotXYByConePerspective",
            value: function _shrinkSpotXYByConePerspective(lightviewPos, viewForward, radius, halfAngle, lightBound, xPlanes, yPlanes) {
                var xMin, yMin;
                var xMax, yMax;
                var normal = Cluster._tempVector32;
                var n = lightBound.yMax + 1;
                for (var i = lightBound.yMin + 1; i < n; i++) {
                    if (this._insertConePlane(lightviewPos, viewForward, radius, halfAngle, yPlanes[i])) {
                        yMin = Math.max(0, i - 1);
                        break;
                    }
                }
                yMax = lightBound.yMax;
                for (var i = yMin + 1; i < n; i++) {
                    var plane = yPlanes[i];
                    normal.setValue(0, -plane.y, -plane.z);
                    if (!this._insertConePlane(lightviewPos, viewForward, radius, halfAngle, normal)) {
                        yMax = Math.max(0, i);
                        break;
                    }
                }
                n = lightBound.xMax + 1;
                for (var i = lightBound.xMin + 1; i < n; i++) {
                    if (this._insertConePlane(lightviewPos, viewForward, radius, halfAngle, xPlanes[i])) {
                        xMin = Math.max(0, i - 1);
                        break;
                    }
                }
                xMax = lightBound.xMax;
                for (var i = xMin + 1; i < n; i++) {
                    var plane = xPlanes[i];
                    normal.setValue( - plane.x, 0, -plane.z);
                    if (!this._insertConePlane(lightviewPos, viewForward, radius, halfAngle, normal)) {
                        xMax = Math.max(0, i);
                        break;
                    }
                }
                lightBound.xMin = xMin;
                lightBound.xMax = xMax;
                lightBound.yMin = yMin;
                lightBound.yMax = yMax;
            }
        },
        {
            key: "_updatePointLightPerspective",
            value: function _updatePointLightPerspective(near, far, viewMat, pointLight, lightIndex, xPlanes, yPlanes) {
                var lightBound = Cluster._tempLightBound;
                var lightviewPos = Cluster._tempVector30;
                Vector3.transformV3ToV3(pointLight._transform.position, viewMat, lightviewPos);
                lightviewPos.z *= -1;
                if (!this._shrinkSphereLightZPerspective(near, far, lightviewPos, pointLight.range, lightBound)) return;
                if (!this._shrinkXYByRadiusPerspective(lightviewPos, pointLight.range, lightBound, xPlanes, yPlanes)) return;
                this._placePointLightToClusters(lightIndex, lightBound);
            }
        },
        {
            key: "_updateSpotLightPerspective",
            value: function _updateSpotLightPerspective(near, far, viewMat, spotLight, lightIndex, xPlanes, yPlanes) {
                var lightBound = Cluster._tempLightBound;
                var viewPos = Cluster._tempVector30;
                var forward = Cluster._tempVector31;
                var viewConeCap = Cluster._tempVector34;
                var position = spotLight._transform.position;
                var range = spotLight.range;
                spotLight._transform.worldMatrix.getForward(forward);
                Vector3.normalize(forward, forward);
                Vector3.scale(forward, range, viewConeCap);
                Vector3.add(position, viewConeCap, viewConeCap);
                Vector3.transformV3ToV3(position, viewMat, viewPos);
                Vector3.transformV3ToV3(viewConeCap, viewMat, viewConeCap);
                viewPos.z *= -1;
                viewConeCap.z *= -1;
                var halfAngle = spotLight.spotAngle / 2 * Math.PI / 180;
                if (!this._shrinkSpotLightZPerspective(near, far, viewPos, viewConeCap, range, halfAngle, lightBound)) return;
                if (!this._shrinkXYByRadiusPerspective(viewPos, range, lightBound, xPlanes, yPlanes)) return;
                var viewFor = Cluster._tempVector33;
                viewFor.x = viewConeCap.x - viewPos.x,
                viewFor.y = viewConeCap.y - viewPos.y,
                viewFor.z = viewConeCap.z - viewPos.z;
                Vector3.normalize(viewFor, viewFor);
                this._shrinkSpotXYByConePerspective(viewPos, viewFor, range, halfAngle, lightBound, xPlanes, yPlanes);
                this._placeSpotLightToClusters(lightIndex, lightBound);
            }
        },
        {
            key: "_updatePointLightOrth",
            value: function _updatePointLightOrth(halfX, halfY, near, far, viewMat, pointLight, lightIndex) {
                var lightBound = Cluster._tempLightBound;
                var lightviewPos = Cluster._tempVector30;
                Vector3.transformV3ToV3(pointLight._transform.position, viewMat, lightviewPos);
                lightviewPos.z *= -1;
                if (!this._shrinkSphereLightByBoundOrth(halfX, halfY, near, far, lightviewPos, pointLight.range, lightBound)) return;
                this._placePointLightToClusters(lightIndex, lightBound);
            }
        },
        {
            key: "_updateSpotLightOrth",
            value: function _updateSpotLightOrth(halfX, halfY, near, far, viewMat, spotLight, lightIndex) {
                var lightBound = Cluster._tempLightBound;
                var viewPos = Cluster._tempVector30;
                var forward = Cluster._tempVector31;
                var viewConeCap = Cluster._tempVector34;
                var position = spotLight._transform.position;
                var range = spotLight.range;
                spotLight._transform.worldMatrix.getForward(forward);
                Vector3.normalize(forward, forward);
                Vector3.scale(forward, range, viewConeCap);
                Vector3.add(position, viewConeCap, viewConeCap);
                Vector3.transformV3ToV3(position, viewMat, viewPos);
                Vector3.transformV3ToV3(viewConeCap, viewMat, viewConeCap);
                viewPos.z *= -1;
                viewConeCap.z *= -1;
                var halfAngle = spotLight.spotAngle / 2 * Math.PI / 180;
                if (!this._shrinkSpotLightByBoundOrth(halfX, halfY, near, far, viewPos, viewConeCap, range, halfAngle, lightBound)) return;
                this._placeSpotLightToClusters(lightIndex, lightBound);
            }
        },
        {
            key: "update",
            value: function update(camera, scene) {
                this._updateMark++;
                var camNear = camera.nearPlane;
                this._depthSliceParam.x = Config3D._config.lightClusterCount.z / Math.log2(camera.farPlane / camNear);
                this._depthSliceParam.y = Math.log2(camNear) * this._depthSliceParam.x;
                var near = camera.nearPlane;
                var far = camera.farPlane;
                var viewMat = camera.viewMatrix;
                var curCount = scene._directionLights._length;
                var pointLights = scene._pointLights;
                var poiCount = pointLights._length;
                var poiElements = pointLights._elements;
                var spotLights = scene._spotLights;
                var spoCount = spotLights._length;
                var spoElements = spotLights._elements;
                if (camera.orthographic) {
                    var halfY = camera.orthographicVerticalSize / 2.0;
                    var halfX = halfY * camera.aspectRatio;
                    for (var i = 0; i < poiCount; i++, curCount++) {
                        this._updatePointLightOrth(halfX, halfY, near, far, viewMat, poiElements[i], curCount);
                    }
                    for (var i = 0; i < spoCount; i++, curCount++) {
                        this._updateSpotLightOrth(halfX, halfY, near, far, viewMat, spoElements[i], curCount);
                    }
                } else {
                    camera._updateClusterPlaneXY();
                    var xPlanes = camera._clusterXPlanes;
                    var yPlanes = camera._clusterYPlanes;
                    for (var i = 0; i < poiCount; i++, curCount++) {
                        this._updatePointLightPerspective(near, far, viewMat, poiElements[i], curCount, xPlanes, yPlanes);
                    }
                    for (var i = 0; i < spoCount; i++, curCount++) {
                        this._updateSpotLightPerspective(near, far, viewMat, spoElements[i], curCount, xPlanes, yPlanes);
                    }
                }
                if (poiCount + spoCount > 0) {
                    var xSlices = this._xSlices,
                    ySlices = this._ySlices,
                    zSlices = this._zSlices;
                    var widthFloat = xSlices * ySlices * 4;
                    var lightOff = widthFloat * zSlices;
                    var clusterPixels = this._clusterPixels;
                    var clusterPixelsCount = clusterPixels.length;
                    var clusterDatas = this._clusterDatas;
                    var updateMark = this._updateMark;
                    var freeSpace = true;
                    for (var z = 0; z < zSlices; z++) {
                        for (var y = 0; y < ySlices; y++) {
                            for (var x = 0; x < xSlices; x++) {
                                var data = clusterDatas[z][y][x];
                                var clusterOff = (x + y * xSlices + z * xSlices * ySlices) * 4;
                                if (data.updateMark !== updateMark) {
                                    clusterPixels[clusterOff] = 0;
                                    clusterPixels[clusterOff + 1] = 0;
                                } else {
                                    if (freeSpace) {
                                        var indices = data.indices;
                                        var pCount = data.pointLightCount;
                                        var sCount = data.spotLightCount;
                                        var count = pCount + sCount;
                                        if (lightOff + count < clusterPixelsCount) {
                                            clusterPixels[clusterOff] = pCount;
                                            clusterPixels[clusterOff + 1] = sCount;
                                            clusterPixels[clusterOff + 2] = Math.floor(lightOff / widthFloat);
                                            clusterPixels[clusterOff + 3] = lightOff % widthFloat;
                                            for (var i = 0; i < count; i++) {
                                                clusterPixels[lightOff++] = indices[i];
                                            }
                                        } else {
                                            count = clusterPixelsCount - (lightOff + count);
                                            pCount = Math.min(pCount, count);
                                            clusterPixels[clusterOff] = pCount;
                                            clusterPixels[clusterOff + 1] = Math.min(sCount, count - pCount);
                                            clusterPixels[clusterOff + 2] = Math.floor(lightOff / widthFloat);
                                            clusterPixels[clusterOff + 3] = lightOff % widthFloat;
                                            for (var i = 0; i < count; i++) {
                                                clusterPixels[lightOff++] = indices[i];
                                            }
                                            freeSpace = false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    var width = this._clusterTexture.width;
                    this._clusterTexture.setSubPixels(0, 0, width, Math.ceil(lightOff / (4 * width)), clusterPixels);
                }
            }
        }]);
        return Cluster;
    } ();
    Cluster._tempVector30 = new Vector3();
    Cluster._tempVector31 = new Vector3();
    Cluster._tempVector32 = new Vector3();
    Cluster._tempVector33 = new Vector3();
    Cluster._tempVector34 = new Vector3();
    Cluster._tempVector35 = new Vector3();
    Cluster._tempVector36 = new Vector3();
    Cluster._tempVector37 = new Vector3();
    Cluster._tempLightBound = new LightBound(); (function(TextureCubeFace) {
        TextureCubeFace[TextureCubeFace["PositiveX"] = 0] = "PositiveX";
        TextureCubeFace[TextureCubeFace["NegativeX"] = 1] = "NegativeX";
        TextureCubeFace[TextureCubeFace["PositiveY"] = 2] = "PositiveY";
        TextureCubeFace[TextureCubeFace["NegativeY"] = 3] = "NegativeY";
        TextureCubeFace[TextureCubeFace["PositiveZ"] = 4] = "PositiveZ";
        TextureCubeFace[TextureCubeFace["NegativeZ"] = 5] = "NegativeZ";
    })(exports.TextureCubeFace || (exports.TextureCubeFace = {}));
    var TextureCube =
    /*#__PURE__*/
    function(_Laya$BaseTexture2) {
        _inherits(TextureCube, _Laya$BaseTexture2);
        var _super31 = _createSuper(TextureCube);
        function TextureCube(size) {
            var _this28;
            var format = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Laya.TextureFormat.R8G8B8;
            var mipmap = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
            _classCallCheck(this, TextureCube);
            _this28 = _super31.call(this, format, mipmap);
            _this28._glTextureType = Laya.LayaGL.instance.TEXTURE_CUBE_MAP;
            _this28._width = size;
            _this28._height = size;
            var gl = Laya.LayaGL.instance;
            _this28._setWarpMode(gl.TEXTURE_WRAP_S, _this28._wrapModeU);
            _this28._setWarpMode(gl.TEXTURE_WRAP_T, _this28._wrapModeV);
            _this28._setFilterMode(_this28._filterMode);
            _this28._setAnisotropy(_this28._anisoLevel);
            if (_this28._mipmap) {
                _this28._mipmapCount = Math.ceil(Math.log2(size)) + 1;
                for (var i = 0; i < _this28._mipmapCount; i++) {
                    _this28._setPixels([], i, Math.max(size >> i, 1), Math.max(size >> i, 1));
                }
                _this28._setGPUMemory(size * size * 4 * (1 + 1 / 3) * 6);
            } else {
                _this28._mipmapCount = 1;
                _this28._setGPUMemory(size * size * 4 * 6);
            }
            return _this28;
        }
        _createClass(TextureCube, [{
            key: "defaulteTexture",
            get: function get() {
                return TextureCube.grayTexture;
            }
        },
        {
            key: "_setPixels",
            value: function _setPixels(pixels, miplevel, width, height) {
                var gl = Laya.LayaGL.instance;
                var glFormat = this._getGLFormat();
                Laya.WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                if (this.format === Laya.TextureFormat.R8G8B8) {
                    gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Z, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[0]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Z, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[1]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[2]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_X, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[3]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Y, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[4]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[5]);
                    gl.pixelStorei(gl.UNPACK_ALIGNMENT, 4);
                } else {
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Z, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[0]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Z, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[1]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[2]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_X, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[3]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Y, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[4]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels[5]);
                }
            }
        },
        {
            key: "setSixSideImageSources",
            value: function setSixSideImageSources(source) {
                var premultiplyAlpha = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                var width;
                var height;
                for (var i = 0; i < 6; i++) {
                    var img = source[i];
                    if (!img) {
                        console.log("TextureCube: image Source can't be null.");
                        return;
                    }
                    var nextWidth = img.width;
                    var nextHeight = img.height;
                    if (i > 0) {
                        if (width !== nextWidth) {
                            console.log("TextureCube: each side image's width and height must same.");
                            return;
                        }
                    }
                    width = nextWidth;
                    height = nextHeight;
                    if (width !== height) {
                        console.log("TextureCube: each side image's width and height must same.");
                        return;
                    }
                }
                this._width = width;
                this._height = height;
                var gl = Laya.LayaGL.instance;
                Laya.WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                var glFormat = this._getGLFormat();
                if (!Laya.Render.isConchApp) {
                    premultiplyAlpha && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, true);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[0]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[1]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[2]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[3]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[4]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source[5]);
                    premultiplyAlpha && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
                } else {
                    if (premultiplyAlpha == true) {
                        for (var j = 0; j < 6; j++) {
                            source[j].setPremultiplyAlpha(premultiplyAlpha);
                        }
                    }
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Z, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[0]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Z, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[1]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[2]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_X, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[3]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Y, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[4]);
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source[5]);
                }
                if (this._mipmap && this._isPot(width) && this._isPot(height)) {
                    gl.generateMipmap(this._glTextureType);
                    this._setGPUMemory(width * height * 4 * (1 + 1 / 3) * 6);
                } else {
                    this._setGPUMemory(width * height * 4 * 6);
                }
                this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                this._setFilterMode(this._filterMode);
                this._readyed = true;
                this._activeResource();
            }
        },
        {
            key: "setSixSidePixels",
            value: function setSixSidePixels(pixels) {
                var miplevel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                if (!pixels) throw new Error("TextureCube:pixels can't be null.");
                var width = Math.max(this._width >> miplevel, 1);
                var height = Math.max(this._height >> miplevel, 1);
                var pixelsCount = width * height * this._getFormatByteCount();
                if (pixels[0].length < pixelsCount) throw "TextureCube:pixels length should at least " + pixelsCount + ".";
                this._setPixels(pixels, miplevel, width, height);
                if (miplevel === 0) {
                    var gl = Laya.LayaGL.instance;
                    this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                    this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                }
                this._readyed = true;
                this._activeResource();
            }
        },
        {
            key: "setImageSource",
            value: function setImageSource(face, imageSource) {
                var miplevel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var width = this._width;
                var height = this._height;
                if (imageSource) {
                    if (width !== imageSource.width || height !== imageSource.height) {
                        console.log("TextureCube: imageSource's width and height must same.");
                        return;
                    }
                }
                var gl = Laya.LayaGL.instance;
                Laya.WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                var glFormat = this._getGLFormat();
                switch (face) {
                case exports.TextureCubeFace.NegativeX:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_X, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                case exports.TextureCubeFace.PositiveX:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                case exports.TextureCubeFace.NegativeY:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Y, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                case exports.TextureCubeFace.PositiveY:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Y, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                case exports.TextureCubeFace.NegativeZ:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_NEGATIVE_Z, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                case exports.TextureCubeFace.PositiveZ:
                    gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_Z, miplevel, glFormat, glFormat, gl.UNSIGNED_BYTE, imageSource);
                    break;
                }
                if (this._mipmap && this._isPot(width) && this._isPot(height)) {
                    gl.generateMipmap(this._glTextureType);
                    this._setGPUMemory(width * height * 4 * (1 + 1 / 3) * 6);
                } else {
                    this._setGPUMemory(width * height * 4 * 6);
                }
                this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                this._setFilterMode(this._filterMode);
                this._readyed = true;
            }
        }], [{
            key: "blackTexture",
            get: function get() {
                return TextureCube._blackTexture;
            }
        },
        {
            key: "grayTexture",
            get: function get() {
                return TextureCube._grayTexture;
            }
        },
        {
            key: "__init__",
            value: function __init__() {
                var blackTexture = new TextureCube(1, Laya.TextureFormat.R8G8B8, false);
                var grayTexture = new TextureCube(1, Laya.TextureFormat.R8G8B8, false);
                var pixels = new Uint8Array(3);
                pixels[0] = 0,
                pixels[1] = 0,
                pixels[2] = 0;
                blackTexture.setSixSidePixels([pixels, pixels, pixels, pixels, pixels, pixels]);
                blackTexture.lock = true;
                pixels[0] = 128,
                pixels[1] = 128,
                pixels[2] = 128;
                grayTexture.setSixSidePixels([pixels, pixels, pixels, pixels, pixels, pixels]);
                grayTexture.lock = true;
                TextureCube._grayTexture = grayTexture;
                TextureCube._blackTexture = blackTexture;
            }
        },
        {
            key: "_parse",
            value: function _parse(data) {
                var propertyParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var constructParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var texture = constructParams ? new TextureCube(0, constructParams[0], constructParams[1]) : new TextureCube(0);
                texture.setSixSideImageSources(data);
                return texture;
            }
        },
        {
            key: "_parseBin",
            value: function _parseBin(data) {
                var propertyParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var constructParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var texture = constructParams ? new TextureCube(0, constructParams[0], constructParams[1]) : new TextureCube(0);
                texture.setSixSideImageSources(data);
                return texture;
            }
        },
        {
            key: "load",
            value: function load(url, complete) {
                var extension = Laya.LoaderManager.createMap[Laya.Utils.getFilecompatibleExtension(url)] ? Laya.Utils.getFilecompatibleExtension(url) : Laya.Utils.getFileExtension(url);
                var type = Laya.LoaderManager.createMap[extension] ? Laya.LoaderManager.createMap[extension][0] : null;
                Laya.ILaya.loader.create(url, complete, null, type);
            }
        }]);
        return TextureCube;
    } (Laya.BaseTexture);
    TextureCube.TEXTURECUBE = "TEXTURECUBE";
    TextureCube.TEXTURECUBEBIN = "TEXTURECUBEBIN";
    var SphericalHarmonicsL2 =
    /*#__PURE__*/
    function() {
        function SphericalHarmonicsL2() {
            _classCallCheck(this, SphericalHarmonicsL2);
            this._coefficients = new Float32Array(27);
        }
        _createClass(SphericalHarmonicsL2, [{
            key: "getCoefficient",
            value: function getCoefficient(i, j) {
                return this._coefficients[i * 9 + j];
            }
        },
        {
            key: "setCoefficient",
            value: function setCoefficient(i, j, coefficient) {
                this._coefficients[i * 9 + j] = coefficient;
            }
        },
        {
            key: "setCoefficients",
            value: function setCoefficients(i, coefficient0, coefficient1, coefficient2, coefficient3, coefficient4, coefficient5, coefficient6, coefficient7, coefficient8) {
                var offset = i * 9;
                this._coefficients[offset] = coefficient0;
                this._coefficients[++offset] = coefficient1;
                this._coefficients[++offset] = coefficient2;
                this._coefficients[++offset] = coefficient3;
                this._coefficients[++offset] = coefficient4;
                this._coefficients[++offset] = coefficient5;
                this._coefficients[++offset] = coefficient6;
                this._coefficients[++offset] = coefficient7;
                this._coefficients[++offset] = coefficient8;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(dest) {
                if (this === dest) return;
                var coes = this._coefficients;
                var destCoes = dest._coefficients;
                for (var i = 0; i < 27; i++) {
                    destCoes[i] = coes[i];
                }
            }
        }]);
        return SphericalHarmonicsL2;
    } ();
    SphericalHarmonicsL2._default = new SphericalHarmonicsL2();
    var SphericalHarmonicsL2Generater =
    /*#__PURE__*/
    function() {
        function SphericalHarmonicsL2Generater() {
            _classCallCheck(this, SphericalHarmonicsL2Generater);
        }
        _createClass(SphericalHarmonicsL2Generater, null, [{
            key: "surfaceArea",
            value: function surfaceArea(u, v) {
                return Math.atan2(u * v, Math.sqrt(u * u + v * v + 1.0));
            }
        },
        {
            key: "uv2Dir",
            value: function uv2Dir(u, v, face, out_dir) {
                switch (face) {
                case exports.TextureCubeFace.PositiveX:
                    out_dir.x = 1.0;
                    out_dir.y = -v;
                    out_dir.z = -u;
                    break;
                case exports.TextureCubeFace.NegativeX:
                    out_dir.x = -1.0;
                    out_dir.y = -v;
                    out_dir.z = u;
                    break;
                case exports.TextureCubeFace.PositiveY:
                    out_dir.x = u;
                    out_dir.y = 1.0;
                    out_dir.z = v;
                    break;
                case exports.TextureCubeFace.NegativeY:
                    out_dir.x = u;
                    out_dir.y = -1.0;
                    out_dir.z = -v;
                    break;
                case exports.TextureCubeFace.PositiveZ:
                    out_dir.x = u;
                    out_dir.y = -v;
                    out_dir.z = 1.0;
                    break;
                case exports.TextureCubeFace.NegativeZ:
                    out_dir.x = -u;
                    out_dir.y = -v;
                    out_dir.z = -1.0;
                    break;
                }
            }
        },
        {
            key: "sh_eval_9",
            value: function sh_eval_9(i, x, y, z) {
                var sqrt = Math.sqrt;
                var M_PI = Math.PI;
                switch (i) {
                case 0:
                    return 0.5 * sqrt(1.0 / M_PI);
                case 1:
                    return - y * 0.5 * sqrt(3.0 / M_PI);
                case 2:
                    return z * 0.5 * sqrt(3.0 / M_PI);
                case 3:
                    return - x * 0.5 * sqrt(3.0 / M_PI);
                case 4:
                    return x * y * 0.5 * sqrt(15.0 / M_PI);
                case 5:
                    return - y * z * 0.5 * sqrt(15.0 / M_PI);
                case 6:
                    return (3.0 * z * z - 1.0) * 0.25 * sqrt(5.0 / M_PI);
                case 7:
                    return - x * z * 0.5 * sqrt(15.0 / M_PI);
                case 8:
                    return (x * x - y * y) * 0.25 * sqrt(15.0 / M_PI);
                default:
                    return 0;
                }
            }
        },
        {
            key: "CalCubemapSH",
            value: function CalCubemapSH(cubemapPixels, pixelComponentSize, cubemapSize) {
                var isGamma = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                var width = cubemapSize;
                var height = cubemapSize;
                var shr = this._tempSHR.fill(0);
                var shg = this._tempSHG.fill(0);
                var shb = this._tempSHB.fill(0);
                var dir = new Vector3();
                for (var face = 0; face < 6; face++) {
                    var facePixels = cubemapPixels[face];
                    for (var y = 0; y < height; y++) {
                        for (var x = 0; x < width; x++) {
                            var px = x + 0.5;
                            var py = y + 0.5;
                            var u = 2.0 * (px / width) - 1.0;
                            var v = 2.0 * (py / height) - 1.0;
                            var dx = 1.0 / width;
                            var dy = 1.0 / height;
                            var x0 = u - dx;
                            var y0 = v - dy;
                            var x1 = u + dx;
                            var y1 = v + dy;
                            var da = this.surfaceArea(x0, y0) - this.surfaceArea(x0, y1) - this.surfaceArea(x1, y0) + this.surfaceArea(x1, y1);
                            this.uv2Dir(u, v, face, dir);
                            Vector3.normalize(dir, dir);
                            var pixelOffset = (x + y * width) * pixelComponentSize;
                            var r = facePixels[pixelOffset];
                            var g = facePixels[pixelOffset + 1];
                            var b = facePixels[pixelOffset + 2];
                            if (isGamma) {
                                r = Color.gammaToLinearSpace(r);
                                g = Color.gammaToLinearSpace(g);
                                b = Color.gammaToLinearSpace(b);
                            }
                            for (var s = 0; s < this.SH_Count; s++) {
                                var sh_val = this.sh_eval_9(s, dir.x, dir.y, dir.z);
                                shr[s] += r * sh_val * da;
                                shg[s] += g * sh_val * da;
                                shb[s] += b * sh_val * da;
                            }
                        }
                    }
                }
                var sh = new SphericalHarmonicsL2();
                for (var index = 0; index < this.SH_Count; index++) {
                    var scale = this.k[index];
                    var _r = shr[index];
                    sh.setCoefficient(0, index, _r * scale);
                    var _g = shg[index];
                    sh.setCoefficient(1, index, _g * scale);
                    var _b = shb[index];
                    sh.setCoefficient(2, index, _b * scale);
                }
                return sh;
            }
        },
        {
            key: "CalGradientSH",
            value: function CalGradientSH(skyColor, equatorColor, groundColor) {
                var isGamma = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                console.time("Gradient SH");
                var skyPixels = this._tempSkyPixels;
                var equatorPixels = this._tempEquatorPixels;
                var groundPixels = this._tempGroundPixels;
                var fillPixelBuffer = function fillPixelBuffer(float32, color, isGamma) {
                    var fillColor = new Color(color.x, color.y, color.z, 1.0);
                    if (isGamma) {
                        fillColor.toLinear(fillColor);
                    }
                    var r = Math.min(fillColor.r, 1.0);
                    var g = Math.min(fillColor.g, 1.0);
                    var b = Math.min(fillColor.b, 1.0);
                    for (var index = 0; index < float32.length; index += 3) {
                        float32[index] = r;
                        float32[index + 1] = g;
                        float32[index + 2] = b;
                    }
                };
                fillPixelBuffer(skyPixels, skyColor, isGamma);
                fillPixelBuffer(equatorPixels, equatorColor, isGamma);
                fillPixelBuffer(groundPixels, groundColor, isGamma);
                var gradientPixles = [];
                gradientPixles[exports.TextureCubeFace.PositiveY] = skyPixels;
                gradientPixles[exports.TextureCubeFace.NegativeY] = groundPixels;
                gradientPixles[exports.TextureCubeFace.PositiveX] = equatorPixels;
                gradientPixles[exports.TextureCubeFace.NegativeX] = equatorPixels;
                gradientPixles[exports.TextureCubeFace.PositiveZ] = equatorPixels;
                gradientPixles[exports.TextureCubeFace.NegativeZ] = equatorPixels;
                var sh = SphericalHarmonicsL2Generater.CalCubemapSH(gradientPixles, 3, this.GradientSimulateSize, false);
                console.timeEnd("Gradient SH");
                return sh;
            }
        }]);
        return SphericalHarmonicsL2Generater;
    } ();
    SphericalHarmonicsL2Generater._tempSHR = new Float32Array(9);
    SphericalHarmonicsL2Generater._tempSHG = new Float32Array(9);
    SphericalHarmonicsL2Generater._tempSHB = new Float32Array(9);
    SphericalHarmonicsL2Generater.k = [0.28209479177387814347, -0.32573500793527994772, 0.32573500793527994772, -0.32573500793527994772, 0.27313710764801976764, -0.27313710764801976764, 0.07884789131313000151, -0.27313710764801976764, 0.13656855382400988382];
    SphericalHarmonicsL2Generater.GradientSimulateSize = 3;
    SphericalHarmonicsL2Generater.SH_Count = 9;
    SphericalHarmonicsL2Generater._tempSkyPixels = new Float32Array(SphericalHarmonicsL2Generater.GradientSimulateSize * SphericalHarmonicsL2Generater.GradientSimulateSize * 3);
    SphericalHarmonicsL2Generater._tempEquatorPixels = new Float32Array(SphericalHarmonicsL2Generater.GradientSimulateSize * SphericalHarmonicsL2Generater.GradientSimulateSize * 3);
    SphericalHarmonicsL2Generater._tempGroundPixels = new Float32Array(SphericalHarmonicsL2Generater.GradientSimulateSize * SphericalHarmonicsL2Generater.GradientSimulateSize * 3);
    var MouseTouch =
    /*#__PURE__*/
    _createClass(function MouseTouch() {
        _classCallCheck(this, MouseTouch);
        this._pressedSprite = null;
        this._pressedLoopCount = -1;
        this.sprite = null;
        this.mousePositionX = 0;
        this.mousePositionY = 0;
    });
    var Touch =
    /*#__PURE__*/
    function() {
        function Touch() {
            _classCallCheck(this, Touch);
            this._indexInList = -1;
            this._identifier = -1;
            this._position = new Vector2();
        }
        _createClass(Touch, [{
            key: "identifier",
            get: function get() {
                return this._identifier;
            }
        },
        {
            key: "position",
            get: function get() {
                return this._position;
            }
        },
        {
            key: "_getIndexInList",
            value: function _getIndexInList() {
                return this._indexInList;
            }
        },
        {
            key: "_setIndexInList",
            value: function _setIndexInList(index) {
                this._indexInList = index;
            }
        }]);
        return Touch;
    } ();
    var Plane =
    /*#__PURE__*/
    function() {
        function Plane(normal) {
            var d = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            _classCallCheck(this, Plane);
            this.normal = normal;
            this.distance = d;
        }
        _createClass(Plane, [{
            key: "normalize",
            value: function normalize() {
                var normalEX = this.normal.x;
                var normalEY = this.normal.y;
                var normalEZ = this.normal.z;
                var magnitude = 1.0 / Math.sqrt(normalEX * normalEX + normalEY * normalEY + normalEZ * normalEZ);
                this.normal.x = normalEX * magnitude;
                this.normal.y = normalEY * magnitude;
                this.normal.z = normalEZ * magnitude;
                this.distance *= magnitude;
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                this.normal.cloneTo(dest.normal);
                dest.distance = this.distance;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Plane(new Vector3());
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "createPlaneBy3P",
            value: function createPlaneBy3P(point0, point1, point2, out) {
                var x1 = point1.x - point0.x;
                var y1 = point1.y - point0.y;
                var z1 = point1.z - point0.z;
                var x2 = point2.x - point0.x;
                var y2 = point2.y - point0.y;
                var z2 = point2.z - point0.z;
                var yz = y1 * z2 - z1 * y2;
                var xz = z1 * x2 - x1 * z2;
                var xy = x1 * y2 - y1 * x2;
                var invPyth = 1.0 / Math.sqrt(yz * yz + xz * xz + xy * xy);
                var x = yz * invPyth;
                var y = xz * invPyth;
                var z = xy * invPyth;
                var normal = out.normal;
                normal.x = x;
                normal.y = y;
                normal.z = z;
                out.distance = -(x * point0.x + y * point0.y + z * point0.z);
            }
        }]);
        return Plane;
    } ();
    Plane.PlaneIntersectionType_Back = 0;
    Plane.PlaneIntersectionType_Front = 1;
    Plane.PlaneIntersectionType_Intersecting = 2;
    var Ray =
    /*#__PURE__*/
    _createClass(function Ray(origin, direction) {
        _classCallCheck(this, Ray);
        this.origin = origin;
        this.direction = direction;
    });
    var ContainmentType =
    /*#__PURE__*/
    _createClass(function ContainmentType() {
        _classCallCheck(this, ContainmentType);
    });
    ContainmentType.Disjoint = 0;
    ContainmentType.Contains = 1;
    ContainmentType.Intersects = 2;
    var CollisionUtils =
    /*#__PURE__*/
    function() {
        function CollisionUtils() {
            _classCallCheck(this, CollisionUtils);
        }
        _createClass(CollisionUtils, null, [{
            key: "distancePlaneToPoint",
            value: function distancePlaneToPoint(plane, point) {
                var dot = Vector3.dot(plane.normal, point);
                return dot - plane.distance;
            }
        },
        {
            key: "distanceBoxToPoint",
            value: function distanceBoxToPoint(box, point) {
                var boxMin = box.min;
                var boxMineX = boxMin.x;
                var boxMineY = boxMin.y;
                var boxMineZ = boxMin.z;
                var boxMax = box.max;
                var boxMaxeX = boxMax.x;
                var boxMaxeY = boxMax.y;
                var boxMaxeZ = boxMax.z;
                var pointeX = point.x;
                var pointeY = point.y;
                var pointeZ = point.z;
                var distance = 0;
                if (pointeX < boxMineX) distance += (boxMineX - pointeX) * (boxMineX - pointeX);
                if (pointeX > boxMaxeX) distance += (boxMaxeX - pointeX) * (boxMaxeX - pointeX);
                if (pointeY < boxMineY) distance += (boxMineY - pointeY) * (boxMineY - pointeY);
                if (pointeY > boxMaxeY) distance += (boxMaxeY - pointeY) * (boxMaxeY - pointeY);
                if (pointeZ < boxMineZ) distance += (boxMineZ - pointeZ) * (boxMineZ - pointeZ);
                if (pointeZ > boxMaxeZ) distance += (boxMaxeZ - pointeZ) * (boxMaxeZ - pointeZ);
                return Math.sqrt(distance);
            }
        },
        {
            key: "distanceBoxToBox",
            value: function distanceBoxToBox(box1, box2) {
                var box1Mine = box1.min;
                var box1MineX = box1Mine.x;
                var box1MineY = box1Mine.y;
                var box1MineZ = box1Mine.z;
                var box1Maxe = box1.max;
                var box1MaxeX = box1Maxe.x;
                var box1MaxeY = box1Maxe.y;
                var box1MaxeZ = box1Maxe.z;
                var box2Mine = box2.min;
                var box2MineX = box2Mine.x;
                var box2MineY = box2Mine.y;
                var box2MineZ = box2Mine.z;
                var box2Maxe = box2.max;
                var box2MaxeX = box2Maxe.x;
                var box2MaxeY = box2Maxe.y;
                var box2MaxeZ = box2Maxe.z;
                var distance = 0;
                var delta;
                if (box1MineX > box2MaxeX) {
                    delta = box1MineX - box2MaxeX;
                    distance += delta * delta;
                } else if (box2MineX > box1MaxeX) {
                    delta = box2MineX - box1MaxeX;
                    distance += delta * delta;
                }
                if (box1MineY > box2MaxeY) {
                    delta = box1MineY - box2MaxeY;
                    distance += delta * delta;
                } else if (box2MineY > box1MaxeY) {
                    delta = box2MineY - box1MaxeY;
                    distance += delta * delta;
                }
                if (box1MineZ > box2MaxeZ) {
                    delta = box1MineZ - box2MaxeZ;
                    distance += delta * delta;
                } else if (box2MineZ > box1MaxeZ) {
                    delta = box2MineZ - box1MaxeZ;
                    distance += delta * delta;
                }
                return Math.sqrt(distance);
            }
        },
        {
            key: "distanceSphereToPoint",
            value: function distanceSphereToPoint(sphere, point) {
                var distance = Math.sqrt(Vector3.distanceSquared(sphere.center, point));
                distance -= sphere.radius;
                return Math.max(distance, 0);
            }
        },
        {
            key: "distanceSphereToSphere",
            value: function distanceSphereToSphere(sphere1, sphere2) {
                var distance = Math.sqrt(Vector3.distanceSquared(sphere1.center, sphere2.center));
                distance -= sphere1.radius + sphere2.radius;
                return Math.max(distance, 0);
            }
        },
        {
            key: "intersectsRayAndTriangleRD",
            value: function intersectsRayAndTriangleRD(ray, vertex1, vertex2, vertex3, out) {
                var rayO = ray.origin;
                var rayOeX = rayO.x;
                var rayOeY = rayO.y;
                var rayOeZ = rayO.z;
                var rayD = ray.direction;
                var rayDeX = rayD.x;
                var rayDeY = rayD.y;
                var rayDeZ = rayD.z;
                var v1eX = vertex1.x;
                var v1eY = vertex1.y;
                var v1eZ = vertex1.z;
                var v2eX = vertex2.x;
                var v2eY = vertex2.y;
                var v2eZ = vertex2.z;
                var v3eX = vertex3.x;
                var v3eY = vertex3.y;
                var v3eZ = vertex3.z;
                var _tempV30eX = CollisionUtils._tempV30.x;
                var _tempV30eY = CollisionUtils._tempV30.y;
                var _tempV30eZ = CollisionUtils._tempV30.z;
                _tempV30eX = v2eX - v1eX;
                _tempV30eY = v2eY - v1eY;
                _tempV30eZ = v2eZ - v1eZ;
                var _tempV31eX = CollisionUtils._tempV31.x;
                var _tempV31eY = CollisionUtils._tempV31.y;
                var _tempV31eZ = CollisionUtils._tempV31.z;
                _tempV31eX = v3eX - v1eX;
                _tempV31eY = v3eY - v1eY;
                _tempV31eZ = v3eZ - v1eZ;
                var _tempV32eX = CollisionUtils._tempV32.x;
                var _tempV32eY = CollisionUtils._tempV32.y;
                var _tempV32eZ = CollisionUtils._tempV32.z;
                _tempV32eX = rayDeY * _tempV31eZ - rayDeZ * _tempV31eY;
                _tempV32eY = rayDeZ * _tempV31eX - rayDeX * _tempV31eZ;
                _tempV32eZ = rayDeX * _tempV31eY - rayDeY * _tempV31eX;
                var determinant = _tempV30eX * _tempV32eX + _tempV30eY * _tempV32eY + _tempV30eZ * _tempV32eZ;
                if (MathUtils3D.isZero(determinant)) {
                    return false;
                }
                var inversedeterminant = 1 / determinant;
                var _tempV33eX = CollisionUtils._tempV33.x;
                var _tempV33eY = CollisionUtils._tempV33.y;
                var _tempV33eZ = CollisionUtils._tempV33.z;
                _tempV33eX = rayOeX - v1eX;
                _tempV33eY = rayOeY - v1eY;
                _tempV33eZ = rayOeZ - v1eZ;
                var triangleU = _tempV33eX * _tempV32eX + _tempV33eY * _tempV32eY + _tempV33eZ * _tempV32eZ;
                triangleU *= inversedeterminant;
                if (triangleU < 0 || triangleU > 1) {
                    return false;
                }
                var _tempV34eX = CollisionUtils._tempV34.x;
                var _tempV34eY = CollisionUtils._tempV34.y;
                var _tempV34eZ = CollisionUtils._tempV34.z;
                _tempV34eX = _tempV33eY * _tempV30eZ - _tempV33eZ * _tempV30eY;
                _tempV34eY = _tempV33eZ * _tempV30eX - _tempV33eX * _tempV30eZ;
                _tempV34eZ = _tempV33eX * _tempV30eY - _tempV33eY * _tempV30eX;
                var triangleV = rayDeX * _tempV34eX + rayDeY * _tempV34eY + rayDeZ * _tempV34eZ;
                triangleV *= inversedeterminant;
                if (triangleV < 0 || triangleU + triangleV > 1) {
                    return false;
                }
                var raydistance = _tempV31eX * _tempV34eX + _tempV31eY * _tempV34eY + _tempV31eZ * _tempV34eZ;
                raydistance *= inversedeterminant;
                if (raydistance < 0) {
                    return false;
                }
                return true;
            }
        },
        {
            key: "intersectsRayAndTriangleRP",
            value: function intersectsRayAndTriangleRP(ray, vertex1, vertex2, vertex3, out) {
                var distance;
                if (!CollisionUtils.intersectsRayAndTriangleRD(ray, vertex1, vertex2, vertex3, distance)) {
                    out = Vector3._ZERO;
                    return false;
                }
                Vector3.scale(ray.direction, distance, CollisionUtils._tempV30);
                Vector3.add(ray.origin, CollisionUtils._tempV30, out);
                return true;
            }
        },
        {
            key: "intersectsRayAndPoint",
            value: function intersectsRayAndPoint(ray, point) {
                Vector3.subtract(ray.origin, point, CollisionUtils._tempV30);
                var b = Vector3.dot(CollisionUtils._tempV30, ray.direction);
                var c = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV30) - MathUtils3D.zeroTolerance;
                if (c > 0 && b > 0) return false;
                var discriminant = b * b - c;
                if (discriminant < 0) return false;
                return true;
            }
        },
        {
            key: "intersectsRayAndRay",
            value: function intersectsRayAndRay(ray1, ray2, out) {
                var ray1o = ray1.origin;
                var ray1oeX = ray1o.x;
                var ray1oeY = ray1o.y;
                var ray1oeZ = ray1o.z;
                var ray1d = ray1.direction;
                var ray1deX = ray1d.x;
                var ray1deY = ray1d.y;
                var ray1deZ = ray1d.z;
                var ray2o = ray2.origin;
                var ray2oeX = ray2o.x;
                var ray2oeY = ray2o.y;
                var ray2oeZ = ray2o.z;
                var ray2d = ray2.direction;
                var ray2deX = ray2d.x;
                var ray2deY = ray2d.y;
                var ray2deZ = ray2d.z;
                Vector3.cross(ray1d, ray2d, CollisionUtils._tempV30);
                var tempV3 = CollisionUtils._tempV30;
                var denominator = Vector3.scalarLength(CollisionUtils._tempV30);
                if (MathUtils3D.isZero(denominator)) {
                    if (MathUtils3D.nearEqual(ray2oeX, ray1oeX) && MathUtils3D.nearEqual(ray2oeY, ray1oeY) && MathUtils3D.nearEqual(ray2oeZ, ray1oeZ)) {
                        return true;
                    }
                }
                denominator = denominator * denominator;
                var m11 = ray2oeX - ray1oeX;
                var m12 = ray2oeY - ray1oeY;
                var m13 = ray2oeZ - ray1oeZ;
                var m21 = ray2deX;
                var m22 = ray2deY;
                var m23 = ray2deZ;
                var m31 = tempV3.x;
                var m32 = tempV3.y;
                var m33 = tempV3.z;
                var dets = m11 * m22 * m33 + m12 * m23 * m31 + m13 * m21 * m32 - m11 * m23 * m32 - m12 * m21 * m33 - m13 * m22 * m31;
                m21 = ray1deX;
                m22 = ray1deY;
                m23 = ray1deZ;
                var s = dets / denominator;
                Vector3.scale(ray1d, s, CollisionUtils._tempV30);
                Vector3.scale(ray2d, s, CollisionUtils._tempV31);
                Vector3.add(ray1o, CollisionUtils._tempV30, CollisionUtils._tempV32);
                Vector3.add(ray2o, CollisionUtils._tempV31, CollisionUtils._tempV33);
                var point1e = CollisionUtils._tempV32;
                var point2e = CollisionUtils._tempV33;
                if (!MathUtils3D.nearEqual(point2e.x, point1e.x) || !MathUtils3D.nearEqual(point2e.y, point1e.y) || !MathUtils3D.nearEqual(point2e.z, point1e.z)) {
                    return false;
                }
                return true;
            }
        },
        {
            key: "intersectsPlaneAndTriangle",
            value: function intersectsPlaneAndTriangle(plane, vertex1, vertex2, vertex3) {
                var test1 = CollisionUtils.intersectsPlaneAndPoint(plane, vertex1);
                var test2 = CollisionUtils.intersectsPlaneAndPoint(plane, vertex2);
                var test3 = CollisionUtils.intersectsPlaneAndPoint(plane, vertex3);
                if (test1 == Plane.PlaneIntersectionType_Front && test2 == Plane.PlaneIntersectionType_Front && test3 == Plane.PlaneIntersectionType_Front) return Plane.PlaneIntersectionType_Front;
                if (test1 == Plane.PlaneIntersectionType_Back && test2 == Plane.PlaneIntersectionType_Back && test3 == Plane.PlaneIntersectionType_Back) return Plane.PlaneIntersectionType_Back;
                return Plane.PlaneIntersectionType_Intersecting;
            }
        },
        {
            key: "intersectsRayAndPlaneRD",
            value: function intersectsRayAndPlaneRD(ray, plane) {
                var planeNor = plane.normal;
                var direction = Vector3.dot(planeNor, ray.direction);
                if (Math.abs(direction) < MathUtils3D.zeroTolerance) return - 1;
                var position = Vector3.dot(planeNor, ray.origin);
                var distance = ( - plane.distance - position) / direction;
                if (distance < 0) {
                    if (distance < -MathUtils3D.zeroTolerance) return - 1;
                    distance = 0;
                }
                return distance;
            }
        },
        {
            key: "intersectsRayAndPlaneRP",
            value: function intersectsRayAndPlaneRP(ray, plane, out) {
                var distance = CollisionUtils.intersectsRayAndPlaneRD(ray, plane);
                if (distance == -1) {
                    out.setValue(0, 0, 0);
                    return false;
                }
                var scaDis = CollisionUtils._tempV30;
                Vector3.scale(ray.direction, distance, scaDis);
                Vector3.add(ray.origin, scaDis, out);
                return true;
            }
        },
        {
            key: "intersectsRayAndBoxRD",
            value: function intersectsRayAndBoxRD(ray, box) {
                var rayoe = ray.origin;
                var rayoeX = rayoe.x;
                var rayoeY = rayoe.y;
                var rayoeZ = rayoe.z;
                var rayde = ray.direction;
                var raydeX = rayde.x;
                var raydeY = rayde.y;
                var raydeZ = rayde.z;
                var boxMine = box.min;
                var boxMineX = boxMine.x;
                var boxMineY = boxMine.y;
                var boxMineZ = boxMine.z;
                var boxMaxe = box.max;
                var boxMaxeX = boxMaxe.x;
                var boxMaxeY = boxMaxe.y;
                var boxMaxeZ = boxMaxe.z;
                var out = 0;
                var tmax = MathUtils3D.MaxValue;
                if (MathUtils3D.isZero(raydeX)) {
                    if (rayoeX < boxMineX || rayoeX > boxMaxeX) {
                        return - 1;
                    }
                } else {
                    var inverse = 1 / raydeX;
                    var t1 = (boxMineX - rayoeX) * inverse;
                    var t2 = (boxMaxeX - rayoeX) * inverse;
                    if (t1 > t2) {
                        var temp = t1;
                        t1 = t2;
                        t2 = temp;
                    }
                    out = Math.max(t1, out);
                    tmax = Math.min(t2, tmax);
                    if (out > tmax) {
                        return - 1;
                    }
                }
                if (MathUtils3D.isZero(raydeY)) {
                    if (rayoeY < boxMineY || rayoeY > boxMaxeY) {
                        return - 1;
                    }
                } else {
                    var inverse1 = 1 / raydeY;
                    var t3 = (boxMineY - rayoeY) * inverse1;
                    var t4 = (boxMaxeY - rayoeY) * inverse1;
                    if (t3 > t4) {
                        var temp1 = t3;
                        t3 = t4;
                        t4 = temp1;
                    }
                    out = Math.max(t3, out);
                    tmax = Math.min(t4, tmax);
                    if (out > tmax) {
                        return - 1;
                    }
                }
                if (MathUtils3D.isZero(raydeZ)) {
                    if (rayoeZ < boxMineZ || rayoeZ > boxMaxeZ) {
                        return - 1;
                    }
                } else {
                    var inverse2 = 1 / raydeZ;
                    var t5 = (boxMineZ - rayoeZ) * inverse2;
                    var t6 = (boxMaxeZ - rayoeZ) * inverse2;
                    if (t5 > t6) {
                        var temp2 = t5;
                        t5 = t6;
                        t6 = temp2;
                    }
                    out = Math.max(t5, out);
                    tmax = Math.min(t6, tmax);
                    if (out > tmax) {
                        return - 1;
                    }
                }
                return out;
            }
        },
        {
            key: "intersectsRayAndBoxRP",
            value: function intersectsRayAndBoxRP(ray, box, out) {
                var distance = CollisionUtils.intersectsRayAndBoxRD(ray, box);
                if (distance === -1) {
                    Vector3._ZERO.cloneTo(out);
                    return distance;
                }
                Vector3.scale(ray.direction, distance, CollisionUtils._tempV30);
                Vector3.add(ray.origin, CollisionUtils._tempV30, CollisionUtils._tempV31);
                CollisionUtils._tempV31.cloneTo(out);
                return distance;
            }
        },
        {
            key: "intersectsRayAndSphereRD",
            value: function intersectsRayAndSphereRD(ray, sphere) {
                var sphereR = sphere.radius;
                Vector3.subtract(ray.origin, sphere.center, CollisionUtils._tempV30);
                var b = Vector3.dot(CollisionUtils._tempV30, ray.direction);
                var c = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV30) - sphereR * sphereR;
                if (c > 0 && b > 0) {
                    return - 1;
                }
                var discriminant = b * b - c;
                if (discriminant < 0) {
                    return - 1;
                }
                var distance = -b - Math.sqrt(discriminant);
                if (distance < 0) distance = 0;
                return distance;
            }
        },
        {
            key: "intersectsRayAndSphereRP",
            value: function intersectsRayAndSphereRP(ray, sphere, out) {
                var distance = CollisionUtils.intersectsRayAndSphereRD(ray, sphere);
                if (distance === -1) {
                    Vector3._ZERO.cloneTo(out);
                    return distance;
                }
                Vector3.scale(ray.direction, distance, CollisionUtils._tempV30);
                Vector3.add(ray.origin, CollisionUtils._tempV30, CollisionUtils._tempV31);
                CollisionUtils._tempV31.cloneTo(out);
                return distance;
            }
        },
        {
            key: "intersectsSphereAndTriangle",
            value: function intersectsSphereAndTriangle(sphere, vertex1, vertex2, vertex3) {
                var sphereC = sphere.center;
                var sphereR = sphere.radius;
                CollisionUtils.closestPointPointTriangle(sphereC, vertex1, vertex2, vertex3, CollisionUtils._tempV30);
                Vector3.subtract(CollisionUtils._tempV30, sphereC, CollisionUtils._tempV31);
                var dot = Vector3.dot(CollisionUtils._tempV31, CollisionUtils._tempV31);
                return dot <= sphereR * sphereR;
            }
        },
        {
            key: "intersectsPlaneAndPoint",
            value: function intersectsPlaneAndPoint(plane, point) {
                var distance = Vector3.dot(plane.normal, point) + plane.distance;
                if (distance > 0) return Plane.PlaneIntersectionType_Front;
                if (distance < 0) return Plane.PlaneIntersectionType_Back;
                return Plane.PlaneIntersectionType_Intersecting;
            }
        },
        {
            key: "intersectsPlaneAndPlane",
            value: function intersectsPlaneAndPlane(plane1, plane2) {
                Vector3.cross(plane1.normal, plane2.normal, CollisionUtils._tempV30);
                var denominator = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV30);
                if (MathUtils3D.isZero(denominator)) return false;
                return true;
            }
        },
        {
            key: "intersectsPlaneAndPlaneRL",
            value: function intersectsPlaneAndPlaneRL(plane1, plane2, line) {
                var plane1nor = plane1.normal;
                var plane2nor = plane2.normal;
                Vector3.cross(plane1nor, plane2nor, CollisionUtils._tempV34);
                var denominator = Vector3.dot(CollisionUtils._tempV34, CollisionUtils._tempV34);
                if (MathUtils3D.isZero(denominator)) return false;
                Vector3.scale(plane2nor, plane1.distance, CollisionUtils._tempV30);
                Vector3.scale(plane1nor, plane2.distance, CollisionUtils._tempV31);
                Vector3.subtract(CollisionUtils._tempV30, CollisionUtils._tempV31, CollisionUtils._tempV32);
                Vector3.cross(CollisionUtils._tempV32, CollisionUtils._tempV34, CollisionUtils._tempV33);
                Vector3.normalize(CollisionUtils._tempV34, CollisionUtils._tempV34);
                return true;
            }
        },
        {
            key: "intersectsPlaneAndBox",
            value: function intersectsPlaneAndBox(plane, box) {
                var planeD = plane.distance;
                var planeNor = plane.normal;
                var planeNoreX = planeNor.x;
                var planeNoreY = planeNor.y;
                var planeNoreZ = planeNor.z;
                var boxMine = box.min;
                var boxMineX = boxMine.x;
                var boxMineY = boxMine.y;
                var boxMineZ = boxMine.z;
                var boxMaxe = box.max;
                var boxMaxeX = boxMaxe.x;
                var boxMaxeY = boxMaxe.y;
                var boxMaxeZ = boxMaxe.z;
                CollisionUtils._tempV30.x = planeNoreX > 0 ? boxMineX: boxMaxeX;
                CollisionUtils._tempV30.y = planeNoreY > 0 ? boxMineY: boxMaxeY;
                CollisionUtils._tempV30.z = planeNoreZ > 0 ? boxMineZ: boxMaxeZ;
                CollisionUtils._tempV31.x = planeNoreX > 0 ? boxMaxeX: boxMineX;
                CollisionUtils._tempV31.y = planeNoreY > 0 ? boxMaxeY: boxMineY;
                CollisionUtils._tempV31.z = planeNoreZ > 0 ? boxMaxeZ: boxMineZ;
                var distance = Vector3.dot(planeNor, CollisionUtils._tempV30);
                if (distance + planeD > 0) return Plane.PlaneIntersectionType_Front;
                distance = Vector3.dot(planeNor, CollisionUtils._tempV31);
                if (distance + planeD < 0) return Plane.PlaneIntersectionType_Back;
                return Plane.PlaneIntersectionType_Intersecting;
            }
        },
        {
            key: "intersectsPlaneAndSphere",
            value: function intersectsPlaneAndSphere(plane, sphere) {
                var sphereR = sphere.radius;
                var distance = Vector3.dot(plane.normal, sphere.center) + plane.distance;
                if (distance > sphereR) return Plane.PlaneIntersectionType_Front;
                if (distance < -sphereR) return Plane.PlaneIntersectionType_Back;
                return Plane.PlaneIntersectionType_Intersecting;
            }
        },
        {
            key: "intersectsBoxAndBox",
            value: function intersectsBoxAndBox(box1, box2) {
                var box1Mine = box1.min;
                var box1Maxe = box1.max;
                var box2Mine = box2.min;
                var box2Maxe = box2.max;
                if (box1Mine.x > box2Maxe.x || box2Mine.x > box1Maxe.x) return false;
                if (box1Mine.y > box2Maxe.y || box2Mine.y > box1Maxe.y) return false;
                if (box1Mine.z > box2Maxe.z || box2Mine.z > box1Maxe.z) return false;
                return true;
            }
        },
        {
            key: "intersectsBoxAndSphere",
            value: function intersectsBoxAndSphere(box, sphere) {
                var center = sphere.center;
                var radius = sphere.radius;
                var nearest = CollisionUtils._tempV30;
                Vector3.Clamp(center, box.min, box.max, nearest);
                var distance = Vector3.distanceSquared(center, nearest);
                return distance <= radius * radius;
            }
        },
        {
            key: "intersectsSphereAndSphere",
            value: function intersectsSphereAndSphere(sphere1, sphere2) {
                var radiisum = sphere1.radius + sphere2.radius;
                return Vector3.distanceSquared(sphere1.center, sphere2.center) <= radiisum * radiisum;
            }
        },
        {
            key: "boxContainsPoint",
            value: function boxContainsPoint(box, point) {
                var boxMine = box.min;
                var boxMaxe = box.max;
                if (boxMine.x <= point.x && boxMaxe.x >= point.x && boxMine.y <= point.y && boxMaxe.y >= point.y && boxMine.z <= point.z && boxMaxe.z >= point.z) return ContainmentType.Contains;
                return ContainmentType.Disjoint;
            }
        },
        {
            key: "boxContainsBox",
            value: function boxContainsBox(box1, box2) {
                var box1Mine = box1.min;
                var box1MineX = box1Mine.x;
                var box1MineY = box1Mine.y;
                var box1MineZ = box1Mine.z;
                var box1Maxe = box1.max;
                var box1MaxeX = box1Maxe.x;
                var box1MaxeY = box1Maxe.y;
                var box1MaxeZ = box1Maxe.z;
                var box2Mine = box2.min;
                var box2MineX = box2Mine.x;
                var box2MineY = box2Mine.y;
                var box2MineZ = box2Mine.z;
                var box2Maxe = box2.max;
                var box2MaxeX = box2Maxe.x;
                var box2MaxeY = box2Maxe.y;
                var box2MaxeZ = box2Maxe.z;
                if (box1MaxeX < box2MineX || box1MineX > box2MaxeX) return ContainmentType.Disjoint;
                if (box1MaxeY < box2MineY || box1MineY > box2MaxeY) return ContainmentType.Disjoint;
                if (box1MaxeZ < box2MineZ || box1MineZ > box2MaxeZ) return ContainmentType.Disjoint;
                if (box1MineX <= box2MineX && box2MaxeX <= box1MaxeX && box1MineY <= box2MineY && box2MaxeY <= box1MaxeY && box1MineZ <= box2MineZ && box2MaxeZ <= box1MaxeZ) {
                    return ContainmentType.Contains;
                }
                return ContainmentType.Intersects;
            }
        },
        {
            key: "boxContainsSphere",
            value: function boxContainsSphere(box, sphere) {
                var boxMin = box.min;
                var boxMineX = boxMin.x;
                var boxMineY = boxMin.y;
                var boxMineZ = boxMin.z;
                var boxMax = box.max;
                var boxMaxeX = boxMax.x;
                var boxMaxeY = boxMax.y;
                var boxMaxeZ = boxMax.z;
                var sphereC = sphere.center;
                var sphereCeX = sphereC.x;
                var sphereCeY = sphereC.y;
                var sphereCeZ = sphereC.z;
                var sphereR = sphere.radius;
                Vector3.Clamp(sphereC, boxMin, boxMax, CollisionUtils._tempV30);
                var distance = Vector3.distanceSquared(sphereC, CollisionUtils._tempV30);
                if (distance > sphereR * sphereR) return ContainmentType.Disjoint;
                if (boxMineX + sphereR <= sphereCeX && sphereCeX <= boxMaxeX - sphereR && boxMaxeX - boxMineX > sphereR && boxMineY + sphereR <= sphereCeY && sphereCeY <= boxMaxeY - sphereR && boxMaxeY - boxMineY > sphereR && boxMineZ + sphereR <= sphereCeZ && sphereCeZ <= boxMaxeZ - sphereR && boxMaxeZ - boxMineZ > sphereR) return ContainmentType.Contains;
                return ContainmentType.Intersects;
            }
        },
        {
            key: "sphereContainsPoint",
            value: function sphereContainsPoint(sphere, point) {
                if (Vector3.distanceSquared(point, sphere.center) <= sphere.radius * sphere.radius) return ContainmentType.Contains;
                return ContainmentType.Disjoint;
            }
        },
        {
            key: "sphereContainsTriangle",
            value: function sphereContainsTriangle(sphere, vertex1, vertex2, vertex3) {
                var test1 = CollisionUtils.sphereContainsPoint(sphere, vertex1);
                var test2 = CollisionUtils.sphereContainsPoint(sphere, vertex2);
                var test3 = CollisionUtils.sphereContainsPoint(sphere, vertex3);
                if (test1 == ContainmentType.Contains && test2 == ContainmentType.Contains && test3 == ContainmentType.Contains) return ContainmentType.Contains;
                if (CollisionUtils.intersectsSphereAndTriangle(sphere, vertex1, vertex2, vertex3)) return ContainmentType.Intersects;
                return ContainmentType.Disjoint;
            }
        },
        {
            key: "sphereContainsBox",
            value: function sphereContainsBox(sphere, box) {
                var sphereC = sphere.center;
                var sphereCeX = sphereC.x;
                var sphereCeY = sphereC.y;
                var sphereCeZ = sphereC.z;
                var sphereR = sphere.radius;
                var boxMin = box.min;
                var boxMineX = boxMin.x;
                var boxMineY = boxMin.y;
                var boxMineZ = boxMin.z;
                var boxMax = box.max;
                var boxMaxeX = boxMax.x;
                var boxMaxeY = boxMax.y;
                var boxMaxeZ = boxMax.z;
                var _tempV30e = CollisionUtils._tempV30;
                var _tempV30eX = _tempV30e.x;
                var _tempV30eY = _tempV30e.y;
                var _tempV30eZ = _tempV30e.z;
                if (!CollisionUtils.intersectsBoxAndSphere(box, sphere)) return ContainmentType.Disjoint;
                var radiusSquared = sphereR * sphereR;
                _tempV30eX = sphereCeX - boxMineX;
                _tempV30eY = sphereCeY - boxMaxeY;
                _tempV30eZ = sphereCeZ - boxMaxeZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMaxeX;
                _tempV30eY = sphereCeY - boxMaxeY;
                _tempV30eZ = sphereCeZ - boxMaxeZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMaxeX;
                _tempV30eY = sphereCeY - boxMineY;
                _tempV30eZ = sphereCeZ - boxMaxeZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMineX;
                _tempV30eY = sphereCeY - boxMineY;
                _tempV30eZ = sphereCeZ - boxMaxeZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMineX;
                _tempV30eY = sphereCeY - boxMaxeY;
                _tempV30eZ = sphereCeZ - boxMineZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMaxeX;
                _tempV30eY = sphereCeY - boxMaxeY;
                _tempV30eZ = sphereCeZ - boxMineZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMaxeX;
                _tempV30eY = sphereCeY - boxMineY;
                _tempV30eZ = sphereCeZ - boxMineZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                _tempV30eX = sphereCeX - boxMineX;
                _tempV30eY = sphereCeY - boxMineY;
                _tempV30eZ = sphereCeZ - boxMineZ;
                if (Vector3.scalarLengthSquared(CollisionUtils._tempV30) > radiusSquared) return ContainmentType.Intersects;
                return ContainmentType.Contains;
            }
        },
        {
            key: "sphereContainsSphere",
            value: function sphereContainsSphere(sphere1, sphere2) {
                var sphere1R = sphere1.radius;
                var sphere2R = sphere2.radius;
                var distance = Vector3.distance(sphere1.center, sphere2.center);
                if (sphere1R + sphere2R < distance) return ContainmentType.Disjoint;
                if (sphere1R - sphere2R < distance) return ContainmentType.Intersects;
                return ContainmentType.Contains;
            }
        },
        {
            key: "closestPointPointTriangle",
            value: function closestPointPointTriangle(point, vertex1, vertex2, vertex3, out) {
                Vector3.subtract(vertex2, vertex1, CollisionUtils._tempV30);
                Vector3.subtract(vertex3, vertex1, CollisionUtils._tempV31);
                Vector3.subtract(point, vertex1, CollisionUtils._tempV32);
                Vector3.subtract(point, vertex2, CollisionUtils._tempV33);
                Vector3.subtract(point, vertex3, CollisionUtils._tempV34);
                var d1 = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV32);
                var d2 = Vector3.dot(CollisionUtils._tempV31, CollisionUtils._tempV32);
                var d3 = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV33);
                var d4 = Vector3.dot(CollisionUtils._tempV31, CollisionUtils._tempV33);
                var d5 = Vector3.dot(CollisionUtils._tempV30, CollisionUtils._tempV34);
                var d6 = Vector3.dot(CollisionUtils._tempV31, CollisionUtils._tempV34);
                if (d1 <= 0 && d2 <= 0) {
                    vertex1.cloneTo(out);
                    return;
                }
                if (d3 >= 0 && d4 <= d3) {
                    vertex2.cloneTo(out);
                    return;
                }
                var vc = d1 * d4 - d3 * d2;
                if (vc <= 0 && d1 >= 0 && d3 <= 0) {
                    var v = d1 / (d1 - d3);
                    Vector3.scale(CollisionUtils._tempV30, v, out);
                    Vector3.add(vertex1, out, out);
                    return;
                }
                if (d6 >= 0 && d5 <= d6) {
                    vertex3.cloneTo(out);
                    return;
                }
                var vb = d5 * d2 - d1 * d6;
                if (vb <= 0 && d2 >= 0 && d6 <= 0) {
                    var w = d2 / (d2 - d6);
                    Vector3.scale(CollisionUtils._tempV31, w, out);
                    Vector3.add(vertex1, out, out);
                    return;
                }
                var va = d3 * d6 - d5 * d4;
                if (va <= 0 && d4 - d3 >= 0 && d5 - d6 >= 0) {
                    var w3 = (d4 - d3) / (d4 - d3 + (d5 - d6));
                    Vector3.subtract(vertex3, vertex2, out);
                    Vector3.scale(out, w3, out);
                    Vector3.add(vertex2, out, out);
                    return;
                }
                var denom = 1 / (va + vb + vc);
                var v2 = vb * denom;
                var w2 = vc * denom;
                Vector3.scale(CollisionUtils._tempV30, v2, CollisionUtils._tempV35);
                Vector3.scale(CollisionUtils._tempV31, w2, CollisionUtils._tempV36);
                Vector3.add(CollisionUtils._tempV35, CollisionUtils._tempV36, out);
                Vector3.add(vertex1, out, out);
            }
        },
        {
            key: "closestPointPlanePoint",
            value: function closestPointPlanePoint(plane, point, out) {
                var planeN = plane.normal;
                var t = Vector3.dot(planeN, point) - plane.distance;
                Vector3.scale(planeN, t, CollisionUtils._tempV30);
                Vector3.subtract(point, CollisionUtils._tempV30, out);
            }
        },
        {
            key: "closestPointBoxPoint",
            value: function closestPointBoxPoint(box, point, out) {
                Vector3.max(point, box.min, CollisionUtils._tempV30);
                Vector3.min(CollisionUtils._tempV30, box.max, out);
            }
        },
        {
            key: "closestPointSpherePoint",
            value: function closestPointSpherePoint(sphere, point, out) {
                var sphereC = sphere.center;
                Vector3.subtract(point, sphereC, out);
                Vector3.normalize(out, out);
                Vector3.scale(out, sphere.radius, out);
                Vector3.add(out, sphereC, out);
            }
        },
        {
            key: "closestPointSphereSphere",
            value: function closestPointSphereSphere(sphere1, sphere2, out) {
                var sphere1C = sphere1.center;
                Vector3.subtract(sphere2.center, sphere1C, out);
                Vector3.normalize(out, out);
                Vector3.scale(out, sphere1.radius, out);
                Vector3.add(out, sphere1C, out);
            }
        }]);
        return CollisionUtils;
    } ();
    CollisionUtils._tempV30 = new Vector3();
    CollisionUtils._tempV31 = new Vector3();
    CollisionUtils._tempV32 = new Vector3();
    CollisionUtils._tempV33 = new Vector3();
    CollisionUtils._tempV34 = new Vector3();
    CollisionUtils._tempV35 = new Vector3();
    CollisionUtils._tempV36 = new Vector3(); (function(FrustumCorner) {
        FrustumCorner[FrustumCorner["FarBottomLeft"] = 0] = "FarBottomLeft";
        FrustumCorner[FrustumCorner["FarTopLeft"] = 1] = "FarTopLeft";
        FrustumCorner[FrustumCorner["FarTopRight"] = 2] = "FarTopRight";
        FrustumCorner[FrustumCorner["FarBottomRight"] = 3] = "FarBottomRight";
        FrustumCorner[FrustumCorner["nearBottomLeft"] = 4] = "nearBottomLeft";
        FrustumCorner[FrustumCorner["nearTopLeft"] = 5] = "nearTopLeft";
        FrustumCorner[FrustumCorner["nearTopRight"] = 6] = "nearTopRight";
        FrustumCorner[FrustumCorner["nearBottomRight"] = 7] = "nearBottomRight";
        FrustumCorner[FrustumCorner["unknown"] = 8] = "unknown";
    })(exports.FrustumCorner || (exports.FrustumCorner = {}));
    var BoundFrustum =
    /*#__PURE__*/
    function() {
        function BoundFrustum(matrix) {
            _classCallCheck(this, BoundFrustum);
            this._matrix = matrix;
            this._near = new Plane(new Vector3());
            this._far = new Plane(new Vector3());
            this._left = new Plane(new Vector3());
            this._right = new Plane(new Vector3());
            this._top = new Plane(new Vector3());
            this._bottom = new Plane(new Vector3());
            BoundFrustum.getPlanesFromMatrix(this._matrix, this._near, this._far, this._left, this._right, this._top, this._bottom);
        }
        _createClass(BoundFrustum, [{
            key: "matrix",
            get: function get() {
                return this._matrix;
            },
            set: function set(matrix) {
                matrix.cloneTo(this._matrix);
                BoundFrustum.getPlanesFromMatrix(this._matrix, this._near, this._far, this._left, this._right, this._top, this._bottom);
            }
        },
        {
            key: "near",
            get: function get() {
                return this._near;
            }
        },
        {
            key: "far",
            get: function get() {
                return this._far;
            }
        },
        {
            key: "left",
            get: function get() {
                return this._left;
            }
        },
        {
            key: "right",
            get: function get() {
                return this._right;
            }
        },
        {
            key: "top",
            get: function get() {
                return this._top;
            }
        },
        {
            key: "bottom",
            get: function get() {
                return this._bottom;
            }
        },
        {
            key: "equalsBoundFrustum",
            value: function equalsBoundFrustum(other) {
                return this._matrix.equalsOtherMatrix(other.matrix);
            }
        },
        {
            key: "equalsObj",
            value: function equalsObj(obj) {
                if (obj instanceof BoundFrustum) {
                    var bf = obj;
                    return this.equalsBoundFrustum(bf);
                }
                return false;
            }
        },
        {
            key: "getPlane",
            value: function getPlane(index) {
                switch (index) {
                case 0:
                    return this._near;
                case 1:
                    return this._far;
                case 2:
                    return this._left;
                case 3:
                    return this._right;
                case 4:
                    return this._top;
                case 5:
                    return this._bottom;
                default:
                    return null;
                }
            }
        },
        {
            key: "getCorners",
            value: function getCorners(corners) {
                BoundFrustum.get3PlaneInterPoint(this._near, this._bottom, this._right, corners[exports.FrustumCorner.nearBottomRight]);
                BoundFrustum.get3PlaneInterPoint(this._near, this._top, this._right, corners[exports.FrustumCorner.nearTopRight]);
                BoundFrustum.get3PlaneInterPoint(this._near, this._top, this._left, corners[exports.FrustumCorner.nearTopLeft]);
                BoundFrustum.get3PlaneInterPoint(this._near, this._bottom, this._left, corners[exports.FrustumCorner.nearBottomLeft]);
                BoundFrustum.get3PlaneInterPoint(this._far, this._bottom, this._right, corners[exports.FrustumCorner.FarBottomRight]);
                BoundFrustum.get3PlaneInterPoint(this._far, this._top, this._right, corners[exports.FrustumCorner.FarTopRight]);
                BoundFrustum.get3PlaneInterPoint(this._far, this._top, this._left, corners[exports.FrustumCorner.FarTopLeft]);
                BoundFrustum.get3PlaneInterPoint(this._far, this._bottom, this._left, corners[exports.FrustumCorner.FarBottomLeft]);
            }
        },
        {
            key: "containsPoint",
            value: function containsPoint(point) {
                var result = Plane.PlaneIntersectionType_Front;
                var planeResult = Plane.PlaneIntersectionType_Front;
                for (var i = 0; i < 6; i++) {
                    switch (i) {
                    case 0:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._near, point);
                        break;
                    case 1:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._far, point);
                        break;
                    case 2:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._left, point);
                        break;
                    case 3:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._right, point);
                        break;
                    case 4:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._top, point);
                        break;
                    case 5:
                        planeResult = CollisionUtils.intersectsPlaneAndPoint(this._bottom, point);
                        break;
                    }
                    switch (planeResult) {
                    case Plane.PlaneIntersectionType_Back:
                        return ContainmentType.Disjoint;
                    case Plane.PlaneIntersectionType_Intersecting:
                        result = Plane.PlaneIntersectionType_Intersecting;
                        break;
                    }
                }
                switch (result) {
                case Plane.PlaneIntersectionType_Intersecting:
                    return ContainmentType.Intersects;
                default:
                    return ContainmentType.Contains;
                }
            }
        },
        {
            key: "intersects",
            value: function intersects(box) {
                var min = box.min;
                var max = box.max;
                var minX = min.x;
                var minY = min.y;
                var minZ = min.z;
                var maxX = max.x;
                var maxY = max.y;
                var maxZ = max.z;
                if (box._lastBoundIndex != -1) {
                    var plan = this.getPlane(box._lastBoundIndex);
                    var normal = plan.normal;
                    if (plan.distance + normal.x * (normal.x < 0 ? minX: maxX) + normal.y * (normal.y < 0 ? minY: maxY) + normal.z * (normal.z < 0 ? minZ: maxZ) < 0) {
                        return false;
                    }
                }
                var nearNormal = this._near.normal;
                if (this._near.distance + nearNormal.x * (nearNormal.x < 0 ? minX: maxX) + nearNormal.y * (nearNormal.y < 0 ? minY: maxY) + nearNormal.z * (nearNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 0;
                    return false;
                }
                var leftNormal = this._left.normal;
                if (this._left.distance + leftNormal.x * (leftNormal.x < 0 ? minX: maxX) + leftNormal.y * (leftNormal.y < 0 ? minY: maxY) + leftNormal.z * (leftNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 2;
                    return false;
                }
                var rightNormal = this._right.normal;
                if (this._right.distance + rightNormal.x * (rightNormal.x < 0 ? minX: maxX) + rightNormal.y * (rightNormal.y < 0 ? minY: maxY) + rightNormal.z * (rightNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 3;
                    return false;
                }
                var bottomNormal = this._bottom.normal;
                if (this._bottom.distance + bottomNormal.x * (bottomNormal.x < 0 ? minX: maxX) + bottomNormal.y * (bottomNormal.y < 0 ? minY: maxY) + bottomNormal.z * (bottomNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 5;
                    return false;
                }
                var topNormal = this._top.normal;
                if (this._top.distance + topNormal.x * (topNormal.x < 0 ? minX: maxX) + topNormal.y * (topNormal.y < 0 ? minY: maxY) + topNormal.z * (topNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 4;
                    return false;
                }
                var farNormal = this._far.normal;
                if (this._far.distance + farNormal.x * (farNormal.x < 0 ? minX: maxX) + farNormal.y * (farNormal.y < 0 ? minY: maxY) + farNormal.z * (farNormal.z < 0 ? minZ: maxZ) < 0) {
                    box._lastBoundIndex = 1;
                    return false;
                }
                box._lastBoundIndex = -1;
                return true;
            }
        },
        {
            key: "containsBoundBox",
            value: function containsBoundBox(box) {
                var p = BoundFrustum._tempV30,
                n = BoundFrustum._tempV31;
                var boxMin = box.min;
                var boxMax = box.max;
                var result = ContainmentType.Contains;
                for (var i = 0; i < 6; i++) {
                    var plane = this.getPlane(i);
                    var planeNor = plane.normal;
                    if (planeNor.x >= 0) {
                        p.x = boxMax.x;
                        n.x = boxMin.x;
                    } else {
                        p.x = boxMin.x;
                        n.x = boxMax.x;
                    }
                    if (planeNor.y >= 0) {
                        p.y = boxMax.y;
                        n.y = boxMin.y;
                    } else {
                        p.y = boxMin.y;
                        n.y = boxMax.y;
                    }
                    if (planeNor.z >= 0) {
                        p.z = boxMax.z;
                        n.z = boxMin.z;
                    } else {
                        p.z = boxMin.z;
                        n.z = boxMax.z;
                    }
                    if (CollisionUtils.intersectsPlaneAndPoint(plane, p) === Plane.PlaneIntersectionType_Back) return ContainmentType.Disjoint;
                    if (CollisionUtils.intersectsPlaneAndPoint(plane, n) === Plane.PlaneIntersectionType_Back) result = ContainmentType.Intersects;
                }
                return result;
            }
        },
        {
            key: "containsBoundSphere",
            value: function containsBoundSphere(sphere) {
                var result = Plane.PlaneIntersectionType_Front;
                var planeResult = Plane.PlaneIntersectionType_Front;
                for (var i = 0; i < 6; i++) {
                    switch (i) {
                    case 0:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._near, sphere);
                        break;
                    case 1:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._far, sphere);
                        break;
                    case 2:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._left, sphere);
                        break;
                    case 3:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._right, sphere);
                        break;
                    case 4:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._top, sphere);
                        break;
                    case 5:
                        planeResult = CollisionUtils.intersectsPlaneAndSphere(this._bottom, sphere);
                        break;
                    }
                    switch (planeResult) {
                    case Plane.PlaneIntersectionType_Back:
                        return ContainmentType.Disjoint;
                    case Plane.PlaneIntersectionType_Intersecting:
                        result = Plane.PlaneIntersectionType_Intersecting;
                        break;
                    }
                }
                switch (result) {
                case Plane.PlaneIntersectionType_Intersecting:
                    return ContainmentType.Intersects;
                default:
                    return ContainmentType.Contains;
                }
            }
        }], [{
            key: "getPlanesFromMatrix",
            value: function getPlanesFromMatrix(m, np, fp, lp, rp, tp, bp) {
                var matrixE = m.elements;
                var m11 = matrixE[0];
                var m12 = matrixE[1];
                var m13 = matrixE[2];
                var m14 = matrixE[3];
                var m21 = matrixE[4];
                var m22 = matrixE[5];
                var m23 = matrixE[6];
                var m24 = matrixE[7];
                var m31 = matrixE[8];
                var m32 = matrixE[9];
                var m33 = matrixE[10];
                var m34 = matrixE[11];
                var m41 = matrixE[12];
                var m42 = matrixE[13];
                var m43 = matrixE[14];
                var m44 = matrixE[15];
                var nearNorE = np.normal;
                nearNorE.x = m13;
                nearNorE.y = m23;
                nearNorE.z = m33;
                np.distance = m43;
                np.normalize();
                var farNorE = fp.normal;
                farNorE.x = m14 - m13;
                farNorE.y = m24 - m23;
                farNorE.z = m34 - m33;
                fp.distance = m44 - m43;
                fp.normalize();
                var leftNorE = lp.normal;
                leftNorE.x = m14 + m11;
                leftNorE.y = m24 + m21;
                leftNorE.z = m34 + m31;
                lp.distance = m44 + m41;
                lp.normalize();
                var rightNorE = rp.normal;
                rightNorE.x = m14 - m11;
                rightNorE.y = m24 - m21;
                rightNorE.z = m34 - m31;
                rp.distance = m44 - m41;
                rp.normalize();
                var topNorE = tp.normal;
                topNorE.x = m14 - m12;
                topNorE.y = m24 - m22;
                topNorE.z = m34 - m32;
                tp.distance = m44 - m42;
                tp.normalize();
                var bottomNorE = bp.normal;
                bottomNorE.x = m14 + m12;
                bottomNorE.y = m24 + m22;
                bottomNorE.z = m34 + m32;
                bp.distance = m44 + m42;
                bp.normalize();
            }
        },
        {
            key: "get3PlaneInterPoint",
            value: function get3PlaneInterPoint(p1, p2, p3, out) {
                var p1Nor = p1.normal;
                var p2Nor = p2.normal;
                var p3Nor = p3.normal;
                Vector3.cross(p2Nor, p3Nor, BoundFrustum._tempV30);
                Vector3.cross(p3Nor, p1Nor, BoundFrustum._tempV31);
                Vector3.cross(p1Nor, p2Nor, BoundFrustum._tempV32);
                var a = Vector3.dot(p1Nor, BoundFrustum._tempV30);
                var b = Vector3.dot(p2Nor, BoundFrustum._tempV31);
                var c = Vector3.dot(p3Nor, BoundFrustum._tempV32);
                Vector3.scale(BoundFrustum._tempV30, -p1.distance / a, BoundFrustum._tempV33);
                Vector3.scale(BoundFrustum._tempV31, -p2.distance / b, BoundFrustum._tempV34);
                Vector3.scale(BoundFrustum._tempV32, -p3.distance / c, BoundFrustum._tempV35);
                Vector3.add(BoundFrustum._tempV33, BoundFrustum._tempV34, BoundFrustum._tempV36);
                Vector3.add(BoundFrustum._tempV35, BoundFrustum._tempV36, out);
            }
        }]);
        return BoundFrustum;
    } ();
    BoundFrustum._tempV30 = new Vector3();
    BoundFrustum._tempV31 = new Vector3();
    BoundFrustum._tempV32 = new Vector3();
    BoundFrustum._tempV33 = new Vector3();
    BoundFrustum._tempV34 = new Vector3();
    BoundFrustum._tempV35 = new Vector3();
    BoundFrustum._tempV36 = new Vector3();
    var Viewport =
    /*#__PURE__*/
    function() {
        function Viewport(x, y, width, height) {
            _classCallCheck(this, Viewport);
            this.minDepth = 0.0;
            this.maxDepth = 1.0;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
        _createClass(Viewport, [{
            key: "project",
            value: function project(source, matrix, out) {
                Vector3.transformV3ToV4(source, matrix, out);
                var x = out.x,
                y = out.y,
                z = out.z;
                var w = out.w;
                if (w !== 1.0) {
                    x = x / w;
                    y = y / w;
                    z = z / w;
                }
                out.x = (x + 1.0) * 0.5 * this.width + this.x;
                out.y = ( - y + 1.0) * 0.5 * this.height + this.y;
                out.z = z * (this.maxDepth - this.minDepth) + this.minDepth;
            }
        },
        {
            key: "unprojectFromMat",
            value: function unprojectFromMat(source, matrix, out) {
                var matrixEleme = matrix.elements;
                out.x = (source.x - this.x) / this.width * 2.0 - 1.0;
                out.y = -((source.y - this.y) / this.height * 2.0 - 1.0);
                out.z = (source.z - this.minDepth) / (this.maxDepth - this.minDepth);
                var a = out.x * matrixEleme[3] + out.y * matrixEleme[7] + out.z * matrixEleme[11] + matrixEleme[15];
                Vector3.transformV3ToV3(out, matrix, out);
                if (a !== 1.0) {
                    out.x = out.x / a;
                    out.y = out.y / a;
                    out.z = out.z / a;
                }
            }
        },
        {
            key: "unprojectFromWVP",
            value: function unprojectFromWVP(source, projection, view, world, out) {
                Matrix4x4.multiply(projection, view, Viewport._tempMatrix4x4);
                world && Matrix4x4.multiply(Viewport._tempMatrix4x4, world, Viewport._tempMatrix4x4);
                Viewport._tempMatrix4x4.invert(Viewport._tempMatrix4x4);
                this.unprojectFromMat(source, Viewport._tempMatrix4x4, out);
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(out) {
                out.x = this.x;
                out.y = this.y;
                out.width = this.width;
                out.height = this.height;
                out.minDepth = this.minDepth;
                out.maxDepth = this.maxDepth;
            }
        }]);
        return Viewport;
    } ();
    Viewport._tempMatrix4x4 = new Matrix4x4();
    var Picker =
    /*#__PURE__*/
    function() {
        function Picker() {
            _classCallCheck(this, Picker);
        }
        _createClass(Picker, null, [{
            key: "calculateCursorRay",
            value: function calculateCursorRay(point, viewPort, projectionMatrix, viewMatrix, world, out) {
                var x = point.x;
                var y = point.y;
                var nearSource = Picker._tempVector30;
                var nerSourceE = nearSource;
                nerSourceE.x = x;
                nerSourceE.y = y;
                nerSourceE.z = viewPort.minDepth;
                var farSource = Picker._tempVector31;
                var farSourceE = farSource;
                farSourceE.x = x;
                farSourceE.y = y;
                farSourceE.z = viewPort.maxDepth;
                var nearPoint = out.origin;
                var farPoint = Picker._tempVector32;
                viewPort.unprojectFromWVP(nearSource, projectionMatrix, viewMatrix, world, nearPoint);
                viewPort.unprojectFromWVP(farSource, projectionMatrix, viewMatrix, world, farPoint);
                var outDire = out.direction;
                outDire.x = farPoint.x - nearPoint.x;
                outDire.y = farPoint.y - nearPoint.y;
                outDire.z = farPoint.z - nearPoint.z;
                Vector3.normalize(out.direction, out.direction);
            }
        },
        {
            key: "rayIntersectsTriangle",
            value: function rayIntersectsTriangle(ray, vertex1, vertex2, vertex3) {
                var result;
                var edge1 = Picker._tempVector30,
                edge2 = Picker._tempVector31;
                Vector3.subtract(vertex2, vertex1, edge1);
                Vector3.subtract(vertex3, vertex1, edge2);
                var directionCrossEdge2 = Picker._tempVector32;
                Vector3.cross(ray.direction, edge2, directionCrossEdge2);
                var determinant;
                determinant = Vector3.dot(edge1, directionCrossEdge2);
                if (determinant > -Number.MIN_VALUE && determinant < Number.MIN_VALUE) {
                    result = Number.NaN;
                    return result;
                }
                var inverseDeterminant = 1.0 / determinant;
                var distanceVector = Picker._tempVector33;
                Vector3.subtract(ray.origin, vertex1, distanceVector);
                var triangleU;
                triangleU = Vector3.dot(distanceVector, directionCrossEdge2);
                triangleU *= inverseDeterminant;
                if (triangleU < 0 || triangleU > 1) {
                    result = Number.NaN;
                    return result;
                }
                var distanceCrossEdge1 = Picker._tempVector34;
                Vector3.cross(distanceVector, edge1, distanceCrossEdge1);
                var triangleV;
                triangleV = Vector3.dot(ray.direction, distanceCrossEdge1);
                triangleV *= inverseDeterminant;
                if (triangleV < 0 || triangleU + triangleV > 1) {
                    result = Number.NaN;
                    return result;
                }
                var rayDistance;
                rayDistance = Vector3.dot(edge2, distanceCrossEdge1);
                rayDistance *= inverseDeterminant;
                if (rayDistance < 0) {
                    result = Number.NaN;
                    return result;
                }
                result = rayDistance;
                return result;
            }
        }]);
        return Picker;
    } ();
    Picker._tempVector30 = new Vector3();
    Picker._tempVector31 = new Vector3();
    Picker._tempVector32 = new Vector3();
    Picker._tempVector33 = new Vector3();
    Picker._tempVector34 = new Vector3(); (function(IndexFormat) {
        IndexFormat[IndexFormat["UInt8"] = 0] = "UInt8";
        IndexFormat[IndexFormat["UInt16"] = 1] = "UInt16";
        IndexFormat[IndexFormat["UInt32"] = 2] = "UInt32";
    })(exports.IndexFormat || (exports.IndexFormat = {}));
    var IndexBuffer3D =
    /*#__PURE__*/
    function(_Laya$Buffer2) {
        _inherits(IndexBuffer3D, _Laya$Buffer2);
        var _super32 = _createSuper(IndexBuffer3D);
        function IndexBuffer3D(indexType, indexCount) {
            var _this29;
            var bufferUsage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0x88E4;
            var canRead = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
            _classCallCheck(this, IndexBuffer3D);
            _this29 = _super32.call(this);
            _this29._indexType = indexType;
            _this29._indexCount = indexCount;
            _this29._bufferUsage = bufferUsage;
            _this29._bufferType = Laya.LayaGL.instance.ELEMENT_ARRAY_BUFFER;
            _this29._canRead = canRead;
            switch (indexType) {
            case exports.IndexFormat.UInt32:
                _this29._indexTypeByteCount = 4;
                break;
            case exports.IndexFormat.UInt16:
                _this29._indexTypeByteCount = 2;
                break;
            case exports.IndexFormat.UInt8:
                _this29._indexTypeByteCount = 1;
                break;
            default:
                throw new Error("unidentification index type.");
            }
            var byteLength = _this29._indexTypeByteCount * indexCount;
            var curBufSta = Laya.BufferStateBase._curBindedBufferState;
            _this29._byteLength = byteLength;
            if (curBufSta) {
                if (curBufSta._bindedIndexBuffer === _assertThisInitialized(_this29)) {
                    Laya.LayaGL.instance.bufferData(_this29._bufferType, byteLength, _this29._bufferUsage);
                } else {
                    curBufSta.unBind();
                    _this29.bind();
                    Laya.LayaGL.instance.bufferData(_this29._bufferType, byteLength, _this29._bufferUsage);
                    curBufSta.bind();
                }
            } else {
                _this29.bind();
                Laya.LayaGL.instance.bufferData(_this29._bufferType, byteLength, _this29._bufferUsage);
            }
            if (canRead) {
                switch (indexType) {
                case exports.IndexFormat.UInt32:
                    _this29._buffer = new Uint32Array(indexCount);
                    break;
                case exports.IndexFormat.UInt16:
                    _this29._buffer = new Uint16Array(indexCount);
                    break;
                case exports.IndexFormat.UInt8:
                    _this29._buffer = new Uint8Array(indexCount);
                    break;
                }
            }
            return _this29;
        }
        _createClass(IndexBuffer3D, [{
            key: "indexType",
            get: function get() {
                return this._indexType;
            }
        },
        {
            key: "indexTypeByteCount",
            get: function get() {
                return this._indexTypeByteCount;
            }
        },
        {
            key: "indexCount",
            get: function get() {
                return this._indexCount;
            }
        },
        {
            key: "canRead",
            get: function get() {
                return this._canRead;
            }
        },
        {
            key: "_bindForVAO",
            value: function _bindForVAO() {
                if (Laya.BufferStateBase._curBindedBufferState) {
                    var gl = Laya.LayaGL.instance;
                    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._glBuffer);
                } else {
                    throw "IndexBuffer3D: must bind current BufferState.";
                }
            }
        },
        {
            key: "bind",
            value: function bind() {
                if (Laya.BufferStateBase._curBindedBufferState) {
                    throw "IndexBuffer3D: must unbind current BufferState.";
                } else {
                    if (Laya.Buffer._bindedIndexBuffer !== this._glBuffer) {
                        var gl = Laya.LayaGL.instance;
                        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._glBuffer);
                        Laya.Buffer._bindedIndexBuffer = this._glBuffer;
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        },
        {
            key: "setData",
            value: function setData(data) {
                var bufferOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var dataStartIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var dataCount = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 4294967295;
                var byteCount = this._indexTypeByteCount;
                if (dataStartIndex !== 0 || dataCount !== 4294967295) {
                    switch (this._indexType) {
                    case exports.IndexFormat.UInt32:
                        data = new Uint32Array(data.buffer, dataStartIndex * byteCount, dataCount);
                        break;
                    case exports.IndexFormat.UInt16:
                        data = new Uint16Array(data.buffer, dataStartIndex * byteCount, dataCount);
                        break;
                    case exports.IndexFormat.UInt8:
                        data = new Uint8Array(data.buffer, dataStartIndex * byteCount, dataCount);
                        break;
                    }
                }
                var curBufSta = Laya.BufferStateBase._curBindedBufferState;
                if (curBufSta) {
                    if (curBufSta._bindedIndexBuffer === this) {
                        Laya.LayaGL.instance.bufferSubData(this._bufferType, bufferOffset * byteCount, data);
                    } else {
                        curBufSta.unBind();
                        this.bind();
                        Laya.LayaGL.instance.bufferSubData(this._bufferType, bufferOffset * byteCount, data);
                        curBufSta.bind();
                    }
                } else {
                    this.bind();
                    Laya.LayaGL.instance.bufferSubData(this._bufferType, bufferOffset * byteCount, data);
                }
                if (this._canRead) {
                    if (bufferOffset !== 0 || dataStartIndex !== 0 || dataCount !== 4294967295) {
                        var maxLength = this._buffer.length - bufferOffset;
                        if (dataCount > maxLength) dataCount = maxLength;
                        if (_typeof(data) == _typeof(this._buffer) && data.length == dataCount) this._buffer.set(data, bufferOffset);
                        else for (var i = 0; i < dataCount; i++) {
                            this._buffer[bufferOffset + i] = data[i];
                        }
                    } else {
                        this._buffer = data;
                    }
                }
            }
        },
        {
            key: "getData",
            value: function getData() {
                if (this._canRead) return this._buffer;
                else throw new Error("Can't read data from VertexBuffer with only write flag!");
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                _get(_getPrototypeOf(IndexBuffer3D.prototype), "destroy", this).call(this);
                this._buffer = null;
                this._byteLength = 0;
                this._indexCount = 0;
            }
        }]);
        return IndexBuffer3D;
    } (Laya.Buffer);
    var SkyMesh =
    /*#__PURE__*/
    function() {
        function SkyMesh() {
            _classCallCheck(this, SkyMesh);
        }
        _createClass(SkyMesh, [{
            key: "_render",
            value: function _render(state) {}
        }]);
        return SkyMesh;
    } ();
    var SkyBox =
    /*#__PURE__*/
    function(_SkyMesh) {
        _inherits(SkyBox, _SkyMesh);
        var _super33 = _createSuper(SkyBox);
        function SkyBox() {
            var _this30;
            _classCallCheck(this, SkyBox);
            _this30 = _super33.call(this);
            var gl = Laya.LayaGL.instance;
            var halfHeight = 1.0;
            var halfWidth = 1.0;
            var halfDepth = 1.0;
            var vertices = new Float32Array([ - halfDepth, halfHeight, -halfWidth, halfDepth, halfHeight, -halfWidth, halfDepth, halfHeight, halfWidth, -halfDepth, halfHeight, halfWidth, -halfDepth, -halfHeight, -halfWidth, halfDepth, -halfHeight, -halfWidth, halfDepth, -halfHeight, halfWidth, -halfDepth, -halfHeight, halfWidth]);
            var indices = new Uint8Array([0, 1, 2, 2, 3, 0, 4, 7, 6, 6, 5, 4, 0, 3, 7, 7, 4, 0, 1, 5, 6, 6, 2, 1, 3, 2, 6, 6, 7, 3, 0, 4, 5, 5, 1, 0]);
            var verDec = VertexMesh.getVertexDeclaration("POSITION");
            _this30._vertexBuffer = new VertexBuffer3D(verDec.vertexStride * 8, gl.STATIC_DRAW, false);
            _this30._vertexBuffer.vertexDeclaration = verDec;
            _this30._indexBuffer = new IndexBuffer3D(exports.IndexFormat.UInt8, 36, gl.STATIC_DRAW, false);
            _this30._vertexBuffer.setData(vertices.buffer);
            _this30._indexBuffer.setData(indices);
            var bufferState = new BufferState();
            bufferState.bind();
            bufferState.applyVertexBuffer(_this30._vertexBuffer);
            bufferState.applyIndexBuffer(_this30._indexBuffer);
            bufferState.unBind();
            _this30._bufferState = bufferState;
            return _this30;
        }
        _createClass(SkyBox, [{
            key: "_render",
            value: function _render(state) {
                var gl = Laya.LayaGL.instance;
                gl.drawElements(gl.TRIANGLES, 36, gl.UNSIGNED_BYTE, 0);
                Laya.Stat.trianglesFaces += 12;
                Laya.Stat.renderBatches++;
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                SkyBox.instance = new SkyBox();
            }
        }]);
        return SkyBox;
    } (SkyMesh);
    var SkyRenderer =
    /*#__PURE__*/
    function() {
        function SkyRenderer() {
            _classCallCheck(this, SkyRenderer);
            this._mesh = SkyBox.instance;
        }
        _createClass(SkyRenderer, [{
            key: "material",
            get: function get() {
                return this._material;
            },
            set: function set(value) {
                if (this._material !== value) {
                    this._material && this._material._removeReference();
                    value && value._addReference();
                    this._material = value;
                }
            }
        },
        {
            key: "mesh",
            get: function get() {
                return this._mesh;
            },
            set: function set(value) {
                if (this._mesh !== value) {
                    this._mesh = value;
                }
            }
        },
        {
            key: "_isAvailable",
            value: function _isAvailable() {
                return this._material && this._mesh ? true: false;
            }
        },
        {
            key: "_render",
            value: function _render(context) {
                if (this._material && this._mesh) {
                    var gl = Laya.LayaGL.instance;
                    var scene = context.scene;
                    var cameraShaderValue = context.cameraShaderValue;
                    var camera = context.camera;
                    var noteValue = ShaderData._SET_RUNTIME_VALUE_MODE_REFERENCE_;
                    Laya.ILaya.Render.supportWebGLPlusRendering && ShaderData.setRuntimeValueMode(false);
                    Laya.WebGLContext.setCullFace(gl, false);
                    Laya.WebGLContext.setDepthFunc(gl, gl.LEQUAL);
                    Laya.WebGLContext.setDepthMask(gl, false);
                    Laya.WebGLContext.setStencilMask(gl, false);
                    var comDef = SkyRenderer._compileDefine;
                    this._material._shaderValues._defineDatas.cloneTo(comDef);
                    var shader = context.shader = this._material._shader.getSubShaderAt(0)._passes[0].withCompile(comDef);
                    var switchShader = shader.bind();
                    var switchShaderLoop = Laya.Stat.loopCount !== shader._uploadMark;
                    var uploadScene = shader._uploadScene !== scene || switchShaderLoop;
                    if (uploadScene || switchShader) {
                        shader.uploadUniforms(shader._sceneUniformParamsMap, scene._shaderValues, uploadScene);
                        shader._uploadScene = scene;
                    }
                    var uploadCamera = shader._uploadCameraShaderValue !== cameraShaderValue || switchShaderLoop;
                    if (uploadCamera || switchShader) {
                        var viewMatrix = SkyRenderer._tempMatrix0;
                        var projectionMatrix = SkyRenderer._tempMatrix1;
                        camera.viewMatrix.cloneTo(viewMatrix);
                        camera.projectionMatrix.cloneTo(projectionMatrix);
                        viewMatrix.setTranslationVector(Vector3._ZERO);
                        if (camera.orthographic) Matrix4x4.createPerspective(camera.fieldOfView, camera.aspectRatio, camera.nearPlane, camera.farPlane, projectionMatrix);
                        var epsilon = 1e-6;
                        var yScale = 1.0 / Math.tan(3.1416 * camera.fieldOfView / 180 * 0.5);
                        projectionMatrix.elements[0] = yScale / camera.aspectRatio;
                        projectionMatrix.elements[5] = yScale;
                        projectionMatrix.elements[10] = epsilon - 1.0;
                        projectionMatrix.elements[11] = -1.0;
                        projectionMatrix.elements[14] = -0;
                        if (camera.isWebXR) {
                            camera._applyViewProject(context, viewMatrix, camera.projectionMatrix);
                        } else {
                            camera._applyViewProject(context, viewMatrix, projectionMatrix);
                        }
                        shader.uploadUniforms(shader._cameraUniformParamsMap, cameraShaderValue, uploadCamera);
                        shader._uploadCameraShaderValue = cameraShaderValue;
                    }
                    var uploadMaterial = shader._uploadMaterial !== this._material || switchShaderLoop;
                    if (uploadMaterial || switchShader) {
                        shader.uploadUniforms(shader._materialUniformParamsMap, this._material._shaderValues, uploadMaterial);
                        shader._uploadMaterial = this._material;
                    }
                    this._mesh._bufferState.bind();
                    this._mesh._render(context);
                    Laya.ILaya.Render.supportWebGLPlusRendering && ShaderData.setRuntimeValueMode(noteValue);
                    Laya.WebGLContext.setDepthFunc(gl, gl.LESS);
                    Laya.WebGLContext.setDepthMask(gl, true);
                    camera._applyViewProject(context, camera.viewMatrix, camera.projectionMatrix);
                }
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                if (this._material) {
                    this._material._removeReference();
                    this._material = null;
                }
            }
        }]);
        return SkyRenderer;
    } ();
    SkyRenderer._tempMatrix0 = new Matrix4x4();
    SkyRenderer._tempMatrix1 = new Matrix4x4();
    SkyRenderer._compileDefine = new DefineDatas();
    var BaseCamera =
    /*#__PURE__*/
    function(_Sprite3D) {
        _inherits(BaseCamera, _Sprite3D);
        var _super34 = _createSuper(BaseCamera);
        function BaseCamera() {
            var _this31;
            var nearPlane = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.3;
            var farPlane = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1000;
            _classCallCheck(this, BaseCamera);
            _this31 = _super34.call(this);
            _this31._skyRenderer = new SkyRenderer();
            _this31._forward = new Vector3();
            _this31._up = new Vector3();
            _this31.clearColor = new Vector4(100 / 255, 149 / 255, 237 / 255, 255 / 255);
            _this31._shaderValues = new ShaderData(null);
            _this31._fieldOfView = 60;
            _this31._useUserProjectionMatrix = false;
            _this31._orthographic = false;
            _this31._orthographicVerticalSize = 10;
            _this31.renderingOrder = 0;
            _this31._nearPlane = nearPlane;
            _this31._farPlane = farPlane;
            _this31.cullingMask = 2147483647;
            _this31.useOcclusionCulling = true;
            return _this31;
        }
        _createClass(BaseCamera, [{
            key: "skyRenderer",
            get: function get() {
                return this._skyRenderer;
            }
        },
        {
            key: "fieldOfView",
            get: function get() {
                return this._fieldOfView;
            },
            set: function set(value) {
                this._fieldOfView = value;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "nearPlane",
            get: function get() {
                return this._nearPlane;
            },
            set: function set(value) {
                this._nearPlane = value;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "farPlane",
            get: function get() {
                return this._farPlane;
            },
            set: function set(vaule) {
                this._farPlane = vaule;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "orthographic",
            get: function get() {
                return this._orthographic;
            },
            set: function set(vaule) {
                this._orthographic = vaule;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "orthographicVerticalSize",
            get: function get() {
                return this._orthographicVerticalSize;
            },
            set: function set(vaule) {
                this._orthographicVerticalSize = vaule;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "renderingOrder",
            get: function get() {
                return this._renderingOrder;
            },
            set: function set(value) {
                this._renderingOrder = value;
                this._sortCamerasByRenderingOrder();
            }
        },
        {
            key: "_sortCamerasByRenderingOrder",
            value: function _sortCamerasByRenderingOrder() {
                if (this.displayedInStage) {
                    var cameraPool = this.scene._cameraPool;
                    var n = cameraPool.length - 1;
                    for (var i = 0; i < n; i++) {
                        if (cameraPool[i].renderingOrder > cameraPool[n].renderingOrder) {
                            var tempCamera = cameraPool[i];
                            cameraPool[i] = cameraPool[n];
                            cameraPool[n] = tempCamera;
                        }
                    }
                }
            }
        },
        {
            key: "_calculateProjectionMatrix",
            value: function _calculateProjectionMatrix() {}
        },
        {
            key: "_onScreenSizeChanged",
            value: function _onScreenSizeChanged() {
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "_prepareCameraToRender",
            value: function _prepareCameraToRender() {
                var cameraSV = this._shaderValues;
                this.transform.getForward(this._forward);
                this.transform.getUp(this._up);
                cameraSV.setVector3(BaseCamera.CAMERAPOS, this.transform.position);
                cameraSV.setVector3(BaseCamera.CAMERADIRECTION, this._forward);
                cameraSV.setVector3(BaseCamera.CAMERAUP, this._up);
            }
        },
        {
            key: "render",
            value: function render() {
                var shader = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                var replacementTag = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
            }
        },
        {
            key: "addLayer",
            value: function addLayer(layer) {
                this.cullingMask |= Math.pow(2, layer);
            }
        },
        {
            key: "removeLayer",
            value: function removeLayer(layer) {
                this.cullingMask &= ~Math.pow(2, layer);
            }
        },
        {
            key: "addAllLayers",
            value: function addAllLayers() {
                this.cullingMask = 2147483647;
            }
        },
        {
            key: "removeAllLayers",
            value: function removeAllLayers() {
                this.cullingMask = 0;
            }
        },
        {
            key: "resetProjectionMatrix",
            value: function resetProjectionMatrix() {
                this._useUserProjectionMatrix = false;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "_onActive",
            value: function _onActive() {
                this._scene._addCamera(this);
                _get(_getPrototypeOf(BaseCamera.prototype), "_onActive", this).call(this);
            }
        },
        {
            key: "_onInActive",
            value: function _onInActive() {
                this._scene._removeCamera(this);
                _get(_getPrototypeOf(BaseCamera.prototype), "_onInActive", this).call(this);
            }
        },
        {
            key: "_parse",
            value: function _parse(data, spriteMap) {
                _get(_getPrototypeOf(BaseCamera.prototype), "_parse", this).call(this, data, spriteMap);
                this.orthographic = data.orthographic;
                data.orthographicVerticalSize !== undefined && (this.orthographicVerticalSize = data.orthographicVerticalSize);
                data.fieldOfView !== undefined && (this.fieldOfView = data.fieldOfView);
                this.nearPlane = data.nearPlane;
                this.farPlane = data.farPlane;
                var color = data.clearColor;
                this.clearColor = new Vector4(color[0], color[1], color[2], color[3]);
                var skyboxMaterial = data.skyboxMaterial;
                if (skyboxMaterial) {
                    this._skyRenderer.material = Laya.Loader.getRes(skyboxMaterial.path);
                }
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                this._skyRenderer.destroy();
                this._skyRenderer = null;
                Laya.Laya.stage.off(Laya.Event.RESIZE, this, this._onScreenSizeChanged);
                _get(_getPrototypeOf(BaseCamera.prototype), "destroy", this).call(this, destroyChild);
            }
        },
        {
            key: "_create",
            value: function _create() {
                return new BaseCamera();
            }
        }]);
        return BaseCamera;
    } (Sprite3D);
    BaseCamera._tempMatrix4x40 = new Matrix4x4();
    BaseCamera.CAMERAPOS = Shader3D.propertyNameToID("u_CameraPos");
    BaseCamera.VIEWMATRIX = Shader3D.propertyNameToID("u_View");
    BaseCamera.PROJECTMATRIX = Shader3D.propertyNameToID("u_Projection");
    BaseCamera.VIEWPROJECTMATRIX = Shader3D.propertyNameToID("u_ViewProjection");
    BaseCamera.CAMERADIRECTION = Shader3D.propertyNameToID("u_CameraDirection");
    BaseCamera.CAMERAUP = Shader3D.propertyNameToID("u_CameraUp");
    BaseCamera.VIEWPORT = Shader3D.propertyNameToID("u_Viewport");
    BaseCamera.PROJECTION_PARAMS = Shader3D.propertyNameToID("u_ProjectionParams");
    BaseCamera.DEPTHTEXTURE = Shader3D.propertyNameToID("u_CameraDepthTexture");
    BaseCamera.DEPTHNORMALSTEXTURE = Shader3D.propertyNameToID("u_CameraDepthNormalsTexture");
    BaseCamera.DEPTHZBUFFERPARAMS = Shader3D.propertyNameToID("u_ZBufferParams");
    BaseCamera.OPAQUETEXTURE = Shader3D.propertyNameToID("u_cameraOpaqueTexture");
    BaseCamera.SHADERDEFINE_DEPTH = Shader3D.getDefineByName("DEPTHMAP");
    BaseCamera.SHADERDEFINE_DEPTHNORMALS = Shader3D.getDefineByName("DEPTHNORMALSMAP");
    BaseCamera.RENDERINGTYPE_DEFERREDLIGHTING = "DEFERREDLIGHTING";
    BaseCamera.RENDERINGTYPE_FORWARDRENDERING = "FORWARDRENDERING";
    BaseCamera._invertYScaleMatrix = new Matrix4x4(1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
    BaseCamera._invertYProjectionMatrix = new Matrix4x4();
    BaseCamera._invertYProjectionViewMatrix = new Matrix4x4();
    BaseCamera.CLEARFLAG_SOLIDCOLOR = 0;
    BaseCamera.CLEARFLAG_SKY = 1;
    BaseCamera.CLEARFLAG_DEPTHONLY = 2;
    BaseCamera.CLEARFLAG_NONE = 3; (function(ShadowMode) {
        ShadowMode[ShadowMode["None"] = 0] = "None";
        ShadowMode[ShadowMode["Hard"] = 1] = "Hard";
        ShadowMode[ShadowMode["SoftLow"] = 2] = "SoftLow";
        ShadowMode[ShadowMode["SoftHigh"] = 3] = "SoftHigh";
    })(exports.ShadowMode || (exports.ShadowMode = {}));
    var Scene3DShaderDeclaration =
    /*#__PURE__*/
    _createClass(function Scene3DShaderDeclaration() {
        _classCallCheck(this, Scene3DShaderDeclaration);
    }); (function(LightType) {
        LightType[LightType["Directional"] = 0] = "Directional";
        LightType[LightType["Spot"] = 1] = "Spot";
        LightType[LightType["Point"] = 2] = "Point";
    })(exports.LightType || (exports.LightType = {}));
    var LightSprite =
    /*#__PURE__*/
    function(_Sprite3D2) {
        _inherits(LightSprite, _Sprite3D2);
        var _super35 = _createSuper(LightSprite);
        function LightSprite() {
            var _this32;
            _classCallCheck(this, LightSprite);
            _this32 = _super35.call(this);
            _this32._shadowMode = exports.ShadowMode.None;
            _this32._isAlternate = false;
            _this32._shadowResolution = 2048;
            _this32._shadowDistance = 50.0;
            _this32._shadowDepthBias = 1.0;
            _this32._shadowNormalBias = 1.0;
            _this32._shadowNearPlane = 0.1;
            _this32._shadowStrength = 1.0;
            _this32._lightWoldMatrix = new Matrix4x4();
            _this32._intensity = 1.0;
            _this32._intensityColor = new Vector3();
            _this32.color = new Vector3(1.0, 1.0, 1.0);
            _this32._lightmapBakedType = LightSprite.LIGHTMAPBAKEDTYPE_REALTIME;
            return _this32;
        }
        _createClass(LightSprite, [{
            key: "intensity",
            get: function get() {
                return this._intensity;
            },
            set: function set(value) {
                this._intensity = value;
            }
        },
        {
            key: "shadowMode",
            get: function get() {
                return this._shadowMode;
            },
            set: function set(value) {
                this._shadowMode = value;
            }
        },
        {
            key: "shadowDistance",
            get: function get() {
                return this._shadowDistance;
            },
            set: function set(value) {
                this._shadowDistance = value;
            }
        },
        {
            key: "shadowResolution",
            get: function get() {
                return this._shadowResolution;
            },
            set: function set(value) {
                this._shadowResolution = value;
            }
        },
        {
            key: "shadowDepthBias",
            get: function get() {
                return this._shadowDepthBias;
            },
            set: function set(value) {
                this._shadowDepthBias = value;
            }
        },
        {
            key: "shadowNormalBias",
            get: function get() {
                return this._shadowNormalBias;
            },
            set: function set(value) {
                this._shadowNormalBias = value;
            }
        },
        {
            key: "shadowStrength",
            get: function get() {
                return this._shadowStrength;
            },
            set: function set(value) {
                this._shadowStrength = value;
            }
        },
        {
            key: "shadowNearPlane",
            get: function get() {
                return this._shadowNearPlane;
            },
            set: function set(value) {
                this._shadowNearPlane = value;
            }
        },
        {
            key: "lightmapBakedType",
            get: function get() {
                return this._lightmapBakedType;
            },
            set: function set(value) {
                if (this._lightmapBakedType !== value) {
                    this._lightmapBakedType = value;
                    if (this.activeInHierarchy) {
                        if (value !== LightSprite.LIGHTMAPBAKEDTYPE_BAKED) this._addToScene();
                        else this._removeFromScene();
                    }
                }
            }
        },
        {
            key: "lightWorldMatrix",
            get: function get() {
                var position = this.transform.position;
                var quaterian = this.transform.rotation;
                Matrix4x4.createAffineTransformation(position, quaterian, Vector3._ONE, this._lightWoldMatrix);
                return this._lightWoldMatrix;
            }
        },
        {
            key: "_parse",
            value: function _parse(data, spriteMap) {
                _get(_getPrototypeOf(LightSprite.prototype), "_parse", this).call(this, data, spriteMap);
                var colorData = data.color;
                this.color.fromArray(colorData);
                this.intensity = data.intensity;
                this.lightmapBakedType = data.lightmapBakedType;
            }
        },
        {
            key: "_cloneTo",
            value: function _cloneTo(destObject, rootSprite, dstSprite) {
                _get(_getPrototypeOf(LightSprite.prototype), "_cloneTo", this).call(this, destObject, rootSprite, dstSprite);
                var spriteLight = destObject;
                spriteLight.color = this.color.clone();
                spriteLight.intensity = this.intensity;
                spriteLight.lightmapBakedType = this.lightmapBakedType;
            }
        },
        {
            key: "_addToScene",
            value: function _addToScene() {
                var scene = this._scene;
                var maxLightCount = Config3D._config.maxLightCount;
                if (scene._lightCount < maxLightCount) {
                    scene._lightCount++;
                    this._addToLightQueue();
                    this._isAlternate = false;
                } else {
                    scene._alternateLights.add(this);
                    this._isAlternate = true;
                    console.warn("LightSprite:light count has large than maxLightCount,the latest added light will be ignore.");
                }
            }
        },
        {
            key: "_removeFromScene",
            value: function _removeFromScene() {
                var scene = this._scene;
                if (this._isAlternate) {
                    scene._alternateLights.remove(this);
                } else {
                    scene._lightCount--;
                    this._removeFromLightQueue();
                    if (scene._alternateLights._length > 0) {
                        var alternateLight = scene._alternateLights.shift();
                        alternateLight._addToLightQueue();
                        alternateLight._isAlternate = false;
                        scene._lightCount++;
                    }
                }
            }
        },
        {
            key: "_addToLightQueue",
            value: function _addToLightQueue() {}
        },
        {
            key: "_removeFromLightQueue",
            value: function _removeFromLightQueue() {}
        },
        {
            key: "_onActive",
            value: function _onActive() {
                _get(_getPrototypeOf(LightSprite.prototype), "_onActive", this).call(this);
                this.lightmapBakedType !== LightSprite.LIGHTMAPBAKEDTYPE_BAKED && this._addToScene();
            }
        },
        {
            key: "_onInActive",
            value: function _onInActive() {
                _get(_getPrototypeOf(LightSprite.prototype), "_onInActive", this).call(this);
                this.lightmapBakedType !== LightSprite.LIGHTMAPBAKEDTYPE_BAKED && this._removeFromScene();
            }
        },
        {
            key: "_create",
            value: function _create() {
                return new LightSprite();
            }
        },
        {
            key: "diffuseColor",
            get: function get() {
                console.log("LightSprite: discard property,please use color property instead.");
                return this.color;
            },
            set: function set(value) {
                console.log("LightSprite: discard property,please use color property instead.");
                this.color = value;
            }
        }]);
        return LightSprite;
    } (Sprite3D);
    LightSprite.LIGHTMAPBAKEDTYPE_REALTIME = 0;
    LightSprite.LIGHTMAPBAKEDTYPE_MIXED = 1;
    LightSprite.LIGHTMAPBAKEDTYPE_BAKED = 2; (function(ShadowCascadesMode) {
        ShadowCascadesMode[ShadowCascadesMode["NoCascades"] = 0] = "NoCascades";
        ShadowCascadesMode[ShadowCascadesMode["TwoCascades"] = 1] = "TwoCascades";
        ShadowCascadesMode[ShadowCascadesMode["FourCascades"] = 2] = "FourCascades";
    })(exports.ShadowCascadesMode || (exports.ShadowCascadesMode = {}));
    var FrustumFace; (function(FrustumFace) {
        FrustumFace[FrustumFace["Near"] = 0] = "Near";
        FrustumFace[FrustumFace["Far"] = 1] = "Far";
        FrustumFace[FrustumFace["Left"] = 2] = "Left";
        FrustumFace[FrustumFace["Right"] = 3] = "Right";
        FrustumFace[FrustumFace["Bottom"] = 4] = "Bottom";
        FrustumFace[FrustumFace["Top"] = 5] = "Top";
    })(FrustumFace || (FrustumFace = {}));
    var ShadowUtils =
    /*#__PURE__*/
    function() {
        function ShadowUtils() {
            _classCallCheck(this, ShadowUtils);
        }
        _createClass(ShadowUtils, null, [{
            key: "supportShadow",
            value: function supportShadow() {
                return Laya.LayaGL.layaGPUInstance._isWebGL2 || Laya.SystemUtils.supportRenderTextureFormat(Laya.RenderTextureFormat.Depth);
            }
        },
        {
            key: "init",
            value: function init() {
                if (Laya.LayaGL.layaGPUInstance._isWebGL2) ShadowUtils._shadowTextureFormat = Laya.RenderTextureFormat.ShadowMap;
                else ShadowUtils._shadowTextureFormat = Laya.RenderTextureFormat.Depth;
            }
        },
        {
            key: "getTemporaryShadowTexture",
            value: function getTemporaryShadowTexture(witdh, height, depthFormat) {
                var shadowMap = RenderTexture.createFromPool(witdh, height, ShadowUtils._shadowTextureFormat, depthFormat);
                shadowMap.filterMode = Laya.FilterMode.Bilinear;
                shadowMap.wrapModeU = Laya.WarpMode.Clamp;
                shadowMap.wrapModeV = Laya.WarpMode.Clamp;
                return shadowMap;
            }
        },
        {
            key: "getShadowBias",
            value: function getShadowBias(light, shadowProjectionMatrix, shadowResolution, out) {
                var frustumSize;
                if (light._lightType == exports.LightType.Directional) {
                    frustumSize = 2.0 / shadowProjectionMatrix.elements[0];
                } else if (light._lightType == exports.LightType.Spot) {
                    frustumSize = Math.tan(light.spotAngle * 0.5 * MathUtils3D.Deg2Rad) * light.range;
                } else {
                    console.warn("ShadowUtils:Only spot and directional shadow casters are supported now.");
                    frustumSize = 0.0;
                }
                var texelSize = frustumSize / shadowResolution;
                var depthBias = -light._shadowDepthBias * texelSize;
                var normalBias = -light._shadowNormalBias * texelSize;
                if (light.shadowMode == exports.ShadowMode.SoftHigh) {
                    var kernelRadius = 2.5;
                    depthBias *= kernelRadius;
                    normalBias *= kernelRadius;
                }
                out.setValue(depthBias, normalBias, 0.0, 0.0);
            }
        },
        {
            key: "getCameraFrustumPlanes",
            value: function getCameraFrustumPlanes(cameraViewProjectMatrix, frustumPlanes) {
                BoundFrustum.getPlanesFromMatrix(cameraViewProjectMatrix, frustumPlanes[FrustumFace.Near], frustumPlanes[FrustumFace.Far], frustumPlanes[FrustumFace.Left], frustumPlanes[FrustumFace.Right], frustumPlanes[FrustumFace.Top], frustumPlanes[FrustumFace.Bottom]);
            }
        },
        {
            key: "getFarWithRadius",
            value: function getFarWithRadius(radius, denominator) {
                return Math.sqrt(radius * radius / denominator);
            }
        },
        {
            key: "getCascadesSplitDistance",
            value: function getCascadesSplitDistance(twoSplitRatio, fourSplitRatio, cameraNear, shadowFar, fov, aspectRatio, cascadesMode, out) {
                out[0] = cameraNear;
                var range = shadowFar - cameraNear;
                var tFov = Math.tan(fov * 0.5);
                var denominator = 1.0 + tFov * tFov * (aspectRatio * aspectRatio + 1.0);
                switch (cascadesMode) {
                case exports.ShadowCascadesMode.NoCascades:
                    out[1] = ShadowUtils.getFarWithRadius(shadowFar, denominator);
                    break;
                case exports.ShadowCascadesMode.TwoCascades:
                    out[1] = ShadowUtils.getFarWithRadius(cameraNear + range * twoSplitRatio, denominator);
                    out[2] = ShadowUtils.getFarWithRadius(shadowFar, denominator);
                    break;
                case exports.ShadowCascadesMode.FourCascades:
                    out[1] = ShadowUtils.getFarWithRadius(cameraNear + range * fourSplitRatio.x, denominator);
                    out[2] = ShadowUtils.getFarWithRadius(cameraNear + range * fourSplitRatio.y, denominator);
                    out[3] = ShadowUtils.getFarWithRadius(cameraNear + range * fourSplitRatio.z, denominator);
                    out[4] = ShadowUtils.getFarWithRadius(shadowFar, denominator);
                    break;
                }
            }
        },
        {
            key: "applySliceTransform",
            value: function applySliceTransform(shadowSliceData, atlasWidth, atlasHeight, cascadeIndex, outShadowMatrices) {
                var sliceE = ShadowUtils._tempMatrix0.elements;
                var oneOverAtlasWidth = 1.0 / atlasWidth;
                var oneOverAtlasHeight = 1.0 / atlasHeight;
                sliceE[0] = shadowSliceData.resolution * oneOverAtlasWidth;
                sliceE[5] = shadowSliceData.resolution * oneOverAtlasHeight;
                sliceE[12] = shadowSliceData.offsetX * oneOverAtlasWidth;
                sliceE[13] = shadowSliceData.offsetY * oneOverAtlasHeight;
                sliceE[1] = sliceE[2] = sliceE[2] = sliceE[4] = sliceE[6] = sliceE[7] = sliceE[8] = sliceE[9] = sliceE[11] = sliceE[14] = 0;
                sliceE[10] = sliceE[15] = 1;
                var offset = cascadeIndex * 16;
                Utils3D._mulMatrixArray(sliceE, outShadowMatrices, offset, outShadowMatrices, offset);
            }
        },
        {
            key: "getDirectionLightShadowCullPlanes",
            value: function getDirectionLightShadowCullPlanes(cameraFrustumPlanes, cascadeIndex, splitDistance, cameraNear, direction, shadowSliceData) {
                var frustumCorners = ShadowUtils._frustumCorners;
                var backPlaneFaces = ShadowUtils._backPlaneFaces;
                var planeNeighbors = ShadowUtils._frustumPlaneNeighbors;
                var twoPlaneCorners = ShadowUtils._frustumTwoPlaneCorners;
                var edgePlanePoint2 = ShadowUtils._edgePlanePoint2;
                var out = shadowSliceData.cullPlanes;
                var near = cameraFrustumPlanes[FrustumFace.Near],
                far = cameraFrustumPlanes[FrustumFace.Far];
                var left = cameraFrustumPlanes[FrustumFace.Left],
                right = cameraFrustumPlanes[FrustumFace.Right];
                var bottom = cameraFrustumPlanes[FrustumFace.Bottom],
                top = cameraFrustumPlanes[FrustumFace.Top];
                var splitNearDistance = splitDistance[cascadeIndex] - cameraNear;
                var splitNear = ShadowUtils._adjustNearPlane;
                var splitFar = ShadowUtils._adjustFarPlane;
                near.normal.cloneTo(splitNear.normal);
                far.normal.cloneTo(splitFar.normal);
                splitNear.distance = near.distance - splitNearDistance;
                splitFar.distance = Math.min( - near.distance + shadowSliceData.sphereCenterZ + shadowSliceData.splitBoundSphere.radius, far.distance);
                BoundFrustum.get3PlaneInterPoint(splitNear, bottom, right, frustumCorners[exports.FrustumCorner.nearBottomRight]);
                BoundFrustum.get3PlaneInterPoint(splitNear, top, right, frustumCorners[exports.FrustumCorner.nearTopRight]);
                BoundFrustum.get3PlaneInterPoint(splitNear, top, left, frustumCorners[exports.FrustumCorner.nearTopLeft]);
                BoundFrustum.get3PlaneInterPoint(splitNear, bottom, left, frustumCorners[exports.FrustumCorner.nearBottomLeft]);
                BoundFrustum.get3PlaneInterPoint(splitFar, bottom, right, frustumCorners[exports.FrustumCorner.FarBottomRight]);
                BoundFrustum.get3PlaneInterPoint(splitFar, top, right, frustumCorners[exports.FrustumCorner.FarTopRight]);
                BoundFrustum.get3PlaneInterPoint(splitFar, top, left, frustumCorners[exports.FrustumCorner.FarTopLeft]);
                BoundFrustum.get3PlaneInterPoint(splitFar, bottom, left, frustumCorners[exports.FrustumCorner.FarBottomLeft]);
                var backIndex = 0;
                for (var i = 0; i < 6; i++) {
                    var plane;
                    switch (i) {
                    case FrustumFace.Near:
                        plane = splitNear;
                        break;
                    case FrustumFace.Far:
                        plane = splitFar;
                        break;
                    default:
                        plane = cameraFrustumPlanes[i];
                        break;
                    }
                    if (Vector3.dot(plane.normal, direction) < 0.0) {
                        plane.cloneTo(out[backIndex]);
                        backPlaneFaces[backIndex] = i;
                        backIndex++;
                    }
                }
                var edgeIndex = backIndex;
                for (var i = 0; i < backIndex; i++) {
                    var backFace = backPlaneFaces[i];
                    var neighborFaces = planeNeighbors[backFace];
                    for (var j = 0; j < 4; j++) {
                        var neighborFace = neighborFaces[j];
                        var notBackFace = true;
                        for (var k = 0; k < backIndex; k++) {
                            if (neighborFace == backPlaneFaces[k]) {
                                notBackFace = false;
                                break;
                            }
                        }
                        if (notBackFace) {
                            var corners = twoPlaneCorners[backFace][neighborFace];
                            var point0 = frustumCorners[corners[0]];
                            var point1 = frustumCorners[corners[1]];
                            Vector3.add(point0, direction, edgePlanePoint2);
                            Plane.createPlaneBy3P(point0, point1, edgePlanePoint2, out[edgeIndex++]);
                        }
                    }
                }
                shadowSliceData.cullPlaneCount = edgeIndex;
            }
        },
        {
            key: "getBoundSphereByFrustum",
            value: function getBoundSphereByFrustum(near, far, fov, aspectRatio, cameraPos, forward, outBoundSphere) {
                var centerZ;
                var radius;
                var k = Math.sqrt(1.0 + aspectRatio * aspectRatio) * Math.tan(fov / 2.0);
                var k2 = k * k;
                var farSNear = far - near;
                var farANear = far + near;
                if (k2 > farSNear / farANear) {
                    centerZ = far;
                    radius = far * k;
                } else {
                    centerZ = 0.5 * farANear * (1 + k2);
                    radius = 0.5 * Math.sqrt(farSNear * farSNear + 2.0 * (far * far + near * near) * k2 + farANear * farANear * k2 * k2);
                }
                var center = outBoundSphere.center;
                outBoundSphere.radius = radius;
                Vector3.scale(forward, centerZ, center);
                Vector3.add(cameraPos, center, center);
                return centerZ;
            }
        },
        {
            key: "getMaxTileResolutionInAtlas",
            value: function getMaxTileResolutionInAtlas(atlasWidth, atlasHeight, tileCount) {
                var resolution = Math.min(atlasWidth, atlasHeight);
                var currentTileCount = Math.floor(atlasWidth / resolution) * Math.floor(atlasHeight / resolution);
                while (currentTileCount < tileCount) {
                    resolution = Math.floor(resolution >> 1);
                    currentTileCount = Math.floor(atlasWidth / resolution) * Math.floor(atlasHeight / resolution);
                }
                return resolution;
            }
        },
        {
            key: "getDirectionalLightMatrices",
            value: function getDirectionalLightMatrices(lightUp, lightSide, lightForward, cascadeIndex, nearPlane, shadowResolution, shadowSliceData, shadowMatrices) {
                var boundSphere = shadowSliceData.splitBoundSphere;
                var center = boundSphere.center;
                var radius = boundSphere.radius;
                var halfShadowResolution = shadowResolution / 2;
                var borderRadius = radius * halfShadowResolution / (halfShadowResolution - ShadowUtils.atlasBorderSize);
                var borderDiam = borderRadius * 2.0;
                var sizeUnit = shadowResolution / borderDiam;
                var radiusUnit = borderDiam / shadowResolution;
                var upLen = Math.ceil(Vector3.dot(center, lightUp) * sizeUnit) * radiusUnit;
                var sideLen = Math.ceil(Vector3.dot(center, lightSide) * sizeUnit) * radiusUnit;
                var forwardLen = Vector3.dot(center, lightForward);
                center.x = lightUp.x * upLen + lightSide.x * sideLen + lightForward.x * forwardLen;
                center.y = lightUp.y * upLen + lightSide.y * sideLen + lightForward.y * forwardLen;
                center.z = lightUp.z * upLen + lightSide.z * sideLen + lightForward.z * forwardLen;
                var origin = shadowSliceData.position;
                var viewMatrix = shadowSliceData.viewMatrix;
                var projectMatrix = shadowSliceData.projectionMatrix;
                var viewProjectMatrix = shadowSliceData.viewProjectMatrix;
                shadowSliceData.resolution = shadowResolution;
                shadowSliceData.offsetX = cascadeIndex % 2 * shadowResolution;
                shadowSliceData.offsetY = Math.floor(cascadeIndex / 2) * shadowResolution;
                Vector3.scale(lightForward, radius + nearPlane, origin);
                Vector3.subtract(center, origin, origin);
                Matrix4x4.createLookAt(origin, center, lightUp, viewMatrix);
                Matrix4x4.createOrthoOffCenter( - borderRadius, borderRadius, -borderRadius, borderRadius, 0.0, radius * 2.0 + nearPlane, projectMatrix);
                Matrix4x4.multiply(projectMatrix, viewMatrix, viewProjectMatrix);
                Utils3D._mulMatrixArray(ShadowUtils._shadowMapScaleOffsetMatrix.elements, viewProjectMatrix.elements, 0, shadowMatrices, cascadeIndex * 16);
            }
        },
        {
            key: "getSpotLightShadowData",
            value: function getSpotLightShadowData(shadowSpotData, spotLight, resolution, shadowParams, shadowSpotMatrices, shadowMapSize) {
                var out = shadowSpotData.position = spotLight.transform.position;
                shadowSpotData.resolution = resolution;
                shadowMapSize.setValue(1.0 / resolution, 1.0 / resolution, resolution, resolution);
                shadowSpotData.offsetX = 0;
                shadowSpotData.offsetY = 0;
                var spotWorldMatrix = spotLight.lightWorldMatrix;
                var viewMatrix = shadowSpotData.viewMatrix;
                var projectMatrix = shadowSpotData.projectionMatrix;
                var viewProjectMatrix = shadowSpotData.viewProjectMatrix;
                var BoundFrustum = shadowSpotData.cameraCullInfo.boundFrustum;
                spotWorldMatrix.invert(viewMatrix);
                Matrix4x4.createPerspective(3.1416 * spotLight.spotAngle / 180.0, 1, 0.1, spotLight.range, projectMatrix);
                shadowParams.y = spotLight.shadowStrength;
                Matrix4x4.multiply(projectMatrix, viewMatrix, viewProjectMatrix);
                BoundFrustum.matrix = viewProjectMatrix;
                viewProjectMatrix.cloneTo(shadowSpotMatrices);
                shadowSpotData.cameraCullInfo.position = out;
            }
        },
        {
            key: "prepareShadowReceiverShaderValues",
            value: function prepareShadowReceiverShaderValues(light, shadowMapWidth, shadowMapHeight, shadowSliceDatas, cascadeCount, shadowMapSize, shadowParams, shadowMatrices, splitBoundSpheres) {
                shadowMapSize.setValue(1.0 / shadowMapWidth, 1.0 / shadowMapHeight, shadowMapWidth, shadowMapHeight);
                shadowParams.setValue(light._shadowStrength, 0.0, 0.0, 0.0);
                if (cascadeCount > 1) {
                    var matrixFloatCount = 16;
                    for (var i = cascadeCount * matrixFloatCount,
                    n = 4 * matrixFloatCount; i < n; i++) {
                        shadowMatrices[i] = 0.0;
                    }
                    for (var i = 0; i < cascadeCount; i++) {
                        var boundSphere = shadowSliceDatas[i].splitBoundSphere;
                        var center = boundSphere.center;
                        var radius = boundSphere.radius;
                        var offset = i * 4;
                        splitBoundSpheres[offset] = center.x;
                        splitBoundSpheres[offset + 1] = center.y;
                        splitBoundSpheres[offset + 2] = center.z;
                        splitBoundSpheres[offset + 3] = radius * radius;
                    }
                    var sphereFloatCount = 4;
                    for (var i = cascadeCount * sphereFloatCount,
                    n = 4 * sphereFloatCount; i < n; i++) {
                        splitBoundSpheres[i] = 0.0;
                    }
                }
            }
        }]);
        return ShadowUtils;
    } ();
    ShadowUtils._tempMatrix0 = new Matrix4x4();
    ShadowUtils._shadowMapScaleOffsetMatrix = new Matrix4x4(0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5, 0.5, 0.0, 1.0);
    ShadowUtils._frustumCorners = [new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3()];
    ShadowUtils._adjustNearPlane = new Plane(new Vector3());
    ShadowUtils._adjustFarPlane = new Plane(new Vector3());
    ShadowUtils._backPlaneFaces = new Array(5);
    ShadowUtils._edgePlanePoint2 = new Vector3();
    ShadowUtils._frustumPlaneNeighbors = [[FrustumFace.Left, FrustumFace.Right, FrustumFace.Top, FrustumFace.Bottom], [FrustumFace.Left, FrustumFace.Right, FrustumFace.Top, FrustumFace.Bottom], [FrustumFace.Near, FrustumFace.Far, FrustumFace.Top, FrustumFace.Bottom], [FrustumFace.Near, FrustumFace.Far, FrustumFace.Top, FrustumFace.Bottom], [FrustumFace.Near, FrustumFace.Far, FrustumFace.Left, FrustumFace.Right], [FrustumFace.Near, FrustumFace.Far, FrustumFace.Left, FrustumFace.Right]];
    ShadowUtils._frustumTwoPlaneCorners = [[[exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.nearBottomLeft, exports.FrustumCorner.nearTopLeft], [exports.FrustumCorner.nearTopRight, exports.FrustumCorner.nearBottomRight], [exports.FrustumCorner.nearBottomRight, exports.FrustumCorner.nearBottomLeft], [exports.FrustumCorner.nearTopLeft, exports.FrustumCorner.nearTopRight]], [[exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.FarTopLeft, exports.FrustumCorner.FarBottomLeft], [exports.FrustumCorner.FarBottomRight, exports.FrustumCorner.FarTopRight], [exports.FrustumCorner.FarBottomLeft, exports.FrustumCorner.FarBottomRight], [exports.FrustumCorner.FarTopRight, exports.FrustumCorner.FarTopLeft]], [[exports.FrustumCorner.nearTopLeft, exports.FrustumCorner.nearBottomLeft], [exports.FrustumCorner.FarBottomLeft, exports.FrustumCorner.FarTopLeft], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.nearBottomLeft, exports.FrustumCorner.FarBottomLeft], [exports.FrustumCorner.FarTopLeft, exports.FrustumCorner.nearTopLeft]], [[exports.FrustumCorner.nearBottomRight, exports.FrustumCorner.nearTopRight], [exports.FrustumCorner.FarTopRight, exports.FrustumCorner.FarBottomRight], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.FarBottomRight, exports.FrustumCorner.nearBottomRight], [exports.FrustumCorner.nearTopRight, exports.FrustumCorner.FarTopRight]], [[exports.FrustumCorner.nearBottomLeft, exports.FrustumCorner.nearBottomRight], [exports.FrustumCorner.FarBottomRight, exports.FrustumCorner.FarBottomLeft], [exports.FrustumCorner.FarBottomLeft, exports.FrustumCorner.nearBottomLeft], [exports.FrustumCorner.nearBottomRight, exports.FrustumCorner.FarBottomRight], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown]], [[exports.FrustumCorner.nearTopRight, exports.FrustumCorner.nearTopLeft], [exports.FrustumCorner.FarTopLeft, exports.FrustumCorner.FarTopRight], [exports.FrustumCorner.nearTopLeft, exports.FrustumCorner.FarTopLeft], [exports.FrustumCorner.FarTopRight, exports.FrustumCorner.nearTopRight], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown], [exports.FrustumCorner.unknown, exports.FrustumCorner.unknown]]];
    ShadowUtils.atlasBorderSize = 4.0; (function(DepthTextureMode) {
        DepthTextureMode[DepthTextureMode["None"] = 0] = "None";
        DepthTextureMode[DepthTextureMode["Depth"] = 1] = "Depth";
        DepthTextureMode[DepthTextureMode["DepthNormals"] = 2] = "DepthNormals";
        DepthTextureMode[DepthTextureMode["MotionVectors"] = 4] = "MotionVectors";
    })(exports.DepthTextureMode || (exports.DepthTextureMode = {}));
    var DepthPass =
    /*#__PURE__*/
    function() {
        function DepthPass() {
            _classCallCheck(this, DepthPass);
            this._zBufferParams = new Vector4();
        }
        _createClass(DepthPass, [{
            key: "update",
            value: function update(camera, depthType, depthTextureFormat) {
                this._viewPort = camera.viewport;
                this._camera = camera;
                switch (depthType) {
                case exports.DepthTextureMode.Depth:
                    camera.depthTexture = this._depthTexture = RenderTexture.createFromPool(this._viewPort.width, this._viewPort.height, Laya.RenderTextureFormat.Depth, depthTextureFormat);
                    break;
                case exports.DepthTextureMode.DepthNormals:
                    camera.depthNormalTexture = this._depthNormalsTexture = RenderTexture.createFromPool(this._viewPort.width, this._viewPort.height, Laya.RenderTextureFormat.R8G8B8A8, depthTextureFormat);
                    break;
                case exports.DepthTextureMode.MotionVectors:
                    break;
                default:
                    throw "there is UnDefined type of DepthTextureMode";
                }
            }
        },
        {
            key: "render",
            value: function render(context, depthType) {
                var scene = context.scene;
                switch (depthType) {
                case exports.DepthTextureMode.Depth:
                    var shaderValues = scene._shaderValues;
                    context.pipelineMode = "ShadowCaster";
                    shaderValues.addDefine(DepthPass.DEPTHPASS);
                    ShaderData.setRuntimeValueMode(false);
                    this._depthTexture._start();
                    shaderValues.setVector(DepthPass.DEFINE_SHADOW_BIAS, DepthPass.SHADOW_BIAS);
                    var gl = Laya.LayaGL.instance;
                    var offsetX = this._viewPort.x;
                    var offsetY = this._viewPort.y;
                    gl.enable(gl.SCISSOR_TEST);
                    gl.viewport(offsetX, offsetY, this._viewPort.width, this._viewPort.height);
                    gl.scissor(offsetX, offsetY, this._viewPort.width, this._viewPort.height);
                    gl.clear(gl.DEPTH_BUFFER_BIT);
                    scene._opaqueQueue._render(context);
                    this._depthTexture._end();
                    ShaderData.setRuntimeValueMode(true);
                    this._setupDepthModeShaderValue(depthType, this._camera);
                    context.pipelineMode = context.configPipeLineMode;
                    shaderValues.removeDefine(DepthPass.DEPTHPASS);
                    break;
                case exports.DepthTextureMode.DepthNormals:
                    var shaderValues = scene._shaderValues;
                    context.pipelineMode = "DepthNormal";
                    ShaderData.setRuntimeValueMode(false);
                    this._depthNormalsTexture._start();
                    var gl = Laya.LayaGL.instance;
                    var offsetX = this._viewPort.x;
                    var offsetY = this._viewPort.y;
                    gl.enable(gl.SCISSOR_TEST);
                    gl.viewport(offsetX, offsetY, this._viewPort.width, this._viewPort.height);
                    gl.scissor(offsetX, offsetY, this._viewPort.width, this._viewPort.height);
                    gl.clearColor(0.5, 0.5, 1.0, 0.0);
                    gl.clear(gl.DEPTH_BUFFER_BIT | gl.COLOR_BUFFER_BIT);
                    scene._opaqueQueue._render(context);
                    this._depthNormalsTexture._end();
                    ShaderData.setRuntimeValueMode(true);
                    this._setupDepthModeShaderValue(depthType, this._camera);
                    context.pipelineMode = context.configPipeLineMode;
                    break;
                case exports.DepthTextureMode.MotionVectors:
                    break;
                default:
                    throw "there is UnDefined type of DepthTextureMode";
                }
            }
        },
        {
            key: "_setupDepthModeShaderValue",
            value: function _setupDepthModeShaderValue(depthType, camera) {
                switch (depthType) {
                case exports.DepthTextureMode.Depth:
                    var far = camera.farPlane;
                    var near = camera.nearPlane;
                    this._zBufferParams.setValue(1.0 - far / near, far / near, (near - far) / (near * far), 1 / near);
                    camera._shaderValues.setVector(DepthPass.DEFINE_SHADOW_BIAS, DepthPass.SHADOW_BIAS);
                    camera._shaderValues.setTexture(DepthPass.DEPTHTEXTURE, this._depthTexture);
                    camera._shaderValues.setVector(DepthPass.DEPTHZBUFFERPARAMS, this._zBufferParams);
                    break;
                case exports.DepthTextureMode.DepthNormals:
                    camera._shaderValues.setTexture(DepthPass.DEPTHNORMALSTEXTURE, this._depthNormalsTexture);
                    break;
                case exports.DepthTextureMode.MotionVectors:
                    break;
                default:
                    throw "there is UnDefined type of DepthTextureMode";
                }
            }
        },
        {
            key: "cleanUp",
            value: function cleanUp() {
                this._depthTexture && RenderTexture.recoverToPool(this._depthTexture);
                this._depthNormalsTexture && RenderTexture.recoverToPool(this._depthNormalsTexture);
                this._depthTexture = null;
                this._depthNormalsTexture = null;
            }
        }]);
        return DepthPass;
    } ();
    DepthPass.SHADOW_BIAS = new Vector4();
    DepthPass.DEPTHPASS = Shader3D.getDefineByName("DEPTHPASS");
    DepthPass.DEFINE_SHADOW_BIAS = Shader3D.propertyNameToID("u_ShadowBias");
    DepthPass.DEPTHTEXTURE = Shader3D.propertyNameToID("u_CameraDepthTexture");
    DepthPass.DEPTHNORMALSTEXTURE = Shader3D.propertyNameToID("u_CameraDepthNormalsTexture");
    DepthPass.DEPTHZBUFFERPARAMS = Shader3D.propertyNameToID("u_ZBufferParams");
    var MulSampleRenderTexture =
    /*#__PURE__*/
    function(_RenderTexture) {
        _inherits(MulSampleRenderTexture, _RenderTexture);
        var _super36 = _createSuper(MulSampleRenderTexture);
        function MulSampleRenderTexture(width, height) {
            var _this33;
            var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Laya.RenderTextureFormat.R8G8B8;
            var depthStencilFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Laya.RenderTextureDepthFormat.DEPTH_16;
            var mulSampler = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
            var mipmap = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
            _classCallCheck(this, MulSampleRenderTexture);
            _this33 = _super36.call(this, width, height, format, depthStencilFormat, mipmap);
            _this33._mulSampler = 1;
            _this33._mulSamplerRT = true;
            _this33._mulSampler = mulSampler;
            return _this33;
        }
        _createClass(MulSampleRenderTexture, [{
            key: "_create",
            value: function _create(width, height) {
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                var glTextureType = this._glTextureType;
                var layaGPU = Laya.LayaGL.layaGPUInstance;
                var isWebGL2 = layaGPU._isWebGL2;
                var format = this._format;
                this._mulSampler = 4;
                this._frameBuffer = gl.createFramebuffer();
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                this._mulRenderBuffer = gl2.createRenderbuffer();
                gl2.bindRenderbuffer(gl2.RENDERBUFFER, this._mulRenderBuffer);
                switch (format) {
                case Laya.RenderTextureFormat.R8G8B8:
                    gl2.renderbufferStorageMultisample(gl2.RENDERBUFFER, this._mulSampler, gl2.RGB8, width, height);
                    break;
                case Laya.RenderTextureFormat.R8G8B8A8:
                    gl2.renderbufferStorageMultisample(gl2.RENDERBUFFER, this._mulSampler, gl2.RGBA8, width, height);
                    break;
                case Laya.RenderTextureFormat.Alpha8:
                    gl2.renderbufferStorageMultisample(gl2.RENDERBUFFER, this._mulSampler, gl2.ALPHA, width, height);
                    break;
                case Laya.RenderTextureFormat.R16G16B16A16:
                    gl2.renderbufferStorageMultisample(gl2.RENDERBUFFER, this._mulSampler, gl2.RGBA16F, width, height);
                    break;
                }
                gl2.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.RENDERBUFFER, this._mulRenderBuffer);
                this._creatGlTexture(width, height);
                if (format !== Laya.RenderTextureFormat.Depth && format !== Laya.RenderTextureFormat.ShadowMap) {
                    this._mulFrameBuffer = gl2.createFramebuffer();
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._mulFrameBuffer);
                    gl.framebufferTexture2D(gl2.FRAMEBUFFER, gl2.COLOR_ATTACHMENT0, gl2.TEXTURE_2D, this._glTexture, 0);
                }
                this._createGLDepthRenderbuffer(width, height);
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                this._setFilterMode(this._filterMode);
                this._setAnisotropy(this._anisoLevel);
                this._readyed = true;
                this._activeResource();
                var gpuMemory = width * height * 4;
                if (this._mipmap) {
                    gpuMemory *= 4 / 3;
                }
                this._setGPUMemory(gpuMemory);
            }
        },
        {
            key: "_createGLDepthRenderbuffer",
            value: function _createGLDepthRenderbuffer(width, height) {
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                if (this._depthStencilFormat !== Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE) {
                    this._depthStencilBuffer = gl.createRenderbuffer();
                    gl.bindRenderbuffer(gl.RENDERBUFFER, this._depthStencilBuffer);
                    switch (this._depthStencilFormat) {
                    case Laya.RenderTextureDepthFormat.DEPTH_16:
                        gl2.renderbufferStorageMultisample(gl.RENDERBUFFER, this._mulSampler, gl2.DEPTH_COMPONENT16, width, height);
                        gl2.framebufferRenderbuffer(gl.FRAMEBUFFER, gl2.DEPTH_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    case Laya.RenderTextureDepthFormat.STENCIL_8:
                        gl2.renderbufferStorageMultisample(gl.RENDERBUFFER, this._mulSampler, gl2.STENCIL_INDEX8, width, height);
                        gl2.framebufferRenderbuffer(gl.FRAMEBUFFER, gl2.STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                        gl2.renderbufferStorageMultisample(gl.RENDERBUFFER, this._mulSampler, gl2.DEPTH24_STENCIL8, width, height);
                        gl2.framebufferRenderbuffer(gl.FRAMEBUFFER, gl2.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                        break;
                    default:
                        throw "RenderTexture: unkonw depth format.";
                    }
                }
            }
        },
        {
            key: "protected",
            value: function _protected(width, height) {
                var glTextureType = this._glTextureType;
                var layaGPU = Laya.LayaGL.layaGPUInstance;
                var isWebGL2 = layaGPU._isWebGL2;
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                if (this._depthStencilFormat !== Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE) {
                    this._depthStencilTexture = new Laya.BaseTexture(Laya.RenderTextureFormat.Depth, false);
                    this._depthStencilTexture.lock = true;
                    this._depthStencilTexture.width = width;
                    this._depthStencilTexture.height = height;
                    this._depthStencilTexture.mipmapCount = 1;
                    this._depthStencilTexture._glTextureType = Laya.LayaGL.instance.TEXTURE_2D;
                    this._depthStencilTexture._readyed = true;
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._mulFrameBuffer);
                    this._depthStencilTexture.filterMode = Laya.FilterMode.Point;
                    this._depthStencilTexture.wrapModeU = Laya.WarpMode.Clamp;
                    this._depthStencilTexture.wrapModeV = Laya.WarpMode.Clamp;
                    Laya.WebGLContext.bindTexture(gl, this._depthStencilTexture._glTextureType, this._depthStencilTexture._getSource());
                    switch (this._depthStencilFormat) {
                    case Laya.RenderTextureDepthFormat.DEPTH_16:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT16, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_SHORT, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH24_STENCIL8, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_STENCIL, width, height, 0, gl.DEPTH_STENCIL, layaGPU._webgl_depth_texture.UNSIGNED_INT_24_8_WEBGL, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    case Laya.RenderTextureDepthFormat.DEPTH_32:
                        if (isWebGL2) {
                            gl2.texStorage2D(glTextureType, this._mipmapCount, gl2.DEPTH_COMPONENT32F, width, height);
                        } else {
                            gl.texImage2D(glTextureType, 0, gl.DEPTH_COMPONENT, width, height, 0, gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, null);
                        }
                        gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.TEXTURE_2D, this._depthStencilTexture._getSource(), 0);
                        break;
                    }
                }
            }
        },
        {
            key: "_end",
            value: function _end() {
                var gl = Laya.LayaGL.instance;
                var gl2 = gl;
                gl2.bindFramebuffer(gl2.READ_FRAMEBUFFER, this._frameBuffer);
                gl2.bindFramebuffer(gl2.DRAW_FRAMEBUFFER, this._mulFrameBuffer);
                gl2.clearBufferfv(gl2.COLOR, 0, [0.0, 0.0, 0.0, 0.0]);
                gl2.blitFramebuffer(0, 0, this.width, this.height, 0, 0, this._width, this._height, gl2.COLOR_BUFFER_BIT, gl.NEAREST);
                if (this._depthAttachMode == Laya.RTDEPTHATTACHMODE.TEXTURE) {
                    gl2.bindFramebuffer(gl2.READ_FRAMEBUFFER, this._frameBuffer);
                    gl2.bindFramebuffer(gl2.DRAW_FRAMEBUFFER, this._mulFrameBuffer);
                    gl2.clearBufferfi(gl.DEPTH_STENCIL, 0, 1.0, 0);
                    gl2.blitFramebuffer(0, 0, this.width, this.height, 0, 0, this._width, this._height, gl2.DEPTH_BUFFER_BIT, gl.NEAREST);
                }
                if (this.mipmap) {
                    Laya.WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    gl.generateMipmap(this._glTextureType);
                    Laya.WebGLContext.bindTexture(gl, this._glTextureType, null);
                }
                gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                RenderTexture._currentActive = null;
                this._isCameraTarget && (RenderContext3D._instance.invertY = false);
                this._readyed = true;
            }
        },
        {
            key: "_disposeResource",
            value: function _disposeResource() {
                _get(_getPrototypeOf(MulSampleRenderTexture.prototype), "_disposeResource", this).call(this);
                var gl = Laya.LayaGL.instance;
                this._mulRenderBuffer && gl.deleteRenderbuffer(this._mulRenderBuffer);
                this._mulFrameBuffer && gl.deleteFramebuffer(this._mulFrameBuffer);
                this._mulRenderBuffer = null;
                this._mulFrameBuffer = null;
            }
        }], [{
            key: "createFromPool",
            value: function createFromPool(width, height) {
                var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Laya.RenderTextureFormat.R8G8B8;
                var depthStencilFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Laya.RenderTextureDepthFormat.DEPTH_16;
                var mulSamples = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 4;
                var mipmap = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                var tex;
                if (!Laya.LayaGL.layaGPUInstance._isWebGL2 || mulSamples == 1) {
                    throw "dont support msaa RT";
                }
                mipmap = mipmap && (width & width - 1) === 0 && (height & height - 1) === 0;
                for (var i = 0,
                n = RenderTexture._pool.length; i < n; i++) {
                    tex = RenderTexture._pool[i];
                    if (tex instanceof MulSampleRenderTexture && tex.width == width && tex.height == height && tex.format == format && tex.depthStencilFormat == depthStencilFormat && tex.mulSampler == mulSamples && tex.mipmap == mipmap) {
                        tex._inPool = false;
                        var end = RenderTexture._pool[n - 1];
                        RenderTexture._pool[i] = end;
                        RenderTexture._pool.length -= 1;
                        return tex;
                    }
                }
                tex = new MulSampleRenderTexture(width, height, format, depthStencilFormat, mulSamples, mipmap);
                tex.lock = true;
                return tex;
            }
        }]);
        return MulSampleRenderTexture;
    } (RenderTexture); (function(CameraClearFlags) {
        CameraClearFlags[CameraClearFlags["SolidColor"] = 0] = "SolidColor";
        CameraClearFlags[CameraClearFlags["Sky"] = 1] = "Sky";
        CameraClearFlags[CameraClearFlags["DepthOnly"] = 2] = "DepthOnly";
        CameraClearFlags[CameraClearFlags["Nothing"] = 3] = "Nothing";
    })(exports.CameraClearFlags || (exports.CameraClearFlags = {})); (function(CameraEventFlags) {
        CameraEventFlags[CameraEventFlags["BeforeForwardOpaque"] = 0] = "BeforeForwardOpaque";
        CameraEventFlags[CameraEventFlags["BeforeSkyBox"] = 2] = "BeforeSkyBox";
        CameraEventFlags[CameraEventFlags["BeforeTransparent"] = 4] = "BeforeTransparent";
        CameraEventFlags[CameraEventFlags["BeforeImageEffect"] = 6] = "BeforeImageEffect";
        CameraEventFlags[CameraEventFlags["AfterEveryThing"] = 8] = "AfterEveryThing";
    })(exports.CameraEventFlags || (exports.CameraEventFlags = {}));
    var Camera =
    /*#__PURE__*/
    function(_BaseCamera) {
        _inherits(Camera, _BaseCamera);
        var _super37 = _createSuper(Camera);
        function Camera() {
            var _this34;
            var aspectRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
            var nearPlane = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.3;
            var farPlane = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1000;
            _classCallCheck(this, Camera);
            _this34 = _super37.call(this, nearPlane, farPlane);
            _this34._updateViewMatrix = true;
            _this34._postProcess = null;
            _this34._enableHDR = false;
            _this34._viewportParams = new Vector4();
            _this34._projectionParams = new Vector4();
            _this34._needBuiltInRenderTexture = false;
            _this34._msaa = false;
            _this34._offScreenRenderTexture = null;
            _this34._internalRenderTexture = null;
            _this34._canBlitDepth = false;
            _this34._internalCommandBuffer = new CommandBuffer();
            _this34._depthTextureFormat = Laya.RenderTextureDepthFormat.DEPTH_16;
            _this34._cameraEventCommandBuffer = {};
            _this34._clusterPlaneCacheFlag = new Vector2( - 1, -1);
            _this34._screenOffsetScale = new Vector4();
            _this34.enableRender = true;
            _this34.clearFlag = exports.CameraClearFlags.SolidColor;
            _this34._viewMatrix = new Matrix4x4();
            _this34._projectionMatrix = new Matrix4x4();
            _this34._projectionViewMatrix = new Matrix4x4();
            _this34._viewport = new Viewport(0, 0, 0, 0);
            _this34._normalizedViewport = new Viewport(0, 0, 1, 1);
            _this34._rayViewport = new Viewport(0, 0, 0, 0);
            _this34._aspectRatio = aspectRatio;
            _this34._boundFrustum = new BoundFrustum(new Matrix4x4());
            _this34._calculateProjectionMatrix();
            Laya.Laya.stage.on(Laya.Event.RESIZE, _assertThisInitialized(_this34), _this34._onScreenSizeChanged);
            _this34.transform.on(Laya.Event.TRANSFORM_CHANGED, _assertThisInitialized(_this34), _this34._onTransformChanged);
            return _this34;
        }
        _createClass(Camera, [{
            key: "aspectRatio",
            get: function get() {
                if (this._aspectRatio === 0) {
                    var vp = this.viewport;
                    return vp.width / vp.height;
                }
                return this._aspectRatio;
            },
            set: function set(value) {
                if (value < 0) throw new Error("Camera: the aspect ratio has to be a positive real number.");
                this._aspectRatio = value;
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "viewport",
            get: function get() {
                if (this._offScreenRenderTexture) this._calculationViewport(this._normalizedViewport, this._offScreenRenderTexture.width, this._offScreenRenderTexture.height);
                else this._calculationViewport(this._normalizedViewport, this.clientWidth, this.clientHeight);
                return this._viewport;
            },
            set: function set(value) {
                var width;
                var height;
                if (this._offScreenRenderTexture) {
                    width = this._offScreenRenderTexture.width;
                    height = this._offScreenRenderTexture.height;
                } else {
                    width = this.clientWidth;
                    height = this.clientHeight;
                }
                this._normalizedViewport.x = value.x / width;
                this._normalizedViewport.y = value.y / height;
                this._normalizedViewport.width = value.width / width;
                this._normalizedViewport.height = value.height / height;
                this._calculationViewport(this._normalizedViewport, width, height);
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "clientWidth",
            get: function get() {
                if (Config3D._config.customPixel) return Config3D._config.pixResolWidth | 0;
                else return RenderContext3D.clientWidth * Config3D._config.pixelRatio | 0;
            }
        },
        {
            key: "clientHeight",
            get: function get() {
                if (Config3D._config.customPixel) return Config3D._config.pixResolHeight | 0;
                else return RenderContext3D.clientHeight * Config3D._config.pixelRatio | 0;
            }
        },
        {
            key: "msaa",
            get: function get() {
                return this._msaa;
            },
            set: function set(value) {
                Laya.LayaGL.layaGPUInstance._isWebGL2 ? this._msaa = value: this._msaa = false;
            }
        },
        {
            key: "normalizedViewport",
            get: function get() {
                return this._normalizedViewport;
            },
            set: function set(value) {
                var width;
                var height;
                if (this._offScreenRenderTexture) {
                    width = this._offScreenRenderTexture.width;
                    height = this._offScreenRenderTexture.height;
                } else {
                    width = this.clientWidth;
                    height = this.clientHeight;
                }
                if (this._normalizedViewport !== value) value.cloneTo(this._normalizedViewport);
                this._calculationViewport(value, width, height);
                this._calculateProjectionMatrix();
            }
        },
        {
            key: "viewMatrix",
            get: function get() {
                if (this._updateViewMatrix) {
                    var scale = this.transform.getWorldLossyScale();
                    var scaleX = scale.x;
                    var scaleY = scale.y;
                    var scaleZ = scale.z;
                    var viewMatE = this._viewMatrix.elements;
                    this.transform.worldMatrix.cloneTo(this._viewMatrix);
                    viewMatE[0] /= scaleX;
                    viewMatE[1] /= scaleX;
                    viewMatE[2] /= scaleX;
                    viewMatE[4] /= scaleY;
                    viewMatE[5] /= scaleY;
                    viewMatE[6] /= scaleY;
                    viewMatE[8] /= scaleZ;
                    viewMatE[9] /= scaleZ;
                    viewMatE[10] /= scaleZ;
                    this._viewMatrix.invert(this._viewMatrix);
                    this._updateViewMatrix = false;
                }
                return this._viewMatrix;
            }
        },
        {
            key: "projectionMatrix",
            get: function get() {
                return this._projectionMatrix;
            },
            set: function set(value) {
                this._projectionMatrix = value;
                this._useUserProjectionMatrix = true;
            }
        },
        {
            key: "projectionViewMatrix",
            get: function get() {
                Matrix4x4.multiply(this.projectionMatrix, this.viewMatrix, this._projectionViewMatrix);
                return this._projectionViewMatrix;
            }
        },
        {
            key: "boundFrustum",
            get: function get() {
                this._boundFrustum.matrix = this.projectionViewMatrix;
                return this._boundFrustum;
            }
        },
        {
            key: "renderTarget",
            get: function get() {
                return this._offScreenRenderTexture;
            },
            set: function set(value) {
                var lastValue = this._offScreenRenderTexture;
                if (lastValue !== value) {
                    lastValue && (lastValue._isCameraTarget = false);
                    value && (value._isCameraTarget = true);
                    this._offScreenRenderTexture = value;
                    this._calculateProjectionMatrix();
                }
            }
        },
        {
            key: "postProcess",
            get: function get() {
                return this._postProcess;
            },
            set: function set(value) {
                this._postProcess = value;
                if (!value) return;
                value && value._init(this);
            }
        },
        {
            key: "enableHDR",
            get: function get() {
                return this._enableHDR;
            },
            set: function set(value) {
                if (value && !Laya.SystemUtils.supportRenderTextureFormat(Laya.RenderTextureFormat.R16G16B16A16)) {
                    console.warn("Camera:can't enable HDR in this device.");
                    return;
                }
                this._enableHDR = value;
            }
        },
        {
            key: "enableBuiltInRenderTexture",
            get: function get() {
                return this._needBuiltInRenderTexture;
            },
            set: function set(value) {
                this._needBuiltInRenderTexture = value;
            }
        },
        {
            key: "depthTextureMode",
            get: function get() {
                return this._depthTextureMode;
            },
            set: function set(value) {
                this._depthTextureMode = value;
            }
        },
        {
            key: "opaquePass",
            get: function get() {
                return this._opaquePass;
            },
            set: function set(value) {
                if (value == this._opaquePass) return;
                if (!value) {
                    this._shaderValues.setTexture(BaseCamera.OPAQUETEXTURE, null);
                    this._opaqueTexture = null;
                }
                this._opaquePass = value;
            }
        },
        {
            key: "depthTextureFormat",
            get: function get() {
                return this._depthTextureFormat;
            },
            set: function set(value) {
                this._depthTextureFormat = value;
            }
        },
        {
            key: "enableBlitDepth",
            set: function set(value) {
                this._canBlitDepth = value;
                if (value) this._internalRenderTexture && (this._internalRenderTexture.depthAttachMode = Laya.RTDEPTHATTACHMODE.TEXTURE);
                else this._internalRenderTexture && (this._internalRenderTexture.depthAttachMode = Laya.RTDEPTHATTACHMODE.RENDERBUFFER);
            }
        },
        {
            key: "canblitDepth",
            get: function get() {
                return this._canBlitDepth && this._internalRenderTexture && this._internalRenderTexture.depthStencilFormat != Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE && this._internalRenderTexture.depthAttachMode == Laya.RTDEPTHATTACHMODE.TEXTURE;
            }
        },
        {
            key: "depthTexture",
            get: function get() {
                return this._depthTexture;
            },
            set: function set(value) {
                this._depthTexture = value;
            }
        },
        {
            key: "depthNormalTexture",
            get: function get() {
                return this._depthNormalsTexture;
            },
            set: function set(value) {
                this._depthNormalsTexture = value;
            }
        },
        {
            key: "_calculationViewport",
            value: function _calculationViewport(normalizedViewport, width, height) {
                var lx = normalizedViewport.x * width;
                var ly = normalizedViewport.y * height;
                var rx = lx + Math.max(normalizedViewport.width * width, 0);
                var ry = ly + Math.max(normalizedViewport.height * height, 0);
                var ceilLeftX = Math.ceil(lx);
                var ceilLeftY = Math.ceil(ly);
                var floorRightX = Math.floor(rx);
                var floorRightY = Math.floor(ry);
                var pixelLeftX = ceilLeftX - lx >= 0.5 ? Math.floor(lx) : ceilLeftX;
                var pixelLeftY = ceilLeftY - ly >= 0.5 ? Math.floor(ly) : ceilLeftY;
                var pixelRightX = rx - floorRightX >= 0.5 ? Math.ceil(rx) : floorRightX;
                var pixelRightY = ry - floorRightY >= 0.5 ? Math.ceil(ry) : floorRightY;
                this._viewport.x = pixelLeftX;
                this._viewport.y = pixelLeftY;
                this._viewport.width = pixelRightX - pixelLeftX;
                this._viewport.height = pixelRightY - pixelLeftY;
            }
        },
        {
            key: "_calculateProjectionMatrix",
            value: function _calculateProjectionMatrix() {
                if (!this._useUserProjectionMatrix) {
                    if (this._orthographic) {
                        var halfHeight = this.orthographicVerticalSize * 0.5;
                        var halfWidth = halfHeight * this.aspectRatio;
                        Matrix4x4.createOrthoOffCenter( - halfWidth, halfWidth, -halfHeight, halfHeight, this.nearPlane, this.farPlane, this._projectionMatrix);
                    } else {
                        Matrix4x4.createPerspective(3.1416 * this.fieldOfView / 180.0, this.aspectRatio, this.nearPlane, this.farPlane, this._projectionMatrix);
                    }
                }
            }
        },
        {
            key: "_isLayerVisible",
            value: function _isLayerVisible(layer) {
                return (Math.pow(2, layer) & this.cullingMask) != 0;
            }
        },
        {
            key: "_onTransformChanged",
            value: function _onTransformChanged(flag) {
                flag &= Transform3D.TRANSFORM_WORLDMATRIX;
                flag && (this._updateViewMatrix = true);
            }
        },
        {
            key: "_parse",
            value: function _parse(data, spriteMap) {
                _get(_getPrototypeOf(Camera.prototype), "_parse", this).call(this, data, spriteMap);
                var clearFlagData = data.clearFlag;
                clearFlagData !== undefined && (this.clearFlag = clearFlagData);
                var viewport = data.viewport;
                this.normalizedViewport = new Viewport(viewport[0], viewport[1], viewport[2], viewport[3]);
                var enableHDR = data.enableHDR;
                enableHDR !== undefined && (this.enableHDR = enableHDR);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var camera = _get(_getPrototypeOf(Camera.prototype), "clone", this).call(this);
                camera.clearFlag = this.clearFlag;
                camera.viewport = this.viewport;
                this.normalizedViewport.cloneTo(camera.normalizedViewport);
                camera.enableHDR = this.enableHDR;
                camera.farPlane = this.farPlane;
                camera.nearPlane = this.nearPlane;
                camera.fieldOfView = this.fieldOfView;
                camera.orthographic = this.orthographic;
                return camera;
            }
        },
        {
            key: "_getCanvasWidth",
            value: function _getCanvasWidth() {
                if (this._offScreenRenderTexture) return this._offScreenRenderTexture.width;
                else return this.clientWidth;
            }
        },
        {
            key: "_getCanvasHeight",
            value: function _getCanvasHeight() {
                if (this._offScreenRenderTexture) return this._offScreenRenderTexture.height;
                else return this.clientHeight;
            }
        },
        {
            key: "_getRenderTexture",
            value: function _getRenderTexture() {
                return this._internalRenderTexture || this._offScreenRenderTexture;
            }
        },
        {
            key: "_needInternalRenderTexture",
            value: function _needInternalRenderTexture() {
                return this._postProcess && this._postProcess.enable || this._enableHDR || this._needBuiltInRenderTexture ? true: false;
            }
        },
        {
            key: "_getRenderTextureFormat",
            value: function _getRenderTextureFormat() {
                if (this._enableHDR) return Laya.RenderTextureFormat.R16G16B16A16;
                else return Laya.RenderTextureFormat.R8G8B8;
            }
        },
        {
            key: "_prepareCameraToRender",
            value: function _prepareCameraToRender() {
                _get(_getPrototypeOf(Camera.prototype), "_prepareCameraToRender", this).call(this);
                var vp = this.viewport;
                this._viewportParams.setValue(vp.x, vp.y, vp.width, vp.height);
                this._projectionParams.setValue(this._nearPlane, this._farPlane, RenderContext3D._instance.invertY ? -1 : 1, 1 / this.farPlane);
                this._shaderValues.setVector(BaseCamera.VIEWPORT, this._viewportParams);
                this._shaderValues.setVector(BaseCamera.PROJECTION_PARAMS, this._projectionParams);
            }
        },
        {
            key: "_applyViewProject",
            value: function _applyViewProject(context, viewMat, proMat) {
                var projectView;
                var shaderData = this._shaderValues;
                if (context.invertY) {
                    Matrix4x4.multiply(BaseCamera._invertYScaleMatrix, proMat, BaseCamera._invertYProjectionMatrix);
                    Matrix4x4.multiply(BaseCamera._invertYProjectionMatrix, viewMat, BaseCamera._invertYProjectionViewMatrix);
                    proMat = BaseCamera._invertYProjectionMatrix;
                    projectView = BaseCamera._invertYProjectionViewMatrix;
                } else {
                    Matrix4x4.multiply(proMat, viewMat, this._projectionViewMatrix);
                    projectView = this._projectionViewMatrix;
                }
                context.viewMatrix = viewMat;
                context.projectionMatrix = proMat;
                context.projectionViewMatrix = projectView;
                shaderData.setMatrix4x4(BaseCamera.VIEWMATRIX, viewMat);
                shaderData.setMatrix4x4(BaseCamera.PROJECTMATRIX, proMat);
                shaderData.setMatrix4x4(BaseCamera.VIEWPROJECTMATRIX, projectView);
            }
        },
        {
            key: "_updateClusterPlaneXY",
            value: function _updateClusterPlaneXY() {
                var fieldOfView = this.fieldOfView;
                var aspectRatio = this.aspectRatio;
                if (this._clusterPlaneCacheFlag.x !== fieldOfView || this._clusterPlaneCacheFlag.y !== aspectRatio) {
                    var clusterCount = Config3D._config.lightClusterCount;
                    var xSlixe = clusterCount.x,
                    ySlice = clusterCount.y;
                    var xCount = xSlixe + 1,
                    yCount = ySlice + 1;
                    var xPlanes = this._clusterXPlanes,
                    yPlanes = this._clusterYPlanes;
                    if (!xPlanes) {
                        xPlanes = this._clusterXPlanes = new Array(xCount);
                        yPlanes = this._clusterYPlanes = new Array(yCount);
                        for (var i = 0; i < xCount; i++) {
                            xPlanes[i] = new Vector3();
                        }
                        for (var i = 0; i < yCount; i++) {
                            yPlanes[i] = new Vector3();
                        }
                    }
                    var halfY = Math.tan(this.fieldOfView / 2 * Math.PI / 180);
                    var halfX = this.aspectRatio * halfY;
                    var yLengthPerCluster = 2 * halfY / ySlice;
                    var xLengthPerCluster = 2 * halfX / xSlixe;
                    for (var i = 0; i < xCount; i++) {
                        var angle = -halfX + xLengthPerCluster * i;
                        var bigHypot = Math.sqrt(1 + angle * angle);
                        var normX = 1 / bigHypot;
                        var xPlane = xPlanes[i];
                        xPlane.setValue(normX, 0, -angle * normX);
                    }
                    for (var i = 0; i < yCount; i++) {
                        var angle = halfY - yLengthPerCluster * i;
                        var bigHypot = Math.sqrt(1 + angle * angle);
                        var normY = -1 / bigHypot;
                        var yPlane = yPlanes[i];
                        yPlane.setValue(0, normY, -angle * normY);
                    }
                    this._clusterPlaneCacheFlag.x = fieldOfView;
                    this._clusterPlaneCacheFlag.y = aspectRatio;
                }
            }
        },
        {
            key: "_applyCommandBuffer",
            value: function _applyCommandBuffer(event, context) {
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERCOMMANDBUFFER);
                var gl = Laya.LayaGL.instance;
                var commandBufferArray = this._cameraEventCommandBuffer[event];
                if (!commandBufferArray || commandBufferArray.length == 0) return;
                commandBufferArray.forEach(function(value) {
                    value._context = context;
                    value._apply();
                });
                RenderTexture.currentActive && RenderTexture.currentActive._end();
                if (this._internalRenderTexture || this._offScreenRenderTexture) this._getRenderTexture()._start();
                else {
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                }
                gl.viewport(0, 0, context.viewport.width, context.viewport.height);
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERCOMMANDBUFFER);
            }
        },
        {
            key: "_renderShadowMap",
            value: function _renderShadowMap(scene, context) {
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_SHADOWMAP);
                var shadowCasterPass;
                var mainDirectLight = scene._mainDirectionLight;
                var needShadowCasterPass = mainDirectLight && mainDirectLight.shadowMode !== exports.ShadowMode.None && ShadowUtils.supportShadow();
                if (needShadowCasterPass) {
                    scene._shaderValues.removeDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW_SPOT);
                    scene._shaderValues.addDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW);
                    shadowCasterPass = ILaya3D.Scene3D._shadowCasterPass;
                    shadowCasterPass.update(this, mainDirectLight, ILaya3D.ShadowLightType.DirectionLight);
                    shadowCasterPass.render(context, scene, ILaya3D.ShadowLightType.DirectionLight);
                } else {
                    scene._shaderValues.removeDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW);
                }
                var spotMainLight = scene._mainSpotLight;
                var spotneedShadowCasterPass = spotMainLight && spotMainLight.shadowMode !== exports.ShadowMode.None && ShadowUtils.supportShadow();
                if (spotneedShadowCasterPass) {
                    scene._shaderValues.removeDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW);
                    scene._shaderValues.addDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW_SPOT);
                    shadowCasterPass = ILaya3D.Scene3D._shadowCasterPass;
                    shadowCasterPass.update(this, spotMainLight, ILaya3D.ShadowLightType.SpotLight);
                    shadowCasterPass.render(context, scene, ILaya3D.ShadowLightType.SpotLight);
                } else {
                    scene._shaderValues.removeDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW_SPOT);
                }
                if (needShadowCasterPass) scene._shaderValues.addDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW);
                if (spotneedShadowCasterPass) scene._shaderValues.addDefine(Scene3DShaderDeclaration.SHADERDEFINE_SHADOW_SPOT);
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_SHADOWMAP);
                return needShadowCasterPass || spotneedShadowCasterPass;
            }
        },
        {
            key: "_preRenderMainPass",
            value: function _preRenderMainPass(context, scene, needInternalRT, viewport) {
                context.camera = this;
                context.cameraShaderValue = this._shaderValues;
                Camera._updateMark++;
                scene._preRenderScript();
                var gl = Laya.LayaGL.instance;
                if (needInternalRT && !this._offScreenRenderTexture && (this.clearFlag == exports.CameraClearFlags.DepthOnly || this.clearFlag == exports.CameraClearFlags.Nothing)) {
                    if (RenderTexture.bindCanvasRender) {
                        var blit = BlitScreenQuadCMD.create(RenderTexture.bindCanvasRender, this._internalRenderTexture);
                        blit.setContext(context);
                        blit.run();
                        blit.recover();
                    } else {
                        if (this._enableHDR) {
                            var grabTexture = RenderTexture.createFromPool(viewport.width, viewport.height, Laya.RenderTextureFormat.R8G8B8, Laya.RenderTextureDepthFormat.DEPTH_16);
                            grabTexture.filterMode = Laya.FilterMode.Bilinear;
                            Laya.WebGLContext.bindTexture(gl, gl.TEXTURE_2D, grabTexture._getSource());
                            gl.copyTexSubImage2D(gl.TEXTURE_2D, 0, 0, 0, viewport.x, RenderContext3D.clientHeight - (viewport.y + viewport.height), viewport.width, viewport.height);
                            var blit = BlitScreenQuadCMD.create(grabTexture, this._internalRenderTexture);
                            blit.setContext(context);
                            blit.run();
                            blit.recover();
                            RenderTexture.recoverToPool(grabTexture);
                        } else {
                            Laya.WebGLContext.bindTexture(gl, gl.TEXTURE_2D, this._internalRenderTexture._getSource());
                            gl.copyTexSubImage2D(gl.TEXTURE_2D, 0, 0, 0, viewport.x, RenderContext3D.clientHeight - (viewport.y + viewport.height), viewport.width, viewport.height);
                        }
                    }
                }
            }
        },
        {
            key: "_renderMainPass",
            value: function _renderMainPass(context, viewport, scene, shader, replacementTag, needInternalRT) {
                var gl = Laya.LayaGL.instance;
                var renderTex = this._getRenderTexture();
                if (renderTex && renderTex._isCameraTarget) context.invertY = true;
                context.viewport = viewport;
                this._prepareCameraToRender();
                var multiLighting = Config3D._config._multiLighting;
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_CLUSTER);
                multiLighting && Cluster.instance.update(this, scene);
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_CLUSTER);
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_CULLING);
                scene._preCulling(context, this, shader, replacementTag);
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_CULLING);
                this._applyViewProject(context, this.viewMatrix, this._projectionMatrix);
                if (this.depthTextureMode != 0) {
                    this._renderDepthMode(context);
                }
                renderTex && renderTex._start();
                scene._clear(gl, context);
                this._applyCommandBuffer(exports.CameraEventFlags.BeforeForwardOpaque, context);
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDEROPAQUE);
                scene._renderScene(context, ILaya3D.Scene3D.SCENERENDERFLAG_RENDERQPAQUE);
                this._opaquePass && this._createOpaqueTexture(renderTex, context);
                renderTex && renderTex._start();
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDEROPAQUE);
                this._applyCommandBuffer(exports.CameraEventFlags.BeforeSkyBox, context);
                scene._renderScene(context, ILaya3D.Scene3D.SCENERENDERFLAG_SKYBOX);
                this._applyCommandBuffer(exports.CameraEventFlags.BeforeTransparent, context);
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERTRANSPARENT);
                scene._renderScene(context, ILaya3D.Scene3D.SCENERENDERFLAG_RENDERTRANSPARENT);
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERTRANSPARENT);
                scene._postRenderScript();
                this._applyCommandBuffer(exports.CameraEventFlags.BeforeImageEffect, context);
                renderTex && renderTex._end();
                if (needInternalRT) {
                    if (this._postProcess && this._postProcess.enable) {
                        Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_POSTPROCESS);
                        this._postProcess.commandContext = context;
                        this._postProcess._render();
                        this._postProcess._applyPostProcessCommandBuffers();
                        Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_POSTPROCESS);
                    } else if (this._enableHDR || this._needBuiltInRenderTexture) {
                        var canvasWidth = this._getCanvasWidth(),
                        canvasHeight = this._getCanvasHeight();
                        if (this._offScreenRenderTexture) {
                            this._screenOffsetScale.setValue(viewport.x / canvasWidth, viewport.y / canvasHeight, viewport.width / canvasWidth, viewport.height / canvasHeight);
                            this._internalCommandBuffer._camera = this;
                            this._internalCommandBuffer._context = context;
                            this._internalCommandBuffer.blitScreenQuad(this._internalRenderTexture, this._offScreenRenderTexture, this._screenOffsetScale, null, null, 0, true);
                            this._internalCommandBuffer._apply();
                            this._internalCommandBuffer.clear();
                        }
                    }
                    RenderTexture.bindCanvasRender = this._internalRenderTexture;
                } else {
                    RenderTexture.bindCanvasRender = null;
                }
                this._applyCommandBuffer(exports.CameraEventFlags.AfterEveryThing, context);
            }
        },
        {
            key: "_renderDepthMode",
            value: function _renderDepthMode(context) {
                Laya.PerformancePlugin.begainSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERDEPTHMDOE);
                var cameraDepthMode = this._depthTextureMode;
                if ((cameraDepthMode & exports.DepthTextureMode.Depth) != 0) {
                    if (!this.canblitDepth || !this._internalRenderTexture.depthStencilTexture) {
                        Camera.depthPass.update(this, exports.DepthTextureMode.Depth, this._depthTextureFormat);
                        Camera.depthPass.render(context, exports.DepthTextureMode.Depth);
                    } else {
                        this.depthTexture = this._internalRenderTexture.depthStencilTexture;
                        Camera.depthPass._depthTexture = this.depthTexture;
                        Camera.depthPass._setupDepthModeShaderValue(exports.DepthTextureMode.Depth, this);
                    }
                }
                if ((cameraDepthMode & exports.DepthTextureMode.DepthNormals) != 0) {
                    Camera.depthPass.update(this, exports.DepthTextureMode.DepthNormals, this._depthTextureFormat);
                    Camera.depthPass.render(context, exports.DepthTextureMode.DepthNormals);
                }
                Laya.PerformancePlugin.endSample(Laya.PerformancePlugin.PERFORMANCE_LAYA_3D_RENDER_RENDERDEPTHMDOE);
            }
        },
        {
            key: "_aftRenderMainPass",
            value: function _aftRenderMainPass(needShadowPass) {
                if (needShadowPass) ILaya3D.Scene3D._shadowCasterPass.cleanUp();
                Camera.depthPass.cleanUp();
            }
        },
        {
            key: "_createOpaqueTexture",
            value: function _createOpaqueTexture(currentTarget, renderContext) {
                if (!this._opaqueTexture) {
                    var tex = this._getRenderTexture();
                    this._opaqueTexture = RenderTexture.createFromPool(tex.width, tex.height, tex.format, Laya.RenderTextureDepthFormat.DEPTHSTENCIL_NONE);
                    this._shaderValues.setTexture(BaseCamera.OPAQUETEXTURE, this._opaqueTexture);
                }
                var blit = BlitScreenQuadCMD.create(currentTarget, this._opaqueTexture);
                blit.setContext(renderContext);
                blit.run();
                blit.recover();
            }
        },
        {
            key: "render",
            value: function render() {
                var shader = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                var replacementTag = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                if (!this.activeInHierarchy) return;
                var viewport = this.viewport;
                var needInternalRT = this._needInternalRenderTexture();
                var context = RenderContext3D._instance;
                var scene = context.scene = this._scene;
                context.pipelineMode = context.configPipeLineMode;
                context.replaceTag = replacementTag;
                context.customShader = shader;
                if (needInternalRT) {
                    if (this._msaa && Laya.LayaGL.layaGPUInstance._isWebGL2) {
                        this._internalRenderTexture = MulSampleRenderTexture.createFromPool(viewport.width, viewport.height, this._getRenderTextureFormat(), this._depthTextureFormat);
                        this._internalRenderTexture.filterMode = Laya.FilterMode.Bilinear;
                    } else {
                        this._internalRenderTexture = RenderTexture.createFromPool(viewport.width, viewport.height, this._getRenderTextureFormat(), this._depthTextureFormat);
                        this._internalRenderTexture.filterMode = Laya.FilterMode.Bilinear;
                    }
                } else {
                    this._internalRenderTexture = null;
                }
                var needShadowCasterPass = this._renderShadowMap(scene, context);
                this._preRenderMainPass(context, scene, needInternalRT, viewport);
                this._renderMainPass(context, viewport, scene, shader, replacementTag, needInternalRT);
                this._aftRenderMainPass(needShadowCasterPass);
            }
        },
        {
            key: "viewportPointToRay",
            value: function viewportPointToRay(point, out) {
                this._rayViewport.x = this.viewport.x;
                this._rayViewport.y = this.viewport.y;
                this._rayViewport.width = Laya.Laya.stage._width;
                this._rayViewport.height = Laya.Laya.stage._height;
                Picker.calculateCursorRay(point, this._rayViewport, this._projectionMatrix, this.viewMatrix, null, out);
            }
        },
        {
            key: "normalizedViewportPointToRay",
            value: function normalizedViewportPointToRay(point, out) {
                var finalPoint = Camera._tempVector20;
                var vp = this.normalizedViewport;
                point.x = point.x * Config3D._config.pixelRatio;
                point.y = point.y * Config3D._config.pixelRatio;
                finalPoint.x = point.x * vp.width;
                finalPoint.y = point.y * vp.height;
                Picker.calculateCursorRay(finalPoint, this.viewport, this._projectionMatrix, this.viewMatrix, null, out);
            }
        },
        {
            key: "worldToViewportPoint",
            value: function worldToViewportPoint(position, out) {
                Matrix4x4.multiply(this._projectionMatrix, this._viewMatrix, this._projectionViewMatrix);
                this.viewport.project(position, this._projectionViewMatrix, out);
                var r = Config3D._config.pixelResol;
                var _wr = (out.x - this.viewport.x) / r;
                var _hr = (out.y - this.viewport.y) / r;
                out.x = _wr + this.viewport.x;
                out.y = _hr + this.viewport.y;
                out.x = out.x / Laya.Laya.stage.clientScaleX | 0;
                out.y = out.y / Laya.Laya.stage.clientScaleY | 0;
            }
        },
        {
            key: "worldToNormalizedViewportPoint",
            value: function worldToNormalizedViewportPoint(position, out) {
                this.worldToViewportPoint(position, out);
                out.x = out.x / Laya.Laya.stage.width;
                out.y = out.y / Laya.Laya.stage.height;
            }
        },
        {
            key: "convertScreenCoordToOrthographicCoord",
            value: function convertScreenCoordToOrthographicCoord(source, out) {
                if (this._orthographic) {
                    var clientWidth = this.clientWidth;
                    var clientHeight = this.clientHeight;
                    var ratioX = this.orthographicVerticalSize * this.aspectRatio / clientWidth;
                    var ratioY = this.orthographicVerticalSize / clientHeight;
                    out.x = ( - clientWidth / 2 + source.x * Laya.Laya.stage.clientScaleX) * ratioX;
                    out.y = (clientHeight / 2 - source.y * Laya.Laya.stage.clientScaleY) * ratioY;
                    out.z = (this.nearPlane - this.farPlane) * (source.z + 1) / 2 - this.nearPlane;
                    Vector3.transformCoordinate(out, this.transform.worldMatrix, out);
                    return true;
                } else {
                    return false;
                }
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                this._offScreenRenderTexture = null;
                this.transform.off(Laya.Event.TRANSFORM_CHANGED, this, this._onTransformChanged);
                _get(_getPrototypeOf(Camera.prototype), "destroy", this).call(this, destroyChild);
            }
        },
        {
            key: "addCommandBuffer",
            value: function addCommandBuffer(event, commandBuffer) {
                var commandBufferArray = this._cameraEventCommandBuffer[event];
                if (!commandBufferArray) commandBufferArray = this._cameraEventCommandBuffer[event] = [];
                if (commandBufferArray.indexOf(commandBuffer) < 0) commandBufferArray.push(commandBuffer);
                commandBuffer._camera = this;
            }
        },
        {
            key: "removeCommandBuffer",
            value: function removeCommandBuffer(event, commandBuffer) {
                var commandBufferArray = this._cameraEventCommandBuffer[event];
                if (commandBufferArray) {
                    var index = commandBufferArray.indexOf(commandBuffer);
                    if (index != -1) commandBufferArray.splice(index, 1);
                } else throw "Camera:unknown event.";
            }
        },
        {
            key: "removeCommandBuffers",
            value: function removeCommandBuffers(event) {
                if (this._cameraEventCommandBuffer[event]) this._cameraEventCommandBuffer[event].length = 0;
            }
        },
        {
            key: "_create",
            value: function _create() {
                return new Camera();
            }
        }], [{
            key: "_updateMark",
            get: function get() {
                return Camera.__updateMark;
            },
            set: function set(value) {
                Camera.__updateMark = value;
            }
        },
        {
            key: "drawRenderTextureByScene",
            value: function drawRenderTextureByScene(camera, scene, renderTexture) {
                var shader = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var replaceFlag = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                return function(scene) {
                    if (!renderTexture) return null;
                    var recoverTexture = camera.renderTarget;
                    camera.renderTarget = renderTexture;
                    var viewport = camera.viewport;
                    var needInternalRT = camera._needInternalRenderTexture();
                    var context = RenderContext3D._instance;
                    var scene = context.scene = scene;
                    context.pipelineMode = context.configPipeLineMode;
                    context.replaceTag = replaceFlag;
                    context.customShader = shader;
                    if (needInternalRT) {
                        camera._internalRenderTexture = RenderTexture.createFromPool(viewport.width, viewport.height, camera._getRenderTextureFormat(), camera.depthTextureFormat);
                        camera._internalRenderTexture.filterMode = Laya.FilterMode.Bilinear;
                    } else {
                        camera._internalRenderTexture = null;
                    }
                    var needShadowCasterPass = camera._renderShadowMap(scene, context);
                    camera._preRenderMainPass(context, scene, needInternalRT, viewport);
                    camera._renderMainPass(context, viewport, scene, shader, replaceFlag, needInternalRT);
                    camera._aftRenderMainPass(needShadowCasterPass);
                    camera.renderTarget = recoverTexture;
                    return camera.renderTarget;
                } (scene);
            }
        }]);
        return Camera;
    } (BaseCamera);
    Camera._tempVector20 = new Vector2();
    Camera.__updateMark = 0;
    Camera.depthPass = new DepthPass();
    var Input3D =
    /*#__PURE__*/
    function() {
        function Input3D() {
            var _this35 = this;
            _classCallCheck(this, Input3D);
            this._eventList = [];
            this._mouseTouch = new MouseTouch();
            this._touchPool = [];
            this._touches = new SimpleSingletonList();
            this._multiTouchEnabled = true;
            this._pushEventList = function(e) {
                e.cancelable && e.preventDefault();
                _this35._eventList.push(e);
            }.bind(this);
        }
        _createClass(Input3D, [{
            key: "__init__",
            value: function __init__(canvas, scene) {
                this._scene = scene;
                Physics3D._bullet && (Input3D._tempHitResult0 = new Laya.HitResult());
                canvas.oncontextmenu = function(e) {
                    return false;
                };
            }
        },
        {
            key: "_onCanvasEvent",
            value: function _onCanvasEvent(canvas) {
                canvas.addEventListener('mousedown', this._pushEventList);
                canvas.addEventListener('mouseup', this._pushEventList, true);
                canvas.addEventListener('mousemove', this._pushEventList, true);
                canvas.addEventListener("touchstart", this._pushEventList);
                canvas.addEventListener("touchend", this._pushEventList, true);
                canvas.addEventListener("touchmove", this._pushEventList, true);
                canvas.addEventListener("touchcancel", this._pushEventList, true);
            }
        },
        {
            key: "_offCanvasEvent",
            value: function _offCanvasEvent(canvas) {
                canvas.removeEventListener('mousedown', this._pushEventList);
                canvas.removeEventListener('mouseup', this._pushEventList, true);
                canvas.removeEventListener('mousemove', this._pushEventList, true);
                canvas.removeEventListener("touchstart", this._pushEventList);
                canvas.removeEventListener("touchend", this._pushEventList, true);
                canvas.removeEventListener("touchmove", this._pushEventList, true);
                canvas.removeEventListener("touchcancel", this._pushEventList, true);
                this._eventList.length = 0;
                this._touches.clear();
            }
        },
        {
            key: "touchCount",
            value: function touchCount() {
                return this._touches.length;
            }
        },
        {
            key: "multiTouchEnabled",
            get: function get() {
                return this._multiTouchEnabled;
            },
            set: function set(value) {
                this._multiTouchEnabled = value;
            }
        },
        {
            key: "_getTouch",
            value: function _getTouch(touchID, type) {
                var touch = this._touchPool[touchID];
                if (type == 0 && touch && touch._getIndexInList() != -1) return null;
                if (type == 1 && touch && touch._getIndexInList() == -1) return null;
                if (!touch) {
                    touch = new Touch();
                    this._touchPool[touchID] = touch;
                    touch._identifier = touchID;
                }
                return touch;
            }
        },
        {
            key: "_mouseTouchDown",
            value: function _mouseTouchDown() {
                var touch = this._mouseTouch;
                var sprite = touch.sprite;
                touch._pressedSprite = sprite;
                touch._pressedLoopCount = Laya.Stat.loopCount;
                if (sprite) {
                    var scripts = sprite._scripts;
                    if (scripts) {
                        for (var i = 0,
                        n = scripts.length; i < n; i++) {
                            scripts[i].onMouseDown();
                        }
                    }
                }
            }
        },
        {
            key: "_mouseTouchUp",
            value: function _mouseTouchUp() {
                var i, n;
                var touch = this._mouseTouch;
                var lastPressedSprite = touch._pressedSprite;
                touch._pressedSprite = null;
                touch._pressedLoopCount = -1;
                var sprite = touch.sprite;
                if (sprite) {
                    if (sprite === lastPressedSprite) {
                        var scripts = sprite._scripts;
                        if (scripts) {
                            for (i = 0, n = scripts.length; i < n; i++) {
                                scripts[i].onMouseClick();
                            }
                        }
                    }
                }
                if (lastPressedSprite) {
                    var lastScripts = lastPressedSprite._scripts;
                    if (lastScripts) {
                        for (i = 0, n = lastScripts.length; i < n; i++) {
                            lastScripts[i].onMouseUp();
                        }
                    }
                }
            }
        },
        {
            key: "_mouseTouchRayCast",
            value: function _mouseTouchRayCast(cameras) {
                if (!Physics3D._bullet && !Physics3D._cannon) return;
                var touchHitResult = Input3D._tempHitResult0;
                var touchPos = Input3D._tempVector20;
                var touchRay = Input3D._tempRay0;
                touchHitResult.succeeded = false;
                var x = this._mouseTouch.mousePositionX;
                var y = this._mouseTouch.mousePositionY;
                touchPos.x = x;
                touchPos.y = y;
                for (var i = cameras.length - 1; i >= 0; i--) {
                    var camera = cameras[i];
                    var viewport = camera.viewport;
                    var ratio = Config3D._config.pixelResol;
                    if (touchPos.x >= viewport.x && touchPos.y >= viewport.y && touchPos.x <= viewport.width / ratio && touchPos.y <= viewport.height / ratio) {
                        camera.viewportPointToRay(touchPos, touchRay);
                        var sucess = this._scene._physicsSimulation.rayCast(touchRay, touchHitResult);
                        if (sucess || camera.clearFlag === exports.CameraClearFlags.SolidColor || camera.clearFlag === exports.CameraClearFlags.Sky) break;
                    }
                }
                var touch = this._mouseTouch;
                var lastSprite = touch.sprite;
                if (touchHitResult.succeeded) {
                    var touchSprite = touchHitResult.collider.owner;
                    touch.sprite = touchSprite;
                    var scripts = touchSprite._scripts;
                    if (lastSprite !== touchSprite) {
                        if (scripts) {
                            for (var j = 0,
                            m = scripts.length; j < m; j++) {
                                scripts[j].onMouseEnter();
                            }
                        }
                    }
                } else {
                    touch.sprite = null;
                }
                if (lastSprite && lastSprite !== touchSprite) {
                    var outScripts = lastSprite._scripts;
                    if (outScripts) {
                        for (j = 0, m = outScripts.length; j < m; j++) {
                            outScripts[j].onMouseOut();
                        }
                    }
                }
            }
        },
        {
            key: "_changeTouches",
            value: function _changeTouches(changedTouches, flag) {
                var offsetX = 0,
                offsetY = 0;
                var lastCount = this._touches.length;
                for (var j = 0,
                m = changedTouches.length; j < m; j++) {
                    var nativeTouch = changedTouches[j];
                    var identifier = nativeTouch.identifier;
                    if (!this._multiTouchEnabled && this._touches.length !== 0 && flag == 0) continue;
                    var touch = this._getTouch(identifier, flag);
                    if (flag == 1 && !touch) continue;
                    var pos = this._touchPool[identifier]._position;
                    var mousePoint = Input3D._tempPoint;
                    mousePoint.setTo(nativeTouch.pageX, nativeTouch.pageY);
                    Laya.ILaya.stage._canvasTransform.invertTransformPoint(mousePoint);
                    var posX = mousePoint.x;
                    var posY = mousePoint.y;
                    switch (flag) {
                    case 0:
                        if ( !! touch) this._touches.add(touch);
                        offsetX += posX;
                        offsetY += posY;
                        break;
                    case 1:
                        if ( !! touch) this._touches.remove(touch);
                        offsetX -= posX;
                        offsetY -= posY;
                        break;
                    case 2:
                        offsetX = posX - pos.x;
                        offsetY = posY - pos.y;
                        break;
                    }
                    pos.x = posX;
                    pos.y = posY;
                }
                var touchCount = this._touches.length;
                if (touchCount === 0) {
                    this._mouseTouch.mousePositionX = 0;
                    this._mouseTouch.mousePositionY = 0;
                } else {
                    this._mouseTouch.mousePositionX = (this._mouseTouch.mousePositionX * lastCount + offsetX) / touchCount;
                    this._mouseTouch.mousePositionY = (this._mouseTouch.mousePositionY * lastCount + offsetY) / touchCount;
                }
            }
        },
        {
            key: "_update",
            value: function _update() {
                var enablePhysics = Physics3D._enablePhysics && !Laya.PhysicsSimulation.disableSimulation;
                var i, n, j, m;
                n = this._eventList.length;
                var cameras = this._scene._cameraPool;
                if (n > 0) {
                    var rayCast = false;
                    for (i = 0; i < n; i++) {
                        var e = this._eventList[i];
                        switch (e.type) {
                        case "mousedown":
                            enablePhysics && this._mouseTouchDown();
                            break;
                        case "mouseup":
                            enablePhysics && this._mouseTouchUp();
                            break;
                        case "mousemove":
                            var mousePoint = Input3D._tempPoint;
                            mousePoint.setTo(e.pageX, e.pageY);
                            Laya.ILaya.stage._canvasTransform.invertTransformPoint(mousePoint);
                            this._mouseTouch.mousePositionX = mousePoint.x;
                            this._mouseTouch.mousePositionY = mousePoint.y;
                            enablePhysics && (rayCast = true);
                            break;
                        case "touchstart":
                            var lastLength = this._touches.length;
                            this._changeTouches(e.changedTouches, 0);
                            if (enablePhysics) { ! Config3D._config.isUseCannonPhysicsEngine && this._mouseTouchRayCast(cameras);
                                lastLength === 0 && this._mouseTouchDown();
                            }
                            break;
                        case "touchend":
                        case "touchcancel":
                            this._changeTouches(e.changedTouches, 1);
                            enablePhysics && this._touches.length === 0 && this._mouseTouchUp();
                            break;
                        case "touchmove":
                            this._changeTouches(e.changedTouches, 2);
                            enablePhysics && (rayCast = true);
                            break;
                        default:
                            throw "Input3D:unkonwn event type.";
                        }
                    }
                    rayCast && !Config3D._config.isUseCannonPhysicsEngine && this._mouseTouchRayCast(cameras);
                    this._eventList.length = 0;
                }
                if (enablePhysics) {
                    var mouseTouch = this._mouseTouch;
                    var pressedSprite = mouseTouch._pressedSprite;
                    if (pressedSprite && Laya.Stat.loopCount > mouseTouch._pressedLoopCount) {
                        var pressedScripts = pressedSprite._scripts;
                        if (pressedScripts) {
                            for (j = 0, m = pressedScripts.length; j < m; j++) {
                                pressedScripts[j].onMouseDrag();
                            }
                        }
                    }
                    var touchSprite = mouseTouch.sprite;
                    if (touchSprite) {
                        var scripts = touchSprite._scripts;
                        if (scripts) {
                            for (j = 0, m = scripts.length; j < m; j++) {
                                scripts[j].onMouseOver();
                            }
                        }
                    }
                }
            }
        },
        {
            key: "getTouch",
            value: function getTouch(index) {
                if (index < this._touches.length) {
                    return this._touches.elements[index];
                } else {
                    return null;
                }
            }
        }]);
        return Input3D;
    } ();
    Input3D._tempPoint = new Laya.Point();
    Input3D._tempVector20 = new Vector2();
    Input3D._tempRay0 = new Ray(new Vector3(), new Vector3());
    var VertexPositionTexture0 =
    /*#__PURE__*/
    function() {
        function VertexPositionTexture0(position, textureCoordinate0) {
            _classCallCheck(this, VertexPositionTexture0);
            this._position = position;
            this._textureCoordinate0 = textureCoordinate0;
        }
        _createClass(VertexPositionTexture0, [{
            key: "position",
            get: function get() {
                return this._position;
            }
        },
        {
            key: "textureCoordinate0",
            get: function get() {
                return this._textureCoordinate0;
            }
        },
        {
            key: "vertexDeclaration",
            get: function get() {
                return VertexPositionTexture0._vertexDeclaration;
            }
        }], [{
            key: "vertexDeclaration",
            get: function get() {
                return VertexPositionTexture0._vertexDeclaration;
            }
        },
        {
            key: "__init__",
            value: function __init__() {
                VertexPositionTexture0._vertexDeclaration = new VertexDeclaration(20, [new VertexElement(0, VertexElementFormat.Vector3, VertexMesh.MESH_POSITION0), new VertexElement(12, VertexElementFormat.Vector2, VertexMesh.MESH_TEXTURECOORDINATE0)]);
            }
        }]);
        return VertexPositionTexture0;
    } ();
    var SkyDome =
    /*#__PURE__*/
    function(_SkyMesh2) {
        _inherits(SkyDome, _SkyMesh2);
        var _super38 = _createSuper(SkyDome);
        function SkyDome() {
            var _this36;
            var stacks = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 48;
            var slices = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 48;
            _classCallCheck(this, SkyDome);
            _this36 = _super38.call(this);
            var gl = Laya.LayaGL.instance;
            _this36._stacks = stacks;
            _this36._slices = slices;
            var vertexDeclaration = VertexPositionTexture0.vertexDeclaration;
            var vertexFloatCount = vertexDeclaration.vertexStride / 4;
            var numberVertices = (_this36._stacks + 1) * (_this36._slices + 1);
            var numberIndices = 3 * _this36._stacks * (_this36._slices + 1) * 2;
            var vertices = new Float32Array(numberVertices * vertexFloatCount);
            var indices = new Uint16Array(numberIndices);
            var stackAngle = Math.PI / _this36._stacks;
            var sliceAngle = Math.PI * 2.0 / _this36._slices;
            var vertexIndex = 0;
            var vertexCount = 0;
            var indexCount = 0;
            for (var stack = 0; stack < _this36._stacks + 1; stack++) {
                var r = Math.sin(stack * stackAngle);
                var y = Math.cos(stack * stackAngle);
                for (var slice = 0; slice < _this36._slices + 1; slice++) {
                    var x = r * Math.sin(slice * sliceAngle);
                    var z = r * Math.cos(slice * sliceAngle);
                    vertices[vertexCount + 0] = x * SkyDome._radius;
                    vertices[vertexCount + 1] = y * SkyDome._radius;
                    vertices[vertexCount + 2] = z * SkyDome._radius;
                    vertices[vertexCount + 3] = -(slice / _this36._slices) + 0.75;
                    vertices[vertexCount + 4] = stack / _this36._stacks;
                    vertexCount += vertexFloatCount;
                    if (stack != _this36._stacks - 1) {
                        indices[indexCount++] = vertexIndex + 1;
                        indices[indexCount++] = vertexIndex;
                        indices[indexCount++] = vertexIndex + (_this36._slices + 1);
                        indices[indexCount++] = vertexIndex + (_this36._slices + 1);
                        indices[indexCount++] = vertexIndex;
                        indices[indexCount++] = vertexIndex + _this36._slices;
                        vertexIndex++;
                    }
                }
            }
            _this36._vertexBuffer = new VertexBuffer3D(vertices.length * 4, gl.STATIC_DRAW, false);
            _this36._vertexBuffer.vertexDeclaration = vertexDeclaration;
            _this36._indexBuffer = new IndexBuffer3D(exports.IndexFormat.UInt16, indices.length, gl.STATIC_DRAW, false);
            _this36._vertexBuffer.setData(vertices.buffer);
            _this36._indexBuffer.setData(indices);
            var bufferState = new BufferState();
            bufferState.bind();
            bufferState.applyVertexBuffer(_this36._vertexBuffer);
            bufferState.applyIndexBuffer(_this36._indexBuffer);
            bufferState.unBind();
            _this36._bufferState = bufferState;
            return _this36;
        }
        _createClass(SkyDome, [{
            key: "stacks",
            get: function get() {
                return this._stacks;
            }
        },
        {
            key: "slices",
            get: function get() {
                return this._slices;
            }
        },
        {
            key: "_render",
            value: function _render(state) {
                var gl = Laya.LayaGL.instance;
                var indexCount = this._indexBuffer.indexCount;
                gl.drawElements(gl.TRIANGLES, indexCount, gl.UNSIGNED_SHORT, 0);
                Laya.Stat.trianglesFaces += indexCount / 3;
                Laya.Stat.renderBatches++;
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                SkyDome.instance = new SkyDome();
            }
        }]);
        return SkyDome;
    } (SkyMesh);
    SkyDome._radius = 1;
    var LightQueue =
    /*#__PURE__*/
    function() {
        function LightQueue() {
            _classCallCheck(this, LightQueue);
            this._length = 0;
            this._elements = [];
        }
        _createClass(LightQueue, [{
            key: "add",
            value: function add(light) {
                if (this._length === this._elements.length) this._elements.push(light);
                else this._elements[this._length] = light;
                this._length++;
            }
        },
        {
            key: "remove",
            value: function remove(light) {
                var index = this._elements.indexOf(light);
                this._length--;
                if (index !== this._length) {
                    var end = this._elements[this._length];
                    this._elements[index] = end;
                }
            }
        },
        {
            key: "shift",
            value: function shift() {
                this._length--;
                return this._elements.shift();
            }
        },
        {
            key: "getBrightestLight",
            value: function getBrightestLight() {
                var maxIntIndex;
                var maxIntensity = -1;
                var elements = this._elements;
                for (var i = 0; i < this._length; i++) {
                    var intensity = elements[i]._intensity;
                    if (maxIntensity < intensity) {
                        maxIntensity = intensity;
                        maxIntIndex = i;
                    }
                }
                return maxIntIndex;
            }
        },
        {
            key: "normalLightOrdering",
            value: function normalLightOrdering(brightestIndex) {
                var firstLight = this._elements[0];
                this._elements[0] = this._elements[brightestIndex];
                this._elements[brightestIndex] = firstLight;
            }
        }]);
        return LightQueue;
    } ();
    var AlternateLightQueue =
    /*#__PURE__*/
    function(_LightQueue) {
        _inherits(AlternateLightQueue, _LightQueue);
        var _super39 = _createSuper(AlternateLightQueue);
        function AlternateLightQueue() {
            _classCallCheck(this, AlternateLightQueue);
            return _super39.apply(this, arguments);
        }
        _createClass(AlternateLightQueue, [{
            key: "remove",
            value: function remove(light) {
                var index = this._elements.indexOf(light);
                this._elements.splice(index, 1);
                this._length--;
            }
        }]);
        return AlternateLightQueue;
    } (LightQueue);
    var PixelLineMaterial =
    /*#__PURE__*/
    function(_Material5) {
        _inherits(PixelLineMaterial, _Material5);
        var _super40 = _createSuper(PixelLineMaterial);
        function PixelLineMaterial() {
            var _this37;
            _classCallCheck(this, PixelLineMaterial);
            _this37 = _super40.call(this);
            _this37.setShaderName("LineShader");
            _this37._shaderValues.setVector(PixelLineMaterial.COLOR, new Vector4(1.0, 1.0, 1.0, 1.0));
            return _this37;
        }
        _createClass(PixelLineMaterial, [{
            key: "color",
            get: function get() {
                return this._shaderValues.getVector(PixelLineMaterial.COLOR);
            },
            set: function set(value) {
                this._shaderValues.setVector(PixelLineMaterial.COLOR, value);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new PixelLineMaterial();
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "__initDefine__",
            value: function __initDefine__() {}
        }]);
        return PixelLineMaterial;
    } (Material);
    PixelLineMaterial.COLOR = Shader3D.propertyNameToID("u_Color");
    var BoundBox =
    /*#__PURE__*/
    function() {
        function BoundBox(min, max) {
            _classCallCheck(this, BoundBox);
            this._lastBoundIndex = -1;
            this.min = min;
            this.max = max;
        }
        _createClass(BoundBox, [{
            key: "_rotateExtents",
            value: function _rotateExtents(extents, rotation, out) {
                var extentsX = extents.x;
                var extentsY = extents.y;
                var extentsZ = extents.z;
                var matElements = rotation.elements;
                out.x = Math.abs(matElements[0] * extentsX) + Math.abs(matElements[4] * extentsY) + Math.abs(matElements[8] * extentsZ);
                out.y = Math.abs(matElements[1] * extentsX) + Math.abs(matElements[5] * extentsY) + Math.abs(matElements[9] * extentsZ);
                out.z = Math.abs(matElements[2] * extentsX) + Math.abs(matElements[6] * extentsY) + Math.abs(matElements[10] * extentsZ);
            }
        },
        {
            key: "getCorners",
            value: function getCorners(corners) {
                corners.length = 8;
                var minX = this.min.x;
                var minY = this.min.y;
                var minZ = this.min.z;
                var maxX = this.max.x;
                var maxY = this.max.y;
                var maxZ = this.max.z;
                corners[0] = new Vector3(minX, maxY, maxZ);
                corners[1] = new Vector3(maxX, maxY, maxZ);
                corners[2] = new Vector3(maxX, minY, maxZ);
                corners[3] = new Vector3(minX, minY, maxZ);
                corners[4] = new Vector3(minX, maxY, minZ);
                corners[5] = new Vector3(maxX, maxY, minZ);
                corners[6] = new Vector3(maxX, minY, minZ);
                corners[7] = new Vector3(minX, minY, minZ);
            }
        },
        {
            key: "getCenter",
            value: function getCenter(out) {
                Vector3.add(this.min, this.max, out);
                Vector3.scale(out, 0.5, out);
            }
        },
        {
            key: "getExtent",
            value: function getExtent(out) {
                Vector3.subtract(this.max, this.min, out);
                Vector3.scale(out, 0.5, out);
            }
        },
        {
            key: "setCenterAndExtent",
            value: function setCenterAndExtent(center, extent) {
                Vector3.subtract(center, extent, this.min);
                Vector3.add(center, extent, this.max);
            }
        },
        {
            key: "tranform",
            value: function tranform(matrix, out) {
                var center = BoundBox._tempVector30;
                var extent = BoundBox._tempVector31;
                this.getCenter(center);
                this.getExtent(extent);
                Vector3.transformCoordinate(center, matrix, center);
                this._rotateExtents(extent, matrix, extent);
                out.setCenterAndExtent(center, extent);
            }
        },
        {
            key: "toDefault",
            value: function toDefault() {
                this.min.toDefault();
                this.max.toDefault();
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var dest = destObject;
                this.min.cloneTo(dest.min);
                this.max.cloneTo(dest.max);
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new BoundBox(new Vector3(), new Vector3());
                this.cloneTo(dest);
                return dest;
            }
        }], [{
            key: "createfromPoints",
            value: function createfromPoints(points, out) {
                if (points == null) throw new Error("points");
                var min = out.min;
                var max = out.max;
                min.x = Number.MAX_VALUE;
                min.y = Number.MAX_VALUE;
                min.z = Number.MAX_VALUE;
                max.x = -Number.MAX_VALUE;
                max.y = -Number.MAX_VALUE;
                max.z = -Number.MAX_VALUE;
                for (var i = 0,
                n = points.length; i < n; ++i) {
                    Vector3.min(min, points[i], min);
                    Vector3.max(max, points[i], max);
                }
            }
        },
        {
            key: "merge",
            value: function merge(box1, box2, out) {
                Vector3.min(box1.min, box2.min, out.min);
                Vector3.max(box1.max, box2.max, out.max);
            }
        }]);
        return BoundBox;
    } ();
    BoundBox._tempVector30 = new Vector3();
    BoundBox._tempVector31 = new Vector3();
    var Bounds =
    /*#__PURE__*/
    function() {
        function Bounds(min, max) {
            _classCallCheck(this, Bounds);
            this._updateFlag = 0;
            this._center = new Vector3();
            this._extent = new Vector3();
            this._boundBox = new BoundBox(new Vector3(), new Vector3());
            min.cloneTo(this._boundBox.min);
            max.cloneTo(this._boundBox.max);
            this._setUpdateFlag(Bounds._UPDATE_CENTER | Bounds._UPDATE_EXTENT, true);
        }
        _createClass(Bounds, [{
            key: "setMin",
            value: function setMin(value) {
                var min = this._boundBox.min;
                if (value !== min) value.cloneTo(min);
                this._setUpdateFlag(Bounds._UPDATE_CENTER | Bounds._UPDATE_EXTENT, true);
                this._setUpdateFlag(Bounds._UPDATE_MIN, false);
            }
        },
        {
            key: "getMin",
            value: function getMin() {
                var min = this._boundBox.min;
                if (this._getUpdateFlag(Bounds._UPDATE_MIN)) {
                    this._getMin(this.getCenter(), this.getExtent(), min);
                    this._setUpdateFlag(Bounds._UPDATE_MIN, false);
                }
                return min;
            }
        },
        {
            key: "setMax",
            value: function setMax(value) {
                var max = this._boundBox.max;
                if (value !== max) value.cloneTo(max);
                this._setUpdateFlag(Bounds._UPDATE_CENTER | Bounds._UPDATE_EXTENT, true);
                this._setUpdateFlag(Bounds._UPDATE_MAX, false);
            }
        },
        {
            key: "getMax",
            value: function getMax() {
                var max = this._boundBox.max;
                if (this._getUpdateFlag(Bounds._UPDATE_MAX)) {
                    this._getMax(this.getCenter(), this.getExtent(), max);
                    this._setUpdateFlag(Bounds._UPDATE_MAX, false);
                }
                return max;
            }
        },
        {
            key: "setCenter",
            value: function setCenter(value) {
                if (value !== this._center) value.cloneTo(this._center);
                this._setUpdateFlag(Bounds._UPDATE_MIN | Bounds._UPDATE_MAX, true);
                this._setUpdateFlag(Bounds._UPDATE_CENTER, false);
            }
        },
        {
            key: "getCenter",
            value: function getCenter() {
                if (this._getUpdateFlag(Bounds._UPDATE_CENTER)) {
                    this._getCenter(this.getMin(), this.getMax(), this._center);
                    this._setUpdateFlag(Bounds._UPDATE_CENTER, false);
                }
                return this._center;
            }
        },
        {
            key: "setExtent",
            value: function setExtent(value) {
                if (value !== this._extent) value.cloneTo(this._extent);
                this._setUpdateFlag(Bounds._UPDATE_MIN | Bounds._UPDATE_MAX, true);
                this._setUpdateFlag(Bounds._UPDATE_EXTENT, false);
            }
        },
        {
            key: "getExtent",
            value: function getExtent() {
                if (this._getUpdateFlag(Bounds._UPDATE_EXTENT)) {
                    this._getExtent(this.getMin(), this.getMax(), this._extent);
                    this._setUpdateFlag(Bounds._UPDATE_EXTENT, false);
                }
                return this._extent;
            }
        },
        {
            key: "_getUpdateFlag",
            value: function _getUpdateFlag(type) {
                return (this._updateFlag & type) != 0;
            }
        },
        {
            key: "_setUpdateFlag",
            value: function _setUpdateFlag(type, value) {
                if (value) this._updateFlag |= type;
                else this._updateFlag &= ~type;
            }
        },
        {
            key: "_getCenter",
            value: function _getCenter(min, max, out) {
                Vector3.add(min, max, out);
                Vector3.scale(out, 0.5, out);
            }
        },
        {
            key: "_getExtent",
            value: function _getExtent(min, max, out) {
                Vector3.subtract(max, min, out);
                Vector3.scale(out, 0.5, out);
            }
        },
        {
            key: "_getMin",
            value: function _getMin(center, extent, out) {
                Vector3.subtract(center, extent, out);
            }
        },
        {
            key: "_getMax",
            value: function _getMax(center, extent, out) {
                Vector3.add(center, extent, out);
            }
        },
        {
            key: "_rotateExtents",
            value: function _rotateExtents(extents, rotation, out) {
                var extentsX = extents.x;
                var extentsY = extents.y;
                var extentsZ = extents.z;
                var matE = rotation.elements;
                out.x = Math.abs(matE[0] * extentsX) + Math.abs(matE[4] * extentsY) + Math.abs(matE[8] * extentsZ);
                out.y = Math.abs(matE[1] * extentsX) + Math.abs(matE[5] * extentsY) + Math.abs(matE[9] * extentsZ);
                out.z = Math.abs(matE[2] * extentsX) + Math.abs(matE[6] * extentsY) + Math.abs(matE[10] * extentsZ);
            }
        },
        {
            key: "_tranform",
            value: function _tranform(matrix, out) {
                var outCen = out._center;
                var outExt = out._extent;
                Vector3.transformCoordinate(this.getCenter(), matrix, outCen);
                this._rotateExtents(this.getExtent(), matrix, outExt);
                out._boundBox.setCenterAndExtent(outCen, outExt);
                out._updateFlag = 0;
            }
        },
        {
            key: "_getBoundBox",
            value: function _getBoundBox() {
                if (this._updateFlag & Bounds._UPDATE_MIN) {
                    var min = this._boundBox.min;
                    this._getMin(this.getCenter(), this.getExtent(), min);
                    this._setUpdateFlag(Bounds._UPDATE_MIN, false);
                }
                if (this._updateFlag & Bounds._UPDATE_MAX) {
                    var max = this._boundBox.max;
                    this._getMax(this.getCenter(), this.getExtent(), max);
                    this._setUpdateFlag(Bounds._UPDATE_MAX, false);
                }
                return this._boundBox;
            }
        },
        {
            key: "calculateBoundsintersection",
            value: function calculateBoundsintersection(bounds) {
                var ownMax = this.getMax();
                var ownMin = this.getMin();
                var calMax = bounds.getMax();
                var calMin = bounds.getMin();
                var tempV0 = Bounds.TEMP_VECTOR3_MAX0;
                var tempV1 = Bounds.TEMP_VECTOR3_MAX1;
                var thisExtends = this.getExtent();
                var boundExtends = bounds.getExtent();
                tempV0.setValue(Math.max(ownMax.x, calMax.x) - Math.min(ownMin.x, calMin.x), Math.max(ownMax.y, calMax.y) - Math.min(ownMin.y, calMin.y), Math.max(ownMax.z, calMax.z) - Math.min(ownMin.z, calMin.z));
                tempV1.setValue((thisExtends.x + boundExtends.x) * 2.0, (thisExtends.y + boundExtends.y) * 2.0, (thisExtends.z + boundExtends.z) * 2.0);
                if (tempV0.x > tempV1.x) return - 1;
                if (tempV0.y > tempV1.y) return - 1;
                if (tempV0.z > tempV1.z) return - 1;
                return (tempV1.x - tempV0.x) * (tempV1.y - tempV0.y) * (tempV1.z - tempV0.z);
            }
        },
        {
            key: "cloneTo",
            value: function cloneTo(destObject) {
                var destBounds = destObject;
                this.getMin().cloneTo(destBounds._boundBox.min);
                this.getMax().cloneTo(destBounds._boundBox.max);
                this.getCenter().cloneTo(destBounds._center);
                this.getExtent().cloneTo(destBounds._extent);
                destBounds._updateFlag = 0;
            }
        },
        {
            key: "clone",
            value: function clone() {
                var dest = new Bounds(new Vector3(), new Vector3());
                this.cloneTo(dest);
                return dest;
            }
        }]);
        return Bounds;
    } ();
    Bounds._UPDATE_MIN = 0x01;
    Bounds._UPDATE_MAX = 0x02;
    Bounds._UPDATE_CENTER = 0x04;
    Bounds._UPDATE_EXTENT = 0x08;
    Bounds.TEMP_VECTOR3_MAX0 = new Vector3();
    Bounds.TEMP_VECTOR3_MAX1 = new Vector3();
    var GeometryElement =
    /*#__PURE__*/
    function() {
        function GeometryElement() {
            _classCallCheck(this, GeometryElement);
            this._destroyed = false;
        }
        _createClass(GeometryElement, [{
            key: "destroyed",
            get: function get() {
                return this._destroyed;
            }
        },
        {
            key: "_getType",
            value: function _getType() {
                throw "GeometryElement:must override it.";
            }
        },
        {
            key: "_prepareRender",
            value: function _prepareRender(state) {
                return true;
            }
        },
        {
            key: "_render",
            value: function _render(state) {
                throw "GeometryElement:must override it.";
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                if (this._destroyed) return;
                this._destroyed = true;
            }
        }]);
        return GeometryElement;
    } ();
    GeometryElement._typeCounter = 0;
    var PixelLineVertex =
    /*#__PURE__*/
    function() {
        function PixelLineVertex() {
            _classCallCheck(this, PixelLineVertex);
        }
        _createClass(PixelLineVertex, [{
            key: "vertexDeclaration",
            get: function get() {
                return PixelLineVertex._vertexDeclaration;
            }
        }], [{
            key: "vertexDeclaration",
            get: function get() {
                return PixelLineVertex._vertexDeclaration;
            }
        },
        {
            key: "__init__",
            value: function __init__() {
                PixelLineVertex._vertexDeclaration = new VertexDeclaration(28, [new VertexElement(0, VertexElementFormat.Vector3, VertexMesh.MESH_POSITION0), new VertexElement(12, VertexElementFormat.Vector4, VertexMesh.MESH_COLOR0)]);
            }
        }]);
        return PixelLineVertex;
    } ();
    var PixelLineFilter =
    /*#__PURE__*/
    function(_GeometryElement) {
        _inherits(PixelLineFilter, _GeometryElement);
        var _super41 = _createSuper(PixelLineFilter);
        function PixelLineFilter(owner, maxLineCount) {
            var _this38;
            _classCallCheck(this, PixelLineFilter);
            _this38 = _super41.call(this);
            _this38._floatCountPerVertices = 7;
            _this38._minUpdate = Number.MAX_VALUE;
            _this38._maxUpdate = Number.MIN_VALUE;
            _this38._bufferState = new BufferState();
            _this38._floatBound = new Float32Array(6);
            _this38._calculateBound = false;
            _this38._maxLineCount = 0;
            _this38._lineCount = 0;
            var pointCount = maxLineCount * 2;
            _this38._owner = owner;
            _this38._maxLineCount = maxLineCount;
            _this38._vertices = new Float32Array(pointCount * _this38._floatCountPerVertices);
            _this38._vertexBuffer = new VertexBuffer3D(PixelLineVertex.vertexDeclaration.vertexStride * pointCount, Laya.LayaGL.instance.STATIC_DRAW, false);
            _this38._vertexBuffer.vertexDeclaration = PixelLineVertex.vertexDeclaration;
            _this38._bufferState.bind();
            _this38._bufferState.applyVertexBuffer(_this38._vertexBuffer);
            _this38._bufferState.unBind();
            var min = PixelLineFilter._tempVector0;
            var max = PixelLineFilter._tempVector1;
            min.setValue(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
            max.setValue( - Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
            _this38._bounds = new Bounds(min, max);
            return _this38;
        }
        _createClass(PixelLineFilter, [{
            key: "_getType",
            value: function _getType() {
                return PixelLineFilter._type;
            }
        },
        {
            key: "_resizeLineData",
            value: function _resizeLineData(maxCount) {
                var pointCount = maxCount * 2;
                var lastVertices = this._vertices;
                this._vertexBuffer.destroy();
                this._maxLineCount = maxCount;
                var vertexCount = pointCount * this._floatCountPerVertices;
                this._vertices = new Float32Array(vertexCount);
                this._vertexBuffer = new VertexBuffer3D(PixelLineVertex.vertexDeclaration.vertexStride * pointCount, Laya.LayaGL.instance.STATIC_DRAW, false);
                this._vertexBuffer.vertexDeclaration = PixelLineVertex.vertexDeclaration;
                if (vertexCount < lastVertices.length) {
                    this._vertices.set(new Float32Array(lastVertices.buffer, 0, vertexCount));
                    this._vertexBuffer.setData(this._vertices.buffer, 0, 0, vertexCount * 4);
                } else {
                    this._vertices.set(lastVertices);
                    this._vertexBuffer.setData(this._vertices.buffer, 0, 0, lastVertices.length * 4);
                }
                this._bufferState.bind();
                this._bufferState.applyVertexBuffer(this._vertexBuffer);
                this._bufferState.unBind();
                this._minUpdate = Number.MAX_VALUE;
                this._maxUpdate = Number.MIN_VALUE;
            }
        },
        {
            key: "_updateLineVertices",
            value: function _updateLineVertices(offset, startPosition, endPosition, startColor, endColor) {
                if (startPosition) {
                    this._vertices[offset + 0] = startPosition.x;
                    this._vertices[offset + 1] = startPosition.y;
                    this._vertices[offset + 2] = startPosition.z;
                }
                if (startColor) {
                    this._vertices[offset + 3] = startColor.r;
                    this._vertices[offset + 4] = startColor.g;
                    this._vertices[offset + 5] = startColor.b;
                    this._vertices[offset + 6] = startColor.a;
                }
                if (endPosition) {
                    this._vertices[offset + 7] = endPosition.x;
                    this._vertices[offset + 8] = endPosition.y;
                    this._vertices[offset + 9] = endPosition.z;
                }
                if (endColor) {
                    this._vertices[offset + 10] = endColor.r;
                    this._vertices[offset + 11] = endColor.g;
                    this._vertices[offset + 12] = endColor.b;
                    this._vertices[offset + 13] = endColor.a;
                }
                this._minUpdate = Math.min(this._minUpdate, offset);
                this._maxUpdate = Math.max(this._maxUpdate, offset + this._floatCountPerVertices * 2);
                var bounds = this._bounds;
                var floatBound = this._floatBound;
                var min = bounds.getMin(),
                max = bounds.getMax();
                Vector3.min(min, startPosition, min);
                Vector3.min(min, endPosition, min);
                Vector3.max(max, startPosition, max);
                Vector3.max(max, endPosition, max);
                bounds.setMin(min);
                bounds.setMax(max);
                floatBound[0] = min.x,
                floatBound[1] = min.y,
                floatBound[2] = min.z;
                floatBound[3] = max.x,
                floatBound[4] = max.y,
                floatBound[5] = max.z;
            }
        },
        {
            key: "_reCalculateBound",
            value: function _reCalculateBound() {
                if (this._calculateBound) {
                    var vertices = this._vertices;
                    var min = PixelLineFilter._tempVector0;
                    var max = PixelLineFilter._tempVector1;
                    min.setValue(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
                    max.setValue( - Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
                    for (var i = 0; i < this._lineCount * 2; ++i) {
                        var offset = this._floatCountPerVertices * i;
                        var x = vertices[offset + 0],
                        y = vertices[offset + 1],
                        z = vertices[offset + 2];
                        min.x = Math.min(x, min.x);
                        min.y = Math.min(y, min.y);
                        min.z = Math.min(z, min.z);
                        max.x = Math.max(x, max.x);
                        max.y = Math.max(y, max.y);
                        max.z = Math.max(z, max.z);
                    }
                    this._bounds.setMin(min);
                    this._bounds.setMax(max);
                    var floatBound = this._floatBound;
                    floatBound[0] = min.x,
                    floatBound[1] = min.y,
                    floatBound[2] = min.z;
                    floatBound[3] = max.x,
                    floatBound[4] = max.y,
                    floatBound[5] = max.z;
                    this._calculateBound = false;
                }
            }
        },
        {
            key: "_removeLineData",
            value: function _removeLineData(index) {
                var floatCount = this._floatCountPerVertices * 2;
                var nextIndex = index + 1;
                var offset = index * floatCount;
                var vertices = this._vertices;
                var rightPartVertices = new Float32Array(vertices.buffer, nextIndex * floatCount * 4, (this._lineCount - nextIndex) * floatCount);
                vertices.set(rightPartVertices, offset);
                this._minUpdate = Math.min(this._minUpdate, offset);
                this._maxUpdate = Math.max(this._maxUpdate, offset + rightPartVertices.length);
                this._lineCount--;
                var floatBound = this._floatBound;
                var startX = vertices[offset],
                startY = vertices[offset + 1],
                startZ = vertices[offset + 2];
                var endX = vertices[offset + 7],
                endY = vertices[offset + 8],
                endZ = vertices[offset + 9];
                var minX = floatBound[0],
                minY = floatBound[1],
                minZ = floatBound[2];
                var maxX = floatBound[3],
                maxY = floatBound[4],
                maxZ = floatBound[5];
                if (startX === minX || startX === maxX || startY === minY || startY === maxY || startZ === minZ || startZ === maxZ || endX === minX || endX === maxX || endY === minY || endY === maxY || endZ === minZ || endZ === maxZ) this._calculateBound = true;
            }
        },
        {
            key: "_updateLineData",
            value: function _updateLineData(index, startPosition, endPosition, startColor, endColor) {
                var floatCount = this._floatCountPerVertices * 2;
                this._updateLineVertices(index * floatCount, startPosition, endPosition, startColor, endColor);
            }
        },
        {
            key: "_updateLineDatas",
            value: function _updateLineDatas(index, data) {
                var floatCount = this._floatCountPerVertices * 2;
                var count = data.length;
                for (var i = 0; i < count; i++) {
                    var line = data[i];
                    this._updateLineVertices((index + i) * floatCount, line.startPosition, line.endPosition, line.startColor, line.endColor);
                }
            }
        },
        {
            key: "_getLineData",
            value: function _getLineData(index, out) {
                var startPosition = out.startPosition;
                var startColor = out.startColor;
                var endPosition = out.endPosition;
                var endColor = out.endColor;
                var vertices = this._vertices;
                var offset = index * this._floatCountPerVertices * 2;
                startPosition.x = vertices[offset + 0];
                startPosition.y = vertices[offset + 1];
                startPosition.z = vertices[offset + 2];
                startColor.r = vertices[offset + 3];
                startColor.g = vertices[offset + 4];
                startColor.b = vertices[offset + 5];
                startColor.a = vertices[offset + 6];
                endPosition.x = vertices[offset + 7];
                endPosition.y = vertices[offset + 8];
                endPosition.z = vertices[offset + 9];
                endColor.r = vertices[offset + 10];
                endColor.g = vertices[offset + 11];
                endColor.b = vertices[offset + 12];
                endColor.a = vertices[offset + 13];
            }
        },
        {
            key: "_prepareRender",
            value: function _prepareRender(state) {
                return true;
            }
        },
        {
            key: "_render",
            value: function _render(state) {
                if (this._minUpdate !== Number.MAX_VALUE && this._maxUpdate !== Number.MIN_VALUE) {
                    this._vertexBuffer.setData(this._vertices.buffer, this._minUpdate * 4, this._minUpdate * 4, (this._maxUpdate - this._minUpdate) * 4);
                    this._minUpdate = Number.MAX_VALUE;
                    this._maxUpdate = Number.MIN_VALUE;
                }
                if (this._lineCount > 0) {
                    this._bufferState.bind();
                    var gl = Laya.LayaGL.instance;
                    gl.drawArrays(gl.LINES, 0, this._lineCount * 2);
                    Laya.Stat.renderBatches++;
                }
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                if (this._destroyed) return;
                _get(_getPrototypeOf(PixelLineFilter.prototype), "destroy", this).call(this);
                this._bufferState.destroy();
                this._vertexBuffer.destroy();
                this._bufferState = null;
                this._vertexBuffer = null;
                this._vertices = null;
            }
        }]);
        return PixelLineFilter;
    } (GeometryElement);
    PixelLineFilter._tempVector0 = new Vector3();
    PixelLineFilter._tempVector1 = new Vector3();
    PixelLineFilter._type = GeometryElement._typeCounter++;
    var RenderableSprite3D =
    /*#__PURE__*/
    function(_Sprite3D3) {
        _inherits(RenderableSprite3D, _Sprite3D3);
        var _super42 = _createSuper(RenderableSprite3D);
        function RenderableSprite3D(name) {
            _classCallCheck(this, RenderableSprite3D);
            return _super42.call(this, name);
        }
        _createClass(RenderableSprite3D, [{
            key: "_onInActive",
            value: function _onInActive() {
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "_onInActive", this).call(this);
                this._scene._removeRenderObject(this._render);
            }
        },
        {
            key: "_onActive",
            value: function _onActive() {
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "_onActive", this).call(this);
                this._scene._addRenderObject(this._render);
            }
        },
        {
            key: "_onActiveInScene",
            value: function _onActiveInScene() {
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "_onActiveInScene", this).call(this);
                if (ILaya3D.Laya3D._editerEnvironment) {
                    var scene = this._scene;
                    var pickColor = new Vector4();
                    scene._allotPickColorByID(this.id, pickColor);
                    scene._pickIdToSprite[this.id] = this;
                    this._render._shaderValues.setVector(RenderableSprite3D.PICKCOLOR, pickColor);
                }
            }
        },
        {
            key: "_addToInitStaticBatchManager",
            value: function _addToInitStaticBatchManager() {}
        },
        {
            key: "_setBelongScene",
            value: function _setBelongScene(scene) {
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "_setBelongScene", this).call(this, scene);
                this._render._setBelongScene(scene);
            }
        },
        {
            key: "_setUnBelongScene",
            value: function _setUnBelongScene() {
                if (!this.destroyed) {
                    this._render._shaderValues.removeDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
                    this._render._setUnBelongScene();
                    _get(_getPrototypeOf(RenderableSprite3D.prototype), "_setUnBelongScene", this).call(this);
                }
            }
        },
        {
            key: "_changeHierarchyAnimator",
            value: function _changeHierarchyAnimator(animator) {
                if (this._hierarchyAnimator) {
                    var renderableSprites = this._hierarchyAnimator._renderableSprites;
                    renderableSprites.splice(renderableSprites.indexOf(this), 1);
                }
                if (animator) animator._renderableSprites.push(this);
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "_changeHierarchyAnimator", this).call(this, animator);
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                _get(_getPrototypeOf(RenderableSprite3D.prototype), "destroy", this).call(this, destroyChild);
                this._render._destroy();
                this._render = null;
            }
        },
        {
            key: "_create",
            value: function _create() {
                return new RenderableSprite3D(this.name);
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                RenderableSprite3D.SHADERDEFINE_RECEIVE_SHADOW = Shader3D.getDefineByName("RECEIVESHADOW");
                RenderableSprite3D.SAHDERDEFINE_LIGHTMAP = Shader3D.getDefineByName("LIGHTMAP");
                RenderableSprite3D.SHADERDEFINE_LIGHTMAP_DIRECTIONAL = Shader3D.getDefineByName("LIGHTMAP_DIRECTIONAL");
            }
        }]);
        return RenderableSprite3D;
    } (Sprite3D);
    RenderableSprite3D.LIGHTMAPSCALEOFFSET = Shader3D.propertyNameToID("u_LightmapScaleOffset");
    RenderableSprite3D.LIGHTMAP = Shader3D.propertyNameToID("u_LightMap");
    RenderableSprite3D.LIGHTMAP_DIRECTION = Shader3D.propertyNameToID("u_LightMapDirection");
    RenderableSprite3D.PICKCOLOR = Shader3D.propertyNameToID("u_PickColor");
    RenderableSprite3D.REFLECTIONTEXTURE = Shader3D.propertyNameToID("u_ReflectTexture");
    RenderableSprite3D.REFLECTIONCUBE_HDR_PARAMS = Shader3D.propertyNameToID("u_ReflectCubeHDRParams");
    RenderableSprite3D.REFLECTIONCUBE_PROBEPOSITION = Shader3D.propertyNameToID("u_SpecCubeProbePosition");
    RenderableSprite3D.REFLECTIONCUBE_PROBEBOXMAX = Shader3D.propertyNameToID("u_SpecCubeBoxMax");
    RenderableSprite3D.REFLECTIONCUBE_PROBEBOXMIN = Shader3D.propertyNameToID("u_SpecCubeBoxMin");
    var BatchMark =
    /*#__PURE__*/
    _createClass(function BatchMark() {
        _classCallCheck(this, BatchMark);
        this.updateMark = -1;
        this.indexInList = -1;
        this.batched = false;
    });
    var SubMeshInstanceBatch =
    /*#__PURE__*/
    function(_GeometryElement2) {
        _inherits(SubMeshInstanceBatch, _GeometryElement2);
        var _super43 = _createSuper(SubMeshInstanceBatch);
        function SubMeshInstanceBatch() {
            var _this39;
            _classCallCheck(this, SubMeshInstanceBatch);
            _this39 = _super43.call(this);
            _this39.instanceWorldMatrixData = new Float32Array(SubMeshInstanceBatch.maxInstanceCount * 16);
            _this39.instanceSimpleAnimatorData = new Float32Array(SubMeshInstanceBatch.maxInstanceCount * 4);
            var gl = Laya.LayaGL.instance;
            _this39.instanceWorldMatrixBuffer = new VertexBuffer3D(_this39.instanceWorldMatrixData.length * 4, gl.DYNAMIC_DRAW);
            _this39.instanceWorldMatrixBuffer.vertexDeclaration = VertexMesh.instanceWorldMatrixDeclaration;
            _this39.instanceSimpleAnimatorBuffer = new VertexBuffer3D(_this39.instanceSimpleAnimatorData.length * 4, gl.DYNAMIC_DRAW);
            _this39.instanceSimpleAnimatorBuffer.vertexDeclaration = VertexMesh.instanceSimpleAnimatorDeclaration;
            return _this39;
        }
        _createClass(SubMeshInstanceBatch, [{
            key: "_render",
            value: function _render(state) {
                var gl = Laya.LayaGL.instance;
                var element = state.renderElement;
                var subMesh = element.instanceSubMesh;
                var count = element.instanceBatchElementList.length;
                var indexCount = subMesh._indexCount;
                subMesh._mesh._instanceBufferState.bind();
                Laya.LayaGL.layaGPUInstance.drawElementsInstanced(gl.TRIANGLES, indexCount, gl.UNSIGNED_SHORT, subMesh._indexStart * 2, count);
                Laya.Stat.renderBatches++;
                Laya.Stat.savedRenderBatches += count - 1;
                Laya.Stat.trianglesFaces += indexCount * count / 3;
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                SubMeshInstanceBatch.instance = new SubMeshInstanceBatch();
            }
        }]);
        return SubMeshInstanceBatch;
    } (GeometryElement);
    SubMeshInstanceBatch.maxInstanceCount = 1024;
    var RenderElement =
    /*#__PURE__*/
    function() {
        function RenderElement() {
            _classCallCheck(this, RenderElement);
            this.renderSubShader = null;
            this.renderType = RenderElement.RENDERTYPE_NORMAL;
        }
        _createClass(RenderElement, [{
            key: "getInvertFront",
            value: function getInvertFront() {
                return this._transform._isFrontFaceInvert;
            }
        },
        {
            key: "setTransform",
            value: function setTransform(transform) {
                this._transform = transform;
            }
        },
        {
            key: "setGeometry",
            value: function setGeometry(geometry) {
                this._geometry = geometry;
            }
        },
        {
            key: "addToOpaqueRenderQueue",
            value: function addToOpaqueRenderQueue(context, queue) {
                queue.elements.add(this);
            }
        },
        {
            key: "addToTransparentRenderQueue",
            value: function addToTransparentRenderQueue(context, queue) {
                queue.elements.add(this);
                queue.lastTransparentBatched = false;
                queue.lastTransparentRenderElement = this;
            }
        },
        {
            key: "_update",
            value: function _update(scene, context, customShader, replacementTag) {
                var subshaderIndex = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                if (this.material) {
                    var subShader = this.material._shader.getSubShaderAt(0);
                    this.renderSubShader = null;
                    if (customShader) {
                        if (replacementTag) {
                            var oriTag = subShader.getFlag(replacementTag);
                            if (oriTag) {
                                var customSubShaders = customShader._subShaders;
                                for (var k = 0,
                                p = customSubShaders.length; k < p; k++) {
                                    var customSubShader = customSubShaders[k];
                                    if (oriTag === customSubShader.getFlag(replacementTag)) {
                                        this.renderSubShader = customSubShader;
                                        break;
                                    }
                                }
                                if (!this.renderSubShader) return;
                            } else {
                                return;
                            }
                        } else {
                            this.renderSubShader = customShader.getSubShaderAt(subshaderIndex);
                        }
                    } else {
                        this.renderSubShader = subShader;
                    }
                    var renderQueue = scene._getRenderQueue(this.material.renderQueue);
                    if (renderQueue.isTransparent) this.addToTransparentRenderQueue(context, renderQueue);
                    else this.addToOpaqueRenderQueue(context, renderQueue);
                }
            }
        },
        {
            key: "_render",
            value: function _render(context) {
                var forceInvertFace = context.invertY;
                var lastStateMaterial, lastStateShaderInstance, lastStateRender;
                var updateMark = Camera._updateMark;
                var sceneMark = ILaya3D.Scene3D._updateMark;
                var scene = context.scene;
                var cameraShaderValue = context.cameraShaderValue;
                var transform = this._transform;
                var geometry = this._geometry;
                context.renderElement = this;
                var sceneDataRender = sceneMark !== this.render._sceneUpdateMark || this.renderType !== this.render._updateRenderType;
                if (sceneDataRender) {
                    this.render._renderUpdate(context, transform);
                    this.render._sceneUpdateMark = sceneMark;
                } else {
                    if (this.renderType == RenderElement.RENDERTYPE_INSTANCEBATCH || this.renderType == RenderElement.RENDERTYPE_STATICBATCH) {
                        this.render._renderUpdate(context, transform);
                    }
                }
                var updateRender = updateMark !== this.render._updateMark || this.renderType !== this.render._updateRenderType;
                if (updateRender) {
                    this.render._renderUpdateWithCamera(context, transform);
                    this.render._updateMark = updateMark;
                    this.render._updateRenderType = this.renderType;
                } else {
                    if (this.renderType == RenderElement.RENDERTYPE_INSTANCEBATCH) {
                        this.render._renderUpdateWithCamera(context, transform);
                    }
                }
                var currentPipelineMode = context.pipelineMode;
                if (geometry._prepareRender(context)) {
                    var passes = this.renderSubShader._passes;
                    for (var j = 0,
                    m = passes.length; j < m; j++) {
                        var pass = passes[j];
                        if (pass._pipelineMode !== currentPipelineMode) continue;
                        var comDef = RenderElement._compileDefine;
                        scene._shaderValues._defineDatas.cloneTo(comDef);
                        comDef.addDefineDatas(this.render._shaderValues._defineDatas);
                        comDef.addDefineDatas(this.material._shaderValues._defineDatas);
                        var shaderIns = context.shader = pass.withCompile(comDef);
                        var switchShader = shaderIns.bind();
                        var switchUpdateMark = updateMark !== shaderIns._uploadMark;
                        var uploadScene = shaderIns._uploadScene !== scene || switchUpdateMark;
                        if (uploadScene || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._sceneUniformParamsMap, scene._shaderValues, uploadScene);
                            shaderIns._uploadScene = scene;
                        }
                        var uploadSprite3D = shaderIns._uploadRender !== this.render || shaderIns._uploadRenderType !== this.renderType || switchUpdateMark;
                        if (uploadSprite3D || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._spriteUniformParamsMap, this.render._shaderValues, uploadSprite3D);
                            shaderIns._uploadRender = this.render;
                            shaderIns._uploadRenderType = this.renderType;
                        }
                        var uploadCamera = shaderIns._uploadCameraShaderValue !== cameraShaderValue || switchUpdateMark;
                        if (uploadCamera || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._cameraUniformParamsMap, cameraShaderValue, uploadCamera);
                            shaderIns._uploadCameraShaderValue = cameraShaderValue;
                        }
                        var uploadMaterial = shaderIns._uploadMaterial !== this.material || switchUpdateMark;
                        if (uploadMaterial || switchShader) {
                            shaderIns.uploadUniforms(shaderIns._materialUniformParamsMap, this.material._shaderValues, uploadMaterial);
                            shaderIns._uploadMaterial = this.material;
                        }
                        var matValues = this.material._shaderValues;
                        if (lastStateMaterial !== this.material || lastStateShaderInstance !== shaderIns) {
                            shaderIns.uploadRenderStateBlendDepth(matValues);
                            shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, this.getInvertFront());
                            lastStateMaterial = this.material;
                            lastStateShaderInstance = shaderIns;
                            lastStateRender = this.render;
                        } else {
                            if (lastStateRender !== this.render) {
                                shaderIns.uploadRenderStateFrontFace(matValues, forceInvertFace, this.getInvertFront());
                                lastStateRender = this.render;
                            }
                        }
                        geometry._render(context);
                        shaderIns._uploadMark = updateMark;
                    }
                }
                if (this.renderType !== RenderElement.RENDERTYPE_NORMAL) this.render._revertBatchRenderUpdate(context);
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                this._transform = null;
                this._geometry = null;
                this.material = null;
                this.render = null;
            }
        }]);
        return RenderElement;
    } ();
    RenderElement.RENDERTYPE_NORMAL = 0;
    RenderElement.RENDERTYPE_STATICBATCH = 1;
    RenderElement.RENDERTYPE_INSTANCEBATCH = 2;
    RenderElement.RENDERTYPE_VERTEXBATCH = 3;
    RenderElement._compileDefine = new DefineDatas();
    var SubMeshRenderElement =
    /*#__PURE__*/
    function(_RenderElement) {
        _inherits(SubMeshRenderElement, _RenderElement);
        var _super44 = _createSuper(SubMeshRenderElement);
        function SubMeshRenderElement() {
            var _this40;
            _classCallCheck(this, SubMeshRenderElement);
            _this40 = _super44.call(this);
            _this40._dynamicWorldPositionNormalNeedUpdate = true;
            return _this40;
        }
        _createClass(SubMeshRenderElement, [{
            key: "_onWorldMatrixChanged",
            value: function _onWorldMatrixChanged() {
                this._dynamicWorldPositionNormalNeedUpdate = true;
            }
        },
        {
            key: "_computeWorldPositionsAndNormals",
            value: function _computeWorldPositionsAndNormals(positionOffset, normalOffset, multiSubMesh, vertexCount) {
                if (this._dynamicWorldPositionNormalNeedUpdate) {
                    var subMesh = this._geometry;
                    var vertexBuffer = subMesh._vertexBuffer;
                    var vertexFloatCount = vertexBuffer.vertexDeclaration.vertexStride / 4;
                    var oriVertexes = vertexBuffer.getFloat32Data();
                    var worldMat = this._transform.worldMatrix;
                    var rotation = this._transform.rotation;
                    var indices = subMesh._indices;
                    for (var i = 0; i < vertexCount; i++) {
                        var index = multiSubMesh ? indices[i] : i;
                        var oriOffset = index * vertexFloatCount;
                        var bakeOffset = i * 3;
                        Utils3D.transformVector3ArrayToVector3ArrayCoordinate(oriVertexes, oriOffset + positionOffset, worldMat, this._dynamicWorldPositions, bakeOffset);
                        normalOffset !== -1 && Utils3D.transformVector3ArrayByQuat(oriVertexes, oriOffset + normalOffset, rotation, this._dynamicWorldNormals, bakeOffset);
                    }
                    this._dynamicWorldPositionNormalNeedUpdate = false;
                }
            }
        },
        {
            key: "setTransform",
            value: function setTransform(transform) {
                if (this._transform !== transform) {
                    this._transform && this._transform.off(Laya.Event.TRANSFORM_CHANGED, this, this._onWorldMatrixChanged);
                    transform && transform.on(Laya.Event.TRANSFORM_CHANGED, this, this._onWorldMatrixChanged);
                    this._dynamicWorldPositionNormalNeedUpdate = true;
                    this._transform = transform;
                }
            }
        },
        {
            key: "setGeometry",
            value: function setGeometry(geometry) {
                if (this._geometry !== geometry) {
                    var subMesh = geometry;
                    var mesh = subMesh._mesh;
                    if (mesh) {
                        var multiSubMesh = mesh._subMeshes.length > 1;
                        var dynBatVerCount = multiSubMesh ? subMesh._indexCount: mesh._vertexCount;
                        if (dynBatVerCount <= ILaya3D.SubMeshDynamicBatch.maxAllowVertexCount) {
                            var length = dynBatVerCount * 3;
                            this._dynamicVertexBatch = true;
                            this._dynamicWorldPositions = new Float32Array(length);
                            this._dynamicWorldNormals = new Float32Array(length);
                            this._dynamicVertexCount = dynBatVerCount;
                            this._dynamicMultiSubMesh = multiSubMesh;
                        } else {
                            this._dynamicVertexBatch = false;
                        }
                    }
                    this._geometry = geometry;
                }
            }
        },
        {
            key: "addToOpaqueRenderQueue",
            value: function addToOpaqueRenderQueue(context, queue) {
                var subMeshStaticBatch = this.staticBatch;
                var queueElements = queue.elements;
                var elements = queueElements.elements;
                if (subMeshStaticBatch && (!this.render._probReflection || this.render._probReflection._isScene) && SubMeshRenderElement.enableStaticBatch) {
                    var staManager = ILaya3D.MeshRenderStaticBatchManager.instance;
                    var staBatchMarks = staManager.getBatchOpaquaMark(this.render.lightmapIndex + 1, this.render.receiveShadow, this.material.id, subMeshStaticBatch._batchID);
                    if (staManager._updateCountMark === staBatchMarks.updateMark) {
                        var staBatchIndex = staBatchMarks.indexInList;
                        if (staBatchMarks.batched) {
                            elements[staBatchIndex].staticBatchElementList.add(this);
                        } else {
                            var staOriElement = elements[staBatchIndex];
                            var staOriRender = staOriElement.render;
                            var staBatchElement = staManager._getBatchRenderElementFromPool();
                            staBatchElement.renderType = RenderElement.RENDERTYPE_STATICBATCH;
                            staBatchElement.setGeometry(subMeshStaticBatch);
                            staBatchElement.material = staOriElement.material;
                            var staRootOwner = subMeshStaticBatch.batchOwner;
                            var staBatchTransform = staRootOwner ? staRootOwner._transform: null;
                            staBatchElement.setTransform(staBatchTransform);
                            staBatchElement.render = staOriRender;
                            staBatchElement.renderSubShader = staOriElement.renderSubShader;
                            var staBatchList = staBatchElement.staticBatchElementList;
                            staBatchList.length = 0;
                            staBatchList.add(staOriElement);
                            staBatchList.add(this);
                            elements[staBatchIndex] = staBatchElement;
                            staBatchMarks.batched = true;
                        }
                    } else {
                        staBatchMarks.updateMark = staManager._updateCountMark;
                        staBatchMarks.indexInList = queueElements.length;
                        staBatchMarks.batched = false;
                        queueElements.add(this);
                    }
                } else if (SubMeshRenderElement.enableDynamicBatch && this.renderSubShader._owner._enableInstancing && Laya.LayaGL.layaGPUInstance.supportInstance() && this.render.lightmapIndex < 0 && (!this.render._probReflection || this.render._probReflection._isScene)) {
                    var subMesh = this._geometry;
                    var insManager = ILaya3D.MeshRenderDynamicBatchManager.instance;
                    var insBatchMarks = insManager.getInstanceBatchOpaquaMark(this.render.receiveShadow, this.material.id, subMesh._id, this._transform._isFrontFaceInvert);
                    if (insManager._updateCountMark === insBatchMarks.updateMark) {
                        var insBatchIndex = insBatchMarks.indexInList;
                        if (insBatchMarks.batched) {
                            var instanceBatchElementList = elements[insBatchIndex].instanceBatchElementList;
                            if (instanceBatchElementList.length === SubMeshInstanceBatch.maxInstanceCount) {
                                insBatchMarks.updateMark = insManager._updateCountMark;
                                insBatchMarks.indexInList = queueElements.length;
                                insBatchMarks.batched = false;
                                queueElements.add(this);
                            } else {
                                instanceBatchElementList.add(this);
                            }
                        } else {
                            var insOriElement = elements[insBatchIndex];
                            var insOriRender = insOriElement.render;
                            var insBatchElement = insManager._getBatchRenderElementFromPool();
                            insBatchElement.renderType = RenderElement.RENDERTYPE_INSTANCEBATCH;
                            insBatchElement.setGeometry(SubMeshInstanceBatch.instance);
                            insBatchElement.material = insOriElement.material;
                            insBatchElement.setTransform(null);
                            insBatchElement.render = insOriRender;
                            insBatchElement.instanceSubMesh = subMesh;
                            insBatchElement.renderSubShader = insOriElement.renderSubShader;
                            var insBatchList = insBatchElement.instanceBatchElementList;
                            insBatchList.length = 0;
                            insBatchList.add(insOriElement);
                            insBatchList.add(this);
                            elements[insBatchIndex] = insBatchElement;
                            insBatchMarks.batched = true;
                        }
                    } else {
                        insBatchMarks.updateMark = insManager._updateCountMark;
                        insBatchMarks.indexInList = queueElements.length;
                        insBatchMarks.batched = false;
                        queueElements.add(this);
                    }
                } else if (this._dynamicVertexBatch && SubMeshRenderElement.enableDynamicBatch) {
                    var verDec = this._geometry._vertexBuffer.vertexDeclaration;
                    var dynManager = ILaya3D.MeshRenderDynamicBatchManager.instance;
                    var dynBatchMarks = dynManager.getVertexBatchOpaquaMark(this.render.lightmapIndex + 1, this.render.receiveShadow, this.material.id, verDec.id);
                    if (dynManager._updateCountMark === dynBatchMarks.updateMark) {
                        var dynBatchIndex = dynBatchMarks.indexInList;
                        if (dynBatchMarks.batched) {
                            elements[dynBatchIndex].vertexBatchElementList.add(this);
                        } else {
                            var dynOriElement = elements[dynBatchIndex];
                            var dynOriRender = dynOriElement.render;
                            var dynBatchElement = dynManager._getBatchRenderElementFromPool();
                            dynBatchElement.renderType = RenderElement.RENDERTYPE_VERTEXBATCH;
                            dynBatchElement.setGeometry(ILaya3D.SubMeshDynamicBatch.instance);
                            dynBatchElement.material = dynOriElement.material;
                            dynBatchElement.setTransform(null);
                            dynBatchElement.render = dynOriRender;
                            dynBatchElement.vertexBatchVertexDeclaration = verDec;
                            dynBatchElement.renderSubShader = dynOriElement.renderSubShader;
                            var dynBatchList = dynBatchElement.vertexBatchElementList;
                            dynBatchList.length = 0;
                            dynBatchList.add(dynOriElement);
                            dynBatchList.add(this);
                            elements[dynBatchIndex] = dynBatchElement;
                            dynBatchMarks.batched = true;
                        }
                    } else {
                        dynBatchMarks.updateMark = dynManager._updateCountMark;
                        dynBatchMarks.indexInList = queueElements.length;
                        dynBatchMarks.batched = false;
                        queueElements.add(this);
                    }
                } else {
                    queueElements.add(this);
                }
            }
        },
        {
            key: "addToTransparentRenderQueue",
            value: function addToTransparentRenderQueue(context, queue) {
                var subMeshStaticBatch = this.staticBatch;
                var queueElements = queue.elements;
                var elements = queueElements.elements;
                if (subMeshStaticBatch && SubMeshRenderElement.enableStaticBatch) {
                    var staManager = ILaya3D.MeshRenderStaticBatchManager.instance;
                    var staLastElement = queue.lastTransparentRenderElement;
                    if (staLastElement) {
                        var staLastRender = staLastElement.render;
                        if (staLastElement._geometry._getType() !== this._geometry._getType() || staLastElement.staticBatch !== subMeshStaticBatch || staLastElement.material !== this.material || staLastRender.receiveShadow !== this.render.receiveShadow || staLastRender.lightmapIndex !== this.render.lightmapIndex) {
                            queueElements.add(this);
                            queue.lastTransparentBatched = false;
                        } else {
                            if (queue.lastTransparentBatched) {
                                elements[queueElements.length - 1].staticBatchElementList.add(this);
                            } else {
                                var staBatchElement = staManager._getBatchRenderElementFromPool();
                                staBatchElement.renderType = RenderElement.RENDERTYPE_STATICBATCH;
                                staBatchElement.setGeometry(subMeshStaticBatch);
                                staBatchElement.material = staLastElement.material;
                                var staRootOwner = subMeshStaticBatch.batchOwner;
                                var staBatchTransform = staRootOwner ? staRootOwner._transform: null;
                                staBatchElement.setTransform(staBatchTransform);
                                staBatchElement.render = this.render;
                                staBatchElement.renderSubShader = staLastElement.renderSubShader;
                                var staBatchList = staBatchElement.staticBatchElementList;
                                staBatchList.length = 0;
                                staBatchList.add(staLastElement);
                                staBatchList.add(this);
                                elements[queueElements.length - 1] = staBatchElement;
                            }
                            queue.lastTransparentBatched = true;
                        }
                    } else {
                        queueElements.add(this);
                        queue.lastTransparentBatched = false;
                    }
                } else if (SubMeshRenderElement.enableDynamicBatch && this.renderSubShader._owner._enableInstancing && Laya.LayaGL.layaGPUInstance.supportInstance() && this.render.lightmapIndex < 0 && (!this.render._probReflection || this.render._probReflection._isScene)) {
                    var subMesh = this._geometry;
                    var insManager = ILaya3D.MeshRenderDynamicBatchManager.instance;
                    var insLastElement = queue.lastTransparentRenderElement;
                    if (insLastElement) {
                        var insLastRender = insLastElement.render;
                        if (insLastElement._geometry._getType() !== this._geometry._getType() || insLastElement._geometry !== subMesh || insLastElement.material !== this.material || insLastRender.receiveShadow !== this.render.receiveShadow) {
                            queueElements.add(this);
                            queue.lastTransparentBatched = false;
                        } else {
                            if (queue.lastTransparentBatched) {
                                var instanceBatchElementList = elements[queueElements.length - 1].instanceBatchElementList;
                                if (instanceBatchElementList.length === SubMeshInstanceBatch.maxInstanceCount) {
                                    queueElements.add(this);
                                    queue.lastTransparentBatched = false;
                                } else {
                                    instanceBatchElementList.add(this);
                                    queue.lastTransparentBatched = true;
                                }
                            } else {
                                var insBatchElement = insManager._getBatchRenderElementFromPool();
                                insBatchElement.renderType = RenderElement.RENDERTYPE_INSTANCEBATCH;
                                insBatchElement.setGeometry(SubMeshInstanceBatch.instance);
                                insBatchElement.material = insLastElement.material;
                                insBatchElement.setTransform(null);
                                insBatchElement.render = this.render;
                                insBatchElement.instanceSubMesh = subMesh;
                                insBatchElement.renderSubShader = insLastElement.renderSubShader;
                                var insBatchList = insBatchElement.instanceBatchElementList;
                                insBatchList.length = 0;
                                insBatchList.add(insLastElement);
                                insBatchList.add(this);
                                elements[queueElements.length - 1] = insBatchElement;
                                queue.lastTransparentBatched = true;
                            }
                        }
                    } else {
                        queueElements.add(this);
                        queue.lastTransparentBatched = false;
                    }
                } else if (this._dynamicVertexBatch && SubMeshRenderElement.enableDynamicBatch) {
                    var verDec = this._geometry._vertexBuffer.vertexDeclaration;
                    var dynManager = ILaya3D.MeshRenderDynamicBatchManager.instance;
                    var dynLastElement = queue.lastTransparentRenderElement;
                    if (dynLastElement) {
                        var dynLastRender = dynLastElement.render;
                        if (!dynLastElement._dynamicVertexBatch || dynLastElement._geometry._getType() !== this._geometry._getType() || dynLastElement._geometry._vertexBuffer._vertexDeclaration !== verDec || dynLastElement.material !== this.material || dynLastRender.receiveShadow !== this.render.receiveShadow || dynLastRender.lightmapIndex !== this.render.lightmapIndex) {
                            queueElements.add(this);
                            queue.lastTransparentBatched = false;
                        } else {
                            if (queue.lastTransparentBatched) {
                                elements[queueElements.length - 1].vertexBatchElementList.add(this);
                            } else {
                                var dynBatchElement = dynManager._getBatchRenderElementFromPool();
                                dynBatchElement.renderType = RenderElement.RENDERTYPE_VERTEXBATCH;
                                dynBatchElement.setGeometry(ILaya3D.SubMeshDynamicBatch.instance);
                                dynBatchElement.material = dynLastElement.material;
                                dynBatchElement.setTransform(null);
                                dynBatchElement.render = this.render;
                                dynBatchElement.vertexBatchVertexDeclaration = verDec;
                                dynBatchElement.renderSubShader = dynLastElement.renderSubShader;
                                var dynBatchList = dynBatchElement.vertexBatchElementList;
                                dynBatchList.length = 0;
                                dynBatchList.add(dynLastElement);
                                dynBatchList.add(this);
                                elements[queueElements.length - 1] = dynBatchElement;
                            }
                            queue.lastTransparentBatched = true;
                        }
                    } else {
                        queueElements.add(this);
                        queue.lastTransparentBatched = false;
                    }
                } else {
                    queueElements.add(this);
                }
                queue.lastTransparentRenderElement = this;
            }
        },
        {
            key: "getInvertFront",
            value: function getInvertFront() {
                switch (this.renderType) {
                case RenderElement.RENDERTYPE_NORMAL:
                    return this._transform._isFrontFaceInvert;
                case RenderElement.RENDERTYPE_STATICBATCH:
                case RenderElement.RENDERTYPE_VERTEXBATCH:
                    return false;
                case RenderElement.RENDERTYPE_INSTANCEBATCH:
                    return this.instanceBatchElementList.elements[0]._transform._isFrontFaceInvert;
                default:
                    throw "SubMeshRenderElement: unknown renderType";
                }
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                _get(_getPrototypeOf(SubMeshRenderElement.prototype), "destroy", this).call(this);
                this._dynamicWorldPositions = null;
                this._dynamicWorldNormals = null;
                this.staticBatch = null;
                this.staticBatchElementList = null;
                this.vertexBatchElementList = null;
                this.vertexBatchVertexDeclaration = null;
            }
        }]);
        return SubMeshRenderElement;
    } (RenderElement);
    SubMeshRenderElement.enableDynamicBatch = true;
    SubMeshRenderElement.enableStaticBatch = true;
    var StaticBatchManager =
    /*#__PURE__*/
    function() {
        function StaticBatchManager() {
            _classCallCheck(this, StaticBatchManager);
            this._initBatchSprites = [];
            this._staticBatches = {};
            this._batchRenderElementPoolIndex = 0;
            this._batchRenderElementPool = [];
        }
        _createClass(StaticBatchManager, [{
            key: "_partition",
            value: function _partition(items, left, right) {
                var pivot = items[Math.floor((right + left) / 2)];
                while (left <= right) {
                    while (this._compare(items[left], pivot) < 0) {
                        left++;
                    }
                    while (this._compare(items[right], pivot) > 0) {
                        right--;
                    }
                    if (left < right) {
                        var temp = items[left];
                        items[left] = items[right];
                        items[right] = temp;
                        left++;
                        right--;
                    } else if (left === right) {
                        left++;
                        break;
                    }
                }
                return left;
            }
        },
        {
            key: "_quickSort",
            value: function _quickSort(items, left, right) {
                if (items.length > 1) {
                    var index = this._partition(items, left, right);
                    var leftIndex = index - 1;
                    if (left < leftIndex) this._quickSort(items, left, leftIndex);
                    if (index < right) this._quickSort(items, index, right);
                }
            }
        },
        {
            key: "_compare",
            value: function _compare(left, right) {
                throw "StaticBatch:must override this function.";
            }
        },
        {
            key: "_initStaticBatchs",
            value: function _initStaticBatchs(rootSprite) {
                throw "StaticBatch:must override this function.";
            }
        },
        {
            key: "_getBatchRenderElementFromPool",
            value: function _getBatchRenderElementFromPool() {
                throw "StaticBatch:must override this function.";
            }
        },
        {
            key: "_addBatchSprite",
            value: function _addBatchSprite(renderableSprite3D) {
                this._initBatchSprites.push(renderableSprite3D);
            }
        },
        {
            key: "_clear",
            value: function _clear() {
                this._batchRenderElementPoolIndex = 0;
            }
        },
        {
            key: "_garbageCollection",
            value: function _garbageCollection() {
                throw "StaticBatchManager: must override it.";
            }
        },
        {
            key: "dispose",
            value: function dispose() {
                this._staticBatches = null;
            }
        }], [{
            key: "_addToStaticBatchQueue",
            value: function _addToStaticBatchQueue(sprite3D, renderableSprite3D) {
                if (sprite3D instanceof RenderableSprite3D) renderableSprite3D.push(sprite3D);
                for (var i = 0,
                n = sprite3D.numChildren; i < n; i++) {
                    StaticBatchManager._addToStaticBatchQueue(sprite3D._children[i], renderableSprite3D);
                }
            }
        },
        {
            key: "_registerManager",
            value: function _registerManager(manager) {
                StaticBatchManager._managers.push(manager);
            }
        },
        {
            key: "combine",
            value: function combine(staticBatchRoot) {
                var renderableSprite3Ds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                if (!renderableSprite3Ds) {
                    renderableSprite3Ds = [];
                    if (staticBatchRoot) StaticBatchManager._addToStaticBatchQueue(staticBatchRoot, renderableSprite3Ds);
                }
                var batchSpritesCount = renderableSprite3Ds.length;
                if (batchSpritesCount > 0) {
                    for (var i = 0; i < batchSpritesCount; i++) {
                        var sprite = renderableSprite3Ds[i];
                        if (!sprite.destroyed) {
                            if (sprite._render._isPartOfStaticBatch) console.warn("StaticBatchManager: Sprite " + sprite.name + " has a part of Static Batch,it will be ignore.");
                            else sprite._addToInitStaticBatchManager();
                        }
                    }
                    for (var k = 0,
                    m = StaticBatchManager._managers.length; k < m; k++) {
                        var manager = StaticBatchManager._managers[k];
                        manager._initStaticBatchs(staticBatchRoot);
                    }
                }
            }
        }]);
        return StaticBatchManager;
    } ();
    StaticBatchManager._managers = [];
    var SubMeshStaticBatch =
    /*#__PURE__*/
    function(_GeometryElement3) {
        _inherits(SubMeshStaticBatch, _GeometryElement3);
        var _super45 = _createSuper(SubMeshStaticBatch);
        function SubMeshStaticBatch(batchOwner, vertexDeclaration) {
            var _this41;
            _classCallCheck(this, SubMeshStaticBatch);
            _this41 = _super45.call(this);
            _this41._bufferState = new BufferState();
            _this41._batchID = SubMeshStaticBatch._batchIDCounter++;
            _this41._batchElements = [];
            _this41._currentBatchVertexCount = 0;
            _this41._currentBatchIndexCount = 0;
            _this41._vertexDeclaration = vertexDeclaration;
            _this41.batchOwner = batchOwner;
            return _this41;
        }
        _createClass(SubMeshStaticBatch, [{
            key: "_getStaticBatchBakedVertexs",
            value: function _getStaticBatchBakedVertexs(batchVertices, batchOffset, batchOwnerTransform, transform, render, mesh) {
                var vertexBuffer = mesh._vertexBuffer;
                var vertexDeclaration = vertexBuffer.vertexDeclaration;
                var positionOffset = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_POSITION0)._offset / 4;
                var normalElement = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_NORMAL0);
                var normalOffset = normalElement ? normalElement._offset / 4 : -1;
                var colorElement = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_COLOR0);
                var colorOffset = colorElement ? colorElement._offset / 4 : -1;
                var uv0Element = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_TEXTURECOORDINATE0);
                var uv0Offset = uv0Element ? uv0Element._offset / 4 : -1;
                var uv1Element = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_TEXTURECOORDINATE1);
                var uv1Offset = uv1Element ? uv1Element._offset / 4 : -1;
                var tangentElement = vertexDeclaration.getVertexElementByUsage(VertexMesh.MESH_TANGENT0);
                var sTangentOffset = tangentElement ? tangentElement._offset / 4 : -1;
                var bakeVertexFloatCount = 18;
                var oriVertexFloatCount = vertexDeclaration.vertexStride / 4;
                var oriVertexes = vertexBuffer.getFloat32Data();
                var worldMat;
                if (batchOwnerTransform) {
                    var rootMat = batchOwnerTransform.worldMatrix;
                    rootMat.invert(SubMeshStaticBatch._tempMatrix4x40);
                    worldMat = SubMeshStaticBatch._tempMatrix4x41;
                    Matrix4x4.multiply(SubMeshStaticBatch._tempMatrix4x40, transform.worldMatrix, worldMat);
                } else {
                    worldMat = transform.worldMatrix;
                }
                var normalMat = SubMeshStaticBatch._tempMatrix4x42;
                worldMat.invert(normalMat);
                normalMat.transpose();
                var rotation = SubMeshStaticBatch._tempQuaternion0;
                worldMat.decomposeTransRotScale(SubMeshStaticBatch._tempVector30, rotation, SubMeshStaticBatch._tempVector31);
                var lightmapScaleOffset = render.lightmapScaleOffset;
                var vertexCount = mesh.vertexCount;
                for (var i = 0; i < vertexCount; i++) {
                    var oriOffset = i * oriVertexFloatCount;
                    var bakeOffset = (i + batchOffset) * bakeVertexFloatCount;
                    Utils3D.transformVector3ArrayToVector3ArrayCoordinate(oriVertexes, oriOffset + positionOffset, worldMat, batchVertices, bakeOffset + 0);
                    if (normalOffset !== -1) Utils3D.transformVector3ArrayToVector3ArrayNormal(oriVertexes, oriOffset + normalOffset, normalMat, batchVertices, bakeOffset + 3);
                    var j, m;
                    var bakOff = bakeOffset + 6;
                    if (colorOffset !== -1) {
                        var oriOff = oriOffset + colorOffset;
                        for (j = 0, m = 4; j < m; j++) {
                            batchVertices[bakOff + j] = oriVertexes[oriOff + j];
                        }
                    } else {
                        for (j = 0, m = 4; j < m; j++) {
                            batchVertices[bakOff + j] = 1.0;
                        }
                    }
                    if (uv0Offset !== -1) {
                        var absUv0Offset = oriOffset + uv0Offset;
                        batchVertices[bakeOffset + 10] = oriVertexes[absUv0Offset];
                        batchVertices[bakeOffset + 11] = oriVertexes[absUv0Offset + 1];
                    }
                    if (lightmapScaleOffset) {
                        if (uv1Offset !== -1) Utils3D.transformLightingMapTexcoordArray(oriVertexes, oriOffset + uv1Offset, lightmapScaleOffset, batchVertices, bakeOffset + 12);
                        else Utils3D.transformLightingMapTexcoordArray(oriVertexes, oriOffset + uv0Offset, lightmapScaleOffset, batchVertices, bakeOffset + 12);
                    }
                    if (sTangentOffset !== -1) {
                        var absSTanegntOffset = oriOffset + sTangentOffset;
                        Utils3D.transformVector3ArrayToVector3ArrayNormal(oriVertexes, absSTanegntOffset, normalMat, batchVertices, bakeOffset + 14);
                        batchVertices[bakeOffset + 17] = oriVertexes[absSTanegntOffset + 3];
                    }
                }
                return vertexCount;
            }
        },
        {
            key: "addTest",
            value: function addTest(sprite) {
                var vertexCount;
                var subMeshVertexCount = sprite.meshFilter.sharedMesh.vertexCount;
                vertexCount = this._currentBatchVertexCount + subMeshVertexCount;
                if (vertexCount > SubMeshStaticBatch.maxBatchVertexCount) return false;
                return true;
            }
        },
        {
            key: "add",
            value: function add(sprite) {
                var mesh = sprite.meshFilter.sharedMesh;
                var subMeshVertexCount = mesh.vertexCount;
                this._batchElements.push(sprite);
                var render = sprite._render;
                render._isPartOfStaticBatch = true;
                render._staticBatch = this;
                var renderElements = render._renderElements;
                for (var i = 0,
                n = renderElements.length; i < n; i++) {
                    renderElements[i].staticBatch = this;
                }
                this._currentBatchIndexCount += mesh._indexBuffer.indexCount;
                this._currentBatchVertexCount += subMeshVertexCount;
            }
        },
        {
            key: "remove",
            value: function remove(sprite) {
                var mesh = sprite.meshFilter.sharedMesh;
                var index = this._batchElements.indexOf(sprite);
                if (index !== -1) {
                    this._batchElements.splice(index, 1);
                    var renderElements = sprite._render._renderElements;
                    for (var i = 0,
                    n = renderElements.length; i < n; i++) {
                        renderElements[i].staticBatch = null;
                    }
                    this._currentBatchIndexCount = this._currentBatchIndexCount - mesh._indexBuffer.indexCount;
                    this._currentBatchVertexCount = this._currentBatchVertexCount - mesh.vertexCount;
                    sprite._render._isPartOfStaticBatch = false;
                }
            }
        },
        {
            key: "finishInit",
            value: function finishInit() {
                if (this._vertexBuffer) {
                    this._vertexBuffer.destroy();
                    this._indexBuffer.destroy();
                    Laya.Resource._addGPUMemory( - (this._vertexBuffer._byteLength + this._indexBuffer._byteLength));
                }
                var gl = Laya.LayaGL.instance;
                var batchVertexCount = 0;
                var batchIndexCount = 0;
                var rootOwner = this.batchOwner;
                var floatStride = this._vertexDeclaration.vertexStride / 4;
                var vertexDatas = new Float32Array(floatStride * this._currentBatchVertexCount);
                var indexDatas = new Uint16Array(this._currentBatchIndexCount);
                this._vertexBuffer = new VertexBuffer3D(this._vertexDeclaration.vertexStride * this._currentBatchVertexCount, gl.STATIC_DRAW);
                this._vertexBuffer.vertexDeclaration = this._vertexDeclaration;
                this._indexBuffer = new IndexBuffer3D(exports.IndexFormat.UInt16, this._currentBatchIndexCount, gl.STATIC_DRAW);
                for (var i = 0,
                n = this._batchElements.length; i < n; i++) {
                    var sprite = this._batchElements[i];
                    var mesh = sprite.meshFilter.sharedMesh;
                    var meshVerCount = this._getStaticBatchBakedVertexs(vertexDatas, batchVertexCount, rootOwner ? rootOwner._transform: null, sprite._transform, sprite._render, mesh);
                    var indices = mesh._indexBuffer.getData();
                    var indexOffset = batchVertexCount;
                    var indexEnd = batchIndexCount + indices.length;
                    var elements = sprite._render._renderElements;
                    for (var j = 0,
                    m = mesh.subMeshCount; j < m; j++) {
                        var subMesh = mesh._subMeshes[j];
                        var start = batchIndexCount + subMesh._indexStart;
                        var element = elements[j];
                        element.staticBatchIndexStart = start;
                        element.staticBatchIndexEnd = start + subMesh._indexCount;
                    }
                    indexDatas.set(indices, batchIndexCount);
                    var k;
                    var isInvert = rootOwner ? sprite._transform._isFrontFaceInvert !== rootOwner.transform._isFrontFaceInvert: sprite._transform._isFrontFaceInvert;
                    if (isInvert) {
                        for (k = batchIndexCount; k < indexEnd; k += 3) {
                            indexDatas[k] = indexOffset + indexDatas[k];
                            var index1 = indexDatas[k + 1];
                            var index2 = indexDatas[k + 2];
                            indexDatas[k + 1] = indexOffset + index2;
                            indexDatas[k + 2] = indexOffset + index1;
                        }
                    } else {
                        for (k = batchIndexCount; k < indexEnd; k += 3) {
                            indexDatas[k] = indexOffset + indexDatas[k];
                            indexDatas[k + 1] = indexOffset + indexDatas[k + 1];
                            indexDatas[k + 2] = indexOffset + indexDatas[k + 2];
                        }
                    }
                    batchIndexCount += indices.length;
                    batchVertexCount += meshVerCount;
                }
                this._vertexBuffer.setData(vertexDatas.buffer);
                this._indexBuffer.setData(indexDatas);
                var memorySize = this._vertexBuffer._byteLength + this._indexBuffer._byteLength;
                Laya.Resource._addGPUMemory(memorySize);
                this._bufferState.bind();
                this._bufferState.applyVertexBuffer(this._vertexBuffer);
                this._bufferState.applyIndexBuffer(this._indexBuffer);
                this._bufferState.unBind();
            }
        },
        {
            key: "_render",
            value: function _render(state) {
                this._bufferState.bind();
                var gl = Laya.LayaGL.instance;
                var element = state.renderElement;
                var staticBatchElementList = element.staticBatchElementList;
                var batchElementList = staticBatchElementList.elements;
                var from = 0;
                var end = 0;
                var count = staticBatchElementList.length;
                for (var i = 1; i < count; i++) {
                    var lastElement = batchElementList[i - 1];
                    if (lastElement.staticBatchIndexEnd === batchElementList[i].staticBatchIndexStart) {
                        end++;
                        continue;
                    } else {
                        var start = batchElementList[from].staticBatchIndexStart;
                        var indexCount = batchElementList[end].staticBatchIndexEnd - start;
                        gl.drawElements(gl.TRIANGLES, indexCount, gl.UNSIGNED_SHORT, start * 2);
                        from = ++end;
                        Laya.Stat.trianglesFaces += indexCount / 3;
                    }
                }
                start = batchElementList[from].staticBatchIndexStart;
                indexCount = batchElementList[end].staticBatchIndexEnd - start;
                gl.drawElements(gl.TRIANGLES, indexCount, gl.UNSIGNED_SHORT, start * 2);
                Laya.Stat.renderBatches++;
                Laya.Stat.savedRenderBatches += count - 1;
                Laya.Stat.trianglesFaces += indexCount / 3;
            }
        },
        {
            key: "dispose",
            value: function dispose() {
                var memorySize = this._vertexBuffer._byteLength + this._indexBuffer._byteLength;
                Laya.Resource._addGPUMemory( - memorySize);
                this._batchElements = null;
                this.batchOwner = null;
                this._vertexDeclaration = null;
                this._bufferState.destroy();
                this._vertexBuffer.destroy();
                this._indexBuffer.destroy();
                this._vertexBuffer = null;
                this._indexBuffer = null;
                this._bufferState = null;
            }
        }]);
        return SubMeshStaticBatch;
    } (GeometryElement);
    SubMeshStaticBatch._tempVector30 = new Vector3();
    SubMeshStaticBatch._tempVector31 = new Vector3();
    SubMeshStaticBatch._tempQuaternion0 = new Quaternion();
    SubMeshStaticBatch._tempMatrix4x40 = new Matrix4x4();
    SubMeshStaticBatch._tempMatrix4x41 = new Matrix4x4();
    SubMeshStaticBatch._tempMatrix4x42 = new Matrix4x4();
    SubMeshStaticBatch.maxBatchVertexCount = 65535;
    SubMeshStaticBatch._batchIDCounter = 0;
    var MeshRenderStaticBatchManager =
    /*#__PURE__*/
    function(_StaticBatchManager) {
        _inherits(MeshRenderStaticBatchManager, _StaticBatchManager);
        var _super46 = _createSuper(MeshRenderStaticBatchManager);
        function MeshRenderStaticBatchManager() {
            var _this42;
            _classCallCheck(this, MeshRenderStaticBatchManager);
            _this42 = _super46.call(this);
            _this42._opaqueBatchMarks = [];
            _this42._updateCountMark = 0;
            return _this42;
        }
        _createClass(MeshRenderStaticBatchManager, [{
            key: "_compare",
            value: function _compare(left, right) {
                var lRender = left._render,
                rRender = right._render;
                var leftGeo = left.meshFilter.sharedMesh,
                rightGeo = right.meshFilter.sharedMesh;
                var lightOffset = lRender.lightmapIndex - rRender.lightmapIndex;
                if (lightOffset === 0) {
                    var receiveShadowOffset = (lRender.receiveShadow ? 1 : 0) - (rRender.receiveShadow ? 1 : 0);
                    if (receiveShadowOffset === 0) {
                        var materialOffset = lRender.sharedMaterial && rRender.sharedMaterial ? lRender.sharedMaterial.id - rRender.sharedMaterial.id: 0;
                        if (materialOffset === 0) {
                            var verDec = leftGeo._vertexBuffer.vertexDeclaration.id - rightGeo._vertexBuffer.vertexDeclaration.id;
                            if (verDec === 0) {
                                return rightGeo._indexBuffer.indexCount - leftGeo._indexBuffer.indexCount;
                            } else {
                                return verDec;
                            }
                        } else {
                            return materialOffset;
                        }
                    } else {
                        return receiveShadowOffset;
                    }
                } else {
                    return lightOffset;
                }
            }
        },
        {
            key: "_getBatchRenderElementFromPool",
            value: function _getBatchRenderElementFromPool() {
                var renderElement = this._batchRenderElementPool[this._batchRenderElementPoolIndex++];
                if (!renderElement) {
                    renderElement = new SubMeshRenderElement();
                    this._batchRenderElementPool[this._batchRenderElementPoolIndex - 1] = renderElement;
                    renderElement.staticBatchElementList = new SingletonList();
                }
                return renderElement;
            }
        },
        {
            key: "_getStaticBatch",
            value: function _getStaticBatch(staticBatches, rootOwner, number) {
                var subMeshStaticBatch = staticBatches[number];
                if (!subMeshStaticBatch) {
                    subMeshStaticBatch = staticBatches[number] = new SubMeshStaticBatch(rootOwner, MeshRenderStaticBatchManager._verDec);
                    this._staticBatches[subMeshStaticBatch._batchID] = subMeshStaticBatch;
                }
                return subMeshStaticBatch;
            }
        },
        {
            key: "_initStaticBatchs",
            value: function _initStaticBatchs(rootOwner) {
                var initBatchSprites = this._initBatchSprites;
                this._quickSort(initBatchSprites, 0, initBatchSprites.length - 1);
                var staticBatches = [];
                var lastCanMerage = false;
                var curStaticBatch;
                var batchNumber = 0;
                for (var i = 0,
                n = initBatchSprites.length; i < n; i++) {
                    var sprite = initBatchSprites[i];
                    if (lastCanMerage) {
                        if (curStaticBatch.addTest(sprite)) {
                            curStaticBatch.add(sprite);
                        } else {
                            lastCanMerage = false;
                            batchNumber++;
                        }
                    } else {
                        var lastIndex = n - 1;
                        if (i !== lastIndex) {
                            curStaticBatch = this._getStaticBatch(staticBatches, rootOwner, batchNumber);
                            curStaticBatch.add(sprite);
                            lastCanMerage = true;
                        }
                    }
                }
                for (i = 0, n = staticBatches.length; i < n; i++) {
                    var staticBatch = staticBatches[i];
                    staticBatch && staticBatch.finishInit();
                }
                this._initBatchSprites.length = 0;
            }
        },
        {
            key: "_removeRenderSprite",
            value: function _removeRenderSprite(sprite) {
                var render = sprite._render;
                var staticBatch = render._staticBatch;
                var batchElements = staticBatch._batchElements;
                var index = batchElements.indexOf(sprite);
                if (index !== -1) {
                    batchElements.splice(index, 1);
                    render._staticBatch = null;
                    var renderElements = render._renderElements;
                    for (var i = 0,
                    n = renderElements.length; i < n; i++) {
                        renderElements[i].staticBatch = null;
                    }
                }
                if (batchElements.length === 0) {
                    delete this._staticBatches[staticBatch._batchID];
                    staticBatch.dispose();
                }
            }
        },
        {
            key: "_clear",
            value: function _clear() {
                _get(_getPrototypeOf(MeshRenderStaticBatchManager.prototype), "_clear", this).call(this);
                this._updateCountMark++;
            }
        },
        {
            key: "_garbageCollection",
            value: function _garbageCollection() {
                for (var key in this._staticBatches) {
                    var staticBatch = this._staticBatches[key];
                    if (staticBatch._batchElements.length === 0) {
                        staticBatch.dispose();
                        delete this._staticBatches[key];
                    }
                }
            }
        },
        {
            key: "getBatchOpaquaMark",
            value: function getBatchOpaquaMark(lightMapIndex, receiveShadow, materialID, staticBatchID) {
                var receiveShadowIndex = receiveShadow ? 1 : 0;
                var staLightMapMarks = this._opaqueBatchMarks[lightMapIndex] || (this._opaqueBatchMarks[lightMapIndex] = []);
                var staReceiveShadowMarks = staLightMapMarks[receiveShadowIndex] || (staLightMapMarks[receiveShadowIndex] = []);
                var staMaterialMarks = staReceiveShadowMarks[materialID] || (staReceiveShadowMarks[materialID] = []);
                return staMaterialMarks[staticBatchID] || (staMaterialMarks[staticBatchID] = new BatchMark());
            }
        }], [{
            key: "__init__",
            value: function __init__() {
                MeshRenderStaticBatchManager._verDec = VertexMesh.getVertexDeclaration("POSITION,NORMAL,COLOR,UV,UV1,TANGENT");
            }
        }]);
        return MeshRenderStaticBatchManager;
    } (StaticBatchManager);
    MeshRenderStaticBatchManager.instance = new MeshRenderStaticBatchManager(); (function(ReflectionProbeMode) {
        ReflectionProbeMode[ReflectionProbeMode["off"] = 0] = "off";
        ReflectionProbeMode[ReflectionProbeMode["simple"] = 1] = "simple";
    })(exports.ReflectionProbeMode || (exports.ReflectionProbeMode = {}));
    var ReflectionProbe =
    /*#__PURE__*/
    function(_Sprite3D4) {
        _inherits(ReflectionProbe, _Sprite3D4);
        var _super47 = _createSuper(ReflectionProbe);
        function ReflectionProbe() {
            var _this43;
            _classCallCheck(this, ReflectionProbe);
            _this43 = _super47.call(this);
            _this43._boxProjection = false;
            _this43._size = new Vector3();
            _this43._offset = new Vector3();
            _this43._reflectionHDRParams = new Vector4();
            _this43._reflectionDecodeFormat = Laya.TextureDecodeFormat.Normal;
            _this43._isScene = false;
            return _this43;
        }
        _createClass(ReflectionProbe, [{
            key: "boxProjection",
            get: function get() {
                return this._boxProjection;
            },
            set: function set(value) {
                this._boxProjection = value;
            }
        },
        {
            key: "importance",
            get: function get() {
                return this._importance;
            },
            set: function set(value) {
                this._importance = value;
            }
        },
        {
            key: "intensity",
            get: function get() {
                return this._intensity;
            },
            set: function set(value) {
                value = Math.max(Math.min(value, 1.0), 0.0);
                this._reflectionHDRParams.x = value;
                if (this._reflectionDecodeFormat == Laya.TextureDecodeFormat.RGBM) this._reflectionHDRParams.x *= 5.0;
                this._intensity = value;
            }
        },
        {
            key: "reflectionTexture",
            get: function get() {
                return this._reflectionTexture;
            },
            set: function set(value) {
                this._reflectionTexture = value;
                this._reflectionTexture._addReference();
            }
        },
        {
            key: "bounds",
            get: function get() {
                return this._bounds;
            },
            set: function set(value) {
                this._bounds = value;
            }
        },
        {
            key: "boundsMax",
            get: function get() {
                return this._bounds.getMax();
            }
        },
        {
            key: "boundsMin",
            get: function get() {
                return this._bounds.getMin();
            }
        },
        {
            key: "probePosition",
            get: function get() {
                return this.transform.position;
            }
        },
        {
            key: "reflectionHDRParams",
            get: function get() {
                return this._reflectionHDRParams;
            },
            set: function set(value) {
                this._reflectionHDRParams = value;
            }
        },
        {
            key: "_parse",
            value: function _parse(data, spriteMap) {
                _get(_getPrototypeOf(ReflectionProbe.prototype), "_parse", this).call(this, data, spriteMap);
                this._boxProjection = data.boxProjection;
                this._importance = data.importance;
                this._reflectionTexture = Laya.Loader.getRes(data.reflection);
                var position = this.transform.position;
                this._size.fromArray(data.boxSize);
                Vector3.scale(this._size, 0.5, ReflectionProbe.TEMPVECTOR3);
                this._offset.fromArray(data.boxOffset);
                var min = new Vector3();
                var max = new Vector3();
                Vector3.add(position, ReflectionProbe.TEMPVECTOR3, max);
                Vector3.add(max, this._offset, max);
                Vector3.subtract(position, ReflectionProbe.TEMPVECTOR3, min);
                Vector3.add(min, this._offset, min);
                this._reflectionDecodeFormat = data.reflectionDecodingFormat;
                this.intensity = data.intensity;
                if (!this._bounds) this.bounds = new Bounds(min, max);
                else {
                    this._bounds.setMin(min);
                    this._bounds.setMax(max);
                }
            }
        },
        {
            key: "_setIndexInReflectionList",
            value: function _setIndexInReflectionList(value) {
                this._indexInReflectProbList = value;
            }
        },
        {
            key: "_getIndexInReflectionList",
            value: function _getIndexInReflectionList() {
                return this._indexInReflectProbList;
            }
        },
        {
            key: "_onActive",
            value: function _onActive() {
                _get(_getPrototypeOf(ReflectionProbe.prototype), "_onActive", this).call(this);
                if (this._reflectionTexture) this.scene._reflectionProbeManager.add(this);
            }
        },
        {
            key: "_onInActive",
            value: function _onInActive() {
                _get(_getPrototypeOf(ReflectionProbe.prototype), "_onInActive", this).call(this);
                if (this.reflectionTexture) this.scene._reflectionProbeManager.remove(this);
            }
        },
        {
            key: "destroy",
            value: function destroy() {
                var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                if (this.destroyed) return;
                _get(_getPrototypeOf(ReflectionProbe.prototype), "destroy", this).call(this, destroyChild);
                this._reflectionTexture && this._reflectionTexture._removeReference();
                this._reflectionTexture = null;
                this._bounds = null;
            }
        },
        {
            key: "_cloneTo",
            value: function _cloneTo(destObject, srcRoot, dstRoot) {
                var dest = destObject;
                dest.bounds = this.bounds;
                dest.boxProjection = this.boxProjection;
                dest.importance = this.importance;
                dest._size = this._size;
                dest._offset = this._offset;
                dest.intensity = this.intensity;
                dest.reflectionHDRParams = this.reflectionHDRParams;
                _get(_getPrototypeOf(ReflectionProbe.prototype), "_cloneTo", this).call(this, destObject, srcRoot, dstRoot);
            }
        }]);
        return ReflectionProbe;
    } (Sprite3D);
    ReflectionProbe.TEMPVECTOR3 = new Vector3();
    ReflectionProbe.defaultTextureHDRDecodeValues = new Vector4(1.0, 1.0, 0.0, 0.0);
    var BaseRender =
    /*#__PURE__*/
    function(_Laya$EventDispatcher3) {
        _inherits(BaseRender, _Laya$EventDispatcher3);
        var _super48 = _createSuper(BaseRender);
        function BaseRender(owner) {
            var _this44;
            _classCallCheck(this, BaseRender);
            _this44 = _super48.call(this);
            _this44._lightmapScaleOffset = new Vector4(1, 1, 0, 0);
            _this44._indexInList = -1;
            _this44._indexInCastShadowList = -1;
            _this44._boundsChange = true;
            _this44._castShadow = false;
            _this44._supportOctree = true;
            _this44._sharedMaterials = [];
            _this44._renderMark = -1;
            _this44._indexInOctreeMotionList = -1;
            _this44._reflectionMode = exports.ReflectionProbeMode.simple;
            _this44._sceneUpdateMark = -1;
            _this44._updateMark = -1;
            _this44._updateRenderType = -1;
            _this44._isPartOfStaticBatch = false;
            _this44._staticBatch = null;
            _this44._ratioIgnor = 0.005;
            _this44._id = ++BaseRender._uniqueIDCounter;
            _this44._indexInCastShadowList = -1;
            _this44._bounds = new Bounds(Vector3._ZERO, Vector3._ZERO);
            _this44._renderElements = [];
            _this44._owner = owner;
            _this44._enable = true;
            _this44._materialsInstance = [];
            _this44._shaderValues = new ShaderData(null);
            _this44.lightmapIndex = -1;
            _this44.receiveShadow = false;
            _this44.sortingFudge = 0.0;
            owner && _this44._owner.transform.on(Laya.Event.TRANSFORM_CHANGED, _assertThisInitialized(_this44), _this44._onWorldMatNeedChange);
            return _this44;
        }
        _createClass(BaseRender, [{
            key: "id",
            get: function get() {
                return this._id;
            }
        },
        {
            key: "ratioIgnor",
            get: function get() {
                return this._ratioIgnor;
            },
            set: function set(value) {
                this._ratioIgnor = value;
            }
        },
        {
            key: "lightmapIndex",
            get: function get() {
                return this._lightmapIndex;
            },
            set: function set(value) {
                this._lightmapIndex = value;
            }
        },
        {
            key: "lightmapScaleOffset",
            get: function get() {
                return this._lightmapScaleOffset;
            },
            set: function set(value) {
                if (!value) throw "BaseRender: lightmapScaleOffset can't be null.";
                this._lightmapScaleOffset = value;
                this._shaderValues.setVector(RenderableSprite3D.LIGHTMAPSCALEOFFSET, value);
            }
        },
        {
            key: "enable",
            get: function get() {
                return this._enable;
            },
            set: function set(value) {
                this._enable = !!value;
            }
        },
        {
            key: "material",
            get: function get() {
                var material = this._sharedMaterials[0];
                if (material && !this._materialsInstance[0]) {
                    var insMat = this._getInstanceMaterial(material, 0);
                    var renderElement = this._renderElements[0];
                    renderElement && (renderElement.material = insMat);
                }
                return this._sharedMaterials[0];
            },
            set: function set(value) {
                this.sharedMaterial = value;
                this._isSupportReflection();
            }
        },
        {
            key: "materials",
            get: function get() {
                for (var i = 0,
                n = this._sharedMaterials.length; i < n; i++) {
                    if (!this._materialsInstance[i]) {
                        var insMat = this._getInstanceMaterial(this._sharedMaterials[i], i);
                        var renderElement = this._renderElements[i];
                        renderElement && (renderElement.material = insMat);
                    }
                }
                return this._sharedMaterials.slice();
            },
            set: function set(value) {
                this.sharedMaterials = value;
                this._isSupportReflection();
            }
        },
        {
            key: "sharedMaterial",
            get: function get() {
                return this._sharedMaterials[0];
            },
            set: function set(value) {
                var lastValue = this._sharedMaterials[0];
                if (lastValue !== value) {
                    this._sharedMaterials[0] = value;
                    this._materialsInstance[0] = false;
                    this._changeMaterialReference(lastValue, value);
                    var renderElement = this._renderElements[0];
                    renderElement && (renderElement.material = value);
                }
                this._isSupportReflection();
            }
        },
        {
            key: "sharedMaterials",
            get: function get() {
                return this._sharedMaterials.slice();
            },
            set: function set(value) {
                var materialsInstance = this._materialsInstance;
                var sharedMats = this._sharedMaterials;
                for (var i = 0,
                n = sharedMats.length; i < n; i++) {
                    var lastMat = sharedMats[i];
                    lastMat && lastMat._removeReference();
                }
                if (value) {
                    var count = value.length;
                    materialsInstance.length = count;
                    sharedMats.length = count;
                    for (i = 0; i < count; i++) {
                        lastMat = sharedMats[i];
                        var mat = value[i];
                        if (lastMat !== mat) {
                            materialsInstance[i] = false;
                            var renderElement = this._renderElements[i];
                            renderElement && (renderElement.material = mat);
                        }
                        if (mat) {
                            mat._addReference();
                        }
                        sharedMats[i] = mat;
                    }
                } else {
                    throw new Error("BaseRender: shadredMaterials value can't be null.");
                }
                this._isSupportReflection();
            }
        },
        {
            key: "bounds",
            get: function get() {
                if (this._boundsChange) {
                    this._calculateBoundingBox();
                    this._boundsChange = false;
                }
                return this._bounds;
            }
        },
        {
            key: "receiveShadow",
            get: function get() {
                return this._receiveShadow;
            },
            set: function set(value) {
                if (this._receiveShadow !== value) {
                    this._receiveShadow = value;
                    if (value) this._shaderValues.addDefine(RenderableSprite3D.SHADERDEFINE_RECEIVE_SHADOW);
                    else this._shaderValues.removeDefine(RenderableSprite3D.SHADERDEFINE_RECEIVE_SHADOW);
                }
            }
        },
        {
            key: "castShadow",
            get: function get() {
                return this._castShadow;
            },
            set: function set(value) {
                this._castShadow = value;
            }
        },
        {
            key: "isPartOfStaticBatch",
            get: function get() {
                return this._isPartOfStaticBatch;
            }
        },
        {
            key: "isRender",
            get: function get() {
                return this._renderMark == -1 || this._renderMark == Laya.Stat.loopCount - 1;
            }
        },
        {
            key: "reflectionMode",
            get: function get() {
                return this._reflectionMode;
            },
            set: function set(value) {
                this._reflectionMode = value;
            }
        },
        {
            key: "_getOctreeNode",
            value: function _getOctreeNode() {
                return this._octreeNode;
            }
        },
        {
            key: "_setOctreeNode",
            value: function _setOctreeNode(value) {
                if (!value) {
                    this._indexInOctreeMotionList !== -1 && this._octreeNode.getManagerNode().removeMotionObject(this);
                }
                this._octreeNode = value;
            }
        },
        {
            key: "_getIndexInMotionList",
            value: function _getIndexInMotionList() {
                return this._indexInOctreeMotionList;
            }
        },
        {
            key: "_setIndexInMotionList",
            value: function _setIndexInMotionList(value) {
                this._indexInOctreeMotionList = value;
            }
        },
        {
            key: "_changeMaterialReference",
            value: function _changeMaterialReference(lastValue, value) {
                lastValue && lastValue._removeReference();
                value._addReference();
            }
        },
        {
            key: "_getInstanceMaterial",
            value: function _getInstanceMaterial(material, index) {
                var insMat = material.clone();
                insMat.name = insMat.name + "(Instance)";
                this._materialsInstance[index] = true;
                this._changeMaterialReference(this._sharedMaterials[index], insMat);
                this._sharedMaterials[index] = insMat;
                return insMat;
            }
        },
        {
            key: "_isSupportReflection",
            value: function _isSupportReflection() {
                this._surportReflectionProbe = false;
                var sharedMats = this._sharedMaterials;
                for (var i = 0,
                n = sharedMats.length; i < n; i++) {
                    var mat = sharedMats[i];
                    this._surportReflectionProbe = this._surportReflectionProbe || mat && mat._shader._supportReflectionProbe;
                }
            }
        },
        {
            key: "_addReflectionProbeUpdate",
            value: function _addReflectionProbeUpdate() {
                if (this._surportReflectionProbe && this._reflectionMode == 1) {
                    this._scene && this._scene._reflectionProbeManager.addMotionObject(this);
                }
            }
        },
        {
            key: "_applyLightMapParams",
            value: function _applyLightMapParams() {
                var lightMaps = this._scene.lightmaps;
                var shaderValues = this._shaderValues;
                var lightmapIndex = this._lightmapIndex;
                if (lightmapIndex >= 0 && lightmapIndex < lightMaps.length) {
                    var lightMap = lightMaps[lightmapIndex];
                    shaderValues.setTexture(RenderableSprite3D.LIGHTMAP, lightMap.lightmapColor);
                    shaderValues.addDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
                    if (lightMap.lightmapDirection) {
                        shaderValues.setTexture(RenderableSprite3D.LIGHTMAP_DIRECTION, lightMap.lightmapDirection);
                        shaderValues.addDefine(RenderableSprite3D.SHADERDEFINE_LIGHTMAP_DIRECTIONAL);
                    } else {
                        shaderValues.removeDefine(RenderableSprite3D.SHADERDEFINE_LIGHTMAP_DIRECTIONAL);
                    }
                } else {
                    shaderValues.removeDefine(RenderableSprite3D.SAHDERDEFINE_LIGHTMAP);
                    shaderValues.removeDefine(RenderableSprite3D.SHADERDEFINE_LIGHTMAP_DIRECTIONAL);
                }
            }
        },
        {
            key: "_onWorldMatNeedChange",
            value: function _onWorldMatNeedChange(flag) {
                this._boundsChange = true;
                if (this._octreeNode) {
                    flag &= Transform3D.TRANSFORM_WORLDPOSITION | Transform3D.TRANSFORM_WORLDQUATERNION | Transform3D.TRANSFORM_WORLDSCALE;
                    if (flag) {
                        if (this._indexInOctreeMotionList === -1) this._octreeNode.getManagerNode().addMotionObject(this);
                    }
                }
                this._addReflectionProbeUpdate();
            }
        },
        {
            key: "_calculateBoundingBox",
            value: function _calculateBoundingBox() {
                throw "BaseRender: must override it.";
            }
        },
        {
            key: "_getIndexInList",
            value: function _getIndexInList() {
                return this._indexInList;
            }
        },
        {
            key: "_setIndexInList",
            value: function _setIndexInList(index) {
                this._indexInList = index;
            }
        },
        {
            key: "_setBelongScene",
            value: function _setBelongScene(scene) {
                this._scene = scene;
            }
        },
        {
            key: "_setUnBelongScene",
            value: function _setUnBelongScene() {
                this._scene = null;
            }
        },
        {
            key: "_needRender",
            value: function _needRender(boundFrustum, context) {
                return true;
            }
        },
        {
            key: "_OctreeNoRender",
            value: function _OctreeNoRender() {}
        },
        {
            key: "_renderUpdate",
            value: function _renderUpdate(context, transform) {}
        },
        {
            key: "_renderUpdateWithCamera",
            value: function _renderUpdateWithCamera(context, transform) {}
        },
        {
            key: "_revertBatchRenderUpdate",
            value: function _revertBatchRenderUpdate(context) {}
        },
        {
            key: "_destroy",
            value: function _destroy() {
                this._indexInOctreeMotionList !== -1 && this._octreeNode.getManagerNode().removeMotionObject(this);
                this.offAll();
                var i = 0,
                n = 0;
                for (i = 0, n = this._renderElements.length; i < n; i++) {
                    this._renderElements[i].destroy();
                }
                for (i = 0, n = this._sharedMaterials.length; i < n; i++) {
                    this._sharedMaterials[i].destroyed || this._sharedMaterials[i]._removeReference();
                }
                this._renderElements = null;
                this._owner = null;
                this._sharedMaterials = null;
                this._bounds = null;
                this._lightmapScaleOffset = null;
                this._scene = null;
            }
        },
        {
            key: "markAsUnStatic",
            value: function markAsUnStatic() {
                if (this._isPartOfStaticBatch) {
                    MeshRenderStaticBatchManager.instance._removeRenderSprite(this._owner);
                    this._isPartOfStaticBatch = false;
                }
            }
        }]);
        return BaseRender;
    } (Laya.EventDispatcher);
    BaseRender._tempBoundBoxCorners = [new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3()];
    BaseRender._uniqueIDCounter = 0;
    BaseRender._defaultLightmapScaleOffset = new Vector4(1.0, 1.0, 0.0, 0.0);
    var PixelLineRenderer =
    /*#__PURE__*/
    function(_BaseRender) {
        _inherits(PixelLineRenderer, _BaseRender);
        var _super49 = _createSuper(PixelLineRenderer);
        function PixelLineRenderer(owner) {
            var _this45;
            _classCallCheck(this, PixelLineRenderer);
            _this45 = _super49.call(this, owner);
            _this45._projectionViewWorldMatrix = new Matrix4x4();
            return _this45;
        }
        _createClass(PixelLineRenderer, [{
            key: "_calculateBoundingBox",
            value: function _calculateBoundingBox() {
                var worldMat = this._owner.transform.worldMatrix;
                var lineFilter = this._owner._geometryFilter;
                lineFilter._reCalculateBound();
                lineFilter._bounds._tranform(worldMat, this._bounds);
            }
        },
        {
            key: "_renderUpdateWithCamera",
            value: function _renderUpdateWithCamera(context, transform) {
                var projectionView = context.projectionViewMatrix;
                var sv = this._shaderValues;
                if (transform) {
                    var worldMat = transform.worldMatrix;
                    sv.setMatrix4x4(Sprite3D.WORLDMATRIX, worldMat);
                    Matrix4x4.multiply(projectionView, worldMat, this._projectionViewWorldMatrix);
                    sv.setMatrix4x4(Sprite3D.MVPMATRIX, this._projectionViewWorldMatrix);
                } else {
                    sv.setMatrix4x4(Sprite3D.WORLDMATRIX, Matrix4x4.DEFAULT);
                    sv.setMatrix4x4(Sprite3D.MVPMATRIX, projectionView);
                }
            }
        }]);
        return PixelLineRenderer;
    } (BaseRender);
    var PixelLineSprite3D =
    /*#__PURE__*/
    function(_RenderableSprite3D) {
        _inherits(PixelLineSprite3D, _RenderableSprite3D);
        var _super50 = _createSuper(PixelLineSprite3D);
        function PixelLineSprite3D() {
            var _this46;
            var maxCount = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 2;
            var name = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
            _classCallCheck(this, PixelLineSprite3D);
            _this46 = _super50.call(this, name);
            _this46._isRenderActive = false;
            _this46._isInRenders = false;
            _this46._geometryFilter = new PixelLineFilter(_assertThisInitialized(_this46), maxCount);
            _this46._render = new PixelLineRenderer(_assertThisInitialized(_this46));
            _this46._changeRenderObjects(0, PixelLineMaterial.defaultMaterial);
            return _this46;
        }
        _createClass(PixelLineSprite3D, [{
            key: "maxLineCount",
            get: function get() {
                return this._geometryFilter._maxLineCount;
            },
            set: function set(value) {
                this._geometryFilter._resizeLineData(value);
                this._geometryFilter._lineCount = Math.min(this._geometryFilter._lineCount, value);
            }
        },
        {
            key: "lineCount",
            get: function get() {
                return this._geometryFilter._lineCount;
            },
            set: function set(value) {
                if (value > this.maxLineCount) throw "PixelLineSprite3D: lineCount can't large than maxLineCount";
                else this._geometryFilter._lineCount = value;
            }
        },
        {
            key: "pixelLineRenderer",
            get: function get() {
                return this._render;
            }
        },
        {
            key: "_onI