/*
 * @Author: yad.com
 * @Date: 2022-06-14 22:11:40
 * @LastEditors: Kane
 * @LastEditTime: 2022-06-15 13:50:53
 * @FilePath: \Boom-Kart-3d\bin\libs\laya.core.js
 */
function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
        return typeof obj;
    }
        : function (obj) {
            return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        }
        ,
        _typeof(obj);
}
function _get() {
    if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
    } else {
        _get = function _get(target, property, receiver) {
            var base = _superPropBase(target, property);
            if (!base)
                return;
            var desc = Object.getOwnPropertyDescriptor(base, property);
            if (desc.get) {
                return desc.get.call(arguments.length < 3 ? target : receiver);
            }
            return desc.value;
        }
            ;
    }
    return _get.apply(this, arguments);
}
function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);
        if (object === null)
            break;
    }
    return object;
}
function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
        constructor: {
            value: subClass,
            writable: true,
            configurable: true
        }
    });
    Object.defineProperty(subClass, "prototype", {
        writable: false
    });
    if (superClass)
        _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;
        return o;
    }
        ;
    return _setPrototypeOf(o, p);
}
function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
        var Super = _getPrototypeOf(Derived), result;
        if (hasNativeReflectConstruct) {
            var NewTarget = _getPrototypeOf(this).constructor;
            result = Reflect.construct(Super, arguments, NewTarget);
        } else {
            result = Super.apply(this, arguments);
        }
        return _possibleConstructorReturn(this, result);
    }
        ;
}
function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
    } else if (call !== void 0) {
        throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized(self);
}
function _assertThisInitialized(self) {
    if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
}
function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
        return false;
    if (Reflect.construct.sham)
        return false;
    if (typeof Proxy === "function")
        return true;
    try {
        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () { }));
        return true;
    } catch (e) {
        return false;
    }
}
function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
    }
        ;
    return _getPrototypeOf(o);
}
function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
            descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}
function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
    if (staticProps)
        _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
        writable: false
    });
    return Constructor;
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
window.Laya = function (exports) {
    'use strict';
    var Config = /*#__PURE__*/
        _createClass(function Config() {
            _classCallCheck(this, Config);
        });
    Config.animationInterval = 50;
    Config.isAntialias = false;
    Config.isAlpha = false;
    Config.premultipliedAlpha = true;
    Config.isStencil = true;
    Config.preserveDrawingBuffer = false;
    Config.webGL2D_MeshAllocMaxMem = true;
    Config.is2DPixelArtGame = false;
    Config.useWebGL2 = true;
    Config.allowGPUInstanceDynamicBatch = true;
    Config.useRetinalCanvas = false;
    window.Config = Config;
    var ILaya = /*#__PURE__*/
        function () {
            function ILaya() {
                _classCallCheck(this, ILaya);
            }
            _createClass(ILaya, null, [{
                key: "regClass",
                value: function regClass(c) {
                    ILaya.__classMap[c.name] = c;
                }
            }]);
            return ILaya;
        }();
    ILaya.Laya = null;
    ILaya.Timer = null;
    ILaya.WorkerLoader = null;
    ILaya.Dragging = null;
    ILaya.GraphicsBounds = null;
    ILaya.Sprite = null;
    ILaya.TextRender = null;
    ILaya.TextAtlas = null;
    ILaya.timer = null;
    ILaya.systemTimer = null;
    ILaya.startTimer = null;
    ILaya.updateTimer = null;
    ILaya.lateTimer = null;
    ILaya.physicsTimer = null;
    ILaya.stage = null;
    ILaya.Loader = null;
    ILaya.loader = null;
    ILaya.TTFLoader = null;
    ILaya.SoundManager = null;
    ILaya.WebAudioSound = null;
    ILaya.AudioSound = null;
    ILaya.ShaderCompile = null;
    ILaya.ClassUtils = null;
    ILaya.SceneUtils = null;
    ILaya.Context = null;
    ILaya.Render = null;
    ILaya.MouseManager = null;
    ILaya.Text = null;
    ILaya.Browser = null;
    ILaya.WebGL = null;
    ILaya.Pool = null;
    ILaya.Utils = null;
    ILaya.Graphics = null;
    ILaya.Submit = null;
    ILaya.Stage = null;
    ILaya.Resource = null;
    ILaya.__classMap = {};
    var Pool = /*#__PURE__*/
        function () {
            function Pool() {
                _classCallCheck(this, Pool);
            }
            _createClass(Pool, null, [{
                key: "getPoolBySign",
                value: function getPoolBySign(sign) {
                    return Pool._poolDic[sign] || (Pool._poolDic[sign] = []);
                }
            }, {
                key: "clearBySign",
                value: function clearBySign(sign) {
                    if (Pool._poolDic[sign])
                        Pool._poolDic[sign].length = 0;
                }
            }, {
                key: "recover",
                value: function recover(sign, item) {
                    if (item[Pool.POOLSIGN])
                        return;
                    item[Pool.POOLSIGN] = true;
                    Pool.getPoolBySign(sign).push(item);
                }
            }, {
                key: "recoverByClass",
                value: function recoverByClass(instance) {
                    if (instance) {
                        var className = instance["__className"] || instance.constructor._$gid;
                        if (className)
                            Pool.recover(className, instance);
                    }
                }
            }, {
                key: "_getClassSign",
                value: function _getClassSign(cla) {
                    var className = cla["__className"] || cla["_$gid"];
                    if (!className) {
                        cla["_$gid"] = className = Pool._CLSID + "";
                        Pool._CLSID++;
                    }
                    return className;
                }
            }, {
                key: "createByClass",
                value: function createByClass(cls) {
                    return Pool.getItemByClass(Pool._getClassSign(cls), cls);
                }
            }, {
                key: "getItemByClass",
                value: function getItemByClass(sign, cls) {
                    if (!Pool._poolDic[sign])
                        return new cls();
                    var pool = Pool.getPoolBySign(sign);
                    if (pool.length) {
                        var rst = pool.pop();
                        rst[Pool.POOLSIGN] = false;
                    } else {
                        rst = new cls();
                    }
                    return rst;
                }
            }, {
                key: "getItemByCreateFun",
                value: function getItemByCreateFun(sign, createFun) {
                    var caller = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var pool = Pool.getPoolBySign(sign);
                    var rst = pool.length ? pool.pop() : createFun.call(caller);
                    rst[Pool.POOLSIGN] = false;
                    return rst;
                }
            }, {
                key: "getItem",
                value: function getItem(sign) {
                    var pool = Pool.getPoolBySign(sign);
                    var rst = pool.length ? pool.pop() : null;
                    if (rst) {
                        rst[Pool.POOLSIGN] = false;
                    }
                    return rst;
                }
            }]);
            return Pool;
        }();
    Pool._CLSID = 0;
    Pool.POOLSIGN = "__InPool";
    Pool._poolDic = {};
    var AlphaCmd = /*#__PURE__*/
        function () {
            function AlphaCmd() {
                _classCallCheck(this, AlphaCmd);
            }
            _createClass(AlphaCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("AlphaCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.alpha(this.alpha);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return AlphaCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(alpha) {
                    var cmd = Pool.getItemByClass("AlphaCmd", AlphaCmd);
                    cmd.alpha = alpha;
                    return cmd;
                }
            }]);
            return AlphaCmd;
        }();
    AlphaCmd.ID = "Alpha";
    var DrawCircleCmd = /*#__PURE__*/
        function () {
            function DrawCircleCmd() {
                _classCallCheck(this, DrawCircleCmd);
            }
            _createClass(DrawCircleCmd, [{
                key: "recover",
                value: function recover() {
                    this.fillColor = null;
                    this.lineColor = null;
                    Pool.recover("DrawCircleCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._drawCircle(this.x + gx, this.y + gy, this.radius, this.fillColor, this.lineColor, this.lineWidth, this.vid);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawCircleCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, radius, fillColor, lineColor, lineWidth, vid) {
                    var cmd = Pool.getItemByClass("DrawCircleCmd", DrawCircleCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.radius = radius;
                    cmd.fillColor = fillColor;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    cmd.vid = vid;
                    return cmd;
                }
            }]);
            return DrawCircleCmd;
        }();
    DrawCircleCmd.ID = "DrawCircle";
    var DrawCurvesCmd = /*#__PURE__*/
        function () {
            function DrawCurvesCmd() {
                _classCallCheck(this, DrawCurvesCmd);
            }
            _createClass(DrawCurvesCmd, [{
                key: "recover",
                value: function recover() {
                    this.points = null;
                    this.lineColor = null;
                    Pool.recover("DrawCurvesCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    if (this.points)
                        context.drawCurves(this.x + gx, this.y + gy, this.points, this.lineColor, this.lineWidth);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawCurvesCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, points, lineColor, lineWidth) {
                    var cmd = Pool.getItemByClass("DrawCurvesCmd", DrawCurvesCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.points = points;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    return cmd;
                }
            }]);
            return DrawCurvesCmd;
        }();
    DrawCurvesCmd.ID = "DrawCurves";
    var DrawImageCmd = /*#__PURE__*/
        function () {
            function DrawImageCmd() {
                _classCallCheck(this, DrawImageCmd);
            }
            _createClass(DrawImageCmd, [{
                key: "recover",
                value: function recover() {
                    this.texture && this.texture._removeReference();
                    this.texture = null;
                    Pool.recover("DrawImageCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    if (this.texture)
                        context.drawTexture(this.texture, this.x + gx, this.y + gy, this.width, this.height);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawImageCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, x, y, width, height) {
                    var cmd = Pool.getItemByClass("DrawImageCmd", DrawImageCmd);
                    cmd.texture = texture;
                    texture._addReference();
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    return cmd;
                }
            }]);
            return DrawImageCmd;
        }();
    DrawImageCmd.ID = "DrawImage";
    var DrawLineCmd = /*#__PURE__*/
        function () {
            function DrawLineCmd() {
                _classCallCheck(this, DrawLineCmd);
            }
            _createClass(DrawLineCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("DrawLineCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._drawLine(gx, gy, this.fromX, this.fromY, this.toX, this.toY, this.lineColor, this.lineWidth, this.vid);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawLineCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(fromX, fromY, toX, toY, lineColor, lineWidth, vid) {
                    var cmd = Pool.getItemByClass("DrawLineCmd", DrawLineCmd);
                    cmd.fromX = fromX;
                    cmd.fromY = fromY;
                    cmd.toX = toX;
                    cmd.toY = toY;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    cmd.vid = vid;
                    return cmd;
                }
            }]);
            return DrawLineCmd;
        }();
    DrawLineCmd.ID = "DrawLine";
    var DrawLinesCmd = /*#__PURE__*/
        function () {
            function DrawLinesCmd() {
                _classCallCheck(this, DrawLinesCmd);
            }
            _createClass(DrawLinesCmd, [{
                key: "recover",
                value: function recover() {
                    this.points = null;
                    this.lineColor = null;
                    Pool.recover("DrawLinesCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    this.points && context._drawLines(this.x + gx, this.y + gy, this.points, this.lineColor, this.lineWidth, this.vid);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawLinesCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, points, lineColor, lineWidth, vid) {
                    var cmd = Pool.getItemByClass("DrawLinesCmd", DrawLinesCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.points = points;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    cmd.vid = vid;
                    return cmd;
                }
            }]);
            return DrawLinesCmd;
        }();
    DrawLinesCmd.ID = "DrawLines";
    var DrawPathCmd = /*#__PURE__*/
        function () {
            function DrawPathCmd() {
                _classCallCheck(this, DrawPathCmd);
            }
            _createClass(DrawPathCmd, [{
                key: "recover",
                value: function recover() {
                    this.paths = null;
                    this.brush = null;
                    this.pen = null;
                    Pool.recover("DrawPathCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    this.paths && context._drawPath(this.x + gx, this.y + gy, this.paths, this.brush, this.pen);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawPathCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, paths, brush, pen) {
                    var cmd = Pool.getItemByClass("DrawPathCmd", DrawPathCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.paths = paths;
                    cmd.brush = brush;
                    cmd.pen = pen;
                    return cmd;
                }
            }]);
            return DrawPathCmd;
        }();
    DrawPathCmd.ID = "DrawPath";
    var DrawPieCmd = /*#__PURE__*/
        function () {
            function DrawPieCmd() {
                _classCallCheck(this, DrawPieCmd);
            }
            _createClass(DrawPieCmd, [{
                key: "recover",
                value: function recover() {
                    this.fillColor = null;
                    this.lineColor = null;
                    Pool.recover("DrawPieCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._drawPie(this.x + gx, this.y + gy, this.radius, this._startAngle, this._endAngle, this.fillColor, this.lineColor, this.lineWidth, this.vid);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawPieCmd.ID;
                }
            }, {
                key: "startAngle",
                get: function get() {
                    return this._startAngle * 180 / Math.PI;
                },
                set: function set(value) {
                    this._startAngle = value * Math.PI / 180;
                }
            }, {
                key: "endAngle",
                get: function get() {
                    return this._endAngle * 180 / Math.PI;
                },
                set: function set(value) {
                    this._endAngle = value * Math.PI / 180;
                }
            }], [{
                key: "create",
                value: function create(x, y, radius, startAngle, endAngle, fillColor, lineColor, lineWidth, vid) {
                    var cmd = Pool.getItemByClass("DrawPieCmd", DrawPieCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.radius = radius;
                    cmd._startAngle = startAngle;
                    cmd._endAngle = endAngle;
                    cmd.fillColor = fillColor;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    cmd.vid = vid;
                    return cmd;
                }
            }]);
            return DrawPieCmd;
        }();
    DrawPieCmd.ID = "DrawPie";
    var DrawPolyCmd = /*#__PURE__*/
        function () {
            function DrawPolyCmd() {
                _classCallCheck(this, DrawPolyCmd);
            }
            _createClass(DrawPolyCmd, [{
                key: "recover",
                value: function recover() {
                    this.points = null;
                    this.fillColor = null;
                    this.lineColor = null;
                    Pool.recover("DrawPolyCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    this.points && context._drawPoly(this.x + gx, this.y + gy, this.points, this.fillColor, this.lineColor, this.lineWidth, this.isConvexPolygon, this.vid);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawPolyCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, points, fillColor, lineColor, lineWidth, isConvexPolygon, vid) {
                    var cmd = Pool.getItemByClass("DrawPolyCmd", DrawPolyCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.points = points;
                    cmd.fillColor = fillColor;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    cmd.isConvexPolygon = isConvexPolygon;
                    cmd.vid = vid;
                    return cmd;
                }
            }]);
            return DrawPolyCmd;
        }();
    DrawPolyCmd.ID = "DrawPoly";
    var DrawRectCmd = /*#__PURE__*/
        function () {
            function DrawRectCmd() {
                _classCallCheck(this, DrawRectCmd);
            }
            _createClass(DrawRectCmd, [{
                key: "recover",
                value: function recover() {
                    this.fillColor = null;
                    this.lineColor = null;
                    Pool.recover("DrawRectCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.drawRect(this.x + gx, this.y + gy, this.width, this.height, this.fillColor, this.lineColor, this.lineWidth);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawRectCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, width, height, fillColor, lineColor, lineWidth) {
                    var cmd = Pool.getItemByClass("DrawRectCmd", DrawRectCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    cmd.fillColor = fillColor;
                    cmd.lineColor = lineColor;
                    cmd.lineWidth = lineWidth;
                    return cmd;
                }
            }]);
            return DrawRectCmd;
        }();
    DrawRectCmd.ID = "DrawRect";
    var Matrix = /*#__PURE__*/
        function () {
            function Matrix() {
                var a = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                var b = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var c = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var d = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
                var tx = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                var ty = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                var nums = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
                _classCallCheck(this, Matrix);
                this._bTransform = false;
                if (Matrix._createFun != null) {
                    return Matrix._createFun(a, b, c, d, tx, ty, nums);
                }
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
                this.tx = tx;
                this.ty = ty;
                this._checkTransform();
            }
            _createClass(Matrix, [{
                key: "identity",
                value: function identity() {
                    this.a = this.d = 1;
                    this.b = this.tx = this.ty = this.c = 0;
                    this._bTransform = false;
                    return this;
                }
            }, {
                key: "_checkTransform",
                value: function _checkTransform() {
                    return this._bTransform = this.a !== 1 || this.b !== 0 || this.c !== 0 || this.d !== 1;
                }
            }, {
                key: "setTranslate",
                value: function setTranslate(x, y) {
                    this.tx = x;
                    this.ty = y;
                    return this;
                }
            }, {
                key: "translate",
                value: function translate(x, y) {
                    this.tx += x;
                    this.ty += y;
                    return this;
                }
            }, {
                key: "scale",
                value: function scale(x, y) {
                    this.a *= x;
                    this.d *= y;
                    this.c *= x;
                    this.b *= y;
                    this.tx *= x;
                    this.ty *= y;
                    this._bTransform = true;
                    return this;
                }
            }, {
                key: "rotate",
                value: function rotate(angle) {
                    var cos = Math.cos(angle);
                    var sin = Math.sin(angle);
                    var a1 = this.a;
                    var c1 = this.c;
                    var tx1 = this.tx;
                    this.a = a1 * cos - this.b * sin;
                    this.b = a1 * sin + this.b * cos;
                    this.c = c1 * cos - this.d * sin;
                    this.d = c1 * sin + this.d * cos;
                    this.tx = tx1 * cos - this.ty * sin;
                    this.ty = tx1 * sin + this.ty * cos;
                    this._bTransform = true;
                    return this;
                }
            }, {
                key: "skew",
                value: function skew(x, y) {
                    var tanX = Math.tan(x);
                    var tanY = Math.tan(y);
                    var a1 = this.a;
                    var b1 = this.b;
                    this.a += tanY * this.c;
                    this.b += tanY * this.d;
                    this.c += tanX * a1;
                    this.d += tanX * b1;
                    return this;
                }
            }, {
                key: "invertTransformPoint",
                value: function invertTransformPoint(out) {
                    var a1 = this.a;
                    var b1 = this.b;
                    var c1 = this.c;
                    var d1 = this.d;
                    var tx1 = this.tx;
                    var n = a1 * d1 - b1 * c1;
                    var a2 = d1 / n;
                    var b2 = -b1 / n;
                    var c2 = -c1 / n;
                    var d2 = a1 / n;
                    var tx2 = (c1 * this.ty - d1 * tx1) / n;
                    var ty2 = -(a1 * this.ty - b1 * tx1) / n;
                    return out.setTo(a2 * out.x + c2 * out.y + tx2, b2 * out.x + d2 * out.y + ty2);
                }
            }, {
                key: "transformPoint",
                value: function transformPoint(out) {
                    return out.setTo(this.a * out.x + this.c * out.y + this.tx, this.b * out.x + this.d * out.y + this.ty);
                }
            }, {
                key: "transformPointN",
                value: function transformPointN(out) {
                    return out.setTo(this.a * out.x + this.c * out.y, this.b * out.x + this.d * out.y);
                }
            }, {
                key: "getScaleX",
                value: function getScaleX() {
                    return this.b === 0 ? this.a : Math.sqrt(this.a * this.a + this.b * this.b);
                }
            }, {
                key: "getScaleY",
                value: function getScaleY() {
                    return this.c === 0 ? this.d : Math.sqrt(this.c * this.c + this.d * this.d);
                }
            }, {
                key: "invert",
                value: function invert() {
                    var a1 = this.a;
                    var b1 = this.b;
                    var c1 = this.c;
                    var d1 = this.d;
                    var tx1 = this.tx;
                    var n = a1 * d1 - b1 * c1;
                    this.a = d1 / n;
                    this.b = -b1 / n;
                    this.c = -c1 / n;
                    this.d = a1 / n;
                    this.tx = (c1 * this.ty - d1 * tx1) / n;
                    this.ty = -(a1 * this.ty - b1 * tx1) / n;
                    return this;
                }
            }, {
                key: "setTo",
                value: function setTo(a, b, c, d, tx, ty) {
                    this.a = a,
                        this.b = b,
                        this.c = c,
                        this.d = d,
                        this.tx = tx,
                        this.ty = ty;
                    return this;
                }
            }, {
                key: "concat",
                value: function concat(matrix) {
                    var a = this.a;
                    var c = this.c;
                    var tx = this.tx;
                    this.a = a * matrix.a + this.b * matrix.c;
                    this.b = a * matrix.b + this.b * matrix.d;
                    this.c = c * matrix.a + this.d * matrix.c;
                    this.d = c * matrix.b + this.d * matrix.d;
                    this.tx = tx * matrix.a + this.ty * matrix.c + matrix.tx;
                    this.ty = tx * matrix.b + this.ty * matrix.d + matrix.ty;
                    return this;
                }
            }, {
                key: "scaleEx",
                value: function scaleEx(x, y) {
                    var ba = this.a
                        , bb = this.b
                        , bc = this.c
                        , bd = this.d;
                    if (bb !== 0 || bc !== 0) {
                        this.a = x * ba;
                        this.b = x * bb;
                        this.c = y * bc;
                        this.d = y * bd;
                    } else {
                        this.a = x * ba;
                        this.b = 0 * bd;
                        this.c = 0 * ba;
                        this.d = y * bd;
                    }
                    this._bTransform = true;
                }
            }, {
                key: "rotateEx",
                value: function rotateEx(angle) {
                    var cos = Math.cos(angle);
                    var sin = Math.sin(angle);
                    var ba = this.a
                        , bb = this.b
                        , bc = this.c
                        , bd = this.d;
                    if (bb !== 0 || bc !== 0) {
                        this.a = cos * ba + sin * bc;
                        this.b = cos * bb + sin * bd;
                        this.c = -sin * ba + cos * bc;
                        this.d = -sin * bb + cos * bd;
                    } else {
                        this.a = cos * ba;
                        this.b = sin * bd;
                        this.c = -sin * ba;
                        this.d = cos * bd;
                    }
                    this._bTransform = true;
                }
            }, {
                key: "clone",
                value: function clone() {
                    var dec = Matrix.create();
                    dec.a = this.a;
                    dec.b = this.b;
                    dec.c = this.c;
                    dec.d = this.d;
                    dec.tx = this.tx;
                    dec.ty = this.ty;
                    dec._bTransform = this._bTransform;
                    return dec;
                }
            }, {
                key: "copyTo",
                value: function copyTo(dec) {
                    dec.a = this.a;
                    dec.b = this.b;
                    dec.c = this.c;
                    dec.d = this.d;
                    dec.tx = this.tx;
                    dec.ty = this.ty;
                    dec._bTransform = this._bTransform;
                    return dec;
                }
            }, {
                key: "toString",
                value: function toString() {
                    return this.a + "," + this.b + "," + this.c + "," + this.d + "," + this.tx + "," + this.ty;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this.recover();
                }
            }, {
                key: "recover",
                value: function recover() {
                    Pool.recover("Matrix", this.identity());
                }
            }], [{
                key: "mul",
                value: function mul(m1, m2, out) {
                    var aa = m1.a
                        , ab = m1.b
                        , ac = m1.c
                        , ad = m1.d
                        , atx = m1.tx
                        , aty = m1.ty;
                    var ba = m2.a
                        , bb = m2.b
                        , bc = m2.c
                        , bd = m2.d
                        , btx = m2.tx
                        , bty = m2.ty;
                    if (bb !== 0 || bc !== 0) {
                        out.a = aa * ba + ab * bc;
                        out.b = aa * bb + ab * bd;
                        out.c = ac * ba + ad * bc;
                        out.d = ac * bb + ad * bd;
                        out.tx = ba * atx + bc * aty + btx;
                        out.ty = bb * atx + bd * aty + bty;
                    } else {
                        out.a = aa * ba;
                        out.b = ab * bd;
                        out.c = ac * ba;
                        out.d = ad * bd;
                        out.tx = ba * atx + btx;
                        out.ty = bd * aty + bty;
                    }
                    return out;
                }
            }, {
                key: "mul16",
                value: function mul16(m1, m2, out) {
                    var aa = m1.a
                        , ab = m1.b
                        , ac = m1.c
                        , ad = m1.d
                        , atx = m1.tx
                        , aty = m1.ty;
                    var ba = m2.a
                        , bb = m2.b
                        , bc = m2.c
                        , bd = m2.d
                        , btx = m2.tx
                        , bty = m2.ty;
                    if (bb !== 0 || bc !== 0) {
                        out[0] = aa * ba + ab * bc;
                        out[1] = aa * bb + ab * bd;
                        out[4] = ac * ba + ad * bc;
                        out[5] = ac * bb + ad * bd;
                        out[12] = ba * atx + bc * aty + btx;
                        out[13] = bb * atx + bd * aty + bty;
                    } else {
                        out[0] = aa * ba;
                        out[1] = ab * bd;
                        out[4] = ac * ba;
                        out[5] = ad * bd;
                        out[12] = ba * atx + btx;
                        out[13] = bd * aty + bty;
                    }
                    return out;
                }
            }, {
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("Matrix", Matrix);
                }
            }]);
            return Matrix;
        }();
    Matrix.EMPTY = new Matrix();
    Matrix.TEMP = new Matrix();
    Matrix._createFun = null;
    var Point = /*#__PURE__*/
        function () {
            function Point() {
                var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                _classCallCheck(this, Point);
                this.x = x;
                this.y = y;
            }
            _createClass(Point, [{
                key: "setTo",
                value: function setTo(x, y) {
                    this.x = x;
                    this.y = y;
                    return this;
                }
            }, {
                key: "reset",
                value: function reset() {
                    this.x = this.y = 0;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    Pool.recover("Point", this.reset());
                }
            }, {
                key: "distance",
                value: function distance(x, y) {
                    return Math.sqrt((this.x - x) * (this.x - x) + (this.y - y) * (this.y - y));
                }
            }, {
                key: "toString",
                value: function toString() {
                    return this.x + "," + this.y;
                }
            }, {
                key: "normalize",
                value: function normalize() {
                    var d = Math.sqrt(this.x * this.x + this.y * this.y);
                    if (d > 0) {
                        var id = 1.0 / d;
                        this.x *= id;
                        this.y *= id;
                    }
                }
            }, {
                key: "copy",
                value: function copy(point) {
                    return this.setTo(point.x, point.y);
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("Point", Point);
                }
            }]);
            return Point;
        }();
    Point.TEMP = new Point();
    Point.EMPTY = new Point();
    var Rectangle = /*#__PURE__*/
        function () {
            function Rectangle() {
                var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var width = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var height = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                _classCallCheck(this, Rectangle);
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
            }
            _createClass(Rectangle, [{
                key: "right",
                get: function get() {
                    return this.x + this.width;
                }
            }, {
                key: "bottom",
                get: function get() {
                    return this.y + this.height;
                }
            }, {
                key: "setTo",
                value: function setTo(x, y, width, height) {
                    this.x = x;
                    this.y = y;
                    this.width = width;
                    this.height = height;
                    return this;
                }
            }, {
                key: "reset",
                value: function reset() {
                    this.x = this.y = this.width = this.height = 0;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    if (this == Rectangle.TEMP || this == Rectangle.EMPTY) {
                        console.log("recover Temp or Empty:", this);
                        return;
                    }
                    Pool.recover("Rectangle", this.reset());
                }
            }, {
                key: "copyFrom",
                value: function copyFrom(source) {
                    this.x = source.x;
                    this.y = source.y;
                    this.width = source.width;
                    this.height = source.height;
                    return this;
                }
            }, {
                key: "contains",
                value: function contains(x, y) {
                    if (this.width <= 0 || this.height <= 0)
                        return false;
                    if (x >= this.x && x < this.right) {
                        if (y >= this.y && y < this.bottom) {
                            return true;
                        }
                    }
                    return false;
                }
            }, {
                key: "intersects",
                value: function intersects(rect) {
                    return !(rect.x > this.x + this.width || rect.x + rect.width < this.x || rect.y > this.y + this.height || rect.y + rect.height < this.y);
                }
            }, {
                key: "intersection",
                value: function intersection(rect) {
                    var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (!this.intersects(rect))
                        return null;
                    out || (out = new Rectangle());
                    out.x = Math.max(this.x, rect.x);
                    out.y = Math.max(this.y, rect.y);
                    out.width = Math.min(this.right, rect.right) - out.x;
                    out.height = Math.min(this.bottom, rect.bottom) - out.y;
                    return out;
                }
            }, {
                key: "union",
                value: function union(source) {
                    var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    out || (out = new Rectangle());
                    this.clone(out);
                    if (source.width <= 0 || source.height <= 0)
                        return out;
                    out.addPoint(source.x, source.y);
                    out.addPoint(source.right, source.bottom);
                    return this;
                }
            }, {
                key: "clone",
                value: function clone() {
                    var out = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    out || (out = new Rectangle());
                    out.x = this.x;
                    out.y = this.y;
                    out.width = this.width;
                    out.height = this.height;
                    return out;
                }
            }, {
                key: "toString",
                value: function toString() {
                    return this.x + "," + this.y + "," + this.width + "," + this.height;
                }
            }, {
                key: "equals",
                value: function equals(rect) {
                    if (!rect || rect.x !== this.x || rect.y !== this.y || rect.width !== this.width || rect.height !== this.height)
                        return false;
                    return true;
                }
            }, {
                key: "addPoint",
                value: function addPoint(x, y) {
                    this.x > x && (this.width += this.x - x,
                        this.x = x);
                    this.y > y && (this.height += this.y - y,
                        this.y = y);
                    if (this.width < x - this.x)
                        this.width = x - this.x;
                    if (this.height < y - this.y)
                        this.height = y - this.y;
                    return this;
                }
            }, {
                key: "_getBoundPoints",
                value: function _getBoundPoints() {
                    var rst = Rectangle._temB;
                    rst.length = 0;
                    if (this.width == 0 || this.height == 0)
                        return rst;
                    rst.push(this.x, this.y, this.x + this.width, this.y, this.x, this.y + this.height, this.x + this.width, this.y + this.height);
                    return rst;
                }
            }, {
                key: "isEmpty",
                value: function isEmpty() {
                    if (this.width <= 0 || this.height <= 0)
                        return true;
                    return false;
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("Rectangle", Rectangle);
                }
            }, {
                key: "_getBoundPointS",
                value: function _getBoundPointS(x, y, width, height) {
                    var rst = Rectangle._temA;
                    rst.length = 0;
                    if (width == 0 || height == 0)
                        return rst;
                    rst.push(x, y, x + width, y, x, y + height, x + width, y + height);
                    return rst;
                }
            }, {
                key: "_getWrapRec",
                value: function _getWrapRec(pointList) {
                    var rst = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (!pointList || pointList.length < 1)
                        return rst ? rst.setTo(0, 0, 0, 0) : Rectangle.TEMP.setTo(0, 0, 0, 0);
                    rst = rst ? rst : Rectangle.create();
                    var i, len = pointList.length, minX, maxX, minY, maxY, tPoint = Point.TEMP;
                    minX = minY = 99999;
                    maxX = maxY = -minX;
                    for (i = 0; i < len; i += 2) {
                        tPoint.x = pointList[i];
                        tPoint.y = pointList[i + 1];
                        minX = minX < tPoint.x ? minX : tPoint.x;
                        minY = minY < tPoint.y ? minY : tPoint.y;
                        maxX = maxX > tPoint.x ? maxX : tPoint.x;
                        maxY = maxY > tPoint.y ? maxY : tPoint.y;
                    }
                    return rst.setTo(minX, minY, maxX - minX, maxY - minY);
                }
            }]);
            return Rectangle;
        }();
    Rectangle.EMPTY = new Rectangle();
    Rectangle.TEMP = new Rectangle();
    Rectangle._temB = [];
    Rectangle._temA = [];
    var LayaGL = /*#__PURE__*/
        _createClass(function LayaGL() {
            _classCallCheck(this, LayaGL);
        });
    LayaGL.ARRAY_BUFFER_TYPE_DATA = 0;
    LayaGL.ARRAY_BUFFER_TYPE_CMD = 1;
    LayaGL.ARRAY_BUFFER_REF_REFERENCE = 0;
    LayaGL.ARRAY_BUFFER_REF_COPY = 1;
    LayaGL.UPLOAD_SHADER_UNIFORM_TYPE_ID = 0;
    LayaGL.UPLOAD_SHADER_UNIFORM_TYPE_DATA = 1;
    var WebGLContext = /*#__PURE__*/
        function () {
            function WebGLContext() {
                _classCallCheck(this, WebGLContext);
            }
            _createClass(WebGLContext, null, [{
                key: "__init__",
                value: function __init__() {
                    var gl = LayaGL.instance;
                    WebGLContext._depthFunc = gl.LESS;
                    WebGLContext._blendEquation = gl.FUNC_ADD;
                    WebGLContext._blendEquationRGB = gl.FUNC_ADD;
                    WebGLContext._blendEquationAlpha = gl.FUNC_ADD;
                    WebGLContext._sFactor = gl.ONE;
                    WebGLContext._dFactor = gl.ZERO;
                    WebGLContext._sFactorAlpha = gl.ONE;
                    WebGLContext._dFactorAlpha = gl.ZERO;
                    WebGLContext._activedTextureID = gl.TEXTURE0;
                    WebGLContext._glTextureIDs = [gl.TEXTURE0, gl.TEXTURE1, gl.TEXTURE2, gl.TEXTURE3, gl.TEXTURE4, gl.TEXTURE5, gl.TEXTURE6, gl.TEXTURE7];
                }
            }, {
                key: "useProgram",
                value: function useProgram(gl, program) {
                    if (WebGLContext._useProgram === program)
                        return false;
                    gl.useProgram(program);
                    WebGLContext._useProgram = program;
                    return true;
                }
            }, {
                key: "setDepthTest",
                value: function setDepthTest(gl, value) {
                    value !== WebGLContext._depthTest && (WebGLContext._depthTest = value,
                        value ? gl.enable(gl.DEPTH_TEST) : gl.disable(gl.DEPTH_TEST));
                }
            }, {
                key: "setDepthMask",
                value: function setDepthMask(gl, value) {
                    value !== WebGLContext._depthMask && (WebGLContext._depthMask = value,
                        gl.depthMask(value));
                }
            }, {
                key: "setDepthFunc",
                value: function setDepthFunc(gl, value) {
                    value !== WebGLContext._depthFunc && (WebGLContext._depthFunc = value,
                        gl.depthFunc(value));
                }
            }, {
                key: "setBlend",
                value: function setBlend(gl, value) {
                    value !== WebGLContext._blend && (WebGLContext._blend = value,
                        value ? gl.enable(gl.BLEND) : gl.disable(gl.BLEND));
                }
            }, {
                key: "setBlendEquation",
                value: function setBlendEquation(gl, blendEquation) {
                    if (blendEquation !== WebGLContext._blendEquation) {
                        WebGLContext._blendEquation = blendEquation;
                        WebGLContext._blendEquationRGB = WebGLContext._blendEquationAlpha = null;
                        gl.blendEquation(blendEquation);
                    }
                }
            }, {
                key: "setBlendEquationSeparate",
                value: function setBlendEquationSeparate(gl, blendEquationRGB, blendEquationAlpha) {
                    if (blendEquationRGB !== WebGLContext._blendEquationRGB || blendEquationAlpha !== WebGLContext._blendEquationAlpha) {
                        WebGLContext._blendEquationRGB = blendEquationRGB;
                        WebGLContext._blendEquationAlpha = blendEquationAlpha;
                        WebGLContext._blendEquation = null;
                        gl.blendEquationSeparate(blendEquationRGB, blendEquationAlpha);
                    }
                }
            }, {
                key: "setBlendFunc",
                value: function setBlendFunc(gl, sFactor, dFactor) {
                    var force = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    if (force || sFactor !== WebGLContext._sFactor || dFactor !== WebGLContext._dFactor) {
                        WebGLContext._sFactor = sFactor;
                        WebGLContext._dFactor = dFactor;
                        WebGLContext._sFactorRGB = null;
                        WebGLContext._dFactorRGB = null;
                        WebGLContext._sFactorAlpha = null;
                        WebGLContext._dFactorAlpha = null;
                        gl.blendFunc(sFactor, dFactor);
                    }
                }
            }, {
                key: "setBlendFuncSeperate",
                value: function setBlendFuncSeperate(gl, srcRGB, dstRGB, srcAlpha, dstAlpha) {
                    if (srcRGB !== WebGLContext._sFactorRGB || dstRGB !== WebGLContext._dFactorRGB || srcAlpha !== WebGLContext._sFactorAlpha || dstAlpha !== WebGLContext._dFactorAlpha) {
                        WebGLContext._sFactorRGB = srcRGB;
                        WebGLContext._dFactorRGB = dstRGB;
                        WebGLContext._sFactorAlpha = srcAlpha;
                        WebGLContext._dFactorAlpha = dstAlpha;
                        WebGLContext._sFactor = null;
                        WebGLContext._dFactor = null;
                        gl.blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
                    }
                }
            }, {
                key: "setCullFace",
                value: function setCullFace(gl, value) {
                    value !== WebGLContext._cullFace && (WebGLContext._cullFace = value,
                        value ? gl.enable(gl.CULL_FACE) : gl.disable(gl.CULL_FACE));
                }
            }, {
                key: "setFrontFace",
                value: function setFrontFace(gl, value) {
                    value !== WebGLContext._frontFace && (WebGLContext._frontFace = value,
                        gl.frontFace(value));
                }
            }, {
                key: "activeTexture",
                value: function activeTexture(gl, textureID) {
                    if (WebGLContext._activedTextureID !== textureID) {
                        gl.activeTexture(textureID);
                        WebGLContext._activedTextureID = textureID;
                    }
                }
            }, {
                key: "bindTexture",
                value: function bindTexture(gl, target, texture) {
                    if (WebGLContext._activeTextures[WebGLContext._activedTextureID - gl.TEXTURE0] !== texture) {
                        gl.bindTexture(target, texture);
                        WebGLContext._activeTextures[WebGLContext._activedTextureID - gl.TEXTURE0] = texture;
                    }
                }
            }, {
                key: "__init_native",
                value: function __init_native() {
                    if (!ILaya.Render.supportWebGLPlusRendering)
                        return;
                    var webGLContext = WebGLContext;
                    webGLContext.activeTexture = webGLContext.activeTextureForNative;
                    webGLContext.bindTexture = webGLContext.bindTextureForNative;
                }
            }, {
                key: "useProgramForNative",
                value: function useProgramForNative(gl, program) {
                    gl.useProgram(program);
                    return true;
                }
            }, {
                key: "setDepthTestForNative",
                value: function setDepthTestForNative(gl, value) {
                    if (value)
                        gl.enable(gl.DEPTH_TEST);
                    else
                        gl.disable(gl.DEPTH_TEST);
                }
            }, {
                key: "setDepthMaskForNative",
                value: function setDepthMaskForNative(gl, value) {
                    gl.depthMask(value);
                }
            }, {
                key: "setDepthFuncForNative",
                value: function setDepthFuncForNative(gl, value) {
                    gl.depthFunc(value);
                }
            }, {
                key: "setBlendForNative",
                value: function setBlendForNative(gl, value) {
                    if (value)
                        gl.enable(gl.BLEND);
                    else
                        gl.disable(gl.BLEND);
                }
            }, {
                key: "setBlendFuncForNative",
                value: function setBlendFuncForNative(gl, sFactor, dFactor) {
                    gl.blendFunc(sFactor, dFactor);
                }
            }, {
                key: "setCullFaceForNative",
                value: function setCullFaceForNative(gl, value) {
                    if (value)
                        gl.enable(gl.CULL_FACE);
                    else
                        gl.disable(gl.CULL_FACE);
                }
            }, {
                key: "setFrontFaceForNative",
                value: function setFrontFaceForNative(gl, value) {
                    gl.frontFace(value);
                }
            }, {
                key: "activeTextureForNative",
                value: function activeTextureForNative(gl, textureID) {
                    gl.activeTexture(textureID);
                }
            }, {
                key: "bindTextureForNative",
                value: function bindTextureForNative(gl, target, texture) {
                    gl.bindTexture(target, texture);
                }
            }, {
                key: "bindVertexArrayForNative",
                value: function bindVertexArrayForNative(gl, vertexArray) {
                    gl.bindVertexArray(vertexArray);
                }
            }]);
            return WebGLContext;
        }();
    WebGLContext._activeTextures = new Array(8);
    WebGLContext._useProgram = null;
    WebGLContext._depthTest = true;
    WebGLContext._depthMask = true;
    WebGLContext._blend = false;
    WebGLContext._cullFace = false;
    WebGLContext.mainContext = null;
    var Handler = /*#__PURE__*/
        function () {
            function Handler() {
                var caller = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                var method = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var once = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                _classCallCheck(this, Handler);
                this.once = false;
                this._id = 0;
                this.setTo(caller, method, args, once);
            }
            _createClass(Handler, [{
                key: "setTo",
                value: function setTo(caller, method, args) {
                    var once = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    this._id = Handler._gid++;
                    this.caller = caller;
                    this.method = method;
                    this.args = args;
                    this.once = once;
                    return this;
                }
            }, {
                key: "run",
                value: function run() {
                    if (this.method == null)
                        return null;
                    var id = this._id;
                    var result = this.method.apply(this.caller, this.args);
                    this._id === id && this.once && this.recover();
                    return result;
                }
            }, {
                key: "runWith",
                value: function runWith(data) {
                    if (this.method == null)
                        return null;
                    var id = this._id;
                    if (data == null)
                        var result = this.method.apply(this.caller, this.args);
                    else if (!this.args && !data.unshift)
                        result = this.method.call(this.caller, data);
                    else if (this.args)
                        result = this.method.apply(this.caller, this.args.concat(data));
                    else
                        result = this.method.apply(this.caller, data);
                    this._id === id && this.once && this.recover();
                    return result;
                }
            }, {
                key: "clear",
                value: function clear() {
                    this.caller = null;
                    this.method = null;
                    this.args = null;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    if (this._id > 0) {
                        this._id = 0;
                        Handler._pool.push(this.clear());
                    }
                }
            }], [{
                key: "create",
                value: function create(caller, method) {
                    var args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var once = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                    if (Handler._pool.length)
                        return Handler._pool.pop().setTo(caller, method, args, once);
                    return new Handler(caller, method, args, once);
                }
            }]);
            return Handler;
        }();
    Handler._pool = [];
    Handler._gid = 1;
    var EventDispatcher = /*#__PURE__*/
        function () {
            function EventDispatcher() {
                _classCallCheck(this, EventDispatcher);
            }
            _createClass(EventDispatcher, [{
                key: "hasListener",
                value: function hasListener(type) {
                    var listener = this._events && this._events[type];
                    return !!listener;
                }
            }, {
                key: "event",
                value: function event(type) {
                    var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (!this._events || !this._events[type])
                        return false;
                    var listeners = this._events[type];
                    if (listeners.run) {
                        if (listeners.once)
                            delete this._events[type];
                        data != null ? listeners.runWith(data) : listeners.run();
                    } else {
                        for (var i = 0, n = listeners.length; i < n; i++) {
                            var listener = listeners[i];
                            if (listener) {
                                data != null ? listener.runWith(data) : listener.run();
                            }
                            if (!listener || listener.once) {
                                listeners.splice(i, 1);
                                i--;
                                n--;
                            }
                        }
                        if (listeners.length === 0 && this._events)
                            delete this._events[type];
                    }
                    return true;
                }
            }, {
                key: "on",
                value: function on(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    return this._createListener(type, caller, listener, args, false);
                }
            }, {
                key: "once",
                value: function once(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    return this._createListener(type, caller, listener, args, true);
                }
            }, {
                key: "_createListener",
                value: function _createListener(type, caller, listener, args, once) {
                    var offBefore = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
                    offBefore && this.off(type, caller, listener, once);
                    var handler = EventHandler.create(caller || this, listener, args, once);
                    this._events || (this._events = {});
                    var events = this._events;
                    if (!events[type])
                        events[type] = handler;
                    else {
                        if (!events[type].run)
                            events[type].push(handler);
                        else
                            events[type] = [events[type], handler];
                    }
                    return this;
                }
            }, {
                key: "off",
                value: function off(type, caller, listener) {
                    var onceOnly = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    if (!this._events || !this._events[type])
                        return this;
                    var listeners = this._events[type];
                    if (listeners != null) {
                        if (listeners.run) {
                            if ((!caller || listeners.caller === caller) && (listener == null || listeners.method === listener) && (!onceOnly || listeners.once)) {
                                delete this._events[type];
                                listeners.recover();
                            }
                        } else {
                            var count = 0;
                            for (var i = 0, n = listeners.length; i < n; i++) {
                                var item = listeners[i];
                                if (!item) {
                                    count++;
                                    continue;
                                }
                                if (item && (!caller || item.caller === caller) && (listener == null || item.method === listener) && (!onceOnly || item.once)) {
                                    count++;
                                    listeners[i] = null;
                                    item.recover();
                                }
                            }
                            if (count === n)
                                delete this._events[type];
                        }
                    }
                    return this;
                }
            }, {
                key: "offAll",
                value: function offAll() {
                    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    var events = this._events;
                    if (!events)
                        return this;
                    if (type) {
                        this._recoverHandlers(events[type]);
                        delete events[type];
                    } else {
                        for (var name in events) {
                            this._recoverHandlers(events[name]);
                        }
                        this._events = null;
                    }
                    return this;
                }
            }, {
                key: "offAllCaller",
                value: function offAllCaller(caller) {
                    if (caller && this._events) {
                        for (var name in this._events) {
                            this.off(name, caller, null);
                        }
                    }
                    return this;
                }
            }, {
                key: "_recoverHandlers",
                value: function _recoverHandlers(arr) {
                    if (!arr)
                        return;
                    if (arr.run) {
                        arr.recover();
                    } else {
                        for (var i = arr.length - 1; i > -1; i--) {
                            if (arr[i]) {
                                arr[i].recover();
                                arr[i] = null;
                            }
                        }
                    }
                }
            }, {
                key: "isMouseEvent",
                value: function isMouseEvent(type) {
                    return EventDispatcher.MOUSE_EVENTS[type] || false;
                }
            }]);
            return EventDispatcher;
        }();
    EventDispatcher.MOUSE_EVENTS = {
        "rightmousedown": true,
        "rightmouseup": true,
        "rightclick": true,
        "mousedown": true,
        "mouseup": true,
        "mousemove": true,
        "mouseover": true,
        "mouseout": true,
        "click": true,
        "doubleclick": true
    };
    var EventHandler = /*#__PURE__*/
        function (_Handler) {
            _inherits(EventHandler, _Handler);
            var _super = _createSuper(EventHandler);
            function EventHandler(caller, method, args, once) {
                _classCallCheck(this, EventHandler);
                return _super.call(this, caller, method, args, once);
            }
            _createClass(EventHandler, [{
                key: "recover",
                value: function recover() {
                    if (this._id > 0) {
                        this._id = 0;
                        EventHandler._pool.push(this.clear());
                    }
                }
            }], [{
                key: "create",
                value: function create(caller, method) {
                    var args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var once = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                    if (EventHandler._pool.length)
                        return EventHandler._pool.pop().setTo(caller, method, args, once);
                    return new EventHandler(caller, method, args, once);
                }
            }]);
            return EventHandler;
        }(Handler);
    EventHandler._pool = [];
    var URL = /*#__PURE__*/
        function () {
            function URL(url) {
                _classCallCheck(this, URL);
                this._url = URL.formatURL(url);
                this._path = URL.getPath(url);
            }
            _createClass(URL, [{
                key: "url",
                get: function get() {
                    return this._url;
                }
            }, {
                key: "path",
                get: function get() {
                    return this._path;
                }
            }], [{
                key: "basePath",
                get: function get() {
                    return URL._basePath;
                },
                set: function set(value) {
                    URL._basePath = ILaya.Laya._getUrlPath();
                    URL._basePath = URL.formatURL(value);
                }
            }, {
                key: "formatURL",
                value: function formatURL(url) {
                    if (!url)
                        return "null path";
                    if (url.indexOf(":") > 0)
                        return url;
                    if (URL.customFormat != null)
                        url = URL.customFormat(url);
                    if (url.indexOf(":") > 0)
                        return url;
                    var char1 = url.charAt(0);
                    if (char1 === ".") {
                        return URL._formatRelativePath(URL._basePath + url);
                    } else if (char1 === '~') {
                        return URL.rootPath + url.substring(1);
                    } else if (char1 === "d") {
                        if (url.indexOf("data:image") === 0)
                            return url;
                    } else if (char1 === "/") {
                        return url;
                    }
                    return URL._basePath + url;
                }
            }, {
                key: "_formatRelativePath",
                value: function _formatRelativePath(value) {
                    var parts = value.split("/");
                    for (var i = 0, len = parts.length; i < len; i++) {
                        if (parts[i] == '..') {
                            parts.splice(i - 1, 2);
                            i -= 2;
                        }
                    }
                    return parts.join('/');
                }
            }, {
                key: "getPath",
                value: function getPath(url) {
                    var ofs = url.lastIndexOf('/');
                    return ofs > 0 ? url.substr(0, ofs + 1) : "";
                }
            }, {
                key: "getFileName",
                value: function getFileName(url) {
                    var ofs = url.lastIndexOf('/');
                    return ofs > 0 ? url.substr(ofs + 1) : url;
                }
            }, {
                key: "getAdptedFilePath",
                value: function getAdptedFilePath(url) {
                    if (!URL.exportSceneToJson || !url)
                        return url;
                    var i, len;
                    len = URL._adpteTypeList.length;
                    var tArr;
                    for (i = 0; i < len; i++) {
                        tArr = URL._adpteTypeList[i];
                        url = url.replace(tArr[0], tArr[1]);
                    }
                    return url;
                }
            }]);
            return URL;
        }();
    URL.version = {};
    URL.exportSceneToJson = false;
    URL._basePath = "";
    URL.rootPath = "";
    URL.customFormat = function (url) {
        var newUrl = URL.version[url];
        if (!window.conch && newUrl)
            url += "?v=" + newUrl;
        return url;
    }
        ;
    URL._adpteTypeList = [[".scene3d", ".json"], [".scene", ".json"], [".taa", ".json"], [".prefab", ".json"]];
    var Resource = /*#__PURE__*/
        function (_EventDispatcher) {
            _inherits(Resource, _EventDispatcher);
            var _super2 = _createSuper(Resource);
            function Resource() {
                var _this2;
                _classCallCheck(this, Resource);
                _this2 = _super2.call(this);
                _this2._id = 0;
                _this2._url = null;
                _this2._cpuMemory = 0;
                _this2._gpuMemory = 0;
                _this2._destroyed = false;
                _this2._referenceCount = 0;
                _this2.lock = false;
                _this2.name = null;
                _this2._id = ++Resource._uniqueIDCounter;
                _this2._destroyed = false;
                _this2._referenceCount = 0;
                Resource._idResourcesMap[_this2.id] = _assertThisInitialized(_this2);
                _this2.lock = false;
                return _this2;
            }
            _createClass(Resource, [{
                key: "id",
                get: function get() {
                    return this._id;
                }
            }, {
                key: "url",
                get: function get() {
                    return this._url;
                }
            }, {
                key: "cpuMemory",
                get: function get() {
                    return this._cpuMemory;
                }
            }, {
                key: "gpuMemory",
                get: function get() {
                    return this._gpuMemory;
                }
            }, {
                key: "destroyed",
                get: function get() {
                    return this._destroyed;
                }
            }, {
                key: "referenceCount",
                get: function get() {
                    return this._referenceCount;
                }
            }, {
                key: "_setCPUMemory",
                value: function _setCPUMemory(value) {
                    var offsetValue = value - this._cpuMemory;
                    this._cpuMemory = value;
                    Resource._addCPUMemory(offsetValue);
                }
            }, {
                key: "_setGPUMemory",
                value: function _setGPUMemory(value) {
                    var offsetValue = value - this._gpuMemory;
                    this._gpuMemory = value;
                    Resource._addGPUMemory(offsetValue);
                }
            }, {
                key: "_setCreateURL",
                value: function _setCreateURL(url) {
                    url = URL.formatURL(url);
                    if (this._url !== url) {
                        var resList;
                        if (this._url) {
                            resList = Resource._urlResourcesMap[this._url];
                            resList.splice(resList.indexOf(this), 1);
                            resList.length === 0 && delete Resource._urlResourcesMap[this._url];
                        }
                        if (url) {
                            resList = Resource._urlResourcesMap[url];
                            resList || (Resource._urlResourcesMap[url] = resList = []);
                            resList.push(this);
                        }
                        this._url = url;
                    }
                }
            }, {
                key: "_addReference",
                value: function _addReference() {
                    var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                    this._referenceCount += count;
                }
            }, {
                key: "_removeReference",
                value: function _removeReference() {
                    var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
                    this._referenceCount -= count;
                }
            }, {
                key: "_clearReference",
                value: function _clearReference() {
                    this._referenceCount = 0;
                }
            }, {
                key: "_recoverResource",
                value: function _recoverResource() { }
            }, {
                key: "_disposeResource",
                value: function _disposeResource() { }
            }, {
                key: "_activeResource",
                value: function _activeResource() { }
            }, {
                key: "destroy",
                value: function destroy() {
                    if (this._destroyed)
                        return;
                    this._destroyed = true;
                    this.lock = false;
                    this._disposeResource();
                    delete Resource._idResourcesMap[this.id];
                    var resList;
                    if (this._url) {
                        resList = Resource._urlResourcesMap[this._url];
                        if (resList) {
                            resList.splice(resList.indexOf(this), 1);
                            resList.length === 0 && delete Resource._urlResourcesMap[this._url];
                        }
                        var resou = ILaya.Loader.loadedMap[this._url];
                        resou == this && delete ILaya.Loader.loadedMap[this._url];
                    }
                }
            }], [{
                key: "cpuMemory",
                get: function get() {
                    return Resource._cpuMemory;
                }
            }, {
                key: "gpuMemory",
                get: function get() {
                    return Resource._gpuMemory;
                }
            }, {
                key: "_addCPUMemory",
                value: function _addCPUMemory(size) {
                    Resource._cpuMemory += size;
                }
            }, {
                key: "_addGPUMemory",
                value: function _addGPUMemory(size) {
                    Resource._gpuMemory += size;
                }
            }, {
                key: "_addMemory",
                value: function _addMemory(cpuSize, gpuSize) {
                    Resource._cpuMemory += cpuSize;
                    Resource._gpuMemory += gpuSize;
                }
            }, {
                key: "getResourceByID",
                value: function getResourceByID(id) {
                    return Resource._idResourcesMap[id];
                }
            }, {
                key: "getResourceByURL",
                value: function getResourceByURL(url) {
                    var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    return Resource._urlResourcesMap[url][index];
                }
            }, {
                key: "destroyUnusedResources",
                value: function destroyUnusedResources() {
                    for (var k in Resource._idResourcesMap) {
                        var res = Resource._idResourcesMap[k];
                        if (!res.lock && res._referenceCount === 0)
                            res.destroy();
                    }
                }
            }]);
            return Resource;
        }(EventDispatcher);
    Resource._uniqueIDCounter = 0;
    Resource._idResourcesMap = {};
    Resource._urlResourcesMap = {};
    Resource._cpuMemory = 0;
    Resource._gpuMemory = 0;
    var Bitmap = /*#__PURE__*/
        function (_Resource) {
            _inherits(Bitmap, _Resource);
            var _super3 = _createSuper(Bitmap);
            function Bitmap() {
                var _this3;
                _classCallCheck(this, Bitmap);
                _this3 = _super3.call(this);
                _this3._width = -1;
                _this3._height = -1;
                return _this3;
            }
            _createClass(Bitmap, [{
                key: "width",
                get: function get() {
                    return this._width;
                },
                set: function set(width) {
                    this._width = width;
                }
            }, {
                key: "height",
                get: function get() {
                    return this._height;
                },
                set: function set(height) {
                    this._height = height;
                }
            }, {
                key: "_getSource",
                value: function _getSource() {
                    throw "Bitmap: must override it.";
                }
            }]);
            return Bitmap;
        }(Resource);
    (function (FilterMode) {
        FilterMode[FilterMode["Point"] = 0] = "Point";
        FilterMode[FilterMode["Bilinear"] = 1] = "Bilinear";
        FilterMode[FilterMode["Trilinear"] = 2] = "Trilinear";
    }
    )(exports.FilterMode || (exports.FilterMode = {}));
    (function (TextureFormat) {
        TextureFormat[TextureFormat["R8G8B8"] = 0] = "R8G8B8";
        TextureFormat[TextureFormat["R8G8B8A8"] = 1] = "R8G8B8A8";
        TextureFormat[TextureFormat["R5G6B5"] = 16] = "R5G6B5";
        TextureFormat[TextureFormat["Alpha8"] = 2] = "Alpha8";
        TextureFormat[TextureFormat["DXT1"] = 3] = "DXT1";
        TextureFormat[TextureFormat["DXT5"] = 4] = "DXT5";
        TextureFormat[TextureFormat["ETC1RGB"] = 5] = "ETC1RGB";
        TextureFormat[TextureFormat["PVRTCRGB_2BPPV"] = 9] = "PVRTCRGB_2BPPV";
        TextureFormat[TextureFormat["PVRTCRGBA_2BPPV"] = 10] = "PVRTCRGBA_2BPPV";
        TextureFormat[TextureFormat["PVRTCRGB_4BPPV"] = 11] = "PVRTCRGB_4BPPV";
        TextureFormat[TextureFormat["PVRTCRGBA_4BPPV"] = 12] = "PVRTCRGBA_4BPPV";
        TextureFormat[TextureFormat["R32G32B32A32"] = 15] = "R32G32B32A32";
    }
    )(exports.TextureFormat || (exports.TextureFormat = {}));
    (function (WarpMode) {
        WarpMode[WarpMode["Repeat"] = 0] = "Repeat";
        WarpMode[WarpMode["Clamp"] = 1] = "Clamp";
    }
    )(exports.WarpMode || (exports.WarpMode = {}));
    var BaseTexture = /*#__PURE__*/
        function (_Bitmap) {
            _inherits(BaseTexture, _Bitmap);
            var _super4 = _createSuper(BaseTexture);
            function BaseTexture(format, mipMap) {
                var _this4;
                _classCallCheck(this, BaseTexture);
                _this4 = _super4.call(this);
                _this4._wrapModeU = exports.WarpMode.Repeat;
                _this4._wrapModeV = exports.WarpMode.Repeat;
                _this4._filterMode = exports.FilterMode.Bilinear;
                _this4._readyed = false;
                _this4._width = -1;
                _this4._height = -1;
                _this4._format = format;
                _this4._mipmap = mipMap;
                _this4._anisoLevel = 1;
                _this4._glTexture = LayaGL.instance.createTexture();
                return _this4;
            }
            _createClass(BaseTexture, [{
                key: "mipmap",
                get: function get() {
                    return this._mipmap;
                }
            }, {
                key: "format",
                get: function get() {
                    return this._format;
                }
            }, {
                key: "wrapModeU",
                get: function get() {
                    return this._wrapModeU;
                },
                set: function set(value) {
                    if (this._wrapModeU !== value) {
                        this._wrapModeU = value;
                        this._width !== -1 && this._setWarpMode(LayaGL.instance.TEXTURE_WRAP_S, value);
                    }
                }
            }, {
                key: "wrapModeV",
                get: function get() {
                    return this._wrapModeV;
                },
                set: function set(value) {
                    if (this._wrapModeV !== value) {
                        this._wrapModeV = value;
                        this._height !== -1 && this._setWarpMode(LayaGL.instance.TEXTURE_WRAP_T, value);
                    }
                }
            }, {
                key: "filterMode",
                get: function get() {
                    return this._filterMode;
                },
                set: function set(value) {
                    if (value !== this._filterMode) {
                        this._filterMode = value;
                        this._width !== -1 && this._height !== -1 && this._setFilterMode(value);
                    }
                }
            }, {
                key: "anisoLevel",
                get: function get() {
                    return this._anisoLevel;
                },
                set: function set(value) {
                    if (value !== this._anisoLevel) {
                        this._anisoLevel = Math.max(1, Math.min(16, value));
                        this._width !== -1 && this._height !== -1 && this._setAnisotropy(value);
                    }
                }
            }, {
                key: "mipmapCount",
                get: function get() {
                    return this._mipmapCount;
                }
            }, {
                key: "defaulteTexture",
                get: function get() {
                    throw "BaseTexture:must override it.";
                }
            }, {
                key: "_getFormatByteCount",
                value: function _getFormatByteCount() {
                    switch (this._format) {
                        case exports.TextureFormat.R8G8B8:
                            return 3;
                        case exports.TextureFormat.R8G8B8A8:
                            return 4;
                        case exports.TextureFormat.R5G6B5:
                            return 1;
                        case exports.TextureFormat.Alpha8:
                            return 1;
                        case exports.TextureFormat.R32G32B32A32:
                            return 4;
                        default:
                            throw "Texture2D: unknown format.";
                    }
                }
            }, {
                key: "_isPot",
                value: function _isPot(size) {
                    return (size & size - 1) === 0;
                }
            }, {
                key: "_getGLFormat",
                value: function _getGLFormat() {
                    var glFormat;
                    var gl = LayaGL.instance;
                    var gpu = LayaGL.layaGPUInstance;
                    switch (this._format) {
                        case exports.TextureFormat.R8G8B8:
                        case exports.TextureFormat.R5G6B5:
                            glFormat = gl.RGB;
                            break;
                        case exports.TextureFormat.R8G8B8A8:
                            glFormat = gl.RGBA;
                            break;
                        case exports.TextureFormat.Alpha8:
                            glFormat = gl.ALPHA;
                            break;
                        case exports.TextureFormat.R32G32B32A32:
                            glFormat = gl.RGBA;
                            break;
                        case exports.TextureFormat.DXT1:
                            if (gpu._compressedTextureS3tc)
                                glFormat = gpu._compressedTextureS3tc.COMPRESSED_RGB_S3TC_DXT1_EXT;
                            else
                                throw "BaseTexture: not support DXT1 format.";
                            break;
                        case exports.TextureFormat.DXT5:
                            if (gpu._compressedTextureS3tc)
                                glFormat = gpu._compressedTextureS3tc.COMPRESSED_RGBA_S3TC_DXT5_EXT;
                            else
                                throw "BaseTexture: not support DXT5 format.";
                            break;
                        case exports.TextureFormat.ETC1RGB:
                            if (gpu._compressedTextureEtc1)
                                glFormat = gpu._compressedTextureEtc1.COMPRESSED_RGB_ETC1_WEBGL;
                            else
                                throw "BaseTexture: not support ETC1RGB format.";
                            break;
                        case exports.TextureFormat.PVRTCRGB_2BPPV:
                            if (gpu._compressedTexturePvrtc)
                                glFormat = gpu._compressedTexturePvrtc.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;
                            else
                                throw "BaseTexture: not support PVRTCRGB_2BPPV format.";
                            break;
                        case exports.TextureFormat.PVRTCRGBA_2BPPV:
                            if (gpu._compressedTexturePvrtc)
                                glFormat = gpu._compressedTexturePvrtc.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG;
                            else
                                throw "BaseTexture: not support PVRTCRGBA_2BPPV format.";
                            break;
                        case exports.TextureFormat.PVRTCRGB_4BPPV:
                            if (gpu._compressedTexturePvrtc)
                                glFormat = gpu._compressedTexturePvrtc.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;
                            else
                                throw "BaseTexture: not support PVRTCRGB_4BPPV format.";
                            break;
                        case exports.TextureFormat.PVRTCRGBA_4BPPV:
                            if (gpu._compressedTexturePvrtc)
                                glFormat = gpu._compressedTexturePvrtc.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;
                            else
                                throw "BaseTexture: not support PVRTCRGBA_4BPPV format.";
                            break;
                        default:
                            throw "BaseTexture: unknown texture format.";
                    }
                    return glFormat;
                }
            }, {
                key: "_setFilterMode",
                value: function _setFilterMode(value) {
                    var gl = LayaGL.instance;
                    WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    switch (value) {
                        case exports.FilterMode.Point:
                            if (this._mipmap)
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.NEAREST_MIPMAP_NEAREST);
                            else
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
                            gl.texParameteri(this._glTextureType, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
                            break;
                        case exports.FilterMode.Bilinear:
                            if (this._mipmap)
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_NEAREST);
                            else
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                            gl.texParameteri(this._glTextureType, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                            break;
                        case exports.FilterMode.Trilinear:
                            if (this._mipmap)
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_LINEAR);
                            else
                                gl.texParameteri(this._glTextureType, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                            gl.texParameteri(this._glTextureType, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                            break;
                        default:
                            throw new Error("BaseTexture:unknown filterMode value.");
                    }
                }
            }, {
                key: "_setWarpMode",
                value: function _setWarpMode(orientation, mode) {
                    var gl = LayaGL.instance;
                    WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    if (this._isPot(this._width) && this._isPot(this._height)) {
                        switch (mode) {
                            case exports.WarpMode.Repeat:
                                gl.texParameteri(this._glTextureType, orientation, gl.REPEAT);
                                break;
                            case exports.WarpMode.Clamp:
                                gl.texParameteri(this._glTextureType, orientation, gl.CLAMP_TO_EDGE);
                                break;
                        }
                    } else {
                        gl.texParameteri(this._glTextureType, orientation, gl.CLAMP_TO_EDGE);
                    }
                }
            }, {
                key: "_setAnisotropy",
                value: function _setAnisotropy(value) {
                    var anisotropic = LayaGL.layaGPUInstance._extTextureFilterAnisotropic;
                    if (anisotropic) {
                        value = Math.max(value, 1);
                        var gl = LayaGL.instance;
                        WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                        value = Math.min(gl.getParameter(anisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT), value);
                        gl.texParameterf(this._glTextureType, anisotropic.TEXTURE_MAX_ANISOTROPY_EXT, value);
                    }
                }
            }, {
                key: "_disposeResource",
                value: function _disposeResource() {
                    if (this._glTexture) {
                        LayaGL.instance.deleteTexture(this._glTexture);
                        this._glTexture = null;
                        this._setGPUMemory(0);
                    }
                }
            }, {
                key: "_getSource",
                value: function _getSource() {
                    if (this._readyed)
                        return this._glTexture;
                    else
                        return null;
                }
            }, {
                key: "generateMipmap",
                value: function generateMipmap() {
                    if (this._isPot(this.width) && this._isPot(this.height))
                        LayaGL.instance.generateMipmap(this._glTextureType);
                }
            }]);
            return BaseTexture;
        }(Bitmap);
    BaseTexture._rgbmRange = 5.0;
    BaseTexture.FORMAT_R8G8B8 = 0;
    BaseTexture.FORMAT_R8G8B8A8 = 1;
    BaseTexture.FORMAT_ALPHA8 = 2;
    BaseTexture.FORMAT_DXT1 = 3;
    BaseTexture.FORMAT_DXT5 = 4;
    BaseTexture.FORMAT_ETC1RGB = 5;
    BaseTexture.FORMAT_PVRTCRGB_2BPPV = 9;
    BaseTexture.FORMAT_PVRTCRGBA_2BPPV = 10;
    BaseTexture.FORMAT_PVRTCRGB_4BPPV = 11;
    BaseTexture.FORMAT_PVRTCRGBA_4BPPV = 12;
    BaseTexture.RENDERTEXTURE_FORMAT_RGBA_HALF_FLOAT = 14;
    BaseTexture.FORMAT_R32G32B32A32 = 15;
    BaseTexture.FORMAT_DEPTH_16 = 0;
    BaseTexture.FORMAT_STENCIL_8 = 1;
    BaseTexture.FORMAT_DEPTHSTENCIL_16_8 = 2;
    BaseTexture.FORMAT_DEPTHSTENCIL_NONE = 3;
    BaseTexture.FILTERMODE_POINT = 0;
    BaseTexture.FILTERMODE_BILINEAR = 1;
    BaseTexture.FILTERMODE_TRILINEAR = 2;
    BaseTexture.WARPMODE_REPEAT = 0;
    BaseTexture.WARPMODE_CLAMP = 1;
    var Texture2D = /*#__PURE__*/
        function (_BaseTexture) {
            _inherits(Texture2D, _BaseTexture);
            var _super5 = _createSuper(Texture2D);
            function Texture2D() {
                var _this5;
                var width = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : exports.TextureFormat.R8G8B8A8;
                var mipmap = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                var canRead = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
                _classCallCheck(this, Texture2D);
                _this5 = _super5.call(this, format, mipmap);
                var gl = LayaGL.instance;
                _this5._glTextureType = gl.TEXTURE_2D;
                _this5._width = width;
                _this5._height = height;
                _this5._canRead = canRead;
                _this5._setWarpMode(gl.TEXTURE_WRAP_S, _this5._wrapModeU);
                _this5._setWarpMode(gl.TEXTURE_WRAP_T, _this5._wrapModeV);
                _this5._setFilterMode(_this5._filterMode);
                _this5._setAnisotropy(_this5._anisoLevel);
                var compress = _this5._gpuCompressFormat();
                if (mipmap) {
                    var mipCount = Math.max(Math.ceil(Math.log2(width)) + 1, Math.ceil(Math.log2(height)) + 1);
                    if (!compress) {
                        for (var i = 0; i < mipCount; i++) {
                            _this5._setPixels(null, i, Math.max(width >> i, 1), Math.max(height >> i, 1));
                        }
                    }
                    _this5._mipmapCount = mipCount;
                    _this5._setGPUMemory(width * height * 4 * (1 + 1 / 3));
                } else {
                    if (!compress)
                        _this5._setPixels(null, 0, width, height);
                    _this5._mipmapCount = 1;
                    _this5._setGPUMemory(width * height * 4);
                }
                return _this5;
            }
            _createClass(Texture2D, [{
                key: "defaulteTexture",
                get: function get() {
                    return Texture2D.grayTexture;
                }
            }, {
                key: "_gpuCompressFormat",
                value: function _gpuCompressFormat() {
                    return this._format == exports.TextureFormat.DXT1 || this._format == exports.TextureFormat.DXT5 || this._format == exports.TextureFormat.ETC1RGB || this._format == exports.TextureFormat.PVRTCRGB_2BPPV || this._format == exports.TextureFormat.PVRTCRGBA_2BPPV || this._format == exports.TextureFormat.PVRTCRGB_4BPPV || this._format == exports.TextureFormat.PVRTCRGBA_4BPPV;
                }
            }, {
                key: "_setPixels",
                value: function _setPixels(pixels, miplevel, width, height) {
                    var gl = LayaGL.instance;
                    var textureType = this._glTextureType;
                    var glFormat = this._getGLFormat();
                    WebGLContext.bindTexture(gl, textureType, this._glTexture);
                    switch (this.format) {
                        case exports.TextureFormat.R8G8B8:
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
                            gl.texImage2D(textureType, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels);
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 4);
                            break;
                        case exports.TextureFormat.R5G6B5:
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 2);
                            gl.texImage2D(textureType, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_SHORT_5_6_5, pixels);
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 4);
                            break;
                        case exports.TextureFormat.R32G32B32A32:
                            if (LayaGL.layaGPUInstance._isWebGL2)
                                gl.texImage2D(textureType, miplevel, gl.RGBA32F, width, height, 0, glFormat, gl.FLOAT, pixels);
                            else
                                gl.texImage2D(textureType, miplevel, gl.RGBA, width, height, 0, glFormat, gl.FLOAT, pixels);
                            break;
                        default:
                            gl.texImage2D(textureType, miplevel, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, pixels);
                    }
                }
            }, {
                key: "_calcualatesCompressedDataSize",
                value: function _calcualatesCompressedDataSize(format, width, height) {
                    switch (format) {
                        case exports.TextureFormat.DXT1:
                        case exports.TextureFormat.ETC1RGB:
                            return (width + 3 >> 2) * (height + 3 >> 2) * 8;
                        case exports.TextureFormat.DXT5:
                            return (width + 3 >> 2) * (height + 3 >> 2) * 16;
                        case exports.TextureFormat.PVRTCRGB_4BPPV:
                        case exports.TextureFormat.PVRTCRGBA_4BPPV:
                            return Math.floor((Math.max(width, 8) * Math.max(height, 8) * 4 + 7) / 8);
                        case exports.TextureFormat.PVRTCRGB_2BPPV:
                        case exports.TextureFormat.PVRTCRGBA_2BPPV:
                            return Math.floor((Math.max(width, 16) * Math.max(height, 8) * 2 + 7) / 8);
                        default:
                            return 0;
                    }
                }
            }, {
                key: "_pharseDDS",
                value: function _pharseDDS(arrayBuffer) {
                    var FOURCC_DXT1 = 827611204;
                    var FOURCC_DXT5 = 894720068;
                    var DDPF_FOURCC = 0x4;
                    var DDSD_MIPMAPCOUNT = 0x20000;
                    var DDS_MAGIC = 0x20534444;
                    var DDS_HEADER_LENGTH = 31;
                    var DDS_HEADER_MAGIC = 0;
                    var DDS_HEADER_SIZE = 1;
                    var DDS_HEADER_FLAGS = 2;
                    var DDS_HEADER_HEIGHT = 3;
                    var DDS_HEADER_WIDTH = 4;
                    var DDS_HEADER_MIPMAPCOUNT = 7;
                    var DDS_HEADER_PF_FLAGS = 20;
                    var DDS_HEADER_PF_FOURCC = 21;
                    var header = new Int32Array(arrayBuffer, 0, DDS_HEADER_LENGTH);
                    if (header[DDS_HEADER_MAGIC] != DDS_MAGIC)
                        throw "Invalid magic number in DDS header";
                    if (!(header[DDS_HEADER_PF_FLAGS] & DDPF_FOURCC))
                        throw "Unsupported format, must contain a FourCC code";
                    var compressedFormat = header[DDS_HEADER_PF_FOURCC];
                    switch (this._format) {
                        case exports.TextureFormat.DXT1:
                            if (compressedFormat !== FOURCC_DXT1)
                                throw "the FourCC code is not same with texture format.";
                            break;
                        case exports.TextureFormat.DXT5:
                            if (compressedFormat !== FOURCC_DXT5)
                                throw "the FourCC code is not same with texture format.";
                            break;
                        default:
                            throw "unknown texture format.";
                    }
                    var mipLevels = 1;
                    if (header[DDS_HEADER_FLAGS] & DDSD_MIPMAPCOUNT) {
                        mipLevels = Math.max(1, header[DDS_HEADER_MIPMAPCOUNT]);
                        if (!this._mipmap)
                            throw "the mipmap is not same with Texture2D.";
                    } else {
                        if (this._mipmap)
                            throw "the mipmap is not same with Texture2D.";
                    }
                    var width = header[DDS_HEADER_WIDTH];
                    var height = header[DDS_HEADER_HEIGHT];
                    this._width = width;
                    this._height = height;
                    var dataOffset = header[DDS_HEADER_SIZE] + 4;
                    this._upLoadCompressedTexImage2D(arrayBuffer, width, height, mipLevels, dataOffset, 0);
                }
            }, {
                key: "_pharseKTX",
                value: function _pharseKTX(arrayBuffer) {
                    var ETC_HEADER_LENGTH = 13;
                    var ETC_HEADER_FORMAT = 4;
                    var ETC_HEADER_HEIGHT = 7;
                    var ETC_HEADER_WIDTH = 6;
                    var ETC_HEADER_MIPMAPCOUNT = 11;
                    var ETC_HEADER_METADATA = 12;
                    var id = new Uint8Array(arrayBuffer, 0, 12);
                    if (id[0] != 0xAB || id[1] != 0x4B || id[2] != 0x54 || id[3] != 0x58 || id[4] != 0x20 || id[5] != 0x31 || id[6] != 0x31 || id[7] != 0xBB || id[8] != 0x0D || id[9] != 0x0A || id[10] != 0x1A || id[11] != 0x0A)
                        throw "Invalid fileIdentifier in KTX header";
                    var header = new Int32Array(id.buffer, id.length, ETC_HEADER_LENGTH);
                    var compressedFormat = header[ETC_HEADER_FORMAT];
                    switch (compressedFormat) {
                        case LayaGL.layaGPUInstance._compressedTextureEtc1.COMPRESSED_RGB_ETC1_WEBGL:
                            this._format = exports.TextureFormat.ETC1RGB;
                            break;
                        default:
                            throw "unknown texture format.";
                    }
                    var mipLevels = header[ETC_HEADER_MIPMAPCOUNT];
                    var width = header[ETC_HEADER_WIDTH];
                    var height = header[ETC_HEADER_HEIGHT];
                    this._width = width;
                    this._height = height;
                    var dataOffset = 64 + header[ETC_HEADER_METADATA];
                    this._upLoadCompressedTexImage2D(arrayBuffer, width, height, mipLevels, dataOffset, 4);
                }
            }, {
                key: "_pharsePVR",
                value: function _pharsePVR(arrayBuffer) {
                    var PVR_FORMAT_2BPP_RGB = 0;
                    var PVR_FORMAT_2BPP_RGBA = 1;
                    var PVR_FORMAT_4BPP_RGB = 2;
                    var PVR_FORMAT_4BPP_RGBA = 3;
                    var PVR_MAGIC = 0x03525650;
                    var PVR_HEADER_LENGTH = 13;
                    var PVR_HEADER_MAGIC = 0;
                    var PVR_HEADER_FORMAT = 2;
                    var PVR_HEADER_HEIGHT = 6;
                    var PVR_HEADER_WIDTH = 7;
                    var PVR_HEADER_MIPMAPCOUNT = 11;
                    var PVR_HEADER_METADATA = 12;
                    var header = new Int32Array(arrayBuffer, 0, PVR_HEADER_LENGTH);
                    if (header[PVR_HEADER_MAGIC] != PVR_MAGIC)
                        throw "Invalid magic number in PVR header";
                    var compressedFormat = header[PVR_HEADER_FORMAT];
                    switch (compressedFormat) {
                        case PVR_FORMAT_2BPP_RGB:
                            this._format = exports.TextureFormat.PVRTCRGB_2BPPV;
                            break;
                        case PVR_FORMAT_4BPP_RGB:
                            this._format = exports.TextureFormat.PVRTCRGB_4BPPV;
                            break;
                        case PVR_FORMAT_2BPP_RGBA:
                            this._format = exports.TextureFormat.PVRTCRGBA_2BPPV;
                            break;
                        case PVR_FORMAT_4BPP_RGBA:
                            this._format = exports.TextureFormat.PVRTCRGBA_4BPPV;
                            break;
                        default:
                            throw "Texture2D:unknown PVR format.";
                    }
                    var mipLevels = header[PVR_HEADER_MIPMAPCOUNT];
                    var width = header[PVR_HEADER_WIDTH];
                    var height = header[PVR_HEADER_HEIGHT];
                    this._width = width;
                    this._height = height;
                    var dataOffset = header[PVR_HEADER_METADATA] + 52;
                    this._upLoadCompressedTexImage2D(arrayBuffer, width, height, mipLevels, dataOffset, 0);
                }
            }, {
                key: "_upLoadCompressedTexImage2D",
                value: function _upLoadCompressedTexImage2D(data, width, height, miplevelCount, dataOffset, imageSizeOffset) {
                    var gl = LayaGL.instance;
                    var textureType = this._glTextureType;
                    WebGLContext.bindTexture(gl, textureType, this._glTexture);
                    var glFormat = this._getGLFormat();
                    var offset = dataOffset;
                    for (var i = 0; i < miplevelCount; i++) {
                        offset += imageSizeOffset;
                        var mipDataSize = this._calcualatesCompressedDataSize(this._format, width, height);
                        var mipData = new Uint8Array(data, offset, mipDataSize);
                        gl.compressedTexImage2D(textureType, i, glFormat, width, height, 0, mipData);
                        width = Math.max(width >> 1, 1.0);
                        height = Math.max(height >> 1, 1.0);
                        offset += mipDataSize;
                    }
                    var memory = offset;
                    this._setGPUMemory(memory);
                    this._readyed = true;
                    this._activeResource();
                }
            }, {
                key: "loadImageSource",
                value: function loadImageSource(source) {
                    var premultiplyAlpha = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var gl = LayaGL.instance;
                    var width = source.width;
                    var height = source.height;
                    this._width = width;
                    this._height = height;
                    if (!(this._isPot(width) && this._isPot(height)))
                        this._mipmap = false;
                    this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                    this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                    this._setFilterMode(this._filterMode);
                    WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    var glFormat = this._getGLFormat();
                    if (ILaya.Render.isConchApp) {
                        if (source.setPremultiplyAlpha) {
                            source.setPremultiplyAlpha(premultiplyAlpha);
                        }
                        gl.texImage2D(this._glTextureType, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, source);
                    } else {
                        premultiplyAlpha && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, true);
                        if (this.format == exports.TextureFormat.R5G6B5)
                            gl.texImage2D(this._glTextureType, 0, gl.RGB, gl.RGB, gl.UNSIGNED_SHORT_5_6_5, source);
                        else
                            gl.texImage2D(this._glTextureType, 0, glFormat, glFormat, gl.UNSIGNED_BYTE, source);
                        premultiplyAlpha && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
                    }
                    if (this._mipmap) {
                        gl.generateMipmap(this._glTextureType);
                        this._setGPUMemory(width * height * 4 * (1 + 1 / 3));
                    } else {
                        this._setGPUMemory(width * height * 4);
                    }
                    if (this._canRead) {
                        if (ILaya.Render.isConchApp) {
                            this._pixels = new Uint8Array(source._nativeObj.getImageData(0, 0, width, height));
                        } else {
                            ILaya.Browser.canvas.size(width, height);
                            ILaya.Browser.canvas.clear();
                            ILaya.Browser.context.drawImage(source, 0, 0, width, height);
                            this._pixels = new Uint8Array(ILaya.Browser.context.getImageData(0, 0, width, height).data.buffer);
                        }
                    }
                    this._readyed = true;
                    this._activeResource();
                }
            }, {
                key: "setPixels",
                value: function setPixels(pixels) {
                    var miplevel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    if (this._gpuCompressFormat())
                        throw "Texture2D:the format is GPU compression format.";
                    if (!pixels)
                        throw "Texture2D:pixels can't be null.";
                    var width = Math.max(this._width >> miplevel, 1);
                    var height = Math.max(this._height >> miplevel, 1);
                    var pixelsCount = width * height * this._getFormatByteCount();
                    if (pixels.length < pixelsCount)
                        throw "Texture2D:pixels length should at least " + pixelsCount + ".";
                    this._setPixels(pixels, miplevel, width, height);
                    if (this._canRead)
                        this._pixels = pixels;
                    this._readyed = true;
                    this._activeResource();
                }
            }, {
                key: "setSubPixels",
                value: function setSubPixels(x, y, width, height, pixels) {
                    var miplevel = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                    if (this._gpuCompressFormat())
                        throw "Texture2D:the format is GPU compression format.";
                    if (!pixels)
                        throw "Texture2D:pixels can't be null.";
                    var gl = LayaGL.instance;
                    var textureType = this._glTextureType;
                    WebGLContext.bindTexture(gl, textureType, this._glTexture);
                    var glFormat = this._getGLFormat();
                    switch (this.format) {
                        case exports.TextureFormat.R8G8B8:
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 1);
                            gl.texSubImage2D(textureType, miplevel, x, y, width, height, glFormat, gl.UNSIGNED_BYTE, pixels);
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 4);
                            break;
                        case exports.TextureFormat.R5G6B5:
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 2);
                            gl.texSubImage2D(textureType, miplevel, x, y, width, height, glFormat, gl.UNSIGNED_SHORT_5_6_5, pixels);
                            gl.pixelStorei(gl.UNPACK_ALIGNMENT, 4);
                            break;
                        case exports.TextureFormat.R32G32B32A32:
                            gl.texSubImage2D(textureType, miplevel, x, y, width, height, glFormat, gl.FLOAT, pixels);
                            break;
                        default:
                            gl.texSubImage2D(textureType, miplevel, x, y, width, height, glFormat, gl.UNSIGNED_BYTE, pixels);
                    }
                    this._readyed = true;
                    this._activeResource();
                }
            }, {
                key: "setCompressData",
                value: function setCompressData(data) {
                    switch (this._format) {
                        case exports.TextureFormat.DXT1:
                        case exports.TextureFormat.DXT5:
                            this._pharseDDS(data);
                            break;
                        case exports.TextureFormat.ETC1RGB:
                            this._pharseKTX(data);
                            break;
                        case exports.TextureFormat.PVRTCRGB_2BPPV:
                        case exports.TextureFormat.PVRTCRGBA_2BPPV:
                        case exports.TextureFormat.PVRTCRGB_4BPPV:
                        case exports.TextureFormat.PVRTCRGBA_4BPPV:
                            this._pharsePVR(data);
                            break;
                        default:
                            throw "Texture2D:unkonwn format.";
                    }
                }
            }, {
                key: "getPixels",
                value: function getPixels() {
                    if (this._canRead)
                        return this._pixels;
                    else
                        throw new Error("Texture2D: must set texture canRead is true.");
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    var pixels = new Uint8Array(3);
                    pixels[0] = 128;
                    pixels[1] = 128;
                    pixels[2] = 128;
                    Texture2D.grayTexture = new Texture2D(1, 1, exports.TextureFormat.R8G8B8, false, false);
                    Texture2D.grayTexture.setPixels(pixels);
                    Texture2D.grayTexture.lock = true;
                    pixels[0] = 255;
                    pixels[1] = 255;
                    pixels[2] = 255;
                    Texture2D.whiteTexture = new Texture2D(1, 1, exports.TextureFormat.R8G8B8, false, false);
                    Texture2D.whiteTexture.setPixels(pixels);
                    Texture2D.whiteTexture.lock = true;
                    pixels[0] = 0;
                    pixels[1] = 0;
                    pixels[2] = 0;
                    Texture2D.blackTexture = new Texture2D(1, 1, exports.TextureFormat.R8G8B8, false, false);
                    Texture2D.blackTexture.setPixels(pixels);
                    Texture2D.blackTexture.lock = true;
                }
            }, {
                key: "_parse",
                value: function _parse(data) {
                    var propertyParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var constructParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var texture = constructParams ? new Texture2D(constructParams[0], constructParams[1], constructParams[2], constructParams[3], constructParams[4]) : new Texture2D(0, 0);
                    if (propertyParams) {
                        texture.wrapModeU = propertyParams.wrapModeU;
                        texture.wrapModeV = propertyParams.wrapModeV;
                        texture.filterMode = propertyParams.filterMode;
                        texture.anisoLevel = propertyParams.anisoLevel;
                    }
                    switch (texture._format) {
                        case exports.TextureFormat.R8G8B8:
                        case exports.TextureFormat.R8G8B8A8:
                            texture.loadImageSource(data);
                            break;
                        case exports.TextureFormat.DXT1:
                        case exports.TextureFormat.DXT5:
                        case exports.TextureFormat.ETC1RGB:
                        case exports.TextureFormat.PVRTCRGB_2BPPV:
                        case exports.TextureFormat.PVRTCRGBA_2BPPV:
                        case exports.TextureFormat.PVRTCRGB_4BPPV:
                        case exports.TextureFormat.PVRTCRGBA_4BPPV:
                            texture.setCompressData(data);
                            break;
                        default:
                            throw "Texture2D:unkonwn format.";
                    }
                    return texture;
                }
            }, {
                key: "load",
                value: function load(url, complete) {
                    ILaya.loader.create(url, complete, null, ILaya.Loader.TEXTURE2D);
                }
            }]);
            return Texture2D;
        }(BaseTexture);
    Texture2D.TEXTURE2D = "TEXTURE2D";
    Texture2D.grayTexture = null;
    Texture2D.whiteTexture = null;
    Texture2D.blackTexture = null;
    var BaseShader = /*#__PURE__*/
        function (_Resource2) {
            _inherits(BaseShader, _Resource2);
            var _super6 = _createSuper(BaseShader);
            function BaseShader() {
                _classCallCheck(this, BaseShader);
                return _super6.call(this);
            }
            return _createClass(BaseShader);
        }(Resource);
    var RenderState2D = /*#__PURE__*/
        function () {
            function RenderState2D() {
                _classCallCheck(this, RenderState2D);
            }
            _createClass(RenderState2D, null, [{
                key: "mat2MatArray",
                value: function mat2MatArray(mat, matArray) {
                    var m = mat;
                    var m4 = matArray;
                    m4[0] = m.a;
                    m4[1] = m.b;
                    m4[2] = RenderState2D.EMPTYMAT4_ARRAY[2];
                    m4[3] = RenderState2D.EMPTYMAT4_ARRAY[3];
                    m4[4] = m.c;
                    m4[5] = m.d;
                    m4[6] = RenderState2D.EMPTYMAT4_ARRAY[6];
                    m4[7] = RenderState2D.EMPTYMAT4_ARRAY[7];
                    m4[8] = RenderState2D.EMPTYMAT4_ARRAY[8];
                    m4[9] = RenderState2D.EMPTYMAT4_ARRAY[9];
                    m4[10] = RenderState2D.EMPTYMAT4_ARRAY[10];
                    m4[11] = RenderState2D.EMPTYMAT4_ARRAY[11];
                    m4[12] = m.tx;
                    m4[13] = m.ty;
                    m4[14] = RenderState2D.EMPTYMAT4_ARRAY[14];
                    m4[15] = RenderState2D.EMPTYMAT4_ARRAY[15];
                    return matArray;
                }
            }, {
                key: "restoreTempArray",
                value: function restoreTempArray() {
                    RenderState2D.TEMPMAT4_ARRAY[0] = 1;
                    RenderState2D.TEMPMAT4_ARRAY[1] = 0;
                    RenderState2D.TEMPMAT4_ARRAY[4] = 0;
                    RenderState2D.TEMPMAT4_ARRAY[5] = 1;
                    RenderState2D.TEMPMAT4_ARRAY[12] = 0;
                    RenderState2D.TEMPMAT4_ARRAY[13] = 0;
                }
            }, {
                key: "clear",
                value: function clear() {
                    RenderState2D.worldScissorTest = false;
                    RenderState2D.worldAlpha = 1;
                }
            }]);
            return RenderState2D;
        }();
    RenderState2D._MAXSIZE = 99999999;
    RenderState2D.EMPTYMAT4_ARRAY = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
    RenderState2D.TEMPMAT4_ARRAY = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
    RenderState2D.worldMatrix4 = RenderState2D.TEMPMAT4_ARRAY;
    RenderState2D.worldMatrix = new Matrix();
    RenderState2D.matWVP = null;
    RenderState2D.worldAlpha = 1.0;
    RenderState2D.worldScissorTest = false;
    RenderState2D.width = 0;
    RenderState2D.height = 0;
    (function (RenderTextureFormat) {
        RenderTextureFormat[RenderTextureFormat["R8G8B8"] = 0] = "R8G8B8";
        RenderTextureFormat[RenderTextureFormat["R8G8B8A8"] = 1] = "R8G8B8A8";
        RenderTextureFormat[RenderTextureFormat["Alpha8"] = 2] = "Alpha8";
        RenderTextureFormat[RenderTextureFormat["R16G16B16A16"] = 14] = "R16G16B16A16";
        RenderTextureFormat[RenderTextureFormat["Depth"] = 15] = "Depth";
        RenderTextureFormat[RenderTextureFormat["ShadowMap"] = 16] = "ShadowMap";
    }
    )(exports.RenderTextureFormat || (exports.RenderTextureFormat = {}));
    (function (RenderTextureDepthFormat) {
        RenderTextureDepthFormat[RenderTextureDepthFormat["DEPTH_16"] = 0] = "DEPTH_16";
        RenderTextureDepthFormat[RenderTextureDepthFormat["STENCIL_8"] = 1] = "STENCIL_8";
        RenderTextureDepthFormat[RenderTextureDepthFormat["DEPTHSTENCIL_24_8"] = 2] = "DEPTHSTENCIL_24_8";
        RenderTextureDepthFormat[RenderTextureDepthFormat["DEPTHSTENCIL_NONE"] = 3] = "DEPTHSTENCIL_NONE";
        RenderTextureDepthFormat[RenderTextureDepthFormat["DEPTHSTENCIL_16_8"] = 2] = "DEPTHSTENCIL_16_8";
    }
    )(exports.RenderTextureDepthFormat || (exports.RenderTextureDepthFormat = {}));
    var RenderTexture2D = /*#__PURE__*/
        function (_BaseTexture2) {
            _inherits(RenderTexture2D, _BaseTexture2);
            var _super7 = _createSuper(RenderTexture2D);
            function RenderTexture2D(width, height) {
                var _this6;
                var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : exports.RenderTextureFormat.R8G8B8;
                var depthStencilFormat = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : exports.RenderTextureDepthFormat.DEPTH_16;
                _classCallCheck(this, RenderTexture2D);
                _this6 = _super7.call(this, format, false);
                _this6._mgrKey = 0;
                _this6._glTextureType = LayaGL.instance.TEXTURE_2D;
                _this6._width = width;
                _this6._height = height;
                _this6._depthStencilFormat = depthStencilFormat;
                _this6._create(width, height);
                _this6.lock = true;
                return _this6;
            }
            _createClass(RenderTexture2D, [{
                key: "depthStencilFormat",
                get: function get() {
                    return this._depthStencilFormat;
                }
            }, {
                key: "defaulteTexture",
                get: function get() {
                    return Texture2D.grayTexture;
                }
            }, {
                key: "getIsReady",
                value: function getIsReady() {
                    return true;
                }
            }, {
                key: "sourceWidth",
                get: function get() {
                    return this._width;
                }
            }, {
                key: "sourceHeight",
                get: function get() {
                    return this._height;
                }
            }, {
                key: "offsetX",
                get: function get() {
                    return 0;
                }
            }, {
                key: "offsetY",
                get: function get() {
                    return 0;
                }
            }, {
                key: "_create",
                value: function _create(width, height) {
                    var gl = LayaGL.instance;
                    this._frameBuffer = gl.createFramebuffer();
                    WebGLContext.bindTexture(gl, this._glTextureType, this._glTexture);
                    var glFormat = this._getGLFormat();
                    gl.texImage2D(this._glTextureType, 0, glFormat, width, height, 0, glFormat, gl.UNSIGNED_BYTE, null);
                    this._setGPUMemory(width * height * 4);
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, this._glTexture, 0);
                    if (this._depthStencilFormat !== exports.RenderTextureDepthFormat.DEPTHSTENCIL_NONE) {
                        this._depthStencilBuffer = gl.createRenderbuffer();
                        gl.bindRenderbuffer(gl.RENDERBUFFER, this._depthStencilBuffer);
                        switch (this._depthStencilFormat) {
                            case exports.RenderTextureDepthFormat.DEPTH_16:
                                gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_COMPONENT16, width, height);
                                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                                break;
                            case exports.RenderTextureDepthFormat.STENCIL_8:
                                gl.renderbufferStorage(gl.RENDERBUFFER, gl.STENCIL_INDEX8, width, height);
                                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                                break;
                            case exports.RenderTextureDepthFormat.DEPTHSTENCIL_24_8:
                                gl.renderbufferStorage(gl.RENDERBUFFER, gl.DEPTH_STENCIL, width, height);
                                gl.framebufferRenderbuffer(gl.FRAMEBUFFER, gl.DEPTH_STENCIL_ATTACHMENT, gl.RENDERBUFFER, this._depthStencilBuffer);
                                break;
                            default:
                        }
                    }
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                    gl.bindRenderbuffer(gl.RENDERBUFFER, null);
                    this._setWarpMode(gl.TEXTURE_WRAP_S, this._wrapModeU);
                    this._setWarpMode(gl.TEXTURE_WRAP_T, this._wrapModeV);
                    this._setFilterMode(this._filterMode);
                    this._setAnisotropy(this._anisoLevel);
                    this._readyed = true;
                    this._activeResource();
                }
            }, {
                key: "generateMipmap",
                value: function generateMipmap() {
                    if (this._isPot(this.width) && this._isPot(this.height)) {
                        this._mipmap = true;
                        LayaGL.instance.generateMipmap(this._glTextureType);
                        this._setFilterMode(this._filterMode);
                        this._setGPUMemory(this.width * this.height * 4 * (1 + 1 / 3));
                    } else {
                        this._mipmap = false;
                        this._setGPUMemory(this.width * this.height * 4);
                    }
                }
            }, {
                key: "start",
                value: function start() {
                    var gl = LayaGL.instance;
                    LayaGL.instance.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    this._lastRT = RenderTexture2D._currentActive;
                    RenderTexture2D._currentActive = this;
                    this._readyed = true;
                    gl.viewport(0, 0, this._width, this._height);
                    this._lastWidth = RenderState2D.width;
                    this._lastHeight = RenderState2D.height;
                    RenderState2D.width = this._width;
                    RenderState2D.height = this._height;
                    BaseShader.activeShader = null;
                }
            }, {
                key: "end",
                value: function end() {
                    var gl = LayaGL.instance;
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                    RenderTexture2D._currentActive = null;
                    this._readyed = true;
                }
            }, {
                key: "restore",
                value: function restore() {
                    var gl = LayaGL.instance;
                    if (this._lastRT != RenderTexture2D._currentActive) {
                        LayaGL.instance.bindFramebuffer(gl.FRAMEBUFFER, this._lastRT ? this._lastRT._frameBuffer : null);
                        RenderTexture2D._currentActive = this._lastRT;
                    }
                    this._readyed = true;
                    gl.viewport(0, 0, this._lastWidth, this._lastHeight);
                    RenderState2D.width = this._lastWidth;
                    RenderState2D.height = this._lastHeight;
                    BaseShader.activeShader = null;
                }
            }, {
                key: "clear",
                value: function clear() {
                    var r = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.0;
                    var g = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.0;
                    var b = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0.0;
                    var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1.0;
                    var gl = LayaGL.instance;
                    gl.clearColor(r, g, b, a);
                    var clearFlag = gl.COLOR_BUFFER_BIT;
                    switch (this._depthStencilFormat) {
                        case gl.DEPTH_COMPONENT16:
                            clearFlag |= gl.DEPTH_BUFFER_BIT;
                            break;
                        case gl.STENCIL_INDEX8:
                            clearFlag |= gl.STENCIL_BUFFER_BIT;
                            break;
                        case gl.DEPTH_STENCIL:
                            clearFlag |= gl.DEPTH_BUFFER_BIT;
                            clearFlag |= gl.STENCIL_BUFFER_BIT;
                            break;
                    }
                    gl.clear(clearFlag);
                }
            }, {
                key: "getData",
                value: function getData(x, y, width, height) {
                    if (ILaya.Render.isConchApp && window.conchConfig.threadMode == 2) {
                        throw "native 2 thread mode use getDataAsync";
                    }
                    var gl = LayaGL.instance;
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    var canRead = gl.checkFramebufferStatus(gl.FRAMEBUFFER) === gl.FRAMEBUFFER_COMPLETE;
                    if (!canRead) {
                        gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                        return null;
                    }
                    var pixels = new Uint8Array(this._width * this._height * 4);
                    var glFormat = this._getGLFormat();
                    gl.readPixels(x, y, width, height, glFormat, gl.UNSIGNED_BYTE, pixels);
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                    return pixels;
                }
            }, {
                key: "getDataAsync",
                value: function getDataAsync(x, y, width, height, callBack) {
                    var gl = LayaGL.instance;
                    gl.bindFramebuffer(gl.FRAMEBUFFER, this._frameBuffer);
                    gl.readPixelsAsync(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, function (data) {
                        callBack(new Uint8Array(data));
                    });
                    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
                }
            }, {
                key: "recycle",
                value: function recycle() { }
            }, {
                key: "_disposeResource",
                value: function _disposeResource() {
                    if (this._frameBuffer) {
                        var gl = LayaGL.instance;
                        gl.deleteTexture(this._glTexture);
                        gl.deleteFramebuffer(this._frameBuffer);
                        gl.deleteRenderbuffer(this._depthStencilBuffer);
                        this._glTexture = null;
                        this._frameBuffer = null;
                        this._depthStencilBuffer = null;
                        this._setGPUMemory(0);
                    }
                }
            }], [{
                key: "currentActive",
                get: function get() {
                    return RenderTexture2D._currentActive;
                }
            }, {
                key: "pushRT",
                value: function pushRT() {
                    RenderTexture2D.rtStack.push({
                        rt: RenderTexture2D._currentActive,
                        w: RenderState2D.width,
                        h: RenderState2D.height
                    });
                }
            }, {
                key: "popRT",
                value: function popRT() {
                    var gl = LayaGL.instance;
                    var top = RenderTexture2D.rtStack.pop();
                    if (top) {
                        if (RenderTexture2D._currentActive != top.rt) {
                            LayaGL.instance.bindFramebuffer(gl.FRAMEBUFFER, top.rt ? top.rt._frameBuffer : null);
                            RenderTexture2D._currentActive = top.rt;
                        }
                        gl.viewport(0, 0, top.w, top.h);
                        RenderState2D.width = top.w;
                        RenderState2D.height = top.h;
                    }
                }
            }]);
            return RenderTexture2D;
        }(BaseTexture);
    RenderTexture2D.rtStack = [];
    RenderTexture2D.defuv = [0, 0, 1, 0, 1, 1, 0, 1];
    RenderTexture2D.flipyuv = [0, 1, 1, 1, 1, 0, 0, 0];
    var WebGLRTMgr = /*#__PURE__*/
        function () {
            function WebGLRTMgr() {
                _classCallCheck(this, WebGLRTMgr);
            }
            _createClass(WebGLRTMgr, null, [{
                key: "getRT",
                value: function getRT(w, h) {
                    w = w | 0;
                    h = h | 0;
                    if (w >= 10000) {
                        console.error('getRT error! w too big');
                    }
                    var ret;
                    ret = new RenderTexture2D(w, h, exports.RenderTextureFormat.R8G8B8A8, -1);
                    return ret;
                }
            }, {
                key: "releaseRT",
                value: function releaseRT(rt) {
                    rt.destroy();
                    return;
                }
            }]);
            return WebGLRTMgr;
        }();
    WebGLRTMgr.dict = {};
    var BlendMode = /*#__PURE__*/
        function () {
            function BlendMode() {
                _classCallCheck(this, BlendMode);
            }
            _createClass(BlendMode, null, [{
                key: "_init_",
                value: function _init_(gl) {
                    BlendMode.fns = [BlendMode.BlendNormal, BlendMode.BlendAdd, BlendMode.BlendMultiply, BlendMode.BlendScreen, BlendMode.BlendOverlay, BlendMode.BlendLight, BlendMode.BlendMask, BlendMode.BlendDestinationOut];
                    BlendMode.targetFns = [BlendMode.BlendNormalTarget, BlendMode.BlendAddTarget, BlendMode.BlendMultiplyTarget, BlendMode.BlendScreenTarget, BlendMode.BlendOverlayTarget, BlendMode.BlendLightTarget, BlendMode.BlendMask, BlendMode.BlendDestinationOut];
                }
            }, {
                key: "BlendNormal",
                value: function BlendNormal(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE_MINUS_SRC_ALPHA, true);
                }
            }, {
                key: "BlendAdd",
                value: function BlendAdd(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.DST_ALPHA, true);
                }
            }, {
                key: "BlendMultiply",
                value: function BlendMultiply(gl) {
                    WebGLContext.setBlendFunc(gl, gl.DST_COLOR, gl.ONE_MINUS_SRC_ALPHA, true);
                }
            }, {
                key: "BlendScreen",
                value: function BlendScreen(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE, true);
                }
            }, {
                key: "BlendOverlay",
                value: function BlendOverlay(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE_MINUS_SRC_COLOR, true);
                }
            }, {
                key: "BlendLight",
                value: function BlendLight(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE, true);
                }
            }, {
                key: "BlendNormalTarget",
                value: function BlendNormalTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE_MINUS_SRC_ALPHA, true);
                }
            }, {
                key: "BlendAddTarget",
                value: function BlendAddTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.DST_ALPHA, true);
                }
            }, {
                key: "BlendMultiplyTarget",
                value: function BlendMultiplyTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.DST_COLOR, gl.ONE_MINUS_SRC_ALPHA, true);
                }
            }, {
                key: "BlendScreenTarget",
                value: function BlendScreenTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE, true);
                }
            }, {
                key: "BlendOverlayTarget",
                value: function BlendOverlayTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE_MINUS_SRC_COLOR, true);
                }
            }, {
                key: "BlendLightTarget",
                value: function BlendLightTarget(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE, true);
                }
            }, {
                key: "BlendMask",
                value: function BlendMask(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ZERO, gl.SRC_ALPHA, true);
                }
            }, {
                key: "BlendDestinationOut",
                value: function BlendDestinationOut(gl) {
                    WebGLContext.setBlendFunc(gl, gl.ZERO, gl.ZERO, true);
                }
            }]);
            return BlendMode;
        }();
    BlendMode.activeBlendFunction = null;
    BlendMode.NAMES = ["normal", "add", "multiply", "screen", "overlay", "light", "mask", "destination-out"];
    BlendMode.TOINT = {
        "normal": 0,
        "add": 1,
        "multiply": 2,
        "screen": 3,
        "overlay": 4,
        "light": 5,
        "mask": 6,
        "destination-out": 7,
        "lighter": 1
    };
    BlendMode.NORMAL = "normal";
    BlendMode.ADD = "add";
    BlendMode.MULTIPLY = "multiply";
    BlendMode.SCREEN = "screen";
    BlendMode.OVERLAY = "overlay";
    BlendMode.LIGHT = "light";
    BlendMode.MASK = "mask";
    BlendMode.DESTINATIONOUT = "destination-out";
    BlendMode.LIGHTER = "lighter";
    BlendMode.fns = [];
    BlendMode.targetFns = [];
    var ShaderDefinesBase = /*#__PURE__*/
        function () {
            function ShaderDefinesBase(name2int, int2name, int2nameMap) {
                _classCallCheck(this, ShaderDefinesBase);
                this._value = 0;
                this._name2int = name2int;
                this._int2name = int2name;
                this._int2nameMap = int2nameMap;
            }
            _createClass(ShaderDefinesBase, [{
                key: "add",
                value: function add(value) {
                    if (typeof value == 'string') {
                        this._value |= this._name2int[value];
                    } else {
                        this._value |= value;
                    }
                    return this._value;
                }
            }, {
                key: "addInt",
                value: function addInt(value) {
                    this._value |= value;
                    return this._value;
                }
            }, {
                key: "remove",
                value: function remove(value) {
                    if (typeof value == 'string') {
                        this._value &= ~this._name2int[value];
                    } else {
                        this._value &= ~value;
                    }
                    return this._value;
                }
            }, {
                key: "isDefine",
                value: function isDefine(def) {
                    return (this._value & def) === def;
                }
            }, {
                key: "getValue",
                value: function getValue() {
                    return this._value;
                }
            }, {
                key: "setValue",
                value: function setValue(value) {
                    this._value = value;
                }
            }, {
                key: "toNameDic",
                value: function toNameDic() {
                    var r = this._int2nameMap[this._value];
                    return r ? r : ShaderDefinesBase._toText(this._value, this._int2name, this._int2nameMap);
                }
            }], [{
                key: "_reg",
                value: function _reg(name, value, _name2int, _int2name) {
                    _name2int[name] = value;
                    _int2name[value] = name;
                }
            }, {
                key: "_toText",
                value: function _toText(value, _int2name, _int2nameMap) {
                    var r = _int2nameMap[value];
                    if (r)
                        return r;
                    var o = {};
                    var d = 1;
                    for (var i = 0; i < 32; i++) {
                        d = 1 << i;
                        if (d > value)
                            break;
                        if (value & d) {
                            var name = _int2name[d];
                            name && (o[name] = "");
                        }
                    }
                    _int2nameMap[value] = o;
                    return o;
                }
            }, {
                key: "_toInt",
                value: function _toInt(names, _name2int) {
                    var words = names.split('.');
                    var num = 0;
                    for (var i = 0, n = words.length; i < n; i++) {
                        var value = _name2int[words[i]];
                        if (!value)
                            throw new Error("Defines to int err:" + names + "/" + words[i]);
                        num |= value;
                    }
                    return num;
                }
            }]);
            return ShaderDefinesBase;
        }();
    var ShaderDefines2D = /*#__PURE__*/
        function (_ShaderDefinesBase) {
            _inherits(ShaderDefines2D, _ShaderDefinesBase);
            var _super8 = _createSuper(ShaderDefines2D);
            function ShaderDefines2D() {
                _classCallCheck(this, ShaderDefines2D);
                return _super8.call(this, ShaderDefines2D.__name2int, ShaderDefines2D.__int2name, ShaderDefines2D.__int2nameMap);
            }
            _createClass(ShaderDefines2D, null, [{
                key: "__init__",
                value: function __init__() {
                    ShaderDefines2D.reg("TEXTURE2D", ShaderDefines2D.TEXTURE2D);
                    ShaderDefines2D.reg("PRIMITIVE", ShaderDefines2D.PRIMITIVE);
                    ShaderDefines2D.reg("GLOW_FILTER", ShaderDefines2D.FILTERGLOW);
                    ShaderDefines2D.reg("BLUR_FILTER", ShaderDefines2D.FILTERBLUR);
                    ShaderDefines2D.reg("COLOR_FILTER", ShaderDefines2D.FILTERCOLOR);
                    ShaderDefines2D.reg("COLOR_ADD", ShaderDefines2D.COLORADD);
                    ShaderDefines2D.reg("WORLDMAT", ShaderDefines2D.WORLDMAT);
                    ShaderDefines2D.reg("FILLTEXTURE", ShaderDefines2D.FILLTEXTURE);
                    ShaderDefines2D.reg('MVP3D', ShaderDefines2D.MVP3D);
                }
            }, {
                key: "reg",
                value: function reg(name, value) {
                    this._reg(name, value, ShaderDefines2D.__name2int, ShaderDefines2D.__int2name);
                }
            }, {
                key: "toText",
                value: function toText(value, int2name, int2nameMap) {
                    return this._toText(value, int2name, int2nameMap);
                }
            }, {
                key: "toInt",
                value: function toInt(names) {
                    return this._toInt(names, ShaderDefines2D.__name2int);
                }
            }]);
            return ShaderDefines2D;
        }(ShaderDefinesBase);
    ShaderDefines2D.TEXTURE2D = 0x01;
    ShaderDefines2D.PRIMITIVE = 0x04;
    ShaderDefines2D.FILTERGLOW = 0x08;
    ShaderDefines2D.FILTERBLUR = 0x10;
    ShaderDefines2D.FILTERCOLOR = 0x20;
    ShaderDefines2D.COLORADD = 0x40;
    ShaderDefines2D.WORLDMAT = 0x80;
    ShaderDefines2D.FILLTEXTURE = 0x100;
    ShaderDefines2D.SKINMESH = 0x200;
    ShaderDefines2D.MVP3D = 0x800;
    ShaderDefines2D.NOOPTMASK = ShaderDefines2D.FILTERGLOW | ShaderDefines2D.FILTERBLUR | ShaderDefines2D.FILTERCOLOR | ShaderDefines2D.FILLTEXTURE;
    ShaderDefines2D.__name2int = {};
    ShaderDefines2D.__int2name = [];
    ShaderDefines2D.__int2nameMap = [];
    var Stat = /*#__PURE__*/
        function () {
            function Stat() {
                _classCallCheck(this, Stat);
            }
            _createClass(Stat, null, [{
                key: "show",
                value: function show() {
                    var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    Stat._StatRender.show(x, y);
                }
            }, {
                key: "enable",
                value: function enable() {
                    Stat._StatRender.enable();
                }
            }, {
                key: "hide",
                value: function hide() {
                    Stat._StatRender.hide();
                }
            }, {
                key: "clear",
                value: function clear() {
                    Stat.trianglesFaces = Stat.renderBatches = Stat.savedRenderBatches = Stat.shaderCall = Stat.spriteRenderUseCacheCount = Stat.frustumCulling = Stat.octreeNodeCulling = Stat.canvasNormal = Stat.canvasBitmap = Stat.canvasReCache = 0;
                }
            }, {
                key: "onclick",
                set: function set(fn) {
                    Stat._StatRender.set_onclick(fn);
                }
            }]);
            return Stat;
        }();
    Stat.FPS = 0;
    Stat.loopCount = 0;
    Stat.shaderCall = 0;
    Stat.renderBatches = 0;
    Stat.savedRenderBatches = 0;
    Stat.trianglesFaces = 0;
    Stat.spriteCount = 0;
    Stat.spriteRenderUseCacheCount = 0;
    Stat.frustumCulling = 0;
    Stat.octreeNodeCulling = 0;
    Stat.canvasNormal = 0;
    Stat.canvasBitmap = 0;
    Stat.canvasReCache = 0;
    Stat.renderSlow = false;
    Stat._fpsData = [];
    Stat._timer = 0;
    Stat._count = 0;
    Stat._StatRender = null;
    var StringKey = /*#__PURE__*/
        function () {
            function StringKey() {
                _classCallCheck(this, StringKey);
                this._strsToID = {};
                this._idToStrs = [];
                this._length = 0;
            }
            _createClass(StringKey, [{
                key: "add",
                value: function add(str) {
                    var index = this._strsToID[str];
                    if (index != null)
                        return index;
                    this._idToStrs[this._length] = str;
                    return this._strsToID[str] = this._length++;
                }
            }, {
                key: "getID",
                value: function getID(str) {
                    var index = this._strsToID[str];
                    return index == null ? -1 : index;
                }
            }, {
                key: "getName",
                value: function getName(id) {
                    var str = this._idToStrs[id];
                    return str == null ? undefined : str;
                }
            }]);
            return StringKey;
        }();
    var Shader = /*#__PURE__*/
        function (_BaseShader) {
            _inherits(Shader, _BaseShader);
            var _super9 = _createSuper(Shader);
            function Shader(vs, ps) {
                var _this7;
                var saveName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var nameMap = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var bindAttrib = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                _classCallCheck(this, Shader);
                _this7 = _super9.call(this);
                _this7._attribInfo = null;
                _this7.customCompile = false;
                _this7._curActTexIndex = 0;
                _this7.tag = {};
                _this7._program = null;
                _this7._params = null;
                _this7._paramsMap = {};
                if (!vs || !ps)
                    throw "Shader Error";
                _this7._attribInfo = bindAttrib;
                _this7._id = ++Shader._count;
                _this7._vs = vs;
                _this7._ps = ps;
                _this7._nameMap = nameMap ? nameMap : {};
                saveName != null && (Shader.sharders[saveName] = _assertThisInitialized(_this7));
                _this7.recreateResource();
                _this7.lock = true;
                return _this7;
            }
            _createClass(Shader, [{
                key: "recreateResource",
                value: function recreateResource() {
                    this._compile();
                    this._setGPUMemory(0);
                }
            }, {
                key: "_disposeResource",
                value: function _disposeResource() {
                    WebGLContext.mainContext.deleteShader(this._vshader);
                    WebGLContext.mainContext.deleteShader(this._pshader);
                    WebGLContext.mainContext.deleteProgram(this._program);
                    this._vshader = this._pshader = this._program = null;
                    this._params = null;
                    this._paramsMap = {};
                    this._setGPUMemory(0);
                    this._curActTexIndex = 0;
                }
            }, {
                key: "_compile",
                value: function _compile() {
                    if (!this._vs || !this._ps || this._params)
                        return;
                    this._reCompile = true;
                    this._params = [];
                    var result;
                    if (this.customCompile)
                        result = ILaya.ShaderCompile.preGetParams(this._vs, this._ps);
                    var gl = WebGLContext.mainContext;
                    this._program = gl.createProgram();
                    this._vshader = Shader._createShader(gl, this._vs, gl.VERTEX_SHADER);
                    this._pshader = Shader._createShader(gl, this._ps, gl.FRAGMENT_SHADER);
                    gl.attachShader(this._program, this._vshader);
                    gl.attachShader(this._program, this._pshader);
                    var one, i, n, location;
                    var attribDescNum = this._attribInfo ? this._attribInfo.length : 0;
                    for (i = 0; i < attribDescNum; i += 2) {
                        gl.bindAttribLocation(this._program, this._attribInfo[i + 1], this._attribInfo[i]);
                    }
                    gl.linkProgram(this._program);
                    if (!this.customCompile && !gl.getProgramParameter(this._program, gl.LINK_STATUS)) {
                        throw gl.getProgramInfoLog(this._program);
                    }
                    var nUniformNum = this.customCompile ? result.uniforms.length : gl.getProgramParameter(this._program, gl.ACTIVE_UNIFORMS);
                    for (i = 0; i < nUniformNum; i++) {
                        var uniform = this.customCompile ? result.uniforms[i] : gl.getActiveUniform(this._program, i);
                        location = gl.getUniformLocation(this._program, uniform.name);
                        one = {
                            vartype: "uniform",
                            glfun: null,
                            ivartype: 1,
                            location: location,
                            name: uniform.name,
                            type: uniform.type,
                            isArray: false,
                            isSame: false,
                            preValue: null,
                            indexOfParams: 0
                        };
                        if (one.name.indexOf('[0]') > 0) {
                            one.name = one.name.substr(0, one.name.length - 3);
                            one.isArray = true;
                            one.location = gl.getUniformLocation(this._program, one.name);
                        }
                        this._params.push(one);
                    }
                    for (i = 0,
                        n = this._params.length; i < n; i++) {
                        one = this._params[i];
                        one.indexOfParams = i;
                        one.index = 1;
                        one.value = [one.location, null];
                        one.codename = one.name;
                        one.name = this._nameMap[one.codename] ? this._nameMap[one.codename] : one.codename;
                        this._paramsMap[one.name] = one;
                        one._this = this;
                        one.uploadedValue = [];
                        switch (one.type) {
                            case gl.INT:
                                one.fun = one.isArray ? this._uniform1iv : this._uniform1i;
                                break;
                            case gl.FLOAT:
                                one.fun = one.isArray ? this._uniform1fv : this._uniform1f;
                                break;
                            case gl.FLOAT_VEC2:
                                one.fun = one.isArray ? this._uniform_vec2v : this._uniform_vec2;
                                break;
                            case gl.FLOAT_VEC3:
                                one.fun = one.isArray ? this._uniform_vec3v : this._uniform_vec3;
                                break;
                            case gl.FLOAT_VEC4:
                                one.fun = one.isArray ? this._uniform_vec4v : this._uniform_vec4;
                                break;
                            case gl.SAMPLER_2D:
                                one.fun = this._uniform_sampler2D;
                                break;
                            case gl.SAMPLER_CUBE:
                                one.fun = this._uniform_samplerCube;
                                break;
                            case gl.FLOAT_MAT4:
                                one.glfun = gl.uniformMatrix4fv;
                                one.fun = this._uniformMatrix4fv;
                                break;
                            case gl.BOOL:
                                one.fun = this._uniform1i;
                                break;
                            case gl.FLOAT_MAT2:
                            case gl.FLOAT_MAT3:
                                throw new Error("compile shader err!");
                            default:
                                throw new Error("compile shader err!");
                        }
                    }
                }
            }, {
                key: "getUniform",
                value: function getUniform(name) {
                    return this._paramsMap[name];
                }
            }, {
                key: "_uniform1f",
                value: function _uniform1f(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value) {
                        WebGLContext.mainContext.uniform1f(one.location, uploadedValue[0] = value);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform1fv",
                value: function _uniform1fv(one, value) {
                    if (value.length < 4) {
                        var uploadedValue = one.uploadedValue;
                        if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                            WebGLContext.mainContext.uniform1fv(one.location, value);
                            uploadedValue[0] = value[0];
                            uploadedValue[1] = value[1];
                            uploadedValue[2] = value[2];
                            uploadedValue[3] = value[3];
                            return 1;
                        }
                        return 0;
                    } else {
                        WebGLContext.mainContext.uniform1fv(one.location, value);
                        return 1;
                    }
                }
            }, {
                key: "_uniform_vec2",
                value: function _uniform_vec2(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1]) {
                        WebGLContext.mainContext.uniform2f(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_vec2v",
                value: function _uniform_vec2v(one, value) {
                    if (value.length < 2) {
                        var uploadedValue = one.uploadedValue;
                        if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                            WebGLContext.mainContext.uniform2fv(one.location, value);
                            uploadedValue[0] = value[0];
                            uploadedValue[1] = value[1];
                            uploadedValue[2] = value[2];
                            uploadedValue[3] = value[3];
                            return 1;
                        }
                        return 0;
                    } else {
                        WebGLContext.mainContext.uniform2fv(one.location, value);
                        return 1;
                    }
                }
            }, {
                key: "_uniform_vec3",
                value: function _uniform_vec3(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2]) {
                        WebGLContext.mainContext.uniform3f(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_vec3v",
                value: function _uniform_vec3v(one, value) {
                    WebGLContext.mainContext.uniform3fv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniform_vec4",
                value: function _uniform_vec4(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                        WebGLContext.mainContext.uniform4f(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2], uploadedValue[3] = value[3]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_vec4v",
                value: function _uniform_vec4v(one, value) {
                    WebGLContext.mainContext.uniform4fv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniformMatrix2fv",
                value: function _uniformMatrix2fv(one, value) {
                    WebGLContext.mainContext.uniformMatrix2fv(one.location, false, value);
                    return 1;
                }
            }, {
                key: "_uniformMatrix3fv",
                value: function _uniformMatrix3fv(one, value) {
                    WebGLContext.mainContext.uniformMatrix3fv(one.location, false, value);
                    return 1;
                }
            }, {
                key: "_uniformMatrix4fv",
                value: function _uniformMatrix4fv(one, value) {
                    WebGLContext.mainContext.uniformMatrix4fv(one.location, false, value);
                    return 1;
                }
            }, {
                key: "_uniform1i",
                value: function _uniform1i(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value) {
                        WebGLContext.mainContext.uniform1i(one.location, uploadedValue[0] = value);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform1iv",
                value: function _uniform1iv(one, value) {
                    WebGLContext.mainContext.uniform1iv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniform_ivec2",
                value: function _uniform_ivec2(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1]) {
                        WebGLContext.mainContext.uniform2i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_ivec2v",
                value: function _uniform_ivec2v(one, value) {
                    WebGLContext.mainContext.uniform2iv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniform_vec3i",
                value: function _uniform_vec3i(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2]) {
                        WebGLContext.mainContext.uniform3i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_vec3vi",
                value: function _uniform_vec3vi(one, value) {
                    WebGLContext.mainContext.uniform3iv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniform_vec4i",
                value: function _uniform_vec4i(one, value) {
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] !== value[0] || uploadedValue[1] !== value[1] || uploadedValue[2] !== value[2] || uploadedValue[3] !== value[3]) {
                        WebGLContext.mainContext.uniform4i(one.location, uploadedValue[0] = value[0], uploadedValue[1] = value[1], uploadedValue[2] = value[2], uploadedValue[3] = value[3]);
                        return 1;
                    }
                    return 0;
                }
            }, {
                key: "_uniform_vec4vi",
                value: function _uniform_vec4vi(one, value) {
                    WebGLContext.mainContext.uniform4iv(one.location, value);
                    return 1;
                }
            }, {
                key: "_uniform_sampler2D",
                value: function _uniform_sampler2D(one, value) {
                    var gl = WebGLContext.mainContext;
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] == null) {
                        uploadedValue[0] = this._curActTexIndex;
                        gl.uniform1i(one.location, this._curActTexIndex);
                        WebGLContext.activeTexture(gl, gl.TEXTURE0 + this._curActTexIndex);
                        WebGLContext.bindTexture(gl, gl.TEXTURE_2D, value);
                        this._curActTexIndex++;
                        return 1;
                    } else {
                        WebGLContext.activeTexture(gl, gl.TEXTURE0 + uploadedValue[0]);
                        WebGLContext.bindTexture(gl, gl.TEXTURE_2D, value);
                        return 0;
                    }
                }
            }, {
                key: "_uniform_samplerCube",
                value: function _uniform_samplerCube(one, value) {
                    var gl = WebGLContext.mainContext;
                    var uploadedValue = one.uploadedValue;
                    if (uploadedValue[0] == null) {
                        uploadedValue[0] = this._curActTexIndex;
                        gl.uniform1i(one.location, this._curActTexIndex);
                        WebGLContext.activeTexture(gl, gl.TEXTURE0 + this._curActTexIndex);
                        WebGLContext.bindTexture(gl, gl.TEXTURE_CUBE_MAP, value);
                        this._curActTexIndex++;
                        return 1;
                    } else {
                        WebGLContext.activeTexture(gl, gl.TEXTURE0 + uploadedValue[0]);
                        WebGLContext.bindTexture(gl, gl.TEXTURE_CUBE_MAP, value);
                        return 0;
                    }
                }
            }, {
                key: "_noSetValue",
                value: function _noSetValue(one) {
                    console.log("no....:" + one.name);
                }
            }, {
                key: "uploadOne",
                value: function uploadOne(name, value) {
                    WebGLContext.useProgram(WebGLContext.mainContext, this._program);
                    var one = this._paramsMap[name];
                    one.fun.call(this, one, value);
                }
            }, {
                key: "uploadTexture2D",
                value: function uploadTexture2D(value) {
                    var CTX = WebGLContext;
                    if (CTX._activeTextures[0] !== value) {
                        CTX.bindTexture(WebGLContext.mainContext, LayaGL.instance.TEXTURE_2D, value);
                        CTX._activeTextures[0] = value;
                    }
                }
            }, {
                key: "upload",
                value: function upload(shaderValue) {
                    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    BaseShader.activeShader = BaseShader.bindShader = this;
                    var gl = WebGLContext.mainContext;
                    WebGLContext.useProgram(gl, this._program);
                    if (this._reCompile) {
                        params = this._params;
                        this._reCompile = false;
                    } else {
                        params = params || this._params;
                    }
                    var one, value, n = params.length, shaderCall = 0;
                    for (var i = 0; i < n; i++) {
                        one = params[i];
                        if ((value = shaderValue[one.name]) !== null)
                            shaderCall += one.fun.call(this, one, value);
                    }
                    Stat.shaderCall += shaderCall;
                }
            }, {
                key: "uploadArray",
                value: function uploadArray(shaderValue, length, _bufferUsage) {
                    BaseShader.activeShader = this;
                    BaseShader.bindShader = this;
                    WebGLContext.useProgram(WebGLContext.mainContext, this._program);
                    var params = this._params, value;
                    var one, shaderCall = 0;
                    for (var i = length - 2; i >= 0; i -= 2) {
                        one = this._paramsMap[shaderValue[i]];
                        if (!one)
                            continue;
                        value = shaderValue[i + 1];
                        if (value != null) {
                            _bufferUsage && _bufferUsage[one.name] && _bufferUsage[one.name].bind();
                            shaderCall += one.fun.call(this, one, value);
                        }
                    }
                    Stat.shaderCall += shaderCall;
                }
            }, {
                key: "getParams",
                value: function getParams() {
                    return this._params;
                }
            }, {
                key: "setAttributesLocation",
                value: function setAttributesLocation(attribDesc) {
                    this._attribInfo = attribDesc;
                }
            }], [{
                key: "getShader",
                value: function getShader(name) {
                    return Shader.sharders[name];
                }
            }, {
                key: "create",
                value: function create(vs, ps) {
                    var saveName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var nameMap = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var bindAttrib = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    return new Shader(vs, ps, saveName, nameMap, bindAttrib);
                }
            }, {
                key: "withCompile",
                value: function withCompile(nameID, define, shaderName, createShader) {
                    if (shaderName && Shader.sharders[shaderName])
                        return Shader.sharders[shaderName];
                    var pre = Shader._preCompileShader[Shader.SHADERNAME2ID * nameID];
                    if (!pre)
                        throw new Error("withCompile shader err!" + nameID);
                    return pre.createShader(define, shaderName, createShader, null);
                }
            }, {
                key: "withCompile2D",
                value: function withCompile2D(nameID, mainID, define, shaderName, createShader) {
                    var bindAttrib = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    if (shaderName && Shader.sharders[shaderName])
                        return Shader.sharders[shaderName];
                    var pre = Shader._preCompileShader[Shader.SHADERNAME2ID * nameID + mainID];
                    if (!pre)
                        throw new Error("withCompile shader err!" + nameID + " " + mainID);
                    return pre.createShader(define, shaderName, createShader, bindAttrib);
                }
            }, {
                key: "addInclude",
                value: function addInclude(fileName, txt) {
                    ILaya.ShaderCompile.addInclude(fileName, txt);
                }
            }, {
                key: "preCompile",
                value: function preCompile(nameID, vs, ps, nameMap) {
                    var id = Shader.SHADERNAME2ID * nameID;
                    Shader._preCompileShader[id] = new ILaya.ShaderCompile(vs, ps, nameMap);
                }
            }, {
                key: "preCompile2D",
                value: function preCompile2D(nameID, mainID, vs, ps, nameMap) {
                    var id = Shader.SHADERNAME2ID * nameID + mainID;
                    Shader._preCompileShader[id] = new ILaya.ShaderCompile(vs, ps, nameMap);
                }
            }, {
                key: "_createShader",
                value: function _createShader(gl, str, type) {
                    var shader = gl.createShader(type);
                    gl.shaderSource(shader, str);
                    gl.compileShader(shader);
                    if (gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
                        return shader;
                    } else {
                        console.log(gl.getShaderInfoLog(shader));
                        return null;
                    }
                }
            }]);
            return Shader;
        }(BaseShader);
    Shader._count = 0;
    Shader._preCompileShader = {};
    Shader.SHADERNAME2ID = 0.0002;
    Shader.nameKey = new StringKey();
    Shader.sharders = new Array(0x20);
    var Shader2X = /*#__PURE__*/
        function (_Shader) {
            _inherits(Shader2X, _Shader);
            var _super10 = _createSuper(Shader2X);
            function Shader2X(vs, ps) {
                var _this8;
                var saveName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                var nameMap = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                var bindAttrib = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                _classCallCheck(this, Shader2X);
                _this8 = _super10.call(this, vs, ps, saveName, nameMap, bindAttrib);
                _this8._params2dQuick2 = null;
                _this8._shaderValueWidth = 0;
                _this8._shaderValueHeight = 0;
                return _this8;
            }
            _createClass(Shader2X, [{
                key: "_disposeResource",
                value: function _disposeResource() {
                    _get(_getPrototypeOf(Shader2X.prototype), "_disposeResource", this).call(this);
                    this._params2dQuick2 = null;
                }
            }, {
                key: "upload2dQuick2",
                value: function upload2dQuick2(shaderValue) {
                    this.upload(shaderValue, this._params2dQuick2 || this._make2dQuick2());
                }
            }, {
                key: "_make2dQuick2",
                value: function _make2dQuick2() {
                    if (!this._params2dQuick2) {
                        this._params2dQuick2 = [];
                        var params = this._params, one;
                        for (var i = 0, n = params.length; i < n; i++) {
                            one = params[i];
                            if (one.name !== "size")
                                this._params2dQuick2.push(one);
                        }
                    }
                    return this._params2dQuick2;
                }
            }], [{
                key: "create",
                value: function create(vs, ps) {
                    var saveName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var nameMap = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var bindAttrib = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    return new Shader2X(vs, ps, saveName, nameMap, bindAttrib);
                }
            }]);
            return Shader2X;
        }(Shader);
    var Value2D = /*#__PURE__*/
        function () {
            function Value2D(mainID, subID) {
                _classCallCheck(this, Value2D);
                this.defines = new ShaderDefines2D();
                this.size = [0, 0];
                this.alpha = 1.0;
                this.ALPHA = 1.0;
                this.subID = 0;
                this.ref = 1;
                this._cacheID = 0;
                this.clipMatDir = [ILaya.Context._MAXSIZE, 0, 0, ILaya.Context._MAXSIZE];
                this.clipMatPos = [0, 0];
                this.clipOff = [0, 0];
                this.mainID = mainID;
                this.subID = subID;
                this.textureHost = null;
                this.texture = null;
                this.color = null;
                this.colorAdd = null;
                this.u_mmat2 = null;
                this._cacheID = mainID | subID;
                this._inClassCache = Value2D._cache[this._cacheID];
                if (mainID > 0 && !this._inClassCache) {
                    this._inClassCache = Value2D._cache[this._cacheID] = [];
                    this._inClassCache._length = 0;
                }
                this.clear();
            }
            _createClass(Value2D, [{
                key: "setValue",
                value: function setValue(value) { }
            }, {
                key: "_ShaderWithCompile",
                value: function _ShaderWithCompile() {
                    var ret = Shader.withCompile2D(0, this.mainID, this.defines.toNameDic(), this.mainID | this.defines._value, Shader2X.create, this._attribLocation);
                    return ret;
                }
            }, {
                key: "upload",
                value: function upload() {
                    var renderstate2d = RenderState2D;
                    RenderState2D.worldMatrix4 === RenderState2D.TEMPMAT4_ARRAY || this.defines.addInt(ShaderDefines2D.WORLDMAT);
                    this.mmat = renderstate2d.worldMatrix4;
                    if (RenderState2D.matWVP) {
                        this.defines.addInt(ShaderDefines2D.MVP3D);
                        this.u_MvpMatrix = RenderState2D.matWVP.elements;
                    }
                    var sd = Shader.sharders[this.mainID | this.defines._value] || this._ShaderWithCompile();
                    if (sd._shaderValueWidth !== renderstate2d.width || sd._shaderValueHeight !== renderstate2d.height) {
                        this.size[0] = renderstate2d.width;
                        this.size[1] = renderstate2d.height;
                        sd._shaderValueWidth = renderstate2d.width;
                        sd._shaderValueHeight = renderstate2d.height;
                        sd.upload(this, null);
                    } else {
                        sd.upload(this, sd._params2dQuick2 || sd._make2dQuick2());
                    }
                }
            }, {
                key: "setFilters",
                value: function setFilters(value) {
                    this.filters = value;
                    if (!value)
                        return;
                    var n = value.length, f;
                    for (var i = 0; i < n; i++) {
                        f = value[i];
                        if (f) {
                            this.defines.add(f.type);
                            f.action.setValue(this);
                        }
                    }
                }
            }, {
                key: "clear",
                value: function clear() {
                    this.defines._value = this.subID;
                    this.clipOff[0] = 0;
                }
            }, {
                key: "release",
                value: function release() {
                    if (--this.ref < 1) {
                        this._inClassCache && (this._inClassCache[this._inClassCache._length++] = this);
                        this.clear();
                        this.filters = null;
                        this.ref = 1;
                        this.clipOff[0] = 0;
                    }
                }
            }], [{
                key: "_initone",
                value: function _initone(type, classT) {
                    Value2D._typeClass[type] = classT;
                    Value2D._cache[type] = [];
                    Value2D._cache[type]._length = 0;
                }
            }, {
                key: "__init__",
                value: function __init__() { }
            }, {
                key: "create",
                value: function create(mainType, subType) {
                    var types = Value2D._cache[mainType | subType];
                    if (types._length)
                        return types[--types._length];
                    else
                        return new Value2D._typeClass[mainType | subType](subType);
                }
            }]);
            return Value2D;
        }();
    Value2D._cache = [];
    Value2D._typeClass = [];
    Value2D.TEMPMAT4_ARRAY = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
    var SubmitKey = /*#__PURE__*/
        function () {
            function SubmitKey() {
                _classCallCheck(this, SubmitKey);
                this.clear();
            }
            _createClass(SubmitKey, [{
                key: "clear",
                value: function clear() {
                    this.submitType = -1;
                    this.blendShader = this.other = 0;
                }
            }, {
                key: "copyFrom",
                value: function copyFrom(src) {
                    this.other = src.other;
                    this.blendShader = src.blendShader;
                    this.submitType = src.submitType;
                }
            }, {
                key: "copyFrom2",
                value: function copyFrom2(src, submitType, other) {
                    this.other = other;
                    this.submitType = submitType;
                }
            }, {
                key: "equal3_2",
                value: function equal3_2(next, submitType, other) {
                    return this.submitType === submitType && this.other === other && this.blendShader === next.blendShader;
                }
            }, {
                key: "equal4_2",
                value: function equal4_2(next, submitType, other) {
                    return this.submitType === submitType && this.other === other && this.blendShader === next.blendShader;
                }
            }, {
                key: "equal_3",
                value: function equal_3(next) {
                    return this.submitType === next.submitType && this.blendShader === next.blendShader;
                }
            }, {
                key: "equal",
                value: function equal(next) {
                    return this.other === next.other && this.submitType === next.submitType && this.blendShader === next.blendShader;
                }
            }]);
            return SubmitKey;
        }();
    var SubmitCMD = /*#__PURE__*/
        function () {
            function SubmitCMD() {
                _classCallCheck(this, SubmitCMD);
                this._ref = 1;
                this._key = new SubmitKey();
            }
            _createClass(SubmitCMD, [{
                key: "renderSubmit",
                value: function renderSubmit() {
                    this.fun.apply(this._this, this.args);
                    return 1;
                }
            }, {
                key: "getRenderType",
                value: function getRenderType() {
                    return 0;
                }
            }, {
                key: "releaseRender",
                value: function releaseRender() {
                    if (--this._ref < 1) {
                        var pool = SubmitCMD.POOL;
                        pool[pool._length++] = this;
                    }
                }
            }], [{
                key: "create",
                value: function create(args, fun, thisobj) {
                    var o = SubmitCMD.POOL._length ? SubmitCMD.POOL[--SubmitCMD.POOL._length] : new SubmitCMD();
                    o.fun = fun;
                    o.args = args;
                    o._this = thisobj;
                    o._ref = 1;
                    o._key.clear();
                    return o;
                }
            }]);
            return SubmitCMD;
        }();
    SubmitCMD.POOL = [];
    {
        SubmitCMD.POOL._length = 0;
    }
    var Filter = /*#__PURE__*/
        function () {
            function Filter() {
                _classCallCheck(this, Filter);
            }
            _createClass(Filter, [{
                key: "type",
                get: function get() {
                    return -1;
                }
            }]);
            return Filter;
        }();
    Filter.BLUR = 0x10;
    Filter.COLOR = 0x20;
    Filter.GLOW = 0x08;
    Filter._filter = function (sprite, context, x, y) {
        var webglctx = context;
        var next = this._next;
        if (next) {
            var filters = sprite.filters
                , len = filters.length;
            if (len == 1 && filters[0].type == Filter.COLOR) {
                context.save();
                context.setColorFilter(filters[0]);
                next._fun.call(next, sprite, context, x, y);
                context.restore();
                return;
            }
            var svCP = Value2D.create(ShaderDefines2D.TEXTURE2D, 0);
            var b;
            var p = Point.TEMP;
            var tMatrix = webglctx._curMat;
            var mat = Matrix.create();
            tMatrix.copyTo(mat);
            var tPadding = 0;
            var tHalfPadding = 0;
            var tIsHaveGlowFilter = false;
            var source = null;
            var out = sprite._cacheStyle.filterCache || null;
            if (!out || sprite.getRepaint() != 0) {
                tIsHaveGlowFilter = sprite._isHaveGlowFilter();
                if (tIsHaveGlowFilter) {
                    tPadding = 50;
                    tHalfPadding = 25;
                }
                b = new Rectangle();
                b.copyFrom(sprite.getSelfBounds());
                b.x += sprite.x;
                b.y += sprite.y;
                b.x -= sprite.pivotX + 4;
                b.y -= sprite.pivotY + 4;
                var tSX = b.x;
                var tSY = b.y;
                b.width += tPadding + 8;
                b.height += tPadding + 8;
                p.x = b.x * mat.a + b.y * mat.c;
                p.y = b.y * mat.d + b.x * mat.b;
                b.x = p.x;
                b.y = p.y;
                p.x = b.width * mat.a + b.height * mat.c;
                p.y = b.height * mat.d + b.width * mat.b;
                b.width = p.x;
                b.height = p.y;
                if (b.width <= 0 || b.height <= 0) {
                    return;
                }
                out && WebGLRTMgr.releaseRT(out);
                source = WebGLRTMgr.getRT(b.width, b.height);
                var outRT = out = WebGLRTMgr.getRT(b.width, b.height);
                sprite._getCacheStyle().filterCache = out;
                webglctx.pushRT();
                webglctx.useRT(source);
                var tX = sprite.x - tSX + tHalfPadding;
                var tY = sprite.y - tSY + tHalfPadding;
                next._fun.call(next, sprite, context, tX, tY);
                webglctx.useRT(outRT);
                for (var i = 0; i < len; i++) {
                    if (i != 0) {
                        webglctx.useRT(source);
                        webglctx.drawTarget(outRT, 0, 0, b.width, b.height, Matrix.TEMP.identity(), svCP, null, BlendMode.TOINT.overlay);
                        webglctx.useRT(outRT);
                    }
                    var fil = filters[i];
                    switch (fil.type) {
                        case Filter.BLUR:
                            fil._glRender && fil._glRender.render(source, context, b.width, b.height, fil);
                            break;
                        case Filter.GLOW:
                            fil._glRender && fil._glRender.render(source, context, b.width, b.height, fil);
                            break;
                        case Filter.COLOR:
                            webglctx.setColorFilter(fil);
                            webglctx.drawTarget(source, 0, 0, b.width, b.height, Matrix.EMPTY.identity(), Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                            webglctx.setColorFilter(null);
                            break;
                    }
                }
                webglctx.popRT();
            } else {
                tIsHaveGlowFilter = sprite._cacheStyle.hasGlowFilter || false;
                if (tIsHaveGlowFilter) {
                    tPadding = 50;
                    tHalfPadding = 25;
                }
                b = sprite.getBounds();
                if (b.width <= 0 || b.height <= 0) {
                    return;
                }
                b.width += tPadding;
                b.height += tPadding;
                p.x = b.x * mat.a + b.y * mat.c;
                p.y = b.y * mat.d + b.x * mat.b;
                b.x = p.x;
                b.y = p.y;
                p.x = b.width * mat.a + b.height * mat.c;
                p.y = b.height * mat.d + b.width * mat.b;
                b.width = p.x;
                b.height = p.y;
            }
            x = x - tHalfPadding - sprite.x;
            y = y - tHalfPadding - sprite.y;
            p.setTo(x, y);
            mat.transformPoint(p);
            x = p.x + b.x;
            y = p.y + b.y;
            webglctx._drawRenderTexture(out, x, y, b.width, b.height, Matrix.TEMP.identity(), 1.0, RenderTexture2D.defuv);
            if (source) {
                var submit = SubmitCMD.create([source], function (s) {
                    s.destroy();
                }, this);
                source = null;
                context.addRenderObject(submit);
            }
            mat.destroy();
        }
    }
        ;
    var Utils = /*#__PURE__*/
        function () {
            function Utils() {
                _classCallCheck(this, Utils);
            }
            _createClass(Utils, null, [{
                key: "toRadian",
                value: function toRadian(angle) {
                    return angle * Utils._pi2;
                }
            }, {
                key: "toAngle",
                value: function toAngle(radian) {
                    return radian * Utils._pi;
                }
            }, {
                key: "toHexColor",
                value: function toHexColor(color) {
                    if (color < 0 || isNaN(color))
                        return null;
                    var str = color.toString(16);
                    while (str.length < 6) {
                        str = "0" + str;
                    }
                    return "#" + str;
                }
            }, {
                key: "getGID",
                value: function getGID() {
                    return Utils._gid++;
                }
            }, {
                key: "concatArray",
                value: function concatArray(source, array) {
                    if (!array)
                        return source;
                    if (!source)
                        return array;
                    var i, len = array.length;
                    for (i = 0; i < len; i++) {
                        source.push(array[i]);
                    }
                    return source;
                }
            }, {
                key: "clearArray",
                value: function clearArray(array) {
                    if (!array)
                        return array;
                    array.length = 0;
                    return array;
                }
            }, {
                key: "copyArray",
                value: function copyArray(source, array) {
                    source || (source = []);
                    if (!array)
                        return source;
                    source.length = array.length;
                    var i, len = array.length;
                    for (i = 0; i < len; i++) {
                        source[i] = array[i];
                    }
                    return source;
                }
            }, {
                key: "getGlobalRecByPoints",
                value: function getGlobalRecByPoints(sprite, x0, y0, x1, y1) {
                    var newLTPoint;
                    newLTPoint = Point.create().setTo(x0, y0);
                    newLTPoint = sprite.localToGlobal(newLTPoint);
                    var newRBPoint;
                    newRBPoint = Point.create().setTo(x1, y1);
                    newRBPoint = sprite.localToGlobal(newRBPoint);
                    var rst = Rectangle._getWrapRec([newLTPoint.x, newLTPoint.y, newRBPoint.x, newRBPoint.y]);
                    newLTPoint.recover();
                    newRBPoint.recover();
                    return rst;
                }
            }, {
                key: "getGlobalPosAndScale",
                value: function getGlobalPosAndScale(sprite) {
                    return Utils.getGlobalRecByPoints(sprite, 0, 0, 1, 1);
                }
            }, {
                key: "bind",
                value: function bind(fun, scope) {
                    var rst = fun;
                    rst = fun.bind(scope);
                    return rst;
                }
            }, {
                key: "updateOrder",
                value: function updateOrder(array) {
                    if (!array || array.length < 2)
                        return false;
                    var i = 1, j, len = array.length, key, c;
                    while (i < len) {
                        j = i;
                        c = array[j];
                        key = array[j]._zOrder;
                        while (--j > -1) {
                            if (array[j]._zOrder > key)
                                array[j + 1] = array[j];
                            else
                                break;
                        }
                        array[j + 1] = c;
                        i++;
                    }
                    return true;
                }
            }, {
                key: "transPointList",
                value: function transPointList(points, x, y) {
                    var i, len = points.length;
                    for (i = 0; i < len; i += 2) {
                        points[i] += x;
                        points[i + 1] += y;
                    }
                }
            }, {
                key: "parseInt",
                value: function (_parseInt) {
                    function parseInt(_x2) {
                        return _parseInt.apply(this, arguments);
                    }
                    parseInt.toString = function () {
                        return _parseInt.toString();
                    }
                        ;
                    return parseInt;
                }(function (str) {
                    var radix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var result = parseInt(str, radix);
                    if (isNaN(result))
                        return 0;
                    return result;
                })
            }, {
                key: "getFileExtension",
                value: function getFileExtension(path) {
                    Utils._extReg.lastIndex = path.lastIndexOf(".");
                    var result = Utils._extReg.exec(path);
                    if (result && result.length > 1) {
                        return result[1].toLowerCase();
                    }
                    return null;
                }
            }, {
                key: "getTransformRelativeToWindow",
                value: function getTransformRelativeToWindow(coordinateSpace, x, y) {
                    var stage = Utils.gStage;
                    var globalTransform = Utils.getGlobalPosAndScale(coordinateSpace);
                    var canvasMatrix = stage._canvasTransform.clone();
                    var canvasLeft = canvasMatrix.tx;
                    var canvasTop = canvasMatrix.ty;
                    canvasMatrix.rotate(-Math.PI / 180 * stage.canvasDegree);
                    canvasMatrix.scale(stage.clientScaleX, stage.clientScaleY);
                    var perpendicular = stage.canvasDegree % 180 != 0;
                    var tx, ty;
                    if (perpendicular) {
                        tx = y + globalTransform.y;
                        ty = x + globalTransform.x;
                        tx *= canvasMatrix.d;
                        ty *= canvasMatrix.a;
                        if (stage.canvasDegree == 90) {
                            tx = canvasLeft - tx;
                            ty += canvasTop;
                        } else {
                            tx += canvasLeft;
                            ty = canvasTop - ty;
                        }
                    } else {
                        tx = x + globalTransform.x;
                        ty = y + globalTransform.y;
                        tx *= canvasMatrix.a;
                        ty *= canvasMatrix.d;
                        tx += canvasLeft;
                        ty += canvasTop;
                    }
                    ty += stage['_safariOffsetY'];
                    var domScaleX, domScaleY;
                    if (perpendicular) {
                        domScaleX = canvasMatrix.d * globalTransform.height;
                        domScaleY = canvasMatrix.a * globalTransform.width;
                    } else {
                        domScaleX = canvasMatrix.a * globalTransform.width;
                        domScaleY = canvasMatrix.d * globalTransform.height;
                    }
                    return {
                        x: tx,
                        y: ty,
                        scaleX: domScaleX,
                        scaleY: domScaleY
                    };
                }
            }, {
                key: "fitDOMElementInArea",
                value: function fitDOMElementInArea(dom, coordinateSpace, x, y, width, height) {
                    if (!dom._fitLayaAirInitialized) {
                        dom._fitLayaAirInitialized = true;
                        dom.style.transformOrigin = dom.style.webKittransformOrigin = "left top";
                        dom.style.position = "absolute";
                    }
                    var transform = Utils.getTransformRelativeToWindow(coordinateSpace, x, y);
                    dom.style.transform = dom.style.webkitTransform = "scale(" + transform.scaleX + "," + transform.scaleY + ") rotate(" + Utils.gStage.canvasDegree + "deg)";
                    dom.style.width = width + 'px';
                    dom.style.height = height + 'px';
                    dom.style.left = transform.x + 'px';
                    dom.style.top = transform.y + 'px';
                }
            }, {
                key: "isOkTextureList",
                value: function isOkTextureList(textureList) {
                    if (!textureList)
                        return false;
                    var i, len = textureList.length;
                    var tTexture;
                    for (i = 0; i < len; i++) {
                        tTexture = textureList[i];
                        if (!tTexture || !tTexture._getSource())
                            return false;
                    }
                    return true;
                }
            }, {
                key: "isOKCmdList",
                value: function isOKCmdList(cmds) {
                    if (!cmds)
                        return false;
                    var i, len = cmds.length;
                    var cmd;
                    for (i = 0; i < len; i++) {
                        cmd = cmds[i];
                    }
                    return true;
                }
            }, {
                key: "getQueryString",
                value: function getQueryString(name) {
                    if (ILaya.Browser.onMiniGame)
                        return null;
                    if (!window.location || !window.location.search)
                        return null;
                    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
                    var r = window.location.search.substr(1).match(reg);
                    if (r != null)
                        return unescape(r[2]);
                    return null;
                }
            }]);
            return Utils;
        }();
    Utils.gStage = null;
    Utils._gid = 1;
    Utils._pi = 180 / Math.PI;
    Utils._pi2 = Math.PI / 180;
    Utils._extReg = /\.(\w+)\??/g;
    Utils.parseXMLFromString = function (value) {
        var rst;
        value = value.replace(/>\s+</g, '><');
        rst = new DOMParser().parseFromString(value, 'text/xml');
        if (rst.firstChild.textContent.indexOf("This page contains the following errors") > -1) {
            throw new Error(rst.firstChild.firstChild.textContent);
        }
        return rst;
    }
        ;
    var ColorUtils = /*#__PURE__*/
        function () {
            function ColorUtils(value) {
                _classCallCheck(this, ColorUtils);
                this.arrColor = [];
                if (value == null) {
                    this.strColor = "#00000000";
                    this.numColor = 0;
                    this.arrColor = [0, 0, 0, 0];
                    return;
                }
                var i, len;
                var color;
                if (typeof value == 'string') {
                    if (value.indexOf("rgba(") >= 0 || value.indexOf("rgb(") >= 0) {
                        var tStr = value;
                        var beginI, endI;
                        beginI = tStr.indexOf("(");
                        endI = tStr.indexOf(")");
                        tStr = tStr.substring(beginI + 1, endI);
                        this.arrColor = tStr.split(",");
                        len = this.arrColor.length;
                        for (i = 0; i < len; i++) {
                            this.arrColor[i] = parseFloat(this.arrColor[i]);
                            if (i < 3) {
                                this.arrColor[i] = Math.round(this.arrColor[i]);
                            }
                        }
                        if (this.arrColor.length == 4) {
                            color = ((this.arrColor[0] * 256 + this.arrColor[1]) * 256 + this.arrColor[2]) * 256 + Math.round(this.arrColor[3] * 255);
                        } else {
                            color = (this.arrColor[0] * 256 + this.arrColor[1]) * 256 + this.arrColor[2];
                        }
                        this.strColor = value;
                    } else {
                        this.strColor = value;
                        value.charAt(0) === '#' && (value = value.substr(1));
                        len = value.length;
                        if (len === 3 || len === 4) {
                            var temp = "";
                            for (i = 0; i < len; i++) {
                                temp += value[i] + value[i];
                            }
                            value = temp;
                        }
                        color = parseInt(value, 16);
                    }
                } else {
                    color = value;
                    this.strColor = Utils.toHexColor(color);
                }
                if (this.strColor.indexOf("rgba") >= 0 || this.strColor.length === 9) {
                    this.arrColor = [((0xFF000000 & color) >>> 24) / 255, ((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255];
                    this.numColor = (0xff000000 & color) >>> 24 | (color & 0xff0000) >> 8 | (color & 0x00ff00) << 8 | (color & 0xff) << 24;
                } else {
                    this.arrColor = [((0xFF0000 & color) >> 16) / 255, ((0xFF00 & color) >> 8) / 255, (0xFF & color) / 255, 1];
                    this.numColor = 0xff000000 | (color & 0xff0000) >> 16 | color & 0x00ff00 | (color & 0xff) << 16;
                }
                this.arrColor.__id = ++ColorUtils._COLODID;
            }
            _createClass(ColorUtils, null, [{
                key: "_initDefault",
                value: function _initDefault() {
                    ColorUtils._DEFAULT = {};
                    for (var i in ColorUtils._COLOR_MAP) {
                        ColorUtils._SAVE[i] = ColorUtils._DEFAULT[i] = new ColorUtils(ColorUtils._COLOR_MAP[i]);
                    }
                    return ColorUtils._DEFAULT;
                }
            }, {
                key: "_initSaveMap",
                value: function _initSaveMap() {
                    ColorUtils._SAVE_SIZE = 0;
                    ColorUtils._SAVE = {};
                    for (var i in ColorUtils._DEFAULT) {
                        ColorUtils._SAVE[i] = ColorUtils._DEFAULT[i];
                    }
                }
            }, {
                key: "create",
                value: function create(value) {
                    var key = value + "";
                    var color = ColorUtils._SAVE[key];
                    if (color != null)
                        return color;
                    if (ColorUtils._SAVE_SIZE < 1000)
                        ColorUtils._initSaveMap();
                    return ColorUtils._SAVE[key] = new ColorUtils(value);
                }
            }]);
            return ColorUtils;
        }();
    ColorUtils._SAVE = {};
    ColorUtils._SAVE_SIZE = 0;
    ColorUtils._COLOR_MAP = {
        "purple": "#800080",
        "orange": "#ffa500",
        "white": '#FFFFFF',
        "red": '#FF0000',
        "green": '#00FF00',
        "blue": '#0000FF',
        "black": '#000000',
        "yellow": '#FFFF00',
        'gray': '#808080'
    };
    ColorUtils._DEFAULT = ColorUtils._initDefault();
    ColorUtils._COLODID = 1;
    var ColorFilter = /*#__PURE__*/
        function (_Filter) {
            _inherits(ColorFilter, _Filter);
            var _super11 = _createSuper(ColorFilter);
            function ColorFilter() {
                var _this9;
                var mat = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                _classCallCheck(this, ColorFilter);
                _this9 = _super11.call(this);
                if (!mat)
                    mat = _this9._copyMatrix(ColorFilter.IDENTITY_MATRIX);
                _this9._mat = new Float32Array(16);
                _this9._alpha = new Float32Array(4);
                _this9.setByMatrix(mat);
                return _this9;
            }
            _createClass(ColorFilter, [{
                key: "gray",
                value: function gray() {
                    return this.setByMatrix(ColorFilter.GRAY_MATRIX);
                }
            }, {
                key: "color",
                value: function color() {
                    var red = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var green = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var blue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var alpha = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
                    return this.setByMatrix([1, 0, 0, 0, red, 0, 1, 0, 0, green, 0, 0, 1, 0, blue, 0, 0, 0, 1, alpha]);
                }
            }, {
                key: "setColor",
                value: function setColor(color) {
                    var arr = ColorUtils.create(color).arrColor;
                    var mt = [0, 0, 0, 0, 256 * arr[0], 0, 0, 0, 0, 256 * arr[1], 0, 0, 0, 0, 256 * arr[2], 0, 0, 0, 1, 0];
                    return this.setByMatrix(mt);
                }
            }, {
                key: "setByMatrix",
                value: function setByMatrix(matrix) {
                    if (this._matrix != matrix)
                        this._copyMatrix(matrix);
                    var j = 0;
                    var z = 0;
                    for (var i = 0; i < 20; i++) {
                        if (i % 5 != 4) {
                            this._mat[j++] = matrix[i];
                        } else {
                            this._alpha[z++] = matrix[i];
                        }
                    }
                    return this;
                }
            }, {
                key: "type",
                get: function get() {
                    return Filter.COLOR;
                }
            }, {
                key: "adjustColor",
                value: function adjustColor(brightness, contrast, saturation, hue) {
                    this.adjustHue(hue);
                    this.adjustContrast(contrast);
                    this.adjustBrightness(brightness);
                    this.adjustSaturation(saturation);
                    return this;
                }
            }, {
                key: "adjustBrightness",
                value: function adjustBrightness(brightness) {
                    brightness = this._clampValue(brightness, 100);
                    if (brightness == 0 || isNaN(brightness))
                        return this;
                    return this._multiplyMatrix([1, 0, 0, 0, brightness, 0, 1, 0, 0, brightness, 0, 0, 1, 0, brightness, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]);
                }
            }, {
                key: "adjustContrast",
                value: function adjustContrast(contrast) {
                    contrast = this._clampValue(contrast, 100);
                    if (contrast == 0 || isNaN(contrast))
                        return this;
                    var x;
                    if (contrast < 0) {
                        x = 127 + contrast / 100 * 127;
                    } else {
                        x = contrast % 1;
                        if (x == 0) {
                            x = ColorFilter.DELTA_INDEX[contrast];
                        } else {
                            x = ColorFilter.DELTA_INDEX[contrast << 0] * (1 - x) + ColorFilter.DELTA_INDEX[(contrast << 0) + 1] * x;
                        }
                        x = x * 127 + 127;
                    }
                    var x1 = x / 127;
                    var x2 = (127 - x) * 0.5;
                    return this._multiplyMatrix([x1, 0, 0, 0, x2, 0, x1, 0, 0, x2, 0, 0, x1, 0, x2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]);
                }
            }, {
                key: "adjustSaturation",
                value: function adjustSaturation(saturation) {
                    saturation = this._clampValue(saturation, 100);
                    if (saturation == 0 || isNaN(saturation))
                        return this;
                    var x = 1 + (saturation > 0 ? 3 * saturation / 100 : saturation / 100);
                    var dx = 1 - x;
                    var r = 0.3086 * dx;
                    var g = 0.6094 * dx;
                    var b = 0.0820 * dx;
                    return this._multiplyMatrix([r + x, g, b, 0, 0, r, g + x, b, 0, 0, r, g, b + x, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]);
                }
            }, {
                key: "adjustHue",
                value: function adjustHue(hue) {
                    hue = this._clampValue(hue, 180) / 180 * Math.PI;
                    if (hue == 0 || isNaN(hue))
                        return this;
                    var cos = Math.cos(hue);
                    var sin = Math.sin(hue);
                    var r = 0.213;
                    var g = 0.715;
                    var b = 0.072;
                    return this._multiplyMatrix([r + cos * (1 - r) + sin * -r, g + cos * -g + sin * -g, b + cos * -b + sin * (1 - b), 0, 0, r + cos * -r + sin * 0.143, g + cos * (1 - g) + sin * 0.140, b + cos * -b + sin * -0.283, 0, 0, r + cos * -r + sin * -(1 - r), g + cos * -g + sin * g, b + cos * (1 - b) + sin * b, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1]);
                }
            }, {
                key: "reset",
                value: function reset() {
                    return this.setByMatrix(this._copyMatrix(ColorFilter.IDENTITY_MATRIX));
                }
            }, {
                key: "_multiplyMatrix",
                value: function _multiplyMatrix(matrix) {
                    var col = [];
                    this._matrix = this._fixMatrix(this._matrix);
                    for (var i = 0; i < 5; i++) {
                        for (var j = 0; j < 5; j++) {
                            col[j] = this._matrix[j + i * 5];
                        }
                        for (j = 0; j < 5; j++) {
                            var val = 0;
                            for (var k = 0; k < 5; k++) {
                                val += matrix[j + k * 5] * col[k];
                            }
                            this._matrix[j + i * 5] = val;
                        }
                    }
                    return this.setByMatrix(this._matrix);
                }
            }, {
                key: "_clampValue",
                value: function _clampValue(val, limit) {
                    return Math.min(limit, Math.max(-limit, val));
                }
            }, {
                key: "_fixMatrix",
                value: function _fixMatrix() {
                    var matrix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    if (matrix == null)
                        return ColorFilter.IDENTITY_MATRIX;
                    if (matrix.length < ColorFilter.LENGTH)
                        matrix = matrix.slice(0, matrix.length).concat(ColorFilter.IDENTITY_MATRIX.slice(matrix.length, ColorFilter.LENGTH));
                    else if (matrix.length > ColorFilter.LENGTH)
                        matrix = matrix.slice(0, ColorFilter.LENGTH);
                    return matrix;
                }
            }, {
                key: "_copyMatrix",
                value: function _copyMatrix(matrix) {
                    var len = ColorFilter.LENGTH;
                    if (!this._matrix)
                        this._matrix = [];
                    for (var i = 0; i < len; i++) {
                        this._matrix[i] = matrix[i];
                    }
                    return this._matrix;
                }
            }]);
            return ColorFilter;
        }(Filter);
    ColorFilter.DELTA_INDEX = [0, 0.01, 0.02, 0.04, 0.05, 0.06, 0.07, 0.08, 0.1, 0.11, 0.12, 0.14, 0.15, 0.16, 0.17, 0.18, 0.20, 0.21, 0.22, 0.24, 0.25, 0.27, 0.28, 0.30, 0.32, 0.34, 0.36, 0.38, 0.40, 0.42, 0.44, 0.46, 0.48, 0.5, 0.53, 0.56, 0.59, 0.62, 0.65, 0.68, 0.71, 0.74, 0.77, 0.80, 0.83, 0.86, 0.89, 0.92, 0.95, 0.98, 1.0, 1.06, 1.12, 1.18, 1.24, 1.30, 1.36, 1.42, 1.48, 1.54, 1.60, 1.66, 1.72, 1.78, 1.84, 1.90, 1.96, 2.0, 2.12, 2.25, 2.37, 2.50, 2.62, 2.75, 2.87, 3.0, 3.2, 3.4, 3.6, 3.8, 4.0, 4.3, 4.7, 4.9, 5.0, 5.5, 6.0, 6.5, 6.8, 7.0, 7.3, 7.5, 7.8, 8.0, 8.4, 8.7, 9.0, 9.4, 9.6, 9.8, 10.0];
    ColorFilter.GRAY_MATRIX = [0.3086, 0.6094, 0.082, 0, 0, 0.3086, 0.6094, 0.082, 0, 0, 0.3086, 0.6094, 0.082, 0, 0, 0, 0, 0, 1, 0];
    ColorFilter.IDENTITY_MATRIX = [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1];
    ColorFilter.LENGTH = 25;
    var DrawTextureCmd = /*#__PURE__*/
        function () {
            function DrawTextureCmd() {
                _classCallCheck(this, DrawTextureCmd);
                this.colorFlt = null;
                this.uv = null;
            }
            _createClass(DrawTextureCmd, [{
                key: "recover",
                value: function recover() {
                    this.texture && this.texture._removeReference();
                    this.texture = null;
                    this.matrix = null;
                    Pool.recover("DrawTextureCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    this.texture && context.drawTextureWithTransform(this.texture, this.x, this.y, this.width, this.height, this.matrix, gx, gy, this.alpha, this.blendMode, this.colorFlt, this.uv);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawTextureCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, x, y, width, height, matrix, alpha, color, blendMode, uv) {
                    var cmd = Pool.getItemByClass("DrawTextureCmd", DrawTextureCmd);
                    cmd.texture = texture;
                    texture._addReference();
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    cmd.matrix = matrix;
                    cmd.alpha = alpha;
                    cmd.color = color;
                    cmd.blendMode = blendMode;
                    cmd.uv = uv == undefined ? null : uv;
                    if (color) {
                        cmd.colorFlt = new ColorFilter();
                        cmd.colorFlt.setColor(color);
                    }
                    return cmd;
                }
            }]);
            return DrawTextureCmd;
        }();
    DrawTextureCmd.ID = "DrawTexture";
    var FillTextureCmd = /*#__PURE__*/
        function () {
            function FillTextureCmd() {
                _classCallCheck(this, FillTextureCmd);
            }
            _createClass(FillTextureCmd, [{
                key: "recover",
                value: function recover() {
                    this.texture = null;
                    this.offset = null;
                    this.other = null;
                    Pool.recover("FillTextureCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.fillTexture(this.texture, this.x + gx, this.y + gy, this.width, this.height, this.type, this.offset, this.other);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return FillTextureCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, x, y, width, height, type, offset, other) {
                    var cmd = Pool.getItemByClass("FillTextureCmd", FillTextureCmd);
                    cmd.texture = texture;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    cmd.type = type;
                    cmd.offset = offset;
                    cmd.other = other;
                    return cmd;
                }
            }]);
            return FillTextureCmd;
        }();
    FillTextureCmd.ID = "FillTexture";
    var RestoreCmd = /*#__PURE__*/
        function () {
            function RestoreCmd() {
                _classCallCheck(this, RestoreCmd);
            }
            _createClass(RestoreCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("RestoreCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.restore();
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return RestoreCmd.ID;
                }
            }], [{
                key: "create",
                value: function create() {
                    var cmd = Pool.getItemByClass("RestoreCmd", RestoreCmd);
                    return cmd;
                }
            }]);
            return RestoreCmd;
        }();
    RestoreCmd.ID = "Restore";
    var RotateCmd = /*#__PURE__*/
        function () {
            function RotateCmd() {
                _classCallCheck(this, RotateCmd);
            }
            _createClass(RotateCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("RotateCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._rotate(this.angle, this.pivotX + gx, this.pivotY + gy);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return RotateCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(angle, pivotX, pivotY) {
                    var cmd = Pool.getItemByClass("RotateCmd", RotateCmd);
                    cmd.angle = angle;
                    cmd.pivotX = pivotX;
                    cmd.pivotY = pivotY;
                    return cmd;
                }
            }]);
            return RotateCmd;
        }();
    RotateCmd.ID = "Rotate";
    var ScaleCmd = /*#__PURE__*/
        function () {
            function ScaleCmd() {
                _classCallCheck(this, ScaleCmd);
            }
            _createClass(ScaleCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("ScaleCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._scale(this.scaleX, this.scaleY, this.pivotX + gx, this.pivotY + gy);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return ScaleCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(scaleX, scaleY, pivotX, pivotY) {
                    var cmd = Pool.getItemByClass("ScaleCmd", ScaleCmd);
                    cmd.scaleX = scaleX;
                    cmd.scaleY = scaleY;
                    cmd.pivotX = pivotX;
                    cmd.pivotY = pivotY;
                    return cmd;
                }
            }]);
            return ScaleCmd;
        }();
    ScaleCmd.ID = "Scale";
    var TransformCmd = /*#__PURE__*/
        function () {
            function TransformCmd() {
                _classCallCheck(this, TransformCmd);
            }
            _createClass(TransformCmd, [{
                key: "recover",
                value: function recover() {
                    this.matrix = null;
                    Pool.recover("TransformCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context._transform(this.matrix, this.pivotX + gx, this.pivotY + gy);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return TransformCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(matrix, pivotX, pivotY) {
                    var cmd = Pool.getItemByClass("TransformCmd", TransformCmd);
                    cmd.matrix = matrix;
                    cmd.pivotX = pivotX;
                    cmd.pivotY = pivotY;
                    return cmd;
                }
            }]);
            return TransformCmd;
        }();
    TransformCmd.ID = "Transform";
    var TranslateCmd = /*#__PURE__*/
        function () {
            function TranslateCmd() {
                _classCallCheck(this, TranslateCmd);
            }
            _createClass(TranslateCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("TranslateCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.translate(this.tx, this.ty);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return TranslateCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(tx, ty) {
                    var cmd = Pool.getItemByClass("TranslateCmd", TranslateCmd);
                    cmd.tx = tx;
                    cmd.ty = ty;
                    return cmd;
                }
            }]);
            return TranslateCmd;
        }();
    TranslateCmd.ID = "Translate";
    var Bezier = /*#__PURE__*/
        function () {
            function Bezier() {
                _classCallCheck(this, Bezier);
                this._controlPoints = [new Point(), new Point(), new Point()];
                this._calFun = this.getPoint2;
            }
            _createClass(Bezier, [{
                key: "_switchPoint",
                value: function _switchPoint(x, y) {
                    var tPoint = this._controlPoints.shift();
                    tPoint.setTo(x, y);
                    this._controlPoints.push(tPoint);
                }
            }, {
                key: "getPoint2",
                value: function getPoint2(t, rst) {
                    var p1 = this._controlPoints[0];
                    var p2 = this._controlPoints[1];
                    var p3 = this._controlPoints[2];
                    var lineX = Math.pow(1 - t, 2) * p1.x + 2 * t * (1 - t) * p2.x + Math.pow(t, 2) * p3.x;
                    var lineY = Math.pow(1 - t, 2) * p1.y + 2 * t * (1 - t) * p2.y + Math.pow(t, 2) * p3.y;
                    rst.push(lineX, lineY);
                }
            }, {
                key: "getPoint3",
                value: function getPoint3(t, rst) {
                    var p1 = this._controlPoints[0];
                    var p2 = this._controlPoints[1];
                    var p3 = this._controlPoints[2];
                    var p4 = this._controlPoints[3];
                    var lineX = Math.pow(1 - t, 3) * p1.x + 3 * p2.x * t * (1 - t) * (1 - t) + 3 * p3.x * t * t * (1 - t) + p4.x * Math.pow(t, 3);
                    var lineY = Math.pow(1 - t, 3) * p1.y + 3 * p2.y * t * (1 - t) * (1 - t) + 3 * p3.y * t * t * (1 - t) + p4.y * Math.pow(t, 3);
                    rst.push(lineX, lineY);
                }
            }, {
                key: "insertPoints",
                value: function insertPoints(count, rst) {
                    var i;
                    count = count > 0 ? count : 5;
                    var dLen;
                    dLen = 1 / count;
                    for (i = 0; i <= 1; i += dLen) {
                        this._calFun(i, rst);
                    }
                }
            }, {
                key: "getBezierPoints",
                value: function getBezierPoints(pList) {
                    var inSertCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 5;
                    var count = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 2;
                    var i, len;
                    len = pList.length;
                    if (len < (count + 1) * 2)
                        return [];
                    var rst = [];
                    switch (count) {
                        case 2:
                            this._calFun = this.getPoint2;
                            break;
                        case 3:
                            this._calFun = this.getPoint3;
                            break;
                        default:
                            return [];
                    }
                    while (this._controlPoints.length <= count) {
                        this._controlPoints.push(Point.create());
                    }
                    for (i = 0; i < count * 2; i += 2) {
                        this._switchPoint(pList[i], pList[i + 1]);
                    }
                    for (i = count * 2; i < len; i += 2) {
                        this._switchPoint(pList[i], pList[i + 1]);
                        if (i / 2 % count == 0)
                            this.insertPoints(inSertCount, rst);
                    }
                    return rst;
                }
            }]);
            return Bezier;
        }();
    Bezier.I = new Bezier();
    var GrahamScan = /*#__PURE__*/
        function () {
            function GrahamScan() {
                _classCallCheck(this, GrahamScan);
            }
            _createClass(GrahamScan, null, [{
                key: "multiply",
                value: function multiply(p1, p2, p0) {
                    return (p1.x - p0.x) * (p2.y - p0.y) - (p2.x - p0.x) * (p1.y - p0.y);
                }
            }, {
                key: "dis",
                value: function dis(p1, p2) {
                    return (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
                }
            }, {
                key: "_getPoints",
                value: function _getPoints(count) {
                    var tempUse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var rst = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    if (!GrahamScan._mPointList)
                        GrahamScan._mPointList = [];
                    while (GrahamScan._mPointList.length < count) {
                        GrahamScan._mPointList.push(new Point());
                    }
                    if (!rst)
                        rst = [];
                    rst.length = 0;
                    if (tempUse) {
                        GrahamScan.getFrom(rst, GrahamScan._mPointList, count);
                    } else {
                        GrahamScan.getFromR(rst, GrahamScan._mPointList, count);
                    }
                    return rst;
                }
            }, {
                key: "getFrom",
                value: function getFrom(rst, src, count) {
                    var i;
                    for (i = 0; i < count; i++) {
                        rst.push(src[i]);
                    }
                    return rst;
                }
            }, {
                key: "getFromR",
                value: function getFromR(rst, src, count) {
                    var i;
                    for (i = 0; i < count; i++) {
                        rst.push(src.pop());
                    }
                    return rst;
                }
            }, {
                key: "pListToPointList",
                value: function pListToPointList(pList) {
                    var tempUse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var i, len = pList.length / 2, rst = GrahamScan._getPoints(len, tempUse, GrahamScan._tempPointList);
                    for (i = 0; i < len; i++) {
                        rst[i].setTo(pList[i + i], pList[i + i + 1]);
                    }
                    return rst;
                }
            }, {
                key: "pointListToPlist",
                value: function pointListToPlist(pointList) {
                    var i, len = pointList.length, rst = GrahamScan._temPList, tPoint;
                    rst.length = 0;
                    for (i = 0; i < len; i++) {
                        tPoint = pointList[i];
                        rst.push(tPoint.x, tPoint.y);
                    }
                    return rst;
                }
            }, {
                key: "scanPList",
                value: function scanPList(pList) {
                    return Utils.copyArray(pList, GrahamScan.pointListToPlist(GrahamScan.scan(GrahamScan.pListToPointList(pList, true))));
                }
            }, {
                key: "scan",
                value: function scan(PointSet) {
                    var i, j, k = 0, tmp, n = PointSet.length, ch;
                    var _tmpDic = {};
                    var key;
                    ch = GrahamScan._temArr;
                    ch.length = 0;
                    n = PointSet.length;
                    for (i = n - 1; i >= 0; i--) {
                        tmp = PointSet[i];
                        key = tmp.x + "_" + tmp.y;
                        if (!(key in _tmpDic)) {
                            _tmpDic[key] = true;
                            ch.push(tmp);
                        }
                    }
                    n = ch.length;
                    Utils.copyArray(PointSet, ch);
                    for (i = 1; i < n; i++) {
                        if (PointSet[i].y < PointSet[k].y || PointSet[i].y == PointSet[k].y && PointSet[i].x < PointSet[k].x)
                            k = i;
                    }
                    tmp = PointSet[0];
                    PointSet[0] = PointSet[k];
                    PointSet[k] = tmp;
                    for (i = 1; i < n - 1; i++) {
                        k = i;
                        for (j = i + 1; j < n; j++) {
                            if (GrahamScan.multiply(PointSet[j], PointSet[k], PointSet[0]) > 0 || GrahamScan.multiply(PointSet[j], PointSet[k], PointSet[0]) == 0 && GrahamScan.dis(PointSet[0], PointSet[j]) < GrahamScan.dis(PointSet[0], PointSet[k]))
                                k = j;
                        }
                        tmp = PointSet[i];
                        PointSet[i] = PointSet[k];
                        PointSet[k] = tmp;
                    }
                    ch = GrahamScan._temArr;
                    ch.length = 0;
                    if (PointSet.length < 3) {
                        return Utils.copyArray(ch, PointSet);
                    }
                    ch.push(PointSet[0], PointSet[1], PointSet[2]);
                    for (i = 3; i < n; i++) {
                        while (ch.length >= 2 && GrahamScan.multiply(PointSet[i], ch[ch.length - 1], ch[ch.length - 2]) >= 0) {
                            ch.pop();
                        }
                        PointSet[i] && ch.push(PointSet[i]);
                    }
                    return ch;
                }
            }]);
            return GrahamScan;
        }();
    GrahamScan._tempPointList = [];
    GrahamScan._temPList = [];
    GrahamScan._temArr = [];
    var DrawStyle = /*#__PURE__*/
        function () {
            function DrawStyle(value) {
                _classCallCheck(this, DrawStyle);
                this.setValue(value);
            }
            _createClass(DrawStyle, [{
                key: "setValue",
                value: function setValue(value) {
                    if (value) {
                        this._color = value instanceof ColorUtils ? value : ColorUtils.create(value);
                    } else
                        this._color = ColorUtils.create("#000000");
                }
            }, {
                key: "reset",
                value: function reset() {
                    this._color = ColorUtils.create("#000000");
                }
            }, {
                key: "toInt",
                value: function toInt() {
                    return this._color.numColor;
                }
            }, {
                key: "equal",
                value: function equal(value) {
                    if (typeof value == 'string')
                        return this._color.strColor === value;
                    if (value instanceof ColorUtils)
                        return this._color.numColor === value.numColor;
                    return false;
                }
            }, {
                key: "toColorStr",
                value: function toColorStr() {
                    return this._color.strColor;
                }
            }], [{
                key: "create",
                value: function create(value) {
                    if (value) {
                        var color = value instanceof ColorUtils ? value : ColorUtils.create(value);
                        return color._drawStyle || (color._drawStyle = new DrawStyle(value));
                    }
                    return DrawStyle.DEFAULT;
                }
            }]);
            return DrawStyle;
        }();
    DrawStyle.DEFAULT = new DrawStyle("#000000");
    var Path = /*#__PURE__*/
        function () {
            function Path() {
                _classCallCheck(this, Path);
                this._lastOriX = 0;
                this._lastOriY = 0;
                this.paths = [];
                this._curPath = null;
            }
            _createClass(Path, [{
                key: "beginPath",
                value: function beginPath(convex) {
                    this.paths.length = 1;
                    this._curPath = this.paths[0] = new renderPath();
                    this._curPath.convex = convex;
                }
            }, {
                key: "closePath",
                value: function closePath() {
                    this._curPath.loop = true;
                }
            }, {
                key: "newPath",
                value: function newPath() {
                    this._curPath = new renderPath();
                    this.paths.push(this._curPath);
                }
            }, {
                key: "addPoint",
                value: function addPoint(pointX, pointY) {
                    this._curPath.path.push(pointX, pointY);
                }
            }, {
                key: "push",
                value: function push(points, convex) {
                    if (!this._curPath) {
                        this._curPath = new renderPath();
                        this.paths.push(this._curPath);
                    } else if (this._curPath.path.length > 0) {
                        this._curPath = new renderPath();
                        this.paths.push(this._curPath);
                    }
                    var rp = this._curPath;
                    rp.path = points.slice();
                    rp.convex = convex;
                }
            }, {
                key: "reset",
                value: function reset() {
                    this.paths.length = 0;
                }
            }]);
            return Path;
        }();
    var renderPath = /*#__PURE__*/
        _createClass(function renderPath() {
            _classCallCheck(this, renderPath);
            this.path = [];
            this.loop = false;
            this.convex = false;
        });
    var SubmitBase = /*#__PURE__*/
        function () {
            function SubmitBase() {
                var renderType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SubmitBase.TYPE_2D;
                _classCallCheck(this, SubmitBase);
                this.clipInfoID = -1;
                this._mesh = null;
                this._blendFn = null;
                this._id = 0;
                this._renderType = 0;
                this._parent = null;
                this._key = new SubmitKey();
                this._startIdx = 0;
                this._numEle = 0;
                this._ref = 1;
                this.shaderValue = null;
                this._renderType = renderType;
                this._id = ++SubmitBase.ID;
            }
            _createClass(SubmitBase, [{
                key: "getID",
                value: function getID() {
                    return this._id;
                }
            }, {
                key: "getRenderType",
                value: function getRenderType() {
                    return this._renderType;
                }
            }, {
                key: "toString",
                value: function toString() {
                    return "ibindex:" + this._startIdx + " num:" + this._numEle + " key=" + this._key;
                }
            }, {
                key: "renderSubmit",
                value: function renderSubmit() {
                    return 1;
                }
            }, {
                key: "releaseRender",
                value: function releaseRender() { }
            }], [{
                key: "__init__",
                value: function __init__() {
                    var s = SubmitBase.RENDERBASE = new SubmitBase(-1);
                    s.shaderValue = new Value2D(0, 0);
                    s.shaderValue.ALPHA = 1;
                    s._ref = 0xFFFFFFFF;
                }
            }]);
            return SubmitBase;
        }();
    SubmitBase.TYPE_2D = 10000;
    SubmitBase.TYPE_CANVAS = 10003;
    SubmitBase.TYPE_CMDSETRT = 10004;
    SubmitBase.TYPE_CUSTOM = 10005;
    SubmitBase.TYPE_BLURRT = 10006;
    SubmitBase.TYPE_CMDDESTORYPRERT = 10007;
    SubmitBase.TYPE_DISABLESTENCIL = 10008;
    SubmitBase.TYPE_OTHERIBVB = 10009;
    SubmitBase.TYPE_PRIMITIVE = 10010;
    SubmitBase.TYPE_RT = 10011;
    SubmitBase.TYPE_BLUR_RT = 10012;
    SubmitBase.TYPE_TARGET = 10013;
    SubmitBase.TYPE_CHANGE_VALUE = 10014;
    SubmitBase.TYPE_SHAPE = 10015;
    SubmitBase.TYPE_TEXTURE = 10016;
    SubmitBase.TYPE_FILLTEXTURE = 10017;
    SubmitBase.KEY_ONCE = -1;
    SubmitBase.KEY_FILLRECT = 1;
    SubmitBase.KEY_DRAWTEXTURE = 2;
    SubmitBase.KEY_VG = 3;
    SubmitBase.KEY_TRIANGLES = 4;
    SubmitBase.ID = 1;
    SubmitBase.preRender = null;
    var SaveBase = /*#__PURE__*/
        function () {
            function SaveBase() {
                _classCallCheck(this, SaveBase);
            }
            _createClass(SaveBase, [{
                key: "isSaveMark",
                value: function isSaveMark() {
                    return false;
                }
            }, {
                key: "restore",
                value: function restore(context) {
                    this._dataObj[this._valueName] = this._value;
                    SaveBase.POOL[SaveBase.POOL._length++] = this;
                    this._newSubmit && (context._curSubmit = SubmitBase.RENDERBASE);
                }
            }], [{
                key: "_createArray",
                value: function _createArray() {
                    var value = [];
                    value._length = 0;
                    return value;
                }
            }, {
                key: "_init",
                value: function _init() {
                    var namemap = SaveBase._namemap = {};
                    namemap[SaveBase.TYPE_ALPHA] = "ALPHA";
                    namemap[SaveBase.TYPE_FILESTYLE] = "fillStyle";
                    namemap[SaveBase.TYPE_FONT] = "font";
                    namemap[SaveBase.TYPE_LINEWIDTH] = "lineWidth";
                    namemap[SaveBase.TYPE_STROKESTYLE] = "strokeStyle";
                    namemap[SaveBase.TYPE_ENABLEMERGE] = "_mergeID";
                    namemap[SaveBase.TYPE_MARK] = namemap[SaveBase.TYPE_TRANSFORM] = namemap[SaveBase.TYPE_TRANSLATE] = [];
                    namemap[SaveBase.TYPE_TEXTBASELINE] = "textBaseline";
                    namemap[SaveBase.TYPE_TEXTALIGN] = "textAlign";
                    namemap[SaveBase.TYPE_GLOBALCOMPOSITEOPERATION] = "_nBlendType";
                    namemap[SaveBase.TYPE_SHADER] = "shader";
                    namemap[SaveBase.TYPE_FILTERS] = "filters";
                    namemap[SaveBase.TYPE_COLORFILTER] = '_colorFiler';
                    return namemap;
                }
            }, {
                key: "save",
                value: function save(context, type, dataObj, newSubmit) {
                    if ((context._saveMark._saveuse & type) !== type) {
                        context._saveMark._saveuse |= type;
                        var cache = SaveBase.POOL;
                        var o = cache._length > 0 ? cache[--cache._length] : new SaveBase();
                        o._value = dataObj[o._valueName = SaveBase._namemap[type]];
                        o._dataObj = dataObj;
                        o._newSubmit = newSubmit;
                        var _save = context._save;
                        _save[_save._length++] = o;
                    }
                }
            }]);
            return SaveBase;
        }();
    SaveBase.TYPE_ALPHA = 0x1;
    SaveBase.TYPE_FILESTYLE = 0x2;
    SaveBase.TYPE_FONT = 0x8;
    SaveBase.TYPE_LINEWIDTH = 0x100;
    SaveBase.TYPE_STROKESTYLE = 0x200;
    SaveBase.TYPE_MARK = 0x400;
    SaveBase.TYPE_TRANSFORM = 0x800;
    SaveBase.TYPE_TRANSLATE = 0x1000;
    SaveBase.TYPE_ENABLEMERGE = 0x2000;
    SaveBase.TYPE_TEXTBASELINE = 0x4000;
    SaveBase.TYPE_TEXTALIGN = 0x8000;
    SaveBase.TYPE_GLOBALCOMPOSITEOPERATION = 0x10000;
    SaveBase.TYPE_CLIPRECT = 0x20000;
    SaveBase.TYPE_CLIPRECT_STENCIL = 0x40000;
    SaveBase.TYPE_IBVB = 0x80000;
    SaveBase.TYPE_SHADER = 0x100000;
    SaveBase.TYPE_FILTERS = 0x200000;
    SaveBase.TYPE_FILTERS_TYPE = 0x400000;
    SaveBase.TYPE_COLORFILTER = 0x800000;
    SaveBase.POOL = SaveBase._createArray();
    SaveBase._namemap = SaveBase._init();
    var SaveClipRect = /*#__PURE__*/
        function () {
            function SaveClipRect() {
                _classCallCheck(this, SaveClipRect);
                this._globalClipMatrix = new Matrix();
                this._clipInfoID = -1;
                this._clipRect = new Rectangle();
                this.incache = false;
            }
            _createClass(SaveClipRect, [{
                key: "isSaveMark",
                value: function isSaveMark() {
                    return false;
                }
            }, {
                key: "restore",
                value: function restore(context) {
                    this._globalClipMatrix.copyTo(context._globalClipMatrix);
                    this._clipRect.clone(context._clipRect);
                    context._clipInfoID = this._clipInfoID;
                    SaveClipRect.POOL[SaveClipRect.POOL._length++] = this;
                    context._clipInCache = this.incache;
                }
            }], [{
                key: "save",
                value: function save(context) {
                    if ((context._saveMark._saveuse & SaveBase.TYPE_CLIPRECT) == SaveBase.TYPE_CLIPRECT)
                        return;
                    context._saveMark._saveuse |= SaveBase.TYPE_CLIPRECT;
                    var cache = SaveClipRect.POOL;
                    var o = cache._length > 0 ? cache[--cache._length] : new SaveClipRect();
                    context._globalClipMatrix.copyTo(o._globalClipMatrix);
                    context._clipRect.clone(o._clipRect);
                    o._clipInfoID = context._clipInfoID;
                    o.incache = context._clipInCache;
                    var _save = context._save;
                    _save[_save._length++] = o;
                }
            }]);
            return SaveClipRect;
        }();
    SaveClipRect.POOL = SaveBase._createArray();
    var SaveMark = /*#__PURE__*/
        function () {
            function SaveMark() {
                _classCallCheck(this, SaveMark);
                this._saveuse = 0;
            }
            _createClass(SaveMark, [{
                key: "isSaveMark",
                value: function isSaveMark() {
                    return true;
                }
            }, {
                key: "restore",
                value: function restore(context) {
                    context._saveMark = this._preSaveMark;
                    SaveMark.POOL[SaveMark.POOL._length++] = this;
                }
            }], [{
                key: "Create",
                value: function Create(context) {
                    var no = SaveMark.POOL;
                    var o = no._length > 0 ? no[--no._length] : new SaveMark();
                    o._saveuse = 0;
                    o._preSaveMark = context._saveMark;
                    context._saveMark = o;
                    return o;
                }
            }]);
            return SaveMark;
        }();
    SaveMark.POOL = SaveBase._createArray();
    var SaveTransform = /*#__PURE__*/
        function () {
            function SaveTransform() {
                _classCallCheck(this, SaveTransform);
                this._matrix = new Matrix();
            }
            _createClass(SaveTransform, [{
                key: "isSaveMark",
                value: function isSaveMark() {
                    return false;
                }
            }, {
                key: "restore",
                value: function restore(context) {
                    context._curMat = this._savematrix;
                    SaveTransform.POOL[SaveTransform.POOL._length++] = this;
                }
            }], [{
                key: "save",
                value: function save(context) {
                    var _saveMark = context._saveMark;
                    if ((_saveMark._saveuse & SaveBase.TYPE_TRANSFORM) === SaveBase.TYPE_TRANSFORM)
                        return;
                    _saveMark._saveuse |= SaveBase.TYPE_TRANSFORM;
                    var no = SaveTransform.POOL;
                    var o = no._length > 0 ? no[--no._length] : new SaveTransform();
                    o._savematrix = context._curMat;
                    context._curMat = context._curMat.copyTo(o._matrix);
                    var _save = context._save;
                    _save[_save._length++] = o;
                }
            }]);
            return SaveTransform;
        }();
    SaveTransform.POOL = SaveBase._createArray();
    var SaveTranslate = /*#__PURE__*/
        function () {
            function SaveTranslate() {
                _classCallCheck(this, SaveTranslate);
                this._mat = new Matrix();
            }
            _createClass(SaveTranslate, [{
                key: "isSaveMark",
                value: function isSaveMark() {
                    return false;
                }
            }, {
                key: "restore",
                value: function restore(context) {
                    this._mat.copyTo(context._curMat);
                    SaveTranslate.POOL[SaveTranslate.POOL._length++] = this;
                }
            }], [{
                key: "save",
                value: function save(context) {
                    var no = SaveTranslate.POOL;
                    var o = no._length > 0 ? no[--no._length] : new SaveTranslate();
                    context._curMat.copyTo(o._mat);
                    var _save = context._save;
                    _save[_save._length++] = o;
                }
            }]);
            return SaveTranslate;
        }();
    SaveTranslate.POOL = SaveBase._createArray();
    var BufferStateBase = /*#__PURE__*/
        function () {
            function BufferStateBase() {
                _classCallCheck(this, BufferStateBase);
                this._nativeVertexArrayObject = LayaGL.layaGPUInstance.createVertexArray();
            }
            _createClass(BufferStateBase, [{
                key: "bind",
                value: function bind() {
                    if (BufferStateBase._curBindedBufferState !== this) {
                        LayaGL.layaGPUInstance.bindVertexArray(this._nativeVertexArrayObject);
                        BufferStateBase._curBindedBufferState = this;
                    }
                }
            }, {
                key: "unBind",
                value: function unBind() {
                    if (BufferStateBase._curBindedBufferState === this) {
                        LayaGL.layaGPUInstance.bindVertexArray(null);
                        BufferStateBase._curBindedBufferState = null;
                    } else {
                        throw "BufferState: must call bind() function first.";
                    }
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    LayaGL.layaGPUInstance.deleteVertexArray(this._nativeVertexArrayObject);
                }
            }, {
                key: "bindForNative",
                value: function bindForNative() {
                    LayaGL.instance.bindVertexArray(this._nativeVertexArrayObject);
                    BufferStateBase._curBindedBufferState = this;
                }
            }, {
                key: "unBindForNative",
                value: function unBindForNative() {
                    LayaGL.instance.bindVertexArray(null);
                    BufferStateBase._curBindedBufferState = null;
                }
            }]);
            return BufferStateBase;
        }();
    var BufferState2D = /*#__PURE__*/
        function (_BufferStateBase) {
            _inherits(BufferState2D, _BufferStateBase);
            var _super12 = _createSuper(BufferState2D);
            function BufferState2D() {
                _classCallCheck(this, BufferState2D);
                return _super12.call(this);
            }
            return _createClass(BufferState2D);
        }(BufferStateBase);
    var Buffer = /*#__PURE__*/
        function () {
            function Buffer() {
                _classCallCheck(this, Buffer);
                this._byteLength = 0;
                this._glBuffer = LayaGL.instance.createBuffer();
            }
            _createClass(Buffer, [{
                key: "bufferUsage",
                get: function get() {
                    return this._bufferUsage;
                }
            }, {
                key: "_bindForVAO",
                value: function _bindForVAO() { }
            }, {
                key: "bind",
                value: function bind() {
                    return false;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    if (this._glBuffer) {
                        LayaGL.instance.deleteBuffer(this._glBuffer);
                        this._glBuffer = null;
                    }
                }
            }]);
            return Buffer;
        }();
    var RenderInfo = /*#__PURE__*/
        _createClass(function RenderInfo() {
            _classCallCheck(this, RenderInfo);
        });
    RenderInfo.loopStTm = 0;
    RenderInfo.loopCount = 0;
    var Buffer2D = /*#__PURE__*/
        function (_Buffer) {
            _inherits(Buffer2D, _Buffer);
            var _super13 = _createSuper(Buffer2D);
            function Buffer2D() {
                var _this10;
                _classCallCheck(this, Buffer2D);
                _this10 = _super13.call(this);
                _this10._maxsize = 0;
                _this10._upload = true;
                _this10._uploadSize = 0;
                _this10._bufferSize = 0;
                _this10._u8Array = null;
                return _this10;
            }
            _createClass(Buffer2D, [{
                key: "bufferLength",
                get: function get() {
                    return this._buffer.byteLength;
                }
            }, {
                key: "byteLength",
                set: function set(value) {
                    this.setByteLength(value);
                }
            }, {
                key: "setByteLength",
                value: function setByteLength(value) {
                    if (this._byteLength !== value) {
                        value <= this._bufferSize || this._resizeBuffer(value * 2 + 256, true);
                        this._byteLength = value;
                    }
                }
            }, {
                key: "needSize",
                value: function needSize(sz) {
                    var old = this._byteLength;
                    if (sz) {
                        var needsz = this._byteLength + sz;
                        needsz <= this._bufferSize || this._resizeBuffer(needsz << 1, true);
                        this._byteLength = needsz;
                    }
                    return old;
                }
            }, {
                key: "_bufferData",
                value: function _bufferData() {
                    this._maxsize = Math.max(this._maxsize, this._byteLength);
                    if (RenderInfo.loopCount % 30 == 0) {
                        if (this._buffer.byteLength > this._maxsize + 64) {
                            this._buffer = this._buffer.slice(0, this._maxsize + 64);
                            this._bufferSize = this._buffer.byteLength;
                            this._checkArrayUse();
                        }
                        this._maxsize = this._byteLength;
                    }
                    if (this._uploadSize < this._buffer.byteLength) {
                        this._uploadSize = this._buffer.byteLength;
                        LayaGL.instance.bufferData(this._bufferType, this._uploadSize, this._bufferUsage);
                    }
                    LayaGL.instance.bufferSubData(this._bufferType, 0, new Uint8Array(this._buffer, 0, this._byteLength));
                }
            }, {
                key: "_bufferSubData",
                value: function _bufferSubData() {
                    var offset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var dataStart = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var dataLength = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    this._maxsize = Math.max(this._maxsize, this._byteLength);
                    if (RenderInfo.loopCount % 30 == 0) {
                        if (this._buffer.byteLength > this._maxsize + 64) {
                            this._buffer = this._buffer.slice(0, this._maxsize + 64);
                            this._bufferSize = this._buffer.byteLength;
                            this._checkArrayUse();
                        }
                        this._maxsize = this._byteLength;
                    }
                    if (this._uploadSize < this._buffer.byteLength) {
                        this._uploadSize = this._buffer.byteLength;
                        LayaGL.instance.bufferData(this._bufferType, this._uploadSize, this._bufferUsage);
                    }
                    if (dataStart || dataLength) {
                        var subBuffer = this._buffer.slice(dataStart, dataLength);
                        LayaGL.instance.bufferSubData(this._bufferType, offset, subBuffer);
                    } else {
                        LayaGL.instance.bufferSubData(this._bufferType, offset, this._buffer);
                    }
                }
            }, {
                key: "_checkArrayUse",
                value: function _checkArrayUse() { }
            }, {
                key: "_bind_uploadForVAO",
                value: function _bind_uploadForVAO() {
                    if (!this._upload)
                        return false;
                    this._upload = false;
                    this._bindForVAO();
                    this._bufferData();
                    return true;
                }
            }, {
                key: "_bind_upload",
                value: function _bind_upload() {
                    if (!this._upload)
                        return false;
                    this._upload = false;
                    this.bind();
                    this._bufferData();
                    return true;
                }
            }, {
                key: "_bind_subUpload",
                value: function _bind_subUpload() {
                    var offset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var dataStart = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var dataLength = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    if (!this._upload)
                        return false;
                    this._upload = false;
                    this.bind();
                    this._bufferSubData(offset, dataStart, dataLength);
                    return true;
                }
            }, {
                key: "_resizeBuffer",
                value: function _resizeBuffer(nsz, copy) {
                    var buff = this._buffer;
                    if (nsz <= buff.byteLength)
                        return this;
                    var u8buf = this._u8Array;
                    if (copy && buff && buff.byteLength > 0) {
                        var newbuffer = new ArrayBuffer(nsz);
                        var oldU8Arr = u8buf && u8buf.buffer == buff ? u8buf : new Uint8Array(buff);
                        u8buf = this._u8Array = new Uint8Array(newbuffer);
                        u8buf.set(oldU8Arr, 0);
                        buff = this._buffer = newbuffer;
                    } else {
                        buff = this._buffer = new ArrayBuffer(nsz);
                        this._u8Array = null;
                    }
                    this._checkArrayUse();
                    this._upload = true;
                    this._bufferSize = buff.byteLength;
                    return this;
                }
            }, {
                key: "append",
                value: function append(data) {
                    this._upload = true;
                    var byteLen, n;
                    byteLen = data.byteLength;
                    if (data instanceof Uint8Array) {
                        this._resizeBuffer(this._byteLength + byteLen, true);
                        n = new Uint8Array(this._buffer, this._byteLength);
                    } else if (data instanceof Uint16Array) {
                        this._resizeBuffer(this._byteLength + byteLen, true);
                        n = new Uint16Array(this._buffer, this._byteLength);
                    } else if (data instanceof Float32Array) {
                        this._resizeBuffer(this._byteLength + byteLen, true);
                        n = new Float32Array(this._buffer, this._byteLength);
                    }
                    n.set(data, 0);
                    this._byteLength += byteLen;
                    this._checkArrayUse();
                }
            }, {
                key: "appendU16Array",
                value: function appendU16Array(data, len) {
                    this._resizeBuffer(this._byteLength + len * 2, true);
                    var u = new Uint16Array(this._buffer, this._byteLength, len);
                    if (len == 6) {
                        u[0] = data[0];
                        u[1] = data[1];
                        u[2] = data[2];
                        u[3] = data[3];
                        u[4] = data[4];
                        u[5] = data[5];
                    } else if (len >= 100) {
                        u.set(new Uint16Array(data.buffer, 0, len));
                    } else {
                        for (var i = 0; i < len; i++) {
                            u[i] = data[i];
                        }
                    }
                    this._byteLength += len * 2;
                    this._checkArrayUse();
                }
            }, {
                key: "appendEx",
                value: function appendEx(data, type) {
                    this._upload = true;
                    var byteLen, n;
                    byteLen = data.byteLength;
                    this._resizeBuffer(this._byteLength + byteLen, true);
                    n = new type(this._buffer, this._byteLength);
                    n.set(data, 0);
                    this._byteLength += byteLen;
                    this._checkArrayUse();
                }
            }, {
                key: "appendEx2",
                value: function appendEx2(data, type, dataLen) {
                    var perDataLen = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
                    this._upload = true;
                    var byteLen, n;
                    byteLen = dataLen * perDataLen;
                    this._resizeBuffer(this._byteLength + byteLen, true);
                    n = new type(this._buffer, this._byteLength);
                    var i;
                    for (i = 0; i < dataLen; i++) {
                        n[i] = data[i];
                    }
                    this._byteLength += byteLen;
                    this._checkArrayUse();
                }
            }, {
                key: "getBuffer",
                value: function getBuffer() {
                    return this._buffer;
                }
            }, {
                key: "setNeedUpload",
                value: function setNeedUpload() {
                    this._upload = true;
                }
            }, {
                key: "getNeedUpload",
                value: function getNeedUpload() {
                    return this._upload;
                }
            }, {
                key: "upload",
                value: function upload() {
                    var gl = LayaGL.instance;
                    var scuess = this._bind_upload();
                    gl.bindBuffer(this._bufferType, null);
                    if (this._bufferType == gl.ARRAY_BUFFER)
                        Buffer._bindedVertexBuffer = null;
                    if (this._bufferType == gl.ELEMENT_ARRAY_BUFFER)
                        Buffer._bindedIndexBuffer = null;
                    BaseShader.activeShader = null;
                    return scuess;
                }
            }, {
                key: "subUpload",
                value: function subUpload() {
                    var offset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var dataStart = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var dataLength = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var gl = LayaGL.instance;
                    var scuess = this._bind_subUpload();
                    gl.bindBuffer(this._bufferType, null);
                    if (this._bufferType == gl.ARRAY_BUFFER)
                        Buffer._bindedVertexBuffer = null;
                    if (this._bufferType == gl.ELEMENT_ARRAY_BUFFER)
                        Buffer._bindedIndexBuffer = null;
                    BaseShader.activeShader = null;
                    return scuess;
                }
            }, {
                key: "_disposeResource",
                value: function _disposeResource() {
                    this._upload = true;
                    this._uploadSize = 0;
                }
            }, {
                key: "clear",
                value: function clear() {
                    this._byteLength = 0;
                    this._upload = true;
                }
            }], [{
                key: "__int__",
                value: function __int__(gl) { }
            }]);
            return Buffer2D;
        }(Buffer);
    Buffer2D.FLOAT32 = 4;
    Buffer2D.SHORT = 2;
    var IndexBuffer2D = /*#__PURE__*/
        function (_Buffer2D) {
            _inherits(IndexBuffer2D, _Buffer2D);
            var _super14 = _createSuper(IndexBuffer2D);
            function IndexBuffer2D() {
                var _this11;
                var bufferUsage = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0x88e4;
                _classCallCheck(this, IndexBuffer2D);
                _this11 = _super14.call(this);
                _this11._bufferUsage = bufferUsage;
                _this11._bufferType = LayaGL.instance.ELEMENT_ARRAY_BUFFER;
                _this11._buffer = new ArrayBuffer(8);
                return _this11;
            }
            _createClass(IndexBuffer2D, [{
                key: "_checkArrayUse",
                value: function _checkArrayUse() {
                    this._uint16Array && (this._uint16Array = new Uint16Array(this._buffer));
                }
            }, {
                key: "getUint16Array",
                value: function getUint16Array() {
                    return this._uint16Array || (this._uint16Array = new Uint16Array(this._buffer));
                }
            }, {
                key: "_bindForVAO",
                value: function _bindForVAO() {
                    var gl = LayaGL.instance;
                    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._glBuffer);
                }
            }, {
                key: "bind",
                value: function bind() {
                    if (Buffer._bindedIndexBuffer !== this._glBuffer) {
                        var gl = LayaGL.instance;
                        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._glBuffer);
                        Buffer._bindedIndexBuffer = this._glBuffer;
                        return true;
                    }
                    return false;
                }
            }, {
                key: "destory",
                value: function destory() {
                    this._uint16Array = null;
                    this._buffer = null;
                }
            }, {
                key: "disposeResource",
                value: function disposeResource() {
                    this._disposeResource();
                }
            }]);
            return IndexBuffer2D;
        }(Buffer2D);
    IndexBuffer2D.create = function () {
        var bufferUsage = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0x88e4;
        return new IndexBuffer2D(bufferUsage);
    }
        ;
    var VertexBuffer2D = /*#__PURE__*/
        function (_Buffer2D2) {
            _inherits(VertexBuffer2D, _Buffer2D2);
            var _super15 = _createSuper(VertexBuffer2D);
            function VertexBuffer2D(vertexStride, bufferUsage) {
                var _this12;
                _classCallCheck(this, VertexBuffer2D);
                _this12 = _super15.call(this);
                _this12._vertexStride = vertexStride;
                _this12._bufferUsage = bufferUsage;
                _this12._bufferType = LayaGL.instance.ARRAY_BUFFER;
                _this12._buffer = new ArrayBuffer(8);
                _this12._floatArray32 = new Float32Array(_this12._buffer);
                _this12._uint32Array = new Uint32Array(_this12._buffer);
                return _this12;
            }
            _createClass(VertexBuffer2D, [{
                key: "vertexStride",
                get: function get() {
                    return this._vertexStride;
                }
            }, {
                key: "getFloat32Array",
                value: function getFloat32Array() {
                    return this._floatArray32;
                }
            }, {
                key: "appendArray",
                value: function appendArray(data) {
                    var oldoff = this._byteLength >> 2;
                    this.setByteLength(this._byteLength + data.length * 4);
                    var vbdata = this.getFloat32Array();
                    vbdata.set(data, oldoff);
                    this._upload = true;
                }
            }, {
                key: "_checkArrayUse",
                value: function _checkArrayUse() {
                    this._floatArray32 && (this._floatArray32 = new Float32Array(this._buffer));
                    this._uint32Array && (this._uint32Array = new Uint32Array(this._buffer));
                }
            }, {
                key: "deleteBuffer",
                value: function deleteBuffer() {
                    _get(_getPrototypeOf(VertexBuffer2D.prototype), "_disposeResource", this).call(this);
                }
            }, {
                key: "_bindForVAO",
                value: function _bindForVAO() {
                    var gl = LayaGL.instance;
                    gl.bindBuffer(gl.ARRAY_BUFFER, this._glBuffer);
                }
            }, {
                key: "bind",
                value: function bind() {
                    if (Buffer._bindedVertexBuffer !== this._glBuffer) {
                        var gl = LayaGL.instance;
                        gl.bindBuffer(gl.ARRAY_BUFFER, this._glBuffer);
                        Buffer._bindedVertexBuffer = this._glBuffer;
                        return true;
                    }
                    return false;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    _get(_getPrototypeOf(VertexBuffer2D.prototype), "destroy", this).call(this);
                    this._byteLength = 0;
                    this._upload = true;
                    this._buffer = null;
                    this._floatArray32 = null;
                }
            }]);
            return VertexBuffer2D;
        }(Buffer2D);
    VertexBuffer2D.create = function (vertexStride) {
        var bufferUsage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0x88e8;
        return new VertexBuffer2D(vertexStride, bufferUsage);
    }
        ;
    var Mesh2D = /*#__PURE__*/
        function () {
            function Mesh2D(stride, vballoc, iballoc) {
                _classCallCheck(this, Mesh2D);
                this._stride = 0;
                this.vertNum = 0;
                this.indexNum = 0;
                this._applied = false;
                this._quadNum = 0;
                this.canReuse = false;
                this._stride = stride;
                this._vb = new VertexBuffer2D(stride, LayaGL.instance.DYNAMIC_DRAW);
                if (vballoc) {
                    this._vb._resizeBuffer(vballoc, false);
                } else {
                    Config.webGL2D_MeshAllocMaxMem && this._vb._resizeBuffer(64 * 1024 * stride, false);
                }
                this._ib = new IndexBuffer2D();
                if (iballoc) {
                    this._ib._resizeBuffer(iballoc, false);
                }
            }
            _createClass(Mesh2D, [{
                key: "cloneWithNewVB",
                value: function cloneWithNewVB() {
                    var mesh = new Mesh2D(this._stride, 0, 0);
                    mesh._ib = this._ib;
                    mesh._quadNum = this._quadNum;
                    mesh._attribInfo = this._attribInfo;
                    return mesh;
                }
            }, {
                key: "cloneWithNewVBIB",
                value: function cloneWithNewVBIB() {
                    var mesh = new Mesh2D(this._stride, 0, 0);
                    mesh._attribInfo = this._attribInfo;
                    return mesh;
                }
            }, {
                key: "getVBW",
                value: function getVBW() {
                    this._vb.setNeedUpload();
                    return this._vb;
                }
            }, {
                key: "getVBR",
                value: function getVBR() {
                    return this._vb;
                }
            }, {
                key: "getIBR",
                value: function getIBR() {
                    return this._ib;
                }
            }, {
                key: "getIBW",
                value: function getIBW() {
                    this._ib.setNeedUpload();
                    return this._ib;
                }
            }, {
                key: "createQuadIB",
                value: function createQuadIB(QuadNum) {
                    this._quadNum = QuadNum;
                    this._ib._resizeBuffer(QuadNum * 6 * 2, false);
                    this._ib.byteLength = this._ib.bufferLength;
                    var bd = this._ib.getUint16Array();
                    var idx = 0;
                    var curvert = 0;
                    for (var i = 0; i < QuadNum; i++) {
                        bd[idx++] = curvert;
                        bd[idx++] = curvert + 2;
                        bd[idx++] = curvert + 1;
                        bd[idx++] = curvert;
                        bd[idx++] = curvert + 3;
                        bd[idx++] = curvert + 2;
                        curvert += 4;
                    }
                    this._ib.setNeedUpload();
                }
            }, {
                key: "setAttributes",
                value: function setAttributes(attribs) {
                    this._attribInfo = attribs;
                    if (this._attribInfo.length % 3 != 0) {
                        throw 'Mesh2D setAttributes error!';
                    }
                }
            }, {
                key: "configVAO",
                value: function configVAO(gl) {
                    if (this._applied)
                        return;
                    this._applied = true;
                    if (!this._vao) {
                        this._vao = new BufferState2D();
                    }
                    this._vao.bind();
                    this._vb._bindForVAO();
                    this._ib.setNeedUpload();
                    this._ib._bind_uploadForVAO();
                    var attribNum = this._attribInfo.length / 3;
                    var idx = 0;
                    for (var i = 0; i < attribNum; i++) {
                        var _size = this._attribInfo[idx + 1];
                        var _type = this._attribInfo[idx];
                        var _off = this._attribInfo[idx + 2];
                        gl.enableVertexAttribArray(i);
                        gl.vertexAttribPointer(i, _size, _type, false, this._stride, _off);
                        idx += 3;
                    }
                    this._vao.unBind();
                }
            }, {
                key: "useMesh",
                value: function useMesh(gl) {
                    this._applied || this.configVAO(gl);
                    this._vao.bind();
                    this._vb.bind();
                    this._ib._bind_upload() || this._ib.bind();
                    this._vb._bind_upload() || this._vb.bind();
                }
            }, {
                key: "getEleNum",
                value: function getEleNum() {
                    return this._ib.getBuffer().byteLength / 2;
                }
            }, {
                key: "releaseMesh",
                value: function releaseMesh() { }
            }, {
                key: "destroy",
                value: function destroy() { }
            }, {
                key: "clearVB",
                value: function clearVB() {
                    this._vb.clear();
                }
            }]);
            return Mesh2D;
        }();
    Mesh2D._gvaoid = 0;
    var MeshQuadTexture = /*#__PURE__*/
        function (_Mesh2D) {
            _inherits(MeshQuadTexture, _Mesh2D);
            var _super16 = _createSuper(MeshQuadTexture);
            function MeshQuadTexture() {
                var _this13;
                _classCallCheck(this, MeshQuadTexture);
                _this13 = _super16.call(this, MeshQuadTexture.const_stride, 4, 4);
                _this13.canReuse = true;
                _this13.setAttributes(MeshQuadTexture._fixattriInfo);
                if (!MeshQuadTexture._fixib) {
                    _this13.createQuadIB(MeshQuadTexture._maxIB);
                    MeshQuadTexture._fixib = _this13._ib;
                } else {
                    _this13._ib = MeshQuadTexture._fixib;
                    _this13._quadNum = MeshQuadTexture._maxIB;
                }
                return _this13;
            }
            _createClass(MeshQuadTexture, [{
                key: "releaseMesh",
                value: function releaseMesh() {
                    this._vb.setByteLength(0);
                    this.vertNum = 0;
                    this.indexNum = 0;
                    MeshQuadTexture._POOL.push(this);
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this._vb.destroy();
                    this._vb.deleteBuffer();
                }
            }, {
                key: "addQuad",
                value: function addQuad(pos, uv, color, useTex) {
                    var vb = this._vb;
                    var vpos = vb._byteLength >> 2;
                    vb.setByteLength(vpos + MeshQuadTexture.const_stride << 2);
                    var vbdata = vb._floatArray32 || vb.getFloat32Array();
                    var vbu32Arr = vb._uint32Array;
                    var cpos = vpos;
                    var useTexVal = useTex ? 0xff : 0;
                    vbdata[cpos++] = pos[0];
                    vbdata[cpos++] = pos[1];
                    vbdata[cpos++] = uv[0];
                    vbdata[cpos++] = uv[1];
                    vbu32Arr[cpos++] = color;
                    vbu32Arr[cpos++] = useTexVal;
                    vbdata[cpos++] = pos[2];
                    vbdata[cpos++] = pos[3];
                    vbdata[cpos++] = uv[2];
                    vbdata[cpos++] = uv[3];
                    vbu32Arr[cpos++] = color;
                    vbu32Arr[cpos++] = useTexVal;
                    vbdata[cpos++] = pos[4];
                    vbdata[cpos++] = pos[5];
                    vbdata[cpos++] = uv[4];
                    vbdata[cpos++] = uv[5];
                    vbu32Arr[cpos++] = color;
                    vbu32Arr[cpos++] = useTexVal;
                    vbdata[cpos++] = pos[6];
                    vbdata[cpos++] = pos[7];
                    vbdata[cpos++] = uv[6];
                    vbdata[cpos++] = uv[7];
                    vbu32Arr[cpos++] = color;
                    vbu32Arr[cpos++] = useTexVal;
                    vb._upload = true;
                }
            }], [{
                key: "__int__",
                value: function __int__() {
                    MeshQuadTexture._fixattriInfo = [5126, 4, 0, 5121, 4, 16, 5121, 4, 20];
                }
            }, {
                key: "getAMesh",
                value: function getAMesh(mainctx) {
                    var ret = null;
                    if (MeshQuadTexture._POOL.length) {
                        ret = MeshQuadTexture._POOL.pop();
                    } else
                        ret = new MeshQuadTexture();
                    mainctx && ret._vb._resizeBuffer(64 * 1024 * MeshQuadTexture.const_stride, false);
                    return ret;
                }
            }]);
            return MeshQuadTexture;
        }(Mesh2D);
    MeshQuadTexture.const_stride = 24;
    MeshQuadTexture._maxIB = 16 * 1024;
    MeshQuadTexture._POOL = [];
    var MeshTexture = /*#__PURE__*/
        function (_Mesh2D2) {
            _inherits(MeshTexture, _Mesh2D2);
            var _super17 = _createSuper(MeshTexture);
            function MeshTexture() {
                var _this14;
                _classCallCheck(this, MeshTexture);
                _this14 = _super17.call(this, MeshTexture.const_stride, 4, 4);
                _this14.canReuse = true;
                _this14.setAttributes(MeshTexture._fixattriInfo);
                return _this14;
            }
            _createClass(MeshTexture, [{
                key: "addData",
                value: function addData(vertices, uvs, idx, matrix, rgba) {
                    var vb = this._vb;
                    var ib = this._ib;
                    var vertsz = vertices.length >> 1;
                    var startpos = vb.needSize(vertsz * MeshTexture.const_stride);
                    var f32pos = startpos >> 2;
                    var vbdata = vb._floatArray32 || vb.getFloat32Array();
                    var vbu32Arr = vb._uint32Array;
                    var ci = 0;
                    var m00 = matrix.a;
                    var m01 = matrix.b;
                    var m10 = matrix.c;
                    var m11 = matrix.d;
                    var tx = matrix.tx;
                    var ty = matrix.ty;
                    var i = 0;
                    for (i = 0; i < vertsz; i++) {
                        var x = vertices[ci]
                            , y = vertices[ci + 1];
                        vbdata[f32pos] = x * m00 + y * m10 + tx;
                        vbdata[f32pos + 1] = x * m01 + y * m11 + ty;
                        vbdata[f32pos + 2] = uvs[ci];
                        vbdata[f32pos + 3] = uvs[ci + 1];
                        vbu32Arr[f32pos + 4] = rgba;
                        vbu32Arr[f32pos + 5] = 0xff;
                        f32pos += 6;
                        ci += 2;
                    }
                    vb.setNeedUpload();
                    var vertN = this.vertNum;
                    var sz = idx.length;
                    var stib = ib.needSize(idx.byteLength);
                    var cidx = ib.getUint16Array();
                    var stibid = stib >> 1;
                    if (vertN > 0) {
                        var end = stibid + sz;
                        var si = 0;
                        for (i = stibid; i < end; i++,
                            si++) {
                            cidx[i] = idx[si] + vertN;
                        }
                    } else {
                        cidx.set(idx, stibid);
                    }
                    ib.setNeedUpload();
                    this.vertNum += vertsz;
                    this.indexNum += idx.length;
                }
            }, {
                key: "releaseMesh",
                value: function releaseMesh() {
                    this._vb.setByteLength(0);
                    this._ib.setByteLength(0);
                    this.vertNum = 0;
                    this.indexNum = 0;
                    MeshTexture._POOL.push(this);
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this._ib.destroy();
                    this._vb.destroy();
                    this._ib.disposeResource();
                    this._vb.deleteBuffer();
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    MeshTexture._fixattriInfo = [5126, 4, 0, 5121, 4, 16, 5121, 4, 20];
                }
            }, {
                key: "getAMesh",
                value: function getAMesh(mainctx) {
                    var ret;
                    if (MeshTexture._POOL.length) {
                        ret = MeshTexture._POOL.pop();
                    } else
                        ret = new MeshTexture();
                    mainctx && ret._vb._resizeBuffer(64 * 1024 * MeshTexture.const_stride, false);
                    return ret;
                }
            }]);
            return MeshTexture;
        }(Mesh2D);
    MeshTexture.const_stride = 24;
    MeshTexture._POOL = [];
    var MeshVG = /*#__PURE__*/
        function (_Mesh2D3) {
            _inherits(MeshVG, _Mesh2D3);
            var _super18 = _createSuper(MeshVG);
            function MeshVG() {
                var _this15;
                _classCallCheck(this, MeshVG);
                _this15 = _super18.call(this, MeshVG.const_stride, 4, 4);
                _this15.canReuse = true;
                _this15.setAttributes(MeshVG._fixattriInfo);
                return _this15;
            }
            _createClass(MeshVG, [{
                key: "addVertAndIBToMesh",
                value: function addVertAndIBToMesh(ctx, points, rgba, ib) {
                    var startpos = this._vb.needSize(points.length / 2 * MeshVG.const_stride);
                    var f32pos = startpos >> 2;
                    var vbdata = this._vb._floatArray32 || this._vb.getFloat32Array();
                    var vbu32Arr = this._vb._uint32Array;
                    var ci = 0;
                    var sz = points.length / 2;
                    for (var i = 0; i < sz; i++) {
                        vbdata[f32pos++] = points[ci];
                        vbdata[f32pos++] = points[ci + 1];
                        ci += 2;
                        vbu32Arr[f32pos++] = rgba;
                    }
                    this._vb.setNeedUpload();
                    this._ib.append(new Uint16Array(ib));
                    this._ib.setNeedUpload();
                    this.vertNum += sz;
                    this.indexNum += ib.length;
                }
            }, {
                key: "releaseMesh",
                value: function releaseMesh() {
                    this._vb.setByteLength(0);
                    this._ib.setByteLength(0);
                    this.vertNum = 0;
                    this.indexNum = 0;
                    MeshVG._POOL.push(this);
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this._ib.destroy();
                    this._vb.destroy();
                    this._ib.disposeResource();
                    this._vb.deleteBuffer();
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    MeshVG._fixattriInfo = [5126, 2, 0, 5121, 4, 8];
                }
            }, {
                key: "getAMesh",
                value: function getAMesh(mainctx) {
                    var ret;
                    if (MeshVG._POOL.length) {
                        ret = MeshVG._POOL.pop();
                    } else
                        ret = new MeshVG();
                    mainctx && ret._vb._resizeBuffer(64 * 1024 * MeshVG.const_stride, false);
                    return ret;
                }
            }]);
            return MeshVG;
        }(Mesh2D);
    MeshVG.const_stride = 12;
    MeshVG._POOL = [];
    var WebGLCacheAsNormalCanvas = /*#__PURE__*/
        function () {
            function WebGLCacheAsNormalCanvas(ctx, sp) {
                _classCallCheck(this, WebGLCacheAsNormalCanvas);
                this.submitStartPos = 0;
                this.submitEndPos = 0;
                this.context = null;
                this.touches = [];
                this.submits = [];
                this.sprite = null;
                this.meshlist = [];
                this.cachedClipInfo = new Matrix();
                this.oldTx = 0;
                this.oldTy = 0;
                this.invMat = new Matrix();
                this.context = ctx;
                this.sprite = sp;
                ctx._globalClipMatrix.copyTo(this.cachedClipInfo);
            }
            _createClass(WebGLCacheAsNormalCanvas, [{
                key: "startRec",
                value: function startRec() {
                    if (this.context._charSubmitCache._enable) {
                        this.context._charSubmitCache.enable(false, this.context);
                        this.context._charSubmitCache.enable(true, this.context);
                    }
                    this.context._incache = true;
                    this.touches.length = 0;
                    this.context.touches = this.touches;
                    this.context._globalClipMatrix.copyTo(this.cachedClipInfo);
                    this.submits.length = 0;
                    this.submitStartPos = this.context._submits._length;
                    for (var i = 0, sz = this.meshlist.length; i < sz; i++) {
                        var curm = this.meshlist[i];
                        curm.canReuse ? curm.releaseMesh() : curm.destroy();
                    }
                    this.meshlist.length = 0;
                    this._mesh = MeshQuadTexture.getAMesh(false);
                    this._pathMesh = MeshVG.getAMesh(false);
                    this._triangleMesh = MeshTexture.getAMesh(false);
                    this.meshlist.push(this._mesh);
                    this.meshlist.push(this._pathMesh);
                    this.meshlist.push(this._triangleMesh);
                    this.context._curSubmit = SubmitBase.RENDERBASE;
                    this._oldMesh = this.context._mesh;
                    this._oldPathMesh = this.context._pathMesh;
                    this._oldTriMesh = this.context._triangleMesh;
                    this._oldMeshList = this.context.meshlist;
                    this.context._mesh = this._mesh;
                    this.context._pathMesh = this._pathMesh;
                    this.context._triangleMesh = this._triangleMesh;
                    this.context.meshlist = this.meshlist;
                    this.oldTx = this.context._curMat.tx;
                    this.oldTy = this.context._curMat.ty;
                    this.context._curMat.tx = 0;
                    this.context._curMat.ty = 0;
                    this.context._curMat.copyTo(this.invMat);
                    this.invMat.invert();
                }
            }, {
                key: "endRec",
                value: function endRec() {
                    if (this.context._charSubmitCache._enable) {
                        this.context._charSubmitCache.enable(false, this.context);
                        this.context._charSubmitCache.enable(true, this.context);
                    }
                    var parsubmits = this.context._submits;
                    this.submitEndPos = parsubmits._length;
                    var num = this.submitEndPos - this.submitStartPos;
                    for (var i = 0; i < num; i++) {
                        this.submits.push(parsubmits[this.submitStartPos + i]);
                    }
                    parsubmits._length -= num;
                    this.context._mesh = this._oldMesh;
                    this.context._pathMesh = this._oldPathMesh;
                    this.context._triangleMesh = this._oldTriMesh;
                    this.context.meshlist = this._oldMeshList;
                    this.context._curSubmit = SubmitBase.RENDERBASE;
                    this.context._curMat.tx = this.oldTx;
                    this.context._curMat.ty = this.oldTy;
                    this.context.touches = null;
                    this.context._incache = false;
                }
            }, {
                key: "isCacheValid",
                value: function isCacheValid() {
                    var curclip = this.context._globalClipMatrix;
                    if (curclip.a != this.cachedClipInfo.a || curclip.b != this.cachedClipInfo.b || curclip.c != this.cachedClipInfo.c || curclip.d != this.cachedClipInfo.d || curclip.tx != this.cachedClipInfo.tx || curclip.ty != this.cachedClipInfo.ty)
                        return false;
                    return true;
                }
            }, {
                key: "flushsubmit",
                value: function flushsubmit() {
                    var curSubmit = SubmitBase.RENDERBASE;
                    this.submits.forEach(function (subm) {
                        if (subm == SubmitBase.RENDERBASE)
                            return;
                        SubmitBase.preRender = curSubmit;
                        curSubmit = subm;
                        subm.renderSubmit();
                    });
                }
            }, {
                key: "releaseMem",
                value: function releaseMem() { }
            }]);
            return WebGLCacheAsNormalCanvas;
        }();
    WebGLCacheAsNormalCanvas.matI = new Matrix();
    var texture_vs = "/*\r\n\ttexture和fillrect使用的。\r\n*/\r\nattribute vec4 posuv;\r\nattribute vec4 attribColor;\r\nattribute vec4 attribFlags;\r\n//attribute vec4 clipDir;\r\n//attribute vec2 clipRect;\r\nuniform vec4 clipMatDir;\r\nuniform vec2 clipMatPos;\t\t// 这个是全局的，不用再应用矩阵了。\r\nvarying vec2 cliped;\r\nuniform vec2 size;\r\nuniform vec2 clipOff;\t\t\t// 使用要把clip偏移。cacheas normal用. 只用了[0]\r\n#ifdef WORLDMAT\r\n\tuniform mat4 mmat;\r\n#endif\r\n#ifdef MVP3D\r\n\tuniform mat4 u_MvpMatrix;\r\n#endif\r\nvarying vec4 v_texcoordAlpha;\r\nvarying vec4 v_color;\r\nvarying float v_useTex;\r\n\r\nvoid main() {\r\n\r\n\tvec4 pos = vec4(posuv.xy,0.,1.);\r\n#ifdef WORLDMAT\r\n\tpos=mmat*pos;\r\n#endif\r\n\tvec4 pos1  =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,0.,1.0);\r\n#ifdef MVP3D\r\n\tgl_Position=u_MvpMatrix*pos1;\r\n#else\r\n\tgl_Position=pos1;\r\n#endif\r\n\tv_texcoordAlpha.xy = posuv.zw;\r\n\t//v_texcoordAlpha.z = attribColor.a/255.0;\r\n\tv_color = attribColor/255.0;\r\n\tv_color.xyz*=v_color.w;//反正后面也要预乘\r\n\t\r\n\tv_useTex = attribFlags.r/255.0;\r\n\tfloat clipw = length(clipMatDir.xy);\r\n\tfloat cliph = length(clipMatDir.zw);\r\n\t\r\n\tvec2 clpos = clipMatPos.xy;\r\n\t#ifdef WORLDMAT\r\n\t\t// 如果有mmat，需要修改clipMatPos,因为 这是cacheas normal （如果不是就错了）， clipMatPos被去掉了偏移\r\n\t\tif(clipOff[0]>0.0){\r\n\t\t\tclpos.x+=mmat[3].x;\t//tx\t最简单处理\r\n\t\t\tclpos.y+=mmat[3].y;\t//ty\r\n\t\t}\r\n\t#endif\r\n\tvec2 clippos = pos.xy - clpos;\t//pos已经应用矩阵了，为了减的有意义，clip的位置也要缩放\r\n\tif(clipw>20000. && cliph>20000.)\r\n\t\tcliped = vec2(0.5,0.5);\r\n\telse {\r\n\t\t//转成0到1之间。/clipw/clipw 表示clippos与normalize之后的clip朝向点积之后，再除以clipw\r\n\t\tcliped=vec2( dot(clippos,clipMatDir.xy)/clipw/clipw, dot(clippos,clipMatDir.zw)/cliph/cliph);\r\n\t}\r\n\r\n}";
    var texture_ps = "/*\r\n\ttexture和fillrect使用的。\r\n*/\r\n#ifdef GL_FRAGMENT_PRECISION_HIGH\r\nprecision highp float;\r\n#else\r\nprecision mediump float;\r\n#endif\r\n\r\nvarying vec4 v_texcoordAlpha;\r\nvarying vec4 v_color;\r\nvarying float v_useTex;\r\nuniform sampler2D texture;\r\nvarying vec2 cliped;\r\n\r\n#ifdef BLUR_FILTER\r\nuniform vec4 strength_sig2_2sig2_gauss1;\r\nuniform vec2 blurInfo;\r\n\r\n#define PI 3.141593\r\n\r\nfloat getGaussian(float x, float y){\r\n    return strength_sig2_2sig2_gauss1.w*exp(-(x*x+y*y)/strength_sig2_2sig2_gauss1.z);\r\n}\r\n\r\nvec4 blur(){\r\n    const float blurw = 9.0;\r\n    vec4 vec4Color = vec4(0.0,0.0,0.0,0.0);\r\n    vec2 halfsz=vec2(blurw,blurw)/2.0/blurInfo;    \r\n    vec2 startpos=v_texcoordAlpha.xy-halfsz;\r\n    vec2 ctexcoord = startpos;\r\n    vec2 step = 1.0/blurInfo;  //每个像素      \r\n    \r\n    for(float y = 0.0;y<=blurw; ++y){\r\n        ctexcoord.x=startpos.x;\r\n        for(float x = 0.0;x<=blurw; ++x){\r\n            //TODO 纹理坐标的固定偏移应该在vs中处理\r\n            vec4Color += texture2D(texture, ctexcoord)*getGaussian(x-blurw/2.0,y-blurw/2.0);\r\n            ctexcoord.x+=step.x;\r\n        }\r\n        ctexcoord.y+=step.y;\r\n    }\r\n    return vec4Color;\r\n}\r\n#endif\r\n\r\n#ifdef COLOR_FILTER\r\nuniform vec4 colorAlpha;\r\nuniform mat4 colorMat;\r\n#endif\r\n\r\n#ifdef GLOW_FILTER\r\nuniform vec4 u_color;\r\nuniform vec4 u_blurInfo1;\r\nuniform vec4 u_blurInfo2;\r\n#endif\r\n\r\n#ifdef COLOR_ADD\r\nuniform vec4 colorAdd;\r\n#endif\r\n\r\n#ifdef FILLTEXTURE\t\r\nuniform vec4 u_TexRange;//startu,startv,urange, vrange\r\n#endif\r\nvoid main() {\r\n\tif(cliped.x<0.) discard;\r\n\tif(cliped.x>1.) discard;\r\n\tif(cliped.y<0.) discard;\r\n\tif(cliped.y>1.) discard;\r\n\t\r\n#ifdef FILLTEXTURE\t\r\n   vec4 color= texture2D(texture, fract(v_texcoordAlpha.xy)*u_TexRange.zw + u_TexRange.xy);\r\n#else\r\n   vec4 color= texture2D(texture, v_texcoordAlpha.xy);\r\n#endif\r\n\r\n   if(v_useTex<=0.)color = vec4(1.,1.,1.,1.);\r\n   color.a*=v_color.w;\r\n   //color.rgb*=v_color.w;\r\n   color.rgb*=v_color.rgb;\r\n   gl_FragColor=color;\r\n   \r\n   #ifdef COLOR_ADD\r\n\tgl_FragColor = vec4(colorAdd.rgb,colorAdd.a*gl_FragColor.a);\r\n\tgl_FragColor.xyz *= colorAdd.a;\r\n   #endif\r\n   \r\n   #ifdef BLUR_FILTER\r\n\tgl_FragColor =   blur();\r\n\tgl_FragColor.w*=v_color.w;   \r\n   #endif\r\n   \r\n   #ifdef COLOR_FILTER\r\n\tmat4 alphaMat =colorMat;\r\n\r\n\talphaMat[0][3] *= gl_FragColor.a;\r\n\talphaMat[1][3] *= gl_FragColor.a;\r\n\talphaMat[2][3] *= gl_FragColor.a;\r\n\r\n\tgl_FragColor = gl_FragColor * alphaMat;\r\n\tgl_FragColor += colorAlpha/255.0*gl_FragColor.a;\r\n   #endif\r\n   \r\n   #ifdef GLOW_FILTER\r\n\tconst float c_IterationTime = 10.0;\r\n\tfloat floatIterationTotalTime = c_IterationTime * c_IterationTime;\r\n\tvec4 vec4Color = vec4(0.0,0.0,0.0,0.0);\r\n\tvec2 vec2FilterDir = vec2(-(u_blurInfo1.z)/u_blurInfo2.x,-(u_blurInfo1.w)/u_blurInfo2.y);\r\n\tvec2 vec2FilterOff = vec2(u_blurInfo1.x/u_blurInfo2.x/c_IterationTime * 2.0,u_blurInfo1.y/u_blurInfo2.y/c_IterationTime * 2.0);\r\n\tfloat maxNum = u_blurInfo1.x * u_blurInfo1.y;\r\n\tvec2 vec2Off = vec2(0.0,0.0);\r\n\tfloat floatOff = c_IterationTime/2.0;\r\n\tfor(float i = 0.0;i<=c_IterationTime; ++i){\r\n\t\tfor(float j = 0.0;j<=c_IterationTime; ++j){\r\n\t\t\tvec2Off = vec2(vec2FilterOff.x * (i - floatOff),vec2FilterOff.y * (j - floatOff));\r\n\t\t\tvec4Color += texture2D(texture, v_texcoordAlpha.xy + vec2FilterDir + vec2Off)/floatIterationTotalTime;\r\n\t\t}\r\n\t}\r\n\tgl_FragColor = vec4(u_color.rgb,vec4Color.a * u_blurInfo2.z);\r\n\tgl_FragColor.rgb *= gl_FragColor.a;   \r\n   #endif\r\n   \r\n}";
    var prime_vs = "attribute vec4 position;\r\nattribute vec4 attribColor;\r\n//attribute vec4 clipDir;\r\n//attribute vec2 clipRect;\r\nuniform vec4 clipMatDir;\r\nuniform vec2 clipMatPos;\r\n#ifdef WORLDMAT\r\n\tuniform mat4 mmat;\r\n#endif\r\nuniform mat4 u_mmat2;\r\n//uniform vec2 u_pos;\r\nuniform vec2 size;\r\nvarying vec4 color;\r\n//vec4 dirxy=vec4(0.9,0.1, -0.1,0.9);\r\n//vec4 clip=vec4(100.,30.,300.,600.);\r\nvarying vec2 cliped;\r\nvoid main(){\r\n\t\r\n#ifdef WORLDMAT\r\n\tvec4 pos=mmat*vec4(position.xy,0.,1.);\r\n\tgl_Position =vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\r\n#else\r\n\tgl_Position =vec4((position.x/size.x-0.5)*2.0,(0.5-position.y/size.y)*2.0,position.z,1.0);\r\n#endif\t\r\n\tfloat clipw = length(clipMatDir.xy);\r\n\tfloat cliph = length(clipMatDir.zw);\r\n\tvec2 clippos = position.xy - clipMatPos.xy;\t//pos已经应用矩阵了，为了减的有意义，clip的位置也要缩放\r\n\tif(clipw>20000. && cliph>20000.)\r\n\t\tcliped = vec2(0.5,0.5);\r\n\telse {\r\n\t\t//clipdir是带缩放的方向，由于上面clippos是在缩放后的空间计算的，所以需要把方向先normalize一下\r\n\t\tcliped=vec2( dot(clippos,clipMatDir.xy)/clipw/clipw, dot(clippos,clipMatDir.zw)/cliph/cliph);\r\n\t}\r\n  //pos2d.x = dot(clippos,dirx);\r\n  color=attribColor/255.;\r\n}";
    var prime_ps = "precision mediump float;\r\n//precision mediump float;\r\nvarying vec4 color;\r\n//uniform float alpha;\r\nvarying vec2 cliped;\r\nvoid main(){\r\n\t//vec4 a=vec4(color.r, color.g, color.b, 1);\r\n\t//a.a*=alpha;\r\n    gl_FragColor= color;// vec4(color.r, color.g, color.b, alpha);\r\n\tgl_FragColor.rgb*=color.a;\r\n\tif(cliped.x<0.) discard;\r\n\tif(cliped.x>1.) discard;\r\n\tif(cliped.y<0.) discard;\r\n\tif(cliped.y>1.) discard;\r\n}";
    var skin_vs = "attribute vec2 position;\r\nattribute vec2 texcoord;\r\nattribute vec4 color;\r\nuniform vec2 size;\r\nuniform float offsetX;\r\nuniform float offsetY;\r\nuniform mat4 mmat;\r\nuniform mat4 u_mmat2;\r\nvarying vec2 v_texcoord;\r\nvarying vec4 v_color;\r\nvoid main() {\r\n  vec4 pos=mmat*u_mmat2*vec4(offsetX+position.x,offsetY+position.y,0,1 );\r\n  gl_Position = vec4((pos.x/size.x-0.5)*2.0,(0.5-pos.y/size.y)*2.0,pos.z,1.0);\r\n  v_color = color;\r\n  v_color.rgb *= v_color.a;\r\n  v_texcoord = texcoord;  \r\n}";
    var skin_ps = "precision mediump float;\r\nvarying vec2 v_texcoord;\r\nvarying vec4 v_color;\r\nuniform sampler2D texture;\r\nuniform float alpha;\r\nvoid main() {\r\n\tvec4 t_color = texture2D(texture, v_texcoord);\r\n\tgl_FragColor = t_color.rgba * v_color;\r\n\tgl_FragColor *= alpha;\r\n}";
    var Shader2D = /*#__PURE__*/
        function () {
            function Shader2D() {
                _classCallCheck(this, Shader2D);
                this.ALPHA = 1;
                this.defines = new ShaderDefines2D();
                this.shaderType = 0;
                this.fillStyle = DrawStyle.DEFAULT;
                this.strokeStyle = DrawStyle.DEFAULT;
            }
            _createClass(Shader2D, [{
                key: "destroy",
                value: function destroy() {
                    this.defines = null;
                    this.filters = null;
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    Shader.preCompile2D(0, ShaderDefines2D.TEXTURE2D, texture_vs, texture_ps, null);
                    Shader.preCompile2D(0, ShaderDefines2D.PRIMITIVE, prime_vs, prime_ps, null);
                    Shader.preCompile2D(0, ShaderDefines2D.SKINMESH, skin_vs, skin_ps, null);
                }
            }]);
            return Shader2D;
        }();
    var SkinMeshBuffer = /*#__PURE__*/
        function () {
            function SkinMeshBuffer() {
                _classCallCheck(this, SkinMeshBuffer);
                var gl = LayaGL.instance;
                this.ib = IndexBuffer2D.create(gl.DYNAMIC_DRAW);
                this.vb = VertexBuffer2D.create(8);
            }
            _createClass(SkinMeshBuffer, [{
                key: "addSkinMesh",
                value: function addSkinMesh(skinMesh) {
                    skinMesh.getData2(this.vb, this.ib, this.vb._byteLength / 32);
                }
            }, {
                key: "reset",
                value: function reset() {
                    this.vb.clear();
                    this.ib.clear();
                }
            }], [{
                key: "getInstance",
                value: function getInstance() {
                    return SkinMeshBuffer.instance = SkinMeshBuffer.instance || new SkinMeshBuffer();
                }
            }]);
            return SkinMeshBuffer;
        }();
    var BasePoly = /*#__PURE__*/
        function () {
            function BasePoly() {
                _classCallCheck(this, BasePoly);
            }
            _createClass(BasePoly, null, [{
                key: "createLine2",
                value: function createLine2(p, indices, lineWidth, indexBase, outVertex, loop) {
                    if (p.length < 4)
                        return null;
                    var points = BasePoly.tempData.length > p.length + 2 ? BasePoly.tempData : new Array(p.length + 2);
                    points[0] = p[0];
                    points[1] = p[1];
                    var newlen = 2;
                    var i = 0;
                    var length = p.length;
                    for (i = 2; i < length; i += 2) {
                        if (Math.abs(p[i] - p[i - 2]) + Math.abs(p[i + 1] - p[i - 1]) > 0.01) {
                            points[newlen++] = p[i];
                            points[newlen++] = p[i + 1];
                        }
                    }
                    if (loop && Math.abs(p[0] - points[newlen - 2]) + Math.abs(p[1] - points[newlen - 1]) > 0.01) {
                        points[newlen++] = p[0];
                        points[newlen++] = p[1];
                    }
                    var result = outVertex;
                    length = newlen / 2;
                    var w = lineWidth / 2;
                    var px, py, p1x, p1y, p2x, p2y, p3x, p3y;
                    var perpx, perpy, perp2x, perp2y;
                    var a1, b1, c1, a2, b2, c2;
                    var denom, dist;
                    p1x = points[0];
                    p1y = points[1];
                    p2x = points[2];
                    p2y = points[3];
                    perpx = -(p1y - p2y);
                    perpy = p1x - p2x;
                    dist = Math.sqrt(perpx * perpx + perpy * perpy);
                    perpx = perpx / dist * w;
                    perpy = perpy / dist * w;
                    result.push(p1x - perpx, p1y - perpy, p1x + perpx, p1y + perpy);
                    for (i = 1; i < length - 1; i++) {
                        p1x = points[(i - 1) * 2];
                        p1y = points[(i - 1) * 2 + 1];
                        p2x = points[i * 2];
                        p2y = points[i * 2 + 1];
                        p3x = points[(i + 1) * 2];
                        p3y = points[(i + 1) * 2 + 1];
                        perpx = -(p1y - p2y);
                        perpy = p1x - p2x;
                        dist = Math.sqrt(perpx * perpx + perpy * perpy);
                        perpx = perpx / dist * w;
                        perpy = perpy / dist * w;
                        perp2x = -(p2y - p3y);
                        perp2y = p2x - p3x;
                        dist = Math.sqrt(perp2x * perp2x + perp2y * perp2y);
                        perp2x = perp2x / dist * w;
                        perp2y = perp2y / dist * w;
                        a1 = -perpy + p1y - (-perpy + p2y);
                        b1 = -perpx + p2x - (-perpx + p1x);
                        c1 = (-perpx + p1x) * (-perpy + p2y) - (-perpx + p2x) * (-perpy + p1y);
                        a2 = -perp2y + p3y - (-perp2y + p2y);
                        b2 = -perp2x + p2x - (-perp2x + p3x);
                        c2 = (-perp2x + p3x) * (-perp2y + p2y) - (-perp2x + p2x) * (-perp2y + p3y);
                        denom = a1 * b2 - a2 * b1;
                        if (Math.abs(denom) < 0.1) {
                            denom += 10.1;
                            result.push(p2x - perpx, p2y - perpy, p2x + perpx, p2y + perpy);
                            continue;
                        }
                        px = (b1 * c2 - b2 * c1) / denom;
                        py = (a2 * c1 - a1 * c2) / denom;
                        result.push(px, py, p2x - (px - p2x), p2y - (py - p2y));
                    }
                    p1x = points[newlen - 4];
                    p1y = points[newlen - 3];
                    p2x = points[newlen - 2];
                    p2y = points[newlen - 1];
                    perpx = -(p1y - p2y);
                    perpy = p1x - p2x;
                    dist = Math.sqrt(perpx * perpx + perpy * perpy);
                    perpx = perpx / dist * w;
                    perpy = perpy / dist * w;
                    result.push(p2x - perpx, p2y - perpy, p2x + perpx, p2y + perpy);
                    for (i = 1; i < length; i++) {
                        indices.push(indexBase + (i - 1) * 2, indexBase + (i - 1) * 2 + 1, indexBase + i * 2 + 1, indexBase + i * 2 + 1, indexBase + i * 2, indexBase + (i - 1) * 2);
                    }
                    return result;
                }
            }, {
                key: "createLineTriangle",
                value: function createLineTriangle(path, color, width, loop, outvb, vbstride, outib) {
                    var points = path.slice();
                    var ptlen = points.length;
                    var p1x = points[0]
                        , p1y = points[1];
                    var p2x = points[2]
                        , p2y = points[2];
                    var len = 0;
                    var rp = 0;
                    var dx = 0
                        , dy = 0;
                    var pointnum = ptlen / 2;
                    if (pointnum <= 1)
                        return;
                    if (pointnum == 2) {
                        return;
                    }
                    var tmpData = new Array(pointnum * 4);
                    var realPtNum = 0;
                    var ci = 0;
                    for (var i = 0; i < pointnum - 1; i++) {
                        p1x = points[ci++],
                            p1y = points[ci++];
                        p2x = points[ci++],
                            p2y = points[ci++];
                        dx = p2x - p1x,
                            dy = p2y - p1y;
                        if (dx != 0 && dy != 0) {
                            len = Math.sqrt(dx * dx + dy * dy);
                            if (len > 1e-3) {
                                rp = realPtNum * 4;
                                tmpData[rp] = p1x;
                                tmpData[rp + 1] = p1y;
                                tmpData[rp + 2] = dx / len;
                                tmpData[rp + 3] = dy / len;
                                realPtNum++;
                            }
                        }
                    }
                    if (loop) {
                        p1x = points[ptlen - 2],
                            p1y = points[ptlen - 1];
                        p2x = points[0],
                            p2y = points[1];
                        dx = p2x - p1x,
                            dy = p2y - p1y;
                        if (dx != 0 && dy != 0) {
                            len = Math.sqrt(dx * dx + dy * dy);
                            if (len > 1e-3) {
                                rp = realPtNum * 4;
                                tmpData[rp] = p1x;
                                tmpData[rp + 1] = p1y;
                                tmpData[rp + 2] = dx / len;
                                tmpData[rp + 3] = dy / len;
                                realPtNum++;
                            }
                        }
                    } else {
                        rp = realPtNum * 4;
                        tmpData[rp] = p1x;
                        tmpData[rp + 1] = p1y;
                        tmpData[rp + 2] = dx / len;
                        tmpData[rp + 3] = dy / len;
                        realPtNum++;
                    }
                    ci = 0;
                    for (i = 0; i < pointnum; i++) {
                        p1x = points[ci],
                            p1y = points[ci + 1];
                        p2x = points[ci + 2],
                            p2y = points[ci + 3];
                    }
                }
            }]);
            return BasePoly;
        }();
    BasePoly.tempData = new Array(256);
    var EarcutNode = /*#__PURE__*/
        _createClass(function EarcutNode(i, x, y) {
            _classCallCheck(this, EarcutNode);
            this.i = i;
            this.x = x;
            this.y = y;
            this.prev = null;
            this.next = null;
            this.z = null;
            this.prevZ = null;
            this.nextZ = null;
            this.steiner = false;
        });
    var Earcut = /*#__PURE__*/
        function () {
            function Earcut() {
                _classCallCheck(this, Earcut);
            }
            _createClass(Earcut, null, [{
                key: "earcut",
                value: function earcut(data, holeIndices, dim) {
                    dim = dim || 2;
                    var hasHoles = holeIndices && holeIndices.length
                        , outerLen = hasHoles ? holeIndices[0] * dim : data.length
                        , outerNode = Earcut.linkedList(data, 0, outerLen, dim, true)
                        , triangles = [];
                    if (!outerNode)
                        return triangles;
                    var minX, minY, maxX, maxY, x, y, invSize;
                    if (hasHoles)
                        outerNode = Earcut.eliminateHoles(data, holeIndices, outerNode, dim);
                    if (data.length > 80 * dim) {
                        minX = maxX = data[0];
                        minY = maxY = data[1];
                        for (var i = dim; i < outerLen; i += dim) {
                            x = data[i];
                            y = data[i + 1];
                            if (x < minX)
                                minX = x;
                            if (y < minY)
                                minY = y;
                            if (x > maxX)
                                maxX = x;
                            if (y > maxY)
                                maxY = y;
                        }
                        invSize = Math.max(maxX - minX, maxY - minY);
                        invSize = invSize !== 0 ? 1 / invSize : 0;
                    }
                    Earcut.earcutLinked(outerNode, triangles, dim, minX, minY, invSize);
                    return triangles;
                }
            }, {
                key: "linkedList",
                value: function linkedList(data, start, end, dim, clockwise) {
                    var i, last;
                    if (clockwise === Earcut.signedArea(data, start, end, dim) > 0) {
                        for (i = start; i < end; i += dim) {
                            last = Earcut.insertNode(i, data[i], data[i + 1], last);
                        }
                    } else {
                        for (i = end - dim; i >= start; i -= dim) {
                            last = Earcut.insertNode(i, data[i], data[i + 1], last);
                        }
                    }
                    if (last && Earcut.equals(last, last.next)) {
                        Earcut.removeNode(last);
                        last = last.next;
                    }
                    return last;
                }
            }, {
                key: "filterPoints",
                value: function filterPoints(start, end) {
                    if (!start)
                        return start;
                    if (!end)
                        end = start;
                    var p = start, again;
                    do {
                        again = false;
                        if (!p.steiner && (Earcut.equals(p, p.next) || Earcut.area(p.prev, p, p.next) === 0)) {
                            Earcut.removeNode(p);
                            p = end = p.prev;
                            if (p === p.next)
                                break;
                            again = true;
                        } else {
                            p = p.next;
                        }
                    } while (again || p !== end);
                    return end;
                }
            }, {
                key: "earcutLinked",
                value: function earcutLinked(ear, triangles, dim, minX, minY, invSize) {
                    var pass = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    if (!ear)
                        return;
                    if (!pass && invSize)
                        Earcut.indexCurve(ear, minX, minY, invSize);
                    var stop = ear, prev, next;
                    while (ear.prev !== ear.next) {
                        prev = ear.prev;
                        next = ear.next;
                        if (invSize ? Earcut.isEarHashed(ear, minX, minY, invSize) : Earcut.isEar(ear)) {
                            triangles.push(prev.i / dim);
                            triangles.push(ear.i / dim);
                            triangles.push(next.i / dim);
                            Earcut.removeNode(ear);
                            ear = next.next;
                            stop = next.next;
                            continue;
                        }
                        ear = next;
                        if (ear === stop) {
                            if (!pass) {
                                Earcut.earcutLinked(Earcut.filterPoints(ear, null), triangles, dim, minX, minY, invSize, 1);
                            } else if (pass === 1) {
                                ear = Earcut.cureLocalIntersections(ear, triangles, dim);
                                Earcut.earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
                            } else if (pass === 2) {
                                Earcut.splitEarcut(ear, triangles, dim, minX, minY, invSize);
                            }
                            break;
                        }
                    }
                }
            }, {
                key: "isEar",
                value: function isEar(ear) {
                    var a = ear.prev
                        , b = ear
                        , c = ear.next;
                    if (Earcut.area(a, b, c) >= 0)
                        return false;
                    var p = ear.next.next;
                    while (p !== ear.prev) {
                        if (Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0)
                            return false;
                        p = p.next;
                    }
                    return true;
                }
            }, {
                key: "isEarHashed",
                value: function isEarHashed(ear, minX, minY, invSize) {
                    var a = ear.prev
                        , b = ear
                        , c = ear.next;
                    if (Earcut.area(a, b, c) >= 0)
                        return false;
                    var minTX = a.x < b.x ? a.x < c.x ? a.x : c.x : b.x < c.x ? b.x : c.x
                        , minTY = a.y < b.y ? a.y < c.y ? a.y : c.y : b.y < c.y ? b.y : c.y
                        , maxTX = a.x > b.x ? a.x > c.x ? a.x : c.x : b.x > c.x ? b.x : c.x
                        , maxTY = a.y > b.y ? a.y > c.y ? a.y : c.y : b.y > c.y ? b.y : c.y;
                    var minZ = Earcut.zOrder(minTX, minTY, minX, minY, invSize)
                        , maxZ = Earcut.zOrder(maxTX, maxTY, minX, minY, invSize);
                    var p = ear.nextZ;
                    while (p && p.z <= maxZ) {
                        if (p !== ear.prev && p !== ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0)
                            return false;
                        p = p.nextZ;
                    }
                    p = ear.prevZ;
                    while (p && p.z >= minZ) {
                        if (p !== ear.prev && p !== ear.next && Earcut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && Earcut.area(p.prev, p, p.next) >= 0)
                            return false;
                        p = p.prevZ;
                    }
                    return true;
                }
            }, {
                key: "cureLocalIntersections",
                value: function cureLocalIntersections(start, triangles, dim) {
                    var p = start;
                    do {
                        var a = p.prev
                            , b = p.next.next;
                        if (!Earcut.equals(a, b) && Earcut.intersects(a, p, p.next, b) && Earcut.locallyInside(a, b) && Earcut.locallyInside(b, a)) {
                            triangles.push(a.i / dim);
                            triangles.push(p.i / dim);
                            triangles.push(b.i / dim);
                            Earcut.removeNode(p);
                            Earcut.removeNode(p.next);
                            p = start = b;
                        }
                        p = p.next;
                    } while (p !== start);
                    return p;
                }
            }, {
                key: "splitEarcut",
                value: function splitEarcut(start, triangles, dim, minX, minY, invSize) {
                    var a = start;
                    do {
                        var b = a.next.next;
                        while (b !== a.prev) {
                            if (a.i !== b.i && Earcut.isValidDiagonal(a, b)) {
                                var c = Earcut.splitPolygon(a, b);
                                a = Earcut.filterPoints(a, a.next);
                                c = Earcut.filterPoints(c, c.next);
                                Earcut.earcutLinked(a, triangles, dim, minX, minY, invSize);
                                Earcut.earcutLinked(c, triangles, dim, minX, minY, invSize);
                                return;
                            }
                            b = b.next;
                        }
                        a = a.next;
                    } while (a !== start);
                }
            }, {
                key: "eliminateHoles",
                value: function eliminateHoles(data, holeIndices, outerNode, dim) {
                    var queue = [], i, len, start, end, list;
                    for (i = 0,
                        len = holeIndices.length; i < len; i++) {
                        start = holeIndices[i] * dim;
                        end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
                        list = Earcut.linkedList(data, start, end, dim, false);
                        if (list === list.next)
                            list.steiner = true;
                        queue.push(Earcut.getLeftmost(list));
                    }
                    queue.sort(Earcut.compareX);
                    for (i = 0; i < queue.length; i++) {
                        Earcut.eliminateHole(queue[i], outerNode);
                        outerNode = Earcut.filterPoints(outerNode, outerNode.next);
                    }
                    return outerNode;
                }
            }, {
                key: "compareX",
                value: function compareX(a, b) {
                    return a.x - b.x;
                }
            }, {
                key: "eliminateHole",
                value: function eliminateHole(hole, outerNode) {
                    outerNode = Earcut.findHoleBridge(hole, outerNode);
                    if (outerNode) {
                        var b = Earcut.splitPolygon(outerNode, hole);
                        Earcut.filterPoints(b, b.next);
                    }
                }
            }, {
                key: "findHoleBridge",
                value: function findHoleBridge(hole, outerNode) {
                    var p = outerNode, hx = hole.x, hy = hole.y, qx = -Infinity, m;
                    do {
                        if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
                            var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
                            if (x <= hx && x > qx) {
                                qx = x;
                                if (x === hx) {
                                    if (hy === p.y)
                                        return p;
                                    if (hy === p.next.y)
                                        return p.next;
                                }
                                m = p.x < p.next.x ? p : p.next;
                            }
                        }
                        p = p.next;
                    } while (p !== outerNode);
                    if (!m)
                        return null;
                    if (hx === qx)
                        return m.prev;
                    var stop = m, mx = m.x, my = m.y, tanMin = Infinity, tan;
                    p = m.next;
                    while (p !== stop) {
                        if (hx >= p.x && p.x >= mx && hx !== p.x && Earcut.pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
                            tan = Math.abs(hy - p.y) / (hx - p.x);
                            if ((tan < tanMin || tan === tanMin && p.x > m.x) && Earcut.locallyInside(p, hole)) {
                                m = p;
                                tanMin = tan;
                            }
                        }
                        p = p.next;
                    }
                    return m;
                }
            }, {
                key: "indexCurve",
                value: function indexCurve(start, minX, minY, invSize) {
                    var p = start;
                    do {
                        if (p.z === null)
                            p.z = Earcut.zOrder(p.x, p.y, minX, minY, invSize);
                        p.prevZ = p.prev;
                        p.nextZ = p.next;
                        p = p.next;
                    } while (p !== start);
                    p.prevZ.nextZ = null;
                    p.prevZ = null;
                    Earcut.sortLinked(p);
                }
            }, {
                key: "sortLinked",
                value: function sortLinked(list) {
                    var i, p, q, e, tail, numMerges, pSize, qSize, inSize = 1;
                    do {
                        p = list;
                        list = null;
                        tail = null;
                        numMerges = 0;
                        while (p) {
                            numMerges++;
                            q = p;
                            pSize = 0;
                            for (i = 0; i < inSize; i++) {
                                pSize++;
                                q = q.nextZ;
                                if (!q)
                                    break;
                            }
                            qSize = inSize;
                            while (pSize > 0 || qSize > 0 && q) {
                                if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
                                    e = p;
                                    p = p.nextZ;
                                    pSize--;
                                } else {
                                    e = q;
                                    q = q.nextZ;
                                    qSize--;
                                }
                                if (tail)
                                    tail.nextZ = e;
                                else
                                    list = e;
                                e.prevZ = tail;
                                tail = e;
                            }
                            p = q;
                        }
                        tail.nextZ = null;
                        inSize *= 2;
                    } while (numMerges > 1);
                    return list;
                }
            }, {
                key: "zOrder",
                value: function zOrder(x, y, minX, minY, invSize) {
                    x = 32767 * (x - minX) * invSize;
                    y = 32767 * (y - minY) * invSize;
                    x = (x | x << 8) & 0x00FF00FF;
                    x = (x | x << 4) & 0x0F0F0F0F;
                    x = (x | x << 2) & 0x33333333;
                    x = (x | x << 1) & 0x55555555;
                    y = (y | y << 8) & 0x00FF00FF;
                    y = (y | y << 4) & 0x0F0F0F0F;
                    y = (y | y << 2) & 0x33333333;
                    y = (y | y << 1) & 0x55555555;
                    return x | y << 1;
                }
            }, {
                key: "getLeftmost",
                value: function getLeftmost(start) {
                    var p = start
                        , leftmost = start;
                    do {
                        if (p.x < leftmost.x)
                            leftmost = p;
                        p = p.next;
                    } while (p !== start);
                    return leftmost;
                }
            }, {
                key: "pointInTriangle",
                value: function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
                    return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0;
                }
            }, {
                key: "isValidDiagonal",
                value: function isValidDiagonal(a, b) {
                    return a.next.i !== b.i && a.prev.i !== b.i && !Earcut.intersectsPolygon(a, b) && Earcut.locallyInside(a, b) && Earcut.locallyInside(b, a) && Earcut.middleInside(a, b);
                }
            }, {
                key: "area",
                value: function area(p, q, r) {
                    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
                }
            }, {
                key: "equals",
                value: function equals(p1, p2) {
                    return p1.x === p2.x && p1.y === p2.y;
                }
            }, {
                key: "intersects",
                value: function intersects(p1, q1, p2, q2) {
                    if (Earcut.equals(p1, q1) && Earcut.equals(p2, q2) || Earcut.equals(p1, q2) && Earcut.equals(p2, q1))
                        return true;
                    return Earcut.area(p1, q1, p2) > 0 !== Earcut.area(p1, q1, q2) > 0 && Earcut.area(p2, q2, p1) > 0 !== Earcut.area(p2, q2, q1) > 0;
                }
            }, {
                key: "intersectsPolygon",
                value: function intersectsPolygon(a, b) {
                    var p = a;
                    do {
                        if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i && Earcut.intersects(p, p.next, a, b))
                            return true;
                        p = p.next;
                    } while (p !== a);
                    return false;
                }
            }, {
                key: "locallyInside",
                value: function locallyInside(a, b) {
                    return Earcut.area(a.prev, a, a.next) < 0 ? Earcut.area(a, b, a.next) >= 0 && Earcut.area(a, a.prev, b) >= 0 : Earcut.area(a, b, a.prev) < 0 || Earcut.area(a, a.next, b) < 0;
                }
            }, {
                key: "middleInside",
                value: function middleInside(a, b) {
                    var p = a
                        , inside = false
                        , px = (a.x + b.x) / 2
                        , py = (a.y + b.y) / 2;
                    do {
                        if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
                            inside = !inside;
                        p = p.next;
                    } while (p !== a);
                    return inside;
                }
            }, {
                key: "splitPolygon",
                value: function splitPolygon(a, b) {
                    var a2 = new EarcutNode(a.i, a.x, a.y)
                        , b2 = new EarcutNode(b.i, b.x, b.y)
                        , an = a.next
                        , bp = b.prev;
                    a.next = b;
                    b.prev = a;
                    a2.next = an;
                    an.prev = a2;
                    b2.next = a2;
                    a2.prev = b2;
                    bp.next = b2;
                    b2.prev = bp;
                    return b2;
                }
            }, {
                key: "insertNode",
                value: function insertNode(i, x, y, last) {
                    var p = new EarcutNode(i, x, y);
                    if (!last) {
                        p.prev = p;
                        p.next = p;
                    } else {
                        p.next = last.next;
                        p.prev = last;
                        last.next.prev = p;
                        last.next = p;
                    }
                    return p;
                }
            }, {
                key: "removeNode",
                value: function removeNode(p) {
                    p.next.prev = p.prev;
                    p.prev.next = p.next;
                    if (p.prevZ)
                        p.prevZ.nextZ = p.nextZ;
                    if (p.nextZ)
                        p.nextZ.prevZ = p.prevZ;
                }
            }, {
                key: "signedArea",
                value: function signedArea(data, start, end, dim) {
                    var sum = 0;
                    for (var i = start, j = end - dim; i < end; i += dim) {
                        sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
                        j = i;
                    }
                    return sum;
                }
            }]);
            return Earcut;
        }();
    var CONST3D2D = /*#__PURE__*/
        _createClass(function CONST3D2D() {
            _classCallCheck(this, CONST3D2D);
        });
    CONST3D2D.BYTES_PE = 4;
    CONST3D2D.BYTES_PIDX = 2;
    CONST3D2D.defaultMatrix4 = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
    CONST3D2D.defaultMinusYMatrix4 = [1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1];
    CONST3D2D.uniformMatrix3 = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0];
    CONST3D2D._TMPARRAY = [];
    CONST3D2D._OFFSETX = 0;
    CONST3D2D._OFFSETY = 0;
    var Submit = /*#__PURE__*/
        function (_SubmitBase) {
            _inherits(Submit, _SubmitBase);
            var _super19 = _createSuper(Submit);
            function Submit() {
                var renderType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SubmitBase.TYPE_2D;
                _classCallCheck(this, Submit);
                return _super19.call(this, renderType);
            }
            _createClass(Submit, [{
                key: "renderSubmit",
                value: function renderSubmit() {
                    if (this._numEle === 0 || !this._mesh || this._numEle == 0)
                        return 1;
                    var _tex = this.shaderValue.textureHost;
                    if (_tex) {
                        var source = _tex._getSource();
                        if (!source)
                            return 1;
                        this.shaderValue.texture = source;
                    }
                    var gl = WebGLContext.mainContext;
                    this._mesh.useMesh(gl);
                    this.shaderValue.upload();
                    if (BlendMode.activeBlendFunction !== this._blendFn) {
                        WebGLContext.setBlend(gl, true);
                        this._blendFn(gl);
                        BlendMode.activeBlendFunction = this._blendFn;
                    }
                    gl.drawElements(gl.TRIANGLES, this._numEle, gl.UNSIGNED_SHORT, this._startIdx);
                    Stat.renderBatches++;
                    Stat.trianglesFaces += this._numEle / 3;
                    return 1;
                }
            }, {
                key: "releaseRender",
                value: function releaseRender() {
                    if (SubmitBase.RENDERBASE == this)
                        return;
                    if (--this._ref < 1) {
                        Submit.POOL[Submit._poolSize++] = this;
                        this.shaderValue.release();
                        this.shaderValue = null;
                        this._mesh = null;
                        this._parent && (this._parent.releaseRender(),
                            this._parent = null);
                    }
                }
            }], [{
                key: "create",
                value: function create(context, mesh, sv) {
                    var o = Submit._poolSize ? Submit.POOL[--Submit._poolSize] : new Submit();
                    o._ref = 1;
                    o._mesh = mesh;
                    o._key.clear();
                    o._startIdx = mesh.indexNum * CONST3D2D.BYTES_PIDX;
                    o._numEle = 0;
                    var blendType = context._nBlendType;
                    o._blendFn = context._targets ? BlendMode.targetFns[blendType] : BlendMode.fns[blendType];
                    o.shaderValue = sv;
                    o.shaderValue.setValue(context._shader2D);
                    var filters = context._shader2D.filters;
                    filters && o.shaderValue.setFilters(filters);
                    return o;
                }
            }, {
                key: "createShape",
                value: function createShape(ctx, mesh, numEle, sv) {
                    var o = Submit._poolSize ? Submit.POOL[--Submit._poolSize] : new Submit();
                    o._mesh = mesh;
                    o._numEle = numEle;
                    o._startIdx = mesh.indexNum * 2;
                    o._ref = 1;
                    o.shaderValue = sv;
                    o.shaderValue.setValue(ctx._shader2D);
                    var blendType = ctx._nBlendType;
                    o._key.blendShader = blendType;
                    o._blendFn = ctx._targets ? BlendMode.targetFns[blendType] : BlendMode.fns[blendType];
                    return o;
                }
            }]);
            return Submit;
        }(SubmitBase);
    Submit._poolSize = 0;
    Submit.POOL = [];
    var SubmitCanvas = /*#__PURE__*/
        function (_SubmitBase2) {
            _inherits(SubmitCanvas, _SubmitBase2);
            var _super20 = _createSuper(SubmitCanvas);
            function SubmitCanvas() {
                var _this16;
                _classCallCheck(this, SubmitCanvas);
                _this16 = _super20.call(this, SubmitBase.TYPE_2D);
                _this16._matrix = new Matrix();
                _this16._matrix4 = CONST3D2D.defaultMatrix4.concat();
                _this16.shaderValue = new Value2D(0, 0);
                return _this16;
            }
            _createClass(SubmitCanvas, [{
                key: "renderSubmit",
                value: function renderSubmit() {
                    var preAlpha = RenderState2D.worldAlpha;
                    var preMatrix4 = RenderState2D.worldMatrix4;
                    var preMatrix = RenderState2D.worldMatrix;
                    var preFilters = RenderState2D.worldFilters;
                    var preWorldShaderDefines = RenderState2D.worldShaderDefines;
                    var v = this.shaderValue;
                    var m = this._matrix;
                    var m4 = this._matrix4;
                    var mout = Matrix.TEMP;
                    Matrix.mul(m, preMatrix, mout);
                    m4[0] = mout.a;
                    m4[1] = mout.b;
                    m4[4] = mout.c;
                    m4[5] = mout.d;
                    m4[12] = mout.tx;
                    m4[13] = mout.ty;
                    RenderState2D.worldMatrix = mout.clone();
                    RenderState2D.worldMatrix4 = m4;
                    RenderState2D.worldAlpha = RenderState2D.worldAlpha * v.alpha;
                    if (v.filters && v.filters.length) {
                        RenderState2D.worldFilters = v.filters;
                        RenderState2D.worldShaderDefines = v.defines;
                    }
                    this.canv['flushsubmit']();
                    RenderState2D.worldAlpha = preAlpha;
                    RenderState2D.worldMatrix4 = preMatrix4;
                    RenderState2D.worldMatrix.destroy();
                    RenderState2D.worldMatrix = preMatrix;
                    RenderState2D.worldFilters = preFilters;
                    RenderState2D.worldShaderDefines = preWorldShaderDefines;
                    return 1;
                }
            }, {
                key: "releaseRender",
                value: function releaseRender() {
                    if (--this._ref < 1) {
                        var cache = SubmitCanvas.POOL;
                        this._mesh = null;
                        cache[cache._length++] = this;
                    }
                }
            }, {
                key: "getRenderType",
                value: function getRenderType() {
                    return SubmitBase.TYPE_CANVAS;
                }
            }], [{
                key: "create",
                value: function create(canvas, alpha, filters) {
                    var o = !SubmitCanvas.POOL._length ? new SubmitCanvas() : SubmitCanvas.POOL[--SubmitCanvas.POOL._length];
                    o.canv = canvas;
                    o._ref = 1;
                    o._numEle = 0;
                    var v = o.shaderValue;
                    v.alpha = alpha;
                    v.defines.setValue(0);
                    filters && filters.length && v.setFilters(filters);
                    return o;
                }
            }]);
            return SubmitCanvas;
        }(SubmitBase);
    SubmitCanvas.POOL = [];
    {
        SubmitCanvas.POOL._length = 0;
    }
    var SubmitTarget = /*#__PURE__*/
        function () {
            function SubmitTarget() {
                _classCallCheck(this, SubmitTarget);
                this.blendType = 0;
                this._ref = 1;
                this._key = new SubmitKey();
            }
            _createClass(SubmitTarget, [{
                key: "renderSubmit",
                value: function renderSubmit() {
                    var gl = WebGLContext.mainContext;
                    this._mesh.useMesh(gl);
                    var target = this.srcRT;
                    if (target) {
                        this.shaderValue.texture = target._getSource();
                        this.shaderValue.upload();
                        this.blend();
                        Stat.renderBatches++;
                        Stat.trianglesFaces += this._numEle / 3;
                        gl.drawElements(gl.TRIANGLES, this._numEle, gl.UNSIGNED_SHORT, this._startIdx);
                    }
                    return 1;
                }
            }, {
                key: "blend",
                value: function blend() {
                    if (BlendMode.activeBlendFunction !== BlendMode.fns[this.blendType]) {
                        var gl = WebGLContext.mainContext;
                        gl.enable(gl.BLEND);
                        BlendMode.fns[this.blendType](gl);
                        BlendMode.activeBlendFunction = BlendMode.fns[this.blendType];
                    }
                }
            }, {
                key: "getRenderType",
                value: function getRenderType() {
                    return 0;
                }
            }, {
                key: "releaseRender",
                value: function releaseRender() {
                    if (--this._ref < 1) {
                        var pool = SubmitTarget.POOL;
                        pool[pool._length++] = this;
                    }
                }
            }], [{
                key: "create",
                value: function create(context, mesh, sv, rt) {
                    var o = SubmitTarget.POOL._length ? SubmitTarget.POOL[--SubmitTarget.POOL._length] : new SubmitTarget();
                    o._mesh = mesh;
                    o.srcRT = rt;
                    o._startIdx = mesh.indexNum * CONST3D2D.BYTES_PIDX;
                    o._ref = 1;
                    o._key.clear();
                    o._numEle = 0;
                    o.blendType = context._nBlendType;
                    o._key.blendShader = o.blendType;
                    o.shaderValue = sv;
                    o.shaderValue.setValue(context._shader2D);
                    if (context._colorFiler) {
                        var ft = context._colorFiler;
                        sv.defines.add(ft.type);
                        sv.colorMat = ft._mat;
                        sv.colorAlpha = ft._alpha;
                    }
                    return o;
                }
            }]);
            return SubmitTarget;
        }();
    SubmitTarget.POOL = [];
    {
        SubmitTarget.POOL._length = 0;
    }
    var SubmitTexture = /*#__PURE__*/
        function (_SubmitBase3) {
            _inherits(SubmitTexture, _SubmitBase3);
            var _super21 = _createSuper(SubmitTexture);
            function SubmitTexture() {
                var renderType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SubmitBase.TYPE_2D;
                _classCallCheck(this, SubmitTexture);
                return _super21.call(this, renderType);
            }
            _createClass(SubmitTexture, [{
                key: "releaseRender",
                value: function releaseRender() {
                    if (--this._ref < 1) {
                        SubmitTexture.POOL[SubmitTexture._poolSize++] = this;
                        this.shaderValue.release();
                        this._mesh = null;
                        this._parent && (this._parent.releaseRender(),
                            this._parent = null);
                    }
                }
            }, {
                key: "renderSubmit",
                value: function renderSubmit() {
                    if (this._numEle === 0)
                        return 1;
                    var tex = this.shaderValue.textureHost;
                    if (tex) {
                        var source = tex ? tex._getSource() : null;
                        if (!source)
                            return 1;
                    }
                    var gl = WebGLContext.mainContext;
                    this._mesh.useMesh(gl);
                    var lastSubmit = SubmitBase.preRender;
                    var prekey = SubmitBase.preRender._key;
                    if (this._key.blendShader === 0 && this._key.submitType === prekey.submitType && this._key.blendShader === prekey.blendShader && BaseShader.activeShader && SubmitBase.preRender.clipInfoID == this.clipInfoID && lastSubmit.shaderValue.defines._value === this.shaderValue.defines._value && (this.shaderValue.defines._value & ShaderDefines2D.NOOPTMASK) == 0) {
                        BaseShader.activeShader.uploadTexture2D(source);
                    } else {
                        if (BlendMode.activeBlendFunction !== this._blendFn) {
                            WebGLContext.setBlend(gl, true);
                            this._blendFn(gl);
                            BlendMode.activeBlendFunction = this._blendFn;
                        }
                        this.shaderValue.texture = source;
                        this.shaderValue.upload();
                    }
                    gl.drawElements(gl.TRIANGLES, this._numEle, gl.UNSIGNED_SHORT, this._startIdx);
                    Stat.renderBatches++;
                    Stat.trianglesFaces += this._numEle / 3;
                    return 1;
                }
            }], [{
                key: "create",
                value: function create(context, mesh, sv) {
                    var o = SubmitTexture._poolSize ? SubmitTexture.POOL[--SubmitTexture._poolSize] : new SubmitTexture(SubmitBase.TYPE_TEXTURE);
                    o._mesh = mesh;
                    o._key.clear();
                    o._key.submitType = SubmitBase.KEY_DRAWTEXTURE;
                    o._ref = 1;
                    o._startIdx = mesh.indexNum * CONST3D2D.BYTES_PIDX;
                    o._numEle = 0;
                    var blendType = context._nBlendType;
                    o._key.blendShader = blendType;
                    o._blendFn = context._targets ? BlendMode.targetFns[blendType] : BlendMode.fns[blendType];
                    o.shaderValue = sv;
                    if (context._colorFiler) {
                        var ft = context._colorFiler;
                        sv.defines.add(ft.type);
                        sv.colorMat = ft._mat;
                        sv.colorAlpha = ft._alpha;
                    }
                    return o;
                }
            }]);
            return SubmitTexture;
        }(SubmitBase);
    SubmitTexture._poolSize = 0;
    SubmitTexture.POOL = [];
    var CharSubmitCache = /*#__PURE__*/
        function () {
            function CharSubmitCache() {
                _classCallCheck(this, CharSubmitCache);
                this._data = [];
                this._ndata = 0;
                this._clipid = -1;
                this._clipMatrix = new Matrix();
                this._enable = false;
            }
            _createClass(CharSubmitCache, [{
                key: "clear",
                value: function clear() {
                    this._tex = null;
                    this._imgId = -1;
                    this._ndata = 0;
                    this._enable = false;
                    this._colorFiler = null;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this.clear();
                    this._data.length = 0;
                    this._data = null;
                }
            }, {
                key: "add",
                value: function add(ctx, tex, imgid, pos, uv, color) {
                    if (this._ndata > 0 && (this._tex != tex || this._imgId != imgid || this._clipid >= 0 && this._clipid != ctx._clipInfoID)) {
                        this.submit(ctx);
                    }
                    this._clipid = ctx._clipInfoID;
                    ctx._globalClipMatrix.copyTo(this._clipMatrix);
                    this._tex = tex;
                    this._imgId = imgid;
                    this._colorFiler = ctx._colorFiler;
                    this._data[this._ndata] = pos;
                    this._data[this._ndata + 1] = uv;
                    this._data[this._ndata + 2] = color;
                    this._ndata += 3;
                }
            }, {
                key: "getPos",
                value: function getPos() {
                    if (CharSubmitCache.__nPosPool == 0)
                        return new Array(8);
                    return CharSubmitCache.__posPool[--CharSubmitCache.__nPosPool];
                }
            }, {
                key: "enable",
                value: function enable(value, ctx) {
                    if (value === this._enable)
                        return;
                    this._enable = value;
                    this._enable || this.submit(ctx);
                }
            }, {
                key: "submit",
                value: function submit(ctx) {
                    var n = this._ndata;
                    if (!n)
                        return;
                    var _mesh = ctx._mesh;
                    var colorFiler = ctx._colorFiler;
                    ctx._colorFiler = this._colorFiler;
                    var submit = SubmitTexture.create(ctx, _mesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                    ctx._submits[ctx._submits._length++] = ctx._curSubmit = submit;
                    submit.shaderValue.textureHost = this._tex;
                    submit._key.other = this._imgId;
                    ctx._colorFiler = colorFiler;
                    ctx._copyClipInfo(submit, this._clipMatrix);
                    submit.clipInfoID = this._clipid;
                    for (var i = 0; i < n; i += 3) {
                        _mesh.addQuad(this._data[i], this._data[i + 1], this._data[i + 2], true);
                        CharSubmitCache.__posPool[CharSubmitCache.__nPosPool++] = this._data[i];
                    }
                    n /= 3;
                    submit._numEle += n * 6;
                    _mesh.indexNum += n * 6;
                    _mesh.vertNum += n * 4;
                    ctx._drawCount += n;
                    this._ndata = 0;
                    if (RenderInfo.loopCount % 100 == 0)
                        this._data.length = 0;
                }
            }]);
            return CharSubmitCache;
        }();
    CharSubmitCache.__posPool = [];
    CharSubmitCache.__nPosPool = 0;
    var AtlasGrid = /*#__PURE__*/
        function () {
            function AtlasGrid() {
                var width = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                var id = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                _classCallCheck(this, AtlasGrid);
                this.atlasID = 0;
                this._width = 0;
                this._height = 0;
                this._texCount = 0;
                this._rowInfo = null;
                this._cells = null;
                this._used = 0;
                this._cells = null;
                this._rowInfo = null;
                this.atlasID = id;
                this._init(width, height);
            }
            _createClass(AtlasGrid, [{
                key: "addRect",
                value: function addRect(type, width, height, pt) {
                    if (!this._get(width, height, pt))
                        return false;
                    this._fill(pt.x, pt.y, width, height, type);
                    this._texCount++;
                    return true;
                }
            }, {
                key: "_release",
                value: function _release() {
                    this._cells = null;
                    this._rowInfo = null;
                }
            }, {
                key: "_init",
                value: function _init(width, height) {
                    this._width = width;
                    this._height = height;
                    this._release();
                    if (this._width == 0)
                        return false;
                    this._cells = new Uint8Array(this._width * this._height * 3);
                    this._rowInfo = new Uint8Array(this._height);
                    this._used = 0;
                    this._clear();
                    return true;
                }
            }, {
                key: "_get",
                value: function _get(width, height, pt) {
                    if (width > this._width || height > this._height) {
                        return false;
                    }
                    var rx = -1;
                    var ry = -1;
                    var nWidth = this._width;
                    var nHeight = this._height;
                    var pCellBox = this._cells;
                    for (var y = 0; y < nHeight; y++) {
                        if (this._rowInfo[y] < width)
                            continue;
                        for (var x = 0; x < nWidth;) {
                            var tm = (y * nWidth + x) * 3;
                            if (pCellBox[tm] != 0 || pCellBox[tm + 1] < width || pCellBox[tm + 2] < height) {
                                x += pCellBox[tm + 1];
                                continue;
                            }
                            rx = x;
                            ry = y;
                            for (var xx = 0; xx < width; xx++) {
                                if (pCellBox[3 * xx + tm + 2] < height) {
                                    rx = -1;
                                    break;
                                }
                            }
                            if (rx < 0) {
                                x += pCellBox[tm + 1];
                                continue;
                            }
                            pt.x = rx;
                            pt.y = ry;
                            return true;
                        }
                    }
                    return false;
                }
            }, {
                key: "_fill",
                value: function _fill(x, y, w, h, type) {
                    var nWidth = this._width;
                    var nHeghit = this._height;
                    this._check(x + w <= nWidth && y + h <= nHeghit);
                    for (var yy = y; yy < h + y; ++yy) {
                        this._check(this._rowInfo[yy] >= w);
                        this._rowInfo[yy] -= w;
                        for (var xx = 0; xx < w; xx++) {
                            var tm = (x + yy * nWidth + xx) * 3;
                            this._check(this._cells[tm] == 0);
                            this._cells[tm] = type;
                            this._cells[tm + 1] = w;
                            this._cells[tm + 2] = h;
                        }
                    }
                    if (x > 0) {
                        for (yy = 0; yy < h; ++yy) {
                            var s = 0;
                            for (xx = x - 1; xx >= 0; --xx,
                                ++s) {
                                if (this._cells[((y + yy) * nWidth + xx) * 3] != 0)
                                    break;
                            }
                            for (xx = s; xx > 0; --xx) {
                                this._cells[((y + yy) * nWidth + x - xx) * 3 + 1] = xx;
                                this._check(xx > 0);
                            }
                        }
                    }
                    if (y > 0) {
                        for (xx = x; xx < x + w; ++xx) {
                            s = 0;
                            for (yy = y - 1; yy >= 0; --yy,
                                s++) {
                                if (this._cells[(xx + yy * nWidth) * 3] != 0)
                                    break;
                            }
                            for (yy = s; yy > 0; --yy) {
                                this._cells[(xx + (y - yy) * nWidth) * 3 + 2] = yy;
                                this._check(yy > 0);
                            }
                        }
                    }
                    this._used += w * h / (this._width * this._height);
                }
            }, {
                key: "_check",
                value: function _check(ret) {
                    if (ret == false) {
                        console.log("xtexMerger 错误啦");
                    }
                }
            }, {
                key: "_clear",
                value: function _clear() {
                    this._texCount = 0;
                    for (var y = 0; y < this._height; y++) {
                        this._rowInfo[y] = this._width;
                    }
                    for (var i = 0; i < this._height; i++) {
                        for (var j = 0; j < this._width; j++) {
                            var tm = (i * this._width + j) * 3;
                            this._cells[tm] = 0;
                            this._cells[tm + 1] = this._width - j;
                            this._cells[tm + 2] = this._width - i;
                        }
                    }
                }
            }]);
            return AtlasGrid;
        }();
    var TextTexture = /*#__PURE__*/
        function (_Resource3) {
            _inherits(TextTexture, _Resource3);
            var _super22 = _createSuper(TextTexture);
            function TextTexture(textureW, textureH) {
                var _this17;
                _classCallCheck(this, TextTexture);
                _this17 = _super22.call(this);
                _this17._texW = 0;
                _this17._texH = 0;
                _this17.__destroyed = false;
                _this17._discardTm = 0;
                _this17.genID = 0;
                _this17.bitmap = {
                    id: 0,
                    _glTexture: null
                };
                _this17.curUsedCovRate = 0;
                _this17.curUsedCovRateAtlas = 0;
                _this17.lastTouchTm = 0;
                _this17.ri = null;
                _this17._texW = textureW || TextTexture.gTextRender.atlasWidth;
                _this17._texH = textureH || TextTexture.gTextRender.atlasWidth;
                _this17.bitmap.id = _this17.id;
                _this17.lock = true;
                return _this17;
            }
            _createClass(TextTexture, [{
                key: "recreateResource",
                value: function recreateResource() {
                    if (this._source)
                        return;
                    var gl = LayaGL.instance;
                    var glTex = this._source = gl.createTexture();
                    this.bitmap._glTexture = glTex;
                    WebGLContext.bindTexture(gl, gl.TEXTURE_2D, glTex);
                    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, this._texW, this._texH, 0, gl.RGBA, gl.UNSIGNED_BYTE, null);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
                    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
                    if (TextTexture.gTextRender.debugUV) {
                        this.fillWhite();
                    }
                }
            }, {
                key: "addChar",
                value: function addChar(data, x, y) {
                    var uv = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    if (TextTexture.gTextRender.isWan1Wan) {
                        return this.addCharCanvas(data, x, y, uv);
                    }
                    !this._source && this.recreateResource();
                    var gl = LayaGL.instance;
                    WebGLContext.bindTexture(gl, gl.TEXTURE_2D, this._source);
                    !ILaya.Render.isConchApp && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, true);
                    var dt = data.data;
                    if (data.data instanceof Uint8ClampedArray)
                        dt = new Uint8Array(dt.buffer);
                    gl.texSubImage2D(gl.TEXTURE_2D, 0, x, y, data.width, data.height, gl.RGBA, gl.UNSIGNED_BYTE, dt);
                    !ILaya.Render.isConchApp && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
                    var u0;
                    var v0;
                    var u1;
                    var v1;
                    u0 = x / this._texW;
                    v0 = y / this._texH;
                    u1 = (x + data.width) / this._texW;
                    v1 = (y + data.height) / this._texH;
                    uv = uv || new Array(8);
                    uv[0] = u0,
                        uv[1] = v0;
                    uv[2] = u1,
                        uv[3] = v0;
                    uv[4] = u1,
                        uv[5] = v1;
                    uv[6] = u0,
                        uv[7] = v1;
                    return uv;
                }
            }, {
                key: "addCharCanvas",
                value: function addCharCanvas(canv, x, y) {
                    var uv = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    !this._source && this.recreateResource();
                    var gl = LayaGL.instance;
                    WebGLContext.bindTexture(gl, gl.TEXTURE_2D, this._source);
                    !ILaya.Render.isConchApp && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, true);
                    gl.texSubImage2D(gl.TEXTURE_2D, 0, x, y, gl.RGBA, gl.UNSIGNED_BYTE, canv);
                    !ILaya.Render.isConchApp && gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
                    var u0;
                    var v0;
                    var u1;
                    var v1;
                    if (ILaya.Render.isConchApp) {
                        u0 = x / this._texW;
                        v0 = y / this._texH;
                        u1 = (x + canv.width) / this._texW;
                        v1 = (y + canv.height) / this._texH;
                    } else {
                        u0 = (x + 1) / this._texW;
                        v0 = (y + 1) / this._texH;
                        u1 = (x + canv.width - 1) / this._texW;
                        v1 = (y + canv.height - 1) / this._texH;
                    }
                    uv = uv || new Array(8);
                    uv[0] = u0,
                        uv[1] = v0;
                    uv[2] = u1,
                        uv[3] = v0;
                    uv[4] = u1,
                        uv[5] = v1;
                    uv[6] = u0,
                        uv[7] = v1;
                    return uv;
                }
            }, {
                key: "fillWhite",
                value: function fillWhite() {
                    !this._source && this.recreateResource();
                    var gl = LayaGL.instance;
                    var dt = new Uint8Array(this._texW * this._texH * 4);
                    dt.fill(0xff);
                    gl.texSubImage2D(gl.TEXTURE_2D, 0, 0, 0, this._texW, this._texH, gl.RGBA, gl.UNSIGNED_BYTE, dt);
                }
            }, {
                key: "discard",
                value: function discard() {
                    ILaya.stage.setGlobalRepaint();
                    this.destroy();
                    return;
                    if (this._texW != TextTexture.gTextRender.atlasWidth || this._texH != TextTexture.gTextRender.atlasWidth) {
                        this.destroy();
                        return;
                    }
                    this.genID++;
                    if (TextTexture.poolLen >= TextTexture.pool.length) {
                        TextTexture.pool = TextTexture.pool.concat(new Array(10));
                    }
                    this._discardTm = RenderInfo.loopStTm;
                    TextTexture.pool[TextTexture.poolLen++] = this;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    this.__destroyed = true;
                    var gl = LayaGL.instance;
                    this._source && gl.deleteTexture(this._source);
                    this._source = null;
                }
            }, {
                key: "touchRect",
                value: function touchRect(ri, curloop) {
                    if (this.lastTouchTm != curloop) {
                        this.curUsedCovRate = 0;
                        this.curUsedCovRateAtlas = 0;
                        this.lastTouchTm = curloop;
                    }
                    var texw2 = TextTexture.gTextRender.atlasWidth * TextTexture.gTextRender.atlasWidth;
                    var gridw2 = ILaya.TextAtlas.atlasGridW * ILaya.TextAtlas.atlasGridW;
                    this.curUsedCovRate += ri.bmpWidth * ri.bmpHeight / texw2;
                    this.curUsedCovRateAtlas += Math.ceil(ri.bmpWidth / ILaya.TextAtlas.atlasGridW) * Math.ceil(ri.bmpHeight / ILaya.TextAtlas.atlasGridW) / (texw2 / gridw2);
                }
            }, {
                key: "texture",
                get: function get() {
                    return this;
                }
            }, {
                key: "_getSource",
                value: function _getSource() {
                    return this._source;
                }
            }, {
                key: "drawOnScreen",
                value: function drawOnScreen(x, y) { }
            }], [{
                key: "getTextTexture",
                value: function getTextTexture(w, h) {
                    return new TextTexture(w, h);
                    if (w != TextTexture.gTextRender.atlasWidth || w != TextTexture.gTextRender.atlasWidth)
                        return new TextTexture(w, h);
                    if (TextTexture.poolLen > 0) {
                        var ret = TextTexture.pool[--TextTexture.poolLen];
                        if (TextTexture.poolLen > 0)
                            TextTexture.clean();
                        return ret;
                    }
                    return new TextTexture(w, h);
                }
            }, {
                key: "clean",
                value: function clean() {
                    var curtm = RenderInfo.loopStTm;
                    if (TextTexture.cleanTm === 0)
                        TextTexture.cleanTm = curtm;
                    if (curtm - TextTexture.cleanTm >= TextTexture.gTextRender.checkCleanTextureDt) {
                        for (var i = 0; i < TextTexture.poolLen; i++) {
                            var p = TextTexture.pool[i];
                            if (curtm - p._discardTm >= TextTexture.gTextRender.destroyUnusedTextureDt) {
                                p.destroy();
                                TextTexture.pool[i] = TextTexture.pool[TextTexture.poolLen - 1];
                                TextTexture.poolLen--;
                                i--;
                            }
                        }
                        TextTexture.cleanTm = curtm;
                    }
                }
            }]);
            return TextTexture;
        }(Resource);
    TextTexture.gTextRender = null;
    TextTexture.pool = new Array(10);
    TextTexture.poolLen = 0;
    TextTexture.cleanTm = 0;
    var TextAtlas = /*#__PURE__*/
        function () {
            function TextAtlas() {
                _classCallCheck(this, TextAtlas);
                this.texWidth = 1024;
                this.texHeight = 1024;
                this.texture = null;
                this.charMaps = {};
                this.texHeight = this.texWidth = ILaya.TextRender.atlasWidth;
                this.texture = TextTexture.getTextTexture(this.texWidth, this.texHeight);
                if (this.texWidth / TextAtlas.atlasGridW > 256) {
                    TextAtlas.atlasGridW = Math.ceil(this.texWidth / 256);
                }
                this.atlasgrid = new AtlasGrid(this.texWidth / TextAtlas.atlasGridW, this.texHeight / TextAtlas.atlasGridW, this.texture.id);
            }
            _createClass(TextAtlas, [{
                key: "setProtecteDist",
                value: function setProtecteDist(d) { }
            }, {
                key: "getAEmpty",
                value: function getAEmpty(w, h, pt) {
                    var find = this.atlasgrid.addRect(1, Math.ceil(w / TextAtlas.atlasGridW), Math.ceil(h / TextAtlas.atlasGridW), pt);
                    if (find) {
                        pt.x *= TextAtlas.atlasGridW;
                        pt.y *= TextAtlas.atlasGridW;
                    }
                    return find;
                }
            }, {
                key: "usedRate",
                get: function get() {
                    return this.atlasgrid._used;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    for (var k in this.charMaps) {
                        var ri = this.charMaps[k];
                        ri.deleted = true;
                    }
                    this.texture.discard();
                }
            }, {
                key: "printDebugInfo",
                value: function printDebugInfo() { }
            }]);
            return TextAtlas;
        }();
    TextAtlas.atlasGridW = 16;
    var Event = /*#__PURE__*/
        function () {
            function Event() {
                _classCallCheck(this, Event);
            }
            _createClass(Event, [{
                key: "setTo",
                value: function setTo(type, currentTarget, target) {
                    this.type = type;
                    this.currentTarget = currentTarget;
                    this.target = target;
                    return this;
                }
            }, {
                key: "stopPropagation",
                value: function stopPropagation() {
                    this._stoped = true;
                }
            }, {
                key: "touches",
                get: function get() {
                    if (!this.nativeEvent)
                        return null;
                    var arr = this.nativeEvent.touches;
                    if (arr) {
                        var stage = ILaya.stage;
                        for (var i = 0, n = arr.length; i < n; i++) {
                            var e = arr[i];
                            var point = Point.TEMP;
                            point.setTo(e.clientX, e.clientY);
                            stage._canvasTransform.invertTransformPoint(point);
                            stage.transform.invertTransformPoint(point);
                            e.stageX = point.x;
                            e.stageY = point.y;
                        }
                    }
                    return arr;
                }
            }, {
                key: "altKey",
                get: function get() {
                    return this.nativeEvent.altKey;
                }
            }, {
                key: "ctrlKey",
                get: function get() {
                    return this.nativeEvent.ctrlKey;
                }
            }, {
                key: "shiftKey",
                get: function get() {
                    return this.nativeEvent.shiftKey;
                }
            }, {
                key: "charCode",
                get: function get() {
                    return this.nativeEvent.charCode;
                }
            }, {
                key: "keyLocation",
                get: function get() {
                    return this.nativeEvent.location || this.nativeEvent.keyLocation;
                }
            }, {
                key: "stageX",
                get: function get() {
                    return ILaya.stage.mouseX;
                }
            }, {
                key: "stageY",
                get: function get() {
                    return ILaya.stage.mouseY;
                }
            }]);
            return Event;
        }();
    Event.EMPTY = new Event();
    Event.MOUSE_DOWN = "mousedown";
    Event.MOUSE_UP = "mouseup";
    Event.CLICK = "click";
    Event.RIGHT_MOUSE_DOWN = "rightmousedown";
    Event.RIGHT_MOUSE_UP = "rightmouseup";
    Event.RIGHT_CLICK = "rightclick";
    Event.MOUSE_MOVE = "mousemove";
    Event.MOUSE_OVER = "mouseover";
    Event.MOUSE_OUT = "mouseout";
    Event.MOUSE_WHEEL = "mousewheel";
    Event.ROLL_OVER = "mouseover";
    Event.ROLL_OUT = "mouseout";
    Event.DOUBLE_CLICK = "doubleclick";
    Event.CHANGE = "change";
    Event.CHANGED = "changed";
    Event.RESIZE = "resize";
    Event.ADDED = "added";
    Event.REMOVED = "removed";
    Event.DISPLAY = "display";
    Event.UNDISPLAY = "undisplay";
    Event.ERROR = "error";
    Event.COMPLETE = "complete";
    Event.LOADED = "loaded";
    Event.READY = "ready";
    Event.PROGRESS = "progress";
    Event.INPUT = "input";
    Event.RENDER = "render";
    Event.OPEN = "open";
    Event.MESSAGE = "message";
    Event.CLOSE = "close";
    Event.KEY_DOWN = "keydown";
    Event.KEY_PRESS = "keypress";
    Event.KEY_UP = "keyup";
    Event.FRAME = "enterframe";
    Event.DRAG_START = "dragstart";
    Event.DRAG_MOVE = "dragmove";
    Event.DRAG_END = "dragend";
    Event.ENTER = "enter";
    Event.SELECT = "select";
    Event.BLUR = "blur";
    Event.FOCUS = "focus";
    Event.VISIBILITY_CHANGE = "visibilitychange";
    Event.FOCUS_CHANGE = "focuschange";
    Event.PLAYED = "played";
    Event.PAUSED = "paused";
    Event.STOPPED = "stopped";
    Event.START = "start";
    Event.END = "end";
    Event.COMPONENT_ADDED = "componentadded";
    Event.COMPONENT_REMOVED = "componentremoved";
    Event.RELEASED = "released";
    Event.LINK = "link";
    Event.LABEL = "label";
    Event.FULL_SCREEN_CHANGE = "fullscreenchange";
    Event.DEVICE_LOST = "devicelost";
    Event.TRANSFORM_CHANGED = "transformchanged";
    Event.ANIMATION_CHANGED = "animationchanged";
    Event.TRAIL_FILTER_CHANGE = "trailfilterchange";
    Event.TRIGGER_ENTER = "triggerenter";
    Event.TRIGGER_STAY = "triggerstay";
    Event.TRIGGER_EXIT = "triggerexit";
    var Texture = /*#__PURE__*/
        function (_EventDispatcher2) {
            _inherits(Texture, _EventDispatcher2);
            var _super23 = _createSuper(Texture);
            function Texture() {
                var _this18;
                var bitmap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                var uv = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                var sourceWidth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                var sourceHeight = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                _classCallCheck(this, Texture);
                _this18 = _super23.call(this);
                _this18.uvrect = [0, 0, 1, 1];
                _this18._destroyed = false;
                _this18._referenceCount = 0;
                _this18.$_GID = 0;
                _this18.offsetX = 0;
                _this18.offsetY = 0;
                _this18._w = 0;
                _this18._h = 0;
                _this18.sourceWidth = 0;
                _this18.sourceHeight = 0;
                _this18.url = null;
                _this18.scaleRate = 1;
                _this18.setTo(bitmap, uv, sourceWidth, sourceHeight);
                return _this18;
            }
            _createClass(Texture, [{
                key: "uv",
                get: function get() {
                    return this._uv;
                },
                set: function set(value) {
                    this.uvrect[0] = Math.min(value[0], value[2], value[4], value[6]);
                    this.uvrect[1] = Math.min(value[1], value[3], value[5], value[7]);
                    this.uvrect[2] = Math.max(value[0], value[2], value[4], value[6]) - this.uvrect[0];
                    this.uvrect[3] = Math.max(value[1], value[3], value[5], value[7]) - this.uvrect[1];
                    this._uv = value;
                }
            }, {
                key: "width",
                get: function get() {
                    if (this._w)
                        return this._w;
                    if (!this.bitmap)
                        return 0;
                    return this.uv && this.uv !== Texture.DEF_UV ? (this.uv[2] - this.uv[0]) * this.bitmap.width : this.bitmap.width;
                },
                set: function set(value) {
                    this._w = value;
                    this.sourceWidth || (this.sourceWidth = value);
                }
            }, {
                key: "height",
                get: function get() {
                    if (this._h)
                        return this._h;
                    if (!this.bitmap)
                        return 0;
                    return this.uv && this.uv !== Texture.DEF_UV ? (this.uv[5] - this.uv[1]) * this.bitmap.height : this.bitmap.height;
                },
                set: function set(value) {
                    this._h = value;
                    this.sourceHeight || (this.sourceHeight = value);
                }
            }, {
                key: "bitmap",
                get: function get() {
                    return this._bitmap;
                },
                set: function set(value) {
                    this._bitmap && this._bitmap._removeReference(this._referenceCount);
                    this._bitmap = value;
                    value && value._addReference(this._referenceCount);
                }
            }, {
                key: "destroyed",
                get: function get() {
                    return this._destroyed;
                }
            }, {
                key: "_addReference",
                value: function _addReference() {
                    this._bitmap && this._bitmap._addReference();
                    this._referenceCount++;
                }
            }, {
                key: "_removeReference",
                value: function _removeReference() {
                    this._bitmap && this._bitmap._removeReference();
                    this._referenceCount--;
                }
            }, {
                key: "_getSource",
                value: function _getSource() {
                    var cb = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    if (this._destroyed || !this._bitmap)
                        return null;
                    this.recoverBitmap(cb);
                    return this._bitmap.destroyed ? null : this.bitmap._getSource();
                }
            }, {
                key: "_onLoaded",
                value: function _onLoaded(complete, context) {
                    if (!context)
                        ;
                    else if (context == this)
                        ;
                    else if (context instanceof Texture) {
                        var tex = context;
                        Texture._create(context, 0, 0, tex.width, tex.height, 0, 0, tex.sourceWidth, tex.sourceHeight, this);
                    } else {
                        this.bitmap = context;
                        this.sourceWidth = this._w = context.width;
                        this.sourceHeight = this._h = context.height;
                    }
                    complete && complete.run();
                    this.event(Event.READY, this);
                }
            }, {
                key: "getIsReady",
                value: function getIsReady() {
                    return this._destroyed ? false : this._bitmap ? true : false;
                }
            }, {
                key: "setTo",
                value: function setTo() {
                    var bitmap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    var uv = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var sourceWidth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var sourceHeight = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    this.bitmap = bitmap;
                    this.sourceWidth = sourceWidth;
                    this.sourceHeight = sourceHeight;
                    if (bitmap) {
                        this._w = bitmap.width;
                        this._h = bitmap.height;
                        this.sourceWidth = this.sourceWidth || bitmap.width;
                        this.sourceHeight = this.sourceHeight || bitmap.height;
                    }
                    this.uv = uv || Texture.DEF_UV;
                }
            }, {
                key: "load",
                value: function load(url) {
                    var complete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (!this._destroyed)
                        ILaya.loader.load(url, Handler.create(this, this._onLoaded, [complete]), null, "htmlimage", 1, true);
                }
            }, {
                key: "getTexturePixels",
                value: function getTexturePixels(x, y, width, height) {
                    var st, dst, i;
                    var tex2d = this.bitmap;
                    var texw = this._w;
                    var texh = this._h;
                    var sourceWidth = this.sourceWidth;
                    var sourceHeight = this.sourceHeight;
                    var tex2dw = tex2d.width;
                    var tex2dh = tex2d.height;
                    var offsetX = this.offsetX;
                    var offsetY = this.offsetY;
                    var draww = width;
                    var drawh = height;
                    if (x + width > texw + offsetX)
                        draww -= x + width - texw - offsetX;
                    if (x + width > sourceWidth)
                        width -= x + width - sourceWidth;
                    if (y + height > texh + offsetY)
                        drawh -= y + height - texh - offsetY;
                    if (y + height > sourceHeight)
                        height -= y + height - sourceHeight;
                    if (width <= 0 || height <= 0)
                        return null;
                    var marginL = offsetX > x ? offsetX - x : 0;
                    var marginT = offsetY > y ? offsetY - y : 0;
                    var rePosX = x > offsetX ? x - offsetX : 0;
                    var rePosY = y > offsetY ? y - offsetY : 0;
                    draww -= marginL;
                    drawh -= marginT;
                    var wstride = width * 4;
                    var pix = null;
                    try {
                        pix = tex2d.getPixels();
                    } catch (e) { }
                    if (pix) {
                        if (x == 0 && y == 0 && width == tex2dw && height == tex2dh)
                            return pix;
                        var _uv = this._uv.slice();
                        var atlasPosX = Math.round(_uv[0] * tex2dw);
                        var atlasPosY = Math.round(_uv[1] * tex2dh);
                        var ret = new Uint8Array(width * height * 4);
                        wstride = tex2dw * 4;
                        dst = (atlasPosY + rePosY) * wstride;
                        st = atlasPosX * 4 + rePosX * 4 + dst;
                        for (i = 0; i < drawh; i++) {
                            ret.set(pix.slice(st, st + draww * 4), width * 4 * (i + marginT) + marginL * 4);
                            st += wstride;
                        }
                        return ret;
                    }
                    var ctx = new ILaya.Context();
                    ctx.size(width, height);
                    ctx.asBitmap = true;
                    var uv = null;
                    if (x != 0 || y != 0 || width != tex2dw || height != tex2dh) {
                        uv = this._uv.slice();
                        var stu = uv[0];
                        var stv = uv[1];
                        var uvw = uv[2] - stu;
                        var uvh = uv[7] - stv;
                        var uk = uvw / texw;
                        var vk = uvh / texh;
                        uv = [stu + rePosX * uk, stv + rePosY * vk, stu + (rePosX + draww) * uk, stv + rePosY * vk, stu + (rePosX + draww) * uk, stv + (rePosY + drawh) * vk, stu + rePosX * uk, stv + (rePosY + drawh) * vk];
                    }
                    ctx._drawTextureM(this, marginL, marginT, draww, drawh, null, 1.0, uv);
                    ctx._targets.start();
                    ctx.flush();
                    ctx._targets.end();
                    ctx._targets.restore();
                    var dt = ctx._targets.getData(0, 0, width, height);
                    ctx.destroy();
                    ret = new Uint8Array(width * height * 4);
                    st = 0;
                    dst = (height - 1) * wstride;
                    for (i = height - 1; i >= 0; i--) {
                        ret.set(dt.slice(dst, dst + wstride), st);
                        st += wstride;
                        dst -= wstride;
                    }
                    return ret;
                }
            }, {
                key: "getPixels",
                value: function getPixels(x, y, width, height) {
                    if (window.conch) {
                        return this._nativeObj.getImageData(x, y, width, height);
                    } else {
                        return this.getTexturePixels(x, y, width, height);
                    }
                }
            }, {
                key: "recoverBitmap",
                value: function recoverBitmap() {
                    var onok = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    var url = this._bitmap.url;
                    if (!this._destroyed && (!this._bitmap || this._bitmap.destroyed) && url) {
                        ILaya.loader.load(url, Handler.create(this, function (bit) {
                            this.bitmap = bit;
                            onok && onok();
                        }), null, "htmlimage", 1, true);
                    }
                }
            }, {
                key: "disposeBitmap",
                value: function disposeBitmap() {
                    if (!this._destroyed && this._bitmap) {
                        this._bitmap.destroy();
                    }
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (!this._destroyed) {
                        this._destroyed = true;
                        var bit = this._bitmap;
                        if (bit) {
                            bit._removeReference(this._referenceCount);
                            if (bit.referenceCount === 0 || force)
                                bit.destroy();
                            bit = null;
                        }
                        if (this.url && this === ILaya.loader.getRes(this.url))
                            ILaya.Loader.clearRes(this.url);
                    }
                }
            }], [{
                key: "moveUV",
                value: function moveUV(offsetX, offsetY, uv) {
                    for (var i = 0; i < 8; i += 2) {
                        uv[i] += offsetX;
                        uv[i + 1] += offsetY;
                    }
                    return uv;
                }
            }, {
                key: "create",
                value: function create(source, x, y, width, height) {
                    var offsetX = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                    var offsetY = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
                    var sourceWidth = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
                    var sourceHeight = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
                    return Texture._create(source, x, y, width, height, offsetX, offsetY, sourceWidth, sourceHeight);
                }
            }, {
                key: "_create",
                value: function _create(source, x, y, width, height) {
                    var offsetX = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;
                    var offsetY = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
                    var sourceWidth = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
                    var sourceHeight = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
                    var outTexture = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : null;
                    var btex = source instanceof Texture;
                    var uv = btex ? source.uv : Texture.DEF_UV;
                    var bitmap = btex ? source.bitmap : source;
                    if (bitmap.width && x + width > bitmap.width)
                        width = bitmap.width - x;
                    if (bitmap.height && y + height > bitmap.height)
                        height = bitmap.height - y;
                    var tex;
                    if (outTexture) {
                        tex = outTexture;
                        tex.setTo(bitmap, null, sourceWidth || width, sourceHeight || height);
                    } else {
                        tex = new Texture(bitmap, null, sourceWidth || width, sourceHeight || height);
                    }
                    tex.width = width;
                    tex.height = height;
                    tex.offsetX = offsetX;
                    tex.offsetY = offsetY;
                    var dwidth = 1 / bitmap.width;
                    var dheight = 1 / bitmap.height;
                    x *= dwidth;
                    y *= dheight;
                    width *= dwidth;
                    height *= dheight;
                    var u1 = tex.uv[0]
                        , v1 = tex.uv[1]
                        , u2 = tex.uv[4]
                        , v2 = tex.uv[5];
                    var inAltasUVWidth = u2 - u1
                        , inAltasUVHeight = v2 - v1;
                    var oriUV = Texture.moveUV(uv[0], uv[1], [x, y, x + width, y, x + width, y + height, x, y + height]);
                    tex.uv = new Float32Array([u1 + oriUV[0] * inAltasUVWidth, v1 + oriUV[1] * inAltasUVHeight, u2 - (1 - oriUV[2]) * inAltasUVWidth, v1 + oriUV[3] * inAltasUVHeight, u2 - (1 - oriUV[4]) * inAltasUVWidth, v2 - (1 - oriUV[5]) * inAltasUVHeight, u1 + oriUV[6] * inAltasUVWidth, v2 - (1 - oriUV[7]) * inAltasUVHeight]);
                    var bitmapScale = bitmap.scaleRate;
                    if (bitmapScale && bitmapScale != 1) {
                        tex.sourceWidth /= bitmapScale;
                        tex.sourceHeight /= bitmapScale;
                        tex.width /= bitmapScale;
                        tex.height /= bitmapScale;
                        tex.scaleRate = bitmapScale;
                    } else {
                        tex.scaleRate = 1;
                    }
                    return tex;
                }
            }, {
                key: "createFromTexture",
                value: function createFromTexture(texture, x, y, width, height) {
                    var texScaleRate = texture.scaleRate;
                    if (texScaleRate != 1) {
                        x *= texScaleRate;
                        y *= texScaleRate;
                        width *= texScaleRate;
                        height *= texScaleRate;
                    }
                    var rect = Rectangle.TEMP.setTo(x - texture.offsetX, y - texture.offsetY, width, height);
                    var result = rect.intersection(Texture._rect1.setTo(0, 0, texture.width, texture.height), Texture._rect2);
                    if (result)
                        var tex = Texture.create(texture, result.x, result.y, result.width, result.height, result.x - rect.x, result.y - rect.y, width, height);
                    else
                        return null;
                    return tex;
                }
            }]);
            return Texture;
        }(EventDispatcher);
    Texture.DEF_UV = new Float32Array([0, 0, 1.0, 0, 1.0, 1.0, 0, 1.0]);
    Texture.NO_UV = new Float32Array([0, 0, 0, 0, 0, 0, 0, 0]);
    Texture.INV_UV = new Float32Array([0, 1, 1.0, 1, 1.0, 0.0, 0, 0.0]);
    Texture._rect1 = new Rectangle();
    Texture._rect2 = new Rectangle();
    var FontInfo = /*#__PURE__*/
        function () {
            function FontInfo(font) {
                _classCallCheck(this, FontInfo);
                this._font = "14px Arial";
                this._family = "Arial";
                this._size = 14;
                this._italic = false;
                this._bold = false;
                this._id = FontInfo._gfontID++;
                this.setFont(font || this._font);
            }
            _createClass(FontInfo, [{
                key: "setFont",
                value: function setFont(value) {
                    this._font = value;
                    var _words = value.split(' ');
                    var l = _words.length;
                    if (l < 2) {
                        if (l == 1) {
                            if (_words[0].indexOf('px') > 0) {
                                this._size = parseInt(_words[0]);
                            }
                        }
                        return;
                    }
                    var szpos = -1;
                    for (var i = 0; i < l; i++) {
                        if (_words[i].indexOf('px') > 0 || _words[i].indexOf('pt') > 0) {
                            szpos = i;
                            this._size = parseInt(_words[i]);
                            if (this._size <= 0) {
                                console.error('font parse error:' + value);
                                this._size = 14;
                            }
                            break;
                        }
                    }
                    var fpos = szpos + 1;
                    var familys = _words[fpos];
                    fpos++;
                    for (; fpos < l; fpos++) {
                        familys += ' ' + _words[fpos];
                    }
                    this._family = familys.split(',')[0];
                    this._italic = _words.indexOf('italic') >= 0;
                    this._bold = _words.indexOf('bold') >= 0;
                }
            }], [{
                key: "Parse",
                value: function Parse(font) {
                    if (font === FontInfo._lastFont) {
                        return FontInfo._lastFontInfo;
                    }
                    var r = FontInfo._cache[font];
                    if (!r) {
                        r = FontInfo._cache[font] = new FontInfo(font);
                    }
                    FontInfo._lastFont = font;
                    FontInfo._lastFontInfo = r;
                    return r;
                }
            }]);
            return FontInfo;
        }();
    FontInfo.EMPTY = new FontInfo(null);
    FontInfo._cache = {};
    FontInfo._gfontID = 0;
    FontInfo._lastFont = '';
    var WordText = /*#__PURE__*/
        function () {
            function WordText() {
                _classCallCheck(this, WordText);
                this.save = [];
                this.toUpperCase = null;
                this.width = -1;
                this.pageChars = [];
                this.startID = 0;
                this.startIDStroke = 0;
                this.lastGCCnt = 0;
                this.splitRender = false;
                this.scalex = 1;
                this.scaley = 1;
            }
            _createClass(WordText, [{
                key: "setText",
                value: function setText(txt) {
                    this.changed = true;
                    this._text = txt;
                    this.width = -1;
                    this.cleanCache();
                }
            }, {
                key: "toString",
                value: function toString() {
                    return this._text;
                }
            }, {
                key: "length",
                get: function get() {
                    return this._text ? this._text.length : 0;
                }
            }, {
                key: "charCodeAt",
                value: function charCodeAt(i) {
                    return this._text ? this._text.charCodeAt(i) : NaN;
                }
            }, {
                key: "charAt",
                value: function charAt(i) {
                    return this._text ? this._text.charAt(i) : null;
                }
            }, {
                key: "cleanCache",
                value: function cleanCache() {
                    this.pageChars.forEach(function (p) {
                        var tex = p.tex;
                        var words = p.words;
                        if (p.words.length == 1 && tex && tex.ri) {
                            tex.destroy();
                        }
                    });
                    this.pageChars = [];
                    this.startID = 0;
                    this.scalex = 1;
                    this.scaley = 1;
                }
            }]);
            return WordText;
        }();
    var CharRenderInfo = /*#__PURE__*/
        function () {
            function CharRenderInfo() {
                _classCallCheck(this, CharRenderInfo);
                this["char"] = '';
                this.deleted = false;
                this.uv = new Array(8);
                this.pos = 0;
                this.orix = 0;
                this.oriy = 0;
                this.touchTick = 0;
                this.isSpace = false;
            }
            _createClass(CharRenderInfo, [{
                key: "touch",
                value: function touch() {
                    var curLoop = RenderInfo.loopCount;
                    if (this.touchTick != curLoop) {
                        this.tex.touchRect(this, curLoop);
                    }
                    this.touchTick = curLoop;
                }
            }]);
            return CharRenderInfo;
        }();
    var ICharRender = /*#__PURE__*/
        function () {
            function ICharRender() {
                _classCallCheck(this, ICharRender);
                this.fontsz = 16;
            }
            _createClass(ICharRender, [{
                key: "getWidth",
                value: function getWidth(font, str) {
                    return 0;
                }
            }, {
                key: "scale",
                value: function scale(sx, sy) { }
            }, {
                key: "canvasWidth",
                get: function get() {
                    return 0;
                },
                set: function set(w) { }
            }, {
                key: "getCharBmp",
                value: function getCharBmp(_char, font, lineWidth, colStr, strokeColStr, size, margin_left, margin_top, margin_right, margin_bottom) {
                    var rect = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : null;
                    return null;
                }
            }]);
            return ICharRender;
        }();
    var Browser = /*#__PURE__*/
        function () {
            function Browser() {
                _classCallCheck(this, Browser);
            }
            _createClass(Browser, null, [{
                key: "__init__",
                value: function __init__() {
                    var Laya = window.Laya || ILaya.Laya;
                    if (Browser._window)
                        return Browser._window;
                    var win = Browser._window = window;
                    var doc = Browser._document = win.document;
                    var u = Browser.userAgent = win.navigator.userAgent;
                    var maxTouchPoints = win.navigator.maxTouchPoints || 0;
                    var platform = win.navigator.platform;
                    if (u.indexOf('AlipayMiniGame') > -1 && "my" in Browser.window) {
                        window.aliPayMiniGame(Laya, Laya);
                        if (!Laya["ALIMiniAdapter"]) {
                            console.error("请先添加阿里小游戏适配库");
                        } else {
                            Laya["ALIMiniAdapter"].enable();
                        }
                    }
                    if (u.indexOf('OPPO') == -1 && u.indexOf("MiniGame") > -1 && "wx" in Browser.window) {
                        if ("bl" in Browser.window) {
                            window.biliMiniGame(Laya, Laya);
                            if (!Laya["BLMiniAdapter"]) {
                                console.error("请引入bilibili小游戏的适配库：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0");
                            } else {
                                Laya["BLMiniAdapter"].enable();
                            }
                        } else if ("qq" in Browser.window) {
                            window.qqMiniGame(Laya, Laya);
                            if (!Laya["QQMiniAdapter"]) {
                                console.error("请引入手机QQ小游戏的适配库：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0");
                            } else {
                                Laya["QQMiniAdapter"].enable();
                            }
                        } else {
                            window.wxMiniGame(Laya, Laya);
                            if (!Laya["MiniAdpter"]) {
                                console.error("请先添加小游戏适配库,详细教程：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0");
                            } else {
                                Laya["MiniAdpter"].enable();
                            }
                        }
                    }
                    if (u.indexOf("MiniGame") > -1 && "qq" in Browser.window) {
                        window.qqMiniGame(Laya, Laya);
                        if (!Laya["QQMiniAdapter"]) {
                            console.error("请先添加小游戏适配库,详细教程");
                        } else {
                            Laya["QQMiniAdapter"].enable();
                        }
                    }
                    if (u.indexOf("SwanGame") > -1) {
                        window.bdMiniGame(Laya, Laya);
                        if (!Laya["BMiniAdapter"]) {
                            console.error("请先添加百度小游戏适配库,详细教程：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0");
                        } else {
                            Laya["BMiniAdapter"].enable();
                        }
                    }
                    if (u.indexOf('QuickGame') > -1) {
                        window.miMiniGame(Laya, Laya);
                        if (!Laya["KGMiniAdapter"]) {
                            console.error("请先添加小米小游戏适配库,详细教程：https://ldc2.layabox.com/doc/?nav=zh-ts-5-0-0");
                        } else {
                            Laya["KGMiniAdapter"].enable();
                        }
                    }
                    if (u.indexOf('OPPO') > -1 && u.indexOf('MiniGame') > -1) {
                        window.qgMiniGame(Laya, Laya);
                        if (!Laya["QGMiniAdapter"]) {
                            console.error("请先添加OPPO小游戏适配库");
                        } else {
                            Laya["QGMiniAdapter"].enable();
                        }
                    }
                    if (u.indexOf('VVGame') > -1) {
                        window.vvMiniGame(Laya, Laya);
                        if (!Laya["VVMiniAdapter"]) {
                            console.error("请先添加VIVO小游戏适配库");
                        } else {
                            Laya["VVMiniAdapter"].enable();
                        }
                    }
                    win.trace = console.log;
                    win.requestAnimationFrame = win.requestAnimationFrame || win.webkitRequestAnimationFrame || win.mozRequestAnimationFrame || win.oRequestAnimationFrame || win.msRequestAnimationFrame || function (fun) {
                        return win.setTimeout(fun, 1000 / 60);
                    }
                        ;
                    var bodyStyle = doc.body.style;
                    bodyStyle.margin = 0;
                    bodyStyle.overflow = 'hidden';
                    bodyStyle['-webkit-user-select'] = 'none';
                    bodyStyle['-webkit-tap-highlight-color'] = 'rgba(200,200,200,0)';
                    var metas = doc.getElementsByTagName('meta');
                    var i = 0
                        , flag = false
                        , content = 'width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no';
                    while (i < metas.length) {
                        var meta = metas[i];
                        if (meta.name == 'viewport') {
                            meta.content = content;
                            flag = true;
                            break;
                        }
                        i++;
                    }
                    if (!flag) {
                        meta = doc.createElement('meta');
                        meta.name = 'viewport',
                            meta.content = content;
                        doc.getElementsByTagName('head')[0].appendChild(meta);
                    }
                    Browser.onMobile = window.isConchApp ? true : u.indexOf("Mobile") > -1;
                    Browser.onIOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
                    Browser.onIPhone = u.indexOf("iPhone") > -1;
                    Browser.onMac = u.indexOf("Mac OS X") > -1;
                    Browser.onIPad = u.indexOf("iPad") > -1 || platform === 'MacIntel' && maxTouchPoints > 1;
                    Browser.onAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1;
                    Browser.onWP = u.indexOf("Windows Phone") > -1;
                    Browser.onQQBrowser = u.indexOf("QQBrowser") > -1;
                    Browser.onMQQBrowser = u.indexOf("MQQBrowser") > -1 || u.indexOf("Mobile") > -1 && u.indexOf("QQ") > -1;
                    Browser.onIE = !!win.ActiveXObject || "ActiveXObject" in win;
                    Browser.onWeiXin = u.indexOf('MicroMessenger') > -1;
                    Browser.onSafari = u.indexOf("Safari") > -1;
                    Browser.onPC = !Browser.onMobile;
                    Browser.onMiniGame = u.indexOf('MiniGame') > -1;
                    Browser.onBDMiniGame = u.indexOf('SwanGame') > -1;
                    Browser.onLayaRuntime = !!Browser.window.conch;
                    if (u.indexOf('OPPO') > -1 && u.indexOf('MiniGame') > -1) {
                        Browser.onQGMiniGame = true;
                        Browser.onMiniGame = false;
                    } else if ("qq" in Browser.window && u.indexOf('MiniGame') > -1) {
                        Browser.onQQMiniGame = true;
                        Browser.onMiniGame = false;
                    } else if ("bl" in Browser.window && u.indexOf('MiniGame') > -1) {
                        Browser.onBLMiniGame = true;
                        Browser.onMiniGame = true;
                    }
                    Browser.onVVMiniGame = u.indexOf('VVGame') > -1;
                    Browser.onKGMiniGame = u.indexOf('QuickGame') > -1;
                    if (u.indexOf('AlipayMiniGame') > -1) {
                        Browser.onAlipayMiniGame = true;
                        Browser.onMiniGame = false;
                    }
                    return win;
                }
            }, {
                key: "createElement",
                value: function createElement(type) {
                    Browser.__init__();
                    return Browser._document.createElement(type);
                }
            }, {
                key: "getElementById",
                value: function getElementById(type) {
                    Browser.__init__();
                    return Browser._document.getElementById(type);
                }
            }, {
                key: "removeElement",
                value: function removeElement(ele) {
                    if (ele && ele.parentNode)
                        ele.parentNode.removeChild(ele);
                }
            }, {
                key: "now",
                value: function now() {
                    return Date.now();
                }
            }, {
                key: "clientWidth",
                get: function get() {
                    Browser.__init__();
                    return Browser._window.innerWidth || Browser._document.body.clientWidth;
                }
            }, {
                key: "clientHeight",
                get: function get() {
                    Browser.__init__();
                    return Browser._window.innerHeight || Browser._document.body.clientHeight || Browser._document.documentElement.clientHeight;
                }
            }, {
                key: "width",
                get: function get() {
                    Browser.__init__();
                    return (ILaya.stage && ILaya.stage.canvasRotation ? Browser.clientHeight : Browser.clientWidth) * Browser.pixelRatio;
                }
            }, {
                key: "height",
                get: function get() {
                    Browser.__init__();
                    return (ILaya.stage && ILaya.stage.canvasRotation ? Browser.clientWidth : Browser.clientHeight) * Browser.pixelRatio;
                }
            }, {
                key: "pixelRatio",
                get: function get() {
                    if (Browser._pixelRatio < 0) {
                        Browser.__init__();
                        if (Browser.userAgent.indexOf("Mozilla/6.0(Linux; Android 6.0; HUAWEI NXT-AL10 Build/HUAWEINXT-AL10)") > -1)
                            Browser._pixelRatio = 2;
                        else {
                            Browser._pixelRatio = Browser._window.devicePixelRatio || 1;
                            if (Browser._pixelRatio < 1)
                                Browser._pixelRatio = 1;
                        }
                    }
                    return Browser._pixelRatio;
                }
            }, {
                key: "container",
                get: function get() {
                    if (!Browser._container) {
                        Browser.__init__();
                        Browser._container = Browser.createElement("div");
                        Browser._container.id = "layaContainer";
                        Browser._document.body.appendChild(Browser._container);
                    }
                    return Browser._container;
                },
                set: function set(value) {
                    Browser._container = value;
                }
            }, {
                key: "window",
                get: function get() {
                    return Browser._window || Browser.__init__();
                }
            }, {
                key: "document",
                get: function get() {
                    Browser.__init__();
                    return Browser._document;
                }
            }]);
            return Browser;
        }();
    Browser._pixelRatio = -1;
    Browser.mainCanvas = null;
    Browser.hanzi = new RegExp("^[\u4E00-\u9FA5]$");
    Browser.fontMap = [];
    Browser.measureText = function (txt, font) {
        var isChinese = Browser.hanzi.test(txt);
        if (isChinese && Browser.fontMap[font]) {
            return Browser.fontMap[font];
        }
        var ctx = Browser.context;
        ctx.font = font;
        var r = ctx.measureText(txt);
        if (isChinese)
            Browser.fontMap[font] = r;
        return r;
    }
        ;
    var CharRender_Canvas = /*#__PURE__*/
        function (_ICharRender) {
            _inherits(CharRender_Canvas, _ICharRender);
            var _super24 = _createSuper(CharRender_Canvas);
            function CharRender_Canvas(maxw, maxh) {
                var _this19;
                var scalefont = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
                var useImageData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
                var showdbg = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
                _classCallCheck(this, CharRender_Canvas);
                _this19 = _super24.call(this);
                _this19.ctx = null;
                _this19.lastScaleX = 1.0;
                _this19.lastScaleY = 1.0;
                _this19.maxTexW = 0;
                _this19.maxTexH = 0;
                _this19.scaleFontSize = true;
                _this19.showDbgInfo = false;
                _this19.supportImageData = true;
                _this19.maxTexW = maxw;
                _this19.maxTexH = maxh;
                _this19.scaleFontSize = scalefont;
                _this19.supportImageData = useImageData;
                _this19.showDbgInfo = showdbg;
                if (!CharRender_Canvas.canvas) {
                    CharRender_Canvas.canvas = Browser.createElement('canvas');
                    CharRender_Canvas.canvas.width = 1024;
                    CharRender_Canvas.canvas.height = 512;
                    CharRender_Canvas.canvas.style.left = "-10000px";
                    CharRender_Canvas.canvas.style.position = "absolute";
                    document.body.appendChild(CharRender_Canvas.canvas);
                    _this19.ctx = CharRender_Canvas.canvas.getContext('2d');
                }
                return _this19;
            }
            _createClass(CharRender_Canvas, [{
                key: "canvasWidth",
                get: function get() {
                    return CharRender_Canvas.canvas.width;
                },
                set: function set(w) {
                    if (CharRender_Canvas.canvas.width == w)
                        return;
                    CharRender_Canvas.canvas.width = w;
                    if (w > 2048) {
                        console.warn("画文字设置的宽度太大，超过2048了");
                    }
                    this.ctx.setTransform(1, 0, 0, 1, 0, 0);
                    this.ctx.scale(this.lastScaleX, this.lastScaleY);
                }
            }, {
                key: "getWidth",
                value: function getWidth(font, str) {
                    if (!this.ctx)
                        return 0;
                    if (this.ctx._lastFont != font) {
                        this.ctx.font = font;
                        this.ctx._lastFont = font;
                    }
                    return this.ctx.measureText(str).width;
                }
            }, {
                key: "scale",
                value: function scale(sx, sy) {
                    if (!this.supportImageData) {
                        this.lastScaleX = sx;
                        this.lastScaleY = sy;
                        return;
                    }
                    if (this.lastScaleX != sx || this.lastScaleY != sy) {
                        this.ctx.setTransform(sx, 0, 0, sy, 0, 0);
                        this.lastScaleX = sx;
                        this.lastScaleY = sy;
                    }
                }
            }, {
                key: "getCharBmp",
                value: function getCharBmp(_char2, font, lineWidth, colStr, strokeColStr, cri, margin_left, margin_top, margin_right, margin_bottom) {
                    var rect = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : null;
                    if (!this.supportImageData)
                        return this.getCharCanvas(_char2, font, lineWidth, colStr, strokeColStr, cri, margin_left, margin_top, margin_right, margin_bottom);
                    var ctx = this.ctx;
                    var sz = this.fontsz;
                    if (ctx.font != font) {
                        ctx.font = font;
                        ctx._lastFont = font;
                    }
                    cri.width = ctx.measureText(_char2).width;
                    var w = cri.width * this.lastScaleX;
                    var h = cri.height * this.lastScaleY;
                    w += (margin_left + margin_right) * this.lastScaleX;
                    h += (margin_top + margin_bottom) * this.lastScaleY;
                    w = Math.ceil(w);
                    h = Math.ceil(h);
                    w = Math.min(w, CharRender_Canvas.canvas.width);
                    h = Math.min(h, CharRender_Canvas.canvas.height);
                    var clearW = w + lineWidth * 2 + 1;
                    var clearH = h + lineWidth * 2 + 1;
                    if (rect) {
                        clearW = Math.max(clearW, rect[0] + rect[2] + 1);
                        clearH = Math.max(clearH, rect[1] + rect[3] + 1);
                    }
                    ctx.clearRect(0, 0, clearW / this.lastScaleX + 1, clearH / this.lastScaleY + 1);
                    ctx.save();
                    ctx.textBaseline = "middle";
                    if (lineWidth > 0) {
                        ctx.strokeStyle = strokeColStr;
                        ctx.lineWidth = lineWidth;
                        ctx.strokeText(_char2, margin_left, margin_top + sz / 2);
                    }
                    if (colStr) {
                        ctx.fillStyle = colStr;
                        ctx.fillText(_char2, margin_left, margin_top + sz / 2);
                    }
                    if (this.showDbgInfo) {
                        ctx.strokeStyle = '#ff0000';
                        ctx.strokeRect(1, 1, w - 2, h - 2);
                        ctx.strokeStyle = '#00ff00';
                        ctx.strokeRect(margin_left, margin_top, cri.width, cri.height);
                    }
                    if (rect) {
                        if (rect[2] == -1)
                            rect[2] = Math.ceil((cri.width + lineWidth * 2) * this.lastScaleX);
                    }
                    var imgdt = rect ? ctx.getImageData(rect[0], rect[1], rect[2], rect[3] + 1) : ctx.getImageData(0, 0, w, h + 1);
                    ctx.restore();
                    cri.bmpWidth = imgdt.width;
                    cri.bmpHeight = imgdt.height;
                    return imgdt;
                }
            }, {
                key: "getCharCanvas",
                value: function getCharCanvas(_char3, font, lineWidth, colStr, strokeColStr, cri, margin_left, margin_top, margin_right, margin_bottom) {
                    var ctx = this.ctx;
                    if (ctx.font != font) {
                        ctx.font = font;
                        ctx._lastFont = font;
                    }
                    cri.width = ctx.measureText(_char3).width;
                    var w = cri.width * this.lastScaleX;
                    var h = cri.height * this.lastScaleY;
                    w += (margin_left + margin_right) * this.lastScaleX;
                    h += (margin_top + margin_bottom) * this.lastScaleY + 1;
                    w = Math.min(w, this.maxTexW);
                    h = Math.min(h, this.maxTexH);
                    CharRender_Canvas.canvas.width = Math.min(w + 1, this.maxTexW);
                    CharRender_Canvas.canvas.height = Math.min(h + 1, this.maxTexH);
                    ctx.font = font;
                    ctx.clearRect(0, 0, w + 1 + lineWidth, h + 1 + lineWidth);
                    ctx.setTransform(1, 0, 0, 1, 0, 0);
                    ctx.save();
                    if (this.scaleFontSize) {
                        ctx.scale(this.lastScaleX, this.lastScaleY);
                    }
                    ctx.translate(margin_left, margin_top);
                    ctx.textAlign = "left";
                    var sz = this.fontsz;
                    ctx.textBaseline = "middle";
                    if (lineWidth > 0) {
                        ctx.strokeStyle = strokeColStr;
                        ctx.fillStyle = colStr;
                        ctx.lineWidth = lineWidth;
                        if (ctx.fillAndStrokeText) {
                            ctx.fillAndStrokeText(_char3, 0, sz / 2);
                        } else {
                            ctx.strokeText(_char3, 0, sz / 2);
                            ctx.fillText(_char3, 0, sz / 2);
                        }
                    } else if (colStr) {
                        ctx.fillStyle = colStr;
                        ctx.fillText(_char3, 0, sz / 2);
                    }
                    if (this.showDbgInfo) {
                        ctx.strokeStyle = '#ff0000';
                        ctx.strokeRect(0, 0, w, h);
                        ctx.strokeStyle = '#00ff00';
                        ctx.strokeRect(0, 0, cri.width, cri.height);
                    }
                    ctx.restore();
                    cri.bmpWidth = CharRender_Canvas.canvas.width;
                    cri.bmpHeight = CharRender_Canvas.canvas.height;
                    return CharRender_Canvas.canvas;
                }
            }]);
            return CharRender_Canvas;
        }(ICharRender);
    CharRender_Canvas.canvas = null;
    var CharRender_Native = /*#__PURE__*/
        function (_ICharRender2) {
            _inherits(CharRender_Native, _ICharRender2);
            var _super25 = _createSuper(CharRender_Native);
            function CharRender_Native() {
                var _this20;
                _classCallCheck(this, CharRender_Native);
                _this20 = _super25.call(this);
                _this20.lastFont = '';
                _this20.lastScaleX = 1.0;
                _this20.lastScaleY = 1.0;
                return _this20;
            }
            _createClass(CharRender_Native, [{
                key: "getWidth",
                value: function getWidth(font, str) {
                    if (!window.conchTextCanvas)
                        return 0;
                    window.conchTextCanvas.font = font;
                    this.lastFont = font;
                    return window.conchTextCanvas.measureText(str).width;
                }
            }, {
                key: "scale",
                value: function scale(sx, sy) {
                    this.lastScaleX = sx;
                    this.lastScaleY = sy;
                }
            }, {
                key: "getCharBmp",
                value: function getCharBmp(_char4, font, lineWidth, colStr, strokeColStr, size, margin_left, margin_top, margin_right, margin_bottom) {
                    var rect = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : null;
                    if (!window.conchTextCanvas)
                        return null;
                    window.conchTextCanvas.font = font;
                    this.lastFont = font;
                    var w = size.width = window.conchTextCanvas.measureText(_char4).width;
                    var h = size.height;
                    w += margin_left + margin_right;
                    h += margin_top + margin_bottom;
                    window.conchTextCanvas.scale && window.conchTextCanvas.scale(this.lastScaleX, this.lastScaleY);
                    var c1 = ColorUtils.create(strokeColStr);
                    var nStrokeColor = c1.numColor;
                    var c2 = ColorUtils.create(colStr);
                    var nTextColor = c2.numColor;
                    var textInfo = window.conchTextCanvas.getTextBitmapData(_char4, nTextColor, lineWidth > 2 ? 2 : lineWidth, nStrokeColor);
                    size.bmpWidth = textInfo.width;
                    size.bmpHeight = textInfo.height;
                    return textInfo;
                }
            }]);
            return CharRender_Native;
        }(ICharRender);
    var TextRender = /*#__PURE__*/
        function () {
            function TextRender() {
                _classCallCheck(this, TextRender);
                this.fontSizeInfo = {};
                this.mapFont = {};
                this.fontID = 0;
                this.mapColor = [];
                this.colorID = 0;
                this.fontScaleX = 1.0;
                this.fontScaleY = 1.0;
                this._curStrPos = 0;
                this.textAtlases = [];
                this.isoTextures = [];
                this.lastFont = null;
                this.fontSizeW = 0;
                this.fontSizeH = 0;
                this.fontSizeOffX = 0;
                this.fontSizeOffY = 0;
                this.renderPerChar = true;
                this.tmpAtlasPos = new Point();
                this.textureMem = 0;
                ILaya.TextAtlas = TextAtlas;
                var bugIOS = false;
                var miniadp = ILaya.Laya['MiniAdpter'];
                if (miniadp && miniadp.systemInfo && miniadp.systemInfo.system) {
                    bugIOS = miniadp.systemInfo.system.toLowerCase() === 'ios 10.1.1';
                }
                if (ILaya.Browser.onMiniGame && !bugIOS)
                    TextRender.isWan1Wan = true;
                this.charRender = ILaya.Render.isConchApp ? new CharRender_Native() : new CharRender_Canvas(TextRender.atlasWidth, TextRender.atlasWidth, TextRender.scaleFontWithCtx, !TextRender.isWan1Wan, false);
                TextRender.textRenderInst = this;
                ILaya.Laya['textRender'] = this;
                TextRender.atlasWidth2 = TextRender.atlasWidth * TextRender.atlasWidth;
            }
            _createClass(TextRender, [{
                key: "setFont",
                value: function setFont(font) {
                    if (this.lastFont == font)
                        return;
                    this.lastFont = font;
                    var fontsz = this.getFontSizeInfo(font._family);
                    var offx = fontsz >> 24;
                    var offy = fontsz >> 16 & 0xff;
                    var fw = fontsz >> 8 & 0xff;
                    var fh = fontsz & 0xff;
                    var k = font._size / TextRender.standardFontSize;
                    this.fontSizeOffX = Math.ceil(offx * k);
                    this.fontSizeOffY = Math.ceil(offy * k);
                    this.fontSizeW = Math.ceil(fw * k);
                    this.fontSizeH = Math.ceil(fh * k);
                    if (font._font.indexOf('italic') >= 0) {
                        this.fontStr = font._font.replace('italic', '');
                    } else {
                        this.fontStr = font._font;
                    }
                }
            }, {
                key: "getNextChar",
                value: function getNextChar(str) {
                    var len = str.length;
                    var start = this._curStrPos;
                    if (start >= len)
                        return null;
                    var i = start;
                    var state = 0;
                    for (; i < len; i++) {
                        var c = str.charCodeAt(i);
                        if (c >>> 11 == 0x1b) {
                            if (state == 1)
                                break;
                            state = 1;
                            i++;
                        } else if (c === 0xfe0e || c === 0xfe0f)
                            ;
                        else if (c == 0x200d) {
                            state = 2;
                        } else {
                            if (state == 0)
                                state = 1;
                            else if (state == 1)
                                break;
                        }
                    }
                    this._curStrPos = i;
                    return str.substring(start, i);
                }
            }, {
                key: "filltext",
                value: function filltext(ctx, data, x, y, fontStr, color, strokeColor, lineWidth, textAlign) {
                    var underLine = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : 0;
                    if (data.length <= 0)
                        return;
                    var font = FontInfo.Parse(fontStr);
                    var nTextAlign = 0;
                    switch (textAlign) {
                        case 'center':
                            nTextAlign = ILaya.Context.ENUM_TEXTALIGN_CENTER;
                            break;
                        case 'right':
                            nTextAlign = ILaya.Context.ENUM_TEXTALIGN_RIGHT;
                            break;
                    }
                    this._fast_filltext(ctx, data, null, x, y, font, color, strokeColor, lineWidth, nTextAlign, underLine);
                }
            }, {
                key: "fillWords",
                value: function fillWords(ctx, data, x, y, fontStr, color, strokeColor, lineWidth) {
                    if (!data)
                        return;
                    if (data.length <= 0)
                        return;
                    var font = typeof fontStr === 'string' ? FontInfo.Parse(fontStr) : fontStr;
                    this._fast_filltext(ctx, null, data, x, y, font, color, strokeColor, lineWidth, 0, 0);
                }
            }, {
                key: "_fast_filltext",
                value: function _fast_filltext(ctx, data, htmlchars, x, y, font, color, strokeColor, lineWidth, textAlign) {
                    var underLine = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 0;
                    if (data && data.length < 1)
                        return;
                    if (htmlchars && htmlchars.length < 1)
                        return;
                    if (lineWidth < 0)
                        lineWidth = 0;
                    this.setFont(font);
                    this.fontScaleX = this.fontScaleY = 1.0;
                    if (TextRender.scaleFontWithCtx) {
                        var sx = 1;
                        var sy = 1;
                        if (!ILaya.Render.isConchApp || window.conchTextCanvas.scale) {
                            sx = ctx.getMatScaleX();
                            sy = ctx.getMatScaleY();
                        }
                        if (sx < 1e-4 || sy < 1e-1)
                            return;
                        if (sx > 1)
                            this.fontScaleX = sx;
                        if (sy > 1)
                            this.fontScaleY = sy;
                    }
                    font._italic && (ctx._italicDeg = 13);
                    var wt = data;
                    var isWT = !htmlchars && data instanceof WordText;
                    var str = data;
                    var isHtmlChar = !!htmlchars;
                    var sameTexData = isWT ? wt.pageChars : [];
                    var strWidth = 0;
                    if (isWT) {
                        str = wt._text;
                        strWidth = wt.width;
                        if (strWidth < 0) {
                            strWidth = wt.width = this.charRender.getWidth(this.fontStr, str);
                        }
                    } else {
                        strWidth = str ? this.charRender.getWidth(this.fontStr, str) : 0;
                    }
                    switch (textAlign) {
                        case ILaya.Context.ENUM_TEXTALIGN_CENTER:
                            x -= strWidth / 2;
                            break;
                        case ILaya.Context.ENUM_TEXTALIGN_RIGHT:
                            x -= strWidth;
                            break;
                    }
                    if (wt && sameTexData) {
                        if (this.hasFreedText(sameTexData)) {
                            sameTexData = wt.pageChars = [];
                        }
                    }
                    var ri = null;
                    var splitTex = this.renderPerChar = !isWT || TextRender.forceSplitRender || isHtmlChar || isWT && wt.splitRender;
                    if (!sameTexData || sameTexData.length < 1) {
                        if (isWT) {
                            wt.scalex = this.fontScaleX;
                            wt.scaley = this.fontScaleY;
                        }
                        if (splitTex) {
                            var stx = 0;
                            var sty = 0;
                            this._curStrPos = 0;
                            var curstr;
                            while (true) {
                                if (htmlchars) {
                                    var chc = htmlchars[this._curStrPos++];
                                    if (chc) {
                                        curstr = chc["char"];
                                        stx = chc.x;
                                        sty = chc.y;
                                    } else {
                                        curstr = null;
                                    }
                                } else {
                                    curstr = this.getNextChar(str);
                                }
                                if (!curstr)
                                    break;
                                ri = this.getCharRenderInfo(curstr, font, color, strokeColor, lineWidth, false);
                                if (!ri) {
                                    break;
                                }
                                if (ri.isSpace)
                                    ;
                                else {
                                    var add = sameTexData[ri.tex.id];
                                    if (!add) {
                                        var o1 = {
                                            texgen: ri.tex.genID,
                                            tex: ri.tex,
                                            words: []
                                        };
                                        sameTexData[ri.tex.id] = o1;
                                        add = o1.words;
                                    } else {
                                        add = add.words;
                                    }
                                    add.push({
                                        ri: ri,
                                        x: stx,
                                        y: sty,
                                        w: ri.bmpWidth / this.fontScaleX,
                                        h: ri.bmpHeight / this.fontScaleY
                                    });
                                    stx += ri.width;
                                }
                            }
                        } else {
                            var isotex = TextRender.noAtlas || strWidth * this.fontScaleX > TextRender.atlasWidth;
                            ri = this.getCharRenderInfo(str, font, color, strokeColor, lineWidth, isotex);
                            sameTexData[0] = {
                                texgen: ri.tex.genID,
                                tex: ri.tex,
                                words: [{
                                    ri: ri,
                                    x: 0,
                                    y: 0,
                                    w: ri.bmpWidth / this.fontScaleX,
                                    h: ri.bmpHeight / this.fontScaleY
                                }]
                            };
                        }
                    }
                    this._drawResortedWords(ctx, x, y, sameTexData);
                    ctx._italicDeg = 0;
                }
            }, {
                key: "_drawResortedWords",
                value: function _drawResortedWords(ctx, startx, starty, samePagesData) {
                    var isLastRender = ctx._charSubmitCache ? ctx._charSubmitCache._enable : false;
                    var mat = ctx._curMat;
                    var slen = samePagesData.length;
                    for (var id in samePagesData) {
                        var dt = samePagesData[id];
                        if (!dt)
                            continue;
                        var pri = dt.words;
                        var pisz = pri.length;
                        if (pisz <= 0)
                            continue;
                        var tex = samePagesData[id].tex;
                        for (var j = 0; j < pisz; j++) {
                            var riSaved = pri[j];
                            var ri = riSaved.ri;
                            if (ri.isSpace)
                                continue;
                            ri.touch();
                            ctx.drawTexAlign = true;
                            if (ILaya.Render.isConchApp) {
                                ctx._drawTextureM(tex.texture, startx + riSaved.x - ri.orix, starty + riSaved.y - ri.oriy, riSaved.w, riSaved.h, null, 1.0, ri.uv);
                            } else {
                                var t = tex;
                                ctx._inner_drawTexture(t.texture, t.id, startx + riSaved.x - ri.orix, starty + riSaved.y - ri.oriy, riSaved.w, riSaved.h, mat, ri.uv, 1.0, isLastRender);
                            }
                            if (ctx.touches) {
                                ctx.touches.push(ri);
                            }
                        }
                    }
                }
            }, {
                key: "hasFreedText",
                value: function hasFreedText(txts) {
                    var sz = txts.length;
                    for (var i = 0; i < sz; i++) {
                        var pri = txts[i];
                        if (!pri)
                            continue;
                        var tex = pri.tex;
                        if (tex.__destroyed || tex.genID != pri.texgen) {
                            return true;
                        }
                    }
                    return false;
                }
            }, {
                key: "getCharRenderInfo",
                value: function getCharRenderInfo(str, font, color, strokeColor, lineWidth) {
                    var isoTexture = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                    var fid = this.mapFont[font._family];
                    if (fid == undefined) {
                        this.mapFont[font._family] = fid = this.fontID++;
                    }
                    var key = str + '_' + fid + '_' + font._size + '_' + color;
                    if (lineWidth > 0)
                        key += '_' + strokeColor + lineWidth;
                    if (font._bold)
                        key += 'P';
                    if (this.fontScaleX != 1 || this.fontScaleY != 1) {
                        key += (this.fontScaleX * 20 | 0) + '_' + (this.fontScaleY * 20 | 0);
                    }
                    var i = 0;
                    var sz = this.textAtlases.length;
                    var ri;
                    var atlas;
                    if (!isoTexture) {
                        for (i = 0; i < sz; i++) {
                            atlas = this.textAtlases[i];
                            ri = atlas.charMaps[key];
                            if (ri) {
                                ri.touch();
                                return ri;
                            }
                        }
                    }
                    ri = new CharRenderInfo();
                    this.charRender.scale(this.fontScaleX, this.fontScaleY);
                    ri["char"] = str;
                    ri.height = font._size;
                    var margin = ILaya.Render.isConchApp ? 0 : font._size / 3 | 0;
                    var imgdt = null;
                    if (!lineWidth) {
                        lineWidth = 0;
                    }
                    var w1 = Math.ceil((this.charRender.getWidth(this.fontStr, str) + 2 * lineWidth) * this.fontScaleX);
                    if (w1 > this.charRender.canvasWidth) {
                        this.charRender.canvasWidth = Math.min(2048, w1 + margin * 2);
                    }
                    if (isoTexture) {
                        this.charRender.fontsz = font._size;
                        imgdt = this.charRender.getCharBmp(str, this.fontStr, lineWidth, color, strokeColor, ri, margin, margin, margin, margin, null);
                        if (imgdt) {
                            var tex = TextTexture.getTextTexture(imgdt.width, imgdt.height);
                            tex.addChar(imgdt, 0, 0, ri.uv);
                            ri.tex = tex;
                            ri.orix = margin;
                            ri.oriy = margin;
                            tex.ri = ri;
                            this.isoTextures.push(tex);
                        }
                    } else {
                        var len = str.length;
                        var lineExt = lineWidth * 1;
                        var fw = Math.ceil((this.fontSizeW + lineExt * 2) * this.fontScaleX);
                        var fh = Math.ceil((this.fontSizeH + lineExt * 2) * this.fontScaleY);
                        TextRender.imgdtRect[0] = (margin - this.fontSizeOffX - lineExt) * this.fontScaleX | 0;
                        TextRender.imgdtRect[1] = (margin - this.fontSizeOffY - lineExt) * this.fontScaleY | 0;
                        if (this.renderPerChar || len == 1) {
                            TextRender.imgdtRect[2] = Math.max(w1, fw);
                            TextRender.imgdtRect[3] = Math.max(w1, fh);
                        } else {
                            TextRender.imgdtRect[2] = -1;
                            TextRender.imgdtRect[3] = fh;
                        }
                        this.charRender.fontsz = font._size;
                        imgdt = this.charRender.getCharBmp(str, this.fontStr, lineWidth, color, strokeColor, ri, margin, margin, margin, margin, TextRender.imgdtRect);
                        if (imgdt) {
                            atlas = this.addBmpData(imgdt, ri);
                            if (TextRender.isWan1Wan) {
                                ri.orix = margin;
                                ri.oriy = margin;
                            } else {
                                ri.orix = this.fontSizeOffX + lineExt;
                                ri.oriy = this.fontSizeOffY + lineExt;
                            }
                            atlas.charMaps[key] = ri;
                        }
                    }
                    return ri;
                }
            }, {
                key: "addBmpData",
                value: function addBmpData(data, ri) {
                    var w = data.width;
                    var h = data.height;
                    var sz = this.textAtlases.length;
                    var atlas;
                    var find = false;
                    for (var i = 0; i < sz; i++) {
                        atlas = this.textAtlases[i];
                        find = atlas.getAEmpty(w, h, this.tmpAtlasPos);
                        if (find) {
                            break;
                        }
                    }
                    if (!find) {
                        atlas = new TextAtlas();
                        this.textAtlases.push(atlas);
                        find = atlas.getAEmpty(w, h, this.tmpAtlasPos);
                        if (!find) {
                            throw 'err1';
                        }
                        this.cleanAtlases();
                    }
                    if (find) {
                        atlas.texture.addChar(data, this.tmpAtlasPos.x, this.tmpAtlasPos.y, ri.uv);
                        ri.tex = atlas.texture;
                    }
                    return atlas;
                }
            }, {
                key: "GC",
                value: function GC() {
                    var i = 0;
                    var sz = this.textAtlases.length;
                    var dt = 0;
                    var destroyDt = TextRender.destroyAtlasDt;
                    var totalUsedRate = 0;
                    var totalUsedRateAtlas = 0;
                    var curloop = RenderInfo.loopCount;
                    var maxWasteRateID = -1;
                    var maxWasteRate = 0;
                    var tex = null;
                    var curatlas = null;
                    for (; i < sz; i++) {
                        curatlas = this.textAtlases[i];
                        tex = curatlas.texture;
                        if (tex) {
                            totalUsedRate += tex.curUsedCovRate;
                            totalUsedRateAtlas += tex.curUsedCovRateAtlas;
                            var waste = curatlas.usedRate - tex.curUsedCovRateAtlas;
                            if (maxWasteRate < waste) {
                                maxWasteRate = waste;
                                maxWasteRateID = i;
                            }
                        }
                        dt = curloop - curatlas.texture.lastTouchTm;
                        if (dt > destroyDt) {
                            TextRender.showLog && console.log('TextRender GC delete atlas ' + tex ? curatlas.texture.id : 'unk');
                            curatlas.destroy();
                            this.textAtlases[i] = this.textAtlases[sz - 1];
                            sz--;
                            i--;
                            maxWasteRateID = -1;
                        }
                    }
                    this.textAtlases.length = sz;
                    sz = this.isoTextures.length;
                    for (i = 0; i < sz; i++) {
                        tex = this.isoTextures[i];
                        dt = curloop - tex.lastTouchTm;
                        if (dt > TextRender.destroyUnusedTextureDt) {
                            tex.ri.deleted = true;
                            tex.ri.tex = null;
                            tex.destroy();
                            this.isoTextures[i] = this.isoTextures[sz - 1];
                            sz--;
                            i--;
                        }
                    }
                    this.isoTextures.length = sz;
                    var needGC = this.textAtlases.length > 1 && this.textAtlases.length - totalUsedRateAtlas >= 2;
                    if (TextRender.atlasWidth * TextRender.atlasWidth * 4 * this.textAtlases.length > TextRender.cleanMem || needGC || TextRender.simClean) {
                        TextRender.simClean = false;
                        TextRender.showLog && console.log('清理使用率低的贴图。总使用率:', totalUsedRateAtlas, ':', this.textAtlases.length, '最差贴图:' + maxWasteRateID);
                        if (maxWasteRateID >= 0) {
                            curatlas = this.textAtlases[maxWasteRateID];
                            curatlas.destroy();
                            this.textAtlases[maxWasteRateID] = this.textAtlases[this.textAtlases.length - 1];
                            this.textAtlases.length = this.textAtlases.length - 1;
                        }
                    }
                    TextTexture.clean();
                }
            }, {
                key: "cleanAtlases",
                value: function cleanAtlases() { }
            }, {
                key: "getCharBmp",
                value: function getCharBmp(c) { }
            }, {
                key: "checkBmpLine",
                value: function checkBmpLine(data, l, sx, ex) {
                    if (this.bmpData32.buffer != data.data.buffer) {
                        this.bmpData32 = new Uint32Array(data.data.buffer);
                    }
                    var stpos = data.width * l + sx;
                    for (var x = sx; x < ex; x++) {
                        if (this.bmpData32[stpos++] != 0)
                            return true;
                    }
                    return false;
                }
            }, {
                key: "updateBbx",
                value: function updateBbx(data, curbbx) {
                    var onlyH = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    var w = data.width;
                    var h = data.height;
                    var x = 0;
                    var sy = curbbx[1];
                    var ey = 0;
                    var y = sy;
                    if (this.checkBmpLine(data, sy, 0, w)) {
                        while (true) {
                            y = (sy + ey) / 2 | 0;
                            if (y + 1 >= sy) {
                                curbbx[1] = y;
                                break;
                            }
                            if (this.checkBmpLine(data, y, 0, w)) {
                                sy = y;
                            } else {
                                ey = y;
                            }
                        }
                    }
                    if (curbbx[3] > h)
                        curbbx[3] = h;
                    else {
                        y = sy = curbbx[3];
                        ey = h;
                        if (this.checkBmpLine(data, sy, 0, w)) {
                            while (true) {
                                y = (sy + ey) / 2 | 0;
                                if (y - 1 <= sy) {
                                    curbbx[3] = y;
                                    break;
                                }
                                if (this.checkBmpLine(data, y, 0, w)) {
                                    sy = y;
                                } else {
                                    ey = y;
                                }
                            }
                        }
                    }
                    if (onlyH)
                        return;
                    var minx = curbbx[0];
                    var stpos = w * curbbx[1];
                    for (y = curbbx[1]; y < curbbx[3]; y++) {
                        for (x = 0; x < minx; x++) {
                            if (this.bmpData32[stpos + x] != 0) {
                                minx = x;
                                break;
                            }
                        }
                        stpos += w;
                    }
                    curbbx[0] = minx;
                    var maxx = curbbx[2];
                    stpos = w * curbbx[1];
                    for (y = curbbx[1]; y < curbbx[3]; y++) {
                        for (x = maxx; x < w; x++) {
                            if (this.bmpData32[stpos + x] != 0) {
                                maxx = x;
                                break;
                            }
                        }
                        stpos += w;
                    }
                    curbbx[2] = maxx;
                }
            }, {
                key: "getFontSizeInfo",
                value: function getFontSizeInfo(font) {
                    var finfo = this.fontSizeInfo[font];
                    if (finfo != undefined)
                        return finfo;
                    var fontstr = 'bold ' + TextRender.standardFontSize + 'px ' + font;
                    if (TextRender.isWan1Wan) {
                        this.fontSizeW = this.charRender.getWidth(fontstr, '有') * 1.5;
                        this.fontSizeH = TextRender.standardFontSize * 1.5;
                        var szinfo = this.fontSizeW << 8 | this.fontSizeH;
                        this.fontSizeInfo[font] = szinfo;
                        return szinfo;
                    }
                    TextRender.pixelBBX[0] = TextRender.standardFontSize / 2;
                    TextRender.pixelBBX[1] = TextRender.standardFontSize / 2;
                    TextRender.pixelBBX[2] = TextRender.standardFontSize;
                    TextRender.pixelBBX[3] = TextRender.standardFontSize;
                    var orix = 16;
                    var oriy = 16;
                    var marginr = 16;
                    var marginb = 16;
                    this.charRender.scale(1, 1);
                    TextRender.tmpRI.height = TextRender.standardFontSize;
                    this.charRender.fontsz = TextRender.standardFontSize;
                    var bmpdt = this.charRender.getCharBmp('g', fontstr, 0, 'red', null, TextRender.tmpRI, orix, oriy, marginr, marginb);
                    if (ILaya.Render.isConchApp) {
                        bmpdt.data = new Uint8ClampedArray(bmpdt.data);
                    }
                    this.bmpData32 = new Uint32Array(bmpdt.data.buffer);
                    this.updateBbx(bmpdt, TextRender.pixelBBX, false);
                    bmpdt = this.charRender.getCharBmp('有', fontstr, 0, 'red', null, TextRender.tmpRI, oriy, oriy, marginr, marginb);
                    if (ILaya.Render.isConchApp) {
                        bmpdt.data = new Uint8ClampedArray(bmpdt.data);
                    }
                    this.bmpData32 = new Uint32Array(bmpdt.data.buffer);
                    if (TextRender.pixelBBX[2] < orix + TextRender.tmpRI.width)
                        TextRender.pixelBBX[2] = orix + TextRender.tmpRI.width;
                    this.updateBbx(bmpdt, TextRender.pixelBBX, false);
                    if (ILaya.Render.isConchApp) {
                        orix = 0;
                        oriy = 0;
                    }
                    var xoff = Math.max(orix - TextRender.pixelBBX[0], 0);
                    var yoff = Math.max(oriy - TextRender.pixelBBX[1], 0);
                    var bbxw = TextRender.pixelBBX[2] - TextRender.pixelBBX[0];
                    var bbxh = TextRender.pixelBBX[3] - TextRender.pixelBBX[1];
                    var sizeinfo = xoff << 24 | yoff << 16 | bbxw << 8 | bbxh;
                    this.fontSizeInfo[font] = sizeinfo;
                    return sizeinfo;
                }
            }, {
                key: "printDbgInfo",
                value: function printDbgInfo() {
                    console.log('图集个数:' + this.textAtlases.length + ',每个图集大小:' + TextRender.atlasWidth + 'x' + TextRender.atlasWidth, ' 用canvas:', TextRender.isWan1Wan);
                    console.log('图集占用空间:' + TextRender.atlasWidth * TextRender.atlasWidth * 4 / 1024 / 1024 * this.textAtlases.length + 'M');
                    console.log('缓存用到的字体:');
                    for (var f in this.mapFont) {
                        var fontsz = this.getFontSizeInfo(f);
                        var offx = fontsz >> 24;
                        var offy = fontsz >> 16 & 0xff;
                        var fw = fontsz >> 8 & 0xff;
                        var fh = fontsz & 0xff;
                        console.log('    ' + f, ' off:', offx, offy, ' size:', fw, fh);
                    }
                    var num = 0;
                    console.log('缓存数据:');
                    var totalUsedRate = 0;
                    var totalUsedRateAtlas = 0;
                    this.textAtlases.forEach(function (a) {
                        var id = a.texture.id;
                        var dt = RenderInfo.loopCount - a.texture.lastTouchTm;
                        var dtstr = dt > 0 ? '' + dt + '帧以前' : '当前帧';
                        totalUsedRate += a.texture.curUsedCovRate;
                        totalUsedRateAtlas += a.texture.curUsedCovRateAtlas;
                        console.log('--图集(id:' + id + ',当前使用率:' + (a.texture.curUsedCovRate * 1000 | 0) + '‰', '当前图集使用率:', (a.texture.curUsedCovRateAtlas * 100 | 0) + '%', '图集使用率:', a.usedRate * 100 | 0, '%, 使用于:' + dtstr + ')--:');
                        for (var k in a.charMaps) {
                            var ri = a.charMaps[k];
                            console.log('     off:', ri.orix, ri.oriy, ' bmp宽高:', ri.bmpWidth, ri.bmpHeight, '无效:', ri.deleted, 'touchdt:', RenderInfo.loopCount - ri.touchTick, '位置:', ri.uv[0] * TextRender.atlasWidth | 0, ri.uv[1] * TextRender.atlasWidth | 0, '字符:', ri["char"], 'key:', k);
                            num++;
                        }
                    });
                    console.log('独立贴图文字(' + this.isoTextures.length + '个):');
                    this.isoTextures.forEach(function (tex) {
                        console.log('    size:', tex._texW, tex._texH, 'touch间隔:', RenderInfo.loopCount - tex.lastTouchTm, 'char:', tex.ri["char"]);
                    });
                    console.log('总缓存:', num, '总使用率:', totalUsedRate, '总当前图集使用率:', totalUsedRateAtlas);
                }
            }, {
                key: "showAtlas",
                value: function showAtlas(n, bgcolor, x, y, w, h) {
                    if (!this.textAtlases[n]) {
                        console.log('没有这个图集');
                        return null;
                    }
                    var sp = new ILaya.Sprite();
                    var texttex = this.textAtlases[n].texture;
                    var texture = {
                        width: TextRender.atlasWidth,
                        height: TextRender.atlasWidth,
                        sourceWidth: TextRender.atlasWidth,
                        sourceHeight: TextRender.atlasWidth,
                        offsetX: 0,
                        offsetY: 0,
                        getIsReady: function getIsReady() {
                            return true;
                        },
                        _addReference: function _addReference() { },
                        _removeReference: function _removeReference() { },
                        _getSource: function _getSource() {
                            return texttex._getSource();
                        },
                        bitmap: {
                            id: texttex.id
                        },
                        _uv: Texture.DEF_UV
                    };
                    sp.size = function (w, h) {
                        this.width = w;
                        this.height = h;
                        sp.graphics.clear();
                        sp.graphics.drawRect(0, 0, sp.width, sp.height, bgcolor);
                        sp.graphics.drawTexture(texture, 0, 0, sp.width, sp.height);
                        return this;
                    }
                        ;
                    sp.graphics.drawRect(0, 0, w, h, bgcolor);
                    sp.graphics.drawTexture(texture, 0, 0, w, h);
                    sp.pos(x, y);
                    ILaya.stage.addChild(sp);
                    return sp;
                }
            }, {
                key: "filltext_native",
                value: function filltext_native(ctx, data, htmlchars, x, y, fontStr, color, strokeColor, lineWidth, textAlign) {
                    var underLine = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 0;
                    if (data && data.length <= 0)
                        return;
                    if (htmlchars && htmlchars.length < 1)
                        return;
                    var font = FontInfo.Parse(fontStr);
                    var nTextAlign = 0;
                    switch (textAlign) {
                        case 'center':
                            nTextAlign = ILaya.Context.ENUM_TEXTALIGN_CENTER;
                            break;
                        case 'right':
                            nTextAlign = ILaya.Context.ENUM_TEXTALIGN_RIGHT;
                            break;
                    }
                    return this._fast_filltext(ctx, data, htmlchars, x, y, font, color, strokeColor, lineWidth, nTextAlign, underLine);
                }
            }]);
            return TextRender;
        }();
    TextRender.useOldCharBook = false;
    TextRender.atlasWidth = 1024;
    TextRender.noAtlas = false;
    TextRender.forceSplitRender = false;
    TextRender.forceWholeRender = false;
    TextRender.scaleFontWithCtx = true;
    TextRender.standardFontSize = 32;
    TextRender.destroyAtlasDt = 10;
    TextRender.checkCleanTextureDt = 2000;
    TextRender.destroyUnusedTextureDt = 3000;
    TextRender.cleanMem = 100 * 1024 * 1024;
    TextRender.isWan1Wan = false;
    TextRender.showLog = false;
    TextRender.debugUV = false;
    TextRender.tmpRI = new CharRenderInfo();
    TextRender.pixelBBX = [0, 0, 0, 0];
    TextRender.imgdtRect = [0, 0, 0, 0];
    TextRender.simClean = false;
    TextTexture.gTextRender = TextRender;
    var Context = /*#__PURE__*/
        function () {
            function Context() {
                _classCallCheck(this, Context);
                this._tmpMatrix = new Matrix();
                this._drawTexToDrawTri_Vert = new Float32Array(8);
                this._drawTexToDrawTri_Index = new Uint16Array([0, 1, 2, 0, 2, 3]);
                this._tempUV = new Float32Array(8);
                this._drawTriUseAbsMatrix = false;
                this._id = ++Context._COUNT;
                this._other = null;
                this._renderNextSubmitIndex = 0;
                this._path = null;
                this._drawCount = 1;
                this._width = Context._MAXSIZE;
                this._height = Context._MAXSIZE;
                this._renderCount = 0;
                this._submits = null;
                this._curSubmit = null;
                this._submitKey = new SubmitKey();
                this._mesh = null;
                this._pathMesh = null;
                this._triangleMesh = null;
                this.meshlist = [];
                this._transedPoints = new Array(8);
                this._temp4Points = new Array(8);
                this._clipRect = Context.MAXCLIPRECT;
                this._globalClipMatrix = new Matrix(Context._MAXSIZE, 0, 0, Context._MAXSIZE, 0, 0);
                this._clipInCache = false;
                this._clipInfoID = 0;
                this._clipID_Gen = 0;
                this._lastMatScaleX = 1.0;
                this._lastMatScaleY = 1.0;
                this._lastMat_a = 1.0;
                this._lastMat_b = 0.0;
                this._lastMat_c = 0.0;
                this._lastMat_d = 1.0;
                this._nBlendType = 0;
                this._save = null;
                this._targets = null;
                this._charSubmitCache = null;
                this._saveMark = null;
                this._shader2D = new Shader2D();
                this.sprite = null;
                this._italicDeg = 0;
                this._lastTex = null;
                this._fillColor = 0;
                this._flushCnt = 0;
                this.defTexture = null;
                this._colorFiler = null;
                this.drawTexAlign = false;
                this._incache = false;
                this.isMain = false;
                Context._contextcount++;
                Context._textRender = Context._textRender || new TextRender();
                if (!this.defTexture) {
                    var defTex2d = new Texture2D(2, 2);
                    defTex2d.setPixels(new Uint8Array(16));
                    defTex2d.lock = true;
                    this.defTexture = new Texture(defTex2d);
                }
                this._lastTex = this.defTexture;
                this.clear();
            }
            _createClass(Context, [{
                key: "drawImage",
                value: function drawImage() { }
            }, {
                key: "getImageData",
                value: function getImageData() { }
            }, {
                key: "measureText",
                value: function measureText(text) {
                    return null;
                }
            }, {
                key: "setTransform",
                value: function setTransform() { }
            }, {
                key: "$transform",
                value: function $transform(a, b, c, d, tx, ty) { }
            }, {
                key: "lineJoin",
                get: function get() {
                    return '';
                },
                set: function set(value) { }
            }, {
                key: "lineCap",
                get: function get() {
                    return '';
                },
                set: function set(value) { }
            }, {
                key: "miterLimit",
                get: function get() {
                    return '';
                },
                set: function set(value) { }
            }, {
                key: "clearRect",
                value: function clearRect(x, y, width, height) { }
            }, {
                key: "_drawRect",
                value: function _drawRect(x, y, width, height, style) {
                    Stat.renderBatches++;
                    style && (this.fillStyle = style);
                    this.fillRect(x, y, width, height, null);
                }
            }, {
                key: "drawTexture2",
                value: function drawTexture2(x, y, pivotX, pivotY, m, args2) { }
            }, {
                key: "transformByMatrix",
                value: function transformByMatrix(matrix, tx, ty) {
                    this.transform(matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx + tx, matrix.ty + ty);
                }
            }, {
                key: "saveTransform",
                value: function saveTransform(matrix) {
                    this.save();
                }
            }, {
                key: "restoreTransform",
                value: function restoreTransform(matrix) {
                    this.restore();
                }
            }, {
                key: "drawRect",
                value: function drawRect(x, y, width, height, fillColor, lineColor, lineWidth) {
                    var ctx = this;
                    if (fillColor != null) {
                        ctx.fillStyle = fillColor;
                        ctx.fillRect(x, y, width, height);
                    }
                    if (lineColor != null) {
                        ctx.strokeStyle = lineColor;
                        ctx.lineWidth = lineWidth;
                        ctx.strokeRect(x, y, width, height);
                    }
                }
            }, {
                key: "alpha",
                value: function alpha(value) {
                    this.globalAlpha *= value;
                }
            }, {
                key: "_transform",
                value: function _transform(mat, pivotX, pivotY) {
                    this.translate(pivotX, pivotY);
                    this.transform(mat.a, mat.b, mat.c, mat.d, mat.tx, mat.ty);
                    this.translate(-pivotX, -pivotY);
                }
            }, {
                key: "_rotate",
                value: function _rotate(angle, pivotX, pivotY) {
                    this.translate(pivotX, pivotY);
                    this.rotate(angle);
                    this.translate(-pivotX, -pivotY);
                }
            }, {
                key: "_scale",
                value: function _scale(scaleX, scaleY, pivotX, pivotY) {
                    this.translate(pivotX, pivotY);
                    this.scale(scaleX, scaleY);
                    this.translate(-pivotX, -pivotY);
                }
            }, {
                key: "_drawLine",
                value: function _drawLine(x, y, fromX, fromY, toX, toY, lineColor, lineWidth, vid) {
                    this.beginPath();
                    this.strokeStyle = lineColor;
                    this.lineWidth = lineWidth;
                    this.moveTo(x + fromX, y + fromY);
                    this.lineTo(x + toX, y + toY);
                    this.stroke();
                }
            }, {
                key: "_drawLines",
                value: function _drawLines(x, y, points, lineColor, lineWidth, vid) {
                    this.beginPath();
                    this.strokeStyle = lineColor;
                    this.lineWidth = lineWidth;
                    this.addPath(points.slice(), false, false, x, y);
                    this.stroke();
                }
            }, {
                key: "drawCurves",
                value: function drawCurves(x, y, points, lineColor, lineWidth) {
                    this.beginPath();
                    this.strokeStyle = lineColor;
                    this.lineWidth = lineWidth;
                    this.moveTo(x + points[0], y + points[1]);
                    var i = 2
                        , n = points.length;
                    while (i < n) {
                        this.quadraticCurveTo(x + points[i++], y + points[i++], x + points[i++], y + points[i++]);
                    }
                    this.stroke();
                }
            }, {
                key: "_fillAndStroke",
                value: function _fillAndStroke(fillColor, strokeColor, lineWidth) {
                    var isConvexPolygon = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
                    if (fillColor != null) {
                        this.fillStyle = fillColor;
                        this.fill();
                    }
                    if (strokeColor != null && lineWidth > 0) {
                        this.strokeStyle = strokeColor;
                        this.lineWidth = lineWidth;
                        this.stroke();
                    }
                }
            }, {
                key: "_drawCircle",
                value: function _drawCircle(x, y, radius, fillColor, lineColor, lineWidth, vid) {
                    Stat.renderBatches++;
                    this.beginPath(true);
                    this.arc(x, y, radius, 0, Context.PI2);
                    this.closePath();
                    this._fillAndStroke(fillColor, lineColor, lineWidth);
                }
            }, {
                key: "_drawPie",
                value: function _drawPie(x, y, radius, startAngle, endAngle, fillColor, lineColor, lineWidth, vid) {
                    this.beginPath();
                    this.moveTo(x, y);
                    this.arc(x, y, radius, startAngle, endAngle);
                    this.closePath();
                    this._fillAndStroke(fillColor, lineColor, lineWidth);
                }
            }, {
                key: "_drawPoly",
                value: function _drawPoly(x, y, points, fillColor, lineColor, lineWidth, isConvexPolygon, vid) {
                    this.beginPath();
                    this.addPath(points.slice(), true, isConvexPolygon, x, y);
                    this.closePath();
                    this._fillAndStroke(fillColor, lineColor, lineWidth, isConvexPolygon);
                }
            }, {
                key: "_drawPath",
                value: function _drawPath(x, y, paths, brush, pen) {
                    this.beginPath();
                    for (var i = 0, n = paths.length; i < n; i++) {
                        var path = paths[i];
                        switch (path[0]) {
                            case "moveTo":
                                this.moveTo(x + path[1], y + path[2]);
                                break;
                            case "lineTo":
                                this.lineTo(x + path[1], y + path[2]);
                                break;
                            case "arcTo":
                                this.arcTo(x + path[1], y + path[2], x + path[3], y + path[4], path[5]);
                                break;
                            case "closePath":
                                this.closePath();
                                break;
                        }
                    }
                    if (brush != null) {
                        this.fillStyle = brush.fillStyle;
                        this.fill();
                    }
                    if (pen != null) {
                        this.strokeStyle = pen.strokeStyle;
                        this.lineWidth = pen.lineWidth || 1;
                        this.lineJoin = pen.lineJoin;
                        this.lineCap = pen.lineCap;
                        this.miterLimit = pen.miterLimit;
                        this.stroke();
                    }
                }
            }, {
                key: "clearBG",
                value: function clearBG(r, g, b, a) {
                    var gl = WebGLContext.mainContext;
                    gl.clearColor(r, g, b, a);
                    gl.clear(gl.COLOR_BUFFER_BIT);
                }
            }, {
                key: "_getSubmits",
                value: function _getSubmits() {
                    return this._submits;
                }
            }, {
                key: "_releaseMem",
                value: function _releaseMem() {
                    var keepRT = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (!this._submits)
                        return;
                    this._curMat && this._curMat.destroy();
                    this._curMat = null;
                    this._shader2D.destroy();
                    this._shader2D = null;
                    this._charSubmitCache.clear();
                    for (var i = 0, n = this._submits._length; i < n; i++) {
                        this._submits[i].releaseRender();
                    }
                    this._submits.length = 0;
                    this._submits._length = 0;
                    this._submits = null;
                    this._curSubmit = null;
                    this._path = null;
                    this._save = null;
                    var sz;
                    for (i = 0,
                        sz = this.meshlist.length; i < sz; i++) {
                        var curm = this.meshlist[i];
                        curm.destroy();
                    }
                    this.meshlist.length = 0;
                    this.sprite = null;
                    if (!keepRT) {
                        this._targets && this._targets.destroy();
                        this._targets = null;
                    }
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    var keepRT = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    --Context._contextcount;
                    this.sprite = null;
                    this._releaseMem(keepRT);
                    this._charSubmitCache.destroy();
                    this._mesh.destroy();
                    if (!keepRT) {
                        this._targets && this._targets.destroy();
                        this._targets = null;
                    }
                }
            }, {
                key: "clear",
                value: function clear() {
                    if (!this._submits) {
                        this._other = ContextParams.DEFAULT;
                        this._curMat = Matrix.create();
                        this._charSubmitCache = new CharSubmitCache();
                        this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._mesh);
                        this._pathMesh = MeshVG.getAMesh(this.isMain);
                        this.meshlist.push(this._pathMesh);
                        this._triangleMesh = MeshTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._triangleMesh);
                        this._submits = [];
                        this._save = [SaveMark.Create(this)];
                        this._save.length = 10;
                        this._shader2D = new Shader2D();
                    }
                    this._submitKey.clear();
                    this._mesh.clearVB();
                    this._drawCount = 1;
                    this._other = ContextParams.DEFAULT;
                    this._other.lineWidth = this._shader2D.ALPHA = 1.0;
                    this._nBlendType = 0;
                    this._clipRect = Context.MAXCLIPRECT;
                    this._curSubmit = SubmitBase.RENDERBASE;
                    SubmitBase.RENDERBASE._ref = 0xFFFFFF;
                    SubmitBase.RENDERBASE._numEle = 0;
                    this._shader2D.fillStyle = this._shader2D.strokeStyle = DrawStyle.DEFAULT;
                    for (var i = 0, n = this._submits._length; i < n; i++) {
                        this._submits[i].releaseRender();
                    }
                    this._submits._length = 0;
                    this._curMat.identity();
                    this._other.clear();
                    this._saveMark = this._save[0];
                    this._save._length = 1;
                }
            }, {
                key: "size",
                value: function size(w, h) {
                    if (this._width != w || this._height != h) {
                        this._width = w;
                        this._height = h;
                        if (this._targets) {
                            this._targets.destroy();
                            this._targets = new RenderTexture2D(w, h, exports.RenderTextureFormat.R8G8B8A8, -1);
                        }
                        if (this.isMain) {
                            WebGLContext.mainContext.viewport(0, 0, w, h);
                            RenderState2D.width = w;
                            RenderState2D.height = h;
                        }
                    }
                    if (w === 0 && h === 0)
                        this._releaseMem();
                }
            }, {
                key: "asBitmap",
                set: function set(value) {
                    if (value) {
                        var rt = this._targets;
                        if (!this._width || !this._height)
                            throw Error("asBitmap no size!");
                        if (!rt || rt.width != this._width || rt.height != this._height) {
                            if (rt) {
                                rt.destroy();
                            }
                            this._targets = new RenderTexture2D(this._width, this._height, exports.RenderTextureFormat.R8G8B8A8, -1);
                        }
                    } else {
                        this._targets && this._targets.destroy();
                        this._targets = null;
                    }
                }
            }, {
                key: "getMatScaleX",
                value: function getMatScaleX() {
                    if (this._lastMat_a == this._curMat.a && this._lastMat_b == this._curMat.b)
                        return this._lastMatScaleX;
                    this._lastMatScaleX = this._curMat.getScaleX();
                    this._lastMat_a = this._curMat.a;
                    this._lastMat_b = this._curMat.b;
                    return this._lastMatScaleX;
                }
            }, {
                key: "getMatScaleY",
                value: function getMatScaleY() {
                    if (this._lastMat_c == this._curMat.c && this._lastMat_d == this._curMat.d)
                        return this._lastMatScaleY;
                    this._lastMatScaleY = this._curMat.getScaleY();
                    this._lastMat_c = this._curMat.c;
                    this._lastMat_d = this._curMat.d;
                    return this._lastMatScaleY;
                }
            }, {
                key: "setFillColor",
                value: function setFillColor(color) {
                    this._fillColor = color;
                }
            }, {
                key: "getFillColor",
                value: function getFillColor() {
                    return this._fillColor;
                }
            }, {
                key: "fillStyle",
                get: function get() {
                    return this._shader2D.fillStyle;
                },
                set: function set(value) {
                    if (!this._shader2D.fillStyle.equal(value)) {
                        SaveBase.save(this, SaveBase.TYPE_FILESTYLE, this._shader2D, false);
                        this._shader2D.fillStyle = DrawStyle.create(value);
                        this._submitKey.other = -this._shader2D.fillStyle.toInt();
                    }
                }
            }, {
                key: "globalAlpha",
                get: function get() {
                    return this._shader2D.ALPHA;
                },
                set: function set(value) {
                    value = Math.floor(value * 1000) / 1000;
                    if (value != this._shader2D.ALPHA) {
                        SaveBase.save(this, SaveBase.TYPE_ALPHA, this._shader2D, false);
                        this._shader2D.ALPHA = value;
                    }
                }
            }, {
                key: "textAlign",
                get: function get() {
                    return this._other.textAlign;
                },
                set: function set(value) {
                    this._other.textAlign === value || (this._other = this._other.make(),
                        SaveBase.save(this, SaveBase.TYPE_TEXTALIGN, this._other, false),
                        this._other.textAlign = value);
                }
            }, {
                key: "textBaseline",
                get: function get() {
                    return this._other.textBaseline;
                },
                set: function set(value) {
                    this._other.textBaseline === value || (this._other = this._other.make(),
                        SaveBase.save(this, SaveBase.TYPE_TEXTBASELINE, this._other, false),
                        this._other.textBaseline = value);
                }
            }, {
                key: "globalCompositeOperation",
                get: function get() {
                    return BlendMode.NAMES[this._nBlendType];
                },
                set: function set(value) {
                    var n = BlendMode.TOINT[value];
                    n == null || this._nBlendType === n || (SaveBase.save(this, SaveBase.TYPE_GLOBALCOMPOSITEOPERATION, this, true),
                        this._curSubmit = SubmitBase.RENDERBASE,
                        this._nBlendType = n);
                }
            }, {
                key: "strokeStyle",
                get: function get() {
                    return this._shader2D.strokeStyle;
                },
                set: function set(value) {
                    this._shader2D.strokeStyle.equal(value) || (SaveBase.save(this, SaveBase.TYPE_STROKESTYLE, this._shader2D, false),
                        this._shader2D.strokeStyle = DrawStyle.create(value),
                        this._submitKey.other = -this._shader2D.strokeStyle.toInt());
                }
            }, {
                key: "translate",
                value: function translate(x, y) {
                    if (x !== 0 || y !== 0) {
                        SaveTranslate.save(this);
                        if (this._curMat._bTransform) {
                            SaveTransform.save(this);
                            this._curMat.tx += x * this._curMat.a + y * this._curMat.c;
                            this._curMat.ty += x * this._curMat.b + y * this._curMat.d;
                        } else {
                            this._curMat.tx = x;
                            this._curMat.ty = y;
                        }
                    }
                }
            }, {
                key: "lineWidth",
                get: function get() {
                    return this._other.lineWidth;
                },
                set: function set(value) {
                    this._other.lineWidth === value || (this._other = this._other.make(),
                        SaveBase.save(this, SaveBase.TYPE_LINEWIDTH, this._other, false),
                        this._other.lineWidth = value);
                }
            }, {
                key: "save",
                value: function save() {
                    this._save[this._save._length++] = SaveMark.Create(this);
                }
            }, {
                key: "restore",
                value: function restore() {
                    var sz = this._save._length;
                    var lastBlend = this._nBlendType;
                    if (sz < 1)
                        return;
                    for (var i = sz - 1; i >= 0; i--) {
                        var o = this._save[i];
                        o.restore(this);
                        if (o.isSaveMark()) {
                            this._save._length = i;
                            return;
                        }
                    }
                    if (lastBlend != this._nBlendType) {
                        this._curSubmit = SubmitBase.RENDERBASE;
                    }
                }
            }, {
                key: "font",
                set: function set(str) {
                    this._other = this._other.make();
                    SaveBase.save(this, SaveBase.TYPE_FONT, this._other, false);
                }
            }, {
                key: "fillText",
                value: function fillText(txt, x, y, fontStr, color, align) {
                    var lineWidth = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0;
                    var borderColor = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : "";
                    Context._textRender.filltext(this, txt, x, y, fontStr, color, borderColor, lineWidth, align);
                }
            }, {
                key: "drawText",
                value: function drawText(text, x, y, font, color, textAlign) {
                    Context._textRender.filltext(this, text, x, y, font, color, null, 0, textAlign);
                }
            }, {
                key: "fillWords",
                value: function fillWords(words, x, y, fontStr, color) {
                    Context._textRender.fillWords(this, words, x, y, fontStr, color, null, 0);
                }
            }, {
                key: "strokeWord",
                value: function strokeWord(text, x, y, font, color, lineWidth, textAlign) {
                    Context._textRender.filltext(this, text, x, y, font, null, color, lineWidth, textAlign);
                }
            }, {
                key: "fillBorderText",
                value: function fillBorderText(txt, x, y, font, color, borderColor, lineWidth, textAlign) {
                    Context._textRender.filltext(this, txt, x, y, font, color, borderColor, lineWidth, textAlign);
                }
            }, {
                key: "fillBorderWords",
                value: function fillBorderWords(words, x, y, font, color, borderColor, lineWidth) {
                    Context._textRender.fillWords(this, words, x, y, font, color, borderColor, lineWidth);
                }
            }, {
                key: "_fast_filltext",
                value: function _fast_filltext(data, x, y, fontObj, color, strokeColor, lineWidth, textAlign) {
                    var underLine = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
                    Context._textRender._fast_filltext(this, data, null, x, y, fontObj, color, strokeColor, lineWidth, textAlign, underLine);
                }
            }, {
                key: "_fillRect",
                value: function _fillRect(x, y, width, height, rgba) {
                    var submit = this._curSubmit;
                    var sameKey = submit && submit._key.submitType === SubmitBase.KEY_DRAWTEXTURE && submit._key.blendShader === this._nBlendType;
                    if (this._mesh.vertNum + 4 > Context._MAXVERTNUM) {
                        this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._mesh);
                        sameKey = false;
                    }
                    sameKey && (sameKey = sameKey && this.isSameClipInfo(submit));
                    this.transformQuad(x, y, width, height, 0, this._curMat, this._transedPoints);
                    if (!this.clipedOff(this._transedPoints)) {
                        this._mesh.addQuad(this._transedPoints, Texture.NO_UV, rgba, false);
                        if (!sameKey) {
                            submit = this._curSubmit = SubmitTexture.create(this, this._mesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                            this._submits[this._submits._length++] = submit;
                            this._copyClipInfo(submit, this._globalClipMatrix);
                            submit.shaderValue.textureHost = this._lastTex;
                            submit._key.other = this._lastTex && this._lastTex.bitmap ? this._lastTex.bitmap.id : -1;
                            submit._renderType = SubmitBase.TYPE_TEXTURE;
                        }
                        this._curSubmit._numEle += 6;
                        this._mesh.indexNum += 6;
                        this._mesh.vertNum += 4;
                    }
                }
            }, {
                key: "fillRect",
                value: function fillRect(x, y, width, height, fillStyle) {
                    var drawstyle = fillStyle ? DrawStyle.create(fillStyle) : this._shader2D.fillStyle;
                    var rgba = this.mixRGBandAlpha(drawstyle.toInt());
                    this._fillRect(x, y, width, height, rgba);
                }
            }, {
                key: "fillTexture",
                value: function fillTexture(texture, x, y, width, height, type, offset, other) {
                    if (!texture._getSource()) {
                        this.sprite && ILaya.systemTimer.callLater(this, this._repaintSprite);
                        return;
                    }
                    this._fillTexture(texture, texture.width, texture.height, texture.uvrect, x, y, width, height, type, offset.x, offset.y);
                }
            }, {
                key: "_fillTexture",
                value: function _fillTexture(texture, texw, texh, texuvRect, x, y, width, height, type, offsetx, offsety) {
                    var submit = this._curSubmit;
                    if (this._mesh.vertNum + 4 > Context._MAXVERTNUM) {
                        this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._mesh);
                    }
                    var repeatx = true;
                    var repeaty = true;
                    switch (type) {
                        case "repeat":
                            break;
                        case "repeat-x":
                            repeaty = false;
                            break;
                        case "repeat-y":
                            repeatx = false;
                            break;
                        case "no-repeat":
                            repeatx = repeaty = false;
                            break;
                        default:
                            break;
                    }
                    var uv = this._temp4Points;
                    var stu = 0;
                    var stv = 0;
                    var stx = 0
                        , sty = 0
                        , edx = 0
                        , edy = 0;
                    if (offsetx < 0) {
                        stx = x;
                        stu = -offsetx % texw / texw;
                    } else {
                        stx = x + offsetx;
                    }
                    if (offsety < 0) {
                        sty = y;
                        stv = -offsety % texh / texh;
                    } else {
                        sty = y + offsety;
                    }
                    edx = x + width;
                    edy = y + height;
                    !repeatx && (edx = Math.min(edx, x + offsetx + texw));
                    !repeaty && (edy = Math.min(edy, y + offsety + texh));
                    if (edx < x || edy < y)
                        return;
                    if (stx > edx || sty > edy)
                        return;
                    var edu = (edx - x - offsetx) / texw;
                    var edv = (edy - y - offsety) / texh;
                    this.transformQuad(stx, sty, edx - stx, edy - sty, 0, this._curMat, this._transedPoints);
                    uv[0] = stu;
                    uv[1] = stv;
                    uv[2] = edu;
                    uv[3] = stv;
                    uv[4] = edu;
                    uv[5] = edv;
                    uv[6] = stu;
                    uv[7] = edv;
                    if (!this.clipedOff(this._transedPoints)) {
                        var rgba = this._mixRGBandAlpha(0xffffffff, this._shader2D.ALPHA);
                        this._mesh.addQuad(this._transedPoints, uv, rgba, true);
                        var sv = Value2D.create(ShaderDefines2D.TEXTURE2D, 0);
                        sv.defines.add(ShaderDefines2D.FILLTEXTURE);
                        sv.u_TexRange = texuvRect.concat();
                        submit = this._curSubmit = SubmitTexture.create(this, this._mesh, sv);
                        this._submits[this._submits._length++] = submit;
                        this._copyClipInfo(submit, this._globalClipMatrix);
                        submit.shaderValue.textureHost = texture;
                        submit._renderType = SubmitBase.TYPE_TEXTURE;
                        this._curSubmit._numEle += 6;
                        this._mesh.indexNum += 6;
                        this._mesh.vertNum += 4;
                    }
                    this.breakNextMerge();
                }
            }, {
                key: "setColorFilter",
                value: function setColorFilter(filter) {
                    SaveBase.save(this, SaveBase.TYPE_COLORFILTER, this, true);
                    this._colorFiler = filter;
                    this._curSubmit = SubmitBase.RENDERBASE;
                }
            }, {
                key: "drawTexture",
                value: function drawTexture(tex, x, y, width, height) {
                    this._drawTextureM(tex, x, y, width, height, null, 1, null);
                }
            }, {
                key: "drawTextures",
                value: function drawTextures(tex, pos, tx, ty) {
                    if (!tex._getSource()) {
                        this.sprite && ILaya.systemTimer.callLater(this, this._repaintSprite);
                        return;
                    }
                    var n = pos.length / 2;
                    var ipos = 0;
                    var bmpid = tex.bitmap.id;
                    for (var i = 0; i < n; i++) {
                        this._inner_drawTexture(tex, bmpid, pos[ipos++] + tx, pos[ipos++] + ty, 0, 0, null, null, 1.0, false);
                    }
                }
            }, {
                key: "_drawTextureAddSubmit",
                value: function _drawTextureAddSubmit(imgid, tex) {
                    var submit = null;
                    submit = SubmitTexture.create(this, this._mesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                    this._submits[this._submits._length++] = submit;
                    submit.shaderValue.textureHost = tex;
                    submit._key.other = imgid;
                    submit._renderType = SubmitBase.TYPE_TEXTURE;
                    this._curSubmit = submit;
                }
            }, {
                key: "_drawTextureM",
                value: function _drawTextureM(tex, x, y, width, height, m, alpha, uv) {
                    var cs = this.sprite;
                    if (!tex._getSource(function () {
                        if (cs) {
                            cs.repaint();
                        }
                    })) {
                        return false;
                    }
                    return this._inner_drawTexture(tex, tex.bitmap.id, x, y, width, height, m, uv, alpha, false);
                }
            }, {
                key: "_drawRenderTexture",
                value: function _drawRenderTexture(tex, x, y, width, height, m, alpha, uv) {
                    return this._inner_drawTexture(tex, -1, x, y, width, height, m, uv, 1.0, false);
                }
            }, {
                key: "submitDebugger",
                value: function submitDebugger() {
                    this._submits[this._submits._length++] = SubmitCMD.create([], function () {
                        debugger;
                    }, this);
                }
            }, {
                key: "_copyClipInfo",
                value: function _copyClipInfo(submit, clipInfo) {
                    var cm = submit.shaderValue.clipMatDir;
                    cm[0] = clipInfo.a;
                    cm[1] = clipInfo.b;
                    cm[2] = clipInfo.c;
                    cm[3] = clipInfo.d;
                    var cmp = submit.shaderValue.clipMatPos;
                    cmp[0] = clipInfo.tx;
                    cmp[1] = clipInfo.ty;
                    submit.clipInfoID = this._clipInfoID;
                    if (this._clipInCache) {
                        submit.shaderValue.clipOff[0] = 1;
                    }
                }
            }, {
                key: "isSameClipInfo",
                value: function isSameClipInfo(submit) {
                    return submit.clipInfoID === this._clipInfoID;
                }
            }, {
                key: "_useNewTex2DSubmit",
                value: function _useNewTex2DSubmit(tex, minVertNum) {
                    if (this._mesh.vertNum + minVertNum > Context._MAXVERTNUM) {
                        this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._mesh);
                    }
                    var submit = SubmitTexture.create(this, this._mesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                    this._submits[this._submits._length++] = this._curSubmit = submit;
                    submit.shaderValue.textureHost = tex;
                    this._copyClipInfo(submit, this._globalClipMatrix);
                }
            }, {
                key: "_drawTexRect",
                value: function _drawTexRect(x, y, w, h, uv) {
                    this.transformQuad(x, y, w, h, this._italicDeg, this._curMat, this._transedPoints);
                    var ops = this._transedPoints;
                    ops[0] = ops[0] + 0.5 | 0;
                    ops[1] = ops[1] + 0.5 | 0;
                    ops[2] = ops[2] + 0.5 | 0;
                    ops[3] = ops[3] + 0.5 | 0;
                    ops[4] = ops[4] + 0.5 | 0;
                    ops[5] = ops[5] + 0.5 | 0;
                    ops[6] = ops[6] + 0.5 | 0;
                    ops[7] = ops[7] + 0.5 | 0;
                    if (!this.clipedOff(this._transedPoints)) {
                        this._mesh.addQuad(this._transedPoints, uv, this._fillColor, true);
                        this._curSubmit._numEle += 6;
                        this._mesh.indexNum += 6;
                        this._mesh.vertNum += 4;
                    }
                }
            }, {
                key: "drawCallOptimize",
                value: function drawCallOptimize(enable) {
                    this._charSubmitCache.enable(enable, this);
                    return enable;
                }
            }, {
                key: "_inner_drawTexture",
                value: function _inner_drawTexture(tex, imgid, x, y, width, height, m, uv, alpha, lastRender) {
                    if (width <= 0 || height <= 0) {
                        return;
                    }
                    var preKey = this._curSubmit._key;
                    uv = uv || tex._uv;
                    if (preKey.submitType === SubmitBase.KEY_TRIANGLES && preKey.other === imgid) {
                        var tv = this._drawTexToDrawTri_Vert;
                        tv[0] = x;
                        tv[1] = y;
                        tv[2] = x + width,
                            tv[3] = y,
                            tv[4] = x + width,
                            tv[5] = y + height,
                            tv[6] = x,
                            tv[7] = y + height;
                        this._drawTriUseAbsMatrix = true;
                        var tuv = this._tempUV;
                        tuv[0] = uv[0];
                        tuv[1] = uv[1];
                        tuv[2] = uv[2];
                        tuv[3] = uv[3];
                        tuv[4] = uv[4];
                        tuv[5] = uv[5];
                        tuv[6] = uv[6];
                        tuv[7] = uv[7];
                        this.drawTriangles(tex, 0, 0, tv, tuv, this._drawTexToDrawTri_Index, m, alpha, null, null);
                        this._drawTriUseAbsMatrix = false;
                        return true;
                    }
                    var mesh = this._mesh;
                    var submit = this._curSubmit;
                    var ops = lastRender ? this._charSubmitCache.getPos() : this._transedPoints;
                    this.transformQuad(x, y, width || tex.width, height || tex.height, this._italicDeg, m || this._curMat, ops);
                    if (this.drawTexAlign) {
                        var round = Math.round;
                        ops[0] = round(ops[0]);
                        ops[1] = round(ops[1]);
                        ops[2] = round(ops[2]);
                        ops[3] = round(ops[3]);
                        ops[4] = round(ops[4]);
                        ops[5] = round(ops[5]);
                        ops[6] = round(ops[6]);
                        ops[7] = round(ops[7]);
                        this.drawTexAlign = false;
                    }
                    var rgba = this._mixRGBandAlpha(0xffffffff, this._shader2D.ALPHA * alpha);
                    if (lastRender) {
                        this._charSubmitCache.add(this, tex, imgid, ops, uv, rgba);
                        return true;
                    }
                    this._drawCount++;
                    var sameKey = imgid >= 0 && preKey.submitType === SubmitBase.KEY_DRAWTEXTURE && preKey.other === imgid;
                    sameKey && (sameKey = sameKey && this.isSameClipInfo(submit));
                    this._lastTex = tex;
                    if (mesh.vertNum + 4 > Context._MAXVERTNUM) {
                        mesh = this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(mesh);
                        sameKey = false;
                    }
                    {
                        mesh.addQuad(ops, uv, rgba, true);
                        if (!sameKey) {
                            this._submits[this._submits._length++] = this._curSubmit = submit = SubmitTexture.create(this, mesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                            submit.shaderValue.textureHost = tex;
                            submit._key.other = imgid;
                            this._copyClipInfo(submit, this._globalClipMatrix);
                        }
                        submit._numEle += 6;
                        mesh.indexNum += 6;
                        mesh.vertNum += 4;
                        return true;
                    }
                    return false;
                }
            }, {
                key: "transform4Points",
                value: function transform4Points(a, m, out) {
                    var tx = m.tx;
                    var ty = m.ty;
                    var ma = m.a;
                    var mb = m.b;
                    var mc = m.c;
                    var md = m.d;
                    var a0 = a[0];
                    var a1 = a[1];
                    var a2 = a[2];
                    var a3 = a[3];
                    var a4 = a[4];
                    var a5 = a[5];
                    var a6 = a[6];
                    var a7 = a[7];
                    if (m._bTransform) {
                        out[0] = a0 * ma + a1 * mc + tx;
                        out[1] = a0 * mb + a1 * md + ty;
                        out[2] = a2 * ma + a3 * mc + tx;
                        out[3] = a2 * mb + a3 * md + ty;
                        out[4] = a4 * ma + a5 * mc + tx;
                        out[5] = a4 * mb + a5 * md + ty;
                        out[6] = a6 * ma + a7 * mc + tx;
                        out[7] = a6 * mb + a7 * md + ty;
                    } else {
                        out[0] = a0 + tx;
                        out[1] = a1 + ty;
                        out[2] = a2 + tx;
                        out[3] = a3 + ty;
                        out[4] = a4 + tx;
                        out[5] = a5 + ty;
                        out[6] = a6 + tx;
                        out[7] = a7 + ty;
                    }
                }
            }, {
                key: "clipedOff",
                value: function clipedOff(pt) {
                    if (this._clipRect.width <= 0 || this._clipRect.height <= 0)
                        return true;
                    return false;
                }
            }, {
                key: "transformQuad",
                value: function transformQuad(x, y, w, h, italicDeg, m, out) {
                    var xoff = 0;
                    if (italicDeg != 0) {
                        xoff = Math.tan(italicDeg * Math.PI / 180) * h;
                    }
                    var maxx = x + w;
                    var maxy = y + h;
                    var tx = m.tx;
                    var ty = m.ty;
                    var ma = m.a;
                    var mb = m.b;
                    var mc = m.c;
                    var md = m.d;
                    var a0 = x + xoff;
                    var a1 = y;
                    var a2 = maxx + xoff;
                    var a3 = y;
                    var a4 = maxx;
                    var a5 = maxy;
                    var a6 = x;
                    var a7 = maxy;
                    if (m._bTransform) {
                        out[0] = a0 * ma + a1 * mc + tx;
                        out[1] = a0 * mb + a1 * md + ty;
                        out[2] = a2 * ma + a3 * mc + tx;
                        out[3] = a2 * mb + a3 * md + ty;
                        out[4] = a4 * ma + a5 * mc + tx;
                        out[5] = a4 * mb + a5 * md + ty;
                        out[6] = a6 * ma + a7 * mc + tx;
                        out[7] = a6 * mb + a7 * md + ty;
                    } else {
                        out[0] = a0 + tx;
                        out[1] = a1 + ty;
                        out[2] = a2 + tx;
                        out[3] = a3 + ty;
                        out[4] = a4 + tx;
                        out[5] = a5 + ty;
                        out[6] = a6 + tx;
                        out[7] = a7 + ty;
                    }
                }
            }, {
                key: "pushRT",
                value: function pushRT() {
                    this.addRenderObject(SubmitCMD.create(null, RenderTexture2D.pushRT, this));
                }
            }, {
                key: "popRT",
                value: function popRT() {
                    this.addRenderObject(SubmitCMD.create(null, RenderTexture2D.popRT, this));
                    this.breakNextMerge();
                }
            }, {
                key: "useRT",
                value: function useRT(rt) {
                    function _use(rt) {
                        if (!rt) {
                            throw 'error useRT';
                        } else {
                            rt.start();
                            rt.clear(0, 0, 0, 0);
                        }
                    }
                    this.addRenderObject(SubmitCMD.create([rt], _use, this));
                    this.breakNextMerge();
                }
            }, {
                key: "RTRestore",
                value: function RTRestore(rt) {
                    function _restore(rt) {
                        rt.restore();
                    }
                    this.addRenderObject(SubmitCMD.create([rt], _restore, this));
                    this.breakNextMerge();
                }
            }, {
                key: "breakNextMerge",
                value: function breakNextMerge() {
                    this._curSubmit = SubmitBase.RENDERBASE;
                }
            }, {
                key: "_repaintSprite",
                value: function _repaintSprite() {
                    this.sprite && this.sprite.repaint();
                }
            }, {
                key: "drawTextureWithTransform",
                value: function drawTextureWithTransform(tex, x, y, width, height, transform, tx, ty, alpha, blendMode) {
                    var colorfilter = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : null;
                    var uv = arguments.length > 11 ? arguments[11] : undefined;
                    var oldcomp;
                    var curMat = this._curMat;
                    if (blendMode) {
                        oldcomp = this.globalCompositeOperation;
                        this.globalCompositeOperation = blendMode;
                    }
                    var oldColorFilter = this._colorFiler;
                    if (colorfilter) {
                        this.setColorFilter(colorfilter);
                    }
                    if (!transform) {
                        this._drawTextureM(tex, x + tx, y + ty, width, height, curMat, alpha, uv);
                        if (blendMode) {
                            this.globalCompositeOperation = oldcomp;
                        }
                        if (colorfilter) {
                            this.setColorFilter(oldColorFilter);
                        }
                        return;
                    }
                    var tmpMat = this._tmpMatrix;
                    tmpMat.a = transform.a;
                    tmpMat.b = transform.b;
                    tmpMat.c = transform.c;
                    tmpMat.d = transform.d;
                    tmpMat.tx = transform.tx + tx;
                    tmpMat.ty = transform.ty + ty;
                    tmpMat._bTransform = transform._bTransform;
                    if (transform && curMat._bTransform) {
                        Matrix.mul(tmpMat, curMat, tmpMat);
                        transform = tmpMat;
                        transform._bTransform = true;
                    } else {
                        tmpMat.tx += curMat.tx;
                        tmpMat.ty += curMat.ty;
                        transform = tmpMat;
                    }
                    this._drawTextureM(tex, x, y, width, height, transform, alpha, uv);
                    if (blendMode) {
                        this.globalCompositeOperation = oldcomp;
                    }
                    if (colorfilter) {
                        this.setColorFilter(oldColorFilter);
                    }
                }
            }, {
                key: "_flushToTarget",
                value: function _flushToTarget(context, target) {
                    RenderState2D.worldScissorTest = false;
                    var gl = LayaGL.instance;
                    gl.disable(gl.SCISSOR_TEST);
                    var preAlpha = RenderState2D.worldAlpha;
                    var preMatrix4 = RenderState2D.worldMatrix4;
                    var preMatrix = RenderState2D.worldMatrix;
                    RenderState2D.worldMatrix = Matrix.EMPTY;
                    RenderState2D.restoreTempArray();
                    RenderState2D.worldMatrix4 = RenderState2D.TEMPMAT4_ARRAY;
                    RenderState2D.worldAlpha = 1;
                    BaseShader.activeShader = null;
                    if (ILaya.Browser.onIOS) {
                        gl.flush();
                    }
                    target.start();
                    if (context._submits._length > 0)
                        target.clear(0, 0, 0, 0);
                    context._curSubmit = SubmitBase.RENDERBASE;
                    context.flush();
                    context.clear();
                    target.restore();
                    context._curSubmit = SubmitBase.RENDERBASE;
                    BaseShader.activeShader = null;
                    RenderState2D.worldAlpha = preAlpha;
                    RenderState2D.worldMatrix4 = preMatrix4;
                    RenderState2D.worldMatrix = preMatrix;
                }
            }, {
                key: "drawCanvas",
                value: function drawCanvas(canvas, x, y, width, height) {
                    if (!canvas)
                        return;
                    var src = canvas.context;
                    var submit;
                    if (src._targets) {
                        if (src._submits._length > 0) {
                            submit = SubmitCMD.create([src, src._targets], this._flushToTarget, this);
                            this._submits[this._submits._length++] = submit;
                        }
                        this._drawRenderTexture(src._targets, x, y, width, height, null, 1.0, RenderTexture2D.flipyuv);
                        this._curSubmit = SubmitBase.RENDERBASE;
                    } else {
                        var canv = canvas;
                        if (canv.touches) {
                            canv.touches.forEach(function (v) {
                                v.touch();
                            });
                        }
                        submit = SubmitCanvas.create(canvas, this._shader2D.ALPHA, this._shader2D.filters);
                        this._submits[this._submits._length++] = submit;
                        submit._key.clear();
                        var mat = submit._matrix;
                        this._curMat.copyTo(mat);
                        var tx = mat.tx
                            , ty = mat.ty;
                        mat.tx = mat.ty = 0;
                        mat.transformPoint(Point.TEMP.setTo(x, y));
                        mat.translate(Point.TEMP.x + tx, Point.TEMP.y + ty);
                        Matrix.mul(canv.invMat, mat, mat);
                        this._curSubmit = SubmitBase.RENDERBASE;
                    }
                }
            }, {
                key: "drawTarget",
                value: function drawTarget(rt, x, y, width, height, m, shaderValue) {
                    var uv = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
                    var blend = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : -1;
                    this._drawCount++;
                    if (this._mesh.vertNum + 4 > Context._MAXVERTNUM) {
                        this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                        this.meshlist.push(this._mesh);
                    }
                    this.transformQuad(x, y, width, height, 0, m || this._curMat, this._transedPoints);
                    if (!this.clipedOff(this._transedPoints)) {
                        this._mesh.addQuad(this._transedPoints, uv || Texture.DEF_UV, 0xffffffff, true);
                        var submit = this._curSubmit = SubmitTarget.create(this, this._mesh, shaderValue, rt);
                        submit.blendType = blend == -1 ? this._nBlendType : blend;
                        this._copyClipInfo(submit, this._globalClipMatrix);
                        submit._numEle = 6;
                        this._mesh.indexNum += 6;
                        this._mesh.vertNum += 4;
                        this._submits[this._submits._length++] = submit;
                        this._curSubmit = SubmitBase.RENDERBASE;
                        return true;
                    }
                    this._curSubmit = SubmitBase.RENDERBASE;
                    return false;
                }
            }, {
                key: "drawTriangles",
                value: function drawTriangles(tex, x, y, vertices, uvs, indices, matrix, alpha, color, blendMode) {
                    var colorNum = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : 0xffffffff;
                    if (!tex._getSource()) {
                        if (this.sprite) {
                            ILaya.systemTimer.callLater(this, this._repaintSprite);
                        }
                        return;
                    }
                    var oldcomp = null;
                    if (blendMode) {
                        oldcomp = this.globalCompositeOperation;
                        this.globalCompositeOperation = blendMode;
                    }
                    this._drawCount++;
                    var tmpMat = this._tmpMatrix;
                    var triMesh = this._triangleMesh;
                    var oldColorFilter = null;
                    var needRestorFilter = false;
                    if (color) {
                        oldColorFilter = this._colorFiler;
                        this._colorFiler = color;
                        this._curSubmit = SubmitBase.RENDERBASE;
                        needRestorFilter = oldColorFilter != color;
                    }
                    var webGLImg = tex.bitmap;
                    var preKey = this._curSubmit._key;
                    var sameKey = preKey.submitType === SubmitBase.KEY_TRIANGLES && preKey.other === webGLImg.id && preKey.blendShader == this._nBlendType;
                    if (triMesh.vertNum + vertices.length / 2 > Context._MAXVERTNUM) {
                        triMesh = this._triangleMesh = MeshTexture.getAMesh(this.isMain);
                        this.meshlist.push(triMesh);
                        sameKey = false;
                    }
                    if (!sameKey) {
                        var submit = this._curSubmit = SubmitTexture.create(this, triMesh, Value2D.create(ShaderDefines2D.TEXTURE2D, 0));
                        submit.shaderValue.textureHost = tex;
                        submit._renderType = SubmitBase.TYPE_TEXTURE;
                        submit._key.submitType = SubmitBase.KEY_TRIANGLES;
                        submit._key.other = webGLImg.id;
                        this._copyClipInfo(submit, this._globalClipMatrix);
                        this._submits[this._submits._length++] = submit;
                    }
                    var rgba = this._mixRGBandAlpha(colorNum, this._shader2D.ALPHA * alpha);
                    if (!this._drawTriUseAbsMatrix) {
                        if (!matrix) {
                            tmpMat.a = 1;
                            tmpMat.b = 0;
                            tmpMat.c = 0;
                            tmpMat.d = 1;
                            tmpMat.tx = x;
                            tmpMat.ty = y;
                        } else {
                            tmpMat.a = matrix.a;
                            tmpMat.b = matrix.b;
                            tmpMat.c = matrix.c;
                            tmpMat.d = matrix.d;
                            tmpMat.tx = matrix.tx + x;
                            tmpMat.ty = matrix.ty + y;
                        }
                        Matrix.mul(tmpMat, this._curMat, tmpMat);
                        triMesh.addData(vertices, uvs, indices, tmpMat || this._curMat, rgba);
                    } else {
                        triMesh.addData(vertices, uvs, indices, matrix, rgba);
                    }
                    this._curSubmit._numEle += indices.length;
                    if (needRestorFilter) {
                        this._colorFiler = oldColorFilter;
                        this._curSubmit = SubmitBase.RENDERBASE;
                    }
                    if (blendMode) {
                        this.globalCompositeOperation = oldcomp;
                    }
                }
            }, {
                key: "transform",
                value: function transform(a, b, c, d, tx, ty) {
                    SaveTransform.save(this);
                    Matrix.mul(Matrix.TEMP.setTo(a, b, c, d, tx, ty), this._curMat, this._curMat);
                    this._curMat._checkTransform();
                }
            }, {
                key: "_transformByMatrix",
                value: function _transformByMatrix(matrix, tx, ty) {
                    matrix.setTranslate(tx, ty);
                    Matrix.mul(matrix, this._curMat, this._curMat);
                    matrix.setTranslate(0, 0);
                    this._curMat._bTransform = true;
                }
            }, {
                key: "setTransformByMatrix",
                value: function setTransformByMatrix(value) {
                    value.copyTo(this._curMat);
                }
            }, {
                key: "rotate",
                value: function rotate(angle) {
                    SaveTransform.save(this);
                    this._curMat.rotateEx(angle);
                }
            }, {
                key: "scale",
                value: function scale(scaleX, scaleY) {
                    SaveTransform.save(this);
                    this._curMat.scaleEx(scaleX, scaleY);
                }
            }, {
                key: "clipRect",
                value: function clipRect(x, y, width, height) {
                    SaveClipRect.save(this);
                    if (this._clipRect == Context.MAXCLIPRECT) {
                        this._clipRect = new Rectangle(x, y, width, height);
                    } else {
                        this._clipRect.width = width;
                        this._clipRect.height = height;
                        this._clipRect.x = x;
                        this._clipRect.y = y;
                    }
                    this._clipID_Gen++;
                    this._clipID_Gen %= 10000;
                    this._clipInfoID = this._clipID_Gen;
                    var cm = this._globalClipMatrix;
                    var minx = cm.tx;
                    var miny = cm.ty;
                    var maxx = minx + cm.a;
                    var maxy = miny + cm.d;
                    if (this._clipRect.width >= Context._MAXSIZE) {
                        cm.a = cm.d = Context._MAXSIZE;
                        cm.b = cm.c = cm.tx = cm.ty = 0;
                    } else {
                        if (this._curMat._bTransform) {
                            cm.tx = this._clipRect.x * this._curMat.a + this._clipRect.y * this._curMat.c + this._curMat.tx;
                            cm.ty = this._clipRect.x * this._curMat.b + this._clipRect.y * this._curMat.d + this._curMat.ty;
                            cm.a = this._clipRect.width * this._curMat.a;
                            cm.b = this._clipRect.width * this._curMat.b;
                            cm.c = this._clipRect.height * this._curMat.c;
                            cm.d = this._clipRect.height * this._curMat.d;
                        } else {
                            cm.tx = this._clipRect.x + this._curMat.tx;
                            cm.ty = this._clipRect.y + this._curMat.ty;
                            cm.a = this._clipRect.width;
                            cm.b = cm.c = 0;
                            cm.d = this._clipRect.height;
                        }
                        if (this._incache) {
                            this._clipInCache = true;
                        }
                    }
                    if (cm.a > 0 && cm.d > 0) {
                        var cmaxx = cm.tx + cm.a;
                        var cmaxy = cm.ty + cm.d;
                        if (cmaxx <= minx || cmaxy <= miny || cm.tx >= maxx || cm.ty >= maxy) {
                            cm.a = -0.1;
                            cm.d = -0.1;
                        } else {
                            if (cm.tx < minx) {
                                cm.a -= minx - cm.tx;
                                cm.tx = minx;
                            }
                            if (cmaxx > maxx) {
                                cm.a -= cmaxx - maxx;
                            }
                            if (cm.ty < miny) {
                                cm.d -= miny - cm.ty;
                                cm.ty = miny;
                            }
                            if (cmaxy > maxy) {
                                cm.d -= cmaxy - maxy;
                            }
                            if (cm.a <= 0)
                                cm.a = -0.1;
                            if (cm.d <= 0)
                                cm.d = -0.1;
                        }
                    }
                }
            }, {
                key: "drawMesh",
                value: function drawMesh(x, y, ib, vb, numElement, mat, shader, shaderValues) {
                    var startIndex = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
                }
            }, {
                key: "addRenderObject",
                value: function addRenderObject(o) {
                    this._submits[this._submits._length++] = o;
                }
            }, {
                key: "submitElement",
                value: function submitElement(start, end) {
                    var mainCtx = this.isMain;
                    var renderList = this._submits;
                    var ret = renderList._length;
                    end < 0 && (end = renderList._length);
                    var submit = SubmitBase.RENDERBASE;
                    while (start < end) {
                        this._renderNextSubmitIndex = start + 1;
                        if (renderList[start] === SubmitBase.RENDERBASE) {
                            start++;
                            continue;
                        }
                        SubmitBase.preRender = submit;
                        submit = renderList[start];
                        start += submit.renderSubmit();
                    }
                    return ret;
                }
            }, {
                key: "flush",
                value: function flush() {
                    this._clipID_Gen = 0;
                    var ret = this.submitElement(0, this._submits._length);
                    this._path && this._path.reset();
                    SkinMeshBuffer.instance && SkinMeshBuffer.getInstance().reset();
                    this._curSubmit = SubmitBase.RENDERBASE;
                    for (var i = 0, sz = this.meshlist.length; i < sz; i++) {
                        var curm = this.meshlist[i];
                        curm.canReuse ? curm.releaseMesh() : curm.destroy();
                    }
                    this.meshlist.length = 0;
                    this._mesh = MeshQuadTexture.getAMesh(this.isMain);
                    this._pathMesh = MeshVG.getAMesh(this.isMain);
                    this._triangleMesh = MeshTexture.getAMesh(this.isMain);
                    this.meshlist.push(this._mesh, this._pathMesh, this._triangleMesh);
                    this._flushCnt++;
                    if (this._flushCnt % 60 == 0 && this.isMain) {
                        if (TextRender.textRenderInst) {
                            TextRender.textRenderInst.GC();
                        }
                    }
                    return ret;
                }
            }, {
                key: "beginPath",
                value: function beginPath() {
                    var convex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    var tPath = this._getPath();
                    tPath.beginPath(convex);
                }
            }, {
                key: "closePath",
                value: function closePath() {
                    this._path.closePath();
                }
            }, {
                key: "addPath",
                value: function addPath(points, close, convex, dx, dy) {
                    var ci = 0;
                    for (var i = 0, sz = points.length / 2; i < sz; i++) {
                        var x1 = points[ci] + dx
                            , y1 = points[ci + 1] + dy;
                        points[ci] = x1;
                        points[ci + 1] = y1;
                        ci += 2;
                    }
                    this._getPath().push(points, convex);
                }
            }, {
                key: "fill",
                value: function fill() {
                    var m = this._curMat;
                    var tPath = this._getPath();
                    var submit = this._curSubmit;
                    var sameKey = submit._key.submitType === SubmitBase.KEY_VG && submit._key.blendShader === this._nBlendType;
                    sameKey && (sameKey = sameKey && this.isSameClipInfo(submit));
                    if (!sameKey) {
                        this._curSubmit = this.addVGSubmit(this._pathMesh);
                    }
                    var rgba = this.mixRGBandAlpha(this.fillStyle.toInt());
                    var curEleNum = 0;
                    var idx;
                    for (var i = 0, sz = tPath.paths.length; i < sz; i++) {
                        var p = tPath.paths[i];
                        var vertNum = p.path.length / 2;
                        if (vertNum < 3 || vertNum == 3 && !p.convex)
                            continue;
                        var cpath = p.path.concat();
                        var pi = 0;
                        var xp, yp;
                        var _x, _y;
                        if (m._bTransform) {
                            for (pi = 0; pi < vertNum; pi++) {
                                xp = pi << 1;
                                yp = xp + 1;
                                _x = cpath[xp];
                                _y = cpath[yp];
                                cpath[xp] = m.a * _x + m.c * _y + m.tx;
                                cpath[yp] = m.b * _x + m.d * _y + m.ty;
                            }
                        } else {
                            for (pi = 0; pi < vertNum; pi++) {
                                xp = pi << 1;
                                yp = xp + 1;
                                _x = cpath[xp];
                                _y = cpath[yp];
                                cpath[xp] = _x + m.tx;
                                cpath[yp] = _y + m.ty;
                            }
                        }
                        if (this._pathMesh.vertNum + vertNum > Context._MAXVERTNUM) {
                            this._curSubmit._numEle += curEleNum;
                            curEleNum = 0;
                            this._pathMesh = MeshVG.getAMesh(this.isMain);
                            this._curSubmit = this.addVGSubmit(this._pathMesh);
                        }
                        var curvert = this._pathMesh.vertNum;
                        if (p.convex) {
                            var faceNum = vertNum - 2;
                            idx = new Array(faceNum * 3);
                            var idxpos = 0;
                            for (var fi = 0; fi < faceNum; fi++) {
                                idx[idxpos++] = curvert;
                                idx[idxpos++] = fi + 1 + curvert;
                                idx[idxpos++] = fi + 2 + curvert;
                            }
                        } else {
                            idx = Earcut.earcut(cpath, null, 2);
                            if (curvert > 0) {
                                for (var ii = 0; ii < idx.length; ii++) {
                                    idx[ii] += curvert;
                                }
                            }
                        }
                        this._pathMesh.addVertAndIBToMesh(this, cpath, rgba, idx);
                        curEleNum += idx.length;
                    }
                    this._curSubmit._numEle += curEleNum;
                }
            }, {
                key: "addVGSubmit",
                value: function addVGSubmit(mesh) {
                    var submit = Submit.createShape(this, mesh, 0, Value2D.create(ShaderDefines2D.PRIMITIVE, 0));
                    submit._key.submitType = SubmitBase.KEY_VG;
                    this._submits[this._submits._length++] = submit;
                    this._copyClipInfo(submit, this._globalClipMatrix);
                    return submit;
                }
            }, {
                key: "stroke",
                value: function stroke() {
                    if (this.lineWidth > 0) {
                        var rgba = this.mixRGBandAlpha(this.strokeStyle._color.numColor);
                        var tPath = this._getPath();
                        var submit = this._curSubmit;
                        var sameKey = submit._key.submitType === SubmitBase.KEY_VG && submit._key.blendShader === this._nBlendType;
                        sameKey && (sameKey = sameKey && this.isSameClipInfo(submit));
                        if (!sameKey) {
                            this._curSubmit = this.addVGSubmit(this._pathMesh);
                        }
                        var curEleNum = 0;
                        for (var i = 0, sz = tPath.paths.length; i < sz; i++) {
                            var p = tPath.paths[i];
                            if (p.path.length <= 0)
                                continue;
                            var idx = [];
                            var vertex = [];
                            var maxVertexNum = p.path.length * 2;
                            if (maxVertexNum < 2)
                                continue;
                            if (this._pathMesh.vertNum + maxVertexNum > Context._MAXVERTNUM) {
                                this._curSubmit._numEle += curEleNum;
                                curEleNum = 0;
                                this._pathMesh = MeshVG.getAMesh(this.isMain);
                                this.meshlist.push(this._pathMesh);
                                this._curSubmit = this.addVGSubmit(this._pathMesh);
                            }
                            BasePoly.createLine2(p.path, idx, this.lineWidth, this._pathMesh.vertNum, vertex, p.loop);
                            var ptnum = vertex.length / 2;
                            var m = this._curMat;
                            var pi = 0;
                            var xp, yp;
                            var _x, _y;
                            if (m._bTransform) {
                                for (pi = 0; pi < ptnum; pi++) {
                                    xp = pi << 1;
                                    yp = xp + 1;
                                    _x = vertex[xp];
                                    _y = vertex[yp];
                                    vertex[xp] = m.a * _x + m.c * _y + m.tx;
                                    vertex[yp] = m.b * _x + m.d * _y + m.ty;
                                }
                            } else {
                                for (pi = 0; pi < ptnum; pi++) {
                                    xp = pi << 1;
                                    yp = xp + 1;
                                    _x = vertex[xp];
                                    _y = vertex[yp];
                                    vertex[xp] = _x + m.tx;
                                    vertex[yp] = _y + m.ty;
                                }
                            }
                            this._pathMesh.addVertAndIBToMesh(this, vertex, rgba, idx);
                            curEleNum += idx.length;
                        }
                        this._curSubmit._numEle += curEleNum;
                    }
                }
            }, {
                key: "moveTo",
                value: function moveTo(x, y) {
                    var tPath = this._getPath();
                    tPath.newPath();
                    tPath._lastOriX = x;
                    tPath._lastOriY = y;
                    tPath.addPoint(x, y);
                }
            }, {
                key: "lineTo",
                value: function lineTo(x, y) {
                    var tPath = this._getPath();
                    if (Math.abs(x - tPath._lastOriX) < 1e-3 && Math.abs(y - tPath._lastOriY) < 1e-3)
                        return;
                    tPath._lastOriX = x;
                    tPath._lastOriY = y;
                    tPath.addPoint(x, y);
                }
            }, {
                key: "arcTo",
                value: function arcTo(x1, y1, x2, y2, r) {
                    var i = 0;
                    var x = 0
                        , y = 0;
                    var dx = this._path._lastOriX - x1;
                    var dy = this._path._lastOriY - y1;
                    var len1 = Math.sqrt(dx * dx + dy * dy);
                    if (len1 <= 0.000001) {
                        return;
                    }
                    var ndx = dx / len1;
                    var ndy = dy / len1;
                    var dx2 = x2 - x1;
                    var dy2 = y2 - y1;
                    var len22 = dx2 * dx2 + dy2 * dy2;
                    var len2 = Math.sqrt(len22);
                    if (len2 <= 0.000001) {
                        return;
                    }
                    var ndx2 = dx2 / len2;
                    var ndy2 = dy2 / len2;
                    var odx = ndx + ndx2;
                    var ody = ndy + ndy2;
                    var olen = Math.sqrt(odx * odx + ody * ody);
                    if (olen <= 0.000001) {
                        return;
                    }
                    var nOdx = odx / olen;
                    var nOdy = ody / olen;
                    var alpha = Math.acos(nOdx * ndx + nOdy * ndy);
                    var halfAng = Math.PI / 2 - alpha;
                    len1 = r / Math.tan(halfAng);
                    var ptx1 = len1 * ndx + x1;
                    var pty1 = len1 * ndy + y1;
                    var orilen = Math.sqrt(len1 * len1 + r * r);
                    var orix = x1 + nOdx * orilen;
                    var oriy = y1 + nOdy * orilen;
                    var dir = ndx * ndy2 - ndy * ndx2;
                    var fChgAng = 0;
                    var sinx = 0.0;
                    var cosx = 0.0;
                    if (dir >= 0) {
                        fChgAng = halfAng * 2;
                        var fda = fChgAng / Context.SEGNUM;
                        sinx = Math.sin(fda);
                        cosx = Math.cos(fda);
                    } else {
                        fChgAng = -halfAng * 2;
                        fda = fChgAng / Context.SEGNUM;
                        sinx = Math.sin(fda);
                        cosx = Math.cos(fda);
                    }
                    var lastx = this._path._lastOriX
                        , lasty = this._path._lastOriY;
                    var _x1 = ptx1
                        , _y1 = pty1;
                    if (Math.abs(_x1 - this._path._lastOriX) > 0.1 || Math.abs(_y1 - this._path._lastOriY) > 0.1) {
                        x = _x1;
                        y = _y1;
                        lastx = _x1;
                        lasty = _y1;
                        this._path._lastOriX = x;
                        this._path._lastOriY = y;
                        this._path.addPoint(x, y);
                    }
                    var cvx = ptx1 - orix;
                    var cvy = pty1 - oriy;
                    for (i = 0; i < Context.SEGNUM; i++) {
                        var cx = cvx * cosx + cvy * sinx;
                        var cy = -cvx * sinx + cvy * cosx;
                        x = cx + orix;
                        y = cy + oriy;
                        if (Math.abs(lastx - x) > 0.1 || Math.abs(lasty - y) > 0.1) {
                            this._path._lastOriX = x;
                            this._path._lastOriY = y;
                            this._path.addPoint(x, y);
                            lastx = x;
                            lasty = y;
                        }
                        cvx = cx;
                        cvy = cy;
                    }
                }
            }, {
                key: "arc",
                value: function arc(cx, cy, r, startAngle, endAngle) {
                    var counterclockwise = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                    var b = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : true;
                    var a = 0
                        , da = 0;
                    var dx = 0
                        , dy = 0
                        , x = 0
                        , y = 0;
                    var i, ndivs;
                    da = endAngle - startAngle;
                    if (!counterclockwise) {
                        if (Math.abs(da) >= Math.PI * 2) {
                            da = Math.PI * 2;
                        } else {
                            while (da < 0.0) {
                                da += Math.PI * 2;
                            }
                        }
                    } else {
                        if (Math.abs(da) >= Math.PI * 2) {
                            da = -Math.PI * 2;
                        } else {
                            while (da > 0.0) {
                                da -= Math.PI * 2;
                            }
                        }
                    }
                    var sx = this.getMatScaleX();
                    var sy = this.getMatScaleY();
                    var sr = r * (sx > sy ? sx : sy);
                    var cl = 2 * Math.PI * sr;
                    ndivs = Math.max(cl / 10, 10) | 0;
                    var tPath = this._getPath();
                    for (i = 0; i <= ndivs; i++) {
                        a = startAngle + da * (i / ndivs);
                        dx = Math.cos(a);
                        dy = Math.sin(a);
                        x = cx + dx * r;
                        y = cy + dy * r;
                        if (x != this._path._lastOriX || y != this._path._lastOriY) {
                            tPath.addPoint(x, y);
                        }
                    }
                    dx = Math.cos(endAngle);
                    dy = Math.sin(endAngle);
                    x = cx + dx * r;
                    y = cy + dy * r;
                    if (x != this._path._lastOriX || y != this._path._lastOriY) {
                        tPath.addPoint(x, y);
                    }
                }
            }, {
                key: "quadraticCurveTo",
                value: function quadraticCurveTo(cpx, cpy, x, y) {
                    var tBezier = Bezier.I;
                    var tArray = tBezier.getBezierPoints([this._path._lastOriX, this._path._lastOriY, cpx, cpy, x, y], 30, 2);
                    for (var i = 0, n = tArray.length / 2; i < n; i++) {
                        this.lineTo(tArray[i * 2], tArray[i * 2 + 1]);
                    }
                    this.lineTo(x, y);
                }
            }, {
                key: "mixRGBandAlpha",
                value: function mixRGBandAlpha(color) {
                    return this._mixRGBandAlpha(color, this._shader2D.ALPHA);
                }
            }, {
                key: "_mixRGBandAlpha",
                value: function _mixRGBandAlpha(color, alpha) {
                    if (alpha >= 1) {
                        return color;
                    }
                    var a = (color & 0xff000000) >>> 24;
                    if (a != 0) {
                        a *= alpha;
                    } else {
                        a = alpha * 255;
                    }
                    return color & 0x00ffffff | a << 24;
                }
            }, {
                key: "strokeRect",
                value: function strokeRect(x, y, width, height, parameterLineWidth) {
                    if (this.lineWidth > 0) {
                        var rgba = this.mixRGBandAlpha(this.strokeStyle._color.numColor);
                        var hw = this.lineWidth / 2;
                        this._fillRect(x - hw, y - hw, width + this.lineWidth, this.lineWidth, rgba);
                        this._fillRect(x - hw, y - hw + height, width + this.lineWidth, this.lineWidth, rgba);
                        this._fillRect(x - hw, y + hw, this.lineWidth, height - this.lineWidth, rgba);
                        this._fillRect(x - hw + width, y + hw, this.lineWidth, height - this.lineWidth, rgba);
                    }
                }
            }, {
                key: "clip",
                value: function clip() { }
            }, {
                key: "drawParticle",
                value: function drawParticle(x, y, pt) {
                    pt.x = x;
                    pt.y = y;
                    this._submits[this._submits._length++] = pt;
                }
            }, {
                key: "_getPath",
                value: function _getPath() {
                    return this._path || (this._path = new Path());
                }
            }, {
                key: "canvas",
                get: function get() {
                    return this._canvas;
                }
            }, {
                key: "_fillTexture_h",
                value: function _fillTexture_h(tex, imgid, uv, oriw, orih, x, y, w) {
                    if (oriw <= 0)
                        console.error('_fillTexture_h error: oriw must>0');
                    var stx = x;
                    var num = Math.floor(w / oriw);
                    var left = w % oriw;
                    for (var i = 0; i < num; i++) {
                        this._inner_drawTexture(tex, imgid, stx, y, oriw, orih, this._curMat, uv, 1, false);
                        stx += oriw;
                    }
                    if (left > 0) {
                        var du = uv[2] - uv[0];
                        var uvr = uv[0] + du * (left / oriw);
                        var tuv = Context.tmpuv1;
                        tuv[0] = uv[0];
                        tuv[1] = uv[1];
                        tuv[2] = uvr;
                        tuv[3] = uv[3];
                        tuv[4] = uvr;
                        tuv[5] = uv[5];
                        tuv[6] = uv[6];
                        tuv[7] = uv[7];
                        this._inner_drawTexture(tex, imgid, stx, y, left, orih, this._curMat, tuv, 1, false);
                    }
                }
            }, {
                key: "_fillTexture_v",
                value: function _fillTexture_v(tex, imgid, uv, oriw, orih, x, y, h) {
                    if (orih <= 0)
                        console.error('_fillTexture_v error: orih must>0');
                    var sty = y;
                    var num = Math.floor(h / orih);
                    var left = h % orih;
                    for (var i = 0; i < num; i++) {
                        this._inner_drawTexture(tex, imgid, x, sty, oriw, orih, this._curMat, uv, 1, false);
                        sty += orih;
                    }
                    if (left > 0) {
                        var dv = uv[7] - uv[1];
                        var uvb = uv[1] + dv * (left / orih);
                        var tuv = Context.tmpuv1;
                        tuv[0] = uv[0];
                        tuv[1] = uv[1];
                        tuv[2] = uv[2];
                        tuv[3] = uv[3];
                        tuv[4] = uv[4];
                        tuv[5] = uvb;
                        tuv[6] = uv[6];
                        tuv[7] = uvb;
                        this._inner_drawTexture(tex, imgid, x, sty, oriw, left, this._curMat, tuv, 1, false);
                    }
                }
            }, {
                key: "drawTextureWithSizeGrid",
                value: function drawTextureWithSizeGrid(tex, tx, ty, width, height, sizeGrid, gx, gy) {
                    if (!tex._getSource())
                        return;
                    tx += gx;
                    ty += gy;
                    var uv = tex.uv
                        , w = tex.bitmap.width
                        , h = tex.bitmap.height;
                    var top = sizeGrid[0];
                    var left = sizeGrid[3];
                    var right = sizeGrid[1];
                    var bottom = sizeGrid[2];
                    var repeat = sizeGrid[4];
                    var needClip = false;
                    if (width == w) {
                        left = right = 0;
                    }
                    if (height == h) {
                        top = bottom = 0;
                    }
                    var d_top = top / h;
                    var d_left = left / w;
                    var d_right = right / w;
                    var d_bottom = bottom / h;
                    if (left + right > width) {
                        var clipWidth = width;
                        needClip = true;
                        width = left + right;
                        this.save();
                        this.clipRect(0 + tx, 0 + ty, clipWidth, height);
                    }
                    var imgid = tex.bitmap.id;
                    var mat = this._curMat;
                    var tuv = this._tempUV;
                    var uvl = uv[0];
                    var uvt = uv[1];
                    var uvr = uv[4];
                    var uvb = uv[5];
                    var uvl_ = uvl;
                    var uvt_ = uvt;
                    var uvr_ = uvr;
                    var uvb_ = uvb;
                    if (left && top) {
                        uvr_ = uvl + d_left;
                        uvb_ = uvt + d_top;
                        tuv[0] = uvl,
                            tuv[1] = uvt,
                            tuv[2] = uvr_,
                            tuv[3] = uvt,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl,
                            tuv[7] = uvb_;
                        this._inner_drawTexture(tex, imgid, tx, ty, left, top, mat, tuv, 1, false);
                    }
                    if (right && top) {
                        uvl_ = uvr - d_right;
                        uvt_ = uvt;
                        uvr_ = uvr;
                        uvb_ = uvt + d_top;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        this._inner_drawTexture(tex, imgid, width - right + tx, 0 + ty, right, top, mat, tuv, 1, false);
                    }
                    if (left && bottom) {
                        uvl_ = uvl;
                        uvt_ = uvb - d_bottom;
                        uvr_ = uvl + d_left;
                        uvb_ = uvb;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        this._inner_drawTexture(tex, imgid, 0 + tx, height - bottom + ty, left, bottom, mat, tuv, 1, false);
                    }
                    if (right && bottom) {
                        uvl_ = uvr - d_right;
                        uvt_ = uvb - d_bottom;
                        uvr_ = uvr;
                        uvb_ = uvb;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        this._inner_drawTexture(tex, imgid, width - right + tx, height - bottom + ty, right, bottom, mat, tuv, 1, false);
                    }
                    if (top) {
                        uvl_ = uvl + d_left;
                        uvt_ = uvt;
                        uvr_ = uvr - d_right;
                        uvb_ = uvt + d_top;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        if (repeat) {
                            this._fillTexture_h(tex, imgid, tuv, tex.width - left - right, top, left + tx, ty, width - left - right);
                        } else {
                            this._inner_drawTexture(tex, imgid, left + tx, ty, width - left - right, top, mat, tuv, 1, false);
                        }
                    }
                    if (bottom) {
                        uvl_ = uvl + d_left;
                        uvt_ = uvb - d_bottom;
                        uvr_ = uvr - d_right;
                        uvb_ = uvb;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        if (repeat) {
                            this._fillTexture_h(tex, imgid, tuv, tex.width - left - right, bottom, left + tx, height - bottom + ty, width - left - right);
                        } else {
                            this._inner_drawTexture(tex, imgid, left + tx, height - bottom + ty, width - left - right, bottom, mat, tuv, 1, false);
                        }
                    }
                    if (left) {
                        uvl_ = uvl;
                        uvt_ = uvt + d_top;
                        uvr_ = uvl + d_left;
                        uvb_ = uvb - d_bottom;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        if (repeat) {
                            this._fillTexture_v(tex, imgid, tuv, left, tex.height - top - bottom, tx, top + ty, height - top - bottom);
                        } else {
                            this._inner_drawTexture(tex, imgid, tx, top + ty, left, height - top - bottom, mat, tuv, 1, false);
                        }
                    }
                    if (right) {
                        uvl_ = uvr - d_right;
                        uvt_ = uvt + d_top;
                        uvr_ = uvr;
                        uvb_ = uvb - d_bottom;
                        tuv[0] = uvl_,
                            tuv[1] = uvt_,
                            tuv[2] = uvr_,
                            tuv[3] = uvt_,
                            tuv[4] = uvr_,
                            tuv[5] = uvb_,
                            tuv[6] = uvl_,
                            tuv[7] = uvb_;
                        if (repeat) {
                            this._fillTexture_v(tex, imgid, tuv, right, tex.height - top - bottom, width - right + tx, top + ty, height - top - bottom);
                        } else {
                            this._inner_drawTexture(tex, imgid, width - right + tx, top + ty, right, height - top - bottom, mat, tuv, 1, false);
                        }
                    }
                    uvl_ = uvl + d_left;
                    uvt_ = uvt + d_top;
                    uvr_ = uvr - d_right;
                    uvb_ = uvb - d_bottom;
                    tuv[0] = uvl_,
                        tuv[1] = uvt_,
                        tuv[2] = uvr_,
                        tuv[3] = uvt_,
                        tuv[4] = uvr_,
                        tuv[5] = uvb_,
                        tuv[6] = uvl_,
                        tuv[7] = uvb_;
                    if (repeat) {
                        var tuvr = Context.tmpUVRect;
                        tuvr[0] = uvl_;
                        tuvr[1] = uvt_;
                        tuvr[2] = uvr_ - uvl_;
                        tuvr[3] = uvb_ - uvt_;
                        this._fillTexture(tex, tex.width - left - right, tex.height - top - bottom, tuvr, left + tx, top + ty, width - left - right, height - top - bottom, 'repeat', 0, 0);
                    } else {
                        this._inner_drawTexture(tex, imgid, left + tx, top + ty, width - left - right, height - top - bottom, mat, tuv, 1, false);
                    }
                    if (needClip)
                        this.restore();
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    Context.MAXCLIPRECT = new Rectangle(0, 0, Context._MAXSIZE, Context._MAXSIZE);
                    ContextParams.DEFAULT = new ContextParams();
                }
            }, {
                key: "set2DRenderConfig",
                value: function set2DRenderConfig() {
                    var gl = LayaGL.instance;
                    WebGLContext.setBlend(gl, true);
                    WebGLContext.setBlendEquation(gl, gl.FUNC_ADD);
                    BlendMode.activeBlendFunction = null;
                    WebGLContext.setBlendFunc(gl, gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
                    WebGLContext.setDepthTest(gl, false);
                    WebGLContext.setCullFace(gl, false);
                    WebGLContext.setDepthMask(gl, true);
                    WebGLContext.setFrontFace(gl, gl.CCW);
                    gl.viewport(0, 0, RenderState2D.width, RenderState2D.height);
                }
            }]);
            return Context;
        }();
    Context.ENUM_TEXTALIGN_DEFAULT = 0;
    Context.ENUM_TEXTALIGN_CENTER = 1;
    Context.ENUM_TEXTALIGN_RIGHT = 2;
    Context._SUBMITVBSIZE = 32000;
    Context._MAXSIZE = 99999999;
    Context._MAXVERTNUM = 65535;
    Context.MAXCLIPRECT = null;
    Context._COUNT = 0;
    Context.SEGNUM = 32;
    Context._contextcount = 0;
    Context.PI2 = 2 * Math.PI;
    Context._textRender = null;
    Context.tmpuv1 = [0, 0, 0, 0, 0, 0, 0, 0];
    Context.tmpUV = [0, 0, 0, 0, 0, 0, 0, 0];
    Context.tmpUVRect = [0, 0, 0, 0];
    var ContextParams = /*#__PURE__*/
        function () {
            function ContextParams() {
                _classCallCheck(this, ContextParams);
                this.lineWidth = 1;
            }
            _createClass(ContextParams, [{
                key: "clear",
                value: function clear() {
                    this.lineWidth = 1;
                    this.textAlign = this.textBaseline = null;
                }
            }, {
                key: "make",
                value: function make() {
                    return this === ContextParams.DEFAULT ? new ContextParams() : this;
                }
            }]);
            return ContextParams;
        }();
    var WebGL = /*#__PURE__*/
        function () {
            function WebGL() {
                _classCallCheck(this, WebGL);
            }
            _createClass(WebGL, null, [{
                key: "_uint8ArraySlice",
                value: function _uint8ArraySlice() {
                    var _this = this;
                    var sz = _this.length;
                    var dec = new Uint8Array(_this.length);
                    for (var i = 0; i < sz; i++) {
                        dec[i] = _this[i];
                    }
                    return dec;
                }
            }, {
                key: "_float32ArraySlice",
                value: function _float32ArraySlice() {
                    var _this = this;
                    var sz = _this.length;
                    var dec = new Float32Array(_this.length);
                    for (var i = 0; i < sz; i++) {
                        dec[i] = _this[i];
                    }
                    return dec;
                }
            }, {
                key: "_uint16ArraySlice",
                value: function _uint16ArraySlice() {
                    var _this = this;
                    var sz;
                    var dec;
                    var i;
                    if (arguments.length === 0) {
                        sz = _this.length;
                        dec = new Uint16Array(sz);
                        for (i = 0; i < sz; i++) {
                            dec[i] = _this[i];
                        }
                    } else if (arguments.length === 2) {
                        var start = arguments.length <= 0 ? undefined : arguments[0];
                        var end = arguments.length <= 1 ? undefined : arguments[1];
                        if (end > start) {
                            sz = end - start;
                            dec = new Uint16Array(sz);
                            for (i = start; i < end; i++) {
                                dec[i - start] = _this[i];
                            }
                        } else {
                            dec = new Uint16Array(0);
                        }
                    }
                    return dec;
                }
            }, {
                key: "_nativeRender_enable",
                value: function _nativeRender_enable() { }
            }, {
                key: "enable",
                value: function enable() {
                    return true;
                }
            }, {
                key: "inner_enable",
                value: function inner_enable() {
                    Float32Array.prototype.slice || (Float32Array.prototype.slice = WebGL._float32ArraySlice);
                    Uint16Array.prototype.slice || (Uint16Array.prototype.slice = WebGL._uint16ArraySlice);
                    Uint8Array.prototype.slice || (Uint8Array.prototype.slice = WebGL._uint8ArraySlice);
                    return true;
                }
            }, {
                key: "onStageResize",
                value: function onStageResize(width, height) {
                    if (WebGLContext.mainContext == null)
                        return;
                    WebGLContext.mainContext.viewport(0, 0, width, height);
                    RenderState2D.width = width;
                    RenderState2D.height = height;
                }
            }]);
            return WebGL;
        }();
    WebGL._isWebGL2 = false;
    WebGL.isNativeRender_enable = false;
    var VertexArrayObject = /*#__PURE__*/
        _createClass(function VertexArrayObject() {
            _classCallCheck(this, VertexArrayObject);
        });
    (function () {
        var glErrorShadow = {};
        function error(msg) {
            if (window.console && window.console.error) {
                window.console.error(msg);
            }
        }
        function log(msg) {
            if (window.console && window.console.log) {
                window.console.log(msg);
            }
        }
        function synthesizeGLError(err, opt_msg) {
            glErrorShadow[err] = true;
            if (opt_msg !== undefined) {
                error(opt_msg);
            }
        }
        function wrapGLError(gl) {
            var f = gl.getError;
            gl.getError = function () {
                var err;
                do {
                    err = f.apply(gl);
                    if (err != gl.NO_ERROR) {
                        glErrorShadow[err] = true;
                    }
                } while (err != gl.NO_ERROR);
                for (var err1 in glErrorShadow) {
                    if (glErrorShadow[err1]) {
                        delete glErrorShadow[err1];
                        return parseInt(err1);
                    }
                }
                return gl.NO_ERROR;
            }
                ;
        }
        var WebGLVertexArrayObjectOES = function WebGLVertexArrayObjectOES(ext) {
            var gl = ext.gl;
            this.ext = ext;
            this.isAlive = true;
            this.hasBeenBound = false;
            this.elementArrayBuffer = null;
            this.attribs = new Array(ext.maxVertexAttribs);
            for (var n = 0; n < this.attribs.length; n++) {
                var attrib = new WebGLVertexArrayObjectOES.VertexAttrib(gl);
                this.attribs[n] = attrib;
            }
            this.maxAttrib = 0;
        };
        WebGLVertexArrayObjectOES.VertexAttrib = function VertexAttrib(gl) {
            this.enabled = false;
            this.buffer = null;
            this.size = 4;
            this.type = gl.FLOAT;
            this.normalized = false;
            this.stride = 16;
            this.offset = 0;
            this.cached = "";
            this.recache();
        }
            ;
        WebGLVertexArrayObjectOES.VertexAttrib.prototype.recache = function recache() {
            this.cached = [this.size, this.type, this.normalized, this.stride, this.offset].join(":");
        }
            ;
        var OESVertexArrayObject = function OESVertexArrayObject(gl) {
            var self = this;
            this.gl = gl;
            wrapGLError(gl);
            var original = this.original = {
                getParameter: gl.getParameter,
                enableVertexAttribArray: gl.enableVertexAttribArray,
                disableVertexAttribArray: gl.disableVertexAttribArray,
                bindBuffer: gl.bindBuffer,
                getVertexAttrib: gl.getVertexAttrib,
                vertexAttribPointer: gl.vertexAttribPointer
            };
            gl.getParameter = function getParameter(pname) {
                if (pname == self.VERTEX_ARRAY_BINDING_OES) {
                    if (self.currentVertexArrayObject == self.defaultVertexArrayObject) {
                        return null;
                    } else {
                        return self.currentVertexArrayObject;
                    }
                }
                return original.getParameter.apply(this, arguments);
            }
                ;
            gl.enableVertexAttribArray = function enableVertexAttribArray(index) {
                var vao = self.currentVertexArrayObject;
                vao.maxAttrib = Math.max(vao.maxAttrib, index);
                var attrib = vao.attribs[index];
                attrib.enabled = true;
                return original.enableVertexAttribArray.apply(this, arguments);
            }
                ;
            gl.disableVertexAttribArray = function disableVertexAttribArray(index) {
                var vao = self.currentVertexArrayObject;
                vao.maxAttrib = Math.max(vao.maxAttrib, index);
                var attrib = vao.attribs[index];
                attrib.enabled = false;
                return original.disableVertexAttribArray.apply(this, arguments);
            }
                ;
            gl.bindBuffer = function bindBuffer(target, buffer) {
                switch (target) {
                    case gl.ARRAY_BUFFER:
                        self.currentArrayBuffer = buffer;
                        break;
                    case gl.ELEMENT_ARRAY_BUFFER:
                        self.currentVertexArrayObject.elementArrayBuffer = buffer;
                        break;
                }
                return original.bindBuffer.apply(this, arguments);
            }
                ;
            gl.getVertexAttrib = function getVertexAttrib(index, pname) {
                var vao = self.currentVertexArrayObject;
                var attrib = vao.attribs[index];
                switch (pname) {
                    case gl.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:
                        return attrib.buffer;
                    case gl.VERTEX_ATTRIB_ARRAY_ENABLED:
                        return attrib.enabled;
                    case gl.VERTEX_ATTRIB_ARRAY_SIZE:
                        return attrib.size;
                    case gl.VERTEX_ATTRIB_ARRAY_STRIDE:
                        return attrib.stride;
                    case gl.VERTEX_ATTRIB_ARRAY_TYPE:
                        return attrib.type;
                    case gl.VERTEX_ATTRIB_ARRAY_NORMALIZED:
                        return attrib.normalized;
                    default:
                        return original.getVertexAttrib.apply(this, arguments);
                }
            }
                ;
            gl.vertexAttribPointer = function vertexAttribPointer(indx, size, type, normalized, stride, offset) {
                var vao = self.currentVertexArrayObject;
                vao.maxAttrib = Math.max(vao.maxAttrib, indx);
                var attrib = vao.attribs[indx];
                attrib.buffer = self.currentArrayBuffer;
                attrib.size = size;
                attrib.type = type;
                attrib.normalized = normalized;
                attrib.stride = stride;
                attrib.offset = offset;
                attrib.recache();
                return original.vertexAttribPointer.apply(this, arguments);
            }
                ;
            if (gl.instrumentExtension) {
                gl.instrumentExtension(this, "OES_vertex_array_object");
            }
            gl.canvas.addEventListener('webglcontextrestored', function () {
                log("OESVertexArrayObject emulation library context restored");
                self.reset_();
            }, true);
            this.reset_();
        };
        OESVertexArrayObject.prototype.VERTEX_ARRAY_BINDING_OES = 0x85B5;
        OESVertexArrayObject.prototype.reset_ = function reset_() {
            var contextWasLost = this.vertexArrayObjects !== undefined;
            if (contextWasLost) {
                for (var ii = 0; ii < this.vertexArrayObjects.length; ++ii) {
                    this.vertexArrayObjects.isAlive = false;
                }
            }
            var gl = this.gl;
            this.maxVertexAttribs = gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
            this.defaultVertexArrayObject = new WebGLVertexArrayObjectOES(this);
            this.currentVertexArrayObject = null;
            this.currentArrayBuffer = null;
            this.vertexArrayObjects = [this.defaultVertexArrayObject];
            this.bindVertexArrayOES(null);
        }
            ;
        OESVertexArrayObject.prototype.createVertexArrayOES = function createVertexArrayOES() {
            var arrayObject = new WebGLVertexArrayObjectOES(this);
            this.vertexArrayObjects.push(arrayObject);
            return arrayObject;
        }
            ;
        OESVertexArrayObject.prototype.deleteVertexArrayOES = function deleteVertexArrayOES(arrayObject) {
            arrayObject.isAlive = false;
            this.vertexArrayObjects.splice(this.vertexArrayObjects.indexOf(arrayObject), 1);
            if (this.currentVertexArrayObject == arrayObject) {
                this.bindVertexArrayOES(null);
            }
        }
            ;
        OESVertexArrayObject.prototype.isVertexArrayOES = function isVertexArrayOES(arrayObject) {
            if (arrayObject && arrayObject instanceof WebGLVertexArrayObjectOES) {
                if (arrayObject.hasBeenBound && arrayObject.ext == this) {
                    return true;
                }
            }
            return false;
        }
            ;
        OESVertexArrayObject.prototype.bindVertexArrayOES = function bindVertexArrayOES(arrayObject) {
            var gl = this.gl;
            if (arrayObject && !arrayObject.isAlive) {
                synthesizeGLError(gl.INVALID_OPERATION, "bindVertexArrayOES: attempt to bind deleted arrayObject");
                return;
            }
            var original = this.original;
            var oldVAO = this.currentVertexArrayObject;
            this.currentVertexArrayObject = arrayObject || this.defaultVertexArrayObject;
            this.currentVertexArrayObject.hasBeenBound = true;
            var newVAO = this.currentVertexArrayObject;
            if (oldVAO == newVAO) {
                return;
            }
            if (!oldVAO || newVAO.elementArrayBuffer != oldVAO.elementArrayBuffer) {
                original.bindBuffer.call(gl, gl.ELEMENT_ARRAY_BUFFER, newVAO.elementArrayBuffer);
            }
            var currentBinding = this.currentArrayBuffer;
            var maxAttrib = Math.max(oldVAO ? oldVAO.maxAttrib : 0, newVAO.maxAttrib);
            for (var n = 0; n <= maxAttrib; n++) {
                var attrib = newVAO.attribs[n];
                var oldAttrib = oldVAO ? oldVAO.attribs[n] : null;
                if (!oldVAO || attrib.enabled != oldAttrib.enabled) {
                    if (attrib.enabled) {
                        original.enableVertexAttribArray.call(gl, n);
                    } else {
                        original.disableVertexAttribArray.call(gl, n);
                    }
                }
                if (attrib.enabled) {
                    var bufferChanged = false;
                    if (!oldVAO || attrib.buffer != oldAttrib.buffer) {
                        if (currentBinding != attrib.buffer) {
                            original.bindBuffer.call(gl, gl.ARRAY_BUFFER, attrib.buffer);
                            currentBinding = attrib.buffer;
                        }
                        bufferChanged = true;
                    }
                    if (bufferChanged || attrib.cached != oldAttrib.cached) {
                        original.vertexAttribPointer.call(gl, n, attrib.size, attrib.type, attrib.normalized, attrib.stride, attrib.offset);
                    }
                }
            }
            if (this.currentArrayBuffer != currentBinding) {
                original.bindBuffer.call(gl, gl.ARRAY_BUFFER, this.currentArrayBuffer);
            }
        }
            ;
        window._setupVertexArrayObject = function (gl) {
            var original_getSupportedExtensions = gl.getSupportedExtensions;
            gl.getSupportedExtensions = function getSupportedExtensions() {
                var list = original_getSupportedExtensions.call(this) || [];
                if (list.indexOf("OES_vertex_array_object") < 0) {
                    list.push("OES_vertex_array_object");
                }
                return list;
            }
                ;
            var original_getExtension = gl.getExtension;
            gl.getExtension = function getExtension(name) {
                var ext = original_getExtension.call(this, name);
                if (ext) {
                    return ext;
                }
                if (name !== "OES_vertex_array_object") {
                    return null;
                }
                if (!this.__OESVertexArrayObject) {
                    console.log("Setup OES_vertex_array_object polyfill");
                    this.__OESVertexArrayObject = new OESVertexArrayObject(this);
                }
                return this.__OESVertexArrayObject;
            }
                ;
        }
            ;
    }
    )();
    var SystemUtils = /*#__PURE__*/
        function () {
            function SystemUtils() {
                _classCallCheck(this, SystemUtils);
            }
            _createClass(SystemUtils, null, [{
                key: "maxTextureCount",
                get: function get() {
                    return this._maxTextureCount;
                }
            }, {
                key: "maxTextureSize",
                get: function get() {
                    return this._maxTextureSize;
                }
            }, {
                key: "shaderCapailityLevel",
                get: function get() {
                    return this._shaderCapailityLevel;
                }
            }, {
                key: "supportTextureFormat",
                value: function supportTextureFormat(format) {
                    switch (format) {
                        case exports.TextureFormat.R32G32B32A32:
                            return !LayaGL.layaGPUInstance._isWebGL2 && !LayaGL.layaGPUInstance._oesTextureFloat ? false : true;
                        default:
                            return true;
                    }
                }
            }, {
                key: "supportRenderTextureFormat",
                value: function supportRenderTextureFormat(format) {
                    switch (format) {
                        case exports.RenderTextureFormat.R16G16B16A16:
                            return LayaGL.layaGPUInstance._isWebGL2 || LayaGL.layaGPUInstance._oesTextureHalfFloat && LayaGL.layaGPUInstance._oesTextureHalfFloatLinear ? true : false;
                        case exports.RenderTextureFormat.Depth:
                            return LayaGL.layaGPUInstance._isWebGL2 || LayaGL.layaGPUInstance._webgl_depth_texture ? true : false;
                        case exports.RenderTextureFormat.ShadowMap:
                            return LayaGL.layaGPUInstance._isWebGL2 ? true : false;
                        default:
                            return true;
                    }
                }
            }]);
            return SystemUtils;
        }();
    var LayaGPU = /*#__PURE__*/
        function () {
            function LayaGPU(gl, isWebGL2) {
                _classCallCheck(this, LayaGPU);
                this._gl = null;
                this._vaoExt = null;
                this._angleInstancedArrays = null;
                this._isWebGL2 = false;
                this._oesTextureHalfFloat = null;
                this._oes_element_index_uint = null;
                this._oesTextureHalfFloatLinear = null;
                this._oesTextureFloat = null;
                this._extShaderTextureLod = null;
                this._extTextureFilterAnisotropic = null;
                this._compressedTextureS3tc = null;
                this._compressedTexturePvrtc = null;
                this._compressedTextureEtc1 = null;
                this._webgl_depth_texture = null;
                this._gl = gl;
                this._isWebGL2 = isWebGL2;
                var maxTextureFS = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
                var maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
                if (!isWebGL2) {
                    if (!ILaya.Render.isConchApp) {
                        if (window._setupVertexArrayObject)
                            window._setupVertexArrayObject(gl);
                    }
                    this._vaoExt = this._getExtension("OES_vertex_array_object");
                    this._angleInstancedArrays = this._getExtension("ANGLE_instanced_arrays");
                    this._oesTextureHalfFloat = this._getExtension("OES_texture_half_float");
                    this._oesTextureHalfFloatLinear = this._getExtension("OES_texture_half_float_linear");
                    this._oesTextureFloat = this._getExtension("OES_texture_float");
                    this._oes_element_index_uint = this._getExtension("OES_element_index_uint");
                    this._extShaderTextureLod = this._getExtension("EXT_shader_texture_lod");
                    this._webgl_depth_texture = this._getExtension("WEBGL_depth_texture");
                    SystemUtils._shaderCapailityLevel = 30;
                } else {
                    this._getExtension("EXT_color_buffer_float");
                    SystemUtils._shaderCapailityLevel = 35;
                }
                this._extTextureFilterAnisotropic = this._getExtension("EXT_texture_filter_anisotropic");
                this._compressedTextureS3tc = this._getExtension("WEBGL_compressed_texture_s3tc");
                this._compressedTexturePvrtc = this._getExtension("WEBGL_compressed_texture_pvrtc");
                this._compressedTextureEtc1 = this._getExtension("WEBGL_compressed_texture_etc1");
                SystemUtils._maxTextureCount = maxTextureFS;
                SystemUtils._maxTextureSize = maxTextureSize;
            }
            _createClass(LayaGPU, [{
                key: "_getExtension",
                value: function _getExtension(name) {
                    var prefixes = LayaGPU._extentionVendorPrefixes;
                    for (var k in prefixes) {
                        var ext = this._gl.getExtension(prefixes[k] + name);
                        if (ext)
                            return ext;
                    }
                    return null;
                }
            }, {
                key: "createVertexArray",
                value: function createVertexArray() {
                    if (this._isWebGL2)
                        return this._gl.createVertexArray();
                    else
                        return this._vaoExt.createVertexArrayOES();
                }
            }, {
                key: "bindVertexArray",
                value: function bindVertexArray(vertexArray) {
                    if (this._isWebGL2)
                        this._gl.bindVertexArray(vertexArray);
                    else
                        this._vaoExt.bindVertexArrayOES(vertexArray);
                }
            }, {
                key: "deleteVertexArray",
                value: function deleteVertexArray(vertexArray) {
                    if (this._isWebGL2)
                        this._gl.deleteVertexArray(vertexArray);
                    else
                        this._vaoExt.deleteVertexArrayOES(vertexArray);
                }
            }, {
                key: "isVertexArray",
                value: function isVertexArray(vertexArray) {
                    if (this._isWebGL2)
                        this._gl.isVertexArray(vertexArray);
                    else
                        this._vaoExt.isVertexArrayOES(vertexArray);
                }
            }, {
                key: "drawElementsInstanced",
                value: function drawElementsInstanced(mode, count, type, offset, instanceCount) {
                    if (this._isWebGL2)
                        this._gl.drawElementsInstanced(mode, count, type, offset, instanceCount);
                    else
                        this._angleInstancedArrays.drawElementsInstancedANGLE(mode, count, type, offset, instanceCount);
                }
            }, {
                key: "drawArraysInstanced",
                value: function drawArraysInstanced(mode, first, count, instanceCount) {
                    if (this._isWebGL2)
                        this._gl.drawArraysInstanced(mode, first, count, instanceCount);
                    else
                        this._angleInstancedArrays.drawArraysInstancedANGLE(mode, first, count, instanceCount);
                }
            }, {
                key: "vertexAttribDivisor",
                value: function vertexAttribDivisor(index, divisor) {
                    if (this._isWebGL2)
                        this._gl.vertexAttribDivisor(index, divisor);
                    else
                        this._angleInstancedArrays.vertexAttribDivisorANGLE(index, divisor);
                }
            }, {
                key: "supportInstance",
                value: function supportInstance() {
                    if ((this._isWebGL2 || this._angleInstancedArrays) && Config.allowGPUInstanceDynamicBatch)
                        return true;
                    else
                        return false;
                }
            }, {
                key: "supportElementIndexUint32",
                value: function supportElementIndexUint32() {
                    return this._isWebGL2 || this._oes_element_index_uint ? true : false;
                }
            }]);
            return LayaGPU;
        }();
    LayaGPU._extentionVendorPrefixes = ["", "WEBKIT_", "MOZ_"];
    var Render = /*#__PURE__*/
        function () {
            function Render(width, height, mainCanv) {
                _classCallCheck(this, Render);
                this._timeId = 0;
                Render._mainCanvas = mainCanv;
                var source = Render._mainCanvas.source;
                source.id = "layaCanvas";
                source.width = width;
                source.height = height;
                if (Render.isConchApp) {
                    document.body.appendChild(source);
                }
                this.initRender(Render._mainCanvas, width, height);
                window.requestAnimationFrame(loop);
                function loop(stamp) {
                    ILaya.stage._loop();
                    window.requestAnimationFrame(loop);
                }
                ILaya.stage.on("visibilitychange", this, this._onVisibilitychange);
            }
            _createClass(Render, [{
                key: "_onVisibilitychange",
                value: function _onVisibilitychange() {
                    if (!ILaya.stage.isVisibility) {
                        this._timeId = window.setInterval(this._enterFrame, 1000);
                    } else if (this._timeId != 0) {
                        window.clearInterval(this._timeId);
                    }
                }
            }, {
                key: "initRender",
                value: function initRender(canvas, w, h) {
                    function getWebGLContext(canvas) {
                        var gl;
                        var names = ["webgl2", "webgl", "experimental-webgl", "webkit-3d", "moz-webgl"];
                        if (!Config.useWebGL2 || Browser.onBDMiniGame) {
                            names.shift();
                        }
                        for (var i = 0; i < names.length; i++) {
                            try {
                                gl = canvas.getContext(names[i], {
                                    stencil: Config.isStencil,
                                    alpha: Config.isAlpha,
                                    antialias: Config.isAntialias,
                                    premultipliedAlpha: Config.premultipliedAlpha,
                                    preserveDrawingBuffer: Config.preserveDrawingBuffer
                                });
                            } catch (e) { }
                            if (gl) {
                                names[i] === 'webgl2' && (WebGL._isWebGL2 = true);
                                return gl;
                            }
                        }
                        return null;
                    }
                    var gl = LayaGL.instance = WebGLContext.mainContext = getWebGLContext(Render._mainCanvas.source);
                    if (!gl)
                        return false;
                    LayaGL.instance = gl;
                    LayaGL.layaGPUInstance = new LayaGPU(gl, WebGL._isWebGL2);
                    canvas.size(w, h);
                    Context.__init__();
                    SubmitBase.__init__();
                    var ctx = new Context();
                    ctx.isMain = true;
                    Render._context = ctx;
                    canvas._setContext(ctx);
                    ShaderDefines2D.__init__();
                    Value2D.__init__();
                    Shader2D.__init__();
                    Buffer2D.__int__(gl);
                    BlendMode._init_(gl);
                    return true;
                }
            }, {
                key: "_enterFrame",
                value: function _enterFrame() {
                    var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    ILaya.stage._loop();
                }
            }], [{
                key: "context",
                get: function get() {
                    return Render._context;
                }
            }, {
                key: "canvas",
                get: function get() {
                    return Render._mainCanvas.source;
                }
            }]);
            return Render;
        }();
    Render.supportWebGLPlusCulling = false;
    Render.supportWebGLPlusAnimation = false;
    Render.supportWebGLPlusRendering = false;
    Render.isConchApp = false;
    {
        Render.isConchApp = window.conch != null;
        if (Render.isConchApp) {
            Render.supportWebGLPlusCulling = false;
            Render.supportWebGLPlusAnimation = false;
            Render.supportWebGLPlusRendering = false;
        } else if (window.qq != null && window.qq.webglPlus != null) {
            Render.supportWebGLPlusCulling = false;
            Render.supportWebGLPlusAnimation = false;
            Render.supportWebGLPlusRendering = false;
        }
    }
    var DrawTrianglesCmd = /*#__PURE__*/
        function () {
            function DrawTrianglesCmd() {
                _classCallCheck(this, DrawTrianglesCmd);
            }
            _createClass(DrawTrianglesCmd, [{
                key: "recover",
                value: function recover() {
                    this.texture = null;
                    this.vertices = null;
                    this.uvs = null;
                    this.indices = null;
                    this.matrix = null;
                    Pool.recover("DrawTrianglesCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.drawTriangles(this.texture, this.x + gx, this.y + gy, this.vertices, this.uvs, this.indices, this.matrix, this.alpha, this.color, this.blendMode, this.colorNum);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawTrianglesCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, x, y, vertices, uvs, indices, matrix, alpha, color, blendMode, colorNum) {
                    var cmd = Pool.getItemByClass("DrawTrianglesCmd", DrawTrianglesCmd);
                    cmd.texture = texture;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.vertices = vertices;
                    cmd.uvs = uvs;
                    cmd.indices = indices;
                    cmd.matrix = matrix;
                    cmd.alpha = alpha;
                    if (color) {
                        cmd.color = new ColorFilter();
                        var c = ColorUtils.create(color).arrColor;
                        cmd.color.color(c[0] * 255, c[1] * 255, c[2] * 255, c[3] * 255);
                    }
                    cmd.blendMode = blendMode;
                    cmd.colorNum = colorNum;
                    return cmd;
                }
            }]);
            return DrawTrianglesCmd;
        }();
    DrawTrianglesCmd.ID = "DrawTriangles";
    var Draw9GridTexture = /*#__PURE__*/
        function () {
            function Draw9GridTexture() {
                _classCallCheck(this, Draw9GridTexture);
            }
            _createClass(Draw9GridTexture, [{
                key: "recover",
                value: function recover() {
                    this.texture._removeReference();
                    Pool.recover("Draw9GridTexture", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.drawTextureWithSizeGrid(this.texture, this.x, this.y, this.width, this.height, this.sizeGrid, gx, gy);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return Draw9GridTexture.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, x, y, width, height, sizeGrid) {
                    var cmd = Pool.getItemByClass("Draw9GridTexture", Draw9GridTexture);
                    cmd.texture = texture;
                    texture._addReference();
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    cmd.sizeGrid = sizeGrid;
                    return cmd;
                }
            }]);
            return Draw9GridTexture;
        }();
    Draw9GridTexture.ID = "Draw9GridTexture";
    var GraphicsBounds = /*#__PURE__*/
        function () {
            function GraphicsBounds() {
                _classCallCheck(this, GraphicsBounds);
                this._cacheBoundsType = false;
            }
            _createClass(GraphicsBounds, [{
                key: "destroy",
                value: function destroy() {
                    this._graphics = null;
                    this._cacheBoundsType = false;
                    if (this._temp)
                        this._temp.length = 0;
                    if (this._rstBoundPoints)
                        this._rstBoundPoints.length = 0;
                    if (this._bounds)
                        this._bounds.recover();
                    this._bounds = null;
                    Pool.recover("GraphicsBounds", this);
                }
            }, {
                key: "reset",
                value: function reset() {
                    this._temp && (this._temp.length = 0);
                }
            }, {
                key: "getBounds",
                value: function getBounds() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (!this._bounds || !this._temp || this._temp.length < 1 || realSize != this._cacheBoundsType) {
                        this._bounds = Rectangle._getWrapRec(this.getBoundPoints(realSize), this._bounds);
                    }
                    this._cacheBoundsType = realSize;
                    return this._bounds;
                }
            }, {
                key: "getBoundPoints",
                value: function getBoundPoints() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (!this._temp || this._temp.length < 1 || realSize != this._cacheBoundsType)
                        this._temp = this._getCmdPoints(realSize);
                    this._cacheBoundsType = realSize;
                    return this._rstBoundPoints = Utils.copyArray(this._rstBoundPoints, this._temp);
                }
            }, {
                key: "_getCmdPoints",
                value: function _getCmdPoints() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    var cmds = this._graphics.cmds;
                    var rst;
                    rst = this._temp || (this._temp = []);
                    rst.length = 0;
                    if (!cmds && this._graphics._one != null) {
                        GraphicsBounds._tempCmds.length = 0;
                        GraphicsBounds._tempCmds.push(this._graphics._one);
                        cmds = GraphicsBounds._tempCmds;
                    }
                    if (!cmds)
                        return rst;
                    var matrixs = GraphicsBounds._tempMatrixArrays;
                    matrixs.length = 0;
                    var tMatrix = GraphicsBounds._initMatrix;
                    tMatrix.identity();
                    var tempMatrix = GraphicsBounds._tempMatrix;
                    var cmd;
                    var tex;
                    for (var i = 0, n = cmds.length; i < n; i++) {
                        cmd = cmds[i];
                        switch (cmd.cmdID) {
                            case AlphaCmd.ID:
                                matrixs.push(tMatrix);
                                tMatrix = tMatrix.clone();
                                break;
                            case RestoreCmd.ID:
                                tMatrix = matrixs.pop();
                                break;
                            case ScaleCmd.ID:
                                tempMatrix.identity();
                                tempMatrix.translate(-cmd.pivotX, -cmd.pivotY);
                                tempMatrix.scale(cmd.scaleX, cmd.scaleY);
                                tempMatrix.translate(cmd.pivotX, cmd.pivotY);
                                this._switchMatrix(tMatrix, tempMatrix);
                                break;
                            case RotateCmd.ID:
                                tempMatrix.identity();
                                tempMatrix.translate(-cmd.pivotX, -cmd.pivotY);
                                tempMatrix.rotate(cmd.angle);
                                tempMatrix.translate(cmd.pivotX, cmd.pivotY);
                                this._switchMatrix(tMatrix, tempMatrix);
                                break;
                            case TranslateCmd.ID:
                                tempMatrix.identity();
                                tempMatrix.translate(cmd.tx, cmd.ty);
                                this._switchMatrix(tMatrix, tempMatrix);
                                break;
                            case TransformCmd.ID:
                                tempMatrix.identity();
                                tempMatrix.translate(-cmd.pivotX, -cmd.pivotY);
                                tempMatrix.concat(cmd.matrix);
                                tempMatrix.translate(cmd.pivotX, cmd.pivotY);
                                this._switchMatrix(tMatrix, tempMatrix);
                                break;
                            case DrawImageCmd.ID:
                            case FillTextureCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), tMatrix);
                                break;
                            case DrawTextureCmd.ID:
                                tMatrix.copyTo(tempMatrix);
                                if (cmd.matrix)
                                    tempMatrix.concat(cmd.matrix);
                                GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), tempMatrix);
                                break;
                            case DrawImageCmd.ID:
                                tex = cmd.texture;
                                if (realSize) {
                                    if (cmd.width && cmd.height) {
                                        GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), tMatrix);
                                    } else {
                                        GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, tex.width, tex.height), tMatrix);
                                    }
                                } else {
                                    var wRate = (cmd.width || tex.sourceWidth) / tex.width;
                                    var hRate = (cmd.height || tex.sourceHeight) / tex.height;
                                    var oWidth = wRate * tex.sourceWidth;
                                    var oHeight = hRate * tex.sourceHeight;
                                    var offX = tex.offsetX > 0 ? tex.offsetX : 0;
                                    var offY = tex.offsetY > 0 ? tex.offsetY : 0;
                                    offX *= wRate;
                                    offY *= hRate;
                                    GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x - offX, cmd.y - offY, oWidth, oHeight), tMatrix);
                                }
                                break;
                            case FillTextureCmd.ID:
                                if (cmd.width && cmd.height) {
                                    GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), tMatrix);
                                } else {
                                    tex = cmd.texture;
                                    GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, tex.width, tex.height), tMatrix);
                                }
                                break;
                            case DrawTextureCmd.ID:
                                var drawMatrix;
                                if (cmd.matrix) {
                                    tMatrix.copyTo(tempMatrix);
                                    tempMatrix.concat(cmd.matrix);
                                    drawMatrix = tempMatrix;
                                } else {
                                    drawMatrix = tMatrix;
                                }
                                if (realSize) {
                                    if (cmd.width && cmd.height) {
                                        GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), drawMatrix);
                                    } else {
                                        tex = cmd.texture;
                                        GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, tex.width, tex.height), drawMatrix);
                                    }
                                } else {
                                    tex = cmd.texture;
                                    wRate = (cmd.width || tex.sourceWidth) / tex.width;
                                    hRate = (cmd.height || tex.sourceHeight) / tex.height;
                                    oWidth = wRate * tex.sourceWidth;
                                    oHeight = hRate * tex.sourceHeight;
                                    offX = tex.offsetX > 0 ? tex.offsetX : 0;
                                    offY = tex.offsetY > 0 ? tex.offsetY : 0;
                                    offX *= wRate;
                                    offY *= hRate;
                                    GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x - offX, cmd.y - offY, oWidth, oHeight), drawMatrix);
                                }
                                break;
                            case DrawRectCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x, cmd.y, cmd.width, cmd.height), tMatrix);
                                break;
                            case DrawCircleCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, Rectangle._getBoundPointS(cmd.x - cmd.radius, cmd.y - cmd.radius, cmd.radius + cmd.radius, cmd.radius + cmd.radius), tMatrix);
                                break;
                            case DrawLineCmd.ID:
                                GraphicsBounds._tempPoints.length = 0;
                                var lineWidth;
                                lineWidth = cmd.lineWidth * 0.5;
                                if (cmd.fromX == cmd.toX) {
                                    GraphicsBounds._tempPoints.push(cmd.fromX + lineWidth, cmd.fromY, cmd.toX + lineWidth, cmd.toY, cmd.fromX - lineWidth, cmd.fromY, cmd.toX - lineWidth, cmd.toY);
                                } else if (cmd.fromY == cmd.toY) {
                                    GraphicsBounds._tempPoints.push(cmd.fromX, cmd.fromY + lineWidth, cmd.toX, cmd.toY + lineWidth, cmd.fromX, cmd.fromY - lineWidth, cmd.toX, cmd.toY - lineWidth);
                                } else {
                                    GraphicsBounds._tempPoints.push(cmd.fromX, cmd.fromY, cmd.toX, cmd.toY);
                                }
                                GraphicsBounds._addPointArrToRst(rst, GraphicsBounds._tempPoints, tMatrix);
                                break;
                            case DrawCurvesCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, Bezier.I.getBezierPoints(cmd.points), tMatrix, cmd.x, cmd.y);
                                break;
                            case DrawLinesCmd.ID:
                            case DrawPolyCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, cmd.points, tMatrix, cmd.x, cmd.y);
                                break;
                            case DrawPathCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, this._getPathPoints(cmd.paths), tMatrix, cmd.x, cmd.y);
                                break;
                            case DrawPieCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, this._getPiePoints(cmd.x, cmd.y, cmd.radius, cmd.startAngle, cmd.endAngle), tMatrix);
                                break;
                            case DrawTrianglesCmd.ID:
                                GraphicsBounds._addPointArrToRst(rst, this._getTriAngBBXPoints(cmd.vertices), tMatrix);
                                break;
                            case Draw9GridTexture.ID:
                                GraphicsBounds._addPointArrToRst(rst, this._getDraw9GridBBXPoints(cmd), tMatrix);
                                break;
                        }
                    }
                    if (rst.length > 200) {
                        rst = Utils.copyArray(rst, Rectangle._getWrapRec(rst)._getBoundPoints());
                    } else if (rst.length > 8)
                        rst = GrahamScan.scanPList(rst);
                    return rst;
                }
            }, {
                key: "_switchMatrix",
                value: function _switchMatrix(tMatix, tempMatrix) {
                    tempMatrix.concat(tMatix);
                    tempMatrix.copyTo(tMatix);
                }
            }, {
                key: "_getPiePoints",
                value: function _getPiePoints(x, y, radius, startAngle, endAngle) {
                    var rst = GraphicsBounds._tempPoints;
                    GraphicsBounds._tempPoints.length = 0;
                    var k = Math.PI / 180;
                    var d1 = endAngle - startAngle;
                    if (d1 >= 360 || d1 <= -360) {
                        rst.push(x - radius, y - radius);
                        rst.push(x + radius, y - radius);
                        rst.push(x + radius, y + radius);
                        rst.push(x - radius, y + radius);
                        return rst;
                    }
                    rst.push(x, y);
                    var delta = d1 % 360;
                    if (delta < 0)
                        delta += 360;
                    var end1 = startAngle + delta;
                    var st = startAngle * k;
                    var ed = end1 * k;
                    rst.push(x + radius * Math.cos(st), y + radius * Math.sin(st));
                    rst.push(x + radius * Math.cos(ed), y + radius * Math.sin(ed));
                    var s1 = Math.ceil(startAngle / 90) * 90;
                    var s2 = Math.floor(end1 / 90) * 90;
                    for (var cs = s1; cs <= s2; cs += 90) {
                        var csr = cs * k;
                        rst.push(x + radius * Math.cos(csr), y + radius * Math.sin(csr));
                    }
                    return rst;
                }
            }, {
                key: "_getTriAngBBXPoints",
                value: function _getTriAngBBXPoints(vert) {
                    var vnum = vert.length;
                    if (vnum < 2)
                        return [];
                    var minx = vert[0];
                    var miny = vert[1];
                    var maxx = minx;
                    var maxy = miny;
                    for (var i = 2; i < vnum;) {
                        var cx = vert[i++];
                        var cy = vert[i++];
                        if (minx > cx)
                            minx = cx;
                        if (miny > cy)
                            miny = cy;
                        if (maxx < cx)
                            maxx = cx;
                        if (maxy < cy)
                            maxy = cy;
                    }
                    return [minx, miny, maxx, miny, maxx, maxy, minx, maxy];
                }
            }, {
                key: "_getDraw9GridBBXPoints",
                value: function _getDraw9GridBBXPoints(cmd) {
                    var minx = 0;
                    var miny = 0;
                    var maxx = cmd.width;
                    var maxy = cmd.height;
                    return [minx, miny, maxx, miny, maxx, maxy, minx, maxy];
                }
            }, {
                key: "_getPathPoints",
                value: function _getPathPoints(paths) {
                    var i, len;
                    var rst = GraphicsBounds._tempPoints;
                    rst.length = 0;
                    len = paths.length;
                    var tCMD;
                    for (i = 0; i < len; i++) {
                        tCMD = paths[i];
                        if (tCMD.length > 1) {
                            rst.push(tCMD[1], tCMD[2]);
                            if (tCMD.length > 3) {
                                rst.push(tCMD[3], tCMD[4]);
                            }
                        }
                    }
                    return rst;
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("GraphicsBounds", GraphicsBounds);
                }
            }, {
                key: "_addPointArrToRst",
                value: function _addPointArrToRst(rst, points, matrix) {
                    var dx = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var dy = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    var i, len;
                    len = points.length;
                    for (i = 0; i < len; i += 2) {
                        GraphicsBounds._addPointToRst(rst, points[i] + dx, points[i + 1] + dy, matrix);
                    }
                }
            }, {
                key: "_addPointToRst",
                value: function _addPointToRst(rst, x, y, matrix) {
                    var _tempPoint = Point.TEMP;
                    _tempPoint.setTo(x ? x : 0, y ? y : 0);
                    matrix.transformPoint(_tempPoint);
                    rst.push(_tempPoint.x, _tempPoint.y);
                }
            }]);
            return GraphicsBounds;
        }();
    GraphicsBounds._tempMatrix = new Matrix();
    GraphicsBounds._initMatrix = new Matrix();
    GraphicsBounds._tempPoints = [];
    GraphicsBounds._tempMatrixArrays = [];
    GraphicsBounds._tempCmds = [];
    var SpriteConst = /*#__PURE__*/
        _createClass(function SpriteConst() {
            _classCallCheck(this, SpriteConst);
        });
    SpriteConst.ALPHA = 0x01;
    SpriteConst.TRANSFORM = 0x02;
    SpriteConst.BLEND = 0x04;
    SpriteConst.CANVAS = 0x08;
    SpriteConst.FILTERS = 0x10;
    SpriteConst.MASK = 0x20;
    SpriteConst.CLIP = 0x40;
    SpriteConst.STYLE = 0x80;
    SpriteConst.TEXTURE = 0x100;
    SpriteConst.GRAPHICS = 0x200;
    SpriteConst.LAYAGL3D = 0x400;
    SpriteConst.CUSTOM = 0x800;
    SpriteConst.ONECHILD = 0x1000;
    SpriteConst.CHILDS = 0x2000;
    SpriteConst.REPAINT_NONE = 0;
    SpriteConst.REPAINT_NODE = 0x01;
    SpriteConst.REPAINT_CACHE = 0x02;
    SpriteConst.REPAINT_ALL = 0x03;
    var ClipRectCmd = /*#__PURE__*/
        function () {
            function ClipRectCmd() {
                _classCallCheck(this, ClipRectCmd);
            }
            _createClass(ClipRectCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("ClipRectCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.clipRect(this.x + gx, this.y + gy, this.width, this.height);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return ClipRectCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(x, y, width, height) {
                    var cmd = Pool.getItemByClass("ClipRectCmd", ClipRectCmd);
                    cmd.x = x;
                    cmd.y = y;
                    cmd.width = width;
                    cmd.height = height;
                    return cmd;
                }
            }]);
            return ClipRectCmd;
        }();
    ClipRectCmd.ID = "ClipRect";
    var DrawTexturesCmd = /*#__PURE__*/
        function () {
            function DrawTexturesCmd() {
                _classCallCheck(this, DrawTexturesCmd);
            }
            _createClass(DrawTexturesCmd, [{
                key: "recover",
                value: function recover() {
                    this.texture._removeReference();
                    this.texture = null;
                    this.pos = null;
                    Pool.recover("DrawTexturesCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.drawTextures(this.texture, this.pos, gx, gy);
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return DrawTexturesCmd.ID;
                }
            }], [{
                key: "create",
                value: function create(texture, pos) {
                    var cmd = Pool.getItemByClass("DrawTexturesCmd", DrawTexturesCmd);
                    cmd.texture = texture;
                    texture._addReference();
                    cmd.pos = pos;
                    return cmd;
                }
            }]);
            return DrawTexturesCmd;
        }();
    DrawTexturesCmd.ID = "DrawTextures";
    var FillTextCmd = /*#__PURE__*/
        function () {
            function FillTextCmd() {
                _classCallCheck(this, FillTextCmd);
                this._textIsWorldText = false;
                this._fontColor = 0xffffffff;
                this._strokeColor = 0;
                this._fontObj = FillTextCmd._defFontObj;
                this._nTexAlign = 0;
            }
            _createClass(FillTextCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("FillTextCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    if (ILaya.stage.isGlobalRepaint()) {
                        this._textIsWorldText && this._text.cleanCache();
                    }
                    if (this._words) {
                        Context._textRender.fillWords(context, this._words, this.x + gx, this.y + gy, this._fontObj, this._color, this._borderColor, this._lineWidth);
                    } else {
                        if (this._textIsWorldText) {
                            context._fast_filltext(this._text, this.x + gx, this.y + gy, this._fontObj, this._color, this._borderColor, this._lineWidth, this._nTexAlign, 0);
                        } else {
                            Context._textRender.filltext(context, this._text, this.x + gx, this.y + gy, this.font, this.color, this._borderColor, this._lineWidth, this._textAlign);
                        }
                    }
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return FillTextCmd.ID;
                }
            }, {
                key: "text",
                get: function get() {
                    return this._text;
                },
                set: function set(value) {
                    this._text = value;
                    this._textIsWorldText = value instanceof WordText;
                    this._textIsWorldText && this._text.cleanCache();
                }
            }, {
                key: "font",
                get: function get() {
                    return this._font;
                },
                set: function set(value) {
                    this._font = value;
                    this._fontObj = FontInfo.Parse(value);
                    this._textIsWorldText && this._text.cleanCache();
                }
            }, {
                key: "color",
                get: function get() {
                    return this._color;
                },
                set: function set(value) {
                    this._color = value;
                    this._fontColor = ColorUtils.create(value).numColor;
                    this._textIsWorldText && this._text.cleanCache();
                }
            }, {
                key: "textAlign",
                get: function get() {
                    return this._textAlign;
                },
                set: function set(value) {
                    this._textAlign = value;
                    switch (value) {
                        case 'center':
                            this._nTexAlign = ILaya.Context.ENUM_TEXTALIGN_CENTER;
                            break;
                        case 'right':
                            this._nTexAlign = ILaya.Context.ENUM_TEXTALIGN_RIGHT;
                            break;
                        default:
                            this._nTexAlign = ILaya.Context.ENUM_TEXTALIGN_DEFAULT;
                    }
                    this._textIsWorldText && this._text.cleanCache();
                }
            }], [{
                key: "create",
                value: function create(text, words, x, y, font, color, textAlign, lineWidth, borderColor) {
                    var cmd = Pool.getItemByClass("FillTextCmd", FillTextCmd);
                    cmd.text = text;
                    cmd._textIsWorldText = text instanceof WordText;
                    cmd._words = words;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.font = font;
                    cmd.color = color;
                    cmd.textAlign = textAlign;
                    cmd._lineWidth = lineWidth;
                    cmd._borderColor = borderColor;
                    return cmd;
                }
            }]);
            return FillTextCmd;
        }();
    FillTextCmd.ID = "FillText";
    FillTextCmd._defFontObj = new FontInfo(null);
    var SaveCmd = /*#__PURE__*/
        function () {
            function SaveCmd() {
                _classCallCheck(this, SaveCmd);
            }
            _createClass(SaveCmd, [{
                key: "recover",
                value: function recover() {
                    Pool.recover("SaveCmd", this);
                }
            }, {
                key: "run",
                value: function run(context, gx, gy) {
                    context.save();
                }
            }, {
                key: "cmdID",
                get: function get() {
                    return SaveCmd.ID;
                }
            }], [{
                key: "create",
                value: function create() {
                    var cmd = Pool.getItemByClass("SaveCmd", SaveCmd);
                    return cmd;
                }
            }]);
            return SaveCmd;
        }();
    SaveCmd.ID = "Save";
    var CacheManger = /*#__PURE__*/
        function () {
            function CacheManger() {
                _classCallCheck(this, CacheManger);
            }
            _createClass(CacheManger, null, [{
                key: "regCacheByFunction",
                value: function regCacheByFunction(disposeFunction, getCacheListFunction) {
                    CacheManger.unRegCacheByFunction(disposeFunction, getCacheListFunction);
                    var cache;
                    cache = {
                        tryDispose: disposeFunction,
                        getCacheList: getCacheListFunction
                    };
                    CacheManger._cacheList.push(cache);
                }
            }, {
                key: "unRegCacheByFunction",
                value: function unRegCacheByFunction(disposeFunction, getCacheListFunction) {
                    var i, len;
                    len = CacheManger._cacheList.length;
                    for (i = 0; i < len; i++) {
                        if (CacheManger._cacheList[i].tryDispose == disposeFunction && CacheManger._cacheList[i].getCacheList == getCacheListFunction) {
                            CacheManger._cacheList.splice(i, 1);
                            return;
                        }
                    }
                }
            }, {
                key: "forceDispose",
                value: function forceDispose() {
                    var i, len = CacheManger._cacheList.length;
                    for (i = 0; i < len; i++) {
                        CacheManger._cacheList[i].tryDispose(true);
                    }
                }
            }, {
                key: "beginCheck",
                value: function beginCheck() {
                    var waitTime = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 15000;
                    ILaya.systemTimer.loop(waitTime, null, CacheManger._checkLoop);
                }
            }, {
                key: "stopCheck",
                value: function stopCheck() {
                    ILaya.systemTimer.clear(null, CacheManger._checkLoop);
                }
            }, {
                key: "_checkLoop",
                value: function _checkLoop() {
                    var cacheList = CacheManger._cacheList;
                    if (cacheList.length < 1)
                        return;
                    var tTime = ILaya.Browser.now();
                    var count;
                    var len;
                    len = count = cacheList.length;
                    while (count > 0) {
                        CacheManger._index++;
                        CacheManger._index = CacheManger._index % len;
                        cacheList[CacheManger._index].tryDispose(false);
                        if (ILaya.Browser.now() - tTime > CacheManger.loopTimeLimit)
                            break;
                        count--;
                    }
                }
            }]);
            return CacheManger;
        }();
    CacheManger.loopTimeLimit = 2;
    CacheManger._cacheList = [];
    CacheManger._index = 0;
    var VectorGraphManager = /*#__PURE__*/
        function () {
            function VectorGraphManager() {
                _classCallCheck(this, VectorGraphManager);
                this.useDic = {};
                this.shapeDic = {};
                this.shapeLineDic = {};
                this._id = 0;
                this._checkKey = false;
                this._freeIdArray = [];
                CacheManger.regCacheByFunction(this.startDispose.bind(this), this.getCacheList.bind(this));
            }
            _createClass(VectorGraphManager, [{
                key: "getId",
                value: function getId() {
                    return this._id++;
                }
            }, {
                key: "addShape",
                value: function addShape(id, shape) {
                    this.shapeDic[id] = shape;
                    if (!this.useDic[id]) {
                        this.useDic[id] = true;
                    }
                }
            }, {
                key: "addLine",
                value: function addLine(id, Line) {
                    this.shapeLineDic[id] = Line;
                    if (!this.shapeLineDic[id]) {
                        this.shapeLineDic[id] = true;
                    }
                }
            }, {
                key: "getShape",
                value: function getShape(id) {
                    if (this._checkKey) {
                        if (this.useDic[id] != null) {
                            this.useDic[id] = true;
                        }
                    }
                }
            }, {
                key: "deleteShape",
                value: function deleteShape(id) {
                    if (this.shapeDic[id]) {
                        this.shapeDic[id] = null;
                        delete this.shapeDic[id];
                    }
                    if (this.shapeLineDic[id]) {
                        this.shapeLineDic[id] = null;
                        delete this.shapeLineDic[id];
                    }
                    if (this.useDic[id] != null) {
                        delete this.useDic[id];
                    }
                }
            }, {
                key: "getCacheList",
                value: function getCacheList() {
                    var str;
                    var list = [];
                    for (str in this.shapeDic) {
                        list.push(this.shapeDic[str]);
                    }
                    for (str in this.shapeLineDic) {
                        list.push(this.shapeLineDic[str]);
                    }
                    return list;
                }
            }, {
                key: "startDispose",
                value: function startDispose(key) {
                    var str;
                    for (str in this.useDic) {
                        this.useDic[str] = false;
                    }
                    this._checkKey = true;
                }
            }, {
                key: "endDispose",
                value: function endDispose() {
                    if (this._checkKey) {
                        var str;
                        for (str in this.useDic) {
                            if (!this.useDic[str]) {
                                this.deleteShape(str);
                            }
                        }
                        this._checkKey = false;
                    }
                }
            }], [{
                key: "getInstance",
                value: function getInstance() {
                    return VectorGraphManager.instance = VectorGraphManager.instance || new VectorGraphManager();
                }
            }]);
            return VectorGraphManager;
        }();
    var Graphics = /*#__PURE__*/
        function () {
            function Graphics() {
                _classCallCheck(this, Graphics);
                this._sp = null;
                this._one = null;
                this._render = this._renderEmpty;
                this._cmds = null;
                this._vectorgraphArray = null;
                this._graphicBounds = null;
                this.autoDestroy = false;
                this._createData();
            }
            _createClass(Graphics, [{
                key: "_createData",
                value: function _createData() { }
            }, {
                key: "_clearData",
                value: function _clearData() { }
            }, {
                key: "_destroyData",
                value: function _destroyData() { }
            }, {
                key: "destroy",
                value: function destroy() {
                    this.clear(true);
                    if (this._graphicBounds)
                        this._graphicBounds.destroy();
                    this._graphicBounds = null;
                    this._vectorgraphArray = null;
                    if (this._sp) {
                        this._sp._renderType = 0;
                        this._sp._setRenderType(0);
                        this._sp = null;
                    }
                    this._destroyData();
                }
            }, {
                key: "clear",
                value: function clear() {
                    var recoverCmds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                    if (recoverCmds) {
                        var tCmd = this._one;
                        if (this._cmds) {
                            var i, len = this._cmds.length;
                            for (i = 0; i < len; i++) {
                                tCmd = this._cmds[i];
                                tCmd.recover();
                            }
                            this._cmds.length = 0;
                        } else if (tCmd) {
                            tCmd.recover();
                        }
                    } else {
                        this._cmds = null;
                    }
                    this._one = null;
                    this._render = this._renderEmpty;
                    this._clearData();
                    if (this._sp) {
                        this._sp._renderType &= ~SpriteConst.GRAPHICS;
                        this._sp._setRenderType(this._sp._renderType);
                    }
                    this._repaint();
                    if (this._vectorgraphArray) {
                        for (i = 0,
                            len = this._vectorgraphArray.length; i < len; i++) {
                            VectorGraphManager.getInstance().deleteShape(this._vectorgraphArray[i]);
                        }
                        this._vectorgraphArray.length = 0;
                    }
                }
            }, {
                key: "_clearBoundsCache",
                value: function _clearBoundsCache() {
                    if (this._graphicBounds)
                        this._graphicBounds.reset();
                }
            }, {
                key: "_initGraphicBounds",
                value: function _initGraphicBounds() {
                    if (!this._graphicBounds) {
                        this._graphicBounds = GraphicsBounds.create();
                        this._graphicBounds._graphics = this;
                    }
                }
            }, {
                key: "_repaint",
                value: function _repaint() {
                    this._clearBoundsCache();
                    this._sp && this._sp.repaint();
                }
            }, {
                key: "_isOnlyOne",
                value: function _isOnlyOne() {
                    return !this._cmds || this._cmds.length === 0;
                }
            }, {
                key: "cmds",
                get: function get() {
                    return this._cmds;
                },
                set: function set(value) {
                    if (this._sp) {
                        this._sp._renderType |= SpriteConst.GRAPHICS;
                        this._sp._setRenderType(this._sp._renderType);
                    }
                    this._cmds = value;
                    this._render = this._renderAll;
                    this._repaint();
                }
            }, {
                key: "getBounds",
                value: function getBounds() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    this._initGraphicBounds();
                    return this._graphicBounds.getBounds(realSize);
                }
            }, {
                key: "getBoundPoints",
                value: function getBoundPoints() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    this._initGraphicBounds();
                    return this._graphicBounds.getBoundPoints(realSize);
                }
            }, {
                key: "drawImage",
                value: function drawImage(texture) {
                    var x = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var y = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    if (!texture)
                        return null;
                    if (!width)
                        width = texture.sourceWidth;
                    if (!height)
                        height = texture.sourceHeight;
                    if (texture.getIsReady()) {
                        var wRate = width / texture.sourceWidth;
                        var hRate = height / texture.sourceHeight;
                        width = texture.width * wRate;
                        height = texture.height * hRate;
                        if (width <= 0 || height <= 0)
                            return null;
                        x += texture.offsetX * wRate;
                        y += texture.offsetY * hRate;
                    }
                    if (this._sp) {
                        this._sp._renderType |= SpriteConst.GRAPHICS;
                        this._sp._setRenderType(this._sp._renderType);
                    }
                    var args = DrawImageCmd.create.call(this, texture, x, y, width, height);
                    if (this._one == null) {
                        this._one = args;
                        this._render = this._renderOneImg;
                    } else {
                        this._saveToCmd(null, args);
                    }
                    this._repaint();
                    return args;
                }
            }, {
                key: "drawTexture",
                value: function drawTexture(texture) {
                    var x = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var y = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    var matrix = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    var alpha = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 1;
                    var color = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
                    var blendMode = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : null;
                    var uv = arguments.length > 9 ? arguments[9] : undefined;
                    if (!texture || alpha < 0.01)
                        return null;
                    if (!texture.getIsReady())
                        return null;
                    if (!width)
                        width = texture.sourceWidth;
                    if (!height)
                        height = texture.sourceHeight;
                    if (texture.getIsReady()) {
                        var wRate = width / texture.sourceWidth;
                        var hRate = height / texture.sourceHeight;
                        width = texture.width * wRate;
                        height = texture.height * hRate;
                        if (width <= 0 || height <= 0)
                            return null;
                        x += texture.offsetX * wRate;
                        y += texture.offsetY * hRate;
                    }
                    if (this._sp) {
                        this._sp._renderType |= SpriteConst.GRAPHICS;
                        this._sp._setRenderType(this._sp._renderType);
                    }
                    var args = DrawTextureCmd.create.call(this, texture, x, y, width, height, matrix, alpha, color, blendMode, uv);
                    this._repaint();
                    return this._saveToCmd(null, args);
                }
            }, {
                key: "drawTextures",
                value: function drawTextures(texture, pos) {
                    if (!texture)
                        return null;
                    return this._saveToCmd(Render._context.drawTextures, DrawTexturesCmd.create.call(this, texture, pos));
                }
            }, {
                key: "drawTriangles",
                value: function drawTriangles(texture, x, y, vertices, uvs, indices) {
                    var matrix = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    var alpha = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 1;
                    var color = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : null;
                    var blendMode = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : null;
                    var colorNum = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : undefined;
                    return this._saveToCmd(Render._context.drawTriangles, DrawTrianglesCmd.create.call(this, texture, x, y, vertices, uvs, indices, matrix, alpha, color, blendMode, colorNum));
                }
            }, {
                key: "fillTexture",
                value: function fillTexture(texture, x, y) {
                    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    var type = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "repeat";
                    var offset = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    if (texture && texture.getIsReady())
                        return this._saveToCmd(Render._context._fillTexture, FillTextureCmd.create.call(this, texture, x, y, width, height, type, offset || Point.EMPTY, {}));
                    else
                        return null;
                }
            }, {
                key: "_saveToCmd",
                value: function _saveToCmd(fun, args) {
                    if (this._sp) {
                        this._sp._renderType |= SpriteConst.GRAPHICS;
                        this._sp._setRenderType(this._sp._renderType);
                    }
                    if (this._one == null) {
                        this._one = args;
                        this._render = this._renderOne;
                    } else {
                        this._render = this._renderAll;
                        (this._cmds || (this._cmds = [])).length === 0 && this._cmds.push(this._one);
                        this._cmds.push(args);
                    }
                    this._repaint();
                    return args;
                }
            }, {
                key: "clipRect",
                value: function clipRect(x, y, width, height) {
                    return this._saveToCmd(Render._context.clipRect, ClipRectCmd.create.call(this, x, y, width, height));
                }
            }, {
                key: "fillText",
                value: function fillText(text, x, y, font, color, textAlign) {
                    return this._saveToCmd(Render._context.fillText, FillTextCmd.create.call(this, text, null, x, y, font || ILaya.Text.defaultFontStr(), color, textAlign, 0, ""));
                }
            }, {
                key: "fillBorderText",
                value: function fillBorderText(text, x, y, font, fillColor, textAlign, lineWidth, borderColor) {
                    return this._saveToCmd(Render._context.fillText, FillTextCmd.create.call(this, text, null, x, y, font || ILaya.Text.defaultFontStr(), fillColor, borderColor, lineWidth, textAlign));
                }
            }, {
                key: "fillWords",
                value: function fillWords(words, x, y, font, color) {
                    return this._saveToCmd(Render._context.fillText, FillTextCmd.create.call(this, null, words, x, y, font || ILaya.Text.defaultFontStr(), color));
                }
            }, {
                key: "fillBorderWords",
                value: function fillBorderWords(words, x, y, font, fillColor, borderColor, lineWidth) {
                    return this._saveToCmd(Render._context.fillText, FillTextCmd.create.call(this, null, words, x, y, font || ILaya.Text.defaultFontStr(), fillColor, "", lineWidth, borderColor));
                }
            }, {
                key: "strokeText",
                value: function strokeText(text, x, y, font, color, lineWidth, textAlign) {
                    return this._saveToCmd(Render._context.fillText, FillTextCmd.create.call(this, text, null, x, y, font || ILaya.Text.defaultFontStr(), null, textAlign, lineWidth, color));
                }
            }, {
                key: "alpha",
                value: function alpha(_alpha) {
                    return this._saveToCmd(Render._context.alpha, AlphaCmd.create.call(this, _alpha));
                }
            }, {
                key: "transform",
                value: function transform(matrix) {
                    var pivotX = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var pivotY = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    return this._saveToCmd(Render._context._transform, TransformCmd.create.call(this, matrix, pivotX, pivotY));
                }
            }, {
                key: "rotate",
                value: function rotate(angle) {
                    var pivotX = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var pivotY = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    return this._saveToCmd(Render._context._rotate, RotateCmd.create.call(this, angle, pivotX, pivotY));
                }
            }, {
                key: "scale",
                value: function scale(scaleX, scaleY) {
                    var pivotX = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var pivotY = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    return this._saveToCmd(Render._context._scale, ScaleCmd.create.call(this, scaleX, scaleY, pivotX, pivotY));
                }
            }, {
                key: "translate",
                value: function translate(tx, ty) {
                    return this._saveToCmd(Render._context.translate, TranslateCmd.create.call(this, tx, ty));
                }
            }, {
                key: "save",
                value: function save() {
                    return this._saveToCmd(Render._context._save, SaveCmd.create.call(this));
                }
            }, {
                key: "restore",
                value: function restore() {
                    return this._saveToCmd(Render._context.restore, RestoreCmd.create.call(this));
                }
            }, {
                key: "replaceText",
                value: function replaceText(text) {
                    this._repaint();
                    var cmds = this._cmds;
                    if (!cmds) {
                        if (this._one && this._isTextCmd(this._one)) {
                            this._one.text = text;
                            return true;
                        }
                    } else {
                        for (var i = cmds.length - 1; i > -1; i--) {
                            if (this._isTextCmd(cmds[i])) {
                                cmds[i].text = text;
                                return true;
                            }
                        }
                    }
                    return false;
                }
            }, {
                key: "_isTextCmd",
                value: function _isTextCmd(cmd) {
                    var cmdID = cmd.cmdID;
                    return cmdID == FillTextCmd.ID;
                }
            }, {
                key: "replaceTextColor",
                value: function replaceTextColor(color) {
                    this._repaint();
                    var cmds = this._cmds;
                    if (!cmds) {
                        if (this._one && this._isTextCmd(this._one)) {
                            this._setTextCmdColor(this._one, color);
                        }
                    } else {
                        for (var i = cmds.length - 1; i > -1; i--) {
                            if (this._isTextCmd(cmds[i])) {
                                this._setTextCmdColor(cmds[i], color);
                            }
                        }
                    }
                }
            }, {
                key: "_setTextCmdColor",
                value: function _setTextCmdColor(cmdO, color) {
                    var cmdID = cmdO.cmdID;
                    switch (cmdID) {
                        case FillTextCmd.ID:
                            cmdO.color = color;
                            break;
                    }
                }
            }, {
                key: "loadImage",
                value: function loadImage(url) {
                    var x = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var y = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    var complete = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    var tex = ILaya.Loader.getRes(url);
                    if (!tex) {
                        tex = new Texture();
                        tex.load(url);
                        ILaya.Loader.cacheTexture(url, tex);
                        tex.once(Event.READY, this, this.drawImage, [tex, x, y, width, height]);
                    } else {
                        if (!tex.getIsReady()) {
                            tex.once(Event.READY, this, this.drawImage, [tex, x, y, width, height]);
                        } else
                            this.drawImage(tex, x, y, width, height);
                    }
                    if (complete != null) {
                        tex.getIsReady() ? complete.call(this._sp) : tex.on(Event.READY, this._sp, complete);
                    }
                }
            }, {
                key: "_renderEmpty",
                value: function _renderEmpty(sprite, context, x, y) { }
            }, {
                key: "_renderAll",
                value: function _renderAll(sprite, context, x, y) {
                    var cmds = this._cmds;
                    for (var i = 0, n = cmds.length; i < n; i++) {
                        cmds[i].run(context, x, y);
                    }
                }
            }, {
                key: "_renderOne",
                value: function _renderOne(sprite, context, x, y) {
                    context.sprite = sprite;
                    this._one.run(context, x, y);
                }
            }, {
                key: "_renderOneImg",
                value: function _renderOneImg(sprite, context, x, y) {
                    context.sprite = sprite;
                    this._one.run(context, x, y);
                }
            }, {
                key: "drawLine",
                value: function drawLine(fromX, fromY, toX, toY, lineColor) {
                    var lineWidth = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
                    var offset = lineWidth < 1 || lineWidth % 2 === 0 ? 0 : 0.5;
                    return this._saveToCmd(Render._context._drawLine, DrawLineCmd.create.call(this, fromX + offset, fromY + offset, toX + offset, toY + offset, lineColor, lineWidth, 0));
                }
            }, {
                key: "drawLines",
                value: function drawLines(x, y, points, lineColor) {
                    var lineWidth = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
                    if (!points || points.length < 4)
                        return null;
                    var offset = lineWidth < 1 || lineWidth % 2 === 0 ? 0 : 0.5;
                    return this._saveToCmd(Render._context._drawLines, DrawLinesCmd.create.call(this, x + offset, y + offset, points, lineColor, lineWidth, 0));
                }
            }, {
                key: "drawCurves",
                value: function drawCurves(x, y, points, lineColor) {
                    var lineWidth = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
                    return this._saveToCmd(Render._context.drawCurves, DrawCurvesCmd.create.call(this, x, y, points, lineColor, lineWidth));
                }
            }, {
                key: "drawRect",
                value: function drawRect(x, y, width, height, fillColor) {
                    var lineColor = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    var lineWidth = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 1;
                    var offset = lineWidth >= 1 && lineColor ? lineWidth / 2 : 0;
                    var lineOffset = lineColor ? lineWidth : 0;
                    return this._saveToCmd(Render._context.drawRect, DrawRectCmd.create.call(this, x + offset, y + offset, width - lineOffset, height - lineOffset, fillColor, lineColor, lineWidth));
                }
            }, {
                key: "drawCircle",
                value: function drawCircle(x, y, radius, fillColor) {
                    var lineColor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    var lineWidth = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
                    var offset = lineWidth >= 1 && lineColor ? lineWidth / 2 : 0;
                    return this._saveToCmd(Render._context._drawCircle, DrawCircleCmd.create.call(this, x, y, radius - offset, fillColor, lineColor, lineWidth, 0));
                }
            }, {
                key: "drawPie",
                value: function drawPie(x, y, radius, startAngle, endAngle, fillColor) {
                    var lineColor = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    var lineWidth = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 1;
                    var offset = lineWidth >= 1 && lineColor ? lineWidth / 2 : 0;
                    var lineOffset = lineColor ? lineWidth : 0;
                    return this._saveToCmd(Render._context._drawPie, DrawPieCmd.create.call(this, x + offset, y + offset, radius - lineOffset, Utils.toRadian(startAngle), Utils.toRadian(endAngle), fillColor, lineColor, lineWidth, 0));
                }
            }, {
                key: "drawPoly",
                value: function drawPoly(x, y, points, fillColor) {
                    var lineColor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    var lineWidth = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 1;
                    var tIsConvexPolygon = false;
                    if (points.length > 6) {
                        tIsConvexPolygon = false;
                    } else {
                        tIsConvexPolygon = true;
                    }
                    var offset = lineWidth >= 1 && lineColor ? lineWidth % 2 === 0 ? 0 : 0.5 : 0;
                    return this._saveToCmd(Render._context._drawPoly, DrawPolyCmd.create.call(this, x + offset, y + offset, points, fillColor, lineColor, lineWidth, tIsConvexPolygon, 0));
                }
            }, {
                key: "drawPath",
                value: function drawPath(x, y, paths) {
                    var brush = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var pen = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    return this._saveToCmd(Render._context._drawPath, DrawPathCmd.create.call(this, x, y, paths, brush, pen));
                }
            }, {
                key: "draw9Grid",
                value: function draw9Grid(texture) {
                    var x = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var y = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var width = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    var height = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    var sizeGrid = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    this._saveToCmd(null, Draw9GridTexture.create(texture, x, y, width, height, sizeGrid));
                }
            }]);
            return Graphics;
        }();
    var Const = /*#__PURE__*/
        _createClass(function Const() {
            _classCallCheck(this, Const);
        });
    Const.NOT_ACTIVE = 0x01;
    Const.ACTIVE_INHIERARCHY = 0x02;
    Const.AWAKED = 0x04;
    Const.NOT_READY = 0x08;
    Const.DISPLAY = 0x10;
    Const.HAS_ZORDER = 0x20;
    Const.HAS_MOUSE = 0x40;
    Const.DISPLAYED_INSTAGE = 0x80;
    Const.DRAWCALL_OPTIMIZE = 0x100;
    var LayaGLQuickRunner = /*#__PURE__*/
        function () {
            function LayaGLQuickRunner() {
                _classCallCheck(this, LayaGLQuickRunner);
            }
            _createClass(LayaGLQuickRunner, null, [{
                key: "__init__",
                value: function __init__() {
                    LayaGLQuickRunner.map[SpriteConst.ALPHA | SpriteConst.TRANSFORM | SpriteConst.GRAPHICS] = LayaGLQuickRunner.alpha_transform_drawLayaGL;
                    LayaGLQuickRunner.map[SpriteConst.ALPHA | SpriteConst.GRAPHICS] = LayaGLQuickRunner.alpha_drawLayaGL;
                    LayaGLQuickRunner.map[SpriteConst.TRANSFORM | SpriteConst.GRAPHICS] = LayaGLQuickRunner.transform_drawLayaGL;
                    LayaGLQuickRunner.map[SpriteConst.TRANSFORM | SpriteConst.CHILDS] = LayaGLQuickRunner.transform_drawNodes;
                    LayaGLQuickRunner.map[SpriteConst.ALPHA | SpriteConst.TRANSFORM | SpriteConst.TEXTURE] = LayaGLQuickRunner.alpha_transform_drawTexture;
                    LayaGLQuickRunner.map[SpriteConst.ALPHA | SpriteConst.TEXTURE] = LayaGLQuickRunner.alpha_drawTexture;
                    LayaGLQuickRunner.map[SpriteConst.TRANSFORM | SpriteConst.TEXTURE] = LayaGLQuickRunner.transform_drawTexture;
                    LayaGLQuickRunner.map[SpriteConst.GRAPHICS | SpriteConst.CHILDS] = LayaGLQuickRunner.drawLayaGL_drawNodes;
                }
            }, {
                key: "transform_drawTexture",
                value: function transform_drawTexture(sprite, context, x, y) {
                    var style = sprite._style;
                    var tex = sprite.texture;
                    context.saveTransform(LayaGLQuickRunner.curMat);
                    context.transformByMatrix(sprite.transform, x, y);
                    context.drawTexture(tex, -sprite.pivotX, -sprite.pivotY, sprite._width || tex.width, sprite._height || tex.height);
                    context.restoreTransform(LayaGLQuickRunner.curMat);
                }
            }, {
                key: "alpha_drawTexture",
                value: function alpha_drawTexture(sprite, context, x, y) {
                    var style = sprite._style;
                    var alpha;
                    var tex = sprite.texture;
                    if ((alpha = style.alpha) > 0.01 || sprite._needRepaint()) {
                        var temp = context.globalAlpha;
                        context.globalAlpha *= alpha;
                        context.drawTexture(tex, x - style.pivotX + tex.offsetX, y - style.pivotY + tex.offsetY, sprite._width || tex.width, sprite._height || tex.height);
                        context.globalAlpha = temp;
                    }
                }
            }, {
                key: "alpha_transform_drawTexture",
                value: function alpha_transform_drawTexture(sprite, context, x, y) {
                    var style = sprite._style;
                    var alpha;
                    var tex = sprite.texture;
                    if ((alpha = style.alpha) > 0.01 || sprite._needRepaint()) {
                        var temp = context.globalAlpha;
                        context.globalAlpha *= alpha;
                        context.saveTransform(LayaGLQuickRunner.curMat);
                        context.transformByMatrix(sprite.transform, x, y);
                        context.drawTexture(tex, -style.pivotX + tex.offsetX, -style.pivotY + tex.offsetY, sprite._width || tex.width, sprite._height || tex.height);
                        context.restoreTransform(LayaGLQuickRunner.curMat);
                        context.globalAlpha = temp;
                    }
                }
            }, {
                key: "alpha_transform_drawLayaGL",
                value: function alpha_transform_drawLayaGL(sprite, context, x, y) {
                    var style = sprite._style;
                    var alpha;
                    if ((alpha = style.alpha) > 0.01 || sprite._needRepaint()) {
                        var temp = context.globalAlpha;
                        context.globalAlpha *= alpha;
                        context.saveTransform(LayaGLQuickRunner.curMat);
                        context.transformByMatrix(sprite.transform, x, y);
                        sprite._graphics && sprite._graphics._render(sprite, context, -style.pivotX, -style.pivotY);
                        context.restoreTransform(LayaGLQuickRunner.curMat);
                        context.globalAlpha = temp;
                    }
                }
            }, {
                key: "alpha_drawLayaGL",
                value: function alpha_drawLayaGL(sprite, context, x, y) {
                    var style = sprite._style;
                    var alpha;
                    if ((alpha = style.alpha) > 0.01 || sprite._needRepaint()) {
                        var temp = context.globalAlpha;
                        context.globalAlpha *= alpha;
                        sprite._graphics && sprite._graphics._render(sprite, context, x - style.pivotX, y - style.pivotY);
                        context.globalAlpha = temp;
                    }
                }
            }, {
                key: "transform_drawLayaGL",
                value: function transform_drawLayaGL(sprite, context, x, y) {
                    var style = sprite._style;
                    context.saveTransform(LayaGLQuickRunner.curMat);
                    context.transformByMatrix(sprite.transform, x, y);
                    sprite._graphics && sprite._graphics._render(sprite, context, -style.pivotX, -style.pivotY);
                    context.restoreTransform(LayaGLQuickRunner.curMat);
                }
            }, {
                key: "transform_drawNodes",
                value: function transform_drawNodes(sprite, context, x, y) {
                    var textLastRender = sprite._getBit(Const.DRAWCALL_OPTIMIZE) && context.drawCallOptimize(true);
                    var style = sprite._style;
                    context.saveTransform(LayaGLQuickRunner.curMat);
                    context.transformByMatrix(sprite.transform, x, y);
                    x = -style.pivotX;
                    y = -style.pivotY;
                    var childs = sprite._children, n = childs.length, ele;
                    if (style.viewport) {
                        var rect = style.viewport;
                        var left = rect.x;
                        var top = rect.y;
                        var right = rect.right;
                        var bottom = rect.bottom;
                        var _x, _y;
                        for (i = 0; i < n; ++i) {
                            if ((ele = childs[i])._visible && (_x = ele._x) < right && _x + ele.width > left && (_y = ele._y) < bottom && _y + ele.height > top) {
                                ele.render(context, x, y);
                            }
                        }
                    } else {
                        for (var i = 0; i < n; ++i) {
                            (ele = childs[i])._visible && ele.render(context, x, y);
                        }
                    }
                    context.restoreTransform(LayaGLQuickRunner.curMat);
                    textLastRender && context.drawCallOptimize(false);
                }
            }, {
                key: "drawLayaGL_drawNodes",
                value: function drawLayaGL_drawNodes(sprite, context, x, y) {
                    var textLastRender = sprite._getBit(Const.DRAWCALL_OPTIMIZE) && context.drawCallOptimize(true);
                    var style = sprite._style;
                    x = x - style.pivotX;
                    y = y - style.pivotY;
                    sprite._graphics && sprite._graphics._render(sprite, context, x, y);
                    var childs = sprite._children, n = childs.length, ele;
                    if (style.viewport) {
                        var rect = style.viewport;
                        var left = rect.x;
                        var top = rect.y;
                        var right = rect.right;
                        var bottom = rect.bottom;
                        var _x, _y;
                        for (i = 0; i < n; ++i) {
                            if ((ele = childs[i])._visible && (_x = ele._x) < right && _x + ele.width > left && (_y = ele._y) < bottom && _y + ele.height > top) {
                                ele.render(context, x, y);
                            }
                        }
                    } else {
                        for (var i = 0; i < n; ++i) {
                            (ele = childs[i])._visible && ele.render(context, x, y);
                        }
                    }
                    textLastRender && context.drawCallOptimize(false);
                }
            }]);
            return LayaGLQuickRunner;
        }();
    LayaGLQuickRunner.map = {};
    LayaGLQuickRunner.curMat = new Matrix();
    var RenderSprite = /*#__PURE__*/
        function () {
            function RenderSprite(type, next) {
                _classCallCheck(this, RenderSprite);
                if (LayaGLQuickRunner.map[type]) {
                    this._fun = LayaGLQuickRunner.map[type];
                    this._next = RenderSprite.NORENDER;
                    return;
                }
                this._next = next || RenderSprite.NORENDER;
                switch (type) {
                    case 0:
                        this._fun = this._no;
                        return;
                    case SpriteConst.ALPHA:
                        this._fun = this._alpha;
                        return;
                    case SpriteConst.TRANSFORM:
                        this._fun = this._transform;
                        return;
                    case SpriteConst.BLEND:
                        this._fun = this._blend;
                        return;
                    case SpriteConst.CANVAS:
                        this._fun = this._canvas;
                        return;
                    case SpriteConst.MASK:
                        this._fun = this._mask;
                        return;
                    case SpriteConst.CLIP:
                        this._fun = this._clip;
                        return;
                    case SpriteConst.STYLE:
                        this._fun = this._style;
                        return;
                    case SpriteConst.GRAPHICS:
                        this._fun = this._graphics;
                        return;
                    case SpriteConst.CHILDS:
                        this._fun = this._children;
                        return;
                    case SpriteConst.CUSTOM:
                        this._fun = this._custom;
                        return;
                    case SpriteConst.TEXTURE:
                        this._fun = this._texture;
                        return;
                    case SpriteConst.FILTERS:
                        this._fun = Filter._filter;
                        return;
                    case RenderSprite.INIT:
                        this._fun = RenderSprite._initRenderFun;
                        return;
                }
                this.onCreate(type);
            }
            _createClass(RenderSprite, [{
                key: "onCreate",
                value: function onCreate(type) { }
            }, {
                key: "_style",
                value: function _style(sprite, context, x, y) {
                    var style = sprite._style;
                    if (style.render != null)
                        style.render(sprite, context, x, y);
                    var next = this._next;
                    next._fun.call(next, sprite, context, x, y);
                }
            }, {
                key: "_no",
                value: function _no(sprite, context, x, y) { }
            }, {
                key: "_custom",
                value: function _custom(sprite, context, x, y) {
                    sprite.customRender(context, x, y);
                    this._next._fun.call(this._next, sprite, context, x - sprite.pivotX, y - sprite.pivotY);
                }
            }, {
                key: "_clip",
                value: function _clip(sprite, context, x, y) {
                    var next = this._next;
                    if (next == RenderSprite.NORENDER)
                        return;
                    var r = sprite._style.scrollRect;
                    var width = r.width;
                    var height = r.height;
                    if (width === 0 || height === 0) {
                        return;
                    }
                    context.save();
                    context.clipRect(x, y, width, height);
                    next._fun.call(next, sprite, context, x - r.x, y - r.y);
                    context.restore();
                }
            }, {
                key: "_texture",
                value: function _texture(sprite, context, x, y) {
                    var tex = sprite.texture;
                    if (tex._getSource())
                        context.drawTexture(tex, x - sprite.pivotX + tex.offsetX, y - sprite.pivotY + tex.offsetY, sprite._width || tex.width, sprite._height || tex.height);
                    var next = this._next;
                    if (next != RenderSprite.NORENDER)
                        next._fun.call(next, sprite, context, x, y);
                }
            }, {
                key: "_graphics",
                value: function _graphics(sprite, context, x, y) {
                    var style = sprite._style;
                    var g = sprite._graphics;
                    g && g._render(sprite, context, x - style.pivotX, y - style.pivotY);
                    var next = this._next;
                    if (next != RenderSprite.NORENDER)
                        next._fun.call(next, sprite, context, x, y);
                }
            }, {
                key: "_image",
                value: function _image(sprite, context, x, y) {
                    var style = sprite._style;
                    context.drawTexture2(x, y, style.pivotX, style.pivotY, sprite.transform, sprite._graphics._one);
                }
            }, {
                key: "_image2",
                value: function _image2(sprite, context, x, y) {
                    var style = sprite._style;
                    context.drawTexture2(x, y, style.pivotX, style.pivotY, sprite.transform, sprite._graphics._one);
                }
            }, {
                key: "_alpha",
                value: function _alpha(sprite, context, x, y) {
                    var style = sprite._style;
                    var alpha;
                    if ((alpha = style.alpha) > 0.01 || sprite._needRepaint()) {
                        var temp = context.globalAlpha;
                        context.globalAlpha *= alpha;
                        var next = this._next;
                        next._fun.call(next, sprite, context, x, y);
                        context.globalAlpha = temp;
                    }
                }
            }, {
                key: "_transform",
                value: function _transform(sprite, context, x, y) {
                    var transform = sprite.transform
                        , _next = this._next;
                    var style = sprite._style;
                    if (transform && _next != RenderSprite.NORENDER) {
                        context.save();
                        context.transform(transform.a, transform.b, transform.c, transform.d, transform.tx + x, transform.ty + y);
                        _next._fun.call(_next, sprite, context, 0, 0);
                        context.restore();
                    } else {
                        if (_next != RenderSprite.NORENDER)
                            _next._fun.call(_next, sprite, context, x, y);
                    }
                }
            }, {
                key: "_children",
                value: function _children(sprite, context, x, y) {
                    var style = sprite._style;
                    var childs = sprite._children, n = childs.length, ele;
                    x = x - sprite.pivotX;
                    y = y - sprite.pivotY;
                    var textLastRender = sprite._getBit(Const.DRAWCALL_OPTIMIZE) && context.drawCallOptimize(true);
                    if (style.viewport) {
                        var rect = style.viewport;
                        var left = rect.x;
                        var top = rect.y;
                        var right = rect.right;
                        var bottom = rect.bottom;
                        var _x, _y;
                        for (i = 0; i < n; ++i) {
                            if ((ele = childs[i])._visible && (_x = ele._x) < right && _x + ele.width > left && (_y = ele._y) < bottom && _y + ele.height > top) {
                                ele.render(context, x, y);
                            }
                        }
                    } else {
                        for (var i = 0; i < n; ++i) {
                            (ele = childs[i])._visible && ele.render(context, x, y);
                        }
                    }
                    textLastRender && context.drawCallOptimize(false);
                }
            }, {
                key: "_canvas",
                value: function _canvas(sprite, context, x, y) {
                    var _cacheStyle = sprite._cacheStyle;
                    var _next = this._next;
                    if (!_cacheStyle.enableCanvasRender) {
                        _next._fun.call(_next, sprite, context, x, y);
                        return;
                    }
                    _cacheStyle.cacheAs === 'bitmap' ? Stat.canvasBitmap++ : Stat.canvasNormal++;
                    var cacheNeedRebuild = false;
                    var textNeedRestore = false;
                    if (_cacheStyle.canvas) {
                        var canv = _cacheStyle.canvas;
                        var ctx = canv.context;
                        var charRIs = canv.touches;
                        if (charRIs) {
                            for (var ci = 0; ci < charRIs.length; ci++) {
                                if (charRIs[ci].deleted) {
                                    textNeedRestore = true;
                                    break;
                                }
                            }
                        }
                        cacheNeedRebuild = canv.isCacheValid && !canv.isCacheValid();
                    }
                    if (sprite._needRepaint() || !_cacheStyle.canvas || textNeedRestore || cacheNeedRebuild || ILaya.stage.isGlobalRepaint()) {
                        if (_cacheStyle.cacheAs === 'normal') {
                            if (context._targets) {
                                _next._fun.call(_next, sprite, context, x, y);
                                return;
                            } else {
                                this._canvas_webgl_normal_repaint(sprite, context);
                            }
                        } else {
                            this._canvas_repaint(sprite, context, x, y);
                        }
                    }
                    var tRec = _cacheStyle.cacheRect;
                    context.drawCanvas(_cacheStyle.canvas, x + tRec.x, y + tRec.y, tRec.width, tRec.height);
                }
            }, {
                key: "_canvas_repaint",
                value: function _canvas_repaint(sprite, context, x, y) {
                    var _cacheStyle = sprite._cacheStyle;
                    var _next = this._next;
                    var tx;
                    var canvas = _cacheStyle.canvas;
                    var left;
                    var top;
                    var tRec;
                    var tCacheType = _cacheStyle.cacheAs;
                    var w, h;
                    var scaleX, scaleY;
                    var scaleInfo;
                    scaleInfo = _cacheStyle._calculateCacheRect(sprite, tCacheType, x, y);
                    scaleX = scaleInfo.x;
                    scaleY = scaleInfo.y;
                    tRec = _cacheStyle.cacheRect;
                    w = tRec.width * scaleX;
                    h = tRec.height * scaleY;
                    left = tRec.x;
                    top = tRec.y;
                    if (tCacheType === 'bitmap' && (w > 2048 || h > 2048)) {
                        console.warn("cache bitmap size larger than 2048,cache ignored");
                        _cacheStyle.releaseContext();
                        _next._fun.call(_next, sprite, context, x, y);
                        return;
                    }
                    if (!canvas) {
                        _cacheStyle.createContext();
                        canvas = _cacheStyle.canvas;
                    }
                    tx = canvas.context;
                    tx.sprite = sprite;
                    (canvas.width != w || canvas.height != h) && canvas.size(w, h);
                    if (tCacheType === 'bitmap')
                        tx.asBitmap = true;
                    else if (tCacheType === 'normal')
                        tx.asBitmap = false;
                    tx.clear();
                    if (scaleX != 1 || scaleY != 1) {
                        var ctx = tx;
                        ctx.save();
                        ctx.scale(scaleX, scaleY);
                        _next._fun.call(_next, sprite, tx, -left, -top);
                        ctx.restore();
                        sprite._applyFilters();
                    } else {
                        ctx = tx;
                        _next._fun.call(_next, sprite, tx, -left, -top);
                        sprite._applyFilters();
                    }
                    if (_cacheStyle.staticCache)
                        _cacheStyle.reCache = false;
                    Stat.canvasReCache++;
                }
            }, {
                key: "_canvas_webgl_normal_repaint",
                value: function _canvas_webgl_normal_repaint(sprite, context) {
                    var _cacheStyle = sprite._cacheStyle;
                    var _next = this._next;
                    var canvas = _cacheStyle.canvas;
                    var tCacheType = _cacheStyle.cacheAs;
                    _cacheStyle._calculateCacheRect(sprite, tCacheType, 0, 0);
                    if (!canvas) {
                        canvas = _cacheStyle.canvas = new WebGLCacheAsNormalCanvas(context, sprite);
                    }
                    var tx = canvas.context;
                    canvas['startRec']();
                    _next._fun.call(_next, sprite, tx, sprite.pivotX, sprite.pivotY);
                    sprite._applyFilters();
                    Stat.canvasReCache++;
                    canvas['endRec']();
                }
            }, {
                key: "_blend",
                value: function _blend(sprite, context, x, y) {
                    var style = sprite._style;
                    var next = this._next;
                    if (style.blendMode) {
                        context.save();
                        context.globalCompositeOperation = style.blendMode;
                        next._fun.call(next, sprite, context, x, y);
                        context.restore();
                    } else {
                        next._fun.call(next, sprite, context, x, y);
                    }
                }
            }, {
                key: "_mask",
                value: function _mask(sprite, context, x, y) {
                    var next = this._next;
                    var mask = sprite.mask;
                    var ctx = context;
                    if (mask) {
                        ctx.save();
                        var preBlendMode = ctx.globalCompositeOperation;
                        var tRect = new Rectangle();
                        tRect.copyFrom(mask.getBounds());
                        tRect.width = Math.round(tRect.width);
                        tRect.height = Math.round(tRect.height);
                        tRect.x = Math.round(tRect.x);
                        tRect.y = Math.round(tRect.y);
                        if (tRect.width > 0 && tRect.height > 0) {
                            var w = tRect.width;
                            var h = tRect.height;
                            var tmpRT = WebGLRTMgr.getRT(w, h);
                            ctx.breakNextMerge();
                            ctx.pushRT();
                            ctx.addRenderObject(SubmitCMD.create([ctx, tmpRT, w, h], RenderSprite.tmpTarget, this));
                            mask.render(ctx, -tRect.x, -tRect.y);
                            ctx.breakNextMerge();
                            ctx.popRT();
                            ctx.save();
                            ctx.clipRect(x + tRect.x - sprite.getStyle().pivotX, y + tRect.y - sprite.getStyle().pivotY, w, h);
                            next._fun.call(next, sprite, ctx, x, y);
                            ctx.restore();
                            preBlendMode = ctx.globalCompositeOperation;
                            ctx.addRenderObject(SubmitCMD.create(["mask"], RenderSprite.setBlendMode, this));
                            var shaderValue = Value2D.create(ShaderDefines2D.TEXTURE2D, 0);
                            var uv = Texture.INV_UV;
                            ctx.drawTarget(tmpRT, x + tRect.x - sprite.getStyle().pivotX, y + tRect.y - sprite.getStyle().pivotY, w, h, Matrix.TEMP.identity(), shaderValue, uv, 6);
                            ctx.addRenderObject(SubmitCMD.create([tmpRT], RenderSprite.recycleTarget, this));
                            ctx.addRenderObject(SubmitCMD.create([preBlendMode], RenderSprite.setBlendMode, this));
                        }
                        ctx.restore();
                    } else {
                        next._fun.call(next, sprite, context, x, y);
                    }
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    LayaGLQuickRunner.__init__();
                    var i, len;
                    var initRender;
                    initRender = new RenderSprite(RenderSprite.INIT, null);
                    len = RenderSprite.renders.length = SpriteConst.CHILDS * 2;
                    for (i = 0; i < len; i++) {
                        RenderSprite.renders[i] = initRender;
                    }
                    RenderSprite.renders[0] = new RenderSprite(0, null);
                }
            }, {
                key: "_initRenderFun",
                value: function _initRenderFun(sprite, context, x, y) {
                    var type = sprite._renderType;
                    var r = RenderSprite.renders[type] = RenderSprite._getTypeRender(type);
                    r._fun(sprite, context, x, y);
                }
            }, {
                key: "_getTypeRender",
                value: function _getTypeRender(type) {
                    if (LayaGLQuickRunner.map[type])
                        return new RenderSprite(type, null);
                    var rst = null;
                    var tType = SpriteConst.CHILDS;
                    while (tType > 0) {
                        if (tType & type)
                            rst = new RenderSprite(tType, rst);
                        tType = tType >> 1;
                    }
                    return rst;
                }
            }, {
                key: "tmpTarget",
                value: function tmpTarget(ctx, rt, w, h) {
                    rt.start();
                    rt.clear(0, 0, 0, 0);
                }
            }, {
                key: "recycleTarget",
                value: function recycleTarget(rt) {
                    WebGLRTMgr.releaseRT(rt);
                }
            }, {
                key: "setBlendMode",
                value: function setBlendMode(blendMode) {
                    var gl = WebGLContext.mainContext;
                    BlendMode.targetFns[BlendMode.TOINT[blendMode]](gl);
                }
            }]);
            return RenderSprite;
        }();
    RenderSprite.INIT = 0x11111;
    RenderSprite.renders = [];
    RenderSprite.NORENDER = new RenderSprite(0, null);
    RenderSprite.tempUV = new Array(8);
    var HTMLCanvas = /*#__PURE__*/
        function (_Bitmap2) {
            _inherits(HTMLCanvas, _Bitmap2);
            var _super26 = _createSuper(HTMLCanvas);
            function HTMLCanvas() {
                var _this21;
                var createCanvas = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                _classCallCheck(this, HTMLCanvas);
                _this21 = _super26.call(this);
                if (createCanvas)
                    _this21._source = Browser.createElement("canvas");
                else {
                    _this21._source = _assertThisInitialized(_this21);
                }
                _this21.lock = true;
                return _this21;
            }
            _createClass(HTMLCanvas, [{
                key: "source",
                get: function get() {
                    return this._source;
                }
            }, {
                key: "_getSource",
                value: function _getSource() {
                    return this._source;
                }
            }, {
                key: "clear",
                value: function clear() {
                    if (this._ctx) {
                        if (this._ctx.clear) {
                            this._ctx.clear();
                        } else {
                            this._ctx.clearRect(0, 0, this._width, this._height);
                        }
                    }
                    if (this._texture) {
                        this._texture.destroy();
                        this._texture = null;
                    }
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    _get(_getPrototypeOf(HTMLCanvas.prototype), "destroy", this).call(this);
                    this._setCPUMemory(0);
                    this._ctx && this._ctx.destroy && this._ctx.destroy();
                    this._ctx = null;
                }
            }, {
                key: "release",
                value: function release() { }
            }, {
                key: "context",
                get: function get() {
                    if (this._ctx)
                        return this._ctx;
                    if (this._source == this) {
                        this._ctx = new ILaya.Context();
                    } else {
                        this._ctx = this._source.getContext(ILaya.Render.isConchApp ? 'layagl' : '2d');
                    }
                    this._ctx._canvas = this;
                    return this._ctx;
                }
            }, {
                key: "_setContext",
                value: function _setContext(context) {
                    this._ctx = context;
                }
            }, {
                key: "getContext",
                value: function getContext(contextID) {
                    var other = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    return this.context;
                }
            }, {
                key: "getMemSize",
                value: function getMemSize() {
                    return 0;
                }
            }, {
                key: "size",
                value: function size(w, h) {
                    if (this._width != w || this._height != h || this._source && (this._source.width != w || this._source.height != h)) {
                        this._width = w;
                        this._height = h;
                        this._setCPUMemory(w * h * 4);
                        this._ctx && this._ctx.size && this._ctx.size(w, h);
                        if (this._source) {
                            this._source.height = h;
                            this._source.width = w;
                        }
                        if (this._texture) {
                            this._texture.destroy();
                            this._texture = null;
                        }
                    }
                }
            }, {
                key: "getTexture",
                value: function getTexture() {
                    if (!this._texture) {
                        var bitmap = new Texture2D();
                        bitmap.loadImageSource(this.source);
                        this._texture = new Texture(bitmap);
                    }
                    return this._texture;
                }
            }, {
                key: "toBase64",
                value: function toBase64(type, encoderOptions) {
                    if (this._source) {
                        if (ILaya.Render.isConchApp) {
                            var win = window;
                            if (win.conchConfig.threadMode == 2) {
                                throw "native 2 thread mode use toBase64Async";
                            }
                            var width = this._ctx._targets.sourceWidth;
                            var height = this._ctx._targets.sourceHeight;
                            var data = this._ctx._targets.getData(0, 0, width, height);
                            return win.conchToBase64FlipY ? win.conchToBase64FlipY(type, encoderOptions, data.buffer, width, height) : win.conchToBase64(type, encoderOptions, data.buffer, width, height);
                        } else {
                            return this._source.toDataURL(type, encoderOptions);
                        }
                    }
                    return null;
                }
            }, {
                key: "toBase64Async",
                value: function toBase64Async(type, encoderOptions, callBack) {
                    var width = this._ctx._targets.sourceWidth;
                    var height = this._ctx._targets.sourceHeight;
                    this._ctx._targets.getDataAsync(0, 0, width, height, function (data) {
                        var win = window;
                        var base64 = win.conchToBase64FlipY ? win.conchToBase64FlipY(type, encoderOptions, data.buffer, width, height) : win.conchToBase64(type, encoderOptions, data.buffer, width, height);
                        callBack(base64);
                    });
                }
            }]);
            return HTMLCanvas;
        }(Bitmap);
    var HitArea = /*#__PURE__*/
        function () {
            function HitArea() {
                _classCallCheck(this, HitArea);
            }
            _createClass(HitArea, [{
                key: "contains",
                value: function contains(x, y) {
                    if (!HitArea._isHitGraphic(x, y, this.hit))
                        return false;
                    return !HitArea._isHitGraphic(x, y, this.unHit);
                }
            }, {
                key: "hit",
                get: function get() {
                    if (!this._hit)
                        this._hit = new ILaya.Graphics();
                    return this._hit;
                },
                set: function set(value) {
                    this._hit = value;
                }
            }, {
                key: "unHit",
                get: function get() {
                    if (!this._unHit)
                        this._unHit = new ILaya.Graphics();
                    return this._unHit;
                },
                set: function set(value) {
                    this._unHit = value;
                }
            }], [{
                key: "_isHitGraphic",
                value: function _isHitGraphic(x, y, graphic) {
                    if (!graphic)
                        return false;
                    var cmds = graphic.cmds;
                    if (!cmds && graphic._one) {
                        cmds = HitArea._cmds;
                        cmds.length = 1;
                        cmds[0] = graphic._one;
                    }
                    if (!cmds)
                        return false;
                    var i, len;
                    len = cmds.length;
                    var cmd;
                    for (i = 0; i < len; i++) {
                        cmd = cmds[i];
                        if (!cmd)
                            continue;
                        switch (cmd.cmdID) {
                            case "Translate":
                                x -= cmd.tx;
                                y -= cmd.ty;
                        }
                        if (HitArea._isHitCmd(x, y, cmd))
                            return true;
                    }
                    return false;
                }
            }, {
                key: "_isHitCmd",
                value: function _isHitCmd(x, y, cmd) {
                    if (!cmd)
                        return false;
                    var rst = false;
                    switch (cmd.cmdID) {
                        case "DrawRect":
                            HitArea._rect.setTo(cmd.x, cmd.y, cmd.width, cmd.height);
                            rst = HitArea._rect.contains(x, y);
                            break;
                        case "DrawCircle":
                            var d;
                            x -= cmd.x;
                            y -= cmd.y;
                            d = x * x + y * y;
                            rst = d < cmd.radius * cmd.radius;
                            break;
                        case "DrawPoly":
                            x -= cmd.x;
                            y -= cmd.y;
                            rst = HitArea._ptInPolygon(x, y, cmd.points);
                            break;
                    }
                    return rst;
                }
            }, {
                key: "_ptInPolygon",
                value: function _ptInPolygon(x, y, areaPoints) {
                    var p = HitArea._ptPoint;
                    p.setTo(x, y);
                    var nCross = 0;
                    var p1x, p1y, p2x, p2y;
                    var len;
                    len = areaPoints.length;
                    for (var i = 0; i < len; i += 2) {
                        p1x = areaPoints[i];
                        p1y = areaPoints[i + 1];
                        p2x = areaPoints[(i + 2) % len];
                        p2y = areaPoints[(i + 3) % len];
                        if (p1y == p2y)
                            continue;
                        if (p.y < Math.min(p1y, p2y))
                            continue;
                        if (p.y >= Math.max(p1y, p2y))
                            continue;
                        var tx = (p.y - p1y) * (p2x - p1x) / (p2y - p1y) + p1x;
                        if (tx > p.x)
                            nCross++;
                    }
                    return nCross % 2 == 1;
                }
            }]);
            return HitArea;
        }();
    HitArea._cmds = [];
    HitArea._rect = new Rectangle();
    HitArea._ptPoint = new Point();
    var ClassUtils = /*#__PURE__*/
        function () {
            function ClassUtils() {
                _classCallCheck(this, ClassUtils);
            }
            _createClass(ClassUtils, null, [{
                key: "regClass",
                value: function regClass(className, classDef) {
                    ClassUtils._classMap[className] = classDef;
                }
            }, {
                key: "regShortClassName",
                value: function regShortClassName(classes) {
                    for (var i = 0; i < classes.length; i++) {
                        var classDef = classes[i];
                        var className = classDef.name;
                        ClassUtils._classMap[className] = classDef;
                    }
                }
            }, {
                key: "getRegClass",
                value: function getRegClass(className) {
                    return ClassUtils._classMap[className];
                }
            }, {
                key: "getClass",
                value: function getClass(className) {
                    var classObject = ClassUtils._classMap[className] || ClassUtils._classMap['Laya.' + className] || className;
                    var glaya = ILaya.Laya;
                    if (typeof classObject == 'string')
                        return ILaya.__classMap[classObject] || glaya[className];
                    return classObject;
                }
            }, {
                key: "getInstance",
                value: function getInstance(className) {
                    var compClass = ClassUtils.getClass(className);
                    if (compClass)
                        return new compClass();
                    else
                        console.warn("[error] Undefined class:", className);
                    return null;
                }
            }, {
                key: "createByJson",
                value: function createByJson(json) {
                    var node = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var root = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var customHandler = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var instanceHandler = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    if (typeof json == 'string')
                        json = JSON.parse(json);
                    var props = json.props;
                    if (!node) {
                        node = instanceHandler ? instanceHandler.runWith(json) : ClassUtils.getInstance(props.runtime || json.type);
                        if (!node)
                            return null;
                    }
                    var child = json.child;
                    if (child) {
                        for (var i = 0, n = child.length; i < n; i++) {
                            var data = child[i];
                            if ((data.props.name === "render" || data.props.renderType === "render") && node["_$set_itemRender"])
                                node.itemRender = data;
                            else {
                                if (data.type == "Graphic") {
                                    ClassUtils._addGraphicsToSprite(data, node);
                                } else if (ClassUtils._isDrawType(data.type)) {
                                    ClassUtils._addGraphicToSprite(data, node, true);
                                } else {
                                    var tChild = ClassUtils.createByJson(data, null, root, customHandler, instanceHandler);
                                    if (data.type === "Script") {
                                        if ("owner" in tChild) {
                                            tChild["owner"] = node;
                                        } else if ("target" in tChild) {
                                            tChild["target"] = node;
                                        }
                                    } else if (data.props.renderType == "mask") {
                                        node.mask = tChild;
                                    } else {
                                        node.addChild(tChild);
                                    }
                                }
                            }
                        }
                    }
                    if (props) {
                        for (var prop in props) {
                            var value = props[prop];
                            if (prop === "var" && root) {
                                root[value] = node;
                            } else if (value instanceof Array && node[prop] instanceof Function) {
                                node[prop].apply(node, value);
                            } else {
                                node[prop] = value;
                            }
                        }
                    }
                    if (customHandler && json.customProps) {
                        customHandler.runWith([node, json]);
                    }
                    if (node["created"])
                        node.created();
                    return node;
                }
            }, {
                key: "_addGraphicsToSprite",
                value: function _addGraphicsToSprite(graphicO, sprite) {
                    var graphics = graphicO.child;
                    if (!graphics || graphics.length < 1)
                        return;
                    var g = ClassUtils._getGraphicsFromSprite(graphicO, sprite);
                    var ox = 0;
                    var oy = 0;
                    if (graphicO.props) {
                        ox = ClassUtils._getObjVar(graphicO.props, "x", 0);
                        oy = ClassUtils._getObjVar(graphicO.props, "y", 0);
                    }
                    if (ox != 0 && oy != 0) {
                        g.translate(ox, oy);
                    }
                    var i, len;
                    len = graphics.length;
                    for (i = 0; i < len; i++) {
                        ClassUtils._addGraphicToGraphics(graphics[i], g);
                    }
                    if (ox != 0 && oy != 0) {
                        g.translate(-ox, -oy);
                    }
                }
            }, {
                key: "_addGraphicToSprite",
                value: function _addGraphicToSprite(graphicO, sprite) {
                    var isChild = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    var g = isChild ? ClassUtils._getGraphicsFromSprite(graphicO, sprite) : sprite.graphics;
                    ClassUtils._addGraphicToGraphics(graphicO, g);
                }
            }, {
                key: "_getGraphicsFromSprite",
                value: function _getGraphicsFromSprite(dataO, sprite) {
                    if (!dataO || !dataO.props)
                        return sprite.graphics;
                    var propsName = dataO.props.renderType;
                    if (propsName === "hit" || propsName === "unHit") {
                        var hitArea = sprite._style.hitArea || (sprite.hitArea = new HitArea());
                        if (!hitArea[propsName]) {
                            hitArea[propsName] = new Graphics();
                        }
                        var g = hitArea[propsName];
                    }
                    if (!g)
                        g = sprite.graphics;
                    return g;
                }
            }, {
                key: "_getTransformData",
                value: function _getTransformData(propsO) {
                    var m;
                    if ("pivotX" in propsO || "pivotY" in propsO) {
                        m = m || new Matrix();
                        m.translate(-ClassUtils._getObjVar(propsO, "pivotX", 0), -ClassUtils._getObjVar(propsO, "pivotY", 0));
                    }
                    var sx = ClassUtils._getObjVar(propsO, "scaleX", 1)
                        , sy = ClassUtils._getObjVar(propsO, "scaleY", 1);
                    var rotate = ClassUtils._getObjVar(propsO, "rotation", 0);
                    var skewX = ClassUtils._getObjVar(propsO, "skewX", 0);
                    var skewY = ClassUtils._getObjVar(propsO, "skewY", 0);
                    if (sx != 1 || sy != 1 || rotate != 0) {
                        m = m || new Matrix();
                        m.scale(sx, sy);
                        m.rotate(rotate * 0.0174532922222222);
                    }
                    return m;
                }
            }, {
                key: "_addGraphicToGraphics",
                value: function _addGraphicToGraphics(graphicO, graphic) {
                    var propsO;
                    propsO = graphicO.props;
                    if (!propsO)
                        return;
                    var drawConfig;
                    drawConfig = ClassUtils.DrawTypeDic[graphicO.type];
                    if (!drawConfig)
                        return;
                    var g = graphic;
                    var params = ClassUtils._getParams(propsO, drawConfig[1], drawConfig[2], drawConfig[3]);
                    var m = ClassUtils._tM;
                    if (m || ClassUtils._alpha != 1) {
                        g.save();
                        if (m)
                            g.transform(m);
                        if (ClassUtils._alpha != 1)
                            g.alpha(ClassUtils._alpha);
                    }
                    g[drawConfig[0]].apply(g, params);
                    if (m || ClassUtils._alpha != 1) {
                        g.restore();
                    }
                }
            }, {
                key: "_adptLineData",
                value: function _adptLineData(params) {
                    params[2] = parseFloat(params[0]) + parseFloat(params[2]);
                    params[3] = parseFloat(params[1]) + parseFloat(params[3]);
                    return params;
                }
            }, {
                key: "_adptTextureData",
                value: function _adptTextureData(params) {
                    params[0] = ILaya.Loader.getRes(params[0]);
                    return params;
                }
            }, {
                key: "_adptLinesData",
                value: function _adptLinesData(params) {
                    params[2] = ClassUtils._getPointListByStr(params[2]);
                    return params;
                }
            }, {
                key: "_isDrawType",
                value: function _isDrawType(type) {
                    if (type === "Image")
                        return false;
                    return type in ClassUtils.DrawTypeDic;
                }
            }, {
                key: "_getParams",
                value: function _getParams(obj, params) {
                    var xPos = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var adptFun = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var rst = ClassUtils._temParam;
                    rst.length = params.length;
                    var i, len;
                    len = params.length;
                    for (i = 0; i < len; i++) {
                        rst[i] = ClassUtils._getObjVar(obj, params[i][0], params[i][1]);
                    }
                    ClassUtils._alpha = ClassUtils._getObjVar(obj, "alpha", 1);
                    var m;
                    m = ClassUtils._getTransformData(obj);
                    if (m) {
                        if (!xPos)
                            xPos = 0;
                        m.translate(rst[xPos], rst[xPos + 1]);
                        rst[xPos] = rst[xPos + 1] = 0;
                        ClassUtils._tM = m;
                    } else {
                        ClassUtils._tM = null;
                    }
                    if (adptFun && ClassUtils[adptFun]) {
                        rst = ClassUtils[adptFun](rst);
                    }
                    return rst;
                }
            }, {
                key: "_getPointListByStr",
                value: function _getPointListByStr(str) {
                    var pointArr = str.split(",");
                    var i, len;
                    len = pointArr.length;
                    for (i = 0; i < len; i++) {
                        pointArr[i] = parseFloat(pointArr[i]);
                    }
                    return pointArr;
                }
            }, {
                key: "_getObjVar",
                value: function _getObjVar(obj, key, noValue) {
                    if (key in obj) {
                        return obj[key];
                    }
                    return noValue;
                }
            }]);
            return ClassUtils;
        }();
    ClassUtils.DrawTypeDic = {
        "Rect": ["drawRect", [["x", 0], ["y", 0], ["width", 0], ["height", 0], ["fillColor", null], ["lineColor", null], ["lineWidth", 1]]],
        "Circle": ["drawCircle", [["x", 0], ["y", 0], ["radius", 0], ["fillColor", null], ["lineColor", null], ["lineWidth", 1]]],
        "Pie": ["drawPie", [["x", 0], ["y", 0], ["radius", 0], ["startAngle", 0], ["endAngle", 0], ["fillColor", null], ["lineColor", null], ["lineWidth", 1]]],
        "Image": ["drawTexture", [["x", 0], ["y", 0], ["width", 0], ["height", 0]]],
        "Texture": ["drawTexture", [["skin", null], ["x", 0], ["y", 0], ["width", 0], ["height", 0]], 1, "_adptTextureData"],
        "FillTexture": ["fillTexture", [["skin", null], ["x", 0], ["y", 0], ["width", 0], ["height", 0], ["repeat", null]], 1, "_adptTextureData"],
        "FillText": ["fillText", [["text", ""], ["x", 0], ["y", 0], ["font", null], ["color", null], ["textAlign", null]], 1],
        "Line": ["drawLine", [["x", 0], ["y", 0], ["toX", 0], ["toY", 0], ["lineColor", null], ["lineWidth", 0]], 0, "_adptLineData"],
        "Lines": ["drawLines", [["x", 0], ["y", 0], ["points", ""], ["lineColor", null], ["lineWidth", 0]], 0, "_adptLinesData"],
        "Curves": ["drawCurves", [["x", 0], ["y", 0], ["points", ""], ["lineColor", null], ["lineWidth", 0]], 0, "_adptLinesData"],
        "Poly": ["drawPoly", [["x", 0], ["y", 0], ["points", ""], ["fillColor", null], ["lineColor", null], ["lineWidth", 1]], 0, "_adptLinesData"]
    };
    ClassUtils._temParam = [];
    ClassUtils._classMap = {};
    var BoundsStyle = /*#__PURE__*/
        function () {
            function BoundsStyle() {
                _classCallCheck(this, BoundsStyle);
            }
            _createClass(BoundsStyle, [{
                key: "reset",
                value: function reset() {
                    if (this.bounds)
                        this.bounds.recover();
                    if (this.userBounds)
                        this.userBounds.recover();
                    this.bounds = null;
                    this.userBounds = null;
                    this.temBM = null;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    Pool.recover("BoundsStyle", this.reset());
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("BoundsStyle", BoundsStyle);
                }
            }]);
            return BoundsStyle;
        }();
    var CacheStyle = /*#__PURE__*/
        function () {
            function CacheStyle() {
                _classCallCheck(this, CacheStyle);
                this.reset();
            }
            _createClass(CacheStyle, [{
                key: "needBitmapCache",
                value: function needBitmapCache() {
                    return this.cacheForFilters || !!this.mask;
                }
            }, {
                key: "needEnableCanvasRender",
                value: function needEnableCanvasRender() {
                    return this.userSetCache != "none" || this.cacheForFilters || !!this.mask;
                }
            }, {
                key: "releaseContext",
                value: function releaseContext() {
                    if (this.canvas && this.canvas.size) {
                        Pool.recover("CacheCanvas", this.canvas);
                        this.canvas.size(0, 0);
                        try {
                            this.canvas.width = 0;
                            this.canvas.height = 0;
                        } catch (e) { }
                    }
                    this.canvas = null;
                }
            }, {
                key: "createContext",
                value: function createContext() {
                    if (!this.canvas) {
                        this.canvas = Pool.getItem("CacheCanvas") || new HTMLCanvas(false);
                        var tx = this.canvas.context;
                        if (!tx) {
                            tx = this.canvas.getContext('2d');
                        }
                    }
                }
            }, {
                key: "releaseFilterCache",
                value: function releaseFilterCache() {
                    var fc = this.filterCache;
                    if (fc) {
                        fc.destroy();
                        fc.recycle();
                        this.filterCache = null;
                    }
                }
            }, {
                key: "recover",
                value: function recover() {
                    if (this === CacheStyle.EMPTY)
                        return;
                    Pool.recover("SpriteCache", this.reset());
                }
            }, {
                key: "reset",
                value: function reset() {
                    this.releaseContext();
                    this.releaseFilterCache();
                    this.cacheAs = "none";
                    this.enableCanvasRender = false;
                    this.userSetCache = "none";
                    this.cacheForFilters = false;
                    this.staticCache = false;
                    this.reCache = true;
                    this.mask = null;
                    this.maskParent = null;
                    this.filterCache = null;
                    this.filters = null;
                    this.hasGlowFilter = false;
                    if (this.cacheRect)
                        this.cacheRect.recover();
                    this.cacheRect = null;
                    return this;
                }
            }, {
                key: "_calculateCacheRect",
                value: function _calculateCacheRect(sprite, tCacheType, x, y) {
                    var _cacheStyle = sprite._cacheStyle;
                    if (!_cacheStyle.cacheRect)
                        _cacheStyle.cacheRect = Rectangle.create();
                    var tRec;
                    if (tCacheType === "bitmap") {
                        tRec = sprite.getSelfBounds();
                        tRec.width = tRec.width + CacheStyle.CANVAS_EXTEND_EDGE * 2;
                        tRec.height = tRec.height + CacheStyle.CANVAS_EXTEND_EDGE * 2;
                        tRec.x = tRec.x - sprite.pivotX;
                        tRec.y = tRec.y - sprite.pivotY;
                        tRec.x = tRec.x - CacheStyle.CANVAS_EXTEND_EDGE;
                        tRec.y = tRec.y - CacheStyle.CANVAS_EXTEND_EDGE;
                        tRec.x = Math.floor(tRec.x + x) - x;
                        tRec.y = Math.floor(tRec.y + y) - y;
                        tRec.width = Math.floor(tRec.width);
                        tRec.height = Math.floor(tRec.height);
                        _cacheStyle.cacheRect.copyFrom(tRec);
                    } else {
                        _cacheStyle.cacheRect.setTo(-sprite._style.pivotX, -sprite._style.pivotY, 1, 1);
                    }
                    tRec = _cacheStyle.cacheRect;
                    if (sprite._style.scrollRect) {
                        var scrollRect = sprite._style.scrollRect;
                        tRec.x -= scrollRect.x;
                        tRec.y -= scrollRect.y;
                    }
                    CacheStyle._scaleInfo.setTo(1, 1);
                    return CacheStyle._scaleInfo;
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("SpriteCache", CacheStyle);
                }
            }]);
            return CacheStyle;
        }();
    CacheStyle.EMPTY = new CacheStyle();
    CacheStyle._scaleInfo = new Point();
    CacheStyle.CANVAS_EXTEND_EDGE = 16;
    var SpriteStyle = /*#__PURE__*/
        function () {
            function SpriteStyle() {
                _classCallCheck(this, SpriteStyle);
                this.reset();
            }
            _createClass(SpriteStyle, [{
                key: "reset",
                value: function reset() {
                    this.scaleX = this.scaleY = 1;
                    this.skewX = this.skewY = 0;
                    this.pivotX = this.pivotY = this.rotation = 0;
                    this.alpha = 1;
                    if (this.scrollRect)
                        this.scrollRect.recover();
                    this.scrollRect = null;
                    if (this.viewport)
                        this.viewport.recover();
                    this.viewport = null;
                    this.hitArea = null;
                    this.dragging = null;
                    this.blendMode = null;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    if (this === SpriteStyle.EMPTY)
                        return;
                    Pool.recover("SpriteStyle", this.reset());
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("SpriteStyle", SpriteStyle);
                }
            }]);
            return SpriteStyle;
        }();
    SpriteStyle.EMPTY = new SpriteStyle();
    var Node = /*#__PURE__*/
        function (_EventDispatcher3) {
            _inherits(Node, _EventDispatcher3);
            var _super27 = _createSuper(Node);
            function Node() {
                var _this22;
                _classCallCheck(this, Node);
                _this22 = _super27.call(this);
                _this22._bits = 0;
                _this22._children = Node.ARRAY_EMPTY;
                _this22._extUIChild = Node.ARRAY_EMPTY;
                _this22._parent = null;
                _this22.name = "";
                _this22.destroyed = false;
                _this22.createGLBuffer();
                return _this22;
            }
            _createClass(Node, [{
                key: "createGLBuffer",
                value: function createGLBuffer() { }
            }, {
                key: "_setBit",
                value: function _setBit(type, value) {
                    if (type === Const.DISPLAY) {
                        var preValue = this._getBit(type);
                        if (preValue != value)
                            this._updateDisplayedInstage();
                    }
                    if (value)
                        this._bits |= type;
                    else
                        this._bits &= ~type;
                }
            }, {
                key: "_getBit",
                value: function _getBit(type) {
                    return (this._bits & type) != 0;
                }
            }, {
                key: "_setUpNoticeChain",
                value: function _setUpNoticeChain() {
                    if (this._getBit(Const.DISPLAY))
                        this._setBitUp(Const.DISPLAY);
                }
            }, {
                key: "_setBitUp",
                value: function _setBitUp(type) {
                    var ele = this;
                    ele._setBit(type, true);
                    ele = ele._parent;
                    while (ele) {
                        if (ele._getBit(type))
                            return;
                        ele._setBit(type, true);
                        ele = ele._parent;
                    }
                }
            }, {
                key: "on",
                value: function on(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    if (type === Event.DISPLAY || type === Event.UNDISPLAY) {
                        if (!this._getBit(Const.DISPLAY))
                            this._setBitUp(Const.DISPLAY);
                    }
                    return this._createListener(type, caller, listener, args, false);
                }
            }, {
                key: "once",
                value: function once(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    if (type === Event.DISPLAY || type === Event.UNDISPLAY) {
                        if (!this._getBit(Const.DISPLAY))
                            this._setBitUp(Const.DISPLAY);
                    }
                    return this._createListener(type, caller, listener, args, true);
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                    this.destroyed = true;
                    this._destroyAllComponent();
                    this._parent && this._parent.removeChild(this);
                    if (this._children) {
                        if (destroyChild)
                            this.destroyChildren();
                        else
                            this.removeChildren();
                    }
                    this.onDestroy();
                    this._children = null;
                    this.offAll();
                }
            }, {
                key: "onDestroy",
                value: function onDestroy() { }
            }, {
                key: "destroyChildren",
                value: function destroyChildren() {
                    if (this._children) {
                        for (var i = 0, n = this._children.length; i < n; i++) {
                            this._children[0].destroy(true);
                        }
                    }
                }
            }, {
                key: "addChild",
                value: function addChild(node) {
                    if (!node || this.destroyed || node === this)
                        return node;
                    if (node._zOrder)
                        this._setBit(Const.HAS_ZORDER, true);
                    if (node._parent === this) {
                        var index = this.getChildIndex(node);
                        if (index !== this._children.length - 1) {
                            this._children.splice(index, 1);
                            this._children.push(node);
                            this._childChanged();
                        }
                    } else {
                        node._parent && node._parent.removeChild(node);
                        this._children === Node.ARRAY_EMPTY && (this._children = []);
                        this._children.push(node);
                        node._setParent(this);
                        this._childChanged();
                    }
                    return node;
                }
            }, {
                key: "addInputChild",
                value: function addInputChild(node) {
                    if (this._extUIChild == Node.ARRAY_EMPTY) {
                        this._extUIChild = [node];
                    } else {
                        if (this._extUIChild.indexOf(node) >= 0) {
                            return null;
                        }
                        this._extUIChild.push(node);
                    }
                    return null;
                }
            }, {
                key: "removeInputChild",
                value: function removeInputChild(node) {
                    var idx = this._extUIChild.indexOf(node);
                    if (idx >= 0) {
                        this._extUIChild.splice(idx, 1);
                    }
                }
            }, {
                key: "addChildren",
                value: function addChildren() {
                    var i = 0
                        , n = arguments.length;
                    while (i < n) {
                        var _i;
                        this.addChild((_i = i++,
                            _i < 0 || arguments.length <= _i ? undefined : arguments[_i]));
                    }
                }
            }, {
                key: "addChildAt",
                value: function addChildAt(node, index) {
                    if (!node || this.destroyed || node === this)
                        return node;
                    if (node._zOrder)
                        this._setBit(Const.HAS_ZORDER, true);
                    if (index >= 0 && index <= this._children.length) {
                        if (node._parent === this) {
                            var oldIndex = this.getChildIndex(node);
                            this._children.splice(oldIndex, 1);
                            this._children.splice(index, 0, node);
                            this._childChanged();
                        } else {
                            node._parent && node._parent.removeChild(node);
                            this._children === Node.ARRAY_EMPTY && (this._children = []);
                            this._children.splice(index, 0, node);
                            node._setParent(this);
                        }
                        return node;
                    } else {
                        throw new Error("appendChildAt:The index is out of bounds");
                    }
                }
            }, {
                key: "getChildIndex",
                value: function getChildIndex(node) {
                    return this._children.indexOf(node);
                }
            }, {
                key: "getChildByName",
                value: function getChildByName(name) {
                    var nodes = this._children;
                    if (nodes) {
                        for (var i = 0, n = nodes.length; i < n; i++) {
                            var node = nodes[i];
                            if (node.name === name)
                                return node;
                        }
                    }
                    return null;
                }
            }, {
                key: "getChildAt",
                value: function getChildAt(index) {
                    return this._children[index] || null;
                }
            }, {
                key: "setChildIndex",
                value: function setChildIndex(node, index) {
                    var childs = this._children;
                    if (index < 0 || index >= childs.length) {
                        throw new Error("setChildIndex:The index is out of bounds.");
                    }
                    var oldIndex = this.getChildIndex(node);
                    if (oldIndex < 0)
                        throw new Error("setChildIndex:node is must child of this object.");
                    childs.splice(oldIndex, 1);
                    childs.splice(index, 0, node);
                    this._childChanged();
                    return node;
                }
            }, {
                key: "_childChanged",
                value: function _childChanged() {
                    var child = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                }
            }, {
                key: "removeChild",
                value: function removeChild(node) {
                    if (!this._children)
                        return node;
                    var index = this._children.indexOf(node);
                    return this.removeChildAt(index);
                }
            }, {
                key: "removeSelf",
                value: function removeSelf() {
                    this._parent && this._parent.removeChild(this);
                    return this;
                }
            }, {
                key: "removeChildByName",
                value: function removeChildByName(name) {
                    var node = this.getChildByName(name);
                    node && this.removeChild(node);
                    return node;
                }
            }, {
                key: "removeChildAt",
                value: function removeChildAt(index) {
                    var node = this.getChildAt(index);
                    if (node) {
                        this._children.splice(index, 1);
                        node._setParent(null);
                    }
                    return node;
                }
            }, {
                key: "removeChildren",
                value: function removeChildren() {
                    var beginIndex = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var endIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0x7fffffff;
                    if (this._children && this._children.length > 0) {
                        var childs = this._children;
                        if (beginIndex === 0 && endIndex >= childs.length - 1) {
                            var arr = childs;
                            this._children = Node.ARRAY_EMPTY;
                        } else {
                            arr = childs.splice(beginIndex, endIndex - beginIndex);
                        }
                        for (var i = 0, n = arr.length; i < n; i++) {
                            arr[i]._setParent(null);
                        }
                    }
                    return this;
                }
            }, {
                key: "replaceChild",
                value: function replaceChild(newNode, oldNode) {
                    var index = this._children.indexOf(oldNode);
                    if (index > -1) {
                        this._children.splice(index, 1, newNode);
                        oldNode._setParent(null);
                        newNode._setParent(this);
                        return newNode;
                    }
                    return null;
                }
            }, {
                key: "numChildren",
                get: function get() {
                    return this._children.length;
                }
            }, {
                key: "parent",
                get: function get() {
                    return this._parent;
                }
            }, {
                key: "_setParent",
                value: function _setParent(value) {
                    if (this._parent !== value) {
                        if (value) {
                            this._parent = value;
                            this._onAdded();
                            this.event(Event.ADDED);
                            if (this._getBit(Const.DISPLAY)) {
                                this._setUpNoticeChain();
                                value.displayedInStage && this._displayChild(this, true);
                            }
                            value._childChanged(this);
                        } else {
                            this._onRemoved();
                            this.event(Event.REMOVED);
                            this._parent._childChanged();
                            if (this._getBit(Const.DISPLAY))
                                this._displayChild(this, false);
                            this._parent = value;
                        }
                    }
                }
            }, {
                key: "displayedInStage",
                get: function get() {
                    if (this._getBit(Const.DISPLAY))
                        return this._getBit(Const.DISPLAYED_INSTAGE);
                    this._setBitUp(Const.DISPLAY);
                    return this._getBit(Const.DISPLAYED_INSTAGE);
                }
            }, {
                key: "_updateDisplayedInstage",
                value: function _updateDisplayedInstage() {
                    var ele;
                    ele = this;
                    var stage = ILaya.stage;
                    var displayedInStage = false;
                    while (ele) {
                        if (ele._getBit(Const.DISPLAY)) {
                            displayedInStage = ele._getBit(Const.DISPLAYED_INSTAGE);
                            break;
                        }
                        if (ele === stage || ele._getBit(Const.DISPLAYED_INSTAGE)) {
                            displayedInStage = true;
                            break;
                        }
                        ele = ele._parent;
                    }
                    this._setBit(Const.DISPLAYED_INSTAGE, displayedInStage);
                }
            }, {
                key: "_setDisplay",
                value: function _setDisplay(value) {
                    if (this._getBit(Const.DISPLAYED_INSTAGE) !== value) {
                        this._setBit(Const.DISPLAYED_INSTAGE, value);
                        if (value)
                            this.event(Event.DISPLAY);
                        else
                            this.event(Event.UNDISPLAY);
                    }
                }
            }, {
                key: "_displayChild",
                value: function _displayChild(node, display) {
                    var childs = node._children;
                    if (childs) {
                        for (var i = 0, n = childs.length; i < n; i++) {
                            var child = childs[i];
                            if (!child._getBit(Const.DISPLAY))
                                continue;
                            if (child._children.length > 0) {
                                this._displayChild(child, display);
                            } else {
                                child._setDisplay(display);
                            }
                        }
                    }
                    node._setDisplay(display);
                }
            }, {
                key: "contains",
                value: function contains(node) {
                    if (node === this)
                        return true;
                    while (node) {
                        if (node._parent === this)
                            return true;
                        node = node._parent;
                    }
                    return false;
                }
            }, {
                key: "timerLoop",
                value: function timerLoop(delay, caller, method) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var coverBefore = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
                    var jumpFrame = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer.loop(delay, caller, method, args, coverBefore, jumpFrame);
                }
            }, {
                key: "timerOnce",
                value: function timerOnce(delay, caller, method) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var coverBefore = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer._create(false, false, delay, caller, method, args, coverBefore);
                }
            }, {
                key: "frameLoop",
                value: function frameLoop(delay, caller, method) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var coverBefore = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer._create(true, true, delay, caller, method, args, coverBefore);
                }
            }, {
                key: "frameOnce",
                value: function frameOnce(delay, caller, method) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var coverBefore = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : true;
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer._create(true, false, delay, caller, method, args, coverBefore);
                }
            }, {
                key: "clearTimer",
                value: function clearTimer(caller, method) {
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer.clear(caller, method);
                }
            }, {
                key: "callLater",
                value: function callLater(method) {
                    var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer.callLater(this, method, args);
                }
            }, {
                key: "runCallLater",
                value: function runCallLater(method) {
                    var timer = this.scene ? this.scene.timer : ILaya.timer;
                    timer.runCallLater(this, method);
                }
            }, {
                key: "scene",
                get: function get() {
                    return this._scene;
                }
            }, {
                key: "active",
                get: function get() {
                    return !this._getBit(Const.NOT_READY) && !this._getBit(Const.NOT_ACTIVE);
                },
                set: function set(value) {
                    value = !!value;
                    if (!this._getBit(Const.NOT_ACTIVE) !== value) {
                        if (this._activeChangeScripts && this._activeChangeScripts.length !== 0) {
                            if (value)
                                throw "Node: can't set the main inActive node active in hierarchy,if the operate is in main inActive node or it's children script's onDisable Event.";
                            else
                                throw "Node: can't set the main active node inActive in hierarchy,if the operate is in main active node or it's children script's onEnable Event.";
                        } else {
                            this._setBit(Const.NOT_ACTIVE, !value);
                            if (this._parent) {
                                if (this._parent.activeInHierarchy) {
                                    if (value)
                                        this._processActive();
                                    else
                                        this._processInActive();
                                }
                            }
                        }
                    }
                }
            }, {
                key: "activeInHierarchy",
                get: function get() {
                    return this._getBit(Const.ACTIVE_INHIERARCHY);
                }
            }, {
                key: "_onActive",
                value: function _onActive() {
                    Stat.spriteCount++;
                }
            }, {
                key: "_onInActive",
                value: function _onInActive() {
                    Stat.spriteCount--;
                }
            }, {
                key: "_onActiveInScene",
                value: function _onActiveInScene() { }
            }, {
                key: "_onInActiveInScene",
                value: function _onInActiveInScene() { }
            }, {
                key: "_parse",
                value: function _parse(data, spriteMap) { }
            }, {
                key: "_setBelongScene",
                value: function _setBelongScene(scene) {
                    if (!this._scene) {
                        this._scene = scene;
                        this._onActiveInScene();
                        for (var i = 0, n = this._children.length; i < n; i++) {
                            this._children[i]._setBelongScene(scene);
                        }
                    }
                }
            }, {
                key: "_setUnBelongScene",
                value: function _setUnBelongScene() {
                    if (this._scene !== this) {
                        this._onInActiveInScene();
                        this._scene = null;
                        for (var i = 0, n = this._children.length; i < n; i++) {
                            this._children[i]._setUnBelongScene();
                        }
                    }
                }
            }, {
                key: "onAwake",
                value: function onAwake() { }
            }, {
                key: "onEnable",
                value: function onEnable() { }
            }, {
                key: "_processActive",
                value: function _processActive() {
                    this._activeChangeScripts || (this._activeChangeScripts = []);
                    this._activeHierarchy(this._activeChangeScripts);
                    this._activeScripts();
                }
            }, {
                key: "_activeHierarchy",
                value: function _activeHierarchy(activeChangeScripts) {
                    this._setBit(Const.ACTIVE_INHIERARCHY, true);
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var comp = this._components[i];
                            if (comp._isScript())
                                comp._enabled && activeChangeScripts.push(comp);
                            else
                                comp._setActive(true);
                        }
                    }
                    this._onActive();
                    for (i = 0,
                        n = this._children.length; i < n; i++) {
                        var child = this._children[i];
                        !child._getBit(Const.NOT_ACTIVE) && child._activeHierarchy(activeChangeScripts);
                    }
                    if (!this._getBit(Const.AWAKED)) {
                        this._setBit(Const.AWAKED, true);
                        this.onAwake();
                    }
                    this.onEnable();
                }
            }, {
                key: "_activeScripts",
                value: function _activeScripts() {
                    for (var i = 0, n = this._activeChangeScripts.length; i < n; i++) {
                        var comp = this._activeChangeScripts[i];
                        if (!comp._awaked) {
                            comp._awaked = true;
                            comp._onAwake();
                        }
                        comp._onEnable();
                    }
                    this._activeChangeScripts.length = 0;
                }
            }, {
                key: "_processInActive",
                value: function _processInActive() {
                    this._activeChangeScripts || (this._activeChangeScripts = []);
                    this._inActiveHierarchy(this._activeChangeScripts);
                    this._inActiveScripts();
                }
            }, {
                key: "_inActiveHierarchy",
                value: function _inActiveHierarchy(activeChangeScripts) {
                    this._onInActive();
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var comp = this._components[i];
                            comp._setActive(false);
                            comp._isScript() && comp._enabled && activeChangeScripts.push(comp);
                        }
                    }
                    this._setBit(Const.ACTIVE_INHIERARCHY, false);
                    for (i = 0,
                        n = this._children.length; i < n; i++) {
                        var child = this._children[i];
                        child && !child._getBit(Const.NOT_ACTIVE) && child._inActiveHierarchy(activeChangeScripts);
                    }
                    this.onDisable();
                }
            }, {
                key: "_inActiveScripts",
                value: function _inActiveScripts() {
                    for (var i = 0, n = this._activeChangeScripts.length; i < n; i++) {
                        this._activeChangeScripts[i].onDisable();
                    }
                    this._activeChangeScripts.length = 0;
                }
            }, {
                key: "onDisable",
                value: function onDisable() { }
            }, {
                key: "_onAdded",
                value: function _onAdded() {
                    if (this._activeChangeScripts && this._activeChangeScripts.length !== 0) {
                        throw "Node: can't set the main inActive node active in hierarchy,if the operate is in main inActive node or it's children script's onDisable Event.";
                    } else {
                        var parentScene = this._parent.scene;
                        parentScene && this._setBelongScene(parentScene);
                        this._parent.activeInHierarchy && this.active && this._processActive();
                    }
                }
            }, {
                key: "_onRemoved",
                value: function _onRemoved() {
                    if (this._activeChangeScripts && this._activeChangeScripts.length !== 0) {
                        throw "Node: can't set the main active node inActive in hierarchy,if the operate is in main active node or it's children script's onEnable Event.";
                    } else {
                        this._parent.activeInHierarchy && this.active && this._processInActive();
                        this._parent.scene && this._setUnBelongScene();
                    }
                }
            }, {
                key: "_addComponentInstance",
                value: function _addComponentInstance(comp) {
                    this._components = this._components || [];
                    this._components.push(comp);
                    comp.owner = this;
                    comp._onAdded();
                    if (this.activeInHierarchy)
                        comp._setActive(true);
                }
            }, {
                key: "_destroyComponent",
                value: function _destroyComponent(comp) {
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var item = this._components[i];
                            if (item === comp) {
                                item._destroy();
                                this._components.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
            }, {
                key: "_destroyAllComponent",
                value: function _destroyAllComponent() {
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var item = this._components[i];
                            item._destroy();
                        }
                        this._components.length = 0;
                    }
                }
            }, {
                key: "_cloneTo",
                value: function _cloneTo(destObject, srcRoot, dstRoot) {
                    var destNode = destObject;
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var destComponent = destNode.addComponent(this._components[i].constructor);
                            this._components[i]._cloneTo(destComponent);
                        }
                    }
                }
            }, {
                key: "addComponentIntance",
                value: function addComponentIntance(component) {
                    if (component.owner)
                        throw "Node:the component has belong to other node.";
                    if (component.isSingleton && this.getComponent(component.constructor))
                        throw "Node:the component is singleton,can't add the second one.";
                    this._addComponentInstance(component);
                    return component;
                }
            }, {
                key: "addComponent",
                value: function addComponent(componentType) {
                    var comp = Pool.createByClass(componentType);
                    comp._destroyed = false;
                    if (comp.isSingleton && this.getComponent(componentType))
                        throw "无法实例" + componentType + "组件" + "，" + componentType + "组件已存在！";
                    this._addComponentInstance(comp);
                    return comp;
                }
            }, {
                key: "getComponent",
                value: function getComponent(componentType) {
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var comp = this._components[i];
                            if (comp instanceof componentType)
                                return comp;
                        }
                    }
                    return null;
                }
            }, {
                key: "getComponents",
                value: function getComponents(componentType) {
                    var arr;
                    if (this._components) {
                        for (var i = 0, n = this._components.length; i < n; i++) {
                            var comp = this._components[i];
                            if (comp instanceof componentType) {
                                arr = arr || [];
                                arr.push(comp);
                            }
                        }
                    }
                    return arr;
                }
            }, {
                key: "timer",
                get: function get() {
                    return this.scene ? this.scene.timer : ILaya.timer;
                }
            }]);
            return Node;
        }(EventDispatcher);
    Node.ARRAY_EMPTY = [];
    ClassUtils.regClass("laya.display.Node", Node);
    ClassUtils.regClass("Laya.Node", Node);
    var Sprite = /*#__PURE__*/
        function (_Node) {
            _inherits(Sprite, _Node);
            var _super28 = _createSuper(Sprite);
            function Sprite() {
                var _this23;
                _classCallCheck(this, Sprite);
                _this23 = _super28.call(this);
                _this23._x = 0;
                _this23._y = 0;
                _this23._width = 0;
                _this23._height = 0;
                _this23._visible = true;
                _this23._mouseState = 0;
                _this23._zOrder = 0;
                _this23._renderType = 0;
                _this23._transform = null;
                _this23._tfChanged = false;
                _this23._repaint = SpriteConst.REPAINT_NONE;
                _this23._texture = null;
                _this23._style = SpriteStyle.EMPTY;
                _this23._cacheStyle = CacheStyle.EMPTY;
                _this23._boundStyle = null;
                _this23._graphics = null;
                _this23.mouseThrough = false;
                _this23.autoSize = false;
                _this23.hitTestPrior = false;
                return _this23;
            }
            _createClass(Sprite, [{
                key: "destroy",
                value: function destroy() {
                    var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                    _get(_getPrototypeOf(Sprite.prototype), "destroy", this).call(this, destroyChild);
                    this._style && this._style.recover();
                    this._cacheStyle && this._cacheStyle.recover();
                    this._boundStyle && this._boundStyle.recover();
                    this._style = null;
                    this._cacheStyle = null;
                    this._boundStyle = null;
                    this._transform = null;
                    if (this._graphics && this._graphics.autoDestroy) {
                        this._graphics.destroy();
                    }
                    this._graphics = null;
                    this.texture = null;
                }
            }, {
                key: "updateZOrder",
                value: function updateZOrder() {
                    Utils.updateOrder(this._children) && this.repaint();
                }
            }, {
                key: "_getBoundsStyle",
                value: function _getBoundsStyle() {
                    if (!this._boundStyle)
                        this._boundStyle = BoundsStyle.create();
                    return this._boundStyle;
                }
            }, {
                key: "_setCustomRender",
                value: function _setCustomRender() { }
            }, {
                key: "customRenderEnable",
                set: function set(b) {
                    if (b) {
                        this._renderType |= SpriteConst.CUSTOM;
                        this._setRenderType(this._renderType);
                        this._setCustomRender();
                    }
                }
            }, {
                key: "cacheAs",
                get: function get() {
                    return this._cacheStyle.cacheAs;
                },
                set: function set(value) {
                    if (value === this._cacheStyle.userSetCache)
                        return;
                    if (this.mask && value === 'normal')
                        return;
                    this._setCacheAs(value);
                    this._getCacheStyle().userSetCache = value;
                    this._checkCanvasEnable();
                    this.repaint();
                }
            }, {
                key: "_setCacheAs",
                value: function _setCacheAs(value) { }
            }, {
                key: "_checkCanvasEnable",
                value: function _checkCanvasEnable() {
                    var tEnable = this._cacheStyle.needEnableCanvasRender();
                    this._getCacheStyle().enableCanvasRender = tEnable;
                    if (tEnable) {
                        if (this._cacheStyle.needBitmapCache()) {
                            this._cacheStyle.cacheAs = "bitmap";
                        } else {
                            this._cacheStyle.cacheAs = this._cacheStyle.userSetCache;
                        }
                        this._cacheStyle.reCache = true;
                        this._renderType |= SpriteConst.CANVAS;
                    } else {
                        this._cacheStyle.cacheAs = "none";
                        this._cacheStyle.releaseContext();
                        this._renderType &= ~SpriteConst.CANVAS;
                    }
                    this._setCacheAs(this._cacheStyle.cacheAs);
                    this._setRenderType(this._renderType);
                }
            }, {
                key: "staticCache",
                get: function get() {
                    return this._cacheStyle.staticCache;
                },
                set: function set(value) {
                    this._getCacheStyle().staticCache = value;
                    if (!value)
                        this.reCache();
                }
            }, {
                key: "reCache",
                value: function reCache() {
                    this._cacheStyle.reCache = true;
                    this._repaint |= SpriteConst.REPAINT_CACHE;
                }
            }, {
                key: "getRepaint",
                value: function getRepaint() {
                    return this._repaint;
                }
            }, {
                key: "_setX",
                value: function _setX(value) {
                    this._x = value;
                }
            }, {
                key: "_setY",
                value: function _setY(value) {
                    this._y = value;
                }
            }, {
                key: "_setWidth",
                value: function _setWidth(texture, value) { }
            }, {
                key: "_setHeight",
                value: function _setHeight(texture, value) { }
            }, {
                key: "x",
                get: function get() {
                    return this._x;
                },
                set: function set(value) {
                    if (this.destroyed)
                        return;
                    if (this._x !== value) {
                        this._setX(value);
                        this.parentRepaint(SpriteConst.REPAINT_CACHE);
                        var p = this._cacheStyle.maskParent;
                        if (p) {
                            p.repaint(SpriteConst.REPAINT_CACHE);
                        }
                    }
                }
            }, {
                key: "y",
                get: function get() {
                    return this._y;
                },
                set: function set(value) {
                    if (this.destroyed)
                        return;
                    if (this._y !== value) {
                        this._setY(value);
                        this.parentRepaint(SpriteConst.REPAINT_CACHE);
                        var p = this._cacheStyle.maskParent;
                        if (p) {
                            p.repaint(SpriteConst.REPAINT_CACHE);
                        }
                    }
                }
            }, {
                key: "width",
                get: function get() {
                    return this.get_width();
                },
                set: function set(value) {
                    this.set_width(value);
                }
            }, {
                key: "set_width",
                value: function set_width(value) {
                    if (this._width !== value) {
                        this._width = value;
                        this._setWidth(this.texture, value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "get_width",
                value: function get_width() {
                    if (!this.autoSize)
                        return this._width || (this.texture ? this.texture.width : 0);
                    if (this.texture)
                        return this.texture.width;
                    if (!this._graphics && this._children.length === 0)
                        return 0;
                    return this.getSelfBounds().width;
                }
            }, {
                key: "height",
                get: function get() {
                    return this.get_height();
                },
                set: function set(value) {
                    this.set_height(value);
                }
            }, {
                key: "set_height",
                value: function set_height(value) {
                    if (this._height !== value) {
                        this._height = value;
                        this._setHeight(this.texture, value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "get_height",
                value: function get_height() {
                    if (!this.autoSize)
                        return this._height || (this.texture ? this.texture.height : 0);
                    if (this.texture)
                        return this.texture.height;
                    if (!this._graphics && this._children.length === 0)
                        return 0;
                    return this.getSelfBounds().height;
                }
            }, {
                key: "displayWidth",
                get: function get() {
                    return this.width * this.scaleX;
                }
            }, {
                key: "displayHeight",
                get: function get() {
                    return this.height * this.scaleY;
                }
            }, {
                key: "setSelfBounds",
                value: function setSelfBounds(bound) {
                    this._getBoundsStyle().userBounds = bound;
                }
            }, {
                key: "getBounds",
                value: function getBounds() {
                    return this._getBoundsStyle().bounds = Rectangle._getWrapRec(this._boundPointsToParent());
                }
            }, {
                key: "getSelfBounds",
                value: function getSelfBounds() {
                    if (this._boundStyle && this._boundStyle.userBounds)
                        return this._boundStyle.userBounds;
                    if (!this._graphics && this._children.length === 0 && !this._texture)
                        return Rectangle.TEMP.setTo(0, 0, this.width, this.height);
                    return this._getBoundsStyle().bounds = Rectangle._getWrapRec(this._getBoundPointsM(false));
                }
            }, {
                key: "_boundPointsToParent",
                value: function _boundPointsToParent() {
                    var ifRotate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    var pX = 0
                        , pY = 0;
                    if (this._style) {
                        pX = this.pivotX;
                        pY = this.pivotY;
                        ifRotate = ifRotate || this._style.rotation !== 0;
                        if (this._style.scrollRect) {
                            pX += this._style.scrollRect.x;
                            pY += this._style.scrollRect.y;
                        }
                    }
                    var pList = this._getBoundPointsM(ifRotate);
                    if (!pList || pList.length < 1)
                        return pList;
                    if (pList.length != 8) {
                        pList = ifRotate ? GrahamScan.scanPList(pList) : Rectangle._getWrapRec(pList, Rectangle.TEMP)._getBoundPoints();
                    }
                    if (!this.transform) {
                        Utils.transPointList(pList, this._x - pX, this._y - pY);
                        return pList;
                    }
                    var tPoint = Point.TEMP;
                    var i, len = pList.length;
                    for (i = 0; i < len; i += 2) {
                        tPoint.x = pList[i];
                        tPoint.y = pList[i + 1];
                        this.toParentPoint(tPoint);
                        pList[i] = tPoint.x;
                        pList[i + 1] = tPoint.y;
                    }
                    return pList;
                }
            }, {
                key: "getGraphicBounds",
                value: function getGraphicBounds() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (!this._graphics)
                        return Rectangle.TEMP.setTo(0, 0, 0, 0);
                    return this._graphics.getBounds(realSize);
                }
            }, {
                key: "_getBoundPointsM",
                value: function _getBoundPointsM() {
                    var ifRotate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    if (this._boundStyle && this._boundStyle.userBounds)
                        return this._boundStyle.userBounds._getBoundPoints();
                    if (!this._boundStyle)
                        this._getBoundsStyle();
                    if (!this._boundStyle.temBM)
                        this._boundStyle.temBM = [];
                    if (this._style.scrollRect) {
                        var rst = Utils.clearArray(this._boundStyle.temBM);
                        var rec = Rectangle.TEMP;
                        rec.copyFrom(this._style.scrollRect);
                        Utils.concatArray(rst, rec._getBoundPoints());
                        return rst;
                    }
                    var pList;
                    if (this._graphics) {
                        pList = this._graphics.getBoundPoints();
                    } else {
                        pList = Utils.clearArray(this._boundStyle.temBM);
                        if (this._texture) {
                            rec = Rectangle.TEMP;
                            rec.setTo(0, 0, this.width || this._texture.width, this.height || this._texture.height);
                            Utils.concatArray(pList, rec._getBoundPoints());
                        }
                    }
                    var child;
                    var cList;
                    var __childs;
                    __childs = this._children;
                    for (var i = 0, n = __childs.length; i < n; i++) {
                        child = __childs[i];
                        if (child instanceof Sprite && child._visible === true) {
                            cList = child._boundPointsToParent(ifRotate);
                            if (cList)
                                pList = pList ? Utils.concatArray(pList, cList) : cList;
                        }
                    }
                    return pList;
                }
            }, {
                key: "_getCacheStyle",
                value: function _getCacheStyle() {
                    this._cacheStyle === CacheStyle.EMPTY && (this._cacheStyle = CacheStyle.create());
                    return this._cacheStyle;
                }
            }, {
                key: "getStyle",
                value: function getStyle() {
                    this._style === SpriteStyle.EMPTY && (this._style = SpriteStyle.create());
                    return this._style;
                }
            }, {
                key: "setStyle",
                value: function setStyle(value) {
                    this._style = value;
                }
            }, {
                key: "scaleX",
                get: function get() {
                    return this._style.scaleX;
                },
                set: function set(value) {
                    this.set_scaleX(value);
                }
            }, {
                key: "_setScaleX",
                value: function _setScaleX(value) {
                    this._style.scaleX = value;
                }
            }, {
                key: "scaleY",
                get: function get() {
                    return this._style.scaleY;
                },
                set: function set(value) {
                    this.set_scaleY(value);
                }
            }, {
                key: "_setScaleY",
                value: function _setScaleY(value) {
                    this._style.scaleY = value;
                }
            }, {
                key: "set_scaleX",
                value: function set_scaleX(value) {
                    var style = this.getStyle();
                    if (style.scaleX !== value) {
                        this._setScaleX(value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "get_scaleX",
                value: function get_scaleX() {
                    return this._style.scaleX;
                }
            }, {
                key: "set_scaleY",
                value: function set_scaleY(value) {
                    var style = this.getStyle();
                    if (style.scaleY !== value) {
                        this._setScaleY(value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "get_scaleY",
                value: function get_scaleY() {
                    return this._style.scaleY;
                }
            }, {
                key: "rotation",
                get: function get() {
                    return this._style.rotation;
                },
                set: function set(value) {
                    var style = this.getStyle();
                    if (style.rotation !== value) {
                        this._setRotation(value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "_setRotation",
                value: function _setRotation(value) {
                    this._style.rotation = value;
                }
            }, {
                key: "skewX",
                get: function get() {
                    return this._style.skewX;
                },
                set: function set(value) {
                    var style = this.getStyle();
                    if (style.skewX !== value) {
                        this._setSkewX(value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "_setSkewX",
                value: function _setSkewX(value) {
                    this._style.skewX = value;
                }
            }, {
                key: "skewY",
                get: function get() {
                    return this._style.skewY;
                },
                set: function set(value) {
                    var style = this.getStyle();
                    if (style.skewY !== value) {
                        this._setSkewY(value);
                        this._setTranformChange();
                    }
                }
            }, {
                key: "_setSkewY",
                value: function _setSkewY(value) {
                    this._style.skewY = value;
                }
            }, {
                key: "_createTransform",
                value: function _createTransform() {
                    return Matrix.create();
                }
            }, {
                key: "_adjustTransform",
                value: function _adjustTransform() {
                    this._tfChanged = false;
                    var style = this._style;
                    var sx = style.scaleX
                        , sy = style.scaleY;
                    var sskx = style.skewX;
                    var ssky = style.skewY;
                    var rot = style.rotation;
                    var m = this._transform || (this._transform = this._createTransform());
                    if (rot || sx !== 1 || sy !== 1 || sskx !== 0 || ssky !== 0) {
                        m._bTransform = true;
                        var skx = (rot - sskx) * 0.0174532922222222;
                        var sky = (rot + ssky) * 0.0174532922222222;
                        var cx = Math.cos(sky);
                        var ssx = Math.sin(sky);
                        var cy = Math.sin(skx);
                        var ssy = Math.cos(skx);
                        m.a = sx * cx;
                        m.b = sx * ssx;
                        m.c = -sy * cy;
                        m.d = sy * ssy;
                        m.tx = m.ty = 0;
                    } else {
                        m.identity();
                        this._renderType &= ~SpriteConst.TRANSFORM;
                        this._setRenderType(this._renderType);
                    }
                    return m;
                }
            }, {
                key: "_setTransform",
                value: function _setTransform(value) { }
            }, {
                key: "transform",
                get: function get() {
                    return this._tfChanged ? this._adjustTransform() : this._transform;
                },
                set: function set(value) {
                    this.set_transform(value);
                }
            }, {
                key: "get_transform",
                value: function get_transform() {
                    return this._tfChanged ? this._adjustTransform() : this._transform;
                }
            }, {
                key: "set_transform",
                value: function set_transform(value) {
                    this._tfChanged = false;
                    var m = this._transform || (this._transform = this._createTransform());
                    value.copyTo(m);
                    this._setTransform(m);
                    if (value) {
                        this._x = m.tx;
                        this._y = m.ty;
                        m.tx = m.ty = 0;
                    }
                    if (value)
                        this._renderType |= SpriteConst.TRANSFORM;
                    else {
                        this._renderType &= ~SpriteConst.TRANSFORM;
                    }
                    this._setRenderType(this._renderType);
                    this.parentRepaint();
                }
            }, {
                key: "_setPivotX",
                value: function _setPivotX(value) {
                    var style = this.getStyle();
                    style.pivotX = value;
                }
            }, {
                key: "_getPivotX",
                value: function _getPivotX() {
                    return this._style.pivotX;
                }
            }, {
                key: "_setPivotY",
                value: function _setPivotY(value) {
                    var style = this.getStyle();
                    style.pivotY = value;
                }
            }, {
                key: "_getPivotY",
                value: function _getPivotY() {
                    return this._style.pivotY;
                }
            }, {
                key: "pivotX",
                get: function get() {
                    return this._getPivotX();
                },
                set: function set(value) {
                    this._setPivotX(value);
                    this.repaint();
                }
            }, {
                key: "pivotY",
                get: function get() {
                    return this._getPivotY();
                },
                set: function set(value) {
                    this._setPivotY(value);
                    this.repaint();
                }
            }, {
                key: "_setAlpha",
                value: function _setAlpha(value) {
                    if (this._style.alpha !== value) {
                        var style = this.getStyle();
                        style.alpha = value;
                        if (value !== 1)
                            this._renderType |= SpriteConst.ALPHA;
                        else
                            this._renderType &= ~SpriteConst.ALPHA;
                        this._setRenderType(this._renderType);
                        this.parentRepaint();
                    }
                }
            }, {
                key: "_getAlpha",
                value: function _getAlpha() {
                    return this._style.alpha;
                }
            }, {
                key: "alpha",
                get: function get() {
                    return this._getAlpha();
                },
                set: function set(value) {
                    value = value < 0 ? 0 : value > 1 ? 1 : value;
                    this._setAlpha(value);
                }
            }, {
                key: "visible",
                get: function get() {
                    return this.get_visible();
                },
                set: function set(value) {
                    this.set_visible(value);
                }
            }, {
                key: "get_visible",
                value: function get_visible() {
                    return this._visible;
                }
            }, {
                key: "set_visible",
                value: function set_visible(value) {
                    if (this._visible !== value) {
                        this._visible = value;
                        this.parentRepaint(SpriteConst.REPAINT_ALL);
                    }
                }
            }, {
                key: "_setBlendMode",
                value: function _setBlendMode(value) { }
            }, {
                key: "blendMode",
                get: function get() {
                    return this._style.blendMode;
                },
                set: function set(value) {
                    this._setBlendMode(value);
                    this.getStyle().blendMode = value;
                    if (value && value != "source-over")
                        this._renderType |= SpriteConst.BLEND;
                    else
                        this._renderType &= ~SpriteConst.BLEND;
                    this._setRenderType(this._renderType);
                    this.parentRepaint();
                }
            }, {
                key: "graphics",
                get: function get() {
                    if (!this._graphics) {
                        this.graphics = new Graphics();
                        this._graphics.autoDestroy = true;
                    }
                    return this._graphics;
                },
                set: function set(value) {
                    if (this._graphics)
                        this._graphics._sp = null;
                    this._graphics = value;
                    if (value) {
                        this._setGraphics(value);
                        this._renderType |= SpriteConst.GRAPHICS;
                        value._sp = this;
                    } else {
                        this._renderType &= ~SpriteConst.GRAPHICS;
                    }
                    this._setRenderType(this._renderType);
                    this.repaint();
                }
            }, {
                key: "_setGraphics",
                value: function _setGraphics(value) { }
            }, {
                key: "_setGraphicsCallBack",
                value: function _setGraphicsCallBack() { }
            }, {
                key: "scrollRect",
                get: function get() {
                    return this._style.scrollRect;
                },
                set: function set(value) {
                    this.getStyle().scrollRect = value;
                    this._setScrollRect(value);
                    this.repaint();
                    if (value) {
                        this._renderType |= SpriteConst.CLIP;
                    } else {
                        this._renderType &= ~SpriteConst.CLIP;
                    }
                    this._setRenderType(this._renderType);
                }
            }, {
                key: "_setScrollRect",
                value: function _setScrollRect(value) { }
            }, {
                key: "pos",
                value: function pos(x, y) {
                    var speedMode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    if (this._x !== x || this._y !== y) {
                        if (this.destroyed)
                            return this;
                        if (speedMode) {
                            this._setX(x);
                            this._setY(y);
                            this.parentRepaint(SpriteConst.REPAINT_CACHE);
                            var p = this._cacheStyle.maskParent;
                            if (p) {
                                p.repaint(SpriteConst.REPAINT_CACHE);
                            }
                        } else {
                            this.x = x;
                            this.y = y;
                        }
                    }
                    return this;
                }
            }, {
                key: "pivot",
                value: function pivot(x, y) {
                    this.pivotX = x;
                    this.pivotY = y;
                    return this;
                }
            }, {
                key: "size",
                value: function size(width, height) {
                    this.width = width;
                    this.height = height;
                    return this;
                }
            }, {
                key: "scale",
                value: function scale(scaleX, scaleY) {
                    var speedMode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    var style = this.getStyle();
                    if (style.scaleX != scaleX || style.scaleY != scaleY) {
                        if (this.destroyed)
                            return this;
                        if (speedMode) {
                            this._setScaleX(scaleX);
                            this._setScaleY(scaleY);
                            this._setTranformChange();
                        } else {
                            this.scaleX = scaleX;
                            this.scaleY = scaleY;
                        }
                    }
                    return this;
                }
            }, {
                key: "skew",
                value: function skew(skewX, skewY) {
                    this.skewX = skewX;
                    this.skewY = skewY;
                    return this;
                }
            }, {
                key: "render",
                value: function render(ctx, x, y) {
                    RenderSprite.renders[this._renderType]._fun(this, ctx, x + this._x, y + this._y);
                    this._repaint = 0;
                }
            }, {
                key: "drawToCanvas",
                value: function drawToCanvas(canvasWidth, canvasHeight, offsetX, offsetY) {
                    return Sprite.drawToCanvas(this, this._renderType, canvasWidth, canvasHeight, offsetX, offsetY);
                }
            }, {
                key: "drawToTexture",
                value: function drawToTexture(canvasWidth, canvasHeight, offsetX, offsetY) {
                    var rt = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    return Sprite.drawToTexture(this, this._renderType, canvasWidth, canvasHeight, offsetX, offsetY, rt);
                }
            }, {
                key: "drawToTexture3D",
                value: function drawToTexture3D(offx, offy, tex) {
                    throw 'not implement';
                }
            }, {
                key: "customRender",
                value: function customRender(context, x, y) {
                    this._repaint = SpriteConst.REPAINT_ALL;
                }
            }, {
                key: "_applyFilters",
                value: function _applyFilters() { }
            }, {
                key: "filters",
                get: function get() {
                    return this._cacheStyle.filters;
                },
                set: function set(value) {
                    value && value.length === 0 && (value = null);
                    if (this._cacheStyle.filters == value)
                        return;
                    this._getCacheStyle().filters = value ? value.slice() : null;
                    if (value && value.length) {
                        this._setColorFilter(value[0]);
                        this._renderType |= SpriteConst.FILTERS;
                    } else {
                        this._setColorFilter(null);
                        this._renderType &= ~SpriteConst.FILTERS;
                    }
                    this._setRenderType(this._renderType);
                    if (value && value.length > 0) {
                        if (!this._getBit(Const.DISPLAY))
                            this._setBitUp(Const.DISPLAY);
                        if (!(value.length == 1 && value[0] instanceof ColorFilter)) {
                            this._getCacheStyle().cacheForFilters = true;
                            this._checkCanvasEnable();
                        }
                    } else {
                        if (this._cacheStyle.cacheForFilters) {
                            this._cacheStyle.cacheForFilters = false;
                            this._checkCanvasEnable();
                        }
                    }
                    this._getCacheStyle().hasGlowFilter = this._isHaveGlowFilter();
                    this.repaint();
                }
            }, {
                key: "_setColorFilter",
                value: function _setColorFilter(value) { }
            }, {
                key: "_isHaveGlowFilter",
                value: function _isHaveGlowFilter() {
                    var i, len;
                    if (this.filters) {
                        for (i = 0; i < this.filters.length; i++) {
                            if (this.filters[i].type == Filter.GLOW) {
                                return true;
                            }
                        }
                    }
                    for (i = 0,
                        len = this._children.length; i < len; i++) {
                        if (this._children[i]._isHaveGlowFilter()) {
                            return true;
                        }
                    }
                    return false;
                }
            }, {
                key: "localToGlobal",
                value: function localToGlobal(point) {
                    var createNewPoint = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var globalNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    if (createNewPoint === true) {
                        point = new Point(point.x, point.y);
                    }
                    var ele = this;
                    globalNode = globalNode || ILaya.stage;
                    while (ele && !ele.destroyed) {
                        if (ele == globalNode)
                            break;
                        point = ele.toParentPoint(point);
                        ele = ele.parent;
                    }
                    return point;
                }
            }, {
                key: "globalToLocal",
                value: function globalToLocal(point) {
                    var createNewPoint = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var globalNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    if (createNewPoint) {
                        point = new Point(point.x, point.y);
                    }
                    var ele = this;
                    var list = [];
                    globalNode = globalNode || ILaya.stage;
                    while (ele && !ele.destroyed) {
                        if (ele == globalNode)
                            break;
                        list.push(ele);
                        ele = ele.parent;
                    }
                    var i = list.length - 1;
                    while (i >= 0) {
                        ele = list[i];
                        point = ele.fromParentPoint(point);
                        i--;
                    }
                    return point;
                }
            }, {
                key: "toParentPoint",
                value: function toParentPoint(point) {
                    if (!point)
                        return point;
                    point.x -= this.pivotX;
                    point.y -= this.pivotY;
                    if (this.transform) {
                        this._transform.transformPoint(point);
                    }
                    point.x += this._x;
                    point.y += this._y;
                    var scroll = this._style.scrollRect;
                    if (scroll) {
                        point.x -= scroll.x;
                        point.y -= scroll.y;
                    }
                    return point;
                }
            }, {
                key: "fromParentPoint",
                value: function fromParentPoint(point) {
                    if (!point)
                        return point;
                    point.x -= this._x;
                    point.y -= this._y;
                    var scroll = this._style.scrollRect;
                    if (scroll) {
                        point.x += scroll.x;
                        point.y += scroll.y;
                    }
                    if (this.transform) {
                        this._transform.invertTransformPoint(point);
                    }
                    point.x += this.pivotX;
                    point.y += this.pivotY;
                    return point;
                }
            }, {
                key: "fromStagePoint",
                value: function fromStagePoint(point) {
                    return point;
                }
            }, {
                key: "on",
                value: function on(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    if (this._mouseState !== 1 && this.isMouseEvent(type)) {
                        this.mouseEnabled = true;
                        this._setBit(Const.HAS_MOUSE, true);
                        if (this._parent) {
                            this._onDisplay();
                        }
                        return this._createListener(type, caller, listener, args, false);
                    }
                    return _get(_getPrototypeOf(Sprite.prototype), "on", this).call(this, type, caller, listener, args);
                }
            }, {
                key: "once",
                value: function once(type, caller, listener) {
                    var args = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    if (this._mouseState !== 1 && this.isMouseEvent(type)) {
                        this.mouseEnabled = true;
                        this._setBit(Const.HAS_MOUSE, true);
                        if (this._parent) {
                            this._onDisplay();
                        }
                        return this._createListener(type, caller, listener, args, true);
                    }
                    return _get(_getPrototypeOf(Sprite.prototype), "once", this).call(this, type, caller, listener, args);
                }
            }, {
                key: "_onDisplay",
                value: function _onDisplay(v) {
                    if (this._mouseState !== 1) {
                        var ele = this;
                        ele = ele.parent;
                        while (ele && ele._mouseState !== 1) {
                            if (ele._getBit(Const.HAS_MOUSE))
                                break;
                            ele.mouseEnabled = true;
                            ele._setBit(Const.HAS_MOUSE, true);
                            ele = ele.parent;
                        }
                    }
                }
            }, {
                key: "_setParent",
                value: function _setParent(value) {
                    _get(_getPrototypeOf(Sprite.prototype), "_setParent", this).call(this, value);
                    if (value && this._getBit(Const.HAS_MOUSE)) {
                        this._onDisplay();
                    }
                }
            }, {
                key: "loadImage",
                value: function loadImage(url) {
                    var complete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (!url) {
                        this.texture = null;
                        loaded.call(this);
                    } else {
                        var tex = ILaya.Loader.textureMap[URL.formatURL(url)];
                        if (!tex) {
                            tex = new Texture();
                            tex.load(url);
                            ILaya.Loader.cacheTexture(url, tex);
                        }
                        this.texture = tex;
                        if (!tex.getIsReady())
                            tex.once(Event.READY, this, loaded);
                        else
                            loaded.call(this);
                    }
                    function loaded() {
                        this.repaint(SpriteConst.REPAINT_ALL);
                        complete && complete.run();
                    }
                    return this;
                }
            }, {
                key: "repaint",
                value: function repaint() {
                    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SpriteConst.REPAINT_CACHE;
                    if (!(this._repaint & type)) {
                        this._repaint |= type;
                        this.parentRepaint(type);
                    }
                    if (this._cacheStyle && this._cacheStyle.maskParent) {
                        this._cacheStyle.maskParent.repaint(type);
                    }
                }
            }, {
                key: "_needRepaint",
                value: function _needRepaint() {
                    return this._repaint & SpriteConst.REPAINT_CACHE && this._cacheStyle.enableCanvasRender && this._cacheStyle.reCache;
                }
            }, {
                key: "_childChanged",
                value: function _childChanged() {
                    var child = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    if (this._children.length)
                        this._renderType |= SpriteConst.CHILDS;
                    else
                        this._renderType &= ~SpriteConst.CHILDS;
                    this._setRenderType(this._renderType);
                    if (child && this._getBit(Const.HAS_ZORDER))
                        ILaya.systemTimer.callLater(this, this.updateZOrder);
                    this.repaint(SpriteConst.REPAINT_ALL);
                }
            }, {
                key: "parentRepaint",
                value: function parentRepaint() {
                    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SpriteConst.REPAINT_CACHE;
                    var p = this._parent;
                    if (p && !(p._repaint & type)) {
                        p._repaint |= type;
                        p.parentRepaint(type);
                    }
                }
            }, {
                key: "stage",
                get: function get() {
                    return ILaya.stage;
                }
            }, {
                key: "hitArea",
                get: function get() {
                    return this._style.hitArea;
                },
                set: function set(value) {
                    this.getStyle().hitArea = value;
                }
            }, {
                key: "_setMask",
                value: function _setMask(value) { }
            }, {
                key: "mask",
                get: function get() {
                    return this._cacheStyle.mask;
                },
                set: function set(value) {
                    if (value && this.mask && this.mask._cacheStyle.maskParent)
                        return;
                    this._getCacheStyle().mask = value;
                    this._setMask(value);
                    this._checkCanvasEnable();
                    if (value) {
                        value._getCacheStyle().maskParent = this;
                    } else {
                        if (this.mask) {
                            this.mask._getCacheStyle().maskParent = null;
                        }
                    }
                    this._renderType |= SpriteConst.MASK;
                    this._setRenderType(this._renderType);
                    this.parentRepaint(SpriteConst.REPAINT_ALL);
                }
            }, {
                key: "mouseEnabled",
                get: function get() {
                    return this._mouseState > 1;
                },
                set: function set(value) {
                    this._mouseState = value ? 2 : 1;
                }
            }, {
                key: "startDrag",
                value: function startDrag() {
                    var area = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    var hasInertia = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    var elasticDistance = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    var elasticBackTime = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 300;
                    var data = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    var disableMouseEvent = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
                    var ratio = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 0.92;
                    this._style.dragging || (this.getStyle().dragging = new ILaya.Dragging());
                    this._style.dragging.start(this, area, hasInertia, elasticDistance, elasticBackTime, data, disableMouseEvent, ratio);
                }
            }, {
                key: "stopDrag",
                value: function stopDrag() {
                    this._style.dragging && this._style.dragging.stop();
                }
            }, {
                key: "_setDisplay",
                value: function _setDisplay(value) {
                    if (!value) {
                        if (this._cacheStyle) {
                            this._cacheStyle.releaseContext();
                            this._cacheStyle.releaseFilterCache();
                            if (this._cacheStyle.hasGlowFilter) {
                                this._cacheStyle.hasGlowFilter = false;
                            }
                        }
                    }
                    _get(_getPrototypeOf(Sprite.prototype), "_setDisplay", this).call(this, value);
                }
            }, {
                key: "hitTestPoint",
                value: function hitTestPoint(x, y) {
                    var point = this.globalToLocal(Point.TEMP.setTo(x, y));
                    x = point.x;
                    y = point.y;
                    var rect = this._style.hitArea ? this._style.hitArea : this._width > 0 && this._height > 0 ? Rectangle.TEMP.setTo(0, 0, this._width, this._height) : this.getSelfBounds();
                    return rect.contains(x, y);
                }
            }, {
                key: "getMousePoint",
                value: function getMousePoint() {
                    return this.globalToLocal(Point.TEMP.setTo(ILaya.stage.mouseX, ILaya.stage.mouseY));
                }
            }, {
                key: "globalScaleX",
                get: function get() {
                    var scale = 1;
                    var ele = this;
                    while (ele) {
                        if (ele === ILaya.stage)
                            break;
                        scale *= ele.scaleX;
                        ele = ele.parent;
                    }
                    return scale;
                }
            }, {
                key: "globalRotation",
                get: function get() {
                    var angle = 0;
                    var ele = this;
                    while (ele) {
                        if (ele === ILaya.stage)
                            break;
                        angle += ele.rotation;
                        ele = ele.parent;
                    }
                    return angle;
                }
            }, {
                key: "globalScaleY",
                get: function get() {
                    var scale = 1;
                    var ele = this;
                    while (ele) {
                        if (ele === ILaya.stage)
                            break;
                        scale *= ele.scaleY;
                        ele = ele.parent;
                    }
                    return scale;
                }
            }, {
                key: "mouseX",
                get: function get() {
                    return this.getMousePoint().x;
                }
            }, {
                key: "mouseY",
                get: function get() {
                    return this.getMousePoint().y;
                }
            }, {
                key: "zOrder",
                get: function get() {
                    return this._zOrder;
                },
                set: function set(value) {
                    if (this._zOrder != value) {
                        this._zOrder = value;
                        if (this._parent) {
                            value && this._parent._setBit(Const.HAS_ZORDER, true);
                            ILaya.systemTimer.callLater(this._parent, this.updateZOrder);
                        }
                    }
                }
            }, {
                key: "texture",
                get: function get() {
                    return this._texture;
                },
                set: function set(value) {
                    if (typeof value == 'string') {
                        this.loadImage(value);
                    } else if (this._texture != value) {
                        this._texture && this._texture._removeReference();
                        this._texture = value;
                        value && value._addReference();
                        this._setTexture(value);
                        this._setWidth(this._texture, this.width);
                        this._setHeight(this._texture, this.height);
                        if (value)
                            this._renderType |= SpriteConst.TEXTURE;
                        else
                            this._renderType &= ~SpriteConst.TEXTURE;
                        this._setRenderType(this._renderType);
                        this.repaint();
                    }
                }
            }, {
                key: "_setTexture",
                value: function _setTexture(value) { }
            }, {
                key: "viewport",
                get: function get() {
                    return this._style.viewport;
                },
                set: function set(value) {
                    if (typeof value == 'string') {
                        var recArr;
                        recArr = value.split(",");
                        if (recArr.length > 3) {
                            value = new Rectangle(parseFloat(recArr[0]), parseFloat(recArr[1]), parseFloat(recArr[2]), parseFloat(recArr[3]));
                        }
                    }
                    this.getStyle().viewport = value;
                }
            }, {
                key: "_setRenderType",
                value: function _setRenderType(type) { }
            }, {
                key: "_setTranformChange",
                value: function _setTranformChange() {
                    this._tfChanged = true;
                    this._renderType |= SpriteConst.TRANSFORM;
                    this.parentRepaint(SpriteConst.REPAINT_CACHE);
                }
            }, {
                key: "_setBgStyleColor",
                value: function _setBgStyleColor(x, y, width, height, fillColor) { }
            }, {
                key: "_setBorderStyleColor",
                value: function _setBorderStyleColor(x, y, width, height, fillColor, borderWidth) { }
            }, {
                key: "captureMouseEvent",
                value: function captureMouseEvent(exclusive) {
                    ILaya.MouseManager.instance.setCapture(this, exclusive);
                }
            }, {
                key: "releaseMouseEvent",
                value: function releaseMouseEvent() {
                    ILaya.MouseManager.instance.releaseCapture();
                }
            }, {
                key: "drawCallOptimize",
                get: function get() {
                    return this._getBit(Const.DRAWCALL_OPTIMIZE);
                },
                set: function set(value) {
                    this._setBit(Const.DRAWCALL_OPTIMIZE, value);
                }
            }], [{
                key: "drawToCanvas",
                value: function drawToCanvas(sprite, _renderType, canvasWidth, canvasHeight, offsetX, offsetY) {
                    offsetX -= sprite.x;
                    offsetY -= sprite.y;
                    offsetX |= 0;
                    offsetY |= 0;
                    canvasWidth |= 0;
                    canvasHeight |= 0;
                    var ctx = new Context();
                    ctx.size(canvasWidth, canvasHeight);
                    ctx.asBitmap = true;
                    ctx._targets.start();
                    ctx._targets.clear(0, 0, 0, 0);
                    RenderSprite.renders[_renderType]._fun(sprite, ctx, offsetX, offsetY);
                    ctx.flush();
                    ctx._targets.end();
                    ctx._targets.restore();
                    var dt = ctx._targets.getData(0, 0, canvasWidth, canvasHeight);
                    ctx.destroy();
                    var imgdata = new ImageData(canvasWidth, canvasHeight);
                    var lineLen = canvasWidth * 4;
                    var dst = imgdata.data;
                    var y = canvasHeight - 1;
                    var off = y * lineLen;
                    var srcoff = 0;
                    for (; y >= 0; y--) {
                        dst.set(dt.subarray(srcoff, srcoff + lineLen), off);
                        off -= lineLen;
                        srcoff += lineLen;
                    }
                    var canv = new HTMLCanvas(true);
                    canv.size(canvasWidth, canvasHeight);
                    var ctx2d = canv.getContext('2d');
                    ctx2d.putImageData(imgdata, 0, 0);
                    return canv;
                }
            }, {
                key: "drawToTexture",
                value: function drawToTexture(sprite, _renderType, canvasWidth, canvasHeight, offsetX, offsetY) {
                    var rt = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    if (!Sprite.drawtocanvCtx) {
                        Sprite.drawtocanvCtx = new Context();
                    }
                    offsetX -= sprite.x;
                    offsetY -= sprite.y;
                    offsetX |= 0;
                    offsetY |= 0;
                    canvasWidth |= 0;
                    canvasHeight |= 0;
                    var ctx = rt ? Sprite.drawtocanvCtx : new Context();
                    ctx.clear();
                    ctx.size(canvasWidth, canvasHeight);
                    if (rt) {
                        ctx._targets = rt;
                    } else {
                        ctx.asBitmap = true;
                    }
                    ctx._targets.start();
                    ctx._targets.clear(0, 0, 0, 0);
                    RenderSprite.renders[_renderType]._fun(sprite, ctx, offsetX, offsetY);
                    ctx.flush();
                    ctx._targets.end();
                    ctx._targets.restore();
                    if (!rt) {
                        var rtex = new Texture(ctx._targets, Texture.INV_UV);
                        ctx.destroy(true);
                        return rtex;
                    }
                    sprite._repaint = 0;
                    return rt;
                }
            }, {
                key: "fromImage",
                value: function fromImage(url) {
                    return new Sprite().loadImage(url);
                }
            }]);
            return Sprite;
        }(Node);
    ClassUtils.regClass("laya.display.Sprite", Sprite);
    ClassUtils.regClass("Laya.Sprite", Sprite);
    var TextStyle = /*#__PURE__*/
        function (_SpriteStyle) {
            _inherits(TextStyle, _SpriteStyle);
            var _super29 = _createSuper(TextStyle);
            function TextStyle() {
                var _this24;
                _classCallCheck(this, TextStyle);
                _this24 = _super29.apply(this, arguments);
                _this24.italic = false;
                return _this24;
            }
            _createClass(TextStyle, [{
                key: "reset",
                value: function reset() {
                    _get(_getPrototypeOf(TextStyle.prototype), "reset", this).call(this);
                    this.italic = false;
                    this.align = "left";
                    this.wordWrap = false;
                    this.leading = 0;
                    this.padding = [0, 0, 0, 0];
                    this.bgColor = null;
                    this.borderColor = null;
                    this.asPassword = false;
                    this.stroke = 0;
                    this.strokeColor = "#000000";
                    this.bold = false;
                    this.underline = false;
                    this.underlineColor = null;
                    this.currBitmapFont = null;
                    return this;
                }
            }, {
                key: "recover",
                value: function recover() {
                    if (this === TextStyle.EMPTY)
                        return;
                    Pool.recover("TextStyle", this.reset());
                }
            }, {
                key: "render",
                value: function render(sprite, context, x, y) {
                    (this.bgColor || this.borderColor) && context.drawRect(x, y, sprite.width, sprite.height, this.bgColor, this.borderColor, 1);
                }
            }], [{
                key: "create",
                value: function create() {
                    return Pool.getItemByClass("TextStyle", TextStyle);
                }
            }]);
            return TextStyle;
        }(SpriteStyle);
    TextStyle.EMPTY = new TextStyle();
    var Text = /*#__PURE__*/
        function (_Sprite) {
            _inherits(Text, _Sprite);
            var _super30 = _createSuper(Text);
            function Text() {
                var _this25;
                _classCallCheck(this, Text);
                _this25 = _super30.call(this);
                _this25._textWidth = 0;
                _this25._textHeight = 0;
                _this25._lines = [];
                _this25._lineWidths = [];
                _this25._startX = 0;
                _this25._startY = 0;
                _this25._charSize = {};
                _this25._valign = "top";
                _this25._fontSize = Text.defaultFontSize;
                _this25._font = Text.defaultFont;
                _this25._color = "#000000";
                _this25._singleCharRender = false;
                _this25.overflow = Text.VISIBLE;
                _this25._style = TextStyle.EMPTY;
                return _this25;
            }
            _createClass(Text, [{
                key: "getStyle",
                value: function getStyle() {
                    this._style === TextStyle.EMPTY && (this._style = TextStyle.create());
                    return this._style;
                }
            }, {
                key: "_getTextStyle",
                value: function _getTextStyle() {
                    if (this._style === TextStyle.EMPTY) {
                        this._style = TextStyle.create();
                    }
                    return this._style;
                }
            }, {
                key: "destroy",
                value: function destroy() {
                    var destroyChild = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
                    _get(_getPrototypeOf(Text.prototype), "destroy", this).call(this, destroyChild);
                    this._clipPoint = null;
                    this._lines = null;
                    this._lineWidths = null;
                    this._words && this._words.forEach(function (w) {
                        w.cleanCache();
                    });
                    this._words = null;
                    this._charSize = null;
                }
            }, {
                key: "_getBoundPointsM",
                value: function _getBoundPointsM() {
                    var ifRotate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    var rec = Rectangle.TEMP;
                    rec.setTo(0, 0, this.width, this.height);
                    return rec._getBoundPoints();
                }
            }, {
                key: "getGraphicBounds",
                value: function getGraphicBounds() {
                    var realSize = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
                    var rec = Rectangle.TEMP;
                    rec.setTo(0, 0, this.width, this.height);
                    return rec;
                }
            }, {
                key: "width",
                get: function get() {
                    if (this._width)
                        return this._width;
                    return this.textWidth + this.padding[1] + this.padding[3];
                },
                set: function set(value) {
                    if (value != this._width) {
                        _get(_getPrototypeOf(Text.prototype), "set_width", this).call(this, value);
                        this.isChanged = true;
                        if (this.borderColor) {
                            this._setBorderStyleColor(0, 0, this.width, this.height, this.borderColor, 1);
                        }
                    }
                }
            }, {
                key: "_getCSSStyle",
                value: function _getCSSStyle() {
                    return this._style;
                }
            }, {
                key: "height",
                get: function get() {
                    if (this._height)
                        return this._height;
                    return this.textHeight;
                },
                set: function set(value) {
                    if (value != this._height) {
                        _get(_getPrototypeOf(Text.prototype), "set_height", this).call(this, value);
                        this.isChanged = true;
                        if (this.borderColor) {
                            this._setBorderStyleColor(0, 0, this.width, this.height, this.borderColor, 1);
                        }
                    }
                }
            }, {
                key: "textWidth",
                get: function get() {
                    this._isChanged && ILaya.systemTimer.runCallLater(this, this.typeset);
                    return this._textWidth;
                }
            }, {
                key: "textHeight",
                get: function get() {
                    this._isChanged && ILaya.systemTimer.runCallLater(this, this.typeset);
                    return this._textHeight;
                }
            }, {
                key: "text",
                get: function get() {
                    return this._text || "";
                },
                set: function set(value) {
                    this.set_text(value);
                }
            }, {
                key: "get_text",
                value: function get_text() {
                    return this._text || "";
                }
            }, {
                key: "set_text",
                value: function set_text(value) {
                    if (this._text !== value) {
                        this.lang(value + "");
                        this.isChanged = true;
                        this.event(Event.CHANGE);
                        if (this.borderColor) {
                            this._setBorderStyleColor(0, 0, this.width, this.height, this.borderColor, 1);
                        }
                    }
                }
            }, {
                key: "lang",
                value: function lang(text) {
                    var arg1 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var arg2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var arg3 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var arg4 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
                    var arg5 = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
                    var arg6 = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
                    var arg7 = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
                    var arg8 = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : null;
                    var arg9 = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : null;
                    var arg10 = arguments.length > 10 && arguments[10] !== undefined ? arguments[10] : null;
                    text = Text.langPacks && Text.langPacks[text] ? Text.langPacks[text] : text;
                    if (arguments.length < 2) {
                        this._text = text;
                    } else {
                        for (var i = 0, n = arguments.length; i < n; i++) {
                            text = text.replace("{" + i + "}", arguments[i + 1]);
                        }
                        this._text = text;
                    }
                }
            }, {
                key: "font",
                get: function get() {
                    return this._font;
                },
                set: function set(value) {
                    if (this._style.currBitmapFont) {
                        this._getTextStyle().currBitmapFont = null;
                        this.scale(1, 1);
                    }
                    if (Text._bitmapFonts && Text._bitmapFonts[value]) {
                        this._getTextStyle().currBitmapFont = Text._bitmapFonts[value];
                    }
                    this._font = value;
                    this.isChanged = true;
                }
            }, {
                key: "fontSize",
                get: function get() {
                    return this._fontSize;
                },
                set: function set(value) {
                    if (this._fontSize != value) {
                        this._fontSize = value;
                        this.isChanged = true;
                    }
                }
            }, {
                key: "bold",
                get: function get() {
                    return this._style.bold;
                },
                set: function set(value) {
                    this._getTextStyle().bold = value;
                    this.isChanged = true;
                }
            }, {
                key: "color",
                get: function get() {
                    return this._color;
                },
                set: function set(value) {
                    this.set_color(value);
                }
            }, {
                key: "get_color",
                value: function get_color() {
                    return this._color;
                }
            }, {
                key: "set_color",
                value: function set_color(value) {
                    if (this._color != value) {
                        this._color = value;
                        if (!this._isChanged && this._graphics) {
                            this._graphics.replaceTextColor(this.color);
                        } else {
                            this.isChanged = true;
                        }
                    }
                }
            }, {
                key: "italic",
                get: function get() {
                    return this._style.italic;
                },
                set: function set(value) {
                    this._getTextStyle().italic = value;
                    this.isChanged = true;
                }
            }, {
                key: "align",
                get: function get() {
                    return this._style.align;
                },
                set: function set(value) {
                    this._getTextStyle().align = value;
                    this.isChanged = true;
                }
            }, {
                key: "valign",
                get: function get() {
                    return this._valign;
                },
                set: function set(value) {
                    this._valign = value;
                    this.isChanged = true;
                }
            }, {
                key: "wordWrap",
                get: function get() {
                    return this._style.wordWrap;
                },
                set: function set(value) {
                    this._getTextStyle().wordWrap = value;
                    this.isChanged = true;
                }
            }, {
                key: "leading",
                get: function get() {
                    return this._style.leading;
                },
                set: function set(value) {
                    this._getTextStyle().leading = value;
                    this.isChanged = true;
                }
            }, {
                key: "padding",
                get: function get() {
                    return this._style.padding;
                },
                set: function set(value) {
                    if (typeof value == 'string') {
                        var arr;
                        arr = value.split(",");
                        var i, len;
                        len = arr.length;
                        while (arr.length < 4) {
                            arr.push(0);
                        }
                        for (i = 0; i < len; i++) {
                            arr[i] = parseFloat(arr[i]) || 0;
                        }
                        value = arr;
                    }
                    this._getTextStyle().padding = value;
                    this.isChanged = true;
                }
            }, {
                key: "bgColor",
                get: function get() {
                    return this._style.bgColor;
                },
                set: function set(value) {
                    this.set_bgColor(value);
                }
            }, {
                key: "set_bgColor",
                value: function set_bgColor(value) {
                    this._getTextStyle().bgColor = value;
                    this._renderType |= SpriteConst.STYLE;
                    this._setBgStyleColor(0, 0, this.width, this.height, value);
                    this._setRenderType(this._renderType);
                    this.isChanged = true;
                }
            }, {
                key: "get_bgColor",
                value: function get_bgColor() {
                    return this._style.bgColor;
                }
            }, {
                key: "borderColor",
                get: function get() {
                    return this._style.borderColor;
                },
                set: function set(value) {
                    this._getTextStyle().borderColor = value;
                    this._renderType |= SpriteConst.STYLE;
                    this._setBorderStyleColor(0, 0, this.width, this.height, value, 1);
                    this._setRenderType(this._renderType);
                    this.isChanged = true;
                }
            }, {
                key: "stroke",
                get: function get() {
                    return this._style.stroke;
                },
                set: function set(value) {
                    this._getTextStyle().stroke = value;
                    this.isChanged = true;
                }
            }, {
                key: "strokeColor",
                get: function get() {
                    return this._style.strokeColor;
                },
                set: function set(value) {
                    this._getTextStyle().strokeColor = value;
                    this.isChanged = true;
                }
            }, {
                key: "isChanged",
                set: function set(value) {
                    if (this._isChanged !== value) {
                        this._isChanged = value;
                        value && ILaya.systemTimer.callLater(this, this.typeset);
                    }
                }
            }, {
                key: "_getContextFont",
                value: function _getContextFont() {
                    return (this.italic ? "italic " : "") + (this.bold ? "bold " : "") + this.fontSize + "px " + (ILaya.Browser.onIPhone ? Text.fontFamilyMap[this.font] || this.font : this.font);
                }
            }, {
                key: "_isPassWordMode",
                value: function _isPassWordMode() {
                    var style = this._style;
                    var password = style.asPassword;
                    if ("prompt" in this && this['prompt'] == this._text)
                        password = false;
                    return password;
                }
            }, {
                key: "_getPassWordTxt",
                value: function _getPassWordTxt(txt) {
                    var len = txt.length;
                    var word;
                    word = "";
                    for (var j = len; j > 0; j--) {
                        word += "●";
                    }
                    return word;
                }
            }, {
                key: "_renderText",
                value: function _renderText() {
                    var padding = this.padding;
                    var visibleLineCount = this._lines.length;
                    if (this.overflow != Text.VISIBLE) {
                        visibleLineCount = Math.min(visibleLineCount, Math.floor((this.height - padding[0] - padding[2]) / (this.leading + this._charSize.height)) + 1);
                    }
                    var beginLine = this.scrollY / (this._charSize.height + this.leading) | 0;
                    var graphics = this.graphics;
                    graphics.clear(true);
                    var ctxFont = this._getContextFont();
                    ILaya.Browser.context.font = ctxFont;
                    var startX = padding[3];
                    var textAlgin = "left";
                    var lines = this._lines;
                    var lineHeight = this.leading + this._charSize.height;
                    var tCurrBitmapFont = this._style.currBitmapFont;
                    if (tCurrBitmapFont) {
                        lineHeight = this.leading + tCurrBitmapFont.getMaxHeight();
                    }
                    var startY = padding[0];
                    if (!tCurrBitmapFont && this._width > 0 && this._textWidth <= this._width) {
                        if (this.align == "right") {
                            textAlgin = "right";
                            startX = this._width - padding[1];
                        } else if (this.align == "center") {
                            textAlgin = "center";
                            startX = this._width * 0.5 + padding[3] - padding[1];
                        }
                    }
                    if (this._height > 0) {
                        var tempVAlign = this._textHeight > this._height ? "top" : this.valign;
                        if (tempVAlign === "middle")
                            startY = (this._height - visibleLineCount * lineHeight) * 0.5 + padding[0] - padding[2];
                        else if (tempVAlign === "bottom")
                            startY = this._height - visibleLineCount * lineHeight - padding[2];
                    }
                    var style = this._style;
                    if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize) {
                        var bitmapScale = tCurrBitmapFont.fontSize / this.fontSize;
                    }
                    if (this._clipPoint) {
                        graphics.save();
                        if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize) {
                            var tClipWidth;
                            var tClipHeight;
                            this._width ? tClipWidth = this._width - padding[3] - padding[1] : tClipWidth = this._textWidth;
                            this._height ? tClipHeight = this._height - padding[0] - padding[2] : tClipHeight = this._textHeight;
                            tClipWidth *= bitmapScale;
                            tClipHeight *= bitmapScale;
                            graphics.clipRect(padding[3], padding[0], tClipWidth, tClipHeight);
                        } else {
                            graphics.clipRect(padding[3], padding[0], this._width ? this._width - padding[3] - padding[1] : this._textWidth, this._height ? this._height - padding[0] - padding[2] : this._textHeight);
                        }
                        this.repaint();
                    }
                    var password = style.asPassword;
                    if ("prompt" in this && this['prompt'] == this._text)
                        password = false;
                    var x = 0
                        , y = 0;
                    var end = Math.min(this._lines.length, visibleLineCount + beginLine) || 1;
                    for (var i = beginLine; i < end; i++) {
                        var word = lines[i];
                        var _word;
                        if (password) {
                            var len = word.length;
                            word = "";
                            for (var j = len; j > 0; j--) {
                                word += "●";
                            }
                        }
                        if (word == null)
                            word = "";
                        x = startX - (this._clipPoint ? this._clipPoint.x : 0);
                        y = startY + lineHeight * i - (this._clipPoint ? this._clipPoint.y : 0);
                        this.underline && this._drawUnderline(textAlgin, x, y, i);
                        if (tCurrBitmapFont) {
                            var tWidth = this.width;
                            if (tCurrBitmapFont.autoScaleSize) {
                                tWidth = this.width * bitmapScale;
                            }
                            tCurrBitmapFont._drawText(word, this, x, y, this.align, tWidth);
                        } else {
                            this._words || (this._words = []);
                            if (this._words.length > i - beginLine) {
                                _word = this._words[i - beginLine];
                            } else {
                                _word = new WordText();
                                this._words.push(_word);
                            }
                            _word.setText(word);
                            _word.splitRender = this._singleCharRender;
                            style.stroke ? graphics.fillBorderText(_word, x, y, ctxFont, this.color, style.strokeColor, style.stroke, textAlgin) : graphics.fillText(_word, x, y, ctxFont, this.color, textAlgin);
                        }
                    }
                    if (tCurrBitmapFont && tCurrBitmapFont.autoScaleSize) {
                        var tScale = 1 / bitmapScale;
                        this.scale(tScale, tScale);
                    }
                    if (this._clipPoint)
                        graphics.restore();
                    this._startX = startX;
                    this._startY = startY;
                }
            }, {
                key: "_drawUnderline",
                value: function _drawUnderline(align, x, y, lineIndex) {
                    var lineWidth = this._lineWidths[lineIndex];
                    switch (align) {
                        case 'center':
                            x -= lineWidth / 2;
                            break;
                        case 'right':
                            x -= lineWidth;
                            break;
                        case 'left':
                        default:
                            break;
                    }
                    y += this._charSize.height;
                    this._graphics.drawLine(x, y, x + lineWidth, y, this.underlineColor || this.color, 1);
                }
            }, {
                key: "typeset",
                value: function typeset() {
                    this._isChanged = false;
                    if (!this._text) {
                        this._clipPoint = null;
                        this._textWidth = this._textHeight = 0;
                        this.graphics.clear(true);
                        return;
                    }
                    if (ILaya.Render.isConchApp) {
                        window.conchTextCanvas.font = this._getContextFont();
                    } else {
                        ILaya.Browser.context.font = this._getContextFont();
                    }
                    this._lines.length = 0;
                    this._lineWidths.length = 0;
                    if (this._isPassWordMode()) {
                        this._parseLines(this._getPassWordTxt(this._text));
                    } else
                        this._parseLines(this._text);
                    this._evalTextSize();
                    if (this._checkEnabledViewportOrNot())
                        this._clipPoint || (this._clipPoint = new Point(0, 0));
                    else
                        this._clipPoint = null;
                    this._renderText();
                }
            }, {
                key: "_evalTextSize",
                value: function _evalTextSize() {
                    var nw, nh;
                    nw = Math.max.apply(this, this._lineWidths);
                    if (this._style.currBitmapFont)
                        nh = this._lines.length * (this._style.currBitmapFont.getMaxHeight() + this.leading) + this.padding[0] + this.padding[2];
                    else
                        nh = this._lines.length * (this._charSize.height + this.leading) + this.padding[0] + this.padding[2];
                    if (nw != this._textWidth || nh != this._textHeight) {
                        this._textWidth = nw;
                        this._textHeight = nh;
                    }
                }
            }, {
                key: "_checkEnabledViewportOrNot",
                value: function _checkEnabledViewportOrNot() {
                    return this.overflow == Text.SCROLL && (this._width > 0 && this._textWidth > this._width || this._height > 0 && this._textHeight > this._height);
                }
            }, {
                key: "changeText",
                value: function changeText(text) {
                    if (this._text !== text) {
                        this.lang(text + "");
                        if (this._graphics && this._graphics.replaceText(this._text))
                            ;
                        else {
                            this.typeset();
                        }
                    }
                }
            }, {
                key: "_parseLines",
                value: function _parseLines(text) {
                    var needWordWrapOrTruncate = this.wordWrap || this.overflow == Text.HIDDEN;
                    if (needWordWrapOrTruncate) {
                        var wordWrapWidth = this._getWordWrapWidth();
                    }
                    var bitmapFont = this._style.currBitmapFont;
                    if (bitmapFont) {
                        this._charSize.width = bitmapFont.getMaxWidth();
                        this._charSize.height = bitmapFont.getMaxHeight();
                    } else {
                        var measureResult = null;
                        if (ILaya.Render.isConchApp) {
                            measureResult = window.conchTextCanvas.measureText(Text._testWord);
                        } else {
                            measureResult = ILaya.Browser.context.measureText(Text._testWord);
                        }
                        if (!measureResult)
                            measureResult = {
                                width: 100
                            };
                        this._charSize.width = measureResult.width;
                        this._charSize.height = measureResult.height || this.fontSize;
                    }
                    var lines = text.replace(/\r\n/g, "\n").split("\n");
                    for (var i = 0, n = lines.length; i < n; i++) {
                        var line = lines[i];
                        if (needWordWrapOrTruncate)
                            this._parseLine(line, wordWrapWidth);
                        else {
                            this._lineWidths.push(this._getTextWidth(line));
                            this._lines.push(line);
                        }
                    }
                }
            }, {
                key: "_parseLine",
                value: function _parseLine(line, wordWrapWidth) {
                    var lines = this._lines;
                    var maybeIndex = 0;
                    var charsWidth = 0;
                    var wordWidth = 0;
                    var startIndex = 0;
                    charsWidth = this._getTextWidth(line);
                    if (charsWidth <= wordWrapWidth) {
                        lines.push(line);
                        this._lineWidths.push(charsWidth);
                        return;
                    }
                    charsWidth = this._charSize.width;
                    maybeIndex = Math.floor(wordWrapWidth / charsWidth);
                    maybeIndex == 0 && (maybeIndex = 1);
                    charsWidth = this._getTextWidth(line.substring(0, maybeIndex));
                    wordWidth = charsWidth;
                    for (var j = maybeIndex, m = line.length; j < m; j++) {
                        charsWidth = this._getTextWidth(line.charAt(j));
                        wordWidth += charsWidth;
                        if (wordWidth > wordWrapWidth) {
                            if (this.wordWrap) {
                                var newLine = line.substring(startIndex, j);
                                if (newLine.charCodeAt(newLine.length - 1) < 255) {
                                    var execResult = /(?:\w|-)+$/.exec(newLine);
                                    if (execResult) {
                                        j = execResult.index + startIndex;
                                        if (execResult.index == 0)
                                            j += newLine.length;
                                        else
                                            newLine = line.substring(startIndex, j);
                                    }
                                }
                                lines.push(newLine);
                                this._lineWidths.push(wordWidth - charsWidth);
                                startIndex = j;
                                if (j + maybeIndex < m) {
                                    j += maybeIndex;
                                    charsWidth = this._getTextWidth(line.substring(startIndex, j));
                                    wordWidth = charsWidth;
                                    j--;
                                } else {
                                    lines.push(line.substring(startIndex, m));
                                    this._lineWidths.push(this._getTextWidth(lines[lines.length - 1]));
                                    startIndex = -1;
                                    break;
                                }
                            } else if (this.overflow == Text.HIDDEN) {
                                lines.push(line.substring(0, j));
                                this._lineWidths.push(this._getTextWidth(lines[lines.length - 1]));
                                return;
                            }
                        }
                    }
                    if (this.wordWrap && startIndex != -1) {
                        lines.push(line.substring(startIndex, m));
                        this._lineWidths.push(this._getTextWidth(lines[lines.length - 1]));
                    }
                }
            }, {
                key: "_getTextWidth",
                value: function _getTextWidth(text) {
                    var bitmapFont = this._style.currBitmapFont;
                    if (bitmapFont)
                        return bitmapFont.getTextWidth(text);
                    else {
                        if (ILaya.Render.isConchApp) {
                            return window.conchTextCanvas.measureText(text).width;
                        } else {
                            var ret = ILaya.Browser.context.measureText(text) || {
                                width: 100
                            };
                            return ret.width;
                        }
                    }
                }
            }, {
                key: "_getWordWrapWidth",
                value: function _getWordWrapWidth() {
                    var p = this.padding;
                    var w;
                    var bitmapFont = this._style.currBitmapFont;
                    if (bitmapFont && bitmapFont.autoScaleSize)
                        w = this._width * (bitmapFont.fontSize / this.fontSize);
                    else
                        w = this._width;
                    if (w <= 0) {
                        w = this.wordWrap ? 100 : ILaya.Browser.width;
                    }
                    w <= 0 && (w = 100);
                    return w - p[3] - p[1];
                }
            }, {
                key: "getCharPoint",
                value: function getCharPoint(charIndex) {
                    var out = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    this._isChanged && ILaya.systemTimer.runCallLater(this, this.typeset);
                    var len = 0
                        , lines = this._lines
                        , startIndex = 0;
                    for (var i = 0, n = lines.length; i < n; i++) {
                        len += lines[i].length;
                        if (charIndex < len) {
                            var line = i;
                            break;
                        }
                        startIndex = len;
                    }
                    var ctxFont = (this.italic ? "italic " : "") + (this.bold ? "bold " : "") + this.fontSize + "px " + this.font;
                    ILaya.Browser.context.font = ctxFont;
                    var width = this._getTextWidth(this._text.substring(startIndex, charIndex));
                    var point = out || new Point();
                    return point.setTo(this._startX + width - (this._clipPoint ? this._clipPoint.x : 0), this._startY + line * (this._charSize.height + this.leading) - (this._clipPoint ? this._clipPoint.y : 0));
                }
            }, {
                key: "scrollX",
                get: function get() {
                    if (!this._clipPoint)
                        return 0;
                    return this._clipPoint.x;
                },
                set: function set(value) {
                    if (this.overflow != Text.SCROLL || this.textWidth < this._width || !this._clipPoint)
                        return;
                    value = value < this.padding[3] ? this.padding[3] : value;
                    var maxScrollX = this._textWidth - this._width;
                    value = value > maxScrollX ? maxScrollX : value;
                    this._clipPoint.x = value;
                    this._renderText();
                }
            }, {
                key: "scrollY",
                get: function get() {
                    if (!this._clipPoint)
                        return 0;
                    return this._clipPoint.y;
                },
                set: function set(value) {
                    if (this.overflow != Text.SCROLL || this.textHeight < this._height || !this._clipPoint)
                        return;
                    value = value < this.padding[0] ? this.padding[0] : value;
                    var maxScrollY = this._textHeight - this._height;
                    value = value > maxScrollY ? maxScrollY : value;
                    this._clipPoint.y = value;
                    this._renderText();
                }
            }, {
                key: "maxScrollX",
                get: function get() {
                    return this.textWidth < this._width ? 0 : this._textWidth - this._width;
                }
            }, {
                key: "maxScrollY",
                get: function get() {
                    return this.textHeight < this._height ? 0 : this._textHeight - this._height;
                }
            }, {
                key: "lines",
                get: function get() {
                    if (this._isChanged)
                        this.typeset();
                    return this._lines;
                }
            }, {
                key: "underlineColor",
                get: function get() {
                    return this._style.underlineColor;
                },
                set: function set(value) {
                    this._getTextStyle().underlineColor = value;
                    if (!this._isChanged)
                        this._renderText();
                }
            }, {
                key: "underline",
                get: function get() {
                    return this._style.underline;
                },
                set: function set(value) {
                    this._getTextStyle().underline = value;
                }
            }, {
                key: "singleCharRender",
                get: function get() {
                    return this._singleCharRender;
                },
                set: function set(value) {
                    this._singleCharRender = value;
                }
            }], [{
                key: "defaultFontStr",
                value: function defaultFontStr() {
                    return Text.defaultFontSize + "px " + Text.defaultFont;
                }
            }, {
                key: "registerBitmapFont",
                value: function registerBitmapFont(name, bitmapFont) {
                    Text._bitmapFonts || (Text._bitmapFonts = {});
                    Text._bitmapFonts[name] = bitmapFont;
                }
            }, {
                key: "unregisterBitmapFont",
                value: function unregisterBitmapFont(name) {
                    var destroy = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
                    if (Text._bitmapFonts && Text._bitmapFonts[name]) {
                        var tBitmapFont = Text._bitmapFonts[name];
                        if (destroy)
                            tBitmapFont.destroy();
                        delete Text._bitmapFonts[name];
                    }
                }
            }]);
            return Text;
        }(Sprite);
    Text.VISIBLE = "visible";
    Text.SCROLL = "scroll";
    Text.HIDDEN = "hidden";
    Text.defaultFontSize = 12;
    Text.defaultFont = "Arial";
    Text.isComplexText = false;
    Text.fontFamilyMap = {
        "报隶": "报隶-简",
        "黑体": "黑体-简",
        "楷体": "楷体-简",
        "兰亭黑": "兰亭黑-简",
        "隶变": "隶变-简",
        "凌慧体": "凌慧体-简",
        "翩翩体": "翩翩体-简",
        "苹方": "苹方-简",
        "手札体": "手札体-简",
        "宋体": "宋体-简",
        "娃娃体": "娃娃体-简",
        "魏碑": "魏碑-简",
        "行楷": "行楷-简",
        "雅痞": "雅痞-简",
        "圆体": "圆体-简"
    };
    Text._testWord = "游";
    Text.CharacterCache = true;
    Text.RightToLeft = false;
    ILaya.regClass(Text);
    ClassUtils.regClass("laya.display.Text", Text);
    ClassUtils.regClass("Laya.Text", Text);
    var Input = /*#__PURE__*/
        function (_Text) {
            _inherits(Input, _Text);
            var _super31 = _createSuper(Input);
            function Input() {
                var _this26;
                _classCallCheck(this, Input);
                _this26 = _super31.call(this);
                _this26._multiline = false;
                _this26._editable = true;
                _this26._maxChars = 1E5;
                _this26._type = "text";
                _this26._prompt = '';
                _this26._promptColor = "#A9A9A9";
                _this26._originColor = "#000000";
                _this26._content = '';
                Input.IOS_IFRAME = ILaya.Browser.onIOS && ILaya.Browser.window.top != ILaya.Browser.window.self;
                _this26._width = 100;
                _this26._height = 20;
                _this26.multiline = false;
                _this26.overflow = Text.SCROLL;
                _this26.on(Event.MOUSE_DOWN, _assertThisInitialized(_this26), _this26._onMouseDown);
                _this26.on(Event.UNDISPLAY, _assertThisInitialized(_this26), _this26._onUnDisplay);
                return _this26;
            }
            _createClass(Input, [{
                key: "setSelection",
                value: function setSelection(startIndex, endIndex) {
                    this.focus = true;
                    Input.inputElement.selectionStart = startIndex;
                    Input.inputElement.selectionEnd = endIndex;
                }
            }, {
                key: "multiline",
                get: function get() {
                    return this._multiline;
                },
                set: function set(value) {
                    this._multiline = value;
                    this.valign = value ? "top" : "middle";
                }
            }, {
                key: "nativeInput",
                get: function get() {
                    return this._multiline ? Input.area : Input.input;
                }
            }, {
                key: "_onUnDisplay",
                value: function _onUnDisplay() {
                    var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    this.focus = false;
                }
            }, {
                key: "_onMouseDown",
                value: function _onMouseDown(e) {
                    this.focus = true;
                }
            }, {
                key: "_syncInputTransform",
                value: function _syncInputTransform() {
                    var inputElement = this.nativeInput;
                    var transform = Utils.getTransformRelativeToWindow(this, this.padding[3], this.padding[0]);
                    var inputWid = this._width - this.padding[1] - this.padding[3];
                    var inputHei = this._height - this.padding[0] - this.padding[2];
                    if (ILaya.Render.isConchApp) {
                        inputElement.setScale(transform.scaleX, transform.scaleY);
                        inputElement.setSize(inputWid, inputHei);
                        inputElement.setPos(transform.x, transform.y);
                    } else {
                        Input.inputContainer.style.transform = Input.inputContainer.style.webkitTransform = "scale(" + transform.scaleX + "," + transform.scaleY + ") rotate(" + ILaya.stage.canvasDegree + "deg)";
                        inputElement.style.width = inputWid + 'px';
                        inputElement.style.height = inputHei + 'px';
                        Input.inputContainer.style.left = transform.x + 'px';
                        Input.inputContainer.style.top = transform.y + 'px';
                    }
                }
            }, {
                key: "select",
                value: function select() {
                    this.nativeInput.select();
                }
            }, {
                key: "focus",
                get: function get() {
                    return this._focus;
                },
                set: function set(value) {
                    var input = this.nativeInput;
                    if (this._focus !== value) {
                        if (value) {
                            if (input.target) {
                                input.target._focusOut();
                            } else {
                                this._setInputMethod();
                            }
                            input.target = this;
                            this._focusIn();
                        } else {
                            input.target = null;
                            this._focusOut();
                            ILaya.Browser.document.body.scrollTop = 0;
                            input.blur();
                            if (ILaya.Render.isConchApp)
                                input.setPos(-10000, -10000);
                            else if (Input.inputContainer.contains(input))
                                Input.inputContainer.removeChild(input);
                        }
                    }
                }
            }, {
                key: "_setInputMethod",
                value: function _setInputMethod() {
                    Input.input.parentElement && Input.inputContainer.removeChild(Input.input);
                    Input.area.parentElement && Input.inputContainer.removeChild(Input.area);
                    Input.inputElement = this._multiline ? Input.area : Input.input;
                    Input.inputContainer.appendChild(Input.inputElement);
                    if (Text.RightToLeft) {
                        Input.inputElement.style.direction = "rtl";
                    }
                }
            }, {
                key: "_focusIn",
                value: function _focusIn() {
                    Input.isInputting = true;
                    var input = this.nativeInput;
                    this._focus = true;
                    var cssStyle = input.style;
                    cssStyle.whiteSpace = this.wordWrap ? "pre-wrap" : "nowrap";
                    this._setPromptColor();
                    input.readOnly = !this._editable;
                    if (ILaya.Render.isConchApp) {
                        input.setType(this._type);
                        input.setForbidEdit(!this._editable);
                    }
                    input.maxLength = this._maxChars;
                    var padding = this.padding;
                    input.value = this._content;
                    input.placeholder = this._prompt;
                    ILaya.stage.off(Event.KEY_DOWN, this, this._onKeyDown);
                    ILaya.stage.on(Event.KEY_DOWN, this, this._onKeyDown);
                    ILaya.stage.focus = this;
                    this.event(Event.FOCUS);
                    if (ILaya.Browser.onPC)
                        input.focus();
                    if (!ILaya.Browser.onMiniGame && !ILaya.Browser.onBDMiniGame && !ILaya.Browser.onQGMiniGame && !ILaya.Browser.onKGMiniGame && !ILaya.Browser.onVVMiniGame && !ILaya.Browser.onAlipayMiniGame && !ILaya.Browser.onQQMiniGame && !ILaya.Browser.onBLMiniGame) {
                        var temp = this._text;
                        this._text = null;
                    }
                    this.typeset();
                    input.setColor(this._originColor);
                    input.setFontSize(this.fontSize);
                    input.setFontFace(ILaya.Browser.onIPhone ? Text.fontFamilyMap[this.font] || this.font : this.font);
                    if (ILaya.Render.isConchApp) {
                        input.setMultiAble && input.setMultiAble(this._multiline);
                    }
                    cssStyle.lineHeight = this.leading + this.fontSize + "px";
                    cssStyle.fontStyle = this.italic ? "italic" : "normal";
                    cssStyle.fontWeight = this.bold ? "bold" : "normal";
                    cssStyle.textAlign = this.align;
                    cssStyle.padding = "0 0";
                    this._syncInputTransform();
                    if (!ILaya.Render.isConchApp && ILaya.Browser.onPC)
                        ILaya.systemTimer.frameLoop(1, this, this._syncInputTransform);
                }
            }, {
                key: "_setPromptColor",
                value: function _setPromptColor() {
                    Input.promptStyleDOM = ILaya.Browser.getElementById("promptStyle");
                    if (!Input.promptStyleDOM) {
                        Input.promptStyleDOM = ILaya.Browser.createElement("style");
                        Input.promptStyleDOM.setAttribute("id", "promptStyle");
                        ILaya.Browser.document.head.appendChild(Input.promptStyleDOM);
                    }
                    Input.promptStyleDOM.innerText = "input::-webkit-input-placeholder, textarea::-webkit-input-placeholder {" + "color:" + this._promptColor + "}" + "input:-moz-placeholder, textarea:-moz-placeholder {" + "color:" + this._promptColor + "}" + "input::-moz-placeholder, textarea::-moz-placeholder {" + "color:" + this._promptColor + "}" + "input:-ms-input-placeholder, textarea:-ms-input-placeholder {" + "color:" + this._promptColor + "}";
                }
            }, {
                key: "_focusOut",
                value: function _focusOut() {
                    if (!Input.isInputting)
                        return;
                    Input.isInputting = false;
                    this._focus = false;
                    this._text = null;
                    this._content = this.nativeInput.value;
                    if (!this._content) {
                        _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, this._prompt);
                        _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this._promptColor);
                    } else {
                        _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, this._content);
                        _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this._originColor);
                    }
                    ILaya.stage.off(Event.KEY_DOWN, this, this._onKeyDown);
                    ILaya.stage.focus = null;
                    this.event(Event.BLUR);
                    this.event(Event.CHANGE);
                    if (ILaya.Render.isConchApp)
                        this.nativeInput.blur();
                    ILaya.Browser.onPC && ILaya.systemTimer.clear(this, this._syncInputTransform);
                }
            }, {
                key: "_onKeyDown",
                value: function _onKeyDown(e) {
                    if (e.keyCode === 13) {
                        if (ILaya.Browser.onMobile && !this._multiline)
                            this.focus = false;
                        this.event(Event.ENTER);
                    }
                }
            }, {
                key: "text",
                get: function get() {
                    if (this._focus)
                        return this.nativeInput.value;
                    else
                        return this._content || "";
                },
                set: function set(value) {
                    _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this._originColor);
                    value += '';
                    if (this._focus) {
                        this.nativeInput.value = value || '';
                        this.event(Event.CHANGE);
                    } else {
                        if (!this._multiline)
                            value = value.replace(/\r?\n/g, '');
                        this._content = value;
                        if (value)
                            _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, value);
                        else {
                            _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, this._prompt);
                            _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this.promptColor);
                        }
                    }
                }
            }, {
                key: "changeText",
                value: function changeText(text) {
                    this._content = text;
                    if (this._focus) {
                        this.nativeInput.value = text || '';
                        this.event(Event.CHANGE);
                    } else
                        _get(_getPrototypeOf(Input.prototype), "changeText", this).call(this, text);
                }
            }, {
                key: "color",
                get: function get() {
                    return _get(_getPrototypeOf(Input.prototype), "color", this);
                },
                set: function set(value) {
                    if (this._focus)
                        this.nativeInput.setColor(value);
                    _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this._content ? value : this._promptColor);
                    this._originColor = value;
                }
            }, {
                key: "bgColor",
                get: function get() {
                    return _get(_getPrototypeOf(Input.prototype), "bgColor", this);
                },
                set: function set(value) {
                    _get(_getPrototypeOf(Input.prototype), "set_bgColor", this).call(this, value);
                    if (ILaya.Render.isConchApp)
                        this.nativeInput.setBgColor(value);
                }
            }, {
                key: "restrict",
                get: function get() {
                    if (this._restrictPattern) {
                        return this._restrictPattern.source;
                    }
                    return "";
                },
                set: function set(pattern) {
                    if (pattern) {
                        pattern = "[^" + pattern + "]";
                        if (pattern.indexOf("^^") > -1)
                            pattern = pattern.replace("^^", "");
                        this._restrictPattern = new RegExp(pattern, "g");
                    } else
                        this._restrictPattern = null;
                }
            }, {
                key: "editable",
                get: function get() {
                    return this._editable;
                },
                set: function set(value) {
                    this._editable = value;
                    if (ILaya.Render.isConchApp) {
                        Input.input.setForbidEdit(!value);
                    }
                }
            }, {
                key: "maxChars",
                get: function get() {
                    return this._maxChars;
                },
                set: function set(value) {
                    if (value <= 0)
                        value = 1E5;
                    this._maxChars = value;
                }
            }, {
                key: "prompt",
                get: function get() {
                    return this._prompt;
                },
                set: function set(value) {
                    if (!this._text && value)
                        _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, this._promptColor);
                    this.promptColor = this._promptColor;
                    if (this._text)
                        _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, this._text == this._prompt ? value : this._text);
                    else
                        _get(_getPrototypeOf(Input.prototype), "set_text", this).call(this, value);
                    this._prompt = Text.langPacks && Text.langPacks[value] ? Text.langPacks[value] : value;
                }
            }, {
                key: "promptColor",
                get: function get() {
                    return this._promptColor;
                },
                set: function set(value) {
                    this._promptColor = value;
                    if (!this._content)
                        _get(_getPrototypeOf(Input.prototype), "set_color", this).call(this, value);
                }
            }, {
                key: "type",
                get: function get() {
                    return this._type;
                },
                set: function set(value) {
                    if (value === "password")
                        this._getTextStyle().asPassword = true;
                    else
                        this._getTextStyle().asPassword = false;
                    this._type = value;
                }
            }], [{
                key: "__init__",
                value: function __init__() {
                    Input._createInputElement();
                    if (ILaya.Browser.onMobile) {
                        var isTrue = false;
                        if (ILaya.Browser.onMiniGame || ILaya.Browser.onBDMiniGame || ILaya.Browser.onQGMiniGame || ILaya.Browser.onKGMiniGame || ILaya.Browser.onVVMiniGame || ILaya.Browser.onAlipayMiniGame || ILaya.Browser.onQQMiniGame || ILaya.Browser.onBLMiniGame) {
                            isTrue = true;
                        }
                        ILaya.Render.canvas.addEventListener(Input.IOS_IFRAME ? isTrue ? "touchend" : "click" : "touchend", Input._popupInputMethod);
                    }
                }
            }, {
                key: "_popupInputMethod",
                value: function _popupInputMethod(e) {
                    if (!Input.isInputting)
                        return;
                    var input = Input.inputElement;
                    input.focus();
                }
            }, {
                key: "_createInputElement",
                value: function _createInputElement() {
                    Input._initInput(Input.area = ILaya.Browser.createElement("textarea"));
                    Input._initInput(Input.input = ILaya.Browser.createElement("input"));
                    Input.inputContainer = ILaya.Browser.createElement("div");
                    Input.inputContainer.style.position = "absolute";
                    Input.inputContainer.style.zIndex = 1E5;
                    ILaya.Browser.container.appendChild(Input.inputContainer);
                    Input.inputContainer.setPos = function (x, y) {
                        Input.inputContainer.style.left = x + 'px';
                        Input.inputContainer.style.top = y + 'px';
                    }
                        ;
                }
            }, {
                key: "_initInput",
                value: function _initInput(input) {
                    var style = input.style;
                    style.cssText = "position:absolute;overflow:hidden;resize:none;transform-origin:0 0;-webkit-transform-origin:0 0;-moz-transform-origin:0 0;-o-transform-origin:0 0;";
                    style.resize = 'none';
                    style.backgroundColor = 'transparent';
                    style.border = 'none';
                    style.outline = 'none';
                    style.zIndex = 1;
                    input.addEventListener('input', Input._processInputting);
                    input.addEventListener('mousemove', Input._stopEvent);
                    input.addEventListener('mousedown', Input._stopEvent);
                    input.addEventListener('touchmove', Input._stopEvent);
                    input.setFontFace = function (fontFace) {
                        input.style.fontFamily = fontFace;
                    }
                        ;
                    if (!ILaya.Render.isConchApp) {
                        input.setColor = function (color) {
                            input.style.color = color;
                        }
                            ;
                        input.setFontSize = function (fontSize) {
                            input.style.fontSize = fontSize + 'px';
                        }
                            ;
                    }
                }
            }, {
                key: "_processInputting",
                value: function _processInputting(e) {
                    var input = Input.inputElement.target;
                    if (!input)
                        return;
                    var value = Input.inputElement.value;
                    if (input._restrictPattern) {
                        value = value.replace(/\u2006|\x27/g, "");
                        if (input._restrictPattern.test(value)) {
                            value = value.replace(input._restrictPattern, "");
                            Input.inputElement.value = value;
                        }
                    }
                    input._text = value;
                    input.event(Event.INPUT);
                }
            }, {
                key: "_stopEvent",
                value: function _stopEvent(e) {
                    if (e.type == 'touchmove')
                        e.preventDefault();
                    e.stopPropagation && e.stopPropagation();
                }
            }]);
            return Input;
        }(Text);
    Input.TYPE_TEXT = "text";
    Input.TYPE_PASSWORD = "password";
    Input.TYPE_EMAIL = "email";
    Input.TYPE_URL = "url";
    Input.TYPE_NUMBER = "number";
    Input.TYPE_RANGE = "range";
    Input.TYPE_DATE = "date";
    Input.TYPE_MONTH = "month";
    Input.TYPE_WEEK = "week";
    Input.TYPE_TIME = "time";
    Input.TYPE_DATE_TIME = "datetime";
    Input.TYPE_DATE_TIME_LOCAL = "datetime-local";
    Input.TYPE_SEARCH = "search";
    Input.IOS_IFRAME = false;
    Input.inputHeight = 45;
    Input.isInputting = false;
    ClassUtils.regClass("laya.display.Input", Input);
    ClassUtils.regClass("Laya.Input", Input);
    var TouchManager = /*#__PURE__*/
        function () {
            function TouchManager() {
                _classCallCheck(this, TouchManager);
                this.preOvers = [];
                this.preDowns = [];
                this.preRightDowns = [];
                this.enable = true;
                this._event = new Event();
                this._lastClickTime = 0;
            }
            _createClass(TouchManager, [{
                key: "_clearTempArrs",
                value: function _clearTempArrs() {
                    TouchManager._oldArr.length = 0;
                    TouchManager._newArr.length = 0;
                    TouchManager._tEleArr.length = 0;
                }
            }, {
                key: "getTouchFromArr",
                value: function getTouchFromArr(touchID, arr) {
                    var i, len;
                    len = arr.length;
                    var tTouchO;
                    for (i = 0; i < len; i++) {
                        tTouchO = arr[i];
                        if (tTouchO.id == touchID) {
                            return tTouchO;
                        }
                    }
                    return null;
                }
            }, {
                key: "removeTouchFromArr",
                value: function removeTouchFromArr(touchID, arr) {
                    var i;
                    for (i = arr.length - 1; i >= 0; i--) {
                        if (arr[i].id == touchID) {
                            arr.splice(i, 1);
                        }
                    }
                }
            }, {
                key: "createTouchO",
                value: function createTouchO(ele, touchID) {
                    var rst;
                    rst = Pool.getItem("TouchData") || {};
                    rst.id = touchID;
                    rst.tar = ele;
                    return rst;
                }
            }, {
                key: "onMouseDown",
                value: function onMouseDown(ele, touchID) {
                    var isLeft = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    if (!this.enable)
                        return;
                    var preO;
                    var tO;
                    var arrs;
                    preO = this.getTouchFromArr(touchID, this.preOvers);
                    arrs = this.getEles(ele, null, TouchManager._tEleArr);
                    if (!preO) {
                        tO = this.createTouchO(ele, touchID);
                        this.preOvers.push(tO);
                    } else {
                        preO.tar = ele;
                    }
                    if (Browser.onMobile)
                        this.sendEvents(arrs, Event.MOUSE_OVER);
                    var preDowns;
                    preDowns = isLeft ? this.preDowns : this.preRightDowns;
                    preO = this.getTouchFromArr(touchID, preDowns);
                    if (!preO) {
                        tO = this.createTouchO(ele, touchID);
                        preDowns.push(tO);
                    } else {
                        preO.tar = ele;
                    }
                    this.sendEvents(arrs, isLeft ? Event.MOUSE_DOWN : Event.RIGHT_MOUSE_DOWN);
                    this._clearTempArrs();
                }
            }, {
                key: "sendEvents",
                value: function sendEvents(eles, type) {
                    var i, len;
                    len = eles.length;
                    this._event._stoped = false;
                    var _target;
                    _target = eles[0];
                    for (i = 0; i < len; i++) {
                        var tE = eles[i];
                        if (tE.destroyed)
                            return;
                        tE.event(type, this._event.setTo(type, tE, _target));
                        if (this._event._stoped)
                            break;
                    }
                }
            }, {
                key: "getEles",
                value: function getEles(start) {
                    var end = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var rst = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    if (!rst) {
                        rst = [];
                    } else {
                        rst.length = 0;
                    }
                    while (start && start != end) {
                        rst.push(start);
                        start = start.parent;
                    }
                    return rst;
                }
            }, {
                key: "checkMouseOutAndOverOfMove",
                value: function checkMouseOutAndOverOfMove(eleNew, elePre) {
                    var touchID = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
                    if (elePre == eleNew)
                        return;
                    var tar;
                    var arrs;
                    var i, len;
                    if (elePre.contains(eleNew)) {
                        arrs = this.getEles(eleNew, elePre, TouchManager._tEleArr);
                        this.sendEvents(arrs, Event.MOUSE_OVER);
                    } else if (eleNew.contains(elePre)) {
                        arrs = this.getEles(elePre, eleNew, TouchManager._tEleArr);
                        this.sendEvents(arrs, Event.MOUSE_OUT);
                    } else {
                        arrs = TouchManager._tEleArr;
                        arrs.length = 0;
                        var oldArr;
                        oldArr = this.getEles(elePre, null, TouchManager._oldArr);
                        var newArr;
                        newArr = this.getEles(eleNew, null, TouchManager._newArr);
                        len = oldArr.length;
                        var tIndex;
                        for (i = 0; i < len; i++) {
                            tar = oldArr[i];
                            tIndex = newArr.indexOf(tar);
                            if (tIndex >= 0) {
                                newArr.splice(tIndex, newArr.length - tIndex);
                                break;
                            } else {
                                arrs.push(tar);
                            }
                        }
                        if (arrs.length > 0) {
                            this.sendEvents(arrs, Event.MOUSE_OUT);
                        }
                        if (newArr.length > 0) {
                            this.sendEvents(newArr, Event.MOUSE_OVER);
                        }
                    }
                }
            }, {
                key: "onMouseMove",
                value: function onMouseMove(ele, touchID) {
                    if (!this.enable)
                        return;
                    var preO;
                    preO = this.getTouchFromArr(touchID, this.preOvers);
                    var arrs;
                    if (!preO) {
                        arrs = this.getEles(ele, null, TouchManager._tEleArr);
                        this.sendEvents(arrs, Event.MOUSE_OVER);
                        this.preOvers.push(this.createTouchO(ele, touchID));
                    } else {
                        this.checkMouseOutAndOverOfMove(ele, preO.tar);
                        preO.tar = ele;
                        arrs = this.getEles(ele, null, TouchManager._tEleArr);
                    }
                    this.sendEvents(arrs, Event.MOUSE_MOVE);
                    this._clearTempArrs();
                }
            }, {
                key: "getLastOvers",
                value: function getLastOvers() {
                    TouchManager._tEleArr.length = 0;
                    if (this.preOvers.length > 0 && this.preOvers[0].tar) {
                        return this.getEles(this.preOvers[0].tar, null, TouchManager._tEleArr);
                    }
                    TouchManager._tEleArr.push(ILaya.stage);
                    return TouchManager._tEleArr;
                }
            }, {
                key: "stageMouseOut",
                value: function stageMouseOut() {
                    var lastOvers;
                    lastOvers = this.getLastOvers();
                    this.preOvers.length = 0;
                    this.sendEvents(lastOvers, Event.MOUSE_OUT);
                }
            }, {
                key: "onMouseUp",
                value: function onMouseUp(ele, touchID) {
                    var isLeft = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
                    if (!this.enable)
                        return;
                    var preO;
                    var arrs;
                    var oldArr;
                    var i, len;
                    var tar;
                    var sendArr;
                    var onMobile = Browser.onMobile;
                    arrs = this.getEles(ele, null, TouchManager._tEleArr);
                    this.sendEvents(arrs, isLeft ? Event.MOUSE_UP : Event.RIGHT_MOUSE_UP);
                    var preDowns;
                    preDowns = isLeft ? this.preDowns : this.preRightDowns;
                    preO = this.getTouchFromArr(touchID, preDowns);
                    if (!preO)
                        ;
                    else {
                        var isDouble;
                        var now = Browser.now();
                        isDouble = now - this._lastClickTime < 300;
                        this._lastClickTime = now;
                        if (ele == preO.tar) {
                            sendArr = arrs;
                        } else {
                            oldArr = this.getEles(preO.tar, null, TouchManager._oldArr);
                            sendArr = TouchManager._newArr;
                            sendArr.length = 0;
                            len = oldArr.length;
                            for (i = 0; i < len; i++) {
                                tar = oldArr[i];
                                if (arrs.indexOf(tar) >= 0) {
                                    sendArr.push(tar);
                                }
                            }
                        }
                        if (sendArr.length > 0) {
                            this.sendEvents(sendArr, isLeft ? Event.CLICK : Event.RIGHT_CLICK);
                        }
                        if (isLeft && isDouble) {
                            this.sendEvents(sendArr, Event.DOUBLE_CLICK);
                        }
                        this.removeTouchFromArr(touchID, preDowns);
                        preO.tar = null;
                        Pool.recover("TouchData", preO);
                    }
                    preO = this.getTouchFromArr(touchID, this.preOvers);
                    if (!preO)
                        ;
                    else {
                        if (onMobile) {
                            sendArr = this.getEles(preO.tar, null, sendArr);
                            if (sendArr && sendArr.length > 0) {
                                this.sendEvents(sendArr, Event.MOUSE_OUT);
                            }
                            this.removeTouchFromArr(touchID, this.preOvers);
                            preO.tar = null;
                            Pool.recover("TouchData", preO);
                        }
                    }
                    this._clearTempArrs();
                }
            }]);
            return TouchManager;
        }();
    TouchManager.I = new TouchManager();
    TouchManager._oldArr = [];
    TouchManager._newArr = [];
    TouchManager._tEleArr = [];
    var MouseManager = /*#__PURE__*/
        function () {
            function MouseManager() {
                _classCallCheck(this, MouseManager);
                this.mouseX = 0;
                this.mouseY = 0;
                this.disableMouseEvent = false;
                this.mouseDownTime = 0;
                this.mouseMoveAccuracy = 2;
                this._event = new Event();
                this._captureSp = null;
                this._captureChain = [];
                this._captureExlusiveMode = false;
                this._hitCaputreSp = false;
                this._point = new Point();
                this._rect = new Rectangle();
                this._lastMoveTimer = 0;
                this._prePoint = new Point();
                this._touchIDs = {};
                this._curTouchID = NaN;
                this._id = 1;
            }
            _createClass(MouseManager, [{
                key: "__init__",
                value: function __init__(stage, canvas) {
                    this._stage = stage;
                    var _this = this;
                    canvas.oncontextmenu = function (e) {
                        if (MouseManager.enabled)
                            return false;
                    }
                        ;
                    canvas.addEventListener('mousedown', function (e) {
                        if (MouseManager.enabled) {
                            if (!Browser.onIE)
                                e.cancelable && e.preventDefault();
                            _this.mouseDownTime = Browser.now();
                            _this.runEvent(e);
                        }
                    });
                    canvas.addEventListener('mouseup', function (e) {
                        if (MouseManager.enabled) {
                            e.cancelable && e.preventDefault();
                            _this.mouseDownTime = -Browser.now();
                            _this.runEvent(e);
                        }
                    }, true);
                    canvas.addEventListener('mousemove', function (e) {
                        if (MouseManager.enabled) {
                            e.cancelable && e.preventDefault();
                            var now = Browser.now();
                            if (now - _this._lastMoveTimer < 10)
                                return;
                            _this._lastMoveTimer = now;
                            _this.runEvent(e);
                        }
                    }, true);
                    canvas.addEventListener("mouseout", function (e) {
                        if (MouseManager.enabled)
                            _this.runEvent(e);
                    });
                    canvas.addEventListener("mouseover", function (e) {
                        if (MouseManager.enabled)
                            _this.runEvent(e);
                    });
                    canvas.addEventListener("touchstart", function (e) {
                        if (MouseManager.enabled) {
                            if (!MouseManager._isFirstTouch && !Input.isInputting)
                                e.cancelable && e.preventDefault();
                            _this.mouseDownTime = Browser.now();
                            _this.runEvent(e);
                        }
                    });
                    canvas.addEventListener("touchend", function (e) {
                        if (MouseManager.enabled) {
                            if (!MouseManager._isFirstTouch && !Input.isInputting)
                                e.cancelable && e.preventDefault();
                            MouseManager._isFirstTouch = false;
                            _this.mouseDownTime = -Browser.now();
                            _this.runEvent(e);
                        } else {
                            _this._curTouchID = NaN;
                        }
                    }, true);
                    canvas.addEventListener("touchmove", function (e) {
                        if (MouseManager.enabled) {
                            e.cancelable && e.preventDefault();
                            _this.runEvent(e);
                        }
                    }, true);
                    canvas.addEventListener("touchcancel", function (e) {
                        if (MouseManager.enabled) {
                            e.cancelable && e.preventDefault();
                            _this.runEvent(e);
                        } else {
                            _this._curTouchID = NaN;
                        }
                    }, true);
                    canvas.addEventListener('mousewheel', function (e) {
                        if (MouseManager.enabled)
                            _this.runEvent(e);
                    });
                    canvas.addEventListener('DOMMouseScroll', function (e) {
                        if (MouseManager.enabled)
                            _this.runEvent(e);
                    });
                }
            }, {
                key: "initEvent",
                value: function initEvent(e) {
                    var nativeEvent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    var _this = this;
                    _this._event._stoped = false;
                    _this._event.nativeEvent = nativeEvent || e;
                    _this._target = null;
                    this._point.setTo(e.pageX || e.clientX, e.pageY || e.clientY);
                    if (this._stage._canvasTransform) {
                        this._stage._canvasTransform.invertTransformPoint(this._point);
                        _this.mouseX = this._point.x;
                        _this.mouseY = this._point.y;
                    }
                    _this._event.touchId = e.identifier || 0;
                    this._tTouchID = _this._event.touchId;
                    var evt;
                    evt = TouchManager.I._event;
                    evt._stoped = false;
                    evt.nativeEvent = _this._event.nativeEvent;
                    evt.touchId = _this._event.touchId;
                }
            }, {
                key: "checkMouseWheel",
                value: function checkMouseWheel(e) {
                    this._event.delta = e.wheelDelta ? e.wheelDelta * 0.025 : -e.detail;
                    var _lastOvers = TouchManager.I.getLastOvers();
                    for (var i = 0, n = _lastOvers.length; i < n; i++) {
                        var ele = _lastOvers[i];
                        ele.event(Event.MOUSE_WHEEL, this._event.setTo(Event.MOUSE_WHEEL, ele, this._target));
                    }
                }
            }, {
                key: "onMouseMove",
                value: function onMouseMove(ele) {
                    TouchManager.I.onMouseMove(ele, this._tTouchID);
                }
            }, {
                key: "onMouseDown",
                value: function onMouseDown(ele) {
                    if (Input.isInputting && ILaya.stage.focus && ILaya.stage.focus["focus"] && !ILaya.stage.focus.contains(this._target)) {
                        var pre_input = ILaya.stage.focus['_tf'] || ILaya.stage.focus;
                        var new_input = ele['_tf'] || ele;
                        if (new_input instanceof Input && new_input.multiline == pre_input.multiline)
                            pre_input['_focusOut']();
                        else
                            pre_input.focus = false;
                    }
                    TouchManager.I.onMouseDown(ele, this._tTouchID, this._isLeftMouse);
                }
            }, {
                key: "onMouseUp",
                value: function onMouseUp(ele) {
                    TouchManager.I.onMouseUp(ele, this._tTouchID, this._isLeftMouse);
                }
            }, {
                key: "check",
                value: function check(sp, mouseX, mouseY, callBack) {
                    this._point.setTo(mouseX, mouseY);
                    sp.fromParentPoint(this._point);
                    mouseX = this._point.x;
                    mouseY = this._point.y;
                    var scrollRect = sp._style.scrollRect;
                    if (scrollRect) {
                        this._rect.setTo(scrollRect.x, scrollRect.y, scrollRect.width, scrollRect.height);
                        if (!this._rect.contains(mouseX, mouseY))
                            return false;
                    }
                    if (!this.disableMouseEvent) {
                        if (sp.hitTestPrior && !sp.mouseThrough && !this.hitTest(sp, mouseX, mouseY)) {
                            return false;
                        }
                        for (var i = sp._children.length - 1; i > -1; i--) {
                            var child = sp._children[i];
                            if (!child.destroyed && child._mouseState > 1 && child._visible) {
                                if (this.check(child, mouseX, mouseY, callBack))
                                    return true;
                            }
                        }
                        for (i = sp._extUIChild.length - 1; i >= 0; i--) {
                            var c = sp._extUIChild[i];
                            if (!c.destroyed && c._mouseState > 1 && c._visible) {
                                if (this.check(c, mouseX, mouseY, callBack))
                                    return true;
                            }
                        }
                    }
                    var isHit = sp.hitTestPrior && !sp.mouseThrough && !this.disableMouseEvent ? true : this.hitTest(sp, mouseX, mouseY);
                    if (isHit) {
                        this._target = sp;
                        callBack.call(this, sp);
                        if (this._target == this._hitCaputreSp) {
                            this._hitCaputreSp = true;
                        }
                    } else if (callBack === this.onMouseUp && sp === this._stage) {
                        this._target = this._stage;
                        callBack.call(this, this._target);
                    }
                    return isHit;
                }
            }, {
                key: "hitTest",
                value: function hitTest(sp, mouseX, mouseY) {
                    var isHit = false;
                    if (sp.scrollRect) {
                        mouseX -= sp._style.scrollRect.x;
                        mouseY -= sp._style.scrollRect.y;
                    }
                    var hitArea = sp._style.hitArea;
                    if (hitArea && hitArea._hit) {
                        return hitArea.contains(mouseX, mouseY);
                    }
                    if (sp.width > 0 && sp.height > 0 || sp.mouseThrough || hitArea) {
                        if (!sp.mouseThrough) {
                            isHit = (hitArea ? hitArea : this._rect.setTo(0, 0, sp.width, sp.height)).contains(mouseX, mouseY);
                        } else {
                            isHit = sp.getGraphicBounds().contains(mouseX, mouseY);
                        }
                    }
                    return isHit;
                }
            }, {
                key: "_checkAllBaseUI",
                value: function _checkAllBaseUI(mousex, mousey, callback) {
                    var ret = this.handleExclusiveCapture(this.mouseX, this.mouseY, callback);
                    if (ret)
                        return true;
                    ret = this.check(this._stage, this.mouseX, this.mouseY, callback);
                    return this.handleCapture(this.mouseX, this.mouseY, callback) || ret;
                }
            }, {
                key: "check3DUI",
                value: function check3DUI(mousex, mousey, callback) {
                    var uis = this._stage._3dUI;
                    var i = 0;
                    var ret = false;
                    for (; i < uis.length; i++) {
                        var curui = uis[i];
                        this._stage._curUIBase = curui;
                        if (!curui.destroyed && curui._mouseState > 1 && curui._visible) {
                            ret = ret || this.check(curui, this.mouseX, this.mouseY, callback);
                        }
                    }
                    this._stage._curUIBase = this._stage;
                    return ret;
                }
            }, {
                key: "handleExclusiveCapture",
                value: function handleExclusiveCapture(mousex, mousey, callback) {
                    if (this._captureExlusiveMode && this._captureSp && this._captureChain.length > 0) {
                        var cursp;
                        this._point.setTo(mousex, mousey);
                        for (var i = 0; i < this._captureChain.length; i++) {
                            cursp = this._captureChain[i];
                            cursp.fromParentPoint(this._point);
                        }
                        this._target = cursp;
                        callback.call(this, cursp);
                        return true;
                    }
                    return false;
                }
            }, {
                key: "handleCapture",
                value: function handleCapture(mousex, mousey, callback) {
                    if (!this._hitCaputreSp && this._captureSp && this._captureChain.length > 0) {
                        var cursp;
                        this._point.setTo(mousex, mousey);
                        for (var i = 0; i < this._captureChain.length; i++) {
                            cursp = this._captureChain[i];
                            cursp.fromParentPoint(this._point);
                        }
                        this._target = cursp;
                        callback.call(this, cursp);
                        return true;
                    }
                    return false;
                }
            }, {
                key: "runEvent",
                value: function runEvent(evt) {
                    var i, n, touch;
                    if (evt.type !== 'mousemove')
                        this._prePoint.x = this._prePoint.y = -1000000;
                    switch (evt.type) {
                        case 'mousedown':
                            this._touchIDs[0] = this._id++;
                            if (!MouseManager._isTouchRespond) {
                                this._isLeftMouse = evt.button === 0;
                                this.initEvent(evt);
                                this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseDown);
                            } else
                                MouseManager._isTouchRespond = false;
                            break;
                        case 'mouseup':
                            this._isLeftMouse = evt.button === 0;
                            this.initEvent(evt);
                            this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseUp);
                            break;
                        case 'mousemove':
                            if (Math.abs(this._prePoint.x - evt.clientX) + Math.abs(this._prePoint.y - evt.clientY) >= this.mouseMoveAccuracy) {
                                this._prePoint.x = evt.clientX;
                                this._prePoint.y = evt.clientY;
                                this.initEvent(evt);
                                this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseMove);
                            }
                            break;
                        case "touchstart":
                            MouseManager._isTouchRespond = true;
                            this._isLeftMouse = true;
                            var touches = evt.changedTouches;
                            for (i = 0,
                                n = touches.length; i < n; i++) {
                                touch = touches[i];
                                if (MouseManager.multiTouchEnabled || isNaN(this._curTouchID)) {
                                    this._curTouchID = touch.identifier;
                                    if (this._id % 200 === 0)
                                        this._touchIDs = {};
                                    this._touchIDs[touch.identifier] = this._id++;
                                    this.initEvent(touch, evt);
                                    this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseDown);
                                }
                            }
                            break;
                        case "touchend":
                        case "touchcancel":
                            MouseManager._isTouchRespond = true;
                            this._isLeftMouse = true;
                            var touchends = evt.changedTouches;
                            for (i = 0,
                                n = touchends.length; i < n; i++) {
                                touch = touchends[i];
                                if (MouseManager.multiTouchEnabled || touch.identifier == this._curTouchID) {
                                    this._curTouchID = NaN;
                                    this.initEvent(touch, evt);
                                    var isChecked;
                                    isChecked = this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseUp);
                                    if (!isChecked) {
                                        this.onMouseUp(null);
                                    }
                                }
                            }
                            break;
                        case "touchmove":
                            var touchemoves = evt.changedTouches;
                            for (i = 0,
                                n = touchemoves.length; i < n; i++) {
                                touch = touchemoves[i];
                                if (MouseManager.multiTouchEnabled || touch.identifier == this._curTouchID) {
                                    this.initEvent(touch, evt);
                                    this._checkAllBaseUI(this.mouseX, this.mouseY, this.onMouseMove);
                                }
                            }
                            break;
                        case "wheel":
                        case "mousewheel":
                        case "DOMMouseScroll":
                            this.checkMouseWheel(evt);
                            break;
                        case "mouseout":
                            TouchManager.I.stageMouseOut();
                            break;
                        case "mouseover":
                            this._stage.event(Event.MOUSE_OVER, this._event.setTo(Event.MOUSE_OVER, this._stage, this._stage));
                            break;
                    }
                }
            }, {
                key: "setCapture",
                value: function setCapture(sp) {
                    var exclusive = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
                    this._captureSp = sp;
                    this._captureExlusiveMode = exclusive;
                    this._captureChain.length = 0;
                    this._captureChain.push(sp);
                    var cursp = sp;
                    while (true) {
                        if (cursp == ILaya.stage)
                            break;
                        if (cursp == ILaya.stage._curUIBase)
                            break;
                        cursp = cursp.parent;
                        if (!cursp)
                            break;
                        this._captureChain.splice(0, 0, cursp);
                    }
                }
            }, {
                key: "releaseCapture",
                value: function releaseCapture() {
                    console.log('release capture');
                    this._captureSp = null;
                }
            }]);
            return MouseManager;
        }();
    MouseManager.instance = new MouseManager();
    MouseManager.enabled = true;
    MouseManager.multiTouchEnabled = true;
    MouseManager._isFirstTouch = true;
    var CallLater = /*#__PURE__*/
        function () {
            function CallLater() {
                _classCallCheck(this, CallLater);
                this._pool = [];
                this._map = {};
                this._laters = [];
            }
            _createClass(CallLater, [{
                key: "_update",
                value: function _update() {
                    var laters = this._laters;
                    var len = laters.length;
                    if (len > 0) {
                        for (var i = 0, n = len - 1; i <= n; i++) {
                            var handler = laters[i];
                            this._map[handler.key] = null;
                            if (handler.method !== null) {
                                handler.run();
                                handler.clear();
                            }
                            this._pool.push(handler);
                            i === n && (n = laters.length - 1);
                        }
                        laters.length = 0;
                    }
                }
            }, {
                key: "_getHandler",
                value: function _getHandler(caller, method) {
                    var cid = caller ? caller.$_GID || (caller.$_GID = ILaya.Utils.getGID()) : 0;
                    var mid = method.$_TID || (method.$_TID = ILaya.Timer._mid++);
                    return this._map[cid + '.' + mid];
                }
            }, {
                key: "callLater",
                value: function callLater(caller, method) {
                    var args = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    if (this._getHandler(caller, method) == null) {
                        var handler;
                        if (this._pool.length)
                            handler = this._pool.pop();
                        else
                            handler = new LaterHandler();
                        handler.caller = caller;
                        handler.method = method;
                        handler.args = args;
                        var cid = caller ? caller.$_GID : 0;
                        var mid = method["$_TID"];
                        handler.key = cid + '.' + mid;
                        this._map[handler.key] = handler;
                        this._laters.push(handler);
                    }
                }
            }, {
                key: "runCallLater",
                value: function runCallLater(caller, method) {
                    var handler = this._getHandler(caller, method);
                    if (handler && handler.method != null) {
                        this._map[handler.key] = null;
                        handler.run();
                        handler.clear();
                    }
                }
            }]);
            return CallLater;
        }();
    CallLater.I = new CallLater();
    var LaterHandler = /*#__PURE__*/
        function () {
            function LaterHandler() {
                _classCallCheck(this, LaterHandler);
            }
            _createClass(LaterHandler, [{
                key: "clear",
                value: function clear() {
                    this.caller = null;
                    this.method = null;
                    this.args = null;
                }
            }, {
                key: "run",
                value: function run() {
                    var caller = this.caller;
                    if (caller && caller.destroyed)
                        return this.clear();
                    var method = this.method;
                    var args = this.args;
                    if (method == null)
                        return;
                    args ? method.apply(caller, args) : method.call(caller);
                }
            }]);
            return LaterHandler;
        }();
    var RunDriver = /*#__PURE__*/
        _createClass(function RunDriver() {
            _classCallCheck(this, RunDriver);
        });
    RunDriver.createShaderCondition = function (conditionScript) {
        var fn = "(function() {return " + conditionScript + ";})";
        return window.Laya._runScript(fn);
    }
        ;
    RunDriver.changeWebGLSize = function (w, h) {
        WebGL.onStageResize(w, h);
    }
        ;
    var Stage = /*#__PURE__*/
        function (_Sprite2) {
            _inherits(Stage, _Sprite2);
            var _super32 = _createSuper(Stage);
            function Stage() {
                var _thisSuper, _this27;
                _classCallCheck(this, Stage);
                _this27 = _super32.call(this);
                _this27.offset = new Point();
                _this27._frameRate = "fast";
                _this27._timeoutId = -1,
                    _this27.designWidth = 0;
                _this27.designHeight = 0;
                _this27.canvasRotation = false;
                _this27.canvasDegree = 0;
                _this27.renderingEnabled = true;
                _this27.screenAdaptationEnabled = true;
                _this27._canvasTransform = new Matrix();
                _this27._screenMode = "none";
                _this27._scaleMode = "noscale";
                _this27._alignV = "top";
                _this27._alignH = "left";
                _this27._bgColor = "black";
                _this27._mouseMoveTime = 0;
                _this27._renderCount = 0;
                _this27._safariOffsetY = 0;
                _this27._frameStartTime = 0;
                _this27._previousOrientation = Browser.window.orientation;
                _this27._wgColor = [0, 0, 0, 1];
                _this27._scene3Ds = [];
                _this27._globalRepaintSet = false;
                _this27._globalRepaintGet = false;
                _this27._3dUI = [];
                _this27._curUIBase = null;
                _this27.useRetinalCanvas = false;
                _get((_thisSuper = _assertThisInitialized(_this27),
                    _getPrototypeOf(Stage.prototype)), "set_transform", _thisSuper).call(_thisSuper, _this27._createTransform());
                _this27.mouseEnabled = true;
                _this27.hitTestPrior = true;
                _this27.autoSize = false;
                _this27._setBit(Const.DISPLAYED_INSTAGE, true);
                _this27._setBit(Const.ACTIVE_INHIERARCHY, true);
                _this27._isFocused = true;
                _this27._isVisibility = true;
                _this27.useRetinalCanvas = Config.useRetinalCanvas;
                var window = Browser.window;
                window.addEventListener("focus", function () {
                    _this27._isFocused = true;
                    _this27.event(Event.FOCUS);
                    _this27.event(Event.FOCUS_CHANGE);
                });
                window.addEventListener("blur", function () {
                    _this27._isFocused = false;
                    _this27.event(Event.BLUR);
                    _this27.event(Event.FOCUS_CHANGE);
                    if (_this27._isInputting())
                        Input["inputElement"].target.focus = false;
                });
                var state = "visibilityState"
                    , visibilityChange = "visibilitychange";
                var document = window.document;
                if (typeof document.hidden !== "undefined") {
                    visibilityChange = "visibilitychange";
                    state = "visibilityState";
                } else if (typeof document.mozHidden !== "undefined") {
                    visibilityChange = "mozvisibilitychange";
                    state = "mozVisibilityState";
                } else if (typeof document.msHidden !== "undefined") {
                    visibilityChange = "msvisibilitychange";
                    state = "msVisibilityState";
                } else if (typeof document.webkitHidden !== "undefined") {
                    visibilityChange = "webkitvisibilitychange";
                    state = "webkitVisibilityState";
                }
                window.document.addEventListener(visibilityChange, function () {
                    if (Browser.document[state] == "hidden") {
                        _this27._isVisibility = false;
                        if (_this27._isInputting())
                            Input["inputElement"].target.focus = false;
                    } else {
                        _this27._isVisibility = true;
                    }
                    _this27.renderingEnabled = _this27._isVisibility;
                    _this27.event(Event.VISIBILITY_CHANGE);
                });
                // window.addEventListener("resize", function () {
                //     var orientation = Browser.window.orientation;
                //     if (orientation != null && orientation != _this27._previousOrientation && _this27._isInputting()) {
                //         Input["inputElement"].target.focus = false;
                //     }
                //     _this27._previousOrientation = orientation;
                //     if (_this27._isInputting())
                //         return;
                //     if (Browser.onSafari)
                //         _this27._safariOffsetY = (Browser.window.__innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight) - Browser.window.innerHeight;
                //     _this27._resetCanvas();
                // });
                // window.addEventListener("orientationchange", function (e) {
                //     _this27._resetCanvas();
                // });



                window.addEventListener("resize", () => {
                    var orientation = Browser.window.orientation;
                    if (orientation != null && orientation != _this27._previousOrientation && _this27._isInputting()) {
                        Input["inputElement"].target.focus = false;
                    }
                    _this27._previousOrientation = orientation;
                    if (_this27._isInputting())
                        return;
                    if (Browser.onSafari) {
                        _this27._safariOffsetY = (Browser.window.__innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight) - Browser.window.innerHeight;
                        _this27._safariOffsetY = Math.max(0, _this27._safariOffsetY);
                    }
                    _this27._resetCanvas();
                });

                window.addEventListener("orientationchange", (e) => {
                    if (Browser.onSafari) {
                        clearTimeout(_this27._timeoutId);
                        _this27._timeoutId = setTimeout(() => {
                            _this27._safariOffsetY = (Browser.window.__innerHeight || Browser.document.body.clientHeight || Browser.document.documentElement.clientHeight) - Browser.window.innerHeight;
                            _this27._safariOffsetY = Math.max(0, _this27._safariOffsetY);
                            _this27._resetCanvas();

                        }, 0.5e3);
                    } else {
                        _this27._resetCanvas();
                    }
                });

                _this27.on(Event.MOUSE_MOVE, _assertThisInitialized(_this27), _this27._onmouseMove);
                if (Browser.onMobile)
                    _this27.on(Event.MOUSE_DOWN, _assertThisInitialized(_this27), _this27._onmouseMove);
                return _this27;
            }
            _createClass(Stage, [{
                key: "_isInputting",
                value: function _isInputting() {
                    return Browser.onMobile && Input.isInputting;
                }
            }, {
                key: "width",
                get: function get() {
                    return _get(_getPrototypeOf(Stage.prototype), "get_width", this).call(this);
                },
                set: function set(value) {
                    this.designWidth = value;
                    _get(_getPrototypeOf(Stage.prototype), "set_width", this).call(this, value);
                    ILaya.systemTimer.callLater(this, this._changeCanvasSize);
                }
            }, {
                key: "height",
                get: function get() {
                    return _get(_getPrototypeOf(Stage.prototype), "get_height", this).call(this);
                },
                set: function set(value) {
                    this.designHeight = value;
                    _get(_getPrototypeOf(Stage.prototype), "set_height", this).call(this, value);
                    ILaya.systemTimer.callLater(this, this._changeCanvasSize);
                }
            }, {
                key: "transform",
                get: function get() {
                    if (this._tfChanged)
                        this._adjustTransform();
                    return this._transform = this._transform || this._createTransform();
                },
                set: function set(value) {
                    _get(_getPrototypeOf(Stage.prototype), "set_transform", this).call(this, value);
                }
            }, {
                key: "isFocused",
                get: function get() {
                    return this._isFocused;
                }
            }, {
                key: "isVisibility",
                get: function get() {
                    return this._isVisibility;
                }
            }, {
                key: "_changeCanvasSize",
                value: function _changeCanvasSize() {
                    this.setScreenSize(Browser.clientWidth * Browser.pixelRatio, Browser.clientHeight * Browser.pixelRatio);
                }
            }, {
                key: "_resetCanvas",
                value: function _resetCanvas() {
                    if (!this.screenAdaptationEnabled)
                        return;
                    this._changeCanvasSize();
                }
            }, {
                key: "setScreenSize",
                value: function setScreenSize(screenWidth, screenHeight) {
                    var rotation = false;
                    if (this._screenMode !== Stage.SCREEN_NONE) {
                        var screenType = screenWidth / screenHeight < 1 ? Stage.SCREEN_VERTICAL : Stage.SCREEN_HORIZONTAL;
                        rotation = screenType !== this._screenMode;
                        if (rotation) {
                            var temp = screenHeight;
                            screenHeight = screenWidth;
                            screenWidth = temp;
                        }
                    }
                    this.canvasRotation = rotation;
                    var canvas = Render._mainCanvas;
                    var canvasStyle = canvas.source.style;
                    var mat = this._canvasTransform.identity();
                    var scaleMode = this._scaleMode;
                    var scaleX = screenWidth / this.designWidth;
                    var scaleY = screenHeight / this.designHeight;
                    var canvasWidth = this.useRetinalCanvas ? screenWidth : this.designWidth;
                    var canvasHeight = this.useRetinalCanvas ? screenHeight : this.designHeight;
                    var realWidth = screenWidth;
                    var realHeight = screenHeight;
                    var pixelRatio = Browser.pixelRatio;
                    this._width = this.designWidth;
                    this._height = this.designHeight;
                    switch (scaleMode) {
                        case Stage.SCALE_NOSCALE:
                            scaleX = scaleY = 1;
                            realWidth = this.designWidth;
                            realHeight = this.designHeight;
                            break;
                        case Stage.SCALE_SHOWALL:
                            scaleX = scaleY = Math.min(scaleX, scaleY);
                            canvasWidth = realWidth = Math.round(this.designWidth * scaleX);
                            canvasHeight = realHeight = Math.round(this.designHeight * scaleY);
                            break;
                        case Stage.SCALE_NOBORDER:
                            scaleX = scaleY = Math.max(scaleX, scaleY);
                            realWidth = Math.round(this.designWidth * scaleX);
                            realHeight = Math.round(this.designHeight * scaleY);
                            break;
                        case Stage.SCALE_FULL:
                            scaleX = scaleY = 1;
                            this._width = canvasWidth = screenWidth;
                            this._height = canvasHeight = screenHeight;
                            break;
                        case Stage.SCALE_FIXED_WIDTH:
                            scaleY = scaleX;
                            this._height = canvasHeight = Math.round(screenHeight / scaleX);
                            break;
                        case Stage.SCALE_FIXED_HEIGHT:
                            scaleX = scaleY;
                            this._width = canvasWidth = Math.round(screenWidth / scaleY);
                            break;
                        case Stage.SCALE_FIXED_AUTO:
                            if (screenWidth / screenHeight < this.designWidth / this.designHeight) {
                                scaleY = scaleX;
                                this._height = canvasHeight = Math.round(screenHeight / scaleX);
                            } else {
                                scaleX = scaleY;
                                this._width = canvasWidth = Math.round(screenWidth / scaleY);
                            }
                            break;
                    }
                    if (this.useRetinalCanvas) {
                        realWidth = canvasWidth = screenWidth;
                        realHeight = canvasHeight = screenHeight;
                    }
                    scaleX *= this.scaleX;
                    scaleY *= this.scaleY;
                    if (scaleX === 1 && scaleY === 1) {
                        this.transform.identity();
                    } else {
                        this.transform.a = this._formatData(scaleX / (realWidth / canvasWidth));
                        this.transform.d = this._formatData(scaleY / (realHeight / canvasHeight));
                    }
                    canvas.size(canvasWidth, canvasHeight);
                    RunDriver.changeWebGLSize(canvasWidth, canvasHeight);
                    mat.scale(realWidth / canvasWidth / pixelRatio, realHeight / canvasHeight / pixelRatio);
                    if (this._alignH === Stage.ALIGN_LEFT)
                        this.offset.x = 0;
                    else if (this._alignH === Stage.ALIGN_RIGHT)
                        this.offset.x = screenWidth - realWidth;
                    else
                        this.offset.x = (screenWidth - realWidth) * 0.5 / pixelRatio;
                    if (this._alignV === Stage.ALIGN_TOP)
                        this.offset.y = 0;
                    else if (this._alignV === Stage.ALIGN_BOTTOM)
                        this.offset.y = screenHeight - realHeight;
                    else
                        this.offset.y = (screenHeight - realHeight) * 0.5 / pixelRatio;
                    this.offset.x = Math.round(this.offset.x);
                    this.offset.y = Math.round(this.offset.y);
                    mat.translate(this.offset.x, this.offset.y);
                    if (this._safariOffsetY)
                        mat.translate(0, this._safariOffsetY);
                    this.canvasDegree = 0;
                    if (rotation) {
                        if (this._screenMode === Stage.SCREEN_HORIZONTAL) {
                            mat.rotate(Math.PI / 2);
                            mat.translate(screenHeight / pixelRatio, 0);
                            this.canvasDegree = 90;
                        } else {
                            mat.rotate(-Math.PI / 2);
                            mat.translate(0, screenWidth / pixelRatio);
                            this.canvasDegree = -90;
                        }
                    }
                    mat.a = this._formatData(mat.a);
                    mat.d = this._formatData(mat.d);
                    mat.tx = this._formatData(mat.tx);
                    mat.ty = this._formatData(mat.ty);
                    _get(_getPrototypeOf(Stage.prototype), "set_transform", this).call(this, this.transform);
                    canvasStyle.transformOrigin = canvasStyle.webkitTransformOrigin = canvasStyle.msTransformOrigin = canvasStyle.mozTransformOrigin = canvasStyle.oTransformOrigin = "0px 0px 0px";
                    canvasStyle.transform = canvasStyle.webkitTransform = canvasStyle.msTransform = canvasStyle.mozTransform = canvasStyle.oTransform = "matrix(" + mat.toString() + ")";
                    if (this._safariOffsetY)
                        mat.translate(0, -this._safariOffsetY);
                    mat.translate(parseInt(canvasStyle.left) || 0, parseInt(canvasStyle.top) || 0);
                    this.visible = true;
                    this._repaint |= SpriteConst.REPAINT_CACHE;
                    this.event(Event.RESIZE);
                }
            }, {
                key: "_formatData",
                value: function _formatData(value) {
                    if (Math.abs(value) < 0.000001)
                        return 0;
                    if (Math.abs(1 - value) < 0.001)
                        return value > 0 ? 1 : -1;
                    return value;
                }
            }, {
                key: "scaleMode",
                get: function get() {
                    return this._scaleMode;
                },
                set: function set(value) {
                    this._scaleMode = value;
                    ILaya.systemTimer.callLater(this, this._changeCanvasSize);
                }
            }, {
                key: "alignH",
                get: function get() {
                    return this._alignH;
                },
                set: function set(value) {
                    this._alignH = value;
                    ILaya.systemTimer.callLater(this, this._changeCanvasSize);
                }
            }, {
                key: "alignV",
                get: function get() {
                    return this._alignV;
                },
                set: function set(value) {
                    this._alignV = value;
                    ILaya.systemTimer.callLater(this, this._changeCanvasSize);
                }
            }, {
                key: "bgColor",
                get: function get() {
                    return this._bgColor;
                },
                set: function set(value) {
                    this._bgColor = value;
                    if (value)
                        this._wgColor = ColorUtils.create(value).arrColor;
                    else
                        this._wgColor = null;
                    if (value) {
                        Render.canvas.style.background = value;
                    } else {
                        Render.canvas.style.background = "none";
                    }
                }
            }, {
                key: "mouseX",
                get: function get() {
                    return Math.round(MouseManager.instance.mouseX / this.clientScaleX);
                }
            }, {
                key: "mouseY",
                get: function get() {
                    return Math.round(MouseManager.instance.mouseY / this.clientScaleY);
                }
            }, {
                key: "getMousePoint",
                value: function getMousePoint() {
                    return Point.TEMP.setTo(this.mouseX, this.mouseY);
                }
            }, {
                key: "clientScaleX",
                get: function get() {
                    return this._transform ? this._transform.getScaleX() : 1;
                }
            }, {
                key: "clientScaleY",
                get: function get() {
                    return this._transform ? this._transform.getScaleY() : 1;
                }
            }, {
                key: "screenMode",
                get: function get() {
                    return this._screenMode;
                },
                set: function set(value) {
                    this._screenMode = value;
                }
            }, {
                key: "repaint",
                value: function repaint() {
                    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SpriteConst.REPAINT_CACHE;
                    this._repaint |= type;
                }
            }, {
                key: "parentRepaint",
                value: function parentRepaint() {
                    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SpriteConst.REPAINT_CACHE;
                }
            }, {
                key: "_loop",
                value: function _loop() {
                    this._globalRepaintGet = this._globalRepaintSet;
                    this._globalRepaintSet = false;
                    this.render(Render._context, 0, 0);
                    return true;
                }
            }, {
                key: "getFrameTm",
                value: function getFrameTm() {
                    return this._frameStartTime;
                }
            }, {
                key: "_onmouseMove",
                value: function _onmouseMove(e) {
                    this._mouseMoveTime = Browser.now();
                }
            }, {
                key: "getTimeFromFrameStart",
                value: function getTimeFromFrameStart() {
                    return Browser.now() - this._frameStartTime;
                }
            }, {
                key: "visible",
                get: function get() {
                    return _get(_getPrototypeOf(Stage.prototype), "visible", this);
                },
                set: function set(value) {
                    if (this.visible !== value) {
                        _get(_getPrototypeOf(Stage.prototype), "set_visible", this).call(this, value);
                        var style = Render._mainCanvas.source.style;
                        style.visibility = value ? "visible" : "hidden";
                    }
                }
            }, {
                key: "render",
                value: function render(context, x, y) {
                    if (window.conch) {
                        this.renderToNative(context, x, y);
                        return;
                    }
                    if (this._frameRate === Stage.FRAME_SLEEP) {
                        var now = Browser.now();
                        if (now - this._frameStartTime >= 1000)
                            this._frameStartTime = now;
                        else
                            return;
                    } else {
                        if (!this._visible) {
                            this._renderCount++;
                            if (this._renderCount % 5 === 0) {
                                CallLater.I._update();
                                Stat.loopCount++;
                                RenderInfo.loopCount = Stat.loopCount;
                                this._updateTimers();
                            }
                            return;
                        }
                        this._frameStartTime = Browser.now();
                        RenderInfo.loopStTm = this._frameStartTime;
                    }
                    this._renderCount++;
                    var frameMode = this._frameRate === Stage.FRAME_MOUSE ? this._frameStartTime - this._mouseMoveTime < 2000 ? Stage.FRAME_FAST : Stage.FRAME_SLOW : this._frameRate;
                    var isFastMode = frameMode !== Stage.FRAME_SLOW;
                    var isDoubleLoop = this._renderCount % 2 === 0;
                    Stat.renderSlow = !isFastMode;
                    if (!isFastMode && !isDoubleLoop)
                        return;
                    CallLater.I._update();
                    Stat.loopCount++;
                    RenderInfo.loopCount = Stat.loopCount;
                    if (this.renderingEnabled) {
                        for (var i = 0, n = this._scene3Ds.length; i < n; i++) {
                            this._scene3Ds[i]._update();
                        }
                        context.clear();
                        _get(_getPrototypeOf(Stage.prototype), "render", this).call(this, context, x, y);
                        Stat._StatRender.renderNotCanvas(context, x, y);
                    }
                    if (this.renderingEnabled) {
                        Stage.clear(this._bgColor);
                        context.flush();
                        VectorGraphManager.instance && VectorGraphManager.getInstance().endDispose();
                    }
                    this._updateTimers();
                }
            }, {
                key: "renderToNative",
                value: function renderToNative(context, x, y) {
                    this._renderCount++;
                    if (!this._visible) {
                        if (this._renderCount % 5 === 0) {
                            CallLater.I._update();
                            Stat.loopCount++;
                            RenderInfo.loopCount = Stat.loopCount;
                            this._updateTimers();
                        }
                        return;
                    }
                    CallLater.I._update();
                    Stat.loopCount++;
                    RenderInfo.loopCount = Stat.loopCount;
                    if (this.renderingEnabled) {
                        for (var i = 0, n = this._scene3Ds.length; i < n; i++) {
                            this._scene3Ds[i]._update();
                        }
                        context.clear();
                        _get(_getPrototypeOf(Stage.prototype), "render", this).call(this, context, x, y);
                        Stat._StatRender.renderNotCanvas(context, x, y);
                    }
                    if (this.renderingEnabled) {
                        Stage.clear(this._bgColor);
                        context.flush();
                        VectorGraphManager.instance && VectorGraphManager.getInstance().endDispose();
                    }
                    this._updateTimers();
                }
            }, {
                key: "_updateTimers",
                value: function _updateTimers() {
                    ILaya.systemTimer._update();
                    ILaya.startTimer._update();
                    ILaya.physicsTimer._update();
                    ILaya.updateTimer._update();
                    ILaya.lateTimer._update();
                    ILaya.timer._update();
                }
            }, {
                key: "fullScreenEnabled",
                set: function set(value) {
                    var document = Browser.document;
                    var canvas = Render.canvas;
                    if (value) {
                        canvas.addEventListener('mousedown', this._requestFullscreen);
                        canvas.addEventListener('touchstart', this._requestFullscreen);
                        document.addEventListener("fullscreenchange", this._fullScreenChanged);
                        document.addEventListener("mozfullscreenchange", this._fullScreenChanged);
                        document.addEventListener("webkitfullscreenchange", this._fullScreenChanged);
                        document.addEventListener("msfullscreenchange", this._fullScreenChanged);
                    } else {
                        canvas.removeEventListener('mousedown', this._requestFullscreen);
                        canvas.removeEventListener('touchstart', this._requestFullscreen);
                        document.removeEventListener("fullscreenchange", this._fullScreenChanged);
                        document.removeEventListener("mozfullscreenchange", this._fullScreenChanged);
                        document.removeEventListener("webkitfullscreenchange", this._fullScreenChanged);
                        document.removeEventListener("msfullscreenchange", this._fullScreenChanged);
                    }
                }
            }, {
                key: "frameRate",
                get: function get() {
                    if (!ILaya.Render.isConchApp) {
                        return this._frameRate;
                    } else {
                        return this._frameRateNative;
                    }
                },
                set: function set(value) {
                    if (!ILaya.Render.isConchApp) {
                        this._frameRate = value;
                    } else {
                        var c = window.conch;
                        switch (value) {
                            case Stage.FRAME_FAST:
                                c.config.setLimitFPS(60);
                                break;
                            case Stage.FRAME_MOUSE:
                                c.config.setMouseFrame(2000);
                                break;
                            case Stage.FRAME_SLOW:
                                c.config.setSlowFrame(true);
                                break;
                            case Stage.FRAME_SLEEP:
                                c.config.setLimitFPS(1);
                                break;
                        }
                        this._frameRateNative = value;
                    }
                }
            }, {
                key: "_requestFullscreen",
                value: function _requestFullscreen() {
                    var element = Browser.document.documentElement;
                    if (element.requestFullscreen) {
                        element.requestFullscreen();
                    } else if (element.mozRequestFullScreen) {
                        element.mozRequestFullScreen();
                    } else if (element.webkitRequestFullscreen) {
                        element.webkitRequestFullscreen();
                    } else if (element.msRequestFullscreen) {
                        element.msRequestFullscreen();
                    }
                }
            }, {
                key: "_fullScreenChanged",
                value: function _fullScreenChanged() {
                    ILaya.stage.event(Event.FULL_SCREEN_CHANGE);
                }
            }, {
                key: "exitFullscreen",
                value: function exitFullscreen() {
                    var document = Browser.document;
                    if (document.exitFullscreen) {
                        document.exitFullscreen();
                    } else if (document.mozCancelFullScreen) {
                        document.mozCancelFullScreen();
                    } else if (document.webkitExitFullscreen) {
                        document.webkitExitFullscreen();
                    }
                }
            }, {
                key: "isGlobalRepaint",
                value: function isGlobalRepaint() {
                    return this._globalRepaintGet;
                }
            }, {
                key: "setGlobalRepaint",
                value: function setGlobalRepaint() {
                    this._globalRepaintSet = true;
                }
            }, {
                key: "add3DUI",
                value: function add3DUI(uibase) {
                    var uiroot = uibase.rootView;
                    if (this._3dUI.indexOf(uiroot) >= 0)
                        return;
                    this._3dUI.push(uiroot);
                }
            }, {
                key: "remove3DUI",
                value: function remove3DUI(uibase) {
                    var uiroot = uibase.rootView;
                    var p = this._3dUI.indexOf(uiroot);
                    if (p >= 0) {
                        this._3dUI.splice(p, 1);
                        return true;
                    }
                    return false;
                }
            }]);
            return Stage;
        }(Sprite);
    Stage.SCALE_NOSCALE = "noscale";
    Stage.SCALE_EXACTFIT = "exactfit";
    Stage.SCALE_SHOWALL = "showall";
    Stage.SCALE_NOBORDER = "noborder";
    Stage.SCALE_FULL = "full";
    Stage.SCALE_FIXED_WIDTH = "fixedwidth";
    Stage.SCALE_FIXED_HEIGHT = "fixedheight";
    Stage.SCALE_FIXED_AUTO = "fixedauto";
    Stage.ALIGN_LEFT = "left";
    Stage.ALIGN_RIGHT = "right";
    Stage.ALIGN_CENTER = "center";
    Stage.ALIGN_TOP = "top";
    Stage.ALIGN_MIDDLE = "middle";
    Stage.ALIGN_BOTTOM = "bottom";
    Stage.SCREEN_NONE = "none";
    Stage.SCREEN_HORIZONTAL = "horizontal";
    Stage.SCREEN_VERTICAL = "vertical";
    Stage.FRAME_FAST = "fast";
    Stage.FRAME_SLOW = "slow";
    Stage.FRAME_MOUSE = "mouse";
    Stage.FRAME_SLEEP = "sleep";
    Stage.clear = function (value) {
        Context.set2DRenderConfig();
        var gl = LayaGL.instance;
        RenderState2D.worldScissorTest && gl.disable(gl.SCISSOR_TEST);
        var ctx = Render.context;
        var c = ctx._submits._length == 0 || Config.preserveDrawingBuffer ? ColorUtils.create(value).arrColor : ILaya.stage._wgColor;
        if (c)
            ctx.clearBG(c[0], c[1], c[2], c[3]);
        else
            ctx.clearBG(0, 0, 0, 0);
        RenderState2D.clear();
    }
        ;
    ClassUtils.regClass("laya.display.Stage", Stage);
    ClassUtils.regClass("Laya.Stage", Stage);
    var KeyBoardManager = /*#__PURE__*/
        function () {
            function KeyBoardManager() {
                _classCallCheck(this, KeyBoardManager);
            }
            _createClass(KeyBoardManager, null, [{
                key: "__init__",
                value: function __init__() {
                    KeyBoardManager._addEvent("keydown");
                    KeyBoardManager._addEvent("keypress");
                    KeyBoardManager._addEvent("keyup");
                }
            }, {
                key: "_addEvent",
                value: function _addEvent(type) {
                    ILaya.Browser.document.addEventListener(type, function (e) {
                        KeyBoardManager._dispatch(e, type);
                    }, true);
                }
            }, {
                key: "_dispatch",
                value: function _dispatch(e, type) {
                    if (!KeyBoardManager.enabled)
                        return;
                    KeyBoardManager._event._stoped = false;
                    KeyBoardManager._event.nativeEvent = e;
                    KeyBoardManager._event.keyCode = e.keyCode || e.which || e.charCode;
                    if (type === "keydown")
                        KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode] = true;
                    else if (type === "keyup")
                        KeyBoardManager._pressKeys[KeyBoardManager._event.keyCode] = null;
                    var target = ILaya.stage.focus && ILaya.stage.focus.event != null && ILaya.stage.focus.displayedInStage ? ILaya.stage.focus : ILaya.stage;
                    var ct = target;
                    while (ct) {
                        ct.event(type, KeyBoardManager._event.setTo(type, ct, target));
                        ct = ct.parent;
                    }
                }
            }, {
                key: "hasKeyDown",
                value: function hasKeyDown(key) {
                    return KeyBoardManager._pressKeys[key];
                }
            }]);
            return KeyBoardManager;
        }();
    KeyBoardManager._pressKeys = {};
    KeyBoardManager.enabled = true;
    KeyBoardManager._event = new Event();
    var SoundChannel = /*#__PURE__*/
        function (_EventDispatcher4) {
            _inherits(SoundChannel, _EventDispatcher4);
            var _super33 = _createSuper(SoundChannel);
            function SoundChannel() {
                var _this28;
                _classCallCheck(this, SoundChannel);
                _this28 = _super33.apply(this, arguments);
                _this28.isStopped = false;
                return _this28;
            }
            _createClass(SoundChannel, [{
                key: "volume",
                get: function get() {
                    return 1;
                },
                set: function set(v) { }
            }, {
                key: "position",
                get: function get() {
                    return 0;
                }
            }, {
                key: "duration",
                get: function get() {
                    return 0;
                }
            }, {
                key: "play",
                value: function play() { }
            }, {
                key: "stop",
                value: function stop() {
                    if (this.completeHandler)
                        this.completeHandler.run();
                }
            }, {
                key: "pause",
                value: function pause() { }
            }, {
                key: "resume",
                value: function resume() { }
            }, {
                key: "__runComplete",
                value: function __runComplete(handler) {
                    if (handler) {
                        handler.run();
                    }
                }
            }]);
            return SoundChannel;
        }(EventDispatcher);
    var AudioSoundChannel = /*#__PURE__*/
        function (_SoundChannel) {
            _inherits(AudioSoundChannel, _SoundChannel);
            var _super34 = _createSuper(AudioSoundChannel);
            function AudioSoundChannel(audio) {
                var _this29;
                _classCallCheck(this, AudioSoundChannel);
                _this29 = _super34.call(this);
                _this29._audio = null;
                _this29._onEnd = _this29.__onEnd.bind(_assertThisInitialized(_this29));
                _this29._resumePlay = _this29.__resumePlay.bind(_assertThisInitialized(_this29));
                audio.addEventListener("ended", _this29._onEnd);
                _this29._audio = audio;
                return _this29;
            }
            _createClass(AudioSoundChannel, [{
                key: "__onEnd",
                value: function __onEnd(evt) {
                    if (this.loops == 1) {
                        if (this.completeHandler) {
                            ILaya.systemTimer.once(10, this, this.__runComplete, [this.completeHandler], false);
                            this.completeHandler = null;
                        }
                        this.stop();
                        this.event(Event.COMPLETE);
                        return;
                    }
                    if (this.loops > 0) {
                        this.loops--;
                    }
                    this.startTime = 0;
                    this.play();
                }
            }, {
                key: "__resumePlay",
                value: function __resumePlay() {
                    if (this._audio)
                        this._audio.removeEventListener("canplay", this._resumePlay);
                    if (this.isStopped)
                        return;
                    try {
                        this._audio.currentTime = this.startTime;
                        Browser.container.appendChild(this._audio);
                        this._audio.play();
                    } catch (e) {
                        this.event(Event.ERROR);
                    }
                }
            }, {
                key: "play",
                value: function play() {
                    this.isStopped = false;
                    try {
                        this._audio.playbackRate = ILaya.SoundManager.playbackRate;
                        this._audio.currentTime = this.startTime;
                    } catch (e) {
                        this._audio.addEventListener("canplay", this._resumePlay);
                        return;
                    }
                    ILaya.SoundManager.addChannel(this);
                    Browser.container.appendChild(this._audio);
                    if ("play" in this._audio)
                        this._audio.play();
                }
            }, {
                key: "position",
                get: function get() {
                    if (!this._audio)
                        return 0;
                    return this._audio.currentTime;
                }
            }, {
                key: "duration",
                get: function get() {
                    if (!this._audio)
                        return 0;
                    return this._audio.duration;
                }
            }, {
                key: "stop",
                value: function stop() {
                    _get(_getPrototypeOf(AudioSoundChannel.prototype), "stop", this).call(this);
                    this.isStopped = true;
                    ILaya.SoundManager.removeChannel(this);
                    this.completeHandler = null;
                    if (!this._audio)
                        return;
                    if ("pause" in this._audio)
                        if (ILaya.Render.isConchApp) {
                            this._audio.stop();
                        }
                    this._audio.pause();
                    this._audio.removeEventListener("ended", this._onEnd);
                    this._audio.removeEventListener("canplay", this._resumePlay);
                    if (!ILaya.Browser.onIE) {
                        if (this._audio != ILaya.AudioSound._musicAudio) {
                            ILaya.Pool.recover("audio:" + this.url, this._audio);
                        }
                    }
                    Browser.removeElement(this._audio);
                    this._audio = null;
                    if (ILaya.SoundManager.autoReleaseSound)
                        ILaya.SoundManager.disposeSoundLater(this.url);
                }
            }, {
                key: "pause",
                value: function pause() {
                    this.isStopped = true;
                    ILaya.SoundManager.removeChannel(this);
                    if ("pause" in this._audio)
                        this._audio.pause();
                    if (ILaya.SoundManager.autoReleaseSound)
                        ILaya.SoundManager.disposeSoundLater(this.url);
                }
            }, {
                key: "resume",
                value: function resume() {
                    var audio = this._audio;
                    if (!audio)
                        return;
                    this.isStopped = false;
                    if (audio.readyState == 0) {
                        audio.src = this.url;
                        audio.addEventListener("canplay", this._resumePlay);
                        audio.load();
                    }
                    ILaya.SoundManager.addChannel(this);
                    if ("play" in audio) {
                        audio.play();
                    }
                }
            }, {
                key: "volume",
                get: function get() {
                    if (!this._audio)
                        return 1;
                    return this._audio.volume;
                },
                set: function set(v) {
                    if (!this._audio)
                        return;
                    this._audio.volume = v;
                }
            }]);
            return AudioSoundChannel;
        }(SoundChannel);
    var AudioSound = /*#__PURE__*/
        function (_EventDispatcher5) {
            _inherits(AudioSound, _EventDispatcher5);
            var _super35 = _createSuper(AudioSound);
            function AudioSound() {
                var _this30;
                _classCallCheck(this, AudioSound);
                _this30 = _super35.apply(this, arguments);
                _this30.loaded = false;
                return _this30;
            }
            _createClass(AudioSound, [{
                key: "dispose",
                value: function dispose() {
                    var ad = AudioSound._audioCache[this.url];
                    Pool.clearBySign("audio:" + this.url);
                    if (ad) {
                        if (!Render.isConchApp) {
                            ad.src = "";
                        }
                        delete AudioSound._audioCache[this.url];
                    }
                }
            }, {
                key: "load",
                value: function load(url) {
                    url = URL.formatURL(url);
                    this.url = url;
                    var ad;
                    if (url == ILaya.SoundManager._bgMusic) {
                        AudioSound._initMusicAudio();
                        ad = AudioSound._musicAudio;
                        if (ad.src != url) {
                            AudioSound._audioCache[ad.src] = null;
                            ad = null;
                        }
                    } else {
                        ad = AudioSound._audioCache[url];
                    }
                    if (ad && ad.readyState >= 2) {
                        this.event(Event.COMPLETE);
                        return;
                    }
                    if (!ad) {
                        if (url == ILaya.SoundManager._bgMusic) {
                            AudioSound._initMusicAudio();
                            ad = AudioSound._musicAudio;
                        } else {
                            ad = Browser.createElement("audio");
                        }
                        AudioSound._audioCache[url] = ad;
                        ad.src = url;
                    }
                    ad.addEventListener("canplaythrough", onLoaded);
                    ad.addEventListener("error", onErr);
                    var me = this;
                    function onLoaded() {
                        offs();
                        me.loaded = true;
                        me.event(Event.COMPLETE);
                    }
                    function onErr() {
                        ad.load = null;
                        offs();
                        me.event(Event.ERROR);
                    }
                    function offs() {
                        ad.removeEventListener("canplaythrough", onLoaded);
                        ad.removeEventListener("error", onErr);
                    }
                    this.audio = ad;
                    if (ad.load) {
                        ad.load();
                    } else {
                        onErr();
                    }
                }
            }, {
                key: "play",
                value: function play() {
                    var startTime = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var loops = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    if (!this.url)
                        return null;
                    var ad;
                    if (this.url == ILaya.SoundManager._bgMusic) {
                        ad = AudioSound._musicAudio;
                    } else {
                        ad = AudioSound._audioCache[this.url];
                    }
                    if (!ad)
                        return null;
                    var tAd;
                    tAd = Pool.getItem("audio:" + this.url);
                    if (Render.isConchApp) {
                        if (!tAd) {
                            tAd = Browser.createElement("audio");
                            tAd.src = this.url;
                        }
                    } else {
                        if (this.url == ILaya.SoundManager._bgMusic) {
                            AudioSound._initMusicAudio();
                            tAd = AudioSound._musicAudio;
                            tAd.src = this.url;
                        } else {
                            tAd = tAd ? tAd : ad.cloneNode(true);
                        }
                    }
                    var channel = new AudioSoundChannel(tAd);
                    channel.url = this.url;
                    channel.loops = loops;
                    channel.startTime = startTime;
                    channel.play();
                    ILaya.SoundManager.addChannel(channel);
                    return channel;
                }
            }, {
                key: "duration",
                get: function get() {
                    var ad;
                    ad = AudioSound._audioCache[this.url];
                    if (!ad)
                        return 0;
                    return ad.duration;
                }
            }], [{
                key: "_initMusicAudio",
                value: function _initMusicAudio() {
                    if (AudioSound._musicAudio)
                        return;
                    if (!AudioSound._musicAudio)
                        AudioSound._musicAudio = Browser.createElement("audio");
                    if (!Render.isConchApp) {
                        Browser.document.addEventListener("mousedown", AudioSound._makeMusicOK);
                    }
                }
            }, {
                key: "_makeMusicOK",
                value: function _makeMusicOK() {
                    Browser.document.removeEventListener("mousedown", AudioSound._makeMusicOK);
                    if (!AudioSound._musicAudio.src) {
                        AudioSound._musicAudio.src = "";
                        AudioSound._musicAudio.load();
                    } else {
                        AudioSound._musicAudio.play();
                    }
                }
            }]);
            return AudioSound;
        }(EventDispatcher);
    AudioSound._audioCache = {};
    var WebAudioSoundChannel = /*#__PURE__*/
        function (_SoundChannel2) {
            _inherits(WebAudioSoundChannel, _SoundChannel2);
            var _super36 = _createSuper(WebAudioSoundChannel);
            function WebAudioSoundChannel() {
                var _this31;
                _classCallCheck(this, WebAudioSoundChannel);
                _this31 = _super36.call(this);
                _this31.bufferSource = null;
                _this31._currentTime = 0;
                _this31._volume = 1;
                _this31._startTime = 0;
                _this31._pauseTime = 0;
                _this31.context = ILaya.WebAudioSound.ctx;
                _this31._onPlayEnd = Utils.bind(_this31.__onPlayEnd, _assertThisInitialized(_this31));
                if (_this31.context["createGain"]) {
                    _this31.gain = _this31.context["createGain"]();
                } else {
                    _this31.gain = _this31.context["createGainNode"]();
                }
                return _this31;
            }
            _createClass(WebAudioSoundChannel, [{
                key: "play",
                value: function play() {
                    ILaya.SoundManager.addChannel(this);
                    this.isStopped = false;
                    this._clearBufferSource();
                    if (!this.audioBuffer)
                        return;
                    if (this.startTime >= this.duration)
                        return stop();
                    var context = this.context;
                    var gain = this.gain;
                    var bufferSource = context.createBufferSource();
                    this.bufferSource = bufferSource;
                    bufferSource.buffer = this.audioBuffer;
                    bufferSource.connect(gain);
                    if (gain)
                        gain.disconnect();
                    gain.connect(context.destination);
                    bufferSource.onended = this._onPlayEnd;
                    this._startTime = Browser.now();
                    if (this.gain.gain.setTargetAtTime) {
                        this.gain.gain.setTargetAtTime(this._volume, this.context.currentTime, WebAudioSoundChannel.SetTargetDelay);
                    } else
                        this.gain.gain.value = this._volume;
                    if (this.loops == 0) {
                        bufferSource.loop = true;
                    }
                    if (bufferSource.playbackRate.setTargetAtTime) {
                        bufferSource.playbackRate.setTargetAtTime(ILaya.SoundManager.playbackRate, this.context.currentTime, WebAudioSoundChannel.SetTargetDelay);
                    } else
                        bufferSource.playbackRate.value = ILaya.SoundManager.playbackRate;
                    bufferSource.start(0, this.startTime);
                    this._currentTime = 0;
                }
            }, {
                key: "__onPlayEnd",
                value: function __onPlayEnd() {
                    if (this.loops == 1) {
                        if (this.completeHandler) {
                            ILaya.timer.once(10, this, this.__runComplete, [this.completeHandler], false);
                            this.completeHandler = null;
                        }
                        this.stop();
                        this.event(Event.COMPLETE);
                        return;
                    }
                    if (this.loops > 0) {
                        this.loops--;
                    }
                    this.startTime = 0;
                    this.play();
                }
            }, {
                key: "position",
                get: function get() {
                    if (this.bufferSource) {
                        return (Browser.now() - this._startTime) / 1000 + this.startTime;
                    }
                    return 0;
                }
            }, {
                key: "duration",
                get: function get() {
                    if (this.audioBuffer) {
                        return this.audioBuffer.duration;
                    }
                    return 0;
                }
            }, {
                key: "_clearBufferSource",
                value: function _clearBufferSource() {
                    if (this.bufferSource) {
                        var sourceNode = this.bufferSource;
                        if (sourceNode.stop) {
                            sourceNode.stop(0);
                        } else {
                            sourceNode.noteOff(0);
                        }
                        sourceNode.disconnect(0);
                        sourceNode.onended = null;
                        if (!WebAudioSoundChannel._tryCleanFailed)
                            this._tryClearBuffer(sourceNode);
                        this.bufferSource = null;
                    }
                }
            }, {
                key: "_tryClearBuffer",
                value: function _tryClearBuffer(sourceNode) {
                    if (!Browser.onMac) {
                        try {
                            sourceNode.buffer = null;
                        } catch (e) {
                            WebAudioSoundChannel._tryCleanFailed = true;
                        }
                        return;
                    }
                    try {
                        sourceNode.buffer = ILaya.WebAudioSound._miniBuffer;
                    } catch (e) {
                        WebAudioSoundChannel._tryCleanFailed = true;
                    }
                }
            }, {
                key: "stop",
                value: function stop() {
                    _get(_getPrototypeOf(WebAudioSoundChannel.prototype), "stop", this).call(this);
                    this._clearBufferSource();
                    this.audioBuffer = null;
                    if (this.gain)
                        this.gain.disconnect();
                    this.isStopped = true;
                    ILaya.SoundManager.removeChannel(this);
                    this.completeHandler = null;
                    if (ILaya.SoundManager.autoReleaseSound)
                        ILaya.SoundManager.disposeSoundLater(this.url);
                }
            }, {
                key: "pause",
                value: function pause() {
                    if (!this.isStopped) {
                        this._pauseTime = this.position;
                    }
                    this._clearBufferSource();
                    if (this.gain)
                        this.gain.disconnect();
                    this.isStopped = true;
                    ILaya.SoundManager.removeChannel(this);
                    if (ILaya.SoundManager.autoReleaseSound)
                        ILaya.SoundManager.disposeSoundLater(this.url);
                }
            }, {
                key: "resume",
                value: function resume() {
                    this.startTime = this._pauseTime;
                    this.play();
                }
            }, {
                key: "volume",
                get: function get() {
                    return this._volume;
                },
                set: function set(v) {
                    this._volume = v;
                    if (this.isStopped) {
                        return;
                    }
                    if (this.gain.gain.setTargetAtTime) {
                        this.gain.gain.setTargetAtTime(v, this.context.currentTime, WebAudioSoundChannel.SetTargetDelay);
                    } else
                        this.gain.gain.value = v;
                }
            }]);
            return WebAudioSoundChannel;
        }(SoundChannel);
    WebAudioSoundChannel._tryCleanFailed = false;
    WebAudioSoundChannel.SetTargetDelay = 0.001;
    var WebAudioSound = /*#__PURE__*/
        function (_EventDispatcher6) {
            _inherits(WebAudioSound, _EventDispatcher6);
            var _super37 = _createSuper(WebAudioSound);
            function WebAudioSound() {
                var _this32;
                _classCallCheck(this, WebAudioSound);
                _this32 = _super37.apply(this, arguments);
                _this32.loaded = false;
                _this32._disposed = false;
                return _this32;
            }
            _createClass(WebAudioSound, [{
                key: "load",
                value: function load(url) {
                    var me = this;
                    url = URL.formatURL(url);
                    this.url = url;
                    this.audioBuffer = WebAudioSound._dataCache[url];
                    if (this.audioBuffer) {
                        this._loaded(this.audioBuffer);
                        return;
                    }
                    WebAudioSound.e.on("loaded:" + url, this, this._loaded);
                    WebAudioSound.e.on("err:" + url, this, this._err);
                    if (WebAudioSound.__loadingSound[url]) {
                        return;
                    }
                    WebAudioSound.__loadingSound[url] = true;
                    var request = new XMLHttpRequest();
                    request.open("GET", url, true);
                    request.responseType = "arraybuffer";
                    request.onload = function () {
                        if (me._disposed) {
                            me._removeLoadEvents();
                            return;
                        }
                        me.data = request.response;
                        WebAudioSound.buffs.push({
                            "buffer": me.data,
                            "url": me.url
                        });
                        WebAudioSound.decode();
                    }
                        ;
                    request.onerror = function (e) {
                        me._err();
                    }
                        ;
                    request.send();
                }
            }, {
                key: "_err",
                value: function _err() {
                    this._removeLoadEvents();
                    WebAudioSound.__loadingSound[this.url] = false;
                    this.event(Event.ERROR);
                }
            }, {
                key: "_loaded",
                value: function _loaded(audioBuffer) {
                    this._removeLoadEvents();
                    if (this._disposed) {
                        return;
                    }
                    this.audioBuffer = audioBuffer;
                    WebAudioSound._dataCache[this.url] = this.audioBuffer;
                    this.loaded = true;
                    this.event(Event.COMPLETE);
                }
            }, {
                key: "_removeLoadEvents",
                value: function _removeLoadEvents() {
                    WebAudioSound.e.off("loaded:" + this.url, this, this._loaded);
                    WebAudioSound.e.off("err:" + this.url, this, this._err);
                }
            }, {
                key: "__playAfterLoaded",
                value: function __playAfterLoaded() {
                    if (!this.__toPlays)
                        return;
                    var i, len;
                    var toPlays;
                    toPlays = this.__toPlays;
                    len = toPlays.length;
                    var tParams;
                    for (i = 0; i < len; i++) {
                        tParams = toPlays[i];
                        if (tParams[2] && !tParams[2].isStopped) {
                            this.play(tParams[0], tParams[1], tParams[2]);
                        }
                    }
                    this.__toPlays.length = 0;
                }
            }, {
                key: "play",
                value: function play() {
                    var startTime = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
                    var loops = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var channel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    channel = channel ? channel : new WebAudioSoundChannel();
                    if (!this.audioBuffer) {
                        if (this.url) {
                            if (!this.__toPlays)
                                this.__toPlays = [];
                            this.__toPlays.push([startTime, loops, channel]);
                            this.once(Event.COMPLETE, this, this.__playAfterLoaded);
                            this.load(this.url);
                        }
                    }
                    channel.url = this.url;
                    channel.loops = loops;
                    channel["audioBuffer"] = this.audioBuffer;
                    channel.startTime = startTime;
                    channel.play();
                    ILaya.SoundManager.addChannel(channel);
                    return channel;
                }
            }, {
                key: "duration",
                get: function get() {
                    if (this.audioBuffer) {
                        return this.audioBuffer.duration;
                    }
                    return 0;
                }
            }, {
                key: "dispose",
                value: function dispose() {
                    this._disposed = true;
                    delete WebAudioSound._dataCache[this.url];
                    delete WebAudioSound.__loadingSound[this.url];
                    this.audioBuffer = null;
                    this.data = null;
                    this.__toPlays = [];
                }
            }], [{
                key: "decode",
                value: function decode() {
                    if (WebAudioSound.buffs.length <= 0 || WebAudioSound.isDecoding) {
                        return;
                    }
                    WebAudioSound.isDecoding = true;
                    WebAudioSound.tInfo = WebAudioSound.buffs.shift();
                    WebAudioSound.ctx.decodeAudioData(WebAudioSound.tInfo["buffer"], WebAudioSound._done, WebAudioSound._fail);
                }
            }, {
                key: "_done",
                value: function _done(audioBuffer) {
                    WebAudioSound.e.event("loaded:" + WebAudioSound.tInfo.url, audioBuffer);
                    WebAudioSound.isDecoding = false;
                    WebAudioSound.decode();
                }
            }, {
                key: "_fail",
                value: function _fail() {
                    WebAudioSound.e.event("err:" + WebAudioSound.tInfo.url, null);
                    WebAudioSound.isDecoding = false;
                    WebAudioSound.decode();
                }
            }, {
                key: "_playEmptySound",
                value: function _playEmptySound() {
                    if (WebAudioSound.ctx == null) {
                        return;
                    }
                    var source = WebAudioSound.ctx.createBufferSource();
                    source.buffer = WebAudioSound._miniBuffer;
                    source.connect(WebAudioSound.ctx.destination);
                    source.start(0, 0, 0);
                }
            }, {
                key: "_unlock",
                value: function _unlock() {
                    if (WebAudioSound._unlocked) {
                        return;
                    }
                    WebAudioSound._playEmptySound();
                    if (WebAudioSound.ctx.state == "running") {
                        window.document.removeEventListener("mousedown", WebAudioSound._unlock, true);
                        window.document.removeEventListener("touchend", WebAudioSound._unlock, true);
                        window.document.removeEventListener("touchstart", WebAudioSound._unlock, true);
                        WebAudioSound._unlocked = true;
                    }
                }
            }, {
                key: "initWebAudio",
                value: function initWebAudio() {
                    if (WebAudioSound.ctx.state != "running") {
                        WebAudioSound._unlock();
                        window.document.addEventListener("mousedown", WebAudioSound._unlock, true);
                        window.document.addEventListener("touchend", WebAudioSound._unlock, true);
                        window.document.addEventListener("touchstart", WebAudioSound._unlock, true);
                    }
                }
            }]);
            return WebAudioSound;
        }(EventDispatcher);
    WebAudioSound._dataCache = {};
    WebAudioSound.webAudioEnabled = window["AudioContext"] || window["webkitAudioContext"] || window["mozAudioContext"];
    WebAudioSound.ctx = WebAudioSound.webAudioEnabled ? new (window["AudioContext"] || window["webkitAudioContext"] || window["mozAudioContext"])() : undefined;
    WebAudioSound.buffs = [];
    WebAudioSound.isDecoding = false;
    WebAudioSound._miniBuffer = WebAudioSound.ctx ? WebAudioSound.ctx.createBuffer(1, 1, 22050) : undefined;
    WebAudioSound.e = new EventDispatcher();
    WebAudioSound._unlocked = false;
    WebAudioSound.__loadingSound = {};
    var SoundManager = /*#__PURE__*/
        function () {
            function SoundManager() {
                _classCallCheck(this, SoundManager);
            }
            _createClass(SoundManager, null, [{
                key: "__init__",
                value: function __init__() {
                    var win = ILaya.Browser.window;
                    var supportWebAudio = win["AudioContext"] || win["webkitAudioContext"] || win["mozAudioContext"] ? true : false;
                    if (supportWebAudio)
                        WebAudioSound.initWebAudio();
                    SoundManager._soundClass = supportWebAudio ? WebAudioSound : AudioSound;
                    AudioSound._initMusicAudio();
                    SoundManager._musicClass = AudioSound;
                    return supportWebAudio;
                }
            }, {
                key: "addChannel",
                value: function addChannel(channel) {
                    if (SoundManager._channels.indexOf(channel) >= 0)
                        return;
                    SoundManager._channels.push(channel);
                }
            }, {
                key: "removeChannel",
                value: function removeChannel(channel) {
                    var i;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        if (SoundManager._channels[i] == channel) {
                            SoundManager._channels.splice(i, 1);
                        }
                    }
                }
            }, {
                key: "disposeSoundLater",
                value: function disposeSoundLater(url) {
                    SoundManager._lastSoundUsedTimeDic[url] = ILaya.Browser.now();
                    if (!SoundManager._isCheckingDispose) {
                        SoundManager._isCheckingDispose = true;
                        ILaya.timer.loop(5000, null, SoundManager._checkDisposeSound);
                    }
                }
            }, {
                key: "_checkDisposeSound",
                value: function _checkDisposeSound() {
                    var key;
                    var tTime = ILaya.Browser.now();
                    var hasCheck = false;
                    for (key in SoundManager._lastSoundUsedTimeDic) {
                        if (tTime - SoundManager._lastSoundUsedTimeDic[key] > 30000) {
                            delete SoundManager._lastSoundUsedTimeDic[key];
                            SoundManager.disposeSoundIfNotUsed(key);
                        } else {
                            hasCheck = true;
                        }
                    }
                    if (!hasCheck) {
                        SoundManager._isCheckingDispose = false;
                        ILaya.timer.clear(null, SoundManager._checkDisposeSound);
                    }
                }
            }, {
                key: "disposeSoundIfNotUsed",
                value: function disposeSoundIfNotUsed(url) {
                    var i;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        if (SoundManager._channels[i].url == url) {
                            return;
                        }
                    }
                    SoundManager.destroySound(url);
                }
            }, {
                key: "autoStopMusic",
                get: function get() {
                    return SoundManager._autoStopMusic;
                },
                set: function set(v) {
                    ILaya.stage.off(Event.BLUR, null, SoundManager._stageOnBlur);
                    ILaya.stage.off(Event.FOCUS, null, SoundManager._stageOnFocus);
                    ILaya.stage.off(Event.VISIBILITY_CHANGE, null, SoundManager._visibilityChange);
                    SoundManager._autoStopMusic = v;
                    if (v) {
                        ILaya.stage.on(Event.BLUR, null, SoundManager._stageOnBlur);
                        ILaya.stage.on(Event.FOCUS, null, SoundManager._stageOnFocus);
                        ILaya.stage.on(Event.VISIBILITY_CHANGE, null, SoundManager._visibilityChange);
                    }
                }
            }, {
                key: "_visibilityChange",
                value: function _visibilityChange() {
                    if (ILaya.stage.isVisibility) {
                        SoundManager._stageOnFocus();
                    } else {
                        SoundManager._stageOnBlur();
                    }
                }
            }, {
                key: "_stageOnBlur",
                value: function _stageOnBlur() {
                    SoundManager._isActive = false;
                    if (SoundManager._musicChannel) {
                        if (!SoundManager._musicChannel.isStopped) {
                            SoundManager._blurPaused = true;
                            SoundManager._musicChannel.pause();
                        }
                    }
                    SoundManager.stopAllSound();
                    ILaya.stage.once(Event.MOUSE_DOWN, null, SoundManager._stageOnFocus);
                }
            }, {
                key: "_recoverWebAudio",
                value: function _recoverWebAudio() {
                    if (WebAudioSound.ctx && WebAudioSound.ctx.state != "running" && WebAudioSound.ctx.resume)
                        WebAudioSound.ctx.resume();
                }
            }, {
                key: "_stageOnFocus",
                value: function _stageOnFocus() {
                    SoundManager._isActive = true;
                    SoundManager._recoverWebAudio();
                    ILaya.stage.off(Event.MOUSE_DOWN, null, SoundManager._stageOnFocus);
                    if (SoundManager._blurPaused) {
                        if (SoundManager._musicChannel && SoundManager._musicChannel.isStopped) {
                            SoundManager._blurPaused = false;
                            SoundManager._musicChannel.resume();
                        }
                    }
                }
            }, {
                key: "muted",
                get: function get() {
                    return SoundManager._muted;
                },
                set: function set(value) {
                    if (value == SoundManager._muted)
                        return;
                    if (value) {
                        SoundManager.stopAllSound();
                    }
                    SoundManager.musicMuted = value;
                    SoundManager._muted = value;
                }
            }, {
                key: "soundMuted",
                get: function get() {
                    return SoundManager._soundMuted;
                },
                set: function set(value) {
                    SoundManager._soundMuted = value;
                }
            }, {
                key: "musicMuted",
                get: function get() {
                    return SoundManager._musicMuted;
                },
                set: function set(value) {
                    if (value == SoundManager._musicMuted)
                        return;
                    if (value) {
                        if (SoundManager._bgMusic) {
                            if (SoundManager._musicChannel && !SoundManager._musicChannel.isStopped) {
                                if (ILaya.Render.isConchApp) {
                                    if (SoundManager._musicChannel._audio)
                                        SoundManager._musicChannel._audio.muted = true;
                                } else {
                                    SoundManager._musicChannel.pause();
                                }
                            } else {
                                SoundManager._musicChannel = null;
                            }
                        } else {
                            SoundManager._musicChannel = null;
                        }
                        SoundManager._musicMuted = value;
                    } else {
                        SoundManager._musicMuted = value;
                        if (SoundManager._bgMusic) {
                            if (SoundManager._musicChannel) {
                                if (ILaya.Render.isConchApp) {
                                    if (SoundManager._musicChannel._audio)
                                        SoundManager._musicChannel._audio.muted = false;
                                } else {
                                    SoundManager._musicChannel.resume();
                                }
                            }
                        }
                    }
                }
            }, {
                key: "useAudioMusic",
                get: function get() {
                    return SoundManager._useAudioMusic;
                },
                set: function set(value) {
                    SoundManager._useAudioMusic = value;
                    if (value) {
                        SoundManager._musicClass = AudioSound;
                    } else {
                        SoundManager._musicClass = null;
                    }
                }
            }, {
                key: "playSound",
                value: function playSound(url) {
                    var loops = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
                    var complete = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var soundClass = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
                    var startTime = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
                    if (!SoundManager._isActive || !url)
                        return null;
                    if (SoundManager._muted)
                        return null;
                    SoundManager._recoverWebAudio();
                    url = URL.formatURL(url);
                    if (url == SoundManager._bgMusic) {
                        if (SoundManager._musicMuted)
                            return null;
                    } else {
                        if (ILaya.Render.isConchApp) {
                            var ext = Utils.getFileExtension(url);
                            if (ext != "wav" && ext != "ogg") {
                                alert("The sound only supports wav or ogg format,for optimal performance reason,please refer to the official website document.");
                                return null;
                            }
                        }
                        if (SoundManager._soundMuted)
                            return null;
                    }
                    var tSound;
                    if (!ILaya.Browser.onBDMiniGame && !ILaya.Browser.onMiniGame && !ILaya.Browser.onKGMiniGame && !ILaya.Browser.onQGMiniGame && !ILaya.Browser.onVVMiniGame && !ILaya.Browser.onAlipayMiniGame && !ILaya.Browser.onQQMiniGame && !ILaya.Browser.onBLMiniGame) {
                        tSound = ILaya.loader.getRes(url);
                    }
                    if (!soundClass)
                        soundClass = SoundManager._soundClass;
                    if (!tSound) {
                        tSound = new soundClass();
                        tSound.load(url);
                        if (!ILaya.Browser.onBDMiniGame && !ILaya.Browser.onMiniGame && !ILaya.Browser.onKGMiniGame && !ILaya.Browser.onQGMiniGame && !ILaya.Browser.onVVMiniGame && !ILaya.Browser.onAlipayMiniGame && !ILaya.Browser.onQQMiniGame && !ILaya.Browser.onBLMiniGame) {
                            ILaya.Loader.cacheRes(url, tSound);
                        }
                    }
                    var channel;
                    channel = tSound.play(startTime, loops);
                    if (!channel)
                        return null;
                    channel.url = url;
                    channel.volume = url == SoundManager._bgMusic ? SoundManager.musicVolume : SoundManager.soundVolume;
                    channel.completeHandler = complete;
                    return channel;
                }
            }, {
                key: "destroySound",
                value: function destroySound(url) {
                    var tSound = ILaya.loader.getRes(url);
                    if (tSound) {
                        ILaya.Loader.clearRes(url);
                        tSound.dispose();
                    }
                }
            }, {
                key: "playMusic",
                value: function playMusic(url) {
                    var loops = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
                    var complete = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
                    var startTime = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
                    url = URL.formatURL(url);
                    SoundManager._bgMusic = url;
                    if (SoundManager._musicChannel)
                        SoundManager._musicChannel.stop();
                    return SoundManager._musicChannel = SoundManager.playSound(url, loops, complete, SoundManager._musicClass, startTime);
                }
            }, {
                key: "stopSound",
                value: function stopSound(url) {
                    url = URL.formatURL(url);
                    var i;
                    var channel;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        channel = SoundManager._channels[i];
                        if (channel.url == url) {
                            channel.stop();
                        }
                    }
                }
            }, {
                key: "stopAll",
                value: function stopAll() {
                    SoundManager._bgMusic = null;
                    var i;
                    var channel;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        channel = SoundManager._channels[i];
                        channel.stop();
                    }
                }
            }, {
                key: "stopAllSound",
                value: function stopAllSound() {
                    var i;
                    var channel;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        channel = SoundManager._channels[i];
                        if (channel.url != SoundManager._bgMusic) {
                            channel.stop();
                        }
                    }
                }
            }, {
                key: "stopMusic",
                value: function stopMusic() {
                    if (SoundManager._musicChannel)
                        SoundManager._musicChannel.stop();
                    SoundManager._bgMusic = null;
                }
            }, {
                key: "setSoundVolume",
                value: function setSoundVolume(volume) {
                    var url = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
                    if (url) {
                        url = URL.formatURL(url);
                        SoundManager._setVolume(url, volume);
                    } else {
                        SoundManager.soundVolume = volume;
                        var i;
                        var channel;
                        for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                            channel = SoundManager._channels[i];
                            if (channel.url != SoundManager._bgMusic) {
                                channel.volume = volume;
                            }
                        }
                    }
                }
            }, {
                key: "setMusicVolume",
                value: function setMusicVolume(volume) {
                    SoundManager.musicVolume = volume;
                    SoundManager._setVolume(SoundManager._bgMusic, volume);
                }
            }, {
                key: "_setVolume",
                value: function _setVolume(url, volume) {
                    url = URL.formatURL(url);
                    var i;
                    var channel;
                    for (i = SoundManager._channels.length - 1; i >= 0; i--) {
                        channel = SoundManager._channels[i];
                        if (channel.url == url) {
                            channel.volume = volume;
                        }
                    }
                }
            }]);
            return SoundManager;
        }();
    SoundManager.musicVolume = 1;
    SoundManager.soundVolume = 1;
    SoundManager.playbackRate = 1;
    SoundManager._useAudioMusic = true;
    SoundManager._muted = false;
    SoundManager._soundMuted = false;
    SoundManager._musicMuted = false;
    SoundManager._bgMusic = null;
    SoundManager._musicChannel = null;
    SoundManager._channels = [];
    SoundManager._blurPaused = false;
    SoundManager._isActive = true;
    SoundManager._lastSoundUsedTimeDic = {};
    SoundManager._isCheckingDispose = false;
    SoundManager.autoReleaseSound = true;
    var Prefab = /*#__PURE__*/
        function () {
            function Prefab() {
                _classCallCheck(this, Prefab);
            }
            _createClass(Prefab, [{
                key: "create",
                value: function create() {
                    if (this.json)
                        return ILaya.SceneUtils.createByData(null, this.json);
                    return null;
                }
   