(function () {
  'use strict';

  class EventMgr {
      static init() {
          EventMgr.instance = new Laya.EventDispatcher();
      }
      static on(eventName, self, func) {
          EventMgr.instance.on(eventName, self, func);
      }
      static event(EventType, data) {
          EventMgr.instance.event(EventType, data);
      }
      static once(EventType, a, c = null, d = null) {
          EventMgr.instance.once(EventType, a, c, d);
      }
      static off(EventType, a, c) {
          EventMgr.instance.off(EventType, a, c);
      }
  }

  let EventType = {
      LoadingSuc: 'LoadingSuc',
      ResProgress: 'ResProgress',
      EnterLoading: 'EnterLoading',
      RefreshCacheData: 'RefreshCacheData',
      RoleRefreshBullet: 'RoleRefreshBullet',
      RoleRefreshHp: 'RoleRefreshHp',
      RefreshHeroModel: 'RefreshHeroModel',
      BottomBoxVisible: 'BottomBoxVisible',
      RefreshRockerPos: 'RefreshRockerPos',
      RefreshKnobPos: 'RefreshKnobPos',
      CheckFireClick: 'CheckFireClick',
      RoleRefreshMagazine: 'RoleRefreshMagazine',
      RefreshRoleRegEvent: 'RefreshRoleRegEvent',
      RefreshSignAni: 'RefreshSignAni',
      RefreshSignShow: 'RefreshSignShow',
      RefreshVehIcon: 'RefreshVehIcon',
      HitShow: 'HitShow',
      RefreshDeadCnt: 'RefreshDeadCnt',
      Throw_start: 'Throw_start',
      Throw_end: 'Throw_end',
      Throw_Attack: 'Throw_Attack',
      Throw_AttackBegin: 'Throw_AttackBegin',
      ReadyLoadGun: 'ReadyLoadGun',
      ReadyLoadGrenade: 'ReadyLoadGrenade',
      CheckRockerClick: 'CheckRockerClick',
      ResultRefresh: 'ResultRefresh',
      RefreshVehGunShow: 'RefreshVehGunShow',
      ShowSniping: 'ShowSniping',
      RefreshGameUI: 'RefreshGameUI',
      StartCreateAI: 'StartCreateAI',
      RecoverPlayer: 'RecoverPlayer',
      CheckResult: 'CheckResult',
      ReviveTimeDown: 'ReviveTimeDown',
      RefreshVehBtn: 'RefreshVehBtn',
      RefreshTankShow: 'RefreshTankShow',
      Reload: 'Reload',
      RefreshCollimation: 'RefreshCollimation',
      RefreshTankBullet: 'RefreshTankBullet',
      RefreshTankSpeed: 'RefreshTankSpeed',
      RefreshTankCom: 'RefreshTankCom',
      RefreshTankRot: 'RefreshTankRot',
      showHit: 'showHit',
      showHit1: 'showHit1',
      InToGame: 'InToGame',
      onAim: 'onAim',
      RefreshMeritorious: 'RefreshMeritorious',
      RefreshVolume: 'RefreshVolume',
      HitEnemyShow: 'HitEnemyShow',
      AimShow: 'AimShow',
      HitTips: 'HitTips',
      GameBegin: 'GameBegin',
      GameInit: 'GameInit',
      ShowPro: 'ShowPro',
      RefreshBombCnt: 'RefreshBombCnt',
      RefreshVocationShow: 'RefreshVocationShow',
      gunClip: 'gunClip',
      RefreshShopWeapon: 'RefreshShopWeapon',
      RefreshShopDaily: 'RefreshShopDaily',
      GuideAniComplete: 'GuideAniComplete',
      LaunchGame: 'LaunchGame',
      RefreshPickUp: 'RefreshPickUp',
      RefreshAirDropBox: 'RefreshAirDropBox',
      RefreshGunShow: 'RefreshGunShow',
      RefreshDoubleHit: 'RefreshDoubleHit',
      PlayHeadShotAni: 'PlayHeadShotAni',
      SecLoadCom: 'SecLoadCom',
      RefreshAIrBoxShow: 'RefreshAIrBoxShow',
      FindPathData: 'FindPathData',
      OpenBox: 'OpenBox',
      UI_UPDATE_MATCHING_COUNT: 'UI_UPDATE_MATCHING_COUNT',
      RefreshVehNameShow: 'RefreshVehNameShow',
      ShowDropInfo: 'ShowDropInfo',
      RefreshVocation: 'RefreshVocation',
      RefreshMainWeapon: 'RefreshMainWeapon',
      RefreshViceWeapon: 'RefreshViceWeapon',
      RefreshGrenade: 'RefreshGrenade',
      RefreshCurSelect: 'RefreshCurSelect',
      ChangeGrenade: 'ChangeGrenade',
      ShowGetAmmoBox: 'ShowGetAmmoBox',
      RefreshVehIconShow: 'RefreshVehIconShow',
      RefreshMaxScore: 'RefreshMaxScore',
      ShowReceiveView: 'ShowReceiveView',
      RefreshAimBtn: 'RefreshAimBtn',
      RoleHpRefresh: 'RoleHpRefresh',
      GuideGetGun: 'GuideGetGun',
      RefreshDeformation: 'RefreshDeformation',
      refreshAddDeskVies: 'refreshAddDeskVies',
      refreshAddDesk: 'refreshAddDesk',
      RefreshNativeIcon: 'RefreshNativeIcon',
      CloseNativeIcon: 'CloseNativeIcon',
      ShowAd_view: 'ShowAd_view',
      setPosView: 'setPosView',
      RefreshNativeBanner: 'RefreshNativeBanner',
      CloseNativeBanner: 'CloseNativeBanner',
      RefreshNativeBanner1: 'RefreshNativeBanner1',
      CloseNativeBanner1: 'CloseNativeBanner1',
      RefreshNativeBanner2: 'RefreshNativeBanner2',
      CloseNativeBanner2: 'CloseNativeBanner2',
      BeginAniCom: 'BeginAniCom',
      RefreshGoods: 'RefreshGoods',
      refreshIcon: 'refreshIcon',
      refreshIcon1: 'refreshIcon1',
      RefreshRevive: 'RefreshRevive',
      SignVisible: 'SignVisible',
      RefreshWeapon1: 'RefreshWeapon1',
      RefreshSideData: 'RefreshSideData',
      RefreshTask: 'RefreshTask',
      RefreshTaskView: 'RefreshTaskView',
      RefreshTaskGet: 'RefreshTaskGet',
      RefreshTaskProgress: 'RefreshTaskProgress',
      DebugTaskTest: 'DebugTaskTest',
      DebugDelTaskTest: 'DebugDelTaskTest',
      DebugTaskLvTest: 'DebugTaskLvTest',
      DebugTaskExpTest: 'DebugTaskExpTest',
      VivoRefreshNativeBanner: 'VivoRefreshNativeBanner',
      VivoCloseNativeBanner: 'VivoCloseNativeBanner',
      setVivoPosView: 'setVivoPosView',
      RerfreshVehIcon: 'RerfreshVehIcon',
      RefreshQQBonusIcon: 'RefreshQQBonusIcon',
      OppoBannerVisible: 'OppoBannerVisible',
      gameExit: 'gameExit',
      changeClipPc: 'changeClipPc',
      switchArmPc: 'switchArmPc',
      showAimPc: 'showAimPc',
      useProp: 'useProp',
      changeRoleAngle: 'changeRoleAngle',
      onVehPc: 'onVehPc',
      onAimPc: 'onAimPc',
      exitFullscreen: 'exitFullscreen',
      onLockMouse: 'onLockMouse'
  };
  let DynamicSceneRoot = 'scene/Conventional/';
  let ESprite3D = {
      MainCamera: DynamicSceneRoot + 'MainCamera.lh',
      CameraPoint: DynamicSceneRoot + 'CamSlots.lh',
      CamTank: DynamicSceneRoot + 'CamTank.lh',
      CamHelicopter: DynamicSceneRoot + 'CamHelicopter.lh',
      Props: DynamicSceneRoot + 'Prop.lh',
      Effect: DynamicSceneRoot + 'Effect.lh',
      RoleDeadPoint: DynamicSceneRoot + 'RoleDeadPoint.lh',
      LvIslandA1: DynamicSceneRoot + 'LvIslandA1.ls',
      LvGuideA: DynamicSceneRoot + 'LvGuideA.ls',
      LvAircCarriA1: DynamicSceneRoot + 'LvAircCarriA1.ls',
      LvAircCarriA2: DynamicSceneRoot + 'LvAircCarriA2.ls',
      UI_AircCarrShow: DynamicSceneRoot + 'UI_AircCarrShow.ls',
      AirdropA: DynamicSceneRoot + 'AirdropA.lh',
      Shotgun_Fire_ef: DynamicSceneRoot + 'Shotgun_Fire_ef.lh',
      Bullet_02_ef: DynamicSceneRoot + 'Bullet_02_ef.lh',
      HandGun_Fire_ef: DynamicSceneRoot + 'HandGun_Fire_ef.lh'
  };
  let Effect = {
      Blood_01_ef: 'Blood_01_ef',
      Clot_ef: 'Clot_ef',
      XS_guide_ef: 'XS_guide_ef'
  };
  let SoundRoot = 'nativescene/sound/';
  let ESound = {
      Bgm: SoundRoot + 'BGM_6.mp3',
      BtnClick: SoundRoot + 'click.mp3',
      BtnClickOgg: SoundRoot + 'click.ogg',
      win: SoundRoot + 'win.mp3',
      fail: SoundRoot + 'fail.mp3'
  };
  let JsonRoot = 'nativescene/cfg/';
  let PathJsonRoot = 'JsonPath/';
  let EJson = {
      vehicleCfg: JsonRoot + 'vehicle.json',
      ModeinformationCfg: JsonRoot + 'modeinformation.json',
      DetectrangeCfg: JsonRoot + 'detectrange.json',
      AINameCfg: JsonRoot + 'aiName.json',
      BulletCfg: JsonRoot + 'bullet.json',
      AIskillsCfg: JsonRoot + 'AIskills.json',
      GunComponentCfg: JsonRoot + 'gunComponent.json',
      CoinParamCfg: JsonRoot + 'coinParam.json',
      SupplyPoint_01Cfg: JsonRoot + 'supplyPoint_01.json',
      guideCfg: JsonRoot + 'guidance.json',
      blindBoxCfg: JsonRoot + 'blindBox.json'
  };
  let PreEJson = {
      TreasureBoxCfg: JsonRoot + 'treasureBox.json',
      ResCfg: JsonRoot + 'res.json',
      startAdSampleJackpot: JsonRoot + 'startAdSampleJackpot.json',
      JackpotCfg: JsonRoot + 'jackpot.json',
      ShopCfg: JsonRoot + 'shop.json',
      ProfessionCfg: JsonRoot + 'profession.json',
      gunAttributeCfg: JsonRoot + 'gunAttribute.json',
      roleSkillCfg: JsonRoot + 'roleSkill.json',
      LevelCfg: JsonRoot + 'level.json',
      dailySignCfg: JsonRoot + 'dailySign.json',
      multilayerDiamondCfg: JsonRoot + 'multilayerDiamond.json',
      goodsGroupCfg: JsonRoot + 'goodsGroup.json',
      Constellation: JsonRoot + 'constellation.json',
      lotteryBoxCfg: JsonRoot + 'lotteryBox.json',
      LotteryBoxCirculationRewardCfg: JsonRoot + 'lotteryBoxCirculationReward.json',
      WarMakesMissionCfg: JsonRoot + 'warMakesMission.json',
      WarMakesRewardCfg: JsonRoot + 'warMakesReward.json'
  };
  let EAtlas = {
      Home: 'res/atlas/home.atlas',
      Game: 'res/atlas/xIndex.atlas',
      Battle: 'res/battle.atlas',
      common: 'res/common.atlas',
      comp: 'res/comp.atlas',
      icon: 'res/icon.atlas',
      ProfessionIcon: 'res/professionIcon.atlas',
      Matching: 'res/matching.atlas',
      selectMap: 'res/selectMap.atlas'
  };
  let EColor = {
      1: '#FFFFFF',
      2: '#5DB121',
      3: '#2959F6',
      4: '#D01AD7',
      5: '#F1DB1D'
  };
  let EQualityImg = {
      1: 'img_game_white.png',
      2: 'img_game_green.png',
      3: 'img_game_blue.png',
      4: 'img_game_violet.png',
      5: 'img_game_origin.png'
  };
  let EGunType = {
      1: '步枪',
      2: '冲锋枪',
      3: '重机枪',
      4: '狙击枪',
      5: '散弹枪',
      6: '榴弹步枪',
      7: '手枪',
      8: '投掷物-手雷',
      9: '喷火器',
      10: '火箭炮',
      11: '导弹',
      12: '榴弹枪',
      13: '坦克炮',
      14: '机炮',
      15: '其他功能性物品'
  };
  let EQuality = {
      1: '基础',
      2: '改良',
      3: '强化',
      4: '典藏',
      5: '传世'
  };
  var GameConst = {
      GameServer: 'wss://',
      LoginServer: 'https://',
      Query: null,
      NetLog: false,
      WsLog: false,
      Scene: 0,
      isShowWxAD: false,
      AppID: '100010309',
      BackStageID: '10152003',
      sideBoxId: '10152001',
      VivoAdCtrId: '10121003',
      vivoCtrTxt: 0,
      ActionId: 0,
      moduleId: 0,
      delaye1_switch: false,
      delaye2_switch: false,
      delaye3_switch: false,
      interval_switch: false,
      interval_switch1: false,
      interval_switch2: false,
      interval_switch3: false,
      dailySkillSwitch: false,
      weapenSwitch: false,
      reviveSwitch: false,
      moreWeapenSwitch: false,
      dailySkillTime: 90,
      dailySkillInterval: 90,
      dailySkillMaxCnt: 3,
      dailySkillLv: 2,
      delaytime: 1500,
      surDelayTime: 100,
      surDelayTime1: 100,
      surDelayLv: 2,
      interval: -1,
      wxBannerSurprised: false,
      wxBannerSurprised1: false,
      wxBannerReward: false,
      wxBannerReward1: false,
      wxBannerDelay: 1500,
      wxBannerBtnDelay: 2000,
      isShowMoreGame: true,
      gameTime: 0,
      interstRam: 0,
      wxAmmoSwitch: false,
      setRecive() {
          if (this.interval_switch) {
              GameConst.interval = 0;
              return;
          }
          else if (this.interval_switch1) {
              GameConst.interval = 1;
              return;
          }
          else if (this.interval_switch2) {
              GameConst.interval = 2;
          }
          else if (this.interval_switch3) {
              GameConst.interval = 3;
              return;
          }
          else {
              GameConst.interval = -1;
          }
      },
      getdalaytiem() {
          return this.delaytime;
      },
      getRecive() {
          return this.interval;
      }
  };
  let EUI = {
      DebugView: {
          class: 'DebugView'
      },
      LoadingUI: {
          class: 'LoadingUI'
      },
      HomeView: {
          class: 'HomeView'
      },
      ReadyView: {
          class: 'ReadyView'
      },
      ResultView: {
          class: 'ResultView',
          tween: true,
          mask: true,
          interstitial: true
      },
      GameView: {
          class: 'GameUI',
          interstitial: true
      },
      ReviveView: {
          class: 'ReviveView'
      },
      ShopView: {
          class: 'ShopView',
          interstitial: true
      },
      ArsenalView: {
          class: 'ArsenalView',
          banner: true,
          interstitial: true
      },
      SecLoadingView: {
          class: 'SecLoadingView',
          banner: true
      },
      WeaponInfoView: {
          class: 'WeaponInfoView',
          tween: true,
          mask: true
      },
      TwoBtnTips: {
          class: 'TwoBtnTips',
          mask: true,
          banner: true,
          interstitial: true
      },
      ShopBuyView: {
          class: 'ShopBuyView'
      },
      GuideView: {
          class: 'GuideUI'
      },
      TrialView: {
          class: 'TrialView'
      },
      DropAirBox: {
          class: 'DropAirBox'
      },
      MatchingView: {
          class: 'MatchingView'
      },
      HouseBagView: {
          class: 'HouseBagView',
          banner: true
      },
      SelectMapView: {
          class: 'SelectMapView',
          interstitial: true
      },
      SignView: {
          class: 'SignView',
          tween: true,
          mask: true
      },
      TrialWeaponDialog: {
          class: 'TrialWeaponDialog'
      },
      NetLoadingView: {
          class: 'NetLoadingView'
      },
      ProfessionView: {
          class: 'ProfessionView',
          banner: true
      },
      LogoView: {
          class: 'LogoViewUI'
      },
      OpenBoxView: {
          class: 'OpenBoxView',
          tween: true,
          mask: true,
          banner: true
      },
      AwardView: {
          class: 'AwardView',
          tween: true,
          mask: true
      },
      ChangeWeaponView: {
          class: 'ChangeWeaponView'
      },
      ChangeProView: {
          class: 'ChangeProView'
      },
      ChangeGrenadeView: {
          class: 'ChangeGrenadeView'
      },
      TestTipsView: {
          class: 'TestTipsView'
      },
      DailyKillView: {
          class: 'DailyKillView',
          interstitial: true
      },
      GuideGunTipsView: {
          class: 'GuideGunTipsView',
          tween: true,
          mask: true
      },
      GuideShopBox: {
          class: 'GuideShopBox',
          tween: true,
          mask: true
      },
      GuideGunGetView: {
          class: 'GuideGunGetView',
          tween: true,
          mask: true
      },
      CumulativePassView: {
          class: 'CumulativePassView',
          tween: true,
          mask: true
      },
      ConstellationWeaponView: {
          class: 'ConstellationWeaponView',
          tween: true,
          mask: true
      },
      OpenBoxRewardView: {
          class: 'OpenBoxRewardView',
          tween: true,
          mask: true
      },
      GetReward: {
          class: 'GetReward',
          tween: true,
          mask: true,
          delay: true,
          interstitial: true
      },
      TaskView: {
          class: 'TaskView',
          tween: true,
          mask: true,
          banner: true
      },
      ShareSucView: {
          class: 'ShareSucView',
          tween: true,
          mask: true
      },
      SurpriseRewardView: {
          class: 'SurpriseRewardView'
      },
      SideMoreBox_wx: {
          class: 'model/side/SideMoreBox_wx',
          mask: true
      },
      WxActivationVehView: {
          class: 'WxActivationVehView',
          tween: true,
          mask: true
      },
      WxLimitTimeGetView: {
          class: 'WxLimitTimeGetView',
          tween: true,
          mask: true
      },
      WxSurpriseRewardView: {
          class: 'WxSurpriseRewardView',
          mask: true,
          delay: true
      },
      CustomerView: {
          class: 'CustomerView',
          tween: true,
          mask: true
      },
      QQBonusView: {
          class: 'QQBonusView',
          tween: true,
          mask: true
      },
      QQBonusRewardView: {
          class: 'QQBonusRewardView',
          tween: true,
          mask: true
      }
  };
  var EGamePhase;
  (function (EGamePhase) {
      EGamePhase[EGamePhase["None"] = 0] = "None";
      EGamePhase[EGamePhase["Init"] = 1] = "Init";
      EGamePhase[EGamePhase["EnterGame"] = 2] = "EnterGame";
      EGamePhase[EGamePhase["InGame"] = 3] = "InGame";
      EGamePhase[EGamePhase["PauseGame"] = 4] = "PauseGame";
      EGamePhase[EGamePhase["OverGame"] = 5] = "OverGame";
  })(EGamePhase || (EGamePhase = {}));
  var PlayerPart;
  (function (PlayerPart) {
      PlayerPart[PlayerPart["Head"] = 0] = "Head";
      PlayerPart[PlayerPart["Body"] = 1] = "Body";
      PlayerPart[PlayerPart["Arms"] = 2] = "Arms";
  })(PlayerPart || (PlayerPart = {}));
  var Teammate;
  (function (Teammate) {
      Teammate[Teammate["Enemy"] = 1] = "Enemy";
      Teammate[Teammate["Teammate"] = 2] = "Teammate";
  })(Teammate || (Teammate = {}));
  var FSMState;
  (function (FSMState) {
      FSMState[FSMState["None"] = 0] = "None";
      FSMState[FSMState["Attack"] = 1] = "Attack";
      FSMState[FSMState["Dead"] = 2] = "Dead";
      FSMState[FSMState["reload"] = 3] = "reload";
      FSMState[FSMState["switchGun"] = 4] = "switchGun";
      FSMState[FSMState["FindPath"] = 5] = "FindPath";
      FSMState[FSMState["TankFindPathState"] = 6] = "TankFindPathState";
      FSMState[FSMState["TankAttackState"] = 7] = "TankAttackState";
      FSMState[FSMState["UseBomb"] = 8] = "UseBomb";
      FSMState[FSMState["LoadingState"] = 9] = "LoadingState";
      FSMState[FSMState["SwitchCatapultState"] = 10] = "SwitchCatapultState";
      FSMState[FSMState["PickUp"] = 11] = "PickUp";
  })(FSMState || (FSMState = {}));
  var curType = {
      HuMan: 'HuMan',
      Tank: 'Tank',
      Air: 'Air'
  };
  var PlayerCamp;
  (function (PlayerCamp) {
      PlayerCamp[PlayerCamp["Enemy"] = 1] = "Enemy";
      PlayerCamp[PlayerCamp["Teammate"] = 2] = "Teammate";
  })(PlayerCamp || (PlayerCamp = {}));
  var PropType;
  (function (PropType) {
      PropType[PropType["AutoGun"] = 1] = "AutoGun";
      PropType[PropType["SubmachineGun"] = 2] = "SubmachineGun";
      PropType[PropType["MachineGun"] = 3] = "MachineGun";
      PropType[PropType["SniperRifle"] = 4] = "SniperRifle";
      PropType[PropType["ShotGun"] = 5] = "ShotGun";
      PropType[PropType["GunWithBarrel"] = 6] = "GunWithBarrel";
      PropType[PropType["HandGun"] = 7] = "HandGun";
      PropType[PropType["Bomb"] = 8] = "Bomb";
      PropType[PropType["MilitaryFlamethrower"] = 9] = "MilitaryFlamethrower";
      PropType[PropType["RocketLauncher"] = 10] = "RocketLauncher";
      PropType[PropType["MissileLauncher"] = 11] = "MissileLauncher";
      PropType[PropType["GrenadeGun"] = 12] = "GrenadeGun";
      PropType[PropType["VehicleGunWeapon"] = 13] = "VehicleGunWeapon";
      PropType[PropType["VehicleMachineGun"] = 14] = "VehicleMachineGun";
      PropType[PropType["Bullet"] = 21] = "Bullet";
      PropType[PropType["Rocket"] = 22] = "Rocket";
      PropType[PropType["Missile"] = 23] = "Missile";
      PropType[PropType["BombPlacement"] = 24] = "BombPlacement";
      PropType[PropType["Grenade"] = 15] = "Grenade";
  })(PropType || (PropType = {}));
  var CamType;
  (function (CamType) {
      CamType[CamType["TPS"] = 0] = "TPS";
      CamType[CamType["FPS"] = 1] = "FPS";
  })(CamType || (CamType = {}));
  var AniType = {
      Idle: 'Stand1',
      forward: 'Forward',
      back: 'Backward',
      left: 'Left',
      right: 'Right',
      foward_left: 'Forward_L45',
      foward_right: 'Forward_R45',
      back_left: 'Backward_L45',
      back_right: 'Backward_R45',
      fire: 'Attack1',
      Huanqiang1: 'Huanqiang1',
      reload: 'Reload1_1',
      Dead1: 'Dead1',
      Dead2: 'Dead2',
      Dead3: 'Dead3',
      Dead5: 'Dead5',
      Hit1: 'Hit1',
      Dead4: 'Dead4',
      Throw_start: 'Throw_start',
      Throw_end: 'Throw_end',
      Throw_hold: 'Throw_hold'
  };
  const platformType = {
      None: 1001,
      Wechat: 2001,
      QQ: 3001,
      Oppo: 4001,
      Vivo: 5001,
      Toutiao: 6001,
      Xiaomi: 7001,
      HuaWei: 8001,
      FTNN: 9001,
      Android_op: 40010,
      Android_vv: 50010
  };

  class SoundMgr {
      static init() {
          var self = this;
          var getItem = Laya.LocalStorage.getItem;
          self.$openMusic = getItem(self.$cacheMusic) !== '0';
          self.$openSound = getItem(self.$cacheSound) !== '0';
          self.$openVibrate = getItem(self.$cacheVibrate) !== '0';
          Laya.SoundManager.autoStopMusic = true;
      }
      static get openMusic() {
          return this.$openMusic;
      }
      static set openMusic(open) {
          var self = this;
          if (self.$openMusic != open) {
              self.$openMusic = open;
              if (open)
                  self.playBGM();
              else
                  self.stopBGM();
              Laya.LocalStorage.setItem(self.$cacheMusic, Number(open) + '');
          }
      }
      static get openSound() {
          return this.$openSound;
      }
      static set openSound(open) {
          var self = this;
          if (self.$openSound != open) {
              self.$openSound = open;
              Laya.LocalStorage.setItem(self.$cacheSound, Number(open) + '');
          }
      }
      static get openVibrate() {
          return this.$openVibrate;
      }
      static set openVibrate(open) {
          var self = this;
          if (self.$openVibrate != open) {
              self.$openVibrate = open;
              Laya.LocalStorage.setItem(self.$cacheVibrate, Number(open) + '');
          }
      }
      static playBGM() {
          var self = this;
          Laya.SoundManager.playMusic(ESound.Bgm);
          self.setMusicVolume(0.6);
      }
      static stopBGM() {
          Laya.SoundManager.stopMusic();
      }
      static playBtnClick() {
          this.playSound(ESound.BtnClick);
      }
      static playSound(url, volume = -1, loops = 1) {
          if (this.openSound) {
              let sound = Laya.SoundManager.playSound(url, loops);
              if (volume != -1 && sound) {
                  sound.volume = volume;
              }
          }
      }
      static setMusicVolume(val) {
          Laya.SoundManager.setMusicVolume(val);
      }
      static setSoundVolume(val) {
          Laya.SoundManager.setSoundVolume(val);
      }
      static playVibrate(isLong) {
          if (this.openVibrate) {
          }
      }
  }
  SoundMgr.$cacheMusic = 'cacheMusic';
  SoundMgr.$cacheSound = 'cacheSound';
  SoundMgr.$cacheVibrate = 'cacheVibrate';

  var outCode = 0, valCode = 0, timeout = {}, interval = {};
  var clear = function (data, key) {
      var info = data[key];
      if (info) {
          delete data[key];
          Laya.timer.clear(null, info);
      }
  };
  class TimeUtils {
      constructor() { }
      static formatTen(num) {
          return (num > 9 ? '' : '0') + num;
      }
      static formatHour(second, sufix = ':') {
          var ten = TimeUtils.formatTen;
          var hour = (second / 3600) | 0;
          var min = ((second / 60) | 0) % 60;
          var sec = second % 60;
          return ten(hour) + sufix + ten(min) + sufix + ten(sec);
      }
      static getDay(time) {
          return ((time / 3600000 + 8) / 24) | 0;
      }
      static isSameDay(time0, time1) {
          var get = TimeUtils.getDay;
          return get(time0) == get(time1);
      }
      static setTimeout(call, thisObj, delay, ...param) {
          var curc = ++outCode;
          var func = (timeout[curc] = function () {
              call.apply(thisObj, param);
              delete timeout[curc];
          });
          Laya.timer.once(delay, null, func);
          return curc;
      }
      static clearTimeout(key) {
          clear(timeout, key);
      }
      static setInterval(call, thisObj, delay, ...param) {
          var curc = ++valCode;
          var func = (interval[curc] = function () {
              call.apply(thisObj, param);
          });
          Laya.timer.loop(delay, null, func);
          return curc;
      }
      static clearInterval(key) {
          clear(interval, key);
      }
  }

  class Timer {
      constructor(call, thisObj, delay = 1, isTime = true, isStop = false) {
          this.$runTime = 0;
          this.$runCount = 0;
          this.$call = call;
          this.$thisObj = thisObj;
          isStop || this.start();
          Laya.timer[isTime ? 'loop' : 'frameLoop'](delay, this, this.update);
      }
      update() {
          var self = this;
          if (self.$running) {
              self.$runCount++;
              self.$call.call(self.$thisObj);
          }
      }
      start() {
          var self = this;
          if (!self.$running) {
              self.$lastTime = Date.now();
              self.$running = true;
          }
      }
      stop() {
          var self = this;
          if (self.$running) {
              let nowT = Date.now();
              self.$runTime += nowT - self.$lastTime;
              self.$lastTime = nowT;
              self.$running = false;
          }
      }
      get running() {
          return this.$running;
      }
      get runTime() {
          var self = this;
          return self.$runTime + (self.running ? Date.now() - self.$lastTime : 0);
      }
      get runCount() {
          return this.$runCount;
      }
      reset() {
          var self = this;
          self.$runTime = self.$runCount = 0;
          self.$lastTime = Date.now();
      }
      clear() {
          var self = this;
          Laya.timer.clear(self, self.update);
          self.$call = self.$thisObj = null;
      }
  }

  var sign = 'LTween', cache = '$' + sign;
  var removeAt = function (array, item) {
      var index = array.indexOf(item);
      index > -1 && array.splice(index, 1);
  };
  class Tween {
      $init(target, props = null) {
          var self = this;
          var tweens = target[cache] || (target[cache] = []);
          tweens.push(self);
          self.$target = target;
          self.$frame = props.frame;
          self.$loop = props.loop;
          self.$once = props.once !== false;
          self.$frameCall = props.frameCall;
          self.$frameObj = props.frameObj;
          self.$curTime = 0;
          self.$needCopy = true;
          self.$steps = [];
          self.$cSteps = [];
          self.$timer = new Timer(self.$update, self, 1, false, true);
      }
      get $runTime() {
          var timer = this.$timer;
          return this.$frame ? timer.runCount : timer.runTime;
      }
      $update() {
          if (Laya.timer.scale == 0)
              return;
          var self = this;
          var steps = self.$steps, cSteps = self.$cSteps;
          if (self.$needCopy) {
              self.$needCopy = false;
              cSteps.push.apply(cSteps, steps);
          }
          var runTime = self.$runTime, remove = 0;
          for (let i = 0, len = steps.length; i < len; i++) {
              let step = steps[i];
              if (step.startTime > runTime)
                  break;
              self.$runStep(step);
              if (step.endTime <= runTime)
                  remove++;
          }
          remove > 0 && steps.splice(0, remove);
          var call = self.$frameCall;
          call && call.call(self.$frameObj);
          steps = self.$steps;
          if (steps && steps.length == 0) {
              if (self.$loop) {
                  self.$timer.reset();
                  self.$steps = cSteps.concat();
              }
              else {
                  self.$once ? self.clear() : self.$pause();
              }
          }
      }
      $pause() {
          var self = this;
          var timer = self.$timer;
          self.$needCopy = true;
          self.$curTime = 0;
          self.$steps = [];
          timer.stop();
          timer.reset();
      }
      $addStep(type, duration, param = null) {
          var self = this;
          var startTime = self.$curTime;
          var endTime = (self.$curTime = startTime + duration);
          self.$steps.push({
              type,
              startTime,
              endTime,
              param
          });
          self.$timer.start();
      }
      $getIncrement(start, end) {
          var copy = {};
          var keys = Object.keys(end);
          var hasv = function (obj) {
              return !!obj || (obj != null && obj != void 0);
          };
          for (let i in keys) {
              let key = keys[i];
              let value = start[key];
              if (hasv(value))
                  copy[key] = end[key] - value;
          }
          return copy;
      }
      $runStep(step) {
          var self = this;
          var type = step.type;
          switch (type) {
              case 0:
                  self.$to(step);
                  break;
              case 1:
                  self.$set(step.param);
                  break;
              case 2:
                  break;
              case 3:
                  self.$call(step.param);
                  break;
          }
      }
      $to(step) {
          var self = this;
          var start = step.startTime;
          var ratio = Math.min((self.$runTime - start) / (step.endTime - start), 1);
          var param = step.param;
          var ease = param[0];
          ease && (ratio = ease(ratio));
          var target = self.$target, endp = param[1], dstp = param[2] || (param[2] = self.$getIncrement(target, endp));
          for (let i in dstp) {
              target[i] = endp[i] - dstp[i] * (1 - ratio);
          }
      }
      $set(props) {
          var self = this;
          var target = self.$target;
          for (let i in props)
              target[i] = props[i];
      }
      $call(param) {
          param[0].apply(param[1], param[2]);
      }
      to(props, duration = 0, ease = null) {
          var self = this;
          if (isNaN(duration) || duration <= 0) {
              self.set(props);
          }
          else {
              self.$addStep(0, duration, [ease, props]);
          }
          return self;
      }
      set(props) {
          var self = this;
          self.$addStep(1, 0, props);
          return self;
      }
      wait(delay) {
          var self = this;
          delay > 0 && self.$addStep(2, delay);
          return self;
      }
      call(call, thisObj, params) {
          var self = this;
          call && self.$addStep(3, 0, [call, thisObj, params]);
          return self;
      }
      repeat(repeat, step) {
          var self = this;
          if (repeat > 0 && self.$timer) {
              let steps = self.$cSteps.concat().concat(self.$steps), len = steps.length;
              if (len > 0) {
                  if (!(step > 0) || step > len)
                      step = len;
                  let startI = len - step;
                  for (let i = 0; i < repeat; i++) {
                      for (let j = 0; j < step; j++) {
                          let step = steps[startI + j];
                          self.$addStep(step.type, step.endTime - step.startTime, step.param);
                      }
                  }
              }
          }
          return self;
      }
      stop() {
          var timer = this.$timer;
          timer && timer.stop();
      }
      resume() {
          var timer = this.$timer;
          timer && timer.start();
      }
      clear() {
          var self = this;
          if (self.$timer) {
              let target = self.$target;
              let tweens = target[cache];
              if (tweens instanceof Array) {
                  removeAt(tweens, self);
                  tweens.length == 0 && delete target[cache];
              }
              self.$timer.clear();
              self.$timer =
                  self.$steps =
                      self.$cSteps =
                          self.$target =
                              self.$frameCall =
                                  self.$frameObj =
                                      null;
              Laya.Pool.recover(sign, self);
          }
      }
      static get(target, props = {}) {
          var tween = Laya.Pool.getItemByClass(sign, Tween);
          tween.$init(target, props || {});
          return tween;
      }
      static once(target, props) {
          Tween.clear(target);
          return Tween.get(target, props);
      }
      static clear(target) {
          if (target) {
              let tweens = target[cache];
              if (tweens instanceof Array) {
                  for (let i = 0, len = tweens.length; i < len; i++) {
                      let tween = tweens[i];
                      tween instanceof Tween && tween.clear();
                  }
              }
              delete target[cache];
          }
      }
      static clearAll(root) {
          var cs = root['_children'];
          Tween.clear(root);
          if (cs) {
              for (let i = 0, len = cs.length; i < len; i++)
                  Tween.clearAll(cs[i]);
          }
      }
      static turnEase(ease) {
          return function (t) {
              return ease(t, 0, 1, 1);
          };
      }
  }

  class Vector3Ex {
  }
  Vector3Ex.ZERO = new Laya.Vector3(0, 0, 0);
  Vector3Ex.One = new Laya.Vector3(1, 1, 1);
  Vector3Ex.Up = new Laya.Vector3(0, 1, 0);
  Vector3Ex.Down = new Laya.Vector3(0, -1, 0);
  Vector3Ex.ForwardLH = new Laya.Vector3(0, 0, 1);
  Vector3Ex.ForwardRH = new Laya.Vector3(0, 0, -1);
  Vector3Ex.UnitX = new Laya.Vector3(1, 0, 0);
  Vector3Ex.UnitY = new Laya.Vector3(0, 1, 0);
  Vector3Ex.UnitZ = new Laya.Vector3(0, 0, 1);
  Vector3Ex.Quaternion = new Laya.Quaternion();

  var Vector3$1 = Laya.Vector3;
  class Utils {
      constructor() { }
      static cloneArray(source) {
          let result = [];
          for (let i = 0; i < source.length; i++) {
              result.push(source[i]);
          }
          return result;
      }
      static DistanceSquared(x1, y1, x2, y2) {
          let offx = x1 - x2;
          let offy = y1 - y2;
          return offx * offx + offy * offy;
      }
      static MapDistanceSquared(pos1, pos2) {
          let offx = pos1.x - pos2.x;
          let offz = pos1.z - pos2.z;
          let dist = offx * offx + offz * offz;
          return dist;
      }
      static GetAngle(dx, dy) {
          if (dy == 0) {
              return dx > 0 ? 0 : 180;
          }
          let angle = (Math.atan(dx / dy) * 180) / Math.PI;
          if (dy < 0) {
              if (dx < 0)
                  angle = 180 + Math.abs(angle);
              else
                  angle = 180 - Math.abs(angle);
          }
          angle = 90 - angle;
          return angle;
      }
      static parseInt(_strNum) {
          if (_strNum == null || _strNum == 'undefined') {
              return 0;
          }
          let intNum = parseFloat(_strNum);
          if (intNum) {
              return Math.floor(intNum);
          }
          return 0;
      }
      static isEmpty(obj) {
          if (typeof obj == 'undefined' || obj == null || obj == '') {
              return true;
          }
          else {
              return false;
          }
      }
      static isEqual(a, b) {
          let offVal = a - b;
          return Utils.nearZero(offVal);
      }
      static nearZero(val) {
          return val >= -0.001 && val <= 0.001;
      }
      static equalVec(vecA, vecB) {
          return (this.isEqual(vecA.x, vecB.x) && this.isEqual(vecA.y, vecB.y) && this.isEqual(vecA.z, vecB.z));
      }
      static vec3NearZero(vec) {
          return this.nearZero(vec.x) && this.nearZero(vec.y) && this.nearZero(vec.z);
      }
      static SmoothDamp(current, target, currentVelocity, smoothTime, maxSpeed = -1, deltaTime, output) {
          if (maxSpeed == -1) {
              maxSpeed = Number.MAX_VALUE;
          }
          smoothTime = Math.max(0.0001, smoothTime);
          let omega = 2.0 / smoothTime;
          let x = omega * deltaTime;
          let exp = 1.0 / (1.0 + x + 0.48 * x * x + 0.235 * x * x * x);
          Vector3$1.subtract(current, target, Utils._changeVec);
          target.cloneTo(Utils._originalTo);
          let maxChange = maxSpeed * smoothTime;
          Utils.ClampMagnitude(Utils._changeVec, maxChange);
          Vector3$1.subtract(current, Utils._changeVec, target);
          Vector3$1.scale(Utils._changeVec, omega, Utils._tmpVec);
          Vector3$1.add(currentVelocity, Utils._tmpVec, Utils._tmpVec);
          Vector3$1.scale(Utils._tmpVec, deltaTime, Utils._tmpVec);
          Vector3$1.scale(Utils._tmpVec, omega, Utils._tmpVec2);
          Vector3$1.subtract(currentVelocity, Utils._tmpVec2, Utils._tmpVec2);
          Vector3$1.scale(Utils._tmpVec2, exp, currentVelocity);
          Vector3$1.add(Utils._changeVec, Utils._tmpVec, Utils._tmpVec);
          Vector3$1.scale(Utils._tmpVec, exp, Utils._tmpVec);
          Vector3$1.add(target, Utils._tmpVec, output);
          Vector3$1.subtract(Utils._originalTo, current, Utils._tmpVec);
          Vector3$1.subtract(output, Utils._originalTo, Utils._tmpVec2);
          if (Vector3$1.dot(Utils._tmpVec, Utils._tmpVec2) > 0) {
              Utils._originalTo.cloneTo(output);
              Vector3$1.subtract(output, Utils._originalTo, Utils._tmpVec);
              Vector3$1.scale(Utils._tmpVec, 1 / deltaTime, currentVelocity);
          }
      }
      static ClampMagnitude(vec, maxLength) {
          if (Vector3$1.scalarLengthSquared(vec) > maxLength * maxLength) {
              Vector3$1.normalize(vec, vec);
              Vector3$1.scale(vec, maxLength, vec);
          }
      }
      static Range(min, max) {
          return min + Math.random() * (max - min);
      }
      static IntRange(min, max) {
          return Math.round(Utils.Range(min, max));
      }
      static DegToRad(deg) {
          return (deg * Math.PI) / 180;
      }
      static RadToDeg(rad) {
          return (rad * 180) / Math.PI;
      }
      static getGravity(height, time) {
          let gravity = (2 * height) / (time * time);
          return gravity;
      }
      static RotatePos(pos, centerPos, eulerY, outPos) {
          let rad = Utils.DegToRad(eulerY - 180);
          let cos = Math.cos(rad);
          let sin = Math.sin(rad);
          let x = (pos.x - centerPos.x) * cos + (pos.z - centerPos.z) * sin + centerPos.x;
          let z = -(pos.x - centerPos.x) * sin + (pos.z - centerPos.z) * cos + centerPos.z;
          outPos.setValue(x, 0, z);
      }
      static formatTimestamp(time) {
          let str;
          let hour;
          let min;
          let sec;
          let hourStr;
          let minStr;
          let secStr;
          hour = Math.floor(time / 3600);
          min = Math.floor((time % 3600) / 60);
          sec = Math.floor((time % 3600) % 60);
          hourStr = hour >= 10 ? hour.toString() : '0' + hour;
          minStr = min >= 10 ? min.toString() : '0' + min;
          secStr = sec >= 10 ? sec.toString() : '0' + sec;
          str = hourStr + ':' + minStr + ':' + secStr;
          return str;
      }
      static formatTime(time) {
          let str;
          let min;
          let sec;
          let secStr;
          let minStr;
          min = Math.floor(time / 60);
          sec = Math.floor(time % 60);
          secStr = sec >= 10 ? sec.toString() : '0' + sec;
          minStr = min >= 10 ? min.toString() : '0' + min;
          str = minStr + ':' + secStr;
          return str;
      }
      static formatNum(num) {
          let str = num.toString();
          if (str.length == 1) {
              str = '00' + num;
          }
          else if (str.length == 2) {
              str = '0' + num;
          }
          return str;
      }
      static log(...params) {
          let str = Utils.formatDate(new Date(), '[hh:mm:ss.S]');
          params.forEach(element => {
              str += ' ' + JSON.stringify(element);
          });
          console.log(str);
      }
      static formatDate(date, fmt) {
          let o = {
              'Y+': date.getFullYear(),
              'M+': date.getMonth() + 1,
              'd+': date.getDate(),
              'h+': date.getHours(),
              'm+': date.getMinutes(),
              's+': date.getSeconds(),
              S: date.getMilliseconds()
          };
          if (/(y+)/.test(fmt))
              fmt = fmt.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
          for (let k in o)
              if (new RegExp('(' + k + ')').test(fmt))
                  fmt = fmt.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length));
          return fmt;
      }
      static checkPhoneIsBangs() {
      }
      static addRedPoint(btn, isRed, top = 8, right = 1) {
          let _redPoint = btn.getChildByName('redPoint');
          if (_redPoint) {
              _redPoint.visible = isRed;
          }
          else if (isRed) {
              _redPoint = new Laya.Image('game/game_redPoint.png');
              _redPoint.name = 'redPoint';
              btn.addChild(_redPoint);
              _redPoint.top = top;
              _redPoint.right = right;
          }
      }
      static shuffle(arr) {
          var len = arr.length;
          for (var i = 0; i < len - 1; i++) {
              var index = Math.floor(Math.random() * (len - i));
              var temp = arr[index];
              arr[index] = arr[len - i - 1];
              arr[len - i - 1] = temp;
          }
          return arr;
      }
      static getTodayDate() {
          let myDate = new Date();
          let year = myDate.getFullYear();
          let month = myDate.getMonth() + 1;
          let date = myDate.getDate();
          let today = '' + year + '_' + month + '_' + date;
          return today;
      }
      static mathSinCos(attr, angle) {
          return Math[attr]((angle * Math.PI) / 180);
      }
      static sin(angle) {
          return Utils.mathSinCos('sin', angle);
      }
      static cos(angle) {
          return angle % 180 == 90 ? 0 : Utils.mathSinCos('cos', angle);
      }
      static initNativeFiles(path, files) {
          var adpters = [Laya.MiniAdpter, Laya.VVMiniAdapter, Laya['QQMiniAdapter'], Laya.QGMiniAdapter];
          var hasChange = false;
          for (let i in adpters) {
              let adpter = adpters[i];
              if (adpter) {
                  if (adpter != Laya.QGMiniAdapter) {
                      adpter.AutoCacheDownFile = true;
                  }
                  adpter.nativefiles = files;
                  hasChange = true;
              }
          }
          if (hasChange) {
              let fileMgr = Laya['MiniFileMgr'];
              if (fileMgr) {
                  let pLen = path.length, fLen = files.length, i, file, sIdx;
                  fileMgr.isLocalNativeFile = function (url) {
                      sIdx = url.indexOf(path) == 0 ? pLen : 0;
                      if (url[0] !== '/') {
                          for (i = 0; i < fLen; i++) {
                              file = files[i];
                              if (url.indexOf(file, sIdx) == sIdx && url[sIdx + file.length] == '/') {
                                  return true;
                              }
                          }
                      }
                      return false;
                  };
              }
              Laya.URL.basePath = Laya.URL['_basePath'] = path;
          }
      }
      static initCDNFiles(path, files) {
          var adpters = [
              Laya['MiniAdpter'],
              Laya.VVMiniAdapter,
              Laya['QQMiniAdapter'],
              Laya.QGMiniAdapter,
              Laya.HWMiniAdapter,
              Laya.TTMiniAdapter
          ];
          var hasChange = false;
          for (let i in adpters) {
              if (adpters[i]) {
                  hasChange = true;
              }
          }
          if (hasChange) {
              let url = Laya.URL;
              let fuc = url.customFormat;
              let format, index;
              url.customFormat = function (url) {
                  url = fuc(url);
                  index = format = url.indexOf('/');
                  if (index > 0) {
                      format = url.substr(0, index);
                      for (let i in files) {
                          if (files[i] === format) {
                              url = path + url;
                              break;
                          }
                      }
                  }
                  return url;
              };
          }
      }
      static memset(length, value) {
          return Array.apply(null, Array(length)).map(function (v, i) {
              return value;
          });
      }
      static memset2(length, create) {
          return Array.apply(null, Array(length)).map(function (v, i) {
              return create(i);
          });
      }
      static randomInArray(array, item) {
          var length = array.length, splice = length;
          if (length > 1 && item != void 0) {
              let index = array.indexOf(item);
              if (index > -1) {
                  length--;
                  splice = index;
              }
          }
          var rndIdx = (Math.random() * length) | 0;
          if (rndIdx >= splice)
              rndIdx++;
          return array[rndIdx];
      }
      static randomSort(array) {
          if (!array)
              return;
          return array.sort(function (a, b) {
              return Math.random() - 0.5;
          });
      }
      static rmSplice(array) {
          var len = array.length;
          var index = (Math.random() * len) | 0;
          return array.splice(index, 1)[0];
      }
      static removeItem(array, rmFun) {
          if (array) {
              for (let i = 0, len = array.length; i < len; i++) {
                  if (rmFun(array[i])) {
                      array.splice(i, 1);
                      i--;
                      len--;
                  }
              }
          }
      }
      static formatStringReg(reg, str, args) {
          for (let i in args) {
              let arg = args[i];
              if (reg.test(str))
                  str = str.replace(reg, args[i]);
              else
                  break;
          }
          return str;
      }
      static formatString(str, ...args) {
          str = str.replace(/%%/g, '%');
          return Utils.formatStringReg(/%d|%s/i, str, args);
      }
      static drawRoundRect(graphics, width, height, round) {
          var paths = [
              ['moveTo', round, 0],
              ['lineTo', width - round, 0],
              ['arcTo', width, 0, width, round, round],
              ['lineTo', width, height - round],
              ['arcTo', width, height, width - round, height, round],
              ['lineTo', round, height],
              ['arcTo', 0, height, 0, height - round, round],
              ['lineTo', 0, round],
              ['arcTo', 0, 0, round, 0, round]
          ];
          graphics.drawPath(0, 0, paths, {
              fillStyle: '#0'
          });
      }
      static screenToStage(pixel) {
      }
      static uiEnableCall(view, call, thisObj, ...params) {
          if (view['_getBit'](Laya.Const.AWAKED)) {
              call.apply(thisObj, params);
          }
          else {
              let func = view.onEnable;
              view.onEnable = function () {
                  func.call(view);
                  view.onEnable = func;
                  call.apply(thisObj, params);
              };
          }
      }
      static centerChild(parent, num, dist = 0) {
          var cs = parent['_children'];
          if (cs) {
              let len = cs.length;
              if (len > 0) {
                  let sum = 0, i, j = 0, arr = [];
                  num === void 0 && (num = len);
                  for (i = 0; i < len; i++) {
                      let csi = cs[i];
                      if (csi.visible) {
                          sum += csi.width;
                          arr.push(csi);
                          if (++j >= num) {
                              break;
                          }
                      }
                  }
                  len = arr.length;
                  sum = (parent.width - sum - (len - 1) * dist) / 2;
                  for (i = 0; i < len; i++) {
                      arr[i].x = sum;
                      sum += arr[i].width + dist;
                  }
              }
          }
      }
      static initVSBtn(btn, module, childIdx, format) {
          var config = 0;
          return config;
      }
      static showMisTouch(view, offsetY = 0, later, func) {
          if (later) {
              view.visible = false;
              Laya.timer.frameOnce(2, Utils, Utils.showMisTouch, [view, offsetY, false, func], false);
          }
          else {
              let height = view.height;
              let parent = view.parent;
              let oldY = view.y, anchorY = view.anchorY || 0;
              let point = Utils.globalToLocal(parent, 0, (660 / 750) * Laya.stage.height);
              view.y = point.y;
              view.visible = true;
              let delay = GameConst.wxBannerBtnDelay;
              Laya.timer.once(delay, null, function () {
                  view.y = oldY + ((view.anchorY || 0) - anchorY) * height;
                  func && func();
              });
          }
      }
      static addClick(node, func, thisObj, once, data, time = 300) {
          var fun = once ? 'once' : 'on', clickTime = 0, params = [], evtIdx;
          node.offAll();
          if (data !== void 0) {
              params.push(data);
              evtIdx = 1;
          }
          node[fun](Laya.Event.CLICK, thisObj, function (e) {
              var now = Date.now();
              e.stopPropagation();
              if (now - clickTime < time) {
                  return;
              }
              params[evtIdx] = e;
              SoundMgr.playBtnClick();
              func.apply(thisObj, params);
              clickTime = now;
          });
          if (node instanceof Laya.UIComponent || node instanceof Laya.View) {
              if (isNaN(node.anchorX)) {
                  node.anchorX = 0.5;
                  node.x += node.width * 0.5;
              }
              if (isNaN(node.anchorY)) {
                  node.anchorY = 0.5;
                  node.y += node.height * 0.5;
              }
          }
          var isTouch = false;
          var oldsx = node.scaleX, oldsy = node.scaleY;
          var nextx = oldsx + (oldsx > 0 ? 1 : -1) * 0.05;
          var nexty = oldsy + (oldsy > 0 ? 1 : -1) * 0.05;
          var tOnce = Tween.once;
          var onDown = function (e) {
              isTouch = true;
              e.stopPropagation();
              tOnce(node, {}).to({
                  scaleX: nextx,
                  scaleY: nexty
              }, 200, null);
          };
          var onOut = function (e) {
              if (isTouch) {
                  isTouch = false;
                  e.stopPropagation();
                  tOnce(node, {}).to({
                      scaleX: oldsx,
                      scaleY: oldsy
                  }, 200, null);
              }
          };
          node.on(Laya.Event.MOUSE_DOWN, thisObj, onDown);
          node.on(Laya.Event.MOUSE_UP, thisObj, onOut);
          node.on(Laya.Event.MOUSE_OUT, thisObj, onOut);
      }
      static addClick2(target, call, thisObj) {
          SoundMgr.playBtnClick();
          target.on(Laya.Event.CLICK, thisObj, call);
      }
      static getRes(url, type) {
          return new Promise(function (resolve) {
              let loader = Laya.loader;
              let res = loader.getRes(url);
              if (res)
                  resolve(res);
              else
                  loader.load(url, Laya.Handler.create(null, resolve), null, type);
          });
      }
      static isIPhone() {
          return false;
      }
      static multipleClick(view, multiple, distance, call, thisObj) {
          var count = 0, lastTime, curTime, timeout;
          view.on(Laya.Event.CLICK, this, function () {
              curTime = Date.now();
              if (curTime - lastTime > distance)
                  count = 0;
              lastTime = curTime;
              if (++count >= multiple) {
                  count = 0;
                  call && call.call(thisObj);
              }
              TimeUtils.clearTimeout(timeout);
              timeout = TimeUtils.setTimeout(function () {
                  count = 0;
              }, null, distance);
          });
      }
      static copy(obj) {
          var ret;
          if (typeof obj === 'object') {
              ret = obj instanceof Array ? [] : Object.create(null);
              for (let i in obj) {
                  ret[i] = Utils.copy(obj[i]);
              }
          }
          else
              ret = obj;
          return ret;
      }
      static copyAttrs(attrs, target, source) {
          for (let i = 0, len = attrs.length; i < len; i++) {
              let attr = attrs[i];
              target[attr] = source[attr];
          }
      }
      static globalToLocal(sprite, x, y) {
          var temp = Laya.Point.TEMP;
          temp.setTo(x, y);
          sprite.globalToLocal(temp);
          return temp;
      }
      static removeArrayObj(array, obj) {
          if (array) {
              for (let i = array.length - 1; i >= 0; i--) {
                  if (array[i] == obj) {
                      array.splice(i, 1);
                  }
              }
          }
      }
      static localToStage(sprite, x, y) {
          var temp = Laya.Point.TEMP;
          temp.setTo(x, y);
          sprite.localToGlobal(temp);
          return temp;
      }
      static getChildren(_node) {
          let children = [];
          if (_node) {
              for (let index = 0; index < _node.numChildren; index++) {
                  children.push(_node.getChildAt(index));
              }
          }
          return children;
      }
      static isHit(_checkSprite, _extW = 0, _extH = 0) {
          if (_checkSprite) {
              let touchPos = _checkSprite.getMousePoint();
              let touchArea = new Laya.Rectangle(0 - _extW / 2, 0 - _extH / 2, _checkSprite.width + _extW, _checkSprite.height + _extH);
              return touchArea.contains(touchPos.x, touchPos.y);
          }
          return false;
      }
      static addMeshCollision(target) {
          if (target instanceof Laya.MeshSprite3D) {
              if (!target.getComponent(Laya.PhysicsCollider)) {
                  let collider = target.addComponent(Laya.PhysicsCollider);
                  let meshShape = new Laya.MeshColliderShape();
                  meshShape.mesh = target.meshFilter.sharedMesh;
                  collider.colliderShape = meshShape;
              }
          }
          else {
              for (let i = 0; i < target.numChildren; i++) {
                  let temp = target.getChildAt(i);
                  Utils.addMeshCollision(temp);
              }
          }
      }
      static hexToColor4F(e) {
          e = e.replace(/^#?/, '0x');
          var t = parseInt(e);
          if (t > 16777215) {
              var i = (t >> 24) & 255, a = (t >> 16) & 255, s = (t >> 8) & 255, r = 255 & t;
              return new Laya.Vector4(i / 255, a / 255, s / 255, r / 255);
          }
          return ((i = (t >> 16) & 255),
              (a = (t >> 8) & 255),
              (s = 255 & t),
              new Laya.Vector4(i / 255, a / 255, s / 255, 1));
      }
      static vec3ToTargetVal(attribute, cnt, model, targetVal = null) {
          let obj = model;
          for (let i = 0; i < cnt; i++) {
              let vec = obj.transform[attribute];
              if (!targetVal) {
                  if (obj.transform[attribute] instanceof Laya.Vector3) {
                      targetVal = Vector3Ex.ZERO;
                  }
                  else {
                      targetVal = Vector3Ex.Quaternion;
                  }
              }
              targetVal.cloneTo(vec);
              obj.transform[attribute] = vec;
              obj = obj.parent;
          }
      }
      static frameLoop(total, frameNum, call, thisObj) {
          if (total > 0 && frameNum > 0) {
              let loop = function (i) {
                  if (i < total) {
                      for (let j = 0, num = Math.min(total - i, frameNum); j < num; j++) {
                          call.call(thisObj, i + j);
                      }
                      Laya.timer.frameOnce(1, Utils, loop, [i + frameNum]);
                  }
              };
              loop(0);
          }
      }
      static getAngle(x, y) {
          var atan;
          if (x == 0) {
              atan = y > 0 ? 90 : 270;
          }
          else {
              atan = (Math.atan(y / x) / Math.PI) * 180;
              x < 0 && (atan += 180);
          }
          return atan;
      }
  }
  Utils._originalTo = new Vector3$1();
  Utils._changeVec = new Vector3$1();
  Utils._tmpVec = new Vector3$1();
  Utils._tmpVec2 = new Vector3$1();

  class UIBaseView extends Laya.View {
      constructor() {
          super();
          this.$events = {};
          this.$calls = [];
      }
      onClosed() {
          super.onClosed();
          var self = this, eventMgr = EventMgr.instance, events = self.$events;
          for (let name in events) {
              eventMgr.off(name, self, events[name]);
          }
          self.$events = null;
          var calls = self.$calls, param = self.closeParam;
          for (let i in calls) {
              let data = calls[i];
              data[0].call(data[1], param);
          }
          self.offAll();
          self.$calls = self.closeParam = null;
          Laya.timer.clearAll(this);
      }
      regEvent(eventName, func) {
          var self = this;
          self.$events[eventName] = func;
          EventMgr.on(eventName, self, func);
      }
      regClick(node, func, once = false, data = null, time = 0) {
          Utils.addClick(node, func, this, once, data, time);
      }
      onShow() { }
      onHide() { }
      onShowInScene() { }
      onTweenCom() { }
      setCloseCall(call, thisObj) {
          this.$calls.push([call, thisObj]);
      }
  }

  var View = Laya.View;
  var REG = Laya.ClassUtils.regClass;
  Laya.UIBaseView = UIBaseView;
  var ui;
  (function (ui) {
      var Ani;
      (function (Ani) {
          class aim_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(aim_aniUI.uiView);
              }
          }
          aim_aniUI.uiView = { "type": "View", "props": { "width": 86, "runtime": "", "height": 86 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 43, "x": 43, "width": 86, "var": "imgSign", "scaleY": 0.5, "scaleX": 0.5, "height": 86, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4, "child": [{ "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "scaleY": 1, "scaleX": 1, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "skewY": 180, "skewX": 0, "rotation": 0, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }] }], "animations": [{ "nodes": [{ "target": 6, "keyframes": { "x": [{ "value": 43, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "x", "index": 0 }], "scaleY": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 10 }], "scaleX": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 10 }], "alpha": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 10 }] } }, { "target": 7, "keyframes": { "x": [{ "value": 43, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "x", "index": 0 }], "scaleY": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 10 }], "scaleX": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 10 }], "alpha": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 0 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 10 }] } }, { "target": 2, "keyframes": { "runtime": [{}] } }], "name": "ani1", "id": 1, "frameRate": 24, "action": 0 }], "loadList": ["battle/bg_zhunxin_2.png"], "loadList3D": [] };
          Ani.aim_aniUI = aim_aniUI;
          REG("ui.Ani.aim_aniUI", aim_aniUI);
          class AK_Gold_efUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(AK_Gold_efUI.uiView);
              }
          }
          AK_Gold_efUI.uiView = { "type": "View", "props": { "width": 217, "runtime": "script/ui/AK_Gold_ef.ts", "height": 135 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 67.5, "x": 108.5, "scaleY": 0.8, "scaleX": 0.8 }, "compId": 3, "child": [{ "type": "Image", "props": { "y": 2, "x": 2, "skin": "Texture2D/AK_Gold_00.png", "name": "gun_glow", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.78 }, "compId": 8 }, { "type": "Image", "props": { "skin": "Texture2D/AK_Gold.png", "name": "gun", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 2, "x": 2, "skin": "Texture2D/AK_Gold_00.png", "name": "gun_glow", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.4633333333333333 }, "compId": 10 }, { "type": "Image", "props": { "y": 48, "x": -51, "skin": "Texture2D/Font_xsrw.png", "scaleY": 1.09, "scaleX": 1.09, "rotation": -2.4, "name": "xsrw", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": -60, "x": 57, "skin": "Texture2D/Font_bdjl.png", "scaleY": 1, "scaleX": 1, "rotation": 0, "name": "bdjl", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }] }], "animations": [{ "nodes": [{ "target": 8, "keyframes": { "alpha": [{ "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 30 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 60 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 10 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 30 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 45 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 10 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 30 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 45 }], "rotation": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "rotation", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 15 }, { "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 20 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "rotation", "index": 30 }] } }, { "target": 7, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 20 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 30 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 40 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 55 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 20 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 30 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 40 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 55 }], "rotation": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 25 }, { "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 30 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 35 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "rotation", "index": 40 }] } }, { "target": 10, "keyframes": { "alpha": [{ "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 0 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 30 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 60 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/AK_Gold_00.png", "Texture2D/AK_Gold.png", "Texture2D/Font_xsrw.png", "Texture2D/Font_bdjl.png"], "loadList3D": [] };
          Ani.AK_Gold_efUI = AK_Gold_efUI;
          REG("ui.Ani.AK_Gold_efUI", AK_Gold_efUI);
          class GameCountdown_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GameCountdown_aniUI.uiView);
              }
          }
          GameCountdown_aniUI.uiView = { "type": "View", "props": { "runtime": "script/ui/GameCountdown_ani.ts", "mouseThrough": true, "mouseEnabled": false }, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "FontClip", "props": { "value": "1", "skin": "Texture2D/Number.png", "skewY": 0, "sheet": "0123456789", "scaleY": 1, "scaleX": 1, "name": "FontA", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "FontClip", "props": { "y": 0, "x": 0, "value": "1", "skin": "Texture2D/Number.png", "skewY": 0, "skewX": 0, "sheet": "0123456789", "scaleY": 2, "scaleX": 2, "rotation": 0, "name": "FontB", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 6 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "value": [{ "value": "10", "tweenMethod": "linearNone", "tween": false, "target": 4, "key": "value", "index": 0 }, { "value": "10", "tweenMethod": "linearNone", "tween": false, "target": 4, "key": "value", "index": 23 }, { "value": "9", "tweenMethod": "linearNone", "tween": false, "target": 4, "key": "value", "index": 24 }, { "value": "9", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 47 }, { "value": "8", "tweenMethod": "linearNone", "tween": false, "target": 4, "key": "value", "index": 48 }, { "value": "8", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 71 }, { "value": "7", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 72 }, { "value": "7", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 95 }, { "value": "6", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 96 }, { "value": "6", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 119 }, { "value": "5", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 120 }, { "value": "5", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 143 }, { "value": "4", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 144 }, { "value": "4", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 167 }, { "value": "3", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 168 }, { "value": "3", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 191 }, { "value": "2", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 192 }, { "value": "2", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 215 }, { "value": "1", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 216 }, { "value": "1", "tweenMethod": "linearNone", "tween": false, "target": 4, "label": null, "key": "value", "index": 239 }], "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 23 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 29 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 47 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 53 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 71 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 72 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 77 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 95 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 96 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 101 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 119 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 120 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 125 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 143 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 144 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 149 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 167 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 168 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 173 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 191 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 192 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 197 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 215 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 216 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 221 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 239 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 23 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 29 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 47 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 53 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 71 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 72 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 77 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 95 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 96 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 101 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 119 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 120 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 125 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 143 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 144 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 149 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 167 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 168 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 173 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 191 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 192 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 197 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 215 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 216 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 221 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 239 }] } }, { "target": 6, "keyframes": { "value": [{ "value": "10", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 0 }, { "value": "10", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 23 }, { "value": "9", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 24 }, { "value": "9", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 47 }, { "value": "8", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 48 }, { "value": "8", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 71 }, { "value": "7", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 72 }, { "value": "7", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 95 }, { "value": "6", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 96 }, { "value": "6", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 119 }, { "value": "5", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 120 }, { "value": "5", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 143 }, { "value": "4", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 144 }, { "value": "4", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 167 }, { "value": "3", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 168 }, { "value": "3", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 191 }, { "value": "2", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 192 }, { "value": "2", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 215 }, { "value": "1", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 216 }, { "value": "1", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "value", "index": 239 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 5 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 19 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 23 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 29 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 43 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 47 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 53 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 67 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 71 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 72 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 77 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 91 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 95 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 96 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 101 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 115 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 119 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 120 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 125 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 139 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 143 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 144 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 149 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 163 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 167 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 168 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 173 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 187 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 191 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 192 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 197 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 211 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 215 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 216 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 221 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 235 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 239 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 5 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 19 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 23 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 29 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 43 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 47 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 53 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 67 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 71 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 72 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 77 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 91 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 95 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 96 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 101 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 115 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 119 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 120 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 125 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 139 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 143 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 144 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 149 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 163 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 167 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 168 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 173 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 187 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 191 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 192 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 197 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 211 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 215 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 216 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 221 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 235 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 239 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 8 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 19 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 23 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 24 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 29 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 43 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 47 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 48 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 53 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 56 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 67 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 71 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 72 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 77 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 80 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 91 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 95 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 96 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 101 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 104 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 115 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 119 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 120 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 125 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 128 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 139 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 143 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 144 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 149 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 152 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 163 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 167 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 168 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 173 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 176 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 187 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 191 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 192 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 197 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 200 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 211 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 215 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 216 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 221 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 224 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 235 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 239 }] } }], "name": "ani1", "id": 1, "frameRate": 24, "action": 0 }], "loadList": ["Texture2D/Number.png"], "loadList3D": [] };
          Ani.GameCountdown_aniUI = GameCountdown_aniUI;
          REG("ui.Ani.GameCountdown_aniUI", GameCountdown_aniUI);
          class HeadShot_efUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(HeadShot_efUI.uiView);
              }
          }
          HeadShot_efUI.uiView = { "type": "View", "props": { "width": 211, "runtime": "script/ui/HeadShot_ef.ts", "height": 90 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 211, "height": 90 }, "compId": 8, "child": [{ "type": "Image", "props": { "y": 43, "x": 105, "skin": "Texture2D/HeadShot.png", "scaleY": 1, "scaleX": 1, "name": "Headshot_1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 1 }, "compId": 4 }, { "type": "Image", "props": { "y": 43, "x": 105, "skin": "Texture2D/HeadShot.png", "scaleY": 3, "scaleX": 3, "name": "Headshot_2", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 5 }, { "type": "Image", "props": { "y": 43, "x": 105, "skin": "Texture2D/HeadShot.png", "scaleY": 3, "scaleX": 3, "name": "Headshot_3", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 6 }, { "type": "Image", "props": { "y": 43, "x": 105, "skin": "Texture2D/HeadShot.png", "scaleY": 3, "scaleX": 3, "name": "Headshot_4", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 7 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "scaleY": [{ "value": 4, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 3 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 5 }], "scaleX": [{ "value": 4, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 3 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 5 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 2 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 50 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 60 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 3 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 12 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 3 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 12 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 3 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 5 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 12 }] } }, { "target": 6, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 7 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 17 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 7 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 17 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 7 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 17 }] } }, { "target": 7, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 11 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 21 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 11 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 21 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 11 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 14 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 21 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 0 }], "loadList": ["Texture2D/HeadShot.png"], "loadList3D": [] };
          Ani.HeadShot_efUI = HeadShot_efUI;
          REG("ui.Ani.HeadShot_efUI", HeadShot_efUI);
          class KillFont_efUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(KillFont_efUI.uiView);
              }
          }
          KillFont_efUI.uiView = { "type": "View", "props": { "width": 168, "runtime": "script/ui/KillFont_ef.ts", "height": 83 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 41, "x": 84, "width": 76, "height": 48 }, "compId": 3, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/Kill.png", "scaleY": 1, "scaleX": 1, "name": "Kill_1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 1 }, "compId": 4 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/Kill.png", "scaleY": 3, "scaleX": 3, "name": "Kill_2", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 5 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "scaleY": [{ "value": 4, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 3 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 5 }], "scaleX": [{ "value": 4, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 3 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 5 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 2 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 50 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 60 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 3 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 12 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 3 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 12 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 3 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 5 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 12 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 0 }], "loadList": ["Texture2D/Kill.png"], "loadList3D": [] };
          Ani.KillFont_efUI = KillFont_efUI;
          REG("ui.Ani.KillFont_efUI", KillFont_efUI);
          class Ready_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(Ready_aniUI.uiView);
              }
          }
          Ready_aniUI.uiView = { "type": "View", "props": { "width": 269, "runtime": "script/ui/Ready_ani.ts", "height": 107 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": -21, "x": -15, "width": 283, "height": 124 }, "compId": 19, "child": [{ "type": "Image", "props": { "y": 71.75, "x": 148.75, "skin": "Texture2D/Ready.png", "scaleY": 1, "scaleX": 1, "name": "Ready", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": 71.75, "x": 148.75, "skin": "Texture2D/ReadyOK.png", "scaleY": 1, "scaleX": 1, "name": "Font", "anchorY": 0.5, "anchorX": 0.5, "alpha": 1 }, "compId": 6 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_01.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 7 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_02.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "2", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 8 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_03.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "3", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 9 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_04.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "4", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 10 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_05.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "5", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 11 }, { "type": "Image", "props": { "y": 71.75, "x": 148.75, "skin": "Texture2D/GO!.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "Go", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 18 }, { "type": "Image", "props": { "y": 71.75, "x": 148.75, "skin": "Texture2D/ReadyOK.png", "scaleY": 1, "scaleX": 1, "name": "Font_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 12 }, { "type": "Image", "props": { "y": 71.75, "x": 141.75, "skin": "Texture2D/Number_01.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "1_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 13 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_02.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "2_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 14 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_03.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "3_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 15 }, { "type": "Image", "props": { "y": 71.75, "x": 146.75, "skin": "Texture2D/Number_04.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "4_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 16 }, { "type": "Image", "props": { "y": 42, "x": 167.75, "skin": "Texture2D/Number_05.png", "scaleY": 1, "scaleX": 1, "rotation": 1, "name": "5_g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 17 }] }], "animations": [{ "nodes": [{ "target": 7, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 104 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 107 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleY", "index": 111 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 104 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 107 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "scaleX", "index": 111 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 103 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 104 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 124 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 125 }] } }, { "target": 8, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleY", "index": 83 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleY", "index": 86 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleY", "index": 90 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 83 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 86 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 90 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 82 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 83 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 103 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 104 }] } }, { "target": 9, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleY", "index": 62 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleY", "index": 65 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleY", "index": 69 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleX", "index": 62 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleX", "index": 65 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "label": null, "key": "scaleX", "index": 69 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "alpha", "index": 61 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "alpha", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "alpha", "index": 83 }] } }, { "target": 10, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 41 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 44 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 48 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 41 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 44 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 48 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 40 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 41 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 61 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 62 }] } }, { "target": 11, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 20 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 23 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 27 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 20 }, { "value": 1.7, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 23 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 27 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 19 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 40 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 41 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 3 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 7 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 20 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 23 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 25 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 27 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 41 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 44 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 46 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 62 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 65 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 67 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 69 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 83 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 86 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 104 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 107 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 109 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 111 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 124 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 127 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 129 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 131 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 3 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 7 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 20 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 23 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 25 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 27 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 41 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 44 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 46 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 48 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 62 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 65 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 67 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 69 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 83 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 86 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 104 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 107 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 109 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 111 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 124 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 127 }, { "value": 0.95, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 129 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 131 }] } }, { "target": 6, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 4 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 7 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 15 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 20 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 4 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 7 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 15 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 20 }], "alpha": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 15 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 20 }] } }, { "target": 12, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleY", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleY", "index": 4 }, { "value": 1.4, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "scaleY", "index": 5 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleY", "index": 9 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "scaleY", "index": 11 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleX", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleX", "index": 4 }, { "value": 1.4, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "scaleX", "index": 5 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "scaleX", "index": 9 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "scaleX", "index": 11 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 4 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "alpha", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 7 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "alpha", "index": 11 }] } }, { "target": 13, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 104 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 108 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 113 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 104 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 108 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 113 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 104 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 108 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 111 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 114 }] } }, { "target": 17, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleY", "index": 20 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleY", "index": 24 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleY", "index": 29 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleX", "index": 20 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleX", "index": 24 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "scaleX", "index": 29 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 30 }] } }, { "target": 16, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleY", "index": 41 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleY", "index": 45 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleY", "index": 50 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleX", "index": 41 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleX", "index": 45 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "scaleX", "index": 50 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 41 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 45 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 48 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 51 }] } }, { "target": 15, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 15, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleY", "index": 62 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleY", "index": 66 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleY", "index": 71 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 15, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleX", "index": 62 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleX", "index": 66 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "scaleX", "index": 71 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 15, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "alpha", "index": 69 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 15, "label": null, "key": "alpha", "index": 72 }] } }, { "target": 14, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 83 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 87 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 92 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 83 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 87 }, { "value": 3.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 92 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 83 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 87 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 90 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 93 }] } }, { "target": 18, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleY", "index": 125 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleY", "index": 128 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleY", "index": 132 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleX", "index": 125 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleX", "index": 128 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "scaleX", "index": 132 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 124 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 125 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 145 }] } }], "name": "ani1", "id": 1, "frameRate": 20, "action": 0 }], "loadList": ["Texture2D/Ready.png", "Texture2D/ReadyOK.png", "Texture2D/Number_01.png", "Texture2D/Number_02.png", "Texture2D/Number_03.png", "Texture2D/Number_04.png", "Texture2D/Number_05.png", "Texture2D/GO!.png"], "loadList3D": [] };
          Ani.Ready_aniUI = Ready_aniUI;
          REG("ui.Ani.Ready_aniUI", Ready_aniUI);
          class Serialkilling_efUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(Serialkilling_efUI.uiView);
              }
          }
          Serialkilling_efUI.uiView = { "type": "View", "props": { "runtime": "" }, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "Image", "props": { "skin": "Texture2D/Combo.png", "name": "Combo", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 13, "x": 122, "skin": "Texture2D/X.png", "scaleY": 0.7, "scaleX": 0.7, "name": "X", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "FontClip", "props": { "y": 15, "x": 165, "value": "99", "spaceX": -20, "skin": "Texture2D/Number.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "name": "Number", "anchorY": 0.7, "anchorX": 0.1 }, "compId": 6 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "x": [{ "value": -300, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "x", "index": 4 }], "skewX": [{ "value": -45, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "skewX", "index": 0 }, { "value": -40, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "skewX", "index": 4 }, { "value": 10, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "skewX", "index": 6 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "skewX", "index": 8 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 4 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 6 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 9 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 4 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 6 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 9 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 7 }, { "value": 0.9, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 10 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 12 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 7 }, { "value": 0.9, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 10 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 12 }] } }, { "target": 6, "keyframes": { "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 9 }, { "value": 1.3, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 12 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 15 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 9 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 12 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 15 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 0 }], "loadList": ["Texture2D/Combo.png", "Texture2D/X.png", "Texture2D/Number.png"], "loadList3D": [] };
          Ani.Serialkilling_efUI = Serialkilling_efUI;
          REG("ui.Ani.Serialkilling_efUI", Serialkilling_efUI);
          class tegongquan_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(tegongquan_aniUI.uiView);
              }
          }
          tegongquan_aniUI.uiView = { "type": "View", "props": { "width": 135, "runtime": "", "height": 135 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 64, "x": 64 }, "compId": 4, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/tegongquan_dikuang.png", "name": "3", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/tegongquan_dikuang.png", "scaleY": 1, "scaleX": 1, "name": "3g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 8 }, { "type": "Image", "props": { "y": -3, "x": 0, "skin": "Texture2D/tegongquan_02.png", "scaleY": 1, "scaleX": 1, "name": "2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Image", "props": { "y": -3, "x": 0, "skin": "Texture2D/tegongquan_02.png", "scaleY": 1, "scaleX": 1, "name": "2g", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 10 }, { "type": "Image", "props": { "y": 48, "x": 4, "skin": "Texture2D/dianjijiusong.png", "scaleY": 1, "scaleX": 1, "name": "1-2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": 28, "x": -15, "skin": "Texture2D/jingxibuduan.png", "scaleY": 1, "scaleX": 1, "name": "1-1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 9 }, { "type": "Image", "props": { "y": 32.5, "x": 29, "skin": "Texture2D/star.png", "scaleY": 0.4, "scaleX": 0.4, "rotation": 45, "name": "star_1", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 11 }, { "type": "Image", "props": { "y": 20, "x": -47, "skin": "Texture2D/star.png", "scaleY": 0.2, "scaleX": 0.2, "rotation": 45, "name": "star_2", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 13 }] }], "animations": [{ "nodes": [{ "target": 8, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 0 }, { "value": 1.4, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 0 }, { "value": 1.4, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 40 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 0 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 15 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 40 }] } }, { "target": 9, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleY", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleY", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleY", "index": 20 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleX", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleX", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 9, "key": "scaleX", "index": 20 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 15 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 25 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 35 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 15 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 25 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 35 }] } }, { "target": 6, "keyframes": { "y": [{ "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "y", "index": 0 }, { "value": -8, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "y", "index": 20 }, { "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "y", "index": 40 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 40 }] } }, { "target": 10, "keyframes": { "y": [{ "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "y", "index": 0 }, { "value": -8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "y", "index": 20 }, { "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "y", "index": 40 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 0 }, { "value": 1.3, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 0 }, { "value": 1.3, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 40 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 0 }, { "value": 0.25, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "alpha", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 40 }] } }, { "target": 11, "keyframes": { "scaleY": [{ "value": 0.2, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 0 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleY", "index": 17 }], "scaleX": [{ "value": 0.2, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 0 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 17 }], "rotation": [{ "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "rotation", "index": 0 }, { "value": 90, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "rotation", "index": 17 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 0 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 7 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "alpha", "index": 17 }] } }, { "target": 13, "keyframes": { "scaleY": [{ "value": 0.15, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 0 }, { "value": 0.15, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 20 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 37 }], "scaleX": [{ "value": 0.15, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 0 }, { "value": 0.15, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 20 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 37 }], "rotation": [{ "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "rotation", "index": 0 }, { "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "rotation", "index": 20 }, { "value": 90, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "rotation", "index": 37 }], "name": [{ "value": "star_2", "tweenMethod": "linearNone", "tween": false, "target": 13, "key": "name", "index": 0 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 20 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 37 }] } }], "name": "ani1", "id": 1, "frameRate": 24, "action": 2 }], "loadList": ["Texture2D/tegongquan_dikuang.png", "Texture2D/tegongquan_02.png", "Texture2D/dianjijiusong.png", "Texture2D/jingxibuduan.png", "Texture2D/star.png"], "loadList3D": [] };
          Ani.tegongquan_aniUI = tegongquan_aniUI;
          REG("ui.Ani.tegongquan_aniUI", tegongquan_aniUI);
          class xianshilingqu_efUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(xianshilingqu_efUI.uiView);
              }
          }
          xianshilingqu_efUI.uiView = { "type": "View", "props": { "width": 148, "runtime": "script/ui/xianshilingqu_ef.ts", "height": 172 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 89, "x": 75 }, "compId": 3, "child": [{ "type": "Image", "props": { "skin": "Texture2D/Tank.png", "name": "tank", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 62, "x": 0, "skin": "Texture2D/xianshilingqu.png", "name": "font", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }] }, { "type": "Label", "props": { "y": 191, "x": 74, "width": 138, "var": "lab_time", "valign": "middle", "height": 30, "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 6 }], "animations": [{ "nodes": [{ "target": 5, "keyframes": { "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleY", "index": 30 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 1.1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 5 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 20 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "scaleX", "index": 30 }], "rotation": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 0 }, { "value": -3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 5 }, { "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 15 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "rotation", "index": 30 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/Tank.png", "Texture2D/xianshilingqu.png"], "loadList3D": [] };
          Ani.xianshilingqu_efUI = xianshilingqu_efUI;
          REG("ui.Ani.xianshilingqu_efUI", xianshilingqu_efUI);
          class XS2_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS2_aniUI.uiView);
              }
          }
          XS2_aniUI.uiView = { "type": "View", "props": {}, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "Image", "props": { "skin": "Texture2D/xs2.png", "name": "sj", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": -87.5, "x": -416, "skin": "Texture2D/xs2_f1.png", "name": "F1", "alpha": 1 }, "compId": 6 }, { "type": "Image", "props": { "y": -132, "x": 187, "skin": "Texture2D/xs2_f2.png", "name": "F2", "alpha": 1 }, "compId": 7 }, { "type": "Image", "props": { "y": -43, "x": 294, "skin": "Texture2D/xs2_f3.png", "name": "F3", "alpha": 0 }, "compId": 5 }, { "type": "Image", "props": { "y": 86, "x": 178, "skin": "Texture2D/xs_bd.png", "scaleY": 1.2, "scaleX": 1.2, "name": "bd", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 8 }, { "type": "Image", "props": { "y": -77, "x": 141, "skin": "Texture2D/sz2.png", "scaleY": 0.8, "scaleX": 0.8, "rotation": 5, "name": "sz1", "alpha": 0.25 }, "compId": 28 }, { "type": "Image", "props": { "y": -81, "x": -141, "skin": "Texture2D/sz2.png", "scaleY": 0.8, "scaleX": -0.8, "rotation": -5, "name": "sz11", "alpha": 0 }, "compId": 29 }, { "type": "Image", "props": { "y": 39, "x": 160, "skin": "Texture2D/sz1.png", "name": "sz2", "alpha": 0 }, "compId": 27 }] }, { "type": "Box", "props": { "y": -3, "x": -152, "scaleY": 0.5, "scaleX": 0.5, "name": "Arrow1" }, "compId": 9, "child": [{ "type": "Image", "props": { "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 10 }, { "type": "Image", "props": { "y": -25, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "2", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 11 }, { "type": "Image", "props": { "y": -50, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "3", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 12 }, { "type": "Image", "props": { "y": -75, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1.5, "scaleX": 1.5, "name": "4", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 13 }, { "type": "Image", "props": { "y": -75, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1.5, "scaleX": 1.5, "name": "11", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 14 }] }, { "type": "Box", "props": { "y": -11, "x": 153, "scaleY": 0.5, "scaleX": 0.5, "rotation": -90, "name": "Arrow2" }, "compId": 15, "child": [{ "type": "Image", "props": { "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 16 }, { "type": "Image", "props": { "y": -25, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "2", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 17 }, { "type": "Image", "props": { "y": -50, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "3", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 18 }, { "type": "Image", "props": { "y": -75, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1.5, "scaleX": 1.5, "name": "4", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 19 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1, "scaleX": 1, "name": "11", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 20 }] }, { "type": "Box", "props": { "y": -11, "x": 191, "scaleY": 0.5, "scaleX": 0.5, "rotation": 90, "name": "Arrow3" }, "compId": 21, "child": [{ "type": "Image", "props": { "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.058823529411764705 }, "compId": 22 }, { "type": "Image", "props": { "y": -25, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "2", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 23 }, { "type": "Image", "props": { "y": -50, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "3", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 24 }, { "type": "Image", "props": { "y": -75, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1.5, "scaleX": 1.5, "name": "4", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 25 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1, "scaleX": 1, "name": "11", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 26 }] }], "animations": [{ "nodes": [{ "target": 6, "keyframes": { "x": [{ "value": -475, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "x", "index": 0 }, { "value": -416, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "x", "index": 10 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 10 }] } }, { "target": 10, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "x", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "x", "index": 32 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 12 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 32 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 34 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 49 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "alpha", "index": 52 }] } }, { "target": 11, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "x", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "x", "index": 32 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 12 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 14 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 34 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 36 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 49 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "alpha", "index": 52 }] } }, { "target": 12, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "x", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "x", "index": 32 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 14 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 16 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 36 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 38 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 49 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "alpha", "index": 52 }] } }, { "target": 13, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "x", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "x", "index": 32 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 16 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 18 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 38 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 40 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 49 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "alpha", "index": 52 }] } }, { "target": 14, "keyframes": { "y": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 18 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 19 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 20 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 21 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 22 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 23 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 24 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 40 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 41 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 42 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 43 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 44 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 45 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "y", "index": 46 }], "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "key": "x", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "x", "index": 32 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 23 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 32 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 45 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleY", "index": 46 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 23 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 32 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 45 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "scaleX", "index": 46 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 17 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 18 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 24 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 28 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 32 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 39 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 40 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 46 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 47 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 14, "label": null, "key": "alpha", "index": 50 }] } }, { "target": 7, "keyframes": { "x": [{ "value": 300, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "x", "index": 0 }, { "value": 300, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "x", "index": 52 }, { "value": 187, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "x", "index": 62 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 52 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 62 }] } }, { "target": 16, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 64 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 86 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 16, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 17, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 64 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 86 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 17, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 18, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 68 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 18, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 19, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 68 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 70 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 92 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 19, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 20, "keyframes": { "y": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 70 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 71 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 72 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 73 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 74 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 75 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 76 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 92 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 93 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 94 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 95 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 96 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 97 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "y", "index": 98 }], "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "x", "index": 84 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 75 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 76 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 97 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleY", "index": 98 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 75 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 76 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 97 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "scaleX", "index": 98 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 69 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 70 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 76 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 77 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 80 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 91 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 92 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 98 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 99 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 20, "label": null, "key": "alpha", "index": 102 }] } }, { "target": 22, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 64 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 22, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 23, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 64 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 86 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 23, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 24, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 68 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 24, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 25, "keyframes": { "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "x", "index": 84 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 68 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 70 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 79 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 82 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 90 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 92 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 101 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 25, "label": null, "key": "alpha", "index": 104 }] } }, { "target": 26, "keyframes": { "y": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 70 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 71 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 72 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 73 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 74 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 75 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 76 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 92 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 93 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 94 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 95 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 96 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 97 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "y", "index": 98 }], "x": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "x", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "x", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "x", "index": 84 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 75 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 76 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 97 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleY", "index": 98 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 75 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 76 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 97 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "scaleX", "index": 98 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 62 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 69 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 70 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 76 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 77 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 80 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 84 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 91 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 92 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 98 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 99 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 26, "label": null, "key": "alpha", "index": 102 }] } }, { "target": 28, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 28, "key": "alpha", "index": 62 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 28, "key": "alpha", "index": 66 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 72 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 28, "key": "alpha", "index": 77 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 84 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 88 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 94 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 28, "label": null, "key": "alpha", "index": 99 }] } }, { "target": 29, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 14 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 32 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 36 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 42 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 29, "label": null, "key": "alpha", "index": 47 }] } }, { "target": 5, "keyframes": { "x": [{ "value": 294, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "x", "index": 0 }, { "value": 294, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "x", "index": 108 }, { "value": 188, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "x", "index": 118 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 108 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 118 }] } }, { "target": 8, "keyframes": { "scaleY": [{ "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 0 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 108 }, { "value": 0.3, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 128 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleY", "index": 129 }, { "value": 0.3, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleY", "index": 149 }], "scaleX": [{ "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 0 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 108 }, { "value": 0.3, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 128 }, { "value": 1.2, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 129 }, { "value": 0.3, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 149 }], "alpha": [{ "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 0 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 108 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 128 }, { "value": 0.5, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "alpha", "index": 129 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "alpha", "index": 149 }] } }, { "target": 27, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 108 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 112 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 118 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 123 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 129 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 133 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 139 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 27, "label": null, "key": "alpha", "index": 144 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 1 }], "loadList": ["Texture2D/xs2.png", "Texture2D/xs2_f1.png", "Texture2D/xs2_f2.png", "Texture2D/xs2_f3.png", "Texture2D/xs_bd.png", "Texture2D/sz2.png", "Texture2D/sz1.png", "Texture2D/xs_arrow.png"], "loadList3D": [] };
          Ani.XS2_aniUI = XS2_aniUI;
          REG("ui.Ani.XS2_aniUI", XS2_aniUI);
          class XS3_zsq_glowUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS3_zsq_glowUI.uiView);
              }
          }
          XS3_zsq_glowUI.uiView = { "type": "View", "props": { "width": 1334, "height": 750 }, "compId": 2, "child": [{ "type": "Box", "props": { "zOrder": 10 }, "compId": 3, "child": [{ "type": "Image", "props": { "skin": "Texture2D/glow_01.png", "name": "g1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/glow_01.png", "rotation": 90, "name": "g2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 4 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 4 }], "alpha": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 4 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 8 }] } }, { "target": 5, "keyframes": { "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 0 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleY", "index": 4 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 0 }, { "value": 2, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "scaleX", "index": 4 }], "alpha": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 4 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 10 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 1 }], "loadList": ["Texture2D/glow_01.png"], "loadList3D": [] };
          Ani.XS3_zsq_glowUI = XS3_zsq_glowUI;
          REG("ui.Ani.XS3_zsq_glowUI", XS3_zsq_glowUI);
          class XS3_zxq_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS3_zxq_aniUI.uiView);
              }
          }
          XS3_zxq_aniUI.uiView = { "type": "View", "props": {}, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/xs4_zxq.png", "scaleY": 1.5, "scaleX": 1.5, "name": "zxq2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "skin": "Texture2D/xs4_zxq.png", "rotation": 45, "name": "zxq1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "skin": "Texture2D/xs4_zxn.png", "name": "zxn", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Image", "props": { "skin": "Texture2D/xs4_zxd.png", "scaleY": 3, "scaleX": 3, "name": "zxd", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "rotation": [{ "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "rotation", "index": 0 }, { "value": 405, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "rotation", "index": 60 }] } }, { "target": 5, "keyframes": { "rotation": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 0 }, { "value": -360, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "rotation", "index": 60 }] } }, { "target": 7, "keyframes": { "scaleY": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleY", "index": 55 }], "scaleX": [{ "value": 3, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "scaleX", "index": 55 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/xs4_zxq.png", "Texture2D/xs4_zxn.png", "Texture2D/xs4_zxd.png"], "loadList3D": [] };
          Ani.XS3_zxq_aniUI = XS3_zxq_aniUI;
          REG("ui.Ani.XS3_zxq_aniUI", XS3_zxq_aniUI);
          class XS4_szq_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS4_szq_aniUI.uiView);
              }
          }
          XS4_szq_aniUI.uiView = { "type": "View", "props": {}, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "Image", "props": { "y": -67, "skin": "Texture2D/xs5_shq.png", "name": "szq", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": -20, "x": 0, "skin": "Texture2D/xs5_shq2.png", "name": "szq2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": -28, "x": -49, "skin": "Texture2D/left_1.png", "name": "sz", "anchorY": 0.35, "anchorX": 0.85, "alpha": 0.5 }, "compId": 6 }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "y": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "y", "index": 0 }, { "value": -67, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "y", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "y", "index": 31 }, { "value": -67, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "y", "index": 65 }] } }, { "target": 6, "keyframes": { "skin": [{ "value": "Texture2D/left_1.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "key": "skin", "index": 0 }, { "value": "Texture2D/left_2.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "key": "skin", "index": 6 }, { "value": "Texture2D/left_3.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "key": "skin", "index": 12 }, { "value": "Texture2D/left_4.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "key": "skin", "index": 18 }, { "value": "Texture2D/left_1.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "skin", "index": 30 }, { "value": "Texture2D/left_2.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "skin", "index": 36 }, { "value": "Texture2D/left_3.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "skin", "index": 42 }, { "value": "Texture2D/left_4.png", "tweenMethod": "linearNone", "tween": false, "target": 6, "label": null, "key": "skin", "index": 48 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/xs5_shq.png", "Texture2D/xs5_shq2.png", "Texture2D/left_1.png", "Texture2D/left_2.png", "Texture2D/left_3.png", "Texture2D/left_4.png"], "loadList3D": [] };
          Ani.XS4_szq_aniUI = XS4_szq_aniUI;
          REG("ui.Ani.XS4_szq_aniUI", XS4_szq_aniUI);
          class XS_arrow1_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS_arrow1_aniUI.uiView);
              }
          }
          XS_arrow1_aniUI.uiView = { "type": "View", "props": {}, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 4, "child": [{ "type": "Image", "props": { "skin": "Texture2D/xs_arrow.png", "name": "1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 3 }, { "type": "Image", "props": { "y": -25, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": -50, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "3", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Image", "props": { "y": -75, "x": 0, "skin": "Texture2D/xs_arrow.png", "scaleY": 1.5, "scaleX": 1.5, "name": "4", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/xs_arrow.png", "name": "11", "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 8 }] }], "animations": [{ "nodes": [{ "target": 3, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 3, "key": "alpha", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 3, "key": "alpha", "index": 3 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 3, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 3, "label": null, "key": "alpha", "index": 30 }] } }, { "target": 5, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "alpha", "index": 3 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "key": "alpha", "index": 6 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 5, "label": null, "key": "alpha", "index": 30 }] } }, { "target": 6, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 6 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "alpha", "index": 9 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 30 }] } }, { "target": 7, "keyframes": { "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "alpha", "index": 9 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "alpha", "index": 12 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "alpha", "index": 25 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "alpha", "index": 30 }] } }, { "target": 8, "keyframes": { "y": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "y", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "y", "index": 12 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "y", "index": 14 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "y", "index": 15 }, { "value": -25, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "y", "index": 17 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "y", "index": 18 }, { "value": -50, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "y", "index": 20 }, { "value": -75, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "y", "index": 21 }], "scaleY": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 20 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleY", "index": 21 }], "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 0 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 20 }, { "value": 1.5, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 21 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "alpha", "index": 10 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 12 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 21 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "alpha", "index": 23 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "alpha", "index": 29 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/xs_arrow.png"], "loadList3D": [] };
          Ani.XS_arrow1_aniUI = XS_arrow1_aniUI;
          REG("ui.Ani.XS_arrow1_aniUI", XS_arrow1_aniUI);
          class XS_arrow2_aniUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(XS_arrow2_aniUI.uiView);
              }
          }
          XS_arrow2_aniUI.uiView = { "type": "View", "props": { "runtime": "script/ui/XS_arrow2_ani.ts" }, "compId": 2, "child": [{ "type": "Box", "props": {}, "compId": 3, "child": [{ "type": "Image", "props": { "skin": "Texture2D/xs_hd.png", "scaleY": 0, "scaleX": 0, "name": "hd", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.2 }, "compId": 13 }, { "type": "Image", "props": { "skin": "Texture2D/xs_q.png", "scaleY": 0.7, "scaleX": 0.7, "rotation": 90, "name": "hq1", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 4 }, { "type": "Image", "props": { "y": 0, "x": 0, "skin": "Texture2D/xs_q.png", "scaleY": 0.4, "scaleX": 0.4, "rotation": -45, "name": "hq2", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.7 }, "compId": 6 }, { "type": "Box", "props": { "y": 100, "name": "Arrow" }, "compId": 12, "child": [{ "type": "Image", "props": { "y": 85, "x": 0, "skin": "Texture2D/Arrow1.png", "name": "Arrow1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 9 }, { "type": "Image", "props": { "y": 40, "x": 0, "skin": "Texture2D/Arrow2.png", "name": "Arrow2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }, { "type": "Image", "props": { "y": 100, "x": 0, "skin": "Texture2D/Arrow_sj.png", "scaleX": 1, "name": "ArrowS1", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 8 }, { "type": "Image", "props": { "y": 130, "x": 0, "skin": "Texture2D/Arrow_sj.png", "scaleY": 0.8, "scaleX": 0.38, "name": "ArrowS2", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 10 }, { "type": "Image", "props": { "y": 160, "x": 0, "skin": "Texture2D/Arrow_sj.png", "scaleY": 0.6, "scaleX": 0.225, "name": "ArrowS3", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 11 }] }] }], "animations": [{ "nodes": [{ "target": 4, "keyframes": { "scaleY": [{ "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 0 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleY", "index": 20 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 21 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 0 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "scaleX", "index": 20 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 21 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "scaleX", "index": 40 }], "rotation": [{ "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "rotation", "index": 0 }, { "value": 90, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "rotation", "index": 20 }, { "value": 45, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "rotation", "index": 21 }, { "value": 90, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "rotation", "index": 40 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 0 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "key": "alpha", "index": 20 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "alpha", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 4, "label": null, "key": "alpha", "index": 40 }] } }, { "target": 6, "keyframes": { "scaleY": [{ "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 0 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleY", "index": 10 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 11 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 20 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 30 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 31 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 0 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "scaleX", "index": 10 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 11 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 20 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 30 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 31 }, { "value": 0.4, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "scaleX", "index": 40 }], "rotation": [{ "value": -45, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "rotation", "index": 0 }, { "value": -90, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "rotation", "index": 10 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "key": "rotation", "index": 11 }, { "value": -45, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "rotation", "index": 20 }, { "value": -90, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "rotation", "index": 30 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "rotation", "index": 31 }, { "value": -45, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "rotation", "index": 40 }], "alpha": [{ "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 10 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 30 }, { "value": 0.7, "tweenMethod": "linearNone", "tween": true, "target": 6, "label": null, "key": "alpha", "index": 40 }] } }, { "target": 12, "keyframes": { "y": [{ "value": 100, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "y", "index": 0 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "y", "index": 7 }, { "value": 100, "tweenMethod": "linearNone", "tween": true, "target": 12, "key": "y", "index": 20 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "y", "index": 27 }, { "value": 100, "tweenMethod": "linearNone", "tween": true, "target": 12, "label": null, "key": "y", "index": 40 }] } }, { "target": 8, "keyframes": { "scaleX": [{ "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 0 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 4 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "key": "scaleX", "index": 8 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 10 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 15 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 20 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 24 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 28 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 30 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 35 }, { "value": 1, "tweenMethod": "linearNone", "tween": true, "target": 8, "label": null, "key": "scaleX", "index": 40 }] } }, { "target": 10, "keyframes": { "scaleX": [{ "value": 0.38, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 0 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 2 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 7 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 11 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 15 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 17 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 22 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 27 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 31 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 35 }, { "value": 0.8, "tweenMethod": "linearNone", "tween": true, "target": 10, "label": null, "key": "scaleX", "index": 37 }, { "value": 0.38, "tweenMethod": "linearNone", "tween": true, "target": 10, "key": "scaleX", "index": 40 }] } }, { "target": 11, "keyframes": { "scaleX": [{ "value": 0.225, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 0 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 3 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 5 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 10 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 15 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 19 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 23 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 25 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 30 }, { "value": 0.6, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 35 }, { "value": 0.1, "tweenMethod": "linearNone", "tween": true, "target": 11, "label": null, "key": "scaleX", "index": 39 }, { "value": 0.225, "tweenMethod": "linearNone", "tween": true, "target": 11, "key": "scaleX", "index": 40 }] } }, { "target": 7, "keyframes": { "y": [{ "value": 40, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "y", "index": 0 }, { "value": 25, "tweenMethod": "linearNone", "tween": true, "target": 7, "key": "y", "index": 7 }, { "value": 40, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "y", "index": 15 }, { "value": 40, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "y", "index": 20 }, { "value": 25, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "y", "index": 27 }, { "value": 40, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "y", "index": 35 }, { "value": 40, "tweenMethod": "linearNone", "tween": true, "target": 7, "label": null, "key": "y", "index": 40 }] } }, { "target": 13, "keyframes": { "scaleY": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleY", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleY", "index": 7 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleY", "index": 20 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleY", "index": 40 }], "scaleX": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleX", "index": 0 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleX", "index": 7 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "key": "scaleX", "index": 20 }, { "value": 1.6, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 27 }, { "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 13, "label": null, "key": "scaleX", "index": 40 }] } }], "name": "ani1", "id": 1, "frameRate": 30, "action": 2 }], "loadList": ["Texture2D/xs_hd.png", "Texture2D/xs_q.png", "Texture2D/Arrow1.png", "Texture2D/Arrow2.png", "Texture2D/Arrow_sj.png"], "loadList3D": [] };
          Ani.XS_arrow2_aniUI = XS_arrow2_aniUI;
          REG("ui.Ani.XS_arrow2_aniUI", XS_arrow2_aniUI);
      })(Ani = ui.Ani || (ui.Ani = {}));
  })(ui || (ui = {}));
  (function (ui) {
      var Item;
      (function (Item) {
          class GrenadeItemUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GrenadeItemUI.uiView);
              }
          }
          GrenadeItemUI.uiView = { "type": "UIBaseView", "props": { "width": 469, "runtime": "", "height": 160 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 469, "var": "bg", "skin": "xIndex/weapon_unselect.png", "sizeGrid": "2,32,32,2", "height": 160 }, "compId": 4 }, { "type": "Image", "props": { "y": 37, "x": 356, "width": 95, "skin": "xIndex/common_bg.png", "sizeGrid": "2,2,2,2", "height": 38 }, "compId": 7 }, { "type": "Image", "props": { "y": 0, "x": 0, "width": 625, "var": "select", "skin": "xIndex/weapon_select2.png", "scaleY": 0.75, "scaleX": 0.75, "height": 215, "sizeGrid": "3,44,44,3" }, "compId": 13 }, { "type": "Image", "props": { "y": 76, "x": 100, "var": "icon", "skin": "icon/101303.png", "scaleY": 1.5, "scaleX": 1.5, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": 100, "x": 404.5, "var": "btn_buy", "skin": "comp/btn_confirm1.png", "scaleY": 0.37, "scaleX": 0.37, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Label", "props": { "y": 25, "x": 199, "var": "lab_gunName", "text": "弹药包", "fontSize": 30, "color": "#ffffff", "bold": true }, "compId": 8 }, { "type": "Label", "props": { "y": 78, "x": 200, "wordWrap": true, "width": 113, "var": "lab_desc", "text": "使用可以补满当前武器备弹", "leading": 8, "height": 42, "fontSize": 16, "color": "#ffffff", "bold": true }, "compId": 9 }, { "type": "Label", "props": { "y": 49, "x": 360, "wordWrap": true, "width": 85, "var": "lab_num", "text": "库存: 360", "leading": 8, "height": 18, "fontSize": 16, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 10 }, { "type": "Label", "props": { "y": 93, "x": 363, "wordWrap": true, "width": 40, "text": "购买", "leading": 8, "height": 18, "fontSize": 16, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 11 }, { "type": "Label", "props": { "y": 93, "x": 400, "wordWrap": true, "width": 48, "var": "lab_price", "text": "600$", "leading": 8, "height": 18, "fontSize": 16, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 12 }], "loadList": ["xIndex/weapon_unselect.png", "xIndex/common_bg.png", "xIndex/weapon_select2.png", "icon/101303.png", "comp/btn_confirm1.png"], "loadList3D": [] };
          Item.GrenadeItemUI = GrenadeItemUI;
          REG("ui.Item.GrenadeItemUI", GrenadeItemUI);
          class HouseBagItemUI extends View {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(HouseBagItemUI.uiView);
              }
          }
          HouseBagItemUI.uiView = { "type": "View", "props": { "width": 287, "runtime": "script/ui/HouseBagItem.ts", "height": 500 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "var": "quality", "skin": "houseBag/quality_2.png" }, "compId": 3 }, { "type": "Image", "props": { "y": 420, "x": 145, "var": "btn_open", "skin": "comp/btn_confirm.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 152, "x": 145.5, "var": "img_icon", "scaleY": 0.8, "scaleX": 0.8, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Label", "props": { "y": 286, "x": 80, "width": 148, "var": "lab_num", "text": "剩余： 5个", "height": 26, "fontSize": 26, "color": "#ffffff", "bold": true }, "compId": 6 }, { "type": "Label", "props": { "y": 406, "x": 103, "width": 85, "text": "打 开", "height": 36, "fontSize": 37, "font": "Microsoft YaHei", "color": "#ffffff", "bold": true }, "compId": 7 }], "loadList": ["houseBag/quality_2.png", "comp/btn_confirm.png"], "loadList3D": [] };
          Item.HouseBagItemUI = HouseBagItemUI;
          REG("ui.Item.HouseBagItemUI", HouseBagItemUI);
      })(Item = ui.Item || (ui.Item = {}));
  })(ui || (ui = {}));
  (function (ui) {
      var view;
      (function (view) {
          class AirDropBoxViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(AirDropBoxViewUI.uiView);
              }
          }
          AirDropBoxViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": -1, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Image", "props": { "y": 37, "skin": "resource/arsenal/bg_weapon.png", "centerX": -330 }, "compId": 76 }, { "type": "Box", "props": { "width": 1334, "var": "centerBox", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 32, "child": [{ "type": "Image", "props": { "y": 190, "x": 665, "width": 612, "skin": "resource/arsenal/items_bg.png", "sizeGrid": "5,5,5,5", "height": 541 }, "compId": 13 }, { "type": "Image", "props": { "y": 117, "x": 756, "var": "btn_arms", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 14 }, { "type": "Image", "props": { "y": 117, "x": 973.5, "var": "btn_parts", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 15 }, { "type": "Image", "props": { "y": 117, "x": 1191, "var": "btn_armor", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 16 }, { "type": "Image", "props": { "y": 151, "x": 416, "visible": false, "var": "btn_lv", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17, "child": [{ "type": "Image", "props": { "var": "mark_1", "skin": "arsenal/ditu2.png" }, "compId": 37 }] }, { "type": "Image", "props": { "y": 151, "x": 645, "visible": false, "var": "btn_quality", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 44, "child": [{ "type": "Image", "props": { "visible": false, "var": "mark_2", "skin": "arsenal/ditu2.png" }, "compId": 45 }] }, { "type": "Image", "props": { "y": 151, "x": 874, "visible": false, "var": "btn_time", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Image", "props": { "visible": false, "var": "mark_3", "skin": "arsenal/ditu2.png" }, "compId": 39 }] }, { "type": "Image", "props": { "y": 151, "x": 874, "visible": false, "var": "btn_name", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 41, "child": [{ "type": "Image", "props": { "visible": false, "skin": "arsenal/ditu2.png" }, "compId": 42 }] }, { "type": "List", "props": { "y": 211, "x": 690, "width": 564, "var": "list", "spaceY": 28, "spaceX": 22, "repeatY": 4, "repeatX": 3, "height": 500, "elasticEnabled": true }, "compId": 21, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 173, "name": "render", "height": 120 }, "compId": 22, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 173, "skin": "arsenal/quality_1.png", "name": "quality", "height": 120 }, "compId": 23 }, { "type": "Image", "props": { "y": 72, "x": 89, "scaleY": 0.45, "scaleX": 0.45, "name": "img_icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 24 }, { "type": "Label", "props": { "y": 2, "x": 8, "width": 161, "text": "M4A1M4A1M4A1M4A1", "overflow": "hidden", "name": "lab_name", "height": 22, "fontSize": 22, "color": "#ffffff", "bold": true }, "compId": 47 }, { "type": "Label", "props": { "y": 97, "x": 2, "text": "普通", "name": "lab_quality", "fontSize": 20, "color": "#ffffff" }, "compId": 75 }, { "type": "Image", "props": { "visible": false, "skin": "arsenal/item_mark.png", "name": "img_mark" }, "compId": 74 }] }] }, { "type": "Box", "props": { "y": 97, "x": 30, "width": 631, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 637 }, "compId": 33 }, { "type": "Label", "props": { "y": 115, "x": 754, "valign": "middle", "text": "武器仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 25 }, { "type": "Label", "props": { "y": 115, "x": 972, "valign": "middle", "text": "配件仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 26 }, { "type": "Label", "props": { "y": 115, "x": 1188, "valign": "middle", "text": "防具仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 27 }, { "type": "Label", "props": { "y": 152, "x": 417, "visible": false, "valign": "middle", "text": "按等级", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 28 }, { "type": "Label", "props": { "y": 152, "x": 646, "visible": false, "valign": "middle", "text": "按品质", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 46 }, { "type": "Label", "props": { "y": 152, "x": 875, "visible": false, "valign": "middle", "text": "按名称", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 43 }, { "type": "Label", "props": { "y": 152, "x": 875, "visible": false, "valign": "middle", "text": "按时间", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 40 }, { "type": "Box", "props": { "y": 562, "x": 33, "width": 540, "var": "weaponInfoBox", "height": 170 }, "compId": 51, "child": [{ "type": "Image", "props": { "skin": "resource/arsenal/itemInfo_bg.png" }, "compId": 52 }, { "type": "Label", "props": { "y": 27, "x": 94, "wordWrap": true, "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 54 }, { "type": "Label", "props": { "y": 27, "x": 163, "wordWrap": true, "var": "lab_type", "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 68 }, { "type": "Label", "props": { "y": 27, "x": 337, "wordWrap": true, "valign": "top", "text": "品质:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 69 }, { "type": "Label", "props": { "y": 27, "x": 405, "wordWrap": true, "var": "lab_quality", "valign": "top", "text": "基础", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 59 }, { "type": "Label", "props": { "y": 57, "x": 94, "wordWrap": true, "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 70 }, { "type": "Label", "props": { "y": 57, "x": 163, "wordWrap": true, "var": "lab_caliber", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 71 }, { "type": "Label", "props": { "y": 57, "x": 337, "wordWrap": true, "valign": "top", "text": "弹容:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 72 }, { "type": "Label", "props": { "y": 57, "x": 405, "wordWrap": true, "var": "lab_num", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 73 }, { "type": "Label", "props": { "y": 143, "x": 44, "valign": "top", "text": "精度:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 55 }, { "type": "Label", "props": { "y": 101, "x": 288, "valign": "top", "text": "射速:", "height": 22, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 56 }, { "type": "Label", "props": { "y": 101.5, "x": 44, "valign": "top", "text": "伤害:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 57 }, { "type": "Label", "props": { "y": 143, "x": 288, "valign": "top", "text": "稳定:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 58 }, { "type": "Image", "props": { "y": 142, "x": 107, "width": 0, "var": "bar_precision", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 60 }, { "type": "Image", "props": { "y": 103, "x": 352, "width": 0, "var": "bar_shootSpeed", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 62 }, { "type": "Image", "props": { "y": 105.5, "x": 107.5, "width": 0, "var": "bar_power", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 64 }, { "type": "Image", "props": { "y": 142, "x": 352, "width": 0, "var": "bar_recoil", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 66 }, { "type": "Image", "props": { "y": 142, "x": 107, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 61 }, { "type": "Image", "props": { "y": 103.5, "x": 351, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 63 }, { "type": "Image", "props": { "y": 105, "x": 106, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 65 }, { "type": "Image", "props": { "y": 142, "x": 351, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 67 }] }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 78, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 79 }] }], "loadList": ["resource/comp/bg.png", "resource/arsenal/bg_weapon.png", "resource/arsenal/items_bg.png", "arsenal/name_bg.png", "arsenal/ditu1.png", "arsenal/ditu2.png", "arsenal/quality_1.png", "arsenal/item_mark.png", "resource/arsenal/itemInfo_bg.png", "arsenal/Market_shuxingzhitiao.png", "shop/Market_shuxingzhi.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.AirDropBoxViewUI = AirDropBoxViewUI;
          REG("ui.view.AirDropBoxViewUI", AirDropBoxViewUI);
          class ArsenalViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ArsenalViewUI.uiView);
              }
          }
          ArsenalViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": -1, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Image", "props": { "y": 37, "skin": "resource/arsenal/bg_weapon.png", "centerX": -330 }, "compId": 76 }, { "type": "Box", "props": { "width": 1334, "var": "centerBox", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 32, "child": [{ "type": "Image", "props": { "y": 190, "x": 665, "width": 612, "skin": "resource/arsenal/items_bg.png", "sizeGrid": "5,5,5,5", "height": 541 }, "compId": 13 }, { "type": "Image", "props": { "y": 117, "x": 756, "var": "btn_arms", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 14 }, { "type": "Image", "props": { "y": 117, "x": 973.5, "var": "btn_parts", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 15 }, { "type": "Image", "props": { "y": 117, "x": 1191, "var": "btn_armor", "skin": "arsenal/name_bg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 16 }, { "type": "Image", "props": { "y": 151, "x": 416, "visible": false, "var": "btn_lv", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17, "child": [{ "type": "Image", "props": { "var": "mark_1", "skin": "arsenal/ditu2.png" }, "compId": 37 }] }, { "type": "Image", "props": { "y": 151, "x": 645, "visible": false, "var": "btn_quality", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 44, "child": [{ "type": "Image", "props": { "visible": false, "var": "mark_2", "skin": "arsenal/ditu2.png" }, "compId": 45 }] }, { "type": "Image", "props": { "y": 151, "x": 874, "visible": false, "var": "btn_time", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Image", "props": { "visible": false, "var": "mark_3", "skin": "arsenal/ditu2.png" }, "compId": 39 }] }, { "type": "Image", "props": { "y": 151, "x": 874, "visible": false, "var": "btn_name", "skin": "arsenal/ditu1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 41, "child": [{ "type": "Image", "props": { "visible": false, "skin": "arsenal/ditu2.png" }, "compId": 42 }] }, { "type": "List", "props": { "y": 211, "x": 690, "width": 564, "var": "list", "spaceY": 28, "spaceX": 22, "repeatY": 4, "repeatX": 3, "height": 500, "elasticEnabled": true }, "compId": 21, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 173, "name": "render", "height": 120 }, "compId": 22, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 173, "skin": "arsenal/quality_1.png", "name": "quality", "height": 120 }, "compId": 23 }, { "type": "Image", "props": { "y": 72, "x": 89, "scaleY": 0.45, "scaleX": 0.45, "name": "img_icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 24 }, { "type": "Label", "props": { "y": 2, "x": 8, "width": 161, "text": "M4A1M4A1M4A1M4A1", "overflow": "hidden", "name": "lab_name", "height": 22, "fontSize": 22, "color": "#ffffff", "bold": true }, "compId": 47 }, { "type": "Label", "props": { "y": 97, "x": 2, "text": "普通", "name": "lab_quality", "fontSize": 20, "color": "#ffffff" }, "compId": 75 }, { "type": "Image", "props": { "visible": false, "skin": "arsenal/item_mark.png", "name": "img_mark" }, "compId": 74 }] }] }, { "type": "Box", "props": { "y": 97, "x": 30, "width": 631, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 637 }, "compId": 33 }, { "type": "Label", "props": { "y": 115, "x": 754, "valign": "middle", "text": "武器仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 25 }, { "type": "Label", "props": { "y": 115, "x": 972, "valign": "middle", "text": "配件仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 26 }, { "type": "Label", "props": { "y": 115, "x": 1188, "valign": "middle", "text": "防具仓库", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 27 }, { "type": "Label", "props": { "y": 152, "x": 417, "visible": false, "valign": "middle", "text": "按等级", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 28 }, { "type": "Label", "props": { "y": 152, "x": 646, "visible": false, "valign": "middle", "text": "按品质", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 46 }, { "type": "Label", "props": { "y": 152, "x": 875, "visible": false, "valign": "middle", "text": "按名称", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 43 }, { "type": "Label", "props": { "y": 152, "x": 875, "visible": false, "valign": "middle", "text": "按时间", "fontSize": 28, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 40 }, { "type": "Box", "props": { "y": 562, "x": 33, "width": 540, "var": "weaponInfoBox", "height": 170 }, "compId": 51, "child": [{ "type": "Image", "props": { "skin": "resource/arsenal/itemInfo_bg.png" }, "compId": 52 }, { "type": "Label", "props": { "y": 27, "x": 94, "wordWrap": true, "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 54 }, { "type": "Label", "props": { "y": 27, "x": 163, "wordWrap": true, "var": "lab_type", "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 68 }, { "type": "Label", "props": { "y": 27, "x": 337, "wordWrap": true, "valign": "top", "text": "品质:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 69 }, { "type": "Label", "props": { "y": 27, "x": 405, "wordWrap": true, "var": "lab_quality", "valign": "top", "text": "基础", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 59 }, { "type": "Label", "props": { "y": 57, "x": 94, "wordWrap": true, "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 70 }, { "type": "Label", "props": { "y": 57, "x": 163, "wordWrap": true, "var": "lab_caliber", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 71 }, { "type": "Label", "props": { "y": 57, "x": 337, "wordWrap": true, "valign": "top", "text": "弹容:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 72 }, { "type": "Label", "props": { "y": 57, "x": 405, "wordWrap": true, "var": "lab_num", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 73 }, { "type": "Label", "props": { "y": 143, "x": 44, "valign": "top", "text": "精度:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 55 }, { "type": "Label", "props": { "y": 101, "x": 288, "valign": "top", "text": "射速:", "height": 22, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 56 }, { "type": "Label", "props": { "y": 101.5, "x": 44, "valign": "top", "text": "伤害:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 57 }, { "type": "Label", "props": { "y": 143, "x": 288, "valign": "top", "text": "稳定:", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 58 }, { "type": "Image", "props": { "y": 142, "x": 107, "width": 0, "var": "bar_precision", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 60 }, { "type": "Image", "props": { "y": 103, "x": 352, "width": 0, "var": "bar_shootSpeed", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 62 }, { "type": "Image", "props": { "y": 105.5, "x": 107.5, "width": 0, "var": "bar_power", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 64 }, { "type": "Image", "props": { "y": 142, "x": 352, "width": 0, "var": "bar_recoil", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "anchorY": 0.5 }, "compId": 66 }, { "type": "Image", "props": { "y": 142, "x": 107, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 61 }, { "type": "Image", "props": { "y": 103.5, "x": 351, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 63 }, { "type": "Image", "props": { "y": 105, "x": 106, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 65 }, { "type": "Image", "props": { "y": 142, "x": 351, "width": 150, "skin": "shop/Market_shuxingzhi.png", "anchorY": 0.5 }, "compId": 67 }] }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 78, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 79 }] }], "loadList": ["resource/comp/bg.png", "resource/arsenal/bg_weapon.png", "resource/arsenal/items_bg.png", "arsenal/name_bg.png", "arsenal/ditu1.png", "arsenal/ditu2.png", "arsenal/quality_1.png", "arsenal/item_mark.png", "resource/arsenal/itemInfo_bg.png", "arsenal/Market_shuxingzhitiao.png", "shop/Market_shuxingzhi.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ArsenalViewUI = ArsenalViewUI;
          REG("ui.view.ArsenalViewUI", ArsenalViewUI);
          class AwardViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(AwardViewUI.uiView);
              }
          }
          AwardViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "houseBag/mask.png", "sizeGrid": "5,5,5,5", "right": 0, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 3, "child": [{ "type": "Image", "props": { "y": 23, "x": 0, "skin": "resource/houseBag/frame.png" }, "compId": 5 }, { "type": "Image", "props": { "y": 260, "x": 549, "skin": "houseBag/bg_award.png" }, "compId": 6 }, { "type": "Image", "props": { "y": 642, "x": 669, "var": "btn_confirm", "skin": "comp/btn_confirm.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }, { "type": "Image", "props": { "y": 369, "x": 669, "width": 130, "var": "awardIcon", "height": 130, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 8 }, { "type": "Label", "props": { "y": 628, "x": 627, "width": 89, "text": "确 定", "height": 36, "fontSize": 37, "font": "Microsoft YaHei", "color": "#ffffff", "bold": true }, "compId": 9 }, { "type": "Label", "props": { "y": 524, "x": 666, "var": "awardName", "text": "98K", "fontSize": 35, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 10 }, { "type": "Label", "props": { "y": 443, "x": 750, "var": "awardNum", "text": "awardNum", "fontSize": 24, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 1 }, "compId": 11 }] }], "loadList": ["houseBag/mask.png", "resource/houseBag/frame.png", "houseBag/bg_award.png", "comp/btn_confirm.png"], "loadList3D": [] };
          view.AwardViewUI = AwardViewUI;
          REG("ui.view.AwardViewUI", AwardViewUI);
          class ChangeGrenadeViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ChangeGrenadeViewUI.uiView);
              }
          }
          ChangeGrenadeViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 3 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 4, "child": [{ "type": "Button", "props": { "y": 256, "x": 251, "var": "btn_grenade1", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 25, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add1", "skin": "xIndex/jiahao.png" }, "compId": 63 }, { "type": "Box", "props": { "width": 103, "var": "box1", "height": 121 }, "compId": 64, "child": [{ "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade1", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 29 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName1", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeName1", "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 32 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum1", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeNum1", "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 33 }, { "type": "Image", "props": { "y": 22, "x": 80, "width": 20, "var": "img_clear1", "skin": "xIndex/jiahao.png", "rotation": 45, "height": 20 }, "compId": 75 }] }] }, { "type": "Button", "props": { "y": 256, "x": 497.5, "var": "btn_grenade2", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 26, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add2", "skin": "xIndex/jiahao.png" }, "compId": 54 }, { "type": "Box", "props": { "width": 103, "var": "box2", "height": 121 }, "compId": 60, "child": [{ "type": "Image", "props": { "y": 22, "x": 80, "width": 20, "var": "img_clear2", "skin": "xIndex/jiahao.png", "rotation": 45, "height": 20 }, "compId": 55 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade2", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 34 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName2", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 37 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum2", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 38 }] }] }, { "type": "Button", "props": { "y": 520, "x": 251, "var": "btn_grenade3", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 27, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add3", "skin": "xIndex/jiahao.png" }, "compId": 56 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box3", "height": 121 }, "compId": 65, "child": [{ "type": "Image", "props": { "y": 22, "x": 80, "width": 20, "var": "img_clear3", "skin": "xIndex/jiahao.png", "rotation": 45, "height": 20 }, "compId": 66 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade3", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 67 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName3", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 68 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum3", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 69 }] }] }, { "type": "Button", "props": { "y": 521, "x": 497.5, "var": "btn_grenade4", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 28, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add4", "skin": "xIndex/jiahao.png" }, "compId": 58 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box4", "height": 121 }, "compId": 70, "child": [{ "type": "Image", "props": { "y": 22, "x": 80, "width": 20, "var": "img_clear4", "skin": "xIndex/jiahao.png", "rotation": 45, "height": 20 }, "compId": 71 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade4", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 72 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName4", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 73 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum4", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 74 }] }] }, { "type": "Image", "props": { "y": 73, "x": 698, "width": 495, "skin": "xIndex/weapon_bg.png", "sizeGrid": "1,1,1,1", "height": 607 }, "compId": 19, "child": [{ "type": "List", "props": { "y": 11, "x": 13, "width": 471, "var": "list", "spaceY": 15, "height": 583 }, "compId": 20, "child": [{ "type": "GrenadeItem", "props": { "runtime": "ui.Item.GrenadeItemUI" }, "compId": 76 }] }] }, { "type": "Image", "props": { "y": 256, "x": 251, "width": 208, "var": "select", "skin": "xIndex/weapon_select2.png", "sizeGrid": "3,44,44,3", "height": 244, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 49 }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 6 }] }], "loadList": ["resource/comp/bg.png", "xIndex/img_game_fuwuqi.png", "xIndex/jiahao.png", "xIndex/weapon_bg.png", "xIndex/weapon_select2.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ChangeGrenadeViewUI = ChangeGrenadeViewUI;
          REG("ui.view.ChangeGrenadeViewUI", ChangeGrenadeViewUI);
          class ChangeProViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ChangeProViewUI.uiView);
              }
          }
          ChangeProViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 3 }, { "type": "Box", "props": { "width": 1334, "mouseThrough": true, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 37, "child": [{ "type": "Box", "props": { "y": 25, "x": 84, "width": 326, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 700 }, "compId": 36 }, { "type": "Image", "props": { "y": 51, "x": 456, "width": 210, "skin": "xIndex/kexuanzhiyedikuang.png", "height": 57, "sizeGrid": "22,23,3,2" }, "compId": 38 }, { "type": "Image", "props": { "y": 107, "x": 456, "width": 737, "skin": "xIndex/common_bg.png", "height": 496, "alpha": 0.5, "sizeGrid": "5,5,5,5" }, "compId": 4 }, { "type": "Image", "props": { "y": 617, "x": 113, "width": 274, "skin": "xIndex/common_bg.png", "height": 99, "alpha": 0.4, "sizeGrid": "5,5,5,5" }, "compId": 6 }, { "type": "Image", "props": { "y": 676, "x": 1065, "var": "btn_confirm", "skin": "wxlocal/comm_btn.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 9, "child": [{ "type": "Label", "props": { "y": 51, "x": 138, "valign": "middle", "text": "确认", "fontSize": 40, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 10 }] }, { "type": "List", "props": { "y": 122, "x": 473, "width": 707, "var": "list", "spaceY": 10, "height": 481, "elasticEnabled": true }, "compId": 15, "child": [{ "type": "Box", "props": { "width": 707, "name": "render", "height": 153 }, "compId": 16, "child": [{ "type": "Image", "props": { "y": 4, "x": 4, "width": 699, "skin": "xIndex/common_bg.png", "height": 144, "sizeGrid": "5,5,5,5" }, "compId": 17 }, { "type": "Image", "props": { "y": -3, "x": -3, "width": 713, "skin": "xIndex/weapon_select.png", "name": "img_select", "height": 158, "sizeGrid": "15,15,15,15" }, "compId": 26 }, { "type": "Image", "props": { "y": 17, "x": 25, "width": 92, "skin": "xIndex/common_bg.png", "height": 92, "sizeGrid": "5,5,5,5" }, "compId": 19 }, { "type": "Image", "props": { "y": 63, "x": 71, "width": 88, "skin": "professionIcon/Role_Engineer.png", "name": "img_head", "height": 88, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 18 }, { "type": "Label", "props": { "y": 127, "x": 71, "valign": "middle", "text": "突击手", "name": "lab_name", "fontSize": 18, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 20 }, { "type": "Label", "props": { "y": 76, "x": 274, "wordWrap": true, "width": 287, "valign": "top", "text": "突击手", "overflow": "hidden", "name": "lab_desc", "height": 63, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 21 }, { "type": "Label", "props": { "y": 96, "x": 561, "valign": "middle", "text": "累计试用3次解锁（0/3）", "name": "lab_pro", "fontSize": 18, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 35 }, { "type": "Image", "props": { "y": 96, "x": 561, "skin": "common/btn_common_green.png", "name": "btn_Unlock", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22, "child": [{ "type": "Label", "props": { "y": 51, "x": 157, "valign": "middle", "text": "视频解锁", "name": "lab_UnlockDesc", "fontSize": 30, "font": "SimHei", "color": "#ffffff", "centerY": 2, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 23 }, { "type": "Image", "props": { "y": 51, "x": 63, "skin": "comp/icon_ad.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 24 }] }] }] }, { "type": "Label", "props": { "y": 80, "x": 560, "width": 137, "valign": "middle", "text": "可选职业", "height": 30, "fontSize": 30, "font": "SimHei", "color": "#ffffff", "centerY": -295, "centerX": -125, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 12 }, { "type": "Label", "props": { "y": 668, "x": 250, "var": "lab_profession", "valign": "middle", "text": "当前职业:突击手", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 7 }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 13, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 14 }] }], "loadList": ["resource/comp/bg.png", "xIndex/kexuanzhiyedikuang.png", "xIndex/common_bg.png", "wxlocal/comm_btn.png", "xIndex/weapon_select.png", "professionIcon/Role_Engineer.png", "common/btn_common_green.png", "comp/icon_ad.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ChangeProViewUI = ChangeProViewUI;
          REG("ui.view.ChangeProViewUI", ChangeProViewUI);
          class ChangeWeaponViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ChangeWeaponViewUI.uiView);
              }
          }
          ChangeWeaponViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 3 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "mouseThrough": true, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 4, "child": [{ "type": "Image", "props": { "y": 370, "x": 1013, "width": 399, "var": "listBg", "skin": "xIndex/weapon_bg.png", "sizeGrid": "1,1,1,1", "height": 589, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 19, "child": [{ "type": "List", "props": { "y": 21, "x": 21, "width": 356, "var": "list", "spaceY": 7, "height": 544, "elasticEnabled": true }, "compId": 20, "child": [{ "type": "Box", "props": { "width": 356, "name": "render", "height": 151 }, "compId": 43, "child": [{ "type": "Image", "props": { "y": 6, "x": 5, "width": 345, "skin": "xIndex/weapon_bg1.png", "sizeGrid": "1,1,1,1", "height": 139 }, "compId": 44 }, { "type": "Image", "props": { "y": 0, "x": 0, "width": 356, "skin": "xIndex/weapon_select.png", "name": "img_select", "height": 151, "sizeGrid": "15,15,15,15" }, "compId": 48 }, { "type": "Button", "props": { "y": 25, "x": 307, "width": 70, "visible": false, "stateNum": 1, "skin": "xIndex/common_bg.png", "sizeGrid": "2,2,2,2", "name": "btn_strong", "labelSize": 22, "labelColors": "#FFFFFF", "label": "改造", "height": 30, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 45 }, { "type": "Image", "props": { "y": 86, "x": 178, "skin": "icon/100203.png", "scaleY": 1.5, "scaleX": 1.5, "name": "icon_gun", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 46 }, { "type": "Label", "props": { "y": 134, "x": 13, "width": 112, "valign": "middle", "text": "AUG", "overflow": "hidden", "name": "lab_name", "height": 18, "fontSize": 18, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 47 }, { "type": "Image", "props": { "width": 356, "skin": "common/blank.png", "name": "img_hide", "height": 151, "sizeGrid": "1,1,1,1" }, "compId": 83 }, { "type": "Image", "props": { "y": 61, "x": 287, "skin": "home/suo.png", "name": "img_unlock" }, "compId": 84 }] }] }] }, { "type": "Box", "props": { "y": 102, "x": 407, "width": 360, "var": "btn_gun0", "height": 252 }, "compId": 74, "child": [{ "type": "Image", "props": { "y": -1, "x": 0, "width": 360, "var": "img_gun_select0", "skin": "xIndex/weapon_select2.png", "height": 252, "sizeGrid": "3,44,44,3" }, "compId": 75 }, { "type": "Button", "props": { "y": 52, "x": 2, "stateNum": 1, "skin": "xIndex/img_game_zuWUQi.png" }, "compId": 76 }, { "type": "Image", "props": { "y": 26, "x": 180, "var": "img_flag0", "skin": "xIndex/img_game_white.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 77 }, { "type": "Image", "props": { "y": 147, "x": 183, "var": "img_gunIcon0", "skewY": 0, "skewX": 0, "scaleY": 2.3, "scaleX": 2.3, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 78 }, { "type": "Label", "props": { "y": 31, "x": 19, "width": 201, "var": "lab_gunName0", "valign": "middle", "overflow": "hidden", "height": 33, "fontSize": 33, "color": "#000000", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 79 }, { "type": "Label", "props": { "y": 31, "x": 353, "var": "lab_bulletNum0", "valign": "middle", "fontSize": 23, "color": "#000000", "anchorY": 0.5, "anchorX": 1, "align": "left" }, "compId": 80 }, { "type": "Image", "props": { "y": 65, "x": 5, "skin": "xIndex/img_game_zhu.png", "scaleY": 1.5, "scaleX": 1.5 }, "compId": 81 }] }, { "type": "Box", "props": { "y": 367, "x": 407, "width": 360, "var": "btn_gun1", "height": 252 }, "compId": 65, "child": [{ "type": "Image", "props": { "y": -1, "x": 0, "width": 360, "var": "img_gun_select1", "skin": "xIndex/weapon_select2.png", "height": 252, "sizeGrid": "3,44,44,3" }, "compId": 66 }, { "type": "Button", "props": { "y": 52, "x": 2, "stateNum": 1, "skin": "xIndex/img_game_zuWUQi.png" }, "compId": 68 }, { "type": "Image", "props": { "y": 1, "x": 2, "var": "img_flag1", "skin": "xIndex/img_game_white.png" }, "compId": 69 }, { "type": "Image", "props": { "y": 147, "x": 183, "var": "img_gunIcon1", "skin": "icon/100102.png", "skewY": 0, "skewX": 0, "scaleY": 2.3, "scaleX": 2.3, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 70 }, { "type": "Label", "props": { "y": 31, "x": 10, "width": 203, "var": "lab_gunName1", "valign": "middle", "text": "HK-416", "overflow": "hidden", "height": 33, "fontSize": 33, "color": "#000000", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 71 }, { "type": "Label", "props": { "y": 31, "x": 353, "var": "lab_bulletNum1", "valign": "middle", "text": "30/1200", "fontSize": 23, "color": "#000000", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 72 }, { "type": "Image", "props": { "y": 65, "x": 5, "skin": "xIndex/img_game_fu.png", "scaleY": 1.5, "scaleX": 1.5 }, "compId": 73 }] }, { "type": "Box", "props": { "y": 25, "x": 68, "width": 326, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 700, "centerY": 0 }, "compId": 82 }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 6 }] }], "loadList": ["resource/comp/bg.png", "xIndex/weapon_bg.png", "xIndex/weapon_bg1.png", "xIndex/weapon_select.png", "xIndex/common_bg.png", "icon/100203.png", "common/blank.png", "home/suo.png", "xIndex/weapon_select2.png", "xIndex/img_game_zuWUQi.png", "xIndex/img_game_white.png", "xIndex/img_game_zhu.png", "icon/100102.png", "xIndex/img_game_fu.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ChangeWeaponViewUI = ChangeWeaponViewUI;
          REG("ui.view.ChangeWeaponViewUI", ChangeWeaponViewUI);
          class ConsoleViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ConsoleViewUI.uiView);
              }
          }
          ConsoleViewUI.uiView = { "type": "UIBaseView", "props": { "x": 0, "width": 1400, "runtime": "", "height": 350 }, "compId": 2, "child": [{ "type": "List", "props": { "y": 0, "x": 0, "width": 1400, "var": "list", "spaceY": 10, "height": 350 }, "compId": 3, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 1400, "name": "render", "height": 30 }, "compId": 4, "child": [{ "type": "Label", "props": { "wordWrap": false, "width": 1400, "valign": "middle", "overflow": "hidden", "name": "tex", "height": 30, "fontSize": 25, "color": "#ffffff", "align": "left" }, "compId": 5 }] }] }], "loadList": [], "loadList3D": [] };
          view.ConsoleViewUI = ConsoleViewUI;
          REG("ui.view.ConsoleViewUI", ConsoleViewUI);
          class ConstellationWeaponViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ConstellationWeaponViewUI.uiView);
              }
          }
          ConstellationWeaponViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 190, "child": [{ "type": "Image", "props": { "y": 375, "x": 633.5, "skin": "resource/home/dikuang.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 45 }, { "type": "Image", "props": { "y": 100, "x": 59.5, "var": "btn_refuse", "skin": "home/guanbi.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 186 }, { "type": "Box", "props": { "y": 204, "x": 368, "width": 248, "var": "box1", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 103, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 102 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 46 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 53 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 54 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 119 }] }, { "type": "Box", "props": { "y": 204, "x": 616, "width": 248, "var": "box2", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 258, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 259 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 260 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 261 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 262 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 263 }] }, { "type": "Box", "props": { "y": 204, "x": 864, "width": 248, "var": "box3", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 264, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 265 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 266 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 267 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 268 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 269 }] }, { "type": "Box", "props": { "y": 204, "x": 1112, "width": 248, "var": "box4", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 270, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 271 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 272 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 273 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 274 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 275 }] }, { "type": "Box", "props": { "y": 411, "x": 368, "width": 248, "var": "box5", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 276, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 277 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 278 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 279 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 280 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 281 }] }, { "type": "Box", "props": { "y": 411, "x": 616, "width": 248, "var": "box6", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 282, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 283 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 284 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 285 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 286 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 287 }] }, { "type": "Box", "props": { "y": 411, "x": 864, "width": 248, "var": "box7", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 288, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 289 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 290 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 291 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 292 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 293 }] }, { "type": "Box", "props": { "y": 411, "x": 1112, "width": 248, "var": "box8", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 294, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 295 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 296 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 297 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 298 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 299 }] }, { "type": "Box", "props": { "y": 618, "x": 368, "width": 248, "var": "box9", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 336, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 337 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 338 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 339 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 340 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 341 }] }, { "type": "Box", "props": { "y": 618, "x": 616, "width": 248, "var": "box10", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 318, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 319 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 320 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 321 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 322 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 323 }] }, { "type": "Box", "props": { "y": 618, "x": 864, "width": 248, "var": "box11", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 324, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 325 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 326 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 327 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 328 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 329 }] }, { "type": "Box", "props": { "y": 618, "x": 1112, "width": 248, "var": "box12", "height": 207, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 330, "child": [{ "type": "Image", "props": { "y": 75, "x": 20, "skin": "home/dizuo.png" }, "compId": 331 }, { "type": "Button", "props": { "y": 162, "x": 130, "stateNum": 1, "skin": "home/anniu.png", "name": "img_bg", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 332 }, { "type": "Label", "props": { "y": 163, "x": 147, "text": "获得", "name": "lab_name", "fontSize": 25, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 333 }, { "type": "Image", "props": { "y": 161, "x": 91, "skin": "comp/icon_ad.png", "scaleY": 0.8, "scaleX": 0.8, "name": "img_video", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 334 }, { "type": "Image", "props": { "y": 69, "x": 133, "width": 128, "name": "img_icon", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 335 }] }] }], "loadList": ["resource/home/dikuang.png", "home/guanbi.png", "home/dizuo.png", "home/anniu.png", "comp/icon_ad.png"], "loadList3D": [] };
          view.ConstellationWeaponViewUI = ConstellationWeaponViewUI;
          REG("ui.view.ConstellationWeaponViewUI", ConstellationWeaponViewUI);
          class CumulativePassViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(CumulativePassViewUI.uiView);
              }
          }
          CumulativePassViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 375, "x": 667, "width": 1090, "height": 640, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 36, "child": [{ "type": "Sprite", "props": { "y": 68, "x": 231, "texture": "resource/game/dikuang.png" }, "compId": 45 }, { "type": "Button", "props": { "y": 451, "x": 674, "width": 213, "var": "btn_getMore", "stateNum": 1, "skin": "common/btn_common_green.png", "height": 78, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 48, "child": [{ "type": "Label", "props": { "y": 40, "x": 107, "valign": "middle", "text": "更多武器", "fontSize": 35, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 49 }] }, { "type": "Button", "props": { "y": 451, "x": 414.5, "width": 213, "var": "btn_get", "stateNum": 1, "skin": "comp/btn_confirm1.png", "height": 78, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Sprite", "props": { "y": 22, "x": 42, "texture": "comp/icon_ad.png" }, "compId": 47 }, { "type": "Label", "props": { "y": 21, "x": 93, "valign": "middle", "text": "收下", "fontSize": 40, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 39 }] }, { "type": "Button", "props": { "y": 74, "x": 807, "var": "btn_close", "stateNum": 1, "skin": "home/guanbi.png" }, "compId": 46 }, { "type": "Image", "props": { "y": 232, "x": 545, "var": "img_icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 50 }] }], "loadList": ["resource/game/dikuang.png", "common/btn_common_green.png", "comp/btn_confirm1.png", "comp/icon_ad.png", "home/guanbi.png"], "loadList3D": [] };
          view.CumulativePassViewUI = CumulativePassViewUI;
          REG("ui.view.CumulativePassViewUI", CumulativePassViewUI);
          class CustomerViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(CustomerViewUI.uiView);
              }
          }
          CustomerViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 225, "x": 317, "width": 700, "height": 300, "centerY": 0, "centerX": 0 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 700, "skin": "common/img_common_backBg.png", "height": 300, "sizeGrid": "25,25,25,25" }, "compId": 32 }, { "type": "Label", "props": { "y": 99, "x": 350, "wordWrap": true, "width": 700, "var": "lab_desc", "valign": "middle", "text": "客服QQ:578686057", "overflow": "hidden", "height": 53, "fontSize": 40, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 35 }, { "type": "Label", "props": { "y": 197, "x": 350, "width": 95, "var": "btn_accept", "valign": "middle", "text": "确定", "height": 40, "fontSize": 40, "color": "#ffe214", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 39 }] }], "loadList": ["common/img_common_backBg.png"], "loadList3D": [] };
          view.CustomerViewUI = CustomerViewUI;
          REG("ui.view.CustomerViewUI", CustomerViewUI);
          class DailyKillViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(DailyKillViewUI.uiView);
              }
          }
          DailyKillViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "houseBag/mask.png", "sizeGrid": "5,5,5,5", "right": 0, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Box", "props": { "width": 880, "var": "box", "right": 81, "height": 607, "bottom": 69 }, "compId": 3, "child": [{ "type": "Image", "props": { "width": 880, "skin": "xIndex/img_game_dikuang.png", "height": 607, "sizeGrid": "10,10,10,10" }, "compId": 13 }, { "type": "Label", "props": { "y": 170, "x": 136, "wordWrap": true, "width": 608, "var": "lab_desc", "text": "您已累计击杀大量英雄，军部特此发来嘉奖，点击领取继续奋勇杀敌吧，后续还有更多缤纷奖励等待着您", "height": 88, "fontSize": 28, "color": "#ffffff" }, "compId": 14 }, { "type": "Label", "props": { "y": 74, "x": 227, "text": "本场累计击杀任务", "fontSize": 52, "color": "#ffea00", "bold": true }, "compId": 16 }, { "type": "Image", "props": { "y": 536, "var": "btn_get", "skin": "comp/lingquanniu.png", "left": 178, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17, "child": [{ "type": "Label", "props": { "y": 34, "x": 76, "text": "领取", "fontSize": 33, "color": "#ffffff", "bold": true }, "compId": 18 }] }, { "type": "Image", "props": { "y": 321, "x": 128, "var": "img_reward", "skin": "openBox/xuangkuang.png", "scaleY": 1.35, "scaleX": 1.35 }, "compId": 19, "child": [{ "type": "Image", "props": { "y": 44, "x": 45, "skin": "icon/101303.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22 }] }, { "type": "Image", "props": { "y": 321, "var": "img_reward1", "skin": "openBox/xuangkuang.png", "scaleY": 1.35, "scaleX": 1.35, "left": 326 }, "compId": 24, "child": [{ "type": "Image", "props": { "y": 44, "x": 46, "skin": "icon/101302.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 23 }] }] }], "loadList": ["houseBag/mask.png", "xIndex/img_game_dikuang.png", "comp/lingquanniu.png", "openBox/xuangkuang.png", "icon/101303.png", "icon/101302.png"], "loadList3D": [] };
          view.DailyKillViewUI = DailyKillViewUI;
          REG("ui.view.DailyKillViewUI", DailyKillViewUI);
          class DebugViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(DebugViewUI.uiView);
              }
          }
          DebugViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": true, "left": 0, "height": 750, "drawCallOptimize": false, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank.png", "right": 0, "left": 0, "bottom": 0, "alpha": 0.5, "sizeGrid": "1,1,1,1" }, "compId": 86 }, { "type": "Box", "props": { "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 17, "child": [{ "type": "List", "props": { "y": 0, "x": 0, "width": 707, "visible": false, "var": "list" }, "compId": 63, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "renderType": "render" }, "compId": 62, "child": [{ "type": "Label", "props": { "x": 0.5, "width": 125, "visible": true, "text": "属性", "name": "name", "height": 42, "fontSize": 28, "color": "#ff0400" }, "compId": 15 }, { "type": "Label", "props": { "x": 115.5, "width": 125, "text": "0", "name": "val", "height": 42, "fontSize": 28, "color": "#ff0400", "align": "center" }, "compId": 18 }] }] }] }, { "type": "Button", "props": { "y": 609, "x": 1157, "width": 143, "visible": true, "var": "btnClear", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "清理数据", "height": 53 }, "compId": 27 }, { "type": "Button", "props": { "y": 19, "x": 11, "width": 143, "visible": true, "var": "btn_Invincible", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "打开无敌", "height": 53 }, "compId": 60 }, { "type": "TextInput", "props": { "y": 557, "x": 1133, "width": 167, "var": "imput_Num", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": " 输入胜利人数", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 56 }, { "type": "Button", "props": { "y": 664, "x": 1158, "width": 143, "visible": true, "var": "btn_makeSure", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "确定", "height": 53 }, "compId": 53 }, { "type": "Button", "props": { "y": 664, "x": 976, "width": 143, "visible": true, "var": "btn_close", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 20, "label": "关闭", "height": 53 }, "compId": 65 }, { "type": "Button", "props": { "y": 90, "x": 11, "width": 143, "visible": true, "var": "btn_camera", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "视野漫游", "height": 53 }, "compId": 70 }, { "type": "Button", "props": { "y": 161, "x": 11, "width": 143, "visible": true, "var": "btn_hitShow", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 23, "label": "打开伤害显示", "height": 53 }, "compId": 71 }, { "type": "Button", "props": { "y": 232, "x": 11, "width": 143, "visible": true, "var": "btn_hitShow1", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 23, "label": "打开玩家显示", "height": 53 }, "compId": 72 }, { "type": "Button", "props": { "y": 303, "x": 11, "width": 143, "visible": true, "var": "btn_clear", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 23, "label": "清空本地缓存", "height": 53 }, "compId": 73 }, { "type": "Label", "props": { "y": 320.5, "x": 992, "var": "lab_time", "text": "当前局数:3333", "fontSize": 50, "color": "#ffffff" }, "compId": 74 }, { "type": "Button", "props": { "y": 19, "x": 179, "width": 143, "visible": true, "var": "btn_Pause", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "暂停AI", "height": 53 }, "compId": 75 }, { "type": "Button", "props": { "y": 90, "x": 179, "width": 143, "visible": true, "var": "btn_pause0", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "暂停己方AI", "height": 53 }, "compId": 76 }, { "type": "Button", "props": { "y": 161, "x": 179, "width": 143, "visible": true, "var": "btn_pause1", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "暂停敌方AI", "height": 53 }, "compId": 77 }, { "type": "Button", "props": { "y": 232, "x": 179, "width": 143, "visible": true, "var": "btn_attack", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "停止AI攻击", "height": 53 }, "compId": 78 }, { "type": "Button", "props": { "y": 303, "x": 179, "width": 143, "visible": true, "var": "btn_bomb", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "无限手雷", "height": 53 }, "compId": 79 }, { "type": "Button", "props": { "y": 375, "x": 179, "width": 143, "visible": true, "var": "btn_Hit", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "height": 53 }, "compId": 80 }, { "type": "Button", "props": { "y": 375, "x": 19, "width": 143, "visible": true, "var": "btn_tank", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 18, "label": "坦克原地旋转开", "height": 53 }, "compId": 81 }, { "type": "Button", "props": { "y": 447.5, "x": 19, "width": 143, "visible": true, "var": "btn_addMoney", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "增加金币", "height": 53 }, "compId": 82 }, { "type": "TextInput", "props": { "y": 557, "x": 952, "width": 167, "var": "imput_cnt", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": " 输入当前局数", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 83 }, { "type": "TextInput", "props": { "y": 505.5, "x": 952, "width": 167, "var": "input_task", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": " 输入任务ID", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 84 }, { "type": "TextInput", "props": { "y": 452.5, "x": 952, "width": 167, "var": "input_delTask", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": " 删除任务类型", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 85 }, { "type": "TextInput", "props": { "y": 452.5, "x": 1133, "width": 167, "var": "input_taskLv", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": "战令等级", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 87 }, { "type": "TextInput", "props": { "y": 500.5, "x": 1133, "width": 167, "var": "input_taskExp", "type": "number", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "promptColor": "#ffffff", "prompt": "增加战令经验", "height": 43, "fontSize": 20, "color": "#ffffff" }, "compId": 88 }, { "type": "Button", "props": { "y": 527, "x": 19, "width": 143, "visible": true, "var": "btn_openView", "stateNum": 1, "skin": "common/img_battle_fuhuo.png", "labelSize": 26, "label": "测试界面", "height": 53 }, "compId": 89 }], "loadList": ["common/blank.png", "common/img_battle_fuhuo.png"], "loadList3D": [] };
          view.DebugViewUI = DebugViewUI;
          REG("ui.view.DebugViewUI", DebugViewUI);
          class GameSceneUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GameSceneUI.uiView);
              }
          }
          GameSceneUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "positionVariance_0": 100, "maxPartices": 100, "left": 0, "height": 750, "bottom": 0 }, "compId": 1, "child": [{ "type": "Box", "props": { "width": 1334, "var": "boxCenter", "top": 0, "right": 0, "left": 0, "height": 750, "bottom": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 85, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "SnipingBox", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 257, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/battle/bg_kaijing.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 258 }] }, { "type": "Box", "props": { "y": 127, "x": 47, "width": 385, "visible": false, "var": "doubleHitBox", "height": 133 }, "compId": 783, "child": [{ "type": "Image", "props": { "y": 50, "skin": "battle/img_hitTips.png" }, "compId": 784 }, { "type": "Image", "props": { "y": 54, "x": 160, "skin": "battle/img_battle_x.png" }, "compId": 785 }, { "type": "FontClip", "props": { "y": 65, "x": 351, "width": 247, "var": "clip_doubleHit", "value": "1", "skin": "resource/common/clip_golden.png", "sheet": "0123456789", "height": 128, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 786 }] }, { "type": "Box", "props": { "visible": true, "var": "bottomBox", "right": 0, "mouseThrough": true, "left": 0, "height": 312, "bottom": 0 }, "compId": 196, "child": [{ "type": "Box", "props": { "visible": false, "var": "tankBox", "right": 0, "mouseThrough": true, "mouseEnabled": true, "left": 0, "height": 289, "bottom": 0, "anchorY": 0.65, "anchorX": 0.5 }, "compId": 280, "child": [{ "type": "Box", "props": { "width": 770, "height": 374, "centerX": 0, "bottom": 2, "alpha": 1 }, "compId": 480, "child": [{ "type": "Image", "props": { "y": 172, "x": 568.5, "var": "img_tankBg", "skin": "battle/Veh_body.png" }, "compId": 282 }, { "type": "Image", "props": { "y": 201, "x": 600, "var": "img_tank", "skin": "battle/Veh_aim.png", "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 281 }, { "type": "Image", "props": { "y": 197, "x": 600, "var": "img_airBg", "skin": "battle/img_battle_airBg.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 620 }, { "type": "Image", "props": { "y": -1, "x": 179, "var": "lab_tankState", "skin": "battle/img_battle_jiuxu.png", "scaleY": 0.6, "scaleX": 0.6 }, "compId": 460 }, { "type": "Sprite", "props": { "y": -19, "x": 179, "texture": "battle/img_battle_jiuxu1.png" }, "compId": 459 }, { "type": "Image", "props": { "y": 213, "x": 331, "skin": "battle/img_battle_sudu.png" }, "compId": 518 }, { "type": "Image", "props": { "y": 299, "x": 287.5, "var": "btn_vehAttack0", "skin": "battle/img_battle_vehSelect.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 465 }, { "type": "Image", "props": { "y": 299, "x": 485.5, "var": "btn_vehAttack1", "skin": "battle/img_battle_vehNoSelect.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 587 }, { "type": "Label", "props": { "y": 230, "x": 353, "var": "lab_tankSpeed", "valign": "middle", "text": "24", "overflow": "hidden", "fontSize": 25, "color": "#f4ff00", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 285 }, { "type": "Label", "props": { "y": 329, "x": 350.09619140625, "width": 50, "valign": "middle", "text": "/", "overflow": "hidden", "height": 20, "fontSize": 14, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 584 }, { "type": "Label", "props": { "y": 328, "x": 547, "width": 50, "valign": "middle", "text": "/", "overflow": "hidden", "height": 20, "fontSize": 14, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 586 }, { "type": "Label", "props": { "y": 327, "x": 302.09619140625, "width": 43, "var": "lab_tankBullet0", "valign": "middle", "text": "8", "overflow": "hidden", "height": 26, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 283 }, { "type": "Label", "props": { "y": 328, "x": 344.09619140625, "width": 28, "var": "lab_vehMaxCnt0", "valign": "middle", "text": "32", "overflow": "hidden", "height": 29, "fontSize": 14, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 467 }, { "type": "Label", "props": { "y": 327, "x": 501, "width": 43, "var": "lab_tankBullet1", "valign": "middle", "text": "8", "overflow": "hidden", "height": 26, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 588 }, { "type": "Label", "props": { "y": 328, "x": 543, "width": 28, "var": "lab_vehMaxCnt1", "valign": "middle", "text": "32", "overflow": "hidden", "height": 29, "fontSize": 14, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 589 }, { "type": "Image", "props": { "y": 287, "x": 288.09619140625, "width": 143, "var": "img_veh_0", "pivotY": 17, "pivotX": 72, "height": 33 }, "compId": 585 }, { "type": "Image", "props": { "y": 286, "x": 487, "width": 143, "var": "img_veh_1", "pivotY": 17, "pivotX": 72, "height": 33 }, "compId": 590 }] }, { "type": "Box", "props": { "width": 325, "visible": false, "var": "airBox", "mouseThrough": true, "mouseEnabled": true, "left": 1, "height": 302, "bottom": -1, "anchorY": 1, "anchorX": 0.5 }, "compId": 753, "child": [{ "type": "Image", "props": { "y": 21, "x": 66, "var": "airOp", "skin": "battle/img_battle_airOp.png", "scaleY": 1.2, "scaleX": 1.2 }, "compId": 787, "child": [{ "type": "Image", "props": { "y": 96.5, "x": 96, "var": "btn_airBack", "skin": "battle/img_battle_aircaoZuo.png", "rotation": 45, "alpha": 0 }, "compId": 790 }, { "type": "Image", "props": { "y": 96, "x": 96, "var": "btn_airLeft", "skin": "battle/img_battle_aircaoZuo.png", "rotation": 135, "alpha": 0 }, "compId": 793 }, { "type": "Image", "props": { "y": 96, "x": 96, "var": "btn_airForward", "skin": "battle/img_battle_aircaoZuo.png", "rotation": 225, "alpha": 0 }, "compId": 794 }, { "type": "Image", "props": { "y": 96, "x": 96, "var": "btn_airRight", "skin": "battle/img_battle_aircaoZuo.png", "rotation": 315, "alpha": 0 }, "compId": 795 }] }] }, { "type": "Box", "props": { "width": 1334, "var": "tankOperationBox", "right": 0, "mouseThrough": true, "left": 0, "height": 291, "bottom": 1 }, "compId": 778, "child": [{ "type": "Image", "props": { "y": 196, "width": 208, "visible": true, "var": "btn_back", "skin": "battle/img_battle_tank2.png", "left": 79, "height": 104, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 336 }, { "type": "Image", "props": { "y": 78, "width": 218, "visible": true, "var": "btn_forward", "skin": "battle/img_battle_tank1.png", "left": 74, "height": 134, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 337 }, { "type": "Box", "props": { "y": 203, "width": 132, "var": "btn_right", "scaleY": 1, "scaleX": 1, "right": 291, "height": 154, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 476, "child": [{ "type": "Image", "props": { "skin": "battle/img_battle_forward.png", "scaleY": 0.8, "scaleX": 0.8 }, "compId": 474 }] }, { "type": "Box", "props": { "y": 200, "width": 132, "var": "btn_left", "skewY": 0, "scaleY": 1, "scaleX": 1, "rotation": 180, "right": 148, "height": 154, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 477, "child": [{ "type": "Image", "props": { "skin": "battle/img_battle_forward.png", "scaleY": 0.8, "scaleX": 0.8 }, "compId": 478 }] }] }] }, { "type": "Box", "props": { "width": 1334, "var": "gunShowBox", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 430, "bottom": 0 }, "compId": 286, "child": [{ "type": "Box", "props": { "y": 246, "width": 681, "height": 184, "centerX": 0 }, "compId": 481, "child": [{ "type": "Image", "props": { "y": 109, "x": 430, "var": "btn_changeGun", "skin": "battle/img_battle_zuwuqiBg_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 494 }, { "type": "Image", "props": { "y": 110, "x": 249, "var": "btn_changeGun1", "skin": "battle/img_battle_zuwuqiBg_0.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 495 }, { "type": "Image", "props": { "y": 130, "x": 36, "width": 71, "var": "btn_goodsBg0", "skin": "battle/img_battle_daoJu1.png", "height": 73, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 512 }, { "type": "Image", "props": { "y": 130, "x": 117, "width": 71, "var": "btn_goodsBg1", "skin": "battle/img_battle_daoJu.png", "height": 73, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 591 }, { "type": "Image", "props": { "y": 130, "x": 572, "width": 71, "var": "btn_goodsBg2", "skin": "battle/img_battle_daoJu.png", "height": 73, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 594 }, { "type": "Image", "props": { "y": 130, "x": 655, "width": 71, "var": "btn_goodsBg3", "skin": "battle/img_battle_daoJu.png", "height": 73, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 597 }, { "type": "Image", "props": { "y": 133, "x": 38, "visible": true, "var": "img_prop_0", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 227 }, { "type": "Image", "props": { "y": 129, "x": 116, "visible": false, "var": "img_prop_1", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 593 }, { "type": "Image", "props": { "y": 129.5, "x": 573, "visible": false, "var": "img_prop_2", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 596 }, { "type": "Image", "props": { "y": 129, "x": 655, "visible": false, "var": "img_prop_3", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 599 }, { "type": "Image", "props": { "y": 107, "x": 429, "var": "img_gun0", "skewY": 0, "mouseEnabled": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 236 }, { "type": "Image", "props": { "y": 112, "x": 248, "var": "img_gun1", "scaleY": 1, "scaleX": 1, "mouseEnabled": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 237 }, { "type": "Label", "props": { "y": 130, "x": 392, "var": "gunCnt0", "valign": "middle", "text": "999", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 163 }, { "type": "Label", "props": { "y": 132, "x": 400, "var": "magazineCnt0", "valign": "middle", "text": "90", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 164 }, { "type": "Label", "props": { "y": 132, "x": 211, "width": 37, "var": "gunCnt1", "valign": "middle", "text": "999", "height": 24, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 228 }, { "type": "Label", "props": { "y": 139, "x": 217, "var": "magazineCnt1", "valign": "middle", "text": "32", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 230 }, { "type": "Label", "props": { "y": 132, "x": 399, "valign": "middle", "text": "/", "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 524 }, { "type": "Label", "props": { "y": 133, "x": 217, "width": 17, "valign": "middle", "text": "/", "height": 24, "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 525 }, { "type": "Label", "props": { "y": 158, "x": 57, "width": 33, "var": "lab_prop_0", "valign": "middle", "text": "3", "height": 12, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 307 }, { "type": "Label", "props": { "y": 153, "x": 137, "width": 33, "visible": false, "var": "lab_prop_1", "valign": "middle", "text": "1", "height": 12, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 592 }, { "type": "Label", "props": { "y": 153.5, "x": 596, "width": 33, "visible": false, "var": "lab_prop_2", "valign": "middle", "text": "1", "height": 12, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 595 }, { "type": "Label", "props": { "y": 153, "x": 676, "width": 33, "visible": false, "var": "lab_prop_3", "valign": "middle", "text": "1", "height": 12, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 598 }] }, { "type": "Button", "props": { "visible": false, "var": "btn_aim", "stateNum": 1, "skin": "battle/btn_jiantou_3.png", "right": -617, "bottom": 151 }, "compId": 202 }, { "type": "Image", "props": { "visible": false, "var": "btn_switch", "skin": "battle/img_battle_huDan.png", "right": -639, "bottom": 340, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 473 }, { "type": "Image", "props": { "y": 147, "x": 638, "visible": false, "var": "img_time2", "skin": "battle/img_battle_daojiShi.png" }, "compId": 500, "child": [{ "type": "Label", "props": { "y": 29, "x": 28, "width": 68, "visible": true, "var": "lab_tips", "valign": "middle", "text": "2.4秒", "overflow": "visible", "height": 30, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 306 }] }, { "type": "Image", "props": { "y": 9, "x": 635, "visible": false, "var": "img_time1", "skin": "battle/img_battle_daojiShi1.png" }, "compId": 499, "child": [{ "type": "Label", "props": { "y": 30, "x": 83, "width": 68, "visible": true, "var": "lab_tips2", "valign": "middle", "text": "6秒", "overflow": "visible", "height": 30, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 501 }] }] }, { "type": "Box", "props": { "y": 239, "mouseEnabled": false, "centerX": 0 }, "compId": 482, "child": [{ "type": "Sprite", "props": { "y": 41, "x": 1, "width": 350, "var": "sp_blood", "height": 15 }, "compId": 255 }, { "type": "Sprite", "props": { "y": 41, "x": 1, "width": 350, "var": "sp_hpMask", "height": 15 }, "compId": 239 }, { "type": "Sprite", "props": { "y": 58, "x": 1, "visible": false, "texture": "battle/im_battle_nengLi.png" }, "compId": 463 }, { "type": "Image", "props": { "visible": false, "skin": "battle/img_battle_huJia.png" }, "compId": 464 }] }] }, { "type": "Button", "props": { "width": 90, "visible": true, "var": "btn_fire", "stateNum": 1, "skin": "battle/img_battle_left_hti.png", "left": 95, "height": 90, "centerY": 18, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 263, "child": [{ "type": "Image", "props": { "y": 5, "x": 5, "skin": "battle/img_battle_left_hti1.png" }, "compId": 561 }, { "type": "Image", "props": { "y": 45, "x": 45, "skin": "battle/img_battle_left_hti3.png", "skewY": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 562 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "var": "centerBox", "mouseThrough": true, "mouseEnabled": false, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 248, "child": [{ "type": "Box", "props": { "y": 375, "x": 667, "width": 86, "visible": false, "var": "sign_0", "scaleY": 0.5, "scaleX": 0.5, "name": "sign_0", "height": 86, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 434, "child": [{ "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "scaleY": 1, "scaleX": 1, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 436 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "skewY": 180, "skewX": 0, "rotation": 0, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 437 }, { "type": "Image", "props": { "y": 43, "x": 43, "skin": "battle/bg_zhunxin_1.png", "name": "static", "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 435 }] }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 262, "visible": false, "var": "sign_1", "name": "sign_1", "mouseEnabled": false, "height": 186, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 377, "child": [{ "type": "Image", "props": { "y": 70, "x": 59, "skin": "battle/sign_11.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0 }, "compId": 383 }, { "type": "Image", "props": { "y": 70, "x": 203, "skin": "battle/sign_11.png", "skewY": 180, "rotation": 0, "anchorY": 0.5 }, "compId": 384 }, { "type": "Image", "props": { "skin": "battle/sign_1.png", "name": "static", "centerY": 8, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 378 }] }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 259, "visible": false, "var": "sign_2", "name": "sign_2", "height": 226, "centerY": -1, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 385, "child": [{ "type": "Image", "props": { "y": 73.5, "x": 81, "skin": "battle/sign_22.png", "scaleY": 1, "scaleX": 1, "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 391 }, { "type": "Image", "props": { "y": 153, "x": 81, "skin": "battle/sign_22.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 392 }, { "type": "Image", "props": { "y": 73.5, "x": 178.5, "skin": "battle/sign_22.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 393 }, { "type": "Image", "props": { "y": 153, "x": 178.5, "skin": "battle/sign_22.png", "scaleY": 1, "scaleX": 1, "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 396 }, { "type": "Image", "props": { "y": 114, "x": 99.5, "skin": "battle/sign_2.png", "scaleY": 1, "scaleX": 1, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 397 }, { "type": "Image", "props": { "y": 83, "x": 130, "skin": "battle/sign_2.png", "scaleY": 1, "scaleX": 1, "rotation": 90, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 398 }, { "type": "Image", "props": { "y": 114, "x": 160, "skin": "battle/sign_2.png", "scaleY": 1, "scaleX": 1, "rotation": 180, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 399 }, { "type": "Image", "props": { "y": 143.5, "x": 130, "skin": "battle/sign_2.png", "scaleY": 1, "scaleX": 1, "rotation": 270, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 400 }, { "type": "Image", "props": { "y": 113, "x": 130, "skin": "battle/sign_21.png", "scaleY": 1, "scaleX": 1, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 386 }] }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 259, "visible": false, "var": "sign_3", "name": "sign_3", "height": 226, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 401, "child": [{ "type": "Image", "props": { "y": 76, "x": 86, "skin": "battle/sign_32.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 412 }, { "type": "Image", "props": { "y": 149, "x": 172, "skin": "battle/sign_32.png", "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 413 }, { "type": "Image", "props": { "y": 149, "x": 86, "skin": "battle/sign_32.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 414 }, { "type": "Image", "props": { "y": 76, "x": 172, "skin": "battle/sign_32.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 416 }, { "type": "Image", "props": { "y": 113, "x": 129, "skin": "battle/sign_31.png", "scaleY": 1, "scaleX": 1, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 402 }] }, { "type": "Box", "props": { "width": 248, "visible": false, "var": "sign_4", "name": "sign_4", "height": 251, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 417, "child": [{ "type": "Image", "props": { "y": 126, "x": 124, "skin": "battle/sign_42.png", "scaleY": 1, "scaleX": 1, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 418 }, { "type": "Image", "props": { "y": 126, "x": 124, "skin": "battle/sign_41.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 424 }] }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 262, "visible": false, "var": "sign_5", "name": "sign_5", "height": 142, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 425, "child": [{ "type": "Image", "props": { "y": 59, "x": 131, "skin": "battle/sign_51.png", "scaleY": 1, "scaleX": 1, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 426 }, { "type": "Image", "props": { "y": 87, "x": 130, "skin": "battle/sign_51.png", "scaleY": 1, "scaleX": 1, "rotation": 180, "name": "static", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 429 }, { "type": "Image", "props": { "y": 38.5, "x": 44, "skin": "battle/sign_52.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 430 }, { "type": "Image", "props": { "y": 104, "x": 218.5, "skin": "battle/sign_52.png", "scaleY": 1, "scaleX": 1, "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 431 }, { "type": "Image", "props": { "y": 104, "x": 45, "skin": "battle/sign_52.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 432 }, { "type": "Image", "props": { "y": 38.5, "x": 218.5, "skin": "battle/sign_52.png", "skewX": 180, "scaleY": 1, "scaleX": 1, "rotation": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 433 }] }, { "type": "Image", "props": { "y": 375, "x": 666, "width": 159, "visible": false, "var": "hitEffectBox", "skin": "battle/img_hit1.png", "scaleX": 1, "rotation": 45, "height": 158, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 278 }, { "type": "Image", "props": { "y": 375, "x": 667, "visible": false, "var": "img_enemyPoint", "skin": "battle/img_enemyPoint.png", "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 301 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "hitBox", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 297 }, { "type": "Label", "props": { "y": 461, "x": 667, "width": 341, "visible": false, "var": "lab_hitShow", "valign": "middle", "text": "受攻部位:身体,伤害:100", "height": 45, "fontSize": 20, "color": "#fdfdfd", "centerY": 86, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5, "alpha": 1, "align": "center" }, "compId": 288 }, { "type": "Label", "props": { "y": 508, "x": 667, "width": 341, "visible": false, "var": "lab_hitShow1", "valign": "middle", "text": "受攻部位:身体,伤害:100", "height": 45, "fontSize": 20, "color": "#fdfdfd", "centerY": 133, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5, "alpha": 1, "align": "center" }, "compId": 290 }] }, { "type": "Button", "props": { "visible": false, "var": "btn_veh", "stateNum": 1, "skin": "battle/img_battle_up_veh.png", "right": 258, "centerY": -66, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 201, "child": [{ "type": "Image", "props": { "y": 35, "x": 43, "var": "icon_veh", "skin": "battle/img_battle_tankIcon.png", "skewY": 180, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 558 }] }, { "type": "Button", "props": { "visible": false, "var": "btn_veh1", "stateNum": 1, "skin": "battle/img_battle_down_veh.png", "skewY": 0, "skewX": 0, "scaleX": 1, "rotation": 0, "right": 80, "centerY": -66, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 520, "child": [{ "type": "Image", "props": { "y": 31, "x": 43, "width": 58, "var": "icon_veh1", "skin": "battle/img_battle_tankIcon.png", "height": 20, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 560 }] }] }, { "type": "Box", "props": { "var": "topBox", "top": 0, "right": 0, "mouseThrough": true, "left": 0, "height": 265 }, "compId": 188, "child": [{ "type": "List", "props": { "y": 0, "width": 326, "var": "list", "spaceY": 3, "right": 161, "repeatY": 4, "repeatX": 1, "mouseEnabled": false, "height": 148 }, "compId": 190, "child": [{ "type": "Box", "props": { "width": 322, "name": "render", "height": 34 }, "compId": 191, "child": [{ "type": "Image", "props": { "y": 18, "x": 153, "skin": "icon/100310.png", "skewX": 180, "scaleY": 0.6, "scaleX": 0.6, "rotation": 180, "name": "attackGun", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 195 }, { "type": "Label", "props": { "y": 15, "x": 0, "width": 110, "valign": "middle", "text": "边打枪边放屁", "pivotY": 12, "overflow": "hidden", "name": "attackName", "height": 23, "fontSize": 18, "color": "#ff4700", "align": "center" }, "compId": 192 }, { "type": "Label", "props": { "y": 15, "x": 322, "width": 108, "valign": "middle", "text": "边打枪边放屁", "overflow": "hidden", "name": "hitName", "height": 23, "fontSize": 18, "color": "#98e2fd", "anchorY": 0.5, "anchorX": 1, "align": "center" }, "compId": 193 }, { "type": "Image", "props": { "y": 15, "x": 204, "skin": "battle/img_battle_baoTou.png", "skewX": 180, "scaleY": 0.3, "scaleX": 0.3, "rotation": 180, "name": "attackFlag", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 751 }] }] }, { "type": "Box", "props": { "y": 0, "x": 451, "width": 432, "height": 86, "centerX": 0 }, "compId": 736, "child": [{ "type": "Image", "props": { "y": 0, "x": 39, "skin": "battle/img_battle_timebg.png" }, "compId": 747 }, { "type": "FontClip", "props": { "y": 62, "x": 210, "var": "font_time0", "value": "24", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.5, "scaleX": 0.5, "anchorY": 0.5, "anchorX": 1 }, "compId": 222 }, { "type": "FontClip", "props": { "y": 62, "x": 222, "var": "font_time1", "value": "08", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.5, "scaleX": 0.5, "anchorY": 0.5, "anchorX": 0 }, "compId": 224 }, { "type": "Sprite", "props": { "y": 42, "x": 214, "texture": "common/wenzi_maohao.png" }, "compId": 223 }, { "type": "Label", "props": { "y": 37.5, "x": 331, "var": "font_enemyDeadCnt", "valign": "middle", "text": "25", "overflow": "hidden", "fontSize": 30, "color": "#fd943f", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 566 }, { "type": "Label", "props": { "y": 37.5, "x": 100, "var": "font_playerDeadCnt", "valign": "middle", "text": "20", "overflow": "hidden", "fontSize": 30, "color": "#48f0ff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 567 }, { "type": "Label", "props": { "y": 37.5, "x": 55, "wordWrap": true, "width": 31, "valign": "middle", "text": "己方", "overflow": "hidden", "height": 73, "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 673 }, { "type": "Label", "props": { "y": 37.5, "x": 378, "wordWrap": true, "width": 28, "valign": "middle", "text": "敌方", "overflow": "hidden", "height": 47, "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 674 }, { "type": "Label", "props": { "y": 23, "x": 216, "var": "lab_winScore", "valign": "middle", "text": "45", "overflow": "hidden", "fontSize": 40, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 675 }] }, { "type": "Box", "props": { "y": 9, "width": 150, "var": "mapBox", "right": 4, "mouseEnabled": false, "height": 150 }, "compId": 264, "child": [{ "type": "Image", "props": { "y": -214, "x": -214, "var": "map", "skin": "resource/map/MapIslandA1.png" }, "compId": 213, "child": [{ "type": "Image", "props": { "y": 215, "x": 205, "width": 160, "var": "mapMask", "scaleY": 1, "scaleX": 1, "renderType": "mask", "height": 150 }, "compId": 308, "child": [{ "type": "Circle", "props": { "y": 74, "x": 83, "radius": 75, "lineWidth": 1, "fillColor": "#ff0000" }, "compId": 750 }] }, { "type": "Image", "props": { "y": 951, "x": 623, "visible": false, "var": "teemmate1", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 312 }, { "type": "Image", "props": { "y": 1122, "x": 994, "visible": false, "var": "teemmate2", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 314 }, { "type": "Image", "props": { "y": 1261, "x": 994, "visible": false, "var": "teemmate3", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 315 }, { "type": "Image", "props": { "y": 1401, "x": 994, "visible": false, "var": "teemmate4", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 316 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "teemmate5", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 317 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "teemmate6", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 318 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "teemmate7", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 319 }, { "type": "Image", "props": { "y": 982, "x": 994, "visible": false, "var": "enemy0", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 320 }, { "type": "Image", "props": { "y": 1122, "x": 994, "visible": false, "var": "enemy1", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 321 }, { "type": "Image", "props": { "y": 1261, "x": 994, "visible": false, "var": "enemy2", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 322 }, { "type": "Image", "props": { "y": 1401, "x": 994, "visible": false, "var": "enemy3", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 323 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "enemy4", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 324 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "enemy5", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.5 }, "compId": 325 }, { "type": "Image", "props": { "y": 1541, "x": 994, "visible": false, "var": "enemy6", "skin": "battle/icon_wanjiaweizhi_1.png", "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.3 }, "compId": 326 }] }, { "type": "Image", "props": { "y": 0, "x": 0, "width": 150, "skin": "battle/bg_ditudi_1.png", "height": 150 }, "compId": 208 }, { "type": "Image", "props": { "y": 59.5, "x": -12, "skin": "battle/wenzi_w.png" }, "compId": 212 }, { "type": "Image", "props": { "y": 136, "x": 61.5, "skin": "battle/wenzi_s.png" }, "compId": 211 }, { "type": "Image", "props": { "y": -13.5, "x": 61.5, "skin": "battle/wenzi_n.png" }, "compId": 210 }, { "type": "Image", "props": { "y": 59.5, "x": 136, "skin": "battle/wenzi_e.png" }, "compId": 209 }, { "type": "Image", "props": { "y": 73, "x": 75, "width": 43, "var": "rolePoint", "skin": "battle/icon_wanjiaweizhi_1.png", "height": 43, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 616, "child": [{ "type": "Image", "props": { "y": -25, "x": -18, "skin": "battle/icon_wanjiaweizhi_2.png" }, "compId": 617 }] }] }, { "type": "Button", "props": { "var": "btn_return", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0 }, "compId": 440, "child": [{ "type": "Image", "props": { "y": 6, "x": 60, "top": 6, "stateNum": 1, "skin": "xIndex/img_game_back1.png", "sizeGrid": "0,5,0,24", "left": 60 }, "compId": 789 }] }] }, { "type": "Image", "props": { "visible": false, "var": "img_hypovolemia", "top": 0, "skin": "battle/img_xxxxx.png", "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 296 }, { "type": "Box", "props": { "y": 10, "x": 10, "visible": false, "var": "changeWeaponBox", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 526, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "right": 0, "left": 0, "bottom": 0 }, "compId": 527 }, { "type": "Image", "props": { "y": 168, "skin": "resource/game/bg_revive.png", "right": -5, "left": -5 }, "compId": 534 }, { "type": "Label", "props": { "y": 209, "text": "复活等待中，神兵等你拿", "fontSize": 38, "color": "#ffffff", "centerY": -166, "centerX": 0, "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 529 }, { "type": "Box", "props": { "width": 1334, "scaleY": 0.7, "scaleX": 0.7, "height": 836, "centerY": 10, "centerX": -1 }, "compId": 644, "child": [{ "type": "Image", "props": { "y": 209, "x": 293, "skin": "trial/bg_yellow.png", "name": "xzzzzzzzzz" }, "compId": 859 }, { "type": "Image", "props": { "y": 324, "x": 590, "var": "img_trial1", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 860 }, { "type": "Image", "props": { "y": 326, "x": 790.9013671875, "var": "img_trial2", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 861 }, { "type": "Image", "props": { "y": 325.5, "x": 993, "var": "img_trial3", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 862 }, { "type": "Image", "props": { "y": 329, "x": 382, "width": 256, "var": "img_icon1", "scaleY": 0.8, "scaleX": 0.8, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 868 }, { "type": "Image", "props": { "y": 326, "x": 593, "width": 256, "var": "img_icon2", "scaleY": 0.4, "scaleX": 0.4, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 869 }, { "type": "Image", "props": { "y": 329, "x": 791, "width": 256, "var": "img_icon3", "scaleY": 0.4, "scaleX": 0.4, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 870 }, { "type": "Image", "props": { "y": 326, "x": 994, "width": 256, "var": "img_icon4", "scaleY": 0.4, "scaleX": 0.4, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 871 }, { "type": "Image", "props": { "y": 597, "x": 797, "visible": false, "var": "btn_getAll", "skin": "resource/trial/btn_getAll.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 867 }, { "type": "Image", "props": { "y": 211, "x": 292, "width": 171, "var": "btn_get1", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "height": 240, "alpha": 0 }, "compId": 872 }, { "type": "Image", "props": { "y": 326, "x": 590, "width": 141, "var": "btn_get2", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "height": 200, "anchorY": 0.5, "anchorX": 0.5, "alpha": 0 }, "compId": 873 }, { "type": "Image", "props": { "y": 231, "x": 727.5, "width": 137, "var": "btn_get3", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "height": 186, "alpha": 0 }, "compId": 874 }, { "type": "Image", "props": { "y": 231, "x": 926, "width": 140, "var": "btn_get4", "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "height": 184, "alpha": 0 }, "compId": 875 }, { "type": "Label", "props": { "y": 464.5, "x": 277, "wordWrap": true, "width": 178, "var": "itemName1", "text": "MGL140000(收藏)", "strokeColor": "#6e6161", "stroke": 4, "overflow": "hidden", "name": "itemName1", "height": 63, "fontSize": 32, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 876 }, { "type": "Label", "props": { "y": 351, "x": 590, "width": 90, "var": "itemName2", "valign": "middle", "text": "波波沙波波沙", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "height": 20, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 877 }, { "type": "Label", "props": { "y": 351, "x": 790.9013671875, "width": 110, "var": "itemName3", "valign": "middle", "text": "s-Kair", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "height": 20, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 878 }, { "type": "Label", "props": { "y": 354, "x": 993, "width": 112, "var": "itemName4", "valign": "middle", "text": "左轮手枪", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "height": 20, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 879 }, { "type": "Label", "props": { "y": 398, "x": 790.9013671875, "var": "lab_get3", "valign": "middle", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 883 }, { "type": "Label", "props": { "y": 398, "x": 993, "var": "lab_get4", "valign": "middle", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 884 }, { "type": "Label", "props": { "y": 398, "x": 590, "width": 44.859375, "var": "lab_get2", "valign": "middle", "text": "试用", "height": 22, "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 885 }, { "type": "Label", "props": { "y": 426, "x": 384, "var": "lab_get1", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 886 }, { "type": "Image", "props": { "y": 426, "x": 331, "width": 34, "var": "img_video1", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "height": 34, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 863 }, { "type": "Image", "props": { "y": 354, "x": 637, "width": 34, "visible": false, "var": "img_video2", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "height": 34, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 864 }, { "type": "Image", "props": { "y": 354, "x": 839, "visible": false, "var": "img_video3", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 865 }, { "type": "Image", "props": { "y": 354, "x": 1040, "width": 34, "visible": false, "var": "img_video4", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "height": 34, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 866 }] }, { "type": "Image", "props": { "width": 277, "visible": true, "var": "changeWeapon", "skin": "comp/btn_confirm.png", "height": 102, "centerY": 250, "centerX": 199, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 532, "child": [{ "type": "Label", "props": { "y": 51, "x": 131, "width": 120, "text": "更换英雄", "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 533 }, { "type": "Sprite", "props": { "y": 231, "x": 584, "visible": false, "texture": "comp/icon_ad.png" }, "compId": 618 }] }, { "type": "Image", "props": { "width": 277, "visible": false, "var": "btn_ttRevive", "skin": "comp/btn_confirm.png", "scaleY": 1.1, "scaleX": 1.1, "height": 102, "centerY": 250, "centerX": -160, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 889, "child": [{ "type": "Label", "props": { "y": 51, "x": 138, "width": 120, "text": "立即复活", "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 890 }] }, { "type": "Image", "props": { "visible": false, "var": "btn_ttSelect", "skin": "comp/gou.png", "scaleY": 0.6, "scaleX": 0.6, "centerY": 305, "centerX": -43, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 892 }, { "type": "Label", "props": { "visible": false, "var": "lab_ttTips", "text": "看视频试用神兵", "scaleY": 0.6, "scaleX": 0.6, "fontSize": 20, "color": "#ffffff", "centerY": 305, "centerX": 21, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 894 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "getAmmoBox", "top": 0, "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 704, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "right": 0, "left": 0, "bottom": 0 }, "compId": 705 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 752, "child": [{ "type": "Image", "props": { "y": 167, "x": -434, "width": 2201, "skin": "resource/game/bg_revive.png", "height": 375 }, "compId": 706 }, { "type": "Image", "props": { "y": 281, "x": 590, "skin": "trial/bg_green.png", "mouseEnabled": false }, "compId": 796, "child": [{ "type": "Image", "props": { "y": 81, "x": 78, "skin": "icon/101303_T.png", "scaleY": 0.35, "scaleX": 0.35, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 732 }] }, { "type": "Label", "props": { "y": 223, "x": 667, "text": "获取更多弹药", "fontSize": 50, "color": "#ffff00", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 707 }, { "type": "Button", "props": { "y": 514, "x": 666, "var": "img_getAmmo", "stateNum": 1, "skin": "comp/btn_confirm.png", "scaleY": 1.1, "scaleX": 1.1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 895, "child": [{ "type": "Label", "props": { "y": 28, "x": 52, "var": "lab_getAmmo", "text": "补充弹药", "fontSize": 30, "color": "#ffffff" }, "compId": 896 }, { "type": "Sprite", "props": { "y": 26, "x": 16, "var": "img_ttAmmoVideo", "texture": "comp/icon_ad.png" }, "compId": 733 }] }, { "type": "Image", "props": { "y": 561.2, "x": 619.2, "visible": false, "var": "img_ammoSelect", "skin": "comp/gou.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 897 }, { "type": "Label", "props": { "y": 561.2, "x": 691.2, "visible": false, "var": "lab_ammoTips", "text": "看视频补充弹药", "scaleY": 0.6, "scaleX": 0.6, "fontSize": 20, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 898 }, { "type": "Label", "props": { "y": 562, "x": 667, "var": "lab_noAmmo", "underline": true, "text": "残忍拒绝", "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 735 }, { "type": "Button", "props": { "y": 504, "x": 666, "width": 225, "visible": false, "var": "img_wxGetAmmo", "stateNum": 1, "skin": "comp/btn_confirm.png", "scaleY": 0.8, "scaleX": 0.8, "height": 86, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 899, "child": [{ "type": "Label", "props": { "y": 28, "x": 52, "text": "补充弹药", "fontSize": 30, "color": "#ffffff" }, "compId": 900 }] }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "VehReviveBox", "top": 0, "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 797, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "right": 0, "left": 0, "bottom": 0 }, "compId": 798 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 799, "child": [{ "type": "Image", "props": { "y": 167, "x": -434, "width": 2201, "skin": "resource/game/bg_revive.png", "height": 375 }, "compId": 800 }, { "type": "Image", "props": { "y": 281, "x": 590, "var": "btn_reviveVeh", "skin": "trial/bg_green.png" }, "compId": 801, "child": [{ "type": "Sprite", "props": { "y": 152, "x": 19, "texture": "comp/icon_ad.png" }, "compId": 803 }, { "type": "Label", "props": { "y": 170, "x": 91, "text": "复活", "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 804 }] }, { "type": "Label", "props": { "y": 562, "x": 667, "var": "btn_noReviveVeh", "underline": true, "text": "残忍拒绝", "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 805 }, { "type": "Label", "props": { "y": 223, "x": 667, "text": "复活载具", "fontSize": 50, "color": "#ffff00", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 806 }, { "type": "Image", "props": { "y": 354.5, "x": 666.5, "var": "img_vehIcon", "skin": "icon/TankMordenA1.png", "scaleY": 0.5, "scaleX": 0.5, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 807 }] }] }, { "type": "Box", "props": { "visible": false, "var": "beginGameBox", "top": 0, "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 490, "child": [{ "type": "Image", "props": { "top": 119, "skin": "resource/battle/img_battle_renwu.png", "centerX": 0 }, "compId": 496, "child": [{ "type": "Label", "props": { "y": 22, "x": 366, "var": "lab_tips1", "valign": "middle", "text": "杀死一名敌方，我方增加1分，达到获胜积分时胜利；时间归零积分高的一方胜利", "fontSize": 28, "color": "#ff7e00", "centerY": 0, "centerX": 0, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 497 }] }, { "type": "Label", "props": { "y": 375, "x": 667, "visible": false, "var": "lab_beginGameTime", "text": "8", "fontSize": 88, "color": "#ffffff", "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 489 }] }, { "type": "Image", "props": { "x": 1269, "visible": false, "var": "imgRecorder", "skin": "toutiao/luzhizhong.png", "right": 35, "bottom": 450, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 887, "child": [{ "type": "Image", "props": { "y": 72, "x": 0, "skin": "toutiao/luzhizhong1.png" }, "compId": 888 }] }, { "type": "Box", "props": { "width": 2000, "visible": false, "var": "mouseBox", "mouseThrough": false, "mouseEnabled": true, "height": 1500, "centerY": 0, "centerX": 0 }, "compId": 904, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "right": 0, "left": 0, "bottom": 0, "alpha": 0.1 }, "compId": 908 }, { "type": "Sprite", "props": { "y": 604, "x": 857, "texture": "battle/dianjijinru.png" }, "compId": 910 }] }, { "type": "KillFont_ef", "props": { "y": 217, "x": 971.5, "var": "hitAni", "runtime": "script/ui/KillFont_ef.ts" }, "compId": 911 }, { "type": "HeadShot_ef", "props": { "y": 194, "x": 950, "var": "headShotAni", "runtime": "script/ui/HeadShot_ef.ts" }, "compId": 912 }], "loadList": ["resource/battle/bg_kaijing.png", "battle/img_hitTips.png", "battle/img_battle_x.png", "resource/common/clip_golden.png", "battle/Veh_body.png", "battle/Veh_aim.png", "battle/img_battle_airBg.png", "battle/img_battle_jiuxu.png", "battle/img_battle_jiuxu1.png", "battle/img_battle_sudu.png", "battle/img_battle_vehSelect.png", "battle/img_battle_vehNoSelect.png", "battle/img_battle_airOp.png", "battle/img_battle_aircaoZuo.png", "battle/img_battle_tank2.png", "battle/img_battle_tank1.png", "battle/img_battle_forward.png", "battle/img_battle_zuwuqiBg_1.png", "battle/img_battle_zuwuqiBg_0.png", "battle/img_battle_daoJu1.png", "battle/img_battle_daoJu.png", "battle/btn_jiantou_3.png", "battle/img_battle_huDan.png", "battle/img_battle_daojiShi.png", "battle/img_battle_daojiShi1.png", "battle/im_battle_nengLi.png", "battle/img_battle_huJia.png", "battle/img_battle_left_hti.png", "battle/img_battle_left_hti1.png", "battle/img_battle_left_hti3.png", "battle/bg_zhunxin_2.png", "battle/bg_zhunxin_1.png", "battle/sign_11.png", "battle/sign_1.png", "battle/sign_22.png", "battle/sign_2.png", "battle/sign_21.png", "battle/sign_32.png", "battle/sign_31.png", "battle/sign_42.png", "battle/sign_41.png", "battle/sign_51.png", "battle/sign_52.png", "battle/img_hit1.png", "battle/img_enemyPoint.png", "battle/img_battle_up_veh.png", "battle/img_battle_tankIcon.png", "battle/img_battle_down_veh.png", "icon/100310.png", "battle/img_battle_baoTou.png", "battle/img_battle_timebg.png", "common/clip_white.png", "common/wenzi_maohao.png", "resource/map/MapIslandA1.png", "battle/icon_wanjiaweizhi_1.png", "battle/bg_ditudi_1.png", "battle/wenzi_w.png", "battle/wenzi_s.png", "battle/wenzi_n.png", "battle/wenzi_e.png", "battle/icon_wanjiaweizhi_2.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png", "battle/img_xxxxx.png", "common/blank.png", "resource/game/bg_revive.png", "trial/bg_yellow.png", "trial/bg_green.png", "resource/trial/btn_getAll.png", "comp/icon_ad.png", "comp/btn_confirm.png", "comp/gou.png", "icon/101303_T.png", "icon/TankMordenA1.png", "resource/battle/img_battle_renwu.png", "toutiao/luzhizhong.png", "toutiao/luzhizhong1.png", "battle/dianjijinru.png"], "loadList3D": [] };
          view.GameSceneUI = GameSceneUI;
          REG("ui.view.GameSceneUI", GameSceneUI);
          class GetRewardUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GetRewardUI.uiView);
              }
          }
          GetRewardUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "x": 667, "width": 1090, "height": 640, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 9, "x": -455, "width": 2000, "skin": "resource/game/bg_revive.png" }, "compId": 77 }, { "type": "Box", "props": { "y": 170, "x": 470, "var": "box" }, "compId": 44 }, { "type": "Box", "props": { "y": 434, "x": 545, "width": 1090, "var": "btnBox", "height": 80, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 82, "child": [{ "type": "Button", "props": { "y": 40, "x": 545, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 61, "child": [{ "type": "Label", "props": { "y": 28, "x": 28, "text": "恭喜获得", "fontSize": 40, "color": "#ffffff", "bold": true }, "compId": 62 }] }, { "type": "Button", "props": { "y": 40, "x": 646, "visible": false, "var": "btn_share", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 78, "child": [{ "type": "Label", "props": { "y": 29, "x": 43, "text": "分享", "fontSize": 40, "color": "#ffffff", "bold": true }, "compId": 79 }, { "type": "Sprite", "props": { "y": 28, "x": 134, "texture": "xIndex/fenxiang icon.png" }, "compId": 81 }] }] }] }], "loadList": ["resource/game/bg_revive.png", "comp/lingquanniu.png", "xIndex/fenxiang icon.png"], "loadList3D": [] };
          view.GetRewardUI = GetRewardUI;
          REG("ui.view.GetRewardUI", GetRewardUI);
          class GuideGunGetViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GuideGunGetViewUI.uiView);
              }
          }
          GuideGunGetViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 375, "x": 667, "width": 1090, "height": 640, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 132, "x": -355, "width": 1800, "skin": "resource/game/bg_revive.png" }, "compId": 42 }, { "type": "Label", "props": { "y": 58, "x": 544, "var": "lab_name", "valign": "middle", "text": "恭喜获得M4-A1", "fontSize": 70, "color": "#ffff00", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 35 }, { "type": "Button", "props": { "y": 584, "x": 545, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Label", "props": { "y": 28, "x": 30, "valign": "middle", "text": "立即体验", "fontSize": 40, "color": "#ffffff", "align": "center" }, "compId": 39 }] }, { "type": "Image", "props": { "y": 320, "x": 545, "skin": "trial/bg_green.png", "scaleY": 1.75, "scaleX": 1.75, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 40 }, { "type": "Image", "props": { "y": 267, "x": 545, "var": "img_icon", "skin": "icon/100302_T.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 43 }] }], "loadList": ["resource/game/bg_revive.png", "comp/lingquanniu.png", "trial/bg_green.png", "icon/100302_T.png"], "loadList3D": [] };
          view.GuideGunGetViewUI = GuideGunGetViewUI;
          REG("ui.view.GuideGunGetViewUI", GuideGunGetViewUI);
          class GuideGunTipsViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GuideGunTipsViewUI.uiView);
              }
          }
          GuideGunTipsViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 638, "height": 332, "centerY": 0, "centerX": 0 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 66, "x": 122, "width": 396, "skin": "openBox/img_openBox_nativeBg.png", "height": 186, "sizeGrid": "25,30,25,30" }, "compId": 41 }, { "type": "Label", "props": { "y": 115, "x": 154, "valign": "middle", "text": "尚未拥有，是否立即获取", "fontSize": 30, "color": "#ffffff", "align": "center" }, "compId": 35 }, { "type": "Button", "props": { "y": 213, "x": 319, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Label", "props": { "y": 23, "x": 60, "valign": "middle", "text": "获取", "fontSize": 50, "color": "#ffffff", "align": "center" }, "compId": 39 }] }] }], "loadList": ["openBox/img_openBox_nativeBg.png", "comp/lingquanniu.png"], "loadList3D": [] };
          view.GuideGunTipsViewUI = GuideGunTipsViewUI;
          REG("ui.view.GuideGunTipsViewUI", GuideGunTipsViewUI);
          class GuideSceneUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GuideSceneUI.uiView);
              }
          }
          GuideSceneUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "var": "base", "top": 0, "right": 0, "name": "base", "left": 0, "bottom": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 198, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "var": "centerBox", "mouseEnabled": false, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 155, "child": [{ "type": "Box", "props": { "y": 397, "x": 689, "width": 86, "var": "imgSign", "scaleY": 0.5, "scaleX": 0.5, "height": 86, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 156, "child": [{ "type": "Image", "props": { "y": 43, "x": 43, "skin": "battle/bg_zhunxin_1.png", "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 157 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "scaleY": 1, "scaleX": 1, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 158 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_2.png", "skewY": 180, "skewX": 0, "rotation": 0, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 159 }] }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 86, "visible": false, "var": "vehSign", "height": 86, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 160, "child": [{ "type": "Image", "props": { "y": 43, "x": 43, "skin": "battle/bg_zhunxin_zhishengji_1.png", "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 161 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_zhishengji_2.png", "scaleY": 1, "scaleX": 1, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 162 }, { "type": "Image", "props": { "skin": "battle/bg_zhunxin_zhishengji_2.png", "skewY": 180, "skewX": 0, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 163 }, { "type": "Image", "props": { "y": 10, "x": 10, "skin": "battle/bg_zhunxin_zhishengji_2.png", "skewY": 0, "skewX": 0, "rotation": 90, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 164 }, { "type": "Image", "props": { "y": 20, "x": 20, "skin": "battle/bg_zhunxin_zhishengji_2.png", "skewY": 0, "skewX": 0, "rotation": -90, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 165 }] }, { "type": "Label", "props": { "width": 341, "visible": false, "var": "lab_hitShow", "valign": "middle", "text": "受攻部位:身体,伤害:100", "height": 45, "fontSize": 20, "color": "#fdfdfd", "centerY": 86, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5, "alpha": 1, "align": "center" }, "compId": 166 }, { "type": "Label", "props": { "width": 341, "visible": false, "var": "lab_hitShow1", "valign": "middle", "text": "受攻部位:身体,伤害:100", "height": 45, "fontSize": 20, "color": "#fdfdfd", "centerY": 133, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5, "alpha": 1, "align": "center" }, "compId": 167 }, { "type": "Image", "props": { "y": 375, "x": 666, "width": 159, "visible": false, "var": "hitEffectBox", "skin": "battle/img_hit1.png", "scaleX": 1, "rotation": 45, "height": 158, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 168 }, { "type": "Image", "props": { "y": 375, "x": 667, "visible": false, "var": "img_enemyPoint", "skin": "battle/img_enemyPoint.png", "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 169 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": true, "var": "hitBox", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 170 }, { "type": "Label", "props": { "y": 184, "x": 666, "visible": false, "var": "lab_hitTips", "valign": "middle", "text": "击杀!", "fontSize": 30, "color": "#ff0400", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 174 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "var": "boxCenter", "top": 0, "right": 0, "left": 0, "height": 750, "bottom": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 100, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "SnipingBox", "top": 0, "right": 0, "name": "SnipingBox", "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 103, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/battle/bg_kaijing.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 104 }] }, { "type": "Box", "props": { "visible": false, "var": "bottomBox", "right": 0, "name": "bottomBox", "mouseThrough": true, "left": 0, "height": 230, "bottom": 0 }, "compId": 105, "child": [{ "type": "Box", "props": { "y": 129, "x": 667, "visible": false, "var": "tankBox", "right": 0, "mouseThrough": true, "mouseEnabled": true, "left": 0, "height": 289, "bottom": 0, "anchorY": 0.65, "anchorX": 0.5 }, "compId": 436, "child": [{ "type": "Image", "props": { "y": 243, "visible": false, "var": "btn_vhe1", "skin": "battle/img_battle_xiaChe.png", "right": 20, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 439 }, { "type": "Image", "props": { "y": 19, "x": 115, "visible": false, "var": "btn_tankMove", "skin": "battle/img_battle_air0.png", "mouseEnabled": false, "alpha": 0 }, "compId": 440, "child": [{ "type": "Image", "props": { "y": 75, "x": 0, "skin": "battle/img_battle_tank.png" }, "compId": 441 }, { "type": "Image", "props": { "y": 46, "x": 46, "var": "btn_move", "skin": "battle/img_battle_air1.png" }, "compId": 442 }] }, { "type": "Image", "props": { "y": 161, "visible": false, "var": "btn_back", "skin": "battle/img_battle_tank2.png", "right": 96, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 443 }, { "type": "Image", "props": { "y": 69, "visible": false, "var": "btn_forward", "skin": "battle/img_battle_tank1.png", "right": 87, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 444 }, { "type": "Box", "props": { "y": 201.5, "width": 154, "var": "btn_right", "skewY": 0, "rotation": -90, "left": 1, "height": 137, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 445, "child": [{ "type": "Image", "props": { "width": 195, "skin": "battle/img_battle_forward.png", "scaleY": 0.8, "scaleX": 0.8 }, "compId": 446 }] }, { "type": "Box", "props": { "y": 201, "width": 154, "var": "btn_left", "skewY": 0, "rotation": 90, "left": 153, "height": 137, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 447, "child": [{ "type": "Image", "props": { "width": 195, "skin": "battle/img_battle_forward.png", "scaleY": 0.8, "scaleX": 0.8 }, "compId": 448 }] }, { "type": "Box", "props": { "width": 770, "height": 374, "centerX": 0, "bottom": 0 }, "compId": 449, "child": [{ "type": "Image", "props": { "y": 200, "x": 569, "skin": "battle/Veh_body.png" }, "compId": 450 }, { "type": "Image", "props": { "y": 228, "x": 600, "var": "img_tank", "skin": "battle/Veh_aim.png", "rotation": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 451 }, { "type": "Label", "props": { "y": 315, "x": 156, "width": 39, "var": "lab_tankBullet", "valign": "middle", "text": "10", "overflow": "hidden", "height": 29, "fontSize": 25, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 452 }, { "type": "Label", "props": { "y": 326, "x": 186, "width": 25, "var": "lab_vehMaxCnt", "valign": "middle", "text": "30", "overflow": "hidden", "height": 29, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 453 }, { "type": "Label", "props": { "y": 318, "x": 623, "var": "lab_tankSpeed", "valign": "middle", "text": "24Km/h", "overflow": "hidden", "fontSize": 25, "color": "#00ff28", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 454 }, { "type": "Sprite", "props": { "y": -19, "x": 179, "texture": "battle/img_battle_jiuxu1.png" }, "compId": 455 }, { "type": "Image", "props": { "y": -1, "x": 179, "var": "lab_tankState", "skin": "battle/img_battle_jiuxu.png", "scaleY": 0.6, "scaleX": 0.6 }, "compId": 456 }, { "type": "Image", "props": { "y": 300, "x": 8, "skin": "battle/img_battle_wuqi.png" }, "compId": 457 }, { "type": "Label", "props": { "y": 316, "x": 80, "width": 130, "valign": "middle", "text": "高级坦克炮", "overflow": "hidden", "height": 29, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 458 }, { "type": "Image", "props": { "y": 317, "x": 719, "skin": "battle/img_battle_huanPao.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 459 }] }] }, { "type": "Box", "props": { "y": 100, "x": 0, "var": "gunShowBox", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 96 }, "compId": 437, "child": [{ "type": "Box", "props": { "y": 0, "width": 589, "height": 116, "centerX": 0 }, "compId": 460, "child": [{ "type": "Button", "props": { "y": 48, "x": 60, "width": 97, "var": "btn_changeGun1", "stateNum": 1, "skin": "battle/btn_huanwuqi_2.png", "height": 79, "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.01 }, "compId": 461 }, { "type": "Button", "props": { "y": 48, "x": 548, "width": 138, "var": "btn_changeGun", "stateNum": 1, "skin": "battle/btn_huanwuqi_2.png", "height": 81, "anchorY": 0.5, "anchorX": 0.5, "alpha": 0.01 }, "compId": 462 }, { "type": "Image", "props": { "y": 47, "x": 556, "var": "img_gun0", "skin": "icon/100302.png", "skewY": 0, "scaleY": 0.5, "scaleX": 0.5, "mouseEnabled": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 463 }, { "type": "Image", "props": { "y": 48, "x": 74, "var": "img_gun1", "skin": "icon/100101.png", "skewX": 0, "scaleY": 0.3, "scaleX": 0.3, "mouseEnabled": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 464 }, { "type": "Label", "props": { "y": 77, "x": 513, "var": "gunCnt0", "valign": "middle", "text": "30", "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 465 }, { "type": "Label", "props": { "y": 80, "x": 523, "var": "magazineCnt0", "valign": "middle", "text": "90", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 466 }, { "type": "Label", "props": { "y": 73, "x": 40, "width": 26.6953125, "var": "gunCnt1", "valign": "middle", "text": "8", "height": 24, "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 467 }, { "type": "Label", "props": { "y": 80, "x": 48, "var": "magazineCnt1", "valign": "middle", "text": "32", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 468 }, { "type": "Label", "props": { "y": 78, "x": 653, "width": 33, "var": "lab_bombCnt", "valign": "middle", "text": "3", "height": 12, "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 469 }, { "type": "Image", "props": { "y": 6, "x": 641, "skin": "battle/img_battle_touzhi_0.png", "scaleY": 1.5, "scaleX": 1.5 }, "compId": 470 }, { "type": "Image", "props": { "y": 51, "x": 686, "width": 256, "var": "img_bomb", "skin": "icon/101201.png", "scaleY": 0.3, "scaleX": 0.3, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 471 }, { "type": "Button", "props": { "y": 23, "x": 705, "width": 57, "visible": true, "var": "btn_useBomb", "stateNum": 1, "skin": "battle/btn_huanwuqi_2.png", "skewX": 0, "scaleX": 1, "height": 57, "anchorX": 1, "alpha": 0 }, "compId": 472 }, { "type": "Image", "props": { "y": 48, "x": 793, "var": "btn_switch", "skin": "battle/img_battle_huDan.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 473 }, { "type": "Image", "props": { "y": 6, "x": 478, "skin": "battle/img_battle_zuwuqiBg_1.png" }, "compId": 474 }, { "type": "Image", "props": { "y": 3.5, "x": 8, "skin": "battle/img_battle_fuwuqiBg_0.png" }, "compId": 475 }, { "type": "Image", "props": { "y": -305, "x": 262, "visible": false, "var": "img_time1", "skin": "battle/img_battle_daojiShi1.png" }, "compId": 476, "child": [{ "type": "Label", "props": { "y": 30, "x": 83, "width": 68, "visible": false, "var": "lab_tips2", "valign": "middle", "text": "6秒", "overflow": "visible", "height": 30, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 477 }] }, { "type": "Image", "props": { "y": -167, "x": 265, "visible": false, "var": "img_time2", "skin": "battle/img_battle_daojiShi.png" }, "compId": 478, "child": [{ "type": "Label", "props": { "y": 29, "x": 28, "width": 68, "visible": true, "var": "lab_tips", "valign": "middle", "text": "2.4秒", "overflow": "visible", "height": 30, "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 479 }] }] }, { "type": "Box", "props": { "y": -394, "x": 494, "width": 470, "visible": false, "var": "pickUpBox", "height": 405 }, "compId": 480, "child": [{ "type": "List", "props": { "y": 59, "x": 244, "width": 188, "visible": false, "var": "airdropLIst", "spaceY": 0, "height": 340 }, "compId": 481, "child": [{ "type": "Box", "props": { "width": 188, "name": "render", "height": 115 }, "compId": 482, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 188, "skin": "battle/img_battle_shiqU.png", "height": 115 }, "compId": 483 }, { "type": "Image", "props": { "y": 57.5, "x": 94, "width": 300, "skin": "icon/100205.png", "scaleY": 0.5, "scaleX": 0.5, "pivotY": 85, "pivotX": 150, "name": "img_icon", "height": 170 }, "compId": 484 }, { "type": "Label", "props": { "y": 85, "x": 94, "valign": "middle", "text": "AK-47", "name": "lab_name", "fontSize": 20, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 485 }] }] }, { "type": "Image", "props": { "y": -5, "x": 2, "var": "airBoxBox", "skin": "airBox/img_battle_airbg1.png" }, "compId": 486, "child": [{ "type": "Image", "props": { "y": 215, "x": 133, "var": "btn_airBox", "skin": "airBox/img_battle_airOpen.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 487, "child": [{ "type": "Label", "props": { "y": 43, "x": 146, "valign": "middle", "text": "打开", "fontSize": 35, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 488 }] }] }] }, { "type": "Button", "props": { "y": -160, "x": 886, "var": "btn_aim", "stateNum": 1, "skin": "battle/btn_jiantou_3.png", "scaleY": 2, "scaleX": 2, "right": 23 }, "compId": 489 }] }, { "type": "Box", "props": { "y": 121, "centerX": 0 }, "compId": 438, "child": [{ "type": "Sprite", "props": { "y": 25, "x": 1, "width": 350, "var": "sp_blood", "height": 26 }, "compId": 490 }, { "type": "Sprite", "props": { "y": 25, "x": 1, "width": 350, "var": "sp_hpMask", "height": 26 }, "compId": 491 }, { "type": "Sprite", "props": { "y": 58, "x": 1, "texture": "battle/im_battle_nengLi.png" }, "compId": 492 }, { "type": "Image", "props": { "skin": "battle/img_battle_huJia.png" }, "compId": 493 }] }] }, { "type": "Box", "props": { "width": 116, "visible": false, "var": "fireBox", "name": "fireBox", "mouseThrough": true, "left": 71, "height": 116, "centerY": -36, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 142, "child": [{ "type": "Button", "props": { "y": 58, "x": 58, "var": "btn_fire", "stateNum": 1, "skin": "battle/btn_zuocesheji.png", "scaleY": 1.5, "scaleX": 1.5, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 145 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 288, "visible": false, "var": "optionBtns", "right": 70, "name": "optionBtns", "mouseThrough": false, "height": 198, "centerY": -58, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 327, "child": [{ "type": "Button", "props": { "y": 4, "x": 94, "visible": false, "stateNum": 1, "skin": "battle/btn_jiantou_1.png" }, "compId": 328 }, { "type": "Button", "props": { "y": 54, "x": 195, "visible": false, "var": "btn_veh", "stateNum": 1, "skin": "battle/btn_jiantou_2.png" }, "compId": 329 }, { "type": "Button", "props": { "y": 107, "x": 92, "visible": false, "var": "btn_vehAttack", "stateNum": 1, "skin": "battle/btn_jiantou_5.png" }, "compId": 331 }] }] }, { "type": "Box", "props": { "var": "guideBox", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 199, "child": [{ "type": "Box", "props": { "visible": false, "var": "bg", "top": 0, "right": 0, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 262, "child": [{ "type": "Label", "props": { "y": 683, "x": 667, "var": "clickTxt", "text": "点击屏幕任意区域继续", "fontSize": 34, "color": "#ffffff", "centerX": 0, "bottom": 50, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 259 }] }, { "type": "Box", "props": { "width": 382, "visible": false, "var": "tip", "top": 50, "height": 59, "centerX": 0 }, "compId": 253, "child": [{ "type": "Image", "props": { "skin": "guide/guide_tipBg.png" }, "compId": 255 }, { "type": "Label", "props": { "y": 349, "x": 485, "var": "tipTxt", "text": "任务1：查看周围", "fontSize": 26, "color": "#FFFFFF", "centerY": 0, "centerX": 0 }, "compId": 254 }, { "type": "Label", "props": { "y": 68, "var": "progressTxt", "text": "任务进度:10%", "height": 20, "fontSize": 20, "color": "#ffffff", "centerX": 0 }, "compId": 360 }] }, { "type": "Box", "props": { "visible": false, "var": "guideBox_001", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 237, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "var": "guide", "mouseEnabled": true, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 378, "child": [{ "type": "Image", "props": { "var": "guide_001", "skin": "guide/guide_dialog_bg.png", "scaleY": 2, "scaleX": 2, "centerY": -74, "centerX": -156 }, "compId": 379, "child": [{ "type": "Rect", "props": { "y": 201, "x": 0, "width": 100, "renderType": "hit", "lineWidth": 1, "height": 29, "fillColor": "#ff0000" }, "compId": 380 }] }, { "type": "Image", "props": { "y": 67, "x": 197, "width": 636, "skin": "guide/guide_dialog.png", "sizeGrid": "155,100,140,100", "height": 407 }, "compId": 381 }, { "type": "Image", "props": { "x": 638, "skin": "guide/women.png", "scaleY": 2, "scaleX": 2, "bottom": 0 }, "compId": 382 }, { "type": "Text", "props": { "y": 218, "x": 257, "wordWrap": true, "width": 508, "var": "guideTxt_001", "valign": "middle", "text": "      即将开始新手训练！", "height": 126, "fontSize": 36, "color": "#ffffff", "align": "center", "runtime": "Laya.Text" }, "compId": 383 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_002", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 239 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_003", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 251, "child": [{ "type": "Image", "props": { "width": 220, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "left": 134, "bottom": 380 }, "compId": 376, "child": [{ "type": "Label", "props": { "y": 22, "text": "拖动轮盘行走", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 377 }] }] }, { "type": "Box", "props": { "visible": false, "var": "guideBox_004", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 257, "child": [{ "type": "Image", "props": { "y": 200, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "centerX": 0 }, "compId": 260, "child": [{ "type": "Label", "props": { "y": 22, "text": "这里是视野中心", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 261 }] }] }, { "type": "Box", "props": { "visible": false, "var": "guideBox_005", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 245, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "var": "flashing", "top": 0, "skin": "guide/guide_mask.png", "sizeGrid": "30,30,30,30", "right": 0, "left": 0, "bottom": 0 }, "compId": 363 }, { "type": "Image", "props": { "skin": "guide/guide_handAim.png", "right": 25, "bottom": 30 }, "compId": 263 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_006", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 271 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_007", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 274 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_008", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 275, "child": [{ "type": "Image", "props": { "y": 200, "x": 0, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "centerX": 0 }, "compId": 358, "child": [{ "type": "Label", "props": { "y": 22, "text": "升降梯上升中", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 359 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_009", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 276, "child": [{ "type": "Box", "props": { "width": 100, "rotation": 180, "height": 100, "centerX": 306, "bottom": -22 }, "compId": 320 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_010", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 284, "child": [{ "type": "Box", "props": { "width": 100, "rotation": 90, "right": 20, "height": 100, "bottom": 325 }, "compId": 354 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_011", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 278 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_012", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 279, "child": [{ "type": "Box", "props": { "width": 100, "rotation": -90, "left": 129, "height": 100, "centerY": 13 }, "compId": 356 }, { "type": "Image", "props": { "y": 174, "width": 160, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "left": 143 }, "compId": 340, "child": [{ "type": "Label", "props": { "y": 22, "text": "点击开火", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 341 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_013", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 280, "child": [{ "type": "Box", "props": { "y": 260, "x": 1114, "width": 100, "rotation": 90, "right": 120, "height": 100, "bottom": 390 }, "compId": 352 }, { "type": "Image", "props": { "y": 131, "x": 1029, "width": 160, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "right": 145, "centerY": -205 }, "compId": 344, "child": [{ "type": "Label", "props": { "y": 22, "text": "点击换弹", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 345 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_014", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 281, "child": [{ "type": "Box", "props": { "y": 305, "x": 1019, "width": 100, "rotation": 90, "right": 215, "height": 100, "bottom": 345 }, "compId": 346 }, { "type": "Image", "props": { "y": 166, "x": 939, "width": 160, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "right": 235, "centerY": -170 }, "compId": 322, "child": [{ "type": "Label", "props": { "y": 22, "text": "点击瞄准", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 323 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_015", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 282, "child": [{ "type": "Box", "props": { "y": 630, "x": 972, "width": 100, "rotation": 135, "height": 100, "centerX": 355, "bottom": 20 }, "compId": 350 }, { "type": "Image", "props": { "y": 492, "x": 907, "width": 160, "skin": "guide/guide_tip.png", "sizeGrid": "35,40,35,40", "centerX": 320, "bottom": 180 }, "compId": 342, "child": [{ "type": "Label", "props": { "y": 22, "text": "点击手雷", "fontSize": 32, "color": "#FFFFFF", "centerX": 0 }, "compId": 343 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_016", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 283 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_017", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 285 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_018", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 277 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_019", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 286 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_020", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 287 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_021", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 288 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "guideBox_022", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 289 }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "completeBox", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 364, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "mouseEnabled": true, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 384, "child": [{ "type": "Image", "props": { "var": "complete", "skin": "guide/guide_dialog_bg.png", "scaleY": 2, "scaleX": 2, "centerY": -74, "centerX": -156 }, "compId": 385, "child": [{ "type": "Rect", "props": { "y": 201, "x": 0, "width": 100, "renderType": "hit", "lineWidth": 1, "height": 29, "fillColor": "#ff0000" }, "compId": 386 }] }, { "type": "Image", "props": { "y": 67, "x": 197, "width": 636, "skin": "guide/guide_dialog.png", "sizeGrid": "155,100,140,100", "height": 407 }, "compId": 387 }, { "type": "Image", "props": { "x": 638, "skin": "guide/women.png", "scaleY": 2, "scaleX": 2, "bottom": 0 }, "compId": 388 }, { "type": "Text", "props": { "y": 218, "x": 257, "wordWrap": true, "width": 508, "var": "completeTxt", "valign": "middle", "text": "即将开始新手训练！", "height": 126, "fontSize": 36, "color": "#ffffff", "align": "center", "runtime": "Laya.Text" }, "compId": 389 }] }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": true, "var": "encourageBox", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 368, "child": [{ "type": "Label", "props": { "y": 350, "var": "encourageTxt", "text": "你真棒1", "fontSize": 26, "color": "#ffffff", "centerX": 0, "alpha": 0 }, "compId": 375 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": true, "var": "slideBox", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 273, "child": [{ "type": "Box", "props": { "width": 100, "visible": false, "var": "rightAni", "rotation": 90, "height": 100, "centerY": 0, "centerX": 200 }, "compId": 316, "child": [{ "type": "Label", "props": { "y": 35, "x": -120, "text": "向右滑动屏幕", "rotation": -90, "fontSize": 24, "color": "#ffffff" }, "compId": 324 }] }, { "type": "Box", "props": { "width": 100, "visible": false, "var": "leftAni", "rotation": 270, "height": 100, "centerY": 0, "centerX": -100 }, "compId": 317, "child": [{ "type": "Label", "props": { "y": -105, "x": 120, "text": "向左滑动屏幕", "rotation": 90, "fontSize": 24, "color": "#ffffff" }, "compId": 326 }] }] }, { "type": "Box", "props": { "var": "aimTip", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 266, "child": [{ "type": "Image", "props": { "y": 399, "x": 474, "visible": false, "skin": "guide/aim_tip.png" }, "compId": 267 }, { "type": "Image", "props": { "y": 0, "x": 0, "visible": false, "skin": "guide/aim_tip.png" }, "compId": 268 }, { "type": "Image", "props": { "y": 0, "x": 0, "visible": false, "skin": "guide/aim_tip.png" }, "compId": 269 }] }, { "type": "Box", "props": { "y": 0, "x": 0, "visible": false, "var": "tipFire", "top": 0, "right": 0, "mouseEnabled": false, "left": 0, "bottom": 0 }, "compId": 309, "child": [{ "type": "Text", "props": { "y": 375, "x": 1017, "visible": true, "text": "点击开火按钮", "runtime": "laya.display.Text", "fontSize": 32, "color": "#ffffff" }, "compId": 301 }, { "type": "Box", "props": { "width": 100, "rotation": 135, "right": 130, "height": 100, "bottom": 130 }, "compId": 321 }] }, { "type": "Box", "props": { "visible": false, "var": "tipAim", "top": -132, "right": 0, "mouseEnabled": false, "left": -47, "bottom": 0 }, "compId": 305, "child": [{ "type": "Image", "props": { "skin": "guide/guide_handAim.png", "right": 25, "bottom": 30 }, "compId": 314 }] }] }, { "type": "Button", "props": { "y": 20, "x": 20, "var": "btn_skip", "top": 20, "stateNum": 1, "skin": "common/img_red.png", "sizeGrid": "0,5,0,24", "left": 20 }, "compId": 243 }], "loadList": ["battle/bg_zhunxin_1.png", "battle/bg_zhunxin_2.png", "battle/bg_zhunxin_zhishengji_1.png", "battle/bg_zhunxin_zhishengji_2.png", "battle/img_hit1.png", "battle/img_enemyPoint.png", "resource/battle/bg_kaijing.png", "battle/img_battle_xiaChe.png", "battle/img_battle_air0.png", "battle/img_battle_tank.png", "battle/img_battle_air1.png", "battle/img_battle_tank2.png", "battle/img_battle_tank1.png", "battle/img_battle_forward.png", "battle/Veh_body.png", "battle/Veh_aim.png", "battle/img_battle_jiuxu1.png", "battle/img_battle_jiuxu.png", "battle/img_battle_wuqi.png", "battle/img_battle_huanPao.png", "battle/btn_huanwuqi_2.png", "icon/100302.png", "icon/100101.png", "battle/img_battle_touzhi_0.png", "icon/101201.png", "battle/img_battle_huDan.png", "battle/img_battle_zuwuqiBg_1.png", "battle/img_battle_fuwuqiBg_0.png", "battle/img_battle_daojiShi1.png", "battle/img_battle_daojiShi.png", "battle/img_battle_shiqU.png", "icon/100205.png", "airBox/img_battle_airbg1.png", "airBox/img_battle_airOpen.png", "battle/btn_jiantou_3.png", "battle/im_battle_nengLi.png", "battle/img_battle_huJia.png", "battle/btn_zuocesheji.png", "battle/btn_jiantou_1.png", "battle/btn_jiantou_2.png", "battle/btn_jiantou_5.png", "guide/guide_tipBg.png", "guide/guide_dialog_bg.png", "guide/guide_dialog.png", "guide/women.png", "guide/guide_tip.png", "guide/guide_mask.png", "guide/guide_handAim.png", "guide/aim_tip.png", "common/img_red.png"], "loadList3D": [] };
          view.GuideSceneUI = GuideSceneUI;
          REG("ui.view.GuideSceneUI", GuideSceneUI);
          class GuideShopBoxUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(GuideShopBoxUI.uiView);
              }
          }
          GuideShopBoxUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 171, "x": 348, "width": 638, "height": 408, "centerY": 0, "centerX": 0 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 16, "x": -581, "width": 1800, "skin": "resource/game/bg_revive.png" }, "compId": 44 }, { "type": "Label", "props": { "y": 34, "x": 318, "valign": "middle", "text": "恭喜获得黄金宝箱", "fontSize": 50, "color": "#ffff00", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 41 }, { "type": "Image", "props": { "y": 91, "x": 222, "skin": "openBox/xuangkuang.png", "scaleY": 2.1, "scaleX": 2.1 }, "compId": 40 }, { "type": "Button", "props": { "y": 339, "x": 319, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 38, "child": [{ "type": "Label", "props": { "y": 28, "x": 30, "valign": "middle", "text": "立即打开", "fontSize": 40, "color": "#ffffff", "align": "center" }, "compId": 39 }] }, { "type": "Image", "props": { "y": 183, "x": 318, "skin": "icon/treasureBox_1.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 45 }] }], "loadList": ["resource/game/bg_revive.png", "openBox/xuangkuang.png", "comp/lingquanniu.png", "icon/treasureBox_1.png"], "loadList3D": [] };
          view.GuideShopBoxUI = GuideShopBoxUI;
          REG("ui.view.GuideShopBoxUI", GuideShopBoxUI);
          class HitRockerUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(HitRockerUI.uiView);
              }
          }
          HitRockerUI.uiView = { "type": "UIBaseView", "props": { "width": 200, "runtime": "", "height": 200 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 200, "skin": "battle/img_battle_left_hti.png", "height": 200 }, "compId": 3 }, { "type": "Image", "props": { "y": 10, "x": 10, "width": 180, "skin": "battle/img_battle_left_hti1.png", "height": 180 }, "compId": 10 }, { "type": "Image", "props": { "y": 100, "x": 100, "var": "knob", "skin": "battle/img_battle_xingZou.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }, { "type": "Image", "props": { "y": 80, "x": 80, "skin": "battle/img_battle_left_hti3.png", "scaleY": 0.8, "scaleX": 0.8 }, "compId": 18 }], "loadList": ["battle/img_battle_left_hti.png", "battle/img_battle_left_hti1.png", "battle/img_battle_xingZou.png", "battle/img_battle_left_hti3.png"], "loadList3D": [] };
          view.HitRockerUI = HitRockerUI;
          REG("ui.view.HitRockerUI", HitRockerUI);
          class HomeViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(HomeViewUI.uiView);
              }
          }
          HomeViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "visible": false, "var": "homeBox", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 154, "child": [{ "type": "Image", "props": { "y": -1, "x": -158, "width": 1800, "skin": "resource/home/hall_background.png", "centerY": 0, "centerX": 0 }, "compId": 11 }, { "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "resource/home/hall_Mask.png", "sizeGrid": "20,20,20,20", "right": 0, "left": 0, "bottom": 0, "alpha": 0.5 }, "compId": 152 }, { "type": "Box", "props": { "y": 375, "x": 667, "width": 1334, "var": "middleBox", "mouseThrough": true, "height": 750, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 23, "child": [{ "type": "Image", "props": { "y": 469, "x": 880, "var": "btn_arsenal", "skin": "home/hall_zhuangbeiku.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 120 }, { "type": "Image", "props": { "y": 469, "x": 1156, "var": "btn_shop", "skin": "home/hall_junxuchu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 118 }, { "type": "Image", "props": { "y": 1022, "x": 1462, "visible": false, "var": "btn_houseBag", "skin": "home/hall_cangku.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 117 }, { "type": "Image", "props": { "y": 624, "x": 1156, "var": "btn_recognition", "skin": "home/hall_biaozhangzhongxin.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 119 }, { "type": "Sprite", "props": { "y": 381, "x": 724.5, "texture": "home/bianjiaokuang.png" }, "compId": 173 }, { "type": "Sprite", "props": { "y": 712, "x": 1312, "texture": "home/bianjiaokuang.png", "rotation": -180 }, "compId": 174 }, { "type": "Image", "props": { "y": 252, "x": 1019, "width": 588, "var": "imgStart", "skin": "resource/home/hall_qianwangzhanchang.png", "height": 234, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 100 }, { "type": "Image", "props": { "y": 38, "x": 753, "skin": "comp/hall_gengxun.png", "gray": true }, "compId": 107 }, { "type": "Image", "props": { "y": 37, "x": 1002, "skin": "comp/hall_gengxun.png", "anchorY": 0, "anchorX": 0 }, "compId": 109 }, { "type": "Image", "props": { "y": 33, "x": 736, "skin": "comp/icon_ticket.png", "scaleY": 1, "scaleX": 1 }, "compId": 140 }, { "type": "Image", "props": { "y": 36, "x": 983, "skin": "comp/icon_xunzhang.png", "scaleY": 1, "scaleX": 1 }, "compId": 139 }, { "type": "FontClip", "props": { "y": 54, "x": 1194, "var": "lab_coin", "value": "0", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "anchorX": 1, "align": "right" }, "compId": 151 }, { "type": "FontClip", "props": { "y": 54, "x": 958, "width": 202, "var": "lab_diamond", "value": "0", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "height": 40, "anchorX": 1, "align": "right" }, "compId": 150 }, { "type": "Box", "props": { "y": 25, "x": 432, "width": 240, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 700 }, "compId": 121 }, { "type": "Image", "props": { "y": 94, "x": 681, "visible": false, "var": "btn_customer", "skin": "home/lianxikefu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 200 }, { "type": "Image", "props": { "y": 94, "x": 681, "visible": false, "var": "btn_qq_bonus", "skin": "side/qq/1.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 201 }] }, { "type": "Image", "props": { "top": 39, "skin": "home/hall_touxiangkuangxinxi.png", "left": -3 }, "compId": 101, "child": [{ "type": "Image", "props": { "y": 116, "x": 59, "width": 110, "var": "headIcon", "skin": "professionIcon/Role_Assaulter.png", "height": 110, "anchorY": 1, "anchorX": 0.5 }, "compId": 102, "child": [{ "type": "Image", "props": { "y": 110, "x": 56, "width": 110, "renderType": "mask", "height": 110, "anchorY": 1, "anchorX": 0.5 }, "compId": 141, "child": [{ "type": "Poly", "props": { "points": "8,55,55,7,101,55,54,100", "lineWidth": 1, "lineColor": "#ff0000", "fillColor": "#00ffff" }, "compId": 162 }] }] }, { "type": "Label", "props": { "y": 65, "x": 114, "var": "userName", "text": "普通玩家", "skewY": 0, "fontSize": 28, "color": "#ffffff" }, "compId": 113 }, { "type": "Label", "props": { "y": 34, "x": 114, "var": "prefession", "text": "Lv. 1", "skewY": 0, "fontSize": 28, "color": "#ffffff" }, "compId": 112 }] }, { "type": "Image", "props": { "skin": "resource/home/hall_frame.png", "left": 0, "bottom": 7 }, "compId": 161, "child": [{ "type": "Image", "props": { "y": 36, "x": 113, "var": "imgSign", "skin": "home/weixuanzhongkuang.png", "gray": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 133, "child": [{ "type": "Label", "props": { "y": 35, "x": 72, "text": "签到", "fontSize": 35, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 176 }] }, { "type": "Image", "props": { "y": 36, "x": 291, "var": "imgTurntable", "skin": "home/weixuanzhongkuang.png", "gray": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 134, "child": [{ "type": "Label", "props": { "y": 35, "x": 72, "text": "抽奖", "fontSize": 35, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 177 }] }, { "type": "Image", "props": { "y": 36, "x": 468, "var": "imgWish", "skin": "home/weixuanzhongkuang.png", "gray": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 135, "child": [{ "type": "Label", "props": { "y": 34, "x": 71, "text": "许愿池", "fontSize": 31, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 178 }] }, { "type": "Image", "props": { "y": 36, "x": 113, "visible": false, "var": "imgSign1", "skin": "home/xuanzhongkuang.png", "gray": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 183, "child": [{ "type": "Label", "props": { "text": "签到", "fontSize": 35, "color": "#ffffff", "centerY": 0, "centerX": 0, "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 186 }] }, { "type": "Image", "props": { "y": 36, "x": 291, "visible": false, "var": "imgTurntable1", "skin": "home/xuanzhongkuang.png", "gray": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 184, "child": [{ "type": "Label", "props": { "text": "抽奖", "fontSize": 35, "color": "#ffffff", "centerY": 0, "centerX": 0, "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 187 }] }, { "type": "Image", "props": { "y": 36, "x": 468, "visible": false, "var": "imgWish1", "skin": "home/xuanzhongkuang.png", "gray": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 185, "child": [{ "type": "Label", "props": { "text": "许愿池", "fontSize": 31, "color": "#ffffff", "centerY": 0, "centerX": 0, "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 188 }] }] }, { "type": "Image", "props": { "y": 237, "visible": false, "skin": "home/hall_renwujiesuo.png", "left": 0 }, "compId": 105, "child": [{ "type": "Label", "props": { "y": 20, "x": 28, "visible": false, "text": "下一个奖励：", "skewY": 0, "fontSize": 30, "color": "#ffffff" }, "compId": 130 }, { "type": "Label", "props": { "y": 63, "x": 28, "visible": false, "text": "200/1000", "skewY": 0, "fontSize": 30, "color": "#ffffff" }, "compId": 131 }, { "type": "Label", "props": { "y": 106, "x": 28, "visible": false, "text": "生涯经验", "skewY": 0, "fontSize": 30, "color": "#ffffff" }, "compId": 132 }] }, { "type": "Box", "props": { "y": 573, "width": 204, "var": "volumeBox", "left": 10, "height": 170, "bottom": 92, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 167, "child": [{ "type": "Image", "props": { "y": 136, "x": 157, "var": "btn_volume", "skin": "comp/icon_ad.png", "gray": false, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 164 }, { "type": "Label", "props": { "y": 81, "x": 125, "width": 55, "var": "lab_volumeNum", "text": "+", "height": 24, "fontSize": 24, "font": "Arial", "color": "#ffffff", "bold": true, "align": "center" }, "compId": 166, "child": [{ "type": "FontClip", "props": { "y": 0, "x": 40, "visible": false, "var": "fontVolumeNum", "value": "150", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.5, "scaleX": 0.5 }, "compId": 197 }] }] }, { "type": "Image", "props": { "visible": false, "var": "btn_share", "top": 110, "skin": "xIndex/fenxiangyouli.png", "left": -534, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 193 }, { "type": "Image", "props": { "visible": false, "var": "moreGame", "top": -144, "skin": "side/op/gengduoyouxi.png", "right": -124, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 202 }, { "type": "Image", "props": { "y": -850, "x": 454, "visible": false, "var": "xxxx", "skin": "common/img_battle_fuhuo.png" }, "compId": 204 }] }], "loadList": ["resource/home/hall_background.png", "resource/home/hall_Mask.png", "home/hall_zhuangbeiku.png", "home/hall_junxuchu.png", "home/hall_cangku.png", "home/hall_biaozhangzhongxin.png", "home/bianjiaokuang.png", "resource/home/hall_qianwangzhanchang.png", "comp/hall_gengxun.png", "comp/icon_ticket.png", "comp/icon_xunzhang.png", "common/clip_white.png", "home/lianxikefu.png", "side/qq/1.png", "home/hall_touxiangkuangxinxi.png", "professionIcon/Role_Assaulter.png", "resource/home/hall_frame.png", "home/weixuanzhongkuang.png", "home/xuanzhongkuang.png", "home/hall_renwujiesuo.png", "comp/icon_ad.png", "xIndex/fenxiangyouli.png", "side/op/gengduoyouxi.png", "common/img_battle_fuhuo.png"], "loadList3D": [] };
          view.HomeViewUI = HomeViewUI;
          REG("ui.view.HomeViewUI", HomeViewUI);
          class HouseBagViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(HouseBagViewUI.uiView);
              }
          }
          HouseBagViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 30 }, { "type": "Box", "props": { "width": 1334, "var": "houseBag", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 4, "child": [{ "type": "Image", "props": { "y": 137, "x": 36, "width": 1256, "skin": "houseBag/bg.png", "sizeGrid": "5,5,5,5", "height": 555 }, "compId": 8 }, { "type": "List", "props": { "y": 189, "x": 100, "width": 1192, "var": "list", "spaceX": 45, "repeatY": 1, "repeatX": 4, "height": 460, "elasticEnabled": true }, "compId": 10, "child": [{ "type": "HouseBagItem", "props": { "var": "HouseBagItem", "runtime": "script/ui/HouseBagItem.ts" }, "compId": 36 }] }] }, { "type": "Box", "props": { "visible": false, "var": "award", "top": 0, "right": 0, "left": 0, "bottom": 0 }, "compId": 18, "child": [{ "type": "Image", "props": { "top": 0, "skin": "houseBag/mask.png", "sizeGrid": "5,5,5,5", "right": 0, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 20 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 32, "child": [{ "type": "Image", "props": { "y": 23, "x": 0, "skin": "resource/houseBag/frame.png" }, "compId": 21 }, { "type": "Image", "props": { "y": 260, "x": 549, "skin": "houseBag/bg_award.png" }, "compId": 22 }, { "type": "Image", "props": { "y": 642, "x": 669, "var": "btn_confirm", "skin": "comp/btn_confirm.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 23 }, { "type": "Image", "props": { "y": 369, "x": 669, "width": 130, "var": "awardIcon", "height": 130, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 26 }, { "type": "Label", "props": { "y": 628, "x": 627, "width": 89, "text": "确 定", "height": 36, "fontSize": 37, "font": "Microsoft YaHei", "color": "#ffffff", "bold": true }, "compId": 24 }, { "type": "Label", "props": { "y": 524, "x": 666, "var": "awardName", "text": "98K", "fontSize": 35, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 25 }, { "type": "Label", "props": { "y": 443, "x": 750, "var": "awardNum", "text": "awardNum", "fontSize": 24, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 1 }, "compId": 31 }] }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 34, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 35 }] }], "loadList": ["resource/comp/bg.png", "houseBag/bg.png", "houseBag/mask.png", "resource/houseBag/frame.png", "houseBag/bg_award.png", "comp/btn_confirm.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.HouseBagViewUI = HouseBagViewUI;
          REG("ui.view.HouseBagViewUI", HouseBagViewUI);
          class LoadingUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(LoadingUI.uiView);
              }
          }
          LoadingUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 1334, "runtime": "script/ui/LoadingUI.ts", "mouseThrough": false, "mouseEnabled": true, "height": 750, "drawCallOptimize": true, "centerY": 0, "centerX": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "width": 1900, "skin": "loading/loading.jpg", "height": 750, "centerX": 0 }, "compId": 20 }, { "type": "Label", "props": { "y": 596, "x": 305, "width": 723, "var": "txt", "text": "游戏加载中...", "styleSkin": "", "strokeColor": "#413b33", "stroke": 4, "fontSize": 32, "color": "#ffffff", "align": "center" }, "compId": 6 }, { "type": "Image", "props": { "y": 630, "x": 167, "skin": "loading/loading_progress.png" }, "compId": 25 }, { "type": "Image", "props": { "y": 639, "x": 167, "width": 0, "var": "bar", "skin": "loading/bg_loading_tiao_2.png", "height": 31 }, "compId": 30 }, { "type": "Image", "props": { "y": 630, "x": 127, "var": "bar1", "skin": "loading/bg_loading_tiao_1.png" }, "compId": 31 }, { "type": "Image", "props": { "y": 669, "x": 182, "var": "imgLight", "skin": "loading/icon_gun.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22 }], "loadList": ["loading/loading.jpg", "loading/logo_toywar.png", "loading/loading_progress.png", "loading/bg_loading_tiao_2.png", "loading/bg_loading_tiao_1.png", "loading/icon_gun.png"], "loadList3D": [] };
          view.LoadingUI = LoadingUI;
          REG("ui.view.LoadingUI", LoadingUI);
          class LogoViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(LogoViewUI.uiView);
              }
          }
          LogoViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 1334, "runtime": "", "mouseThrough": false, "mouseEnabled": true, "height": 750, "drawCallOptimize": true, "centerY": 0, "centerX": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "var": "img_logo", "skin": "loading/ComLogo.jpg", "centerY": 0, "centerX": 0, "alpha": 0 }, "compId": 33 }], "loadList": ["loading/ComLogo.jpg"], "loadList3D": [] };
          view.LogoViewUI = LogoViewUI;
          REG("ui.view.LogoViewUI", LogoViewUI);
          class MathcingViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(MathcingViewUI.uiView);
              }
          }
          MathcingViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 21 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 23, "child": [{ "type": "Image", "props": { "y": 40, "x": 0, "top": 40, "skin": "matching/bg.png", "sizeGrid": "5,5,5,5", "right": 0, "left": 0, "bottom": 40 }, "compId": 4, "child": [{ "type": "List", "props": { "y": 73, "width": 855, "var": "list", "spaceY": 10, "spaceX": 20, "scaleY": 1.2, "scaleX": 1.2, "repeatY": 2, "repeatX": 8, "height": 189, "centerX": 0 }, "compId": 5, "child": [{ "type": "Box", "props": { "width": 89, "name": "render", "height": 89 }, "compId": 6, "child": [{ "type": "Image", "props": { "skin": "matching/shenlanse2.png", "sizeGrid": "5,5,5,5" }, "compId": 7 }, { "type": "Image", "props": { "y": 10, "x": 10, "skin": "matching/wenhao.png", "name": "imgQuestion" }, "compId": 8 }, { "type": "Image", "props": { "y": 11, "x": 11, "width": 70, "name": "imgHead", "height": 70 }, "compId": 9 }] }] }, { "type": "List", "props": { "y": 405, "width": 855, "var": "list2", "spaceY": 10, "spaceX": 20, "scaleY": 1.2, "scaleX": 1.2, "repeatY": 2, "repeatX": 8, "height": 189, "centerX": 0 }, "compId": 11, "child": [{ "type": "Box", "props": { "width": 89, "name": "render", "height": 89 }, "compId": 12, "child": [{ "type": "Image", "props": { "skin": "matching/shenlanse2.png", "sizeGrid": "5,5,5,5" }, "compId": 13 }, { "type": "Image", "props": { "y": 10, "x": 10, "skin": "matching/wenhao.png", "name": "imgQuestion" }, "compId": 14 }, { "type": "Image", "props": { "y": 11, "x": 11, "width": 70, "name": "imgHead", "height": 70 }, "compId": 15 }] }] }, { "type": "Image", "props": { "skin": "resource/matching/VS_effect.png", "centerY": 0, "centerX": 0 }, "compId": 17 }, { "type": "Image", "props": { "y": 311, "skin": "matching/VS.png", "scaleY": 0.8, "scaleX": 0.8, "centerX": -1 }, "compId": 16 }, { "type": "Image", "props": { "y": -35, "skin": "resource/matching/word_1.png", "centerX": 0 }, "compId": 18 }, { "type": "Label", "props": { "y": -11, "x": 783, "var": "point", "text": "...", "fontSize": 70, "color": "#ffffff", "bold": true }, "compId": 20 }] }] }], "loadList": ["resource/comp/bg.png", "matching/bg.png", "matching/shenlanse2.png", "matching/wenhao.png", "resource/matching/VS_effect.png", "matching/VS.png", "resource/matching/word_1.png"], "loadList3D": [] };
          view.MathcingViewUI = MathcingViewUI;
          REG("ui.view.MathcingViewUI", MathcingViewUI);
          class OneBtnTipsUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(OneBtnTipsUI.uiView);
              }
          }
          OneBtnTipsUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 600, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 300, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Label", "props": { "valign": "middle", "text": "确认", "fontSize": 30, "align": "center" }, "compId": 35 }], "loadList": [], "loadList3D": [] };
          view.OneBtnTipsUI = OneBtnTipsUI;
          REG("ui.view.OneBtnTipsUI", OneBtnTipsUI);
          class OpenAirDropBoxViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(OpenAirDropBoxViewUI.uiView);
              }
          }
          OpenAirDropBoxViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "resource/home/zhezhaoceng.png", "right": 0, "mouseEnabled": true, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 13, "child": [{ "type": "Image", "props": { "y": 180, "x": 375, "skin": "resource/home/beijingkuang.png" }, "compId": 14 }, { "type": "Image", "props": { "y": 200, "x": 776, "skin": "home/zidan.png" }, "compId": 15 }, { "type": "Sprite", "props": { "y": 172, "x": 558, "texture": "home/biaoti.png" }, "compId": 16 }, { "type": "Image", "props": { "y": 347, "x": 667, "width": 256, "var": "img_icon", "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 20 }, { "type": "Label", "props": { "y": 489, "x": 666, "width": 524, "var": "lan_gunName", "valign": "middle", "overflow": "hidden", "height": 58, "fontSize": 58, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 21 }, { "type": "Button", "props": { "y": 590, "x": 666, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17, "child": [{ "type": "Sprite", "props": { "y": 32, "x": 30, "texture": "comp/icon_ad.png" }, "compId": 18 }, { "type": "Label", "props": { "y": 33, "x": 65, "text": "立即获得", "fontSize": 32, "color": "#ffffff", "bold": true }, "compId": 19 }] }, { "type": "Button", "props": { "y": 230, "x": 908, "var": "btn_close", "stateNum": 1, "skin": "home/guanbi.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22 }] }], "loadList": ["resource/home/zhezhaoceng.png", "resource/home/beijingkuang.png", "home/zidan.png", "home/biaoti.png", "comp/lingquanniu.png", "comp/icon_ad.png", "home/guanbi.png"], "loadList3D": [] };
          view.OpenAirDropBoxViewUI = OpenAirDropBoxViewUI;
          REG("ui.view.OpenAirDropBoxViewUI", OpenAirDropBoxViewUI);
          class OpenBoxRewardViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(OpenBoxRewardViewUI.uiView);
              }
          }
          OpenBoxRewardViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 375, "x": 667, "width": 1090, "height": 640, "centerY": 0, "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 45, "child": [{ "type": "Image", "props": { "y": 80, "x": -355, "width": 1800, "skin": "resource/game/bg_revive.png" }, "compId": 46 }, { "type": "Button", "props": { "y": 532, "x": 545, "var": "btn_get", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 48, "child": [{ "type": "Label", "props": { "y": 28, "x": 30, "valign": "middle", "text": "立即获得", "fontSize": 40, "color": "#ffffff", "align": "center" }, "compId": 49 }] }, { "type": "Image", "props": { "y": 267.5, "x": 545, "skin": "trial/bg_green.png", "scaleY": 1.75, "scaleX": 1.75, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 50 }, { "type": "Image", "props": { "y": 221, "x": 550.5, "width": 142, "var": "img_icon", "skin": "icon/icon_xunzhang.png", "height": 130, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 51 }, { "type": "Label", "props": { "y": 278, "x": 645, "width": 188, "var": "lab_cnt", "valign": "middle", "text": "x9999", "fontSize": 30, "color": "#ffffff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 52 }] }], "loadList": ["resource/game/bg_revive.png", "comp/lingquanniu.png", "trial/bg_green.png", "icon/icon_xunzhang.png"], "loadList3D": [] };
          view.OpenBoxRewardViewUI = OpenBoxRewardViewUI;
          REG("ui.view.OpenBoxRewardViewUI", OpenBoxRewardViewUI);
          class OpenBoxViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(OpenBoxViewUI.uiView);
              }
          }
          OpenBoxViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 1334, "height": 750, "centerY": -46, "centerX": 0 }, "compId": 71, "child": [{ "type": "Image", "props": { "y": 370, "x": 612, "skin": "resource/openBox/diban2.png", "sizeGrid": "5,5,5,5", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 3 }, { "type": "Box", "props": { "y": 208, "x": 376, "width": 583, "var": "box", "height": 227 }, "compId": 73, "child": [{ "type": "Image", "props": { "y": 60, "x": 73, "visible": false, "var": "img_select", "skin": "openBox/xuanzhongkuang.png", "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "58,58,58,58" }, "compId": 175 }, { "type": "Image", "props": { "y": 60, "x": 73, "width": 71, "skin": "openBox/baoxiang.png", "height": 61, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 57 }, { "type": "Image", "props": { "y": 60, "x": 221, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 151 }, { "type": "Image", "props": { "y": 60, "x": 369, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 152 }, { "type": "Image", "props": { "y": 60, "x": 517, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 153 }, { "type": "Image", "props": { "y": 188, "x": 517, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 154 }, { "type": "Image", "props": { "y": 188, "x": 369, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 155 }, { "type": "Image", "props": { "y": 188, "x": 221, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 156 }, { "type": "Image", "props": { "y": 188, "x": 73, "skin": "openBox/baoxiang.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 157 }] }, { "type": "Button", "props": { "y": 108, "x": 174, "var": "btn_close", "stateNum": 1, "skin": "home/guanbi.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 88 }, { "type": "Button", "props": { "y": 539, "x": 881, "var": "btn_openReward", "stateNum": 1, "skin": "openBox/choujiangdiban.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 54, "child": [{ "type": "Image", "props": { "y": 47, "x": 67, "var": "img_videoIcon", "skin": "openBox/kanshipin.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 185 }, { "type": "Sprite", "props": { "y": 24, "x": 95, "texture": "openBox/choujiang.png" }, "compId": 196 }] }, { "type": "Image", "props": { "y": 159, "x": 948, "var": "lab_cnt", "skin": "openBox/5.png", "anchorY": 0.5, "anchorX": 1 }, "compId": 181 }, { "type": "Image", "props": { "y": 159, "x": 958, "skin": "openBox/_.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 182 }, { "type": "Image", "props": { "y": 159, "x": 980, "skin": "openBox/5.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 183 }, { "type": "Image", "props": { "y": 155, "x": 331, "width": 0, "var": "pro_val", "skin": "resource/openBox/jindu2.png" }, "compId": 191 }, { "type": "Sprite", "props": { "y": 152, "x": 328, "width": 573, "texture": "resource/openBox/jindu1.png" }, "compId": 190 }, { "type": "Sprite", "props": { "y": 115.5, "x": 914, "texture": "openBox/jiangpin.png" }, "compId": 194 }] }], "loadList": ["resource/openBox/diban2.png", "openBox/xuanzhongkuang.png", "openBox/baoxiang.png", "home/guanbi.png", "openBox/choujiangdiban.png", "openBox/kanshipin.png", "openBox/choujiang.png", "openBox/5.png", "openBox/_.png", "resource/openBox/jindu2.png", "resource/openBox/jindu1.png", "openBox/jiangpin.png"], "loadList3D": [] };
          view.OpenBoxViewUI = OpenBoxViewUI;
          REG("ui.view.OpenBoxViewUI", OpenBoxViewUI);
          class ProfessionViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ProfessionViewUI.uiView);
              }
          }
          ProfessionViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank_2.png", "right": 0, "left": 0, "bottom": 0, "sizeGrid": "2,2,2,2" }, "compId": 32 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 39, "child": [{ "type": "Image", "props": { "y": 383, "x": 74, "var": "img_icon", "scaleY": 1.8, "scaleX": 1.8, "left": 74, "centerY": 8, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 35 }, { "type": "Label", "props": { "y": 160, "x": 950, "var": "lab_name", "valign": "middle", "text": "医疗兵", "right": 285, "fontSize": 65, "color": "#ffffff", "centerY": -215, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 36 }, { "type": "Label", "props": { "y": 407, "x": 956, "wordWrap": true, "width": 607, "var": "lab_desc", "valign": "top", "right": 75, "height": 237, "fontSize": 33, "color": "#ffffff", "centerY": 32, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 37 }, { "type": "Label", "props": { "y": 685, "x": 1194, "valign": "middle", "text": "正在加载中...", "right": 51, "fontSize": 30, "color": "#ffffff", "bottom": 50, "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 38 }] }], "loadList": ["common/blank_2.png"], "loadList3D": [] };
          view.ProfessionViewUI = ProfessionViewUI;
          REG("ui.view.ProfessionViewUI", ProfessionViewUI);
          class ReadyViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ReadyViewUI.uiView);
              }
          }
          ReadyViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": false, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/ready/img_readBg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 30 }, { "type": "Box", "props": { "x": 0, "width": 1334, "var": "box", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 4, "child": [{ "type": "Box", "props": { "x": 180, "width": 261, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 562, "centerY": 27 }, "compId": 196 }, { "type": "Button", "props": { "y": 481, "x": 757, "width": 105, "var": "btn_grenade1", "stateNum": 1, "skin": "xIndex/zhuangbeibeijing.png", "height": 131, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 12, "child": [{ "type": "Image", "props": { "y": 37, "x": 23, "var": "img_add1", "skin": "xIndex/jiahao.png" }, "compId": 192 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade1", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 55 }, { "type": "Label", "props": { "y": 107, "x": 52, "var": "lab_change1", "text": "点击更换", "skewX": 0, "fontSize": 20, "color": "#ffffff", "anchorX": 0.5, "align": "left" }, "compId": 24 }, { "type": "Label", "props": { "y": 14, "x": 36, "width": 60, "var": "lab_grenadeName1", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeName1", "height": 18, "fontSize": 18, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 110 }, { "type": "Label", "props": { "y": 14, "x": 88, "width": 24, "var": "lab_grenadeNum1", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeNum1", "height": 12, "fontSize": 12, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 155 }] }, { "type": "Button", "props": { "y": 481, "x": 897, "var": "btn_grenade2", "stateNum": 1, "skin": "xIndex/zhuangbeibeijing.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 135, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add2", "skin": "xIndex/jiahao.png" }, "compId": 193 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade2", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 136 }, { "type": "Label", "props": { "y": 107, "x": 13, "var": "lab_change2", "text": "点击更换", "skewX": 0, "fontSize": 20, "color": "#ffffff", "align": "left" }, "compId": 151 }, { "type": "Label", "props": { "y": 14, "x": 23, "width": 36, "var": "lab_grenadeName2", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "height": 18, "fontSize": 18, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 157 }, { "type": "Label", "props": { "y": 14, "x": 89, "width": 24, "var": "lab_grenadeNum2", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "height": 12, "fontSize": 12, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 158 }] }, { "type": "Button", "props": { "y": 621, "x": 756, "var": "btn_grenade3", "stateNum": 1, "skin": "xIndex/zhuangbeibeijing.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 139, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add3", "skin": "xIndex/jiahao.png" }, "compId": 194 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade3", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 141 }, { "type": "Label", "props": { "y": 107, "x": 13, "var": "lab_change3", "text": "点击更换", "skewX": 0, "fontSize": 20, "color": "#ffffff", "align": "left" }, "compId": 152 }, { "type": "Label", "props": { "y": 12, "x": 23, "width": 36, "var": "lab_grenadeName3", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "height": 18, "fontSize": 18, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 160 }, { "type": "Label", "props": { "y": 12, "x": 88, "var": "lab_grenadeNum3", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 12, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 161 }] }, { "type": "Button", "props": { "y": 620, "x": 898, "var": "btn_grenade4", "stateNum": 1, "skin": "xIndex/zhuangbeibeijing.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 140, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add4", "skin": "xIndex/jiahao.png" }, "compId": 195 }, { "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade4", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 144 }, { "type": "Label", "props": { "y": 99, "x": 13, "var": "lab_change4", "text": "点击更换", "skewX": 0, "fontSize": 20, "color": "#ffffff", "align": "left" }, "compId": 153 }, { "type": "Label", "props": { "y": 12, "x": 23, "var": "lab_grenadeName4", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 163 }, { "type": "Label", "props": { "y": 12, "x": 88, "var": "lab_grenadeNum4", "valign": "middle", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 12, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 164 }] }, { "type": "Box", "props": { "y": 72, "x": 480, "width": 682, "height": 298 }, "compId": 169, "child": [{ "type": "Image", "props": { "y": 42, "x": 0, "skin": "trial/bg_yellow.png" }, "compId": 170 }, { "type": "Image", "props": { "y": 140, "x": 268, "var": "img_trial1", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 171 }, { "type": "Image", "props": { "y": 140, "x": 433, "var": "img_trial2", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 172 }, { "type": "Image", "props": { "y": 140, "x": 597, "var": "img_trial3", "skin": "trial/bg_green.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 173 }, { "type": "Image", "props": { "y": 256, "x": 48, "var": "img_video1", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 203 }, { "type": "Image", "props": { "y": 180, "x": 312.5, "width": 34, "var": "img_video2", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "height": 34, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 205 }, { "type": "Image", "props": { "y": 180, "x": 478.5, "var": "img_video3", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 207 }, { "type": "Image", "props": { "y": 180, "x": 641, "width": 34, "var": "img_video4", "skin": "comp/icon_ad.png", "scaleY": 0.6, "scaleX": 0.6, "height": 34, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 209 }, { "type": "Image", "props": { "y": 269, "x": 426, "visible": false, "var": "btn_getAll", "skin": "comp/woquandouyao.png", "scaleY": 0.8, "scaleX": 0.8, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 179, "child": [{ "type": "Sprite", "props": { "y": 3, "x": 144, "var": "img_videoAll", "texture": "comp/icon_ad.png" }, "compId": 236 }] }, { "type": "Image", "props": { "y": 135, "x": 89, "width": 256, "var": "img_icon1", "scaleY": 0.8, "scaleX": 0.8, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 180 }, { "type": "Image", "props": { "y": 116, "x": 269, "width": 256, "var": "img_icon2", "scaleY": 0.4, "scaleX": 0.4, "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 181 }, { "type": "Image", "props": { "y": 116, "x": 432, "var": "img_icon3", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 182 }, { "type": "Image", "props": { "y": 116, "x": 602, "var": "img_icon4", "scaleY": 0.4, "scaleX": 0.4, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 183 }, { "type": "Image", "props": { "y": 45, "x": 1, "width": 171, "var": "btn_get1", "skin": "common/blank.png", "height": 240, "alpha": 0, "sizeGrid": "1,1,1,1" }, "compId": 197 }, { "type": "Image", "props": { "y": 140, "x": 268, "width": 141, "var": "btn_get2", "skin": "common/blank.png", "height": 200, "anchorY": 0.5, "anchorX": 0.5, "alpha": 0, "sizeGrid": "1,1,1,1" }, "compId": 198 }, { "type": "Image", "props": { "y": 45, "x": 364, "width": 137, "var": "btn_get3", "skin": "common/blank.png", "height": 186, "alpha": 0, "sizeGrid": "1,1,1,1" }, "compId": 199 }, { "type": "Image", "props": { "y": 47, "x": 530, "width": 140, "var": "btn_get4", "skin": "common/blank.png", "height": 184, "alpha": 0, "sizeGrid": "1,1,1,1" }, "compId": 200 }, { "type": "Label", "props": { "y": 185, "x": 31, "wordWrap": true, "width": 114, "var": "itemName1", "text": "MGL140000(收藏)", "strokeColor": "#6e6161", "stroke": 4, "overflow": "hidden", "name": "itemName1", "height": 45, "fontSize": 20, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 184 }, { "type": "Label", "props": { "y": 180, "x": 264, "width": 88, "var": "itemName2", "valign": "middle", "text": "增血包", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 185 }, { "type": "Label", "props": { "y": 180, "x": 426, "width": 110, "var": "itemName3", "valign": "middle", "text": "s-Kair", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "height": 20, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 186 }, { "type": "Label", "props": { "y": 180, "x": 594, "width": 112, "var": "itemName4", "valign": "middle", "text": "左轮手枪", "strokeColor": "#6e6161", "stroke": 5, "overflow": "hidden", "height": 20, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 187 }, { "type": "Label", "props": { "y": 180, "x": 307, "visible": false, "var": "itemNum2", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 188 }, { "type": "Label", "props": { "y": 180, "x": 470, "visible": false, "var": "itemNum3", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 189 }, { "type": "Label", "props": { "y": 180, "x": 649, "visible": false, "var": "itemNum4", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 190 }, { "type": "Label", "props": { "y": 210, "x": 434, "var": "lab_get3", "valign": "middle", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 208 }, { "type": "Label", "props": { "y": 211, "x": 602, "var": "lab_get4", "valign": "middle", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 210 }, { "type": "Label", "props": { "y": 211, "x": 265, "var": "lab_get2", "valign": "middle", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 206 }, { "type": "Label", "props": { "y": 244, "x": 69, "var": "lab_get1", "text": "试用", "fontSize": 22, "color": "#ffffff", "bold": true }, "compId": 202 }] }, { "type": "Image", "props": { "y": 581, "x": 1071, "width": 189, "var": "btnStartGame", "skin": "xIndex/btn_1.png", "scaleY": 1, "scaleX": 1, "height": 232, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 121, "child": [{ "type": "Image", "props": { "y": 99, "x": 29.5, "skin": "xIndex/word_start.png" }, "compId": 168 }] }, { "type": "Image", "props": { "y": 403, "x": 310, "var": "btn_changePro", "skin": "resource/game/zhiyebeijing.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 211, "child": [{ "type": "Label", "props": { "y": 514, "x": 51, "text": "点击更换职业", "fontSize": 25, "color": "#ffffff" }, "compId": 212 }, { "type": "Label", "props": { "y": 23, "x": 147, "width": 81, "var": "lab_occupation", "valign": "middle", "overflow": "hidden", "height": 30, "fontSize": 25, "color": "#000000", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 119 }, { "type": "Label", "props": { "y": 12, "x": 32, "text": "当前职业:", "fontSize": 24, "color": "#000000", "bold": true }, "compId": 166 }] }, { "type": "Box", "props": { "y": 415, "x": 482, "width": 190, "var": "btn_gun", "height": 134 }, "compId": 215, "child": [{ "type": "Image", "props": { "y": 14.024999999999977, "x": 94, "width": 188, "var": "img_flag", "stateNum": 1, "skin": "xIndex/img_game_white.png", "scaleY": 0.55, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 214 }, { "type": "Image", "props": { "y": 29, "x": 1, "width": 93, "skin": "xIndex/img_game_zhu.png", "height": 101 }, "compId": 216 }, { "type": "Image", "props": { "y": 80, "x": 94, "width": 144, "stateNum": 1, "skin": "xIndex/img_game_zuWUQi.png", "scaleY": 1.3, "scaleX": 1.3, "height": 80, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17 }, { "type": "Image", "props": { "y": 83.02499999999998, "x": 97, "var": "img_gunIcon", "skewY": 0, "skewX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 36 }, { "type": "Label", "props": { "y": 107.02499999999998, "x": 91, "text": "点击更换", "fontSize": 20, "color": "#ffffff", "align": "left" }, "compId": 108 }, { "type": "Label", "props": { "y": 3.0249999999999773, "x": 7, "width": 79, "var": "lab_gunName", "valign": "middle", "skewY": 0.5, "skewX": 0, "overflow": "hidden", "height": 18, "fontSize": 15, "color": "#000000", "bold": true, "align": "left" }, "compId": 22 }, { "type": "Label", "props": { "y": 15.024999999999977, "x": 186, "width": 46, "var": "lab_bulletNum", "valign": "middle", "overflow": "hidden", "height": 14, "fontSize": 10, "color": "#000000", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 148 }] }, { "type": "Box", "props": { "y": 553.5, "x": 483, "width": 190, "var": "btn_gun1", "height": 134 }, "compId": 217, "child": [{ "type": "Image", "props": { "y": 14.024999999999977, "x": 94, "width": 188, "var": "img_flag1", "stateNum": 1, "skin": "xIndex/img_game_white.png", "scaleY": 0.55, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 218 }, { "type": "Image", "props": { "y": 29, "x": 1, "width": 93, "skin": "xIndex/img_game_fu.png", "height": 101 }, "compId": 219 }, { "type": "Image", "props": { "y": 80, "x": 94, "width": 144, "stateNum": 1, "skin": "xIndex/img_game_zuWUQi.png", "scaleY": 1.3, "scaleX": 1.3, "height": 80, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 220 }, { "type": "Image", "props": { "y": 83.02499999999998, "x": 97, "var": "img_gunIcon1", "skewY": 0, "skewX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 221 }, { "type": "Label", "props": { "y": 107.02499999999998, "x": 91, "text": "点击更换", "fontSize": 20, "color": "#ffffff", "align": "left" }, "compId": 222 }, { "type": "Label", "props": { "y": 3.0249999999999773, "x": 7, "width": 79, "var": "lab_gunName1", "valign": "middle", "skewY": 0.5, "skewX": 0, "overflow": "hidden", "height": 18, "fontSize": 15, "color": "#000000", "bold": true, "align": "left" }, "compId": 223 }, { "type": "Label", "props": { "y": 15.024999999999977, "x": 186, "width": 46, "var": "lab_bulletNum1", "valign": "middle", "overflow": "hidden", "height": 14, "fontSize": 10, "color": "#000000", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 224 }] }, { "type": "Sprite", "props": { "y": 89, "x": 481.5, "texture": "xIndex/jiantou1.png" }, "compId": 226 }, { "type": "Sprite", "props": { "y": 104.5, "x": 669, "texture": "xIndex/jiantou1.png", "rotation": 180 }, "compId": 227 }, { "type": "Sprite", "props": { "y": 386, "x": 612.34375, "texture": "xIndex/jiantou.png" }, "compId": 228 }, { "type": "Sprite", "props": { "y": 401, "x": 502.5, "texture": "xIndex/jiantou.png", "rotation": 180 }, "compId": 229 }, { "type": "Label", "props": { "y": 81, "x": 515, "text": "推荐组合", "fontSize": 30, "color": "#fffc00   ", "bold": true }, "compId": 225 }, { "type": "Label", "props": { "y": 381, "x": 507, "text": "选择装备", "fontSize": 24, "color": "#ffffff", "bold": true }, "compId": 230 }] }, { "type": "Button", "props": { "width": 184, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "height": 76, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 91, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 118 }] }], "loadList": ["resource/ready/img_readBg.png", "xIndex/zhuangbeibeijing.png", "xIndex/jiahao.png", "trial/bg_yellow.png", "trial/bg_green.png", "comp/icon_ad.png", "comp/woquandouyao.png", "common/blank.png", "xIndex/btn_1.png", "xIndex/word_start.png", "resource/game/zhiyebeijing.png", "xIndex/img_game_white.png", "xIndex/img_game_zhu.png", "xIndex/img_game_zuWUQi.png", "xIndex/img_game_fu.png", "xIndex/jiantou1.png", "xIndex/jiantou.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ReadyViewUI = ReadyViewUI;
          REG("ui.view.ReadyViewUI", ReadyViewUI);
          class ResultViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ResultViewUI.uiView);
              }
          }
          ResultViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 1334, "var": "middleBox", "name": "middleBox", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 19, "child": [{ "type": "Image", "props": { "y": 40, "skin": "resource/game/bg_game.png", "right": -11 }, "compId": 177, "child": [{ "type": "Image", "props": { "var": "img_bg", "top": 2, "skin": "xIndex/bg_win_di_2.png", "centerX": 13, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 42 }] }, { "type": "Box", "props": { "y": -41, "x": 637, "width": 668, "var": "resultBox", "height": 776 }, "compId": 78, "child": [{ "type": "Image", "props": { "y": 237, "x": 329, "var": "img_floor_0", "skin": "resource/game/bg_lose_di_1.png", "skewY": 0, "skewX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 43 }, { "type": "Button", "props": { "y": 724, "x": 498, "width": 277, "visible": true, "var": "btn_back", "stateNum": 1, "skin": "common/btn_common_green.png", "labelSize": 30, "labelColors": "#ffffff", "labelBold": true, "height": 102, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 47, "child": [{ "type": "Image", "props": { "y": 34, "x": 48, "skin": "comp/icon_ad.png" }, "compId": 191 }, { "type": "Label", "props": { "y": 51, "x": 155, "text": "三倍领取", "fontSize": 30, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 205 }] }, { "type": "Image", "props": { "y": 257, "x": 420, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 52 }, { "type": "Image", "props": { "y": 318, "x": 420, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 53 }, { "type": "Image", "props": { "y": 377, "x": 420, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 55 }, { "type": "Image", "props": { "y": 436, "x": 420, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 73 }, { "type": "Image", "props": { "y": 497, "x": 420, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 80 }, { "type": "Image", "props": { "y": 597, "x": 205, "width": 40, "skin": "comp/icon_xunzhang.png", "height": 40 }, "compId": 56 }, { "type": "Label", "props": { "y": 258, "x": 137, "text": "击杀", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6" }, "compId": 48 }, { "type": "Label", "props": { "y": 317, "x": 138, "text": "爆头", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6" }, "compId": 49 }, { "type": "Label", "props": { "y": 375, "x": 136, "text": "摧毁载具", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6" }, "compId": 51 }, { "type": "Label", "props": { "y": 279, "x": 557, "var": "lab_killGold", "valign": "middle", "text": "456", "fontSize": 28, "font": "Microsoft YaHei", "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 57 }, { "type": "Label", "props": { "y": 341, "x": 561, "width": 60, "var": "lab_BlowGold", "valign": "middle", "text": "7586", "height": 28, "fontSize": 28, "font": "Microsoft YaHei", "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 61 }, { "type": "Label", "props": { "y": 402, "x": 546, "var": "lab_VehicleGold", "valign": "middle", "text": "10", "fontSize": 28, "font": "Microsoft YaHei", "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 63 }, { "type": "Label", "props": { "y": 620, "x": 338, "var": "lab_totalGold", "valign": "middle", "text": "11111111111111111", "fontSize": 35, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 64 }, { "type": "Label", "props": { "y": 619, "x": 295.4140625, "valign": "middle", "text": "总计", "fontSize": 30, "font": "SimHei", "color": "#ffee5b", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 65 }, { "type": "Label", "props": { "y": 276, "x": 321, "var": "lab_killCnt", "valign": "middle", "text": "7", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 66 }, { "type": "Label", "props": { "y": 336, "x": 320, "var": "lab_BlowCnt", "valign": "middle", "text": "4", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 67 }, { "type": "Label", "props": { "y": 393, "x": 320, "var": "lab_VehicleCnt", "valign": "middle", "text": "2", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 69 }, { "type": "Label", "props": { "y": 437, "x": 138, "width": 56, "text": "最高连击", "height": 27, "fontSize": 28, "font": "SimHei", "color": "#d6d6d6" }, "compId": 74 }, { "type": "Label", "props": { "y": 463, "x": 557, "var": "lab_doubleHitGold", "valign": "middle", "text": "452", "fontSize": 28, "font": "Microsoft YaHei", "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 75 }, { "type": "Label", "props": { "y": 452, "x": 319, "width": 15.572265625, "var": "lab_doubleHit", "valign": "middle", "text": "5", "height": 28, "fontSize": 28, "font": "SimHei", "color": "#d6d6d6", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 76 }, { "type": "Label", "props": { "y": 496, "x": 137, "text": "复活惩罚", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6" }, "compId": 81 }, { "type": "Label", "props": { "y": 523, "x": 561.83984375, "width": 69, "var": "lab_reviveGold", "valign": "middle", "text": "-200", "height": 28, "fontSize": 28, "font": "Microsoft YaHei", "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 82 }, { "type": "Label", "props": { "y": 511, "x": 320, "var": "lab_reviveCnt", "valign": "middle", "text": "1", "fontSize": 28, "font": "SimHei", "color": "#d6d6d6", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 83 }, { "type": "Image", "props": { "y": 724, "x": 226.6298828125, "width": 277, "var": "btn_get", "valign": "middle", "underline": true, "text": "普通领取", "stateNum": 1, "skin": "wxlocal/comm_btn.png", "labelSize": 30, "labelFont": "SimHei", "labelColors": "#ffffff", "labelBold": true, "label": "  返回基地", "height": 102, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 86, "child": [{ "type": "Label", "props": { "y": 36, "x": 77.328125, "valign": "middle", "text": "领取奖励", "fontSize": 30, "font": "SimHei", "color": "#ffffff", "bold": true, "align": "center" }, "compId": 178 }] }, { "type": "Button", "props": { "y": 908, "x": -49, "width": 170, "visible": false, "var": "btnRecorder", "stateNum": 1, "skin": "common/btn_common_green.png", "labelSize": 30, "labelColors": "#ffffff", "labelBold": true, "height": 102, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 217, "child": [{ "type": "Image", "props": { "y": 14, "x": 63, "skin": "toutiao/fenxiang.png" }, "compId": 218 }, { "type": "Image", "props": { "y": 57, "x": 18, "skin": "toutiao/fenxiangluping1111.png" }, "compId": 220 }] }] }, { "type": "Box", "props": { "y": 12, "x": 667, "width": 668, "visible": false, "var": "cleanBox", "height": 723 }, "compId": 128, "child": [{ "type": "Image", "props": { "y": -14, "x": -1500, "width": 3000, "skin": "common/blank.png", "sizeGrid": "1,1,1,1", "height": 750 }, "compId": 221 }, { "type": "Image", "props": { "y": 220, "x": 101.5, "skin": "xIndex/clean_bg.png" }, "compId": 160 }, { "type": "Image", "props": { "y": 476, "x": 329, "skin": "resource/game/bg_lose_di_1.png", "skewY": 0, "skewX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 134 }, { "type": "Image", "props": { "y": 290, "x": 140, "width": 236, "skin": "comp/bg_award.png", "scaleY": 0.4, "scaleX": 0.4, "height": 232 }, "compId": 162 }, { "type": "Image", "props": { "y": 290, "x": 279, "skin": "comp/bg_award.png", "scaleY": 0.4, "scaleX": 0.4 }, "compId": 163 }, { "type": "Image", "props": { "y": 290, "x": 419, "skin": "comp/bg_award.png", "scaleY": 0.4, "scaleX": 0.4 }, "compId": 164 }, { "type": "Image", "props": { "y": 334, "x": 188, "width": 60, "var": "icon1", "height": 48, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 165 }, { "type": "Image", "props": { "y": 334, "x": 326, "width": 50, "var": "icon2", "height": 50, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 166 }, { "type": "Image", "props": { "y": 334, "x": 467, "width": 50, "var": "icon3", "height": 50, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 167 }, { "type": "Label", "props": { "y": 237, "x": 136, "wordWrap": true, "width": 400, "text": "恭喜你取得了胜利，这是你在打扫战场时发现的东西，赶紧收起来吧!", "height": 56, "fontSize": 22, "color": "#e8dc4d" }, "compId": 161 }, { "type": "Button", "props": { "y": 594, "x": 194, "width": 277, "var": "btn_adGet", "stateNum": 1, "skin": "comp/btn_confirm.png", "labelSize": 30, "labelFont": "SimHei", "labelColors": "#ffffff", "labelBold": true, "labelAlign": "none", "height": 102, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 135, "child": [{ "type": "Image", "props": { "y": 36, "x": 44, "skin": "comp/icon_ad.png" }, "compId": 190 }, { "type": "Label", "props": { "y": 51, "x": 154.65625, "text": "领取奖励", "fontSize": 30, "font": "SimHei", "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 195 }] }, { "type": "Image", "props": { "y": 594, "x": 468, "width": 277, "var": "btn_get2", "valign": "middle", "underline": true, "text": "普通领取", "stateNum": 1, "skin": "wxlocal/comm_btn.png", "labelSize": 30, "labelFont": "SimHei", "labelColors": "#ffffff", "labelBold": true, "label": "返回基地", "height": 102, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 159, "child": [{ "type": "Label", "props": { "y": 36, "x": 77.328125, "text": "返回基地", "fontSize": 30, "font": "SimHei", "color": "#ffffff", "bold": true }, "compId": 179 }] }, { "type": "Label", "props": { "y": 391, "x": 186, "wordWrap": true, "var": "lab_name1", "text": "黄金宝箱", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 168 }, { "type": "Label", "props": { "y": 411, "x": 186, "wordWrap": true, "var": "lab_num1", "text": "x10", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 169 }, { "type": "Label", "props": { "y": 391, "x": 327, "wordWrap": true, "var": "lab_name2", "text": "黄金宝箱", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 170 }, { "type": "Label", "props": { "y": 411, "x": 327, "wordWrap": true, "var": "lab_num2", "text": "x10", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 171 }, { "type": "Label", "props": { "y": 391, "x": 467.5107421875, "wordWrap": true, "var": "lab_name3", "text": "黄金宝箱", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 172 }, { "type": "Label", "props": { "y": 411, "x": 468, "wordWrap": true, "var": "lab_num3", "text": "x10", "fontSize": 18, "color": "#ffee5b", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 173 }, { "type": "Button", "props": { "y": 880, "x": 524, "visible": false, "var": "btn_share", "stateNum": 1, "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 214, "child": [{ "type": "Label", "props": { "y": 29, "x": 43, "text": "分享", "fontSize": 40, "color": "#ffffff", "bold": true }, "compId": 215 }, { "type": "Sprite", "props": { "y": 28, "x": 134, "texture": "xIndex/fenxiang icon.png" }, "compId": 216 }] }, { "type": "Label", "props": { "y": 670, "x": 334, "visible": false, "var": "btn_ttBack", "valign": "bottom", "underline": true, "text": "返回", "fontSize": 20, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 222 }] }, { "type": "Image", "props": { "y": 521, "x": 751, "width": 510, "skin": "xIndex/jindutiao.png" }, "compId": 210 }, { "type": "Image", "props": { "y": 521, "x": 751, "width": 0, "var": "pro_val", "skin": "xIndex/jindutiao1.png", "height": 18 }, "compId": 211 }] }], "loadList": ["resource/game/bg_game.png", "xIndex/bg_win_di_2.png", "resource/game/bg_lose_di_1.png", "common/btn_common_green.png", "comp/icon_ad.png", "comp/icon_xunzhang.png", "wxlocal/comm_btn.png", "toutiao/fenxiang.png", "toutiao/fenxiangluping1111.png", "common/blank.png", "xIndex/clean_bg.png", "comp/bg_award.png", "comp/btn_confirm.png", "comp/lingquanniu.png", "xIndex/fenxiang icon.png", "xIndex/jindutiao.png", "xIndex/jindutiao1.png"], "loadList3D": [] };
          view.ResultViewUI = ResultViewUI;
          REG("ui.view.ResultViewUI", ResultViewUI);
          class ReviveViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ReviveViewUI.uiView);
              }
          }
          ReviveViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 405 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 406, "child": [{ "type": "Box", "props": { "x": 81, "width": 326, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 700, "centerY": 0 }, "compId": 407 }, { "type": "Button", "props": { "y": 228, "x": 582, "width": 178, "var": "btn_gun", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "sizeGrid": "0,25,0,0", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 408, "child": [{ "type": "Image", "props": { "y": 69, "x": 87, "var": "img_gunIcon", "skin": "icon/100105.png", "skewY": 0, "skewX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 409 }, { "type": "Label", "props": { "y": 99, "x": 89, "width": 74, "text": "点击更换武器", "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 410 }, { "type": "Label", "props": { "y": 4, "x": 4, "width": 110, "var": "lab_gunName", "text": "HK-416", "skewY": 0, "skewX": 0, "overflow": "hidden", "height": 18, "fontSize": 18, "color": "#ffffff", "bold": true, "align": "left" }, "compId": 412 }, { "type": "Label", "props": { "y": 7, "x": 173, "var": "lab_bulletNum", "text": "30/1200", "fontSize": 14, "color": "#ffffff", "anchorX": 1 }, "compId": 413 }] }, { "type": "Button", "props": { "y": 491, "x": 582, "width": 178, "var": "btn_gun1", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "sizeGrid": "0,25,0,0", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 414, "child": [{ "type": "Image", "props": { "y": 69, "x": 87, "var": "img_gunIcon1", "skin": "icon/100105.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 415 }, { "type": "Label", "props": { "y": 99, "x": 89, "width": 74, "text": "点击更换武器", "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 416 }, { "type": "Label", "props": { "y": 4, "x": 4, "width": 110, "var": "lab_gunName1", "text": "911", "skewY": 0, "skewX": 0, "overflow": "hidden", "height": 20, "fontSize": 18, "color": "#ffffff", "bold": true, "align": "left" }, "compId": 418 }, { "type": "Label", "props": { "y": 7, "x": 173, "var": "lab_bulletNum1", "text": "30/1200", "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 419 }] }, { "type": "Button", "props": { "y": 227, "x": 902, "var": "btn_grenade1", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 420, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add1", "skin": "xIndex/jiahao.png" }, "compId": 480 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box1", "height": 121 }, "compId": 481, "child": [{ "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade1", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 482 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName1", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeName1", "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 483 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum1", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "name": "lab_grenadeNum1", "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 484 }, { "type": "Label", "props": { "y": 99, "x": 12, "var": "lab_change1", "text": "点击更换武器", "skewX": 0, "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 423 }] }] }, { "type": "Button", "props": { "y": 227, "x": 1148, "var": "btn_grenade2", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 427, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add2", "skin": "xIndex/jiahao.png" }, "compId": 485 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box2", "height": 121 }, "compId": 486, "child": [{ "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade2", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 488 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName2", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 489 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum2", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 490 }, { "type": "Label", "props": { "y": 99, "x": 12, "var": "lab_change2", "text": "点击更换武器", "skewX": 0, "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 430 }] }] }, { "type": "Button", "props": { "y": 491, "x": 902, "var": "btn_grenade3", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 434, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add3", "skin": "xIndex/jiahao.png" }, "compId": 491 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box3", "height": 121 }, "compId": 492, "child": [{ "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade3", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 494 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName3", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 495 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum3", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 496 }, { "type": "Label", "props": { "y": 99, "x": 12, "var": "lab_change3", "text": "点击更换武器", "skewX": 0, "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 437 }] }] }, { "type": "Button", "props": { "y": 491, "x": 1148, "var": "btn_grenade4", "stateNum": 1, "skin": "xIndex/img_game_fuwuqi.png", "scaleY": 2, "scaleX": 2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 441, "child": [{ "type": "Image", "props": { "y": 40, "x": 22, "var": "img_add4", "skin": "xIndex/jiahao.png" }, "compId": 497 }, { "type": "Box", "props": { "y": 0, "x": 0, "width": 103, "var": "box4", "height": 121 }, "compId": 498, "child": [{ "type": "Image", "props": { "y": 66, "x": 51, "var": "img_grenade4", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 500 }, { "type": "Label", "props": { "y": 4, "x": 3, "var": "lab_grenadeName4", "valign": "middle", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 18, "color": "#ffffff", "align": "left" }, "compId": 501 }, { "type": "Label", "props": { "y": 7, "x": 100, "var": "lab_grenadeNum4", "text": "手雷", "skewY": 0, "skewX": 0, "scaleY": 1, "fontSize": 14, "color": "#ffffff", "anchorX": 1, "align": "right" }, "compId": 502 }, { "type": "Label", "props": { "y": 99, "x": 12, "var": "lab_change4", "text": "点击更换武器", "skewX": 0, "height": 12, "fontSize": 12, "color": "#ffffff", "align": "left" }, "compId": 444 }] }] }, { "type": "Button", "props": { "y": 667, "x": 249, "width": 273, "var": "btn_changePro", "stateNum": 1, "skin": "xIndex/common_bg.png", "sizeGrid": "2,2,2,2", "height": 98, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 450, "child": [{ "type": "Label", "props": { "y": 32, "x": 160, "width": 98, "var": "lab_occupation", "valign": "middle", "text": "狙击手", "overflow": "hidden", "height": 32, "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 451 }, { "type": "Label", "props": { "y": 15, "x": 14, "text": "当前职业:", "fontSize": 32, "color": "#ffffff", "bold": true }, "compId": 452 }, { "type": "Label", "props": { "y": 61, "x": 63.09375, "text": "点击更换角色", "fontSize": 24, "color": "#ffffff", "bold": true }, "compId": 453 }] }, { "type": "Image", "props": { "y": 681, "x": 1131, "var": "btnStartGame", "skin": "comp/btn_confirm1.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 475, "child": [{ "type": "Label", "props": { "text": "确 认", "fontSize": 36, "color": "#ffffff", "centerY": 0, "centerX": 0, "bold": true }, "compId": 479 }] }] }], "loadList": ["resource/comp/bg.png", "xIndex/img_game_fuwuqi.png", "icon/100105.png", "xIndex/jiahao.png", "xIndex/common_bg.png", "comp/btn_confirm1.png"], "loadList3D": [] };
          view.ReviveViewUI = ReviveViewUI;
          REG("ui.view.ReviveViewUI", ReviveViewUI);
          class RockerUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(RockerUI.uiView);
              }
          }
          RockerUI.uiView = { "type": "UIBaseView", "props": { "width": 200, "runtime": "", "height": 200 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 200, "skin": "battle/img_battle_left_hti.png", "height": 200 }, "compId": 3 }, { "type": "Image", "props": { "y": 10, "x": 10, "width": 180, "skin": "battle/img_battle_left_hti1.png", "height": 180 }, "compId": 10 }, { "type": "Image", "props": { "y": 166, "x": 102, "skin": "battle/img_battle_move.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 11 }, { "type": "Image", "props": { "y": 39, "x": 102, "skin": "battle/img_battle_move.png", "skewX": 180, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 14 }, { "type": "Image", "props": { "y": 100, "x": 39, "skin": "battle/img_battle_move.png", "rotation": 90, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 15 }, { "type": "Image", "props": { "y": 100, "x": 162, "skin": "battle/img_battle_move.png", "rotation": -90, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 16 }, { "type": "Image", "props": { "y": 100, "x": 100, "var": "knob", "skin": "battle/img_battle_xingZou.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 4 }], "loadList": ["battle/img_battle_left_hti.png", "battle/img_battle_left_hti1.png", "battle/img_battle_move.png", "battle/img_battle_xingZou.png"], "loadList3D": [] };
          view.RockerUI = RockerUI;
          REG("ui.view.RockerUI", RockerUI);
          class SecLoadingViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(SecLoadingViewUI.uiView);
              }
          }
          SecLoadingViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 1334, "runtime": "", "mouseEnabled": true, "height": 750, "drawCallOptimize": true, "centerY": 0, "centerX": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "width": 1900, "skin": "loading/loading.jpg", "height": 750, "centerX": 0, "alpha": 1 }, "compId": 20 }, { "type": "Label", "props": { "y": 596, "x": 305, "width": 723, "var": "txt", "text": "游戏加载中...", "styleSkin": "", "strokeColor": "#413b33", "stroke": 4, "fontSize": 32, "color": "#ffffff", "align": "center" }, "compId": 6 }, { "type": "Image", "props": { "y": 630, "x": 167, "skin": "loading/loading_progress.png" }, "compId": 25 }, { "type": "Image", "props": { "y": 639, "x": 167, "width": 0, "var": "bar", "skin": "loading/bg_loading_tiao_2.png", "height": 31 }, "compId": 30 }, { "type": "Image", "props": { "y": 630, "x": 127, "var": "bar1", "skin": "loading/bg_loading_tiao_1.png" }, "compId": 31 }, { "type": "Image", "props": { "y": 669, "x": 182, "var": "imgLight", "skin": "loading/icon_gun.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22 }], "loadList": ["loading/loading.jpg", "loading/logo_toywar.png", "loading/loading_progress.png", "loading/bg_loading_tiao_2.png", "loading/bg_loading_tiao_1.png", "loading/icon_gun.png"], "loadList3D": [] };
          view.SecLoadingViewUI = SecLoadingViewUI;
          REG("ui.view.SecLoadingViewUI", SecLoadingViewUI);
          class SelectMapViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(SelectMapViewUI.uiView);
              }
          }
          SelectMapViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/home/hall_background.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 5 }, { "type": "Image", "props": { "y": 647, "var": "btn_confirm", "skin": "comp/btn_confirm1.png", "centerX": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 14, "child": [{ "type": "Label", "props": { "y": 35, "x": 74, "text": "前往战场", "fontSize": 32, "color": "#ffffff", "centerX": 0, "bold": true }, "compId": 13 }] }, { "type": "List", "props": { "y": 175, "x": 360, "width": 1334, "var": "list", "spaceX": 65, "repeatY": 1, "height": 420 }, "compId": 9, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 590, "name": "render", "height": 420 }, "compId": 17, "child": [{ "type": "Image", "props": { "y": 190, "x": 294, "width": 620, "name": "bg_map", "height": 394, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 10 }, { "type": "Image", "props": { "y": 190, "x": 294, "width": 574, "name": "map", "height": 349, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 18 }, { "type": "Image", "props": { "y": 288, "x": 3, "width": 581, "skin": "selectMap/bg_word.png", "name": "bg_word", "height": 76 }, "compId": 19 }, { "type": "Label", "props": { "y": 299, "x": 293, "width": 572, "text": "大马士革之围", "overflow": "hidden", "name": "mapName", "height": 58, "fontSize": 58, "color": "#ffffff", "bold": true, "anchorX": 0.5, "align": "center" }, "compId": 20 }, { "type": "Label", "props": { "y": 375, "x": 293, "width": 572, "text": "(完成两次海岛决战解锁0/2)", "overflow": "hidden", "name": "unlockDesc", "height": 58, "fontSize": 36, "color": "#ffffff", "bold": true, "anchorX": 0.5, "align": "center" }, "compId": 22 }] }] }, { "type": "Label", "props": { "y": 63, "text": "选择游戏地图", "fontSize": 52, "color": "#ffffff", "centerX": 0, "bold": true }, "compId": 12 }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 23, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 24 }] }, { "type": "xianshilingqu_ef", "props": { "y": 134, "x": 18, "runtime": "script/ui/xianshilingqu_ef.ts" }, "compId": 25 }], "loadList": ["resource/home/hall_background.png", "comp/btn_confirm1.png", "selectMap/bg_word.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.SelectMapViewUI = SelectMapViewUI;
          REG("ui.view.SelectMapViewUI", SelectMapViewUI);
          class ShopBuyViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ShopBuyViewUI.uiView);
              }
          }
          ShopBuyViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "fontSize": 26, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 191 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 192, "child": [{ "type": "Image", "props": { "y": 98.5, "x": 639, "skin": "resource/shop/bg.png" }, "compId": 159 }, { "type": "Image", "props": { "y": 557, "x": 887, "var": "btn_confirm", "skin": "shop/Market_querengoumai.png" }, "compId": 171 }, { "type": "Box", "props": { "y": 163, "x": 276, "width": 243, "scaleY": 1.37, "scaleX": 1.37, "height": 360 }, "compId": 167, "child": [{ "type": "Image", "props": { "y": 8, "x": -115, "var": "clock", "skin": "shop/Market_shizhong.png" }, "compId": 162 }, { "type": "Image", "props": { "y": 160, "x": 79, "visible": false, "var": "icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 164 }, { "type": "Label", "props": { "y": 21, "x": -37, "width": 128, "var": "lab_cnt", "valign": "middle", "text": "00:00:00", "overflow": "hidden", "height": 24, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 165 }, { "type": "Label", "props": { "y": 277, "x": 79, "width": 254, "var": "lab_name", "valign": "middle", "text": "type54(改良)", "stroke": 2, "overflow": "hidden", "height": 32, "fontSize": 24, "font": "Microsoft YaHei", "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 166 }] }, { "type": "Box", "props": { "y": 240, "x": 719, "width": 561, "var": "weaponInfo", "height": 440 }, "compId": 169, "child": [{ "type": "Label", "props": { "y": 80, "x": 84, "wordWrap": true, "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 200 }, { "type": "Label", "props": { "y": 80, "x": 163, "wordWrap": true, "var": "lab_type", "valign": "top", "text": "类型:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 201 }, { "type": "Label", "props": { "y": 79, "x": 364, "wordWrap": true, "valign": "top", "text": "品质:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 202 }, { "type": "Label", "props": { "y": 79, "x": 440, "wordWrap": true, "var": "lab_quality", "valign": "top", "text": "基础", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 203 }, { "type": "Label", "props": { "y": 117, "x": 84, "wordWrap": true, "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 204 }, { "type": "Label", "props": { "y": 117, "x": 162, "wordWrap": true, "var": "lab_caliber", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 205 }, { "type": "Label", "props": { "y": 117, "x": 365, "wordWrap": true, "valign": "top", "text": "弹容:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 206 }, { "type": "Label", "props": { "y": 117, "x": 436, "wordWrap": true, "var": "lab_num", "valign": "top", "text": "口径:", "overflow": "hidden", "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 207 }, { "type": "Label", "props": { "y": 249, "x": 10, "valign": "top", "text": "精度:", "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 208 }, { "type": "Label", "props": { "y": 201, "x": 290, "valign": "top", "text": "射速:", "height": 22, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 209 }, { "type": "Label", "props": { "y": 202, "x": 9, "valign": "top", "text": "伤害:", "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 210 }, { "type": "Label", "props": { "y": 250, "x": 289, "valign": "top", "text": "稳定:", "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 211 }, { "type": "Image", "props": { "y": 251, "x": 80, "width": 100, "var": "bar_precision", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 212 }, { "type": "Image", "props": { "y": 207, "x": 363, "width": 95, "var": "bar_shootSpeed", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 213 }, { "type": "Image", "props": { "y": 208, "x": 81, "width": 95, "var": "bar_power", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 214 }, { "type": "Image", "props": { "y": 249, "x": 363, "width": 95, "var": "bar_recoil", "skin": "arsenal/Market_shuxingzhitiao.png", "sizeGrid": "0,2,0,2", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 215 }, { "type": "Image", "props": { "y": 252, "x": 80, "width": 150, "skin": "shop/Market_shuxingzhi.png", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 216 }, { "type": "Image", "props": { "y": 206, "x": 363, "width": 150, "skin": "shop/Market_shuxingzhi.png", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 217 }, { "type": "Image", "props": { "y": 208, "x": 81, "width": 150, "skin": "shop/Market_shuxingzhi.png", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 218 }, { "type": "Image", "props": { "y": 249, "x": 363, "width": 150, "skin": "shop/Market_shuxingzhi.png", "scaleY": 1.3, "scaleX": 1.3, "anchorY": 0.5 }, "compId": 219 }] }, { "type": "Box", "props": { "y": 211, "x": 30, "width": 616, "var": "dragBox", "mouseThrough": false, "mouseEnabled": true, "height": 352 }, "compId": 220 }, { "type": "Image", "props": { "y": 236.5, "x": 1020.5, "var": "icon_cost", "skin": "comp/icon_xunzhang.png", "scaleY": 0.7, "scaleX": 0.7, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 173 }, { "type": "Label", "props": { "y": 232.5, "x": 914, "wordWrap": true, "width": 100, "valign": "top", "text": "售价", "overflow": "hidden", "height": 32, "fontSize": 38, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 172 }, { "type": "Label", "props": { "y": 236, "x": 1107, "width": 100, "var": "txt_price", "valign": "top", "text": "80000", "height": 32, "fontSize": 36, "color": "#f1db1d", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 146 }, { "type": "Label", "props": { "y": 414, "x": 1005, "wordWrap": true, "width": 351, "var": "boxInfo", "valign": "top", "text": "内含丰富奖励，打开有惊喜！", "overflow": "hidden", "height": 117, "fontSize": 26, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 190 }, { "type": "Image", "props": { "y": 26, "x": 690, "skin": "comp/hall_gengxun.png", "gray": true }, "compId": 193 }, { "type": "Image", "props": { "y": 26, "x": 943, "skin": "comp/hall_gengxun.png", "anchorY": 0, "anchorX": 0 }, "compId": 194 }, { "type": "Image", "props": { "y": 28, "x": 674, "skin": "comp/icon_ticket.png" }, "compId": 195 }, { "type": "Image", "props": { "y": 32, "x": 924, "skin": "comp/icon_xunzhang.png" }, "compId": 196 }, { "type": "FontClip", "props": { "y": 42, "x": 1136, "var": "lab_meritorious", "value": "999", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "anchorX": 1 }, "compId": 197 }, { "type": "FontClip", "props": { "y": 42, "x": 882, "var": "lab_volume", "value": "999", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "anchorX": 1 }, "compId": 198 }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_cancel", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 221, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 222 }] }], "loadList": ["resource/comp/bg.png", "resource/shop/bg.png", "shop/Market_querengoumai.png", "shop/Market_shizhong.png", "arsenal/Market_shuxingzhitiao.png", "shop/Market_shuxingzhi.png", "comp/icon_xunzhang.png", "comp/hall_gengxun.png", "comp/icon_ticket.png", "common/clip_white.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ShopBuyViewUI = ShopBuyViewUI;
          REG("ui.view.ShopBuyViewUI", ShopBuyViewUI);
          class ShopViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(ShopViewUI.uiView);
              }
          }
          ShopViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/comp/bg.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 4 }, { "type": "Box", "props": { "width": 1334, "var": "centerBox", "height": 750, "centerY": 0, "centerX": 0 }, "compId": 32, "child": [{ "type": "Panel", "props": { "y": 145, "x": 35, "width": 1300, "visible": true, "var": "panel", "height": 550 }, "compId": 78, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 2804, "sizeGrid": "355,30,25,260", "height": 550 }, "compId": 79, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 795, "height": 550 }, "compId": 148, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "skin": "resource/shop/Market_ditu.png", "sizeGrid": "0,0,0,0", "scaleY": 1.38, "scaleX": 1.38 }, "compId": 146 }, { "type": "List", "props": { "y": 87, "x": 28, "width": 741, "var": "list", "spaceX": 3, "repeatY": 1, "repeatX": 3, "height": 417 }, "compId": 43, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 243, "name": "render", "height": 412 }, "compId": 44, "child": [{ "type": "Image", "props": { "y": -9, "x": -6, "skin": "shop/bg_quality3.png", "name": "quality" }, "compId": 42 }, { "type": "Image", "props": { "y": 41, "x": 11, "skin": "shop/Market_junbeixiangmingchengbeijing.png" }, "compId": 150 }, { "type": "Image", "props": { "y": 47, "x": 21, "skin": "shop/Market_shizhong.png" }, "compId": 172 }, { "type": "Image", "props": { "y": 340, "x": 1.5, "skin": "shop/Market_jiagebeijing.png" }, "compId": 152 }, { "type": "Image", "props": { "y": 380, "x": 196, "skin": "comp/icon_xunzhang.png", "scaleY": 0.6, "scaleX": 0.6, "name": "icon_cost", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 173 }, { "type": "Image", "props": { "y": 193, "x": 119, "scaleY": 0.8, "scaleX": 0.8, "name": "icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 48 }, { "type": "Label", "props": { "y": 59, "x": 98, "width": 128, "valign": "middle", "text": "00:00:00", "overflow": "hidden", "name": "lab_cnt", "height": 24, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 45 }, { "type": "Label", "props": { "y": 280, "x": 120, "width": 219, "valign": "middle", "text": "type54(改良)", "stroke": 2, "overflow": "hidden", "name": "lab_name", "height": 32, "fontSize": 24, "font": "Microsoft YaHei", "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 46 }, { "type": "Label", "props": { "y": 381, "x": 102, "width": 149, "valign": "middle", "text": "价格：100", "overflow": "visible", "name": "lab_cost", "height": 28, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 47 }, { "type": "Label", "props": { "y": 317, "x": 121, "width": 207, "valign": "middle", "text": "改良", "overflow": "hidden", "name": "lab_quality", "height": 18, "fontSize": 18, "font": "Microsoft YaHei", "color": "#ffc600", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 189 }] }] }, { "type": "Label", "props": { "y": 39, "x": 130, "valign": "middle", "text": "武器装备·限时特卖", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 40 }] }, { "type": "Box", "props": { "y": 0, "x": 820, "width": 795, "height": 550 }, "compId": 174, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "skin": "resource/shop/Market_ditu.png", "sizeGrid": "0,0,0,0", "scaleY": 1.38, "scaleX": 1.38 }, "compId": 175 }, { "type": "List", "props": { "y": 87, "x": 28, "width": 741, "var": "list1", "spaceX": 3, "repeatY": 1, "repeatX": 3, "height": 417 }, "compId": 176, "child": [{ "type": "Box", "props": { "y": 206, "x": 118, "width": 251, "name": "render", "height": 425, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 177, "child": [{ "type": "Image", "props": { "width": 252, "skin": "shop/bg_quality3.png", "name": "quality", "height": 360 }, "compId": 178 }, { "type": "Image", "props": { "y": 54, "x": 16.5, "skin": "shop/Market_junbeixiangmingchengbeijing.png" }, "compId": 179 }, { "type": "Image", "props": { "y": 351, "x": 7, "skin": "shop/Market_jiagebeijing.png" }, "compId": 182 }, { "type": "Image", "props": { "y": 391, "x": 201.5, "skin": "comp/icon_ticket.png", "scaleY": 0.6, "scaleX": 0.6, "name": "icon_cost", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 183 }, { "type": "Image", "props": { "y": 204, "x": 124.5, "skin": "icon/treasureBox_1.png", "scaleY": 0.8, "scaleX": 0.8, "name": "icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 184 }, { "type": "Label", "props": { "y": 291, "x": 125.5, "width": 219, "valign": "middle", "text": "type54(改良)", "strokeColor": "#000000", "stroke": 2, "overflow": "hidden", "name": "lab_name", "height": 32, "fontSize": 24, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 186 }, { "type": "Label", "props": { "y": 71, "x": 96.5, "width": 128, "valign": "middle", "text": "剩余：3", "overflow": "hidden", "name": "lab_cnt", "height": 22, "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 185 }, { "type": "Label", "props": { "y": 392, "x": 107.5, "width": 149, "valign": "middle", "text": "价格：1000", "overflow": "visible", "name": "lab_cost", "height": 28, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 187 }, { "type": "Label", "props": { "y": 328, "x": 126.5, "width": 207, "visible": false, "valign": "middle", "text": "type54(改良)", "overflow": "hidden", "name": "lab_quality", "height": 18, "fontSize": 18, "color": "#ffc600", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "right" }, "compId": 190 }] }] }, { "type": "Label", "props": { "y": 39, "x": 123, "valign": "middle", "text": "军备箱·限时特卖", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 188 }] }, { "type": "Box", "props": { "y": 0, "x": 1640, "width": 896, "height": 550 }, "compId": 191, "child": [{ "type": "Image", "props": { "y": -1, "x": 0, "width": 620, "skin": "resource/shop/Market_ditu.png", "sizeGrid": "0,0,0,0", "scaleY": 1.38, "scaleX": 1.38, "height": 396 }, "compId": 192 }, { "type": "List", "props": { "y": 86, "x": 28, "width": 815, "var": "list2", "spaceX": 35, "repeatY": 1, "repeatX": 3, "height": 468 }, "compId": 193, "child": [{ "type": "Box", "props": { "y": 1, "x": 0, "width": 238, "name": "render", "height": 563 }, "compId": 194, "child": [{ "type": "Image", "props": { "y": -8, "x": -6, "skin": "shop/bg_quality5.png", "name": "quality" }, "compId": 195 }, { "type": "Image", "props": { "y": 342, "x": -1, "width": 274, "skin": "shop/Market_jiagebeijing.png", "height": 93 }, "compId": 197 }, { "type": "Image", "props": { "y": 304, "x": 189, "skin": "comp/icon_xunzhang.png", "scaleY": 0.6, "scaleX": 0.6 }, "compId": 196 }, { "type": "Image", "props": { "y": 385.2, "x": 213, "skin": "comp/icon_ticket.png", "scaleY": 0.6, "scaleX": 0.6, "name": "icon_cost", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 198 }, { "type": "Image", "props": { "y": 319, "x": 119, "skin": "shop/coin1.png", "name": "icon", "anchorY": 1, "anchorX": 0.5 }, "compId": 199 }, { "type": "Label", "props": { "y": 323, "x": 112, "width": 167, "valign": "middle", "text": "获得  20000", "strokeColor": "#000000", "stroke": 2, "overflow": "hidden", "name": "lab_name", "height": 32, "fontSize": 24, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 200 }, { "type": "Label", "props": { "y": 386.2, "x": 108.5, "width": 149, "valign": "middle", "text": "价格：1000", "overflow": "visible", "name": "lab_cost", "height": 28, "fontSize": 24, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 202 }] }] }, { "type": "Label", "props": { "y": 39, "x": 123, "valign": "middle", "text": "限时特卖", "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 204 }] }] }] }, { "type": "Image", "props": { "y": 26, "x": 690, "skin": "comp/hall_gengxun.png", "gray": true }, "compId": 166 }, { "type": "Image", "props": { "y": 26, "x": 943, "skin": "comp/hall_gengxun.png", "anchorY": 0, "anchorX": 0 }, "compId": 167 }, { "type": "Image", "props": { "y": 28, "x": 674, "skin": "comp/icon_ticket.png" }, "compId": 168 }, { "type": "Image", "props": { "y": 32, "x": 924, "skin": "comp/icon_xunzhang.png" }, "compId": 169 }, { "type": "FontClip", "props": { "y": 42, "x": 1136, "var": "lab_meritorious", "value": "999", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "anchorX": 1 }, "compId": 170 }, { "type": "FontClip", "props": { "y": 42, "x": 882, "var": "lab_volume", "value": "999", "skin": "common/clip_white.png", "sheet": "0123456789", "scaleY": 0.7, "scaleX": 0.7, "anchorX": 1 }, "compId": 171 }] }, { "type": "Button", "props": { "y": 38, "x": 92, "var": "btn_back", "top": 0, "stateNum": 1, "skin": "xIndex/img_game_back.png", "sizeGrid": "0,5,0,24", "left": 0, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 207, "child": [{ "type": "Image", "props": { "y": 9, "x": 54.5, "skin": "xIndex/img_game_back1.png" }, "compId": 208 }] }], "loadList": ["resource/comp/bg.png", "resource/shop/Market_ditu.png", "shop/bg_quality3.png", "shop/Market_junbeixiangmingchengbeijing.png", "shop/Market_shizhong.png", "shop/Market_jiagebeijing.png", "comp/icon_xunzhang.png", "comp/icon_ticket.png", "icon/treasureBox_1.png", "shop/bg_quality5.png", "shop/coin1.png", "comp/hall_gengxun.png", "common/clip_white.png", "xIndex/img_game_back.png", "xIndex/img_game_back1.png"], "loadList3D": [] };
          view.ShopViewUI = ShopViewUI;
          REG("ui.view.ShopViewUI", ShopViewUI);
          class SignViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(SignViewUI.uiView);
              }
          }
          SignViewUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 45, "child": [{ "type": "Image", "props": { "y": 54, "x": 6, "width": 1243, "skin": "resource/map/bg_sign1111.png", "height": 617 }, "compId": 44 }, { "type": "Image", "props": { "y": 688, "x": 640, "var": "btn_get", "skin": "comp/lingquanniu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 42, "child": [{ "type": "Sprite", "props": { "y": 35, "x": 48, "texture": "comp/icon_ad.png" }, "compId": 56 }, { "type": "Label", "props": { "y": 33, "x": 102, "text": "领取", "fontSize": 34, "color": "#ffffff", "bold": true }, "compId": 57 }] }, { "type": "Label", "props": { "y": 687, "x": 848, "width": 180, "var": "btn_getFew", "valign": "middle", "underline": true, "text": "只要少量特供券", "height": 50, "fontSize": 24, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 46 }, { "type": "Image", "props": { "y": 311, "x": 516, "visible": false, "var": "got1", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 47 }, { "type": "Image", "props": { "y": 311, "x": 663, "visible": false, "var": "got2", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 49 }, { "type": "Image", "props": { "y": 311, "x": 811, "visible": false, "var": "got3", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 50 }, { "type": "Image", "props": { "y": 514.5, "x": 516, "visible": false, "var": "got4", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 51 }, { "type": "Image", "props": { "y": 514.5, "x": 664, "visible": false, "var": "got5", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 52 }, { "type": "Image", "props": { "y": 514.5, "x": 811, "visible": false, "var": "got6", "skin": "sign/img_got.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 53 }, { "type": "Image", "props": { "y": 311, "x": 508.5, "visible": false, "var": "mark", "skin": "sign/mark.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 48 }, { "type": "Box", "props": { "y": 687, "x": 739, "width": 416, "var": "tipsBox", "mouseEnabled": false, "height": 100, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 58 }] }], "loadList": ["resource/map/bg_sign1111.png", "comp/lingquanniu.png", "comp/icon_ad.png", "sign/img_got.png", "sign/mark.png"], "loadList3D": [] };
          view.SignViewUI = SignViewUI;
          REG("ui.view.SignViewUI", SignViewUI);
          class SurpriseRewardViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(SurpriseRewardViewUI.uiView);
              }
          }
          SurpriseRewardViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseEnabled": true, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "visible": true, "top": 0, "skin": "common/blank.png", "right": 0, "left": 0, "bottom": 0, "alpha": 1, "sizeGrid": "1,1,1,1" }, "compId": 230 }, { "type": "Image", "props": { "visible": true, "top": 0, "skin": "resource/game/bg_0.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 198 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 220, "child": [{ "type": "Image", "props": { "y": 0, "x": -333, "width": 2000, "visible": false, "skin": "common/blank_2.png", "height": 750, "centerY": 0, "centerX": 0, "sizeGrid": "2,2,2,2" }, "compId": 219 }, { "type": "Box", "props": { "y": 129, "x": 191, "width": 385, "var": "rewardBox", "height": 562 }, "compId": 231, "child": [{ "type": "Image", "props": { "x": 82, "skin": "xIndex/recive_btn.png", "scaleY": 0.85, "scaleX": 0.85 }, "compId": 199 }, { "type": "Sprite", "props": { "y": 109, "var": "lab_tips", "texture": "xIndex/des.png" }, "compId": 200 }, { "type": "Image", "props": { "y": 460, "x": 151, "var": "recive_btn", "skin": "wxlocal/comm_btn.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 201, "child": [{ "type": "Label", "props": { "y": 31, "x": 97, "text": "领取", "strokeColor": "#552b0b", "stroke": 2, "fontSize": 40, "font": "SimHei", "color": "#ffffff", "bold": true, "align": "center" }, "compId": 202 }] }, { "type": "Image", "props": { "y": 323, "x": 52, "var": "img_coin", "skin": "comp/icon_xunzhang.png" }, "compId": 203, "child": [{ "type": "Label", "props": { "text": "X 100", "strokeColor": "#9c9c9c", "fontSize": 40, "font": "SimHei", "color": "#ffffff", "centerY": 0, "centerX": 105, "bold": true, "align": "center" }, "compId": 204 }] }] }] }], "loadList": ["common/blank.png", "resource/game/bg_0.png", "common/blank_2.png", "xIndex/recive_btn.png", "xIndex/des.png", "wxlocal/comm_btn.png", "comp/icon_xunzhang.png"], "loadList3D": [] };
          view.SurpriseRewardViewUI = SurpriseRewardViewUI;
          REG("ui.view.SurpriseRewardViewUI", SurpriseRewardViewUI);
          class TaskViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(TaskViewUI.uiView);
              }
          }
          TaskViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "width": 1334, "var": "centerBox", "height": 750, "centerY": -51, "centerX": 0 }, "compId": 51, "child": [{ "type": "Sprite", "props": { "y": 57, "x": 112, "texture": "resource/task/bg_diban.png" }, "compId": 133 }, { "type": "Image", "props": { "y": 289, "x": 756, "var": "img_light", "skin": "task/guang.png", "rotation": 0, "blendMode": "lighter", "anchorY": 0.5, "anchorX": 0.5, "alpha": 1 }, "compId": 195 }, { "type": "Panel", "props": { "y": 426, "x": 254, "width": 829, "var": "panel", "height": 150 }, "compId": 106, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 1285, "var": "box", "sizeGrid": "355,30,25,260", "height": 191 }, "compId": 53 }] }, { "type": "Panel", "props": { "y": 397, "x": 353, "width": 626, "height": 40 }, "compId": 159, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 851, "var": "lvBox", "sizeGrid": "355,30,25,260", "height": 40 }, "compId": 160, "child": [{ "type": "Image", "props": { "y": 20, "x": 0, "width": 1040, "var": "img_lvBg", "skin": "task/jindu1.png", "height": 6, "anchorY": 0.5, "anchorX": 0, "sizeGrid": "2,2,2,2" }, "compId": 164 }, { "type": "Image", "props": { "y": 20, "x": 0, "width": 0, "var": "img_lvBg1", "skin": "task/jindu2.png", "height": 6, "anchorY": 0.5, "anchorX": 0, "sizeGrid": "2,2,2,2" }, "compId": 163 }] }] }, { "type": "Button", "props": { "y": 343, "x": 976, "visible": false, "var": "btn_get", "stateNum": 1, "skin": "task/lingqu.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 114 }, { "type": "Image", "props": { "y": 343, "x": 976, "visible": false, "var": "img_noGet", "skin": "task/img_noget.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 196 }, { "type": "Image", "props": { "y": 151, "x": 272, "width": 88, "skin": "task/dengjiqiangmingdiban.png", "height": 26, "sizeGrid": "10,8,10,8" }, "compId": 117 }, { "type": "Image", "props": { "y": 164, "x": 426, "width": 120, "var": "btn_refresh", "skin": "task/renwushuaxindiban.png", "height": 26, "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "10,11,10,11" }, "compId": 118, "child": [{ "type": "Label", "props": { "y": 13, "x": 2, "valign": "middle", "text": "任务刷新", "fontSize": 22, "color": "#fff583", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "center" }, "compId": 120 }, { "type": "Sprite", "props": { "y": 2, "x": 93, "texture": "task/kanshipin2.png" }, "compId": 121 }] }, { "type": "Image", "props": { "y": 151, "x": 653.5, "width": 205, "skin": "task/dengjiqiangmingdiban.png", "height": 26, "sizeGrid": "10,8,10,8" }, "compId": 123 }, { "type": "Button", "props": { "y": 75, "x": 1105, "width": 42, "var": "btn_close", "stateNum": 1, "skin": "home/guanbi.png", "height": 42, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 108 }, { "type": "Label", "props": { "y": 200, "x": 949.6162109375, "var": "lab_time", "valign": "middle", "text": "16天4小时00小时00分钟00秒", "fontSize": 20, "color": "#d9eed3", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 111 }, { "type": "List", "props": { "y": 183, "x": 247, "width": 408, "var": "list", "spaceY": 5, "height": 200, "elasticEnabled": true }, "compId": 113, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 316, "name": "render", "height": 34 }, "compId": 126, "child": [{ "type": "Image", "props": { "y": 0, "x": 1, "width": 314, "skin": "task/renwudiban.png", "height": 33, "sizeGrid": "10,10,10,10" }, "compId": 127 }, { "type": "Image", "props": { "y": 16, "x": 369, "width": 70, "visible": false, "skin": "task/qianwangdiban.png", "name": "btn_get", "height": 30, "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "12,10,12,10" }, "compId": 130, "child": [{ "type": "Label", "props": { "y": 15, "x": 35, "width": 47, "visible": true, "valign": "middle", "text": "完成", "height": 28, "fontSize": 19, "color": "#925b00", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 174 }] }, { "type": "Image", "props": { "y": 16, "x": 369, "width": 70, "visible": false, "skin": "task/qianwangdiban.png", "name": "img_reward", "height": 30, "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "12,10,12,10" }, "compId": 131 }, { "type": "Image", "props": { "y": 16.8, "x": 312.4, "skin": "task/jiangli.png", "scaleY": 1.2, "scaleX": 1.2, "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "10,14,10,14" }, "compId": 173 }, { "type": "Label", "props": { "y": 17.3, "x": 6, "width": 195, "valign": "middle", "text": "完成三局游戏", "overflow": "hidden", "name": "lab_desc", "height": 18, "fontSize": 15, "color": "#d9eed3", "bold": true, "anchorY": 0.5, "anchorX": 0, "align": "left" }, "compId": 128 }, { "type": "Label", "props": { "y": 17.3, "x": 241, "width": 68, "valign": "middle", "text": "9999/9999", "overflow": "hidden", "name": "lab_cnt", "height": 28, "fontSize": 15, "color": "#d9eed3", "bold": false, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 129 }, { "type": "Label", "props": { "y": 16.8, "x": 311.4, "valign": "middle", "text": "+30", "name": "lab_reward", "fontSize": 12, "color": "#7f4f10", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 132 }] }] }, { "type": "Label", "props": { "y": 164, "x": 756, "var": "lab_reward", "valign": "middle", "text": "mp5_特种迷你彩版", "fontSize": 20, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 124 }, { "type": "Label", "props": { "y": 164, "x": 315, "var": "lab_lv", "valign": "middle", "text": "lv.1", "fontSize": 20, "color": "#d9eed3", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 119 }, { "type": "Image", "props": { "y": 287.5, "x": 756, "visible": false, "var": "img_icon", "skin": "icon/icon_ticket.png", "scaleY": 1, "scaleX": 1, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 125 }, { "type": "Label", "props": { "y": 168, "x": 949.6162109375, "valign": "middle", "text": "倒计时", "fontSize": 26, "color": "#d9eed3", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "left" }, "compId": 171 }] }], "loadList": ["resource/task/bg_diban.png", "task/guang.png", "task/jindu1.png", "task/jindu2.png", "task/lingqu.png", "task/img_noget.png", "task/dengjiqiangmingdiban.png", "task/renwushuaxindiban.png", "task/kanshipin2.png", "home/guanbi.png", "task/renwudiban.png", "task/qianwangdiban.png", "task/jiangli.png", "icon/icon_ticket.png"], "loadList3D": [] };
          view.TaskViewUI = TaskViewUI;
          REG("ui.view.TaskViewUI", TaskViewUI);
          class TrialViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(TrialViewUI.uiView);
              }
          }
          TrialViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "resource/trial/Trail_BG.png", "right": 0, "left": 0, "bottom": 0 }, "compId": 25 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 21, "child": [{ "type": "Image", "props": { "y": 199, "x": 212, "skin": "trial/bg_yellow.png" }, "compId": 6 }, { "type": "Image", "props": { "y": 209, "x": 512, "skin": "trial/bg_green.png" }, "compId": 7 }, { "type": "Image", "props": { "y": 210, "x": 713, "skin": "trial/bg_green.png" }, "compId": 8 }, { "type": "Image", "props": { "y": 210, "x": 916.10546875, "skin": "trial/bg_green.png" }, "compId": 9 }, { "type": "Image", "props": { "y": 587, "x": 355, "width": 158, "var": "btn_get1", "skin": "trial/btn_ad.png", "height": 54, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 10 }, { "type": "Image", "props": { "y": 506, "x": 593, "width": 158, "var": "btn_get2", "skin": "trial/btn_ad.png", "height": 54, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 12 }, { "type": "Image", "props": { "y": 506, "x": 794, "width": 158, "var": "btn_get3", "skin": "trial/btn_ad.png", "height": 54, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 11 }, { "type": "Image", "props": { "y": 506, "x": 996, "width": 158, "var": "btn_get4", "skin": "trial/btn_ad.png", "height": 54, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 13 }, { "type": "Image", "props": { "y": 639, "x": 781, "var": "btn_refuse", "skin": "trial/btn_refuse.png", "scaleY": 1.5, "scaleX": 1.5, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 17 }, { "type": "Image", "props": { "y": 586, "x": 795, "visible": false, "var": "btn_getAll", "skin": "resource/trial/btn_getAll.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 16 }, { "type": "Image", "props": { "y": 335, "x": 372, "width": 256, "var": "img_icon1", "height": 256, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 22 }, { "type": "Image", "props": { "y": 310, "x": 615, "var": "img_icon2", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 27 }, { "type": "Image", "props": { "y": 310, "x": 815, "var": "img_icon3", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 28 }, { "type": "Image", "props": { "y": 310, "x": 1004, "var": "img_icon4", "scaleY": 0.6, "scaleX": 0.6, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 29 }, { "type": "Label", "props": { "y": 452, "x": 272, "wordWrap": true, "width": 186, "var": "itemName1", "text": "MGL140000(收藏)", "strokeColor": "#6e6161", "stroke": 4, "name": "itemName1", "height": 70, "fontSize": 32, "color": "#ffffff", "bold": true, "align": "center" }, "compId": 14 }, { "type": "Label", "props": { "y": 425, "x": 599, "width": 155, "var": "itemName2", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "height": 40, "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 35 }, { "type": "Label", "props": { "y": 425, "x": 800, "width": 155, "var": "itemName3", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "height": 40, "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 34 }, { "type": "Label", "props": { "y": 425, "x": 1004, "width": 155, "var": "itemName4", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "height": 40, "fontSize": 26, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 33 }, { "type": "Label", "props": { "y": 503, "x": 586, "visible": false, "var": "itemNum2", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 40, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 30 }, { "type": "Label", "props": { "y": 513, "x": 834, "visible": false, "var": "itemNum3", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 40, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 31 }, { "type": "Label", "props": { "y": 513, "x": 1081.5, "visible": false, "var": "itemNum4", "valign": "middle", "text": "+2", "strokeColor": "#6e6161", "stroke": 5, "fontSize": 40, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 32 }, { "type": "Label", "props": { "y": 699, "x": 1081.5, "var": "lab_loading", "text": "正在加载中", "fontSize": 40, "color": "#ffffff" }, "compId": 37 }] }], "animations": [{ "nodes": [{ "target": 37, "keyframes": { "visible": [{ "value": false, "tweenMethod": "linearNone", "tween": false, "target": 37, "key": "visible", "index": 0 }], "alpha": [{ "value": 0, "tweenMethod": "linearNone", "tween": true, "target": 37, "key": "alpha", "index": 0 }] } }], "name": "ani1", "id": 1, "frameRate": 24, "action": 2 }], "loadList": ["resource/trial/Trail_BG.png", "trial/bg_yellow.png", "trial/bg_green.png", "trial/btn_ad.png", "trial/btn_refuse.png", "resource/trial/btn_getAll.png"], "loadList3D": [] };
          view.TrialViewUI = TrialViewUI;
          REG("ui.view.TrialViewUI", TrialViewUI);
          class TrialWeaponDialogUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(TrialWeaponDialogUI.uiView);
              }
          }
          TrialWeaponDialogUI.uiView = { "type": "UIBaseView", "props": { "width": 1334, "top": 0, "runtime": "", "right": 0, "left": 0, "height": 750, "bottom": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "top": 0, "skin": "common/blank_2.png", "right": 0, "left": 0, "bottom": 0, "alpha": 0.8, "sizeGrid": "2,2,2,2" }, "compId": 9 }, { "type": "Box", "props": { "width": 1334, "height": 750, "centerY": 0, "centerX": 0 }, "compId": 10, "child": [{ "type": "Image", "props": { "y": 36, "skin": "resource/trial/trial_weapon.png", "centerX": 0 }, "compId": 3 }, { "type": "Image", "props": { "y": 643, "x": 815, "var": "btn_get", "skin": "comp/btn_ad.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 5 }, { "type": "Image", "props": { "y": 425, "x": 827, "var": "img_icon", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 7 }, { "type": "Label", "props": { "y": 704, "x": 820, "var": "btn_refuse", "underline": true, "text": "残忍拒绝", "fontSize": 22, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 6 }, { "type": "Label", "props": { "y": 512, "x": 725, "wordWrap": true, "width": 182, "var": "lab_name", "valign": "middle", "text": "M4A1", "height": 57, "fontSize": 26, "color": "#ffffff", "align": "center" }, "compId": 8 }] }], "loadList": ["common/blank_2.png", "resource/trial/trial_weapon.png", "comp/btn_ad.png"], "loadList3D": [] };
          view.TrialWeaponDialogUI = TrialWeaponDialogUI;
          REG("ui.view.TrialWeaponDialogUI", TrialWeaponDialogUI);
          class TwoBtnTipsUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(TwoBtnTipsUI.uiView);
              }
          }
          TwoBtnTipsUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "width": 1334, "top": 0, "runtime": "", "right": 0, "mouseThrough": false, "mouseEnabled": true, "left": 0, "height": 750, "drawCallOptimize": true, "bottom": 0 }, "compId": 2, "child": [{ "type": "Box", "props": { "y": 225, "x": 317, "width": 700, "height": 300, "centerY": 0, "centerX": 0 }, "compId": 36, "child": [{ "type": "Image", "props": { "y": 0, "x": 0, "width": 700, "skin": "common/img_common_backBg.png", "height": 300, "sizeGrid": "25,25,25,25" }, "compId": 32 }, { "type": "Label", "props": { "y": 75, "x": 350, "wordWrap": true, "width": 700, "var": "lab_desc", "valign": "middle", "text": "刷新后进行中的任务进度可能会丢失", "overflow": "hidden", "height": 113, "fontSize": 40, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 35 }, { "type": "Label", "props": { "y": 197, "x": 470, "width": 95, "var": "btn_cancel", "valign": "middle", "text": "取消", "height": 40, "fontSize": 40, "color": "#ffe214", "centerX": 120, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 38 }, { "type": "Label", "props": { "y": 197, "x": 230, "width": 95, "var": "btn_accept", "valign": "middle", "text": "确定", "height": 40, "fontSize": 40, "color": "#ffe214", "centerX": -120, "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 39 }] }], "loadList": ["common/img_common_backBg.png"], "loadList3D": [] };
          view.TwoBtnTipsUI = TwoBtnTipsUI;
          REG("ui.view.TwoBtnTipsUI", TwoBtnTipsUI);
          class WeaponInfoViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(WeaponInfoViewUI.uiView);
              }
          }
          WeaponInfoViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 1334, "runtime": "", "height": 750, "drawCallOptimize": true, "centerY": 0, "centerX": 0 }, "compId": 2, "child": [{ "type": "Button", "props": { "y": 108, "x": 451.5, "var": "btn_back", "stateNum": 1, "skin": "common/img_red.png", "sizeGrid": "0,5,0,24" }, "compId": 5 }, { "type": "Image", "props": { "y": 185, "x": 465, "width": 694, "skin": "common/img_back_kuang.png", "height": 403, "sizeGrid": "3,3,3,3" }, "compId": 13 }, { "type": "Image", "props": { "y": 190, "x": 653, "width": 501, "skin": "common/img_back_kuang.png", "height": 392, "sizeGrid": "3,3,3,3" }, "compId": 33 }, { "type": "Image", "props": { "y": 190, "x": 471, "width": 180, "skin": "common/img_back_kuang.png", "height": 100, "sizeGrid": "3,3,3,3" }, "compId": 34 }, { "type": "Image", "props": { "y": 292, "x": 471, "width": 180, "skin": "common/img_back_kuang.png", "height": 290, "sizeGrid": "3,3,3,3" }, "compId": 35 }, { "type": "ProgressBar", "props": { "y": 340, "x": 547, "width": 100, "var": "pro_accuracy", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 49 }, { "type": "ProgressBar", "props": { "y": 368, "x": 547, "width": 100, "var": "pro_gunPower", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 50 }, { "type": "ProgressBar", "props": { "y": 396, "x": 547, "width": 100, "var": "pro_gunFiring", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 51 }, { "type": "ProgressBar", "props": { "y": 424, "x": 547, "width": 100, "var": "pro_gunRecoilInte", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 52 }, { "type": "ProgressBar", "props": { "y": 453, "x": 547, "width": 100, "var": "pro_gunPortability", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 53 }, { "type": "ProgressBar", "props": { "y": 481, "x": 547, "width": 100, "var": "pro_magazineClip", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 54 }, { "type": "ProgressBar", "props": { "y": 509, "x": 547, "width": 100, "var": "pro_magazine", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 55 }, { "type": "ProgressBar", "props": { "y": 537, "x": 547, "width": 100, "var": "pro_reloadingTime", "value": 0.3, "skin": "common/progress.png", "height": 5, "sizeGrid": "0,2,0,2" }, "compId": 56 }, { "type": "Label", "props": { "y": 276, "x": 648, "var": "lab_name", "valign": "middle", "text": "M4A1", "fontSize": 20, "color": "#ec14ff", "anchorY": 0.5, "anchorX": 1, "align": "right" }, "compId": 37 }, { "type": "Label", "props": { "y": 314, "x": 594, "width": 45, "var": "lab_quality", "valign": "middle", "text": "限量级", "height": 15, "fontSize": 15, "color": "#ec14ff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 38 }, { "type": "Label", "props": { "y": 314, "x": 511, "valign": "middle", "text": "武器品质:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 39 }, { "type": "Label", "props": { "y": 342, "x": 519, "valign": "middle", "text": "精确度:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 40 }, { "type": "Label", "props": { "y": 370, "x": 526, "valign": "middle", "text": "威力:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 41 }, { "type": "Label", "props": { "y": 398, "x": 526, "valign": "middle", "text": "射速:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 42 }, { "type": "Label", "props": { "y": 426, "x": 511, "valign": "middle", "text": "后座稳定:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 43 }, { "type": "Label", "props": { "y": 454, "x": 511, "valign": "middle", "text": "轻便程度:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 44 }, { "type": "Label", "props": { "y": 482, "x": 511, "valign": "middle", "text": "弹夹容量:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 45 }, { "type": "List", "props": { "y": 400, "x": 1043, "width": 164, "var": "list", "height": 337, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 72, "child": [{ "type": "Box", "props": { "y": 0, "x": 0, "width": 164, "name": "render", "height": 62 }, "compId": 73, "child": [{ "type": "Image", "props": { "y": 1, "x": 2, "width": 160, "skin": "common/img_back_kuang.png", "height": 60, "sizeGrid": "3,3,3,3" }, "compId": 74 }] }] }, { "type": "Label", "props": { "y": 510, "x": 511, "valign": "middle", "text": "备用弹夹:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 46 }, { "type": "Label", "props": { "y": 538, "x": 511, "valign": "middle", "text": "换弹速度:", "fontSize": 15, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 47 }, { "type": "Image", "props": { "y": 206, "x": 667, "width": 84, "skin": "common/img_white_kuang.png", "height": 79, "sizeGrid": "10,10,10,10" }, "compId": 57, "child": [{ "type": "Label", "props": { "y": 11, "x": 23, "valign": "middle", "text": "枪托", "fontSize": 14, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 63 }] }, { "type": "Image", "props": { "y": 206, "x": 754, "width": 84, "skin": "common/img_white_kuang.png", "height": 79, "sizeGrid": "10,10,10,10" }, "compId": 58, "child": [{ "type": "Label", "props": { "y": 11, "x": 23, "valign": "middle", "text": "瞄具", "fontSize": 14, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 64 }] }, { "type": "Image", "props": { "y": 206, "x": 840, "width": 84, "skin": "common/img_white_kuang.png", "height": 79, "sizeGrid": "10,10,10,10" }, "compId": 59, "child": [{ "type": "Label", "props": { "y": 11, "x": 23, "valign": "middle", "text": "枪管", "fontSize": 14, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 65 }] }, { "type": "Image", "props": { "y": 231, "x": 959, "width": 169, "skin": "common/img_white_kuang.png", "height": 339, "sizeGrid": "10,10,10,10" }, "compId": 60, "child": [{ "type": "Label", "props": { "y": -15, "x": 88, "valign": "middle", "text": "可用配件列表", "fontSize": 14, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 66 }] }, { "type": "Image", "props": { "y": 488, "x": 670, "width": 81, "skin": "common/img_white_kuang.png", "height": 82, "sizeGrid": "10,10,10,10" }, "compId": 61, "child": [{ "type": "Label", "props": { "y": 14, "x": 19, "valign": "middle", "text": "弹匣", "fontSize": 14, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 67 }] }, { "type": "Image", "props": { "y": 501, "x": 842, "width": 80, "visible": false, "skin": "common/img_red_kuang.png", "height": 50, "sizeGrid": "10,10,10,10" }, "compId": 69, "child": [{ "type": "Label", "props": { "y": 25, "x": 40, "valign": "middle", "text": "回收", "fontSize": 18, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 70 }] }, { "type": "Image", "props": { "y": 488, "x": 755.5, "width": 81, "skin": "common/img_white_kuang.png", "height": 82, "sizeGrid": "10,10,10,10" }, "compId": 62, "child": [{ "type": "Label", "props": { "y": 14, "x": 21, "valign": "middle", "text": "护木", "fontSize": 14, "color": "#000000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 68 }] }, { "type": "Image", "props": { "y": 234, "x": 561, "width": 150, "var": "icon", "height": 90, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 36 }], "loadList": ["common/img_red.png", "common/img_back_kuang.png", "common/progress.png", "common/img_white_kuang.png", "common/img_red_kuang.png"], "loadList3D": [] };
          view.WeaponInfoViewUI = WeaponInfoViewUI;
          REG("ui.view.WeaponInfoViewUI", WeaponInfoViewUI);
          class WxLimitTimeGetViewUI extends Laya.UIBaseView {
              constructor() { super(); }
              createChildren() {
                  super.createChildren();
                  this.createView(WxLimitTimeGetViewUI.uiView);
              }
          }
          WxLimitTimeGetViewUI.uiView = { "type": "UIBaseView", "props": { "y": 0, "x": 0, "width": 748, "runtime": "", "height": 570, "centerY": 0, "centerX": 0 }, "compId": 2, "child": [{ "type": "Image", "props": { "y": 0, "x": -5, "width": 583, "skin": "resource/home/beijingkuang1.png", "scaleY": 1.3, "scaleX": 1.3, "height": 390 }, "compId": 234 }, { "type": "Image", "props": { "y": 44, "x": 370, "skin": "home/zidan.png" }, "compId": 235 }, { "type": "Sprite", "props": { "y": 53, "x": 45, "texture": "home/kuang1.png" }, "compId": 236 }, { "type": "Sprite", "props": { "y": 46, "x": 64, "texture": "home/kuang2.png" }, "compId": 237 }, { "type": "Button", "props": { "y": 37, "x": 717, "var": "btn_close", "stateNum": 1, "skin": "home/guanbi.png", "anchorY": 0.5, "anchorX": 0.5 }, "compId": 238 }, { "type": "Sprite", "props": { "y": 53, "x": 379, "texture": "home/kuang1.png" }, "compId": 239 }, { "type": "Sprite", "props": { "y": 46, "x": 344, "texture": "home/kuang2.png" }, "compId": 240 }, { "type": "Image", "props": { "y": 419, "x": 189, "width": 164, "skin": "home/jindutiao1.png", "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "1,1,1,1" }, "compId": 248 }, { "type": "Image", "props": { "y": 418, "x": 107, "width": 164, "var": "pro_tank", "skin": "home/jindutiao2.png", "anchorY": 0.5, "anchorX": 0, "sizeGrid": "1,1,2,1" }, "compId": 249 }, { "type": "Image", "props": { "y": 413, "x": 188, "skin": "home/jindutiao.png" }, "compId": 250 }, { "type": "Image", "props": { "y": 418, "x": 561, "width": 164, "skin": "home/jindutiao1.png", "anchorY": 0.5, "anchorX": 0.5, "sizeGrid": "1,1,1,1" }, "compId": 251 }, { "type": "Image", "props": { "y": 418, "x": 479, "width": 164, "var": "pro_air", "skin": "home/jindutiao2.png", "anchorY": 0.5, "anchorX": 0, "sizeGrid": "1,1,2,1" }, "compId": 252 }, { "type": "Image", "props": { "y": 412, "x": 560, "skin": "home/jindutiao.png" }, "compId": 253 }, { "type": "Button", "props": { "y": 530, "x": 188, "var": "btn_getTank", "stateNum": 1, "skin": "comp/lingquanniu.png", "scaleY": 0.8, "scaleX": 0.8, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 241, "child": [{ "type": "Label", "props": { "y": 46, "x": 128, "text": "查看广告", "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 258 }, { "type": "Image", "props": { "y": 46, "x": 47, "skin": "home/shipin.png", "scaleY": 1.2, "scaleX": 1.2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 259 }] }, { "type": "Button", "props": { "y": 530, "x": 560, "var": "btn_getAir", "stateNum": 1, "skin": "comp/lingquanniu.png", "scaleY": 0.8, "scaleX": 0.8, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 242, "child": [{ "type": "Label", "props": { "y": 46, "x": 128, "text": "查看广告", "fontSize": 32, "color": "#ffffff", "bold": true, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 260 }, { "type": "Image", "props": { "y": 46, "x": 47, "skin": "home/shipin.png", "scaleY": 1.2, "scaleX": 1.2, "anchorY": 0.5, "anchorX": 0.5 }, "compId": 261 }] }, { "type": "Label", "props": { "y": 419, "x": 287, "valign": "middle", "text": "/2", "fontSize": 12, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 254 }, { "type": "Label", "props": { "y": 418, "x": 660, "valign": "middle", "text": "/2", "fontSize": 12, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 255 }, { "type": "Label", "props": { "y": 419, "x": 278, "var": "lab_tankCnt", "valign": "middle", "text": "1", "fontSize": 12, "color": "#fff000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 256 }, { "type": "Label", "props": { "y": 418, "x": 652, "var": "lab_airCnt", "valign": "middle", "text": "0", "fontSize": 12, "color": "#fff000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 257 }, { "type": "Label", "props": { "y": 69, "x": 227, "valign": "middle", "text": "限时!30分钟!", "fontSize": 40, "color": "#fff000", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 243 }, { "type": "Label", "props": { "y": 113, "x": 152, "valign": "middle", "text": "永久", "fontSize": 40, "color": "#ffb62a", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 244 }, { "type": "Label", "props": { "y": 113, "x": 352, "valign": "middle", "text": "获得坦克、飞机的驾驶资格", "fontSize": 25, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 245 }, { "type": "Label", "props": { "y": 442, "x": 188, "valign": "middle", "text": "累计看两次视频永久激活", "fontSize": 12, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 246 }, { "type": "Label", "props": { "y": 442, "x": 560, "valign": "middle", "text": "累计看两次视频永久激活", "fontSize": 12, "color": "#ffffff", "anchorY": 0.5, "anchorX": 0.5, "align": "center" }, "compId": 247 }], "loadList": ["resource/home/beijingkuang1.png", "home/zidan.png", "home/kuang1.png", "home/kuang2.png", "home/guanbi.png", "home/jindutiao1.png", "home/jindutiao2.png", "home/jindutiao.png", "comp/lingquanniu.png", "home/shipin.png"], "loadList3D": [] };
          view.WxLimitTimeGetViewUI = WxLimitTimeGetViewUI;
          REG("ui.view.WxLimitTimeGetViewUI", WxLimitTimeGetViewUI);
      })(view = ui.view || (ui.view = {}));
  })(ui || (ui = {}));

  class AK_Gold_ef extends ui.Ani.AK_Gold_efUI {
      onAwake() { }
  }

  class GameCountdown_ani extends ui.Ani.GameCountdown_aniUI {
      onAwake() {
          this.visible = true;
          this.ani1.on(Laya.Event.COMPLETE, this, this.completeAni);
          this.ani1.play(120);
      }
      completeAni() {
          this.visible = false;
      }
  }

  class HeadShot_ef extends ui.Ani.HeadShot_efUI {
      onAwake() {
          this.visible = false;
          let self = this;
          Laya.timer.frameOnce(2, this, function () {
              self.x = Laya.stage.width / 2;
          });
      }
      setAni() {
          this.visible = true;
          this.ani1.gotoAndStop(0);
          this.ani1.play(0, false);
      }
  }

  class KillFont_ef extends ui.Ani.KillFont_efUI {
      onAwake() {
          this.visible = false;
          let self = this;
          Laya.timer.frameOnce(2, this, function () {
              self.x = Laya.stage.width / 2;
          });
      }
      setAni() {
          this.visible = true;
          this.ani1.gotoAndStop(0);
          this.ani1.play(0, false);
      }
  }

  class Ready_ani extends ui.Ani.Ready_aniUI {
      onAwake() {
          this.ani1.gotoAndStop(0);
      }
      setAni() {
          this.ani1.play(0, false);
      }
      stopAni() {
          this.ani1.stop();
      }
  }

  class TipView extends Laya.View {
      constructor() {
          super();
          var width = 800, height = 80;
          var img = new Laya.Image('common/blank.png');
          img.width = width;
          img.height = height;
          var txt = new Laya.Text();
          txt.fontSize = 36;
          txt.wordWrap = true;
          txt.color = '#FFFFFF';
          txt.width = width;
          txt.height = height;
          txt.align = 'center';
          txt.valign = 'middle';
          this.addChild(img);
          this.addChild(txt);
          this.width = width;
          this.height = height;
      }
      set text(text) {
          this['_children'][1].text = text;
      }
      play(call, thisObj) {
          var self = this;
          self.scale(0.8, 0.8);
          self.alpha = 1;
          Tween.get(self)
              .to({
              scaleX: 1,
              scaleY: 1
          }, 200, Tween.turnEase(Laya.Ease.backOut))
              .wait(400)
              .to({
              alpha: 0
          }, 400)
              .call(call, thisObj, null);
      }
  }

  class UIMgr {
      static checkView(ui) {
          var mgr = Laya.MouseManager;
          if (mgr.enabled) {
              mgr.enabled = false;
              Utils.uiEnableCall(ui, function () {
                  mgr.enabled = true;
              }, null);
          }
      }
      static checkBanner(ui, bool) { }
      static setBannerVisible(isVisible, isClick = false) { }
      static checkMask(ui) {
          var config = ui.$uiConfig;
          config && config.mask ? UIMgr.showMaskBg(ui) : UIMgr.hideMaskBg();
      }
      static checkTop(topUI) {
          var curTop = UIMgr.topUI();
          if (topUI == curTop && curTop) {
              UIMgr.checkMask(topUI);
              UIMgr.refreshTopShow();
          }
      }
      static checkTopShow() {
          var curTop = UIMgr.topUI();
          UIMgr.checkMask(curTop);
          UIMgr.refreshTopShow();
      }
      static refreshTopShow() {
          var curTop = UIMgr.topUI();
          curTop.onShow();
      }
      static showSideList(ui) { }
      static hideSideList() { }
      static onUIClose(ui) {
          var config = ui.$uiConfig;
          var tween = config && config.tween;
          if (tween) {
              UIMgr.hideTween(ui);
          }
          else {
              UIMgr.destroyUI(ui);
          }
      }
      static destroyUI(ui) {
          var list = ui._aniList;
          UIMgr.checkBanner(ui, false);
          if (list) {
              for (let i = 0, len = list.length; i < len; i++) {
                  let ani = list[i];
                  if (ani instanceof Laya.AnimationBase)
                      ani.clear();
              }
              ui._aniList = null;
          }
          Laya.timer.clearAll(ui);
          Laya.stage.removeChild(ui);
          Tween.clearAll(ui);
          ui.close();
          ui.destroy(true);
      }
      static showTween(ui) {
          Utils.uiEnableCall(ui, UIMgr.onShowTween, UIMgr, ui);
      }
      static onShowTween(ui) {
          var stage = Laya.stage;
          if (isNaN(ui.anchorX)) {
              ui.anchorX = 0.5;
              ui.x += ui.width / 2;
          }
          if (isNaN(ui.anchorY)) {
              ui.anchorY = 0.5;
              ui.y += ui.height / 2;
          }
          ui.scale(0, 0);
          stage.mouseEnabled = false;
          Tween.get(ui, {})
              .to({
              scaleX: 1,
              scaleY: 1
          }, 300, Tween.turnEase(Laya.Ease.backOut))
              .call(function () {
              stage.mouseEnabled = true;
              ui.anchorX = ui.anchorY = 0.5;
              ui.x = Laya.stage.width / 2;
              ui.y = Laya.stage.height / 2;
              UIMgr.checkBanner(UIMgr.topUI(), true);
              ui.onTweenCom();
          }, null, null);
      }
      static hideTween(ui) {
          var stage = Laya.stage;
          UIMgr.showMaskBg(ui);
          stage.mouseEnabled = false;
          Tween.get(ui, {})
              .to({
              scaleX: 0,
              scaleY: 0
          }, 300, Tween.turnEase(Laya.Ease.backIn))
              .call(function () {
              UIMgr.destroyUI(ui);
              stage.mouseEnabled = true;
              UIMgr.checkTopShow();
          }, null, null);
      }
      static showMaskBg(ui) {
          var mask = UIMgr._maskBg;
          var stage = Laya.stage;
          if (!mask) {
              mask = UIMgr._maskBg = new Laya.Image('common/blank_2.png');
              mask.sizeGrid = '2,2,2,2';
              mask.size(stage.width + 20, stage.height + 20);
              mask.pos(-10, -10);
              mask.alpha = 0.7;
              mask.name = 'maskBg';
              mask.on(Laya.Event.MOUSE_DOWN, UIMgr, UIMgr.onStMask);
          }
          stage.addChild(mask);
          mask.zOrder = ui.zOrder;
          stage.setChildIndex(mask, stage.getChildIndex(ui));
      }
      static hideMaskBg() {
          var mask = UIMgr._maskBg;
          mask && mask.removeSelf();
      }
      static onStMask(e) {
          e.stopPropagation();
      }
      static openUI(uiConfig, data = null, visible = true) {
          if (uiConfig == undefined || uiConfig == null)
              return;
          let old = UIMgr.findUI(uiConfig);
          if (old) {
              console.error('so quick', uiConfig);
              return;
          }
          return UIMgr.createUI(uiConfig, data, visible);
      }
      static createUI(uiConfig, data = null, visible = true) {
          let clzz = Laya.ClassUtils.getRegClass(uiConfig.class);
          if (clzz && clzz.prototype instanceof Laya.Sprite) {
              let ui = new clzz();
              let top = UIMgr.topUI();
              ui.dataSource = data;
              ui.zOrder = UIMgr._zOrder++;
              ui.visible = visible !== false;
              ui.$uiConfig = uiConfig;
              Laya.stage.addChild(ui);
              UIMgr._uiArray.push(ui);
              UIMgr.checkMask(ui);
              UIMgr.checkView(ui);
              top && top.onHide();
              let topUi = UIMgr.topUI();
              if (uiConfig.tween) {
                  UIMgr.showTween(ui);
              }
              else {
                  if (topUi == ui) {
                      UIMgr.checkBanner(topUi, true);
                  }
              }
              if (topUi == ui) {
                  UIMgr.checkTop(UIMgr.topUI());
              }
              return ui;
          }
          else {
              console.error('openUI error', uiConfig);
              return null;
          }
      }
      static closeUI(uiConfig) {
          var isTop = false;
          if (uiConfig) {
              let _uiArray = UIMgr._uiArray;
              for (let endi = _uiArray.length - 1, i = endi; i >= 0; i--) {
                  let ui = _uiArray[i];
                  if (ui.$uiConfig == uiConfig) {
                      _uiArray.splice(i, 1);
                      UIMgr.onUIClose(ui);
                      isTop = i == endi;
                      break;
                  }
              }
          }
          if (isTop) {
              UIMgr.checkTop(UIMgr.topUI());
          }
      }
      static updateUI(uiConfig, data = null) {
          var view = UIMgr.findUI(uiConfig);
          if (view) {
              UIMgr.setTop(uiConfig);
          }
          else
              UIMgr.openUI(uiConfig, data);
      }
      static toUI(uiConfig, data) {
          var array = UIMgr._uiArray, oldUI;
          for (let i = array.length - 1; i >= 0; i--) {
              let ui = array[i];
              if (ui.$uiConfig != uiConfig) {
                  UIMgr.onUIClose(ui);
                  array.splice(i, 1);
              }
              else {
                  oldUI = ui;
                  data !== void 0 && (ui.dataSource = data);
              }
          }
          if (oldUI) {
              UIMgr.checkTop(oldUI);
          }
          else {
              oldUI = UIMgr.openUI(uiConfig, data);
          }
          return oldUI;
      }
      static showTips(msg) {
          var tips = UIMgr._tipViews;
          if (tips == null) {
              let box = new Laya.Box();
              tips = UIMgr._tipViews = [];
              Laya.stage.addChild(box);
              box.zOrder = UIMgr._tZOrder;
              for (let i = 0; i < 3; i++) {
                  let subBox = new TipView();
                  subBox.alpha = 0;
                  box.addChild(subBox);
                  subBox.anchorX = subBox.anchorY = 0.5;
                  subBox.x = 400;
                  subBox.visible = false;
                  tips.push(subBox);
              }
              box.width = 800;
              box.centerX = 0;
              box.centerY = -20;
          }
          if (tips.length == 0)
              return;
          var txt = tips.shift();
          txt.text = msg;
          txt.visible = true;
          txt.play(function () {
              tips.push(txt);
              txt.visible = false;
          });
      }
      static findUI(uiConfig) {
          if (uiConfig) {
              let _uiArray = UIMgr._uiArray;
              for (let i = _uiArray.length - 1; i >= 0; i--) {
                  let ui = _uiArray[i];
                  if (ui.$uiConfig == uiConfig)
                      return ui;
              }
          }
          return null;
      }
      static setTop(uiConfig) {
          var ui = UIMgr.findUI(uiConfig);
          if (ui) {
              let _uiArray = UIMgr._uiArray;
              let index = _uiArray.indexOf(ui);
              _uiArray.splice(index, 1);
              _uiArray.push(ui);
              ui.visible = true;
              ui.zOrder = UIMgr._zOrder++;
              UIMgr.checkTop(ui);
          }
      }
      static topUI() {
          var array = UIMgr._uiArray;
          var length = array.length;
          if (length > 0)
              return array[length - 1];
      }
  }
  UIMgr._zOrder = 1000;
  UIMgr._tZOrder = 100000;
  UIMgr._uiArray = [];

  class CfgDataMgr {
      constructor() { }
      static get instance() {
          if (CfgDataMgr._instance == null) {
              CfgDataMgr._instance = new CfgDataMgr();
          }
          return CfgDataMgr._instance;
      }
      addConfigs() {
          this.gunAttributeCfg = Laya.loader.getRes(PreEJson.gunAttributeCfg);
          this.professionCfg = Laya.loader.getRes(PreEJson.ProfessionCfg);
          this.shopCfg = Laya.loader.getRes(PreEJson.ShopCfg);
          this.startAdSampleJackpotCfg = Laya.loader.getRes(PreEJson.startAdSampleJackpot);
          this.jackpotCfg = Laya.loader.getRes(PreEJson.JackpotCfg);
          this.resCfg = Laya.loader.getRes(PreEJson.ResCfg);
          this.treasureBoxCfg = Laya.loader.getRes(PreEJson.TreasureBoxCfg);
          this.roleSkillCfg = Laya.loader.getRes(PreEJson.roleSkillCfg);
          this.levelCfg = Laya.loader.getRes(PreEJson.LevelCfg);
          this.dailySignCfg = Laya.loader.getRes(PreEJson.dailySignCfg);
          this.multilayerDiamondCfg = Laya.loader.getRes(PreEJson.multilayerDiamondCfg);
          this.goodsGroupCfg = Laya.loader.getRes(PreEJson.goodsGroupCfg);
          this.constellation = Laya.loader.getRes(PreEJson.Constellation);
          this.lotteryBoxCfg = Laya.loader.getRes(PreEJson.lotteryBoxCfg);
          this.lotteryBoxCirculationRewardCfg = Laya.loader.getRes(PreEJson.LotteryBoxCirculationRewardCfg);
          this.warMakesMissionCfg = Laya.loader.getRes(PreEJson.WarMakesMissionCfg);
          this.warMakesRewardCfg = Laya.loader.getRes(PreEJson.WarMakesRewardCfg);
      }
      initConfigs() {
          this.vehicleCfg = Laya.loader.getRes(EJson.vehicleCfg);
          this.modeinformationCfg = Laya.loader.getRes(EJson.ModeinformationCfg);
          this.detectrangeCfg = Laya.loader.getRes(EJson.DetectrangeCfg);
          this.aiNameCfg = Laya.loader.getRes(EJson.AINameCfg);
          this.bulletCfg = Laya.loader.getRes(EJson.BulletCfg);
          this.aiSkillsCfg = Laya.loader.getRes(EJson.AIskillsCfg);
          this.gunComponentCfg = Laya.loader.getRes(EJson.GunComponentCfg);
          this.coinParamCfg = Laya.loader.getRes(EJson.CoinParamCfg);
          this.supplyPoint_01Cfg = Laya.loader.getRes(EJson.SupplyPoint_01Cfg);
          this.guideCfg = Laya.loader.getRes(EJson.guideCfg);
          this.blindBoxCfg = Laya.loader.getRes(EJson.blindBoxCfg);
          this.initData();
      }
      initGlobalCfg() {
          this.globalCfg = Laya.loader.getRes(JsonRoot + 'global.json');
      }
      initData() {
          this._nameCnt = Object.keys(this.aiNameCfg).length;
      }
      getGlobalCfg(key, defValue = 0) {
          let cfg = this.globalCfg[key];
          return cfg ? cfg.value : defValue;
      }
      getRandomName() {
          let random = Utils.IntRange(1, this._nameCnt);
          return this.aiNameCfg[random].name;
      }
      getLevelCfg(lv) {
          return CfgDataMgr.instance.levelCfg[lv];
      }
      clearLevelCfg(level) {
          let cfg = this.getLevelCfg(level);
          this.spawnpointCfg = null;
          Laya.loader.clearRes(JsonRoot + cfg.spawnpoint);
          for (let i = 0; i < cfg.pathData.length; i++) {
              Laya.loader.clearRes(PathJsonRoot + cfg.pathData[i]);
          }
      }
      randomJackpot(jackpotCfg) {
          let count = 0;
          for (let cfg of jackpotCfg) {
              count += cfg.power;
          }
          let random = Math.random() * count;
          let cnt = 0;
          for (let cfg of jackpotCfg) {
              cnt += cfg.power;
              if (cnt >= random) {
                  return cfg.goods;
              }
          }
      }
  }
  CfgDataMgr._instance = null;

  class UserData {
      constructor() {
          this.isInitComplete = false;
          this.isNewPlayer = false;
          this._isGuide = true;
          this._isFirstGame = false;
          this.trialVocationId = 0;
          this.hasTrialGunArr = new Object();
          this.trialGunArr = [];
          this.trialUseGunId = '';
          this.curTrialVocationId = 0;
          this.isShowBanner = false;
          this.isRefreshIcon = false;
          this.levelNum = 0;
          this.isNeedRefreshTask = false;
          this.wxSide = {};
          this.maxVehLimitCnt = 2;
          this.enterGameTime = 0;
          this.defaultValMap = {};
          this.needSaveMap = {};
          this.cacheTime = 0;
          this.isNeedUpload = true;
          this.gameUseVocationId = 0;
          this.gameUseGunId = '';
          this.gameGunArr = [];
          this._lastGameDate = -1;
          this._level = 1;
          this._passDic = new Object();
          this._freeTrialNum = 0;
          this._deadTrialNum = 0;
          this._signTime = 0;
          this._signArr = [];
          this._curVocationId = 101;
          this._curUseGunId = '';
          this._useGunArr = [];
          this._hasGunArr = new Object();
          this._hasGoodArr = new Object();
          this._hasProfessionArr = [101];
          this._professionStateArr = new Object();
          this._clickDailySkillCnt = 0;
          this._meritorious = 0;
          this._volume = 0;
          this._volumeTime = 0;
          this._shopData = {};
          this._openBoxTime = 0;
          this._gameComCnt = 0;
          this._comGuideGame = false;
          this._clickVideoCnt = 0;
          this._hasConstellationArr = [];
          this._isGetFreeArms = false;
          this._actionId = 0;
          this._taskArr = new Object();
          this._taskExp = 0;
          this._taskLv1 = 1;
          this._taskDay = 0;
          this._taskRewardArr = [];
          this._vehLimitAdArr = [0, 0];
          this._homeShareCnt = 0;
          this._isAddMyGame = 0;
          this.curTime = 0;
          this.curCnt = 0;
          this._puid = 0;
      }
      static get instance() {
          if (UserData._instance == null) {
              UserData._instance = new UserData();
          }
          return UserData._instance;
      }
      init() {
          let self = this;
          let key;
          let isExperienceGuidanceStr = Laya.LocalStorage.getItem('isExperienceGuidance');
          let isExperienceGuidance = Utils.isEmpty(isExperienceGuidanceStr)
              ? true
              : isExperienceGuidanceStr.indexOf('true') != -1
                  ? true
                  : false;
          if (isExperienceGuidance) {
              Laya.LocalStorage.clear();
              Laya.LocalStorage.setItem('isExperienceGuidance', '334411');
          }
          else {
              let isGuideStr = Laya.LocalStorage.getItem('isGuide');
              let isGuide = Utils.isEmpty(isGuideStr)
                  ? true
                  : isGuideStr.indexOf('true') != -1
                      ? true
                      : false;
              if (isGuide) {
                  Laya.LocalStorage.clear();
                  Laya.LocalStorage.setItem('isExperienceGuidance', '334411');
              }
          }
          for (key in this) {
              if (key.indexOf('_') == 0) {
                  let val = Laya.LocalStorage.getItem(key);
                  if (val != null && val.length > 0) {
                      let old = (this.defaultValMap[key] = self[key]);
                      if (typeof old === 'object') {
                          val = JSON.parse(val);
                      }
                      else if (typeof old === 'number' && !isNaN(old)) {
                          val = +val || old;
                      }
                      else if (typeof old === 'boolean') {
                          val = val === 'true';
                      }
                      self[key] = val;
                  }
              }
          }
          this.checkNewPlayer();
          this.formatAll();
          this.cacheTime = this.getCache('cacheTime', false);
          this.checkNewDay();
          Laya.timer.loop(30000, this, this.onUpdate);
          this.enterGameTime = Date.now();
      }
      onUpdate() {
          this.checkNewDay();
          this.saveData('all', true);
      }
      saveData(name, immediately = true) {
          if (!this.isNeedUpload)
              return;
          if (immediately) {
              let key;
              let isCached = false;
              if (name == 'all') {
                  for (key in this.needSaveMap) {
                      this.cacheData(key);
                      delete this.needSaveMap[key];
                      isCached = true;
                  }
              }
              else {
                  this.cacheData(name);
                  delete this.needSaveMap[name];
                  isCached = true;
              }
              if (isCached) {
                  if (!this.isInitComplete)
                      return;
                  this.cacheTime = Date.now();
                  this.uploadToSvr();
                  this.setCache('cacheTime', this.cacheTime + '');
              }
          }
          else {
              this.needSaveMap[name] = name;
          }
      }
      cacheData(key) {
          var value = this[key];
          if (typeof value === 'object')
              value = JSON.stringify(value);
          else
              value += '';
          Laya.LocalStorage.setItem(key, value);
      }
      setCache(key, value) {
          Laya.LocalStorage.setItem(key, value);
      }
      getCache(key, isStr) {
          let str = Laya.LocalStorage.getItem(key);
          if (str == '' || str == null || str == undefined) {
              if (isStr)
                  return '';
              else
                  return 0;
          }
          else {
              if (isStr)
                  return str;
              else
                  return parseInt(str);
          }
      }
      uploadWxData() {
          var kvDataList = [
              {
                  key: 'level',
                  value: '' + this._level
              }
          ];
      }
      parseDataFromSvr(data) {
          if (data.cacheTime == null) {
              data.cacheTime = 0;
          }
          console.log('----------------->parseDataFromSvr:', data);
          if (data.cacheTime < this.cacheTime) {
              return;
          }
          let key;
          let isChange = false;
          for (key in data) {
              if (key.indexOf('_') == 0) {
                  isChange = false;
                  if (this[key] != data[key]) {
                      isChange = true;
                  }
                  this[key] = data[key];
                  if (isChange) {
                      this.cacheData(key);
                  }
                  var setName = 'set' + key;
                  var setFunc = this[setName];
                  if (typeof setFunc == 'function') {
                      setFunc.call(this, data[key]);
                  }
              }
          }
          this.formatAll();
          if (this.cacheTime == 0) {
          }
          EventMgr.event(EventType.RefreshCacheData);
      }
      formatAll() { }
      onUpload() {
          let data = {};
          let key;
          if (this.isNeedUpload) {
              for (key in this) {
                  if (key.indexOf('_') == 0) {
                      data[key] = this[key];
                  }
              }
          }
          else {
              console.info('清空数据');
              for (key in this) {
                  if (key.indexOf('_') == 0) {
                      data[key] = this.defaultValMap[key];
                  }
              }
          }
      }
      uploadToSvr() {
          var self = this, timer = Laya.timer;
          timer.clear(self, self.onUpload);
          timer.once(100, self, self.onUpload);
      }
      clearData() { }
      checkNewDay() {
          var curDate = Date.now();
          if (!TimeUtils.isSameDay(curDate, this._lastGameDate)) {
              this._lastGameDate = curDate;
              this.saveData('_lastGameDate');
              this._shopData = {};
              this.volumeTime = 0;
              this.clickDailySkillCnt = 0;
              this.isNeedRefreshTask = true;
              return true;
          }
      }
      set level(val) {
          this._level = val;
          this.saveData('_level');
      }
      get level() {
          return this._level;
      }
      setPassDic(lv) {
          if (this._passDic[lv]) {
              this._passDic[lv] += 1;
          }
          else {
              this._passDic[lv] = 1;
          }
          this.saveData('_passDic');
      }
      getPass(lv) {
          let time = this._passDic[lv];
          if (time == undefined) {
              time = 0;
          }
          return time;
      }
      get freeTrialNum() {
          return this._freeTrialNum;
      }
      set freeTrialNum(val) {
          this._freeTrialNum = val;
          this.saveData('_freeTrialNum', true);
      }
      get deadTrialNum() {
          return this._deadTrialNum;
      }
      set deadTrialNum(val) {
          this._deadTrialNum = val;
          this.saveData('_deadTrialNum', true);
      }
      get curVocationId() {
          if (this.trialVocationId)
              return this.trialVocationId;
          return this._curVocationId;
      }
      set curVocationId(val) {
          if (this.curTrialVocationId == val) {
              this.trialVocationId = val;
              EventMgr.event(EventType.RefreshHeroModel, val);
              return;
          }
          this._curVocationId = val;
          EventMgr.event(EventType.RefreshHeroModel, val);
          this.saveData('_curVocationId', true);
      }
      get curUseGunId() {
          if (this.trialUseGunId)
              return this.trialUseGunId;
          return this._curUseGunId;
      }
      set curUseGunId(val) {
          if (this.isTrialGun(val)) {
              this.trialUseGunId = val;
              return;
          }
          this._curUseGunId = val;
          this.saveData('_curUseGunId', true);
      }
      getUseGunArr() {
          if (this.trialGunArr.length > 0)
              return this.trialGunArr;
          return this._useGunArr;
      }
      setUseGunArr(index, gunId) {
          if (this.isTrialGun(gunId)) {
              this.trialGunArr[index] = gunId;
              let temp = index == 0 ? 1 : 0;
              if (!this.trialGunArr[temp]) {
                  this.trialGunArr[temp] = this._useGunArr[temp];
              }
              return;
          }
          else {
              let temp = index == 0 ? 1 : 0;
              if (this.isTrialGun(this.trialGunArr[temp])) {
                  this.trialGunArr[index] = gunId;
                  this._useGunArr[index] = gunId;
                  return;
              }
              else {
                  this.trialGunArr.length = 0;
              }
          }
          this._useGunArr[index] = gunId;
          this.saveData('_useGunArr', true);
      }
      get meritorious() {
          return this._meritorious;
      }
      set meritorious(val) {
          this._meritorious = val | 0;
          EventMgr.event(EventType.RefreshMeritorious);
          this.saveData('_meritorious', true);
      }
      addMeritorious(val) {
          if (val > 0) {
              EventMgr.event(EventType.RefreshTaskProgress, [109, val | 0]);
          }
          this.meritorious += val;
      }
      get volume() {
          return this._volume;
      }
      set volume(val) {
          this._volume = val;
          EventMgr.event(EventType.RefreshVolume);
          this.saveData('_volume', true);
      }
      get volumeTime() {
          return this._volumeTime;
      }
      set volumeTime(val) {
          this._volumeTime = val;
          this.saveData('_volumeTime', true);
      }
      get openBoxTime() {
          return this._openBoxTime;
      }
      set openBoxTime(val) {
          this._openBoxTime = val;
          this.saveData('_openBoxTime', true);
      }
      genID(length = 0) {
          let curTime = Date.now();
          if (this.curCnt == curTime) {
              this.curCnt++;
          }
          else {
              this.curTime = curTime;
              this.curCnt = 0;
          }
          return (Number(Math.random().toString().substr(3, length) + Date.now()).toString(36) +
              '_' +
              this.curCnt);
      }
      checkNewPlayer() {
          let isGuide = Laya.LocalStorage.getItem('isGuide');
          this.isGuide = Utils.isEmpty(isGuide) ? true : isGuide.indexOf('true') != -1 ? true : false;
          let newPlayer = Laya.LocalStorage.getItem('newPlayer');
          this.isNewPlayer = !newPlayer;
          if (this.isNewPlayer) {
              Laya.LocalStorage.setItem('newPlayer', '1111');
              this._isFirstGame = this.isNewPlayer;
          }
      }
      addHasGunArr(indexId, data, immediately = false) {
          if (Utils.isEmpty(this._hasGunArr[indexId])) {
              this._hasGunArr[indexId] = data;
              this.saveData('_hasGunArr', immediately);
          }
      }
      get hasGunArr() {
          return this._hasGunArr;
      }
      addGoodArr(data, immediately = false) {
          let indexId = this.genID();
          data.Uid = indexId;
          this._hasGoodArr[indexId] = data;
          this.saveData('_hasGoodArr', immediately);
      }
      getGoodsByType(type) {
          let arr = [];
          for (let key in this._hasGoodArr) {
              let good = this._hasGoodArr[key];
              if (good.goodsType == type) {
                  if (arr.length > 0) {
                      for (let i = 0; i < arr.length; i++) {
                          if (arr[i].id == good.id) {
                              arr[i].num += 1;
                          }
                          else if (i + 1 == arr.length) {
                              arr.push({
                                  id: good.id,
                                  num: 1
                              });
                              break;
                          }
                      }
                  }
                  else {
                      arr.push({
                          id: good.id,
                          num: 1
                      });
                  }
              }
          }
          return arr;
      }
      get hasGoodArr() {
          let arr = [];
          for (let key in this._hasGoodArr) {
              let good = this._hasGoodArr[key];
              if (arr.length > 0) {
                  for (let i = 0; i < arr.length; i++) {
                      if (arr[i].id == good.id) {
                          arr[i].num += 1;
                      }
                      else if (i + 1 == arr.length) {
                          arr.push({
                              id: good.id,
                              num: 1
                          });
                          break;
                      }
                  }
              }
              else {
                  arr.push({
                      id: good.id,
                      num: 1
                  });
              }
          }
          return arr;
      }
      getNum(id) {
          let num = 0;
          for (let key in this._hasGoodArr) {
              let good = this._hasGoodArr[key];
              if (good.id == id) {
                  num++;
              }
          }
          return num;
      }
      consumeGood(goodId) {
          for (let key in this._hasGoodArr) {
              if (this._hasGoodArr[key].id == goodId) {
                  delete this._hasGoodArr[key];
                  this.saveData('_hasGoodArr');
                  return;
              }
          }
          console.log('仓库不存在物品: ' + goodId);
      }
      getGunInfo(indexId) {
          if (Utils.isEmpty(this._hasGunArr[indexId])) {
              if (!Utils.isEmpty(this.hasTrialGunArr[indexId]))
                  return this.hasTrialGunArr[indexId];
              EventMgr.event(Laya.Event.ERROR);
              console.info('===错误枪支ID===', indexId);
              Laya.LocalStorage.clear();
              return null;
          }
          return this._hasGunArr[indexId];
      }
      addGun(gunId) {
          let indexId = this.genID() + gunId;
          let data = {
              id: gunId,
              Uid: indexId,
              time: Date.now(),
              goodsType: 103
          };
          this.addHasGunArr(indexId, data, true);
          return indexId;
      }
      addTrialGun(val) {
          let indexId = this.genID() + val;
          let data = {
              id: val,
              Uid: indexId,
              time: Date.now(),
              goodsType: 103
          };
          this.hasTrialGunArr[indexId] = data;
          return indexId;
      }
      getHasTrialGunArr() {
          return this.hasTrialGunArr;
      }
      addGood(good, num = 1, goodsType = null) {
          let goodId;
          if (good instanceof Array) {
              goodsType = good[0];
              goodId = good[1];
              num = good[2];
          }
          else {
              goodId = good;
          }
          if (!goodsType) {
              let resCfg = CfgDataMgr.instance.resCfg[goodId];
              goodsType = resCfg.goodsType;
          }
          if (goodsType == 1) {
              this.addMeritorious(num);
          }
          else if (goodsType == 2) {
              this.volume += num;
          }
          else if (goodsType == 101 || goodsType == 104) {
              this.addGoodArr({
                  id: goodId,
                  time: Date.now(),
                  goodsType: goodsType
              });
          }
          else if (goodsType == 102) {
              this.addProfessionArr(goodId);
          }
          else if (goodsType == 103) {
              return this.addGun(goodId);
          }
      }
      set isGuide(b) {
          this._isGuide = b;
          this.saveData('isGuide');
      }
      get isGuide() {
          return this._isGuide;
      }
      get shopData() {
          return this._shopData;
      }
      setShopData(index, val) {
          this._shopData[index] = val;
          this.saveData('_shopData');
      }
      isTrialGun(gunId) {
          if (this.hasTrialGunArr[gunId])
              return true;
          return false;
      }
      canSign() {
          return !TimeUtils.isSameDay(Date.now(), this._signTime);
      }
      sign() {
          this._signTime = Date.now();
          this._signArr.push(this._signArr.length + 1);
          this.saveData('_signArr', true);
          this.saveData('_signTime', true);
      }
      getSign() {
          return this._signArr;
      }
      setAccontId(id) {
          this._actionId = id;
          this.saveData('_actionId');
      }
      getAccontId() {
          return this._actionId;
      }
      getHasProfessionArr() {
          return this._hasProfessionArr;
      }
      addProfessionArr(val) {
          if (this._hasProfessionArr.indexOf(val) == -1) {
              this._hasProfessionArr.push(val);
              this.saveData('_hasProfessionArr');
          }
      }
      setProfessionStateArr(ProfessionId, add) {
          let cnt = this._professionStateArr[ProfessionId];
          if (cnt) {
              this._professionStateArr[ProfessionId] = cnt + add;
          }
          else {
              this._professionStateArr[ProfessionId] = add;
          }
          this.saveData('_professionStateArr');
      }
      getProfessionStateArr() {
          return this._professionStateArr;
      }
      get clickDailySkillCnt() {
          return this._clickDailySkillCnt;
      }
      set clickDailySkillCnt(val) {
          this._clickDailySkillCnt = val;
          this.saveData('_clickDailySkillCnt');
      }
      set gameComCnt(val) {
          this._gameComCnt = val;
          this.saveData('_gameComCnt');
      }
      get gameComCnt() {
          return this._gameComCnt;
      }
      set comGuideGame(val) {
          this._comGuideGame = val;
          this.saveData('_comGuideGame');
      }
      get comGuideGame() {
          return this._comGuideGame;
      }
      set clickVideoCnt(val) {
          this._clickVideoCnt = val;
          EventMgr.event(EventType.RefreshTaskProgress, [108, 1]);
          this.saveData('_clickVideoCnt');
      }
      get clickVideoCnt() {
          return this._clickVideoCnt;
      }
      setHasConstellationArr(val) {
          if (this._hasConstellationArr.indexOf(val) == -1) {
              this._hasConstellationArr.push(val);
              this.saveData('_hasConstellationArr');
          }
      }
      get hasConstellationArr() {
          return this._hasConstellationArr;
      }
      get isGetFreeArms() {
          return this._isGetFreeArms;
      }
      set isGetFreeArms(val) {
          this._isGetFreeArms = val;
          this.saveData('_isGetFreeArms');
      }
      getGameUseVocationId() {
          return this.gameUseVocationId;
      }
      setGameUseVocationId(val) {
          this.gameUseVocationId = val;
      }
      getGameUseGunId() {
          return this.gameUseGunId;
      }
      setGameUseGunId(val) {
          if (val === void 0)
              return;
          this.gameUseGunId = val;
      }
      getGameGunArr() {
          return this.gameGunArr;
      }
      setGameGunArr(index, val) {
          if (val === void 0)
              return;
          this.gameGunArr[index] = val;
      }
      clearTaskData() {
          this._taskArr = new Object();
      }
      setTaskArr(index, info) {
          this._taskArr[index] = info;
          this.saveData('_taskArr');
      }
      delOneTask(taskId) {
          delete this._taskArr[taskId];
          this.saveData('_taskArr');
      }
      getAllTaskData() {
          return this._taskArr;
      }
      getOneTaskData(index) {
          return this._taskArr[index];
      }
      get taskExp() {
          return this._taskExp;
      }
      set taskExp(val) {
          this._taskExp = val;
          this.saveData('_taskExp');
      }
      get taskLv() {
          return this._taskLv1;
      }
      set taskLv(val) {
          this._taskLv1 = val;
          this.saveData('_taskLv1');
      }
      get taskDay() {
          return this._taskDay;
      }
      set taskDay(val) {
          this._taskDay = val;
          this.saveData('_taskDay');
      }
      clearTaskReward() {
          this._taskRewardArr = [];
          this.saveData('_taskRewardArr');
      }
      set setTaskReward(val) {
          if (this._taskRewardArr.indexOf(val) == -1) {
              this._taskRewardArr.push(val);
              this.saveData('_taskRewardArr');
          }
      }
      get getTaskReward() {
          return this._taskRewardArr;
      }
      set homeShareCnt(val) {
          this._homeShareCnt = val;
          this.saveData('_homeShareCnt');
      }
      get homeShareCnt() {
          return this._homeShareCnt;
      }
      set IsAddMyGame(val) {
          this._isAddMyGame = val;
          this.saveData('_isAddMyGame');
      }
      get IsAddMyGame() {
          return this._isAddMyGame;
      }
      setVehLimitAdArr(index) {
          this._vehLimitAdArr[index]++;
          this.saveData('_vehLimitAdArr');
      }
      getVehLimitAdArr() {
          return this._vehLimitAdArr;
      }
      checkLimitTime() {
          let data = Date.now();
          if (data - this.enterGameTime >= 30 * 60 * 1000) {
              return true;
          }
          return false;
      }
      get puid() {
          return this._puid;
      }
      set puid(val) {
          this._puid = val;
          this.cacheData('_puid');
      }
      checkAddMyGame(uiMgr) {
          if (this._isAddMyGame == 1 && GameConst.Scene == 3003) {
              uiMgr.openUI(EUI.QQBonusRewardView).setCloseCall(function () {
                  UserData.instance.addMeritorious(100);
                  UserData.instance.IsAddMyGame = 2;
                  EventMgr.event(EventType.RefreshQQBonusIcon);
              });
          }
      }
  }
  UserData._instance = null;

  class xianshilingqu_ef extends ui.Ani.xianshilingqu_efUI {
      onAwake() {
          this.visible = !UserData.instance.checkLimitTime();
          this.on(Laya.Event.CLICK, this, this.onClick);
          EventMgr.on(EventType.RerfreshVehIcon, this, this.onRefresh);
          if (this.visible) {
              let arr = UserData.instance.getVehLimitAdArr();
              if (arr[0] < 2 || arr[1] < 2) {
                  this.visible = true;
              }
              else {
                  this.visible = false;
              }
          }
          Laya.timer.loop(1000, this, this.timeLoop);
          this.timeLoop();
      }
      onClick() {
          UIMgr.openUI(EUI.WxLimitTimeGetView);
      }
      onRefresh() {
          this.visible = false;
      }
      timeLoop() {
          let time = UserData.instance.enterGameTime + 30 * 60 * 1000;
          time = time - Date.now();
          if (time <= 0) {
              this.lab_time.visible = false;
              this.visible = false;
              Laya.timer.clear(this, this.timeLoop);
          }
          else {
              time = time / 1000;
              let str = Utils.formatTimestamp(time);
              this.lab_time.text = str;
          }
      }
      onDestroy() {
          Laya.timer.clearAll(this);
          this.offAll();
          this.ani1.stop();
      }
  }

  class XS_arrow2_ani extends ui.Ani.XS_arrow2_aniUI {
      constructor() {
          super();
          this._complete = false;
      }
      onAwake() {
          this.visible = false;
      }
      setVisible(isVisible) {
          if (isVisible) {
              this.visible = true;
              this.ani1.play(0, true);
          }
          else {
              this.visible = false;
              this.ani1.stop();
          }
      }
  }

  class HouseBagItem extends ui.Item.HouseBagItemUI {
      onAwake() {
          Utils.addClick(this.btn_open, this.onClickOpen, this, 1, null);
      }
      set dataSource(data) {
          this._dataSource = data;
          this.initView();
      }
      onDestroy() { }
      initView() {
          if (this._dataSource) {
              let resCfg = CfgDataMgr.instance.resCfg[this._dataSource.id];
              if (resCfg) {
                  this.quality.skin = 'houseBag/quality_' + resCfg.goodsQuality + '.png';
                  this.img_icon.skin = 'icon/' + resCfg.shopsIcon;
                  this.lab_num.text = '剩余： ' + this._dataSource.num + '个';
              }
          }
      }
      onClickOpen() {
          if (this._dataSource) {
              let boxCfg = CfgDataMgr.instance.treasureBoxCfg[this._dataSource.id];
              let jackpotCfg = CfgDataMgr.instance.jackpotCfg[boxCfg.jackpotID];
              let goods = CfgDataMgr.instance.randomJackpot(jackpotCfg);
              UserData.instance.addGood(goods);
              UserData.instance.consumeGood(this._dataSource.id);
              Laya.MouseManager.enabled = false;
              Laya.timer.frameOnce(2, this, function () {
                  Laya.MouseManager.enabled = true;
                  EventMgr.event(EventType.OpenBox, [goods]);
              });
          }
      }
  }

  var Sprite3D = Laya.Sprite3D;
  class DataMgr {
      constructor() {
          this.test_Invincible = false;
          this.test_HitShow = false;
          this.test_HitShow1 = false;
          this.isTest = true;
          this.isTestPause = false;
          this.isTestPause0 = false;
          this.isTestPause1 = false;
          this.isTestAttack = true;
          this.isTestGrenade = false;
          this.isTestHit = false;
          this.isTestTank = false;
          this.isSwitchCom = true;
          this.isFireId = 0;
          this.touchID = -1;
          this.killCnt = 0;
          this.killHeadCnt = 0;
          this.serialKill = 0;
          this.curSerialKill = 0;
          this.doubleHit = 0;
          this.curDoubleHit = 0;
          this.destroyVehicle = 0;
          this.reviveCnt = 0;
          this.loadTime = 0;
          this.isIntoGame = true;
          this.isCannonAttack = true;
          this.isRoleMove = false;
          this.isGameAiMove = true;
          this.isCurReviveIng = false;
          this.tankMoveArr = [];
          this.airMoveArr = [];
          this.isStand = true;
          this.isLaunchGame = true;
          this.isViscous = false;
          this.isMoveElevator = false;
          this.pathArr = [];
          this.isFirstShowDesk = false;
          this.isFirstComGame = false;
          this.isGuideFirstGame = false;
          this.isGameCom = false;
          this.dayGamesCnt = 0;
          this.dayGamesComCnt = 0;
          this._players = [];
          this._enemys = [];
          this.props = [];
          this.timeStampArr = [];
          this.lastClearTime = 0;
          this.dropGunArr = [];
          this.airDropArr = [];
          this.curPickupGun = null;
          this.curAirDropBox = null;
          this.vec = new Laya.Vector3();
          this.isUpDownVehBeg = false;
          this.reviveRewardCnt = 0;
          this.showVehDeadAni = false;
          this.isGuideCom = false;
          this.isNeedClearRes = false;
          this.isLoopTime = true;
          this.isLoadCom = false;
          this.curDeadPlayerCnt = 0;
          this.curDeadEnemyCnt = 0;
          this.roleHeight = 0;
          this.dailySkillCnt = 0;
          this.findEnemyTime = 500;
          this.isCanUseVeh = false;
          this.wxBannerShow = false;
          this.isGuideReward = false;
          this.isCanUseTank = false;
          this.isCanUseAir = false;
          this.isShowDailySkill = false;
          this.roleHitCnt = 0;
          this.isGuideGunGame = false;
          this.showNoBulletTime = 0;
          this.isShowAmmoBox = false;
          this.isFTPc = false;
          this._trialWeapons0 = [];
          this._trialWeapons1 = [];
          this._trialGood = [];
          this._testTrialGood = [];
          this.isFirstShowWeapon = true;
          this.lastConstellationTime = 0;
          this.gameTime = 0;
          this.attackClickCnt = 0;
          this.isShowOpBanner = false;
          this.keyBoardA = false;
          this.keyBoardW = false;
          this.keyBoardS = false;
          this.keyBoardD = false;
          this.isFullscreen = false;
          this._tankSpeed = 0;
          this._isTankCom = true;
          this._tankRot = 0;
          this._curPhase = EGamePhase.None;
          this._rot = new Laya.Vector3();
      }
      static get instance() {
          if (DataMgr._instance == null) {
              DataMgr._instance = new DataMgr();
          }
          return DataMgr._instance;
      }
      initProp() {
          this._rootNode = new Sprite3D('Root', false);
          this._effects = Laya.loader.getRes(ESprite3D.Effect);
          this._mapNode = new Sprite3D('Map', false);
          this._rootNode.addChild(this._mapNode);
          this._propParent = new Sprite3D('Props', false);
          this._rootNode.addChild(this._propParent);
      }
      initEffect() { }
      addChildToRoot(obj) {
          this._rootNode.addChild(obj);
      }
      addChildToRoot1(obj) {
          let pos = obj.transform.position;
          let rot = obj.transform.rotationEuler;
          this.vec.setValue(pos.x, pos.y, pos.z);
          this._rot.setValue(rot.x, rot.y, rot.z);
          this._rootNode.addChild(obj);
          this.vec.cloneTo(pos);
          this._rot.cloneTo(rot);
          obj.transform.position = pos;
          obj.transform.rotationEuler = rot;
      }
      getRootNode() {
          return this._rootNode;
      }
      get curPhase() {
          return this._curPhase;
      }
      set curPhase(val) {
          this._curPhase = val;
      }
      isPhase(val) {
          return this._curPhase == val;
      }
      isGamming() {
          return DataMgr.instance.curPhase == EGamePhase.InGame;
      }
      playCfgSound(name, pos) {
          if (!DataMgr.instance.isGamming())
              return;
          let soundParam_a = CfgDataMgr.instance.getGlobalCfg('soundParam_a');
          let sound;
          sound = SoundRoot + name + '.mp3';
          let dis = Laya.Vector3.distance(pos, DataMgr.instance.role.transform.position);
          let val = 1 - dis / (dis + soundParam_a);
          if (val > 0) {
              SoundMgr.playSound(sound, val);
          }
      }
      showSceneEffect(name, pos, rot = null, parent = null, autoRecover = true, time = 5000) {
          if (parent == null)
              parent = this._propParent;
          let effect = this.createEffect(name, parent);
          parent.addChild(effect);
          effect.transform.position = pos;
          if (rot) {
              effect.transform.rotationEuler = rot;
          }
          effect.active = true;
          if (autoRecover) {
              Laya.timer.once(time, this, function () {
                  this.recoverEffect(effect);
              });
          }
          return effect;
      }
      recoverEffect(effect, name = '') {
          if (effect == null || effect['__InPool'] == true)
              return;
          effect.active = false;
          effect.removeSelf();
          name == '' && (name = effect.name);
          Laya.Pool.recover(name, effect);
      }
      createEffect(effectName, parent) {
          if (Utils.isEmpty(effectName)) {
              return;
          }
          let effect = Laya.Pool.getItem(effectName);
          if (!effect) {
              let sp = Laya.loader.getRes(ESprite3D[effectName]);
              if (!sp) {
                  sp = this._effects.getChildByName(effectName);
              }
              effect = Sprite3D.instantiate(sp, parent, false);
          }
          else {
              parent.addChild(effect);
          }
          return effect;
      }
      get mapNode() {
          return this._mapNode;
      }
      get propParent() {
          return this._propParent;
      }
      recoverProp(prop) {
          if (prop == null || prop['__InPool'] == true)
              return;
          if (prop.owner == null)
              return;
          prop.owner.removeSelf();
          prop.owner.active = false;
          prop.onRecover();
          Laya.Pool.recover(prop.gameObject.name, prop);
          if (prop.owner.name == 'Barrel') {
              console.info('=====:错误名字');
          }
      }
      recoverObj(prop, name = '') {
          if (name == '') {
              name = prop.name;
          }
          prop.removeSelf();
          prop.active = false;
          Laya.Pool.recover(name, prop);
      }
      setRoleOriginPos(moveSp) {
          let spawnpointCfg = CfgDataMgr.instance.spawnpointCfg;
          let cfgPos = spawnpointCfg[0].position;
          let pos = moveSp.transform.localPosition;
          let y = DataMgr.instance.roleHeight;
          pos.setValue(cfgPos[0], y, cfgPos[2]);
          for (let key in spawnpointCfg) {
              let cfg = spawnpointCfg[key];
              if (cfg.name == 'spawnpoint_1') {
                  pos.setValue(cfg.position[0], cfg.position[1], cfg.position[2]);
                  pos.y = this.roleHeight;
                  moveSp.transform.localRotationEulerY = cfg.rotationY;
                  break;
              }
          }
          moveSp.transform.localPosition = pos;
      }
      calBulletHurt(part, cfg) {
          let hurt = 0;
          switch (part) {
              case PlayerPart.Body:
                  hurt = cfg.gunAttParam_body;
                  break;
              case PlayerPart.Arms:
                  hurt = cfg.gunAttParam_arms;
                  break;
              case PlayerPart.Head:
                  hurt = cfg.gunAttParam_head;
                  break;
          }
          return hurt;
      }
      set tankSpeed(val) {
          this._tankSpeed = val;
          EventMgr.event(EventType.RefreshTankSpeed, this._tankSpeed);
      }
      set isTankCom(val) {
          this._isTankCom = val;
          EventMgr.event(EventType.RefreshTankCom, this._isTankCom);
      }
      set tankRot(val) {
          this._tankRot = val;
          EventMgr.event(EventType.RefreshTankRot, this._tankRot);
      }
      clearTrial() {
          let userData = UserData.instance;
          userData.trialUseGunId = '';
          userData.trialVocationId = 0;
          userData.trialGunArr = [];
          userData.hasTrialGunArr = new Object();
          this._trialWeapon0 = null;
          this._trialWeapon1 = null;
          this._trialWeapons0.length = 0;
          this._trialWeapons1.length = 0;
          userData.curTrialVocationId = 0;
          this._trialGood.length = 0;
          this._trialSkill = 0;
          this._trialItem1 = null;
          this._trialItem2 = null;
          this._trialItem3 = null;
          this._trialItem4 = null;
      }
      clearPoolBySign(poolName) {
          let pool = Laya.Pool.getPoolBySign(poolName);
          for (let i = pool.length - 1; i >= 0; i--) {
              let sp = pool[i];
              sp.destroy();
          }
          Laya.Pool.clearBySign(poolName);
      }
      clearAll() { }
      get getWxBannerShow() {
          return this.wxBannerShow && !this.isGuideFirstGame;
      }
      checkTimeAdd(time) {
          if (DataMgr.instance.timeStampArr.length > 0) {
              DataMgr.instance.timeStampArr.sort();
              let minIndex = 0;
              let minVal = 10000000000000000000000;
              let curVal = 0;
              for (let i = 0, len = DataMgr.instance.timeStampArr.length; i < len; i++) {
                  let lastTime = DataMgr.instance.timeStampArr[i];
                  curVal = Math.abs(lastTime - time);
                  if (curVal < minVal) {
                      minVal = curVal;
                      minIndex = i;
                  }
              }
              if (Math.abs(minVal - time) > 100) {
                  DataMgr.instance.timeStampArr.push(time);
              }
              else {
                  if (minIndex >= DataMgr.instance.timeStampArr.length - 1) {
                      time += 100;
                      DataMgr.instance.timeStampArr.push(time);
                  }
                  else {
                      let isExit = false;
                      for (let i = minIndex, len = DataMgr.instance.timeStampArr.length - 1; i < len; i++) {
                          minVal = DataMgr.instance.timeStampArr[i];
                          curVal = DataMgr.instance.timeStampArr[i + 1];
                          if (curVal - minVal > 100) {
                              time = (curVal + minVal) / 2;
                              DataMgr.instance.timeStampArr.push(time);
                              isExit = true;
                          }
                      }
                      if (!isExit) {
                          time = DataMgr.instance.timeStampArr[DataMgr.instance.timeStampArr.length - 1] + 100;
                          DataMgr.instance.timeStampArr.push(time);
                      }
                  }
              }
          }
          else {
              DataMgr.instance.timeStampArr.push(time);
          }
          return time;
      }
      checkBannerShow(uiConfig) {
          if (uiConfig == EUI.GetReward) {
              if (DataMgr.instance.isGuideReward) {
                  DataMgr.instance.wxBannerShow = GameConst.wxBannerReward;
              }
              else {
                  DataMgr.instance.wxBannerShow = GameConst.wxBannerReward1;
              }
          }
          else if (uiConfig == EUI.WxSurpriseRewardView) {
              DataMgr.instance.wxBannerShow = GameConst.wxBannerSurprised;
          }
          else if (uiConfig == EUI.GameView && DataMgr.instance.isShowAmmoBox) {
              DataMgr.instance.wxBannerShow = GameConst.wxAmmoSwitch;
          }
      }
      checkIsKey() {
          return (DataMgr.instance.keyBoardA ||
              DataMgr.instance.keyBoardD ||
              DataMgr.instance.keyBoardS ||
              DataMgr.instance.keyBoardW);
      }
  }
  DataMgr._instance = null;
  DataMgr.deltaTime = 0;
  DataMgr.nowTime = 0;
  DataMgr.FixedDeltaTime = 0.016;
  DataMgr.FPS = 60;
  DataMgr.findTimeInterval = 100;

  class LoadUtils {
      constructor(keys, ratios) {
          this.keys = keys;
          this.ratios = ratios;
          this.values = Utils.memset(keys.length, 0);
      }
      setValue(key, value) {
          var self = this;
          var index = self.keys.indexOf(key);
          if (index > -1) {
              self.values[index] = value;
          }
      }
      getValue(key) {
          var self = this;
          return self.values[self.keys.indexOf(key)];
      }
      get value() {
          var self = this, sum = 0, values = self.values, ratios = self.ratios;
          for (let i in values) {
              sum += values[i] * ratios[i];
          }
          return Math.floor(sum * 100 + 0.5) / 100;
      }
      clear() {
          var self = this;
          self.keys = self.values = self.ratios = null;
      }
      static create(keys, ratios) {
          var len = keys.length;
          if (len > 0 && len == ratios.length) {
              let sum = 0;
              for (let i = 0; i < len; i++)
                  sum += ratios[i];
              if (sum !== 1) {
                  let sum1 = 0;
                  len -= 1;
                  for (let i = 0; i < len; i++) {
                      sum1 += ratios[i] /= sum;
                  }
                  ratios[len] = 1 - sum1;
              }
              return new LoadUtils(keys, ratios);
          }
      }
  }

  class SceneConst {
  }
  SceneConst.Realtime_Shadow = false;
  SceneConst.Enable_Fog = false;
  SceneConst.Enable_Skybox = false;
  SceneConst.DEBUG = false;
  SceneConst.isUseWorker = false;

  var Sprite3D$1 = Laya.Sprite3D;
  var Texture2D = Laya.Texture2D;
  var MeshSprite3D = Laya.MeshSprite3D;
  var SkinnedMeshSprite3D = Laya.SkinnedMeshSprite3D;
  var Handler = Laya.Handler;
  var BaseMaterial = Laya.BaseMaterial;
  var Vector3$2 = Laya.Vector3;
  class ExUtils {
      constructor() { }
      static setModelSkinByUrl(model, skinUrl) {
          if (!skinUrl)
              return;
          Texture2D.load(skinUrl, Handler.create(this, function (texture) {
              ExUtils.setModelSkin(model, texture, null, 'materials');
              model.active = true;
          }));
      }
      static setModelSkin(model, texture, color = null, matName = 'sharedMaterials') {
          if (model == null || texture == null)
              return;
          if (model instanceof MeshSprite3D) {
              var meshSprite3D = model;
              for (var i = 0; i < meshSprite3D.meshRenderer[matName].length; i++) {
                  var material = meshSprite3D.meshRenderer[matName][i];
                  material.albedoTexture = texture;
                  if (color)
                      material.albedoColor = color;
              }
              meshSprite3D.meshRenderer.castShadow = SceneConst.Realtime_Shadow;
          }
          if (model instanceof SkinnedMeshSprite3D) {
              var skinnedMeshSprite3D = model;
              for (var i = 0; i < skinnedMeshSprite3D.skinnedMeshRenderer[matName].length; i++) {
                  var material = skinnedMeshSprite3D.skinnedMeshRenderer[matName][i];
                  material.albedoTexture = texture;
                  if (color)
                      material.albedoColor = color;
              }
              skinnedMeshSprite3D.skinnedMeshRenderer.castShadow = SceneConst.Realtime_Shadow;
          }
          for (var i = 0, n = model.numChildren; i < n; i++) {
              this.setModelSkin(model.getChildAt(i), texture, color, matName);
          }
      }
      static setMatetial(node, path, handler = null) {
          BaseMaterial.load(path, Handler.create(this, function (mat) {
              let mesh = this.getMesh(node);
              if (mesh) {
                  mesh.meshRenderer.material = mat;
                  mesh.meshRenderer.castShadow = SceneConst.Realtime_Shadow;
                  mesh.meshRenderer.receiveShadow = SceneConst.Realtime_Shadow;
                  if (handler)
                      handler.run();
              }
          }));
      }
      static getMaterial(node) {
          if (node == null)
              return null;
          let mesh = this.getMesh(node);
          if (mesh) {
              var material = mesh.meshRenderer.sharedMaterials[0];
              return material;
          }
          let mat;
          for (let i = 0; i < node.numChildren; i++) {
              mat = this.getMaterial(node.getChildAt(i));
              if (mat) {
                  return mat;
              }
          }
          return null;
      }
      static setMaterialLight(node, isLight) { }
      static setRecieveShadow(model, val) {
          if (model instanceof MeshSprite3D) {
              var meshSprite3D = model;
              meshSprite3D.meshRenderer.receiveShadow = val;
          }
          if (model instanceof SkinnedMeshSprite3D) {
              var skinnedMeshSprite3D = model;
              skinnedMeshSprite3D.skinnedMeshRenderer.receiveShadow = val;
          }
          for (var i = 0; i < model.numChildren; i++) {
              this.setRecieveShadow(model.getChildAt(i), val);
          }
      }
      static setCastShadow(model, val) {
          if (model instanceof MeshSprite3D) {
              var meshSprite3D = model;
              meshSprite3D.meshRenderer.castShadow = val;
          }
          if (model instanceof SkinnedMeshSprite3D) {
              var skinnedMeshSprite3D = model;
              skinnedMeshSprite3D.skinnedMeshRenderer.castShadow = val;
          }
          for (var i = 0; i < model.numChildren; i++) {
              this.setCastShadow(model.getChildAt(i), val);
          }
      }
      static getMesh(obj) {
          if (obj == null)
              return null;
          let mesh;
          if (obj instanceof MeshSprite3D) {
              return obj;
          }
          for (let i = 0; i < obj.numChildren; i++) {
              mesh = this.getMesh(obj.getChildAt(i));
              if (mesh) {
                  return mesh;
              }
          }
          return null;
      }
      static getSkinMesh(obj) {
          if (obj == null)
              return null;
          let mesh;
          if (obj instanceof SkinnedMeshSprite3D) {
              return obj;
          }
          for (let i = 0; i < obj.numChildren; i++) {
              mesh = this.getSkinMesh(obj.getChildAt(i));
              if (mesh) {
                  return mesh;
              }
          }
          return null;
      }
      static instanceSprite3D(path, parent, handler = null) {
          let callback = Handler.create(this, function (obj) {
              if (obj == null || obj == null) {
                  console.error('instanceSprite3D null', path);
              }
              obj.active = true;
              if (handler) {
                  handler.runWith(obj);
              }
          });
          let instance = Laya.Pool.getItem(path);
          if (instance) {
              parent && parent.addChild(instance);
              callback.runWith(instance);
              return;
          }
          let obj = Laya.loader.getRes(path);
          if (obj) {
              let instance = Sprite3D$1.instantiate(obj, parent, false);
              callback.runWith(instance);
              return;
          }
          Sprite3D$1.load(path, Laya.Handler.create(ExUtils, ExUtils.instanceSprite3D, [path, parent, handler]));
      }
      static getComponentInChild(obj, cls) {
          let component = obj.getComponent(cls);
          if (component instanceof cls) {
              return component;
          }
          for (let i = 0; i < obj.numChildren; i++) {
              component = this.getComponentInChild(obj.getChildAt(i), cls);
              if (component instanceof cls) {
                  return component;
              }
          }
          return null;
      }
      static getAllComponentsInChild(obj, cls) {
          let componentArr = [];
          let getComponent = function (obj1, cls1) {
              let component = obj1.getComponent(cls1);
              if (component instanceof cls1) {
                  componentArr.push(component);
              }
              for (let i = 0; i < obj1.numChildren; i++) {
                  component = getComponent(obj1.getChildAt(i), cls1);
              }
          };
          getComponent(obj, cls);
          return componentArr;
      }
      static addSingleComponent(obj, cls) {
          if (obj == null) {
              console.trace('addSingleComponent obj null', cls);
              return null;
          }
          let component = obj.getComponent(cls);
          if (component == null) {
              component = obj.addComponent(cls);
          }
          return component;
      }
      static getChild(obj, path) {
          let nodeNames = path.split('/');
          for (let i = 0, size = nodeNames.length; i < size; i++) {
              obj = obj.getChildByName(nodeNames[i]);
          }
          return obj;
      }
      static findChild(obj, name) {
          if (obj.name == name) {
              return obj;
          }
          let result = null;
          for (let i = 0, size = obj.numChildren; i < size; i++) {
              result = this.findChild(obj.getChildAt(i), name);
              if (result) {
                  return result;
              }
          }
          return null;
      }
      static LayaLookAt(tf, targetPos, ignoreY = false, isNegation = true) {
          if (isNegation) {
              Vector3$2.subtract(tf.position, targetPos, this._vec);
              Vector3$2.add(tf.position, this._vec, this._vec);
          }
          else {
              targetPos.cloneTo(this._vec);
          }
          if (ignoreY) {
              this._vec.y = tf.position.y;
          }
          tf.lookAt(this._vec, Vector3Ex.Up, false);
      }
  }
  ExUtils._vec = new Vector3$2();

  var Vector3$5 = Laya.Vector3;
  class BaseProp extends Laya.Script3D {
      constructor() {
          super();
          this._targetPos = new Vector3$5();
      }
      onAwake() {
          super.onAwake();
          this.gameObject = this.owner;
          this.transform = this.gameObject.transform;
      }
      onRecover() {
          if (this.model) {
              this.model.removeSelf();
              this.model.active = false;
              Laya.Pool.recover(this.modelName, this.model);
          }
          this.model = null;
      }
      onUpdate() {
          super.onUpdate();
          if (!DataMgr.instance.isGamming()) {
              DataMgr.instance.recoverProp(this);
          }
      }
      startUse(player, gunCfg) { }
      aiStartBomb(attacker, target, id = 100002) { }
      setModel(id) {
          let self = this;
          this.bulletID = id;
          this.cfg = CfgDataMgr.instance.bulletCfg[this.bulletID];
          if (this.cfg) {
              let modelName = this.cfg.bulletModel;
              if (!Utils.isEmpty(modelName)) {
                  this.modelName = DynamicSceneRoot + modelName + '.lh';
                  ExUtils.instanceSprite3D(this.modelName, this.gameObject, Laya.Handler.create(this, function (obj) {
                      self.model = obj;
                  }));
              }
          }
      }
      showSceneEffect() {
          let isSound = this._attacker.isRolePlayer();
          if (!isSound) {
              if (this._attacker.curTarget && this._attacker.curTarget.isRolePlayer()) {
                  isSound = true;
              }
          }
          if (isSound) {
              if (this._hitTag == 8) {
                  this.cfg.bulletHitVehVx &&
                      DataMgr.instance.playCfgSound(this.cfg.bulletHitVehVx, this.transform.position);
              }
              else {
                  this.cfg.bulletHitSceneVx &&
                      DataMgr.instance.playCfgSound(this.cfg.bulletHitSceneVx, this.transform.position);
              }
          }
          if (this._hitTag == 8) {
              this.cfg.bulletHitVehicleFX &&
                  DataMgr.instance.showSceneEffect(this.cfg.bulletHitVehicleFX, this._targetPos, this.transform.rotationEuler, null, true, 500);
              Laya.timer.once(100, this, function () {
                  this.cfg.bulletHitVehicleAFX &&
                      DataMgr.instance.showSceneEffect(this.cfg.bulletHitVehicleAFX, this._targetPos, this.transform.rotationEuler, null, true, 5000);
                  DataMgr.instance.recoverProp(this);
              });
          }
          else {
              if (this.cfg.bulletHitSceneFX) {
                  let isBoom = this.cfg.bulletHitSceneFX.indexOf('Bomb') != -1;
                  if (this._attacker.isUseVeh ||
                      Laya.Vector3.distance(this.transform.position, DataMgr.instance.role.transform.position) <
                          50) {
                      let effect = DataMgr.instance.showSceneEffect(this.cfg.bulletHitSceneFX, this._targetPos, isBoom ? null : this.transform.rotationEuler, null, true, 500);
                      let scale = this.cfg.bulletHitSceneScale;
                      if (scale > 0) {
                          let localScale = effect.transform.localScale;
                          localScale.setValue(scale, scale, scale);
                          effect.transform.localScale = localScale;
                      }
                  }
              }
              Laya.timer.once(100, this, function () {
                  if (this.cfg.bulletHitSceneAFX) {
                      let isBoom = this.cfg.bulletHitSceneFX.indexOf('Bomb') != -1;
                      let effect = DataMgr.instance.showSceneEffect(this.cfg.bulletHitSceneAFX, this._targetPos, isBoom ? null : this.transform.rotationEuler, null, true, 5000);
                  }
                  DataMgr.instance.recoverProp(this);
              });
          }
      }
      showHitEffect() {
          if (this._hurter.isUseVeh) {
              if (this.cfg.bulletHitVehVx) {
                  DataMgr.instance.playCfgSound(this.cfg.bulletHitVehVx, this.transform.position);
              }
              this.cfg.bulletHitVehicleFX &&
                  DataMgr.instance.showSceneEffect(this.cfg.bulletHitVehicleFX, this._targetPos, this.transform.rotationEuler, null, true, 500);
              Laya.timer.once(100, this, function () {
                  this.cfg.bulletHitVehicleAFX &&
                      DataMgr.instance.showSceneEffect(this.cfg.bulletHitVehicleAFX, this._targetPos, this.transform.rotationEuler, null, true, 5000);
              });
          }
          else {
              if (this.cfg.bulletHitBodyVx.length > 0) {
                  if (this._attacker.isRolePlayer()) {
                      DataMgr.instance.playCfgSound(this.cfg.bulletHitBodyVx[(this.cfg.bulletHitBodyVx.length * Math.random()) | 0], this._attacker.transform.position);
                  }
              }
              if (!this._hurter.isRolePlayer()) {
                  if (this.cfg.bulletHitBodyFX) {
                      this._hurter.hitEffect.push(DataMgr.instance.showSceneEffect(this.cfg.bulletHitBodyFX, this._targetPos, this.transform.rotationEuler, null, true, 5000));
                  }
              }
              Laya.timer.once(100, this, function () {
                  if (this.cfg.bulletHitBodyAFX) {
                      this._hurter.hitEffect.push(DataMgr.instance.showSceneEffect(this.cfg.bulletHitBodyAFX, this._targetPos, this.transform.rotationEuler, null, true, 5000));
                  }
              });
          }
      }
      showRangeHitEffect() {
          this.cfg.bulletHitSceneVx &&
              DataMgr.instance.playCfgSound(this.cfg.bulletHitSceneVx, this.transform.position);
          this.cfg.bulletHitSceneFX &&
              DataMgr.instance.showSceneEffect(this.cfg.bulletHitSceneFX, this.transform.position, this.transform.rotationEuler, null, true, 5000);
          Laya.timer.once(100, this, function () {
              this.cfg.bulletHitSceneAFX &&
                  DataMgr.instance.showSceneEffect(this.cfg.bulletHitSceneAFX, this.transform.position, this.transform.rotationEuler, null, true, 5000);
              DataMgr.instance.recoverProp(this);
          });
      }
  }

  class ModeMgr {
      constructor() {
          this._curEnemyScore = 0;
          this._curTeamScore = 0;
          this.maxScore = 0;
          this._gameMaxTime = 0;
          this._gameTime = 0;
      }
      static get instance() {
          if (ModeMgr._instance == null) {
              ModeMgr._instance = new ModeMgr();
          }
          return ModeMgr._instance;
      }
      get levelModelCfg() {
          return this._levelModelCfg;
      }
      set levelModelCfg(val) {
          this._levelModelCfg = val;
          if (Utils.isEmpty(this._levelModelCfg))
              return;
          this._gameMaxTime = this._levelModelCfg.battleCountDown;
          switch (this.levelModelCfg.modeVictoryCondition) {
              case 1:
                  this._gameTime = this._gameMaxTime = 0;
                  this.curTeamScore = this._levelModelCfg.initialIntegral_A;
                  this.curEnemyScore = this._levelModelCfg.initialIntegral_B;
                  this.maxScore = this._levelModelCfg.initialIntegral_A;
                  break;
              case 2:
                  this._gameTime = this._gameMaxTime;
                  break;
              case 3:
                  this._gameTime = this._gameMaxTime;
                  this.curTeamScore = this.curEnemyScore = 0;
                  this.maxScore = this._levelModelCfg.victoryCondition;
                  break;
              case 4:
                  this._gameTime = this._gameMaxTime;
                  this.curTeamScore = this._levelModelCfg.initialIntegral_A;
                  this.curEnemyScore = this._levelModelCfg.initialIntegral_B;
                  break;
          }
      }
      cntCurTime() {
          if (!DataMgr.instance.isGamming())
              return 0;
          if (this._gameMaxTime == 0) {
              this._gameTime++;
          }
          else {
              this._gameTime--;
          }
          if (this._gameTime < 0) {
              EventMgr.event(EventType.CheckResult, true);
          }
          return this._gameTime;
      }
      get gameTime() {
          return this._gameTime;
      }
      get modAIMaxRespawn() {
          if (Utils.isEmpty(this.levelModelCfg)) {
              return 0;
          }
          return this.levelModelCfg.modAIMaxRespawn;
      }
      get modeVictoryCondition() {
          return this.levelModelCfg.modeVictoryCondition;
      }
      get modePlayerLives() {
          return this._levelModelCfg.modePlayerLives == -1
              ? 9999999
              : this._levelModelCfg.modePlayerLives;
      }
      setScore(isTeam) {
          switch (this.levelModelCfg.modeVictoryCondition) {
              case 1:
                  if (isTeam) {
                      this.curTeamScore--;
                  }
                  else {
                      this.curEnemyScore--;
                  }
                  break;
              case 2:
                  break;
              case 3:
                  if (isTeam) {
                      this.curEnemyScore++;
                  }
                  else {
                      this.curTeamScore++;
                  }
                  break;
              case 4:
                  if (isTeam) {
                      this.curTeamScore--;
                  }
                  else {
                      this.curEnemyScore--;
                  }
                  break;
          }
      }
      set curEnemyScore(val) {
          this._curEnemyScore = val;
          if (this._curEnemyScore < 0) {
              this._curEnemyScore = 0;
          }
      }
      get curEnemyScore() {
          return this._curEnemyScore;
      }
      set curTeamScore(val) {
          this._curTeamScore = val;
          if (this._curTeamScore < 0) {
              this._curTeamScore = 0;
          }
      }
      get curTeamScore() {
          return this._curTeamScore;
      }
      checkResult(isEnd) {
          switch (this.levelModelCfg.modeVictoryCondition) {
              case 1:
                  return this.teamElimination();
              case 2:
                  return this.trainingGround();
              case 3:
                  return this.teamCompetition(isEnd);
              case 4:
                  return this.teamElimination();
          }
      }
      teamElimination() {
          if (this.curTeamScore <= 0) {
              return 1;
          }
          if (this.curEnemyScore <= 0) {
              return 2;
          }
          return 0;
      }
      teamCompetition(isEnd) {
          if (isEnd) {
              return this.curTeamScore > this.curEnemyScore ? 2 : 1;
          }
          if (this.curTeamScore >= this.maxScore)
              return 2;
          if (this.curEnemyScore >= this.maxScore)
              return 1;
          return 0;
      }
      trainingGround() {
          return 0;
      }
      zombieAttack() {
          return 0;
      }
  }
  ModeMgr._instance = null;

  class AirdropBox extends BaseProp {
      constructor() {
          super();
          this._curBoxData = [];
          this._vec = new Laya.Vector3();
      }
      onAwake() {
          super.onAwake();
      }
      setData() {
          this._airBox = this.owner;
          this._curBoxData.push({
              type: 1,
              val: this.getGoodsId(2)
          });
          this._curBoxData.push({
              type: 7777,
              val: 100006
          });
          this._curBoxData.push({
              type: 8888,
              val: 100007
          });
          this.startDrop();
      }
      get curBoxData() {
          return this._curBoxData;
      }
      setCurBoxData(val) {
          Utils.removeArrayObj(this.curBoxData, val);
      }
      getGoodsId(type) {
          let cfg = CfgDataMgr.instance.jackpotCfg[CfgDataMgr.instance.shopCfg[type].jackpotID];
          let goodsID = CfgDataMgr.instance.randomJackpot(cfg)[1];
          return goodsID;
      }
      startDrop() {
          let cfg = CfgDataMgr.instance.supplyPoint_01Cfg;
          let data = cfg[(Math.random() * cfg.length) | 0];
          this._vec.setValue(data.position[0], DataMgr.instance.roleHeight, data.position[2]);
          let pos = this._airBox.transform.localPosition;
          this._vec.cloneTo(pos);
          pos.y = 50;
          this._airBox.transform.localPosition = pos;
          this._parachute = this._airBox.getChildAt(1);
          this._parachute.active = true;
          Tween.once(this._airBox.transform, {})
              .to({
              localPositionY: this._vec.y
          }, 3000, null)
              .call(this.show, this, null);
          Laya.timer.once(ModeMgr.instance.levelModelCfg.supplyWeaponExistTime * 1000, this, this.stop);
      }
      show() {
          let self = this;
          Tween.once(this._parachute.transform, {})
              .to({
              localScaleX: 0.3,
              localScaleY: 0.2,
              localScaleZ: 0.3
          }, 1000, null)
              .call(function () {
              let scale = self._parachute.transform.localScale;
              scale.setValue(1, 1, 1);
              self._parachute.transform.localScale = scale;
              self._parachute.active = false;
          }, null, null);
      }
      stop() {
          Utils.removeArrayObj(DataMgr.instance.airDropArr, this);
          DataMgr.instance.recoverEffect(this.gameObject, ESprite3D.AirdropA);
      }
      recover() {
          Tween.clear(this._airBox.transform);
          Tween.clear(this._parachute.transform);
          Laya.timer.clear(this, this.stop);
      }
  }

  class AirdropMgr {
      constructor() { }
      static get instance() {
          if (AirdropMgr._instance == null) {
              AirdropMgr._instance = new AirdropMgr();
          }
          return AirdropMgr._instance;
      }
      init() { }
      stop() {
          Laya.timer.clear(this, this.createBox);
      }
      startCreate() {
          Laya.timer.once(ModeMgr.instance.levelModelCfg.supplyWeaponDropTime * 1000, this, this.createBox);
      }
      createBox() {
          ExUtils.instanceSprite3D(ESprite3D.AirdropA, DataMgr.instance.getRootNode(), Laya.Handler.create(this, function (mesh) {
              let box = ExUtils.addSingleComponent(mesh, AirdropBox);
              box.setData();
              DataMgr.instance.airDropArr.push(box);
          }));
          this.startCreate();
      }
  }
  AirdropMgr._instance = null;

  class PlayerCollider extends Laya.Script3D {
      onAwake() { }
  }

  class UmengPlatform {
      static trackEvent(eventID, data) { }
  }

  var Vector3$7 = Laya.Vector3;
  var Ray = Laya.Ray;
  var HitResult = Laya.HitResult;
  class Bomb extends BaseProp {
      constructor() {
          super();
          this._gravity = new Vector3$7(0, -9.8, 0);
          this.g = 9.8 * 0.35;
          this.speed = 20;
          this._dir = new Vector3$7();
          this._flying = false;
          this._vec = new Vector3$7();
          this._tempVec = new Vector3$7();
          this._isAI = false;
          this._isHiting = false;
          this.target = new Laya.Vector3();
          this.verticalSpeed = 0;
          this.moveDirection = new Laya.Vector3();
          this.angleSpeed = 0;
          this.angle = 0;
          this.time = 0;
          this._frameIndex = 0;
          this.FramCnt = 3;
          this.FrameHurt = 10;
          this._players = [];
      }
      onAwake() {
          super.onAwake();
          this._ray = new Ray(new Vector3$7(0, 0, 0), new Vector3$7(0, -1, 0));
          this._result = new HitResult();
          this._collisonGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
          this.collisionWith =
              Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1 ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2 ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3;
      }
      onUpdate() {
          if (this._flying) {
              if (this._isAI) {
                  this.time += DataMgr.deltaTime;
                  let test = this.verticalSpeed - this.g * this.time;
                  Laya.Vector3.normalize(this.moveDirection, this._vec);
                  Laya.Vector3.scale(this._vec, this.speed * DataMgr.deltaTime, this._vec);
                  Laya.Vector3.scale(Vector3Ex.Up, test * DataMgr.deltaTime, this._tempVec);
                  Laya.Vector3.add(this._vec, this._tempVec, this._vec);
                  if (Laya.Vector3.distance(this.transform.position, this.target) <=
                      Laya.Vector3.scalarLength(this._vec)) {
                      let pos = this.transform.position;
                      this.target.cloneTo(pos);
                      pos.y += 0.2;
                      this.transform.position = pos;
                      this.explode();
                  }
                  this.transform.translate(this._vec, false);
                  let testAngle = -this.angle + this.angleSpeed * this.time;
                  let rot = this.transform.rotationEuler;
                  rot.setValue(testAngle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
                  this.transform.rotationEuler = rot;
              }
              else {
                  Laya.Vector3.add(this._dir, this._gravity, this._dir);
                  Laya.Vector3.scale(this._dir, DataMgr.FixedDeltaTime, this._tempVec);
                  Laya.Vector3.add(this._tempVec, this.transform.position, this._vec);
                  this.transform.lookAt(this._vec, Vector3Ex.Up, false);
                  this.transform.translate(this._tempVec, false);
                  this._frameIndex++;
                  if (this._frameIndex > this.FramCnt) {
                      this._frameIndex -= this.FramCnt;
                      if (this.checkCollision()) {
                          this.explode();
                      }
                  }
              }
          }
          if (this._isHiting) {
              if (this.time <= DataMgr.nowTime) {
                  this.showEffect();
                  this._isHiting = false;
              }
              else {
                  this._frameIndex++;
                  if (this._frameIndex > this.FrameHurt) {
                      this._frameIndex -= this.FrameHurt;
                      this.checkResult();
                  }
              }
          }
          super.onUpdate();
      }
      checkCollision() {
          let origin = this._ray.origin;
          this.transform.position.cloneTo(origin);
          origin.y += 2;
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, 3, this._collisonGroup, this.collisionWith);
          if (this._result.succeeded) {
              let pos = this.transform.position;
              this._result.point.cloneTo(pos);
              pos.y += 0.2;
              this.transform.position = pos;
              return true;
          }
          return false;
      }
      onRecover() {
          super.onRecover();
          this._isAI = false;
          this._isHiting = false;
          this._players.length = 0;
          this.time = 0;
      }
      startFly(curPos, dir, attack, attackTime = -1, bulletID = 100002) {
          this.setModel(bulletID);
          this._gunID = 101201;
          this._gravity.y = -this.cfg.bulletGravitationalSpeed;
          Utils.vec3ToTargetVal('position', 1, this.gameObject, curPos);
          dir.cloneTo(this._dir);
          Laya.Vector3.scale(this._dir, this.cfg.bulletSpeed, this._dir);
          this._attack = attack;
          this._flying = true;
          this._attackTime = 99999;
      }
      aiStartBomb(attacker, target, id = 100002) {
          this._gunID = 101201;
          this.setModel(id);
          target.cloneTo(this.target);
          this.transform.position.cloneTo(this._vec);
          let tempDistance = Laya.Vector3.distance(this._vec, target);
          let tempTime = tempDistance / this.speed;
          let riseTime = tempTime / 2;
          this.transform.lookAt(target, Vector3Ex.Up);
          this.verticalSpeed = this.g * riseTime;
          let hu = Math.atan(this.verticalSpeed / this.speed);
          this.angle = (180 / Math.PI) * hu;
          let rot = this.transform.rotationEuler;
          rot.setValue(-this.angle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
          this.transform.rotationEuler = rot;
          this.angleSpeed = this.angle / riseTime;
          Laya.Vector3.subtract(target, this.transform.position, this.moveDirection);
          this._attack = attacker;
          this._isAI = true;
          this._flying = true;
          this._attackTime = 99999;
      }
      explode() {
          let self = this;
          this._flying = false;
          if (self.cfg.bulletType == 7 || self.cfg.bulletType == 6) {
              this._isHiting = true;
              this._frameIndex = 0;
              this.time = DataMgr.nowTime + 1000;
          }
          else {
              if (this._isAI) {
                  Laya.timer.once(this.cfg.bulletLifeTime, self, function () {
                      self.checkResult();
                      self.showEffect();
                  });
              }
              else {
                  this._attackTime = this._attackTime - DataMgr.nowTime;
                  this._attackTime < 0 && (this._attackTime = 0);
                  Laya.timer.once(this.cfg.bulletLifeTime, self, function () {
                      self.checkResult();
                      self.showEffect();
                  });
              }
          }
      }
      checkResult() {
          let self = this;
          let players;
          if (self.cfg.bulletType == 7 || self.cfg.bulletType == 6) {
              players =
                  self._attack.getCamp() == PlayerCamp.Teammate
                      ? DataMgr.instance._players
                      : DataMgr.instance._enemys;
          }
          else {
              players =
                  self._attack.getCamp() == PlayerCamp.Enemy
                      ? DataMgr.instance._players
                      : DataMgr.instance._enemys;
          }
          let isHit = false;
          for (let i = 0, cnt = players.length; i < cnt; i++) {
              let player = players[i];
              if (player.isDead)
                  continue;
              if (Vector3$7.distance(this.transform.position, player.transform.position) <=
                  this.cfg.harmRadial) {
                  if (this._players.indexOf(player.id) == -1) {
                      this._players.push(player.id);
                  }
                  else {
                      continue;
                  }
                  switch (self.cfg.bulletType) {
                      case 7:
                          player.addAmmo(self.cfg.bulletParam);
                          break;
                      case 6:
                          player.addHp(self.cfg.bulletParam);
                          break;
                      default:
                          player.hurtByBullet(PlayerPart.Body, this._attack, this.transform.position, this.transform.rotationEuler, this._gunID, player.getBodyCenter());
                          isHit = true;
                          break;
                  }
              }
          }
          if (self._attack.isRolePlayer() && isHit) {
              UmengPlatform.trackEvent('zhandou', {
                  caozuo: '雷命中'
              });
          }
      }
      showEffect() {
          this.showRangeHitEffect();
      }
  }

  var Vector3$b = Laya.Vector3;
  class BombPlacement extends BaseProp {
      constructor() {
          super();
          this._frameIndex = 0;
          this._isStart = false;
          this._bombTime = 0;
      }
      onAwake() {
          super.onAwake();
      }
      onUpdate() {
          if (!this._isStart)
              return;
          this._frameIndex++;
          if (this._frameIndex > 6) {
              this._frameIndex -= 6;
              let enemyArr = this._camp == PlayerCamp.Teammate ? DataMgr.instance._enemys : DataMgr.instance._players;
              let len = enemyArr.length;
              for (let i = 0; i < len; i++) {
                  let player = enemyArr[i];
                  if (player.isDead)
                      continue;
                  if (Laya.Vector3.distance(player.transform.position, this.transform.position) <=
                      this.cfg.harmRadial) {
                      this.explode();
                      this._isStart = false;
                      return;
                  }
              }
              if (DataMgr.nowTime > this._bombTime) {
                  this.explode();
                  this._isStart = false;
              }
          }
          super.onUpdate();
      }
      onRecover() {
          super.onRecover();
      }
      startUse(player, gunCfg) {
          this.setModel(gunCfg.bulletID);
          this._camp = player.getCamp();
          let pos = this.transform.position;
          player.transform.position.cloneTo(pos);
          this._player = player;
          this.transform.position = pos;
          this._isStart = true;
          this._bombTime = this.cfg.bulletLifeTime + DataMgr.nowTime;
      }
      setModel(bulletID) {
          throw new Error('Method not implemented.');
      }
      explode() {
          let self = this;
          this.transform.localPositionY = DataMgr.instance.roleHeight;
          Laya.timer.once(self.cfg.bulletLifeTime, self, function () {
              let players = self._camp == PlayerCamp.Enemy ? DataMgr.instance._players : DataMgr.instance._enemys;
              for (let i = 0, cnt = players.length; i < cnt; i++) {
                  let player = players[i];
                  if (player.isDead)
                      continue;
                  if (Vector3$b.distance(self.transform.position, player.transform.position) <=
                      self.cfg.harmRadial) {
                      player.hurtByCannon(self._player, self.transform.position, self.transform.rotationEuler, self.cfg.bulletParam, 101301);
                  }
              }
              this.showRangeHitEffect();
          });
      }
  }

  var Vector3$6 = Laya.Vector3;
  class Bullet extends BaseProp {
      constructor() {
          super();
          this._velocity = new Vector3$6();
          this._dir = new Vector3$6();
          this._isRole = false;
          this.normal = new Laya.Vector3();
          this.point = new Laya.Vector3();
      }
      onAwake() {
          super.onAwake();
      }
      onDisable() {
          super.onDisable();
      }
      onUpdate() {
          if (this._moveEndTime == 0)
              return;
          if (this._moveEndTime > 0 && DataMgr.nowTime > this._moveEndTime) {
              this._moveEndTime = 0;
              this.onHurt();
              this.showSceneEffect();
              return;
          }
          if (this._velocity) {
              this.transform.translate(this._velocity, false);
          }
          super.onUpdate();
      }
      onRecover() {
          super.onRecover();
          this._moveEndTime = 0;
          this._attacker = null;
          this._hurter = null;
          this._hurtPart = null;
      }
      setTarget(attacker, hurter, hurtPart, origin, targetPos, hitTag, gunID, hitObj) {
          this.setModel(attacker.gun.gunCfg.bulletID);
          this._attacker = attacker;
          this._hurter = hurter;
          this._hurtPart = hurtPart;
          this._isRole = attacker.isRolePlayer();
          this._hitTag = hitTag;
          this._gunID = gunID;
          let pos = this.transform.position;
          origin.cloneTo(pos);
          this.transform.position = pos;
          Vector3$6.subtract(targetPos, origin, this._dir);
          Vector3$6.normalize(this._dir, this._dir);
          Vector3$6.scale(this._dir, Bullet.SPEED, this._velocity);
          Vector3Ex.ZERO.cloneTo(this.point);
          Vector3Ex.ZERO.cloneTo(this.normal);
          this.ownerSp = null;
          if (hitObj && hitObj.point) {
              hitObj.point.cloneTo(this.point);
              hitObj.normal.cloneTo(this.normal);
              this.ownerSp = hitObj.owner;
          }
          let dist = Vector3$6.distance(origin, targetPos);
          let moveTime = (dist / Bullet.SPEED) * DataMgr.FixedDeltaTime * 1000;
          this._moveEndTime = DataMgr.nowTime + moveTime;
          ExUtils.LayaLookAt(this.transform, targetPos);
          targetPos.cloneTo(this._targetPos);
      }
      onHurt() {
          if (this._attacker.isRolePlayer() && Laya.Vector3.scalarLength(this.point) != 0) {
              let pos = this.transform.position;
              this.point.cloneTo(pos);
              this.transform.position = pos;
              pos.cloneTo(this._velocity);
              Laya.Vector3.scale(this.normal, 0.1, this._dir);
              Laya.Vector3.add(this._velocity, this._dir, this._velocity);
              this.transform.lookAt(this._velocity, Vector3Ex.Up, false);
              this._velocity.cloneTo(this._targetPos);
          }
          if (this.cfg.harmRadial != 0) {
              let _camp = this._attacker.getCamp();
              let players = _camp == PlayerCamp.Enemy ? DataMgr.instance._players : DataMgr.instance._enemys;
              for (let i = 0, cnt = players.length; i < cnt; i++) {
                  let player = players[i];
                  if (player.isDead)
                      continue;
                  if (Vector3$6.distance(player.transform.position, this._targetPos) <= this.cfg.harmRadial) {
                      player.hurtByBullet(this._hurtPart, this._attacker, this._targetPos, this.transform.rotationEuler, this._gunID, this.ownerSp);
                  }
              }
          }
          else {
              if (this._hurter) {
                  super.showHitEffect();
                  this._hurter.hurtByBullet(this._hurtPart, this._attacker, this._targetPos, this.transform.rotationEuler, this._gunID, this.ownerSp);
              }
          }
      }
      showSceneEffect() {
          if (this._hitTag != -1 && this._isRole && !this._hurter) {
              super.showSceneEffect();
          }
          else {
              DataMgr.instance.recoverProp(this);
          }
      }
  }
  Bullet.TAIL_START_TIME = 20;
  Bullet.TAIL_END_TIME = 500;
  Bullet.SPEED = 6;

  var Vector3$a = Laya.Vector3;
  class Grenade extends BaseProp {
      constructor() {
          super();
          this._gravity = new Vector3$a(0, -9.8, 0);
          this._dir = new Vector3$a();
          this._flying = false;
          this._vec = new Vector3$a();
          this._tempVec = new Vector3$a();
          this.target = new Laya.Vector3();
          this.speed = 20;
          this.verticalSpeed = 0;
          this.g = 9.8 * 0.16;
          this.angle = 0;
          this.angleSpeed = 0;
          this.moveDirection = new Laya.Vector3();
          this._isAI = true;
          this.time = 0;
      }
      onAwake() {
          super.onAwake();
      }
      onUpdate() {
          if (this._flying) {
              if (this.transform.position.y < DataMgr.instance.roleHeight) {
                  this.explode();
                  this._flying = false;
                  return;
              }
              if (this._isAI) {
                  this.time += DataMgr.deltaTime;
                  let test = this.verticalSpeed - this.g * this.time;
                  Laya.Vector3.normalize(this.moveDirection, this._vec);
                  Laya.Vector3.scale(this._vec, this.speed * DataMgr.deltaTime, this._vec);
                  Laya.Vector3.scale(Vector3Ex.Up, test * DataMgr.deltaTime, this._tempVec);
                  Laya.Vector3.add(this._vec, this._tempVec, this._vec);
                  this.transform.translate(this._vec, false);
                  let testAngle = -this.angle + this.angleSpeed * this.time;
                  let rot = this.transform.rotationEuler;
                  rot.setValue(testAngle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
                  this.transform.rotationEuler = rot;
              }
              else {
                  Laya.Vector3.add(this._dir, this._gravity, this._dir);
                  Laya.Vector3.scale(this._dir, DataMgr.FixedDeltaTime, this._tempVec);
                  Laya.Vector3.add(this._tempVec, this.transform.position, this._vec);
                  this.transform.lookAt(this._vec, Vector3Ex.Up, false);
                  this.transform.translate(this._tempVec, false);
              }
          }
          super.onUpdate();
      }
      onRecover() {
          super.onRecover();
      }
      startFly(curPos, dir, attack, gunCfg) {
          this.setModel(gunCfg.bulletID);
          this._gravity.y = -this.cfg.bulletGravitationalSpeed;
          Utils.vec3ToTargetVal('position', 1, this.gameObject, curPos);
          this._gunID = gunCfg.gunID;
          dir.cloneTo(this._dir);
          Laya.Vector3.scale(this._dir, this.cfg.bulletSpeed, this._dir);
          this._isAI = false;
          this._attack = attack;
          this._flying = true;
      }
      setAITarget(attack, pos, dir, gunCfg, target) {
          this.setModel(gunCfg.bulletID);
          this._gunID = gunCfg.gunID;
          Utils.vec3ToTargetVal('position', 1, this.gameObject, pos);
          this.time = 0;
          target.cloneTo(this.target);
          this.transform.position.cloneTo(this._vec);
          let tempDistance = Laya.Vector3.distance(this._vec, target);
          let tempTime = tempDistance / this.speed;
          let riseTime = tempTime / 2;
          this.transform.lookAt(target, Vector3Ex.Up);
          this.verticalSpeed = this.g * riseTime;
          let hu = Math.atan(this.verticalSpeed / this.speed);
          this.angle = (180 / Math.PI) * hu;
          let rot = this.transform.rotationEuler;
          rot.setValue(-this.angle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
          this.transform.rotationEuler = rot;
          this.angleSpeed = this.angle / riseTime;
          Laya.Vector3.subtract(target, this.transform.position, this.moveDirection);
          this._isAI = true;
          this._attack = attack;
          this._flying = true;
      }
      explode() {
          let self = this;
          this.transform.localPositionY = DataMgr.instance.roleHeight;
          let players = self._attack.getCamp() == PlayerCamp.Enemy
              ? DataMgr.instance._players
              : DataMgr.instance._enemys;
          for (let i = 0, cnt = players.length; i < cnt; i++) {
              let player = players[i];
              if (player.isDead)
                  continue;
              if (Vector3$a.distance(this.transform.position, player.transform.position) <=
                  this.cfg.harmRadial) {
                  player.hurtByBullet(PlayerPart.Body, this._attack, this.transform.position, this.transform.rotationEuler, this._gunID, player.getBodyCenter());
              }
          }
          this.showRangeHitEffect();
      }
  }

  var Ray$2 = Laya.Ray;
  var HitResult$2 = Laya.HitResult;
  var Vector3$9 = Laya.Vector3;
  class Missile extends BaseProp {
      constructor() {
          super();
          this._vec = new Laya.Vector3();
          this._tempVec = new Laya.Vector3();
          this._curSpeed = 0;
          this._addSpeed = 0;
          this._isStop = false;
          this._bulletLifeTime = 0;
          this._rot = new Laya.Quaternion();
      }
      onAwake() {
          super.onAwake();
          this._ray = new Ray$2(new Vector3$9(0, 0, 0), new Vector3$9(0, 0, 0));
          this._result = new HitResult$2();
      }
      onUpdate() {
          if (this._isStop)
              return;
          this.transform.getForward(this._vec);
          if (Utils.isEmpty(this._hitPlayer) || this._hitPlayer.isDead) {
              this.checkAttack();
              return;
          }
          let attPos = this._hitPlayer.transform.position;
          this.transform.lookAt(attPos, Vector3Ex.Up, false);
          this.transform.getForward(this._vec);
          Laya.Vector3.scale(this._vec, this._curSpeed, this._tempVec);
          if (Laya.Vector3.scalarLength(this._tempVec) >
              Laya.Vector3.distance(this.transform.position, attPos)) {
              this.checkAttack();
          }
          else {
              this.transform.translate(this._tempVec, false);
              this._curSpeed += this._addSpeed;
              let origin = this._ray.origin;
              let direction = this._ray.direction;
              this.transform.position.cloneTo(origin);
              this._vec.cloneTo(direction);
              this._ray.origin = origin;
              this._ray.direction = direction;
              DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, 1);
              if (this._result.succeeded) {
                  this.checkAttack();
              }
              if (this._bulletLifeTime < DataMgr.nowTime) {
                  this.checkAttack();
              }
          }
          super.onUpdate();
      }
      setTarget(attack, hitPlayer, pos, dir, gunCfg) {
          Utils.vec3ToTargetVal('position', 1, this.gameObject, pos);
          this._isStop = false;
          this._player = attack;
          this._hitPlayer = hitPlayer;
          this.setModel(gunCfg.bulletID);
          this._gunCfg = gunCfg;
          this._curSpeed = this.cfg.bulletSpeed;
          this._addSpeed = this.cfg.bulletSpeedDelt;
          this._bulletLifeTime = this.cfg.bulletLifeTime + DataMgr.nowTime;
      }
      checkAttack() {
          this._isStop = true;
          let pos = this.transform.position;
          this._hitPlayer.transform.position.cloneTo(pos);
          this.transform.position = pos;
          let isHit = false;
          let props = this._player.getCamp() == PlayerCamp.Enemy
              ? DataMgr.instance._players
              : DataMgr.instance._enemys;
          let len = props.length;
          for (let i = 0; i < len; i++) {
              let veh = props[i];
              if (this._player.getCamp() != veh.getCamp()) {
                  if (veh.isDead)
                      continue;
                  if (Laya.Vector3.distance(veh.transform.position, this.transform.position) <=
                      this.cfg.harmRadial) {
                      veh.hurtByCannon(this._player, this.transform.position, this.transform.rotationEuler, 1000, this._gunCfg.gunID);
                      isHit = true;
                  }
              }
          }
          if (this._player.isRolePlayer() && isHit) {
              UmengPlatform.trackEvent('zhandou', {
                  wqmz: this._gunCfg.gunID
              });
              if (this._player._veh) {
                  UmengPlatform.trackEvent('zhandou', {
                      zjkh: this._player._veh.cfg.vehID
                  });
              }
          }
          this.showRangeHitEffect();
      }
      onRecover() {
          super.onRecover();
      }
  }

  var Ray$1 = Laya.Ray;
  var HitResult$1 = Laya.HitResult;
  var Vector3$8 = Laya.Vector3;
  class Rocket extends BaseProp {
      constructor() {
          super();
          this._dir = new Laya.Vector3();
          this._vec = new Laya.Vector3();
          this._vec1 = new Laya.Vector3();
          this.target = new Laya.Vector3();
          this._curSpeed = 0;
          this._addSpeed = 0;
          this._isStop = false;
          this.speed = 20;
          this.verticalSpeed = 0;
          this.g = 9.8 * 0.35;
          this.angle = 0;
          this.angleSpeed = 0;
          this.moveDirection = new Laya.Vector3();
          this._isAI = true;
          this.time = 0;
          this._tempVec = new Vector3$8();
      }
      onAwake() {
          super.onAwake();
          this._ray = new Ray$1(new Vector3$8(0, 0, 0), new Vector3$8(0, 0, 0));
          this._result = new HitResult$1();
      }
      onUpdate() {
          if (this._isStop)
              return;
          if (this._isAI) {
              this.time += DataMgr.deltaTime;
              let test = this.verticalSpeed - this.g * this.time;
              Laya.Vector3.normalize(this.moveDirection, this._vec);
              Laya.Vector3.scale(this._vec, this.speed * DataMgr.deltaTime, this._vec);
              Laya.Vector3.scale(Vector3Ex.Up, test * DataMgr.deltaTime, this._tempVec);
              Laya.Vector3.add(this._vec, this._tempVec, this._vec);
              this.transform.translate(this._vec, false);
              let testAngle = -this.angle + this.angleSpeed * this.time;
              let rot = this.transform.rotationEuler;
              rot.setValue(testAngle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
              this.transform.rotationEuler = rot;
          }
          else {
              this._dir.cloneTo(this._vec);
              Laya.Vector3.scale(this._vec, (this._curSpeed + this._addSpeed / 2) * DataMgr.FixedDeltaTime, this._vec);
              this._curSpeed += this._addSpeed;
              this.transform.translate(this._vec, false);
              if (this._curSpeed <= 0) {
                  this.checkAttack();
                  return;
              }
          }
          let direction = this._ray.direction;
          let origin = this._ray.origin;
          this.transform.position.cloneTo(origin);
          this._dir.cloneTo(direction);
          this._ray.direction = direction;
          this._ray.origin = origin;
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, Laya.Vector3.scalarLength(this._vec));
          if (this._result.succeeded && this._result.collider.owner.parent.name != 'Barrel') {
              let pos = this.transform.position;
              this._result.point.cloneTo(pos);
              pos.y = DataMgr.instance.roleHeight + 0.2;
              this.transform.position = pos;
              this.checkAttack();
              return;
          }
          if (this.transform.position.y < DataMgr.instance.roleHeight + 0.2) {
              this.checkAttack();
              return;
          }
          super.onUpdate();
      }
      setTarget(attack, pos, dir, gunCfg) {
          this.setModel(gunCfg.bulletID);
          this._gunCfg = gunCfg;
          this._curSpeed = this.cfg.bulletSpeed;
          this._addSpeed = this.cfg.bulletSpeedDelt;
          Utils.vec3ToTargetVal('position', 1, this.gameObject, pos);
          dir.cloneTo(this._dir);
          Laya.Vector3.scale(this._dir, -1, this._dir);
          this._dir.cloneTo(this._vec);
          Laya.Vector3.scale(this._vec, (this._curSpeed + this._addSpeed / 2) * DataMgr.FixedDeltaTime, this._vec);
          Laya.Vector3.add(this.transform.position, this._vec, this._vec1);
          ExUtils.LayaLookAt(this.transform, this._vec1, false);
          this._isStop = false;
          this._player = attack;
          this._isAI = false;
      }
      setAITarget(attack, pos, dir, gunCfg, target) {
          this.setModel(gunCfg.bulletID);
          this._gunCfg = gunCfg;
          target.cloneTo(this.target);
          Utils.vec3ToTargetVal('position', 1, this.gameObject, pos);
          this.transform.position.cloneTo(this._vec);
          let tempDistance = Laya.Vector3.distance(this._vec, target);
          let tempTime = tempDistance / this.speed;
          let riseTime = tempTime / 2;
          this.transform.lookAt(target, Vector3Ex.Up);
          this.verticalSpeed = this.g * riseTime;
          let hu = Math.atan(this.verticalSpeed / this.speed);
          this.angle = (180 / Math.PI) * hu;
          let rot = this.transform.rotationEuler;
          rot.setValue(-this.angle, this.transform.rotationEuler.y, this.transform.rotationEuler.z);
          this.transform.rotationEuler = rot;
          this.angleSpeed = this.angle / riseTime;
          Laya.Vector3.subtract(target, this.transform.position, this.moveDirection);
          Vector3Ex.Down.cloneTo(this._dir);
          this._isAI = true;
          this._isStop = false;
          this._player = attack;
      }
      onRecover() {
          this.time = 0;
          super.onRecover();
      }
      checkAttack() {
          this._isStop = true;
          let isHit = false;
          let props = this._player.getCamp() == PlayerCamp.Teammate
              ? DataMgr.instance._enemys
              : DataMgr.instance._players;
          let len = props.length;
          for (let i = 0; i < len; i++) {
              let player = props[i];
              if (player.isDead)
                  continue;
              if (Laya.Vector3.distance(player.transform.position, this.transform.position) <=
                  this.cfg.harmRadial) {
                  player.hurtByCannon(this._player, this.transform.position, this.transform.rotationEuler, 1000, this._gunCfg.gunID);
                  isHit = true;
              }
          }
          if (this._player.isRolePlayer() && isHit) {
              UmengPlatform.trackEvent('zhandou', {
                  wqkh: this._gunCfg.gunID
              });
              if (this._player._veh) {
                  UmengPlatform.trackEvent('zhandou', {
                      zjkh: this._player._veh.cfg.vehID
                  });
              }
          }
          this.showRangeHitEffect();
      }
  }

  var Sprite3D$2 = Laya.Sprite3D;
  class PropMgr {
      constructor() { }
      static get instance() {
          if (PropMgr._instance == null) {
              PropMgr._instance = new PropMgr();
          }
          return PropMgr._instance;
      }
      getProp(propType, name) {
          let prop = Laya.Pool.getItem(name);
          if (prop == null) {
              let prefab = new Sprite3D$2(name, false);
              let obj = Sprite3D$2.instantiate(prefab, DataMgr.instance.propParent, false);
              if (propType == PropType.Bullet) {
                  prop = obj.addComponent(Bullet);
              }
              else if (propType == PropType.Bomb) {
                  prop = obj.addComponent(Bomb);
              }
              else if (propType == PropType.Rocket) {
                  prop = obj.addComponent(Rocket);
              }
              else if (propType == PropType.Missile) {
                  prop = obj.addComponent(Missile);
              }
              else if (propType == PropType.Grenade) {
                  prop = obj.addComponent(Grenade);
              }
              else if (propType == PropType.BombPlacement) {
                  prop = obj.addComponent(BombPlacement);
              }
          }
          if (prop) {
              DataMgr.instance.propParent.addChild(prop.owner);
              prop.owner.active = true;
          }
          return prop;
      }
  }
  PropMgr._instance = null;

  class VehCollider extends Laya.Script3D {
  }

  var Vector3$c = Laya.Vector3;
  var Vector2 = Laya.Vector2;
  var Ray$3 = Laya.Ray;
  var HitResult$3 = Laya.HitResult;
  var Handler$2 = Laya.Handler;
  class Gun extends BaseProp {
      constructor() {
          super();
          this.maxBulletCnt = 20;
          this.fireCD = 300;
          this.attackPos = new Vector3$c();
          this.targetPos = new Laya.Vector3();
          this.index = 0;
          this.isCanFire = true;
          this._attackCnt = 5;
          this.isFiring = false;
          this.hitTag = -1;
          this._vec = new Vector3$c();
          this._vec1 = new Vector3$c();
          this._vec2 = new Vector3$c();
          this._vec3 = new Vector3$c();
          this._tempVec = new Vector3$c();
          this._dir = new Vector3$c();
          this._fireTime = 0;
          this._bulletCnt = 0;
          this._viewPos = new Vector2();
          this._curAttackCnt = 0;
          this._cameraLookPos = new Laya.Vector3();
          this._gunComp_scope = -1;
          this._gunComp_barrel = -1;
          this._gunComp_stock = -1;
          this._gunComp_magazine = -1;
          this._gunComp_butt = -1;
          this._isShowAim = true;
          this.RAY_DIST = 100;
          this.MAX_DIST = 200;
      }
      onAwake() {
          super.onAwake();
          this._ray = new Ray$3(new Vector3$c(0, 0, 0), new Vector3$c(0, 0, 0));
          this._cameraRay = new Ray$3(new Vector3$c(0, 0, 0), new Vector3$c(0, 0, 0));
          this._result = new HitResult$3();
          this._centerPoint = new Vector2(Laya.stage.width * 0.5, Laya.stage.height * 0.5);
          this.launchTf = this.transform;
      }
      onUpdate() { }
      onDestroy() {
          this._ray = null;
          this._result = null;
          this.launchTf = null;
          this.player = null;
          this.attackPos = null;
          this._centerPoint = null;
          this._vec = null;
          this.hurtPlayer = null;
          super.onDestroy();
      }
      onRecover() {
          DataMgr.instance.recoverEffect(this._fireEffect);
          DataMgr.instance.recoverEffect(this._slot_OutputEffect);
          DataMgr.instance.recoverEffect(this._gunModel);
          Tween.clear(this.transform);
          this._rotatorGun = null;
          this._modelName = '';
          this._fireEffect =
              this._slot_OutputEffect =
                  this.magazine =
                      this.player =
                          this.hurtPlayer =
                              this._shootInfo =
                                  this._gunModel =
                                      null;
          this._gunComp_butt =
              this._gunComp_magazine =
                  this._gunComp_stock =
                      this._gunComp_scope =
                          this._gunComp_barrel =
                              -1;
      }
      set bulletCnt(val) {
          this._bulletCnt = val;
          if (!this._isCatapult) {
              this.refreshBullet();
          }
      }
      get bulletCnt() {
          return this._bulletCnt;
      }
      get magazineNumber() {
          return this._magazineNumber;
      }
      set magazineNumber(val) {
          this._magazineNumber = val;
          if (this.player && this.player.isRolePlayer() && !this._isCatapult) {
              EventMgr.event(EventType.RoleRefreshMagazine, [this._magazineNumber, this.index]);
          }
      }
      refreshBullet() {
          if (this.player && this.player.isRolePlayer()) {
              EventMgr.event(EventType.RoleRefreshBullet, [this._bulletCnt, this.index]);
          }
      }
      refreshVehShow() {
          EventMgr.event(EventType.RoleRefreshBullet, [this._bulletCnt, this.index]);
          EventMgr.event(EventType.RoleRefreshMagazine, [this._magazineNumber, this.index]);
      }
      setAttackCnt() {
          if (this.player.isUseVeh) {
              this._attackCnt = 0;
          }
          else {
              let aiAttackTimeBulletNum = this.player.aiCfg.aiAttackTimeBulletNum;
              this._attackCnt =
                  (aiAttackTimeBulletNum[0] +
                      Math.random() * (aiAttackTimeBulletNum[1] - aiAttackTimeBulletNum[0])) |
                      0;
          }
      }
      isHasScope() {
          return this._gunComp_scope > 0;
      }
      get scopeInfo() {
          let cfg = CfgDataMgr.instance.gunComponentCfg[this._gunComp_scope];
          return cfg;
      }
      get getFiring() {
          return this.isFiring;
      }
      checkCanFire() {
          return (this.isCanFire = this._magazineNumber > 0 || this.bulletCnt > 0);
      }
      get isHasCatapult() {
          return this._gunComp_stock > 0;
      }
      get gun_barrel() {
          return this._gunComp_stock;
      }
      setCatapult() {
          this._isCatapult = true;
      }
      isCatapult() {
          return this._isCatapult;
      }
      switchCatapult(isCatapult) {
          this._fireTime += 1000;
          this.player.fsm.changeState(FSMState.SwitchCatapultState);
      }
      get isUseCatapult() {
          return false;
      }
      get camSlot() {
          return this._camSlot_FPS_Aim;
      }
      setGunId(gunId, player, index) {
          this.parentTr = this.gameObject.parent.transform;
          this.dataBind(player, index);
          this.initGunRatio(gunId);
          if (!player.isRolePlayer() && !player.isUseVeh && index == 1) {
              return;
          }
          this.changeModel(this.gunCfg.gunModel);
      }
      dataBind(player, index) {
          this.player = player;
          this.index = index;
          if (player.curType == curType.HuMan) {
          }
          else if (player.curType == curType.Tank) {
              let _rotator = this.player.gameObject.getChildAt(0);
              this._barrel = ExUtils.findChild(_rotator, 'Barrel');
          }
          else if (player.curType == curType.Air) {
          }
          this._collisonGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
          if (this.player.getCamp() == PlayerCamp.Teammate) {
              this.collisionWith =
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                      Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2;
          }
          else {
              this.collisionWith =
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                      Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3;
          }
      }
      setData(data, info = null) {
          if (!this._isCatapult) {
              if (!Utils.isEmpty(data)) {
                  for (let key in data) {
                      this['_' + key] = data[key];
                  }
              }
              if (this.gunCfg.defaultAccessoriesID > 0) {
                  this._gunComp_scope = this.gunCfg.defaultAccessoriesID;
              }
          }
          this._mechanicalSight = CfgDataMgr.instance.gunComponentCfg[100000];
          this._isShowAim = this.gunCfg.defaultAccessoriesID >= 0;
          if (this.index == 0 && this.player.isRolePlayer()) {
              EventMgr.event(EventType.RefreshAimBtn, this._isShowAim);
          }
          if (info) {
              this.bulletCnt = info[0];
              this.magazineNumber = info[1];
          }
      }
      isShowAim() {
          return this._isShowAim;
      }
      get mechanicalSight() {
          return this._mechanicalSight;
      }
      initGunRatio(gunId) {
          this.gunCfg = CfgDataMgr.instance.gunAttributeCfg[gunId];
          this.RAY_DIST = this.gunCfg.radialRange;
          if (this.gunCfg.gunType == PropType.VehicleGunWeapon) {
              this.fireCD = this.gunCfg.reloadingTime;
          }
          else {
              this.fireCD = this.gunCfg.gunShootInterval;
          }
          this.gunName = CfgDataMgr.instance.resCfg[gunId].goodsName;
          if (this.player.curType != curType.HuMan) {
              this.maxBulletCnt = this.gunCfg.magazineClip;
              this.bulletCnt = this.player._veh['bullet' + this.index];
              this.magazineNumber = this.player._veh['clip' + this.index];
          }
          else {
              this.maxBulletCnt = this.gunCfg.magazineClip;
              this.bulletCnt = this.maxBulletCnt;
              this.magazineNumber = this.gunCfg.magazineNumber * this.gunCfg.magazineClip;
          }
          if (!this.player.isUseVeh) {
              this._shootInfo = {};
              this._shootInfo.verticalBaseExcursionAdd = this.gunCfg.verticalBaseExcursionAdd;
              this._shootInfo.verticalRandomExcursionAdd = this.gunCfg.verticalRandomExcursionAdd;
              this._shootInfo.verticalLimitExcursionAdd = this.gunCfg.verticalLimitExcursionAdd;
              this._shootInfo.horizontalBaseExcursionAdd = this.gunCfg.horizontalBaseExcursionAdd;
              this._shootInfo.horizontalRandomExcursionAdd = this.gunCfg.horizontalRandomExcursionAdd;
              this._shootInfo.horizontalLimitExcursionAdd = this.gunCfg.horizontalLimitExcursionAdd;
              this._shootInfo.recoilRecoverTime = this.gunCfg.recoilRecoverTime;
              this._shootInfo.verticalReadyLimitExcursionAdd = this.gunCfg.verticalReadyLimitExcursionAdd;
              this._shootInfo.recoilTime = this.gunCfg.recoilTime;
              this._shootInfo.curVerticalDeviation = 0;
              this._shootInfo.horRecoveryValue = 0;
              this._shootInfo.verRecoveryValue = 0;
              this._shootInfo.curHorizontalDeviation = 0;
              this._shootInfo.curRecoilRecoverTime = 0;
              this._shootInfo.verticalTotalValue = 0;
              this._shootInfo.verticalValue = 0;
              this._shootInfo.isCanHorMove = false;
              this._shootInfo.isRecover = false;
              this._shootInfo.isLeft = true;
          }
      }
      reset(isRefresh = false) {
          let cnt = this.magazineNumber;
          let addCnt = this.maxBulletCnt - this.bulletCnt;
          addCnt = cnt > addCnt ? addCnt : cnt;
          if (this.player.isRolePlayer()) {
              this.magazineNumber -= addCnt;
          }
          this.bulletCnt += addCnt;
          if (this.gunCfg.gunType == PropType.VehicleGunWeapon) {
              this._fireTime = DataMgr.nowTime;
          }
          else {
              this._fireTime = 0;
          }
          this.isFiring = false;
          if (isRefresh) {
              if (!this.player.isRolePlayer() && this.bulletCnt <= 0) {
                  this.player.switchArms(1);
              }
          }
      }
      fire() {
          let now = DataMgr.nowTime;
          if (now < this._fireTime + this.fireCD) {
              return false;
          }
          if (this.player.isRolePlayer() && this.propType == PropType.VehicleGunWeapon) {
              DataMgr.instance.isTankCom = false;
          }
          this._fireTime = now;
          if (this.bulletCnt > 0) {
              if (this.player.isRolePlayer()) {
                  UmengPlatform.trackEvent('zhandou', {
                      wqkh: this.gunCfg.gunID
                  });
              }
              this.bulletCnt--;
              this.onFired();
              return true;
          }
          return false;
      }
      onFired() {
          let self = this;
          let isRole = this.player.isRolePlayer();
          if (this.player.isUseVeh) {
              this.propType == PropType.VehicleGunWeapon && this.player._veh.playAttackAni();
          }
          else {
              this.player.setRoleAni(this.gunCfg.fire_action);
          }
          if (isRole) {
              EventMgr.event(EventType.RefreshSignAni);
          }
          else {
              this._curAttackCnt++;
              if (this._curAttackCnt > this._attackCnt) {
                  this._curAttackCnt -= this._attackCnt;
                  self.setFiring(false);
              }
          }
          let attackAniTime = 100;
          Laya.timer.once(attackAniTime, self, function () {
              if (self.bulletCnt <= 0) {
                  self.setFiring(false);
                  self.player.reload();
                  if (self.player.isRolePlayer() && self._magazineNumber <= 0 && self.bulletCnt <= 0) {
                      UmengPlatform.trackEvent('zhandou', self.index == 0
                          ? {
                              caozuo: '主弹药'
                          }
                          : {
                              caozuo: '副弹药'
                          });
                  }
              }
              else {
                  if (self.gunCfg.gunPullPlug == 1) {
                      self._fireTime += 1000 + attackAniTime;
                      if (self.player.isRoleAttackState()) {
                          self.player.fsm.changeState(FSMState.LoadingState);
                      }
                  }
              }
          });
          let showEffect = function (effect) {
              if (effect) {
                  effect.active = true;
                  Laya.timer.once(self.fireCD - 20, self, function () {
                      effect.active = false;
                  });
              }
          };
          Laya.timer.frameOnce(1, self, function () {
              showEffect(self._fireEffect);
              Laya.timer.frameOnce(1, self, function () {
                  showEffect(self._slot_OutputEffect);
              });
          });
          DataMgr.instance.playCfgSound(this.gunCfg.soundEffectFire, this.player.transform.position);
      }
      setFiring(val) {
          if (this.isFiring == val)
              return;
          this.isFiring = val;
          if (!val && this.player.isRolePlayer() && this._shootInfo) {
              this._shootInfo.verticalValue = 0;
          }
          if (this.player.isRolePlayer()) {
              if (DataMgr.instance.serialKill < DataMgr.instance.curSerialKill) {
                  DataMgr.instance.serialKill = DataMgr.instance.curSerialKill;
              }
              DataMgr.instance.curSerialKill = 0;
              if (DataMgr.instance.doubleHit < DataMgr.instance.curDoubleHit) {
                  DataMgr.instance.doubleHit = DataMgr.instance.curDoubleHit;
              }
              DataMgr.instance.curDoubleHit = 0;
              EventMgr.event(EventType.RefreshDoubleHit, false);
          }
      }
      calAttackPos() {
          if (this.player.isRolePlayer()) {
              if (!this.player.isUseVeh) {
                  let cameraCtrl = DataMgr.instance.cameraCtrl;
                  this._viewPos.setValue(this._centerPoint.x, this._centerPoint.y);
                  this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
                  this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
                  cameraCtrl.camera.viewportPointToRay(this._viewPos, this._ray);
                  this._shootInfo.verticalValue =
                      this._shootInfo.verticalBaseExcursionAdd +
                          this._shootInfo.verticalRandomExcursionAdd * Math.random();
                  this._viewPos.setValue(this._centerPoint.x, this._centerPoint.y - this._shootInfo.verticalValue);
                  this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
                  this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
                  cameraCtrl.camera.viewportPointToRay(this._viewPos, this._cameraRay);
                  Laya.Vector3.scale(this._cameraRay.direction, 250, this._cameraLookPos);
                  Laya.Vector3.add(this._cameraRay.origin, this._cameraLookPos, this._cameraLookPos);
              }
          }
          else if (!this.player.isUseVeh) {
              let cfg = this.player.aiCfg;
              if (this.gunCfg.bulletID == 100001) {
                  let random = Math.random();
                  let curRate = 0;
                  if (this.player.curTarget.isRolePlayer()) {
                      curRate = cfg.aiHitRate;
                  }
                  else {
                      curRate = cfg.aiMutualHitRate;
                  }
                  if (random > curRate)
                      return;
              }
              let arr = ['aiHeadHitRate', 'aiBodyHitRate', 'aiBodyHitRate'];
              let random = Math.random();
              let cnt = 0;
              let index = 0;
              for (let i = 0, len = arr.length; i < len; i++) {
                  cnt += cfg[arr[i]];
                  if (cnt >= random) {
                      index = i;
                      break;
                  }
              }
              switch (index) {
                  case 0:
                      this.player.curTarget.getHeadCenterPos().cloneTo(this._vec);
                      break;
                  case 1:
                      this.player.curTarget.getBodyCenterPos().cloneTo(this._vec);
                      break;
                  case 2:
                      this.player.curTarget.getBodyCenterPos().cloneTo(this._vec);
                      break;
              }
              let origin = this._ray.origin;
              let direction1 = this._ray.direction;
              this.launchTf.position.cloneTo(origin);
              Laya.Vector3.subtract(this._vec, this.launchTf.position, this._vec);
              Laya.Vector3.normalize(this._vec, this._vec);
              this._vec.cloneTo(direction1);
              this._ray.origin = origin;
              this._ray.direction = direction1;
          }
          this.hurtPlayer = null;
          this.hurtPart = PlayerPart.Body;
          switch (this.gunCfg.gunType) {
              case PropType.ShotGun:
                  this.setScatterWeaponFire();
                  break;
              case PropType.RocketLauncher:
                  break;
              case PropType.MissileLauncher:
                  if (this.player.isRolePlayer() && this.player._veh) {
                      UmengPlatform.trackEvent('zhandou', {
                          zjkh: this.player._veh.cfg.vehID
                      });
                  }
                  this.setMissileLauncherFire();
                  break;
              case PropType.GrenadeGun:
                  break;
              case PropType.VehicleGunWeapon:
                  if (this.player.isRolePlayer() && this.player._veh) {
                      UmengPlatform.trackEvent('zhandou', {
                          zjkh: this.player._veh.cfg.vehID
                      });
                  }
                  this.setVehicleGunWeaponFire();
                  break;
              case PropType.VehicleMachineGun:
                  if (this.player.isRolePlayer() && this.player._veh) {
                      UmengPlatform.trackEvent('zhandou', {
                          zjkh: this.player._veh.cfg.vehID
                      });
                  }
                  this.setVehicleMachineGunFire();
                  break;
              default:
                  this.setDirectWeaponFire();
                  break;
          }
          if (this.player.isRolePlayer() && !this.player.isUseVeh) {
              if (this._shootInfo.verticalValue != 0) {
                  DataMgr.instance.cameraCtrl.setLookAt(this._cameraLookPos);
              }
          }
      }
      checkAim() {
          let cameraCtrl = DataMgr.instance.cameraCtrl;
          this._viewPos.setValue(this._centerPoint.x, this._centerPoint.y - (this.player.isUseVeh ? 0 : this._shootInfo.verticalValue));
          this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
          this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
          cameraCtrl.camera.viewportPointToRay(this._viewPos, this._ray);
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST, this._collisonGroup, this.collisionWith);
          if (this._result.succeeded) {
              let owner = this._result.collider.owner;
              let collider = owner.getComponent(PlayerCollider);
              if (collider) {
                  let hurtPlayer = collider.player;
                  if (hurtPlayer.isDead == false) {
                      if (hurtPlayer.getCamp() != this.player.getCamp()) {
                          return true;
                      }
                  }
              }
              else {
                  let collider = owner.getComponent(VehCollider);
                  if (collider) {
                      let hurtPlayer = collider.veh.player;
                      if (hurtPlayer && collider.veh._isDead == false) {
                          if (hurtPlayer.getCamp() != this.player.getCamp()) {
                              return true;
                          }
                      }
                  }
              }
          }
          return false;
      }
      changeModel(name, callback = null) {
          let self = this;
          this._modelName = name;
          if (this.player.curType == curType.HuMan) {
              let path = DynamicSceneRoot + name + '.lh';
              ExUtils.instanceSprite3D(path, null, Handler$2.create(this, function (newModel) {
                  if (!self.gameObject) {
                      newModel.destroy();
                      return;
                  }
                  self.setGunModel(newModel, path);
                  callback && callback.run();
              }));
          }
          else {
              self.setVehicleModel();
              callback && callback.run();
          }
      }
      setGunModel(newModel, modelName) {
          let self = this;
          if (this.player && this.player.gameObject) {
              self.owner.addChild(newModel);
              newModel.name = modelName;
              this._gunModel = newModel;
              this.magazine = ExUtils.findChild(newModel, 'Magazine');
              Utils.vec3ToTargetVal('localPosition', 1, newModel);
              this._camSlot_FPS_Aim = ExUtils.findChild(this.player.gameObject, 'CamSlot_FPS_Aim');
              let posCfg = this.gunCfg.gunMountPointPos;
              let pos11 = this._camSlot_FPS_Aim.transform.localPosition;
              pos11.setValue(-posCfg[0], posCfg[1], posCfg[2]);
              this._camSlot_FPS_Aim.transform.localPosition = pos11;
              self.setEffect(newModel);
              if (SceneConst.Realtime_Shadow) {
                  ExUtils.setCastShadow(newModel, true);
              }
          }
      }
      setEffect(newModel) {
          let self = this;
          let launchNode = newModel.getChildByName('Slot_Fire');
          if (launchNode) {
              self.launchTf = launchNode.transform;
              if (self._fireEffect) {
                  self.launchTf.owner.addChild(self._fireEffect);
              }
              else {
                  if (self.gunCfg.fireEffect_scale) {
                      self._fireEffect = DataMgr.instance.createEffect('Rifle_Fire_ef', self.launchTf.owner);
                      self._vec.setValue(self.gunCfg.fireEffect_scale, self.gunCfg.fireEffect_scale, self.gunCfg.fireEffect_scale);
                      Utils.vec3ToTargetVal('localScale', 1, self._fireEffect, self._vec);
                  }
              }
              if (self._fireEffect) {
                  self._fireEffect.active = false;
                  Utils.vec3ToTargetVal('localPosition', 1, self._fireEffect);
                  Utils.vec3ToTargetVal('localRotationEuler', 1, self._fireEffect);
              }
              let slot_Output = ExUtils.findChild(newModel, 'Slot_Output');
              if (slot_Output) {
                  if (self._slot_OutputEffect) {
                      self.launchTf.owner.addChild(self._slot_OutputEffect);
                  }
                  else {
                      self._slot_OutputEffect = DataMgr.instance.createEffect(self.gunCfg.shellCaseEffect, self.launchTf.owner);
                  }
                  if (self._slot_OutputEffect) {
                      self._slot_OutputEffect.active = false;
                      Utils.vec3ToTargetVal('localPosition', 1, self._slot_OutputEffect);
                      Utils.vec3ToTargetVal('localRotationEuler', 1, self._slot_OutputEffect);
                  }
              }
          }
      }
      setVehicleModel() {
          let self = this;
          let prObj = this.gameObject.parent;
          this._camSlot_FPS_Aim = ExUtils.findChild(prObj, 'CameraAim');
          let cannonNode = ExUtils.findChild(prObj, 'Barrel');
          let launchNode = ExUtils.findChild(this.gameObject, 'RotatorGunA');
          if (this.player.curType == curType.Air) {
              let gun = ExUtils.findChild(this.player.gameObject, 'RotatorGunA');
              if (gun)
                  this._rotatorGun = gun.transform;
          }
          if (this.player.curType == curType.Tank && launchNode) {
              this.rotatorModel = cannonNode.parent.parent;
              if (this.player.isRolePlayer()) {
                  let _mParent = launchNode.parent;
                  _mParent.transform.localRotationEulerY = 180;
              }
          }
          if (this.propType == PropType.VehicleMachineGun) {
              launchNode = launchNode.getChildByName('Slot_Fire');
          }
          else if (this.propType == PropType.VehicleGunWeapon) {
              launchNode = cannonNode.getChildByName('Slot_Fire');
          }
          if (launchNode) {
              self.launchTf = launchNode.transform;
              if (this._fireEffect) {
                  self.launchTf.owner.addChild(this._fireEffect);
                  self._fireEffect.active = false;
              }
              else {
                  if (this.propType == PropType.VehicleMachineGun) {
                      if (self.gunCfg.fireEffect_scale) {
                          self._fireEffect = DataMgr.instance.createEffect('Rifle_Fire_ef', self.launchTf.owner);
                          self._vec.setValue(self.gunCfg.fireEffect_scale, self.gunCfg.fireEffect_scale, self.gunCfg.fireEffect_scale);
                          Utils.vec3ToTargetVal('localScale', 1, self._fireEffect, self._vec);
                      }
                  }
                  else {
                      self._fireEffect = DataMgr.instance.createEffect('TankMorden_Fire_ef', self.launchTf.owner);
                  }
                  self._fireEffect && (self._fireEffect.active = false);
              }
              if (self._fireEffect) {
                  Utils.vec3ToTargetVal('localPosition', 1, self._fireEffect);
                  Utils.vec3ToTargetVal('localRotationEuler', 1, self._fireEffect);
              }
          }
      }
      checkCanAttack(target = null) {
          if (target) {
              target.cloneTo(this._vec);
              this._vec.y += 1;
          }
          else {
              this.player.curTarget.getBodyCenterPos().cloneTo(this._vec);
          }
          let heroPos = this.player.heroModel.transform.position;
          heroPos.y += 1;
          Laya.Vector3.subtract(this._vec, heroPos, this._vec);
          Laya.Vector3.normalize(this._vec, this._vec);
          let origin = this._ray.origin;
          let direction = this._ray.direction;
          this._vec.cloneTo(direction);
          heroPos.cloneTo(origin);
          if (DataMgr.instance.scene) {
              DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST, this._collisonGroup, this.collisionWith);
              if (this._result.succeeded) {
                  let collider = this._result.collider.owner.getComponent(PlayerCollider);
                  let vehProp = this._result.collider.owner.getComponent(VehCollider);
                  if (collider) {
                      let hurtPlayer = collider.player;
                      if (hurtPlayer.isDead == false && hurtPlayer.getCamp() != this.player.getCamp()) {
                          return true;
                      }
                  }
                  else if (vehProp) {
                      let hurtPlayer = vehProp.veh.player;
                      if (hurtPlayer &&
                          vehProp.veh._isDead == false &&
                          hurtPlayer.getCamp() != this.player.getCamp()) {
                          return true;
                      }
                  }
                  return false;
              }
          }
          return false;
      }
      bombAttack(bombTime, throwId) {
          let cameraCtrl = DataMgr.instance.cameraCtrl;
          this._viewPos.setValue(Laya.stage.width / 2, 0);
          this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
          this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
          cameraCtrl.camera.viewportPointToRay(this._viewPos, this._ray);
          let bomb = PropMgr.instance.getProp(PropType.Bomb, 'Bomb');
          bomb.startFly(this.player._gunNodeR.transform.position, this._ray.direction, this.player, bombTime, throwId);
      }
      getVehAttackPos() {
          let origin = this._ray.origin;
          let direction = this._ray.direction;
          this._barrel.transform.getForward(this._vec);
          Laya.Vector3.scale(this._vec, -1, this._vec);
          this._vec.cloneTo(direction);
          this.launchTf.position.cloneTo(origin);
          this._ray.origin = origin;
          this._ray.direction = direction;
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST, this._collisonGroup, this.collisionWith);
          if (this._result.succeeded) {
              this._result.point.cloneTo(this._vec);
          }
          else {
              Vector3$c.scale(this._ray.direction, this.RAY_DIST, this._vec);
              Vector3$c.add(this._ray.origin, this._vec, this._vec);
          }
          EventMgr.event(EventType.RefreshCollimation, [this._vec.x, this._vec.y, this._vec.z]);
      }
      setDirectWeaponFire() {
          Vector3$c.scale(this._ray.direction, this.RAY_DIST, this._vec);
          Vector3$c.add(this._ray.origin, this._vec, this._vec);
          let num = Math.random() * 360;
          let r = this.gunCfg.droppointBulletRadial;
          let y = Math.sin(num) * r;
          let x = Math.cos(num) * r;
          this._vec.y += y;
          this._vec.x += x;
          Laya.Vector3.subtract(this._vec, this._ray.origin, this._vec);
          Laya.Vector3.normalize(this._vec, this._vec);
          let direction = this._ray.direction;
          this._vec.cloneTo(direction);
          this._ray.direction = direction;
          this.hitTag = -1;
          let attackInfo = new Object();
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST + this.MAX_DIST, this._collisonGroup, this.collisionWith);
          if (this._result.succeeded) {
              this._result.point.cloneTo(this.attackPos);
              let owner = this._result.collider.owner;
              this.hitTag = owner.layer;
              let collider = owner.getComponent(PlayerCollider);
              if (collider) {
                  let hurtPlayer = collider.player;
                  if (hurtPlayer.isDead == false) {
                      if (hurtPlayer.getCamp() != this.player.getCamp()) {
                          this.hurtPlayer = hurtPlayer;
                          this.hurtPart = collider.playerPart;
                      }
                      else {
                          this.hitTag = -1;
                      }
                  }
                  else {
                      this.hitTag = -1;
                  }
              }
              else {
                  let collider = owner.getComponent(VehCollider);
                  if (collider) {
                      this.hitTag = 8;
                      let hurtPlayer = collider.veh.player;
                      if (hurtPlayer && hurtPlayer.isDead == false) {
                          if (hurtPlayer.getCamp() != this.player.getCamp()) {
                              this.hurtPlayer = hurtPlayer;
                              this.hurtPart = PlayerPart.Body;
                          }
                      }
                  }
              }
              attackInfo = {
                  point: this._result.point,
                  normal: this._result.normal,
                  owner: owner
              };
              if (this.player.isRolePlayer() && this.hurtPlayer) {
                  UmengPlatform.trackEvent('zhandou', {
                      wqkh: this.gunCfg.gunID
                  });
              }
              let bullet = PropMgr.instance.getProp(PropType.Bullet, 'Bullet');
              bullet.setTarget(this.player, this.hurtPlayer, this.hurtPart, this.launchTf.position, this.attackPos, this.hitTag, this.gunCfg.gunID, attackInfo);
          }
      }
      setScatterWeaponFire() {
          let cnt = this.gunCfg.droppointBulletNum;
          this.hitTag = -1;
          this._ray.direction.cloneTo(this._tempVec);
          let index = 0;
          for (let i = 0; i < cnt; i++) {
              if (Utils.isEmpty(this._gunModel))
                  return;
              this.hurtPlayer = null;
              this.hurtPart = PlayerPart.Body;
              this._tempVec.cloneTo(this._vec);
              Vector3$c.scale(this._vec, this.RAY_DIST, this._vec);
              this._tempVec.cloneTo(this._vec3);
              Vector3$c.scale(this._vec3, this.RAY_DIST, this._vec3);
              let r = this.gunCfg.droppointBulletRadial;
              index++;
              if (index == 1) {
                  this._gunModel.transform.getRight(this._vec1);
                  this._gunModel.transform.getUp(this._vec2);
              }
              else if (index == 2) {
                  this._gunModel.transform.getRight(this._vec1);
                  Laya.Vector3.scale(this._vec1, -1, this._vec1);
                  this._gunModel.transform.getUp(this._vec2);
              }
              else if (index == 3) {
                  this._gunModel.transform.getRight(this._vec1);
                  this._gunModel.transform.getUp(this._vec2);
                  Laya.Vector3.scale(this._vec2, -1, this._vec2);
              }
              else if (index == 4) {
                  index = 0;
                  this._gunModel.transform.getRight(this._vec1);
                  this._gunModel.transform.getUp(this._vec2);
                  Laya.Vector3.scale(this._vec2, -1, this._vec2);
                  Laya.Vector3.scale(this._vec1, -1, this._vec1);
              }
              Laya.Vector3.scale(this._vec1, r, this._vec1);
              Vector3$c.add(this._ray.origin, this._vec, this._vec);
              Laya.Vector3.add(this._vec, this._vec1, this._vec1);
              Laya.Vector3.scale(this._vec2, r, this._vec2);
              Vector3$c.add(this._ray.origin, this._vec3, this._vec3);
              Laya.Vector3.add(this._vec3, this._vec2, this._vec2);
              Laya.Vector3.lerp(this._vec1, this._vec2, Math.random(), this._vec);
              Laya.Vector3.subtract(this._vec, this._ray.origin, this._vec);
              Laya.Vector3.normalize(this._vec, this._vec);
              let direction = this._ray.direction;
              this._vec.cloneTo(direction);
              this._ray.direction = direction;
              let attackInfo = new Object();
              DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST + this.MAX_DIST, this._collisonGroup, this.collisionWith);
              if (this._result.succeeded) {
                  this._result.point.cloneTo(this.attackPos);
                  let owner = this._result.collider.owner;
                  this.hitTag = owner.layer;
                  let collider = owner.getComponent(PlayerCollider);
                  if (collider) {
                      let hurtPlayer = collider.player;
                      if (hurtPlayer.isDead == false && hurtPlayer.getCamp() != this.player.getCamp()) {
                          this.hurtPlayer = hurtPlayer;
                          this.hurtPart = collider.playerPart;
                      }
                  }
                  attackInfo = {
                      point: this._result.point,
                      normal: this._result.normal,
                      owner: owner
                  };
                  if (this.player.isRolePlayer() && this.hurtPlayer) {
                      UmengPlatform.trackEvent('zhandou', {
                          wqkh: this.gunCfg.gunID
                      });
                  }
                  let bullet = PropMgr.instance.getProp(PropType.Bullet, 'Bullet');
                  bullet.setTarget(this.player, this.hurtPlayer, this.hurtPart, this.launchTf.position, this.attackPos, this.hitTag, this.gunCfg.gunID, attackInfo);
              }
          }
      }
      setVehicleMachineGunFire() {
          this.hurtPlayer = null;
          this.hurtPart = PlayerPart.Body;
          this.hitTag = -1;
          let direction = this._ray.direction;
          let origin = this._ray.origin;
          if (this.player.isRolePlayer()) {
              if (this._barrel) {
                  this._barrel.transform.getForward(this._dir);
              }
              else {
                  this.launchTf.getForward(this._dir);
              }
              Laya.Vector3.scale(this._dir, -1, this._dir);
          }
          else {
              Laya.Vector3.subtract(this.targetPos, this.launchTf.position, this._dir);
              Laya.Vector3.normalize(this._dir, this._dir);
          }
          Laya.Vector3.scale(this._dir, 5, this._tempVec);
          Laya.Vector3.add(this._tempVec, this.launchTf.position, this._tempVec);
          ExUtils.LayaLookAt(this.launchTf, this._tempVec);
          this._dir.cloneTo(direction);
          this._ray.direction = direction;
          let pos = this.launchTf.position;
          pos.cloneTo(origin);
          this._ray.origin = origin;
          let attackInfo = new Object();
          DataMgr.instance.scene.physicsSimulation.rayCast(this._ray, this._result, this.RAY_DIST + this.MAX_DIST, this._collisonGroup, this.collisionWith);
          if (this._result.succeeded) {
              this._result.point.cloneTo(this.attackPos);
              let owner = this._result.collider.owner;
              this.hitTag = owner.layer;
              let collider = owner.getComponent(PlayerCollider);
              if (collider) {
                  let hurtPlayer = collider.player;
                  if (hurtPlayer.isDead == false && hurtPlayer.getCamp() != this.player.getCamp()) {
                      this.hurtPlayer = hurtPlayer;
                      this.hurtPart = collider.playerPart;
                  }
              }
              attackInfo = {
                  point: this._result.point,
                  normal: this._result.normal,
                  owner: owner
              };
              if (this.player.isRolePlayer() && this.hurtPlayer) {
                  UmengPlatform.trackEvent('zhandou', {
                      wqkh: this.gunCfg.gunID
                  });
                  if (this.player._veh) {
                      UmengPlatform.trackEvent('zhandou', {
                          zjkh: this.player._veh.cfg.vehID
                      });
                  }
              }
              let bullet = PropMgr.instance.getProp(PropType.Bullet, 'Bullet');
              bullet.setTarget(this.player, this.hurtPlayer, this.hurtPart, this.launchTf.position, this.attackPos, this.hitTag, this.player.gun.gunCfg.gunID, attackInfo);
          }
      }
      setVehicleGunWeaponFire() { }
      setProjectileWeaponFire() { }
      setMissileLauncherFire() {
          let arr = this.player.getCamp() == PlayerCamp.Enemy
              ? DataMgr.instance._players
              : DataMgr.instance._enemys;
          let hitArr = [];
          let len = arr.length;
          for (let i = 0; i < len; i++) {
              if (arr[i].isVisible()) {
                  hitArr.push(arr[i]);
              }
          }
          let index = (Math.random() * hitArr.length) | 0;
          this.hurtPlayer = hitArr[index];
      }
      setDrop(isDrop = true) {
          if (!isDrop) {
              Utils.removeArrayObj(this.player._gunArr, this.player.gun);
              DataMgr.instance.recoverProp(this);
              return;
          }
          if (!DataMgr.instance.isGamming())
              return;
          let ranodm = Math.random();
          let val = CfgDataMgr.instance.getGlobalCfg('roleDeathDropGunProbability');
          if (ranodm > val)
              return;
          EventMgr.event(EventType.ShowDropInfo, [this.player.playerName, this.gunName]);
          Utils.removeArrayObj(this.player._gunArr, this.player.gun);
          this.player.transform.position.cloneTo(this._vec);
          this._vec.y = 6;
          DataMgr.instance.addChildToRoot(this.gameObject);
          let pos = this.transform.position;
          this._vec.cloneTo(pos);
          this.transform.position = pos;
          DataMgr.instance.dropGunArr.push(this);
          Tween.once(this.transform, {
              loop: true
          })
              .to({
              localPositionY: 6.5
          }, 3000, null)
              .to({
              localPositionY: 6
          }, 3000, null);
          this.player.gun = null;
          Laya.timer.once(10000, this, this.recoveGun);
      }
      clearPickUp(player) {
          Tween.clear(this.transform);
          Utils.vec3ToTargetVal('localPosition', 1, this.gameObject);
          Utils.vec3ToTargetVal('localRotationEuler', 1, this.gameObject);
          Utils.removeArrayObj(DataMgr.instance.dropGunArr, this);
          this.hurtPlayer = null;
          this.dataBind(player, player.gunIndex);
          EventMgr.event(EventType.RefreshGunShow);
          Laya.timer.clear(this, this.recoveGun);
      }
      recoveGun() {
          Utils.removeArrayObj(DataMgr.instance.dropGunArr, this);
          DataMgr.instance.recoverProp(this);
          Tween.clear(this.transform);
      }
  }

  class AutoGun extends Gun {
      onAwake() {
          this.propType = PropType.AutoGun;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          super.onUpdate();
          if (this.isFiring) {
              this.fire();
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
      }
  }

  class MathUtils {
      static RandomVelocity(vec, randMax, velWidth, velHeight, baseVel) {
          let fRand_r = Math.sqrt(-2 * Math.log((Math.random() + 1) / (randMax + 1)));
          let fRand_t = 2 * Math.PI * Math.random() / randMax;
          vec.x = fRand_r * Math.cos(fRand_t) * velWidth;
          vec.y = fRand_r * Math.sin(fRand_t) * velHeight - baseVel;
      }
      static GetNumberInNormalDistribution(centerVal, offsetVal) {
          return centerVal + (MathUtils.RandomNormalDistribution() * offsetVal);
      }
      static RandomNormalDistribution() {
          var u = 0.0, v = 0.0, w = 0.0, c = 0.0;
          do {
              u = Math.random() * 2 - 1.0;
              v = Math.random() * 2 - 1.0;
              w = u * u + v * v;
          } while (w == 0.0 || w >= 1.0);
          c = Math.sqrt((-2 * Math.log(w)) / w);
          return u * c;
      }
      static InverseLerp(from, to, value) {
          if (from < to) {
              if (value < from)
                  return 0;
              else if (value > to)
                  return 1;
              else {
                  value -= from;
                  value /= (to - from);
                  return value;
              }
          }
          else if (from > to) {
              if (value < to)
                  return 1;
              else if (value > from)
                  return 0;
              else {
                  return 1 - ((value - to) / (from - to));
              }
          }
          return 0;
      }
      static SmoothStep(from, to, t) {
          t = MathUtils.Clamp01(t);
          t = -2 * t * t * t + 3 * t * t;
          return to * t + from * (1 - t);
      }
      static Clamp(value, min, max) {
          if (value < min)
              return min;
          if (value > max)
              return max;
          return value;
      }
      static Clamp01(value) {
          if (value < 0)
              return 0;
          if (value > 1)
              return 1;
          return value;
      }
  }

  var Vector3$3 = Laya.Vector3;
  var Quaternion = Laya.Quaternion;
  class CameraCtrl extends Laya.Script {
      constructor() {
          super();
          this.huManRot = new Laya.Vector2();
          this.lastMouseX = NaN;
          this.lastMouseY = NaN;
          this.yawPitchRoll = new Vector3$3();
          this.tempRotationZ = new Quaternion();
          this.isMouseDown = false;
          this.rotaionSpeed = 0.00006;
          this._velocity = new Vector3$3();
          this._velocity1 = new Vector3$3();
          this.staticTime = 0.2;
          this.staticTime1 = 0.1;
          this._tempVector3 = new Vector3$3();
          this._tempVec = new Vector3$3();
          this._isJumpUp = false;
          this._targetRot = new Vector3$3();
          this._initRot = new Laya.Vector3();
          this._isAim = false;
          this._tankRot = new Laya.Vector3();
          this._lastRot = new Laya.Vector3();
          this.m_TurnSpeed = 1.5;
          this.m_TurnSmoothing = 3;
          this.m_TiltMax = 0.5;
          this.m_TiltMin = 0.35;
          this.m_LookAngle = 0;
          this.m_TiltAngle = 0;
          this.m_PivotEulers = new Laya.Vector3();
          this.m_PivotTargetRot = new Laya.Quaternion();
          this.m_TransformTargetRot = new Laya.Quaternion();
          this._pivotRot = new Laya.Vector3();
          this._cameraRot = new Laya.Vector3();
          this._pivotPos = new Laya.Vector3();
          this._cameraPos = new Laya.Vector3();
          this._curFloatVel = new Laya.Vector2();
          this._isToFloatCom = true;
          this._curFloatX = 0.005;
          this._curFloatY = 0.005;
          this._speedBase = 0;
          this._curFloatR = 1;
          this._isSec = true;
          this._curFloatOrigin = new Laya.Vector2();
          this._aimPoint = new Laya.Sprite3D();
          this._jumpUpIndex = 0;
          this._fallBackIndex = 0;
          this._jumpUpCnt = 3;
          this._fallBackCnt = 10;
          this._fallBackVal = 0.15;
          this._cameraShakVal = 0;
          this._curCameraShakVal = 0.01;
          this._cameraShakMaxVal = 0.3;
          this._huManJumpUpVal = 0;
          this._huManHVal = 0;
      }
      onAwake() {
          this.gameObject = this.owner;
          this.transform = this.gameObject.transform;
          this.camera = ExUtils.findChild(this.gameObject, 'camera');
          this.m_Pivot = this.camera.parent;
          this.camera.farPlane = 10000;
          this.camera.enableHDR = false;
          this._camSlot = {};
          let sp = Laya.loader.getRes(ESprite3D.CameraPoint);
          this._roleDeadPointTr = Laya.loader.getRes(ESprite3D.RoleDeadPoint).transform;
          this._camSlot.CamSlot_TPS = sp.getChildByName('CamSlot_TPS');
          this._camSlot.CamTank = Laya.loader.getRes(ESprite3D.CamTank);
          this._camSlot.CamHelicopter = Laya.loader.getRes(ESprite3D.CamHelicopter);
          this._roleDeadPointTr.localRotationEulerX = -this._roleDeadPointTr.localRotationEulerX;
          this._roleDeadPointTr.localRotationEulerY = 180 + this._roleDeadPointTr.localRotationEulerY;
          CameraCtrl.NOR_FOV = CfgDataMgr.instance.getGlobalCfg('normalFOV');
          this._curFloatR = CfgDataMgr.instance.getGlobalCfg('cursorShockRangeBase');
          this._speedBase = CfgDataMgr.instance.getGlobalCfg('cursorShockSpeedBase');
          this._curFloatY = this._curFloatX = this._speedBase;
          this.animator = this.gameObject.getComponent(Laya.Animator);
      }
      onUpdate() {
          if (CameraCtrl.DEBUG) {
              this.updateCamera(Laya.timer.delta);
          }
      }
      onLateUpdate() {
          if (CameraCtrl.DEBUG)
              return;
          if (this._moveToTf == null)
              return;
          if (DataMgr.instance.role.isDead || DataMgr.instance.isPhase(EGamePhase.OverGame)) {
              if (DataMgr.instance.showVehDeadAni) {
                  let pos = this.transform.position;
                  let rot = this.transform.rotationEuler;
                  Utils.SmoothDamp(pos, this._cameraPos, this._velocity1, this.staticTime1, -1, DataMgr.FixedDeltaTime, this._tempVec);
                  Utils.SmoothDamp(rot, this._cameraRot, this._velocity, this.staticTime1, -1, DataMgr.FixedDeltaTime, this._tempVector3);
                  this._tempVec.cloneTo(pos);
                  this._tempVector3.cloneTo(rot);
                  this.transform.position = pos;
                  this.transform.rotationEuler = rot;
                  if (Laya.Vector3.distance(pos, this._cameraPos) <= 0.001 &&
                      Laya.Vector3.distance(rot, this._cameraRot) <= 0.001) {
                      DataMgr.instance.showVehDeadAni = false;
                      DataMgr.instance.role.CameraRegular.addChild(this.gameObject);
                      Utils.vec3ToTargetVal('localRotationEuler', 1, this.gameObject);
                      Utils.vec3ToTargetVal('localPosition', 1, this.gameObject);
                      this.gameObject.transform.localRotationEulerY = 180;
                  }
              }
              return;
          }
          if (!DataMgr.instance.isGamming())
              return;
          if (DataMgr.instance.isUpDownVehBeg && DataMgr.instance.role.roleCtrl._initViewLock) {
              let pos = this.transform.position;
              let rot = this.transform.rotationEuler;
              Utils.SmoothDamp(pos, this._cameraPos, this._velocity1, this.staticTime1, -1, DataMgr.FixedDeltaTime, this._tempVec);
              Utils.SmoothDamp(rot, this._cameraRot, this._velocity, this.staticTime1, -1, DataMgr.FixedDeltaTime, this._tempVector3);
              this._tempVec.cloneTo(pos);
              this._tempVector3.cloneTo(rot);
              this.transform.position = pos;
              this.transform.rotationEuler = rot;
              if (Laya.Vector3.distance(pos, this._cameraPos) <= 0.001 &&
                  Laya.Vector3.distance(rot, this._cameraRot) <= 0.001) {
                  this.showVehCameraCom();
              }
          }
          else {
              if (this._isAim) {
                  if (this._followModel != curType.HuMan) {
                      return;
                  }
                  let pos = this.transform.localPosition;
                  Utils.SmoothDamp(pos, Vector3Ex.ZERO, this._velocity1, this.staticTime, -1, DataMgr.FixedDeltaTime, this._tempVec);
                  this._tempVec.cloneTo(pos);
                  this.transform.localPosition = pos;
                  this.camera.fieldOfView = MathUtils.SmoothStep(this.camera.fieldOfView, this._nextFieleView, 0.2);
                  if (Math.abs(this.camera.fieldOfView - this._nextFieleView) < 0.5 &&
                      Laya.Vector3.distance(pos, Vector3Ex.ZERO) <= 0.001) {
                      this._isAim = false;
                  }
              }
              else {
                  if (this._followModel == curType.HuMan) {
                      if (!(0 == this.huManRot.x && 0 == this.huManRot.y) || this._isJumpUp) {
                          if (this._isJumpUp && this._huManJumpUpVal == 0) {
                              let val = 0;
                              if (this._fallBackIndex < DataMgr.instance.role.gun.gunCfg.recoilRecoverTime) {
                                  this._fallBackIndex++;
                                  if (this._moveToTf.localRotationEulerX <=
                                      DataMgr.instance.role.roleCtrl.getMinEulerX()) {
                                      this._fallBackIndex = 4000;
                                  }
                                  else {
                                      val = DataMgr.instance.role.isAimState ? 0.4 : 1;
                                      val *= this._fallBackVal;
                                  }
                              }
                              else {
                                  this._isJumpUp = false;
                              }
                              this.setRoleRotate(this.huManRot.x - val, this.huManRot.y);
                          }
                          else if (0 != this.huManRot.x || 0 != this.huManRot.y || this._huManJumpUpVal != 0) {
                              if (this._jumpUpIndex < DataMgr.instance.role.gun.gunCfg.recoilTime) {
                                  this.huManRot.x += this._huManJumpUpVal;
                                  let minEulerX = DataMgr.instance.role.roleCtrl.getMinEulerX();
                                  if (this.huManRot.x == minEulerX) {
                                  }
                                  else if (minEulerX - this.huManRot.x > -0.0001) {
                                      this.huManRot.x = minEulerX;
                                  }
                                  if (this._huManJumpUpVal != 0) {
                                      let gun = DataMgr.instance.role.gun;
                                      this._huManHVal =
                                          gun.gunCfg.horizontalBaseExcursionAdd +
                                              gun.gunCfg.horizontalRandomExcursionAdd * Math.random();
                                      this._huManHVal = Math.random() <= 0.5 ? this._huManHVal * -1 : this._huManHVal;
                                  }
                                  this.huManRot.y += this._huManHVal;
                                  this.setRoleRotate(this.huManRot.x, this.huManRot.y);
                                  this._jumpUpIndex++;
                                  if (this._huManJumpUpVal == 0) {
                                      if (Math.abs(this.transform.localRotationEulerZ) <= this._curCameraShakVal) {
                                          this.transform.localRotationEulerZ = 0;
                                      }
                                      else {
                                          this.transform.localRotationEulerZ +=
                                              this.transform.localRotationEulerZ > 0
                                                  ? -this._curCameraShakVal
                                                  : this._curCameraShakVal;
                                      }
                                  }
                                  else {
                                      if (Math.abs(Math.abs(this.transform.localRotationEulerZ) - Math.abs(this._cameraShakVal)) <= this._curCameraShakVal) {
                                          this.transform.localRotationEulerZ = this._curCameraShakVal;
                                          this._cameraShakVal = Math.random() * this._cameraShakMaxVal;
                                      }
                                      else {
                                          this.transform.localRotationEulerZ +=
                                              this.transform.localRotationEulerZ > this._cameraShakVal
                                                  ? -this._curCameraShakVal
                                                  : this._curCameraShakVal;
                                      }
                                  }
                              }
                              else {
                                  this._huManJumpUpVal = this._jumpUpIndex = this._huManHVal = 0;
                              }
                          }
                      }
                      if (!Utils.isIPhone()) {
                          if (!this._isJumpUp && DataMgr.instance.isStand) {
                              if (this._isToFloatCom) {
                                  let r = (-Math.random() * Math.PI) / 2;
                                  let role = DataMgr.instance.role;
                                  let floatR = role._isAim && role.gun.isHasScope()
                                      ? role.gun.scopeInfo.upSteady
                                      : role.gun.mechanicalSight.upSteady;
                                  floatR *= this._curFloatR;
                                  if (this._isSec) {
                                      this._curFloatVel.setValue(Math.cos(r) * floatR + this._curFloatOrigin.x, -Math.sin(r) * floatR + this._curFloatOrigin.y);
                                  }
                                  else {
                                      this._curFloatVel.setValue(-Math.sin(r) * floatR + this._curFloatOrigin.x, Math.cos(r) * floatR + this._curFloatOrigin.y);
                                  }
                                  this._isToFloatCom = !this._isToFloatCom;
                                  this._isSec = !this._isSec;
                              }
                              else {
                                  if (Math.abs(this.transform.localRotationEulerX - this._curFloatVel.x) <
                                      this._curFloatX) {
                                      this.transform.localRotationEulerX = this._curFloatVel.x;
                                  }
                                  else {
                                      this.transform.localRotationEulerX +=
                                          this.transform.localRotationEulerX > this._curFloatVel.x
                                              ? -this._curFloatX
                                              : this._curFloatX;
                                  }
                                  if (Math.abs(this.transform.localRotationEulerY - this._curFloatVel.y) <
                                      this._curFloatY) {
                                      this.transform.localRotationEulerY = this._curFloatVel.y;
                                  }
                                  else {
                                      this.transform.localRotationEulerY +=
                                          this.transform.localRotationEulerY > this._curFloatVel.y
                                              ? -this._curFloatY
                                              : this._curFloatY;
                                  }
                                  let euler = this.transform.localRotationEuler;
                                  euler.setValue(this.transform.localRotationEulerX, this.transform.localRotationEulerY, this.transform.localRotationEulerZ);
                                  this.transform.localRotationEuler = euler;
                                  if (this.transform.localRotationEulerY == this._curFloatVel.y &&
                                      this.transform.localRotationEulerX == this._curFloatVel.x) {
                                      this._isToFloatCom = !this._isToFloatCom;
                                  }
                              }
                          }
                      }
                  }
                  else {
                      let pos = this.transform.position;
                      Utils.SmoothDamp(pos, this._moveToTf.position, this._velocity1, this.staticTime, -1, DataMgr.FixedDeltaTime, this._tempVec);
                      this._tempVec.cloneTo(pos);
                      this.transform.position = pos;
                      this.HandleRotationMovement();
                      DataMgr.instance.role.roleCtrl.setTurretRotate();
                  }
              }
          }
      }
      bindPlayer(sp, type) {
          this.clear();
          let self = this;
          this._curCamType = type;
          this._followModel = DataMgr.instance.role.curType;
          let pos = new Laya.Vector3();
          let rotate = new Laya.Vector3();
          if (this._followModel != curType.HuMan) {
              DataMgr.instance.addChildToRoot(this.gameObject);
              Utils.vec3ToTargetVal('position', 1, this.gameObject, sp.transform.position);
              this.setCamPos();
              this.transform.localRotationEulerY = DataMgr.instance.role.parentTr.localRotationEulerY;
              this.transform.localRotation.getYawPitchRoll(this._tempVec);
              this.m_LookAngle = this._tempVec.x;
              this.camera.transform.localRotationEulerY += 180;
              this.m_PivotEulers = this.m_Pivot.transform.localRotationEuler;
              let refreshFun = function () {
                  self.HandleRotationMovement(true);
                  Laya.timer.callLater(self, function () {
                      EventMgr.event(EventType.RefreshRoleRegEvent);
                  });
              };
              if (this._followModel == curType.Tank) {
                  refreshFun();
              }
              else {
                  refreshFun();
              }
          }
          else {
              switch (type) {
                  case CamType.TPS:
                      sp.addChild(this.owner);
                      this._camSlot.CamSlot_TPS.transform.localPosition.cloneTo(pos);
                      this._camSlot.CamSlot_TPS.transform.localRotationEuler.cloneTo(rotate);
                      break;
                  case CamType.FPS:
                      this._camSlot.CamSlot_FPS = ExUtils.findChild(sp, 'CamRotator');
                      this._camSlot.CamSlot_FPS.addChild(this.owner);
                      this._camSlot.CamSlot_FPS.transform.localPosition.cloneTo(pos);
                      this._camSlot.CamSlot_FPS.transform.localRotationEuler.cloneTo(rotate);
                      this._aimPoint = ExUtils.findChild(sp, 'CamSlot_FPS_AimScop');
                      break;
              }
              let cameraPos = this.transform.localPosition;
              let cameraRotate = this.transform.localRotationEuler;
              if (this._curCamType == CamType.FPS) {
                  Vector3Ex.ZERO.cloneTo(cameraPos);
                  Vector3Ex.ZERO.cloneTo(cameraRotate);
              }
              else {
                  pos.cloneTo(cameraPos);
                  rotate.cloneTo(cameraRotate);
              }
              this.transform.localPosition = cameraPos;
              this.transform.localRotationEuler = cameraRotate;
              this.transform.localRotationEulerY += 180;
              this.transform.localRotationEuler.cloneTo(this._initRot);
              let target = new Laya.Sprite3D('cameraLook');
              sp.addChild(target);
              this._lookTr = target.transform;
              Utils.vec3ToTargetVal('localPosition', 2, this.camera);
              Utils.vec3ToTargetVal('localRotationEuler', 2, this.camera);
              Laya.timer.callLater(this, function () {
                  EventMgr.event(EventType.RefreshRoleRegEvent);
              });
          }
          this._moveToTf = sp.transform;
          if (CameraCtrl.DEBUG) {
              this.debug();
          }
          if (this._curCamType == CamType.FPS) {
              this._curFloatOrigin.setValue(this.transform.localRotationEulerX, this.transform.localRotationEulerY);
          }
      }
      clear() {
          this.m_LookAngle = 0;
          this.m_TiltAngle = 0;
          Vector3Ex.ZERO.cloneTo(this._velocity);
          Vector3Ex.ZERO.cloneTo(this._velocity1);
          this.camera.fieldOfView = CameraCtrl.NOR_FOV;
          this._isToFloatCom = true;
          this._isAim = false;
      }
      HandleRotationMovement(isIgnore = false) {
          if (!isIgnore) {
              if (this._tankRot.y == 0 && this._tankRot.x == 0)
                  return;
          }
          let self = this;
          let setAngleFun = function () {
              var x = -self._tankRot.y;
              var y = self._tankRot.x;
              self.m_LookAngle += x * self.m_TurnSpeed;
              Laya.Quaternion.createFromYawPitchRoll(self.m_LookAngle, 0, 0, self.m_TransformTargetRot);
              self.m_TiltAngle += y * self.m_TurnSpeed;
              self.m_TiltAngle = MathUtils.Clamp(self.m_TiltAngle, self.m_TiltMin, self.m_TiltMax);
              Laya.Quaternion.createFromYawPitchRoll(self.m_PivotEulers.y, self.m_TiltAngle, self.m_PivotEulers.z, self.m_PivotTargetRot);
              Utils.vec3ToTargetVal('localRotation', 1, self.m_Pivot, self.m_PivotTargetRot);
              Utils.vec3ToTargetVal('localRotation', 1, self.gameObject, self.m_TransformTargetRot);
          };
          setAngleFun();
          Vector3Ex.ZERO.cloneTo(self._tankRot);
      }
      camFollowTank(speed) {
          this.transform.localRotationEulerY += speed;
          this.transform.localRotation.getYawPitchRoll(this._tempVec);
          this.m_LookAngle = this._tempVec.x;
      }
      setLookAt(targetPos) {
          targetPos.cloneTo(this._tempVec);
          this._lookTr.lookAt(this._tempVec, Vector3Ex.Up, false);
          this._lookTr.localRotationEuler.cloneTo(this._targetRot);
          let x = -this._targetRot.x;
          let val;
          if (x + this._moveToTf.localRotationEulerX < DataMgr.instance.role.roleCtrl.getMinEulerX()) {
              val = DataMgr.instance.role.roleCtrl.getMinEulerX() - this._moveToTf.localRotationEulerX;
          }
          else {
              val = x;
          }
          this._huManJumpUpVal = val / DataMgr.instance.role.gun.gunCfg.recoilTime;
          this._fallBackVal = val / DataMgr.instance.role.gun.gunCfg.recoilRecoverTime;
          this._jumpUpIndex = this._fallBackIndex = 0;
          this._isJumpUp = true;
      }
      get LookTr() {
          return this._lookTr;
      }
      setTurretRotate(rot) {
          this._tankRot.cloneTo(this._lastRot);
          rot.cloneTo(this._tankRot);
      }
      setTankVerticalLimit(min, max) {
          this.m_TiltMin = (min / 180) * Math.PI;
          this.m_TiltMax = (max / 180) * Math.PI;
      }
      setAim(isOpen) {
          let role = DataMgr.instance.role;
          if (this._followModel != curType.HuMan) {
              this._isAim = isOpen;
              this._nextFieleView = isOpen ? CameraCtrl.AIM_FOV : CameraCtrl.NOR_FOV;
              if (isOpen) {
                  let slotPos = role.gun.camSlot;
                  slotPos.addChild(this.gameObject);
                  Utils.vec3ToTargetVal('localPosition', 3, this.camera);
                  Utils.vec3ToTargetVal('localRotationEuler', 3, this.camera);
                  this.camera.transform.localRotationEulerY = 180;
              }
              else {
                  let curY = this.transform.rotationEuler.y;
                  DataMgr.instance.addChildToRoot(this.gameObject);
                  Utils.vec3ToTargetVal('position', 1, this.gameObject, this._moveToTf.position);
                  this.setCamPos();
                  this.camera.transform.localRotationEulerY += 180;
                  this.transform.localRotationEulerY = curY;
                  this.transform.localRotation.getYawPitchRoll(this._tempVec);
                  this.m_LookAngle = this._tempVec.x;
                  this.m_PivotEulers = this.m_Pivot.transform.localRotationEuler;
                  this.m_TiltAngle = 0;
              }
          }
          else {
              this._isAim = true;
              this._nextFieleView = isOpen ? CameraCtrl.AIM_FOV : CameraCtrl.NOR_FOV;
              if (isOpen) {
                  this.gameObject.addChild(DataMgr.instance.role.gun.gameObject);
                  let pos = DataMgr.instance.role.gun.transform.localPosition;
                  let cfg = DataMgr.instance.role.gun.gunCfg.gunMountPointPos;
                  pos.setValue(cfg[0], cfg[1], cfg[2]);
                  pos.z = -pos.z;
                  DataMgr.instance.role.gun.transform.localPosition = pos;
                  DataMgr.instance.role.gun.transform.localRotationEulerY = 180;
                  let cfg1 = DataMgr.instance.role._skinCfg;
                  this._curFloatY = this._curFloatX = this._speedBase * cfg1.aimCursorShakeMultiplier;
                  DataMgr.instance.role.arm_01.active = false;
              }
              else {
                  this._camSlot.CamSlot_FPS.addChild(this.gameObject);
                  role.addGunNode(role.gun.gameObject, role.gun.gunCfg);
                  Utils.vec3ToTargetVal('localPosition', 1, role.gun.gameObject);
                  Utils.vec3ToTargetVal('localRotationEuler', 1, role.gun.gameObject);
                  this._curFloatY = this._curFloatX = this._speedBase;
                  DataMgr.instance.role.arm_01.active = true;
              }
          }
      }
      setSniping(isOpen) {
          this._isAim = true;
          let role = DataMgr.instance.role;
          this._nextFieleView = isOpen
              ? CameraCtrl.NOR_FOV * role.gun.scopeInfo.upAimscale
              : CameraCtrl.NOR_FOV;
          if (isOpen) {
              let slotPos = this._aimPoint;
              slotPos.addChild(this.gameObject);
              let pos = role.gun.gameObject.transform.position;
              let rot = role.gun.gameObject.transform.rotationEuler;
              pos.cloneTo(this._tempVec);
              rot.cloneTo(this._tempVector3);
              this.gameObject.addChild(role.gun.gameObject);
              this._tempVec.cloneTo(pos);
              this._tempVector3.cloneTo(rot);
              role.gun.gameObject.transform.position = pos;
              role.gun.gameObject.transform.rotationEuler = rot;
              let cfg1 = DataMgr.instance.role._skinCfg;
              this._curFloatY = this._curFloatX = this._speedBase * cfg1.aimCursorShakeMultiplier;
          }
          else {
              this._camSlot.CamSlot_FPS.addChild(this.gameObject);
              role.addGunNode(role.gun.gameObject, role.gun.gunCfg);
              Utils.vec3ToTargetVal('localPosition', 1, role.gun.gameObject);
              Utils.vec3ToTargetVal('localRotationEuler', 1, role.gun.gameObject);
              this._curFloatY = this._curFloatX = this._speedBase;
          }
      }
      reviveInit() {
          if (DataMgr.instance.role.curType == curType.HuMan) {
              this.clear();
              if (this.gameObject.parent.name != this._camSlot.CamSlot_FPS.name) {
                  this._camSlot.CamSlot_FPS.addChild(this.gameObject);
                  Utils.vec3ToTargetVal('localPosition', 1, this.gameObject);
              }
          }
      }
      setCamPos() {
          if (!this._camSlot.CamTank)
              this._camSlot.CamTank = Laya.loader.getRes(ESprite3D.CamTank);
          if (!this._camSlot.CamHelicopter)
              this._camSlot.CamHelicopter = Laya.loader.getRes(ESprite3D.CamHelicopter);
          let targetObj = this._followModel == curType.Tank ? this._camSlot.CamTank : this._camSlot.CamHelicopter;
          targetObj = targetObj.getChildByName('Pivot');
          targetObj.transform.localPosition.cloneTo(this._pivotPos);
          targetObj.transform.localRotationEuler.cloneTo(this._pivotRot);
          targetObj = targetObj.getChildByName('CameraRegular');
          targetObj.transform.localPosition.cloneTo(this._cameraPos);
          targetObj.transform.localRotationEuler.cloneTo(this._cameraRot);
          this._cameraRot.x = -this._cameraRot.x;
          Utils.vec3ToTargetVal('localPosition', 1, this.m_Pivot, this._pivotPos);
          Utils.vec3ToTargetVal('localRotationEuler', 1, this.m_Pivot, this._pivotRot);
          Utils.vec3ToTargetVal('localPosition', 1, this.camera, this._cameraPos);
          Utils.vec3ToTargetVal('localRotationEuler', 1, this.camera, this._cameraRot);
      }
      OperationModeSwitch() {
          let pos = this.transform.localPosition;
          let rot = this.transform.localRotationEuler;
          if (this._curCamType == CamType.FPS) {
              this._curCamType = CamType.TPS;
          }
          else {
              this._curCamType = CamType.FPS;
          }
          if (this._curCamType == CamType.FPS) {
              this._camSlot.CamSlot_FPS.addChild(this.owner);
              Vector3Ex.ZERO.cloneTo(pos);
              Vector3Ex.ZERO.cloneTo(rot);
          }
          else {
              this._moveToTf.owner.addChild(this.owner);
              this._camSlot.CamSlot_TPS.transform.localPosition.cloneTo(pos);
              this._camSlot.CamSlot_TPS.transform.localRotationEuler.cloneTo(rot);
          }
          this.transform.localPosition = pos;
          this.transform.localRotationEuler = rot;
          this.transform.localRotationEulerY += 180;
      }
      showVehCameraBegin() {
          if (!this._camSlot.CamTank)
              this._camSlot.CamTank = Laya.loader.getRes(ESprite3D.CamTank);
          if (!this._camSlot.CamHelicopter)
              this._camSlot.CamHelicopter = Laya.loader.getRes(ESprite3D.CamHelicopter);
          this._followModel = DataMgr.instance.role.curType;
          let pos = this.transform.position;
          let rot = this.transform.rotationEuler;
          pos.cloneTo(this._tempVec);
          rot.cloneTo(this._tempVector3);
          DataMgr.instance.addChildToRoot(this.gameObject);
          Utils.vec3ToTargetVal('localPosition', 1, this.gameObject, this._tempVec);
          Utils.vec3ToTargetVal('localRotationEuler', 1, this.gameObject, this._tempVector3);
          if (DataMgr.instance.role.curType == curType.Air) {
              this.camera.nearPlane = 1;
          }
          else {
              this.camera.nearPlane = 0.01;
          }
      }
      showVehCamera() {
          if (!DataMgr.instance.isPhase(EGamePhase.OverGame)) {
              Laya.MouseManager.enabled = false;
          }
          let pos = DataMgr.instance.role.parentTr.position;
          let rot = DataMgr.instance.role.parentTr.rotationEuler;
          pos.cloneTo(this._tempVec);
          rot.cloneTo(this._tempVector3);
          if (this._followModel == curType.HuMan) {
              let camSlot_FPS = DataMgr.instance.role.heroModel.getChildByName('CamSlot_FPS');
              pos = camSlot_FPS.transform.position;
              rot = camSlot_FPS.transform.rotationEuler;
              pos.cloneTo(this._tempVec);
              rot.cloneTo(this._tempVector3);
              this._tempVec.cloneTo(this._cameraPos);
              this._tempVector3.cloneTo(this._cameraRot);
              pos = this.camera.transform.position;
              rot = this.camera.transform.rotationEuler;
              pos.cloneTo(this._tempVec);
              rot.cloneTo(this._tempVector3);
              Utils.vec3ToTargetVal('localRotationEuler', 2, this.camera);
              Utils.vec3ToTargetVal('localPosition', 2, this.camera);
              pos = this.gameObject.transform.position;
              rot = this.gameObject.transform.rotationEuler;
              this._tempVec.cloneTo(pos);
              this._tempVector3.cloneTo(rot);
              this.gameObject.transform.position = pos;
              this.gameObject.transform.rotationEuler = rot;
              this._cameraRot.y += 180;
          }
          else {
              let cameraPoint = this._followModel == curType.Tank ? this._camSlot.CamTank : this._camSlot.CamHelicopter;
              DataMgr.instance.curVeh.gameObject.addChild(cameraPoint);
              cameraPoint = cameraPoint.getChildByName('Pivot');
              cameraPoint = cameraPoint.getChildByName('CameraRegular');
              cameraPoint.transform.rotationEuler.cloneTo(this._cameraRot);
              cameraPoint.transform.position.cloneTo(this._cameraPos);
              this._cameraRot.y += 180;
              if (this._followModel == curType.Air) {
                  let tr = DataMgr.instance.role.transform;
                  tr.localPositionY = DataMgr.instance.role.roleCtrl.limitH;
              }
          }
      }
      showVehCameraCom() {
          Laya.MouseManager.enabled = true;
          let cameraPoint = this._followModel == curType.Tank ? this._camSlot.CamTank : this._camSlot.CamHelicopter;
          cameraPoint.removeSelf();
          let role = DataMgr.instance.role;
          this.bindPlayer(role.gameObject, role.isUseVeh ? CamType.TPS : CamType.FPS);
          role.roleCtrl._initViewLock = false;
          DataMgr.instance.isUpDownVehBeg = false;
          role.setPlayerGun(0);
          if (role.isUseVeh) {
              EventMgr.event(EventType.RefreshVehIconShow);
          }
      }
      vehAniRest() {
          if (DataMgr.instance.role.curType == curType.HuMan)
              return;
          this.camera.transform.position.cloneTo(this._tempVec);
          this.camera.transform.rotationEuler.cloneTo(this._tempVector3);
          Utils.vec3ToTargetVal('localPosition', 2, this.camera);
          Utils.vec3ToTargetVal('localRotationEuler', 2, this.camera);
          let pos = this.gameObject.transform.position;
          let rot = this.gameObject.transform.rotationEuler;
          this._tempVec.cloneTo(pos);
          this._tempVector3.cloneTo(rot);
          this.gameObject.transform.position = pos;
          this.gameObject.transform.rotationEuler = rot;
          let targetObj = DataMgr.instance.role.CameraRegular;
          targetObj.transform.position.cloneTo(this._cameraPos);
          targetObj.transform.rotationEuler.cloneTo(this._cameraRot);
          this._cameraRot.y += 180;
      }
      setRoleRotate(rotateX, rotateY) {
          this._moveToTf.localRotationEulerX = rotateX;
          this._moveToTf.owner.parent.transform.localRotationEulerY = rotateY;
      }
      debug() {
          if (CameraCtrl.DEBUG) {
              Laya.stage.on('mousedown', this, this.mouseDown);
              Laya.stage.on('mouseup', this, this.mouseUp);
              Laya.stage.on('mouseout', this, this.mouseOut);
          }
          else {
              Laya.stage.off('mousedown', this, this.mouseDown);
              Laya.stage.off('mouseup', this, this.mouseUp);
              Laya.stage.off('mouseout', this, this.mouseOut);
          }
      }
      mouseDown(e) {
          this.camera.transform.localRotation.getYawPitchRoll(this.yawPitchRoll);
          this.lastMouseX = Laya.stage.mouseX;
          this.lastMouseY = Laya.stage.mouseY;
          this.isMouseDown = true;
      }
      mouseUp(e) {
          this.isMouseDown = false;
      }
      mouseOut(e) {
          this.isMouseDown = false;
      }
      updateRotation() {
          var ypr = this.yawPitchRoll;
          if (Math.abs(ypr.y) < 1.5) {
              Quaternion.createFromYawPitchRoll(ypr.x, ypr.y, ypr.z, this.tempRotationZ);
              this.camera.transform.localRotation = this.tempRotationZ;
          }
      }
      updateCamera(elapsedTime) {
          if (!isNaN(this.lastMouseX) && !isNaN(this.lastMouseY)) {
              var scene = this.owner.scene;
              Laya.KeyBoardManager.hasKeyDown(87) && this.moveForward(-0.01 * elapsedTime);
              Laya.KeyBoardManager.hasKeyDown(83) && this.moveForward(0.01 * elapsedTime);
              Laya.KeyBoardManager.hasKeyDown(65) && this.moveRight(-0.01 * elapsedTime);
              Laya.KeyBoardManager.hasKeyDown(68) && this.moveRight(0.01 * elapsedTime);
              Laya.KeyBoardManager.hasKeyDown(81) && this.moveVertical(0.01 * elapsedTime);
              Laya.KeyBoardManager.hasKeyDown(69) && this.moveVertical(-0.01 * elapsedTime);
              if (this.isMouseDown) {
                  var offsetX = Laya.stage.mouseX - this.lastMouseX;
                  var offsetY = Laya.stage.mouseY - this.lastMouseY;
                  var yprElem = this.yawPitchRoll;
                  yprElem.x -= offsetX * this.rotaionSpeed * elapsedTime;
                  yprElem.y -= offsetY * this.rotaionSpeed * elapsedTime;
                  this.updateRotation();
              }
          }
          this.lastMouseX = Laya.stage.mouseX;
          this.lastMouseY = Laya.stage.mouseY;
      }
      moveForward(distance) {
          this._tempVector3.x = 0;
          this._tempVector3.y = 0;
          this._tempVector3.z = distance;
          this.camera.transform.translate(this._tempVector3);
      }
      moveRight(distance) {
          this._tempVector3.y = 0;
          this._tempVector3.z = 0;
          this._tempVector3.x = distance;
          this.camera.transform.translate(this._tempVector3);
      }
      moveVertical(distance) {
          this._tempVector3.x = this._tempVector3.z = 0;
          this._tempVector3.y = distance;
          this.camera.transform.translate(this._tempVector3, false);
      }
  }
  CameraCtrl.AIM_FOV = 60;
  CameraCtrl.NOR_FOV = 90;
  CameraCtrl.DEBUG = false;

  class GrenadeGun extends Gun {
      onAwake() {
          this.propType = PropType.GrenadeGun;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          super.onUpdate();
          if (this.isFiring) {
              this.fire();
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
          let grenade = PropMgr.instance.getProp(PropType.Grenade, 'Grenade');
          this.launchTf.getForward(this._vec);
          Laya.Vector3.scale(this._vec, -1, this._vec);
          if (this.player.isRolePlayer()) {
              grenade.startFly(this.launchTf.position, this._vec, this.player, this.player.gun.gunCfg);
          }
          else {
              grenade.setAITarget(this.player, this.launchTf.position, this._vec, this.player.gun.gunCfg, this.player.curTarget.transform.position);
          }
      }
  }

  class MissileLauncher extends Gun {
      onAwake() {
          this.propType = PropType.MissileLauncher;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          super.onUpdate();
          if (this.isFiring) {
              this.fire();
          }
      }
      onFired() {
          this.calAttackPos();
          if (this.hurtPlayer) {
              super.onFired();
              switch (this.gunCfg.bulletID) {
                  case 100002:
                  case 100003:
                  case 100005:
                      let rocket = PropMgr.instance.getProp(PropType.Rocket, 'Rocket');
                      this._rotatorGun.getForward(this._vec);
                      rocket.setTarget(this.player, this._rotatorGun.position, this._vec, this.gunCfg);
                      break;
                  case 100004:
                      let missile = PropMgr.instance.getProp(PropType.Missile, 'Missile');
                      this.launchTf.getForward(this._vec);
                      Laya.Vector3.scale(this._vec, -1, this._vec);
                      missile.setTarget(this.player, this.hurtPlayer, this.launchTf.position, this._vec, this.gunCfg);
                      break;
              }
          }
      }
  }

  class Geometry {
      constructor() {
          this.isGeometry = true;
      }
      mergeVertices() {
          let verticesMap = {};
          let unique = new Array(), changes = [];
          let v, key;
          let precisionPoints = 4;
          let precision = Math.pow(10, precisionPoints);
          let i, il, face;
          let indices;
          for (i = 0, il = this.vertices.length; i < il; i++) {
              v = this.vertices[i];
              key =
                  Math.round(v.x * precision) +
                      '_' +
                      Math.round(v.y * precision) +
                      '_' +
                      Math.round(v.z * precision);
              if (verticesMap[key] == null) {
                  verticesMap[key] = i;
                  unique.push(v);
                  changes[i] = unique.length - 1;
              }
              else {
                  changes[i] = changes[verticesMap[key]];
              }
          }
          let faceIndicesToRemove = [];
          for (i = 0, il = this.faces.length; i < il; i++) {
              face = this.faces[i];
              face.a = changes[face.a];
              face.b = changes[face.b];
              face.c = changes[face.c];
              indices = [face.a, face.b, face.c];
              for (let n = 0; n < 3; n++) {
                  if (indices[n] == indices[(n + 1) % 3]) {
                      faceIndicesToRemove.push(i);
                      break;
                  }
              }
          }
          for (i = faceIndicesToRemove.length - 1; i >= 0; i--) {
              let idx = faceIndicesToRemove[i];
              this.faces.splice(idx, 1);
          }
          let diff = this.vertices.length - unique.length;
          this.vertices = unique;
          return diff;
      }
  }

  var VertexMesh = Laya.VertexMesh;
  class NavMesh {
      static createMesh(g) {
          let _numberIndices = g.faces.length * 3;
          var vertexDeclaration = VertexMesh.getVertexDeclaration('POSITION,NORMAL,COLOR');
          var p2 = [];
          var i2 = [];
          var k = 0;
          for (var j = 0; j < _numberIndices / 3; j++) {
              i2.push(k++);
              i2.push(k++);
              i2.push(k++);
              var a = g.faces[j].a;
              var b = g.faces[j].c;
              var c = g.faces[j].b;
              p2.push(g.vertices[a].x);
              p2.push(g.vertices[a].y);
              p2.push(g.vertices[a].z);
              p2.push(0);
              p2.push(0);
              p2.push(0);
              var cc = this.getColor(g.vertices[a]);
              p2.push(cc.x);
              p2.push(cc.y);
              p2.push(cc.z);
              p2.push(cc.w);
              p2.push(g.vertices[b].x);
              p2.push(g.vertices[b].y);
              p2.push(g.vertices[b].z);
              p2.push(0);
              p2.push(0);
              p2.push(0);
              cc = this.getColor(g.vertices[b]);
              p2.push(cc.x);
              p2.push(cc.y);
              p2.push(cc.z);
              p2.push(cc.w);
              p2.push(g.vertices[c].x);
              p2.push(g.vertices[c].y);
              p2.push(g.vertices[c].z);
              p2.push(0);
              p2.push(0);
              p2.push(0);
              cc = this.getColor(g.vertices[c]);
              p2.push(cc.x);
              p2.push(cc.y);
              p2.push(cc.z);
              p2.push(cc.w);
          }
          NavMesh.computeNormal(p2, i2);
          var indices = new Uint16Array(i2);
          var vertices = new Float32Array(p2);
          return Laya.PrimitiveMesh['_createMesh'](vertexDeclaration, vertices, indices);
      }
      static getColor(v) {
          var c3 = this.fromHSV((Laya.Vector3.scalarLength(v) / 20 + 100) % 1, 1, 1);
          return new Laya.Vector4(c3.x, c3.y, c3.z, 1);
      }
      static computeNormal(vin, idata) {
          for (var i = 0; i < idata.length; i += 3) {
              var i0 = idata[i] * 10;
              var i1 = idata[i + 1] * 10;
              var i2 = idata[i + 2] * 10;
              var x0 = vin[i0];
              var y0 = vin[i0 + 1];
              var z0 = vin[i0 + 2];
              var x1 = vin[i1];
              var y1 = vin[i1 + 1];
              var z1 = vin[i1 + 2];
              var x2 = vin[i2];
              var y2 = vin[i2 + 1];
              var z2 = vin[i2 + 2];
              var nx = (y0 - y2) * (z0 - z1) - (z0 - z2) * (y0 - y1);
              var ny = (z0 - z2) * (x0 - x1) - (x0 - x2) * (z0 - z1);
              var nz = (x0 - x2) * (y0 - y1) - (y0 - y2) * (x0 - x1);
              vin[i0 + 3] += nx;
              vin[i1 + 3] += nx;
              vin[i2 + 3] += nx;
              vin[i0 + 4] += ny;
              vin[i1 + 4] += ny;
              vin[i2 + 4] += ny;
              vin[i0 + 5] += nz;
              vin[i1 + 5] += nz;
              vin[i2 + 5] += nz;
          }
          for (i = 3; i < vin.length; i += 10) {
              nx = vin[i];
              ny = vin[i + 1];
              nz = vin[i + 2];
              var distance = Math.sqrt(nx * nx + ny * ny + nz * nz);
              vin[i] /= distance;
              vin[i + 1] /= distance;
              vin[i + 2] /= distance;
          }
      }
      static fromHSV(h, s, v) {
          var R, G, B;
          if (s == 0) {
              R = G = B = v;
          }
          else {
              var h6 = h * 6;
              var i = h6 >> 0;
              var f = h6 - i;
              var a = v * (1 - s);
              var b = v * (1 - s * f);
              var c = v * (1 - s * (1 - f));
              switch (i) {
                  case 0:
                      R = v;
                      G = c;
                      B = a;
                      break;
                  case 1:
                      R = b;
                      G = v;
                      B = a;
                      break;
                  case 2:
                      R = a;
                      G = v;
                      B = c;
                      break;
                  case 3:
                      R = a;
                      G = b;
                      B = v;
                      break;
                  case 4:
                      R = c;
                      G = a;
                      B = v;
                      break;
                  case 5:
                      R = v;
                      G = a;
                      B = b;
                      break;
              }
          }
          return new Laya.Vector3(R, G, B);
      }
  }

  class WorkerMgr {
      constructor() { }
      static get instance() {
          if (WorkerMgr._instance == null) {
              WorkerMgr._instance = new WorkerMgr();
          }
          return WorkerMgr._instance;
      }
      init() {
          if (SceneConst.isUseWorker) {
              this.worker = new Worker(WorkerMgr.workerJsPath);
              this.worker.onmessage = this.onWorkerMsg.bind(this);
          }
      }
      sendMsg(type, data) {
          this.worker.postMessage({
              type: type,
              data: data
          });
      }
      onWorkerMsg(msg) {
          let data;
          data = msg.data.data;
          EventMgr.event(EventType.FindPathData, data);
      }
  }
  WorkerMgr.workerJsPath = 'workers/index.js';

  var Vector3$4 = Laya.Vector3;
  var Handler$1 = Laya.Handler;
  var Loader = Laya.Loader;
  class NavMgr {
      constructor() {
          this.navUrl = '';
          this._groupName = 'level';
          this._vec = new Laya.Vector3();
      }
      onMeshJsonLoaded(level) {
          if (this.navUrl != '') {
              Laya.loader.clearRes(this.navUrl);
          }
          this.navUrl = 'meshes/' + CfgDataMgr.instance.getLevelCfg(level).levelSceneName + '.json';
          Laya.loader.load(this.navUrl, Handler$1.create(this, this.onNavLoaded), null, Loader.JSON);
      }
      onFindPath(playerID, originVec, targetVec) {
          if (!SceneConst.isUseWorker) {
              if (Utils.isEmpty(this.patrol))
                  return null;
              let playerNavMeshGroup = this.patrol.getGroup(this._groupName, targetVec, false);
              let calculatedPath = this.patrol.findPath(originVec, targetVec, this._groupName, playerNavMeshGroup);
              if (calculatedPath && calculatedPath.length) {
                  let p = [];
                  let len = calculatedPath.length;
                  for (let i = 0; i < len; i++) {
                      p.push(new Vector3$4(calculatedPath[i].x, calculatedPath[i].y + 0.1, calculatedPath[i].z));
                  }
                  return p;
              }
              else {
                  return null;
              }
          }
          else {
              WorkerMgr.instance.sendMsg(1, {
                  id: playerID,
                  originVec: originVec,
                  targetVec: targetVec
              });
              return null;
          }
      }
      getClosestNode(targetVec) {
          if (!this.patrol)
              return null;
          let playerNavMeshGroup = this.patrol.getGroup(this._groupName, targetVec, false);
          let calculatedPath = this.patrol.getClosestNode(targetVec, this._groupName, playerNavMeshGroup);
          if (!calculatedPath)
              return null;
          this._vec.setValue(calculatedPath.centroid.x, calculatedPath.centroid.y, calculatedPath.centroid.z);
          return this.getRandomNode(this._vec);
      }
      getRandomNode(targetVec) {
          let playerNavMeshGroup = this.patrol.getGroup(this._groupName, targetVec, false);
          let calculatedPath = this.patrol.getRandomNode(this._groupName, playerNavMeshGroup, targetVec, 10);
          this._vec.setValue(calculatedPath.x, calculatedPath.y, calculatedPath.z);
          return this._vec;
      }
      isBitSet(value, position) {
          return !!(value & (1 << position));
      }
      onNavLoaded() {
          let self = this;
          let json = Laya.loader.getRes(self.navUrl);
          let g = self.getG(json);
          if (SceneConst.isUseWorker) {
              WorkerMgr.instance.sendMsg(0, {
                  json: json
              });
          }
          else {
              self.patrol = Laya.Browser.window.patrol;
              if (self.patrol == null && Laya.Browser.window.threePathfinding) {
                  self.patrol = Laya.Browser.window.threePathfinding.Pathfinding;
              }
              let zoneNodes;
              if (self.patrol.buildNodes) {
                  zoneNodes = self.patrol.buildNodes(g);
              }
              else {
                  zoneNodes = self.patrol.createZone(g);
                  self.patrol = new self.patrol();
              }
              self.patrol.setZoneData(this._groupName, zoneNodes);
          }
          let material = new Laya.BlinnPhongMaterial();
          material.albedoColor = new Laya.Vector4(20 / 255, 220 / 255 / 20 / 255 / 255 / 255);
          material.renderMode = Laya.BlinnPhongMaterial.RENDERMODE_CUTOUT;
          let mesh = new Laya.MeshSprite3D(NavMesh.createMesh(g));
          mesh.meshRenderer.material = material;
          mesh.name = 'NavMesh';
          mesh['_isStatic'] = true;
          DataMgr.instance.scene.addChild(mesh);
          let meshC = mesh.addComponent(Laya.PhysicsCollider);
          var meshShape = new Laya.MeshColliderShape();
          meshShape.mesh = mesh.meshFilter.sharedMesh;
          meshC.colliderShape = meshShape;
      }
      getG(json) {
          let nUvLayers = 0;
          if (json.uvs) {
              for (let i = 0; i < json.uvs.length; i++) {
                  if (json.uvs[i].length)
                      nUvLayers++;
              }
          }
          let p2 = json.vertices;
          let ii = json.faces;
          let faces = [];
          let offset = 0;
          let zLength = ii.length;
          while (offset < zLength) {
              let type = ii[offset++];
              let isQuad = this.isBitSet(type, 0);
              let hasMaterial = this.isBitSet(type, 1);
              let hasFaceVertexUv = this.isBitSet(type, 3);
              let hasFaceNormal = this.isBitSet(type, 4);
              let hasFaceVertexNormal = this.isBitSet(type, 5);
              let hasFaceColor = this.isBitSet(type, 6);
              let hasFaceVertexColor = this.isBitSet(type, 7);
              if (isQuad) {
                  faces.push({
                      a: ii[offset],
                      b: ii[offset + 1],
                      c: ii[offset + 2]
                  });
                  faces.push({
                      a: ii[offset],
                      b: ii[offset + 2],
                      c: ii[offset + 3]
                  });
                  offset += 4;
                  if (hasMaterial) {
                      offset++;
                  }
                  if (hasFaceVertexUv) {
                      offset += 4 * nUvLayers;
                  }
                  if (hasFaceNormal) {
                      offset++;
                  }
                  if (hasFaceVertexNormal) {
                      offset += 4;
                  }
                  if (hasFaceColor) {
                      offset++;
                  }
                  if (hasFaceVertexColor) {
                      offset += 4;
                  }
              }
              else {
                  faces.push({
                      a: ii[offset],
                      b: ii[offset + 1],
                      c: ii[offset + 2]
                  });
                  offset += 3;
                  if (hasMaterial) {
                      offset++;
                  }
                  if (hasFaceVertexUv) {
                      offset += 3 * nUvLayers;
                  }
                  if (hasFaceNormal) {
                      offset++;
                  }
                  if (hasFaceVertexNormal) {
                      offset += 3;
                  }
                  if (hasFaceColor) {
                      offset++;
                  }
                  if (hasFaceVertexColor) {
                      offset += 3;
                  }
              }
          }
          let p = [];
          let vscale = 1;
          for (let i = 0; i < p2.length; i += 3) {
              p.push(new Vector3$4(p2[i] * vscale, p2[i + 1] * vscale, p2[i + 2] * vscale));
          }
          let g = new Geometry();
          g.faces = faces;
          g.vertices = p;
          return g;
      }
  }
  NavMgr.instance = new NavMgr();

  class RocketLauncher extends Gun {
      onAwake() {
          this.propType = PropType.RocketLauncher;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          super.onUpdate();
          if (this.isFiring) {
              this.fire();
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
          let rocket = PropMgr.instance.getProp(PropType.Rocket, 'Rocket');
          this.launchTf.getForward(this._vec);
          if (this.player.isRolePlayer()) {
              rocket.setTarget(this.player, this.launchTf.position, this._vec, this.gunCfg);
          }
          else {
              rocket.setAITarget(this.player, this.launchTf.position, this._vec, this.gunCfg, this.player.curTarget.transform.position);
          }
      }
  }

  class SniperRifle extends Gun {
      onAwake() {
          this.propType = PropType.SniperRifle;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          super.onUpdate();
          if (this.isFiring) {
              this.fire();
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
      }
  }

  class VehicleProp extends Laya.Script3D {
      constructor() {
          super();
          this._isDead = false;
          this.isTank = false;
          this.isUseIng = false;
          this.useID = -1;
          this.bullet0 = 0;
          this.bullet1 = 0;
          this.clip0 = 0;
          this.clip1 = 0;
          this.durable = 0;
      }
      onAwake() {
          this.isUseIng = false;
          this._isDead = false;
          this.player = null;
          if (!this.gameObject) {
              this.gameObject = this.owner;
              this.model = this.gameObject.getChildAt(0);
              this.transform = this.gameObject.transform;
              let index = this.gameObject.name.indexOf('Tank');
              this.isTank = index != -1;
              this.trail && (this.trail.transform.localPositionY += 0.1);
              this.tailSmoke = ExUtils.findChild(this.gameObject, 'TailSmoke');
              this.trail = ExUtils.findChild(this.gameObject, 'Trail');
              if (this.tailSmoke) {
                  this.tailSmoke.destroy();
                  this.tailSmoke = null;
              }
              if (this.trail) {
                  this.trail.destroy();
                  this.trail = null;
              }
              this.ani = ExUtils.getComponentInChild(this.gameObject, Laya.Animator);
              this.body = ExUtils.findChild(this.gameObject, 'Body');
              this.rotatorCanonA = ExUtils.findChild(this.gameObject, 'RotatorCanonA');
              this.barrel = ExUtils.findChild(this.gameObject, 'Barrel');
              this.rotatorGunA = ExUtils.findChild(this.gameObject, 'RotatorGunA');
              this.body_Ruined = ExUtils.findChild(this.gameObject, 'Body_Ruined');
              this.rotatorCanonA_Ruined = ExUtils.findChild(this.gameObject, 'RotatorCanonA_Ruined');
              this.barrel_Ruined = ExUtils.findChild(this.gameObject, 'Barrel_Ruined');
              this.rotatorGunA_Ruined = ExUtils.findChild(this.gameObject, 'RotatorGunA_Ruined');
          }
          this.rotatorCanonA && Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorCanonA);
          this.rotatorCanonA_Ruined &&
              Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorCanonA_Ruined);
          this.barrel && Utils.vec3ToTargetVal('localRotationEuler', 1, this.barrel);
          this.rotatorGunA && Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorGunA);
          this.body_Ruined && Utils.vec3ToTargetVal('localRotationEuler', 1, this.body_Ruined);
          this.barrel_Ruined && Utils.vec3ToTargetVal('localRotationEuler', 1, this.barrel_Ruined);
          this.rotatorGunA_Ruined &&
              Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorGunA_Ruined);
      }
      setData(cfg) {
          if (!cfg)
              return;
          this.onAwake();
          Utils.vec3ToTargetVal('localRotationEuler', 1, this.model);
          Utils.vec3ToTargetVal('localPosition', 1, this.model);
          if (SceneConst.Realtime_Shadow) {
              ExUtils.setCastShadow(this.model, true);
          }
          this.cfg = cfg;
          let gunCfg = CfgDataMgr.instance.gunAttributeCfg[cfg.vehWeaponID2];
          this.bullet0 = gunCfg.magazineClip;
          this.clip0 = gunCfg.magazineNumber * gunCfg.magazineClip;
          gunCfg = CfgDataMgr.instance.gunAttributeCfg[cfg.vehWeaponID1];
          if (!gunCfg)
              return;
          this.bullet1 = gunCfg.magazineClip;
          this.clip1 = gunCfg.magazineNumber * gunCfg.magazineClip;
          this.durable = this.cfg.vehHPt;
          if (this.tailSmoke) {
              this.tailSmoke.active = this.trail.active = false;
          }
          this.refreshTankShow(false);
          if (this.isTank && this.rotatorCanonA) {
              let rotator = this.rotatorCanonA.parent;
              rotator.transform.localRotationEulerY = 0;
          }
          this.ani && this.ani.play('Idle');
          this.bindCollider(this.gameObject);
          let effect = this.gameObject.getChildByName(Effect.XS_guide_ef);
          if (effect) {
              effect.active = true;
          }
          else {
              effect = DataMgr.instance.showSceneEffect(Effect.XS_guide_ef, Vector3Ex.ZERO, null, null, false);
              this.gameObject.addChild(effect);
              effect.transform.localScaleX = 2;
              effect.transform.localScaleZ = 2;
          }
          this.gameObject.active = true;
      }
      playDeadAni() {
          DataMgr.instance.addChildToRoot1(this.gameObject);
          if (this.isTank) {
              this.transform.localPositionY = DataMgr.instance.roleHeight;
          }
          this.showEffect(false);
          this.ani.crossFade(this.isTank ? 'Dead' : 'D', 0.1);
          this.refreshTankShow(true);
          this._isDead = true;
          Laya.timer.once(20000, this, this.onRecover);
          this.bindCollider(this.gameObject);
      }
      playIdea() {
          this.ani.play('Idle');
      }
      playAttackAni() {
          if (this.isTank) {
              this.ani && this.ani.crossFade('Fire', 0.1);
          }
      }
      refreshTankShow(isDead) {
          if (this.rotatorGunA_Ruined) {
              this.body.meshRenderer.enable = !isDead;
              this.rotatorCanonA && (this.rotatorCanonA.meshRenderer.enable = !isDead);
              this.barrel && (this.barrel.meshRenderer.enable = !isDead);
              this.rotatorGunA && (this.rotatorGunA.meshRenderer.enable = !isDead);
              this.body_Ruined.active = isDead;
              this.rotatorCanonA_Ruined && (this.rotatorCanonA_Ruined.active = isDead);
              this.barrel_Ruined && (this.barrel_Ruined.active = isDead);
              this.rotatorGunA_Ruined.active = isDead;
          }
      }
      showEffect(isVisible) {
          if (this.tailSmoke) {
              this.trail && (this.tailSmoke.active = this.trail.active = isVisible);
          }
      }
      setActivation(id, player) {
          this.useID = id;
          this.player = player;
          this.playIdea();
          let effect = this.gameObject.getChildByName(Effect.XS_guide_ef);
          effect && (effect.active = false);
      }
      recover() {
          DataMgr.instance.addChildToRoot1(this.gameObject);
          this.gameObject.transform.localPositionY = DataMgr.instance.roleHeight;
          if (this.rotatorCanonA && this.rotatorCanonA.parent) {
              this.rotatorCanonA.parent.transform.localRotationEulerY = 0;
              this.barrel && Utils.vec3ToTargetVal('localRotationEuler', 1, this.barrel);
              this.rotatorGunA && Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorGunA);
              this.rotatorCanonA && Utils.vec3ToTargetVal('localRotationEuler', 1, this.rotatorCanonA);
          }
          this.isUseIng = this._isDead;
          this.durable = this.player.hp;
          this.bullet0 = this.player._gunArr[0].bulletCnt;
          this.clip0 = this.player._gunArr[0].magazineNumber;
          this.bullet1 = this.player._gunArr[1].bulletCnt;
          this.clip1 = this.player._gunArr[1].magazineNumber;
          this.bindCollider(this.gameObject);
          this.playIdea();
      }
      bindCollider(obj) {
          let co = obj.getComponent(Laya.PhysicsCollider);
          if (co) {
              co.collisionGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
              let collider = ExUtils.addSingleComponent(obj, VehCollider);
              collider.veh = this;
          }
          for (let i = 0; i < obj.numChildren; i++) {
              this.bindCollider(obj.getChildAt(i));
          }
      }
      onRecover() {
          this.gameObject.active = false;
      }
      roleRevive() {
          this.setData(this.cfg);
          this.player = DataMgr.instance.role;
          let effect = this.gameObject.getChildByName(Effect.XS_guide_ef);
          effect && (effect.active = false);
          Laya.timer.clear(this, this.onRecover);
      }
  }

  var Sprite3D$3 = Laya.Sprite3D;
  var Vector3$d = Laya.Vector3;
  var Handler$3 = Laya.Handler;
  var Loader$1 = Laya.Loader;
  var ShadowMode = Laya.ShadowMode;
  var ShadowCascadesMode = Laya.ShadowCascadesMode;
  class SceneMgr {
      constructor() {
          this._pathArr = [];
      }
      static get instance() {
          if (SceneMgr._instance == null) {
              SceneMgr._instance = new SceneMgr();
          }
          return SceneMgr._instance;
      }
      init() {
          this.initPrefab();
      }
      initPrefab() {
          DataMgr.instance.initProp();
          this._prefabDic = {};
          this.initSubPrefab(ESprite3D.Props);
      }
      createLight(scene) {
          let lights = scene.getChildByName('Lights');
          if (lights) {
              let light = lights.getChildByName('MixLight_Sun');
              if (light && !Utils.isIPhone()) {
                  light.shadowMode = ShadowMode.SoftLow;
                  light.shadowDistance = 10;
                  light.shadowResolution = 1024;
                  light.shadowCascadesMode = ShadowCascadesMode.NoCascades;
                  light.shadowNormalBias = 4;
              }
          }
          this.initSkybox();
      }
      initFog() {
          if (!SceneConst.Enable_Fog)
              return;
          DataMgr.instance.scene.enableFog = true;
          DataMgr.instance.scene.fogColor = new Vector3$d(0.494, 0.7, 0.85);
          DataMgr.instance.scene.fogStart = 30;
          DataMgr.instance.scene.fogRange = 150;
      }
      initSkybox() {
          if (!SceneConst.Enable_Skybox)
              return;
          Laya.BaseMaterial.load('scene/Conventional/Assets/Resources/Materials/SkyboxSunnyA.lmat', Handler$3.create(this, this.loadSkyMaterial));
      }
      loadSkyMaterial(mat) {
          DataMgr.instance.cameraCtrl.camera.clearFlag = Laya.BaseCamera.CLEARFLAG_SKY;
          let skyRenderer = DataMgr.instance.scene.skyRenderer;
          skyRenderer.mesh = Laya.SkyBox.instance;
          skyRenderer.material = mat;
      }
      initSubPrefab(path) {
          let node = Laya.loader.getRes(path);
          let obj;
          for (let i = 0, num = node.numChildren; i < num; i++) {
              obj = node.getChildAt(i);
              this._prefabDic[obj.name] = obj;
          }
      }
      revertPrefabToPool() {
          for (let i = DataMgr.instance.mapNode.numChildren - 1; i >= 0; i--) {
              let node = DataMgr.instance.mapNode.getChildAt(i).removeSelf();
              node.active = false;
              Laya.Pool.recover(node.name, node);
          }
      }
      getPrefab(modelName) {
          let obj = this._prefabDic[modelName];
          return Laya.Sprite3D.instantiate(obj, null);
      }
      getPreloadEnemyModels(secenPath) {
          this.clearLastScene();
          let result = [];
          let arr = [];
          for (let key in CfgDataMgr.instance.professionCfg) {
              let cfg = CfgDataMgr.instance.professionCfg[key];
              if (cfg.ID > 601) {
                  break;
              }
              arr.push(cfg.aiModel[0]);
              arr.push(cfg.aiModel[1]);
          }
          for (let i = 0, len = arr.length; i < len; i++) {
              result.push({
                  url: DynamicSceneRoot + arr[i] + '.lh',
                  type: Loader$1.HIERARCHY
              });
          }
          result.push({
              url: ESprite3D[secenPath],
              type: Loader$1.HIERARCHY
          });
          result.push({
              url: DynamicSceneRoot + 'WeapThrowGrenade' + '.lh',
              type: Loader$1.HIERARCHY
          });
          return result;
      }
      clearLastScene() {
          if (DataMgr.instance.scene == null)
              return;
          DataMgr.instance.getRootNode().removeSelf();
          DataMgr.instance.scene.destroy();
          DataMgr.instance.scene = null;
          Laya.Resource.destroyUnusedResources();
      }
      onSceneLoaded(path) {
          let scene = Laya.loader.getRes(path);
          if (!scene) {
              scene = new Laya.Scene3D();
              let arr = [, 'PropsDynamic', 'Lights'];
              for (let i = 0, len = arr.length; i < len; i++) {
                  scene.addChild(Laya.loader.getRes(DynamicSceneRoot + arr[i] + '.lh'));
              }
          }
          DataMgr.instance.scene = scene;
          Laya.stage.addChild(DataMgr.instance.scene);
          DataMgr.instance.scene.addChild(DataMgr.instance.getRootNode());
          DataMgr.instance.scene.physicsSimulation.continuousCollisionDetection = true;
          this.sceneCamAni = null;
          let sceneCam = scene.getChildByName('MainCamera');
          if (sceneCam) {
              let sp = sceneCam.getChildAt(0);
              sp = sp.getChildAt(0);
              sp.nearPlane = 1;
              let cameraAni = sceneCam.getComponent(Laya.Animator);
              cameraAni.speed = 0;
              this.sceneCamAni = cameraAni;
          }
          if (this._camera == null) {
              let camera = Laya.loader.getRes(ESprite3D.MainCamera);
              this._camera = camera;
              DataMgr.instance.cameraCtrl = camera.addComponent(CameraCtrl);
              DataMgr.instance.addChildToRoot(this._camera);
          }
          this._camera.active = false;
          let level = UserData.instance.level;
          NavMgr.instance.onMeshJsonLoaded(level);
          if (DataMgr.instance.pathArr.length == 0) {
              let cfg = CfgDataMgr.instance.getLevelCfg(level);
              let pathData = cfg.pathData;
              for (let i = 0; i < pathData.length; i++) {
                  let path = Laya.loader.getRes(PathJsonRoot + pathData[i]);
                  if (path) {
                      DataMgr.instance.pathArr.push(path);
                  }
              }
              CfgDataMgr.instance.spawnpointCfg = Laya.loader.getRes(JsonRoot + cfg.spawnpoint);
          }
          if (SceneConst.Realtime_Shadow) {
              this.createLight(scene);
              let len = scene.numChildren;
              for (let i = 0; i < len; i++) {
                  let sp = scene.getChildAt(i);
                  ExUtils.setRecieveShadow(sp, true);
              }
          }
          this.initFog();
          UserData.instance.level == 1 && this.createVeh();
          let sp = scene.getChildByName('PropsForExport');
          if (sp) {
              sp = scene.getChildByName('SmokeA1');
              if (sp) {
                  sp.destroy();
              }
          }
      }
      addChildToProp(obj) {
          DataMgr.instance.propParent.addChild(obj);
      }
      getProp(propType, name) {
          let prop = Laya.Pool.getItem(name);
          if (prop == null) {
              let prefab = new Sprite3D$3(name, false);
              let obj = Sprite3D$3.instantiate(prefab, DataMgr.instance.propParent, false);
              if (propType == PropType.MissileLauncher) {
                  prop = obj.addComponent(MissileLauncher);
              }
              else if (propType == PropType.SniperRifle) {
                  prop = obj.addComponent(SniperRifle);
              }
              else if (propType == PropType.GrenadeGun) {
                  prop = obj.addComponent(GrenadeGun);
              }
              else if (propType == PropType.RocketLauncher) {
                  prop = obj.addComponent(RocketLauncher);
              }
              else {
                  prop = obj.addComponent(AutoGun);
              }
          }
          if (prop) {
              DataMgr.instance.propParent.addChild(prop.owner);
              prop.owner.active = true;
          }
          return prop;
      }
      createVeh() {
          let spawnpointCfg = CfgDataMgr.instance.spawnpointCfg;
          for (let key in spawnpointCfg) {
              let point = spawnpointCfg[key];
              if (point.name.indexOf('HelicopterSpot') != -1) {
              }
          }
          let tankArr = [100102];
          let airArr = [100201, 100202];
          let sp = DataMgr.instance.scene.getChildByName('ActiveProps');
          sp = sp.getChildByName('Transporters');
          for (let i = 0, len = sp.numChildren; i < len; i++) {
              let child = sp.getChildAt(i);
              let vehId;
              if (child.name.indexOf('Tank') > -1) {
                  vehId = tankArr[(Math.random() * tankArr.length) | 0];
              }
              else {
                  vehId = airArr[(Math.random() * airArr.length) | 0];
              }
              let cfg = CfgDataMgr.instance.vehicleCfg[vehId];
              let name = DynamicSceneRoot + cfg.vehModel_inactive + '.lh';
              ExUtils.instanceSprite3D(name, null, Laya.Handler.create(this, function (modelName, index, curVehID, model) {
                  let prop;
                  let objPoint = sp.getChildAt(index);
                  if (model.name != modelName) {
                      let vehParent = new Laya.Sprite3D();
                      objPoint.addChild(vehParent);
                      vehParent.addChild(model);
                      vehParent.name = modelName;
                      model.active = true;
                      prop = ExUtils.addSingleComponent(model.parent, VehicleProp);
                  }
                  else {
                      prop = ExUtils.addSingleComponent(model, VehicleProp);
                      objPoint.addChild(model);
                  }
                  Utils.vec3ToTargetVal('localRotationEuler', 1, model);
                  Utils.vec3ToTargetVal('localPosition', 1, model);
                  let cfg1 = CfgDataMgr.instance.vehicleCfg[curVehID];
                  prop.setData(cfg1);
                  prop.modelName = modelName;
                  DataMgr.instance.props.push(prop);
              }, [name, i, vehId]));
          }
          AirdropMgr.instance.init();
      }
      setSceneAni() {
          if (this.sceneCamAni) {
              this.sceneCamAni.speed = 1;
              switch (DataMgr.instance.levelCfg.levelSceneName) {
                  case 'LvIslandA1':
                      this.sceneCamAni.play('LvIslandA1');
                      break;
                  case 'LvAircCarriA1':
                      this.sceneCamAni.play('LvAircCarriA1');
                      break;
                  case 'LvAircCarriA2':
                      this.sceneCamAni.play('LvAircCarriA2');
                      break;
              }
          }
      }
  }
  SceneMgr._instance = null;

  class TaskMgr {
      constructor() { }
      init() {
          EventMgr.on(EventType.RefreshTaskProgress, this, this.setTaskProgress);
          EventMgr.on(EventType.DebugTaskTest, this, this.debugTaskTest);
          EventMgr.on(EventType.DebugDelTaskTest, this, this.debugDelTaskTest);
          EventMgr.on(EventType.DebugTaskLvTest, this, this.debugTaskLvTest);
          EventMgr.on(EventType.DebugTaskExpTest, this, this.debugTaskExpTest);
          let taskData = UserData.instance.getAllTaskData();
          if (Object.keys(taskData).length == 0) {
              this.refreshTaskData();
              UserData.instance.taskDay = Date.now();
          }
          else {
              let myDate = new Date(UserData.instance.taskDay);
              let month = myDate.getMonth() + 1;
              let str1 = Utils.getTodayDate();
              let arr1 = str1.split('_');
              if (month != parseInt(arr1[1])) {
                  this.refreshTaskData();
                  UserData.instance.clearTaskReward();
                  UserData.instance.taskDay = Date.now();
              }
              else if (UserData.instance.isNeedRefreshTask) {
                  Laya.timer.frameOnce(2, this, function () {
                      this.checkTaskCom();
                  });
              }
          }
      }
      refreshTaskData() {
          UserData.instance.clearTaskData();
          let cfg = CfgDataMgr.instance.getGlobalCfg('warMakesMissionTypeID');
          let arr = [];
          for (let i = 0, len = cfg.length; i < len; i++) {
              arr.push(cfg[i]);
          }
          arr = Utils.randomSort(arr);
          let taskCnt = CfgDataMgr.instance.getGlobalCfg('warMakesMissionNumber');
          for (let i = 0; i < taskCnt; i++) {
              let taskArr = CfgDataMgr.instance.warMakesMissionCfg[arr[i]];
              let info = taskArr[(Math.random() * taskArr.length) | 0];
              let data = {};
              data.ID = info.ID;
              data.type = arr[i];
              data.progress = 0;
              data.state = 1;
              data.completeVal = info.conditionParam_1;
              data.exp = info.warMakesMissionExp;
              data.param = info.conditionParam_2;
              UserData.instance.setTaskArr(arr[i], data);
          }
          let type = CfgDataMgr.instance.getGlobalCfg('warMakesMissionFixedTypeID');
          let taskArr = CfgDataMgr.instance.warMakesMissionCfg[type];
          let info = taskArr[(Math.random() * taskArr.length) | 0];
          let data = {};
          data.ID = info.ID;
          data.type = type;
          data.progress = 0;
          data.state = 1;
          data.completeVal = info.conditionParam_1;
          data.exp = info.warMakesMissionExp;
          data.param = info.conditionParam_2;
          UserData.instance.setTaskArr(type, data);
      }
      checkTaskCom() {
          let taskData = UserData.instance.getAllTaskData();
          let delArr = [];
          let taskArr = [];
          for (let key in taskData) {
              let task = taskData[key];
              if (task.state == 0) {
                  delArr.push(task.type);
              }
              else {
                  taskArr.push(task.type);
              }
          }
          for (let key in delArr) {
              UserData.instance.delOneTask(delArr[key]);
          }
          let arr = CfgDataMgr.instance.getGlobalCfg('warMakesMissionTypeID');
          arr = arr.concat();
          for (let key in taskArr) {
              Utils.removeArrayObj(arr, taskArr[key]);
          }
          arr = Utils.randomSort(arr);
          taskData = UserData.instance.getAllTaskData();
          let taskCnt = CfgDataMgr.instance.getGlobalCfg('warMakesMissionNumber') + 1;
          for (let i = taskCnt - Object.keys(taskData).length; i > 0; i--) {
              let taskArr = CfgDataMgr.instance.warMakesMissionCfg[arr[i]];
              let info = taskArr[(Math.random() * taskArr.length) | 0];
              let data = {};
              data.ID = info.ID;
              data.type = arr[i];
              data.progress = 0;
              data.state = 1;
              data.completeVal = info.conditionParam_1;
              data.exp = info.warMakesMissionExp;
              data.param = info.conditionParam_2;
              UserData.instance.setTaskArr(arr[i], data);
          }
      }
      setTaskProgress(taskId, val, conditionParam_2 = -1) {
          let allTaskData = UserData.instance.getAllTaskData();
          let taskData = allTaskData[taskId];
          if (taskData !== void 0 && taskData.state == 1) {
              if (conditionParam_2 != -1) {
                  if (conditionParam_2 == taskData.param) {
                      taskData.progress += val;
                  }
                  else {
                      return;
                  }
              }
              else {
                  taskData.progress += val;
              }
              if (taskData.progress >= taskData.completeVal) {
                  taskData.progress = taskData.completeVal;
                  taskData.state = 2;
                  EventMgr.event(EventType.RefreshTaskGet);
              }
              UserData.instance.setTaskArr(taskId, taskData);
              EventMgr.event(EventType.RefreshTask);
          }
      }
      debugTaskTest(taskId) {
          let type = '';
          let info;
          for (let key in CfgDataMgr.instance.warMakesMissionCfg) {
              let arr = CfgDataMgr.instance.warMakesMissionCfg[key];
              for (let key1 in arr) {
                  if (taskId == arr[key1].ID) {
                      type = key;
                      info = arr[key1];
                  }
              }
          }
          if (type == '') {
              UIMgr.showTips('无效任务ID');
              return;
          }
          let taskData = UserData.instance.getOneTaskData(parseInt(type));
          if (taskData !== void 0) {
              UIMgr.showTips('同类型任务已存在');
              return;
          }
          let data = {};
          data.ID = info.ID;
          data.type = parseInt(type);
          data.progress = 0;
          data.state = 1;
          data.completeVal = info.conditionParam_1;
          data.exp = info.warMakesMissionExp;
          data.param = info.conditionParam_2;
          UserData.instance.setTaskArr(data.type, data);
          UIMgr.showTips('添加任务成功');
          EventMgr.event(EventType.RefreshTask);
      }
      debugDelTaskTest(taskId) {
          let taskData = UserData.instance.getOneTaskData(taskId);
          if (taskData !== void 0) {
              UserData.instance.delOneTask(taskId);
              UIMgr.showTips('删除任务成功');
              EventMgr.event(EventType.RefreshTask);
          }
          else {
              UIMgr.showTips('没有找到该类型任务');
          }
      }
      debugTaskLvTest(lv) {
          UserData.instance.taskLv = lv;
          UserData.instance.taskExp = CfgDataMgr.instance.warMakesRewardCfg[lv].rackedExp;
          EventMgr.event(EventType.RefreshTaskView);
      }
      debugTaskExpTest(val) {
          UserData.instance.taskExp += val;
          for (let key in CfgDataMgr.instance.warMakesRewardCfg) {
              let cfg = CfgDataMgr.instance.warMakesRewardCfg[key];
              if (UserData.instance.taskExp >= cfg.rackedExp) {
                  UserData.instance.taskLv = cfg.ID;
              }
          }
          EventMgr.event(EventType.RefreshTaskView);
      }
  }
  TaskMgr.instance = new TaskMgr();

  // var Miwu = require('allval');
  var Advertisement = {

  };
  //初始化变量
  Advertisement.initVal = function () {
    Advertisement.recorder = null;    //游戏录制变量
    Advertisement.resNode = null;     //常住节点的变量
    Advertisement.currtimer = 0;      //录制计时变量
    Advertisement.cstop = false;      //录制成功判断变量
    Advertisement.videoPath = "";     //录制路径变量
    Advertisement.erroRecNode = null; //录屏错误节点变量
    Advertisement.erroNode = null;    //激励视频错误节点变量
    Advertisement.nrewardNode = null; //奖励发放节点变量
    Advertisement.bannerAd = null;    //banner广告变量
    Advertisement.nativeAd = null;    //原生广告变量
    Advertisement.isLoad = false; //原生广告就绪
    Advertisement.isShow = false; //原生广告就绪

    Advertisement.nativeAdn = null;   //原生广告节点
    Advertisement.nativeAdtouch = false;
    Advertisement.bannersize = false; //判断是否适配过
    Advertisement.insertAd = null;    //插屏广告变量
    Advertisement.videoAd = null;     //激励视频广告变量
    Advertisement.reward = true;      //判断是否发放奖励
    Advertisement.rewarda = "";       //奖励类型变量    
    Advertisement.rewardNode = null;  //奖励节点变量
    Advertisement.native = true;      //防止原生广告是否请求频繁判断
    Advertisement.insert = true;      //防止插屏广告是否请求频繁判断
    Advertisement.bannerReady = false;      //防止banner广告请求频繁判断
    Advertisement.isAutoBanner = true;
    Advertisement.video = true;      //防止video请求过于频繁
    Advertisement.bgmusic = 0;        //背景音乐ID
    Advertisement.adId = '';          //原生广告返回ID
    Advertisement.nativeAdl = null;
    Advertisement.adLabel = null;
    Advertisement.bannerID = "";
    Advertisement.imenu = false;
    Advertisement.pkname = '';
    Advertisement.hutui = null;
    Advertisement.imag = null;
    Advertisement.closeBtn = null;
    Advertisement.closet = false;

    Advertisement.socketTimeOut = null;
   

    Advertisement.screenWidth = 0;
    Advertisement.screenHeight = 0;

    Advertisement.initSystemInfo();
    var two  = 0;
    Advertisement.nativeAdV();
    // Advertisement.bannerAdver();
    Advertisement.insertAdverV2();
    
    Advertisement.data = null;
    qg.getSystemInfo({
        success: function (data) {
            console.log(`handling success， screenHeight = ${data.screenHeight}`);
            Advertisement.data = data;
        }
    });
    this.testDate = new Date();

    
  };
  Advertisement.specialPeriod = function () {
    // this.testDate = new Date();
    //     setInterval(() => {
    //         console.log('15秒')
    //         Advertisement.showNative();
    //     }, 30000);
  };


  /**
     * 在这个时间前不显示广告
     * @param _year 年
     * @param _month 月
     * @param _date 日
     * @param _h 小时
     * @param _m 分钟
     * @returns 
     */
  Advertisement.TimeManger = function(_year, _month, _date, _h,){
    var nowdate = new Date();
    //年
    var year = nowdate.getFullYear();
    //月
    var month = nowdate.getMonth() + 1;
    //日
    var date = nowdate.getDate();
    //周几
    var day = nowdate.getDay();
    //小时
    var h = nowdate.getHours();
    //分钟
    var m = nowdate.getMinutes();
    //秒
    var s = nowdate.getSeconds();
    console.log(year, month, date, h, m);
    if (year > _year) {
      return true
    } else if (year == _year) {
      if (month > _month) {
        return true;
      } else if (month == _month) {
        if (date > _date) {
          return true;
        } else if (date == _date) {
          if (h > _h) {
            return true;
          }
          else {
            return false;
          }
        }
        else {
          return false;
        }
      } else {
        return false;
      }
    } else {
      return false;
    }
  };
  var JGt  = 0;
  Advertisement.jiangeP = function(){
    
    
    if (Laya.timer.currTimer - JGt > 3000) {
      JGt = Laya.timer.currTimer;
      
      return true;
    }
    else {
      return false;
    }
  };
  Advertisement.insertAdverV2 = function () {
    
    
      if(Advertisement.jiangeP() == true)
      {
        if(!Advertisement.TimeManger(2025,6,13,19) ) return;
        console.log('/*-4-52-12kdck'),
        Advertisement.showNative(),
    Advertisement.bannerAdverV();
      }
      
    
     

     
  },

  //获取当前是周几
  Advertisement.getWeekDate = function () {
    var now = new Date();
    var day = now.getDay();
    var weeks = new Array(
        "周日",
        "周一",
        "周二",
        "周三",
        "周四",
        "周五",
        "周六",
    );
    var week = weeks[day];
    console.log(week);
    return week;
  };

  //VIVO获取系统信息
  Advertisement.initSystemInfo = function () {
    qg.getSystemInfo({
      success: function (data) {
        console.log(`handling success， brand = ${data.brand}`);
        Advertisement.screenHeight = data.screenHeight;
        Advertisement.screenWidth = data.screenWidth;
      }
    });
  },

    // //VIVO原生插屏广告竖屏
    // Advertisement.nativeAdV = function () {
    //   console.log("测试log0:", Advertisement.isLoad);
    //   if (Advertisement.screenHeight && Advertisement.screenWidth) {
    //     console.log("测试log1:", Advertisement.isLoad);
    //     Advertisement.nativeAd = qg.createCustomAd({
    //       posId: '0e05ba1fe9524c9dba37877dda21eefd',
    //       style: {
    //         // left: (Advertisement.screenWidth - (Advertisement.screenWidth/1080)*525)/2,
    //         top: Advertisement.screenHeight / 2
    //       }
    //     });
    //   }
    //   else {
    //     console.log("测试log2:", Advertisement.isLoad);
    //     Advertisement.nativeAd = qg.createCustomAd({
    //       posId: '0e05ba1fe9524c9dba37877dda21eefd',
    //       style: {
    //         top: 500
    //       }
    //     });
    //   }
    //   Advertisement.nativeAd.onLoad(() => {
    //     Advertisement.isLoad = true;
    //     // console.log("原生广告onLoad");
    //   });
    //   Advertisement.nativeAd.onError(err => {
    //     // console.log("原生模板广告加载失败", err);
    //     Advertisement.isLoad = false;
    //     Laya.timer.once(1000, this, Advertisement.nativeAdV);
    //   });
    // },
    // Advertisement.showNative = function () {
    //   this.testDate = new Date();
      
    //     // console.log('小于等于13')
      
    //     let timer = 0.8;
    //     Laya.timer.once(timer * 1000, this, () => {
    //       console.log("测试log3:", Advertisement.isLoad);
    //       if (Advertisement.isLoad && !Advertisement.isShow) {
    //         Advertisement.isShow = true;
    //         Advertisement.nativeAd.show().then(() => {
    //           let mask = new Laya.Sprite;
    //           mask.width = 2000;
    //           mask.height = 3000;
    //           mask.mouseEnabled = true;
    //           Laya.stage.addChild(mask);
    //           mask.zOrder = 99999;
    //           Advertisement.nativeAd.onClose(() => {
    //             mask.destroy();
    //             Advertisement.isLoad = false;
    //             Advertisement.isShow = false;
    //             // Advertisement.nativeAdV();
    //             Advertisement.nativeAd.offLoad();
    //             Advertisement.nativeAd.offError();
    //             Advertisement.nativeAd.offClose();
    //             Advertisement.nativeAd.destroy();
    //             Laya.timer.once(1000, this, Advertisement.nativeAdV);
    //             // Advertisement.nativeAdV();
    //           });
    //           console.log('原生模板广告展示完成');
    //         }).catch((err) => {
    //           console.log('原生模板广告展示失败', JSON.stringify(err));
    //           Advertisement.isLoad = false;
    //           Advertisement.isShow = false;
    //           // Advertisement.nativeAdV();
    //           Advertisement.nativeAd.offLoad();
    //           Advertisement.nativeAd.offError();
    //           Advertisement.nativeAd.offClose();
    //           Advertisement.nativeAd.destroy();
    //           Laya.timer.once(1000, this, Advertisement.nativeAdV);
    //           // Advertisement.nativeAdV();
    //         });
    //       }
    //     });
      
    // },
    //VIVO原生插屏广告横屏
    Advertisement.nativeAdV = function () {
      console.log("测试log0:", Advertisement.isLoad);
      if (Advertisement.screenHeight && Advertisement.screenWidth) {
        console.log("测试log1:", Advertisement.isLoad);
        Advertisement.nativeAd = qg.createCustomAd({
          posId: '2541911',
          style: {
            // left: (Advertisement.screenWidth - (Advertisement.screenWidth/1080)*525)/2,
            // top: Advertisement.screenHeight / 2
            // left: Advertisement.data.screenWidth / 4,
            // top: Advertisement.data.screenHeight / 8
          }
        });
      }
      else {
        console.log("测试log2:", Advertisement.isLoad);
        Advertisement.nativeAd = qg.createCustomAd({
          posId: '2541911',
          style: {
            top: 500
            // left: Advertisement.data.screenWidth / 4,
            //       top: Advertisement.data.screenHeight / 8
          }
        });
      }
      Advertisement.nativeAd.onLoad(() => {
        Advertisement.isLoad = true;
        console.log("原生广告onLoad");
      });
      Advertisement.nativeAd.onError(err => {
        console.log("原生模板广告加载失败", err);
        Advertisement.isLoad = false;
        Laya.timer.once(1000, this, Advertisement.nativeAdV);
      });
    },

    
    Advertisement.showNative = function () {
      this.testDate = new Date();
      // if ((this.getWeekDate() == "周六" || this.getWeekDate() == "周日") ||
      //     ((Number(this.testDate.getHours()) <= 9) || (Number(this.testDate.getHours()) >= 19))) {
      //     console.log('周六日或十月1-7')
          if (qg.createCustomAd && Advertisement.data) {
              Advertisement.customAd = qg.createCustomAd({
                  posId: '2541911',
                  style: {
                      left: Advertisement.data.screenWidth / 4,
                      top: Advertisement.data.screenHeight / 8
                      // left: 0,
                      // top: Advertisement.data.screenHeight / 5
                  }
              });
              Advertisement.customAd.onError(err => {
                  console.log("原生模板广告加载失败", err);
              });
              Advertisement.customAd.show().then(() => {
                  console.log('原生模板广告展示完成');
              }).catch((err) => {
                  console.log('原生模板广告展示失败', JSON.stringify(err));
              });
              //原生广告关闭回调
              // Advertisement.customAd.onClose(function() {
              //     Advertisement.bannerAdverV();
              // })
          }
          // Advertisement.bannerAdverV();
      // } else (
      //     console.log('周一五')
      // )
  },
    //VIVObanner广告
  Advertisement.bannerAdverV = function () {
        // return;
        // if(!Advertisement.TimeManger(2024,2,8,19,0)) return;
            //销毁之前存在的banner广告
            if (Advertisement.bannerAd != null) {
                Advertisement.bannerAd.destroy();
                Advertisement.bannerAd = null;
            }
            Advertisement.boolBannerVivo = false;
            Advertisement.bannerAd = qg.createBannerAd({
                posId: "2541906", //输入广告ID
                style: {
                    // left:0,
                    // top:0
                }
            });
            let adshow = Advertisement.bannerAd.show();
            // 调用then和catch之前需要对show的结果做下判空处理，防止出错（如果没有判空，在平台版本为1052以及以下的手机上将会出现错误）
            adshow && adshow.then(() => {
                console.log("banner广告展示成功");
                Advertisement.resNode.scheduleOnce(function () {
                    Advertisement.boolBannerVivo = true;
                }, 10);
            }).catch((err) => {
                switch (err.code) {
                    case 30003:
                        console.log("新用户7天内不能曝光Banner，请将手机时间调整为7天后，退出游戏重新进入");
                        //   qg.showToast({
                        //       message: "banner广告展示失败：30003"
                        //   });
                        break;
                    case 30009:
                        console.log("10秒内调用广告次数超过1次，10秒后再调用");
                        //   qg.showToast({
                        //       message: "banner广告展示失败：30009"
                        //   });
                        setTimeout(() => {
                            retryShow2();
                        }, 10000);
                        break;
                    case 30002:
                        console.log("加载广告失败，重新加载广告");
                        //   qg.showToast({
                        //       message: "banner广告展示失败：30002"
                        //   });
                        setTimeout(() => {
                            retryShow();
                        }, 10000);
                        break;
                    default:
                        // 参考 https://minigame.vivo.com.cn/documents/#/lesson/open-ability/ad?id=广告错误码信息 对错误码做分类处理
                        console.log("banner广告展示失败");
                        console.log(JSON.stringify(err));
                        //   qg.showToast({
                        //       message: `banner广告展示失败${JSON.stringify(err)}`
                        //   });
                        break;
                }
            });
            Advertisement.bannerAd.onClose(function () {
                Advertisement.resNode.scheduleOnce(function () {
                    // Advertisement.boolBannerVivo = true;
                    Advertisement.bannerAdverV();

                }, 60);
            });





    };


  Advertisement.bannerDestroy = function () {
    if (Advertisement.bannerAd != null) {
        Advertisement.bannerAd.destroy();
        Advertisement.bannerAd = null;
        Advertisement.bannersize = false;
    }
  };
    //VIVO插屏广告
    Advertisement.insertV = function () {
      console.log('Advertisement.insertV');
      // Advertisement.showNative();
      // Advertisement.nativeAdV();
      Advertisement.showNative();
    };

    // //VIVO激励视频


  Advertisement.videoAdverV = function (e) {
    Advertisement.showTip("暂无广告，请重试");
    Advertisement.videop = e;
    if (Advertisement.videoAd == null) {
        Advertisement.videoAd = qg.createRewardedVideoAd({
            posId: '2541912' //输入广告ID
        });
        Advertisement.videoAd.onLoad(() => {
            console.log("激励视频已加载");
            // cc.audioEngine.pauseAll();
            var adshow = Advertisement.videoAd.show();
            // 调用then和catch之前需要对show的结果做下判空处理，防止出错（如果没有判空，在平台版本为1052以及以下的手机上将会出现错误）
            Advertisement.reward = true;
            adshow && adshow.then(() => {
                console.log("激励视频广告显示成功");
            }).catch(err => {
                console.log("激励视频广告显示失败", err);
                Advertisement.showTip("暂无广告，请重试");
                Advertisement.errorNode.opacity = 255;
                setTimeout(() => {
                    Advertisement.errorNode.opacity = 0;
                }, 3000);
            });
        });
        Advertisement.videoAd.onError(err => {
            console.log("激励视频异常", err);
        });
        Advertisement.videoAd.onClose(res => {
            if (res && res.isEnded) {
                if (Advertisement.reward) //判断是否发放过奖励
                {
                    Advertisement.reward = false;
                    // cc.audioEngine.resumeAll();
                    
                    Advertisement.videop && Advertisement.videop();
                    Advertisement.videop = null;
                    
                    
                }
            } else {
                console.log("播放中途退出，不下发游戏奖励");
                // cc.audioEngine.resumeAll();
            }
        });
    }
    var adload = Advertisement.videoAd.load();

    // 调用then和catch之前需要对load的结果做下判空处理，防止出错（如果没有判空，在平台版本为1052以及以下的手机上将会出现错误）
    adload && adload.then(() => {
        console.log("激励视频广告加载成功");
    }).catch(err => {
        console.log("激励视频广告加载失败", err);
        Advertisement.showTip("暂无广告，请重试");
        Advertisement.errorNode.opacity = 255;
        setTimeout(() => {
            Advertisement.errorNode.opacity = 0;
        }, 3000);
    });
  };

  Advertisement.showTip = function (str) {
    let te = new Laya.Label();
    te.text = str;
    te.fontSize = 38;
    te.zOrder = 99999;
    te.color = "#FFFFFF";//FFFFFF
    te.x = 280;
    te.y = 300;
    
    Laya.stage.addChild(te);
    Laya.timer.once(2 * 1000,this,()=>{
      te.destroy();
    });
  };

  var Handler$5 = Laya.Handler;
  var Loader$6 = Laya.Loader;
  class ResMgr {
      constructor() { }
      static get instance() {
          if (ResMgr._instance == null) {
              ResMgr._instance = new ResMgr();
          }
          return ResMgr._instance;
      }
      static preLoadCfg() {
          let preload = ResMgr.PreloadCfg;
          for (let key in PreEJson) {
              let data = {
                  url: PreEJson[key],
                  type: Loader$6.JSON
              };
              preload.push(data);
          }
          Laya.loader.create(ResMgr.PreloadCfg, Handler$5.create(ResMgr, ResMgr.onComplete0), Handler$5.create(ResMgr, ResMgr.onProgress0));
      }
      static onProgress0(value) {
          EventMgr.event(EventType.ResProgress, value * ResMgr._preWeight);
      }
      static onProgress1(value) {
          var preWeight = ResMgr._preWeight;
          EventMgr.event(EventType.ResProgress, value * (1 - preWeight) + preWeight);
      }
      static onComplete0(isSuccess) {
          if (isSuccess) {
              CfgDataMgr.instance.addConfigs();
              UserData.instance.init();
              TaskMgr.instance.init();
              var reload = ResMgr.PreloadRes;
              reload.push({
                  url: 'resource/matching/VS_effect.png',
                  type: Loader$6.IMAGE
              });
              reload.push({
                  url: 'resource/matching/word_1.png',
                  type: Loader$6.IMAGE
              });
              reload.push({
                  url: 'resource/comp/bg.png',
                  type: Loader$6.IMAGE
              });
              Laya.loader.create(reload, Handler$5.create(ResMgr, ResMgr.onComplete1), Handler$5.create(ResMgr, ResMgr.onProgress1));
              EventMgr.once(EventType.LoadingSuc, ResMgr, ResMgr.instance.launchGame);
          }
          else {
              UIMgr.openUI(EUI.NetLoadingView);
          }
      }
      static onComplete1(isSuccess) {
          if (isSuccess) {
              Laya.loader.create(ResMgr.SyncloadCfg, Handler$5.create(ResMgr, CfgDataMgr.instance.addConfigs), null);
              if (!UserData.instance.isGuide) {
                  let cfg = CfgDataMgr.instance.professionCfg[UserData.instance.curVocationId];
                  Laya.loader.create(DynamicSceneRoot + cfg.aiModel[0] + '.lh', null, null, Loader$6.HIERARCHY);
              }
              ResMgr.instance.launchGame();
          }
          else {
              UIMgr.openUI(EUI.NetLoadingView);
          }
      }
      launchGame() {
          if (++ResMgr._sucCount == 2) {
              EventMgr.event(EventType.LaunchGame);
          }
      }
      static preLoadGameRes(level = 1) {
          UIMgr.openUI(EUI.SecLoadingView);
          Laya.loader.maxLoader = 10;
          let reload = [];
          let syncload = [];
          if (DataMgr.instance.isLaunchGame) {
              syncload.push({
                  url: ESprite3D.CamHelicopter,
                  type: Loader$6.HIERARCHY
              });
              syncload.push({
                  url: ESprite3D.CamTank,
                  type: Loader$6.HIERARCHY
              });
              for (let key in EJson) {
                  let data = {
                      url: EJson[key],
                      type: Loader$6.JSON
                  };
                  reload.push(data);
              }
          }
          if (!UserData.instance._isFirstGame) {
              let cfg = CfgDataMgr.instance.getLevelCfg(level);
              if (cfg) {
                  reload.push({
                      url: JsonRoot + cfg.spawnpoint,
                      type: Loader$6.JSON
                  });
                  for (let i = 0; i < cfg.pathData.length; i++) {
                      reload.push({
                          url: PathJsonRoot + cfg.pathData[i],
                          type: Loader$6.JSON
                      });
                  }
              }
              else {
                  console.log('未找到关卡配置表，level: ' + level);
              }
              let obj = SceneMgr.instance.getPreloadEnemyModels(cfg.levelSceneName);
              reload = reload.concat(obj);
              reload.push({
                  url: ESprite3D.MainCamera,
                  type: Loader$6.HIERARCHY
              });
              reload.push({
                  url: ESprite3D.CameraPoint,
                  type: Loader$6.HIERARCHY
              });
              reload.push({
                  url: ESprite3D.Effect,
                  type: Loader$6.HIERARCHY
              });
              reload.push({
                  url: ESprite3D.Props,
                  type: Loader$6.HIERARCHY
              });
              reload.push({
                  url: ESprite3D.RoleDeadPoint,
                  type: Loader$6.HIERARCHY
              });
          }
          DataMgr.instance.isLoadCom = false;
          Laya.loader.create(reload, Handler$5.create(ResMgr, ResMgr.onGameComp1), Handler$5.create(ResMgr, ResMgr.onGameProgress));
          Laya.timer.once(2000, this, function () {
              Laya.loader.create(syncload, null, null);
          });
      }
      static onGameComp() {
          if (DataMgr.instance.isLaunchGame) {
              CfgDataMgr.instance.initConfigs();
              SceneMgr.instance.init();
          }
          EventMgr.event(EventType.GameBegin);
      }
      static onGameProgress(val) {
          EventMgr.event(EventType.ResProgress, val);
      }
      static onGameComp1(isSuccess) {
          Advertisement.insertAdverV2();
          console.info('资源加载成功  可以进入游戏', isSuccess);
          if (isSuccess) {
              DataMgr.instance.isLoadCom = true;
          }
          else {
              UIMgr.openUI(EUI.NetLoadingView);
          }
      }
      static loadGlobal() {
          Laya.loader.create([
              {
                  url: JsonRoot + 'global.json',
                  type: Loader$6.JSON
              }
          ], Handler$5.create(ResMgr, ResMgr.loadGlobalCom));
      }
      static loadGlobalCom(isSuccess) {
          if (isSuccess) {
              CfgDataMgr.instance.initGlobalCfg();
              UIMgr.openUI(EUI.LogoView);
          }
          else {
              UIMgr.openUI(EUI.NetLoadingView);
          }
      }
  }
  ResMgr._instance = null;
  ResMgr.PreloadCfg = [];
  ResMgr.SyncloadCfg = [];
  ResMgr.PreloadRes = [];
  ResMgr._sucCount = 0;
  ResMgr._preWeight = 0.4;

  class SdkMgr {
      static createBlockAd(type) { }
      static closeBlockAd() { }
      static createAppBox() { }
      static createRewardedVideoAd(callBack, fail) {
          callBack && callBack();
      }
      static LoadSubpackage(callback, name = '') {
          if (Laya.Browser.onWeiXin) {
              window['wx']['loadSubpackage']({
                  name,
                  success: function (res) {
                      console.log('成功', name);
                      callback();
                  }
              });
          }
          else {
              callback();
          }
      }
      static createInsertAd(type) { }
      static trackEvent(id, str) { }
      static addMoreGame(view, type) { }
      static addesk(view) { }
      static visibilitychange() { }
      static shareCard(handler, isShowTips = true) { }
      static loadSubpackage(packLoaded, cb) { }
  }

  class LoadingUI extends ui.view.LoadingUI {
      onAwake() {
          let self = this;
          self.regEvent(EventType.ResProgress, self.onProgress);
          Laya.loader.on(Laya.Event.ERROR, self, self.onLoadError);
          EventMgr.event(EventType.EnterLoading);
          let local = Laya.LocalStorage, cache = 'hasCache';
          let subWg = 0;
          self.util = LoadUtils.create([0, 1, 2], [subWg, 0.95 - subWg, 0.05]);
          local.setItem(cache, '1');
          self.setValue(0, 1);
          SdkMgr.LoadSubpackage(() => {
              SdkMgr.LoadSubpackage(() => {
                  SdkMgr.LoadSubpackage(() => {
                      SdkMgr.LoadSubpackage(() => {
                          SdkMgr.LoadSubpackage(() => {
                              ResMgr.preLoadCfg();
                          }, 'meshes');
                      }, 'JsonPath');
                  }, 'head_4399');
              }, 'resource');
          }, 'home');
          DataMgr.instance.loadTime = Date.now();
          UmengPlatform.trackEvent('loding', {
              loding: UserData.instance.isNewPlayer ? '新' : '老'
          });
      }
      onDisable() {
          let self = this;
          self.util.clear();
          self.util = null;
          self.removeTimer();
          Laya.loader.off(Laya.Event.ERROR, self, self.onLoadError);
          EventMgr.event(EventType.EnterLoading);
      }
      initTimer() {
          let self = this;
          if (!self.netTimer) {
              self.netTimer = new Timer(self.onLogin, self, 12);
              self.onLogin();
          }
          self.onLogin();
      }
      onLogin() {
          let self = this;
          let timer = self.netTimer, value;
          let minTime = CfgDataMgr.instance.getGlobalCfg('theFirstTimeLogosStayTime');
          minTime *= 1000;
          if ((value = timer.runTime / minTime) >= 1) {
              value = 1;
              timer.clear();
          }
          self.util.setValue(2, value);
          self.updateBar();
      }
      removeTimer() {
          let self = this;
          let timer = self.netTimer;
          if (timer) {
              timer.clear();
              self.netTimer = null;
          }
      }
      onProgress(value) {
          let self = this;
          self.setValue(1, value);
          value >= 0.95 && self.initTimer();
      }
      setValue(key, value) {
          let self = this;
          self.util.setValue(key, value);
          self.updateBar();
      }
      updateBar() {
          let self = this, value = self.util.value;
          self.bar.width = value * 977;
          self.bar1.x = 165 + self.bar.width;
          let str;
          if (UserData.instance.isNewPlayer) {
              str = '' + (value * 100).toFixed(0) + '%';
          }
          else {
              str = '加载中，请稍等...' + (value * 100).toFixed(0) + '%';
          }
          self.txt.changeText(str);
          if (value >= 1) {
              EventMgr.event(EventType.LoadingSuc);
          }
      }
      onLoadError() {
          this.txt.color = '#FF0000';
          this.txt.text = '加载失败，请确保网络正常，退出游戏重试';
      }
  }

  class GameConfig {
      constructor() { }
      static init() {
          var reg = Laya.ClassUtils.regClass;
          reg("script/ui/AK_Gold_ef.ts", AK_Gold_ef);
          reg("script/ui/GameCountdown_ani.ts", GameCountdown_ani);
          reg("script/ui/HeadShot_ef.ts", HeadShot_ef);
          reg("script/ui/KillFont_ef.ts", KillFont_ef);
          reg("script/ui/Ready_ani.ts", Ready_ani);
          reg("script/ui/xianshilingqu_ef.ts", xianshilingqu_ef);
          reg("script/ui/XS_arrow2_ani.ts", XS_arrow2_ani);
          reg("script/ui/HouseBagItem.ts", HouseBagItem);
          reg("script/ui/LoadingUI.ts", LoadingUI);
      }
  }
  GameConfig.width = 1334;
  GameConfig.height = 750;
  GameConfig.scaleMode = "exactfit";
  GameConfig.screenMode = "horizontal";
  GameConfig.alignV = "middle";
  GameConfig.alignH = "center";
  GameConfig.startScene = "view/LogoView.scene";
  GameConfig.sceneRoot = "";
  GameConfig.debug = false;
  GameConfig.stat = false;
  GameConfig.physicsDebug = false;
  GameConfig.exportSceneToJson = true;
  GameConfig.init();

  const isWx$1 = typeof wx !== 'undefined';
  class AldPlatform {
      static aldSendEvent(eventName, defaultData = null, params = null) {
          if (isWx$1) {
          }
          else {
          }
      }
      static getNewName() {
          return '';
      }
      static resetUser() {
          AldPlatform.$newName = null;
      }
      static aldStageStart(level) {
          if (typeof wx == 'undefined' || wx['aldStage'] == null)
              return;
          let data = {};
          data['stageId'] = '' + level;
          data['stageName'] = '第' + level + '关';
          data['userId'] = UserData.instance.getAccontId();
          wx['aldStage'].onStart(data);
      }
      static aldStageRunning(event, params) { }
      static aldStageEnd(level, clear) {
          if (typeof wx == 'undefined' || wx['aldStage'] == null)
              return;
          let data = {};
          data['stageId'] = level + '';
          data['stageName'] = '第' + level + '关';
          data['event'] = clear ? 'complete' : 'fail';
          data['userId'] = UserData.instance.getAccontId();
          data['params'] = {
              desc: clear ? '关卡完成' : '关卡失败'
          };
          wx['aldStage'].onEnd(data);
      }
      static getLoadTime() {
          return AldPlatform.homeTime - AldPlatform.loadingTime;
      }
  }

  class XS_arrow2_ani$1 extends ui.Ani.XS_arrow2_aniUI {
      constructor() {
          super();
          this._complete = false;
      }
      onAwake() {
          this.visible = false;
      }
      setVisible(isVisible) {
          if (isVisible) {
              this.visible = true;
              this.ani1.play(0, true);
          }
          else {
              this.visible = false;
              this.ani1.stop();
          }
      }
  }

  var Sprite = Laya.Sprite;
  var HitArea = Laya.HitArea;
  class GuideMgr {
      constructor() {
          this.guideSteps = [];
          this.guideStep = -1;
          this._point = new Laya.Point();
      }
      static get instance() {
          if (GuideMgr._instance == null) {
              GuideMgr._instance = new GuideMgr();
          }
          return GuideMgr._instance;
      }
      init() {
          if (!this.clickContainer) {
              this.clickContainer = new Laya.Sprite();
              Laya.stage.addChild(this.clickContainer);
              this.clickContainer.size(Laya.stage.width, Laya.stage.height);
              this.clickContainer.zOrder = UIMgr._tZOrder - 2;
              this.guideContainer = new Sprite();
              this.guideContainer.cacheAs = 'bitmap';
              Laya.stage.addChild(this.guideContainer);
              this.guideContainer.zOrder = UIMgr._tZOrder - 1;
              let maskArea = new Sprite();
              maskArea.alpha = 0.5;
              maskArea.graphics.drawRect(0, 0, Laya.stage.width, Laya.stage.height, '#000000');
              this.guideContainer.addChild(maskArea);
              this.interactionArea = new Sprite();
              this.interactionArea.blendMode = 'destination-out';
              this.guideContainer.addChild(this.interactionArea);
              this.hitArea = new HitArea();
              this.hitArea.hit.drawRect(0, 0, Laya.stage.width, Laya.stage.height, '#000000');
              this.guideContainer.hitArea = this.hitArea;
              this.guideContainer.mouseEnabled = true;
              this.tipWordsContainer = new Laya.Box();
              this.guideContainer.addChild(this.tipWordsContainer);
              this.tipWordsContainer.width = 281;
              this.tipWordsContainer.height = 103;
              this.tipWordsContainer.anchorX = this.tipWordsContainer.anchorY = 1;
              let tipsBg = new Laya.Image();
              this.tipWordsContainer.addChild(tipsBg);
              tipsBg.width = 185;
              tipsBg.height = 68;
              tipsBg.scaleX = tipsBg.scaleY = 1.5;
              tipsBg.skewY = 180;
              tipsBg.x = 281;
              tipsBg.loadImage('xIndex/duihuakuang.png');
              this.tipWords = new Laya.Label();
              this.tipWordsContainer.addChild(this.tipWords);
              this.tipWords.color = '#ffffff';
              this.tipWords.fontSize = 20;
              this.tipWords.wordWrap = true;
              this.tipWords.x = 26;
              this.tipWords.y = 4;
              this.tipWords.width = 200;
              this.tipWords.height = 60;
              this.tipWords.overflow = 'hidden';
              this.tipWords.align = 'center';
              this.tipWords.valign = 'middle';
              this.tipWordsClick = new Laya.Label();
              this.tipWordsContainer.addChild(this.tipWordsClick);
              this.tipWordsClick.color = '#fff400';
              this.tipWordsClick.bold = true;
              this.tipWordsClick.fontSize = 27;
              this.tipWordsClick.underline = true;
              this.tipWordsClick.width = 111;
              this.tipWordsClick.height = 29;
              this.tipWordsClick.x = 193;
              this.tipWordsClick.y = 78;
              this.tipWordsClick.text = '立即领取';
              this.tipWordsClick.anchorX = this.tipWordsClick.anchorY = 0.5;
              this.tipWordsContainer1 = new Laya.Box();
              this.guideContainer.addChild(this.tipWordsContainer1);
              this.tipWordsContainer1.width = 281;
              this.tipWordsContainer1.height = 103;
              this.tipWordsContainer1.anchorX = this.tipWordsContainer1.anchorY = 1;
              let tipsBg1 = new Laya.Image();
              this.tipWordsContainer1.addChild(tipsBg1);
              tipsBg1.width = 185;
              tipsBg1.height = 68;
              tipsBg1.scaleX = tipsBg1.scaleY = 1.5;
              tipsBg1.skewY = 180;
              tipsBg1.x = 281;
              tipsBg1.loadImage('xIndex/duihuakuang.png');
              this.tipWords1 = new Laya.Label();
              this.tipWordsContainer1.addChild(this.tipWords1);
              this.tipWords1.color = '#ffffff';
              this.tipWords1.fontSize = 20;
              this.tipWords1.align = 'center';
              this.tipWords1.valign = 'middle';
              this.tipWords1.wordWrap = true;
              this.tipWords1.anchorX = this.tipWords1.anchorY = 0.5;
              this.tipWords1.x = 140;
              this.tipWords1.y = 51;
              this.tipWords1.width = 200;
              this.tipWords1.height = 60;
              this.guideAni = new XS_arrow2_ani$1();
              this.guideContainer.addChild(this.guideAni);
          }
          this.showGuide(false);
          this.guideStep = -1;
          this.guideSteps.length = 0;
      }
      nextStep() {
          let step = this.guideSteps[this.guideStep];
          this.hitArea.unHit.clear();
          switch (step.drawType) {
              case 0:
                  this.hitArea.unHit.drawCircle(step.x, step.y, step.radius, '#000000');
                  break;
              case 1:
                  this.hitArea.unHit.drawRect(step.x - step.width / 2, step.y - step.height / 2, step.width, step.height, '#000000');
                  break;
          }
          this.interactionArea.graphics.clear();
          switch (step.drawType) {
              case 0:
                  this.interactionArea.graphics.drawCircle(step.x, step.y, step.radius, '#000000');
                  break;
              case 1:
                  this.interactionArea.graphics.drawRect(step.x - step.width / 2, step.y - step.height / 2, step.width, step.height, '#000000');
                  break;
          }
          this.guideAni.setVisible(true);
          this.guideAni.pos(step.x, step.y);
          switch (step.tipsDir) {
              case 0:
                  this.guideAni.rotation = 0;
                  break;
              case 1:
                  this.guideAni.rotation = -90;
                  break;
              case 2:
                  this.guideAni.rotation = -180;
                  break;
              case 3:
                  this.guideAni.rotation = -270;
                  break;
          }
          this.clickContainer.offAll();
          if (step.callBack) {
              this.clickContainer.on(Laya.Event.CLICK, this, this.onClick);
          }
      }
      onClick() {
          this.showGuide(false);
          let step = this.guideSteps[this.guideStep];
          this.guideAni.setVisible(false);
          this.clickContainer.offAll();
          if (step.tips) {
              this.tipWords1.text = step.tips;
              this.tipWordsContainer1.pos(step.x - 100, step.y - 50);
              this.guideContainer.visible = this.tipWordsContainer1.visible = true;
              this.clickContainer.mouseEnabled = true;
              this.clickContainer.visible = true;
              if (step.callBack) {
                  if (step.argArray === void 0) {
                      step.callBack.call(step.scope);
                  }
                  else {
                      step.callBack.call(step.scope, step.argArray);
                  }
              }
          }
          else if (step.ClickTips) {
              this.tipWords.text = step.ClickTips;
              this.tipWordsContainer.pos(step.x - 50, step.y - 80);
              this.guideContainer.visible = this.tipWordsContainer.visible = true;
              this.clickContainer.mouseEnabled = true;
              this.clickContainer.visible = true;
              this.setTipsClick();
          }
          else {
              if (step.callBack) {
                  if (step.argArray === void 0) {
                      step.callBack.call(step.scope);
                  }
                  else {
                      step.callBack.call(step.scope, step.argArray);
                  }
              }
          }
      }
      setTipsClick() {
          this._point.setTo(0, 0);
          this.tipWordsClick.localToGlobal(this._point);
          this._point.setTo(this._point.x + this.tipWordsClick.width / 2, this._point.y + this.tipWordsClick.height / 2);
          this.hitArea.unHit.clear();
          this.hitArea.unHit.drawCircle(this._point.x, this._point.y, 50, '#000000');
          this.interactionArea.graphics.clear();
          this.interactionArea.graphics.drawCircle(this._point.x, this._point.y, 50, '#000000');
          this.guideAni.setVisible(true);
          this.guideAni.pos(this._point.x, this._point.y);
          this.guideAni.rotation = 0;
          this.clickContainer.offAll();
          this.clickContainer.on(Laya.Event.CLICK, this, this.onTipsClickCallBack);
      }
      onTipsClickCallBack() {
          this.showGuide(false);
          let step = this.guideSteps[this.guideStep];
          if (step.callBack) {
              if (step.argArray === void 0) {
                  step.callBack.call(step.scope);
              }
              else {
                  step.callBack.call(step.scope, step.argArray);
              }
          }
      }
      closeOneContainer(type) {
          let self = this;
          switch (type) {
              case 2:
                  self.tipWordsContainer.visible = false;
                  break;
              case 3:
                  self.clickContainer.visible = false;
                  break;
          }
      }
      closeGuide() {
          this.guideContainer && (this.guideContainer.visible = false);
          if (UserData.instance.isGuide) {
              UserData.instance.isGuide = false;
              DataMgr.instance.isGuideFirstGame = true;
          }
      }
      showGuide(isVisible) {
          this.guideContainer.visible = isVisible;
          this.clickContainer.visible = isVisible;
          this.tipWordsContainer.visible = false;
          this.tipWordsContainer1.visible = false;
      }
      setGuideInfo(info) {
          let self = this;
          Laya.timer.frameOnce(2, self, function () {
              self.guideStep++;
              self._point.setTo(0, 0);
              info.btn.localToGlobal(self._point);
              if (!info.radius) {
                  info.radius = 100;
              }
              if (!info.drawType) {
                  info.drawType = 0;
              }
              if (!info.tipsDir) {
                  info.tipsDir = 0;
              }
              info.x = self._point.x + (info.btn.width / 2) * info.btn.scaleX;
              info.y = self._point.y + (info.btn.height / 2) * info.btn.scaleY;
              if (!info.width) {
                  info.width = info.btn.width * info.btn.scaleX;
              }
              if (!info.height) {
                  info.height = info.btn.height * info.btn.scaleY;
              }
              self.guideSteps.push(info);
              self.showGuide(true);
              if (info.tips1) {
                  this.tipWords1.text = info.tips1;
                  this.tipWordsContainer1.pos(info.x - 100, info.y - 50);
                  this.tipWordsContainer1.visible = true;
              }
              self.nextStep();
              if (info.showCall) {
                  info.showCall.call(info.scope);
              }
          });
      }
  }

  class BaseState {
      onEnter(player) { }
      onRuning(player) { }
      onExit(player) { }
      counterAttack() { }
  }

  class BaseSkill extends Laya.Script3D {
      constructor(player) {
          super();
          this._player = player;
          this.checkSkill();
      }
      onAwake() {
          super.onAwake();
      }
      checkSkill() {
          this.cfg = this._player.skillCfg;
          let ownPos = this._player.transform.position;
          let targetPos = this._player.curTarget.transform.position;
          let attackDis = this._player.aiCfg.aiAttackRange;
          let enemyMinDis = 100;
          let curEnemyDis = 0;
          let enemyCnt = 0;
          if (this._player.checkResidue(this.cfg.aiSkillAmmo)) {
              if (Laya.Vector3.distance(ownPos, targetPos) <= this.cfg.aiSkillTargetDistance) {
                  if (this._player.curTarget.speed < this.cfg.aiSkillTargetSpeed) {
                      this.skillComplete();
                      return;
                  }
                  let isEnemy = this.cfg.aiSkillTarget == 1;
                  let enemyArr;
                  let playerArr;
                  if (isEnemy) {
                      enemyArr =
                          this._player.getCamp() == PlayerCamp.Enemy
                              ? DataMgr.instance._players
                              : DataMgr.instance._enemys;
                      playerArr =
                          this._player.getCamp() == PlayerCamp.Teammate
                              ? DataMgr.instance._players
                              : DataMgr.instance._enemys;
                  }
                  else {
                      enemyArr =
                          this._player.getCamp() == PlayerCamp.Teammate
                              ? DataMgr.instance._players
                              : DataMgr.instance._enemys;
                  }
                  for (let i = 0, len = enemyArr.length; i < len; i++) {
                      let player = enemyArr[i];
                      curEnemyDis = Laya.Vector3.distance(player.transform.position, targetPos);
                      if (curEnemyDis <= enemyMinDis) {
                          enemyMinDis = curEnemyDis;
                      }
                      if (Laya.Vector3.distance(player.transform.position, ownPos) <= attackDis) {
                          enemyCnt++;
                      }
                  }
                  if (playerArr) {
                      let playerCnt = 0;
                      for (let i = 0, len = playerArr.length; i < len; i++) {
                          let player = playerArr[i];
                          if (Laya.Vector3.distance(player.transform.position, ownPos) <= attackDis) {
                              playerCnt++;
                          }
                      }
                      let ratio = playerCnt > 0 ? enemyCnt / playerCnt : enemyCnt;
                      if (ratio < this.cfg.aiSkillEnemyByCompany)
                          return;
                  }
                  if (enemyCnt >= this.cfg.aiSkillEnemyCount &&
                      enemyMinDis <= this.cfg.aiSkillTargetCompanyDistance) {
                      Laya.timer.callLater(this, this.startSkill);
                      return;
                  }
              }
          }
          this.skillComplete();
      }
      startSkill() {
          console.info('基类：startSkill');
      }
      skillComplete() {
          let self = this;
          Laya.timer.frameOnce(1, self, function () {
              if (self._player) {
                  self._player.curSkillTime = DataMgr.nowTime + self._player.aiCfg.aiSkillIntervalTime * 1000;
                  self._player.skillCom = null;
                  self._player = null;
                  self.destroy();
              }
          });
      }
  }

  class ComSkill extends BaseSkill {
      constructor(player) {
          super(player);
          this._vec = new Laya.Vector3();
          this._skillTime = 1000;
          this._targetPos = new Laya.Vector3();
          this._isStart = false;
      }
      onUpdate() {
          if (!DataMgr.instance.isGamming())
              return;
          let self = this;
          if (this._player && !this._player.isDead) {
              if (this._isStart) {
                  this._player.transform.lookAt(this._targetPos, Vector3Ex.Up, false);
                  if (this._skillTime < DataMgr.nowTime) {
                      let cfg = this._player.skillCfg;
                      if (cfg.aiSkillID == 109) {
                          this._bomb.startUse(self._player, self._player.gun.gunCfg);
                      }
                      else {
                          this._bomb.aiStartBomb(self._player, this._targetPos, cfg.aiSkillAmmo);
                      }
                      self.skillComplete();
                  }
              }
          }
          else {
              self.skillComplete();
          }
      }
      startSkill() {
          let cfg = this._player.skillCfg;
          let self = this;
          this._player.gun.gameObject.active = false;
          this._player.setRoleAni(AniType.Throw_start);
          if (cfg.aiSkillID == 102 || cfg.aiSkillID == 103) {
              let players = self._player.getCamp() == PlayerCamp.Enemy
                  ? DataMgr.instance._enemys
                  : DataMgr.instance._players;
              let index = 0;
              let curDis = 100;
              for (let i = 0, len = players.length; i < len; i++) {
                  let player = players[i];
                  if (player.getPlayerId() == self._player.getPlayerId()) {
                      continue;
                  }
                  if (player.isDead)
                      continue;
                  let dis = Laya.Vector3.distance(self._player.transform.position, player.transform.position);
                  if (dis < curDis) {
                      curDis = dis;
                      index = i;
                  }
              }
              players[index].transform.position.cloneTo(this._targetPos);
          }
          else {
              if (self._player.curTarget) {
                  self._player.curTarget.transform.position.cloneTo(this._targetPos);
              }
              else {
                  self.skillComplete();
                  return;
              }
          }
          if (cfg.aiSkillID == 109) {
              this._bomb = PropMgr.instance.getProp(PropType.BombPlacement, 'BombPlacement');
          }
          else {
              this._bomb = PropMgr.instance.getProp(PropType.Bomb, 'Bomb');
          }
          this._player.gun.parentTr.owner.addChild(this._bomb.gameObject);
          Utils.vec3ToTargetVal('localPosition', 1, this._bomb.gameObject);
          Laya.timer.once(cfg.aiSkillReadyTime * 1000, self, function () {
              let ownPos = self._player.transform.position;
              let pos = self._bomb.transform.position;
              pos.cloneTo(self._vec);
              SceneMgr.instance.addChildToProp(self._bomb.gameObject);
              self._vec.cloneTo(pos);
              self._bomb.transform.position = pos;
              self._player.setRoleAni(AniType.Throw_end);
              self._skillTime = cfg.aiSkillRlessTime * 1000 + DataMgr.nowTime;
              self._isStart = true;
          });
      }
      skillComplete() {
          this._vec = null;
          this._isStart = false;
          this._player.gun.gameObject.active = true;
          super.skillComplete();
      }
  }

  class RocketSkill extends BaseSkill {
      constructor(player, type) {
          super(player);
          this._changGunTime = 0;
          this._switchTime = 0;
          this._isStart = false;
          this._aiSkillReadyTime = 0;
          this._isUse = false;
          this._isRest = false;
          this._vec = new Laya.Vector3();
          this._type = type;
      }
      onUpdate() {
          if (!DataMgr.instance.isGamming())
              return;
          let self = this;
          if (this._isStart) {
              if (this._isUse) {
                  if (this._aiSkillReadyTime == 0) {
                      this._aiSkillReadyTime = this.cfg.aiSkillReadyTime + DataMgr.nowTime;
                  }
                  else if (this._aiSkillReadyTime < DataMgr.nowTime) {
                      DataMgr.instance.playCfgSound(this._sound, this._player.transform.position);
                      if (this._type == 1) {
                          let rocket = PropMgr.instance.getProp(PropType.Rocket, 'Rocket');
                          this._player.gun.launchTf.getForward(this._vec);
                          rocket.setAITarget(this._player, this._player.gun.launchTf.position, this._vec, this._player.gun.gunCfg, this._player.curTarget.transform.position);
                      }
                      else {
                          let rocket = PropMgr.instance.getProp(PropType.Missile, 'Missile');
                          this._player.gun.launchTf.getForward(this._vec);
                          rocket.setTarget(this._player, this._player.curTarget, this._player.gun.launchTf.position, this._vec, this._player.gun.gunCfg);
                      }
                      this.setSwitchGun(2);
                      this._isStart = true;
                      this._isUse = false;
                      this._isRest = true;
                  }
              }
              else {
                  if (DataMgr.nowTime > this._changGunTime && this._changGunTime > 0) {
                      this._changGunTime = 0;
                      if (this._isRest) {
                          this._player.switchGunSucc(2);
                          this._isStart = false;
                          Laya.timer.once(this.cfg.aiSkillRlessTime, this, function () {
                              self.skillComplete();
                          });
                      }
                      else {
                          this._player.switchGunSucc(1);
                      }
                  }
                  if (DataMgr.nowTime > this._switchTime) {
                      this._isUse = true;
                  }
              }
          }
          if (this._player && !this._player.isDead) {
              this._player.transform.lookAt(this._player.curTarget.transform.position, Vector3Ex.Up, false);
          }
          else {
              self.skillComplete();
          }
      }
      _sound(_sound, position) {
          throw new Error('Method not implemented.');
      }
      startSkill() {
          if (this._player.isUseVeh && this._player.curTarget.isUseVeh) {
              this._sound = this._player.gun.gunCfg.soundEffectFire;
              this._isVeh = this._player.isUseVeh;
              this.setSwitchGun(1);
              this._isStart = true;
          }
          else {
              this.skillComplete();
          }
      }
      setSwitchGun(index) {
          this._player.setRoleAni(this._player.gun.gunCfg.swith_action);
          this._player.gun.isCanFire = false;
          let cfg = this._player.getNextGunCfg(index);
          this._switchTime = cfg.gunSwitchTime;
          this._changGunTime = this._switchTime / 4 + DataMgr.nowTime;
          this._switchTime += DataMgr.nowTime;
      }
      skillComplete() {
          this._aiSkillReadyTime = 0;
          this._isUse = false;
          this._isStart = false;
          this._isRest = false;
          super.skillComplete();
      }
  }

  class StrafingSkill extends BaseSkill {
      constructor(player) {
          super(player);
          this._isStart = false;
          this._curRotY = 0;
          this._time = 100;
          this._skillCD = 1000;
          this._isRight = true;
      }
      onUpdate() {
          if (!DataMgr.instance.isGamming())
              return;
          if (this._isStart) {
              if (this._player && !this._player.isDead) {
                  if (this._skillCD < DataMgr.nowTime) {
                      this.skillComplete();
                  }
                  if (this._isRight) {
                      this._player.transform.localRotationEulerY > this._curRotY + 30 &&
                          (this._isRight = false);
                  }
                  else {
                      this._player.transform.localRotationEulerY < this._curRotY - 30 && (this._isRight = true);
                  }
                  this._player.transform.localRotationEulerY += this._isRight ? 1 : -1;
              }
              else {
                  this.skillComplete();
              }
          }
      }
      startSkill() {
          let self = this;
          if (this._player.curTarget) {
              this._player.transform.lookAt(this._player.curTarget.transform.position, Vector3Ex.Up, false);
          }
          Laya.timer.once(this.cfg.aiSkillReadyTime, this, function () {
              self._isStart = true;
              self._player.gun._attackCnt = 1000000000;
              self._curRotY = self._player.transform.localRotationEulerY;
              self._player.gun.setFiring(true);
              self._skillCD = self.cfg.aiSkillRlessTime * 1000 + DataMgr.nowTime;
          });
      }
      skillComplete() {
          Tween.clear(this._player.transform);
          super.skillComplete();
      }
  }

  var Ray$4 = Laya.Ray;
  var HitResult$4 = Laya.HitResult;
  var Vector3$g = Laya.Vector3;
  class AttackState extends BaseState {
      constructor() {
          super();
          this._nextAttack = 0;
          this._frameCnt = 0;
          this._maxStandTime = 10000;
          this._curStandTime = 100;
          this._randomTime = 200;
          this._rateIndex = 0;
          this._vec = new Laya.Vector3();
          this._dirArr = [];
          this._isBeginMove = false;
          this._moveTime = 0;
      }
      onEnter(player) {
          if (!player.isRolePlayer()) {
              this._aiAttackTimeIntervals = 1000 * player.aiCfg.aiAttackTimeIntervals;
              let time = player.aiCfg.aiTargetDelay;
              this._nextAttack += time * 1000 + DataMgr.nowTime;
              player.setRoleAni(player.gun.gunCfg.stand_action);
              this._curStandTime = DataMgr.nowTime + this._maxStandTime;
              player.curSkillTime = DataMgr.nowTime + player.skillCD;
              this._player = player;
              if (!this._ray) {
                  this._ray = new Ray$4(new Vector3$g(0, 0, 0), new Vector3$g(0, 0, 0));
                  this._result = new HitResult$4();
              }
              this._isBeginMove = false;
              this._curDir = -1;
              this._collisonGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
              if (player.getCamp() == PlayerCamp.Teammate) {
                  this._collisionWith =
                      Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                          Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2;
              }
              else {
                  this._collisionWith =
                      Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                          Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3;
              }
          }
          else {
              this._rateIndex = CfgDataMgr.instance.getGlobalCfg('cursorStickyTestRate');
          }
      }
      onRuning(player) {
          if (!player.isRolePlayer()) {
              if (Utils.isEmpty(player.curTarget) || player.curTarget.isDead) {
                  player.fsm.changeState(FSMState.FindPath);
                  return;
              }
              if (player.skillCom) {
                  player.skillCom.onUpdate();
                  return;
              }
              if (DataMgr.nowTime > player.curSkillTime) {
                  player.curSkillTime = DataMgr.nowTime + player.skillCD;
                  this.useSkill(player);
              }
              else {
                  if (this._nextAttack > 0 && DataMgr.nowTime >= this._nextAttack) {
                      player.transform.lookAt(player.curTarget.transform.position, Vector3Ex.Up, false);
                      this._nextAttack =
                          DataMgr.nowTime + this._aiAttackTimeIntervals + Math.random() * this._randomTime;
                      if (Laya.Vector3.distance(player.transform.position, player.curTarget.transform.position) >
                          player.aiCfg.aiAttackRange) {
                          player.fsm.changeState(FSMState.FindPath);
                          return;
                      }
                      else {
                          player.setRoleAni(player.gun.gunCfg.stand_action, 0);
                          this.aiFire(player);
                          this._moveTime = DataMgr.nowTime + 200;
                      }
                      this._isBeginMove = false;
                  }
                  else {
                      if (this._curStandTime < DataMgr.nowTime) {
                          if (!player.gun.checkCanAttack()) {
                              player.fsm.changeState(FSMState.FindPath);
                          }
                          else {
                              this._curStandTime = DataMgr.nowTime + this._maxStandTime;
                          }
                      }
                  }
              }
          }
          else {
              this._frameCnt++;
              if (this._frameCnt > this._rateIndex && player.gun) {
                  let isAim = player.gun.checkAim();
                  EventMgr.event(EventType.AimShow, isAim);
                  DataMgr.instance.isViscous = isAim;
                  this._frameCnt -= this._rateIndex;
                  if (isAim && DataMgr.instance.isShowDailySkill) {
                      DataMgr.instance.isShowDailySkill = false;
                      Laya.timer.once(100, this, function () {
                          UIMgr.openUI(EUI.DailyKillView);
                      });
                  }
              }
          }
      }
      onExit(player) {
          player.gun && player.gun.setFiring(false);
          this._nextAttack = 0;
          this._frameCnt = 0;
          this._curStandTime = 100;
          player.skillCom && player.skillCom.destroy();
          player.skillCom = null;
      }
      aiFire(player) {
          if (DataMgr.instance.isTestAttack) {
              if (player.curTarget.isDead)
                  return;
              player.gun.setAttackCnt();
              player.gun.setFiring(true);
          }
      }
      useSkill(player) {
          let random = Math.random();
          let curRandom = 0;
          let curSkillID = 0;
          for (let i = 1; i <= 3; i++) {
              let arr = player.aiCfg['aiSkill' + i];
              if (arr.length <= 0)
                  continue;
              curRandom += arr[1];
              if (curRandom > random) {
                  curSkillID = arr[0];
                  break;
              }
          }
          if (curSkillID) {
              player.skillCfg = CfgDataMgr.instance.aiSkillsCfg[curSkillID];
              switch (curSkillID) {
                  case 101:
                  case 102:
                  case 103:
                  case 109:
                      player.skillCom = new ComSkill(player);
                      break;
                  case 104:
                      break;
                  case 105:
                      player.skillCom = new RocketSkill(player, 1);
                      break;
                  case 106:
                      player.skillCom = new RocketSkill(player, 2);
                      break;
                  case 107:
                      player.skillCom = new StrafingSkill(player);
                      break;
                  case 108:
                      break;
              }
          }
      }
      counterAttack() {
          this._player.curTarget = this._player.attacker;
      }
      randomWalk() {
          return;
          if (Utils.isIPhone())
              return;
          let self = this;
          this._isBeginMove = true;
          this._dirArr.length = 0;
          this._curDir = -1;
          let random = Math.random();
          if (random < 0.5)
              return;
          let origin = this._ray.origin;
          let direction = this._ray.direction;
          this._player.transform.position.cloneTo(this._vec);
          let func = function (attribute, val, index) {
              self._player.transform[attribute](self._vec);
              self._vec.cloneTo(direction);
              self._ray.direction = direction;
              self._player.transform.position.cloneTo(self._vec);
              self._vec.cloneTo(origin);
              self._ray.origin = origin;
              DataMgr.instance.scene.physicsSimulation.rayCast(self._ray, self._result, 10, self._collisonGroup, self._collisionWith);
              if (!self._result.succeeded) {
                  Vector3Ex.Down.cloneTo(direction);
                  self._ray.direction = direction;
                  DataMgr.instance.scene.physicsSimulation.rayCast(self._ray, self._result, 10, self._collisonGroup, self._collisionWith);
                  if (self._result.succeeded && self._result.collider.owner.name == 'NavMesh') {
                      self._dirArr.push(index);
                  }
              }
          };
          let arr = [0, 1, 2, 3];
          Utils.randomSort(arr);
          for (let i = 0; i < 2; i++) {
              switch (arr[i]) {
                  case 0:
                      func('getForward', 5, 0);
                      break;
                  case 1:
                      func('getForward', -5, 1);
                      break;
                  case 2:
                      func('getRight', 5, 2);
                      break;
                  case 3:
                      func('getRight', -5, 3);
                      break;
              }
          }
          if (this._dirArr.length > 0) {
              this._curDir = this._dirArr[(this._dirArr.length * Math.random()) | 0];
          }
      }
      walk() {
          if (this._curDir == -1)
              return;
          if (this._curDir == 4) {
              this._player.transform.translate(this._vec, false);
          }
          else {
              let aniName;
              switch (this._curDir) {
                  case 0:
                      aniName = 'Forward';
                      this._player.transform.getForward(this._vec);
                      break;
                  case 1:
                      aniName = 'Backward';
                      this._player.transform.getForward(this._vec);
                      Laya.Vector3.scale(this._vec, -1, this._vec);
                      break;
                  case 2:
                      aniName = 'Right';
                      this._player.transform.getRight(this._vec);
                      break;
                  case 3:
                      aniName = 'Left';
                      this._player.transform.getRight(this._vec);
                      Laya.Vector3.scale(this._vec, -1, this._vec);
                      break;
              }
              this._player.setRoleAni(aniName, 0);
              Laya.Vector3.scale(this._vec, 0.01, this._vec);
              this._curDir = 4;
          }
      }
  }

  class DeadState extends BaseState {
      onEnter(player) {
          if (player.isRolePlayer()) {
              DataMgr.instance.role.roleCtrl.stop();
              DataMgr.instance.cameraCtrl.reviveInit();
          }
          if (!player.isFindPathDead) {
              ModeMgr.instance.setScore(player.getCamp() == PlayerCamp.Teammate);
              if (player.attacker.isRolePlayer()) {
                  DataMgr.instance.roleHitCnt++;
              }
          }
          if (player.isUseVeh) {
              player._veh.playDeadAni();
              if (player.isRolePlayer()) {
                  UmengPlatform.trackEvent('jiesuan', {
                      shuju: '载具被毁'
                  });
              }
              else if (player.attacker.isRolePlayer()) {
                  UmengPlatform.trackEvent('jiesuan', {
                      shuju: '摧毁载具'
                  });
              }
          }
          else {
              if (player.deadType == 0) {
                  player.setRoleAni(player.hurtPart == PlayerPart.Head
                      ? AniType.Dead1
                      : player.hurtPart == PlayerPart.Body
                          ? AniType.Dead2
                          : AniType.Dead3);
              }
              else if (player.deadType == 1) {
                  player.setRoleAni(AniType.Dead4);
              }
              else if (player.deadType == 2) {
                  player.setRoleAni(AniType.Dead4);
              }
              let sound = ['Death_Male_01', 'Death_Male_02', 'Death_Male_03'];
              DataMgr.instance.playCfgSound(sound[(Math.random() * sound.length) | 0], player.transform.position);
          }
          this._clearTime = DataMgr.nowTime + DeadState.CLEAR_TIME;
          EventMgr.event(EventType.CheckResult, false);
      }
      onRuning(player) {
          if (this._clearTime > 0 && DataMgr.nowTime >= this._clearTime) {
              this._clearTime = 0;
              player.stopAI();
              if (player.isRolePlayer() == false) {
                  player.checkVehClear();
                  EventMgr.event(EventType.RecoverPlayer, player);
                  player.recover();
                  Utils.removeArrayObj(DataMgr.instance[player.getCamp() == PlayerCamp.Teammate ? '_players' : '_enemys'], player);
              }
              else {
                  player.roleHp = 0;
                  player._curAmmo = new Object();
              }
              player._deadHandler && player._deadHandler.run();
              player._deadHandler = null;
          }
      }
      onExit(player) {
          this._clearTime = 0;
      }
  }
  DeadState.CLEAR_TIME = 1300;

  class FindPathState extends BaseState {
      constructor() {
          super();
          this._findSize = 10;
          this._vec = new Laya.Vector3();
          this._forwardVec = new Laya.Vector3();
          this._tempVec = new Laya.Vector3();
          this._targetPos = new Laya.Vector3();
          this._outHitInfoArr = [];
          this._isNavMeshPath = true;
          this._frameCnt = 0;
          this._aiTargeAngleInterval = 30;
          this._aiAttackAngleInterval = 30;
          this._randomTime = 100;
          this._findMaxTime = 3000;
          this._curMeshPathArr = [];
          this._curMeshPathIndex = 0;
          this._jsonCnt = 6;
          this._pathJsonIndex = 1;
          this._pathAarrIndex = 0;
          this._pathPointIndex = 0;
          this._isWaitData = false;
          this._failCnt = 0;
          this.maxFailCnt = 3;
          this.findInterval = 5;
      }
      onEnter(player) {
          let self = this;
          this.clear();
          this._curFindTime = 1111111 + Laya.timer.currTimer;
          if (!this._player) {
              this._ray = new Laya.Ray(new Laya.Vector3(0, 0, 0), new Laya.Vector3(0, -1, 0));
          }
          this._player = player;
          this._modelTr = player.transform;
          player.speed = player.aiCfg.aiMoveSpeed;
          this._findSize = player.aiCfg.aiTargetRange;
          this._aiAttackAngleInterval = player.aiCfg.aiAttackAngleInterval;
          this._aiTargeAngleInterval = player.aiCfg.aiTargeAngleInterval;
          let roleMoveActionRateRange = CfgDataMgr.instance.getGlobalCfg('roleMoveActionRateRange');
          let roleMoveSpeedRateRange = CfgDataMgr.instance.getGlobalCfg('roleMoveSpeedRateRange');
          player.aniSpeed =
              ((roleMoveActionRateRange[1] - roleMoveActionRateRange[0]) /
                  (roleMoveSpeedRateRange[1] - roleMoveSpeedRateRange[0])) *
                  (player.speed - roleMoveSpeedRateRange[0]) +
                  roleMoveActionRateRange[0];
          this._player.curTarget = null;
          let frameIndex = 2;
          if (!DataMgr.instance.isGameAiMove) {
              frameIndex = 3 + this._player.getPlayerId() * 2;
          }
          Laya.timer.frameOnce(frameIndex, this, function () {
              self.findPathPoint(false);
              player.setRoleAni(player.gun.gunCfg.run_action);
              self._isWaitData = false;
              if (!DataMgr.instance.isGameAiMove) {
                  let addTime = self._player.getCamp() == PlayerCamp.Enemy ? 300 : 1000;
                  self._curFindTime = DataMgr.nowTime + 10 * 1000 + addTime;
              }
              else {
                  self._curFindTime =
                      DataMgr.nowTime + DataMgr.instance.findEnemyTime + Math.random() * self._randomTime;
              }
          });
          player.setRoleAni(player.gun.gunCfg.run_action);
      }
      onRuning(player) {
          if (this._curFindTime < DataMgr.nowTime) {
              this.findEnemy();
              this._frameCnt = 0;
          }
          this.attackFrame(player);
          if (this._isWaitData) {
              return;
          }
          let tr = player.transform;
          this._targetPos.y = DataMgr.instance.roleHeight;
          tr.getForward(this._forwardVec);
          Laya.Vector3.scale(this._forwardVec, player.getMoveVal(player.speed * DataMgr.FixedDeltaTime * 1000), this._forwardVec);
          if (Laya.Vector3.distance(tr.position, this._targetPos) <=
              Laya.Vector3.scalarLength(this._forwardVec)) {
              Utils.vec3ToTargetVal('position', 1, tr.owner, this._targetPos);
              if (!this._player.curTarget && this._curMeshPathArr.length > 0) {
                  this._curMeshPathIndex++;
                  if (this._curMeshPathIndex >= this._curMeshPathArr.length) {
                      this._curMeshPathIndex = 0;
                      this.findPathPoint(true);
                  }
                  else {
                      this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                      this._targetPos.cloneTo(this._player.navMeshPos);
                  }
              }
              else {
                  if (this._player.curTarget) {
                      this._player.curTarget.transform.position.cloneTo(this._targetPos);
                      this.findPathPoint(false);
                  }
                  else {
                      this.findPathPoint(true);
                  }
              }
          }
          else {
              if (this._curMeshPathArr.length == 0)
                  return;
              this._targetPos.cloneTo(this._vec);
              this._vec.y = tr.position.y;
              tr.lookAt(this._vec, Vector3Ex.Up, false);
              if (!Utils.isEmpty(this._player.curTarget)) {
                  if (Laya.Vector3.distance(tr.position, this._player.curTarget.transform.position) <= 1) {
                      this.setAttackState();
                      return;
                  }
              }
              tr.getForward(this._forwardVec);
              Laya.Vector3.scale(this._forwardVec, player.getMoveVal(player.speed * DataMgr.FixedDeltaTime * 1000), this._forwardVec);
              tr.translate(this._forwardVec, false);
              tr.localPositionY = DataMgr.instance.roleHeight;
          }
      }
      onExit(player) { }
      attackFrame(player) {
          this._frameCnt++;
          if (this._frameCnt > this.findInterval) {
              this._frameCnt -= this.findInterval;
              if (this._player.curTarget) {
                  if (Laya.Vector3.distance(this._player.curTarget.transform.position, player.transform.position) <= player.aiCfg.aiAttackRange) {
                      this.checkToAttack(player);
                  }
              }
          }
      }
      clear() {
          Vector3Ex.ZERO.cloneTo(this._targetPos);
          this._curMeshPathIndex = this._failCnt = 0;
          this._player = this._modelTr = null;
          this._isNavMeshPath = this._isWaitData = true;
          this._frameCnt = this._pathAarrIndex = this._pathPointIndex = this._curMeshPathArr.length = 0;
          this._pathJsonIndex = 1;
      }
      findPathPoint(isArrive) {
          if (this._player.curTarget) {
              return this.findPathByNaMesh(isArrive);
          }
          else {
              return this.findPathByPoint(isArrive);
          }
      }
      findPathByNaMesh(isArrive) {
          this._isNavMeshPath = true;
          if (isArrive) {
              if (this._curMeshPathArr.length > 0) {
                  this._curMeshPathIndex++;
                  let len = this._curMeshPathArr.length;
                  if (this._curMeshPathIndex >= len) {
                      this._curMeshPathArr.length = 0;
                      this._isWaitData = true;
                      console.info('NaMesh 寻路失败444   ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                      return false;
                  }
                  this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                  this._targetPos.cloneTo(this._player.navMeshPos);
                  return true;
              }
              else {
                  this._isWaitData = true;
                  console.info('NaMesh 寻路失败333  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
              }
          }
          else {
              this.getMeshPointArr(this._modelTr.position, this._targetPos);
              if (this._curMeshPathArr.length > 0) {
                  this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                  this._targetPos.cloneTo(this._player.navMeshPos);
              }
              else {
                  console.info('NaMesh 寻路失败22  ', this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                  this._isNavMeshPath = true;
                  this._player.curTarget = null;
                  this._isWaitData = true;
                  if (this.setFailCnt()) {
                      return false;
                  }
                  this._player.setRoleAni(this._player.gun.gunCfg.stand_action);
                  return false;
              }
          }
      }
      findPathByPoint(isArrive) {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          if (cfg) {
              if (isArrive) {
                  this._player._isBack ? this._pathAarrIndex-- : this._pathAarrIndex++;
                  if (!this.checkPathJson()) {
                      this._isWaitData = true;
                      console.info('NaMesh 寻路失败555  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                      this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                      this._player._isBack = !this._player._isBack;
                      if (this.setFailCnt()) {
                          return false;
                      }
                  }
                  let cfgPos = this.getPointPos();
                  if (!cfgPos) {
                      console.info('NaMesh 寻路失败666  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                      this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                      this._player._isBack = !this._player._isBack;
                      cfgPos = this.getPointPos();
                      if (!cfgPos) {
                          this._isWaitData = true;
                          return;
                      }
                  }
                  this._targetPos.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                  this.getMeshPointArr(this._modelTr.position, this._targetPos);
                  if (this._curMeshPathArr.length > 0) {
                      this._curMeshPathArr[0].cloneTo(this._targetPos);
                      this._targetPos.cloneTo(this._player.navMeshPos);
                      this._player.setRoleAni(this._player.gun.gunCfg.run_action);
                  }
                  else {
                      this._isWaitData = true;
                      if (this.setFailCnt()) {
                          return false;
                      }
                      console.info('NaMesh 寻路失败777   ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                  }
                  return true;
              }
              else {
                  if (this._isNavMeshPath) {
                      this._isNavMeshPath = false;
                      let cfgPos = this.findCurPathPoint();
                      if (cfgPos) {
                          this._targetPos.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                          this.getMeshPointArr(this._modelTr.position, this._targetPos);
                          if (this._curMeshPathArr.length > 0) {
                              this._curMeshPathArr[0].cloneTo(this._targetPos);
                              this._targetPos.cloneTo(this._player.navMeshPos);
                              return true;
                          }
                          else {
                              console.info('NaMesh 寻路失败11000  ' +
                                  this._player.getPlayerId() +
                                  '------' +
                                  Laya.timer.currTimer);
                              if (this.setFailCnt()) {
                                  return false;
                              }
                              this._isWaitData = true;
                              this._player.setRoleAni(this._player.gun.gunCfg.stand_action);
                              return false;
                          }
                      }
                      else {
                          console.info('NaMesh 寻路失败888  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                          this._isWaitData = true;
                          return false;
                      }
                  }
              }
          }
          else {
              console.info('NaMesh 寻路失败999  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
              if (this._pathJsonIndex >= this._jsonCnt || this._pathJsonIndex < 0) {
                  this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                  this._player._isBack = !this._player._isBack;
                  this._isNavMeshPath = true;
                  this.findPathByPoint(false);
              }
              else {
                  this._isWaitData = true;
              }
              return false;
          }
      }
      checkAngle(isAttack, target) {
          let playerTr = this._player.transform;
          playerTr.getForward(this._vec);
          Laya.Vector3.subtract(target.transform.position, playerTr.position, this._tempVec);
          let angle = isAttack ? this._aiAttackAngleInterval / 2 : this._aiTargeAngleInterval / 2;
          Laya.Vector3.normalize(this._tempVec, this._tempVec);
          let r = Laya.Vector3.dot(this._vec, this._tempVec);
          r = (Math.acos(r) / Math.PI) * 180;
          if (r < angle)
              return true;
          return false;
      }
      findEnemy() {
          this._curFindTime =
              DataMgr.nowTime + DataMgr.instance.findEnemyTime + Math.random() * this._randomTime;
          let len = this._player.getCamp() == PlayerCamp.Teammate
              ? DataMgr.instance._enemys.length
              : DataMgr.instance._players.length;
          let arr = this._player.getCamp() == PlayerCamp.Teammate
              ? DataMgr.instance._enemys
              : DataMgr.instance._players;
          let attackArr = [];
          let playerArr = [];
          for (let i = 0; i < len; i++) {
              let pr = arr[i];
              if (pr.isDead)
                  continue;
              if (DataMgr.nowTime < pr.birthIgnoresTime)
                  continue;
              let curDis = Laya.Vector3.distance(pr.transform.position, this._player.transform.position);
              playerArr.push({
                  player: pr,
                  dis: curDis
              });
          }
          playerArr.sort((a, b) => {
              return a.dis - b.dis;
          });
          if (!this._player.curTarget || !this._player.curTarget.isDead) {
              len = playerArr.length;
              for (let i = 0; i < len; i++) {
                  let pr = playerArr[i].player;
                  if (pr.isDead)
                      continue;
                  if (DataMgr.nowTime < pr.birthIgnoresTime)
                      continue;
                  let curDis = Laya.Vector3.distance(pr.transform.position, this._player.transform.position);
                  if (curDis <= this._findSize &&
                      this.checkAngle(false, pr) &&
                      this._player.gun.checkCanAttack(pr.transform.position)) {
                      attackArr.push({
                          player: pr,
                          dis: curDis
                      });
                      if (attackArr.length >= 3)
                          break;
                      if (i > len / 2)
                          break;
                  }
              }
          }
          if (attackArr.length != 0) {
              let pr = attackArr[(Math.random() * attackArr.length) | 0].player;
              this._player.curTarget = pr;
              pr.transform.position.cloneTo(this._targetPos);
              this._curFindTime += this._findMaxTime;
              this._targetPos.cloneTo(this._vec);
              this._vec.y = this._player.transform.position.y;
              this._player.transform.lookAt(this._vec, Vector3Ex.Up, false);
              this._player.setRoleAni(this._player.gun.gunCfg.run_action);
              this._curMeshPathIndex = this._curMeshPathArr.length = 0;
              this._isWaitData = false;
              if (pr.isUseVeh && !pr._veh.isTank) {
                  if (Laya.Vector3.distance(this._player.curTarget.transform.position, this._player.transform.position) <= this._player.aiCfg.aiAttackRange) {
                      if (!this.checkToAttack(this._player)) {
                          this._isNavMeshPath = true;
                          this._player.curTarget = null;
                          this.findPathPoint(false);
                      }
                  }
                  else {
                      this._isNavMeshPath = true;
                      this._player.curTarget = null;
                      this.findPathPoint(false);
                  }
              }
              else {
                  this.findPathPoint(false);
              }
          }
          else if (this._isWaitData) {
              this._isWaitData = false;
              this._isNavMeshPath = true;
              if (this.findPathPoint(false)) {
                  this._player.setRoleAni(this._player.gun.gunCfg.run_action);
              }
          }
          this._curFindTime = DataMgr.instance.checkTimeAdd(this._curFindTime);
      }
      setAttackState() {
          this._player.fsm.changeState(FSMState.Attack);
      }
      checkPathJson() {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathLen = Object.keys(cfg).length;
          if (this._pathJsonIndex > this._jsonCnt &&
              this._pathJsonIndex <= 0 &&
              this._pathAarrIndex > pathLen &&
              this._pathAarrIndex <= 0) {
              return false;
          }
          return true;
      }
      getPointPos() {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathLen = Object.keys(cfg).length;
          if (this._pathAarrIndex >= this._pathJsonIndex * 6 + 1 + pathLen ||
              this._pathAarrIndex <= this._pathJsonIndex * 6 + 1) {
              this._player._isBack ? this._pathJsonIndex-- : this._pathJsonIndex++;
              cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
              if (Utils.isEmpty(cfg)) {
                  return null;
              }
              this._pathAarrIndex =
                  this._pathJsonIndex * 6 + (this._player._isBack ? Object.keys(cfg).length : 1);
          }
          pathLen = Object.keys(cfg['path_' + this._pathAarrIndex].path).length;
          this._pathPointIndex = (Math.random() * pathLen) | 0;
          let info = cfg['path_' + this._pathAarrIndex].path[this._pathPointIndex];
          return info.position;
      }
      findCurPathPoint() {
          let curDis = 0;
          let lastDis = 1000;
          this._pathJsonIndex = 0;
          this._pathJsonIndex = 0;
          let pathArr = DataMgr.instance.pathArr;
          for (let i = 0; i < pathArr.length; i++) {
              let cfg = DataMgr.instance.pathArr[i];
              let len = Object.keys(cfg).length;
              for (let j = i * 6 + 1; j < i * 6 + 1 + len; j++) {
                  let cfgPos = cfg['path_' + j].path[0].position;
                  this._vec.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                  curDis = Laya.Vector3.distance(this._vec, this._player.transform.position);
                  if (lastDis > curDis && curDis > 3) {
                      this._pathJsonIndex = i;
                      this._pathAarrIndex = j;
                      lastDis = curDis;
                  }
              }
          }
          let pathJson = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathInfo = pathJson['path_' + this._pathAarrIndex].path;
          let len = Object.keys(pathInfo).length;
          this._pathPointIndex = (Math.random() * len) | 0;
          return pathInfo[this._pathPointIndex].position;
      }
      getRayPoint(pos) {
          let self = this;
          let origin = self._ray.origin;
          pos.cloneTo(origin);
          origin.y += 10;
          let direction = self._ray.direction;
          Vector3Ex.Down.cloneTo(direction);
          self._ray.origin = origin;
          self._ray.direction = direction;
          DataMgr.instance.scene.physicsSimulation.rayCastAll(self._ray, self._outHitInfoArr, 25);
          let len = self._outHitInfoArr.length;
          for (let i = 0; i < len; i++) {
              let out = this._outHitInfoArr[i];
              if (out.collider.owner.name == 'NavMesh') {
                  return out.point;
              }
          }
          return null;
      }
      getMeshPointArr(pos1, pos2) {
          let vec;
          vec = this.getRayPoint(pos1);
          Vector3Ex.ZERO.cloneTo(this._vec);
          if (vec) {
              vec.cloneTo(this._vec);
          }
          else {
              vec = NavMgr.instance.getClosestNode(pos1);
              vec && vec.cloneTo(this._vec);
          }
          let vec1;
          vec1 = this.getRayPoint(pos2);
          Vector3Ex.ZERO.cloneTo(this._tempVec);
          vec1 && vec1.cloneTo(this._tempVec);
          if (vec1) {
              vec1.cloneTo(this._tempVec);
          }
          else {
              vec1 = NavMgr.instance.getClosestNode(pos2);
              vec1 && vec1.cloneTo(this._tempVec);
          }
          this._curMeshPathArr.length = 0;
          if (Laya.Vector3.distance(this._vec, this._tempVec) > 0) {
              let arr = NavMgr.instance.onFindPath(this._player.getPlayerId(), this._vec, this._tempVec);
              if (arr) {
                  this._curMeshPathIndex = 0;
                  this._curMeshPathArr = arr.concat();
              }
              else {
                  Vector3Ex.ZERO.cloneTo(this._vec);
                  Vector3Ex.ZERO.cloneTo(this._tempVec);
                  vec1 = NavMgr.instance.getClosestNode(pos2);
                  vec1 && vec1.cloneTo(this._tempVec);
                  vec = NavMgr.instance.getClosestNode(pos1);
                  vec && vec.cloneTo(this._vec);
                  if (Laya.Vector3.distance(this._vec, this._tempVec) > 0) {
                      let arr = NavMgr.instance.onFindPath(this._player.getPlayerId(), this._vec, this._tempVec);
                      if (arr) {
                          this._curMeshPathIndex = 0;
                          this._curMeshPathArr = arr.concat();
                      }
                  }
                  else {
                      console.info('-------  当前寻路没有结果');
                  }
              }
          }
      }
      checkToAttack(player) {
          let isAttack = false;
          if (this.checkAngle(true, player.curTarget) && player.gun.checkCanAttack()) {
              isAttack = true;
              this.setAttackState();
          }
          return isAttack;
      }
      playerFail() {
          this._player.isFindPathDead = true;
          this._player.fsm.changeState(FSMState.Dead);
      }
      setFailCnt() {
          this._failCnt++;
          if (this._failCnt > this.maxFailCnt) {
              this.playerFail();
              return true;
          }
      }
      counterAttack() {
          if (this._player.attacker.isUseVeh && !this._player.attacker._veh.isTank) {
              return;
          }
          this._player.curTarget = this._player.attacker;
          this.findPathPoint(false);
      }
  }

  class LoadingState extends BaseState {
      onEnter(player) {
          let loadTiem = 1000;
          player.playReloadAni();
          this._cd = loadTiem + DataMgr.nowTime;
          if (player.isRolePlayer() && player._isAim) {
              player.refreshAim();
          }
      }
      onRuning(player) {
          if (this._cd > 0 && this._cd <= DataMgr.nowTime) {
              this._cd = 0;
              player.fsm.changeState(FSMState.Attack);
              if (player.isAimState) {
                  EventMgr.event(EventType.onAim, false);
              }
          }
      }
      onExit(player) { }
  }

  class PickUpState extends BaseState {
      onEnter(player) {
          if (!player) {
              return;
          }
          if (player.isAimState) {
              EventMgr.event(EventType.onAim, true);
              player.isAimState = false;
          }
          this.curTime = DataMgr.nowTime + 1000;
          let data = player.pickData;
          if (data.type == 1) {
              let pickUpGun = player.gun;
              player.gun.setDrop(false);
              player._gunArr.splice(player.gunIndex, 0, DataMgr.instance.curPickupGun);
              player.gun = DataMgr.instance.curPickupGun;
              player.gun.clearPickUp(player);
              player.addGunNode(DataMgr.instance.curPickupGun.gameObject, DataMgr.instance.curPickupGun.gunCfg);
              DataMgr.instance.curPickupGun = pickUpGun;
              EventMgr.event(EventType.RefreshSignShow);
              DataMgr.instance.role.reload();
          }
          else {
              let info = data.val;
              switch (info.type) {
                  case 1:
                      let pickUpGun = player.gun;
                      player.gun.setDrop(false);
                      let gun = player.createGunFun(player.gunIndex, CfgDataMgr.instance.gunAttributeCfg[info.val]);
                      player.gun = gun;
                      player._gunArr.splice(player.gunIndex, 0, gun);
                      DataMgr.instance.curPickupGun = pickUpGun;
                      gun.setData(null);
                      EventMgr.event(EventType.RefreshGunShow);
                      EventMgr.event(EventType.RefreshSignShow);
                      DataMgr.instance.role.reload();
                      break;
                  case 8888:
                      player.addAmmo(CfgDataMgr.instance.roleSkillCfg[info.val].bulletParam);
                      break;
                  case 7777:
                      player.addHp(CfgDataMgr.instance.roleSkillCfg[info.val].bulletParam);
                      break;
              }
              EventMgr.event(EventType.RefreshAIrBoxShow);
          }
      }
      onRuning(player) {
          if (this.curTime < DataMgr.nowTime) {
              player.fsm.changeState(FSMState.Attack);
          }
      }
      onExit(player) { }
  }

  class ReloadState extends BaseState {
      onEnter(player) {
          let self = this;
          if (player.isRolePlayer() && player._isAim) {
              EventMgr.event(EventType.onAim, true);
          }
          self._player = player;
          let time = player.gun.gunCfg.reloadingTime;
          this._armBulletCD = time + DataMgr.nowTime;
          this._loadTime = this._armBulletCD + 1000;
          this._reloadTime = Math.ceil((time + 1000) / 1000);
          if (player.isRolePlayer()) {
              EventMgr.event(EventType.ShowPro, [true, this._reloadTime]);
          }
          this._player.setRoleAni(self._player.gun.gunCfg.magInstall_action);
          EventMgr.on(EventType.Reload, this, this.onReload);
          EventMgr.on(EventType.gunClip, this, this.onGunClip);
          this._curTime = DataMgr.nowTime;
          if (player.isRolePlayer() && player._isAim) {
              player.refreshAim();
          }
      }
      onRuning(player) {
          if (player.isRolePlayer()) {
              this._reloadTime -= DataMgr.deltaTime;
              EventMgr.event(EventType.ShowPro, [true, this._reloadTime]);
          }
          if (this._armBulletCD > 0 && this._armBulletCD < DataMgr.nowTime) {
              this._armBulletCD = 0;
              player.playReloadAni();
          }
          if (this._loadTime > 0 && this._loadTime < DataMgr.nowTime) {
              this._loadTime = 0;
              this._player.fsm.changeState(FSMState.Attack);
              player.isNeedRefresh = true;
              if (player.isAimState) {
                  EventMgr.event(EventType.onAim, false);
              }
          }
      }
      onExit(player) {
          this._player.gun && this._player.gun.reset(true);
          if (player.isRolePlayer()) {
              EventMgr.event(EventType.ShowPro, [false]);
          }
          EventMgr.off(EventType.Reload, this, this.onReload);
          EventMgr.off(EventType.gunClip, this, this.onGunClip);
      }
      onReload(isVisible, playerID) {
          if (!DataMgr.instance.isGamming())
              return;
          if (playerID != this._player.getPlayerId())
              return;
          if (!this._player.gun)
              return;
          if (this._player.gun.magazine) {
              DataMgr.instance.playCfgSound(isVisible
                  ? this._player.gun.gunCfg.soundEffectMagInstall
                  : this._player.gun.gunCfg.soundEffectMagOut, this._player.transform.position);
          }
      }
      onGunClip(isVisible, playerID) {
          if (!DataMgr.instance.isGamming())
              return;
          if (playerID != this._player.getPlayerId())
              return;
          if (!this._player.gun)
              return;
          if (this._player.gun.magazine) {
              this._player.gun.magazine.active = isVisible;
          }
      }
  }

  class SwitchCatapultState extends BaseState {
      onEnter(player) {
          this._cd = DataMgr.nowTime + 1000;
          if (player.gun.isUseCatapult) {
          }
      }
      onRuning(player) {
          if (this._cd > 0 && this._cd <= DataMgr.nowTime) {
              this._cd = 0;
              player.fsm.changeState(FSMState.Attack);
              player.isNeedRefresh = true;
          }
      }
      onExit(player) { }
  }

  class SwitchGunState extends BaseState {
      constructor() {
          super();
          this._changGunTime = 0;
          this._loadTime = 0;
      }
      onEnter(player) {
          let cfg = player.getNextGunCfg();
          if (player.isRolePlayer()) {
              EventMgr.event(EventType.onAim, true);
              DataMgr.instance.playCfgSound(cfg.soundEffectSwith, player.transform.position);
          }
          player.setRoleAni(player.gun.gunCfg.swith_action);
          player.gun.isCanFire = false;
          this._switchTime = cfg.gunSwitchTime;
          this._changGunTime = this._switchTime / 4;
          this._changGunTime += DataMgr.nowTime;
          this._switchTime += DataMgr.nowTime;
          this._loadTime = this._switchTime + 1000;
      }
      onRuning(player) {
          if (DataMgr.nowTime > this._changGunTime && this._changGunTime > 0) {
              this._changGunTime = 0;
              player.switchGunSucc();
          }
          if (this._switchTime > 0 && DataMgr.nowTime > this._switchTime) {
              this._switchTime = 0;
              player.playReloadAni();
          }
          if (this._loadTime > 0 && DataMgr.nowTime > this._loadTime) {
              this._loadTime = 0;
              player.fsm.changeState(FSMState.Attack);
          }
      }
      onExit(player) { }
  }

  class TankAttackState extends BaseState {
      constructor() {
          super();
          this._nextAttack = 0;
          this._frameCnt = 0;
          this._maxStandTime = 10000;
          this._curStandTime = 0;
          this._curPos = new Laya.Vector3();
          this._randomTime = 200;
          this._vec = new Laya.Vector3();
          this._vec1 = new Laya.Vector3();
          this._rot = new Laya.Quaternion();
          this._tempVec = new Laya.Vector3();
          this._lastRot = new Laya.Quaternion();
          this._nextRot = new Laya.Quaternion();
          this._lastBarrelRot = new Laya.Quaternion();
          this._nextBarrelRot = new Laya.Quaternion();
      }
      onEnter(player) {
          this._aiAttackTimeIntervals = 1000 * player.aiCfg.aiAttackTimeIntervals;
          let time = Math.random() * player.aiCfg.aiTargetDelay;
          this._nextAttack += time * 1000 + DataMgr.nowTime;
          this._curStandTime = DataMgr.nowTime + this._curStandTime;
          player.transform.position.cloneTo(this._curPos);
          player.curSkillTime = DataMgr.nowTime + player.skillCD;
      }
      onRuning(player) {
          if (player.curTarget) {
              if (player.curTarget.isDead) {
                  player.fsm.changeState(FSMState.TankFindPathState);
                  return;
              }
              if (player.skillCom) {
                  player.skillCom.onUpdate();
                  return;
              }
              this.setTankRot(player);
              if (DataMgr.nowTime > player.curSkillTime) {
                  player.curSkillTime = DataMgr.nowTime + player.skillCD;
                  this.useSkill(player);
              }
              else {
                  if (this._nextAttack > 0 && DataMgr.nowTime >= this._nextAttack) {
                      this._nextAttack =
                          DataMgr.nowTime + this._aiAttackTimeIntervals + Math.random() * this._randomTime;
                      let dis = Laya.Vector3.distance(player.transform.position, player.curTarget.transform.position);
                      if (dis > player.aiCfg.aiAttackRange || dis < 5) {
                          player.fsm.changeState(FSMState.TankFindPathState);
                          return;
                      }
                      else {
                          this.aiFire(player);
                      }
                  }
                  this._frameCnt++;
                  if (this._frameCnt > 10) {
                      this._frameCnt -= 10;
                      if (!player.gun.checkCanAttack()) {
                      }
                      else if (DataMgr.nowTime > this._curStandTime) {
                          if (Laya.Vector3.distance(this._curPos, player.transform.position) <= 1) {
                              player.fsm.changeState(FSMState.TankFindPathState);
                          }
                          else {
                              this._curStandTime = DataMgr.nowTime + this._maxStandTime;
                          }
                      }
                  }
              }
          }
      }
      onExit(player) {
          player.gun && player.gun.setFiring(false);
          this._nextAttack = 0;
      }
      aiFire(player) {
          if (player.curTarget.isDead)
              return;
          player.curTarget.getBodyCenterPos().cloneTo(player.gun.targetPos);
          player.gun.setAttackCnt();
          player.gun.setFiring(true);
      }
      useSkill(player) {
          let random = Math.random();
          let curRandom = 0;
          let curSkillID = 0;
          for (let i = 1; i <= 3; i++) {
              let arr = player.aiCfg['aiSkill' + i];
              curRandom += arr[1];
              if (curRandom > random) {
                  curSkillID = arr[0];
                  break;
              }
          }
          if (curSkillID) {
              player.skillCfg = CfgDataMgr.instance.aiSkillsCfg[curSkillID];
              console.info('curSkillID', curSkillID);
              switch (curSkillID) {
                  case 105:
                      player.skillCom = new RocketSkill(player, 1);
                      break;
                  case 106:
                      player.skillCom = new RocketSkill(player, 2);
                      break;
              }
          }
      }
      setTankRot(player) {
          let tr = player._gunArr[1].rotatorModel.transform;
          let trRot = tr.rotation;
          let targetPos = player.curTarget.transform.position;
          targetPos.cloneTo(this._vec1);
          this._vec1.y = tr.position.y;
          Laya.Vector3.subtract(tr.position, this._vec1, this._vec);
          this._vec.x = -this._vec.x;
          Laya.Quaternion.rotationLookAt(this._vec, Vector3Ex.Up, this._rot);
          Laya.Quaternion.lerp(trRot, this._rot, 0.1, this._rot);
          this._rot.cloneTo(trRot);
          tr.rotation = trRot;
      }
      checkAngle(player, target) {
          let playerTr = player.transform;
          playerTr.getForward(this._vec);
          Laya.Vector3.subtract(target, playerTr.position, this._tempVec);
          let angle = 3;
          Laya.Vector3.normalize(this._tempVec, this._tempVec);
          let r = Laya.Vector3.dot(this._vec, this._tempVec);
          r = (Math.acos(r) / Math.PI) * 180;
          if (r < angle)
              return true;
          return false;
      }
  }

  class TankFindPathState extends BaseState {
      constructor() {
          super();
          this._findSize = 10;
          this._vec = new Laya.Vector3();
          this._forwardVec = new Laya.Vector3();
          this._tempVec = new Laya.Vector3();
          this._tempVec1 = new Laya.Vector3();
          this._targetPos = new Laya.Vector3();
          this._outHitInfoArr = [];
          this._isNavMeshPath = true;
          this._frameCnt = 0;
          this._aiTargeAngleInterval = 30;
          this._aiAttackAngleInterval = 30;
          this._findEnemyTime = 100;
          this._randomTime = 100;
          this._curMeshPathArr = [];
          this._curMeshPathIndex = 0;
          this._jsonCnt = 6;
          this._pathJsonIndex = 1;
          this._pathAarrIndex = 0;
          this._pathPointIndex = 0;
          this._isWaitData = false;
          this._isGetPathPoint = true;
          this._failCnt = 0;
          this._rot = new Laya.Quaternion();
          this._rot1 = new Laya.Quaternion();
          this.maxFailCnt = 3;
          this.findInterval = 5;
      }
      onEnter(player) {
          let self = this;
          this.clear();
          this._curFindTime = DataMgr.nowTime + this._findEnemyTime + Math.random() * this._randomTime;
          if (!this._player) {
              this._ray = new Laya.Ray(new Laya.Vector3(0, 0, 0), new Laya.Vector3(0, -1, 0));
          }
          this._player = player;
          this._modelTr = player.transform;
          player.speed = player.aiCfg.aiMoveSpeed;
          this._findSize = player.aiCfg.aiTargetRange;
          this._aiAttackAngleInterval = player.aiCfg.aiAttackAngleInterval;
          this._aiTargeAngleInterval = player.aiCfg.aiTargeAngleInterval;
          player._veh.transform.localRotationEulerY = 180;
          this._player.curTarget = null;
          Laya.timer.frameOnce(2, this, function () {
              self.findPathPoint(false);
              self._isWaitData = false;
          });
      }
      onRuning(player) {
          if (this._curFindTime < DataMgr.nowTime) {
              this.findEnemy();
              this._frameCnt = 0;
          }
          this.attackFrame(player);
          if (this._isWaitData) {
              return;
          }
          let tr = player.transform;
          this._targetPos.y = DataMgr.instance.roleHeight;
          if (Laya.Vector3.distance(tr.position, this._targetPos) <=
              player.getMoveVal(player.speed * DataMgr.FixedDeltaTime * 1000)) {
              Utils.vec3ToTargetVal('position', 1, tr.owner, this._targetPos);
              if (this._isNavMeshPath && Utils.isEmpty(this._player.curTarget)) {
                  this.findEnemy();
              }
              else {
                  if (!this._player.curTarget && this._curMeshPathArr.length > 0) {
                      this._curMeshPathIndex++;
                      if (this._curMeshPathIndex >= this._curMeshPathArr.length) {
                          this._curMeshPathIndex = 0;
                          this.findPathPoint(true);
                      }
                      else {
                          this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                      }
                  }
                  else {
                      if (this._player.curTarget) {
                          this._player.curTarget.transform.position.cloneTo(this._targetPos);
                          this.findPathPoint(false);
                      }
                      else {
                          this.findPathPoint(true);
                      }
                  }
              }
          }
          else {
              this._targetPos.cloneTo(this._tempVec);
              this._tempVec.y = tr.position.y;
              Laya.Vector3.subtract(this._tempVec, tr.position, this._tempVec);
              this._tempVec.cloneTo(this._tempVec1);
              tr.getForward(this._vec);
              this._targetPos.cloneTo(this._tempVec);
              this._tempVec.y = tr.position.y;
              tr.lookAt(this._tempVec, Vector3Ex.Up, false);
              tr.getForward(this._vec);
              Laya.Vector3.scale(this._vec, this._player.getMoveVal(player.speed * DataMgr.FixedDeltaTime * 1000), this._tempVec);
              tr.translate(this._tempVec, false);
              this._targetPos.y = DataMgr.instance.roleHeight;
          }
      }
      attackFrame(player) {
          this._frameCnt++;
          if (this._frameCnt > this.findInterval) {
              this._frameCnt -= this.findInterval;
              if (this._player.curTarget) {
                  if (Laya.Vector3.distance(this._player.curTarget.transform.position, player.transform.position) <= player.aiCfg.aiAttackRange) {
                      this.checkToAttack(player);
                  }
              }
          }
      }
      clear() {
          Vector3Ex.ZERO.cloneTo(this._targetPos);
          this._curMeshPathIndex = 0;
          this._player = null;
          this._isNavMeshPath = true;
          this._frameCnt = 0;
          this._pathJsonIndex = 1;
          this._pathAarrIndex = 0;
          this._pathPointIndex = 0;
          this._isWaitData = true;
      }
      findPathPoint(isArrive) {
          if (this._player.curTarget) {
              return this.findPathByNaMesh(isArrive);
          }
          else {
              return this.findPathByPoint(isArrive);
          }
      }
      findPathByNaMesh(isArrive) {
          this._isNavMeshPath = true;
          if (isArrive) {
              if (this._curMeshPathArr.length > 0) {
                  this._curMeshPathIndex++;
                  let len = this._curMeshPathArr.length;
                  if (this._curMeshPathIndex >= len) {
                      this._curMeshPathArr.length = 0;
                      this._isWaitData = true;
                      console.info('TankNaMesh 寻路失败444   ' +
                          this._player.getPlayerId() +
                          '------' +
                          Laya.timer.currTimer);
                      return false;
                  }
                  this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                  return true;
              }
              else {
                  this._isWaitData = true;
                  console.info('TankNaMesh 寻路失败333  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
              }
          }
          else {
              this.getMeshPointArr(this._modelTr.position, this._targetPos);
              if (SceneConst.isUseWorker) {
                  return true;
              }
              else {
                  if (this._curMeshPathArr.length > 0) {
                      this._curMeshPathArr[this._curMeshPathIndex].cloneTo(this._targetPos);
                  }
                  else {
                      console.info('TankNaMesh 寻路失败22  ', this._player.getPlayerId() + '------' + Laya.timer.currTimer);
                      this._isNavMeshPath = true;
                      this._player.curTarget = null;
                      this._isWaitData = true;
                      if (this.setFailCnt()) {
                          return false;
                      }
                      return false;
                  }
              }
          }
      }
      findPathByPoint(isArrive) {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          if (cfg) {
              if (isArrive) {
                  this._player._isBack ? this._pathAarrIndex-- : this._pathAarrIndex++;
                  if (!this.checkPathJson()) {
                      this._isWaitData = true;
                      console.info('TankNaMesh 寻路失败555  ' +
                          this._player.getPlayerId() +
                          '------' +
                          Laya.timer.currTimer);
                      this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                      this._player._isBack = !this._player._isBack;
                      if (this.setFailCnt()) {
                          return false;
                      }
                  }
                  let cfgPos = this.getPointPos();
                  if (!cfgPos) {
                      console.info('TankNaMesh 寻路失败666  ' +
                          this._player.getPlayerId() +
                          '------' +
                          Laya.timer.currTimer);
                      this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                      this._player._isBack = !this._player._isBack;
                      cfgPos = this.getPointPos();
                      if (!cfgPos) {
                          this._isWaitData = true;
                          return;
                      }
                  }
                  this._targetPos.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                  this.getMeshPointArr(this._modelTr.position, this._targetPos);
                  if (SceneConst.isUseWorker) {
                  }
                  else {
                      if (this._curMeshPathArr.length > 0) {
                          this._curMeshPathArr[0].cloneTo(this._targetPos);
                      }
                      else {
                          this._isWaitData = true;
                          if (this.setFailCnt()) {
                              return false;
                          }
                          console.info('TankNaMesh 寻路失败777   ' +
                              this._player.getPlayerId() +
                              '------' +
                              Laya.timer.currTimer);
                      }
                  }
                  return true;
              }
              else {
                  if (this._isNavMeshPath) {
                      this._isNavMeshPath = false;
                      let cfgPos = this.findCurPathPoint();
                      if (cfgPos) {
                          this._targetPos.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                          this.getMeshPointArr(this._modelTr.position, this._targetPos);
                          if (SceneConst.isUseWorker) {
                          }
                          else {
                              if (this._curMeshPathArr.length > 0) {
                                  this._curMeshPathArr[0].cloneTo(this._targetPos);
                                  return true;
                              }
                              else {
                                  console.info('TankNaMesh 寻路失败11000  ' +
                                      this._player.getPlayerId() +
                                      '------' +
                                      Laya.timer.currTimer);
                                  if (this.setFailCnt()) {
                                      return false;
                                  }
                                  this._isWaitData = true;
                                  return false;
                              }
                          }
                      }
                      else {
                          console.info('TankNaMesh 寻路失败888  ' +
                              this._player.getPlayerId() +
                              '------' +
                              Laya.timer.currTimer);
                          this._isWaitData = true;
                          this._isGetPathPoint = false;
                          return false;
                      }
                  }
              }
          }
          else {
              console.info('TankNaMesh 寻路失败999  ' + this._player.getPlayerId() + '------' + Laya.timer.currTimer);
              if (this._pathJsonIndex >= this._jsonCnt || this._pathJsonIndex < 0) {
                  this._pathJsonIndex = this._pathJsonIndex > this._jsonCnt ? this._jsonCnt : 0;
                  this._player._isBack = !this._player._isBack;
                  this._isNavMeshPath = true;
                  this.findPathByPoint(false);
              }
              else {
                  this._isWaitData = true;
              }
              return false;
          }
      }
      checkAngle(isAttack, target) {
          let playerTr = this._player.transform;
          playerTr.getForward(this._vec);
          Laya.Vector3.subtract(target.transform.position, playerTr.position, this._tempVec);
          let angle = isAttack ? this._aiAttackAngleInterval / 2 : this._aiTargeAngleInterval / 2;
          Laya.Vector3.normalize(this._tempVec, this._tempVec);
          let r = Laya.Vector3.dot(this._vec, this._tempVec);
          r = (Math.acos(r) / Math.PI) * 180;
          if (r < angle)
              return true;
          return false;
      }
      findEnemy() {
          this._curFindTime = DataMgr.nowTime + this._findEnemyTime + Math.random() * this._randomTime;
          let len = this._player.getCamp() == PlayerCamp.Teammate
              ? DataMgr.instance._enemys.length
              : DataMgr.instance._players.length;
          let arr = this._player.getCamp() == PlayerCamp.Teammate
              ? DataMgr.instance._enemys
              : DataMgr.instance._players;
          let attackArr = [];
          for (let i = 0; i < len; i++) {
              let pr = arr[i];
              if (pr.isDead)
                  continue;
              if (DataMgr.nowTime < pr.birthIgnoresTime)
                  continue;
              let curDis = Laya.Vector3.distance(pr.transform.position, this._player.transform.position);
              if (curDis <= this._findSize && this.checkAngle(false, pr)) {
                  attackArr.push({
                      player: pr,
                      dis: curDis
                  });
                  if (attackArr.length >= 3) {
                      break;
                  }
              }
          }
          if (attackArr.length != 0) {
              let pr = attackArr[(Math.random() * attackArr.length) | 0].player;
              this._player.curTarget = pr;
              pr.transform.position.cloneTo(this._targetPos);
              this._targetPos.cloneTo(this._vec);
              this._vec.y = this._player.transform.position.y;
              this._curMeshPathIndex = this._curMeshPathArr.length = 0;
              this._isWaitData = false;
              if (pr.isUseVeh && !pr._veh.isTank) {
                  if (Laya.Vector3.distance(this._player.curTarget.transform.position, this._player.transform.position) <= this._player.aiCfg.aiAttackRange) {
                      this._isNavMeshPath = true;
                      this._player.curTarget = null;
                      this.findPathPoint(false);
                  }
                  else {
                      this._isNavMeshPath = true;
                      this._player.curTarget = null;
                      this.findPathPoint(false);
                  }
              }
              else {
                  this.findPathPoint(false);
              }
          }
          else if (this._isWaitData) {
              this._isWaitData = false;
              this._isNavMeshPath = true;
              this.findPathPoint(false);
          }
      }
      setAttackState() {
          this._player.fsm.changeState(FSMState.TankAttackState);
      }
      checkPathJson() {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathLen = Object.keys(cfg).length;
          if (this._pathJsonIndex > this._jsonCnt &&
              this._pathJsonIndex <= 0 &&
              this._pathAarrIndex > pathLen &&
              this._pathAarrIndex <= 0) {
              return false;
          }
          return true;
      }
      getPointPos() {
          let cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathLen = Object.keys(cfg).length;
          if (this._pathAarrIndex >= this._pathJsonIndex * 6 + 1 + pathLen ||
              this._pathAarrIndex <= this._pathJsonIndex * 6 + 1) {
              this._player._isBack ? this._pathJsonIndex-- : this._pathJsonIndex++;
              cfg = DataMgr.instance.pathArr[this._pathJsonIndex];
              if (Utils.isEmpty(cfg)) {
                  return null;
              }
              this._pathAarrIndex =
                  this._pathJsonIndex * 6 + (this._player._isBack ? Object.keys(cfg).length : 1);
          }
          pathLen = Object.keys(cfg['path_' + this._pathAarrIndex].path).length;
          this._pathPointIndex = (Math.random() * pathLen) | 0;
          let info = cfg['path_' + this._pathAarrIndex].path[this._pathPointIndex];
          return info.position;
      }
      findCurPathPoint() {
          let curDis = 0;
          let lastDis = 1000;
          this._pathJsonIndex = 0;
          this._pathJsonIndex = 0;
          let pathArr = DataMgr.instance.pathArr;
          for (let i = 0; i < pathArr.length; i++) {
              let cfg = DataMgr.instance.pathArr[i];
              let len = Object.keys(cfg).length;
              for (let j = i * 6 + 1; j < i * 6 + 1 + len; j++) {
                  let cfgPos = cfg['path_' + j].path[0].position;
                  this._vec.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
                  curDis = Laya.Vector3.distance(this._vec, this._player.transform.position);
                  if (lastDis > curDis && curDis > 3) {
                      this._pathJsonIndex = i;
                      this._pathAarrIndex = j;
                      lastDis = curDis;
                  }
              }
          }
          let pathJson = DataMgr.instance.pathArr[this._pathJsonIndex];
          let pathInfo = pathJson['path_' + this._pathAarrIndex].path;
          let len = Object.keys(pathInfo).length;
          this._pathPointIndex = (Math.random() * len) | 0;
          return pathInfo[this._pathPointIndex].position;
      }
      getRayPoint(pos) {
          let self = this;
          let origin = self._ray.origin;
          pos.cloneTo(origin);
          origin.y += 10;
          let direction = self._ray.direction;
          Vector3Ex.Down.cloneTo(direction);
          self._ray.origin = origin;
          self._ray.direction = direction;
          DataMgr.instance.scene.physicsSimulation.rayCastAll(self._ray, self._outHitInfoArr, 25);
          let len = self._outHitInfoArr.length;
          for (let i = 0; i < len; i++) {
              let out = this._outHitInfoArr[i];
              if (out.collider.owner.name == 'NavMesh') {
                  return out.point;
              }
          }
          return null;
      }
      getMeshPointArr(pos1, pos2) {
          if (SceneConst.isUseWorker) {
              this._isWaitData = true;
          }
          let vec;
          vec = this.getRayPoint(pos1);
          Vector3Ex.ZERO.cloneTo(this._vec);
          if (vec) {
              vec.cloneTo(this._vec);
          }
          else {
              vec = NavMgr.instance.getClosestNode(pos1);
              vec && vec.cloneTo(this._vec);
          }
          let vec1;
          vec1 = this.getRayPoint(pos2);
          Vector3Ex.ZERO.cloneTo(this._tempVec);
          vec1 && vec1.cloneTo(this._tempVec);
          if (vec1) {
              vec1.cloneTo(this._tempVec);
          }
          else {
              vec1 = NavMgr.instance.getClosestNode(pos2);
              vec1 && vec1.cloneTo(this._tempVec);
          }
          this._curMeshPathArr.length = 0;
          if (Laya.Vector3.distance(this._vec, this._tempVec) > 0) {
              let arr = NavMgr.instance.onFindPath(this._player.getPlayerId(), this._vec, this._tempVec);
              if (arr) {
                  this._curMeshPathIndex = 0;
                  this._curMeshPathArr = arr.concat();
              }
              else {
                  Vector3Ex.ZERO.cloneTo(this._vec);
                  Vector3Ex.ZERO.cloneTo(this._tempVec);
                  vec1 = NavMgr.instance.getClosestNode(pos2);
                  vec1 && vec1.cloneTo(this._tempVec);
                  vec = NavMgr.instance.getClosestNode(pos1);
                  vec && vec.cloneTo(this._vec);
                  if (Laya.Vector3.distance(this._vec, this._tempVec) > 0) {
                      let arr = NavMgr.instance.onFindPath(this._player.getPlayerId(), this._vec, this._tempVec);
                      if (arr) {
                          this._curMeshPathIndex = 0;
                          this._curMeshPathArr = arr.concat();
                      }
                  }
                  else {
                      console.info('_-------');
                  }
              }
          }
      }
      checkToAttack(player) {
          let isAttack = false;
          if (this.checkAngle(true, player.curTarget) && player.gun.checkCanAttack()) {
              isAttack = true;
          }
          isAttack && this.setAttackState();
          return isAttack;
      }
      playerFail() {
          this._player.isFindPathDead = true;
          this._player.fsm.changeState(FSMState.Dead);
      }
      setFailCnt() {
          this._failCnt++;
          if (this._failCnt > this.maxFailCnt) {
              this.playerFail();
              return true;
          }
      }
      counterAttack() {
          if (this._player.attacker.isUseVeh && !this._player.attacker._veh.isTank) {
              return;
          }
          this._player.curTarget = this._player.attacker;
          this.findPathPoint(false);
      }
  }

  class UseBombState extends BaseState {
      constructor() {
          super();
          this._endTime = 0;
          this._isThrow = false;
          this._isThrowStart = false;
          this._isThrowEnd = false;
          this._isBeginCnt = false;
          this._delayTime = 0;
      }
      onEnter(player) {
          EventMgr.event(EventType.onAim, true);
          this._player = player;
          player.gun.gameObject.active = false;
          this._isThrow = false;
          EventMgr.on(EventType.Throw_start, this, this.throw_start);
          EventMgr.on(EventType.Throw_end, this, this.throw_end);
          EventMgr.on(EventType.Throw_Attack, this, this.throw_attack);
          EventMgr.on(EventType.Throw_AttackBegin, this, this.beginThrow);
          this._gunCfg = CfgDataMgr.instance.gunAttributeCfg[101201];
          let _cfg = CfgDataMgr.instance.bulletCfg[this._gunCfg.bulletID];
          this._useTime = Math.ceil(_cfg.bulletLifeTime / 1000);
          this._delayTime = this._useTime;
          this._isBomb = this._isBeginCnt = this._isThrowEnd = this._isThrowStart = false;
          EventMgr.event(EventType.SignVisible, false);
          this._player.grenade.active = true;
          this._player.setRoleAni(AniType.Throw_start);
      }
      onRuning(player) {
          if (DataMgr.instance.role.isBeginBomb && !this._isBeginCnt) {
          }
          if (this._isBeginCnt) {
          }
          if ((this._endTime != 0 && DataMgr.nowTime > this._endTime) || this._isBomb) {
              this._endTime = 0;
              this._player.fsm.changeState(FSMState.Attack);
              player.isNeedRefresh = true;
          }
      }
      onExit(player) {
          if (player && player.gun) {
              player.gun.gameObject.active = true;
              EventMgr.event(EventType.RefreshCurSelect);
          }
          player.drawLine(false);
          this._endTime = 0;
          player.isBeginBomb = false;
          this._player.isUseCom = false;
          EventMgr.off(EventType.Throw_start, this, this.throw_start);
          EventMgr.off(EventType.Throw_Attack, this, this.throw_attack);
          EventMgr.off(EventType.Throw_end, this, this.throw_end);
          EventMgr.event(EventType.ShowPro, [false]);
          EventMgr.event(EventType.SignVisible, true);
      }
      throw_end(playerId) {
          if (playerId != this._player.getPlayerId())
              return;
          if (!this._isThrowEnd) {
              this._isThrowEnd = true;
              if (this._isThrowEnd && this._isThrow) {
                  if (this._player.grenade.active) {
                      this.bomb();
                  }
              }
          }
      }
      throw_start(playerId) {
          if (playerId != this._player.getPlayerId())
              return;
          if (!this._isThrowStart) {
              this._isThrowStart = true;
          }
      }
      beginThrow() {
          this._player.setRoleAni(AniType.Throw_hold);
      }
      throw_attack() {
          if (this._isThrow)
              return;
          this._isThrow = true;
          if (this._isThrowEnd && this._isThrow) {
              if (this._player.grenade.active) {
                  this.bomb();
              }
          }
      }
      bomb() {
          this._player.isUseCom = true;
          this._endTime = DataMgr.nowTime + 1000;
          this._player.setRoleAni(AniType.Throw_end);
          this._player.grenade.active = false;
          this._player.gun.bombAttack(this._useTime, this._gunCfg.bulletID);
          this._player.drawLine(false);
          EventMgr.event(EventType.RefreshBombCnt, this._player.bombCnt);
      }
  }

  class ActionFSM {
      constructor(player) {
          this._stateMap = null;
          this._stateMap = {};
          this._player = player;
          this._isRunning = false;
      }
      changeState(type) {
          let state = this._stateMap[type];
          if (state == null) {
              switch (type) {
                  case FSMState.reload:
                      state = new ReloadState();
                      break;
                  case FSMState.Attack:
                      state = new AttackState();
                      break;
                  case FSMState.Dead:
                      state = new DeadState();
                      break;
                  case FSMState.switchGun:
                      state = new SwitchGunState();
                      break;
                  case FSMState.FindPath:
                      state = new FindPathState();
                      break;
                  case FSMState.UseBomb:
                      state = new UseBombState();
                      break;
                  case FSMState.TankFindPathState:
                      state = new TankFindPathState();
                      break;
                  case FSMState.TankAttackState:
                      state = new TankAttackState();
                      break;
                  case FSMState.LoadingState:
                      state = new LoadingState();
                      break;
                  case FSMState.SwitchCatapultState:
                      state = new SwitchCatapultState();
                      break;
                  case FSMState.PickUp:
                      state = new PickUpState();
                      break;
                  case FSMState.None:
                      state = new BaseState();
                      break;
                  default:
                      break;
              }
              this._stateMap[type] = state;
          }
          if (state == this._curState)
              return;
          this._curState && this._curState.onExit(this._player);
          state && state.onEnter(this._player);
          state && (this._curState = state);
          if (this._player.isAimState && (type == FSMState.UseBomb || type == FSMState.switchGun)) {
              this._player.isAimState = false;
          }
          if (type != FSMState.Attack && this._player.isRolePlayer()) {
              EventMgr.event(EventType.AimShow, false);
              DataMgr.instance.isViscous = false;
          }
      }
      isCurState(state) {
          return this._curState == this._stateMap[state];
      }
      setRunning(value) {
          this._isRunning = value;
      }
      isRunning() {
          return this._isRunning;
      }
      updateLogic() {
          if (!this._isRunning || !this._curState)
              return;
          this._curState.onRuning(this._player);
      }
      counterAttack() {
          this._curState.counterAttack();
      }
  }

  class BaseEntity extends Laya.Script3D {
      constructor() {
          super();
          this.aniDuration = 1000;
      }
      onAwake() {
          this.gameObject = this.owner;
          this.transform = this.gameObject.transform;
      }
      crossFade(name, duration = 0.1, layerIndex = 0, curAniName) {
          this.animator.crossFade(name, duration, layerIndex);
      }
  }

  class PlayerEvent extends Laya.Script3D {
      constructor() {
          super();
          this.isRole = false;
          this.playerID = 0;
          this._throwTime = 0;
          this._reloadTime1 = 0;
          this._reloadTime2 = 0;
      }
      FootStep() { }
      Throw_start() {
          let time = DataMgr.nowTime;
          if (time - this._throwTime > 20) {
              this._throwTime = time;
              EventMgr.event(EventType.Throw_start, this.playerID);
          }
      }
      Throw_hold() {
          let time = DataMgr.nowTime;
          if (time - this._throwTime > 20) {
              this._throwTime = time;
              EventMgr.event(EventType.Throw_end, this.playerID);
          }
      }
      HandGun_MagDetach() {
          let time = DataMgr.nowTime;
          if (time - this._reloadTime1 > 20) {
              this._reloadTime1 = time;
              EventMgr.event(EventType.Reload, [false, this.playerID]);
          }
      }
      HandGun_MagAtach() {
          let time = DataMgr.nowTime;
          if (time - this._reloadTime2 > 20) {
              this._reloadTime2 = time;
              EventMgr.event(EventType.Reload, [true, this.playerID]);
          }
      }
      AssaultRifle_MagDetach() {
          let time = DataMgr.nowTime;
          if (time - this._reloadTime1 > 20) {
              this._reloadTime1 = time;
              EventMgr.event(EventType.Reload, [false, this.playerID]);
          }
      }
      AssaultRifle_MagAtach() {
          let time = DataMgr.nowTime;
          if (time - this._reloadTime2 > 20) {
              this._reloadTime2 = time;
              EventMgr.event(EventType.Reload, [true, this.playerID]);
          }
      }
      MagDetach() {
          EventMgr.event(EventType.gunClip, [false, this.playerID]);
      }
      MagAtach() {
          EventMgr.event(EventType.gunClip, [true, this.playerID]);
      }
  }

  class VehicleGunWeapon extends Gun {
      onAwake() {
          this.propType = PropType.VehicleGunWeapon;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          let isExit = false;
          if (this.player) {
              if (this.player.isRolePlayer() && DataMgr.instance.isCannonAttack) {
                  isExit = true;
              }
              else if (!this.player.isRolePlayer() && this.index == 0) {
                  isExit = true;
              }
          }
          if (isExit) {
              super.onUpdate();
              if (this.player.isRolePlayer() && DataMgr.nowTime > this._fireTime + this.fireCD) {
                  DataMgr.instance.isTankCom = true;
              }
              if (this.isFiring) {
                  this.fire();
              }
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
          let rocket = PropMgr.instance.getProp(PropType.Rocket, 'Rocket');
          this._barrel.transform.getForward(this._vec);
          if (this.player.isRolePlayer()) {
              rocket.setTarget(this.player, this._barrel.transform.position, this._vec, this.gunCfg);
          }
          else {
              rocket.setAITarget(this.player, this.launchTf.position, this._vec, this.gunCfg, this.player.curTarget.transform.position);
          }
      }
  }

  class VehicleMachineGun extends Gun {
      onAwake() {
          this.propType = PropType.VehicleMachineGun;
          super.onAwake();
      }
      onUpdate() {
          if (this.player && this.player.isRolePlayer() && !DataMgr.instance.isSwitchCom)
              return;
          let isExit = false;
          if (this.player) {
              if (this.player.isRolePlayer() && !DataMgr.instance.isCannonAttack) {
                  isExit = true;
              }
              else if (!this.player.isRolePlayer() && this.index == 1) {
                  isExit = true;
              }
          }
          if (isExit) {
              super.onUpdate();
              if (this.isFiring) {
                  this.fire();
              }
          }
      }
      onFired() {
          this.calAttackPos();
          super.onFired();
      }
  }

  var Handler$4 = Laya.Handler;
  class Player extends BaseEntity {
      constructor() {
          super();
          this.curType = curType.HuMan;
          this.armBulletCD = 1000;
          this.skillCD = 0;
          this.curSkillTime = 0;
          this._isAim = false;
          this.isAimState = false;
          this.navMeshPos = new Laya.Vector3();
          this.hitEffect = [];
          this._aniType = '';
          this.aniSpeed = 1;
          this.isUseVeh = false;
          this.speed = 1;
          this._isBack = false;
          this.isBeginBomb = false;
          this.arms = [];
          this.isNeedRefresh = false;
          this.isUseCom = false;
          this.deadType = 0;
          this.isFindPathDead = false;
          this._gunArr = [];
          this.isRole = false;
          this.vec = new Laya.Vector3();
          this.tempVec = new Laya.Vector3();
          this._maxHp = 0;
          this._isCatapult = false;
          this._isDead = false;
          this._hp = 0;
          this._effectArr = [];
          this._gunIndex = 0;
          this._curSwitchGunIndex = 0;
          this._skillGunIndex = 0;
          this._curGunIndex = 0;
          this._bloodEndTime = 500;
          this._curFrameIndex = 0;
          this._beHitTime = 0;
          this._isBeHit = false;
          this._catapultArr = new Object();
          this._isLockAction = false;
          this._isShowFlag = 0;
          this.roleHp = 0;
          this.suprarenalCnt = 0;
          this.suprarenalCntTime = 0;
          this._outHitInfoArr = [];
          this._vec = new Laya.Vector3();
          this._tempVec = new Laya.Vector3();
      }
      onAwake() {
          super.onAwake();
          this.fsm = new ActionFSM(this);
          if (this.isRole) {
              this._ray = new Laya.Ray(new Laya.Vector3(0, 0, 0), new Laya.Vector3(0, -1, 0));
              this._curAmmo = new Object();
          }
      }
      setPlayerId(id) {
          this.playerId = id;
      }
      getPlayerId() {
          return this.playerId;
      }
      setCamp(camp) {
          this._camp = camp;
      }
      getCamp() {
          return this._camp;
      }
      isRolePlayer() {
          return this.isRole;
      }
      set playerName(val) {
          this._playerName = val;
      }
      get playerName() {
          return this._playerName;
      }
      reduceHp(val) {
          this.hp -= val;
          if (!this.isUseVeh) {
              this._effectArr.push(DataMgr.instance.createEffect(Effect.Clot_ef, this.gameObject));
          }
          if (this.attacker.isRolePlayer()) {
              let hitPart = this.hurtPart == PlayerPart.Body
                  ? '身体'
                  : this.hurtPart == PlayerPart.Head
                      ? '头部'
                      : '四肢';
              EventMgr.event(EventType.showHit, [hitPart, val]);
              EventMgr.event(EventType.HitEnemyShow);
              DataMgr.instance.curDoubleHit++;
          }
          if (this.isRole) {
              let hitPart = this.hurtPart == PlayerPart.Body
                  ? '身体'
                  : this.hurtPart == PlayerPart.Head
                      ? '头部'
                      : '四肢';
              EventMgr.event(EventType.showHit1, [hitPart, val]);
          }
          else {
              this.fsm.counterAttack();
          }
      }
      set hp(val) {
          this._hp = val;
          if (this._hp < 0) {
              this._hp = 0;
          }
          if (this.isRole) {
              EventMgr.event(EventType.RoleRefreshHp, this._hp / this._maxHp);
          }
          if (this._hp == 0) {
              this.doDead();
          }
      }
      get hp() {
          return this._hp;
      }
      get maxHp() {
          return this._maxHp;
      }
      get isDead() {
          return this._isDead;
      }
      set setDead(val) {
          this._isDead = val;
      }
      setDeadHandler(handler) {
          this._deadHandler = handler;
      }
      getBodyCenterPos() {
          return this._bodyCenterTf.position;
      }
      getBodyCenter() {
          return this._bodyCenterTf.owner;
      }
      getHeadCenterPos() {
          return this._headCenterTf.position;
      }
      get gunIndex() {
          return this._gunIndex;
      }
      set gunIndex(val) {
          this._gunIndex = val;
      }
      onDestroy() {
          super.onDestroy();
          this.heroModel = null;
          this.fsm = null;
          this.gun = null;
          this._bodyCenterTf = null;
          this._headCenterTf = null;
          this._skinCfg = null;
      }
      onDisable() { }
      recover() {
          for (let i = 0, len = this._effectArr.length; i < len; i++) {
              DataMgr.instance.recoverEffect(this._effectArr[i]);
          }
          this._effectArr.length = 0;
          this.checkVehClear();
          if (this.isRole) {
              this._curAmmo = new Object();
          }
      }
      clear() {
          for (let i = 0, len = this._gunArr.length; i < len; i++) {
              let gun = this._gunArr[i];
              if (!this.isUseVeh) {
                  DataMgr.instance.recoverProp(gun);
              }
              else {
                  gun.destroy();
              }
          }
          if (this.hitEffect.length > 0) {
              for (let i = 0, len = this.hitEffect.length; i < len; i++) {
                  let sp = this.hitEffect[i];
                  sp.active = false;
              }
              this.hitEffect.length = 0;
          }
          if (this._isCatapult && this.gun) {
              this.gun.gameObject.active = false;
          }
          if (this._flagObj) {
              DataMgr.instance.recoverEffect(this._flagObj);
          }
          this._gunArr.length = 0;
          this.gun = null;
          this.curTarget = null;
          this.cameraAni = null;
          this._gunIndex = 0;
          this._aniType = '';
          this.isAimState = false;
          this._isBeHit = false;
          this.stopAI();
          this.playCameraStand();
          this.isNeedRefresh = false;
          this._isLockAction = false;
          this._isCatapult = false;
          this.isFindPathDead = false;
          this.deadType = 0;
          this.skillCom && this.skillCom.destroy();
          this.skillCom = null;
      }
      updateRender(now) {
          if (DataMgr.instance.isTestPause && !this.isRole)
              return;
          if (DataMgr.instance.isTestPause0 && this._camp == PlayerCamp.Teammate && !this.isRole)
              return;
          if (DataMgr.instance.isTestPause1 && this._camp == PlayerCamp.Enemy)
              return;
          this.fsm && this.fsm.updateLogic();
          this._curFrameIndex++;
          if (this._curFrameIndex > 10 && !this.isDead) {
              this._curFrameIndex -= 10;
              this.check();
          }
      }
      startAI(state) {
          if (this.fsm) {
              if (this.isRolePlayer()) {
                  this.fsm.changeState(FSMState.Attack);
              }
              else {
                  this.fsm.changeState(state);
              }
              this.fsm.setRunning(true);
          }
      }
      stopAI() {
          if (this.fsm) {
              this.fsm.setRunning(false);
              this.fsm.changeState(FSMState.None);
          }
      }
      bindCollider(obj) {
          if (obj.name == 'BodyCollider' ||
              obj.name == 'HeadCollider' ||
              obj.name == 'UpperLegCollider' ||
              obj.name == 'LowwerLegCollider' ||
              obj.name == 'UpperArmCollider' ||
              obj.name == 'LowwerArmCollider') {
              let collider = ExUtils.addSingleComponent(obj, PlayerCollider);
              collider.player = this;
              if (obj.name == 'BodyCollider') {
                  collider.playerPart = PlayerPart.Body;
                  this._bodyCenterTf = obj.transform;
              }
              else if (obj.name == 'HeadCollider') {
                  collider.playerPart = PlayerPart.Head;
                  this._headCenterTf = obj.transform;
              }
              else {
                  collider.playerPart = PlayerPart.Arms;
                  this.arms.push(obj.transform);
              }
              let co = obj.getComponent(Laya.PhysicsCollider);
              co.collisionGroup =
                  this._camp == PlayerCamp.Teammate
                      ? Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2
                      : Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3;
          }
          for (let i = 0; i < obj.numChildren; i++) {
              this.bindCollider(obj.getChildAt(i));
          }
      }
      setEnemyId(id, handler) {
          this.aiCfg = CfgDataMgr.instance.professionCfg[id];
          this._skinCfg = this.aiCfg;
          this.changeModel(this.aiCfg.aiModel[this._camp == PlayerCamp.Enemy ? 1 : 0], handler);
      }
      doDead() {
          if (this.isDead)
              return;
          this._isDead = true;
          this.fsm.changeState(FSMState.Dead);
          EventMgr.event(EventType.RefreshDeadCnt);
          let cfg = CfgDataMgr.instance.resCfg[this._attackGun];
          let gunName = '_____';
          if (cfg)
              gunName = cfg.goodsIcon;
          if (this._attackGun == 3) {
              gunName = 'battle/img_battle_tankIcon.png';
              this._isShowFlag = 1;
          }
          EventMgr.event(EventType.HitShow, [
              this.attacker.playerName,
              this._playerName,
              gunName,
              this.attacker._camp,
              this._isShowFlag
          ]);
          if (this.attacker.isRolePlayer()) {
              EventMgr.event(EventType.HitTips);
              DataMgr.instance.killCnt++;
              if (cfg) {
                  let gunCfg = CfgDataMgr.instance.gunAttributeCfg[this._attackGun];
                  gunCfg && TaskMgr.instance.setTaskProgress(106, 1, gunCfg.gunType);
                  gunCfg && TaskMgr.instance.setTaskProgress(113, 1, cfg.ID);
              }
              if (UserData.instance.curVocationId > 601) {
                  TaskMgr.instance.setTaskProgress(112, 1, UserData.instance.curVocationId);
              }
              if (this.attacker._veh) {
                  TaskMgr.instance.setTaskProgress(107, 1, this.attacker._veh.isTank ? 1 : 2);
              }
              TaskMgr.instance.setTaskProgress(102, 1);
              if (this.hurtPart == PlayerPart.Head) {
                  DataMgr.instance.killHeadCnt++;
                  EventMgr.event(EventType.PlayHeadShotAni);
                  UmengPlatform.trackEvent('jiesuan', {
                      shuju: '爆头'
                  });
              }
              DataMgr.instance.curSerialKill++;
              if (DataMgr.instance.curSerialKill > 1) {
                  EventMgr.event(EventType.RefreshDoubleHit, [true, DataMgr.instance.curSerialKill]);
              }
              UmengPlatform.trackEvent('jiesuan', {
                  shuju: '击杀'
              });
          }
          this._isLockAction = true;
          if (this.isRole && this.isUseVeh) {
              DataMgr.instance.showVehDeadAni = true;
              DataMgr.instance.cameraCtrl.vehAniRest();
          }
      }
      checkVehClear() {
          if (this.isUseVeh) {
              this.isUseVeh = false;
              this._veh = null;
              this.curType = curType.HuMan;
              for (let i = this._gunArr.length - 1; i >= 0; i--) {
                  let gun = this._gunArr[i];
                  gun.destroy();
              }
              this._gunArr.length = 0;
          }
      }
      born(state = FSMState.Attack) {
          this.birthIgnoresTime = 1000 + DataMgr.nowTime;
          this._isDead = false;
          if (!this.isRole) {
              this._playerName = CfgDataMgr.instance.getRandomName();
              this._isBack = this.getCamp() == PlayerCamp.Teammate;
          }
          else {
              this.body_01 && (this.body_01.active = false);
          }
          this.startAI(state);
          if (this.isRole) {
              if (this.gun.bulletCnt != this.gun.maxBulletCnt) {
                  this.reload();
              }
          }
      }
      setSkin(skinId, callBack = null) {
          this._skinId = skinId;
          this._skinCfg = CfgDataMgr.instance.professionCfg[skinId];
          let modelName = this._skinCfg.aiModel[0];
          this.changeModel(modelName, callBack);
      }
      setVeh(veh, roleId, callBack = null) {
          if (this.isUseVeh) {
              this._skinCfg = CfgDataMgr.instance.vehicleCfg[(this._skinId = veh.cfg.vehID)];
              if (this.isRole) {
                  if (DataMgr.instance.isGuideFirstGame) {
                      if (veh.isTank) {
                          AldPlatform.aldSendEvent('yd22');
                      }
                      else {
                          AldPlatform.aldSendEvent('yd23');
                      }
                  }
                  if (veh.isTank) {
                      AldPlatform.aldSendEvent('guanka24');
                  }
                  else {
                      AldPlatform.aldSendEvent('guanka25');
                  }
              }
          }
          else {
              this._skinCfg = CfgDataMgr.instance.professionCfg[(this._skinId = roleId)];
          }
          this.loadVehModel(veh, callBack);
      }
      loadVehModel(veh, callback = null) {
          let self = this;
          let oldModel = self.gameObject.getChildByName('Model');
          if (!this.isUseVeh) {
              oldModel && (oldModel.active = true);
              self.arms.length = 0;
              self.bindCollider(oldModel);
              self.animator = ExUtils.getComponentInChild(oldModel, Laya.Animator);
              self.aniState = null;
              if (!this._veh.isTank) {
                  this._veh.transform.localPositionY = DataMgr.instance.roleHeight;
                  this._veh.transform.localRotationEulerZ = this._veh.transform.localRotationEulerX = 0;
              }
              this._veh = null;
          }
          else {
              oldModel && (oldModel.active = false);
              self.cameraAni = null;
              let cameraRegular = ExUtils.findChild(veh.gameObject, 'CameraRegular');
              if (cameraRegular) {
                  this.CameraRegular = cameraRegular;
                  self.cameraAni = cameraRegular.getComponent(Laya.Animator);
              }
              if (this.isRole) {
                  Utils.vec3ToTargetVal('rotationEuler', 1, self.parentTr.owner, veh.gameObject.transform.rotationEuler);
                  Utils.vec3ToTargetVal('position', 1, self.parentTr.owner, veh.gameObject.transform.position);
              }
              veh.setActivation(this.playerId, this);
              self.owner.addChildAt(veh.gameObject, 0);
              this.playCameraStand();
              veh.playIdea();
              let effect = veh.gameObject.getChildByName(Effect.XS_guide_ef);
              effect && DataMgr.instance.recoverEffect(effect);
              oldModel = veh.gameObject;
              this._veh = veh;
              self.animator = null;
              UmengPlatform.trackEvent('zhandou', {
                  jhzj: this._veh.cfg.vehID
              });
              if (this.curType == curType.Tank) {
                  veh.showEffect(true);
              }
          }
          Utils.vec3ToTargetVal('localRotationEuler', 1, oldModel);
          Utils.vec3ToTargetVal('localPosition', this.isRole ? 2 : 1, oldModel);
          self.mesh = ExUtils.getSkinMesh(oldModel);
          self.heroModel = oldModel;
          self.armGunWithId(true);
          callback && callback.run();
      }
      getHPByJson() {
          let val;
          if (this.curType == curType.HuMan) {
              val = this.isRole ? this._skinCfg.mainRoleHP : this._skinCfg.aiRoleHP;
          }
          else {
              val = this._skinCfg.vehHPt;
          }
          return val;
      }
      changeModel(name, callback = null) {
          let self = this;
          let path = DynamicSceneRoot + name + '.lh';
          ExUtils.instanceSprite3D(path, null, Handler$4.create(this, function (newModel) {
              if (!self.gameObject) {
                  newModel.destroy();
                  return;
              }
              let oldModel = self.gameObject.getChildByName('Model');
              if (oldModel) {
                  let playerEvent = oldModel.getComponent(PlayerEvent);
                  DataMgr.instance.recoverEffect(oldModel, playerEvent.modelName);
              }
              self.body_01 = self.arm_01 = null;
              self.owner.addChildAt(newModel, 0);
              Utils.vec3ToTargetVal('localRotationEuler', 3, newModel);
              Utils.vec3ToTargetVal('localPosition', 1, newModel);
              let playerEvent = ExUtils.addSingleComponent(newModel, PlayerEvent);
              playerEvent.modelName = path;
              playerEvent.isRole = this.isRole;
              playerEvent.playerID = self.playerId;
              self.arm_01 = newModel.getChildByName('Arm');
              self.body_01 = newModel.getChildByName('Body');
              self.arm_01 && (self.body_01.active = self.arm_01.active = true);
              newModel.name = 'Model';
              self.heroModel = newModel;
              self.animator = ExUtils.getComponentInChild(newModel, Laya.Animator);
              self.aniState = this.animator.getControllerLayer(0);
              if (!self.isRole) {
                  newModel.transform.localRotationEulerY += 180;
              }
              else {
                  self.body_01 && (self.body_01.active = false);
                  let camSlot = ExUtils.findChild(newModel, 'CamSlot_FPS');
                  self.cameraAni = camSlot.getComponent(Laya.Animator);
                  this.playCameraStand();
              }
              self.mesh = ExUtils.getSkinMesh(newModel);
              if (SceneConst.Realtime_Shadow) {
                  ExUtils.setCastShadow(newModel, true);
              }
              self.bindCollider(newModel);
              self.armGunWithId(false);
              if (!self.isRole) {
                  let flagName = self._camp == PlayerCamp.Teammate ? 'IdentificationBlue' : 'IdentificationRed';
                  ExUtils.instanceSprite3D(DynamicSceneRoot + flagName + '.lh', self.heroModel, Handler$4.create(this, function (newModel) {
                      self._flagObj = newModel;
                      Utils.vec3ToTargetVal('localPosition', 1, self._flagObj);
                      self._flagObj.name = DynamicSceneRoot + flagName + '.lh';
                  }));
              }
              callback && callback.run();
          }));
      }
      armGunWithId(isLoadVeh) {
          this.onArmGun(isLoadVeh);
          if (this.isRole) {
              DataMgr.instance.role.roleCtrl.init(this._skinId);
              DataMgr.instance.role.roleCtrl._initViewLock = isLoadVeh;
          }
          else {
              this.skillCD = this.aiCfg.aiSkillIntervalTime * 1000;
          }
          this._maxHp = this.getHPByJson();
          if (this.curType == curType.HuMan) {
              if (this.roleHp != 0) {
                  this.hp = this.roleHp;
                  EventMgr.event(EventType.RoleHpRefresh, this._hp / this._maxHp);
                  this.roleHp = 0;
              }
              else {
                  this.hp = this._maxHp;
              }
          }
          else {
              this.roleHp = this.hp;
              this.hp = this._veh.durable;
          }
      }
      onArmGun(isLoadVeh) {
          let self = this;
          let id = -1;
          if (self.isRole) {
              let info = UserData.instance.getGunInfo(UserData.instance.curUseGunId);
              info && (id = info.id);
          }
          else {
              id = self.aiCfg.aiMainWeaponType[(Math.random() * self.aiCfg.aiMainWeaponType.length) | 0];
              id = this.getGunId(id);
          }
          if (self.curType == curType.HuMan) {
              if (id == -1) {
                  return;
              }
              this._gunNodeR = ExUtils.findChild(self.heroModel, 'Slot_WeaponR');
              this._gunNodeL = ExUtils.findChild(self.heroModel, 'Slot_WeaponL');
              if (this.isRole) {
                  if (this.grenade) {
                      this.grenade.removeSelf();
                      this.grenade.destroy();
                      this.grenade = null;
                  }
                  ExUtils.instanceSprite3D(DynamicSceneRoot + 'WeapThrowGrenade' + '.lh', this._gunNodeR, Laya.Handler.create(this, function (obj) {
                      self.grenade = obj;
                      self.grenade.active = false;
                      Utils.vec3ToTargetVal('localPosition', 1, self.grenade, null);
                  }));
              }
              let gunCfg = CfgDataMgr.instance.gunAttributeCfg[id];
              self._gunArr.push(this.createGunFun(0, gunCfg));
              if (this.isRole) {
                  let gunArr = UserData.instance.getUseGunArr();
                  let info = UserData.instance.getGunInfo(gunArr[1]);
                  if (info) {
                      id = info.id;
                      gunCfg = CfgDataMgr.instance.gunAttributeCfg[id];
                      let gun = this.createGunFun(1, gunCfg);
                      gun.gameObject.active = false;
                      self._gunArr.push(gun);
                  }
                  for (let i = 0, len = self._gunArr.length; i < len; i++) {
                      let gun = self._gunArr[i];
                      let data = UserData.instance.getGunInfo(gunArr[i]);
                      if (data) {
                          if (Object.keys(this._curAmmo).length > 0) {
                              gun.setData(data, this._curAmmo['gun_' + i]);
                          }
                          else {
                              gun.setData(data);
                          }
                      }
                  }
                  this._curAmmo = new Object();
                  this._catapultArr = {};
                  for (let i = 0, len = self._gunArr.length; i < len; i++) {
                      let gun = self._gunArr[i];
                      if (gun.isHasCatapult) {
                          let gunCfg = CfgDataMgr.instance.gunAttributeCfg[gun.gun_barrel];
                          let barrel = self.createGunFun(gun.index, gunCfg);
                          barrel.setCatapult();
                          barrel.setData(null);
                          this._catapultArr[gun.index] = barrel;
                          barrel.gameObject.active = false;
                      }
                  }
              }
              else {
                  let cfgLen = self.aiCfg.aiViceWeaponType.length;
                  if (cfgLen > 0) {
                      id = self.aiCfg.aiViceWeaponType[(Math.random() * cfgLen) | 0];
                      id = this.getGunId(id);
                      gunCfg = CfgDataMgr.instance.gunAttributeCfg[id];
                      let gun = this.createGunFun(1, gunCfg);
                      gun.gameObject.active = false;
                      self._gunArr.push(gun);
                  }
                  else {
                      if (self.aiCfg.aiID == 701 || self.aiCfg.aiID == 801) {
                          id = self.aiCfg.aiID == 701 ? 100901 : 101001;
                          gunCfg = CfgDataMgr.instance.gunAttributeCfg[id];
                          let gun = this.createGunFun(1, gunCfg);
                          gun.gameObject.active = false;
                          self._gunArr.push(gun);
                      }
                  }
                  for (let i = 0, len = self._gunArr.length; i < len; i++) {
                      let gun = self._gunArr[i];
                      gun.setData(null);
                  }
              }
          }
          else if (this.curType == curType.Tank) {
              let sp1 = ExUtils.findChild(self.heroModel, 'Barrel');
              if (sp1) {
                  let gun = ExUtils.addSingleComponent(sp1, VehicleGunWeapon);
                  id = self._skinCfg.vehWeaponID2;
                  gun.onAwake();
                  gun.setGunId(id, self, 0);
                  self._gunArr.push(gun);
              }
              let sp = ExUtils.findChild(self.heroModel, 'RotatorGunA');
              if (sp) {
                  let gun = ExUtils.addSingleComponent(sp, VehicleMachineGun);
                  id = self._skinCfg.vehWeaponID1;
                  gun.onAwake();
                  gun.setGunId(id, self, 1);
                  self._gunArr.push(gun);
              }
          }
          else if (this.curType == curType.Air) {
              let sp1 = ExUtils.findChild(self.heroModel, 'SlotFireMissileA');
              if (sp1) {
                  let gun = ExUtils.addSingleComponent(sp1, MissileLauncher);
                  id = self._skinCfg.vehWeaponID2;
                  gun.onAwake();
                  gun.setGunId(id, self, 0);
                  self._gunArr.push(gun);
              }
              let sp = ExUtils.findChild(self.heroModel, 'RotatorGunA');
              if (sp) {
                  let gun = ExUtils.addSingleComponent(sp, VehicleMachineGun);
                  id = self._skinCfg.vehWeaponID1;
                  gun.onAwake();
                  gun.setGunId(id, self, 1);
                  self._gunArr.push(gun);
              }
          }
          self.setPlayerGun(0);
          this._residue = {};
          if (!this.isRole) {
              this.setSkill();
          }
          else {
              self.curType == curType.HuMan && this.animator.play(this.gun.gunCfg.stand_action);
              EventMgr.event(EventType.RefreshGunShow);
          }
      }
      setSkill() {
          let skillId = -1;
          for (let i = 1; i <= 3; i++) {
              let skill = this.aiCfg['aiSkill' + i];
              if (Utils.isEmpty(skill)) {
                  continue;
              }
              if (skill.length > 0) {
                  if (skill[0] == 105 || skill[0] == 106 || skill[0] == 107) {
                      skillId = skill[0];
                  }
                  let cfg = CfgDataMgr.instance.aiSkillsCfg[skill[0]];
                  this._residue[cfg.aiSkillAmmo] = cfg.ammoNum == 0 ? 9999 : cfg.ammoNum;
              }
          }
          if (skillId == -1)
              return;
          let cfg = CfgDataMgr.instance.aiSkillsCfg[skillId];
          if (cfg.gunType.length <= 0)
              return;
          for (let i = 0, len = this._gunArr.length; i < len; i++) {
              let gun = this._gunArr[i];
              for (let j = 0, cfgLen = cfg.gunType.length; j < cfgLen; j++) {
                  if (gun.gunCfg.gunType == cfg.gunType[j]) {
                      this._skillGunIndex = i;
                      break;
                  }
              }
          }
      }
      setPlayerGun(index) {
          this.gun = this._gunArr[index];
          if (this.gun) {
              this.gun.gameObject.active = true;
              this.gun.setFiring(false);
          }
          if (this.isRole) {
              EventMgr.event(EventType.RefreshSignShow);
              EventMgr.event(EventType.RefreshAimBtn, this.gun.isShowAim());
          }
      }
      getGunId(type) {
          let cfg = CfgDataMgr.instance.gunAttributeCfg;
          let cfgArr = [];
          for (let key in cfg) {
              if (cfg[key].gunType == type) {
                  cfgArr.push(cfg[key].gunID);
              }
          }
          return cfgArr[(Math.random() * cfgArr.length) | 0];
      }
      crossFade(name, duration = 0.1, layerIndex = 0, curAniName = '') {
          if (!this.animator)
              return;
          if (this._isLockAction)
              return;
          curAniName != '' && (this._aniType = curAniName);
          super.crossFade(name, duration, layerIndex, curAniName);
      }
      hurtByBullet(part, attacker, pos, rot, attackGun, parentObj) {
          if (this.isDead)
              return;
          this.hurtPart = part;
          let hurt = DataMgr.instance.calBulletHurt(part, CfgDataMgr.instance.gunAttributeCfg[attackGun]);
          this.attacker = attacker;
          this._isBeHit = true;
          this._beHitTime = DataMgr.nowTime + CfgDataMgr.instance.getGlobalCfg('hitStiffTime') * 1000;
          if (this.isRole && DataMgr.instance.test_Invincible) {
              hurt = 0;
          }
          else if (this.birthIgnoresTime > DataMgr.nowTime) {
              hurt = 0;
          }
          if (DataMgr.instance.isTestHit) {
              hurt = 1000000;
          }
          this.deadType = 0;
          this._attackGun = attackGun;
          this.setHitShow(attacker, true, attackGun);
          hurt > 0 && this.reduceHp(hurt);
          if (this.isRole) {
              let soundArr = ['GetHit_Male_02', 'GetHit_Male_03'];
              DataMgr.instance.playCfgSound(soundArr[(Math.random() * soundArr.length) | 0], this.transform.position);
          }
      }
      hurtByCannon(attacker, pos, rot, hurt, gunID) {
          if (this.isDead)
              return;
          this.hurtPart = PlayerPart.Body;
          this._attackGun = gunID;
          this.attacker = attacker;
          if (this.isRole && DataMgr.instance.test_Invincible) {
              hurt = 0;
          }
          this.setHitShow(attacker);
          hurt > 0 && this.reduceHp(hurt);
          this.deadType = 1;
          if (!this.isRole && hurt > 0) {
              if (DataMgr.nowTime > this._bloodEndTime) {
                  let effect = Effect.Blood_01_ef;
                  DataMgr.instance.showSceneEffect(effect, pos, rot, this._bodyCenterTf.owner, true);
                  this._bloodEndTime = DataMgr.nowTime + Player.BLOOD_TIME;
              }
          }
          if (this.isRole) {
              let soundArr = ['GetHit_Male_02', 'GetHit_Male_03'];
              DataMgr.instance.playCfgSound(soundArr[(Math.random() * soundArr.length) | 0], this.transform.position);
          }
      }
      hurtByVel(attacker, pos) {
          if (this.isDead)
              return;
          this.hurtPart = PlayerPart.Body;
          let hurt = 10000;
          this.attacker = attacker;
          this._attackGun = 3;
          if (this.isRole && DataMgr.instance.test_Invincible) {
              hurt = 0;
          }
          this.deadType = 2;
          this.setHitShow(attacker, false);
          this.reduceHp(hurt);
          if (!this.isRole && hurt > 0) {
              if (DataMgr.nowTime > this._bloodEndTime) {
                  let effect = Effect.Blood_01_ef;
                  DataMgr.instance.showSceneEffect(effect, pos, Vector3Ex.ZERO, this._bodyCenterTf.owner, true);
                  this._bloodEndTime = DataMgr.nowTime + Player.BLOOD_TIME;
              }
          }
          if (this.isRole) {
              let soundArr = ['GetHit_Male_02', 'GetHit_Male_03'];
              DataMgr.instance.playCfgSound(soundArr[(Math.random() * soundArr.length) | 0], this.transform.position);
          }
      }
      setHitShow(attacker, isShow = true, attackGun = -1) {
          this._isShowFlag = 0;
          if (isShow) {
              if (attacker.gun.gunCfg.gunType == PropType.RocketLauncher ||
                  attacker.gun.gunCfg.gunType == PropType.MissileLauncher ||
                  attacker.gun.gunCfg.gunType == PropType.VehicleGunWeapon) {
                  this._isShowFlag = 1;
              }
              if (this.hurtPart == PlayerPart.Head) {
                  this._isShowFlag = 2;
              }
              if (attackGun > 0 &&
                  (attackGun == 101201 || attackGun == 101202 || attackGun == 101203 || attackGun == 101301)) {
                  this._isShowFlag = 1;
              }
          }
      }
      addAmmo(cnt, isClip = false) {
          let magazineNumber = this.gun.gunCfg.magazineNumber == 0 ? 1 : this.gun.gunCfg.magazineNumber;
          if (isClip) {
              magazineNumber = 1;
          }
          let val = magazineNumber * this.gun.gunCfg.magazineClip * cnt;
          this.gun.magazineNumber += val;
          DataMgr.instance.role.reload();
      }
      addHp(cnt) {
          if (this.isDead)
              return false;
          if (this.hp >= this.maxHp)
              return false;
          if (cnt + this.hp > this._maxHp) {
              this.hp = this._maxHp;
          }
          else {
              this.hp += cnt;
          }
          return true;
      }
      setRoleAni(name, duration = 0.1) {
          if (DataMgr.instance.isCurReviveIng && this.isRole)
              return;
          if (!this.animator)
              return;
          if (name == '')
              return;
          if (this.isFindPathDead && name.indexOf('Dead') == -1)
              return;
          let Huanqiang1 = this.gun.gunCfg.swith_action;
          let reload = this.gun.gunCfg.magInstall_action;
          let fire = this.gun.gunCfg.fire_action;
          if (name == Huanqiang1 || name == reload || name == fire) {
              if (name == Huanqiang1 || name == reload) {
                  if (this.isRole && this.aniState) {
                      let clip = this.aniState.getAnimatorState(name).clip;
                      this.aniDuration = clip.duration() * 1000;
                      let curTime = name == Huanqiang1 ? this.gun.gunCfg.gunSwitchTime : this.gun.gunCfg.reloadingTime;
                      this.animator.speed = this.aniDuration / curTime;
                  }
              }
          }
          else {
              if (this._aniType == name) {
                  return;
              }
              if (!this.isRole) {
                  this.animator.speed = name == this.gun.gunCfg.run_action ? this.aniSpeed : 1;
              }
              else {
                  this.animator.speed = 1;
              }
          }
          this.crossFade(name, duration, 0, name);
      }
      reload() {
          if (this.isRoleAttackState() &&
              this.gun.checkCanFire() &&
              this.gun.bulletCnt != this.gun.maxBulletCnt) {
              if (this.isUseVeh) {
                  this.gun.reset();
              }
              else {
                  this.fsm.changeState(FSMState.reload);
              }
          }
      }
      refreshAim() {
          DataMgr.instance.cameraCtrl.setSniping(false);
          EventMgr.event(EventType.onAim, true);
      }
      openFire(isOpen) {
          if (DataMgr.instance.isUpDownVehBeg)
              return;
          if (Utils.isEmpty(this.gun))
              return;
          if (this.isUseCom)
              return;
          if (this.fsm.isCurState(FSMState.UseBomb)) {
              if (!isOpen) {
                  EventMgr.event(EventType.Throw_Attack);
              }
              else {
                  EventMgr.event(EventType.Throw_AttackBegin);
              }
              DataMgr.instance.role.isBeginBomb = isOpen;
          }
          if (!this.fsm.isCurState(FSMState.Attack))
              return;
          if (this.isRoleAttackState() && this.gun.magazineNumber <= 0 && this.gun.bulletCnt <= 0) {
              if (DataMgr.nowTime - DataMgr.instance.showNoBulletTime >=
                  CfgDataMgr.instance.getGlobalCfg('ammunitionLackIntervalTime') * 1000) {
                  DataMgr.instance.showNoBulletTime = DataMgr.nowTime;
                  SoundMgr.playSound(SoundRoot + 'Gunempty.mp3');
                  DataMgr.instance.role.roleCtrl.refreshRocker();
                  EventMgr.event(EventType.ShowGetAmmoBox, true);
              }
              else {
                  UIMgr.showTips('子弹已经耗尽');
              }
              isOpen && DataMgr.instance.role.roleCtrl.refreshRocker();
          }
          this.gun.setFiring(isOpen && this.isRoleAttackState() && this.gun.checkCanFire());
      }
      onAim(isAim, isClick) {
          if (!this.isRoleAttackState() && isClick)
              return;
          if (this._isAim == isAim)
              return;
          this._isAim = isAim;
          if (this.gun.isHasScope()) {
              EventMgr.event(EventType.ShowSniping, [isAim]);
              DataMgr.instance.cameraCtrl.setSniping(isAim);
          }
          else {
              DataMgr.instance.cameraCtrl.setAim(isAim);
          }
          if (isClick) {
              this.isAimState = isAim;
          }
      }
      isRoleAttackState() {
          if (!this.fsm)
              return false;
          return this.fsm.isCurState(FSMState.Attack) || this.fsm.isCurState(FSMState.TankAttackState);
      }
      reviveInit() {
          this._isAim = false;
      }
      switchArms(index) {
          let isUseBomb = this.fsm.isCurState(FSMState.UseBomb);
          if ((isUseBomb && this.isBeginBomb) || (!this.isRoleAttackState() && !isUseBomb))
              return false;
          if (this._isCatapult)
              return false;
          if (this.isRoleAttackState() && this._gunIndex == index)
              return false;
          this._curSwitchGunIndex = index;
          this.grenade && (this.grenade.active = false);
          let cfg = CfgDataMgr.instance.gunAttributeCfg[this.gun.gunCfg.gunID];
          if (cfg) {
              this.fsm.changeState(FSMState.switchGun);
          }
          return true;
      }
      switchGunSucc(state = 0) {
          let gunIndex;
          if (state == 0) {
              gunIndex = this._gunIndex;
              this._gunIndex = this._curSwitchGunIndex;
          }
          else if (state == 1) {
              this._curGunIndex = this._gunIndex;
              gunIndex = this._gunIndex;
              this._gunIndex = this._skillGunIndex;
          }
          else if (state == 2) {
              gunIndex = this._skillGunIndex;
              this._gunIndex = this._curGunIndex;
          }
          this._gunArr[gunIndex].gameObject.active = false;
          this.setPlayerGun(this._gunIndex);
          this.gun.reset();
      }
      getNextGunCfg(state = 0) {
          let gun;
          if (state == 0) {
              let gunIndex = this._gunIndex;
              gunIndex++;
              gunIndex = gunIndex & 1;
              gun = this._gunArr[gunIndex];
          }
          else if (state == 1) {
              gun = this._gunArr[this._skillGunIndex];
          }
          else if (state == 2) {
              gun = this._gunArr[this._gunIndex];
          }
          return gun.gunCfg;
      }
      CannonGunSwitch(index) {
          if (this.gun.isHasCatapult || this._isCatapult) {
              if (this._isCatapult) {
                  this._catapultArr[this.gun.index].gameObject.active = false;
                  this.setPlayerGun(this.gun.index);
                  this._isCatapult = false;
              }
              else {
                  this._catapultArr[this.gun.index].gameObject.active = true;
                  this.gun.gameObject.active = false;
                  this.gun = this._catapultArr[this.gun.index];
                  this._isCatapult = true;
              }
          }
          else {
              this._gunIndex = index;
              this.setPlayerGun(this._gunIndex);
              this.gun.refreshVehShow();
              this.gun.reset();
          }
      }
      get isCatapult() {
          return this._isCatapult;
      }
      isVisible() {
          if (Utils.isEmpty(this.mesh) || Utils.isEmpty(this.mesh['_render']))
              return false;
          return this.mesh['_render'].isRender;
      }
      getHardStraightRatio(type) {
          if (this._isBeHit) {
              if (DataMgr.nowTime - this._beHitTime > 0) {
                  this._isBeHit = false;
              }
              else {
                  let time = (this._beHitTime - DataMgr.nowTime) / 1000;
                  let a = CfgDataMgr.instance.getGlobalCfg(type == 0 ? 'hitStiff_moveSpeed_a' : 'hitStiff_cornerSpeed_a');
                  let b = CfgDataMgr.instance.getGlobalCfg(type == 0 ? 'hitStiff_moveSpeed_b' : 'hitStiff_cornerSpeed_b');
                  return 1 - (a * Math.pow(time, 2) + b);
              }
          }
          return 1;
      }
      getRotateVal(rot) {
          return rot * this.getHardStraightRatio(1);
      }
      getMoveVal(move) {
          return move * this.getHardStraightRatio(0) * this.addSpeed();
      }
      addSpeed() {
          if (this.suprarenalCntTime > DataMgr.nowTime) {
              return this.suprarenalCnt;
          }
          return 1;
      }
      playReloadAni() {
          this.setRoleAni(this.gun.gunCfg.recharge_action);
          DataMgr.instance.playCfgSound(this.gun.gunCfg.soundEffectRecharge, this.transform.position);
      }
      playCameraAni(isWin) {
          if (!this.cameraAni)
              return;
          this.body_01 && (this.gun.gameObject.active = this.body_01.active = true);
          this.transform.localRotationEulerX = 0;
          if (!this.isUseVeh) {
              this._gunNodeR.addChild(this.gun.gameObject);
          }
          if (this.curType == curType.HuMan) {
              this.cameraAni.play(isWin ? 'Victory' : 'Fail');
              !this.isDead && this.crossFade(isWin ? 'Cheer' : 'Lose');
          }
          else if (this.curType == curType.Tank) {
              this.cameraAni.play('Finish');
          }
          else if (this.curType == curType.Air) {
              this.cameraAni.play(isWin ? 'Victory' : 'Fail');
          }
          this._isLockAction = true;
      }
      playCameraStand() {
          if (!this.cameraAni)
              return;
          if (!(this.curType == curType.Air)) {
              this.cameraAni.play('Idle');
          }
      }
      checkResidue(id) {
          if (DataMgr.instance.isTestGrenade) {
              return true;
          }
          if (this.isRole) {
              return true;
          }
          else {
              if (this._residue && this._residue[id]) {
                  let cnt = this._residue[id];
                  this._residue[id] = --cnt;
                  return true;
              }
          }
          return false;
      }
      createGunFun(index, gunCfg) {
          let self = this;
          let id = gunCfg.gunID;
          let gunType = gunCfg.gunType;
          let gun = SceneMgr.instance.getProp(gunType, gunCfg.gunModel);
          let sp = gun.owner;
          if (gunCfg.gunType == PropType.SniperRifle) {
              this._gunNodeL.addChild(sp);
          }
          else {
              this._gunNodeR.addChild(sp);
          }
          gun.setGunId(id, self, index);
          gun.owner.active = true;
          Utils.vec3ToTargetVal('localPosition', 1, sp);
          Utils.vec3ToTargetVal('localRotationEuler', 1, sp);
          return gun;
      }
      addGunNode(sp, gunCfg) {
          if (gunCfg.gunType == PropType.SniperRifle) {
              this._gunNodeL.addChild(sp);
          }
          else {
              this._gunNodeR.addChild(sp);
          }
      }
      get bombCnt() {
          for (let key in DataMgr.instance._trialGood) {
              let data = DataMgr.instance._trialGood[key];
              if (data[0] == 101201) {
                  DataMgr.instance._trialGood[key][1] = data[1] - 1;
                  return DataMgr.instance._trialGood[key][1];
              }
          }
          return 0;
      }
      isHasCatapult() {
          return this._isCatapult || this.gun.isHasCatapult;
      }
      setAmmoInfo() {
          for (let i = 0; i < 2; i++) {
              let gun = this._gunArr[i];
              let arr = new Array();
              arr.push(gun.bulletCnt);
              arr.push(gun.magazineNumber);
              this._curAmmo['gun_' + i] = arr;
          }
      }
      check() {
          if (this.aiCfg.automaticVehicle == 0)
              return;
          let self = this;
          let len = DataMgr.instance.props.length;
          for (let i = 0; i < len; i++) {
              let vehicle = DataMgr.instance.props[i];
              if (!vehicle.isTank || vehicle.isUseIng)
                  continue;
              let dis = Laya.Vector3.distance(vehicle.transform.position, self.transform.position);
              let curDis = !vehicle.isTank ? this._skinCfg.discernPlaneDis : self._skinCfg.discernTankDis;
              if (curDis >= dis) {
                  self.clear();
                  self.isUseVeh = true;
                  self.curType = curType.Tank;
                  vehicle.isUseIng = true;
                  self.curAiCfg = self.aiCfg;
                  self.aiCfg = CfgDataMgr.instance.professionCfg[vehicle.cfg.aiFormID];
                  self.setVeh(vehicle, -1, Laya.Handler.create(self, function () {
                      self.born();
                      self.fsm.changeState(FSMState.TankFindPathState);
                  }));
                  return;
              }
          }
      }
      TestMeshPointArr(pos1, pos2) {
          let vec = this.testGetRayPoint(pos1);
          Vector3Ex.ZERO.cloneTo(this._vec);
          vec && vec.cloneTo(this._vec);
          let vec1 = this.testGetRayPoint(pos2);
          Vector3Ex.ZERO.cloneTo(this._tempVec);
          vec1 && vec1.cloneTo(this._tempVec);
          if (Laya.Vector3.distance(this._vec, this._tempVec) > 0) {
              let arr = NavMgr.instance.onFindPath(this.getPlayerId(), this._vec, this._tempVec);
              if (arr) {
                  console.info(arr);
              }
          }
      }
      testGetRayPoint(pos) {
          let self = this;
          let origin = self._ray.origin;
          pos.cloneTo(origin);
          origin.y += 10;
          let direction = self._ray.direction;
          Vector3Ex.Down.cloneTo(direction);
          self._ray.origin = origin;
          self._ray.direction = direction;
          DataMgr.instance.scene.physicsSimulation.rayCastAll(self._ray, self._outHitInfoArr, 25);
          let len = self._outHitInfoArr.length;
          for (let i = 0; i < len; i++) {
              let out = this._outHitInfoArr[i];
              if (out.collider.owner.name == 'NavMesh') {
                  return out.point;
              }
          }
          return null;
      }
      refreshHeroModel(modelID) {
          this.setEnemyId(modelID, null);
      }
      drawLine(isShow) { }
  }
  Player.BLOOD_TIME = 800;

  class AirPlayer extends Player {
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class AntiTankPlayer extends Player {
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class ElitePlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class HitAirPlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class MachinePlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class MedicalPlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class RaiderPlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class RiflePlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class SpurtFirePlayer extends Player {
      constructor() {
          super();
          this._vec4 = new Laya.Vector4();
      }
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  class TankPlayer extends Player {
      onAwake() {
          super.onAwake();
      }
      clear() {
          super.clear();
      }
  }

  var Sprite3D$4 = Laya.Sprite3D;
  class PlayerMgr {
      constructor() {
          this._generateID = 0;
          this._refreshCnt = 0;
          this._curOurAIIndex = 0;
          this._curEnemyAIIndex = 0;
          this._birthPoint = new Laya.Vector3();
          this._vec = new Laya.Vector3();
          this._curIndex = 0;
          this._playerIDArr = [];
          EventMgr.on(EventType.StartCreateAI, this, this.startCreate);
      }
      static get instance() {
          if (PlayerMgr._instance == null) {
              PlayerMgr._instance = new PlayerMgr();
          }
          return PlayerMgr._instance;
      }
      startCreate() {
          let self = this;
          this.clear();
          Laya.timer.once(2000, this, function () {
              Utils.frameLoop(ModeMgr.instance.levelModelCfg.modeAIHostileNumber, 1, index => {
                  self.refreshAITimer(1, null);
              }, null);
          });
          Laya.timer.once(1000, this, function () {
              Utils.frameLoop(ModeMgr.instance.levelModelCfg.modeAIFriendlyNumber, 1, index => {
                  self.refreshAITimer(2, null);
              }, null);
          });
      }
      refreshAITimer(type, handler) {
          let self = this;
          let cfg = ModeMgr.instance.levelModelCfg;
          if (this.checkModeAIHostileNumber(type))
              return;
          this._refreshCnt++;
          let time = cfg.modeAIRefreshTime * 1000;
          let levelCfg = DataMgr.instance.levelCfg;
          Laya.timer.once(time, this, function () {
              if (type == 2) {
                  let len = levelCfg.ourAIID.length;
                  if (len <= self._curOurAIIndex) {
                      self._curOurAIIndex = 0;
                  }
                  self.createPlayer(type, levelCfg.ourAIID[self._curOurAIIndex], handler);
                  self._curOurAIIndex++;
              }
              else if (type == 1) {
                  let len = levelCfg.enemyAIID.length;
                  if (len <= self._curEnemyAIIndex) {
                      self._curEnemyAIIndex = 0;
                  }
                  self.createPlayer(type, levelCfg.enemyAIID[self._curEnemyAIIndex], handler);
                  self._curEnemyAIIndex++;
              }
          });
      }
      createPlayer(type, enemyId, handler, bornPos = null, state = FSMState.FindPath) {
          let self = this;
          let player = this.getPlayer(enemyId);
          player.setCamp(type == 1 ? PlayerCamp.Enemy : PlayerCamp.Teammate);
          player.setPlayerId(this.generateID);
          player.setDeadHandler(Laya.Handler.create(this, this.refreshAITimer, [type, null]));
          DataMgr.instance.addChildToRoot(player.owner);
          if (this._playerIDArr.length < 10) {
              this._playerIDArr.push(enemyId);
          }
          player.setEnemyId(enemyId, Laya.Handler.create(this, function () {
              player.gameObject.active = true;
              player.born(state);
              bornPos ? self.setBronPoint(bornPos) : self.getBronPoint(type);
              if (type == 1) {
                  DataMgr.instance._enemys.push(player);
              }
              else {
                  DataMgr.instance._players.push(player);
              }
              let pos = player.transform.position;
              self._birthPoint.cloneTo(pos);
              pos.y = DataMgr.instance.roleHeight;
              player.transform.position = pos;
              handler && handler.run();
          }));
      }
      get generateID() {
          return ++this._generateID;
      }
      clear() {
          this._generateID = 0;
          this._refreshCnt = 0;
          this._curOurAIIndex = 0;
          this._curEnemyAIIndex = 0;
          this._curIndex = 0;
      }
      setBronPoint(bornPos) {
          bornPos.cloneTo(this._birthPoint);
      }
      getBronPoint(type) {
          let cfg = CfgDataMgr.instance.spawnpointCfg;
          let detectrangeCfg = CfgDataMgr.instance.detectrangeCfg;
          let bronLen = Object.keys(cfg).length;
          let bronArr = [];
          for (let key in CfgDataMgr.instance.spawnpointCfg) {
              let data = CfgDataMgr.instance.spawnpointCfg[key];
              if (data.name.indexOf('spawnpoint') != -1) {
                  bronArr.push(CfgDataMgr.instance.spawnpointCfg[key]);
              }
          }
          bronLen = bronArr.length;
          let players = DataMgr.instance._players;
          let len = players.length;
          for (let i = bronLen - 2; i >= 0; i--) {
              let cfgPos = bronArr[i].position;
              this._vec.setValue(cfgPos[0], cfgPos[1], cfgPos[2]);
              for (let j = 0; j < len; j++) {
                  let player = players[j];
                  if (this.checkRange(player.transform.position, this._vec, detectrangeCfg[i].scale)) {
                      if (this._curIndex < i) {
                          this._curIndex = i;
                      }
                  }
              }
          }
          let curIndex = this._curIndex;
          if (type == 1) {
              curIndex++;
              bronLen - curIndex > 1 && (curIndex = (curIndex + Math.random() * (bronLen - curIndex)) | 0);
          }
          else if (this.checkEnemys(bronArr[curIndex].position)) {
              this._curIndex > 0 && this._curIndex--;
              curIndex = this._curIndex;
          }
          let cfgPos = bronArr[curIndex].position;
          this._birthPoint.setValue(cfgPos[0] - bronArr[curIndex].scale[0] / 2 + Math.random() * bronArr[curIndex].scale[0], cfgPos[1], cfgPos[2] - bronArr[curIndex].scale[2] / 2 + Math.random() * bronArr[curIndex].scale[2]);
      }
      checkRange(pos1, pos2, dis) {
          let x = Math.abs(pos1.x - pos2.x);
          let y = Math.abs(pos1.z - pos2.z);
          let a = dis[0] / 2;
          let b = dis[2] / 2;
          if (a > b) {
              if (Math.pow(x, 2) / Math.pow(a, 2) + Math.pow(y, 2) / Math.pow(b, 2) < 1)
                  return true;
          }
          else {
              if (Math.pow(y, 2) / Math.pow(a, 2) + Math.pow(x, 2) / Math.pow(b, 2) < 1)
                  return true;
          }
          return false;
      }
      checkModeAIHostileNumber(type) {
          let cfg = ModeMgr.instance.levelModelCfg;
          let arr = type == 1 ? DataMgr.instance._enemys : DataMgr.instance._players;
          let maxCnt = type == 1 ? cfg.modeAIHostileNumber : cfg.modeAIFriendlyNumber;
          let len = arr.length;
          let cnt = 0;
          for (let i = 0; i < len; i++) {
              if (!arr[i].isDead && !arr[i].isRolePlayer()) {
                  cnt++;
              }
          }
          return cnt >= maxCnt;
      }
      checkEnemys(pos) {
          let detectrangeCfg = CfgDataMgr.instance.detectrangeCfg;
          let enemys = DataMgr.instance._enemys;
          let len = enemys.length;
          for (let j = 0; j < len; j++) {
              let player = enemys[j];
              if (this.checkRange(player.transform.position, this._vec, detectrangeCfg[this._curIndex].scale)) {
                  return true;
              }
          }
          return false;
      }
      getPlayer(aiId) {
          let name = '' + aiId;
          let player = Laya.Pool.getItem(name);
          if (player == null) {
              let playerObj = new Sprite3D$4(name, false);
              if (aiId == 101) {
                  player = playerObj.addComponent(RiflePlayer);
              }
              else if (aiId == 201) {
                  player = playerObj.addComponent(ElitePlayer);
              }
              else if (aiId == 301) {
                  player = playerObj.addComponent(AntiTankPlayer);
              }
              else if (aiId == 401) {
                  player = playerObj.addComponent(HitAirPlayer);
              }
              else if (aiId == 501) {
                  player = playerObj.addComponent(MachinePlayer);
              }
              else if (aiId == 601) {
                  player = playerObj.addComponent(RaiderPlayer);
              }
              else if (aiId == 701) {
                  player = playerObj.addComponent(TankPlayer);
              }
              else if (aiId == 801) {
                  player = playerObj.addComponent(AirPlayer);
              }
              else if (aiId == 901) {
                  player = playerObj.addComponent(SpurtFirePlayer);
              }
              else if (aiId == 1001) {
                  player = playerObj.addComponent(MedicalPlayer);
              }
              else if (aiId == 1101 || aiId == 1102) {
                  player = playerObj.addComponent(TankPlayer);
              }
              else if (aiId == 1103 || aiId == 1104) {
                  player = playerObj.addComponent(AirPlayer);
              }
              else if (aiId == 1105 || aiId == 1106) {
                  player = playerObj.addComponent(TankPlayer);
              }
          }
          else {
              player.curType == curType.HuMan;
              player.clear();
          }
          return player;
      }
  }

  var Vector3$e = Laya.Vector3;
  class BaseMoveCtrl extends Laya.Script {
      constructor() {
          super();
          this.limitH = 0;
          this.moveArr = [];
          this._initViewLock = true;
          this._touchPos = new Laya.Point();
          this._lastPos = new Vector3$e(0, 0, -1);
          this._attackRot = new Vector3$e();
          this._temVec = new Laya.Vector3();
          this._temVec1 = new Laya.Vector3();
          this._vec = new Laya.Vector3();
          this._cameraTouchPos = new Laya.Point();
          this._tempPoint = new Laya.Point();
          this._curMoveSpeed = new Laya.Point(0, 0);
          this._canMove = true;
          this._minEulerX = 0;
          this._maxEulerX = 0;
          this._moveType = -1;
          this.angle = -1;
          this.radians = -1;
          this._curSpeed = 0;
          this._curTranslateSpeed = 0;
          this.cameraAngle = -1;
          this.cameraRadians = -1;
          this._rockerId = -1;
          this._rotateId = -1;
          this._radius = 80;
          this.speed = 0.5;
          this.isNeedMoveRocker = true;
          this.deltaX = 0;
          this.deltaY = 0;
          this._time = 0;
      }
      onAwake() {
          super.onAwake();
      }
      init(id) {
          this._role = DataMgr.instance.role;
          this._parentTr = this.owner.parent['transform'];
          this.ray = new Laya.Ray(new Laya.Vector3(0, 0, 0), new Laya.Vector3(0, -2, 0));
          Vector3Ex.Up.cloneTo(this.ray.direction);
          Laya.Vector3.scale(this.ray.direction, -1, this.ray.direction);
          this.outHitInfo = new Laya.HitResult();
          this._collisonGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER;
          this.collisionWith =
              Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1 ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2 ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER3;
          this.collisionWith1 =
              Laya.Physics3DUtils.COLLISIONFILTERGROUP_ALLFILTER ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER2 ^
                  Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1;
      }
      onUpdate() {
          super.onUpdate();
          if (!DataMgr.instance.isGamming())
              return;
          if (this._initViewLock)
              return;
          if (DataMgr.instance.isFTPc) {
              if (0 != this.deltaY || 0 != this.deltaX) {
                  this.onRotate();
              }
              else {
                  DataMgr.instance.cameraCtrl.huManRot.setValue(this._role.transform.localRotationEulerX, this._parentTr.localRotationEulerY);
              }
          }
          else {
              if (this._rotateId != -1) {
                  this.onRotate();
              }
              else {
                  DataMgr.instance.cameraCtrl.huManRot.setValue(this._role.transform.localRotationEulerX, this._parentTr.localRotationEulerY);
              }
          }
          this.deltaX = this.deltaY = 0;
          if (DataMgr.instance.checkIsKey() && DataMgr.instance.isRoleMove) {
              this.setRoleMove(this.setRoleAni());
          }
          else if (this._rockerId != -1 &&
              (this.isNeedMoveRocker ? this.angle != -1 : true) &&
              DataMgr.instance.isRoleMove) {
              this.setRoleMove(this.setRoleAni());
          }
          else if (this._role.isNeedRefresh) {
              this._role.setRoleAni(this._role.gun.gunCfg.stand_action);
              this._role.isNeedRefresh = false;
          }
      }
      stop(immediately = false) {
          this._attackRot.setValue(0, 0, 0);
      }
      regEvent(node) {
          if (this._eventNode)
              return;
          this._eventNode = node;
          if (DataMgr.instance.isFTPc) {
              this.unregEvent(false);
              node.on(Laya.Event.MOUSE_DOWN, this, this.onFTMouseDown);
              node.on(Laya.Event.MOUSE_UP, this, this.onFTMouseUp);
              node.on(Laya.Event.MOUSE_OUT, this, this.onFTMouseUp);
              EventMgr.on(EventType.changeRoleAngle, this, this.onMove1111);
          }
          else {
              node.on(Laya.Event.MOUSE_DOWN, this, this.onCMouseDown);
              node.on(Laya.Event.MOUSE_UP, this, this.onCMouseUp);
              node.on(Laya.Event.MOUSE_OUT, this, this.onCMouseUp);
          }
      }
      onFTMouseDown(e) {
          DataMgr.instance.role.openFire(true);
      }
      onFTMouseUp(e) {
          DataMgr.instance.role.openFire(false);
      }
      onMove1111(x, y) {
          this.deltaX = x;
          this.deltaY = y;
          this.amendRotate(this.deltaX, this.deltaY);
      }
      unregEvent(isLock = true) {
          if (!this._eventNode)
              return;
          this._eventNode.off(Laya.Event.MOUSE_DOWN, this, this.onCMouseDown);
          this._eventNode.off(Laya.Event.MOUSE_UP, this, this.onCMouseUp);
          this._eventNode.off(Laya.Event.MOUSE_OUT, this, this.onCMouseUp);
          this._eventNode.off(Laya.Event.MOUSE_DOWN, this, this.onFTMouseDown);
          this._eventNode.off(Laya.Event.MOUSE_UP, this, this.onFTMouseUp);
          this._eventNode.off(Laya.Event.MOUSE_OUT, this, this.onFTMouseUp);
          EventMgr.off(EventType.changeRoleAngle, this, this.onMove1111);
          this._initViewLock = isLock;
      }
      onDestroy() {
          super.onDestroy();
          this.unregEvent();
          this._role = null;
          this._parentTr = null;
          this._eventNode = null;
          this._touchPos = null;
          this._lastPos = null;
          this._attackRot = null;
          this._temVec = null;
          this._vec = null;
          this._cameraTouchPos = null;
          this._tempPoint = null;
          this.originPiont = null;
          this.cameraOriginPiont = null;
          this._curMoveSpeed = null;
          this.ray = null;
          this.outHitInfo = null;
      }
      clear() {
          this._rotateId = -1;
          this._rockerId = -1;
      }
      setRockMove(originPiont, touchPos, isMove, rocker) {
          let self = this;
          let locationPos = rocker.globalToLocal(touchPos, false);
          let deltaX = locationPos.x - originPiont.x;
          let deltaY = locationPos.y - originPiont.y;
          let dx = deltaX * deltaX;
          let dy = deltaY * deltaY;
          let angle = (Math.atan2(deltaX, deltaY) * 180) / Math.PI;
          if (angle < 0)
              angle += 360;
          angle = Math.round(angle);
          let radians = (Math.PI / 180) * angle;
          if (dx + dy >= self._radius * self._radius) {
              let x = Math.floor(Math.sin(radians) * self._radius + originPiont.x);
              let y = Math.floor(Math.cos(radians) * self._radius + originPiont.y);
              EventMgr.event(EventType.RefreshKnobPos, [x, y, false, isMove]);
          }
          else {
              EventMgr.event(EventType.RefreshKnobPos, [locationPos.x, locationPos.y, false, isMove]);
          }
          if (isMove) {
              self.radians = radians;
              self.angle = angle;
          }
          else {
              self.cameraRadians = radians;
              self.cameraAngle = angle;
          }
      }
      onCMouseDown(e) {
          let self = this;
          if (this._role.isDead)
              return;
          let moveRocker = function (index) {
              self._rockerId = index;
              EventMgr.event(EventType.RefreshRockerPos, [self._tempPoint, true]);
              EventMgr.event(EventType.CheckRockerClick, [self._tempPoint.x, self._tempPoint.y, true]);
              DataMgr.instance.isStand = false;
          };
          let moveCamera = function (index) {
              self._rotateId = index;
              self._lastPos.setValue(self._tempPoint.x, self._tempPoint.y, 0);
              EventMgr.event(EventType.CheckFireClick, [self._tempPoint.x, self._tempPoint.y, true]);
              EventMgr.event(EventType.RefreshRockerPos, [self._tempPoint, false]);
          };
          let w = (Laya.stage.width * 5) / 17;
          let h = (Laya.stage.height * 6) / 13;
          let touches = e.touches;
          if (touches && touches.length > 0) {
              let len = e.touches.length;
              for (let i = 0; i < len; i++) {
                  if (this.isNeedMoveRocker &&
                      touches[i].stageX <= w &&
                      touches[i].stageY >= h &&
                      this._rockerId == -1) {
                      this._tempPoint.setTo(touches[i].stageX, touches[i].stageY);
                      moveRocker(touches[i].identifier);
                  }
                  else if ((this.isNeedMoveRocker
                      ? true
                      : this.checkDownPos(touches[i].stageX, touches[i].stageY)) &&
                      touches[i].identifier != this._rockerId &&
                      this._rotateId == -1 &&
                      touches[i].identifier != DataMgr.instance.touchID) {
                      this._tempPoint.setTo(touches[i].stageX, touches[i].stageY);
                      moveCamera(touches[i].identifier);
                  }
              }
          }
          else {
              if (this.isNeedMoveRocker && e.stageX <= w && e.stageY >= h && this._rockerId == -1) {
                  this._tempPoint.setTo(e.stageX, e.stageY);
                  moveRocker(e.touchId);
              }
              else if ((this.isNeedMoveRocker ? true : this.checkDownPos(e.stageX, e.stageY)) &&
                  e.touchId != this._rockerId &&
                  this._rotateId == -1 &&
                  e.touchId != DataMgr.instance.touchID) {
                  this._tempPoint.setTo(e.stageX, e.stageY);
                  moveCamera(e.touchId);
              }
          }
          if (this._rotateId != -1 || (this.isNeedMoveRocker ? this._rockerId != -1 : true)) {
              Laya.stage.off(Laya.Event.MOUSE_MOVE, this, this.onMove);
              Laya.stage.on(Laya.Event.MOUSE_MOVE, this, this.onMove);
          }
      }
      onCMouseUp(e, isRefresh = false) {
          let self = this;
          let moveMouseUp = function () {
              self._rockerId = self.radians = self.angle = self._moveType = -1;
              if (!(self._role.fsm.isCurState(FSMState.UseBomb) ||
                  self._role.fsm.isCurState(FSMState.reload) ||
                  self._role.fsm.isCurState(FSMState.switchGun))) {
                  self._role.setRoleAni(self._role.gun.gunCfg.stand_action);
              }
              DataMgr.instance.isStand = true;
              EventMgr.event(EventType.RefreshKnobPos, [0, 0, true, true]);
              self._curMoveSpeed.setTo(0, 0);
              EventMgr.event(EventType.CheckRockerClick, [0, 0, false]);
          };
          let cameraMouseUp = function () {
              self.stop(false);
              self._rotateId = -1;
              EventMgr.event(EventType.RefreshKnobPos, [0, 0, true, false]);
              EventMgr.event(EventType.CheckFireClick, [0, 0, false]);
          };
          if (isRefresh) {
              moveMouseUp();
              cameraMouseUp();
              return;
          }
          if (this._role.isDead)
              return;
          let points = e.touches;
          let isExit = 0;
          if (points && points.length > 0) {
              let len = points.length;
              for (let i = 0; i < len; i++) {
                  if (e.touchId == self._rockerId) {
                      isExit += 1;
                  }
                  else if (e.touchId == self._rotateId) {
                      isExit += 2;
                  }
              }
              if (isExit == 0)
                  return;
          }
          else {
              if (e.touchId == self._rockerId) {
                  isExit += 1;
              }
              else if (e.touchId == self._rotateId) {
                  isExit += 2;
              }
          }
          if (isExit == 1) {
              moveMouseUp();
          }
          else if (isExit == 2) {
              cameraMouseUp();
          }
          else if (isExit > 2) {
              moveMouseUp();
              cameraMouseUp();
          }
          if (self._rotateId == -1 && (self.isNeedMoveRocker ? self._rockerId == -1 : true)) {
              Laya.stage.off(Laya.Event.MOUSE_MOVE, self, self.onMove);
          }
      }
      onMove(e) {
          let curTime = DataMgr.nowTime;
          if (curTime - this._time < 8) {
              return;
          }
          this._time = curTime;
          let points = e.touches;
          let self = this;
          let cameraMove = function () {
              if (self._lastPos.z == -1) {
                  self._lastPos.x = self._cameraTouchPos.x;
                  self._lastPos.y = self._cameraTouchPos.y;
                  self._lastPos.z = 0;
              }
              self.deltaX = self._cameraTouchPos.x - self._lastPos.x;
              self.deltaY = self._cameraTouchPos.y - self._lastPos.y;
              self.amendRotate(self.deltaX, self.deltaY);
              self._lastPos.x = self._cameraTouchPos.x;
              self._lastPos.y = self._cameraTouchPos.y;
              if (self._role.gun && DataMgr.instance.isFireId == 1) {
                  self.setRockMove(self.cameraOriginPiont, self._cameraTouchPos, false, DataMgr.instance.cameraRocker);
              }
          };
          let roleMove = function () {
              if (DataMgr.instance.isRoleMove) {
                  self.setRockMove(self.originPiont, self._touchPos, true, DataMgr.instance.rocker);
              }
          };
          let isExit = 0;
          if (points && points.length > 0) {
              let len = points.length;
              for (let i = 0; i < len; i++) {
                  let touch = points[i].identifier;
                  if (touch == this._rotateId) {
                      isExit += 1;
                      this._cameraTouchPos.setTo(points[i].stageX, points[i].stageY);
                  }
                  else if (touch == this._rockerId) {
                      isExit += 2;
                      this._touchPos.setTo(points[i].stageX, points[i].stageY);
                  }
              }
          }
          else {
              if (e.touchId == this._rotateId) {
                  isExit += 1;
                  this._cameraTouchPos.setTo(e.stageX, e.stageY);
              }
              else if (e.touchId == this._rockerId) {
                  this._touchPos.setTo(e.stageX, e.stageY);
                  isExit += 2;
              }
          }
          if (isExit == 1) {
              cameraMove();
          }
          else if (isExit == 2) {
              roleMove();
          }
          else if (isExit > 2) {
              cameraMove();
              roleMove();
          }
      }
      setTurretRotate() { }
      setRoleAni() {
          return 0;
      }
      amendRotate(deltaX, deltaY) { }
      onRotate() { }
      setRoleMove(moveType) { }
      refreshRocker() {
          this.onCMouseUp(null, true);
      }
      drawLine(isShow) { }
      checkMaxAngle() {
          return false;
      }
      moveDown(index) {
          if (this._role.curType == curType.HuMan) {
              this._rockerId = 112111;
              DataMgr.instance.isRoleMove = true;
          }
      }
      moveUp(index) {
          if (this._role.curType == curType.HuMan) {
              if (!DataMgr.instance.checkIsKey()) {
                  this._rockerId = -1;
                  DataMgr.instance.isRoleMove = false;
              }
          }
      }
      checkDownPos(x, y) {
          return true;
      }
      getAngleClamp(x) {
          return x;
      }
      getMinEulerX() {
          return this._minEulerX;
      }
      getOutCarPoint() {
          return null;
      }
  }

  var Vector3$f = Laya.Vector3;
  class AirMoveCtrl extends BaseMoveCtrl {
      constructor() {
          super();
          this._viewPos = new Laya.Vector2();
          this.curAngle = new Laya.Vector3();
          this._addAngleR = 0.1;
          this._addAngleB = 0.1;
          this._angleR = 10;
          this._angleB = 6;
          this.m_LookAngle = 0;
          this._lastRot = new Laya.Quaternion();
          this._nextRot = new Laya.Quaternion();
          this.MaxAngle = 60;
      }
      onAwake() {
          super.onAwake();
      }
      onDestroy() {
          super.onDestroy();
          Laya.timer.clear(this, this.airRotator);
          this.moveArr.length = 0;
      }
      onUpdate() {
          if (!DataMgr.instance.isPhase(EGamePhase.InGame))
              return;
          if (this._role == null || this._role.isDead || !this._role._skinCfg)
              return;
          super.onUpdate();
          if (this._rockerId == -1) {
              if (this._model) {
                  this._model.localRotationEulerX = MathUtils.SmoothStep(this._model.localRotationEulerX, 0, 0.1);
                  this._model.localRotationEulerZ = MathUtils.SmoothStep(this._model.localRotationEulerZ, 0, 0.1);
                  this.curAngle.setValue(this._model.localRotationEulerX, 0, this._model.localRotationEulerZ);
              }
          }
          this.setAirframeRotate();
          if (this._rockerId != -1 &&
              (this.isNeedMoveRocker ? this.angle != -1 : true) &&
              DataMgr.instance.isRoleMove) {
              DataMgr.instance.tankSpeed = (Math.abs(this._curSpeed) * 1000) | 0;
          }
          else {
              DataMgr.instance.tankSpeed = 0;
              this._curSpeed = 0;
          }
      }
      clear() {
          super.clear();
          this.m_LookAngle = 0;
      }
      init(id) {
          super.init(id);
          this.isNeedMoveRocker = false;
          this._tankCfg = CfgDataMgr.instance.vehicleCfg[id];
          this._vehRotateInterval = this._tankCfg.vehRotateInterval;
          this.limitH = this._tankCfg.crossHeight;
          this.MaxAngle = this._tankCfg.vehGunVeerInterval_horizontal[1];
          DataMgr.instance.cameraCtrl.setTankVerticalLimit(this._tankCfg.vehGunVeerInterval_vertical[0], this._tankCfg.vehGunVeerInterval_vertical[1]);
          this._vehRotSpeed = this._tankCfg.vehTurrutFollowSpeed;
          this._rotator_Tail = ExUtils.findChild(this._role.gameObject, 'Rotator_Tail');
          this._rotator_Top = ExUtils.findChild(this._role.gameObject, 'Rotator_Top');
          let gun = ExUtils.findChild(this._role.gameObject, 'RotatorGunA');
          if (gun)
              this._rotatorGun = gun.transform;
          Laya.timer.frameLoop(1, this, this.airRotator);
          let obj = this._parentTr.owner.getChildAt(0);
          this._model = obj.getChildAt(0).transform;
          this._tankForwardR = this._tankCfg.checkPos[2];
          this._tankForwardM = this._tankCfg.checkPos[1];
          this._tankBackM = this._tankCfg.checkPos[0];
          let arr = ExUtils.getAllComponentsInChild(this._role.gameObject, Laya.PhysicsCollider);
          let len = arr.length;
          for (let i = 0; i < len; i++) {
              arr[i].collisionGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1;
          }
      }
      airRotator() {
          if (!DataMgr.instance.isGamming()) {
              Laya.timer.clear(this, this.airRotator);
          }
          else {
              this._rotator_Tail && (this._rotator_Tail.transform.localRotationEulerX -= 20);
              this._rotator_Top && (this._rotator_Top.transform.localRotationEulerY -= 20);
          }
      }
      onRotate() {
          if (this._role._isAim) {
          }
          else {
              DataMgr.instance.cameraCtrl.setTurretRotate(this._attackRot);
          }
          Vector3Ex.ZERO.cloneTo(this._attackRot);
      }
      amendRotate(deltaX, deltaY) {
          let self = this;
          let x = deltaY * this._tankCfg.vehGunVeerSpeed_horizontal * DataMgr.FixedDeltaTime;
          let y = deltaX * this._tankCfg.vehGunVeerSpeed_vertical * DataMgr.FixedDeltaTime;
          self._attackRot.setValue(x, y, 0);
      }
      setRoleMove() {
          let self = this;
          if (this.isBack) {
              this._curSpeed += this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > this._tankCfg.vehBackwardSpeed
                      ? this._tankCfg.vehBackwardSpeed
                      : this._curSpeed;
              this._parentTr.getForward(this._vec);
              Laya.Vector3.scale(this._vec, this._role.getMoveVal(this._curSpeed * DataMgr.FixedDeltaTime * 1000), this._vec);
          }
          else if (this.isForward) {
              this._curSpeed -= this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > -this._tankCfg.vehForwardSpeed
                      ? this._curSpeed
                      : -this._tankCfg.vehForwardSpeed;
              this._parentTr.getForward(this._vec);
              Laya.Vector3.scale(this._vec, this._role.getMoveVal(this._curSpeed * DataMgr.FixedDeltaTime * 1000), this._vec);
          }
          else if (this.isRight) {
              this._curSpeed -= this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > -this._tankCfg.vehForwardSpeed
                      ? this._curSpeed
                      : -this._tankCfg.vehForwardSpeed;
              this._parentTr.getRight(this._vec);
              Laya.Vector3.scale(this._vec, this._role.getMoveVal(this._curSpeed * DataMgr.FixedDeltaTime * 1000), this._vec);
          }
          else if (this.isLeft) {
              this._curSpeed -= this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > -this._tankCfg.vehForwardSpeed
                      ? this._curSpeed
                      : -this._tankCfg.vehForwardSpeed;
              this._parentTr.getRight(this._vec);
              Laya.Vector3.scale(this._vec, -1, this._vec);
              Laya.Vector3.scale(this._vec, this._role.getMoveVal(this._curSpeed * DataMgr.FixedDeltaTime * 1000), this._vec);
          }
          this._parentTr.position.cloneTo(this._temVec);
          Laya.Vector3.add(this._vec, this._temVec, this._temVec);
          let rayOrigin = this.ray.origin;
          let direction = this.ray.direction;
          this._temVec.cloneTo(rayOrigin);
          rayOrigin.y += 1.8 + this.limitH;
          this.ray.origin = rayOrigin;
          let isSuc = false;
          let checkFun = function (dis, attribute, val) {
              if (isSuc)
                  return;
              self._parentTr[attribute](self._vec);
              Laya.Vector3.scale(self._vec, val, self._vec);
              self._vec.cloneTo(direction);
              self.ray.direction = direction;
              DataMgr.instance.scene.physicsSimulation.rayCast(self.ray, self.outHitInfo, dis, self._collisonGroup, self.collisionWith);
              if (self.outHitInfo.succeeded) {
                  isSuc = true;
              }
          };
          checkFun(this._tankBackM, 'getForward', -1);
          checkFun(this._tankForwardM, 'getForward', 1);
          checkFun(this._tankForwardR, 'getRight', 1);
          checkFun(this._tankForwardR, 'getRight', -1);
          if (isSuc)
              return;
          if (Laya.Vector3.scalarLength(this._temVec) < 180) {
              Utils.vec3ToTargetVal('position', 1, this._parentTr.owner, this._temVec);
          }
      }
      setTurretRotate() {
          if (this._rotatorGun) {
              this._viewPos.setValue(Laya.stage.width / 2, Laya.stage.height / 2);
              this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
              this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
              DataMgr.instance.cameraCtrl.camera.viewportPointToRay(this._viewPos, this.ray);
              DataMgr.instance.scene.physicsSimulation.rayCast(this.ray, this.outHitInfo, this._role.gun.RAY_DIST);
              if (this.outHitInfo.succeeded) {
                  this.outHitInfo.point.cloneTo(this._vec);
              }
              else {
                  Vector3$f.scale(this.ray.direction, this._role.gun.RAY_DIST, this._vec);
                  Vector3$f.add(this.ray.origin, this._vec, this._vec);
              }
              ExUtils.LayaLookAt(this._rotatorGun, this._vec);
              DataMgr.instance.tankRot = this._rotatorGun.localRotationEulerY;
          }
      }
      checkMaxAngle() {
          DataMgr.instance.cameraCtrl.camera.transform.position.cloneTo(this._vec);
          this._parentTr.getForward(this._temVec1);
          this._vec.y = this._parentTr.position.y;
          Laya.Vector3.scale(this._temVec1, -1, this._temVec1);
          Laya.Vector3.subtract(this._vec, this._parentTr.position, this._vec);
          Laya.Vector3.scale(this._vec, -1, this._vec);
          Laya.Vector3.normalize(this._vec, this._vec);
          let r = Laya.Vector3.dot(this._vec, this._temVec1);
          r = (Math.acos(r) / Math.PI) * 180;
          return r > this.MaxAngle;
      }
      moveDown(index) {
          let curIndex = this.moveArr.indexOf(index);
          if (this._rockerId == -1) {
              this.moveArr.push(index);
              this._rockerId = 112111;
              DataMgr.instance.isRoleMove = true;
          }
      }
      moveUp(index) {
          let curIndex = this.moveArr.indexOf(index);
          if (curIndex != -1) {
              this.moveArr.splice(curIndex, 1);
              if (this.moveArr.length == 0) {
                  this._rockerId = -1;
                  DataMgr.instance.isRoleMove = false;
              }
          }
      }
      get isRight() {
          return this.moveArr.indexOf(0) > -1;
      }
      get isLeft() {
          return this.moveArr.indexOf(1) > -1;
      }
      get isBack() {
          return this.moveArr.indexOf(3) > -1;
      }
      get isForward() {
          return this.moveArr.indexOf(2) > -1;
      }
      checkDownPos(x, y) {
          let clickX;
          let clickY;
          let r;
          for (let i = 0, len = DataMgr.instance.airMoveArr.length; i < len; i++) {
              let arr = DataMgr.instance.airMoveArr[i];
              clickX = arr[0] - x;
              clickY = arr[1] - y;
              r = arr[2];
              if (Math.pow(clickX, 2) + Math.pow(clickY, 2) <= Math.pow(r, 2)) {
                  return false;
              }
          }
          let ui = UIMgr.findUI(EUI.GameView);
          if (ui) {
              let _point = new Laya.Point();
              _point.setTo(ui['airBox'].width / 2, ui['airBox'].height / 2);
              ui['airBox'].localToGlobal(_point);
              clickX = _point.x - x;
              clickY = _point.y - y;
              r = ui['airBox'].width * ui['airBox'].scaleX;
              if (Math.pow(clickX, 2) + Math.pow(clickY, 2) <= Math.pow(r, 2)) {
                  return false;
              }
          }
          return true;
      }
      getOutCarPoint() {
          let self = this;
          let origin = self.ray.origin;
          let direction = self.ray.direction;
          this._parentTr.position.cloneTo(origin);
          Vector3Ex.Down.cloneTo(direction);
          origin.y += 10;
          self.ray.origin = origin;
          self.ray.direction = direction;
          DataMgr.instance.scene.physicsSimulation.rayCast(self.ray, self.outHitInfo, this._role.gun.RAY_DIST, self._collisonGroup, self.collisionWith);
          if (self.outHitInfo.succeeded && self.outHitInfo.collider.owner.name == 'NavMesh') {
              this._parentTr.position.cloneTo(this._vec);
              let isGet = false;
              let func = function (attribute, val) {
                  self._parentTr[attribute](self._temVec);
                  Laya.Vector3.scale(self._temVec, val, self._temVec);
                  Laya.Vector3.add(self._temVec, self._vec, self._temVec);
                  self._temVec.cloneTo(origin);
                  origin.y += 3;
                  self.ray.origin = origin;
                  DataMgr.instance.scene.physicsSimulation.rayCast(self.ray, self.outHitInfo, 50, self._collisonGroup, self.collisionWith);
                  if (self.outHitInfo.succeeded && self.outHitInfo.collider.owner.name == 'NavMesh') {
                      self.outHitInfo.point.cloneTo(self._temVec1);
                      isGet = true;
                  }
              };
              func('getForward', 10);
              if (isGet)
                  return self._temVec1;
              func('getForward', -10);
              if (isGet)
                  return self._temVec1;
              func('getRight', 10);
              if (isGet)
                  return self._temVec1;
              func('getRight', -10);
              if (isGet)
                  return self._temVec1;
          }
          return null;
      }
      setAirframeRotate() {
          let cameraCtrl = DataMgr.instance.cameraCtrl;
          this._viewPos.setValue(Laya.stage.width / 2, Laya.stage.height / 2);
          this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
          this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
          cameraCtrl.camera.viewportPointToRay(this._viewPos, this.ray);
          this._parentTr.rotation.cloneTo(this._lastRot);
          this._lastRot.getYawPitchRoll(this._vec);
          Laya.Quaternion.createFromYawPitchRoll(this._vec.x, 0, 0, this._lastRot);
          Laya.Vector3.scale(this.ray.direction, 50, this._vec);
          Laya.Vector3.add(this.ray.origin, this._vec, this._vec);
          ExUtils.LayaLookAt(this._parentTr, this._vec, false, true);
          this._parentTr.rotation.cloneTo(this._nextRot);
          this._nextRot.getYawPitchRoll(this._vec);
          Laya.Quaternion.createFromYawPitchRoll(this._vec.x, 0, 0, this._nextRot);
          Laya.Quaternion.lerp(this._lastRot, this._nextRot, this._vehRotSpeed, this._lastRot);
          let rot = this._parentTr.rotation;
          this._lastRot.cloneTo(rot);
          this._parentTr.rotation = rot;
      }
  }

  class RoleCtrl extends BaseMoveCtrl {
      constructor() {
          super();
          this.stopIndex = 0;
          this.stopCnt = 30;
          this.balls = [];
          this._outHitInfoArr = [];
          this.vec = new Laya.Vector3();
          this.vec1 = new Laya.Vector3();
          this.vec2 = new Laya.Vector3();
          this._gravity = new Laya.Vector3(0, -9.8, 0);
          this._dir = new Laya.Vector3();
          this._viewPos = new Laya.Vector2();
          this._ray = new Laya.Ray(new Laya.Vector3(0, 0, 0), new Laya.Vector3(0, 0, 0));
          this.sp = new Laya.Sprite3D();
      }
      onAwake() {
          super.onAwake();
          DataMgr.instance.addChildToRoot(this.sp);
          for (let i = 0; i < 80; i++) {
              let ball = SceneMgr.instance.getPrefab('SightingLine');
              this.balls.push(ball);
              DataMgr.instance.addChildToRoot(ball);
              ball.active = false;
          }
      }
      onDestroy() {
          super.onDestroy();
      }
      init(id) {
          super.init(id);
          this._roleRatio = {};
          this._roleRatio.roleAngularSpeed = this._role.gun.gunCfg.gunVeerSpeed_horizontal;
          this._roleRatio.roleMoveMaxSpeed = this._role._skinCfg.roleMoveMaxSpeed;
          this._roleRatio.roleMoveDeltSpeed = this._role._skinCfg.roleMoveDeltSpeed;
          this._roleRatio.roleStopDeltSpeed = this._role._skinCfg.roleStopDeltSpeed;
          this.speed = this._roleRatio.roleMoveMaxSpeed;
          this._minEulerX = -60;
          this._maxEulerX = 40;
      }
      getAngleClamp(x) {
          return MathUtils.Clamp(x, this._minEulerX, this._maxEulerX);
      }
      onUpdate() {
          if (this._role == null || this._role.isDead || !this._role._skinCfg)
              return;
          super.onUpdate();
          if (this._rockerId == -1) {
              this.stopIndex = 0;
          }
          else {
              this.stopIndex++;
              if (this.stopIndex > this.stopCnt && DataMgr.instance.isGamming()) {
                  this.stopIndex -= this.stopCnt;
                  let soundArr = ['FootStep_01', 'FootStep_02', 'FootStep_03'];
                  let sound;
                  sound = SoundRoot + soundArr[(Math.random() * soundArr.length) | 0] + '.mp3';
                  SoundMgr.playSound(sound, 1);
              }
          }
          if (this._role.isBeginBomb) {
              this.drawLine(true);
          }
      }
      onRotate() {
          let x = this._role.getRotateVal(this._attackRot.x);
          let y = this._role.getRotateVal(this._attackRot.y);
          let valX = 1;
          let valY = 1;
          if (DataMgr.instance.isViscous) {
              valX =
                  Math.abs(x) /
                      (CfgDataMgr.instance.getGlobalCfg('frontSightPalstanceChange_a') + Math.abs(x)) +
                      CfgDataMgr.instance.getGlobalCfg('frontSightPalstanceChange_b');
              valY =
                  Math.abs(y) /
                      (CfgDataMgr.instance.getGlobalCfg('frontSightPalstanceChange_a') + Math.abs(y)) +
                      CfgDataMgr.instance.getGlobalCfg('frontSightPalstanceChange_b');
              valX = MathUtils.Clamp(valX, 0, 1);
              valY = MathUtils.Clamp(valY, 0, 1);
          }
          x *= valX;
          y *= valY;
          x = this._role.transform.localRotationEulerX + x;
          y = this._parentTr.localRotationEulerY - y;
          x = this.getAngleClamp(x);
          DataMgr.instance.cameraCtrl.huManRot.setValue(x, y);
          this._attackRot.setValue(0, 0, 0);
      }
      amendRotate(deltaX, deltaY) {
          let self = this;
          let RotX = 1;
          let RotY = 1;
          if (this._role._isAim) {
              RotX = RotY = CfgDataMgr.instance.getGlobalCfg('aimCamRotaMultiplier');
          }
          let x = deltaY * this._roleRatio.roleAngularSpeed * DataMgr.FixedDeltaTime * RotX;
          let y = deltaX * this._roleRatio.roleAngularSpeed * DataMgr.FixedDeltaTime * RotY;
          self._attackRot.setValue(x, y, 0);
      }
      setRoleAni() {
          let val = 15;
          let moveType = 0;
          if ((this.angle > val && this.angle <= 90 - val) ||
              (DataMgr.instance.keyBoardD && DataMgr.instance.keyBoardS)) {
              moveType = 1;
          }
          else if ((this.angle > 90 + val && this.angle <= 180 - val) ||
              (DataMgr.instance.keyBoardD && DataMgr.instance.keyBoardW)) {
              moveType = 3;
          }
          else if ((this.angle > 180 + val && this.angle <= 270 - val) ||
              (DataMgr.instance.keyBoardA && DataMgr.instance.keyBoardW)) {
              moveType = 5;
          }
          else if ((this.angle > 270 + val && this.angle <= 360 - val) ||
              (DataMgr.instance.keyBoardA && DataMgr.instance.keyBoardS)) {
              moveType = 7;
          }
          else if ((this.angle > 90 - val && this.angle <= 90 + val) || DataMgr.instance.keyBoardD) {
              moveType = 2;
          }
          else if ((this.angle > 180 - val && this.angle <= 180 + val) || DataMgr.instance.keyBoardW) {
              moveType = 4;
          }
          else if ((this.angle > 270 - val && this.angle <= 270 + val) || DataMgr.instance.keyBoardA) {
              moveType = 6;
          }
          else if (this.angle > 360 - val || this.angle <= val || DataMgr.instance.keyBoardS) {
          }
          if (!this._role.isNeedRefresh) {
              if (this._moveType == moveType)
                  return moveType;
          }
          if (this._role.fsm.isCurState(FSMState.UseBomb) ||
              this._role.fsm.isCurState(FSMState.reload) ||
              this._role.fsm.isCurState(FSMState.switchGun)) {
              this._moveType = moveType;
              return moveType;
          }
          this._moveType = moveType;
          this._role.setRoleAni(this._role.gun.gunCfg.walk_action);
          this._role.isNeedRefresh = false;
          return moveType;
      }
      setRoleMove(moveType) {
          let speedX = this._moveType == 2
              ? -this._roleRatio.roleMoveDeltSpeed
              : this._moveType == 6
                  ? this._roleRatio.roleMoveDeltSpeed
                  : this._moveType == 7 || this._moveType == 5
                      ? this._roleRatio.roleMoveDeltSpeed / 2
                      : this._moveType == 1 || this._moveType == 3
                          ? -this._roleRatio.roleMoveDeltSpeed / 2
                          : 0;
          let speedZ = this._moveType == 0
              ? -this._roleRatio.roleMoveDeltSpeed
              : this._moveType == 4
                  ? this._roleRatio.roleMoveDeltSpeed
                  : this._moveType == 3 || this._moveType == 5
                      ? this._roleRatio.roleMoveDeltSpeed / 2
                      : this._moveType == 1 || this._moveType == 7
                          ? -this._roleRatio.roleMoveDeltSpeed / 2
                          : 0;
          this._curMoveSpeed.setTo(this._curMoveSpeed.x + speedX, this._curMoveSpeed.y + speedZ);
          let maxX = (speedX / this._roleRatio.roleMoveDeltSpeed) * this._roleRatio.roleMoveMaxSpeed;
          let maxZ = (speedZ / this._roleRatio.roleMoveDeltSpeed) * this._roleRatio.roleMoveMaxSpeed;
          maxX = Math.abs(maxX) - Math.abs(this._curMoveSpeed.x) > 0 ? this._curMoveSpeed.x : maxX;
          maxZ = Math.abs(maxZ) - Math.abs(this._curMoveSpeed.y) > 0 ? this._curMoveSpeed.y : maxZ;
          this._curMoveSpeed.setTo(maxX, maxZ);
          let moveX = 1;
          let moveZ = 1;
          if (this._role._isAim) {
              moveX = moveZ = CfgDataMgr.instance.getGlobalCfg('aimMoveSpeedMultiplier');
          }
          if (this._role.fsm.isCurState(FSMState.reload)) {
              moveX = moveZ = CfgDataMgr.instance.getGlobalCfg('reloadMoveSpeedMultiplier');
          }
          maxZ = maxZ * moveZ;
          maxX = maxX * moveX;
          this._parentTr.getRight(this._temVec);
          Laya.Vector3.scale(this._temVec, this._role.getMoveVal(maxX * DataMgr.FixedDeltaTime * 1000), this._temVec);
          this._parentTr.getForward(this._vec);
          Laya.Vector3.scale(this._vec, -this._role.getMoveVal(maxZ * DataMgr.FixedDeltaTime * 1000), this._vec);
          if (this._moveType % 2 == 0) {
              if (this._moveType == 0 || this._moveType == 4) {
                  this._vec.cloneTo(this._temVec);
              }
          }
          else {
              Laya.Vector3.add(this._vec, this._temVec, this._temVec);
          }
          this._temVec.cloneTo(this.vec2);
          let rayOrigin = this.ray.origin;
          this._temVec.cloneTo(this._vec);
          Laya.Vector3.scale(this._vec, 10, this._vec);
          Laya.Vector3.add(this._parentTr.position, this._vec, rayOrigin);
          let height = 20;
          rayOrigin.y += height;
          this.ray.origin = rayOrigin;
          let direction = this.ray.direction;
          Vector3Ex.Down.cloneTo(direction);
          this.ray.direction = direction;
          this._outHitInfoArr.length = 0;
          DataMgr.instance.scene.physicsSimulation.rayCastAll(this.ray, this._outHitInfoArr, height + 5);
          let colliderNameArr = [
              'BodyCollider',
              'HeadCollider',
              'UpperLegCollider',
              'LowwerLegCollider',
              'UpperArmCollider',
              'LowwerArmCollider',
              'NavMesh'
          ];
          if (this._outHitInfoArr.length == 0) {
              Vector3Ex.ZERO.cloneTo(this._temVec);
          }
          else {
              let isExit = false;
              for (let i = 0, len = this._outHitInfoArr.length; i < len; i++) {
                  if (this._outHitInfoArr[i].collider.owner.name == 'NavMesh') {
                      isExit = true;
                  }
                  else if (colliderNameArr.indexOf(this._outHitInfoArr[i].collider.owner.name) == -1) {
                      Vector3Ex.ZERO.cloneTo(this._temVec);
                      break;
                  }
              }
              !isExit && Vector3Ex.ZERO.cloneTo(this._temVec);
          }
          if (Laya.Vector3.distance(Vector3Ex.ZERO, this._temVec) == 0) {
              let origin = this.ray.origin;
              let direction = this.ray.direction;
              this._parentTr.position.cloneTo(origin);
              this.ray.origin = origin;
              this.vec2.cloneTo(direction);
              this.ray.direction = direction;
              DataMgr.instance.scene.physicsSimulation.rayCast(this.ray, this.outHitInfo, 1, this._collisonGroup, this.collisionWith);
              if (this.outHitInfo.succeeded) {
                  Laya.Vector3.cross(this.vec2, this.outHitInfo.normal, this._temVec);
                  Laya.Vector3.cross(this._temVec, this.outHitInfo.normal, this._temVec);
                  this._temVec.cloneTo(direction);
                  this.ray.direction = direction;
                  DataMgr.instance.scene.physicsSimulation.rayCast(this.ray, this.outHitInfo, 1, this._collisonGroup, this.collisionWith);
                  if (this.outHitInfo.succeeded) {
                      Laya.Vector3.cross(this.vec2, this.outHitInfo.normal, this._temVec);
                      Laya.Vector3.cross(this._temVec, this.outHitInfo.normal, this._temVec);
                  }
                  Laya.Vector3.normalize(this._temVec, this._temVec);
                  Laya.Vector3.scale(this._temVec, -Math.abs(this._role.getMoveVal(maxZ * DataMgr.FixedDeltaTime * 1000)), this._temVec);
                  this._parentTr.translate(this._temVec, false);
              }
          }
          else {
              this._parentTr.translate(this._temVec, false);
          }
      }
      drawLine(isShow) {
          for (let i = 0, len = this.balls.length; i < len; i++) {
              let ball = this.balls[i];
              ball.active = false;
          }
          if (!isShow) {
              return;
          }
          let cameraCtrl = DataMgr.instance.cameraCtrl;
          this._viewPos.setValue(Laya.stage.width / 2, 0);
          this._viewPos.x = this._viewPos.x * Laya.stage.clientScaleX;
          this._viewPos.y = this._viewPos.y * Laya.stage.clientScaleY;
          cameraCtrl.camera.viewportPointToRay(this._viewPos, this._ray);
          let pos = this.sp.transform.position;
          this._role._gunNodeR.transform.position.cloneTo(pos);
          this.sp.transform.position = pos;
          this._ray.direction.cloneTo(this._dir);
          Laya.Vector3.scale(this._dir, CfgDataMgr.instance.bulletCfg[100002].bulletSpeed, this._dir);
          this._gravity.y = -CfgDataMgr.instance.bulletCfg[100002].bulletGravitationalSpeed;
          this._role._gunNodeR.transform.position.cloneTo(this.vec1);
          for (let i = 0; i < 10000; i++) {
              Laya.Vector3.add(this._dir, this._gravity, this._dir);
              Laya.Vector3.scale(this._dir, DataMgr.FixedDeltaTime, this.vec);
              Laya.Vector3.add(this.vec, this.vec1, this.vec1);
              this.sp.transform.lookAt(this.vec1, Vector3Ex.Up, false);
              this.sp.transform.position.cloneTo(this.vec2);
              this.sp.transform.translate(this.vec, false);
              this.sp.transform.position.cloneTo(this.vec1);
              if (i % 2 == 0) {
                  let index = i / 2;
                  let ball = this.balls[index];
                  let ballPos = ball.transform.position;
                  ball.active = true;
                  let scale = ball.transform.localScale;
                  scale.setValue(5, 5, 5);
                  ball.transform.localScale = scale;
                  this.vec2.cloneTo(ballPos);
                  ball.transform.position = ballPos;
                  if (this.vec2.y < DataMgr.instance.roleHeight) {
                      if (index - 2 > 0) {
                          let ball = this.balls[index - 2];
                          ball.active = true;
                          let scale = ball.transform.localScale;
                          scale.setValue(30, 30, 30);
                          ball.transform.localScale = scale;
                          ball.transform.localPositionY = DataMgr.instance.roleHeight;
                      }
                      return;
                  }
              }
          }
      }
  }

  var Vector2$1 = Laya.Vector2;
  class TankMoveCtrl extends BaseMoveCtrl {
      constructor() {
          super();
          this._viewPos = new Vector2$1();
          this._outHitInfoArr = [];
          this._lastRot = new Laya.Quaternion();
          this._nextRot = new Laya.Quaternion();
          this._lastBarrelRot = new Laya.Quaternion();
          this._nextBarrelRot = new Laya.Quaternion();
          this._isCamFollow = true;
      }
      onAwake() {
          super.onAwake();
      }
      onDestroy() {
          if (Utils.isEmpty(this._rayCheckArr))
              return;
          let len = this._rayCheckArr.length;
          for (let i = 0; i < len; i++) {
              let obj = this._rayCheckArr[i];
              obj.removeSelf();
              obj.destroy();
          }
          this.moveArr.length = 0;
          super.onDestroy();
      }
      onUpdate() {
          if (this._role == null || this._role.isDead || !this._role._skinCfg)
              return;
          if (this._rotateId != -1) {
              this._isCamFollow = false;
          }
          super.onUpdate();
          this._isCamFollow = true;
          if (this._rockerId != -1 &&
              (this.isNeedMoveRocker ? this.angle != -1 : true) &&
              DataMgr.instance.isRoleMove) {
              DataMgr.instance.tankSpeed = (Math.abs(this._curSpeed) * 1000) | 0;
          }
          else {
              DataMgr.instance.tankSpeed = 0;
              this._curSpeed = 0;
          }
      }
      init(id) {
          super.init(id);
          let self = this;
          this.isNeedMoveRocker = false;
          this._rotator = this._role._gunArr[1].rotatorModel;
          if (this._initViewLock) {
              this._rotator.transform.localRotationEulerY += 180;
          }
          this._barrel = ExUtils.findChild(this._rotator, 'Barrel');
          this.setTurretRotate(true);
          this._tankCfg = CfgDataMgr.instance.vehicleCfg[id];
          this._maxBackAngle = this._tankCfg.vehRotateInterval[0] + 360;
          this._minBackAngle = this._tankCfg.vehRotateInterval[1];
          this.limitH = this._tankCfg.crossHeight;
          DataMgr.instance.cameraCtrl.setTankVerticalLimit(this._tankCfg.vehGunVeerInterval_vertical[0], this._tankCfg.vehGunVeerInterval_vertical[1]);
          this._vehRotSpeed = this._tankCfg.vehTurrutFollowSpeed;
          let arr = ExUtils.getAllComponentsInChild(this._role.gameObject, Laya.PhysicsCollider);
          let len = arr.length;
          for (let i = 0; i < len; i++) {
              arr[i].collisionGroup = Laya.Physics3DUtils.COLLISIONFILTERGROUP_CUSTOMFILTER1;
          }
          let _tankBackM = this._tankCfg.checkPos[0];
          let _tankForwardM = this._tankCfg.checkPos[1];
          let _tankForwardL = this._tankCfg.checkPos[2];
          let _tankForwardR = this._tankCfg.checkPos[3];
          Laya.timer.frameOnce(2, this, function () {
              Utils.vec3ToTargetVal('localPosition', 1, self._role.gameObject);
              self._tankForwardLObj = new Laya.Sprite3D();
              self._parentTr.owner.addChild(self._tankForwardLObj);
              let pos = self._tankForwardLObj.transform.localPosition;
              pos.setValue(-_tankForwardL, 0, -_tankBackM);
              self._tankForwardLObj.transform.localPosition = pos;
              self._tankForwardLObj.name = 'ForwardL';
              self._tankForwardRObj = new Laya.Sprite3D();
              self._parentTr.owner.addChild(self._tankForwardRObj);
              pos = self._tankForwardRObj.transform.localPosition;
              pos.setValue(_tankForwardR, 0, -_tankBackM);
              self._tankForwardRObj.transform.localPosition = pos;
              self._tankForwardRObj.name = 'ForwardR';
              self._tankBackLObj = new Laya.Sprite3D();
              self._parentTr.owner.addChild(self._tankBackLObj);
              pos = self._tankBackLObj.transform.localPosition;
              pos.setValue(_tankForwardR, 0, _tankForwardM);
              self._tankBackLObj.transform.localPosition = pos;
              self._tankBackLObj.name = 'BackL';
              self._tankBackRObj = new Laya.Sprite3D();
              self._parentTr.owner.addChild(self._tankBackRObj);
              pos = self._tankBackRObj.transform.localPosition;
              pos.setValue(-_tankForwardL, 0, _tankForwardM);
              self._tankBackRObj.transform.localPosition = pos;
              self._tankBackRObj.name = 'BackL';
              self._rayCheckArr = [
                  self._tankForwardLObj,
                  self._tankForwardRObj,
                  self._tankBackLObj,
                  self._tankBackRObj
              ];
          });
      }
      onRotate() {
          if (this._role._isAim) {
              let x = this._barrel.transform.localRotationEulerX +
                  this._role.getRotateVal(this._attackRot.x * 10);
              x = MathUtils.Clamp(x, -12, 8.8);
              let y = this._rotator.transform.localRotationEulerY -
                  this._role.getRotateVal(this._attackRot.y * 100);
              this._barrel.transform.localRotationEulerX = x;
              this._rotator.transform.localRotationEulerY = y;
              this._attackRot.setValue(0, 0, 0);
          }
          else {
              DataMgr.instance.cameraCtrl.setTurretRotate(this._attackRot);
          }
      }
      amendRotate(deltaX, deltaY) {
          let self = this;
          let x = deltaY * this._tankCfg.vehGunVeerSpeed_vertical * DataMgr.FixedDeltaTime;
          let y = deltaX * this._tankCfg.vehGunVeerSpeed_horizontal * DataMgr.FixedDeltaTime;
          self._attackRot.setValue(x, y, 0);
      }
      setRoleMove() {
          if (DataMgr.instance.keyBoardW || DataMgr.instance.keyBoardS) {
          }
          let speedX = this._tankCfg.vehBodyVeerSpeed_horizontal * DataMgr.FixedDeltaTime;
          speedX = this.isLeft ? speedX : this.isRight ? -speedX : 0;
          if (this.isBack) {
              this._curSpeed += this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > this._tankCfg.vehBackwardSpeed
                      ? this._tankCfg.vehBackwardSpeed
                      : this._curSpeed;
          }
          else if (this.isForward) {
              this._curSpeed -= this._tankCfg.vehDeltSpeed;
              this._curSpeed =
                  this._curSpeed > -this._tankCfg.vehForwardSpeed
                      ? this._curSpeed
                      : -this._tankCfg.vehForwardSpeed;
              speedX = -speedX;
          }
          else if (!DataMgr.instance.isTestTank) {
              return;
          }
          speedX = this._role.getRotateVal(speedX);
          this._parentTr.localRotationEulerY += speedX;
          this._parentTr.getForward(this._vec);
          Laya.Vector3.scale(this._vec, this._role.getMoveVal(this._curSpeed * DataMgr.FixedDeltaTime * 1000), this._vec);
          this._parentTr.translate(this._vec, false);
          Vector3Ex.Down.cloneTo(this.ray.direction);
          let grou